(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    411813,      12434]*)
(*NotebookOutlinePosition[    440109,      13186]*)
(*  CellTagsIndexPosition[    435913,      13074]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["3", "ChapterLine",
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell["Derivatives", "Title",
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[TextData[{
  "The symmetry analysis of differential equations is based on several \
differential operators. Among these operators are the ordinary \
differentiation, the total differential, the Fr\[EAcute]chet derivative, the \
Euler-Lagrange derivative, and the prolongation, to name the main operators. \
The basis of the symmetry analysis is the prolongation of a differential \
equation. Unfortunately, the prolongation as a differential operator is not \
implemented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This chapter will discuss the different types of derivatives used in the \
calculus of symmetry analysis and will demonstrate their application by \
several examples. Another subject of the present chapter is the presentation \
of the theoretical background for the derivatives. One point we will discuss \
is the connection of the theory with the practical implementation of these \
operators in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Application of the defined operators to several examples will \
demonstrate their use. Throughout the text, we use subscripts to denote a \
differentiation. The subscripted representation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is created by the function ",
  StyleBox["LieTraditionalForm[]", "MmaText"],
  ". This ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " function converts the standard form of differentials in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to a traditional form frequently used in mathematics."
}], "Text",
  PageBreakBelow->False,
  CellTags->{
  "differential operators", "ordinary differentiation", "total differential", 
    "Frechet derivative", "Euler-Lagrange derivative", "prolongation", 
    "LieTraditionalForm[]", "traditional form"}],

Cell[CellGroupData[{

Cell["3.1 Ordinary and Partial Derivatives", "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 3}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>Identity},
  CellTags->"Ordinary and partial derivatives"],

Cell[TextData[{
  "Ordinary and partial derivatives are widely used in calculus. As a matter \
of fact, this kind of calculation is also applied in the symmetry analysis of \
differential equations. Gauss, Leibniz, and Newton introduced the notion of \
derivatives in the 17th",
  StyleBox[" ",
    FontSlant->"Italic"],
  "century in order to have a measure for the slope of a function. Still \
today, we continue to use derivatives to measure the slope of a function at a \
position ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The definition of a differential is one of the fruitful concepts mankind \
invented to describe nature in mathematical terms. Newton and Leibniz \
introduced the calculus of differentials to describe physical and \
mathematical relations by means of differential equations. The main \
ingredients of differential equations are derivatives combined in a linear or \
non-linear way. The definition of a derivative in terms of a limiting process \
is given by the following:"
}], "Text",
  Evaluatable->False,
  CellTags->{"calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}],

Cell["Definition: Ordinary derivative", "Definition",
  CellTags->"Definition: Ordinary derivative"],

Cell[TextData[{
  "Given a smooth function ",
  Cell[BoxData[
      \(TraditionalForm
      \`f : \ \[DoubleStruckCapitalR]\  \[Rule] \ 
        \[DoubleStruckCapitalR]\)]],
  ", the derivative of\[ThinSpace] ",
  StyleBox["f\[ThinSpace] ",
    FontSlant->"Italic"],
  "is defined by the relation"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            StyleBox[\(df\/dx\),
              FontSlant->"Italic"], " ", ":=", " ", 
            \(lim\+\(h \[Rule] 0\)\ \(f(x + h)\  - f(x)\)\/h\)}],
          "TraditionalForm"], ".", "\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
        "\[EmptyCircle]"}], TextForm]], "NumberedEquation",
  TextJustification->1],

Cell[TextData[{
  "This definition is the mathematical expression of how to manage the \
calculation of the slope for a known function",
  StyleBox[" f.",
    FontSlant->"Italic"],
  " The meaning of this formula is that we have to take two neighboring \
points separated by a distance ",
  StyleBox["h",
    FontSlant->"Italic"],
  " in the ",
  StyleBox["x",
    FontSlant->"Italic"],
  " domain and calculate the ratio of the difference of the function at these \
points. If we assume that the distance ",
  StyleBox["h",
    FontSlant->"Italic"],
  " becomes smaller and smaller, we end up with a value describing the slope \
of the function at the point ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". Here we used the representation of the derivative in mathematical terms. \
The definition of the derivative given in (3.1) is not only a symbolic \
formula but also of practical relevance. In ",
  StyleBox["Mathematica, ",
    FontSlant->"Italic"],
  "we can demonstrate the practical use by just applying relation (3.1) to a \
specific function. Let us assume that the function",
  StyleBox[" f",
    FontSlant->"Italic"],
  " is given by the trigonometric function"
}], "Text",
  Evaluatable->False,
  CellTags->"trigonometric function"],

Cell[BoxData[
    \(f[x_] := Sin[x]\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "Formula (3.1) in terms of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  reads"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Df = Limit[\(f[x + h] - f[x]\)\/h, h \[Rule] 0]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(Cos[x]\)], "Output"]
}, Open  ]],

Cell["\<\
which provides us with the expected result. We certainly know that \
the derivative of the sin is given by a cos. The result can be checked by a \
symbolic calculation using the differentiation\
\>", "Text",
  Evaluatable->False,
  CellTags->"symbolic calculation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x f[x]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(Cos[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which gives the same result. We realize that ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "provides the same result by different algorithmic procedures. However, the \
standard way of calculating derivatives of functions ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  " is the application of the operator ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_x\)], "MmaText"],
  " to ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  ". The pattern ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_x f[x]\)]],
  " or ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(D[F[x], x]\),
          "MmaText"], TraditionalForm]]],
  " serves to calculate all the ordinary differentials of a function ",
  StyleBox["f", "",
    FontSlant->"Italic"],
  " with one independent variable. "
}], "Text",
  Evaluatable->False,
  CellTags->{"ordinary differential", "independent variable"}],

Cell[TextData[{
  "Another way of looking on relation (3.1) in the definition above is based \
on a geometrical interpretation. Rewriting the original formula (3.1) helps \
us to understand the geometrical contents. Let us first replace the limit in \
equation (3.1) by another representation. The derivative defined on the \
left-hand side of equation (3.1) can be represented by introducing a \
condition on the right-hand side. Dropping for the moment the ",
  StyleBox["Limit[]", "MmaText"],
  " and introducing a reference point ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " on the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis, we are able to rewrite the right-hand side. We assume that ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " is a distance ",
  StyleBox["h",
    FontSlant->"Italic"],
  " away from",
  StyleBox[" ",
    FontSlant->"Italic"],
  "our point of interest",
  StyleBox[" x",
    FontSlant->"Italic"],
  ". The resulting value on the right-hand side of (3.1) is an approximation \
of the derivative at the point ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we write"
}], "Text",
  Evaluatable->False,
  CellTags->{"geometrical interpretation", "Limit[]"}],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  PageWidth->Infinity],

Cell[CellGroupData[{

Cell[BoxData[
    \(Df = \(f[x + h] - f[x]\)\/h /. h \[Rule] x0 - x\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\(\(-f[x]\) + f[x0]\)\/\(\(-x\) + x0\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The left-hand side in equation (3.1) can be represented by the \
differential operator ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[PartialD]\_x\),
          "MmaText"], TraditionalForm]]],
  StyleBox[".",
    FontSlant->"Italic"],
  " The calculation is carried out at the location ",
  Cell[BoxData[
      \(TraditionalForm\`x = x\_0\)]],
  ". This representation of the derivative gives us"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dlf = \[PartialD]\_x f[x] /. x \[Rule] x0\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x0", "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Combining the two expressions, we get an approximate representation of a \
derivative for the function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at the location ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(df = Dlf == Df\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "x0", "]"}], "==", 
      \(\(\(-f[x]\) + f[x0]\)\/\(\(-x\) + x0\)\)}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The geometrical way of reading this equation is to consider ",
  StyleBox["df",
    FontSlant->"Italic"],
  " as a parametric definition of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f[x]\)], "MmaText"],
  ". The parameter ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " denotes a specific location in the domain of the independent variables. \
An explicit representation of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  " follows from ",
  Cell[BoxData[
      \(TraditionalForm\`d\[NegativeVeryThinSpace]f\)], "MmaText"],
  " by solving it with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`f[x]\)], "MmaText"],
  ":"
}], "Text",
  ShowCellBracket->True,
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = Solve[df, f[x]] /. f[x] \[Rule] w\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"w", "\[Rule]", 
          RowBox[{\(f[x0]\), "+", 
            RowBox[{"x", " ", 
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x0", "]"}]}], "-", 
            RowBox[{"x0", " ", 
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x0", "]"}]}]}]}], "}"}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["The replacement of ",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]],
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox[" by an auxiliary variable ",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["w",
    FontSlant->"Italic"],
  StyleBox[" is necessary to define the function ",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]],
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox[" in a pure function as",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Text",
  Evaluatable->False,
  CellTags->"pure function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fun = f \[Rule] Function[{x, x0}, w] /. Flatten[sol1]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"f", "\[Rule]", 
      RowBox[{"Function", "[", 
        RowBox[{\({x, x0}\), ",", 
          RowBox[{\(f[x0]\), "+", 
            RowBox[{"x", " ", 
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x0", "]"}]}], "-", 
            RowBox[{"x0", " ", 
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x0", "]"}]}]}]}], "]"}]}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a representation of the function ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  " defined at any location ",
  StyleBox["x",
    FontSlant->"Italic"],
  " knowing at the same time the same function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at a point ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ". In addition, we also have to know the derivative of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "at this location. The relation appears somewhat strange at the first look. \
However, the geometrical content of this expression is easy to understand if \
we represent it graphically. To perceive the implications of the relation, \
let us examine a plot of ",
  StyleBox["f.",
    FontSlant->"Italic"],
  " Being specific in the plotting, we set the function \[NoBreak]",
  StyleBox["f",
    FontSlant->"Italic"],
  " to the trigonometric function sin"
}], "Text",
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->"trigonometric function"],

Cell[BoxData[
    \(f[x_] := Sin[x]\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "In another step, we define a function ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(g[x, x\_0]\),
          "MmaText"], TraditionalForm]]],
  ", combining our results for ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x, x\_0]\),
          "MmaText"], TraditionalForm]]],
  ". The new function ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(g[x, x\_0]\),
          "MmaText"], TraditionalForm]]],
  " allows us to represent ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at any points ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ":"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Clear[g]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(g[x_, x0_] := f[x, x0] /. fun\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "If we plot both functions ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(g[x, x\_0]\),
          "MmaText"], TraditionalForm]]],
  " in a common coordinate frame, we get the following picture:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[\n\tEvaluate[{f[x], g[x, 1]}], {x, 0, \[Pi]\/2}, \n\t
      AxesLabel \[Rule] {"\<x\>", "\<f,g\>"}, \n\t
      PlotStyle \[Rule] {RGBColor[1, 0, 0], \n\t\t\tRGBColor[0, 0, 1]}]\)], 
  "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.606305 0.0147151 0.511886 [
[.17539 .00222 -12 -9 ]
[.17539 .00222 12 0 ]
[.32696 .00222 -9 -9 ]
[.32696 .00222 9 0 ]
[.47854 .00222 -12 -9 ]
[.47854 .00222 12 0 ]
[.63011 .00222 -3 -9 ]
[.63011 .00222 3 0 ]
[.78169 .00222 -12 -9 ]
[.78169 .00222 12 0 ]
[.93327 .00222 -9 -9 ]
[.93327 .00222 9 0 ]
[1.025 .01472 0 -9.5 ]
[1.025 .01472 12 9.5 ]
[.01131 .11709 -18 -4.5 ]
[.01131 .11709 0 4.5 ]
[.01131 .21947 -18 -4.5 ]
[.01131 .21947 0 4.5 ]
[.01131 .32185 -18 -4.5 ]
[.01131 .32185 0 4.5 ]
[.01131 .42422 -18 -4.5 ]
[.01131 .42422 0 4.5 ]
[.01131 .5266 -6 -4.5 ]
[.01131 .5266 0 4.5 ]
[.02381 .64303 -14 0 ]
[.02381 .64303 14 19 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.17539 .01472 m
.17539 .02097 L
s
[(0.25)] .17539 .00222 0 1 Mshowa
.32696 .01472 m
.32696 .02097 L
s
[(0.5)] .32696 .00222 0 1 Mshowa
.47854 .01472 m
.47854 .02097 L
s
[(0.75)] .47854 .00222 0 1 Mshowa
.63011 .01472 m
.63011 .02097 L
s
[(1)] .63011 .00222 0 1 Mshowa
.78169 .01472 m
.78169 .02097 L
s
[(1.25)] .78169 .00222 0 1 Mshowa
.93327 .01472 m
.93327 .02097 L
s
[(1.5)] .93327 .00222 0 1 Mshowa
.125 Mabswid
.05412 .01472 m
.05412 .01847 L
s
.08444 .01472 m
.08444 .01847 L
s
.11476 .01472 m
.11476 .01847 L
s
.14507 .01472 m
.14507 .01847 L
s
.2057 .01472 m
.2057 .01847 L
s
.23602 .01472 m
.23602 .01847 L
s
.26633 .01472 m
.26633 .01847 L
s
.29665 .01472 m
.29665 .01847 L
s
.35728 .01472 m
.35728 .01847 L
s
.38759 .01472 m
.38759 .01847 L
s
.41791 .01472 m
.41791 .01847 L
s
.44822 .01472 m
.44822 .01847 L
s
.50885 .01472 m
.50885 .01847 L
s
.53917 .01472 m
.53917 .01847 L
s
.56948 .01472 m
.56948 .01847 L
s
.5998 .01472 m
.5998 .01847 L
s
.66043 .01472 m
.66043 .01847 L
s
.69074 .01472 m
.69074 .01847 L
s
.72106 .01472 m
.72106 .01847 L
s
.75138 .01472 m
.75138 .01847 L
s
.81201 .01472 m
.81201 .01847 L
s
.84232 .01472 m
.84232 .01847 L
s
.87264 .01472 m
.87264 .01847 L
s
.90295 .01472 m
.90295 .01847 L
s
.96358 .01472 m
.96358 .01847 L
s
.9939 .01472 m
.9939 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.02381 .11709 m
.03006 .11709 L
s
[(0.2)] .01131 .11709 1 0 Mshowa
.02381 .21947 m
.03006 .21947 L
s
[(0.4)] .01131 .21947 1 0 Mshowa
.02381 .32185 m
.03006 .32185 L
s
[(0.6)] .01131 .32185 1 0 Mshowa
.02381 .42422 m
.03006 .42422 L
s
[(0.8)] .01131 .42422 1 0 Mshowa
.02381 .5266 m
.03006 .5266 L
s
[(1)] .01131 .5266 1 0 Mshowa
.125 Mabswid
.02381 .04031 m
.02756 .04031 L
s
.02381 .0659 m
.02756 .0659 L
s
.02381 .0915 m
.02756 .0915 L
s
.02381 .14269 m
.02756 .14269 L
s
.02381 .16828 m
.02756 .16828 L
s
.02381 .19388 m
.02756 .19388 L
s
.02381 .24506 m
.02756 .24506 L
s
.02381 .27066 m
.02756 .27066 L
s
.02381 .29625 m
.02756 .29625 L
s
.02381 .34744 m
.02756 .34744 L
s
.02381 .37304 m
.02756 .37304 L
s
.02381 .39863 m
.02756 .39863 L
s
.02381 .44982 m
.02756 .44982 L
s
.02381 .47541 m
.02756 .47541 L
s
.02381 .50101 m
.02756 .50101 L
s
.02381 .5522 m
.02756 .5522 L
s
.02381 .57779 m
.02756 .57779 L
s
.02381 .60338 m
.02756 .60338 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(f) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(,) show
79.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
87.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.06244 .04731 L
.10458 .08271 L
.14415 .11565 L
.18221 .14693 L
.22272 .17965 L
.26171 .21045 L
.30316 .2423 L
.34309 .27198 L
.3815 .29949 L
.42237 .32749 L
.46172 .35311 L
.49955 .37641 L
.53984 .39966 L
.57861 .42043 L
.61984 .4407 L
.65954 .45836 L
.69774 .47356 L
.73838 .48773 L
.77751 .49936 L
.81909 .50951 L
.85916 .51709 L
.87754 .51984 L
.89771 .52232 L
.91765 .52422 L
.92854 .52502 L
.93871 .52562 L
.94354 .52586 L
.94878 .52608 L
.95341 .52624 L
.95832 .52638 L
.96273 .52647 L
.96524 .52652 L
.9676 .52655 L
.96976 .52657 L
.97173 .52659 L
.97277 .52659 L
.97391 .5266 L
.97509 .5266 L
.97619 .5266 L
s
0 0 1 r
.02381 .16888 m
.06244 .1865 L
.10458 .20572 L
.14415 .22377 L
.18221 .24113 L
.22272 .25961 L
.26171 .2774 L
.30316 .29631 L
.34309 .31452 L
.3815 .33204 L
.42237 .35069 L
.46172 .36864 L
.49955 .38589 L
.53984 .40427 L
.57861 .42196 L
.61984 .44076 L
.65954 .45888 L
.69774 .4763 L
.73838 .49484 L
.77751 .51269 L
.81909 .53166 L
.85916 .54993 L
.89771 .56752 L
.93871 .58622 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{246, 151.875},
  ImageMargins->{{Inherited, 0}, {0, 1.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004c0000_A000`40O003h00O?7oo10001Goo0P00
17oo1@0017oo10003Goo10001Goo0P001Goo100037oo10001Goo0P001goo00<007ooOol00goo1000
57oo1@0057oo1@0017oo0P0017oo1@0017oo100037oo1@0017oo0P001Goo1000:Goo000kOol00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007oo
Ool02Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol027oo
00<007ooOol00Woo00<007ooOol00Woo0P001goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool04goo00<007ooOol05Woo00<007ooOol017oo0P0017oo00D007ooOomoo`0000=oo`03001oogoo
009oo`03001oogoo00]oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo02Ioo`00
>goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol027oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol0
1goo00<007ooOol04goo00<007ooOol05Woo00<007ooOol02goo00<007ooOol02Goo00<007ooOol0
2goo00<007ooOol03goo00<007ooOol09Woo000kOol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`08Ool00`00
Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`0COol00`00Oomoo`0FOol00`00
Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`0?Ool00`00Oomoo`0VOol003]o
o`03001oogoo009oo`03001oogoo00]oo`03001oogoo00=oo`@000aoo`03001oogoo009oo`03001o
ogoo00Uoo`@000]oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo009oo`@001Ioo`03001o
ogoo01Ioo`03001oogoo00eoo`03001oogoo00=oo`@000ioo`03001oogoo00]oo`@002Uoo`00>goo
00<007ooOol00Woo00<007ooOol037oo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol02Goo00<007ooOol037oo00<007ooOol00Woo00<007ooOol03Goo00D007ooOomoo`00
01Uoo`03001oogoo01Ioo`03001oogoo00ioo`03001oogoo009oo`03001oogoo00moo`03001oogoo
00]oo`03001oogoo02Yoo`00>goo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ao
o`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00aoo`03001oogoo009o
o`03001oogoo00Qoo`03001oogoo009oo`05001oogooOol0000GOol3000FOol3000<Ool01@00Oomo
ogoo000017oo00<007ooOol03Goo0`003Goo00<007ooOol0:Woo000lOol4000<Ool30005Ool5000<
Ool4000<Ool5000;Ool4000;Ool60003Ool5000EOol00`00Oomoo`0FOol00`00Oomoo`0;Ool30005
Ool5000=Ool00`00Oomoo`0;Ool5000XOol00?moocAoo`00ogoo=7oo000VOol00`00Oomoo`3aOol2
0002Ool2000COol002Ioo`03001oogoo0?9oo`04001oogoo000DOol002Ioo`03001oogoo0?=oo`80
01Eoo`009Woo00<007ooOol0lgoo0P005Goo000POol600000g`00000003X000:Ool01000Oomoo`00
57oo000VOol00`00O01oo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`08Ool20002Ool2000COol002Io
o`03001oog`00?moo`]oo`009Woo00@007ooOoml0?moo`Yoo`009Woo00@007ooOomoo`9l0?moo`Qo
o`009Woo00<007ooOol00goo00=l07ooOol0ogoo1Goo000VOol20005Ool00g`0Oomoo`3oOol4Ool0
02Ioo`03001oogoo00Eoo`03O01oogoo0?moo`=oo`009Woo00<007ooOol01Woo00=l07ooOol0ogoo
0Woo000VOol00`00Oomoo`07Ool00g`0Oomoo`3oOol1Ool002Ioo`03001oogoo00Qoo`9l0?moo`5o
o`009Woo00<007ooOol02Woo00=l07ooOol0oGoo000VOol2000<Ool00g`0Oomoo`3lOol002Ioo`03
001oogoo00aoo`03O01oogoo0?]oo`009Woo00<007ooOol03Goo0W`0ngoo000VOol00`00Oomoo`0?
Ool00g`0Oomoo`3hOol002Ioo`03001oogoo011oo`03O01oogoo0?Moo`009Woo00<007ooOol04Goo
00=l07ooOol0mWoo000VOol2000COol2O03fOol002Ioo`03001oogoo01Aoo`03O01oogoo0?=oo`00
9Woo00<007ooOol05Goo00=l07ooOol0lWoo000VOol00`00Oomoo`0FOol00g`0Oomoo`3aOol000eo
o`@000Eoo`8000Aoo`D000Eoo`03001oogoo01Moo`9l0?5oo`0037oo00<007ooOol00Woo00<007oo
Ool00Woo0P0017oo00D007ooOomoo`0000Eoo`03001oogoo01Uoo`03O01oogoo0>ioo`0037oo00<0
07ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol06Woo00=l07ooOol0kGoo000<
Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool2000LOol00g`0Oomoo`3/Ool000ao
o`03001oogoo009oo`03001oogoo00]oo`03001oogoo00Aoo`03001oogoo01aoo`03O01oogoo0>]o
o`0037oo00<007ooOol00Woo00<007ooOol037oo00<007ooOol00goo00<007ooOol07Goo00=l07oo
Ool0jWoo000<Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Goo00<007ooOol0
7Woo0W`0jWoo000=Ool4000<Ool30006Ool00`00Oomoo`0POol00g`0Oomoo`3WOol002Ioo`03001o
ogoo025oo`03O01oogoo0>Ioo`009Woo0P008goo00=l07ooOol0iGoo000VOol00`00Oomoo`0SOol0
0g`0Oomoo`3TOol002Ioo`03001oogoo02Aoo`03O01oogoo0>=oo`009Woo00<007ooOol09Goo0W`0
hgoo000VOol00`00Oomoo`0WOol00g`0Oomoo`3POol002Ioo`03001oogoo02Qoo`03O01oogoo0=mo
o`009Woo0P0O:Woo00=l07ooOol0gWoo000VOol01000Ool07`0O:Goo0W`0gWoo000VOol01000Oomo
ogoo0P0O:Goo00=l07ooOol0fgoo000VOol00`00Oomoo`03Ool201lXOol00g`0Oomoo`3JOol002Io
o`03001oogoo00Eoo`807bMoo`03O01oogoo0=Uoo`009Woo00<007ooOol01goo0P0O9Woo0W`0fGoo
000VOol2000:Ool201lVOol00g`0Oomoo`3FOol002Ioo`03001oogoo00]oo`807bEoo`03O01oogoo
0=Eoo`009Woo00<007ooOol03Goo0P0O97oo0W`0eGoo000=Ool40005Ool20007Ool30004Ool00`00
Oomoo`0?Ool301lSOol00g`0Oomoo`3BOol000aoo`03001oogoo009oo`03001oogoo009oo`8000Qo
o`03001oogoo00=oo`03001oogoo019oo`807b9oo`03O01oogoo0=5oo`0037oo00<007ooOol00Woo
00<007ooOol037oo00<007ooOol00goo00<007ooOol057oo0`0O87oo00=l07ooOol0d7oo000<Ool0
0`00Oomoo`02Ool00`00Oomoo`08Ool60004Ool2000HOol201lOOol2O03@Ool000aoo`03001oogoo
009oo`03001oogoo00Uoo`04001oogoo0005Ool00`00Oomoo`0IOol301lNOol00g`0Oomoo`3=Ool0
00aoo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0005Ool00`00Oomoo`0LOol201lMOol0
0g`0Oomoo`3<Ool000aoo`03001oogoo009oo`03001oogoo00Yoo`03001oo`0000Eoo`03001oogoo
01ioo`807aaoo`03O01oogoo0<]oo`003Goo10003Woo0P001Goo00<007ooOol087oo0P0O6goo0W`0
bgoo000VOol00`00Oomoo`0ROol201lKOol00g`0Oomoo`38Ool002Ioo`8002Eoo`807aYoo`03O01o
ogoo0<Moo`009Woo00<007ooOol09Woo0P0O6Goo00=l07ooOol0aWoo000VOol00`00Oomoo`0XOol2
01lHOol2O036Ool002Ioo`03001oogoo02Yoo`807aQoo`03O01oogoo0<=oo`009Woo00<007ooOol0
;7oo0`0O5Woo00=l07ooOol0`Woo000VOol00`00Oomoo`0_Ool201lEOol2O032Ool002Ioo`80039o
o`807aEoo`03O01oogoo0;moo`009Woo00<007ooOol0<goo0P0O57oo00=l07ooOol0_Woo000VOol0
0`00Oomoo`0eOol201lCOol2O02nOol002Ioo`03001oogoo03Moo`807a=oo`9l0;aoo`009Woo00<0
07ooOol0>Goo0P0O4goo00=l07ooOol0^Goo000VOol00`00Oomoo`0kOol201lBOol2O02iOol002Io
o`03001oogoo03eoo`807a9oo`9l0;Moo`009Woo0P00@7oo0`0O4Goo00=l07ooOol0]7oo000VOol0
0`00Oomoo`12Ool201l@Ool2O02dOol002Ioo`03001oogoo04Aoo`807a1oo`03O01oogoo0;5oo`00
3Goo10001Goo0P001Woo0`001Goo00<007ooOol0AWoo0P0O3goo00=l07ooOol0/7oo000<Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20005Ool01@00Oomoogoo000017oo00<007ooOol0B7oo0`0O3Goo
0W`0/7oo000<Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01@00Oomoogoo000017oo00<007ooOol0
Bgoo0P0O3Goo00=l07ooOol0[Goo000<Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01@00Oomoogoo
000017oo0P00CWoo0`0O2goo0W`0[Goo000<Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`1@Ool201l;Ool00g`0Oomoo`2ZOol000aoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Ioo`03001oogoo059oo`807`Yoo`9l0:Yoo`0037oo00<007ooOol00Woo00<007ooOol0
2Woo00<007ooOol01Goo00<007ooOol0E7oo0P0O2Woo00=l07ooOol0Ygoo000=Ool4000>Ool30004
Ool00`00Oomoo`1FOol201l9Ool2O02WOol002Ioo`03001oogoo05Qoo`807`Uoo`03O01oogoo0:Ao
o`009Woo0P00Fgoo0P0O27oo0W`0Y7oo000VOol00`00Oomoo`1LOol301l7Ool00g`0Oomoo`2QOol0
02Ioo`03001oogoo05moo`807`Ioo`9l0:5oo`009Woo00<007ooOol0HGoo0P0O1Woo00=l07ooOol0
WWoo000VOol00`00Oomoo`1SOol201l5Ool2O02NOol002Ioo`03001oogoo06Eoo`<07`Aoo`03O01o
ogoo09]oo`009Woo0P00JGoo0P0O0goo0W`0Vgoo000VOol00`00Oomoo`1ZOol201l3Ool00g`0Oomo
o`2HOol002Ioo`03001oogoo06aoo`807`9oo`9l09Qoo`009Woo00<007ooOol0KWoo0`0O00=oog`0
O000UWoo000VOol00`00Oomoo`1aOol201l00gooO01l002DOol002Ioo`03001oogoo07=oo`<07`9l
099oo`009Woo0P00Mgoo0P0O0W`0T7oo000VOol00`00Oomoo`1hOol201l2O02>Ool002Ioo`03001o
ogoo07Yoo`807`9l08aoo`003Goo10001Goo0P001Goo10001Goo00<007ooOol0O7oo0P0O0W`0RWoo
000<Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`1nOol201l2O028Ool000aoo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009o
o`03001oogoo009oo`03001oogoo081oo`807`03O01oogoo08Eoo`0037oo00<007ooOol00Woo00<0
07ooOol027oo00<007ooOol00Woo00<007ooOol00Woo0P00Pgoo0P0O00=l07ooOol0Pgoo000<Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`24Ool201l00g`0Oomoo`21Ool000ao
o`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08Io
o`<07h5oo`0037oo00<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<007ooOol00Woo
00<007ooOol0RGoo0P0OOgoo000=Ool4000<Ool40005Ool00`00Oomoo`2;Ool201l00g`0Oomoo`1j
Ool002Ioo`03001oogoo08eoo`807`03O01oogoo07Qoo`009Woo0P00T7oo0P0O00=l07ooOol0MWoo
000VOol00`00Oomoo`2AOol201l00g`0Oomoo`1dOol002Ioo`03001oogoo09=oo`807`9l07=oo`00
9Woo00<007ooOol0UGoo0P0O0W`0LGoo000VOol00`00Oomoo`2GOol201l3O01^Ool002Ioo`03001o
ogoo09Uoo`<07`9l06aoo`009Woo00<007ooOol0W7oo0P0O0g`0JGoo000VOol2002OOol301l3O01V
Ool002Ioo`03001oogoo0:5oo`807`04Ooml07`0O01SOol002Ioo`03001oogoo0:=oo`807`9oo`=l
061oo`009Woo00<007ooOol0YGoo0P0O0goo0g`0GGoo000VOol00`00Oomoo`2WOol301l3Ool4O01I
Ool002Ioo`03001oogoo0:Yoo`807`Eoo`=l05Ioo`009Woo0P00[Goo0`0O1Goo0g`0Dgoo000VOol0
0`00Oomoo`2_Ool201l6Ool4O01?Ool002Ioo`03001oogoo0;5oo`807`Qoo`Al04]oo`007Goo1@00
17oo00<007ooOol0/goo0P0O2Woo17`0Agoo000OOol00`00Oomoo`04Ool00`00Oomoo`2eOol201l<
Ool:O00mOol001moo`03001oogoo00Aoo`03001oogoo0;Moo`807aAoo`Yl03=oo`007goo00<007oo
Ool017oo0P00^Woo0P0O77oo2g`0:7oo000OOol00`00Oomoo`04Ool00`00Oomoo`2kOol301m<Ool0
01moo`03001oogoo00Aoo`03001oogoo0;ioo`807dYoo`007Goo0`001Woo00<007ooOol0`7oo0P0O
B7oo000OOol00`00Oomoo`04Ool00`00Oomoo`32Ool201m6Ool002Ioo`03001oogoo0<Aoo`807dAo
o`009Woo0P00agoo0P0O@Woo000VOol00`00Oomoo`38Ool201m0Ool002Ioo`03001oogoo0<Yoo`80
7cioo`009Woo00<007ooOol0c7oo0P0O?7oo000VOol00`00Oomoo`3>Ool301liOol002Ioo`03001o
ogoo0=5oo`807cMoo`009Woo0P00e7oo0P0O=Goo000VOol00`00Oomoo`3EOol201lcOol002Ioo`03
001oogoo0=Moo`<07c1oo`009Woo00<007ooOol0fWoo0P0O;Woo000VOol00`00Oomoo`3LOol201l/
Ool002Ioo`03001oogoo0=ioo`807bYoo`009Woo0P00hGoo0P0O:7oo000VOol00`00Oomoo`3oOol;
Ool002Ioo`03001oogoo0?moo`]oo`009Woo00<007ooOol0ogoo2goo000VOol00`00Oomoo`3oOol;
Ool00?moocAoo`00ogoo=7oo003oOoldOol00?moocAoo`00ogoo=7oo003oOoldOol00?moocAoo`00
ogoo=7oo003oOoldOol00?moocAoo`00ogoo=7oo000SOol00`00Oomoo`07Ool4003oOol3Ool002=o
o`8000aoo`03001oogoo0?moo`0067oo1P001Woo00<007ooOol01Woo0`0000=oo`00Ool0ogoo0Goo
000JOol00`00Oomoo`07Ool20006Ool01000Oomoogoo0P00ogoo0Woo000JOol00`00Oomoo`0?Ool0
0`00Oomoo`02Ool00`00Oomoo`3oOol001Yoo`03001oogoo00moo`03001oogoo009oo`03001oogoo
0?moo`006Woo00<007ooOol03goo00@007ooOomoo`800?moo`9oo`0067oo1P003goo0`0000=oo`00
0000ogoo0Goo000JOol00`00Oomoo`3oOolGOol001]oo`<00?mooaIoo`00ogoo=7oo003oOoldOol0
0?moocAoo`00ogoo=7oo003oOoldOol00?moocAoo`00ogoo=7oo003oOoldOol00001\
\>"],
  ImageRangeCache->{{{0, 306.5}, {188.813, 0}} -> {-0.263482, -0.115979, \
0.00858936, 0.0101737}}]
}, Open  ]],

Cell[TextData[{
  "From the above figure, we clearly see the geometrical meaning of ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "and ",
  StyleBox["f. ",
    FontSlant->"Italic"],
  "In fact, ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "is the representation of the tangent of the function ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "at a certain location ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ". In the figure above, we chose ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0 = 1\)]],
  ". The figure allows us to interpret the derivative of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " as a slope. The relation derived in ",
  StyleBox["df",
    FontSlant->"Italic"],
  " clearly displays a linear dependence in the independent variable",
  StyleBox[" x",
    FontSlant->"Italic"],
  ". Examining the slopes of the function",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  " at other points ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ", we get a set of tangents. A graphical representation of this set is \
given below. This sort of plot represents an envelope of the function ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  StyleBox[". ",
    FontSlant->"Italic"],
  " The following lines of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are necessary to create the envelope of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->{"tangent", "envelope"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[\n\t\tTable[g[x, x0], {x0, 0, \[Pi]\/2, \[Pi]\/20}]], \n
      \t{x, 0, \[Pi]\/2}, AxesLabel \[Rule] {"\<x\>", "\<g\>"}, \n\t
      PlotStyle \[Rule] 
        Table[RGBColor[1, 0, 0], \n\t\t\t{x0, 0, \[Pi]\/2, \[Pi]\/20}]]\)], 
  "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.606305 0.0147151 0.374717 [
[.17539 .00222 -12 -9 ]
[.17539 .00222 12 0 ]
[.32696 .00222 -9 -9 ]
[.32696 .00222 9 0 ]
[.47854 .00222 -12 -9 ]
[.47854 .00222 12 0 ]
[.63011 .00222 -3 -9 ]
[.63011 .00222 3 0 ]
[.78169 .00222 -12 -9 ]
[.78169 .00222 12 0 ]
[.93327 .00222 -9 -9 ]
[.93327 .00222 9 0 ]
[1.025 .01472 0 -9.5 ]
[1.025 .01472 12 9.5 ]
[.01131 .10839 -24 -4.5 ]
[.01131 .10839 0 4.5 ]
[.01131 .20207 -18 -4.5 ]
[.01131 .20207 0 4.5 ]
[.01131 .29575 -24 -4.5 ]
[.01131 .29575 0 4.5 ]
[.01131 .38943 -6 -4.5 ]
[.01131 .38943 0 4.5 ]
[.01131 .48311 -24 -4.5 ]
[.01131 .48311 0 4.5 ]
[.01131 .57679 -18 -4.5 ]
[.01131 .57679 0 4.5 ]
[.02381 .64303 -6 0 ]
[.02381 .64303 6 19 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.17539 .01472 m
.17539 .02097 L
s
[(0.25)] .17539 .00222 0 1 Mshowa
.32696 .01472 m
.32696 .02097 L
s
[(0.5)] .32696 .00222 0 1 Mshowa
.47854 .01472 m
.47854 .02097 L
s
[(0.75)] .47854 .00222 0 1 Mshowa
.63011 .01472 m
.63011 .02097 L
s
[(1)] .63011 .00222 0 1 Mshowa
.78169 .01472 m
.78169 .02097 L
s
[(1.25)] .78169 .00222 0 1 Mshowa
.93327 .01472 m
.93327 .02097 L
s
[(1.5)] .93327 .00222 0 1 Mshowa
.125 Mabswid
.05412 .01472 m
.05412 .01847 L
s
.08444 .01472 m
.08444 .01847 L
s
.11476 .01472 m
.11476 .01847 L
s
.14507 .01472 m
.14507 .01847 L
s
.2057 .01472 m
.2057 .01847 L
s
.23602 .01472 m
.23602 .01847 L
s
.26633 .01472 m
.26633 .01847 L
s
.29665 .01472 m
.29665 .01847 L
s
.35728 .01472 m
.35728 .01847 L
s
.38759 .01472 m
.38759 .01847 L
s
.41791 .01472 m
.41791 .01847 L
s
.44822 .01472 m
.44822 .01847 L
s
.50885 .01472 m
.50885 .01847 L
s
.53917 .01472 m
.53917 .01847 L
s
.56948 .01472 m
.56948 .01847 L
s
.5998 .01472 m
.5998 .01847 L
s
.66043 .01472 m
.66043 .01847 L
s
.69074 .01472 m
.69074 .01847 L
s
.72106 .01472 m
.72106 .01847 L
s
.75138 .01472 m
.75138 .01847 L
s
.81201 .01472 m
.81201 .01847 L
s
.84232 .01472 m
.84232 .01847 L
s
.87264 .01472 m
.87264 .01847 L
s
.90295 .01472 m
.90295 .01847 L
s
.96358 .01472 m
.96358 .01847 L
s
.9939 .01472 m
.9939 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.02381 .10839 m
.03006 .10839 L
s
[(0.25)] .01131 .10839 1 0 Mshowa
.02381 .20207 m
.03006 .20207 L
s
[(0.5)] .01131 .20207 1 0 Mshowa
.02381 .29575 m
.03006 .29575 L
s
[(0.75)] .01131 .29575 1 0 Mshowa
.02381 .38943 m
.03006 .38943 L
s
[(1)] .01131 .38943 1 0 Mshowa
.02381 .48311 m
.03006 .48311 L
s
[(1.25)] .01131 .48311 1 0 Mshowa
.02381 .57679 m
.03006 .57679 L
s
[(1.5)] .01131 .57679 1 0 Mshowa
.125 Mabswid
.02381 .03345 m
.02756 .03345 L
s
.02381 .05219 m
.02756 .05219 L
s
.02381 .07092 m
.02756 .07092 L
s
.02381 .08966 m
.02756 .08966 L
s
.02381 .12713 m
.02756 .12713 L
s
.02381 .14587 m
.02756 .14587 L
s
.02381 .1646 m
.02756 .1646 L
s
.02381 .18334 m
.02756 .18334 L
s
.02381 .22081 m
.02756 .22081 L
s
.02381 .23955 m
.02756 .23955 L
s
.02381 .25828 m
.02756 .25828 L
s
.02381 .27702 m
.02756 .27702 L
s
.02381 .31449 m
.02756 .31449 L
s
.02381 .33322 m
.02756 .33322 L
s
.02381 .35196 m
.02756 .35196 L
s
.02381 .3707 m
.02756 .3707 L
s
.02381 .40817 m
.02756 .40817 L
s
.02381 .4269 m
.02756 .4269 L
s
.02381 .44564 m
.02756 .44564 L
s
.02381 .46438 m
.02756 .46438 L
s
.02381 .50185 m
.02756 .50185 L
s
.02381 .52058 m
.02756 .52058 L
s
.02381 .53932 m
.02756 .53932 L
s
.02381 .55805 m
.02756 .55805 L
s
.02381 .59553 m
.02756 .59553 L
s
.02381 .61426 m
.02756 .61426 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.06244 .03859 L
.10458 .06463 L
.14415 .08909 L
.18221 .11261 L
.22272 .13765 L
.26171 .16175 L
.30316 .18736 L
.34309 .21204 L
.3815 .23578 L
.42237 .26104 L
.46172 .28536 L
.49955 .30874 L
.53984 .33364 L
.57861 .3576 L
.61984 .38308 L
.65954 .40762 L
.69774 .43123 L
.73838 .45635 L
.77751 .48053 L
.81909 .50623 L
.85916 .53099 L
.89771 .55482 L
.93871 .58016 L
.97619 .60332 L
s
.02381 .0152 m
.06244 .03878 L
.10458 .0645 L
.14415 .08866 L
.18221 .11189 L
.22272 .13662 L
.26171 .16042 L
.30316 .18572 L
.34309 .21009 L
.3815 .23354 L
.42237 .25849 L
.46172 .28251 L
.49955 .3056 L
.53984 .3302 L
.57861 .35386 L
.61984 .37903 L
.65954 .40327 L
.69774 .42658 L
.73838 .45139 L
.77751 .47528 L
.81909 .50066 L
.85916 .52512 L
.89771 .54865 L
.93871 .57368 L
.97619 .59656 L
s
.02381 .01855 m
.06244 .04126 L
.10458 .06603 L
.14415 .08929 L
.18221 .11165 L
.22272 .13546 L
.26171 .15838 L
.30316 .18275 L
.34309 .20622 L
.3815 .22879 L
.42237 .25282 L
.46172 .27595 L
.49955 .29818 L
.53984 .32186 L
.57861 .34465 L
.61984 .36889 L
.65954 .39223 L
.69774 .41467 L
.73838 .43857 L
.77751 .46157 L
.81909 .48601 L
.85916 .50956 L
.89771 .53222 L
.93871 .55632 L
.97619 .57835 L
s
.02381 .0275 m
.06244 .04877 L
.10458 .07198 L
.14415 .09377 L
.18221 .11472 L
.22272 .13703 L
.26171 .1585 L
.30316 .18133 L
.34309 .20331 L
.3815 .22447 L
.42237 .24697 L
.46172 .26864 L
.49955 .28948 L
.53984 .31166 L
.57861 .33301 L
.61984 .35571 L
.65954 .37758 L
.69774 .39861 L
.73838 .42099 L
.77751 .44254 L
.81909 .46544 L
.85916 .4875 L
.89771 .50873 L
.93871 .53131 L
.97619 .55195 L
s
.02381 .04449 m
.06244 .06381 L
.10458 .08488 L
.14415 .10466 L
.18221 .12369 L
.22272 .14395 L
.26171 .16344 L
.30316 .18416 L
.34309 .20413 L
.3815 .22334 L
.42237 .24377 L
.46172 .26345 L
.49955 .28236 L
.53984 .30251 L
.57861 .32189 L
.61984 .3425 L
.65954 .36236 L
.69774 .38146 L
.73838 .40178 L
.77751 .42134 L
.81909 .44213 L
.85916 .46217 L
.89771 .48144 L
.93871 .50194 L
.97619 .52068 L
s
.02381 .07158 m
.06244 .08846 L
.10458 .10687 L
.14415 .12417 L
.18221 .1408 L
.22272 .1585 L
.26171 .17554 L
.30316 .19366 L
.34309 .21111 L
.3815 .22789 L
.42237 .24575 L
.46172 .26295 L
.49955 .27948 L
.53984 .29709 L
.57861 .31403 L
.61984 .33205 L
.65954 .3494 L
.69774 .36609 L
.73838 .38386 L
.77751 .40096 L
.81909 .41913 L
.85916 .43664 L
.89771 .45349 L
.93871 .47141 L
.97619 .48778 L
s
.02381 .11028 m
.06244 .12432 L
.10458 .13963 L
.14415 .154 L
.18221 .16783 L
.22272 .18254 L
.26171 .19671 L
.30316 .21176 L
.34309 .22627 L
.3815 .24022 L
.42237 .25507 L
.46172 .26936 L
.49955 .28311 L
.53984 .29774 L
.57861 .31183 L
.61984 .3268 L
.65954 .34123 L
.69774 .3551 L
.73838 .36987 L
.77751 .38408 L
.81909 .39919 L
.85916 .41374 L
.89771 .42775 L
.93871 .44264 L
.97619 .45626 L
s
.02381 .16154 m
.06244 .17238 L
.10458 .1842 L
.14415 .1953 L
.18221 .20598 L
.22272 .21735 L
.26171 .22829 L
.30316 .23992 L
.34309 .25112 L
.3815 .2619 L
.42237 .27336 L
.46172 .2844 L
.49955 .29502 L
.53984 .30632 L
.57861 .3172 L
.61984 .32877 L
.65954 .33991 L
.69774 .35063 L
.73838 .36203 L
.77751 .37301 L
.81909 .38468 L
.85916 .39592 L
.89771 .40674 L
.93871 .41824 L
.97619 .42876 L
s
.02381 .22558 m
.06244 .23296 L
.10458 .24101 L
.14415 .24856 L
.18221 .25583 L
.22272 .26357 L
.26171 .27102 L
.30316 .27893 L
.34309 .28656 L
.3815 .29389 L
.42237 .3017 L
.46172 .30921 L
.49955 .31644 L
.53984 .32413 L
.57861 .33154 L
.61984 .33941 L
.65954 .347 L
.69774 .35429 L
.73838 .36205 L
.77751 .36953 L
.81909 .37747 L
.85916 .38512 L
.89771 .39248 L
.93871 .40031 L
.97619 .40747 L
s
.02381 .30195 m
.06244 .30568 L
.10458 .30976 L
.14415 .31358 L
.18221 .31726 L
.22272 .32118 L
.26171 .32495 L
.30316 .32896 L
.34309 .33282 L
.3815 .33653 L
.42237 .34048 L
.46172 .34429 L
.49955 .34794 L
.53984 .35184 L
.57861 .35559 L
.61984 .35957 L
.65954 .36341 L
.69774 .3671 L
.73838 .37103 L
.77751 .37482 L
.81909 .37884 L
.85916 .38271 L
.89771 .38644 L
.93871 .3904 L
.97619 .39403 L
s
.02381 .38943 m
.06244 .38943 L
.10458 .38943 L
.14415 .38943 L
.18221 .38943 L
.22272 .38943 L
.26171 .38943 L
.30316 .38943 L
.34309 .38943 L
.3815 .38943 L
.42237 .38943 L
.46172 .38943 L
.49955 .38943 L
.53984 .38943 L
.57861 .38943 L
.61984 .38943 L
.65954 .38943 L
.69774 .38943 L
.73838 .38943 L
.77751 .38943 L
.81909 .38943 L
.85916 .38943 L
.89771 .38943 L
.93871 .38943 L
.97619 .38943 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{288, 177.875},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OBGoo10001Goo0P00
17oo1@0017oo100057oo10001Goo0P001Goo100057oo10001Goo0P001goo00<007ooOol00goo1000
77oo1@006goo1@0017oo0P0017oo1@0017oo100057oo1@0017oo0P001Goo1000:goo0018Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007oo
Ool047oo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol047oo
00<007ooOol00Woo00<007ooOol00Woo0P001goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool06goo00<007ooOol07Goo00<007ooOol017oo0P0017oo00D007ooOomoo`0000=oo`03001oogoo
009oo`03001oogoo01=oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo02Qoo`00
B7oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol047oo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol047oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol0
1goo00<007ooOol06goo00<007ooOol07Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol0
4goo00<007ooOol03goo00<007ooOol0:7oo0018Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`08Ool00`00Oomoo`0@Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0@Ool00`00
Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`0KOol00`00Oomoo`0MOol00`00
Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0COol00`00Oomoo`0?Ool00`00Oomoo`0XOol004Qo
o`03001oogoo009oo`03001oogoo00]oo`03001oogoo00=oo`@001=oo`03001oogoo009oo`03001o
ogoo00Uoo`@001=oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo009oo`@001ioo`03001o
ogoo01eoo`03001oogoo00eoo`03001oogoo00=oo`@001Ioo`03001oogoo00]oo`@002]oo`00B7oo
00<007ooOol00Woo00<007ooOol037oo00<007ooOol00Woo00<007ooOol057oo00<007ooOol00Woo
00<007ooOol02Goo00<007ooOol057oo00<007ooOol00Woo00<007ooOol03Goo00D007ooOomoo`00
025oo`03001oogoo01eoo`03001oogoo00ioo`03001oogoo009oo`03001oogoo01Moo`03001oogoo
00]oo`03001oogoo02aoo`00B7oo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ao
o`03001oogoo01Aoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Aoo`03001oogoo009o
o`03001oogoo00Qoo`03001oogoo009oo`05001oogooOol0000OOol3000MOol3000<Ool01@00Oomo
ogoo000017oo00<007ooOol05Goo0`003Goo00<007ooOol0;7oo0019Ool4000<Ool30005Ool5000C
Ool4000<Ool5000COol4000;Ool60003Ool5000MOol00`00Oomoo`0MOol00`00Oomoo`0;Ool30005
Ool5000EOol00`00Oomoo`0;Ool5000ZOol00?moofUoo`00ogooJGoo003oOomYOol002]oo`03001o
ogoo0?moobAoo`80009oo`80015oo`00:goo00<007ooOol0ogoo9Goo00@007ooOol0019oo`00:goo
00<007ooOol0ogoo9Woo0P004goo000[Ool00`00Oomoo`3oOolVOol2000COol002Aoo`L00003O000
00000?l001/000Yoo`04001oogoo000BOol002]oo`=l00Ioo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Uo
o`80009oo`80015oo`00:goo00@007`0O01l02Qoo`03001oogoo02Uoo`03001oogoo02Uoo`03001o
ogoo02Uoo`03001oogoo02Uoo`03001oogoo02Uoo`03001oogoo039oo`00:goo00<007ooOol00g`0
ogoo>7oo000[Ool017`0Oomoogoo17`0ogoo=Woo000[Ool00`00O01l0003Ool3O03oOoleOol002]o
o`800003Ooml07`000=oo`=l0?mooc=oo`00:goo00<007ooOol00Woo0W`00Woo0g`0ogoo<Woo000[
Ool00`00Oomoo`04Ool2O002Ool3O03oOol`Ool002]oo`9l00Moo`9l0004Ooml07`0O03oOol_Ool0
02]oo`04001oog`0O007Ool00g`0Oomoo`03O03oOol]Ool002]oo`80009oo`9l00Ioo`9l009oo`9l
0?moobaoo`00:goo00<007ooOol00goo0W`01Woo0W`000Aoog`0O01l0?moobYoo`00:goo00<007oo
Ool01Goo0W`01Woo00=l07ooOol00W`0ogoo:Goo000[Ool00`00Oomoo`07Ool2O005Ool2O002Ool2
O03oOolWOol002]oo`03001oogoo00Uoo`9l00Eoo`9l009oo`03O01oogoo0?moobAoo`00:goo0P00
37oo0W`01Goo0W`000=oog`0O000ogoo97oo000[Ool2O00>Ool2O005Ool00g`0Oomoo`02O03oOolR
Ool002]oo`04001oog`0O00>Ool2O004Ool2O002Ool00g`0Oomoo`3oOolOOol002]oo`04001oogoo
Ool2O00>Ool2O004Ool2O0000gooO01l003oOolOOol002]oo`03001oogoo00=oo`9l00ioo`9l00Ao
o`9l0003Ooml07`00?mooaeoo`00:goo00<007ooOol01Goo0W`03Woo0W`017oo0W`000=oog`0O000
ogoo6goo000[Ool20008Ool3O00=Ool2O004Ool2O0000gooO01oo`3oOolIOol002]oo`03001oogoo
00Yoo`9l00eoo`9l00Aoo`Al0?mooaQoo`002Goo10001Goo0P0017oo1@0017oo10001Woo00<007oo
Ool037oo0W`03Goo0W`017oo17`0ogoo5Woo0008Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004
Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol03Woo0g`037oo
0W`017oo17`0ogoo57oo0008Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00
Oomoo`03Ool00`00Oomoo`0AOol2O00<Ool2O004Ool4O03oOolBOol000Qoo`03001oogoo009oo`03
001oogoo00Yoo`03001oogoo00Qoo`03001oogoo00=oo`<001=oo`=l00]oo`9l00Aoo`Al0?mooa1o
o`0027oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol00goo10001Woo0W`05goo0W`02goo
0W`017oo0g`0ogoo3goo0008Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Ooml0002O00FOol2O00;Ool2O004Ool3O03oOol=Ool000Qoo`03001oogoo009o
o`03001oogoo00Qoo`05001oogooOol00004Ool00`00Oomoo`07Ool00`00Oomoo`02Ool2O00FOol3
O00:Ool2O003Ool4O03oOol;Ool000Uoo`@000aoo`<000Eoo`D000Eoo`03001oogoo00Aoo`=l01Io
o`9l00Yoo`9l00=oo`=l0?moo`Yoo`00:goo00<007ooOol01goo0g`05Goo0g`02Goo00=l07ooOol0
0Woo0g`0ogoo27oo000[Ool2000;Ool3O00EOol2O008Ool2O003Ool4O03oOol6Ool002]oo`03001o
ogoo00eoo`=l01Aoo`9l00Qoo`9l00=oo`Al0?moo`Aoo`00:goo00<007ooOol047oo0g`04goo0W`0
27oo0W`00goo0g`0ogoo0goo000[Ool00`00Oomoo`0COol3O00BOol2O008Ool2O003Ool3O03oOol1
Ool002]oo`03001oogoo01Ioo`9l019oo`=l00Moo`9l009oo`=l0?moo`00:goo0P006Goo0W`04goo
0W`01goo0g`000Aoog`0O01l0?eoo`00:goo00<007ooOol06Woo0g`04Woo0W`027oo1W`0ngoo000[
Ool00`00Oomoo`0MOol2O00BOol3O007Ool5O03jOol002]oo`03001oogoo01moo`=l019oo`9l00Mo
o`El0?Qoo`00:goo00<007ooOol08Woo0g`04Goo0g`01Woo17`0mgoo000[Ool2O00VOol2O00BOol2
O006Ool4O03eOol002]oo`8000Al02Aoo`=l015oo`9l00Ioo`Al0?=oo`00:goo00<007ooOol00goo
17`08goo0g`047oo0W`01Woo0g`0lWoo000[Ool00`00Oomoo`07Ool3O00SOol3O00?Ool2O006Ool3
O03`Ool002]oo`03001oogoo00Yoo`Al029oo`=l00ioo`=l00Aoo`Al0>ioo`00:goo00<007ooOol0
3Woo17`08Goo0g`03Woo0W`017oo17`0k7oo000[Ool2000COol4O00POol3O00=Ool2O004Ool3O03[
Ool002]oo`03001oogoo01Ioo`=l021oo`=l00aoo`=l00=oo`=l0>Uoo`00:goo00<007ooOol06Goo
0g`087oo0W`03Goo0W`00Woo17`0igoo000AOol40005Ool20005Ool40006Ool00`00Oomoo`0LOol3
O00OOol3O00<Ool3O0000gooO01l0002O03UOol0011oo`03001oogoo009oo`03001oogoo009oo`80
00Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo01moo`=l01moo`=l00aoo`9l0003Ooml
07`0009l0>=oo`0047oo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00goo00<007ooOol0
8Woo17`07Woo0g`02goo1g`0hGoo000@Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`03
Ool3000VOol4O00MOol3O00:Ool7O03OOol0011oo`03001oogoo009oo`03001oogoo00Uoo`@000Io
o`03001oogoo02Yoo`=l01eoo`=l00Yoo`Il0=eoo`0047oo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol01goo00<007ooOol0;Goo17`077oo0g`02Goo1W`0fgoo000@Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`0aOol4O00KOol2O009Ool6O03IOol0015oo`@0
00aoo`D000Eoo`03001oogoo03Eoo`Al01Uoo`9l00Uoo`Il0=Moo`00:goo0P00>Woo17`05goo0g`0
1goo1g`0eGoo000[Ool2O00nOol4O00FOol2O007Ool6O03DOol002]oo`03001oog`000=l03ioo`=l
01Eoo`=l00Ioo`03O01oog`000=l0=9oo`00:goo00<007ooOol00goo17`0?Goo0g`05Goo0g`017oo
0W`000=oog`0O0000W`0d7oo000[Ool00`00Oomoo`07Ool4O00lOol3O00EOol2O004Ool00g`0Oomo
o`04O03>Ool002]oo`8000aoo`Il03Uoo`=l01Aoo`=l009oo`9l009oo`Al0<aoo`00:goo00<007oo
Ool04Goo1W`0=Woo0g`057oo0g`000Aoog`0O01oo`El0<Yoo`00:goo00<007ooOol05goo1W`0<goo
17`04goo17`00Woo1W`0agoo000[Ool00`00Oomoo`0MOol6O00aOol4O00BOol3O002Ool3O0000goo
O01l0035Ool002]oo`03001oogoo02=oo`Il02moo`Al011oo`Al0005Ooml07`0O01oo`02O033Ool0
02]oo`03001oogoo02Uoo`El02ioo`Al00ioo`Ql0003Ooml07`00<5oo`00:goo0P00;goo1W`0;7oo
17`02goo0g`000=oog`0O0000g`000=oog`0O000_goo000[Ool00`00Oomoo`0dOol5O00[Ool3O00:
Ool3O0000gooO01l0003O00017ooO01l07`0_7oo000[Ool00`00Oomoo`0iOol4O00ZOol4O007Ool3
O002Ool5O00017ooO01l07`0^Woo000[Ool00`00Oomoo`0mOol4O00ZOol4O005Ool3O002Ool00g`0
Ooml0002O00017ooO01l07`0^7oo000[Ool00`00Oomoo`11Ool4O00ZOol4O002Ool4O00017ooO01l
07oo1g`0]Woo000[Ool20016Ool6O00XOol7O002Ool00g`0Oomoo`07O02dOol002]oo`03001oogoo
04]oo`Il02Ioo`El0003Ooml07`0009oo`Ql0;5oo`00:goo00<007ooOol0DGoo1W`08goo17`000=o
og`0O0000Woo0W`000=oog`0O0000g`0[goo0009Ool40005Ool20007Ool00`00Oomoo`03Ool40006
Ool00`00Oomoo`1GOol6O00OOol7O002Ool2O0000gooO01l0003O02]Ool000Qoo`03001oogoo009o
o`03001oogoo009oo`8000Moo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001o
ogoo05eoo`Il01Yoo`=l0003Ooml07`0009l009oo`03O01oogoo00Il0:Yoo`0027oo00<007ooOol0
0Woo00<007ooOol02goo00<007ooOol01goo00<007ooOol00goo00<007ooOol0Hgoo17`067oo0g`0
00=oog`0O0000W`000=oog`0O0000Woo0W`000Aoog`0O01l0:Qoo`0027oo00<007ooOol00Woo00<0
07ooOol037oo00<007ooOol01Woo00<007ooOol00goo0`00Igoo17`05Goo17`00Woo0g`000=oog`0
O0000Woo0W`00Woo0g`0YGoo0008Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`02Ool4
0006Ool00`00Oomoo`1[Ool4O00COol3O003Ool6O002Ool2O003Ool3O02ROol000Qoo`03001oogoo
009oo`03001oogoo00eoo`05001oogooOol00009Ool6O01/Ool5O00@Ool3O003Ool2O0000gooO01l
0002O00017ooO01l07`00Woo0g`0X7oo0008Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomo
o`02Ool01@00Oomoogoo00002Goo00<007ooOol00goo2g`0IWoo1W`02goo0g`017oo00Al07ooOomo
o`Ml009oo`Al09eoo`002Goo10002goo1P000goo1@001Goo00<007ooOol03Woo37`0H7oo1G`027oo
0g`00goo0W`00goo0W`000=oog`0O0000W`00Woo1G`0VWoo000[Ool2000KOol<O01IOol6O003Ool4
O003Ool2O003Ool2O003Ool9O02HOol002]oo`03001oogoo02Ioo`]l05Aoo`Ql00Aoo`9l00=oo`03
O01oogoo009oo`Ul09Ioo`00:goo00<007ooOol0<Goo37`0CGoo1W`00goo00Al07ooOomoo`9l00Ao
o`9l0003Ooml07`000El09=oo`00:goo00<007ooOol0?Goo2g`0AGoo2G`00goo0W`017oo0W`00goo
1G`0TGoo000[Ool00`00Oomoo`18Ool9O00nOol4O003Ool6O005Ool2O004Ool5O02>Ool002]oo`03
001oogoo055oo`Il03Yoo`=l00=oo`9l00=oo`El009oo`9l00Aoo`Il08]oo`00:goo0P00F7oo2G`0
<goo0g`00goo0W`00goo00=l07ooOol01W`01Goo0W`000Aoog`0O01l08Qoo`00:goo00<007ooOol0
H7oo2g`0:Goo0g`017oo00Al07ooOomoo`9l00Ioo`El009oo`9l009oo`=l08Eoo`00:goo00<007oo
Ool0Jgoo37`07goo0g`00goo0W`00goo0W`01Woo0W`000=oog`0O0001G`00Woo0g`0PWoo000[Ool0
0`00Oomoo`1gOol;O00EOol4O003Ool00g`0Oomoo`02Ool2O006Ool2O003Ool5O003Ool4O01nOol0
02]oo`03001oogoo089oo`]l00aoo`=l00=oo`9l00Aoo`9l00Ioo`9l00Eoo`El009oo`El07Yoo`00
:goo0P00SWoo37`00Woo0g`00goo0W`017oo0W`01Woo0W`01goo2g`0Mgoo000[Ool00`00Oomoo`2I
Ool;O005Ool2O006Ool2O007Ool2O003Ool8O01cOol002]oo`03001oogoo09ioo`=l00=oo`al00=o
o`9l00Moo`9l00Eoo`Ql06moo`00:goo00<007ooOol0Wgoo17`00goo0W`01Goo0W`000=oog`0O000
1g`01Goo0W`01Woo0g`000=oog`0O00017`0JWoo000[Ool00`00Oomoo`2QOol3O004Ool2O005Ool0
0g`0Oomoo`05Ool8O00017ooO01l07`01Woo0g`00goo1g`0I7oo000[Ool00`00Oomoo`2SOol3O004
Ool00g`0Oomoo`03Ool2O007Ool2O004Ool8O005Ool3O004Ool7O01POol002]oo`800:Eoo`Al00=o
o`9l00Eoo`9l00Moo`9l00Qoo`il00Aoo`Ml05aoo`00:goo00<007ooOol0YWoo17`00goo0W`01Goo
0W`01goo0W`027oo0g`027oo47`0F7oo000QOol50005Ool00`00Oomoo`2XOol3O004Ool00g`0Oomo
o`04Ool00g`0Oomoo`06Ool2O009Ool2O008Ool3O006Ool=O01@Ool002=oo`03001oogoo00Eoo`03
001oogoo0:Yoo`=l00=oo`9l00Eoo`9l00Qoo`03O01oogoo00Qoo`=l00Qoo`=l00Ioo`=l00Aoo`ml
04Aoo`008goo00<007ooOol01Goo00<007ooOol0Zgoo17`00goo0W`01Goo0W`01goo0W`02goo0W`0
2Goo0W`01goo0g`01goo1W`00goo2g`0>Goo000SOol00`00Oomoo`05OoooO00GO00WOol002=oo`03
001oogoo00Eoo`03001oogoo0:moo`=l00Aoo`03O01oogoo00Aoo`9l00Moo`9l00]oo`9l00Uoo`=l
00Uoo`Al00]oo`El00moo`Il02Moo`008goo00<007ooOol01Goo00<007ooOol0/7oo17`00goo0W`0
1Woo0W`01goo0W`02goo0W`02Woo0W`02goo17`037oo1W`0=Woo000QOol30007Ool00`00Oomoo`2b
Ool4O003Ool2O006Ool00g`0Oomoo`06Ool2O00;Ool2O00:Ool3O00<Ool4O00>Ool6O00`Ool002=o
o`03001oogoo00Eoo`03001oogoo0;Aoo`=l00Aoo`9l00Eoo`9l00Qoo`=l00Yoo`9l00]oo`=l00eo
o`Al011oo`Il02Yoo`00:goo0P00]goo0g`017oo0W`01Goo0W`02Goo0W`02Woo0W`037oo0g`03Woo
0g`04goo0g`09goo000[Ool00`00Oomoo`2gOol3O005Ool2O005Ool2O009Ool2O00:Ool2O00=Ool3
O00>Ool4O00iOol002]oo`03001oogoo0;Uoo`=l00Eoo`03O01oogoo00Aoo`9l00Uoo`9l00Yoo`9l
00ioo`=l00moo`Al03Eoo`00:goo00<007ooOol0^Woo17`017oo0W`01Woo0W`02Goo0W`02Woo0W`0
3goo0g`047oo17`0<Goo000[Ool00`00Oomoo`2lOol3O005Ool2O006Ool2O009Ool2O00:Ool3O00?
Ool2O00BOol4O00]Ool002]oo`03001oogoo0;ioo`=l00Eoo`03O01oogoo00Eoo`9l00Uoo`9l00]o
o`9l00moo`=l01=oo`Al02Uoo`00:goo0P00`7oo0g`01Goo0W`01goo0W`02Goo0W`02goo0W`047oo
0g`057oo0W`09goo000[Ool00`00Oomoo`31Ool3O005Ool2O007Ool2O009Ool2O00;Ool3O00@Ool3
O00jOol002]oo`03001oogoo0<9oo`Al00Eoo`9l00Moo`9l00Uoo`9l00aoo`9l015oo`=l03Moo`00
:goo00<007ooOol0a7oo0g`01Woo00=l07ooOol01Woo0W`02Goo0W`037oo0g`04Goo0g`0=7oo000[
Ool00`00Oomoo`36Ool3O005Ool2O008Ool00g`0Oomoo`08Ool2O00=Ool2O00BOol3O00aOol002]o
o`800<Qoo`Al00Eoo`03O01oogoo00Ioo`9l00Yoo`9l00eoo`9l01=oo`=l02ioo`00:goo00<007oo
Ool0bGoo17`017oo0W`027oo0W`02Woo0W`03Goo0W`057oo0W`0;7oo000[Ool00`00Oomoo`3;Ool3
O005Ool2O008Ool00g`0Oomoo`09Ool2O00=Ool2O00DOol3O00YOol002]oo`03001oogoo0<eoo`=l
00Eoo`03O01oogoo00Ioo`9l00]oo`9l00eoo`=l01Aoo`9l02Moo`00:goo00<007ooOol0cWoo0g`0
1Goo0W`027oo0W`02goo0W`03Woo0W`0>goo000[Ool00`00Oomoo`3@Ool3O005Ool00g`0Oomoo`07
Ool2O00;Ool2O00>Ool2O00iOol002]oo`800=9oo`04O01oog`0O004Ool2O009Ool00g`0Oomoo`0:
Ool2O00>Ool3O00fOol002]oo`03001oogoo0=9oo`9l0003Ooml07oo00Aoo`9l00Qoo`9l00aoo`9l
00moo`9l03Aoo`002Goo1@0017oo0P0017oo1@0017oo10001Woo00<007ooOol0e7oo00Al07ooO01l
00Eoo`03O01oogoo00Moo`9l00aoo`9l00moo`=l035oo`002goo00<007ooOol017oo0P0017oo00D0
07ooOomoo`0000=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo0=Eoo`04O01oogooO005
Ool2O009Ool00g`0Oomoo`0;Ool2O00@Ool2O00_Ool000]oo`03001oogoo00]oo`03001oogoo00Uo
o`03001oogoo00=oo`03001oogoo0=Ioo`9l0003Ooml07`000Eoo`9l00Qoo`9l00eoo`9l011oo`9l
02eoo`002goo00<007ooOol037oo00<007ooOol027oo00<007ooOol00goo0`00f7oo00=l07ooOol0
0W`01Goo0W`027oo0W`03Goo00=l07ooOol03goo0W`0:goo000;Ool00`00Oomoo`0=Ool00`00Oomo
o`03Ool40006Ool00`00Oomoo`3IOol2O002Ool00g`0Oomoo`04Ool00g`0Oomoo`07Ool2O00<Ool2
O00AOol2O00YOol000]oo`03001oogoo00ioo`03001oogoo009oo`03001oogoo00Moo`03001oogoo
0=]oo`9l0003Ooml07`000Eoo`9l00Uoo`03O01oogoo00]oo`9l015oo`9l02Moo`002Goo0`0037oo
00D007ooOomoo`0000Aoo`03001oogoo00Moo`03001oogoo0=eoo`03O01oogoo009l00Eoo`9l00Qo
o`9l00eoo`9l03Qoo`002goo00<007ooOol02goo0`001Goo1@001Goo00<007ooOol0gWoo0W`00Woo
0W`01Goo00=l07ooOol01goo0W`03Goo0W`0=Woo000[Ool00`00Oomoo`3POol2O002Ool00g`0Oomo
o`03Ool2O009Ool2O00=Ool2O00dOol002]oo`800>=oo`9l0003Ooml07`000Eoo`9l00Uoo`9l00eo
o`=l035oo`00:goo00<007ooOol0i7oo00=l07ooOol00W`01Goo0W`02Goo0W`03Woo0W`0;goo000[
Ool00`00Oomoo`3UOol2O002Ool00g`0Oomoo`04Ool00g`0Oomoo`08Ool00g`0Oomoo`0=Ool2O00]
Ool002]oo`03001oogoo0>Moo`9l0003Ooml07`000Eoo`9l00Uoo`9l00moo`9l02]oo`00:goo00<0
07ooOol0jGoo00=l07ooOol00W`01Goo00=l07ooOol027oo0W`03goo0W`0:Goo000[Ool2003[Ool2
O002Ool2O004Ool2O00:Ool2O00?Ool2O00WOol002]oo`03001oogoo0>aoo`9l009oo`03O01oogoo
00=oo`9l00Yoo`9l03Ioo`00:goo00<007ooOol0kWoo0W`000=oog`0O0001Goo00=l07ooOol02Goo
0W`0=7oo000[Ool00`00Oomoo`3`Ool017`0Oomoog`01Goo0W`02goo0W`0<Woo000[Ool00`00Oomo
o`3aOol2O0000gooO01l0005Ool00g`0Oomoo`0:Ool2O00`Ool002]oo`03001oogoo0?=oo`03O01o
ogoo009l00Aoo`9l00aoo`9l02ioo`00:goo0P00mGoo0W`00Woo00=l07ooOol00goo0W`037oo0W`0
;7oo000[Ool00`00Oomoo`3fOol2O0000gooO01l0005Ool00g`0Oomoo`0;Ool2O00ZOol002]oo`03
001oogoo0?Qoo`04O01oogooO005Ool2O00=Ool2O00XOol002]oo`03001oogoo0?Uoo`9l0003Ooml
07`000Eoo`9l00eoo`03O01oogoo02Eoo`00:goo00<007ooOol0ngoo00Al07ooOoml00Ioo`9l03=o
o`00:goo0P00oGoo0W`000=oog`0O0001Woo00=l07ooOol0<7oo000[Ool00`00Oomoo`3nOol2O000
0gooO01oo`05Ool2O00`Ool0015oo`D000Aoo`8000Eoo`@000Ioo`03001oogoo0?moo`5oo`04O01o
og`0O006Ool2O00^Ool001=oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo0?moo`9oo`9l0003Ooml07oo00Ioo`9l02aoo`004goo00<007ooOol03goo00<007oo
Ool00goo00<007ooOol0ogoo17oo17`01goo0W`0:Woo000COol00`00Oomoo`0?Ool00`00Oomoo`03
Ool3003oOol6Ool3O008Ool2O00XOol001=oo`03001oogoo00]oo`@000Ioo`03001oogoo0?moo`Qo
o`=l00Qoo`03O01oogoo02Eoo`004goo00<007ooOol02goo00<007ooOol01goo00<007ooOol0ogoo
2Goo17`0;Woo000AOol3000=Ool00`00Oomoo`07Ool00`00Oomoo`3oOol;Ool017`0Ooml07`0;7oo
000COol00`00Oomoo`0;Ool50005Ool00`00Oomoo`3oOol<Ool2O0000gooO01l000ZOol002]oo`03
001oogoo0?moo`ioo`9l0003Ooml07`002Qoo`00:goo0P00ogoo4Goo00Al07ooOoml02Moo`00:goo
00<007ooOol0ogoo4Goo0W`0:7oo000[Ool00`00Oomoo`3oOolCOol00g`0Oomoo`0UOol002]oo`03
001oogoo0?mooc]oo`00:goo00<007ooOol0ogoo>goo000[Ool2003oOollOol002]oo`03001oogoo
0?mooc]oo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogoo
JGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo000XOol4003o
OolmOol002aoo`03001oogoo0?moocYoo`00:7oo0`0000=oo`00Ool0ogoo>goo000WOol01000Oomo
ogoo0P00ogoo?7oo000WOol00`00Oomoo`02Ool00`00Oomoo`3oOoljOol002Moo`03001oogoo009o
o`03001oogoo0?moocYoo`009goo00@007ooOomoo`800?moocaoo`00:7oo0`0000=oo`000000ogoo
>goo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol0
0?moofUoo`00ogooJGoo003oOomYOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.313, 0}} -> {-0.24548, -0.136616, \
0.00709105, 0.0114736}}]
}, Open  ]],

Cell[TextData[{
  "The above figure shows that the slope of the function ",
  StyleBox["sin[", "MmaText"],
  StyleBox["x", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " starts with a finite value at ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0 = 0\)]],
  " and ends up with a vanishing value at ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0 = \[Pi]/2\)]],
  ". The following figure, showing the function and the derivative of the \
function, represents another way to examine the behavior of the slope."
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[\n\t\t{f[x], \[PartialD]\_x f[x]}], \t{x, 0, \[Pi]\/2}, \n
      \tAxesLabel \[Rule] {"\<x\>", "\<f,f'\>"}, \n\t
      PlotStyle \[Rule] {RGBColor[0, 0, 1], \n\t\t\tRGBColor[1, 0, 0]}]\)], 
  "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.606305 0.0147151 0.588604 [
[.17539 .00222 -12 -9 ]
[.17539 .00222 12 0 ]
[.32696 .00222 -9 -9 ]
[.32696 .00222 9 0 ]
[.47854 .00222 -12 -9 ]
[.47854 .00222 12 0 ]
[.63011 .00222 -3 -9 ]
[.63011 .00222 3 0 ]
[.78169 .00222 -12 -9 ]
[.78169 .00222 12 0 ]
[.93327 .00222 -9 -9 ]
[.93327 .00222 9 0 ]
[1.025 .01472 0 -9.5 ]
[1.025 .01472 12 9.5 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -18 0 ]
[.02381 .64303 18 19 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.17539 .01472 m
.17539 .02097 L
s
[(0.25)] .17539 .00222 0 1 Mshowa
.32696 .01472 m
.32696 .02097 L
s
[(0.5)] .32696 .00222 0 1 Mshowa
.47854 .01472 m
.47854 .02097 L
s
[(0.75)] .47854 .00222 0 1 Mshowa
.63011 .01472 m
.63011 .02097 L
s
[(1)] .63011 .00222 0 1 Mshowa
.78169 .01472 m
.78169 .02097 L
s
[(1.25)] .78169 .00222 0 1 Mshowa
.93327 .01472 m
.93327 .02097 L
s
[(1.5)] .93327 .00222 0 1 Mshowa
.125 Mabswid
.05412 .01472 m
.05412 .01847 L
s
.08444 .01472 m
.08444 .01847 L
s
.11476 .01472 m
.11476 .01847 L
s
.14507 .01472 m
.14507 .01847 L
s
.2057 .01472 m
.2057 .01847 L
s
.23602 .01472 m
.23602 .01847 L
s
.26633 .01472 m
.26633 .01847 L
s
.29665 .01472 m
.29665 .01847 L
s
.35728 .01472 m
.35728 .01847 L
s
.38759 .01472 m
.38759 .01847 L
s
.41791 .01472 m
.41791 .01847 L
s
.44822 .01472 m
.44822 .01847 L
s
.50885 .01472 m
.50885 .01847 L
s
.53917 .01472 m
.53917 .01847 L
s
.56948 .01472 m
.56948 .01847 L
s
.5998 .01472 m
.5998 .01847 L
s
.66043 .01472 m
.66043 .01847 L
s
.69074 .01472 m
.69074 .01847 L
s
.72106 .01472 m
.72106 .01847 L
s
.75138 .01472 m
.75138 .01847 L
s
.81201 .01472 m
.81201 .01847 L
s
.84232 .01472 m
.84232 .01847 L
s
.87264 .01472 m
.87264 .01847 L
s
.90295 .01472 m
.90295 .01847 L
s
.96358 .01472 m
.96358 .01847 L
s
.9939 .01472 m
.9939 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.02381 .13244 m
.03006 .13244 L
s
[(0.2)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.4)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.6)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.8)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -79 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(f) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(,) show
79.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(f) show
87.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(') show
95.000000 17.437500 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .01472 m
.06244 .0522 L
.10458 .0929 L
.14415 .13078 L
.18221 .16675 L
.22272 .20437 L
.26171 .23979 L
.30316 .27641 L
.34309 .31054 L
.3815 .34217 L
.42237 .37437 L
.46172 .40383 L
.49955 .43061 L
.53984 .45735 L
.57861 .48124 L
.61984 .50455 L
.65954 .52486 L
.69774 .54233 L
.73838 .55862 L
.77751 .572 L
.81909 .58367 L
.85916 .59239 L
.87754 .59554 L
.89771 .59839 L
.91765 .60058 L
.92854 .6015 L
.93871 .60219 L
.94354 .60247 L
.94878 .60272 L
.95341 .6029 L
.95832 .60306 L
.96273 .60317 L
.96524 .60322 L
.9676 .60326 L
.96976 .60329 L
.97173 .6033 L
.97277 .60331 L
.97391 .60331 L
.97509 .60332 L
.97619 .60332 L
s
1 0 0 r
.02381 .60332 m
.02499 .60332 L
.02605 .60331 L
.02729 .60331 L
.02846 .6033 L
.03053 .60328 L
.03279 .60325 L
.03527 .60321 L
.0379 .60316 L
.04262 .60304 L
.04749 .60287 L
.05205 .60268 L
.06244 .60212 L
.07305 .60138 L
.08274 .60054 L
.10458 .5981 L
.12357 .59537 L
.14429 .59174 L
.18493 .58266 L
.22406 .5715 L
.26565 .55711 L
.30571 .54083 L
.34426 .523 L
.38527 .50178 L
.42475 .47924 L
.46273 .45571 L
.50315 .42875 L
.54206 .40107 L
.58342 .3699 L
.62326 .33831 L
.66159 .30661 L
.70238 .27159 L
.74164 .23678 L
.77939 .20243 L
.8196 .16505 L
.85828 .12846 L
.89942 .08904 L
.93905 .05075 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{288, 177.875},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OAGoo10001Goo0P00
17oo1@0017oo100057oo10001Goo0P001Goo100057oo10001Goo0P001goo00<007ooOol00goo1000
77oo1@006goo1@0017oo0P0017oo1@0017oo100057oo1@0017oo0P001Goo1000;goo0014Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007oo
Ool047oo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol047oo
00<007ooOol00Woo00<007ooOol00Woo0P001goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool06goo00<007ooOol07Goo00<007ooOol017oo0P0017oo00D007ooOomoo`0000=oo`03001oogoo
009oo`03001oogoo01=oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo02aoo`00
A7oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol047oo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol047oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol0
1goo00<007ooOol06goo00<007ooOol07Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol0
4goo00<007ooOol03goo00<007ooOol0;7oo0014Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`08Ool00`00Oomoo`0@Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0@Ool00`00
Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`0KOol00`00Oomoo`0MOol00`00
Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0COol00`00Oomoo`0?Ool00`00Oomoo`0/Ool004Ao
o`03001oogoo009oo`03001oogoo00]oo`03001oogoo00=oo`@001=oo`03001oogoo009oo`03001o
ogoo00Uoo`@001=oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo009oo`@001ioo`03001o
ogoo01eoo`03001oogoo00eoo`03001oogoo00=oo`@001Ioo`03001oogoo00]oo`@002moo`00A7oo
00<007ooOol00Woo00<007ooOol037oo00<007ooOol00Woo00<007ooOol057oo00<007ooOol00Woo
00<007ooOol02Goo00<007ooOol057oo00<007ooOol00Woo00<007ooOol03Goo00D007ooOomoo`00
025oo`03001oogoo01eoo`03001oogoo00ioo`03001oogoo009oo`03001oogoo01Moo`03001oogoo
00]oo`03001oogoo031oo`00A7oo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ao
o`03001oogoo01Aoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Aoo`03001oogoo009o
o`03001oogoo00Qoo`03001oogoo009oo`05001oogooOol0000OOol3000MOol3000<Ool01@00Oomo
ogoo000017oo00<007ooOol05Goo0`003Goo00<007ooOol0<7oo0015Ool4000<Ool30005Ool5000C
Ool4000<Ool5000COol4000;Ool60003Ool5000MOol00`00Oomoo`0MOol00`00Oomoo`0;Ool30005
Ool5000EOol00`00Oomoo`0;Ool5000^Ool00?moofUoo`00ogooJGoo003oOomYOol002Moo`03001o
ogoo0?moobEoo`80009oo`8001Aoo`009goo00<007ooOol0ogoo9Woo00@007ooOol001Eoo`009goo
00<007ooOol0ogoo9goo0P005Woo000WOol00`00Oomoo`3oOolWOol2000FOol0021oo`L0000301l0
00000?l001<00003O000000000D000]oo`04001oogoo000EOol002Moo`0300007goo00Ioo`03001o
ogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`04001o
ogooO005Ool00`00Oomoo`0:Ool20002Ool2000DOol002Moo`03001oo`0O02Uoo`03001oogoo02Uo
o`03001oogoo02Uoo`03001oogoo02Uoo`03001oogoo02Uoo`03001oogoo02Uoo`03001oogoo00Qo
o`03O01oogoo02]oo`009goo00@007ooOol07omoo`moo`03O01oogoo02aoo`009goo00D007ooOomo
o`0O0?moo`eoo`03O01oogoo02eoo`009goo00<007ooOol00Woo00<07gooOol0ogoo2Goo00=l07oo
Ool0;Woo000WOol00`00Oomoo`03Ool00`0OOomoo`3oOol7Ool00g`0Oomoo`0_Ool002Moo`03001o
ogoo00Aoo`0301moogoo0?moo`Eoo`03O01oogoo031oo`009goo00<007ooOol01Goo00<07gooOol0
ogoo0goo00=l07ooOol0<Goo000WOol20007Ool00`0OOomoo`3oOol1Ool00g`0Oomoo`0bOol002Mo
o`03001oogoo00Moo`0301moogoo0?ioo`03O01oogoo03=oo`009goo00<007ooOol027oo00<07goo
Ool0o7oo00=l07ooOol0=7oo000WOol00`00Oomoo`09Ool00`0OOomoo`3jOol00g`0Oomoo`0eOol0
02Moo`03001oogoo00Yoo`0301moogoo0?Qoo`03O01oogoo03Ioo`009goo00<007ooOol02goo00<0
7gooOol0mWoo00=l07ooOol0=goo000WOol00`00Oomoo`0<Ool00`0OOomoo`3dOol00g`0Oomoo`0h
Ool002Moo`03001oogoo00eoo`0301moogoo0?9oo`03O01oogoo03Uoo`009goo0P003goo0P0OlGoo
00=l07ooOol0>Woo000WOol00`00Oomoo`0@Ool00`0OOomoo`3]Ool00g`0Oomoo`0kOol002Moo`03
001oogoo015oo`0301moogoo0>]oo`03O01oogoo03aoo`009goo00<007ooOol04Woo00<07gooOol0
jGoo00=l07ooOol0?Goo000WOol00`00Oomoo`0COol00`0OOomoo`3WOol00g`0Oomoo`0nOol002Mo
o`03001oogoo01Aoo`0301moogoo0>Eoo`03O01oogoo03moo`009goo00<007ooOol05Goo00<07goo
Ool0hgoo00=l07ooOol0@7oo000WOol00`00Oomoo`0FOol00`0OOomoo`3QOol00g`0Oomoo`11Ool0
02Moo`03001oogoo01Moo`0301moogoo0=moo`03O01oogoo049oo`009goo0P006Goo00<07gooOol0
gGoo00=l07ooOol0@goo000WOol00`00Oomoo`0IOol00`0OOomoo`3JOol2O016Ool002Moo`03001o
ogoo01Yoo`0301moogoo0=Qoo`03O01oogoo04Ioo`009goo00<007ooOol06goo00<07gooOol0eWoo
00=l07ooOol0Agoo000WOol00`00Oomoo`0LOol00`0OOomoo`3DOol00g`0Oomoo`18Ool000eoo`@0
00Eoo`8000Aoo`D000Ioo`03001oogoo01eoo`0301moogoo0=9oo`03O01oogoo04Uoo`0037oo00<0
07ooOol00Woo00<007ooOol00Woo0P0017oo00D007ooOomoo`0000Ioo`03001oogoo01ioo`0301mo
ogoo0=1oo`03O01oogoo04Yoo`0037oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo
00<007ooOol07goo00<07gooOol0cWoo00=l07ooOol0Bgoo000<Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Oomoo`06Ool3000POol00`0OOomoo`3<Ool00g`0Oomoo`1<Ool000aoo`03001oogoo
009oo`03001oogoo00]oo`03001oogoo00Eoo`03001oogoo025oo`0301moogoo0<Yoo`03O01oogoo
04eoo`0037oo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol08Woo00<0
7gooOol0b7oo00=l07ooOol0CWoo000<Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo
00001Woo00<007ooOol08goo00<07gooOol0aWoo00=l07ooOol0Cgoo000=Ool4000<Ool30007Ool0
0`00Oomoo`0TOol00`0OOomoo`33Ool2O01BOol002Moo`03001oogoo02Eoo`807l9oo`03O01oogoo
059oo`009goo00<007ooOol09goo00<07gooOol0_Woo00=l07ooOol0Dgoo000WOol00`00Oomoo`0X
Ool00`0OOomoo`2lOol00g`0Oomoo`1DOol002Moo`03001oogoo02Uoo`0301moogoo0;Yoo`03O01o
ogoo05Eoo`009goo0P00:goo00<07gooOol0^7oo00=l07ooOol0EWoo000WOol00`00Oomoo`0[Ool0
0`0OOomoo`2fOol00g`0Oomoo`1GOol002Moo`03001oogoo02aoo`0301moogoo0;Aoo`03O01oogoo
05Qoo`009goo00<007ooOol0;Goo00<07gooOol0/Woo00=l07ooOol0FGoo000WOol00`00Oomoo`0^
Ool00`0OOomoo`2`Ool00g`0Oomoo`1JOol002Moo`03001oogoo02moo`0301moogoo0:ioo`03O01o
ogoo05]oo`009goo00<007ooOol0<7oo00<07gooOol0[7oo00=l07ooOol0G7oo000WOol00`00Oomo
o`0aOol201n[Ool00g`0Oomoo`1MOol002Moo`8003Aoo`0301moogoo0:Moo`03O01oogoo05ioo`00
9goo00<007ooOol0=7oo00<07gooOol0YGoo00=l07ooOol0Ggoo000WOol00`00Oomoo`0eOol00`0O
Oomoo`2SOol00g`0Oomoo`1POol002Moo`03001oogoo03Ioo`0301moogoo0:5oo`03O01oogoo065o
o`009goo00<007ooOol0=goo00<07gooOol0Wgoo00=l07ooOol0HWoo000WOol00`00Oomoo`0hOol0
0`0OOomoo`2MOol00g`0Oomoo`1SOol002Moo`03001oogoo03Uoo`0301moogoo09]oo`03O01oogoo
06Aoo`009goo00<007ooOol0>Woo00<07gooOol0VGoo00=l07ooOol0IGoo000WOol00`00Oomoo`0k
Ool00`0OOomoo`2GOol00g`0Oomoo`1VOol002Moo`8003eoo`0301moogoo09Aoo`9l06Uoo`009goo
00<007ooOol0?Goo00<07gooOol0TWoo00=l07ooOol0JGoo000WOol00`00Oomoo`0nOol00`0OOomo
o`2@Ool00g`0Oomoo`1ZOol002Moo`03001oogoo03moo`0301moogoo08ioo`03O01oogoo06]oo`00
9goo00<007ooOol0@7oo00<07gooOol0S7oo00=l07ooOol0K7oo000WOol00`00Oomoo`11Ool00`0O
Oomoo`2:Ool00g`0Oomoo`1]Ool000eoo`@000Eoo`8000Moo`<000Eoo`03001oogoo049oo`0301mo
ogoo08Qoo`03O01oogoo06ioo`0037oo00<007ooOol00Woo00<007ooOol00Woo0P0027oo00<007oo
Ool017oo00<007ooOol0@goo00<07gooOol0QGoo0W`0LGoo000<Ool00`00Oomoo`02Ool00`00Oomo
o`0<Ool00`00Oomoo`04Ool00`00Oomoo`14Ool00`0OOomoo`23Ool00g`0Oomoo`1aOol000aoo`03
001oogoo009oo`03001oogoo00Qoo`H000Eoo`<004Eoo`807h9oo`03O01oogoo079oo`0037oo00<0
07ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo04Moo`0301moogoo07ioo`03
O01oogoo07=oo`0037oo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo
04Qoo`0301moogoo07aoo`03O01oogoo07Aoo`0037oo00<007ooOol00Woo00<007ooOol02Woo00<0
07oo00001Woo00<007ooOol0BGoo00<07gooOol0NGoo0W`0Mgoo000=Ool4000>Ool20006Ool00`00
Oomoo`1:Ool00`0OOomoo`1gOol00g`0Oomoo`1gOol002Moo`03001oogoo04]oo`807gIoo`03O01o
ogoo07Qoo`009goo00<007ooOol0CGoo00<07gooOol0LWoo00=l07ooOol0NGoo000WOol00`00Oomo
o`1>Ool00`0OOomoo`1`Ool00g`0Oomoo`1jOol002Moo`80051oo`0301moogoo06eoo`9l07eoo`00
9goo00<007ooOol0D7oo00<07gooOol0Jgoo00=l07ooOol0OGoo000WOol00`00Oomoo`1AOol201mZ
Ool00g`0Oomoo`1nOol002Moo`03001oogoo05=oo`0301moogoo06Ioo`03O01oogoo07moo`009goo
00<007ooOol0E7oo00<07gooOol0I7oo00=l07ooOol0P7oo000WOol00`00Oomoo`1EOol00`0OOomo
o`1QOol2O023Ool002Moo`03001oogoo05Ioo`0301moogoo05moo`03O01oogoo08=oo`009goo00<0
07ooOol0Egoo0P0OGWoo00=l07ooOol0Q7oo000WOol00`00Oomoo`1IOol00`0OOomoo`1JOol00g`0
Oomoo`25Ool002Moo`8005]oo`0301moogoo05Qoo`03O01oogoo08Ioo`009goo00<007ooOol0Fgoo
00<07gooOol0EGoo0W`0RGoo000WOol00`00Oomoo`1LOol201mDOol00g`0Oomoo`29Ool002Moo`03
001oogoo05ioo`0301moogoo051oo`03O01oogoo08Yoo`009goo00<007ooOol0Ggoo00<07gooOol0
CWoo00=l07ooOol0Rgoo000WOol00`00Oomoo`1POol00`0OOomoo`1<Ool00g`0Oomoo`2<Ool002Mo
o`03001oogoo065oo`0301moogoo04Uoo`9l08moo`009goo00<007ooOol0HWoo0P0OB7oo00=l07oo
Ool0Sgoo000WOol2001UOol00`0OOomoo`14Ool00g`0Oomoo`2@Ool002Moo`03001oogoo06Eoo`03
01moogoo049oo`03O01oogoo095oo`009goo00<007ooOol0IWoo00<07gooOol0?goo0W`0U7oo000W
Ool00`00Oomoo`1WOol00`0OOomoo`0mOol00g`0Oomoo`2DOol002Moo`03001oogoo06Qoo`807cao
o`03O01oogoo09Eoo`009goo00<007ooOol0JWoo00<07gooOol0>7oo00=l07ooOol0UWoo000=Ool4
0005Ool20006Ool30006Ool00`00Oomoo`1[Ool00`0OOomoo`0fOol00g`0Oomoo`2GOol000aoo`03
001oogoo009oo`03001oogoo009oo`8000Eoo`05001oogooOol00005Ool00`00Oomoo`1/Ool00`0O
Oomoo`0cOol2O02JOol000aoo`03001oogoo009oo`03001oogoo00Uoo`05001oogooOol00005Ool0
0`00Oomoo`1]Ool00`0OOomoo`0aOol00g`0Oomoo`2JOol000aoo`03001oogoo009oo`03001oogoo
00Uoo`05001oogooOol00005Ool3001^Ool201l`Ool00g`0Oomoo`2KOol000aoo`03001oogoo009o
o`03001oogoo00Uoo`@000Ioo`03001oogoo071oo`0301moogoo02]oo`9l09ioo`0037oo00<007oo
Ool00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol0LGoo00<07gooOol0:Goo00=l07oo
Ool0WWoo000<Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool00`00Oomoo`1bOol2
01lXOol00g`0Oomoo`2OOol000eoo`@000ioo`<000Eoo`03001oogoo07Aoo`0301moogoo02=oo`9l
0:9oo`009goo00<007ooOol0MGoo00<07gooOol08Goo00=l07ooOol0XWoo000WOol00`00Oomoo`1f
Ool201lPOol00g`0Oomoo`2SOol002Moo`03001oogoo07Qoo`0301moogoo01]oo`9l0:Ioo`009goo
0P00NWoo00<07gooOol06Goo00=l07ooOol0YWoo000WOol00`00Oomoo`1jOol201lHOol00g`0Oomo
o`2WOol002Moo`03001oogoo07aoo`0301moogoo01=oo`9l0:Yoo`009goo00<007ooOol0OGoo0P0O
4Woo00=l07ooOol0ZWoo000WOol00`00Oomoo`1oOol00`0OOomoo`0=Ool2O02]Ool002Moo`03001o
ogoo081oo`0301moogoo00]oo`03O01oogoo0:eoo`009goo00<007ooOol0PGoo0P0O2Goo0W`0/7oo
000WOol00`00Oomoo`23Ool00`0OOomoo`05Ool00g`0Oomoo`2`Ool002Moo`03001oogoo08Aoo`03
01moogoo009oo`9l0;=oo`009goo0P00QWoo0P0O00=oog`0Ool0]7oo000WOol00`00Oomoo`26Ool2
O02fOol002Moo`03001oogoo08Eoo`03O01oogoo00807kAoo`009goo00<007ooOol0Q7oo00=l07oo
Ool00goo00<07gooOol0/Goo000WOol00`00Oomoo`22Ool2O007Ool201naOol002Moo`03001oogoo
085oo`03O01oogoo00Uoo`0301moogoo0:ioo`009goo00<007ooOol0P7oo00=l07ooOol02goo0P0O
[Woo000WOol00`00Oomoo`1nOol2O00@Ool00`0OOomoo`2[Ool002Moo`8007ioo`03O01oogoo015o
o`807j]oo`009goo00<007ooOol0Ngoo0W`05Woo00<07gooOol0Z7oo000WOol00`00Oomoo`1jOol0
0g`0Oomoo`0GOol201nXOol002Moo`03001oogoo07Qoo`9l01aoo`0301moogoo0:Eoo`009goo00<0
07ooOol0MWoo0W`07goo0P0OYGoo000WOol00`00Oomoo`1eOol00g`0Oomoo`0QOol201nSOol000eo
o`@000Eoo`8000Eoo`@000Ioo`03001oogoo07=oo`9l02Ioo`0301moogoo0:1oo`0037oo00<007oo
Ool00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0LWoo
00=l07ooOol09goo0P0OX7oo000<Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`1`Ool2O00/Ool00`0OOomoo`2MOol000aoo`03001oogoo009oo`03
001oogoo00Qoo`03001oogoo009oo`03001oogoo00=oo`<006ioo`9l02moo`807ieoo`0037oo00<0
07ooOol00Woo00<007ooOol02Goo10001Woo00<007ooOol0K7oo0W`0<goo0P0OVgoo000<Ool00`00
Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`1[Ool00g`0
Oomoo`0eOol201nIOol000aoo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo06Uoo`9l03Yoo`807iMoo`003Goo100037oo10001Woo00<007ooOol0Igoo
0W`0?Woo0P0OUGoo000WOol00`00Oomoo`1UOol2O012Ool201nCOol002Moo`03001oogoo06=oo`9l
04Ioo`807i5oo`009goo00<007ooOol0HGoo0W`0BWoo0P0OSgoo000WOol00`00Oomoo`1OOol2O01>
Ool201n=Ool002Moo`8005ioo`9l059oo`807h]oo`009goo00<007ooOol0Fgoo0W`0EWoo0P0ORGoo
000WOol00`00Oomoo`1IOol2O01JOol301n6Ool002Moo`03001oogoo05Moo`9l05moo`807hAoo`00
9goo00<007ooOol0EGoo0W`0Hgoo0P0OPWoo000WOol00`00Oomoo`1COol2O01WOol201n0Ool002Mo
o`03001oogoo055oo`9l06]oo`807gioo`009goo00<007ooOol0CWoo0g`0Kgoo0`0ONgoo000WOol2
001=Ool2O01eOol201miOol002Moo`03001oogoo04Uoo`=l07Uoo`807gMoo`009goo00<007ooOol0
Agoo0W`0OWoo0`0OM7oo000WOol00`00Oomoo`15Ool2O023Ool201mbOol002Moo`03001oogoo049o
o`=l08Moo`<07fmoo`009goo00<007ooOol0?goo0g`0SGoo0`0OK7oo000WOol00`00Oomoo`0lOol3
O02COol201mZOol002Moo`03001oogoo03Uoo`=l09Qoo`<07fMoo`009goo00<007ooOol0=Woo0g`0
WWoo0`0OI7oo000WOol2000cOol4O02TOol401mPOol002Moo`03001oogoo02ioo`Al0:aoo`@07eao
o`009goo00<007ooOol0:Woo17`0]7oo100OF7oo000WOol00`00Oomoo`0VOol4O02lOol401mDOol0
02Moo`03001oogoo029oo`Al0<Aoo`@07e1oo`007Goo1@001Goo00<007ooOol07Goo1G`0c7oo1@0O
Bgoo000OOol00`00Oomoo`05Ool00`00Oomoo`0HOol5O03FOol501m6Ool001moo`03001oogoo00Eo
o`03001oogoo00eoo`]l0>1oo`/07c]oo`007goo00<007ooOol01Goo47`0mWoo400O:goo000OOol0
0`00Oomoo`05Ool00`00Oomoo`3oOoloOol001moo`03001oogoo00Eoo`03001oogoo0?moocmoo`00
7Goo0`001goo00<007ooOol0ogoo?goo000OOol00`00Oomoo`05Ool00`00Oomoo`3oOoloOol00?mo
ofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo
003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`007goo00<007ooOol0ogooAgoo
000OOol2003oOom8Ool001Aoo`H000Ioo`03001oogoo00Eoo`H00?mooc]oo`005Woo00<007ooOol0
1goo0P0027oo00<007ooOol0ogoo?7oo000FOol00`00Oomoo`0AOol00`00Oomoo`3oOollOol001Io
o`03001oogoo015oo`03001oogoo0?moocaoo`005Woo00<007ooOol04Goo00<007ooOol01goo00<0
07ooOol0ogoo<Woo000DOol6000>Ool60006Ool00`00Oomoo`3oOolbOol001Ioo`03001oogoo015o
o`03001oogoo00Moo`03001oogoo0?mooc9oo`005goo0`004Goo0`001Woo00<007ooOol0ogoo<Woo
003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?mo
ofUoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.313, 0}} -> {-0.224207, -0.0869725, \
0.00709105, 0.0073043}}]
}, Open  ]],

Cell[TextData[{
  "The figure shows us the derived behavior of the slope in a more compact \
way. The slope of sin[",
  StyleBox["x",
    FontSlant->"Italic"],
  "] starts with the value 1 at ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  " and finishes with 0 at ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "= \[Pi]/2. "
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "Knowing the geometrical meaning of differentiation, we can ask for \
additional properties of this operation. In the following, we will discuss \
some of these properties. We only state a few of these features known by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". One of these properties is the product rule which governs the \
differentiation of a product of functions, ",
  StyleBox["e.g.,\[ThinSpace]",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" f",
    FontSlant->"Italic"],
  " and ",
  StyleBox["g",
    FontSlant->"Italic"],
  ". The product rule is implemented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and automatically applied to products of functions:"
}], "Text",
  Evaluatable->False,
  CellTags->"differentiation of a product"],

Cell[BoxData[
    \(Clear[f, g]\)], "Input",
  PageWidth->Infinity],

Cell[CellGroupData[{

Cell[BoxData[
    \(prule = \[PartialD]\_x\((f[x]\ g[x])\) // LieTraditionalForm\)], "Input",\

  PageWidth->Infinity],

Cell[BoxData[
    \(g\ f\_x + f\ g\_x\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result represents the expected relation which is known from standard \
texts in calculus. Another feature of derivatives is the rule for rational \
functions. The differentiation of the ratio ",
  StyleBox["f[x]/g[x]",
    FontSlant->"Italic"],
  " gives "
}], "Text",
  CellTags->{"rational function", "differentiation of the ratio"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(qrule = 
      Simplify[\[PartialD]\_x\( f[x]\/g[x]\)] // LieTraditionalForm\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\(g\ f\_x - f\ g\_x\)\/g\^2\)], "Output"]
}, Open  ]],

Cell["\<\
which is the standard formula. The chain rule of Leibniz is useful \
in differentiating nested functions \
\>", "Text",
  Evaluatable->False,
  CellTags->"chain rule of Leibniz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(crule = \[PartialD]\_x f[g[x]] // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f\_g\ g\_x\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which indicates that we first differentiate the function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to ",
  StyleBox["g",
    FontSlant->"Italic"],
  " followed by a differentiation of ",
  StyleBox["g",
    FontSlant->"Italic"],
  " with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The properties stated above and more are known by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to manage the calculation of differentials."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "In symmetry analysis, we frequently have to deal with functions depending \
on several independent variables. A function of a set of variables can be \
differentiated with respect to one of these variables at a time. The rest of \
the independent variables will stay unchanged in this calculation. The slope \
of a function of several variables is not just a single function, since the \
independent variables may vary in different ways. All the rates of change for \
a function of ",
  StyleBox["m",
    FontSlant->"Italic"],
  " variables are described by ",
  StyleBox["m",
    FontSlant->"Italic"],
  " functions, called its partial derivatives. In the discussion above, we \
introduced the definition of the derivative known as an ordinary derivative \
which is defined for functions depending on a single independent variable. \
The more generic case is that we have functions depending on several \
independent variables. The partial derivatives of a function of several \
variables are its ordinary derivatives with respect to each variable \
separately. We can define this as follows:"
}], "Text",
  Evaluatable->False,
  CellTags->"partial derivativ"],

Cell["Definition: Partial derivative", "Definition",
  CellTags->"Definition: Partial derivative"],

Cell[TextData[{
  "Given a smooth function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", ":", " ", 
          
          FormBox[\(\[DoubleStruckCapitalR]\^m\  \[Rule] \ 
              \[DoubleStruckCapitalR]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " depending on ",
  StyleBox["m",
    FontSlant->"Italic"],
  " independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_m\)]],
  ", we define the partial derivative of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to the independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_q\)]],
  " by"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TextForm
    \`\[PartialD]f\/\[PartialD]x\_q\  = 
      \(\(\ lim\)\+\(h \[Rule] 0\)\) 
        \(\((f \((x\_1, x\_2, \[Ellipsis], \ x\_q + h, \ \[Ellipsis], x\_m)
                      \)\  - f 
                    \((x\_1, x\_2, \[Ellipsis], \ x\_q, \ \[Ellipsis], x\_m)
                      \))\)\/h\) . \[ThickSpace]\[EmptyCircle]\)], 
  "NumberedEquation",
  FontVariations->{"CompatibilityType"->0}],

Cell[TextData[{
  "This formula allows us to calculate the variation of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "with respect to different coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`x\_q\)]],
  ". The partial derivative of a function is an operation known by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The partial derivative is accessible under the same pattern ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_\[Placeholder]\ \[Placeholder]\)]],
  ". Although we can access partial derivatives and ordinary derivatives by \
the same symbol ",
  StyleBox["D[]", "MmaText"],
  ", ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "is capable of distinguishing the different operations. Consider, for \
example, a function ",
  Cell[BoxData[
      \(TraditionalForm\`f = f(x\_1, x\_2)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "of two variables.",
  StyleBox[" ",
    FontSlant->"Italic"],
  "If we treat",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  " as a constant, ",
  StyleBox["f",
    FontSlant->"Italic"],
  " may be ",
  "differentiated",
  " with respect to\[NonBreakingSpace]\[NoBreak]",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ". The result is called a partial derivative of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we carry out this by"
}], "Text",
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"partial derivative", "D[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_\(x\_1\)f[x\_1, x\_2] // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f\_\(x\_1\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting symbol for the representation of a partial derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a superscripted expression of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". The superscripts denote the order of differentiation with respect to the \
independent variables. In our example, we get the first derivative with \
respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ". The derivative with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  " follows in the same way by "
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[
      RowBox[{
        RowBox[{\(\[PartialD]\_\(x\_2\)\), 
          RowBox[{"f", "[", 
            RowBox[{\(x\_1\), ",", 
              StyleBox[\(x\_2\),
                FontColor->GrayLevel[0]]}], "]"}]}], 
        StyleBox[
          RowBox[{
            StyleBox["/",
              FontColor->GrayLevel[0]], "/"}]], "LieTraditionalForm"}],
      FontColor->RGBColor[0, 0, 1]]], "Input"],

Cell[BoxData[
    \(f\_\(x\_2\)\)], "Output"]
}, Open  ]],

Cell["\<\
The combination of both operations allows us to calculate \
higher-order derivatives\
\>", "Text",
  Evaluatable->False,
  CellTags->"higher order derivatives"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{\(\[PartialD]\_\(x\_1, x\_2\)\), 
        RowBox[{"f", "[", 
          RowBox[{
            StyleBox[\(x\_1\),
              FontColor->GrayLevel[0]], ",", 
            StyleBox[\(x\_2\),
              FontColor->GrayLevel[0]]}], "]"}]}], "//", 
      "LieTraditionalForm"}]], "Input"],

Cell[BoxData[
    \(f\_\(x\_1, x\_2\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Higher-order derivatives follow by carrying out the differentiation with \
respect to different variables. The calculation of higher derivatives is done \
for functions with only one independent variable in a similar way. Since both \
operations are nearly identical, here we will give only the definition for \
the case with more than one independent variable. The one-dimensional case is \
included in this definition. The ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th-order derivative is defined as follows:"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "Definition: ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th-Order derivative"
}], "Definition",
  CellTags->"Definition: kth order derivative"],

Cell[TextData[{
  "Given a smooth function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", ":", " ", 
          
          FormBox[\(\[DoubleStruckCapitalR]\^m \[Rule] 
              \[DoubleStruckCapitalR]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " depending on ",
  StyleBox["m",
    FontSlant->"Italic"],
  " independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_q\)]],
  ", we call"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\[PartialD]\^k f \((x)\)\)\/\(\[PartialD]x\_\(j\_1\) 
          \[PartialD]x\_\(j\_2\) \[Ellipsis] \[PartialD]x\_\(j\_k\)\) := \ 
      \[PartialD]\_J f \((x)\), \)\)], "NumberedEquation"],

Cell[TextData[{
  "the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th-order partial derivative of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to the ",
  StyleBox["m",
    FontSlant->"Italic"],
  " independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The non-sorted multi-index ",
  StyleBox["J",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\( = \((j\_1\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(, j\)\_2\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(, \[Ellipsis], j\_k\)\)]],
  ") denotes the derivative with respect to one of the ",
  StyleBox["m",
    FontSlant->"Italic"],
  " coordinates. The integers ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] j\_k \[LessEqual] m\)]],
  " of this ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-tuple indicate which derivatives are being taken. The order of \
differentiation ",
  StyleBox["k",
    FontSlant->"Italic"],
  " is equivalent to the sum of all indices ",
  Cell[BoxData[
      \(TraditionalForm\`j\_k\)]],
  ", which we denote by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"|", 
          RowBox[{\(J | \), " ", "=", " ", 
            FormBox[\(\[Sum]\_\(i = 1\)\%k j\_i\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ".\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False,
  CellTags->{"partial derivative", "order of differentiation"}],

Cell[TextData[{
  "Using this definition, we are able to calculate, for example, the \
second-order derivative of the function ",
  StyleBox["f. ",
    FontSlant->"Italic"],
  " The calculation of the partial derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is as simple as the application of the ordinary derivative even for \
higher-order derivatives. For example, the sixth",
  StyleBox["-",
    FontSlant->"Italic"],
  "order derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is derived  by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_\({x1, 2}, {x2, 4}\)f[x1, x2] // LieTraditionalForm\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f\_\(x1, x1, x2, x2, x2, x2\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "So far, we discussed simple examples of derivatives already implemented in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The following sections will illustrate how special types of derivatives \
are implemented. We will discuss tangent vectors, vector fields, \
Fr\[EAcute]chet derivatives, prolongations of vector fields, and variational \
derivatives also known as Euler derivatives. The special types of derivatives \
we are going to discuss are useful in examining symmetries of differential \
equations."
}], "Text",
  Evaluatable->False,
  CellTags->{"variational derivative", "Euler derivative"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2 Tangent Vector", "Section",
  Evaluatable->False,
  CellTags->"tangent vector"],

Cell[TextData[{
  "Sometimes it is important to know how a real-valued function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", ":", " ", 
          
          FormBox[\(\[DoubleStruckCapitalR]\^n \[Rule] 
              \[DoubleStruckCapitalR]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " varies in different directions. The partial derivative discussed above \
only measures how much\[NonBreakingSpace]\[NoBreak]",
  StyleBox["f",
    FontSlant->"Italic"],
  " changes in a certain direction. However, it is also possible to measure \
the variation of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " in other directions. Measuring the variation of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at a location ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", " ", "\[Element]", " ", 
          FormBox[\(\[DoubleStruckCapitalR]\^m\),
            "TraditionalForm"]}], TraditionalForm]]],
  " along a straight line ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = ",
  StyleBox["x",
    FontSlant->"Italic"],
  " + ",
  StyleBox["t",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  ", we need the tangent vector ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  ". Since we are dealing with differential operators, we define the tangent \
vector as an operator acting in the space of functions. Actually, a tangent \
vector is a vector with a cetrain direction and a finite length. However, in \
view of the application in symmetry analysis, let us define such an \
operator."
}], "Text",
  Evaluatable->False,
  CellTags->{"measure", "tangent vector", "symmetry analysis"}],

Cell["Definition: Tangent vector", "Definition",
  CellTags->"Definition: Tangent vector"],

Cell[TextData[{
  "We assume that",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(f : \[DoubleStruckCapitalR]\^m\),
              "TraditionalForm"], "\[Rule]", "\[DoubleStruckCapitalR]"}], 
          " "}], TraditionalForm]]],
  "is a smooth differentiable function. The tangent vector ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  " is defined by the relation"
}], "Text",
  Evaluatable->False,
  CellTags->"tangent vector"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(v\&\[RightVector]\_x\),
              "TraditionalForm"], \((f)\)}], " ", "=", " ", 
          FormBox[
            RowBox[{
              FractionBox["d", 
                StyleBox["dt",
                  FontSlant->"Italic"]], 
              \((f(x\&\[RightVector]\  + \ t\ x\&\[RightVector]\_0)
                  \( | \_\(t = 0\)\)\)}],
            "TraditionalForm"]}], ","}], TraditionalForm]], "NumberedEquation",\

  Evaluatable->False,
  FontVariations->{"CompatibilityType"->0},
  CellTags->"eq-4"],

Cell[TextData[{
  "where",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(x\_0\),
              "TraditionalForm"], " ", "\[Element]", "  ", 
            FormBox[\(\[DoubleStruckCapitalR]\^n\),
              "TraditionalForm"]}], " "}], TraditionalForm]]],
  "and ",
  StyleBox["t",
    FontSlant->"Italic"],
  " is a real parameter.\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False],

Cell["\<\
This definition is known as directional derivative in calculus. A \
more explicit way to write the definition is given by\
\>", "Text",
  Evaluatable->False,
  CellTags->"directional derivative"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  "(f) = ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderscriptBox[
            FormBox[\(lim\+\(\  \)\),
              "TraditionalForm"], \(t \[Rule] 0\)], 
          
          StyleBox[
            \(\(f(x\&\[RightVector] + t\ x\&\[RightVector]\_0)\  - \ 
                  f(x\&\[RightVector])\)\/t\),
            ScriptLevel->0]}], TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-5"],

Cell[TextData[{
  "Relation (3.5) is more convenient in comparison with the definition of an \
ordinary derivative. On the other hand, equation ",
  ButtonBox["(3.4)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  " is more useful in the implementation of the tangent vector in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Although the second definition (3.5) is based on a complicated \
mathematical process involving the determination of a limit, the first \
expression is easier to handle symbolically. The reason is that equation \
(3.4) contains basic operations like an ordinary differentiation and a \
substitution. Both of these operations are easily handled by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not know how to calculate the tangent vector of a function, we must \
define an operator which handles this kind of calculation. Let us now examine \
equation ",
  ButtonBox["(3.4)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  " in more detail to see how an implementation can be based on it. In the \
calculation of the tangent vector for an arbitrary function ",
  StyleBox["f,",
    FontSlant->"Italic"],
  " we need to know the function ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "itself, the independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  ", and the support point ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\_0\)]],
  ". We use these three components as input parameters for our function ",
  StyleBox["TangentVector[]", "MmaText"],
  ". We define the function ",
  StyleBox["TangentVector[] in", "MmaText"],
  " the following way:"
}], "Text",
  Evaluatable->False,
  CellTags->{"operator", "independent variables", "input", "TangentVector[]"}],

Cell[BoxData[
    \(TangentVector[f_, x_List, x0_List] := \n\t
      Block[{rule, res, t}, \n\t\trule = Thread[x \[Rule] x + t\ x0]; \n\t\t
        res = f /. rule; \n\t\tres = \[PartialD]\_t res /. t \[Rule] 0]\)], 
  "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "These few lines closely follow the definition given in equation ",
  ButtonBox["(3.4)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  ". The lines just state that the original argument is replaced by a new \
argument and that after the replacement, a differentiation with respect to \
the  parameter ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " takes place. At the end of the calculation ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " is replaced by zero. The actual calculation is reduced to an ordinary \
differentiation with respect to a parameter. All other operations are \
replacements given as a transformation of the argument and as a side \
condition. The definition given in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is capable of reproducing the general formula in ",
  ButtonBox["(3.4)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  " at a certain point ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\_0\)]],
  ". As an example, we demonstrate here the calculation for a function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " depending on four independent variables:"
}], "Text",
  Evaluatable->False,
  CellTags->"ordinary differentiation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TangentVector[
        f[x1, x2, x3, x4], {x1, x2, x3, x4}, {x10, x20, x30, x40}] // 
      LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(x10\ f\_x1 + x20\ f\_x2 + x30\ f\_x3 + x40\ f\_x4\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "As expected, the result of our calculation is a sum of four products. Each \
product consists of a partial derivative with respect to the coordinate ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["x", 
          StyleBox["q",
            FontWeight->"Plain",
            FontSlant->"Italic",
            FontTracking->"Plain",
            FontVariations->{"Underline"->False,
            "Outline"->False,
            "Shadow"->False,
            "StrikeThrough"->False,
            "Masked"->False,
            "CompatibilityType"->0,
            "RotationAngle"->0}]], TraditionalForm]]],
  " and the component ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(0\_q\)\)]],
  " of the related location. Similar to the ordinary differentiation, the \
function ",
  StyleBox["TangentVector[]", "MmaText"],
  " satisfies some additional properties. Some of these algebraic features of \
the directional derivative are listed below. Let us assume that we have two \
real numbers ",
  StyleBox["a",
    FontSlant->"Italic"],
  " and",
  StyleBox[" b",
    FontSlant->"Italic"],
  " and two independent functions ",
  StyleBox["f",
    FontSlant->"Italic"],
  " and ",
  StyleBox["g",
    FontSlant->"Italic"],
  ". Then, we can show that the relation"
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TangentVector[a\ f[x1, x2] + b\ g[x1, x2], {x1, x2}, {x10, x20}] == \n\t
      a\ TangentVector[f[x1, x2], {x1, x2}, {x10, x20}] + \n\t\t
        b\ TangentVector[g[x1, x2], {x1, x2}, {x10, x20}]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "is satisfied. This behavior of the tangent vector is known as linearity. \
Thus, we can say that ",
  StyleBox["TangentVector[]", "MmaText"],
  " is a linear operator. The application of ",
  StyleBox["TangentVector[]", "MmaText"],
  " on a product gives us"
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TangentVector[f[x1, x2]\ g[x1, x2], \n\t{x1, x2}, {x10, x20}]\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(g[x1, x2]\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"x20", " ", 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}], "+", 
            RowBox[{"x10", " ", 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], 
          ")"}]}], "+", 
      RowBox[{\(f[x1, x2]\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"x20", " ", 
              RowBox[{
                SuperscriptBox["g", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}], "+", 
            RowBox[{"x10", " ", 
              RowBox[{
                SuperscriptBox["g", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], 
          ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is just the scalar product of the vector ",
  StyleBox["(f, g)",
    FontSlant->"Italic"],
  " with a vector containing the two tangent vectors of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " and ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "as elements. There is also a chain rule for the tangent vector similar to \
the case of ordinary differentiation. For example, let ",
  Cell[BoxData[
      \(TraditionalForm\`g\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`g\_2\)]],
  " be two differentiable functions depending on ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  ". For a function ",
  StyleBox["F",
    FontSlant->"Italic"],
  " given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"scalar product", "tangent vector"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = F[g1[x1, x2], g2[x1, x2]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(F[g1[x1, x2], g2[x1, x2]]\)], "Output"]
}, Open  ]],

Cell["we can derive the tangent vector in the form", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(TangentVector[f, {x1, x2}, {x10, x20}] // LieTraditionalForm\)], "Input",\

  PageWidth->Infinity],

Cell[BoxData[
    \(F\_g1\ \((x10\ g1\_x1 + x20\ g1\_x2)\) + 
      F\_g2\ \((x10\ g2\_x1 + x20\ g2\_x2)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is a superposition of the vector field of ",
  Cell[BoxData[
      \(TraditionalForm\`g\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`g\_2\)]],
  " multiplied by the derivatives of ",
  StyleBox["F",
    FontSlant->"Italic"],
  ". As we demonstrated, all these properties are immediately available \
without any additional definitions. This behavior is actually based on the \
implementation of the derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->"superposition"],

Cell[TextData[{
  "The name used for our function to calculate the tangent vector of a given \
function is somewhat misleading. Actually, we calculate a scalar product of \
the tangent vector and a support vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\_0\)]],
  " using our function. In some calculations, however, it is necessary to \
have the vector components of the tangent vector available. Such an \
application, for example, is the calculation of the tangent surface on a \
hypersurface. "
}], "Text",
  Evaluatable->False,
  CellTags->{"components of the tangent vector", "tangent surface"}],

Cell[TextData[{
  "The components of the tangent vector ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  " become available by altering ",
  StyleBox["TangentVector[]", "MmaText"],
  " in an appropriate way. The following lines generalize the function in \
such a way that the result of the calculation is a vector of differentials \
applied to a function. We also assume in our definition that the support \
point is arbitrary and thus can be created by the operator ",
  StyleBox["TangentVector[]", "MmaText"],
  " itself:"
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[BoxData[
    \(TangentVector[f_, x_List] := 
      Block[{rule, res, t}, \n\t\t
        x0 = Table[Unique["\<$aU\>"], \n\t\t\t\t{i, 1, Length[x]}]; \n\t\t
        rule = Thread[x \[Rule] x + t\ x0]; \n\t\tres = f /. rule; \n\t\t
        res = \[PartialD]\_t res /. t \[Rule] 0; \n\t\t
        Table[Coefficient[res, x0\[LeftDoubleBracket]i\[RightDoubleBracket]], 
          \n\t\t\t{i, 1, Length[x0]}]]\)], "Input"],

Cell[TextData[{
  "The application of the function ",
  StyleBox["TangentVector[]", "MmaText"],
  " on a function ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "depending on three independent variables gives us"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[f]; \n
    TangentVector[f[x1, x2, x3], {x1, x2, x3}] // LieTraditionalForm\)], 
  "Input"],

Cell[BoxData[
    \({f\_x1, f\_x2, f\_x3}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is, in fact, the gradient of the scalar function ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". We note that the function ",
  StyleBox["TangentVector[]", "MmaText"],
  " needs only two arguments, the function ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "and a list of independent variables. "
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[TextData[{
  "For some applications in geometry and physics, we need to calculate the \
tangent surface of a given function. Recalling the definition of the tangent \
of a function given at the beginning of this section, we generalize this \
one-dimensional definition to a two-dimensional version. Using the vector \
representation of the tangent vector at a certain point ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  " for the two-dimensional case, we can represent the tangent surface by"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(f\_s\),
                "TraditionalForm"], " ", "=", " ", 
              FormBox[
                RowBox[{
                  FormBox[\(f(x\_0\),
                    "TraditionalForm"], ",", \(y\_0\)}],
                "TraditionalForm"]}], ")"}], " ", "+", " ", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                FormBox[\(x\&\[RightVector]\),
                  "TraditionalForm"], "-", 
                FormBox[\(x\&\[RightVector]\_0\),
                  "TraditionalForm"]}], ")"}], " ", "\[CenterDot]", " ", 
            FormBox[
              RowBox[{
                FormBox[\(v\&\[RightVector]\_x\),
                  "TraditionalForm"], \((f)\)}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  ","
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "representing the sum of the function at the support point ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_0, y\_0)\)\)]],
  " and the scalar product of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            FormBox[\(x\&\[RightVector]\),
              "TraditionalForm"], "-", 
            FormBox[\(x\&\[RightVector]\_0\),
              "TraditionalForm"]}], ")"}], TraditionalForm]]],
  " and the tangent vector. Similar to the definition of a tangent vector, we \
can implement a tangent surface by"
}], "Text",
  Evaluatable->False,
  CellTags->"tangent surface"],

Cell[BoxData[
    \(Clear[TangentSurface]; \n
    TangentSurface[f_, x_List, x0_List] := \n\t
      Block[{rule, tvector, sf, surface}, \n\t\trule = Thread[x \[Rule] x0]; 
        \n\t\ttvector = TangentVector[f, x]; \n\t\tsf = f /. rule; \n\t\t
        surface = sf + \((x - x0)\) . tvector]\)], "Input",
  PageWidth->Infinity,
  CellTags->"TangentSurface[]"],

Cell[TextData[{
  "Using the function ",
  StyleBox["TangentSurface[]", "MmaText"],
  ", we can determine the tangent space located at ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " of a given function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". As an example, let us consider a function ",
  StyleBox["h",
    FontSlant->"Italic"],
  " in a two-dimensional space with coordinates ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  CellTags->"TangentSurface[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(h = Sin[x]\ Cos[y]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(Cos[y]\ Sin[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["h",
    FontSlant->"Italic"],
  "[",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  "] has the graphical representation"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(pl1 = 
      Plot3D[h, {x, \(-\[Pi]\), \[Pi]\/2}, {y, \(-\[Pi]\), \[Pi]}, 
        AxesLabel \[Rule] {"\<x\>", "\<y\>", "\<h\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.55112e-017 1.04977 -0.0679587 1.04977 [
[.04501 .23932 -12 -8.75252 ]
[.04501 .23932 0 .24748 ]
[.17172 .18945 -11.8183 -9 ]
[.17172 .18945 .18174 0 ]
[.30499 .13702 -11.2873 -9 ]
[.30499 .13702 .71266 0 ]
[.44535 .08183 -5.37821 -9 ]
[.44535 .08183 .62179 0 ]
[.59338 .02365 -5.11275 -9 ]
[.59338 .02365 .88725 0 ]
[.29165 .07573 -9.31117 -12.875 ]
[.29165 .07573 .68883 0 ]
[.76162 .0881 0 -6.17057 ]
[.76162 .0881 12 2.82943 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.93925 .36012 0 -5.91342 ]
[.93925 .36012 6 3.08658 ]
[.91861 .21225 0 -8.62807 ]
[.91861 .21225 10 4.24693 ]
[.02411 .26511 -12 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -18 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[-0.05457 .39542 -10 -4.05332 ]
[-0.05457 .39542 0 8.82168 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.03716 .25514 m
.68874 0 L
s
.05455 .24833 m
.05931 .25284 L
s
[(-3)] .04501 .23932 1 .945 Mshowa
.18085 .19887 m
.18542 .20358 L
s
[(-2)] .17172 .18945 .96971 1 Mshowa
.31367 .14687 m
.318 .15179 L
s
[(-1)] .30499 .13702 .88122 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(0)] .44535 .08183 .79274 1 Mshowa
.60094 .03438 m
.60471 .03974 L
s
[(1)] .59338 .02365 .70425 1 Mshowa
.125 Mabswid
.07931 .23863 m
.08215 .24136 L
s
.10432 .22884 m
.10713 .23159 L
s
.12958 .21895 m
.13237 .22173 L
s
.15509 .20896 m
.15785 .21176 L
s
.20688 .18868 m
.20959 .19153 L
s
.23317 .17839 m
.23586 .18126 L
s
.25973 .16799 m
.26239 .17089 L
s
.28656 .15748 m
.28919 .16041 L
s
.34105 .13614 m
.34363 .13912 L
s
.36873 .12531 m
.37127 .12831 L
s
.39669 .11436 m
.3992 .11739 L
s
.42495 .10329 m
.42743 .10635 L
s
.48236 .08081 m
.48477 .08392 L
s
.51153 .06939 m
.51391 .07253 L
s
.54101 .05784 m
.54335 .06101 L
s
.57081 .04618 m
.57312 .04937 L
s
.63139 .02246 m
.63362 .0257 L
s
.66218 .0104 m
.66436 .01367 L
s
gsave
.29165 .07573 -70.3112 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.74932 .09266 m
.74316 .09495 L
s
[(-2)] .76162 .0881 -1 .37124 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.92673 .36405 m
.92047 .36602 L
s
[(2)] .93925 .36012 -1 .31409 Mshowa
.125 Mabswid
.77428 .13086 m
.77058 .1322 L
s
.79837 .1677 m
.79466 .16902 L
s
.82162 .20326 m
.8179 .20455 L
s
.86578 .27081 m
.86204 .27206 L
s
.88677 .30292 m
.88302 .30414 L
s
.90707 .33398 m
.90332 .33518 L
s
.72342 .05305 m
.71974 .05445 L
s
.69654 .01193 m
.69287 .01336 L
s
.94577 .39318 m
.94201 .39434 L
s
.96423 .4214 m
.96046 .42254 L
s
gsave
.91861 .21225 -61 -12.6281 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(-1)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(-0.5)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.5)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40054 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43642 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
gsave
-0.05457 .39542 -71 -8.05332 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 56.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 56.000000 4.000000 lineto
 56.000000 16.875000 lineto
closepath
clip newpath
57.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
57.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
0 .381 .827 r
.37901 .68206 .40169 .70185 .43867 .72499 .4162 .70177 Metetra
.145 .484 .9 r
.4162 .70177 .43867 .72499 .47696 .745 .45467 .71857 Metetra
.362 .576 .922 r
.45467 .71857 .47696 .745 .51651 .75812 .49439 .72909 Metetra
.527 .636 .901 r
.49439 .72909 .51651 .75812 .55708 .76125 .53516 .73054 Metetra
.636 .672 .868 r
.53516 .73054 .55708 .76125 .59834 .75246 .57669 .7212 Metetra
.709 .697 .837 r
.57669 .7212 .59834 .75246 .63987 .7313 .6186 .70067 Metetra
.759 .718 .815 r
.6186 .70067 .63987 .7313 .68129 .69895 .66054 .66999 Metetra
.794 .739 .802 r
.66054 .66999 .68129 .69895 .72236 .65799 .70226 .63148 Metetra
.819 .761 .798 r
.70226 .63148 .72236 .65799 .763 .61197 .74368 .58832 Metetra
.834 .786 .805 r
.74368 .58832 .763 .61197 .80334 .56486 .78489 .5441 Metetra
.838 .812 .825 r
.78489 .5441 .80334 .56486 .8437 .52056 .82616 .50235 Metetra
.825 .839 .858 r
.82616 .50235 .8437 .52056 .88455 .48246 .86791 .46617 Metetra
.784 .859 .905 r
.86791 .46617 .88455 .48246 .92646 .45313 .91066 .43795 Metetra
.701 .856 .956 r
.91066 .43795 .92646 .45313 .97003 .43424 .95495 .41922 Metetra
.253 .583 .945 r
.35573 .66174 .37901 .68206 .4162 .70177 .39341 .67182 Metetra
.431 .583 .903 r
.39341 .67182 .4162 .70177 .45467 .71857 .43217 .67972 Metetra
.529 .574 .845 r
.43217 .67972 .45467 .71857 .49439 .72909 .47202 .68316 Metetra
.588 .573 .804 r
.47202 .68316 .49439 .72909 .53516 .73054 .51283 .68027 Metetra
.631 .581 .78 r
.51283 .68027 .53516 .73054 .57669 .7212 .5544 .6699 Metetra
.667 .597 .768 r
.5544 .6699 .57669 .7212 .6186 .70067 .59648 .65179 Metetra
.699 .621 .767 r
.59648 .65179 .6186 .70067 .66054 .66999 .63883 .62663 Metetra
.73 .655 .775 r
.63883 .62663 .66054 .66999 .70226 .63148 .68126 .59595 Metetra
.761 .701 .795 r
.68126 .59595 .70226 .63148 .74368 .58832 .72369 .56189 Metetra
.791 .765 .829 r
.72369 .56189 .74368 .58832 .78489 .5441 .76619 .5269 Metetra
.811 .848 .877 r
.76619 .5269 .78489 .5441 .82616 .50235 .80891 .49347 Metetra
.789 .939 .927 r
.80891 .49347 .82616 .50235 .86791 .46617 .85216 .46381 Metetra
.65 .964 .917 r
.85216 .46381 .86791 .46617 .91066 .43795 .8963 .43964 Metetra
.387 .846 .801 r
.8963 .43964 .91066 .43795 .95495 .41922 .94172 .42211 Metetra
.559 .723 .95 r
.33183 .64088 .35573 .66174 .39341 .67182 .37031 .63697 Metetra
.597 .63 .854 r
.37031 .63697 .39341 .67182 .43217 .67972 .40956 .63213 Metetra
.61 .578 .793 r
.40956 .63213 .43217 .67972 .47202 .68316 .44959 .62554 Metetra
.618 .553 .758 r
.44959 .62554 .47202 .68316 .51283 .68027 .49038 .61659 Metetra
.627 .544 .742 r
.49038 .61659 .51283 .68027 .5544 .6699 .53184 .60489 Metetra
.637 .548 .738 r
.53184 .60489 .5544 .6699 .59648 .65179 .57392 .59035 Metetra
.65 .564 .745 r
.57392 .59035 .59648 .65179 .63883 .62663 .61652 .57319 Metetra
.667 .595 .765 r
.61652 .57319 .63883 .62663 .68126 .59595 .65959 .55392 Metetra
.689 .647 .803 r
.65959 .55392 .68126 .59595 .72369 .56189 .7031 .53327 Metetra
.713 .733 .866 r
.7031 .53327 .72369 .56189 .76619 .5269 .74707 .51208 Metetra
.717 .864 .951 r
.74707 .51208 .76619 .5269 .80891 .49347 .79157 .49126 Metetra
.567 .932 .924 r
.79157 .49126 .80891 .49347 .85216 .46381 .8367 .47163 Metetra
.8367 .47163 .85216 .46381 .8963 .43964 .88263 .45384 Metetra
.06 0 0 r
.88263 .45384 .8963 .43964 .94172 .42211 .92949 .43834 Metetra
.721 .764 .887 r
.30728 .61945 .33183 .64088 .37031 .63697 .34685 .59994 Metetra
.691 .658 .813 r
.34685 .59994 .37031 .63697 .40956 .63213 .38679 .58109 Metetra
.663 .594 .768 r
.38679 .58109 .40956 .63213 .44959 .62554 .42713 .56365 Metetra
.643 .557 .742 r
.42713 .56365 .44959 .62554 .49038 .61659 .46791 .5482 Metetra
.628 .535 .731 r
.46791 .5482 .49038 .61659 .53184 .60489 .50923 .53509 Metetra
.617 .527 .73 r
.50923 .53509 .53184 .60489 .57392 .59035 .55119 .52439 Metetra
.609 .531 .742 r
.55119 .52439 .57392 .59035 .61652 .57319 .5939 .51589 Metetra
.603 .551 .769 r
.5939 .51589 .61652 .57319 .65959 .55392 .63746 .50911 Metetra
.598 .595 .819 r
.63746 .50911 .65959 .55392 .7031 .53327 .68193 .50337 Metetra
.585 .679 .905 r
.68193 .50337 .7031 .53327 .74707 .51208 .72734 .49781 Metetra
.507 .801 .998 r
.72734 .49781 .74707 .51208 .79157 .49126 .77365 .49152 Metetra
.204 .732 .796 r
.77365 .49152 .79157 .49126 .8367 .47163 .8208 .48364 Metetra
.092 0 0 r
.8208 .48364 .8367 .47163 .88263 .45384 .86867 .47343 Metetra
.195 0 0 r
.86867 .47343 .88263 .45384 .92949 .43834 .91714 .4604 Metetra
.793 .769 .831 r
.28205 .59743 .30728 .61945 .34685 .59994 .32285 .56374 Metetra
.748 .684 .79 r
.32285 .56374 .34685 .59994 .38679 .58109 .36364 .53234 Metetra
.706 .623 .762 r
.36364 .53234 .38679 .58109 .42713 .56365 .40443 .5053 Metetra
.669 .58 .746 r
.40443 .5053 .42713 .56365 .46791 .5482 .44533 .48414 Metetra
.634 .548 .74 r
.44533 .48414 .46791 .5482 .50923 .53509 .48656 .46975 Metetra
.601 .528 .744 r
.48656 .46975 .50923 .53509 .55119 .52439 .5284 .46233 Metetra
.568 .518 .76 r
.5284 .46233 .55119 .52439 .5939 .51589 .57114 .46135 Metetra
.53 .521 .79 r
.57114 .46135 .5939 .51589 .63746 .50911 .61503 .46559 Metetra
.482 .544 .843 r
.61503 .46559 .63746 .50911 .68193 .50337 .66024 .47322 Metetra
.403 .592 .921 r
.66024 .47322 .68193 .50337 .72734 .49781 .70683 .48193 Metetra
.24 .643 .96 r
.70683 .48193 .72734 .49781 .77365 .49152 .75473 .48916 Metetra
0 .563 .744 r
.75473 .48916 .77365 .49152 .8208 .48364 .8037 .49239 Metetra
.156 0 0 r
.8037 .49239 .8208 .48364 .86867 .47343 .8534 .48943 Metetra
.159 0 0 r
.8534 .48943 .86867 .47343 .91714 .4604 .90343 .47876 Metetra
.823 .767 .8 r
.25611 .57479 .28205 .59743 .32285 .56374 .29811 .53105 Metetra
.786 .712 .782 r
.29811 .53105 .32285 .56374 .36364 .53234 .33977 .49088 Metetra
.745 .666 .773 r
.33977 .49088 .36364 .53234 .40443 .5053 .3811 .45715 Metetra
.699 .625 .77 r
.3811 .45715 .40443 .5053 .44533 .48414 .42227 .432 Metetra
.648 .589 .774 r
.42227 .432 .44533 .48414 .48656 .46975 .46358 .41662 Metetra
.59 .557 .786 r
.46358 .41662 .48656 .46975 .5284 .46233 .50542 .41129 Metetra
.522 .53 .805 r
.50542 .41129 .5284 .46233 .57114 .46135 .5482 .41528 Metetra
.44 .509 .833 r
.5482 .41528 .57114 .46135 .61503 .46559 .59231 .42695 Metetra
.339 .496 .868 r
.59231 .42695 .61503 .46559 .66024 .47322 .63801 .44375 Metetra
.216 .495 .901 r
.63801 .44375 .66024 .47322 .70683 .48193 .68543 .46241 Metetra
.084 .507 .902 r
.68543 .46241 .70683 .48193 .75473 .48916 .73446 .47922 Metetra
0 .53 .838 r
.73446 .47922 .75473 .48916 .8037 .49239 .7848 .49039 Metetra
.001 .577 .745 r
.7848 .49039 .8037 .49239 .8534 .48943 .83594 .49261 Metetra
.83594 .49261 .8534 .48943 .90343 .47876 .88728 .48355 Metetra
.831 .765 .79 r
.22944 .55152 .25611 .57479 .29811 .53105 .27233 .50377 Metetra
.812 .747 .792 r
.27233 .50377 .29811 .53105 .33977 .49088 .31475 .4601 Metetra
.781 .727 .803 r
.31475 .4601 .33977 .49088 .3811 .45715 .35667 .42367 Metetra
.736 .705 .822 r
.35667 .42367 .3811 .45715 .42227 .432 .39827 .3968 Metetra
.67 .676 .847 r
.39827 .3968 .42227 .432 .46358 .41662 .43987 .38081 Metetra
.578 .637 .873 r
.43987 .38081 .46358 .41662 .50542 .41129 .48192 .37598 Metetra
.457 .584 .892 r
.48192 .37598 .50542 .41129 .5482 .41528 .52489 .38155 Metetra
.319 .523 .897 r
.52489 .38155 .5482 .41528 .59231 .42695 .56921 .39569 Metetra
.191 .469 .888 r
.56921 .39569 .59231 .42695 .63801 .44375 .61522 .41564 Metetra
.11 .446 .881 r
.61522 .41564 .63801 .44375 .68543 .46241 .66308 .43776 Metetra
.1 .474 .894 r
.66308 .43776 .68543 .46241 .73446 .47922 .71272 .45791 Metetra
.175 .559 .933 r
.71272 .45791 .73446 .47922 .7848 .49039 .7638 .47183 Metetra
.329 .686 .98 r
.7638 .47183 .7848 .49039 .83594 .49261 .81579 .47575 Metetra
.52 .81 .998 r
.81579 .47575 .83594 .49261 .88728 .48355 .868 .46699 Metetra
.823 .767 .8 r
.202 .52757 .22944 .55152 .27233 .50377 .2453 .48265 Metetra
.822 .789 .821 r
.2453 .48265 .27233 .50377 .31475 .4601 .28819 .44136 Metetra
.807 .813 .856 r
.28819 .44136 .31475 .4601 .35667 .42367 .33064 .4066 Metetra
.764 .834 .905 r
.33064 .4066 .35667 .42367 .39827 .3968 .37279 .38051 Metetra
.674 .834 .96 r
.37279 .38051 .39827 .3968 .43987 .38081 .41493 .36431 Metetra
.517 .786 .994 r
.41493 .36431 .43987 .38081 .48192 .37598 .45748 .35826 Metetra
.322 .682 .978 r
.45748 .35826 .48192 .37598 .52489 .38155 .50088 .36165 Metetra
.168 .569 .934 r
.50088 .36165 .52489 .38155 .56921 .39569 .54554 .37278 Metetra
.108 .501 .905 r
.54554 .37278 .56921 .39569 .61522 .41564 .59179 .38911 Metetra
.143 .491 .904 r
.59179 .38911 .61522 .41564 .66308 .43776 .63982 .40732 Metetra
.245 .523 .914 r
.63982 .40732 .66308 .43776 .71272 .45791 .68957 .42364 Metetra
.374 .572 .916 r
.68957 .42364 .71272 .45791 .7638 .47183 .74079 .43423 Metetra
.498 .621 .903 r
.74079 .43423 .7638 .47183 .81579 .47575 .79299 .43573 Metetra
.603 .663 .881 r
.79299 .43573 .81579 .47575 .868 .46699 .84556 .42574 Metetra
.793 .769 .831 r
.17377 .50293 .202 .52757 .2453 .48265 .21683 .46715 Metetra
.806 .84 .877 r
.21683 .46715 .2453 .48265 .28819 .44136 .25979 .43373 Metetra
.785 .917 .927 r
.25979 .43373 .28819 .44136 .33064 .4066 .30262 .40477 Metetra
.684 .955 .95 r
.30262 .40477 .33064 .4066 .37279 .38051 .34538 .38182 Metetra
.478 .895 .9 r
.34538 .38182 .37279 .38051 .41493 .36431 .3883 .36579 Metetra
.25 .763 .816 r
.3883 .36579 .41493 .36431 .45748 .35826 .43167 .35688 Metetra
.11 .662 .791 r
.43167 .35688 .45748 .35826 .50088 .36165 .47582 .35453 Metetra
.091 .629 .856 r
.47582 .35453 .50088 .36165 .54554 .37278 .52106 .35752 Metetra
.185 .633 .942 r
.52106 .35752 .54554 .37278 .59179 .38911 .56765 .36395 Metetra
.321 .621 .957 r
.56765 .36395 .59179 .38911 .63982 .40732 .61572 .37147 Metetra
.432 .596 .913 r
.61572 .37147 .63982 .40732 .68957 .42364 .66529 .37744 Metetra
.51 .578 .859 r
.66529 .37744 .68957 .42364 .74079 .43423 .71617 .37926 Metetra
.566 .572 .819 r
.71617 .37926 .74079 .43423 .79299 .43573 .76806 .37466 Metetra
.61 .577 .792 r
.76806 .37466 .79299 .43573 .84556 .42574 .82056 .36208 Metetra
.721 .764 .887 r
.1447 .47755 .17377 .50293 .21683 .46715 .18688 .45551 Metetra
.718 .882 .957 r
.18688 .45551 .21683 .46715 .25979 .43373 .22947 .43411 Metetra
.603 .942 .939 r
.22947 .43411 .25979 .43373 .30262 .40477 .27243 .41414 Metetra
.351 .818 .744 r
.27243 .41414 .30262 .40477 .34538 .38182 .3158 .3962 Metetra
.3158 .3962 .34538 .38182 .3883 .36579 .35968 .38064 Metetra
.35968 .38064 .3883 .36579 .43167 .35688 .40417 .36755 Metetra
.40417 .36755 .43167 .35688 .47582 .35453 .44941 .35669 Metetra
.213 .738 .783 r
.44941 .35669 .47582 .35453 .52106 .35752 .49555 .34758 Metetra
.433 .826 .984 r
.49555 .34758 .52106 .35752 .56765 .36395 .54269 .33948 Metetra
.555 .754 .97 r
.54269 .33948 .56765 .36395 .61572 .37147 .5909 .33151 Metetra
.59 .656 .882 r
.5909 .33151 .61572 .37147 .66529 .37744 .64019 .32273 Metetra
.6 .591 .814 r
.64019 .32273 .66529 .37744 .71617 .37926 .69054 .31222 Metetra
.606 .556 .772 r
.69054 .31222 .71617 .37926 .76806 .37466 .74184 .29922 Metetra
.614 .541 .749 r
.74184 .29922 .76806 .37466 .82056 .36208 .79398 .28321 Metetra
.559 .723 .95 r
.11475 .45142 .1447 .47755 .18688 .45551 .15558 .44501 Metetra
.462 .826 .994 r
.15558 .44501 .18688 .45551 .22947 .43411 .19739 .43755 Metetra
.238 .755 .793 r
.19739 .43755 .22947 .43411 .27243 .41414 .24024 .42819 Metetra
.24024 .42819 .27243 .41414 .3158 .3962 .28414 .41625 Metetra
.28414 .41625 .3158 .3962 .35968 .38064 .32905 .40133 Metetra
.32905 .40133 .35968 .38064 .40417 .36755 .37488 .38333 Metetra
.37488 .38333 .40417 .36755 .44941 .35669 .42152 .3625 Metetra
.488 .901 .824 r
.42152 .3625 .44941 .35669 .49555 .34758 .46886 .33936 Metetra
.691 .938 .964 r
.46886 .33936 .49555 .34758 .54269 .33948 .51683 .31469 Metetra
.727 .816 .92 r
.51683 .31469 .54269 .33948 .5909 .33151 .5654 .2894 Metetra
.699 .696 .844 r
.5654 .2894 .5909 .33151 .64019 .32273 .61459 .26443 Metetra
.667 .616 .788 r
.61459 .26443 .64019 .32273 .69054 .31222 .66447 .24062 Metetra
.641 .565 .754 r
.66447 .24062 .69054 .31222 .74184 .29922 .71519 .21869 Metetra
.622 .536 .736 r
.71519 .21869 .74184 .29922 .79398 .28321 .76691 .19907 Metetra
.253 .583 .945 r
.08389 .42449 .11475 .45142 .15558 .44501 .1232 .43245 Metetra
.079 .596 .881 r
.1232 .43245 .15558 .44501 .19739 .43755 .16403 .43804 Metetra
.034 0 0 r
.16403 .43804 .19739 .43755 .24024 .42819 .20658 .43875 Metetra
.023 0 0 r
.20658 .43875 .24024 .42819 .28414 .41625 .25089 .43255 Metetra
.25089 .43255 .28414 .41625 .32905 .40133 .29681 .41821 Metetra
.29681 .41821 .32905 .40133 .37488 .38333 .34403 .39543 Metetra
.533 .912 .761 r
.34403 .39543 .37488 .38333 .42152 .3625 .39221 .36499 Metetra
.748 .99 .883 r
.39221 .36499 .42152 .3625 .46886 .33936 .44097 .32855 Metetra
.827 .933 .9 r
.44097 .32855 .46886 .33936 .51683 .31469 .49004 .28844 Metetra
.813 .825 .859 r
.49004 .28844 .51683 .31469 .5654 .2894 .53925 .24731 Metetra
.769 .727 .814 r
.53925 .24731 .5654 .2894 .61459 .26443 .58864 .20782 Metetra
.721 .651 .779 r
.58864 .20782 .61459 .26443 .66447 .24062 .63836 .1723 Metetra
.677 .595 .756 r
.63836 .1723 .66447 .24062 .71519 .21869 .68873 .14255 Metetra
.637 .555 .745 r
.68873 .14255 .71519 .21869 .76691 .19907 .74018 .11974 Metetra
0 .381 .827 r
.05208 .39672 .08389 .42449 .1232 .43245 .09011 .41475 Metetra
0 .399 .771 r
.09011 .41475 .1232 .43245 .16403 .43804 .13008 .42959 Metetra
0 .489 .744 r
.13008 .42959 .16403 .43804 .20658 .43875 .17234 .4375 Metetra
.091 .649 .778 r
.17234 .4375 .20658 .43875 .25089 .43255 .21695 .43539 Metetra
.357 .831 .849 r
.21695 .43539 .25089 .43255 .29681 .41821 .26372 .42132 Metetra
.615 .955 .901 r
.26372 .42132 .29681 .41821 .34403 .39543 .3122 .39485 Metetra
.782 .983 .904 r
.3122 .39485 .34403 .39543 .39221 .36499 .36182 .35719 Metetra
.854 .944 .877 r
.36182 .35719 .39221 .36499 .44097 .32855 .41201 .31093 Metetra
.867 .882 .845 r
.41201 .31093 .44097 .32855 .49004 .28844 .46228 .25961 Metetra
.848 .816 .818 r
.46228 .25961 .49004 .28844 .53925 .24731 .51239 .20719 Metetra
.812 .753 .798 r
.51239 .20719 .53925 .24731 .58864 .20782 .56232 .15749 Metetra
.767 .697 .785 r
.56232 .15749 .58864 .20782 .63836 .1723 .61229 .1138 Metetra
.716 .647 .779 r
.61229 .1138 .63836 .1723 .68873 .14255 .66273 .07859 Metetra
.661 .603 .779 r
.66273 .07859 .68873 .14255 .74018 .11974 .71423 .05343 Metetra
0 .292 .757 r
.01926 .36808 .05208 .39672 .09011 .41475 .05672 .38958 Metetra
0 .37 .799 r
.05672 .38958 .09011 .41475 .13008 .42959 .09633 .40763 Metetra
.075 .536 .901 r
.09633 .40763 .13008 .42959 .17234 .4375 .13851 .41798 Metetra
.354 .723 .987 r
.13851 .41798 .17234 .4375 .21695 .43539 .1834 .41711 Metetra
.596 .837 .99 r
.1834 .41711 .21695 .43539 .26372 .42132 .23079 .40279 Metetra
.743 .87 .939 r
.23079 .40279 .26372 .42132 .3122 .39485 .28017 .37454 Metetra
.816 .863 .883 r
.28017 .37454 .3122 .39485 .36182 .35719 .33087 .33373 Metetra
.848 .844 .84 r
.33087 .33373 .36182 .35719 .41201 .31093 .3822 .28335 Metetra
.858 .823 .813 r
.3822 .28335 .41201 .31093 .46228 .25961 .43358 .22742 Metetra
.852 .802 .801 r
.43358 .22742 .46228 .25961 .51239 .20719 .48468 .17039 Metetra
.834 .78 .8 r
.48468 .17039 .51239 .20719 .56232 .15749 .53544 .11653 Metetra
.803 .757 .81 r
.53544 .11653 .56232 .15749 .61229 .1138 .58609 .06944 Metetra
.757 .729 .826 r
.58609 .06944 .61229 .1138 .66273 .07859 .63708 .03184 Metetra
.693 .694 .847 r
.63708 .03184 .66273 .07859 .71423 .05343 .68905 .00539 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.05455 .24833 m
.05931 .25284 L
s
[(-3)] .04501 .23932 1 .945 Mshowa
.18085 .19887 m
.18542 .20358 L
s
[(-2)] .17172 .18945 .96971 1 Mshowa
.31367 .14687 m
.318 .15179 L
s
[(-1)] .30499 .13702 .88122 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(0)] .44535 .08183 .79274 1 Mshowa
.60094 .03438 m
.60471 .03974 L
s
[(1)] .59338 .02365 .70425 1 Mshowa
.125 Mabswid
.07931 .23863 m
.08215 .24136 L
s
.10432 .22884 m
.10713 .23159 L
s
.12958 .21895 m
.13237 .22173 L
s
.15509 .20896 m
.15785 .21176 L
s
.20688 .18868 m
.20959 .19153 L
s
.23317 .17839 m
.23586 .18126 L
s
.25973 .16799 m
.26239 .17089 L
s
.28656 .15748 m
.28919 .16041 L
s
.34105 .13614 m
.34363 .13912 L
s
.36873 .12531 m
.37127 .12831 L
s
.39669 .11436 m
.3992 .11739 L
s
.42495 .10329 m
.42743 .10635 L
s
.48236 .08081 m
.48477 .08392 L
s
.51153 .06939 m
.51391 .07253 L
s
.54101 .05784 m
.54335 .06101 L
s
.57081 .04618 m
.57312 .04937 L
s
.63139 .02246 m
.63362 .0257 L
s
.66218 .0104 m
.66436 .01367 L
s
gsave
.29165 .07573 -70.3112 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{331, 163.313},
  ImageMargins->{{0, 0}, {0, 3.25}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006M0000c1000`40O003h00OogooWWoo003]Ool5
002[Ool00>moo`03001oogoo0:]oo`00kgoo00<007ooOol0Zgoo003_Ool00`00Oomoo`2[Ool00>mo
o`03001oogoo0:]oo`00kgoo00<007ooOol05Woo0P00Tgoo003]Ool3000FOol200000goo0000002B
Ool00>moo`03001oogoo011oo`@00003Ool000000080099oo`00ogoo0Woo0`0000=oo`0000000UJj
0`00TGoo003nOol30002Ool20004E[X01000E[X00000T7oo003kOol30003Ool200000eJjF]YF^P02
E[X00e[J001F^P02002@Ool00?Uoo`800004Ool007ooOol20008E[X00`00E[YF^P02002?Ool00?Io
o`<000Aoo`8000=F^P05F]YF^UJjE[YJfP02E[X01P00F]YF^P00Ool008ioo`00X7oo0P000Woo0P00
CWoo0P001Woo00<005JjE[X02UJj00@005JjE[YF^P8008ioo`00XGoo00@007ooOol002=oo`@002Eo
o`@000Ioo`03001RnP00009F^P05F]YF^UJjE[YJfP03E[X025[J001F^UJjF]X007oo002=Ool00:9o
o`8002=oo`03001oogoo009oo`03001oogoo021oo`8000=oo`03001oogoo009oo`800003G]YNf@00
00aF^P07001F^UJjE[X007oo0000S7oo002ROol2000SOol00`00Oomoo`02Ool00`00Oomoo`0MOol3
0009Ool01`00G]URnUkIG_YNf@0000=F^P05F]YF^UJjE[YJfP03E[X01`00E[YF^UJj001oo`0008ao
o`00XGoo00@007ooOol0029oo`03001oogoo009oo`03001oogoo01Yoo`<00003Ool007oo00Qoo`03
001NfEkJ00=Nf@03G]YNf@0000YF^P03001F^UJj009F^P03001oo`0008]oo`00X7oo0P000Woo0P00
8Goo00<007ooOol00Woo00<007ooOol067oo0P0037oo0P0000YNfF;jG]UNnUkIH_YNfEkj001JfP=F
^P09F]YF^UJjE[YJfUJj001F^U[J009F^P04001oo`00002:Ool00<Moo`03001oogoo009oo`03001o
ogoo01Eoo`<000eoo`04001NfEkIG]X3G]T01UkJG]UNfEkIG]X000UF^P03001F^UJj00<0009oo`03
001oogoo08Qoo`00agoo00<007ooOol00Woo00<007ooOol04goo0P000Woo00<007ooOol02Woo0100
05kjG]URnUkIG_YNfF;jG]UNnUkIH_YNf@00E[YJfP=F^P04F]YF^UJjE[X30000159GEWQBF0000Woo
00<007ooOol03Woo1@00M7oo0038Ool4000COol3000?Ool20002G]T01EkJG]UNfEkIG]X00ekI00EN
fUkIG]UNf@0000MF^P8000EBF004001oogoo000@Ool01@00Oomoogoo0000M7oo003MOol2000AOol0
5@00G]UNnUkIH_YNfEkjG]URnUkIG_YNfF;jG]UNnUkIH_YNf@00E[YJfP02E[X200002E9H001BEeIh
DUQBN59GEWP00002Ool00`00Oomoo`0>Ool00`00Oomoo`1eOol00=Yoo`<00003Ool007oo00moo`05
001Rn@00G]UNfP03G]T01EkJG]UNfEkIG]X00ekI00ANfUkIG]T0009F^P8000=BF003001BF59H00AB
F005001oogooOol00006Ool60004Ool00`00Oomoo`1dOol00=Moo`<001Aoo`0E001RnFKi001RnUkI
G_YNfF;jG]UNnUkIH_YNfEkjG]URnUkIG_YNfF;j0080000=DUMFN59HDWQBE`00DUQBN59GEWQBF59h
00000goo00<007ooOol03goo00<007ooOol0Lgoo003EOol3000EOol00`00H_UVn@02I_T01000G]UN
fEkJ0ekI00ENfUkIG]UNfEkJ00=Nf@<000IBF003001BF59H00EBF005001oogooOol0000AOol00`00
Oomoo`1bOol00=9oo`<001Moo`0W001RnFKiH_QW6F;i001NfF;jG]UNnUkIH_YNfEkjG]URnUkIG_YN
f@00FWQJV5Ig001BF59hDUMFN59H001BEeIhDUQBN59GEWQBF00000Aoo`03001oogoo00Yoo`05001o
ogooOol0001dOol00:Ioo`D002Eoo`8001Uoo`03001RnFKi009Vn@04H_UVnFKi0003G]T01EkJG]UN
fEkIG]X00UkI0P0000EJN5ZHFYQJV00000EBF003001BF59H00EBF003001oogoo009oo`8000aoo`<0
07Eoo`00Z7oo00<007ooOol08Woo0`0000=oo`00Ool05Woo0P0002URnFKiH_QW6F;iI_URn6LI001N
nUkIH_YNfEkjG]URnUkIG_X005ZHFWQJV5IgFYQJN5ZH001FN59HDWQBE`00DUQBN59GEWQBF59hDUMF
N000009oo`<008Aoo`00Z7oo00<007ooOol087oo0P0017oo00<007ooOol057oo00<006KiH_T00fKi
00QRnFKiI_UVnF;iI_T005kJ0ekI00INfUkIG]T005ZHFWP3FYP015YhFYQJV000159H00<0059HDUP0
1U9H00<007ooOol00goo00<007ooOol0PGoo002MOol60005Ool00`00Oomoo`0MOol3000LOol04`00
IaURnFKiH_QW6F;iI_URn6LIH_UVnF;h001NfEkjG]URnUkI0080000IFYQJN5ZHEWMJV5YhFYQFMeZH
001BN59GEWQBF000DUMFN59HDWQBEeIhDUQBN59G000017oo00<007ooOol0PGoo002XOol00`00Oomo
o`0KOol200000goo001oo`0KOol00`00I_URn@03I_T01F;iI_UVnFKiH_T00fKi00IRn@00G]UNfUkI
0002FYP01EYhFYQJV5ZHFWP00eZH00=JN5ZH00000e9H00<0059HDUP01e9H00<007ooOol00goo00<0
07ooOol0P7oo002XOol00`00Oomoo`0HOol3000OOol04P00IaURnFKiH_QW6F;iI_URn6LIH_UVnF;h
IaURnFKi001RnP80000LEWMJV5YhFYQFMeZHFWQJV5IgFYQJN5ZHEWL0059HDWQBE`00DUQBN59GEWQB
F59hDUMFN59H0006Ool00`00Oomoo`1oOol00:Ioo`<001Moo`<0025oo`03001VnF;i00=Vn@05H_UV
nFKiI_URn@03I_T01F;iI_UVnFKi00000eZH00EJN5ZHFYQJV5Yh00=JV005FWQJV5ZHFYP00003DUP0
0`00DUQBF008DUP00`00Oomoo`03Ool00`00Oomoo`1oOol00:Qoo`03001oogoo01=oo`8002=oo`0c
001[6@00I_URn6LIH_UVnF;hIaURnFKiH_QW6F;iI_URn6LI001Rf000FYQJN5ZHEWMJV5YhFYQFMeZH
FWQJV5IgFYQJN5ZH001FN59H001BEeIhDUQBN59GEWQBF59hDUMFN00000Ioo`03001oogoo07ioo`00
^goo0`0097oo00@006/IIaP0009Vn@05H_UVnFKiI_URn@03I_T02F;iI_UVnFKi001R^5jh001JN003
FYP01EYhFYQJV5ZHFWP00eZH00AJN5ZHFYP000=BF003001BF59H00EBF0<000Moo`03001oogoo07eo
o`00^Goo0P0000=oo`00Ool08goo014006/IIaQ[6FKh001RnFKiH_QW6F;iI_URn6LIH_UVnF;h0080
000MH]QN^6;HG[P005IgFYQJN5ZHEWMJV5YhFYQFMeZHFWQJV5IgFYQJN000DUMFN000DWQBEeIhDUQB
N002000014hFDSM>5P001Woo00<007ooOol0OGoo002fOol3000WOol01`00JaUW66/IJaQ[6@0000=V
n@05H_UVnFKiI_URn@02I_T02P00G[QR^5jhH[QN^6:h001JV5Yh0eZH00EJN5ZHFYQJV5Yh00=JV003
FWQJV000009BF004001BF59HDUP200001U8gCSM>=dhgDSL000Ioo`8007ioo`00]7oo0P00:Goo02h0
06/IIaQ[6FKhJaUW66/I001W6F;iI_URn6LIH_UVnF;h001N^6;HG[QRf5jhH]QN^6;H001JV5IgFYQJ
N5ZHEWMJV5YhFYQFMeZHFWQJV5Ig001BF59h001FN0800008CQIB=dhFDSM>5U8gCQH000Qoo`03001o
ogoo07]oo`00/Goo0`0000=oo`00Ool09goo00/006/IIaQ[6F/HJaUW66/IJaQ[6@0000=Vn@0>H_UV
nFKi001N^6:hG[QR^5jhH[QN^6:hG[P0009JV005FWQJV5ZHFYQJN003FYP01eYhFYQJV5ZHFWP0059H
0080009>=`05DSM>=dhgCSMB=`03CSL00`00Oomoo`05Ool00`00Oomoo`1kOol008Aoo`D002Eoo`<0
02aoo`0/001[6FLHJaUVn6/IIaQ[6FKhJaUW6000H_QW6F;iI_URn000G[QRf5jhH]QN^6;HG[QRf5jh
H]QN^000FWQJV5IgFYQJN5ZHEWMJV5YhFYQFMeZHFWQJV0<0000<DSM>5U8gCQIB=dhFDSM>5U8gCQIB
=`0027oo00<007ooOol0NWoo0024Ool01@00Oomoogoo00008goo0`00;Goo010006/IIaQ[6F/HJaUW
66/IJaQ[6FLHJaU[6000H_UVn@80000=G[QR^5jhH[QN^6:hG[QR^5jhH[QN^6:h00000eZH00EJN5ZH
FYQJV5Yh00=JV008FWP00000001>=`00CSMB=`=>=`05DSM>=dhgCSMB=`02CSL00`00Oomoo`06Ool0
0`00Oomoo`1iOol008Eoo`03001oogoo025oo`<000=oo`03001oogoo02Uoo`0Z001[6FLHJaUVn6/I
IaQ[6FKhJaUW66/II_Q[6@00I_T006;HG[QRf5jhH]QN^6;HG[QRf5jhH]QN^6;HG[QRf000FYQJN5ZH
EWMJV5YhFYQFMeZH0P0000=BEeIHDUL00P0000eB=dhFDSM>5U8gCQIB=dhFDSM>5U8gCQH00008Ool0
0`00Oomoo`1iOol007aoo`H000Aoo`03001oogoo01ioo`80035oo`0S001[6FLHJaU[66/IIaQ[6F/H
JaUW66/IJaQ[6FLHJaT006:hG[QR^5jhH[QN^6:hG[QR^5jhH[QN^6:hG[QR^5jh001JN003FYP01EYh
FYQJV5ZH00000eIG00ABEeIG000000=>=`05DSM>=dhgCSMB=`03CSL00e8g001oo`08Ool00`00Oomo
o`1hOol008Moo`03001oogoo01Yoo`<00003Ool007oo02moo`0Y001[6FLHJaUVn6/IIaQ[6FKhJaUW
66/II_Q[6FLHJaT006Ki001Rf5jhH]QN^6;HG[QRf5jhH]QN^6;HG[QRf5jhH]QN^000EWMJV5YhFYQF
M`0200001UIGDUMFF59GEUMBE`80000>DSM>5U8gCQIB=dhFDSM>5U8gCQIB=dhFDSL000Uoo`03001o
ogoo07Moo`00R7oo00<007ooOol05goo0P00=7oo02P006/IIaQ[6F/HJaUW66/IJaQ[6FLHJaU[66/I
IaQ[6@00I_UVn000G[QR^5jhH[QN^6:hG[QR^5jhH[QN^6:hG[QR^5jhH[P005ZHFWQJV0800005DUMF
EeIGEUMBE`03EUL0159G001>=e8g0dhg00EB=dhgCSM>=e8g00=>=`03001oogoo00Moo`03001oogoo
07Moo`00Q7oo00D007ooOomoo`0001Ioo`<003Eoo`0V001[6FLHJaUVn6/IIaQ[6FKhJaUW66/II_Q[
6FLHJaT006KiI_QVnF;h001N^6;HG[QRf5jhH]QN^6;HG[QRf5jhH]QN^6;HG[QRf0<0000JEUQBEeIG
DUMFF59GEUMBEeIHDUMFE`00DSM>5U8gCQIB=dhFDSM>5U8gCQIB=dhFDSL000Uoo`8007Qoo`00QGoo
0`005Goo0P00=goo02P006/i001[6F/HJaUW66/IJaQ[6FLHJaU[66/IIaQ[6@00I_UVn6KiI_QVn@00
H[QN^6:hG[QR^5jhH[QN^6:hG[QR^5jhH[QN^6:hG[P0009FE`05DUMFEeIGEUMBE`03EUL0159GEUMF
E`000dhg00EB=dhgCSM>=e8g00=>=`04DSM>=dhg0009Ool00`00Oomoo`1fOol009Yoo`<003Qoo`0V
001_>F/HKcT006/IIaQ[6FKhJaUW66/II_Q[6FLHJaT006KiI_QVnF;hI_UVn6Ki001Rf5jhH]QN^6;H
G[QRf5jhH]QN^6;HG[QRf0<0000=EUQBEeIGDUMFF59GEUMBEeIHDUMFEe9GEUP00P0000i>5U8gCQIB
=dhFDSM>5U8gCQIB=dhFDSM>5P002Woo00<007ooOol0MGoo002GOol300000goo001oo`0gOol00`00
JcU[6002JcT08P00IaQ[6F/HJaUW66/IJaQ[6FLHJaT006KiI_QVnFKhI_UVn6KiI_QVn@00H[QN^6:h
G[QR^5jhH[QN^6:hG[QR^0000eZH00D005IGEUMFEe9G00=FE`05DUMFEeIGEUMBE`0200001E8gCSM>
=dhgDSL00dhg00MB=dhgCSM>=e8gCSL0000:Ool00`00Oomoo`1dOol009Eoo`8003eoo`0T001[66li
JaQ_>F/H001Vn6/IIaQ[6FKhJaUW66/I001VnFKhI_URn6KiI_QVnF;hI_UVn000G[QRf5jhH]QN^6;H
G[QRf5jh0P00015JV5YgFYQJN000DUMFF59GEUMBEeIHDUMFEe9GEUQBEeIG0080000?CQIB=dhFDSM>
5U8gCQIB=dhFDSM>5U8gCQIB=`0000Yoo`03001oogoo01aoo`<005Eoo`00TWoo0`00?Woo00<006/H
JcT00V/i021[66/iJcT006LHJaU[66/IIaQ[6@00I_UVn6KiI_QVnFKhI_UVn6KiI_QVnFKh001N^6:h
G[QR^5jhH[QN^0001eZH00<0059GEUL00UIG00EBEeIGEUMFEe9G009FE`05001BE`00CSMB=`03CSL0
1E8gCSM>=dhgDSL00dhg00<007ooOol02Goo00<007ooOol07Goo00<007ooOol0Dgoo002@Ool20002
Ool00`00Oomoo`0kOol08`00JaQ_>F/HKcU[66liJaQ_>F/H001Vn6/IIaQ[6@00I_UVn6KiH_QVnFKh
I_URn6KiI_QVnF;hI_T006;HG[QRf5jhH]P00P0002IJN5ZHFWMJV5YhFYQJMeZH001FEe9GEUQBEeIG
DUMFF59GEUMBEeIH001FE`00DSM>5U8gCQIB=dhFDSM>5U8gCQIB=dhFDSM>5P002goo00<007ooOol0
77oo00<007ooOol0Dgoo001VOol3000TOol30011Ool00`00JaQ[>@02JcT07f/HJcU[>F/iJaQ[>@00
JaUW66/I001VnFKhI_UVn6KiI_QVnFKhI_UVn6KiI_QVnFKhI_T006:hG[QR^00000YJV004001FEeIG
DUL3EUL0259GEUMFEeIGDUL005IG0003CSL01E8gCSM>=dhgDSL00dhg00AB=dhg000000]oo`03001o
ogoo01]oo`03001oo`0005Aoo`00IGoo00D007ooOomoo`00025oo`800003Ool007oo041oo`0R001[
66liJaQ_>F/HKcU[66liJaQ_>F/HKcT006/I001VnFKhI_URn6KiI_QVnF;hI_UVn6KiH_QVnFKhI_UR
n000G[P200009EZHFWQJV5YgFYQJN5ZHFWMJV5YhFYQJM`00DUMFEe9GEUQBEeIGDUMFF59GEUL005IH
DUL004hFDSM>5U8gCQIB=dhFDSM>5U8g00800003BQH007oo00]oo`03001oogoo01Yoo`03001oo`00
05Aoo`00JGoo00<007ooOol077oo0`00A7oo00<006/HJcT00V/i00E[66/iJcU[>F/H00=[>@0FJaQ[
>@00I_UVn6KiI_QVnFKhI_UVn6KiI_QVnFKhI_UVn6KiI_QVnFKh000>FYP01@00EUMFEeIGDUL00eIG
00QBEeIGEUMFE`00EUL0058g0dhg00=B=dhgCSL00`0000E>5dhFCQM>5P0000Yoo`03001oo`0001Yo
o`05001oogooOol0001COol005eoo`H000Ioo`03001oogoo01Uoo`@004Eoo`0R001[66liJaQ_>F/H
KcU[66liJaQ_>F/HKcU[66li001_>P00I_URn6KiI_QVnF;hI_UVn6KiH_QVnFKhI_URn6KiI_P20000
8EZHFWQJV5YgFYQJN5ZHFWMJV5YhFYQJMeZHFWP0059GEUQBEeIGDUMFF59GEUMBEeIHDUL0059G001>
5U8gCQIB=`03000024hgCQI>5dXFCSM>5ThG000<Ool00`00Oomoo`07Ool4000=Ool01@00Oomoogoo
0000Dgoo001WOol2000JOol20019Ool01@00JcU[>F/iJaP00f/i00M[66/iJcU[>F/HJcT00002JcT0
5000I_QVnFKhI_UVn6KiI_QVnFKhI_UVn6KiI_QVnFKh001NfF;I000>FYP00`00DUMFE`02EUL02e9G
EUMFEeIGDUMFE`00EUMBE`00CSL00P0000]>5dhFCQM>5ThGCQI>5dhFCQM>5P0000eoo`03001oogoo
00Eoo`03001oogoo009oo`03001oogoo00Uoo`<00004Ool00000001BOol006Uoo`03001oogoo01Ao
o`<004Yoo`0@001_>F/HKcU[66liJaQ_>F/HKcU[66liJaQ_>@00KcX3JcT03@00I_QVnF;hI_UVn6Ki
H_QVnFKhI_URn6Ki0080000OG]URnEkI001JMeZHFWQJV5YgFYQJN5ZHFWMJV5YhFYQJMeZH001FEe9G
EUQBEeIGDUMFF59GEUMBE`00DUL00`0000i>5ThGBQI>=dhFCQM:5ThgCQI>5dXFCSM>5P003Goo00<0
07ooOol017oo00<007ooOol00Woo00<007ooOol0HWoo001UOol01@00Oomoogoo000057oo0P0000=o
o`00Ool0BGoo00D006/iJcU[>F/H00=[>@07JaQ[>F/iJcU[66/i00001V/i01<006KhI_UVn6KiI_QV
nFKhI_UVn6Ki001RfEkIH]UNfF;IG]T0000>FYP00`00EUMBE`03EUL0159GEUMFEeIG0P00015>=`00
CQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5`0000eoo`03001oogoo00Aoo`03001oogoo009oo`03
001oogoo069oo`00IWoo0`004Woo0`00CGoo010006liJaQ_>F/HKcU[66liJaQ_>F/HKcU[66li001_
>P=[>@0/KcY[>F/iJcT006KhI_URn6KiI_QVnF;hI_T006;iG]URnEkIH_UNfF;i001JV5YgFYQJN5ZH
FWMJV5YhFYQJMeZHFWQJV5Yg001BEeIGDUMFF59GEUMBE`<0000BCSMB>4hg001:5ThgCQI>5dXFCSM>
5ThGBQI>=dhFCQM:5P003Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0HWoo001iOol3
001>Ool01@00JcT006/iJaP00f/i00M[66/iJcU[>F/HJcT00009JcT04`00I_UVn6KiI_QVnFKhI_T0
06;IG]URfEkIH]UNfF;IG]URf@0000eJV005001FEeIGEUMBE`0300005ThgDSL0058gCSMB=`00CQM>
5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5P003Woo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool0HWoo001fOol3001@Ool04000KeU[>FmI001_>F/HKcU[66liJaQ_>F/HKcU[60000f/i00E_>V/i
JcU[>Flj009[>@0R001VnFKhI_URn6Ki001RnEkIH_UNfF;iG]URnEkIH_UNf@00FWQJV5YgFYQJN5ZH
FWMJV5YhFYQJMeZHFWQJV000EUP200006DhgDSQ>=e8gCSL004hgDSM>=`00CQI>5dXFCSM>5ThGBQI>
=dhFCQM:5ThgCQI>5`0000ioo`03001oogoo009oo`03001oogoo009oo`03001oogoo069oo`00Lgoo
0`00DWoo00@006/iJcU_>@9[>@03001[>F/H00=[>@04JaQ[>F/i000<JcT00`00I_UVn002000036;I
G]URfEkIH]UNfF;IG]URfEkIH]T000iJV080000KDSM>=e8gCSMB=dhgDSL0058gCSMB=dhg001>5ThG
CQI>5dhFCQM>5ThGCQI>5dhFCQM>5P0000eoo`<000Aoo`@006Eoo`00LGoo0P000Woo00<007ooOol0
Cgoo010006mIJcU_FF/iKeU[>FmI001_>F/HKcU[66liJaP000=[>@05KcY[>F/iJcU_>P03JcT07flj
JcT006;h001NfF;iG]URnEkIH_UNfF;iG]URnEkIH_UNfF;i001JV5YhFYQJMeZHFWQJV5YgFYQJN5ZH
00<0000MDSM>=e8hCSMB=dhgDSQ>=`00CSMB>4hgDSL004hgCQI>5dXFCSM>5ThGBQI>=dhFCQM:5Thg
CQH0000?Ool00`00Oomoo`1ZOol006ioo`<005Eoo`04001[>F/iKcT3JcT00fliJcT00002JcT016/H
JcU[>@003f/i014005kIH]UNfF;IG]URfEkIH]UNfF;IG]URfEkIH]UNf@0000UJV080000:DWQBF59h
001B=dhgDSM>=e8gCSL20000558gCSMB=dhg001>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThG000?
Ool00`00Oomoo`1ZOol006aoo`800003Ool0000005Aoo`0@001_FF/iKeU[>FmIJcU_FF/iKeU[>@00
JaQ_>F/H0003JcT01FljJcU[>F/iKcX00f/i01e_>V/iJcU[>@00IcX005kIH_UNfF;iG]URnEkIH_UN
fF;iG]URnEkIH_UNf@00FWMJV5YhFYQJMeZH00800009DUQFNE9HEWQBF000CSMB=dhg00<0000FCSMB
>000DSM>=e8hCSL004XFCSM>5ThGBQI>=dhFCQM:5ThgCQI>5dXF000@Ool00`00Oomoo`1YOol006Yo
o`8005Qoo`04001[>F/iKcT3JcT02FliJcU[>F/iKcU[>@00JcT0000?JcT05000IcYW>P00H]UNfF;I
G]URfEkIH]UNfF;IG]URfEkIH]UNfF;I0004FYP20003DWP0159HDWQBN59h100001Y>=e8gCSMB=dhg
001>=e8gCSMB=`00CQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5P0047oo00<007ooOol0J7oo001Z
Ool2001HOol03`00JcU_FF/iKeU[>FmIJcU_FF/iKeU[>FmIJcT00003JcT01FljJcU[>F/iKcX00f/i
00=_>V/iJcT00P0001IW>VMKIcYWF`00H_UNfF;iG]URnEkIH_UNfF;iG]URnEkIH_UNfF;i001JV080
0007DUQFN59HEWUBF5IhDUP0100001aB>4hgDSM>=e8hCSMB=dhg001>=e8gCSMB>000CQM:5ThgCQI>
5dXFCSM>5ThGBQI>=dhFCQL0011oo`03001oogoo06Qoo`00JWoo00<007oo0000EWoo00<006/iKcT0
0f/i00E_>F/iJcU[>Fli00=[>@03001[NP0000a[>@03001WFfLj009W>P0BIe]W>P00G]URfEkIH]UN
fF;IG]URfEkIH]UNfF;IG]URfEkI0P0000=BN59HDWP00U9h00EBF0000000059H009BN00M001>=e8g
CSMB=dhgDSM>=e8gCSL004hgDSM>=`00CQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQH0000AOol00`00
Oomoo`1WOol0065oo`D000Aoo`04001oogoo001DOol04`00JcU_FF/iKeU[>FmIJcU_FF/iKeU[>FmI
JcT006]jKgY[NP0000=[>@05KcY[>F/iJcU_>P02JcT05P00Ie]W>VMKIcYWFfLjIe]W>P00G]URnEkI
H_UNfF;iG]URnEkIH_UNfF;i0`0000EFNE9HEWQBF5Ii0080000TDUQFNE9HEWQBF5Ii001B=dhgDSQ>
=e8gCSMB>4hgDSM>=`00CSMB=`00CSM>5ThGBQI>=dhFCQM:5ThgCQI>5dXFCSM>5P004Goo00<007oo
Ool0IWoo001SOol00`00Oomoo`03Ool20003Ool00`00Oomoo`1@Ool00`00JcU_>@03JcT01FliJcU[
>F/iKcT00f/i00<006]jKgX00Vmj00=[NP00JcT01f/i00<006MKIcX00VLj011WFfLjIcYW>VMKIcX0
05kIH]UNfF;IG]URfEkIH]UNf@8000=F^P03001BN000008000=BN00SDUQBN59hDWQBF59h001B=dhg
DSM>=e8gCSMB=dhgDSL0058gCSMB=`00CQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQL0000@Ool2001X
Ool006=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo04ioo`0G001[>FmIJcU_FF/iKeU[
>FmIJcU_FF/iKeU[>@00JgY_NV]jKiY[NVmjJgX00003JcT05fljJcU[>@00Ie]W>VMKIcYWFfLjIe]W
>VMKIcYWF`00H_UNfF;iG]URnEkIH_T00P0000AF^U[JE[YJfP<0000YEWUBF5IhDUQFNE9HEWQBF5Ii
DUQFN59H001>=e8gCSMB>4hgDSM>=e8hCSMB=`00DSQ>=`00BQI>=dhFCQM:5ThgCQI>5dXFCSM>5ThG
BQH0000BOol00`00Oomoo`1UOol005Qoo`H000Eoo`03001oogoo00=oo`8000Eoo`03001oogoo04ao
o`03001[>Fli00=[>@05KcU[>F/iJcU_>@03JcT00`00JgY_NP02KgX01V]jKgY_NVmjJgX000=[>@80
0005Ie]W>VLjIcYWF`03IcX02VMKIcYW>VLjIe/006;IG]URfEkI0P000eJj0`000UJj00<0059HDWP0
0U9h00EBF59hDWQBN59H00=BN00N001B=dhgDSM>=e8gCSMB=dhgDSM>=e8g001B=`00CQM>5ThGCQI>
5dhFCQM>5ThGCQI>5dhFCQM>5P004Goo00<007ooOol0IGoo001SOol00`00Oomoo`03Ool00`00Oomo
o`05Ool2001;Ool0;`00JcU_FF/iKeU[>FmIJcU_FF/iKeU[>FmIJcT006]jKgY[NVnJJgY_NV]jKiY[
NVmjJgX006/i001W>VMKIcYWFfLjIe]W>VMKIcYWFfLjIe]W>VMKIcX005kIH_T00P0000=F^U[J0000
0P0002iJfUJjF]YF^U[J001FN59HEWUBF5IhDUQFNE9HEWQBF5IiDUQFN000DSQ>=e8gCSMB>4hgDSM>
=e8hCSMB=`00DSP004hGBQI>=dhFCQM:5ThgCQI>5dXFCSM>5P80019oo`03001oogoo06Aoo`00Hgoo
00<007ooOol00goo00<007ooOol01goo00<007ooOol0Agoo00<006]J00000f/i00E_>F/iJcU[>Fli
00=[>@03KcT006mj009_NP05JgY_NVmjKgY[NP03KgX016]j001W>VMK0fLj00EWFfLjIcYW>VMK00=W
>P04Ie]W>VLjIcX2000015Jj000000002EJj00<0059hDUP00e9h00EBF59hDWQBN59H009BN00H001>
=e8gCSMB=dhgDSM>=e8gCSMB=dhg001>=`00CQI>5dhFCQM>5ThGCQI>5dhF0`0000=>5`00Ool04Woo
00<007ooOol0Hgoo001QOol30005Ool20009Ool00`00Oomoo`15Ool0;@00JeU_FV]J001[>FmIJcU_
FF/iKeU[>FmIJcU_F@00KgY[NVnJJgY_NV]jKiY[NVmjJgY_VV]j001WV`00IcYWFfLjIe]W>VMKIcYW
FfLjIe]W>VMKIcYWF`0500009U[JE[YJfUJjF]YF^U[JE[YJfUJjF]YF^P00DUQFN59HEWUBF5IhDUQF
NE9HEWQBF5Ii001B=dhgDSQ>=e8gCSMB>4hgDSM>=e8hCSL200001DhgCQI>5dXFCSL0100000I:5dhg
BQI>=dXG000BOol00`00Oomoo`1SOol006=oo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo
04=oo`03001[FV]J00=[FP05001[>F/iJcU_>@03JcT00fli001_NP02KgX01F]jKgY_NVmjJgX00fmj
00Q[NP00Ika[_6Nl001W>VMK0fLj00IWFfLjIcYW>VMKIcX400000e/l001F^P0<E[X01@00DWQBN59h
DUP00e9h01=BF59hDWQBN59HDWP0058gCSMB=dhgDSM>=e8gCSMB=dhgDSM>=`02000014hG00000000
0dhG00M:5dhGCQM>5dXGCQL0000COol00`00Oomoo`1ROol006Qoo`8000aoo`03001oogoo045oo`03
001[FFmJ009[FP03JeU_FV]J0080000AKeU[>FmIJcU_F@00KgY[NVnJJgY_NV]jKiY[NVmjJgY_VP02
00003VNKJkaWVf^lIi/006LjIe]W>VMKIcYWFfLjIe/30000;5lmFcaO?E/lGcd005[JE[YJfUJjF]YF
^U[JE[YJfUJjF]YF^U[J001FNE9HEWQBF5IiDUQFN59HEWUBF5IhDUP004hgDSM>=e8hCSMB=dhgDSQ>
=e8gCSL400003DhgBQM>=dXFCSM:5dhgBQI>=dXGCSM:5P0001Aoo`03001oogoo065oo`00J7oo00<0
07ooOol037oo00<007ooOol0?goo00<006]JJeX026]J00D006/iJcU_>@0000=_NP05JgY_NVmjKgY[
NP03KgX01000IkaW_6^l0fNl00E[_000IcYW>VMK009W>P@00003FcaK?E/l009K?003FceK?00000eF
^P03001BF59h009BN005DUQBN59hDWQBF003DWP02000DSM>=e8gCSMB=dhgDSL400001DXgBSP004hG
BQL00dhG00E:5dhGCQM>5dXG00=>5`03BQL007oo015oo`8006=oo`00J7oo00<007ooOol03Goo00<0
07ooOol0?Goo00<006]IKeX00V]J00I[FFmJJeY[FV]IKeX2JeX06`00KeT006mjJgY_VV]jKgY[NVnJ
JgY_NV]jKiX006^lIi][_6NKJkaWVf^lIi][_000Ie]W>P040000:5lmFcaO?E/lGceK?5lmFcaO?E/l
001F^U[JE[YJfUJjF]YF^U[JE[YJfUJjF]YF^P00DUQFNE9HEWQBF5IiDUQFN59HEWUBF5Ih001B>4hg
100001I>>4XGCSQ:5dhhBQM>>000CSM:5ThgBQM>=dXFCSM:5dhgBQI>=dXGCSL001Aoo`03001oogoo
061oo`00J7oo0P003goo00<007ooOol0>goo00<006]JJeX036]J00D006mjKgY_NV]j00=_NP05JgY_
NVmjKgX00002Ik`01F^lIkaW_6NlJk`00fNl1@000e/l00EK?E/lFcaK?5/m00=K?003Fcd005Jj00aF
^P03001BN59H00=BN005DUQBN59hDWQBF00500000dXhCSQ:=`02BSP01ThhBSM:>4XhCSQ:=`800003
CQM:5dhG009>5`05BQM>5dhGCQM:5`02CQL00`00Oomoo`0COol00`00Oomoo`1OOol004moo`@000Eo
o`8000Eoo`@000Eoo`03001oogoo00moo`03001oogoo03Uoo`03001[FFmJ009[FP06JeU_FV]JJeY[
FFmJ0V]J00A[FFmJ001_^`80000AJgY_NV]jKiY[NVmjJgY_VP00JkaWVf^lIi][_6NKJkaWV`030000
96NKJk`005lmFcaO?E/lGceK?5lmFcaO?E/lGceK?5lmFcaO?@00F]YF^U[JE[YJfUJjF]YF^U[JE[YJ
fUJjF]X005IhDUQFN@H0000PBSU>F@00CSQ:5dhhBQM>>4XGCSQ:5dhhBQM>>4XGCSP004hg001>=dXF
CSM:5dhgBQI>=dXGCSM:5ThgBQL001Aoo`03001oogoo05moo`00CWoo00<007ooOol00Woo00<007oo
Ool00Woo0P0017oo00<007ooOol00Woo00@007ooOomoo`80019oo`03001oogoo03Moo`03001[FV]J
00a[FP03001[^f^k009[^`800004KgY[NVmjKgX20002Ik`016^lIkaW_6Nl0`0000=W_6^lIk`00P00
00EG_P00FcaK?5/m00=K?005FceK?5/lFcaK?@03Fc`00`00E[YF^P0:E[X50009BUT00`00CSQ:=`02
BSP01ThhBSM:>4XhCSQ:=`9:>003CSP00000009>5`05BQM>5dhGCQM:5`03CQL00dXGCQL0000EOol0
0`00Oomoo`1NOol004ioo`03001oogoo009oo`03001oogoo00eoo`04001oogooOol2000COol00`00
Oomoo`0eOol00`00JeU_FP02JeX01V]IKeY[FV]JJeU_FP9[FP0:JeT00000Kk][^foKJk]_^f^kKm/2
00001f]j001WVf^lIi][_6NK00<00004Ii][_6NKJk`200006eNmEkiG_ENn001O?E/lGceK?5lmFcaO
?E/lGceK?5lmFcaO?E/l001F^U[JE[YJfUJjF]YF^P0400000dZK001>F@02BUT01TXiCUU:FDYIBSU>
F@9:F@0NBST004XGCSQ:5dhhBQM>>4XGCSQ:5dhhBQM>>4XG001:5P00BQM>=dXFCSM:5dhgBQI>=dXG
CSM:5P005Woo00<007ooOol0GGoo0016Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool01@00
Oomoogoo00005Goo00<007ooOol0<goo00<006]JJeX02f]J00<006^kJk/02F^k00@006NlIkaW_0<0
0003Ika[_6Nl009W_08000MG_P04001K?5/lFcd3Fc`01E/mFcaK?5/lFcd00U/l00@005JjE[YF^P@0
00I:V`03001:FDYI00Y:F@04001:>4hhBSL2BSP02dhhBSM:>4XhCSQ:=dXh001>5dXG00000ThG00E:
5dhGCQM>5dXG00=>5`03001oogoo01Aoo`03001oogoo05eoo`00CWoo00<007ooOol00Woo00<007oo
Ool02Goo100017oo0P005Goo00<007ooOol0<Goo00<006]IKeX00V]J00I[FFmJJeY[FV]IKeX2JeX0
3f]I001[^fnkJk]_ff^kKk][^foKJk]_^f^k001Of`0300001VNKJkaWVf^lIi][_080000FEkeG_UNm
EkiG_ENnEkeG_UNmEkh005lmFcaO?E/lGceK?5lmFcaO?E/lGcd500001DZLBY]:VdIkBY`00TZK00I6
NdZLBY/004XiCUT2BUT01TXiCUU:FDYIBSU>F@9:F@0M001>>4XGCSQ:5dhhBQM>>4XGCSQ:5dhhBQM>
>000CSL004hgBQM>=dXFCSM:5dhgBQI>=dXGCSL0000FOol00`00Oomoo`1LOol004ioo`03001oogoo
009oo`03001oogoo00Uoo`03001oogoo00Eoo`03001oogoo01Eoo`03001oogoo02moo`03001WF`00
00][FP03001[^f^k00Q[^`@0009On`800003Ika[_6Nl008000eG_P05001K?5/lFceK?0060003A_h0
0`00BY]:V`0:BY/00`00BUU:F@0:BUT01@00BSQ:>4hhBSL00TXh00M>>4XgBSQ:>4hhBSL00002CQL0
1@00CQM>5dhGBQL00dhG00A:5dhGCQL001Eoo`03001oo`0000Moo`D0055oo`00CWoo00<007ooOol0
0Woo00<007ooOol02Goo00<007ooOol01Goo00<007ooOol05Woo0P00;Goo0P0000IWFfMlIe/006]I
KeX2JeX03f]IKeY[FV]JJeT006^kKk][^foKJk]_^f^kKm][^`0300001eoKGoaKfeolGm]Oo5_K00<0
000>EkeG_UNmEkiG_ENnEkeG_UNmEkiG_ENnEkeG_PH0000:@_i77T;nA_i2oTLN@_i6oT;n0002BY/0
1TIkBYa:VdZKAW]:W09:V`06AW]:W000BUU:>DiI0TYI02=:>DiIBUU:FDXiCUU:F@00BQM>>4XGCSQ:
5dhhBQM>>4XGCSQ:5dhh001>=dXGCSL004hgBQM>=dXFCSM:5dhgBQI>=`0001Moo`03001oogoo00Eo
o`05001oogooOol0001AOol004moo`@000aoo`D000=oo`8001Uoo`03001oogoo02Uoo`07001WNfMK
Ig]WFfMkIe/00P001F]J0P001f^k100000=OneoKGo/00Uok00MOfeok000003^I?iTkV@040004Ekh6
0002=ch00cMO0016oP0;A_h00`00BY]:V`0:BY/00`00BUU:F@0:BUT01P00BSM:>4XhCSQ:=`9:>006
CSQ:=dXhBSQ>>0000dhG00D004hGCQM>5dXG00=>5`03BQM>5`0001Moo`03001oogoo00Eoo`03001o
ogoo059oo`00IWoo00<007ooOol06Woo00<007ooOol09goo00`006MlIe]WO6MKIgaWFfMlIe]WO000
KeX2JeX02000Km][^fnkJk]_ff^kKk/200002F^k000005olGm]Oo5_KGoaOf`02000023nJ>gToVS]i
?iXkNCnJ>gT5000063<n=elc?SMO<chgGc<n=elc?SMO00177T;nA_i2oTLN@_i6oT;nAai2oTKn@_h0
009:V`06AW]:W4ZKBY]6NdZL0TZK00I6N`00BUU:FDXiCUT2BUT08TXiCUU:FDYIBSU>F@00CSQ:5dhh
BQM>>4XGCSQ:5dhhBQM>>4XG001:5ThgBQL004XFCSM:5dhgBQI>=dXGCSM:5P0067oo00<007ooOol0
1Goo00<007ooOol0DGoo001VOol00`00Oomoo`0KOol00`00Oomoo`0TOol200003VMkIe]WNfMKIg]W
FfMkIe]WNfMKIg/006]J0005Jk/30002Jk/01000Go]OneoK0eok0P0000@kVCnI>iToV@T000056_P0
0000000gG`03=ch01SMO=chg?SLn=el000]6oP03001:VdZK00U:V`03001:FDYI00Y:F@04001:>4hh
BSL2BSP02ThhBSM:>4XhCSQ:=dXh001>5dXG0ThG00<004XGCQL00ThG00E:5dhGCQM>5`0001Qoo`03
001oogoo00Ioo`03001oogoo051oo`00IWoo0P007Goo00<007ooOol08Woo00l006MKIgaWFfMlIe]W
O6MKIgaWFfMlIe]WO6MKIg`00P0000=[^fnk00000P0000Y_^f^kKm][^`00Fm]Oo5oKGoaKf``00005
3[T00000000:V`08000053<n=elc?SMO<chgG`00Aai2oTKn@_i77T;nA_i2oTLN@_i6oP00BY`2BY/0
1TIkBYa:VdZKAW]:W09:V`06001>FDYIBUU:>DiI0TYI025:>DiIBUU:FDXi001:5dhhBQM>>4XGCSQ:
5dhhBQM>>4XGCSP004hgBQI>=dXG001:5ThgBQM>=dXFCSM:5dhg000067oo00<007ooOol01Woo00<0
07ooOol0Cgoo001VOol00`00Oomoo`0MOol00`00Oomoo`0POol04@00Ie]WNfMKIg]WFfMkIe]WNfMK
Ig]WFfMkIe]WN`00Ho`01@000f^k0P0000=On`000000200000=37clO@al00P000RJn1`0000@:N`Yj
2WX:NPP00003=el004Kn00Y6oP03001:VdZK00Q:V`03001:FDYI00Y:F@05001:>4XhCSQ:=`02BSP0
1dhhBSM:>4XhCSQ:=`00009>5`05BQM>5dhG001:5`03CQL014XG000000006Goo00D007ooOomoo`00
00=oo`03001oogoo04moo`00IWoo0P007goo00<007ooOol07Goo0P0000eWFfMlIe]WO6MKIgaWFfMl
Ie]WO6MKIgaWF`0400001F?lHm]So6?LHo`02P0001<o7T<O?ai3?clN@alo7T<o?ai37clN000VWRZo
9YhZ_bJN:[lVWP05000020Yj2W/001JN5WdFWA9m5Yh8000024;nA_i2oTLN@_h004IkBY`2BY/02TIk
BYa:VdZKAW]:W4ZK001:>DiI0TYI00I:>DiIBUU:FDXiCUT2BUT05000CSQ:5dhhBQM>>4XGCSQ:5dhh
BQM>>000CSM:5dhgBQI>=`00CSL400000dXhCUT0000GOol30004Ool3001BOol006Ioo`03001oogoo
01moo`03001oogoo01]oo`0>001WNfMKIg]WFfMkIe]WNfMKIg]WFfMkIe]WN`<00005HoaSg6?LHmaS
o003Hm`20002@iL2000045MNDeh00000@alo7d<O?am37clO@alo7d<O?am37clO0P001RJn00@0018m
5SdB?@D000HFO@05000VORIm9WhVO@090008BY/00`00BUU:F@0:BUT01P00BSM:>4XhCSQ:=`9:>006
CSQ:=dXhBSQ>>0000ThG100000Q>F4XhCSQ:>4iHBSQ>>0006Goo00<007ooOol0EWoo001MOol40004
Ool01000Ool0000087oo00<007ooOol06Goo00`006MlIe]WO6MKIgaWFfMlIe]WO6MKIg`4000026?K
HoaSg6?lHm]So6?LHo`200005T>G00000000DceGGU<mEeiC?EMN0013?clN@alo7T<o?ai37clN@clo
7T<O1@0000@Z_bJN:[lVWP8000055SdB?1IM4SdF?@0300004QJM4WdFWQIm5Yd002Yn9UdZORIM:WhV
GBYn9UdZORIM000bG0H00007BY]6NdZL001:FDXiCUT00TYI00i:>DiIBUU:FDXiCUU:F@00BQM>>4XG
CSQ:5dhh200000a:>4iIBSQ>F@00CUU:>4iIBSQ>FDXh000JOol00`00Oomoo`1EOol005aoo`03001o
ogoo009oo`04001oogooOol2000017oo000000007goo00<007ooOol05Woo0P0000UOO@00001WFfMk
Ie]WNfMKIg/00`0000EWN`00001Sg6?l00=Sg005HoaSg6?L0013U`0200002U=NEeiC?EMNDeiGGU<m
EeiCGUMN0P0000<o7d<O?al01P0000E:VdIkAW/003YL00D000039[h001Hm00<B?@035SdB?@0000<0
00<FO@0;000VORIm9WhVOBIn9WdVORIm9Wh00007=U`G0005AST04000CUQ:>4hhBSQ>F4XhCSP004iH
BSQ>>4XhCUQ:>0006Goo00<007ooOol0EGoo001LOol00`00Oomoo`02Ool01@00Oomoogoo00000goo
00@0004g000001ioo`03001oogoo01=oo`800008FeeOOE]MGgeKG@00Ie]WO0<0000<IgaWFfMl001S
o6?KHoaSg6?lHm]So6?L100000eGGU<mEeiC?EMNDceGGU<mEeiC?EMNDceGGP04000044IjBY]6NdZK
AWY:VdIkBY]6NP00=S/jG3Hk>U`f>cYL100000PB?1IM4SdF?A8l0009o0gl0P0003lFOAJM000ZORIM
:WhVGBYn9UdZORIM:Wh003IL<U`fGC9L=U`bG3IM<U`fG39L000n>T9K?SY2Fchj@U/n>T9K?SY2Fchj
0016>DIIASU6FTHiAUU6>DIJASU6FDHiAUX004iIBSQ>FDXhCUU:>000BSQ>FDXhCUU:>4iI00006Woo
00<007ooOol0E7oo001LOol00`00Oomoo`02Ool01@00Oomoogoo000017oo0P0000<15`0000007Goo
00<007ooOol04Goo00<005mmGgd01Umm0P0000IWNfMKIg]WFfMk0002Hm`01F?lHmaSg6?LHo`01000
00eO?000001GGU<mEeiCGUMNDceGGU=NEeiC?@0200001EJjDYX004IkBY/00dIk00m:VdIkAW]6NdZK
AW/003IK>U`f>cYL=U/jG3Hk>U`01@0000HF?A8m000000gl2O`400002RIn9WdVORIm9WhVOBIn9WdV
OP002CIL00@003hj?SXnF`<n>P07?U/n>Shj?SXnFchj00002dHi00l004XhCUQ:>4hhBSQ>F4Xh001:
>4iHBSQ>>4Xh00006Woo00<007ooOol0E7oo001LOol00`00Oomoo`02Ool01000Oomoogoo0P001Goo
00<0004G0CP00P0077oo00<007ooOol03Woo0P0000IOOE]MGgeKGEmmFed300001E]MGgd00000Ie/0
0P0000ISo6?KHoaSg6?lHm/4000036=LGcaSG5lkHe`005MNDceGGU<mEeiC?@<0000NDYYF^U:JE[YB
VP00AW]:VdIjBY]6NdZKAWY:VdIkBY/003YL=S/jG3Hk>U`f>cYL=S/jG0009Q`UnbXL1@0000@=o0Wk
3O`9o0<0000j9UdZORIM:WhVGBYn9Ud0039L=U`bG3IM<U`fG39L=UdbG3IL0012Fchj@U/n>T9K?SY2
Fchj@U/n>T9K0016FTHiAUU6>DIJASU6FDHiAUY6>DIIAST004XhCUU:>4iIBSQ>FDXh001:>4iIBSQ>
FDXh000JOol00`00Oomoo`1COol005aoo`03001oogoo009oo`05001oogooOol00007Ool00`000AL1
5`03000KOol00`00Oomoo`0;Ool20005Ggd30007Ggd;00000emLHeaO?002Ge`00f=LGcaOG0020000
1E<mEeh00000DYX00U:j00IF^U:JD[YB^UJj0002AW/01DZKAW]6NdIkBY/00dIk00]:V`00>U`fFcYL
=S/jG3IK>U`f>`00008V70059O/V72HL9Q`Un`0300032O`00`gl0000000200001RIm9WhVOBIn9Wd0
00TfG005000n>Shj?SXnF`03?SX01SiK?SXn>Shj?U/000]6>@0?001>>4XhCUQ:>4hhBSQ>F4Xh001:
>4iHBSQ>>00001Yoo`8005Aoo`00@goo0`0000Aoo`000000019oo`03001oogoo009oo`03001oogoo
008000Qoo`8000030CP0000000<001Uoo`8000Uoo`800004GgeKGEmmFed3000025]MGgeKGEmmFeeO
OE]MGgd200001T^kCma;^doLBk]?g0@0000;Gc]SG5llHeaO>f=LGcaSG5lkHeaO?0020000:EJjDYYF
^U:JE[YBVUJjDYYF^U:JE[X004ZKAW]:VdIjBY]6NdZKAWY:VdIk000f>cYL=S/jG3Hk>U`f>cYL=S/0
02Gk9Q`UnbXL9O/V72Gk:Q`00`0000H=o0Wl3O`0017l3M`30000=2IM:WhVG@00<U`fG39L=UdbG3IL
<U`fGC9L000n>T9K?SY2Fchj@U/n>T9K?SY2Fchj0016>DIJASU6FDHiAUY6>DIIASU6FTHi001:>4iI
BSQ>FDXhCUU:>4iI001>FDXhCUU:>0006goo00<007ooOol0DWoo0014Ool01@00Oomoogoo000057oo
10000goo0P002Goo0`0000@15`000GP1N@8001Uoo`03001oogoo00Aoo`8000=OO@<000UOO@800006
Cma;_4oLCka?g4^l10000UmL00ISG5llGeaOG6=LGc`2Ge`01V=L000005Zi001BVP9B^P06E[YBVU:j
D[YF^U:J0U:j00EF^P00AW]6NdZK00=6N`0?BY]6NdIkAW/003Hk>U`fFcYL=S/jG3IK>U`f>`00008V
70089O/V72HL9Q`Un`005M/Eg08000072O`=o0004O`=o17l3M`010002CIL00<003iK?SX00Shj00Dn
Fchj?SXn>SiK00<n>P030016>DHi00U6>@0?001:>4hhBSQ>F4XhCSQ:>4iH001>>4XhCUQ:>00001]o
o`03001oogoo055oo`00A7oo00D007ooOomoo`0001]oo`03001oogoo00Uoo`D000030EP1N@5H00<0
01Moo`03001oo`0000<00003Bem;?P000080000BFeeOOE]MGgeKGEmmFeeOOE]MGgeKG@00Bk]?g4^k
Cma;^doL100000]O?6=LGc]SG5llHeaO>f=LGcaSG5lk0080000bG]YJ^EkJF[T005:JE[YBVUJjDYYF
^U:JE[YBVUJjDYYF^P00BY]6NdZKAWY:VdIkBY]6NTZK000jG3Hk>U`f>cYL=S/jG3Hk>U`f>`009O/V
72Gk:Q`UnbHL9O/001GK5M`Ef`8000083O`0017l3M`Ao0gK4O`=g0<0000_<U`fG39L=UdbG3IL<U`f
G@00@U/n>T9K?SY2Fchj@U/n>T9K?SY2F`00AUU6>DIJASU6FDHiAUY6>DIIASU6FP00CUU:>4iIBSQ>
FDXhCUU:>4iI001>FDXhCUT0000LOol00`00Oomoo`1@Ool004Aoo`05001oogooOol0000KOol2000<
Ool00`000GT0000200000`5i0GP1N@04000BOol40002Bel01d]N00000000Bei;G`0000UOO@800005
Cka?g4^lCma?_002000016>M000006Lj0P0000ISG5llGeaOG6=LGc`2Ge`02P00F[UNfEZiG]UJ^EkI
001F^U:J0U:j00IF^U:JD[YB^UJjDYX2D[X01@00AW]6NdIkBY/00TIk2P0000Df>cYL=U/jG00000<V
70089O/V72HL9Q`Un`005M/Eg08Ef`<000074O`=o17l3M`Ao0gl4O`010001CIL00<003hj?U/00chj
00LnFchj?SXn>SiK?SX0000<AST03`00CUQ:>4hhBSQ>F4XhCSQ:>000BSQ>>4XhCUP0000KOol00`00
Oomoo`1@Ool004Aoo`80009oo`03001oogoo01Uoo`03001oogoo00aoo`030001VP5i00<000050EP1
N@0000066`040007Ool7000014]OBci;Gd/n0`0000I;?T]OBci;Gd/nBel200001E]MGgeKGEmmFed0
0P0000E?g4^kCma;^doL0080000>HiaS_@00Ic]S>VLkHcYW>`00HeaO>f=LGcaSG080000DF[UNfUZi
G]YJ^EkJF[UNfP00E[YBVUJjDYYF^U:JE[YBVUJjDYYF^PL0000:BSU:64XhAQP003hH@QTmn48I?QP7
00003BGk9Q`UnbXL9O/V70005M`EfaGL5M/Eg1GK0080000:4O`=g17l3M/Ao0gL4O`001hM6O`30000
:S9L=U`bG000?SY2Fchj@U/n>T9K?SY2Fchj@U/n>P00ASU6FDHiAUY6>DIIASU6FTHiAUU6>@00BSQ>
FDXhCUU:>4iIBSQ>FDXh001:>4iIBSP001aoo`03001oogoo04moo`00A7oo00@007oo000001aoo`03
001oogoo00eoo`8000030GT1NP00008000050GT1N0001Q`:70021Q`700001R[O:]hZgb[N:]lZgPD0
0005Bei;Gd]OBem;GP03Bel00d]NBem;G`0200001Emm000004^lCm`01@0000ESWF>LHid006Lk00=W
>P03Ic]W>VLj0080000AGc`00000G]UJ^EkIF[UNfEZiG]UJ^EkIF[UNf@00E[YBVP02D[X015JjDYYB
^U:j0P0000=BF000BSP02DXh00@0048I@QTn6@=26@05?QU26D8I000en@0300001BGk9Q`V72HL0000
0QGK00DEg1GK5M/EfaGL008000073O`Ao0gL4O`=o0007O`00ahL00<Mo00000000P000Shj00DnFchj
?SXn>SiK00<n>P03?U/004Hi00Y6>@0?001>>4XhCUQ:>4hhBSQ>F4XhCSQ:>000BSQ>>00001Yoo`80
0003Ool007oo04moo`00A7oo00<007ooOol07Goo0P0047oo0`0000<1N@0000000`0000D66`XL1Q/:
?0HK00800008;_lZgRkO:]h^ob[N;]lZgP@0000>Bem;?T]OBci;Gd/nBem;?T]OBci;Gd/nBem;?PP0
0004HkeSW6>mHi`200007VLkHcYW>f<jIc]S>VLkHcYW>f<j001J^EkJF[UNfUZiG]YJ^EkJF[UNfUZi
G]YJ^EkJ001F^U:JE[YBVP<0000MCSMBF4hgDUP004XhAQQ:>DXHBSQ664XiBQQ:>000@QTn648I?OQ2
6ChH@QTmn48I?QP003Gi=QXen@05000021GK5M`EfaGL5M/Eg1GK5M`30000317l3M/Ao0gL000Io1hM
6O`N71Wl7QdIo0@0000T@U/n>T9K?SY2Fchj@U/n>T9K0016FTHiAUU6>DIJASU6FDHiAUY6>DII001>
FDXhCUU:>4iIBSQ>FDXhCUU:>000BSQ>F@005Woo0`0000AGGE]n0000051oo`00@goo0P001Woo1000
1Goo0P001Goo100017oo00<007ooOol04Goo00<001iM00001`0000D:70HL1Q`670XL00800004:]hZ
gb[N:]l2000012[N:]lZgR[O0P000T]O00I;GT]OBem;Gd]NBel80002Hid026>LHieSWF>MHi`006Lj
Ic/3IcX06FLkIcYW>VLjIc]W>P00H]T005ZiG]UJ^EkIF[UNfEZiG]UJ^EkIF[UNfEZi001B^UJj0080
009BF006CUQBF59HDUQ>F0002TXh00D0048I@QU26ChI00=26@05?QU26@00=OXen@03=OX00cGi=OX0
000200025M/01aGL5M/EfaGK5M`000fk008000053M`Ao0gl000Mo0037Q`01Qgl7Q`N71hL000^?0@0
0003?SXnFchj008n>P030016>DHi00U6>@0;001:>4hhBSQ>F4XhCSQ:>4iHBSQ>>004000COol40000
1EMNEeeKOUMMEeh00P00Cgoo001:Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomo
o`02Ool01@00Oomoogoo000057oo00D001hm7UdN?AiN00T000032Q`66`0000<00008;_lZgRkO:]h^
ob[N;]lZgP800003Bem;?P0000L0000XCmd00000HiaS_F>LHkeSW6>mHi`006<jIc]S>VLkHcYW>f<j
Ic]S>VLkHcX005kHH_URf000F[UNfUZiG]YJ^EkJF[UNfUZiG]YJ^EkJF[T20000:59HCSMBF4hgDUQ>
=e9HCSMBF4hg001:64XhAQQ:>DXHBSQ664XiBQP003gh@QTn648I?OQ26ChH@QTmn48I000f6SGi=QXe
nCHJ=OTf6SGi100000PEg1GK5M`Ef`002K/=g0Vk0P00010Ao0gL000Io1hM6O`N71Wl7QdIo1hL000^
GBhl;UdZ?0@0000B@U/n>P00ASU6FTHiAUU6>DIJASU6FDHiAUY6>@00BSQ>FDXh1P0000E>_000CY]:
V`00011oo`8000840007001KOUMMFgiGGE]nEed00P00Cgoo001:Ool00`00Oomoo`02Ool00`00Oomo
o`0=Ool01000Oomoogoo0P0057oo00@001iM7UdN?@<NG@037Sd0000002400004HiaSWF>MHid20000
0fLjIc]W>P02IcX01fLkIcYW>VLjIc]W>P00009Rf@0>H]QRf@00G]UJ^EkIF[UNfEZiG]UJ^EkIF[UN
f@<000=BF005CUQBF59HDUQ>F003DUP00`00BSQ:>008BSP00`00?QU26@02@QT01ShI@QU26D8I?QT0
008enP07=OTenSGj=OXenCGj00000bWk0`000QGK00D000Vk3K/9^`fk00<000037Q`Mo1hL008N7004
7O`N71hL0008;S`B0008BY/00`00BY/0000=Ool3000410001`00EeeKOUMMEeiGGE]n008004moo`00
BWoo00<007ooOol00Woo00<007ooOol03Goo00D007ooOomoo`0001Ioo`09000N?AiM7SdNGQhm7UdN
?AiN00<000032U`0000000d0000>>el00000EgeKWU]mFgiGOE^N001WFf<kIe]SF`@0000LIc]S>VLk
HcYW>f<jIc]S>VLkHcYW>f<j001Nf6;iH]QRnEkHH_T005kJF[UNfUZiG]YJ^EkJF[T20000<eYhEWMJ
N000DUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF000BSU:64XhAQQ:>DXHBSQ664Xi00126Cgh@QTn648I?OQ2
6ChH@QTmn000=OTf6SGi=QXenCHJ=OTf6P00:O/UfRWk9MXYn`0400001@Vk3M`9^`gK2K/00`0002dI
o1hM6O`N71Wl7QdIo000:S`^GBhl;UdZ?2iM;S`^GBXl;Ud003il>U/nO3iL?W`jFcil?U`nO3YK?W`0
04jKBY]>_4ZKCY]:VdjlBY]>VdZKC[`004jK00002Woo0P001@@00P0000EGGE]nEeeKOUMM00800003
Ool007oo04ioo`00BWoo00<007ooOol00Woo00<007ooOol02Goo100017oo00<007ooOol05Goo00D0
01iM7UdN?AiM00<0008NG@D000<k?`05>elk?c/o>clkG`03>cl200001U]nFgeKOU]mFgiKO@8000MW
F`04001W6@000003IcX01FLkIcYW>VLjIc/00P000V;I00iRf6;IH]URfF;HH]T005kIF[UNfEZiG]UJ
^@000UIh00EFMeIhEWP004iH00=BF005CUQBF59HDUQ>F002DUP00`00BSQ:>008BSP00`00@QTn6@03
@QT01ChI@QU26D8I00000cGj00LenCGj=OXenSGi=OX00007:O/300001@fk2K/=^`Vk3K/010000QhL
00@Mo1hL7Q`000T^?003000nO3il00TnO003001:VdZK00U:V`03001:V`0000Qoo`8000<400D00003
EeeKOUMM00<000Aoo`03001oogoo04aoo`00BWoo00<007ooOol00Woo00<007ooOol02Goo00<007oo
Ool01Goo0P005goo2@0000A6gDKN@]e6oP800008=chkGcLn>elg?S]O=chkG`80000/FgeKOUMmFiiK
OE]nEgd006=KIe]S>fMKHe]WFf<kIe/006/JIaU[>VLI001S>VLkHcYW>f<jIc/006;iG]QRnF;HH_UN
f6;iH]QRnEkHH_T005kJF[UNfP80000kEUMJN5IgFWQFEeYhEWL004hgDUQ>=e9HCSMBF4hgDUQ>=e9H
CSL004HHBSU:64XhAQQ:>DXHBSQ66000?QQ26Cgh@QTn648I?OQ26ChH@QT003HJ=OTf6SGi=QXenCHJ
=OT002GJ:O/UfRWk9MXYnbGJ:O/UfP0300001`Vk3M/9^`gL0009g0WK00<0000X6O`N7AWl000Z?2iM
;S`^GBXl;Ud^?2iM:S`003iL?W`jFcil?U`nO3YK?W`nG3il>U/004ZKCY]:VdjlBY]>VdZKC[a:VdjK
BY/004ZK0005Ool700001Q@0600D01@0001KOP8000Moo`03001oogoo04aoo`00BWoo00<007ooOol0
0Woo00<007ooOol02Goo00<007ooOol017oo00<007ooOol05Goo1P000dKM00E6gTKMA]e6gDKN00=6
g@<00003>clkGc/o00800009FgiKOE]nFgeKOU]mFgiKO@0000QWF`03001W6FLI00AW6@06001W>VLj
IcYW>`000f;I00ERf6;IH]URfF;H00=Rf@03H]P005Zi008000=FN009EWMFN5IhEWQFMeIh001BF4iH
00=BF007CUQBF59HDUQ>F59H00002TXh00@0048I@QTn6@=26@05?QU26D8I000en@03=OX01SGi=OXe
nSGj=OT000PYn`03000Io1Wl008000083K/9^`fk0009g0WK2M`9f`@000T^?003000nO3il00TnO003
001:VdZK00Y:V`03001:V`00009oo`D000LD00<000Uoo`03001oogoo04aoo`00Bgoo100037oo1@00
0Woo00<007ooOol04Woo0`0017oo010004KMA]i2gDKnA]e6gT;MA_i6gDKN@]e6oTKMA]i2g@<0000K
EgeKWU]mFgiGOE^NFgeKOUMm001SFfMKHc]WFf=KIe]S>fMK001[6VLIJcYW6F/JIaU[>VLI0080001E
Ic/006;iG]QRnF;HH_UNf6;iH]QRnEkHH_URf6;iG]P005IgFWQFEeYhEWMJN5IGFWQFMeYhEUMJN000
DUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF000BSQ664XiBQQ:>4HHBSU:64Xh00126ChH@QTmn48I?QQ26Cgh
@QTn6000=OTf6SGi=QXenCHJ=OTf6SGi000UfRWk9MXYnbGJ:O/UfRWk000Io1GK6O`00P0000T9^`00
2M/9g0WK3O`9f`WL2M/00`00024Z?2iM;S`^GBXl;Ud^?2iM000nO3iL?W`jFcil?U`nO3YK?W`nG3il
001>_4ZKCY]:VdjlBY]>VdZKC[a:VdjKBY/01P000Q@000DH01@0500D01P000<D0003001oogoo00Uo
o`03001oogoo04aoo`00HWoo0P0047oo0`0027oo00<004KMA]h00dKM00E6gTKMA]e6gDKN0096g@80
00=Jn`800005FgiKOE]nFgeKOP020008Ie/00`00IaUW6@09IaT01@00H]URfF;IH]P00f;I00ERf6;I
H]URfF;H009Rf@03001NU`00009FN005EWMFN5IhEWQFM`03EWP01EIg001BF59HCUP00e9H00I>F59H
DUQBF4iH000:BSP01P00@QU26D8I?QU26@X00005=OTenSGj=OX00009:O/00`006O`Io0026O`30000
20WK2M`9f`WL2M/9g0WK2M`40005;S`00`00?W`nO00:?W`00`00BY]:V`09BY/00`00BY/000022000
0`00500D00065002000<Ool00`00Oomoo`1<Ool0069oo`03001oogoo00aoo`<000aoo`800008A]i2
gDKnA]e6gT;MA_i6g@800007FaaJne/LF_]K75[kFa`00P0002IKOE]n001WFf=KIe]S>fMKHe]WFf<k
Ie/006/JIaU[>VLIJaYW6F/jIaU[6VLIJcX006Ki001RnF;HH_UNf6;iH]QRnEkHH_URf6;i0P00025J
Uejh001JN5IgFWQFEeYhEWMJN5IGFWQFMeYhEUL004hgDUQ>=e9HCSMBF4hgDUQ>=e9HCSL004XHBSQ6
64XiBQP02P0000Y:64GgAQQ5m`00@OQ26Cgh@QU1n0P0000=:O/UfRWk9MXYnbGJ:O/001Wl5M/Io1WK
6O`00`0000X9g0WK3O`9f`WL2M/=o0005SdB70<0000L:S`^GBhl000jFcil?U`nO3YK?W`nG3il>U/n
O3iL001:VdjlBY]>VdZKC[a:VdjKBY]>_4ZKCY/2000010P0000D01P00a@01@003Goo00<007ooOol0
C7oo001ROol2000;Ool2000AOol00`00A]i6g@02A]d01DKN000005[kFa`00e[k00IK75[kF_]Jne/L
F_/30008Ie/00`00IaUW6@09IaT01@00I_QVn6Kh00000f;I00URf6;IH]URfF;HH]T005jHGYL00ejH
00D005IhEWQFN5Ig00=FN005EWMFN5IhEWP00003DUP01DiHDUQBF59HCUP00U9H1`0014XG00`004HG
AOM65dGgAQM5mdHGAOM65dGg0002@QP01D7h@QQ2648H@OP00T8H00<003XJ>QX01P0000<Yn`006O`0
1QWl100000X9g0WK2M`9f`WL000F?A8m5SdB?@@000`nO003001:VdZK00Q:V`D00003500000000080
00<@0003001oogoo00aoo`03001oogoo04aoo`00HWoo00<007ooOol01goo0`0057oo00<004KN@]d0
0P0000aK75[kFaaJne/LF_]K75[kFaaJne/LF_/20000?fLJH_T00000Ie]SFfMKHc]WF`00JaYW6F/j
IaU[6VLIJcYW6F/JIaU[>P00I_URf6KiI_QVn@00H_URf6;iG]QRnF;HH_T005jhFYMN^5ZGG[QJU`00
EUMJN5IgFWQFEeYhEWMJN5IGFWQFMeYh001BF4hgDUQ>=e9HCSMBF0020000:DhF0019mThGBQI:5dWf
CQM:5TXGBOI>5`00AQQ5mdXHAOM664GgBQQ5mdHH00126D7h@QTmn48I@OQ26Cgh@QU1n000>QTn>SXJ
?SXj6Chj>QX01@0000DEfaWl6M/Io1GK0080000>2O`000000009g0WK000B?1Hm4Q`F?A8l5SdB70P0
000:?W`nG3il>U/nO000CY]:VdjlBY/600000d<o?cm3?`03000740000`00Oomoo`0=Ool00`00Oomo
o`1;Ool0065oo`03001oogoo00Eoo`<001Qoo`8000=Jn`05FaaJne[kF_]K7003F_/02E/LF_/006;i
IaYRnF<JH_UW6P020002Ie/00`00IaUW6@09IaT00`00I_QVn004I_P00`00H]QRf@02H]T01F;HH]T0
05jHGYL00ejH00ENUejHGYP005Ig00=FN005EWMFN5IhEWQFM`02EWP00`00CUQBF002DUP300001Dhg
CQI>=dhG00002DXG00`004GgAQM5mdHGAOM65dGgAQM5mdHG0003@QP0247h@QQ2648H@OQ26000?SX3
>QX023hj>QXj6SXJ?SXj6P00<U`600001AWl0009o0Gl2O`0100000hB?AHm4SdF?A8m5SdB?AHm000Z
_RJn:[hV_RZn2P000T<o00Do?d<o@cm3?clo0093?`03000o?`0000H@0003001oogoo00ioo`03001o
ogoo04]oo`00HGoo00<007oo00000Woo0`0077oo01L005/LF_]K75[kFaaJne/LF_]K75[kFaaJn`00
H_UW6V;iIaYRnFLJH_UW6V;i0080000HJaYW6F/jIaU[6VLIJcYW6F/JIaU[>P00I_URf6KiI_QVnF;H
I_UVn000G]QRnF;H0P0001QN^5ZGG[QJUejhFYMN^5ZGG[P005YhEUMJN5IgFWQFEeYhEWMJN5IGFWQF
M`00CSL20000>E8gCQIB=dhFDSM>5U8g001:5dWfCQM:5TXGBOI>5dXFBQL004XHAOM664GgBQQ5mdHH
AOM:64Gg000mn48I@OQ26Cgh@QU1n48I?OQ26@00?SXj6Chj>QXn>SXI?SXj6Shj000bGC9L<Ud^?39M
<U`bG@0500000`XL1O/9o00400001Q8L5SdB?1Hm4Q`F?@80000J9YhZ_bJn:[lVWRZo9[hZ_bJN:[l0
04<o?am3?clo@clo7d<o?cm3?clO@clo?`00?al0008@00<0015oo`03001oogoo04]oo`00HGoo1@00
87oo00<005/LF_/00U[k00EK75[kF_]Jne/L0080000=H_UW6V;iHaYRnFLJH_US6V;iIaX006LI0000
2FLI00<006KhI_P026Kh00<006;H00000UjH00ENUejHGYQNV5jG00=NV005GYMNV000EWQFM`03EWP0
1UIgEWQFN5IhEWMFN080000:CQI>=dhGCSM>5ThgCQM>=dhF000:BQL03@00AQM5mdHGAOM65dGgAQM5
mdHGAOL0047h00=26008@OQ2648H@QQ1n000>QXn>P<j6P06?SXj6SXJ>QXn>P000S9L00DbGC9L<U`b
G39M008bG003000NWP0000`0000=5SdB?@009[hZ_RJn:[hV_RZn9[hZ_RJn:[h00P0000Do?d<o@cm3
?clo00=3?`03?cm3?d<o00D001=oo`03001oogoo04]oo`00F7oo1@0017oo0P0097oo0P0004=Jne/L
F_]K75[kFa`006LJH_UW6V;iIaYRnFLJH_UW6V;iIaX006/II_Q[6@00JaYW6F/jIaU[6VLIJcX006Ki
H]QVnFKhI_URf6KiI_QVnF;HI_UVn000FYMN^5ZGG[QJUejhFYMN^5ZGG[QJUejhFYL005IgFWQFEeYh
EWMJN5IGFWQFM`030000@4hFDSM>5U8gCQIB=dhFDSM>5U8gCQH004XFBQM9mThGBQI:5dWfCQM:5P00
AOM:64GgAQQ5mdXHAOM664GgBQP0048I?OQ26D7h@QTmn48I@OQ26Cgh000j6Shj>QTn>SXJ?SXj6Chj
>QXn>P00<UdbG39M;S`bGC9L<Ud^?39M0P0000DJOAjN6WdNWQYm0140000:9[hZ_bJN:[lV_P00?am3
?clo@cl8000FOol00`00Oomoo`1;Ool005Yoo`03001oogoo00Eoo`03001oogoo02Aoo`0H001Jne[k
F_]K7000HaYRnFLJH_US6V;iIaYRnF<JH_UW6P00IaUVn6LII_QW6@001FLI00<006KhI_P02VKh00@0
06;H001NU`=NV005GYMNV5jHGYQNU`03GYP01EjG001FN5IhEWL00eIh0P0000mB=eIGDSL004hGCSM>
5ThgCQM>=dhFCSM>5dhg00002DXG00`004HGAOM65dGgAQM5mdHGAOM65dGg0002@QP01D7h@QQ2648H
@OP00d8H00@003XJ>QXn>P<j6P05?SXj6SXJ>QX00003<U`01C9M<U`bG39L<Ud00c9L00P001Ym7YhN
OQjN6WdNWQin600000Q[FfMJIeYWFV]K001oo`005Woo00<007ooOol0Bgoo001JOol00`00Oomoo`06
Ool2000UOol0?P00F_/00000IaYRnFLJH_UW6V;iIaYRnFLJH_UW6P00JaUVn6/II_Q[6FKhJaT006/J
IaU[>P00I_URf6KiI_QVnF;HI_UVn6KiH]QVnFKh001R^6KH001N^5ZGG[QJUejhFYMN^5ZGG[QJUejh
FYMN^000FWQFMeYhEUL20000AUIGDSIFEe8fEUL0058gCQIB=dhFDSM>5U8gCQIB=dhF0019mThGBQI:
5dWfCQM:5TXGBOI>5`00AQQ5mdXHAOM664GgBQQ5mdHHAOL0047h@QTmn48I@OQ26Cgh@QU1n48I000n
>SXJ?SXj6Chj>QXn>SXI?SXj6P00;S`bGC9L<Ud^?39M<U`bGBhl2@0000Ho7clo?am3?clO?cl20000
1U]MFgiGGE]n001WF`80000=HkaS_@00Je]W>V]KIcY[FfLjJe]W>V]K00000goo00<007ooOol04goo
00<007ooOol0Bgoo001JOol00`00Oomoo`08Ool00`00Oomoo`0SOol06P00H_US6V;iIaYRnF<JH_UW
6V;iHaYRnFLJ001W6FKhIaUVn6LII_QW6FKhIaT006LI000<I_P00`00H]QRf002H]P00`00GYQNU`03
GYP01EjGGYQNV5jHGYL00ejH01P005Ih0000058gDUMB=eIGDSMBEe8g001>5ThgCQM>=dhFCSM>5dhg
CQI>=dhG0009BQL03000AOM65dGgAQM5mdHGAOM65dGgAQL000=26005@OQ2648H@QQ1n002@QP01@00
>QXj6SXJ?SX00cXJ00Dn>SXJ>QX0039M008bG0H00005AYa:_4Zl000o7`03?cl01ClO?clo?clo?al0
0P0000AKOU]MFgeKO@8000AWF`800005Je]WFVMJIeY[F`03IeX00f]K001oo`04Ool00`00Oomoo`0C
Ool00`00Oomoo`1:Ool005Yoo`03001oogoo00Uoo`03001oogoo02=oo`0h001RnFLJH_UW6V;iIaYR
nFLJH_UW6P00JaUVn6/II_Q[6FKhJaUVn6/II_Q[6@00I_URf6KiI_QVnF;HI_UVn6KiH]QVnFKh001R
^6KHH[QRf6:h001JUejhFYMN^5ZGG[QJUejhFYMN^5ZGG[QJU`80000lEUMB=UIGDSIFEe8fEUMB=UIG
DSH004hFDSM>5U8gCQIB=dhFDSM>5U8g001:5dWfCQM:5TXGBOI>5dXFBQL004XHAOM664GgBQQ5mdHH
AOM:64GgAQP0048I@OQ26Cgh@QU1n48I?OQ26D7h000j6Chj>QXn>SXI200000Y:_4JLB[a6VdZlAYa:
_4JKB[a6W0800005@clo7clo?am3?`0200001UMMFgiKGE]nEed0009WF`0?He]WNfMKIe/006/j001[
FfLjJe]W>V]KIcY[F`0000Ioo`03001oogoo01=oo`03001oogoo04Yoo`00FWoo00<007ooOol02Woo
00<007ooOol08goo01P006;iHaYRnFLJH_US6V;iIaX006LII_QW6FKhIaUVn6LII_QW6FKhIaT006[h
000:I_P00`00H]QRf005H]P01000GYQNV5jG0ejH00ANUejHGYQNV0<0000GEUMB=e9GDSMFEe8gDUMB
=eIGDSMBE`00CSM>5ThgCQM>=dhFCSM>5dhgCQH0000:BQL03@00AQM5mdHGAOM65dGgAQM5mdHGAOL0
047h00=26004@OQ2648H@QP80006BUT00`00B[a6W003B[`01DJLB[a:_4ZlAY`00dZl00<003lo?cl0
0P000U]m00EKOU]MFgeKO@0000IWF`06001[>V/iJcT006]K0fMJ00=[F`00Ool01goo00<007ooOol0
4Woo00<007ooOol0BWoo001HOol3000=Ool2000TOol20000IFLJH_UW6V;iIaX006/II_Q[6FKhJaUV
n6/II_Q[6FKhJaT006/II_Q[6@00I_URf6KiI_QVnF;HI_UVn000H[QVf6:hH]QR^6KHH[QRf000G[QJ
UejhFYMN^5ZGG[QJUejh001JN5IGFWP005IGDSIFEe8fEUMB=UIGDSIFEe8f001>5U8gCQIB=dhFDSM>
5U8gCQIB=`00CQM:5TXGBOI>5dXFBQM9mThGBQH004GgBQQ5mdHHAOM:64GgAQQ5mdXHAOL003gh@QT0
1@0000A>>4XGCSP0009:F@05CUY:FDYIBUU>FP03BUT03P00AYa:_4JKB[a6W4ZlAY]:_4JLB[a6VdZl
AY`3000025]MFgiGGE]nFeeKOUMM0002Ie/03f=KIg]WFfMK001[>VLiJcYW6F/j001[FfLjJe/0000:
Ool00`00Oomoo`0AOol00`00Oomoo`1:Ool005Yoo`03001oogoo00eoo`03001oogoo02=oo`0F001S
6V;iIaX006LII_QW6FKhIaUVn6LII_QW6FKhIaT006[hI_Q[66KhJ_P20005I_P00`00H]QRf008H]P0
1@00GYQNV5jHGYL00ejH01d005YgEWMJN5Ig001B=eIGDSMBEe8gEUMB=e9GDSMFEe8g001>5dhgCQI>
=dhGCSM>5ThgCQM>=`0000U:5`0:00165dGgAQM5mdHGAOM65dGgAQL500002DXhBSM:>4XGBSQ:=dXh
BQL0000;BUT01000B[a:_4JL0dZl00A6W4ZlB[a:_0800008F]]Jn`00001KOE]nFeeKO@8000IWF`03
001[>V/i009[>@06JcY[>F/i001[F`0037oo00<007ooOol047oo00<007ooOol0BWoo001[Ool00`00
Oomoo`0SOol0;@00IaX006/II_Q[6FKhJaUVn6/II_Q[6FKhJaT006/II_Q[6FKhJaUVn6/II_P006;H
I_UVn000H[QVf6:hH]QR^6KHH[QRf6:hI]QR^000FYMN^5ZGG[QJU`020000:UYhEUMJN5IgFWP005IG
DSIFEe8fEUMB=UIGDSIFEe8fEUL0058gCQIB=dhFDSM>5U8gCQIB=dhF0019mThGBQI:5dWfCQM:5TXG
BOI>5`00AQQ5m`H0000?CQM9mP00BQM>>4XGCSQ:5dhhBQM>>4XGCSQ:5`0000=:F@05CUY:FDYIBUU>
FP03BUT02000AYa:_4JKB[a6W4ZlAY/200001U[kE]YJneKJF_]FfP800003Fgh006Mk009WF`0?He]W
NfMKIe/006/jIcU[>VLIJcYW>F/jIaU[>P0000eoo`03001oogoo011oo`03001oogoo04Yoo`00K7oo
00<007ooOol08goo01X006LII_QW6FKhIaUVn6LII_QW6FKhIaT006[hI_Q[66KhJ_QVn6/HI_QZn6Kh
001Vn0003F;H02@005jGGYQNV000EWMJMeIgFWQFMeYgEWMJN000DUMB=eIGDSMBEe8gEUMB=e9GDSL0
04hFCSM>5dhgCQI>=dhGCSM>5Thg0008BQL500001DXFBQM:5dhGBQH00TXG00i>5dXF001:=dXhBQM:
>4XgBSQ:5dXhBSM:>00034YI00D004ZlB[a6W4Zl00800005F]YJfe[KF_]JfP02F]/015[kF]YJf`00
1fMK00<006/jJcT00V/i00I[>V/iJcU[>F/j000?Ool00`00Oomoo`0?Ool00`00Oomoo`1:Ool006eo
o`8002Aoo`0X001[6FKhJaUVn6/II_Q[6FKhJaUVn000I_Q[6FKhJaUVn6/II_Q[6FKhJaUVn000H[QV
f6:hH]QR^6KHH[QRf6:hI]QR^6;HH[QVf000G[P200008eIgFWQFEeYhEWMJN5IGFWQFM`00DSIFEe8f
EUMB=UIGDSIFEe8fEUMB=P00CQIB=dhFDSM>5U8gCQIB=dhFDSL004XGBOH01@0001a9mThG001>5dXF
CQM9mThGBQI>5dWfCQM:5ThG001>>4XGCSQ:5dhhBQM>>4XGCSQ:5dhh001>FP=:F@05CUY:FDYIBUU>
FP02BUT00`00B[a6W00200004E[kE]YJneKJF_]FfU[kE]YJneKJF_/006LJ001WFf=KIg/00VMK00/0
06/jIcU[>VLIJcYW>F/jIaU[>P00015oo`03001oogoo00moo`03001oogoo04Uoo`00Kgoo00<007oo
Ool08Woo01P006LII_QW6FKhIaUVn6LII_P006KhJaQVn6[hI_Q[66KhJ_QVn6/HI_P006Kh000>H]P0
8P00FWQFMeYgEWMJN5IgFWMFMeYhEWMJMeIg001B=e9GDSMFEe8gDUMB=eIGDSMBE`00CSM>5ThgCQM>
=dhFCSM>5dhg100000E:5ThFCQI>5TXF00=>5P05001:5dXGCQM:5P02BQL04DhGBQI:5dXG001:5dXh
BSM:>4XGBSQ:=dXhBQM:>4Xg000034YI0P0000=Jfe[kF]X00U[K00IJne[JF]]Jfe[kF]X2000016<J
H_URnP000fMK00<006/jJcT00V/i00I[>V/iJcU[>F/j000COol00`00Oomoo`0>Ool00`00Oomoo`19
Ool0071oo`03001oogoo029oo`80000QI_Q[6FKhJaUVn000I_Q[6FKhJaUVn6/II_Q[6FKhJaUVn000
I_Q[6FKh001R^6KHH[QRf6:hI]QR^6;HH[QVf6:h00<0000NEWMJN5IGFWQFMeYhEUMJN5IgFWQFEeYh
001FEe8fEUMB=UIGDSIFEe8fEUMB=P00CQIB=dhFDSM>5U8g0`0002M>5`00CQM9mThGBOI>5dWfCQM9
mThGBOH004WfCQM:5ThGBOI>5dXFCQM9mThGBQH004XGCSQ:5dhhBQM>>4XGCSQ:5dhhBQL004YICUX0
0dYI00A>FTYIBUU:F@80000PEYT005[kE]YJneKJF_]FfU[kE]YJneKJ001RnFLJH_UW6V;iIaX006MK
001[>VLiJcYW6F/jIcU[>VLIJcX001Aoo`03001oogoo00ioo`03001oogoo04Uoo`00LGoo00<007oo
Ool08goo01H006KhIaUVn000I_Q[66KhJ_QVn6/HI_QZn6KhJaQVn000I_QW6FKhIaT000YRf00N001N
^5jhG[P005IgFWQFMeYgEWMJN5IgFWMFMeYhEWL0058gEUMB=e9GDSMFEe8gDUMB=eIGDSL004hG1000
00I>5dhFCQI>5ThG0003CQH01DXFCQI>5ThFBQH00ThF00H004XFBQM:5dhGBQH2BQL044hGBQI:5`00
BSQ:5dXhBSM:>4XGBSQ:=dXhBQM:>0001dYI0P0000EFN5JIEYT005[J009Jf`0AF_]JfU[KF]]Jne[J
001RnF<JH_URnV;iHaYRnF;j001[>P03JcT01V/jJcU[>F/iJcX001Ioo`03001oogoo00eoo`03001o
ogoo04Uoo`00LWoo0P0097oo03X006Kh001Vn6/II_Q[6FKhJaUVn6/II_Q[6FKh001Vn6/II_Q[6FKh
JaT006;HH[QVf6:hH]QR^6KHH[P005ZHG[UN^5ji001JN5IgFWQFEeYhEWMJN5IGFWQFMeYhEUL0058f
EUMB=UIGDSIFEe8fEUMB=P<0000]CQI>5dhFCQM>5ThGCQI>5dhF0019mThGBOI>5dWfCQM9mThGBOI>
5`00CQM9mThGBQI>5dWfCQM:5ThGBOI>5`00CSQ:5dhhBQM>>4XGCSQ:5dhhBQM>>000009:F@0VCUY:
F@00001FVEIhEYUFN5JIEWP005KJF_]FfU[kE]YJneKJ001RnFLJH_UW6V;iIaYRnFLJ001[>@00JcYW
6F/jIcU[>VLIJcX001Qoo`03001oogoo00aoo`03001oogoo04Uoo`00M7oo00<007ooOol08Woo01H0
06KhJaQVn6[hI_Q[66KhJ_QVn6/HI_P006KhIaUVn6LII_QW6FKhIaT000ERf08000IN^00D001JMeIg
FWQFMeYgEWMJN5IgFWMFMeYh001BEe8gEUMB=e9GDSMFE`800003CSL004hF009>5P05CQM>5ThFCQI>
5`02CQH00`00CQI:5P03CQH02DXFCQI>5ThFBQH004XGCQM:5P02BQL04dhGBQI:5dXGCQM:5P00BSM:
>4XGBSQ:=dXhBQM:>4XgBSQ:5`00009:F@80009FV@05EWQFVEJIEYUFN002EYT05@00F]YJfe[KF_]J
fP00H_US6V;iH_YRnF<JH_URnP00JaUW6F/I001[>P03JcT00f/j001oo`0IOol00`00Oomoo`0;Ool0
0`00Oomoo`19Ool007Eoo`03001oogoo029oo`0c001Vn6/II_Q[6FKhJaUVn6/II_Q[6@00JaUVn6/I
I_Q[6FKhJaUVn6/I001Rf6:hI]P005jiFYQN^EjhG[UJV5jiG[P005IGFWQFMeYhEUMJN5IgFWQFEeYh
EWL0058fEUMB=UIG00<0000aDSM>5U8gCQH004hFCQM>5ThGCQI>5dhFCQM>5ThG001>5dWfCQM9mThG
BOI>5dWfCQM9mP00BQI>5dWfCQM:5ThGBOI>5dXFCQL004hhBQM>>4XGCSQ:5dhhBQM>>4XGCSP00`00
00mFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWP005KJF_/00P0001=RnFLJH_UW6V;iIaYRnFLJ001[>FLH
JaUW66/i001[>VLIJcX0000KOol00`00Oomoo`0<Ool00`00Oomoo`18Ool007Ioo`03001oogoo029o
o`0F001Vn6/HI_QZn6KhJaQVn6[h001W6FKhIaUVn6LII_QW6FKhIaUVn000H]P2000:G[P03P00EWMJ
MeIgFWQFMeYgEWMJN5IgFWMFM`00DSL200002E8gCSIB=dhgDSM>=U8g001>5`03CQH01dhGCQI>5ThF
CQM>5P00009>5P05BQI>5ThFCQI:5P03CQH01@00BQM:5dhGBQH00TXG00i>5dXFBQM:5dhG001:>4Xg
BSQ:5dXhBSM:>4XG0P0000=BF59G00000UJI00EFN5JIEYUFVEIh00=FV@0AEWQFV@00F_/006;jH_US
6V;iH_YRnF<JH_URnP00JaUW6@03JaT01FLIJaT006/j00007Goo00<007ooOol02goo00<007ooOol0
B7oo001gOol2000SOol20000:V/II_Q[6FKhJaT006/II_Q[6FKhJaUVn6/II_Q[6FKhJaUVn000G[QN
^EZHG[UN^5jiFYQN^EjhG[UJV5ji001JN5IGFWQFMeYhEUMJN5IgFWQFE`<0000bCQIB=dhFDSM>5U8g
CQIB=dhF001>5ThGCQI>5dhFCQM>5ThGCQI>5`00CQM9mThGBOI>5dWfCQM9mThGBOH004WfCQM:5ThG
BOI>5dXFCQM9mThGBQH004XGCSQ:5dhhBQM>>080000WDUMFF59GEUP005JIEWQFVEIhEYUFN5JIEWQF
VEIhEYUFN5JI001W6V;iIaYRnFLJH_UW6V;iIaX006/iIaQ[6FLHJcUW66/IIaQ[>@0001moo`03001o
ogoo00Yoo`03001oogoo04Qoo`00NGoo00<007ooOol08Woo01@006/HI_QZn000IaUVn6LII_QW6FKh
IaUVn6LII_QW6FKh001Rn@0035jh00P005YhEWMJMeIgFWQFMeYg0P00011BE`00CSMB=dhfDSM>=e8g
CSIB=dhgDSM>=P00CQI>5`=>5P06CQM>5ThFCQI>5`000dhF00E:5ThFCQI>5TXF009>5P06001:5TXG
BQM>5dXF0TXG00Q>5dXFBQL004XhBQM:>4Xg0P000U9G00IBF59GDUMBEe9H0003EYT01EIhEYUFVEJI
EWP00eJI00d005jh001S6V;iH_YRnF<JH_URnV;i001W6@03JaT01FLIJaU[6F/I00008Goo00<007oo
Ool02Goo00<007ooOol0B7oo001jOol00`00Oomoo`0ROol03P00JaT006/II_Q[6FKhJaUVn6/II_Q[
6FKhJaT2000056;iIaX005jiG[QN^EZHG[UN^5jiFYQN^EjhG[UJV000EWMJN5IGFWP30000<eIHDUMB
F59G001>5U8gCQIB=dhFDSM>5U8gCQIB=`00CQM>5ThGCQI>5dhFCQM>5ThGCQH004WfCQM9mThGBOI>
5dWfCQM9mThG001>5dWfCQM:5ThGBOI>5dXFCQM9mThG001>>00200004e9GEUQBEeIHDUMFF59GEUQB
E`00EWQFVEIhEYUFN5JIEWQFVEIh0080000DH]UN^6;I001W6V;iIaYRnFLJH_T006LHJaUW66/iIaQ[
6FLHJcT0029oo`03001oogoo00Uoo`03001oogoo04Qoo`00Ngoo00<007ooOol08Woo01<006LII_QW
6FKhIaUVn6LII_QW6FKhIaT006LJH_US6V;iIaX0000<G[P05`00EWL00000DUQBEe9HDUMBF59GDUP0
058gCSMB=dhfDSM>=e8gCSIB=dhg00000dhF00E>5dhFCQI>5ThG00=>5P03001:5ThF009>5P09BQI>
5ThFCQI:5ThF001>5dXF009:5`05CQM:5TXGBQM>5`0300001E9HDUMBEe9GDUP00e9G00IBF59GDUMB
E`00EWP3EYT015IhEYUFV@000ejh00YNfEjhG[P006<JH_URnV;i001W6@=[6@05IaU[6F/IJaT0000T
Ool00`00Oomoo`08Ool00`00Oomoo`18Ool007aoo`03001oogoo029oo`0N001[6FKhJaUVn6/II_Q[
6FKhJaT006LJH_UW6V;iIaYRnFLJ001N^EjhG[UJV5jiG[QN^EZHG[UN^5ji0P0003=BEe9HDUMFF59G
DUQBEeIHDUMBF000DSM>5U8gCQIB=dhFDSM>5U8gCQH004hFCQM>5ThGCQI>5dhFCQM>5ThG001>5dWf
CQM9mThGBOI>5dWfCQM9mP00BQI>5dWfCQM:5ThGBOH00P0002eB=`00EUQBEeIHDUMFF59GEUQBEeIH
DUMFF59GEUP005JIEWQFVEIhEYUFN000G[QRfEjhH]UN^6;IG[P006;iIaYRn@00IaQ[6FLHJcUW66/I
IaQ[>FLH00009Goo00<007ooOol01goo00<007ooOol0B7oo001mOol2000SOol04P00IaUVn6LII_QW
6FKhIaT006LJH_US6V;iIaYRnF<JH_T000UN^0<0000HDUMBF59GDUQBEe9HDUMBF59GDUQBE`00CSIB
=dhgDSM>=U8gCSMB=dhfDSL004hG0dhF00M>5dhFCQI>5ThGCQH00002CQH01DXFCQI>5ThFBQH00dhF
00D004XGBQM>5dXF00<000AB=`04001BEe9GDUP3DUL01E9HDUMBEe9GDUP00U9G00<005JIEWP00UJI
00D005jhG[QN^5kI00=N^006G]UN^000H_T006LI0f/I00IW6F/IJaU[6FLI000VOol00`00Oomoo`08
Ool00`00Oomoo`17Ool007moo`03001oogoo025oo`800003I_Q[6FKh0080000AIaYRnFLJH_UW6V;i
IaYRnFLJH_T005ZHG[UN^5jiFYQN^@020003EYT0;`00DUMFF59GDUQBEeIHDUMBF59GEUP0058gCQIB
=dhFDSM>5U8gCQIB=dhFDSL004hGCQI>5dhFCQM>5ThGCQI>5dhF0019mThGBOI>5dWfCQM9mThGBOI>
5`00CQL00P0001Q>=U8gCSIB=dhfDSM>=P00DUMFF59GEUQBEeIHDUMFF59GEUQBEeIHDUL005IhEYT2
00005UjhH]UN^6;IG[QRfEjhH]UN^6;IG[P006LHJaUW66/iIaQ[6FLHJcUW6000:7oo00<007ooOol0
1goo00<007ooOol0Agoo0020Ool00`00Oomoo`0ROol04@00I_P006;iIaYRnF<JH_UW6V;iHaYRnFLJ
H_US6V;i00000ejh0P001EJI01X0059HDUMBF59GDUQBEe9HDUMBF59GDUP0058gCSIB=dhgDSM>=U8g
CSMB=dhf001>5ThG0dhF00I>5dhFCQI>5ThG0003CQH01TXFCQI>5ThFBQI>5P<000YB=`05001BEe9G
DUMBF003DUL01U9HDUMBEe9GDUQBE`800005G]UN^5jhG[QNf@03G[P01ekIG[QN^5jh001Vn000009[
6@06IaU[6F/IJaUW6@00:Woo00<007ooOol01Woo00<007ooOol0Agoo0021Ool00`00Oomoo`0ROol0
4@00H_UW6V;iIaYRnFLJH_UW6V;iIaYRnFLJH_UW6P00G[T00P0025JI02P0059HDUMFF59GDUQBEeIH
DUMBF59G001>5U8gCQIB=dhFDSM>5U8gCQIB=`00CQM>5ThGCQI>5dhFCQM>5ThGCQH004WfCQM9mThG
BOI>5`<0000cDSL0058gCSIB=dhfDSM>=U8gCSIB=dhfDSL005IHDUMFF59GEUQBEeIHDUMFF59GEUQB
EeIH001RfEjhH]UN^6;IG[QRfEjhH]UN^6;IG[P006KhIaUVn000IaQ[6FLHJcUW600002aoo`03001o
ogoo00Eoo`03001oogoo04Moo`00PWoo0P008goo010006;iHaYRnFLJH_US6V;iIaYRnF<JH_UW6V;i
HaX000YFV@0H001BEe9HDUMBF59GDUQBEe9HDUMBF59G001>=e8gCSIB=dhgDSM>=U8gCSMB=`000ThF
00E>5dhFCQI>5ThG00=>5P03001:5P0000<00006CSM>5U8gCQI>=`002e8g00<0059HDUL00U9G00EB
F59GDUMBEe9H009BE`03001JV000009N^005G]UN^5jhG[QNf@03G[P01`00I_QVnFKhI_UVn000009[
6@03IaT007oo02aoo`03001oogoo00Eoo`03001oogoo04Moo`00Q7oo00<007ooOol08Goo00`006;i
IaYRnFLJH_UW6V;iIaYRnFLJH_T200000e/L001FV@09EYT08000DUMBF59GEUQBEe9HDUMFF59GDUP0
058gCQIB=dhFDSM>5U8gCQIB=dhF001>5ThGCQI>5dhFCQM>5ThGCQH300007dhFDSM>5U8gCQIB=dhF
DSM>5P00CSIB=dhfDSM>=U8gCSIB=dhfDSM>=P00DUMFF59GEUQBEeIHDUMFF59G0080000HGYQJU`00
G[QRfEjhH]UN^6;IG[QRfEjh001Vn6LII_Q[6FKhIaT006/iIaQ[6@00;Woo00<007ooOol017oo00<0
07ooOol0Agoo0025Ool00`00Oomoo`0QOol02@00H_US6V;iIaYRnF<JH_UW6P02000015[kFaaJn`00
2UJI01P0059HDUMBF59GDUQBEe9HDUMBF59G001>=U8gCSMB=dhfDSM>=e8gCSIB=`00CQL3CQH00dhG
CQH0000200003DhF001>5U8gCQI>=dhFDSM>5ThgCQIB=`0000aB=`03001BEe9H00=BE`03DUQBE`00
00EJV005001N^5jhG[QNf@03G[P03000I_QVnFKhI_UVn6KiI_QVn@00JaT0031oo`03001oogoo00=o
o`03001oogoo04Moo`00QWoo00<007ooOol08Goo00H006;iIaYRnFLJH_T200001e/LF_]K75[kFaaJ
n`0000YFV@0H001FF59GDUQBEeIHDUMBF59GEUQBE`00CQIB=dhFDSM>5U8gCQIB=dhFDSL004hG1000
03e>5ThgCQI>=dhF001>5U8gCQIB=dhFDSM>5U8gCQIB=`00DSM>=U8gCSIB=dhfDSM>=U8gCSIB=`00
EUQBEeIHDUMFF59G001JMejHFYMNV5YgGYP006;IG[QRfEjhH]UN^6;I001W6FKhJaUVn6LII_Q[6FKh
IaT0000bOol00`00Oomoo`03Ool00`00Oomoo`16Ool008Moo`80029oo`03001RnF<J008000=Jn`06
FaaJne[kF_]K70002UJI01@0059GDUQBEe9HDUMBF59GDUQBEe9H001B=dhfDSM>=e8gCSIB=dhg1000
00I>=dhFCQM>5dhgCQH2CQL03Dhg001>=dhFDSM>5ThgCQIB=dhFCSM>5P0000aB=`06001BEe9GDUQB
E`0025ZH00<005kIG[P00Ujh00aNf@00I_UVn6KiI_QVnFKhI_UVn6Ki000cOol00`00Oomoo`03Ool0
0`00Oomoo`16Ool008Uoo`03001oogoo021oo`80000<FaaJne/LF_]K75[kFaaJne/LF_]K70002UJI
00h0059GEUQBEe9HDUMFF59GDUQBEeIH001B=dhF1@0002Q:5dhh001>=dhFCSM>5ThgCQI>=dhFCSM>
5P00CQIB=dhFDSM>5U8gCQIB=dhFDSL0058gCSIB=dhfDSM>=U8gCSIB=dhfDSM>=P00DUMFF080000I
FWMNV5ZGGYQJMejHFYMNV5Yg001N^6;IG[QRf@00IaUVn6/II_QW6FKhJaUVn6LI0000=Goo00<007oo
Ool00Woo00<007ooOol0AWoo002:Ool00`00Oomoo`0POol01@00F_]Jne[kFa`00e[k00EK75[kF_]J
n`0000YFV@09001BF59GDUQBEe9HDUMBF59G00D00005CQM>=dhgCSM>5`03CSL01@00CQM>5dhgCQH0
0ThG011>=dhFCQM>5`00CQI>=dhFDSM>5ThgCQIB=dhFCSL000aB=`8000aJV00>001N^5kI001VnFKh
I_UVn6KiI_QVnFKhI_T003Moo`05001oogooOol00018Ool008]oo`03001oogoo021oo`0=001Jne/L
F_]K75[kFaaJne/LF_]K75[k00002UJI00<0059HDUL01@0004]:>4iI001>>4XGCSQ:5dhhBQM>>4XG
CSQ:5`00CQI>=dhFCSM>5ThgCQI>=dhFCSL0058gCQIB=dhFDSM>5U8gCQIB=dhF001>=U8gCSIB=dhf
DSM>=U8gCSIB=dhfDSL005jHFWMNV5ZGGYQJMejHFYMNV5YgGYQJUejH001Rf@00IaUVn6/II_QW6FKh
JaUVn6LI0000>Goo00@007ooOol004Qoo`00S7oo0P008Goo0P000U[k00EK75[kF_]Jne/L009Jn`03
001FVEJI00AFV@L00009BSQ>>4XhCUU:>4hhBSQ>F@0000=>=`09CQM>=dhgCSM>5dhg001>=dhF009>
5`0BCSM>5ThGCQM>=dhF001>5U8gCQI>=dhFDSM>5ThgCQIB=`002U8g0P0000=FN000FYP035ZH00/0
06KiI_QVnFKhI_UVn6KiI_QVn@0003Yoo`04001oogoo0018Ool008ioo`03001oogoo021oo`06001K
75[kFaaJne/L2P0003Q:NTZKBWY:N`00CUU:>4iIBSQ>FDXhCUU:>4iIBSP004XGCSQ:5dhhBQM>>4XG
CSQ:5dhh001>=dhFCSM>5ThgCQI>=dhFCSM>5P00CQIB=dhFDSM>5U8gCQIB=dhFDSL0058gCSIB=dhf
DSM>=U8g0P0001aFEeYhEUL005ZGGYQJMejHFYMNV5YgGYQJUejHFWMNV000I_T006/II_QW6FKhJaUV
n6LII_P003]oo`03001oo`0004Qoo`00Sgoo00<007ooOol087oo1@000TKM00A6gTKMA]d000U:NP0=
001>>4XhCUU:>4hhBSQ>FDXhCSP004hgCQL00dhg00U>5dhgCSM>=dhG001>5dhgCQH00ThG015>=dhF
CQM>5dhg001>=dhFDSM>5ThgCQIB=dhFCSM>5P0000EB=`800007EWQFMeIhEWMFN5Ig00002UZH00`0
06;iH_UVn@00I_UVn6KiI_QVnFKh000mOol00`00Ool00017Ool0091oo`03001oogoo021oo`120016
oTKMA]i2gDKnA]e6gT;M001:NTYkBWY:VdYjBW]:NTZKBWX004XhCUU:>4iIBSQ>FDXhCUU:>4iI001>
>4XGCSQ:5dhhBQM>>4XGCSP004hgCQI>=dhFCSM>5ThgCQI>=dhF001>5U8gCQIB=dhFDSM>5U8gCQIB
=`00DSM>=U8g0P0001iFEeYhEUMJN5IGFWQFEeYh001NV5ZGGYQJMejHFYMNV5YgGYP006KiH]QVnF;H
I_T006/II_QW6FKh000oOol20017Ool0095oo`80025oo`040016gDKMA]h3A]d00dKNA]d00009BWX0
2`00BSQ>>4XhCUU:>4hhBSQ>FDXh00000Thg00E>5dhgCSM>=dhG00=>=`05001>5dhGCSM>5P02CQL0
3dhgCQI>5`00DSM>5ThgCQIB=dhFCSM>5U8gCQI>=`03000035IhEWMFN5IgEWQFMeIhEWMFN5IgEWP0
00MJV005001RnF;iI_URf002H_T01@00I_QVnFKh0000@7oo0P00Agoo002COol00`00Oomoo`0OOol2
0000>TKMA]i2gDKnA]e6gT;M001:NTYkBWY:VdYjBW]:NTZK001>FDXhCUU:>4iIBSQ>FDXhCUU:>000
BQM>>4XGCSQ:5dhhBQM>>4XG001>5ThgCQI>=dhFCSM>5ThgCQI>=`00DSM>5U8gCQIB=dhFDSM>5U8g
0P0001=FEeYhEUMJN5IGFWQFEeYhEUMJN5IGFWQFE`00FWMNV5ZGGYQJM`0200002fKiH]QVnF;HI_UR
f6KiH]P006Kh0000@Goo0P00Agoo002DOol00`00Oomoo`0POol00`00A]e6gP03A]d00dKN001:NP08
BWX02`00CUU:>4hhBSQ>FDXhCSQ:>4iI00000dhg00U>5dhgCSM>=dhGCSL004hgCQH00ThG00i>=dhF
CQM>5dhgCQH004hFDSM>5ThgCQIB=dhF0P00015BF59G001FMeIhEWMFN5IgEWQFMeIhEWMFN5IgEWQF
M`0000=JV006001Rf6;iH_UVnF;H0V;i00EVnF;HH_URn@0003ioo`@004Uoo`00UGoo00<007ooOol0
87oo0P000396gT;MA_i6gDKN001:VdYjBW]:NTZKBWY:NdYj001:>4iIBSQ>FDXhCUU:>4iIBSP004XG
CSQ:5dhhBQM>>4XGCSQ:5`00CQI>=dhFCSM>5ThgCQI>=dhFCSL0058gCQIB=dhF0`00029BEeIHDUMF
F000FWQFEeYhEUMJN5IGFWQFEeYhEUMJN5IGFWP005jHFWL006;HI_URf6KiH]QVnF;HI_URf6KiH]P0
03]oo`@004eoo`00UWoo0P008Goo10000TKM00=6gP00BWX01dYj00`004XhCUU:>4hhBSQ>FDXhCSQ:
>000CQL3CSL02DhGCSM>=dhgCQL004hGCSM>5P02CQL01dhgCQI>5dhGCSL004hg0080000FDUMBF59G
DUQBEe9HDUMBF000EWQFMeIhEWMFN5IgEWQFMeIhEWMFN5IgEWP200001F;HH_URnFKiH]P00V;i00EV
nF;HH_URn@0003Qoo`@0055oo`00V7oo00<007ooOol07goo00<001hm7Ud0100002I:NTZKBWY:NdYj
BY]:NTYk001>FDXhCUU:>4iIBSQ>FDXhCUT004hhBQM>>4XGCSQ:5dhhBQM>>000CSM>5ThgCQI>=dhF
CSM>5Thg0`0002EFF59GEUQBEeIHDUMFF59GEUQBE`00EUMJN5IGFWQFEeYhEUMJN5IGFWQFEeYhEUL0
06;HI_URf6KiH]QVnF;HI_URf6KiH]P0000eOol4001EOol009Uoo`03001oogoo01moo`05000NGAiM
7SdNG@060004BWX02P00CSQ:>4iIBSQ>>4XhCUU:>0000Thg00E>5dhgCSM>=dhG009>=`07001>5ThG
CQM>=dhFCQL00`00021>F000DUQBEe9HDUMBF59GDUQBEe9HDUMBF59G001FMeIhEWMFN5IgEWQFMeIh
EWMFN5Ig001Nf@00H_UVnF;H0V;i00EVnF;HH_URn@00039oo`@005Uoo`00VWoo00<007ooOol07goo
00X001hm7UdN?AiN7Sd0038k=U`b?0T0000ABSQ>FDXhCUU:>000BQM>>4XGCSQ:5dhhBQM>>4XG001>
5P0400006e9HCSQ>F4hgDUP005IHDUMFF59GEUQBEeIHDUMFF59GEUP005YhEUMJN5IGFWQFEeYhEUMJ
N002000035kIH]T006KiH]QVnF;HI_URf6KiH]P002moo`@005eoo`00Vgoo0P0087oo00@001iM7UdN
?@8NG@03000f?3IL008fG004=S`fG3IL0003@SXA00007dhhCUQ>>4iHCSQ>F4hhCUQ>>000DUMBF59G
DUQBEe9HDUMBF59GDUQBEe9H001FN5IgEWQFMeIhEWMFN00000ENf@05001RnF;iI_URf002H_T00`00
Oomoo`0ZOol4001QOol009eoo`03001oogoo01ioo`80001;7UdN?AiN7Sd0038k=U`b?3IL<S/fG000
@UXn>T9J@SY2FShj@UY2>T9J001:FDHhBUU6>4YIASQ:FDHhBUT004iHCSMBF4hhCUQ>=e9HCSQ>F4hg
001BEeIHDUMFF59GEUQBEeIHDUMFF59G001FEeYhEUMJN5IGFWP006;IG]URfEjiH]UNfF;I001VnF;H
I_URf00002Yoo`<006Eoo`00WWoo00<007ooOol07Woo0`0000DN?AiM000fG3Hl00<fG003=S`fG000
00Q2>P03001:>4Xi009:>@0SBSQ:>DXiBSU:>000CSQ>F4hhCUQ>>4iHCSQ>F4hhCUP0059HDUMBF59G
DUQBEe9HDUMBF59GDUQBE`00EWMFN5IgEWP00009G]T01000H_URn@009goo1000J7oo002OOol00`00
Oomoo`0NOol40000=QiN000fG38k=U`b?3IL<S/0048j@UXn>T9J@SY2FShj@UY2>P00ASQ:FDHhBUU6
>4YIASQ:FDHh001>>4iHCSMBF4hhCUQ>=e9HCSQ>F000EUQBEeIHDUMFF59GEUQBEeIHDUMFF000FWQF
E`80000=H]UNfF;IG[URfEkIH]UN^F;IG]T006;H000097oo1000K7oo002POol2000POol00`000GX0
000200000cIL=S`fG002=U`00cHl0012>P07@SX00`00BSU:>003BST074XhBSU:>DXi001>F4hhCUQ>
>4iHCSQ>F4hhCUQ>>000DUMBF59GDUQBEe9HDUMBF59GDUQBEe9H0P003EkI00<007ooOol07goo1000
L7oo002ROol00`00Oomoo`0NOol00`000GX1N@030000?S8k=U`b?3IL<S/0048j@UXn>T9J@SY2FShj
@UX004YIASQ:FDHhBUU6>4YIASQ:F@00DUQ>>4iHCSMBF4hhCUQ>=e9HCSP0059GEUQBEeIHDUMFF59G
EUQBEeIHDUL005jiH]UNfF;IG[URfEkIH]UN^F;IG]URfEji000NOol4001dOol00:=oo`03001oogoo
01eoo`<00081N@<000<fG0030012>T8j00I2>P04001:>DXiBSP3BST064XhBSU:>@00CSQ>F4hhCUQ>
>4iHCSQ>F4hhCUP0059HDUMBF59GDUQBEe9HDUMBF0800003F[X005kI00UNf@8001]oo`@007Qoo`00
Y7oo00<007ooOol077oo00P007ooOol0005i0IX0017l0P0002Lb?3IL0012FT8j@UXn>T9J@SY2FShj
0016>4YIASQ:FDHhBUU6>4YIASP004hgDUQ>>4iHCSMBF4hhCUQ>=e9H001FF59GEUQBEeIHDUL00P00
00iJfUJiF]X006;IG[URfEkIH]UN^F;IG]URf@006Goo1000O7oo002UOol2000LOol01000Oomoogoo
0P0000@1N@004O`=g0<000Q2>P05001:>DXiBSU:>003BST04TXhBST004iHCSQ>F4hhCUQ>>4iHCSQ>
F4hh001BEe9HDUMBF0800007E[YJ^UZjF[YF^UZj00001ekI00<007ooOol05Goo0`00P7oo002WOol0
0`00Oomoo`0IOol00`00Oomoo`03Ool2000010gK4O`=fa7l0`0001i2FT8j@UXn>T9J@SY2FP00BUU6
>4YIASQ:FDHhBUU6>4YI001>F4hgDUQ>>4iHCSMBF4hhCUQ>=`00DUL2000045[JE[UJfUJiF]YF^E[J
E[UJfP00H]UN^F;IG]URf@0057oo1000Pgoo002XOol00`00Oomoo`0HOol00`00Oomoo`04Ool20000
0a7L4O`=g0024M`40004@SX00`00BSQ:>@02BST03TXhBSU:>DXiBSP004hhCUQ>>4iHCSQ>F4hhCUP4
0002F[X01EJjF[YJ^UZjE[X00eZj00=F^UZj00000UkI0P004Goo1000Qgoo002YOol00`00Oomoo`0G
Ool00`00Oomoo`06Ool200001a7l3M/Ao0gK000Z?2iM00@0000>@SX004HhBUU6>4YIASQ:FDHhBUU6
>000CSQ>F0D0000CD[]>VU:k001JfUJiF]YF^E[JE[UJfUJiF]YF^E[JE[T005kI00003goo1000Rgoo
002ZOol00`00Oomoo`0FOol00`00Oomoo`08Ool200002@gL4M`Ag000:S`^?BXl;UdZ?00>00002Tjk
CY]>^djKC[]>VdjkCY/005Jj0eZj00EF^UZjF[YJ^UJj00=J^P03E[X007oo00]oo`@008moo`00Zgoo
0P005Woo00<007ooOol02Woo0P0002TAo000;UdZ?2iM:S`^GBXl;Ud004:L?W]2W3ik@Y`nNd:L?W]2
W000D[]>VU:kCYYB^djJD[]>VU:kCYX005JiF]YF^E[JE[UJfUJiF]YF^E[J008000Uoo`@009=oo`00
[Goo00<007ooOol04goo00<007ooOol037oo0`0000L^GBXl;SdZ?2iM:S`00009@W`03P00CY]>^djK
C[]>VdjkCY]>^djKC[]>V`00E[X3F[X00eJjF[YJ^P020007Ool4002GOol00:ioo`03001oogoo019o
o`03001oogoo00ioo`<0000P:S`^GBXl;UdZ?000?W]2W3ik@Y`nNd:L?W]2W3ik001>VU:kCYYB^djJ
D[]>VU:kCYYB^djJ001F^E[JE[UJfP8000Eoo`@009]oo`00[goo00<007ooOol04Goo00<007ooOol0
4Goo0P0000D^?BXl;UdZ?00000U2O00>001>VdjkCY]>^djKC[]>VdjkCY]>^`00F[YF^P8000Aoo`<0
09moo`00/7oo0P004Goo00<007ooOol04goo0`0001D^GBXl000nNd:L?W]2W3ik@Y`nNd:L?W/004jJ
D[]>VU:kCYYB^djJD[/010000Woo1000XWoo002bOol00`00Oomoo`0>Ool00`00Oomoo`0FOol30009
@W`01000C[]>Vdjk1@000Woo1000YWoo002cOol00`00Oomoo`0<Ool00`00Oomoo`0IOol>0003Ool4
002ZOol00;Aoo`03001oogoo00]oo`03001oogoo02Ioo`@00:ioo`00]Goo0P002goo00<007ooOol0
8Woo1000/Woo002gOol00`00Oomoo`08Ool00`00Oomoo`0NOol4002fOol00;Qoo`03001oogoo00Mo
o`03001oogoo01]oo`<00;Yoo`00^Goo00<007ooOol01Woo00<007ooOol05goo1000_Goo002jOol2
0006Ool00`00Oomoo`0COol40031Ool00;aoo`03001oogoo00=oo`03001oogoo00moo`@00<Eoo`00
_Goo00<007ooOol00Woo00<007ooOol02goo1000bGoo002nOol01@00Oomoogoo00002Goo1000cGoo
002oOol200000goo001oo`04Ool4003AOol00<5oo`800003Ool0000000800=Eoo`00`Woo0P00fGoo
0000\
\>"],
  ImageRangeCache->{{{0, 412.75}, {203.125, 0}} -> {-0.381734, 0.0432783, \
0.00488705, 0.00488705}}]
}, Open  ]],

Cell[TextData[{
  "We calculate the tangent surface of this function at the point ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\((x\_0\),
            "TraditionalForm"], ",", \(y\_0\)}], TraditionalForm]]],
  ") = (\[Pi]/2, 0) by using our function"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ht = TangentSurface[h, {x, y}, {\[Pi]\/2, 0}]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(1 + \((\(-\(\[Pi]\/2\)\) + x)\)\ Cos[x]\ Cos[y] - y\ Sin[x]\ Sin[y]\)], 
  "Output"]
}, Open  ]],

Cell["\<\
A graphical representation of this relation for the tangent surface \
follows with\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(pl2 = 
      Plot3D[ht, {x,  .5, 2}, {y, \(-1\), 1}, \n\t\tColorFunction \[Rule] Hue]
        \)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-016 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -18 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.22808 .16727 -5.79519 -9 ]
[.22808 .16727 .20481 0 ]
[.44535 .08183 -16.1346 -9 ]
[.44535 .08183 1.86537 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 24 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 18 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -18 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -24 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0.5)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(1.5)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-1)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-0.5)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(0.5)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(1)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(0.25)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0.5)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.75)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40054 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43642 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
1 .668 0 r
.38253 .59755 .40453 .62075 .44146 .61045 .41954 .59369 Metetra
1 .794 0 r
.41954 .59369 .44146 .61045 .4789 .60066 .45722 .59009 Metetra
1 .929 0 r
.45722 .59009 .4789 .60066 .5169 .59115 .49561 .5864 Metetra
.932 1 0 r
.49561 .5864 .5169 .59115 .55547 .58173 .53474 .5823 Metetra
.799 1 0 r
.53474 .5823 .55547 .58173 .59464 .57221 .57459 .57748 Metetra
.678 1 0 r
.57459 .57748 .59464 .57221 .6344 .5624 .61516 .57166 Metetra
.574 1 0 r
.61516 .57166 .6344 .5624 .67477 .55217 .65644 .5646 Metetra
.491 1 0 r
.65644 .5646 .67477 .55217 .71575 .54139 .69839 .5561 Metetra
.435 1 0 r
.69839 .5561 .71575 .54139 .75732 .52996 .74096 .54598 Metetra
.406 1 0 r
.74096 .54598 .75732 .52996 .79948 .51783 .78412 .53415 Metetra
.406 1 0 r
.78412 .53415 .79948 .51783 .84221 .50496 .82781 .52056 Metetra
.435 1 0 r
.82781 .52056 .84221 .50496 .88552 .49136 .87199 .50521 Metetra
.492 1 0 r
.87199 .50521 .88552 .49136 .9294 .47709 .91661 .48818 Metetra
.575 1 0 r
.91661 .48818 .9294 .47709 .97385 .46221 .96163 .46957 Metetra
1 .696 0 r
.35995 .57497 .38253 .59755 .41954 .59369 .39698 .57703 Metetra
.995 1 0 r
.39698 .57703 .41954 .59369 .45722 .59009 .43484 .57915 Metetra
.686 1 0 r
.43484 .57915 .45722 .59009 .49561 .5864 .47356 .58087 Metetra
.39 1 0 r
.47356 .58087 .49561 .5864 .53474 .5823 .51317 .58175 Metetra
.115 1 0 r
.51317 .58175 .53474 .5823 .57459 .57748 .55365 .58136 Metetra
0 1 .128 r
.55365 .58136 .57459 .57748 .61516 .57166 .59499 .57931 Metetra
0 1 .332 r
.59499 .57931 .61516 .57166 .65644 .5646 .63713 .57525 Metetra
0 1 .491 r
.63713 .57525 .65644 .5646 .69839 .5561 .68002 .5689 Metetra
0 1 .6 r
.68002 .5689 .69839 .5561 .74096 .54598 .72359 .56003 Metetra
0 1 .655 r
.72359 .56003 .74096 .54598 .78412 .53415 .76774 .54847 Metetra
0 1 .655 r
.76774 .54847 .78412 .53415 .82781 .52056 .8124 .53416 Metetra
0 1 .599 r
.8124 .53416 .82781 .52056 .87199 .50521 .85747 .5171 Metetra
0 1 .49 r
.85747 .5171 .87199 .50521 .91661 .48818 .90287 .49739 Metetra
0 1 .33 r
.90287 .49739 .91661 .48818 .96163 .46957 .94854 .47519 Metetra
1 .743 0 r
.33675 .55266 .35995 .57497 .39698 .57703 .37375 .5599 Metetra
.785 1 0 r
.37375 .5599 .39698 .57703 .43484 .57915 .41174 .56705 Metetra
.323 1 0 r
.41174 .56705 .43484 .57915 .47356 .58087 .45073 .57356 Metetra
0 1 .114 r
.45073 .57356 .47356 .58087 .51317 .58175 .49075 .57887 Metetra
0 1 .514 r
.49075 .57887 .51317 .58175 .55365 .58136 .5318 .58244 Metetra
0 1 .865 r
.5318 .58244 .55365 .58136 .59499 .57931 .57382 .58377 Metetra
0 .842 1 r
.57382 .58377 .59499 .57931 .63713 .57525 .61677 .58242 Metetra
0 .615 1 r
.61677 .58242 .63713 .57525 .68002 .5689 .66055 .57801 Metetra
0 .46 1 r
.66055 .57801 .68002 .5689 .72359 .56003 .70506 .57023 Metetra
0 .382 1 r
.70506 .57023 .72359 .56003 .76774 .54847 .75019 .55888 Metetra
0 .383 1 r
.75019 .55888 .76774 .54847 .8124 .53416 .7958 .54387 Metetra
0 .462 1 r
.7958 .54387 .8124 .53416 .85747 .5171 .84177 .52519 Metetra
0 .617 1 r
.84177 .52519 .85747 .5171 .90287 .49739 .88799 .50298 Metetra
0 .845 1 r
.88799 .50298 .90287 .49739 .94854 .47519 .93434 .47745 Metetra
1 .797 0 r
.31291 .53032 .33675 .55266 .37375 .5599 .34987 .54179 Metetra
.594 1 0 r
.34987 .54179 .37375 .5599 .41174 .56705 .38793 .55308 Metetra
.003 1 0 r
.38793 .55308 .41174 .56705 .45073 .57356 .42713 .56355 Metetra
0 1 .552 r
.42713 .56355 .45073 .57356 .49075 .57887 .4675 .57254 Metetra
0 .943 1 r
.4675 .57254 .49075 .57887 .5318 .58244 .50903 .57941 Metetra
0 .501 1 r
.50903 .57941 .5318 .58244 .57382 .58377 .55166 .58357 Metetra
0 .134 1 r
.55166 .58357 .57382 .58377 .61677 .58242 .59532 .58447 Metetra
.15 0 1 r
.59532 .58447 .61677 .58242 .66055 .57801 .63991 .58165 Metetra
.343 0 1 r
.63991 .58165 .66055 .57801 .70506 .57023 .68531 .57474 Metetra
.441 0 1 r
.68531 .57474 .70506 .57023 .75019 .55888 .73135 .56351 Metetra
.44 0 1 r
.73135 .56351 .75019 .55888 .7958 .54387 .77788 .54782 Metetra
.342 0 1 r
.77788 .54782 .7958 .54387 .84177 .52519 .82474 .52769 Metetra
.147 0 1 r
.82474 .52769 .84177 .52519 .88799 .50298 .87178 .50326 Metetra
0 .137 1 r
.87178 .50326 .88799 .50298 .93434 .47745 .91886 .4748 Metetra
1 .847 0 r
.28842 .50766 .31291 .53032 .34987 .54179 .32533 .52225 Metetra
.437 1 0 r
.32533 .52225 .34987 .54179 .38793 .55308 .36344 .53662 Metetra
0 1 .254 r
.36344 .53662 .38793 .55308 .42713 .56355 .40281 .55003 Metetra
0 1 .901 r
.40281 .55003 .42713 .56355 .4675 .57254 .44346 .56176 Metetra
0 .512 1 r
.44346 .56176 .4675 .57254 .50903 .57941 .48538 .57109 Metetra
0 0 1 r
.48538 .57109 .50903 .57941 .55166 .58357 .52853 .57734 Metetra
.426 0 1 r
.52853 .57734 .55166 .58357 .59532 .58447 .57281 .5799 Metetra
.754 0 1 r
.57281 .5799 .59532 .58447 .63991 .58165 .61812 .57823 Metetra
.978 0 1 r
.61812 .57823 .63991 .58165 .68531 .57474 .66429 .57191 Metetra
1 0 .91 r
.66429 .57191 .68531 .57474 .73135 .56351 .71117 .56067 Metetra
1 0 .911 r
.71117 .56067 .73135 .56351 .77788 .54782 .75856 .54434 Metetra
.976 0 1 r
.75856 .54434 .77788 .54782 .82474 .52769 .80627 .52296 Metetra
.751 0 1 r
.80627 .52296 .82474 .52769 .87178 .50326 .85412 .49668 Metetra
.422 0 1 r
.85412 .49668 .87178 .50326 .91886 .4748 .90195 .46582 Metetra
1 .885 0 r
.26326 .48447 .28842 .50766 .32533 .52225 .30014 .50094 Metetra
.325 1 0 r
.30014 .50094 .32533 .52225 .36344 .53662 .3383 .51715 Metetra
0 1 .434 r
.3383 .51715 .36344 .53662 .40281 .55003 .37781 .53234 Metetra
0 .856 1 r
.37781 .53234 .40281 .55003 .44346 .56176 .41868 .54572 Metetra
0 .213 1 r
.41868 .54572 .44346 .56176 .48538 .57109 .46093 .55651 Metetra
.348 0 1 r
.46093 .55651 .48538 .57109 .52853 .57734 .5045 .56399 Metetra
.813 0 1 r
.5045 .56399 .52853 .57734 .57281 .5799 .5493 .56749 Metetra
1 0 .828 r
.5493 .56749 .57281 .5799 .61812 .57823 .5952 .56642 Metetra
1 0 .585 r
.5952 .56642 .61812 .57823 .66429 .57191 .64205 .56034 Metetra
1 0 .462 r
.64205 .56034 .66429 .57191 .71117 .56067 .68966 .54892 Metetra
1 0 .462 r
.68966 .54892 .71117 .56067 .75856 .54434 .73781 .53202 Metetra
1 0 .587 r
.73781 .53202 .75856 .54434 .80627 .52296 .78631 .50964 Metetra
1 0 .832 r
.78631 .50964 .80627 .52296 .85412 .49668 .83494 .48197 Metetra
.808 0 1 r
.83494 .48197 .85412 .49668 .90195 .46582 .88353 .44936 Metetra
1 .906 0 r
.2374 .46061 .26326 .48447 .30014 .50094 .27432 .4776 Metetra
.268 1 0 r
.27432 .4776 .30014 .50094 .3383 .51715 .31256 .49433 Metetra
0 1 .526 r
.31256 .49433 .3383 .51715 .37781 .53234 .3522 .51001 Metetra
0 .732 1 r
.3522 .51001 .37781 .53234 .41868 .54572 .39327 .52382 Metetra
0 .06 1 r
.39327 .52382 .41868 .54572 .46093 .55651 .43578 .53497 Metetra
.525 0 1 r
.43578 .53497 .46093 .55651 .5045 .56399 .47968 .54271 Metetra
1 0 .989 r
.47968 .54271 .5045 .56399 .5493 .56749 .52489 .54634 Metetra
1 0 .615 r
.52489 .54634 .5493 .56749 .5952 .56642 .57127 .54526 Metetra
1 0 .361 r
.57127 .54526 .5952 .56642 .64205 .56034 .61866 .53901 Metetra
1 0 .233 r
.61866 .53901 .64205 .56034 .68966 .54892 .66687 .52725 Metetra
1 0 .234 r
.66687 .52725 .68966 .54892 .73781 .53202 .71569 .50983 Metetra
1 0 .363 r
.71569 .50983 .73781 .53202 .78631 .50964 .76488 .48675 Metetra
1 0 .619 r
.76488 .48675 .78631 .50964 .83494 .48197 .81425 .45821 Metetra
1 0 .994 r
.81425 .45821 .83494 .48197 .88353 .44936 .86358 .42458 Metetra
1 .906 0 r
.21083 .43602 .2374 .46061 .27432 .4776 .24788 .45213 Metetra
.268 1 0 r
.24788 .45213 .27432 .4776 .31256 .49433 .28626 .46799 Metetra
0 1 .526 r
.28626 .46799 .31256 .49433 .3522 .51001 .32606 .4828 Metetra
0 .732 1 r
.32606 .4828 .3522 .51001 .39327 .52382 .36731 .49577 Metetra
0 .06 1 r
.36731 .49577 .39327 .52382 .43578 .53497 .41004 .50612 Metetra
.525 0 1 r
.41004 .50612 .43578 .53497 .47968 .54271 .4542 .51309 Metetra
1 0 .989 r
.4542 .51309 .47968 .54271 .52489 .54634 .49971 .516 Metetra
1 0 .615 r
.49971 .516 .52489 .54634 .57127 .54526 .54645 .51426 Metetra
1 0 .361 r
.54645 .51426 .57127 .54526 .61866 .53901 .59426 .50741 Metetra
1 0 .233 r
.59426 .50741 .61866 .53901 .66687 .52725 .64294 .49512 Metetra
1 0 .234 r
.64294 .49512 .66687 .52725 .71569 .50983 .69229 .47724 Metetra
1 0 .363 r
.69229 .47724 .71569 .50983 .76488 .48675 .74208 .45378 Metetra
1 0 .619 r
.74208 .45378 .76488 .48675 .81425 .45821 .7921 .42492 Metetra
1 0 .994 r
.7921 .42492 .81425 .45821 .86358 .42458 .84214 .39104 Metetra
1 .885 0 r
.18351 .41069 .21083 .43602 .24788 .45213 .22082 .42452 Metetra
.325 1 0 r
.22082 .42452 .24788 .45213 .28626 .46799 .25944 .43812 Metetra
0 1 .434 r
.25944 .43812 .28626 .46799 .32606 .4828 .29945 .45073 Metetra
0 .856 1 r
.29945 .45073 .32606 .4828 .36731 .49577 .34091 .46159 Metetra
0 .213 1 r
.34091 .46159 .36731 .49577 .41004 .50612 .38384 .46996 Metetra
.348 0 1 r
.38384 .46996 .41004 .50612 .4542 .51309 .4282 .47513 Metetra
.813 0 1 r
.4282 .47513 .4542 .51309 .49971 .516 .47393 .47647 Metetra
1 0 .828 r
.47393 .47647 .49971 .516 .54645 .51426 .52092 .47342 Metetra
1 0 .585 r
.52092 .47342 .54645 .51426 .59426 .50741 .56901 .46554 Metetra
1 0 .462 r
.56901 .46554 .59426 .50741 .64294 .49512 .61803 .45254 Metetra
1 0 .462 r
.61803 .45254 .64294 .49512 .69229 .47724 .66778 .43427 Metetra
1 0 .587 r
.66778 .43427 .69229 .47724 .74208 .45378 .71805 .41073 Metetra
1 0 .832 r
.71805 .41073 .74208 .45378 .7921 .42492 .76863 .38212 Metetra
.808 0 1 r
.76863 .38212 .7921 .42492 .84214 .39104 .81932 .34876 Metetra
1 .847 0 r
.15539 .38473 .18351 .41069 .22082 .42452 .19313 .39493 Metetra
.437 1 0 r
.19313 .39493 .22082 .42452 .25944 .43812 .23211 .40492 Metetra
0 1 .254 r
.23211 .40492 .25944 .43812 .29945 .45073 .27244 .41403 Metetra
0 1 .901 r
.27244 .41403 .29945 .45073 .34091 .46159 .31416 .42157 Metetra
0 .512 1 r
.31416 .42157 .34091 .46159 .38384 .46996 .35729 .42686 Metetra
0 0 1 r
.35729 .42686 .38384 .46996 .4282 .47513 .40183 .42928 Metetra
.426 0 1 r
.40183 .42928 .4282 .47513 .47393 .47647 .44771 .42825 Metetra
.754 0 1 r
.44771 .42825 .47393 .47647 .52092 .47342 .49485 .42328 Metetra
.978 0 1 r
.49485 .42328 .52092 .47342 .56901 .46554 .54311 .41398 Metetra
1 0 .91 r
.54311 .41398 .56901 .46554 .61803 .45254 .59233 .40009 Metetra
1 0 .911 r
.59233 .40009 .61803 .45254 .66778 .43427 .64235 .38149 Metetra
.976 0 1 r
.64235 .38149 .66778 .43427 .71805 .41073 .69297 .35818 Metetra
.751 0 1 r
.69297 .35818 .71805 .41073 .76863 .38212 .744 .33032 Metetra
.422 0 1 r
.744 .33032 .76863 .38212 .81932 .34876 .79528 .29821 Metetra
1 .797 0 r
.12642 .3583 .15539 .38473 .19313 .39493 .16478 .3636 Metetra
.594 1 0 r
.16478 .3636 .19313 .39493 .23211 .40492 .2043 .36877 Metetra
.003 1 0 r
.2043 .36877 .23211 .40492 .27244 .41403 .24505 .37321 Metetra
0 1 .552 r
.24505 .37321 .27244 .41403 .31416 .42157 .28711 .37633 Metetra
0 .943 1 r
.28711 .37633 .31416 .42157 .35729 .42686 .33049 .37756 Metetra
0 .501 1 r
.33049 .37756 .35729 .42686 .40183 .42928 .3752 .37637 Metetra
0 .134 1 r
.3752 .37637 .40183 .42928 .44771 .42825 .4212 .37227 Metetra
.15 0 1 r
.4212 .37227 .44771 .42825 .49485 .42328 .46841 .36485 Metetra
.343 0 1 r
.46841 .36485 .49485 .42328 .54311 .41398 .51673 .35379 Metetra
.441 0 1 r
.51673 .35379 .54311 .41398 .59233 .40009 .56604 .33887 Metetra
.44 0 1 r
.56604 .33887 .59233 .40009 .64235 .38149 .6162 .31998 Metetra
.342 0 1 r
.6162 .31998 .64235 .38149 .69297 .35818 .66705 .29714 Metetra
.147 0 1 r
.66705 .29714 .69297 .35818 .744 .33032 .71843 .27049 Metetra
0 .137 1 r
.71843 .27049 .744 .33032 .79528 .29821 .77021 .24025 Metetra
1 .743 0 r
.0965 .33164 .12642 .3583 .16478 .3636 .13573 .33092 Metetra
.785 1 0 r
.13573 .33092 .16478 .3636 .2043 .36877 .17596 .33018 Metetra
.323 1 0 r
.17596 .33018 .2043 .36877 .24505 .37321 .2173 .32894 Metetra
0 1 .114 r
.2173 .32894 .24505 .37321 .28711 .37633 .2598 .32673 Metetra
0 1 .514 r
.2598 .32673 .28711 .37633 .33049 .37756 .3035 .32308 Metetra
0 1 .865 r
.3035 .32308 .33049 .37756 .3752 .37637 .34841 .31758 Metetra
0 .842 1 r
.34841 .31758 .3752 .37637 .4212 .37227 .39451 .30984 Metetra
0 .615 1 r
.39451 .30984 .4212 .37227 .46841 .36485 .44175 .29954 Metetra
0 .46 1 r
.44175 .29954 .46841 .36485 .51673 .35379 .49006 .28645 Metetra
0 .382 1 r
.49006 .28645 .51673 .35379 .56604 .33887 .53936 .27038 Metetra
0 .383 1 r
.53936 .27038 .56604 .33887 .6162 .31998 .58955 .25125 Metetra
0 .462 1 r
.58955 .25125 .6162 .31998 .66705 .29714 .64051 .22909 Metetra
0 .617 1 r
.64051 .22909 .66705 .29714 .71843 .27049 .69213 .20399 Metetra
0 .845 1 r
.69213 .20399 .71843 .27049 .77021 .24025 .74431 .17614 Metetra
1 .696 0 r
.06554 .30507 .0965 .33164 .13573 .33092 .10587 .29736 Metetra
.995 1 0 r
.10587 .29736 .13573 .33092 .17596 .33018 .14705 .28982 Metetra
.686 1 0 r
.14705 .28982 .17596 .33018 .2173 .32894 .18914 .2821 Metetra
.39 1 0 r
.18914 .2821 .2173 .32894 .2598 .32673 .23222 .27383 Metetra
.115 1 0 r
.23222 .27383 .2598 .32673 .3035 .32308 .27633 .26468 Metetra
0 1 .128 r
.27633 .26468 .3035 .32308 .34841 .31758 .32149 .25434 Metetra
0 1 .332 r
.32149 .25434 .34841 .31758 .39451 .30984 .3677 .24255 Metetra
0 1 .491 r
.3677 .24255 .39451 .30984 .44175 .29954 .41496 .22908 Metetra
0 1 .6 r
.41496 .22908 .44175 .29954 .49006 .28645 .46322 .21375 Metetra
0 1 .655 r
.46322 .21375 .49006 .28645 .53936 .27038 .51244 .19645 Metetra
0 1 .655 r
.51244 .19645 .53936 .27038 .58955 .25125 .56257 .17712 Metetra
0 1 .599 r
.56257 .17712 .58955 .25125 .64051 .22909 .61354 .15577 Metetra
0 1 .49 r
.61354 .15577 .64051 .22909 .69213 .20399 .66529 .13247 Metetra
0 1 .33 r
.66529 .13247 .69213 .20399 .74431 .17614 .71778 .10736 Metetra
1 .668 0 r
.03339 .27895 .06554 .30507 .10587 .29736 .0751 .26349 Metetra
1 .794 0 r
.0751 .26349 .10587 .29736 .14705 .28982 .11744 .24847 Metetra
1 .929 0 r
.11744 .24847 .14705 .28982 .18914 .2821 .16049 .23366 Metetra
.932 1 0 r
.16049 .23366 .18914 .2821 .23222 .27383 .2043 .21883 Metetra
.799 1 0 r
.2043 .21883 .23222 .27383 .27633 .26468 .24894 .20376 Metetra
.678 1 0 r
.24894 .20376 .27633 .26468 .32149 .25434 .29443 .18826 Metetra
.574 1 0 r
.29443 .18826 .32149 .25434 .3677 .24255 .3408 .17216 Metetra
.491 1 0 r
.3408 .17216 .3677 .24255 .41496 .22908 .38808 .15533 Metetra
.435 1 0 r
.38808 .15533 .41496 .22908 .46322 .21375 .43627 .13766 Metetra
.406 1 0 r
.43627 .13766 .46322 .21375 .51244 .19645 .48537 .11908 Metetra
.406 1 0 r
.48537 .11908 .51244 .19645 .56257 .17712 .53538 .09956 Metetra
.435 1 0 r
.53538 .09956 .56257 .17712 .61354 .15577 .58629 .0791 Metetra
.492 1 0 r
.58629 .0791 .61354 .15577 .66529 .13247 .6381 .05774 Metetra
.575 1 0 r
.6381 .05774 .66529 .13247 .71778 .10736 .6908 .03557 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0.5)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(1.5)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{333, 158.625},
  ImageMargins->{{0, 0}, {0, 1.3125}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006P0000aQ000`40O003h00Oogoo1@00W7oo003o
Ool01@00Oomoogoo0000W7oo003oOol1Ool00`00Oomoo`2MOol00?moo`9oo`03001oogoo09aoo`00
ogoo0goo00<007ooOol0Vgoo003oOol4Ool00`00Oomoo`2JOol00?moo`05001oogooOol0002LOol0
0?moo`5oo`<0011oo`D008Qoo`00ogoo5Woo00<007ooOol0R7oo003oOolFOol00`00Oomoo`28Ool0
0?moo`]oo`H000Eoo`03001oogoo08Qoo`00ogoo5Woo00<007ooOol0R7oo003oOolFOol00`00Oomo
o`28Ool00?mooaAoo`<008Yoo`00ogoo1goo0P003Goo00<007ooOol0R7oo003oOol5Ool5002GOol0
0?moo`9oo`<000=oo`8009Moo`00ogoo0P001Woo00<007oo0000UWoo003lOol30008Ool01000Oomo
o`00UGoo003iOol4000:Ool01000Oomoo`00UGoo003gOol2000>Ool00`00Oomoo`02002DOol00;ao
o`D000Aoo`8000Eoo`@002Aoo`<0011oo`03001oogoo009oo`03001oogoo095oo`00_Woo00<007oo
Ool017oo0P0017oo00<007ooOol00Woo00<007ooOol07goo0P004Woo0P0017oo00<007ooOol0TGoo
002nOol00`00Oomoo`0?Ool00`00Oomoo`0LOol3000BOol200000d_P001oo`04Ool00`00Oomoo`2@
Ool00;ioo`03001oogoo00moo`03001oogoo01Yoo`8001=oo`800005An1;h4OPAn000004Ool00`00
Oomoo`2@Ool00;ioo`03001oogoo00]oo`@001Yoo`<0019oo`<00007Bn17h4_PAn1;h4OP00001Goo
00<007ooOol0Sgoo002nOol00`00Oomoo`0;Ool00`00Oomoo`0IOol2000COol200001D_PAn17h4OP
Bn000dOP00=;h00000000goo0`00T7oo002lOol3000=Ool00`00Oomoo`0FOol3000BOol300002dOP
Bn17h4_PAn1;h4OPBn17h4_PAn000P001Goo00<007ooOol0SWoo002nOol00`00Oomoo`0;Ool5000B
Ool2000COol2000013_P0017h4_P0dOP00E;h4OPAn17h4_P0097h08000Ioo`03001oogoo08eoo`00
h7oo0`004goo0P0001<oh3_P?n0kh000An1;h4OPBn17h4_PAn1;h4OPBn17h000An000006Ool00`00
Oomoo`2<Ool00=eoo`<001=oo`<0008oh005>n0oh3oP?n000002An001D_PAn17h4OPBn000dOP00A;
h000An0000Ioo`03001oogoo08aoo`00fgoo0P0057oo0P0001Pkh3oP>n0oh3_P?n0kh3oP>n0004OP
Bn17h4_PAn1;h4OPBn17h4_PAn0004OP0007Ool00`00Oomoo`2;Ool00=Qoo`<00003Ool007oo011o
o`<00003?n0kh3oP008oh005>n0oh3oP?n0kh002?n001@00An17h4OPBn000dOP00M;h4OPAn0004_P
An000005Ool00`00Ool0002<Ool00=Ioo`8001Aoo`80000N=n0003oP>n0oh3_P?n0kh3oP>n0oh3_P
?n0kh3oP001;h4OPBn17h4_PAn1;h4OPBn17h000An1;h0001goo00<007ooOol0RWoo003COol3000D
Ool20004=n001@00?n0oh3oP>n000coP00Pkh3oP?n0oh3_P0017h4_P0dOP00I;h4OPAn17h4_P0002
An000d_P001oo`06Ool00`00Oomoo`29Ool00=5oo`8001Eoo`8000<gh00P<n0gh3OP000kh3oP>n0o
h3_P?n0kh3oP>n0oh3_P?n0kh000An1;h4OPBn17h4_PAn1;h4OP0017h4_PAn0000Qoo`03001oogoo
00ioo`@000Eoo`8000Eoo`@006Ioo`00cWoo0`0000=oo`00Ool04Woo0P002COP00<003_P?n000SoP
00Dkh3oP?n0oh3_P00<oh0040017h4OPBn03An001D_PAn17h000Bn000TOP00<007ooOol01Woo00<0
07ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol0
Hgoo003<Ool2000EOol300000cOP<n0gh002=n008c?P=n0gh3OP<n0gh000?n0kh3oP>n0oh3_P?n0k
h3oP>n0oh3_P?n0004_PAn1;h4OPBn17h4_PAn0004OPBn17h4_P00001goo0P003Woo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol0Hgoo0039Ool3000DOol300000c?P000gh00;=n001000?n0o
h3_P0coP00Dkh3oP?n0oh3_P008oh0050017h4OPAn1;h003An001d_P0017h4OPBn17h00000Uoo`03
001oogoo00=oo`H0009oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo06=oo`00aWoo0`00
5Goo0P0000<ch2oP<n000S?P00D003OP=n0gh3?P00<gh00N<n0gh3OP=n0ch000>n0oh3_P?n0kh3oP
>n0oh3_P?n0kh3oP001;h4OPBn17h4_PAn1;h4OP0017h4_P0`002Goo00<007ooOol02goo00<007oo
Ool00Woo00<007ooOol02Goo1000IWoo0034Ool2000EOol30007<n000`00=n0gh00:=n001@00?n0o
h3oP>n000coP00Pkh3oP?n0oh3_P?n0004_P0dOP00=;h4OPAn000`0000@3jP?Y0nX000Uoo`03001o
ogoo00Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo06Moo`00VGoo1@008goo0`0057oo
0`0000D_h3?P<n0ch2oP00<ch005;n0ch000=n0ch003=n001C?P=n0gh3OP<n000cOP01@003oP>n0o
h3_P?n0kh3oP>n0oh3_P?n0kh000An1;h4OPBn17h4_P0P0000H3j@?Z0nT3jP?Y000:Ool00`00Oomo
o`09Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`1WOol009]oo`03001oogoo025oo`80
01Aoo`<00003<n0003?P00/ch003000gh3OP00Xgh003000kh3oP008oh005>n0oh3oP?n0kh003?n00
1@00An17h4_PAn000P0000T3jP?Y0003j@?Z0nT3jP?Y00002Goo00<007ooOol02Woo100037oo1@00
IGoo002KOol00`00Oomoo`0NOol3000COol300001RoP<n0ch3?P;n00008ch005;n0ch3?P<n0_h003
<n001BoP000gh3OP<n000cOP00Dch3OP=n0gh3?P008gh00?000kh3oP>n0oh3_P?n0kh3oP>n0oh3_P
?n0004_P0080000;0nT3jP?Y0nX000?Z0nT3jP?Y0nX00008Ool00`00Ool00025Ool009]oo`03001o
ogoo01aoo`8001=oo`<000Pch003000ch3?P00Tch003000gh3OP00/gh003000oh3_P00<oh006>n0o
h3oP?n0kh3oP0`0000d3jP?Y0nX3j@?Z0nT000?Y0nX3j@?Z0nT0000:Ool00`00Oomoo`23Ool009]o
o`03001oogoo01Uoo`<0019oo`<00005;n0ch3?P<n0_h003<n001BoP<n0ch000;n000c?P00D_h3?P
<n0ch2oP00<ch005000gh3OP=n0ch003=n003c?P=n0gh3OP<n0003_P?n0kh3oP>n0oh3_P?n0kh002
00004@?_0003jP?Y0nX3j@?Z0nT3jP000nX3j@?Z0nT3jP?Y00002Woo00<007ooOol0PWoo002KOol0
0`00Oomoo`0GOol2000COol200000cOP000ch00<<n000`00<n0ch009<n000`00=n0gh00;=n001000
?n0oh3_P0coP0P000P?_0143kP?_0003jP?Y0nX3j@?Z0nT000?Y0nX3j@?Z0nT3jP0000]oo`03001o
ogoo085oo`00VGoo0`005Woo0`004Woo0`000cOP00Dch000<n0ch2oP00<ch009;n0ch3?P<n0_h3?P
000ch2oP00<ch005;n0ch3?P<n0_h002<n000`00<n0gh002=n001C?P=n0gh3OP<n000cOP00D003oP
>n0oh3_P0080000E0nl3kP?_0nh3k`?^0003j@?Z0nT3jP?Y0nX000?Z0nT3jP?Y0nX3j@0000]oo`03
001oogoo085oo`00Vgoo00<007ooOol04Goo0`004goo0P001cOP00<003?P<n002S?P00<003?P<n00
2S?P00<003OP=n002cOP00D003oP000000?^00<3k`0D0nh3k`?_0nl3kP000nT3jP?Y0nX3j@000nT3
jP?Y0nX3j@?Z0nT000Yoo`80089oo`00[Goo0P004goo0`000SOP00Dch3OP=n0gh3?P00<gh005000c
h3?P<n0_h003<n001RoP<n0ch3?P;n00008ch005;n0ch3?P<n0_h003<n001BoP000gh3OP<n000cOP
00Hch3OP=n0gh3?P=n0300006P?_0nh3k`?^0nl3kP?_0nh3k`?^0nl000?Z0nT3jP?Y0nX000?Z0nT3
jP?Y0nX3j@?Z000<Ool00`00Oomoo`1oOol00:Yoo`<0019oo`<00003?n0003OP00Xgh003000ch3?P
00Xch003000ch3?P00Xch003000gh3OP00Lgh08000040o8000?_0nh30nl01@?^0nl3k`?_0nh00P?_
010000?Y0nX3j@?Z0nT000?Y0nX3j@?Z0nT3jP?Y0nX000]oo`03001oogoo07moo`00Z7oo0`004Woo
0P0000Lkh3oP>n0oh3_P000ch003=n002C?P=n0gh3OP<n0gh000<n0_h003<n001BoP<n0ch3?P;n00
0c?P00D003?P<n0ch2oP00<ch005;n0ch3?P<n000003=n0013?P=n0gh3OP0P000`?b01d3l`000nl3
kP?_0nh3k`?^0nl3kP?_0nh3k`?^0003j@?Z0nT3jP000nX3j@?Z0nT3jP?Y0nX3j@0000aoo`03001o
ogoo07ioo`00YGoo0`004Woo0`0000<oh3_P?n000SoP00<kh3oP00002cOP00<003?P<n002S?P00<0
03?P<n002C?P00<003OP=n000SOP0`001P?b00@000?_0nl3kP<3k`0E0nh3k`?_0nl3kP?_0003jP?Y
0nX3j@000nT3jP?Y0nX3j@?Z0nT3jP0000eoo`03001oogoo07eoo`00Xgoo0P004Woo0`0000/oh3_P
?n0kh3oP>n0oh3_P?n0kh000008gh005<n0gh3OP=n0ch003=n001C?P000ch3?P;n000c?P00T_h3?P
<n0ch2oP<n0003?P;n000c?P00D_h3?P<n0ch2oP008ch004000ch00000020o801@?c0o83lP?b0o<0
0P?b01d000?_0nh3k`?^0nl3kP?_0nh3k`?^0nl3kP000nT3jP?Y0nX000?Z0nT3jP?Y0nX3j@?Z0nT3
jP0000]oo`8007moo`00X7oo0`004Goo0`0000=7h000?n000SoP00Dkh3oP?n0oh3_P00<oh003>n00
03OP00Xgh003000ch3?P00Xch003000ch3?P00Pch0<000`3lP050003k`?_0nl3kP030nl050?^0nl3
k`?_0nh000?Y0nX3j@000nT3jP?Y0nX3j@?Z0nT3jP?Y000=Ool00`00Oomoo`1lOol009ioo`800003
Ool007oo00moo`80000BBn17h4_PAn1;h000?n0kh3oP>n0oh3_P?n0kh3oP>n0oh0000cOP00Dch3OP
=n0gh3?P00<gh005000ch3?P<n0_h003<n001RoP<n0ch3?P;n00008ch005;n0ch3?P<n0_h0030000
0`?c0003lP020o801@?c0o83lP?b0o<00`?b01/3l`?b0003kP?_0nh3k`?^0nl3kP?_0nh3k`?^0nl0
00?Z0nT3jP000nX3j@?Z0nT3jP?Y0nX00`003Woo00<007ooOol0Ngoo002KOol3000AOol30007An00
0`00>n0oh002?n001C_P?n0oh3oP>n000SoP00<003OP=n002SOP00<003?P<n002C?P00<003?P<n00
0c?P0P001@?d00<000?b0o802P?b00<000?_0nh00`?_00D3kP?_0nl3k`?^00<3k`090003jP?Y0003
j@?Z0nT3jP?Y008000<3G`03001oogoo00]oo`03001oogoo07]oo`00VGoo0P004Goo0`0001U7h4_P
An1;h4OPBn17h4_PAn1;h4OP000kh3oP>n0oh3_P?n0kh3oP>n0oh3_P000ch003=n001C?P=n0gh3OP
<n000SOP00<002oP<n000S?P00D_h3?P<n0ch2oP00<ch003000ch000008000<3m0060o<3m0?d0o@0
00?c0`?b00D3l`?b0o83lP?c00<3lP0E0o<000?_0nh3k`?^0nl3kP?_0nh3k`?^0nl3kP000nT3jP00
0nX3j@?Z008000D3G`03001oogoo00aoo`03001oogoo07Yoo`00UWoo0`0047oo0`0000=Ch000An00
2dOP00<003oP>n000coP00Lkh3oP?n0oh3_P?n00000;=n000`00<n0ch009<n03000:0o@00`000o83
lP0;0o8010000nl3k`?^0`?_00/3kP?_0nl3k`?^0nl000?Z0nT000?Y008000P3G`03001oogoo00Yo
o`<007]oo`00Fgoo10001Goo0P001Goo100097oo0`003goo1000025Ch5OPDn1Gh5?P0017h4_PAn1;
h4OPBn17h4_PAn1;h4OP000kh3oP>n0oh3_P?n0kh3oP>n0oh3_P?n0003OP<n000cOP00Tch3OP=n0g
h3?P=n0003?P;n000c?P00<_h3?P00000P0000@3m0000o@3l`<3m0050o<3m0?d0o@3l`020o@00`00
0o83l`030o801@?c0o83lP?b0o<00`?b00l000?^0nl3kP?_0nh3k`?^0nl3kP?_0nh3k`000nX00P00
2P=O00<007ooOol037oo00<007ooOol0NGoo001JOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`0OOol2000?Ool300000eOPDn1Gh002En001E?PEn1Gh5OP0000
34OP00@003oP?n0kh0<oh006>n0oh3oP?n0kh0002cOP00<003?P<n000c?P0P001@?d00<000?d0o@0
2@?d00<000?b0o802`?b00D000?_0nl3k`?^00<3k`050nh3k`?_0nl3kP03000<0el00`00Oomoo`0<
Ool00`00Oomoo`1hOol005Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo01aoo`<000io
o`<0000VIn0005OPDn1Gh5?PEn1Ch5OPDn1Gh5?PEn0004_PAn1;h4OPBn17h4_PAn1;h4OPBn0003oP
>n0oh3_P?n0kh3oP>n0oh3_P?n0000<gh005<n0gh3OP=n0ch003=n000c?P000ch00300020o@01P?c
0o@3m0?d0o<00083m0050o<3m0?d0o@3l`030o@00`?c0003lP020o801@?c0o83lP?b0o<00`?b00d3
l`?b0003kP?_0nh3k`?^0nl3kP?_0nh3k`0300020el00`000el3G`090el00`00Oomoo`0=Ool00`00
Oomoo`06Ool4001]Ool005Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo01Yoo`800003
Ool007oo00Yoo`@00006In1Sh6OPHn1Wh0000eOP00ECh5OPEn1Gh5?P009Gh0030017h4OP00U7h003
000kh3oP008oh005>n0oh3oP?n0kh003?n000`00=n0gh008=n03000:0o@00`000o@3m00:0o@00`00
0o83lP0;0o800`000nh3k`020nl00`?^0nl3k`0200030Wl00`000el0000;0el00`00Oomoo`0=Ool0
0`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`1ZOol005Yoo`03001oogoo009oo`03001oogoo
00Uoo`@001Yoo`<000aoo`<0000_Hn1Wh6?PIn1Sh6OPHn1Wh6?P001Ch5OPDn1Gh5?PEn1Ch5OPDn1G
h5?P0017h4_PAn1;h4OPBn17h4_PAn1;h4OP000kh3oP>n0oh3_P?n0kh3oP>n0oh3_P000ch003=n00
0c?P=n0gh00300000`?b0003l`030o@01@?c0o@3m0?d0o<00`?d00D000?d0o@3m0?c00<3m0060o<3
m0?d0o@000?c0`?b00D3l`?b0o83lP?c00<3lP070o<000?_0nh3k`?^0nl00P0000P2G`9o0Ul2O`9O
0003G`0030=O00<007ooOol037oo0P001Woo00<007ooOol00Woo00<007ooOol0JWoo001JOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0IOol2000=Ool200003gOP001Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?P001Ch003En001e?PEn1Gh5OPDn1Gh00000]7h003000oh3_P00<oh007>n0oh3oP?n0k
h3oP00001COP0P001@?b00<000?d0o@02@?d00<000?d0o@02P?d00<000?b0o802P?b00@000?_0nl3
kP8000030Wl2G`9o0082O`030Ul2O`9o008000`3G`03001oogoo00eoo`03001oogoo00Aoo`03001o
ogoo009oo`03001oogoo06Yoo`00FWoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol05Woo
0`0037oo0`0003Egh7?PMn1ch000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn0005OPDn1Gh5?PEn1Ch5OPDn1G
h5?PEn0004_PAn1;h4OPBn17h4_PAn1;h4OPBn0003oP>n0oh3_P?n0kh3oP>n0oh3_P?n0003OP00<0
0083lP080o<3lP?b0o83l`000o@3l`<3m0090o<3m0?d0o@3l`?d0003m0?c00<3m0050o<3m0?d0o@3
l`020o@00`000o83l`030o801@?c0o83lP?b0o<00`?b0`0000X2G`9o0Ul2O`9O0Wl2G`9o0Ul2O`80
00d3G`03001oogoo00eoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo06Yoo`00Fgoo1000
37oo1@004Woo0P003Goo0P001gOP00l006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0005OPDn000eOP00IC
h5OPEn1Gh5?P000;An001000?n0oh3_P0coP00@kh3oP?n0oh0<000X3lP030003m0?d00X3m0030003
m0?d00T3m0030003lP?b00X3lP8000<2O`050Ul2O`9o0Wl2G`030Wl00`9O0000000=0el00`00Oomo
o`0>Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1ZOol007moo`<000aoo`<0000cLn1g
h7?PMn1ch7OPLn1gh7?PMn0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?P001Ch5OPDn1Gh5?PEn1Ch5OPDn1G
h5?P0017h4_PAn1;h4OPBn17h4_PAn1;h000?n0kh3oP>n0oh3_P00@000030nl000?c00<3lP050o<3
lP?b0o83l`030o8010000o@3m0?c0`?d00H3l`?d0o@3m0?c00020o@01@?c0o@3m0?d0o<00`?d00<3
l`?d00000P?b00D3l`?b0o83lP?c0083lP80000@0Kl0009O0Wl2G`9o0Ul2O`9O0Wl2G`9o0Ul2O`9O
000>0el00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1ZOol007aoo`<0
00aoo`<00003Oh1oX00000Ygh00<001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0000eOP00ECh5OPEn1Gh5?P
00=Gh0030017h4OP00U7h003000oh00000<00083k`050nh3k`?_0nl0000;0o800`000o@3m00:0o@0
0`000o@3m0090o@00`000o83lP050o8200040Ml00`000Ul2O`020Wl01@9O0Wl2O`9o0Ul00`9o00<0
00=O0el030=O00<007ooOol037oo0`0017oo1000KGoo001jOol200000goo001oo`08Ool40000<Wn0
Oj1oP7nPOh0007?PMn1ch7OPLn1gh7?PMn1ch7OPLn0006?PIn1Sh6OPHn1Wh6?PIn1Sh6OP001Gh5?P
En1Ch5OPDn1Gh5?PEn1Ch5OP001;h4OPBn17h4_PAn1;h4OPBn0300003@?_0nh3k`?^0nl3kP?_0nh3
k`?^0003lP?c00<3lP080o<3lP?b0o83l`?b0003l`<3m0050o<3m0?d0o@3l`030o@01@000o@3m0?d
0o<00`?d00H3l`?d0o@3m0000o<30o8300004`6o0Ml1_`7O0Kl1g`000Wl2G`9o0Ul2O`9O0Wl2G`9o
0Ul2O`9O008000/3G`<0015oo`03001oogoo079oo`00Mgoo0`002Woo0`0000=oX7n0Oj000WnP00Io
P7nPOj1oX7n0000:Mn003@00In1Sh6OPHn1Wh6?PIn1Sh6OPHn0005?P00=Gh005Dn1Gh5OPEn1Ch002
En000`00An17h004An03000010?Z0003k`?^0`?_00D3kP?_0nl3k`?^0083k`030003lP?b00T3lP03
0003m0?d00T3m0030003m0?d00X3m0040003lP00000:0Ml00`000Wl2G`030Wl01@9O0Wl2O`9o0Ul0
0`002@=O0P0000@0W`1o07l0011oo`03001oogoo079oo`00MGoo0P002goo0P00039o87l0001oP7nP
Oh1oX7n0Oj1oP7nPOh1oX7n0001ch7OPLn1gh7?PMn1ch7OPLn1gh000In1Sh6OPHn1Wh6?PIn1Sh6OP
Hn0005?PEn1Ch5OPDn1Gh5?PEn1Ch5OPDn0004OP10000183jP?Y0nX3j@?Z0003k`?^0nl3kP?_0nh3
k`?^0nl3kP?_00020o801@?c0o83lP?b0o<00`?b00@3l`000o@3l`<3m0050o<3m0?d0o@3l`020o@0
0`000o<3m0020o@01P?c0o@3m0?d0o<3m0<0000D0Ml1_`7O0Kl1g`6o0Ml1_`7O0Kl1g`6o0002G`9o
0Ul2O`9O0Wl2G`<000030Ul2O`0000P3G`070000O`2O07l0W`1o00004Goo00<007ooOol0LGoo001c
Ool2000;Ool20003O`000glP001oX002Oj001Gn0Oj1oX7nPOh000gnP00<007OPMn0027OP00h006?P
In1Sh6OPHn1Wh6?PIn1Sh6OP001Gh5?P0eOP00ACh5OPEn1Gh0@0000:0nT3jP?Y0nX3j@?Z0nT3jP?Y
00020nl01@?^0nl3k`?_0nh00`?_00<3kP000o802`?b00<000?d0o@02@?d00<000?d0o@01@?d0`00
00<1O`000Ml0307O00D0009o0Wl2O`9O00<000050Ul2O`9o0Wl2G`0200050el200000`1o09l0O`02
07l00`2O07l0000AOol00`00Oomoo`1`Ool007=oo`8000Uoo`80000/Ob1o07lPO`1o87l0Ob0007nP
Oh1oX7n0Oj1oP7nPOh1oX7n0Oj0007OPLn1gh7?PMn1ch7OPLn1gh7?P001Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh000En1Ch0H00083h`0I0003j@?Z0nT3jP?Y0nX3j@?Z0nT3jP?Y0003kP?_0nh3k`?^0nl3kP?_
0nh3k`?^00000`?b00D3l`?b0o83lP?c00<3lP040003m0?d0o<30o@01P?c0o@3m0?d0o<00083m003
0o<3m0?d0080000C0Il1O`6O0Gl1W`000Ml1_`7O0Kl1g`6o0Ml1_`7O0Kl1g`6o0Ml0100000X2G`9o
0Ul2O`9O0Wl2G`9o0Ul000<3G`80000:09l0O`2O07l0W`1o09l0O`2O000@Ool2001bOol006Yoo`@0
00Eoo`03001oo`0000Eoo`<00003O`1o87l0009o0006Ob1o07l0O`1o80000gnP00EoP7nPOj1oX7n0
009oX003001gh7OP00Qgh009001Wh6?PIn1Sh6OPHn1Wh6?P00D000T3h`0<0003j@?Z0nT3jP?Y0nX3
j@?Z0nT3jP000`?_00D3kP?_0nl3k`?^00<3k`030003lP?b00T3lP030003m0?d00X3m0030003m000
008000L1O`030001g`7O00T1g`<000050Ul2O`9o0Wl2G`030Wl01@9O0Wl2O`9o0Ul00`000`1o00D0
W`1o07l0O`2O00<0O`0309l007oo011oo`03001oogoo06moo`00JGoo00<007ooOol00Woo00<007oo
Ool00Woo00D007ooOol007oo00<0000WOX1nX000Ob1o07lPO`1o87l0Ob1o07lPO`1o8000Oj1oP7nP
Oh1oX7n0Oj1oP7nPOh0007?PMn1ch7OPLn1gh7?PMn1ch7OP001Wh6?P00D000032n0?h00000/3h`0J
0003jP?Y0nX3j@?Z0nT3jP?Y0nX3j@000nh3k`?^0nl3kP?_0nh3k`?^0nl3kP000o83l`<3lP050o<3
lP?b0o83l`020o801@000o@3m0?d0o<00`?d00<3l`?d0o@00`0001@1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0001_`7O0Kl1g`6o0Ml1_`7O0P000101_`7O0Kl0009O0Wl2G`9o0Ul2O`9O0Wl2G`9o0Ul2O`80
000>07l0W`1o09l0O`2O07l0W`1o09l0O`2O07l0019oo`03001oogoo06ioo`00JGoo00<007ooOol0
0Woo00H007ooOomoo`00Ool400000gj0OZ1nP002OX001GjP001o07l0Ob000gl000Io87l0O`1o0000
Oh03Oj001Gn0Oj1oX7nPOh000WnP00<007OPMn001GOP1@0000D;h0oP3n0?h0_P00<?h0030003h`?S
00T3h`0=0003jP?Y0nX3j@?Z0nT3jP?Y0nX3j@000nh00`?_00D3kP?_0nl3k`?^0083k`030003lP?b
00T3lP030003m0?d00D3m0<000030Gl0005o00/1O`030001g`7O00<1g`<000D1g`030002O`9O00<2
O`050Ul2O`9o0Wl2G`04000207l01@2O07l0O`1o09l00`1o00D0W`1o07l0O`00015oo`03001oogoo
06ioo`00JGoo00<007ooOol00Woo00@007ooOomoo`80000UOZ1nP7jPOX1nX7j0OZ1nP7jPOX1nX000
Ob1o07lPO`1o87l0Ob1o07lPO`0007n0Oj1oP7nPOh1oX7n0Oj1oP7nP001gh7?PMn00100000h_h3?P
;n0000_P3n0;h0oP2n0?h0_P3n0;h0002`?S01P000?Y0nX3j@?Z0nT3jP?Y0nX3j@?Z0003k`?^0nl3
kP?_0nh3k`?^0nl3kP?_00020o801@?c0o83lP?b0o<00`?b00@3l`000o@3l`<3m08000<1O`0A0Il1
O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`000Kl1g`0300004@7O0Kl1g`6o0Ml1_`7O0Kl0009O0Wl2
G`9o0Ul2O`9O0Wl00P0000<<7a0O31l00P0000h0W`1o09l0O`2O07l0W`1o09l0O`2O07l0W`004Goo
0P00Kgoo001YOol00`00Oomoo`02Ool01000Oomoogoo0P000gj000EnX7j0OX1nP7jP00=nP005OZ00
07l0O`1o8003O`001WlPO`1o07l0001oP0=oX004Oh1oX7nPOj050002;n001S?P;n0_h2oP<n0000<?
h0052n0?h0oP3n0;h0023n000`000n<3h`090n<03P000nT3jP?Y0nX3j@?Z0nT3jP?Y0nX000?_0nh3
0nl01`?^0nl3k`?_0nh3k`0000/3lP030003m000008000L1O`030001O`5o00T1O`<000`1g`040002
O`9o0Ul20Wl2000341l01@`O41l0002O00000P1o00D0W`1o07l0O`2O00<0O`0409l0O`1o000BOol0
0`00Oomoo`1/Ool006Uoo`03001oogoo009oo`06001oogooOol007oo0P0001UnX7j0OZ1nP7jPOX1n
X7j0OZ1nP7jP001o87l0Ob1o07lPO`1o87l0Ob0007nPOh1oX005000065OPDn1Gh000<n0_h3?P;n0c
h2oP<n0_h3?P000?h0_P3n0;h0oP2n0?h0_P3n0000/3h`0H0003jP?Y0nX3j@?Z0nT3jP?Y0nX3j@00
0nh3k`?^0nl3kP?_0nh3k`?^0nl3kP000`?b00D3l`?b0o83lP?c0083lP<00081O`050Il1O`5o0Gl1
W`030Gl02@6O0001W`5o0Il1O`6O0Gl1W`0300004`6O0001g`6o0Ml1_`7O0Kl1g`6o0Ml1_`7O0Kl1
g`000Wl2G`9o0080000H31l@7``O41l<7a0O31l@7`0009l0002O07l0W`1o09l0O`2O07l0W`1o09l0
O`004Woo00<007ooOol0K7oo001YOol00`00Oomoo`02Ool01000Oomoogoo0P000Woo00@007j0OX1n
X0=nP006OZ1nP7j0OX1nX0000Wl000=o87l0O`001`0025OP00<002oP<n000boP00Hch2oP;n0_h000
2n033n001`_P3n0?h0oP2n0?h00000X3h`0<0003j@?Z0nT3jP?Y0nX3j@?Z0nT3jP000`?_00D3kP?_
0nl3k`?^00<3k`030003lP?b00@3lP@000030Ml0005o00/1O`030001O`5o0081O`<000D1O`030001
g`7O00/1g`<0000341l<7a0O008@7`0831l@7a0O41l<7`0007l000<0O`0509l0O`1o07l0W`0307l0
0`2O07l0000BOol00`00Oomoo`1[Ool006Yoo`@000Aoo`03001oogoo009oo`0:001nX7j0OZ1nP7jP
OX1nX7j0OZ07000027oPNn1oh7_POn0005OPDn03En006U?PEn1Gh5OPDn0002oP<n0_h3?P;n0ch2oP
<n0_h0002n0?h0_P3n0;h0oP2n0?h0_P000;0n<06@000nT3jP?Y0nX3j@?Z0nT3jP?Y0nX000?_0nh3
k`?^0nl3kP?_0nh3k`?^0nl000?c00@000080Kl1g`6o0Ml1_`7O0001W`<1O`050Il1O`5o0Gl1W`02
0Gl00`000Il0000200005@6O0Gl1W`5o0Il1O`6O0Gl0006o0Ml1_`7O0Kl1g`6o0Ml1_`7O0Kl1g`02
00007@`O41l<7a0O31l@7``O41l<7a0O31l@7``O0000O`0007l0W`1o09l0O`2O07l0W`1o09l0O`2O
00004goo00<007ooOol0JWoo001aOol20005Ool200000gj0OZ1nP0040003OZ000`00On1oh007On00
0`00En1Gh007En001000;n0_h3?P0boP00Hch2oP;n0_h0002n033n001P_P3n0?h0oP2n0000X3h`0=
0003jP?Y0nX3j@?Z0nT3jP?Y0nX3j@000nh00`?_00D3kP?_0nl3k`?^00@000<1g`050Kl1g`7O0Ml1
_`020Ml00`000Gl1O`080Gl3000;0Gl00`000Ml1g`080Ml2000012PO000@7``O0a0O00D<7a0O41l@
7``O00<@7`040000O`1o000307l01P2O07l0O`1o09l0O`<0019oo`8006aoo`00LGoo00<007ooOol0
1Woo0`00019nX7k0OZ1n`7jPO/1nX7k0001oh7_POn1kh7oPNn1oh7_P0002En001E?PEn1Gh5OPDn00
0eOP01D003?P;n0ch2oP<n0_h3?P;n0ch0003n0;h0oP2n0?h0_P3n0;h0oP00002`?S00h000?Z0nT3
jP?Y0nX3j@?Z0nT3jP?Y0003kP?_1P000182G`9o0001g`6o0Ml1_`7O0Kl1g`6o0Ml1_`7O0Kl0005o
0Il30Gl06`6O000000000Il1O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0001g`6o0Ml1_`7O0Kl1
g`020002:1l082@O:1l0010O31l@7``O41l<7a0O31l@7``O41l<7`0007l0W`0009l0O`2O07l0W`1o
09l0O`00<1ld7c0O000COol00`00Oomoo`1YOol0075oo`8000Qoo`03001nX7jP00MnX003001oh7oP
00Moh003001Gh5OP00QGh004000_h2oP<n03;n001S?P;n0_h0003n0;h0<?h0052n0?h0oP3n00000:
0n<02@000nT3jP?Y0nX3j@?Z0nT3jP0500030Wl02@9O0Wl2O`9o0Ul2O`000Ml1_`030Ml01`6o0Ml1
g`7O0Kl1g`0000@1O`8000D1O`030001O`5o00X1O`030001g`7O0081g`<000HX7`04000@7a0O31l3
41l01@`O41l@7a0O31l00Q0O00D0001o07l0002O00<0O`0809l00000<1ld7c0O=1l001=oo`03001o
ogoo00Ioo`@000Eoo`8000Eoo`@004moo`00LGoo00<007ooOol027oo01D007jPO/1nX7k0OZ1n`7jP
O/1nX000Nn1oh7_POn1kh7oPNn1oh7_P00000UOP00ECh5OPEn1Gh5?P009Gh00E000_h3?P;n0ch2oP
<n0_h3?P;n0000_P3n0;h0oP2n0?h0_P3n0;h00000/3h`030003j@?Z00D0000L0el3?`000Ul2O`9O
0Wl2G`9o0Ul2O`9O0Wl2G`000Kl1g`6o0Ml1_`7O0Kl1g`6o0Ml1_`000Gl300030Gl0506O0Gl1O`5o
0Il0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`000Kl200000bPO91lX7`02:1l08b@O:1lX7bPO91l0
00`O41l<7a0O31l@7``O41l<7a0O31l@7`0009l0O`2O0000W`1o09l003@O<1ld7c0O=1l`7c@O0000
4goo00<007ooOol017oo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<0
07ooOol0C7oo001@Ool40005Ool20004Ool50004Ool40005Ool00`00Oomoo`09Ool20008OZ000`00
On1oh007On000`00En1Gh007En001@00;n0_h2oP<n000boP00<ch2oP00000PoP00D;h0oP3n0?h0_P
008?h0030003h`?S00<3h`P000P3G`040002O`9o0Ul30Wl01P9O0Wl2O`9o0Ul00081g`050Kl1g`7O
0Ml1_`020Ml3000;0Gl00`000Gl1O`090Gl3000<:1l01@0041l@7a0O31l00a0O00P<7a0O41l@7``O
41l0002O0P1o0`0000Td7c0O=1l`7c@O<1ld7c0O00004goo0P001Goo00<007ooOol00Woo00<007oo
Ool03Goo00<007ooOol0C7oo001?Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomo
ogoo00000goo00<007ooOol00Woo00<007ooOol00Woo0P0037oo01<007k0OZ1n`7jPO/1nX7k0OZ00
07_POn1kh7oPNn1oh7_POn000003En005U?PEn1Gh5OPDn1Gh000<n0_h3?P;n0ch2oP<n0_h3?P000?
h0_P3n0;h0oP2P0000H3nP?k0oX3n`?j00020el01@<o0el3G`=O0cl00`=O01<0009o0Ul2O`9O0Wl2
G`9o0Ul2O`9O0Wl0007O0Kl1g`6o0Ml1_`030000106o0Ml0006O0`5o00D1W`5o0Gl1O`6O00<1O`09
0001O`6O0Gl1W`5o0Il1O`6O00800005=1l002PO:1lT7`03:1l01B@O:1lX7bPO91l00bPO01h0010O
31l@7``O41l<7a0O31l@7``O41l<7`0007l0W`1o000`7c@O<1ld7c0O=1l`7c@O<1ld7c0O000COol0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`1<Ool004moo`03001oogoo
009oo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo009oo`03001oogoo00aoo`03001nX7jP
00EnX003001oh7oP00Moh003001Gh5OP00=Gh1<00083k`060o03k`?_0003n`?j0`?k00H3nP?k0o/3
n`?j000:0el01@000Wl2O`9o0Ul00`9o00D2G`9o0Wl0006o0081g`<00081g`050Kl1g`7O0Ml0000;
0Gl00`000Gl1O`040Gl20004=1l00`00:1lX7`0;:1l00`0031l@7`0241l01@`O41l@7a0O31l00a0O
014<7`000000030O000`7c@O<1ld7c0O=1l`7c@O<1ld7`0001Aoo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00Uoo`@004moo`00Cgoo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol0
27oo00@007ooOomoo`8000mooaL0000T:n0Wh2_P9n0[h0000n<3hP?S0n83h`?R0n<3hP?S0003l0?_
0o03k`?`0nl3l0?_0003nP?k0oX3n`?j0o/3nP?k0oX3n`000`=O00D3?`=O0el3G`<o0083G`0<0002
G`9o0Ul2O`9O0Wl2G`9o0Ul2O`9O0`0000`1_`7O0Kl1g`6o0Ml1_`7O0Kl0005o0Il30Gl02`6O0Gl1
O`5o0Il1O`000Gl1W`5o0Il00P001S@O00D002PO:1lX7b@O00<X7`0T91lX7bPO:1lT7bPO000@7``O
41l<7a0O31l@7``O41l<7a0O31l@7`00=1l`7c@O<1l0030O=1l`7c@O<1ld7c0O=1l`7`005Goo00D0
07ooOomoo`0000Aoo`03001oogoo00Uoo`03001oogoo051oo`00Cgoo00<007ooOol00Woo00<007oo
Ool02goo00<007ooOol00goo100017oo00<007ooOol03goo00<007kPO^001GkP00<006?PHn001f?P
00<002OP9n001ROP00@000?S0n<3hP<3h`040n83h`?S00030nl01`?`0nl3k`?_0o03k`000083n`05
0oX3n`?k0o/3nP030o/00`000el3G`080el00`000Ul2O`020Wl00`9O0Wl2O`0400000`7O0Kl1g`02
0Ml01`6o0Ml1g`7O0Kl1g`0000`1O`040001O`000009=1l00`00:1lX7`0;:1l00`0041l<7`0341l0
1@`O41l@7a0O31l00P00015L7`00=1l`7c@O<1l0030O=1l`7c@O<1ld7c0O=1l`7`0001Aoo`05001o
ogooOol00004Ool00`00Oomoo`09Ool00`00Oomoo`1@Ool004moo`03001oogoo009oo`03001oogoo
00aoo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo011oo`09001nh7k0O^1n`7kPO/1nh000
00USh00Y000[h2OP:n0Wh2_P9n0[h2OP0003hP?S0n83h`?R0n<3hP?S0n8000?_0o03k`?`0nl3l0?_
0o0000?k0oX3n`?j0o/3nP?k0oX3n`?j0003?`030el02`<o0el3G`=O0cl3G`000Wl2G`9o0Ul00`00
0142G`9o0Ul2O`000Ml1_`7O0Kl1g`6o0Ml1_`7O0Kl1g`000081O`050Il1O`5o0Gl1W`030Gl3000;
=1l00`0091lX7`02:1l01B@O:1lX7bPO91l00bPO00XT7`0031l@7``O41l<7a0O31l@7`8000=L7`0@
000`7c@O<1ld7`00=1l`7c@O<1ld7c0O=1l`7c@O000COol30003Ool4000<Ool5001>Ool004moo`03
001oogoo009oo`03001oogoo00Qoo`05001oogooOol00004Ool00`00Oomoo`05Ool2000BOol00`00
O^1nh005O^000`00Hn1Sh006Hn000`009n0Wh0069n001@000n<3h`?S0n800`?S00@3hP?S0003l0<3
k`060o03k`?_0nl3l0000`?k00D3nP?k0o/3n`?j0083n`030003G`=O00L3G`030002O`0000800082
O`060Ul2O`9o0Wl2G`000P7O00D1_`7O0Ml1g`6o00<1g`030Kl0005o00D1O`@00003=1l003@O00`d
7`03000X7bPO00/X7`04000@7a0O31l241l20006G1l04000<1ld7c0O=1l003@O<1ld7c0O=1l`7c@O
<1ld7`005Goo00<007ooOol0Hgoo001@Ool4000<Ool30005Ool50003Ool00`00Oomoo`0BOol02@00
O^1n`7kPO/1nh7k0O^000008Hn00:P009n0[h2OP:n0Wh2_P9n0[h0000n<3hP?S0n83h`?R0n<3hP?S
0003l0?_0o03k`?`0nl3l0?_0o0000?k0oX3n`?j0o/3nP?k0oX3n`000el3?`<3G`040cl3G`=O0el2
00006@9O0Wl2G`9o0Ul2O`9O0Wl2G`9o0001g`6o0Ml1_`7O0Kl1g`6o0Ml1_`7O0Kl0005o00@000Hd
7`03000d7c@O00Xd7`03000X7b@O00<X7`0591lX7bPO:1lT7`03:1l0100041l<7a0O0P0025`O0100
03@O<1ld7c0O=1l003@O<1ld7c0O=1l`7c@O<1l001Eoo`03001oogoo06=oo`00L7oo00<007ooOol0
4goo00<007kPO^001GkP00<006?PHn001V?P00<002OP9n001ROP00D000?S0n<3h`?R00<3h`040n80
00?_0o030nl01P?`0nl3k`?_0003nP<3n`070oX3n`?k0o/3nP?k00001@=O0`0000<3G`000Wl00P9o
00D2G`9o0Wl2O`9O00<2O`050001g`7O0Ml1_`030Ml00`6o0Ml1g`03000:=1l00`00=1ld7`0:=1l0
0`00:1lX7`0<:1l3000;G1l03000=1l`7c@O<1l0030O=1l`7c@O<1ld7`800003I1l007oo01Aoo`03
001oogoo069oo`00L7oo00<007ooOol057oo1@0000Anh7k0O^0000QSh00W000Wh2_P9n0[h2OP:n0W
h0000n83h`?R0n<3hP?S0n83h`?R0003k`?`0nl3l0?_0o03k`?`0nl000?j0o/3nP?k0oX3n`?j0o/3
nP000083G`<000030el3?`=O0083G`0B0002O`9O0Wl2G`9o0Ul2O`9O0Wl2G`000Kl1g`6o0Ml1_`7O
100000<X7`00=1l02c@O00<003@O=1l02S@O00@002PO:1lT7`<X7`0691lX7bPO:1lT7bPO0P003E`O
0100030O=1l`7c@O<1l0030O=1l`7c@O001T7f0OI1l001Eoo`8006=oo`00Kgoo00<007ooOol05Woo
00@007lPO`1o80T000=Sh003000Wh2OP00HWh0030003hP?S0083h`050n83h`?S0n<000020nl01@?`
0nl3k`?_0o000P?_00<000?k0oX00`?k00@3nP?k0o/3n`<000P3G`030002G`9o0082O`050Ul2O`9o
0Wl2G`020Wl00`000Kl000030006:1l00`00=1ld7`09=1l00`00=1ld7`0:=1l00`00:1lX7`08:1l2
00000gPO001L7`0=G1l02000<1ld7c0O=1l`7`00<1l20005I1l00`00Oomoo`0COol00`00Oomoo`1Q
Ool006moo`<001Moo`09001o87l0Ob1o07lPO`1o800000=;h0T0000M:n0Wh2_P0003h`?R0n<3hP?S
0n83h`?R0n<000?`0nl3l0?_0o03k`?`0nl3l0000o/3nP?k0oX3n`0300000`?k0003G`020el01@<o
0el3G`=O0cl00P=O00H0009O0Wl2G`9o0Ul700001B@O:1lX7bPO91l00bPO00<T7bPO000033@O00<0
03@O=1l02S@O00D002PO:1lX7b@O00<X7`8000=h7`03O1l005`O00aL7`06000d7c0O=1l`7c@O0P00
00QP7f@OH1mT7f0OI1mP7`005Woo00<007ooOol0H7oo001FOol40005Ool20005Ool40005Ool00`00
Oomoo`0HOol200001gl0Ob1o07lPO`1o800000M;h0040003h0?P0n0900001@?S0n83h`?S00000`?_
00L3l0?_0nl3k`?`0nl000020o/300000`?k0oX3n`020o/00`000el3G`030el:000541l00`00:1lX
7`0::1l00`00=1ld7`09=1l00`00=1ld7`0:=1l00`00:1lX7`02:1l30006N1l00`00G1mL7`0<G1l0
1`00=1l`7c@O001T7`0000QT7`03001oogoo01Aoo`03001oogoo05moo`00EGoo00<007ooOol00Woo
00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol00Woo0P006goo00P007l0Ob1o07lP
O`1o80001T_P00<000?P0n001P?P00@000?a0o03lAl0000A09l0O`2O07l000`O41l<7a0O31l@7``O
41l<7a0O31l00002:1l01B@O:1lX7bPO91l00bPO00<T7`00=1l02S@O00<003@O=1l02c@O00@002@O
0000009h7`05O1mh7gPON1ml7`03N1l00`00G1mL7`0;G1l04000<1l00000I1mP7f@O001T7f0OI1mP
7f@OH1mT7`005Goo0P00HGoo001EOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool0
0`00Oomoo`0KOol01`00O`1o87l0Ob1o000000M;h0030003h0?P00D3h0040003l@?a0o030o4010?`
0o43l@0010>o0`000P>o00<0007o0Ol01`7o00<0001o07l01`1o00<0010O41l0210O00<002PO:1l0
2RPO00<003@O=1l02C@O00<003@O=1l02C@O0`0037PO00<005`OG1l035`O00<006@OI1l016@O00<0
06@OI1l01F@O00<007ooOol057oo00<007ooOol0GWoo001EOol00`00Oomoo`02Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`0LOol200001GlPO`1o87l000001d_P00<000?P0n001@?P00/0
00?`0o43l0?a0o03l@?`0o4000>o00<00083_`040ml3_`>o00090Ol05`0009l0O`2O07l0W`1o09l0
O`2O000@7``O41l<7a0O31l@7``O41l<7a0O00000bPO00DT7bPO:1lX7b@O00<X7`03000d7c@O00Td
7`03000d7c@O00Ld7`800003O1al7@00009h7`05O1mh7gPON1ml7`03N1l017`ON1mh7`002e`O0P00
011l6@00H1mT7f0OI1mP7f@O001T7f0OI1mP7f@OH1l001Moo`03001oogoo05eoo`00EGoo00<007oo
Ool00Woo00<007ooOol02Goo100017oo0P007goo1@0000=o0000Bn001D_P00<000?P0n001@?P00D0
00?a0o43l@?`00<3l@030o00000000T3_`030001o`7o00L1o`030000O`1o00L0O`03000@7a0O00P@
7`03000X7bPO00TX7`03000d7c@O00Xd7`03000d7c@O00@d7`8000Al7003001h7gPO00]h7`03001L
7e`O00ML7`800004O1Yl6G`J0006I1l00`00I1mT7`05I1l00`00Oomoo`0DOol00`00Oomoo`1MOol0
05Eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Eoo`03001oogoo01moo`04001o@7m0
Od040005Bn000`000n03h0050n001@000o43l0?a0o000`0000<3l0000kl00P>o00L3g`>o0kl3_`?O
0kl000090Ol0600007l0W`1o09l0O`2O07l0W`1o000<7a0O31l@7``O41l<7a0O31l@7``O000T7`<X
7`0591lX7bPO:1lT7`02:1l00`00=1ld7`09=1l00`00=1ld7`02=1l20003O1`01G`MO1al77`L0000
0gPO00El7gPON1mh7g`O00=h7`03O1l005`O00ML7`0C001l6G`JO1Ul6W`IO1X006@OH1mT7f0OI1mP
7`00H1mT7f0OI1l00P0000=l7P00Ool057oo0P00GWoo001EOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`05Ool00`00Oomoo`0POol00`00Od1o@003Od040003Bn000`000n03h0050n040000
1P?`0o43l@?a0o0000T3_`030001o`7o00L1o`030000O`1o00L0O`03000@7a0O00P@7`03000X7bPO
00TX7`03000d7c@O00Xd7`04000d7`000009O1`00`00N1mh7`0;N1l00`00G1mL7`03G1l2000027`I
O1Yl6G`JO1Ul6W`I0007I1l01000I1mT7`000g`O00<007ooOol057oo00<007ooOol0G7oo001FOol4
000<Ool50003Ool2000ROol00`00Od1o@003Od000`00=n0gh00400050n0300002P?`0o43l0?a0o03
l@?`0o43l0000`>o00H3g`>o0kl3_`?O00090Ol06@0009l0O`2O07l0W`1o09l0O`2O000@7``O41l<
7a0O31l@7``O41l<7a0O000X7b@O00<X7`0791lX7bPO:1lT7bPO00002S@O0`0000=l77`MO1`00W`L
00El7G`LO1al77`M009l7003001l7gPO009h7`05O1mh7gPON1ml7`03N1l01000G1mL7e`O0P0001Yl
6W`IO1Yl6G`JO1Ul6W`IO1Yl6@00H1mT7f0OI1mP7f@O001T7`00O1ml7W`OO1il7`005Woo00<007oo
Ool01Woo1@00D7oo001^Ool00`00Oomoo`0ROol00`00Od1o@003Od000`00=n0gh002=n0600030n00
0`000o03l@020o401@?`0o43l@?a00002@>o00<0007o0Ol01`7o00<0001o07l01`1o00<0010O41l0
210O00<002PO:1l02BPO00<003@O=1l013@O10000W`L00<007`LO1`02W`L00<007PON1l02gPO0`00
00el6G`JO1Ul6W`IO1Yl6G`JO1Ul6W`IO1X00006I1l20007O1l00`00Oomoo`0DOol00`00Oomoo`07
Ool00`00Oomoo`1@Ool006ioo`03001oogoo02=oo`8000Ao@004000gh3OP<n0300000`?W00000002
00003@?P0003l@?`0o43l0?a0o03l@?`0o4000?O00<3_`050ml3_`>o0kl000090Ol05`0007l0W`1o
09l0O`2O07l0W`1o000<7a0O31l@7``O41l<7a0O31l@7``O00000RPO00DT7bPO:1lX7b@O00<X7`03
91l003@O00@000Il7005001l77`LO1al7@03O1`02G`MO1al77`LO1el7000N1ml7`03N1l01W`ON1mh
7gPOO1mh7`80000OO1Yl6G`JO1Ul6W`IO1Yl6G`JO1Ul6W`IO1Yl6G`J001T7f0OI1mP7`00O1il7`00
O1ml7W`OO1il7g`N00005Woo00<007ooOol01goo00<007ooOol0D7oo001^Ool00`00Oomoo`0TOol4
0002Od030003=n000`000nL3i`020nL700001@?a0o03l@?a00002@>o00<0007o0Ol01`7o00<0001o
07l01`1o00<0010O41l0210O00<002PO:1l01bPO10002g`L00<007`LO1`02W`L00<007PON1l01gPO
0P000W`B010007`JO1Ul6W`IO1Yl6G`JO1Ul6W`IO1Yl6G`JO1T000=T7`03001l7g`O009l7`03001l
7g`O00Al7`03001oogoo01Aoo`03001oogoo00Ioo`03001oogoo051oo`00KGoo00<007ooOol09Woo
00<007mP000010000SOP00Hch3OP=n0000?W0nP30nL01@?X0003o0?k0o`020000`>o00@3g`>o0kl0
00T1o`0G0000W`1o09l0O`2O07l0W`1o09l0010O31l@7``O41l<7a0O31l@7``O41l00002:1l60000
17`ON1ml7`002g`L00<007`MO1`00W`L00El7G`LO1al77`M00=l7005O1d007PON1ml7`03N1l20000
57`BO15l4W`A001l6G`JO1Ul6W`IO1Yl6G`JO1Ul6W`IO1Yl6G`JO1T300003G`NO1ml7W`OO1h007`N
O1ml7W`OO1il7`0001Moo`03001oogoo00Eoo`03001oogoo051oo`00KGoo0P009Woo0`0017mP0`00
0cOP00<000?W0nL01@?W00<000?l0o`01P?l00<0007o000010000P>o00<0007o0Ol01`7o00<0001o
07l01`1o00<0010O41l00a0O20002GPO00<007`LO1`02W`L00<007`LO1`02W`L00<007PON1l00WPO
0P001g`B010007`IO1Yl6G`JO1Ul6W`IO1Yl6G`JO1Ul6W`IO1X000Ql7`03001l7g`O00Al7`03001o
ogoo01Aoo`03001oogoo00Eoo`03001oogoo051oo`00C7oo10001Goo0P001goo00<007ooOol00goo
10001Goo00<007ooOol08goo0P000goo00H007mPOh1oH7n0Of0300000c?P=n0000020nL050?X0nL3
i`?W0nP000?l0o/3o0?k0o`3n`?l00027`7o0Ql1o`8O0OlL00004f0OG1mL7e`OH1mL7`00N1ml7gPO
O1mh7g`ON1ml7gPOO1mh7`0000]l7003001l77`M00=l7005O1el77`LO1al7@03O1`06P00N1l00000
O19l4G`BO15l4W`AO19l4G`B001l6W`IO1Yl6G`JO1Ul6W`IO1Yl6G`JO1T200003W`C001l7g`NO1ml
7W`OO1il7g`N001l7W`OO1h200000g`O001oo`0DOol20004Ool3001BOol004]oo`03001oogoo009o
o`03001oogoo009oo`8000Moo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`80025o
o`<000Ioo`03001oH7mP00=oH003000Wh00000<000L3i`030003o0?l00D3o00300027`7o0081o`05
0Ql1o`7o0Ol0000901l01000=1ld7c0O0c@O00@`7c@O=1l000YL7`03001h7gPO00Uh7`03001l77`L
00Yl7003001l77`L00Ul70<000al4P0<001l6W`IO1Yl6G`JO1Ul6W`IO1Yl6@000g`C00<007`OO1l0
1g`O00<007`O000017`O00<007ooOol03Woo1P001Woo00<007ooOol0D7oo001;Ool00`00Oomoo`02
Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`0MOol3000:Ool20000
27n0Of1oP7mP000Wh2_P9n0300000`?W0nP3i`020nL04P000o/3o0?k0o`3n`?l0o/3o0000Ql1o`8O
0Ol27`7o0Ql000T07`0;000d7c0O=1l`7c@O<1ld7c0O=1l00002G1l01F0OG1mL7e`OH1l00e`O00iP
7`00O1mh7g`ON1ml7gPOO1mh7g`ON1ml7`002g`L00@007`LO1al7@=l7003O1el70000080000HO0el
3P00O19l4G`BO15l4W`AO19l4G`BO15l4W`AO18007`JO1Ul6W`IO1Yl6G`J0P0000il4W`CO19l4g`B
001l7W`OO1il7g`NO1ml7W`O0P0000Ml7W`OO1il7g`NO1l0000<Ool30005Ool00`00Oomoo`1GOol0
04]oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Ioo`03001oogoo009oo`03001oogoo
01Yoo`<000ioo`@0009oH003000Wh2_P008Wh0@000<3i`030003o0?l00D3o0030001o`8O00<1o`04
0Ql1o`7o000901l01@00=1ld7c@O<1l00c@O00<`7c@O00002U`O00<007PON1l02GPO00<007`LO1`0
2W`L00<007`LO1`00g`L0P001G`>00<007`BO1802g`B00H007`IO1Yl6G`JO1T20008O1<00`00O1ml
7`04O1l30006O1l00`00Oomoo`07Ool30008Ool00`00Oomoo`1GOol004]oo`03001oogoo009oo`03
001oogoo00aoo`03001oogoo009oo`@000Aoo`8001Uoo`<0019oo`03001oH7n000@000079n0[h2OP
:n0000?]0n`01@000143n`?l0o/3o0?k0o`3n`000Ol27`7o0Ql1o`8O0Ol27`0000P07`0;000`7c@O
<1ld7c0O=1l`7c@O<1l00003G1l01F0OG1mL7e`OH1l00e`O00d007POO1mh7g`ON1ml7gPOO1mh7g`O
N1l0000;O1`00`00O1al70030000=g`>O0el3W`=O0il3G`>O0d007`AO19l4G`BO15l4W`AO19l4G`B
O15l4W`A001l6G`JO1T007`BO1=l4W`CO19l4g`BO1=l4W`C001l7g`NO1ml7W`O001l7g`NO1l007`O
O1il7g`NO1ml7P0000Aoo`@000aoo`03001oogoo05Ioo`00Bgoo00<007ooOol00Woo00<007ooOol0
3Goo00D007ooOomoo`0000Moo`03001oogoo01Eoo`<001Ioo`8000=oP0<00004:n0Wh2OP00050nd4
00050o`00`000Ol27`030Ol00`8O0Ol0000901l00`00<1ld7`02=1l01S0O=1ld7c@O<1l000YL7`03
001h7gPO00Uh7`03001l77`L00Ul70<000]l3P03001l4W`B00]l4P04001l6P00000<O1<01@00O1ml
7g`O00001G`O00<007`OO1l017`O100047oo00<007ooOol0EWoo001;Ool00`00Oomoo`02Ool00`00
Oomoo`08Ool00`00Oomoo`02Ool01@00Oomoogoo00001goo00<007ooOol04Woo0`006goo00D007n0
Oh1oP7mP00<000059n0[h0000nd3k0030nd00`?/0003G`0400002`?l00027`7o0Ql1o`8O0Ol27`7o
00002@0O00/0030O=1l`7c@O<1ld7c0O=1l0060O00=L7`05H1mL7e`OG1mP7`02G1l03@00O1mh7g`O
N1ml7gPOO1mh7g`ON1ml7`0000Il70@0000LO0il3@00O0el3W`=O0il3G`>O0el3W`=O0il3G`>001l
4W`AO19l4G`BO15l4W`AO19l4G`BO142000047`CO19l4g`BO1=l4W`CO19l4g`BO1=l4W`CO18007`N
0P0000]l7g`NO1ml7W`OO1h007`NO1ml7W`O00800003H1l007oo015oo`03001oogoo05Ioo`00C7oo
10002goo1P000goo1@000goo0P0047oo0`007goo0P000gn000H001oP000002OP00060nd00`000el3
O`020el500001`8O0Ol1o`7o0Ql1o`0000P07`03000d7c0O00<d7`05<1ld7c@O=1l0000:G1l00`00
N1mh7`09N1l00`00O1al70040006O0h00`00O0il3P0:O0h00`00O19l4P08O18200000g`:O0/0000>
O1<00`00O1ml7`07O1l01000O1ml7`0016@O0P0047oo00<007ooOol0EWoo001/Ool00`00Oomoo`0<
Ool3000SOol300001Gn0Of0001oP8n000`0000<3k@?/0nd00P?]00X3k0000el3O`=O0gl3G`=o0000
g`D000030Ql0000O00P07`0<000d7c0O=1l`7c@O<1ld7c0O001L7f0O0e`O011P7e`OG1mL7f0OG1l0
07POO1mh7g`ON1ml7gPOO1mh7`@0000PO0il3G`>O0el3W`=O0il3G`>O0el3P00O0il3G`>O0el3W`=
O0il3G`>O0el3W`=001l4G`BO15l4W`AO19l4@80000AO0]l2W`;O0X007`BO1=l4W`CO19l4g`BO1=l
4W`CO19l4`0200002g`B001l7W`OO1il7g`NO1ml7W`OO1h00P0000QT7f0OI1mP7f@OH1mT7`003Woo
0P00F7oo001/Ool00`00Oomoo`0:Ool2000WOol02@00Oh000000Oh0001oP8n0Oh00300040nd01000
0el3G`=o0`=O00<3O`000=l0103O1`00100O00@003@O=1l`7`<d7`04<1ld7c@O000:G1l01000N1mh
7gPO1P0000Al4G`BO18000]l3P03001l3W`>00Yl3P03001l4W`B009l4P<00008O0Yl2g`:O0]l2W`;
O0X000Ul4`8000Al4`03001l7g`O00Al7`<000IT7`800003=1l0000000Uoo`<00003Ool007oo05Mo
o`00Jgoo0P002Goo0`00:Woo00<007n0Oh000`0000@Oh2?P7n0Sh0@00083k@0B0003O`=O0gl3G`=o
0el0002o0=l0_`3O0;l0g`2o0=l002`O0RPO2P0000D`7c@O<1ld7`00009L7`04H1mL7e`OG1l80000
9G`BO15l4W`AO19l4G`BO15l4P00O0il3G`>O0el3W`=O0il3G`>O0el3W`=001l3G`>O0el3W`=O0il
3G`>O0el3W`=O0h007`B0080000BO0Yl2g`:O0]l2W`;O0Yl2g`:O0]l2P00O19l4g`BO1=l4W`C0P00
01]l4W`CO19l4g`BO1=l4P00O1il7g`NO1l006@OH1mT7`00I1mP7f@OH1l0030O=1l`7c@O<1l00`00
0Woo100017oo00<007ooOol0EWoo001[Ool00`00Oomoo`05Ool3000^Ool01000Oh1oP7n00P0000DO
h2?P7n0Sh0000083l0@00083G`050gl3G`=O0el000080=l00`00:1lX7`06:1l01000I1mT7f@O2`00
0g`I00Il6W`IO1T007`BO143O1801g`AO19l4W`BO15l4P0000]l3P03001l3W`>00Ul3P<0000?O0]l
2W`;O0Yl2g`:O0]l2W`;O0Yl2g`:O0]l2P0000=l4`8000Yl4`04001l7`000005I1l02@00I1l00000
<1ld7c0O=1l`7`0200000`2O07l000030007Ool00`00Oomoo`1EOol006]oo`8000=oo`<0039oo`05
001oP7n0Oh1oH002000022?P7n0Sh0000o03k`?`0nl3000040=O0gl3G`=o0el0002o0=l0_`3O0;l0
g`2o000X7b`O0bPO00@/7bPO:1l000UT7`0/001l6W`IO1Yl6G`JO1Ul6W`IO1Yl6@00O15l4W`AO19l
4G`BO15l4W`AO19l4@00O0el3W`=O0il3G`>O0el3W`=O0il3G`>001l3W`=O0il3G`>O0el3P<0000C
O0Ml1P00O0Yl2g`:O0]l2W`;O0Yl2g`:O0]l2W`;O0Yl2`00O1<00P0001El4W`CO19l4g`BO1=l4W`C
O19l4g`BO1=l4P00H1mT7f0OI1mP7f@OH1l00P0000Xd7c0O=1l`7c@O<1l0001o09l0O`<000Uoo`03
001oogoo05Eoo`00HWoo1@0017oo00<007oo00000P00=Woo0P000gn00`0000<Oh0000o001@?`1000
0`=O00<0003O0=l01@3O00<002PO:1l01RPO00<006@OI1l01V@O00<007`IO1X00g`I00Ml6W`IO1Ul
6G`JO1T00002O1801G`AO19l4W`BO1400g`B00=l4@00O0h02W`>00<007`>O0h00g`>0P000W`6019l
1g`6O0Il1P00O0Yl2g`:O0]l2W`;O0Yl2g`:O0]l2W`;O0X2000=O1<200000g`I001T7`04I1l01`00
<1l0030O=1l`7c@O0080000307l0W`00008000]oo`03001oogoo05Eoo`00I7oo00<007ooOol017oo
0P00>Woo100000=oH00000000`0000T3k`?`0nl3l0?_0o0000;o0]l0100000/0g`2o0=l0_`3O0;l0
g`2o000X7b`O00<X7`04;1lX7bPO0008I1l09P00O1Ul6W`IO1Yl6G`JO1Ul6W`IO1X007`BO15l4W`A
O19l4G`BO15l4W`AO18007`>O0el3W`=O0il3G`>O0el3W`=O0il3@00O0d3000057`6O0Ml1W`7O0Il
1g`6O0Ml1P00O0Yl2g`:O0]l2W`;O0Yl2g`:O0/200003G`:O0/007`CO19l4g`BO1=l4W`CO19l4g`B
00800004O1Yl6G`JO1T2000026@O0000030O=1l`7`00<1l200000`2O07l0W`03000<Ool00`00Oomo
o`1EOol006Aoo`03001oogoo00Eoo`03001oogoo03Uoo`03001oH7mP00@000048n00000000050o00
1@000]l2g`;o0]l010001P3O00<002PO:1l01BPO00<006@OI1l01f@O00<007`IO1X00g`I00Il6W`I
O1Ul6G`J0003O1801G`AO19l4W`BO1400g`B00<007`>O0h027`>0`0000=l1W`7O0H00W`600El1g`6
O0Il1W`7009l1P09001l2g`:O0]l2W`;O0Yl2g`:00800006O0]l2W`;O0Yl2`001g`C0P00011l6G`J
O1Ul6W`IO1Yl6G`J000d7c0O=1l`7c@O<1l000<0O`<000ioo`03001oogoo05Eoo`00I7oo00<007oo
Ool01Woo0P00>Woo0P0000=oH7n0Of000P0000<Sh1oP00000`0000/3l0?_0002g`;o0]l2o`;O0_l0
000o00D000050=l002PO:1l/7`03:1l00b`O:1l00008I1l07P00O1Yl6G`JO1Ul6W`IO1Yl6G`JO1T0
07`AO19l4G`BO15l4W`AO19l4G`BO14007`=O0il3G`>O0el3P@0000FO0Il1`00O0Ml1W`7O0Il1g`6
O0Ml1W`7O0Il1g`6O0L007`;O0Yl2g`:O0/200003G`:O0]l2W`;O0Yl2g`:O0/007`CO19l4g`B0080
0008O1Yl6G`JO1Ul6W`IO1Yl6@800005G1l00000<1ld7`0200000`1o00000002000@Ool00`00Oomo
o`1EOol006Aoo`03001oogoo00Qoo`03001oogoo03Uoo`03001oH7mP009oH08000047n0000?`0o04
00030]l010;o0]l2g`001@0o1@001RPO00<006@OI1l01V@O00@007`IO1Ul6P=l6@06O1Yl6G`IO1T0
07`A0g`B00El4G`BO19l4W`A009l4P03001l3P0000<0009l1P06O0Ml1W`6O0Il1`000W`600El1g`6
O0Il1W`700=l1P06O0Ml1W`6001l2g`:0P0000el2g`:O0]l2W`;O0Yl2g`:O0]l2W`;001l4`020000
27`IO1Yl6G`JO1Ul6W`IO1X20005G1l7000BOol00`00Oomoo`1EOol006Aoo`03001oogoo00Uoo`03
001oogoo03Uoo`800003Oh1oH7n000D000030o03k`?`00<000060_l2g`;o0]l2o`001`0o00<0040O
0000100000</7`00I1l026@O014007`JO1Ul6W`IO1Yl6G`JO1Ul6P00O19l4G`BO15l4W`A00L0000I
O0Il1g`6O0Ml1W`7O0Il1g`6O0Ml1W`7001l1g`6O0Ml1W`7O0Il1g`6O0Ml1W`7O0H00`0000el2W`;
O0Yl2g`:O0]l2W`;O0Yl2g`:O0]l2P02000027`JO1Ul6W`IO1Yl6G`JO1T20005G1l200000``O41l0
000200000goo001oo`0AOol00`00Oomoo`1EOol0069oo`<000aoo`03001oogoo03Uoo`<0009oH003
000[h000008000@3l0@000040_l2g`;O000603l00`00@1m07`04@1l70004I1l01@00O1Ul6G`IO1X0
0W`I2P0000Ql2W`;O0Yl2g`:O0/007`70g`600El1g`6O0Il1W`700=l1P05001l1W`6O0Il1`03O0H0
0g`7O0H000020002O0H03000O0]l2W`;O0Yl2g`:O0]l2W`;O0Yl2`80009l4P06001l6W`IO1Yl6G`J
0P001E`O0P000Q0O0P001Goo00<007ooOol047oo00<007ooOol0E7oo001TOol00`00Oomoo`0;Ool2
000jOol00`00Od00000300000b_P9n00000200001P?_0o03k`000]l2o`D000H0?`0=000l7d0O?1m0
7c`O@1ll7d0O001l7g`NO1l02`0002El4g`BO1=l4W`C001l2g`:O0]l2W`;O0Yl2g`:O0]l2W`;001l
1g`6O0Ml1W`7O0Il1g`6O0Ml1W`7O0H007`6O0Ml1W`7O0Il1`0200003g`6O0Ml1W`7O0Il1`00O0]l
2W`;O0Yl2g`:O0]l2P0200001G`BO15l4W`AO1800P0000=l6@0000001E`O0P0000@<7a0O000000Mo
o`03001oogoo011oo`03001oogoo05Aoo`00M7oo00<007ooOol0>7oo0P000Wm00`000ROP100000<3
l00000000P;O00<2o`;O00000P001@0o00<0040O@1l01D0O00@007`OO1ml7P=l7`05O1il7g`O001l
4P03O1<057`BO1=l4g`CO19l4`00O0]l2W`;O0Yl2g`:O0]l2W`;O0Yl2`00O0L3O0H01G`7O0Il1W`6
O0L00g`600<007`6O0H00`000W`600El1g`6O0Il1W`7009l1P06001l2g`:O0]l2W`;0P0027`B0`00
15`O0P0000@@7``O000000Yoo`03001oogoo00moo`03001oogoo05Aoo`00MGoo00<007ooOol0>Goo
00@007m0Od1o@0@000039n0000?/00@000050_l2g`;o0]l2o`04000303l0=@00?1m07c`O@1ll7d0O
?1l007`NO1ml7W`OO1il7g`NO1ml7P00O19l4g`BO1=l4W`CO19l4g`BO1<007`;O0Yl2g`:O0]l2W`;
O0Yl2g`:001l1W`7O0Il1g`6O0Ml1W`7O0Il1g`6O0L00`00011l1g`6O0Ml1W`7O0Il1g`6O0Ml1W`7
O0Il1`00O0]l2P800008O19l4G`BO15l4W`AO19l4@800003O1mh7gPO00P000eoo`03001oogoo00io
o`03001oogoo05Aoo`00MWoo00<007ooOol0>Goo0P000Wm000<003OP=n0010000P?]0`0000D2g`;o
0]l2g`000080?`@000Q07`04001l7g`OO1h3O1l01G`NO1ml7`00O1800g`C01Al4W`CO1=l4g`B001l
2W`;O0Yl2g`:O0]l2W`;O0Yl2g`:001l1W`70g`600=l1g`600000`000W`600D007`6O0Il1W`700=l
1P06O0Ml1W`6O0Il1g`60`0027`B0P001GPO0P0000<X7`0000004Goo00<007ooOol03Goo00<007oo
Ool0E7oo001gOol2000jOol3000017m0000003?P0SOP0`000P?]100000<2g`;o0000100o100002U0
7c`O@1ll7d0O?1l007`NO1ml7W`OO1il7g`NO1l007`CO19l4g`BO1=l4W`CO19l4g`B001l2W`;O0Yl
2g`:O0]l2W`;O0Yl2g`:001l1W`700@0000AO0Il1g`6O0Ml1W`7O0H007`6O0Ml1W`7O0Il1g`6O0Ml
1P0300002G`=O0h007`BO15l4W`AO19l4@020002N1l00g`ON1mh7`05000COol00`00Oomoo`0=Ool0
0`00Oomoo`1DOol007Uoo`03001oogoo03Qoo`03001o800000<000@gh0@000030nd000=O00@000D0
?`0300107`0000@00003@1l007`O009l7`09O1il7g`OO1ml7W`O001l4g`B00=l4`0<O19l4g`CO1=l
4P00O0Yl2g`:O0]l2W`;1`0000El1g`6O0Il1W`700=l1P05O0Ml1W`6O0H00003O0H00g`7O0Il1P02
0006O0h20002O1820005N1l4000GOol00`00Oomoo`0<Ool00`00Oomoo`1DOol007Yoo`03001oogoo
03Qoo`04001o87l0Ob040002=n000c?P0003i`0400000`=o0el00002000403l01P00@1ll7d0O?1m0
7`P0000;O1il7g`NO1l007`CO19l4g`BO1=l4P0:00005g`;O0Yl2g`:O0]l2P00O0Il1g`6O0Ml1W`7
O0Il1g`6O0Ml1W`7O0H007`6O0L00`0000Ul3W`=O0il3G`>O0el3W`=O0h010000gPO00=l7`000000
0P006Woo00<007ooOol037oo00<007ooOol0Dgoo001kOol00`00Oomoo`0hOol01`00Ob1o07lPO`00
04_P00H00083i`<00083G`@00080?`8000I07`05001l7g`OO1ml7P0;000057`BO1=l4g`CO18007`:
O0]l2W`;O0Yl2g`:O0]l2W`;O0X007`6O0L3O0H01G`7O0Il1W`6O0L00W`60`002W`>0P0017`L1@00
7Woo00<007ooOol02goo00<007ooOol0Dgoo001lOol2000iOol200000gl0Ob1o00020003Bn040000
0`?W0nP0000300000`=O0000_`050000;c`O@1ll7d0O?1m07`00O1ml7W`OO1il7g`NO1ml7W`O001l
4g`BO1=l4W`CO19l4g`BO1=l4P00O0Yl2g`:O0]l2W`;O0Yl2g`:O0]l2P00O0Il1g`6O0Ml1W`7O0H0
100000Yl3W`=000007`>O0el3W`=O0il3@<000=l70@0029oo`03001oogoo00]oo`03001oogoo05=o
o`00OWoo00<007ooOol0=goo1@0000=o8000Bn0014_P2`000`3O1000140O0P000W`O00Il7W`OO1ml
7g`NO1l200001G`BO1=l4g`CO1800g`C011l4P00O0Yl2g`:O0]l2W`;O0Yl2g`:O0]l2P00O0Il1`@0
00Ql3P80009l3P80009l70@002Moo`03001oogoo00Yoo`03001oogoo05=oo`00Ogoo00<007ooOol0
=goo00@007kPO/1nh0L0009;h08000030n000000008000030o/00000008000030=l0_`0000H0000L
?1l007`NO1ml7W`OO1il7g`NO1ml7P00O19l4g`BO1=l4W`CO19l4g`B001l2W`;O0Yl2g`:O0/70000
37`>O0el3W`=O0il3G`>O0el3W`=O0il3@T002]oo`03001oogoo00Uoo`03001oogoo05=oo`00P7oo
00<007ooOol0=goo00<007kPO^000gkP0P000V?P1`0000<3h00000002P000bPO700000=l4W`AO180
0W`B00Al4G`B000000Al3PH0009l70@002ioo`03001oogoo00Uoo`03001oogoo05=oo`00PGoo0P00
>7oo00P007kPO/1nh7k0O^1n`0001V?P2`0000<27`7o0Ql01@000RPO0P0026@O0P0000Ql6W`IO1Yl
6G`JO1Ul6W`I0P0000]l4W`AO19l4G`BO15l4W`AO19l4G`B00D000Al70@003=oo`03001oogoo00Qo
o`03001oogoo05=oo`00Pgoo00<007ooOol0=Woo1@000WkP0P001V?P0P000ROP2`0000<1o`000000
1@0026@O0P0000=l6G`JO1T00W`I00=l6W`IO1T00P0000Al4G`BO19l4PD000Eh7`D003Moo`03001o
ogoo00Qoo`03001oogoo059oo`00Q7oo00<007ooOol0=Woo00@007k0OZ1n`3T00005O1mh7g`ON1ml
7`05000mOol00`00Oomoo`07Ool00`00Oomoo`1BOol008Eoo`03001oogoo03Ioo`03001nX7jP00En
X08000Moh08000MGh0800003;n0000000280049oo`03001oogoo00Moo`03001oogoo059oo`00QWoo
0P00=goo00T007k0OZ1n`7jPO/1nX7k0OZ000P0000Eoh7_POn1kh7oP01400003Mn1ch7OP00@005]o
o`03001oogoo00Ioo`03001oogoo059oo`00R7oo00<007ooOol0=Goo00<007jPOZ000gjP2@000Wl0
00Io87l0000007nPOh03Oj0017n0Oj1oX7nP1@00H7oo00<007ooOol01Goo00<007ooOol0DWoo0029
Ool00`00Oomoo`0eOol500003gjPOX1nX7j0OZ0007lPO`1o87l0Ob1o07lPO`1o800200000gn0Oj1o
P004001VOol00`00Oomoo`04Ool00`00Oomoo`1BOol008Yoo`03001oogoo03Eoo`03001nX7j0009n
P005OZ1nP7j0OX1nX00200000gl0Ob1o0002O`000glPO`1o0004001ZOol00`00Oomoo`04Ool00`00
Oomoo`1BOol008]oo`8003Ioo`0?001nX7j0OZ1nP7jPOX1nX7j0OZ1nP000O`1o87l000@006moo`03
001oogoo00=oo`03001oogoo059oo`00SGoo00<007ooOol0=7oo00<007jPOX000Wj000AnX7j0OX1n
P0D007Aoo`03001oogoo00=oo`03001oogoo055oo`00SWoo00<007ooOol0=7oo00@007jPOX1nX0@0
07Uoo`03001oogoo00=oo`03001oogoo055oo`00Sgoo00<007ooOol0=7oo0`00OWoo00<007ooOol0
0Woo00<007ooOol0DGoo002@Ool2000dOol00`00Oomoo`1oOol01@00Oomoogoo0000Dgoo002BOol0
0`00Oomoo`0aOol00`00Oomoo`20Ool01000Oomoo`00Dgoo002COol00`00Oomoo`0`Ool00`00Oomo
o`20Ool01000Oomoo`00Dgoo002DOol00`00Oomoo`0_Ool00`00Oomoo`21Ool00`00Ool0001COol0
09Eoo`8002moo`03001oogoo089oo`03001oo`00059oo`00Ugoo00<007ooOol0;7oo00<007ooOol0
Pgoo0P00DWoo002HOol00`00Oomoo`0[Ool00`00Oomoo`23Ool2001BOol009Uoo`03001oogoo02Yo
o`03001oogoo08=oo`80059oo`00VWoo0P00:Woo00<007ooOol0Ogoo1000E7oo002LOol00`00Oomo
o`0WOol00`00Oomoo`1kOol4001HOol009eoo`03001oogoo02Ioo`03001oogoo07Moo`@005aoo`00
WWoo00<007ooOol09Goo00<007ooOol0Lgoo1000H7oo002OOol2000UOol00`00Oomoo`1_Ool4001T
Ool00:5oo`03001oogoo029oo`03001oogoo06]oo`@006Qoo`00XWoo00<007ooOol08Goo00<007oo
Ool0Igoo1000K7oo002SOol00`00Oomoo`0POol00`00Oomoo`1SOol4001`Ool00:Aoo`80021oo`03
001oogoo061oo`<007Aoo`00YWoo00<007ooOol07Goo00<007ooOol0G7oo1000Mgoo002WOol00`00
Oomoo`0KOol00`00Oomoo`1IOol4001kOol00:Qoo`03001oogoo01Yoo`03001oogoo05Eoo`@007mo
o`00ZGoo0P006Woo00<007ooOol0DGoo1000Pgoo002[Ool00`00Oomoo`0GOol00`00Oomoo`1=Ool4
0027Ool00:aoo`03001oogoo01Ioo`03001oogoo04Uoo`@008]oo`00[Goo00<007ooOol05Goo00<0
07ooOol0AGoo1000Sgoo002^Ool2000EOol00`00Oomoo`12Ool3002COol00;1oo`03001oogoo019o
o`03001oogoo03ioo`@009Ioo`00/Goo00<007ooOol04Goo00<007ooOol0>Woo1000VWoo002bOol0
0`00Oomoo`0@Ool00`00Oomoo`0fOol4002NOol00;=oo`80011oo`03001oogoo039oo`@00:9oo`00
]Goo00<007ooOol03Goo00<007ooOol0;Woo1000YWoo002fOol00`00Oomoo`0<Ool00`00Oomoo`0Z
Ool4002ZOol00;Moo`03001oogoo00]oo`03001oogoo02Ioo`@00:ioo`00^7oo0P002goo00<007oo
Ool08Woo1000/Woo002jOol00`00Oomoo`08Ool00`00Oomoo`0OOol3002fOol00;]oo`03001oogoo
00Moo`03001oogoo01]oo`@00;Uoo`00_7oo00<007ooOol01Woo00<007ooOol05goo1000_Goo002m
Ool20006Ool00`00Oomoo`0COol40031Ool00;moo`03001oogoo00=oo`03001oogoo00moo`@00<Eo
o`00`7oo00<007ooOol00Woo00<007ooOol02goo1000bGoo0031Ool01@00Oomoogoo00002Goo1000
cGoo0032Ool200000goo001oo`04Ool4003AOol00<Aoo`800003Ool0000000800=Eoo`00aGoo0P00
fGoo0000\
\>"],
  ImageRangeCache->{{{0, 415.25}, {197.25, 0}} -> {-0.451648, 0.00690541, \
0.00526311, 0.00526311}}]
}, Open  ]],

Cell[TextData[{
  "Superimposing both surfaces demonstrates that the two functions have the \
common point ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\((x\_0\),
            "TraditionalForm"], ",", \(y\_0\)}], TraditionalForm]]],
  ")=(\[Pi]/2, 0)."
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[pl1, pl2, 
      PlotRange \[Rule] {{\(-2\), 2}, {\(-2\), 2}, {\(-1\), 1}}, 
      ViewPoint \[Rule] {3.130, \(-1.044\), 0.751}, Boxed \[Rule] False]\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53411 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0922957 1.0923 -0.233922 1.0923 [
[.66323 .54776 -5.89295 0 ]
[.66323 .54776 6.10705 9 ]
[.73187 .52455 -5.85757 0 ]
[.73187 .52455 6.14243 9 ]
[.8096 .49827 -2.90867 0 ]
[.8096 .49827 3.09133 9 ]
[.89835 .46826 -2.88559 0 ]
[.89835 .46826 3.11441 9 ]
[1.00064 .43367 -2.85884 0 ]
[1.00064 .43367 3.14116 9 ]
[.81168 .56651 -4.84778 0 ]
[.81168 .56651 5.15222 12.875 ]
[.15994 -0.01365 -5.84217 -9 ]
[.15994 -0.01365 6.15783 0 ]
[.3824 .01059 -5.96172 -9 ]
[.3824 .01059 6.03828 0 ]
[.5933 .03357 -3.03728 -9 ]
[.5933 .03357 2.96272 0 ]
[.79351 .0554 -3.09063 -9 ]
[.79351 .0554 2.90937 0 ]
[.98382 .07614 -3.14116 -9 ]
[.98382 .07614 2.85884 0 ]
[.59245 -0.03469 -5.06214 -12.875 ]
[.59245 -0.03469 4.93786 0 ]
[.99803 .09126 0 -4.01021 ]
[.99803 .09126 12 4.98979 ]
[1.00185 .1719 0 -4.05835 ]
[1.00185 .1719 24 4.94165 ]
[1.00572 .25371 0 -4.10724 ]
[1.00572 .25371 6 4.89276 ]
[1.00964 .33671 0 -4.15688 ]
[1.00964 .33671 18 4.84312 ]
[1.01362 .42092 0 -4.20731 ]
[1.01362 .42092 6 4.79269 ]
[1.07373 .25965 0 -5.87563 ]
[1.07373 .25965 10 6.99937 ]
[ 0 0 0 0 ]
[ 1 .53411 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.66298 .53411 m
1 .42004 L
s
.66298 .53411 m
.66286 .52729 L
s
[(-2)] .66323 .54776 -0.01784 -1 Mshowa
.73155 .5109 m
.73138 .50408 L
s
[(-1)] .73187 .52455 -0.02374 -1 Mshowa
.80918 .48462 m
.80898 .4778 L
s
[(0)] .8096 .49827 -0.03044 -1 Mshowa
.89783 .45462 m
.89757 .4478 L
s
[(1)] .89835 .46826 -0.03814 -1 Mshowa
1 .42004 m
.99968 .41322 L
s
[(2)] 1.00064 .43367 -0.04705 -1 Mshowa
.125 Mabswid
.67605 .52969 m
.67597 .52559 L
s
.68942 .52516 m
.68934 .52107 L
s
.70312 .52052 m
.70304 .51643 L
s
.71716 .51577 m
.71707 .51168 L
s
.74629 .50591 m
.74619 .50182 L
s
.76141 .50079 m
.76131 .4967 L
s
.77693 .49554 m
.77681 .49145 L
s
.79285 .49015 m
.79273 .48606 L
s
.82596 .47894 m
.82583 .47485 L
s
.8432 .47311 m
.84306 .46902 L
s
.86091 .46712 m
.86076 .46302 L
s
.87911 .46096 m
.87896 .45686 L
s
.91709 .4481 m
.91693 .44401 L
s
.93691 .44139 m
.93674 .4373 L
s
.95732 .43448 m
.95714 .43039 L
s
.97834 .42737 m
.97815 .42328 L
s
gsave
.81168 .56651 -65.8478 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.15958 0 m
.98446 .08978 L
s
.15958 0 m
.1594 .00682 L
s
[(-2)] .15994 -0.01365 -0.0263 1 Mshowa
.38232 .02424 m
.38227 .03107 L
s
[(-1)] .3824 .01059 -0.00638 1 Mshowa
.59347 .04723 m
.59356 .05405 L
s
[(0)] .5933 .03357 .01243 1 Mshowa
.79392 .06904 m
.79413 .07587 L
s
[(1)] .79351 .0554 .03021 1 Mshowa
.98446 .08978 m
.98478 .0966 L
s
[(2)] .98382 .07614 .04705 1 Mshowa
.125 Mabswid
.2051 .00495 m
.20501 .00905 L
s
.25012 .00986 m
.25005 .01395 L
s
.29466 .0147 m
.2946 .0188 L
s
.33872 .0195 m
.33868 .02359 L
s
.42544 .02894 m
.42543 .03303 L
s
.46812 .03358 m
.46812 .03768 L
s
.51034 .03818 m
.51036 .04227 L
s
.55212 .04273 m
.55216 .04682 L
s
.63439 .05168 m
.63446 .05577 L
s
.67489 .05609 m
.67497 .06018 L
s
.71497 .06045 m
.71507 .06455 L
s
.75465 .06477 m
.75476 .06886 L
s
.8328 .07327 m
.83294 .07737 L
s
.87128 .07746 m
.87144 .08156 L
s
.90939 .08161 m
.90955 .0857 L
s
.94711 .08572 m
.94729 .08981 L
s
gsave
.59245 -0.03469 -66.0621 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.98446 .08978 m
1 .42004 L
s
.98446 .08978 m
.97767 .08904 L
s
[(-1)] .99803 .09126 -1 -0.10884 Mshowa
.98826 .17057 m
.98147 .1699 L
s
[(-0.5)] 1.00185 .1719 -1 -0.09814 Mshowa
.99212 .25253 m
.98532 .25193 L
s
[(0)] 1.00572 .25371 -1 -0.08728 Mshowa
.99603 .33567 m
.98922 .33515 L
s
[(0.5)] 1.00964 .33671 -1 -0.07625 Mshowa
1 .42004 m
.99319 .41959 L
s
[(1)] 1.01362 .42092 -1 -0.06504 Mshowa
.125 Mabswid
.98522 .10585 m
.98114 .10541 L
s
.98597 .12196 m
.9819 .12153 L
s
.98674 .13812 m
.98266 .1377 L
s
.9875 .15432 m
.98342 .15391 L
s
.98903 .18687 m
.98495 .18648 L
s
.9898 .20321 m
.98572 .20283 L
s
.99057 .2196 m
.98649 .21923 L
s
.99134 .23604 m
.98726 .23567 L
s
.9929 .26906 m
.98881 .26871 L
s
.99368 .28564 m
.98959 .2853 L
s
.99446 .30227 m
.99038 .30194 L
s
.99524 .31895 m
.99116 .31863 L
s
.99682 .35245 m
.99273 .35214 L
s
.99761 .36927 m
.99353 .36898 L
s
.99841 .38614 m
.99432 .38586 L
s
.9992 .40306 m
.99511 .40279 L
s
gsave
1.07373 .25965 -61 -9.87563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .53411 L
0 .53411 L
closepath
clip
newpath
.5 Mabswid
.66478 .44904 m .66148 .44984 L p .64292 .42438 L .309 .562 .926 r
F P
0 g
s
.66148 .44984 m .62997 .42789 L .64292 .42438 L p .309 .562 .926 r
F P
0 g
s
.64292 .42438 m .62997 .42789 L .60276 .40419 L p .423 .58 .904 r
F P
0 g
s
.64292 .42438 m .67485 .44968 L .66478 .44904 L p .309 .562 .926 r
F P
0 g
s
.57246 .36295 m .64292 .42438 L p .60276 .40419 L .423 .58 .904 r
F P
0 g
s
.60276 .40419 m .56036 .37171 L .57246 .36295 L p .423 .58 .904 r
F P
0 g
s
.57246 .36295 m .56036 .37171 L .53294 .35 L p .503 .614 .895 r
F P
0 g
s
.50147 .30665 m .57246 .36295 L p .53294 .35 L .503 .614 .895 r
F P
0 g
s
.53294 .35 m .49016 .32018 L .50147 .30665 L p .503 .614 .895 r
F P
0 g
s
.50147 .30665 m .49016 .32018 L .4625 .30439 L p .573 .667 .902 r
F P
0 g
s
.68699 .445 m .67485 .44968 L p .66486 .41516 L .36 .554 .907 r
F P
0 g
s
.67485 .44968 m .64292 .42438 L .66486 .41516 L p .36 .554 .907 r
F P
0 g
s
.42981 .26564 m .50147 .30665 L p .4625 .30439 L .573 .667 .902 r
F P
0 g
s
.4625 .30439 m .41926 .28253 L .42981 .26564 L p .573 .667 .902 r
F P
0 g
s
.59304 .35132 m .66486 .41516 L .64292 .42438 L p .37 .54 .892 r
F P
0 g
s
.64292 .42438 m .57246 .36295 L .59304 .35132 L p .37 .54 .892 r
F P
0 g
s
.42981 .26564 m .41926 .28253 L .39122 .27543 L p .64 .742 .923 r
F P
0 g
s
.52069 .29283 m .59304 .35132 L .57246 .36295 L p .392 .565 .904 r
F P
0 g
s
.57246 .36295 m .50147 .30665 L .52069 .29283 L p .392 .565 .904 r
F P
0 g
s
.35712 .24708 m .42981 .26564 L p .39122 .27543 L .64 .742 .923 r
F P
0 g
s
.39122 .27543 m .3473 .26532 L .35712 .24708 L p .64 .742 .923 r
F P
0 g
s
.44768 .2502 m .52069 .29283 L .50147 .30665 L p .434 .634 .939 r
F P
0 g
s
.50147 .30665 m .42981 .26564 L .44768 .2502 L p .434 .634 .939 r
F P
0 g
s
.66486 .41516 m .69739 .44145 L .68699 .445 L p .36 .554 .907 r
F P
0 g
s
.35712 .24708 m .3473 .26532 L .3187 .26803 L p .703 .84 .948 r
F P
0 g
s
.37365 .23088 m .44768 .2502 L .42981 .26564 L p .5 .751 .985 r
F P
0 g
s
.42981 .26564 m .35712 .24708 L .37365 .23088 L p .5 .751 .985 r
F P
0 g
s
.28288 .25395 m .35712 .24708 L p .3187 .26803 L .703 .84 .948 r
F P
0 g
s
.3187 .26803 m .27383 .27127 L .28288 .25395 L p .703 .84 .948 r
F P
0 g
s
.70999 .43476 m .69739 .44145 L p .68763 .40218 L .404 .565 .9 r
F P
0 g
s
.69739 .44145 m .66486 .41516 L .68763 .40218 L p .404 .565 .9 r
F P
0 g
s
.61451 .3426 m .68763 .40218 L .66486 .41516 L p .321 .518 .893 r
F P
0 g
s
.66486 .41516 m .59304 .35132 L .61451 .3426 L p .321 .518 .893 r
F P
0 g
s
.28288 .25395 m .27383 .27127 L .24449 .28309 L p .731 .942 .953 r
F P
0 g
s
.29805 .23798 m .37365 .23088 L .35712 .24708 L p .57 .884 .991 r
F P
0 g
s
.35712 .24708 m .28288 .25395 L .29805 .23798 L p .57 .884 .991 r
F P
0 g
s
.54077 .2879 m .61451 .3426 L .59304 .35132 L p .232 .502 .903 r
F P
0 g
s
.59304 .35132 m .52069 .29283 L .54077 .2879 L p .232 .502 .903 r
F P
0 g
s
.20661 .28449 m .28288 .25395 L p .24449 .28309 L .731 .942 .953 r
F P
0 g
s
.24449 .28309 m .19839 .29877 L .20661 .28449 L p .731 .942 .953 r
F P
0 g
s
.46631 .24784 m .54077 .2879 L .52069 .29283 L p .141 .528 .919 r
F P
0 g
s
.52069 .29283 m .44768 .2502 L .46631 .24784 L p .141 .528 .919 r
F P
0 g
s
.68763 .40218 m .72073 .42672 L .70999 .43476 L p .404 .565 .9 r
F P
0 g
s
.22035 .26968 m .29805 .23798 L .28288 .25395 L p .591 .947 .896 r
F P
0 g
s
.28288 .25395 m .20661 .28449 L .22035 .26968 L p .591 .947 .896 r
F P
0 g
s
.20661 .28449 m .19839 .29877 L .16818 .31722 L p .647 .969 .866 r
F P
0 g
s
.39078 .22934 m .46631 .24784 L .44768 .2502 L p .081 .597 .883 r
F P
0 g
s
.44768 .2502 m .37365 .23088 L .3867 .22971 L p .081 .597 .883 r
F P
0 g
s
.44768 .2502 m .3867 .22971 L .40094 .23306 L .081 .597 .883 r
F
.46631 .24784 m .48581 .25811 L p .51946 .27635 L 0 .242 .631 r
F P
0 g
s
.54077 .2879 m .51246 .27266 L p .51946 .27635 L 0 .242 .631 r
F P
0 g
s
.51246 .27266 m .46631 .24784 L p .51946 .27635 L 0 .242 .631 r
F P
0 g
s
.56182 .29154 m .63695 .33664 L .61451 .3426 L p 0 .407 .853 r
F P
0 g
s
.61451 .3426 m .54077 .2879 L .56182 .29154 L p 0 .407 .853 r
F P
0 g
s
.48581 .25811 m .56182 .29154 L .54077 .2879 L p 0 .242 .631 r
F P
0 g
s
.56182 .29154 m .58393 .30242 L p .63296 .33406 L 0 .265 .683 r
F P
0 g
s
.63695 .33664 m .63356 .3346 L p .63296 .33406 L 0 .265 .683 r
F P
0 g
s
.63356 .3346 m .56182 .29154 L p .63296 .33406 L 0 .265 .683 r
F P
0 g
s
.58393 .30242 m .66043 .33292 L .63695 .33664 L p 0 .265 .683 r
F P
0 g
s
.66043 .33292 m .58393 .30242 L .60719 .31828 L p .469 0 0 r
F P
0 g
s
.68502 .33061 m .66043 .33292 L p .61903 .32153 L .469 0 0 r
F P
0 g
s
.60719 .31828 m .61717 .31986 L p .61903 .32153 L .469 0 0 r
F P
0 g
s
.61717 .31986 m .68502 .33061 L p .61903 .32153 L .469 0 0 r
F P
0 g
s
.58393 .30242 m .56182 .29154 L p .53842 .28632 L .612 .045 0 r
F P
0 g
s
.5063 .27915 m .54929 .29203 L p .53842 .28632 L .612 .045 0 r
F P
0 g
s
.54929 .29203 m .58393 .30242 L p .53842 .28632 L .612 .045 0 r
F P
0 g
s
.40864 .24196 m .48581 .25811 L .46846 .24896 L p .454 0 0 r
F P
0 g
s
.46846 .24896 m .46631 .24784 L p .46165 .24736 L .454 0 0 r
F P
0 g
s
.46165 .24736 m .40864 .24196 L .46846 .24896 L .454 0 0 r
F
.3867 .22971 m .39078 .22934 L p .40094 .23306 L .081 .597 .883 r
F P
0 g
s
.12795 .33239 m .20661 .28449 L p .16818 .31722 L .647 .969 .866 r
F P
0 g
s
.16818 .31722 m .12069 .34202 L .12795 .33239 L p .647 .969 .866 r
F P
0 g
s
.7338 .41804 m .72073 .42672 L p .71128 .38553 L .446 .593 .904 r
F P
0 g
s
.72073 .42672 m .68763 .40218 L .71128 .38553 L p .446 .593 .904 r
F P
0 g
s
.63695 .33664 m .71128 .38553 L .68763 .40218 L p .274 .518 .905 r
F P
0 g
s
.68763 .40218 m .61451 .3426 L .63695 .33664 L p .274 .518 .905 r
F P
0 g
s
.31368 .2353 m .39078 .22934 L .37365 .23088 L p .12 .671 .751 r
F P
0 g
s
.37365 .23088 m .29805 .23798 L .31368 .2353 L p .12 .671 .751 r
F P
0 g
s
.14018 .31945 m .22035 .26968 L .20661 .28449 L p .56 .924 .76 r
F P
0 g
s
.20661 .28449 m .12795 .33239 L .14018 .31945 L p .56 .924 .76 r
F P
0 g
s
.12795 .33239 m .12069 .34202 L .08956 .36327 L p .399 .821 .645 r
F P
0 g
s
.71128 .38553 m .74488 .40568 L .7338 .41804 L p .446 .593 .904 r
F P
0 g
s
.04683 .3877 m .12795 .33239 L p .08956 .36327 L .399 .821 .645 r
F P
0 g
s
.08956 .36327 m .04066 .39195 L .04683 .3877 L p .399 .821 .645 r
F P
0 g
s
.2345 .26405 m .31368 .2353 L .29805 .23798 L p 0 0 0 r
F P
0 g
s
.29805 .23798 m .22035 .26968 L .2345 .26405 L p 0 0 0 r
F P
0 g
s
.46631 .24784 m .39078 .22934 L .40864 .24196 L p .454 0 0 r
F P
0 g
s
.75845 .39525 m .74488 .40568 L p .73586 .36568 L .489 .638 .921 r
F P
0 g
s
.74488 .40568 m .71128 .38553 L .73586 .36568 L p .489 .638 .921 r
F P
0 g
s
.05745 .37697 m .14018 .31945 L .12795 .33239 L p .52 .889 .686 r
F P
0 g
s
.12795 .33239 m .04683 .3877 L .05745 .37697 L p .52 .889 .686 r
F P
0 g
s
.04066 .39195 m .00873 .41143 L p .00912 .4107 L 0 0 0 r
F P
0 g
s
.00912 .4107 m .04683 .3877 L .04066 .39195 L p 0 0 0 r
F P
0 g
s
.66043 .33292 m .73586 .36568 L .71128 .38553 L p .226 .543 .927 r
F P
0 g
s
.71128 .38553 m .63695 .33664 L .66043 .33292 L p .226 .543 .927 r
F P
0 g
s
.32989 .24547 m .40864 .24196 L .39078 .22934 L p .355 0 0 r
F P
0 g
s
.39078 .22934 m .31368 .2353 L .32989 .24547 L p .355 0 0 r
F P
0 g
s
.22035 .26968 m .16195 .30594 L p .15286 .30951 L .447 .85 .663 r
F P
0 g
s
.16195 .30594 m .14018 .31945 L .15286 .30951 L p .447 .85 .663 r
F P
0 g
s
.08049 .34323 m .14329 .31328 L p .15286 .30951 L .687 .98 .837 r
F P
0 g
s
.15286 .30951 m .2345 .26405 L .22035 .26968 L p .447 .85 .663 r
F P
0 g
s
.2345 .26405 m .16154 .30468 L p .16603 .30243 L 0 0 0 r
F P
0 g
s
.16154 .30468 m .15286 .30951 L .16603 .30243 L p 0 0 0 r
F P
0 g
s
.16603 .30243 m .24913 .26726 L .2345 .26405 L p 0 0 0 r
F P
0 g
s
.09293 .32078 m .17074 .30007 L p .16603 .30243 L .713 .978 .913 r
F P
0 g
s
.24913 .26726 m .16993 .30078 L p .17976 .29767 L 0 0 0 r
F P
0 g
s
.16993 .30078 m .16603 .30243 L .17976 .29767 L p 0 0 0 r
F P
0 g
s
.17976 .29767 m .26435 .27797 L .24913 .26726 L p 0 0 0 r
F P
0 g
s
.10601 .29562 m .19007 .29441 L p .17976 .29767 L .69 .935 .966 r
F P
0 g
s
.26435 .27797 m .18064 .29747 L p .19412 .29435 L 0 0 0 r
F P
0 g
s
.18064 .29747 m .17976 .29767 L .19412 .29435 L p 0 0 0 r
F P
0 g
s
.19412 .29435 m .28028 .29386 L .26435 .27797 L p 0 0 0 r
F P
0 g
s
.1197 .26883 m .20828 .29107 L p .19412 .29435 L .625 .857 .986 r
F P
0 g
s
.20828 .29107 m .20919 .2913 L .19412 .29435 L p .625 .857 .986 r
F P
0 g
s
.19007 .29441 m .19412 .29435 L .17976 .29767 L p .69 .935 .966 r
F P
0 g
s
.17074 .30007 m .17976 .29767 L .16603 .30243 L p .713 .978 .913 r
F P
0 g
s
.14329 .31328 m .16603 .30243 L .15286 .30951 L p .687 .98 .837 r
F P
0 g
s
.00873 .41143 m .00343 .41421 L .00401 .41426 L p 0 0 0 r
F P
0 g
s
.00401 .41426 m .00912 .4107 L p .00873 .41143 L 0 0 0 r
F P
0 g
s
.73586 .36568 m .76989 .37924 L .75845 .39525 L p .489 .638 .921 r
F P
0 g
s
.56182 .29154 m .48581 .25811 L .5063 .27915 L p .612 .045 0 r
F P
0 g
s
.01355 .40655 m .01896 .4009 L p .04683 .3877 L .484 .877 .701 r
F P
0 g
s
.01896 .4009 m .05745 .37697 L .04683 .3877 L p .484 .877 .701 r
F P
0 g
s
.04683 .3877 m .00912 .4107 L .01355 .40655 L p .484 .877 .701 r
F P
0 g
s
.24913 .26726 m .32989 .24547 L .31368 .2353 L p .087 0 0 r
F P
0 g
s
.31368 .2353 m .2345 .26405 L .24913 .26726 L p .087 0 0 r
F P
0 g
s
.78401 .36745 m .76989 .37924 L p .76145 .34342 L .536 .704 .948 r
F P
0 g
s
.76989 .37924 m .73586 .36568 L .76145 .34342 L p .536 .704 .948 r
F P
0 g
s
.42736 .26671 m .5063 .27915 L .48581 .25811 L p .639 .128 .015 r
F P
0 g
s
.48581 .25811 m .40864 .24196 L .42736 .26671 L p .639 .128 .015 r
F P
0 g
s
.06866 .36211 m .15286 .30951 L .14018 .31945 L p .619 .946 .755 r
F P
0 g
s
.14018 .31945 m .05745 .37697 L .06866 .36211 L p .619 .946 .755 r
F P
0 g
s
.68502 .33061 m .76145 .34342 L .73586 .36568 L p .175 .593 .939 r
F P
0 g
s
.73586 .36568 m .66043 .33292 L .68502 .33061 L p .175 .593 .939 r
F P
0 g
s
.3468 .2666 m .42736 .26671 L .40864 .24196 L p .545 .051 .034 r
F P
0 g
s
.40864 .24196 m .32989 .24547 L .3468 .2666 L p .545 .051 .034 r
F P
0 g
s
.76145 .34342 m .79585 .34887 L .78401 .36745 L p .536 .704 .948 r
F P
0 g
s
.02376 .39191 m .02949 .38397 L p .05745 .37697 L .725 .989 .861 r
F P
0 g
s
.02949 .38397 m .06866 .36211 L .05745 .37697 L p .725 .989 .861 r
F P
0 g
s
.05745 .37697 m .01896 .4009 L .02376 .39191 L p .725 .989 .861 r
F P
0 g
s
.52789 .30776 m .60719 .31828 L .58393 .30242 L p .675 .165 .022 r
F P
0 g
s
.58393 .30242 m .5063 .27915 L .52789 .30776 L p .675 .165 .022 r
F P
0 g
s
.81054 .33627 m .79585 .34887 L p .78811 .3198 L .583 .792 .979 r
F P
0 g
s
.79585 .34887 m .76145 .34342 L .78811 .3198 L p .583 .792 .979 r
F P
0 g
s
.26435 .27797 m .3468 .2666 L .32989 .24547 L p .307 0 0 r
F P
0 g
s
.32989 .24547 m .24913 .26726 L .26435 .27797 L p .307 0 0 r
F P
0 g
s
.15286 .30951 m .06866 .36211 L .08049 .34323 L p .687 .98 .837 r
F P
0 g
s
.71078 .3286 m .78811 .3198 L .76145 .34342 L p .119 .643 .88 r
F P
0 g
s
.76145 .34342 m .68665 .33088 L p .71078 .3286 L .119 .643 .88 r
F P
0 g
s
.65735 .35251 m .73609 .32621 L p .71078 .3286 L .446 0 0 r
F P
0 g
s
.73609 .32621 m .73776 .32565 L .71078 .3286 L p .446 0 0 r
F P
0 g
s
.68665 .33088 m .68502 .33061 L .71078 .3286 L p .119 .643 .88 r
F P
0 g
s
.44705 .30002 m .52789 .30776 L .5063 .27915 L p .679 .221 .156 r
F P
0 g
s
.5063 .27915 m .42736 .26671 L .44705 .30002 L p .679 .221 .156 r
F P
0 g
s
.78811 .3198 m .82285 .3165 L .81054 .33627 L p .583 .792 .979 r
F P
0 g
s
.63165 .33613 m .71078 .3286 L .68502 .33061 L p .506 0 0 r
F P
0 g
s
.68502 .33061 m .60719 .31828 L .63165 .33613 L p .506 0 0 r
F P
0 g
s
.36455 .29546 m .44705 .30002 L .42736 .26671 L p .616 .154 .133 r
F P
0 g
s
.42736 .26671 m .3468 .2666 L .36455 .29546 L p .616 .154 .133 r
F P
0 g
s
.03466 .37032 m .04071 .36009 L p .06866 .36211 L .804 .97 .907 r
F P
0 g
s
.04071 .36009 m .08049 .34323 L .06866 .36211 L p .804 .97 .907 r
F P
0 g
s
.06866 .36211 m .02949 .38397 L .03466 .37032 L p .804 .97 .907 r
F P
0 g
s
.83818 .30371 m .82285 .3165 L p .81598 .29597 L .615 .89 .989 r
F P
0 g
s
.82285 .3165 m .78811 .3198 L .81598 .29597 L p .615 .89 .989 r
F P
0 g
s
.55066 .33964 m .63165 .33613 L .60719 .31828 L p .657 .184 .117 r
F P
0 g
s
.60719 .31828 m .52789 .30776 L .55066 .33964 L p .657 .184 .117 r
F P
0 g
s
.78811 .3198 m .71562 .32805 L p .73776 .32565 L 0 0 0 r
F P
0 g
s
.71562 .32805 m .71078 .3286 L .73776 .32565 L p 0 0 0 r
F P
0 g
s
.68432 .36384 m .76104 .32313 L p .73776 .32565 L .327 0 0 r
F P
0 g
s
.73776 .32565 m .81598 .29597 L .78811 .3198 L p 0 0 0 r
F P
0 g
s
.76104 .32313 m .76603 .32048 L .73776 .32565 L p .327 0 0 r
F P
0 g
s
.28028 .29386 m .36455 .29546 L .3468 .2666 L p .429 0 0 r
F P
0 g
s
.3468 .2666 m .26435 .27797 L .28028 .29386 L p .429 0 0 r
F P
0 g
s
.16603 .30243 m .08049 .34323 L .09293 .32078 L p .713 .978 .913 r
F P
0 g
s
.81598 .29597 m .85104 .28429 L .83818 .30371 L p .615 .89 .989 r
F P
0 g
s
.46784 .33711 m .55066 .33964 L .52789 .30776 L p .676 .235 .196 r
F P
0 g
s
.52789 .30776 m .44705 .30002 L .46784 .33711 L p .676 .235 .196 r
F P
0 g
s
.71078 .3286 m .63165 .33613 L .65735 .35251 L p .446 0 0 r
F P
0 g
s
.04623 .34247 m .05261 .33019 L p .08049 .34323 L .805 .914 .913 r
F P
0 g
s
.05261 .33019 m .09293 .32078 L .08049 .34323 L p .805 .914 .913 r
F P
0 g
s
.08049 .34323 m .04071 .36009 L .04623 .34247 L p .805 .914 .913 r
F P
0 g
s
.86708 .27191 m .85104 .28429 L p .84517 .27311 L .585 .941 .918 r
F P
0 g
s
.85104 .28429 m .81598 .29597 L .84517 .27311 L p .585 .941 .918 r
F P
0 g
s
.38327 .32767 m .46784 .33711 L .44705 .30002 L p .641 .18 .143 r
F P
0 g
s
.44705 .30002 m .36455 .29546 L .38327 .32767 L p .641 .18 .143 r
F P
0 g
s
.81598 .29597 m .73776 .32565 L .76603 .32048 L p 0 0 0 r
F P
0 g
s
.76603 .32048 m .84517 .27311 L .81598 .29597 L p 0 0 0 r
F P
0 g
s
.57466 .36976 m .65735 .35251 L .63165 .33613 L p .599 .137 .127 r
F P
0 g
s
.63165 .33613 m .55066 .33964 L .57466 .36976 L p .599 .137 .127 r
F P
0 g
s
.17976 .29767 m .09293 .32078 L .10601 .29562 L p .69 .935 .966 r
F P
0 g
s
.29703 .31181 m .38327 .32767 L .36455 .29546 L p .487 0 0 r
F P
0 g
s
.36455 .29546 m .28028 .29386 L .29703 .31181 L p .487 0 0 r
F P
0 g
s
.84517 .27311 m .88059 .25435 L .86708 .27191 L p .585 .941 .918 r
F P
0 g
s
.48981 .37236 m .57466 .36976 L .55066 .33964 L p .644 .193 .166 r
F P
0 g
s
.55066 .33964 m .46784 .33711 L .48981 .37236 L p .644 .193 .166 r
F P
0 g
s
.73776 .32565 m .65735 .35251 L .68432 .36384 L p .327 0 0 r
F P
0 g
s
.05843 .30974 m .06515 .29585 L p .09293 .32078 L .774 .855 .911 r
F P
0 g
s
.06515 .29585 m .10601 .29562 L .09293 .32078 L p .774 .855 .911 r
F P
0 g
s
.09293 .32078 m .05261 .33019 L .05843 .30974 L p .774 .855 .911 r
F P
0 g
s
.89741 .24296 m .88059 .25435 L p .87583 .25224 L .462 .874 .73 r
F P
0 g
s
.88059 .25435 m .84517 .27311 L .87583 .25224 L p .462 .874 .73 r
F P
0 g
s
.19412 .29435 m .20919 .2913 L p .2726 .29358 L .111 .662 .797 r
F P
0 g
s
.28028 .29386 m .27513 .29389 L p .2726 .29358 L .111 .662 .797 r
F P
0 g
s
.27513 .29389 m .19412 .29435 L p .2726 .29358 L .111 .662 .797 r
F P
0 g
s
.20919 .2913 m .29703 .31181 L .28028 .29386 L p .111 .662 .797 r
F P
0 g
s
.20919 .2913 m .22505 .2872 L p .27802 .30531 L .097 .614 .885 r
F P
0 g
s
.29703 .31181 m .28256 .30844 L p .27802 .30531 L .097 .614 .885 r
F P
0 g
s
.28256 .30844 m .20919 .2913 L p .27802 .30531 L .097 .614 .885 r
F P
0 g
s
.31474 .32825 m .29703 .31181 L p .22801 .28821 L .097 .614 .885 r
F P
0 g
s
.31474 .32825 m .40307 .35811 L .38327 .32767 L p .48 0 0 r
F P
0 g
s
.38327 .32767 m .29703 .31181 L .31474 .32825 L p .48 0 0 r
F P
0 g
s
.31474 .32825 m .33351 .33942 L p .35931 .34636 L .363 0 0 r
F P
0 g
s
.40307 .35811 m .34213 .33751 L p .35931 .34636 L .363 0 0 r
F P
0 g
s
.34213 .33751 m .31474 .32825 L p .35931 .34636 L .363 0 0 r
F P
0 g
s
.42404 .38143 m .51301 .39989 L .48981 .37236 L p .562 .014 0 r
F P
0 g
s
.48981 .37236 m .40307 .35811 L .42404 .38143 L p .562 .014 0 r
F P
0 g
s
.33351 .33942 m .42404 .38143 L .40307 .35811 L p .363 0 0 r
F P
0 g
s
.51301 .39989 m .42404 .38143 L .44483 .39195 L p .328 0 0 r
F P
0 g
s
.44483 .39195 m .44623 .39267 L p .44968 .39304 L .328 0 0 r
F P
0 g
s
.51301 .39989 m .44483 .39195 L .44968 .39304 L .328 0 0 r
F
.51301 .39989 m .59991 .3929 L .57466 .36976 L p .567 .077 .052 r
F P
0 g
s
.57466 .36976 m .48981 .37236 L .51301 .39989 L p .567 .077 .052 r
F P
0 g
s
.53745 .41422 m .6264 .40419 L .59991 .3929 L p .371 0 0 r
F P
0 g
s
.59991 .3929 m .51301 .39989 L .53745 .41422 L p .371 0 0 r
F P
0 g
s
.44623 .39267 m .53745 .41422 L .51301 .39989 L p .328 0 0 r
F P
0 g
s
.53857 .40604 m .56716 .40478 L .55896 .39636 L p .547 .045 .015 r
F P
0 g
s
.55896 .39636 m .5306 .39731 L .53857 .40604 L p .547 .045 .015 r
F P
0 g
s
.50973 .40113 m .53857 .40604 L .5306 .39731 L p .576 .034 0 r
F P
0 g
s
.5306 .39731 m .502 .39269 L .50973 .40113 L p .576 .034 0 r
F P
0 g
s
.48068 .39014 m .50973 .40113 L .502 .39269 L p .568 0 0 r
F P
0 g
s
.54666 .41142 m .57364 .41003 L p .56716 .40478 L .41 0 0 r
F P
0 g
s
.6264 .40419 m .71254 .36685 L .68432 .36384 L p .299 0 0 r
F P
0 g
s
.68432 .36384 m .59991 .3929 L .6264 .40419 L p .299 0 0 r
F P
0 g
s
.71254 .36685 m .6264 .40419 L .6541 .39981 L p 0 0 0 r
F P
0 g
s
.62132 .40083 m .6126 .40321 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.6541 .39981 m .6264 .40419 L p .59861 .40719 L .088 .646 .711 r
F P
0 g
s
.60019 .40682 m .6541 .39981 L .59861 .40719 L .088 .646 .711 r
F
.60363 .40603 m .62132 .40083 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.6126 .40321 m .60397 .40205 L p .59145 .40796 L .151 0 0 r
F P
0 g
s
.59145 .40796 m .59146 .40796 L .6126 .40321 L .151 0 0 r
F
.59801 .40725 m .60019 .40682 L .59861 .40719 L .088 .646 .711 r
F
.59135 .40797 m .59977 .40688 L .59801 .40725 L F
.59977 .40688 m .60019 .40682 L .59801 .40725 L F
.6126 .40321 m .60043 .40674 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.59145 .40796 m .6541 .39981 L .59135 .40797 L .088 .646 .711 r
F
.62456 .40345 m .62938 .40286 L p .59145 .40796 L F P
0 g
s
.62938 .40286 m .6541 .39981 L p .59145 .40796 L .088 .646 .711 r
F P
0 g
s
.6264 .40419 m .55392 .41236 L p .55884 .41179 L .088 .646 .711 r
F P
0 g
s
.57067 .41038 m .57233 .41019 L .53984 .41392 L .088 .646 .711 r
F
.57233 .41019 m .6264 .40419 L .55446 .41228 L F
.57233 .41019 m .55446 .41228 L .53984 .41392 L F
.60397 .40205 m .57615 .40975 L p .57761 .40958 L .151 0 0 r
F P
0 g
s
.57606 .40976 m .61204 .40574 L .57563 .40981 L .088 .646 .711 r
F
.59135 .40797 m .59617 .40745 L .57606 .40976 L F
.59617 .40745 m .61204 .40574 L .57606 .40976 L F
.59545 .39755 m .56716 .40478 L .57532 .40984 L p .371 0 0 r
F P
0 g
s
.60397 .40205 m .57761 .40958 L .59145 .40796 L .151 0 0 r
F
.61204 .40574 m .6264 .40419 L .57233 .41019 L .088 .646 .711 r
F
.61204 .40574 m .57233 .41019 L .57563 .40981 L F
.57761 .40958 m .576 .41004 L .59135 .40797 L .151 0 0 r
F
.57761 .40958 m .59135 .40797 L .59145 .40796 L F
.57514 .40986 m .57233 .41019 L .57364 .41003 L .088 .646 .711 r
F
.57547 .40993 m .57364 .41003 L p .55486 .41315 L .158 0 0 r
F P
0 g
s
.57364 .41003 m .54666 .41142 L .55157 .41246 L p .158 0 0 r
F P
0 g
s
.57364 .41003 m .57233 .41019 L .55204 .41244 L .088 .646 .711 r
F
.55201 .41245 m .55204 .41244 L .54881 .4128 L F
.57364 .41003 m .55204 .41244 L .55201 .41245 L F
.56716 .40478 m .53857 .40604 L .54666 .41142 L p .41 0 0 r
F P
0 g
s
.54666 .41142 m .53857 .40604 L p .51861 .40629 L .42 0 0 r
F P
0 g
s
.52342 .40733 m .54666 .41142 L p .51861 .40629 L .42 0 0 r
F P
0 g
s
.48829 .39464 m .51485 .40521 L p .50973 .40113 L .38 0 0 r
F P
0 g
s
.51706 .40595 m .50973 .40113 L p .51485 .40521 L .38 0 0 r
F P
0 g
s
.53857 .40604 m .50973 .40113 L .51706 .40595 L p .42 0 0 r
F P
0 g
s
.53857 .40604 m .51706 .40595 L .51861 .40629 L .42 0 0 r
F
.50973 .40113 m .48068 .39014 L .48742 .39412 L p .38 0 0 r
F P
0 g
s
.48742 .39412 m .48829 .39464 L p .49019 .39521 L .38 0 0 r
F P
0 g
s
.50973 .40113 m .48742 .39412 L .49019 .39521 L .38 0 0 r
F
.49603 .39575 m .50674 .40015 L p .51118 .40288 L 0 .453 .799 r
F P
0 g
s
.54666 .41142 m .52342 .40733 L p .53929 .41018 L .138 0 0 r
F P
0 g
s
.48829 .39464 m .49603 .39575 L p .51346 .40428 L 0 .453 .799 r
F P
0 g
s
.52497 .40761 m .51571 .40567 L .51346 .40428 L .131 .634 .905 r
F
.52394 .40742 m .51571 .40567 L .52497 .40761 L F
.54193 .41366 m .51514 .40555 L .52521 .40769 L F
.51485 .40521 m .51758 .4063 L .51706 .40595 L p .38 0 0 r
F P
0 g
s
.51758 .4063 m .51485 .40521 L p .51346 .40428 L 0 .453 .799 r
F P
0 g
s
.51485 .40521 m .48829 .39464 L p .51346 .40428 L 0 .453 .799 r
F P
0 g
s
.51094 .4026 m .51346 .40428 L .51042 .40241 L .131 .634 .905 r
F
.52497 .40761 m .51346 .40428 L .51094 .4026 L F
.52521 .40769 m .52394 .40742 L .52497 .40761 L F
.52212 .40766 m .528 .41055 L .51514 .40555 L F
.55157 .41246 m .54874 .41281 L p .52451 .40744 L F P
0 g
s
.54874 .41281 m .54193 .41366 L p .52538 .40775 L .131 .634 .905 r
F P
0 g
s
.54874 .41281 m .52538 .40775 L .52451 .40744 L .131 .634 .905 r
F
.51758 .4063 m .52556 .40787 L p .53929 .41018 L .138 0 0 r
F P
0 g
s
.52342 .40733 m .51758 .4063 L p .53929 .41018 L .138 0 0 r
F P
0 g
s
.51706 .40595 m .51758 .4063 L p .51861 .40629 L .42 0 0 r
F P
0 g
s
.51758 .4063 m .52342 .40733 L p .51861 .40629 L .42 0 0 r
F P
0 g
s
.5145 .40479 m .51346 .40428 L .51907 .40659 L 0 .453 .799 r
F
.51346 .40428 m .49603 .39575 L .51118 .40288 L F
.51346 .40428 m .51118 .40288 L .51907 .40659 L F
.59545 .39755 m .57532 .40984 L .57568 .4098 L .371 0 0 r
F
.60397 .40205 m .59545 .39755 L p .57568 .4098 L F P
0 g
s
.57615 .40975 m .60397 .40205 L p .57568 .4098 L .371 0 0 r
F P
0 g
s
.57532 .40984 m .56716 .40478 L p .57364 .41003 L .41 0 0 r
F P
0 g
s
.56296 .41098 m .55157 .41246 L .51151 .40043 L .131 .634 .905 r
F
.56296 .41098 m .51151 .40043 L .51471 .40056 L F
.51541 .40059 m .51471 .40056 L .51536 .40058 L F
.56296 .41098 m .51471 .40056 L .51541 .40059 L F
.49603 .39575 m .50389 .39327 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.50674 .40015 m .49603 .39575 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.50389 .39327 m .52217 .40085 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.51536 .40058 m .51151 .40043 L .50309 .3979 L .131 .634 .905 r
F
.54666 .41142 m .53929 .41018 L .54909 .412 L .138 0 0 r
F
.55157 .41246 m .54666 .41142 L p .55109 .41247 L F P
0 g
s
.502 .39269 m .4732 .38255 L .48068 .39014 L p .568 0 0 r
F P
0 g
s
.45147 .3734 m .48068 .39014 L .4732 .38255 L p .5 0 0 r
F P
0 g
s
.45883 .37681 m .48829 .39464 L .48068 .39014 L p 0 .267 .673 r
F P
0 g
s
.4732 .38255 m .502 .39269 L .4944 .38135 L p .661 .134 0 r
F P
0 g
s
.4944 .38135 m .46584 .37225 L .4732 .38255 L p .661 .134 0 r
F P
0 g
s
.44423 .36723 m .4732 .38255 L .46584 .37225 L p .628 .065 0 r
F P
0 g
s
.4732 .38255 m .44423 .36723 L .45147 .3734 L p .5 0 0 r
F P
0 g
s
.46633 .3772 m .49603 .39575 L .48829 .39464 L p 0 .431 .848 r
F P
0 g
s
.48829 .39464 m .45883 .37681 L .46633 .3772 L p 0 .431 .848 r
F P
0 g
s
.55157 .41246 m .52451 .40744 L .46968 .38787 L .131 .634 .905 r
F
.52556 .40787 m .50674 .40015 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.53365 .40562 m .52556 .40787 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.54881 .4128 m .56276 .41106 L p .59135 .40797 L .088 .646 .711 r
F P
0 g
s
.56312 .41102 m .59135 .40797 L .56276 .41106 L .088 .646 .711 r
F
.5632 .41101 m .59135 .40797 L .56304 .41103 L F
.56321 .41101 m .56321 .41101 L .5632 .41101 L F
.56321 .41101 m .59135 .40797 L .5632 .41101 L F
.60043 .40674 m .6126 .40321 L p .59146 .40796 L .151 0 0 r
F P
0 g
s
.6126 .40321 m .64095 .38873 L .63213 .38826 L p .127 0 0 r
F P
0 g
s
.63213 .38826 m .60397 .40205 L .6126 .40321 L p .127 0 0 r
F P
0 g
s
.64095 .38873 m .6126 .40321 L .62132 .40083 L p 0 0 0 r
F P
0 g
s
.62132 .40083 m .60363 .40603 L p .60103 .40318 L .485 .9 .884 r
F P
0 g
s
.56321 .41101 m .60374 .40602 L .59135 .40797 L .088 .646 .711 r
F
.60374 .40602 m .60383 .40601 L .59135 .40797 L F
.56356 .41096 m .60388 .406 L p .56321 .41101 L F P
0 g
s
.59944 .40702 m .60043 .40674 L p .59144 .40796 L .151 0 0 r
F P
0 g
s
.59144 .40796 m .60043 .40674 L .59146 .40796 L .151 0 0 r
F
.60388 .406 m .62456 .40345 L p .60043 .40674 L .088 .646 .711 r
F P
0 g
s
.60388 .406 m .60043 .40674 L .59135 .40797 L .088 .646 .711 r
F
.58389 .41153 m .59241 .40932 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.60043 .40674 m .58389 .41153 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.59241 .40932 m .60363 .40603 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.58389 .41153 m .59944 .40702 L p .59144 .40796 L .151 0 0 r
F P
0 g
s
.60363 .40603 m .59241 .40932 L .59588 .40685 L p .485 .9 .884 r
F P
0 g
s
.59588 .40685 m .60103 .40318 L p .60363 .40603 L .485 .9 .884 r
F P
0 g
s
.60374 .40602 m .60388 .406 L .60383 .40601 L .088 .646 .711 r
F
.5633 .411 m .56311 .41102 L .56317 .41099 L .195 .723 .831 r
F
.56321 .41101 m .56356 .41096 L .56321 .41101 L .088 .646 .711 r
F
.56331 .411 m .56321 .41101 L .5633 .411 L .195 .723 .831 r
F
.56321 .41101 m .56311 .41102 L .5633 .411 L F
.56312 .41102 m .5633 .411 L p .56321 .41101 L .088 .646 .711 r
F P
0 g
s
.5633 .411 m .56356 .41096 L p .56321 .41101 L .088 .646 .711 r
F P
0 g
s
.57159 .4048 m .60103 .40318 L .59588 .40685 L p .481 .864 .978 r
F P
0 g
s
.59588 .40685 m .59514 .40738 L p .59333 .40718 L .481 .864 .978 r
F P
0 g
s
.59333 .40718 m .57159 .4048 L .59588 .40685 L .481 .864 .978 r
F
.59135 .40797 m .57563 .40981 L .54881 .4128 L .088 .646 .711 r
F
.576 .41004 m .58389 .41153 L p .59144 .40796 L .151 0 0 r
F P
0 g
s
.59145 .40796 m .59135 .40797 L .59144 .40796 L .151 0 0 r
F
.59135 .40797 m .576 .41004 L .59144 .40796 L F
.59145 .40796 m .59144 .40796 L .59146 .40796 L F
.59514 .40738 m .59241 .40932 L p .58747 .40825 L .481 .864 .978 r
F P
0 g
s
.58747 .40825 m .57159 .4048 L .59514 .40738 L .481 .864 .978 r
F
.53984 .41392 m .54881 .4128 L p .57067 .41038 L .088 .646 .711 r
F P
0 g
s
.57364 .41003 m .56256 .41125 L .56008 .41228 L .158 0 0 r
F
.53745 .41422 m .53984 .41392 L p .55884 .41179 L .088 .646 .711 r
F P
0 g
s
.55392 .41236 m .53745 .41422 L p .55884 .41179 L .088 .646 .711 r
F P
0 g
s
.56256 .41125 m .55157 .41246 L .56008 .41228 L .158 0 0 r
F
.55157 .41246 m .55486 .41315 L p .56008 .41228 L F P
0 g
s
.55486 .41315 m .58389 .41153 L .57547 .40993 L p .158 0 0 r
F P
0 g
s
.56304 .41103 m .56317 .41099 L p .55849 .41295 L .195 .723 .831 r
F P
0 g
s
.40307 .35811 m .48981 .37236 L .46784 .33711 L p .632 .143 .073 r
F P
0 g
s
.46584 .37225 m .4944 .38135 L .48693 .36756 L p .701 .219 .1 r
F P
0 g
s
.502 .39269 m .5306 .39731 L .52276 .38564 L p .651 .162 .078 r
F P
0 g
s
.52276 .38564 m .4944 .38135 L .502 .39269 L p .651 .162 .078 r
F P
0 g
s
.47396 .37436 m .50389 .39327 L .49603 .39575 L p .184 .538 .926 r
F P
0 g
s
.56312 .41102 m .50309 .3979 L .5025 .39754 L .131 .634 .905 r
F
.49831 .39496 m .52165 .40074 L p .5025 .39754 L F P
0 g
s
.50389 .39327 m .51187 .38706 L p .52947 .40205 L .39 .683 .976 r
F P
0 g
s
.52195 .40082 m .56312 .41102 L p .50397 .39786 L .131 .634 .905 r
F P
0 g
s
.53365 .40562 m .52217 .40085 L p .52947 .40205 L .39 .683 .976 r
F P
0 g
s
.52217 .40085 m .50389 .39327 L p .52947 .40205 L .39 .683 .976 r
F P
0 g
s
.52165 .40074 m .52195 .40082 L p .5025 .39754 L .131 .634 .905 r
F P
0 g
s
.50397 .39786 m .5025 .39754 L .52195 .40082 L .131 .634 .905 r
F
.5306 .39731 m .55896 .39636 L .55088 .38506 L p .621 .164 .146 r
F P
0 g
s
.55088 .38506 m .52276 .38564 L .5306 .39731 L p .621 .164 .146 r
F P
0 g
s
.51187 .38706 m .54185 .3994 L .53674 .40327 L p .39 .683 .976 r
F P
0 g
s
.53674 .40327 m .53365 .40562 L p .52947 .40205 L .39 .683 .976 r
F P
0 g
s
.52947 .40205 m .51187 .38706 L .53674 .40327 L .39 .683 .976 r
F
.52217 .40085 m .53365 .40562 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.56289 .41094 m .56317 .41099 L .56304 .41103 L p .201 .687 .928 r
F P
0 g
s
.56308 .41101 m .56302 .41102 L .56296 .41098 L .131 .634 .905 r
F
.56302 .41102 m .55157 .41246 L .56296 .41098 L F
.56304 .41103 m .55157 .41246 L p .56308 .41101 L F P
0 g
s
.53365 .40562 m .56289 .41094 L p .55486 .41315 L .201 .687 .928 r
F P
0 g
s
.56276 .41106 m .56304 .41103 L p .56312 .41102 L .088 .646 .711 r
F P
0 g
s
.56304 .41103 m .55486 .41315 L p .56289 .41094 L .201 .687 .928 r
F P
0 g
s
.52556 .40787 m .53365 .40562 L p .55248 .41231 L .201 .687 .928 r
F P
0 g
s
.55109 .41247 m .55486 .41315 L .55157 .41246 L p .138 0 0 r
F P
0 g
s
.55486 .41315 m .55109 .41247 L p .55248 .41231 L .201 .687 .928 r
F P
0 g
s
.52556 .40787 m .55109 .41247 L p .54909 .412 L .138 0 0 r
F P
0 g
s
.53929 .41018 m .52556 .40787 L .54909 .412 L .138 0 0 r
F
.55109 .41247 m .52556 .40787 L p .55248 .41231 L .201 .687 .928 r
F P
0 g
s
.56304 .41103 m .56312 .41102 L p .56321 .41101 L .088 .646 .711 r
F P
0 g
s
.58389 .41153 m .55849 .41295 L p .56311 .41102 L .195 .723 .831 r
F P
0 g
s
.58389 .41153 m .56311 .41102 L .56331 .411 L .195 .723 .831 r
F
.55849 .41295 m .55486 .41315 L .56304 .41103 L p F P
0 g
s
.56312 .41102 m .56304 .41103 L p .56308 .41101 L .131 .634 .905 r
F P
0 g
s
.49603 .39575 m .46633 .3772 L .47396 .37436 L p .184 .538 .926 r
F P
0 g
s
.46968 .38787 m .49831 .39496 L p .50309 .3979 L .131 .634 .905 r
F P
0 g
s
.51042 .40241 m .51514 .40555 L .46968 .38787 L .131 .634 .905 r
F
.51571 .40567 m .51514 .40555 L .51042 .40241 L F
.52556 .40787 m .51907 .40659 L p .51118 .40288 L 0 .453 .799 r
F P
0 g
s
.50674 .40015 m .52556 .40787 L p .51118 .40288 L 0 .453 .799 r
F P
0 g
s
.51907 .40659 m .51758 .4063 L p .5145 .40479 L 0 .453 .799 r
F P
0 g
s
.54193 .41366 m .53597 .41233 L .52212 .40766 L .131 .634 .905 r
F
.53597 .41233 m .528 .41055 L .52212 .40766 L F
.57563 .40981 m .57514 .40986 L .57364 .41003 L .088 .646 .711 r
F
.57532 .40984 m .57547 .40993 L p .57568 .4098 L .371 0 0 r
F P
0 g
s
.57547 .40993 m .576 .41004 L p .57761 .40958 L .151 0 0 r
F P
0 g
s
.57615 .40975 m .57547 .40993 L p .57761 .40958 L .151 0 0 r
F P
0 g
s
.57547 .40993 m .57615 .40975 L p .57568 .4098 L .371 0 0 r
F P
0 g
s
.57364 .41003 m .57547 .40993 L .57532 .40984 L p .41 0 0 r
F P
0 g
s
.54193 .41366 m .53745 .41422 L p .528 .41055 L .131 .634 .905 r
F P
0 g
s
.44623 .39267 m .42404 .38143 L p .38518 .35968 L 0 .425 .798 r
F P
0 g
s
.35341 .3419 m .39803 .3663 L p .38518 .35968 L 0 .425 .798 r
F P
0 g
s
.39803 .3663 m .44623 .39267 L p .38518 .35968 L 0 .425 .798 r
F P
0 g
s
.33351 .33942 m .31474 .32825 L p .24907 .28541 L .116 .558 .918 r
F P
0 g
s
.2418 .28067 m .24726 .28417 L p .24907 .28541 L .116 .558 .918 r
F P
0 g
s
.24726 .28417 m .33351 .33942 L p .24907 .28541 L .116 .558 .918 r
F P
0 g
s
.22505 .2872 m .227 .28809 L p .22801 .28821 L .097 .614 .885 r
F P
0 g
s
.227 .28809 m .31474 .32825 L p .22801 .28821 L .097 .614 .885 r
F P
0 g
s
.64465 .31474 m .65289 .31617 L p .66898 .31868 L .123 0 0 r
F P
0 g
s
.6706 .31894 m .66931 .31873 L p .66898 .31868 L .123 0 0 r
F P
0 g
s
.66931 .31873 m .64465 .31474 L p .66898 .31868 L .123 0 0 r
F P
0 g
s
.65289 .31617 m .67892 .31507 L .6706 .31894 L p .123 0 0 r
F P
0 g
s
.67892 .31507 m .65289 .31617 L .66127 .31788 L p .183 0 0 r
F P
0 g
s
.68737 .31166 m .67892 .31507 L p .66207 .31775 L .183 0 0 r
F P
0 g
s
.66127 .31788 m .6619 .31773 L p .66207 .31775 L .183 0 0 r
F P
0 g
s
.6619 .31773 m .68737 .31166 L p .66207 .31775 L .183 0 0 r
F P
0 g
s
.62669 .31773 m .65289 .31617 L .64465 .31474 L p .513 0 0 r
F P
0 g
s
.64465 .31474 m .61856 .31146 L .62669 .31773 L p .513 0 0 r
F P
0 g
s
.79562 .31193 m .87583 .25224 L .84517 .27311 L p 0 0 0 r
F P
0 g
s
.84517 .27311 m .76603 .32048 L .79562 .31193 L p 0 0 0 r
F P
0 g
s
.46784 .33711 m .38327 .32767 L .40307 .35811 L p .632 .143 .073 r
F P
0 g
s
.60029 .31932 m .62669 .31773 L .61856 .31146 L p .644 .167 .107 r
F P
0 g
s
.61856 .31146 m .5923 .30882 L .60029 .31932 L p .644 .167 .107 r
F P
0 g
s
.5737 .32054 m .60029 .31932 L .5923 .30882 L p .69 .266 .236 r
F P
0 g
s
.5923 .30882 m .56588 .30658 L .5737 .32054 L p .69 .266 .236 r
F P
0 g
s
.59991 .3929 m .68432 .36384 L .65735 .35251 L p .495 .021 .06 r
F P
0 g
s
.65735 .35251 m .57466 .36976 L .59991 .3929 L p .495 .021 .06 r
F P
0 g
s
.19412 .29435 m .10601 .29562 L .1197 .26883 L p .625 .857 .986 r
F P
0 g
s
.63496 .32411 m .66127 .31788 L .65289 .31617 L p .492 0 0 r
F P
0 g
s
.65289 .31617 m .62669 .31773 L .63496 .32411 L p .492 0 0 r
F P
0 g
s
.87583 .25224 m .91168 .22859 L .89741 .24296 L p .462 .874 .73 r
F P
0 g
s
.5469 .32109 m .5737 .32054 L .56588 .30658 L p .71 .316 .3 r
F P
0 g
s
.56588 .30658 m .53928 .30455 L .5469 .32109 L p .71 .316 .3 r
F P
0 g
s
.60842 .32979 m .63496 .32411 L .62669 .31773 L p .608 .156 .153 r
F P
0 g
s
.62669 .31773 m .60029 .31932 L .60842 .32979 L p .608 .156 .153 r
F P
0 g
s
.66979 .31959 m .69596 .30855 L .68737 .31166 L p .199 0 0 r
F P
0 g
s
.68737 .31166 m .66127 .31788 L .66979 .31959 L p .199 0 0 r
F P
0 g
s
.51991 .32072 m .5469 .32109 L .53928 .30455 L p .719 .34 .33 r
F P
0 g
s
.53928 .30455 m .51251 .30257 L .51991 .32072 L p .719 .34 .33 r
F P
0 g
s
.58165 .33437 m .60842 .32979 L .60029 .31932 L p .66 .249 .254 r
F P
0 g
s
.60029 .31932 m .5737 .32054 L .58165 .33437 L p .66 .249 .254 r
F P
0 g
s
.64336 .33026 m .66979 .31959 L .66127 .31788 L p .451 0 .014 r
F P
0 g
s
.66127 .31788 m .63496 .32411 L .64336 .33026 L p .451 0 .014 r
F P
0 g
s
.49272 .31928 m .51991 .32072 L .51251 .30257 L p .722 .347 .339 r
F P
0 g
s
.51251 .30257 m .48555 .30056 L .49272 .31928 L p .722 .347 .339 r
F P
0 g
s
.71254 .36685 m .79562 .31193 L .76603 .32048 L p .153 0 0 r
F P
0 g
s
.76603 .32048 m .68432 .36384 L .71254 .36685 L p .153 0 0 r
F P
0 g
s
.07124 .27405 m .07828 .25915 L p .10601 .29562 L .724 .799 .911 r
F P
0 g
s
.07828 .25915 m .1197 .26883 L .10601 .29562 L p .724 .799 .911 r
F P
0 g
s
.10601 .29562 m .06515 .29585 L .07124 .27405 L p .724 .799 .911 r
F P
0 g
s
.92938 .21861 m .91168 .22859 L p .90811 .23413 L 0 0 0 r
F P
0 g
s
.91168 .22859 m .87583 .25224 L .90811 .23413 L p 0 0 0 r
F P
0 g
s
.55466 .33742 m .58165 .33437 L .5737 .32054 L p .688 .299 .305 r
F P
0 g
s
.5737 .32054 m .5469 .32109 L .55466 .33742 L p .688 .299 .305 r
F P
0 g
s
.67843 .32107 m .70469 .30557 L .69596 .30855 L p .186 0 0 r
F P
0 g
s
.69596 .30855 m .66979 .31959 L .67843 .32107 L p .186 0 0 r
F P
0 g
s
.46534 .31671 m .49272 .31928 L .48555 .30056 L p .719 .34 .33 r
F P
0 g
s
.48555 .30056 m .45841 .29847 L .46534 .31671 L p .719 .34 .33 r
F P
0 g
s
.61669 .3398 m .64336 .33026 L .63496 .32411 L p .565 .131 .176 r
F P
0 g
s
.63496 .32411 m .60842 .32979 L .61669 .3398 L p .565 .131 .176 r
F P
0 g
s
.52745 .33862 m .55466 .33742 L .5469 .32109 L p .705 .326 .328 r
F P
0 g
s
.5469 .32109 m .51991 .32072 L .52745 .33862 L p .705 .326 .328 r
F P
0 g
s
.43778 .31304 m .46534 .31671 L .45841 .29847 L p .71 .316 .299 r
F P
0 g
s
.45841 .29847 m .43109 .29635 L .43778 .31304 L p .71 .316 .299 r
F P
0 g
s
.6519 .33582 m .67843 .32107 L .66979 .31959 L p .401 0 .051 r
F P
0 g
s
.66979 .31959 m .64336 .33026 L .6519 .33582 L p .401 0 .051 r
F P
0 g
s
.58975 .34757 m .61669 .3398 L .60842 .32979 L p .624 .221 .258 r
F P
0 g
s
.60842 .32979 m .58165 .33437 L .58975 .34757 L p .624 .221 .258 r
F P
0 g
s
.8266 .29908 m .90811 .23413 L .87583 .25224 L p 0 0 0 r
F P
0 g
s
.87583 .25224 m .79562 .31193 L .8266 .29908 L p 0 0 0 r
F P
0 g
s
.50002 .33773 m .52745 .33862 L .51991 .32072 L p .715 .337 .331 r
F P
0 g
s
.51991 .32072 m .49272 .31928 L .50002 .33773 L p .715 .337 .331 r
F P
0 g
s
.41004 .30842 m .43778 .31304 L .43109 .29635 L p .688 .266 .238 r
F P
0 g
s
.43109 .29635 m .40358 .29428 L .41004 .30842 L p .688 .266 .238 r
F P
0 g
s
.68722 .32206 m .71356 .30258 L .70469 .30557 L p .156 0 0 r
F P
0 g
s
.70469 .30557 m .67843 .32107 L .68722 .32206 L p .156 0 0 r
F P
0 g
s
.56256 .353 m .58975 .34757 L .58165 .33437 L p .661 .273 .299 r
F P
0 g
s
.58165 .33437 m .55466 .33742 L .56256 .353 L p .661 .273 .299 r
F P
0 g
s
.62508 .34894 m .6519 .33582 L .64336 .33026 L p .514 .093 .18 r
F P
0 g
s
.64336 .33026 m .61669 .3398 L .62508 .34894 L p .514 .093 .18 r
F P
0 g
s
.4724 .33469 m .50002 .33773 L .49272 .31928 L p .72 .333 .316 r
F P
0 g
s
.49272 .31928 m .46534 .31671 L .4724 .33469 L p .72 .333 .316 r
F P
0 g
s
.38212 .30306 m .41004 .30842 L .40358 .29428 L p .637 .166 .119 r
F P
0 g
s
.40358 .29428 m .37588 .29242 L .38212 .30306 L p .637 .166 .119 r
F P
0 g
s
.90811 .23413 m .94452 .20841 L .92938 .21861 L p 0 0 0 r
F P
0 g
s
.53512 .35568 m .56256 .353 L .55466 .33742 L p .686 .303 .315 r
F P
0 g
s
.55466 .33742 m .52745 .33862 L .53512 .35568 L p .686 .303 .315 r
F P
0 g
s
.13402 .24167 m .22505 .2872 L .20919 .2913 L p .535 .76 .98 r
F P
0 g
s
.20919 .2913 m .1197 .26883 L .13402 .24167 L p .535 .76 .98 r
F P
0 g
s
.66057 .34047 m .68722 .32206 L .67843 .32107 L p .342 0 .064 r
F P
0 g
s
.67843 .32107 m .6519 .33582 L .66057 .34047 L p .342 0 .064 r
F P
0 g
s
.44459 .32952 m .4724 .33469 L .46534 .31671 L p .718 .313 .279 r
F P
0 g
s
.46534 .31671 m .43778 .31304 L .44459 .32952 L p .718 .313 .279 r
F P
0 g
s
.59798 .35965 m .62508 .34894 L .61669 .3398 L p .582 .181 .247 r
F P
0 g
s
.61669 .3398 m .58975 .34757 L .59798 .35965 L p .582 .181 .247 r
F P
0 g
s
.35403 .29729 m .38212 .30306 L .37588 .29242 L p .503 0 0 r
F P
0 g
s
.37588 .29242 m .34799 .29099 L .35403 .29729 L p .503 0 0 r
F P
0 g
s
.69613 .32235 m .72256 .29943 L .71356 .30258 L p .117 0 0 r
F P
0 g
s
.71356 .30258 m .68722 .32206 L .69613 .32235 L p .117 0 0 r
F P
0 g
s
.50746 .35532 m .53512 .35568 L .52745 .33862 L p .704 .317 .312 r
F P
0 g
s
.52745 .33862 m .50002 .33773 L .50746 .35532 L p .704 .317 .312 r
F P
0 g
s
.41661 .32242 m .44459 .32952 L .43778 .31304 L p .704 .266 .208 r
F P
0 g
s
.43778 .31304 m .41004 .30842 L .41661 .32242 L p .704 .266 .208 r
F P
0 g
s
.32576 .29151 m .35403 .29729 L .34799 .29099 L p .136 0 0 r
F P
0 g
s
.34799 .29099 m .32064 .29024 L p .32576 .29151 L .136 0 0 r
F P
0 g
s
.35403 .29729 m .32576 .29151 L .33174 .29307 L p .176 0 0 r
F P
0 g
s
.30313 .28234 m .33098 .29279 L p .32576 .29151 L .325 .739 .978 r
F P
0 g
s
.33098 .29279 m .33174 .29307 L .32576 .29151 L p .325 .739 .978 r
F P
0 g
s
.32064 .29024 m .31989 .29022 L .32576 .29151 L p .136 0 0 r
F P
0 g
s
.63361 .35681 m .66057 .34047 L .6519 .33582 L p .455 .042 .167 r
F P
0 g
s
.6519 .33582 m .62508 .34894 L .63361 .35681 L p .455 .042 .167 r
F P
0 g
s
.57059 .36729 m .59798 .35965 L .58975 .34757 L p .628 .235 .28 r
F P
0 g
s
.58975 .34757 m .56256 .353 L .57059 .36729 L p .628 .235 .28 r
F P
0 g
s
.4796 .35183 m .50746 .35532 L .50002 .33773 L p .716 .317 .29 r
F P
0 g
s
.50002 .33773 m .4724 .33469 L .4796 .35183 L p .716 .317 .29 r
F P
0 g
s
.38848 .31368 m .41661 .32242 L .41004 .30842 L p .661 .17 .072 r
F P
0 g
s
.41004 .30842 m .38212 .30306 L .38848 .31368 L p .661 .17 .072 r
F P
0 g
s
.31989 .29022 m .29158 .29043 L .29731 .28615 L p .405 .825 .968 r
F P
0 g
s
.29731 .28615 m .32576 .29151 L .31989 .29022 L p .405 .825 .968 r
F P
0 g
s
.66937 .34393 m .69613 .32235 L .68722 .32206 L p .275 0 .058 r
F P
0 g
s
.68722 .32206 m .66057 .34047 L .66937 .34393 L p .275 0 .058 r
F P
0 g
s
.54294 .37134 m .57059 .36729 L .56256 .353 L p .662 .268 .29 r
F P
0 g
s
.56256 .353 m .53512 .35568 L .54294 .37134 L p .662 .268 .29 r
F P
0 g
s
.0846 .23763 m .09196 .2224 L p .1197 .26883 L .659 .744 .913 r
F P
0 g
s
.09196 .2224 m .13402 .24167 L .1197 .26883 L p .659 .744 .913 r
F P
0 g
s
.1197 .26883 m .07828 .25915 L .0846 .23763 L p .659 .744 .913 r
F P
0 g
s
.60634 .37017 m .63361 .35681 L .62508 .34894 L p .53 .127 .221 r
F P
0 g
s
.62508 .34894 m .59798 .35965 L .60634 .37017 L p .53 .127 .221 r
F P
0 g
s
.742 .35895 m .8266 .29908 L .79562 .31193 L p 0 0 0 r
F P
0 g
s
.79562 .31193 m .71254 .36685 L .742 .35895 L p 0 0 0 r
F P
0 g
s
.36018 .30372 m .38848 .31368 L .38212 .30306 L p .533 0 0 r
F P
0 g
s
.38212 .30306 m .35403 .29729 L .36018 .30372 L p .533 0 0 r
F P
0 g
s
.45154 .34524 m .4796 .35183 L .4724 .33469 L p .721 .299 .243 r
F P
0 g
s
.4724 .33469 m .44459 .32952 L .45154 .34524 L p .721 .299 .243 r
F P
0 g
s
.70517 .32174 m .7317 .29601 L .72256 .29943 L p .07 0 0 r
F P
0 g
s
.72256 .29943 m .69613 .32235 L .70517 .32174 L p .07 0 0 r
F P
0 g
s
.51504 .37148 m .54294 .37134 L .53512 .35568 L p .688 .286 .279 r
F P
0 g
s
.53512 .35568 m .50746 .35532 L .51504 .37148 L p .688 .286 .279 r
F P
0 g
s
.33174 .29307 m .36018 .30372 L .35403 .29729 L p .176 0 0 r
F P
0 g
s
.42332 .33578 m .45154 .34524 L .44459 .32952 L p .713 .253 .157 r
F P
0 g
s
.44459 .32952 m .41661 .32242 L .42332 .33578 L p .713 .253 .157 r
F P
0 g
s
.64226 .36304 m .66937 .34393 L .66057 .34047 L p .384 0 .136 r
F P
0 g
s
.66057 .34047 m .63361 .35681 L .64226 .36304 L p .384 0 .136 r
F P
0 g
s
.57875 .37978 m .60634 .37017 L .59798 .35965 L p .585 .183 .246 r
F P
0 g
s
.59798 .35965 m .57059 .36729 L .57875 .37978 L p .585 .183 .246 r
F P
0 g
s
.67829 .34591 m .70517 .32174 L .69613 .32235 L p .199 0 .032 r
F P
0 g
s
.69613 .32235 m .66937 .34393 L .67829 .34591 L p .199 0 .032 r
F P
0 g
s
.39495 .32383 m .42332 .33578 L .41661 .32242 L p .672 .155 0 r
F P
0 g
s
.41661 .32242 m .38848 .31368 L .39495 .32383 L p .672 .155 0 r
F P
0 g
s
.32576 .29151 m .29731 .28615 L .30313 .28234 L p .325 .739 .978 r
F P
0 g
s
.48693 .36756 m .51504 .37148 L .50746 .35532 L p .707 .288 .248 r
F P
0 g
s
.50746 .35532 m .4796 .35183 L .48693 .36756 L p .707 .288 .248 r
F P
0 g
s
.31474 .32825 m .22505 .2872 L .2418 .28067 L p .116 .558 .918 r
F P
0 g
s
.61482 .37868 m .64226 .36304 L .63361 .35681 L p .464 .055 .178 r
F P
0 g
s
.63361 .35681 m .60634 .37017 L .61482 .37868 L p .464 .055 .178 r
F P
0 g
s
.55088 .38506 m .57875 .37978 L .57059 .36729 L p .628 .219 .248 r
F P
0 g
s
.57059 .36729 m .54294 .37134 L .55088 .38506 L p .628 .219 .248 r
F P
0 g
s
.71434 .32007 m .74098 .29222 L .7317 .29601 L p .016 0 0 r
F P
0 g
s
.7317 .29601 m .70517 .32174 L .71434 .32007 L p .016 0 0 r
F P
0 g
s
.36644 .3099 m .39495 .32383 L .38848 .31368 L p .535 0 0 r
F P
0 g
s
.38848 .31368 m .36018 .30372 L .36644 .3099 L p .535 0 0 r
F P
0 g
s
.45863 .35965 m .48693 .36756 L .4796 .35183 L p .717 .27 .187 r
F P
0 g
s
.4796 .35183 m .45154 .34524 L .45863 .35965 L p .717 .27 .187 r
F P
0 g
s
.65104 .3673 m .67829 .34591 L .66937 .34393 L p .298 0 .087 r
F P
0 g
s
.66937 .34393 m .64226 .36304 L .65104 .3673 L p .298 0 .087 r
F P
0 g
s
.33174 .29307 m .33781 .29465 L p .35692 .3024 L 0 .391 .722 r
F P
0 g
s
.36018 .30372 m .35785 .30285 L p .35692 .3024 L 0 .391 .722 r
F P
0 g
s
.35785 .30285 m .33174 .29307 L p .35692 .3024 L 0 .391 .722 r
F P
0 g
s
.33781 .29465 m .36644 .3099 L .36018 .30372 L p 0 .391 .722 r
F P
0 g
s
.33781 .29465 m .34399 .29598 L p .36153 .30685 L 0 .372 .771 r
F P
0 g
s
.36644 .3099 m .36266 .30788 L p .36153 .30685 L 0 .372 .771 r
F P
0 g
s
.36266 .30788 m .33781 .29465 L p .36153 .30685 L 0 .372 .771 r
F P
0 g
s
.37282 .31548 m .36644 .3099 L p .34531 .29679 L 0 .372 .771 r
F P
0 g
s
.37282 .31548 m .40155 .33308 L .39495 .32383 L p .499 0 0 r
F P
0 g
s
.39495 .32383 m .36644 .3099 L .37282 .31548 L p .499 0 0 r
F P
0 g
s
.37282 .31548 m .37933 .32012 L p .39261 .32787 L .421 0 0 r
F P
0 g
s
.40155 .33308 m .39263 .32761 L p .39261 .32787 L .421 0 0 r
F P
0 g
s
.39263 .32761 m .37282 .31548 L p .39261 .32787 L .421 0 0 r
F P
0 g
s
.37933 .32012 m .40828 .34103 L .40155 .33308 L p .421 0 0 r
F P
0 g
s
.40828 .34103 m .37933 .32012 L .38595 .32352 L p 0 .216 .67 r
F P
0 g
s
.41514 .34729 m .40828 .34103 L p .39256 .3287 L 0 .216 .67 r
F P
0 g
s
.38595 .32352 m .39255 .32889 L p .39256 .3287 L 0 .216 .67 r
F P
0 g
s
.39255 .32889 m .41514 .34729 L p .39256 .3287 L 0 .216 .67 r
F P
0 g
s
.37933 .32012 m .37282 .31548 L p .35284 .29891 L 0 .363 .804 r
F P
0 g
s
.35028 .2968 m .35224 .29837 L p .35284 .29891 L 0 .363 .804 r
F P
0 g
s
.35224 .29837 m .37933 .32012 L p .35284 .29891 L 0 .363 .804 r
F P
0 g
s
.34399 .29598 m .34492 .29661 L p .34531 .29679 L 0 .372 .771 r
F P
0 g
s
.34492 .29661 m .37282 .31548 L p .34531 .29679 L 0 .372 .771 r
F P
0 g
s
.52276 .38564 m .55088 .38506 L .54294 .37134 L p .662 .238 .227 r
F P
0 g
s
.54294 .37134 m .51504 .37148 L .52276 .38564 L p .662 .238 .227 r
F P
0 g
s
.43016 .34801 m .45863 .35965 L .45154 .34524 L p .711 .221 .08 r
F P
0 g
s
.45154 .34524 m .42332 .33578 L .43016 .34801 L p .711 .221 .08 r
F P
0 g
s
.58704 .39 m .61482 .37868 L .60634 .37017 L p .527 .109 .192 r
F P
0 g
s
.60634 .37017 m .57875 .37978 L .58704 .39 L p .527 .109 .192 r
F P
0 g
s
.68732 .3462 m .71434 .32007 L .70517 .32174 L p .112 0 0 r
F P
0 g
s
.70517 .32174 m .67829 .34591 L .68732 .3462 L p .112 0 0 r
F P
0 g
s
.30904 .27884 m .33781 .29465 L .33174 .29307 L p .259 .651 .965 r
F P
0 g
s
.33174 .29307 m .30313 .28234 L .30904 .27884 L p .259 .651 .965 r
F P
0 g
s
.14899 .21538 m .2418 .28067 L .22505 .2872 L p .434 .661 .956 r
F P
0 g
s
.22505 .2872 m .13402 .24167 L .14899 .21538 L p .434 .661 .956 r
F P
0 g
s
.40155 .33308 m .43016 .34801 L .42332 .33578 L p .661 .116 0 r
F P
0 g
s
.42332 .33578 m .39495 .32383 L .40155 .33308 L p .661 .116 0 r
F P
0 g
s
.4944 .38135 m .52276 .38564 L .51504 .37148 L p .688 .24 .182 r
F P
0 g
s
.51504 .37148 m .48693 .36756 L .4944 .38135 L p .688 .24 .182 r
F P
0 g
s
.6541 .39981 m .742 .35895 L .71254 .36685 L p 0 0 0 r
F P
0 g
s
.72363 .31721 m .7504 .28798 L .74098 .29222 L p 0 0 0 r
F P
0 g
s
.74098 .29222 m .71434 .32007 L .72363 .31721 L p 0 0 0 r
F P
0 g
s
.62342 .38482 m .65104 .3673 L .64226 .36304 L p .377 0 .11 r
F P
0 g
s
.64226 .36304 m .61482 .37868 L .62342 .38482 L p .377 0 .11 r
F P
0 g
s
.55896 .39636 m .58704 .39 L .57875 .37978 L p .579 .145 .181 r
F P
0 g
s
.57875 .37978 m .55088 .38506 L .55896 .39636 L p .579 .145 .181 r
F P
0 g
s
.48693 .36756 m .45863 .35965 L .46584 .37225 L p .701 .219 .1 r
F P
0 g
s
.65992 .36932 m .68732 .3462 L .67829 .34591 L p .19 0 .013 r
F P
0 g
s
.67829 .34591 m .65104 .3673 L .65992 .36932 L p .19 0 .013 r
F P
0 g
s
.59545 .39755 m .62342 .38482 L .61482 .37868 L p .444 .005 .107 r
F P
0 g
s
.61482 .37868 m .58704 .39 L .59545 .39755 L p .444 .005 .107 r
F P
0 g
s
.43713 .35864 m .46584 .37225 L .45863 .35965 L p .689 .163 0 r
F P
0 g
s
.45863 .35965 m .43016 .34801 L .43713 .35864 L p .689 .163 0 r
F P
0 g
s
.69647 .34462 m .72363 .31721 L .71434 .32007 L p .01 0 0 r
F P
0 g
s
.71434 .32007 m .68732 .3462 L .69647 .34462 L p .01 0 0 r
F P
0 g
s
.09849 .20279 m .10617 .18793 L p .13402 .24167 L .575 .688 .918 r
F P
0 g
s
.10617 .18793 m .14899 .21538 L .13402 .24167 L p .575 .688 .918 r
F P
0 g
s
.13402 .24167 m .09196 .2224 L .09849 .20279 L p .575 .688 .918 r
F P
0 g
s
.31504 .27547 m .34399 .29598 L .33781 .29465 L p .21 .573 .94 r
F P
0 g
s
.33781 .29465 m .30904 .27884 L .31504 .27547 L p .21 .573 .94 r
F P
0 g
s
.73304 .31307 m .75996 .28323 L .7504 .28798 L p 0 0 0 r
F P
0 g
s
.7504 .28798 m .72363 .31721 L .73304 .31307 L p 0 0 0 r
F P
0 g
s
.40828 .34103 m .43713 .35864 L .43016 .34801 L p .615 .047 0 r
F P
0 g
s
.43016 .34801 m .40155 .33308 L .40828 .34103 L p .615 .047 0 r
F P
0 g
s
.63213 .38826 m .65992 .36932 L .65104 .3673 L p .258 0 .01 r
F P
0 g
s
.65104 .3673 m .62342 .38482 L .63213 .38826 L p .258 0 .01 r
F P
0 g
s
.42404 .38143 m .33351 .33942 L .35341 .3419 L p 0 .425 .798 r
F P
0 g
s
.56716 .40478 m .59545 .39755 L .58704 .39 L p .501 .034 .077 r
F P
0 g
s
.58704 .39 m .55896 .39636 L .56716 .40478 L p .501 .034 .077 r
F P
0 g
s
.66891 .36886 m .69647 .34462 L .68732 .3462 L p .056 0 0 r
F P
0 g
s
.68732 .3462 m .65992 .36932 L .66891 .36886 L p .056 0 0 r
F P
0 g
s
.37282 .31548 m .34399 .29598 L .35028 .2968 L p 0 .363 .804 r
F P
0 g
s
.70573 .34104 m .73304 .31307 L .72363 .31721 L p 0 0 0 r
F P
0 g
s
.72363 .31721 m .69647 .34462 L .70573 .34104 L p 0 0 0 r
F P
0 g
s
.60397 .40205 m .63213 .38826 L .62342 .38482 L p .319 0 0 r
F P
0 g
s
.62342 .38482 m .59545 .39755 L .60397 .40205 L p .319 0 0 r
F P
0 g
s
.32114 .27208 m .35028 .2968 L .34399 .29598 L p .179 .51 .913 r
F P
0 g
s
.34399 .29598 m .31504 .27547 L .32114 .27208 L p .179 .51 .913 r
F P
0 g
s
.46584 .37225 m .43713 .35864 L .44423 .36723 L p .628 .065 0 r
F P
0 g
s
.74258 .30759 m .76967 .27795 L .75996 .28323 L p 0 0 0 r
F P
0 g
s
.75996 .28323 m .73304 .31307 L .74258 .30759 L p 0 0 0 r
F P
0 g
s
.2595 .27046 m .35341 .3419 L .33351 .33942 L p .154 .519 .916 r
F P
0 g
s
.33351 .33942 m .2418 .28067 L .2595 .27046 L p .154 .519 .916 r
F P
0 g
s
.64095 .38873 m .66891 .36886 L .65992 .36932 L p .094 0 0 r
F P
0 g
s
.65992 .36932 m .63213 .38826 L .64095 .38873 L p .094 0 0 r
F P
0 g
s
.41514 .34729 m .44423 .36723 L .43713 .35864 L p .516 0 0 r
F P
0 g
s
.43713 .35864 m .40828 .34103 L .41514 .34729 L p .516 0 0 r
F P
0 g
s
.678 .36577 m .70573 .34104 L .69647 .34462 L p 0 0 0 r
F P
0 g
s
.69647 .34462 m .66891 .36886 L .678 .36577 L p 0 0 0 r
F P
0 g
s
.35668 .29688 m .38595 .32352 L .37933 .32012 L p 0 .361 .825 r
F P
0 g
s
.37933 .32012 m .35028 .2968 L .35668 .29688 L p 0 .361 .825 r
F P
0 g
s
.71509 .33538 m .74258 .30759 L .73304 .31307 L p 0 0 0 r
F P
0 g
s
.73304 .31307 m .70573 .34104 L .71509 .33538 L p 0 0 0 r
F P
0 g
s
.32735 .26852 m .35668 .29688 L .35028 .2968 L p .163 .463 .888 r
F P
0 g
s
.35028 .2968 m .32114 .27208 L .32735 .26852 L p .163 .463 .888 r
F P
0 g
s
.75224 .30076 m .77952 .27215 L .76967 .27795 L p 0 0 0 r
F P
0 g
s
.76967 .27795 m .74258 .30759 L .75224 .30076 L p 0 0 0 r
F P
0 g
s
.16463 .19108 m .2595 .27046 L .2418 .28067 L p .337 .574 .928 r
F P
0 g
s
.2418 .28067 m .14899 .21538 L .16463 .19108 L p .337 .574 .928 r
F P
0 g
s
.64986 .38605 m .678 .36577 L .66891 .36886 L p 0 0 0 r
F P
0 g
s
.66891 .36886 m .64095 .38873 L .64986 .38605 L p 0 0 0 r
F P
0 g
s
.53745 .41422 m .44623 .39267 L .46968 .38787 L p .131 .634 .905 r
F P
0 g
s
.44423 .36723 m .41514 .34729 L .42213 .35154 L p 0 .184 .623 r
F P
0 g
s
.42213 .35154 m .45147 .3734 L .44423 .36723 L p 0 .184 .623 r
F P
0 g
s
.68719 .35995 m .71509 .33538 L .70573 .34104 L p 0 0 0 r
F P
0 g
s
.70573 .34104 m .678 .36577 L .68719 .35995 L p 0 0 0 r
F P
0 g
s
.3927 .32539 m .42213 .35154 L .41514 .34729 L p 0 .284 .761 r
F P
0 g
s
.41514 .34729 m .38595 .32352 L .3927 .32539 L p 0 .284 .761 r
F P
0 g
s
.72457 .32762 m .75224 .30076 L .74258 .30759 L p 0 0 0 r
F P
0 g
s
.74258 .30759 m .71509 .33538 L .72457 .32762 L p 0 0 0 r
F P
0 g
s
.11289 .17166 m .12091 .1578 L p .14899 .21538 L .465 .627 .922 r
F P
0 g
s
.12091 .1578 m .16463 .19108 L .14899 .21538 L p .465 .627 .922 r
F P
0 g
s
.14899 .21538 m .10617 .18793 L .11289 .17166 L p .465 .627 .922 r
F P
0 g
s
.36321 .29603 m .3927 .32539 L .38595 .32352 L p .006 .367 .836 r
F P
0 g
s
.38595 .32352 m .35668 .29688 L .36321 .29603 L p .006 .367 .836 r
F P
0 g
s
.62132 .40083 m .64986 .38605 L .64095 .38873 L p 0 0 0 r
F P
0 g
s
.76202 .29263 m .78951 .26584 L .77952 .27215 L p 0 0 0 r
F P
0 g
s
.77952 .27215 m .75224 .30076 L .76202 .29263 L p 0 0 0 r
F P
0 g
s
.33366 .26466 m .36321 .29603 L .35668 .29688 L p .157 .432 .868 r
F P
0 g
s
.35668 .29688 m .32735 .26852 L .33366 .26466 L p .157 .432 .868 r
F P
0 g
s
.48068 .39014 m .45147 .3734 L .45883 .37681 L p 0 .267 .673 r
F P
0 g
s
.65887 .38009 m .68719 .35995 L .678 .36577 L p 0 0 0 r
F P
0 g
s
.678 .36577 m .64986 .38605 L .65887 .38009 L p 0 0 0 r
F P
0 g
s
.42925 .35347 m .45883 .37681 L .45147 .3734 L p 0 .309 .77 r
F P
0 g
s
.45147 .3734 m .42213 .35154 L .42925 .35347 L p 0 .309 .77 r
F P
0 g
s
.71509 .33538 m .68719 .35995 L .69647 .35137 L p .494 .835 .553 r
F P
0 g
s
.69647 .35137 m .72457 .32762 L .71509 .33538 L p .494 .835 .553 r
F P
0 g
s
.37452 .33296 m .46968 .38787 L .44623 .39267 L p .167 .555 .93 r
F P
0 g
s
.44623 .39267 m .35341 .3419 L .37452 .33296 L p .167 .555 .93 r
F P
0 g
s
.39958 .32552 m .42925 .35347 L .42213 .35154 L p 0 .345 .82 r
F P
0 g
s
.42213 .35154 m .3927 .32539 L .39958 .32552 L p 0 .345 .82 r
F P
0 g
s
.75224 .30076 m .72457 .32762 L .73414 .3178 L p .525 .84 .534 r
F P
0 g
s
.73414 .3178 m .76202 .29263 L .75224 .30076 L p .525 .84 .534 r
F P
0 g
s
.36986 .29407 m .39958 .32552 L .3927 .32539 L p .065 .378 .843 r
F P
0 g
s
.3927 .32539 m .36321 .29603 L .36986 .29407 L p .065 .378 .843 r
F P
0 g
s
.63014 .39477 m .65887 .38009 L .64986 .38605 L p .443 .862 .721 r
F P
0 g
s
.64986 .38605 m .62132 .40083 L .63014 .39477 L p .443 .862 .721 r
F P
0 g
s
.77193 .28327 m .79966 .25911 L .78951 .26584 L p 0 0 0 r
F P
0 g
s
.78951 .26584 m .76202 .29263 L .77193 .28327 L p 0 0 0 r
F P
0 g
s
.34008 .26041 m .36986 .29407 L .36321 .29603 L p .159 .412 .854 r
F P
0 g
s
.36321 .29603 m .33366 .26466 L .34008 .26041 L p .159 .412 .854 r
F P
0 g
s
.56317 .41099 m .59241 .40932 L .58389 .41153 L p .195 .723 .831 r
F P
0 g
s
.66796 .37083 m .69647 .35137 L .68719 .35995 L p .595 .929 .721 r
F P
0 g
s
.68719 .35995 m .65887 .38009 L .66796 .37083 L p .595 .929 .721 r
F P
0 g
s
.70585 .34008 m .73414 .3178 L .72457 .32762 L p .656 .944 .697 r
F P
0 g
s
.72457 .32762 m .69647 .35137 L .70585 .34008 L p .656 .944 .697 r
F P
0 g
s
.27823 .25558 m .37452 .33296 L .35341 .3419 L p .202 .506 .909 r
F P
0 g
s
.35341 .3419 m .2595 .27046 L .27823 .25558 L p .202 .506 .909 r
F P
0 g
s
.43651 .35286 m .46633 .3772 L .45883 .37681 L p .022 .409 .858 r
F P
0 g
s
.45883 .37681 m .42925 .35347 L .43651 .35286 L p .022 .409 .858 r
F P
0 g
s
.60103 .40318 m .63014 .39477 L .62132 .40083 L p .485 .9 .884 r
F P
0 g
s
.74383 .30603 m .77193 .28327 L .76202 .29263 L p .649 .932 .664 r
F P
0 g
s
.76202 .29263 m .73414 .3178 L .74383 .30603 L p .649 .932 .664 r
F P
0 g
s
.40659 .3237 m .43651 .35286 L .42925 .35347 L p .073 .395 .853 r
F P
0 g
s
.42925 .35347 m .39958 .32552 L .40659 .3237 L p .073 .395 .853 r
F P
0 g
s
.63904 .38499 m .66796 .37083 L .65887 .38009 L p .658 .972 .866 r
F P
0 g
s
.65887 .38009 m .63014 .39477 L .63904 .38499 L p .658 .972 .866 r
F P
0 g
s
.37662 .29086 m .40659 .3237 L .39958 .32552 L p .121 .393 .847 r
F P
0 g
s
.39958 .32552 m .36986 .29407 L .37662 .29086 L p .121 .393 .847 r
F P
0 g
s
.34661 .25568 m .37662 .29086 L .36986 .29407 L p .167 .402 .845 r
F P
0 g
s
.36986 .29407 m .34008 .26041 L .34661 .25568 L p .167 .402 .845 r
F P
0 g
s
.59241 .40932 m .56317 .41099 L .57159 .4048 L p .481 .864 .978 r
F P
0 g
s
.67714 .35831 m .70585 .34008 L .69647 .35137 L p .74 .992 .83 r
F P
0 g
s
.69647 .35137 m .66796 .37083 L .67714 .35831 L p .74 .992 .83 r
F P
0 g
s
.181 .16961 m .27823 .25558 L .2595 .27046 L p .25 .506 .902 r
F P
0 g
s
.2595 .27046 m .16463 .19108 L .181 .16961 L p .25 .506 .902 r
F P
0 g
s
.71532 .32618 m .74383 .30603 L .73414 .3178 L p .764 .994 .798 r
F P
0 g
s
.73414 .3178 m .70585 .34008 L .71532 .32618 L p .764 .994 .798 r
F P
0 g
s
.60974 .39306 m .63904 .38499 L .63014 .39477 L p .667 .949 .955 r
F P
0 g
s
.63014 .39477 m .60103 .40318 L .60974 .39306 L p .667 .949 .955 r
F P
0 g
s
.44389 .34955 m .47396 .37436 L .46633 .3772 L p .176 .479 .896 r
F P
0 g
s
.46633 .3772 m .43651 .35286 L .44389 .34955 L p .176 .479 .896 r
F P
0 g
s
.54185 .3994 m .57159 .4048 L .56317 .41099 L p .442 .779 .998 r
F P
0 g
s
.56317 .41099 m .53365 .40562 L .54185 .3994 L p .442 .779 .998 r
F P
0 g
s
.41373 .3198 m .44389 .34955 L .43651 .35286 L p .172 .437 .87 r
F P
0 g
s
.43651 .35286 m .40659 .3237 L .41373 .3198 L p .172 .437 .87 r
F P
0 g
s
.12782 .14595 m .1362 .13359 L p .16463 .19108 L .32 .553 .918 r
F P
0 g
s
.1362 .13359 m .181 .16961 L .16463 .19108 L p .32 .553 .918 r
F P
0 g
s
.16463 .19108 m .12091 .1578 L .12782 .14595 L p .32 .553 .918 r
F P
0 g
s
.64803 .37154 m .67714 .35831 L .66796 .37083 L p .766 .98 .913 r
F P
0 g
s
.66796 .37083 m .63904 .38499 L .64803 .37154 L p .766 .98 .913 r
F P
0 g
s
.38352 .2863 m .41373 .3198 L .40659 .3237 L p .173 .412 .851 r
F P
0 g
s
.40659 .3237 m .37662 .29086 L .38352 .2863 L p .173 .412 .851 r
F P
0 g
s
.58009 .39453 m .60974 .39306 L .60103 .40318 L p .632 .88 .987 r
F P
0 g
s
.60103 .40318 m .57159 .4048 L .58009 .39453 L p .632 .88 .987 r
F P
0 g
s
.35326 .25041 m .38352 .2863 L .37662 .29086 L p .18 .4 .84 r
F P
0 g
s
.37662 .29086 m .34661 .25568 L .35326 .25041 L p .18 .4 .84 r
F P
0 g
s
.68641 .34266 m .71532 .32618 L .70585 .34008 L p .811 .99 .877 r
F P
0 g
s
.70585 .34008 m .67714 .35831 L .68641 .34266 L p .811 .99 .877 r
F P
0 g
s
.4817 .36817 m .51187 .38706 L .50389 .39327 L p .339 .597 .941 r
F P
0 g
s
.50389 .39327 m .47396 .37436 L .4817 .36817 L p .339 .597 .941 r
F P
0 g
s
.61854 .37901 m .64803 .37154 L .63904 .38499 L p .747 .926 .949 r
F P
0 g
s
.63904 .38499 m .60974 .39306 L .61854 .37901 L p .747 .926 .949 r
F P
0 g
s
.55015 .38917 m .58009 .39453 L .57159 .4048 L p .573 .792 .982 r
F P
0 g
s
.57159 .4048 m .54185 .3994 L .55015 .38917 L p .573 .792 .982 r
F P
0 g
s
.4514 .34342 m .4817 .36817 L .47396 .37436 L p .293 .527 .907 r
F P
0 g
s
.47396 .37436 m .44389 .34955 L .4514 .34342 L p .293 .527 .907 r
F P
0 g
s
.6571 .35456 m .68641 .34266 L .67714 .35831 L p .808 .947 .913 r
F P
0 g
s
.67714 .35831 m .64803 .37154 L .6571 .35456 L p .808 .947 .913 r
F P
0 g
s
.421 .31375 m .4514 .34342 L .44389 .34955 L p .255 .473 .878 r
F P
0 g
s
.44389 .34955 m .41373 .3198 L .421 .31375 L p .255 .473 .878 r
F P
0 g
s
.39053 .28035 m .421 .31375 L .41373 .3198 L p .222 .433 .855 r
F P
0 g
s
.41373 .3198 m .38352 .2863 L .39053 .28035 L p .222 .433 .855 r
F P
0 g
s
.51996 .37707 m .55015 .38917 L .54185 .3994 L p .508 .706 .959 r
F P
0 g
s
.54185 .3994 m .51187 .38706 L .51996 .37707 L p .508 .706 .959 r
F P
0 g
s
.5887 .38023 m .61854 .37901 L .60974 .39306 L p .701 .855 .956 r
F P
0 g
s
.60974 .39306 m .58009 .39453 L .5887 .38023 L p .701 .855 .956 r
F P
0 g
s
.36002 .24457 m .39053 .28035 L .38352 .2863 L p .196 .406 .841 r
F P
0 g
s
.38352 .2863 m .35326 .25041 L .36002 .24457 L p .196 .406 .841 r
F P
0 g
s
.48957 .3586 m .51996 .37707 L .51187 .38706 L p .444 .628 .932 r
F P
0 g
s
.51187 .38706 m .4817 .36817 L .48957 .3586 L p .444 .628 .932 r
F P
0 g
s
.62741 .36117 m .6571 .35456 L .64803 .37154 L p .778 .888 .924 r
F P
0 g
s
.64803 .37154 m .61854 .37901 L .62741 .36117 L p .778 .888 .924 r
F P
0 g
s
.55855 .37498 m .5887 .38023 L .58009 .39453 L p .643 .782 .948 r
F P
0 g
s
.58009 .39453 m .55015 .38917 L .55855 .37498 L p .643 .782 .948 r
F P
0 g
s
.45903 .33444 m .48957 .3586 L .4817 .36817 L p .382 .561 .905 r
F P
0 g
s
.4817 .36817 m .4514 .34342 L .45903 .33444 L p .382 .561 .905 r
F P
0 g
s
.42839 .30552 m .45903 .33444 L .4514 .34342 L p .324 .505 .881 r
F P
0 g
s
.4514 .34342 m .421 .31375 L .42839 .30552 L p .324 .505 .881 r
F P
0 g
s
.52815 .36335 m .55855 .37498 L .55015 .38917 L p .58 .711 .933 r
F P
0 g
s
.55015 .38917 m .51996 .37707 L .52815 .36335 L p .58 .711 .933 r
F P
0 g
s
.59738 .36205 m .62741 .36117 L .61854 .37901 L p .733 .827 .923 r
F P
0 g
s
.61854 .37901 m .5887 .38023 L .59738 .36205 L p .733 .827 .923 r
F P
0 g
s
.39768 .27298 m .42839 .30552 L .421 .31375 L p .268 .457 .861 r
F P
0 g
s
.421 .31375 m .39053 .28035 L .39768 .27298 L p .268 .457 .861 r
F P
0 g
s
.36691 .23817 m .39768 .27298 L .39053 .28035 L p .214 .417 .845 r
F P
0 g
s
.39053 .28035 m .36002 .24457 L .36691 .23817 L p .214 .417 .845 r
F P
0 g
s
.49755 .3457 m .52815 .36335 L .51996 .37707 L p .516 .647 .915 r
F P
0 g
s
.51996 .37707 m .48957 .3586 L .49755 .3457 L p .516 .647 .915 r
F P
0 g
s
.56705 .35698 m .59738 .36205 L .5887 .38023 L p .682 .768 .916 r
F P
0 g
s
.5887 .38023 m .55855 .37498 L .56705 .35698 L p .682 .768 .916 r
F P
0 g
s
.46679 .32266 m .49755 .3457 L .48957 .3586 L p .451 .588 .899 r
F P
0 g
s
.48957 .3586 m .45903 .33444 L .46679 .32266 L p .451 .588 .899 r
F P
0 g
s
.43591 .29514 m .46679 .32266 L .45903 .33444 L p .383 .534 .883 r
F P
0 g
s
.45903 .33444 m .42839 .30552 L .43591 .29514 L p .383 .534 .883 r
F P
0 g
s
.53646 .34605 m .56705 .35698 L .55855 .37498 L p .627 .712 .908 r
F P
0 g
s
.55855 .37498 m .52815 .36335 L .53646 .34605 L p .627 .712 .908 r
F P
0 g
s
.40495 .26424 m .43591 .29514 L .42839 .30552 L p .312 .483 .868 r
F P
0 g
s
.42839 .30552 m .39768 .27298 L .40495 .26424 L p .312 .483 .868 r
F P
0 g
s
.37391 .23124 m .40495 .26424 L .39768 .27298 L p .235 .435 .853 r
F P
0 g
s
.39768 .27298 m .36691 .23817 L .37391 .23124 L p .235 .435 .853 r
F P
0 g
s
.50565 .32959 m .53646 .34605 L .52815 .36335 L p .568 .66 .899 r
F P
0 g
s
.52815 .36335 m .49755 .3457 L .50565 .32959 L p .568 .66 .899 r
F P
0 g
s
.47467 .3082 m .50565 .32959 L .49755 .3457 L p .505 .611 .892 r
F P
0 g
s
.49755 .3457 m .46679 .32266 L .47467 .3082 L p .505 .611 .892 r
F P
0 g
s
.44356 .28273 m .47467 .3082 L .46679 .32266 L p .435 .562 .884 r
F P
0 g
s
.46679 .32266 m .43591 .29514 L .44356 .28273 L p .435 .562 .884 r
F P
0 g
s
.41235 .25421 m .44356 .28273 L .43591 .29514 L p .354 .512 .876 r
F P
0 g
s
.43591 .29514 m .40495 .26424 L .41235 .25421 L p .354 .512 .876 r
F P
0 g
s
.38104 .22384 m .41235 .25421 L .40495 .26424 L p .258 .459 .866 r
F P
0 g
s
.40495 .26424 m .37391 .23124 L .38104 .22384 L p .258 .459 .866 r
F P
0 g
s
.25 Mabswid
.98446 .08978 m
1 .42004 L
s
.98446 .08978 m
.97767 .08904 L
s
[(-1)] .99803 .09126 -1 -0.10884 Mshowa
.98826 .17057 m
.98147 .1699 L
s
[(-0.5)] 1.00185 .1719 -1 -0.09814 Mshowa
.99212 .25253 m
.98532 .25193 L
s
[(0)] 1.00572 .25371 -1 -0.08728 Mshowa
.99603 .33567 m
.98922 .33515 L
s
[(0.5)] 1.00964 .33671 -1 -0.07625 Mshowa
1 .42004 m
.99319 .41959 L
s
[(1)] 1.01362 .42092 -1 -0.06504 Mshowa
.125 Mabswid
.98522 .10585 m
.98114 .10541 L
s
.98597 .12196 m
.9819 .12153 L
s
.98674 .13812 m
.98266 .1377 L
s
.9875 .15432 m
.98342 .15391 L
s
.98903 .18687 m
.98495 .18648 L
s
.9898 .20321 m
.98572 .20283 L
s
.99057 .2196 m
.98649 .21923 L
s
.99134 .23604 m
.98726 .23567 L
s
.9929 .26906 m
.98881 .26871 L
s
.99368 .28564 m
.98959 .2853 L
s
.99446 .30227 m
.99038 .30194 L
s
.99524 .31895 m
.99116 .31863 L
s
.99682 .35245 m
.99273 .35214 L
s
.99761 .36927 m
.99353 .36898 L
s
.99841 .38614 m
.99432 .38586 L
s
.9992 .40306 m
.99511 .40279 L
s
gsave
1.07373 .25965 -61 -9.87563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 153.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000`1000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00ogooJGoo002jOol3002[Ool00;aoo`03001oogoo0:Uoo`00_7oo00<007ooOol0
ZGoo002kOol00`00Ool0002ZOol00;]oo`03001oo`000:Yoo`00^Woo00D007ooOomoo`000:Uoo`00
^Woo00D007ooOomoo`000:Uoo`00BWoo1@00JWoo0`0000Aoo`0000000:Qoo`00BWoo00D007ooOomo
o`000?mooaYoo`00Bgoo00<007ooOol0ogoo6goo0012Ool60004Ool00`00Oomoo`3oOolJOol004eo
o`03001oogoo0?mooaUoo`00CWoo00<007ooOol0ogoo67oo001:Ool01@00Oomoogoo0000=goo1@00
gGoo001;Ool3000jOol00`00Oomoo`3MOol008Qoo`03001oogoo0=eoo`00OGoo1P001Goo00<007oo
Ool0gGoo0028Ool00`00Oomoo`3MOol008Qoo`03001oogoo0=eoo`00QWoo0`00<Goo1000ZWoo0028
Ool00`00Oomoo`0^Ool00`00Oomoo`02Ool00`00Oomoo`2WOol00;Uoo`03001oogoo009oo`03001o
ogoo0:Moo`00BGoo1@00Jgoo00<007ooOol00Woo00<007ooOol0Ygoo0019Ool00`00Oomoo`02Ool:
001QOol00`00Oomoo`02Ool00`00Oomoo`2WOol005Eoo`03001oogoo00X005Moo`03001oogoo009o
o`03001oogoo0:Moo`00HGoo2P000Woo00<007ooOol0BGoo00<007ooOol00Woo00<007ooOol0;Woo
1@00M7oo001[Ool90016Ool4000cOol00`00Oomoo`1dOol006eoo`03001oogoo00Aoo`X007=oo`03
001oogoo07Aoo`00N7oo00<007ooOol00goo2@00JWoo00<007ooOol0M7oo0024Ool00`00Oomoo`0:
001POol00`00Oomoo`1dOol008Aoo`03001oogoo00Qoo`03001oo`0000P00003Ool007oo05Aoo`03
001oogoo07Aoo`00VWoo2P00Bgoo0`00;Woo1@00@goo002KOol00`00Oomoo`06Ool90014Ool00`00
Oomoo`0/Ool01@00Oomoogoo0000@goo002VOol00`00Oomoo`04Ool9001[Ool00`00Oomoo`14Ool0
0;5oo`03001oogoo009oo`X0069oo`03001oogoo04=oo`00_7oo00@007ooOomoo`T005Yoo`03001o
ogoo049oo`00_7oo00<007ooOol027oo00<007oo00002@00DGoo00<007ooOol0@Goo003AOol00`00
Ool000080014Ool01@00Oomoogoo0000@goo003LOol:000kOol30014Ool00=aoo`03001oogoo00Mo
o`T007Uoo`00iWoo00<007ooOol01Woo2P00Kgoo003aOol00`00Oomoo`05Ool9001VOol00?5oo`03
001oogoo00Moo`03001oogoo00Aoo`X005aoo`00ogoo1Woo00<007ooOol017oo2@00Dgoo003oOol@
Ool00`00Oomoo`03Ool:000BOol5000bOol00?mooaYoo`03001oogoo00=oo`D000moo`03001oogoo
039oo`00ogoo97oo00<007ooOol03Goo00<007ooOol0<Woo003oOolTOol00`00Oomoo`02Ool60005
Ool00`00Oomoo`0bOol00?moobAoo`03001oogoo00eoo`03001oogoo039oo`00ogoo8goo0P003goo
00<007ooOol0<Woo003oOolTOol00`00Oomoo`0;Ool3000dOol00?moobAoo`03001oogoo00eoo`03
001oogoo039oo`00ogoo97oo00<007ooOol0@Woo003oOolTOol00`00Oomoo`12Ool00?moob=oo`<0
04=oo`00ogoo97oo00<007ooOol0@Woo003oOolUOol00`00Oomoo`11Ool004=oo`03001oogoo0=io
o`03001oogoo045oo`00@Woo00<002Hl0000gWoo0P00@goo0012Ool00`009Q`Z?@02003MOol00`00
Oomoo`11Ool0045oo`04000V?2Hm9Q`29S`00`00Oomoo`3JOol00`00Oomoo`11Ool0041oo`09000V
72Xm9Q`V?BHL:SdV70000=]oo`03001oogoo045oo`00@7oo00<002Hm9Q`00RHl00@V?BHL9S`V?080
0=Qoo`8004=oo`00?goo00d002Xm9Q`V?BHL:SdV72Hm9Q`Z?BHL9Sd0003HOol00`00Oomoo`11Ool0
03ioo`03000jO@00008V?0069SdV72Hl9S`V?BHL0RHl00<V?@00Ool0eWoo00<007ooOol0@Goo000n
Ool00`00>W`jO@0200002RHL9SdV72Xm9Q`V?BHL:SdV72Hm0P00eGoo00<007ooOol02goo10001Goo
0P001Goo10008Woo000mOol02P00>W`jOCYl>WdjO0009S`V?BHL0RHl00LV?BHL9S`V?2Hm9Q`0003D
Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00
Oomoo`0OOol003eoo`0D000jOCIl>WdjO3Ym=W`002HL9SdV72Xm9Q`V?BHL:SdV70006O/00=5oo`<0
00aoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo01moo`00?7oo00d003Ym>W`jOCYl>Wdj
O3Ym>W`002Hl9SdV70029S`00bHm9Q`000037O`00`00Oomoo`3@Ool00`00Oomoo`02Ool60002Ool0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0OOol003aoo`0G000fO3Ym>W`jOCIl>WdjO3Ym
=W`002HL9SdV72Xm9Q`001Wk7Q`Mnagl6O/0003AOol00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00
Oomoo`09Ool4000ROol003]oo`0<000jO3Ym>W`jOCYl>WdjO3Ym>W`jOCYl0P0000@V?BHL9S`000HM
o003001oogoo0<ioo`03001oogoo00Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo02=o
o`00>goo01X003Ym>W`jOCIl>WdjO3Ym=W`jOCYl>WdfO3Ym000V?@007Q`Mnagl6O/N71gk7O`In`00
cWoo0P0037oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol08goo000jOol04@00B[d00000
>W`jOCYl>WdjO3Ym>W`jOCYl>WdjO3Ym00002Qgl0P00cGoo00<007ooOol02goo100037oo1@008Goo
000jOol07P00A[a:_DJl000jO3Ym=W`jOCYl>WdfO3Ym>W`jO@00:Ud001gl6O/N71gk7O`InahL7O/M
o1Wk7Q`00<aoo`03001oogoo045oo`00>Goo01@004JlA[a6_4ZmA[`003Yl>WdjO3Ym>W`jOCYl>Wdj
O000:S`Z?@002agl00<007ooOol0bGoo00<007ooOol0@Goo000iOol01`00B[e6_4ZmA[a:_DJl0080
000;>WdfO3Ym>W`jOCIl000V?2YM9S`ZG@0200002aWk7Q`Mnagl6O/N71gk7O`InahL0000bGoo0`00
@Woo000iOol00`00A[a:_@03A[`02TZmA[a6_000>WdjO3Ym>W`jO@000bXm00@Z?2Xm:Sd000XMo003
001oogoo0<Moo`03001oogoo045oo`00>7oo02@004JlB[e6_4ZmA[a:_DJlB[e6_4Zm000jOCIl>Wd0
02YM9S`ZGBHl:UdV?2YM9S`001Wk7Q`Mnagl6O/N71gk7O`InahL002mOol00`00Oomoo`08Ool00`00
Oomoo`11Ool003Qoo`03001:_DJl0096_005B[e6_4JlA[a:_@02A[`200001CYl000Z?BXm:S`00bXm
00@Z?2Xm:Sd000XMo003001oogoo0;Qoo`8000aoo`03001oogoo041oo`00=goo02L004ZmA[a:_DJl
B[e6_4ZmA[a:_DJlB[e6_4ZmA[`002Hl:UdV?2YM9S`ZGBHl:UdV?2YM9S`001Wk7Q`Mnagl6O/N71gk
7O`InahL0000]goo0P003Woo00<007ooOol0@7oo000gOol20002A[`01DZmA[a6_4JlB[d00dJl00A:
_DJl000fW@8000<Z?@05:S`Z?BXm:SdZ?002:Sd200097O`00`00Oomoo`2bOol2000?Ool20012Ool0
03Ioo`03001Bg5;l0080000UA[a:_DJlB[e6_4ZmA[a:_DJlB[d003Jn=YdfWP00:UdV?2YM9S`ZGBHl
:UdV?2YM9S`ZG@007Q`Mnagl6O/N71gk7O`InahL000097oo00<007ooOol0RWoo0`004Goo00<007oo
Ool0@7oo000fOol00`00D_aBo002D_`200001DZmA[a6_4JlB[d00TJl00H003JN=YdfWSJM=Yh20002
:Sd01BXl:SdZ?BXm:S`00bXm00<001gl7O`01agl00<007ooOol07goo0P0000@Mf`00000008Qoo`80
01=oo`03001oogoo041oo`00=Goo00P005;lD]aBoE;LD_aBg5;m0P000296_4ZmA[a:_@00=[hfWCJN
<Ydf_SJM=YhbW@009S`ZGBHl:UdV?2YM9S`ZGBHl:Ud001hL7O/Mo1Wk7Q`Mnagl6O/N708001Eoo`/0
00037KXQfafj00H0089oo`8001Eoo`03001oogoo041oo`00=Goo00<005;lD_`01e;l0P000TJl00X0
03JM=YhfWCJN=YdfWSJM=YhfW@800003:SdZ?2Xm008Z?@05:S`Z?BXm:Sd0000:7O`00`00Oomoo`0;
Ool70009:00010006KX001fj0QgK0`0000<d03P000000`00O7oo0`005Goo0P00@Woo000eOol03000
D_eBg5;lD]aBoE;LD_aBg5;mD]aBo080000F=YdfWS:M=[hfWCJN<Ydf_SJM=YhbWCJn000ZGBHl:UdV
?2YM9S`ZGBHl:Ud200002Qgk7O`InahL7O/Mo1Wk7Q`Mn`0027oo100001l400P0000002P0;00X02`0
:00/02P0;00X02`0:00001VJ7K/I^P007KXQfafj000X0000=00h03@0>00d0004001gOol3000GOol0
0`00Oomoo`10Ool003Aoo`03001Bo5;l00YBo00?0012oP00000fWSJM=YhfWCJN=YdfWSJM=YhfWCJN
00800005:S`Z?BXm:SdZ?003:Sd00bXl000Mo0087O`00`00Oomoo`03Ool30007200;00001aVJ000I
^Qfj6KX001fj008Mf`D00006=00h03@0>00d03P01000LGoo100067oo00<007ooOol00goo1000>Goo
000dOol04@00D]aBo5;LD_eBg5;lD]aBoE;LD_aBg5;m00137d;n@al00P00024bWCJn=YdfWS:M=[hf
WCJN<Ydf_SJM000V?2YM9S`ZGBHl:UdV?2YM9S`001gk7O`InahL7O/Mo1Wk7Q`Mn`00Ool00`0000H4
00P0100800@0200400006B00900004@Q@2548D0QA24001VJ000I^QFJ000IVQfk6KX001fj8M/M^P00
@24004aP00D00005=00h03@0>00d0004001[Ool5000IOol00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`0fOol003Aoo`03001Bo5;l00UBo0030012oT;n00A2oP80000<=YhfWCJN=YdfWSJM=Yhf
WCJN=Yd002Xl0bXm00HZ?2Xm:SdZ?BXl00097O`00`00200800042003000690001P00@2508D0QA240
00<EVP09000IVQVJ000I^Qfj6KX001fj008Mf`0500108@00C61@H@03C60500001C@0>00d03P00000
JGoo1@0067oo0`0017oo00<007ooOol00Woo00<007ooOol0=Woo000cOol05P00D_aBg5;mD]aBo5;L
D_eBg5;lD]aBoE;L0012oT<O@_i37d;n@am2oT<O0P0000TfWCJN<Ydf_SJM=YhbWCJn=Yd00P0001@Z
GBHl:UdV?2YM9S`ZGBHl000Mnagl6O/N71gk7O`InahL7O/000@0100000`T0200900P02@0800T0200
900P0000@242000071FJ000IVQFJ000EVQVj5IX001VJ7K/I^P007KXQfafj00108@00C61@HDaPD65<
H51QC61@HDaP1`00IWoo100077oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol037oo0`00
00Aoo`00000002=oo`00<goo0P002U;l00<004;n@_h02D;n0P0000XfWSJM=YhfWCJN=YdfWSJM=Yh0
00<Z?@05:S`Z?BXm:SdZ?00200067O`00`005O`0000?90000`004IX000025IX010005IXEVP000QVJ
00T001fj6KXM^QVj000M^P00:O/00P000TaP00E@HDaPC61<H51Q00=<H004D65<H4aPC604001AOol0
0`00Oomoo`0>Ool5000MOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool01@00Oomo
ogoo000097oo000cOol00`00Gcd0000300007U;LD_aBg5;mD]aBo000@am2oT<O@_i37d;n@am2oT<O
@_i37d;n@al003JN<Ydf_SJM=YhbWCJn=YdfWP80000<9S`ZGBHl:UdV?2YM9S`ZG@007O`InahL0P00
00<Eo1XL5O`00P00028T0200900P02@0800T0200900P02@08000016J000ANP004GXEVP006IXEVP00
5IXI^P007K/IVQfk6KX002Wk;Q/Yn`80000@D65<H51QC61@HDaPD65<H51QC61@HDaPD65<H51QC603
001>Ool00`00Oomoo`0>Ool5000NOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool0
1@00Oomoogoo000097oo000bOol01`00FcaK75/lFaaK?5/L00@00003D_`004;n00i2oP80000:=Ydf
WSJM=YhfWCJN=YdfWSJM0002:Sd02BXl:SdZ?BXm:S`Z?@007O`000025O`01QWl5O`Eo1Gl6O`000XT
0004000AVQ6J4IX200035IX010005IXEVP000QVJ00H001fj6KX002GK0003:O/50003C6001E1QC61<
H4aPD6400daP00A@HDaP0018808004]oo`03001oogoo00ioo`D001moo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo00eoo`05001oogooOol0000TOol0039oo`0;001K75/lFaaO?E/LFcaK75lm
FaaK?003000044<O@_i37d;n@am2oT<O@_i37d;n@am2oT<O@_i37d;n0P0000Pf_SJM=YhbWCJn=Ydf
WS:M0P0001@ZGBHl:UdV?2YM9S`ZG@006O`Eo1XL5O`Io1Gl6Q`Eo1Wl000T02001`0000DAVP004IXA
^a6J0080000B5IXANP005GTIVQFJ000EVQVj000M^`009O/UfP00:O/^6bWk0P0000=Da53400001P00
00M<H51QC61@HDaPD65<H00200000d`P00000017Ool2000?Ool6000OOol20005Ool4000@Ool20002
Ool00`00Oomoo`0ROol0039oo`0>001K?5/LFcaK75/lFaaK?5/LFcaK75/l001?G`@000i2oP80000;
=YdfWSJM=YhfWCJN=YdfWP00:SdZ?003:Sd010004Q`001Wl0aGl00DIo1Gl5O`Eo1Wl0080008d00<0
00054M`0016k4K/000034IX200025IX010005IXEVP000aVJ00<002Gk9M/00RGK00H002Wk:O/YnbXK
0003E<@01E34E<ADa5C4D<@01`000TaP00<004`PB2000P00@goo0`003goo1P008Goo00<007ooOol0
5goo00@007oo000002Eoo`00<Woo018005/LGceK75/lFaaO?E/LFcaK75lm001?Od]NCgm?GTmoBeh4
000034<O@_i37d;n@am2oT<O@_i37d;n@am2oP800007=YhbWCJn=YdfWS:M=[h00P0000HV?000000B
7@gl4Qd2000021Gl6Q`Eo1Wl5O`J71Gl6O`30000<1YM000F7@004M`0016k4IX0016J4K/001FJ000E
VQ5j000ENAVJ000I^P008M/002Gk8MXUnbGJ000YnbhK:O/^6`00E<A@a5C4D<=Da534E<A@`eC4D<AD
a533E<A@a0D00003B21<8000008003ioo`@000ioo`D00003Ak`007oo025oo`03001oogoo01Moo`03
001oogoo02Ioo`00<Goo01L005/LFcaK75/lFaaK?5/LFcaK75/lFa`004mNCgm?GTmOCei?OdmNCem?
GTmo00@000Y2oP800006=YdfWSJM=YhfWCJN0P0000PAo18L4O`B717l4Q`Ao0000aGl00HIo1Gl5O`E
o1Wl5O`200001QXm000000004M`0008A^`06000AVQ6J000AVP000QFJ00T001FJ5IX0027K7KXQf`00
9O/00RGK00<002XK:O/00RWk00<Z6`00E<@00UC400E@a5C4E<ADa53400=Da006D<ADa5C4E<A@a5C4
100000A884`P000003Yoo`D000eoo`H00003Ak`007oo029oo`03001oogoo01Ioo`8002Qoo`00<Goo
01/005lmFaaK?5/LGceK75/lFaaO?E/L001;GTmoCei?Od]NCgm?GTmoBei?OdmNCgm;GTmoCeh01000
00Q37d;n@am2oT<O@_i37d;n0P0000Hf_SJM000000hm2Q`20000418M4O`B7@gl4QdAo0005O`J71Gl
6O`Eo1XL5O`Io1Gl0P0000<JGAHm0000100000@AVP004IXA^`8000034GTEVQ5j0080000T6K/0027K
7KXQf`009O/QfRGk000^6bWk;Q/003Hl001Da534E<A@`eC4D<ADa533E<A@a5C4D<=Da534E<A@``00
D81DXE200`0000=880000000=Woo1@003Goo2@008goo0`00@Goo000aOol07`00FaaK?5/LFcaK75/l
FaaK?5/LFc`004moCei?GdmNCgm?GTmOCei?OdmNCem?GTmoCei?GdmNCgm?GTmO00@000E2oP<00003
3S`>?@Xl008>?0083Sd0018L4O`B717l4Q`Ao080008Eo0066O`Eo1Gl5O`Io1Gl0`0000PF?@005O`0
017K000A^`000Q6J0P0000@EVP004IX0008I^P06000Qfafj8M/002Gk0RGK00@002XK:O/0008f>`05
001Da5C4E<A@a003E<@01E34E<ADa5C4D<@00eC400M@a000D85DPE20E85@P@0200000d`P0000000c
Ool5000=Ool9000UOol00`00Oomoo`10Ool0031oo`0G001K75/lFaaO?E/LFcaK75lmFaaK?000Cgm?
GTmoBei?OdmNCgm;GTmoCei?O`0B00000`YK2W`:F`0200001@hm2Q`>?@XL3Sd00P0000lAo18M3O`B
7A7l4Qd001XL5O`Io1Gl6Q`Eo1Wl5O`01`0000HA^`004IX0016J4K/200003Q6J5K/AVP006IXI^`00
8M/M^R7K000Unb7J9O/20000738K=S`f>cHl001Da534E<A@`eC4D<ADa533E<A@a5C4D<=Da534E<A@
``00D81DXE20E:5@P5BQ1@00;Woo1`0037oo200000=;OP00Ool09Goo00<007ooOol0@7oo000`OolG
0006Ekh500000e?K001K_@020002Ool700001@Xl3S`>?0hm2S`00P0000HB717l4Q`Ao18L00025O`0
1QWl5O`Eo1Gl6O`Eo0`000071GX000004IXEVQ6J00000QVj00H0027K7KXQf`009O/29M/00`00=S/f
>`03=S/20002E<@01E34E<ADa5C4D<@00eC400i@a5C4E<ADa000E85@PEB1D81DPE21E85@P5B11000
:Woo20002goo200000A?Wd]nCgl002Moo`03001oogoo03moo`00;goo00`006=lGeaSOEmLHgaOG6=m
GeaSO5mL0002Ekh01ENMEkiG_UNnEid00eNn00AGWENnEkiG_PL00003Dm]?fU?K008000Qoo`H0000:
2Q`>?@XL3Sd0018M3O`B7A7l4Qd200002QGl6O`Eo1XL5O`Io1Gl6Q`003`0100000H1F@000ET000Ei
1GX200005A6J5K/AVP006IX001fj8M/M^R7K000Un`00<Q`003Hl<Q/f?3Hk=S`b6`0900004U34E<A@
`eC4D<ADa000E:5@P5BQD81DXE20E:5@P5BQD81DX@<002Eoo`X000Yoo`T00004Cim;OTnO000WOol2
0011Ool002moo`03001SG6=L00QSG003001G_UNn00QG_PT00003CmYCfe?K008000moo`<000033Sd:
?0hl008000084O`B717l4Q`Ao0005O`Io0<Eo0066O`Eo1Gl000l03P01@0000T1NP001GX000ej000A
VQFJ00000QVj00H001fj8M/M^R7K0003;Q/00`00=S/f>`04=S/01@00FDUIBUU900000eU:3P0000MD
PE20E85@PEB1D81DP@03000NOol;00000e>d001oo`09Ool9000014nOBgi?O`00:Goo00<007ooOol0
?goo000^Ool03P00GeaSOEmLHgaOG6=mGeaSO5mLHgd005NnEid3Ekh00eNMEkh0000400002E_l0000
0000AkP005?KCmYCf`02000DOol300005@hm2Q`000gl4QdAo18M3O`001Gl6O`Eo1XL5O`Io1Gl6Q`0
03`0>00l00040000<05I0005N@002GX0016J5K/001Vk6IX001fj8M/002XL000b72hK<Q`003Hl<Q/f
?3Hk=S`b6`00FDUIBUTY001IBEU:FDUIBUU9FDX005U:FDUIBUTYFDYIB@00EBQI:@h001Moo`<00003
400000P000T000Uoo`T00005Bgi?Wd]nCil0000ZOol00`00Oomoo`0oOol002ioo`03001SG6=L00MS
G003001G_UNn009G_PD000AKg0800005AiL00000Dm]?fP02000IOol200001`hl0000018L4O`B717l
008000056O`Eo1Gl5O`Io0025O`200000cP0?00h000500001`Ej000=NP004IXEVP00008I^P03000M
^P00008Un`04000^6bhK;Q/20003=S/01P00?U/005U9FDX000IIBP0H001IBEU:FDUIBUU9FDX005TY
EBQI:ETXFBUE:000E>IE1eCVE@MDiUD7001@PTb21`003Woo0`000Q002`0027oo2P0000=?OdnOBgh0
0P00:goo00<007ooOol0?goo000^Ool02P00GeaSO5mLHgeOG6=lGeaSOEmL1P0000EKoEOLFoaGg5_m
00H00004CmYCf`00000MOol200005@hm0000017l4Qd=o18M000Io1Gl6Q`Eo1Wl5O`J71Gl000h03`0
>00l000400006@Ei0009NP004IXE^`006K/IVP009O/YnbGk:Q`0038L;Q/b72hK000b6cHl000nO3iK
0080000SFDX005U:FDUIBUU9FDYIB@00FBUIBUU9FDYI:EU:001I:EDXFBUE:5TY001E1eCVE@MDiUD7
E>IE1`00D:=<PU2SC89@X`0200000c`00000000=00000``04000000200000`P00000000400000eoH
001oo`05Ool@000]Ool00`00Oomoo`0oOol002eoo`03001SG6=L00ISG0<000QKg0@00004AkL005?K
Dm/2000QOol400001Q7l4Q`Ao18L000Io0<Eo0096O`Eo1Gl5O`003P0?00h03`000D000053IX=NP00
4IXEVP0200000agK000Un`039O/00`00;Q/^6`02;Q/200001Cil?U/nO3iK?W`0:@0000<l03P00000
20000Q0000@000`0000400H00003GoP007oo00=oo`H0008@00H0009;7P03Aah007oo02aoo`80045o
o`00;Goo00H006=lGeaSOEmLHg`4000025OLFoeGg5_lEmaKoEOLFo`700000e?K0000000VOol30000
0a8M3O`B7@0200001aGl6Q`Eo1Wl5O`J71Gl00@00003?000000000<000063IX9NP00000E^`000QgK
02T002Gk:O/UnbXL000b72hK<Q`^6`00?U]2O3iK?W`nFd9l001IBUDYFDYI:EU:EBT005DYFDYE:EU:
EBUIBP00EBUE25DYE@QE:ED8EBT0053X009@i`0;D<M@j53WD>L004b4B8A<Q4QSC8A8Q00500001C@0
>0400000;0400P0000<X0B@100002P0000=Of00000001`000Q0000<<00000000100000I;?dLNBcm7
7T/o000^Ool00`00Oomoo`0oOol002eoo`03001SG00000<000=WW003001Kg5_L00AKg0<00007CkL0
0000001?fU?K0000:Woo0P0000DB717l4Q`Ao00000<Eo0046O`Eo1Gl5O`200000cP0000000060000
1@FJ000A^aFk00000QgK00<002Gk9O/00RGk00`002hK;Q/003IL000nFcil?U/nO3iK?W`200005EU9
FDYIBEU:FDT005DYFDYE:ETYEBUIBP00EBUE2EDYE@UE:ED9EBT00006D>L00`00B8A8Q0040002A6D0
0`00=00d000200000c0100000003:04200001B01000D0@0030000`0000=On@000000100000<T0000
000011001P000d/N00=77T/N0000;goo00<007ooOol00goo10001Goo0P001Goo1000:7oo000]Ool2
00002f>LIiaSW6NmHiaWW000FoeGg5_lEm`0200000ACfdoJ000002eoo`80000B3O`B7A7l000Eo1XL
5O`Io1Gl6Q`Eo1Wl000l03P0?00005220`0000H9V`Ej000AVQFk00027M/2000022Wk9O/Z7000<Q`0
03YL=S/200001T9l?U/nO3iK@W`nF`80000EFDYI:EU:001IBUDYFDYE:EU:EBT005D8EBUE25DYE@QE
:ED8001@ae3X009@i`D00006A8E4I4AUA6A4QDAT0`0000</0@0000000bP100PT0@00704P0@006040
00`00`0000=Sn@0000000P0000DT02P0000000`000<@00H00008Aai;?dLNBcm77T/oAah002moo`03
001oogoo009oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo
02Eoo`00;7oo00<006NLIi`01VNL00<005_LFm`00P000UOJ00<004ng00000P0000=Cf`000000<Goo
0P0000@B717l0000008Eo0046O`Eo1Gl5O`20002>0000`00C65<P@0300021IX010004K/E^`000agK
00H002Gk9O/Un`00>U`3=U`01cYL000nO3iK?W`nF`000096W080000>FDUIBP00FBUE:EU:EBUI:EDY
001E2EDYE@UE:@L000A<a`030014I4AU00@00004?4E0A@000004:04200000b010000000200001@`0
00000000GoT00P000b@000<X0000400011001P0000E77T/NBai;7TLN009;7P03001oogoo02aoo`<0
00Aoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo02Eoo`00;7oo00X006>LIiaSW6NmHiaW
W6>L001Gg0800003EoYGf@0000@00003;c<0000003Eoo`<000044Qd001XL5O`30000218L5Sd00000
>00004aQD88300001PVK1GX0016J5K/0008Mf`0D8O/002Wk000b?000>U`f>cYL=S/jG000@W`nFcil
001:W4JKAYa6V`h0000;D@U@j5D9D>P004S7C<Q<adc8B<M<b00300001D15?4A0AC`T@4D00P0000<d
9000:0400P0000HP0A`1000D0@002002000026OkIm/00000:00T02P0900200000a00300@00024005
00002T/oAai;?dLNBcm77T/oAai;?`00<7oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
3Goo00<007ooOol09Goo000[Ool00`00IiaWW006Ii`20003EmX00`00CkL0000200000c<d001oo`0h
Ool500074Sd300000daQC85<H@0300001@FJ000A^aFk00000agK00@002hl;S`^?08000<fG004>U`0
00000007AY`200003eD9EBUE:EDYE@UE:@00D@U@j549D@QA2E3XD@T00004C<L200000dRWA:L00003
?4D2000013PT=2@h93@T0P000R0100<001@100000P000VOk00AWf`00000X008T008000D@00H00003
Bai77T/N009;7P05Aai;7T/NBah0000aOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool4000XOol002]oo`07001WW6>LIkeSW6NLHi`00P0000=GnU?IEoX00P0000A;]`00000cE08003ao
o`@000084Q`F?A8L5SdB71Hm4Q`F?@80000SC65@PTaQ0001F@001GX0016J5K/001gK000V7000;S`^
6c8l;S`003Hk>U`f>cYL=S/004JKAYa6VdZLAY]6W4JKBYa6V`0300003UD9EBUA2EDY001A2E3XE@U@
j549D>QE2@00C<P200001TB7B:M4QTRW0010A@800004=2@h9C@T>2D200000b`3<0@0000400000fOk
Hm]Wn`03000012P0900000000a0000<<010040001P0000=6gP0000000P0000=77T/oAah00P00<Woo
00<007ooOol00Woo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0:Goo000[Ool00`00IiaW
W002Ii`200000f?L001GfP0200001Tng00000000<c@0041oo`@000PB?@80000;C85<H@000ET000FJ
000A^aFk000V70028Q`00`00;S`^?002;S`01P00=U`fG3IL000nO08000M6W003001>g4kL00800007
EBUE2@00D@QA2E3XD@T01@0000I8YdBWB:M4YdRWA:L2000013PT=2@h93@T0P000b`30`000VNl00T0
06Ok000005oj000X02@000001Q001P0000M2_D;M@[e2gD:m@]e2_@03000dOol00`00Oomoo`02Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0YOol002Yoo`04001SW6NmHi`200001fOLHm`0
05?I001;]doG00800003;c<0000004=oo`@0000;4Q`F?A8L5SdB71Hm4Q`F?@00D89<H@0600002QGl
000V727l9Q`002hl;Q/b?2hl0P00014jG000@YdnO4:M0016W4JKBYa6VdJLAY/004jlC]a>_4kL00L0
0009C>Q<b4cXC<L004B7B:M4QTRW00800004?6I0IP00>2D200000b`3<0@/0`0300000f>lImeS_003
000015_IGoX002P00P0000H<0100400@00`0400600002T:mA]i2_D;N@[e6gT:m@]i2_@00=7oo0P00
1Goo100037oo1@009goo000ZOol01000Ii`000000VOL00ESg6OL000004ng00<00003<c<007oo04Io
o`@000LB?@80000:C64000000005VP004M/Eg0009Q`28Q`20004;S`01P00@Y`nW4:L?Wa2W08000=6
W003001>g4kL00I>g0D00006C>Q<b4cX0018YdBW0P00141V0P0000</0`0000000`001FNl00<005oj
FmT010001Q001`0000]2_D;M@[e2gD:m@]e2_D;M@[e2g@0003Eoo`03001oogoo03moo`00:Woo0P00
00QWg6?LImaSg6OL001?f4^g1@00BWoo100000LB71Hm4Q`F?A8L5SdB700800002aGl000V727l9Q`Q
o000;Q/b?000=Wd00P0000DnO4:M?Wa2WCil0080000?BY`004kLC[a>g4jlC]a>_4kLC[`005;lEaeB
o5LM00l00008HieOO6>MHg`006>lImeS_0800003GoYKf@000080008@0005300@0100400<00060000
34;N@[e6gT:m@]i2_DKN@[e2gT:mA]h003Ioo`03001oogoo03moo`00:Goo00<006?LIm`00VOL00AS
g000001?]`<00003<c@007oo04ioo`<000LB?@D000031I/001GL008000<R7003000^?00000<fO@07
000nW4:L?Wa2W3jL@Y`00P0024kL01P005LLE_aG75KlEaaFo5LL001OGE/lFceK?5mMFcaK?@00HieS
O6=mHgaSWF=l0002Ik`300000eoj000000040004400700003D;M@[e2gD:m@]e2_D;M@[e2gD:m@]e2
_@0003Ioo`03001oogoo03moo`00:Goo00@006OLHmaWg0<00003CmP0000000<0059oo`<000094Q`F
?A8L5SdB71Hm4Q`004000080000>1I/001Gl4M/0027l9Q`Qo000=W`jOCIl=WdfO0800006@YdnO4:M
001:gDJl0P0001e>g4jlC]a>_4kL001G7E;lEaeBo5LMD_aG7E;l001K?5mMFcaOGE/lGeeK?000HgaS
WEmlHieSO6>M00<00003HoaOg00000800005800T0200900P000900003SYl?Yd00000@[e2gT:mA]i2
_D;N@[e6gT:m000gOol20010Ool002Qoo`07001Wg6OLIm`005_kFoX01@00EWoo0`001Q8m1`0000DE
g0008Q`002YM008000DfO@800006?W`004KMB]e6gD[M0`000TkL01H005KlEaaFo5LLE_aG75Kl001K
?5/mFcaOGE/lFceK?000HgaSOF=lHieSO0<00003GmaSg00000<00006800T0200900P02@01P0000<J
7@00>W`00Sil00/nWCYl000004;M@[e2gD:m@]e2_@0003Qoo`03001oogoo03moo`00:7oo00H006?L
000005_kFmX4001JOol300001Q8L5SdB71Hm4Q`F?@P0000D9UdZGBIM:Ud003Ym=W`fOCIl>WdfO000
A[a:gDJlB]e6_4[MA[a:g@D0000?EaeBo5LMD_aG7@00GeeK?5mMFcaOGE/lGed006>M00D00003HoeO
g00000<00005900P02@0800T0006000031XL6SdJ7000>W`nWCYl?YdjO3jM>W`nW@800004@[e6gP00
000iOol00`00Oomoo`0oOol002Moo`<00003FmYKn`0000@005eoo`<000HB?@P000<ZG@8000<fO@0?
000n_P00001:gDKMB]e6gD[MA]d004lMDae?7E<M00l00004GkeOWEnmGkd300001e?K000P02@0800T
020000H000066SdJ71XM6Qd003Yl0Sil00HnWCYl?W`nO3jM>W`2?W`2000lOol00`00Oomoo`0nOol0
02Moo`04001One_JFo/4001QOol300001Q8L5SdB71Hm4Q`F?@<000080K/001HM000ZGBIM:UdVG@80
0005=Wd004;N?[e2gP0200006TJlB]e6_4[M001C7TlMDai?7E<NCaeC7P00FgiGGE]nEeeKOUMMFgh0
05nnFieO_UnMGkh300001U?K00000200900P00L0000C7O/R7000000J7000>W`nWCYl?YdjO3jM>W`n
WCYl?YdjO3jM0000?Goo00<007ooOol0?Woo000VOol01000Fo]KfU_k0`00IGoo0`00118m2@0012YM
0P0000Dn_CkN?[hngSjm0080000CB]d005<MCaeC7DlMDae?7E<MCad005MMFeiGGEMNEeeKGUMM0000
0Unm00EOW@00000005?J00<000038000000000H000088Q`Qo28L8O`R727l000jO08nO006?YdjO3il
?W`nWCYl0Sil00<nW@00Ool0?7oo0P00@7oo000UOol00`00Go]KfP03001YOol5000010ik4Y`>O0jL
1`0000@ZG@00<[l^WP800005@]hn_D;N?[e2gP0500003U<NCaeC7TlM001GGE]nEeeKOUMMFgiGG@00
Fid300000e>m0000000:00001b8L7O`R71gk8Q`Mo28L0080000>=U`00000?YdjO3jM>W`nWCYl?Ydj
O3jM>W`003ioo`03001oogoo03ioo`009Goo00<005_J00000P00K7oo00<T000000000P001Pil1@00
0bjn00Tb_P00000003kN?[d004LNAal00TLN3P0000=C_E>n00002`0000TUnbHL0000027l8Q`Qo28L
00001CIL0P0000<nO3jM>W`00Sil00<nWCYl0000?goo00<007ooOol0?Woo000TOol4001cOol40000
0`ik4Y`>O00200002A:L00000000<[l^WS:n;Yhb_`0300003d/oAai;?dLNBcm77T/o001CWdmnCgm?
OU>OCgi?O`0?000022XL9O/Z72Gk:Q`Un`007O`2000023YL=U`jG3Hk>U`fG3YL=S/200001CjM>W`n
WCYl0000@7oo00<007ooOol0?Woo000TOol2001iOol400033W`00`6h0000000200000c:n;[h00002
=al40003Aah01000Cgi?Odmn1@0000<kVcnK>i/01P0000d^72hK;Q`002HL9O/V72Gk9Q`UnbHL9O/0
000<=U`200000cYl001oo`0oOol20010Ool0029oo`8007moo`@000030KT0000000H00004=alfoc/O
=al700001100000000ZF0`00014fG000;S`Z6bhl:Q/^?2XK;S`Z6bhl000Z72Gk:Q`UnbXL0080000@
;S/003IL>U`f>cYL=U`jG3Hk>U`fG3YL=S/jG3IL0012Ool00`00Oomoo`0nOol0025oo`03001oogoo
08=oo`@000033W`0000000l000=oo`0A000fG38l=U`002hL;Q/^72hK;Q`^6bhL;Q/^70009Q`Un`02
0004<S`2000:=U`00`00Oomoo`11Ool00`00Oomoo`03Ool5000fOol0021oo`03001oogoo08Qoo`/0
00]oo`04000fG38k=U`2000022XK;S`Z6bhl:Q/^?2XK;S`200004S8k<S`^>c8l<S/b?2hk<S`003YL
=S/jG3IL>U`f>cYL=U`004Aoo`03001oogoo00Eoo`03001oogoo03Ioo`00`Woo00/003IL<S`fG38l
000^6bhL;Q/^72hK00800003;S`0038l00Pb?003000fG3IL00@fG003001oogoo04=oo`03001oogoo
00Eoo`03001oogoo03Ioo`00`goo00P003IL<S/fG38l000Z6bhl0P0000hZ72hl:Q`^?000<S`b>c8l
;S/b?38k<S`^>c8l0P0000@f>cYL000004Aoo`<000Moo`03001oogoo03Ioo`00a7oo00@003IL<S`f
G0<00008;S`Z?2hl:Q`^?2Xl;S`000Xb?080049oo`03001oo`00008000Uoo`03001oogoo03Ioo`00
aGoo0`0000/V?BHl000Z72hl:Q`^?2XL;S`Z72hl00800008<S/b?2hk<S`b>c8l;S/003moo`04001o
ogooOol3000<Ool00`00Oomoo`0fOol00<Ioo`80000>9S`V?BHm000Z72hl:S`^?2XL;S`Z?2hl:Q`0
00Hb?003001oogoo03eoo`@000eoo`<003Qoo`00b7oo0180028L9SdV?000:Q`^?2XL;S`Z72hl:Q`^
?2XL000b>c8l;S/2000kOol00`00Oomoo`03000BOol00`00Oomoo`0fOol00<Uoo`80008V?@800007
;S`Z?2hl:Q`^?2Xl;S`01000?Goo0`00CWoo003;Ool02@009SdV?2Hm000^?2XL;S`Z7002000kOol0
0`00Oomoo`03001AOol00<aoo`8000049Sd00000;S`2000hOol00`00Oomoo`02Ool3001DOol00<io
o`04001oo`00000jOol00`00Ool00002000DOol5000nOol00?moo`Qoo`04001oogooOol3000GOol0
1@00Oomoogoo0000?Woo003oOol8Ool4000KOol00`00Oomoo`0oOol00?moo`=oo`03001oogoo00<0
01moo`03001oogoo03ioo`00ogoo0goo0`008goo00<007ooOol0?Goo003nOol4000WOol00`00Oomo
o`0lOol00?Uoo`03001oogoo00<002Ioo`05001oogooOol0000nOol00?Eoo`04001oogooOol3000Z
Ool3000oOol00?Eoo`03001oo`00008006ioo`00l7oo00@007ooOomoo`<001=oo`D005Uoo`00l7oo
100067oo00<007ooOol0FGoo003/Ool00`00Ool00002000KOol00`00Oomoo`1IOol00>Qoo`03001o
ogoo00<001ioo`03001oogoo05Uoo`00i7oo00@007ooOomoo`<0025oo`03001oogoo05Uoo`00h7oo
00@007ooOomoo`@002Aoo`03001oogoo05Uoo`00h7oo00<007oo00000P009Goo0`00Fgoo003LOol0
0`00Oomoo`03000ZOol00`00Oomoo`1IOol00=Uoo`03001oogoo00<001Aoo`@0075oo`00eGoo00@0
07ooOomoo`<001Ioo`03001oogoo009oo`03001oogoo06ioo`00eGoo10006Goo00<007ooOol00Woo
00<007ooOol0KWoo003>Ool01000Oomoogoo100077oo00<007ooOol00Woo00<007ooOol0KWoo003>
Ool00`00Ool00002000OOol00`00Oomoo`02Ool00`00Oomoo`1^Ool00<ioo`80029oo`03001oogoo
009oo`03001oogoo06ioo`00lWoo00<007ooOol00Woo00<007ooOol0KWoo003SOol5000;Ool4001a
Ool00>Eoo`03001oogoo081oo`00iGoo00<007ooOol0P7oo003JOol60005Ool00`00Oomoo`20Ool0
0>Eoo`03001oogoo081oo`00iGoo00<007ooOol0P7oo003?Ool5000?Ool30022Ool00<moo`05001o
ogooOol0000AOol00`00Oomoo`20Ool00=1oo`03001oogoo09Eoo`00agoo1P0017oo00<007ooOol0
U7oo003BOol00`00Oomoo`2COol00==oo`03001oogoo099oo`00cgoo00D007ooOomoo`0001moo`80
009oo`8006moo`00d7oo0`008Goo00@007ooOol0071oo`00mGoo0P00LGoo003eOol2001aOol00?Ao
o`04001oogoo001`Ool00?=oo`80009oo`8006moo`00ogooJGoo003oOomYOol00?moofUoo`00ogoo
JGoo003oOomYOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {191.188, 0}} -> {-0.0237361, 0.126683, \
0.00432707, 0.00432707}}]
}, Open  ]],

Cell[TextData[{
  "In the above figure, we observe that the tangent surface is located below \
the surface ",
  StyleBox["h",
    FontSlant->"Italic"],
  ". The tangent surface is plotted for a smaller interval in the ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  " directions to prevent intersections of ",
  StyleBox["h ",
    FontSlant->"Italic"],
  "and the tangent surface. This example shows that the one-dimensional \
notion of a tangent can be generalized to a two-dimensional version. This \
generalization is not restricted to two dimensions but can be extended to \
higher dimensions. Since the higher-dimensional cases cannot be represented \
easily by graphics, we suppress a further discussion of these tangent \
surfaces."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "This section was intended to show how a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function for a derivative can be defined if we know an appropriate \
mathematical definition. We also notice that not every mathematical \
definition is an efficient definition for an implementation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". An essential point to efficiently implement a mathematical relation in ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a mathematical definition based on structures which are basic elements \
in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". In the case of the ",
  StyleBox["TangentVector[]", "MmaText"],
  " function, it was essential that we used the pattern matching of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in the replacement rules. The application of such simple operations \
allows us to write refined functions. In the next section, we will come back \
to a derivative already known by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the total derivative."
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3 The Total Derivative", "Section",
  Evaluatable->False,
  CellTags->"total derivative"],

Cell[TextData[{
  "Let us consider functions ",
  StyleBox["f",
    FontSlant->"Italic"],
  " depending on a set of independent variables ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "= ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\((x\_1\),
                "TraditionalForm"], ",", \(x\_2\)}],
            "TraditionalForm"], ",", "\[Ellipsis]", ",", \(x\_n\)}], 
        TraditionalForm]]],
  ") and a set of dependent variables ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1, 2, \[Ellipsis]\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  " represents all possible derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u = \((u\^1, u\^2, \[Ellipsis], u\^\[Alpha])\)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "with respect to the independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". We are interested in the derivative of these functions with respect to \
all independent variables. If we assume that ",
  StyleBox["u",
    FontSlant->"Italic"],
  " depends on the vector ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", we must consider all derivatives of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  ". In other words, we obtain the total derivative of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "by differentiating ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", while treating all the ",
  Cell[BoxData[
      \(TraditionalForm\`u\^\[Alpha]\)]],
  "'s and their derivatives as functions of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{"dependent variables", "independent variables"}],

Cell["Definition: Total derivative", "Definition",
  CellTags->"Definition: Total derivative"],

Cell[TextData[{
  "The total derivative of a function ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, u\_\((k)\))\)]],
  " with respect to the independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " is given by"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(D\_i\) f\), " ", "=", "  ", 
        RowBox[{\(\[PartialD]f\/\[PartialD]x\_i\), "+", 
          StyleBox[
            UnderoverscriptBox[
              StyleBox["\[Sum]",
                ScriptLevel->0,
                FontFamily->"Times",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              \(\[Alpha] = 1\), "q"],
            ScriptLevel->0], 
          StyleBox[
            UnderscriptBox[
              StyleBox["\[Sum]",
                FontFamily->"Times",
                FontSize->8,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], "J"],
            ScriptLevel->0], " ", 
          \(u\_\(J, i\)\%\[Alpha]\ 
            \[PartialD]f\/\[PartialD]u\_j\%\[Alpha]\)}]}], TextForm]], 
  "NumberedEquation",
  Evaluatable->False,
  FontVariations->{"CompatibilityType"->0},
  CellTags->"eq-7"],

Cell[TextData[{
  "where for ",
  Cell[BoxData[
      \(TraditionalForm\`J = \((j\_1, j\_2, \ \[Ellipsis], j\_j)\)\)]],
  ","
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TextForm
    \`\(u\_\(J, j\)\%\[Alpha]\  = \ 
      \(\[PartialD]u\_j\%\[Alpha]\/\[PartialD]x\_i\  = \ 
        \[PartialD]\^\(l + 1\)u\^\[Alpha]\/\(\[PartialD]x\_i 
            \[PartialD]x\_\(j\_1\) \[PartialD]x\_\(j\_2\) \[CenterEllipsis] 
            \[PartialD]x\_\(j\_l\)\)\), \)\)], "NumberedEquation",
  Evaluatable->False,
  FontVariations->{"CompatibilityType"->0},
  CellTags->"eq-8"],

Cell[TextData[{
  "and the sum in ",
  ButtonBox["(3.7)",
    ButtonData:>"eq-7",
    ButtonStyle->"Hyperlink"],
  "  runs over all ",
  StyleBox["J",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s of order ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(0\  \[LessEqual] \)\  | \(J | \ \( \[LessEqual] \ k\)\)\)]],
  " with ",
  Cell[BoxData[
      FormBox[
        RowBox[{"|", 
          RowBox[{\(J | \), " ", "=", " ", 
            FormBox[\(\[Sum]\_\(i = 1\)\%l j\_i\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ".  ",
  StyleBox["k",
    FontSlant->"Italic"],
  " is the highest order of the derivatives occurring in ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\[ThickSpace]\[EmptyCircle] "
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " analogue of this definition is available by the function ",
  StyleBox["D[],", "MmaText"],
  "  which ",
  ButtonBox["S. Wolfram [1991]",
    ButtonData:>{"Literat.nb", "Wolf-91"},
    ButtonStyle->"Hyperlink"],
  " calls a partial derivative. Showing the equivalence of both notions, let \
us demonstrate the action of the function ",
  StyleBox["D[]", "MmaText"],
  " by considering a simple example."
}], "Text",
  Evaluatable->False,
  CellTags->"D[]"],

Cell[TextData[{
  "Let us examine a function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", " ", "=", " ", 
          RowBox[{"x", " ", "u", " ", 
            FormBox[\(u\_xy\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`u\  = \ u(x, y)\)]],
  " is a function of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ". We apply the function ",
  StyleBox["D[]", "MmaText"],
  " on this expression in two steps. First, we use ",
  StyleBox["x",
    FontSlant->"Italic"],
  " as the variable of differentiation, and in a second step, we \
differentiate with respect to ",
  StyleBox["y",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = x\ u[x, y]\ \[PartialD]\_\(x, y\)u[x, y]; 
    f // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(u\ x\ u\_\(x, y\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[f, x] // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(u\ u\_\(x, y\) + x\ u\_x\ u\_\(x, y\) + u\ x\ u\_\(x, x, y\)\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[f, y] // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(x\ u\_y\ u\_\(x, y\) + u\ x\ u\_\(x, y, y\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing the results obtained by ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "with the ",
  ButtonBox["definition",
    ButtonData:>"Definition: Complete derivative",
    ButtonStyle->"Hyperlink"],
  " given above demonstrates the equivalence of both notions. Higher-order \
total derivatives are defined by a repeated application of the single \
operator ",
  ButtonBox["(3.7)",
    ButtonData:>"eq-7",
    ButtonStyle->"Hyperlink"],
  " with different variables of differentiation. If ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[
                RowBox[{
                  FormBox[\(J = \((j\_1\)\),
                    "TraditionalForm"], ",", \(j\_2\)}],
                "TraditionalForm"], ",", "\[Ellipsis]", ",", \(j\_m\)}],
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " is a ",
  StyleBox["m",
    FontSlant->"Italic"],
  StyleBox["th",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["-",
    FontSlant->"Italic"],
  "order multi-index, with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(1 \[LessEqual] j\_m \[LessEqual] \),
            "TraditionalForm"], "p"}], TraditionalForm]]],
  " for each m, then the ",
  StyleBox["j",
    FontSlant->"Italic"],
  "th total derivative is denoted by"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "higher order total derivatives", "multi index", "total derivative"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(D\_J\), " ", "=", " ", 
        RowBox[{
        \(D\_\(j\_1\)\), "\[NegativeVeryThinSpace]", \(D\_\(j\_2\)\), 
          "\[CenterEllipsis]", " ", 
          RowBox[{
            SubscriptBox[
              StyleBox["D",
                FontSlant->"Italic"], \(j\_m\)], "."}]}]}], TextForm]], 
  "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "For example, we find the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(D\_x\),
            "TraditionalForm"], \(D\_y\)}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(D\_y\),
            "TraditionalForm"], \(D\_x\)}], TraditionalForm]]],
  " derivatives by successively applying ",
  Cell[BoxData[
      \(TraditionalForm\`D\_x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\_y\)]],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we can realize this by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(df1\  = \ D[D[f, x], y]; df1 // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(u\_y\ u\_\(x, y\) + x\ u\_\(x, y\)\%2 + x\ u\_y\ u\_\(x, x, y\) + 
      u\ u\_\(x, y, y\) + x\ u\_x\ u\_\(x, y, y\) + 
      u\ x\ u\_\(x, x, y, y\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(df2\  = \ D[D[f, y], x]; df2 // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(u\_y\ u\_\(x, y\) + x\ u\_\(x, y\)\%2 + x\ u\_y\ u\_\(x, x, y\) + 
      u\ u\_\(x, y, y\) + x\ u\_x\ u\_\(x, y, y\) + 
      u\ x\ u\_\(x, x, y, y\)\)], "Output"]
}, Open  ]],

Cell["\<\
Subtracting both representations of the mixed derivatives from each \
other, we get\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(df1 - df2\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "It is obvious that both expressions contain the same result. This implies  \
that we can commute the ",
  Cell[BoxData[
      \(TraditionalForm\`D\_x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\_y\)]],
  ". In general, we can interchange the ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  "\[CloseCurlyQuote]s in the calculation in any order."
}], "Text",
  Evaluatable->False,
  CellTags->"commutation of derivatives"],

Cell["\<\
Another representation of derivatives instrumental in the \
calculation of symmetries is the prolongation. A prolongation is not a \
completely new derivative; however, it introduces a geometrical concept in \
the manifold, allowing a greater flexibility in the use of coordinates.\
\>", 
  "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4 Prolongations", "Section",
  Evaluatable->False,
  CellTags->{"Prolongations", "prolongation"}],

Cell[TextData[{
  "In the calculation of symmetries, we frequently have to calculate the \
prolongation of a given system of differential equations. Here, we first \
define the term prolongation for a function. In S",
  ButtonBox["ection 3.7,",
    ButtonData:>{"derivat1.nb", "Prolongation of vector fields"},
    ButtonStyle->"Hyperlink"],
  " we will discuss the application of prolongations to vector fields. This \
definition is extended to differential equations in an additional step in S",
  ButtonBox["ection 4.2.5",
    ButtonData:>{"symmet1.nb", "Prolongation of Transformations"},
    ButtonStyle->"Hyperlink"],
  " for ODEs and in S",
  ButtonBox["ection 5.4.1",
    ButtonData:>{"symmet5.nb", "Calculation of prolongations"},
    ButtonStyle->"Hyperlink"],
  " for PDEs. "
}], "Text",
  Evaluatable->False,
  CellTags->{"prolongation", "vector field", "ODE", "PDE"}],

Cell[TextData[{
  "The term prolongation actually means an extension of the space of \
coordinates by their derivatives up to a certain order. As a simple example, \
we can extend or prolong the space of variables ",
  StyleBox["u",
    FontSlant->"Italic"],
  " for a function ",
  Cell[BoxData[
      \(TraditionalForm
      \`u : \ \[DoubleStruckCapitalR]\  \[Rule] \ 
        \[DoubleStruckCapitalR]\)]],
  " by its first derivative. In classical mechanics, such an extension of the \
configuration space with coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " to a space with ",
  StyleBox["u ",
    FontSlant->"Italic"],
  "and",
  StyleBox[" u'",
    FontSlant->"Italic"],
  " as coordinates is known as an extension of the configuration space to \
phase space. A more specific example occurring frequently in mathematical \
physics is given by a vector-valued function u = f(x) = ",
  Cell[BoxData[
      \(TraditionalForm\`\((f\_1\)\)]],
  "(x), \[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`f\_m\)]],
  "(x)) with ",
  StyleBox["n",
    FontSlant->"Italic"],
  " independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\( = \((x\_1\)\)\)]],
  ",\[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  ") and ",
  StyleBox["m",
    FontSlant->"Italic"],
  " dependent variables. For such an ",
  StyleBox["n \[Times] m",
    FontSlant->"Italic"],
  " space, the definition of the prolongation reads"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "prolong the space of variables", "extension", "configuration space"}],

Cell["Definition: Prolongation", "Definition",
  CellTags->"Definition: Prolongation"],

Cell[TextData[{
  "For a given vector-valued function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", ":", " ", 
          
          FormBox[\(\[DoubleStruckCapitalR]\^n \[Rule] \ 
              \[DoubleStruckCapitalR]\^m\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", we define the",
  StyleBox[" ",
    FontSlant->"Italic"],
  "k",
  StyleBox["th",
    FontSlant->"Italic"],
  " prolongation of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  " by"
}], "Text",
  Evaluatable->False,
  CellTags->"vector valued function"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(pr\^\((k)\)\),
            "TraditionalForm"], \(f(x)\)}], " ", ":=", " ", 
        RowBox[{
          FormBox[\(u\^\((k)\)\),
            "TraditionalForm"], "."}]}], TraditionalForm]]],
"\[ThickSpace]\[EmptyCircle]"], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "This relation means that we have to determine all derivatives of ",
  StyleBox["u ",
    FontSlant->"Italic"],
  "up to a certain order ",
  StyleBox["k",
    FontSlant->"Italic"],
  ". The result of such a calculation is a set of terms containing all \
possible derivatives of ",
  StyleBox["u",
    FontSlant->"Italic"],
  " up to ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th order."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The calculation of the",
  StyleBox[" k",
    FontSlant->"Italic"],
  "th prolongation is in some sense equivalent to the calculation of the \
first ",
  StyleBox["k",
    FontSlant->"Italic"],
  " coefficients in a Taylor expansion of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "at the point ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{"calculation of the kth prolongation", "Taylor expansion"}],

Cell[TextData[{
  "Let us demonstrate the calculation of the prolongation for a single \
function ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\  = \ f\) \((x, y, z)\)\)]],
  ". Here, ",
  Cell[BoxData[
      \(TraditionalForm\`n\  = \ 3\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\  = \ 1\)]],
  ". We are looking for the second prolongation of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  "; i.e., ",
  Cell[BoxData[
      \(TraditionalForm\`k\  = \ 2\)]],
  ". We use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to carry out such a calculation. If we do the calculation by hand, we \
have to collect the derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  " with respect to the independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x\  = \)\ \) \((x, y, z)\)\)]],
  " up to order 2"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(pr\^\((2)\)\),
            "TraditionalForm"], "f", \((x, y, z)\)}], " ", "=", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"f", ",", " ", 
              
              FormBox[\(\[PartialD]f\/\[PartialD]x, 
                \[PartialD]f\/\[PartialD]y, \ \[PartialD]f\/\[PartialD]z, 
                \[PartialD]\^2 f\/\(\[PartialD]x \[PartialD]y\), \t\ 
                \[PartialD]\^2 f\/\(\[PartialD]x \[PartialD]z\), \ 
                \(\n\t\[PartialD]\^2 f\)\/\(\[PartialD]y\ \[PartialD]z\), 
                \[PartialD]\^2 f\/\[PartialD]x\^2, 
                \[PartialD]\^2 f\/\[PartialD]y\^2, 
                \[PartialD]\^2 f\/\[PartialD]z\^2\ \),
                "TraditionalForm"]}], ")"}], "."}]}], TextForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  CellTags->"eq-11"],

Cell[TextData[{
  "This list of terms represents the expansion coefficients of a Taylor \
series of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "around ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ". The first few terms can be read off from the following series \
expansion:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[f, x, y, z, x0, y0, z0]; \n
    Normal[Series[f[x, y, z], {x, x0, 1}, \n\t\t{y, y0, 1}, {z, z0, 1}]] // 
      LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(f + \((x - x0)\)\ f\_x0 + 
      \((y - y0)\)\ \((f\_y0 + \((x - x0)\)\ f\_\(x0, y0\))\) + 
      \((z - z0)\)\ 
        \((f\_z0 + \((x - x0)\)\ f\_\(x0, z0\) + 
            \((y - y0)\)\ 
              \((f\_\(y0, z0\) + \((x - x0)\)\ f\_\(x0, y0, z0\))\))\)\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we do the calculation for the prolongation by applying the function ",
  StyleBox["Outer[]", "MmaText"],
  " in connection with the differentiation ",
  StyleBox["D[]", "MmaText"],
  ". The aim is to reproduce the content of equation ",
  ButtonBox["(3.11)",
    ButtonData:>"eq-11",
    ButtonStyle->"Hyperlink"],
  ". So we have to define a function called ",
  StyleBox["prolongation[]", "MmaText"],
  " using lists as input variables for the functions ",
  StyleBox["f",
    FontSlant->"Italic"],
  " and the independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The third argument of ",
  StyleBox["prolongation[]", "MmaText"],
  " determines the largest order ",
  StyleBox["k",
    FontSlant->"Italic"],
  " of differentiation:"
}], "Text",
  Evaluatable->False,
  CellTags->{"D[]", "prolongation[]"}],

Cell[BoxData[
    \(prolongation[f_List, x_List, order_] := \n\t
      Block[{aux, dresult}, \n\t\tresult = f; \n\t\taux = result; \n\t\t
        Do[aux = Outer[D, aux, x]; \n\t\t\t
          AppendTo[result, aux], {i, 1, order}]; \n\t\t
        Sort[Union[Flatten[result]], \n\t\t\tderivativeOrder[#1, #2]&]]\)], 
  "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The function ",
  StyleBox["prolongation[]", "MmaText"],
  " is based on the auxiliary function ",
  StyleBox["derivativeOrder[]", "MmaText"],
  ". This function determines the order of a differential expression. The \
result of ",
  StyleBox["derivativeOrder[]", "MmaText"],
  " influences the sorting of the derivatives in the function ",
  StyleBox["Sort[]", "MmaText"],
  ". ",
  StyleBox["derivativeOrder[]", "MmaText"],
  " allows us to sort the derivatives by an increasing order."
}], "Text",
  Evaluatable->False,
  CellTags->{"derivativeOrder[]", "Sort[]"}],

Cell[BoxData[
    RowBox[{
      RowBox[{\(derivativeOrder[expr1_, expr2_]\), ":=", "\n", "\t", 
        RowBox[{"If", "[", 
          RowBox[{
          \(FreeQ[expr1, Derivative] || \n\t\t\tFreeQ[expr2, Derivative]\), 
            ",", "True", ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{"Plus", "[", 
                RowBox[{"expr1", "/.", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["_", 
                        TagBox[\((x___)\),
                          Derivative],
                        MultilineFunction->None], "[", "___", "]"}], 
                    "\[Rule]", "x"}]}], "]"}], "<", "\n", "\t\t\t", 
              RowBox[{"Plus", "[", 
                RowBox[{"expr2", "/.", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["_", 
                        TagBox[\((x___)\),
                          Derivative],
                        MultilineFunction->None], "[", "___", "]"}], 
                    "\[Rule]", "x"}]}], "]"}]}]}], "]"}]}], ";"}]], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The function ",
  StyleBox["derivativeOrder[]", "MmaText"],
  " checks the two arguments ",
  StyleBox["expr1 ",
    FontSlant->"Italic"],
  "and ",
  StyleBox["expr2",
    FontSlant->"Italic"],
  " on derivatives. If the expressions are free of derivatives, the function \
returns ",
  StyleBox["True",
    FontSlant->"Italic"],
  ". If the expressions contain derivatives, the function only returns True \
if the order of the derivatives increases. The application of ",
  StyleBox["prolongation[]", "MmaText"],
  " on ",
  StyleBox["f[x,y,z]", "MmaText"],
  " up to second order gives us the coordinates of the extended space"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(prolongation[{f[x, y, z]}, {x, y, z}, 2] // LieTraditionalForm\)], 
  "Input"],

Cell[BoxData[
    \({f, f\_x, f\_y, f\_z, f\_\(x, x\), f\_\(x, y\), f\_\(x, z\), 
      f\_\(y, y\), f\_\(y, z\), f\_\(z, z\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "From a mathematical point of view, we determined the coordinates of a \
jet-space of order 2 (cf. ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  "). The ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th prolongation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(pr\^\((k)\)\),
            "TraditionalForm"], \((f(x))\)}], TraditionalForm]]],
  " is also known as the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-jet of ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". The related space of independent and dependent variables extended by the \
derivatives is thus called jet-space. Thus, if ",
  Cell[BoxData[
      \(TraditionalForm\`u = f(x)\)]],
  " is a function whose graph lies in the space of dependent and independent \
variables, the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th prolongation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(pr\^\((k)\)\),
            "TraditionalForm"], \((f(x))\)}], TraditionalForm]]],
  " is a function whose graph lies in the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-jet space."
}], "Text",
  Evaluatable->False,
  CellTags->{"jet-space", "k-jet", "prolongation", "space"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5 The Fr\[EAcute]chet Derivative", "Section",
  Evaluatable->False,
  CellTags->"The Frechet derivative"],

Cell[TextData[{
  "In the previous sections, we discussed differential operators available in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This section deals with a differential operator instrumental in the \
theory of symmetry analysis. Here, we discuss a generalized derivative and \
its definition in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The derivative is called a Gateaux or Fr\[EAcute]chet derivative. This \
kind of derivative is very useful in the calculations of symmetries (",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Fokas [1980, 1987]",
    ButtonData:>{"Literat.nb", "Fokas-1981"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Fokas and Fuchssteiner [1981], Baumann [1997]",
    ButtonData:>{"Literat.nb", "Fokas-1987"},
    ButtonStyle->"Hyperlink"],
  "). Such a derivative uses not only the steepest descent of a function but \
also puts a weight on it."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}],

Cell["Definition: Fr\[EAcute]chet derivative", "Definition",
  CellTags->"Definition: Frechet derivative"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(f = \(f(x, u\_\((n)\)\)\),
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " be a function in ",
  StyleBox["p",
    FontSlant->"Italic"],
  " independent and ",
  StyleBox["q",
    FontSlant->"Italic"],
  " dependent variables. ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((n)\)\)]],
  " denotes all the derivatives in this function up to order ",
  Cell[BoxData[
      \(TraditionalForm\`n = 0, 1, 2, \[Ellipsis]\)]],
  ". The Fr\[EAcute]chet derivative ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_f\)]],
  " of a function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " based on ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(w(x, u\_\((n)\)\),
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " is defined in such a way that"
}], "Text",
  Evaluatable->False,
  CellTags->"Frechet derivative"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\(\[GothicCapitalD]\_f\)(w)\), " ", "=", " ", 
        RowBox[{
          StyleBox[
            FractionBox["d", 
              StyleBox[
                RowBox[{
                  StyleBox["d",
                    FontFamily->"Times",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Italic",
                    FontTracking->"Plain",
                    PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                  "\[Epsilon]"}]]],
            ScriptLevel->0], " ", \(f(u + \[Epsilon]\ \(w(u)\))\), 
          \(|\_\(\[Epsilon] = 0\)\)}]}], TraditionalForm]]]], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-12"],

Cell[TextData[{
  "holds for all auxiliary functions ",
  StyleBox["w",
    FontSlant->"Italic"],
  ". We call the function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " the support of the Fr\[EAcute]chet derivative and ",
  StyleBox["w",
    FontSlant->"Italic"],
  " the test function.\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False,
  CellTags->{"test function", "support"}],

Cell[TextData[{
  "The algorithmic content of this definition is that ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[GothicCapitalD]\_f\)(w)\)]],
  " is calculated by replacing ",
  StyleBox["u",
    FontSlant->"Italic"],
  " and all of its derivatives in ",
  StyleBox["f",
    FontSlant->"Italic"],
  " ",
  StyleBox["b",
    FontSlant->"Italic"],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`u + \[Epsilon]\ w\)]],
  ". If we later differentiate the resulting expression with respect to \
\[Epsilon] and set ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ", we determined the Fr\[EAcute]chet derivative. The result of these two \
steps is the Fr\[EAcute]chet derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " based on the test function ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  ". Using the steps in a pencil calculation for one independent and one \
dependent variable, equation ",
  ButtonBox["(3.12)",
    ButtonData:>"eq-12",
    ButtonStyle->"Hyperlink"],
  " can be reduced to an explicit expression like"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\[GothicCapitalD]\_f\  = \ 
      \(\(\[Sum]\ \)\+\(k = 0\)\%\[Infinity]\) 
        \(\[PartialD]f\/\[PartialD]u\_\((k)\)\) 
        \(\[PartialD]\^k\/\[PartialD]x\^k . \)\)], "NumberedEquation",
  Evaluatable->False,
  FontSlant->"Plain",
  CellTags->"eq-13"],

Cell[TextData[{
  "In (3.13) ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  " denotes the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th derivative of ",
  StyleBox["u",
    FontSlant->"Italic"],
  " with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The sum in ",
  ButtonBox["(3.13)",
    ButtonData:>"eq-13",
    ButtonStyle->"Hyperlink"],
  " is finite since the order of the largest derivative of the support is \
finite. This is the case in all practical situations."
}], "Text",
  Evaluatable->False,
  CellTags->"support"],

Cell[TextData[{
  "Let us consider as a support function",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              FormBox[\(f = u\_x\),
                "TraditionalForm"], " ", 
              FormBox[\(u\_\(x, x, x\)\),
                "TraditionalForm"]}], " ", "+", " ", 
            FormBox[\(u\_x\%2\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". The Fr\[EAcute]chet derivative with a test function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(w = \(w(x, u\_\(x, x, x\)\)\),
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " contained in the class of support functions ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is given by applying equation ",
  ButtonBox["(3.13)",
    ButtonData:>"eq-13",
    ButtonStyle->"Hyperlink"],
  "  to ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->"Frechet derivative"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[GothicCapitalD]\_f\)(w)\  = \ 
        \((u\_\(x, x, x\)\  + \ 2\ u\_x)\)\ \(D\_x\) w\  + \ 
          u\_x\ \(D\_\(x, x, x\)\) w\)]],
  ","
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-14"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`D\_x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\_\(x, x, x\)\)]],
  " denote the first- and third-order total derivatives. If we choose the \
test  function as ",
  Cell[BoxData[
      \(TraditionalForm\`w = u\_x\%2/2\)]],
  ", we get from relation ",
  ButtonBox["(3.14)",
    ButtonData:>"eq-14",
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`\(\[GothicCapitalD]\_f\)(w)\  = \ 
      \(\((u\_\(x, x, x\)\  + \ 2  u\_x)\)\ u\_x\  = \ 
        \(u\_x\) u\_\(x, x, x\)\  + \ 2\ u\_x\%2\)\)]]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "representing a differential expression containing only derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The definition of the ",
  ButtonBox["Fr\[EAcute]chet derivative",
    ButtonData:>"Definition: Frechet derivative",
    ButtonStyle->"Hyperlink"],
  " given above for one independent and one dependent variable is easily \
generalized to a vector of ",
  StyleBox["r ",
    FontSlant->"Italic"],
  "support functions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\(f = \((f\_1\)\),
                "TraditionalForm"], ",", "\[Ellipsis]", ",", \(f\_r\)}],
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " and ",
  StyleBox["q",
    FontSlant->"Italic"],
  " test functions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                RowBox[{"w", 
                  FormBox[\( = \((w\_1\)\),
                    "TraditionalForm"]}], ",", \(w\_2\)}],
              "TraditionalForm"], ",", " ", "\[Ellipsis]", ",", " ", 
            FormBox[\(w\_q\),
              "TraditionalForm"]}], ")"}], TraditionalForm]]],
  ". Then the Fr\[EAcute]chet derivative of such an ",
  StyleBox["r",
    FontSlant->"Italic"],
  "-tuple is given by the relation"
}], "Text",
  Evaluatable->False,
  CellTags->"vector Frechet derivative"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\(\[GothicCapitalD]\_f\)(w)\), " ", "=", " ", 
        RowBox[{
          RowBox[{
            StyleBox[
              FractionBox["d", 
                StyleBox[
                  RowBox[{
                    StyleBox["d",
                      FontFamily->"Times",
                      FontSize->10,
                      FontWeight->"Roman",
                      FontSlant->"Italic",
                      FontTracking->"Plain",
                      PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                    "\[Epsilon]"}]]],
              ScriptLevel->0], 
            RowBox[{"(", GridBox[{
                  {
                    \(\(f\_1\)(u\_1 + \[Epsilon]\ w\_1, u\_2, \[Ellipsis], 
                        u\_r) + \[CenterEllipsis] + 
                      \(f\_1\)(u\_1, u\_2, \[Ellipsis], 
                        u\_r + \[Epsilon]\ w\_r)\)},
                  {
                    \(\(f\_2\)(u\_1 + \[Epsilon]\ w\_1, u\_2, \[Ellipsis], 
                        u\_r) + \[CenterEllipsis] + 
                      \(f\_2\)(u\_1, u\_2, \[Ellipsis], 
                        u\_r + \[Epsilon]\ w\_r)\)},
                  {"\[VerticalEllipsis]"},
                  {
                    \(\(f\_r\)(u\_1 + \[Epsilon]\ w\_1, u\_2, \[Ellipsis], 
                        u\_r) + \[CenterEllipsis] + 
                      \(f\_r\)(u\_1, u\_2, \[Ellipsis], 
                        u\_r + \[Epsilon]\ w\_r)\)}
                  }], ")"}]}], " ", \( | \_\(\[Epsilon] = 0\)\), "."}]}], 
      TraditionalForm]]]], "NumberedEquation",
  CellTags->"eq-16add"],

Cell[TextData[{
  "Introducing the ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " test functions as a column vector allows us to define the ",
  StyleBox["q",
    FontSlant->"Italic"],
  "\[Times]",
  StyleBox["r",
    FontSlant->"Italic"],
  " matrix differential operator"
}], "Text",
  Evaluatable->False,
  CellTags->"matrix differential operator"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \(\((\(\[GothicCapitalD]\_f\)(w))\)\_\[Mu]\[Alpha]\), " ", "=", " ", 
          RowBox[{
            FractionBox["d", 
              StyleBox[
                RowBox[{
                  StyleBox["d",
                    FontFamily->"Times",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Italic",
                    FontTracking->"Plain",
                    PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                  "\[Epsilon]"}]]], 
            \(\(f\_\[Mu]\)(u\_\[Alpha] + \ \[Epsilon]\ \(\(w\_\[Alpha]\)(u)\))
              \), " ", \(|\_\(\[Epsilon] = 0\)\)}]}], " ", ",", "       ", 
        \(\[Mu] = 1\), ",", "\[Ellipsis]", ",", "r", ",", "    ", 
        \(\[Alpha] = 1\), ",", "\[Ellipsis]", ",", "q"}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-16"],

Cell["\<\
This expression is equivalent to the matrix differential operator \
\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\(\((\[GothicCapitalD]\_f)\)\_\[Mu]\[Alpha]\  = \ 
        \[Sum]\+J\ \[PartialD]f\_\[Mu]\/\[PartialD]u\_J\%\[Alpha]\ D\_J, 
      \ \ \ \ \ \(\[Mu] = \)\ \[InvisibleComma] 1, \[Ellipsis], r; 
      \ \ \ \ \ \ \[Alpha] = 1, \[Ellipsis], \(q . \)\)\)], "NumberedEquation",\

  Evaluatable->False,
  CellTags->"eq-17"],

Cell[TextData[{
  "The sum in ",
  ButtonBox["(3.18)",
    ButtonData:>"eq-17",
    ButtonStyle->"Hyperlink"],
  " extends over all multi-indices ",
  StyleBox["J",
    FontSlant->"Italic"],
  ". To define the Fr\[EAcute]chet derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we use relation ",
  ButtonBox["(3.12)",
    ButtonData:>"eq-12",
    ButtonStyle->"Hyperlink"],
  " and its matrix version ",
  ButtonBox["(3.16)",
    ButtonData:>"eq-16add",
    ButtonStyle->"Hyperlink"],
  ". We note again that the ",
  Cell[BoxData[
      \(TraditionalForm\`u\^\[Alpha]\)]],
  " and all their derivatives are replaced by ",
  Cell[BoxData[
      \(TraditionalForm\`u\^\[Alpha]\)]],
  " + \[Epsilon]\[ThinSpace]",
  Cell[BoxData[
      \(TraditionalForm\`w\^\[Alpha]\)]],
  ". After the replacement of the arguments, we differentiate with respect to \
\[Epsilon] and set ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  " in the next step. The result in the general case is a matrix containing \
the derivatives of the support ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " based on the test functions ",
  Cell[BoxData[
      \(TraditionalForm\`w\^\[Alpha]\)]],
  ". The implementation of the Fr\[EAcute]chet derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(FrechetD[support_List, dependVar_List, \n\tindependVar_List, 
        testfunction_List] := \n\t
      Block[{indep, frechet, deriv, \[Epsilon], r0, x1, x2}, \n\t\tr0 = 
          Function[indep, x1 + \[Epsilon]\ x2]; \n\t\tfrechet = {}; 
        Do[deriv = {}; \n\t\t\tDo[
            AppendTo[
              deriv, \[PartialD]\_\[Epsilon]\((support\[LeftDoubleBracket]
                        j\[RightDoubleBracket] /. \n\t\t\t\t\t\t\t\tdependVar\
\[LeftDoubleBracket]
                          i\[RightDoubleBracket] \[Rule] \((r0 /. \n\t{indep \
\[Rule] independVar, \n\tx1 \[Rule] 
                                dependVar\[LeftDoubleBracket]
                                    i\[RightDoubleBracket] @@ 
                                  independVar, \n\t
                              x2 \[Rule] 
                                testfunction\[LeftDoubleBracket]
                                    i\[RightDoubleBracket] @@ 
                                  independVar})\))\) /. \[Epsilon] \[Rule] 
                  0], \n\t\t\t\t{i, 1, Length[support]}]; \n\t\t\tAppendTo[
            frechet, deriv], \n\t\t\t{j, 1, 
            Length[support]}]; \n\t\tfrechet]\)], "Input",
  PageWidth->Infinity,
  CellTags->{"FrechetD", "FrechetD[]"}],

Cell[TextData[{
  "The code of the Fr\[EAcute]chet derivative follows closely the relation \
given in equation ",
  ButtonBox["(3.12)",
    ButtonData:>"eq-12",
    ButtonStyle->"Hyperlink"],
  ". In ",
  StyleBox["FrechetD[],", "MmaText"],
  " we first define a pure function stored in the variable ",
  StyleBox["r",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\_0\)]],
  StyleBox[".",
    FontSlant->"Italic"],
  " This function serves as a general pattern to replace the original \
argument by a varied argument. A loop extending over the number of dependent \
variables replaces the independent and dependent variables. This step creates \
an explicit rule for the replacement. After the replacement, a \
differentiation with respect to the parameter \[Epsilon] is performed and, at \
the end, \[Epsilon] is replaced by zero. The resulting expressions are \
collected in the list ",
  StyleBox["frechet",
    FontSlant->"Italic"],
  " which is returned by the function. An example will demonstrate the \
application of the function."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "In FrechetD[]", "pure function", "dependent variables", 
    "independent variables"}],

Cell["Example 1", "Example"],

Cell["\<\
Consider a set of two expressions representing a system of partial \
differential equations given by\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        AdjustmentBox["  ",
          BoxMargins->{{0, 0}, {-0.740741, 0.740741}},
          BoxBaselineShift->0.740741], 
        RowBox[{
          FormBox[\(v\_x\  - \ u\  = \ 0\),
            "TraditionalForm"], ",", 
          AdjustmentBox["\n",
            BoxMargins->{{0, 0}, {0.592593, -0.592593}},
            BoxBaselineShift->-0.592593], 
          FormBox[
            RowBox[{
              FormBox[\(v\_t\  - \ u\_x\/\(u\^2\ \)\  = \ 0\),
                "TraditionalForm"], ","}],
            "TextForm"]}]}], TextForm]], "NumberedEquation",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  CellTags->"eq-18"],

Cell[TextData[{
  "where ",
  StyleBox["u",
    FontSlant->"Italic"],
  " and ",
  StyleBox["v",
    FontSlant->"Italic"],
  " are functions of ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "and",
  StyleBox[" t.",
    FontSlant->"Italic"],
  " This set of equations is equivalent to a non-linear diffusion equation in \
",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ". Our aim is to calculate the Fr\[EAcute]chet derivative of the left-hand \
side of the system ",
  ButtonBox["(3.19).",
    ButtonData:>"eq-18",
    ButtonStyle->"Hyperlink"],
  " Let us define a variable ",
  StyleBox["eqsys",
    FontSlant->"Italic"],
  " containing the left-hand side of the equations:"
}], "Text",
  Evaluatable->False,
  CellTags->"nonlinear diffusion equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqsys = {\[PartialD]\_x v[x, t] - u[x, t], 
        \[PartialD]\_t v[x, t] - \[PartialD]\_x u[x, t]\/u[x, t]\^2}; 
    eqsys // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({\(-u\) + v\_x, \(-\(u\_x\/u\^2\)\) + v\_t}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The application of our function ",
  StyleBox["FrechetD[]", "MmaText"],
  " to this expression gives us"
}], "Text",
  CellTags->"FrechetD[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(FrechetD[eqsys, {u, v}, {x, t}, {w1, w2}] // \n\tMatrixForm\) // 
      LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-w1\), \(w2\_x\)},
            {
              StyleBox[\(\(2\ w1\ u\_x\)\/u\^3 - w1\_x\/u\^2\),
                ScriptLevel->0], \(w2\_t\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The calculation of the Fr\[EAcute]chet derivative using ",
  StyleBox["FrechetD[]", "MmaText"],
  " is carried out by supplying four arguments containing the equations: the \
dependent variables of the support, the independent variables, and the test \
functions ",
  Cell[BoxData[
      \(TraditionalForm\`w\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\_2\)]],
  ". The result is a 2 \[Times] 2 matrix containing expressions of ",
  Cell[BoxData[
      \(TraditionalForm\`w\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\_2\)]],
  " and their derivatives. From the result, we can get the corresponding \
operators if we consider ",
  Cell[BoxData[
      \(TraditionalForm\`w\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\_2\)]],
  " as auxiliary functions. The related matrix operator reads"
}], "Text",
  Evaluatable->False,
  CellTags->{"support", "matrix operator"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", GridBox[{
              {\(-1\), \(\[PartialD]\_x\)},
              {
                RowBox[{
                  StyleBox[
                    FractionBox[
                      RowBox[{"2", "  ", 
                        SuperscriptBox[\(u\_x\), 
                          TagBox["",
                            Derivative],
                          MultilineFunction->None]}], \(u\^3\)],
                    ScriptLevel->0], 
                  StyleBox["-",
                    ScriptLevel->0], 
                  RowBox[{
                    StyleBox[
                      FractionBox[
                        SuperscriptBox["1", 
                          TagBox["",
                            Derivative],
                          MultilineFunction->None], \(u\^2\)],
                      
                      ScriptLevel->
                        0], \(\[PartialD]\_x\)}]}], \(\[PartialD]\_t\)}
              }], ")"}], "."}], TextForm]], "NumberedEquation"],

Cell[TextData[{
  "In our symmetry calculations, we sometimes need also the adjoint \
representation of the Fr\[EAcute]chet derivative. In general, the adjoint \
representation of a differential operator is defined via an integral \
expression. Assume that we know the differential operator ",
  ButtonBox["(3.12)",
    ButtonData:>"eq-12",
    ButtonStyle->"Hyperlink"],
  ". We denote the adjoint operator of ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_f\)]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[GothicCapitalD]\_f\%*\)\)]],
  " satisfying"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "adjoint representation", "adjoint Frechet derivative", "adjoint operator"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            
            FormBox[\(\[Integral]\_\[CapitalOmega]\ 
                V\ \(\[GothicCapitalD]\_f\) W\),
              "TraditionalForm"], \(\[DifferentialD]x\)}], "  ", "=", " ", 
          RowBox[{
            
            FormBox[\(\[Integral]\_\[CapitalOmega]\ 
                W\ \(\[GothicCapitalD]\_f\%*\) V\),
              "TraditionalForm"], \(\[DifferentialD]x\)}]}], 
        TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Equation (3.21) holds for any pair of functions ",
  StyleBox["W",
    FontSlant->"Italic"],
  " and ",
  StyleBox["V",
    FontSlant->"Italic"],
  ". If we examine definition (3.21) in more detail, we can replace the \
integral operation by a plain differential representation (cf. ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  "). The corresponding expression to ",
  ButtonBox["(3.18) ",
    ButtonData:>"eq-17",
    ButtonStyle->"Hyperlink"],
  "is given by"
}], "Text",
  Evaluatable->False],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \(\((\(\[GothicCapitalD]\_f\%*\))\)\_\[Mu]\[Alpha]\), " ", "=", 
          RowBox[{
            StyleBox[\(\[Sum]\+J\),
              ScriptLevel->0], 
            RowBox[{\(\((\(-1\))\)\^J\), " ", 
              RowBox[{\(D\_J\), "(", 
                StyleBox[\(\[PartialD]f\_\[Mu]\/\[PartialD]u\_J\%\[Alpha]\),
                  ScriptLevel->0], ")"}]}]}]}], ",", "      ", \(\[Mu] = 1\), 
        ",", "\[Ellipsis]", ",", \(r; \ \ \ \[Alpha] = 1\), ",", 
        "\[Ellipsis]", ",", " ", \(q . \)}], TraditionalForm]]]], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->{"eq-20", "adjoint Frechet derivative"}],

Cell[TextData[{
  "In view of an algorithm in ",
  StyleBox["Mathematica, ",
    FontSlant->"Italic"],
  "this means that we convert derivatives of the test functions to \
derivatives of the support multiplied by some coefficients. This is strictly \
the definition of an adjoint differential operator. The described procedure \
is implemented in the following function ",
  StyleBox["AdjointFrechetD[]:", "MmaText"]
}], "Text",
  Evaluatable->False,
  CellTags->{"adjoint differential operator", "AdjointFrechetD[]"}],

Cell[BoxData[
    RowBox[{\(AdjointFrechetD[support_List, dependVar_List, \n\t
        independVar_List, testfunction_List]\), ":=", "\n", "\t", 
      RowBox[{"Block", "[", 
        RowBox[{\({subrule, $testf, frechet, n, b}\), ",", "\n", "\t\t", 
          RowBox[{
            RowBox[{"subrule", "=", 
              RowBox[{
                RowBox[{"b_.", " ", 
                  RowBox[{
                    SuperscriptBox["$testf", 
                      TagBox[\((n___)\),
                        Derivative],
                      MultilineFunction->None], "@@", "independVar"}]}], 
                "\[RuleDelayed]", "\n", 
                "\t\t\t\t", \(\((\(-1\))\)\^Plus @@ {n}\ \[IndentingNewLine]\
\[PartialD]\_\(Delete[Thread[{independVar, {n}}], 0]\)\((b\ $testf @@ 
                          independVar)\)\)}]}], ";", "\n", 
            "\t\t", \(frechet = 
              FrechetD[support, dependVar, \n\t\t\t\tindependVar, 
                testfunction]\), ";", "\n", 
            "\t\t", \(Do[
              frechet = 
                frechet /. \n\t\t\t\t\t\((subrule /. $testf \[Rule] 
                        testfunction\[LeftDoubleBracket]
                          i\[RightDoubleBracket])\), \n\t\t\t{i, 1, 
                Length[testfunction]}]\), ";", "\n", 
            "\t\t", \(frechet = Transpose[frechet]\)}]}], "]"}]}]], "Input",
  PageWidth->Infinity,
  PageBreakWithin->Automatic,
  PageBreakBelow->True,
  CellTags->"AdjointFrechetD[]"],

Cell[TextData[{
  "The adjoint representation of the Fr\[EAcute]chet derivative of the system \
",
  StyleBox["eqsys",
    FontSlant->"Italic"],
  " is thus given by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(AdjointFrechetD[eqsys, {u, v}, {x, t}, \n\t{w1, w2}] // MatrixForm
        \) // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-w1\), 
              FormBox[
                StyleBox[\(w1\_x\/u\^2\),
                  ScriptLevel->0],
                "StandardForm"]},
            {\(-w2\_x\), \(-w2\_t\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"derivat1.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{658, 668},
WindowMargins->{{130, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->38,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Derivatives", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Ordinary and Partial Derivatives", "Tangent Vector", 
                "The Total Derivative", "Prolongations", 
                "The Fr\[EAcute]chet Derivative"}, #]&)], FontSlant -> 
            "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellBracket->True,
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "differential operators"->{
    Cell[2351, 63, 1809, 37, 327, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "ordinary differentiation"->{
    Cell[2351, 63, 1809, 37, 327, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}],
    Cell[103556, 3203, 1248, 32, 159, "Text",
      Evaluatable->False,
      CellTags->"ordinary differentiation"]},
  "total differential"->{
    Cell[2351, 63, 1809, 37, 327, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "Frechet derivative"->{
    Cell[2351, 63, 1809, 37, 327, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}],
    Cell[387106, 11667, 970, 34, 75, "Text",
      Evaluatable->False,
      CellTags->"Frechet derivative"],
    Cell[391216, 11809, 981, 32, 54, "Text",
      Evaluatable->False,
      CellTags->"Frechet derivative"]},
  "Euler-Lagrange derivative"->{
    Cell[2351, 63, 1809, 37, 327, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "prolongation"->{
    Cell[2351, 63, 1809, 37, 327, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}],
    Cell[373297, 11229, 105, 2, 52, "Section",
      Evaluatable->False,
      CellTags->{"Prolongations", "prolongation"}],
    Cell[373405, 11233, 880, 19, 96, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "vector field", "ODE", "PDE"}],
    Cell[384457, 11584, 1266, 41, 117, "Text",
      Evaluatable->False,
      CellTags->{"jet-space", "k-jet", "prolongation", "space"}]},
  "LieTraditionalForm[]"->{
    Cell[2351, 63, 1809, 37, 327, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "traditional form"->{
    Cell[2351, 63, 1809, 37, 327, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "Ordinary and partial derivatives"->{
    Cell[4185, 104, 391, 6, 52, "Section",
      Evaluatable->False,
      CounterAssignments->{{"Title", 3}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Ordinary and partial derivatives"]},
  "calculus"->{
    Cell[4579, 112, 1120, 21, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "Gauss"->{
    Cell[4579, 112, 1120, 21, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "Leibniz"->{
    Cell[4579, 112, 1120, 21, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "Newton"->{
    Cell[4579, 112, 1120, 21, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "slope"->{
    Cell[4579, 112, 1120, 21, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "derivative"->{
    Cell[4579, 112, 1120, 21, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "Definition: Ordinary derivative"->{
    Cell[5702, 135, 100, 1, 38, "Definition",
      CellTags->"Definition: Ordinary derivative"]},
  "trigonometric function"->{
    Cell[6534, 163, 1248, 32, 180, "Text",
      Evaluatable->False,
      CellTags->"trigonometric function"],
    Cell[15416, 469, 1059, 31, 117, "Text",
      Evaluatable->False,
      CellTags->"trigonometric function"]},
  "symbolic calculation"->{
    Cell[8190, 219, 275, 6, 54, "Text",
      Evaluatable->False,
      CellTags->"symbolic calculation"]},
  "ordinary differential"->{
    Cell[8623, 237, 992, 30, 96, "Text",
      Evaluatable->False,
      CellTags->{"ordinary differential", "independent variable"}]},
  "independent variable"->{
    Cell[8623, 237, 992, 30, 96, "Text",
      Evaluatable->False,
      CellTags->{"ordinary differential", "independent variable"}]},
  "geometrical interpretation"->{
    Cell[9618, 269, 1294, 36, 159, "Text",
      Evaluatable->False,
      CellTags->{"geometrical interpretation", "Limit[]"}]},
  "Limit[]"->{
    Cell[9618, 269, 1294, 36, 159, "Text",
      Evaluatable->False,
      CellTags->{"geometrical interpretation", "Limit[]"}]},
  "pure function"->{
    Cell[13913, 422, 841, 23, 33, "Text",
      Evaluatable->False,
      CellTags->"pure function"],
    Cell[400670, 12090, 1199, 30, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "In FrechetD[]", "pure function", "dependent variables", 
        "independent variables"}]},
  "tangent"->{
    Cell[34894, 1081, 1617, 55, 138, "Text",
      Evaluatable->False,
      CellTags->{"tangent", "envelope"}]},
  "envelope"->{
    Cell[34894, 1081, 1617, 55, 138, "Text",
      Evaluatable->False,
      CellTags->{"tangent", "envelope"}]},
  "differentiation of a product"->{
    Cell[84307, 2573, 812, 21, 96, "Text",
      Evaluatable->False,
      CellTags->"differentiation of a product"]},
  "rational function"->{
    Cell[85401, 2611, 358, 8, 54, "Text",
      CellTags->{"rational function", "differentiation of the ratio"}]},
  "differentiation of the ratio"->{
    Cell[85401, 2611, 358, 8, 54, "Text",
      CellTags->{"rational function", "differentiation of the ratio"}]},
  "chain rule of Leibniz"->{
    Cell[85998, 2633, 188, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"chain rule of Leibniz"]},
  "partial derivativ"->{
    Cell[86909, 2670, 1180, 22, 201, "Text",
      Evaluatable->False,
      CellTags->"partial derivativ"]},
  "Definition: Partial derivative"->{
    Cell[88092, 2694, 98, 1, 38, "Definition",
      CellTags->"Definition: Partial derivative"]},
  "partial derivative"->{
    Cell[89268, 2733, 1619, 54, 138, "Text",
      Evaluatable->False,
      CellTags->{"partial derivative", "D[]"}],
    Cell[94246, 2908, 1416, 48, 96, "Text",
      Evaluatable->False,
      CellTags->{"partial derivative", "order of differentiation"}]},
  "D[]"->{
    Cell[89268, 2733, 1619, 54, 138, "Text",
      Evaluatable->False,
      CellTags->{"partial derivative", "D[]"}],
    Cell[367030, 10991, 538, 16, 75, "Text",
      Evaluatable->False,
      CellTags->"D[]"],
    Cell[380528, 11467, 911, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{"D[]", "prolongation[]"}]},
  "higher order derivatives"->{
    Cell[92216, 2838, 170, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"higher order derivatives"]},
  "Definition: kth order derivative"->{
    Cell[93378, 2875, 165, 6, 38, "Definition",
      CellTags->"Definition: kth order derivative"]},
  "order of differentiation"->{
    Cell[94246, 2908, 1416, 48, 96, "Text",
      Evaluatable->False,
      CellTags->{"partial derivative", "order of differentiation"}]},
  "variational derivative"->{
    Cell[96466, 2988, 638, 13, 96, "Text",
      Evaluatable->False,
      CellTags->{"variational derivative", "Euler derivative"}]},
  "Euler derivative"->{
    Cell[96466, 2988, 638, 13, 96, "Text",
      Evaluatable->False,
      CellTags->{"variational derivative", "Euler derivative"}]},
  "tangent vector"->{
    Cell[97141, 3006, 89, 2, 52, "Section",
      Evaluatable->False,
      CellTags->"tangent vector"],
    Cell[97233, 3010, 1816, 53, 159, "Text",
      Evaluatable->False,
      CellTags->{"measure", "tangent vector", "symmetry analysis"}],
    Cell[99145, 3068, 500, 15, 33, "Text",
      Evaluatable->False,
      CellTags->"tangent vector"],
    Cell[108387, 3354, 848, 29, 75, "Text",
      Evaluatable->False,
      CellTags->{"scalar product", "tangent vector"}]},
  "measure"->{
    Cell[97233, 3010, 1816, 53, 159, "Text",
      Evaluatable->False,
      CellTags->{"measure", "tangent vector", "symmetry analysis"}]},
  "symmetry analysis"->{
    Cell[97233, 3010, 1816, 53, 159, "Text",
      Evaluatable->False,
      CellTags->{"measure", "tangent vector", "symmetry analysis"}],
    Cell[385876, 11634, 1118, 28, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}]},
  "Definition: Tangent vector"->{
    Cell[99052, 3065, 90, 1, 38, "Definition",
      CellTags->"Definition: Tangent vector"]},
  "eq-4"->{
    Cell[99648, 3085, 607, 18, 44, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-4"]},
  "directional derivative"->{
    Cell[100703, 3122, 205, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"directional derivative"]},
  "eq-5"->{
    Cell[100911, 3129, 530, 18, 46, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-5"]},
  "operator"->{
    Cell[101444, 3149, 1856, 45, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "operator", "independent variables", "input", "TangentVector[]"}]},
  "independent variables"->{
    Cell[101444, 3149, 1856, 45, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "operator", "independent variables", "input", "TangentVector[]"}],
    Cell[362203, 10826, 1953, 68, 138, "Text",
      Evaluatable->False,
      CellTags->{"dependent variables", "independent variables"}],
    Cell[400670, 12090, 1199, 30, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "In FrechetD[]", "pure function", "dependent variables", 
        "independent variables"}]},
  "input"->{
    Cell[101444, 3149, 1856, 45, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "operator", "independent variables", "input", "TangentVector[]"}]},
  "TangentVector[]"->{
    Cell[101444, 3149, 1856, 45, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "operator", "independent variables", "input", "TangentVector[]"}],
    Cell[105073, 3248, 1338, 40, 118, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"],
    Cell[106720, 3301, 342, 9, 54, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"],
    Cell[110988, 3444, 613, 14, 96, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"],
    Cell[112489, 3490, 390, 12, 54, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"],
    Cell[360894, 10787, 1172, 30, 159, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"]},
  "scalar product"->{
    Cell[108387, 3354, 848, 29, 75, "Text",
      Evaluatable->False,
      CellTags->{"scalar product", "tangent vector"}]},
  "superposition"->{
    Cell[109785, 3410, 575, 18, 75, "Text",
      Evaluatable->False,
      CellTags->"superposition"]},
  "components of the tangent vector"->{
    Cell[110363, 3430, 622, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{"components of the tangent vector", "tangent surface"}]},
  "tangent surface"->{
    Cell[110363, 3430, 622, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{"components of the tangent vector", "tangent surface"}],
    Cell[114369, 3545, 620, 17, 54, "Text",
      Evaluatable->False,
      CellTags->"tangent surface"]},
  "TangentSurface[]"->{
    Cell[114992, 3564, 360, 7, 135, "Input",
      CellTags->"TangentSurface[]"],
    Cell[115355, 3573, 566, 20, 54, "Text",
      Evaluatable->False,
      CellTags->"TangentSurface[]"]},
  "total derivative"->{
    Cell[362103, 10822, 97, 2, 52, "Section",
      Evaluatable->False,
      CellTags->"total derivative"],
    Cell[369053, 11074, 1475, 46, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "higher order total derivatives", "multi index", "total derivative"}]},
  "dependent variables"->{
    Cell[362203, 10826, 1953, 68, 138, "Text",
      Evaluatable->False,
      CellTags->{"dependent variables", "independent variables"}],
    Cell[400670, 12090, 1199, 30, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "In FrechetD[]", "pure function", "dependent variables", 
        "independent variables"}]},
  "Definition: Total derivative"->{
    Cell[364159, 10896, 94, 1, 38, "Definition",
      CellTags->"Definition: Total derivative"]},
  "eq-7"->{
    Cell[364528, 10910, 1155, 31, 69, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-7"]},
  "eq-8"->{
    Cell[365848, 10951, 415, 9, 52, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-8"]},
  "higher order total derivatives"->{
    Cell[369053, 11074, 1475, 46, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "higher order total derivatives", "multi index", "total derivative"}]},
  "multi index"->{
    Cell[369053, 11074, 1475, 46, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "higher order total derivatives", "multi index", "total derivative"}]},
  "commutation of derivatives"->{
    Cell[372468, 11201, 459, 14, 54, "Text",
      Evaluatable->False,
      CellTags->"commutation of derivatives"]},
  "Prolongations"->{
    Cell[373297, 11229, 105, 2, 52, "Section",
      Evaluatable->False,
      CellTags->{"Prolongations", "prolongation"}]},
  "vector field"->{
    Cell[373405, 11233, 880, 19, 96, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "vector field", "ODE", "PDE"}]},
  "ODE"->{
    Cell[373405, 11233, 880, 19, 96, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "vector field", "ODE", "PDE"}]},
  "PDE"->{
    Cell[373405, 11233, 880, 19, 96, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "vector field", "ODE", "PDE"}]},
  "prolong the space of variables"->{
    Cell[374288, 11254, 1621, 50, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "prolong the space of variables", "extension", 
        "configuration space"}]},
  "extension"->{
    Cell[374288, 11254, 1621, 50, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "prolong the space of variables", "extension", 
        "configuration space"}]},
  "configuration space"->{
    Cell[374288, 11254, 1621, 50, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "prolong the space of variables", "extension", 
        "configuration space"}]},
  "Definition: Prolongation"->{
    Cell[375912, 11306, 86, 1, 38, "Definition",
      CellTags->"Definition: Prolongation"]},
  "vector valued function"->{
    Cell[376001, 11309, 561, 21, 33, "Text",
      Evaluatable->False,
      CellTags->"vector valued function"]},
  "calculation of the kth prolongation"->{
    Cell[377369, 11362, 474, 17, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "calculation of the kth prolongation", "Taylor expansion"}]},
  "Taylor expansion"->{
    Cell[377369, 11362, 474, 17, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "calculation of the kth prolongation", "Taylor expansion"}]},
  "eq-11"->{
    Cell[378762, 11412, 931, 23, 86, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-11"]},
  "prolongation[]"->{
    Cell[380528, 11467, 911, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{"D[]", "prolongation[]"}]},
  "derivativeOrder[]"->{
    Cell[381793, 11506, 586, 15, 75, "Text",
      Evaluatable->False,
      CellTags->{"derivativeOrder[]", "Sort[]"}]},
  "Sort[]"->{
    Cell[381793, 11506, 586, 15, 75, "Text",
      Evaluatable->False,
      CellTags->{"derivativeOrder[]", "Sort[]"}]},
  "jet-space"->{
    Cell[384457, 11584, 1266, 41, 117, "Text",
      Evaluatable->False,
      CellTags->{"jet-space", "k-jet", "prolongation", "space"}]},
  "k-jet"->{
    Cell[384457, 11584, 1266, 41, 117, "Text",
      Evaluatable->False,
      CellTags->{"jet-space", "k-jet", "prolongation", "space"}]},
  "space"->{
    Cell[384457, 11584, 1266, 41, 117, "Text",
      Evaluatable->False,
      CellTags->{"jet-space", "k-jet", "prolongation", "space"}]},
  "The Frechet derivative"->{
    Cell[385760, 11630, 113, 2, 52, "Section",
      Evaluatable->False,
      CellTags->"The Frechet derivative"]},
  "generalized derivative"->{
    Cell[385876, 11634, 1118, 28, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}]},
  "Gateaux"->{
    Cell[385876, 11634, 1118, 28, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}]},
  "Frechet"->{
    Cell[385876, 11634, 1118, 28, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}]},
  "Definition: Frechet derivative"->{
    Cell[386997, 11664, 106, 1, 38, "Definition",
      CellTags->"Definition: Frechet derivative"]},
  "eq-12"->{
    Cell[388079, 11703, 760, 20, 41, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-12"]},
  "test function"->{
    Cell[388842, 11725, 394, 13, 54, "Text",
      Evaluatable->False,
      CellTags->{"test function", "support"}]},
  "support"->{
    Cell[388842, 11725, 394, 13, 54, "Text",
      Evaluatable->False,
      CellTags->{"test function", "support"}],
    Cell[390649, 11786, 564, 21, 54, "Text",
      Evaluatable->False,
      CellTags->"support"],
    Cell[404430, 12218, 937, 27, 96, "Text",
      Evaluatable->False,
      CellTags->{"support", "matrix operator"}]},
  "eq-13"->{
    Cell[390344, 11776, 302, 8, 54, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-13"]},
  "eq-14"->{
    Cell[392200, 11843, 275, 9, 28, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-14"]},
  "vector Frechet derivative"->{
    Cell[393176, 11879, 1415, 43, 96, "Text",
      Evaluatable->False,
      CellTags->"vector Frechet derivative"]},
  "eq-16add"->{
    Cell[394594, 11924, 1639, 37, 77, "NumberedEquation",
      CellTags->"eq-16add"]},
  "matrix differential operator"->{
    Cell[396236, 11963, 360, 13, 33, "Text",
      Evaluatable->False,
      CellTags->"matrix differential operator"]},
  "eq-16"->{
    Cell[396599, 11978, 945, 23, 44, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-16"]},
  "eq-17"->{
    Cell[397664, 12009, 359, 8, 56, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-17"]},
  "FrechetD"->{
    Cell[399395, 12065, 1272, 23, 261, "Input",
      CellTags->{"FrechetD", "FrechetD[]"}]},
  "FrechetD[]"->{
    Cell[399395, 12065, 1272, 23, 261, "Input",
      CellTags->{"FrechetD", "FrechetD[]"}],
    Cell[403808, 12193, 161, 5, 33, "Text",
      CellTags->"FrechetD[]"]},
  "In FrechetD[]"->{
    Cell[400670, 12090, 1199, 30, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "In FrechetD[]", "pure function", "dependent variables", 
        "independent variables"}]},
  "eq-18"->{
    Cell[402052, 12130, 692, 20, 57, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-18"]},
  "nonlinear diffusion equation"->{
    Cell[402747, 12152, 762, 28, 75, "Text",
      Evaluatable->False,
      CellTags->"nonlinear diffusion equation"]},
  "matrix operator"->{
    Cell[404430, 12218, 937, 27, 96, "Text",
      Evaluatable->False,
      CellTags->{"support", "matrix operator"}]},
  "adjoint representation"->{
    Cell[406407, 12276, 707, 18, 76, "Text",
      Evaluatable->False,
      CellTags->{
      "adjoint representation", "adjoint Frechet derivative", 
        "adjoint operator"}]},
  "adjoint Frechet derivative"->{
    Cell[406407, 12276, 707, 18, 76, "Text",
      Evaluatable->False,
      CellTags->{
      "adjoint representation", "adjoint Frechet derivative", 
        "adjoint operator"}],
    Cell[408251, 12335, 703, 16, 53, "NumberedEquation",
      Evaluatable->False,
      CellTags->{"eq-20", "adjoint Frechet derivative"}]},
  "adjoint operator"->{
    Cell[406407, 12276, 707, 18, 76, "Text",
      Evaluatable->False,
      CellTags->{
      "adjoint representation", "adjoint Frechet derivative", 
        "adjoint operator"}]},
  "eq-20"->{
    Cell[408251, 12335, 703, 16, 53, "NumberedEquation",
      Evaluatable->False,
      CellTags->{"eq-20", "adjoint Frechet derivative"}]},
  "adjoint differential operator"->{
    Cell[408957, 12353, 518, 11, 75, "Text",
      Evaluatable->False,
      CellTags->{"adjoint differential operator", "AdjointFrechetD[]"}]},
  "AdjointFrechetD[]"->{
    Cell[408957, 12353, 518, 11, 75, "Text",
      Evaluatable->False,
      CellTags->{"adjoint differential operator", "AdjointFrechetD[]"}],
    Cell[409478, 12366, 1471, 31, 230, "Input",
      PageBreakWithin->Automatic,
      PageBreakBelow->True,
      CellTags->"AdjointFrechetD[]"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"differential operators", 413755, 12487},
  {"ordinary differentiation", 414099, 12495},
  {"total differential", 414554, 12506},
  {"Frechet derivative", 414892, 12514},
  {"Euler-Lagrange derivative", 415457, 12528},
  {"prolongation", 415789, 12536},
  {"LieTraditionalForm[]", 416529, 12553},
  {"traditional form", 416865, 12561},
  {"Ordinary and partial derivatives", 417217, 12569},
  {"calculus", 417595, 12577},
  {"Gauss", 417769, 12582},
  {"Leibniz", 417945, 12587},
  {"Newton", 418120, 12592},
  {"slope", 418294, 12597},
  {"derivative", 418473, 12602},
  {"Definition: Ordinary derivative", 418673, 12607},
  {"trigonometric function", 418802, 12610},
  {"symbolic calculation", 419056, 12617},
  {"ordinary differential", 419193, 12621},
  {"independent variable", 419357, 12625},
  {"geometrical interpretation", 419527, 12629},
  {"Limit[]", 419672, 12633},
  {"pure function", 419823, 12637},
  {"tangent", 420131, 12646},
  {"envelope", 420261, 12650},
  {"differentiation of a product", 420411, 12654},
  {"rational function", 420555, 12658},
  {"differentiation of the ratio", 420706, 12661},
  {"chain rule of Leibniz", 420850, 12664},
  {"partial derivativ", 420986, 12668},
  {"Definition: Partial derivative", 421134, 12672},
  {"partial derivative", 421259, 12675},
  {"D[]", 421529, 12682},
  {"higher order derivatives", 421891, 12692},
  {"Definition: kth order derivative", 422045, 12696},
  {"order of differentiation", 422179, 12699},
  {"variational derivative", 422349, 12703},
  {"Euler derivative", 422508, 12707},
  {"tangent vector", 422665, 12711},
  {"measure", 423155, 12724},
  {"symmetry analysis", 423321, 12728},
  {"Definition: Tangent vector", 423664, 12736},
  {"eq-4", 423771, 12739},
  {"directional derivative", 423908, 12743},
  {"eq-5", 424033, 12747},
  {"operator", 424157, 12751},
  {"independent variables", 424350, 12756},
  {"input", 424857, 12769},
  {"TangentVector[]", 425044, 12774},
  {"scalar product", 425764, 12794},
  {"superposition", 425911, 12798},
  {"components of the tangent vector", 426056, 12802},
  {"tangent surface", 426224, 12806},
  {"TangentSurface[]", 426499, 12813},
  {"total derivative", 426713, 12819},
  {"dependent variables", 427017, 12827},
  {"Definition: Total derivative", 427384, 12836},
  {"eq-7", 427495, 12839},
  {"eq-8", 427617, 12843},
  {"higher order total derivatives", 427763, 12847},
  {"multi index", 427950, 12852},
  {"commutation of derivatives", 428152, 12857},
  {"Prolongations", 428292, 12861},
  {"vector field", 428438, 12865},
  {"ODE", 428586, 12869},
  {"PDE", 428734, 12873},
  {"prolong the space of variables", 428909, 12877},
  {"extension", 429105, 12883},
  {"configuration space", 429311, 12889},
  {"Definition: Prolongation", 429522, 12895},
  {"vector valued function", 429647, 12898},
  {"calculation of the kth prolongation", 429805, 12902},
  {"Taylor expansion", 429986, 12907},
  {"eq-11", 430156, 12912},
  {"prolongation[]", 430288, 12916},
  {"derivativeOrder[]", 430429, 12920},
  {"Sort[]", 430565, 12924},
  {"jet-space", 430704, 12928},
  {"k-jet", 430857, 12932},
  {"space", 431010, 12936},
  {"The Frechet derivative", 431180, 12940},
  {"generalized derivative", 431327, 12944},
  {"Gateaux", 431511, 12949},
  {"Frechet", 431695, 12954},
  {"Definition: Frechet derivative", 431902, 12959},
  {"eq-12", 432017, 12962},
  {"test function", 432148, 12966},
  {"support", 432282, 12970},
  {"eq-13", 432633, 12980},
  {"eq-14", 432755, 12984},
  {"vector Frechet derivative", 432897, 12988},
  {"eq-16add", 433032, 12992},
  {"matrix differential operator", 433156, 12995},
  {"eq-16", 433290, 12999},
  {"eq-17", 433413, 13003},
  {"FrechetD", 433538, 13007},
  {"FrechetD[]", 433650, 13010},
  {"In FrechetD[]", 433840, 13015},
  {"eq-18", 434044, 13021},
  {"nonlinear diffusion equation", 434190, 13025},
  {"matrix operator", 434334, 13029},
  {"adjoint representation", 434485, 13033},
  {"adjoint Frechet derivative", 434702, 13039},
  {"adjoint operator", 435050, 13048},
  {"eq-20", 435246, 13054},
  {"adjoint differential operator", 435425, 13058},
  {"AdjointFrechetD[]", 435595, 13062}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 301, 4, 117, "ChapterLine",
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2043, 57, 305, 4, 193, "Title",
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2351, 63, 1809, 37, 327, "Text",
  PageBreakBelow->False,
  CellTags->{
  "differential operators", "ordinary differentiation", "total differential", 
    "Frechet derivative", "Euler-Lagrange derivative", "prolongation", 
    "LieTraditionalForm[]", "traditional form"}],

Cell[CellGroupData[{
Cell[4185, 104, 391, 6, 52, "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 3}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Ordinary and partial derivatives"],
Cell[4579, 112, 1120, 21, 180, "Text",
  Evaluatable->False,
  CellTags->{
  "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}],
Cell[5702, 135, 100, 1, 38, "Definition",
  CellTags->"Definition: Ordinary derivative"],
Cell[5805, 138, 331, 11, 33, "Text",
  Evaluatable->False],
Cell[6139, 151, 392, 10, 44, "NumberedEquation"],
Cell[6534, 163, 1248, 32, 180, "Text",
  Evaluatable->False,
  CellTags->"trigonometric function"],
Cell[7785, 197, 71, 2, 27, "Input"],
Cell[7859, 201, 145, 6, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8029, 211, 103, 2, 38, "Input"],
Cell[8135, 215, 40, 1, 30, "Output"]
}, Open  ]],
Cell[8190, 219, 275, 6, 54, "Text",
  Evaluatable->False,
  CellTags->"symbolic calculation"],

Cell[CellGroupData[{
Cell[8490, 229, 75, 2, 27, "Input"],
Cell[8568, 233, 40, 1, 30, "Output"]
}, Open  ]],
Cell[8623, 237, 992, 30, 96, "Text",
  Evaluatable->False,
  CellTags->{"ordinary differential", "independent variable"}],
Cell[9618, 269, 1294, 36, 159, "Text",
  Evaluatable->False,
  CellTags->{"geometrical interpretation", "Limit[]"}],
Cell[10915, 307, 64, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[11004, 313, 103, 2, 38, "Input"],
Cell[11110, 317, 72, 1, 42, "Output"]
}, Open  ]],
Cell[11197, 321, 456, 14, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11678, 339, 97, 2, 27, "Input"],
Cell[11778, 343, 127, 3, 30, "Output"]
}, Open  ]],
Cell[11920, 349, 282, 10, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12227, 363, 70, 2, 27, "Input"],
Cell[12300, 367, 205, 5, 42, "Output"]
}, Open  ]],
Cell[12520, 375, 760, 23, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13305, 402, 96, 2, 27, "Input"],
Cell[13404, 406, 494, 13, 30, "Output"]
}, Open  ]],
Cell[13913, 422, 841, 23, 33, "Text",
  Evaluatable->False,
  CellTags->"pure function"],

Cell[CellGroupData[{
Cell[14779, 449, 109, 2, 27, "Input"],
Cell[14891, 453, 510, 13, 30, "Output"]
}, Open  ]],
Cell[15416, 469, 1059, 31, 117, "Text",
  Evaluatable->False,
  CellTags->"trigonometric function"],
Cell[16478, 502, 71, 2, 27, "Input"],
Cell[16552, 506, 673, 27, 54, "Text",
  Evaluatable->False],
Cell[17228, 535, 64, 2, 27, "Input"],
Cell[17295, 539, 85, 2, 27, "Input"],
Cell[17383, 543, 363, 13, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17771, 560, 240, 5, 114, "Input"],
Cell[18014, 567, 16865, 511, 202, 6045, 372, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[34894, 1081, 1617, 55, 138, "Text",
  Evaluatable->False,
  CellTags->{"tangent", "envelope"}],

Cell[CellGroupData[{
Cell[36536, 1140, 295, 6, 134, "Input"],
Cell[36834, 1148, 26104, 821, 233, 9491, 610, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[62953, 1972, 567, 15, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[63545, 1991, 257, 5, 114, "Input"],
Cell[63805, 1998, 20115, 557, 233, 6201, 379, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[83935, 2558, 369, 13, 54, "Text",
  Evaluatable->False],
Cell[84307, 2573, 812, 21, 96, "Text",
  Evaluatable->False,
  CellTags->"differentiation of a product"],
Cell[85122, 2596, 67, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[85214, 2602, 118, 3, 27, "Input"],
Cell[85335, 2607, 51, 1, 30, "Output"]
}, Open  ]],
Cell[85401, 2611, 358, 8, 54, "Text",
  CellTags->{"rational function", "differentiation of the ratio"}],

Cell[CellGroupData[{
Cell[85784, 2623, 135, 4, 40, "Input"],
Cell[85922, 2629, 61, 1, 44, "Output"]
}, Open  ]],
Cell[85998, 2633, 188, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"chain rule of Leibniz"],

Cell[CellGroupData[{
Cell[86211, 2642, 108, 2, 27, "Input"],
Cell[86322, 2646, 44, 1, 30, "Output"]
}, Open  ]],
Cell[86381, 2650, 525, 18, 75, "Text",
  Evaluatable->False],
Cell[86909, 2670, 1180, 22, 201, "Text",
  Evaluatable->False,
  CellTags->"partial derivativ"],
Cell[88092, 2694, 98, 1, 38, "Definition",
  CellTags->"Definition: Partial derivative"],
Cell[88193, 2697, 643, 23, 54, "Text",
  Evaluatable->False],
Cell[88839, 2722, 426, 9, 50, "NumberedEquation"],
Cell[89268, 2733, 1619, 54, 138, "Text",
  Evaluatable->False,
  CellTags->{"partial derivative", "D[]"}],

Cell[CellGroupData[{
Cell[90912, 2791, 112, 2, 28, "Input"],
Cell[91027, 2795, 45, 1, 30, "Output"]
}, Open  ]],
Cell[91087, 2799, 621, 17, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[91733, 2820, 420, 12, 28, "Input"],
Cell[92156, 2834, 45, 1, 30, "Output"]
}, Open  ]],
Cell[92216, 2838, 170, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"higher order derivatives"],

Cell[CellGroupData[{
Cell[92411, 2847, 326, 9, 28, "Input"],
Cell[92740, 2858, 51, 1, 30, "Output"]
}, Open  ]],
Cell[92806, 2862, 569, 11, 96, "Text",
  Evaluatable->False],
Cell[93378, 2875, 165, 6, 38, "Definition",
  CellTags->"Definition: kth order derivative"],
Cell[93546, 2883, 460, 17, 33, "Text",
  Evaluatable->False],
Cell[94009, 2902, 234, 4, 52, "NumberedEquation"],
Cell[94246, 2908, 1416, 48, 96, "Text",
  Evaluatable->False,
  CellTags->{"partial derivative", "order of differentiation"}],
Cell[95665, 2958, 572, 17, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[96262, 2979, 123, 3, 28, "Input"],
Cell[96388, 2984, 63, 1, 30, "Output"]
}, Open  ]],
Cell[96466, 2988, 638, 13, 96, "Text",
  Evaluatable->False,
  CellTags->{"variational derivative", "Euler derivative"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[97141, 3006, 89, 2, 52, "Section",
  Evaluatable->False,
  CellTags->"tangent vector"],
Cell[97233, 3010, 1816, 53, 159, "Text",
  Evaluatable->False,
  CellTags->{"measure", "tangent vector", "symmetry analysis"}],
Cell[99052, 3065, 90, 1, 38, "Definition",
  CellTags->"Definition: Tangent vector"],
Cell[99145, 3068, 500, 15, 33, "Text",
  Evaluatable->False,
  CellTags->"tangent vector"],
Cell[99648, 3085, 607, 18, 44, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-4"],
Cell[100258, 3105, 442, 15, 33, "Text",
  Evaluatable->False],
Cell[100703, 3122, 205, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"directional derivative"],
Cell[100911, 3129, 530, 18, 46, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-5"],
Cell[101444, 3149, 1856, 45, 222, "Text",
  Evaluatable->False,
  CellTags->{
  "operator", "independent variables", "input", "TangentVector[]"}],
Cell[103303, 3196, 250, 5, 99, "Input"],
Cell[103556, 3203, 1248, 32, 159, "Text",
  Evaluatable->False,
  CellTags->"ordinary differentiation"],

Cell[CellGroupData[{
Cell[104829, 3239, 143, 3, 27, "Input"],
Cell[104975, 3244, 83, 1, 30, "Output"]
}, Open  ]],
Cell[105073, 3248, 1338, 40, 118, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[CellGroupData[{
Cell[106436, 3292, 228, 3, 63, "Input"],
Cell[106667, 3297, 38, 1, 30, "Output"]
}, Open  ]],
Cell[106720, 3301, 342, 9, 54, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[CellGroupData[{
Cell[107087, 3314, 97, 2, 45, "Input"],
Cell[107187, 3318, 1185, 33, 50, "Output"]
}, Open  ]],
Cell[108387, 3354, 848, 29, 75, "Text",
  Evaluatable->False,
  CellTags->{"scalar product", "tangent vector"}],

Cell[CellGroupData[{
Cell[109260, 3387, 85, 2, 27, "Input"],
Cell[109348, 3391, 59, 1, 30, "Output"]
}, Open  ]],
Cell[109422, 3395, 82, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[109529, 3400, 118, 3, 27, "Input"],
Cell[109650, 3405, 120, 2, 30, "Output"]
}, Open  ]],
Cell[109785, 3410, 575, 18, 75, "Text",
  Evaluatable->False,
  CellTags->"superposition"],
Cell[110363, 3430, 622, 12, 96, "Text",
  Evaluatable->False,
  CellTags->{"components of the tangent vector", "tangent surface"}],
Cell[110988, 3444, 613, 14, 96, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],
Cell[111604, 3460, 420, 7, 153, "Input"],
Cell[112027, 3469, 247, 8, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[112299, 3481, 117, 3, 45, "Input"],
Cell[112419, 3486, 55, 1, 30, "Output"]
}, Open  ]],
Cell[112489, 3490, 390, 12, 54, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],
Cell[112882, 3504, 554, 10, 96, "Text",
  Evaluatable->False],
Cell[113439, 3516, 927, 27, 27, "NumberedEquation",
  Evaluatable->False],
Cell[114369, 3545, 620, 17, 54, "Text",
  Evaluatable->False,
  CellTags->"tangent surface"],
Cell[114992, 3564, 360, 7, 135, "Input",
  CellTags->"TangentSurface[]"],
Cell[115355, 3573, 566, 20, 54, "Text",
  Evaluatable->False,
  CellTags->"TangentSurface[]"],

Cell[CellGroupData[{
Cell[115946, 3597, 74, 2, 27, "Input"],
Cell[116023, 3601, 48, 1, 30, "Output"]
}, Open  ]],
Cell[116086, 3605, 248, 12, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[116359, 3621, 162, 3, 36, "Input"],
Cell[116524, 3626, 83733, 1710, 219, 26004, 991, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[200272, 5339, 307, 9, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[200604, 5352, 101, 2, 36, "Input"],
Cell[200708, 5356, 104, 2, 40, "Output"]
}, Open  ]],
Cell[200827, 5361, 128, 4, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[200980, 5369, 150, 4, 45, "Input"],
Cell[201133, 5375, 63740, 1338, 210, 20018, 792, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[264888, 6716, 309, 10, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[265222, 6730, 190, 4, 45, "Input"],
Cell[265415, 6736, 94636, 4025, 203, 71206, 3731, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[360066, 10764, 825, 21, 138, "Text",
  Evaluatable->False],
Cell[360894, 10787, 1172, 30, 159, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"]
}, Open  ]],

Cell[CellGroupData[{
Cell[362103, 10822, 97, 2, 52, "Section",
  Evaluatable->False,
  CellTags->"total derivative"],
Cell[362203, 10826, 1953, 68, 138, "Text",
  Evaluatable->False,
  CellTags->{"dependent variables", "independent variables"}],
Cell[364159, 10896, 94, 1, 38, "Definition",
  CellTags->"Definition: Total derivative"],
Cell[364256, 10899, 269, 9, 33, "Text",
  Evaluatable->False],
Cell[364528, 10910, 1155, 31, 69, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-7"],
Cell[365686, 10943, 159, 6, 33, "Text",
  Evaluatable->False],
Cell[365848, 10951, 415, 9, 52, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-8"],
Cell[366266, 10962, 761, 27, 54, "Text",
  Evaluatable->False],
Cell[367030, 10991, 538, 16, 75, "Text",
  Evaluatable->False,
  CellTags->"D[]"],
Cell[367571, 11009, 834, 31, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[368430, 11044, 130, 3, 28, "Input"],
Cell[368563, 11049, 51, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[368651, 11055, 85, 2, 27, "Input"],
Cell[368739, 11059, 97, 2, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[368873, 11066, 85, 2, 27, "Input"],
Cell[368961, 11070, 77, 1, 30, "Output"]
}, Open  ]],
Cell[369053, 11074, 1475, 46, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "higher order total derivatives", "multi index", "total derivative"}],
Cell[370531, 11122, 381, 11, 30, "NumberedEquation",
  Evaluatable->False],
Cell[370915, 11135, 620, 24, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[371560, 11163, 106, 2, 27, "Input"],
Cell[371669, 11167, 183, 3, 31, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[371889, 11175, 106, 2, 27, "Input"],
Cell[371998, 11179, 183, 3, 31, "Output"]
}, Open  ]],
Cell[372196, 11185, 129, 4, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[372350, 11193, 65, 2, 27, "Input"],
Cell[372418, 11197, 35, 1, 30, "Output"]
}, Open  ]],
Cell[372468, 11201, 459, 14, 54, "Text",
  Evaluatable->False,
  CellTags->"commutation of derivatives"],
Cell[372930, 11217, 330, 7, 75, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[373297, 11229, 105, 2, 52, "Section",
  Evaluatable->False,
  CellTags->{"Prolongations", "prolongation"}],
Cell[373405, 11233, 880, 19, 96, "Text",
  Evaluatable->False,
  CellTags->{"prolongation", "vector field", "ODE", "PDE"}],
Cell[374288, 11254, 1621, 50, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "prolong the space of variables", "extension", "configuration space"}],
Cell[375912, 11306, 86, 1, 38, "Definition",
  CellTags->"Definition: Prolongation"],
Cell[376001, 11309, 561, 21, 33, "Text",
  Evaluatable->False,
  CellTags->"vector valued function"],
Cell[376565, 11332, 354, 10, 27, "NumberedEquation",
  Evaluatable->False],
Cell[376922, 11344, 444, 16, 54, "Text",
  Evaluatable->False],
Cell[377369, 11362, 474, 17, 54, "Text",
  Evaluatable->False,
  CellTags->{"calculation of the kth prolongation", "Taylor expansion"}],
Cell[377846, 11381, 913, 29, 96, "Text",
  Evaluatable->False],
Cell[378762, 11412, 931, 23, 86, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-11"],
Cell[379696, 11437, 324, 11, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[380045, 11452, 168, 3, 63, "Input"],
Cell[380216, 11457, 297, 7, 50, "Output"]
}, Open  ]],
Cell[380528, 11467, 911, 28, 96, "Text",
  Evaluatable->False,
  CellTags->{"D[]", "prolongation[]"}],
Cell[381442, 11497, 348, 7, 153, "Input"],
Cell[381793, 11506, 586, 15, 75, "Text",
  Evaluatable->False,
  CellTags->{"derivativeOrder[]", "Sort[]"}],
Cell[382382, 11523, 1109, 26, 99, "Input"],
Cell[383494, 11551, 682, 20, 96, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[384201, 11575, 98, 2, 27, "Input"],
Cell[384302, 11579, 140, 2, 30, "Output"]
}, Open  ]],
Cell[384457, 11584, 1266, 41, 117, "Text",
  Evaluatable->False,
  CellTags->{"jet-space", "k-jet", "prolongation", "space"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[385760, 11630, 113, 2, 52, "Section",
  Evaluatable->False,
  CellTags->"The Frechet derivative"],
Cell[385876, 11634, 1118, 28, 117, "Text",
  Evaluatable->False,
  CellTags->{
  "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}],
Cell[386997, 11664, 106, 1, 38, "Definition",
  CellTags->"Definition: Frechet derivative"],
Cell[387106, 11667, 970, 34, 75, "Text",
  Evaluatable->False,
  CellTags->"Frechet derivative"],
Cell[388079, 11703, 760, 20, 41, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-12"],
Cell[388842, 11725, 394, 13, 54, "Text",
  Evaluatable->False,
  CellTags->{"test function", "support"}],
Cell[389239, 11740, 1102, 34, 117, "Text",
  Evaluatable->False],
Cell[390344, 11776, 302, 8, 54, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-13"],
Cell[390649, 11786, 564, 21, 54, "Text",
  Evaluatable->False,
  CellTags->"support"],
Cell[391216, 11809, 981, 32, 54, "Text",
  Evaluatable->False,
  CellTags->"Frechet derivative"],
Cell[392200, 11843, 275, 9, 28, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-14"],
Cell[392478, 11854, 447, 16, 54, "Text",
  Evaluatable->False],
Cell[392928, 11872, 245, 5, 27, "NumberedEquation",
  Evaluatable->False],
Cell[393176, 11879, 1415, 43, 96, "Text",
  Evaluatable->False,
  CellTags->"vector Frechet derivative"],
Cell[394594, 11924, 1639, 37, 77, "NumberedEquation",
  CellTags->"eq-16add"],
Cell[396236, 11963, 360, 13, 33, "Text",
  Evaluatable->False,
  CellTags->"matrix differential operator"],
Cell[396599, 11978, 945, 23, 44, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-16"],
Cell[397547, 12003, 114, 4, 33, "Text",
  Evaluatable->False],
Cell[397664, 12009, 359, 8, 56, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-17"],
Cell[398026, 12019, 1366, 44, 117, "Text",
  Evaluatable->False],
Cell[399395, 12065, 1272, 23, 261, "Input",
  CellTags->{"FrechetD", "FrechetD[]"}],
Cell[400670, 12090, 1199, 30, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "In FrechetD[]", "pure function", "dependent variables", 
    "independent variables"}],
Cell[401872, 12122, 28, 0, 33, "Example"],
Cell[401903, 12124, 146, 4, 33, "Text",
  Evaluatable->False],
Cell[402052, 12130, 692, 20, 57, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-18"],
Cell[402747, 12152, 762, 28, 75, "Text",
  Evaluatable->False,
  CellTags->"nonlinear diffusion equation"],

Cell[CellGroupData[{
Cell[403534, 12184, 179, 3, 42, "Input"],
Cell[403716, 12189, 77, 1, 40, "Output"]
}, Open  ]],
Cell[403808, 12193, 161, 5, 33, "Text",
  CellTags->"FrechetD[]"],

Cell[CellGroupData[{
Cell[403994, 12202, 148, 3, 45, "Input"],
Cell[404145, 12207, 270, 8, 59, "Output"]
}, Open  ]],
Cell[404430, 12218, 937, 27, 96, "Text",
  Evaluatable->False,
  CellTags->{"support", "matrix operator"}],
Cell[405370, 12247, 1034, 27, 62, "NumberedEquation"],
Cell[406407, 12276, 707, 18, 76, "Text",
  Evaluatable->False,
  CellTags->{
  "adjoint representation", "adjoint Frechet derivative", 
    "adjoint operator"}],
Cell[407117, 12296, 552, 17, 29, "NumberedEquation",
  Evaluatable->False],
Cell[407672, 12315, 576, 18, 75, "Text",
  Evaluatable->False],
Cell[408251, 12335, 703, 16, 53, "NumberedEquation",
  Evaluatable->False,
  CellTags->{"eq-20", "adjoint Frechet derivative"}],
Cell[408957, 12353, 518, 11, 75, "Text",
  Evaluatable->False,
  CellTags->{"adjoint differential operator", "AdjointFrechetD[]"}],
Cell[409478, 12366, 1471, 31, 230, "Input",
  PageBreakWithin->Automatic,
  PageBreakBelow->True,
  CellTags->"AdjointFrechetD[]"],
Cell[410952, 12399, 200, 7, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[411177, 12410, 134, 2, 45, "Input"],
Cell[411314, 12414, 308, 10, 59, "Output"]
}, Open  ]],
Cell[411637, 12427, 148, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

