(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    356014,      11465]*)
(*NotebookOutlinePosition[    442901,      13668]*)
(*  CellTagsIndexPosition[    432234,      13402]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["3.6 The Euler Derivative", "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 3}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 22}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"The Euler derivative"],

Cell[TextData[{
  "In this section, we will discuss the Euler derivative. The Euler \
derivative, also known as the functional derivative, has its origin in the ",
  StyleBox["calculus of variations",
    FontSlant->"Italic"],
  ".  The term ",
  StyleBox["calculus of variations ",
    FontSlant->"Italic"],
  "was first coined by Leonhard Euler in 1756. He used it to describe a new \
method in mechanics which Lagrange had developed 1 year earlier. Thus, the \
original application of the Euler derivative originates from mechanics. In \
this context, Euler and Lagrange used this sort of derivative to write down \
their famous equations, the Euler-Lagrange equations. Up to now, the main \
application of this derivative in physics has been the formulation of \
dynamical equations. In C",
  ButtonBox["hapter 9",
    ButtonData:>{"Symmet75.nb", None},
    ButtonStyle->"Hyperlink"],
  ", we will show that the Euler derivative is a useful tool in connection \
with Lie-B\[ADoubleDot]cklund or generalized symmetries. Before we discuss \
the Euler derivative and its implementation, we recall briefly the basic \
properties of the origin in the calculus of variations."
}], "Text",
  Evaluatable->False,
  PageBreakBelow->False,
  CellTags->{
  "calculus of variations", "Euler", "Lagrange", "Euler-Lagrange equations", 
    "dynamical equations", "generalized symmetries"}],

Cell[CellGroupData[{

Cell["3.6.1 The Problem of Variation", "Subsection",
  Evaluatable->False,
  CellTags->"The Problem of Variations"],

Cell[TextData[{
  "The calculus of variations was first used by Johann Bernoulli in July \
1696, when he presented the ",
  StyleBox["brachystochrone problem",
    FontSlant->"Italic"],
  ". The problem can be formulated as follows. A point mass is moving \
frictionless in a homogenous force field along a path joining two points. The \
question is which curve connects the two points for the shortest travel. \
Johann Bernoulli announced the solution of the problem, but did not present \
his findings in public. He preferred to first challenge his contemporaries to \
examine the problem, too. This challenge was particularly aimed at his \
brother and teacher Jakob Bernoulli, who was his bitter enemy. Jakob found \
one solution, but did not present it to Johann. It was only upon the \
intervention of Leibniz, with whom Jakob had a lifelong friendship and a \
scientific correspondence, that he sent it to his brother in May 1697. The \
most fascinating event was that this solution was a cycloid, a curve also \
discovered at this time."
}], "Text",
  Evaluatable->False,
  PageBreakBelow->False,
  AspectRatioFixed->True,
  CellTags->{
  "Bernoulli", "brachystochrone problem", "Leibniz", 
    "calculus of variations"}],

Cell[TextData[{
  "As mentioned above, the main idea in the calculus of variations arose from \
the work of Euler and Lagrange. Later, Hamilton contributed the term ",
  StyleBox["minimum principle ",
    FontSlant->"Italic"],
  "to the theory, and it is still in use today. The main idea of all these \
considerations of Euler, Lagrange, and Hamilton is the assumption that there \
exists a generating functional ",
  StyleBox["F. ",
    FontSlant->"Italic"],
  "This functional is responsible for the dynamical development of the \
motion. The key point in the calculus of variations is to find a function  \
which extremizes the functional ",
  StyleBox["F",
    FontSlant->"Italic"],
  ". The solution of this issue is to vary the function by introducing a test \
function. Thus, the variation of ",
  StyleBox["F",
    FontSlant->"Italic"],
  " is actually carried out by replacing the function ",
  StyleBox["u",
    FontSlant->"Italic"],
  " by a slightly changed new function ",
  Cell[BoxData[
      \(TraditionalForm\`u + \[Epsilon]\ w\)]],
  ", where \[Epsilon] is a small parameter and ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " denotes an arbitrary test function. After replacing ",
  StyleBox["u",
    FontSlant->"Italic"],
  " and all of its higher derivatives in the functional ",
  StyleBox["F",
    FontSlant->"Italic"],
  ", we have to determine the extreme of ",
  StyleBox["F",
    FontSlant->"Italic"],
  ". The functional in this representation can be considered as a function of \
the parameter \[Epsilon]. The maximum or minimum of ",
  StyleBox["F",
    FontSlant->"Italic"],
  " is found if we use the standard procedure of calculus for finding extreme \
values.  In mathematical terms, we need to calculate the derivative of ",
  StyleBox["F",
    FontSlant->"Italic"],
  " with respect to \[Epsilon] under the condition that \[Epsilon] vanishes:"
}], "Text",
  Evaluatable->False,
  PageBreakWithin->True,
  AspectRatioFixed->True,
  CellTags->{
  "Hamilton", "minimum principle", "calculus of variations", 
    "generating functional", "minimize", "higher derivatives", "functional"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          FormBox[
            RowBox[{
              FractionBox[
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["d",
                        FontFamily->"Times",
                        FontSize->10,
                        FontWeight->"Roman",
                        FontSlant->"Italic",
                        FontTracking->"Plain",
                        PrivateFontOptions->{
                        "FontPostScriptName"->Automatic}], 
                      StyleBox["F",
                        FontWeight->"Roman",
                        FontSlant->"Italic"]}]], "(", "\[Epsilon]", ")"}], 
                \(d\ \[Epsilon]\)], \(|\_\(\[Epsilon] = 0\)\)}],
            "TraditionalForm"],
          "TraditionalForm"], "=", " ", "0."}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"eq-1"],

Cell[TextData[{
  "The basic problem of the calculus of variations is to determine a \
function",
  StyleBox[" u(x)",
    FontSlant->"Italic"],
  " such that the integral"
}], "Text",
  Evaluatable->False],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(F[u]\), " ", "=", " ", 
          RowBox[{
            RowBox[{
              SubsuperscriptBox[
                StyleBox["\[Integral]",
                  ScriptLevel->0], \(x\_1\), \(x\_2\)], 
              \(\(f(x, u, u\_x, \[Ellipsis])\) \[DifferentialD]x\)}], " ", 
            "=", " ", 
            RowBox[{
              SubsuperscriptBox[
                StyleBox["\[Integral]",
                  ScriptLevel->0], \(x\_1\), \(x\_2\)], 
              \(\(f(x, u\_\((k)\))\) \[DifferentialD]x\)}]}]}], " ", ",", 
        "       ", \(k = 1\), ",", "2", ",", "\[Ellipsis]"}], 
      TraditionalForm]]]], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-2"],

Cell[TextData[{
  "assumes an extreme. An extreme here is either a maximum or a minimum. In \
equation ",
  ButtonBox["(3.24),",
    ButtonData:>"eq-2",
    ButtonStyle->"Hyperlink"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`u\_x = \[PartialD]u/\[PartialD]x\)]],
  " denotes the partial derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`\(u\ \)\)]],
  "with respect to the independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is a vector of coordinates. Let us assume first that we have only one \
independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". This assumption will make it easier to represent and discuss the theory. \
A generalization to more independent variables will be given below."
}], "Text",
  Evaluatable->False,
  CellTags->{"extreme", "maximum", "minimum"}],

Cell[TextData[{
  "The expression ",
  Cell[BoxData[
      \(TraditionalForm\`F[u]\)]],
  " given in equation ",
  ButtonBox["(3.24)",
    ButtonData:>"eq-2",
    ButtonStyle->"Hyperlink"],
  " is called a functional defined by an integral over a density ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " which depends on the independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and the unknown function ",
  StyleBox["u",
    FontSlant->"Italic"],
  ". In general, this density may also depend on derivatives of ",
  StyleBox["u",
    FontSlant->"Italic"],
  " up to a certain order ",
  StyleBox["k",
    FontSlant->"Italic"],
  ",",
  StyleBox[" ",
    FontSlant->"Italic"],
  "denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  ". The limits in the integral ",
  ButtonBox["(3.24)",
    ButtonData:>"eq-2",
    ButtonStyle->"Hyperlink"],
  " are assumed to be fixed. We note that fixed limits are not necessary. If \
they are allowed to vary, the problem increases in such a way that not only ",
  
  Cell[BoxData[
      \(TraditionalForm\`u(x)\)]],
  " but also ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  " are needed to bring ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " to an extreme value. The question is how to manage the functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " in becoming an extreme. Let us assume that an extreme of ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " exists if a function ",
  Cell[BoxData[
      \(TraditionalForm\`u = u(x)\)]],
  " makes the functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " a minimum. Then, any neighboring function, no matter how close it \
approaches ",
  Cell[BoxData[
      \(TraditionalForm\`u(x)\)]],
  ", must make ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " increase. The definition of a neighboring or test function may be as \
follows. We introduce a parametric representation of ",
  Cell[BoxData[
      \(TraditionalForm\`u = u(x; \[Epsilon])\)]],
  " in such a way that for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(u = \(u(x; \[Epsilon] = 0) = u(x)\), \)\)]],
  " we get the identity and the functional yields an extreme. We write the \
small perturbation of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " as"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "functional", "extreme", "test function", "parametric representation", 
    "small perturbation"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`u(x; \[Epsilon])\  = \ u(x; 0)\  + \ \[Epsilon]\ \(w(x)\)\)]],
  ","
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-3"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`w(x)\)]],
  " is the test function which has continuous derivatives and vanishes at the \
endpoints ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\ \)\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  ". We note that the vanishing of ",
  Cell[BoxData[
      \(TraditionalForm\`w(x)\)]],
  " at ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                FormBox[\(w(x\_1\),
                  "TraditionalForm"], ")"}], " ", "=", " ", 
              FormBox[\(w(x\_2\),
                "TraditionalForm"]}], ")"}], "=", "0"}], TraditionalForm]]],
  " is one of the basic assumptions of the calculus of variations."
}], "Text",
  Evaluatable->False,
  CellTags->"continuous derivative"],

Cell[TextData[{
  "If functions of the type given in equation ",
  ButtonBox["(3.25)",
    ButtonData:>"eq-3",
    ButtonStyle->"Hyperlink"],
  " are considered as variations of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", the functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " becomes a function of \[Epsilon]\[ThinSpace]:"
}], "Text",
  Evaluatable->False,
  CellTags->"variation"],

Cell[TextData[{
  StyleBox["F",
    FontSlant->"Italic"],
  "[",
  StyleBox["u",
    FontSlant->"Italic"],
  ";\[Epsilon]] =",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["\[Integral]",
              ScriptLevel->0], \(x\_1\), \(x\_2\)], 
          \(\(f(x, u(x; \[Epsilon]), \(u\_x\)(x, \[Epsilon]), \[Ellipsis])\) 
            \[DifferentialD]x\)}], TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-4"],

Cell[TextData[{
  "The condition that the integral has a stationary value (in other words, an \
extreme) is that ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " be independent of \[Epsilon] in first order. This means that"
}], "Text",
  Evaluatable->False,
  CellTags->"stationary value"],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]F\/\[PartialD]\[Epsilon]\( \[VerticalSeparator] 
          \_\(\[Epsilon] = 0\)\)\ \( = \ 0\)\)], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-5"],

Cell[TextData[{
  "for all functions ",
  Cell[BoxData[
      \(TraditionalForm\`w(x)\)]],
  ". This is a necessary condition but not a sufficient one. We will not \
pursue the details of the sufficient conditions here. They were extensively \
discussed by ",
  ButtonBox["Blanchard and Br\[UDoubleDot]ning [1992]",
    ButtonData:>{"Literat.nb", "Blan-92"},
    ButtonStyle->"Hyperlink"],
  ". To demonstrate how these formulas work in detail, let us consider the \
simple example of the shortest connection between two points in an Euclidean \
plane."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "necessary condition", "sufficient condition", 
    "shortest connection between two points", "Euclidean plane"}],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Let us consider the equation of a curve in a Euclidean space which yields \
the shortest distance between two points in the plane. The geometrical \
increment of distance ",
  Cell[BoxData[
      FormBox[
        StyleBox["ds",
          FontSlant->"Italic"], TraditionalForm]]],
  " in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, x\)\)]],
  ")-plane is given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"Euclidean space", "geometrical increment"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox["ds",
          FontSlant->"Italic"], " ", "=", " ", 
        RowBox[{
          FormBox[
            RowBox[{
              SqrtBox[
                RowBox[{
                  RowBox[{
                    SuperscriptBox[
                      StyleBox["dx",
                        FontSlant->"Italic"], "2"], "+", 
                    SuperscriptBox[
                      StyleBox["du",
                        FontSlant->"Italic"], "2"]}], " "}]], " ", "=", " ", 
              RowBox[{
                SqrtBox[
                  RowBox[{"1", "+", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        StyleBox[\(du\/dx\),
                          FontSlant->"Italic"], ")"}], "2"]}]], 
                StyleBox["dx",
                  FontSlant->"Italic"]}]}],
            "TraditionalForm"], "."}]}], TextForm]], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-6"],

Cell[TextData[{
  "The total length ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " of the curve between two points ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  " is"
}], "Text",
  Evaluatable->False,
  CellTags->"total length between two points"],

Cell[BoxData[
    FormBox[
      RowBox[{"s", " ", "=", " ", 
        RowBox[{
          
          FormBox[\(\[Integral]\_x\_1\%x\_2\(\@\( 1 + u\_x\%2\)\) 
                  \[DifferentialD]x\  \[Congruent] \ F[u]\),
            "TraditionalForm"], "."}]}], TextForm]], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-7"],

Cell["\<\
We know that the shortest connection between two points in the \
Euclidean plane is a straight line given by\
\>", "Text",
  Evaluatable->False,
  CellTags->"straight line"],

Cell[TextData[{
  StyleBox["u", "DisplayFormula",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ")= \[Alpha] ",
  StyleBox["x",
    FontSlant->"Italic"],
  " + \[Beta],"
}], "NumberedEquation",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  CellTags->"eq-8"],

Cell[TextData[{
  "where \[Alpha] and \[Beta] are constants determining the slope and the \
intersection of the line with the vertical coordinate axis. Now let us \
consider the line in the range ",
  StyleBox["x",
    FontSlant->"Italic"],
  " \[Element] [0, 2\[Pi]]. To demonstrate the numerical behavior of the \
functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ", we choose a special test function ",
  Cell[BoxData[
      \(TraditionalForm\`w(x) = sin(4  x)\)]],
  ". Using our representation of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " given by equation ",
  ButtonBox["(3.30)",
    ButtonData:>"eq-8",
    ButtonStyle->"Hyperlink"],
  " with \[Alpha]=1 and \[Beta]=0 for example, we get for the derivative of ",
  
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ","
}], "Text",
  Evaluatable->False,
  CellTags->{"slope", "functional", "test function"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(u\_x\), "=", " ", 
        RowBox[{"1", " ", "+", " ", 
          RowBox[{
            StyleBox["4",
              AutoSpacing->True,
              ScriptSizeMultipliers->0.71,
              ScriptMinSize->5,
              ScriptLevel->0], 
            StyleBox["\[Epsilon]",
              AutoSpacing->True,
              ScriptSizeMultipliers->0.71,
              ScriptMinSize->5,
              ScriptLevel->0], " ", \(cos(4  x) . \)}]}]}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Inserting this representation into ",
  ButtonBox["(3.29)",
    ButtonData:>"eq-7",
    ButtonStyle->"Hyperlink"],
  " we find"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{\(F[\[Epsilon]]\), " ", "=", " ", 
          FormBox[
            RowBox[{
              SubsuperscriptBox[
                StyleBox["\[Integral]",
                  ScriptLevel->0], "0", \(2  \[Pi]\)], 
              \(\(\@\(1 + 
                      4  \[Epsilon]\ \(cos(\[NegativeThinSpace]4  x)\)\)\) 
                \[DifferentialD]x\)}],
            "TraditionalForm"]}], TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-10"],

Cell[TextData[{
  "This relation represents our specific functional. We are looking for the \
minimum of this function to get the extreme of the functional. Considered as \
a function of \[Epsilon], this relation cannot be solved for \[Epsilon]. \
However, to get an idea of the dependence on the parameter \[Epsilon], we can \
use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". If we define equation ",
  ButtonBox["(3.32)",
    ButtonData:>"eq-10",
    ButtonStyle->"Hyperlink"],
  " as a function depending on \[Epsilon], we can use the numerical \
capabilities of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to graphically represent the dependence of ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " on \[Epsilon]. First, let us define equation ",
  ButtonBox["(3.32)",
    ButtonData:>"eq-10",
    ButtonStyle->"Hyperlink"],
  " by"
}], "Text",
  Evaluatable->False,
  CellTags->"minimum"],

Cell[BoxData[
    \(F[\[Epsilon]_] := 
      NIntegrate[\n\t\t
        \@\(1 + \((1 + 4\ \[Epsilon]\ Cos[4\ x])\)\^2\), {x, 0, 2\ \[Pi]}]
        \)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "We then use the defined function ",
  StyleBox["F[]", "MmaText"],
  " in connection with ",
  StyleBox["Plot[]", "MmaText"],
  " to represent the value of the functional for certain values of \
\[Epsilon]:  "
}], "Text",
  Evaluatable->False,
  CellTags->{"Plot[]", "functional"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[F[\[Epsilon]]], {\[Epsilon], \(-1\), 1}, 
      AxesLabel \[Rule] {"\<\[Epsilon]\>", "\<F\>"}, 
      PlotStyle \[Rule] RGBColor[1, 0, 0]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 -0.549842 0.063535 [
[.02381 .00947 -6 -9 ]
[.02381 .00947 6 0 ]
[.2619 .00947 -12 -9 ]
[.2619 .00947 12 0 ]
[.7381 .00947 -9 -9 ]
[.7381 .00947 9 0 ]
[.97619 .00947 -3 -9 ]
[.97619 .00947 3 0 ]
[1.025 .02197 0 -6.4375 ]
[1.025 .02197 10 6.4375 ]
[.4875 .08551 -12 -4.5 ]
[.4875 .08551 0 4.5 ]
[.4875 .21258 -12 -4.5 ]
[.4875 .21258 0 4.5 ]
[.4875 .33965 -12 -4.5 ]
[.4875 .33965 0 4.5 ]
[.4875 .46672 -12 -4.5 ]
[.4875 .46672 0 4.5 ]
[.4875 .59379 -12 -4.5 ]
[.4875 .59379 0 4.5 ]
[.5 .64303 -5 0 ]
[.5 .64303 5 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .02197 m
.02381 .02822 L
s
[(-1)] .02381 .00947 0 1 Mshowa
.2619 .02197 m
.2619 .02822 L
s
[(-0.5)] .2619 .00947 0 1 Mshowa
.7381 .02197 m
.7381 .02822 L
s
[(0.5)] .7381 .00947 0 1 Mshowa
.97619 .02197 m
.97619 .02822 L
s
[(1)] .97619 .00947 0 1 Mshowa
.125 Mabswid
.07143 .02197 m
.07143 .02572 L
s
.11905 .02197 m
.11905 .02572 L
s
.16667 .02197 m
.16667 .02572 L
s
.21429 .02197 m
.21429 .02572 L
s
.30952 .02197 m
.30952 .02572 L
s
.35714 .02197 m
.35714 .02572 L
s
.40476 .02197 m
.40476 .02572 L
s
.45238 .02197 m
.45238 .02572 L
s
.54762 .02197 m
.54762 .02572 L
s
.59524 .02197 m
.59524 .02572 L
s
.64286 .02197 m
.64286 .02572 L
s
.69048 .02197 m
.69048 .02572 L
s
.78571 .02197 m
.78571 .02572 L
s
.83333 .02197 m
.83333 .02572 L
s
.88095 .02197 m
.88095 .02572 L
s
.92857 .02197 m
.92857 .02572 L
s
.25 Mabswid
0 .02197 m
1 .02197 L
s
gsave
1.025 .02197 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
.5 .08551 m
.50625 .08551 L
s
[(10)] .4875 .08551 1 0 Mshowa
.5 .21258 m
.50625 .21258 L
s
[(12)] .4875 .21258 1 0 Mshowa
.5 .33965 m
.50625 .33965 L
s
[(14)] .4875 .33965 1 0 Mshowa
.5 .46672 m
.50625 .46672 L
s
[(16)] .4875 .46672 1 0 Mshowa
.5 .59379 m
.50625 .59379 L
s
[(18)] .4875 .59379 1 0 Mshowa
.125 Mabswid
.5 .11728 m
.50375 .11728 L
s
.5 .14904 m
.50375 .14904 L
s
.5 .18081 m
.50375 .18081 L
s
.5 .24435 m
.50375 .24435 L
s
.5 .27611 m
.50375 .27611 L
s
.5 .30788 m
.50375 .30788 L
s
.5 .37142 m
.50375 .37142 L
s
.5 .40318 m
.50375 .40318 L
s
.5 .43495 m
.50375 .43495 L
s
.5 .49849 m
.50375 .49849 L
s
.5 .53025 m
.50375 .53025 L
s
.5 .56202 m
.50375 .56202 L
s
.5 .05374 m
.50375 .05374 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .60332 m
.06244 .53006 L
.10458 .45188 L
.14415 .38055 L
.18221 .31445 L
.22272 .24768 L
.26171 .18813 L
.30316 .13185 L
.34309 .08677 L
.3815 .05383 L
.40134 .04107 L
.42237 .03057 L
.43178 .02682 L
.4419 .02339 L
.45139 .02073 L
.4602 .01872 L
.47031 .01693 L
.47564 .0162 L
.48134 .01559 L
.48394 .01536 L
.48676 .01515 L
.48925 .015 L
.49187 .01488 L
.49424 .0148 L
.49559 .01476 L
.49685 .01474 L
.498 .01472 L
.49906 .01472 L
.50027 .01472 L
.50143 .01472 L
.50256 .01473 L
.50379 .01475 L
.50495 .01478 L
.50601 .0148 L
.50848 .01489 L
.51108 .01502 L
.51598 .01535 L
.52133 .01585 L
.53088 .01711 L
.53975 .01871 L
.55028 .02116 L
.56021 .02406 L
.5788 .03107 L
.59881 .04116 L
.61727 .05295 L
.65667 .08653 L
.69456 .129 L
.7349 .18322 L
.77372 .24202 L
.815 .30971 L
Mistroke
.85476 .37862 L
.893 .44746 L
.9337 .52283 L
.97288 .597 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{300, 143},
  ImageMargins->{{10, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005g0000/Q000`40O003h00O@goo1@00;7oo1000
1Goo0P001Goo1000FGoo10001Goo0P001Goo1000;7oo1@00DGoo0015Ool00`00Oomoo`0[Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`1EOol00`00Oomoo`02
Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0[Ool00`00Oomoo`1AOol004Eo
o`03001oogoo02]oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo05Eoo`03001oogoo009o
o`03001oogoo00eoo`03001oogoo02]oo`03001oogoo055oo`00>Woo1P001Goo00<007ooOol08goo
1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol0EGoo00<007ooOol00Woo00<007oo
Ool03Goo00<007ooOol0:goo00<007ooOol0DGoo0015Ool00`00Oomoo`0[Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool4001HOol00`00Oomoo`02Ool00`00Oomoo`09Ool4000^Ool00`00Oomoo`1AOol0
04Eoo`03001oogoo02]oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo05Uoo`03001oogoo
009oo`03001oogoo00Uoo`03001oogoo02moo`03001oogoo055oo`00@goo0`00;Goo00<007ooOol0
0Woo00<007ooOol02Goo00<007ooOol0FGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
;Goo0`00Dgoo0015Ool00`00Oomoo`0/Ool4000<Ool5001HOol4000<Ool5000]Ool00`00Oomoo`1A
Ool00?moogQoo`00/Woo00<007ooOol0`Woo002bOol00`00Oomoo`32Ool00;9oo`03001oogoo0<9o
o`00[Goo2W`0O7oo1000@7oo002XOol5O005Ool00`00Oomoo`02Ool6O01eOol00`00Oomoo`02Ool0
0`00Oomoo`0mOol003aoofL000El01D000El06P000Qoo`03001oogoo049oo`00@Goo00<007ooOol0
27oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol027oo00<007ooOol02Goo00<007ooOol0
27oo00<007ooOol027oo00<007ooOol02Goo00<007ooOol00Woo0W`017oo00<007ooOol027oo00<0
07ooOol02Goo00@007ooOomoo`9l00Eoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Uo
o`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Qo
o`03001oogoo00aoo`D0041oo`00X7oo00=l07ooOol03goo00<007ooOol03goo0W`0KGoo00<007oo
Ool0@Goo002NOol2O00BOol00`00Oomoo`0AOol2O01/Ool4000oOol009aoo`9l01Aoo`03001oogoo
01=oo`9l0:eoo`00Vgoo00=l07ooOol057oo00<007ooOol05Goo00=l07ooOol0ZWoo002IOol2O00G
Ool00`00Oomoo`0FOol2O02ZOol009Moo`9l01Uoo`03001oogoo01Qoo`9l0:Qoo`00UWoo00=l07oo
Ool06Goo0P006goo00=l07ooOol0YGoo002EOol00g`0Oomoo`0JOol00`00Oomoo`0KOol00g`0Oomo
o`2TOol009=oo`9l01eoo`03001oogoo01aoo`03O01oogoo0:=oo`00TWoo00=l07ooOol07Goo00<0
07ooOol07Goo0W`0Xgoo002AOol00g`0Oomoo`0=Ool50003Ool40005Ool00`00Oomoo`0OOol00g`0
Oomoo`2POol008moo`9l019oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo021oo`03O01oogoo09moo`00SWoo00=l07ooOol04Woo00<007ooOol00Woo00<007ooOol00Woo
00<007ooOol00Woo00<007ooOol08Goo00=l07ooOol0WWoo002=Ool00g`0Oomoo`0COol00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool3000ROol00g`0Oomoo`2MOol008aoo`03O01oogoo
01Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo02=oo`03O01oogoo
09aoo`00Rgoo00=l07ooOol05Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol097oo00=l07ooOol0Vgoo002:Ool00g`0Oomoo`0DOol30004Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool00`00Oomoo`0UOol00g`0Oomoo`2JOol008Uoo`03O01oogoo01Moo`03001oogoo00=o
o`@000Eoo`03001oogoo02Ioo`03O01oogoo09Uoo`00R7oo00=l07ooOol09goo00<007ooOol09goo
00=l07ooOol0V7oo0028Ool00g`0Oomoo`0WOol00`00Oomoo`0WOol00g`0Oomoo`2HOol008Moo`03
O01oogoo02Qoo`03001oogoo02Qoo`03O01oogoo09Moo`00QWoo00=l07ooOol0:Goo0P00:Woo00=l
07ooOol0UWoo0025Ool00g`0Oomoo`0ZOol00`00Oomoo`0ZOol00g`0Oomoo`2EOol008Aoo`03O01o
ogoo02]oo`03001oogoo02]oo`03O01oogoo09Aoo`00Pgoo00=l07ooOol0;7oo00<007ooOol0;7oo
00=l07ooOol0Tgoo0022Ool00g`0Oomoo`0]Ool00`00Oomoo`0]Ool00g`0Oomoo`2BOol0089oo`03
O01oogoo02eoo`03001oogoo02eoo`03O01oogoo099oo`00PGoo00=l07ooOol0;Woo00<007ooOol0
;Woo00=l07ooOol0TGoo0020Ool00g`0Oomoo`0_Ool2000`Ool00g`0Oomoo`2@Ool0081oo`03O01o
ogoo02moo`03001oogoo031oo`03O01oogoo08moo`00Ogoo00=l07ooOol0<7oo00<007ooOol0<7oo
00=l07ooOol0Sgoo001nOol00g`0Oomoo`0aOol00`00Oomoo`0aOol00g`0Oomoo`2>Ool007eoo`03
O01oogoo039oo`03001oogoo039oo`03O01oogoo08eoo`00OGoo00=l07ooOol0<Woo00<007ooOol0
<goo00=l07ooOol0S7oo001lOol00g`0Oomoo`0cOol00`00Oomoo`0cOol00g`0Oomoo`2<Ool007]o
o`03O01oogoo03Aoo`03001oogoo03Aoo`03O01oogoo08]oo`00Ngoo00=l07ooOol0=7oo0P00=Woo
00=l07ooOol0RWoo001jOol00g`0Oomoo`0eOol00`00Oomoo`0fOol00g`0Oomoo`29Ool007Uoo`03
O01oogoo03Ioo`03001oogoo03Ioo`03O01oogoo08Uoo`00NGoo00=l07ooOol0=Woo00<007ooOol0
=goo00=l07ooOol0R7oo001hOol00g`0Oomoo`0VOol50002Ool50005Ool00`00Oomoo`0hOol00g`0
Oomoo`27Ool007Moo`03O01oogoo02Uoo`03001oogoo009oo`05001oogooOol00005Ool00`00Oomo
o`0hOol00g`0Oomoo`27Ool007Moo`03O01oogoo02Uoo`03001oogoo00=oo`03001oogoo00Ioo`03
001oogoo03Uoo`03O01oogoo08Ioo`00MWoo00=l07ooOol0:Woo00<007ooOol017oo00<007ooOol0
1Goo0`00>Woo00=l07ooOol0QGoo001eOol00g`0Oomoo`0[Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`0jOol00g`0Oomoo`25Ool007Eoo`03O01oogoo02]oo`03001oogoo00Ioo`03001o
ogoo00=oo`03001oogoo03]oo`03O01oogoo08Aoo`00M7oo00=l07ooOol0:Woo0`0017oo00D007oo
Oomoo`0000Eoo`03001oogoo03]oo`03O01oogoo08Aoo`00Lgoo00=l07ooOol0;Goo00<007ooOol0
0goo0`001Woo00<007ooOol0?7oo00=l07ooOol0Pgoo001cOol00g`0Oomoo`0lOol00`00Oomoo`0m
Ool00g`0Oomoo`22Ool0079oo`03O01oogoo03eoo`03001oogoo03eoo`03O01oogoo089oo`00LGoo
00=l07ooOol0?Woo00<007ooOol0?Woo00=l07ooOol0PGoo001aOol00g`0Oomoo`0nOol20010Ool0
0g`0Oomoo`20Ool0071oo`03O01oogoo03moo`03001oogoo03moo`03O01oogoo081oo`00Kgoo00=l
07ooOol0@7oo00<007ooOol0@7oo00=l07ooOol0Ogoo001_Ool00g`0Oomoo`10Ool00`00Oomoo`11
Ool00g`0Oomoo`1nOol006ioo`03O01oogoo045oo`03001oogoo045oo`03O01oogoo07ioo`00KWoo
00=l07ooOol0@Goo00<007ooOol0@Woo00=l07ooOol0OGoo001]Ool00g`0Oomoo`12Ool00`00Oomo
o`12Ool00g`0Oomoo`1mOol006aoo`03O01oogoo04=oo`8004Aoo`03O01oogoo07aoo`00K7oo00=l
07ooOol0@goo00<007ooOol0A7oo00=l07ooOol0Ngoo001[Ool00g`0Oomoo`14Ool00`00Oomoo`14
Ool00g`0Oomoo`1kOol006]oo`03O01oogoo04Aoo`03001oogoo04Eoo`03O01oogoo07Yoo`00JWoo
00=l07ooOol0AGoo00<007ooOol0AWoo00=l07ooOol0NGoo001YOol00g`0Oomoo`16Ool00`00Oomo
o`16Ool00g`0Oomoo`1iOol006Uoo`03O01oogoo04Ioo`03001oogoo04Moo`03O01oogoo07Qoo`00
J7oo00=l07ooOol0Agoo00<007ooOol0Agoo00=l07ooOol0N7oo001XOol00g`0Oomoo`17Ool20019
Ool00g`0Oomoo`1gOol006Moo`03O01oogoo04Qoo`03001oogoo04Uoo`03O01oogoo07Ioo`00IWoo
00=l07ooOol0BGoo00<007ooOol0BGoo00=l07ooOol0MWoo001VOol00g`0Oomoo`19Ool00`00Oomo
o`1:Ool00g`0Oomoo`1eOol006Eoo`03O01oogoo03Uoo`D000Eoo`<000Aoo`03001oogoo04Yoo`03
O01oogoo07Eoo`00IGoo00=l07ooOol0>goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol0
Bgoo00=l07ooOol0M7oo001TOol00g`0Oomoo`0lOol00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`1;Ool00g`0Oomoo`1dOol006Aoo`03O01oogoo03aoo`03001oogoo009oo`H000Aoo`<004ao
o`03O01oogoo07=oo`00Hgoo00=l07ooOol0?Goo00<007ooOol00goo00@007ooOol000Eoo`03001o
ogoo04aoo`03O01oogoo07=oo`00Hgoo00=l07ooOol0?Goo00<007ooOol00goo00@007ooOol000Eo
o`03001oogoo04eoo`03O01oogoo079oo`00HWoo00=l07ooOol0?7oo0`001Woo00<007oo00001Goo
00<007ooOol0CGoo00=l07ooOol0LWoo001QOol00g`0Oomoo`0oOol00`00Oomoo`05Ool20005Ool0
0`00Oomoo`1>Ool00g`0Oomoo`1aOol0065oo`03O01oogoo04ioo`03001oogoo04ioo`03O01oogoo
075oo`00H7oo00=l07ooOol0Cgoo00<007ooOol0Cgoo00=l07ooOol0L7oo001POol00g`0Oomoo`1?
Ool00`00Oomoo`1?Ool00g`0Oomoo`1`Ool005moo`03O01oogoo051oo`80055oo`03O01oogoo06mo
o`00Ggoo00=l07ooOol0D7oo00<007ooOol0D7oo00=l07ooOol0Kgoo001NOol00g`0Oomoo`1AOol0
0`00Oomoo`1AOol00g`0Oomoo`1^Ool005eoo`03O01oogoo059oo`03001oogoo059oo`03O01oogoo
06eoo`00GGoo00=l07ooOol0DWoo00<007ooOol0DWoo00=l07ooOol0KGoo001LOol00g`0Oomoo`1C
Ool00`00Oomoo`1COol00g`0Oomoo`1/Ool005aoo`03O01oogoo05=oo`03001oogoo05Aoo`03O01o
ogoo06]oo`00Fgoo00=l07ooOol0E7oo0P00EGoo00=l07ooOol0Jgoo001JOol00g`0Oomoo`1EOol0
0`00Oomoo`1EOol00g`0Oomoo`1ZOol005Yoo`03O01oogoo05Eoo`03001oogoo05Eoo`03O01oogoo
06Yoo`00FGoo00=l07ooOol0EWoo00<007ooOol0EWoo00=l07ooOol0JGoo001IOol00g`0Oomoo`1F
Ool00`00Oomoo`1GOol00g`0Oomoo`1XOol005Qoo`03O01oogoo05Moo`03001oogoo05Moo`03O01o
ogoo06Qoo`00F7oo00=l07ooOol0Egoo00<007ooOol0F7oo00=l07ooOol0Igoo001GOol00g`0Oomo
o`1HOol00`00Oomoo`1IOol00g`0Oomoo`1VOol005Ioo`03O01oogoo05Uoo`8005Yoo`03O01oogoo
06Ioo`00EWoo00=l07ooOol0FGoo00<007ooOol0FWoo00=l07ooOol0IGoo001EOol00g`0Oomoo`1J
Ool00`00Oomoo`1JOol00g`0Oomoo`1UOol005Eoo`03O01oogoo05Yoo`03001oogoo05]oo`03O01o
ogoo06Aoo`00E7oo00=l07ooOol0Fgoo00<007ooOol0G7oo00=l07ooOol0Hgoo001COol00g`0Oomo
o`1;Ool50004Ool30005Ool00`00Oomoo`1LOol00g`0Oomoo`1SOol005=oo`03O01oogoo04eoo`03
001oogoo00=oo`05001oogooOol00004Ool00`00Oomoo`1MOol00g`0Oomoo`1ROol0059oo`03O01o
ogoo04ioo`03001oogoo00=oo`05001oogooOol00004Ool00`00Oomoo`1MOol00g`0Oomoo`1ROol0
059oo`03O01oogoo04ioo`03001oogoo00=oo`05001oogooOol00004Ool3001NOol00g`0Oomoo`1Q
Ool0055oo`03O01oogoo04moo`03001oogoo00=oo`@000Eoo`03001oogoo05ioo`03O01oogoo065o
o`00DGoo00=l07ooOol0Cgoo00<007ooOol00goo00<007ooOol01Woo00<007ooOol0Ggoo00=l07oo
Ool0H7oo001@Ool00g`0Oomoo`1>Ool30006Ool00`00Oomoo`05Ool00`00Oomoo`1OOol00g`0Oomo
o`1POol0051oo`03O01oogoo051oo`03001oogoo00Eoo`<000Aoo`03001oogoo061oo`03O01oogoo
05moo`00Cgoo00=l07ooOol0H7oo00<007ooOol0H7oo00=l07ooOol0Ggoo001?Ool00g`0Oomoo`1P
Ool00`00Oomoo`1QOol00g`0Oomoo`1NOol004ioo`03O01oogoo065oo`80069oo`03O01oogoo05io
o`00CWoo00=l07ooOol0HGoo00<007ooOol0HWoo00=l07ooOol0GGoo001=Ool00g`0Oomoo`1ROol0
0`00Oomoo`1ROol00g`0Oomoo`1MOol004eoo`03O01oogoo069oo`03001oogoo06=oo`03O01oogoo
05aoo`00C7oo00=l07ooOol0Hgoo00<007ooOol0Hgoo00=l07ooOol0G7oo001<Ool00g`0Oomoo`1S
Ool00`00Oomoo`1TOol00g`0Oomoo`1KOol004]oo`03O01oogoo06Aoo`03001oogoo06Aoo`03O01o
ogoo05]oo`00Bgoo00=l07ooOol0I7oo00<007ooOol0IGoo00=l07ooOol0FWoo001:Ool00g`0Oomo
o`1UOol2001VOol00g`0Oomoo`1JOol004Uoo`03O01oogoo06Ioo`03001oogoo06Ioo`03O01oogoo
05Uoo`00BGoo00=l07ooOol0IWoo00<007ooOol0IWoo00=l07ooOol0FGoo0018Ool00g`0Oomoo`1W
Ool00`00Oomoo`1WOol00g`0Oomoo`1HOol004Qoo`03O01oogoo06Moo`03001oogoo06Moo`03O01o
ogoo05Qoo`00Agoo00=l07ooOol0J7oo00<007ooOol0J7oo00=l07ooOol0Egoo0017Ool00g`0Oomo
o`1XOol00`00Oomoo`1XOol00g`0Oomoo`1GOol004Ioo`03O01oogoo06Uoo`8006Yoo`03O01oogoo
05Ioo`00AWoo00=l07ooOol0JGoo00<007ooOol0JGoo00=l07ooOol0EWoo0015Ool00g`0Oomoo`1Z
Ool00`00Oomoo`1ZOol00g`0Oomoo`1EOol004Eoo`03O01oogoo06Yoo`03001oogoo06Yoo`03O01o
ogoo05Eoo`00A7oo00=l07ooOol0Jgoo00<007ooOol0Jgoo00=l07ooOol0E7oo0014Ool00g`0Oomo
o`1JOol50003Ool40005Ool00`00Oomoo`1[Ool00g`0Oomoo`1DOol004=oo`03O01oogoo05eoo`03
001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo06aoo`03O01oogoo05=oo`00
@goo00=l07ooOol0GGoo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
K7oo00=l07ooOol0Dgoo0012Ool00g`0Oomoo`1NOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool3001]Ool00g`0Oomoo`1BOol0049oo`03O01oogoo05ioo`03001oogoo00=oo`@000Eo
o`03001oogoo06ioo`03O01oogoo055oo`00@Goo00=l07ooOol0Ggoo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0KWoo00=l07ooOol0DGoo002QOol30004Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`32Ool00:=oo`03001oogoo00=oo`@000Eoo`03001oogoo
0<9oo`00/Woo00<007ooOol0`Woo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol00?moogQo
o`00ogooN7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00[goo0`00aGoo
002`Ool00`00Oomoo`34Ool00;1oo`03001oogoo0<Aoo`00/7oo00<007oo0000a7oo002`Ool30034
Ool00;1oo`03001oo`000<Aoo`00/7oo00D007ooOomoo`000<9oo`00[goo1P00`Woo003oOomhOol0
0?moogQoo`00ogooN7oo0000\
\>"],
  ImageRangeCache->{{{0, 374}, {177.75, 0}} -> {-1.58083, 8.05729, 0.0110575, \
0.0828749}}]
}, Open  ]],

Cell[TextData[{
  "The result of our calculation shows that the value of the functional is \
minimal for \[Epsilon]=0 and increases for all other values of \[Epsilon]. \
Thus, we demonstrated numerically that the minimum of the functional exists. \
In a second plot, we demonstrate the influence of \[Epsilon] on the function  \
",
  Cell[BoxData[
      \(TraditionalForm\`u(x) = x\)]],
  " for different values of \[Epsilon]. This shows us that the value of ",
  Cell[BoxData[
      \(TraditionalForm\`F[u; \[Epsilon]]\)]],
  " is always greater than ",
  Cell[BoxData[
      \(TraditionalForm\`F[u; 0]\)]],
  ", no matter which value (positive or negative) is chosen for \[Epsilon]."
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[
      Evaluate[\n
        \t\t{y[x, 0], y[x, 1], y[x, \(-\(1\/2\)\)]} /. \n\t\t\t
          y \[Rule] Function[{x, \[Epsilon]}, x + \[Epsilon]\ Sin[4\ x]]], \n
      \t{x, 0, 2\ \[Pi]}, \n\tAxesLabel \[Rule] {"\<x\>", "\<y\>"}, \n\t
      PlotRange \[Rule] All, \n\t
      PlotStyle 
        \[Rule] {RGBColor[0, \ 0, \ 0.996109], \n\t\t\t
          RGBColor[1.000, 0.000, 0.000], \n\t\t\t
          RGBColor[0.000, 0.251, 0.251]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0299242 0.0888383 [
[.17539 .01742 -3 -9 ]
[.17539 .01742 3 0 ]
[.32696 .01742 -3 -9 ]
[.32696 .01742 3 0 ]
[.47854 .01742 -3 -9 ]
[.47854 .01742 3 0 ]
[.63011 .01742 -3 -9 ]
[.63011 .01742 3 0 ]
[.78169 .01742 -3 -9 ]
[.78169 .01742 3 0 ]
[.93327 .01742 -3 -9 ]
[.93327 .01742 3 0 ]
[1.025 .02992 0 -9.5 ]
[1.025 .02992 12 9.5 ]
[.01131 .11876 -6 -4.5 ]
[.01131 .11876 0 4.5 ]
[.01131 .2076 -6 -4.5 ]
[.01131 .2076 0 4.5 ]
[.01131 .29644 -6 -4.5 ]
[.01131 .29644 0 4.5 ]
[.01131 .38528 -6 -4.5 ]
[.01131 .38528 0 4.5 ]
[.01131 .47412 -6 -4.5 ]
[.01131 .47412 0 4.5 ]
[.01131 .56295 -6 -4.5 ]
[.01131 .56295 0 4.5 ]
[.02381 .64303 -6 0 ]
[.02381 .64303 6 19 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.17539 .02992 m
.17539 .03617 L
s
[(1)] .17539 .01742 0 1 Mshowa
.32696 .02992 m
.32696 .03617 L
s
[(2)] .32696 .01742 0 1 Mshowa
.47854 .02992 m
.47854 .03617 L
s
[(3)] .47854 .01742 0 1 Mshowa
.63011 .02992 m
.63011 .03617 L
s
[(4)] .63011 .01742 0 1 Mshowa
.78169 .02992 m
.78169 .03617 L
s
[(5)] .78169 .01742 0 1 Mshowa
.93327 .02992 m
.93327 .03617 L
s
[(6)] .93327 .01742 0 1 Mshowa
.125 Mabswid
.05412 .02992 m
.05412 .03367 L
s
.08444 .02992 m
.08444 .03367 L
s
.11476 .02992 m
.11476 .03367 L
s
.14507 .02992 m
.14507 .03367 L
s
.2057 .02992 m
.2057 .03367 L
s
.23602 .02992 m
.23602 .03367 L
s
.26633 .02992 m
.26633 .03367 L
s
.29665 .02992 m
.29665 .03367 L
s
.35728 .02992 m
.35728 .03367 L
s
.38759 .02992 m
.38759 .03367 L
s
.41791 .02992 m
.41791 .03367 L
s
.44822 .02992 m
.44822 .03367 L
s
.50885 .02992 m
.50885 .03367 L
s
.53917 .02992 m
.53917 .03367 L
s
.56948 .02992 m
.56948 .03367 L
s
.5998 .02992 m
.5998 .03367 L
s
.66043 .02992 m
.66043 .03367 L
s
.69074 .02992 m
.69074 .03367 L
s
.72106 .02992 m
.72106 .03367 L
s
.75137 .02992 m
.75137 .03367 L
s
.81201 .02992 m
.81201 .03367 L
s
.84232 .02992 m
.84232 .03367 L
s
.87264 .02992 m
.87264 .03367 L
s
.90295 .02992 m
.90295 .03367 L
s
.96358 .02992 m
.96358 .03367 L
s
.9939 .02992 m
.9939 .03367 L
s
.25 Mabswid
0 .02992 m
1 .02992 L
s
gsave
1.025 .02992 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.02381 .11876 m
.03006 .11876 L
s
[(1)] .01131 .11876 1 0 Mshowa
.02381 .2076 m
.03006 .2076 L
s
[(2)] .01131 .2076 1 0 Mshowa
.02381 .29644 m
.03006 .29644 L
s
[(3)] .01131 .29644 1 0 Mshowa
.02381 .38528 m
.03006 .38528 L
s
[(4)] .01131 .38528 1 0 Mshowa
.02381 .47412 m
.03006 .47412 L
s
[(5)] .01131 .47412 1 0 Mshowa
.02381 .56295 m
.03006 .56295 L
s
[(6)] .01131 .56295 1 0 Mshowa
.125 Mabswid
.02381 .04769 m
.02756 .04769 L
s
.02381 .06546 m
.02756 .06546 L
s
.02381 .08323 m
.02756 .08323 L
s
.02381 .10099 m
.02756 .10099 L
s
.02381 .13653 m
.02756 .13653 L
s
.02381 .1543 m
.02756 .1543 L
s
.02381 .17207 m
.02756 .17207 L
s
.02381 .18983 m
.02756 .18983 L
s
.02381 .22537 m
.02756 .22537 L
s
.02381 .24314 m
.02756 .24314 L
s
.02381 .2609 m
.02756 .2609 L
s
.02381 .27867 m
.02756 .27867 L
s
.02381 .31421 m
.02756 .31421 L
s
.02381 .33197 m
.02756 .33197 L
s
.02381 .34974 m
.02756 .34974 L
s
.02381 .36751 m
.02756 .36751 L
s
.02381 .40304 m
.02756 .40304 L
s
.02381 .42081 m
.02756 .42081 L
s
.02381 .43858 m
.02756 .43858 L
s
.02381 .45635 m
.02756 .45635 L
s
.02381 .49188 m
.02756 .49188 L
s
.02381 .50965 m
.02756 .50965 L
s
.02381 .52742 m
.02756 .52742 L
s
.02381 .54519 m
.02756 .54519 L
s
.02381 .01216 m
.02756 .01216 L
s
.02381 .58072 m
.02756 .58072 L
s
.02381 .59849 m
.02756 .59849 L
s
.02381 .61626 m
.02756 .61626 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 .996 r
.5 Mabswid
.02381 .02992 m
.06244 .05257 L
.10458 .07726 L
.14415 .10046 L
.18221 .12276 L
.22272 .1465 L
.26171 .16936 L
.30316 .19365 L
.34309 .21705 L
.3815 .23956 L
.42237 .26352 L
.46172 .28658 L
.49955 .30876 L
.53984 .33237 L
.57861 .35509 L
.61984 .37925 L
.65954 .40253 L
.69774 .42491 L
.73838 .44873 L
.77751 .47167 L
.81909 .49604 L
.85916 .51952 L
.89771 .54212 L
.93871 .56615 L
.97619 .58811 L
s
1 0 0 r
.02381 .02992 m
.04262 .08325 L
.0522 .10706 L
.06244 .12825 L
.0679 .13733 L
.07286 .14413 L
.07784 .1495 L
.08255 .15317 L
.08522 .15464 L
.08656 .15522 L
.08805 .15572 L
.08931 .15605 L
.09002 .15619 L
.09066 .15629 L
.09192 .15641 L
.09312 .15644 L
.09384 .15641 L
.09449 .15637 L
.09525 .15628 L
.09596 .15616 L
.09723 .15589 L
.0986 .15549 L
.10011 .15492 L
.10171 .15418 L
.10458 .1525 L
.10954 .1486 L
.11406 .14402 L
.12422 .13073 L
.14255 .10023 L
.15259 .08284 L
.16325 .06612 L
.17235 .05461 L
.17753 .04961 L
.17986 .04778 L
.1824 .0461 L
.18466 .0449 L
.18708 .04392 L
.18842 .04352 L
.18964 .04325 L
.19086 .04307 L
.19202 .04297 L
.19309 .04296 L
.19422 .04302 L
.19519 .04313 L
.19625 .04331 L
.1974 .04359 L
.19862 .04398 L
.20084 .04492 L
.20339 .04637 L
.20617 .04841 L
Mistroke
.21123 .05335 L
.21616 .05963 L
.22073 .06671 L
.24129 .11141 L
.25991 .16362 L
.28082 .22307 L
.28998 .24589 L
.30003 .26686 L
.30472 .27491 L
.30975 .28216 L
.31409 .28724 L
.31881 .29145 L
.32158 .29329 L
.3228 .29394 L
.32414 .29456 L
.32532 .29501 L
.32659 .2954 L
.32729 .29557 L
.32793 .2957 L
.32918 .29589 L
.33033 .29597 L
.33138 .29598 L
.33255 .29592 L
.33379 .29576 L
.3351 .29549 L
.33633 .29515 L
.33863 .29428 L
.34103 .29306 L
.34327 .29164 L
.34838 .28746 L
.35868 .27545 L
.37715 .24592 L
.39576 .21408 L
.40558 .19992 L
.41097 .1936 L
.41602 .18882 L
.41875 .18676 L
.42126 .18521 L
.42404 .18389 L
.4255 .18336 L
.42704 .18294 L
.42826 .18271 L
.42956 .18256 L
.43079 .1825 L
.43191 .18253 L
.43322 .18266 L
.43397 .18279 L
.43465 .18293 L
.43591 .18326 L
.43724 .18372 L
Mistroke
.43962 .18481 L
.44218 .18638 L
.44681 .19025 L
.45232 .19654 L
.45735 .20385 L
.46721 .22216 L
.47635 .24325 L
.49708 .30047 L
.51589 .35451 L
.52579 .38002 L
.53623 .40283 L
.54155 .41241 L
.54739 .42112 L
.5527 .42731 L
.55766 .43154 L
.56028 .43317 L
.56156 .43381 L
.56275 .43431 L
.56381 .43469 L
.56498 .43502 L
.56615 .43527 L
.5674 .43545 L
.56806 .4355 L
.56875 .43553 L
.56999 .43551 L
.57068 .43546 L
.57132 .43539 L
.57203 .43528 L
.57278 .43513 L
.57414 .43478 L
.57543 .43435 L
.57783 .4333 L
.58023 .43194 L
.58247 .4304 L
.58757 .42594 L
.59786 .41349 L
.61632 .38358 L
.63491 .35198 L
.64472 .33815 L
.6501 .33207 L
.65516 .32754 L
.65794 .32559 L
.66094 .32395 L
.66226 .32338 L
.66366 .32289 L
.66485 .32256 L
.66616 .32229 L
.66685 .32219 L
.6675 .32212 L
.66871 .32205 L
Mistroke
.67002 .32208 L
.67076 .32214 L
.67144 .32223 L
.67257 .32243 L
.67382 .32275 L
.67513 .32319 L
.67635 .32369 L
.67895 .32506 L
.68141 .32675 L
.68604 .33094 L
.69102 .33689 L
.69646 .34504 L
.70677 .36485 L
.71612 .38702 L
.73709 .44563 L
.75795 .50465 L
.7671 .52712 L
.77715 .54764 L
.78182 .55542 L
.78684 .5624 L
.79157 .56761 L
.79588 .57118 L
.79841 .57274 L
.80075 .57382 L
.80197 .57426 L
.80332 .57463 L
.804 .57477 L
.80473 .5749 L
.80605 .57504 L
.80722 .57508 L
.8085 .57503 L
.80914 .57497 L
.80983 .57487 L
.81108 .57463 L
.81232 .5743 L
.81349 .57391 L
.81569 .57297 L
.81808 .57165 L
.82031 .57013 L
.8254 .56575 L
.83569 .55341 L
.85414 .52361 L
.87271 .49199 L
.88251 .47808 L
.88789 .47193 L
.89295 .46732 L
.89572 .46534 L
.89871 .46365 L
.90004 .46306 L
.90143 .46254 L
Mistroke
.90263 .46219 L
.90393 .46189 L
.90462 .46178 L
.90526 .4617 L
.90648 .46161 L
.90778 .46161 L
.90852 .46166 L
.9092 .46173 L
.91034 .46191 L
.91159 .46221 L
.91289 .46261 L
.91412 .46309 L
.91658 .46434 L
.91917 .46605 L
.92379 .47013 L
.92877 .47598 L
.93422 .48403 L
.94451 .50363 L
.95386 .52564 L
.97482 .58409 L
.97619 .58811 L
Mfstroke
0 .251 .251 r
.02381 .02992 m
.03279 .02476 L
.04262 .0198 L
.04758 .01779 L
.0503 .01687 L
.05288 .01613 L
.05528 .01558 L
.05655 .01534 L
.05789 .01512 L
.05902 .01498 L
.06026 .01485 L
.06139 .01477 L
.06244 .01473 L
.0631 .01472 L
.06379 .01472 L
.06504 .01475 L
.06581 .01479 L
.06653 .01484 L
.06788 .01498 L
.06917 .01516 L
.07036 .01537 L
.07305 .01599 L
.07529 .01668 L
.07776 .01761 L
.08274 .02005 L
.08819 .02361 L
.09404 .02843 L
.10458 .03965 L
.12582 .07041 L
.14594 .10512 L
.16416 .13586 L
.17453 .15122 L
.18427 .16341 L
.19379 .17283 L
.19914 .17694 L
.20404 .17994 L
.20893 .18218 L
.2117 .18313 L
.21428 .18381 L
.21568 .18409 L
.21701 .18431 L
.2182 .18446 L
.21949 .18458 L
.22016 .18462 L
.22089 .18466 L
.22166 .18468 L
.22238 .18468 L
.22367 .18465 L
.22439 .18462 L
.22505 .18458 L
Mistroke
.22635 .18446 L
.22756 .18431 L
.22983 .18394 L
.23228 .1834 L
.23492 .18268 L
.24408 .17916 L
.25488 .17354 L
.26481 .16777 L
.27392 .16266 L
.28368 .15809 L
.28655 .15702 L
.28928 .15615 L
.29193 .15544 L
.29438 .15493 L
.2967 .15457 L
.29787 .15444 L
.29916 .15434 L
.30045 .15428 L
.30117 .15426 L
.30184 .15426 L
.30306 .15429 L
.30435 .15436 L
.30559 .15448 L
.30694 .15465 L
.30937 .1551 L
.31174 .1557 L
.31392 .15641 L
.31889 .15855 L
.32413 .16164 L
.33289 .16867 L
.34251 .179 L
.362 .20683 L
.38291 .24268 L
.40269 .2761 L
.41313 .29145 L
.42423 .30501 L
.43406 .31415 L
.43965 .31806 L
.44491 .32084 L
.44724 .32181 L
.44971 .32265 L
.45181 .32322 L
.45411 .3237 L
.45542 .3239 L
.4566 .32404 L
.45726 .3241 L
.45797 .32415 L
.45926 .32421 L
.46047 .32423 L
.46175 .3242 L
Mistroke
.46284 .32414 L
.46405 .32405 L
.46534 .3239 L
.46654 .32373 L
.46925 .32321 L
.47164 .32262 L
.47419 .32186 L
.48347 .3181 L
.50436 .30648 L
.51465 .30086 L
.52006 .29834 L
.52578 .29619 L
.5282 .29546 L
.53079 .29481 L
.53228 .29451 L
.53364 .29428 L
.53502 .29409 L
.53629 .29396 L
.53745 .29387 L
.53867 .29382 L
.5399 .29381 L
.5406 .29382 L
.54126 .29384 L
.54244 .29391 L
.54352 .29401 L
.54471 .29415 L
.54596 .29435 L
.54853 .2949 L
.55096 .2956 L
.55551 .29738 L
.56041 .30002 L
.56571 .3037 L
.57527 .3125 L
.58409 .32289 L
.62351 .38662 L
.64332 .41957 L
.66142 .44357 L
.6662 .4485 L
.6714 .4531 L
.67638 .45674 L
.68088 .45937 L
.68613 .46165 L
.68901 .46254 L
.69033 .46287 L
.69172 .46316 L
.69293 .46336 L
.69424 .46354 L
.69544 .46366 L
.69656 .46373 L
.69788 .46377 L
Mistroke
.69908 .46377 L
.69974 .46375 L
.70046 .46372 L
.70178 .46363 L
.703 .4635 L
.70412 .46335 L
.70665 .46291 L
.70898 .46237 L
.71121 .46174 L
.7216 .45763 L
.74263 .44592 L
.75221 .44067 L
.75747 .43819 L
.76243 .43622 L
.76706 .4348 L
.76967 .4342 L
.77091 .43396 L
.77207 .43378 L
.77313 .43364 L
.77409 .43353 L
.77517 .43344 L
.77632 .43338 L
.77742 .43336 L
.77862 .43336 L
.77976 .43341 L
.78081 .43348 L
.78199 .4336 L
.78322 .43376 L
.78544 .43417 L
.78782 .43477 L
.79043 .43562 L
.79511 .43766 L
.79947 .44017 L
.80942 .44809 L
.82006 .45975 L
.8414 .49119 L
.86155 .52608 L
.87986 .55671 L
.89026 .57182 L
.9 .58365 L
.90958 .59272 L
.91496 .5966 L
.91987 .59936 L
.92237 .60048 L
.92503 .60147 L
.92795 .6023 L
.93066 .60285 L
.93199 .60304 L
.93269 .60312 L
.93343 .60319 L
Mistroke
.93408 .60324 L
.93479 .60328 L
.93604 .60332 L
.93726 .60331 L
.93856 .60327 L
.93979 .60318 L
.94091 .60307 L
.94294 .60279 L
.94517 .60236 L
.9497 .60117 L
.95389 .5997 L
.95782 .59805 L
.97619 .58811 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{300, 143},
  ImageMargins->{{20, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005g0000/Q000`40O003h00OIgoo1@0077oo1@00
7goo0`008Goo0`007Woo10007goo0`00H7oo001YOol00`00Oomoo`0LOol01@00Oomoogoo00007Woo
00D007ooOomoo`00025oo`03001oogoo01aoo`03001oogoo009oo`03001oogoo01]oo`05001oogoo
Ool0001OOol006Uoo`03001oogoo01eoo`03001oogoo02=oo`03001oogoo01moo`03001oogoo025o
o`03001oogoo01]oo`05001oogooOol0001OOol006Uoo`03001oogoo01ioo`03001oogoo029oo`03
001oogoo01]oo`H0029oo`03001oogoo01]oo`05001oogooOol0001OOol006Uoo`03001oogoo01mo
o`03001oogoo01moo`8001moo`04001oogoo000OOol4000NOol4001POol006Uoo`03001oogoo021o
o`03001oogoo021oo`03001oogoo01aoo`04001oogoo000OOol00`00Oomoo`0OOol00`00Oomoo`1Q
Ool006Moo`<001ioo`05001oogooOol0000NOol01@00Oomoogoo00007goo00<007oo00007goo00<0
07ooOol087oo00<007ooOol0H7oo0016Ool00`00Oomoo`0POol00`00Oomoo`0MOol3000POol3000Q
Ool2000OOol5000OOol3001OOol004Ioo`03001oogoo0?moobmoo`00AWoo00<007ooOol0ogoo;goo
0016Ool20006Ool30>OMOol20002Ool20013Ool004Ioo`03001oogoo009oo`<0i`=oo`80imaoo`04
001oogoo0014Ool004Ioo`03001oogoo0080i`Qoo`<0imYoo`8004Eoo`00AWoo00<0003W0>L03Goo
00<0igooOol0egoo0P00AGoo0011Ool500000`3W0000000=00000`3W0000003=0009Ool01000Oomo
o`00A7oo0016Ool00g`001l07`04Ool00`00Oomoo`04Ool01000Oomoo`3W0goo00<007ooOol017oo
00<007ooOol017oo00<007ooOol00goo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol00goo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo
00<007ooOol00goo00<007ooOol017oo00<007ooOol017oo00<007ooOol027oo0P000Woo0P00@goo
0016Ool00`00O01oo`0201l=Ool00`3WOomoo`3oOolMOol004Ioo`03001l07oo009oo`807`aoo`03
0>Moogoo00moo`Al0?moo`Uoo`00AWoo00<007`0Ool017oo0P0O2Woo00<0igooOol03Goo0W`017oo
0W`0ogoo1goo0016Ool00`00Ooml0006Ool00`0OOomoo`08Ool00`3WOomoo`0;Ool00g`0Oomoo`06
Ool00g`0Oomoo`3oOol4Ool004Ioo`03001oog`000Moo`807`Uoo`030>Moogoo00Uoo`03O01oogoo
00Qoo`03O01oogoo0?moo`=oo`00AWoo00<007ooO0002Goo00<07gooOol01goo00<0igooOol027oo
00=l07ooOol027oo00=l07ooOol0ogoo0goo0016Ool200000gooO01oo`08Ool201l7Ool00`3WOomo
o`07Ool00g`0Oomoo`0:Ool00g`0Oomoo`3oOol2Ool004Ioo`04001oogooO00;Ool00`0OOomoo`05
Ool00`3WOomoo`05Ool00g`0Oomoo`0<Ool00g`0Oomoo`3oOol1Ool004Ioo`04001oogooO00<Ool2
01l6Ool00`3WOomoo`04Ool00g`0Oomoo`0<Ool00g`0Oomoo`3oOol1Ool004Ioo`05001oogooOoml
000=Ool00`0OOomoo`03Ool00`3WOomoo`03Ool00g`0Oomoo`0>Ool00g`0Oomoo`3oOol004Ioo`80
009oo`03O01oogoo00aoo`807`Aoo`050>MoogooOoml000AOol00g`0Oomoo`3oOol004Ioo`05001o
ogooOoml000@Ool201l3Ool0103WOomoog`04Woo00=l07ooOol0oWoo0016Ool00`00Oomoo`02Ool0
0g`0Oomoo`0?Ool201l017oo0>Moog`04goo00=l07ooOol0oWoo0016Ool00`00Oomoo`02Ool00g`0
Oomoo`0AOol201l00`3WO01oo`0COol00g`0Oomoo`3mOol004Ioo`8000Aoo`03O01oogoo019oo`03
0>Moogoo01=oo`03O01oogoo0?eoo`00?Goo1@0017oo00<007ooOol00goo00=l07ooOol04Goo00Al
07oo0>L07aAoo`03O01oogoo0?aoo`00?goo00<007ooOol017oo00<007ooOol017oo00=l07ooOol0
47oo00Al07ooOol0i`807a9oo`03O01oogoo0?aoo`00?goo00<007ooOol017oo00<007ooOol017oo
00=l07ooOol03goo00El07ooOomoo`3W009oo`807a1oo`03O01oogoo0?aoo`00?goo00<007ooOol0
17oo0P001Woo00=l07ooOol03Woo00=l07ooOol00Woo00@0igooOomoo`807`moo`03O01oogoo0?]o
o`00?goo00<007ooOol017oo00<007ooOol01Goo00=l07ooOol03Goo00=l07ooOol00goo00<0igoo
Ool00goo00<07gooOol037oo00=l07ooOol0ngoo000oOol00`00Oomoo`04Ool00`00Oomoo`06Ool0
0g`0Oomoo`0<Ool00g`0Oomoo`04Ool00`3WOomoo`03Ool201l<Ool00g`0Oomoo`3kOol003eoo`<0
00Ioo`03001oogoo00Moo`03O01oogoo00Yoo`03O01oogoo00Eoo`030>Moogoo00Eoo`807`]oo`03
O01oogoo0?Yoo`00?goo00<007ooOol017oo0P0027oo00=l07ooOol02Goo00=l07ooOol01goo00<0
igooOol01Woo0P0O2Goo00=l07ooOol0nWoo0016Ool00`00Oomoo`08Ool00g`0Oomoo`08Ool00g`0
Oomoo`08Ool00`3WOomoo`07Ool201l7Ool00g`0Oomoo`3jOol004Ioo`03001oogoo00Qoo`03O01o
ogoo00Moo`03O01oogoo00Uoo`030>Moogoo00Uoo`0301moogoo00Eoo`03O01oogoo0?Uoo`00AWoo
00<007ooOol02Goo00=l07ooOol017oo0W`03Goo00<0igooOol02Goo0P0O1Goo00=l07ooOol0nGoo
0016Ool2000;Ool2O002Ool2O00?Ool00`3WOomoo`0;Ool00`0OOomoo`02Ool00g`0Oomoo`05Ool5
0>O_Ool004Ioo`03001oogoo00aoo`=l015oo`80i`aoo`807`=oo`04O01oogooOol40>L4Ool20>O]
Ool004Ioo`03001oogoo029oo`030>Moogoo00]oo`0501moogooO01oo`020>L:Ool00`3WOomoo`3Z
Ool004Ioo`03001oogoo02=oo`030>Moogoo00]oo`807`03O000igoo00aoo`030>Moogoo0>Uoo`00
AWoo0P009Goo00<0igooOol037oo00<0ig`0Ool03Goo00<0igooOol0j7oo0016Ool00`00Oomoo`0U
Ool00`3WOomoo`09Ool20>L00gooO0007`0>Ool20>OXOol004Ioo`03001oogoo02Ioo`030>Moogoo
00Eoo`<0i`=oo`04O01oo`0O01l>Ool00`3WOomoo`3UOol004Ioo`03001oogoo02Moo`L0i`Moo`03
O01oogoo00807`eoo`030>Moogoo00ioo`El0=5oo`00AWoo0P00=Woo00=l07ooOol00Woo0P0O2goo
00<0igooOol037oo0W`017oo0W`0d7oo000lOol50005Ool00`00Oomoo`0fOol00g`0Oomoo`03Ool2
01l:Ool00`3WOomoo`0:Ool00g`0Oomoo`06Ool00g`0Oomoo`3=Ool003aoo`05001oogooOol00005
Ool00`00Oomoo`0fOol00g`0Oomoo`05Ool201l9Ool00`3WOomoo`09Ool00g`0Oomoo`07Ool00g`0
Oomoo`3<Ool003eoo`03001oogoo00Ioo`03001oogoo03Ioo`03O01oogoo00Moo`0301moogoo00Io
o`030>Moogoo00Qoo`03O01oogoo00Uoo`03O01oogoo0<]oo`00?Woo00<007ooOol01Goo0P00>7oo
00=l07ooOol01goo0P0O1goo00<0igooOol01Woo00=l07ooOol02Woo00=l07ooOol0bgoo000oOol0
0`00Oomoo`04Ool00`00Oomoo`0gOol00g`0Oomoo`09Ool00`0OOomoo`05Ool00`3WOomoo`05Ool0
0g`0Oomoo`0;Ool00g`0Oomoo`3:Ool0041oo`03001oogoo00=oo`03001oogoo03Moo`03O01oogoo
00Yoo`807`Eoo`030>Moogoo00Aoo`03O01oogoo00aoo`03O01oogoo0<Yoo`00?7oo00D007ooOomo
o`0000Eoo`03001oogoo03Qoo`03O01oogoo00]oo`0301moogoo00=oo`030>Moogoo009oo`03O01o
ogoo00ioo`03O01oogoo0<Uoo`00?Goo0`001Woo0P00>Goo00=l07ooOol037oo0P0O17oo00D0igoo
Oomoog`0011oo`03O01oogoo0<Uoo`00AWoo00<007ooOol0>7oo00=l07ooOol03Woo0P0O0Woo00@0
igooOoml015oo`03O01oogoo0<Uoo`00AWoo00<007ooOol0>Goo00=l07ooOol03goo0P0O00Aoo`3W
Ooml019oo`03O01oogoo0<Qoo`00AWoo00<007ooOol0>Goo00=l07ooOol04Goo00<07`3WO0004goo
00=l07ooOol0b7oo0016Ool00`00Oomoo`0jOol00g`0Oomoo`0BOol00`3WOomoo`0BOol00g`0Oomo
o`37Ool004Ioo`8003]oo`03O01oogoo015oo`04O01oo`3W01lBOol00g`0Oomoo`37Ool004Ioo`03
001oogoo03Yoo`03O01oogoo011oo`05O01oogoo0>Moo`0201l@Ool00g`0Oomoo`37Ool004Ioo`03
001oogoo03]oo`03O01oogoo00moo`05O01oogooOol0i`02Ool201l?Ool00g`0Oomoo`36Ool004Io
o`03001oogoo03]oo`03O01oogoo00ioo`03O01oogoo009oo`030>Moogoo009oo`807`eoo`03O01o
ogoo0<Ioo`00AWoo0P00?Goo00=l07ooOol037oo00=l07ooOol017oo00<0igooOol00goo00<07goo
Ool02goo00=l07ooOol0aGoo0016Ool00`00Oomoo`0lOol00g`0Oomoo`0;Ool00g`0Oomoo`05Ool0
0`3WOomoo`04Ool201l;Ool00g`0Oomoo`35Ool004Ioo`03001oogoo03eoo`03O01oogoo00Yoo`03
O01oogoo00Ioo`030>Moogoo00Eoo`807`Uoo`03O01oogoo0<Eoo`00AWoo00<007ooOol0?Goo00=l
07ooOol02Goo00=l07ooOol01goo00<0igooOol01goo0P0O27oo00=l07ooOol0a7oo0016Ool2000o
Ool00g`0Oomoo`07Ool00g`0Oomoo`09Ool00`3WOomoo`08Ool201l6Ool00g`0Oomoo`34Ool003eo
o`<000Ioo`03001oogoo03moo`03O01oogoo00Ioo`03O01oogoo00Yoo`030>Moogoo00Uoo`0301mo
ogoo00=oo`03O01oogoo0<Aoo`00?7oo00D007ooOomoo`0000Eoo`03001oogoo03moo`03O01oogoo
00Eoo`03O01oogoo00]oo`030>Moogoo00Yoo`807`Aoo`03O01oogoo0<=oo`00@7oo00<007ooOol0
0goo00<007ooOol0@7oo0g`000Aoog`0O01l00moo`030>Moogoo00]oo`807`9oo`03O01oogoo00Eo
o`H0ikQoo`00@7oo00<007ooOol00goo0P00A7oo0W`04Woo00<0igooOol037oo0P0O00=oog`0Ool0
0goo0P3W1Woo0P3W]Woo000nOol20006Ool00`00Oomoo`1GOol00`3WOomoo`0>Ool0100OO01oogoo
0P3W2Woo0P3W]7oo0010Ool00`00Oomoo`03Ool00`00Oomoo`1HOol00`3WOomoo`0>Ool00g`001l0
i`0>Ool00`3WOomoo`2aOol003aoo`05001oogooOol00005Ool00`00Oomoo`1IOol20>L>Ool20>L2
01l>Ool00`3WOomoo`2`Ool003eoo`<000Ioo`8005aoo`030>Moogoo00Uoo`80i`05Ooml07ooOol0
7`0>Ool00`3WOomoo`2_Ool004Ioo`03001oogoo05aoo`<0i`Eoo`<0i`=oo`04O01oogooOol201l<
Ool00`3WOomoo`2_Ool004Ioo`03001oogoo05ioo`H0i`Moo`03O01oogoo009oo`0301moogoo00Yo
o`030>Moogoo00ioo`El09]oo`00AWoo00<007ooOol0Jgoo00=l07ooOol00goo0P0O2goo00<0igoo
Ool037oo00=l07ooOol00goo00=l07ooOol0V7oo0016Ool2001/Ool00g`0Oomoo`05Ool00`0OOomo
o`08Ool00`3WOomoo`0;Ool00g`0Oomoo`05Ool00g`0Oomoo`2GOol004Ioo`03001oogoo06aoo`03
O01oogoo00Eoo`807`Uoo`030>Moogoo00Uoo`03O01oogoo00Moo`03O01oogoo09Ioo`00AWoo00<0
07ooOol0K7oo00=l07ooOol01goo0P0O27oo00<0igooOol01goo00=l07ooOol02Goo00=l07ooOol0
UGoo0016Ool00`00Oomoo`1/Ool00g`0Oomoo`09Ool201l6Ool00`3WOomoo`06Ool00g`0Oomoo`0:
Ool00g`0Oomoo`2EOol004Ioo`8006ioo`03O01oogoo00Yoo`807`Eoo`030>Moogoo00Aoo`03O01o
ogoo00aoo`03O01oogoo09Aoo`00AWoo00<007ooOol0KGoo00=l07ooOol037oo00<07gooOol00goo
00<0igooOol00goo00=l07ooOol03Goo00=l07ooOol0Tgoo0016Ool00`00Oomoo`1]Ool00g`0Oomo
o`0=Ool201l3Ool00`3WOomoo`02Ool00g`0Oomoo`0>Ool00g`0Oomoo`2COol004Ioo`03001oogoo
06ioo`03O01oogoo00ioo`0501moogooOol0i`03Ool00g`0Oomoo`0?Ool00g`0Oomoo`2BOol004Io
o`8006moo`03O01oogoo00moo`807`05Ool0igooOoml000BOol00g`0Oomoo`2BOol003moo`<000Ao
o`03001oogoo06ioo`03O01oogoo015oo`0501moo`3WOoml000COol00g`0Oomoo`2AOol0041oo`03
001oogoo00=oo`03001oogoo06moo`03O01oogoo015oo`807`030>Moogoo019oo`03O01oogoo095o
o`00@7oo00<007ooOol00goo00<007ooOol0Kgoo00=l07ooOol04goo00<0igooOol04goo00=l07oo
Ool0T7oo000lOol60004Ool2001aOol00g`0Oomoo`0AOol017`0Ool0i`0O4goo00=l07ooOol0T7oo
000mOol01000Oomoo`001Goo00<007ooOol0L7oo00=l07ooOol047oo00El07ooOomoo`3W00807a5o
o`03O01oogoo091oo`00?Goo00@007ooOol000Eoo`03001oogoo075oo`03O01oogoo00moo`05O01o
ogooOol0i`02Ool201l@Ool00g`0Oomoo`2?Ool003ioo`03001oo`0000Eoo`03001oogoo075oo`03
O01oogoo00ioo`03O01oogoo00=oo`040>MoogooOol201l>Ool00g`0Oomoo`2?Ool003moo`8000Eo
o`8007=oo`03O01oogoo00aoo`03O01oogoo00Aoo`030>Moogoo00=oo`0301moogoo00]oo`03O01o
ogoo08moo`00AWoo00<007ooOol0Lgoo00=l07ooOol02goo00=l07ooOol01Goo00<0igooOol00goo
0P0O37oo00=l07ooOol0SWoo0016Ool00`00Oomoo`1cOol00g`0Oomoo`0:Ool00g`0Oomoo`06Ool0
0`3WOomoo`05Ool201l:Ool00g`0Oomoo`2>Ool004Ioo`03001oogoo07Aoo`03O01oogoo00Qoo`03
O01oogoo00Qoo`030>Moogoo00Ioo`807`Uoo`03O01oogoo08eoo`00AWoo0P00MGoo00=l07ooOol0
27oo00=l07ooOol027oo00<0igooOol027oo0P0O1goo00=l07ooOol0SGoo0016Ool00`00Oomoo`1e
Ool00g`0Oomoo`05Ool2O00<Ool00`3WOomoo`09Ool00`0OOomoo`04Ool00g`0Oomoo`2=Ool004Io
o`03001oogoo07Ioo`9l00Aoo`03O01oogoo00eoo`030>Moogoo00Uoo`807`Eoo`03O01oogoo08ao
o`00AWoo00<007ooOol0Mgoo1W`03goo00<0igooOol02goo0P0O0goo00=l07ooOol017oo1`3WPGoo
0016Ool2002>Ool00`3WOomoo`0<Ool201l00gooO01oo`03Ool20>L7Ool20>MoOol004Ioo`03001o
ogoo08ioo`030>Moogoo00eoo`807`04O01oo`3W0>L;Ool00`3WOomoo`1lOol004Ioo`03001oogoo
08moo`80i`moo`80i`ioo`030>Moogoo07]oo`00AWoo00<007ooOol0TGoo00<0igooOol02Woo0P3W
00=l000O01l03Woo00<0igooOol0NWoo0016Ool2002COol00`3WOomoo`06Ool30>L3Ool00g`0Ool0
7`0>Ool00`3WOomoo`1iOol003eoo`@000Eoo`03001oogoo09=oo`80i`Eoo`030>Moogoo00Aoo`03
O01oogoo00807`eoo`030>Moogoo00moo`Al06Eoo`00?7oo00<007ooOol00Woo00<007ooOol00Woo
00<007ooOol0UGoo1@3W1goo00=l07ooOol00Woo00<07gooOol02goo00<0igooOol03Goo0W`00Woo
0W`0I7oo0011Ool00`00Oomoo`02Ool00`00Oomoo`2ROol00g`0Oomoo`02Ool201l;Ool00`3WOomo
o`0<Ool00g`0Oomoo`04Ool00g`0Oomoo`1QOol0045oo`03001oogoo009oo`800:=oo`03O01oogoo
00Aoo`0301moogoo00Uoo`030>Moogoo00Yoo`03O01oogoo00Ioo`03O01oogoo061oo`00?Goo1000
1Goo00<007ooOol0XWoo00=l07ooOol01Goo0P0O2Woo00<0igooOol027oo00=l07ooOol01goo00=l
07ooOol0H7oo000mOol00`00Oomoo`06Ool00`00Oomoo`2ROol00g`0Oomoo`07Ool201l9Ool00`3W
Oomoo`06Ool00g`0Oomoo`09Ool2O01POol003eoo`03001oogoo00Ioo`03001oogoo0:=oo`03O01o
ogoo00Qoo`807`Moo`030>Moogoo00Ioo`03O01oogoo00Yoo`03O01oogoo05ioo`00?Goo1@0017oo
0P00Y7oo00=l07ooOol02Woo0P0O1Woo00<0igooOol017oo00=l07ooOol037oo00=l07ooOol0GGoo
0016Ool00`00Oomoo`2SOol00g`0Oomoo`0<Ool00`0OOomoo`04Ool00`3WOomoo`02Ool00g`0Oomo
o`0=Ool00g`0Oomoo`1MOol004Ioo`03001oogoo0:Aoo`03O01oogoo00aoo`807`Aoo`030>Moogoo
009oo`03O01oogoo00ioo`03O01oogoo05aoo`00AWoo00<007ooOol0Y7oo00=l07ooOol03Woo0P0O
0goo00@0igooOoml015oo`03O01oogoo05aoo`00AWoo0P00YWoo00=l07ooOol03goo00H07gooOol0
igooO00BOol00g`0Oomoo`1LOol004Ioo`03001oogoo0:Eoo`03O01oogoo011oo`807`03Ool0igoo
01=oo`03O01oogoo05]oo`00AWoo00<007ooOol0YWoo00=l07ooOol04Goo00<07`3WOol04goo00=l
07ooOol0Fgoo0016Ool00`00Oomoo`2VOol00g`0Oomoo`0AOol00g`0Ool0i`0DOol00g`0Oomoo`1J
Ool004Ioo`800:Qoo`03O01oogoo00moo`04O01oogoo0>L201lBOol00g`0Oomoo`1JOol004Ioo`03
001oogoo0:Moo`03O01oogoo00moo`07O01oogooOol0igoo01l04Goo00=l07ooOol0FWoo0016Ool0
0`00Oomoo`2XOol00g`0Oomoo`0=Ool00g`0Oomoo`02Ool00`3WOomoo`0201l@Ool00g`0Oomoo`1I
Ool004Ioo`03001oogoo0:Qoo`03O01oogoo00eoo`03O01oogoo00=oo`040>MoogooOol201l>Ool0
0g`0Oomoo`1IOol004Ioo`800:Yoo`03O01oogoo00]oo`03O01oogoo00Aoo`030>Moogoo00=oo`03
01moogoo00aoo`03O01oogoo05Qoo`00?Woo0`001Goo00<007ooOol0ZGoo00=l07ooOol02goo00=l
07ooOol01Goo00<0igooOol00goo0P0O37oo00=l07ooOol0F7oo000mOol01@00Oomoogoo000017oo
00<007ooOol0ZWoo00=l07ooOol02Goo00=l07ooOol01Woo00<0igooOol01Goo0P0O2Woo00=l07oo
Ool0F7oo000mOol01@00Oomoogoo000017oo00<007ooOol0ZWoo00=l07ooOol027oo00=l07ooOol0
27oo00<0igooOol01Woo0P0O2Goo00=l07ooOol0Egoo000mOol01@00Oomoogoo000017oo0P00[7oo
00=l07ooOol01goo00=l07ooOol02Goo00<0igooOol01goo0P0O1goo00=l07ooOol0Egoo000mOol4
0005Ool00`00Oomoo`2/Ool00g`0Oomoo`05Ool00g`0Oomoo`0;Ool00`3WOomoo`08Ool201l5Ool0
0g`0Oomoo`1GOol003eoo`03001oogoo00Ioo`03001oogoo0:aoo`9l00Aoo`9l00moo`030>Moogoo
00Uoo`807`Aoo`03O01oogoo05Ioo`00?Woo00<007ooOol01Goo00<007ooOol0[Woo1G`04Goo00<0
igooOol02Woo00D07gooOomoog`005Qoo`00?goo0`0017oo00<007ooOol0a7oo00<0igooOol02goo
0P0O0Woo00=l07ooOol0EGoo0016Ool20036Ool00`3WOomoo`0<Ool201l00g`0Oomoo`1EOol004Io
o`03001oogoo0<Ioo`030>Moogoo00aoo`80ieMoo`00AWoo00<007ooOol0agoo00<0igooOol02Goo
0P3WFGoo0016Ool00`00Oomoo`38Ool00`3WOomoo`07Ool00`3WOomoo`1IOol004Ioo`800<Yoo`<0
i`=oo`<0ieaoo`00AWoo00<007ooOol0c7oo103WGWoo0016Ool00`00Oomoo`3oOol_Ool004Ioo`03
001oogoo0?moobmoo`00AWoo0P00ogoo<7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol0
0?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00@goo
0`00ogoo<Woo0015Ool00`00Oomoo`3oOol`Ool004Eoo`03001oogoo0?mooc1oo`00A7oo00<007oo
0000ogoo<Goo0014Ool00`00Ool0003oOolaOol004=oo`05001oogooOol0003oOol`Ool004=oo`05
001oogooOol0003oOol`Ool0049oo`<00004Ool00000003oOol_Ool00?moogQoo`00ogooN7oo003o
OomhOol00?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol00?moogQo
o`00\
\>"],
  ImageRangeCache->{{{0, 374}, {177.75, 0}} -> {-2.03704, -0.695776, \
0.0361419, 0.0616654}}]
}, Open  ]],

Cell[TextData[{
  "From this figure, we can conclude that the line ",
  Cell[BoxData[
      \(TraditionalForm\`u(x) = x\)]],
  " is one realization of the shortest connection between two points in the \
Euclidean plane. \[EmptySquare]"
}], "Text",
  CellTags->"shortest connection between two points"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["3.6.2 Euler\[CloseCurlyQuote]s Equation"], "Subsection",
  Evaluatable->False,
  CellTags->"Euler's Equation"],

Cell[TextData[{
  "In this section, we derive the analytical representation of the Euler \
derivative. The construction of this sort of derivative is based on condition \
",
  ButtonBox["(3.27).",
    ButtonData:>"eq-5",
    ButtonStyle->"Hyperlink"],
  " If we carry out the differentiation with respect to \[Epsilon], equation  \
",
  ButtonBox["(3.26)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  " will provide"
}], "Text",
  Evaluatable->False,
  CellTags->"Euler derivative"],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]F\/\[PartialD]\[Epsilon]\  = \ 
      \[PartialD]\/\[PartialD]\[Epsilon]\ 
        \(\[Integral]\_x\_1\%x\_2\( f(x, u, u\_x, \[Ellipsis])\) 
            \(\[DifferentialD]x . \)\)\)], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Since the limits of the integral are fixed, the differentiation affects \
only the density of the functional ",
  StyleBox["F",
    FontSlant->"Italic"],
  ". Hence,"
}], "Text",
  Evaluatable->False,
  CellTags->"functional"],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]F\/\[PartialD]\[Epsilon]\  = \ 
      \[Integral]\_x\_1\%x\_2\((
            \(\[PartialD]f\/\[PartialD]u\) 
                \[PartialD]u\/\[PartialD]\[Epsilon]\  + \ 
              \(\[PartialD]f\/\[PartialD]u\_x\) 
                \[PartialD]u\_x\/\[PartialD]\[Epsilon]\  + \ 
              \(\[PartialD]f\/\[PartialD]u\_\(x, x\)\) 
                \[PartialD]u\_\(x, x\)\/\[PartialD]\[Epsilon] + 
              \[CenterEllipsis])\) \(\[DifferentialD]x . \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-12"],

Cell[TextData[{
  "If we now use the representation of ",
  Cell[BoxData[
      \(TraditionalForm\`u = u(x; \[Epsilon])\)]],
  " as given in (3.25) to introduce the \[Epsilon] dependence for the \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and the derivatives ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  ", we get"
}], "Text",
  Evaluatable->False,
  CellTags->"representation"],

Cell[BoxData[
    \(TraditionalForm\`\[PartialD]u\/\[PartialD]e = \ w(x), \ \ \ \ \ \ \ 
    \[PartialD]u\_x\/\[PartialD]\[Epsilon] = \ w\_x, \ \ \ 
    \[PartialD]u\_\(x, x\)\/\[PartialD]\[Epsilon]\  = \ w\_\(x, x, x\), \ 
    \[Ellipsis]\)], "NumberedEquation",
  Evaluatable->False],

Cell["Using these relations in equation (3.34), we find", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]F\/\[PartialD]\[Epsilon]\  = \ 
      \[Integral]\_x\_1\%x\_2\((
            \(\[PartialD]f\/\[PartialD]u\) \(w(x)\)\  + \ 
              \(\[PartialD]f\/\[PartialD]u\_x\) w\_x\  + \ 
              \(\[PartialD]f\/\[PartialD]u\_\(x, x\)\) w\_\(x, x\) + 
              \[CenterEllipsis])\) \(\[DifferentialD]x . \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-14"],

Cell[TextData[{
  "The result so far is that the integrand contains derivatives of the \
density ",
  StyleBox["f",
    FontSlant->"Italic"],
  " and the test function ",
  StyleBox["w",
    FontSlant->"Italic"],
  ". Since we do not know anything about the derivatives of ",
  StyleBox["w, ",
    FontSlant->"Italic"],
  "we need to reduce (3.36) in such a way that it only contains the test \
function ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  ". The reduction can be obtained by an integration of parts with respect to \
the test function. Additional use of the conditions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(w(x\_1\),
              "TraditionalForm"], ")"}], "="}], TraditionalForm]]],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"w", 
              FormBox[\((x\_2\),
                "TraditionalForm"]}], ")"}], "=", "0"}], TraditionalForm]]],
  " simplifies expression ",
  ButtonBox["(3.36)",
    ButtonData:>"eq-14",
    ButtonStyle->"Hyperlink"],
  " to"
}], "Text",
  Evaluatable->False,
  CellTags->{"functional density", "test function"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[
          \(\[PartialD]F\/\[PartialD]\[Epsilon]\  = \ 
            \[Integral]\_x\_1\%x\_2\(w(x)\) 
                \((\[PartialD]f\/\[PartialD]u - \ 
                    \(d\/\(d\ x\)\) \((\[PartialD]f\/\[PartialD]u\_x)\)\  + \ 
                    \(\(d\^2\/\(d\ x\^2\)\) 
                        \((\[PartialD]f\/\[PartialD]u\_\(x, x\))\) 
                      \[MinusPlus] \[CenterEllipsis]\))\) 
                \[DifferentialD]x\),
          ScriptLevel->0], TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-15"],

Cell[TextData[{
  "The integral in equation ",
  ButtonBox["(3.37)",
    ButtonData:>"eq-15",
    ButtonStyle->"Hyperlink"],
  " seems to be independent of \[Epsilon]. However, the function ",
  Cell[BoxData[
      \(TraditionalForm\`u = u(x; \[Epsilon])\)]],
  " and all derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " are still functions of \[Epsilon]. We know from the representation of ",
  Cell[BoxData[
      \(TraditionalForm\`u(x; \[Epsilon])\)]],
  " that this dependency disappears if we set ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ". Before we start this calculation, we generalize ",
  ButtonBox["(3.37)",
    ButtonData:>"eq-15",
    ButtonStyle->"Hyperlink"],
  " to arbitrary orders in the derivatives:"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[PartialD]F\/\[PartialD]\[Epsilon]\  = \ 
      \[Integral]\_x\_1\%x\_2 w(x) 
        \((\[Sum]\+\(n = 0\)\%\[Infinity]\(\((\(-1\))\)\^n\) 
            \(d\^n\/\(d\ x\^n\)\) \((\[PartialD]f\/\[PartialD]u\_\((n)\))\))
          \)\ \[DifferentialD]x, \)\)], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm
      \`u\_\((n)\)\  = \ \[PartialD]\^n u\/\[PartialD]x\^n\)]],
  " denotes the ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Our aim was to find the extreme of ",
  Cell[BoxData[
      \(TraditionalForm\`\(F . \)\)]],
  " A necessary condition for the existence of an extreme is the vanishing of \
the derivative ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[PartialD]F\/\[PartialD]\[Epsilon]\) 
        \[VerticalSeparator]\_\(\[Epsilon] = 0\)\( = \ 0\)\)]],
  ". In our calculations, we assumed that ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " is an arbitrary function. Thus, the derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " can only vanish if the integrand vanishes and so we end up with the \
result"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[Sum]\+\(n = 0\)\%\[Infinity]\(\((\(-1\))\)\^n\) 
        \(d\^n\/\(d\ x\^n\)\) \((\[PartialD]f\/\[PartialD]u\_\((n)\))\)\  = \ 
      0, \)\)], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and all the derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " are now independent of \[Epsilon]. This result is known as Euler\
\[CloseCurlyQuote]s equation and it is a necessary condition for the \
functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " to allow an extreme. The Euler equation is reduced to the well-known \
Euler-Lagrange equation if we restrict the order of the derivatives to 2. \
Since the Euler equation is needed in the calculation of symmetries, we \
define a special symbol for this operation and call it the Euler operator."
}], "Text",
  Evaluatable->False,
  CellTags->{"Euler equation", "Euler-Lagrange equation", "Euler operator"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.3 Euler Operator", "Subsection",
  Evaluatable->False,
  CellTags->"Euler operator"],

Cell["\<\
The Euler operator is also known as a variational derivative in the \
field of dynamical formulations or statistical mechanics. In this section, we \
define this operator as a special type of derivative.\
\>", "Text",
  CellTags->{
  "Euler operator", "variational derivative", "dynamical formulation", 
    "statistical mechanics", "special type of derivative"}],

Cell["Definition: Euler operator", "Definition",
  CellTags->"Definition: Euler Operator"],

Cell[TextData[{
  StyleBox["Let ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(f = \(f(x, u, u\_x\)\),
              "TraditionalForm"], ",", "\[Ellipsis]"}], ")"}], 
        TraditionalForm]],
    FontWeight->"Plain"],
  StyleBox[" be the density of a functional ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`F[u]\)],
    FontWeight->"Plain"],
  StyleBox[". Then we call",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  Background->None,
  CellTags->"functional"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              FractionBox[
                StyleBox[
                  RowBox[{"\[Delta]", 
                    StyleBox["F",
                      FontSlant->"Italic"]}]], 
                StyleBox[
                  RowBox[{"\[Delta]", 
                    StyleBox["u",
                      FontSlant->"Italic"]}]]],
              ScriptLevel->0], " ", ":="}], " "}], TraditionalForm]],
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{\(\[Sum]\+\(n = 0\)\%\[Infinity]\), \(\((\(-1\))\)\^n\), 
            FractionBox[\(d\^n\), 
              SuperscriptBox[
                StyleBox[
                  RowBox[{
                    StyleBox["d",
                      FontWeight->"Roman",
                      FontSlant->"Italic"], 
                    StyleBox["x",
                      FontSlant->"Italic"]}]], "n"]], 
            \((\[PartialD]f\/\[PartialD]u\_\((n)\))\)}],
          ScriptLevel->0], TraditionalForm]],
    FontWeight->"Plain"]
}], "Text",
  TextAlignment->Center,
  FontWeight->"Bold",
  Background->None],

Cell[TextData[StyleBox["the functional derivative of F and",
  FontWeight->"Plain"]], "Text",
  FontWeight->"Bold",
  Background->None,
  CellTags->"functional derivative"],

Cell[TextData[{
  StyleBox["\[GothicCapitalE] :=",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox[\(\[Sum]\+\(n = 0\)\%\[Infinity]\),
              ScriptLevel->0], \(\((\(-1\))\)\^n\), \(D\_n\), 
            StyleBox[\(\[PartialD]\/\[PartialD]u\_\((n)\)\),
              ScriptLevel->0]}]}], TraditionalForm]],
    FontWeight->"Plain"]
}], "Text",
  TextAlignment->Center,
  FontWeight->"Bold",
  Background->None],

Cell[TextData[{
  StyleBox["an Euler operator. ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{\(D\_n\), "=", 
          FractionBox[\(d\^n\), 
            SuperscriptBox[
              StyleBox["dx",
                FontSlant->"Italic"], "n"]]}], TraditionalForm]],
    FontWeight->"Plain"],
  StyleBox[" denotes the ",
    FontWeight->"Plain"],
  StyleBox["n",
    FontWeight->"Roman",
    FontSlant->"Italic"],
  StyleBox["th",
    FontWeight->"Plain"],
  StyleBox["-",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["order total derivative.\[ThickSpace]\[EmptyCircle]",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  Background->None],

Cell[TextData[{
  "The actual information of this definition is that the functional \
derivative ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox[
            RowBox[{"\[Delta]", 
              StyleBox["F",
                FontSlant->"Italic"]}]], 
          StyleBox[
            RowBox[{"\[Delta]", 
              StyleBox["u",
                FontSlant->"Italic"]}]]], TraditionalForm]]],
  " can be replaced by ordinary and partial derivatives if we know the \
density of the functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ". Consequently, we can introduce a general derivative, the Euler operator, \
which is based on known operations. The essential content of the definition \
above is that knowing the density ",
  StyleBox["f",
    FontSlant->"Italic"],
  " of a functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " is sufficient to calculate the corresponding functional derivative. The \
functional derivative follows just by differentiation of the density ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". An additional merit is the knowledge of the Euler equation for this \
functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ". The definition from above is a result of the calculus of variations. \
Thus, the Euler derivative can be calculated by an algorithmic procedure."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "partial derivative", "ordinary derivative", "functional density", 
    "functional derivative", "Euler equation", "algorithmic procedure"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.6.4 Algorithm Used in the Calculus of Variations", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Algorithm used in the Calculus of Variations"],

Cell[TextData[{
  "Our next goal is to define a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function allowing the calculation of the Euler derivative. Before we \
present the function, we briefly repeat the main steps of the calculus of \
variations. These steps are intimately related to the definition of the Euler \
derivative and are thus the basis of the calculation. The four main steps of \
the algorithm are as follows:"
}], "Text",
  CellMargins->{{73.5, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"algorithm"],

Cell[TextData[{
  "Replacement of the dependent function ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " by its variation ",
  Cell[BoxData[
      \(TraditionalForm\`u = u + \ \[Epsilon]\ w\)]],
  "."
}], "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True],

Cell[TextData[
"Differentiation of the functional density with respect to the parameter \
\[Epsilon] and replacement of \[Epsilon] by zero after the differentiation."],
   "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"functional density"],

Cell[TextData[{
  "Use the boundary conditions for the test function to eliminate the \
derivatives in ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  "."
}], "ListItem",
  CellDingbat->"3.",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"boundary condition", "test function"}],

Cell[TextData[{
  "The coefficient of the test function ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " delivers the Euler equation. "
}], "ListItem",
  CellDingbat->"4.",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Euler equation"],

Cell[TextData[{
  "These four steps define the calculation of the Euler derivative \
algorithmically. The function defined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is based on these four steps. When looking at the ",
  ButtonBox["definition",
    ButtonData:>"Definition: Euler Operaror",
    ButtonStyle->"Hyperlink"],
  " of the Euler derivative \[GothicCapitalE], we realize that we need at \
least three pieces of information to carry out the calculation. First, we \
should know the density of the functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ", second the dependent variable, and third the name of the independent \
variable. From our discussions of the algorithm, we expect that the highest \
order of differentiation should be determined by the function itself. Thus, \
we define the function ",
  StyleBox["EulerD[] ", "MmaText"],
  "with three necessary arguments. A fourth optional argument allows \
influencing the representation of the result of the function. The following \
lines contain the code for ",
  StyleBox["EulerD[]:", "MmaText"]
}], "Text",
  Evaluatable->False,
  CellTags->{"Euler derivative", "EulerD[]"}],

Cell[BoxData[
    \(\( (*\ \(--\(-\ Euler\)\)\ derivative\ \(for\ --\) - *) \n (*\ 
      \(--\(-\ one\)\)\ dependent\ and\ one\ independet\ 
          \(variable\ --\) - *) \nClear[EulerD]; \n
    \(Options[EulerD] = {eXpand \[Rule] False}; \)\)\)], "Input",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"EulerD[]"],

Cell[BoxData[
    RowBox[{
    \(EulerD[density_, depend_, independ_, \n\toptions___]\), ":=", "\n", 
      "\t", 
      RowBox[{"Block", "[", 
        RowBox[{
        \({f0, rule, fh, \[Epsilon], w, y, expand}\), ",", "\n", "\t\t", 
          \( (*\(--\(-\ check\)\)\ \(options\ --\) - *) \), "\n", "\t\t", 
          RowBox[{
          \({expand} = 
              \({eXpand} /. {options}\) /. \n\t\t\t\tOptions[EulerD]\), ";", 
            "\n", "\t\t", 
            \( (*\(--\(-\ rule\)\)\ for\ the\ variation\ of\ \(u--\) - *) \), 
            "\n", "\t\t", \(f0 = Function[x, y[x] + \[Epsilon]\ w[x]]\), ";", 
            "\n", "\t\t", 
            \( (*\(--\(-\ rule\)\)\ for\ the\ replacement\ of\ \n\t\t\t\t
                \(derivatives\ of\ \(w\ --\) - \)\ *) \), "\n", "\t\t", 
            RowBox[{"rule", "=", 
              RowBox[{
                RowBox[{"b_.", " ", 
                  RowBox[{
                    SuperscriptBox["w", 
                      TagBox[\((n_)\),
                        Derivative],
                      MultilineFunction->None], "[", "independ", "]"}]}], 
                "\[RuleDelayed]", "\n", "\t\t\t\t", 
                \(\((\(-1\))\)\^n\ Hold[\[PartialD]\_{independ, n}b]\)}]}], 
            ";", "\n", "\t\t", 
            \( (*\(--\(-\ step\)\)\ of\ \(variation\ --\) - *) \), "\n", 
            "\t\t", \(fh = 
              \(density /. depend \[Rule] f0\) /. \n
                \t\t\t\t{x \[Rule] independ, y \[Rule] depend}\), ";", "\n", 
            "\t\t", \( (*
              \(--\(-\ differentiation\)\)\ with\ respect\ to\ 
                  \(\[Epsilon]\ --\) - *) \), "\n", "\t\t", 
            \(fh = Expand[\[PartialD]\_\[Epsilon] fh /. \[Epsilon] \[Rule] 0]
                \), ";", "\n", "\t\t", 
            \( (*\(--\(-\ transformation\)\)\ to\ \(w\ --\) - *) \), "\n", 
            "\t\t", \(fh = \(fh /. rule\) /. w[independ] \[Rule] 1\), ";", 
            "\n", "\t\t", 
            \( (*\(--\(--\ Euler\)\)\ \(equations\ --\) - \ *) \), "\n", 
            "\t\t", \(If[expand, fh = ReleaseHold[fh], fh]\)}]}], "]"}]}]], 
  "Input",
  PageWidth->Infinity,
  AspectRatioFixed->True],

Cell["\<\
Using this function, it is straightforward to calculate the \
functional derivative of any density containing one dependent and one \
independent variable. We demonstrate the application of this function by \
discussing the famous brachistochrone problem already mentioned in the \
introduction.\
\>", "Text",
  Evaluatable->False,
  CellTags->"brachistochrone problem"],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Let us discuss the classical problem of the brachystochrone solved by \
Johann Bernoulli in 1696. The physical content of this famous problem is the \
following: Consider a particle moving in a constant force field. The particle \
with mass ",
  StyleBox["m",
    FontSlant->"Italic"],
  " starts at rest from some higher point in the force field and moves to \
some lower point. The question is which path is selected by the particle to \
finish the transit in the least possible time. Let us reduce the problem to \
the point of deriving the Euler equation. The dimensionless functional \
density governing the movement of the particle can be derived from the \
integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{"t", "=", 
          FormBox[\(\[Integral]\_p\_1\%p\_2 1/v \[DifferentialD]s\),
            "TraditionalForm"]}], TraditionalForm]]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " is time, ",
  Cell[BoxData[
      \(TraditionalForm\`ds\)],
    FontSlant->"Italic"],
  " the line element, and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " the velocity. Expressing the line element and the velocity in Cartesian \
coordinates, we can express the density of the functional by"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "brachystochrone", "Bernoulli", "Euler equation", "functional density", 
    "line element", "velocity", "Cartesian coordinates"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(f(x, u, u\_x\),
            "TraditionalForm"], ")"}], " ", "=", " ", 
        RowBox[{"(", 
          RowBox[{
            FormBox[
              SuperscriptBox[
                RowBox[{
                  FractionBox[\(1 + u\_x\%2\), 
                    RowBox[{"2", 
                      StyleBox["gx",
                        FontFamily->"Times",
                        FontSize->10,
                        FontWeight->"Roman",
                        FontSlant->"Italic",
                        FontTracking->"Plain",
                        PrivateFontOptions->{
                        "FontPostScriptName"->Automatic}]}]], ")"}], 
                \(1/2\)],
              "TraditionalForm"], ","}]}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " describes the horizontal coordinate and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " the vertical one. The application of our function ",
  StyleBox["EulerD[]", "MmaText"],
  " on this functional density"
}], "Text",
  Evaluatable->False,
  CellTags->{"EulerD[]", "functional density"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = \@\(\(1 + \((\[PartialD]\_x u[x])\)\^2\)\/\(2  g\ x\)\); 
    f // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    FractionBox[
      SqrtBox[
        StyleBox[\(\(1 + u\_x\%2\)\/\(g\ x\)\),
          ScriptLevel->0]], \(\@2\)]], "Output"]
}, Open  ]],

Cell["gives us", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(EulerD[f, u, x, eXpand \[Rule] True] // PowerExpand\) // Simplify
        \) // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(u\_x + u\_x\%3 - 2\ x\ u\_\(x, x\)\)\/\(2\ \@2\ \@g\ x\^\(3/2\)\ 
        \((1 + u\_x\%2)\)\^\(3/2\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "a second-order ordinary differential equation for the variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The solution of this equation is a cycloid and can be derived by \
applying ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (cf. ",
  ButtonBox["Baumann [1996]",
    ButtonData:>{"Literat.nb", "Baum-96"},
    ButtonStyle->"Hyperlink"],
  ").\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->"cycloid"],

Cell["Example 2", "Example"],

Cell[TextData[{
  "Another example of the application of the function ",
  StyleBox["EulerD[]", "MmaText"],
  " is the derivation of the Euler-Lagrange equation for a mechanical system \
with one degree of freedom. The functional density for such a problem is \
generally given by the Lagrange function \[GothicCapitalL]"
}], "Text",
  CellTags->{
  "EulerD[]", "Euler-Lagrange equation", "mechanical system", 
    "functional density", "Lagrange function"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[GothicCapitalL]\  = \ l[t, q[t], \(q'\)[t]]; 
    \[GothicCapitalL] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(l[t, q, q\_t]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " denotes the generalized coordinate of the particle and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " the time. The Euler-Lagrange equation for this general Lagrangian then \
follows by"
}], "Text",
  CellTags->{"Euler-Lagrange equation", "Lagrangian"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(EulerD[\[GothicCapitalL], q, t, eXpand \[Rule] False]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          StyleBox[
            RowBox[{"Hold", "[", 
              RowBox[{\(\[PartialD]\_{t, 1}\), 
                RowBox[{
                  SuperscriptBox["l", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", 
                  RowBox[{"t", ",", \(q[t]\), ",", 
                    RowBox[{
                      SuperscriptBox["q", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}]}], "]"}]}], 
              "]"}],
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontTracking->"Plain",
            FontVariations->{"Underline"->False,
            "Outline"->False,
            "Shadow"->False,
            "StrikeThrough"->False,
            "Masked"->False,
            "CompatibilityType"->0,
            "RotationAngle"->0}]}], 
        StyleBox["+",
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontVariations->{"Underline"->False,
          "Outline"->False,
          "Shadow"->False,
          "StrikeThrough"->False,
          "Masked"->False,
          "CompatibilityType"->0,
          "RotationAngle"->0}], 
        StyleBox[
          RowBox[{
            SuperscriptBox["l", 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"t", ",", \(q[t]\), ",", 
              RowBox[{
                SuperscriptBox["q", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "]"}],
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontVariations->{"Underline"->False,
          "Outline"->False,
          "Shadow"->False,
          "StrikeThrough"->False,
          "Masked"->False,
          "CompatibilityType"->0,
          "RotationAngle"->0}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["representing the left-hand side of the expression", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \(\(\[PartialD]\/\[PartialD]q\) \[GothicCapitalL]\), " ", "-", " ", 
          RowBox[{
            FractionBox["d", 
              StyleBox["dt",
                FontSlant->"Italic"]], 
            \((\(\[PartialD]\/\[PartialD]q\_t\) \[GothicCapitalL])\)}]}], 
        " ", "=", " ", "0."}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "The disadvantage of this representation is the appearance of the function \
",
  StyleBox["Hold[] ", "MmaText"],
  "in the equation. However, if we are only interested in the explicit form \
of the equations, we can set the option ",
  StyleBox["eXpand\[Rule]True", "MmaText",
    FontSlant->"Italic"],
  ". Then, the result reads"
}], "Text",
  CellTags->"Hold[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EulerD[\[GothicCapitalL], q, t, eXpand \[Rule] True] == 0 // 
      LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(l\_q - q\_t\ l\_\(q, q\_t\) - l\_\(t, q\_t\) - 
        l\_\(q\_t, q\_t\)\ q\_\(t, t\) == 0\)], "Output"]
}, Open  ]],

Cell[TextData[
"This equation is the general representation of the Euler-Lagrange equation.\
\[ThickSpace]\[EmptySquare]"], "Text",
  CellTags->"Euler-Lagrange equation"],

Cell[TextData[{
  "The Euler operator defined above was the result of the variation of a \
functional. We demonstrated the calculation for a single dependent variable ",
  
  Cell[BoxData[
      \(TraditionalForm\`u = u(x)\)]],
  " which was a function of one independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The generic case in applications is more complex. We rarely find systems \
with only one dependent variable. Thus, we need a generalization of the \
formulation considering more than one dependent variable in the functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ". In the following exposition, we assume that a set of ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " dependent variables ",
  Cell[BoxData[
      \(TraditionalForm\`u\^\[Alpha]\)]],
  " exists. The functional ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " for such a case is represented by "
}], "Text",
  Evaluatable->False,
  CellTags->"Euler operator"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[
                  RowBox[{
                    FormBox[\(F[u\^1\),
                      "TraditionalForm"], ",", \(u\^2\)}],
                  "TraditionalForm"], ",", \(u\^3\)}],
              "TraditionalForm"], ",", "\[Ellipsis]"}], "]"}], " ", "=", 
        " ", 
        RowBox[{
          
          FormBox[\(\[Integral]\_x\_1\%x\_2\( f(x, u\^1, \[Ellipsis], 
                  u\_x\%1, \[Ellipsis])\) \[DifferentialD]x\),
            "TraditionalForm"], "."}]}], TraditionalForm]], "NumberedEquation",\

  Evaluatable->False],

Cell[TextData[{
  "The variation of the dependent variables is now performed by introducing a \
set of test functions ",
  Cell[BoxData[
      \(TraditionalForm\`w\^\[Alpha]\)]],
  ". Using this set of auxiliary functions, we can represent the variation \
by"
}], "Text",
  Evaluatable->False,
  CellTags->"auxiliary function"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(u\^\[Alpha]\),
                "TraditionalForm"], \((x; \[Epsilon])\)}], " ", "=", " ", 
            RowBox[{
              RowBox[{
                FormBox[\(u\^\[Alpha]\),
                  "TraditionalForm"], \((x; 0)\)}], " ", "+", " ", 
              RowBox[{"\[Epsilon]", " ", 
                RowBox[{
                  FormBox[\(w\^\[Alpha]\),
                    "TraditionalForm"], "(", "x", ")"}]}]}]}], " ", ",", 
          "   ", \(\[Alpha] = 1\), ",", "2", ",", "3", ",", "\[Ellipsis]", 
          " ", ",", 
          StyleBox["q",
            FontSlant->"Italic"]}], TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False],

Cell["\<\
The derivation of the Euler operator proceeds in exactly the same \
manner as presented above. We skip the detailed calculations and present only \
the result:\
\>", "Text",
  Evaluatable->False,
  CellTags->"Euler operator"],

Cell[BoxData[
    \(TextForm
    \`\(\[PartialD]F\/\[PartialD]\[Epsilon]\  = \ 
        \[Integral]\_x\_1\%x\_2\[Sum]\+\(\[Alpha] = 1\)\%q\[InvisibleComma] {
          \(\(\[Sum]\[InvisibleComma] \)\+\(n = 1\)\%\[Infinity]\) 
            \((\(-1\))\)\^n\ D\_\((n)\)\ 
            \[PartialD]f\/\[PartialD]u\_\((n)\)\%\[Alpha]} 
        \(\(w\^\[Alpha]\)(x)\) \(\[DifferentialD]x . \)\)\)], 
  "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Since the individual variations ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            FormBox[\(w\^\[Alpha]\),
              "TraditionalForm"], "(", "x", ")"}],
          "InlineFormula"], TraditionalForm]]],
  " are all independent of each other, the vanishing of equation (3.23) when \
evaluated at \[Epsilon]=0 requires the separate vanishing of each expression \
in curly brackets. Thus, we again can define an Euler operator for each of \
the ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " dependent variables ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(u\^\[Alpha]\),
          "InlineFormula"], TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "3.6.5 Euler Operator for ",
  StyleBox["q",
    FontSlant->"Italic"],
  " Dependent Variables"
}], "Subsection",
  Evaluatable->False,
  CellTags->"Euler operator for q-dependent variables"],

Cell[TextData[{
  "In this section, we extend the definition of the Euler derivative to a set \
of ",
  StyleBox["q",
    FontSlant->"Italic"],
  " dependent variables. Let ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\(f = \(f(x, u\^1\)\),
                  "TraditionalForm"], ",", \(u\^2\)}],
              "TraditionalForm"], ",", 
            RowBox[{"\[Ellipsis]", " ", 
              FormBox[
                RowBox[{",", 
                  FormBox[\(u\_x\%1\),
                    "TraditionalForm"], " ", ",", \(u\_x\%2\)}],
                "TraditionalForm"]}], " ", ",", "\[Ellipsis]"}], ")"}], 
        TraditionalForm]]],
  " be the density of the functional ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(F[u\^1\),
            "TraditionalForm"], ",", \(u\^2\)}], TraditionalForm]]],
  ",\[Ellipsis]]. Then, we define the Euler operator ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalE]\_\[Alpha]\)]],
  " as"
}], "Text",
  Evaluatable->False,
  CellTags->{"functional", "Euler operator"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[GothicCapitalE]\_\[Alpha]\  := \ 
        \[Sum]\+\(n = 0\)\%\[Infinity]\[InvisibleComma] 
      \((\(-1\))\)\^n\ D\_\((n)\)\ 
        \[PartialD]\/\[PartialD]u\_\((n)\)\%\[Alpha]\ , \ \ \ \[Alpha] = 1, 
      2, \ \[Ellipsis], q, \)\)], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "which will give us the \[Alpha]th Euler equation when applied to the \
density ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ","
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(\[GothicCapitalE]\_\[Alpha]\),
            "TraditionalForm"], " ", "f"}], " ", "=", " ", "0."}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "The only difference between this definition and the definition for the \
single variable is the number of equations contained in (3.46). The \
occurrence of the ",
  StyleBox["q",
    FontSlant->"Italic"],
  " equations in the theoretical formulas must now be incorporated in our ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " definition for the Euler derivative ",
  StyleBox["EulerD[]", "MmaText"],
  ". The theoretical definition (3.45) only alters our ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function in a way that, for several dependent variables, a set of Euler \
equations results. Thus, we change our ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function in such a way that all dependent variables are taken into \
account in the application of the ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalE]\_\[Alpha]\)]],
  " operator. We realize this by including a loop scanning the input list of \
the dependent variables. The code of this generalized Euler operator is"
}], "Text",
  Evaluatable->False,
  CellTags->{"EulerD[]", "loop", "generalized Euler operator"}],

Cell[BoxData[
    RowBox[{
    \(EulerD[density_, depend_List, \n\tindepend_, options___]\), ":=", "\n", 
      "\t", 
      RowBox[{"Block", "[", 
        RowBox[{
        \({f0, fh, e, w, y, expand, \n\t\t\teuler = {}, wtable}\), ",", "\n", 
          "\t\t", 
          RowBox[{
          \({expand} = 
              \({eXpand} /. {options}\) /. \n\t\t\t\tOptions[EulerD]\), ";", 
            "\n", "\t\t", 
            \(wtable = Table[w[i], \n\t\t\t\t{i, 1, Length[depend]}]\), ";", 
            "\n", "\t\t", \(f0 = Function[x, y[x] + e\ w[x]]\), ";", "\n", 
            "\t\t", 
            RowBox[{\(rules[i_]\), ":=", "\n", "\t\t\t", 
              RowBox[{
                RowBox[{"b_.", " ", 
                  RowBox[{
                    
                    SuperscriptBox[
                      \(wtable\[LeftDoubleBracket]i\[RightDoubleBracket]\), 
                      TagBox[\((n_)\),
                        Derivative],
                      MultilineFunction->None], "[", "independ", "]"}]}], 
                "\[RuleDelayed]", "\n", "\t\t\t\t", 
                \(\((\(-1\))\)\^n\ Hold[\[PartialD]\_{independ, n}b]\)}]}], 
            ";", "\n", "\t\t", 
            \(Do[\n\t\t\t
              fh = \(density /. 
                    depend\[LeftDoubleBracket]j\[RightDoubleBracket] \[Rule] 
                      f0\) /. \n
                  \t\t\t\t\t{x \[Rule] independ, 
                    y \[Rule] 
                      depend\[LeftDoubleBracket]j\[RightDoubleBracket], \n
                    \t\t\t\t\t\t
                    w \[Rule] 
                      wtable\[LeftDoubleBracket]j\[RightDoubleBracket]}; \n
              \t\t\tfh = Expand[\[PartialD]\_e fh /. e \[Rule] 0]; \n\t\t\t
              fh = \(fh /. rules[j]\) /. \n\t\t\t\t\t
                  \(wtable\[LeftDoubleBracket]j\[RightDoubleBracket]\)[
                      independ] \[Rule] 1; \n\t\t\tAppendTo[euler, fh], \n
              \t\t\t{j, 1, Length[depend]}]\), ";", "\n", "\t\t", 
            \(If[expand, \n\t\t\teuler = ReleaseHold[euler], \n\t\t\teuler]
              \)}]}], "]"}]}]], "Input",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"EulerD[]"],

Cell["\<\

Let us demonstrate the application of this function by two examples.\
\>", 
  "Text",
  Evaluatable->False],

Cell["Example 1", "Example"],

Cell["\<\
Assume that we know the functional density of a two-dimensional \
oscillator system. Let us further assume that the two coordinates of the \
oscillators are coupled by a product. We expect that the two equations of \
motion follow by applying the Euler derivative. The Lagrange density of the \
system reads\
\>", "Text",
  Evaluatable->False,
  CellTags->{
  "two-dimensional oscillator system", "oscillators", "Lagrange density", 
    "equations of motion", "Euler derivative"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\tl = 
      u[t]\ v[t] + \((\[PartialD]\_t u[t])\)\^2 + 
        \((\[PartialD]\_t v[t])\)\^2 - \ u[t]\^2 - v[t]\^2; 
    l // LieTraditionalForm\)\)], "Input"],

Cell[BoxData[
    \(\(-u\^2\) + u\ v - v\^2 + u\_t\%2 + v\_t\%2\)], "Output"]
}, Open  ]],

Cell["\<\
The corresponding system of second-order equations follows by\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EulerD[l, {u, v}, t, eXpand \[Rule] True] // LieTraditionalForm\)], 
  "Input"],

Cell[BoxData[
    \({\(-2\)\ u + v - 2\ u\_\(t, t\), u - 2\ v - 2\ v\_\(t, t\)}\)], "Output"]
}, Open  ]],

Cell[TextData[
"which are the left-hand sides of the Euler-Lagrange equations.\[ThickSpace]\
\[EmptySquare]"], "Text",
  Evaluatable->False],

Cell[TextData[{
  "Note that we used the same name, ",
  StyleBox["EulerD[],", "MmaText"],
  " for the operators \[GothicCapitalE] and ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalE]\_\[Alpha]\)]],
  ". This sort of definition is possible in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and provides a great flexibility in the application of a single symbol \
for different operations. ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "is able to distinguish the two different functions by the different \
arguments."
}], "Text",
  Evaluatable->False,
  CellTags->"EulerD[]"],

Cell["Example 2", "Example"],

Cell["\<\
Another example for a two-dimensional Lagrangian is given by the \
function\
\>", "Text",
  CellTags->"two-dimensional Lagrangian"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\tf = 
      u[t]\ v[t] + \((\[PartialD]\_t u[t])\)\^2 + 
        \((\[PartialD]\_t v[t])\)\^2 + 
        2\ \[PartialD]\_t u[t]\ \[PartialD]\_t v[t]; 
    f // LieTraditionalForm\)\)], "Input"],

Cell[BoxData[
    \(u\ v + u\_t\%2 + 2\ u\_t\ v\_t + v\_t\%2\)], "Output"]
}, Open  ]],

Cell["\<\
This density is a special model of a Dirac Lagrangian containing \
the derivatives with respect to time as a binomial. The corresponding \
Euler-Lagrange equations read\
\>", "Text",
  CellTags->{"Dirac Lagrangian", "binomial", "Euler-Lagrange equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(EulerD[f, {u, v}, t, eXpand \[Rule] True] // LieTraditionalForm\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({v - 2\ u\_\(t, t\) - 2\ v\_\(t, t\), 
      u - 2\ u\_\(t, t\) - 2\ v\_\(t, t\)}\)], "Output"]
}, Open  ]],

Cell[TextData[
"representing a coupled system of second-order ordinary differential \
equations.\[ThickSpace]\[EmptySquare]"], "Text",
  CellTags->"second-order ordinary differential equation"],

Cell[TextData[{
  "So far, we are able to handle point systems depending on one independent \
variable. However, equations occurring in real situations depend on more than \
one variable. Thus, we need a generalization of our Euler derivative to more \
than one independent variable. In fact, the definitions of an Euler operator \
can be extended from the ",
  StyleBox["q+1",
    FontSlant->"Italic"],
  "-dimensional case to the ",
  StyleBox["q\[ThinSpace]+\[ThinSpace]p",
    FontSlant->"Italic"],
  "-dimensional case. We define this operator in the following section."
}], "Text",
  Evaluatable->False,
  CellTags->{"point system", "Euler derivative", "Euler operator"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "3.6.6 Euler Operator for ",
  StyleBox["q ", "InlineFormula",
    FontSlant->"Italic"],
  StyleBox["+ ", "InlineFormula"],
  StyleBox["p", "InlineFormula",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "Dimensions"
}], "Subsection",
  Evaluatable->False,
  CellTags->"Euler operator for (q-p)-dimensions"],

Cell[TextData[
"Here, we will discuss the general definition of an Euler operator. This sort \
of operator, for example, is used to write down field equations such as \
Maxwell\[CloseCurlyQuote]s equations, Schr\[ODoubleDot]dinger's equation, \
Euler's equation in hydrodynamics, and many others."], "Text",
  Evaluatable->False,
  CellTags->{
  "Maxwell equation", "Schr\[ODoubleDot]dinger equation", "Euler equation", 
    "hydrodynamics"}],

Cell[TextData[{
  "Definition:",
  StyleBox[" (q,p)",
    FontVariations->{"CompatibilityType"->0}],
  "-Dimensional Euler operator"
}], "Definition",
  CellTags->"Definition: (qp)-dimensional Euler operator"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`f = f(x, u\_\((n)\))\)]],
  " be the density of the functional ",
  StyleBox["F",
    FontSlant->"Italic"],
  "[",
  StyleBox["u",
    FontSlant->"Italic"],
  "] with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\(x = \((x\^1\)\),
                  "TraditionalForm"], ",", \(x\^2\)}],
              "TraditionalForm"], ",", "\[Ellipsis]", ",", \(x\^p\)}], ")"}], 
        TraditionalForm]]],
  ", and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[
                RowBox[{
                  RowBox[{"u", 
                    FormBox[\( = \((u\^1\)\),
                      "TraditionalForm"]}], ",", \(u\^2\)}],
                "TraditionalForm"], ",", "\[Ellipsis]", ",", \(u\^q\)}],
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " the ",
  StyleBox["p",
    FontSlant->"Italic"],
  StyleBox["-",
    FontVariations->{"CompatibilityType"->0}],
  " and ",
  StyleBox["q",
    FontSlant->"Italic"],
  "-dimensional vectors of the independent and dependent variables. By ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((n)\)\)]],
  " we denote all the derivatives with respect to the independent variables. \
We call"
}], "Text",
  Evaluatable->False,
  CellTags->"functional"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[GothicCapitalE]\_\[Alpha]\), "=", " ", 
          
          FormBox[\(\[Sum]\+J\(\((\(-D\))\)\_J\) 
                \[PartialD]\/\[PartialD]u\_J\%\[Alpha]\),
            "TraditionalForm"]}], " "}], TraditionalForm]], "NumberedEquation",\

  Evaluatable->False,
  CellTags->"eq-25"],

Cell[TextData[{
  "the general Euler operator in ",
  StyleBox["q ",
    FontSlant->"Italic"],
  "dependent and ",
  StyleBox["p",
    FontSlant->"Italic"],
  " independent variables. ",
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  " is a multi-index ",
  Cell[BoxData[
      \(TraditionalForm\`J = \((j\_1, \[Ellipsis], j\_k)\)\)]],
  " with ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "\[LessEqual]", " ", 
          FormBox[\(j\_k\),
            "TraditionalForm"], "\[LessEqual]", "p"}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`k\  \[GreaterEqual] 0\)]],
  ".\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False,
  CellTags->"multi index"],

Cell[TextData[{
  "Since the functional densities ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " depend on a finite number of derivatives ",
  Cell[BoxData[
      \(TraditionalForm\`u\_J\%\[Alpha]\)]],
  ", the infinite sum in ",
  ButtonBox["(3.47)",
    ButtonData:>"eq-25",
    ButtonStyle->"Hyperlink"],
  " is terminated at this upper limit. Again, the Euler equations for a given \
functional ",
  Cell[BoxData[
      \(TraditionalForm\`F[u]\)]],
  " follow from the application of ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalE]\_\[Alpha]\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->"Euler equation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(\[GothicCapitalE]\_\[Alpha]\),
              "TraditionalForm"], " ", "F"}], " ", "=", " ", "0"}], "  ", 
        ",", "   ", \(\[Alpha]\  = \ 1\), ",", "2", ",", "\[Ellipsis]", ",", 
        " ", \(q . \)}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "From a theoretical point of view, we know the general Euler operator. Our \
next step is to make this operation available in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". We define the generalized Euler operator by taking into account the \
different independent variables. The corresponding definition of ",
  StyleBox["EulerD[]", "MmaText"],
  " for ",
  StyleBox["q\[ThinSpace]+\[ThinSpace]p",
    FontSlant->"Italic"],
  " dimensions is given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"general Euler operator", "EulerD[]"}],

Cell[BoxData[{\(Clear[EulerD]\), "\n", 
    RowBox[{\(EulerD[density_, depend_List, \n\tindepend_List, options___]\), 
      ":=", "\n", "\t", 
      RowBox[{"Block", "[", 
        RowBox[{\({f0, fh, e, w, y, x$m, expand, \n\t\t\teuler = {}, 
            wtable}\), ",", "\n", "\t\t", 
          
          RowBox[{\({expand} = \({eXpand} /. {options}\) /. \n\t\t\t\tOptions[
                  EulerD]\), ";", "\n", 
            "\t\t", \(wtable = 
              Table[w[i], \n\t\t\t\t{i, 1, Length[depend]}]\), ";", "\n", 
            "\t\t", \(f0 = Function[x$m, y + e\ w]\), ";", "\n", "\t\t", 
            RowBox[{\(ruleg[i_]\), ":=", "\n", "\t\t\t", 
              RowBox[{
                RowBox[{"b_.", " ", 
                  RowBox[{
                    
                    SuperscriptBox[\(wtable\[LeftDoubleBracket]
                        i\[RightDoubleBracket]\), 
                      TagBox[\((n___)\),
                        Derivative],
                      MultilineFunction->None], "@@", "independ"}]}], 
                "\[RuleDelayed]", "\n", 
                "\t\t\t\t", \(\((\(-1\))\)\^Plus @@ {n}\ \
\[IndentingNewLine]Hold[\[PartialD]\_\(Delete[Thread[{independ, {n}}], 0]\)b]\
\)}]}], ";", "\n", 
            "\t\t", \(Do[\n\t\t\tfh = \(density /. 
                    depend\[LeftDoubleBracket]j\[RightDoubleBracket] \[Rule] 
                      f0\) /. \n\t\t\t\t\t{x$m \[Rule] 
                      independ, \n\t\t\t\t\t\ty \[Rule] 
                      depend\[LeftDoubleBracket]j\[RightDoubleBracket] @@ 
                        independ, \n\t\t\t\t\t\tw \[Rule] 
                      wtable\[LeftDoubleBracket]j\[RightDoubleBracket] @@ 
                        independ}; \n\t\t\tfh = 
                Expand[\[PartialD]\_e fh /. e \[Rule] 0]; \n\t\t\tfh = \(fh /. 
                    ruleg[j]\) /. \n\t\t\t\t\twtable\[LeftDoubleBracket]
                        j\[RightDoubleBracket] @@ independ \[Rule] 
                    1; \n\t\t\tAppendTo[euler, fh], \n\t\t\t{j, 1, 
                Length[depend]}]\), ";", "\n", 
            "\t\t", \(If[\[InvisibleSpace]Not[expand], \n\t\t\teuler = 
                ReleaseHold[euler], \n\t\t\teuler]\)}]}], "]"}]}]}], "Input",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"EulerD[]"],

Cell[TextData[{
  "We demonstrate the application of the function ",
  StyleBox["EulerD[]", "MmaText"],
  " to the wave equation in 2+1 dimensions and to a system of coupled \
non-linear diffusion equations."
}], "Text",
  CellTags->{"wave equation", "coupled nonlinear diffusion equations"}],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Let us consider a functional in ",
  Cell[BoxData[
      \(TraditionalForm\`q = 1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`p = 3\)]],
  " variables and assume that the density is quadratic in the derivatives \
given by"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{\(F[u]\), "=", " ", 
        RowBox[{
          FormBox[\(1\/2\),
            "TraditionalForm"], 
          RowBox[{"\[Integral]", " ", 
            RowBox[{
              FormBox[
                RowBox[{
                  
                  FormBox[
                    \((\(u\_x\_1\%2\)(x\_1, x\_2, x\_3)\  - u\_x\_2\%2\  - 
                        u\_x\_3\%2)\),
                    "TraditionalForm"], \(\[DifferentialD]x\_1\), 
                  \(\[DifferentialD]x\_2\), \(\[DifferentialD]x\_3\)}],
                "TraditionalForm"], "."}]}]}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False],

Cell["\<\
Calculating the variational derivative, we immediately find that \
the Euler equations are given by the Laplace equation:\
\>", "Text",
  Evaluatable->False,
  CellTags->{"variational derivative", "Euler equation", "Laplace equation"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          \(\(-u\_\(\(x\_1\) x\_1\)\) + u\_\(x\_2, x\_2\) + \ 
            u\_\(x\_3, x\_3\)\),
          "TraditionalForm"], " ", "=", " ", "0."}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Using the generalized definition of ",
  StyleBox["EulerD[]", "MmaText"],
  ", we can reconstruct the result of our pencil calculation. First, let us \
define the density by"
}], "Text",
  Evaluatable->False,
  CellTags->{"EulerD[]", "pencil calculation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = 
      1\/2\ {\((\[PartialD]\_x1 u[x1, x2, x3])\)\^2 - 
            \((\[PartialD]\_x2 u[x1, x2, x3])\)\^2 - 
            \((\[PartialD]\_x3 u[x1, x2, x3])\)\^2}; 
    f // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({1\/2\ \((u\_x1\%2 - u\_x2\%2 - u\_x3\%2)\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The application of ",
  StyleBox["EulerD[]", "MmaText"],
  " to ",
  StyleBox["f",
    FontSlant->"Italic"],
  " gives"
}], "Text",
  CellTags->"EulerD[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(wave\  = \ EulerD[f, {u}, {x1, x2, x3}]; 
    \(Map[# == 0&, Flatten[wave]] // LieTraditionalForm\) // TableForm\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-u\_\(x1, x1\)\) + u\_\(x2, x2\) + u\_\(x3, x3\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ u, x1, x1]], 
            Subscript[ u, x2, x2], 
            Subscript[ u, x3, x3]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[
"The resulting equation is known as the wave equation in 2\[ThinSpace]+\
\[ThinSpace]1 dimensions.\[ThickSpace]\[EmptySquare]"], "Text",
  Evaluatable->False],

Cell["Example 2", "Example"],

Cell[TextData[{
  "In this example, we will consider a system in two field variables ",
  Cell[BoxData[
      \(TraditionalForm\`\((q = 2)\)\)]],
  " and two independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`\((p = 2)\)\)]],
  ". The physical background of this model is the diffusion of two components \
in a non-linear medium. The Lagrange density of this field model has the \
representation"
}], "Text",
  CellTags->{
  "diffusion", "two component nonlinear medium", "Lagrange density"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(l\  = \ 
      v[x, t] \[PartialD]\_t\ u[x, t]\  + \ 
        \[PartialD]\_x\ u[x, t] \[PartialD]\_x\ v[x, t]\  + 
        \(u[x, t]\^\(2\ \)\) v[x, t]\^2; l // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(u\^2\ v\^2 + v\ u\_t + u\_x\ v\_x\)], "Output"]
}, Open  ]],

Cell["The related equations of motion follow by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cnondiffu\  = EulerD[l, {u, v}, {x, t}]; 
    \(Map[# == 0&, cnondiffu] // LieTraditionalForm\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(2\ u\ v\^2 - v\_t - v\_\(x, x\) == 0\)},
          {\(2\ u\^2\ v + u\_t - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ 2, u, 
              Power[ v, 2]], 
            Times[ -1, 
              Subscript[ v, t]], 
            Times[ -1, 
              Subscript[ v, x, x]]], 0], 
        Equal[ 
          Plus[ 
            Times[ 2, 
              Power[ u, 2], v], 
            Subscript[ u, t], 
            Times[ -1, 
              Subscript[ u, x, x]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "representing two coupled non-linear diffusion equations for the variables \
",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ".\[ThickSpace]\[EmptySquare]"
}], "Text",
  CellTags->"coupled nonlinear diffusion equations"],

Cell["\<\
So far, we discussed differential operators like tangent vectors, \
prolongations, Fr\[EAcute]chet derivatives, and several versions of Euler \
derivatives. All these differentials are non-standard operators with special \
applications. One of these applications is symmetry analysis of differential \
equations. In the following section, we discuss the central usage of these \
differential operators. We will show that the Fr\[EAcute]chet derivative is \
the main link between differential equations and their symmetries.\
\>", 
  "Text",
  CellTags->{
  "tangent vector", "prolongation", "Frechet derivative", "Euler derivative", 
    "non-standard differential operators", 
    "symmetry analysis of differential equations", "differential operators"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.7 Prolongation of Vector Fields", "Section",
  Evaluatable->False,
  CellTags->"Prolongation of vector fields"],

Cell["\<\
In Lie's theory, a vector field takes a central role in analyzing \
symmetries of differential equations. A vector field is closely related to \
the term of the tangent on a curve. The following will show the connection \
between the tangent of a curve and the related vector field. We will also \
calculate the prolongation or extension of a vector field which is \
instrumental in symmetry analysis. The calculation of the extension of a \
vector field is one of the central terms in Lie's theory.\
\>", "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "symmetry", "symmetries of differential equations", 
    "prolongation", "extension", "Lie theory"}],

Cell[TextData[{
  "As discussed in S",
  ButtonBox["ection 3.2",
    ButtonData:>{"derivat.nb", "Tangent vector"},
    ButtonStyle->"Hyperlink"],
  ", we define a tangent vector as a measure to determine the variation of a \
function in all its independent variables. Closely related to the tangent \
vector is a vector field. Let us assume that we have a smooth curve \
\[GothicCapitalC] on a manifold \[GothicCapitalM] given in a parametric form \
by ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\  : \ I\  \[Rule] \ M\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " is a subinterval of \[DoubleStruckCapitalR]. The local representation of \
the curve is thus given by the ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " coordinates of \[GothicCapitalM] by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"\[CapitalPhi]", " ", "=", " ", 
              RowBox[{
                FormBox[\((\[CapitalPhi]\^1\),
                  "TraditionalForm"], \((t)\)}]}], ",", " ", 
            RowBox[{
              FormBox[\(\[CapitalPhi]\^2\),
                "TraditionalForm"], \((t)\)}], ",", "\[Ellipsis]", ",", " ", 
            RowBox[{
              FormBox[\(\[CapitalPhi]\^m\),
                "TraditionalForm"], \((t)\)}]}], ")"}], TraditionalForm]]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " is a parameter. The tangent vector of the curve is given by the \
derivative with respect to the parameter ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " and is calculated by ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox[
            RowBox[{
              StyleBox["d",
                FontSlant->"Italic"], "\[CapitalPhi]"}]], 
          StyleBox["dt",
            FontSlant->"Italic"]], TraditionalForm]]],
  ". An example for this notation is the three-dimensional spiral defined by \
the function"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "tangent vector", "independent variables", "curve in parametric form", 
    "three dimensional spiral", "solenoid"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi] = {2\ Cos[t], 2\ Sin[t], \@t}\)], "Input"],

Cell[BoxData[
    \({2\ Cos[t], 2\ Sin[t], \@t}\)], "Output"]
}, Open  ]],

Cell["A graphical representation of this curve is created by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(pl1 = 
      ParametricPlot3D[
        Flatten[{\[CapitalPhi], \n\t\t\t\tRGBColor[1, 0, 0]}], {t, 0, 
          4\ \[Pi]}, \n\t\tAxesLabel \[Rule] {"\<x\>", "\<y\>", "\<z\>"}]\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.03715 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0361002 1.12432 0 1.12432 [
[.08105 .23262 -11.9248 -9 ]
[.08105 .23262 .07517 0 ]
[.21208 .17795 -11.388 -9 ]
[.21208 .17795 .61198 0 ]
[.35045 .12025 -5.4256 -9 ]
[.35045 .12025 .5744 0 ]
[.49678 .05926 -5.1572 -9 ]
[.49678 .05926 .8428 0 ]
[.65178 -0.00529 -4.88879 -9 ]
[.65178 -0.00529 1.11121 0 ]
[.30679 .06538 -10.8493 -19 ]
[.30679 .06538 1.15073 0 ]
[.00939 .76964 -6.92719 0 ]
[.00939 .76964 5.07281 9 ]
[.12048 .84981 -6.71079 0 ]
[.12048 .84981 5.28921 9 ]
[.22022 .92178 -3.26247 0 ]
[.22022 .92178 2.73753 9 ]
[.31028 .98676 -3.18181 0 ]
[.31028 .98676 2.81819 9 ]
[.39198 1.04571 -3.11113 0 ]
[.39198 1.04571 2.88887 9 ]
[.2141 .99178 -6.52495 0 ]
[.2141 .99178 5.47505 19 ]
[.06459 .26301 -6 -2.64015 ]
[.06459 .26301 0 6.35985 ]
[.04551 .38252 -6 -2.74526 ]
[.04551 .38252 0 6.25474 ]
[.02475 .51258 -6 -2.86062 ]
[.02475 .51258 0 6.13938 ]
[.00208 .65465 -6 -2.98777 ]
[.00208 .65465 0 6.01223 ]
[-0.03626 .50639 -12 -5.9816 ]
[-0.03626 .50639 0 13.0184 ]
[ 0 0 0 0 ]
[ 1 1.03715 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.07918 .2475 m
.67517 0 L
s
.09092 .24262 m
.09586 .24762 L
s
[(-2)] .08105 .23262 .98747 1 Mshowa
.22147 .1884 m
.22617 .19363 L
s
[(-1)] .21208 .17795 .898 1 Mshowa
.35929 .13118 m
.3637 .13664 L
s
[(0)] .35045 .12025 .80853 1 Mshowa
.50498 .07067 m
.50909 .07638 L
s
[(1)] .49678 .05926 .71907 1 Mshowa
.65927 .0066 m
.66301 .01255 L
s
[(2)] .65178 -0.00529 .6296 1 Mshowa
.125 Mabswid
.11648 .23201 m
.11942 .23503 L
s
.14231 .22128 m
.14522 .22433 L
s
.16842 .21044 m
.17129 .21352 L
s
.1948 .19948 m
.19765 .20259 L
s
.24844 .17721 m
.25122 .18037 L
s
.27569 .16589 m
.27845 .16908 L
s
.30325 .15445 m
.30597 .15767 L
s
.33111 .14287 m
.3338 .14612 L
s
.38777 .11935 m
.39039 .12265 L
s
.41658 .10738 m
.41916 .11072 L
s
.44572 .09528 m
.44826 .09865 L
s
.47518 .08305 m
.47768 .08644 L
s
.53513 .05815 m
.53755 .0616 L
s
.56563 .04549 m
.568 .04897 L
s
.59648 .03268 m
.59881 .03619 L
s
.62769 .01972 m
.62998 .02326 L
s
gsave
.30679 .06538 -71.8493 -23 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.25 Mabswid
0 .7474 m
.40008 1.03715 L
s
.01153 .75575 m
.0126 .74881 L
s
[(-2)] .00939 .76964 .15453 -1 Mshowa
.12213 .83585 m
.12296 .82887 L
s
[(-1)] .12048 .84981 .11846 -1 Mshowa
.22145 .90778 m
.22206 .90078 L
s
[(0)] .22022 .92178 .08749 -1 Mshowa
.31113 .97273 m
.31155 .96571 L
s
[(1)] .31028 .98676 .0606 -1 Mshowa
.3925 1.03166 m
.39276 1.02464 L
s
[(2)] .39198 1.04571 .03704 -1 Mshowa
.125 Mabswid
.03465 .77249 m
.03526 .76832 L
s
.05725 .78886 m
.05783 .78468 L
s
.07935 .80487 m
.0799 .80069 L
s
.10097 .82053 m
.1015 .81635 L
s
.14284 .85085 m
.14331 .84666 L
s
.16311 .86553 m
.16356 .86134 L
s
.18296 .87991 m
.18338 .87571 L
s
.2024 .89399 m
.2028 .88979 L
s
.24011 .92129 m
.24045 .91709 L
s
.2584 .93454 m
.25872 .93033 L
s
.27632 .94752 m
.27662 .94331 L
s
.29389 .96025 m
.29417 .95604 L
s
.32803 .98497 m
.32826 .98076 L
s
.34461 .99697 m
.34482 .99276 L
s
.36087 1.00875 m
.36107 1.00454 L
s
.37683 1.02031 m
.37701 1.0161 L
s
gsave
.2141 .99178 -67.525 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.25 Mabswid
.07918 .2475 m
0 .7474 L
s
.07757 .25764 m
.08407 .25496 L
s
[(0)] .06459 .26301 1 -0.4133 Mshowa
.0586 .37742 m
.06515 .37486 L
s
[(1)] .04551 .38252 1 -0.38994 Mshowa
.03796 .50777 m
.04456 .50536 L
s
[(2)] .02475 .51258 1 -0.36431 Mshowa
.0154 .65017 m
.02206 .64793 L
s
[(3)] .00208 .65465 1 -0.33605 Mshowa
.125 Mabswid
.0739 .28081 m
.07781 .27922 L
s
.07017 .30437 m
.07408 .30279 L
s
.06638 .32831 m
.0703 .32675 L
s
.06252 .35266 m
.06645 .35111 L
s
.05461 .4026 m
.05855 .40108 L
s
.05056 .42821 m
.0545 .42671 L
s
.04643 .45427 m
.05038 .45279 L
s
.04223 .48079 m
.04618 .47932 L
s
.03361 .53523 m
.03757 .53381 L
s
.02918 .56319 m
.03315 .56179 L
s
.02467 .59166 m
.02865 .59027 L
s
.02008 .62065 m
.02407 .61928 L
s
.01064 .68024 m
.01464 .67892 L
s
.00578 .71088 m
.00979 .70959 L
s
.00084 .74211 m
.00486 .74083 L
s
gsave
-0.03626 .50639 -73 -9.9816 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.25 Mabswid
.07918 .2475 m
0 .7474 L
s
0 .7474 m
.40008 1.03715 L
s
.40008 1.03715 m
.41583 .58558 L
s
.41583 .58558 m
.07918 .2475 L
s
.67517 0 m
.93476 .41825 L
s
.93476 .41825 m
1 .89588 L
s
1 .89588 m
.70552 .52403 L
s
.70552 .52403 m
.67517 0 L
s
.07918 .2475 m
0 .7474 L
s
0 .7474 m
.70552 .52403 L
s
.70552 .52403 m
.67517 0 L
s
.67517 0 m
.07918 .2475 L
s
.41583 .58558 m
.93476 .41825 L
s
.93476 .41825 m
1 .89588 L
s
1 .89588 m
.40008 1.03715 L
s
.40008 1.03715 m
.41583 .58558 L
s
0 0 m
1 0 L
1 1.03715 L
0 1.03715 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.58238 .68156 m
.53405 .69191 L
s
.62934 .66639 m
.58238 .68156 L
s
.53405 .69191 m
.48533 .69748 L
s
.67392 .64642 m
.62934 .66639 L
s
.48533 .69748 m
.43722 .69835 L
s
.71511 .6217 m
.67392 .64642 L
s
.43722 .69835 m
.39073 .69464 L
s
.75189 .59234 m
.71511 .6217 L
s
.39073 .69464 m
.34687 .68654 L
s
.78326 .55851 m
.75189 .59234 L
s
.34687 .68654 m
.30668 .67426 L
s
.80821 .52043 m
.78326 .55851 L
s
.30668 .67426 m
.27123 .65814 L
s
.82577 .47837 m
.80821 .52043 L
s
.5345 .87749 m
.48306 .88007 L
s
.58566 .87068 m
.5345 .87749 L
s
.6355 .85965 m
.58566 .87068 L
s
.48306 .88007 m
.43233 .87845 L
s
.27123 .65814 m
.24158 .63855 L
s
.68301 .84445 m
.6355 .85965 L
s
.83509 .43253 m
.82577 .47837 L
s
.43233 .87845 m
.38335 .87272 L
s
.72714 .8252 m
.68301 .84445 L
s
.38335 .87272 m
.33717 .86302 L
s
.83539 .38287 m
.83509 .43253 L
s
.76685 .80207 m
.72714 .8252 L
s
.24158 .63855 m
.21877 .616 L
s
.33717 .86302 m
.29484 .84953 L
s
.80106 .77531 m
.76685 .80207 L
s
.82603 .32811 m
.83539 .38287 L
s
.29484 .84953 m
.25748 .8325 L
s
.21877 .616 m
.20382 .59111 L
s
.80464 .24608 m
.82603 .32811 L
s
.82871 .74529 m
.80106 .77531 L
s
.25748 .8325 m
.22619 .81229 L
s
.20382 .59111 m
.19762 .5646 L
s
.84876 .71248 m
.82871 .74529 L
s
.22619 .81229 m
.20208 .78934 L
s
.86026 .67749 m
.84876 .71248 L
s
.19762 .5646 m
.20091 .53737 L
s
.20208 .78934 m
.1862 .76419 L
s
.8624 .64104 m
.86026 .67749 L
s
.20091 .53737 m
.21419 .51041 L
s
.1862 .76419 m
.17952 .73754 L
s
.85455 .60404 m
.8624 .64104 L
s
.21419 .51041 m
.23764 .4848 L
s
.8364 .5675 m
.85455 .60404 L
s
.17952 .73754 m
.18285 .71021 L
s
.23764 .4848 m
.27102 .46172 L
s
.80799 .53254 m
.8364 .5675 L
s
.18285 .71021 m
.19673 .68313 L
s
.27102 .46172 m
.31366 .44231 L
s
.76981 .50033 m
.80799 .53254 L
s
.31366 .44231 m
.36437 .42767 L
s
.19673 .68313 m
.22137 .65734 L
s
.72286 .47203 m
.76981 .50033 L
s
.36437 .42767 m
.42147 .41871 L
s
.66859 .44871 m
.72286 .47203 L
s
.22137 .65734 m
.25655 .63396 L
s
.42147 .41871 m
.48288 .41612 L
s
.82234 .6907 m
.85177 .72316 L
s
.60895 .43125 m
.66859 .44871 L
s
.48288 .41612 m
.54622 .42029 L
s
.54622 .42029 m
.60895 .43125 L
s
.25655 .63396 m
.30157 .61411 L
s
.78254 .66085 m
.82234 .6907 L
s
.30157 .61411 m
.35515 .59883 L
s
.73337 .63474 m
.78254 .66085 L
s
.35515 .59883 m
.41552 .58903 L
s
.67636 .6134 m
.73337 .63474 L
s
.61355 .5977 m
.67636 .6134 L
s
.41552 .58903 m
.48044 .58538 L
s
.54735 .58826 m
.61355 .5977 L
s
.48044 .58538 m
.54735 .58826 L
s
0 g
.25 Mabswid
.67517 0 m
.93476 .41825 L
s
.93476 .41825 m
1 .89588 L
s
1 .89588 m
.70552 .52403 L
s
.70552 .52403 m
.67517 0 L
s
.07918 .2475 m
0 .7474 L
s
0 .7474 m
.70552 .52403 L
s
.70552 .52403 m
.67517 0 L
s
.67517 0 m
.07918 .2475 L
s
.07918 .2475 m
.67517 0 L
s
.09092 .24262 m
.09586 .24762 L
s
[(-2)] .08105 .23262 .98747 1 Mshowa
.22147 .1884 m
.22617 .19363 L
s
[(-1)] .21208 .17795 .898 1 Mshowa
.35929 .13118 m
.3637 .13664 L
s
[(0)] .35045 .12025 .80853 1 Mshowa
.50498 .07067 m
.50909 .07638 L
s
[(1)] .49678 .05926 .71907 1 Mshowa
.65927 .0066 m
.66301 .01255 L
s
[(2)] .65178 -0.00529 .6296 1 Mshowa
.125 Mabswid
.11648 .23201 m
.11942 .23503 L
s
.14231 .22128 m
.14522 .22433 L
s
.16842 .21044 m
.17129 .21352 L
s
.1948 .19948 m
.19765 .20259 L
s
.24844 .17721 m
.25122 .18037 L
s
.27569 .16589 m
.27845 .16908 L
s
.30325 .15445 m
.30597 .15767 L
s
.33111 .14287 m
.3338 .14612 L
s
.38777 .11935 m
.39039 .12265 L
s
.41658 .10738 m
.41916 .11072 L
s
.44572 .09528 m
.44826 .09865 L
s
.47518 .08305 m
.47768 .08644 L
s
.53513 .05815 m
.53755 .0616 L
s
.56563 .04549 m
.568 .04897 L
s
.59648 .03268 m
.59881 .03619 L
s
.62769 .01972 m
.62998 .02326 L
s
gsave
.30679 .06538 -71.8493 -23 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.25 Mabswid
0 .7474 m
.40008 1.03715 L
s
.01153 .75575 m
.0126 .74881 L
s
[(-2)] .00939 .76964 .15453 -1 Mshowa
.12213 .83585 m
.12296 .82887 L
s
[(-1)] .12048 .84981 .11846 -1 Mshowa
.22145 .90778 m
.22206 .90078 L
s
[(0)] .22022 .92178 .08749 -1 Mshowa
.31113 .97273 m
.31155 .96571 L
s
[(1)] .31028 .98676 .0606 -1 Mshowa
.3925 1.03166 m
.39276 1.02464 L
s
[(2)] .39198 1.04571 .03704 -1 Mshowa
.125 Mabswid
.03465 .77249 m
.03526 .76832 L
s
.05725 .78886 m
.05783 .78468 L
s
.07935 .80487 m
.0799 .80069 L
s
.10097 .82053 m
.1015 .81635 L
s
.14284 .85085 m
.14331 .84666 L
s
.16311 .86553 m
.16356 .86134 L
s
.18296 .87991 m
.18338 .87571 L
s
.2024 .89399 m
.2028 .88979 L
s
.24011 .92129 m
.24045 .91709 L
s
.2584 .93454 m
.25872 .93033 L
s
.27632 .94752 m
.27662 .94331 L
s
.29389 .96025 m
.29417 .95604 L
s
.32803 .98497 m
.32826 .98076 L
s
.34461 .99697 m
.34482 .99276 L
s
.36087 1.00875 m
.36107 1.00454 L
s
.37683 1.02031 m
.37701 1.0161 L
s
gsave
.2141 .99178 -67.525 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{333.313, 196.5},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006P0000mA000`40O003h00OmGoo1@00YWoo003e
Ool01@00Oomoogoo0000YWoo003fOol00`00Oomoo`2WOol00?Moo`03001oogoo0:Ioo`00n7oo00<0
07ooOol0YGoo003iOol00`00Oomoo`2TOol00?Eoo`05001oogooOol0002VOol00?Ioo`<00:Moo`00
ogooXGoo003oOonQOol00:Qoo`80009oo`800?9oo`00ZGoo00@007ooOol00?=oo`00ZWoo0P00DWoo
0P00X7oo002ZOol2001@Ool200000goo0000002OOol00:Uoo`04001oogoo000XOol5000OOol40002
Ool2002OOol00:Qoo`80009oo`8002Uoo`03001oogoo01eoo`8000Aoo`05001oo`00Ool0002NOol0
0=Moo`03001oogoo01]oo`8000Qoo`04001oogoo002MOol00=Moo`03001oogoo01Qoo`<00003Ool0
07oo00Moo`04001oogoo002MOol00=Moo`03001oogoo01Ioo`8000eoo`05001oogooOol0002LOol0
0=Moo`03001oogoo01=oo`<000moo`05001oogooOol0002LOol00=Eoo`<001=oo`80009oo`03001o
ogoo00ioo`05001oogooOol0002KOol00=Moo`03001oogoo00moo`8001Eoo`03001oogoo009oo`03
001oogoo09Qoo`00iWoo0`005goo00<007ooOol00Woo00<007ooOol0V7oo003TOol20003Ool00`00
Oomoo`0DOol00`00Oomoo`03Ool00`00Oomoo`2GOol00>5oo`<001aoo`03001oogoo00Aoo`03001o
ogoo09Ioo`00ggoo0P000Woo00<007ooOol06Woo00<007ooOol017oo00<007ooOol0UWoo003MOol2
000QOol00`00Oomoo`05Ool00`00Oomoo`2EOol00;Ioo`@0021oo`<002=oo`03001oogoo00Eoo`03
001oogoo09Eoo`00]Goo00<007ooOol00Woo00<007ooOol06goo0P000goo00<007ooOol087oo00<0
07ooOol01Woo00<007ooOol0U7oo002eOol00`00Oomoo`02Ool00`00Oomoo`0HOol3000XOol00`00
Oomoo`07Ool00`00Oomoo`2COol00;Eoo`03001oogoo009oo`03001oogoo01Ioo`@002Uoo`03001o
ogoo00Moo`03001oogoo09=oo`00]Goo00<007ooOol00Woo00<007ooOol057oo0P00;Goo00<007oo
Ool027oo00<007ooOol0TWoo002eOol00`00Oomoo`02Ool00`00Oomoo`0AOol3000_Ool00`00Oomo
o`09Ool00`00Oomoo`2AOol00;Eoo`03001oogoo009oo`03001oogoo00moo`80009oo`03001oogoo
02eoo`03001oogoo00Uoo`03001oogoo095oo`00]Woo10003goo0`00=7oo00<007ooOol02Woo00<0
07ooOol0T7oo0037Ool3000fOol00`00Oomoo`0:Ool00`00Oomoo`2@Ool00<Eoo`8000=oo`03001o
ogoo03Aoo`03001oogoo00Yoo`03001oogoo08moo`00`Woo0`00?7oo00<007ooOol02goo00<007oo
Ool0SWoo0030Ool20002Ool00`00Oomoo`0jOol00`00Oomoo`0;Ool00`00Oomoo`2>Ool009Uoo`D0
01moo`<0045oo`03001oogoo00aoo`03001oogoo08eoo`00Vgoo00<007ooOol07Goo0`00@goo00<0
07ooOol03Goo00<007ooOol0S7oo002KOol00`00Oomoo`0KOol20003Ool00`00Oomoo`10Ool00`00
Oomoo`0=Ool00`00Oomoo`2<Ool0091oo`H000Eoo`03001oogoo01Qoo`<004Qoo`03001oogoo00io
o`03001oogoo08]oo`00Vgoo00<007ooOol05Woo0P000Woo00<007ooOol0AWoo00<007ooOol03Woo
00<007ooOol0Rgoo002KOol00`00Oomoo`0COol3001=Ool00`00Oomoo`0?Ool00`00Oomoo`2:Ool0
09Uoo`<001=oo`@004ioo`03001oogoo011oo`03001oogoo08Uoo`00Vgoo00<007ooOol03goo0P00
DWoo00<007ooOol047oo00<007ooOol0RGoo002ZOol3001DOol00`00Oomoo`0AOol00`00Oomoo`28
Ool00:Qoo`80009oo`03001oogoo059oo`03001oogoo019oo`03001oogoo08Moo`00YGoo0`00FGoo
00<007ooOol04Woo00<007ooOol0Qgoo001lOol5000ROol200000goo001oo`1IOol00`00Oomoo`0C
Ool00`00Oomoo`26Ool007aoo`05001oogooOol0000POol2001NOol00`00Oomoo`0COol00`00Oomo
o`26Ool007eoo`03001oogoo01ioo`<0065oo`03001oogoo01=oo`03001oogoo08Eoo`00M7oo1P00
17oo00<007ooOol06goo0P000goo00<007ooOol0GWoo00<007ooOol057oo00<007ooOol0Q7oo001o
Ool00`00Oomoo`0GOol3001VOol00`00Oomoo`0DOol00`00Oomoo`24Ool0081oo`03001oogoo01Ao
o`80009oo`03001oogoo06Aoo`03001oogoo01Eoo`03001oogoo08=oo`00O7oo00D007ooOomoo`00
01Aoo`8006]oo`03001oogoo01Ioo`03001oogoo089oo`00OGoo0`004Woo0`0000=oo`00Ool0JWoo
00<007ooOol05Woo00<007ooOol0PWoo002@Ool2001`Ool00`00Oomoo`0GOol00`00Oomoo`21Ool0
08eoo`@0075oo`03001oogoo01Moo`03001oogoo085oo`00Rgoo0P00MGoo00<007ooOol067oo00<0
07ooOol0P7oo0029Ool2001gOol00`00Oomoo`0IOol00`00Oomoo`1oOol008Ioo`<0009oo`03001o
ogoo07Aoo`03001oogoo01Uoo`03001oogoo07moo`00Q7oo0P00O7oo00<007ooOol06Woo00<007oo
Ool0OWoo0022Ool20002Ool00`00Oomoo`1iOol00`00Oomoo`0FOol00g`0Oomoo`02Ool00`00Oomo
o`1mOol0089oo`8007ioo`03001oogoo01Ioo`03O01oogoo009oo`03001oogoo07eoo`00PWoo0`00
OGoo00<007ooOol05Woo00=l07ooOol00goo00<007ooOol0O7oo0022Ool01000Oomoo`00OGoo00<0
07ooOol05Woo00=l07ooOol00Woo00<007ooOol0O7oo001iOol40004Ool00`00Oomoo`02Ool00`00
Oomoo`1jOol00`00Oomoo`0FOol00g`0Oomoo`03Ool00`00Oomoo`1kOol007Qoo`03001oogoo009o
o`05001oogooOol00005Ool00`00Oomoo`1iOol00`00Oomoo`0FOol00g`0Oomoo`04Ool00`00Oomo
o`1jOol007Qoo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`1hOol00`00Oomoo`0F
Ool00g`0Oomoo`04Ool00`00Oomoo`1jOol007Qoo`03001oogoo009oo`04001oogooOol20006Ool0
0`00Oomoo`1gOol00`00Oomoo`0GOol00g`0Oomoo`04Ool00`00Oomoo`1iOol007Qoo`03001oogoo
009oo`05001oogooOol00008Ool00`00Oomoo`1fOol00`00Oomoo`0GOol00g`0Oomoo`05Ool00`00
Oomoo`1hOol007Qoo`03001oogoo009oo`05001oogooOol00009Ool00`00Oomoo`1eOol00`00Oomo
o`0GOol00g`0Oomoo`05Ool00`00Oomoo`1hOol007Qoo`03001oogoo009oo`04001oogoo000;Ool0
0`00Oomoo`1dOol00`00Oomoo`0GOol00g`0Oomoo`06Ool00`00Oomoo`1gOol007Uoo`@000=oo`03
001oogoo00Yoo`03001oogoo07=oo`03001oogoo01Qoo`03O01oogoo00Eoo`03001oogoo07Moo`00
P7oo0P0037oo00<007ooOol0LWoo00<007ooOol067oo00=l07ooOol01Woo00<007ooOol0MWoo0020
Ool00`00Oomoo`0<Ool00`00Oomoo`1aOol00`00Oomoo`0HOol00g`0Oomoo`07Ool00`00Oomoo`1e
Ool0081oo`03001oogoo00eoo`03001oogoo071oo`03001oogoo01Qoo`03O01oogoo00Moo`03001o
ogoo07Eoo`00P7oo00<007ooOol03Woo00<007ooOol0Kgoo00<007ooOol06Goo00=l07ooOol01goo
00<007ooOol0M7oo0020Ool00`00Oomoo`0?Ool00`00Oomoo`1^Ool00`00Oomoo`0IOol00g`0Oomo
o`08Ool00`00Oomoo`1cOol007moo`80019oo`03001oogoo06eoo`03001oogoo01Uoo`03O01oogoo
00Qoo`03001oogoo07=oo`00Ogoo00<007ooOol04Woo00<007ooOol0K7oo00<007ooOol06Goo00=l
07ooOol02Goo00<007ooOol0LWoo001oOol00`00Oomoo`0COol00`00Oomoo`1/Ool00`00Oomoo`0H
Ool00g`0Oomoo`09Ool00`00Oomoo`1bOol007moo`03001oogoo01Aoo`03001oogoo06]oo`03001o
ogoo01Uoo`03O01oogoo00Uoo`03001oogoo075oo`00Ogoo00<007ooOol05Goo00<007ooOol0JWoo
00<007ooOol06Goo00=l07ooOol02Woo00<007ooOol0L7oo001oOol00`00Oomoo`0FOol00`00Oomo
o`1YOol00`00Oomoo`0IOol00g`0Oomoo`0:Ool00`00Oomoo`1`Ool007ioo`03001oogoo01Qoo`03
001oogoo06Qoo`03001oogoo01Uoo`03O01oogoo00]oo`03001oogoo06moo`00OWoo00<007ooOol0
6Goo00<007ooOol0Igoo00<007ooOol06Goo00=l07ooOol037oo00<007ooOol0KWoo001nOol00`00
Oomoo`0JOol00`00Oomoo`1VOol00`00Oomoo`0IOol00g`0Oomoo`0<Ool00`00Oomoo`1^Ool007io
o`03001oogoo01]oo`03001oogoo06Eoo`03001oogoo01Yoo`03O01oogoo00aoo`03001oogoo06eo
o`00OWoo0P007Goo00<007ooOol0I7oo00<007ooOol06Woo00=l07ooOol037oo00<007ooOol0KGoo
001nOol00`00Oomoo`0MOol00`00Oomoo`1SOol00`00Oomoo`0JOol00g`0Oomoo`0=Ool00`00Oomo
o`1/Ool007Eoo`D000Aoo`03001oogoo01ioo`03001oogoo069oo`03001oogoo01Yoo`03O01oogoo
00ioo`03001oogoo06]oo`00Mgoo00<007ooOol00goo00<007ooOol087oo00<007ooOol0HGoo00<0
07ooOol06Woo00=l07ooOol03Woo00<007ooOol0Jgoo001gOol00`00Oomoo`03Ool00`00Oomoo`0Q
Ool00`00Oomoo`1POol00`00Oomoo`0JOol00g`0Oomoo`0?Ool00`00Oomoo`1ZOol007Moo`03001o
ogoo00=oo`03001oogoo029oo`03001oogoo05moo`03001oogoo01Yoo`03O01oogoo011oo`03001o
ogoo06Uoo`00Mgoo00<007ooOol00goo0P0097oo00<007ooOol0GWoo00<007ooOol06Woo00=l07oo
Ool047oo00<007ooOol0JGoo001gOol00`00Oomoo`03Ool00`00Oomoo`0TOol00`00Oomoo`1MOol0
0`00Oomoo`0JOol00g`0Oomoo`0AOol00`00Oomoo`1XOol007Eoo`<000Eoo`03001oogoo02Eoo`03
001oogoo05eoo`03001oogoo01Uoo`03O01oogoo015oo`03001oogoo06Qoo`00Mgoo00<007ooOol0
0goo00<007ooOol09Woo00<007ooOol07goo5W`09goo00<007ooOol06Goo00=l07ooOol04Goo0P00
JGoo001lOol00`00Oomoo`0XOol00`00Oomoo`0HOol6O00FOol:O00MOol00`00Oomoo`0IOol00g`0
Oomoo`0>Ool300000goo001oo`1XOol007aoo`8002Yoo`03001oogoo019oo`El02Ioo`Ml01Ioo`03
001oogoo01Uoo`03O01oogoo00]oo`<000Aoo`03001oogoo06Moo`00O7oo00<007ooOol0:Woo00<0
07ooOol03Goo17`0<Woo1G`04Goo00<007ooOol06Goo00=l07ooOol027oo0`001goo00<007ooOol0
Igoo001lOol00`00Oomoo`0[Ool00`00Oomoo`08Ool4O00kOol3O00>Ool00`00Oomoo`0IOol00g`0
Oomoo`04Ool4000;Ool00`00Oomoo`1VOol007aoo`03001oogoo02aoo`03001oogoo00Aoo`=l049o
o`=l00]oo`03001oogoo01Uoo`04O01oogooOol3000?Ool00`00Oomoo`1VOol007aoo`03001oogoo
02eoo`04001oogooOol2O018Ool3O008Ool00`00Oomoo`0HOol00g`0Ool00002000BOol00`00Oomo
o`1VOol007]oo`80031oo`03001l07`004eoo`=l00Eoo`03001oogoo01Moo`03001l000001Eoo`03
001oogoo06Ioo`00Ngoo00<007ooOol0;Woo0W`000<007ooOol0Cgoo0g`00Woo00<007ooOol057oo
0`0000=oog`0Ool05Goo00<007ooOol0IWoo001kOol00`00Oomoo`0/Ool2O003Ool00`00Oomoo`1A
Ool2O0000`00Oomoo`0AOol30004Ool00g`0Oomoo`0DOol00`00Oomoo`1VOol007]oo`03001oogoo
02Yoo`9l00Ioo`03001oogoo059oo`03001l07`000ioo`<000Moo`03O01oogoo01Aoo`03001oogoo
06Ioo`00Ngoo00<007ooOol0:Goo00=l07ooOol01goo00<007ooOol0DGoo00<007ooOol00W`02Goo
0`002Goo00=l07ooOol05Woo00<007ooOol0IGoo001kOol00`00Oomoo`0XOol00g`0Oomoo`09Ool0
0`00Oomoo`1@Ool00`00Oomoo`02Ool2O004Ool3000<Ool00g`0Oomoo`0FOol00`00Oomoo`1UOol0
07Yoo`8002Qoo`9l00eoo`03001oogoo04moo`03001oogoo00Aoo`9l008000moo`03O01oogoo01Io
o`03001oogoo06Eoo`00NWoo00<007ooOol09Woo00=l07ooOol03Woo00<007ooOol0CWoo00@007oo
Oomoo`<0009oo`03O01oogoo00ioo`03O01oogoo01Ioo`03001oogoo06Eoo`00NWoo00<007ooOol0
9Goo00=l07ooOol047oo00<007ooOol0CWoo0`001Woo0W`03Goo00=l07ooOol05goo00<007ooOol0
IGoo001jOol00`00Oomoo`0UOol00g`0Oomoo`0AOol00`00Oomoo`1:Ool4000:Ool2O00;Ool00g`0
Oomoo`0GOol00`00Oomoo`1UOol007Yoo`03001oogoo02Aoo`03O01oogoo01=oo`03001oogoo04Io
o`<000=oo`03001oogoo00Yoo`03O01oogoo00Moo`03O01oogoo01Qoo`03001oogoo06Eoo`00NWoo
0P0097oo00=l07ooOol05Goo00<007ooOol0@Woo0`001Woo00<007ooOol02goo00=l07ooOol01Woo
00=l07ooOol067oo00<007ooOol0IGoo001OOol5000EOol2000UOol00g`0Oomoo`0FOol00`00Oomo
o`0nOol30009Ool00`00Oomoo`0<Ool00g`0Oomoo`04Ool00g`0Oomoo`0JOol00`00Oomoo`1TOol0
05moo`05001oogooOol0000<Ool50004Ool00`00Oomoo`0SOol00g`0Oomoo`0HOol00`00Oomoo`0j
Ool3000<Ool00`00Oomoo`0=Ool00g`0Oomoo`03Ool00g`0Oomoo`0JOol00`00Oomoo`1TOol0061o
o`03001oogoo00eoo`05001oogooOol00004Ool00`00Oomoo`0ROol00g`0Oomoo`0JOol00`00Oomo
o`0fOol3000?Ool00`00Oomoo`0>Ool2O002Ool00g`0Oomoo`0KOol00`00Oomoo`1TOol0065oo`03
001oogoo00eoo`03001oogoo00Eoo`03001oogoo029oo`03O01oogoo01]oo`03001oogoo035oo`@0
015oo`80019oo`03O01oog`001eoo`03001oogoo06Aoo`00Ggoo00@007ooOol000moo`03001oogoo
00Aoo`03001oogoo025oo`03O01oogoo01eoo`03001oogoo02eoo`<0019oo`<0009oo`03001oogoo
011oo`03O01oogoo01aoo`03001oogoo06Aoo`00Ggoo1@003goo00<007ooOol00goo00<007ooOol0
8Goo00=l07ooOol07Woo00<007ooOol0:Goo0`004Woo0`001Woo00<007ooOol03goo0W`07Goo00<0
07ooOol0I7oo001dOol00`00Oomoo`02Ool00`00Oomoo`0POol00g`0Oomoo`0POol00`00Oomoo`0U
Ool3000AOol40009Ool00`00Oomoo`0>Ool017`0Oomoog`077oo00<007ooOol0I7oo001`Ool01@00
Oomoogoo000017oo00<007ooOol087oo00=l07ooOol08Goo00<007ooOol08Goo0`004Goo0`003Woo
00<007ooOol037oo00=l07ooOol00Woo00=l07ooOol06Woo00<007ooOol0Hgoo001aOol30004Ool0
0`00Oomoo`0QOol00g`0Oomoo`0ROol00`00Oomoo`0MOol3000AOol3000BOol00`00Oomoo`0;Ool0
0g`0Oomoo`02Ool00g`0Oomoo`0JOol00`00Oomoo`1SOol007Qoo`03001oogoo021oo`03O01oogoo
02Aoo`03001oogoo01Uoo`<0015oo`<001Ioo`03001oogoo00Uoo`03O01oogoo00Aoo`03O01oogoo
01Uoo`03001oogoo06=oo`00N7oo00<007ooOol087oo00=l07ooOol09Goo00<007ooOol05Goo0`00
4Goo0`006Goo00<007ooOol02Goo00=l07ooOol01Goo00=l07ooOol067oo00<007ooOol0Hgoo001h
Ool00`00Oomoo`0POol00g`0Oomoo`0VOol00`00Oomoo`0AOol3000AOol3000MOol00`00Oomoo`07
Ool00g`0Oomoo`07Ool00g`0Oomoo`0GOol00`00Oomoo`1SOol007Qoo`03001oogoo021oo`03O01o
ogoo02Moo`03001oogoo00aoo`@0015oo`<0025oo`03001oogoo00Eoo`03O01oogoo00Qoo`03O01o
ogoo01Moo`03001oogoo06=oo`00N7oo00<007ooOol087oo00=l07ooOol0:7oo00<007ooOol027oo
0`004Goo10009Goo00<007ooOol00goo00=l07ooOol02Woo00=l07ooOol05Woo00<007ooOol0Hgoo
001gOol00`00Oomoo`0QOol00g`0Oomoo`0YOol00`00Oomoo`04Ool3000AOol3000ZOol01@00Oomo
ogooO0003Woo00=l07ooOol05Woo00<007ooOol0HWoo001gOol00`00Oomoo`0ROol00g`0Oomoo`0Y
Ool00`00Oomoo`03000AOol3000]Ool01@00OomoogooO0003Woo00=l07ooOol05Woo00<007ooOol0
HWoo001gOol00`00Oomoo`0ROol00g`0Oomoo`0ZOol20006Ool;O003000aOol00`00Ooml000@Ool0
0g`0Oomoo`0EOol00`00Oomoo`1ROol007Moo`8002=oo`03O01oogoo02Moo`]l00Qoo`<0009oo`]l
02Qoo`03001oogoo00moo`03O01oogoo01Eoo`03001oogoo069oo`00Mgoo00<007ooOol08Woo00=l
07ooOol08Goo1W`00goo00<007ooOol02Woo0`0047oo1W`08Goo00=l07oo00004Goo00=l07ooOol0
57oo00<007ooOol0HWoo001gOol00`00Oomoo`0SOol00g`0Oomoo`0KOol5O009Ool00`00Oomoo`07
Ool3000IOol6O00JOol01G`0Oomoogoo000047oo00=l07ooOol057oo00<007ooOol0HWoo001gOol0
0`00Oomoo`0TOol00g`0Oomoo`0FOol4O00>Ool00`00Oomoo`03Ool4000ROol4O00DOol2O004Ool0
0`00Oomoo`0?Ool00g`0Oomoo`0COol00`00Oomoo`1ROol007Ioo`03001oogoo02Eoo`03O01oogoo
019oo`Al019oo`03001oogoo00<002Yoo`El00ioo`03O01oogoo00Eoo`03001oogoo00ioo`03O01o
ogoo01Aoo`03001oogoo065oo`00MWoo00<007ooOol09Woo00=l07ooOol03goo0W`05Woo0`00<Woo
17`02Goo00=l07ooOol01goo00<007ooOol03Woo00=l07ooOol04goo00<007ooOol0HGoo001fOol2
000XOol00g`0Oomoo`0<Ool2O00EOol4000hOol2O005Ool2O00;Ool00`00Oomoo`0=Ool00g`0Oomo
o`0COol00`00Oomoo`1QOol007Ioo`03001oogoo02Qoo`03O01oogoo00Uoo`9l01Aoo`<000=oo`03
001oogoo03Qoo`9l009oo`03O01oogoo00]oo`03001oogoo00eoo`03O01oogoo01=oo`03001oogoo
065oo`00MWoo00<007ooOol0:Goo00=l07ooOol01Woo0W`04goo0`001Woo00<007ooOol0>Woo0g`0
3Woo00<007ooOol037oo00=l07ooOol04goo00<007ooOol0HGoo001fOol00`00Oomoo`0ZOol00g`0
Oomoo`03Ool2O00BOol30009Ool00`00Oomoo`0hOol2O003Ool2O00=Ool00`00Oomoo`0<Ool00g`0
Oomoo`0BOol00`00Oomoo`1QOol007Ioo`03001oogoo02]oo`03O01oogoo009l011oo`@000aoo`03
001oogoo03Ioo`9l00Moo`9l00aoo`03001oogoo00]oo`03O01oogoo019oo`03001oogoo065oo`00
MGoo00<007ooOol0;Goo0W`03goo0`0047oo00<007ooOol0=7oo0W`02goo0W`02goo00<007ooOol0
2Woo00=l07ooOol04goo00<007ooOol0H7oo001eOol2000/Ool2O002Ool00g`0Oomoo`09Ool3000C
Ool00`00Oomoo`0bOol2O00?Ool2O009Ool00`00Oomoo`0:Ool00g`0Oomoo`0COol00`00Oomoo`1P
Ool007Eoo`03001oogoo02Uoo`9l00Eoo`03O01oogoo00Eoo`<001Ioo`03001oogoo031oo`9l01=o
o`9l00Qoo`03001oogoo00Uoo`03O01oogoo01=oo`03001oogoo061oo`00K7oo0`001Woo00<007oo
Ool0:7oo00=l07ooOol01Woo0W`00Woo0`006Goo00<007ooOol0;Woo0W`05goo0W`01goo00<007oo
Ool027oo00=l07ooOol04goo00<007ooOol0H7oo001[Ool01@00Oomoogoo00001Goo00<007ooOol0
9goo00=l07ooOol027oo0`006goo00<007ooOol0;Goo0W`06goo0W`01Woo00<007ooOol01Woo00=l
07ooOol057oo00<007ooOol0H7oo001_Ool00`00Oomoo`03Ool00`00Oomoo`0VOol00g`0Oomoo`05
Ool40003Ool2O00IOol00`00Oomoo`0ZOol3O00OOol00g`0Oomoo`04Ool00`00Oomoo`05Ool00g`0
Oomoo`0DOol00`00Oomoo`1POol006moo`03001oogoo009oo`03001oogoo02Ioo`03O01oogoo00=o
o`<000Uoo`9l01Moo`03001oogoo02Qoo`9l02=oo`9l00Aoo`03001oogoo00Eoo`03O01oogoo01Ao
o`03001oogoo061oo`00KGoo0P001Goo00<007ooOol09Woo00=l07ooOol00`003Woo0g`057oo00<0
07ooOol09Goo0g`09goo00=l07ooOol00Woo00<007ooOol017oo00=l07ooOol057oo00<007ooOol0
H7oo001_Ool00`00Oomoo`02Ool2000VOol017`00000000057oo0W`04Woo00<007ooOol08goo0W`0
:goo00=l07ooOol00Woo00<007ooOol00goo00=l07ooOol05Goo00<007ooOol0Ggoo001[Ool01@00
Oomoogoo000017oo00<007ooOol08goo0`006Goo0g`03goo00<007ooOol07goo17`0;Woo0W`00goo
00<007ooOol00Woo00=l07ooOol05Goo00<007ooOol0Ggoo001/Ool30005Ool00`00Oomoo`0POol3
00000g`0Oomoo`0LOol6O009Ool00`00Oomoo`0JOol5O00dOol017`0Oomoo`000goo00=l07ooOol0
5Woo00<007ooOol0Ggoo001dOol00`00Oomoo`0MOol30003Ool00g`0Oomoo`0ROol:O00EOol7O00j
Ool017`0Oomoo`000Woo00=l07ooOol05Woo00<007ooOol0Ggoo001dOol00`00Oomoo`0IOol40005
Ool00g`0Oomoo`0/Ool00`00O01l000CO012Ool01W`0Oomoo`00Ooml01Qoo`03001oogoo05moo`00
Lgoo00<007ooOol05goo0`002Goo00=l07ooOol0;7oo00<007ooOol0EWoo00El07ooOol007`001Qo
o`03001oogoo05moo`00Lgoo0P005Goo0`002goo00=l07ooOol0;Goo00<007ooOol0Egoo00Al07oo
O00001Qoo`03001oogoo05moo`00Lgoo00<007ooOol04Goo0`003Woo00=l07ooOol0;Goo00<007oo
Ool0F7oo0W`000<007ooOol05goo00<007ooOol0GWoo001cOol00`00Oomoo`0>Ool3000AOol00g`0
Oomoo`0]Ool00`00Oomoo`1HOol2O0000goo001oo`0GOol00`00Oomoo`1NOol007=oo`03001oogoo
00]oo`<001Aoo`03O01oogoo02eoo`03001oogoo05Qoo`05O01oog`0Ool0000GOol00`00Oomoo`1N
Ool007=oo`03001oogoo00Qoo`<001Ioo`03O01oogoo02ioo`03001oogoo05Moo`03O01oogoo00=o
o`03001oogoo01Aoo`03001oogoo05ioo`00LWoo00<007ooOol01Goo10006Goo00=l07ooOol0;Woo
00<007ooOol0Egoo00=l07ooOol017oo00<007ooOol04goo00<007ooOol0GWoo001bOol00`00Oomo
o`02Ool3000MOol00g`0Oomoo`0^Ool00`00Oomoo`1FOol00g`0Oomoo`05Ool00`00Oomoo`0COol0
0`00Oomoo`1NOol0079oo`D0021oo`03O01oogoo02ioo`03001oogoo05Ioo`03O01oogoo00Ioo`03
001oogoo019oo`03001oogoo05ioo`00LWoo0P0097oo00=l07ooOol0;Goo00<007ooOol0EGoo00=l
07ooOol027oo00<007ooOol04Woo00<007ooOol0GGoo001cOol2000SOol00g`0Oomoo`0]Ool00`00
Oomoo`1DOol00g`0Oomoo`0:Ool00`00Oomoo`0AOol00`00Oomoo`1MOol007Aoo`80029oo`03O01o
ogoo02eoo`03001oogoo05=oo`03O01oogoo00]oo`03001oogoo015oo`03001oogoo05eoo`00MWoo
00<007ooOol087oo00=l07ooOol0;7oo00<007ooOol0DWoo00=l07ooOol03Goo00<007ooOol047oo
00<007ooOol0GGoo001gOol2000POol00g`0Oomoo`0/Ool00`00Oomoo`1AOol00g`0Oomoo`0?Ool0
0`00Oomoo`0?Ool00`00Oomoo`1MOol007Uoo`03001oogoo01ioo`03O01oogoo02]oo`03001oogoo
051oo`03O01oogoo015oo`03001oogoo00ioo`03001oogoo05eoo`00NGoo0P007goo00=l07ooOol0
:goo00<007ooOol0Cgoo00=l07ooOol04goo00<007ooOol03Goo00<007ooOol0GGoo001kOol2000N
Ool00g`0Oomoo`0ZOol00`00Oomoo`1>Ool00g`0Oomoo`0DOol00`00Oomoo`0>Ool00`00Oomoo`1L
Ool007eoo`8001aoo`03O01oogoo02Yoo`03001oogoo04eoo`03O01oogoo01Ioo`03001oogoo00eo
o`03001oogoo05aoo`00OWoo0P0077oo00=l07ooOol0:Goo00<007ooOol0Bgoo0W`06Woo00<007oo
Ool037oo00<007ooOol0G7oo001cOol50008Ool00`00Oomoo`0JOol00g`0Oomoo`0XOol00`00Oomo
o`1:Ool00g`0Oomoo`0KOol00`00Oomoo`0;Ool00`00Oomoo`1LOol007=oo`05001oogooOol00009
Ool00`00Oomoo`0JOol00g`0Oomoo`0WOol00`00Oomoo`19Ool00g`0Oomoo`0MOol00`00Oomoo`0:
Ool00`00Oomoo`1LOol007Aoo`03001oogoo00]oo`8001]oo`03O01oogoo02Ioo`03001oogoo04Qo
o`03O01oogoo01ioo`03001oogoo00Yoo`03001oogoo05aoo`00Jgoo1P0017oo00<007ooOol037oo
00<007ooOol06Goo00=l07ooOol09Goo00<007ooOol0AWoo0W`08Woo00<007ooOol02Goo00<007oo
Ool0G7oo001fOol00`00Oomoo`0<Ool00`00Oomoo`0IOol00g`0Oomoo`0SOol00`00Oomoo`15Ool2
O00UOol00`00Oomoo`09Ool00`00Oomoo`1KOol007Moo`03001oogoo00aoo`8001Yoo`9l02=oo`03
001oogoo04=oo`9l02Qoo`03001oogoo00Qoo`03001oogoo05]oo`00Lgoo00D007ooOomoo`0000mo
o`8001]oo`9l025oo`03001oogoo045oo`9l02Yoo`03001oogoo00Qoo`03001oogoo05]oo`00M7oo
0`004Woo0`006Woo0W`07goo00<007ooOol0?goo0W`0;Goo00<007ooOol01goo00<007ooOol0Fgoo
002;Ool00`00Oomoo`0JOol00g`0Oomoo`0LOol00`00Oomoo`0mOol2O00`Ool00`00Oomoo`06Ool0
0`00Oomoo`1KOol008]oo`8001aoo`9l01aoo`03001oogoo03]oo`9l03=oo`03001oogoo00Eoo`03
001oogoo05]oo`00SGoo0P0077oo0W`06Woo00<007ooOol0>Goo0W`0=Woo00<007ooOol017oo00<0
07ooOol0Fgoo002?Ool2000LOol2O00HOol00`00Oomoo`0fOol3O00hOol00`00Oomoo`04Ool00`00
Oomoo`1KOol0091oo`03001oogoo01aoo`9l01Ioo`03001oogoo03=oo`=l03aoo`03001oogoo00Ao
o`03001oogoo05Yoo`00TGoo0P007Woo0g`04goo00<007ooOol0;goo17`0@7oo00<007ooOol00goo
00<007ooOol0FWoo002COol2000OOol3O00@Ool00`00Oomoo`0[Ool4O015Ool00`00Oomoo`02Ool0
0`00Oomoo`1JOol009Aoo`80025oo`Al00aoo`03001oogoo02Ioo`El04Yoo`05001oogooOol0001L
Ool009Ioo`03001oogoo029oo`El00Moo`03001oogoo025oo`El04moo`05001oogooOol0001LOol0
08aoo`D000Ioo`8002Moo`Ml0003001oogoo01]oo`Il05Eoo`04001oogoo001LOol008ioo`03001o
ogoo00Moo`8002eooail05aoo`03001oo`0005aoo`00SWoo00<007ooOol02Goo00<007ooOol0:Woo
00<007ooOol0N7oo00<007oo0000Fgoo0023Ool60005Ool00`00Oomoo`0:Ool2000ZOol00`00Oomo
o`1hOol00`00Ool0001KOol008ioo`03001oogoo00]oo`8002Uoo`03001oogoo07Uoo`8005]oo`00
SWoo00<007ooOol03Goo00<007ooOol09Woo00<007ooOol0N7oo0`00Fgoo002<Ool3000@Ool2000V
Ool00`00Oomoo`1dOol4001NOol008ioo`03001oogoo00moo`8002Eoo`03001oogoo071oo`@0069o
o`00XWoo00<007ooOol08Woo00<007ooOol0Jgoo1@00IWoo002SOol2000ROol00`00Oomoo`1WOol4
001[Ool00:Aoo`80025oo`03001oogoo06=oo`@006moo`00YWoo0P007goo00<007ooOol0GWoo1@00
Lgoo002XOol00`00Oomoo`0LOol00`00Oomoo`1JOol4001hOol00:Qoo`8001eoo`03001oogoo05Io
o`@007aoo`00ZWoo0P006goo00<007ooOol0DGoo1@00P7oo002MOol4000;Ool00`00Oomoo`0HOol0
0`00Oomoo`1=Ool40025Ool009aoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Moo`03
001oogoo04Uoo`@008Uoo`00W7oo00<007ooOol00Woo00<007ooOol02Woo0P005goo00<007ooOol0
A7oo1@00SGoo002LOol00`00Oomoo`02Ool00`00Oomoo`0;Ool2000FOol00`00Oomoo`10Ool4002B
Ool009aoo`03001oogoo009oo`03001oogoo00eoo`<0019oo`03001oogoo03eoo`@009Ioo`00W7oo
00<007ooOol00Woo00<007ooOol03goo00<007ooOol047oo00<007ooOol0>7oo1@00VWoo002LOol0
0`00Oomoo`02Ool00`00Oomoo`0?Ool2000AOol00`00Oomoo`0dOol4002OOol009eoo`@001Aoo`<0
00ioo`03001oogoo02moo`D00:=oo`00]Woo0P003Woo00<007ooOol0:goo1000Z7oo002hOol00`00
Oomoo`0;Ool00`00Oomoo`0WOol4002/Ool00;Uoo`8000]oo`03001oogoo029oo`D00;1oo`00^Woo
0P002Woo00<007ooOol07Woo1000]Goo002lOol20008Ool00`00Oomoo`0JOol4002iOol00;eoo`80
00Moo`03001oogoo01Eoo`D00;eoo`00/7oo1@002Woo00<007ooOol017oo00<007ooOol04Goo1000
`Woo002bOol00`00Oomoo`0;Ool20004Ool00`00Oomoo`0=Ool40036Ool009]oo`<001Aoo`03001o
ogoo00aoo`8000=oo`03001oogoo00Qoo`D00<Yoo`00WGoo00<007ooOol04Woo00<007ooOol03Woo
0P0000=oo`00Ool01Goo1000cgoo002MOol00`00Oomoo`0BOol00`00Oomoo`0?Ool30002Ool4003C
Ool009aoo`03001oo`0001=oo`03001oogoo015oo`<00=Moo`00W7oo00<007oo00004Goo0`00kGoo
002KOol01@00Oomoogoo00004Woo00<007ooOol0jgoo002KOol01@00Oomoogoo0000ogoo0Goo002J
Ool3000017oo00000000ogoo003oOonQOol00?mooj5oo`00`Goo1@00fWoo0031Ool01@00Oomoogoo
0000fWoo0032Ool00`00Oomoo`3KOol00<=oo`03001oogoo0=Yoo`00a7oo00<007ooOol0fGoo0035
Ool00`00Oomoo`3HOol00<5oo`05001oogooOol0003JOol00<9oo`<00=]oo`00\
\>"],
  ImageRangeCache->{{{0, 415.625}, {244.625, 0}} -> {-0.450194, -0.0523032, \
0.00528819, 0.00528819}}]
}, Open  ]],

Cell[TextData[{
  "The tangent vector of the curve is just calculated with the definition by \
differentiating \[CapitalPhi] with respect to the parameter ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->"tangent vector"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tang = \[PartialD]\_t \[CapitalPhi]\)], "Input"],

Cell[BoxData[
    \({\(-2\)\ Sin[t], 2\ Cos[t], 1\/\(2\ \@t\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The derived tangent vector depends on the location on the curve. In the \
parametric representation, we also observe that the tangent vector is \
infinite in the origin and becomes smaller and smaller if ",
  StyleBox["t",
    FontSlant->"Italic"],
  " increases. If we plot the tangents on different locations along the \
curve, we get a field of vectors defining the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  ". The function ",
  StyleBox["Line[]", "MmaText"],
  " allows us to graphically represent the vector field in connection with \
the curve:"
}], "Text",
  Evaluatable->False,
  CellTags->{"parametric representation", "vector field", "Line[]"}],

Cell[BoxData[
    \(\(vfield = 
      Table[\n\t\t{RGBColor[0.000, 0.000, 1.000], \n\t\t\t
          Line[{\[CapitalPhi], \[CapitalPhi] + tang\/\@\(tang . tang\)}]}, \n
        \t\t{t, 0.1, 4\ \[Pi],  .7}]; \)\)], "Input",
  PageWidth->Infinity],

Cell["\<\
The vector field and the curve are shown below. We combine the \
plots and the graphic primitives as follows:\
\>", "Text",
  Evaluatable->False,
  CellTags->"graphic primitives"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[pl1, Graphics3D[vfield], \n\tPlotRange \[Rule] All]\)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00058 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0201266 1.09111 -1.11022e-016 1.09111 [
[.09659 .22558 -11.9014 -9 ]
[.09659 .22558 .09864 0 ]
[.21824 .17535 -11.4057 -9 ]
[.21824 .17535 .59432 0 ]
[.34611 .12258 -5.455 -9 ]
[.34611 .12258 .545 0 ]
[.48068 .06706 -5.20715 -9 ]
[.48068 .06706 .79285 0 ]
[.6225 .0086 -4.95931 -9 ]
[.6225 .0086 1.04069 0 ]
[.30588 .06856 -10.899 -19 ]
[.30588 .06856 1.10098 0 ]
[.03377 .74679 -6.87586 0 ]
[.03377 .74679 5.12414 9 ]
[.13267 .81958 -6.68486 0 ]
[.13267 .81958 5.31514 9 ]
[.22249 .88568 -3.25914 0 ]
[.22249 .88568 2.74086 9 ]
[.30442 .94597 -3.18586 0 ]
[.30442 .94597 2.81414 9 ]
[.37945 1.00119 -3.12089 0 ]
[.37945 1.00119 2.87911 9 ]
[.21265 .95075 -6.52538 0 ]
[.21265 .95075 5.47462 19 ]
[.05814 .26384 -6 -2.65859 ]
[.05814 .26384 0 6.34141 ]
[.04054 .37446 -6 -2.75502 ]
[.04054 .37446 0 6.24498 ]
[.02155 .49393 -6 -2.85996 ]
[.02155 .49393 0 6.14004 ]
[.00096 .62335 -6 -2.97458 ]
[.00096 .62335 0 6.02542 ]
[-0.03796 .48957 -12 -5.98558 ]
[-0.03796 .48957 0 13.0144 ]
[ 0 0 0 0 ]
[ 1 1.00058 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.07225 .24924 m
.67866 0 L
s
.10616 .23531 m
.11094 .24017 L
s
[(-2)] .09659 .22558 .98356 1 Mshowa
.22737 .18549 m
.23194 .19055 L
s
[(-1)] .21824 .17535 .90095 1 Mshowa
.35475 .13313 m
.35907 .13841 L
s
[(0)] .34611 .12258 .81833 1 Mshowa
.48877 .07805 m
.49281 .08354 L
s
[(1)] .48068 .06706 .73572 1 Mshowa
.62996 .02002 m
.63369 .02573 L
s
[(2)] .6225 .0086 .6531 1 Mshowa
.125 Mabswid
.12993 .22554 m
.13277 .22848 L
s
.15393 .21567 m
.15675 .21864 L
s
.17817 .20571 m
.18097 .2087 L
s
.20265 .19565 m
.20542 .19866 L
s
.25234 .17522 m
.25505 .17829 L
s
.27756 .16486 m
.28024 .16795 L
s
.30303 .15439 m
.30568 .1575 L
s
.32876 .14381 m
.33138 .14696 L
s
.381 .12234 m
.38356 .12553 L
s
.40753 .11144 m
.41006 .11466 L
s
.43433 .10042 m
.43682 .10367 L
s
.46141 .08929 m
.46387 .09256 L
s
.51641 .06669 m
.5188 .07001 L
s
.54435 .0552 m
.5467 .05855 L
s
.57258 .0436 m
.5749 .04697 L
s
.60112 .03187 m
.60339 .03527 L
s
.08262 .24498 m
.08551 .24788 L
s
.65911 .00803 m
.6613 .01149 L
s
gsave
.30588 .06856 -71.899 -23 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.25 Mabswid
0 .7069 m
.39763 1.00058 L
s
.03574 .73329 m
.03672 .72654 L
s
[(-2)] .03377 .74679 .14598 -1 Mshowa
.13422 .80603 m
.13499 .79925 L
s
[(-1)] .13267 .81958 .11414 -1 Mshowa
.22366 .87209 m
.22425 .8653 L
s
[(0)] .22249 .88568 .08638 -1 Mshowa
.30526 .93236 m
.30568 .92555 L
s
[(1)] .30442 .94597 .06195 -1 Mshowa
.38 .98756 m
.38028 .98075 L
s
[(2)] .37945 1.00119 .0403 -1 Mshowa
.125 Mabswid
.05622 .74842 m
.05678 .74437 L
s
.0763 .76325 m
.07684 .7592 L
s
.09598 .77779 m
.0965 .77373 L
s
.11529 .79205 m
.11578 .78798 L
s
.15279 .81975 m
.15323 .81568 L
s
.17101 .8332 m
.17143 .82913 L
s
.18889 .84641 m
.18928 .84234 L
s
.20644 .85937 m
.20681 .8553 L
s
.24058 .88459 m
.24091 .88051 L
s
.25719 .89685 m
.2575 .89277 L
s
.2735 .9089 m
.27379 .90482 L
s
.28952 .92073 m
.28979 .91665 L
s
.32073 .94379 m
.32096 .9397 L
s
.33593 .95501 m
.33615 .95093 L
s
.35087 .96605 m
.35107 .96196 L
s
.36556 .9769 m
.36574 .97281 L
s
.01483 .71785 m
.01545 .71381 L
s
.3942 .99805 m
.39435 .99396 L
s
gsave
.21265 .95075 -67.5254 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.25 Mabswid
.07225 .24924 m
0 .7069 L
s
.07076 .25867 m
.07707 .25609 L
s
[(0)] .05814 .26384 1 -0.4092 Mshowa
.05326 .36953 m
.05962 .36706 L
s
[(1)] .04054 .37446 1 -0.38777 Mshowa
.03436 .48925 m
.04077 .48692 L
s
[(2)] .02155 .49393 1 -0.36445 Mshowa
.01388 .61897 m
.02034 .61678 L
s
[(3)] .00096 .62335 1 -0.33898 Mshowa
.125 Mabswid
.06737 .28018 m
.07116 .27865 L
s
.06392 .30201 m
.06772 .30049 L
s
.06042 .32418 m
.06422 .32267 L
s
.05687 .34668 m
.06068 .34518 L
s
.0496 .39273 m
.05342 .39126 L
s
.04588 .41629 m
.0497 .41485 L
s
.0421 .44023 m
.04593 .4388 L
s
.03826 .46455 m
.0421 .46313 L
s
.0304 .51436 m
.03425 .51298 L
s
.02637 .53987 m
.03022 .53851 L
s
.02227 .56581 m
.02614 .56446 L
s
.01811 .59217 m
.02198 .59084 L
s
.00958 .64622 m
.01346 .64493 L
s
.0052 .67394 m
.00909 .67266 L
s
.00075 .70212 m
.00465 .70087 L
s
gsave
-0.03796 .48957 -73 -9.98558 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.25 Mabswid
.07225 .24924 m
0 .7069 L
s
0 .7069 m
.39763 1.00058 L
s
.39763 1.00058 m
.41223 .58672 L
s
.41223 .58672 m
.07225 .24924 L
s
.67866 0 m
.94026 .41817 L
s
.94026 .41817 m
1 .85585 L
s
1 .85585 m
.70669 .47963 L
s
.70669 .47963 m
.67866 0 L
s
.07225 .24924 m
0 .7069 L
s
0 .7069 m
.70669 .47963 L
s
.70669 .47963 m
.67866 0 L
s
.67866 0 m
.07225 .24924 L
s
.41223 .58672 m
.94026 .41817 L
s
.94026 .41817 m
1 .85585 L
s
1 .85585 m
.39763 1.00058 L
s
.39763 1.00058 m
.41223 .58672 L
s
0 0 m
1 0 L
1 1.00058 L
0 1.00058 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.66932 .62374 m
.55831 .68443 L
s
1 0 0 r
.5782 .65976 m
.53352 .66932 L
s
.62159 .64572 m
.5782 .65976 L
s
.53352 .66932 m
.48849 .67445 L
s
.66274 .62725 m
.62159 .64572 L
s
0 0 1 r
.4905 .67432 m
.35857 .68349 L
s
1 0 0 r
.48849 .67445 m
.44407 .67521 L
s
.70069 .6044 m
.66274 .62725 L
s
.44407 .67521 m
.40122 .67173 L
s
.7345 .5773 m
.70069 .6044 L
s
0 0 1 r
.79124 .50033 m
.74357 .60407 L
s
1 0 0 r
.40122 .67173 m
.3609 .66417 L
s
.76321 .54613 m
.7345 .5773 L
s
.3609 .66417 m
.32409 .65278 L
s
.78591 .51113 m
.76321 .54613 L
s
.32409 .65278 m
.29178 .63786 L
s
0 0 1 r
.67328 .80798 m
.55293 .85465 L
s
.32142 .65175 m
.2171 .61082 L
s
1 0 0 r
.80176 .47255 m
.78591 .51113 L
s
.53394 .83969 m
.48661 .84202 L
s
.581 .83341 m
.53394 .83969 L
s
.62682 .82318 m
.581 .83341 L
s
.48661 .84202 m
.43999 .84041 L
s
0 0 1 r
.48406 .84203 m
.34447 .84244 L
s
1 0 0 r
.29178 .63786 m
.26495 .6198 L
s
.67043 .80907 m
.62682 .82318 L
s
.80998 .4306 m
.80176 .47255 L
s
.43999 .84041 m
.39506 .83497 L
s
.71084 .7912 m
.67043 .80907 L
s
.39506 .83497 m
.3528 .82582 L
s
0 0 1 r
.80703 .71177 m
.75041 .79446 L
s
1 0 0 r
.80993 .38524 m
.80998 .4306 L
s
.74708 .76976 m
.71084 .7912 L
s
.26495 .6198 m
.24452 .59908 L
s
.3528 .82582 m
.31423 .81316 L
s
.77814 .74502 m
.74708 .76976 L
s
0 0 1 r
.79471 .31211 m
.83465 .44872 L
s
1 0 0 r
.80106 .33528 m
.80993 .38524 L
s
.31423 .81316 m
.28036 .79724 L
s
.24452 .59908 m
.2314 .57628 L
s
0 0 1 r
.30789 .81058 m
.19914 .76497 L
s
1 0 0 r
.78146 .26013 m
.80106 .33528 L
s
.80306 .71733 m
.77814 .74502 L
s
.28036 .79724 m
.2522 .77842 L
s
.2314 .57628 m
.22635 .55212 L
s
.82093 .68716 m
.80306 .71733 L
s
0 0 1 r
.22973 .57155 m
.20629 .49775 L
s
1 0 0 r
.2522 .77842 m
.23074 .75713 L
s
.83091 .65508 m
.82093 .68716 L
s
.22635 .55212 m
.22998 .52738 L
s
0 0 1 r
.82034 .5777 m
.86296 .67101 L
s
1 0 0 r
.23074 .75713 m
.21691 .7339 L
s
.83231 .6218 m
.83091 .65508 L
s
.22998 .52738 m
.24268 .50299 L
s
.21691 .7339 m
.21153 .70939 L
s
.82463 .58814 m
.83231 .6218 L
s
0 0 1 r
.21438 .72669 m
.19206 .65092 L
s
1 0 0 r
.24268 .50299 m
.26454 .47993 L
s
.80766 .55501 m
.82463 .58814 L
s
.21153 .70939 m
.21525 .68436 L
s
.26454 .47993 m
.29527 .45923 L
s
0 0 1 r
.27348 .47297 m
.36322 .40771 L
s
1 0 0 r
.78149 .52342 m
.80766 .55501 L
s
.21525 .68436 m
.2285 .65966 L
s
.29527 .45923 m
.33422 .44189 L
s
.74662 .49441 m
.78149 .52342 L
s
0 0 1 r
.68335 .45929 m
.82304 .52021 L
s
1 0 0 r
.33422 .44189 m
.38029 .42887 L
s
.2285 .65966 m
.25139 .63625 L
s
.70397 .46898 m
.74662 .49441 L
s
.38029 .42887 m
.43196 .42095 L
s
.65487 .44806 m
.70397 .46898 L
s
.25139 .63625 m
.28363 .6151 L
s
.43196 .42095 m
.48739 .41873 L
s
.79311 .66619 m
.82015 .69562 L
s
.60105 .4324 m
.65487 .44806 L
s
0 0 1 r
.45621 .41924 m
.62097 .4116 L
s
1 0 0 r
.48739 .41873 m
.54449 .42254 L
s
0 0 1 r
.26384 .62702 m
.36119 .56097 L
s
1 0 0 r
.54449 .42254 m
.60105 .4324 L
s
.28363 .6151 m
.32453 .59721 L
s
.7569 .63923 m
.79311 .66619 L
s
0 0 1 r
.69593 .60877 m
.84005 .66591 L
s
1 0 0 r
.32453 .59721 m
.37293 .58349 L
s
.71245 .61572 m
.7569 .63923 L
s
.37293 .58349 m
.42724 .57471 L
s
.66114 .59656 m
.71245 .61572 L
s
.60476 .58249 m
.66114 .59656 L
s
.42724 .57471 m
.48548 .57145 L
s
0 0 1 r
.45849 .57223 m
.63277 .56321 L
s
1 0 0 r
.54544 .57403 m
.60476 .58249 L
s
.48548 .57145 m
.54544 .57403 L
s
0 g
.25 Mabswid
.67866 0 m
.94026 .41817 L
s
.94026 .41817 m
1 .85585 L
s
1 .85585 m
.70669 .47963 L
s
.70669 .47963 m
.67866 0 L
s
.07225 .24924 m
0 .7069 L
s
0 .7069 m
.70669 .47963 L
s
.70669 .47963 m
.67866 0 L
s
.67866 0 m
.07225 .24924 L
s
.07225 .24924 m
.67866 0 L
s
.10616 .23531 m
.11094 .24017 L
s
[(-2)] .09659 .22558 .98356 1 Mshowa
.22737 .18549 m
.23194 .19055 L
s
[(-1)] .21824 .17535 .90095 1 Mshowa
.35475 .13313 m
.35907 .13841 L
s
[(0)] .34611 .12258 .81833 1 Mshowa
.48877 .07805 m
.49281 .08354 L
s
[(1)] .48068 .06706 .73572 1 Mshowa
.62996 .02002 m
.63369 .02573 L
s
[(2)] .6225 .0086 .6531 1 Mshowa
.125 Mabswid
.12993 .22554 m
.13277 .22848 L
s
.15393 .21567 m
.15675 .21864 L
s
.17817 .20571 m
.18097 .2087 L
s
.20265 .19565 m
.20542 .19866 L
s
.25234 .17522 m
.25505 .17829 L
s
.27756 .16486 m
.28024 .16795 L
s
.30303 .15439 m
.30568 .1575 L
s
.32876 .14381 m
.33138 .14696 L
s
.381 .12234 m
.38356 .12553 L
s
.40753 .11144 m
.41006 .11466 L
s
.43433 .10042 m
.43682 .10367 L
s
.46141 .08929 m
.46387 .09256 L
s
.51641 .06669 m
.5188 .07001 L
s
.54435 .0552 m
.5467 .05855 L
s
.57258 .0436 m
.5749 .04697 L
s
.60112 .03187 m
.60339 .03527 L
s
.08262 .24498 m
.08551 .24788 L
s
.65911 .00803 m
.6613 .01149 L
s
gsave
.30588 .06856 -71.899 -23 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.25 Mabswid
0 .7069 m
.39763 1.00058 L
s
.03574 .73329 m
.03672 .72654 L
s
[(-2)] .03377 .74679 .14598 -1 Mshowa
.13422 .80603 m
.13499 .79925 L
s
[(-1)] .13267 .81958 .11414 -1 Mshowa
.22366 .87209 m
.22425 .8653 L
s
[(0)] .22249 .88568 .08638 -1 Mshowa
.30526 .93236 m
.30568 .92555 L
s
[(1)] .30442 .94597 .06195 -1 Mshowa
.38 .98756 m
.38028 .98075 L
s
[(2)] .37945 1.00119 .0403 -1 Mshowa
.125 Mabswid
.05622 .74842 m
.05678 .74437 L
s
.0763 .76325 m
.07684 .7592 L
s
.09598 .77779 m
.0965 .77373 L
s
.11529 .79205 m
.11578 .78798 L
s
.15279 .81975 m
.15323 .81568 L
s
.17101 .8332 m
.17143 .82913 L
s
.18889 .84641 m
.18928 .84234 L
s
.20644 .85937 m
.20681 .8553 L
s
.24058 .88459 m
.24091 .88051 L
s
.25719 .89685 m
.2575 .89277 L
s
.2735 .9089 m
.27379 .90482 L
s
.28952 .92073 m
.28979 .91665 L
s
.32073 .94379 m
.32096 .9397 L
s
.33593 .95501 m
.33615 .95093 L
s
.35087 .96605 m
.35107 .96196 L
s
.36556 .9769 m
.36574 .97281 L
s
.01483 .71785 m
.01545 .71381 L
s
.3942 .99805 m
.39435 .99396 L
s
gsave
.21265 .95075 -67.5254 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{333.313, 191.063},
  ImageMargins->{{0, 0}, {0, 2.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006P0000kQ000`40O003h00Ol7oo1@00Zgoo003`
Ool01@00Oomoogoo0000Zgoo003aOol00`00Oomoo`2/Ool00?9oo`03001oogoo0:]oo`00lgoo00<0
07ooOol0ZWoo003dOol00`00Oomoo`2YOol00?1oo`05001oogooOol0002[Ool00?5oo`<00:aoo`00
Ygoo0P000Woo0P00lgoo002XOol01000Oomoo`00E7oo0P00WWoo002YOol2001COol200000goo0000
002MOol00:Uoo`80051oo`<000=oo`8009eoo`00Z7oo00@007ooOol004eoo`8000=oo`06001oogoo
001oo`00W7oo002WOol20002Ool2000UOol5000POol20008Ool01000Oomoo`00Vgoo003DOol00`00
Oomoo`0MOol300000goo001oo`07Ool01000Oomoo`00Vgoo003DOol00`00Oomoo`0KOol20004Ool0
0`00Oomoo`06Ool01@00Oomoogoo0000VWoo003DOol00`00Oomoo`0HOol3000?Ool01@00Oomoogoo
0000VWoo003DOol00`00Oomoo`0FOol20002Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomo
o`2GOol00=Aoo`03001oogoo01Aoo`8001Eoo`03001oogoo009oo`03001oogoo09Ioo`00dWoo0`00
4goo10005Woo00<007ooOol00Woo00<007ooOol0UWoo003DOol00`00Oomoo`0?Ool2000JOol00`00
Oomoo`03Ool00`00Oomoo`2EOol00>=oo`<001aoo`03001oogoo00Aoo`03001oogoo09Aoo`00hGoo
0P000Woo00<007ooOol06Woo00<007ooOol017oo00<007ooOol0U7oo003NOol3000QOol00`00Oomo
o`05Ool00`00Oomoo`2COol00;Aoo`@002Aoo`@0029oo`03001oogoo00Ioo`03001oogoo099oo`00
/goo00<007ooOol00Woo00<007ooOol07goo0P009Woo00<007ooOol01Woo00<007ooOol0TWoo002c
Ool00`00Oomoo`02Ool00`00Oomoo`0LOol3000XOol00`00Oomoo`07Ool00`00Oomoo`2AOol00;=o
o`03001oogoo009oo`03001oogoo01Yoo`80009oo`03001oogoo02Ioo`03001oogoo00Moo`03001o
ogoo095oo`00/goo00<007ooOol00Woo00<007ooOol067oo0P00;Goo00<007ooOol027oo00<007oo
Ool0T7oo002cOol00`00Oomoo`02Ool00`00Oomoo`0EOol4000^Ool00`00Oomoo`09Ool00`00Oomo
o`2?Ool00;=oo`03001oogoo009oo`03001oogoo01=oo`80039oo`03001oogoo00Uoo`03001oogoo
08moo`00]7oo10004goo0`00=7oo00<007ooOol02Woo00<007ooOol0SWoo0039Ool2000gOol00`00
Oomoo`0;Ool00`00Oomoo`2=Ool00<Moo`8003Uoo`03001oogoo00]oo`03001oogoo08eoo`00a7oo
0`0000=oo`00Ool0>7oo00<007ooOol037oo00<007ooOol0S7oo0031Ool3000oOol00`00Oomoo`0;
Ool00`00Oomoo`2<Ool009Uoo`D0025oo`@0041oo`03001oogoo00aoo`03001oogoo08]oo`00Vgoo
00<007ooOol07goo0P00A7oo00<007ooOol03Goo00<007ooOol0RWoo002KOol00`00Oomoo`0LOol3
0016Ool00`00Oomoo`0=Ool00`00Oomoo`2:Ool0091oo`H000Eoo`03001oogoo01Yoo`8000=oo`03
001oogoo04=oo`03001oogoo00ioo`03001oogoo08Uoo`00Vgoo00<007ooOol067oo0P00Bgoo00<0
07ooOol03goo00<007ooOol0R7oo002KOol00`00Oomoo`0EOol300000goo001oo`1:Ool00`00Oomo
o`0?Ool00`00Oomoo`28Ool009Uoo`<001Aoo`<0051oo`03001oogoo011oo`03001oogoo08Moo`00
Vgoo00<007ooOol047oo1000DGoo00<007ooOol04Goo00<007ooOol0QWoo002/Ool2001EOol00`00
Oomoo`0AOol00`00Oomoo`26Ool00:Yoo`<005Ioo`03001oogoo019oo`03001oogoo08Eoo`00Ygoo
0`00FGoo00<007ooOol04Woo00<007ooOol0QGoo001mOol5000SOol2001LOol00`00Oomoo`0COol0
0`00Oomoo`24Ool007eoo`05001oogooOol0000POol3001NOol00`00Oomoo`0DOol00`00Oomoo`23
Ool007ioo`03001oogoo01moo`80065oo`03001oogoo01Aoo`03001oogoo08=oo`00MGoo1P0017oo
00<007ooOol077oo0P0000=oo`00Ool0H7oo00<007ooOol05Goo00<007ooOol0PWoo0020Ool00`00
Oomoo`0HOol3001UOol00`00Oomoo`0FOol00`00Oomoo`21Ool0085oo`03001oogoo01Eoo`<006Qo
o`03001oogoo01Eoo`03001oogoo085oo`00OGoo00D007ooOomoo`0001Aoo`<006]oo`03001oogoo
01Ioo`03001oogoo081oo`00OWoo0`004goo0`00KGoo00<007ooOol05goo00<007ooOol0Ogoo002B
Ool2001`Ool00`00Oomoo`0GOol00`00Oomoo`1oOol008moo`<0079oo`03001oogoo01Qoo`03001o
ogoo07ioo`00SGoo0P00MGoo00<007ooOol067oo00<007ooOol0OWoo002:Ool3001gOol00`00Oomo
o`0IOol00`00Oomoo`1mOol008Qoo`8007Yoo`03001oogoo01Yoo`03001oogoo07aoo`00QWoo0P00
O7oo00<007ooOol06Woo00<007ooOol0O7oo0023Ool300000goo001oo`1kOol00`00Oomoo`0KOol0
0`00Oomoo`1kOol0085oo`80085oo`03001oogoo01aoo`03001oogoo07Yoo`00Ogoo0P00Pgoo00<0
07ooOol077oo00<007ooOol0NWoo001oOol20023Ool00`00Oomoo`0MOol00`00Oomoo`1iOol007mo
o`03001oo`00089oo`03001oogoo011oo`03O01oogoo00Yoo`03001oogoo07Uoo`00MWoo10001Goo
00@007ooOol0085oo`03001oogoo011oo`03O01oogoo00]oo`03001oogoo07Qoo`00MGoo00<007oo
Ool00Woo00D007ooOomoo`0000Aoo`03001oogoo07ioo`03001oogoo015oo`03O01oogoo00]oo`03
001oogoo07Moo`00MGoo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo07eoo`03001o
ogoo015oo`03O01oogoo00]oo`03001oogoo07Moo`00MGoo00<007ooOol00Woo00@007ooOomoo`80
00Eoo`03001oogoo07aoo`03001oogoo015oo`03O01oogoo00aoo`03001oogoo07Ioo`00MGoo00<0
07ooOol00Woo00D007ooOomoo`0000Moo`03001oogoo07aoo`03001oogoo015oo`03O01oogoo00ao
o`03001oogoo07Eoo`00MGoo00<007ooOol00Woo00D007ooOomoo`0000Qoo`03001oogoo07]oo`03
001oogoo015oo`03O01oogoo00aoo`03001oogoo07Eoo`00MGoo00<007ooOol00Woo00D007ooOomo
o`0000Uoo`03001oogoo07Yoo`03001oogoo015oo`03O01oogoo00eoo`03001oogoo07Aoo`00MWoo
10000goo00<007ooOol02Goo00<007ooOol0NGoo00<007ooOol04Woo00=l07ooOol03Goo00<007oo
Ool0Lgoo001mOol2000;Ool00`00Oomoo`1hOol00`00Oomoo`0BOol00g`0Oomoo`0=Ool00`00Oomo
o`1cOol007eoo`03001oogoo00]oo`03001oogoo07Moo`03001oogoo019oo`03O01oogoo00ioo`03
001oogoo079oo`00OGoo00<007ooOol037oo00<007ooOol0MWoo00<007ooOol04Woo00=l07ooOol0
3Woo00<007ooOol0LWoo001mOol00`00Oomoo`0=Ool00`00Oomoo`1eOol00`00Oomoo`0BOol00`0O
O01oo`0?Ool00`00Oomoo`1aOol007eoo`03001oogoo00ioo`03001oogoo07Aoo`03001oogoo01=o
o`03O01oogoo00moo`03001oogoo071oo`00O7oo0P004Goo00<007ooOol0Lgoo00<007ooOol04goo
00=l07ooOol03goo00<007ooOol0L7oo001lOol00`00Oomoo`0AOol00`00Oomoo`1bOol00`00Oomo
o`0COol00`0OO01oo`0@Ool00`00Oomoo`1_Ool007aoo`03001oogoo019oo`03001oogoo075oo`03
001oogoo01Aoo`03O01oogoo011oo`03001oogoo06ioo`00O7oo00<007ooOol04goo00<007ooOol0
L7oo00<007ooOol057oo00=l07ooOol047oo00<007ooOol0KWoo001lOol00`00Oomoo`0DOol00`00
Oomoo`1_Ool00`00Oomoo`0DOol00g`0Oomoo`0AOol00`00Oomoo`1]Ool007aoo`03001oogoo01Eo
o`03001oogoo06ioo`03001oogoo01Aoo`0301ml07oo019oo`03001oogoo06aoo`00Ngoo00<007oo
Ool05goo00<007ooOol0KGoo00<007ooOol05Goo00=l07ooOol04Goo00<007ooOol0K7oo001kOol0
0`00Oomoo`0HOol00`00Oomoo`1/Ool00`00Oomoo`0EOol00g`0Oomoo`0BOol00`00Oomoo`1[Ool0
07]oo`03001oogoo01Uoo`03001oogoo06aoo`03001oogoo01Aoo`03O01oogoo019oo`03001oogoo
06]oo`00Ngoo0P006goo00<007ooOol0Jgoo00<007ooOol057oo00=l000OOol04goo00<007ooOol0
JWoo001kOol00`00Oomoo`0KOol00`00Oomoo`1ZOol00`00Oomoo`0DOol00g`001moo`0DOol00`00
Oomoo`1YOol0079oo`D000Aoo`03001oogoo01aoo`03001oogoo06Uoo`03001oogoo01Eoo`03O01o
ogoo01=oo`03001oogoo06Uoo`00M7oo00<007ooOol00goo00<007ooOol07Woo00<007ooOol0J7oo
00<007ooOol05Goo00=l000OOol057oo00<007ooOol0J7oo001dOol00`00Oomoo`03Ool00`00Oomo
o`0OOol00`00Oomoo`1WOol00`00Oomoo`0EOol00g`001moo`0EOol00`00Oomoo`1WOol007Aoo`03
001oogoo00=oo`80025oo`03001oogoo06Ioo`03001oogoo01Eoo`03O0007goo01Eoo`03001oogoo
06Moo`00M7oo00<007ooOol00goo00<007ooOol08Goo00<007ooOol0IGoo00<007ooOol05Goo00=l
000OOol05Woo00<007ooOol0IWoo001dOol00`00Oomoo`03Ool00`00Oomoo`0ROol00`00Oomoo`1T
Ool00`00Oomoo`0EOol00g`0Ool07`0FOol00`00Oomoo`1VOol0079oo`<000Eoo`03001oogoo02=o
o`03001oogoo06=oo`03001oogoo01Eoo`03O01oo`0O01Moo`03001oogoo06Eoo`00M7oo00<007oo
Ool00Woo00<007ooOol09Goo00<007ooOol06Goo00<07gooOol0AWoo00<007ooOol05Goo00=l07oo
01l067oo00<007ooOol0I7oo001iOol2000WOol00`00Oomoo`0FOol201lWOolB01l@Ool00`00Oomo
o`0EOol017`0Oomoo`0O5goo00<007ooOol0I7oo001iOol00`00Oomoo`0WOol2000EOol00`0OOomo
o`0DOol701l6O00601lROol00`00Oomoo`0EOol017`0Oomoo`0O5goo0P00IGoo001iOol00`00Oomo
o`0YOol00`00Oomoo`0AOol00`0OOomoo`0;Ool<O00;Ool:O00NOol00`00Oomoo`0EOol017`0Oomo
o`0O57oo0`0000=oo`00Ool0I7oo001iOol00`00Oomoo`0ZOol00`00Oomoo`0>Ool201l7Ool7O00Q
Ool6O00HOol00`00Oomoo`0EOol01G`0Oomoogoo01l047oo0`0017oo00<007ooOol0Hgoo001iOol0
0`00Oomoo`0[Ool00`00Oomoo`0<Ool00`0OOomoo`04Ool3O00^Ool5O00COol00`00Oomoo`0EOol0
1G`0Oomoogoo01l037oo10001goo00<007ooOol0Hgoo001hOol00`00Oomoo`0]Ool00`00Oomoo`0:
Ool0100OOomoogoo17`0=Woo0g`047oo00<007ooOol05Goo00El07ooOomoo`0O00Uoo`<000aoo`03
001oogoo069oo`00N7oo0P00;goo00<007ooOol01goo0P0O0Woo0W`0?Goo0W`03goo00<007ooOol0
57oo00El07ooOomoo`0O00Ioo`<000moo`03001oogoo069oo`00N7oo00<007ooOol0;goo00<007oo
Ool01Goo00<07gooOol00W`0@Goo0g`037oo00<007ooOol04goo00=l07ooOol00goo00<07gooOol0
0`004Woo00<007ooOol0HWoo001hOol00`00Oomoo`0`Ool00`00Oomoo`03Ool0100OOoml07`0AWoo
0g`02Goo00<007ooOol04goo00=l07ooOol00goo00<07`0000005Goo00<007ooOol0HWoo001hOol0
0`00Oomoo`0aOol00`00Oomoo`0201l2O01;Ool3O006Ool00`00Oomoo`0COol00g`0Oomoo`03000H
Ool00`00Oomoo`1ROol007Qoo`03001oogoo039oo`0400007g`0O01@Ool2O0001@0OOomoogoo0000
57oo00@007`0000001]oo`03001oogoo069oo`00Mgoo0P00=7oo00<07g`0Ool0Dgoo0g`000=oo`00
Ool047oo0`0000=l07ooOol077oo00<007ooOol0HWoo001gOol00`00Oomoo`0aOol201l2Ool00`00
Oomoo`1DOol00g`0001oo`0=Ool30003Ool00g`0Oomoo`0MOol00`00Oomoo`1QOol007Moo`03001o
ogoo02moo`03O0007goo00Aoo`03001oogoo05Aoo`04001l07`001l8Ool30006Ool00g`0Oomoo`0M
Ool00`00Oomoo`1QOol007Moo`03001oogoo02ioo`03O01oogoo00Ioo`03001oogoo059oo`80009o
o`03O0007`0O00=oo`<000Qoo`03O01oogoo01ioo`03001oogoo065oo`00Mgoo00<007ooOol0;Goo
00=l07ooOol027oo00<007ooOol0CWoo0`000Woo00<007ooOol00W`00P0O00<007ooOol02Goo00=l
07ooOol07Woo00<007ooOol0HGoo001gOol2000]Ool00g`0Oomoo`0:Ool00`00Oomoo`1:Ool30006
Ool4000017`0Ool07`0O2Goo00=l07ooOol07goo00<007ooOol0HGoo001MOol5000;Ool50005Ool0
0`00Oomoo`0/Ool00g`0Oomoo`0;Ool00`00Oomoo`16Ool30006Ool40004Ool2O00017oo01l07`0O
1Woo00=l07ooOol07goo00<007ooOol0HGoo001MOol01@00Oomoogoo00002goo00D007ooOomoo`00
00Aoo`03001oogoo02=oo`0301moogoo00Ioo`03O01oogoo00eoo`03001oogoo049oo`<000Ioo`<0
00Aoo`03001oogoo00=oo`04O01oogooOol201l3Ool00g`0Oomoo`0POol00`00Oomoo`1QOol005io
o`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo02=oo`0301moogoo00Eoo`03O01oogoo00mo
o`03001oogoo03eoo`@000Ioo`<000Qoo`03001oogoo00=oo`03O01oogoo009oo`807`03Ooml000O
025oo`03001oogoo065oo`00Ggoo00<007ooOol03Goo00<007ooOol017oo00<007ooOol097oo00<0
7gooOol00goo00=l07ooOol04Goo00<007ooOol0>Goo0`001goo0`0037oo00<007ooOol00goo00=l
07ooOol00goo0`0O8Woo00<007ooOol0H7oo001MOol01000Oomoo`003goo00<007ooOol00goo00<0
07ooOol097oo00<07gooOol00goo00=l07ooOol04Woo00<007ooOol0=Goo0`001goo0`0047oo00<0
07ooOol00goo0W`00goo00=l000OOol00P0O87oo00<007ooOol0H7oo001MOol5000?Ool00`00Oomo
o`02Ool2000UOol00`0OOomoo`02Ool00g`0Oomoo`0DOol00`00Oomoo`0aOol30006Ool4000COol0
0`00Oomoo`05Ool017`0Ooml000O17oo0P0O7Woo00<007ooOol0H7oo001]Ool01@00Oomoogoo0000
17oo00<007ooOol09Goo00D07gooOomoog`001Moo`03001oogoo02eoo`<000Ioo`<001Qoo`03001o
ogoo00Eoo`9l000301moogoo00Aoo`807aaoo`03001oogoo061oo`00KWoo0`0017oo00<007ooOol0
9Woo00@07gooOoml01Uoo`03001oogoo02Uoo`<000Ioo`<001aoo`03001oogoo00Aoo`9l02Eoo`03
001oogoo061oo`00MGoo00<007ooOol09Woo00@07gooOoml01Yoo`03001oogoo02Eoo`<000Ioo`<0
021oo`03001oogoo00=oo`03O0007g`002Aoo`03001oogoo061oo`00MGoo00<007ooOol09goo00<0
7gooO0006goo00<007ooOol08Goo0`001Woo0`008goo00<007ooOol00Woo00El000OOomoog`002=o
o`03001oogoo061oo`00MGoo0P00:7oo00<07gooO00077oo00<007ooOol07Goo0`001Woo0`009goo
00H007ooOomoog`001l3Ool00g`0Oomoo`0QOol00`00Oomoo`1OOol007Eoo`03001oogoo02Moo`03
01ml07oo01eoo`03001oogoo01Uoo`<000Eoo`@002]oo`04001oog`001l4Ool00g`0Oomoo`0QOol0
0`00Oomoo`1OOol007Eoo`03001oogoo02Moo`0301ml07oo01ioo`03001oogoo01Aoo`@000Eoo`<0
031oo`03001l000O00Eoo`03O01oogoo021oo`03001oogoo05moo`00M7oo00<007ooOol0:Goo00=l
07ooOol07Woo00<007ooOol047oo0`001Woo0`00<goo00=l0000Ool01Woo00=l07ooOol07goo00<0
07ooOol0Ggoo001dOol00`00Oomoo`0YOol00`0OOomoo`0OOol00`00Oomoo`0<Ool30006Ool3000e
Ool00g`0Ool00008Ool00g`0Oomoo`0NOol00`00Oomoo`1OOol007Aoo`03001oogoo02Uoo`0301mo
ogoo01Yoo`0301moogoo00=oo`03001oogoo00Qoo`<000Ioo`<001Aoo`X07aQoo`9l0004Ool07goo
0008Ool00g`0Oomoo`0MOol00`00Oomoo`1OOol007Aoo`8002]oo`0301moogoo01Moo`807`Moo`03
001oogoo00Aoo`<000Ioo`<000Eooa807b5oo`05O01oogooOol07`02Ool00`00Oomoo`05Ool00g`0
Oomoo`0MOol00`00Oomoo`1OOol007Aoo`03001oogoo02Yoo`0301moogoo01Ioo`0301moogoo00Qo
o`03001oogoo00<000Eoo`8000H07`Ml02moo`05O01oogooOol07`04Ool00`00Oomoo`05Ool00g`0
Oomoo`0MOol00`00Oomoo`1NOol007Aoo`03001oogoo02Yoo`03O01oogoo01Aoo`807`]oo`<00003
Ooml07`000Ml00eoo`al029oo`03O01oogoo009oo`0301moogoo00=oo`03001oogoo00Aoo`03O000
7goo01eoo`03001oogoo05ioo`00Lgoo00<007ooOol0;7oo00=l07ooOol04Woo00<07gooOol027oo
0`0017`000Aoo`00000001ioo`Ql01Uoo`03O01oogoo009oo`0301moogoo00Aoo`03001oogoo00Eo
o`03O01oogoo01aoo`03001oogoo05ioo`00Lgoo00<007ooOol0;7oo00=l07ooOol047oo0P0O27oo
0`0000=l07ooOol00goo0P00:Goo0g`05Goo00=l07ooOol00goo00<07gooOol01Goo00<007ooOol0
17oo00=l000OOol077oo00<007ooOol0GWoo001cOol2000^Ool00g`0Oomoo`0>Ool00`0OOomoo`04
Ool017`0000000002Goo00<007ooOol0:goo17`03goo0W`01Goo00<07gooOol01goo00<007ooOol0
17oo00=l07ooOol06goo00<007ooOol0GWoo001cOol00`00Oomoo`0]Ool00g`0Oomoo`0<Ool201l3
Ool00g`000000002000<Ool00`00Oomoo`0_Ool3O00;Ool00g`0Oomoo`05Ool00`0OOomoo`08Ool0
0`00Oomoo`03Ool00g`001moo`0KOol00`00Oomoo`1NOol007=oo`03001oogoo02ioo`03O01oogoo
00Yoo`0401moogooO003000@Ool00`00Oomoo`0bOol3O007Ool00g`0Oomoo`05Ool00`0OOomoo`0:
Ool00`00Oomoo`02Ool00g`001moo`0KOol00`00Oomoo`1NOol007=oo`03001oogoo02moo`03O01o
ogoo00Moo`807`04O0000000000COol00`00Oomoo`0eOol3O003Ool00g`0Oomoo`06Ool00`0OOomo
o`0:Ool00`00Oomoo`02Ool00g`0Ool07`0LOol00`00Oomoo`1MOol0079oo`03001oogoo035oo`03
O01oogoo00Eoo`04O0000000000FOol00`00Oomoo`0hOol2O00201lFOol00`00Oomoo`02Ool00g`0
01moo`0KOol00`00Oomoo`1MOol0079oo`03001oogoo02Uoo`807`Ioo`03O01oogoo00=oo`<001Uo
o`03001oogoo03Qoo`03O01oog`0009l000301moogoo01=oo`06001oogooOoml000O77oo00<007oo
Ool0GGoo001bOol3000[Ool301l4Ool00g`0Ool00002000LOol00`00Oomoo`0fOol2O005Ool2O002
01lCOol01P00Oomoog`0Ool07a]oo`03001oogoo05eoo`00JGoo0`001Woo00<007ooOol0;Woo0P0O
00Aoo`00000000807aeoo`03001oogoo03Aoo`9l00Uoo`9l00<07a1oo`06001oogooO01oo`0O6goo
00<007ooOol0GGoo001XOol01@00Oomoogoo00001Goo00<007ooOol0;Woo0`000`0O0W`07Goo00<0
07ooOol0<Woo0W`03Goo0W`000=oo`0O01l03goo00<007ooO0000Woo00<07gooOol067oo00<007oo
Ool0GGoo001/Ool00`00Oomoo`03Ool00`00Oomoo`0[Ool30003Ool2O00301l2O00KOol00`00Oomo
o`0`Ool2O00AOol2O00017oo01l07`0O3Goo00D007`0Oomoo`0O01Yoo`03001oogoo05eoo`00K7oo
00<007ooOol00Woo00<007ooOol0:7oo10001Goo00=l07ooOol00goo0P0O0W`06Goo00<007ooOol0
;Woo0W`05Goo0W`00Woo0P0O37oo00D007ooOomoo`0O01Yoo`03001oogoo05aoo`00JWoo0P001Goo
00<007ooOol09Goo0`0027oo00=l07ooOol01goo0P0O00=l07ooOol05Goo00<007ooOol0;7oo0W`0
6Goo00Al07ooOomoo`<07`Uoo`05O00007ooOol07`0JOol00`00Oomoo`1LOol006aoo`03001oogoo
009oo`8002=oo`<000Yoo`03O01oogoo00Yoo`<07aEoo`03001oogoo02Uoo`=l01aoo`9l00Aoo`80
7`Moo`05O00007ooOol07`0JOol00`00Oomoo`1LOol006Qoo`05001oogooOol00004Ool00`00Oomo
o`0OOol30003Ool00`0OOomoo`06Ool00g`0Oomoo`0>Ool201lCOol00`00Oomoo`0VOol3O0000`0O
Oomoo`0NOol00g`0Oomoo`03Ool301l4Ool00g`0Ool00002Ool00`0OOomoo`0GOol00`00Oomoo`1L
Ool006Uoo`<000Eoo`03001oogoo01aoo`<000Ioo`0301moogoo00Eoo`03O01oogoo015oo`9l011o
o`03001oogoo02Aoo`=l0003Ool07`0O029oo`9l00Ioo`<07`07Ooml07ooOol007oo01l06Goo00<0
07ooOol0G7oo001aOol00`00Oomoo`0IOol30009Ool00`0OOomoo`04Ool00g`0Oomoo`0DOol4O00<
Ool00`00Oomoo`0POol4O002Ool201lVOol2O007Ool201l3Ool00`00Ool07`0HOol00`00Oomoo`1L
Ool0071oo`03001oogoo01Moo`<000eoo`0301moogoo00=oo`03O01oogoo01Qoo`El00Moo`03001o
ogoo01]oo`El00Aoo`807bYoo`03O01oogoo00Aoo`04O01oo`0O01l2Ool00`0001moo`0GOol00`00
Oomoo`1LOol0071oo`03001oogoo01Aoo`<0011oo`0301moogoo009oo`03O01oogoo01ioo`Al00=o
o`03001oogoo01Aoo`Ml00Moo`807beoo`03O01oogoo00=oo`03O01oogoo00=oo`03001oo`0O01Mo
o`03001oogoo05aoo`00L7oo0P004Woo0`004goo00<07gooOol00Woo00=l07ooOol08Woo5G`000<0
7g`0O0000W`037oo0P0O<7oo00=l07ooOol00Woo00=l07ooOol017oo00<0000OOol05goo00<007oo
Ool0Fgoo001`Ool00`00Oomoo`0>Ool3000FOol01@0OOomoogooO0009Goo3P0O5Woo0P0O<goo00El
07ooOomoog`000Moo`03001oogoo01Ioo`03001oogoo05]oo`00L7oo00<007ooOol02Woo10006Woo
00@07gooOoml01eoo`P07`=oo`03001oogoo01eoo`0301moogoo03=oo`04O01oogooO009Ool00`00
Oomoo`0EOol00`00Oomoo`1KOol0071oo`03001oogoo00Moo`<001ioo`0401moogooO00XOol00`00
Oomoo`1DOol00g`0Ooml000:Ool00`00Oomoo`0DOol00`00Oomoo`1KOol006moo`03001oogoo00Eo
o`<0025oo`0401moogooO00XOol00`00Oomoo`1EOol00g`0Oomoo`09Ool00`00Oomoo`0DOol00`00
Oomoo`1KOol006moo`03001oogoo009oo`<002Aoo`0301moog`002Uoo`03001oogoo05Eoo`9l00]o
o`03001oogoo01=oo`03001oogoo05]oo`00Kgoo1@00:7oo00<07g`0Ool0:7oo00<007ooOol0E7oo
00=l07ooOol037oo00<007ooOol04Woo00<007ooOol0Fgoo001_Ool2000[Ool00`0OO01oo`0XOol0
0`00Oomoo`1DOol00g`0Oomoo`0=Ool00`00Oomoo`0BOol00`00Oomoo`1JOol0071oo`8002Yoo`03
01ml07oo02Qoo`03001oogoo05=oo`03O01oogoo00moo`03001oogoo015oo`03001oogoo05Yoo`00
LWoo0P00:7oo00<07g`0Ool0:7oo00<007ooOol0DWoo00<07g`0Ool047oo00<007ooOol04Goo00<0
07ooOol0FWoo001bOol2000YOol00`0OOomoo`0WOol00`00Oomoo`1BOol00g`0Oomoo`0AOol00`00
Oomoo`0@Ool00`00Oomoo`1JOol007Aoo`800003Ool007oo02Aoo`0301ml07oo02Moo`03001oogoo
055oo`03O01oogoo01=oo`03001oogoo00moo`03001oogoo05Yoo`00MWoo0P009Goo00<07g`0Ool0
9goo00<007ooOol0D7oo00=l07ooOol05Goo00<007ooOol03Woo00<007ooOol0FWoo001gOol00`00
Oomoo`0TOol00g`0Oomoo`0VOol00`00Oomoo`1?Ool00g`001moo`0FOol00`00Oomoo`0>Ool00`00
Oomoo`1JOol007Qoo`8002Eoo`03O01oogoo02Eoo`03001oogoo04ioo`03O0007goo01Qoo`03001o
ogoo00ioo`03001oogoo05Uoo`00NWoo0P008goo00=l07ooOol09Goo00<007ooOol0CGoo00=l000O
Ool06Woo00<007ooOol03Goo00<007ooOol0FGoo001kOol00`00Oomoo`0ROol00g`0Oomoo`0TOol0
0`00Oomoo`1<Ool00g`0Ool07`0LOol00`00Oomoo`0<Ool00`00Oomoo`1IOol007aoo`80029oo`03
O01oogoo02Aoo`03001oogoo04]oo`03O01oo`0O01ioo`03001oogoo00]oo`03001oogoo05Uoo`00
OWoo00<007ooOol087oo00=l07ooOol08goo00<007ooOol0BGoo0W`000=oo`0OOol07Woo00<007oo
Ool02goo00<007ooOol0FGoo001oOol2000QOol00g`0Oomoo`0ROol00`00Oomoo`18Ool01G`0Oomo
ogoo01l087oo00<007ooOol02Woo00<007ooOol0FGoo0021Ool00`00Oomoo`0FOol201l7Ool00g`0
Oomoo`0QOol00`00Oomoo`17Ool01G`0Oomoogoo01l08Woo00<007ooOol02Goo00<007ooOol0FGoo
001fOol50007Ool00`00Oomoo`0GOol201l6Ool00g`0Oomoo`0POol00`00Oomoo`16Ool01G`0Oomo
ogoo01l097oo00<007ooOol02Goo00<007ooOol0F7oo001fOol01@00Oomoogoo000027oo0P006Goo
0P0O1Goo00=l07ooOol07goo00<007ooOol0A7oo0W`017oo00<07gooOol08goo00<007ooOol027oo
00<007ooOol0F7oo001gOol00`00Oomoo`0:Ool2000JOol301l3Ool00g`0Oomoo`0NOol00`00Oomo
o`12Ool2O005Ool00`0OOomoo`0TOol00`00Oomoo`08Ool00`00Oomoo`1HOol006ioo`H000Aoo`03
001oogoo00]oo`03001oogoo01Yoo`807`9oo`9l01ioo`03001oogoo041oo`9l00Ioo`0301moogoo
02Ioo`03001oogoo00Moo`03001oogoo05Qoo`00NGoo00<007ooOol02goo0P0077oo0`0O00=oog`0
Ool077oo00<007ooOol0?Woo0W`027oo00<07gooOol09goo00<007ooOol01Woo00<007ooOol0F7oo
001jOol00`00Oomoo`0;Ool2000NOol201l2O00JOol00`00Oomoo`0mOol2O009Ool00`0OOomoo`0Y
Ool00`00Oomoo`05Ool00`00Oomoo`1HOol007Ioo`05001oogooOol0000?Ool00`00Ool0000MOol2
01l2O00HOol00`00Oomoo`0kOol2O00hOol00`00Oomoo`04Ool00`00Oomoo`1HOol007Moo`<0015o
o`8001moo`<07`03O01oogoo01Aoo`03001oogoo03Uoo`9l03Yoo`03001oogoo00Aoo`03001oogoo
05Qoo`00S7oo0P008Goo0P0O00=l07ooOol04Woo00<007ooOol0=Woo0g`0?Goo00<007ooOol017oo
00<007ooOol0Egoo002>Ool2000QOol201l2O00AOol00`00Oomoo`0cOol3O011Ool00`00Oomoo`03
Ool00`00Oomoo`1GOol0091oo`03001oogoo029oo`9l00moo`03001oogoo02moo`Al000301moogoo
049oo`03001oogoo009oo`03001oogoo05Moo`00T7oo0P009Goo0g`037oo00<007ooOol0:goo17`0
0P0OAgoo00<007ooOol00Woo00<007ooOol0Egoo002BOol2000VOol4O008Ool00`00Oomoo`0VOol5
O0000goo01l07`1;Ool01@00Oomoogoo0000FGoo002DOol00`00Oomoo`0WOol4O004Ool00`00Oomo
o`0QOol5O003Ool301m>Ool01000Oomoo`00FGoo002EOol00`00Oomoo`0ZOol7O00LOol5O006Ool2
01mBOol00`00Ool0001IOol009Ioo`<0021ooa007`Il00T07`el00Qoo`<07eEoo`03001oo`0005Qo
o`00SGoo1@001Woo00<007ooOol0:goo00<007ooOol08Goo0`0OF7oo00<007oo0000F7oo002?Ool0
0`00Oomoo`07Ool00`00Oomoo`0ZOol00`00Oomoo`0OOol201mLOol2001HOol008moo`03001oogoo
00Qoo`<002Uoo`03001oogoo01eoo`807eeoo`<005Qoo`00Q7oo1P001Goo00<007ooOol02Woo00<0
07ooOol09goo00<007ooOol0N7oo1000Fgoo002?Ool00`00Oomoo`0;Ool200000goo001oo`0TOol0
0`00Oomoo`1dOol4001OOol008moo`03001oogoo00eoo`03001oogoo02Aoo`03001oogoo071oo`@0
06=oo`00SGoo0`003goo0P009Goo00<007ooOol0K7oo1000Igoo002?Ool00`00Oomoo`0?Ool2000S
Ool00`00Oomoo`1WOol5001[Ool00:=oo`03001oogoo021oo`03001oogoo06=oo`@0071oo`00Xgoo
0P008Goo00<007ooOol0Ggoo1000M7oo002UOol3000NOol00`00Oomoo`1KOol4001hOol00:Moo`03
001oogoo01aoo`03001oogoo05Moo`@007aoo`00Z7oo0P0077oo00<007ooOol0DWoo1@00P7oo002Z
Ool00`00Oomoo`0IOol00`00Oomoo`1>Ool40025Ool009eoo`@000Uoo`8001Yoo`03001oogoo04Yo
o`@008Uoo`00W7oo00<007ooOol00Woo00<007ooOol027oo0`005goo00<007ooOol0AWoo1000SGoo
002LOol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0EOol00`00Oomoo`12Ool4002AOol0
09aoo`03001oogoo009oo`03001oogoo00]oo`03001oo`0001Aoo`03001oogoo03ioo`@009Eoo`00
W7oo00<007ooOol00Woo00<007ooOol037oo0P0057oo00<007ooOol0>Goo1@00VGoo002LOol00`00
Oomoo`02Ool00`00Oomoo`0=Ool2000BOol00`00Oomoo`0fOol4002NOol009aoo`03001oogoo009o
o`03001oogoo00moo`80011oo`03001oogoo039oo`@00:9oo`00WGoo10004goo0P003goo00<007oo
Ool0;Woo1000YWoo002fOol00`00Oomoo`0<Ool00`00Oomoo`0ZOol4002ZOol00;Moo`8000aoo`03
001oogoo02Eoo`D00:ioo`00^7oo0P002goo00<007ooOol08Goo1000/goo002jOol20009Ool00`00
Oomoo`0MOol4002gOol00;]oo`8000Qoo`03001oogoo01Uoo`@00;]oo`00[goo1@002Goo0P001Woo
00<007ooOol05Goo1000_goo002aOol00`00Oomoo`0:Ool00`00Oomoo`04Ool00`00Oomoo`0@Ool5
0033Ool009Uoo`<001Eoo`03001oogoo00]oo`<000=oo`03001oogoo00aoo`@00<Qoo`00Vgoo00<0
07ooOol04goo00<007ooOol03Goo00D007ooOomoo`0000Yoo`@00<aoo`00Vgoo00<007ooOol04goo
00<007ooOol03Goo0P000Woo00<007ooOol017oo1000d7oo002JOol00`00Ool0000DOol00`00Oomo
o`0?Ool30002Ool4003DOol009Yoo`03001oo`00019oo`<0019oo`@00=Qoo`00VGoo00D007ooOomo
o`0001=oo`03001oogoo0>aoo`00VGoo00D007ooOomoo`000?moo`=oo`00V7oo0`0000Aoo`000000
0?moo`9oo`00ogooXGoo003oOonQOol00;ioo`D00=eoo`00_Woo00D007ooOomoo`000=eoo`00_goo
00<007ooOol0gWoo0030Ool00`00Oomoo`3MOol00<5oo`03001oogoo0=aoo`00`Woo00<007ooOol0
fgoo002nOol01@00Oomoogoo0000gGoo002oOol3003NOol00001\
\>"],
  ImageRangeCache->{{{0, 415.625}, {237.813, 0}} -> {-0.457407, -0.04002, \
0.00532195, 0.00532195}}]
}, Open  ]],

Cell[TextData[{
  "We observe that the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " of our spiral assigns a tangent vector to each point ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ". The vector field itself varies smoothly from point to point. In \
Cartesian coordinates, the vector field of our spiral is given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"spiral", "tangent vector", "Cartesian coordinates"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(v\&\[RightVector]\), " ", "=", " ", 
        RowBox[{
          RowBox[{"(", GridBox[{
                {\(-y\)},
                {"x"},
                {\(1\/\(2  z\)\)}
                }], ")"}], "."}]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "This representation is based on the basis vectors of  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". In symmetry analysis of differential equations, it is convenient to \
replace the Cartesian basis by a representation using the partial \
differentiations with respect to the Cartesian coordinates. The partial \
derivatives with respect to the coordinates can be interpreted as \
placeholders for the Cartesian basis. Thus, we define a vector field as a \
differential operator in local coordinates as follows."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "partial differentiation", "partial derivatives", "Cartesian basis", 
    "differential operator in local coordinates"}],

Cell["Definition: Vector field", "Definition",
  CellTags->"Definition: Vector Field"],

Cell[TextData[{
  "A vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " on a manifold \[GothicCapitalM] is a tangent vector ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  " to each point ",
  Cell[BoxData[
      \(TraditionalForm\`x\  \[Element] \ \[GothicCapitalM]\)]],
  "  varying smoothly from point to point. In local coordinates, a vector \
field has the representation"
}], "Text",
  Evaluatable->False,
  CellTags->{"manifold", "local coordinates"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(v\&\[RightVector]\_x\  = \ 
      \(\[Xi]\^1\) \[PartialD]\/\[PartialD]x\^1\  + \ 
        \[Xi]\^2\ \[PartialD]\/\[PartialD]x\^2\  + \ \[CenterEllipsis]\  + \ 
        \(\[Xi]\^m\) \[PartialD]\/\[PartialD]x\^m, \)\)], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\^i\)]],
  " are smooth functions of the coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ".\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The related ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " definition is thus given by"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Clear[VectorField]; \n
    VectorField[coef_List, \n\tvars_List] := 
      Block[{F, k}, \n\t\tF = k@@vars; 
        \[Sum]\+\(i = 1\)\%\(Length[coef]\)coef\[LeftDoubleBracket]i
              \[RightDoubleBracket]\ 
            \[PartialD]\_\(vars\[LeftDoubleBracket]i\[RightDoubleBracket]\)F]
        \)], "Input",
  PageWidth->Infinity,
  CellTags->"VectorField[]"],

Cell[TextData[{
  "Application in a three-dimensional manifold \[GothicCapitalM] with \
coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " gives"
}], "Text",
  Evaluatable->False,
  CellTags->"manifold"],

Cell[BoxData[
    \(\(var = {x, y, z}; \)\)], "Input",
  PageWidth->Infinity],

Cell[CellGroupData[{

Cell[BoxData[
    \(coefficients = {v1@@var, v2@@var, v3@@var}\)], "Input"],

Cell[BoxData[
    \({v1[x, y, z], v2[x, y, z], v3[x, y, z]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(VectorField[coefficients, var] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(v1\ k\_x + v2\ k\_y + v3\ k\_z\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The differential operators are represented in our result by derivatives of \
an arbitrary function ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " with respect to the coordinates contained in the variable ",
  StyleBox["var",
    FontSlant->"Italic"],
  ". Let us look at this example from a more physical point of view, which \
was the original view of Lie. Assume that the components of the vector field \
are the components of a velocity field of a laminar fluid flow. Then, at each \
point ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ", the vector ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  " describes the velocity of the fluid particles passing through the point ",
  
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Thus, we are able to describe the velocity field of a fluid by using the \
mathematical term of a vector field."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "velocity field", "laminar fluid flow", "fluid flow", 
    "velocity of a fluid particle"}],

Cell["\<\
Now, let us look at our example of the spiral in a different way. \
Knowing that the vector field describes the velocity field of the fluid, we \
may ask for the stream lines or potential representation of the flow. From a \
physical point of view, the vector field is connected with the flow if we \
consider the laminar behavior. To derive the potential representation of the \
flow of our example, we have to consider the components of the vector field \
as the defining components of the flow of the coordinates. The defining \
equations read\
\>", "Text",
  Evaluatable->False,
  CellTags->{"stream lines", "potential representation", "flow", "laminar"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(flowEquations = 
      Thread[{\[PartialD]\_\[Epsilon] x[\[Epsilon]], 
            \[PartialD]\_\[Epsilon] y[\[Epsilon]], 
            \[PartialD]\_\[Epsilon] z[\[Epsilon]]} == {\(-y[\[Epsilon]]\), 
            x[\[Epsilon]], 1\/\(2\ z[\[Epsilon]]\)}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "\[Prime]",
              MultilineFunction->None], "[", "\[Epsilon]", "]"}], "==", 
          \(-y[\[Epsilon]]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "\[Epsilon]", "]"}], "==", 
          \(x[\[Epsilon]]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["z", "\[Prime]",
              MultilineFunction->None], "[", "\[Epsilon]", "]"}], "==", 
          \(1\/\(2\ z[\[Epsilon]]\)\)}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The right-hand sides of these flow equations are the components of the \
tangent vector or the vector field. The flow has to satisfy that the vector ",
  
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  " at ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  " is reproduced at the origin. The solution of these equations under the \
initial conditions ",
  Cell[BoxData[
      \(TraditionalForm\`x(0) = x\_0\)], "InlineFormula"],
  StyleBox[", ", "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`y(0) = y\_0\)], "InlineFormula"],
  StyleBox[", ", "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`z(0) = z\_0\)], "InlineFormula"],
  " gives us the flow related to the vector field"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "flow equations", "tangent vector", "components of tangent vector", 
    "origin", "initial conditions", "vector field"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(flow = 
      Simplify[\n\t
        DSolve[Join[flowEquations, {x[0] == x0, y[0] == y0, z[0] == z0}], {
            x[\[Epsilon]], y[\[Epsilon]], z[\[Epsilon]]}, \[Epsilon]]]\)], 
  "Input"],

Cell[BoxData[
    \({{z[\[Epsilon]] \[Rule] \(-\@\(z0\^2 + \[Epsilon]\)\), 
        x[\[Epsilon]] \[Rule] x0\ Cos[\[Epsilon]] - y0\ Sin[\[Epsilon]], 
        y[\[Epsilon]] \[Rule] y0\ Cos[\[Epsilon]] + x0\ Sin[\[Epsilon]]}, {
        z[\[Epsilon]] \[Rule] \@\(z0\^2 + \[Epsilon]\), 
        x[\[Epsilon]] \[Rule] x0\ Cos[\[Epsilon]] - y0\ Sin[\[Epsilon]], 
        y[\[Epsilon]] \[Rule] y0\ Cos[\[Epsilon]] + x0\ Sin[\[Epsilon]]}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result shows that the flow of our vector field is given by a rotation \
in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  "-plane and a special translation along the ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " direction. This flow describes the spiral we started from in a different \
representation. We must remember that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[
                RowBox[{
                  FormBox[\((x\_0\),
                    "TraditionalForm"], ",", \(y\_0\)}],
                "TraditionalForm"], ",", \(z\_0\)}],
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " is an arbitrary position of the three-dimensional space. This initial \
vector is transformed to another position if we change the parameter \
\[Epsilon]. This transformation acts like the flow in a fluid. Generalizing \
this example, we can define a flow of a vector field by the following:"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "rotation", "translation", "transformation", "flow of a vector field"}],

Cell["Definition: Flow of a vector field", "Definition"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " is a vector field, we call the integral curve passing through a point ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  " in the manifold \[GothicCapitalM] the flow ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalPhi]", "(", 
          RowBox[{
            FormBox[\(x\&\[RightVector]\),
              "TraditionalForm"], ",", "t"}], ")"}], TraditionalForm]]],
  " generated by ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  ".\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False,
  CellTags->{"integral curve", "manifold"}],

Cell["The flow of a vector field has the properties", "Text",
  Evaluatable->False,
  CellTags->"properties of a flow"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[CapitalPhi]", "(", 
        RowBox[{"\[CapitalPhi]", "(", 
          RowBox[{
            
            FormBox[\(\(\(x\&\[RightVector], \[Epsilon])\), \[Delta])\)\  = \ 
                \[CapitalPhi](x\&\[RightVector], \[Epsilon] + \[Delta]), 
              \ \ \ \ \ \ \ \ \ \ 
              x\&\[RightVector]\  \[Element] \ \[GothicCapitalM]\),
              "TraditionalForm"], ","}]}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-31"],

Cell[TextData[{
  "meaning that the application of the flow on the same point ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  " of \[GothicCapitalM] at different values of \[Epsilon] results in the \
flow at ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  " at a location of the sum in \[Epsilon] and \[Delta]. Another property the \
flow has to satisfy is the representation of ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  " at the origin of \[Epsilon]; that is, at ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ", we have the identity"
}], "Text",
  Evaluatable->False,
  CellTags->{"property of flow", "identity"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[CapitalPhi]", "(", 
          RowBox[{
            FormBox[\(x\&\[RightVector]\),
              "TraditionalForm"], ",", "0"}], ")"}], " ", "=", " ", 
        FormBox[\(x\&\[RightVector] . \),
          "TraditionalForm"]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-32"],

Cell[TextData[{
  "Equation (3.54) describes the identity of the flow for a vanishing \
parameter \[Epsilon] reproducing the original vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  ". Comparing the two properties with the features discussed in C",
  ButtonBox["hapter 1",
    ButtonData:>{"Group.nb", "Groups"},
    ButtonStyle->"Hyperlink"],
  " on groups, we see that the flow generated by a vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " has some characteristics in common with groups. The derivation of the \
flow or the one-parameter group generated by a given vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " is known as exponentiation of the vector field and represented by the \
notation"
}], "Text",
  Evaluatable->False,
  CellTags->{"group", "exponentiation", "exponentiation of vector field"}],

Cell[BoxData[
    \(TraditionalForm
    \`e\^\(\[Epsilon]  v\&\[RightVector]\)\  = \ 
      \(\[CapitalPhi](x\&\[RightVector], \[Epsilon]) . \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-33"],

Cell[TextData[{
  "In the following, we will denote the flow by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalPhi]", "(", 
          RowBox[{
            FormBox[\(x\&\[RightVector]\),
              "TraditionalForm"], ",", "\[Epsilon]"}], ")"}], 
        TraditionalForm]]],
  ". As already discussed, the flow is a result from the solution of a system \
of ordinary differential equations related to the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  ". The vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " is the generator; precisely, the infinitesimal generator of the \
transformation. Expanding the flow around ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(x\&\[RightVector]\),
            "TraditionalForm"], "=", "0"}], TraditionalForm]]],
  ", we find the infinitesimal representation"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "infinitesimal generator", "infinitesimal generator of the transformation", 
    "infinitesimal representation"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[CapitalPhi]", 
          RowBox[{"(", 
            RowBox[{
              FormBox[\(x\&\[RightVector]\),
                "TraditionalForm"], ",", "\[Epsilon]"}], ")"}]}], " ", "=", 
        " ", 
        RowBox[{
          FormBox[\(x\&\[RightVector]\),
            "TraditionalForm"], " ", "+", " ", 
          RowBox[{"\[Epsilon]", " ", 
            FormBox[\(\[Xi]\&\[RightVector]\),
              "TraditionalForm"], 
            RowBox[{"(", 
              FormBox[\(x\&\[RightVector]\),
                "TraditionalForm"], ")"}]}], " ", "+", " ", 
          FormBox[\(O(\[Epsilon]\^2), \),
            "TraditionalForm"]}]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-34"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[
                RowBox[{
                  FormBox[
                    RowBox[{
                      FormBox[\(\[Xi]\&\[RightVector]\),
                        "TraditionalForm"], "=", \((\[Xi]\_1\)}],
                    "TraditionalForm"], ",", \(\[Xi]\_2\)}],
                "TraditionalForm"], ",", "\[Ellipsis]", ",", \(\[Xi]\_n\)}],
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " are the expansion coefficients of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  ". The related determining equations of the flow also known as \
characteristic equations are given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"characteristic equations", "determining equations"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{
              StyleBox[\(dx\_i\),
                FontSlant->"Italic"], "(", "\[Epsilon]", ")"}], 
            StyleBox[
              RowBox[{
                StyleBox["d",
                  FontSlant->"Italic"], "\[Epsilon]"}]]], " ", "=", " ", 
          \(\(\[Xi]\_i\)(\(x\&\[RightVector]\)(\[Epsilon]))\)}], ",", "   ", 
        \(i = 1\), ",", "2", ",", "\[Ellipsis]", ",", "n"}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-35"],

Cell[TextData[{
  "with the initial condition ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(x\&\[RightVector]\),
              "TraditionalForm"], \((\[Epsilon] = 0)\)}], "=", 
          FormBox[\(x\&\[RightVector]\),
            "TraditionalForm"]}], TraditionalForm]]],
  ". Above, we discussed the spiral as an example in three dimensions \
\[GothicCapitalM]=",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". Several other examples will demonstrate the application of the \
theoretical considerations connecting the flow and the vector field on a \
manifold."
}], "Text",
  Evaluatable->False,
  CellTags->{"initial condition", "vector field", "manifold"}],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Another example describing a one-dimensional translation in \
\[GothicCapitalM]=\[DoubleStruckCapitalR] is given by the vector field ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"], "=", " ", 
          FormBox[\(\[PartialD]\_x\),
            "TraditionalForm"]}], TraditionalForm]]],
  ". The corresponding characteristic equation for the coordinate ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " reads"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "translation", "one-dimensinal translation", "characteristic equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(onedim = \[PartialD]\_\[Epsilon] x[\[Epsilon]] == 1\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["x", "\[Prime]",
          MultilineFunction->None], "[", "\[Epsilon]", "]"}], "==", "1"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "This equation was created by applying equation ",
  ButtonBox["(3.57)",
    ButtonData:>"eq-35",
    ButtonStyle->"Hyperlink"],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1 = 1. \)]],
  " The solution of this simple first-order ODE under the initial condition ",
  
  Cell[BoxData[
      \(TraditionalForm\`x(\[Epsilon]\  = \ 0) = x\)]],
  " representing the identity ",
  ButtonBox["(3.54)",
    ButtonData:>"eq-32",
    ButtonStyle->"Hyperlink"],
  " is"
}], "Text",
  Evaluatable->False,
  CellTags->{"first-order ODE", "ODE of first-order"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(flowOnedim = 
      DSolve[{onedim, x[0] == x0}, x[\[Epsilon]], \[Epsilon]] /. 
        x0 \[Rule] x\)], "Input"],

Cell[BoxData[
    \({{x[\[Epsilon]] \[Rule] x + \[Epsilon]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is just a translation of the coordinate. We define the flow \
\[CapitalPhi] in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by the relation"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\[CapitalPhi][x_, \[Epsilon]_] := x + \[Epsilon]\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "Using this representation of the flow, we can check the properties ",
  ButtonBox["(3.53)",
    ButtonData:>"eq-31",
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["(3.54)",
    ButtonData:>"eq-32",
    ButtonStyle->"Hyperlink"],
  ". The combination of two translations \[Epsilon] and \[Delta] satisfy the \
condition"
}], "Text",
  Evaluatable->False,
  CellTags->{"flow", "translation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi][\[CapitalPhi][x, \[Epsilon]], \[Delta]] == 
      \[CapitalPhi][x, \[Epsilon] + \[Delta]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "representing the closure relation of the group of translations. The second \
property ",
  ButtonBox["(3.54),",
    ButtonData:>"eq-32",
    ButtonStyle->"Hyperlink"],
  " the identity of the group, gives"
}], "Text",
  Evaluatable->False,
  CellTags->{"group of translation", "identity of group"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi][x, 0] == x\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["\<\
Knowing the identity of the group, we are able to construct the \
inverse element of the group. The inverse element of the associated group \
follows from the relation\
\>", "Text",
  Evaluatable->False,
  CellTags->{"inverse element", "inverse element of group"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x == 
      \[CapitalPhi][InverseFunction[\[CapitalPhi][x, \[Epsilon]]], \[Epsilon]]
        \n == \[CapitalPhi][\[CapitalPhi][x, \(-\[Epsilon]\)], \[Epsilon]]
        \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\[Epsilon] + InverseFunction[x + \[Epsilon]] == x\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\[Epsilon] + InverseFunction[x + \[Epsilon]] == x, 
      InverseFunction[x + \[Epsilon]]]\)], "Input"],

Cell[BoxData[
    \({{InverseFunction[x + \[Epsilon]] \[Rule] x - \[Epsilon]}}\)], "Output"]
}, Open  ]],

Cell[TextData[
"The found solution represents an inverse translation if we assume that \
\[Epsilon] > 0. The associativity of the underlying group follows from"], 
  "Text",
  Evaluatable->False,
  CellTags->{"inverse translation", "associativity"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi][\[CapitalPhi][\[CapitalPhi][x, \[Epsilon]], \[Delta]], 
        \[Omega]] == \n\t
      \[CapitalPhi][\[CapitalPhi][\[CapitalPhi][x, \[Delta]], \[Omega]], 
        \[Epsilon]] == \n\t
      \[CapitalPhi][\[CapitalPhi][\[CapitalPhi][x, \[Omega]], \[Epsilon]], 
        \[Delta]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "We demonstrated for the vector field ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"], 
          FormBox[\( = \[PartialD]\_x\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", generating a translation in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", that the corresponding flow possesses all properties of a group. The \
symmetry of translation is one of those symmetries frequently encountered in  \
symmetry analysis.\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "properties of a group", "symmetry of translation", "symmetries"}],

Cell["Example 2", "Example"],

Cell[TextData[{
  "Another one-dimensional example in \[GothicCapitalM] = \
\[DoubleStruckCapitalR] also possessing the group properties is given by the \
vector field ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"], "=", 
          RowBox[{"x", 
            FormBox[\(\[PartialD]\_x\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". From equation ",
  ButtonBox["(3.57),",
    ButtonData:>"eq-35",
    ButtonStyle->"Hyperlink"],
  " the corresponding characteristic equation is"
}], "Text",
  Evaluatable->False,
  CellTags->"characteristic equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(scale = \[PartialD]\_\[Epsilon] x[\[Epsilon]] == x[\[Epsilon]]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["x", "\[Prime]",
          MultilineFunction->None], "[", "\[Epsilon]", "]"}], "==", 
      \(x[\[Epsilon]]\)}]], "Output"]
}, Open  ]],

Cell["This equation allows the solution", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(flowScale = 
      DSolve[{scale, x[0] == x0}, x[\[Epsilon]], \[Epsilon]] /. 
        x0 \[Rule] x\)], "Input"],

Cell[BoxData[
    \({{x[\[Epsilon]] \[Rule] E\^\[Epsilon]\ x}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result defines a scaling transformation of the variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". We consider the factor ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\[Epsilon]\)]],
  " as a constant greater than or less than 1 depending on the sign of \
\[Epsilon]. For positive \[Epsilon], the original value of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is enlarged, and for negative values of \[Epsilon], ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is reduced in its value. We can check the two basic properties of the \
closure and the identity of the group by defining the flow as"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "scaling transformation", "closure", "identity", "closure of group", 
    "identity of group", "flow"}],

Cell[BoxData[
    \(\[CapitalPhi][x_, \[Epsilon]_] := x\ Exp[\[Epsilon]]\)], "Input",
  PageWidth->Infinity],

Cell["The closure of the scaling group now reads", "Text",
  CellTags->"scaling group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi][\[CapitalPhi][x, \[Epsilon]], \[Delta]] == 
      \[CapitalPhi][x, \[Epsilon] + \[Delta]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["and the identity is given by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi][x, 0] == x\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[TextData[
"The two relations demonstrate that the transformation group of scaling is \
closed and contains the identity transformation.\[ThickSpace]\[EmptySquare]"],
   "Text",
  Evaluatable->False,
  CellTags->"identity transformation"],

Cell["Example 3", "Example"],

Cell["\<\
In this example, we will reverse our calculations. Knowing the \
flow, we will derive the related vector field. A global transformation \
commonly encountered in physics and mathematics is a rotation. To simplify \
things, let us consider the rotation of an object in the plane. The \
corresponding flow of this transformation is given by\
\>", "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "global transformation", "rotation", "transformation"}],

Cell[BoxData[
    \(\[CapitalPhi][x_, y_, \[Epsilon]_] := {
        x\ Cos[\[Epsilon]] - y\ Sin[\[Epsilon]], 
        x\ Sin[\[Epsilon]] + y\ Cos[\[Epsilon]]}\)], "Input"],

Cell[TextData[{
  "Knowing the flow of a group, we are able to calculate the infinitesimal \
representation of the flow by calculating the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  ". According to equations ",
  ButtonBox["(3.55)",
    ButtonData:>"eq-33",
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["(3.56),",
    ButtonData:>"eq-34",
    ButtonStyle->"Hyperlink"],
  " the infinitesimals \[Xi] of the flow define the coefficients of the \
vector field. For the present example, in two dimensions the vector field has \
the representation"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "infinitesimal representation", "flow of a group", "infinitesimals", 
    "coefficients of the vector field"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(v\&\[RightVector]\),
          "TraditionalForm"], " ", "=", " ", 
        RowBox[{
          RowBox[{
            FormBox[\(\[Xi]\_1\),
              "TraditionalForm"], "(", \(x, y\), ")"}], " ", 
          RowBox[{
            FormBox[\(\[PartialD]\_x\),
              "TraditionalForm"], " ", 
            RowBox[{"+", " ", 
              FormBox[\(\[Xi]\_2\),
                "TraditionalForm"]}]}], \((x, y)\), " ", 
          RowBox[{
            FormBox[\(\[PartialD]\_y\),
              "TraditionalForm"], "."}]}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False],

Cell["The infinitesimals are calculated by the relation", "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Xi]", " ", "=", " ", 
        RowBox[{
          FractionBox[
            StyleBox[
              RowBox[{
                StyleBox["d",
                  FontSlant->"Italic"], "\[CapitalPhi]"}]], 
            StyleBox[
              RowBox[{
                StyleBox["d",
                  FontSlant->"Italic"], "\[Epsilon]"}]]], 
          SubscriptBox[
            StyleBox["\[VerticalSeparator]",
              ScriptLevel->2], \(\ \[Epsilon] = 0\)], "."}]}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"eq-37"],

Cell["From the flow for rotations, we get the infinitesimals", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi] = 
      \[PartialD]\_\[Epsilon] \[CapitalPhi][x, y, \[Epsilon]] /. 
        \[Epsilon] \[Rule] 0\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({\(-y\), x}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " of plane rotations has the representation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"], " ", "=", " ", 
          RowBox[{
            RowBox[{\(-y\), " ", 
              FormBox[\(\[PartialD]\_x\),
                "TraditionalForm"]}], "+", " ", 
            RowBox[{"x", " ", 
              FormBox[\(\[PartialD]\_y\),
                "TraditionalForm"]}]}]}], TraditionalForm]]],
  ". Again, we can reverse our considerations and calculate the flow starting \
from the vector field. The flow or the global group transformation follow by \
solving the characteristic equations, which are a system of ordinary \
differential equations."
}], "Text",
  Evaluatable->False,
  CellTags->"vector field"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rotation = {
        \[PartialD]\_\[Epsilon] x[\[Epsilon]] == \(-y[\[Epsilon]]\), 
        \[PartialD]\_\[Epsilon] y[\[Epsilon]] == x[\[Epsilon]]}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "\[Prime]",
              MultilineFunction->None], "[", "\[Epsilon]", "]"}], "==", 
          \(-y[\[Epsilon]]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "\[Epsilon]", "]"}], "==", 
          \(x[\[Epsilon]]\)}]}], "}"}]], "Output"]
}, Open  ]],

Cell["The related flow follows by solving these equations:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(flow = 
      Simplify[\n\t\t\t
          DSolve[Join[rotation, {x[0] == x0, y[0] == y0}], {x[\[Epsilon]], 
              y[\[Epsilon]]}, \[Epsilon]]]\  /. {x0 \[Rule] x, y0 \[Rule] y}
          \)], "Input"],

Cell[BoxData[
    \({{x[\[Epsilon]] \[Rule] x\ Cos[\[Epsilon]] - y\ Sin[\[Epsilon]], 
        y[\[Epsilon]] \[Rule] y\ Cos[\[Epsilon]] + x\ Sin[\[Epsilon]]}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[
"reproducing the relation with which we started.\[ThickSpace]\[EmptySquare]"],
   "Text",
  Evaluatable->False],

Cell["Example 4", "Example"],

Cell["\<\
As a final example, let us consider the global group action of a \
flow containing rational expressions which are related to a projective group:\
\
\>", "Text",
  Evaluatable->False,
  CellTags->{"global group action", "group action", "projective group"}],

Cell[BoxData[
    \(\[CapitalPhi][x_, y_, \[Epsilon]_] := {x\/\(1 + \[Epsilon]\ y\ x\^2\), 
        y\/\(1 - \[Epsilon]\ y\)}\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "Differentiating this expression by using equation ",
  ButtonBox["(3.59)",
    ButtonData:>"eq-37",
    ButtonStyle->"Hyperlink"],
  ", we find the infinitesimals of the flow to be"
}], "Text",
  Evaluatable->False,
  CellTags->{"infinitesimals", "flow"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi] = 
      \[PartialD]\_\[Epsilon] \[CapitalPhi][x, y, \[Epsilon]] /. 
        \[Epsilon] \[Rule] 0\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({\(-x\^3\)\ y, y\^2}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which gives us the vector field in the representation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"], " ", "=", " ", 
          RowBox[{
            RowBox[{
              FormBox[\(-x\^3\),
                "TraditionalForm"], " ", "y", " ", 
              FormBox[\(\[PartialD]\_x\),
                "TraditionalForm"]}], " ", "+", " ", 
            FormBox[
              RowBox[{
                FormBox[\(y\^2\),
                  "TraditionalForm"], \(\[PartialD]\_y\)}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  ".  Knowing the infinitesimals, we are able to graphically represent the \
vector field. A plot of the vector field corresponding to the rational flow \
is given below. The package ",
  StyleBox["Graphics`PlotField`", "MmaText"],
  " is useful for the representation of vector fields."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "package", "Graphics`PlotField", 
    "grapical representation of vector field", 
    "representation of vector field"}],

Cell[BoxData[
    \(<< "\<Graphics`PlotField`\>"\)], "Input",
  PageWidth->Infinity],

Cell[CellGroupData[{

Cell[BoxData[
    \(PlotVectorField[\[Xi], {x, \(-2\), 2}, \n\t{y, \(-2\), 2}, 
      ColorFunction \[Rule] Hue]\)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .89349 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.209114 0.439501 0.209114 [
[ 0 0 0 0 ]
[ 1 .89349 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
0 0 Mdot
grestore
} def
% End of user PostScript
1 0 0 r
.0001 w
.08177 .02127 m
.02381 .03576 L
s
% Start of user PostScript
-2. -2. -2.27718 -1.9307 MAarrowhead1
% End of user PostScript
1 0 .897 r
.08177 .08102 m
.03209 .09167 L
s
% Start of user PostScript
-2. -1.71429 -2.23759 -1.66337 MAarrowhead1
% End of user PostScript
.224 0 1 r
.08177 .14077 m
.04037 .14816 L
s
% Start of user PostScript
-2. -1.42857 -2.19799 -1.39322 MAarrowhead1
% End of user PostScript
0 .64 1 r
.08177 .20051 m
.04865 .20525 L
s
% Start of user PostScript
-2. -1.14286 -2.15839 -1.12023 MAarrowhead1
% End of user PostScript
0 1 .509 r
.08177 .26026 m
.05693 .26292 L
s
% Start of user PostScript
-2. -0.857143 -2.11879 -0.844415 MAarrowhead1
% End of user PostScript
.333 1 0 r
.08177 .32001 m
.06521 .32119 L
s
% Start of user PostScript
-2. -0.571429 -2.0792 -0.565772 MAarrowhead1
% End of user PostScript
1 .832 0 r
.08177 .37975 m
.07349 .38005 L
s
% Start of user PostScript
-2. -0.285714 -2.0396 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.08177 .4395 m
.08177 .4395 L
s
% Start of user PostScript
-2. 0 MAarrowzero1
% End of user PostScript
1 .832 0 r
.08177 .49925 m
.09005 .49954 L
s
% Start of user PostScript
-2. 0.285714 -1.9604 0.287128 MAarrowhead1
% End of user PostScript
.333 1 0 r
.08177 .55899 m
.09833 .56018 L
s
% Start of user PostScript
-2. 0.571429 -1.9208 0.577085 MAarrowhead1
% End of user PostScript
0 1 .509 r
.08177 .61874 m
.10661 .6214 L
s
% Start of user PostScript
-2. 0.857143 -1.88121 0.869871 MAarrowhead1
% End of user PostScript
0 .64 1 r
.08177 .67849 m
.11489 .68322 L
s
% Start of user PostScript
-2. 1.14286 -1.84161 1.16548 MAarrowhead1
% End of user PostScript
.224 0 1 r
.08177 .73824 m
.12317 .74563 L
s
% Start of user PostScript
-2. 1.42857 -1.80201 1.46393 MAarrowhead1
% End of user PostScript
1 0 .897 r
.08177 .79798 m
.13145 .80863 L
s
% Start of user PostScript
-2. 1.71429 -1.76241 1.7652 MAarrowhead1
% End of user PostScript
1 0 0 r
.08177 .85773 m
.13974 .87222 L
s
% Start of user PostScript
-2. 2. -1.72282 2.0693 MAarrowhead1
% End of user PostScript
0 .056 1 r
.14152 .02127 m
.10502 .03576 L
s
% Start of user PostScript
-1.71429 -2. -1.88884 -1.9307 MAarrowhead1
% End of user PostScript
0 .681 1 r
.14152 .08102 m
.11023 .09167 L
s
% Start of user PostScript
-1.71429 -1.71429 -1.8639 -1.66337 MAarrowhead1
% End of user PostScript
0 1 .722 r
.14152 .14077 m
.11545 .14816 L
s
% Start of user PostScript
-1.71429 -1.42857 -1.83897 -1.39322 MAarrowhead1
% End of user PostScript
0 1 .148 r
.14152 .20051 m
.12066 .20525 L
s
% Start of user PostScript
-1.71429 -1.14286 -1.81403 -1.12023 MAarrowhead1
% End of user PostScript
.406 1 0 r
.14152 .26026 m
.12588 .26292 L
s
% Start of user PostScript
-1.71429 -0.857143 -1.78909 -0.844415 MAarrowhead1
% End of user PostScript
.946 1 0 r
.14152 .32001 m
.13109 .32119 L
s
% Start of user PostScript
-1.71429 -0.571429 -1.76416 -0.565772 MAarrowhead1
% End of user PostScript
1 .525 0 r
.14152 .37975 m
.1363 .38005 L
s
% Start of user PostScript
-1.71429 -0.285714 -1.73922 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.14152 .4395 m
.14152 .4395 L
s
% Start of user PostScript
-1.71429 0 MAarrowzero1
% End of user PostScript
1 .525 0 r
.14152 .49925 m
.14673 .49954 L
s
% Start of user PostScript
-1.71429 0.285714 -1.68935 0.287128 MAarrowhead1
% End of user PostScript
.946 1 0 r
.14152 .55899 m
.15195 .56018 L
s
% Start of user PostScript
-1.71429 0.571429 -1.66441 0.577085 MAarrowhead1
% End of user PostScript
.406 1 0 r
.14152 .61874 m
.15716 .6214 L
s
% Start of user PostScript
-1.71429 0.857143 -1.63948 0.869871 MAarrowhead1
% End of user PostScript
0 1 .148 r
.14152 .67849 m
.16238 .68322 L
s
% Start of user PostScript
-1.71429 1.14286 -1.61454 1.16548 MAarrowhead1
% End of user PostScript
0 1 .722 r
.14152 .73824 m
.16759 .74563 L
s
% Start of user PostScript
-1.71429 1.42857 -1.58961 1.46393 MAarrowhead1
% End of user PostScript
0 .681 1 r
.14152 .79798 m
.17281 .80863 L
s
% Start of user PostScript
-1.71429 1.71429 -1.56467 1.7652 MAarrowhead1
% End of user PostScript
0 .056 1 r
.14152 .85773 m
.17802 .87222 L
s
% Start of user PostScript
-1.71429 2. -1.53973 2.0693 MAarrowhead1
% End of user PostScript
0 1 .572 r
.20127 .02127 m
.18014 .03576 L
s
% Start of user PostScript
-1.42857 -2. -1.52959 -1.9307 MAarrowhead1
% End of user PostScript
0 1 .109 r
.20127 .08102 m
.18316 .09167 L
s
% Start of user PostScript
-1.42857 -1.71429 -1.51516 -1.66337 MAarrowhead1
% End of user PostScript
.313 1 0 r
.20127 .14077 m
.18618 .14816 L
s
% Start of user PostScript
-1.42857 -1.42857 -1.50072 -1.39322 MAarrowhead1
% End of user PostScript
.698 1 0 r
.20127 .20051 m
.1892 .20525 L
s
% Start of user PostScript
-1.42857 -1.14286 -1.48629 -1.12023 MAarrowhead1
% End of user PostScript
1 .948 0 r
.20127 .26026 m
.19221 .26292 L
s
% Start of user PostScript
-1.42857 -0.857143 -1.47186 -0.844415 MAarrowhead1
% End of user PostScript
1 .618 0 r
.20127 .32001 m
.19523 .32119 L
s
% Start of user PostScript
-1.42857 -0.571429 -1.45743 -0.565772 MAarrowhead1
% End of user PostScript
1 .304 0 r
.20127 .37975 m
.19825 .38005 L
s
% Start of user PostScript
-1.42857 -0.285714 -1.443 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.20127 .4395 m
.20127 .4395 L
s
% Start of user PostScript
-1.42857 0 MAarrowzero1
% End of user PostScript
1 .304 0 r
.20127 .49925 m
.20428 .49954 L
s
% Start of user PostScript
-1.42857 0.285714 -1.41414 0.287128 MAarrowhead1
% End of user PostScript
1 .618 0 r
.20127 .55899 m
.2073 .56018 L
s
% Start of user PostScript
-1.42857 0.571429 -1.39971 0.577085 MAarrowhead1
% End of user PostScript
1 .948 0 r
.20127 .61874 m
.21032 .6214 L
s
% Start of user PostScript
-1.42857 0.857143 -1.38528 0.869871 MAarrowhead1
% End of user PostScript
.698 1 0 r
.20127 .67849 m
.21334 .68322 L
s
% Start of user PostScript
-1.42857 1.14286 -1.37085 1.16548 MAarrowhead1
% End of user PostScript
.313 1 0 r
.20127 .73824 m
.21635 .74563 L
s
% Start of user PostScript
-1.42857 1.42857 -1.35642 1.46393 MAarrowhead1
% End of user PostScript
0 1 .109 r
.20127 .79798 m
.21937 .80863 L
s
% Start of user PostScript
-1.42857 1.71429 -1.34199 1.7652 MAarrowhead1
% End of user PostScript
0 1 .572 r
.20127 .85773 m
.22239 .87222 L
s
% Start of user PostScript
-1.42857 2. -1.32756 2.0693 MAarrowhead1
% End of user PostScript
.184 1 0 r
.26101 .02127 m
.2502 .03576 L
s
% Start of user PostScript
-1.14286 -2. -1.19458 -1.9307 MAarrowhead1
% End of user PostScript
.582 1 0 r
.26101 .08102 m
.25174 .09167 L
s
% Start of user PostScript
-1.14286 -1.71429 -1.18719 -1.66337 MAarrowhead1
% End of user PostScript
.926 1 0 r
.26101 .14077 m
.25329 .14816 L
s
% Start of user PostScript
-1.14286 -1.42857 -1.1798 -1.39322 MAarrowhead1
% End of user PostScript
1 .782 0 r
.26101 .20051 m
.25483 .20525 L
s
% Start of user PostScript
-1.14286 -1.14286 -1.17241 -1.12023 MAarrowhead1
% End of user PostScript
1 .537 0 r
.26101 .26026 m
.25638 .26292 L
s
% Start of user PostScript
-1.14286 -0.857143 -1.16502 -0.844415 MAarrowhead1
% End of user PostScript
1 .332 0 r
.26101 .32001 m
.25792 .32119 L
s
% Start of user PostScript
-1.14286 -0.571429 -1.15763 -0.565772 MAarrowhead1
% End of user PostScript
1 .158 0 r
.26101 .37975 m
.25947 .38005 L
s
% Start of user PostScript
-1.14286 -0.285714 -1.15025 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.26101 .4395 m
.26101 .4395 L
s
% Start of user PostScript
-1.14286 0 MAarrowzero1
% End of user PostScript
1 .158 0 r
.26101 .49925 m
.26256 .49954 L
s
% Start of user PostScript
-1.14286 0.285714 -1.13547 0.287128 MAarrowhead1
% End of user PostScript
1 .332 0 r
.26101 .55899 m
.2641 .56018 L
s
% Start of user PostScript
-1.14286 0.571429 -1.12808 0.577085 MAarrowhead1
% End of user PostScript
1 .537 0 r
.26101 .61874 m
.26565 .6214 L
s
% Start of user PostScript
-1.14286 0.857143 -1.12069 0.869871 MAarrowhead1
% End of user PostScript
1 .782 0 r
.26101 .67849 m
.26719 .68322 L
s
% Start of user PostScript
-1.14286 1.14286 -1.1133 1.16548 MAarrowhead1
% End of user PostScript
.926 1 0 r
.26101 .73824 m
.26874 .74563 L
s
% Start of user PostScript
-1.14286 1.42857 -1.10591 1.46393 MAarrowhead1
% End of user PostScript
.582 1 0 r
.26101 .79798 m
.27028 .80863 L
s
% Start of user PostScript
-1.14286 1.71429 -1.09853 1.7652 MAarrowhead1
% End of user PostScript
.184 1 0 r
.26101 .85773 m
.27183 .87222 L
s
% Start of user PostScript
-1.14286 2. -1.09114 2.0693 MAarrowhead1
% End of user PostScript
.474 1 0 r
.32076 .02127 m
.3162 .03576 L
s
% Start of user PostScript
-0.857143 -2. -0.878962 -1.9307 MAarrowhead1
% End of user PostScript
.861 1 0 r
.32076 .08102 m
.31685 .09167 L
s
% Start of user PostScript
-0.857143 -1.71429 -0.875845 -1.66337 MAarrowhead1
% End of user PostScript
1 .811 0 r
.32076 .14077 m
.3175 .14816 L
s
% Start of user PostScript
-0.857143 -1.42857 -0.872728 -1.39322 MAarrowhead1
% End of user PostScript
1 .543 0 r
.32076 .20051 m
.31815 .20525 L
s
% Start of user PostScript
-0.857143 -1.14286 -0.869611 -1.12023 MAarrowhead1
% End of user PostScript
1 .332 0 r
.32076 .26026 m
.3188 .26292 L
s
% Start of user PostScript
-0.857143 -0.857143 -0.866494 -0.844415 MAarrowhead1
% End of user PostScript
1 .177 0 r
.32076 .32001 m
.31946 .32119 L
s
% Start of user PostScript
-0.857143 -0.571429 -0.863377 -0.565772 MAarrowhead1
% End of user PostScript
1 .072 0 r
.32076 .37975 m
.32011 .38005 L
s
% Start of user PostScript
-0.857143 -0.285714 -0.86026 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.32076 .4395 m
.32076 .4395 L
s
% Start of user PostScript
-0.857143 0 MAarrowzero1
% End of user PostScript
1 .072 0 r
.32076 .49925 m
.32141 .49954 L
s
% Start of user PostScript
-0.857143 0.285714 -0.854026 0.287128 MAarrowhead1
% End of user PostScript
1 .177 0 r
.32076 .55899 m
.32206 .56018 L
s
% Start of user PostScript
-0.857143 0.571429 -0.850909 0.577085 MAarrowhead1
% End of user PostScript
1 .332 0 r
.32076 .61874 m
.32272 .6214 L
s
% Start of user PostScript
-0.857143 0.857143 -0.847792 0.869871 MAarrowhead1
% End of user PostScript
1 .543 0 r
.32076 .67849 m
.32337 .68322 L
s
% Start of user PostScript
-0.857143 1.14286 -0.844675 1.16548 MAarrowhead1
% End of user PostScript
1 .811 0 r
.32076 .73824 m
.32402 .74563 L
s
% Start of user PostScript
-0.857143 1.42857 -0.841558 1.46393 MAarrowhead1
% End of user PostScript
.861 1 0 r
.32076 .79798 m
.32467 .80863 L
s
% Start of user PostScript
-0.857143 1.71429 -0.838441 1.7652 MAarrowhead1
% End of user PostScript
.474 1 0 r
.32076 .85773 m
.32532 .87222 L
s
% Start of user PostScript
-0.857143 2. -0.835324 2.0693 MAarrowhead1
% End of user PostScript
.538 1 0 r
.38051 .02127 m
.37915 .03576 L
s
% Start of user PostScript
-0.571429 -2. -0.577893 -1.9307 MAarrowhead1
% End of user PostScript
.925 1 0 r
.38051 .08102 m
.37935 .09167 L
s
% Start of user PostScript
-0.571429 -1.71429 -0.57697 -1.66337 MAarrowhead1
% End of user PostScript
1 .749 0 r
.38051 .14077 m
.37954 .14816 L
s
% Start of user PostScript
-0.571429 -1.42857 -0.576046 -1.39322 MAarrowhead1
% End of user PostScript
1 .481 0 r
.38051 .20051 m
.37973 .20525 L
s
% Start of user PostScript
-0.571429 -1.14286 -0.575123 -1.12023 MAarrowhead1
% End of user PostScript
1 .274 0 r
.38051 .26026 m
.37993 .26292 L
s
% Start of user PostScript
-0.571429 -0.857143 -0.574199 -0.844415 MAarrowhead1
% End of user PostScript
1 .125 0 r
.38051 .32001 m
.38012 .32119 L
s
% Start of user PostScript
-0.571429 -0.571429 -0.573276 -0.565772 MAarrowhead1
% End of user PostScript
1 .035 0 r
.38051 .37975 m
.38031 .38005 L
s
% Start of user PostScript
-0.571429 -0.285714 -0.572352 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.38051 .4395 m
.38051 .4395 L
s
% Start of user PostScript
-0.571429 0 MAarrowzero1
% End of user PostScript
1 .035 0 r
.38051 .49925 m
.3807 .49954 L
s
% Start of user PostScript
-0.571429 0.285714 -0.570505 0.287128 MAarrowhead1
% End of user PostScript
1 .125 0 r
.38051 .55899 m
.38089 .56018 L
s
% Start of user PostScript
-0.571429 0.571429 -0.569581 0.577085 MAarrowhead1
% End of user PostScript
1 .274 0 r
.38051 .61874 m
.38109 .6214 L
s
% Start of user PostScript
-0.571429 0.857143 -0.568658 0.869871 MAarrowhead1
% End of user PostScript
1 .481 0 r
.38051 .67849 m
.38128 .68322 L
s
% Start of user PostScript
-0.571429 1.14286 -0.567734 1.16548 MAarrowhead1
% End of user PostScript
1 .749 0 r
.38051 .73824 m
.38147 .74563 L
s
% Start of user PostScript
-0.571429 1.42857 -0.566811 1.46393 MAarrowhead1
% End of user PostScript
.925 1 0 r
.38051 .79798 m
.38167 .80863 L
s
% Start of user PostScript
-0.571429 1.71429 -0.565887 1.7652 MAarrowhead1
% End of user PostScript
.538 1 0 r
.38051 .85773 m
.38186 .87222 L
s
% Start of user PostScript
-0.571429 2. -0.564964 2.0693 MAarrowhead1
% End of user PostScript
.545 1 0 r
.44025 .02127 m
.44008 .03576 L
s
% Start of user PostScript
-0.285714 -2. -0.286522 -1.9307 MAarrowhead1
% End of user PostScript
.931 1 0 r
.44025 .08102 m
.44011 .09167 L
s
% Start of user PostScript
-0.285714 -1.71429 -0.286407 -1.66337 MAarrowhead1
% End of user PostScript
1 .743 0 r
.44025 .14077 m
.44013 .14816 L
s
% Start of user PostScript
-0.285714 -1.42857 -0.286292 -1.39322 MAarrowhead1
% End of user PostScript
1 .475 0 r
.44025 .20051 m
.44016 .20525 L
s
% Start of user PostScript
-0.285714 -1.14286 -0.286176 -1.12023 MAarrowhead1
% End of user PostScript
1 .267 0 r
.44025 .26026 m
.44018 .26292 L
s
% Start of user PostScript
-0.285714 -0.857143 -0.286061 -0.844415 MAarrowhead1
% End of user PostScript
1 .119 0 r
.44025 .32001 m
.4402 .32119 L
s
% Start of user PostScript
-0.285714 -0.571429 -0.285945 -0.565772 MAarrowhead1
% End of user PostScript
1 .03 0 r
.44025 .37975 m
.44023 .38005 L
s
% Start of user PostScript
-0.285714 -0.285714 -0.28583 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.44025 .4395 m
.44025 .4395 L
s
% Start of user PostScript
-0.285714 0 MAarrowzero1
% End of user PostScript
1 .03 0 r
.44025 .49925 m
.44028 .49954 L
s
% Start of user PostScript
-0.285714 0.285714 -0.285599 0.287128 MAarrowhead1
% End of user PostScript
1 .119 0 r
.44025 .55899 m
.4403 .56018 L
s
% Start of user PostScript
-0.285714 0.571429 -0.285483 0.577085 MAarrowhead1
% End of user PostScript
1 .267 0 r
.44025 .61874 m
.44033 .6214 L
s
% Start of user PostScript
-0.285714 0.857143 -0.285368 0.869871 MAarrowhead1
% End of user PostScript
1 .475 0 r
.44025 .67849 m
.44035 .68322 L
s
% Start of user PostScript
-0.285714 1.14286 -0.285253 1.16548 MAarrowhead1
% End of user PostScript
1 .743 0 r
.44025 .73824 m
.44037 .74563 L
s
% Start of user PostScript
-0.285714 1.42857 -0.285137 1.46393 MAarrowhead1
% End of user PostScript
.931 1 0 r
.44025 .79798 m
.4404 .80863 L
s
% Start of user PostScript
-0.285714 1.71429 -0.285022 1.7652 MAarrowhead1
% End of user PostScript
.545 1 0 r
.44025 .85773 m
.44042 .87222 L
s
% Start of user PostScript
-0.285714 2. -0.284906 2.0693 MAarrowhead1
% End of user PostScript
.5 .02127 m
.5 .03576 L
s
% Start of user PostScript
0 -2. 0 -1.9307 MAarrowhead1
% End of user PostScript
.931 1 0 r
.5 .08102 m
.5 .09167 L
s
% Start of user PostScript
0 -1.71429 0 -1.66337 MAarrowhead1
% End of user PostScript
1 .742 0 r
.5 .14077 m
.5 .14816 L
s
% Start of user PostScript
0 -1.42857 0 -1.39322 MAarrowhead1
% End of user PostScript
1 .475 0 r
.5 .20051 m
.5 .20525 L
s
% Start of user PostScript
0 -1.14286 0 -1.12023 MAarrowhead1
% End of user PostScript
1 .267 0 r
.5 .26026 m
.5 .26292 L
s
% Start of user PostScript
0 -0.857143 0 -0.844415 MAarrowhead1
% End of user PostScript
1 .119 0 r
.5 .32001 m
.5 .32119 L
s
% Start of user PostScript
0 -0.571429 0 -0.565772 MAarrowhead1
% End of user PostScript
1 .03 0 r
.5 .37975 m
.5 .38005 L
s
% Start of user PostScript
0 -0.285714 0 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.5 .4395 m
.5 .4395 L
s
% Start of user PostScript
0 0 MAarrowzero1
% End of user PostScript
1 .03 0 r
.5 .49925 m
.5 .49954 L
s
% Start of user PostScript
0 0.285714 0 0.287128 MAarrowhead1
% End of user PostScript
1 .119 0 r
.5 .55899 m
.5 .56018 L
s
% Start of user PostScript
0 0.571429 0 0.577085 MAarrowhead1
% End of user PostScript
1 .267 0 r
.5 .61874 m
.5 .6214 L
s
% Start of user PostScript
0 0.857143 0 0.869871 MAarrowhead1
% End of user PostScript
1 .475 0 r
.5 .67849 m
.5 .68322 L
s
% Start of user PostScript
0 1.14286 0 1.16548 MAarrowhead1
% End of user PostScript
1 .742 0 r
.5 .73824 m
.5 .74563 L
s
% Start of user PostScript
0 1.42857 0 1.46393 MAarrowhead1
% End of user PostScript
.931 1 0 r
.5 .79798 m
.5 .80863 L
s
% Start of user PostScript
0 1.71429 0 1.7652 MAarrowhead1
% End of user PostScript
.545 1 0 r
.5 .85773 m
.5 .87222 L
s
% Start of user PostScript
0 2. 0 2.0693 MAarrowhead1
% End of user PostScript
.55975 .02127 m
.55992 .03576 L
s
% Start of user PostScript
0.285714 -2. 0.286522 -1.9307 MAarrowhead1
% End of user PostScript
.931 1 0 r
.55975 .08102 m
.55989 .09167 L
s
% Start of user PostScript
0.285714 -1.71429 0.286407 -1.66337 MAarrowhead1
% End of user PostScript
1 .743 0 r
.55975 .14077 m
.55987 .14816 L
s
% Start of user PostScript
0.285714 -1.42857 0.286292 -1.39322 MAarrowhead1
% End of user PostScript
1 .475 0 r
.55975 .20051 m
.55984 .20525 L
s
% Start of user PostScript
0.285714 -1.14286 0.286176 -1.12023 MAarrowhead1
% End of user PostScript
1 .267 0 r
.55975 .26026 m
.55982 .26292 L
s
% Start of user PostScript
0.285714 -0.857143 0.286061 -0.844415 MAarrowhead1
% End of user PostScript
1 .119 0 r
.55975 .32001 m
.5598 .32119 L
s
% Start of user PostScript
0.285714 -0.571429 0.285945 -0.565772 MAarrowhead1
% End of user PostScript
1 .03 0 r
.55975 .37975 m
.55977 .38005 L
s
% Start of user PostScript
0.285714 -0.285714 0.28583 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.55975 .4395 m
.55975 .4395 L
s
% Start of user PostScript
0.285714 0 MAarrowzero1
% End of user PostScript
1 .03 0 r
.55975 .49925 m
.55972 .49954 L
s
% Start of user PostScript
0.285714 0.285714 0.285599 0.287128 MAarrowhead1
% End of user PostScript
1 .119 0 r
.55975 .55899 m
.5597 .56018 L
s
% Start of user PostScript
0.285714 0.571429 0.285483 0.577085 MAarrowhead1
% End of user PostScript
1 .267 0 r
.55975 .61874 m
.55967 .6214 L
s
% Start of user PostScript
0.285714 0.857143 0.285368 0.869871 MAarrowhead1
% End of user PostScript
1 .475 0 r
.55975 .67849 m
.55965 .68322 L
s
% Start of user PostScript
0.285714 1.14286 0.285253 1.16548 MAarrowhead1
% End of user PostScript
1 .743 0 r
.55975 .73824 m
.55963 .74563 L
s
% Start of user PostScript
0.285714 1.42857 0.285137 1.46393 MAarrowhead1
% End of user PostScript
.931 1 0 r
.55975 .79798 m
.5596 .80863 L
s
% Start of user PostScript
0.285714 1.71429 0.285022 1.7652 MAarrowhead1
% End of user PostScript
.545 1 0 r
.55975 .85773 m
.55958 .87222 L
s
% Start of user PostScript
0.285714 2. 0.284906 2.0693 MAarrowhead1
% End of user PostScript
.538 1 0 r
.61949 .02127 m
.62085 .03576 L
s
% Start of user PostScript
0.571429 -2. 0.577893 -1.9307 MAarrowhead1
% End of user PostScript
.925 1 0 r
.61949 .08102 m
.62065 .09167 L
s
% Start of user PostScript
0.571429 -1.71429 0.57697 -1.66337 MAarrowhead1
% End of user PostScript
1 .749 0 r
.61949 .14077 m
.62046 .14816 L
s
% Start of user PostScript
0.571429 -1.42857 0.576046 -1.39322 MAarrowhead1
% End of user PostScript
1 .481 0 r
.61949 .20051 m
.62027 .20525 L
s
% Start of user PostScript
0.571429 -1.14286 0.575123 -1.12023 MAarrowhead1
% End of user PostScript
1 .274 0 r
.61949 .26026 m
.62007 .26292 L
s
% Start of user PostScript
0.571429 -0.857143 0.574199 -0.844415 MAarrowhead1
% End of user PostScript
1 .125 0 r
.61949 .32001 m
.61988 .32119 L
s
% Start of user PostScript
0.571429 -0.571429 0.573276 -0.565772 MAarrowhead1
% End of user PostScript
1 .035 0 r
.61949 .37975 m
.61969 .38005 L
s
% Start of user PostScript
0.571429 -0.285714 0.572352 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.61949 .4395 m
.61949 .4395 L
s
% Start of user PostScript
0.571429 0 MAarrowzero1
% End of user PostScript
1 .035 0 r
.61949 .49925 m
.6193 .49954 L
s
% Start of user PostScript
0.571429 0.285714 0.570505 0.287128 MAarrowhead1
% End of user PostScript
1 .125 0 r
.61949 .55899 m
.61911 .56018 L
s
% Start of user PostScript
0.571429 0.571429 0.569581 0.577085 MAarrowhead1
% End of user PostScript
1 .274 0 r
.61949 .61874 m
.61891 .6214 L
s
% Start of user PostScript
0.571429 0.857143 0.568658 0.869871 MAarrowhead1
% End of user PostScript
1 .481 0 r
.61949 .67849 m
.61872 .68322 L
s
% Start of user PostScript
0.571429 1.14286 0.567734 1.16548 MAarrowhead1
% End of user PostScript
1 .749 0 r
.61949 .73824 m
.61853 .74563 L
s
% Start of user PostScript
0.571429 1.42857 0.566811 1.46393 MAarrowhead1
% End of user PostScript
.925 1 0 r
.61949 .79798 m
.61833 .80863 L
s
% Start of user PostScript
0.571429 1.71429 0.565887 1.7652 MAarrowhead1
% End of user PostScript
.538 1 0 r
.61949 .85773 m
.61814 .87222 L
s
% Start of user PostScript
0.571429 2. 0.564964 2.0693 MAarrowhead1
% End of user PostScript
.474 1 0 r
.67924 .02127 m
.6838 .03576 L
s
% Start of user PostScript
0.857143 -2. 0.878962 -1.9307 MAarrowhead1
% End of user PostScript
.861 1 0 r
.67924 .08102 m
.68315 .09167 L
s
% Start of user PostScript
0.857143 -1.71429 0.875845 -1.66337 MAarrowhead1
% End of user PostScript
1 .811 0 r
.67924 .14077 m
.6825 .14816 L
s
% Start of user PostScript
0.857143 -1.42857 0.872728 -1.39322 MAarrowhead1
% End of user PostScript
1 .543 0 r
.67924 .20051 m
.68185 .20525 L
s
% Start of user PostScript
0.857143 -1.14286 0.869611 -1.12023 MAarrowhead1
% End of user PostScript
1 .332 0 r
.67924 .26026 m
.6812 .26292 L
s
% Start of user PostScript
0.857143 -0.857143 0.866494 -0.844415 MAarrowhead1
% End of user PostScript
1 .177 0 r
.67924 .32001 m
.68054 .32119 L
s
% Start of user PostScript
0.857143 -0.571429 0.863377 -0.565772 MAarrowhead1
% End of user PostScript
1 .072 0 r
.67924 .37975 m
.67989 .38005 L
s
% Start of user PostScript
0.857143 -0.285714 0.86026 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.67924 .4395 m
.67924 .4395 L
s
% Start of user PostScript
0.857143 0 MAarrowzero1
% End of user PostScript
1 .072 0 r
.67924 .49925 m
.67859 .49954 L
s
% Start of user PostScript
0.857143 0.285714 0.854026 0.287128 MAarrowhead1
% End of user PostScript
1 .177 0 r
.67924 .55899 m
.67794 .56018 L
s
% Start of user PostScript
0.857143 0.571429 0.850909 0.577085 MAarrowhead1
% End of user PostScript
1 .332 0 r
.67924 .61874 m
.67728 .6214 L
s
% Start of user PostScript
0.857143 0.857143 0.847792 0.869871 MAarrowhead1
% End of user PostScript
1 .543 0 r
.67924 .67849 m
.67663 .68322 L
s
% Start of user PostScript
0.857143 1.14286 0.844675 1.16548 MAarrowhead1
% End of user PostScript
1 .811 0 r
.67924 .73824 m
.67598 .74563 L
s
% Start of user PostScript
0.857143 1.42857 0.841558 1.46393 MAarrowhead1
% End of user PostScript
.861 1 0 r
.67924 .79798 m
.67533 .80863 L
s
% Start of user PostScript
0.857143 1.71429 0.838441 1.7652 MAarrowhead1
% End of user PostScript
.474 1 0 r
.67924 .85773 m
.67468 .87222 L
s
% Start of user PostScript
0.857143 2. 0.835324 2.0693 MAarrowhead1
% End of user PostScript
.184 1 0 r
.73899 .02127 m
.7498 .03576 L
s
% Start of user PostScript
1.14286 -2. 1.19458 -1.9307 MAarrowhead1
% End of user PostScript
.582 1 0 r
.73899 .08102 m
.74826 .09167 L
s
% Start of user PostScript
1.14286 -1.71429 1.18719 -1.66337 MAarrowhead1
% End of user PostScript
.926 1 0 r
.73899 .14077 m
.74671 .14816 L
s
% Start of user PostScript
1.14286 -1.42857 1.1798 -1.39322 MAarrowhead1
% End of user PostScript
1 .782 0 r
.73899 .20051 m
.74517 .20525 L
s
% Start of user PostScript
1.14286 -1.14286 1.17241 -1.12023 MAarrowhead1
% End of user PostScript
1 .537 0 r
.73899 .26026 m
.74362 .26292 L
s
% Start of user PostScript
1.14286 -0.857143 1.16502 -0.844415 MAarrowhead1
% End of user PostScript
1 .332 0 r
.73899 .32001 m
.74208 .32119 L
s
% Start of user PostScript
1.14286 -0.571429 1.15763 -0.565772 MAarrowhead1
% End of user PostScript
1 .158 0 r
.73899 .37975 m
.74053 .38005 L
s
% Start of user PostScript
1.14286 -0.285714 1.15025 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.73899 .4395 m
.73899 .4395 L
s
% Start of user PostScript
1.14286 0 MAarrowzero1
% End of user PostScript
1 .158 0 r
.73899 .49925 m
.73744 .49954 L
s
% Start of user PostScript
1.14286 0.285714 1.13547 0.287128 MAarrowhead1
% End of user PostScript
1 .332 0 r
.73899 .55899 m
.7359 .56018 L
s
% Start of user PostScript
1.14286 0.571429 1.12808 0.577085 MAarrowhead1
% End of user PostScript
1 .537 0 r
.73899 .61874 m
.73435 .6214 L
s
% Start of user PostScript
1.14286 0.857143 1.12069 0.869871 MAarrowhead1
% End of user PostScript
1 .782 0 r
.73899 .67849 m
.73281 .68322 L
s
% Start of user PostScript
1.14286 1.14286 1.1133 1.16548 MAarrowhead1
% End of user PostScript
.926 1 0 r
.73899 .73824 m
.73126 .74563 L
s
% Start of user PostScript
1.14286 1.42857 1.10591 1.46393 MAarrowhead1
% End of user PostScript
.582 1 0 r
.73899 .79798 m
.72972 .80863 L
s
% Start of user PostScript
1.14286 1.71429 1.09853 1.7652 MAarrowhead1
% End of user PostScript
.184 1 0 r
.73899 .85773 m
.72817 .87222 L
s
% Start of user PostScript
1.14286 2. 1.09114 2.0693 MAarrowhead1
% End of user PostScript
0 1 .572 r
.79873 .02127 m
.81986 .03576 L
s
% Start of user PostScript
1.42857 -2. 1.52959 -1.9307 MAarrowhead1
% End of user PostScript
0 1 .109 r
.79873 .08102 m
.81684 .09167 L
s
% Start of user PostScript
1.42857 -1.71429 1.51516 -1.66337 MAarrowhead1
% End of user PostScript
.313 1 0 r
.79873 .14077 m
.81382 .14816 L
s
% Start of user PostScript
1.42857 -1.42857 1.50072 -1.39322 MAarrowhead1
% End of user PostScript
.698 1 0 r
.79873 .20051 m
.8108 .20525 L
s
% Start of user PostScript
1.42857 -1.14286 1.48629 -1.12023 MAarrowhead1
% End of user PostScript
1 .948 0 r
.79873 .26026 m
.80779 .26292 L
s
% Start of user PostScript
1.42857 -0.857143 1.47186 -0.844415 MAarrowhead1
% End of user PostScript
1 .618 0 r
.79873 .32001 m
.80477 .32119 L
s
% Start of user PostScript
1.42857 -0.571429 1.45743 -0.565772 MAarrowhead1
% End of user PostScript
1 .304 0 r
.79873 .37975 m
.80175 .38005 L
s
% Start of user PostScript
1.42857 -0.285714 1.443 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.79873 .4395 m
.79873 .4395 L
s
% Start of user PostScript
1.42857 0 MAarrowzero1
% End of user PostScript
1 .304 0 r
.79873 .49925 m
.79572 .49954 L
s
% Start of user PostScript
1.42857 0.285714 1.41414 0.287128 MAarrowhead1
% End of user PostScript
1 .618 0 r
.79873 .55899 m
.7927 .56018 L
s
% Start of user PostScript
1.42857 0.571429 1.39971 0.577085 MAarrowhead1
% End of user PostScript
1 .948 0 r
.79873 .61874 m
.78968 .6214 L
s
% Start of user PostScript
1.42857 0.857143 1.38528 0.869871 MAarrowhead1
% End of user PostScript
.698 1 0 r
.79873 .67849 m
.78666 .68322 L
s
% Start of user PostScript
1.42857 1.14286 1.37085 1.16548 MAarrowhead1
% End of user PostScript
.313 1 0 r
.79873 .73824 m
.78365 .74563 L
s
% Start of user PostScript
1.42857 1.42857 1.35642 1.46393 MAarrowhead1
% End of user PostScript
0 1 .109 r
.79873 .79798 m
.78063 .80863 L
s
% Start of user PostScript
1.42857 1.71429 1.34199 1.7652 MAarrowhead1
% End of user PostScript
0 1 .572 r
.79873 .85773 m
.77761 .87222 L
s
% Start of user PostScript
1.42857 2. 1.32756 2.0693 MAarrowhead1
% End of user PostScript
0 .056 1 r
.85848 .02127 m
.89498 .03576 L
s
% Start of user PostScript
1.71429 -2. 1.88884 -1.9307 MAarrowhead1
% End of user PostScript
0 .681 1 r
.85848 .08102 m
.88977 .09167 L
s
% Start of user PostScript
1.71429 -1.71429 1.8639 -1.66337 MAarrowhead1
% End of user PostScript
0 1 .722 r
.85848 .14077 m
.88455 .14816 L
s
% Start of user PostScript
1.71429 -1.42857 1.83897 -1.39322 MAarrowhead1
% End of user PostScript
0 1 .148 r
.85848 .20051 m
.87934 .20525 L
s
% Start of user PostScript
1.71429 -1.14286 1.81403 -1.12023 MAarrowhead1
% End of user PostScript
.406 1 0 r
.85848 .26026 m
.87412 .26292 L
s
% Start of user PostScript
1.71429 -0.857143 1.78909 -0.844415 MAarrowhead1
% End of user PostScript
.946 1 0 r
.85848 .32001 m
.86891 .32119 L
s
% Start of user PostScript
1.71429 -0.571429 1.76416 -0.565772 MAarrowhead1
% End of user PostScript
1 .525 0 r
.85848 .37975 m
.8637 .38005 L
s
% Start of user PostScript
1.71429 -0.285714 1.73922 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.85848 .4395 m
.85848 .4395 L
s
% Start of user PostScript
1.71429 0 MAarrowzero1
% End of user PostScript
1 .525 0 r
.85848 .49925 m
.85327 .49954 L
s
% Start of user PostScript
1.71429 0.285714 1.68935 0.287128 MAarrowhead1
% End of user PostScript
.946 1 0 r
.85848 .55899 m
.84805 .56018 L
s
% Start of user PostScript
1.71429 0.571429 1.66441 0.577085 MAarrowhead1
% End of user PostScript
.406 1 0 r
.85848 .61874 m
.84284 .6214 L
s
% Start of user PostScript
1.71429 0.857143 1.63948 0.869871 MAarrowhead1
% End of user PostScript
0 1 .148 r
.85848 .67849 m
.83762 .68322 L
s
% Start of user PostScript
1.71429 1.14286 1.61454 1.16548 MAarrowhead1
% End of user PostScript
0 1 .722 r
.85848 .73824 m
.83241 .74563 L
s
% Start of user PostScript
1.71429 1.42857 1.58961 1.46393 MAarrowhead1
% End of user PostScript
0 .681 1 r
.85848 .79798 m
.82719 .80863 L
s
% Start of user PostScript
1.71429 1.71429 1.56467 1.7652 MAarrowhead1
% End of user PostScript
0 .056 1 r
.85848 .85773 m
.82198 .87222 L
s
% Start of user PostScript
1.71429 2. 1.53973 2.0693 MAarrowhead1
% End of user PostScript
1 0 0 r
.91823 .02127 m
.97619 .03576 L
s
% Start of user PostScript
2. -2. 2.27718 -1.9307 MAarrowhead1
% End of user PostScript
1 0 .897 r
.91823 .08102 m
.96791 .09167 L
s
% Start of user PostScript
2. -1.71429 2.23759 -1.66337 MAarrowhead1
% End of user PostScript
.224 0 1 r
.91823 .14077 m
.95963 .14816 L
s
% Start of user PostScript
2. -1.42857 2.19799 -1.39322 MAarrowhead1
% End of user PostScript
0 .64 1 r
.91823 .20051 m
.95135 .20525 L
s
% Start of user PostScript
2. -1.14286 2.15839 -1.12023 MAarrowhead1
% End of user PostScript
0 1 .509 r
.91823 .26026 m
.94307 .26292 L
s
% Start of user PostScript
2. -0.857143 2.11879 -0.844415 MAarrowhead1
% End of user PostScript
.333 1 0 r
.91823 .32001 m
.93479 .32119 L
s
% Start of user PostScript
2. -0.571429 2.0792 -0.565772 MAarrowhead1
% End of user PostScript
1 .832 0 r
.91823 .37975 m
.92651 .38005 L
s
% Start of user PostScript
2. -0.285714 2.0396 -0.2843 MAarrowhead1
% End of user PostScript
1 0 0 r
.91823 .4395 m
.91823 .4395 L
s
% Start of user PostScript
2. 0 MAarrowzero1
% End of user PostScript
1 .832 0 r
.91823 .49925 m
.90995 .49954 L
s
% Start of user PostScript
2. 0.285714 1.9604 0.287128 MAarrowhead1
% End of user PostScript
.333 1 0 r
.91823 .55899 m
.90167 .56018 L
s
% Start of user PostScript
2. 0.571429 1.9208 0.577085 MAarrowhead1
% End of user PostScript
0 1 .509 r
.91823 .61874 m
.89339 .6214 L
s
% Start of user PostScript
2. 0.857143 1.88121 0.869871 MAarrowhead1
% End of user PostScript
0 .64 1 r
.91823 .67849 m
.88511 .68322 L
s
% Start of user PostScript
2. 1.14286 1.84161 1.16548 MAarrowhead1
% End of user PostScript
.224 0 1 r
.91823 .73824 m
.87683 .74563 L
s
% Start of user PostScript
2. 1.42857 1.80201 1.46393 MAarrowhead1
% End of user PostScript
1 0 .897 r
.91823 .79798 m
.86855 .80863 L
s
% Start of user PostScript
2. 1.71429 1.76241 1.7652 MAarrowhead1
% End of user PostScript
1 0 0 r
.91823 .85773 m
.86026 .87222 L
s
% Start of user PostScript
2. 2. 1.72282 2.0693 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 .89349 L
0 .89349 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  CellMargins->{{Inherited, Inherited}, {-10, Inherited}},
  Evaluatable->False,
  ImageSize->{333.313, 193.813},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006P0000lQ000`40O003h00OogooXGoo003oOonQ
Ool00?mooj5oo`00ogooXGoo002NOol2>n0>Ool00d?POomoo`0oOol2@n0>Ool2>n2NOol008ioo`03
5n1oogoo00eoo`@kh0aoo`=3h0eoo`=3h0eoo`A3h0aoo`A3h0aoo`93h003An13h7oo00]oo`8kh003
?n0kh7oo00eoo`8Gh8ioo`00GGoo0W`03goo0P0o3Goo00<3lGoo0o403Woo0aOP3Goo0c_P3Goo0d?P
3Goo00=3h4OP@n003Goo00A3h4OP@n13h0aoo`04@n17h4?P@n0<Ool4@n0=Ool3>n0<Ool45n0>Ool0
0`?aOol3l@0=Ool203l>Ool2O01NOol005Aoo`03O01oogoo009oo`Al00aoo`0303moogoo0080?`io
o`<3l@ioo`<Gh0ioo`<kh0ioo`93h0eoo`=3h0eoo`=3h0eoo`=3h0ioo`93h0ioo`<kh0eoo`8Gh003
4n0Gh7oo00eoo`030o43lP?a00ioo`80?`03Ool0?goo00]oo`Al00Eoo`03O01oogoo059oo`00DWoo
1g`03goo100o3goo10?a3Woo0QOP3goo0S_P3goo00=3h7ooOol03Goo00=3h7ooOol03Goo0T?P3Woo
0T?P3Woo0T?P3goo0S_P3Woo0aOP3Goo1@?a3goo100o3Woo17`000Aoog`0O01l059oo`00D7oo1G`0
4Goo1@0o3goo0`?a3goo0QOP47oo0S_P3goo00=3h7ooOol03Goo00=3h7ooOol03Goo00=3h7ooOol0
3Goo00=3h7ooOol03Woo00=3h7ooOol03Goo0S_P47oo0QOP3Woo10?a3Woo1P0o47oo1W`0D7oo001?
Ool6O00@Ool303lAOol20o4AOol00aOPOomoo`0?Ool00c_POomoo`0>Ool00d?POomoo`0=Ool00d?P
Oomoo`0=Ool00d?POomoo`0=Ool00d?POomoo`0>Ool00d?POomoo`0>Ool00c_POomoo`0?Ool00aOP
Oomoo`0?Ool20o4@Ool403l?Ool7O01?Ool00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00
ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo002NOol2Kn0>Ool2Mn10Ool2Mn0>Ool00foPOomo
o`2MOol008moo`03Bn1oogoo00aoo`A_h0aoo`Agh0aoo`=gh0eoo`Agh0aoo`Agh0aoo`9gh003Ln1g
h7oo00]oo`=_h0moo`03Bn1oogoo08eoo`00OWoo00<3hWooOol03Goo00=;h4OPBn003Goo00=_h6_P
Kn003Goo00Agh7?PMn1gh0aoo`03Mn1ch7OP00eoo`04Mn1ch7OPMn0<Ool017OPLn1gh7OP37oo00Ag
h7?PMn1gh0eoo`9_h0ioo`9;h11oo`030n9oogoo07aoo`00G7oo0g`L37oo00<2_gooOol00P:o3Goo
0`?R3Woo0T_P00=7h4_POol02goo0foP3Woo0WOP3Goo0gOP3Goo0gOP3Goo0gOP3Woo0WOP3Woo00=_
h6_PKn0037oo0T_P00=7h4_POol03Goo0`?R3Goo0P:o0Woo00<2_gooOol02Goo0g`LGGoo001EOol2
O1`00gooO1al7002O1`=Ool50[l>Ool40n8=Ool4Bn0=Ool2Kn0?Ool2Mn0>Ool00gOPOomoo`0=Ool2
Mn0>Ool2Mn0>Ool2Mn0?Ool2Kn0=Ool3Bn0=Ool30n800`?S0n9oo`0=Ool50[l<Ool4O1`2Ool2O1aE
Ool005=oo`=l7003O1]l77oo00ioo`H2_`ioo`<3hPmoo`9;h0moo`9_h0moo`03Mn1oogoo00eoo`03
Mn1oogoo00eoo`03Mn1oogoo00eoo`03Mn1oogoo00ioo`03Mn1oogoo00eoo`9_h0ioo`=;h0ioo`@3
hPioo`H2_`ioo`=l7003O1]l77`L05=oo`00DGoo1g`L3Woo1`:o3Goo0P?R47oo00=;h7ooOol03goo
00=_h7ooOol03Woo00=gh7ooOol03Goo00=gh7ooOol03Goo00=gh7ooOol03Goo00=gh7ooOol03Woo
00=gh7ooOol03Woo00=_h7ooOol03Woo00=;h7ooOol03goo0P?R3Goo1`:o3Woo1g`LDGoo003oOonQ
Ool00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00
ogooXGoo002OOol00glPOomoo`0<Ool4O^0<Ool3O^0=Ool4O^0<Ool4O^0<Ool3O^0>Ool2Ob2OOol0
091oo`03Mn1oogoo00aoo`=o80aoo`Anh0aoo`=nh0eoo`Anh0aoo`Anh0aoo`=nh0aoo`Ao80ioo`03
Mn1oogoo08ioo`00Ogoo00<Wh7ooOol03Goo0gOP3Goo0WlP3Goo00=nh7k0O^003Goo00=nh7k0O^00
3Goo00=nh7k0O^003Goo00=nh7k0O^003Woo0WkP3Goo00=o87l0Ob003Goo00=gh7?PMn003goo00<W
h7ooOol0OGoo001GOol261l3Ool361l<Ool20oH00goo0oH3mP0>Ool39n0=Ool2Mn000g?PMn1gh00;
Ool2Ob0?Ool2O^0>Ool00gkPOomoo`0=Ool2O^0>Ool2O^0>Ool2O^0>Ool3Ob0;Ool3Mn000g?PMn1o
o`0<Ool39n0>Ool40oH<Ool361l3Ool261mHOol005Eoo`LH7`eoo`D3mPioo`DWh0eoo`=gh0eoo`9o
80moo`03O^1oogoo00eoo`03O^1oogoo00eoo`03O^1oogoo00eoo`03O^1oogoo00ioo`03O^1oogoo
00eoo`9o80eoo`=gh0eoo`DWh0ioo`@3mPeoo`LH7eIoo`00Dgoo1aPO3Goo1`?f3Goo0bOP3goo0WOP
3goo00=o87ooOol03Woo00=nh7ooOol03Goo00=nh7ooOol03Goo00=nh7ooOol03Goo00=nh7ooOol0
3Woo00=nh7ooOol03Woo00=o87ooOol03Goo0WOP3goo0bOP3Goo1P?f3Woo1QPOE7oo001FOol461o/
Ool361mGOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mo
oj5oo`00ogooXGoo002POol00gh0Oomoo`0;Ool2OL0>Ool3OL0=Ool4OL0<Ool4OL0>Ool00gg0Oomo
o`0<Ool00gh0Oomoo`2NOol0095oo`03O`1oogoo00aoo`9n00aoo`Am`0aoo`=m`0eoo`Am`0aoo`Am
`0aoo`=m`0eoo`9n00ioo`03O`1oogoo08moo`00P7oo00=Gh7ooOol03Goo0Wl03Goo0Wh000=n87h0
Ool02Woo17g037oo0gg03Goo0gg03Goo0gg03Goo0gg037oo0gh03Goo0gl03goo00=Gh7ooOol0OWoo
001^Ool00`?TOomoo`0>Ool2En0>Ool4O`0<Ool00gh0OR1n000=Ool2OL0>Ool00gg0Oomoo`0=Ool2
OL0>Ool2OL0>Ool2OL0=Ool3OP0<Ool4O`0>Ool2En0@Ool00`?TOomoo`1/Ool005Yoo`D2O`eoo`@3
i0eoo`EGh0eoo`Ao00aoo`9n00ioo`9m`0ioo`03OL1oogoo00eoo`9m`0ioo`9m`0ioo`9m`0ioo`9n
00]oo`Eo00eoo`AGh0ioo`@3i0aoo`<2O`03Ool2O`9o05Yoo`00Egoo0`9o00<2W`9oOol03Goo0`?T
00<3h`?TOol037oo0UOP00AKh5OPEn1Gh0aoo`=o00eoo`9n00moo`03OL1oogoo00eoo`03OL1oogoo
00eoo`03OL1oogoo00eoo`03OL1oogoo00ioo`03OL1oogoo00aoo`9n00eoo`Ao00aoo`EGh0eoo`04
0n@3h`?T0n<20n@=Ool50WmHOol005Eoo`L2O`eoo`H3i0aoo`AGh0ioo`9o00moo`03OP1oogoo00io
o`03OL1oogoo00eoo`03OL1oogoo00eoo`03OL1oogoo00eoo`03OL1oogoo00ioo`03OL1oogoo00eo
o`03OP1oogoo00ioo`9o00ioo`=Gh0aoo`L3i0eoo`H2OeIoo`00ogooXGoo003oOonQOol00?mooj5o
o`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00X7oo00=m@7oo
Ool037oo0gd037oo0gd03Goo17d037oo17d02goo17d03Goo00=m@7ooOol0Wgoo002BOol00gh0Oomo
o`0;Ool3OD0<Ool3O@0<Ool00gd0O>1m000=Ool017d0O>1m07d037oo00Am07cPO@1m00aoo`03O@1l
h7d000aoo`9m@0ioo`03OP1oogoo091oo`00PGoo00=oX7ooOol03Goo0Wh037oo00Em@7dPOD1m87e0
00]oo`9m00eoo`=m00eoo`=m00eoo`=m00eoo`=m00]oo`9m@003OB1m@7oo00aoo`9n00moo`03Oj1o
ogoo07moo`00G7oo0P?_47oo0S?P3goo0gnP3Woo17h02goo17e037oo0Wd03Woo00=m07ooOol03Goo
0Wd03Woo0Wd03Woo0Wd037oo0ge037oo17h03Woo0WnP3goo0S?P4Goo0P?_G7oo001JOol40nl>Ool4
<n0=Ool6Oj0<Ool5OP0:Ool3OD0>Ool00gd0Oomoo`0=Ool00gd0Oomoo`0=Ool00gd0Oomoo`0=Ool0
0gd0Oomoo`0=Ool2O@0=Ool3OD0;Ool5OP0<Ool5Oj0=Ool4<n0?Ool40nmJOol005Qoo`@3k`030o03
k`?_00]oo`<ch004;n0ch3?P<n0;Ool7Oj0;Ool3OP0=Ool2OD0?Ool00gd0Oomoo`0=Ool00gd0Oomo
o`0=Ool00gd0Oomoo`0=Ool00gd0Oomoo`0>Ool00gd0Oomoo`0=Ool00ge0Oomoo`0<Ool3OP0;Ool6
Oj0<Ool2<n0012oP<n0ch3?P2goo0P?_00<3l0?_0o000`?_F7oo001KOol30nl?Ool4<n2nOol3<n0?
Ool40nmKOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mo
oj5oo`00ogooXGoo002_Ool00gaPOomoo`0mOol2O62_Ool00:5oo`03O:1oogoo00]oo`=lH0aoo`=l
H0eoo`AlH0aoo`AlH0]oo`AlH0aoo`03O:1oogoo0:1oo`00XGoo0WbP37oo0gaP37oo00=lH7a0O600
3Goo00AlH7a0O61lH0aoo`04O61l@7aPO60<Ool3O60;Ool00gbPO81lX02QOol0099oo`03OD1oogoo
00]oo`9lX003O81lX7oo00Yoo`9lH0eoo`=lH0eoo`=lH0eoo`=lH0eoo`=lH0Yoo`AlX0eoo`03OD1o
ogoo095oo`00GWoo0R_P47oo0WOP3goo0WiP3Woo0ge037oo00=lX7b0O:0037oo0WaP3Woo00=lH7oo
Ool03Goo0WaP3Woo0WaP3Woo0WaP2goo17bP2goo17e03Woo0WiP3goo0WOP3goo0R_PGgoo001LOol4
:n0>Ool4Mn0=Ool5OV0;Ool5OD0;Ool3O:0=Ool00gaPOomoo`0=Ool00gaPOomoo`0=Ool00gaPOomo
o`0=Ool00gaPOomoo`0=Ool2O60=Ool2O:0;Ool3OD000gdPOD1m@00;Ool5OV0=Ool4Mn0=Ool00b_P
9n0[h002:n1LOol005Yoo`<[h0039n0[h2_P00aoo`Agh003Nn1gh7oo00Yoo`MnH0Yoo`=m@0ioo`03
O:1oogoo00eoo`03O61oogoo00eoo`03O61oogoo00eoo`03O61oogoo00eoo`03O61oogoo00ioo`03
O61oogoo00eoo`03O:1oogoo00]oo`Am@0Yoo`MnH0Yoo`04Mn1kh7OPNn03Mn0;Ool2:n000bOP:n0[
h002:n1JOol005eoo`<[h0moo`=gh;]oo`Agh0ioo`@[h5eoo`00ogooXGoo003oOonQOol00?mooj5o
o`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00;ioo`=l00eoo`Al00aoo`Al
0;ioo`00/Woo00=l07ooOol02Goo00=l07`PO0003Goo00Al07`PO21l00aoo`04O01l87`PO00;Ool0
0g`0Oomoo`2`Ool00;5oo`03O01l87`000Yoo`03O01l87`000eoo`03O01l87`000eoo`03O01l87`0
00]oo`03O01l87`00;5oo`00Xgoo00=l87ooOol02goo00Al07`PO21l00Yoo`03O01oogoo00eoo`9l
00ioo`9l00Yoo`04O01l87`PO00<Ool00g`POomoo`2ROol0061oo`9o@0moo`9n00moo`9m80ioo`9l
P0ioo`=l80]oo`04O01l87`0O00;Ool00g`0Oomoo`0=Ool2O00>Ool2O00;Ool2O0000g`PO01oo`09
Ool4O20=Ool2O80>Ool2OB0?Ool2OP0?Ool2Od1QOol005ioo`9o@003Ob1o@7oo00aoo`An00eoo`Am
80aoo`ElP0]oo`El80]oo`9l00eoo`03O01oogoo00eoo`03O01oogoo00eoo`03O01oogoo00aoo`9l
00Yoo`Il80]oo`AlP0aoo`03OB1m07dP009m80aoo`En00aoo`04Od1o87m0Od1OOol005aoo`=o@004
Ob1o@7lPOd0:Ool4OP000ggPOP1n000:Ool3OB000gd0OB1m800:Ool7O80:Ool3O20=Ool00g`0Oomo
o`0=Ool00g`0Oomoo`0=Ool00g`0Oomoo`0=Ool00g`0Oomoo`0>Ool00g`0Oomoo`0:Ool4O20:Ool6
O80:Ool2OB000gd0OB1m8002OB0:Ool017h0ON1n07gP0gh02Woo0Wm000Ao87m0Od1o@5eoo`00Ggoo
17m03Goo17h03Goo0gdPUgoo17dP3Goo17h03Goo0gm0H7oo003oOonQOol00?mooj5oo`00ogooXGoo
003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mo
oj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00GWoo00=l07ooOol03Woo00=l07ooOol03Goo00=l
07ooOol03Goo00=l07ooOol03Goo00=l07ooOol03Goo00=l07ooOol03Goo00=l07ooOol03Goo00=l
07ooOol03Goo00=l07ooOol03Woo00=l07ooOol03Goo00=l07ooOol03Goo00=l07ooOol03Goo00=l
07ooOol03Goo00=l07ooOol03Goo00=l07ooOol0GGoo003oOonQOol00?mooj5oo`00ogooXGoo003o
OonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00:eoo`9l
00moo`03O01oogoo00eoo`Al00aoo`Al00moo`03O01oogoo0:aoo`00Vgoo00=l87ooOol03Goo0W`0
00=l87`0Ool037oo0g`03goo00Al07`PO21l00aoo`04O01l87`PO00?Ool3O00?Ool00g`POomoo`2J
Ool008Yoo`03O81oogoo00eoo`=l80moo`03O01l87`000ioo`9l00moo`03O01l87`000eoo`03O01l
87`0011oo`9l00moo`=l80moo`03O81oogoo08Uoo`00Jgoo0Wh03Goo0WdP3Woo0gb03Goo0W`P00=l
@7`POol03Woo00=l07`PO0003Woo0W`03goo0W`03Woo0W`03goo0W`03goo00=l87a0O2000W`P37oo
0gb03Woo0WdP3Woo0Wh0Jgoo001KOol3Od0=Ool4OP0;Ool4OB0<Ool5O80=Ool3O20?Ool2O00>Ool2
O00?Ool00g`0Oomoo`0=Ool00g`0Oomoo`0>Ool2O00?Ool3O20<Ool6O80;Ool4OB0<Ool4OP0<Ool3
Od1LOol005]oo`9o@003Ob1o@7m0009o@0Qoo`04OP1mh7h0ON03OP09Ool00gdPO@1m8003OB0:Ool6
O80>Ool2O20?Ool00g`0Oomoo`0=Ool00g`0Oomoo`0=Ool00g`0Oomoo`0=Ool00g`0Oomoo`0>Ool0
0g`0Oomoo`0=Ool2O20=Ool7O809Ool4OB000gd0OB1m8009Ool4OP000ggPOP1oo`08Ool3Od000glP
Od1o@01LOol005]oo`Ao@0]oo`An00aoo`=m8:Eoo`Am80aoo`=n00aoo`=o@5aoo`00ogooXGoo003o
OonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5o
o`00[Woo0WaP3Goo17aP3Goo17aP3Goo17aP3Goo00=lH7ooOol0[Goo002LOol00gbPOomoo`0=Ool4
O60=Ool2O6000ga0O61oo`0<Ool017aPO41lH7aP3Goo0gaP3Woo0gaP3goo00=lX7ooOol0Vgoo002;
Ool00ge0Oomoo`0=Ool3O:0?Ool3O60>Ool3O60=Ool3O60>Ool3O60>Ool2O60?Ool00gbPO81lX00?
Ool00ge0Oomoo`2:Ool007]oo`03OV1oogoo00eoo`9m@0eoo`04O:1lP7bPO:0?Ool3O60>Ool2O60?
Ool2O60>Ool2O60>Ool3O60?Ool2O:000gb0O:1oo`0<Ool2OD0?Ool00giPOomoo`1jOol005ioo`8[
h0aoo`9gh0eoo`=nH0aoo`9m@003OB1m@7e000aoo`AlX0moo`9lH0ioo`9lH0moo`9lH0ioo`9lH0io
o`9lH0moo`AlX0eoo`04OD1m87e0OD0<Ool3OV0=Ool2Mn0=Ool2:n1NOol005eoo`8[h0039n0[h2_P
00Yoo`Agh0]oo`9nH003OT1nH7iP00Yoo`=m@003OB1m@7e000eoo`=lX0ioo`9lH0moo`03O61oogoo
00eoo`03O61oogoo00eoo`03O61oogoo00eoo`9lH0moo`9lX0ioo`03OD1m87e0009m@0Yoo`9nH004
OT1nH7i0OV0:Ool3Mn000g_PMn1oo`09Ool4:n1NOol005eoo`L[h0Qoo`Igh0Uoo`InH0aoo`Am@0io
o`03O:1oogoo00eoo`03O61oogoo00eoo`03O61oogoo00eoo`03O61oogoo00eoo`03O61oogoo00eo
o`03O61oogoo00eoo`03O:1oogoo00eoo`=m@0aoo`MnH0Qoo`Mgh0Qoo`H[h5ioo`00ogooXGoo003o
OonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5o
o`00[Woo0Wd0?goo0Wd0[goo002MOol00ge0Oomoo`0<Ool4O@0=Ool4O@0=Ool4O@0=Ool3O@0=Ool4
O@0?Ool00ge0Oomoo`2KOol008aoo`03OP1oogoo00eoo`9m@0moo`=m00eoo`04O@1lh7d0O@0=Ool2
O@000gcPO@1oo`0<Ool00gd0O>1m000=Ool3O@0?Ool00ge0OB1m@00?Ool00gh0Oomoo`2:Ool007ao
o`03Oj1oogoo00eoo`9n00eoo`9m@003OB1m@7oo00eoo`=m00ioo`03O@1lh7d000eoo`03O@1lh7d0
00ioo`9m00ioo`=m00moo`9m@003OB1m@7oo00aoo`9n00ioo`03Oj1oogoo07]oo`00H7oo0P?_37oo
0S?P37oo0gnP37oo17h03Goo0ge03goo0Wd03Woo0Wd03goo0Wd03Woo0Wd03Woo0Wd03goo17e03Goo
17h037oo0WnP3Goo0S?P37oo0P?_H7oo001NOol60nl:Ool4<n0:Ool2Oj000go0Oj1oX00:Ool3OP00
0ghPOP1oo`0<Ool3OD0>Ool2O@0?Ool00gd0Oomoo`0=Ool00gd0Oomoo`0=Ool00gd0Oomoo`0=Ool2
O@0?Ool2OD0>Ool5OP0:Ool3Oj000go0Oj1oo`09Ool4<n0:Ool20nl00`?`0nl3k`1OOol0061oo`H3
k`Moo`Lch0Qoo`IoX0aoo`=n00ioo`03OD1oogoo00eoo`03O@1oogoo00eoo`03O@1oogoo00eoo`03
O@1oogoo00eoo`03O@1oogoo00eoo`03O@1oogoo00eoo`03OD1oogoo00eoo`=n00aoo`IoX0Qoo`Hc
h0Qoo`H3kf1oo`00H7oo0`?_2Woo13?P_Woo0c?P2goo0`?_H7oo003oOonQOol00?mooj5oo`00ogoo
XGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo002NOol00gh0
Oomoo`0>Ool2OL0=Ool3OL0=Ool4OL0<Ool4OL0=Ool2OL0?Ool00gh0Oomoo`2MOol008eoo`03O`1o
ogoo00eoo`9n00ioo`Am`0eoo`=m`0eoo`Am`0aoo`Am`0eoo`Am`0eoo`=n00moo`03O`1oogoo08]o
o`00S7oo0gl03Goo0Wh000=n87h0Ool037oo00Am`7gPOL1m`0eoo`=m`0eoo`=m`0eoo`=m`0ioo`03
OL1mh7g000ioo`9n0003OR1n07oo00aoo`9o08eoo`00Kgoo00<3i7ooOol02goo00=Gh7ooOol037oo
0gl03Woo0gh03Woo0Wg03goo00=m`7ooOol03Goo0Wg03Woo0Wg03Woo0gg03Goo17h03Goo17l03Goo
00=Gh7ooOol02goo00<3i7ooOol0KWoo001NOol30Wl00goo0Wl2O`0;Ool30n@:Ool4En0;Ool5O`0>
Ool2OP0>Ool2OL0?Ool00gg0Oomoo`0=Ool2OL0>Ool2OL0>Ool2OL0>Ool00gh0OR1n000>Ool4O`0<
Ool3En0:Ool40n@:Ool20Wl017oo0Wl2O`9oGgoo001QOol50Wl9Ool50n@8Ool6En0;Ool4O`0>Ool2
OP0>Ool00gg0Oomoo`0=Ool00gg0Oomoo`0=Ool00gg0Oomoo`0=Ool00gg0Oomoo`0=Ool2OL0>Ool2
OP0>Ool3O`0<Ool5En08Ool30n@00`?S0n@3i008Ool50WmROol0069oo`H2O`Moo`H3i0Yoo`AGh0ao
o`9o00moo`03OP1oogoo00aoo`03OL1oogoo00eoo`03OL1oogoo00eoo`03OL1oogoo00eoo`03OL1o
ogoo00eoo`03OL1oogoo00eoo`03OP1oogoo00aoo`9o00eoo`=Gh0Yoo`L3i0Ioo`L2Of9oo`00ogoo
XGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol0
0?mooj5oo`00ogooXGoo002NOol2Ob0=Ool4O^0=Ool3O^0=Ool4O^0<Ool4O^0=Ool3O^0>Ool00glP
Oomoo`2MOol008ioo`03Mn1oogoo00]oo`Ao80eoo`9nh003O/1nh7oo00aoo`03O^1n`7kP00eoo`04
O^1n`7kPO^0<Ool017kPO/1nh7kP3Goo0gkP3Woo0glP3Woo00=gh7ooOol0S7oo001nOol00bOPOomo
o`0<Ool3Mn0=Ool3Ob0>Ool3O^0=Ool3O^0=Ool3O^0=Ool3O^0>Ool2O^0?Ool2Ob0>Ool3Mn0=Ool0
0bOPOomoo`1mOol006Aoo`0361moogoo00Yoo`030oIoogoo00Uoo`<Wh0aoo`04Mn1ch7OPMn0>Ool3
Ob0=Ool2O^0?Ool00gkPOomoo`0=Ool2O^0>Ool2O^0>Ool2O^0>Ool3Ob0>Ool017OPLn1gh7OP2goo
0bOP37oo00<3mWooOol02Goo00<H7gooOol0Hgoo001NOol361l3Ool361l8Ool50oH9Ool59n0;Ool4
Mn0=Ool3Ob0=Ool2O^0?Ool00gkPOomoo`0=Ool2O^0>Ool2O^0>Ool2O^0>Ool2Ob0>Ool4Mn0;Ool4
9n0:Ool50oH7Ool361l3Ool361mOOol0065oo`PH7`Moo`H3mPUoo`@Wh0aoo`9gh0ioo`9o80ioo`03
O^1oogoo00eoo`03O^1oogoo00eoo`03O^1oogoo00eoo`03O^1oogoo00eoo`03O^1oogoo00eoo`9o
80ioo`9gh0aoo`<Wh0Yoo`H3mPIoo`8H7`0371lH7aPO00<H7f9oo`00I7oo1aPO27oo10?f2goo0ROP
3Goo00=gh7ooOol037oo00=o87ooOol037oo00=nh7ooOol03Goo00=nh7ooOol03Goo00=nh7ooOol0
3Goo00=nh7ooOol03Goo00=nh7ooOol03Goo00=o87ooOol037oo00=gh7ooOol02goo0ROP2goo10?f
27oo1aPOI7oo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003o
OonQOol00?mooj5oo`00ogooXGoo003oOonQOol009moo`03Kn1oogoo00]oo`Agh0eoo`=gh0eoo`Ag
h0aoo`Agh0aoo`Agh0eoo`9_h9moo`00Sgoo00=;h7ooOol02goo0foP3Goo00Agh7?PMn1gh0eoo`=g
h0eoo`Agh0aoo`Agh0aoo`9gh003Ln1gh7oo00aoo`04Kn1[h6oPKn0=Ool00d_POomoo`2=Ool0081o
o`030n9oogoo00Yoo`=;h0ioo`9_h0ioo`03Mn1ch7OP00eoo`03Mn1ch7OP00eoo`03Mn1ch7OP00eo
o`03Mn1ch7OP00eoo`03Mn1ch7OP00ioo`=_h0eoo`A;h0aoo`030n9oogoo07ioo`00GWoo0g`L1Woo
00=l77ooOol01Goo0P:o00=oo`:oOol02goo0`?R37oo0d_P3Goo0foP3Goo0WOP3goo00=gh7ooOol0
3Goo0WOP3Woo0WOP3Woo0WOP3Woo00=_h6_PKn003Goo00=;h4OPBn0037oo0`?R2goo00<2_gooOol0
0P:o1goo00=l77ooOol00goo0g`LGgoo001QOol4O1`2Ool3O1`7Ool40[l9Ool20n800`?S0n83hP0<
Ool2Bn0>Ool2Kn0=Ool2Mn0?Ool00gOPOomoo`0=Ool2Mn0>Ool2Mn0>Ool2Mn0>Ool2Kn0=Ool3Bn0<
Ool010?R0n<3hP?R2Woo10:o1goo0g`L00=oog`LO1`00W`LHWoo001UOol3O1`017`KO1al77`L1Goo
1P:o2Goo10?R37oo0T_P3Goo0VoP3Woo00=gh7ooOol03Goo00=gh7ooOol03Goo00=gh7ooOol03Goo
00=gh7ooOol03Goo00=gh7ooOol03Goo0VoP3Goo00=;h7ooOol02goo0`?R2Woo1@:o1Woo1W`LIWoo
001VOol7O1`7Ool40[l;Ool20n8<Ool00d_POomoo`0<Ool00foPOomoo`0<Ool00gOPOomoo`0=Ool0
0gOPOomoo`0=Ool00gOPOomoo`0=Ool00gOPOomoo`0=Ool00gOPOomoo`0=Ool00foPOomoo`0;Ool0
0d_POomoo`0;Ool20n8;Ool30[l8Ool6O1aWOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5o
o`00ogooXGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5oo`00Wgoo0S_P3goo
00=3h7ooOol02goo0d?P3Goo14?P37oo14?P37oo0T?P3goo00<kh7ooOol0WWoo002?Ool25n0<Ool4
>n0=Ool3@n0=Ool3@n0=Ool2@n000dOP@n1oo`0;Ool2@n000dOP@n1oo`0;Ool4@n0=Ool3>n0=Ool0
0aOPOomoo`2>Ool005ioo`9l00moo`80?`ioo`030o5oo`?a00]oo`@Gh0eoo`<kh0eoo`=3h0eoo`=3
h0eoo`=3h0eoo`=3h0eoo`A3h0eoo`8kh0ioo`<Gh0aoo`030o5oo`?a00ioo`80?`ioo`9l05moo`00
H7oo17`01Goo00=l07ooOol01Goo0P0o00=oo`0oOol02Woo0`?a2goo00@Gh1?P5n0Gh0aoo`<kh0eo
o`93h0moo`03@n1oogoo00eoo`93h0ioo`93h0ioo`93h0eoo`<kh0eoo`035n0Ch1OP00aoo`030o43
lP?a00]oo`0403moo`0o03l6Ool00g`0Oomoo`03Ool4O01QOol006Aoo`Al0004Ooml07`0O007Ool3
03l9Ool50o4;Ool35n0=Ool2>n0>Ool00d?POomoo`0=Ool00d?POomoo`0=Ool2@n0>Ool2@n0>Ool2
@n0=Ool2>n0>Ool25n0<Ool40o49Ool403l7Ool2O0000gooO01l0002O01UOol006Qoo`Il00Eoo`D0
?`Uoo`<3l@eoo`8Gh0aoo`8kh0ioo`03@n1oogoo00eoo`03@n1oogoo00eoo`03@n1oogoo00eoo`03
@n1oogoo00eoo`03@n1oogoo00aoo`8kh0eoo`8Gh0aoo`<3l@Uoo`H0?`Eoo`El06Uoo`00J7oo1g`0
1goo0`0o2Woo0P?a3Goo00<Gh7ooOol02goo00<kh7ooOol037oo00=3h7ooOol03Goo00=3h7ooOol0
3Goo00=3h7ooOol03Goo00=3h7ooOol03Goo00=3h7ooOol037oo00<kh7ooOol037oo00<Gh7ooOol0
2Woo0P?a2Woo100o1goo1W`0JGoo003oOonQOol00?mooj5oo`00ogooXGoo003oOonQOol00?mooj5o
o`00\
\>"],
  ImageRangeCache->{{{0, 415.625}, {241.25, 0}} -> {-3.68057, -2.10175, \
0.0221388, 0.0221388}}]
}, Open  ]],

Cell[BoxData[
    \(\(\n\[EmptySquare]\ \ \ \)\)], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, -10}},
  TextAlignment->Right,
  TextJustification->0],

Cell[TextData[{
  "So far, the discussion of flows and the related vector fields was \
restricted to a set of independent coordinates. Let us now ask the question: \
What happens if we apply the flow concept to a function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " depending on a set of independent coordinates? Let us assume that ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " is a vector field on the manifold \[GothicCapitalM] and ",
  StyleBox["f ",
    FontSlant->"Italic"],
  ": \[GothicCapitalM] \[Rule] \[DoubleStruckCapitalR] is a smooth function. \
Our intention is to get a formula describing the changes of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " if we apply the transformation \[CapitalPhi] on the independent \
variables. To simplify things and make them easier to read in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we restrict our considerations to the case \[GothicCapitalM]= \
\[DoubleStruckCapitalR]. In local coordinates, the vector field is thus given \
by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"], " ", "=", " ", 
          RowBox[{"\[Xi]", " ", \((x)\), " ", 
            FormBox[\(\[PartialD]\_x\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". Now, let us examine the behavior of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " if the flow \[CapitalPhi] is applied on the independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". After the transformation of the independent variables, we calculate the  \
derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " with respect to the parameter \[Epsilon]:"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "manifold", "smooth function", "transformation", "independent variables", 
    "vector field", "flow", "transformation of independent variables"}],

Cell[BoxData[
    \(Clear[\[CapitalPhi], \[Xi]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_\[Epsilon] f[\[CapitalPhi][x, \[Epsilon]]]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", \(\[CapitalPhi][x, \[Epsilon]]\), 
        "]"}], " ", 
      RowBox[{
        SuperscriptBox["\[CapitalPhi]", 
          TagBox[\((0, 1)\),
            Derivative],
          MultilineFunction->None], "[", \(x, \[Epsilon]\), "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an expression containing derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " and \[CapitalPhi]. From our considerations above, we know that the flow \
\[CapitalPhi] at ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  " has to represent the identity. We also know that the first derivative of \
the flow at \[Epsilon]=0 is a representation of the infinitesimals \[Xi]. We \
use these conditions to define the transformation rule"
}], "Text",
  Evaluatable->False,
  CellTags->{"identity", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"rule1", "=", 
      RowBox[{"{", 
        RowBox[{\(\[CapitalPhi][x_, 0] \[RuleDelayed] x\), ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox["\[CapitalPhi]", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x_, 0\), "]"}], 
            "\[RuleDelayed]", \(\[Xi][x]\)}]}], "}"}]}]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(\[CapitalPhi][x_, 0] \[RuleDelayed] x\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["\[CapitalPhi]", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x_, 0\), "]"}], 
          "\[RuleDelayed]", \(\[Xi][x]\)}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The second element of this list of delayed rules introduces an \
abbreviation for the coefficients of the vector field \[Xi]. If we again \
evaluate the differentiation of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " at \[Epsilon] = 0 and use ",
  StyleBox["rule1",
    FontSlant->"Italic"],
  ", we find"
}], "Text",
  Evaluatable->False,
  CellTags->{"delayed rule", "coefficients of the vector field"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[PartialD]\_\[Epsilon] f[\[CapitalPhi][x, \[Epsilon]]] /. 
        \[Epsilon] \[Rule] 0\) /. rule1\)], "Input"],

Cell[BoxData[
    RowBox[{\(\[Xi][x]\), " ", 
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This relation can be identified with the application of the vector field ",
  
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " on ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "; i.e.,",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              FormBox[\(v\&\[RightVector]\),
                "TraditionalForm"], \(f(x)\)}], " ", "=", " ", 
            RowBox[{
              FormBox[\(\(\[Xi](x)\)\ \[PartialD]\_x\),
                "TraditionalForm"], \(f(x)\)}]}]}], TraditionalForm]]],
  ". The presented calculation shows that the notation for a vector field is \
generally useful for simplifying the representation of the infinitesimal \
flow. The one-dimensional example can be generalized to higher dimensions. \
The vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " acts as a first-order partial differential operator on real functions ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "InlineFormula"], TraditionalForm]]],
  " on \[GothicCapitalM]. On the other hand, we can expand the function ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "InlineFormula"], TraditionalForm]]],
  " containing the transformed arguments in a Taylor series around \[Epsilon] \
= 0. The result of this sort of calculation is"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "infinitesimal flow", 
    "first order partial differential operator", "Taylor series"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[f[\[CapitalPhi][x, \[Epsilon]]], {\[Epsilon], 0, 1}] /. rule1
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(f[x]\), "+", 
        RowBox[{\(\[Xi][x]\), " ", 
          RowBox[{
            SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], " ", "\[Epsilon]"}], 
        "+", 
        InterpretationBox[\(O[\[Epsilon]]\^2\),
          SeriesData[ \[Epsilon], 0, {}, 0, 2, 1]]}],
      SeriesData[ \[Epsilon], 0, {
        f[ x], 
        Times[ 
          \[Xi][ x], 
          Derivative[ 1][ f][ x]]}, 0, 2, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "representing the infinitesimal change of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " under the flow generated by the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  ". We can summarize that the flow changes the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " in the following way:"
}], "Text",
  Evaluatable->False,
  CellTags->"infinitesimal change"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(f(\[CapitalPhi](x, \[Epsilon]))\), " ", "=", " ", 
            RowBox[{\(f(x)\), " ", "+", " ", 
              RowBox[{"\[Epsilon]", " ", 
                FormBox[\(v\&\[RightVector]\),
                  "TraditionalForm"], " ", \(f(x)\)}], " ", "+", " ", 
              FormBox[\(O(\[Epsilon]\^2\),
                "TraditionalForm"]}]}], " ", ")"}], TraditionalForm]]],
  ","
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-38"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)], "InlineFormula"],
  StyleBox["f", "InlineFormula",
    FontSlant->"Italic"],
  " gives the infinitesimal change in the function ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "InlineFormula"], TraditionalForm]]],
  " under the flow generated by\[NonBreakingSpace]\[NoBreak]",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[TextData[
"So far, we discussed the meaning of a vector field in a manifold \
\[GothicCapitalM] of independent variables. We observed that the ensemble of \
the tangent vectors at different positions defines the vector field. We also \
introduced the vector field by replacing the Cartesian basis with a \
differential basis. The examination of a function under the action of the \
flow demonstrated that the transformed function is represented by the \
function itself and the infinitesimal change of the function caused by the \
application of the vector field on the function. Up to now, we assumed in our \
discussions that the variables in the manifold are independent of each other. \
Let us now assume that we have a manifold containing also some dependent \
variables. Here, the question arises of how to transform the derivatives \
contained in such a manifold. This is closely related to the problem of \
prolonging or extending a vector field."], "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "manifold", "Cartesian basis", "tangent vector", 
    "differential basis", "transformed function", "infinitesimal change", 
    "dependent variables", "prolonging a vector field", 
    "extending a vector field"}],

Cell[TextData[{
  "We discussed in S",
  ButtonBox["ection 3.4",
    ButtonData:>{"derivat.nb", "Prolongations"},
    ButtonStyle->"Hyperlink"],
  " how to extend or prolong a manifold. The procedure in a nutshell is that \
we add new coordinates, representing the derivatives, to the manifold. On the \
other hand, if we extend the manifold by new coordinates, we naturally have \
to extend the vector field by these new coordinates. We can write such an \
extension symbolically by"
}], "Text",
  Evaluatable->False,
  CellTags->{"prolong a manifold", "extend a manifold", "extension"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(pr\^\((k)\)\),
            "TraditionalForm"], " ", 
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"]}], " ", "=", " ", 
        RowBox[{
          FormBox[\(\[Xi]\_i\),
            "TraditionalForm"], " ", 
          RowBox[{
            FormBox[\(\[PartialD]\_\(x\_i\)\),
              "TraditionalForm"], "  ", 
            RowBox[{"+", " ", 
              FormBox[\(\[Phi]\^\[Alpha]\),
                "TraditionalForm"]}]}], " ", 
          RowBox[{
            FormBox[\(\[PartialD]\_\(u\^\[Alpha]\)\),
              "TraditionalForm"], " ", 
            RowBox[{"+", " ", 
              FormBox[\(\[Phi]'\^\[Alpha]\),
                "TraditionalForm"]}]}], " ", 
          RowBox[{
            FormBox[\(\[PartialD]\_\(u\_i\%\[Alpha]\)\),
              "TraditionalForm"], " ", \(+\ \(\[CenterEllipsis] . \)\)}]}]}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-39"],

Cell[TextData[{
  "In expression (3.61), we divided the variables of the manifold \
\[GothicCapitalM] into two sets: one known as independent variables ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(x\& \[RightVector] \) = \((x\_1, x\_2, \[Ellipsis], x\_p)\)\)]],
  " and the other known as dependent variables ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(u\& \[RightVector] \) = \((u\^1, u\^2, \[Ellipsis], u\^q)\)\)]],
  ". ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]'\^\[Alpha]\)]],
  " denotes the symbol of the transformed derivatives ",
  Cell[BoxData[
      \(TraditionalForm\`u\_i\%\[Alpha]\)]],
  "=",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[PartialD]u\^\[Alpha]/\[PartialD]x\_i\)\)]],
  ". The difficulty with relation (3.61) at the moment is that we do not know \
how to calculate the coefficients  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]'\^\[Alpha]\)]],
  " of the extension. However, to get a feeling of how derivatives change \
under a transformation, let us go back to the basics of calculus."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "manifold", "transformed derivatives", "transformation", "Calculus"}],

Cell[TextData[{
  "Assume that we have to examine the transformations of a curve ",
  Cell[BoxData[
      \(TraditionalForm\`u = f(x)\)]],
  " in one independent variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and one dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u(x)\)]],
  ". The transformation of this curve is given by two rules defining the \
change of the original variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["u",
    FontSlant->"Italic"],
  " to the new variables ",
  Cell[BoxData[
      \(TraditionalForm\`X = \[CapitalXi](x, u)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`U = \[CapitalPhi](x, u)\)]],
  ", respectively. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we define this transformation by the following set of rules:"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "transformation", "change of original variables", "new variables"}],

Cell[BoxData[
    \(Clear[U, X, \[CapitalPhi], \[CapitalXi]]; \n
    transformation\ \  = 
      \ {X \[Rule] Function[{x, u}, \[CapitalXi][x, u[x]]], 
        U \[Rule] Function[{x, u}, \[CapitalPhi][x, u[x]]]}; \)], "Input"],

Cell[TextData[{
  "where the transforming functions \[CapitalXi] and \[CapitalPhi] are given \
functions of the original variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Applying the transformation on the curve ",
  Cell[BoxData[
      \(TraditionalForm\`u = f(x)\)]],
  ", a new representation ",
  Cell[BoxData[
      \(TraditionalForm\`U = F(X)\)]],
  " results. The variables ",
  StyleBox["U",
    FontSlant->"Italic"],
  " and ",
  StyleBox["X",
    FontSlant->"Italic"],
  " in the new representation depend on the variables of the old \
representation ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  ". Our intention is to examine the derivative of the curve in the new \
coordinates. The calculation of the derivative of ",
  StyleBox["U",
    FontSlant->"Italic"],
  " in this new coordinate system needs to take into account the changes of \
all the new variables. These changes are best represented if we use the total \
derivative to realize the derivative. The slope of the curve in the new \
coordinates is calculated at each point ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  " of the old coordinate system by"
}], "Text",
  Evaluatable->False,
  CellTags->{"original variables", "changes of variables"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "=", \(Dt[U[x, u]]\/Dt[X[x, u]]\)}], 
      ";", 
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "//", "LieTraditionalForm"}]}]], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\(Dt[u]\ U\_u + Dt[x]\ U\_x\)\/\(Dt[u]\ X\_u + Dt[x]\ X\_x\)\)], 
  "Output"]
}, Open  ]],

Cell["\<\
The result shows that the derivative in the new coordinate system \
is a function of the old variables. If we explicitly express these \
dependencies by the transformations connecting the old and the new \
coordinates, we get\
\>", "Text",
  Evaluatable->False,
  CellTags->{"new coordinate system", "transformation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "=", 
        RowBox[{
          SuperscriptBox["U", "\[Prime]",
            MultilineFunction->None], "/.", "transformation"}]}], ";", 
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "//", "LieTraditionalForm"}]}]], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\(u\_x\ \[CapitalPhi]\_u + 
        \[CapitalPhi]\_x\)\/\(u\_x\ \[CapitalXi]\_u + \[CapitalXi]\_x\)\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "This is a basic result from calculus and fundamental for our further \
examinations. The formula above says that a transformed derivative itself \
becomes a function of the transformation in the new coordinates. The \
connecting link between our current examinations and the prolongation of the \
vector field are the transformations \[CapitalXi] and \[CapitalPhi] which \
represent the flow of the related vector field. The variable ",
  Cell[BoxData[
      \(TraditionalForm\`U'\)]],
  " in our notation is nothing else than the representation of the symbol ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]'\^\[Alpha]\)]],
  ". This symbol was introduced in relation ",
  ButtonBox["(3.61) ",
    ButtonData:>"eq-39",
    ButtonStyle->"Hyperlink"],
  "for the extended vector field. The difference between the considerations \
on vector fields and the representation of the ",
  StyleBox["extension",
    FontSlant->"Italic"],
  " in calculus is that the latter does not depend on a parameter \[Epsilon]. \
However, this dependence is not essential, as we will show in a moment. We \
can actually assume that the transformations \[CapitalXi] and \[CapitalPhi] \
depend on \[Epsilon]. The definition of these one-parameter transformations \
reads"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "prolongation", "flow of the vector field", "extension", 
    "one parameter transformation"}],

Cell[BoxData[
    \(\(transformation = {
        X \[Rule] Function[{x, u}, \[CapitalXi][x, u[x], \[Epsilon]]], 
        U \[Rule] Function[{x, u}, \[CapitalPhi][x, u[x], \[Epsilon]]]}; 
    \)\)], "Input"],

Cell[TextData[
"These transformations do not change the previous result. The relations for \
the extended vector field are derived if we replace the original \
transformations by the \[Epsilon]-dependent transformations. Then, the \
derivative in new coordinates gets the form"], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "=", 
        \(Dt[U[x, u]]\/Dt[X[x, u]] /. transformation\)}], ";", 
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "//", "LieTraditionalForm"}]}]], "Input"],

Cell[BoxData[
    \(\(u\_x\ \[CapitalPhi]\_u + 
        \[CapitalPhi]\_x\)\/\(u\_x\ \[CapitalXi]\_u + \[CapitalXi]\_x\)\)], 
  "Output"]
}, Open  ]],

Cell[TextData[
"where \[Epsilon] is just a parameter in this expression. This representation \
of the transformation is a general transformation determined by the arbitrary \
functions \[CapitalXi] and \[CapitalPhi]. Lie demonstrated that this general \
transformation can be replaced by a much simpler version, the so-called \
infinitesimal transformation. We know from our considerations above that the \
infinitesimal transformations of the manifold \[GothicCapitalM] are given \
by"], "Text",
  Evaluatable->False,
  CellTags->{"transformation", "infinitesimal transformation", "manifold"}],

Cell[BoxData[
    \(\(infinitesimalTransformation = {
        X \[Rule] Function[{x, u}, x + \[Epsilon]\ \[Xi][x, u[x]]], 
        U \[Rule] Function[{x, u}, u[x] + \[Epsilon]\ \[Phi][x, u[x]]]}; 
    \)\)], "Input"],

Cell["\<\
Using these infinitesimal transformations of the variables, the \
first derivative in the new coordinate system becomes\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "=", 
        \(Dt[U[x, u]]\/Dt[X[x, u]] /. infinitesimalTransformation\)}], ";", 
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "//", "LieTraditionalForm"}]}]], "Input"],

Cell[BoxData[
    \(\(u\_x + \[Epsilon]\ \((u\_x\ \[Phi]\_u + \[Phi]\_x)\)\)\/\(1 + 
        \[Epsilon]\ \((u\_x\ \[Xi]\_u + \[Xi]\_x)\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Remembering the fact that in symmetry analysis, an infinitesimal \
representation is based on the linear part of the parameter \[Epsilon], we \
are able to reduce this rational expression to a simpler form by expanding ",
  Cell[BoxData[
      \(TraditionalForm\`U'\)]],
  " around \[Epsilon] = 0"
}], "Text",
  Evaluatable->False,
  CellTags->{"infinitesimal representation", "rational expression"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "=", 
        RowBox[{"Expand", "[", 
          RowBox[{"Series", "[", 
            RowBox[{
              SuperscriptBox["U", "\[Prime]",
                MultilineFunction->None], ",", \({\[Epsilon], 0, 1}\)}], 
            "]"}], "]"}]}], ";", 
      RowBox[{
        SuperscriptBox["U", "\[Prime]",
          MultilineFunction->None], "//", "LieTraditionalForm"}]}]], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(u\_x\), "+", 
        \(\((u\_x\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\) + u\_x\ \[Phi]\_u + 
              \[Phi]\_x)\)\ \[Epsilon]\), "+", 
        InterpretationBox[\(O[\[Epsilon]]\^2\),
          SeriesData[ \[Epsilon], 0, {}, 0, 2, 1]]}],
      SeriesData[ \[Epsilon], 0, {
        Subscript[ u, x], 
        Plus[ 
          Times[ 
            Subscript[ u, x], 
            Plus[ 
              Times[ -1, 
                Subscript[ u, x], 
                Subscript[ \[Xi], u]], 
              Times[ -1, 
                Subscript[ \[Xi], x]]]], 
          Times[ 
            Subscript[ u, x], 
            Subscript[ \[Phi], u]], 
          Subscript[ \[Phi], x]]}, 0, 2, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is that the derivative ",
  StyleBox["U'",
    FontSlant->"Italic"],
  " is given by the old derivative ",
  StyleBox["u'",
    FontSlant->"Italic"],
  " plus terms characteristic of the transformation. This expression \
represents the infinitesimal transformation of the first derivative depending \
on the derivatives of the infinitesimals \[Xi] and \[Phi] for the independent \
and dependent variables. The representation of the prolonged vector field is \
thus given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"infinitesimal transformation", "prolonged vector field"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"prolongation", "=", 
      RowBox[{"AppendTo", "[", 
        RowBox[{"infinitesimalTransformation", ",", 
          RowBox[{\(Uprime \[Rule] Function[{x, u}, w]\), "/.", 
            RowBox[{"w", "\[Rule]", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"Normal", "[", 
                    SuperscriptBox["U", "\[Prime]",
                      MultilineFunction->None], "]"}], "/.", 
                  \(u[x] \[Rule] u\)}], ")"}]}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
        \(X \[Rule] Function[{x, u}, x + \[Epsilon]\ \[Xi][x, u[x]]]\), ",", 
          \(U \[Rule] Function[{x, u}, u[x] + \[Epsilon]\ \[Phi][x, u[x]]]\), 
          ",", 
          RowBox[{"Uprime", "\[Rule]", 
            RowBox[{"Function", "[", 
              RowBox[{\({x, u}\), ",", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["u", "\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}], "+", 
                  RowBox[{"\[Epsilon]", " ", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            SuperscriptBox["u", "\[Prime]",
                              MultilineFunction->None], "[", "x", "]"}], 
                          " ", 
                          RowBox[{
                            SuperscriptBox["\[Phi]", 
                              TagBox[\((0, 1)\),
                                Derivative],
                              MultilineFunction->None], "[", \(x, u\), 
                            "]"}]}], "+", 
                        RowBox[{
                          RowBox[{
                            SuperscriptBox["u", "\[Prime]",
                              MultilineFunction->None], "[", "x", "]"}], 
                          " ", 
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{
                                RowBox[{"-", 
                                  RowBox[{
                                    SuperscriptBox["u", "\[Prime]",
                                      MultilineFunction->None], "[", "x", 
                                    "]"}]}], " ", 
                                RowBox[{
                                  SuperscriptBox["\[Xi]", 
                                    TagBox[\((0, 1)\),
                                      Derivative],
                                    MultilineFunction->None], "[", \(x, u\), 
                                  "]"}]}], "-", 
                              RowBox[{
                                SuperscriptBox["\[Xi]", 
                                  TagBox[\((1, 0)\),
                                    Derivative],
                                  MultilineFunction->None], "[", \(x, u\), 
                                "]"}]}], ")"}]}], "+", 
                        RowBox[{
                          SuperscriptBox["\[Phi]", 
                            TagBox[\((1, 0)\),
                              Derivative],
                            MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                      ")"}]}]}]}]}]}]}], "}"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The variable ",
  StyleBox["prolongation",
    FontSlant->"Italic"],
  " contains the infinitesimal transformations for the independent and \
dependent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and the first prolongation \[Phi]' of this manifold. Knowing the \
infinitesimal transformations of the variables, we are able to write down the \
corresponding vector field. The once extended vector field thus becomes "
}], "Text",
  Evaluatable->False,
  CellTags->"first prolongation"],

Cell[BoxData[
    RowBox[{\(vectorField[f_]\), ":=", 
      RowBox[{
      \(\[Xi][x, u]\ \[PartialD]\_x f\), "+", " ", 
        \(\[Phi][x, u]\ \[PartialD]\_u f\), "+", "\n", "\t\t", 
        RowBox[{
          RowBox[{"Coefficient", "[", 
            RowBox[{
              RowBox[{"Normal", "[", 
                SuperscriptBox["U", "\[Prime]",
                  MultilineFunction->None], "]"}], ",", "\[Epsilon]"}], 
            "]"}], " ", \(\[PartialD]\_p f\)}]}]}]], "Input"],

Cell[TextData[{
  "The application of this function on an auxiliary function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " depending on the variables ",
  StyleBox["(x, u, p) ",
    FontSlant->"Italic"],
  "gives us the first extended vector field in its general form:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vectorField[f[x, u, p]] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\[Phi]\ f\_u + \[Xi]\ f\_x + 
      f\_p\ \((u\_x\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\) + u\_x\ \[Phi]\_u + 
            \[Phi]\_x)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "We changed the notation slightly by introducing the variable ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " for the first derivative in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". This substitution simplifies the representation and clarifies the fact \
that ",
  Cell[BoxData[
      \(TraditionalForm\`u\_x\)]],
  " is considered as another coordinate of the manifold \[GothicCapitalM]. \
The result shows that the first extended vector field depends in a \
characteristic way on the derivatives of the dependent variables as well as \
on the first derivatives of the flow components \[Xi] and \[Phi]. Recalling \
the steps of the calculation for deriving the first extension of the vector \
field, we can go to the next order in the extension. The steps we needed in \
the calculation were as follows:"
}], "Text",
  Evaluatable->False],

Cell["1. Replace the old differentials by the new differentials.", "ListItem",
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->0,
  CellTags->{"old differentials", "new differentials"}],

Cell["\<\
2. Use the infinitesimal representation of the \
transformations.\
\>", "ListItem",
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->0,
  CellTags->"infinitesimal transformation"],

Cell[TextData[
"3. Expand the result around \[Epsilon] = 0 up to first order."], "ListItem",
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->0],

Cell["\<\
The second extension of the vector field follows by using the same \
steps but incorporates the results of the first extension. The second \
extension is calculated by the formula\
\>", "Text",
  Evaluatable->False,
  CellTags->"extension"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["U", "\[DoublePrime]",
          MultilineFunction->None], "=", 
        \(Normal[
          Series[\[PartialD]\_x\((
                    Dt[U[x, u]]\/Dt[X[x, u]] /. infinitesimalTransformation)
                    \)\/\[PartialD]\_x X[x, u[x]] /. 
              infinitesimalTransformation, {\[Epsilon], 0, 1}]]\)}], ";", 
      RowBox[{
        SuperscriptBox["U", "\[DoublePrime]",
          MultilineFunction->None], "//", "LieTraditionalForm"}]}]], "Input"],

Cell[BoxData[
    \(u\_\(x, x\) + 
      \[Epsilon]\ 
        \((2\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\)\ u\_\(x, x\) + 
            \[Phi]\_u\ u\_\(x, x\) - 
            u\_x\ \((
                \[Xi]\_u\ u\_\(x, x\) + u\_x\ \[Xi]\_\(x, u\) + 
                  u\_x\ \((u\_x\ \[Xi]\_\(u, u\) + \[Xi]\_\(x, u\))\) + 
                  \[Xi]\_\(x, x\))\) + u\_x\ \[Phi]\_\(x, u\) + 
            u\_x\ \((u\_x\ \[Phi]\_\(u, u\) + \[Phi]\_\(x, u\))\) + 
            \[Phi]\_\(x, x\))\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of the calculation contains a large number of terms. However, \
looking at the first terms of the result, we observe that the second \
derivative, ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(x, x\)\)]],
  ", is altered by a sum of terms containing derivatives of the \
infinitesimals \[Xi] and \[Phi]. The components of this expression are \
derivatives of the dependent variable and the flows \[Xi] and \[Phi] up to \
second order. The twice extended vector field thus follows by"
}], "Text",
  Evaluatable->False,
  CellTags->"twice extended vector field"],

Cell[BoxData[
    RowBox[{\(Clear[vectorField]\), ";", "\n", 
      RowBox[{\(vectorField[f_]\), ":=", 
        RowBox[{
        \(\[Xi][x, u]\ \[PartialD]\_x f\), "+", 
          \(\[Phi][x, u]\ \[PartialD]\_u f\), "+", "\n", "\t\t", 
          RowBox[{
            RowBox[{"Coefficient", "[", 
              RowBox[{
                RowBox[{"Normal", "[", 
                  SuperscriptBox["U", "\[Prime]",
                    MultilineFunction->None], "]"}], ",", "\[Epsilon]"}], 
              "]"}], " ", \(\[PartialD]\_p f\)}], "+", "\n", "\t\t", 
          RowBox[{
            RowBox[{"Coefficient", "[", 
              RowBox[{
                SuperscriptBox["U", "\[DoublePrime]",
                  MultilineFunction->None], ",", "\[Epsilon]"}], "]"}], " ", 
            \(\[PartialD]\_q f\)}]}]}]}]], "Input"],

Cell["Applied to an auxiliary function, we get the expression", "Text",
  CellTags->"auxiliary function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vectorField[f[x, u, p, q]] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\[Phi]\ f\_u + \[Xi]\ f\_x + 
      f\_p\ \((u\_x\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\) + u\_x\ \[Phi]\_u + 
            \[Phi]\_x)\) + 
      f\_q\ \((2\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\)\ u\_\(x, x\) + 
            \[Phi]\_u\ u\_\(x, x\) - 
            u\_x\ \((
                \[Xi]\_u\ u\_\(x, x\) + u\_x\ \[Xi]\_\(x, u\) + 
                  u\_x\ \((u\_x\ \[Xi]\_\(u, u\) + \[Xi]\_\(x, u\))\) + 
                  \[Xi]\_\(x, x\))\) + u\_x\ \[Phi]\_\(x, u\) + 
            u\_x\ \((u\_x\ \[Phi]\_\(u, u\) + \[Phi]\_\(x, u\))\) + 
            \[Phi]\_\(x, x\))\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "In conclusion, the second extension of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " follows from the first extension which was created using the \
infinitesimals itself. If we are interested in the third extension, we need \
the second and the first extension. In other words, the higher extensions of \
the vector field are recursively defined. This recursive definition was first \
observed by ",
  ButtonBox["Lie and Engel [1888]",
    ButtonData:>{"Literat.nb", "Lie-88"},
    ButtonStyle->"Hyperlink"],
  ". Today, the extensions are calculated by a general formula combining all \
the discussed steps in a nutshell. The prolongation formula in its modern \
form is given by "
}], "Text",
  Evaluatable->False,
  CellTags->{
  "second extension", "extension", "higher extension", 
    "recursive definition of extension", "prolongation formula"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(pr\^\((k)\)\) v\&\[RightVector]\  = \ 
      v\&\[RightVector]\  + 
        \[Sum]\+\(\[Alpha] = 1\)\%q
            \(\[Sum]\+J\(\( \[Phi]\_\[Alpha]\%J\)(x, u\_\((k)\))\)\ 
              \(\[PartialD]\/\[PartialD]u\_J\%\[Alpha] . \)\)\)], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-40"],

Cell[TextData[{
  "The second summation in this expression extends to all multi-indices ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"J", "=", 
                FormBox[\((j\_1\),
                  "TraditionalForm"]}], ",", "\[Ellipsis]", ",", 
              FormBox[\(j\_l\),
                "TraditionalForm"]}], ")"}], "  "}], TraditionalForm]]],
  "with 1 \[LessEqual] ",
  Cell[BoxData[
      \(TraditionalForm\`j\_l\)]],
  " \[LessEqual] ",
  StyleBox["p",
    FontSlant->"Italic"],
  ", 1 \[LessEqual] l \[LessEqual] ",
  StyleBox["k",
    FontSlant->"Italic"],
  ". The ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "th expansion coefficients ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\%J\)]],
  " of the prolongation are recursively given by"
}], "Text",
  Evaluatable->False,
  CellTags->"prolongation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\[Phi]\_\[Alpha]\%J\)(x, u\_\((k)\))\  = \ 
      \(D\_J\)(\[Phi]\_\[Alpha]\  - 
            \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ u\_i\%\[Alpha])\  + \ 
        \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ u\_\(J, i\)\%\[Alpha], \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-41"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm
      \`u\_i\%\[Alpha]\  = \ \[PartialD]u\^\[Alpha]/\[PartialD]x\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm
      \`u\_\(J, i\)\%\[Alpha]\  = \ 
        \[PartialD]u\_J\%\[Alpha]/\[PartialD]x\_i\)]],
  ". This step corresponds to the recursion discussed above. For a detailed \
discussion of the recursive prolongation formula, see, e.g., ",
  ButtonBox["Bluman and Kumei [1989]",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Ibragimov [1985]",
    ButtonData:>{"Literat.nb", "Ibra-85"},
    ButtonStyle->"Hyperlink"],
  ", and ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->"recursive prolongation formula"],

Cell[TextData[{
  "The problem of such a complicated recursive calculation of the \
prolongation is that for the ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "th-order calculation, we always need to know the ",
  Cell[BoxData[
      \(TraditionalForm\`k - 1\)]],
  " previous results. If ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " is a large number, this can be very time- and memory-consuming if done by \
computer, not to mention the labor of a pencil calculation. Thus, we need a \
method which simplifies the calculation and makes it efficient for a \
computer. Actually, there exists a way to derive the extensions of a vector \
field much quicker."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The calculation of the prolongation of a vector field is simplified if we \
keep the following two points in mind. First, there exists a representation \
of the infinitesimals which simplifies the transformations. This \
representation is known as the characteristics. Second, the differentiation \
process of the prolongation can be eliminated by using the ",
  ButtonBox["Fr\[EAcute]chet derivative",
    ButtonData:>{"derivat.nb", "Definition: Frechet derivative"},
    ButtonStyle->"Hyperlink"],
  ". The combination of these two tools provides us with a procedure to \
overcome the recursive definition of the prolongation."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "calculation of the prolongation", "infinitesimals", "characteristics", 
    "Frechet derivative"}],

Cell[TextData[{
  "Before discussing the implementation of the prolongation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", let us briefly show the equivalence of both formulations. To fix terms, \
we call the first procedure the recursive prolongation formula and the \
second, the Fr\[EAcute]chet prolongation. The first step to prove the \
equivalence of the two methods is the introduction of the characteristics of \
a vector field. The characteristic function of a general vector field is \
defined by (cf. ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ")"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "recursive prolongation", "Frechet prolongation", "characteristics", 
    "characteristic function", "general vector field"}],

Cell[BoxData[
    \(TraditionalForm
    \`Q\_\[Alpha]\  = \ 
      \[Phi]\_\[Alpha]\  - \ 
        \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ 
            \[PartialD]u\^\[Alpha]\/\[PartialD]x\_i, \ \ \ \ \ \[Alpha] = 1, 
    2, \[Ellipsis], \(q . \)\)], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-42"],

Cell[TextData[{
  "If we assume that the characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " depend on the dependent variables and its derivatives, we can write down \
a relation connecting the prolongation of a function \[CapitalDelta] with the \
Fr\[EAcute]chet derivative. The function \[CapitalDelta] is a member of the \
extended manifold and depends on derivatives up to ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "th order. The vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_Q\)]],
  " based on the characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " allows us the inclusion of first-order derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " in the transformation. The connection between the prolongation of ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_Q\)]],
  " and the Fr\[EAcute]chet derivative is given by"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "characteristics", "extended manifold", "manifold", "Frechet derivative", 
    "prolongation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(pr\^\((k)\)\) \(\(v\&\[RightVector]\_Q\)(\[CapitalDelta])\)\  = \ 
      \(\(\[GothicCapitalD]\_\[CapitalDelta]\)(Q) . \)\)], "NumberedEquation",\

  Evaluatable->False,
  CellTags->"eq-43"],

Cell[TextData[{
  "This relation follows from the definition of the prolongation of the \
vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_Q\)]]
}], "Text",
  Evaluatable->False,
  CellTags->"prolongation of the vector field"],

Cell[BoxData[
    FormBox[
      StyleBox[
        \(\(pr\^\((k)\)\) \(v\& \[RightVector] \)\_Q\  = \ 
          \[Sum]\+\(\[Alpha] = 1\)\%p\[Sum]\+J\(D\_J\) \(Q\_\[Alpha]\) 
              \[PartialD]\/\[PartialD]u\_J\%\[Alpha], \),
        ScriptLevel->0], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-44"],

Cell[TextData[{
  "where, in general, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[
                RowBox[{
                  FormBox[\(Q\_\[Alpha]\),
                    "TraditionalForm"], "=", \(Q\_\[Alpha]\)}],
                "TraditionalForm"], \((u\^\((k)\)\)}],
            "TraditionalForm"], ")"}], TraditionalForm]], "InlineFormula"],
  " depends on derivatives up to order ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1, \[Ellipsis]\)]],
  ". If, in addition, we use the definition of the ",
  ButtonBox["Fr\[EAcute]chet derivative,",
    ButtonData:>{"derivat.nb", "Definition: Fr\[EAcute]chet derivative"},
    ButtonStyle->"Hyperlink"],
  " introduced in S",
  ButtonBox["ection 3.5",
    ButtonData:>{"derivat.nb", "Definition: Frechet derivative"},
    ButtonStyle->"Hyperlink"],
  ", we are able to reproduce equation ",
  ButtonBox["(3.65)",
    ButtonData:>"eq-43",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "Relations ",
  ButtonBox["(3.63)",
    ButtonData:>"eq-42",
    ButtonStyle->"Hyperlink"],
  " allows us to calculate the ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "th expansion coefficient of the prolongation by a total differentiation"
}], "Text",
  Evaluatable->False,
  CellTags->"expansion coefficient of the prolongation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(\[Phi]\_\[Alpha]\%J\),
          "TraditionalForm"], " ", "=", " ", 
        RowBox[{
          
          FormBox[\(\(D\_J\) Q\_\[Alpha]\  + \ 
              \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ u\_\(J, i\)\%\[Alpha]\),
            "TraditionalForm"], "."}]}], TraditionalForm]], "NumberedEquation",\

  Evaluatable->False],

Cell[TextData[{
  "Substituting this expression for the general representation of the \
prolongation formula ",
  ButtonBox["(3.62)",
    ButtonData:>"eq-40",
    ButtonStyle->"Hyperlink"],
  " and rearranging terms in the sums, we get"
}], "Text",
  Evaluatable->False,
  CellTags->"prolongation formula"],

Cell[BoxData[
    \(TraditionalForm
    \`\(pr\^\((k)\)\) \(v\& \[RightVector] \)\  = \ 
      \[Sum]\+\(\[Alpha] = 1\)\%q\[Sum]\+J\( D\_J\) \(Q\_\[Alpha]\) 
            \[PartialD]\/\[PartialD]u\_J\%\[Alpha]\  + 
        \(\(\ \[Sum]\)\+\(i = 1\)\%q\) \[Xi]\_i\ 
          \({\(\[PartialD]\/\[PartialD]x\_i\) 
                \(\[Sum]\+\(\[Alpha] = 1\)\%q\[Sum]\+J
                    \( u\_\(J, i\)\%\[Alpha]\) 
                    \[PartialD]\/\[PartialD]u\_J\%\[Alpha]\)} . \)\)], 
  "NumberedEquation",
  Evaluatable->False],

Cell["\<\
A comparison of the terms in curly brackets with the definition of \
the total derivative\
\>", "Text",
  Evaluatable->False,
  CellTags->"total derivative"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(D\_i\) f\), " ", "=", " ", 
        RowBox[{
          StyleBox[\(\[PartialD]f\/\[PartialD]x\_i\),
            ScriptLevel->0], " ", "+", " ", 
          \(\[Sum]\+\(\[Alpha] = 1\)\%q\[Sum]\+J\( u\_\(J, i\)\%\[Alpha]\) 
              \[PartialD]f\/\[PartialD]u\_J\%\[Alpha]\)}]}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell["shows that we can replace the prolongation (3.62)  by", "Text",
  Evaluatable->False,
  CellTags->"prolongation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(pr\^\((k)\)\) \(v\& \[RightVector] \)\  = \ 
      \(pr\^\((k)\)\) \(v\& \[RightVector] \)\_Q\  + \ 
        \[Sum]\+\(i = 1\)\%p\( \[Xi]\_i\) D\_i, \)\)], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where we used definition ",
  ButtonBox["(3.66)",
    ButtonData:>"eq-44",
    ButtonStyle->"Hyperlink"],
  " to express the ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "th prolongation of ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_Q\)]],
  ". If we now use relation ",
  ButtonBox["(3.65)",
    ButtonData:>"eq-43",
    ButtonStyle->"Hyperlink"],
  ", we can express the prolongation of a vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " by the Fr\[EAcute]chet derivative as"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\(pr\^\((k)\)\) \(v\& \[RightVector] \)\  = \ 
      \(\[GothicCapitalD]\_\[CapitalDelta]\)(Q)\  + \ 
        \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ D\_i . \)], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Thus, we demonstrated the equivalence of the two methods. Both procedures \
are available in the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The advantage of relation (3.71) is that the prolongation of a vector \
field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " is free of any recursion. If we replace the characteristics by their \
infinitesimal representations, we get a formula which contains all the \
necessary information:"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "characteristics", "infinitesimal representation of characteristics"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(pr\^\((k)\)\) \(v\& \[RightVector] \)\), " ", "=", " ", 
        RowBox[{\(\(\[GothicCapitalD]\_\[CapitalDelta]\)(Q)\), 
          SubscriptBox["\[VerticalSeparator]", 
            RowBox[{\(Q\_\[Alpha]\), " ", "=", " ", 
              RowBox[{\(\[Phi]\_\[Alpha]\), " ", 
                StyleBox["-",
                  FontSize->7], 
                StyleBox[" ",
                  FontSize->7], 
                RowBox[{
                  StyleBox[\(\[Sum]\+\(i = 1\)\%p\),
                    ScriptLevel->2,
                    FontSize->7], 
                  \(\[Xi]\_i\ 
                    \[PartialD]u\^\[Alpha]\/\[PartialD]x\_i\)}]}]}]], 
          RowBox[{"+", " ", 
            RowBox[{
              StyleBox[
                UnderoverscriptBox[
                  StyleBox["\[Sum]",
                    ScriptLevel->1,
                    FontSize->19], \(i = 1\), "p"],
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontTracking->"Plain",
                FontVariations->{"Underline"->False,
                "Outline"->False,
                "Shadow"->False,
                "StrikeThrough"->False,
                "Masked"->False,
                "CompatibilityType"->0,
                "RotationAngle"->0}], \(\[Xi]\_i\ D\_i . \)}]}]}]}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"eq-50"],

Cell[TextData[{
  "Relation (3.72) seems very complicated at first glance. This formula is \
awkward if we do the calculation by hand. However, using a computer, (3.72) \
is just the expression we need. From a computational point of view, equation \
(3.72) contains simple operations. These operations are differentiation, \
summation, and a substitution. Each one of these operations is carried out by \
a computer very efficiently. Another advantage of calculating the \
prolongation of a vector field using (3.72) is the flexibility of its \
application. We can also use this formula to calculate the prolongation in \
connection with Lie-B\[ADoubleDot]cklund symmetries. This type of symmetries \
is discussed in C",
  ButtonBox["hapter 9.",
    ButtonData:>{"Symmet75.nb", None},
    ButtonStyle->"Hyperlink"],
  " "
}], "Text",
  Evaluatable->False,
  CellTags->{
  "prolongation", "calculate the prolongation", 
    "Lie-B\[ADoubleDot]cklund symmetries"}],

Cell[TextData[{
  "The implementation of the prolongation follows formula ",
  ButtonBox["(3.72) very closely",
    ButtonData:>"eq-50",
    ButtonStyle->"Hyperlink"],
  ". The following lines show how the prolongation is implemented in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The prolongation function is based on the function ",
  StyleBox["FrechetD[]", "MmaText"],
  ". For the correct work of ",
  StyleBox["Prolongation[],", "MmaText"],
  " it is thus necessary that the ",
  ButtonBox["Fr\[EAcute]chet derivative",
    ButtonData:>{"derivat.nb", "FrechetD"},
    ButtonStyle->"Hyperlink"],
  " is also available. The function ",
  StyleBox["Prolongation[]", "MmaText"],
  " is based on the differentiation and substitutions as represented in \
(3.72). The function itself needs three arguments. The first argument \
represents the function on which the prolongation is applied. The second and \
third arguments contain the sets of dependent and independent variables of \
the manifold. All three arguments are lists. The result is a general \
expression of the infinitesimals representing the ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "th prolongation. The order ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " of the prolongation is determined by the function itself. The symbolic \
names for the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  " are also created by the function itself."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "Prolongation[]", "Frechet derivative", "symbolic names of infinitesimals"}],

Cell[BoxData[{
    \(\(Clear[Prolongation];\)\), "\n", 
    \(Prolongation[equations_List, \n\tdepend_List, independ_List] := \n\t
      Block[{Depend = {}, vars, test = {}, \n\t\t\teta = {}, subrule = {}, 
          prol = {}, \n\t\t\tprolong, mainrule, xyzt, wxc, 
          uvw}, \n\t\tDo[\n\t\t\tAppendTo[
            Depend, \n\t\t\t\tdepend\[LeftDoubleBracket]
                i\[RightDoubleBracket] @@ independ], \n\t\t\t{i, 1, 
            Length[depend]}]; \n\ 
        vars = Flatten[Join[independ, Depend]]; \n\t\tDo[
          AppendTo[
            eta, \n\t\t\t\tphi[i] @@ 
                vars - \[IndentingNewLine]\[Sum]\+\(j = \
1\)\%\(Length[independ]\)xi[j] @@ 
                    vars\ \ \[PartialD]\_\(independ\[LeftDoubleBracket]j\
\[RightDoubleBracket]\)Depend\[LeftDoubleBracket]
                      i\[RightDoubleBracket]], \n\t\t\t{i, 1, 
            Length[depend]}]; \n\t\tDo[
          AppendTo[test, \n\t\t\t\tUnique["\<w$t\>"]], \n\t\t\t{i, 1, 
            Length[Depend]}]; \n\t\tmainrule = 
          wxc \[Rule] Function[xyzt, uvw]; \n\t\tDo[
          AppendTo[subrule, 
            mainrule /. \n\t\t\t\t\t{wxc \[Rule] 
                  test\[LeftDoubleBracket]
                    i\[RightDoubleBracket], \n\t\t\t\t\t\tuvw \[Rule] 
                  eta\[LeftDoubleBracket]
                    i\[RightDoubleBracket], \n\t\t\t\t\t\txyzt \[Rule] 
                  independ}], \n\t\t\t{i, 1, Length[eta]}]; \n\t\tprolong = 
          FrechetD[equations, \n\t\t\t\tdepend, independ, 
            test]; \n\t\tprolong = 
          Expand[prolong /. subrule]; \n\t\tprolong = 
          Apply[Plus, prolong, 1]; \n\t\tDo[\n\t\t\tAppendTo[
            prol, \n\t\t\t\tExpand[
              prolong\[LeftDoubleBracket]
                  j\[RightDoubleBracket] + \n\t\t\t\t\t\t\[Sum]\+\(i = \
1\)\%\(Length[independ]\)xi[i] @@ 
                      vars\ \ \[IndentingNewLine]\[PartialD]\_\(independ\
\[LeftDoubleBracket]i\[RightDoubleBracket]\)equations]], \n\t\t\t{j, 1, 
            Length[prolong]}]; \n\t\tFlatten[prol]]\)}], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  CellTags->{"Function Prolongation", "Prolongation[]"}],

Cell[TextData[{
  "Now, we can use this function to check our interactive calculations given \
above. By applying the function ",
  StyleBox["Prolongation[]", "MmaText",
    Background->None],
  StyleBox[" ", "MmaText"],
  "to an arbitrary function depending on one independent and one dependent \
variable and its derivative, we can check our calculations. Since the \
function ",
  StyleBox["Prolongation[]", "MmaText",
    Background->None],
  " uses the Fr\[EAcute]chet derivative in the calculation, it is not \
necessary to specify the highest order of derivatives. The function \
automatically detects the order of the derivative. The application of ",
  StyleBox["Prolongation[]", "MmaText"],
  " to the simple example discussed above gives us"
}], "Text",
  Evaluatable->False,
  CellTags->{"Prolongation[]", "Frechet derivative"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(prolongation\  = \ 
      Prolongation[{f[x, u[x], \[PartialD]\_x u[x]]}, {u}, {x}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "-", 
        RowBox[{
          SuperscriptBox[
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "2"], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "-", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{\(\(phi[1]\)[x, u[x]]\), " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{\(\(xi[1]\)[x, u[x]]\), " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((1, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we compare this result with the result obtained by the interactive \
calculation, we detect a complete equivalence. The result created by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is difficult to read. The prolongation becomes more readable if we apply \
the function ",
  StyleBox["LieTraditionalForm[]",
    CellFrame->True,
    Background->None],
  " to the result of the above calculation."
}], "Text",
  Evaluatable->False,
  CellTags->"LieTraditionalForm[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(prolongation\  // \ LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({f\_x\ \[Xi]\_1 + f\_u\ \[Phi]\_1 - 
        f\_\(u\_x\)\ u\_x\%2\ \((\[Xi]\_1)\)\_u - 
        f\_\(u\_x\)\ u\_x\ \((\[Xi]\_1)\)\_x + 
        f\_\(u\_x\)\ u\_x\ \((\[Phi]\_1)\)\_u + 
        f\_\(u\_x\)\ \((\[Phi]\_1)\)\_x}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["LieTraditionalForm[]", "MmaText"],
  " uses the variable ",
  StyleBox["TraditionalLieForm", "MmaText",
    CellFrame->True,
    Background->None],
  " containing rules to transform dependent variables and their derivatives \
to a shorthand notation. This representation uses subscripts to denote \
differentiations and suppresses the arguments of the functions. The result of \
the transformation is shorter and contains the information in condensed form. \
The representation reminds one of the traditional mathematical notation but \
is not usable by ",
  StyleBox["Mathematica. ",
    FontSlant->"Italic"],
  "An abbreviation for ",
  StyleBox["LieTraditionalForm[]", "MmaText"],
  " is ",
  StyleBox["LTF[]", "MmaText"],
  ". This function additionally represents the argument as equations in a \
table. Both functions deliver easy-to-read output but are inconsistent with ",
  
  StyleBox["Mathematica'",
    FontSlant->"Italic"],
  "s notation",
  StyleBox[".",
    FontSlant->"Italic"],
  " However, we can solve this notational inconsistency for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by storing the result of ",
  StyleBox["Prolongation[]", "MmaText",
    Background->None],
  " into the variable ",
  StyleBox["prolongation",
    CellFrame->True,
    Background->None],
  " and suppressing the output. Afterward, we apply the rules ",
  StyleBox["TraditionalLieForm", "MmaText",
    Background->None],
  " to that variable. In this way, we gain both a consistent representation \
in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and a condensed representation of the result. We will demonstrate this \
procedure by calculating higher-order prolongations. We can use the function \
",
  StyleBox["Prolongation[]", "MmaText",
    Background->None],
  " in a manner as simple as in the previous example. The result for the \
second extension of a vector field reads"
}], "Text",
  CellTags->{
  "Prolongation[]", "TraditionalLieForm", "LieTraditionalForm[]", 
    "higher order prolongations", "vector field", "LTF[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(secondProlongation\  = \ 
      Prolongation[{
          f[x, u[x], \[PartialD]\_{x, 1}u[x], \[PartialD]\_{x, 2}u[x]]}, \n
        \t{u}, {x}]; \ secondProlongation\  // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({f\_x\ \[Xi]\_1 + f\_u\ \[Phi]\_1 - 
        f\_\(u\_x\)\ u\_x\%2\ \((\[Xi]\_1)\)\_u - 
        f\_\(u\_x\)\ u\_x\ \((\[Xi]\_1)\)\_x + 
        f\_\(u\_x\)\ u\_x\ \((\[Phi]\_1)\)\_u + 
        f\_\(u\_x\)\ \((\[Phi]\_1)\)\_x - 
        3\ f\_\(u\_\(x, x\)\)\ u\_x\ \((\[Xi]\_1)\)\_u\ u\_\(x, x\) - 
        2\ f\_\(u\_\(x, x\)\)\ \((\[Xi]\_1)\)\_x\ u\_\(x, x\) + 
        f\_\(u\_\(x, x\)\)\ \((\[Phi]\_1)\)\_u\ u\_\(x, x\) - 
        f\_\(u\_\(x, x\)\)\ u\_x\%3\ \((\[Xi]\_1)\)\_\(u, u\) - 
        2\ f\_\(u\_\(x, x\)\)\ u\_x\%2\ \((\[Xi]\_1)\)\_\(x, u\) - 
        f\_\(u\_\(x, x\)\)\ u\_x\ \((\[Xi]\_1)\)\_\(x, x\) + 
        f\_\(u\_\(x, x\)\)\ u\_x\%2\ \((\[Phi]\_1)\)\_\(u, u\) + 
        2\ f\_\(u\_\(x, x\)\)\ u\_x\ \((\[Phi]\_1)\)\_\(x, u\) + 
        f\_\(u\_\(x, x\)\)\ \((\[Phi]\_1)\)\_\(x, x\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Applying the transformation to the variable ",
  StyleBox["secondProlongation",
    Background->None],
  " delivers the shorthand notation. Multiple differentiations of the \
dependent variables are denoted by subscripts separated by commas. However, \
the variable ",
  StyleBox["secondProlongation ",
    Background->None],
  "contains the full ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representation of the result. We can display the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(secondProlongation\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "-", 
        RowBox[{"3", " ", 
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox["u", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{
          SuperscriptBox[
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "2"], " ", 
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 2)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "-", 
        RowBox[{
          SuperscriptBox[
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "3"], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((0, 2)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "-", 
        RowBox[{"2", " ", 
          RowBox[{
            SuperscriptBox["u", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{"2", " ", 
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((1, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "-", 
        RowBox[{"2", " ", 
          SuperscriptBox[
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "2"], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((1, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((2, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "-", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((2, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "-", 
        RowBox[{
          SuperscriptBox[
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "2"], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "-", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, u[x]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{\(\(phi[1]\)[x, u[x]]\), " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 1, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "+", 
        RowBox[{\(\(xi[1]\)[x, u[x]]\), " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((1, 0, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", \(u[x]\), ",", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "]"}]}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The application of a prolonged vector field to a differential \
expression is used extensively in the symmetry analysis of differential \
equations. Let us demonstrate the application of this function by two \
examples.\
\>", "Text",
  Evaluatable->False,
  CellTags->"symmetry analysis of differential equations"],

Cell["Example 1", "Example"],

Cell["\<\
Assume that we know that the infinitesimal flow is given by a \
rotation in the plane:\
\>", "Text",
  Evaluatable->False,
  CellTags->"infinitesimal flow"],

Cell[BoxData[
    \(\(flows = {xi[1] \[Rule] Function[{x, y}, \(-y[x]\)], \n\t\t
        phi[1] \[Rule] Function[{x, y}, x]}; \)\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "We are interested in the behavior of the differential expression ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalDelta] = \ \[PartialD]\^2\( y(x)\)/\[PartialD]x\^2\)]],
  " under this kind of flow. First, we will calculate the prolongation of \
\[CapitalDelta] by using the function ",
  StyleBox["Prolongation[]", "MmaText"],
  ". "
}], "Text",
  Evaluatable->False,
  CellTags->{"prolongation", "Prolongation[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(prol2 = Prolongation[{\[PartialD]\_{x, 2}y[x]}, {y}, {x}]; 
    prol2 // LieTraditionalForm\ \)\)], "Input"],

Cell[BoxData[
    \({\(-2\)\ \((\[Xi]\_1)\)\_x\ y\_\(x, x\) - 
        3\ y\_x\ \((\[Xi]\_1)\)\_y\ y\_\(x, x\) + 
        \((\[Phi]\_1)\)\_y\ y\_\(x, x\) - y\_x\ \((\[Xi]\_1)\)\_\(x, x\) - 
        2\ y\_x\%2\ \((\[Xi]\_1)\)\_\(x, y\) - 
        y\_x\%3\ \((\[Xi]\_1)\)\_\(y, y\) + \((\[Phi]\_1)\)\_\(x, x\) + 
        2\ y\_x\ \((\[Phi]\_1)\)\_\(x, y\) + 
        y\_x\%2\ \((\[Phi]\_1)\)\_\(y, y\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an expression containing a combination of derivatives for \
the ",
  Cell[BoxData[
      \(TraditionalForm\`infinitesimals\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  " and the dependent variables. The prolongation of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " is simplified if we insert the known representation of the flow"
}], "Text",
  Evaluatable->False,
  CellTags->{"infinitesimals", "prolongation of the vector field"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(prol2 /. y[x] \[Rule] y\) /. flows // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({3\ y\_x\ y\_\(x, x\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is that the prolongation of ",
  Cell[BoxData[
      \(TraditionalForm\`\(y'\)'\)]],
  " under a rotation results into an expression which is closely related to \
the original expression \[CapitalDelta]. We will later show that the result \
derived is a consequence of the symmetry group of the equation ",
  Cell[BoxData[
      \(TraditionalForm\`\(y'\)' = 0. \)]],
  "\[ThickSpace]\[EmptySquare]"
}], "Text",
  CellTags->"symmetry group"],

Cell["Example 2", "Example"],

Cell[TextData[{
  "Another example invariant under the given flow is given by the following \
example. The differential expression \[CapitalDelta] reads ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalDelta]", " ", "=", " ", 
          RowBox[{\(\(y'\)'\), " ", 
            FormBox[\(\((1 + y'\^2)\)\^\(\(-3\)/2\)\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". The corresponding prolongation of \[CapitalDelta] under the condition of \
the symmetry of rotation is"
}], "Text",
  Evaluatable->False,
  CellTags->"symmetry of rotation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
      \(Prolongation[{
              \[PartialD]\_{x, 2}y[x]\ 
                \((1 + \((\[PartialD]\_x y[x])\)\^2)\)\^\(\(-3\)/2\)}, {y}, {
              x}] /. y[x] \[Rule] y\) /. flows]\)], "Input"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result shows that the prolongation of the expression ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{
            FormBox[
              RowBox[{
                StyleBox[
                  FormBox[
                    SubscriptBox["y", 
                      StyleBox[
                        RowBox[{
                          StyleBox["x",
                            FontSlant->"Italic"], "x"}]]],
                    "TraditionalForm"],
                  FontSlant->"Italic"], "(", \(1 + y\_x\%2\)}],
              "TraditionalForm"], ")"}], \(\(-3\)/2\)], TraditionalForm]]],
  " under an infinitesimal rotations vanishes.\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False],

Cell["\<\
So far, we discussed the basic tools of symmetry analysis. The \
following chapters will show you how these tools are used to find the \
symmetries of functions and differential equations.\
\>", "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet1.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
AutoGeneratedPackage->Automatic,
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
Evaluator->"Local",
WindowSize->{719, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->61,
PrintingPageRange->{74, 74},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Derivatives", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"The Euler Derivative", 
                "Prolongation of Vector Fields"}, #]&)], FontSlant -> 
            "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageFooters->{{Inherited, None, Inherited}, {Inherited, None, Inherited}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->True,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
TextAlignment->Left,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
PrivateFontOptions->{"FontType"->"Outline"},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "The Euler derivative"->{
    Cell[1739, 51, 379, 6, 52, "Section",
      Evaluatable->False,
      CounterAssignments->{{"Title", 3}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 22}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"The Euler derivative"]},
  "calculus of variations"->{
    Cell[2121, 59, 1379, 27, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "calculus of variations", "Euler", "Lagrange", 
        "Euler-Lagrange equations", "dynamical equations", 
        "generalized symmetries"}],
    Cell[3643, 94, 1229, 23, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "Bernoulli", "brachystochrone problem", "Leibniz", 
        "calculus of variations"}],
    Cell[4875, 119, 2126, 52, 285, "Text",
      Evaluatable->False,
      PageBreakWithin->True,
      CellTags->{
      "Hamilton", "minimum principle", "calculus of variations", 
        "generating functional", "minimize", "higher derivatives", 
        "functional"}]},
  "Euler"->{
    Cell[2121, 59, 1379, 27, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "calculus of variations", "Euler", "Lagrange", 
        "Euler-Lagrange equations", "dynamical equations", 
        "generalized symmetries"}]},
  "Lagrange"->{
    Cell[2121, 59, 1379, 27, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "calculus of variations", "Euler", "Lagrange", 
        "Euler-Lagrange equations", "dynamical equations", 
        "generalized symmetries"}]},
  "Euler-Lagrange equations"->{
    Cell[2121, 59, 1379, 27, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "calculus of variations", "Euler", "Lagrange", 
        "Euler-Lagrange equations", "dynamical equations", 
        "generalized symmetries"}]},
  "dynamical equations"->{
    Cell[2121, 59, 1379, 27, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "calculus of variations", "Euler", "Lagrange", 
        "Euler-Lagrange equations", "dynamical equations", 
        "generalized symmetries"}]},
  "generalized symmetries"->{
    Cell[2121, 59, 1379, 27, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "calculus of variations", "Euler", "Lagrange", 
        "Euler-Lagrange equations", "dynamical equations", 
        "generalized symmetries"}]},
  "The Problem of Variations"->{
    Cell[3525, 90, 115, 2, 49, "Subsection",
      Evaluatable->False,
      CellTags->"The Problem of Variations"]},
  "Bernoulli"->{
    Cell[3643, 94, 1229, 23, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "Bernoulli", "brachystochrone problem", "Leibniz", 
        "calculus of variations"}],
    Cell[87272, 2815, 1424, 34, 204, "Text",
      Evaluatable->False,
      CellTags->{
      "brachystochrone", "Bernoulli", "Euler equation", "functional density", 
        "line element", "velocity", "Cartesian coordinates"}]},
  "brachystochrone problem"->{
    Cell[3643, 94, 1229, 23, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "Bernoulli", "brachystochrone problem", "Leibniz", 
        "calculus of variations"}]},
  "Leibniz"->{
    Cell[3643, 94, 1229, 23, 222, "Text",
      Evaluatable->False,
      PageBreakBelow->False,
      CellTags->{
      "Bernoulli", "brachystochrone problem", "Leibniz", 
        "calculus of variations"}]},
  "Hamilton"->{
    Cell[4875, 119, 2126, 52, 285, "Text",
      Evaluatable->False,
      PageBreakWithin->True,
      CellTags->{
      "Hamilton", "minimum principle", "calculus of variations", 
        "generating functional", "minimize", "higher derivatives", 
        "functional"}]},
  "minimum principle"->{
    Cell[4875, 119, 2126, 52, 285, "Text",
      Evaluatable->False,
      PageBreakWithin->True,
      CellTags->{
      "Hamilton", "minimum principle", "calculus of variations", 
        "generating functional", "minimize", "higher derivatives", 
        "functional"}]},
  "generating functional"->{
    Cell[4875, 119, 2126, 52, 285, "Text",
      Evaluatable->False,
      PageBreakWithin->True,
      CellTags->{
      "Hamilton", "minimum principle", "calculus of variations", 
        "generating functional", "minimize", "higher derivatives", 
        "functional"}]},
  "minimize"->{
    Cell[4875, 119, 2126, 52, 285, "Text",
      Evaluatable->False,
      PageBreakWithin->True,
      CellTags->{
      "Hamilton", "minimum principle", "calculus of variations", 
        "generating functional", "minimize", "higher derivatives", 
        "functional"}]},
  "higher derivatives"->{
    Cell[4875, 119, 2126, 52, 285, "Text",
      Evaluatable->False,
      PageBreakWithin->True,
      CellTags->{
      "Hamilton", "minimum principle", "calculus of variations", 
        "generating functional", "minimize", "higher derivatives", 
        "functional"}]},
  "functional"->{
    Cell[4875, 119, 2126, 52, 285, "Text",
      Evaluatable->False,
      PageBreakWithin->True,
      CellTags->{
      "Hamilton", "minimum principle", "calculus of variations", 
        "generating functional", "minimize", "higher derivatives", 
        "functional"}],
    Cell[9846, 260, 2594, 85, 264, "Text",
      Evaluatable->False,
      CellTags->{
      "functional", "extreme", "test function", "parametric representation", 
        "small perturbation"}],
    Cell[18431, 561, 892, 27, 117, "Text",
      Evaluatable->False,
      CellTags->{"slope", "functional", "test function"}],
    Cell[21720, 670, 299, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"Plot[]", "functional"}],
    Cell[68797, 2261, 245, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"functional"],
    Cell[76422, 2496, 573, 21, 33, "Text",
      CellTags->"functional"],
    Cell[99993, 3216, 1132, 34, 75, "Text",
      Evaluatable->False,
      CellTags->{"functional", "Euler operator"}],
    Cell[110218, 3524, 1419, 49, 75, "Text",
      Evaluatable->False,
      CellTags->"functional"]},
  "eq-1"->{
    Cell[7004, 173, 981, 27, 44, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-1"]},
  "eq-2"->{
    Cell[8196, 211, 744, 19, 42, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-2"]},
  "extreme"->{
    Cell[8943, 232, 900, 26, 117, "Text",
      Evaluatable->False,
      CellTags->{"extreme", "maximum", "minimum"}],
    Cell[9846, 260, 2594, 85, 264, "Text",
      Evaluatable->False,
      CellTags->{
      "functional", "extreme", "test function", "parametric representation", 
        "small perturbation"}]},
  "maximum"->{
    Cell[8943, 232, 900, 26, 117, "Text",
      Evaluatable->False,
      CellTags->{"extreme", "maximum", "minimum"}]},
  "minimum"->{
    Cell[8943, 232, 900, 26, 117, "Text",
      Evaluatable->False,
      CellTags->{"extreme", "maximum", "minimum"}],
    Cell[20604, 635, 928, 26, 138, "Text",
      Evaluatable->False,
      CellTags->"minimum"]},
  "test function"->{
    Cell[9846, 260, 2594, 85, 264, "Text",
      Evaluatable->False,
      CellTags->{
      "functional", "extreme", "test function", "parametric representation", 
        "small perturbation"}],
    Cell[18431, 561, 892, 27, 117, "Text",
      Evaluatable->False,
      CellTags->{"slope", "functional", "test function"}],
    Cell[70867, 2324, 1168, 38, 117, "Text",
      Evaluatable->False,
      CellTags->{"functional density", "test function"}],
    Cell[82561, 2696, 331, 11, 26, "ListItem",
      Evaluatable->False,
      CellTags->{"boundary condition", "test function"}]},
  "parametric representation"->{
    Cell[9846, 260, 2594, 85, 264, "Text",
      Evaluatable->False,
      CellTags->{
      "functional", "extreme", "test function", "parametric representation", 
        "small perturbation"}],
    Cell[159724, 5139, 713, 16, 117, "Text",
      Evaluatable->False,
      CellTags->{"parametric representation", "vector field", "Line[]"}]},
  "small perturbation"->{
    Cell[9846, 260, 2594, 85, 264, "Text",
      Evaluatable->False,
      CellTags->{
      "functional", "extreme", "test function", "parametric representation", 
        "small perturbation"}]},
  "eq-3"->{
    Cell[12443, 347, 198, 7, 27, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-3"]},
  "continuous derivative"->{
    Cell[12644, 356, 966, 34, 75, "Text",
      Evaluatable->False,
      CellTags->"continuous derivative"]},
  "variation"->{
    Cell[13613, 392, 409, 14, 54, "Text",
      Evaluatable->False,
      CellTags->"variation"]},
  "eq-4"->{
    Cell[14025, 408, 497, 18, 42, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-4"]},
  "stationary value"->{
    Cell[14525, 428, 295, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"stationary value"]},
  "eq-5"->{
    Cell[14823, 438, 212, 5, 44, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-5"]},
  "necessary condition"->{
    Cell[15038, 445, 717, 17, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "necessary condition", "sufficient condition", 
        "shortest connection between two points", "Euclidean plane"}]},
  "sufficient condition"->{
    Cell[15038, 445, 717, 17, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "necessary condition", "sufficient condition", 
        "shortest connection between two points", "Euclidean plane"}]},
  "shortest connection between two points"->{
    Cell[15038, 445, 717, 17, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "necessary condition", "sufficient condition", 
        "shortest connection between two points", "Euclidean plane"}],
    Cell[67552, 2220, 301, 7, 54, "Text",
      CellTags->"shortest connection between two points"]},
  "Euclidean plane"->{
    Cell[15038, 445, 717, 17, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "necessary condition", "sufficient condition", 
        "shortest connection between two points", "Euclidean plane"}]},
  "Euclidean space"->{
    Cell[15789, 466, 484, 14, 75, "Text",
      Evaluatable->False,
      CellTags->{"Euclidean space", "geometrical increment"}]},
  "geometrical increment"->{
    Cell[15789, 466, 484, 14, 75, "Text",
      Evaluatable->False,
      CellTags->{"Euclidean space", "geometrical increment"}]},
  "eq-6"->{
    Cell[16276, 482, 983, 28, 52, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-6"]},
  "total length between two points"->{
    Cell[17262, 512, 327, 13, 33, "Text",
      Evaluatable->False,
      CellTags->"total length between two points"]},
  "eq-7"->{
    Cell[17592, 527, 332, 9, 45, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-7"]},
  "straight line"->{
    Cell[17927, 538, 183, 5, 54, "Text",
      Evaluatable->False,
      CellTags->"straight line"]},
  "eq-8"->{
    Cell[18113, 545, 315, 14, 27, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-8"]},
  "slope"->{
    Cell[18431, 561, 892, 27, 117, "Text",
      Evaluatable->False,
      CellTags->{"slope", "functional", "test function"}]},
  "eq-10"->{
    Cell[20066, 617, 535, 16, 43, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-10"]},
  "Plot[]"->{
    Cell[21720, 670, 299, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"Plot[]", "functional"}]},
  "Euler's Equation"->{
    Cell[67890, 2232, 125, 2, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Euler's Equation"]},
  "Euler derivative"->{
    Cell[68018, 2236, 495, 15, 75, "Text",
      Evaluatable->False,
      CellTags->"Euler derivative"],
    Cell[83188, 2721, 1173, 25, 180, "Text",
      Evaluatable->False,
      CellTags->{"Euler derivative", "EulerD[]"}],
    Cell[105376, 3365, 490, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "two-dimensional oscillator system", "oscillators", "Lagrange density", 
        "equations of motion", "Euler derivative"}],
    Cell[108496, 3473, 677, 14, 117, "Text",
      Evaluatable->False,
      CellTags->{"point system", "Euler derivative", "Euler operator"}],
    Cell[122167, 3907, 765, 13, 117, "Text",
      CellTags->{
      "tangent vector", "prolongation", "Frechet derivative", 
        "Euler derivative", "non-standard differential operators", 
        "symmetry analysis of differential equations", 
        "differential operators"}]},
  "eq-12"->{
    Cell[69045, 2271, 582, 13, 48, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-12"]},
  "representation"->{
    Cell[69630, 2286, 417, 14, 54, "Text",
      Evaluatable->False,
      CellTags->"representation"]},
  "eq-14"->{
    Cell[70428, 2312, 436, 10, 48, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-14"]},
  "functional density"->{
    Cell[70867, 2324, 1168, 38, 117, "Text",
      Evaluatable->False,
      CellTags->{"functional density", "test function"}],
    Cell[79546, 2607, 1552, 40, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "partial derivative", "ordinary derivative", "functional density", 
        "functional derivative", "Euler equation", "algorithmic procedure"}],
    Cell[82238, 2686, 320, 8, 45, "ListItem",
      Evaluatable->False,
      CellTags->"functional density"],
    Cell[87272, 2815, 1424, 34, 204, "Text",
      Evaluatable->False,
      CellTags->{
      "brachystochrone", "Bernoulli", "Euler equation", "functional density", 
        "line element", "velocity", "Cartesian coordinates"}],
    Cell[89558, 2877, 376, 12, 54, "Text",
      Evaluatable->False,
      CellTags->{"EulerD[]", "functional density"}],
    Cell[91090, 2936, 458, 9, 75, "Text",
      CellTags->{
      "EulerD[]", "Euler-Lagrange equation", "mechanical system", 
        "functional density", "Lagrange function"}]},
  "eq-15"->{
    Cell[72038, 2364, 623, 16, 48, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-15"]},
  "Euler equation"->{
    Cell[75047, 2457, 772, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "Euler equation", "Euler-Lagrange equation", "Euler operator"}],
    Cell[79546, 2607, 1552, 40, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "partial derivative", "ordinary derivative", "functional density", 
        "functional derivative", "Euler equation", "algorithmic procedure"}],
    Cell[82895, 2709, 290, 10, 26, "ListItem",
      Evaluatable->False,
      CellTags->"Euler equation"],
    Cell[87272, 2815, 1424, 34, 204, "Text",
      Evaluatable->False,
      CellTags->{
      "brachystochrone", "Bernoulli", "Euler equation", "functional density", 
        "line element", "velocity", "Cartesian coordinates"}],
    Cell[109561, 3506, 442, 8, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "Maxwell equation", "Schr\[ODoubleDot]dinger equation", 
        "Euler equation", "hydrodynamics"}],
    Cell[112688, 3614, 700, 24, 75, "Text",
      Evaluatable->False,
      CellTags->"Euler equation"],
    Cell[117905, 3754, 245, 5, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "variational derivative", "Euler equation", "Laplace equation"}]},
  "Euler-Lagrange equation"->{
    Cell[75047, 2457, 772, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "Euler equation", "Euler-Lagrange equation", "Euler operator"}],
    Cell[91090, 2936, 458, 9, 75, "Text",
      CellTags->{
      "EulerD[]", "Euler-Lagrange equation", "mechanical system", 
        "functional density", "Lagrange function"}],
    Cell[91762, 2957, 341, 10, 54, "Text",
      CellTags->{"Euler-Lagrange equation", "Lagrangian"}],
    Cell[95379, 3071, 170, 3, 33, "Text",
      CellTags->"Euler-Lagrange equation"],
    Cell[107755, 3449, 265, 5, 54, "Text",
      CellTags->{
      "Dirac Lagrangian", "binomial", "Euler-Lagrange equation"}]},
  "Euler operator"->{
    Cell[75047, 2457, 772, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "Euler equation", "Euler-Lagrange equation", "Euler operator"}],
    Cell[75856, 2480, 94, 2, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Euler operator"],
    Cell[75953, 2484, 373, 7, 54, "Text",
      CellTags->{
      "Euler operator", "variational derivative", "dynamical formulation", 
        "statistical mechanics", "special type of derivative"}],
    Cell[95552, 3076, 987, 26, 138, "Text",
      Evaluatable->False,
      CellTags->"Euler operator"],
    Cell[98342, 3161, 235, 6, 54, "Text",
      Evaluatable->False,
      CellTags->"Euler operator"],
    Cell[99993, 3216, 1132, 34, 75, "Text",
      Evaluatable->False,
      CellTags->{"functional", "Euler operator"}],
    Cell[108496, 3473, 677, 14, 117, "Text",
      Evaluatable->False,
      CellTags->{"point system", "Euler derivative", "Euler operator"}]},
  "variational derivative"->{
    Cell[75953, 2484, 373, 7, 54, "Text",
      CellTags->{
      "Euler operator", "variational derivative", "dynamical formulation", 
        "statistical mechanics", "special type of derivative"}],
    Cell[117905, 3754, 245, 5, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "variational derivative", "Euler equation", "Laplace equation"}]},
  "dynamical formulation"->{
    Cell[75953, 2484, 373, 7, 54, "Text",
      CellTags->{
      "Euler operator", "variational derivative", "dynamical formulation", 
        "statistical mechanics", "special type of derivative"}]},
  "statistical mechanics"->{
    Cell[75953, 2484, 373, 7, 54, "Text",
      CellTags->{
      "Euler operator", "variational derivative", "dynamical formulation", 
        "statistical mechanics", "special type of derivative"}]},
  "special type of derivative"->{
    Cell[75953, 2484, 373, 7, 54, "Text",
      CellTags->{
      "Euler operator", "variational derivative", "dynamical formulation", 
        "statistical mechanics", "special type of derivative"}]},
  "Definition: Euler Operator"->{
    Cell[76329, 2493, 90, 1, 38, "Definition",
      CellTags->"Definition: Euler Operator"]},
  "functional derivative"->{
    Cell[78183, 2557, 172, 4, 33, "Text",
      CellTags->"functional derivative"],
    Cell[79546, 2607, 1552, 40, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "partial derivative", "ordinary derivative", "functional density", 
        "functional derivative", "Euler equation", 
        "algorithmic procedure"}]},
  "partial derivative"->{
    Cell[79546, 2607, 1552, 40, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "partial derivative", "ordinary derivative", "functional density", 
        "functional derivative", "Euler equation", 
        "algorithmic procedure"}]},
  "ordinary derivative"->{
    Cell[79546, 2607, 1552, 40, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "partial derivative", "ordinary derivative", "functional density", 
        "functional derivative", "Euler equation", 
        "algorithmic procedure"}]},
  "algorithmic procedure"->{
    Cell[79546, 2607, 1552, 40, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "partial derivative", "ordinary derivative", "functional density", 
        "functional derivative", "Euler equation", 
        "algorithmic procedure"}]},
  "Algorithm used in the Calculus of Variations"->{
    Cell[81135, 2652, 180, 3, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Algorithm used in the Calculus of Variations"]},
  "algorithm"->{
    Cell[81318, 2657, 588, 13, 96, "Text",
      Evaluatable->False,
      CellTags->"algorithm"]},
  "boundary condition"->{
    Cell[82561, 2696, 331, 11, 26, "ListItem",
      Evaluatable->False,
      CellTags->{"boundary condition", "test function"}]},
  "EulerD[]"->{
    Cell[83188, 2721, 1173, 25, 180, "Text",
      Evaluatable->False,
      CellTags->{"Euler derivative", "EulerD[]"}],
    Cell[84364, 2748, 332, 7, 81, "Input",
      CellTags->"EulerD[]"],
    Cell[89558, 2877, 376, 12, 54, "Text",
      Evaluatable->False,
      CellTags->{"EulerD[]", "functional density"}],
    Cell[91090, 2936, 458, 9, 75, "Text",
      CellTags->{
      "EulerD[]", "Euler-Lagrange equation", "mechanical system", 
        "functional density", "Lagrange function"}],
    Cell[101894, 3279, 1147, 26, 180, "Text",
      Evaluatable->False,
      CellTags->{"EulerD[]", "loop", "generalized Euler operator"}],
    Cell[103044, 3307, 2177, 47, 442, "Input",
      CellTags->"EulerD[]"],
    Cell[106635, 3409, 612, 17, 96, "Text",
      Evaluatable->False,
      CellTags->"EulerD[]"],
    Cell[113763, 3651, 569, 14, 96, "Text",
      Evaluatable->False,
      CellTags->{"general Euler operator", "EulerD[]"}],
    Cell[114335, 3667, 2287, 43, 496, "Input",
      CellTags->"EulerD[]"],
    Cell[118427, 3771, 275, 7, 54, "Text",
      Evaluatable->False,
      CellTags->{"EulerD[]", "pencil calculation"}],
    Cell[119051, 3793, 174, 8, 33, "Text",
      CellTags->"EulerD[]"]},
  "brachistochrone problem"->{
    Cell[86858, 2803, 380, 8, 75, "Text",
      Evaluatable->False,
      CellTags->"brachistochrone problem"]},
  "brachystochrone"->{
    Cell[87272, 2815, 1424, 34, 204, "Text",
      Evaluatable->False,
      CellTags->{
      "brachystochrone", "Bernoulli", "Euler equation", "functional density", 
        "line element", "velocity", "Cartesian coordinates"}]},
  "line element"->{
    Cell[87272, 2815, 1424, 34, 204, "Text",
      Evaluatable->False,
      CellTags->{
      "brachystochrone", "Bernoulli", "Euler equation", "functional density", 
        "line element", "velocity", "Cartesian coordinates"}]},
  "velocity"->{
    Cell[87272, 2815, 1424, 34, 204, "Text",
      Evaluatable->False,
      CellTags->{
      "brachystochrone", "Bernoulli", "Euler equation", "functional density", 
        "line element", "velocity", "Cartesian coordinates"}]},
  "Cartesian coordinates"->{
    Cell[87272, 2815, 1424, 34, 204, "Text",
      Evaluatable->False,
      CellTags->{
      "brachystochrone", "Bernoulli", "Euler equation", "functional density", 
        "line element", "velocity", "Cartesian coordinates"}],
    Cell[195554, 6391, 477, 11, 75, "Text",
      Evaluatable->False,
      CellTags->{"spiral", "tangent vector", "Cartesian coordinates"}]},
  "cycloid"->{
    Cell[90581, 2917, 475, 15, 54, "Text",
      Evaluatable->False,
      CellTags->"cycloid"]},
  "mechanical system"->{
    Cell[91090, 2936, 458, 9, 75, "Text",
      CellTags->{
      "EulerD[]", "Euler-Lagrange equation", "mechanical system", 
        "functional density", "Lagrange function"}]},
  "Lagrange function"->{
    Cell[91090, 2936, 458, 9, 75, "Text",
      CellTags->{
      "EulerD[]", "Euler-Lagrange equation", "mechanical system", 
        "functional density", "Lagrange function"}]},
  "Lagrangian"->{
    Cell[91762, 2957, 341, 10, 54, "Text",
      CellTags->{"Euler-Lagrange equation", "Lagrangian"}]},
  "Hold[]"->{
    Cell[94708, 3048, 384, 10, 75, "Text",
      CellTags->"Hold[]"]},
  "auxiliary function"->{
    Cell[97226, 3126, 327, 9, 54, "Text",
      Evaluatable->False,
      CellTags->"auxiliary function"],
    Cell[309506, 10200, 105, 1, 33, "Text",
      CellTags->"auxiliary function"]},
  "Euler operator for q-dependent variables"->{
    Cell[99781, 3207, 209, 7, 50, "Subsection",
      Evaluatable->False,
      CellTags->"Euler operator for q-dependent variables"]},
  "loop"->{
    Cell[101894, 3279, 1147, 26, 180, "Text",
      Evaluatable->False,
      CellTags->{"EulerD[]", "loop", "generalized Euler operator"}]},
  "generalized Euler operator"->{
    Cell[101894, 3279, 1147, 26, 180, "Text",
      Evaluatable->False,
      CellTags->{"EulerD[]", "loop", "generalized Euler operator"}]},
  "two-dimensional oscillator system"->{
    Cell[105376, 3365, 490, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "two-dimensional oscillator system", "oscillators", "Lagrange density", 
        "equations of motion", "Euler derivative"}]},
  "oscillators"->{
    Cell[105376, 3365, 490, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "two-dimensional oscillator system", "oscillators", "Lagrange density", 
        "equations of motion", "Euler derivative"}]},
  "Lagrange density"->{
    Cell[105376, 3365, 490, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "two-dimensional oscillator system", "oscillators", "Lagrange density", 
        "equations of motion", "Euler derivative"}],
    Cell[120077, 3834, 507, 12, 75, "Text",
      CellTags->{
      "diffusion", "two component nonlinear medium", "Lagrange density"}]},
  "equations of motion"->{
    Cell[105376, 3365, 490, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "two-dimensional oscillator system", "oscillators", "Lagrange density", 
        "equations of motion", "Euler derivative"}]},
  "two-dimensional Lagrangian"->{
    Cell[107281, 3430, 141, 4, 33, "Text",
      CellTags->"two-dimensional Lagrangian"]},
  "Dirac Lagrangian"->{
    Cell[107755, 3449, 265, 5, 54, "Text",
      CellTags->{
      "Dirac Lagrangian", "binomial", "Euler-Lagrange equation"}]},
  "binomial"->{
    Cell[107755, 3449, 265, 5, 54, "Text",
      CellTags->{
      "Dirac Lagrangian", "binomial", "Euler-Lagrange equation"}]},
  "second-order ordinary differential equation"->{
    Cell[108300, 3468, 193, 3, 33, "Text",
      CellTags->"second-order ordinary differential equation"]},
  "point system"->{
    Cell[108496, 3473, 677, 14, 117, "Text",
      Evaluatable->False,
      CellTags->{"point system", "Euler derivative", "Euler operator"}]},
  "Euler operator for (q-p)-dimensions"->{
    Cell[109210, 3492, 348, 12, 50, "Subsection",
      Evaluatable->False,
      CellTags->"Euler operator for (q-p)-dimensions"]},
  "Maxwell equation"->{
    Cell[109561, 3506, 442, 8, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "Maxwell equation", "Schr\[ODoubleDot]dinger equation", 
        "Euler equation", "hydrodynamics"}]},
  "Schr\[ODoubleDot]dinger equation"->{
    Cell[109561, 3506, 442, 8, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "Maxwell equation", "Schr\[ODoubleDot]dinger equation", 
        "Euler equation", "hydrodynamics"}]},
  "hydrodynamics"->{
    Cell[109561, 3506, 442, 8, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "Maxwell equation", "Schr\[ODoubleDot]dinger equation", 
        "Euler equation", "hydrodynamics"}]},
  "Definition: (qp)-dimensional Euler operator"->{
    Cell[110006, 3516, 209, 6, 38, "Definition",
      CellTags->"Definition: (qp)-dimensional Euler operator"]},
  "eq-25"->{
    Cell[111640, 3575, 345, 10, 55, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-25"]},
  "multi index"->{
    Cell[111988, 3587, 697, 25, 54, "Text",
      Evaluatable->False,
      CellTags->"multi index"]},
  "general Euler operator"->{
    Cell[113763, 3651, 569, 14, 96, "Text",
      Evaluatable->False,
      CellTags->{"general Euler operator", "EulerD[]"}]},
  "wave equation"->{
    Cell[116625, 3712, 292, 6, 54, "Text",
      CellTags->{"wave equation", "coupled nonlinear diffusion equations"}]},
  "coupled nonlinear diffusion equations"->{
    Cell[116625, 3712, 292, 6, 54, "Text",
      CellTags->{"wave equation", "coupled nonlinear diffusion equations"}],
    Cell[121862, 3895, 302, 10, 33, "Text",
      CellTags->"coupled nonlinear diffusion equations"]},
  "Laplace equation"->{
    Cell[117905, 3754, 245, 5, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "variational derivative", "Euler equation", "Laplace equation"}]},
  "pencil calculation"->{
    Cell[118427, 3771, 275, 7, 54, "Text",
      Evaluatable->False,
      CellTags->{"EulerD[]", "pencil calculation"}]},
  "diffusion"->{
    Cell[120077, 3834, 507, 12, 75, "Text",
      CellTags->{
      "diffusion", "two component nonlinear medium", "Lagrange density"}]},
  "two component nonlinear medium"->{
    Cell[120077, 3834, 507, 12, 75, "Text",
      CellTags->{
      "diffusion", "two component nonlinear medium", "Lagrange density"}]},
  "tangent vector"->{
    Cell[122167, 3907, 765, 13, 117, "Text",
      CellTags->{
      "tangent vector", "prolongation", "Frechet derivative", 
        "Euler derivative", "non-standard differential operators", 
        "symmetry analysis of differential equations", 
        "differential operators"}],
    Cell[123784, 3944, 2111, 57, 160, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent vector", "independent variables", "curve in parametric form", 
        "three dimensional spiral", "solenoid"}],
    Cell[159262, 5120, 275, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"tangent vector"],
    Cell[195554, 6391, 477, 11, 75, "Text",
      Evaluatable->False,
      CellTags->{"spiral", "tangent vector", "Cartesian coordinates"}],
    Cell[202184, 6591, 916, 24, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "flow equations", "tangent vector", "components of tangent vector", 
        "origin", "initial conditions", "vector field"}],
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}]},
  "prolongation"->{
    Cell[122167, 3907, 765, 13, 117, "Text",
      CellTags->{
      "tangent vector", "prolongation", "Frechet derivative", 
        "Euler derivative", "non-standard differential operators", 
        "symmetry analysis of differential equations", 
        "differential operators"}],
    Cell[123103, 3930, 678, 12, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "symmetry", "symmetries of differential equations", 
        "prolongation", "extension", "Lie theory"}],
    Cell[294045, 9788, 1421, 29, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation", "flow of the vector field", "extension", 
        "one parameter transformation"}],
    Cell[311607, 10254, 906, 30, 54, "Text",
      Evaluatable->False,
      CellTags->"prolongation"],
    Cell[316337, 10390, 1077, 27, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "extended manifold", "manifold", 
        "Frechet derivative", "prolongation"}],
    Cell[321435, 10546, 119, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"prolongation"],
    Cell[324670, 10640, 962, 19, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation", "calculate the prolongation", 
        "Lie-B\[ADoubleDot]cklund symmetries"}],
    Cell[351661, 11330, 446, 11, 54, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "Prolongation[]"}]},
  "Frechet derivative"->{
    Cell[122167, 3907, 765, 13, 117, "Text",
      CellTags->{
      "tangent vector", "prolongation", "Frechet derivative", 
        "Euler derivative", "non-standard differential operators", 
        "symmetry analysis of differential equations", 
        "differential operators"}],
    Cell[314412, 10343, 798, 15, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "calculation of the prolongation", "infinitesimals", "characteristics", 
        "Frechet derivative"}],
    Cell[316337, 10390, 1077, 27, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "extended manifold", "manifold", 
        "Frechet derivative", "prolongation"}],
    Cell[325635, 10661, 1657, 40, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Prolongation[]", "Frechet derivative", 
        "symbolic names of infinitesimals"}],
    Cell[329479, 10746, 840, 18, 138, "Text",
      Evaluatable->False,
      CellTags->{"Prolongation[]", "Frechet derivative"}]},
  "non-standard differential operators"->{
    Cell[122167, 3907, 765, 13, 117, "Text",
      CellTags->{
      "tangent vector", "prolongation", "Frechet derivative", 
        "Euler derivative", "non-standard differential operators", 
        "symmetry analysis of differential equations", 
        "differential operators"}]},
  "symmetry analysis of differential equations"->{
    Cell[122167, 3907, 765, 13, 117, "Text",
      CellTags->{
      "tangent vector", "prolongation", "Frechet derivative", 
        "Euler derivative", "non-standard differential operators", 
        "symmetry analysis of differential equations", 
        "differential operators"}],
    Cell[350967, 11307, 324, 7, 75, "Text",
      Evaluatable->False,
      CellTags->"symmetry analysis of differential equations"]},
  "differential operators"->{
    Cell[122167, 3907, 765, 13, 117, "Text",
      CellTags->{
      "tangent vector", "prolongation", "Frechet derivative", 
        "Euler derivative", "non-standard differential operators", 
        "symmetry analysis of differential equations", 
        "differential operators"}]},
  "Prolongation of vector fields"->{
    Cell[122981, 3926, 119, 2, 52, "Section",
      Evaluatable->False,
      CellTags->"Prolongation of vector fields"]},
  "vector field"->{
    Cell[123103, 3930, 678, 12, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "symmetry", "symmetries of differential equations", 
        "prolongation", "extension", "Lie theory"}],
    Cell[159724, 5139, 713, 16, 117, "Text",
      Evaluatable->False,
      CellTags->{"parametric representation", "vector field", "Line[]"}],
    Cell[202184, 6591, 916, 24, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "flow equations", "tangent vector", "components of tangent vector", 
        "origin", "initial conditions", "vector field"}],
    Cell[211828, 6867, 736, 19, 75, "Text",
      Evaluatable->False,
      CellTags->{"initial condition", "vector field", "manifold"}],
    Cell[221151, 7201, 472, 9, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "global transformation", "rotation", "transformation"}],
    
    Cell[224244, 7298, 890, 23, 96, "Text",
      Evaluatable->False,
      CellTags->"vector field"],
    Cell[227432, 7404, 1104, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "package", "Graphics`PlotField", 
        "grapical representation of vector field", 
        "representation of vector field"}],
    Cell[277800, 9316, 1943, 46, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "smooth function", "transformation", 
        "independent variables", "vector field", "flow", 
        "transformation of independent variables"}],
    Cell[282488, 9453, 1536, 41, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "infinitesimal flow", 
        "first order partial differential operator", "Taylor series"}],
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}],
    Cell[334912, 10896, 2107, 54, 306, "Text",
      CellTags->{
      "Prolongation[]", "TraditionalLieForm", "LieTraditionalForm[]", 
        "higher order prolongations", "vector field", "LTF[]"}]},
  "symmetry"->{
    Cell[123103, 3930, 678, 12, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "symmetry", "symmetries of differential equations", 
        "prolongation", "extension", "Lie theory"}]},
  "symmetries of differential equations"->{
    Cell[123103, 3930, 678, 12, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "symmetry", "symmetries of differential equations", 
        "prolongation", "extension", "Lie theory"}]},
  "extension"->{
    Cell[123103, 3930, 678, 12, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "symmetry", "symmetries of differential equations", 
        "prolongation", "extension", "Lie theory"}],
    Cell[287381, 9589, 588, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{"prolong a manifold", "extend a manifold", "extension"}],
    Cell[294045, 9788, 1421, 29, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation", "flow of the vector field", "extension", 
        "one parameter transformation"}],
    Cell[306769, 10129, 250, 6, 54, "Text",
      Evaluatable->False,
      CellTags->"extension"],
    Cell[310340, 10222, 913, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "second extension", "extension", "higher extension", 
        "recursive definition of extension", "prolongation formula"}]},
  "Lie theory"->{
    Cell[123103, 3930, 678, 12, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "symmetry", "symmetries of differential equations", 
        "prolongation", "extension", "Lie theory"}]},
  "independent variables"->{
    Cell[123784, 3944, 2111, 57, 160, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent vector", "independent variables", "curve in parametric form", 
        "three dimensional spiral", "solenoid"}],
    Cell[277800, 9316, 1943, 46, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "smooth function", "transformation", 
        "independent variables", "vector field", "flow", 
        "transformation of independent variables"}]},
  "curve in parametric form"->{
    Cell[123784, 3944, 2111, 57, 160, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent vector", "independent variables", "curve in parametric form", 
        "three dimensional spiral", "solenoid"}]},
  "three dimensional spiral"->{
    Cell[123784, 3944, 2111, 57, 160, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent vector", "independent variables", "curve in parametric form", 
        "three dimensional spiral", "solenoid"}]},
  "solenoid"->{
    Cell[123784, 3944, 2111, 57, 160, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent vector", "independent variables", "curve in parametric form", 
        "three dimensional spiral", "solenoid"}]},
  "Line[]"->{
    Cell[159724, 5139, 713, 16, 117, "Text",
      Evaluatable->False,
      CellTags->{"parametric representation", "vector field", "Line[]"}]},
  "graphic primitives"->{
    Cell[160688, 5164, 189, 5, 54, "Text",
      Evaluatable->False,
      CellTags->"graphic primitives"]},
  "spiral"->{
    Cell[195554, 6391, 477, 11, 75, "Text",
      Evaluatable->False,
      CellTags->{"spiral", "tangent vector", "Cartesian coordinates"}]},
  "partial differentiation"->{
    Cell[196346, 6415, 736, 14, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "partial differentiation", "partial derivatives", "Cartesian basis", 
        "differential operator in local coordinates"}]},
  "partial derivatives"->{
    Cell[196346, 6415, 736, 14, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "partial differentiation", "partial derivatives", "Cartesian basis", 
        "differential operator in local coordinates"}]},
  "Cartesian basis"->{
    Cell[196346, 6415, 736, 14, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "partial differentiation", "partial derivatives", "Cartesian basis", 
        "differential operator in local coordinates"}],
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}]},
  "differential operator in local coordinates"->{
    Cell[196346, 6415, 736, 14, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "partial differentiation", "partial derivatives", "Cartesian basis", 
        "differential operator in local coordinates"}]},
  "Definition: Vector Field"->{
    Cell[197085, 6431, 86, 1, 38, "Definition",
      CellTags->"Definition: Vector Field"]},
  "manifold"->{
    Cell[197174, 6434, 515, 14, 54, "Text",
      Evaluatable->False,
      CellTags->{"manifold", "local coordinates"}],
    Cell[198795, 6488, 231, 8, 33, "Text",
      Evaluatable->False,
      CellTags->"manifold"],
    Cell[205001, 6668, 679, 20, 54, "Text",
      Evaluatable->False,
      CellTags->{"integral curve", "manifold"}],
    Cell[211828, 6867, 736, 19, 75, "Text",
      Evaluatable->False,
      CellTags->{"initial condition", "vector field", "manifold"}],
    Cell[277800, 9316, 1943, 46, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "smooth function", "transformation", 
        "independent variables", "vector field", "flow", 
        "transformation of independent variables"}],
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}],
    Cell[288990, 9633, 1167, 28, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "transformed derivatives", "transformation", "Calculus"}],
    Cell[296486, 9850, 594, 9, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "transformation", "infinitesimal transformation", "manifold"}],
    Cell[316337, 10390, 1077, 27, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "extended manifold", "manifold", 
        "Frechet derivative", "prolongation"}]},
  "local coordinates"->{
    Cell[197174, 6434, 515, 14, 54, "Text",
      Evaluatable->False,
      CellTags->{"manifold", "local coordinates"}]},
  "VectorField[]"->{
    Cell[198405, 6477, 387, 9, 107, "Input",
      CellTags->"VectorField[]"]},
  "velocity field"->{
    Cell[199486, 6520, 1058, 27, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "velocity field", "laminar fluid flow", "fluid flow", 
        "velocity of a fluid particle"}]},
  "laminar fluid flow"->{
    Cell[199486, 6520, 1058, 27, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "velocity field", "laminar fluid flow", "fluid flow", 
        "velocity of a fluid particle"}]},
  "fluid flow"->{
    Cell[199486, 6520, 1058, 27, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "velocity field", "laminar fluid flow", "fluid flow", 
        "velocity of a fluid particle"}]},
  "velocity of a fluid particle"->{
    Cell[199486, 6520, 1058, 27, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "velocity field", "laminar fluid flow", "fluid flow", 
        "velocity of a fluid particle"}]},
  "stream lines"->{
    Cell[200547, 6549, 669, 11, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "stream lines", "potential representation", "flow", "laminar"}]},
  "potential representation"->{
    Cell[200547, 6549, 669, 11, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "stream lines", "potential representation", "flow", "laminar"}]},
  "flow"->{
    Cell[200547, 6549, 669, 11, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "stream lines", "potential representation", "flow", "laminar"}],
    Cell[214701, 6968, 416, 13, 54, "Text",
      Evaluatable->False,
      CellTags->{"flow", "translation"}],
    Cell[219426, 7140, 803, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "scaling transformation", "closure", "identity", "closure of group", 
        "identity of group", "flow"}],
    Cell[226902, 7382, 274, 8, 33, "Text",
      Evaluatable->False,
      CellTags->{"infinitesimals", "flow"}],
    Cell[277800, 9316, 1943, 46, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "smooth function", "transformation", 
        "independent variables", "vector field", "flow", 
        "transformation of independent variables"}]},
  "laminar"->{
    Cell[200547, 6549, 669, 11, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "stream lines", "potential representation", "flow", "laminar"}]},
  "flow equations"->{
    Cell[202184, 6591, 916, 24, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "flow equations", "tangent vector", "components of tangent vector", 
        "origin", "initial conditions", "vector field"}]},
  "components of tangent vector"->{
    Cell[202184, 6591, 916, 24, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "flow equations", "tangent vector", "components of tangent vector", 
        "origin", "initial conditions", "vector field"}]},
  "origin"->{
    Cell[202184, 6591, 916, 24, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "flow equations", "tangent vector", "components of tangent vector", 
        "origin", "initial conditions", "vector field"}]},
  "initial conditions"->{
    Cell[202184, 6591, 916, 24, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "flow equations", "tangent vector", "components of tangent vector", 
        "origin", "initial conditions", "vector field"}]},
  "rotation"->{
    Cell[203800, 6636, 1139, 28, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "rotation", "translation", "transformation", "flow of a vector field"}],
    
    Cell[221151, 7201, 472, 9, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "global transformation", "rotation", 
        "transformation"}]},
  "translation"->{
    Cell[203800, 6636, 1139, 28, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "rotation", "translation", "transformation", "flow of a vector field"}],
    
    Cell[212598, 6890, 629, 17, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "translation", "one-dimensinal translation", 
        "characteristic equation"}],
    Cell[214701, 6968, 416, 13, 54, "Text",
      Evaluatable->False,
      CellTags->{"flow", "translation"}]},
  "transformation"->{
    Cell[203800, 6636, 1139, 28, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "rotation", "translation", "transformation", "flow of a vector field"}],
    
    Cell[221151, 7201, 472, 9, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "global transformation", "rotation", "transformation"}],
    
    Cell[277800, 9316, 1943, 46, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "smooth function", "transformation", 
        "independent variables", "vector field", "flow", 
        "transformation of independent variables"}],
    Cell[288990, 9633, 1167, 28, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "transformed derivatives", "transformation", "Calculus"}],
    Cell[290160, 9663, 946, 30, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "transformation", "change of original variables", "new variables"}],
    Cell[293128, 9758, 328, 7, 75, "Text",
      Evaluatable->False,
      CellTags->{"new coordinate system", "transformation"}],
    Cell[296486, 9850, 594, 9, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "transformation", "infinitesimal transformation", "manifold"}]},
  "flow of a vector field"->{
    Cell[203800, 6636, 1139, 28, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "rotation", "translation", "transformation", 
        "flow of a vector field"}]},
  "integral curve"->{
    Cell[205001, 6668, 679, 20, 54, "Text",
      Evaluatable->False,
      CellTags->{"integral curve", "manifold"}]},
  "properties of a flow"->{
    Cell[205683, 6690, 119, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"properties of a flow"]},
  "eq-31"->{
    Cell[205805, 6694, 520, 13, 28, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-31"]},
  "property of flow"->{
    Cell[206328, 6709, 703, 18, 75, "Text",
      Evaluatable->False,
      CellTags->{"property of flow", "identity"}]},
  "identity"->{
    Cell[206328, 6709, 703, 18, 75, "Text",
      Evaluatable->False,
      CellTags->{"property of flow", "identity"}],
    Cell[219426, 7140, 803, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "scaling transformation", "closure", "identity", "closure of group", 
        "identity of group", "flow"}],
    Cell[280305, 9385, 574, 13, 96, "Text",
      Evaluatable->False,
      CellTags->{"identity", "infinitesimals"}]},
  "eq-32"->{
    Cell[207034, 6729, 367, 10, 28, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-32"]},
  "group"->{
    Cell[207404, 6741, 906, 20, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "group", "exponentiation", "exponentiation of vector field"}]},
  "exponentiation"->{
    Cell[207404, 6741, 906, 20, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "group", "exponentiation", "exponentiation of vector field"}]},
  "exponentiation of vector field"->{
    Cell[207404, 6741, 906, 20, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "group", "exponentiation", "exponentiation of vector field"}]},
  "eq-33"->{
    Cell[208313, 6763, 213, 6, 31, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-33"]},
  "infinitesimal generator"->{
    Cell[208529, 6771, 1067, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimal generator", 
        "infinitesimal generator of the transformation", 
        "infinitesimal representation"}]},
  "infinitesimal generator of the transformation"->{
    Cell[208529, 6771, 1067, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimal generator", 
        "infinitesimal generator of the transformation", 
        "infinitesimal representation"}]},
  "infinitesimal representation"->{
    Cell[208529, 6771, 1067, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimal generator", 
        "infinitesimal generator of the transformation", 
        "infinitesimal representation"}],
    Cell[221800, 7217, 752, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimal representation", "flow of a group", "infinitesimals", 
        "coefficients of the vector field"}],
    Cell[297995, 9890, 419, 9, 75, "Text",
      Evaluatable->False,
      CellTags->{"infinitesimal representation", "rational expression"}]},
  "eq-34"->{
    Cell[209599, 6801, 774, 21, 31, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-34"]},
  "characteristic equations"->{
    Cell[210376, 6824, 868, 23, 55, "Text",
      Evaluatable->False,
      CellTags->{"characteristic equations", "determining equations"}]},
  "determining equations"->{
    Cell[210376, 6824, 868, 23, 55, "Text",
      Evaluatable->False,
      CellTags->{"characteristic equations", "determining equations"}]},
  "eq-35"->{
    Cell[211247, 6849, 578, 16, 44, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-35"]},
  "initial condition"->{
    Cell[211828, 6867, 736, 19, 75, "Text",
      Evaluatable->False,
      CellTags->{"initial condition", "vector field", "manifold"}]},
  "one-dimensinal translation"->{
    Cell[212598, 6890, 629, 17, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "translation", "one-dimensinal translation", 
        "characteristic equation"}]},
  "characteristic equation"->{
    Cell[212598, 6890, 629, 17, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "translation", "one-dimensinal translation", 
        "characteristic equation"}],
    Cell[218110, 7090, 643, 19, 54, "Text",
      Evaluatable->False,
      CellTags->"characteristic equation"]},
  "first-order ODE"->{
    Cell[213547, 6923, 581, 19, 54, "Text",
      Evaluatable->False,
      CellTags->{"first-order ODE", "ODE of first-order"}]},
  "ODE of first-order"->{
    Cell[213547, 6923, 581, 19, 54, "Text",
      Evaluatable->False,
      CellTags->{"first-order ODE", "ODE of first-order"}]},
  "group of translation"->{
    Cell[215357, 6994, 317, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"group of translation", "identity of group"}]},
  "identity of group"->{
    Cell[215357, 6994, 317, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"group of translation", "identity of group"}],
    Cell[219426, 7140, 803, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "scaling transformation", "closure", "identity", "closure of group", 
        "identity of group", "flow"}]},
  "inverse element"->{
    Cell[215835, 7015, 274, 6, 54, "Text",
      Evaluatable->False,
      CellTags->{"inverse element", "inverse element of group"}]},
  "inverse element of group"->{
    Cell[215835, 7015, 274, 6, 54, "Text",
      Evaluatable->False,
      CellTags->{"inverse element", "inverse element of group"}]},
  "inverse translation"->{
    Cell[216720, 7046, 249, 5, 54, "Text",
      Evaluatable->False,
      CellTags->{"inverse translation", "associativity"}]},
  "associativity"->{
    Cell[216720, 7046, 249, 5, 54, "Text",
      Evaluatable->False,
      CellTags->{"inverse translation", "associativity"}]},
  "properties of a group"->{
    Cell[217397, 7068, 679, 18, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "properties of a group", "symmetry of translation", "symmetries"}]},
  "symmetry of translation"->{
    Cell[217397, 7068, 679, 18, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "properties of a group", "symmetry of translation", "symmetries"}]},
  "symmetries"->{
    Cell[217397, 7068, 679, 18, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "properties of a group", "symmetry of translation", "symmetries"}]},
  "scaling transformation"->{
    Cell[219426, 7140, 803, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "scaling transformation", "closure", "identity", "closure of group", 
        "identity of group", "flow"}]},
  "closure"->{
    Cell[219426, 7140, 803, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "scaling transformation", "closure", "identity", "closure of group", 
        "identity of group", "flow"}]},
  "closure of group"->{
    Cell[219426, 7140, 803, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "scaling transformation", "closure", "identity", "closure of group", 
        "identity of group", "flow"}]},
  "scaling group"->{
    Cell[220343, 7166, 87, 1, 33, "Text",
      CellTags->"scaling group"]},
  "identity transformation"->{
    Cell[220875, 7192, 242, 5, 54, "Text",
      Evaluatable->False,
      CellTags->"identity transformation"]},
  "global transformation"->{
    Cell[221151, 7201, 472, 9, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "global transformation", "rotation", 
        "transformation"}]},
  "flow of a group"->{
    Cell[221800, 7217, 752, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimal representation", "flow of a group", "infinitesimals", 
        "coefficients of the vector field"}]},
  "infinitesimals"->{
    Cell[221800, 7217, 752, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimal representation", "flow of a group", "infinitesimals", 
        "coefficients of the vector field"}],
    Cell[223208, 7260, 117, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals"],
    Cell[226902, 7382, 274, 8, 33, "Text",
      Evaluatable->False,
      CellTags->{"infinitesimals", "flow"}],
    Cell[280305, 9385, 574, 13, 96, "Text",
      Evaluatable->False,
      CellTags->{"identity", "infinitesimals"}],
    Cell[314412, 10343, 798, 15, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "calculation of the prolongation", "infinitesimals", "characteristics", 
        "Frechet derivative"}],
    Cell[352694, 11359, 604, 17, 75, "Text",
      Evaluatable->False,
      CellTags->{"infinitesimals", "prolongation of the vector field"}]},
  "coefficients of the vector field"->{
    Cell[221800, 7217, 752, 20, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimal representation", "flow of a group", "infinitesimals", 
        "coefficients of the vector field"}],
    Cell[281698, 9426, 447, 12, 75, "Text",
      Evaluatable->False,
      CellTags->{"delayed rule", "coefficients of the vector field"}]},
  "eq-37"->{
    Cell[223328, 7264, 574, 17, 44, "NumberedEquation",
      CellTags->"eq-37"]},
  "global group action"->{
    Cell[226470, 7369, 265, 6, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "global group action", "group action", "projective group"}]},
  "group action"->{
    Cell[226470, 7369, 265, 6, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "global group action", "group action", "projective group"}]},
  "projective group"->{
    Cell[226470, 7369, 265, 6, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "global group action", "group action", "projective group"}]},
  "package"->{
    Cell[227432, 7404, 1104, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "package", "Graphics`PlotField", 
        "grapical representation of vector field", 
        "representation of vector field"}]},
  "Graphics`PlotField"->{
    Cell[227432, 7404, 1104, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "package", "Graphics`PlotField", 
        "grapical representation of vector field", 
        "representation of vector field"}]},
  "grapical representation of vector field"->{
    Cell[227432, 7404, 1104, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "package", "Graphics`PlotField", 
        "grapical representation of vector field", 
        "representation of vector field"}]},
  "representation of vector field"->{
    Cell[227432, 7404, 1104, 28, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "package", "Graphics`PlotField", 
        "grapical representation of vector field", 
        "representation of vector field"}]},
  "smooth function"->{
    Cell[277800, 9316, 1943, 46, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "smooth function", "transformation", 
        "independent variables", "vector field", "flow", 
        "transformation of independent variables"}]},
  "transformation of independent variables"->{
    Cell[277800, 9316, 1943, 46, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "smooth function", "transformation", 
        "independent variables", "vector field", "flow", 
        "transformation of independent variables"}]},
  "delayed rule"->{
    Cell[281698, 9426, 447, 12, 75, "Text",
      Evaluatable->False,
      CellTags->{"delayed rule", "coefficients of the vector field"}]},
  "infinitesimal flow"->{
    Cell[282488, 9453, 1536, 41, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "infinitesimal flow", 
        "first order partial differential operator", "Taylor series"}],
    Cell[351325, 11318, 166, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"infinitesimal flow"]},
  "first order partial differential operator"->{
    Cell[282488, 9453, 1536, 41, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "infinitesimal flow", 
        "first order partial differential operator", "Taylor series"}]},
  "Taylor series"->{
    Cell[282488, 9453, 1536, 41, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "infinitesimal flow", 
        "first order partial differential operator", "Taylor series"}]},
  "infinitesimal change"->{
    Cell[284682, 9519, 431, 13, 54, "Text",
      Evaluatable->False,
      CellTags->"infinitesimal change"],
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}]},
  "eq-38"->{
    Cell[285116, 9534, 528, 14, 27, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-38"]},
  "differential basis"->{
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}]},
  "transformed function"->{
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}]},
  "dependent variables"->{
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}]},
  "prolonging a vector field"->{
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}]},
  "extending a vector field"->{
    Cell[286139, 9568, 1239, 19, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "vector field", "manifold", "Cartesian basis", "tangent vector", 
        "differential basis", "transformed function", "infinitesimal change", 
        "dependent variables", "prolonging a vector field", 
        "extending a vector field"}]},
  "prolong a manifold"->{
    Cell[287381, 9589, 588, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{"prolong a manifold", "extend a manifold", "extension"}]},
  "extend a manifold"->{
    Cell[287381, 9589, 588, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{"prolong a manifold", "extend a manifold", "extension"}]},
  "eq-39"->{
    Cell[287972, 9603, 1015, 28, 31, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-39"]},
  "transformed derivatives"->{
    Cell[288990, 9633, 1167, 28, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "transformed derivatives", "transformation", "Calculus"}]},
  "Calculus"->{
    Cell[288990, 9633, 1167, 28, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "manifold", "transformed derivatives", "transformation", "Calculus"}]},
  "change of original variables"->{
    Cell[290160, 9663, 946, 30, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "transformation", "change of original variables", "new variables"}]},
  "new variables"->{
    Cell[290160, 9663, 946, 30, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "transformation", "change of original variables", "new variables"}]},
  "original variables"->{
    Cell[291338, 9701, 1327, 37, 180, "Text",
      Evaluatable->False,
      CellTags->{"original variables", "changes of variables"}]},
  "changes of variables"->{
    Cell[291338, 9701, 1327, 37, 180, "Text",
      Evaluatable->False,
      CellTags->{"original variables", "changes of variables"}]},
  "new coordinate system"->{
    Cell[293128, 9758, 328, 7, 75, "Text",
      Evaluatable->False,
      CellTags->{"new coordinate system", "transformation"}]},
  "flow of the vector field"->{
    Cell[294045, 9788, 1421, 29, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation", "flow of the vector field", "extension", 
        "one parameter transformation"}]},
  "one parameter transformation"->{
    Cell[294045, 9788, 1421, 29, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation", "flow of the vector field", "extension", 
        "one parameter transformation"}]},
  "infinitesimal transformation"->{
    Cell[296486, 9850, 594, 9, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "transformation", "infinitesimal transformation", "manifold"}],
    Cell[299711, 9943, 610, 14, 96, "Text",
      Evaluatable->False,
      CellTags->{"infinitesimal transformation", "prolonged vector field"}],
    Cell[306396, 10114, 206, 7, 26, "ListItem",
      Evaluatable->False,
      CellTags->"infinitesimal transformation"]},
  "rational expression"->{
    Cell[297995, 9890, 419, 9, 75, "Text",
      Evaluatable->False,
      CellTags->{"infinitesimal representation", "rational expression"}]},
  "prolonged vector field"->{
    Cell[299711, 9943, 610, 14, 96, "Text",
      Evaluatable->False,
      CellTags->{"infinitesimal transformation", "prolonged vector field"}]},
  "first prolongation"->{
    Cell[303662, 10035, 583, 16, 96, "Text",
      Evaluatable->False,
      CellTags->"first prolongation"]},
  "old differentials"->{
    Cell[306190, 10108, 203, 4, 26, "ListItem",
      Evaluatable->False,
      CellTags->{"old differentials", "new differentials"}]},
  "new differentials"->{
    Cell[306190, 10108, 203, 4, 26, "ListItem",
      Evaluatable->False,
      CellTags->{"old differentials", "new differentials"}]},
  "twice extended vector field"->{
    Cell[308087, 10166, 593, 12, 117, "Text",
      Evaluatable->False,
      CellTags->"twice extended vector field"]},
  "second extension"->{
    Cell[310340, 10222, 913, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "second extension", "extension", "higher extension", 
        "recursive definition of extension", "prolongation formula"}]},
  "higher extension"->{
    Cell[310340, 10222, 913, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "second extension", "extension", "higher extension", 
        "recursive definition of extension", "prolongation formula"}]},
  "recursive definition of extension"->{
    Cell[310340, 10222, 913, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "second extension", "extension", "higher extension", 
        "recursive definition of extension", "prolongation formula"}]},
  "prolongation formula"->{
    Cell[310340, 10222, 913, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "second extension", "extension", "higher extension", 
        "recursive definition of extension", "prolongation formula"}],
    Cell[320028, 10504, 306, 9, 54, "Text",
      Evaluatable->False,
      CellTags->"prolongation formula"]},
  "eq-40"->{
    Cell[311256, 10243, 348, 9, 63, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-40"]},
  "eq-41"->{
    Cell[312516, 10286, 327, 8, 55, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-41"]},
  "recursive prolongation formula"->{
    Cell[312846, 10296, 852, 26, 76, "Text",
      Evaluatable->False,
      CellTags->"recursive prolongation formula"]},
  "calculation of the prolongation"->{
    Cell[314412, 10343, 798, 15, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "calculation of the prolongation", "infinitesimals", "characteristics", 
        "Frechet derivative"}]},
  "characteristics"->{
    Cell[314412, 10343, 798, 15, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "calculation of the prolongation", "infinitesimals", "characteristics", 
        "Frechet derivative"}],
    Cell[315213, 10360, 814, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "recursive prolongation", "Frechet prolongation", "characteristics", 
        "characteristic function", "general vector field"}],
    Cell[316337, 10390, 1077, 27, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "extended manifold", "manifold", 
        "Frechet derivative", "prolongation"}],
    Cell[322638, 10586, 617, 15, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", 
        "infinitesimal representation of characteristics"}]},
  "recursive prolongation"->{
    Cell[315213, 10360, 814, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "recursive prolongation", "Frechet prolongation", "characteristics", 
        "characteristic function", "general vector field"}]},
  "Frechet prolongation"->{
    Cell[315213, 10360, 814, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "recursive prolongation", "Frechet prolongation", "characteristics", 
        "characteristic function", "general vector field"}]},
  "characteristic function"->{
    Cell[315213, 10360, 814, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "recursive prolongation", "Frechet prolongation", "characteristics", 
        "characteristic function", "general vector field"}]},
  "general vector field"->{
    Cell[315213, 10360, 814, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "recursive prolongation", "Frechet prolongation", "characteristics", 
        "characteristic function", "general vector field"}]},
  "eq-42"->{
    Cell[316030, 10380, 304, 8, 63, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-42"]},
  "extended manifold"->{
    Cell[316337, 10390, 1077, 27, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "extended manifold", "manifold", 
        "Frechet derivative", "prolongation"}]},
  "eq-43"->{
    Cell[317417, 10419, 234, 6, 31, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-43"]},
  "prolongation of the vector field"->{
    Cell[317654, 10427, 253, 7, 33, "Text",
      Evaluatable->False,
      CellTags->"prolongation of the vector field"],
    Cell[352694, 11359, 604, 17, 75, "Text",
      Evaluatable->False,
      CellTags->{"infinitesimals", "prolongation of the vector field"}]},
  "eq-44"->{
    Cell[317910, 10436, 339, 8, 63, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-44"]},
  "expansion coefficient of the prolongation"->{
    Cell[319286, 10478, 358, 11, 54, "Text",
      Evaluatable->False,
      CellTags->"expansion coefficient of the prolongation"]},
  "total derivative"->{
    Cell[320869, 10528, 167, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"total derivative"]},
  "infinitesimal representation of characteristics"->{
    Cell[322638, 10586, 617, 15, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", 
        "infinitesimal representation of characteristics"}]},
  "eq-50"->{
    Cell[323258, 10603, 1409, 35, 59, "NumberedEquation",
      CellTags->"eq-50"]},
  "calculate the prolongation"->{
    Cell[324670, 10640, 962, 19, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation", "calculate the prolongation", 
        "Lie-B\[ADoubleDot]cklund symmetries"}]},
  "Lie-B\[ADoubleDot]cklund symmetries"->{
    Cell[324670, 10640, 962, 19, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation", "calculate the prolongation", 
        "Lie-B\[ADoubleDot]cklund symmetries"}]},
  "Prolongation[]"->{
    Cell[325635, 10661, 1657, 40, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Prolongation[]", "Frechet derivative", 
        "symbolic names of infinitesimals"}],
    Cell[327295, 10703, 2181, 41, 710, "Input",
      InitializationCell->True,
      CellTags->{"Function Prolongation", "Prolongation[]"}],
    Cell[329479, 10746, 840, 18, 138, "Text",
      Evaluatable->False,
      CellTags->{"Prolongation[]", "Frechet derivative"}],
    Cell[334912, 10896, 2107, 54, 306, "Text",
      CellTags->{
      "Prolongation[]", "TraditionalLieForm", "LieTraditionalForm[]", 
        "higher order prolongations", "vector field", "LTF[]"}],
    Cell[351661, 11330, 446, 11, 54, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "Prolongation[]"}]},
  "symbolic names of infinitesimals"->{
    Cell[325635, 10661, 1657, 40, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Prolongation[]", "Frechet derivative", 
        "symbolic names of infinitesimals"}]},
  "Function Prolongation"->{
    Cell[327295, 10703, 2181, 41, 710, "Input",
      InitializationCell->True,
      CellTags->{"Function Prolongation", "Prolongation[]"}]},
  "LieTraditionalForm[]"->{
    Cell[334036, 10868, 503, 13, 75, "Text",
      Evaluatable->False,
      CellTags->"LieTraditionalForm[]"],
    Cell[334912, 10896, 2107, 54, 306, "Text",
      CellTags->{
      "Prolongation[]", "TraditionalLieForm", "LieTraditionalForm[]", 
        "higher order prolongations", "vector field", "LTF[]"}]},
  "TraditionalLieForm"->{
    Cell[334912, 10896, 2107, 54, 306, "Text",
      CellTags->{
      "Prolongation[]", "TraditionalLieForm", "LieTraditionalForm[]", 
        "higher order prolongations", "vector field", "LTF[]"}]},
  "higher order prolongations"->{
    Cell[334912, 10896, 2107, 54, 306, "Text",
      CellTags->{
      "Prolongation[]", "TraditionalLieForm", "LieTraditionalForm[]", 
        "higher order prolongations", "vector field", "LTF[]"}]},
  "LTF[]"->{
    Cell[334912, 10896, 2107, 54, 306, "Text",
      CellTags->{
      "Prolongation[]", "TraditionalLieForm", "LieTraditionalForm[]", 
        "higher order prolongations", "vector field", "LTF[]"}]},
  "symmetry group"->{
    Cell[353511, 11388, 470, 11, 75, "Text",
      CellTags->"symmetry group"]},
  "symmetry of rotation"->{
    Cell[354015, 11403, 566, 13, 78, "Text",
      Evaluatable->False,
      CellTags->"symmetry of rotation"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"The Euler derivative", 357971, 11518},
  {"calculus of variations", 358351, 11526},
  {"Euler", 359113, 11547},
  {"Lagrange", 359395, 11555},
  {"Euler-Lagrange equations", 359693, 11563},
  {"dynamical equations", 359986, 11571},
  {"generalized symmetries", 360282, 11579},
  {"The Problem of Variations", 360581, 11587},
  {"Bernoulli", 360716, 11591},
  {"brachystochrone problem", 361188, 11603},
  {"Leibniz", 361413, 11610},
  {"Hamilton", 361639, 11617},
  {"minimum principle", 361939, 11625},
  {"generating functional", 362243, 11633},
  {"minimize", 362534, 11641},
  {"higher derivatives", 362835, 11649},
  {"functional", 363128, 11657},
  {"eq-1", 364246, 11687},
  {"eq-2", 364363, 11691},
  {"extreme", 364483, 11695},
  {"maximum", 364816, 11704},
  {"minimum", 364952, 11708},
  {"test function", 365191, 11715},
  {"parametric representation", 365810, 11730},
  {"small perturbation", 366179, 11739},
  {"eq-3", 366389, 11745},
  {"continuous derivative", 366523, 11749},
  {"variation", 366651, 11753},
  {"eq-4", 366762, 11757},
  {"stationary value", 366892, 11761},
  {"eq-5", 367009, 11765},
  {"necessary condition", 367141, 11769},
  {"sufficient condition", 367381, 11775},
  {"shortest connection between two points", 367639, 11781},
  {"Euclidean plane", 367975, 11789},
  {"Euclidean space", 368210, 11795},
  {"geometrical increment", 368371, 11799},
  {"eq-6", 368515, 11803},
  {"total length between two points", 368660, 11807},
  {"eq-7", 368793, 11811},
  {"straight line", 368919, 11815},
  {"eq-8", 369033, 11819},
  {"slope", 369152, 11823},
  {"eq-10", 369294, 11827},
  {"Plot[]", 369415, 11831},
  {"Euler's Equation", 369550, 11835},
  {"Euler derivative", 369686, 11839},
  {"eq-12", 370578, 11860},
  {"representation", 370708, 11864},
  {"eq-14", 370826, 11868},
  {"functional density", 370960, 11872},
  {"eq-15", 371988, 11896},
  {"Euler equation", 372118, 11900},
  {"Euler-Lagrange equation", 373348, 11930},
  {"Euler operator", 374027, 11946},
  {"variational derivative", 374999, 11970},
  {"dynamical formulation", 375389, 11979},
  {"statistical mechanics", 375620, 11984},
  {"special type of derivative", 375856, 11989},
  {"Definition: Euler Operator", 376092, 11994},
  {"functional derivative", 376216, 11997},
  {"partial derivative", 376577, 12006},
  {"ordinary derivative", 376855, 12013},
  {"algorithmic procedure", 377135, 12020},
  {"Algorithm used in the Calculus of Variations", 377438, 12027},
  {"algorithm", 377595, 12031},
  {"boundary condition", 377721, 12035},
  {"EulerD[]", 377869, 12039},
  {"brachistochrone problem", 379110, 12070},
  {"brachystochrone", 379246, 12074},
  {"line element", 379498, 12080},
  {"velocity", 379746, 12086},
  {"Cartesian coordinates", 380007, 12092},
  {"cycloid", 380396, 12101},
  {"mechanical system", 380519, 12105},
  {"Lagrange function", 380725, 12110},
  {"Lagrangian", 380924, 12115},
  {"Hold[]", 381042, 12118},
  {"auxiliary function", 381139, 12121},
  {"Euler operator for q-dependent variables", 381378, 12127},
  {"loop", 381526, 12131},
  {"generalized Euler operator", 381702, 12135},
  {"two-dimensional oscillator system", 381885, 12139},
  {"oscillators", 382125, 12145},
  {"Lagrange density", 382370, 12151},
  {"equations of motion", 382755, 12160},
  {"two-dimensional Lagrangian", 383010, 12166},
  {"Dirac Lagrangian", 383125, 12169},
  {"binomial", 383270, 12173},
  {"second-order ordinary differential equation", 383450, 12177},
  {"point system", 383578, 12180},
  {"Euler operator for (q-p)-dimensions", 383766, 12184},
  {"Maxwell equation", 383923, 12188},
  {"Schr\[ODoubleDot]dinger equation", 384159, 12194},
  {"hydrodynamics", 384376, 12200},
  {"Definition: (qp)-dimensional Euler operator", 384623, 12206},
  {"eq-25", 384750, 12209},
  {"multi index", 384878, 12213},
  {"general Euler operator", 385011, 12217},
  {"wave equation", 385160, 12221},
  {"coupled nonlinear diffusion equations", 385326, 12224},
  {"Laplace equation", 385573, 12229},
  {"pencil calculation", 385759, 12234},
  {"diffusion", 385899, 12238},
  {"two component nonlinear medium", 386075, 12242},
  {"tangent vector", 386235, 12246},
  {"prolongation", 387567, 12276},
  {"Frechet derivative", 389014, 12312},
  {"non-standard differential operators", 390058, 12337},
  {"symmetry analysis of differential equations", 390396, 12344},
  {"differential operators", 390847, 12354},
  {"Prolongation of vector fields", 391171, 12361},
  {"vector field", 391314, 12365},
  {"symmetry", 393572, 12418},
  {"symmetries of differential equations", 393834, 12424},
  {"extension", 394069, 12430},
  {"Lie theory", 394967, 12452},
  {"independent variables", 395214, 12458},
  {"curve in parametric form", 395722, 12470},
  {"three dimensional spiral", 395973, 12476},
  {"solenoid", 396208, 12482},
  {"Line[]", 396441, 12488},
  {"graphic primitives", 396613, 12492},
  {"spiral", 396736, 12496},
  {"partial differentiation", 396910, 12500},
  {"partial derivatives", 397159, 12506},
  {"Cartesian basis", 397404, 12512},
  {"differential operator in local coordinates", 398016, 12525},
  {"Definition: Vector Field", 398270, 12531},
  {"manifold", 398380, 12534},
  {"local coordinates", 400003, 12573},
  {"VectorField[]", 400147, 12577},
  {"velocity field", 400249, 12580},
  {"laminar fluid flow", 400469, 12586},
  {"fluid flow", 400681, 12592},
  {"velocity of a fluid particle", 400911, 12598},
  {"stream lines", 401125, 12604},
  {"potential representation", 401318, 12609},
  {"flow", 401491, 12614},
  {"laminar", 402353, 12636},
  {"flow equations", 402536, 12641},
  {"components of tangent vector", 402794, 12647},
  {"origin", 403030, 12653},
  {"initial conditions", 403278, 12659},
  {"rotation", 403516, 12665},
  {"translation", 403885, 12676},
  {"transformation", 404371, 12690},
  {"flow of a vector field", 405624, 12722},
  {"integral curve", 405825, 12728},
  {"properties of a flow", 405973, 12732},
  {"eq-31", 406097, 12736},
  {"property of flow", 406230, 12740},
  {"identity", 406368, 12744},
  {"eq-32", 406825, 12756},
  {"group", 406947, 12760},
  {"exponentiation", 407128, 12765},
  {"exponentiation of vector field", 407325, 12770},
  {"eq-33", 407497, 12775},
  {"infinitesimal generator", 407636, 12779},
  {"infinitesimal generator of the transformation", 407913, 12786},
  {"infinitesimal representation", 408173, 12793},
  {"eq-34", 408763, 12808},
  {"characteristic equations", 408904, 12812},
  {"determining equations", 409076, 12816},
  {"eq-35", 409232, 12820},
  {"initial condition", 409366, 12824},
  {"one-dimensinal translation", 409539, 12828},
  {"characteristic equation", 409748, 12834},
  {"first-order ODE", 410063, 12843},
  {"ODE of first-order", 410220, 12847},
  {"group of translation", 410379, 12851},
  {"identity of group", 410538, 12855},
  {"inverse element", 410898, 12864},
  {"inverse element of group", 411066, 12868},
  {"inverse translation", 411229, 12872},
  {"associativity", 411379, 12876},
  {"properties of a group", 411537, 12880},
  {"symmetry of translation", 411731, 12885},
  {"symmetries", 411912, 12890},
  {"scaling transformation", 412105, 12895},
  {"closure", 412324, 12901},
  {"closure of group", 412552, 12907},
  {"scaling group", 412777, 12913},
  {"identity transformation", 412885, 12916},
  {"global transformation", 413028, 12920},
  {"flow of a group", 413227, 12926},
  {"infinitesimals", 413460, 12932},
  {"coefficients of the vector field", 414393, 12955},
  {"eq-37", 414758, 12964},
  {"global group action", 414868, 12967},
  {"group action", 415043, 12972},
  {"projective group", 415222, 12977},
  {"package", 415392, 12982},
  {"Graphics`PlotField", 415660, 12989},
  {"grapical representation of vector field", 415949, 12996},
  {"representation of vector field", 416229, 13003},
  {"smooth function", 416494, 13010},
  {"transformation of independent variables", 416799, 13017},
  {"delayed rule", 417077, 13024},
  {"infinitesimal flow", 417245, 13028},
  {"first order partial differential operator", 417611, 13037},
  {"Taylor series", 417840, 13043},
  {"infinitesimal change", 418076, 13049},
  {"eq-38", 418541, 13060},
  {"differential basis", 418676, 13064},
  {"transformed function", 419045, 13072},
  {"dependent variables", 419413, 13080},
  {"prolonging a vector field", 419787, 13088},
  {"extending a vector field", 420160, 13096},
  {"prolong a manifold", 420527, 13104},
  {"extend a manifold", 420698, 13108},
  {"eq-39", 420857, 13112},
  {"transformed derivatives", 420998, 13116},
  {"Calculus", 421182, 13121},
  {"change of original variables", 421386, 13126},
  {"new variables", 421572, 13131},
  {"original variables", 421763, 13136},
  {"changes of variables", 421929, 13140},
  {"new coordinate system", 422096, 13144},
  {"flow of the vector field", 422260, 13148},
  {"one parameter transformation", 422493, 13154},
  {"infinitesimal transformation", 422726, 13160},
  {"rational expression", 423182, 13171},
  {"prolonged vector field", 423356, 13175},
  {"first prolongation", 423530, 13179},
  {"old differentials", 423666, 13183},
  {"new differentials", 423827, 13187},
  {"twice extended vector field", 423998, 13191},
  {"second extension", 424143, 13195},
  {"higher extension", 424389, 13201},
  {"recursive definition of extension", 424652, 13207},
  {"prolongation formula", 424902, 13213},
  {"eq-40", 425248, 13222},
  {"eq-41", 425370, 13226},
  {"recursive prolongation formula", 425517, 13230},
  {"calculation of the prolongation", 425679, 13234},
  {"characteristics", 425904, 13240},
  {"recursive prolongation", 426737, 13261},
  {"Frechet prolongation", 426993, 13267},
  {"characteristic function", 427252, 13273},
  {"general vector field", 427508, 13279},
  {"eq-42", 427749, 13285},
  {"extended manifold", 427883, 13289},
  {"eq-43", 428095, 13295},
  {"prolongation of the vector field", 428244, 13299},
  {"eq-44", 428525, 13306},
  {"expansion coefficient of the prolongation", 428683, 13310},
  {"total derivative", 428841, 13314},
  {"infinitesimal representation of characteristics", 429004, 13318},
  {"eq-50", 429194, 13324},
  {"calculate the prolongation", 429313, 13327},
  {"Lie-B\[ADoubleDot]cklund symmetries", 429549, 13333},
  {"Prolongation[]", 429764, 13339},
  {"symbolic names of infinitesimals", 430587, 13358},
  {"Function Prolongation", 430801, 13364},
  {"LieTraditionalForm[]", 430972, 13368},
  {"TraditionalLieForm", 431312, 13376},
  {"higher order prolongations", 431548, 13381},
  {"LTF[]", 431763, 13386},
  {"symmetry group", 431987, 13391},
  {"symmetry of rotation", 432096, 13394}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 379, 6, 52, "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 3}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 22}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"The Euler derivative"],
Cell[2121, 59, 1379, 27, 222, "Text",
  Evaluatable->False,
  PageBreakBelow->False,
  CellTags->{
  "calculus of variations", "Euler", "Lagrange", "Euler-Lagrange equations", 
    "dynamical equations", "generalized symmetries"}],

Cell[CellGroupData[{
Cell[3525, 90, 115, 2, 49, "Subsection",
  Evaluatable->False,
  CellTags->"The Problem of Variations"],
Cell[3643, 94, 1229, 23, 222, "Text",
  Evaluatable->False,
  PageBreakBelow->False,
  CellTags->{
  "Bernoulli", "brachystochrone problem", "Leibniz", 
    "calculus of variations"}],
Cell[4875, 119, 2126, 52, 285, "Text",
  Evaluatable->False,
  PageBreakWithin->True,
  CellTags->{
  "Hamilton", "minimum principle", "calculus of variations", 
    "generating functional", "minimize", "higher derivatives", 
    "functional"}],
Cell[7004, 173, 981, 27, 44, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-1"],
Cell[7988, 202, 205, 7, 33, "Text",
  Evaluatable->False],
Cell[8196, 211, 744, 19, 42, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-2"],
Cell[8943, 232, 900, 26, 117, "Text",
  Evaluatable->False,
  CellTags->{"extreme", "maximum", "minimum"}],
Cell[9846, 260, 2594, 85, 264, "Text",
  Evaluatable->False,
  CellTags->{
  "functional", "extreme", "test function", "parametric representation", 
    "small perturbation"}],
Cell[12443, 347, 198, 7, 27, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-3"],
Cell[12644, 356, 966, 34, 75, "Text",
  Evaluatable->False,
  CellTags->"continuous derivative"],
Cell[13613, 392, 409, 14, 54, "Text",
  Evaluatable->False,
  CellTags->"variation"],
Cell[14025, 408, 497, 18, 42, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-4"],
Cell[14525, 428, 295, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"stationary value"],
Cell[14823, 438, 212, 5, 44, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-5"],
Cell[15038, 445, 717, 17, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "necessary condition", "sufficient condition", 
    "shortest connection between two points", "Euclidean plane"}],
Cell[15758, 464, 28, 0, 33, "Example"],
Cell[15789, 466, 484, 14, 75, "Text",
  Evaluatable->False,
  CellTags->{"Euclidean space", "geometrical increment"}],
Cell[16276, 482, 983, 28, 52, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-6"],
Cell[17262, 512, 327, 13, 33, "Text",
  Evaluatable->False,
  CellTags->"total length between two points"],
Cell[17592, 527, 332, 9, 45, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-7"],
Cell[17927, 538, 183, 5, 54, "Text",
  Evaluatable->False,
  CellTags->"straight line"],
Cell[18113, 545, 315, 14, 27, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-8"],
Cell[18431, 561, 892, 27, 117, "Text",
  Evaluatable->False,
  CellTags->{"slope", "functional", "test function"}],
Cell[19326, 590, 554, 16, 28, "NumberedEquation",
  Evaluatable->False],
Cell[19883, 608, 180, 7, 33, "Text",
  Evaluatable->False],
Cell[20066, 617, 535, 16, 43, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-10"],
Cell[20604, 635, 928, 26, 138, "Text",
  Evaluatable->False,
  CellTags->"minimum"],
Cell[21535, 663, 182, 5, 54, "Input"],
Cell[21720, 670, 299, 9, 54, "Text",
  Evaluatable->False,
  CellTags->{"Plot[]", "functional"}],

Cell[CellGroupData[{
Cell[22044, 683, 185, 3, 45, "Input"],
Cell[22232, 688, 17310, 502, 209, 6038, 349, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[39557, 1193, 719, 16, 117, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[40301, 1213, 470, 10, 190, "Input"],
Cell[40774, 1225, 26763, 992, 209, 12512, 802, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[67552, 2220, 301, 7, 54, "Text",
  CellTags->"shortest connection between two points"]
}, Open  ]],

Cell[CellGroupData[{
Cell[67890, 2232, 125, 2, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Euler's Equation"],
Cell[68018, 2236, 495, 15, 75, "Text",
  Evaluatable->False,
  CellTags->"Euler derivative"],
Cell[68516, 2253, 278, 6, 46, "NumberedEquation",
  Evaluatable->False],
Cell[68797, 2261, 245, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"functional"],
Cell[69045, 2271, 582, 13, 48, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-12"],
Cell[69630, 2286, 417, 14, 54, "Text",
  Evaluatable->False,
  CellTags->"representation"],
Cell[70050, 2302, 285, 5, 44, "NumberedEquation",
  Evaluatable->False],
Cell[70338, 2309, 87, 1, 33, "Text",
  Evaluatable->False],
Cell[70428, 2312, 436, 10, 48, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-14"],
Cell[70867, 2324, 1168, 38, 117, "Text",
  Evaluatable->False,
  CellTags->{"functional density", "test function"}],
Cell[72038, 2364, 623, 16, 48, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-15"],
Cell[72664, 2382, 800, 23, 96, "Text",
  Evaluatable->False],
Cell[73467, 2407, 343, 7, 62, "NumberedEquation",
  Evaluatable->False],
Cell[73813, 2416, 997, 32, 98, "Text",
  Evaluatable->False],
Cell[74813, 2450, 231, 5, 62, "NumberedEquation",
  Evaluatable->False],
Cell[75047, 2457, 772, 18, 117, "Text",
  Evaluatable->False,
  CellTags->{"Euler equation", "Euler-Lagrange equation", "Euler operator"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[75856, 2480, 94, 2, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Euler operator"],
Cell[75953, 2484, 373, 7, 54, "Text",
  CellTags->{
  "Euler operator", "variational derivative", "dynamical formulation", 
    "statistical mechanics", "special type of derivative"}],
Cell[76329, 2493, 90, 1, 38, "Definition",
  CellTags->"Definition: Euler Operator"],
Cell[76422, 2496, 573, 21, 33, "Text",
  CellTags->"functional"],
Cell[76998, 2519, 1182, 36, 68, "Text"],
Cell[78183, 2557, 172, 4, 33, "Text",
  CellTags->"functional derivative"],
Cell[78358, 2563, 487, 15, 68, "Text"],
Cell[78848, 2580, 695, 25, 34, "Text"],
Cell[79546, 2607, 1552, 40, 181, "Text",
  Evaluatable->False,
  CellTags->{
  "partial derivative", "ordinary derivative", "functional density", 
    "functional derivative", "Euler equation", "algorithmic procedure"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[81135, 2652, 180, 3, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Algorithm used in the Calculus of Variations"],
Cell[81318, 2657, 588, 13, 96, "Text",
  Evaluatable->False,
  CellTags->"algorithm"],
Cell[81909, 2672, 326, 12, 26, "ListItem",
  Evaluatable->False],
Cell[82238, 2686, 320, 8, 45, "ListItem",
  Evaluatable->False,
  CellTags->"functional density"],
Cell[82561, 2696, 331, 11, 26, "ListItem",
  Evaluatable->False,
  CellTags->{"boundary condition", "test function"}],
Cell[82895, 2709, 290, 10, 26, "ListItem",
  Evaluatable->False,
  CellTags->"Euler equation"],
Cell[83188, 2721, 1173, 25, 180, "Text",
  Evaluatable->False,
  CellTags->{"Euler derivative", "EulerD[]"}],
Cell[84364, 2748, 332, 7, 81, "Input",
  CellTags->"EulerD[]"],
Cell[84699, 2757, 2156, 44, 388, "Input"],
Cell[86858, 2803, 380, 8, 75, "Text",
  Evaluatable->False,
  CellTags->"brachistochrone problem"],
Cell[87241, 2813, 28, 0, 33, "Example"],
Cell[87272, 2815, 1424, 34, 204, "Text",
  Evaluatable->False,
  CellTags->{
  "brachystochrone", "Bernoulli", "Euler equation", "functional density", 
    "line element", "velocity", "Cartesian coordinates"}],
Cell[88699, 2851, 856, 24, 58, "NumberedEquation",
  Evaluatable->False],
Cell[89558, 2877, 376, 12, 54, "Text",
  Evaluatable->False,
  CellTags->{"EulerD[]", "functional density"}],

Cell[CellGroupData[{
Cell[89959, 2893, 122, 2, 58, "Input"],
Cell[90084, 2897, 142, 4, 75, "Output"]
}, Open  ]],
Cell[90241, 2904, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[90290, 2908, 135, 2, 27, "Input"],
Cell[90428, 2912, 138, 2, 52, "Output"]
}, Open  ]],
Cell[90581, 2917, 475, 15, 54, "Text",
  Evaluatable->False,
  CellTags->"cycloid"],
Cell[91059, 2934, 28, 0, 33, "Example"],
Cell[91090, 2936, 458, 9, 75, "Text",
  CellTags->{
  "EulerD[]", "Euler-Lagrange equation", "mechanical system", 
    "functional density", "Lagrange function"}],

Cell[CellGroupData[{
Cell[91573, 2949, 124, 2, 27, "Input"],
Cell[91700, 2953, 47, 1, 30, "Output"]
}, Open  ]],
Cell[91762, 2957, 341, 10, 54, "Text",
  CellTags->{"Euler-Lagrange equation", "Lagrangian"}],

Cell[CellGroupData[{
Cell[92128, 2971, 86, 1, 27, "Input"],
Cell[92217, 2974, 2007, 57, 32, "Output"]
}, Open  ]],
Cell[94239, 3034, 65, 0, 33, "Text"],
Cell[94307, 3036, 398, 10, 47, "NumberedEquation"],
Cell[94708, 3048, 384, 10, 75, "Text",
  CellTags->"Hold[]"],

Cell[CellGroupData[{
Cell[95117, 3062, 119, 2, 27, "Input"],
Cell[95239, 3066, 125, 2, 30, "Output"]
}, Open  ]],
Cell[95379, 3071, 170, 3, 33, "Text",
  CellTags->"Euler-Lagrange equation"],
Cell[95552, 3076, 987, 26, 138, "Text",
  Evaluatable->False,
  CellTags->"Euler operator"],
Cell[96542, 3104, 681, 20, 45, "NumberedEquation",
  Evaluatable->False],
Cell[97226, 3126, 327, 9, 54, "Text",
  Evaluatable->False,
  CellTags->"auxiliary function"],
Cell[97556, 3137, 783, 22, 27, "NumberedEquation",
  Evaluatable->False],
Cell[98342, 3161, 235, 6, 54, "Text",
  Evaluatable->False,
  CellTags->"Euler operator"],
Cell[98580, 3169, 434, 9, 55, "NumberedEquation",
  Evaluatable->False],
Cell[99017, 3180, 727, 22, 75, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[99781, 3207, 209, 7, 50, "Subsection",
  Evaluatable->False,
  CellTags->"Euler operator for q-dependent variables"],
Cell[99993, 3216, 1132, 34, 75, "Text",
  Evaluatable->False,
  CellTags->{"functional", "Euler operator"}],
Cell[101128, 3252, 325, 7, 53, "NumberedEquation",
  Evaluatable->False],
Cell[101456, 3261, 188, 7, 33, "Text",
  Evaluatable->False],
Cell[101647, 3270, 244, 7, 28, "NumberedEquation",
  Evaluatable->False],
Cell[101894, 3279, 1147, 26, 180, "Text",
  Evaluatable->False,
  CellTags->{"EulerD[]", "loop", "generalized Euler operator"}],
Cell[103044, 3307, 2177, 47, 442, "Input",
  CellTags->"EulerD[]"],
Cell[105224, 3356, 118, 5, 54, "Text",
  Evaluatable->False],
Cell[105345, 3363, 28, 0, 33, "Example"],
Cell[105376, 3365, 490, 10, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "two-dimensional oscillator system", "oscillators", "Lagrange density", 
    "equations of motion", "Euler derivative"}],

Cell[CellGroupData[{
Cell[105891, 3379, 183, 4, 27, "Input"],
Cell[106077, 3385, 77, 1, 30, "Output"]
}, Open  ]],
Cell[106169, 3389, 88, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[106282, 3396, 99, 2, 27, "Input"],
Cell[106384, 3400, 93, 1, 30, "Output"]
}, Open  ]],
Cell[106492, 3404, 140, 3, 33, "Text",
  Evaluatable->False],
Cell[106635, 3409, 612, 17, 96, "Text",
  Evaluatable->False,
  CellTags->"EulerD[]"],
Cell[107250, 3428, 28, 0, 33, "Example"],
Cell[107281, 3430, 141, 4, 33, "Text",
  CellTags->"two-dimensional Lagrangian"],

Cell[CellGroupData[{
Cell[107447, 3438, 216, 5, 27, "Input"],
Cell[107666, 3445, 74, 1, 30, "Output"]
}, Open  ]],
Cell[107755, 3449, 265, 5, 54, "Text",
  CellTags->{"Dirac Lagrangian", "binomial", "Euler-Lagrange equation"}],

Cell[CellGroupData[{
Cell[108045, 3458, 122, 3, 27, "Input"],
Cell[108170, 3463, 115, 2, 30, "Output"]
}, Open  ]],
Cell[108300, 3468, 193, 3, 33, "Text",
  CellTags->"second-order ordinary differential equation"],
Cell[108496, 3473, 677, 14, 117, "Text",
  Evaluatable->False,
  CellTags->{"point system", "Euler derivative", "Euler operator"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[109210, 3492, 348, 12, 50, "Subsection",
  Evaluatable->False,
  CellTags->"Euler operator for (q-p)-dimensions"],
Cell[109561, 3506, 442, 8, 75, "Text",
  Evaluatable->False,
  CellTags->{
  "Maxwell equation", "Schr\[ODoubleDot]dinger equation", "Euler equation", 
    "hydrodynamics"}],
Cell[110006, 3516, 209, 6, 38, "Definition",
  CellTags->"Definition: (qp)-dimensional Euler operator"],
Cell[110218, 3524, 1419, 49, 75, "Text",
  Evaluatable->False,
  CellTags->"functional"],
Cell[111640, 3575, 345, 10, 55, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-25"],
Cell[111988, 3587, 697, 25, 54, "Text",
  Evaluatable->False,
  CellTags->"multi index"],
Cell[112688, 3614, 700, 24, 75, "Text",
  Evaluatable->False,
  CellTags->"Euler equation"],
Cell[113391, 3640, 369, 9, 28, "NumberedEquation",
  Evaluatable->False],
Cell[113763, 3651, 569, 14, 96, "Text",
  Evaluatable->False,
  CellTags->{"general Euler operator", "EulerD[]"}],
Cell[114335, 3667, 2287, 43, 496, "Input",
  CellTags->"EulerD[]"],
Cell[116625, 3712, 292, 6, 54, "Text",
  CellTags->{"wave equation", "coupled nonlinear diffusion equations"}],
Cell[116920, 3720, 28, 0, 33, "Example"],
Cell[116951, 3722, 288, 10, 54, "Text",
  Evaluatable->False],
Cell[117242, 3734, 660, 18, 44, "NumberedEquation",
  Evaluatable->False],
Cell[117905, 3754, 245, 5, 54, "Text",
  Evaluatable->False,
  CellTags->{
  "variational derivative", "Euler equation", "Laplace equation"}],
Cell[118153, 3761, 271, 8, 29, "NumberedEquation",
  Evaluatable->False],
Cell[118427, 3771, 275, 7, 54, "Text",
  Evaluatable->False,
  CellTags->{"EulerD[]", "pencil calculation"}],

Cell[CellGroupData[{
Cell[118727, 3782, 228, 5, 57, "Input"],
Cell[118958, 3789, 78, 1, 42, "Output"]
}, Open  ]],
Cell[119051, 3793, 174, 8, 33, "Text",
  CellTags->"EulerD[]"],

Cell[CellGroupData[{
Cell[119250, 3805, 148, 3, 45, "Input"],
Cell[119401, 3810, 454, 14, 30, "Output"]
}, Open  ]],
Cell[119870, 3827, 173, 3, 33, "Text",
  Evaluatable->False],
Cell[120046, 3832, 28, 0, 33, "Example"],
Cell[120077, 3834, 507, 12, 75, "Text",
  CellTags->{
  "diffusion", "two component nonlinear medium", "Lagrange density"}],

Cell[CellGroupData[{
Cell[120609, 3850, 212, 4, 45, "Input"],
Cell[120824, 3856, 67, 1, 30, "Output"]
}, Open  ]],
Cell[120906, 3860, 57, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[120988, 3864, 141, 2, 45, "Input"],
Cell[121132, 3868, 715, 24, 49, "Output"]
}, Open  ]],
Cell[121862, 3895, 302, 10, 33, "Text",
  CellTags->"coupled nonlinear diffusion equations"],
Cell[122167, 3907, 765, 13, 117, "Text",
  CellTags->{
  "tangent vector", "prolongation", "Frechet derivative", "Euler derivative", 
    "non-standard differential operators", 
    "symmetry analysis of differential equations", "differential operators"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[122981, 3926, 119, 2, 52, "Section",
  Evaluatable->False,
  CellTags->"Prolongation of vector fields"],
Cell[123103, 3930, 678, 12, 117, "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "symmetry", "symmetries of differential equations", 
    "prolongation", "extension", "Lie theory"}],
Cell[123784, 3944, 2111, 57, 160, "Text",
  Evaluatable->False,
  CellTags->{
  "tangent vector", "independent variables", "curve in parametric form", 
    "three dimensional spiral", "solenoid"}],

Cell[CellGroupData[{
Cell[125920, 4005, 76, 1, 30, "Input"],
Cell[125999, 4008, 61, 1, 33, "Output"]
}, Open  ]],
Cell[126075, 4012, 92, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[126192, 4017, 211, 5, 63, "Input"],
Cell[126406, 4024, 32841, 1093, 256, 12392, 835, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[159262, 5120, 275, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"tangent vector"],

Cell[CellGroupData[{
Cell[159562, 5132, 68, 1, 27, "Input"],
Cell[159633, 5135, 76, 1, 47, "Output"]
}, Open  ]],
Cell[159724, 5139, 713, 16, 117, "Text",
  Evaluatable->False,
  CellTags->{"parametric representation", "vector field", "Line[]"}],
Cell[160440, 5157, 245, 5, 106, "Input"],
Cell[160688, 5164, 189, 5, 54, "Text",
  Evaluatable->False,
  CellTags->"graphic primitives"],

Cell[CellGroupData[{
Cell[160902, 5173, 112, 2, 45, "Input"],
Cell[161017, 5177, 34522, 1211, 253, 13514, 946, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[195554, 6391, 477, 11, 75, "Text",
  Evaluatable->False,
  CellTags->{"spiral", "tangent vector", "Cartesian coordinates"}],
Cell[196034, 6404, 309, 9, 68, "NumberedEquation",
  Evaluatable->False],
Cell[196346, 6415, 736, 14, 117, "Text",
  Evaluatable->False,
  CellTags->{
  "partial differentiation", "partial derivatives", "Cartesian basis", 
    "differential operator in local coordinates"}],
Cell[197085, 6431, 86, 1, 38, "Definition",
  CellTags->"Definition: Vector Field"],
Cell[197174, 6434, 515, 14, 54, "Text",
  Evaluatable->False,
  CellTags->{"manifold", "local coordinates"}],
Cell[197692, 6450, 304, 6, 44, "NumberedEquation",
  Evaluatable->False],
Cell[197999, 6458, 248, 9, 33, "Text",
  Evaluatable->False],
Cell[198250, 6469, 152, 6, 33, "Text",
  Evaluatable->False],
Cell[198405, 6477, 387, 9, 107, "Input",
  CellTags->"VectorField[]"],
Cell[198795, 6488, 231, 8, 33, "Text",
  Evaluatable->False,
  CellTags->"manifold"],
Cell[199029, 6498, 77, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[199131, 6504, 75, 1, 27, "Input"],
Cell[199209, 6507, 73, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[199319, 6513, 85, 1, 27, "Input"],
Cell[199407, 6516, 64, 1, 30, "Output"]
}, Open  ]],
Cell[199486, 6520, 1058, 27, 138, "Text",
  Evaluatable->False,
  CellTags->{
  "velocity field", "laminar fluid flow", "fluid flow", 
    "velocity of a fluid particle"}],
Cell[200547, 6549, 669, 11, 138, "Text",
  Evaluatable->False,
  CellTags->{"stream lines", "potential representation", "flow", "laminar"}],

Cell[CellGroupData[{
Cell[201241, 6564, 284, 5, 40, "Input"],
Cell[201528, 6571, 641, 17, 44, "Output"]
}, Open  ]],
Cell[202184, 6591, 916, 24, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "flow equations", "tangent vector", "components of tangent vector", 
    "origin", "initial conditions", "vector field"}],

Cell[CellGroupData[{
Cell[203125, 6619, 210, 5, 63, "Input"],
Cell[203338, 6626, 447, 7, 88, "Output"]
}, Open  ]],
Cell[203800, 6636, 1139, 28, 138, "Text",
  Evaluatable->False,
  CellTags->{
  "rotation", "translation", "transformation", "flow of a vector field"}],
Cell[204942, 6666, 56, 0, 38, "Definition"],
Cell[205001, 6668, 679, 20, 54, "Text",
  Evaluatable->False,
  CellTags->{"integral curve", "manifold"}],
Cell[205683, 6690, 119, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"properties of a flow"],
Cell[205805, 6694, 520, 13, 28, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-31"],
Cell[206328, 6709, 703, 18, 75, "Text",
  Evaluatable->False,
  CellTags->{"property of flow", "identity"}],
Cell[207034, 6729, 367, 10, 28, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-32"],
Cell[207404, 6741, 906, 20, 117, "Text",
  Evaluatable->False,
  CellTags->{"group", "exponentiation", "exponentiation of vector field"}],
Cell[208313, 6763, 213, 6, 31, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-33"],
Cell[208529, 6771, 1067, 28, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "infinitesimal generator", "infinitesimal generator of the transformation", 
    "infinitesimal representation"}],
Cell[209599, 6801, 774, 21, 31, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-34"],
Cell[210376, 6824, 868, 23, 55, "Text",
  Evaluatable->False,
  CellTags->{"characteristic equations", "determining equations"}],
Cell[211247, 6849, 578, 16, 44, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-35"],
Cell[211828, 6867, 736, 19, 75, "Text",
  Evaluatable->False,
  CellTags->{"initial condition", "vector field", "manifold"}],
Cell[212567, 6888, 28, 0, 33, "Example"],
Cell[212598, 6890, 629, 17, 54, "Text",
  Evaluatable->False,
  CellTags->{
  "translation", "one-dimensinal translation", "characteristic equation"}],

Cell[CellGroupData[{
Cell[213252, 6911, 107, 2, 27, "Input"],
Cell[213362, 6915, 170, 5, 30, "Output"]
}, Open  ]],
Cell[213547, 6923, 581, 19, 54, "Text",
  Evaluatable->False,
  CellTags->{"first-order ODE", "ODE of first-order"}],

Cell[CellGroupData[{
Cell[214153, 6946, 133, 3, 27, "Input"],
Cell[214289, 6951, 74, 1, 30, "Output"]
}, Open  ]],
Cell[214378, 6955, 213, 7, 33, "Text",
  Evaluatable->False],
Cell[214594, 6964, 104, 2, 27, "Input"],
Cell[214701, 6968, 416, 13, 54, "Text",
  Evaluatable->False,
  CellTags->{"flow", "translation"}],

Cell[CellGroupData[{
Cell[215142, 6985, 159, 3, 27, "Input"],
Cell[215304, 6990, 38, 1, 30, "Output"]
}, Open  ]],
Cell[215357, 6994, 317, 9, 54, "Text",
  Evaluatable->False,
  CellTags->{"group of translation", "identity of group"}],

Cell[CellGroupData[{
Cell[215699, 7007, 80, 2, 27, "Input"],
Cell[215782, 7011, 38, 1, 30, "Output"]
}, Open  ]],
Cell[215835, 7015, 274, 6, 54, "Text",
  Evaluatable->False,
  CellTags->{"inverse element", "inverse element of group"}],

Cell[CellGroupData[{
Cell[216134, 7025, 224, 5, 45, "Input"],
Cell[216361, 7032, 83, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[216481, 7038, 129, 2, 27, "Input"],
Cell[216613, 7042, 92, 1, 30, "Output"]
}, Open  ]],
Cell[216720, 7046, 249, 5, 54, "Text",
  Evaluatable->False,
  CellTags->{"inverse translation", "associativity"}],

Cell[CellGroupData[{
Cell[216994, 7055, 347, 7, 63, "Input"],
Cell[217344, 7064, 38, 1, 30, "Output"]
}, Open  ]],
Cell[217397, 7068, 679, 18, 75, "Text",
  Evaluatable->False,
  CellTags->{
  "properties of a group", "symmetry of translation", "symmetries"}],
Cell[218079, 7088, 28, 0, 33, "Example"],
Cell[218110, 7090, 643, 19, 54, "Text",
  Evaluatable->False,
  CellTags->"characteristic equation"],

Cell[CellGroupData[{
Cell[218778, 7113, 121, 3, 27, "Input"],
Cell[218902, 7118, 188, 5, 30, "Output"]
}, Open  ]],
Cell[219105, 7126, 71, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[219201, 7131, 131, 3, 27, "Input"],
Cell[219335, 7136, 76, 1, 30, "Output"]
}, Open  ]],
Cell[219426, 7140, 803, 20, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "scaling transformation", "closure", "identity", "closure of group", 
    "identity of group", "flow"}],
Cell[220232, 7162, 108, 2, 27, "Input"],
Cell[220343, 7166, 87, 1, 33, "Text",
  CellTags->"scaling group"],

Cell[CellGroupData[{
Cell[220455, 7171, 159, 3, 27, "Input"],
Cell[220617, 7176, 38, 1, 30, "Output"]
}, Open  ]],
Cell[220670, 7180, 44, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[220739, 7184, 80, 2, 27, "Input"],
Cell[220822, 7188, 38, 1, 30, "Output"]
}, Open  ]],
Cell[220875, 7192, 242, 5, 54, "Text",
  Evaluatable->False,
  CellTags->"identity transformation"],
Cell[221120, 7199, 28, 0, 33, "Example"],
Cell[221151, 7201, 472, 9, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "global transformation", "rotation", "transformation"}],
Cell[221626, 7212, 171, 3, 27, "Input"],
Cell[221800, 7217, 752, 20, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "infinitesimal representation", "flow of a group", "infinitesimals", 
    "coefficients of the vector field"}],
Cell[222555, 7239, 650, 19, 30, "NumberedEquation",
  Evaluatable->False],
Cell[223208, 7260, 117, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],
Cell[223328, 7264, 574, 17, 44, "NumberedEquation",
  CellTags->"eq-37"],
Cell[223905, 7283, 92, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[224022, 7288, 159, 4, 27, "Input"],
Cell[224184, 7294, 45, 1, 30, "Output"]
}, Open  ]],
Cell[224244, 7298, 890, 23, 96, "Text",
  Evaluatable->False,
  CellTags->"vector field"],

Cell[CellGroupData[{
Cell[225159, 7325, 179, 3, 27, "Input"],
Cell[225341, 7330, 441, 12, 30, "Output"]
}, Open  ]],
Cell[225797, 7345, 68, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[225890, 7349, 228, 5, 63, "Input"],
Cell[226121, 7356, 174, 3, 30, "Output"]
}, Open  ]],
Cell[226310, 7362, 126, 3, 33, "Text",
  Evaluatable->False],
Cell[226439, 7367, 28, 0, 33, "Example"],
Cell[226470, 7369, 265, 6, 54, "Text",
  Evaluatable->False,
  CellTags->{"global group action", "group action", "projective group"}],
Cell[226738, 7377, 161, 3, 38, "Input"],
Cell[226902, 7382, 274, 8, 33, "Text",
  Evaluatable->False,
  CellTags->{"infinitesimals", "flow"}],

Cell[CellGroupData[{
Cell[227201, 7394, 159, 4, 27, "Input"],
Cell[227363, 7400, 54, 1, 30, "Output"]
}, Open  ]],
Cell[227432, 7404, 1104, 28, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "package", "Graphics`PlotField", 
    "grapical representation of vector field", 
    "representation of vector field"}],
Cell[228539, 7434, 84, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[228648, 7440, 148, 3, 45, "Input"],
Cell[228799, 7445, 48817, 1862, 235, 32747, 1657, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[277631, 9310, 166, 4, 27, "Input"],
Cell[277800, 9316, 1943, 46, 201, "Text",
  Evaluatable->False,
  CellTags->{
  "manifold", "smooth function", "transformation", "independent variables", 
    "vector field", "flow", "transformation of independent variables"}],
Cell[279746, 9364, 60, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[279831, 9369, 88, 1, 27, "Input"],
Cell[279922, 9372, 368, 10, 30, "Output"]
}, Open  ]],
Cell[280305, 9385, 574, 13, 96, "Text",
  Evaluatable->False,
  CellTags->{"identity", "infinitesimals"}],

Cell[CellGroupData[{
Cell[280904, 9402, 411, 10, 27, "Input"],
Cell[281318, 9414, 365, 9, 30, "Output"]
}, Open  ]],
Cell[281698, 9426, 447, 12, 75, "Text",
  Evaluatable->False,
  CellTags->{"delayed rule", "coefficients of the vector field"}],

Cell[CellGroupData[{
Cell[282170, 9442, 134, 2, 27, "Input"],
Cell[282307, 9446, 166, 4, 30, "Output"]
}, Open  ]],
Cell[282488, 9453, 1536, 41, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "infinitesimal flow", 
    "first order partial differential operator", "Taylor series"}],

Cell[CellGroupData[{
Cell[284049, 9498, 108, 2, 27, "Input"],
Cell[284160, 9502, 507, 14, 30, "Output"]
}, Open  ]],
Cell[284682, 9519, 431, 13, 54, "Text",
  Evaluatable->False,
  CellTags->"infinitesimal change"],
Cell[285116, 9534, 528, 14, 27, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-38"],
Cell[285647, 9550, 489, 16, 33, "Text",
  Evaluatable->False],
Cell[286139, 9568, 1239, 19, 222, "Text",
  Evaluatable->False,
  CellTags->{
  "vector field", "manifold", "Cartesian basis", "tangent vector", 
    "differential basis", "transformed function", "infinitesimal change", 
    "dependent variables", "prolonging a vector field", 
    "extending a vector field"}],
Cell[287381, 9589, 588, 12, 96, "Text",
  Evaluatable->False,
  CellTags->{"prolong a manifold", "extend a manifold", "extension"}],
Cell[287972, 9603, 1015, 28, 31, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-39"],
Cell[288990, 9633, 1167, 28, 138, "Text",
  Evaluatable->False,
  CellTags->{
  "manifold", "transformed derivatives", "transformation", "Calculus"}],
Cell[290160, 9663, 946, 30, 117, "Text",
  Evaluatable->False,
  CellTags->{
  "transformation", "change of original variables", "new variables"}],
Cell[291109, 9695, 226, 4, 45, "Input"],
Cell[291338, 9701, 1327, 37, 180, "Text",
  Evaluatable->False,
  CellTags->{"original variables", "changes of variables"}],

Cell[CellGroupData[{
Cell[292690, 9742, 323, 9, 40, "Input"],
Cell[293016, 9753, 97, 2, 44, "Output"]
}, Open  ]],
Cell[293128, 9758, 328, 7, 75, "Text",
  Evaluatable->False,
  CellTags->{"new coordinate system", "transformation"}],

Cell[CellGroupData[{
Cell[293481, 9769, 410, 11, 27, "Input"],
Cell[293894, 9782, 136, 3, 44, "Output"]
}, Open  ]],
Cell[294045, 9788, 1421, 29, 222, "Text",
  Evaluatable->False,
  CellTags->{
  "prolongation", "flow of the vector field", "extension", 
    "one parameter transformation"}],
Cell[295469, 9819, 206, 4, 45, "Input"],
Cell[295678, 9825, 309, 5, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[296012, 9834, 320, 8, 40, "Input"],
Cell[296335, 9844, 136, 3, 44, "Output"]
}, Open  ]],
Cell[296486, 9850, 594, 9, 117, "Text",
  Evaluatable->False,
  CellTags->{"transformation", "infinitesimal transformation", "manifold"}],
Cell[297083, 9861, 216, 4, 45, "Input"],
Cell[297302, 9867, 165, 4, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[297492, 9875, 333, 8, 40, "Input"],
Cell[297828, 9885, 152, 2, 44, "Output"]
}, Open  ]],
Cell[297995, 9890, 419, 9, 75, "Text",
  Evaluatable->False,
  CellTags->{"infinitesimal representation", "rational expression"}],

Cell[CellGroupData[{
Cell[298439, 9903, 497, 13, 27, "Input"],
Cell[298939, 9918, 757, 22, 30, "Output"]
}, Open  ]],
Cell[299711, 9943, 610, 14, 96, "Text",
  Evaluatable->False,
  CellTags->{"infinitesimal transformation", "prolonged vector field"}],

Cell[CellGroupData[{
Cell[300346, 9961, 515, 11, 45, "Input"],
Cell[300864, 9974, 2783, 58, 90, "Output"]
}, Open  ]],
Cell[303662, 10035, 583, 16, 96, "Text",
  Evaluatable->False,
  CellTags->"first prolongation"],
Cell[304248, 10053, 482, 11, 46, "Input"],
Cell[304733, 10066, 290, 8, 54, "Text"],

Cell[CellGroupData[{
Cell[305048, 10078, 78, 1, 27, "Input"],
Cell[305129, 10081, 167, 3, 30, "Output"]
}, Open  ]],
Cell[305311, 10087, 876, 19, 159, "Text",
  Evaluatable->False],
Cell[306190, 10108, 203, 4, 26, "ListItem",
  Evaluatable->False,
  CellTags->{"old differentials", "new differentials"}],
Cell[306396, 10114, 206, 7, 26, "ListItem",
  Evaluatable->False,
  CellTags->"infinitesimal transformation"],
Cell[306605, 10123, 161, 4, 26, "ListItem",
  Evaluatable->False],
Cell[306769, 10129, 250, 6, 54, "Text",
  Evaluatable->False,
  CellTags->"extension"],

Cell[CellGroupData[{
Cell[307044, 10139, 527, 12, 71, "Input"],
Cell[307574, 10153, 498, 10, 50, "Output"]
}, Open  ]],
Cell[308087, 10166, 593, 12, 117, "Text",
  Evaluatable->False,
  CellTags->"twice extended vector field"],
Cell[308683, 10180, 820, 18, 83, "Input"],
Cell[309506, 10200, 105, 1, 33, "Text",
  CellTags->"auxiliary function"],

Cell[CellGroupData[{
Cell[309636, 10205, 81, 1, 27, "Input"],
Cell[309720, 10208, 605, 11, 70, "Output"]
}, Open  ]],
Cell[310340, 10222, 913, 19, 138, "Text",
  Evaluatable->False,
  CellTags->{
  "second extension", "extension", "higher extension", 
    "recursive definition of extension", "prolongation formula"}],
Cell[311256, 10243, 348, 9, 63, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-40"],
Cell[311607, 10254, 906, 30, 54, "Text",
  Evaluatable->False,
  CellTags->"prolongation"],
Cell[312516, 10286, 327, 8, 55, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-41"],
Cell[312846, 10296, 852, 26, 76, "Text",
  Evaluatable->False,
  CellTags->"recursive prolongation formula"],
Cell[313701, 10324, 708, 17, 117, "Text",
  Evaluatable->False],
Cell[314412, 10343, 798, 15, 117, "Text",
  Evaluatable->False,
  CellTags->{
  "calculation of the prolongation", "infinitesimals", "characteristics", 
    "Frechet derivative"}],
Cell[315213, 10360, 814, 18, 117, "Text",
  Evaluatable->False,
  CellTags->{
  "recursive prolongation", "Frechet prolongation", "characteristics", 
    "characteristic function", "general vector field"}],
Cell[316030, 10380, 304, 8, 63, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-42"],
Cell[316337, 10390, 1077, 27, 138, "Text",
  Evaluatable->False,
  CellTags->{
  "characteristics", "extended manifold", "manifold", "Frechet derivative", 
    "prolongation"}],
Cell[317417, 10419, 234, 6, 31, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-43"],
Cell[317654, 10427, 253, 7, 33, "Text",
  Evaluatable->False,
  CellTags->"prolongation of the vector field"],
Cell[317910, 10436, 339, 8, 63, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-44"],
Cell[318252, 10446, 1031, 30, 75, "Text",
  Evaluatable->False],
Cell[319286, 10478, 358, 11, 54, "Text",
  Evaluatable->False,
  CellTags->"expansion coefficient of the prolongation"],
Cell[319647, 10491, 378, 11, 55, "NumberedEquation",
  Evaluatable->False],
Cell[320028, 10504, 306, 9, 54, "Text",
  Evaluatable->False,
  CellTags->"prolongation formula"],
Cell[320337, 10515, 529, 11, 63, "NumberedEquation",
  Evaluatable->False],
Cell[320869, 10528, 167, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"total derivative"],
Cell[321039, 10535, 393, 9, 63, "NumberedEquation",
  Evaluatable->False],
Cell[321435, 10546, 119, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"prolongation"],
Cell[321557, 10550, 243, 5, 55, "NumberedEquation",
  Evaluatable->False],
Cell[321803, 10557, 593, 20, 54, "Text",
  Evaluatable->False],
Cell[322399, 10579, 236, 5, 55, "NumberedEquation",
  Evaluatable->False],
Cell[322638, 10586, 617, 15, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "characteristics", "infinitesimal representation of characteristics"}],
Cell[323258, 10603, 1409, 35, 59, "NumberedEquation",
  CellTags->"eq-50"],
Cell[324670, 10640, 962, 19, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "prolongation", "calculate the prolongation", 
    "Lie-B\[ADoubleDot]cklund symmetries"}],
Cell[325635, 10661, 1657, 40, 222, "Text",
  Evaluatable->False,
  CellTags->{
  "Prolongation[]", "Frechet derivative", 
    "symbolic names of infinitesimals"}],
Cell[327295, 10703, 2181, 41, 710, "Input",
  InitializationCell->True,
  CellTags->{"Function Prolongation", "Prolongation[]"}],
Cell[329479, 10746, 840, 18, 138, "Text",
  Evaluatable->False,
  CellTags->{"Prolongation[]", "Frechet derivative"}],

Cell[CellGroupData[{
Cell[330344, 10768, 116, 2, 27, "Input"],
Cell[330463, 10772, 3558, 93, 130, "Output"]
}, Open  ]],
Cell[334036, 10868, 503, 13, 75, "Text",
  Evaluatable->False,
  CellTags->"LieTraditionalForm[]"],

Cell[CellGroupData[{
Cell[334564, 10885, 71, 1, 27, "Input"],
Cell[334638, 10888, 259, 5, 30, "Output"]
}, Open  ]],
Cell[334912, 10896, 2107, 54, 306, "Text",
  CellTags->{
  "Prolongation[]", "TraditionalLieForm", "LieTraditionalForm[]", 
    "higher order prolongations", "vector field", "LTF[]"}],

Cell[CellGroupData[{
Cell[337044, 10954, 221, 4, 46, "Input"],
Cell[337268, 10960, 842, 14, 72, "Output"]
}, Open  ]],
Cell[338125, 10977, 581, 17, 96, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[338731, 10998, 51, 1, 27, "Input"],
Cell[338785, 11001, 12167, 303, 310, "Output"]
}, Open  ]],
Cell[350967, 11307, 324, 7, 75, "Text",
  Evaluatable->False,
  CellTags->"symmetry analysis of differential equations"],
Cell[351294, 11316, 28, 0, 33, "Example"],
Cell[351325, 11318, 166, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"infinitesimal flow"],
Cell[351494, 11325, 164, 3, 45, "Input"],
Cell[351661, 11330, 446, 11, 54, "Text",
  Evaluatable->False,
  CellTags->{"prolongation", "Prolongation[]"}],

Cell[CellGroupData[{
Cell[352132, 11345, 130, 2, 28, "Input"],
Cell[352265, 11349, 414, 7, 52, "Output"]
}, Open  ]],
Cell[352694, 11359, 604, 17, 75, "Text",
  Evaluatable->False,
  CellTags->{"infinitesimals", "prolongation of the vector field"}],

Cell[CellGroupData[{
Cell[353323, 11380, 114, 2, 27, "Input"],
Cell[353440, 11384, 56, 1, 30, "Output"]
}, Open  ]],
Cell[353511, 11388, 470, 11, 75, "Text",
  CellTags->"symmetry group"],
Cell[353984, 11401, 28, 0, 33, "Example"],
Cell[354015, 11403, 566, 13, 78, "Text",
  Evaluatable->False,
  CellTags->"symmetry of rotation"],

Cell[CellGroupData[{
Cell[354606, 11420, 231, 5, 30, "Input"],
Cell[354840, 11427, 37, 1, 30, "Output"]
}, Open  ]],
Cell[354892, 11431, 741, 20, 57, "Text",
  Evaluatable->False],
Cell[355636, 11453, 212, 4, 54, "Text"],
Cell[355851, 11459, 147, 3, 44, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

