(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21276,        500]*)
(*NotebookOutlinePosition[     42775,       1027]*)
(*  CellTagsIndexPosition[     40516,        964]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["1", "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  AspectRatioFixed->True],

Cell["Introduction", "Title",
  CellMargins->{{Inherited, Inherited}, {72, Inherited}},
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  AspectRatioFixed->True],

Cell[TextData[
"Symmetry principles play an important role in the laws of nature. They \
summarize the regularities of the laws that are independent of the specific \
dynamics. Thus, invariance principles provide a structure and coherence to \
the laws of nature, just as the laws of nature provide a structure and \
coherence to the set of events. In fact, it is hard to imagine that progress \
could have been made in deducing the laws of nature without the existence of \
certain symmetries. The ability to represent experiments in different places \
at different times is based on the invariance of the laws of nature under \
space-time translations. Without regularities embodied in the laws of \
physics, we would be unable to make sense of physical events; without \
regularities in the laws of nature, we would be unable to discover the laws \
themselves. Today we realize that symmetry principles are even more powerful\
\[LongDash]they dictate the form of the laws of nature."], "Text",
  PageBreakBelow->False,
  CellTags->{
  "space-time translation", "symmetry principle", "laws of nature"}],

Cell[TextData[{
  "An important implication of symmetry in physics and in mathematics is the \
existence of conservation laws. For every global continuous symmetry (i.e., a \
 transformation of a physical system that acts the same way everywhere and at \
all times), there exists an associated time-independent quantity. This \
connection went unnoticed until 1918, when ",
  ButtonBox["Emmy Noether [1918]",
    ButtonData:>{"Literat.nb", "Noether-18"},
    ButtonStyle->"Hyperlink"],
  " proved her famous theorem relating symmetry and conservation laws. Thus, \
due to the invariance of the laws of physics under spatial transformations, \
momentum is conserved; due to time-translational invariance, energy is \
conserved; and due to the invariance under a change in phase of the wave \
function of charged particles, electric charge is conserved. It is essential \
that the symmetry be continuous; namely that it is specified by a set of \
parameters that can be varied continuously, and that the symmetry \
transformation can be arbitrary close to the identity transformation. The \
discrete symmetries of nature, such as time-reversal invariance or mirror \
reflection, do not lead to new conserved quantities."
}], "Text",
  PageBreakBelow->True,
  CellTags->{
  "continuous symmetry", "laws of physics", "time translational invariance", 
    "discrete symmetry", "time reversal invariance", "mirror reflection", 
    "conserved quantity"}],

Cell[TextData[
"Until the 20th century, principles of symmetry played only a small role in \
theoretical physics. The Greeks and others were fascinated by the symmetries \
of objects and believed that these were mirrored in the structure of nature. \
Even Kepler attempted to impose his notions of symmetry on the motion of the \
planets. Newton\[CloseCurlyQuote]s laws of mechanics embodied symmetry \
principles realized in the equivalence of inertial frames, or Galilean \
invariance. These symmetries implied conservation laws. In the 19th century, \
this ancient situation changed dramatically beginning with Lie. His great \
advance in 1873 was to put symmetry first, to regard the symmetry principle \
as the primary feature of nature that constrains the allowable dynamical \
laws. Lie applied his theory to different models given by differential \
equations. In this way, he created the symmetry analysis of differential \
equations."], "Text",
  CellTags->{
  "principles of symmetry", "Newton's laws", "Galilean invariance", 
    "conservation laws"}],

Cell[TextData[{
  "Thus, symmetry analysis of differential equations is an old theme in the \
field of applied mathematics and physics. The subject of the present book \
started in the late 19th century with the work of ",
  ButtonBox["Marius Sophus Lie",
    ButtonData:>{"MSLie.nb", None},
    ButtonStyle->"Hyperlink"],
  ". The theory in its basic form was developed and applied by Lie during the \
period 1872\[Dash]1899. Until now there have been extensions of the theory \
and a continuous application in physics, especially in hydrodynamics, \
mechanics, electrodynamics, quantum theory, statistical mechanics, field \
theory, particle physics, etc. Today, symmetry analysis is one of the rare \
theories which allows one to derive solutions of differential equations in a \
completely algorithmic way. Among other solution procedures like the inverse \
scattering theory and the Hirota technique, Lie\[CloseCurlyQuote]s theory \
takes an outstanding position. Although Lie\[CloseCurlyQuote]s theory is \
applicable to any sort of differential equations, the other theories are \
commonly useful in the solution of so-called completely integrable equations \
or underlie some other restrictions. However, we will present here an \
overview of Lie\[CloseCurlyQuote]s procedure and its application to some \
examples which are either of practical or theoretical interest. During the \
last few decades, there has been a revival of interest in Lie\
\[CloseCurlyQuote]s theory and significant progress has been made due to the \
efforts of several mathematicians and physicists."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "symmetry analysis of differential equations", "hydrodynamics", "mechanics",
     "electrodynamics", "quantum theory", "statistical mechanics", 
    "field theory", "particle physics", "completely integrable equations"}],

Cell[TextData[
"Lie\[CloseCurlyQuote]s theory is powerful, versatile, and fundamental to the \
development of systematic procedures that lead to invariant solutions of \
boundary value problems. As this theory is not based on linear operators, \
superposition or other requirements of linear solution techniques, they are \
applicable to both linear and non-linear differential models."], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "linear operators", "superposition", "linear solution techniques"}],

Cell["\<\
A central problem in physics, mathematics, and engineering is to \
find solutions of a given system of differential equations. These equations \
may be linear or nonlinear. The generic case of practical problems which \
handle ordinary as well as partial differential equations are nonlinear \
models. Let us summarize all these equations by the notation\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "system of differential equations", "nonlinear", 
    "partial differential equation"}],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\(\[CapitalDelta]\^i\)(x, u\_\((k)\))\  = \ 0\ , 
    \ \ \ \ \ \ \ \ \ i = 1, 2, \[Ellipsis], m\)]]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is a ",
  StyleBox["p",
    FontSlant->"Italic"],
  "-dimensional vector of independent variables and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  " denotes the derivatives up to order ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1, \[Ellipsis]\)]],
  " of a ",
  StyleBox["q",
    FontSlant->"Italic"],
  "-dimensional vector of dependent variables\[NoBreak] ",
  StyleBox["u",
    FontSlant->"Italic"],
  ". The central question for such a general system of nonlinear partial or \
ordinary differential equations is: Can we find a universal procedure which \
gives us solutions for this system of equations? We do not try to find the \
general solution but simply a solution. That this is not a trivial task has \
been known for a long time. In the last century, Lie pointed out this central \
problem in a foreword to his lecture Differentialgleichungen as follows:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Die \[ADoubleDot]lteren Untersuchungen \[UDoubleDot]ber \
gew\[ODoubleDot]hnliche Differentialgle-ichungen, wie man sie in den gebr\
\[ADoubleDot]uchlichen Lehrb\[UDoubleDot]chern findet, bilden kein \
systematisches Ganzes. Man entwickelte specielle Integrationstheorien z.B. f\
\[UDoubleDot]r die homogenen Differentialgleichungen, f\[UDoubleDot]r die \
linearen Differentialgleichungen und andere specielle integrable Formen von \
Differentialgleichungen. Es war aber den Mathematikern entgangen, da\[SZ] \
diese speciellen Theorien sich unter eine allgemeine Methode unterordnen \
lassen. Das Fundament dieser Methoden ist der Begriff der ",
  StyleBox["infinitisemalen Transformation ",
    FontWeight->"Bold"],
  "und der damit auf das engste zusammenh\[ADoubleDot]ngende Begriff der ",
  StyleBox["eingliedrigen Gruppe",
    FontWeight->"Bold"],
  "."
}], "Quote",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CharacterEncoding->"$SystemCharacterEncoding"],

Cell[TextData[{
  "\[LongDash]",
  StyleBox["Auszug aus ",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["Differentialgleichungen",
    FontSlant->"Italic"],
  " von Sophus Lie, Leipzig 1891"
}], "Quote",
  Evaluatable->False,
  TextAlignment->Right,
  TextJustification->0,
  AspectRatioFixed->True],

Cell["The translation of these comments is:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "The older examinations on ordinary differential equations as found in \
standard books are not systematic. The writers developed special integration \
theories for homogeneous differential equations, for linear differential \
equations, and other special integrable forms of differential equations. \
However, the mathematicians did not realize that these special theories are \
all contained in the term ",
    Evaluatable->False,
    TextJustification->1,
    AspectRatioFixed->True],
  StyleBox["infinitesimal transformations",
    Evaluatable->False,
    TextJustification->1,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[", which is closely connected with the term of a ",
    Evaluatable->False,
    TextJustification->1,
    AspectRatioFixed->True],
  StyleBox["one parametric group",
    Evaluatable->False,
    TextJustification->1,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[".",
    Evaluatable->False,
    TextJustification->1,
    AspectRatioFixed->True]
}], "Quote",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "\[LongDash]Quotation from  ",
  StyleBox["Differentialgleichungen",
    FontSlant->"Italic"],
  " by Sophus Lie, Leipzig\[NonBreakingSpace]\[NoBreak]1891"
}], "Quote",
  Evaluatable->False,
  TextAlignment->Right,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  "One of the main deficiencies of Lie\[CloseCurlyQuote]s theory is the \
tremendous amount of work necessary to derive a solution of a given \
differential equation. This work of algebraic manipulation increases if the \
differential equation depends not only on one but on several independent \
variables. It increases even more if we study a system of equations. For such \
general situations, it may happen that we have to handle hundreds of \
equations to find a single solution. In the past, this large amount of work \
was a severe barrier for using Lie\[CloseCurlyQuote]s theory. Today, we are \
able to overcome the problems of algebraic manipulation of this great number \
of expressions. Using computer algebra systems like ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Maple",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Macsyma",
    FontSlant->"Italic"],
  ", or ",
  StyleBox["Axiom",
    FontSlant->"Italic"],
  ", to name the more powerful systems, we can manage the laborious work in \
an up-to-date fashion. "
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "algebraic manipulation", "computer algebra", "Mathematica", "Maple", 
    "Macsyma", "Axiom"}],

Cell[TextData[{
  "In this book, we prefer ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "to carry out the calculations. An overview of programs written in other \
programming languages is given in recent articles by Hereman [",
  ButtonBox["1994",
    ButtonData:>{"Literat.nb", "Here-94"},
    ButtonStyle->"Hyperlink"],
  ",",
  ButtonBox["1996",
    ButtonData:>{"Literat.nb", "Hereman-1996"},
    ButtonStyle->"Hyperlink"],
  "]. Hereman shows that there exists a large number of programs with \
different capabilities in different programming languages. Our choice of \
using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a programming language has been motivated by several reasons. First, ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a language which is easy to use. Second, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " allows a direct formulation of the problem. Third, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a very powerful high-level programming language designed for pattern \
matching, which is needed in Lie\[CloseCurlyQuote]s theory to find structures \
of a certain type. Finally, ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "allows a very simple formulation of the theory of Lie. These four points \
were considered in our decision process to choose the programming language."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "To appreciate the present text, the reader should have a moderate \
understanding of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". You will find the explanations for the commands used in the examples in \
Appendix B."
}], "Text"],

Cell[TextData[{
  "Lie\[CloseCurlyQuote]s classical theory is a source for various \
generalizations. Among these generalizations is the ",
  StyleBox["non-classical method",
    FontSlant->"Italic"],
  " of ",
  ButtonBox["Bluman and Cole [1974],",
    ButtonData:>{"Literat.nb", "Bum-74"},
    ButtonStyle->"Hyperlink"],
  " which was the focus of some research in the last few years uncovering the \
connection with the direct reduction method of ",
  ButtonBox["Clarkson and Kruskal [1989]",
    ButtonData:>{"Literat.nb", "Clarkson-89"},
    ButtonStyle->"Hyperlink"],
  ". A recent development in Lie\[CloseCurlyQuote]s theory by ",
  ButtonBox["Baikov, Gazizov, and Ibragimov [1989]",
    ButtonData:>{"Literat.nb", "Baik-89"},
    ButtonStyle->"Hyperlink"],
  " is the introduction of approximate symmetries, allowing the asymptotic \
solutions for a range of parameters to be derived. Another adornment of Lie\
\[CloseCurlyQuote]s classical theory is the introduction of generalized \
symmetries, which is extensively discussed by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ". Generalized symmetries are symmetries which are a generalization of \
contact symmetries. The generalization of Lie\[CloseCurlyQuote]s theory \
releases one or more of the basic properties obeyed by the classical theory."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "Lie's classical theory", "direct reduction method", 
    "approximate symmetries", "asymptotic solutions", 
    "generalized symmetries", "contact symmetries", "non classical method"}],

Cell[TextData[
"The fundamentals of Lie\[CloseCurlyQuote]s theory of symmetry analysis of \
differential equations are based on the invariance of the equation under a \
transformation of independent and dependent variables. This transformation \
forms a local group of point transformations which establishes a \
diffeomorphism on the space of independent and dependent variables, mapping \
solutions of the equations to solutions."], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"local group", "point transformation", "diffeomorphism"}],

Cell[TextData[{
  "The description of the fundamentals of Lie\[CloseCurlyQuote]s theory, Lie \
groups, and Lie algebras is the starting point for our discussions in Chapter \
2. Chapter 3 presents fundamental aspects of derivatives and their \
definitions in ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " Chapter 4 on ordinary differential equations discusses the application of \
Lie\[CloseCurlyQuote]s integration theory in connection with point \
symmetries. Chapter 5 deals with point symmetries in connection with partial \
differential equations. Several examples demonstrate the broad application of \
Lie\[CloseCurlyQuote]s theory. Chapter 6 extends the classical point \
symmetries to non-classical symmetries. In Chapter 7, potential symmetries of \
partial differential equations are examined. The recent development of \
approximate symmetries is contained in Chapter 8. The generalized symmetries \
of PDEs and second-order ODEs is presented in Chapter 9. The last chapter \
contains a special topic of symmetry analysis, i.e., the automatic solution \
of a system of overdetermined equations."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "Lie groups", "Lie algebras", "ordinary differential equation", 
    "Lie's integration theory", "point symmetry", 
    "partial differential equations", "non-classical symmetries", 
    "approximate symmetries", "generalized symmetries", "symmetry analysis", 
    "overdetermined equations"}],

Cell[TextData[{
  "The material contained in the chapters is based on theoretical \
considerations necessary to understand what is going on in the related \
functions of ",
  StyleBox["MathLie.",
    FontSlant->"Italic"],
  " ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package supporting the calculations in the book and more. A full version \
of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " accompanies the book on CD-ROM. A great number of examples contained in \
each chapter demonstrate the broad application of Lie\[CloseCurlyQuote]s \
theory in connection with ",
  StyleBox["MathLie.",
    FontSlant->"Italic"],
  " The examples are designed in such a way that the reader can take an \
active part by calculating the results interactively. This opens the way to \
experimentation with the calculations. Thus, the present book is not a book \
just for reading but a book for experimental mathematics and physics."
}], "Text",
  CellTags->{"MathLie", "CD-Rom", "experiment", "experimental mathematics"}],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"Group.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{673, 668},
WindowMargins->{{14, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Introduction", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Introduction", FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"SectionReferences"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
PrivateFontOptions->{"FontType"->"Outline"},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1.25,
CounterBoxOptions->{CounterFunction:>Identity},
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "space-time translation"->{
    Cell[2506, 68, 1104, 16, 243, "Text",
      PageBreakBelow->False,
      CellTags->{
      "space-time translation", "symmetry principle", "laws of nature"}]},
  "symmetry principle"->{
    Cell[2506, 68, 1104, 16, 243, "Text",
      PageBreakBelow->False,
      CellTags->{
      "space-time translation", "symmetry principle", "laws of nature"}]},
  "laws of nature"->{
    Cell[2506, 68, 1104, 16, 243, "Text",
      PageBreakBelow->False,
      CellTags->{
      "space-time translation", "symmetry principle", "laws of nature"}]},
  "continuous symmetry"->{
    Cell[3613, 86, 1448, 24, 264, "Text",
      PageBreakBelow->True,
      CellTags->{
      "continuous symmetry", "laws of physics", 
        "time translational invariance", "discrete symmetry", 
        "time reversal invariance", "mirror reflection", 
        "conserved quantity"}]},
  "laws of physics"->{
    Cell[3613, 86, 1448, 24, 264, "Text",
      PageBreakBelow->True,
      CellTags->{
      "continuous symmetry", "laws of physics", 
        "time translational invariance", "discrete symmetry", 
        "time reversal invariance", "mirror reflection", 
        "conserved quantity"}]},
  "time translational invariance"->{
    Cell[3613, 86, 1448, 24, 264, "Text",
      PageBreakBelow->True,
      CellTags->{
      "continuous symmetry", "laws of physics", 
        "time translational invariance", "discrete symmetry", 
        "time reversal invariance", "mirror reflection", 
        "conserved quantity"}]},
  "discrete symmetry"->{
    Cell[3613, 86, 1448, 24, 264, "Text",
      PageBreakBelow->True,
      CellTags->{
      "continuous symmetry", "laws of physics", 
        "time translational invariance", "discrete symmetry", 
        "time reversal invariance", "mirror reflection", 
        "conserved quantity"}]},
  "time reversal invariance"->{
    Cell[3613, 86, 1448, 24, 264, "Text",
      PageBreakBelow->True,
      CellTags->{
      "continuous symmetry", "laws of physics", 
        "time translational invariance", "discrete symmetry", 
        "time reversal invariance", "mirror reflection", 
        "conserved quantity"}]},
  "mirror reflection"->{
    Cell[3613, 86, 1448, 24, 264, "Text",
      PageBreakBelow->True,
      CellTags->{
      "continuous symmetry", "laws of physics", 
        "time translational invariance", "discrete symmetry", 
        "time reversal invariance", "mirror reflection", 
        "conserved quantity"}]},
  "conserved quantity"->{
    Cell[3613, 86, 1448, 24, 264, "Text",
      PageBreakBelow->True,
      CellTags->{
      "continuous symmetry", "laws of physics", 
        "time translational invariance", "discrete symmetry", 
        "time reversal invariance", "mirror reflection", 
        "conserved quantity"}]},
  "principles of symmetry"->{
    Cell[5064, 112, 1062, 16, 222, "Text",
      CellTags->{
      "principles of symmetry", "Newton's laws", "Galilean invariance", 
        "conservation laws"}]},
  "Newton's laws"->{
    Cell[5064, 112, 1062, 16, 222, "Text",
      CellTags->{
      "principles of symmetry", "Newton's laws", "Galilean invariance", 
        "conservation laws"}]},
  "Galilean invariance"->{
    Cell[5064, 112, 1062, 16, 222, "Text",
      CellTags->{
      "principles of symmetry", "Newton's laws", "Galilean invariance", 
        "conservation laws"}]},
  "conservation laws"->{
    Cell[5064, 112, 1062, 16, 222, "Text",
      CellTags->{
      "principles of symmetry", "Newton's laws", "Galilean invariance", 
        "conservation laws"}]},
  "symmetry analysis of differential equations"->{
    Cell[6129, 130, 1904, 31, 327, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis of differential equations", "hydrodynamics", 
        "mechanics", "electrodynamics", "quantum theory", 
        "statistical mechanics", "field theory", "particle physics", 
        "completely integrable equations"}]},
  "hydrodynamics"->{
    Cell[6129, 130, 1904, 31, 327, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis of differential equations", "hydrodynamics", 
        "mechanics", "electrodynamics", "quantum theory", 
        "statistical mechanics", "field theory", "particle physics", 
        "completely integrable equations"}]},
  "mechanics"->{
    Cell[6129, 130, 1904, 31, 327, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis of differential equations", "hydrodynamics", 
        "mechanics", "electrodynamics", "quantum theory", 
        "statistical mechanics", "field theory", "particle physics", 
        "completely integrable equations"}]},
  "electrodynamics"->{
    Cell[6129, 130, 1904, 31, 327, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis of differential equations", "hydrodynamics", 
        "mechanics", "electrodynamics", "quantum theory", 
        "statistical mechanics", "field theory", "particle physics", 
        "completely integrable equations"}]},
  "quantum theory"->{
    Cell[6129, 130, 1904, 31, 327, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis of differential equations", "hydrodynamics", 
        "mechanics", "electrodynamics", "quantum theory", 
        "statistical mechanics", "field theory", "particle physics", 
        "completely integrable equations"}]},
  "statistical mechanics"->{
    Cell[6129, 130, 1904, 31, 327, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis of differential equations", "hydrodynamics", 
        "mechanics", "electrodynamics", "quantum theory", 
        "statistical mechanics", "field theory", "particle physics", 
        "completely integrable equations"}]},
  "field theory"->{
    Cell[6129, 130, 1904, 31, 327, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis of differential equations", "hydrodynamics", 
        "mechanics", "electrodynamics", "quantum theory", 
        "statistical mechanics", "field theory", "particle physics", 
        "completely integrable equations"}]},
  "particle physics"->{
    Cell[6129, 130, 1904, 31, 327, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis of differential equations", "hydrodynamics", 
        "mechanics", "electrodynamics", "quantum theory", 
        "statistical mechanics", "field theory", "particle physics", 
        "completely integrable equations"}]},
  "completely integrable equations"->{
    Cell[6129, 130, 1904, 31, 327, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis of differential equations", "hydrodynamics", 
        "mechanics", "electrodynamics", "quantum theory", 
        "statistical mechanics", "field theory", "particle physics", 
        "completely integrable equations"}]},
  "linear operators"->{
    Cell[8036, 163, 552, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "linear operators", "superposition", "linear solution techniques"}]},
  "superposition"->{
    Cell[8036, 163, 552, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "linear operators", "superposition", "linear solution techniques"}]},
  "linear solution techniques"->{
    Cell[8036, 163, 552, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "linear operators", "superposition", "linear solution techniques"}]},
  "system of differential equations"->{
    Cell[8591, 175, 554, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "system of differential equations", "nonlinear", 
        "partial differential equation"}]},
  "nonlinear"->{
    Cell[8591, 175, 554, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "system of differential equations", "nonlinear", 
        "partial differential equation"}]},
  "partial differential equation"->{
    Cell[8591, 175, 554, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "system of differential equations", "nonlinear", 
        "partial differential equation"}]},
  "algebraic manipulation"->{
    Cell[13234, 307, 1271, 30, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "algebraic manipulation", "computer algebra", "Mathematica", "Maple", 
        "Macsyma", "Axiom"}]},
  "computer algebra"->{
    Cell[13234, 307, 1271, 30, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "algebraic manipulation", "computer algebra", "Mathematica", "Maple", 
        "Macsyma", "Axiom"}]},
  "Mathematica"->{
    Cell[13234, 307, 1271, 30, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "algebraic manipulation", "computer algebra", "Mathematica", "Maple", 
        "Macsyma", "Axiom"}]},
  "Maple"->{
    Cell[13234, 307, 1271, 30, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "algebraic manipulation", "computer algebra", "Mathematica", "Maple", 
        "Macsyma", "Axiom"}]},
  "Macsyma"->{
    Cell[13234, 307, 1271, 30, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "algebraic manipulation", "computer algebra", "Mathematica", "Maple", 
        "Macsyma", "Axiom"}]},
  "Axiom"->{
    Cell[13234, 307, 1271, 30, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "algebraic manipulation", "computer algebra", "Mathematica", "Maple", 
        "Macsyma", "Axiom"}]},
  "Lie's classical theory"->{
    Cell[16252, 388, 1657, 35, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie's classical theory", "direct reduction method", 
        "approximate symmetries", "asymptotic solutions", 
        "generalized symmetries", "contact symmetries", 
        "non classical method"}]},
  "direct reduction method"->{
    Cell[16252, 388, 1657, 35, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie's classical theory", "direct reduction method", 
        "approximate symmetries", "asymptotic solutions", 
        "generalized symmetries", "contact symmetries", 
        "non classical method"}]},
  "approximate symmetries"->{
    Cell[16252, 388, 1657, 35, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie's classical theory", "direct reduction method", 
        "approximate symmetries", "asymptotic solutions", 
        "generalized symmetries", "contact symmetries", 
        "non classical method"}],
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "asymptotic solutions"->{
    Cell[16252, 388, 1657, 35, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie's classical theory", "direct reduction method", 
        "approximate symmetries", "asymptotic solutions", 
        "generalized symmetries", "contact symmetries", 
        "non classical method"}]},
  "generalized symmetries"->{
    Cell[16252, 388, 1657, 35, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie's classical theory", "direct reduction method", 
        "approximate symmetries", "asymptotic solutions", 
        "generalized symmetries", "contact symmetries", 
        "non classical method"}],
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "contact symmetries"->{
    Cell[16252, 388, 1657, 35, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie's classical theory", "direct reduction method", 
        "approximate symmetries", "asymptotic solutions", 
        "generalized symmetries", "contact symmetries", 
        "non classical method"}]},
  "non classical method"->{
    Cell[16252, 388, 1657, 35, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie's classical theory", "direct reduction method", 
        "approximate symmetries", "asymptotic solutions", 
        "generalized symmetries", "contact symmetries", 
        "non classical method"}]},
  "local group"->{
    Cell[17912, 425, 585, 10, 117, "Text",
      Evaluatable->False,
      CellTags->{"local group", "point transformation", "diffeomorphism"}]},
  "point transformation"->{
    Cell[17912, 425, 585, 10, 117, "Text",
      Evaluatable->False,
      CellTags->{"local group", "point transformation", "diffeomorphism"}]},
  "diffeomorphism"->{
    Cell[17912, 425, 585, 10, 117, "Text",
      Evaluatable->False,
      CellTags->{"local group", "point transformation", "diffeomorphism"}]},
  "Lie groups"->{
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "Lie algebras"->{
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "ordinary differential equation"->{
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "Lie's integration theory"->{
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "point symmetry"->{
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "partial differential equations"->{
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "non-classical symmetries"->{
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "symmetry analysis"->{
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "overdetermined equations"->{
    Cell[18500, 437, 1515, 27, 243, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie groups", "Lie algebras", "ordinary differential equation", 
        "Lie's integration theory", "point symmetry", 
        "partial differential equations", "non-classical symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "symmetry analysis", "overdetermined equations"}]},
  "MathLie"->{
    Cell[20018, 466, 1094, 26, 180, "Text",
      CellTags->{
      "MathLie", "CD-Rom", "experiment", "experimental mathematics"}]},
  "CD-Rom"->{
    Cell[20018, 466, 1094, 26, 180, "Text",
      CellTags->{
      "MathLie", "CD-Rom", "experiment", "experimental mathematics"}]},
  "experiment"->{
    Cell[20018, 466, 1094, 26, 180, "Text",
      CellTags->{
      "MathLie", "CD-Rom", "experiment", "experimental mathematics"}]},
  "experimental mathematics"->{
    Cell[20018, 466, 1094, 26, 180, "Text",
      CellTags->{
      "MathLie", "CD-Rom", "experiment", "experimental mathematics"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"space-time translation", 23069, 547},
  {"symmetry principle", 23259, 552},
  {"laws of nature", 23445, 557},
  {"continuous symmetry", 23636, 562},
  {"laws of physics", 23950, 570},
  {"time translational invariance", 24278, 578},
  {"discrete symmetry", 24594, 586},
  {"time reversal invariance", 24917, 594},
  {"mirror reflection", 25233, 602},
  {"conserved quantity", 25550, 610},
  {"principles of symmetry", 25871, 618},
  {"Newton's laws", 26058, 623},
  {"Galilean invariance", 26251, 628},
  {"conservation laws", 26442, 633},
  {"symmetry analysis of differential equations", 26659, 638},
  {"hydrodynamics", 27013, 646},
  {"mechanics", 27363, 654},
  {"electrodynamics", 27719, 662},
  {"quantum theory", 28074, 670},
  {"statistical mechanics", 28436, 678},
  {"field theory", 28789, 686},
  {"particle physics", 29146, 694},
  {"completely integrable equations", 29518, 702},
  {"linear operators", 29875, 710},
  {"superposition", 30057, 715},
  {"linear solution techniques", 30252, 720},
  {"system of differential equations", 30453, 725},
  {"nonlinear", 30655, 731},
  {"partial differential equation", 30877, 737},
  {"algebraic manipulation", 31092, 743},
  {"computer algebra", 31312, 749},
  {"Mathematica", 31527, 755},
  {"Maple", 31736, 761},
  {"Macsyma", 31947, 767},
  {"Axiom", 32156, 773},
  {"Lie's classical theory", 32382, 779},
  {"direct reduction method", 32712, 787},
  {"approximate symmetries", 33041, 795},
  {"asymptotic solutions", 33773, 811},
  {"generalized symmetries", 34102, 819},
  {"contact symmetries", 34832, 835},
  {"non classical method", 35159, 843},
  {"local group", 35477, 851},
  {"point transformation", 35651, 855},
  {"diffeomorphism", 35819, 859},
  {"Lie groups", 35983, 863},
  {"Lie algebras", 36409, 872},
  {"ordinary differential equation", 36853, 881},
  {"Lie's integration theory", 37291, 890},
  {"point symmetry", 37719, 899},
  {"partial differential equations", 38163, 908},
  {"non-classical symmetries", 38601, 917},
  {"symmetry analysis", 39032, 926},
  {"overdetermined equations", 39470, 935},
  {"MathLie", 39891, 944},
  {"CD-Rom", 40039, 948},
  {"experiment", 40191, 952},
  {"experimental mathematics", 40357, 956}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 349, 6, 117, "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2091, 59, 412, 7, 163, "Title",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2506, 68, 1104, 16, 243, "Text",
  PageBreakBelow->False,
  CellTags->{
  "space-time translation", "symmetry principle", "laws of nature"}],
Cell[3613, 86, 1448, 24, 264, "Text",
  PageBreakBelow->True,
  CellTags->{
  "continuous symmetry", "laws of physics", "time translational invariance", 
    "discrete symmetry", "time reversal invariance", "mirror reflection", 
    "conserved quantity"}],
Cell[5064, 112, 1062, 16, 222, "Text",
  CellTags->{
  "principles of symmetry", "Newton's laws", "Galilean invariance", 
    "conservation laws"}],
Cell[6129, 130, 1904, 31, 327, "Text",
  Evaluatable->False,
  CellTags->{
  "symmetry analysis of differential equations", "hydrodynamics", "mechanics",
     "electrodynamics", "quantum theory", "statistical mechanics", 
    "field theory", "particle physics", "completely integrable equations"}],
Cell[8036, 163, 552, 10, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "linear operators", "superposition", "linear solution techniques"}],
Cell[8591, 175, 554, 12, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "system of differential equations", "nonlinear", 
    "partial differential equation"}],
Cell[9148, 189, 173, 2, 27, "NumberedEquation"],
Cell[9324, 193, 1050, 28, 159, "Text",
  Evaluatable->False],
Cell[10377, 223, 1011, 20, 202, "Quote",
  Evaluatable->False],
Cell[11391, 245, 325, 11, 31, "Quote",
  Evaluatable->False],
Cell[11719, 258, 101, 2, 33, "Text",
  Evaluatable->False],
Cell[11823, 262, 1123, 32, 160, "Quote",
  Evaluatable->False],
Cell[12949, 296, 282, 9, 31, "Quote",
  Evaluatable->False],
Cell[13234, 307, 1271, 30, 222, "Text",
  Evaluatable->False,
  CellTags->{
  "algebraic manipulation", "computer algebra", "Mathematica", "Maple", 
    "Macsyma", "Axiom"}],
Cell[14508, 339, 1476, 38, 222, "Text",
  Evaluatable->False],
Cell[15987, 379, 262, 7, 75, "Text"],
Cell[16252, 388, 1657, 35, 222, "Text",
  Evaluatable->False,
  CellTags->{
  "Lie's classical theory", "direct reduction method", 
    "approximate symmetries", "asymptotic solutions", 
    "generalized symmetries", "contact symmetries", "non classical method"}],
Cell[17912, 425, 585, 10, 117, "Text",
  Evaluatable->False,
  CellTags->{"local group", "point transformation", "diffeomorphism"}],
Cell[18500, 437, 1515, 27, 243, "Text",
  Evaluatable->False,
  CellTags->{
  "Lie groups", "Lie algebras", "ordinary differential equation", 
    "Lie's integration theory", "point symmetry", 
    "partial differential equations", "non-classical symmetries", 
    "approximate symmetries", "generalized symmetries", "symmetry analysis", 
    "overdetermined equations"}],
Cell[20018, 466, 1094, 26, 180, "Text",
  CellTags->{"MathLie", "CD-Rom", "experiment", "experimental mathematics"}],
Cell[21115, 494, 145, 3, 44, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

