(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1380511,      41349]*)
(*NotebookOutlinePosition[   1432817,      42575]*)
(*  CellTagsIndexPosition[   1425991,      42412]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["4", "ChapterLine",
  CellTags->"1.1"],

Cell["\<\
Symmetries of Ordinary
Differential Equations\
\>", "Title",
  CellTags->"1.1"],

Cell[CellGroupData[{

Cell["4.1 Introduction", "Section",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Introduction"],

Cell["\<\
Let us start with the following question. Suppose you have to solve \
an ordinary differential equation of second order like\
\>", "Text",
  CellTags->"ordinary differential equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(equation1 = 
      \[PartialD]\_{x, 2}u[x] - \((x - u[x])\)\ \[PartialD]\_x u[x] == 0; 
    equation1 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(-\((\(-u\) + x)\)\)\ u\_x + u\_\(x, x\) == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "How can we proceed to find the solution of this simple-looking equation? \
The first idea is to use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to solve the equation. If we apply ",
  StyleBox["DSolve[]", "MmaText"],
  " to the equation, we get the answer"
}], "Text",
  CellTags->{"DSolve[]", "solve equations"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution = DSolve[equation1, u, x]\)], "Input"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(-\((x - u[x])\)\), " ", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", "u", ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell["\<\
After this dissatisfying result, you may check your knowledge as to \
whether the differential equation belongs to a class you know. Or you may try \
to find a transformation which will put the differential equation into a \
standard form. If you are not successful, you perhaps look up a table of \
standard equations or you try to make some ansatz to find a solution. If none \
of your tasks solved the problem, you have to leave it unsolved. But you may \
have an uneasy feeling that there is a method you may have overlooked or of \
which you are unaware.\
\>", "Text",
  CellTags->{
  "transformation", "standard form", "standard equation", "ansatz"}],

Cell[TextData[{
  "In this section, we will show you a procedure which perhaps solves your \
problem and which is simple in its application when ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is used as a tool. The method we will present is a rather ancient method \
invented at the end of the last century by the Norwegian mathematician ",
  ButtonBox["Sophus Lie",
    ButtonData:>{"MSLie.nb", None},
    ButtonStyle->"Hyperlink"],
  ". He produced a tremendous work on symmetries which is applied not only to \
solve differential equations but also to fields like quantum mechanics, \
function theory, perturbation theory, etc. In this chapter, we restrict our \
considerations to ordinary differential equations. In C",
  ButtonBox["hapter 5",
    ButtonData:>{"symmet5.nb", None},
    ButtonStyle->"Hyperlink"],
  ", we will discuss partial differential equations, too."
}], "Text",
  CellTags->{
  "Sophus Lie", "quantum mechanics", "function theory", 
    "perturbation theory", "ordinary differential equation"}],

Cell[TextData[{
  "The story of symmetry analysis started in the middle of the 19th century \
when Lie and Klein met in Berlin. Both mathematicians contributed a lot to \
the theory of symmetries. Lie invented his famous work to examine symmetries \
in connection with algebraic and differential equations. In his \
G\[ODoubleDot]ttinger program, Klein developed the discrete and algebraic \
parts of the application of symmetries on functions. Lie merged into the \
large field of differential equations which was very useful for classifying \
the differential equations in a new way. The theory developed by Lie is very \
laborious if done by hand. This was one of the reasons why the application of \
this theory disappeared for solving practical problems. Very few people used \
Lie\[CloseCurlyQuote]s procedure to examine their differential equations. One \
of these was ",
  ButtonBox["Birkhoff [1950]",
    ButtonData:>{"Literat.nb", "Birk-50"},
    ButtonStyle->"Hyperlink"],
  " who in the 1950s applied the theory to hydrodynamic problems. In recent \
years, more and more attention was paid to the theory of Lie as one of the \
rare methods to deliver solutions, especially for non-linear differential \
equations. Today, Lie\[CloseCurlyQuote]s procedure is accessible for a broad \
application if the computational power of computer algebra is used. The very \
extended algebraic calculations today are carried out by computers. In the \
past 20 years, there has been a tremendous increase of computer power and of \
the development of symbolic languages, allowing the problem to be tackled in \
an even simpler way. A summary of the development of symbolic programs was \
recently given by Hereman [",
  ButtonBox["1994",
    ButtonData:>{"Literat.nb", "Here-94"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["1996",
    ButtonData:>{"Literat.nb", "Hereman-1996"},
    ButtonStyle->"Hyperlink"],
  "]. One of these symbolic languages usable for the implementation of Lie\
\[CloseCurlyQuote]s procedure is ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with its powerful matching procedures is well fitted as a tool to carry \
out calculations used in Lie\[CloseCurlyQuote]s theory."
}], "Text",
  CellTags->{
  "Lie", "Klein", "differential equation", "Birkhoff", 
    "hydrodynamic problem", "nonlinear differential equation", 
    "computer algebra", "algebraic calculations", "symbolic programs", 
    "Heraman", "symbolic languages"}],

Cell[TextData[{
  "Lie\[CloseCurlyQuote]s main idea was that the symmetry properties of a \
differential equation can be used to solve the equation. How this works and \
how Lie\[CloseCurlyQuote]s theory is used within ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " will be discussed in the following sections."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2 Symmetry Transformations of Functions", "Section",
  CellTags->"Symmetry Transformations of Functions"],

Cell[TextData[
"Before we apply Lie\[CloseCurlyQuote]s method to ordinary differential \
equations, we will briefly discuss symmetries in connection with functions. \
This section serves to introduce the main concepts of the theory occurring \
throughout the book."], "Text",
  Evaluatable->False,
  CellTags->{"ordinary differential equation", "symmetries and functions"}],

Cell[CellGroupData[{

Cell["4.2.1 Symmetries", "Subsection",
  CellTags->"Symmetries"],

Cell[TextData[{
  "One of the most remarkable discoveries of Lie in the theory of groups was \
the invariance of a function under some transformations. When dealing with \
differential equations, one very often tries to simplify the equation by an \
appropriate change of variables. This transformation generally involves both \
the independent and the dependent variables. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we can represent such transformations by the following list of rules:"
}], "Text",
  CellTags->{"change of variables", "transformation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rule1 = {x \[Rule] Function[{x, u}, X[x, u]], \n\t\t
        u \[Rule] Function[{x, u}, U[x, u]]}\)], "Input"],

Cell[BoxData[
    \({x \[Rule] Function[{x, u}, X[x, u]], 
      u \[Rule] Function[{x, u}, U[x, u]]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This kind of transformation involving the original independent and \
dependent variables (",
  StyleBox["x",
    FontSlant->"Italic"],
  ",",
  StyleBox["u",
    FontSlant->"Italic"],
  ") is usually called a point transformation, meaning that a point ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  " of the manifold \[GothicCapitalM] is transformed into another point ",
  Cell[BoxData[
      \(TraditionalForm\`\((X, U)\)\)]],
  ". A point transformation takes only into account a change of the \
coordinates. The point transformations actually considered by Lie were \
transformations depending on at least one parameter \[Epsilon]. As we will \
see, the parameter \[Epsilon] is the parameter of the corresponding group. \
Thus, we call \[Epsilon] the group parameter. A one-parameter transformation \
is thus given by"
}], "Text",
  CellTags->{
  "point transformation", "manifold", "group parameter", 
    "one-parameter transformation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rule2 = {x \[Rule] Function[{x, u, \[Epsilon]}, X[x, u, \[Epsilon]]], \n
        \t\tu \[Rule] Function[{x, u, \[Epsilon]}, U[x, u, \[Epsilon]]]}\)], 
  "Input"],

Cell[BoxData[
    \({x \[Rule] Function[{x, u, \[Epsilon]}, X[x, u, \[Epsilon]]], 
      u \[Rule] Function[{x, u, \[Epsilon]}, U[x, u, \[Epsilon]]]}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Such transformations have the following properties: They are invertible if \
the corresponding Jacobi determinant exists, repeated application yields a \
transformation of the same type, and the identity of the transformation for \
\[Epsilon] = 0 exists. As we know from C",
  ButtonBox["hapter 2",
    ButtonData:>{"Group.nb", "Groups"},
    ButtonStyle->"Hyperlink"],
  ", these three properties are the basis of a Lie group. They can be \
summarized in the definition of symmetry transformations."
}], "Text",
  CellTags->{
  "Jacobi determinant", "identity of a transformation", 
    "symmetry transformation"}],

Cell["Definition:  Symmetry transformation", "Definition",
  CellTags->"Definition: Symmetry Transformation"],

Cell[TextData["A set \[GothicCapitalG] of transformations given by "], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] X(x, u, \[Epsilon])\)]],
  ","
}], "DisplayFormula",
  TextAlignment->Center],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`u \[Rule] U(x, u, \[Epsilon])\)]]], "DisplayFormula",
  TextAlignment->Center],

Cell[TextData[{
  "is a one-parameter group if it contains the identical transformation ",
  StyleBox["I",
    FontSlant->"Italic"],
  " = ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0\)]],
  " and includes the inverse ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\[Epsilon]\%\(-1\)\)]],
  " and the composition ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(T\_\[Epsilon]\ \[CircleTimes]\),
              "TraditionalForm"], " ", 
            FormBox[\(T\_\[Beta]\),
              "TraditionalForm"]}], " ", "\[Element]", " ", 
          "\[GothicCapitalG]"}], TraditionalForm]]],
  ". By a suitable choice of the group parameter \[Epsilon], the main group \
property",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              FormBox[\(T\_\[Epsilon]\),
                "TraditionalForm"], " ", "\[CircleTimes]", " ", 
              FormBox[\(T\_\[Beta]\),
                "TraditionalForm"]}], " ", "\[Element]", " ", 
            "\[GothicCapitalG]"}]}], TraditionalForm]]],
  " can be written"
}], "Text",
  CellTags->{"identical transformation", "inverse", "main group property"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(T\_\[Epsilon]\),
              "TraditionalForm"], " ", "\[CircleTimes]", " ", 
            FormBox[\(T\_\[Beta]\),
              "TraditionalForm"]}], " ", "=", " ", 
          FormBox[\(T\_\(\[Epsilon] + \[Beta]\)\),
            "TraditionalForm"]}], ","}], TraditionalForm]], "NumberedEquation",\

  CellTags->"eq-1"],

Cell["that is,", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(X(X(x, u, \[Epsilon]), U(x, u, \[Epsilon]), \[Beta])\ \  = \ \ 
      X(x, u, \[Epsilon] + \[Beta]), \)\)], "NumberedEquation",
  CellTags->"eq-2"],

Cell[BoxData[
    \(TraditionalForm
    \`U(X(x, u, \[Epsilon]), U(x, u, \[Epsilon]), \[Beta])\ \  = \ \ 
      \(U(x, u, \[Epsilon] + \[Beta]) . \)\)], "NumberedEquation",
  CellTags->"eq-3"],

Cell[TextData[
"In particular applications, the two conditions hold only for sufficiently \
small values of \[Epsilon] and \[Beta]. There, we arrive at what is called a \
local one-parameter group \[GothicCapitalG] or an infinitesimal group.\
\[ThickSpace]\[EmptyCircle]"], "Text",
  CellTags->{"local one-parameter group", "infinitesimal group"}],

Cell[TextData[{
  "These simple properties ensure that the transformations given in ",
  StyleBox["rule2",
    FontSlant->"Italic"],
  " form a one-parameter group of point transformations. A simple example to \
show how point transformations work can be given by considering the shift of \
a function. Mathematically, a shift is defined by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(T\_\[Epsilon]\),
              "TraditionalForm"], \(f(x)\)}], " ", "=", 
          \(f(x + \[Epsilon])\)}], TraditionalForm]]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\[Epsilon]\)]],
  " represents the translation operator. A definition of such an operator in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reads"
}], "Text",
  CellTags->{"one-parameter group", "point transformation"}],

Cell[BoxData[
    \(T[f_, \[Epsilon]_] := f /. x \[Rule] x + \[Epsilon]\)], "Input"],

Cell[TextData[{
  "This definition assumes that ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and that ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is replaced by ",
  Cell[BoxData[
      \(TraditionalForm\`x + \[Epsilon]\)]],
  " in the argument of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". To demonstrate the properties stated above, we start with the \
verification of the identity transformation for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ":"
}], "Text",
  CellTags->"identity transformation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T[f[x], 0]\)], "Input"],

Cell[BoxData[
    \(f[x]\)], "Output"]
}, Open  ]],

Cell["\<\
which demonstrates the existence of the identity transformation. \
The inverse transformation can be checked by creating a translation and the \
corresponding reverse by\
\>", "Text",
  CellTags->{"inverse transformation", "translation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(T[T[f[x], \[Epsilon]], \(-\[Epsilon]\)]\)], "Input"],

Cell[BoxData[
    \(f[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "meaning that the inverse transformation is represented by a negative \
shift. The operation of translation and its inverse yield the original \
representation of the function. The closure of the transformation means that \
the function created by the transformation is again of the same type. This \
behavior can be demonstrated by the following specific example choosing ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(f(x) = x\^2\),
            "TraditionalForm"], "-", \(x\^3\)}], TraditionalForm]]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T[x\^2 - x\^3, \(-\[Epsilon]\)]\)], "Input"],

Cell[BoxData[
    \(\((x - \[Epsilon])\)\^2 - \((x - \[Epsilon])\)\^3\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "To demonstrate the action of the transformation, we will graphically \
represent the results for the identity and for a shift with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = \(-2. \)\)]]
}], "Text",
  CellTags->"transformation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[{T[x\^2 - x\^3, 0], T[x\^2 - x\^3, \(-2\)]}], \n
      \t{x, \(-2\), 4}, \n\t
      PlotStyle 
        \[Rule] {RGBColor[1.000, 0.000, 0.000], \n\t\t\t
          RGBColor[0.000, 0.000, 1.000]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.15873 0.235434 0.575277 [
[.02381 .22293 -6 -9 ]
[.02381 .22293 6 0 ]
[.18254 .22293 -6 -9 ]
[.18254 .22293 6 0 ]
[.5 .22293 -3 -9 ]
[.5 .22293 3 0 ]
[.65873 .22293 -3 -9 ]
[.65873 .22293 3 0 ]
[.81746 .22293 -3 -9 ]
[.81746 .22293 3 0 ]
[.97619 .22293 -3 -9 ]
[.97619 .22293 3 0 ]
[.32877 .00532 -24 -4.5 ]
[.32877 .00532 0 4.5 ]
[.32877 .12038 -24 -4.5 ]
[.32877 .12038 0 4.5 ]
[.32877 .35049 -18 -4.5 ]
[.32877 .35049 0 4.5 ]
[.32877 .46554 -18 -4.5 ]
[.32877 .46554 0 4.5 ]
[.32877 .5806 -18 -4.5 ]
[.32877 .5806 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .23543 m
.02381 .24168 L
s
[(-2)] .02381 .22293 0 1 Mshowa
.18254 .23543 m
.18254 .24168 L
s
[(-1)] .18254 .22293 0 1 Mshowa
.5 .23543 m
.5 .24168 L
s
[(1)] .5 .22293 0 1 Mshowa
.65873 .23543 m
.65873 .24168 L
s
[(2)] .65873 .22293 0 1 Mshowa
.81746 .23543 m
.81746 .24168 L
s
[(3)] .81746 .22293 0 1 Mshowa
.97619 .23543 m
.97619 .24168 L
s
[(4)] .97619 .22293 0 1 Mshowa
.125 Mabswid
.05556 .23543 m
.05556 .23918 L
s
.0873 .23543 m
.0873 .23918 L
s
.11905 .23543 m
.11905 .23918 L
s
.15079 .23543 m
.15079 .23918 L
s
.21429 .23543 m
.21429 .23918 L
s
.24603 .23543 m
.24603 .23918 L
s
.27778 .23543 m
.27778 .23918 L
s
.30952 .23543 m
.30952 .23918 L
s
.37302 .23543 m
.37302 .23918 L
s
.40476 .23543 m
.40476 .23918 L
s
.43651 .23543 m
.43651 .23918 L
s
.46825 .23543 m
.46825 .23918 L
s
.53175 .23543 m
.53175 .23918 L
s
.56349 .23543 m
.56349 .23918 L
s
.59524 .23543 m
.59524 .23918 L
s
.62698 .23543 m
.62698 .23918 L
s
.69048 .23543 m
.69048 .23918 L
s
.72222 .23543 m
.72222 .23918 L
s
.75397 .23543 m
.75397 .23918 L
s
.78571 .23543 m
.78571 .23918 L
s
.84921 .23543 m
.84921 .23918 L
s
.88095 .23543 m
.88095 .23918 L
s
.9127 .23543 m
.9127 .23918 L
s
.94444 .23543 m
.94444 .23918 L
s
.25 Mabswid
0 .23543 m
1 .23543 L
s
.34127 .00532 m
.34752 .00532 L
s
[(-0.4)] .32877 .00532 1 0 Mshowa
.34127 .12038 m
.34752 .12038 L
s
[(-0.2)] .32877 .12038 1 0 Mshowa
.34127 .35049 m
.34752 .35049 L
s
[(0.2)] .32877 .35049 1 0 Mshowa
.34127 .46554 m
.34752 .46554 L
s
[(0.4)] .32877 .46554 1 0 Mshowa
.34127 .5806 m
.34752 .5806 L
s
[(0.6)] .32877 .5806 1 0 Mshowa
.125 Mabswid
.34127 .03409 m
.34502 .03409 L
s
.34127 .06285 m
.34502 .06285 L
s
.34127 .09161 m
.34502 .09161 L
s
.34127 .14914 m
.34502 .14914 L
s
.34127 .17791 m
.34502 .17791 L
s
.34127 .20667 m
.34502 .20667 L
s
.34127 .2642 m
.34502 .2642 L
s
.34127 .29296 m
.34502 .29296 L
s
.34127 .32173 m
.34502 .32173 L
s
.34127 .37925 m
.34502 .37925 L
s
.34127 .40802 m
.34502 .40802 L
s
.34127 .43678 m
.34502 .43678 L
s
.34127 .49431 m
.34502 .49431 L
s
.34127 .52307 m
.34502 .52307 L
s
.34127 .55184 m
.34502 .55184 L
s
.34127 .60936 m
.34502 .60936 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.24057 .61803 m
.24402 .58366 L
.2538 .5064 L
.26416 .43713 L
.27367 .38422 L
.28414 .33679 L
.29359 .30293 L
.30258 .27795 L
.30742 .26717 L
.31271 .2574 L
.31758 .25017 L
.32199 .24496 L
.32723 .24034 L
.3301 .23848 L
.33281 .23715 L
.33404 .23668 L
.33533 .23627 L
.33644 .23598 L
.33764 .23574 L
.33893 .23556 L
.34013 .23546 L
.34086 .23544 L
.34156 .23544 L
.34286 .23549 L
.344 .2356 L
.34523 .23578 L
.34639 .23601 L
.34745 .23627 L
.34992 .23705 L
.35252 .23812 L
.35742 .24078 L
.36277 .24456 L
.38119 .26267 L
.40244 .28795 L
.42175 .30834 L
.42644 .31219 L
.43139 .31559 L
.43398 .31706 L
.43683 .31841 L
.43942 .31938 L
.44184 .32005 L
.44301 .32029 L
.44429 .32048 L
.4455 .3206 L
.44662 .32065 L
.44772 .32065 L
.44873 .3206 L
.44989 .32048 L
.45098 .32031 L
.45218 .32005 L
Mistroke
.45344 .3197 L
.4557 .31888 L
.45813 .31768 L
.4608 .316 L
.46606 .31146 L
.47103 .3056 L
.48035 .29011 L
.48556 .27868 L
.49038 .2662 L
.50128 .23073 L
.51093 .19018 L
.51998 .14365 L
.54059 .00343 L
Mfstroke
.54059 .00343 m
.54096 0 L
s
0 0 1 r
.55798 .61803 m
.56097 .58801 L
.5707 .51052 L
.58106 .44055 L
.59145 .38259 L
.60087 .33974 L
.60981 .30692 L
.61926 .27986 L
.62404 .26893 L
.62928 .25891 L
.6341 .25143 L
.6385 .24597 L
.6437 .24108 L
.64656 .23907 L
.64927 .2376 L
.65048 .23707 L
.65177 .23659 L
.65289 .23624 L
.65409 .23594 L
.65537 .2357 L
.65657 .23554 L
.65727 .23548 L
.65801 .23545 L
.65932 .23544 L
.66056 .23551 L
.66125 .23558 L
.6619 .23566 L
.66307 .23585 L
.66432 .23612 L
.66649 .23674 L
.66887 .23763 L
.67414 .24033 L
.67906 .24367 L
.69743 .26129 L
.71601 .28331 L
.73626 .30564 L
.74158 .31035 L
.74724 .31457 L
.75 .31627 L
.75259 .31764 L
.7549 .31866 L
.75743 .31955 L
.75861 .31989 L
.75988 .32018 L
.76058 .32031 L
.76122 .32041 L
.76247 .32056 L
.76361 .32064 L
.76484 .32066 L
.76601 .32061 L
Mistroke
.76709 .32051 L
.76834 .32032 L
.7695 .32008 L
.77078 .31974 L
.77216 .31927 L
.77496 .31802 L
.77753 .3165 L
.78229 .31267 L
.78736 .30707 L
.79215 .30024 L
.79649 .29267 L
.80716 .26809 L
.81721 .23634 L
.82696 .19678 L
.83726 .14465 L
.85573 .02182 L
Mfstroke
.85573 .02182 m
.85814 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{300, 143},
  ImageMargins->{{10, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005g0000/Q000`40O003h00OogooN7oo003oOomh
Ool007Eoo`@000Eoo`8000Moo`<00>eoo`00M7oo00<007ooOol00Woo00<007ooOol00Woo0P0027oo
00<007ooOol0k7oo001dOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool00`00Oomo
o`0eOol00g`0Oomoo`1GOol00`0OOomoo`1DOol006aoo`H0009oo`03001oogoo009oo`03001oogoo
00Qoo`H000Aoo`<003Eoo`03O01oogoo05Moo`0301moogoo05Aoo`00M7oo00<007ooOol00Woo00<0
07ooOol02Goo00@007ooOol000Eoo`03001oogoo03Eoo`03O01oogoo05Moo`0301moogoo05Aoo`00
M7oo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Eoo`03001oogoo03Eoo`03O01oogoo
05Ioo`0301moogoo05Eoo`00M7oo00<007ooOol00Woo00<007ooOol02Woo00<007oo00001Goo00<0
07ooOol0=Goo00=l07ooOol0EWoo00<07gooOol0EGoo001eOol4000>Ool20005Ool00`00Oomoo`0d
Ool00g`0Oomoo`1GOol00`0OOomoo`1EOol008ioo`03001oogoo03Aoo`03O01oogoo05Moo`0301mo
ogoo05Eoo`00SWoo00<007ooOol0=7oo00=l07ooOol0Egoo00<07gooOol0EGoo002>Ool00`00Oomo
o`0dOol00g`0Oomoo`1GOol00`0OOomoo`1EOol008ioo`8003Eoo`03O01oogoo05Moo`0301moogoo
05Eoo`00SWoo00<007ooOol0=7oo00=l07ooOol0EWoo00<07gooOol0EWoo002>Ool00`00Oomoo`0d
Ool00g`0Oomoo`1FOol00`0OOomoo`1FOol008ioo`03001oogoo03Aoo`03O01oogoo05Ioo`0301mo
ogoo05Ioo`00SWoo00<007ooOol0<goo00=l07ooOol0Egoo00<07gooOol0EWoo002>Ool00`00Oomo
o`0cOol00g`0Oomoo`1GOol00`0OOomoo`1FOol008ioo`03001oogoo03=oo`03O01oogoo05Moo`03
01moogoo05Ioo`00SWoo00<007ooOol0<goo00=l07ooOol0Egoo00<07gooOol0EWoo002>Ool00`00
Oomoo`0cOol00g`0Oomoo`1FOol00`0OOomoo`1GOol008ioo`8003Aoo`03O01oogoo05Ioo`0301mo
ogoo05Moo`00SWoo00<007ooOol0<goo00=l07ooOol0EWoo00<07gooOol0Egoo002>Ool00`00Oomo
o`0cOol00g`0Oomoo`1FOol00`0OOomoo`1GOol008ioo`03001oogoo039oo`03O01oogoo05Moo`03
01moogoo05Moo`00SWoo00<007ooOol0<Woo00=l07ooOol0Egoo00<07gooOol0Egoo002>Ool00`00
Oomoo`0bOol00g`0Oomoo`1GOol00`0OOomoo`1GOol008ioo`03001oogoo039oo`03O01oogoo05Io
o`0301moogoo05Qoo`00SWoo00<007ooOol0<Woo00=l07ooOol0EWoo00<07gooOol0F7oo002>Ool2
000cOol00g`0Oomoo`1FOol00`0OOomoo`1HOol008ioo`03001oogoo039oo`03O01oogoo05Ioo`03
01moogoo05Qoo`00SWoo00<007ooOol0<Woo00=l07ooOol0EWoo00<07gooOol0F7oo002>Ool00`00
Oomoo`0aOol00g`0Oomoo`1GOol00`0OOomoo`1HOol008ioo`03001oogoo035oo`03O01oogoo05Mo
o`0301moogoo05Qoo`00MGoo10001Goo0P0017oo1@001Goo00<007ooOol0<Goo00=l07ooOol0EWoo
00<07gooOol0FGoo001dOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo0000
1Goo00<007ooOol0<Goo00=l07ooOol0EWoo00<07gooOol0FGoo001dOol00`00Oomoo`02Ool00`00
Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`0aOol00g`0Oomoo`1FOol00`0OOomoo`1IOol006ao
o`H0009oo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo00Eoo`<0035oo`03O01oogoo05Io
o`0301moogoo05Uoo`00M7oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol017oo00<007oo
Ool0<Goo00=l07ooOol0EWoo00<07gooOol0FGoo001dOol00`00Oomoo`02Ool00`00Oomoo`0<Ool0
0`00Oomoo`03Ool00`00Oomoo`0aOol00g`0Oomoo`1FOol00`0OOomoo`1IOol007Aoo`03001oogoo
009oo`03001oogoo00Qoo`05001oogooOol00005Ool00`00Oomoo`0`Ool00g`0Oomoo`1GOol00`0O
Oomoo`1IOol007Eoo`@000aoo`<000Ioo`03001oogoo031oo`03O01oogoo05Ioo`0301moogoo05Yo
o`00SWoo00<007ooOol0<7oo00=l07ooOol0EWoo00<07gooOol0FWoo002>Ool00`00Oomoo`0`Ool0
0g`0Oomoo`1FOol00`0OOomoo`1JOol008ioo`03001oogoo031oo`03O01oogoo05Ioo`0301moogoo
05Yoo`00SWoo0P00<Goo00=l07ooOol0EWoo00<07gooOol0FWoo002>Ool00`00Oomoo`0_Ool00g`0
Oomoo`1GOol00`0OOomoo`1JOol008ioo`03001oogoo02moo`03O01oogoo05Ioo`0301moogoo05]o
o`00SWoo00<007ooOol0;goo00=l07ooOol0EWoo00<07gooOol0Fgoo002>Ool00`00Oomoo`0_Ool0
0g`0Oomoo`1FOol00`0OOomoo`1KOol008ioo`03001oogoo02ioo`03O01oogoo05Moo`0301moogoo
05]oo`00SWoo00<007ooOol0;Woo00=l07ooOol0EWoo00<07gooOol0G7oo002>Ool00`00Oomoo`0^
Ool00g`0Oomoo`1FOol00`0OOomoo`1LOol008ioo`8002moo`03O01oogoo05Ioo`0301moogoo05ao
o`00SWoo00<007ooOol0;Goo00=l07ooOol0Egoo00<07gooOol0G7oo000fOol5000YOol5000UOol0
0`00Oomoo`0XOol500000g`0Oomoo`0SOol5000YOol30003Ool00`0OOomoo`0VOol3000cOol003Io
o`05001oogooOol0000[Ool00`00Oomoo`0UOol00`00Oomoo`0ZOol01000Oomoog`09Goo00D007oo
Oomoo`0002Qoo`07001oogooOol007oo01l0:Woo00<007ooOol0<Woo000gOol00`00Oomoo`0/Ool0
0`00Oomoo`0UOol00`00Oomoo`0ZOol01000Oomoog`09Woo00<007ooOol0;Goo00<007oo01l0:Woo
00<007ooOol0<Woo000^Ool60004Ool00`00Oomoo`0POol60005Ool00`00Oomoo`0UOol00`00Oomo
o`0ZOol00`00Ooml000XOol00`00Oomoo`0/Ool00`00Ool07`0VOol6000cOol003Uoo`03001oogoo
02Yoo`03001oogoo02Eoo`03001oogoo02Yoo`03001oog`002Uoo`03001oogoo02Uoo`80009oo`03
01moogoo02Eoo`04001oogoo000dOol003Yoo`03001oogoo02Uoo`03001oogoo02Eoo`03001oogoo
02Yoo`03001oog`002Yoo`03001oogoo02Yoo`0300007goo02Moo`04001oogoo000dOol003Ioo`05
001oogooOol0000YOol3000WOol2000YOol300000gooO01oo`0UOol01@00Oomoogoo0000:7oo00H0
07ooOomoo`0001lYOol00`00Ool0000dOol003Moo`<002aoo`03001oogoo02Eoo`03001oogoo02Yo
o`03001l07oo02Moo`<002Yoo`<00003Ool07goo02Uoo`8003Aoo`00SWoo00<007ooOol0:goo00=l
07ooOol0Egoo00<07gooOol0GWoo002>Ool00`00Oomoo`0[Ool00g`0Oomoo`1FOol00`0OOomoo`1O
Ool008ioo`03001oogoo02]oo`03O01oogoo05Ioo`0301moogoo05moo`00SWoo00<007ooOol0:Woo
00=l07ooOol0Egoo00<07gooOol0Ggoo002>Ool00`00Oomoo`0ZOol00g`0Oomoo`1GOol00`0OOomo
o`1OOol008ioo`03001oogoo02Yoo`03O01oogoo05Ioo`0301moogoo061oo`00;WooGP001W`0:@00
00=l000000009`001P0O:@0000<07`000000<@00;goo000eOol00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`02Ool2O002Ool01000Oomoog`01Goo00<0
07ooOol01Woo00<007ooOol01Woo00<007ooOol01Woo00<007ooOol01Goo00=l0000Ool01goo00<0
07ooOol01Woo00<007ooOol01Woo00<007ooOol01Woo00<007ooOol00Woo0P0O00Aoo`00Oomoo`<0
7`=oo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`0301moogoo
00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo
03=oo`00=Goo00<007ooOol0:Woo00<007ooOol097oo00=l07ooOol00Woo00@007ooOomoo`9l02Io
o`03O00007oo02Ioo`0501moogooOol00005Ool00`0OOomoo`0SOol00`0O001oo`0[Ool00`00Oomo
o`0cOol008Uoo`03O01oogoo009oo`03001oogoo00=oo`03O01oogoo02=oo`03O01oogoo02Eoo`03
01moogoo00Uoo`0301moogoo029oo`0301moogoo065oo`00R7oo00=l07ooOol00goo00<007ooOol0
17oo00=l07ooOol08Goo00=l07ooOol09Goo00<07gooOol02goo00<07gooOol08Goo00<07gooOol0
HGoo0027Ool00g`0Oomoo`04Ool00`00Oomoo`05Ool00g`0Oomoo`0POol00g`0Oomoo`0UOol00`0O
Oomoo`0<Ool00`0OOomoo`0OOol00`0OOomoo`1ROol008Ioo`03O01oogoo00Eoo`03001oogoo00Io
o`9l021oo`03O01oogoo02Aoo`0301moogoo00ioo`0301moogoo01ioo`0301moogoo069oo`00QWoo
00=l07ooOol01Goo00<007ooOol027oo00=l07ooOol07Goo00=l07ooOol08goo00<07gooOol047oo
00<07gooOol07Goo00<07gooOol0HWoo0025Ool00g`0Oomoo`06Ool2000:Ool00g`0Oomoo`0KOol0
0g`0Oomoo`0SOol00`0OOomoo`0BOol00`0OOomoo`0KOol00`0OOomoo`1SOol008Eoo`03O01oogoo
00Ioo`03001oogoo00Yoo`03O01oogoo01Yoo`03O01oogoo02=oo`0301moogoo01=oo`0301moogoo
01Yoo`0301moogoo06=oo`00Q7oo00=l07ooOol01goo00<007ooOol02goo00=l07ooOol06Goo00=l
07ooOol08Woo00<07gooOol05Goo00<07gooOol06Goo00<07gooOol0Hgoo0024Ool00g`0Oomoo`07
Ool00`00Oomoo`0<Ool00g`0Oomoo`0GOol00g`0Oomoo`0SOol00`0OOomoo`0FOol00`0OOomoo`0G
Ool00`0OOomoo`1TOol008=oo`03O01oogoo00Qoo`03001oogoo00aoo`03O01oogoo01Moo`03O01o
ogoo029oo`0301moogoo01Qoo`0301moogoo01Ioo`0301moogoo06Aoo`00Pgoo00=l07ooOol027oo
00<007ooOol03Goo00=l07ooOol05Goo00=l07ooOol08goo00<07gooOol06Goo00<07gooOol057oo
00<07gooOol0IGoo0022Ool00g`0Oomoo`09Ool00`00Oomoo`0>Ool00g`0Oomoo`0DOol00g`0Oomo
o`0ROol00`0OOomoo`0KOol00`0OOomoo`0COol00`0OOomoo`1UOol0089oo`03O01oogoo00Uoo`03
001oogoo00moo`03O01oogoo019oo`03O01oogoo02=oo`0301moogoo01]oo`0301moogoo019oo`03
01moogoo06Ioo`00PWoo00=l07ooOol02Goo0P004Goo00=l07ooOol04Goo00=l07ooOol08goo00<0
7gooOol077oo00<07gooOol04Goo00<07gooOol0IWoo0022Ool00g`0Oomoo`09Ool00`00Oomoo`0A
Ool00g`0Oomoo`0?Ool00g`0Oomoo`0TOol00`0OOomoo`0MOol00`0OOomoo`0?Ool00`0OOomoo`1W
Ool0085oo`03O01oogoo00Yoo`03001oogoo019oo`03O01oogoo00ioo`03O01oogoo02=oo`0301mo
ogoo01moo`0301moogoo00ioo`0301moogoo06Moo`00PGoo00=l07ooOol02Woo00<007ooOol04goo
00=l07ooOol037oo00=l07ooOol097oo00<07gooOol07goo00<07gooOol03Goo00<07gooOol0J7oo
0021Ool00g`0Oomoo`0:Ool00`00Oomoo`0DOol00g`0Oomoo`0;Ool00g`0Oomoo`0TOol00`0OOomo
o`0POol00`0OOomoo`0<Ool00`0OOomoo`1XOol0081oo`03O01oogoo00]oo`03001oogoo01Eoo`03
O01oogoo00Qoo`9l02Moo`0301moogoo025oo`807`]oo`0301moogoo06Uoo`00P7oo00=l07ooOol0
2goo00<007ooOol05Goo00=l07ooOol01goo00=l07ooOol09Woo00<07gooOol097oo00<07gooOol0
1goo00<07gooOol0JWoo0020Ool00g`0Oomoo`0;Ool00`00Oomoo`0FOol3O004Ool3O00XOol00`0O
Oomoo`0UOol301l4Ool201m]Ool007moo`03O01oogoo00aoo`8001Yoo`El02Yoo`0301moogoo02Mo
o`D07fmoo`00Ogoo00=l07ooOol037oo00<007ooOol0Agoo00<07gooOol0W7oo001oOol00g`0Oomo
o`0<Ool00`00Oomoo`17Ool00`0OOomoo`2LOol007ioo`03O01oogoo00eoo`03001oogoo04Moo`03
01moogoo09aoo`00OWoo00=l07ooOol03Goo00<007ooOol0AWoo00<07gooOol0WGoo001eOol40005
Ool00g`0001oo`03Ool50005Ool00`00Oomoo`16Ool00`0OOomoo`2MOol007Aoo`03001oogoo009o
o`03001oogoo009oo`03O00007oo00=oo`05001oogooOol00005Ool00`00Oomoo`16Ool00`0OOomo
o`2MOol007Aoo`03001oogoo009oo`05001oogooOoml0007Ool00`00Oomoo`06Ool00`00Oomoo`16
Ool00`0OOomoo`2MOol007Aoo`03001oogoo009oo`05001oogooOoml0008Ool00`00Oomoo`05Ool3
0015Ool00`0OOomoo`2NOol007Aoo`03001oogoo009oo`05001oogooOoml0009Ool00`00Oomoo`04
Ool00`00Oomoo`15Ool00`0OOomoo`2NOol007Aoo`03001oogoo009oo`05001oogooOoml000:Ool0
0`00Oomoo`03Ool00`00Oomoo`15Ool00`0OOomoo`2NOol007Aoo`03001oogoo009oo`04001oogoo
O007Ool01@00Oomoogoo00001Goo00<007ooOol0AGoo00<07gooOol0WWoo001eOol40003Ool00g`0
Oomoo`06Ool30006Ool00`00Oomoo`15Ool00`0OOomoo`2NOol007aoo`03O01oogoo00moo`03001o
ogoo04Eoo`0301moogoo09ioo`00O7oo00=l07ooOol03goo00<007ooOol0A7oo00<07gooOol0Wgoo
001lOol00g`0Oomoo`0?Ool00`00Oomoo`14Ool00`0OOomoo`2OOol007]oo`03O01oogoo011oo`80
04Eoo`0301moogoo09moo`00Ngoo00=l07ooOol047oo00<007ooOol0A7oo00<07gooOol0Wgoo001k
Ool00g`0Oomoo`0@Ool00`00Oomoo`14Ool00`0OOomoo`2OOol007]oo`03O01oogoo011oo`03001o
ogoo04Aoo`0301moogoo09moo`00Ngoo00=l07ooOol047oo00<007ooOol0@goo00<07gooOol0X7oo
001kOol00g`0Oomoo`0@Ool00`00Oomoo`13Ool00`0OOomoo`2POol007Yoo`03O01oogoo015oo`03
001oogoo04=oo`0301moogoo0:1oo`00NWoo00=l07ooOol04Goo00<007ooOol0@goo00<07gooOol0
X7oo001jOol00g`0Oomoo`0AOol00`00Oomoo`13Ool00`0OOomoo`2POol007Yoo`03O01oogoo015o
o`8004Aoo`0301moogoo0:1oo`00NWoo00=l07ooOol04Goo00<007ooOol0@Woo00<07gooOol0XGoo
001jOol00g`0Oomoo`0AOol00`00Oomoo`12Ool00`0OOomoo`2QOol007Yoo`03O01oogoo015oo`03
001oogoo049oo`0301moogoo0:5oo`00NWoo00=l07ooOol04Goo00<007ooOol0@Woo00<07gooOol0
XGoo001iOol00g`0Oomoo`0BOol00`00Oomoo`12Ool00`0OOomoo`2QOol007Uoo`03O01oogoo019o
o`03001oogoo049oo`0301moogoo0:5oo`00NGoo00=l07ooOol04Woo00<007ooOol0@Goo00<07goo
Ool0XWoo001iOol00g`0Oomoo`0BOol20012Ool00`0OOomoo`2ROol007Uoo`03O01oogoo019oo`03
001oogoo045oo`0301moogoo0:9oo`00NGoo00=l07ooOol04Woo00<007ooOol0@Goo00<07gooOol0
XWoo001iOol00g`0Oomoo`0BOol00`00Oomoo`11Ool00`0OOomoo`2ROol007Qoo`03O01oogoo01=o
o`03001oogoo045oo`0301moogoo0:9oo`00MGoo0`0000=l07ooOol00goo0P001goo0`0017oo00<0
07ooOol0@7oo00<07gooOol0Xgoo001dOol01P00OomoogooO00000Aoo`8000Qoo`03001oogoo00=o
o`03001oogoo041oo`0301moogoo0:=oo`00M7oo00H007ooOomoog`0000>Ool00`00Oomoo`03Ool0
0`00Oomoo`10Ool00`0OOomoo`2SOol007Aoo`06001oogooOoml00002Woo1P0017oo0`00@7oo00<0
7gooOol0Xgoo001dOol01P00OomoogooO00000]oo`04001oogoo0005Ool00`00Oomoo`10Ool00`0O
Oomoo`2SOol007Aoo`06001oogooO01oo`002goo00@007ooOol000Eoo`03001oogoo041oo`0301mo
ogoo0:=oo`00M7oo00H007ooOoml07oo000<Ool00`00Ool00005Ool00`00Oomoo`0oOol00`0OOomo
o`2TOol007Eoo`800003O00007oo00eoo`8000Eoo`03001oogoo03moo`0301moogoo0:Aoo`00Mgoo
00=l07ooOol057oo00<007ooOol0?goo00<07gooOol0Y7oo001gOol00g`0Oomoo`0DOol00`00Oomo
o`0oOol00`0OOomoo`2TOol007Moo`03O01oogoo01Aoo`03001oogoo03moo`0301moogoo0:Aoo`00
MWoo00=l07ooOol05Goo0P00@7oo00<07gooOol0Y7oo001fOol00g`0Oomoo`0EOol00`00Oomoo`0n
Ool00`0OOomoo`2UOol007Ioo`03O01oogoo01Eoo`03001oogoo03ioo`0301moogoo0:Eoo`00MWoo
00=l07ooOol05Goo00<007ooOol0?Woo00<07gooOol0YGoo001fOol00g`0Oomoo`0EOol00`00Oomo
o`0nOol00`0OOomoo`2UOol007Ioo`03O01oogoo01Eoo`03001oogoo03ioo`0301moogoo0:Eoo`00
MWoo00=l07ooOol05Goo00<007ooOol0?Woo00<07gooOol0YGoo001eOol00g`0Oomoo`0FOol00`00
Oomoo`0nOol00`0OOomoo`2UOol007Eoo`03O01oogoo01Ioo`8003ioo`0301moogoo0:Ioo`00MGoo
00=l07ooOol05Woo00<007ooOol0?Goo00<07gooOol0YWoo001eOol00g`0Oomoo`0FOol00`00Oomo
o`0mOol00`0OOomoo`2VOol007Eoo`03O01oogoo01Ioo`03001oogoo03eoo`0301moogoo0:Ioo`00
MGoo00=l07ooOol05Woo00<007ooOol0?Goo00<07gooOol0YWoo001eOol00g`0Oomoo`0FOol00`00
Oomoo`0mOol00`0OOomoo`2VOol007Aoo`03O01oogoo01Moo`03001oogoo03eoo`0301moogoo0:Io
o`00M7oo00=l07ooOol05goo00<007ooOol0?7oo00<07gooOol0Ygoo001dOol00g`0Oomoo`0GOol2
000mOol00`0OOomoo`2WOol007Aoo`03O01oogoo01Moo`03001oogoo03aoo`0301moogoo0:Moo`00
M7oo00=l07ooOol05goo00<007ooOol0?7oo00<07gooOol0Ygoo001dOol00g`0Oomoo`0GOol00`00
Oomoo`0lOol00`0OOomoo`2WOol007Aoo`03O01oogoo01Moo`03001oogoo03aoo`0301moogoo0:Mo
o`00M7oo00=l000000000P001Goo0P001Woo0`001Goo00<007ooOol0?7oo00<07gooOol0Ygoo001c
Ool00g`0001oo`03Ool00`00Oomoo`02Ool20005Ool01@00Oomoogoo000017oo00<007ooOol0?7oo
00<07gooOol0Ygoo001cOol00g`0001oo`03Ool00`00Oomoo`09Ool01@00Oomoogoo000017oo00<0
07ooOol0>goo00<07gooOol0Z7oo001cOol00g`0001oo`03Ool00`00Oomoo`09Ool01@00Oomoogoo
000017oo0`00>goo00<07gooOol0Z7oo001cOol00g`0001oo`03Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`0kOol00`0OOomoo`2XOol007=oo`03O00007oo00=oo`03001oogoo00Uoo`03001oogoo
00Ioo`03001oogoo03]oo`0301moogoo0:Qoo`00Lgoo00=l0000Ool00goo00<007ooOol02Woo00<0
07ooOol01Goo00<007ooOol0>goo00<07gooOol0Z7oo001cOol00g`0Ool00003000>Ool30004Ool0
0`00Oomoo`0kOol00`0OOomoo`2XOol007=oo`03O01oogoo01Qoo`03001oogoo03]oo`0301moogoo
0:Qoo`00LWoo00=l07ooOol06Goo00<007ooOol0>Woo00<07gooOol0ZGoo001bOol00g`0Oomoo`0I
Ool00`00Oomoo`0jOol00`0OOomoo`2YOol0079oo`03O01oogoo01Uoo`8003]oo`0301moogoo0:Uo
o`00LWoo00=l07ooOol06Goo00<007ooOol0>Woo00<07gooOol0ZGoo001bOol00g`0Oomoo`0IOol0
0`00Oomoo`0jOol00`0OOomoo`2YOol00001\
\>"],
  ImageRangeCache->{{{0, 374}, {177.75, 0}} -> {-3.2028, -0.434817, \
0.0280328, 0.00773479}}]
}, Open  ]],

Cell[TextData[{
  "It is obvious from the figure that a shift by \[Dash]2 in the argument \
translates the function by a distance of 2 to the right. Using the animation \
capabilities of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we can readily demonstrate the shifting process by a small simulation. \
The process of shifting is demonstrated by the following animation where the \
parameter \[Epsilon] is varied from \[Dash]1 up to 1 in steps of 1/20."
}], "Text",
  CellTags->"animation of a translation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Plot[Evaluate[T[x\^2\/2 - x\^3\/4, \[Epsilon]]], \n
        \t\t\t{x, \(-2\), 2}, \n\t\t\tPlotRange \[Rule] {\(- .4\),  .6}, 
        PlotStyle \[Rule] {Hue[\[Epsilon]]}], \n
      \t{\[Epsilon], \(-1\), 1, 1\/20}]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.5231 .61803 m
.53984 .55067 L
.57861 .4323 L
.59832 .38497 L
.61984 .34238 L
.64066 .30955 L
.65954 .2864 L
.67922 .26845 L
.69002 .26109 L
.70019 .25567 L
.70995 .25179 L
.71487 .2503 L
.72027 .24901 L
.72488 .24819 L
.72746 .24784 L
.72982 .24759 L
.73201 .24742 L
.73325 .24734 L
.7344 .24729 L
.7354 .24725 L
.73651 .24723 L
.73766 .24721 L
.73874 .24722 L
.73992 .24723 L
.74117 .24726 L
.74236 .24731 L
.74344 .24737 L
.74608 .24756 L
.74857 .2478 L
.75354 .24847 L
.75892 .24947 L
.76855 .25195 L
.77743 .25495 L
.79619 .26337 L
.81683 .27542 L
.85717 .30518 L
.89599 .33806 L
.93727 .37301 L
.97619 .40172 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.375, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OooY0005O01B0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Eoo`Il0004Ool007oo
Ool6O007Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00
Oomoo`0;Ool000aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo009oo`=l00Moo`03001oogoo00Ioo`=l00Aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00Y7oo00<007ooOol0?7oo0W`05Woo
0W`0C7oo002TOol00`00Oomoo`0jOol2O00JOol2O01:Ool00:Aoo`03001oogoo03Uoo`03O01oogoo
01aoo`9l04Qoo`00Y7oo00<007ooOol0=goo0W`08Goo0W`0AWoo002TOol00`00Oomoo`0fOol00g`0
Oomoo`0SOol2O014Ool00:Aoo`03001oogoo03Eoo`03O01oogoo02Ioo`9l049oo`00Y7oo00<007oo
Ool0=7oo00=l07ooOol0:Goo0W`0@7oo002TOol2000cOol2O00^Ool00g`0Oomoo`0mOol00:Aoo`03
001oogoo035oo`03O01oogoo02moo`9l03eoo`00Y7oo00<007ooOol0<7oo00=l07ooOol0<Woo00=l
07ooOol0>Woo002TOol00`00Oomoo`0_Ool00g`0Oomoo`0dOol00g`0Oomoo`0iOol00:Aoo`03001o
ogoo02ioo`03O01oogoo03Ioo`9l03Uoo`00Y7oo00<007ooOol0;Goo00=l07ooOol0>Goo00=l07oo
Ool0=Woo002TOol00`00Oomoo`0/Ool00g`0Oomoo`0kOol00g`0Oomoo`0eOol00:Aoo`03001oogoo
02aoo`03O01oogoo03aoo`9l03Eoo`00Y7oo00<007ooOol0:goo00=l07ooOol0?goo00=l07ooOol0
<Woo002TOol00`00Oomoo`0ZOol00g`0Oomoo`11Ool00g`0Oomoo`0aOol00:Aoo`8002Yoo`03O01o
ogoo04=oo`03O01oogoo031oo`00Y7oo00<007ooOol0:7oo00=l07ooOol0AGoo0W`0<7oo002TOol0
0`00Oomoo`0XOol00g`0Oomoo`17Ool00g`0Oomoo`0]Ool00:Aoo`03001oogoo02Moo`03O01oogoo
04Uoo`03O01oogoo02aoo`00Y7oo00<007ooOol09goo00=l07ooOol0BWoo0W`0;7oo002TOol00`00
Oomoo`0VOol00g`0Oomoo`1=Ool00g`0Oomoo`0YOol00:Aoo`03001oogoo02Ioo`03O01oogoo04io
o`03O01oogoo02Qoo`00Y7oo00<007ooOol09Goo00=l07ooOol0D7oo0W`0:7oo002TOol00`00Oomo
o`0UOol00g`0Oomoo`1BOol00g`0Oomoo`0UOol00:Aoo`03001oogoo02Aoo`03O01oogoo05Aoo`03
O01oogoo02Aoo`00Y7oo0P009Goo00=l07ooOol0EGoo00=l07ooOol08goo002TOol00`00Oomoo`0S
Ool00g`0Oomoo`1GOol00g`0Oomoo`0ROol00:Aoo`03001oogoo029oo`03O01oogoo05Uoo`9l029o
o`00Y7oo00<007ooOol08Woo00=l07ooOol0Fgoo00=l07ooOol07goo002TOol00`00Oomoo`0QOol0
0g`0Oomoo`1MOol00g`0Oomoo`0NOol00:Aoo`03001oogoo025oo`03O01oogoo05ioo`03O01oogoo
01eoo`00Y7oo00<007ooOol087oo00=l07ooOol0H7oo00=l07ooOol077oo002:Ool40005Ool20004
Ool50006Ool00`00Oomoo`0POol00g`0Oomoo`1QOol2O00LOol008Uoo`03001oogoo009oo`03001o
ogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomoo`0OOol00g`0Oomoo`1TOol00g`0Oomo
o`0IOol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo01moo`03
O01oogoo06Eoo`03O01oogoo01Qoo`00RGoo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol0
1Woo0`007Woo00=l07ooOol0Igoo00=l07ooOol05goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0;
Ool00`00Oomoo`05Ool00`00Oomoo`0NOol00g`0Oomoo`1XOol00g`0Oomoo`0FOol008Uoo`03001o
ogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo01eoo`03O01oogoo06Yoo`03O01o
ogoo01Eoo`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo
01eoo`03O01oogoo06]oo`9l01Eoo`00RWoo100037oo0`001goo00<007ooOol077oo00=l07ooOol0
KWoo00=l07ooOol04Woo002TOol00`00Oomoo`0LOol00g`0Oomoo`1_Ool00g`0Oomoo`0AOol00:Ao
o`03001oogoo01]oo`03O01oogoo075oo`03O01oogoo011oo`00Y7oo00<007ooOol06goo00=l07oo
Ool0LWoo00=l07ooOol03goo002TOol00`00Oomoo`0JOol00g`0Oomoo`1dOol2O00?Ool00:Aoo`03
001oogoo01Yoo`03O01oogoo07Ioo`03O01oogoo00aoo`00Y7oo0P006goo00=l07ooOol0Mgoo00=l
07ooOol02goo002TOol00`00Oomoo`0IOol00g`0Oomoo`26Ool00:Aoo`03001oogoo01Uoo`03O01o
ogoo08Ioo`00Y7oo00<007ooOol067oo00=l07ooOol0Qgoo002TOol00`00Oomoo`0HOol00g`0Oomo
o`27Ool00:Aoo`03001oogoo01Qoo`03O01oogoo08Moo`00Y7oo00<007ooOol05goo00=l07ooOol0
R7oo002TOol00`00Oomoo`0GOol00g`0Oomoo`28Ool00:Aoo`03001oogoo01Ioo`03O01oogoo08Uo
o`00Y7oo0P005goo00=l07ooOol0RGoo002TOol00`00Oomoo`0FOol00g`0Oomoo`29Ool00:Aoo`03
001oogoo01Eoo`03O01oogoo08Yoo`00Y7oo00<007ooOol05Goo00=l07ooOol0RWoo002TOol00`00
Oomoo`0EOol00g`0Oomoo`2:Ool00:Aoo`03001oogoo01Aoo`03O01oogoo08]oo`00Y7oo00<007oo
Ool057oo00=l07ooOol0Rgoo002TOol00`00Oomoo`0DOol00g`0Oomoo`2;Ool00:Aoo`03001oogoo
01=oo`03O01oogoo08aoo`00Y7oo00<007ooOol04goo00=l07ooOol0S7oo002TOol2000DOol00g`0
Oomoo`2<Ool00:Aoo`03001oogoo019oo`03O01oogoo08eoo`00Y7oo00<007ooOol04Woo00=l07oo
Ool0SGoo002TOol00`00Oomoo`0BOol00g`0Oomoo`2=Ool00:Aoo`03001oogoo015oo`03O01oogoo
08ioo`00Y7oo00<007ooOol04Goo00=l07ooOol0SWoo002TOol00`00Oomoo`0AOol00g`0Oomoo`2>
Ool008Yoo`@000Eoo`8000Moo`<000Eoo`03001oogoo011oo`03O01oogoo08moo`00RGoo00<007oo
Ool00Woo00<007ooOol00Woo0P0027oo00<007ooOol017oo00<007ooOol047oo00=l07ooOol0Sgoo
0029Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`0?Ool00g`0Oomo
o`2@Ool008Uoo`03001oogoo009oo`03001oogoo00Qoo`H000Eoo`<000moo`03O01oogoo091oo`00
RGoo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo00moo`03O01oogoo
091oo`00RGoo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo00ioo`03
O01oogoo095oo`00RGoo00<007ooOol00Woo00<007ooOol02Woo00<007oo00001Woo00<007ooOol0
3Woo00=l07ooOol0TGoo002:Ool4000>Ool20006Ool00`00Oomoo`0>Ool00g`0Oomoo`2AOol00:Ao
o`03001oogoo00eoo`03O01oogoo099oo`00Y7oo00<007ooOol03Goo00=l07ooOol0TWoo002TOol0
0`00Oomoo`0=Ool00g`0Oomoo`2BOol00:Aoo`03001oogoo00aoo`03O01oogoo09=oo`00Y7oo00<0
07ooOol037oo00=l07ooOol0Tgoo002TOol2000=Ool00g`0Oomoo`2COol00:Aoo`03001oogoo00]o
o`03O01oogoo09Aoo`00Y7oo00<007ooOol02goo00=l07ooOol0U7oo002TOol00`00Oomoo`0;Ool0
0g`0Oomoo`2DOol00:Aoo`03001oogoo00Yoo`03O01oogoo09Eoo`00Y7oo00<007ooOol02Woo00=l
07ooOol0UGoo002TOol00`00Oomoo`0:Ool00g`0Oomoo`2EOol00:Aoo`03001oogoo00Uoo`03O01o
ogoo09Ioo`00Y7oo00<007ooOol02Goo00=l07ooOol0UWoo002TOol00`00Oomoo`09Ool00g`0Oomo
o`2FOol00:Aoo`8000Yoo`03O01oogoo09Ioo`00Y7oo00<007ooOol027oo00=l07ooOol0Ugoo002T
Ool00`00Oomoo`08Ool00g`0Oomoo`2GOol00:Aoo`03001oogoo00Qoo`03O01oogoo09Moo`00Y7oo
00<007ooOol027oo00=l07ooOol0Ugoo002TOol00`00Oomoo`07Ool00g`0Oomoo`2HOol00:Aoo`03
001oogoo00Moo`03O01oogoo09Qoo`00Y7oo00<007ooOol01goo00=l07ooOol0V7oo002TOol00`00
Oomoo`07Ool00g`0Oomoo`2HOol00:Aoo`03001oogoo00Ioo`03O01oogoo09Uoo`00Y7oo0P001goo
00=l07ooOol0VGoo002TOol00`00Oomoo`06Ool00g`0Oomoo`2IOol00:Aoo`03001oogoo00Ioo`03
O01oogoo09Uoo`00Y7oo00<007ooOol01Goo00=l07ooOol0VWoo002TOol00`00Oomoo`05Ool00g`0
Oomoo`2JOol00:Aoo`03001oogoo00Eoo`03O01oogoo09Yoo`00Y7oo00<007ooOol01Goo00=l07oo
Ool0VWoo002TOol00`00Oomoo`04Ool00g`0Oomoo`2KOol00:Aoo`03001oogoo00Aoo`03O01oogoo
09]oo`00Y7oo00<007ooOol017oo00=l07ooOol0Vgoo0000\
\>"],
  ImageRangeCache->{{{0, 328.188}, {202.438, 0}} -> {-2.16423, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .3 0 r
.5 Mabswid
.51096 .61803 m
.53984 .51059 L
.57861 .40273 L
.59975 .35751 L
.61984 .32264 L
.63964 .29547 L
.65803 .27616 L
.6686 .26748 L
.67855 .26082 L
.68749 .25604 L
.69249 .25384 L
.69716 .25209 L
.70213 .25053 L
.70666 .24938 L
.7117 .24839 L
.71447 .24798 L
.7171 .24767 L
.71964 .24745 L
.72092 .24737 L
.72234 .2473 L
.72354 .24725 L
.72484 .24722 L
.72606 .24721 L
.72719 .24722 L
.72851 .24724 L
.72974 .24728 L
.73045 .24731 L
.73109 .24734 L
.73253 .24743 L
.73543 .24767 L
.73816 .24798 L
.74279 .24866 L
.74788 .24966 L
.75817 .25242 L
.76771 .25579 L
.77663 .25961 L
.81545 .2825 L
.85673 .31464 L
.89649 .34877 L
.93473 .38046 L
.97543 .4086 L
.97619 .40904 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OooV0005OB1E0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`04001oogooOol6OB05Ool6OB0:Ool0
0`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool0
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo
00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`04001oogdP
OB0;Ool00`00Oomoo`03Ool3OB07Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool0
0`00Oomoo`0<Ool00`00Oomoo`0;Ool00:Aoo`03001oogoo03Qoo`=m81Ioo`=m84ioo`00Y7oo00<0
07ooOol0=Woo0WdP77oo0WdPC7oo002TOol00`00Oomoo`0eOol00gdPOomoo`0NOol2OB1:Ool00:Ao
o`03001oogoo03=oo`9m82=oo`03OB1oogoo04Moo`00Y7oo00<007ooOol0<Woo00=m87ooOol097oo
0WdPAgoo002TOol00`00Oomoo`0aOol00gdPOomoo`0WOol00gdPOomoo`14Ool00:Aoo`03001oogoo
031oo`03OB1oogoo02Uoo`9m84Aoo`00Y7oo0P00<7oo00=m87ooOol0;7oo00=m87ooOol0@Goo002T
Ool00`00Oomoo`0^Ool00gdPOomoo`0^Ool2OB11Ool00:Aoo`03001oogoo02eoo`03OB1oogoo035o
o`03OB1oogoo03ioo`00Y7oo00<007ooOol0;7oo00=m87ooOol0<goo00=m87ooOol0?Goo002TOol0
0`00Oomoo`0[Ool00gdPOomoo`0eOol2OB0mOol00:Aoo`03001oogoo02Yoo`03OB1oogoo03Qoo`03
OB1oogoo03Yoo`00Y7oo00<007ooOol0:Goo00=m87ooOol0>Woo00=m87ooOol0>Goo002TOol00`00
Oomoo`0XOol00gdPOomoo`0lOol2OB0iOol00:Aoo`03001oogoo02Moo`03OB1oogoo03moo`03OB1o
ogoo03Ioo`00Y7oo00<007ooOol09goo00=m87ooOol0@7oo00=m87ooOol0=Goo002TOol2000WOol0
0gdPOomoo`12Ool2OB0eOol00:Aoo`03001oogoo02Eoo`03OB1oogoo04Eoo`03OB1oogoo039oo`00
Y7oo00<007ooOol097oo00=m87ooOol0Agoo00=m87ooOol0<Goo002TOol00`00Oomoo`0TOol00gdP
Oomoo`18Ool00gdPOomoo`0`Ool00:Aoo`03001oogoo02=oo`03OB1oogoo04Yoo`03OB1oogoo02mo
o`00Y7oo00<007ooOol08Woo00=m87ooOol0C7oo0WdP;goo002TOol00`00Oomoo`0ROol00gdPOomo
o`1>Ool00gdPOomoo`0/Ool00:Aoo`03001oogoo025oo`03OB1oogoo051oo`03OB1oogoo02]oo`00
Y7oo00<007ooOol08Goo00=m87ooOol0DGoo00=m87ooOol0:Woo002TOol00`00Oomoo`0POol00gdP
Oomoo`1COol00gdPOomoo`0YOol00:Aoo`80021oo`03OB1oogoo05Eoo`9m82Uoo`00Y7oo00<007oo
Ool07goo00=m87ooOol0Egoo00=m87ooOol09Woo002TOol00`00Oomoo`0NOol00gdPOomoo`1IOol0
0gdPOomoo`0UOol00:Aoo`03001oogoo01ioo`03OB1oogoo05Yoo`03OB1oogoo02Aoo`00Y7oo00<0
07ooOol07Goo00=m87ooOol0G7oo00=m87ooOol08goo002TOol00`00Oomoo`0MOol00gdPOomoo`1M
Ool00gdPOomoo`0ROol00:Aoo`03001oogoo01aoo`03OB1oogoo05moo`9m829oo`00RWoo10001Goo
0P0017oo1@001Woo00<007ooOol077oo00=m87ooOol0HGoo00=m87ooOol07goo0029Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00001Woo00<007ooOol06goo00=m87ooOol0
Hgoo00=m87ooOol07Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`07Ool00`00
Oomoo`0KOol00gdPOomoo`1TOol00gdPOomoo`0MOol008Uoo`03001oogoo009oo`03001oogoo00Yo
o`03001oogoo00Ioo`<001Yoo`03OB1oogoo06Ioo`03OB1oogoo01aoo`00RGoo00<007ooOol00Woo
00<007ooOol02goo00<007ooOol01Goo00<007ooOol06Woo00=m87ooOol0Igoo0WdP77oo0029Ool0
0`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`0IOol00gdPOomoo`1ZOol0
0gdPOomoo`0IOol008Uoo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol00006Ool00`00
Oomoo`0IOol00gdPOomoo`1[Ool00gdPOomoo`0HOol008Yoo`@000aoo`<000Moo`03001oogoo01Uo
o`03OB1oogoo06aoo`9m81Qoo`00Y7oo00<007ooOol067oo00=m87ooOol0Kgoo00=m87ooOol05Goo
002TOol00`00Oomoo`0HOol00gdPOomoo`1`Ool2OB0EOol00:Aoo`03001oogoo01Moo`03OB1oogoo
07=oo`03OB1oogoo019oo`00Y7oo00<007ooOol05goo00=m87ooOol0M7oo00=m87ooOol04Goo002T
Ool00`00Oomoo`0FOol00gdPOomoo`1fOol2OB0AOol00:Aoo`8001Moo`03OB1oogoo07Qoo`03OB1o
ogoo00ioo`00Y7oo00<007ooOol05Woo00=m87ooOol0NGoo0WdP3Woo002TOol00`00Oomoo`0EOol0
0gdPOomoo`1lOol00gdPOomoo`0;Ool00:Aoo`03001oogoo01Eoo`03OB1oogoo08Yoo`00Y7oo00<0
07ooOol057oo00=m87ooOol0Rgoo002TOol00`00Oomoo`0DOol00gdPOomoo`2;Ool00:Aoo`03001o
ogoo01Aoo`03OB1oogoo08]oo`00Y7oo00<007ooOol04goo00=m87ooOol0S7oo002TOol00`00Oomo
o`0COol00gdPOomoo`2<Ool00:Aoo`8001Aoo`03OB1oogoo08aoo`00Y7oo00<007ooOol04Woo00=m
87ooOol0SGoo002TOol00`00Oomoo`0BOol00gdPOomoo`2=Ool00:Aoo`03001oogoo015oo`03OB1o
ogoo08ioo`00Y7oo00<007ooOol04Goo00=m87ooOol0SWoo002TOol00`00Oomoo`0AOol00gdPOomo
o`2>Ool00:Aoo`03001oogoo011oo`03OB1oogoo08moo`00Y7oo00<007ooOol047oo00=m87ooOol0
Sgoo002TOol00`00Oomoo`0?Ool00gdPOomoo`2@Ool00:Aoo`03001oogoo00moo`03OB1oogoo091o
o`00Y7oo0P0047oo00=m87ooOol0T7oo002TOol00`00Oomoo`0>Ool00gdPOomoo`2AOol00:Aoo`03
001oogoo00ioo`03OB1oogoo095oo`00Y7oo00<007ooOol03Woo00=m87ooOol0TGoo002TOol00`00
Oomoo`0=Ool00gdPOomoo`2BOol00:Aoo`03001oogoo00eoo`03OB1oogoo099oo`00Y7oo00<007oo
Ool037oo00=m87ooOol0Tgoo002:Ool40005Ool20007Ool30005Ool00`00Oomoo`0<Ool00gdPOomo
o`2COol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Qoo`03001oogoo00Aoo`03001oogoo
00aoo`03OB1oogoo09=oo`00RGoo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<0
07ooOol02goo00=m87ooOol0U7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`08Ool60005Ool3000;
Ool00gdPOomoo`2DOol008Uoo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00
Oomoo`0;Ool00gdPOomoo`2DOol008Uoo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006
Ool00`00Oomoo`0:Ool00gdPOomoo`2EOol008Uoo`03001oogoo009oo`03001oogoo00Yoo`03001o
o`0000Ioo`03001oogoo00Yoo`03OB1oogoo09Eoo`00RWoo10003Woo0P001Woo00<007ooOol02Goo
00=m87ooOol0UWoo002TOol00`00Oomoo`09Ool00gdPOomoo`2FOol00:Aoo`03001oogoo00Uoo`03
OB1oogoo09Ioo`00Y7oo00<007ooOol027oo00=m87ooOol0Ugoo002TOol00`00Oomoo`08Ool00gdP
Oomoo`2GOol00:Aoo`03001oogoo00Qoo`03OB1oogoo09Moo`00Y7oo0P002Goo00=m87ooOol0Ugoo
002TOol00`00Oomoo`07Ool00gdPOomoo`2HOol00:Aoo`03001oogoo00Moo`03OB1oogoo09Qoo`00
Y7oo00<007ooOol01goo00=m87ooOol0V7oo002TOol00`00Oomoo`07Ool00gdPOomoo`2HOol00:Ao
o`03001oogoo00Ioo`03OB1oogoo09Uoo`00Y7oo00<007ooOol01Woo00=m87ooOol0VGoo002TOol0
0`00Oomoo`06Ool00gdPOomoo`2IOol00:Aoo`03001oogoo00Ioo`03OB1oogoo09Uoo`00Y7oo00<0
07ooOol01Goo00=m87ooOol0VWoo002TOol20006Ool00gdPOomoo`2JOol00:Aoo`03001oogoo00Eo
o`03OB1oogoo09Yoo`00Y7oo00<007ooOol017oo00=m87ooOol0Vgoo002TOol00`00Oomoo`04Ool0
0gdPOomoo`2KOol00:Aoo`03001oogoo00Aoo`03OB1oogoo09]oo`00Y7oo00<007ooOol017oo00=m
87ooOol0Vgoo002TOol00`00Oomoo`03Ool00gdPOomoo`2LOol00:Aoo`03001oogoo00=oo`03OB1o
ogoo09aoo`00Y7oo00<007ooOol00goo00=m87ooOol0W7oo002TOol00`00Oomoo`03Ool00gdPOomo
o`2LOol00:Aoo`8000=oo`03OB1oogoo09eoo`00Y7oo00<007ooOol00Woo00=m87ooOol0WGoo002T
Ool00`00Oomoo`02Ool00gdPOomoo`2MOol00:Aoo`03001oogoo009oo`03OB1oogoo09eoo`00Y7oo
00D007ooOomoogdP0:1oo`00Y7oo00D007ooOomoogdP0:1oo`00Y7oo00D007ooOomoogdP0:1oo`00
Y7oo00D007ooOomoogdP0:1oo`00Y7oo00@007ooOomm8:5oo`00Y7oo00@007ooOomm8:5oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .6 0 r
.5 Mabswid
.49817 .61803 m
.49955 .61191 L
.53984 .47387 L
.57861 .37614 L
.59975 .33593 L
.61984 .30549 L
.63964 .28235 L
.65803 .2665 L
.6686 .25968 L
.67855 .2547 L
.68749 .25135 L
.69252 .24991 L
.69716 .24887 L
.70186 .24808 L
.70449 .24775 L
.70689 .24752 L
.70913 .24736 L
.71039 .2473 L
.71156 .24725 L
.71258 .24723 L
.7137 .24722 L
.71488 .24722 L
.71598 .24723 L
.71719 .24726 L
.71851 .24731 L
.71989 .24738 L
.72117 .24747 L
.72347 .24766 L
.72593 .24793 L
.73154 .24878 L
.73665 .24981 L
.74663 .25253 L
.75583 .2558 L
.77663 .26563 L
.81603 .29159 L
.85392 .32233 L
.89426 .35704 L
.93308 .38827 L
.97436 .41455 L
.97619 .41547 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OooR0005OT1I0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001n@7i000An@0Aoo`In@0ioo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
3Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol02Woo0gi03Woo00<0
07ooOT000Wi02goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo
00<007ooOol02goo002TOol00`00Oomoo`0dOol3OT0FOol3OT1BOol00:Aoo`03001oogoo039oo`9n
@1aoo`9n@51oo`00Y7oo00<007ooOol0<Goo00=n@7ooOol07Woo0Wi0CWoo002TOol00`00Oomoo`0`
Ool00gi0Oomoo`0QOol2OT1<Ool00:Aoo`03001oogoo02moo`03OT1oogoo02Aoo`03OT1oogoo04Uo
o`00Y7oo00<007ooOol0;Woo00=n@7ooOol09Woo0Wi0BGoo002TOol00`00Oomoo`0]Ool00gi0Oomo
o`0YOol00gi0Oomoo`16Ool00:Aoo`8002aoo`9n@2eoo`03OT1oogoo04Eoo`00Y7oo00<007ooOol0
:Woo00=n@7ooOol0;Woo0Wi0AGoo002TOol00`00Oomoo`0YOol00gi0Oomoo`0aOol00gi0Oomoo`12
Ool00:Aoo`03001oogoo02Qoo`03OT1oogoo03=oo`03OT1oogoo045oo`00Y7oo00<007ooOol09goo
00=n@7ooOol0=Goo0Wi0@Goo002TOol00`00Oomoo`0VOol00gi0Oomoo`0hOol00gi0Oomoo`0nOol0
0:Aoo`03001oogoo02Ioo`03OT1oogoo03Uoo`03OT1oogoo03eoo`00Y7oo00<007ooOol09Goo00=n
@7ooOol0>goo0Wi0?Goo002TOol00`00Oomoo`0TOol00gi0Oomoo`0nOol00gi0Oomoo`0jOol00:Ao
o`03001oogoo02=oo`03OT1oogoo041oo`03OT1oogoo03Uoo`00Y7oo0P008goo00=n@7ooOol0@Woo
0Wi0>Goo002TOol00`00Oomoo`0ROol00gi0Oomoo`14Ool00gi0Oomoo`0fOol00:Aoo`03001oogoo
025oo`03OT1oogoo04Ioo`03OT1oogoo03Eoo`00Y7oo00<007ooOol087oo00=n@7ooOol0B7oo0Wi0
=Goo002TOol00`00Oomoo`0OOol00gi0Oomoo`1;Ool00gi0Oomoo`0bOol00:Aoo`03001oogoo01mo
o`03OT1oogoo04aoo`03OT1oogoo035oo`00Y7oo00<007ooOol07Woo00=n@7ooOol0CWoo00=n@7oo
Ool0<7oo002TOol00`00Oomoo`0MOol00gi0Oomoo`1@Ool2OT0`Ool00:Aoo`03001oogoo01eoo`03
OT1oogoo059oo`03OT1oogoo02eoo`00Y7oo00<007ooOol077oo00=n@7ooOol0E7oo00=n@7ooOol0
;7oo002TOol2000LOol00gi0Oomoo`1FOol00gi0Oomoo`0[Ool00:Aoo`03001oogoo01]oo`03OT1o
ogoo05Moo`03OT1oogoo02Yoo`00Y7oo00<007ooOol06Woo00=n@7ooOol0FGoo0Wi0:Woo002TOol0
0`00Oomoo`0JOol00gi0Oomoo`1KOol00gi0Oomoo`0WOol00:Aoo`03001oogoo01Uoo`03OT1oogoo
05eoo`03OT1oogoo02Ioo`00Y7oo00<007ooOol06Goo00=n@7ooOol0GWoo00=n@7ooOol09Goo002T
Ool00`00Oomoo`0HOol00gi0Oomoo`1POol00gi0Oomoo`0TOol008Yoo`@000Eoo`8000Aoo`D000Io
o`03001oogoo01Qoo`03OT1oogoo065oo`9n@2Aoo`00RGoo00<007ooOol00Woo00<007ooOol00Woo
0P0017oo00D007ooOomoo`0000Ioo`03001oogoo01Moo`03OT1oogoo06Aoo`03OT1oogoo025oo`00
RGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol05goo00=n@7ooOol0
IGoo00=n@7ooOol087oo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool3000F
Ool00gi0Oomoo`1WOol2OT0POol008Uoo`03001oogoo009oo`03001oogoo00]oo`03001oogoo00Eo
o`03001oogoo01Ioo`03OT1oogoo06Uoo`03OT1oogoo01eoo`00RGoo00<007ooOol00Woo00<007oo
Ool037oo00<007ooOol017oo00<007ooOol05Woo00=n@7ooOol0JWoo00=n@7ooOol077oo0029Ool0
0`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol05Goo00=n@7ooOol0
K7oo0Wi077oo002:Ool4000<Ool30007Ool00`00Oomoo`0EOol00gi0Oomoo`1^Ool00gi0Oomoo`0I
Ool00:Aoo`03001oogoo01Aoo`03OT1oogoo071oo`03OT1oogoo01Qoo`00Y7oo00<007ooOol057oo
00=n@7ooOol0LGoo0Wi067oo002TOol00`00Oomoo`0DOol00gi0Oomoo`1cOol00gi0Oomoo`0EOol0
0:Aoo`03001oogoo01=oo`03OT1oogoo07Eoo`9n@1Eoo`00Y7oo00<007ooOol04goo00=n@7ooOol0
Mgoo00=n@7ooOol04Woo002TOol2000COol00gi0Oomoo`1iOol00gi0Oomoo`0AOol00:Aoo`03001o
ogoo019oo`03OT1oogoo07Yoo`9n@15oo`00Y7oo00<007ooOol04Woo00=n@7ooOol0O7oo00=n@7oo
Ool03Woo002TOol00`00Oomoo`0AOol00gi0Oomoo`1nOol2OT0>Ool00:Aoo`03001oogoo015oo`03
OT1oogoo081oo`03OT1oogoo00]oo`00Y7oo00<007ooOol047oo00=n@7ooOol0Sgoo002TOol00`00
Oomoo`0@Ool00gi0Oomoo`2?Ool00:Aoo`03001oogoo00moo`03OT1oogoo091oo`00Y7oo00<007oo
Ool03goo00=n@7ooOol0T7oo002TOol2000@Ool00gi0Oomoo`2@Ool00:Aoo`03001oogoo00ioo`03
OT1oogoo095oo`00Y7oo00<007ooOol03Woo00=n@7ooOol0TGoo002TOol00`00Oomoo`0=Ool00gi0
Oomoo`2BOol00:Aoo`03001oogoo00eoo`03OT1oogoo099oo`00Y7oo00<007ooOol03Goo00=n@7oo
Ool0TWoo002TOol00`00Oomoo`0<Ool00gi0Oomoo`2COol00:Aoo`03001oogoo00aoo`03OT1oogoo
09=oo`00Y7oo00<007ooOol02goo00=n@7ooOol0U7oo002TOol00`00Oomoo`0;Ool00gi0Oomoo`2D
Ool00:Aoo`8000aoo`03OT1oogoo09Aoo`00Y7oo00<007ooOol02Woo00=n@7ooOol0UGoo002TOol0
0`00Oomoo`0:Ool00gi0Oomoo`2EOol00:Aoo`03001oogoo00Uoo`03OT1oogoo09Ioo`00Y7oo00<0
07ooOol02Goo00=n@7ooOol0UWoo002TOol00`00Oomoo`09Ool00gi0Oomoo`2FOol00:Aoo`03001o
ogoo00Qoo`03OT1oogoo09Moo`00RWoo10001Goo0P001goo0`001Goo00<007ooOol027oo00=n@7oo
Ool0Ugoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`04Ool00`00Oomo
o`08Ool00gi0Oomoo`2GOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03
001oogoo00Qoo`03OT1oogoo09Moo`00RGoo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00
1goo00=n@7ooOol0V7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<0
07ooOol01goo00=n@7ooOol0V7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`00
1Woo00<007ooOol01goo00=n@7ooOol0V7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Ool00006Ool00`00Oomoo`06Ool00gi0Oomoo`2IOol008Yoo`@000ioo`8000Ioo`03001oogoo00Io
o`03OT1oogoo09Uoo`00Y7oo00<007ooOol01Woo00=n@7ooOol0VGoo002TOol00`00Oomoo`05Ool0
0gi0Oomoo`2JOol00:Aoo`03001oogoo00Eoo`03OT1oogoo09Yoo`00Y7oo00<007ooOol01Goo00=n
@7ooOol0VWoo002TOol00`00Oomoo`05Ool00gi0Oomoo`2JOol00:Aoo`8000Eoo`03OT1oogoo09]o
o`00Y7oo00<007ooOol017oo00=n@7ooOol0Vgoo002TOol00`00Oomoo`04Ool00gi0Oomoo`2KOol0
0:Aoo`03001oogoo00=oo`03OT1oogoo09aoo`00Y7oo00<007ooOol00goo00=n@7ooOol0W7oo002T
Ool00`00Oomoo`03Ool00gi0Oomoo`2LOol00:Aoo`03001oogoo009oo`03OT1oogoo09eoo`00Y7oo
00<007ooOol00Woo00=n@7ooOol0WGoo002TOol00`00Oomoo`02Ool00gi0Oomoo`2MOol00:Aoo`03
001oogoo009oo`03OT1oogoo09eoo`00Y7oo0P000Woo00=n@7ooOol0WWoo002TOol01@00Oomoogoo
OT00X7oo002TOol01@00OomoogooOT00X7oo002TOol01000Oomoogi0XGoo002TOol01000Oomoogi0
XGoo002TOol01000Oomoogi0XGoo002TOol01000Oomoogi0XGoo002TOol00`00Oomn@02ROol00:Ao
o`03001oogi00:9oo`00Y7oo00<007ooOT00XWoo002TOol00`00OT1oo`2ROol00:Aoo`03001n@7oo
0:9oo`00Y7oo00<007i0Ool0XWoo002TOol00gi0Oomoo`2ROol00:Aoo`03OT1oogoo0:9oo`00Y7oo
00=n@7ooOol0XWoo002TOol00gi0Oomoo`2ROol00:=oo`03OT0007oo0:=oo`00Xgoo00=n@000Ool0
Xgoo002SOol00gi0001oo`2SOol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .9 0 r
.5 Mabswid
.48713 .61803 m
.49955 .56699 L
.53984 .44039 L
.57861 .35242 L
.59975 .31701 L
.61984 .29079 L
.62942 .28068 L
.63964 .2715 L
.64922 .26434 L
.65803 .25894 L
.66831 .25399 L
.67362 .252 L
.67944 .25022 L
.68451 .24902 L
.68925 .24818 L
.69186 .24783 L
.69425 .24758 L
.69557 .24747 L
.697 .24737 L
.69836 .2473 L
.69961 .24726 L
.70079 .24723 L
.70203 .24721 L
.70309 .24722 L
.70424 .24723 L
.70549 .24727 L
.70619 .24729 L
.70683 .24732 L
.70924 .24747 L
.71147 .24766 L
.71389 .24792 L
.71827 .24854 L
.72348 .24953 L
.72899 .25086 L
.73888 .25392 L
.75845 .26233 L
.77676 .27266 L
.81559 .30047 L
.85686 .3351 L
.89663 .36899 L
.93487 .398 L
.97557 .42064 L
.97619 .4209 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OooN0005Oh1M0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Uoo`EoP0Eoo`EoP0=oo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]o
o`0037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007oo
Ool03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol01goo0Wn00goo
00<007ooOol02Goo0gn000<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol02goo002TOol00`00Oomoo`0aOol3Oh0DOol3Oh1GOol00:Ao
o`03001oogoo02moo`9oP1Yoo`=oP5Aoo`00Y7oo00<007ooOol0;Goo0Wn07goo0Wn0DWoo002TOol0
0`00Oomoo`0/Ool00gn0Oomoo`0QOol2Oh1@Ool00:Aoo`03001oogoo02Yoo`9oP2Ioo`03Oh1oogoo
04eoo`00Y7oo00<007ooOol0:Goo00=oP7ooOol09goo0Wn0CGoo002TOol00`00Oomoo`0XOol00gn0
Oomoo`0ZOol00gn0Oomoo`1:Ool00:Aoo`8002Qoo`03Oh1oogoo02aoo`9oP4Yoo`00Y7oo00<007oo
Ool09Woo00=oP7ooOol0;goo00=oP7ooOol0Agoo002TOol00`00Oomoo`0UOol00gn0Oomoo`0aOol2
Oh17Ool00:Aoo`03001oogoo02Aoo`03Oh1oogoo03Aoo`03Oh1oogoo04Aoo`00Y7oo00<007ooOol0
8goo00=oP7ooOol0=Woo0Wn0A7oo002TOol00`00Oomoo`0ROol00gn0Oomoo`0iOol00gn0Oomoo`11
Ool00:Aoo`03001oogoo025oo`03Oh1oogoo03]oo`9oP45oo`00Y7oo00<007ooOol08Goo00=oP7oo
Ool0?Goo00=oP7ooOol0?Woo002TOol00`00Oomoo`0POol00gn0Oomoo`0oOol00gn0Oomoo`0mOol0
0:Aoo`03001oogoo01moo`03Oh1oogoo045oo`03Oh1oogoo03aoo`00Y7oo0P007goo00=oP7ooOol0
@goo0Wn0?7oo002TOol00`00Oomoo`0NOol00gn0Oomoo`15Ool00gn0Oomoo`0iOol00:Aoo`03001o
ogoo01eoo`03Oh1oogoo04Moo`03Oh1oogoo03Qoo`00Y7oo00<007ooOol077oo00=oP7ooOol0BGoo
00=oP7ooOol0=goo002TOol00`00Oomoo`0KOol00gn0Oomoo`1;Ool00gn0Oomoo`0fOol00:Aoo`03
001oogoo01]oo`03Oh1oogoo04aoo`9oP3Ioo`00Y7oo00<007ooOol06Woo00=oP7ooOol0Cgoo00=o
P7ooOol0<goo002TOol00`00Oomoo`0JOol00gn0Oomoo`1@Ool00gn0Oomoo`0bOol00:Aoo`03001o
ogoo01Uoo`03Oh1oogoo059oo`03Oh1oogoo035oo`00Y7oo00<007ooOol06Goo00=oP7ooOol0Dgoo
00=oP7ooOol0<7oo002TOol2000IOol00gn0Oomoo`1EOol00gn0Oomoo`0_Ool00:Aoo`03001oogoo
01Qoo`03Oh1oogoo05Ioo`9oP2moo`00Y7oo00<007ooOol05goo00=oP7ooOol0FGoo00=oP7ooOol0
;7oo002TOol00`00Oomoo`0GOol00gn0Oomoo`1JOol00gn0Oomoo`0[Ool00:Aoo`03001oogoo01Io
o`03Oh1oogoo05aoo`03Oh1oogoo02Yoo`00Y7oo00<007ooOol05Woo00=oP7ooOol0GGoo00=oP7oo
Ool0:Goo002TOol00`00Oomoo`0EOol00gn0Oomoo`1OOol2Oh0YOol008Yoo`@000Eoo`8000Aoo`D0
00Ioo`03001oogoo01Eoo`03Oh1oogoo065oo`03Oh1oogoo02Ioo`00RGoo00<007ooOol00Woo00<0
07ooOol00Woo0P0017oo00D007ooOomoo`0000Ioo`03001oogoo01Aoo`03Oh1oogoo06=oo`03Oh1o
ogoo02Eoo`00RGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol057oo
00=oP7ooOol0I7oo00=oP7ooOol097oo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomo
o`06Ool3000COol00gn0Oomoo`1VOol00gn0Oomoo`0SOol008Uoo`03001oogoo009oo`03001oogoo
00]oo`03001oogoo00Eoo`03001oogoo01=oo`03Oh1oogoo06Moo`9oP2=oo`00RGoo00<007ooOol0
0Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol04Woo00=oP7ooOol0JWoo00=oP7ooOol0
87oo0029Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol04Woo
00=oP7ooOol0Jgoo00=oP7ooOol07goo002:Ool4000<Ool30007Ool00`00Oomoo`0AOol00gn0Oomo
o`1]Ool2Oh0OOol00:Aoo`03001oogoo015oo`03Oh1oogoo06moo`03Oh1oogoo01aoo`00Y7oo00<0
07ooOol047oo00=oP7ooOol0LGoo00=oP7ooOol06goo002TOol00`00Oomoo`0@Ool00gn0Oomoo`1b
Ool2Oh0KOol00:Aoo`03001oogoo00moo`03Oh1oogoo07Eoo`03Oh1oogoo01Qoo`00Y7oo00<007oo
Ool03goo00=oP7ooOol0MWoo0Wn067oo002TOol2000@Ool00gn0Oomoo`1hOol2Oh0FOol00:Aoo`03
001oogoo00ioo`03Oh1oogoo07]oo`03Oh1oogoo01=oo`00Y7oo00<007ooOol03Woo00=oP7ooOol0
O7oo0Wn04goo002TOol00`00Oomoo`0=Ool00gn0Oomoo`1oOol00gn0Oomoo`0@Ool00:Aoo`03001o
ogoo00eoo`03Oh1oogoo081oo`9oP11oo`00Y7oo00<007ooOol037oo00=oP7ooOol0Pgoo0Wn03Woo
002TOol00`00Oomoo`0<Ool00gn0Oomoo`25Ool00gn0Oomoo`0;Ool00:Aoo`03001oogoo00]oo`03
Oh1oogoo09Aoo`00Y7oo00<007ooOol02goo00=oP7ooOol0U7oo002TOol2000;Ool00gn0Oomoo`2E
Ool00:Aoo`03001oogoo00Yoo`03Oh1oogoo09Eoo`00Y7oo00<007ooOol02Goo00=oP7ooOol0UWoo
002TOol00`00Oomoo`09Ool00gn0Oomoo`2FOol00:Aoo`03001oogoo00Uoo`03Oh1oogoo09Ioo`00
Y7oo00<007ooOol027oo00=oP7ooOol0Ugoo002TOol00`00Oomoo`08Ool00gn0Oomoo`2GOol00:Ao
o`03001oogoo00Qoo`03Oh1oogoo09Moo`00Y7oo00<007ooOol01goo00=oP7ooOol0V7oo002TOol0
0`00Oomoo`07Ool00gn0Oomoo`2HOol00:Aoo`8000Qoo`03Oh1oogoo09Qoo`00Y7oo00<007ooOol0
1Woo00=oP7ooOol0VGoo002TOol00`00Oomoo`06Ool00gn0Oomoo`2IOol00:Aoo`03001oogoo00Io
o`03Oh1oogoo09Uoo`00Y7oo00<007ooOol01Goo00=oP7ooOol0VWoo002TOol00`00Oomoo`05Ool0
0gn0Oomoo`2JOol00:Aoo`03001oogoo00Eoo`03Oh1oogoo09Yoo`00RWoo10001Goo0P001goo0`00
1Goo00<007ooOol017oo00=oP7ooOol0Vgoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20008
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00gn0Oomoo`2KOol008Uoo`03001oogoo009oo`03001o
ogoo00aoo`03001oogoo00Aoo`03001oogoo00Aoo`03Oh1oogoo09]oo`00RGoo00<007ooOol00Woo
00<007ooOol027oo1P001Goo0`000goo00=oP7ooOol0W7oo0029Ool00`00Oomoo`02Ool00`00Oomo
o`09Ool01000Oomoo`001Woo00<007ooOol00goo00=oP7ooOol0W7oo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol00goo00=oP7ooOol0W7oo0029Ool00`00Oomo
o`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomoo`02Ool00gn0Oomoo`2MOol008Yoo`@0
00ioo`8000Ioo`03001oogoo009oo`03Oh1oogoo09eoo`00Y7oo00<007ooOol00Woo00=oP7ooOol0
WGoo002TOol00`00Oomoo`02Ool00gn0Oomoo`2MOol00:Aoo`05001oogooOomoP02POol00:Aoo`05
001oogooOomoP02POol00:Aoo`05001oogooOomoP02POol00:Aoo`800003OomoP7oo0:1oo`00Y7oo
00@007ooOomoP:5oo`00Y7oo00@007ooOomoP:5oo`00Y7oo00<007ooOh00XWoo002TOol00`00Oomo
P02ROol00:Aoo`03001oogn00:9oo`00Y7oo00<007n0Ool0XWoo002TOol00`00Oh1oo`2ROol00:Ao
o`03001oP7oo0:9oo`00Y7oo00=oP7ooOol0XWoo002TOol00gn0001oo`2ROol00:Aoo`03Oh1oogoo
0:9oo`00Xgoo00=oP000Ool0Xgoo002SOol00gn0001oo`2SOol00:=oo`03Oh0007oo0:=oo`00Xgoo
00=oP000Ool0Xgoo002ROol00gn0Ool0002TOol00:9oo`03Oh1oo`000:Aoo`00XWoo00=oP7oo0000
Y7oo002ROol00gn0Ool0002TOol00:9oo`04Oh1oo`00002SOol00:5oo`04Oh1oogoo002TOol00:5o
o`04Oh1oogoo002TOol00:5oo`04Oh1oogoo002TOol00:5oo`04Oh1oogoo002TOol00:5oo`04Oh1o
ogoo002TOol00:5oo`04Oh1oogoo002TOol00:1oo`05Oh1oogooOol0002TOol00:1oo`05Oh1oogoo
Ool0002TOol00:1oo`05Oh1oogooOol0002TOol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.8 1 0 r
.5 Mabswid
.47525 .61803 m
.49955 .52559 L
.53984 .41004 L
.57861 .33145 L
.59975 .30064 L
.61984 .27845 L
.62942 .27014 L
.63964 .2628 L
.64922 .2573 L
.65803 .25334 L
.66293 .25159 L
.66831 .25002 L
.67372 .2488 L
.67668 .24828 L
.67944 .24789 L
.68205 .24761 L
.68334 .2475 L
.68453 .24741 L
.68559 .24735 L
.68676 .24729 L
.68793 .24725 L
.68917 .24722 L
.68983 .24722 L
.69053 .24721 L
.69176 .24722 L
.69246 .24723 L
.6931 .24725 L
.6938 .24727 L
.69456 .2473 L
.69592 .24737 L
.6972 .24746 L
.69961 .24766 L
.702 .24792 L
.70424 .24822 L
.70933 .24907 L
.71429 .25015 L
.71962 .25156 L
.73808 .25833 L
.75925 .26927 L
.77935 .28224 L
.8176 .31179 L
.8583 .34663 L
.89748 .37925 L
.91749 .39421 L
.93911 .40825 L
.97619 .42521 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OooJ0005In1Q0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Eoo`IWh004Ool007ooOol6In06Ool00`00
Oomoo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00
Oomoo`0;Ool000aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo009o
o`=Wh0Moo`03001oogoo00Ioo`=Wh0=oo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00Y7oo00<007ooOol0;Goo0VOP5Woo
0VOPFgoo002TOol00`00Oomoo`0[Ool2In0JOol3In1HOol00:Aoo`03001oogoo02Uoo`9Wh1moo`9W
h5Ioo`00Y7oo00<007ooOol0:7oo00=Wh7ooOol08Goo0VOPE7oo002TOol00`00Oomoo`0WOol00fOP
Oomoo`0TOol2In1BOol00:Aoo`03001oogoo02Ioo`03In1oogoo02Moo`9Wh51oo`00Y7oo00<007oo
Ool097oo0VOP;7oo00=Wh7ooOol0CGoo002TOol2000TOol00fOPOomoo`0]Ool00fOPOomoo`1<Ool0
0:Aoo`03001oogoo029oo`03In1oogoo02moo`9Wh4aoo`00Y7oo00<007ooOol08Goo00=Wh7ooOol0
<Woo00=Wh7ooOol0BGoo002TOol00`00Oomoo`0POol00fOPOomoo`0dOol00fOPOomoo`18Ool00:Ao
o`03001oogoo01moo`03In1oogoo03Ioo`9Wh4Qoo`00Y7oo00<007ooOol07Woo00=Wh7ooOol0>Goo
00=Wh7ooOol0AGoo002TOol00`00Oomoo`0MOol00fOPOomoo`0kOol00fOPOomoo`14Ool00:Aoo`03
001oogoo01aoo`03In1oogoo03eoo`9Wh4Aoo`00Y7oo00<007ooOol06goo00=Wh7ooOol0@7oo00=W
h7ooOol0@Goo002TOol00`00Oomoo`0KOol00fOPOomoo`11Ool00fOPOomoo`10Ool00:Aoo`8001]o
o`03In1oogoo04=oo`9Wh41oo`00Y7oo00<007ooOol06Woo00=Wh7ooOol0AGoo00=Wh7ooOol0?Goo
002TOol00`00Oomoo`0IOol00fOPOomoo`17Ool00fOPOomoo`0lOol00:Aoo`03001oogoo01Qoo`03
In1oogoo04Uoo`03In1oogoo03]oo`00Y7oo00<007ooOol067oo00=Wh7ooOol0BWoo0VOP>goo002T
Ool00`00Oomoo`0GOol00fOPOomoo`1=Ool00fOPOomoo`0hOol00:Aoo`03001oogoo01Moo`03In1o
ogoo04ioo`03In1oogoo03Moo`00Y7oo00<007ooOol05Woo00=Wh7ooOol0D7oo00=Wh7ooOol0=Woo
002TOol00`00Oomoo`0EOol00fOPOomoo`1BOol00fOPOomoo`0eOol00:Aoo`03001oogoo01Eoo`03
In1oogoo05=oo`9Wh3Eoo`00Y7oo0P005Goo00=Wh7ooOol0EWoo00=Wh7ooOol0<Woo002TOol00`00
Oomoo`0DOol00fOPOomoo`1GOol00fOPOomoo`0aOol00:Aoo`03001oogoo01=oo`03In1oogoo05Uo
o`03In1oogoo031oo`00Y7oo00<007ooOol04goo00=Wh7ooOol0FWoo00=Wh7ooOol0;goo002TOol0
0`00Oomoo`0BOol00fOPOomoo`1LOol00fOPOomoo`0^Ool00:Aoo`03001oogoo019oo`03In1oogoo
05eoo`9Wh2ioo`00Y7oo00<007ooOol04Goo00=Wh7ooOol0H7oo00=Wh7ooOol0:goo002:Ool40005
Ool20004Ool50006Ool00`00Oomoo`0AOol00fOPOomoo`1QOol00fOPOomoo`0ZOol008Uoo`03001o
ogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomoo`0@Ool00fOPOomo
o`1SOol00fOPOomoo`0YOol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03
001oogoo011oo`03In1oogoo06Aoo`03In1oogoo02Qoo`00RGoo00<007ooOol00Woo00<007ooOol0
2Woo00<007ooOol01Woo0`003goo00=Wh7ooOol0IWoo0VOP:7oo0029Ool00`00Oomoo`02Ool00`00
Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool00fOPOomoo`1XOol00fOPOomoo`0UOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo00ioo`03In1oogoo06Yo
o`03In1oogoo02Aoo`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03
001oogoo00ioo`03In1oogoo06]oo`9Wh2Aoo`00RWoo100037oo0`001goo00<007ooOol03Goo00=W
h7ooOol0KWoo00=Wh7ooOol08Goo002TOol00`00Oomoo`0=Ool00fOPOomoo`1_Ool00fOPOomoo`0P
Ool00:Aoo`03001oogoo00aoo`03In1oogoo075oo`9Wh21oo`00Y7oo00<007ooOol037oo00=Wh7oo
Ool0Lgoo00=Wh7ooOol07Goo002TOol00`00Oomoo`0;Ool00fOPOomoo`1eOol00fOPOomoo`0LOol0
0:Aoo`03001oogoo00]oo`03In1oogoo07Ioo`03In1oogoo01]oo`00Y7oo0P002goo00=Wh7ooOol0
N7oo0VOP6goo002TOol00`00Oomoo`0:Ool00fOPOomoo`1jOol00fOPOomoo`0HOol00:Aoo`03001o
ogoo00Uoo`03In1oogoo07aoo`9Wh1Qoo`00Y7oo00<007ooOol02Goo00=Wh7ooOol0OWoo0VOP5Woo
002TOol00`00Oomoo`08Ool00fOPOomoo`21Ool2In0DOol00:Aoo`03001oogoo00Qoo`03In1oogoo
08=oo`=Wh15oo`00Y7oo00<007ooOol027oo00=Wh7ooOol0QWoo0VOP3goo002TOol00`00Oomoo`07
Ool00fOPOomoo`29Ool2In0=Ool00:Aoo`03001oogoo00Moo`03In1oogoo09Qoo`00Y7oo0P0027oo
00=Wh7ooOol0V7oo002TOol00`00Oomoo`06Ool00fOPOomoo`2IOol00:Aoo`03001oogoo00Ioo`03
In1oogoo09Uoo`00Y7oo00<007ooOol01Goo00=Wh7ooOol0VWoo002TOol00`00Oomoo`05Ool00fOP
Oomoo`2JOol00:Aoo`03001oogoo00Eoo`03In1oogoo09Yoo`00Y7oo00<007ooOol017oo00=Wh7oo
Ool0Vgoo002TOol00`00Oomoo`04Ool00fOPOomoo`2KOol00:Aoo`03001oogoo00Aoo`03In1oogoo
09]oo`00Y7oo00<007ooOol00goo00=Wh7ooOol0W7oo002TOol20004Ool00fOPOomoo`2LOol00:Ao
o`03001oogoo00=oo`03In1oogoo09aoo`00Y7oo00<007ooOol00Woo00=Wh7ooOol0WGoo002TOol0
0`00Oomoo`02Ool00fOPOomoo`2MOol00:Aoo`03001oogoo009oo`03In1oogoo09eoo`00Y7oo00D0
07ooOomoofOP0:1oo`00Y7oo00D007ooOomoofOP0:1oo`00RWoo10001Goo0P001goo0`001Goo00D0
07ooOomoofOP0:1oo`00RGoo00<007ooOol00Woo00<007ooOol00Woo0P0027oo00<007ooOol017oo
00@007ooOomWh:5oo`00RGoo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00@007oo
OomWh:5oo`00RGoo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`0000=Wh7ooOol0Wgoo0029
Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooIn00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooIn00XWoo0029Ool00`00Oomoo`02
Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00In1oo`2ROol008Yoo`@000ioo`8000Ioo`03001W
h7oo0:9oo`00Y7oo00<006OPOol0XWoo002TOol00fOPOomoo`2ROol00:Aoo`03In1oogoo0:9oo`00
Y7oo00=Wh7ooOol0XWoo002SOol00fOP001oo`2SOol00:=oo`03In0000000:=oo`00Xgoo00=Wh000
Ool0Xgoo002SOol00fOP001oo`2SOol00:9oo`03In1oo`000:Aoo`00XWoo00=Wh7oo0000Y7oo002R
Ool00fOPOol0002TOol00:9oo`03In1oo`000:Aoo`00XGoo00AWh7ooOol00:Aoo`00XGoo00AWh7oo
Ool00:Aoo`00XGoo00AWh7ooOol00:Aoo`00XGoo00=Wh7ooOol00P00Xgoo002POol01FOPOomoogoo
0000Y7oo002POol01FOPOomoogoo0000Y7oo002POol01FOPOomoogoo0000Y7oo002POol01FOPOomo
ogoo0000Y7oo002OOol00fOPOomoo`02Ool00`00Oomoo`2ROol009moo`03In1oogoo009oo`03001o
ogoo0:9oo`00Wgoo00=Wh7ooOol00Woo00<007ooOol0XWoo002OOol00fOPOomoo`02Ool00`00Oomo
o`2ROol009ioo`03In1oogoo00=oo`03001oogoo0:9oo`00WWoo00=Wh7ooOol00goo0P00Xgoo002N
Ool00fOPOomoo`03Ool00`00Oomoo`2ROol009ioo`03In1oogoo00=oo`03001oogoo0:9oo`00WGoo
00=Wh7ooOol017oo00<007ooOol0XWoo002MOol00fOPOomoo`04Ool00`00Oomoo`2ROol009eoo`03
In1oogoo00Aoo`03001oogoo0:9oo`00WGoo00=Wh7ooOol017oo00<007ooOol0XWoo002LOol00fOP
Oomoo`05Ool00`00Oomoo`2ROol009aoo`03In1oogoo00Eoo`03001oogoo0:9oo`00W7oo00=Wh7oo
Ool01Goo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 1 0 r
.5 Mabswid
.46236 .61803 m
.49955 .48759 L
.52059 .4284 L
.53984 .38269 L
.57861 .31311 L
.5976 .28903 L
.60847 .27795 L
.61832 .26951 L
.62777 .26278 L
.63799 .25695 L
.64362 .25436 L
.64879 .25235 L
.6537 .25076 L
.65897 .2494 L
.66406 .2484 L
.6687 .24776 L
.67094 .24754 L
.67212 .24744 L
.67337 .24736 L
.67446 .24731 L
.67566 .24726 L
.67676 .24723 L
.67779 .24722 L
.679 .24721 L
.68032 .24723 L
.68098 .24725 L
.68169 .24727 L
.68298 .24732 L
.68426 .24739 L
.68547 .24747 L
.68773 .24766 L
.69041 .24796 L
.69288 .2483 L
.69845 .24928 L
.70815 .25169 L
.71722 .25469 L
.73786 .26399 L
.75814 .27596 L
.77668 .28887 L
.81644 .32083 L
.85469 .35376 L
.89538 .38679 L
.93457 .4124 L
.94487 .4176 L
.95601 .42234 L
.96653 .42588 L
.97619 .42828 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OooF0006?n1T0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo009oo`Doh0Aoo`Hoh0Yoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]o
o`0037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007oo
Ool03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007oo?n000SoP2Woo00<0
07ooOol00Woo0coP1goo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol02goo002TOol00`00Oomoo`0ZOol2?n0EOol2?n1OOol00:Ao
o`03001oogoo02Qoo`8oh1Uoo`8oh5eoo`00Y7oo00<007ooOol09Goo0coP7Goo0SoPFgoo002TOol0
0`00Oomoo`0TOol00coPOomoo`0POol2?n1IOol00:Aoo`03001oogoo02=oo`03?n1oogoo02=oo`8o
h5Moo`00Y7oo00<007ooOol08Woo00<oh7ooOol09Woo0SoPEGoo002TOol00`00Oomoo`0POol2?n0[
Ool2?n1COol00:Aoo`80021oo`03?n1oogoo02eoo`03?n1oogoo051oo`00Y7oo00<007ooOol07Woo
00<oh7ooOol0;goo0SoPD7oo002TOol00`00Oomoo`0MOol00coPOomoo`0bOol00coPOomoo`1=Ool0
0:Aoo`03001oogoo01eoo`03?n1oogoo03=oo`8oh4eoo`00Y7oo00<007ooOol077oo00<oh7ooOol0
=Woo00<oh7ooOol0BWoo002TOol00`00Oomoo`0KOol00coPOomoo`0hOol00coPOomoo`19Ool00:Ao
o`03001oogoo01Yoo`03?n1oogoo03Yoo`03?n1oogoo04Qoo`00Y7oo00<007ooOol06Goo00<oh7oo
Ool0?7oo0SoPB7oo002TOol00`00Oomoo`0IOol00coPOomoo`0nOol00coPOomoo`15Ool00:Aoo`03
001oogoo01Qoo`03?n1oogoo041oo`03?n1oogoo04Aoo`00Y7oo0P0067oo00<oh7ooOol0@Woo00<o
h7ooOol0@goo002TOol00`00Oomoo`0FOol00coPOomoo`14Ool00coPOomoo`12Ool00:Aoo`03001o
ogoo01Eoo`03?n1oogoo04Ioo`8oh49oo`00Y7oo00<007ooOol05Goo00<oh7ooOol0B7oo00<oh7oo
Ool0?goo002TOol00`00Oomoo`0DOol00coPOomoo`1:Ool00coPOomoo`0nOol00:Aoo`03001oogoo
01Aoo`03?n1oogoo04]oo`03?n1oogoo03eoo`00Y7oo00<007ooOol04goo00<oh7ooOol0CGoo0SoP
?Goo002TOol00`00Oomoo`0COol00coPOomoo`1?Ool00coPOomoo`0jOol00:Aoo`03001oogoo019o
o`03?n1oogoo055oo`03?n1oogoo03Uoo`00Y7oo00<007ooOol04Goo00<oh7ooOol0Dgoo0SoP>Goo
002TOol2000BOol00coPOomoo`1EOol00coPOomoo`0fOol00:Aoo`03001oogoo011oo`03?n1oogoo
05Moo`03?n1oogoo03Eoo`00Y7oo00<007ooOol047oo00<oh7ooOol0F7oo0SoP=Goo002TOol00`00
Oomoo`0?Ool00coPOomoo`1KOol00coPOomoo`0bOol00:Aoo`03001oogoo00moo`03?n1oogoo05ao
o`03?n1oogoo035oo`00Y7oo00<007ooOol03Woo00<oh7ooOol0GWoo00<oh7ooOol0<7oo002TOol0
0`00Oomoo`0>Ool00coPOomoo`1OOol00coPOomoo`0_Ool008Yoo`@000Eoo`8000Aoo`D000Ioo`03
001oogoo00eoo`03?n1oogoo065oo`8oh2moo`00RGoo00<007ooOol00Woo00<007ooOol00Woo0P00
17oo00D007ooOomoo`0000Ioo`03001oogoo00aoo`03?n1oogoo06Aoo`03?n1oogoo02aoo`00RGoo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol037oo00<oh7ooOol0IGoo
00<oh7ooOol0:goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool3000;Ool0
0coPOomoo`1WOol00coPOomoo`0ZOol008Uoo`03001oogoo009oo`03001oogoo00]oo`03001oogoo
00Eoo`03001oogoo00]oo`03?n1oogoo06Qoo`03?n1oogoo02Uoo`00RGoo00<007ooOol00Woo00<0
07ooOol037oo00<007ooOol017oo00<007ooOol02Woo00<oh7ooOol0JWoo0SoP:Goo0029Ool00`00
Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol02Woo00<oh7ooOol0K7oo
00<oh7ooOol09Woo002:Ool4000<Ool30007Ool00`00Oomoo`09Ool00coPOomoo`1^Ool00coPOomo
o`0UOol00:Aoo`03001oogoo00Uoo`03?n1oogoo06moo`03?n1oogoo02Aoo`00Y7oo00<007ooOol0
27oo00<oh7ooOol0LGoo0SoP97oo002TOol00`00Oomoo`08Ool00coPOomoo`1cOol00coPOomoo`0Q
Ool00:Aoo`03001oogoo00Moo`03?n1oogoo07Eoo`8oh25oo`00Y7oo00<007ooOol01goo00<oh7oo
Ool0Mgoo00<oh7ooOol07Woo002TOol20007Ool00coPOomoo`1iOol2?n0NOol00:Aoo`03001oogoo
00Ioo`03?n1oogoo07]oo`03?n1oogoo01]oo`00Y7oo00<007ooOol01Woo00<oh7ooOol0O7oo0SoP
6goo002TOol00`00Oomoo`05Ool00coPOomoo`1oOol00coPOomoo`0HOol00:Aoo`03001oogoo00Eo
o`03?n1oogoo081oo`8oh1Qoo`00Y7oo00<007ooOol017oo00<oh7ooOol0Pgoo0SoP5Woo002TOol0
0`00Oomoo`04Ool00coPOomoo`25Ool4?n0BOol00:Aoo`03001oogoo00=oo`03?n1oogoo08Yoo`<o
h0moo`00Y7oo00<007ooOol00goo00<oh7ooOol0SGoo0SoP3Goo002TOol20004Ool00coPOomoo`2L
Ool00:Aoo`03001oogoo009oo`03?n1oogoo09eoo`00Y7oo00<007ooOol00Woo00<oh7ooOol0WGoo
002TOol00`00Oomoo`02Ool00coPOomoo`2MOol00:Aoo`05001oogooOoloh02POol00:Aoo`05001o
ogooOoloh02POol00:Aoo`04001oogoo?n2QOol00:Aoo`04001oogoo?n2QOol00:Aoo`04001oogoo
?n2QOol00:Aoo`03001oocoP0:9oo`00Y7oo0P0000<oh7ooOol0X7oo002TOol00`00Ooloh02ROol0
0:Aoo`03000oh7oo0:9oo`00Y7oo00<003oPOol0XWoo002TOol00coPOomoo`2ROol00:Aoo`03?n1o
ogoo0:9oo`00Y7oo00<oh7ooOol0XWoo002:Ool40005Ool20007Ool30004Ool00coP001oo`2SOol0
08Uoo`03001oogoo009oo`03001oogoo009oo`8000Qoo`03001oogoo00=oo`03?n0007oo0:=oo`00
RGoo00<007ooOol00Woo00<007ooOol037oo00<007ooOol00goo00<oh000Ool0Xgoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`08Ool60003Ool00coPOol00002002ROol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`04001oogoo0004Ool00coPOol0002TOol008Uoo`03001oogoo009oo`03001oogoo
00Uoo`04001oogoo0004Ool00coPOol0002TOol008Uoo`03001oogoo009oo`03001oogoo00Yoo`03
001oo`0000Aoo`03?n1oo`000:Aoo`00RWoo10003Woo0P000goo00@oh7ooOol00:Aoo`00XGoo00@o
h7ooOol00:Aoo`00XGoo00@oh7ooOol00:Aoo`00XGoo00@oh7ooOol00:Aoo`00X7oo00Doh7ooOomo
o`000:Aoo`00X7oo00Doh7ooOomoo`000:Aoo`00X7oo00@oh7ooOomoo`800:=oo`00X7oo00Doh7oo
Oomoo`000:Aoo`00Wgoo00<oh7ooOol00Woo00<007ooOol0XWoo002OOol00coPOomoo`02Ool00`00
Oomoo`2ROol009moo`03?n1oogoo009oo`03001oogoo0:9oo`00WWoo00<oh7ooOol00goo00<007oo
Ool0XWoo002NOol00coPOomoo`03Ool00`00Oomoo`2ROol009ioo`03?n1oogoo00=oo`03001oogoo
0:9oo`00WWoo00<oh7ooOol00goo00<007ooOol0XWoo002MOol00coPOomoo`04Ool00`00Oomoo`2R
Ool009eoo`03?n1oogoo00Aoo`800:=oo`00WGoo00<oh7ooOol017oo00<007ooOol0XWoo002MOol0
0coPOomoo`04Ool00`00Oomoo`2ROol009aoo`03?n1oogoo00Eoo`03001oogoo0:9oo`00W7oo00<o
h7ooOol01Goo00<007ooOol0XWoo002LOol00coPOomoo`05Ool00`00Oomoo`2ROol009]oo`03?n1o
ogoo00Ioo`03001oogoo0:9oo`00Vgoo00<oh7ooOol01Woo00<007ooOol0XWoo002KOol00coPOomo
o`06Ool00`00Oomoo`2ROol009]oo`03?n1oogoo00Ioo`03001oogoo0:9oo`00VWoo00<oh7ooOol0
1goo0P00Xgoo002JOol00coPOomoo`07Ool00`00Oomoo`2ROol009Yoo`03?n1oogoo00Moo`03001o
ogoo0:9oo`00VWoo00<oh7ooOol01goo00<007ooOol0XWoo002IOol00coPOomoo`08Ool00`00Oomo
o`2ROol009Uoo`03?n1oogoo00Qoo`03001oogoo0:9oo`00VGoo00<oh7ooOol027oo00<007ooOol0
XWoo002IOol00coPOomoo`08Ool00`00Oomoo`2ROol009Qoo`03?n1oogoo00Uoo`03001oogoo0:9o
o`00V7oo00<oh7ooOol02Goo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 1 0 r
.5 Mabswid
.45137 .61803 m
.46172 .57473 L
.49955 .45287 L
.52059 .39921 L
.53984 .35825 L
.55994 .32321 L
.57861 .2973 L
.5976 .27699 L
.60827 .26808 L
.61832 .26125 L
.62818 .25594 L
.63336 .25368 L
.63884 .25168 L
.64346 .25029 L
.64853 .24907 L
.65314 .24824 L
.65523 .24794 L
.65745 .24769 L
.65869 .24757 L
.66005 .24746 L
.6613 .24737 L
.66246 .24731 L
.66381 .24726 L
.66452 .24724 L
.66526 .24722 L
.66652 .24721 L
.66724 .24722 L
.6679 .24722 L
.66919 .24725 L
.67041 .24729 L
.6715 .24734 L
.67269 .24741 L
.67535 .24762 L
.6778 .24787 L
.68209 .24847 L
.68682 .24933 L
.69636 .25172 L
.70652 .25515 L
.71581 .25902 L
.7367 .27002 L
.77646 .29777 L
.8147 .32954 L
.8554 .36443 L
.89458 .39485 L
.9146 .40783 L
.92512 .41371 L
.93622 .41908 L
.94616 .4231 L
.95705 .42657 L
.96183 .42775 L
Mistroke
.96695 .42879 L
.96944 .4292 L
.97179 .42953 L
.97619 .43 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OooC00055n1X0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`HGh0Aoo`HGh0ioo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`0037oo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol02Goo0aOP00<007ooOol037oo00@001OP5n0Gh0]oo`03
001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00]oo`00Y7oo00<007ooOol09Goo0QOP5Woo0aOPHWoo002TOol00`00Oomoo`0SOol25n0K
Ool25n1POol00:Aoo`03001oogoo029oo`035n1oogoo01eoo`8Gh5ioo`00Y7oo00<007ooOol087oo
0QOP8Woo0QOPG7oo002TOol00`00Oomoo`0OOol00aOPOomoo`0TOol25n1JOol00:Aoo`03001oogoo
01ioo`035n1oogoo02Moo`035n1oogoo05Moo`00Y7oo00<007ooOol07Goo00<Gh7ooOol0:Goo0QOP
Egoo002TOol2000MOol00aOPOomoo`0/Ool00aOPOomoo`1DOol00:Aoo`03001oogoo01]oo`035n1o
ogoo02ioo`8Gh5Aoo`00Y7oo00<007ooOol06Woo00<Gh7ooOol0<Goo00<Gh7ooOol0DGoo002TOol0
0`00Oomoo`0IOol00aOPOomoo`0cOol00aOPOomoo`1@Ool00:Aoo`03001oogoo01Qoo`035n1oogoo
03Eoo`8Gh51oo`00Y7oo00<007ooOol05goo00<Gh7ooOol0>7oo00<Gh7ooOol0CGoo002TOol00`00
Oomoo`0FOol00aOPOomoo`0jOol25n1=Ool00:Aoo`03001oogoo01Eoo`035n1oogoo03eoo`035n1o
ogoo04Yoo`00Y7oo00<007ooOol05Goo00<Gh7ooOol0?Woo00<Gh7ooOol0BGoo002TOol00`00Oomo
o`0DOol00aOPOomoo`10Ool00aOPOomoo`18Ool00:Aoo`8001Aoo`035n1oogoo049oo`8Gh4Qoo`00
Y7oo00<007ooOol04goo00<Gh7ooOol0A7oo00<Gh7ooOol0AGoo002TOol00`00Oomoo`0BOol00aOP
Oomoo`16Ool00aOPOomoo`14Ool00:Aoo`03001oogoo015oo`035n1oogoo04Qoo`035n1oogoo04=o
o`00Y7oo00<007ooOol04Goo00<Gh7ooOol0BGoo00<Gh7ooOol0@Woo002TOol00`00Oomoo`0@Ool0
0aOPOomoo`1;Ool25n12Ool00:Aoo`03001oogoo00moo`035n1oogoo04ioo`035n1oogoo03moo`00
Y7oo00<007ooOol03goo00<Gh7ooOol0Cgoo00<Gh7ooOol0?Woo002TOol00`00Oomoo`0>Ool00aOP
Oomoo`1AOol00aOPOomoo`0mOol00:Aoo`03001oogoo00eoo`035n1oogoo05=oo`035n1oogoo03ao
o`00Y7oo0P003Woo00<Gh7ooOol0E7oo0QOP?7oo002TOol00`00Oomoo`0<Ool00aOPOomoo`1GOol0
0aOPOomoo`0iOol00:Aoo`03001oogoo00aoo`035n1oogoo05Qoo`035n1oogoo03Qoo`00Y7oo00<0
07ooOol02goo00<Gh7ooOol0FWoo00<Gh7ooOol0=goo002TOol00`00Oomoo`0:Ool00aOPOomoo`1L
Ool00aOPOomoo`0fOol00:Aoo`03001oogoo00Yoo`035n1oogoo05eoo`8Gh3Ioo`00Y7oo00<007oo
Ool02Goo00<Gh7ooOol0H7oo00<Gh7ooOol0<goo002:Ool40005Ool20004Ool50006Ool00`00Oomo
o`09Ool00aOPOomoo`1QOol00aOPOomoo`0bOol008Uoo`03001oogoo009oo`03001oogoo009oo`80
00Aoo`05001oogooOol00006Ool00`00Oomoo`08Ool00aOPOomoo`1SOol00aOPOomoo`0aOol008Uo
o`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo00Qoo`035n1oogoo06Ao
o`035n1oogoo031oo`00RGoo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`001goo
00<Gh7ooOol0IWoo0QOP<7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool0
0`00Oomoo`07Ool00aOPOomoo`1XOol00aOPOomoo`0]Ool008Uoo`03001oogoo009oo`03001oogoo
00aoo`03001oogoo00Aoo`03001oogoo00Ioo`035n1oogoo06Yoo`035n1oogoo02aoo`00RGoo00<0
07ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo00Ioo`035n1oogoo06]o
o`8Gh2aoo`00RWoo100037oo0`001goo00<007ooOol01Goo00<Gh7ooOol0KWoo00<Gh7ooOol0:Goo
002TOol00`00Oomoo`05Ool00aOPOomoo`1_Ool00aOPOomoo`0XOol00:Aoo`03001oogoo00Aoo`03
5n1oogoo075oo`8Gh2Qoo`00Y7oo00<007ooOol017oo00<Gh7ooOol0Lgoo00<Gh7ooOol09Goo002T
Ool00`00Oomoo`03Ool00aOPOomoo`1eOol25n0UOol00:Aoo`03001oogoo00=oo`035n1oogoo07Mo
o`035n1oogoo029oo`00Y7oo0P0017oo00<Gh7ooOol0N7oo00<Gh7ooOol08Goo002TOol00`00Oomo
o`02Ool00aOPOomoo`1jOol25n0QOol00:Aoo`03001oogoo009oo`035n1oogoo07aoo`8Gh1moo`00
Y7oo00D007ooOomooaOP085oo`8Gh1eoo`00Y7oo00D007ooOomooaOP08=oo`8Gh1]oo`00Y7oo00D0
07ooOomooaOP08Eoo`<Gh1Qoo`00Y7oo00@007ooOolGh8Uoo`8Gh1Ioo`00Y7oo00@007ooOolGh8]o
o`8Gh1Aoo`00Y7oo00<007oo5n00SWoo1QOP3Woo002TOol200000aOPOomoo`2BOol00aOPOomoo`0;
Ool00:Aoo`03000Gh7oo0:9oo`00Y7oo00<001OPOol0XWoo002TOol00`005n1oo`2ROol00:Aoo`03
5n1oogoo0:9oo`00Y7oo00<Gh7ooOol0XWoo002SOol00aOP001oo`2SOol00:=oo`035n0007oo0:=o
o`00Xgoo00<Gh000Ool0Xgoo002ROol00aOPOol0002TOol00:9oo`045n1oo`00002SOol00:9oo`03
5n1oo`000:Aoo`00XGoo00@Gh7ooOol00:Aoo`00XGoo00@Gh7ooOol00:Aoo`00XGoo00@Gh7ooOol0
0:Aoo`00XGoo00@Gh7ooOol00:Aoo`00X7oo00DGh7ooOomoo`000:Aoo`00RWoo10001Goo0P001goo
0`0000=ooaOPOol00Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20008
Ool01000OomooaOP0goo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00
OolGh004Ool00`00Oomoo`2ROol008Uoo`03001oogoo009oo`03001oogoo00Qoo`H000035n1oogoo
009oo`<00:9oo`00RGoo00<007ooOol00Woo00<007ooOol02Goo00H007ooOol007oo5n04Ool00`00
Oomoo`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`05001oogoo000Gh005Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Yoo`04001oo`005n05Ool00`00Oomoo`2ROol0
08Yoo`@000ioo`8000035n1oogoo00=oo`03001oogoo0:9oo`00WGoo00<Gh7ooOol017oo00<007oo
Ool0XWoo002MOol00aOPOomoo`04Ool00`00Oomoo`2ROol009eoo`035n1oogoo00Aoo`03001oogoo
0:9oo`00WGoo00<Gh7ooOol017oo00<007ooOol0XWoo002LOol00aOPOomoo`05Ool00`00Oomoo`2R
Ool009aoo`035n1oogoo00Eoo`800:=oo`00W7oo00<Gh7ooOol01Goo00<007ooOol0XWoo002KOol0
0aOPOomoo`06Ool00`00Oomoo`2ROol009]oo`035n1oogoo00Ioo`03001oogoo0:9oo`00Vgoo00<G
h7ooOol01Woo00<007ooOol0XWoo002JOol00aOPOomoo`07Ool00`00Oomoo`2ROol009Yoo`035n1o
ogoo00Moo`03001oogoo0:9oo`00VWoo00<Gh7ooOol01goo00<007ooOol0XWoo002IOol00aOPOomo
o`08Ool00`00Oomoo`2ROol009Uoo`035n1oogoo00Qoo`03001oogoo0:9oo`00VGoo00<Gh7ooOol0
27oo0P00Xgoo002IOol00aOPOomoo`08Ool00`00Oomoo`2ROol009Qoo`035n1oogoo00Uoo`03001o
ogoo0:9oo`00V7oo00<Gh7ooOol02Goo00<007ooOol0XWoo002HOol00aOPOomoo`09Ool00`00Oomo
o`2ROol009Moo`035n1oogoo00Yoo`03001oogoo0:9oo`00Ugoo00<Gh7ooOol02Woo00<007ooOol0
XWoo002GOol00aOPOomoo`0:Ool00`00Oomoo`2ROol009Moo`035n1oogoo00Yoo`03001oogoo0:9o
o`00UWoo00<Gh7ooOol02goo00<007ooOol0XWoo002FOol00aOPOomoo`0;Ool2002SOol009Ioo`03
5n1oogoo00]oo`03001oogoo0:9oo`00UWoo00<Gh7ooOol02goo00<007ooOol0XWoo002EOol00aOP
Oomoo`0<Ool00`00Oomoo`2ROol009Eoo`035n1oogoo00aoo`03001oogoo0:9oo`00UGoo00<Gh7oo
Ool037oo00<007ooOol0XWoo002EOol00aOPOomoo`0<Ool00`00Oomoo`2ROol009Aoo`035n1oogoo
00eoo`03001oogoo0:9oo`00U7oo00<Gh7ooOol03Goo00<007ooOol0XWoo002DOol00aOPOomoo`0=
Ool00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 .1 r
.5 Mabswid
.43971 .61803 m
.46172 .53271 L
.49955 .42133 L
.52059 .37299 L
.53984 .33658 L
.55994 .30598 L
.57861 .28388 L
.5976 .26717 L
.60763 .26052 L
.61832 .25501 L
.62861 .25115 L
.6344 .24957 L
.63973 .24848 L
.64199 .24813 L
.64441 .24781 L
.64706 .24754 L
.64835 .24744 L
.64954 .24736 L
.65087 .2473 L
.65158 .24727 L
.65232 .24725 L
.65358 .24722 L
.65429 .24721 L
.65496 .24721 L
.6562 .24722 L
.65734 .24725 L
.65859 .24729 L
.6599 .24736 L
.66114 .24743 L
.66247 .24753 L
.6649 .24776 L
.66945 .24835 L
.67475 .2493 L
.67964 .25041 L
.68856 .253 L
.69801 .25648 L
.71758 .26589 L
.7359 .27698 L
.77472 .3059 L
.816 .34094 L
.85576 .37448 L
.894 .40246 L
.91372 .41397 L
.9347 .42327 L
.94498 .42652 L
.95076 .42794 L
.95608 .42896 L
.96075 .42963 L
.9634 .42992 L
.96587 .43012 L
Mistroke
.96721 .4302 L
.96848 .43026 L
.96961 .4303 L
.97085 .43032 L
.97149 .43033 L
.9722 .43033 L
.97294 .43033 L
.97363 .43032 L
.97486 .4303 L
.97556 .43027 L
.97619 .43025 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Ooo?00050n9/0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00Uoo`D3hPAoo`P3hP03Ool007oo00eoo`03001oogoo00eoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
3Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol01goo0P?R0goo00<007ooOol02goo0`?R
3Goo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol02goo002TOol00`00Oomoo`0ROol30n8FOol20n9UOol00:Aoo`03001oogoo021o
o`83hQ]oo`83hV=oo`00Y7oo00<007ooOol07goo00<3hWooOol07Goo0P?RHGoo002TOol00`00Oomo
o`0MOol20n8ROol20n9OOol00:Aoo`03001oogoo01aoo`030n9oogoo02Aoo`83hUeoo`00Y7oo00<0
07ooOol06goo00<3hWooOol09goo00<3hWooOol0FWoo002TOol00`00Oomoo`0JOol00`?ROomoo`0Y
Ool20n9JOol00:Aoo`8001Uoo`83hRioo`030n9oogoo05Moo`00Y7oo00<007ooOol05goo00<3hWoo
Ool0;goo00<3hWooOol0EWoo002TOol00`00Oomoo`0FOol00`?ROomoo`0aOol20n9FOol00:Aoo`03
001oogoo01Eoo`030n9oogoo03Aoo`030n9oogoo05=oo`00Y7oo00<007ooOol057oo00<3hWooOol0
=Woo00<3hWooOol0DWoo002TOol00`00Oomoo`0COol00`?ROomoo`0hOol20n9BOol00:Aoo`03001o
ogoo01=oo`030n9oogoo03Yoo`030n9oogoo04moo`00Y7oo00<007ooOol04Woo00<3hWooOol0?7oo
00<3hWooOol0CWoo002TOol00`00Oomoo`0AOol00`?ROomoo`0nOol20n9>Ool00:Aoo`03001oogoo
011oo`030n9oogoo045oo`030n9oogoo04]oo`00Y7oo0P0047oo00<3hWooOol0@goo00<3hWooOol0
BWoo002TOol00`00Oomoo`0?Ool00`?ROomoo`14Ool00`?ROomoo`19Ool00:Aoo`03001oogoo00io
o`030n9oogoo04Ioo`83hTUoo`00Y7oo00<007ooOol03Goo00<3hWooOol0BGoo00<3hWooOol0AWoo
002TOol00`00Oomoo`0<Ool00`?ROomoo`1;Ool00`?ROomoo`15Ool00:Aoo`03001oogoo00aoo`03
0n9oogoo04aoo`030n9oogoo04Aoo`00Y7oo00<007ooOol02goo00<3hWooOol0CWoo00<3hWooOol0
@goo002TOol00`00Oomoo`0:Ool00`?ROomoo`1@Ool20n93Ool00:Aoo`03001oogoo00Yoo`030n9o
ogoo059oo`030n9oogoo041oo`00Y7oo00<007ooOol02Goo00<3hWooOol0E7oo00<3hWooOol0?goo
002TOol20009Ool00`?ROomoo`1FOol00`?ROomoo`0nOol00:Aoo`03001oogoo00Qoo`030n9oogoo
05Moo`030n9oogoo03eoo`00Y7oo00<007ooOol01goo00<3hWooOol0FGoo00<3hWooOol0?7oo002T
Ool00`00Oomoo`07Ool00`?ROomoo`1JOol20n8lOol00:Aoo`03001oogoo00Ioo`030n9oogoo05eo
o`030n9oogoo03Uoo`00Y7oo00<007ooOol01Woo00<3hWooOol0GWoo00<3hWooOol0>7oo002TOol0
0`00Oomoo`05Ool00`?ROomoo`1POol00`?ROomoo`0gOol008Yoo`@000Eoo`8000Aoo`D000Ioo`03
001oogoo00Eoo`030n9oogoo065oo`030n9oogoo03Ioo`00RGoo00<007ooOol00Woo00<007ooOol0
0Woo0P0017oo00D007ooOomoo`0000Ioo`03001oogoo00Aoo`030n9oogoo06=oo`83hSIoo`00RGoo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol017oo00<3hWooOol0IGoo
00<3hWooOol0<goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool30003Ool0
0`?ROomoo`1WOol00`?ROomoo`0bOol008Uoo`03001oogoo009oo`03001oogoo00]oo`03001oogoo
00Eoo`03001oogoo00=oo`030n9oogoo06Qoo`030n9oogoo035oo`00RGoo00<007ooOol00Woo00<0
07ooOol037oo00<007ooOol017oo00<007ooOol00Woo00<3hWooOol0JWoo00<3hWooOol0<7oo0029
Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol00Woo00<3hWoo
Ool0Jgoo0P?R<7oo002:Ool4000<Ool30007Ool01@00Oomoogoo0n80L7oo00<3hWooOol0;Goo002T
Ool01@00Oomoogoo0n80LGoo00<3hWooOol0;7oo002TOol01000Oomoo`?RLgoo0P?R;7oo002TOol0
1000Oomoo`?RMGoo00<3hWooOol0:Goo002TOol00`00Ool3hP1gOol00`?ROomoo`0XOol00:Aoo`03
001oo`?R07Qoo`83hRQoo`00Y7oo0P0000<3hWooOol0N7oo00<3hWooOol09Goo002TOol00`000n9o
o`1kOol20n8UOol00:Aoo`030003hWoo07eoo`030n9oogoo029oo`00Y7oo00<3hWooOol0OWoo0P?R
8Woo002TOol00`?ROomoo`20Ool20n8POol00:=oo`030n8007oo08=oo`@3hQaoo`00Xgoo00<3hP00
Ool0Qgoo0P?R6Woo002SOol00`?R001oo`29Ool20n8HOol00:9oo`030n9oo`0008aoo`D3hQ=oo`00
XWoo00@3hWoo0000091oo`H3hPeoo`00XWoo00<3hWoo0000Y7oo002QOol010?ROomoo`00Y7oo002Q
Ool010?ROomoo`00Y7oo002QOol010?ROomoo`00Y7oo002POol01@?ROomoogoo0000Y7oo002POol0
1@?ROomoogoo0000Y7oo002POol01@?ROomoogoo0000Y7oo002OOol00`?ROomoo`02Ool00`00Oomo
o`2ROol009moo`030n9oogoo009oo`03001oogoo0:9oo`00Wgoo00<3hWooOol00Woo0P00Xgoo002N
Ool00`?ROomoo`03Ool00`00Oomoo`2ROol009ioo`030n9oogoo00=oo`03001oogoo0:9oo`00WWoo
00<3hWooOol00goo00<007ooOol0XWoo002MOol00`?ROomoo`04Ool00`00Oomoo`2ROol009eoo`03
0n9oogoo00Aoo`03001oogoo0:9oo`00W7oo00<3hWooOol01Goo00<007ooOol0XWoo002:Ool40005
Ool20007Ool00`?R00000005Ool00`00Oomoo`2ROol008Uoo`03001oogoo009oo`03001oogoo009o
o`8000Moo`030n8007oo00Eoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007ooOol02Woo
00<3hWoo00001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`08Ool2000010?R
000000001Goo0`00XWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool010000n9oo`001Woo00<0
07ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool010?ROomoo`001Woo00<007ooOol0
XWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool010?R001oo`001Woo00<007ooOol0XWoo002:
Ool4000<Ool010?ROol000001Woo00<007ooOol0XWoo002IOol00`?ROomoo`08Ool00`00Oomoo`2R
Ool009Uoo`030n9oogoo00Qoo`03001oogoo0:9oo`00VGoo00<3hWooOol027oo00<007ooOol0XWoo
002HOol00`?ROomoo`09Ool00`00Oomoo`2ROol009Qoo`030n9oogoo00Uoo`03001oogoo0:9oo`00
V7oo00<3hWooOol02Goo0P00Xgoo002GOol00`?ROomoo`0:Ool00`00Oomoo`2ROol009Moo`030n9o
ogoo00Yoo`03001oogoo0:9oo`00Ugoo00<3hWooOol02Woo00<007ooOol0XWoo002FOol00`?ROomo
o`0;Ool00`00Oomoo`2ROol009Ioo`030n9oogoo00]oo`03001oogoo0:9oo`00UWoo00<3hWooOol0
2goo00<007ooOol0XWoo002FOol00`?ROomoo`0;Ool00`00Oomoo`2ROol009Eoo`030n9oogoo00ao
o`03001oogoo0:9oo`00UGoo00<3hWooOol037oo00<007ooOol0XWoo002EOol00`?ROomoo`0<Ool2
002SOol009Eoo`030n9oogoo00aoo`03001oogoo0:9oo`00U7oo00<3hWooOol03Goo00<007ooOol0
XWoo002DOol00`?ROomoo`0=Ool00`00Oomoo`2ROol009Aoo`030n9oogoo00eoo`03001oogoo0:9o
o`00U7oo00<3hWooOol03Goo00<007ooOol0XWoo002COol00`?ROomoo`0>Ool00`00Oomoo`2ROol0
09=oo`030n9oogoo00ioo`03001oogoo0:9oo`00Tgoo00<3hWooOol03Woo00<007ooOol0XWoo002C
Ool00`?ROomoo`0>Ool00`00Oomoo`2ROol0099oo`030n9oogoo00moo`800:=oo`00TWoo00<3hWoo
Ool03goo00<007ooOol0XWoo002BOol00`?ROomoo`0?Ool00`00Oomoo`2ROol0099oo`030n9oogoo
00moo`03001oogoo0:9oo`00TGoo00<3hWooOol047oo00<007ooOol0XWoo002AOol00`?ROomoo`0@
Ool00`00Oomoo`2ROol0095oo`030n9oogoo011oo`03001oogoo0:9oo`00TGoo00<3hWooOol047oo
00<007ooOol0XWoo002@Ool00`?ROomoo`0AOol00`00Oomoo`2ROol0091oo`030n9oogoo015oo`03
001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 .4 r
.5 Mabswid
.42709 .61803 m
.46172 .49411 L
.49955 .39285 L
.51896 .35266 L
.53984 .31758 L
.56097 .29005 L
.5707 .2799 L
.58106 .27073 L
.59145 .26317 L
.60087 .25767 L
.61034 .25337 L
.61926 .2504 L
.62391 .24925 L
.62902 .24829 L
.63159 .24792 L
.63435 .24761 L
.63569 .2475 L
.63696 .24741 L
.63809 .24734 L
.63933 .24728 L
.64048 .24724 L
.64156 .24722 L
.6427 .24721 L
.64393 .24722 L
.64501 .24724 L
.64615 .24727 L
.64712 .24731 L
.64818 .24737 L
.65059 .24753 L
.65317 .24778 L
.65781 .24839 L
.66314 .24936 L
.66805 .25049 L
.67915 .25385 L
.68894 .25767 L
.6993 .26252 L
.73719 .28611 L
.77753 .31812 L
.81636 .35152 L
.85763 .38525 L
.87826 .39996 L
.89739 .4116 L
.91592 .42059 L
.92627 .42447 L
.93564 .42719 L
.94053 .42829 L
.94569 .4292 L
.95009 .42978 L
.95259 .43001 L
.95492 .43018 L
Mistroke
.95622 .43024 L
.9569 .43027 L
.95763 .4303 L
.95826 .43031 L
.95896 .43032 L
.96019 .43033 L
.96138 .43033 L
.96266 .4303 L
.96388 .43027 L
.96499 .43021 L
.96629 .43014 L
.96749 .43005 L
.97024 .42979 L
.97291 .42945 L
.97576 .42899 L
.97619 .42892 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Ooo;00050na`0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00Aoo`L3k004Ool007ooOol60n`6Ool00`00Oomoo`0<Ool00`00
Oomoo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00
Oomoo`0;Ool000aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo009oo`83k0Qoo`03001o
ogoo00Ioo`83k0Aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00Y7oo00<007ooOol07Woo0P?/5Goo
0`?/JWoo002TOol00`00Oomoo`0LOol20n`JOol30naWOol00:Aoo`03001oogoo01Yoo`83k1moo`83
k6Eoo`00Y7oo00<007ooOol06Goo00<3k7ooOol08Goo0P?/Hgoo002TOol00`00Oomoo`0GOol20n`V
Ool00`?/Oomoo`1POol00:Aoo`03001oogoo01Ioo`030naoogoo02Moo`83k61oo`00Y7oo00<007oo
Ool05Goo00<3k7ooOol0:Woo00<3k7ooOol0GGoo002TOol2000EOol00`?/Oomoo`0/Ool20naMOol0
0:Aoo`03001oogoo01=oo`030naoogoo02moo`030naoogoo05Yoo`00Y7oo00<007ooOol04Woo00<3
k7ooOol0<Goo0P?/FWoo002TOol00`00Oomoo`0AOol00`?/Oomoo`0dOol00`?/Oomoo`1GOol00:Ao
o`03001oogoo011oo`030naoogoo03Ioo`030naoogoo05Ioo`00Y7oo00<007ooOol03goo00<3k7oo
Ool0>7oo0P?/EWoo002TOol00`00Oomoo`0>Ool00`?/Oomoo`0kOol00`?/Oomoo`1COol00:Aoo`03
001oogoo00ioo`030naoogoo03aoo`030naoogoo059oo`00Y7oo00<007ooOol03Goo00<3k7ooOol0
?Woo0P?/DWoo002TOol00`00Oomoo`0<Ool00`?/Oomoo`11Ool00`?/Oomoo`1?Ool00:Aoo`8000ao
o`030naoogoo04=oo`030naoogoo04ioo`00Y7oo00<007ooOol02goo00<3k7ooOol0A7oo0P?/CWoo
002TOol00`00Oomoo`0:Ool00`?/Oomoo`17Ool00`?/Oomoo`1;Ool00:Aoo`03001oogoo00Uoo`03
0naoogoo04Uoo`030naoogoo04Yoo`00Y7oo00<007ooOol027oo00<3k7ooOol0Bgoo00<3k7ooOol0
BGoo002TOol00`00Oomoo`08Ool00`?/Oomoo`1<Ool00`?/Oomoo`18Ool00:Aoo`03001oogoo00Mo
o`030naoogoo04ioo`030naoogoo04Moo`00Y7oo00<007ooOol01goo00<3k7ooOol0Cgoo00<3k7oo
Ool0AWoo002TOol00`00Oomoo`06Ool00`?/Oomoo`1AOol00`?/Oomoo`15Ool00:Aoo`03001oogoo
00Ioo`030naoogoo059oo`83k4Eoo`00Y7oo0P001Woo00<3k7ooOol0EGoo00<3k7ooOol0@Woo002T
Ool00`00Oomoo`05Ool00`?/Oomoo`1FOol00`?/Oomoo`11Ool00:Aoo`03001oogoo00Aoo`030nao
ogoo05Qoo`030naoogoo041oo`00Y7oo00<007ooOol017oo00<3k7ooOol0FGoo00<3k7ooOol0?goo
002TOol00`00Oomoo`03Ool00`?/Oomoo`1KOol00`?/Oomoo`0nOol00:Aoo`03001oogoo009oo`03
0naoogoo05eoo`83k3ioo`00Y7oo00<007ooOol00Woo00<3k7ooOol0Ggoo00<3k7ooOol0>goo002:
Ool40005Ool20004Ool50006Ool01@00Oomoogoo0n`0Hgoo00<3k7ooOol0>Woo0029Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00001Woo00D007ooOomoo`?/06Aoo`83k3Yo
o`00RGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00@007ooOol3k6Moo`030nao
ogoo03Moo`00RGoo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`0000<3k7ooOol0
IWoo0P?/=goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Ool3k01[
Ool00`?/Oomoo`0dOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001o
o`?/06aoo`030naoogoo03=oo`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`00
00Ioo`030003k7oo06eoo`83k3=oo`00RWoo100037oo0`001goo00<000?/Ool0Kgoo00<3k7ooOol0
<7oo002TOol00`?/Oomoo`1`Ool00`?/Oomoo`0_Ool00:Aoo`030naoogoo075oo`030naoogoo02io
o`00Xgoo00<3k000Ool0Lgoo0P?/;Woo002SOol00`?/001oo`1eOol00`?/Oomoo`0[Ool00:9oo`03
0naoo`0007Moo`030naoogoo02Yoo`00XWoo00@3k7oo000007Moo`83k2Yoo`00XGoo00@3k7ooOol0
07Yoo`030naoogoo02Moo`00XGoo00@3k7ooOol007]oo`83k2Moo`00XGoo00@3k7ooOol007eoo`03
0naoogoo02Aoo`00X7oo00D3k7ooOomoo`0007ioo`83k2Aoo`00X7oo00D3k7ooOomoo`00081oo`83
k29oo`00X7oo00D3k7ooOomoo`00089oo`<3k1moo`00Wgoo00<3k7ooOol00Woo00<007ooOol0Pgoo
0`?/77oo002OOol00`?/Oomoo`02Ool00`00Oomoo`26Ool60n`7Ool20n`=Ool009ioo`030naoogoo
00=oo`8008eoo`L3k0moo`00WWoo00<3k7ooOol00goo00<007ooOol0XWoo002NOol00`?/Oomoo`03
Ool00`00Oomoo`2ROol009eoo`030naoogoo00Aoo`03001oogoo0:9oo`00WGoo00<3k7ooOol017oo
00<007ooOol0XWoo002MOol00`?/Oomoo`04Ool00`00Oomoo`2ROol009aoo`030naoogoo00Eoo`03
001oogoo0:9oo`00W7oo00<3k7ooOol01Goo00<007ooOol0XWoo002KOol00`?/Oomoo`06Ool00`00
Oomoo`2ROol009]oo`030naoogoo00Ioo`03001oogoo0:9oo`00Vgoo00<3k7ooOol01Woo0P00Xgoo
002JOol00`?/Oomoo`07Ool00`00Oomoo`2ROol009Yoo`030naoogoo00Moo`03001oogoo0:9oo`00
VWoo00<3k7ooOol01goo00<007ooOol0XWoo002IOol00`?/Oomoo`08Ool00`00Oomoo`2ROol009Uo
o`030naoogoo00Qoo`03001oogoo0:9oo`00V7oo00<3k7ooOol02Goo00<007ooOol0XWoo002:Ool4
0005Ool20003Ool010?/Oomoogoo0`001Goo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool20003Ool00`?/Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`2ROol008Uoo`03001o
ogoo009oo`03001oogoo00Ioo`030naoogoo00=oo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo
00<007ooOol00Woo00<007ooOol01Woo00<3k7oo00001@001Goo0`00XWoo0029Ool00`00Oomoo`02
Ool00`00Oomoo`06Ool010?/Oomoo`000Woo00<007ooOol017oo00<007ooOol0XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`05Ool01@?/Oomoogoo00000Woo00<007ooOol017oo00<007ooOol0XWoo
0029Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`?/Oomoo`02Ool00`00Ool00006Ool00`00Oomo
o`2ROol008Yoo`@000Qoo`030naoogoo00=oo`8000Ioo`03001oogoo0:9oo`00UWoo00<3k7ooOol0
2goo00<007ooOol0XWoo002EOol00`?/Oomoo`0<Ool00`00Oomoo`2ROol009Eoo`030naoogoo00ao
o`03001oogoo0:9oo`00UGoo00<3k7ooOol037oo00<007ooOol0XWoo002DOol00`?/Oomoo`0=Ool0
0`00Oomoo`2ROol009Aoo`030naoogoo00eoo`800:=oo`00U7oo00<3k7ooOol03Goo00<007ooOol0
XWoo002DOol00`?/Oomoo`0=Ool00`00Oomoo`2ROol009=oo`030naoogoo00ioo`03001oogoo0:9o
o`00Tgoo00<3k7ooOol03Woo00<007ooOol0XWoo002COol00`?/Oomoo`0>Ool00`00Oomoo`2ROol0
099oo`030naoogoo00moo`03001oogoo0:9oo`00TWoo00<3k7ooOol03goo00<007ooOol0XWoo002B
Ool00`?/Oomoo`0?Ool00`00Oomoo`2ROol0099oo`030naoogoo00moo`03001oogoo0:9oo`00TGoo
00<3k7ooOol047oo0P00Xgoo002AOol00`?/Oomoo`0@Ool00`00Oomoo`2ROol0095oo`030naoogoo
011oo`03001oogoo0:9oo`00TGoo00<3k7ooOol047oo00<007ooOol0XWoo002@Ool00`?/Oomoo`0A
Ool00`00Oomoo`2ROol0091oo`030naoogoo015oo`03001oogoo0:9oo`00T7oo00<3k7ooOol04Goo
00<007ooOol0XWoo002?Ool00`?/Oomoo`0BOol00`00Oomoo`2ROol008moo`030naoogoo019oo`03
001oogoo0:9oo`00Sgoo00<3k7ooOol04Woo00<007ooOol0XWoo002?Ool00`?/Oomoo`0BOol2002S
Ool008ioo`030naoogoo01=oo`03001oogoo0:9oo`00SWoo00<3k7ooOol04goo00<007ooOol0XWoo
002>Ool00`?/Oomoo`0COol00`00Oomoo`2ROol008eoo`030naoogoo01Aoo`03001oogoo0:9oo`00
SGoo00<3k7ooOol057oo00<007ooOol0XWoo002=Ool00`?/Oomoo`0DOol00`00Oomoo`2ROol008eo
o`030naoogoo01Aoo`03001oogoo0:9oo`00S7oo00<3k7ooOol05Goo00<007ooOol0XWoo002<Ool0
0`?/Oomoo`0EOol00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 .7 r
.5 Mabswid
.41545 .61803 m
.42237 .58827 L
.46172 .45882 L
.49955 .3673 L
.51896 .33166 L
.53984 .30112 L
.56097 .27783 L
.5707 .26951 L
.58106 .2622 L
.59145 .25642 L
.60087 .25246 L
.60542 .25096 L
.61034 .24963 L
.61498 .24865 L
.61926 .24798 L
.62171 .24769 L
.62396 .24748 L
.62519 .2474 L
.62654 .24732 L
.62781 .24727 L
.62899 .24723 L
.63007 .24722 L
.63109 .24721 L
.6322 .24722 L
.6334 .24725 L
.63459 .24729 L
.63584 .24734 L
.63808 .24749 L
.64055 .24771 L
.64319 .24801 L
.64795 .24873 L
.65361 .24988 L
.65874 .25118 L
.67793 .25806 L
.68875 .26321 L
.69873 .26869 L
.73813 .29574 L
.77602 .32698 L
.81636 .36164 L
.85518 .39223 L
.87493 .40544 L
.89646 .41723 L
.90645 .42158 L
.91709 .42534 L
.92226 .42681 L
.92713 .42798 L
.93183 .42889 L
.93622 .42954 L
.93847 .42981 L
.94089 .43003 L
Mistroke
.94226 .43013 L
.94357 .43021 L
.94474 .43026 L
.94601 .4303 L
.94725 .43033 L
.94795 .43033 L
.94861 .43033 L
.94931 .43033 L
.94994 .43032 L
.95064 .43031 L
.95138 .43029 L
.9526 .43024 L
.95375 .43018 L
.95634 .42999 L
.95875 .42974 L
.96102 .42944 L
.96528 .42873 L
.96986 .42771 L
.97482 .42632 L
.97619 .42588 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Ooo700060oEc0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo009oo`@3m@Eoo`H3m@Yoo`03001oogoo00aoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]o
o`0037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007oo
Ool03Goo00<007ooOol037oo00<007ooOol037oo00<000?e0oD00P?e2Woo00<007ooOol00Woo0P?e
27oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol02goo002TOol00`00Oomoo`0JOol20oDEOol30oE^Ool00:Ao
o`03001oogoo01Qoo`83mAYoo`83mFaoo`00Y7oo00<007ooOol05Woo0P?e7Woo0P?eJWoo002TOol0
0`00Oomoo`0EOol00`?eOomoo`0POol30oEWOol00:Aoo`03001oogoo01Aoo`030oEoogoo02Aoo`83
mFEoo`00Y7oo00<007ooOol04goo00<3mGooOol09goo00<3mGooOol0HWoo002TOol00`00Oomoo`0A
Ool20oD[Ool20oEROol00:Aoo`80015oo`030oEoogoo02eoo`030oEoogoo05moo`00Y7oo00<007oo
Ool03goo00<3mGooOol0;goo00<3mGooOol0GWoo002TOol00`00Oomoo`0>Ool00`?eOomoo`0aOol2
0oENOol00:Aoo`03001oogoo00eoo`030oEoogoo03Aoo`030oEoogoo05]oo`00Y7oo00<007ooOol0
37oo00<3mGooOol0=Woo00<3mGooOol0FWoo002TOol00`00Oomoo`0<Ool00`?eOomoo`0gOol20oEJ
Ool00:Aoo`03001oogoo00]oo`030oEoogoo03Yoo`030oEoogoo05Moo`00Y7oo00<007ooOol02Woo
00<3mGooOol0?7oo00<3mGooOol0EWoo002TOol00`00Oomoo`09Ool00`?eOomoo`0nOol20oEFOol0
0:Aoo`03001oogoo00Qoo`030oEoogoo045oo`030oEoogoo05=oo`00Y7oo0P002Goo00<3mGooOol0
@Woo00<3mGooOol0DWoo002TOol00`00Oomoo`07Ool00`?eOomoo`14Ool20oEBOol00:Aoo`03001o
ogoo00Ioo`030oEoogoo04Moo`030oEoogoo04moo`00Y7oo00<007ooOol01Woo00<3mGooOol0B7oo
00<3mGooOol0CWoo002TOol00`00Oomoo`05Ool00`?eOomoo`1:Ool20oE>Ool00:Aoo`03001oogoo
00Aoo`030oEoogoo04eoo`030oEoogoo04]oo`00Y7oo00<007ooOol017oo00<3mGooOol0CWoo00<3
mGooOol0BWoo002TOol00`00Oomoo`03Ool00`?eOomoo`1@Ool00`?eOomoo`19Ool00:Aoo`03001o
ogoo009oo`030oEoogoo059oo`030oEoogoo04Qoo`00Y7oo00<007ooOol00Woo00<3mGooOol0Dgoo
00<3mGooOol0Agoo002TOol20002Ool00`?eOomoo`1EOol00`?eOomoo`16Ool00:Aoo`05001oogoo
Ool3m@1HOol00`?eOomoo`15Ool00:Aoo`04001oogoo0oEJOol20oE5Ool00:Aoo`03001oo`?e05eo
o`030oEoogoo049oo`00Y7oo00<007oo0oD0GWoo00<3mGooOol0@Goo002TOol00`000oEoo`1OOol0
0`?eOomoo`10Ool00:Aoo`030003mGoo061oo`030oEoogoo03moo`00RWoo10001Goo0P0017oo1@00
1Woo00<3mGooOol0HGoo00<3mGooOol0?Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004
Ool01@00Oomoogoo00001Woo00<3mGooOol0HWoo00<3mGooOol0?Goo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool00`00Oomoo`06Ool00`?e001oo`1TOol20oDmOol008Uoo`03001oogoo009oo`03
001oogoo00Yoo`03001oogoo00Eoo`040oD00000001UOol00`?eOomoo`0jOol008Uoo`03001oogoo
009oo`03001oogoo00]oo`03001oogoo00=oo`030oEoo`0006Qoo`030oEoogoo03Uoo`00RGoo00<0
07ooOol00Woo00<007ooOol037oo00<007ooOol00Woo00<3mGoo0000JGoo0P?e>Goo0029Ool00`00
Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00000goo00@3mGooOol006]oo`030oEoogoo03Io
o`00RWoo100037oo0`0017oo00@3mGooOol006aoo`030oEoogoo03Eoo`00XGoo00@3mGooOol006eo
o`83mCEoo`00X7oo00D3mGooOomoo`0006moo`030oEoogoo039oo`00X7oo00D3mGooOomoo`00071o
o`030oEoogoo035oo`00Wgoo00<3mGooOol00Woo00<007ooOol0Kgoo0P?e<Goo002OOol00`?eOomo
o`02Ool00`00Oomoo`1aOol00`?eOomoo`0^Ool009ioo`030oEoogoo00=oo`8007=oo`83mBioo`00
WWoo00<3mGooOol00goo00<007ooOol0M7oo00<3mGooOol0:goo002NOol00`?eOomoo`03Ool00`00
Oomoo`1eOol20oD[Ool009eoo`030oEoogoo00Aoo`03001oogoo07Moo`83mBUoo`00WGoo00<3mGoo
Ool017oo00<007ooOol0NGoo0P?e9goo002LOol00`?eOomoo`05Ool00`00Oomoo`1kOol20oDUOol0
09aoo`030oEoogoo00Eoo`03001oogoo07eoo`<3mB9oo`00W7oo00<3mGooOol01Goo00<007ooOol0
P7oo0P?e4Woo00<3mGooOol02goo002KOol00`?eOomoo`06Ool00`00Oomoo`22Ool70oD6Ool50oD>
Ool009]oo`030oEoogoo00Ioo`8008Uoo`P3mA9oo`00VWoo00<3mGooOol01goo00<007ooOol0XWoo
002JOol00`?eOomoo`07Ool00`00Oomoo`2ROol009Uoo`030oEoogoo00Qoo`03001oogoo0:9oo`00
VGoo00<3mGooOol027oo00<007ooOol0XWoo002IOol00`?eOomoo`08Ool00`00Oomoo`2ROol009Qo
o`030oEoogoo00Uoo`03001oogoo0:9oo`00V7oo00<3mGooOol02Goo00<007ooOol0XWoo002GOol0
0`?eOomoo`0:Ool00`00Oomoo`2ROol009Moo`030oEoogoo00Yoo`03001oogoo0:9oo`00Ugoo00<3
mGooOol02Woo0P00Xgoo002FOol00`?eOomoo`0;Ool00`00Oomoo`2ROol009Ioo`030oEoogoo00]o
o`03001oogoo0:9oo`00UWoo00<3mGooOol02goo00<007ooOol0XWoo002FOol00`?eOomoo`0;Ool0
0`00Oomoo`2ROol009Eoo`030oEoogoo00aoo`03001oogoo0:9oo`00UGoo00<3mGooOol037oo00<0
07ooOol0XWoo002:Ool40005Ool200000`?eOomoo`04Ool30005Ool00`00Oomoo`2ROol008Uoo`03
001oogoo009oo`03001oogoo009oo`030003mGoo00Moo`03001oogoo00Aoo`03001oogoo0:9oo`00
RGoo00<007ooOol00Woo00<007ooOol00goo00<3mGooOol01Woo00<007ooOol017oo00<007ooOol0
XWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`?eOomoo`02Ool60005Ool3002ROol008Uo
o`03001oogoo009oo`03001oogoo009oo`030oEoogoo00Aoo`04001oogoo0006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`030oEoogoo00Aoo`04001oogoo0006Ool00`00
Oomoo`2ROol008Uoo`03001oogoo009oo`03001oogoo009oo`030oEoogoo00Eoo`03001oo`0000Io
o`03001oogoo0:9oo`00RWoo10001Goo00<3mGooOol01Woo0P001Woo00<007ooOol0XWoo002BOol0
0`?eOomoo`0?Ool00`00Oomoo`2ROol0099oo`030oEoogoo00moo`03001oogoo0:9oo`00TWoo00<3
mGooOol03goo00<007ooOol0XWoo002AOol00`?eOomoo`0@Ool00`00Oomoo`2ROol0095oo`030oEo
ogoo011oo`03001oogoo0:9oo`00TGoo00<3mGooOol047oo0P00Xgoo002AOol00`?eOomoo`0@Ool0
0`00Oomoo`2ROol0091oo`030oEoogoo015oo`03001oogoo0:9oo`00T7oo00<3mGooOol04Goo00<0
07ooOol0XWoo002@Ool00`?eOomoo`0AOol00`00Oomoo`2ROol008moo`030oEoogoo019oo`03001o
ogoo0:9oo`00Sgoo00<3mGooOol04Woo00<007ooOol0XWoo002?Ool00`?eOomoo`0BOol00`00Oomo
o`2ROol008moo`030oEoogoo019oo`03001oogoo0:9oo`00SWoo00<3mGooOol04goo00<007ooOol0
XWoo002>Ool00`?eOomoo`0COol2002SOol008ioo`030oEoogoo01=oo`03001oogoo0:9oo`00SGoo
00<3mGooOol057oo00<007ooOol0XWoo002=Ool00`?eOomoo`0DOol00`00Oomoo`2ROol008eoo`03
0oEoogoo01Aoo`03001oogoo0:9oo`00S7oo00<3mGooOol05Goo00<007ooOol0XWoo002<Ool00`?e
Oomoo`0EOol00`00Oomoo`2ROol008aoo`030oEoogoo01Eoo`03001oogoo0:9oo`00S7oo00<3mGoo
Ool05Goo00<007ooOol0XWoo002;Ool00`?eOomoo`0FOol00`00Oomoo`2ROol008]oo`030oEoogoo
01Ioo`800:=oo`00Rgoo00<3mGooOol05Woo00<007ooOol0XWoo002;Ool00`?eOomoo`0FOol00`00
Oomoo`2ROol008Yoo`030oEoogoo01Moo`03001oogoo0:9oo`00RWoo00<3mGooOol05goo00<007oo
Ool0XWoo002:Ool00`?eOomoo`0GOol00`00Oomoo`2ROol008Yoo`030oEoogoo01Moo`03001oogoo
0:9oo`00RGoo00<3mGooOol067oo00<007ooOol0XWoo0029Ool00`?eOomoo`0HOol00`00Oomoo`2R
Ool008Uoo`030oEoogoo01Qoo`03001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 1 r
.5 Mabswid
.40411 .61803 m
.42237 .54518 L
.46172 .42672 L
.49955 .34458 L
.51896 .3133 L
.53984 .2871 L
.54994 .27702 L
.56097 .26784 L
.57151 .26076 L
.58106 .25571 L
.58593 .25361 L
.59119 .25169 L
.59574 .25032 L
.60074 .24911 L
.60605 .24816 L
.60895 .24778 L
.61034 .24763 L
.61166 .24752 L
.61287 .24742 L
.6142 .24734 L
.6154 .24729 L
.61651 .24725 L
.61771 .24722 L
.61903 .24721 L
.6197 .24722 L
.62041 .24722 L
.62171 .24725 L
.62296 .2473 L
.62411 .24735 L
.62667 .24753 L
.62904 .24775 L
.63128 .24801 L
.6363 .24878 L
.64175 .24989 L
.65273 .25296 L
.66285 .25671 L
.68161 .26575 L
.70225 .27836 L
.74259 .30883 L
.78142 .34192 L
.82269 .3766 L
.84332 .39226 L
.86245 .40509 L
.88216 .41607 L
.9007 .42387 L
.91058 .42687 L
.91615 .42817 L
.92126 .42911 L
.92558 .4297 L
.92804 .42995 L
Mistroke
.93032 .43013 L
.93156 .4302 L
.93274 .43026 L
.93379 .43029 L
.93494 .43032 L
.93618 .43033 L
.93751 .43033 L
.93864 .43031 L
.93988 .43027 L
.94098 .43022 L
.94201 .43017 L
.94433 .43 L
.94659 .42977 L
.94901 .42946 L
.95339 .42873 L
.95737 .42786 L
.96706 .42492 L
.97619 .42104 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Ooo400040omh0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`H3o`Aoo`L3o`eoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`0037oo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool037oo00<007ooOol02Goo0`?o00<007ooOol037oo00<007oo0ol00P?o2Woo00<007ooOol037oo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo
00<007ooOol02goo002TOol00`00Oomoo`0FOol20olGOol20omaOol00:Aoo`03001oogoo01Aoo`83
oa]oo`83ofmoo`00Y7oo00<007ooOol04goo00<3ogooOol07Goo0P?oKGoo002TOol00`00Oomoo`0A
Ool20olROol20om[Ool00:Aoo`03001oogoo011oo`030omoogoo02Aoo`83ofUoo`00Y7oo00<007oo
Ool03goo00<3ogooOol09goo0P?oIgoo002TOol00`00Oomoo`0>Ool00`?oOomoo`0ZOol20omUOol0
0:Aoo`8000ioo`030omoogoo02eoo`030omoogoo069oo`00Y7oo00<007ooOol037oo00<3ogooOol0
;goo00<3ogooOol0HGoo002TOol00`00Oomoo`0:Ool20olcOol20omQOol00:Aoo`03001oogoo00Uo
o`030omoogoo03Eoo`030omoogoo05ioo`00Y7oo00<007ooOol027oo00<3ogooOol0=goo00<3ogoo
Ool0GGoo002TOol00`00Oomoo`07Ool00`?oOomoo`0iOol20omMOol00:Aoo`03001oogoo00Moo`03
0omoogoo03]oo`030omoogoo05Yoo`00Y7oo00<007ooOol01Woo00<3ogooOol0?Goo00<3ogooOol0
FGoo002TOol00`00Oomoo`05Ool00`?oOomoo`0oOol20omIOol00:Aoo`03001oogoo00Aoo`030omo
ogoo049oo`030omoogoo05Ioo`00Y7oo0P001Goo00<3ogooOol0@goo00<3ogooOol0EGoo002TOol0
0`00Oomoo`03Ool00`?oOomoo`15Ool00`?oOomoo`1DOol00:Aoo`03001oogoo009oo`030omoogoo
04Moo`030omoogoo05=oo`00Y7oo00<007ooOol00Woo00<3ogooOol0B7oo00<3ogooOol0DWoo002T
Ool01@00Oomoogoo0ol0C7oo00<3ogooOol0DGoo002TOol01000Oomoo`?oCWoo00<3ogooOol0D7oo
002TOol00`00Ool3o`1@Ool20om@Ool00:Aoo`03001oo`?o059oo`030omoogoo04eoo`00Y7oo00<0
00?oOol0Dgoo00<3ogooOol0C7oo002TOol00`?oOomoo`1DOol00`?oOomoo`1;Ool00:Aoo`030ol0
07oo05Eoo`030omoogoo04Yoo`00Xgoo00<3o`00Ool0Egoo00<3ogooOol0BGoo002SOol00`?o001o
o`1HOol00`?oOomoo`18Ool00:9oo`030omoo`0005Yoo`030omoogoo04Moo`00XWoo00<3ogoo0000
Fgoo0P?oAgoo002QOol010?oOomoo`00GGoo00<3ogooOol0A7oo002QOol010?oOomoo`00GWoo00<3
ogooOol0@goo002:Ool40005Ool20004Ool50002Ool01@?oOomoogoo0000Ggoo00<3ogooOol0@Woo
0029Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00000Woo00D3ogooOomo
o`00061oo`030omoogoo045oo`00RGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol00Woo
00<3ogooOol00Woo00<007ooOol0Ggoo0P?o@Goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool0
1@00Oomoogoo0ol017oo0`00HGoo00<3ogooOol0?Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`0;
Ool01000Oomoo`?o17oo00<007ooOol0HWoo00<3ogooOol0?Goo0029Ool00`00Oomoo`02Ool00`00
Oomoo`0<Ool00`000omoo`04Ool00`00Oomoo`1SOol00`?oOomoo`0lOol008Uoo`03001oogoo009o
o`03001oogoo00Qoo`06001oogooOol000?o1Goo00<007ooOol0I7oo0P?o?7oo002:Ool4000<Ool3
00000`?oOomoo`04Ool00`00Oomoo`1VOol00`?oOomoo`0iOol009eoo`030omoogoo00Aoo`03001o
ogoo06Moo`030omoogoo03Qoo`00W7oo00<3ogooOol01Goo00<007ooOol0J7oo0P?o>7oo002LOol0
0`?oOomoo`05Ool00`00Oomoo`1ZOol00`?oOomoo`0eOol009]oo`030omoogoo00Ioo`03001oogoo
06]oo`83ocEoo`00Vgoo00<3ogooOol01Woo00<007ooOol0KGoo00<3ogooOol0<Woo002KOol00`?o
Oomoo`06Ool2001_Ool20olbOol009Yoo`030omoogoo00Moo`03001oogoo071oo`030omoogoo02mo
o`00VWoo00<3ogooOol01goo00<007ooOol0LGoo0P?o;goo002IOol00`?oOomoo`08Ool00`00Oomo
o`1cOol20ol]Ool009Uoo`030omoogoo00Qoo`03001oogoo07Eoo`83ob]oo`00V7oo00<3ogooOol0
2Goo00<007ooOol0Mgoo0P?o:Goo002HOol00`?oOomoo`09Ool00`00Oomoo`1iOol20olHOol20ol=
Ool009Moo`030omoogoo00Yoo`03001oogoo07]oo`<3oa9oo`<3o`moo`00Ugoo00<3ogooOol02Woo
00<007ooOol0OWoo1P?o27oo10?o4Woo002GOol00`?oOomoo`0:Ool20025Ool80olFOol009Ioo`03
0omoogoo00]oo`03001oogoo0:9oo`00UWoo00<3ogooOol02goo00<007ooOol0XWoo002FOol00`?o
Oomoo`0;Ool00`00Oomoo`2ROol009Eoo`030omoogoo00aoo`03001oogoo0:9oo`00UGoo00<3ogoo
Ool037oo00<007ooOol0XWoo002EOol00`?oOomoo`0<Ool00`00Oomoo`2ROol009Aoo`030omoogoo
00eoo`03001oogoo0:9oo`00U7oo00<3ogooOol03Goo00<007ooOol0XWoo002DOol00`?oOomoo`0=
Ool00`00Oomoo`2ROol009=oo`030omoogoo00ioo`800:=oo`00Tgoo00<3ogooOol03Woo00<007oo
Ool0XWoo002COol00`?oOomoo`0>Ool00`00Oomoo`2ROol0099oo`030omoogoo00moo`03001oogoo
0:9oo`00TWoo00<3ogooOol03goo00<007ooOol0XWoo002BOol00`?oOomoo`0?Ool00`00Oomoo`2R
Ool0095oo`030omoogoo011oo`03001oogoo0:9oo`00RWoo10000goo00@3ogoo000000Moo`<000Eo
o`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00D007ooOol3ogoo008000Qoo`03001oogoo00Ao
o`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00@007ooOol3o`]oo`03001oogoo00Aoo`03001o
ogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo0ol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Ool3o`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Ool3o`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`000omo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@00003Ool3ogoo00]oo`8000Ioo`03001o
ogoo0:9oo`00Sgoo00<3ogooOol04Woo00<007ooOol0XWoo002>Ool00`?oOomoo`0COol00`00Oomo
o`2ROol008ioo`030omoogoo01=oo`03001oogoo0:9oo`00SWoo00<3ogooOol04goo00<007ooOol0
XWoo002=Ool00`?oOomoo`0DOol00`00Oomoo`2ROol008eoo`030omoogoo01Aoo`800:=oo`00SGoo
00<3ogooOol057oo00<007ooOol0XWoo002<Ool00`?oOomoo`0EOol00`00Oomoo`2ROol008aoo`03
0omoogoo01Eoo`03001oogoo0:9oo`00S7oo00<3ogooOol05Goo00<007ooOol0XWoo002;Ool00`?o
Oomoo`0FOol00`00Oomoo`2ROol008]oo`030omoogoo01Ioo`03001oogoo0:9oo`00Rgoo00<3ogoo
Ool05Woo00<007ooOol0XWoo002:Ool00`?oOomoo`0GOol00`00Oomoo`2ROol008Yoo`030omoogoo
01Moo`03001oogoo0:9oo`00RWoo00<3ogooOol05goo0P00Xgoo002:Ool00`?oOomoo`0GOol00`00
Oomoo`2ROol008Uoo`030omoogoo01Qoo`03001oogoo0:9oo`00RGoo00<3ogooOol067oo00<007oo
Ool0XWoo0029Ool00`?oOomoo`0HOol00`00Oomoo`2ROol008Uoo`030omoogoo01Qoo`03001oogoo
0:9oo`00R7oo00<3ogooOol06Goo00<007ooOol0XWoo0028Ool00`?oOomoo`0IOol00`00Oomoo`2R
Ool008Qoo`030omoogoo01Uoo`03001oogoo0:9oo`00R7oo00<3ogooOol06Goo00<007ooOol0XWoo
0027Ool00`?oOomoo`0JOol2002SOol008Moo`030omoogoo01Yoo`03001oogoo0:9oo`00Qgoo00<3
ogooOol06Woo00<007ooOol0XWoo0027Ool00`?oOomoo`0JOol00`00Oomoo`2ROol008Ioo`030omo
ogoo01]oo`03001oogoo0:9oo`00QWoo00<3ogooOol06goo00<007ooOol0XWoo0026Ool00`?oOomo
o`0KOol00`00Oomoo`2ROol008Ioo`030omoogoo01]oo`03001oogoo0:9oo`00QGoo00<3ogooOol0
77oo00<007ooOol0XWoo0025Ool00`?oOomoo`0LOol00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .7 1 r
.5 Mabswid
.39187 .61803 m
.42237 .50554 L
.46172 .3977 L
.49955 .32457 L
.51896 .29745 L
.53984 .2754 L
.54994 .26719 L
.56097 .25996 L
.57139 .2547 L
.58106 .25112 L
.58614 .24972 L
.58881 .24912 L
.59163 .24857 L
.5941 .24817 L
.59682 .24781 L
.59928 .24756 L
.60159 .24738 L
.60274 .24732 L
.604 .24727 L
.60519 .24723 L
.60628 .24722 L
.60727 .24721 L
.60836 .24722 L
.6095 .24724 L
.61057 .24728 L
.61174 .24733 L
.61298 .2474 L
.6152 .24756 L
.61758 .24779 L
.62019 .24812 L
.62548 .24898 L
.63047 .25003 L
.6398 .25263 L
.64986 .25627 L
.66075 .26112 L
.70167 .28625 L
.74108 .31749 L
.77896 .35007 L
.8193 .38326 L
.85813 .40961 L
.86826 .41508 L
.8793 .42021 L
.88985 .42423 L
.8994 .42706 L
.90429 .42818 L
.90956 .42914 L
.91198 .42949 L
.91454 .42979 L
.91672 .43 L
.91912 .43017 L
Mistroke
.92053 .43024 L
.92122 .43027 L
.92186 .43029 L
.92306 .43032 L
.92436 .43033 L
.92566 .43033 L
.92639 .43032 L
.92709 .4303 L
.92781 .43028 L
.92848 .43025 L
.92998 .43018 L
.9312 .43009 L
.93233 .43 L
.93491 .42974 L
.93742 .42941 L
.9401 .42898 L
.94474 .42803 L
.94902 .42692 L
.95868 .42355 L
.96719 .41956 L
.97619 .41426 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Ooo000050[mk0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00Uoo`D2_`Aoo`L2_`9oo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]o
o`0037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007oo
Ool03Goo00<007ooOol037oo00<007ooOol01Woo0`:o0goo00<007ooOol02Woo0`:o3Woo00<007oo
Ool037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007oo
Ool037oo00<007ooOol02goo002TOol00`00Oomoo`0BOol30[lFOol20[meOol00:Aoo`03001oogoo
011oo`82_a]oo`82_g=oo`00Y7oo00<007ooOol03goo00<2_gooOol07Goo0P:oLGoo002TOol00`00
Oomoo`0>Ool00`:oOomoo`0POol20[m_Ool00:Aoo`03001oogoo00eoo`030[moogoo02=oo`82_feo
o`00Y7oo00<007ooOol02goo0P:o:7oo00<2_gooOol0JWoo002TOol00`00Oomoo`09Ool20[l[Ool2
0[mZOol00:Aoo`8000Uoo`030[moogoo02eoo`030[moogoo06Moo`00Y7oo00<007ooOol01goo00<2
_gooOol0;goo0P:oIgoo002TOol00`00Oomoo`06Ool00`:oOomoo`0bOol20[mUOol00:Aoo`03001o
ogoo00Ioo`030[moogoo03Aoo`030[moogoo069oo`00Y7oo00<007ooOol01Goo00<2_gooOol0=Woo
00<2_gooOol0HGoo002TOol00`00Oomoo`04Ool00`:oOomoo`0hOol00`:oOomoo`1POol00:Aoo`03
001oogoo00=oo`030[moogoo03Yoo`82_f1oo`00Y7oo00<007ooOol00Woo00<2_gooOol0?Goo00<2
_gooOol0GGoo002TOol01@00Oomoogoo0[l0@Goo00<2_gooOol0G7oo002TOol01@00Oomoogoo0[l0
@Woo00<2_gooOol0Fgoo002TOol200000goo0[moo`13Ool00`:oOomoo`1JOol00:Aoo`03001oo`:o
04Ioo`82_eYoo`00Y7oo00<000:oOol0B7oo00<2_gooOol0Egoo002TOol00`000[moo`19Ool00`:o
Oomoo`1FOol00:Aoo`030[moogoo04Yoo`030[moogoo05Eoo`00Xgoo00<2_`00Ool0C7oo00<2_goo
Ool0E7oo002ROol00`:oOol0001>Ool20[mDOol00:9oo`030[moo`00051oo`030[moogoo055oo`00
XGoo00@2_gooOol0055oo`030[moogoo051oo`00XGoo00@2_gooOol0059oo`030[moogoo04moo`00
X7oo00@2_gooOomoo`80059oo`030[moogoo04ioo`00X7oo00D2_gooOomoo`0005Aoo`82_dioo`00
Wgoo00<2_gooOol00Woo00<007ooOol0E7oo00<2_gooOol0Bgoo002OOol00`:oOomoo`02Ool00`00
Oomoo`1EOol00`:oOomoo`1:Ool009ioo`030[moogoo00=oo`03001oogoo05Ioo`030[moogoo04Uo
o`00WWoo00<2_gooOol00goo00<007ooOol0Egoo00<2_gooOol0B7oo002MOol00`:oOomoo`04Ool0
0`00Oomoo`1HOol20[m8Ool008Yoo`@000Eoo`8000Aoo`@000030[moogoo00Aoo`03001oogoo05Yo
o`030[moogoo04Eoo`00RGoo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00D007ooOol2_`00
00Ioo`03001oogoo05]oo`030[moogoo04Aoo`00RGoo00<007ooOol00Woo00<007ooOol02Goo00<0
07oo0[l01goo00<007ooOol0G7oo00<2_gooOol0@goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:
Ool00`:oOomoo`06Ool3001MOol00`:oOomoo`12Ool008Uoo`03001oogoo009oo`03001oogoo00Yo
o`030[l007oo00Ioo`03001oogoo05ioo`82_d9oo`00RGoo00<007ooOol00Woo00<007ooOol02Goo
00@2_gooOol000Ioo`03001oogoo061oo`030[moogoo03moo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D000:oOomoo`0000Ioo`03001oogoo065oo`030[moogoo03ioo`00RWoo10002goo00@2
_`00000000Moo`03001oogoo069oo`030[moogoo03eoo`00VGoo00<2_gooOol027oo00<007ooOol0
Hgoo0P:o?Goo002HOol00`:oOomoo`09Ool00`00Oomoo`1UOol20[lkOol009Qoo`030[moogoo00Uo
o`03001oogoo06Moo`030[moogoo03Qoo`00Ugoo00<2_gooOol02Woo00<007ooOol0J7oo0P:o>7oo
002GOol00`:oOomoo`0:Ool00`00Oomoo`1ZOol00`:oOomoo`0eOol009Ioo`030[moogoo00]oo`80
06aoo`82_cEoo`00UWoo00<2_gooOol02goo00<007ooOol0KGoo0P:o<goo002FOol00`:oOomoo`0;
Ool00`00Oomoo`1_Ool00`:oOomoo`0`Ool009Eoo`030[moogoo00aoo`03001oogoo071oo`82_c1o
o`00UGoo00<2_gooOol037oo00<007ooOol0LWoo00<2_gooOol07Woo0P:o3Goo002EOol00`:oOomo
o`0<Ool00`00Oomoo`1cOol20[lLOol20[l?Ool009Aoo`030[moogoo00eoo`03001oogoo07Eoo`82
_aUoo`030[moogoo00moo`00U7oo00<2_gooOol03Goo00<007ooOol0Mgoo10:o4goo0P:o4Woo002D
Ool00`:oOomoo`0=Ool00`00Oomoo`1kOol60[l7Ool60[lDOol009=oo`030[moogoo00ioo`80089o
o`L2_aYoo`00Tgoo00<2_gooOol03Woo00<007ooOol0XWoo002COol00`:oOomoo`0>Ool00`00Oomo
o`2ROol0099oo`030[moogoo00moo`03001oogoo0:9oo`00TWoo00<2_gooOol03goo00<007ooOol0
XWoo002BOol00`:oOomoo`0?Ool00`00Oomoo`2ROol0095oo`030[moogoo011oo`03001oogoo0:9o
o`00TGoo00<2_gooOol047oo00<007ooOol0XWoo002@Ool00`:oOomoo`0AOol00`00Oomoo`2ROol0
091oo`030[moogoo015oo`03001oogoo0:9oo`00T7oo00<2_gooOol04Goo0P00Xgoo002?Ool00`:o
Oomoo`0BOol00`00Oomoo`2ROol008moo`030[moogoo019oo`03001oogoo0:9oo`00Sgoo00<2_goo
Ool04Woo00<007ooOol0XWoo002>Ool00`:oOomoo`0COol00`00Oomoo`2ROol008ioo`030[moogoo
01=oo`03001oogoo0:9oo`00SWoo00<2_gooOol04goo00<007ooOol0XWoo002:Ool300000`:oOomo
o`03Ool20007Ool30005Ool00`00Oomoo`2ROol008Uoo`06001oogooOol2_`0017oo0P0027oo00<0
07ooOol017oo00<007ooOol0XWoo0029Ool01P00Oomoogoo0[l000ioo`03001oogoo00Aoo`03001o
ogoo0:9oo`00RGoo00H007ooOol2_goo000:Ool60005Ool3002ROol008Uoo`06001oogoo0[moo`00
2goo00@007ooOol000Ioo`03001oogoo0:9oo`00RGoo00H007ooOol2_goo000;Ool01000Oomoo`00
1Woo00<007ooOol0XWoo0029Ool00`00Ool2_`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00
Oomoo`2ROol008Yoo`040002_`00000>Ool20006Ool00`00Oomoo`2ROol008]oo`030[moogoo01Io
o`03001oogoo0:9oo`00RWoo00<2_gooOol05goo00<007ooOol0XWoo002:Ool00`:oOomoo`0GOol0
0`00Oomoo`2ROol008Yoo`030[moogoo01Moo`03001oogoo0:9oo`00RWoo00<2_gooOol05goo00<0
07ooOol0XWoo0029Ool00`:oOomoo`0HOol2002SOol008Uoo`030[moogoo01Qoo`03001oogoo0:9o
o`00RGoo00<2_gooOol067oo00<007ooOol0XWoo0028Ool00`:oOomoo`0IOol00`00Oomoo`2ROol0
08Qoo`030[moogoo01Uoo`03001oogoo0:9oo`00R7oo00<2_gooOol06Goo00<007ooOol0XWoo0028
Ool00`:oOomoo`0IOol00`00Oomoo`2ROol008Moo`030[moogoo01Yoo`03001oogoo0:9oo`00Qgoo
00<2_gooOol06Woo00<007ooOol0XWoo0027Ool00`:oOomoo`0JOol00`00Oomoo`2ROol008Ioo`03
0[moogoo01]oo`800:=oo`00QWoo00<2_gooOol06goo00<007ooOol0XWoo0026Ool00`:oOomoo`0K
Ool00`00Oomoo`2ROol008Ioo`030[moogoo01]oo`03001oogoo0:9oo`00QGoo00<2_gooOol077oo
00<007ooOol0XWoo0025Ool00`:oOomoo`0LOol00`00Oomoo`2ROol008Eoo`030[moogoo01aoo`03
001oogoo0:9oo`00Q7oo00<2_gooOol07Goo00<007ooOol0XWoo0024Ool00`:oOomoo`0MOol00`00
Oomoo`2ROol008Aoo`030[moogoo01eoo`03001oogoo0:9oo`00Q7oo00<2_gooOol07Goo0P00Xgoo
0023Ool00`:oOomoo`0NOol00`00Oomoo`2ROol008=oo`030[moogoo01ioo`03001oogoo0:9oo`00
Pgoo00<2_gooOol07Woo00<007ooOol0XWoo0022Ool00`:oOomoo`0OOol00`00Oomoo`2ROol0089o
o`030[moogoo01moo`03001oogoo0:9oo`00PWoo00<2_gooOol07goo00<007ooOol0XWoo0022Ool0
0`:oOomoo`0OOol00`00Oomoo`2ROol0085oo`030[moogoo021oo`03001oogoo0:9oo`00PGoo00<2
_gooOol087oo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.37923 .61803 m
.3815 .60802 L
.42237 .46926 L
.44268 .41472 L
.46172 .37164 L
.48111 .33523 L
.49955 .30715 L
.5198 .28315 L
.53832 .26698 L
.54791 .26064 L
.55813 .25531 L
.56309 .25323 L
.56777 .25156 L
.57229 .25022 L
.57652 .2492 L
.58117 .24832 L
.58364 .24797 L
.58628 .24766 L
.58761 .24754 L
.58905 .24743 L
.59041 .24734 L
.59168 .24728 L
.59281 .24725 L
.59406 .24722 L
.59537 .24721 L
.59659 .24722 L
.59767 .24725 L
.59885 .24728 L
.60009 .24734 L
.60123 .24741 L
.60329 .24756 L
.60548 .24777 L
.6105 .24844 L
.61507 .24927 L
.62505 .25175 L
.63425 .25483 L
.65505 .26426 L
.67381 .27531 L
.69445 .28969 L
.73479 .32226 L
.77362 .35569 L
.81489 .3889 L
.83552 .40313 L
.85465 .41421 L
.87318 .42253 L
.88353 .42598 L
.8929 .42829 L
.89779 .42916 L
.90046 .42954 L
.90295 .42983 L
Mistroke
.90508 .43002 L
.90735 .43018 L
.90865 .43025 L
.90988 .43029 L
.91099 .43032 L
.91218 .43033 L
.91347 .43033 L
.91468 .43031 L
.91538 .4303 L
.91601 .43027 L
.91744 .43021 L
.91874 .43013 L
.92015 .43003 L
.92301 .42974 L
.92552 .42941 L
.9282 .42898 L
.93302 .42799 L
.93836 .42655 L
.94329 .42491 L
.9544 .42002 L
.9642 .41431 L
.97457 .40676 L
.97619 .40543 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Oonl00050Imo0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00Eoo`H1W`04Ool007ooOol50Il7Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00
Oomoo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00
Oomoo`0;Ool000aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00eoo`03001oogoo00aoo`03001oogoo009oo`<1W`Moo`03001oogoo00Eoo`<1W`Ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00Y7oo00<007ooOol03goo0P6O5Goo
0`6ONGoo002TOol00`00Oomoo`0=Ool20IlJOol20ImgOol00:Aoo`03001oogoo00aoo`030Imoogoo
01aoo`81WgEoo`00Y7oo00<007ooOol02Woo0P6O8Goo0P6OLgoo002TOol00`00Oomoo`09Ool00`6O
Oomoo`0SOol20ImaOol00:Aoo`03001oogoo00Qoo`030Imoogoo02Ioo`81Wfmoo`00Y7oo00<007oo
Ool01goo00<1WgooOol0:Goo0P6OKGoo002TOol20006Ool20Il^Ool20Im[Ool00:Aoo`03001oogoo
00Aoo`030Imoogoo031oo`030Imoogoo06Qoo`00Y7oo00<007ooOol00goo00<1WgooOol0<Woo00<1
WgooOol0Igoo002TOol00`00Oomoo`02Ool00`6OOomoo`0dOol20ImWOol00:Aoo`05001oogooOol1
W`0iOol00`6OOomoo`1TOol00:Aoo`04001oogoo0IlkOol00`6OOomoo`1SOol00:Aoo`03001oo`6O
03eoo`030Imoogoo069oo`00Y7oo00<0006OOol0?Woo0P6OHWoo002TOol00`6OOomoo`10Ool00`6O
Oomoo`1OOol00:=oo`030Il007oo049oo`030Imoogoo05ioo`00XWoo00@1Wgoo000004=oo`030Imo
ogoo05eoo`00XWoo00<1Wgoo0000AGoo00<1WgooOol0G7oo002QOol0106OOomoo`00AWoo0P6OG7oo
002QOol0106OOomoo`00B7oo00<1WgooOol0FGoo002POol01@6OOomoogoo0000BGoo00<1WgooOol0
F7oo002POol01@6OOomoogoo0000BWoo00<1WgooOol0Egoo002OOol00`6OOomoo`02Ool00`00Oomo
o`19Ool00`6OOomoo`1FOol009moo`030Imoogoo009oo`03001oogoo04Yoo`81WeIoo`00WWoo00<1
WgooOol00goo00<007ooOol0C7oo00<1WgooOol0Dgoo002MOol00`6OOomoo`04Ool00`00Oomoo`1=
Ool00`6OOomoo`1BOol009eoo`030Imoogoo00Aoo`8004moo`030Imoogoo055oo`00W7oo00<1Wgoo
Ool01Goo00<007ooOol0Cgoo00<1WgooOol0D7oo002LOol00`6OOomoo`05Ool00`00Oomoo`1@Ool2
0Im@Ool009]oo`030Imoogoo00Ioo`03001oogoo059oo`030Imoogoo04eoo`00VWoo00<1WgooOol0
1goo00<007ooOol0Dgoo00<1WgooOol0C7oo002JOol00`6OOomoo`07Ool00`00Oomoo`1DOol00`6O
Oomoo`1;Ool009Uoo`030Imoogoo00Qoo`03001oogoo05Eoo`030Imoogoo04Yoo`00RWoo10001Goo
0P0017oo00<1W`0000000P001Woo00<007ooOol0EWoo00<1WgooOol0BGoo0029Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool20003Ool00`6O001oo`02Ool00`00Oomoo`04Ool00`00Oomoo`1GOol20Im9
Ool008Uoo`03001oogoo009oo`03001oogoo00Moo`030Imoo`0000Uoo`03001oogoo05Uoo`030Imo
ogoo04Ioo`00RGoo00<007ooOol00Woo00<007ooOol01Woo00D1WgooOomoo`0000Qoo`<005Yoo`03
0Imoogoo04Eoo`00RGoo00<007ooOol00Woo00<007ooOol01Woo00<1WgooOol00Woo00<007ooOol0
1Goo00<007ooOol0Fgoo00<1WgooOol0A7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`6O
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`1LOol00`6OOomoo`13Ool008Uoo`03001oogoo009o
o`03001oogoo00Eoo`040Imoogoo0003Ool00`00Oomoo`04Ool00`00Oomoo`1MOol20Im3Ool008Yo
o`@000Moo`030Imoogoo009oo`<000Moo`03001oogoo05moo`030Imoogoo041oo`00UGoo00<1Wgoo
Ool037oo00<007ooOol0H7oo00<1WgooOol0?goo002DOol00`6OOomoo`0=Ool00`00Oomoo`1QOol0
0`6OOomoo`0nOol009Aoo`030Imoogoo00eoo`03001oogoo069oo`81Wcioo`00U7oo00<1WgooOol0
3Goo00<007ooOol0I7oo00<1WgooOol0>goo002COol00`6OOomoo`0>Ool00`00Oomoo`1UOol20Ilk
Ool009=oo`030Imoogoo00ioo`8006Qoo`030Imoogoo03Qoo`00TWoo00<1WgooOol03goo00<007oo
Ool0J7oo0P6O:Woo00<1WgooOol02goo002BOol00`6OOomoo`0?Ool00`00Oomoo`1ZOol20IlWOol0
0`6OOomoo`0<Ool0095oo`030Imoogoo011oo`03001oogoo06aoo`81Wb=oo`81W`moo`00TGoo00<1
WgooOol047oo00<007ooOol0KWoo0P6O7goo0P6O4Goo002AOol00`6OOomoo`0@Ool00`00Oomoo`1`
Ool20IlKOol20IlCOol0091oo`030Imoogoo015oo`03001oogoo079oo`<1WaIoo`81WaEoo`00T7oo
00<1WgooOol04Goo00<007ooOol0MGoo106O4Goo00<1WgooOol05Goo002@Ool00`6OOomoo`0AOol0
0`00Oomoo`1iOol40Il7Ool60IlHOol008moo`030Imoogoo019oo`8007ioo`L1Waioo`00Sgoo00<1
WgooOol04Woo00<007ooOol0XWoo002?Ool00`6OOomoo`0BOol00`00Oomoo`2ROol008ioo`030Imo
ogoo01=oo`03001oogoo0:9oo`00SWoo00<1WgooOol04goo00<007ooOol0XWoo002=Ool00`6OOomo
o`0DOol00`00Oomoo`2ROol008eoo`030Imoogoo01Aoo`03001oogoo0:9oo`00SGoo00<1WgooOol0
57oo00<007ooOol0XWoo002<Ool00`6OOomoo`0EOol00`00Oomoo`2ROol008aoo`030Imoogoo01Eo
o`03001oogoo0:9oo`00S7oo00<1WgooOol05Goo0P00Xgoo002;Ool00`6OOomoo`0FOol00`00Oomo
o`2ROol008]oo`030Imoogoo01Ioo`03001oogoo0:9oo`00Rgoo00<1WgooOol05Woo00<007ooOol0
XWoo002:Ool00`6OOomoo`0GOol00`00Oomoo`2ROol008Yoo`030Imoogoo01Moo`03001oogoo0:9o
o`00RWoo00<1WgooOol05goo00<007ooOol0XWoo002:Ool0106O000000001Goo0P001goo0`001Goo
00<007ooOol0XWoo0029Ool00`6OOomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`04Ool0
0`00Oomoo`2ROol008Uoo`030Imoogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo
0:9oo`00RGoo00<1WgooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0028Ool00`6O001oo`03
Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0028Ool00`6O001oo`03Ool00`00
Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0028Ool00`6O001oo`03Ool00`00Oomoo`0:
Ool00`00Ool00006Ool00`00Oomoo`2ROol008Moo`030Imoogoo00@000ioo`8000Ioo`03001oogoo
0:9oo`00Qgoo00<1WgooOol06Woo00<007ooOol0XWoo0027Ool00`6OOomoo`0JOol00`00Oomoo`2R
Ool008Moo`030Imoogoo01Yoo`03001oogoo0:9oo`00QWoo00<1WgooOol06goo00<007ooOol0XWoo
0026Ool00`6OOomoo`0KOol00`00Oomoo`2ROol008Ioo`030Imoogoo01]oo`800:=oo`00QGoo00<1
WgooOol077oo00<007ooOol0XWoo0025Ool00`6OOomoo`0LOol00`00Oomoo`2ROol008Eoo`030Imo
ogoo01aoo`03001oogoo0:9oo`00Q7oo00<1WgooOol07Goo00<007ooOol0XWoo0024Ool00`6OOomo
o`0MOol00`00Oomoo`2ROol008Aoo`030Imoogoo01eoo`03001oogoo0:9oo`00Q7oo00<1WgooOol0
7Goo00<007ooOol0XWoo0023Ool00`6OOomoo`0NOol00`00Oomoo`2ROol008=oo`030Imoogoo01io
o`03001oogoo0:9oo`00Pgoo00<1WgooOol07Woo0P00Xgoo0022Ool00`6OOomoo`0OOol00`00Oomo
o`2ROol0089oo`030Imoogoo01moo`03001oogoo0:9oo`00PWoo00<1WgooOol07goo00<007ooOol0
XWoo0022Ool00`6OOomoo`0OOol00`00Oomoo`2ROol0085oo`030Imoogoo021oo`03001oogoo0:9o
o`00PGoo00<1WgooOol087oo00<007ooOol0XWoo0021Ool00`6OOomoo`0POol00`00Oomoo`2ROol0
081oo`030Imoogoo025oo`03001oogoo0:9oo`00P7oo00<1WgooOol08Goo00<007ooOol0XWoo0020
Ool00`6OOomoo`0QOol2002SOol007moo`030Imoogoo029oo`03001oogoo0:9oo`00Ogoo00<1Wgoo
Ool08Woo00<007ooOol0XWoo001oOol00`6OOomoo`0ROol00`00Oomoo`2ROol007moo`030Imoogoo
029oo`03001oogoo0:9oo`00OWoo00<1WgooOol08goo00<007ooOol0XWoo001nOol00`6OOomoo`0S
Ool00`00Oomoo`2ROol007ioo`030Imoogoo02=oo`03001oogoo0:9oo`00OGoo00<1WgooOol097oo
00<007ooOol0XWoo001mOol00`6OOomoo`0TOol00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .1 1 r
.5 Mabswid
.36815 .61803 m
.3815 .56339 L
.42237 .4362 L
.44268 .3869 L
.46172 .34843 L
.48111 .3164 L
.49955 .29221 L
.50923 .2818 L
.5198 .27215 L
.53832 .2593 L
.54864 .25425 L
.558 .2509 L
.56318 .24952 L
.56591 .24893 L
.5688 .2484 L
.57132 .24802 L
.57409 .24769 L
.57531 .24757 L
.57662 .24746 L
.57783 .24738 L
.57897 .24732 L
.58019 .24727 L
.58083 .24725 L
.58153 .24723 L
.58222 .24722 L
.58295 .24721 L
.58425 .24722 L
.58546 .24724 L
.58659 .24727 L
.58782 .24732 L
.58914 .2474 L
.59212 .24763 L
.59494 .24793 L
.60021 .24871 L
.60523 .24971 L
.60986 .25084 L
.62033 .2541 L
.63909 .26218 L
.65973 .27393 L
.70007 .30329 L
.7389 .33603 L
.78017 .37112 L
.81993 .40075 L
.84001 .41276 L
.85818 .42132 L
.86834 .42498 L
.87789 .42761 L
.88315 .4287 L
.88798 .42946 L
.89051 .42977 L
Mistroke
.89328 .43003 L
.89468 .43013 L
.89618 .43022 L
.8969 .43025 L
.89759 .43028 L
.89888 .43031 L
.90002 .43033 L
.90125 .43033 L
.90242 .43032 L
.90348 .4303 L
.90466 .43025 L
.90596 .43019 L
.9073 .4301 L
.90856 .43 L
.91116 .42974 L
.91353 .42943 L
.91883 .4285 L
.92338 .42742 L
.92831 .42597 L
.93726 .42253 L
.94628 .41798 L
.95618 .41167 L
.97619 .39444 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Oonh000505n30005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo009oo`D0G`Aoo`D0G`]oo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]o
o`0037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007oo
Ool03Goo00<007ooOol037oo00<007oo05l00P1O2Woo00@007ooOomoo`<0G`Qoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00]oo`00Y7oo00<007ooOol02goo0`1O57oo0`1OOGoo002TOol0
0`00Oomoo`09Ool205lJOol305mjOol00:Aoo`03001oogoo00Moo`80Gamoo`80GgQoo`00Y7oo00<0
07ooOol01Woo00<0GgooOol08Goo0P1OMWoo002TOol00`00Oomoo`04Ool205lVOol00`1OOomoo`1c
Ool00:Aoo`03001oogoo00=oo`0305moogoo02Moo`80Gg=oo`00Y7oo00<007ooOol00Woo00<0Ggoo
Ool0:Woo00<0GgooOol0L7oo002TOol20002Ool00`1OOomoo`0/Ool205m`Ool00:Aoo`04001oogoo
05laOol00`1OOomoo`1]Ool00:Aoo`03001oo`1O03=oo`80Gfeoo`00Y7oo00<0001OOol0=Goo00<0
GgooOol0JWoo002TOol00`1OOomoo`0fOol00`1OOomoo`1YOol00:=oo`0305l007oo03Qoo`80GfUo
o`00XWoo00<0Ggoo0000>goo00<0GgooOol0IWoo002ROol00`1OOol0000lOol205mVOol00:5oo`04
05moogoo000nOol00`1OOomoo`1SOol00:1oo`0505moogooOol0000oOol00`1OOomoo`1ROol009mo
o`0305moogoo009oo`8003moo`0305moogoo065oo`00Wgoo00<0GgooOol00Woo00<007ooOol0?goo
0P1OHGoo002NOol00`1OOomoo`03Ool00`00Oomoo`11Ool00`1OOomoo`1NOol009eoo`0305moogoo
00Aoo`03001oogoo049oo`0305moogoo05eoo`00WGoo00<0GgooOol017oo00<007ooOol0@goo00<0
GgooOol0G7oo002LOol00`1OOomoo`05Ool00`00Oomoo`14Ool00`1OOomoo`1KOol009]oo`0305mo
ogoo00Ioo`03001oogoo04Eoo`80Ge]oo`00Vgoo00<0GgooOol01Woo00<007ooOol0Agoo00<0Ggoo
Ool0F7oo002JOol00`1OOomoo`07Ool00`00Oomoo`18Ool00`1OOomoo`1GOol009Yoo`0305moogoo
00Moo`03001oogoo04Uoo`0305moogoo05Ioo`00VGoo00<0GgooOol027oo0P00Bgoo00<0GgooOol0
EGoo002HOol00`1OOomoo`09Ool00`00Oomoo`1;Ool00`1OOomoo`1DOol009Qoo`0305moogoo00Uo
o`03001oogoo04aoo`80GeAoo`00Ugoo00<0GgooOol02Woo00<007ooOol0CWoo00<0GgooOol0DGoo
002FOol00`1OOomoo`0;Ool00`00Oomoo`1?Ool00`1OOomoo`1@Ool009Ioo`0305moogoo00]oo`03
001oogoo051oo`0305moogoo04moo`00UGoo00<0GgooOol037oo00<007ooOol0DGoo00<0GgooOol0
CWoo002:Ool40005Ool20000101OOomoogoo1@001Woo00<007ooOol0DWoo0P1OCWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool00`0005moo`03Ool01@00Oomoogoo00001Woo00<007ooOol0E7oo
00<0GgooOol0Bgoo0029Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`1OOomoo`03Ool00`00Oomo
o`07Ool00`00Oomoo`1EOol00`1OOomoo`1:Ool008Uoo`03001oogoo009oo`03001oogoo009oo`03
05moogoo00Eoo`03001oogoo00Ioo`<005Ioo`0305moogoo04Uoo`00RGoo00<007ooOol00Woo00<0
07ooOol00Woo00<0GgooOol01Woo00<007ooOol01Goo00<007ooOol0Egoo0P1OBGoo0029Ool00`00
Oomoo`02Ool01@00Oomoogoo05l02Woo00<007ooOol017oo00<007ooOol0FGoo00<0GgooOol0AWoo
0029Ool00`00Oomoo`02Ool01@00Oomoogoo05l01Woo00D007ooOomoo`0000Ioo`03001oogoo05Yo
o`80GdIoo`00RWoo10000goo00<0GgooOol01Woo0`001goo00<007ooOol0G7oo00<0GgooOol0@goo
002AOol00`1OOomoo`0@Ool00`00Oomoo`1MOol00`1OOomoo`12Ool0095oo`0305moogoo011oo`03
001oogoo05ioo`80Gd9oo`00T7oo00<0GgooOol04Goo00<007ooOol0H7oo00<0GgooOol0<Goo00<0
GgooOol02goo002@Ool00`1OOomoo`0AOol00`00Oomoo`1QOol205l`Ool00`1OOomoo`0<Ool008mo
o`0305moogoo019oo`03001oogoo06=oo`0305moogoo02aoo`0305moogoo00eoo`00Sgoo00<0Ggoo
Ool04Woo0P00IGoo0P1O:goo00<0GgooOol03Woo002?Ool00`1OOomoo`0BOol00`00Oomoo`1VOol0
0`1OOomoo`0WOol00`1OOomoo`0?Ool008ioo`0305moogoo01=oo`03001oogoo06Moo`80GbIoo`03
05moogoo011oo`00SWoo00<0GgooOol04goo00<007ooOol0JGoo00<0GgooOol08Woo00<0GgooOol0
4Goo002>Ool00`1OOomoo`0COol00`00Oomoo`1ZOol205lPOol205lDOol008eoo`0305moogoo01Ao
o`03001oogoo06aoo`80Gaaoo`80GaIoo`00SGoo00<0GgooOol057oo00<007ooOol0KWoo0`1O5Woo
0`1O67oo002<Ool00`1OOomoo`0EOol00`00Oomoo`1aOol305lAOol205lKOol008aoo`0305moogoo
01Eoo`03001oogoo07Aoo`D0G`Moo`D0Gaeoo`00S7oo00<0GgooOol05Goo0P00NWoo201O8Goo002;
Ool00`1OOomoo`0FOol00`00Oomoo`2ROol008]oo`0305moogoo01Ioo`03001oogoo0:9oo`00Rgoo
00<0GgooOol05Woo00<007ooOol0XWoo002:Ool00`1OOomoo`0GOol00`00Oomoo`2ROol008Yoo`03
05moogoo01Moo`03001oogoo0:9oo`00RWoo00<0GgooOol05goo00<007ooOol0XWoo0029Ool00`1O
Oomoo`0HOol00`00Oomoo`2ROol008Uoo`0305moogoo01Qoo`03001oogoo0:9oo`00RGoo00<0Ggoo
Ool067oo00<007ooOol0XWoo0028Ool00`1OOomoo`0IOol2002SOol008Qoo`0305moogoo01Uoo`03
001oogoo0:9oo`00R7oo00<0GgooOol06Goo00<007ooOol0XWoo0027Ool00`1OOomoo`0JOol00`00
Oomoo`2ROol008Moo`0305moogoo01Yoo`03001oogoo0:9oo`00Qgoo00<0GgooOol06Woo00<007oo
Ool0XWoo0026Ool00`1OOomoo`0KOol00`00Oomoo`2ROol008Ioo`0405moogooOol40005Ool20007
Ool30005Ool00`00Oomoo`2ROol008Ioo`0405moogoo0004Ool00`00Oomoo`02Ool20008Ool00`00
Oomoo`04Ool00`00Oomoo`2ROol008Eoo`0505moogooOol00004Ool00`00Oomoo`0<Ool00`00Oomo
o`04Ool00`00Oomoo`2ROol008Eoo`0505moogooOol00004Ool00`00Oomoo`08Ool60005Ool3002R
Ool008Eoo`0505moogooOol00004Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo
0024Ool00`1OOomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007oo
Ool0XWoo0024Ool00`1OOomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool0
0`00Oomoo`2ROol008Aoo`0305moogoo00=oo`@000ioo`8000Ioo`03001oogoo0:9oo`00Q7oo00<0
GgooOol07Goo00<007ooOol0XWoo0023Ool00`1OOomoo`0NOol00`00Oomoo`2ROol008=oo`0305mo
ogoo01ioo`03001oogoo0:9oo`00Pgoo00<0GgooOol07Woo00<007ooOol0XWoo0022Ool00`1OOomo
o`0OOol00`00Oomoo`2ROol0089oo`0305moogoo01moo`800:=oo`00PWoo00<0GgooOol07goo00<0
07ooOol0XWoo0021Ool00`1OOomoo`0POol00`00Oomoo`2ROol0085oo`0305moogoo021oo`03001o
ogoo0:9oo`00PGoo00<0GgooOol087oo00<007ooOol0XWoo0020Ool00`1OOomoo`0QOol00`00Oomo
o`2ROol0081oo`0305moogoo025oo`03001oogoo0:9oo`00P7oo00<0GgooOol08Goo00<007ooOol0
XWoo001oOol00`1OOomoo`0ROol00`00Oomoo`2ROol007moo`0305moogoo029oo`03001oogoo0:9o
o`00Ogoo00<0GgooOol08Woo0P00Xgoo001nOol00`1OOomoo`0SOol00`00Oomoo`2ROol007ioo`03
05moogoo02=oo`03001oogoo0:9oo`00OWoo00<0GgooOol08goo00<007ooOol0XWoo001nOol00`1O
Oomoo`0SOol00`00Oomoo`2ROol007eoo`0305moogoo02Aoo`03001oogoo0:9oo`00OGoo00<0Ggoo
Ool097oo00<007ooOol0XWoo001mOol00`1OOomoo`0TOol00`00Oomoo`2ROol007eoo`0305moogoo
02Aoo`03001oogoo0:9oo`00O7oo00<0GgooOol09Goo00<007ooOol0XWoo001lOol00`1OOomoo`0U
Ool2002SOol007aoo`0305moogoo02Eoo`03001oogoo0:9oo`00O7oo00<0GgooOol09Goo00<007oo
Ool0XWoo001kOol00`1OOomoo`0VOol00`00Oomoo`2ROol007]oo`0305moogoo02Ioo`03001oogoo
0:9oo`00Ngoo00<0GgooOol09Woo00<007ooOol0XWoo001kOol00`1OOomoo`0VOol00`00Oomoo`2R
Ool007Yoo`0305moogoo02Moo`03001oogoo0:9oo`00NWoo00<0GgooOol09goo00<007ooOol0XWoo
001jOol00`1OOomoo`0WOol00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 0 1 r
.5 Mabswid
.35621 .61803 m
.3815 .52228 L
.40095 .46237 L
.42237 .40625 L
.46172 .32794 L
.48113 .30009 L
.502 .27732 L
.51211 .26878 L
.52314 .26121 L
.53356 .25565 L
.54323 .25181 L
.5483 .25027 L
.5538 .24897 L
.55632 .2485 L
.55898 .24808 L
.56128 .24779 L
.56375 .24754 L
.56498 .24744 L
.56615 .24737 L
.56729 .24731 L
.56834 .24727 L
.56933 .24724 L
.57039 .24722 L
.57145 .24721 L
.57262 .24722 L
.57388 .24725 L
.57504 .24728 L
.57631 .24734 L
.57764 .24742 L
.5799 .2476 L
.58236 .24785 L
.58764 .2486 L
.59263 .24956 L
.60197 .25197 L
.61202 .25543 L
.62292 .2601 L
.66384 .28473 L
.70324 .31571 L
.74113 .34825 L
.78147 .38162 L
.82029 .40838 L
.83042 .41399 L
.84147 .4193 L
.85202 .4235 L
.86157 .4265 L
.86645 .42772 L
.87173 .42879 L
.87415 .42919 L
.8767 .42955 L
.8791 .42982 L
Mistroke
.88128 .43002 L
.88248 .43011 L
.88378 .43019 L
.8845 .43023 L
.88516 .43026 L
.88646 .4303 L
.88758 .43033 L
.88881 .43033 L
.89009 .43033 L
.89129 .4303 L
.89193 .43028 L
.89264 .43026 L
.89405 .43019 L
.89536 .4301 L
.89658 .43001 L
.89933 .42973 L
.90227 .42933 L
.90761 .42835 L
.91254 .42714 L
.92365 .42327 L
.93345 .4185 L
.94382 .41199 L
.96055 .39813 L
.97619 .38117 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Oond000551n70005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`HD7`Aoo`HD7`ioo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`0037oo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool02Goo0a@O00<007ooOol037oo00@001@O51lD7`]oo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00]oo`00Y7oo00<007ooOol01goo0Q@O5Woo0Q@OPGoo002TOol00`00Oomoo`05Ool251lJ
Ool251moOol00:Aoo`03001oogoo00Aoo`0351moogoo01aoo`8D7geoo`00Y7oo00<007ooOol00Woo
0Q@O8Goo0Q@ONgoo002TOol00`00Oomoo`0251lUOol251miOol00:Aoo`03001ooa@O02Uoo`8D7gMo
o`00Y7oo00<001@OOol0:goo0Q@OMGoo002TOol00a@O001oo`0]Ool251mcOol00:=oo`0351l007oo
031oo`8D7g5oo`00XWoo00<D7goo0000<goo00<D7gooOol0KWoo002QOol011@OOomoo`00=7oo00<D
7gooOol0KGoo002QOol011@OOomoo`00=Goo00<D7gooOol0K7oo002POol01A@OOomoogoo0000=Woo
0Q@OK7oo002OOol00a@OOomoo`02Ool00`00Oomoo`0fOol00a@OOomoo`1YOol009ioo`0351moogoo
00=oo`03001oogoo03Moo`0351moogoo06Qoo`00WGoo00<D7gooOol017oo00<007ooOol0>7oo00<D
7gooOol0Igoo002LOol00a@OOomoo`05Ool00`00Oomoo`0iOol00a@OOomoo`1VOol009aoo`0351mo
ogoo00Eoo`8003]oo`8D7fIoo`00Vgoo00<D7gooOol01Woo00<007ooOol0?7oo00<D7gooOol0Hgoo
002JOol00a@OOomoo`07Ool00`00Oomoo`0mOol00a@OOomoo`1ROol009Uoo`0351moogoo00Qoo`03
001oogoo03ioo`0351moogoo065oo`00VGoo00<D7gooOol027oo00<007ooOol0?goo00<D7gooOol0
H7oo002HOol00a@OOomoo`09Ool00`00Oomoo`10Ool00a@OOomoo`1OOol009Moo`0351moogoo00Yo
o`03001oogoo045oo`0351moogoo05ioo`00Ugoo00<D7gooOol02Woo00<007ooOol0@Woo00<D7goo
Ool0GGoo002FOol00a@OOomoo`0;Ool00`00Oomoo`13Ool251mMOol009Ioo`0351moogoo00]oo`03
001oogoo04Eoo`0351moogoo05Yoo`00UGoo00<D7gooOol037oo0P00Agoo00<D7gooOol0FGoo002E
Ool00a@OOomoo`0<Ool00`00Oomoo`17Ool00a@OOomoo`1HOol009Aoo`0351moogoo00eoo`03001o
ogoo04Qoo`0351moogoo05Moo`00U7oo00<D7gooOol03Goo00<007ooOol0BGoo00<D7gooOol0EWoo
002COol00a@OOomoo`0>Ool00`00Oomoo`1:Ool00a@OOomoo`1EOol009=oo`0351moogoo00ioo`03
001oogoo04]oo`8D7eEoo`00TWoo00<D7gooOol03goo00<007ooOol0CGoo00<D7gooOol0DWoo002:
Ool40004Ool00a@O00000004Ool50006Ool00`00Oomoo`1>Ool00a@OOomoo`1AOol008Uoo`03001o
ogoo009oo`05001oogoo51moo`020004Ool01@00Oomoogoo00001Woo00<007ooOol0Cgoo0Q@ODGoo
0029Ool00`00Oomoo`02Ool01000Oomooa@O27oo00<007ooOol01goo00<007ooOol0DGoo00<D7goo
Ool0CWoo0029Ool00`00Oomoo`02Ool00`00OolD7`0:Ool00`00Oomoo`06Ool3001BOol00a@OOomo
o`1=Ool008Uoo`03001oogoo009oo`03001ooa@O00]oo`03001oogoo00Eoo`03001oogoo05=oo`8D
7deoo`00RGoo00<007ooOol00Woo00<001@OOol037oo00<007ooOol017oo00<007ooOol0EGoo00<D
7gooOol0BWoo0029Ool00`00Oomoo`02Ool00`0051moo`08Ool01@00Oomoogoo00001Woo00<007oo
Ool0EWoo00<D7gooOol0>goo00<D7gooOol02goo002:Ool400000a@OOomoo`09Ool30007Ool00`00
Oomoo`1GOol251ljOol00a@OOomoo`0<Ool008ioo`0351moogoo01=oo`03001oogoo05Uoo`0351mo
ogoo03Ioo`0351moogoo00eoo`00SGoo00<D7gooOol057oo00<007ooOol0FWoo0Q@O=Goo00<D7goo
Ool03Woo002=Ool00a@OOomoo`0DOol00`00Oomoo`1LOol00a@OOomoo`0aOol00a@OOomoo`0?Ool0
08aoo`0351moogoo01Eoo`03001oogoo05eoo`0351moogoo02moo`0351moogoo011oo`00S7oo00<D
7gooOol05Goo00<007ooOol0GWoo0Q@O;Woo00<D7gooOol04Goo002;Ool00a@OOomoo`0FOol2001Q
Ool00a@OOomoo`0ZOol00a@OOomoo`0BOol008]oo`0351moogoo01Ioo`03001oogoo065oo`8D7bUo
o`0351moogoo01=oo`00Rgoo00<D7gooOol05Woo00<007ooOol0Hgoo00<D7gooOol09Goo00<D7goo
Ool057oo002:Ool00a@OOomoo`0GOol00`00Oomoo`1TOol251lTOol00a@OOomoo`0EOol008Yoo`03
51moogoo01Moo`03001oogoo06Ioo`8D7b1oo`8D7aQoo`00RGoo00<D7gooOol067oo00<007ooOol0
J7oo0Q@O77oo0Q@O6Woo0029Ool00a@OOomoo`0HOol00`00Oomoo`1ZOol251lHOol251lLOol008Uo
o`0351moogoo01Qoo`03001oogoo06aoo`<D7a=oo`8D7aioo`00R7oo00<D7gooOol06Goo00<007oo
Ool0Kgoo1a@O1goo1A@O87oo0028Ool00a@OOomoo`0IOol2001fOol851lUOol008Moo`0351moogoo
01Yoo`03001oogoo0:9oo`00Qgoo00<D7gooOol06Woo00<007ooOol0XWoo0027Ool00a@OOomoo`0J
Ool00`00Oomoo`2ROol008Ioo`0351moogoo01]oo`03001oogoo0:9oo`00QWoo00<D7gooOol06goo
00<007ooOol0XWoo0026Ool00a@OOomoo`0KOol00`00Oomoo`2ROol008Eoo`0351moogoo01aoo`03
001oogoo0:9oo`00QGoo00<D7gooOol077oo00<007ooOol0XWoo0024Ool00a@OOomoo`0MOol00`00
Oomoo`2ROol008Aoo`0351moogoo01eoo`800:=oo`00Q7oo00<D7gooOol07Goo00<007ooOol0XWoo
0023Ool00a@OOomoo`0NOol00`00Oomoo`2ROol008=oo`0351moogoo01ioo`03001oogoo0:9oo`00
Pgoo00<D7gooOol07Woo00<007ooOol0XWoo0022Ool00a@OOomoo`0OOol00`00Oomoo`2ROol0089o
o`0351moogoo01moo`03001oogoo0:9oo`00PWoo00<D7gooOol01Goo10001Goo0P001goo0`001Goo
00<007ooOol0XWoo0021Ool00a@OOomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool0
0`00Oomoo`04Ool00`00Oomoo`2ROol0085oo`0351moogoo00Eoo`03001oogoo009oo`03001oogoo
00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00PGoo00<D7gooOol01Goo00<007ooOol00Woo00<0
07ooOol027oo1P001Goo0`00XWoo0021Ool00a@OOomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool01000Oomoo`001Woo00<007ooOol0XWoo0020Ool00a@OOomoo`06Ool00`00Oomoo`02Ool00`00
Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0020Ool00a@OOomoo`06Ool00`00Oomoo`02
Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol0081oo`0351moogoo00Moo`@000io
o`8000Ioo`03001oogoo0:9oo`00Ogoo00<D7gooOol08Woo00<007ooOol0XWoo001oOol00a@OOomo
o`0ROol00`00Oomoo`2ROol007moo`0351moogoo029oo`03001oogoo0:9oo`00OWoo00<D7gooOol0
8goo00<007ooOol0XWoo001nOol00a@OOomoo`0SOol00`00Oomoo`2ROol007ioo`0351moogoo02=o
o`800:=oo`00OGoo00<D7gooOol097oo00<007ooOol0XWoo001mOol00a@OOomoo`0TOol00`00Oomo
o`2ROol007eoo`0351moogoo02Aoo`03001oogoo0:9oo`00OGoo00<D7gooOol097oo00<007ooOol0
XWoo001lOol00a@OOomoo`0UOol00`00Oomoo`2ROol007aoo`0351moogoo02Eoo`03001oogoo0:9o
o`00O7oo00<D7gooOol09Goo00<007ooOol0XWoo001lOol00a@OOomoo`0UOol00`00Oomoo`2ROol0
07]oo`0351moogoo02Ioo`03001oogoo0:9oo`00Ngoo00<D7gooOol09Woo0P00Xgoo001kOol00a@O
Oomoo`0VOol00`00Oomoo`2ROol007]oo`0351moogoo02Ioo`03001oogoo0:9oo`00NWoo00<D7goo
Ool09goo00<007ooOol0XWoo001jOol00a@OOomoo`0WOol00`00Oomoo`2ROol007Yoo`0351moogoo
02Moo`03001oogoo0:9oo`00NGoo00<D7gooOol0:7oo00<007ooOol0XWoo001iOol00a@OOomoo`0X
Ool00`00Oomoo`2ROol007Uoo`0351moogoo02Qoo`03001oogoo0:9oo`00NGoo00<D7gooOol0:7oo
00<007ooOol0XWoo001hOol00a@OOomoo`0YOol2002SOol007Qoo`0351moogoo02Uoo`03001oogoo
0:9oo`00N7oo00<D7gooOol0:Goo00<007ooOol0XWoo001hOol00a@OOomoo`0YOol00`00Oomoo`2R
Ool007Moo`0351moogoo02Yoo`03001oogoo0:9oo`00Mgoo00<D7gooOol0:Woo00<007ooOol0XWoo
001gOol00a@OOomoo`0ZOol00`00Oomoo`2ROol007Moo`0351moogoo02Yoo`03001oogoo0:9oo`00
MWoo00<D7gooOol0:goo00<007ooOol0XWoo001fOol00a@OOomoo`0[Ool00`00Oomoo`2ROol00001
\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 0 1 r
.5 Mabswid
.34326 .61803 m
.3815 .48456 L
.40095 .42994 L
.42237 .3793 L
.44292 .33949 L
.46172 .31007 L
.48113 .28623 L
.49195 .27563 L
.502 .26743 L
.51196 .26078 L
.52099 .25596 L
.53102 .25191 L
.53653 .25024 L
.54171 .24901 L
.54637 .24818 L
.54901 .24783 L
.55148 .24757 L
.55281 .24746 L
.55408 .24738 L
.55522 .24732 L
.55645 .24727 L
.55709 .24725 L
.5578 .24723 L
.55853 .24722 L
.55923 .24721 L
.56046 .24722 L
.56115 .24723 L
.56179 .24724 L
.56287 .24727 L
.56402 .24732 L
.56609 .24745 L
.56855 .24765 L
.57079 .24789 L
.57566 .24859 L
.58026 .24946 L
.58998 .25195 L
.60028 .25549 L
.61873 .26395 L
.65662 .28812 L
.69696 .32046 L
.73578 .35388 L
.77706 .38733 L
.79769 .40177 L
.81682 .4131 L
.83534 .42171 L
.84569 .42535 L
.85506 .42784 L
.85995 .42881 L
.86262 .42924 L
.86511 .42959 L
Mistroke
.86742 .42985 L
.86952 .43004 L
.87185 .43019 L
.87313 .43025 L
.87435 .4303 L
.87555 .43032 L
.87687 .43033 L
.87753 .43033 L
.87825 .43033 L
.87954 .4303 L
.88076 .43026 L
.88204 .43019 L
.88433 .43004 L
.88702 .42977 L
.88952 .42946 L
.89518 .42846 L
.90025 .42724 L
.90573 .42556 L
.91568 .42151 L
.92536 .41628 L
.93428 .41029 L
.95308 .39373 L
.97373 .36894 L
.97619 .36551 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Oon`0006?1n:0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00Qo
o`Hl7`Aoo`Hl7`=oo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]o
o`0037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007oo
Ool03Goo00<007ooOol01Woo0S`O17oo00<007ooOol02Goo0c`O00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol02goo002TOol00`00Oomoo`03Ool3?1lEOol3?1n4Ool00:Ao
o`04001oogooOol2?1lKOol2?1n2Ool00:Aoo`04001oogoo?1lOOol2?1n0Ool00:Aoo`03000l7c`O
029oo`03?1moogoo07eoo`00Y7oo00<l7gooOol08goo0S`OOGoo002ROol2?1l00`00Oomoo`0UOol2
?1mkOol00:5oo`04?1moogoo000YOol2?1miOol00:1oo`04?1moogooOol2000ZOol2?1mgOol009mo
o`03?1moogoo009oo`03001oogoo02]oo`8l7gEoo`00Wgoo00<l7gooOol00Woo00<007ooOol0;Goo
0S`OLgoo002NOol00c`OOomoo`03Ool00`00Oomoo`0_Ool00c`OOomoo`1`Ool009eoo`03?1moogoo
00Aoo`03001oogoo031oo`03?1moogoo06moo`00W7oo00<l7gooOol01Goo00<007ooOol0<Goo00<l
7gooOol0KWoo002KOol00c`OOomoo`06Ool00`00Oomoo`0bOol00c`OOomoo`1]Ool009Yoo`03?1mo
ogoo00Moo`03001oogoo03=oo`03?1moogoo06aoo`00VGoo00<l7gooOol027oo00<007ooOol0=7oo
00<l7gooOol0Jgoo002HOol00c`OOomoo`09Ool00`00Oomoo`0eOol2?1m[Ool009Moo`03?1moogoo
00Yoo`8003Qoo`03?1moogoo06Qoo`00UWoo00<l7gooOol02goo00<007ooOol0>7oo00<l7gooOol0
Igoo002FOol00c`OOomoo`0;Ool00`00Oomoo`0iOol00c`OOomoo`1VOol009Eoo`03?1moogoo00ao
o`03001oogoo03Yoo`03?1moogoo06Eoo`00UGoo00<l7gooOol037oo00<007ooOol0>goo00<l7goo
Ool0I7oo002DOol00c`OOomoo`0=Ool00`00Oomoo`0lOol00c`OOomoo`1SOol009=oo`03?1moogoo
00ioo`03001oogoo03eoo`8l7f=oo`00Tgoo00<l7gooOol03Woo00<007ooOol0?goo00<l7gooOol0
H7oo002BOol00c`OOomoo`0?Ool00`00Oomoo`10Ool00c`OOomoo`1OOol0099oo`03?1moogoo00mo
o`03001oogoo045oo`8l7emoo`00TGoo00<l7gooOol047oo0P00A7oo00<l7gooOol0G7oo002@Ool0
0c`OOomoo`0AOol00`00Oomoo`14Ool00c`OOomoo`1KOol0091oo`03?1moogoo015oo`03001oogoo
04Eoo`8l7e]oo`00Sgoo00<l7gooOol04Woo00<007ooOol0Agoo00<l7gooOol0F7oo002?Ool00c`O
Oomoo`0BOol00`00Oomoo`18Ool00c`OOomoo`1GOol008ioo`03?1moogoo01=oo`03001oogoo04Uo
o`03?1moogoo05Ioo`00SWoo00<l7gooOol04goo00<007ooOol0BWoo00<l7gooOol0EGoo002:Ool3
00000c`OOomoo`03Ool20004Ool50006Ool00`00Oomoo`1;Ool2?1mEOol008Uoo`06001oogooOoll
7`0017oo0P0017oo00D007ooOomoo`0000Ioo`03001oogoo04eoo`03?1moogoo04Aoo`03?1moogoo
00]oo`00RGoo00H007ooOoll7goo000;Ool00`00Oomoo`07Ool00`00Oomoo`1>Ool00c`OOomoo`12
Ool00c`OOomoo`0<Ool008Uoo`06001oogoo?1moo`0037oo00<007ooOol01Woo0`00Cgoo00<l7goo
Ool0@7oo00<l7gooOol03Goo0029Ool00`00Ooll7`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool0
0`00Oomoo`1@Ool00c`OOomoo`0nOol00c`OOomoo`0>Ool008Uoo`03001ooc`O009oo`03001oogoo
00aoo`03001oogoo00Aoo`03001oogoo055oo`8l7cioo`03?1moogoo00ioo`00RGoo00<007oo?1l0
0Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo05=oo`03?1moogoo03Yoo`03?1mo
ogoo00moo`00RWoo00@l7`00000000aoo`<000Moo`03001oogoo05Aoo`03?1moogoo03Qoo`03?1mo
ogoo011oo`00RWoo00<l7gooOol05goo00<007ooOol0EGoo00<l7gooOol0=Woo00<l7gooOol04Goo
0029Ool00c`OOomoo`0HOol00`00Oomoo`1FOol00c`OOomoo`0eOol00c`OOomoo`0AOol008Uoo`03
?1moogoo01Qoo`03001oogoo05Moo`03?1moogoo03=oo`03?1moogoo019oo`00RGoo00<l7gooOol0
67oo00<007ooOol0F7oo0S`O<Woo00<l7gooOol04goo0028Ool00c`OOomoo`0IOol00`00Oomoo`1J
Ool00c`OOomoo`0^Ool00c`OOomoo`0DOol008Qoo`03?1moogoo01Uoo`8005aoo`8l7baoo`8l7aMo
o`00Qgoo00<l7gooOol06Woo00<007ooOol0GGoo0S`O:Goo00<l7gooOol05goo0027Ool00c`OOomo
o`0JOol00`00Oomoo`1OOol2?1lVOol00c`OOomoo`0HOol008Ioo`03?1moogoo01]oo`03001oogoo
065oo`8l7b9oo`8l7a]oo`00QWoo00<l7gooOol06goo00<007ooOol0Hgoo0S`O7goo00<l7gooOol0
6goo0026Ool00c`OOomoo`0KOol00`00Oomoo`1UOol2?1lKOol2?1lNOol008Eoo`03?1moogoo01ao
o`03001oogoo06Moo`8l7aMoo`8l7b1oo`00QGoo00<l7gooOol077oo00<007ooOol0JGoo13`O4Goo
0S`O8Woo0024Ool00c`OOomoo`0MOol00`00Oomoo`1]Ool5?1l7Ool5?1lTOol008Aoo`03?1moogoo
01eoo`8007=oo`Ll7bUoo`00Q7oo00<l7gooOol07Goo00<007ooOol0XWoo0023Ool00c`OOomoo`0N
Ool00`00Oomoo`2ROol008=oo`03?1moogoo01ioo`03001oogoo0:9oo`00Pgoo00<l7gooOol07Woo
00<007ooOol0XWoo0022Ool00c`OOomoo`0OOol00`00Oomoo`2ROol0089oo`03?1moogoo01moo`03
001oogoo0:9oo`00PWoo00<l7gooOol07goo00<007ooOol0XWoo0021Ool00c`OOomoo`0POol00`00
Oomoo`2ROol0085oo`03?1moogoo021oo`03001oogoo0:9oo`00P7oo00<l7gooOol08Goo0P00Xgoo
0020Ool00c`OOomoo`0QOol00`00Oomoo`2ROol0081oo`03?1moogoo025oo`03001oogoo0:9oo`00
Ogoo00<l7gooOol08Woo00<007ooOol0XWoo001oOol00c`OOomoo`0ROol00`00Oomoo`2ROol007mo
o`03?1moogoo029oo`03001oogoo0:9oo`00OWoo00<l7gooOol08goo00<007ooOol0XWoo001nOol0
0c`OOomoo`09Ool40005Ool20007Ool30005Ool00`00Oomoo`2ROol007ioo`03?1moogoo00Qoo`03
001oogoo009oo`03001oogoo009oo`8000Qoo`03001oogoo00Aoo`03001oogoo0:9oo`00OGoo00<l
7gooOol02Goo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol0XWoo001m
Ool00c`OOomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`08Ool60005Ool3002ROol007eoo`03?1mo
ogoo00Uoo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol007eo
o`03?1moogoo00Uoo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2R
Ool007aoo`03?1moogoo00Yoo`03001oogoo009oo`03001oogoo00Yoo`03001oo`0000Ioo`03001o
ogoo0:9oo`00O7oo00<l7gooOol02goo10003Woo0P001Woo00<007ooOol0XWoo001lOol00c`OOomo
o`0UOol00`00Oomoo`2ROol007]oo`03?1moogoo02Ioo`03001oogoo0:9oo`00Ngoo00<l7gooOol0
9Woo00<007ooOol0XWoo001kOol00c`OOomoo`0VOol00`00Oomoo`2ROol007]oo`03?1moogoo02Io
o`03001oogoo0:9oo`00NWoo00<l7gooOol09goo0P00Xgoo001jOol00c`OOomoo`0WOol00`00Oomo
o`2ROol007Yoo`03?1moogoo02Moo`03001oogoo0:9oo`00NGoo00<l7gooOol0:7oo00<007ooOol0
XWoo001iOol00c`OOomoo`0XOol00`00Oomoo`2ROol007Uoo`03?1moogoo02Qoo`03001oogoo0:9o
o`00NGoo00<l7gooOol0:7oo00<007ooOol0XWoo001hOol00c`OOomoo`0YOol00`00Oomoo`2ROol0
07Qoo`03?1moogoo02Uoo`03001oogoo0:9oo`00N7oo00<l7gooOol0:Goo00<007ooOol0XWoo001g
Ool00c`OOomoo`0ZOol2002SOol007Moo`03?1moogoo02Yoo`03001oogoo0:9oo`00Mgoo00<l7goo
Ool0:Woo00<007ooOol0XWoo001gOol00c`OOomoo`0ZOol00`00Oomoo`2ROol007Ioo`03?1moogoo
02]oo`03001oogoo0:9oo`00MWoo00<l7gooOol0:goo00<007ooOol0XWoo001fOol00c`OOomoo`0[
Ool00`00Oomoo`2ROol007Eoo`03?1moogoo02aoo`03001oogoo0:9oo`00MGoo00<l7gooOol0;7oo
00<007ooOol0XWoo001eOol00c`OOomoo`0/Ool00`00Oomoo`2ROol007Eoo`03?1moogoo02aoo`80
0:=oo`00M7oo00<l7gooOol0;Goo00<007ooOol0XWoo001dOol00c`OOomoo`0]Ool00`00Oomoo`2R
Ool007Aoo`03?1moogoo02eoo`03001oogoo0:9oo`00Lgoo00<l7gooOol0;Woo00<007ooOol0XWoo
001cOol00c`OOomoo`0^Ool00`00Oomoo`2ROol007=oo`03?1moogoo02ioo`03001oogoo0:9oo`00
Lgoo00<l7gooOol0;Woo00<007ooOol0XWoo001bOol00c`OOomoo`0_Ool00`00Oomoo`2ROol0079o
o`03?1moogoo02moo`03001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.8 0 1 r
.5 Mabswid
.33237 .61803 m
.34309 .5732 L
.3815 .45012 L
.40095 .4006 L
.42237 .35523 L
.44292 .32011 L
.46172 .29469 L
.48113 .27468 L
.49183 .26617 L
.502 .25964 L
.51159 .25482 L
.51685 .25271 L
.52181 .25104 L
.52644 .24977 L
.53145 .24869 L
.53367 .24831 L
.53601 .24797 L
.53801 .24773 L
.5402 .24752 L
.54152 .24742 L
.54274 .24734 L
.54391 .24729 L
.54515 .24725 L
.54626 .24722 L
.5473 .24721 L
.54844 .24722 L
.54967 .24724 L
.55091 .24727 L
.55161 .2473 L
.55226 .24733 L
.55498 .2475 L
.55732 .24772 L
.55983 .24801 L
.56478 .24876 L
.56944 .24969 L
.57817 .25197 L
.58789 .25531 L
.59818 .25967 L
.61664 .26941 L
.65452 .29552 L
.69486 .32885 L
.73369 .36219 L
.77496 .39444 L
.79559 .40786 L
.81472 .41797 L
.82427 .42203 L
.83325 .42518 L
.83822 .42662 L
.8436 .42793 L
.84812 .42882 L
Mistroke
.85297 .42956 L
.85555 .42985 L
.8579 .43006 L
.85903 .43014 L
.86026 .43021 L
.86143 .43026 L
.8625 .4303 L
.86374 .43033 L
.86491 .43033 L
.86619 .43033 L
.86691 .43032 L
.86757 .4303 L
.86882 .43026 L
.86953 .43023 L
.87019 .43019 L
.87151 .43011 L
.87295 .42999 L
.8757 .42971 L
.87829 .42936 L
.88314 .42849 L
.88881 .42711 L
.89402 .42549 L
.90374 .42152 L
.91283 .41666 L
.92343 .4095 L
.93348 .40117 L
.95381 .37943 L
.97236 .35347 L
.97619 .34734 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004Oon]0004I1n?0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00Eo
o`ET7`9oo`03001oof@O00IT7`Ioo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00]oo`0037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
3Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol00Woo0f@O1goo00<007ooOol01Woo0f@O0goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol02goo002TOol00`00OomT7`02I1lFOol3
I1n7Ool00:Aoo`9T7aaoo`9T7hEoo`00XWoo0V@O00<007ooOol07Goo0V@OPgoo002QOol016@OOomo
o`008Goo0V@OPGoo002POol01F@OOomoogoo00008goo0V@OOgoo002OOol00f@OOomoo`02Ool00`00
Oomoo`0SOol00f@OOomoo`1lOol009ioo`03I1moogoo00=oo`03001oogoo02Aoo`9T7gaoo`00WGoo
00=T7gooOol017oo0P009goo00=T7gooOol0NGoo002LOol00f@OOomoo`05Ool00`00Oomoo`0WOol0
0f@OOomoo`1hOol009]oo`03I1moogoo00Ioo`03001oogoo02Qoo`9T7gQoo`00VWoo00=T7gooOol0
1goo00<007ooOol0:Woo00=T7gooOol0MGoo002IOol00f@OOomoo`08Ool00`00Oomoo`0[Ool00f@O
Oomoo`1dOol009Qoo`03I1moogoo00Uoo`03001oogoo02aoo`9T7gAoo`00Ugoo00=T7gooOol02Woo
00<007ooOol0;Woo00=T7gooOol0LGoo002FOol00f@OOomoo`0;Ool00`00Oomoo`0_Ool00f@OOomo
o`1`Ool009Eoo`03I1moogoo00aoo`03001oogoo031oo`9T7g1oo`00UGoo00=T7gooOol037oo00<0
07ooOol0<Woo00=T7gooOol0KGoo002DOol00f@OOomoo`0=Ool2000dOol00f@OOomoo`1/Ool009=o
o`03I1moogoo00ioo`03001oogoo03Aoo`9T7faoo`00TWoo00=T7gooOol03goo00<007ooOol0=Woo
00=T7gooOol0JGoo002BOol00f@OOomoo`0?Ool00`00Oomoo`0gOol00f@OOomoo`1XOol0095oo`03
I1moogoo011oo`03001oogoo03Qoo`9T7fQoo`00T7oo00=T7gooOol04Goo00<007ooOol0>Woo00=T
7gooOol0IGoo002@Ool00f@OOomoo`0AOol00`00Oomoo`0kOol00f@OOomoo`1TOol008moo`03I1mo
ogoo019oo`03001oogoo03aoo`03I1moogoo06=oo`00Sgoo00=T7gooOol04Woo00<007ooOol0?Goo
00=T7gooOol0HWoo002>Ool00f@OOomoo`0COol00`00Oomoo`0nOol00f@OOomoo`1QOol008ioo`03
I1moogoo01=oo`80041oo`03I1moogoo061oo`00SGoo00=T7gooOol057oo00<007ooOol0@7oo00=T
7gooOol0Ggoo002=Ool00f@OOomoo`0DOol00`00Oomoo`11Ool2I1mAOol00f@OOomoo`0;Ool008ao
o`03I1moogoo01Eoo`03001oogoo04=oo`03I1moogoo04eoo`03I1moogoo00aoo`00S7oo00=T7goo
Ool05Goo00<007ooOol0A7oo00=T7gooOol0C7oo00=T7gooOol037oo002;Ool00f@OOomoo`0FOol0
0`00Oomoo`15Ool00f@OOomoo`1:Ool00f@OOomoo`0=Ool008Yoo`03I1moogoo01Moo`03001oogoo
04Ioo`03I1moogoo04Uoo`03I1moogoo00eoo`00RWoo00AT7`00000000Eoo`8000Aoo`D000Ioo`03
001oogoo04Moo`03I1moogoo04Moo`03I1moogoo00ioo`00RGoo00=T7gooOol00Woo00<007ooOol0
0Woo0P0017oo00D007ooOomoo`0000Ioo`03001oogoo04Qoo`03I1moogoo04Eoo`03I1moogoo00mo
o`00RGoo00=T7gooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol0BGoo0V@OAGoo
00=T7gooOol03goo0028Ool00f@O001oo`03Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool3001;Ool0
0f@OOomoo`11Ool00f@OOomoo`0@Ool008Qoo`03I1l007oo00=oo`03001oogoo00]oo`03001oogoo
00Eoo`03001oogoo04aoo`03I1moogoo03moo`03I1moogoo015oo`00Qgoo00=T7goo000017oo00<0
07ooOol037oo00<007ooOol017oo00<007ooOol0CGoo0V@O?goo00=T7gooOol04Goo0027Ool00f@O
Ool00004Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol0Cgoo00=T7gooOol0>goo
00=T7gooOol04Woo0026Ool016@OOomoogoo100037oo0`001goo00<007ooOol0D7oo00=T7gooOol0
>Goo00=T7gooOol04goo0026Ool00f@OOomoo`0KOol00`00Oomoo`1AOol2I1lhOol00f@OOomoo`0D
Ool008Eoo`03I1moogoo01aoo`03001oogoo05=oo`03I1moogoo03Aoo`03I1moogoo01Eoo`00QGoo
00=T7gooOol077oo00<007ooOol0E7oo00=T7gooOol0<Woo00=T7gooOol05Woo0024Ool00f@OOomo
o`0MOol00`00Oomoo`1EOol2I1laOol00f@OOomoo`0GOol008Aoo`03I1moogoo01eoo`03001oogoo
05Moo`03I1moogoo02eoo`03I1moogoo01Qoo`00Q7oo00=T7gooOol07Goo0P00FGoo00=T7gooOol0
:goo00=T7gooOol06Goo0023Ool00f@OOomoo`0NOol00`00Oomoo`1IOol2I1lYOol2I1lLOol008=o
o`03I1moogoo01ioo`03001oogoo05]oo`03I1moogoo02Eoo`03I1moogoo01aoo`00PWoo00=T7goo
Ool07goo00<007ooOol0G7oo0V@O8goo0V@O7goo0022Ool00f@OOomoo`0OOol00`00Oomoo`1NOol2
I1lPOol00f@OOomoo`0OOol0089oo`03I1moogoo01moo`03001oogoo061oo`=T7a]oo`9T7b9oo`00
PGoo00=T7gooOol087oo00<007ooOol0Hgoo0f@O5Woo0V@O97oo0021Ool00f@OOomoo`0POol00`00
Oomoo`1VOol2I1lBOol2I1lVOol0085oo`03I1moogoo021oo`03001oogoo06Qoo`IT7`Moo`ET7bQo
o`00P7oo00=T7gooOol08Goo0P00Kgoo1f@O;Goo0020Ool00f@OOomoo`0QOol00`00Oomoo`2ROol0
07moo`03I1moogoo029oo`03001oogoo0:9oo`00Ogoo00=T7gooOol08Woo00<007ooOol0XWoo001o
Ool00f@OOomoo`0ROol00`00Oomoo`2ROol007ioo`03I1moogoo02=oo`03001oogoo0:9oo`00OWoo
00=T7gooOol08goo00<007ooOol0XWoo001nOol00f@OOomoo`0SOol00`00Oomoo`2ROol007eoo`03
I1moogoo02Aoo`03001oogoo0:9oo`00OGoo00=T7gooOol097oo00<007ooOol0XWoo001mOol00f@O
Oomoo`0TOol2002SOol007aoo`03I1moogoo02Eoo`03001oogoo0:9oo`00O7oo00=T7gooOol09Goo
00<007ooOol0XWoo001lOol00f@OOomoo`0UOol00`00Oomoo`2ROol007aoo`03I1moogoo02Eoo`03
001oogoo0:9oo`00Ngoo00=T7gooOol09Woo00<007ooOol0XWoo001kOol00f@OOomoo`0VOol00`00
Oomoo`2ROol007]oo`03I1moogoo00aoo`@000Eoo`8000Moo`<000Eoo`03001oogoo0:9oo`00NWoo
00=T7gooOol037oo00<007ooOol00Woo00<007ooOol00Woo0P0027oo00<007ooOol017oo00<007oo
Ool0XWoo001jOol00f@OOomoo`0<Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool0
0`00Oomoo`2ROol007Yoo`03I1moogoo00aoo`03001oogoo009oo`03001oogoo00Qoo`H000Eoo`<0
0:9oo`00NGoo00=T7gooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03
001oogoo0:9oo`00NGoo00=T7gooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol0
00Ioo`03001oogoo0:9oo`00NGoo00=T7gooOol03Goo00<007ooOol00Woo00<007ooOol02Woo00<0
07oo00001Woo00<007ooOol0XWoo001hOol00f@OOomoo`0?Ool4000>Ool20006Ool00`00Oomoo`2R
Ool007Qoo`03I1moogoo02Uoo`03001oogoo0:9oo`00N7oo00=T7gooOol0:Goo00<007ooOol0XWoo
001hOol00f@OOomoo`0YOol00`00Oomoo`2ROol007Moo`03I1moogoo02Yoo`03001oogoo0:9oo`00
Mgoo00=T7gooOol0:Woo00<007ooOol0XWoo001gOol00f@OOomoo`0ZOol2002SOol007Ioo`03I1mo
ogoo02]oo`03001oogoo0:9oo`00MWoo00=T7gooOol0:goo00<007ooOol0XWoo001fOol00f@OOomo
o`0[Ool00`00Oomoo`2ROol007Eoo`03I1moogoo02aoo`03001oogoo0:9oo`00MGoo00=T7gooOol0
;7oo00<007ooOol0XWoo001eOol00f@OOomoo`0/Ool00`00Oomoo`2ROol007Aoo`03I1moogoo02eo
o`03001oogoo0:9oo`00M7oo00=T7gooOol0;Goo00<007ooOol0XWoo001dOol00f@OOomoo`0]Ool0
0`00Oomoo`2ROol007Aoo`03I1moogoo02eoo`800:=oo`00Lgoo00=T7gooOol0;Woo00<007ooOol0
XWoo001cOol00f@OOomoo`0^Ool00`00Oomoo`2ROol007=oo`03I1moogoo02ioo`03001oogoo0:9o
o`00LWoo00=T7gooOol0;goo00<007ooOol0XWoo001bOol00f@OOomoo`0_Ool00`00Oomoo`2ROol0
079oo`03I1moogoo02moo`03001oogoo0:9oo`00LGoo00=T7gooOol0<7oo00<007ooOol0XWoo001a
Ool00f@OOomoo`0`Ool00`00Oomoo`2ROol0075oo`03I1moogoo031oo`03001oogoo0:9oo`00LGoo
00=T7gooOol0<7oo0P00Xgoo001`Ool00f@OOomoo`0aOol00`00Oomoo`2ROol0071oo`03I1moogoo
035oo`03001oogoo0:9oo`00L7oo00=T7gooOol0<Goo00<007ooOol0XWoo001_Ool00f@OOomoo`0b
Ool00`00Oomoo`2ROol006moo`03I1moogoo039oo`03001oogoo0:9oo`00Kgoo00=T7gooOol0<Woo
00<007ooOol0XWoo001_Ool00f@OOomoo`0bOol00`00Oomoo`2ROol006ioo`03I1moogoo03=oo`03
001oogoo0:9oo`00KWoo00=T7gooOol0<goo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 .9 r
.5 Mabswid
.3207 .61803 m
.34309 .5313 L
.3815 .41884 L
.40095 .37424 L
.42237 .33392 L
.44292 .3033 L
.46172 .2817 L
.48113 .26532 L
.49183 .25868 L
.502 .25385 L
.51159 .25055 L
.51695 .24921 L
.51948 .2487 L
.52181 .2483 L
.52398 .24798 L
.52636 .2477 L
.52875 .24748 L
.53006 .24739 L
.53128 .24732 L
.53243 .24727 L
.53353 .24724 L
.53451 .24722 L
.53558 .24721 L
.53674 .24722 L
.53798 .24724 L
.53903 .24727 L
.5402 .24732 L
.54141 .24739 L
.54255 .24746 L
.54511 .24769 L
.54762 .24797 L
.55029 .24834 L
.55954 .25015 L
.56516 .25165 L
.57047 .25332 L
.5804 .25708 L
.60041 .26693 L
.61887 .27832 L
.65827 .30802 L
.69616 .34026 L
.7365 .37431 L
.77532 .4027 L
.7965 .41491 L
.80623 .41951 L
.8166 .4236 L
.82701 .42681 L
.83193 .42798 L
.83644 .42886 L
.841 .42955 L
.8434 .42982 L
Mistroke
.84592 .43005 L
.84699 .43013 L
.84812 .4302 L
.84911 .43025 L
.85018 .43029 L
.85143 .43032 L
.85262 .43033 L
.85377 .43033 L
.85484 .43032 L
.85603 .43029 L
.85727 .43024 L
.85833 .43019 L
.85949 .43011 L
.86208 .42989 L
.86449 .42962 L
.86887 .42895 L
.87354 .42798 L
.87911 .42647 L
.88435 .42469 L
.89416 .42039 L
.90391 .41481 L
.91421 .40742 L
.93268 .39013 L
.95229 .36563 L
.97062 .3366 L
.97619 .32653 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 1.5}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OonY0005O1bB0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00Il
70Eoo`Il70Yoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
3Goo00<007`LO1`037oo00<007ooOol00Woo0g`L1goo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol037oo00<007ooOol02goo002SOol2O1`FOol2O1b<Ool00:5oo`9l7003Ool007oo01Moo`9l
78Yoo`00Wgoo0W`L0goo00<007ooOol067oo0W`LR7oo002NOol00g`LOomoo`03Ool00`00Oomoo`0J
Ool2O1b6Ool009aoo`9l70Ioo`03001oogoo01aoo`9l78Aoo`00Vgoo00=l77ooOol01Woo00<007oo
Ool07Woo0W`LPWoo002JOol00g`LOomoo`07Ool00`00Oomoo`0POol2O1b0Ool009Qoo`9l70Yoo`80
02=oo`03O1aoogoo07eoo`00Ugoo00=l77ooOol02Woo00<007ooOol08goo00=l77ooOol0O7oo002F
Ool00g`LOomoo`0;Ool00`00Oomoo`0TOol2O1alOol009Eoo`03O1aoogoo00aoo`03001oogoo02Io
o`03O1aoogoo07Uoo`00U7oo00=l77ooOol03Goo00<007ooOol09goo00=l77ooOol0N7oo002DOol0
0g`LOomoo`0=Ool00`00Oomoo`0XOol2O1ahOol009=oo`03O1aoogoo00ioo`03001oogoo02Yoo`03
O1aoogoo07Eoo`00TWoo00=l77ooOol03goo00<007ooOol0:goo00=l77ooOol0M7oo002AOol00g`L
Oomoo`0@Ool00`00Oomoo`0/Ool2O1adOol0091oo`03O1aoogoo015oo`03001oogoo02ioo`03O1ao
ogoo075oo`00T7oo00=l77ooOol04Goo0P00<7oo00=l77ooOol0L7oo002?Ool00g`LOomoo`0BOol0
0`00Oomoo`0`Ool00g`LOomoo`1_Ool008moo`03O1aoogoo019oo`03001oogoo035oo`03O1aoogoo
06ioo`00SWoo00=l77ooOol04goo00<007ooOol0<Woo0W`LKWoo002=Ool00g`LOomoo`0DOol00`00
Oomoo`0dOol00g`LOomoo`1[Ool008eoo`03O1aoogoo01Aoo`03001oogoo03Eoo`03O1aoogoo06Yo
o`00S7oo00=l77ooOol05Goo00<007ooOol0=Woo00=l77ooOol0Fgoo00=l77ooOol02goo002<Ool0
0g`LOomoo`0EOol00`00Oomoo`0gOol00g`LOomoo`1IOol00g`LOomoo`0<Ool008]oo`03O1aoogoo
01Ioo`03001oogoo03Qoo`9l75Uoo`03O1aoogoo00aoo`00RWoo00=l77ooOol05goo00<007ooOol0
>Woo00=l77ooOol0EGoo00=l77ooOol03Goo002:Ool00g`LOomoo`0GOol2000lOol00g`LOomoo`1C
Ool00g`LOomoo`0>Ool008Uoo`03O1aoogoo01Qoo`03001oogoo03aoo`03O1aoogoo059oo`03O1ao
ogoo00ioo`00RGoo00=l77ooOol067oo00<007ooOol0?Goo00=l77ooOol0D7oo00=l77ooOol03goo
0028Ool00g`LOomoo`0IOol00`00Oomoo`0nOol2O1a@Ool00g`LOomoo`0?Ool008Qoo`03O1aoogoo
01Uoo`03001oogoo041oo`03O1aoogoo04aoo`03O1aoogoo011oo`00Qgoo00=l77ooOol06Woo00<0
07ooOol0@Goo00=l77ooOol0Bgoo00=l77ooOol047oo0027Ool00g`LOomoo`0JOol00`00Oomoo`12
Ool00g`LOomoo`19Ool00g`LOomoo`0AOol008Ioo`04O1aoogooOol40005Ool20004Ool50006Ool0
0`00Oomoo`13Ool00g`LOomoo`18Ool00g`LOomoo`0AOol008Ioo`04O1aoogoo0004Ool00`00Oomo
o`02Ool20004Ool01@00Oomoogoo00001Woo00<007ooOol0A7oo0W`LAgoo00=l77ooOol04Woo0025
Ool01G`LOomoogoo000017oo00<007ooOol02Goo00<007ooOol01goo00<007ooOol0AWoo00=l77oo
Ool0@goo00=l77ooOol04goo0025Ool01G`LOomoogoo000017oo00<007ooOol02Woo00<007ooOol0
1Woo0`00Agoo00=l77ooOol0@Goo00=l77ooOol057oo0024Ool00g`LOomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`18Ool00g`LOomoo`0oOol00g`LOomoo`0E
Ool008Aoo`03O1aoogoo009oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001o
ogoo04Uoo`03O1aoogoo03eoo`03O1aoogoo01Ioo`00Pgoo00=l77ooOol00goo00<007ooOol00Woo
00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo04Yoo`9l73eoo`03O1aoogoo01Ioo`00
Pgoo00=l77ooOol017oo100037oo0`001goo00<007ooOol0C7oo00=l77ooOol0>Goo00=l77ooOol0
5goo0022Ool00g`LOomoo`0OOol00`00Oomoo`1=Ool00g`LOomoo`0gOol00g`LOomoo`0HOol0089o
o`03O1aoogoo01moo`03001oogoo04ioo`9l73Ioo`03O1aoogoo01Uoo`00PGoo00=l77ooOol087oo
00<007ooOol0D7oo00=l77ooOol0<Woo00=l77ooOol06Woo0021Ool00g`LOomoo`0POol00`00Oomo
o`1AOol00g`LOomoo`0`Ool00g`LOomoo`0KOol0085oo`03O1aoogoo021oo`03001oogoo059oo`9l
72moo`03O1aoogoo01aoo`00P7oo00=l77ooOol08Goo0P00EGoo00=l77ooOol0:goo00=l77ooOol0
7Goo0020Ool00g`LOomoo`0QOol00`00Oomoo`1EOol2O1`ZOol00g`LOomoo`0NOol007moo`03O1ao
ogoo029oo`03001oogoo05Moo`9l72Moo`03O1aoogoo01moo`00Ogoo00=l77ooOol08Woo00<007oo
Ool0FGoo0W`L8goo0W`L8Woo001nOol00g`LOomoo`0SOol00`00Oomoo`1KOol2O1`POol00g`LOomo
o`0ROol007ioo`03O1aoogoo02=oo`03001oogoo05eoo`9l71aoo`9l72Eoo`00OWoo00=l77ooOol0
8goo00<007ooOol0Ggoo0W`L67oo0W`L9goo001mOol00g`LOomoo`0TOol00`00Oomoo`1QOol2O1`B
Ool4O1`YOol007eoo`03O1aoogoo02Aoo`03001oogoo06=oo`Ml70Moo`Al72eoo`00OGoo00=l77oo
Ool097oo0P00Jgoo1g`L<Goo001lOol00g`LOomoo`0UOol00`00Oomoo`2ROol007aoo`03O1aoogoo
02Eoo`03001oogoo0:9oo`00O7oo00=l77ooOol09Goo00<007ooOol0XWoo001kOol00g`LOomoo`0V
Ool00`00Oomoo`2ROol007]oo`03O1aoogoo02Ioo`03001oogoo0:9oo`00Ngoo00=l77ooOol09Woo
00<007ooOol0XWoo001jOol00g`LOomoo`0WOol00`00Oomoo`2ROol007Yoo`03O1aoogoo02Moo`03
001oogoo0:9oo`00NWoo00=l77ooOol09goo00<007ooOol0XWoo001iOol00g`LOomoo`0XOol2002S
Ool007Uoo`03O1aoogoo02Qoo`03001oogoo0:9oo`00NGoo00=l77ooOol0:7oo00<007ooOol0XWoo
001hOol00g`LOomoo`0YOol00`00Oomoo`2ROol007Qoo`03O1aoogoo02Uoo`03001oogoo0:9oo`00
N7oo00=l77ooOol0:Goo00<007ooOol0XWoo001gOol00g`LOomoo`0ZOol00`00Oomoo`2ROol007Mo
o`03O1aoogoo011oo`@000Eoo`8000Moo`<000Eoo`03001oogoo0:9oo`00Mgoo00=l77ooOol03goo
00<007ooOol00Woo00<007ooOol00Woo0P0027oo00<007ooOol017oo00<007ooOol0XWoo001fOol0
0g`LOomoo`0@Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`2ROol0
07Ioo`03O1aoogoo011oo`03001oogoo009oo`03001oogoo00Qoo`H000Eoo`<00:9oo`00MWoo00=l
77ooOol047oo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo0:9oo`00
MGoo00=l77ooOol04Goo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo
0:9oo`00MGoo00=l77ooOol04Goo00<007ooOol00Woo00<007ooOol02Woo00<007oo00001Woo00<0
07ooOol0XWoo001eOol00g`LOomoo`0BOol4000>Ool20006Ool00`00Oomoo`2ROol007Aoo`03O1ao
ogoo02eoo`03001oogoo0:9oo`00M7oo00=l77ooOol0;Goo00<007ooOol0XWoo001dOol00g`LOomo
o`0]Ool00`00Oomoo`2ROol007=oo`03O1aoogoo02ioo`03001oogoo0:9oo`00Lgoo00=l77ooOol0
;Woo00<007ooOol0XWoo001cOol00g`LOomoo`0^Ool2002SOol0079oo`03O1aoogoo02moo`03001o
ogoo0:9oo`00LWoo00=l77ooOol0;goo00<007ooOol0XWoo001bOol00g`LOomoo`0_Ool00`00Oomo
o`2ROol0075oo`03O1aoogoo031oo`03001oogoo0:9oo`00LGoo00=l77ooOol0<7oo00<007ooOol0
XWoo001aOol00g`LOomoo`0`Ool00`00Oomoo`2ROol0075oo`03O1aoogoo031oo`03001oogoo0:9o
o`00L7oo00=l77ooOol0<Goo00<007ooOol0XWoo001`Ool00g`LOomoo`0aOol00`00Oomoo`2ROol0
071oo`03O1aoogoo035oo`800:=oo`00L7oo00=l77ooOol0<Goo00<007ooOol0XWoo001_Ool00g`L
Oomoo`0bOol00`00Oomoo`2ROol006moo`03O1aoogoo039oo`03001oogoo0:9oo`00Kgoo00=l77oo
Ool0<Woo00<007ooOol0XWoo001_Ool00g`LOomoo`0bOol00`00Oomoo`2ROol006ioo`03O1aoogoo
03=oo`03001oogoo0:9oo`00KWoo00=l77ooOol0<goo00<007ooOol0XWoo001^Ool00g`LOomoo`0c
Ool00`00Oomoo`2ROol006ioo`03O1aoogoo03=oo`03001oogoo0:9oo`00KGoo00=l77ooOol0=7oo
0P00Xgoo001]Ool00g`LOomoo`0dOol00`00Oomoo`2ROol006eoo`03O1aoogoo03Aoo`03001oogoo
0:9oo`00KGoo00=l77ooOol0=7oo00<007ooOol0XWoo001/Ool00g`LOomoo`0eOol00`00Oomoo`2R
Ool006aoo`03O1aoogoo03Eoo`03001oogoo0:9oo`00K7oo00=l77ooOol0=Goo00<007ooOol0XWoo
001/Ool00g`LOomoo`0eOol00`00Oomoo`2ROol006]oo`03O1aoogoo03Ioo`03001oogoo0:9oo`00
Jgoo00=l77ooOol0=Woo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 .6 r
.5 Mabswid
.30807 .61803 m
.34309 .49282 L
.3815 .3906 L
.40134 .35001 L
.42237 .31526 L
.4419 .29008 L
.4602 .27222 L
.47058 .26438 L
.48045 .2584 L
.4893 .25417 L
.49897 .25075 L
.50429 .24938 L
.50929 .2484 L
.51378 .24777 L
.51632 .24752 L
.51865 .24736 L
.51986 .2473 L
.52116 .24725 L
.52239 .24722 L
.52351 .24721 L
.52482 .24722 L
.52556 .24723 L
.52625 .24725 L
.52751 .24729 L
.52884 .24735 L
.53012 .24743 L
.53149 .24753 L
.53397 .24776 L
.53691 .24812 L
.53962 .24853 L
.54942 .2506 L
.55854 .25331 L
.57924 .26201 L
.5997 .2736 L
.61829 .28622 L
.65827 .31794 L
.69674 .35102 L
.73765 .38455 L
.75801 .39916 L
.77706 .41089 L
.79532 .41994 L
.80558 .42391 L
.81494 .42677 L
.81973 .42792 L
.82482 .42891 L
.82729 .4293 L
.82962 .42961 L
.83169 .42984 L
.83397 .43005 L
.83519 .43014 L
Mistroke
.8365 .43021 L
.83722 .43025 L
.83788 .43027 L
.83916 .43031 L
.84034 .43033 L
.84162 .43033 L
.84282 .43032 L
.84394 .4303 L
.84522 .43025 L
.84642 .43019 L
.84774 .4301 L
.84916 .42999 L
.85206 .42969 L
.85471 .42932 L
.85946 .42846 L
.86453 .42724 L
.87367 .42422 L
.88453 .41921 L
.89438 .41324 L
.91361 .39748 L
.93442 .37379 L
.95433 .34411 L
.97539 .30467 L
.97619 .30299 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OonV0004O1:F0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001l4W`B00=l
4PAoo`Ml4Peoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
2goo0g`B3Woo00<007ooO1800W`B2Woo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo
00<007ooOol02goo002OOol3O182Ool00`00Oomoo`0AOol2O1:?Ool009eoo`9l4PEoo`03001oogoo
01=oo`9l4Xeoo`00Vgoo0W`B1goo00<007ooOol05Goo0W`BRgoo002JOol00g`BOomoo`07Ool00`00
Oomoo`0GOol2O1:9Ool009Qoo`9l4PYoo`03001oogoo01Uoo`03O19oogoo08Ioo`00Ugoo00=l4Woo
Ool02Woo00<007ooOol06Woo0W`BQWoo002FOol00g`BOomoo`0;Ool00`00Oomoo`0LOol00g`BOomo
o`23Ool009Eoo`03O19oogoo00aoo`8001ioo`9l4X=oo`00U7oo00=l4WooOol03Goo00<007ooOol0
7goo00=l4WooOol0P7oo002COol00g`BOomoo`0>Ool00`00Oomoo`0POol2O1:0Ool0099oo`03O19o
ogoo00moo`03001oogoo029oo`03O19oogoo07eoo`00TGoo00=l4WooOol047oo00<007ooOol08goo
00=l4WooOol0O7oo002@Ool00g`BOomoo`0AOol00`00Oomoo`0TOol2O19lOol008moo`03O19oogoo
019oo`03001oogoo02Ioo`03O19oogoo07Uoo`00Sgoo00=l4WooOol04Woo00<007ooOol09goo00=l
4WooOol0N7oo002>Ool00g`BOomoo`0COol00`00Oomoo`0XOol2O19ZOol00g`BOomoo`0;Ool008eo
o`03O19oogoo01Aoo`03001oogoo02Yoo`03O19oogoo06Moo`03O19oogoo00]oo`00S7oo00=l4Woo
Ool05Goo0P00;7oo00=l4WooOol0IGoo00=l4WooOol037oo002<Ool00g`BOomoo`0EOol00`00Oomo
o`0/Ool2O19UOol00g`BOomoo`0<Ool008]oo`03O19oogoo01Ioo`03001oogoo02ioo`03O19oogoo
065oo`03O19oogoo00eoo`00RWoo00=l4WooOol05goo00<007ooOol0;goo00=l4WooOol0H7oo00=l
4WooOol03Goo002:Ool00g`BOomoo`0GOol00`00Oomoo`0`Ool00g`BOomoo`1NOol00g`BOomoo`0>
Ool008Uoo`03O19oogoo01Qoo`03001oogoo035oo`03O19oogoo05aoo`03O19oogoo00moo`00R7oo
00=l4WooOol06Goo00<007ooOol0<Woo0W`BG7oo00=l4WooOol03goo0028Ool00g`BOomoo`0IOol0
0`00Oomoo`0dOol00g`BOomoo`1HOol00g`BOomoo`0@Ool008Moo`03O19oogoo01Yoo`03001oogoo
03Eoo`03O19oogoo05Moo`03O19oogoo011oo`00Qgoo00=l4WooOol06Woo00<007ooOol0=Woo00=l
4WooOol0EGoo00=l4WooOol04Goo0026Ool00g`BOomoo`0KOol2000hOol00g`BOomoo`1DOol00g`B
Oomoo`0AOol008Eoo`03O19oogoo01aoo`03001oogoo03Qoo`9l4U=oo`03O19oogoo019oo`00QGoo
00=l4WooOol077oo00<007ooOol0>Woo00=l4WooOol0Cgoo00=l4WooOol04goo0024Ool00g`BOomo
o`0MOol00`00Oomoo`0kOol00g`BOomoo`1>Ool00g`BOomoo`0COol008Aoo`03O19oogoo01eoo`03
001oogoo03aoo`03O19oogoo04aoo`03O19oogoo01Aoo`00Pgoo00=l4WooOol07Woo00<007ooOol0
?Goo00=l4WooOol0Bgoo00=l4WooOol057oo0023Ool00g`BOomoo`0NOol00`00Oomoo`0nOol2O19:
Ool00g`BOomoo`0EOol0089oo`03O19oogoo00Eoo`@000Eoo`8000Aoo`D000Ioo`03001oogoo041o
o`03O19oogoo04Ioo`03O19oogoo01Ioo`00PWoo00=l4WooOol017oo00<007ooOol00Woo00<007oo
Ool00Woo0P0017oo00D007ooOomoo`0000Ioo`03001oogoo045oo`03O19oogoo04Eoo`03O19oogoo
01Ioo`00PGoo00=l4WooOol01Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<0
07ooOol0@Woo00=l4WooOol0@goo00=l4WooOol05goo0021Ool00g`BOomoo`05Ool00`00Oomoo`02
Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool30013Ool00g`BOomoo`12Ool00g`BOomoo`0GOol0081o
o`03O19oogoo00Ioo`03001oogoo009oo`03001oogoo00]oo`03001oogoo00Eoo`03001oogoo04Ao
o`9l4T5oo`03O19oogoo01Qoo`00P7oo00=l4WooOol01Woo00<007ooOol00Woo00<007ooOol037oo
00<007ooOol017oo00<007ooOol0AWoo00=l4WooOol0?Goo00=l4WooOol06Goo001oOol00g`BOomo
o`07Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol0Agoo00=l
4WooOol0>goo00=l4WooOol06Woo001oOol00g`BOomoo`08Ool4000<Ool30007Ool00`00Oomoo`18
Ool00g`BOomoo`0iOol00g`BOomoo`0KOol007ioo`03O19oogoo02=oo`03001oogoo04Uoo`9l4SQo
o`03O19oogoo01aoo`00OWoo00=l4WooOol08goo00<007ooOol0Bgoo00=l4WooOol0=7oo00=l4Woo
Ool07Goo001nOol00g`BOomoo`0SOol00`00Oomoo`1<Ool00g`BOomoo`0bOol00g`BOomoo`0NOol0
07eoo`03O19oogoo02Aoo`03001oogoo04eoo`9l4S5oo`03O19oogoo01moo`00OGoo00=l4WooOol0
97oo00<007ooOol0Cgoo00=l4WooOol0;Goo00=l4WooOol087oo001mOol00g`BOomoo`0TOol2001A
Ool2O18/Ool00g`BOomoo`0QOol007aoo`03O19oogoo02Eoo`03001oogoo059oo`03O19oogoo02Mo
o`9l4RAoo`00O7oo00=l4WooOol09Goo00<007ooOol0Dgoo0W`B9Woo00=l4WooOol097oo001kOol0
0g`BOomoo`0VOol00`00Oomoo`1EOol2O18SOol00g`BOomoo`0UOol007]oo`03O19oogoo02Ioo`03
001oogoo05Moo`=l4Qioo`9l4RQoo`00Ngoo00=l4WooOol09Woo00<007ooOol0FWoo0W`B6goo00=l
4WooOol0:7oo001jOol00g`BOomoo`0WOol00`00Oomoo`1LOol2O18GOol2O18[Ool007Yoo`03O19o
ogoo02Moo`03001oogoo05ioo`9l4Q=oo`9l4Reoo`00NWoo00=l4WooOol09goo00<007ooOol0H7oo
1g`B1goo1G`B;goo001iOol00g`BOomoo`0XOol2001WOol8O18dOol007Uoo`03O19oogoo02Qoo`03
001oogoo0:9oo`00NGoo00=l4WooOol0:7oo00<007ooOol0XWoo001hOol00g`BOomoo`0YOol00`00
Oomoo`2ROol007Qoo`03O19oogoo02Uoo`03001oogoo0:9oo`00Mgoo00=l4WooOol0:Woo00<007oo
Ool0XWoo001gOol00g`BOomoo`0ZOol00`00Oomoo`2ROol007Moo`03O19oogoo02Yoo`03001oogoo
0:9oo`00MWoo00=l4WooOol0:goo00<007ooOol0XWoo001fOol00g`BOomoo`0[Ool00`00Oomoo`2R
Ool007Ioo`03O19oogoo02]oo`800:=oo`00MGoo00=l4WooOol0;7oo00<007ooOol0XWoo001eOol0
0g`BOomoo`0/Ool00`00Oomoo`2ROol007Eoo`03O19oogoo02aoo`03001oogoo0:9oo`00M7oo00=l
4WooOol0;Goo00<007ooOol0XWoo001dOol00g`BOomoo`0]Ool00`00Oomoo`2ROol007=oo`03O19o
ogoo02ioo`03001oogoo0:9oo`00Lgoo00=l4WooOol057oo10001Goo0P001goo0`001Goo00<007oo
Ool0XWoo001cOol00g`BOomoo`0COol00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomo
o`04Ool00`00Oomoo`2ROol0079oo`03O19oogoo01Aoo`03001oogoo009oo`03001oogoo00aoo`03
001oogoo00Aoo`03001oogoo0:9oo`00LWoo00=l4WooOol057oo00<007ooOol00Woo00<007ooOol0
27oo1P001Goo0`00XWoo001bOol00g`BOomoo`0DOol00`00Oomoo`02Ool00`00Oomoo`09Ool01000
Oomoo`001Woo00<007ooOol0XWoo001aOol00g`BOomoo`0EOol00`00Oomoo`02Ool00`00Oomoo`09
Ool01000Oomoo`001Woo00<007ooOol0XWoo001aOol00g`BOomoo`0EOol00`00Oomoo`02Ool00`00
Oomoo`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol0075oo`03O19oogoo01Ioo`@000ioo`8000Io
o`03001oogoo0:9oo`00LGoo00=l4WooOol0<7oo00<007ooOol0XWoo001`Ool00g`BOomoo`0aOol0
0`00Oomoo`2ROol0071oo`03O19oogoo035oo`03001oogoo0:9oo`00L7oo00=l4WooOol0<Goo00<0
07ooOol0XWoo001_Ool00g`BOomoo`0bOol00`00Oomoo`2ROol006moo`03O19oogoo039oo`800:=o
o`00Kgoo00=l4WooOol0<Woo00<007ooOol0XWoo001_Ool00g`BOomoo`0bOol00`00Oomoo`2ROol0
06ioo`03O19oogoo03=oo`03001oogoo0:9oo`00KWoo00=l4WooOol0<goo00<007ooOol0XWoo001^
Ool00g`BOomoo`0cOol00`00Oomoo`2ROol006eoo`03O19oogoo03Aoo`03001oogoo0:9oo`00KGoo
00=l4WooOol0=7oo00<007ooOol0XWoo001]Ool00g`BOomoo`0dOol00`00Oomoo`2ROol006eoo`03
O19oogoo03Aoo`03001oogoo0:9oo`00K7oo00=l4WooOol0=Goo0P00Xgoo001/Ool00g`BOomoo`0e
Ool00`00Oomoo`2ROol006aoo`03O19oogoo03Eoo`03001oogoo0:9oo`00K7oo00=l4WooOol0=Goo
00<007ooOol0XWoo001[Ool00g`BOomoo`0fOol00`00Oomoo`2ROol006]oo`03O19oogoo03Ioo`03
001oogoo0:9oo`00Jgoo00=l4WooOol0=Woo00<007ooOol0XWoo001ZOol00g`BOomoo`0gOol00`00
Oomoo`2ROol006Yoo`03O19oogoo03Moo`03001oogoo0:9oo`00JWoo00=l4WooOol0=goo00<007oo
Ool0XWoo001ZOol00g`BOomoo`0gOol2002SOol006Uoo`03O19oogoo03Qoo`03001oogoo0:9oo`00
JGoo00=l4WooOol0>7oo00<007ooOol0XWoo001YOol00g`BOomoo`0hOol00`00Oomoo`2ROol006Qo
o`03O19oogoo03Uoo`03001oogoo0:9oo`00J7oo00=l4WooOol0>Goo00<007ooOol0XWoo001XOol0
0g`BOomoo`0iOol00`00Oomoo`2ROol006Qoo`03O19oogoo03Uoo`03001oogoo0:9oo`00Igoo00=l
4WooOol0>Woo00<007ooOol0XWoo001WOol00g`BOomoo`0jOol00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 .3 r
.5 Mabswid
.2964 .61803 m
.30316 .58888 L
.34309 .45765 L
.3815 .3653 L
.40134 .32933 L
.42237 .29913 L
.4419 .27785 L
.4602 .26337 L
.47058 .25733 L
.48045 .25296 L
.4893 .25013 L
.49432 .24896 L
.49897 .24815 L
.50162 .2478 L
.50405 .24756 L
.50543 .24745 L
.50672 .24736 L
.50806 .24729 L
.50878 .24727 L
.50954 .24724 L
.51082 .24722 L
.51154 .24721 L
.51221 .24721 L
.51344 .24723 L
.51475 .24726 L
.51591 .2473 L
.517 .24735 L
.51949 .24752 L
.52177 .24773 L
.52417 .24801 L
.52845 .24865 L
.53306 .24954 L
.5381 .25075 L
.54838 .25391 L
.55771 .25755 L
.57866 .2681 L
.61865 .2954 L
.65711 .3271 L
.69803 .36224 L
.73743 .39316 L
.75723 .40627 L
.77532 .41622 L
.78463 .42045 L
.79477 .42428 L
.80033 .42602 L
.80549 .42738 L
.81079 .42853 L
.81566 .42934 L
.81814 .42966 L
.82075 .42994 L
Mistroke
.82338 .43014 L
.82487 .43023 L
.82553 .43026 L
.82626 .43028 L
.82755 .43032 L
.82877 .43033 L
.82997 .43033 L
.83107 .43032 L
.83226 .43029 L
.83357 .43024 L
.83494 .43016 L
.83622 .43007 L
.8385 .42987 L
.8409 .42959 L
.84519 .42892 L
.8498 .42796 L
.85484 .42661 L
.86514 .42283 L
.87449 .41818 L
.88528 .41129 L
.89546 .40322 L
.91551 .38257 L
.93397 .35758 L
.97343 .28297 L
.97619 .27659 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OonQ0005O0VJ0005Ool000aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Qoo`Ml2@Aoo`El2@Ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]o
o`0037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007oo
Ool01Woo0W`91Goo00<007ooOol027oo0g`900=oo`00Ool03Goo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol02goo002KOol2O0T7Ool00`00Oomoo`0;Ool3O0VDOol009Yo
o`03O0Uoogoo00Moo`03001oogoo00ioo`=l2I5oo`00V7oo0W`92Woo00<007ooOol04Goo0W`9Sgoo
002GOol00g`9Oomoo`0:Ool00`00Oomoo`0COol2O0V=Ool009Eoo`9l2@eoo`03001oogoo01Eoo`9l
2H]oo`00U7oo00=l2GooOol03Goo00<007ooOol05goo00=l2GooOol0R7oo002BOol2O0T@Ool00`00
Oomoo`0HOol2O0V8Ool0095oo`03O0Uoogoo011oo`8001]oo`03O0Uoogoo07Moo`03O0Uoogoo00]o
o`00T7oo00=l2GooOol04Goo00<007ooOol06goo00=l2GooOol0MGoo00=l2GooOol037oo002?Ool0
0g`9Oomoo`0BOol00`00Oomoo`0LOol2O0UeOol00g`9Oomoo`0<Ool008ioo`03O0Uoogoo01=oo`03
001oogoo01ioo`03O0Uoogoo075oo`03O0Uoogoo00eoo`00SWoo00=l2GooOol04goo00<007ooOol0
7goo00=l2GooOol0L7oo00=l2GooOol03Goo002=Ool00g`9Oomoo`0DOol00`00Oomoo`0POol2O0U_
Ool00g`9Oomoo`0>Ool008aoo`03O0Uoogoo01Eoo`03001oogoo029oo`03O0Uoogoo06aoo`03O0Uo
ogoo00ioo`00Rgoo00=l2GooOol05Woo00<007ooOol08goo00=l2GooOol0JWoo00=l2GooOol03goo
002:Ool00g`9Oomoo`0GOol00`00Oomoo`0TOol2O0UZOol00g`9Oomoo`0?Ool008Yoo`03O0Uoogoo
01Moo`03001oogoo02Ioo`03O0Uoogoo06Ioo`03O0Uoogoo011oo`00RGoo00=l2GooOol067oo0P00
:7oo00=l2GooOol0IGoo00=l2GooOol047oo0028Ool00g`9Oomoo`0IOol00`00Oomoo`0XOol2O0UT
Ool00g`9Oomoo`0AOol008Moo`03O0Uoogoo01Yoo`03001oogoo02Yoo`03O0Uoogoo065oo`03O0Uo
ogoo015oo`00Qgoo00=l2GooOol06Woo00<007ooOol0:goo00=l2GooOol0Ggoo00=l2GooOol04Woo
0026Ool00g`9Oomoo`0KOol00`00Oomoo`0/Ool2O0UOOol00g`9Oomoo`0BOol008Eoo`03O0Uoogoo
01aoo`03001oogoo02ioo`03O0Uoogoo05]oo`03O0Uoogoo01=oo`00QGoo00=l2GooOol077oo00<0
07ooOol0;goo00=l2GooOol0FWoo00=l2GooOol04goo0024Ool00g`9Oomoo`0MOol00`00Oomoo`0`
Ool00g`9Oomoo`1HOol00g`9Oomoo`0DOol008=oo`03O0Uoogoo01ioo`03001oogoo035oo`03O0Uo
ogoo05Moo`03O0Uoogoo01Aoo`00Pgoo00=l2GooOol07Woo00<007ooOol0<Woo0W`9EWoo00=l2Goo
Ool05Goo0022Ool00g`9Oomoo`0OOol2000eOol00g`9Oomoo`1COol00g`9Oomoo`0EOol0089oo`03
O0Uoogoo01moo`03001oogoo03Eoo`03O0Uoogoo055oo`03O0Uoogoo01Ioo`00PGoo00=l2GooOol0
87oo00<007ooOol0=Woo00=l2GooOol0D7oo00=l2GooOol05Woo0021Ool00g`9Oomoo`0POol00`00
Oomoo`0gOol00g`9Oomoo`1>Ool00g`9Oomoo`0GOol0081oo`03O0Uoogoo025oo`03001oogoo03Qo
o`9l2Dioo`03O0Uoogoo01Moo`00P7oo00=l2GooOol08Goo00<007ooOol0>Woo00=l2GooOol0BWoo
00=l2GooOol067oo001oOol00g`9Oomoo`0ROol00`00Oomoo`0kOol00g`9Oomoo`19Ool00g`9Oomo
o`0HOol007moo`03O0Uoogoo00Qoo`@000Eoo`8000Aoo`D000Ioo`03001oogoo03aoo`03O0Uoogoo
04Moo`03O0Uoogoo01Uoo`00OWoo00=l2GooOol027oo00<007ooOol00Woo00<007ooOol00Woo0P00
17oo00D007ooOomoo`0000Ioo`03001oogoo03eoo`03O0Uoogoo04Eoo`03O0Uoogoo01Yoo`00OWoo
00=l2GooOol027oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol0?Woo
00=l2GooOol0A7oo00=l2GooOol06Woo001mOol00g`9Oomoo`09Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Oomoo`06Ool3000oOol2O0U3Ool00g`9Oomoo`0KOol007eoo`03O0Uoogoo00Uoo`03
001oogoo009oo`03001oogoo00]oo`03001oogoo00Eoo`03001oogoo045oo`03O0Uoogoo03moo`03
O0Uoogoo01aoo`00O7oo00=l2GooOol02Woo00<007ooOol00Woo00<007ooOol037oo00<007ooOol0
17oo00<007ooOol0@Woo00=l2GooOol0?Goo00=l2GooOol07Goo001lOol00g`9Oomoo`0:Ool00`00
Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol0@goo00=l2GooOol0?7oo
00=l2GooOol07Goo001lOol00g`9Oomoo`0;Ool4000<Ool30007Ool00`00Oomoo`14Ool00g`9Oomo
o`0jOol00g`9Oomoo`0NOol007]oo`03O0Uoogoo02Ioo`03001oogoo04Eoo`9l2CUoo`03O0Uoogoo
01moo`00Ngoo00=l2GooOol09Woo00<007ooOol0Agoo00=l2GooOol0=Goo00=l2GooOol087oo001j
Ool00g`9Oomoo`0WOol00`00Oomoo`18Ool00g`9Oomoo`0cOol00g`9Oomoo`0QOol007Yoo`03O0Uo
ogoo02Moo`03001oogoo04Uoo`9l2C9oo`03O0Uoogoo029oo`00NGoo00=l2GooOol0:7oo00<007oo
Ool0Bgoo0W`9;goo00=l2GooOol08goo001iOol00g`9Oomoo`0XOol2001>Ool2O0T/Ool00g`9Oomo
o`0TOol007Uoo`03O0Uoogoo02Qoo`03001oogoo04moo`03O0Uoogoo02Qoo`03O0Uoogoo02Eoo`00
N7oo00=l2GooOol0:Goo00<007ooOol0D7oo0W`99Woo0W`9:7oo001hOol00g`9Oomoo`0YOol00`00
Oomoo`1BOol2O0TSOol00g`9Oomoo`0XOol007Moo`03O0Uoogoo02Yoo`03001oogoo05Aoo`03O0Uo
ogoo01ioo`9l2B]oo`00Mgoo00=l2GooOol0:Woo00<007ooOol0EGoo0W`977oo0W`9;Goo001gOol0
0g`9Oomoo`0ZOol00`00Oomoo`1GOol2O0THOol2O0T_Ool007Ioo`03O0Uoogoo02]oo`03001oogoo
05Uoo`Al2A9oo`9l2C5oo`00MWoo00=l2GooOol0:goo00<007ooOol0GGoo1G`91goo1W`9<goo001e
Ool00g`9Oomoo`0/Ool2001SOol7O0TiOol007Eoo`03O0Uoogoo02aoo`03001oogoo0:9oo`00M7oo
00=l2GooOol0;Goo00<007ooOol0XWoo001dOol00g`9Oomoo`0]Ool00`00Oomoo`2ROol007Aoo`03
O0Uoogoo02eoo`03001oogoo0:9oo`00Lgoo00=l2GooOol0;Woo00<007ooOol0XWoo001cOol00g`9
Oomoo`0^Ool00`00Oomoo`2ROol0079oo`03O0Uoogoo02moo`03001oogoo0:9oo`00LWoo00=l2Goo
Ool0;goo00<007ooOol0XWoo001bOol00g`9Oomoo`0_Ool00`00Oomoo`2ROol0075oo`03O0Uoogoo
031oo`800:=oo`00LGoo00=l2GooOol0<7oo00<007ooOol0XWoo001aOol00g`9Oomoo`0`Ool00`00
Oomoo`2ROol0071oo`03O0Uoogoo035oo`03001oogoo0:9oo`00L7oo00=l2GooOol0<Goo00<007oo
Ool0XWoo001`Ool00g`9Oomoo`0aOol00`00Oomoo`2ROol0071oo`03O0Uoogoo035oo`03001oogoo
0:9oo`00Kgoo00=l2GooOol067oo10001Goo0P001goo0`001Goo00<007ooOol0XWoo001_Ool00g`9
Oomoo`0GOol00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`04Ool00`00Oomoo`2R
Ool006moo`03O0Uoogoo01Moo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001o
ogoo0:9oo`00KWoo00=l2GooOol067oo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo
001^Ool00g`9Oomoo`0HOol00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007oo
Ool0XWoo001^Ool00g`9Oomoo`0HOol00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo
00<007ooOol0XWoo001]Ool00g`9Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool0
0006Ool00`00Oomoo`2ROol006eoo`03O0Uoogoo01Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
KGoo00=l2GooOol0=7oo00<007ooOol0XWoo001/Ool00g`9Oomoo`0eOol00`00Oomoo`2ROol006ao
o`03O0Uoogoo03Eoo`03001oogoo0:9oo`00K7oo00=l2GooOol0=Goo00<007ooOol0XWoo001[Ool0
0g`9Oomoo`0fOol00`00Oomoo`2ROol006]oo`03O0Uoogoo03Ioo`800:=oo`00Jgoo00=l2GooOol0
=Woo00<007ooOol0XWoo001[Ool00g`9Oomoo`0fOol00`00Oomoo`2ROol006Yoo`03O0Uoogoo03Mo
o`03001oogoo0:9oo`00JWoo00=l2GooOol0=goo00<007ooOol0XWoo001ZOol00g`9Oomoo`0gOol0
0`00Oomoo`2ROol006Uoo`03O0Uoogoo03Qoo`03001oogoo0:9oo`00JGoo00=l2GooOol0>7oo00<0
07ooOol0XWoo001YOol00g`9Oomoo`0hOol00`00Oomoo`2ROol006Qoo`03O0Uoogoo03Uoo`03001o
ogoo0:9oo`00J7oo00=l2GooOol0>Goo0P00Xgoo001XOol00g`9Oomoo`0iOol00`00Oomoo`2ROol0
06Moo`03O0Uoogoo03Yoo`03001oogoo0:9oo`00Igoo00=l2GooOol0>Woo00<007ooOol0XWoo001W
Ool00g`9Oomoo`0jOol00`00Oomoo`2ROol006Moo`03O0Uoogoo03Yoo`03001oogoo0:9oo`00IWoo
00=l2GooOol0>goo00<007ooOol0XWoo001VOol00g`9Oomoo`0kOol00`00Oomoo`2ROol006Ioo`03
O0Uoogoo03]oo`03001oogoo0:9oo`00IGoo00=l2GooOol0?7oo00<007ooOol0XWoo001UOol00g`9
Oomoo`0lOol2002SOol006Eoo`03O0Uoogoo03aoo`03001oogoo0:9oo`00IGoo00=l2GooOol0?7oo
00<007ooOol0XWoo001TOol00g`9Oomoo`0mOol00`00Oomoo`2ROol006Aoo`03O0Uoogoo03eoo`03
001oogoo0:9oo`00I7oo00=l2GooOol0?Goo00<007ooOol0XWoo001TOol00g`9Oomoo`0mOol00`00
Oomoo`2ROol006=oo`03O0Uoogoo03ioo`03001oogoo0:9oo`00Hgoo00=l2GooOol0?Woo00<007oo
Ool0XWoo001SOol00g`9Oomoo`0nOol00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.28509 .61803 m
.30316 .54574 L
.34309 .42566 L
.3815 .34281 L
.40134 .31127 L
.42237 .28542 L
.43178 .27622 L
.4419 .26786 L
.45139 .26141 L
.4602 .25657 L
.47031 .25232 L
.47564 .25061 L
.48134 .24919 L
.48394 .24867 L
.48676 .2482 L
.48925 .24786 L
.49187 .24758 L
.49424 .2474 L
.49559 .24732 L
.49685 .24727 L
.498 .24724 L
.49906 .24722 L
.50027 .24721 L
.50143 .24722 L
.50256 .24725 L
.50379 .24729 L
.50495 .24735 L
.50601 .24741 L
.50848 .2476 L
.51108 .24787 L
.51598 .24856 L
.52133 .24958 L
.53088 .25207 L
.53975 .25511 L
.56021 .26448 L
.5788 .27546 L
.61878 .30494 L
.65725 .33749 L
.69817 .37219 L
.73757 .40138 L
.75737 .41313 L
.77546 .42157 L
.78543 .42512 L
.7949 .42769 L
.80009 .42875 L
.8049 .4295 L
.80767 .42982 L
.81018 .43005 L
.81157 .43015 L
.81307 .43023 L
Mistroke
.81376 .43026 L
.81449 .43029 L
.8158 .43032 L
.81702 .43033 L
.81771 .43033 L
.81835 .43033 L
.81953 .43031 L
.82077 .43027 L
.82188 .43023 L
.82293 .43017 L
.8253 .42999 L
.82786 .42973 L
.8302 .42943 L
.83547 .4285 L
.83975 .4275 L
.84442 .42615 L
.85382 .42258 L
.86412 .4173 L
.87347 .41122 L
.89443 .39282 L
.91366 .3697 L
.93447 .33737 L
.97544 .24916 L
.97619 .24721 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`<000eoo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo0004OonN0005O02D00000g`0000000060005Ool000ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Eo
o`Il009oo`03001oog`000El00Moo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00aoo`03O01oogoo00]oo`0037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol00Woo0g`027oo00<007ooOol01Goo0g`017oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00=l07ooOol02goo002GOol2O00;
Ool00`00Oomoo`08Ool3O028Ool00g`0Oomoo`0<Ool009Eoo`9l00eoo`03001oogoo00]oo`9l08Io
o`03O01oogoo00aoo`00U7oo00=l07ooOol03Goo00<007ooOol03Goo0W`0Pgoo00=l07ooOol03Goo
002BOol2O00@Ool00`00Oomoo`0?Ool2O021Ool00g`0Oomoo`0=Ool0095oo`03O01oogoo011oo`03
001oogoo015oo`9l07ioo`03O01oogoo00ioo`00T7oo00=l07ooOol04Goo00<007ooOol04goo0W`0
O7oo00=l07ooOol03Woo002?Ool00g`0Oomoo`0BOol00`00Oomoo`0EOol2O01iOol00g`0Oomoo`0?
Ool008ioo`03O01oogoo01=oo`8001Qoo`03O01oogoo07Ioo`03O01oogoo00moo`00SGoo00=l07oo
Ool057oo00<007ooOol067oo00=l07ooOol0M7oo00=l07ooOol047oo002<Ool00g`0Oomoo`0EOol0
0`00Oomoo`0IOol2O01dOol00g`0Oomoo`0@Ool008]oo`03O01oogoo01Ioo`03001oogoo01]oo`03
O01oogoo071oo`03O01oogoo015oo`00RWoo00=l07ooOol05goo00<007ooOol077oo00=l07ooOol0
Kgoo00=l07ooOol04Goo0029Ool00g`0Oomoo`0HOol00`00Oomoo`0MOol00g`0Oomoo`1]Ool00g`0
Oomoo`0BOol008Qoo`03O01oogoo01Uoo`03001oogoo01ioo`03O01oogoo06aoo`03O01oogoo019o
o`00Qgoo00=l07ooOol06Woo00<007ooOol07goo0W`0K7oo00=l07ooOol04Woo0027Ool00g`0Oomo
o`0JOol00`00Oomoo`0QOol00g`0Oomoo`1XOol00g`0Oomoo`0COol008Ioo`03O01oogoo01]oo`03
001oogoo029oo`03O01oogoo06Moo`03O01oogoo01=oo`00QGoo00=l07ooOol077oo0P0097oo00=l
07ooOol0IGoo00=l07ooOol057oo0024Ool00g`0Oomoo`0MOol00`00Oomoo`0TOol2O01UOol00g`0
Oomoo`0DOol008=oo`03O01oogoo01ioo`03001oogoo02Ioo`03O01oogoo065oo`03O01oogoo01Eo
o`00Pgoo00=l07ooOol07Woo00<007ooOol09goo00=l07ooOol0H7oo00=l07ooOol05Goo0022Ool0
0g`0Oomoo`0OOol00`00Oomoo`0XOol2O01OOol00g`0Oomoo`0FOol0089oo`03O01oogoo01moo`03
001oogoo02Yoo`03O01oogoo05aoo`03O01oogoo01Ioo`00PGoo00=l07ooOol087oo00<007ooOol0
:goo00=l07ooOol0FWoo00=l07ooOol05goo0020Ool00g`0Oomoo`0QOol00`00Oomoo`0/Ool2O01J
Ool00g`0Oomoo`0GOol0081oo`03O01oogoo025oo`03001oogoo02ioo`03O01oogoo05Ioo`03O01o
ogoo01Qoo`00Ogoo00=l07ooOol08Woo00<007ooOol0;goo00=l07ooOol0EGoo00=l07ooOol067oo
001oOol00g`0Oomoo`0ROol2000aOol00g`0Oomoo`1COol00g`0Oomoo`0IOol007ioo`03O01oogoo
02=oo`03001oogoo035oo`03O01oogoo059oo`03O01oogoo01Uoo`00OWoo00=l07ooOol08goo00<0
07ooOol0<Woo0W`0DGoo00=l07ooOol06Woo001mOol00g`0Oomoo`0TOol00`00Oomoo`0dOol00g`0
Oomoo`1=Ool00g`0Oomoo`0KOol007eoo`03O01oogoo02Aoo`03001oogoo03Eoo`03O01oogoo04]o
o`03O01oogoo01aoo`00O7oo00=l07ooOol09Goo00<007ooOol0=Woo00=l07ooOol0BWoo00=l07oo
Ool077oo001lOol00g`0Oomoo`0UOol00`00Oomoo`0gOol00g`0Oomoo`18Ool00g`0Oomoo`0MOol0
07]oo`03O01oogoo00aoo`@000Eoo`8000Aoo`D000Ioo`03001oogoo03Qoo`9l04Moo`03O01oogoo
01ioo`00Ngoo00=l07ooOol02goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00D007ooOomo
o`0000Ioo`03001oogoo03Yoo`03O01oogoo04Aoo`03O01oogoo01ioo`00NWoo00=l07ooOol037oo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol0>goo00=l07ooOol0@Woo
00=l07ooOol07goo001jOol00g`0Oomoo`0<Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomo
o`06Ool3000lOol00g`0Oomoo`10Ool00g`0Oomoo`0POol007Uoo`03O01oogoo00eoo`03001oogoo
009oo`03001oogoo00]oo`03001oogoo00Eoo`03001oogoo03eoo`03O01oogoo03ioo`03O01oogoo
025oo`00NGoo00=l07ooOol03Goo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<0
07ooOol0?Woo00=l07ooOol0?Goo00=l07ooOol08Goo001hOol00g`0Oomoo`0>Ool00`00Oomoo`02
Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol0?goo0W`0?7oo00=l07ooOol08Woo
001hOol00g`0Oomoo`0?Ool4000<Ool30007Ool00`00Oomoo`11Ool00g`0Oomoo`0hOol00g`0Oomo
o`0SOol007Qoo`03O01oogoo02Uoo`03001oogoo049oo`03O01oogoo03Ioo`03O01oogoo02Aoo`00
Mgoo00=l07ooOol0:Woo00<007ooOol0@goo00=l07ooOol0=Goo00=l07ooOol097oo001gOol00g`0
Oomoo`0ZOol00`00Oomoo`14Ool00g`0Oomoo`0cOol00g`0Oomoo`0UOol007Ioo`03O01oogoo02]o
o`03001oogoo04Eoo`9l039oo`03O01oogoo02Ioo`00MWoo00=l07ooOol0:goo00<007ooOol0Agoo
00=l07ooOol0;Woo00=l07ooOol09goo001eOol00g`0Oomoo`0/Ool20019Ool2O00]Ool00g`0Oomo
o`0XOol007Eoo`03O01oogoo02aoo`03001oogoo04Yoo`9l02Yoo`03O01oogoo02Uoo`00M7oo00=l
07ooOol0;Goo00<007ooOol0C7oo0W`09goo00=l07ooOol0:Woo001dOol00g`0Oomoo`0]Ool00`00
Oomoo`1>Ool2O00TOol00g`0Oomoo`0[Ool007=oo`03O01oogoo02ioo`03001oogoo051oo`9l021o
o`9l02ioo`00Lgoo00=l07ooOol0;Woo00<007ooOol0DWoo0W`077oo0W`0<7oo001bOol00g`0Oomo
o`0_Ool00`00Oomoo`1DOol2O00FOol4O00bOol0079oo`03O01oogoo02moo`03001oogoo05Ioo`Al
011oo`9l03Ioo`00LWoo00=l07ooOol0;goo00<007ooOol0FWoo1G`01goo17`0>7oo001aOol00g`0
Oomoo`0`Ool2001POol7O00lOol0075oo`03O01oogoo031oo`03001oogoo0:9oo`00LGoo00=l07oo
Ool0<7oo00<007ooOol0XWoo001`Ool00g`0Oomoo`0aOol00`00Oomoo`2ROol0071oo`03O01oogoo
035oo`03001oogoo0:9oo`00L7oo00=l07ooOol0<Goo00<007ooOol0XWoo001_Ool00g`0Oomoo`0b
Ool00`00Oomoo`2ROol006moo`03O01oogoo039oo`03001oogoo0:9oo`00Kgoo00=l07ooOol0<Woo
00<007ooOol0XWoo001^Ool00g`0Oomoo`0cOol00`00Oomoo`2ROol006ioo`03O01oogoo03=oo`80
0:=oo`00KWoo00=l07ooOol0<goo00<007ooOol0XWoo001]Ool00g`0Oomoo`0dOol00`00Oomoo`2R
Ool006eoo`03O01oogoo03Aoo`03001oogoo0:9oo`00KGoo00=l07ooOol0=7oo00<007ooOol0XWoo
001/Ool00g`0Oomoo`0eOol00`00Oomoo`2ROol006aoo`03O01oogoo03Eoo`03001oogoo0:9oo`00
Jgoo00=l07ooOol077oo10001Goo0P001goo0`001Goo00<007ooOol0XWoo001[Ool00g`0Oomoo`0K
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`04Ool00`00Oomoo`2ROol006]o
o`03O01oogoo01]oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9o
o`00JWoo00=l07ooOol077oo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo001ZOol0
0g`0Oomoo`0LOol00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo
001ZOol00g`0Oomoo`0LOol00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007oo
Ool0XWoo001YOol00g`0Oomoo`0MOol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool0
0`00Oomoo`2ROol006Uoo`03O01oogoo01ioo`@000ioo`8000Ioo`03001oogoo0:9oo`00JGoo00=l
07ooOol0>7oo00<007ooOol0XWoo001XOol00g`0Oomoo`0iOol00`00Oomoo`2ROol006Qoo`03O01o
ogoo03Uoo`03001oogoo0:9oo`00J7oo00=l07ooOol0>Goo00<007ooOol0XWoo001WOol00g`0Oomo
o`0jOol00`00Oomoo`2ROol006Moo`03O01oogoo03Yoo`800:=oo`00Igoo00=l07ooOol0>Woo00<0
07ooOol0XWoo001VOol00g`0Oomoo`0kOol00`00Oomoo`2ROol006Ioo`03O01oogoo03]oo`03001o
ogoo0:9oo`00IWoo00=l07ooOol0>goo00<007ooOol0XWoo001UOol00g`0Oomoo`0lOol00`00Oomo
o`2ROol006Eoo`03O01oogoo03aoo`03001oogoo0:9oo`00IGoo00=l07ooOol0?7oo00<007ooOol0
XWoo001TOol00g`0Oomoo`0mOol00`00Oomoo`2ROol006Aoo`03O01oogoo03eoo`03001oogoo0:9o
o`00I7oo00=l07ooOol0?Goo0P00Xgoo001TOol00g`0Oomoo`0mOol00`00Oomoo`2ROol006=oo`03
O01oogoo03ioo`03001oogoo0:9oo`00Hgoo00=l07ooOol0?Woo00<007ooOol0XWoo001SOol00g`0
Oomoo`0nOol00`00Oomoo`2ROol006=oo`03O01oogoo03ioo`03001oogoo0:9oo`00HWoo00=l07oo
Ool0?goo00<007ooOol0XWoo001ROol00g`0Oomoo`0oOol00`00Oomoo`2ROol0069oo`03O01oogoo
03moo`03001oogoo0:9oo`00HWoo00=l07ooOol0?goo00<007ooOol0XWoo001QOol00g`0Oomoo`10
Ool2002SOol0065oo`03O01oogoo041oo`03001oogoo0:9oo`00HGoo00=l07ooOol0@7oo00<007oo
Ool0XWoo001QOol00g`0Oomoo`10Ool00`00Oomoo`2ROol0061oo`03O01oogoo045oo`03001oogoo
0:9oo`00H7oo00=l07ooOol0@Goo00<007ooOol0XWoo001POol00g`0Oomoo`11Ool00`00Oomoo`2R
Ool0061oo`03O01oogoo045oo`03001oogoo0:9oo`00Ggoo00=l07ooOol0@Woo00<007ooOol0XWoo
001OOol00g`0Oomoo`12Ool00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .3 0 r
.5 Mabswid
.27289 .61803 m
.30316 .50606 L
.32392 .4448 L
.34309 .39674 L
.3815 .32302 L
.40022 .29707 L
.42085 .27534 L
.44026 .26094 L
.45116 .25523 L
.45599 .25321 L
.46114 .2514 L
.4663 .24992 L
.47098 .24887 L
.47324 .24845 L
.47569 .24807 L
.47798 .24778 L
.48012 .24757 L
.48262 .24738 L
.48395 .24731 L
.48469 .24728 L
.48537 .24725 L
.48608 .24724 L
.48686 .24722 L
.48754 .24722 L
.48827 .24721 L
.48953 .24722 L
.49024 .24724 L
.49092 .24726 L
.49213 .2473 L
.49341 .24737 L
.49569 .24752 L
.49815 .24775 L
.50085 .24808 L
.50613 .24892 L
.51112 .24996 L
.52046 .25253 L
.53051 .25615 L
.54141 .26097 L
.58233 .28604 L
.62173 .31724 L
.65962 .34982 L
.69996 .38303 L
.73878 .40944 L
.74891 .41492 L
.75995 .42009 L
.7705 .42413 L
.78006 .42698 L
.78494 .42812 L
.79021 .42909 L
.79264 .42945 L
Mistroke
.79519 .42976 L
.79738 .42998 L
.79977 .43015 L
.80118 .43023 L
.80187 .43026 L
.80251 .43028 L
.80371 .43032 L
.80501 .43033 L
.80631 .43033 L
.80705 .43032 L
.80774 .43031 L
.80846 .43029 L
.80913 .43026 L
.81063 .43019 L
.81185 .43012 L
.81299 .43003 L
.81556 .42978 L
.81808 .42946 L
.82075 .42904 L
.8261 .42793 L
.83102 .42661 L
.84214 .42248 L
.85194 .41746 L
.8623 .41069 L
.88192 .39345 L
.90024 .37174 L
.92057 .34081 L
.93912 .30582 L
.97619 .21475 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo
00<007ooOol0XWoo002TOol2002SOol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002T
Ool00`00Oomoo`2ROol000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Ioo`D000aoo`003Goo
00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04Mo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0B7oo00<007ooOol037oo000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool0
0`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo04Uoo`03OB0007oo00]oo`003Goo00D007ooOomoo`0004Qo
o`<004Moo`8004Moo`<004Qoo`05001oogooOB00000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Moo`03001m800000eoo`00Y7oo00<007ooOol0Tgoo00=m87ooOol0
37oo002TOol00`00Oomoo`2BOol00gdPOomoo`0=Ool00:Aoo`03001oogoo099oo`03OB1oogoo00eo
o`00Y7oo00<007ooOol0TWoo00=m87ooOol03Goo002TOol00`00Oomoo`2AOol00gdPOomoo`0>Ool0
0:Aoo`03001oogoo095oo`03OB1oogoo00ioo`00Y7oo00<007ooOol0T7oo00=m87ooOol03goo0004
OonJ0005OB2D00000gdP0000000:0005Ool000aoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo009oo`Em80Aoo`Mm80Yoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00Moo`03OB1oogoo009oo`03001oogoo00]oo`0037oo
00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo
00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOB000WdP
2goo00<007ooOol00Woo0gdP1goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol01goo00=m87ooOol00Woo00<007ooOol02goo002DOol2OB0>Ool00`00Oomoo`05Ool2OB28
Ool00gdPOomoo`0@Ool0099oo`9m811oo`03001oogoo00Moo`9m88Eoo`03OB1oogoo015oo`00TGoo
00=m87ooOol047oo00<007ooOol02Goo0WdPPgoo00=m87ooOol04Goo002?Ool2OB0COol00`00Oomo
o`0;Ool2OB20Ool00gdPOomoo`0BOol008eoo`9m81Eoo`03001oogoo00eoo`9m87ioo`03OB1oogoo
019oo`00Rgoo0WdP5goo00<007ooOol03goo00=m87ooOol0Ngoo00=m87ooOol04Woo002:Ool00gdP
Oomoo`0GOol00`00Oomoo`0@Ool2OB1jOol00gdPOomoo`0COol008Uoo`03OB1oogoo01Qoo`8001=o
o`03OB1oogoo07Moo`03OB1oogoo01=oo`00R7oo00=m87ooOol06Goo00<007ooOol04goo0WdPMWoo
00=m87ooOol057oo0027Ool00gdPOomoo`0JOol00`00Oomoo`0EOol2OB1dOol00gdPOomoo`0DOol0
08Moo`03OB1oogoo01Yoo`03001oogoo01Moo`03OB1oogoo071oo`03OB1oogoo01Eoo`00QWoo00=m
87ooOol06goo00<007ooOol067oo00=m87ooOol0Kgoo00=m87ooOol05Goo0025Ool00gdPOomoo`0L
Ool00`00Oomoo`0IOol00gdPOomoo`1^Ool00gdPOomoo`0EOol008Aoo`03OB1oogoo01eoo`03001o
ogoo01Yoo`9m86eoo`03OB1oogoo01Ioo`00Pgoo00=m87ooOol07Woo00<007ooOol077oo00=m87oo
Ool0JWoo00=m87ooOol05Woo0023Ool00gdPOomoo`0NOol00`00Oomoo`0MOol00gdPOomoo`1XOol0
0gdPOomoo`0GOol0089oo`03OB1oogoo01moo`03001oogoo01ioo`03OB1oogoo06Moo`03OB1oogoo
01Moo`00PGoo00=m87ooOol087oo0P0087oo00=m87ooOol0IWoo00=m87ooOol05goo0021Ool00gdP
Oomoo`0POol00`00Oomoo`0POol2OB1UOol00gdPOomoo`0HOol0081oo`03OB1oogoo025oo`03001o
ogoo029oo`03OB1oogoo069oo`03OB1oogoo01Qoo`00Ogoo00=m87ooOol08Woo00<007ooOol08goo
00=m87ooOol0H7oo00=m87ooOol06Goo001oOol00gdPOomoo`0ROol00`00Oomoo`0TOol00gdPOomo
o`1OOol00gdPOomoo`0IOol007ioo`03OB1oogoo02=oo`03001oogoo02Eoo`03OB1oogoo05eoo`03
OB1oogoo01Yoo`00OGoo00=m87ooOol097oo00<007ooOol09Woo0WdPGGoo00=m87ooOol06Woo001m
Ool00gdPOomoo`0TOol00`00Oomoo`0XOol00gdPOomoo`1IOol00gdPOomoo`0KOol007aoo`03OB1o
ogoo02Eoo`03001oogoo02Uoo`03OB1oogoo05Qoo`03OB1oogoo01]oo`00O7oo00=m87ooOol09Goo
00<007ooOol0:Woo00=m87ooOol0EWoo00=m87ooOol077oo001kOol00gdPOomoo`0VOol2000/Ool0
0gdPOomoo`1EOol00gdPOomoo`0LOol007]oo`03OB1oogoo02Ioo`03001oogoo02aoo`9m85Aoo`03
OB1oogoo01eoo`00NWoo00=m87ooOol09goo00<007ooOol0;Woo00=m87ooOol0DGoo00=m87ooOol0
7Goo001jOol00gdPOomoo`0WOol00`00Oomoo`0_Ool00gdPOomoo`1?Ool00gdPOomoo`0NOol007Uo
o`03OB1oogoo02Qoo`03001oogoo031oo`03OB1oogoo04eoo`03OB1oogoo01moo`00NGoo00=m87oo
Ool0:7oo00<007ooOol0<Goo00=m87ooOol0Bgoo00=m87ooOol087oo001hOol00gdPOomoo`0YOol0
0`00Oomoo`0bOol2OB1;Ool00gdPOomoo`0POol007Qoo`03OB1oogoo00moo`@000Eoo`8000Aoo`D0
00Ioo`03001oogoo03Aoo`03OB1oogoo04Moo`03OB1oogoo025oo`00Mgoo00=m87ooOol03goo00<0
07ooOol00Woo00<007ooOol00Woo0P0017oo00D007ooOomoo`0000Ioo`03001oogoo03Eoo`03OB1o
ogoo04Eoo`03OB1oogoo029oo`00Mgoo00=m87ooOol03goo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol01goo00<007ooOol0=Woo00=m87ooOol0A7oo00=m87ooOol08Woo001fOol00gdPOomo
o`0@Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool3000gOol00gdPOomoo`12Ool0
0gdPOomoo`0SOol007Ioo`03OB1oogoo011oo`03001oogoo009oo`03001oogoo00]oo`03001oogoo
00Eoo`03001oogoo03Qoo`9m845oo`03OB1oogoo02Aoo`00MGoo00=m87ooOol04Goo00<007ooOol0
0Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol0>Woo00=m87ooOol0?Goo00=m87ooOol0
9Goo001eOol00gdPOomoo`0AOol00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo
00<007ooOol0>goo00=m87ooOol0>goo00=m87ooOol09Woo001dOol00gdPOomoo`0COol4000<Ool3
0007Ool00`00Oomoo`0lOol00gdPOomoo`0jOol00gdPOomoo`0VOol007Aoo`03OB1oogoo02eoo`03
001oogoo03eoo`9m83Uoo`03OB1oogoo02Moo`00Lgoo00=m87ooOol0;Woo00<007ooOol0?goo0WdP
=Woo00=m87ooOol0:7oo001cOol00gdPOomoo`0^Ool00`00Oomoo`11Ool00gdPOomoo`0bOol00gdP
Oomoo`0YOol0079oo`03OB1oogoo02moo`03001oogoo049oo`9m835oo`03OB1oogoo02Yoo`00LWoo
00=m87ooOol0;goo00<007ooOol0A7oo00=m87ooOol0;Goo00=m87ooOol0:goo001aOol00gdPOomo
o`0`Ool20016Ool2OB0[Ool2OB0^Ool0075oo`03OB1oogoo031oo`03001oogoo04Moo`9m82Qoo`03
OB1oogoo02ioo`00L7oo00=m87ooOol0<Goo00<007ooOol0BGoo00=m87ooOol097oo00=m87ooOol0
;goo001`Ool00gdPOomoo`0aOol00`00Oomoo`1:Ool2OB0SOol00gdPOomoo`0`Ool0071oo`03OB1o
ogoo035oo`03001oogoo04aoo`9m821oo`03OB1oogoo035oo`00Kgoo00=m87ooOol0<Woo00<007oo
Ool0CWoo0WdP77oo0WdP=7oo001_Ool00gdPOomoo`0bOol00`00Oomoo`1@Ool2OB0HOol2OB0fOol0
06ioo`03OB1oogoo03=oo`03001oogoo059oo`=m81=oo`9m83Qoo`00KWoo00=m87ooOol0<goo00<0
07ooOol0EGoo1WdP1goo1WdP>Woo001^Ool00gdPOomoo`0cOol2001LOol7OB10Ool006eoo`03OB1o
ogoo03Aoo`03001oogoo0:9oo`00KGoo00=m87ooOol0=7oo00<007ooOol0XWoo001/Ool00gdPOomo
o`0eOol00`00Oomoo`2ROol006aoo`03OB1oogoo03Eoo`03001oogoo0:9oo`00K7oo00=m87ooOol0
=Goo00<007ooOol0XWoo001[Ool00gdPOomoo`0fOol00`00Oomoo`2ROol006]oo`03OB1oogoo03Io
o`03001oogoo0:9oo`00Jgoo00=m87ooOol0=Woo00<007ooOol0XWoo001ZOol00gdPOomoo`0gOol0
0`00Oomoo`2ROol006Yoo`03OB1oogoo03Moo`800:=oo`00JWoo00=m87ooOol0=goo00<007ooOol0
XWoo001YOol00gdPOomoo`0hOol00`00Oomoo`2ROol006Uoo`03OB1oogoo03Qoo`03001oogoo0:9o
o`00J7oo00=m87ooOol0>Goo00<007ooOol0XWoo001XOol00gdPOomoo`0iOol00`00Oomoo`2ROol0
06Qoo`03OB1oogoo03Uoo`03001oogoo0:9oo`00Igoo00=m87ooOol087oo10001Goo0P001goo0`00
1Goo00<007ooOol0XWoo001WOol00gdPOomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`02Ool20008
Ool00`00Oomoo`04Ool00`00Oomoo`2ROol006Moo`03OB1oogoo01moo`03001oogoo009oo`03001o
ogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00IWoo00=m87ooOol087oo00<007ooOol00Woo
00<007ooOol027oo1P001Goo0`00XWoo001VOol00gdPOomoo`0POol00`00Oomoo`02Ool00`00Oomo
o`09Ool01000Oomoo`001Woo00<007ooOol0XWoo001VOol00gdPOomoo`0POol00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo001UOol00gdPOomoo`0QOol00`00Oomo
o`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol006Eoo`03OB1oogoo029oo`@0
00ioo`8000Ioo`03001oogoo0:9oo`00IGoo00=m87ooOol0?7oo00<007ooOol0XWoo001TOol00gdP
Oomoo`0mOol00`00Oomoo`2ROol006Aoo`03OB1oogoo03eoo`03001oogoo0:9oo`00I7oo00=m87oo
Ool0?Goo00<007ooOol0XWoo001TOol00gdPOomoo`0mOol00`00Oomoo`2ROol006=oo`03OB1oogoo
03ioo`800:=oo`00Hgoo00=m87ooOol0?Woo00<007ooOol0XWoo001SOol00gdPOomoo`0nOol00`00
Oomoo`2ROol0069oo`03OB1oogoo03moo`03001oogoo0:9oo`00HWoo00=m87ooOol0?goo00<007oo
Ool0XWoo001ROol00gdPOomoo`0oOol00`00Oomoo`2ROol0069oo`03OB1oogoo03moo`03001oogoo
0:9oo`00HGoo00=m87ooOol0@7oo00<007ooOol0XWoo001QOol00gdPOomoo`10Ool00`00Oomoo`2R
Ool0065oo`03OB1oogoo041oo`03001oogoo0:9oo`00H7oo00=m87ooOol0@Goo0P00Xgoo001POol0
0gdPOomoo`11Ool00`00Oomoo`2ROol0061oo`03OB1oogoo045oo`03001oogoo0:9oo`00H7oo00=m
87ooOol0@Goo00<007ooOol0XWoo001OOol00gdPOomoo`12Ool00`00Oomoo`2ROol005moo`03OB1o
ogoo049oo`03001oogoo0:9oo`00Ggoo00=m87ooOol0@Woo00<007ooOol0XWoo001NOol00gdPOomo
o`13Ool00`00Oomoo`2ROol005ioo`03OB1oogoo04=oo`03001oogoo0:9oo`00GWoo00=m87ooOol0
@goo00<007ooOol0XWoo001NOol00gdPOomoo`13Ool2002SOol005eoo`03OB1oogoo04Aoo`03001o
ogoo0:9oo`00GGoo00=m87ooOol0A7oo00<007ooOol0XWoo001MOol00gdPOomoo`14Ool00`00Oomo
o`2ROol005aoo`03OB1oogoo04Eoo`03001oogoo0:9oo`00G7oo00=m87ooOol0AGoo00<007ooOol0
XWoo001LOol00gdPOomoo`15Ool00`00Oomoo`2ROol005aoo`03OB1oogoo04Eoo`03001oogoo0:9o
o`00Fgoo00=m87ooOol0AWoo00<007ooOol0XWoo001KOol00gdPOomoo`16Ool00`00Oomoo`2ROol0
0001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .6 0 r
.5 Mabswid
.26011 .61803 m
.26171 .61092 L
.30316 .46973 L
.32392 .41403 L
.34309 .37079 L
.36292 .33379 L
.3815 .30581 L
.40022 .28369 L
.4108 .27372 L
.42085 .26585 L
.43053 .25967 L
.4411 .25442 L
.44575 .25259 L
.4507 .25094 L
.45504 .24976 L
.45962 .24876 L
.46218 .24832 L
.46498 .24791 L
.46753 .24763 L
.46991 .24743 L
.47135 .24734 L
.47206 .24731 L
.47272 .24728 L
.47394 .24724 L
.47459 .24723 L
.47528 .24722 L
.47596 .24721 L
.47669 .24721 L
.47738 .24722 L
.47801 .24723 L
.47872 .24725 L
.47948 .24727 L
.48103 .24734 L
.48239 .24742 L
.48368 .24751 L
.48609 .24774 L
.48868 .24804 L
.49148 .24845 L
.4965 .24937 L
.5012 .25045 L
.51067 .25322 L
.52108 .25716 L
.54212 .26763 L
.58095 .29387 L
.62222 .32781 L
.66198 .36196 L
.70023 .39209 L
.72159 .40631 L
.74093 .41686 L
.75063 .42116 L
Mistroke
.76112 .42496 L
.76593 .42639 L
.77101 .42767 L
.77569 .42864 L
.78011 .42936 L
.78249 .42967 L
.78508 .42994 L
.78623 .43004 L
.78744 .43013 L
.78857 .4302 L
.78961 .43025 L
.79081 .43029 L
.79211 .43032 L
.79325 .43033 L
.79445 .43033 L
.79577 .43031 L
.797 .43027 L
.79771 .43024 L
.79835 .43021 L
.79979 .43013 L
.80215 .42993 L
.80432 .4297 L
.80923 .42897 L
.81356 .42808 L
.81813 .4269 L
.82759 .42361 L
.83775 .41875 L
.85607 .40631 L
.86623 .39724 L
.87729 .38551 L
.8974 .35887 L
.91715 .32563 L
.93815 .28198 L
.97587 .18008 L
.97619 .17908 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol0
0`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2ROol00:Ao
o`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo
0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo09Aoo`03OT1o
ogoo00]oo`00Y7oo00<007ooOol0U7oo00=n@7ooOol02goo002TOol2002DOol00gi0Oomoo`0<Ool0
0:Aoo`03001oogoo09=oo`03OT1oogoo00aoo`00Y7oo00<007ooOol0TWoo00=n@7ooOol03Goo002T
Ool00`00Oomoo`2BOol00gi0Oomoo`0=Ool000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004Io
o`03001n@000008000aoo`003Goo00D007ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qo
o`03001oogoo04Ioo`05OT1oogooOol0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo04Ioo`03OT0007oo00ioo`001Goo1P0017oo00<007ooOol0?goo1P00
1Goo00<007ooOol0AGoo00<007ooOol0B7oo00<007ooOol0AWoo00=n@7oo00003Woo000@Ool00`00
Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`15Ool01Gi0Oomoogoo00003Goo
000AOol00`00Oomoo`18Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`15Ool00gi0Oomo
o`02Ool00`00Oomoo`0:Ool000eoo`05001oogooOol00018Ool30017Ool20017Ool30016Ool00gi0
Ool00003Ool00`00Oomoo`0:Ool000ioo`<004]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001o
ogoo04Aoo`03OT1oogoo00<000eoo`00Y7oo00<007ooOol0Sgoo00=n@7ooOol047oo002TOol00`00
Oomoo`2>Ool00gi0Oomoo`0AOol00:Aoo`03001oogoo08ioo`03OT1oogoo015oo`00Y7oo00<007oo
Ool0SWoo00=n@7ooOol04Goo002TOol00`00Oomoo`2=Ool00gi0Oomoo`0BOol00:Aoo`03001oogoo
08eoo`03OT1oogoo019oo`00Y7oo00<007ooOol0S7oo00=n@7ooOol04goo0004OonF0005OT2D0000
0gi00000000>0005Ool000aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00aoo`03001n@7i000=n@0Aoo`Qn@0eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo
00aoo`03001oogoo00Aoo`03OT1oogoo00Eoo`03001oogoo00]oo`0037oo00<007ooOol037oo00<0
07ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol037oo00<007ooOol037oo00<007ooOol02Woo0gi03goo00@007ooOT1n@0]oo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00=oo`03OT1oogoo00Ioo`03001oogoo
00]oo`00T7oo0Wi04Woo00@007ooOomoo`9n@8Qoo`03OT1oogoo01Aoo`00SWoo0Wi057oo00<007oo
Ool00goo0Wi0QWoo00=n@7ooOol057oo002<Ool2OT0FOol00`00Oomoo`05Ool2OT23Ool00gi0Oomo
o`0EOol008Yoo`9n@1Qoo`03001oogoo00Moo`9n@85oo`03OT1oogoo01Eoo`00RGoo00=n@7ooOol0
67oo00<007ooOol02Goo0Wi0OWoo00=n@7ooOol05Woo0028Ool00gi0Oomoo`0IOol00`00Oomoo`0;
Ool2OT1lOol00gi0Oomoo`0FOol008Moo`03OT1oogoo01Yoo`03001oogoo00eoo`03OT1oogoo07Uo
o`03OT1oogoo01Ioo`00QWoo00=n@7ooOol06goo0P003goo0Wi0N7oo00=n@7ooOol05goo0025Ool0
0gi0Oomoo`0LOol00`00Oomoo`0@Ool00gi0Oomoo`1eOol00gi0Oomoo`0GOol008Aoo`03OT1oogoo
01eoo`03001oogoo015oo`9n@7Aoo`03OT1oogoo01Qoo`00Pgoo00=n@7ooOol07Woo00<007ooOol0
4goo00=n@7ooOol0LGoo00=n@7ooOol067oo0022Ool00gi0Oomoo`0OOol00`00Oomoo`0DOol2OT1`
Ool00gi0Oomoo`0IOol0085oo`03OT1oogoo021oo`03001oogoo01Ioo`03OT1oogoo06eoo`03OT1o
ogoo01Uoo`00PGoo00=n@7ooOol087oo00<007ooOol05goo00=n@7ooOol0Jgoo00=n@7ooOol06Woo
0020Ool00gi0Oomoo`0QOol00`00Oomoo`0HOol2OT1[Ool00gi0Oomoo`0JOol007moo`03OT1oogoo
029oo`03001oogoo01Yoo`03OT1oogoo06Moo`03OT1oogoo01]oo`00OWoo00=n@7ooOol08goo00<0
07ooOol06goo00=n@7ooOol0IWoo00=n@7ooOol06goo001mOol00gi0Oomoo`0TOol2000MOol00gi0
Oomoo`1TOol00gi0Oomoo`0LOol007eoo`03OT1oogoo02Aoo`03001oogoo01eoo`9n@6Aoo`03OT1o
ogoo01aoo`00O7oo00=n@7ooOol09Goo00<007ooOol07goo00=n@7ooOol0H7oo00=n@7ooOol07Goo
001kOol00gi0Oomoo`0VOol00`00Oomoo`0POol00gi0Oomoo`1OOol00gi0Oomoo`0MOol007]oo`03
OT1oogoo02Ioo`03001oogoo025oo`9n@5ioo`03OT1oogoo01ioo`00NWoo00=n@7ooOol09goo00<0
07ooOol08goo00=n@7ooOol0Fgoo00=n@7ooOol07Woo001iOol00gi0Oomoo`0XOol00`00Oomoo`0T
Ool00gi0Oomoo`1IOol00gi0Oomoo`0OOol007Uoo`03OT1oogoo02Qoo`03001oogoo02Eoo`03OT1o
ogoo05Qoo`03OT1oogoo01moo`00N7oo00=n@7ooOol0:Goo00<007ooOol09Woo00=n@7ooOol0EWoo
00=n@7ooOol087oo001gOol00gi0Oomoo`0ZOol00`00Oomoo`0WOol00gi0Oomoo`1EOol00gi0Oomo
o`0POol007Moo`03OT1oogoo02Yoo`8002Uoo`03OT1oogoo05=oo`03OT1oogoo025oo`00MWoo00=n
@7ooOol0:goo00<007ooOol0:Goo00=n@7ooOol0DWoo00=n@7ooOol08Goo001fOol00gi0Oomoo`0[
Ool00`00Oomoo`0ZOol2OT1AOol00gi0Oomoo`0ROol007Eoo`03OT1oogoo02aoo`03001oogoo02ao
o`03OT1oogoo04ioo`03OT1oogoo029oo`00MGoo00=n@7ooOol0;7oo00<007ooOol0;Goo00=n@7oo
Ool0C7oo00=n@7ooOol08goo001dOol00gi0Oomoo`0]Ool00`00Oomoo`0^Ool00gi0Oomoo`1;Ool0
0gi0Oomoo`0SOol007Aoo`03OT1oogoo02eoo`03001oogoo02moo`03OT1oogoo04Uoo`03OT1oogoo
02Aoo`00Lgoo00=n@7ooOol057oo10001Goo0P0017oo1@001Woo00<007ooOol0<7oo00=n@7ooOol0
Agoo00=n@7ooOol09Goo001cOol00gi0Oomoo`0COol00`00Oomoo`02Ool00`00Oomoo`02Ool20004
Ool01@00Oomoogoo00001Woo00<007ooOol0<Goo00=n@7ooOol0AGoo00=n@7ooOol09Woo001bOol0
0gi0Oomoo`0DOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`0bOol0
0gi0Oomoo`14Ool00gi0Oomoo`0VOol0079oo`03OT1oogoo01Aoo`03001oogoo009oo`03001oogoo
00Yoo`03001oogoo00Ioo`<003=oo`9n@4=oo`03OT1oogoo02Moo`00LWoo00=n@7ooOol057oo00<0
07ooOol00Woo00<007ooOol02goo00<007ooOol01Goo00<007ooOol0=Goo00=n@7ooOol0?goo00=n
@7ooOol0:7oo001aOol00gi0Oomoo`0EOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04
Ool00`00Oomoo`0fOol00gi0Oomoo`0mOol00gi0Oomoo`0YOol0075oo`03OT1oogoo01Eoo`03001o
ogoo009oo`03001oogoo00Qoo`05001oogooOol00006Ool00`00Oomoo`0gOol00gi0Oomoo`0lOol0
0gi0Oomoo`0YOol0071oo`03OT1oogoo01Moo`@000aoo`<000Moo`03001oogoo03Qoo`03OT1oogoo
03Yoo`03OT1oogoo02Yoo`00L7oo00=n@7ooOol0<Goo00<007ooOol0>Goo0Wi0>Goo00=n@7ooOol0
:goo001_Ool00gi0Oomoo`0bOol00`00Oomoo`0kOol00gi0Oomoo`0eOol00gi0Oomoo`0/Ool006mo
o`03OT1oogoo039oo`03001oogoo03aoo`03OT1oogoo03=oo`03OT1oogoo02eoo`00Kgoo00=n@7oo
Ool0<Woo00<007ooOol0?Goo0Wi0<Woo00=n@7ooOol0;Woo001^Ool00gi0Oomoo`0cOol00`00Oomo
o`0oOol2OT0_Ool00gi0Oomoo`0_Ool006ioo`03OT1oogoo03=oo`80049oo`9n@2aoo`03OT1oogoo
031oo`00KGoo00=n@7ooOol0=7oo00<007ooOol0@goo00=n@7ooOol0:7oo00=n@7ooOol0<Goo001]
Ool00gi0Oomoo`0dOol00`00Oomoo`14Ool2OT0VOol2OT0dOol006aoo`03OT1oogoo03Eoo`03001o
ogoo04Ioo`9n@2=oo`03OT1oogoo03Aoo`00K7oo00=n@7ooOol0=Goo00<007ooOol0B7oo0Wi07goo
0Wi0=goo001/Ool00gi0Oomoo`0eOol00`00Oomoo`1:Ool2OT0LOol00gi0Oomoo`0gOol006]oo`03
OT1oogoo03Ioo`03001oogoo04aoo`9n@1Qoo`9n@3Yoo`00Jgoo00=n@7ooOol0=Woo00<007ooOol0
CWoo17i04Woo0Wi0?7oo001ZOol00gi0Oomoo`0gOol00`00Oomoo`1BOol5OT08Ool5OT0nOol006Yo
o`03OT1oogoo03Moo`8005Qoo`Qn@4=oo`00JWoo00=n@7ooOol0=goo00<007ooOol0XWoo001YOol0
0gi0Oomoo`0hOol00`00Oomoo`2ROol006Uoo`03OT1oogoo03Qoo`03001oogoo0:9oo`00J7oo00=n
@7ooOol0>Goo00<007ooOol0XWoo001XOol00gi0Oomoo`0iOol00`00Oomoo`2ROol006Moo`03OT1o
ogoo03Yoo`03001oogoo0:9oo`00Igoo00=n@7ooOol0>Woo00<007ooOol0XWoo001WOol00gi0Oomo
o`0jOol00`00Oomoo`2ROol006Ioo`03OT1oogoo03]oo`03001oogoo0:9oo`00IWoo00=n@7ooOol0
>goo0P00Xgoo001UOol00gi0Oomoo`0lOol00`00Oomoo`2ROol006Eoo`03OT1oogoo03aoo`03001o
ogoo0:9oo`00IGoo00=n@7ooOol0?7oo00<007ooOol0XWoo001TOol00gi0Oomoo`0mOol00`00Oomo
o`2ROol006Aoo`03OT1oogoo03eoo`03001oogoo0:9oo`00I7oo00=n@7ooOol0?Goo00<007ooOol0
XWoo001TOol00gi0Oomoo`0SOol40005Ool20007Ool30005Ool00`00Oomoo`2ROol006=oo`03OT1o
ogoo02=oo`03001oogoo009oo`03001oogoo009oo`8000Qoo`03001oogoo00Aoo`03001oogoo0:9o
o`00Hgoo00=n@7ooOol08goo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<007oo
Ool0XWoo001SOol00gi0Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`08Ool60005Ool3002ROol0
069oo`03OT1oogoo02Aoo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomo
o`2ROol0069oo`03OT1oogoo02Aoo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool0
0`00Oomoo`2ROol0069oo`03OT1oogoo02Aoo`03001oogoo009oo`03001oogoo00Yoo`03001oo`00
00Ioo`03001oogoo0:9oo`00HWoo00=n@7ooOol09Goo10003Woo0P001Woo00<007ooOol0XWoo001Q
Ool00gi0Oomoo`10Ool00`00Oomoo`2ROol0065oo`03OT1oogoo041oo`03001oogoo0:9oo`00HGoo
00=n@7ooOol0@7oo00<007ooOol0XWoo001POol00gi0Oomoo`11Ool00`00Oomoo`2ROol0061oo`03
OT1oogoo045oo`03001oogoo0:9oo`00H7oo00=n@7ooOol0@Goo0P00Xgoo001POol00gi0Oomoo`11
Ool00`00Oomoo`2ROol005moo`03OT1oogoo049oo`03001oogoo0:9oo`00Ggoo00=n@7ooOol0@Woo
00<007ooOol0XWoo001OOol00gi0Oomoo`12Ool00`00Oomoo`2ROol005ioo`03OT1oogoo04=oo`03
001oogoo0:9oo`00GWoo00=n@7ooOol0@goo00<007ooOol0XWoo001NOol00gi0Oomoo`13Ool00`00
Oomoo`2ROol005eoo`03OT1oogoo04Aoo`03001oogoo0:9oo`00GGoo00=n@7ooOol0A7oo00<007oo
Ool0XWoo001MOol00gi0Oomoo`14Ool2002SOol005eoo`03OT1oogoo04Aoo`03001oogoo0:9oo`00
G7oo00=n@7ooOol0AGoo00<007ooOol0XWoo001LOol00gi0Oomoo`15Ool00`00Oomoo`2ROol005ao
o`03OT1oogoo04Eoo`03001oogoo0:9oo`00Fgoo00=n@7ooOol0AWoo00<007ooOol0XWoo001KOol0
0gi0Oomoo`16Ool00`00Oomoo`2ROol005]oo`03OT1oogoo04Ioo`03001oogoo0:9oo`00Fgoo00=n
@7ooOol0AWoo00<007ooOol0XWoo001JOol00gi0Oomoo`17Ool00`00Oomoo`2ROol005Yoo`03OT1o
ogoo04Moo`800:=oo`00FWoo00=n@7ooOol0Agoo00<007ooOol0XWoo001IOol00gi0Oomoo`18Ool0
0`00Oomoo`2ROol005Uoo`03OT1oogoo04Qoo`03001oogoo0:9oo`00FGoo00=n@7ooOol0B7oo00<0
07ooOol0XWoo001IOol00gi0Oomoo`18Ool00`00Oomoo`2ROol005Qoo`03OT1oogoo04Uoo`03001o
ogoo0:9oo`00F7oo00=n@7ooOol0BGoo00<007ooOol0XWoo001GOol00gi0Oomoo`1:Ool00`00Oomo
o`2ROol005Moo`03OT1oogoo04Yoo`03001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .9 0 r
.5 Mabswid
.24909 .61803 m
.26171 .56607 L
.30316 .43663 L
.32392 .38628 L
.34309 .34767 L
.36292 .31515 L
.3815 .29107 L
.40022 .27259 L
.41016 .265 L
.42085 .25844 L
.43095 .25369 L
.43667 .25161 L
.44198 .25005 L
.44708 .24888 L
.45171 .2481 L
.45427 .24777 L
.45562 .24763 L
.45705 .2475 L
.45829 .24741 L
.45966 .24733 L
.46091 .24728 L
.46207 .24724 L
.46334 .24722 L
.46397 .24721 L
.46467 .24721 L
.46592 .24723 L
.46708 .24726 L
.46775 .24728 L
.46845 .24731 L
.4697 .24737 L
.47253 .24758 L
.47498 .24782 L
.47725 .24811 L
.48243 .24894 L
.4914 .25099 L
.50098 .25399 L
.52233 .26334 L
.54248 .27507 L
.58095 .30323 L
.62187 .33778 L
.66127 .37123 L
.69916 .3996 L
.72024 .41237 L
.7395 .42147 L
.74902 .4249 L
.75406 .4264 L
.75941 .42774 L
.76456 .42878 L
.76922 .4295 L
.77148 .42977 L
Mistroke
.77391 .43001 L
.77503 .43009 L
.77621 .43017 L
.77731 .43023 L
.77832 .43027 L
.77954 .43031 L
.78019 .43032 L
.78088 .43033 L
.78203 .43033 L
.78329 .43032 L
.78442 .4303 L
.78563 .43025 L
.78678 .4302 L
.78782 .43013 L
.79019 .42994 L
.79278 .42966 L
.798 .42885 L
.8026 .42786 L
.80751 .42652 L
.81634 .42334 L
.82661 .41833 L
.83773 .41124 L
.85789 .39367 L
.87781 .36989 L
.89886 .33717 L
.9368 .2566 L
.97619 .14008 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03
001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2R
Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`2ROol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo0:9oo`00
PGoo1P000Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00XWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2ROol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`00RGoo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo0:9oo`00RWoo100037oo0`001goo00<007ooOol0
XWoo002TOol00`00Oomoo`2DOol00gn0Oomoo`0;Ool00:Aoo`03001oogoo09Aoo`03Oh1oogoo00]o
o`00Y7oo00<007ooOol0Tgoo00=oP7ooOol037oo002TOol00`00Oomoo`2COol00gn0Oomoo`0<Ool0
0:Aoo`03001oogoo09=oo`03Oh1oogoo00aoo`00Y7oo0P00Tgoo00=oP7ooOol03Goo002TOol00`00
Oomoo`2BOol00gn0Oomoo`0=Ool00:Aoo`03001oogoo099oo`03Oh1oogoo00eoo`00Y7oo00<007oo
Ool0TGoo00=oP7ooOol03Woo002TOol00`00Oomoo`2AOol00gn0Oomoo`0>Ool00:Aoo`03001oogoo
095oo`03Oh1oogoo00ioo`00Y7oo00<007ooOol0T7oo00=oP7ooOol03goo002TOol00`00Oomoo`2@
Ool00gn0Oomoo`0?Ool00:Aoo`03001oogoo091oo`03Oh1oogoo00moo`00Y7oo00<007ooOol0Sgoo
00=oP7ooOol047oo002TOol2002@Ool00gn0Oomoo`0@Ool00:Aoo`03001oogoo08moo`03Oh1oogoo
011oo`00Y7oo00<007ooOol0SWoo00=oP7ooOol04Goo002TOol00`00Oomoo`2>Ool00gn0Oomoo`0A
Ool000eoo`D004Qoo`D004Eoo`03001oogoo04Ioo`D004=oo`03Oh1oogoo00D000aoo`003Goo00D0
07ooOomoo`0004Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo04=oo`04Oh1oogoo0003
Ool00`00Oomoo`0:Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001o
ogoo049oo`03Oh1oogoo009oo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo
00<007ooOol0AGoo00<007ooOol0B7oo00<007ooOol0@Woo00=oP7ooOol00goo00<007ooOol037oo
000@Ool00`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`12Ool00gn0Oomo
o`04Ool00`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03
001oogoo045oo`03Oh1oogoo00Ioo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Mo
o`8004Moo`<004=oo`03Oh1oogoo009oo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo045oo`03Oh1oogoo00=oo`<000eoo`00Y7oo00<007ooOol0
Rgoo00=oP7ooOol057oo002TOol00`00Oomoo`2;Ool00gn0Oomoo`0DOol00:Aoo`03001oogoo08]o
o`03Oh1oogoo01Aoo`00Y7oo00<007ooOol0RWoo00=oP7ooOol05Goo002TOol00`00Oomoo`2:Ool0
0gn0Oomoo`0EOol00:Aoo`03001oogoo08Yoo`03Oh1oogoo01Eoo`00Y7oo00<007ooOol0RGoo00=o
P7ooOol05Woo0004OonB0005Oh2E00000gn00000000A0005Ool000aoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00Uoo`IoP0Aoo`EoP0Aoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`05001oogooOomoP00:Ool00`00Oomoo`0;Ool0
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Ioo`=oP0=oo`03
001oogoo00Uoo`=oP003Ool007oo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`04001oogooOh0;Ool00`00Oomoo`0;Ool008aoo`9oP1Eoo`=oP8Uoo`03Oh1oogoo01Moo`00RWoo
0Wn067oo00@007ooOh1oP8Moo`03Oh1oogoo01Moo`00R7oo0Wn06Woo00@007ooOomoo`9oP8Aoo`03
Oh1oogoo01Qoo`00Qgoo00=oP7ooOol06Woo00<007ooOol00goo0Wn0PWoo00=oP7ooOol067oo0025
Ool2Oh0MOol00`00Oomoo`05Ool2Oh1oOol00gn0Oomoo`0IOol008Aoo`03Oh1oogoo01eoo`03001o
ogoo00Moo`9oP7eoo`03Oh1oogoo01Uoo`00Pgoo00=oP7ooOol07Woo00<007ooOol02Goo0Wn0NWoo
00=oP7ooOol06Woo0022Ool00gn0Oomoo`0OOol2000<Ool00gn0Oomoo`1gOol00gn0Oomoo`0JOol0
085oo`03Oh1oogoo021oo`03001oogoo00aoo`9oP7Ioo`03Oh1oogoo01]oo`00P7oo00=oP7ooOol0
8Goo00<007ooOol03Woo00=oP7ooOol0Lgoo00=oP7ooOol06goo001oOol00gn0Oomoo`0ROol00`00
Oomoo`0?Ool00gn0Oomoo`1aOol00gn0Oomoo`0LOol007ioo`03Oh1oogoo02=oo`03001oogoo011o
o`9oP75oo`03Oh1oogoo01aoo`00OGoo00=oP7ooOol097oo00<007ooOol04Woo00=oP7ooOol0KGoo
00=oP7ooOol07Goo001lOol00gn0Oomoo`0UOol00`00Oomoo`0COol00gn0Oomoo`1/Ool00gn0Oomo
o`0MOol007aoo`03Oh1oogoo02Eoo`03001oogoo01Aoo`9oP6aoo`03Oh1oogoo01eoo`00Ngoo00=o
P7ooOol09Woo00<007ooOol05Woo00=oP7ooOol0J7oo00=oP7ooOol07Woo001jOol00gn0Oomoo`0W
Ool00`00Oomoo`0GOol00gn0Oomoo`1WOol00gn0Oomoo`0NOol007Uoo`03Oh1oogoo02Qoo`8001Uo
o`03Oh1oogoo06Eoo`03Oh1oogoo01moo`00NGoo00=oP7ooOol0:7oo00<007ooOol06Goo0Wn0IGoo
00=oP7ooOol07goo001hOol00gn0Oomoo`0YOol00`00Oomoo`0KOol00gn0Oomoo`1QOol00gn0Oomo
o`0POol007Moo`03Oh1oogoo02Yoo`03001oogoo01aoo`03Oh1oogoo061oo`03Oh1oogoo021oo`00
Mgoo00=oP7ooOol0:Woo00<007ooOol07Goo00=oP7ooOol0GWoo00=oP7ooOol08Goo001fOol00gn0
Oomoo`0[Ool00`00Oomoo`0NOol00gn0Oomoo`1MOol00gn0Oomoo`0QOol007Ioo`03Oh1oogoo02]o
o`03001oogoo01moo`9oP5aoo`03Oh1oogoo029oo`00MGoo00=oP7ooOol0;7oo00<007ooOol08Goo
00=oP7ooOol0FGoo00=oP7ooOol08Woo001dOol00gn0Oomoo`0]Ool00`00Oomoo`0ROol00gn0Oomo
o`1GOol00gn0Oomoo`0SOol007Aoo`03Oh1oogoo02eoo`03001oogoo02=oo`03Oh1oogoo05Ioo`03
Oh1oogoo02=oo`00Lgoo00=oP7ooOol0;Woo0P009Goo00=oP7ooOol0E7oo00=oP7ooOol097oo001c
Ool00gn0Oomoo`0^Ool00`00Oomoo`0UOol00gn0Oomoo`1COol00gn0Oomoo`0TOol0079oo`03Oh1o
ogoo02moo`03001oogoo02Ioo`9oP59oo`03Oh1oogoo02Eoo`00LWoo00=oP7ooOol0;goo00<007oo
Ool0:7oo00=oP7ooOol0CWoo00=oP7ooOol09Woo001aOol00gn0Oomoo`0`Ool00`00Oomoo`0YOol0
0gn0Oomoo`1<Ool00gn0Oomoo`0WOol0075oo`03Oh1oogoo031oo`03001oogoo02Yoo`03Oh1oogoo
04]oo`03Oh1oogoo02Moo`00L7oo00=oP7ooOol0<Goo00<007ooOol0:goo00=oP7ooOol0BGoo00=o
P7ooOol0:7oo001`Ool00gn0Oomoo`0GOol40005Ool20004Ool50006Ool00`00Oomoo`0/Ool2Oh18
Ool00gn0Oomoo`0YOol006moo`03Oh1oogoo01Moo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`0^Ool00gn0Oomoo`15Ool00gn0Oomoo`0YOol006moo`03
Oh1oogoo01Moo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo02moo`03
Oh1oogoo04=oo`03Oh1oogoo02Yoo`00KWoo00=oP7ooOol067oo00<007ooOol00Woo00<007ooOol0
2Woo00<007ooOol01Woo0`00<7oo00=oP7ooOol0@Goo00=oP7ooOol0:goo001^Ool00gn0Oomoo`0H
Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`0aOol00gn0Oomoo`0o
Ool00gn0Oomoo`0/Ool006eoo`03Oh1oogoo01Uoo`03001oogoo009oo`03001oogoo00aoo`03001o
ogoo00Aoo`03001oogoo039oo`9oP3moo`03Oh1oogoo02aoo`00KGoo00=oP7ooOol06Goo00<007oo
Ool00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo03Aoo`03Oh1oogoo03]oo`03
Oh1oogoo02eoo`00K7oo00=oP7ooOol06goo100037oo0`001goo00<007ooOol0=Goo00=oP7ooOol0
>Goo00=oP7ooOol0;Woo001/Ool00gn0Oomoo`0eOol00`00Oomoo`0fOol2Oh0hOol00gn0Oomoo`0_
Ool006aoo`03Oh1oogoo03Eoo`03001oogoo03Qoo`03Oh1oogoo03Eoo`03Oh1oogoo02moo`00Jgoo
00=oP7ooOol0=Woo00<007ooOol0>Goo00=oP7ooOol0<goo00=oP7ooOol0<7oo001[Ool00gn0Oomo
o`0fOol00`00Oomoo`0jOol2Oh0bOol00gn0Oomoo`0aOol006Yoo`03Oh1oogoo03Moo`03001oogoo
03aoo`03Oh1oogoo02ioo`03Oh1oogoo039oo`00JWoo00=oP7ooOol0=goo0P00?Woo0Wn0;7oo0Wn0
=Goo001YOol00gn0Oomoo`0hOol00`00Oomoo`0oOol2Oh0YOol00gn0Oomoo`0eOol006Uoo`03Oh1o
ogoo03Qoo`03001oogoo045oo`9oP2Ioo`03Oh1oogoo03Ioo`00J7oo00=oP7ooOol0>Goo00<007oo
Ool0@goo00=oP7ooOol08Woo00=oP7ooOol0=goo001XOol00gn0Oomoo`0iOol00`00Oomoo`14Ool2
Oh0POol2Oh0jOol006Qoo`03Oh1oogoo03Uoo`03001oogoo04Ioo`9oP1aoo`9oP3aoo`00Igoo00=o
P7ooOol0>Woo00<007ooOol0B7oo0gn05Woo0gn0?Woo001WOol00gn0Oomoo`0jOol00`00Oomoo`1;
Ool4Oh0AOol00gn0Oomoo`0oOol006Ioo`03Oh1oogoo03]oo`03001oogoo04moo`AoP0Uoo`AoP49o
o`00IWoo00=oP7ooOol0>goo0P00E7oo2Gn0AWoo001UOol00gn0Oomoo`0lOol00`00Oomoo`2ROol0
06Eoo`03Oh1oogoo03aoo`03001oogoo0:9oo`00IGoo00=oP7ooOol0?7oo00<007ooOol0XWoo001T
Ool00gn0Oomoo`0mOol00`00Oomoo`2ROol006Aoo`03Oh1oogoo03eoo`03001oogoo0:9oo`00I7oo
00=oP7ooOol0?Goo00<007ooOol0XWoo001SOol00gn0Oomoo`0nOol00`00Oomoo`2ROol006=oo`03
Oh1oogoo03ioo`03001oogoo0:9oo`00Hgoo00=oP7ooOol0?Woo00<007ooOol0XWoo001ROol00gn0
Oomoo`0oOol2002SOol0069oo`03Oh1oogoo03moo`03001oogoo0:9oo`00HWoo00=oP7ooOol0?goo
00<007ooOol0XWoo001ROol00gn0Oomoo`0oOol00`00Oomoo`2ROol0065oo`03Oh1oogoo041oo`03
001oogoo0:9oo`00HGoo00=oP7ooOol0@7oo00<007ooOol0XWoo001QOol00gn0Oomoo`10Ool00`00
Oomoo`2ROol0061oo`03Oh1oogoo02Moo`@000Eoo`8000Moo`<000Eoo`03001oogoo0:9oo`00H7oo
00=oP7ooOol09Woo00<007ooOol00Woo00<007ooOol00Woo0P0027oo00<007ooOol017oo00<007oo
Ool0XWoo001POol00gn0Oomoo`0VOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool0
0`00Oomoo`2ROol005moo`03Oh1oogoo02Moo`03001oogoo009oo`03001oogoo00Qoo`H000Eoo`<0
0:9oo`00Ggoo00=oP7ooOol09goo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03
001oogoo0:9oo`00Ggoo00=oP7ooOol09goo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol0
00Ioo`03001oogoo0:9oo`00GWoo00=oP7ooOol0:7oo00<007ooOol00Woo00<007ooOol02Woo00<0
07oo00001Woo00<007ooOol0XWoo001NOol00gn0Oomoo`0YOol4000>Ool20006Ool00`00Oomoo`2R
Ool005ioo`03Oh1oogoo04=oo`03001oogoo0:9oo`00GGoo00=oP7ooOol0A7oo00<007ooOol0XWoo
001MOol00gn0Oomoo`14Ool00`00Oomoo`2ROol005eoo`03Oh1oogoo04Aoo`03001oogoo0:9oo`00
G7oo00=oP7ooOol0AGoo00<007ooOol0XWoo001LOol00gn0Oomoo`15Ool2002SOol005aoo`03Oh1o
ogoo04Eoo`03001oogoo0:9oo`00Fgoo00=oP7ooOol0AWoo00<007ooOol0XWoo001KOol00gn0Oomo
o`16Ool00`00Oomoo`2ROol005]oo`03Oh1oogoo04Ioo`03001oogoo0:9oo`00Fgoo00=oP7ooOol0
AWoo00<007ooOol0XWoo001JOol00gn0Oomoo`17Ool00`00Oomoo`2ROol005Yoo`03Oh1oogoo04Mo
o`03001oogoo0:9oo`00FWoo00=oP7ooOol0Agoo00<007ooOol0XWoo001IOol00gn0Oomoo`18Ool0
0`00Oomoo`2ROol005Uoo`03Oh1oogoo04Qoo`800:=oo`00FGoo00=oP7ooOol0B7oo00<007ooOol0
XWoo001HOol00gn0Oomoo`19Ool00`00Oomoo`2ROol005Qoo`03Oh1oogoo04Uoo`03001oogoo0:9o
o`00F7oo00=oP7ooOol0BGoo00<007ooOol0XWoo001GOol00gn0Oomoo`1:Ool00`00Oomoo`2ROol0
05Moo`03Oh1oogoo04Yoo`03001oogoo0:9oo`00Egoo00=oP7ooOol0BWoo00<007ooOol0XWoo001G
Ool00gn0Oomoo`1:Ool00`00Oomoo`2ROol005Ioo`03Oh1oogoo04]oo`03001oogoo0:9oo`00EWoo
00=oP7ooOol0Bgoo0P00Xgoo001FOol00gn0Oomoo`1;Ool00`00Oomoo`2ROol005Ioo`03Oh1oogoo
04]oo`03001oogoo0:9oo`00EGoo00=oP7ooOol0C7oo00<007ooOol0XWoo001EOol00gn0Oomoo`1<
Ool00`00Oomoo`2ROol005Eoo`03Oh1oogoo04aoo`03001oogoo0:9oo`00EGoo00=oP7ooOol0C7oo
00<007ooOol0XWoo001DOol00gn0Oomoo`1=Ool00`00Oomoo`2ROol005Aoo`03Oh1oogoo04eoo`03
001oogoo0:9oo`00E7oo00=oP7ooOol0CGoo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.8 1 0 r
.5 Mabswid
.23724 .61803 m
.26171 .52474 L
.28158 .46327 L
.30316 .40664 L
.34309 .32728 L
.36292 .29903 L
.38395 .27641 L
.39336 .26855 L
.40349 .26158 L
.41298 .25638 L
.42179 .25264 L
.42709 .25089 L
.43189 .2496 L
.43723 .2485 L
.44016 .24805 L
.44292 .24771 L
.44537 .24749 L
.4466 .2474 L
.44795 .24732 L
.4491 .24727 L
.45034 .24724 L
.45151 .24722 L
.45257 .24721 L
.45322 .24722 L
.45391 .24723 L
.45514 .24725 L
.45582 .24728 L
.45647 .2473 L
.45793 .24738 L
.46038 .24756 L
.46301 .24782 L
.46797 .24849 L
.47258 .24934 L
.48305 .25201 L
.49325 .25554 L
.50415 .26023 L
.54565 .28534 L
.58563 .31692 L
.6241 .34999 L
.66502 .38362 L
.68537 .39834 L
.70442 .41021 L
.72268 .41941 L
.73287 .42346 L
.74231 .42644 L
.74762 .42777 L
.75244 .42874 L
.75779 .42956 L
.76072 .42989 L
.76204 .43001 L
Mistroke
.76348 .43012 L
.76466 .43019 L
.76593 .43025 L
.76663 .43028 L
.76727 .4303 L
.76852 .43033 L
.76966 .43033 L
.77089 .43033 L
.77206 .43031 L
.77314 .43027 L
.77439 .43022 L
.77555 .43015 L
.77821 .42995 L
.7808 .42967 L
.78358 .42928 L
.78856 .42835 L
.79318 .42722 L
.80366 .42366 L
.81388 .41879 L
.82477 .41199 L
.84616 .3935 L
.86632 .36931 L
.88638 .33819 L
.90484 .30282 L
.9443 .20365 L
.97619 .09765 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=o
o`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<0
07ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo
002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo0P00Xgoo002TOol00`00Oomoo`2R
Ool00:Aoo`03001oogoo09Aoo`03In1oogoo00]oo`00Y7oo00<007ooOol0U7oo00=Wh7ooOol02goo
002TOol00`00Oomoo`2COol00fOPOomoo`0<Ool00:Aoo`03001oogoo09=oo`03In1oogoo00aoo`00
Y7oo00<007ooOol0Tgoo00=Wh7ooOol037oo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2C
Ool00fOPOomoo`0<Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol0
0006Ool00`00Oomoo`2BOol00fOPOomoo`0=Ool008Uoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Moo`03001oogoo099oo`03In1oogoo00eoo`00PGoo1P000Woo00<007ooOol00Woo00<0
07ooOol02Woo00<007ooOol01Woo0`00TWoo00=Wh7ooOol03Goo0029Ool00`00Oomoo`02Ool00`00
Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2AOol00fOPOomoo`0>Ool008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo095oo`03In1oogoo00ioo`00RGoo00<007oo
Ool00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo095oo`03In1oogoo00ioo`00
RWoo100037oo0`001goo00<007ooOol0T7oo00=Wh7ooOol03goo002TOol00`00Oomoo`2@Ool00fOP
Oomoo`0?Ool00:Aoo`03001oogoo091oo`03In1oogoo00moo`00Y7oo00<007ooOol0T7oo00=Wh7oo
Ool03goo002TOol00`00Oomoo`2?Ool00fOPOomoo`0@Ool00:Aoo`03001oogoo08moo`03In1oogoo
011oo`00Y7oo0P00T7oo00=Wh7ooOol047oo002TOol00`00Oomoo`2>Ool00fOPOomoo`0AOol00:Ao
o`03001oogoo08ioo`03In1oogoo015oo`00Y7oo00<007ooOol0SWoo00=Wh7ooOol04Goo002TOol0
0`00Oomoo`2>Ool00fOPOomoo`0AOol00:Aoo`03001oogoo08eoo`03In1oogoo019oo`00Y7oo00<0
07ooOol0SGoo00=Wh7ooOol04Woo002TOol00`00Oomoo`2=Ool00fOPOomoo`0BOol00:Aoo`03001o
ogoo08aoo`03In1oogoo01=oo`00Y7oo00<007ooOol0S7oo00=Wh7ooOol04goo002TOol2002=Ool0
0fOPOomoo`0COol00:Aoo`03001oogoo08]oo`03In1oogoo01Aoo`00Y7oo00<007ooOol0Rgoo00=W
h7ooOol057oo002TOol00`00Oomoo`2;Ool00fOPOomoo`0DOol000eoo`D004Qoo`D004Eoo`03001o
ogoo04Ioo`D0041oo`03In1oogoo00=oo`D000aoo`003Goo00D007ooOomoo`0004Yoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo03moo`03In1oogoo00Aoo`05001oogooOol0000<Ool000io
o`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo03moo`03In1oogoo00Eo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0?goo00=Wh7ooOol01Woo00<007ooOol037oo000@Ool00`00Oomoo`19Ool0
0`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0nOol00fOPOomoo`08Ool00`00Oomoo`0;Ool0
015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo03ioo`03In1oogoo
00Uoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Moo`<003moo`03In1o
ogoo00Ioo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03001oogoo04Qoo`03
001oogoo03eoo`03In1oogoo00Moo`<000eoo`00Y7oo00<007ooOol0R7oo00=Wh7ooOol05goo002T
Ool00`00Oomoo`27Ool00fOPOomoo`0HOol00:Aoo`03001oogoo08Moo`03In1oogoo01Qoo`00Y7oo
00<007ooOol0Qgoo00=Wh7ooOol067oo002TOol00`00Oomoo`26Ool00fOPOomoo`0IOol00:Aoo`03
001oogoo08Ioo`03In1oogoo01Uoo`00Y7oo00<007ooOol0QGoo00=Wh7ooOol06Woo0004Oon>0005
In2E00000fOP0000000E0005Ool000aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00Ioo`AWh09oo`03001oogoo00IWh0Moo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03In1oogoo00aoo`03001oogoo00]oo`0037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol00Woo16OP1Woo00<007ooOol01Woo0fOP
17oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol02goo00=Wh000Ool0
3Goo00<007ooOol02goo0028Ool2In0FOol2In02Ool00`00Oomoo`24Ool00fOPOomoo`0KOol008Io
o`9Wh1Yoo`9Wh003001oogoo08=oo`03In1oogoo01aoo`00QGoo00=Wh7ooOol077oo0VOPQ7oo00=W
h7ooOol077oo0023Ool2In0OOol01000OomWh6OPPWoo00=Wh7ooOol077oo0022Ool00fOPOomoo`0O
Ool01000Oomoogoo0VOPOgoo00=Wh7ooOol07Goo0021Ool00fOPOomoo`0POol00`00Oomoo`03Ool0
0fOPOomoo`1lOol00fOPOomoo`0MOol0081oo`03In1oogoo025oo`03001oogoo00Aoo`9Wh7]oo`03
In1oogoo01ioo`00Ogoo00=Wh7ooOol08Woo0P001goo00=Wh7ooOol0N7oo00=Wh7ooOol07Woo001n
Ool00fOPOomoo`0SOol00`00Oomoo`07Ool2In1hOol00fOPOomoo`0NOol007eoo`03In1oogoo02Ao
o`03001oogoo00Uoo`9Wh7Eoo`03In1oogoo01moo`00O7oo00=Wh7ooOol09Goo00<007ooOol02goo
00=Wh7ooOol0LWoo00=Wh7ooOol07goo001kOol00fOPOomoo`0VOol00`00Oomoo`0<Ool00fOPOomo
o`1aOol00fOPOomoo`0OOol007Yoo`03In1oogoo02Moo`03001oogoo00eoo`9Wh71oo`03In1oogoo
021oo`00NGoo00=Wh7ooOol0:7oo00<007ooOol03goo00=Wh7ooOol0KGoo00=Wh7ooOol087oo001h
Ool00fOPOomoo`0YOol00`00Oomoo`0@Ool00fOPOomoo`1[Ool00fOPOomoo`0QOol007Moo`03In1o
ogoo02Yoo`03001oogoo015oo`9Wh6]oo`03In1oogoo025oo`00Mgoo00=Wh7ooOol0:Woo00<007oo
Ool04goo00=Wh7ooOol0Igoo00=Wh7ooOol08Woo001fOol00fOPOomoo`0[Ool2000EOol00fOPOomo
o`1VOol00fOPOomoo`0ROol007Eoo`03In1oogoo02aoo`03001oogoo01Eoo`9Wh6Eoo`03In1oogoo
02=oo`00MGoo00=Wh7ooOol0;7oo00<007ooOol05goo00=Wh7ooOol0HWoo00=Wh7ooOol08goo001d
Ool00fOPOomoo`0]Ool00`00Oomoo`0HOol00fOPOomoo`1POol00fOPOomoo`0TOol007=oo`03In1o
ogoo02ioo`03001oogoo01Uoo`03In1oogoo05moo`03In1oogoo02Aoo`00Lgoo00=Wh7ooOol0;Woo
00<007ooOol06Woo00=Wh7ooOol0GGoo00=Wh7ooOol09Goo001bOol00fOPOomoo`0_Ool00`00Oomo
o`0KOol2In1MOol00fOPOomoo`0UOol0075oo`03In1oogoo031oo`03001oogoo01eoo`03In1oogoo
05Uoo`03In1oogoo02Ioo`00LGoo00=Wh7ooOol0<7oo00<007ooOol07Woo00=Wh7ooOol0F7oo00=W
h7ooOol09Woo001`Ool00fOPOomoo`0aOol00`00Oomoo`0OOol00fOPOomoo`1FOol00fOPOomoo`0W
Ool0071oo`03In1oogoo035oo`80025oo`03In1oogoo05Aoo`03In1oogoo02Qoo`00Kgoo00=Wh7oo
Ool0<Woo00<007ooOol08Goo0VOPE7oo00=Wh7ooOol0:7oo001_Ool00fOPOomoo`0bOol00`00Oomo
o`0SOol00fOPOomoo`1@Ool00fOPOomoo`0YOol006ioo`03In1oogoo03=oo`03001oogoo02Aoo`03
In1oogoo04ioo`03In1oogoo02Yoo`00KWoo00=Wh7ooOol0<goo00<007ooOol09Goo00=Wh7ooOol0
C7oo00=Wh7ooOol0:goo001]Ool00fOPOomoo`0dOol00`00Oomoo`0VOol00fOPOomoo`1;Ool00fOP
Oomoo`0[Ool006eoo`03In1oogoo03Aoo`03001oogoo02Moo`9Wh4Yoo`03In1oogoo02aoo`00K7oo
00=Wh7ooOol06goo10001Goo0P0017oo1@001Woo00<007ooOol0:Goo00=Wh7ooOol0AWoo00=Wh7oo
Ool0;Goo001/Ool00fOPOomoo`0JOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomo
ogoo00001Woo00<007ooOol0:Woo00=Wh7ooOol0AGoo00=Wh7ooOol0;Goo001[Ool00fOPOomoo`0K
Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`0[Ool00fOPOomoo`13
Ool00fOPOomoo`0^Ool006]oo`03In1oogoo01]oo`03001oogoo009oo`03001oogoo00Yoo`03001o
ogoo00Ioo`<002aoo`03In1oogoo045oo`03In1oogoo02moo`00JWoo00=Wh7ooOol077oo00<007oo
Ool00Woo00<007ooOol02goo00<007ooOol01Goo00<007ooOol0;Goo0VOP@7oo00=Wh7ooOol0<7oo
001ZOol00fOPOomoo`0LOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomo
o`0_Ool00fOPOomoo`0mOol00fOPOomoo`0`Ool006Uoo`03In1oogoo01eoo`03001oogoo009oo`03
001oogoo00Qoo`05001oogooOol00006Ool00`00Oomoo`0`Ool00fOPOomoo`0kOol00fOPOomoo`0a
Ool006Uoo`03In1oogoo01ioo`@000aoo`<000Moo`03001oogoo035oo`03In1oogoo03Uoo`03In1o
ogoo039oo`00J7oo00=Wh7ooOol0>Goo00<007ooOol0<Woo0VOP>7oo00=Wh7ooOol0<goo001XOol0
0fOPOomoo`0iOol00`00Oomoo`0dOol00fOPOomoo`0eOol00fOPOomoo`0cOol006Moo`03In1oogoo
03Yoo`03001oogoo03Eoo`03In1oogoo03=oo`03In1oogoo03Aoo`00Igoo00=Wh7ooOol0>Woo00<0
07ooOol0=Woo0VOP<Woo00=Wh7ooOol0=Goo001VOol00fOPOomoo`0kOol00`00Oomoo`0hOol00fOP
Oomoo`0^Ool00fOPOomoo`0fOol006Ioo`03In1oogoo03]oo`8003Yoo`9Wh2aoo`9Wh3Uoo`00IGoo
00=Wh7ooOol0?7oo00<007ooOol0>goo0VOP:Goo00=Wh7ooOol0>Goo001UOol00fOPOomoo`0lOol0
0`00Oomoo`0mOol2In0VOol00fOPOomoo`0jOol006Aoo`03In1oogoo03eoo`03001oogoo03moo`9W
h2=oo`03In1oogoo03]oo`00I7oo00=Wh7ooOol0?Goo00<007ooOol0@Goo0VOP7goo0VOP?Woo001S
Ool00fOPOomoo`0nOol00`00Oomoo`13Ool2In0LOol00fOPOomoo`0nOol006=oo`03In1oogoo03io
o`03001oogoo04Eoo`9Wh1Qoo`9Wh45oo`00Hgoo00=Wh7ooOol0?Woo00<007ooOol0Agoo16OP4Goo
0fOP@goo001ROol00fOPOomoo`0oOol00`00Oomoo`1;Ool5In07Ool5In16Ool0069oo`03In1oogoo
03moo`80055oo`MWh4]oo`00HGoo00=Wh7ooOol0@7oo00<007ooOol0XWoo001QOol00fOPOomoo`10
Ool00`00Oomoo`2ROol0065oo`03In1oogoo041oo`03001oogoo0:9oo`00H7oo00=Wh7ooOol0@Goo
00<007ooOol0XWoo001POol00fOPOomoo`11Ool00`00Oomoo`2ROol0061oo`03In1oogoo045oo`03
001oogoo0:9oo`00Ggoo00=Wh7ooOol0@Woo00<007ooOol0XWoo001OOol00fOPOomoo`12Ool00`00
Oomoo`2ROol005ioo`03In1oogoo04=oo`03001oogoo0:9oo`00GWoo00=Wh7ooOol0@goo0P00Xgoo
001NOol00fOPOomoo`13Ool00`00Oomoo`2ROol005eoo`03In1oogoo04Aoo`03001oogoo0:9oo`00
GGoo00=Wh7ooOol0A7oo00<007ooOol0XWoo001MOol00fOPOomoo`14Ool00`00Oomoo`2ROol005ao
o`03In1oogoo04Eoo`03001oogoo0:9oo`00G7oo00=Wh7ooOol0AGoo00<007ooOol0XWoo001LOol0
0fOPOomoo`0[Ool40005Ool20007Ool30005Ool00`00Oomoo`2ROol005aoo`03In1oogoo02Yoo`03
001oogoo009oo`03001oogoo009oo`8000Qoo`03001oogoo00Aoo`03001oogoo0:9oo`00Fgoo00=W
h7ooOol0:goo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol0XWoo001K
Ool00fOPOomoo`0[Ool00`00Oomoo`02Ool00`00Oomoo`08Ool60005Ool3002ROol005]oo`03In1o
ogoo02]oo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol005Yo
o`03In1oogoo02aoo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2R
Ool005Yoo`03In1oogoo02aoo`03001oogoo009oo`03001oogoo00Yoo`03001oo`0000Ioo`03001o
ogoo0:9oo`00FWoo00=Wh7ooOol0;Goo10003Woo0P001Woo00<007ooOol0XWoo001IOol00fOPOomo
o`18Ool00`00Oomoo`2ROol005Uoo`03In1oogoo04Qoo`03001oogoo0:9oo`00FGoo00=Wh7ooOol0
B7oo00<007ooOol0XWoo001IOol00fOPOomoo`18Ool00`00Oomoo`2ROol005Qoo`03In1oogoo04Uo
o`03001oogoo0:9oo`00F7oo00=Wh7ooOol0BGoo0P00Xgoo001HOol00fOPOomoo`19Ool00`00Oomo
o`2ROol005Moo`03In1oogoo04Yoo`03001oogoo0:9oo`00Egoo00=Wh7ooOol0BWoo00<007ooOol0
XWoo001GOol00fOPOomoo`1:Ool00`00Oomoo`2ROol005Moo`03In1oogoo04Yoo`03001oogoo0:9o
o`00EWoo00=Wh7ooOol0Bgoo00<007ooOol0XWoo001FOol00fOPOomoo`1;Ool00`00Oomoo`2ROol0
05Ioo`03In1oogoo04]oo`03001oogoo0:9oo`00EWoo00=Wh7ooOol0Bgoo00<007ooOol0XWoo001E
Ool00fOPOomoo`1<Ool2002SOol005Eoo`03In1oogoo04aoo`03001oogoo0:9oo`00EGoo00=Wh7oo
Ool0C7oo00<007ooOol0XWoo001DOol00fOPOomoo`1=Ool00`00Oomoo`2ROol005Aoo`03In1oogoo
04eoo`03001oogoo0:9oo`00E7oo00=Wh7ooOol0CGoo00<007ooOol0XWoo001DOol00fOPOomoo`1=
Ool00`00Oomoo`2ROol005=oo`03In1oogoo04ioo`03001oogoo0:9oo`00Dgoo00=Wh7ooOol0CWoo
00<007ooOol0XWoo001COol00fOPOomoo`1>Ool00`00Oomoo`2ROol0059oo`03In1oogoo04moo`80
0:=oo`00DWoo00=Wh7ooOol0Cgoo00<007ooOol0XWoo001BOol00fOPOomoo`1?Ool00`00Oomoo`2R
Ool0059oo`03In1oogoo04moo`03001oogoo0:9oo`00DGoo00=Wh7ooOol0D7oo00<007ooOol0XWoo
001AOol00fOPOomoo`1@Ool00`00Oomoo`2ROol0055oo`03In1oogoo051oo`03001oogoo0:9oo`00
DGoo00=Wh7ooOol0D7oo00<007ooOol0XWoo001@Ool00fOPOomoo`1AOol00`00Oomoo`2ROol0051o
o`03In1oogoo055oo`03001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 1 0 r
.5 Mabswid
.22439 .61803 m
.26171 .48681 L
.28158 .43076 L
.30316 .37965 L
.32216 .34249 L
.34309 .30949 L
.36292 .28534 L
.3739 .27475 L
.38395 .2667 L
.39323 .26059 L
.40336 .25531 L
.40891 .253 L
.41406 .25123 L
.41936 .24975 L
.42424 .2487 L
.42932 .24791 L
.43199 .24761 L
.43335 .24749 L
.43481 .24739 L
.43609 .24732 L
.43726 .24727 L
.43844 .24724 L
.43955 .24722 L
.44085 .24721 L
.44205 .24723 L
.44336 .24726 L
.44403 .24728 L
.44476 .24731 L
.44717 .24745 L
.44938 .24764 L
.45181 .2479 L
.45436 .24823 L
.45866 .24895 L
.46337 .24993 L
.47364 .25279 L
.48298 .25618 L
.50393 .26624 L
.54391 .29287 L
.58238 .32427 L
.6233 .35946 L
.6627 .39078 L
.6825 .40423 L
.70059 .41457 L
.72003 .42313 L
.72516 .42488 L
.73075 .42654 L
.73564 .42775 L
.74093 .42881 L
.7437 .42926 L
.74626 .42961 L
Mistroke
.74865 .42987 L
.74992 .42999 L
.75127 .4301 L
.75251 .43018 L
.75363 .43023 L
.75476 .43028 L
.75583 .43031 L
.75703 .43033 L
.75813 .43033 L
.75935 .43032 L
.76064 .43029 L
.76193 .43025 L
.76312 .43019 L
.76442 .4301 L
.76579 .42999 L
.7681 .42976 L
.77062 .42943 L
.77632 .42842 L
.78162 .42712 L
.79217 .42349 L
.80212 .4187 L
.82072 .40601 L
.83047 .39729 L
.84078 .38642 L
.85924 .36249 L
.89718 .29374 L
.91667 .24722 L
.93757 .18808 L
.97619 .05166 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo0029Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo0029Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol008Yoo`@000ioo`8000Ioo`03001oogoo0:9oo`00
Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007oo
Ool0XWoo002TOol00`00Oomoo`2ROol00:Aoo`800:=oo`00Y7oo00<007ooOol0XWoo002TOol00`00
Oomoo`2ROol00:Aoo`03001oogoo0:9oo`00Y7oo00<007ooOol0XWoo002TOol00`00Oomoo`2ROol0
0:Aoo`03001oogoo09Aoo`03?n1oogoo00]oo`00Y7oo00<007ooOol0U7oo00<oh7ooOol02goo002T
Ool00`00Oomoo`2COol00coPOomoo`0<Ool00:Aoo`8009Aoo`03?n1oogoo00aoo`00Y7oo00<007oo
Ool0Tgoo00<oh7ooOol037oo002TOol00`00Oomoo`2COol00coPOomoo`0<Ool00:Aoo`03001oogoo
099oo`03?n1oogoo00eoo`00Y7oo00<007ooOol0TWoo00<oh7ooOol03Goo002TOol00`00Oomoo`2B
Ool00coPOomoo`0=Ool00:Aoo`03001oogoo099oo`03?n1oogoo00eoo`00Y7oo00<007ooOol0TGoo
00<oh7ooOol03Woo002TOol00`00Oomoo`2AOol00coPOomoo`0>Ool00:Aoo`03001oogoo095oo`03
?n1oogoo00ioo`00Y7oo0P00TGoo00<oh7ooOol03goo002TOol00`00Oomoo`2@Ool00coPOomoo`0?
Ool00:Aoo`03001oogoo091oo`03?n1oogoo00moo`00Y7oo00<007ooOol0T7oo00<oh7ooOol03goo
002TOol00`00Oomoo`2?Ool00coPOomoo`0@Ool00:Aoo`03001oogoo08moo`03?n1oogoo011oo`00
Y7oo00<007ooOol0Sgoo00<oh7ooOol047oo002:Ool40005Ool20004Ool50006Ool00`00Oomoo`2?
Ool00coPOomoo`0@Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol0
0006Ool00`00Oomoo`2>Ool00coPOomoo`0AOol008Uoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Moo`03001oogoo08ioo`03?n1oogoo015oo`00PGoo1P000Woo00<007ooOol00Woo00<0
07ooOol02Woo00<007ooOol01Woo0`00SWoo00<oh7ooOol04Goo0029Ool00`00Oomoo`02Ool00`00
Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2=Ool00coPOomoo`0BOol008Uoo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo08eoo`03?n1oogoo019oo`00RGoo00<007oo
Ool00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo08eoo`03?n1oogoo019oo`00
RWoo100037oo0`001goo00<007ooOol0SGoo00<oh7ooOol04Woo002TOol00`00Oomoo`2<Ool00coP
Oomoo`0COol00:Aoo`03001oogoo08aoo`03?n1oogoo01=oo`00Y7oo00<007ooOol0S7oo00<oh7oo
Ool04goo002TOol00`00Oomoo`2<Ool00coPOomoo`0COol00:Aoo`03001oogoo08]oo`03?n1oogoo
01Aoo`00Y7oo0P00S7oo00<oh7ooOol057oo002TOol00`00Oomoo`2;Ool00coPOomoo`0DOol00:Ao
o`03001oogoo08Yoo`03?n1oogoo01Eoo`00Y7oo00<007ooOol0RWoo00<oh7ooOol05Goo002TOol0
0`00Oomoo`2:Ool00coPOomoo`0EOol00:Aoo`03001oogoo08Yoo`03?n1oogoo01Eoo`00Y7oo00<0
07ooOol0RGoo00<oh7ooOol05Woo002TOol00`00Oomoo`29Ool00coPOomoo`0FOol00:Aoo`03001o
ogoo08Uoo`03?n1oogoo01Ioo`00Y7oo00<007ooOol0RGoo00<oh7ooOol05Woo002TOol20029Ool0
0coPOomoo`0GOol00:Aoo`03001oogoo08Qoo`03?n1oogoo01Moo`00Y7oo00<007ooOol0R7oo00<o
h7ooOol05goo002TOol00`00Oomoo`27Ool00coPOomoo`0HOol000eoo`D004Qoo`D004Eoo`03001o
ogoo04Ioo`D003aoo`03?n1oogoo00Moo`D000aoo`003Goo00D007ooOomoo`0004Yoo`03001oogoo
04Eoo`03001oogoo04Qoo`03001oogoo03]oo`03?n1oogoo00Qoo`05001oogooOol0000<Ool000io
o`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo03]oo`03?n1oogoo00Uo
o`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007ooOol0AGoo00<007oo
Ool0B7oo00<007ooOol0>goo00<oh7ooOol02Woo00<007ooOol037oo000@Ool00`00Oomoo`19Ool0
0`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0jOol00coPOomoo`0<Ool00`00Oomoo`0;Ool0
015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo03Yoo`03?n1oogoo
00eoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Moo`<003]oo`03?n1o
ogoo00Yoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03001oogoo04Qoo`03
001oogoo03Uoo`03?n1oogoo00]oo`<000eoo`00Y7oo00<007ooOol0Q7oo00<oh7ooOol06goo002T
Ool00`00Oomoo`23Ool00coPOomoo`0LOol00:Aoo`03001oogoo08=oo`03?n1oogoo01aoo`00Y7oo
00<007ooOol0Pgoo00<oh7ooOol077oo002TOol00`00Oomoo`22Ool00coPOomoo`0MOol00:Aoo`03
001oogoo089oo`03?n1oogoo01eoo`00Y7oo00<007ooOol0PGoo00<oh7ooOol07Woo0004Oon:0006
?n2D00000coP0000000I0005Ool000aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo009oo`Doh0Eoo`Hoh0Yoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00Qoo`05?n1oogooOol0000>Ool00`00Oomoo`0;Ool000aoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oocoP008oh0Yoo`03001oogoo00=oo`<oh0Moo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Moo`03?n1oogoo009oo`03001o
ogoo00aoo`03001oogoo00]oo`00QGoo0SoP5Woo0coP17oo00<007ooOol0P7oo00<oh7ooOol07goo
0023Ool2?n0KOol2?n02Ool00`00Oomoo`1oOol00coPOomoo`0POol0089oo`03?n1oogoo01eoo`8o
h003001oogoo07moo`03?n1oogoo021oo`00P7oo0SoP8Woo0SoPP7oo00<oh7ooOol087oo001oOol0
0coPOomoo`0ROol01000Ooloh3oPOGoo00<oh7ooOol08Goo001mOol2?n0UOol01@00Oomoogoo?n00
O7oo00<oh7ooOol08Goo001kOol2?n0WOol00`00Oomoo`02Ool2?n1iOol00coPOomoo`0ROol007Yo
o`03?n1oogoo02Moo`8000Eoo`03?n1oogoo07Ioo`03?n1oogoo029oo`00NGoo00<oh7ooOol0:7oo
00<007ooOol01Goo00<oh7ooOol0MGoo00<oh7ooOol08Woo001iOol00coPOomoo`0XOol00`00Oomo
o`06Ool2?n1dOol00coPOomoo`0SOol007Qoo`03?n1oogoo02Uoo`03001oogoo00Qoo`03?n1oogoo
075oo`03?n1oogoo02=oo`00Mgoo00<oh7ooOol0:Woo00<007ooOol02Goo0SoPL7oo00<oh7ooOol0
97oo001fOol00coPOomoo`0[Ool00`00Oomoo`0;Ool00coPOomoo`1]Ool00coPOomoo`0TOol007Eo
o`03?n1oogoo02aoo`03001oogoo00aoo`03?n1oogoo06]oo`03?n1oogoo02Eoo`00MGoo00<oh7oo
Ool0;7oo00<007ooOol03Goo00<oh7ooOol0JWoo00<oh7ooOol09Goo001dOol00coPOomoo`0]Ool0
0`00Oomoo`0>Ool2?n1YOol00coPOomoo`0VOol007=oo`03?n1oogoo02ioo`03001oogoo011oo`03
?n1oogoo06Ioo`03?n1oogoo02Ioo`00LWoo00<oh7ooOol0;goo0P004Woo00<oh7ooOol0I7oo00<o
h7ooOol09goo001aOol00coPOomoo`0`Ool00`00Oomoo`0BOol00coPOomoo`1SOol00coPOomoo`0W
Ool0075oo`03?n1oogoo031oo`03001oogoo01=oo`03?n1oogoo065oo`03?n1oogoo02Qoo`00L7oo
00<oh7ooOol0<Goo00<007ooOol057oo0SoPHGoo00<oh7ooOol0:7oo001_Ool00coPOomoo`0bOol0
0`00Oomoo`0FOol00coPOomoo`1MOol00coPOomoo`0YOol006moo`03?n1oogoo039oo`03001oogoo
01Moo`03?n1oogoo05aoo`03?n1oogoo02Uoo`00KWoo00<oh7ooOol0<goo00<007ooOol067oo00<o
h7ooOol0FWoo00<oh7ooOol0:Woo001^Ool00coPOomoo`0cOol00`00Oomoo`0IOol00coPOomoo`1H
Ool00coPOomoo`0[Ool006eoo`03?n1oogoo03Aoo`03001oogoo01Yoo`8oh5Qoo`03?n1oogoo02]o
o`00K7oo00<oh7ooOol0=Goo00<007ooOol077oo00<oh7ooOol0E7oo00<oh7ooOol0;7oo001/Ool0
0coPOomoo`0eOol2000NOol00coPOomoo`1COol00coPOomoo`0/Ool006]oo`03?n1oogoo03Ioo`03
001oogoo01ioo`03?n1oogoo055oo`03?n1oogoo02eoo`00JWoo00<oh7ooOol0=goo00<007ooOol0
7goo00<oh7ooOol0D7oo00<oh7ooOol0;Goo001ZOol00coPOomoo`0gOol00`00Oomoo`0POol2?n1?
Ool00coPOomoo`0^Ool006Uoo`03?n1oogoo03Qoo`03001oogoo029oo`03?n1oogoo04aoo`03?n1o
ogoo02ioo`00JGoo00<oh7ooOol0>7oo00<007ooOol08goo00<oh7ooOol0BWoo00<oh7ooOol0;goo
001XOol00coPOomoo`0iOol00`00Oomoo`0TOol00coPOomoo`19Ool00coPOomoo`0_Ool006Qoo`03
?n1oogoo01moo`@000Eoo`8000Aoo`D000Ioo`03001oogoo02Eoo`03?n1oogoo04Moo`03?n1oogoo
031oo`00Igoo00<oh7ooOol07goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00D007ooOomo
o`0000Ioo`03001oogoo02Ioo`03?n1oogoo04Eoo`03?n1oogoo035oo`00Igoo00<oh7ooOol07goo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol09goo0SoPA7oo00<oh7oo
Ool0<Woo001VOol00coPOomoo`0POol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool3
000YOol00coPOomoo`11Ool00coPOomoo`0bOol006Ioo`03?n1oogoo021oo`03001oogoo009oo`03
001oogoo00]oo`03001oogoo00Eoo`03001oogoo02Yoo`03?n1oogoo03moo`03?n1oogoo03=oo`00
IGoo00<oh7ooOol08Goo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol0
:goo00<oh7ooOol0?Goo00<oh7ooOol0=7oo001UOol00coPOomoo`0QOol00`00Oomoo`02Ool00`00
Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol0;7oo00<oh7ooOol0>goo00<oh7ooOol0=Goo
001UOol00coPOomoo`0ROol4000<Ool30007Ool00`00Oomoo`0]Ool2?n0kOol00coPOomoo`0eOol0
06Aoo`03?n1oogoo03eoo`03001oogoo02moo`03?n1oogoo03Moo`03?n1oogoo03Ioo`00I7oo00<o
h7ooOol0?Goo00<007ooOol0<7oo00<oh7ooOol0=Goo00<oh7ooOol0=goo001SOol00coPOomoo`0n
Ool00`00Oomoo`0aOol2?n0dOol00coPOomoo`0hOol006=oo`03?n1oogoo03ioo`03001oogoo03=o
o`8oh35oo`03?n1oogoo03Uoo`00HWoo00<oh7ooOol0?goo00<007ooOol0=Goo0SoP;Woo00<oh7oo
Ool0>Woo001ROol00coPOomoo`0oOol2000hOol00coPOomoo`0ZOol00coPOomoo`0kOol0065oo`03
?n1oogoo041oo`03001oogoo03Qoo`8oh2Uoo`03?n1oogoo03aoo`00HGoo00<oh7ooOol0@7oo00<0
07ooOol0>Woo00<oh7ooOol097oo0SoP?goo001QOol00coPOomoo`10Ool00`00Oomoo`0kOol2?n0S
Ool00coPOomoo`0oOol0061oo`03?n1oogoo045oo`03001oogoo03eoo`8oh1moo`8oh49oo`00H7oo
00<oh7ooOol0@Goo00<007ooOol0?goo0coP6goo00<oh7ooOol0@Woo001OOol00coPOomoo`12Ool0
0`00Oomoo`12Ool2?n0GOol2?n15Ool005moo`03?n1oogoo049oo`03001oogoo04Aoo`03?n1oogoo
019oo`8oh4Moo`00GWoo00<oh7ooOol0@goo00<007ooOol0AGoo1coP1goo1SoPBGoo001NOol00coP
Oomoo`13Ool2001=Ool7?n1?Ool005ioo`03?n1oogoo04=oo`03001oogoo0:9oo`00GGoo00<oh7oo
Ool0A7oo00<007ooOol0XWoo001MOol00coPOomoo`14Ool00`00Oomoo`2ROol005eoo`03?n1oogoo
04Aoo`03001oogoo0:9oo`00G7oo00<oh7ooOol0AGoo00<007ooOol0XWoo001LOol00coPOomoo`15
Ool00`00Oomoo`2ROol005aoo`03?n1oogoo04Eoo`03001oogoo0:9oo`00Fgoo00<oh7ooOol0AWoo
00<007ooOol0XWoo001KOol00coPOomoo`16Ool00`00Oomoo`2ROol005]oo`03?n1oogoo04Ioo`80
0:=oo`00FWoo00<oh7ooOol0Agoo00<007ooOol0XWoo001JOol00coPOomoo`17Ool00`00Oomoo`2R
Ool005Yoo`03?n1oogoo04Moo`03001oogoo0:9oo`00FGoo00<oh7ooOol0B7oo00<007ooOol0XWoo
001IOol00coPOomoo`18Ool00`00Oomoo`2ROol005Uoo`03?n1oogoo04Qoo`03001oogoo0:9oo`00
F7oo00<oh7ooOol0;goo10001Goo0P001goo0`001Goo00<007ooOol0XWoo001HOol00coPOomoo`0^
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`04Ool00`00Oomoo`2ROol005Qo
o`03?n1oogoo02ioo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9o
o`00Egoo00<oh7ooOol0;goo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo001GOol0
0coPOomoo`0_Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo
001GOol00coPOomoo`0_Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007oo
Ool0XWoo001GOol00coPOomoo`0_Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool0
0`00Oomoo`2ROol005Ioo`03?n1oogoo035oo`@000ioo`8000Ioo`03001oogoo0:9oo`00EWoo00<o
h7ooOol0Bgoo00<007ooOol0XWoo001FOol00coPOomoo`1;Ool00`00Oomoo`2ROol005Eoo`03?n1o
ogoo04aoo`03001oogoo0:9oo`00EGoo00<oh7ooOol0C7oo00<007ooOol0XWoo001EOol00coPOomo
o`1<Ool00`00Oomoo`2ROol005Aoo`03?n1oogoo04eoo`800:=oo`00E7oo00<oh7ooOol0CGoo00<0
07ooOol0XWoo001DOol00coPOomoo`1=Ool00`00Oomoo`2ROol005Aoo`03?n1oogoo04eoo`03001o
ogoo0:9oo`00Dgoo00<oh7ooOol0CWoo00<007ooOol0XWoo001COol00coPOomoo`1>Ool00`00Oomo
o`2ROol005=oo`03?n1oogoo04ioo`03001oogoo0:9oo`00DWoo00<oh7ooOol0Cgoo00<007ooOol0
XWoo001BOol00coPOomoo`1?Ool00`00Oomoo`2ROol0059oo`03?n1oogoo04moo`03001oogoo0:9o
o`00DWoo00<oh7ooOol0Cgoo0P00Xgoo001AOol00coPOomoo`1@Ool00`00Oomoo`2ROol0055oo`03
?n1oogoo051oo`03001oogoo0:9oo`00DGoo00<oh7ooOol0D7oo00<007ooOol0XWoo001@Ool00coP
Oomoo`1AOol00`00Oomoo`2ROol0051oo`03?n1oogoo055oo`03001oogoo0:9oo`00D7oo00<oh7oo
Ool0DGoo00<007ooOol0XWoo001@Ool00coPOomoo`1AOol00`00Oomoo`2ROol004moo`03?n1oogoo
059oo`03001oogoo0:9oo`00Cgoo00<oh7ooOol0DWoo00<007ooOol0XWoo001?Ool00coPOomoo`1B
Ool2002SOol004ioo`03?n1oogoo05=oo`03001oogoo0:9oo`00CWoo00<oh7ooOol0Dgoo00<007oo
Ool0XWoo001>Ool00coPOomoo`1COol00`00Oomoo`2ROol004eoo`03?n1oogoo05Aoo`03001oogoo
0:9oo`00CGoo00<oh7ooOol0E7oo00<007ooOol0XWoo001=Ool00coPOomoo`1DOol00`00Oomoo`2R
Ool004eoo`03?n1oogoo05Aoo`03001oogoo0:9oo`00C7oo00<oh7ooOol0EGoo00<007ooOol0XWoo
001<Ool00coPOomoo`1EOol00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 1 0 r
.5 Mabswid
.21326 .61803 m
.22272 .57807 L
.26171 .45217 L
.28158 .40134 L
.30316 .35554 L
.32216 .32274 L
.34309 .2942 L
.36292 .27395 L
.37378 .26546 L
.38395 .25908 L
.39433 .25406 L
.39945 .25212 L
.4042 .25062 L
.40884 .24942 L
.41306 .24857 L
.41774 .24787 L
.4203 .24759 L
.42147 .24749 L
.42272 .2474 L
.42398 .24733 L
.42513 .24728 L
.42628 .24724 L
.42738 .24722 L
.42865 .24721 L
.42982 .24722 L
.43112 .24725 L
.43177 .24727 L
.43249 .2473 L
.43382 .24736 L
.43505 .24744 L
.43781 .24767 L
.44024 .24794 L
.4428 .24828 L
.45162 .24997 L
.45662 .25125 L
.46127 .25264 L
.48173 .2609 L
.50032 .27105 L
.5403 .2993 L
.57877 .3314 L
.61969 .36641 L
.65909 .39665 L
.67889 .40922 L
.69698 .41857 L
.70628 .42244 L
.71642 .42585 L
.72199 .42734 L
.72714 .42847 L
.73207 .4293 L
.73482 .42967 L
Mistroke
.73732 .42993 L
.73965 .43012 L
.74097 .4302 L
.74221 .43026 L
.74351 .4303 L
.7447 .43033 L
.74536 .43033 L
.74607 .43033 L
.74737 .43033 L
.74847 .4303 L
.7497 .43026 L
.75097 .4302 L
.75217 .43013 L
.7543 .42996 L
.7566 .42971 L
.7619 .42892 L
.76457 .42839 L
.76748 .42771 L
.77744 .4246 L
.78274 .42242 L
.78774 .42002 L
.79708 .4146 L
.81805 .39779 L
.8381 .37519 L
.85657 .34827 L
.89602 .26907 L
.93396 .16184 L
.97435 .00991 L
.97619 .00201 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00U7oo00<Gh7ooOol02goo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0U7oo00<Gh7oo
Ool02goo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0U7oo
00<Gh7ooOol02goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`2DOol00aOPOomoo`0;Ool008Yoo`@000ioo`8000Ioo`03001oogoo09Aoo`035n1oogoo00]oo`00
Y7oo00<007ooOol0Tgoo00<Gh7ooOol037oo002TOol00`00Oomoo`2COol00aOPOomoo`0<Ool00:Ao
o`03001oogoo09=oo`035n1oogoo00aoo`00Y7oo00<007ooOol0Tgoo00<Gh7ooOol037oo002TOol0
0`00Oomoo`2BOol00aOPOomoo`0=Ool00:Aoo`8009=oo`035n1oogoo00eoo`00Y7oo00<007ooOol0
TWoo00<Gh7ooOol03Goo002TOol00`00Oomoo`2BOol00aOPOomoo`0=Ool00:Aoo`03001oogoo095o
o`035n1oogoo00ioo`00Y7oo00<007ooOol0TGoo00<Gh7ooOol03Woo002TOol00`00Oomoo`2AOol0
0aOPOomoo`0>Ool00:Aoo`03001oogoo091oo`035n1oogoo00moo`00Y7oo00<007ooOol0T7oo00<G
h7ooOol03goo002TOol00`00Oomoo`2@Ool00aOPOomoo`0?Ool00:Aoo`80095oo`035n1oogoo00mo
o`00Y7oo00<007ooOol0Sgoo00<Gh7ooOol047oo002TOol00`00Oomoo`2?Ool00aOPOomoo`0@Ool0
0:Aoo`03001oogoo08moo`035n1oogoo011oo`00Y7oo00<007ooOol0Sgoo00<Gh7ooOol047oo002T
Ool00`00Oomoo`2>Ool00aOPOomoo`0AOol00:Aoo`03001oogoo08ioo`035n1oogoo015oo`00Y7oo
00<007ooOol0SWoo00<Gh7ooOol04Goo002TOol00`00Oomoo`2=Ool00aOPOomoo`0BOol00:Aoo`03
001oogoo08eoo`035n1oogoo019oo`00Y7oo0P00SWoo00<Gh7ooOol04Woo002TOol00`00Oomoo`2=
Ool00aOPOomoo`0BOol00:Aoo`03001oogoo08aoo`035n1oogoo01=oo`00Y7oo00<007ooOol0S7oo
00<Gh7ooOol04goo002TOol00`00Oomoo`2<Ool00aOPOomoo`0COol00:Aoo`03001oogoo08aoo`03
5n1oogoo01=oo`00Y7oo00<007ooOol0Rgoo00<Gh7ooOol057oo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`2;Ool00aOPOomoo`0DOol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`2;Ool00aOPOomoo`0DOol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo08]oo`035n1oogoo01Aoo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00RWoo00<Gh7ooOol05Goo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`2:Ool00aOPOomoo`0EOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo08Yoo`035n1oogoo01Eo
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo08Uoo`03
5n1oogoo01Ioo`00RWoo100037oo0`001goo00<007ooOol0RGoo00<Gh7ooOol05Woo002TOol00`00
Oomoo`29Ool00aOPOomoo`0FOol00:Aoo`03001oogoo08Uoo`035n1oogoo01Ioo`00Y7oo00<007oo
Ool0R7oo00<Gh7ooOol05goo002TOol00`00Oomoo`28Ool00aOPOomoo`0GOol00:Aoo`03001oogoo
08Qoo`035n1oogoo01Moo`00Y7oo0P00RGoo00<Gh7ooOol05goo002TOol00`00Oomoo`27Ool00aOP
Oomoo`0HOol00:Aoo`03001oogoo08Moo`035n1oogoo01Qoo`00Y7oo00<007ooOol0Qgoo00<Gh7oo
Ool067oo002TOol00`00Oomoo`26Ool00aOPOomoo`0IOol00:Aoo`03001oogoo08Ioo`035n1oogoo
01Uoo`00Y7oo00<007ooOol0QWoo00<Gh7ooOol06Goo002TOol00`00Oomoo`25Ool00aOPOomoo`0J
Ool00:Aoo`03001oogoo08Eoo`035n1oogoo01Yoo`00Y7oo00<007ooOol0QGoo00<Gh7ooOol06Woo
002TOol20025Ool00aOPOomoo`0KOol00:Aoo`03001oogoo08Aoo`035n1oogoo01]oo`00Y7oo00<0
07ooOol0Pgoo00<Gh7ooOol077oo002TOol00`00Oomoo`23Ool00aOPOomoo`0LOol000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D003Qoo`035n1oogoo00]oo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo03Moo`035n1oogoo00aoo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo03Mo
o`035n1oogoo00eoo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol0=goo00<Gh7ooOol03Woo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0fOol00aOPOomoo`0@Ool0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
03Ioo`035n1oogoo015oo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<003Qoo`035n1oogoo00eoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo03Eoo`035n1oogoo00moo`<000eoo`00Y7oo00<007ooOol0P7oo00<G
h7ooOol07goo002TOol00`00Oomoo`20Ool00aOPOomoo`0OOol00:Aoo`03001oogoo07moo`035n1o
ogoo021oo`00Y7oo00<007ooOol0Ogoo00<Gh7ooOol087oo002TOol00`00Oomoo`1oOol00aOPOomo
o`0POol00:Aoo`03001oogoo07ioo`035n1oogoo025oo`00Y7oo00<007ooOol0OWoo00<Gh7ooOol0
8Goo0004Oon700055n2D00000aOP0000000M0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`HGh0Eoo`DGh0moo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00Aoo`035n1oogoo00Eoo`03001oogoo00aoo`03001oogoo00]oo`0037oo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol02goo00<Gh000Ool03Goo00<001OP5n000QOP2goo00<0
07ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol017oo00<Gh7ooOol01Goo00<0
07ooOol037oo00<007ooOol02goo0021Ool35n0EOol25n09Ool00`00Oomoo`1lOol00aOPOomoo`0S
Ool007moo`8Gh1Yoo`8Gh0Moo`03001oogoo07aoo`035n1oogoo02=oo`00OGoo0QOP7Woo0QOP1Goo
00<007ooOol0O7oo00<Gh7ooOol08goo001kOol25n0ROol25n03Ool00`00Oomoo`1kOol00aOPOomo
o`0TOol007Yoo`035n1oogoo02Aoo`8Gh003Ool007oo07aoo`035n1oogoo02Aoo`00NGoo00<Gh7oo
Ool09goo0QOPO7oo00<Gh7ooOol09Goo001hOol00aOPOomoo`0YOol00`005n1oo`1jOol00aOPOomo
o`0UOol007Moo`035n1oogoo02Yoo`80008Gh7Qoo`035n1oogoo02Ioo`00MWoo00<Gh7ooOol0:goo
00D007ooOomooaOP07Moo`035n1oogoo02Ioo`00MGoo00<Gh7ooOol0;7oo00<007ooOol00Woo00<G
h7ooOol0Lgoo00<Gh7ooOol09goo001dOol00aOPOomoo`0]Ool00`00Oomoo`03Ool25n1cOol00aOP
Oomoo`0WOol007=oo`035n1oogoo02ioo`03001oogoo00Eoo`035n1oogoo06moo`035n1oogoo02Qo
o`00LWoo00<Gh7ooOol0;goo00<007ooOol01Woo00<Gh7ooOol0KWoo00<Gh7ooOol0:7oo001aOol0
0aOPOomoo`0`Ool00`00Oomoo`07Ool25n1]Ool00aOPOomoo`0YOol0071oo`035n1oogoo035oo`03
001oogoo00Uoo`035n1oogoo06Yoo`035n1oogoo02Uoo`00L7oo00<Gh7ooOol0<Goo00<007ooOol0
2Woo00<Gh7ooOol0J7oo00<Gh7ooOol0:Woo001_Ool00aOPOomoo`0bOol00`00Oomoo`0;Ool25n1X
Ool00aOPOomoo`0ZOol006ioo`035n1oogoo03=oo`8000ioo`035n1oogoo06Aoo`035n1oogoo02]o
o`00KGoo00<Gh7ooOol0=7oo00<007ooOol03Woo00<Gh7ooOol0Hgoo00<Gh7ooOol0:goo001]Ool0
0aOPOomoo`0dOol00`00Oomoo`0?Ool25n1ROol00aOPOomoo`0/Ool006aoo`035n1oogoo03Eoo`03
001oogoo015oo`035n1oogoo05moo`035n1oogoo02aoo`00Jgoo00<Gh7ooOol0=Woo00<007ooOol0
4Woo00<Gh7ooOol0GGoo00<Gh7ooOol0;Goo001ZOol00aOPOomoo`0gOol00`00Oomoo`0COol25n1M
Ool00aOPOomoo`0]Ool006Yoo`035n1oogoo03Moo`03001oogoo01Eoo`035n1oogoo05Uoo`035n1o
ogoo02ioo`00JGoo00<Gh7ooOol0>7oo00<007ooOol05Woo00<Gh7ooOol0F7oo00<Gh7ooOol0;Woo
001YOol00aOPOomoo`0hOol00`00Oomoo`0GOol00aOPOomoo`1FOol00aOPOomoo`0_Ool006Qoo`03
5n1oogoo03Uoo`03001oogoo01Qoo`035n1oogoo05Eoo`035n1oogoo02moo`00J7oo00<Gh7ooOol0
>Goo0P006Woo0QOPE7oo00<Gh7ooOol0<7oo001WOol00aOPOomoo`0jOol00`00Oomoo`0KOol00aOP
Oomoo`1AOol00aOPOomoo`0`Ool006Moo`035n1oogoo03Yoo`03001oogoo01aoo`035n1oogoo04mo
o`035n1oogoo035oo`00IWoo00<Gh7ooOol0>goo00<007ooOol07Goo00<Gh7ooOol0CWoo00<Gh7oo
Ool0<Goo001VOol00aOPOomoo`0kOol00`00Oomoo`0NOol00aOPOomoo`1<Ool00aOPOomoo`0bOol0
06Eoo`035n1oogoo03aoo`03001oogoo01moo`8Gh4]oo`035n1oogoo03=oo`00I7oo00<Gh7ooOol0
?Goo00<007ooOol08Goo00<Gh7ooOol0B7oo00<Gh7ooOol0<goo001TOol00aOPOomoo`0SOol40005
Ool20004Ool50006Ool00`00Oomoo`0ROol00aOPOomoo`16Ool00aOPOomoo`0dOol006=oo`035n1o
ogoo02=oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006Ool00`00Oomo
o`0SOol00aOPOomoo`14Ool00aOPOomoo`0eOol006=oo`035n1oogoo02=oo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo02Aoo`035n1oogoo049oo`035n1oogoo03Ioo`00
HWoo00<Gh7ooOol097oo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`009Goo00<G
h7ooOol0@Goo00<Gh7ooOol0=Woo001ROol00aOPOomoo`0TOol00`00Oomoo`02Ool00`00Oomoo`0;
Ool00`00Oomoo`05Ool00`00Oomoo`0VOol25n10Ool00aOPOomoo`0gOol0065oo`035n1oogoo02Eo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo02Qoo`035n1oogoo03ao
o`035n1oogoo03Qoo`00HGoo00<Gh7ooOol09Goo00<007ooOol00Woo00<007ooOol027oo00D007oo
Oomoo`0000Ioo`03001oogoo02Uoo`035n1oogoo03Yoo`035n1oogoo03Uoo`00H7oo00<Gh7ooOol0
9goo100037oo0`001goo00<007ooOol0:Woo00<Gh7ooOol0>7oo00<Gh7ooOol0>Woo001POol00aOP
Oomoo`11Ool00`00Oomoo`0[Ool00aOPOomoo`0gOol00aOPOomoo`0jOol005moo`035n1oogoo049o
o`03001oogoo02aoo`8Gh3Ioo`035n1oogoo03]oo`00Ggoo00<Gh7ooOol0@Woo00<007ooOol0;Woo
00<Gh7ooOol0<Woo00<Gh7ooOol0?7oo001NOol00aOPOomoo`13Ool00`00Oomoo`0_Ool00aOPOomo
o`0`Ool00aOPOomoo`0mOol005ioo`035n1oogoo04=oo`03001oogoo031oo`8Gh2moo`035n1oogoo
03ioo`00GWoo00<Gh7ooOol0@goo0P00<goo0QOP;7oo00<Gh7ooOol0?goo001MOol00aOPOomoo`14
Ool00`00Oomoo`0dOol25n0XOol25n12Ool005eoo`035n1oogoo04Aoo`03001oogoo03Ioo`035n1o
ogoo02Aoo`035n1oogoo049oo`00GGoo00<Gh7ooOol0A7oo00<007ooOol0=goo0QOP8goo00<Gh7oo
Ool0@goo001LOol00aOPOomoo`15Ool00`00Oomoo`0iOol25n0OOol25n16Ool005aoo`035n1oogoo
04Eoo`03001oogoo03]oo`8Gh1]oo`8Gh4Qoo`00G7oo00<Gh7ooOol0AGoo00<007ooOol0?Goo0aOP
5goo00<Gh7ooOol0B7oo001KOol00aOPOomoo`16Ool00`00Oomoo`10Ool35n0AOol35n1;Ool005]o
o`035n1oogoo04Ioo`03001oogoo04=oo`DGh0Qoo`@Gh4ioo`00FWoo00<Gh7ooOol0Agoo0P00B7oo
2AOPDWoo001JOol00aOPOomoo`17Ool00`00Oomoo`2ROol005Yoo`035n1oogoo04Moo`03001oogoo
0:9oo`00FGoo00<Gh7ooOol0B7oo00<007ooOol0XWoo001IOol00aOPOomoo`18Ool00`00Oomoo`2R
Ool005Uoo`035n1oogoo04Qoo`03001oogoo0:9oo`00F7oo00<Gh7ooOol0BGoo00<007ooOol0XWoo
001HOol00aOPOomoo`19Ool00`00Oomoo`2ROol005Qoo`035n1oogoo04Uoo`03001oogoo0:9oo`00
Egoo00<Gh7ooOol0BWoo00<007ooOol0XWoo001GOol00aOPOomoo`1:Ool2002SOol005Moo`035n1o
ogoo04Yoo`03001oogoo0:9oo`00EWoo00<Gh7ooOol0Bgoo00<007ooOol0XWoo001FOol00aOPOomo
o`1;Ool00`00Oomoo`2ROol005Ioo`035n1oogoo04]oo`03001oogoo0:9oo`00EGoo00<Gh7ooOol0
C7oo00<007ooOol0XWoo001EOol00aOPOomoo`1<Ool00`00Oomoo`2ROol005Eoo`035n1oogoo039o
o`@000Eoo`8000Moo`<000Eoo`03001oogoo0:9oo`00E7oo00<Gh7ooOol0<Woo00<007ooOol00Woo
00<007ooOol00Woo0P0027oo00<007ooOol017oo00<007ooOol0XWoo001DOol00aOPOomoo`0bOol0
0`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`2ROol005Aoo`035n1oogoo
039oo`03001oogoo009oo`03001oogoo00Qoo`H000Eoo`<00:9oo`00Dgoo00<Gh7ooOol0<goo00<0
07ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo0:9oo`00Dgoo00<Gh7ooOol0
<goo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo0:9oo`00Dgoo00<G
h7ooOol0<goo00<007ooOol00Woo00<007ooOol02Woo00<007oo00001Woo00<007ooOol0XWoo001B
Ool00aOPOomoo`0eOol4000>Ool20006Ool00`00Oomoo`2ROol0059oo`035n1oogoo04moo`03001o
ogoo0:9oo`00DWoo00<Gh7ooOol0Cgoo00<007ooOol0XWoo001AOol00aOPOomoo`1@Ool00`00Oomo
o`2ROol0055oo`035n1oogoo051oo`03001oogoo0:9oo`00DGoo00<Gh7ooOol0D7oo00<007ooOol0
XWoo001AOol00aOPOomoo`1@Ool2002SOol0051oo`035n1oogoo055oo`03001oogoo0:9oo`00D7oo
00<Gh7ooOol0DGoo00<007ooOol0XWoo001@Ool00aOPOomoo`1AOol00`00Oomoo`2ROol004moo`03
5n1oogoo059oo`03001oogoo0:9oo`00Cgoo00<Gh7ooOol0DWoo00<007ooOol0XWoo001?Ool00aOP
Oomoo`1BOol00`00Oomoo`2ROol004ioo`035n1oogoo05=oo`03001oogoo0:9oo`00CWoo00<Gh7oo
Ool0Dgoo00<007ooOol0XWoo001>Ool00aOPOomoo`1COol00`00Oomoo`2ROol004eoo`035n1oogoo
05Aoo`800:=oo`00CGoo00<Gh7ooOol0E7oo00<007ooOol0XWoo001=Ool00aOPOomoo`1DOol00`00
Oomoo`2ROol004aoo`035n1oogoo05Eoo`03001oogoo0:9oo`00C7oo00<Gh7ooOol0EGoo00<007oo
Ool0XWoo001<Ool00aOPOomoo`1EOol00`00Oomoo`2ROol004]oo`035n1oogoo05Ioo`03001oogoo
0:9oo`00Bgoo00<Gh7ooOol0EWoo00<007ooOol0XWoo001;Ool00aOPOomoo`1FOol00`00Oomoo`2R
Ool004Yoo`035n1oogoo05Moo`03001oogoo0:9oo`00BWoo00<Gh7ooOol0Egoo0P00Xgoo001:Ool0
0aOPOomoo`1GOol00`00Oomoo`2ROol004Yoo`035n1oogoo05Moo`03001oogoo0:9oo`00BGoo00<G
h7ooOol0F7oo00<007ooOol0XWoo0019Ool00aOPOomoo`1HOol00`00Oomoo`2ROol004Uoo`035n1o
ogoo05Qoo`03001oogoo0:9oo`00BGoo00<Gh7ooOol0F7oo00<007ooOol0XWoo0018Ool00aOPOomo
o`1IOol00`00Oomoo`2ROol004Qoo`035n1oogoo05Uoo`03001oogoo0:9oo`00B7oo00<Gh7ooOol0
FGoo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 .1 r
.5 Mabswid
.20171 .61803 m
.22272 .53578 L
.26171 .42069 L
.28158 .3749 L
.30316 .33419 L
.32392 .30324 L
.34309 .28129 L
.36181 .26551 L
.37246 .25886 L
.38244 .25406 L
.3874 .25217 L
.39282 .25047 L
.39793 .2492 L
.40038 .24871 L
.40268 .24831 L
.40494 .24798 L
.40739 .24769 L
.40961 .24749 L
.41165 .24735 L
.4128 .2473 L
.41387 .24726 L
.41504 .24723 L
.4163 .24721 L
.41762 .24722 L
.41887 .24724 L
.41999 .24727 L
.42121 .24732 L
.42242 .24739 L
.42354 .24747 L
.42606 .24768 L
.43061 .24824 L
.43566 .2491 L
.44098 .25027 L
.45102 .25318 L
.46199 .25735 L
.4816 .26706 L
.50255 .28017 L
.54405 .312 L
.58403 .34624 L
.6225 .37833 L
.64198 .39301 L
.66342 .40713 L
.68377 .41797 L
.69289 .42187 L
.70282 .42534 L
.70822 .42687 L
.71323 .42806 L
.71801 .42897 L
.72046 .42935 L
.72311 .42969 L
Mistroke
.72572 .42996 L
.72686 .43005 L
.72812 .43014 L
.72923 .43021 L
.73041 .43026 L
.73167 .4303 L
.73283 .43033 L
.73397 .43033 L
.7352 .43033 L
.73637 .43031 L
.73744 .43027 L
.73841 .43023 L
.73948 .43018 L
.74164 .43002 L
.744 .42979 L
.74658 .42947 L
.75176 .42858 L
.75657 .42746 L
.76103 .42617 L
.77113 .42229 L
.7819 .41665 L
.79217 .40973 L
.80328 .40048 L
.82345 .37869 L
.84336 .35037 L
.86442 .31248 L
.90236 .22156 L
.94275 .08914 L
Mfstroke
.94275 .08914 m
.96396 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00T7oo00<3hWooOol03goo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0T7oo00<3hWoo
Ool03goo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0T7oo
00<3hWooOol03goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`2?Ool00`?ROomoo`0@Ool008Yoo`@000ioo`8000Ioo`03001oogoo08moo`030n9oogoo011oo`00
Y7oo00<007ooOol0Sgoo00<3hWooOol047oo002TOol00`00Oomoo`2?Ool00`?ROomoo`0@Ool00:Ao
o`03001oogoo08ioo`030n9oogoo015oo`00Y7oo00<007ooOol0SWoo00<3hWooOol04Goo002TOol0
0`00Oomoo`2>Ool00`?ROomoo`0AOol00:Aoo`8008moo`030n9oogoo015oo`00Y7oo00<007ooOol0
SWoo00<3hWooOol04Goo002TOol00`00Oomoo`2=Ool00`?ROomoo`0BOol00:Aoo`03001oogoo08eo
o`030n9oogoo019oo`00Y7oo00<007ooOol0SGoo00<3hWooOol04Woo002TOol00`00Oomoo`2=Ool0
0`?ROomoo`0BOol00:Aoo`03001oogoo08eoo`030n9oogoo019oo`00Y7oo00<007ooOol0S7oo00<3
hWooOol04goo002TOol00`00Oomoo`2<Ool00`?ROomoo`0COol00:Aoo`8008eoo`030n9oogoo01=o
o`00Y7oo00<007ooOol0S7oo00<3hWooOol04goo002TOol00`00Oomoo`2;Ool00`?ROomoo`0DOol0
0:Aoo`03001oogoo08]oo`030n9oogoo01Aoo`00Y7oo00<007ooOol0Rgoo00<3hWooOol057oo002T
Ool00`00Oomoo`2;Ool00`?ROomoo`0DOol00:Aoo`03001oogoo08]oo`030n9oogoo01Aoo`00Y7oo
00<007ooOol0RWoo00<3hWooOol05Goo002TOol00`00Oomoo`2:Ool00`?ROomoo`0EOol00:Aoo`03
001oogoo08Yoo`030n9oogoo01Eoo`00Y7oo0P00Rgoo00<3hWooOol05Goo002TOol00`00Oomoo`29
Ool00`?ROomoo`0FOol00:Aoo`03001oogoo08Uoo`030n9oogoo01Ioo`00Y7oo00<007ooOol0RGoo
00<3hWooOol05Woo002TOol00`00Oomoo`28Ool00`?ROomoo`0GOol00:Aoo`03001oogoo08Qoo`03
0n9oogoo01Moo`00Y7oo00<007ooOol0R7oo00<3hWooOol05goo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`28Ool00`?ROomoo`0GOol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`27Ool00`?ROomoo`0HOol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo08Moo`030n9oogoo01Qoo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00Qgoo00<3hWooOol067oo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`26Ool00`?ROomoo`0IOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo08Ioo`030n9oogoo01Uo
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo08Ioo`03
0n9oogoo01Uoo`00RWoo100037oo0`001goo00<007ooOol0QGoo00<3hWooOol06Woo002TOol00`00
Oomoo`25Ool00`?ROomoo`0JOol00:Aoo`03001oogoo08Eoo`030n9oogoo01Yoo`00Y7oo00<007oo
Ool0Q7oo00<3hWooOol06goo002TOol00`00Oomoo`24Ool00`?ROomoo`0KOol00:Aoo`03001oogoo
08Aoo`030n9oogoo01]oo`00Y7oo0P00Q7oo00<3hWooOol077oo002TOol00`00Oomoo`23Ool00`?R
Oomoo`0LOol00:Aoo`03001oogoo08=oo`030n9oogoo01aoo`00Y7oo00<007ooOol0Pgoo00<3hWoo
Ool077oo002TOol00`00Oomoo`22Ool00`?ROomoo`0MOol00:Aoo`03001oogoo089oo`030n9oogoo
01eoo`00Y7oo00<007ooOol0PWoo00<3hWooOol07Goo002TOol00`00Oomoo`21Ool00`?ROomoo`0N
Ool00:Aoo`03001oogoo085oo`030n9oogoo01ioo`00Y7oo00<007ooOol0PGoo00<3hWooOol07Woo
002TOol20021Ool00`?ROomoo`0OOol00:Aoo`03001oogoo081oo`030n9oogoo01moo`00Y7oo00<0
07ooOol0P7oo00<3hWooOol07goo002TOol00`00Oomoo`1oOol00`?ROomoo`0POol000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D003Aoo`030n9oogoo00moo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo03Aoo`030n9oogoo00moo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo03Ao
o`030n9oogoo011oo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol0<goo00<3hWooOol04Woo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0cOol00`?ROomoo`0COol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
03=oo`030n9oogoo01Aoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<003Aoo`030n9oogoo015oo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo039oo`030n9oogoo019oo`<000eoo`00Y7oo00<007ooOol0OGoo00<3
hWooOol08Woo002TOol00`00Oomoo`1lOol00`?ROomoo`0SOol00:Aoo`03001oogoo07aoo`030n9o
ogoo02=oo`00Y7oo00<007ooOol0Ngoo00<3hWooOol097oo002TOol00`00Oomoo`1kOol00`?ROomo
o`0TOol00:Aoo`03001oogoo07]oo`030n9oogoo02Aoo`00Y7oo00<007ooOol0NWoo00<3hWooOol0
9Goo0004Oon300050n:E00000`?R0000000P0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00Qoo`H3hPEoo`L3hP03Ool007oo00ioo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03
001oogoo00aoo`04001oogoo0n8;Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool000aoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00Moo`030n9oogoo009oo`03001oogoo00]oo`83hPmoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`04001oogoo0n8;Ool00`00Oomoo`0<Ool0
0`00Oomoo`0;Ool007eoo`<3hQEoo`83hPeoo`03001oogoo07Qoo`030n9oogoo02Moo`00Ngoo0P?R
6Woo0P?R2goo00<007ooOol0N7oo00<3hWooOol09goo001iOol20n8NOol20n89Ool00`00Oomoo`1h
Ool00`?ROomoo`0WOol007Qoo`030n9oogoo021oo`83hPMoo`03001oogoo07Moo`030n9oogoo02Qo
o`00Mgoo00<3hWooOol08goo0P?R1Goo00<007ooOol0Mgoo00<3hWooOol0:7oo001fOol00`?ROomo
o`0VOol20n83Ool00`00Oomoo`1fOol00`?ROomoo`0YOol007Aoo`83hR]oo`040n9oogoo001hOol0
0`?ROomoo`0YOol007=oo`030n9oogoo02aoo`83hP8007Moo`030n9oogoo02Uoo`00LWoo00<3hWoo
Ool0;goo00<3hWooOol0MGoo00<3hWooOol0:Woo001aOol00`?ROomoo`0`Ool00`000n83hP1eOol0
0`?ROomoo`0ZOol0071oo`030n9oogoo035oo`04001oogoo0n9cOol00`?ROomoo`0[Ool006moo`03
0n9oogoo039oo`05001oogooOol3hP1bOol00`?ROomoo`0[Ool006moo`030n9oogoo039oo`03001o
ogoo009oo`83hVmoo`030n9oogoo02aoo`00KWoo00<3hWooOol0<goo00<007ooOol017oo00<3hWoo
Ool0K7oo00<3hWooOol0;7oo001]Ool00`?ROomoo`0dOol00`00Oomoo`05Ool20n9/Ool00`?ROomo
o`0/Ool006aoo`030n9oogoo03Eoo`03001oogoo00Moo`030n9oogoo06Qoo`030n9oogoo02eoo`00
Jgoo00<3hWooOol0=Woo00<007ooOol027oo00<3hWooOol0Igoo00<3hWooOol0;Goo001[Ool00`?R
Oomoo`0fOol2000:Ool20n9VOol00`?ROomoo`0^Ool006Yoo`030n9oogoo03Moo`03001oogoo00]o
o`030n9oogoo06=oo`030n9oogoo02ioo`00JGoo00<3hWooOol0>7oo00<007ooOol037oo00<3hWoo
Ool0HGoo00<3hWooOol0;goo001XOol00`?ROomoo`0iOol00`00Oomoo`0=Ool00`?ROomoo`1POol0
0`?ROomoo`0_Ool006Qoo`030n9oogoo03Uoo`03001oogoo00ioo`030n9oogoo05ioo`030n9oogoo
031oo`00Igoo00<3hWooOol0>Woo00<007ooOol03goo00<3hWooOol0GGoo00<3hWooOol0<7oo001V
Ool00`?ROomoo`0kOol00`00Oomoo`0@Ool00`?ROomoo`1KOol00`?ROomoo`0aOol006Ioo`030n9o
ogoo03]oo`03001oogoo015oo`83hUYoo`030n9oogoo039oo`00IGoo00<3hWooOol0?7oo00<007oo
Ool04goo00<3hWooOol0Egoo00<3hWooOol0<Woo001TOol00`?ROomoo`0mOol00`00Oomoo`0DOol0
0`?ROomoo`1EOol00`?ROomoo`0cOol006Aoo`030n9oogoo03eoo`8001Ioo`030n9oogoo05Aoo`03
0n9oogoo03=oo`00Hgoo00<3hWooOol0?Woo00<007ooOol05Woo00<3hWooOol0DWoo00<3hWooOol0
=7oo001SOol00`?ROomoo`0nOol00`00Oomoo`0GOol00`?ROomoo`1AOol00`?ROomoo`0dOol0069o
o`030n9oogoo03moo`03001oogoo01Qoo`030n9oogoo04moo`030n9oogoo03Eoo`00HWoo00<3hWoo
Ool0?goo00<007ooOol06Goo0P?RCWoo00<3hWooOol0=Woo001QOol00`?ROomoo`10Ool00`00Oomo
o`0KOol00`?ROomoo`1;Ool00`?ROomoo`0fOol0065oo`030n9oogoo041oo`03001oogoo01aoo`03
0n9oogoo04Uoo`030n9oogoo03Moo`00H7oo00<3hWooOol09goo10001Goo0P0017oo1@001Woo00<0
07ooOol07Goo0P?RB7oo00<3hWooOol0>7oo001POol00`?ROomoo`0VOol00`00Oomoo`02Ool00`00
Oomoo`02Ool20004Ool01@00Oomoogoo00001Woo00<007ooOol07goo00<3hWooOol0AGoo00<3hWoo
Ool0>7oo001OOol00`?ROomoo`0WOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`07Ool0
0`00Oomoo`0POol00`?ROomoo`13Ool00`?ROomoo`0iOol005moo`030n9oogoo02Moo`03001oogoo
009oo`03001oogoo00Yoo`03001oogoo00Ioo`<0025oo`83hT9oo`030n9oogoo03Yoo`00GWoo00<3
hWooOol0:7oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol01Goo00<007ooOol08goo00<3
hWooOol0?goo00<3hWooOol0>Woo001NOol00`?ROomoo`0XOol00`00Oomoo`02Ool00`00Oomoo`0<
Ool00`00Oomoo`04Ool00`00Oomoo`0TOol00`?ROomoo`0mOol00`?ROomoo`0kOol005eoo`030n9o
ogoo02Uoo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol00006Ool00`00Oomoo`0UOol0
0`?ROomoo`0kOol00`?ROomoo`0lOol005eoo`030n9oogoo02Yoo`@000aoo`<000Moo`03001oogoo
02Ioo`030n9oogoo03Uoo`030n9oogoo03eoo`00G7oo00<3hWooOol0AGoo00<007ooOol09goo0P?R
>7oo00<3hWooOol0?Woo001LOol00`?ROomoo`15Ool00`00Oomoo`0YOol00`?ROomoo`0dOol00`?R
Oomoo`0oOol005aoo`030n9oogoo04Eoo`03001oogoo02Yoo`030n9oogoo039oo`030n9oogoo041o
o`00Fgoo00<3hWooOol0AWoo00<007ooOol0:goo0P?R<Goo00<3hWooOol0@Goo001KOol00`?ROomo
o`16Ool00`00Oomoo`0]Ool20n8^Ool00`?ROomoo`12Ool005Yoo`030n9oogoo04Moo`80031oo`83
hR]oo`030n9oogoo04=oo`00FWoo00<3hWooOol0Agoo00<007ooOol0<Goo00<3hWooOol09goo00<3
hWooOol0A7oo001JOol00`?ROomoo`17Ool00`00Oomoo`0bOol20n8VOol00`?ROomoo`15Ool005Uo
o`030n9oogoo04Qoo`03001oogoo03Aoo`030n9oogoo025oo`83hTQoo`00FGoo00<3hWooOol0B7oo
00<007ooOol0=Goo0P?R7goo0P?RBWoo001HOol00`?ROomoo`19Ool00`00Oomoo`0gOol20n8KOol2
0n9<Ool005Qoo`030n9oogoo04Uoo`03001oogoo03Uoo`<3hQIoo`83hTioo`00F7oo00<3hWooOol0
BGoo00<007ooOol0?7oo0P?R4Woo0P?RD7oo001GOol00`?ROomoo`1:Ool00`00Oomoo`0nOol60n87
Ool50n9BOol005Moo`030n9oogoo04Yoo`8004Eoo`L3hUMoo`00Egoo00<3hWooOol0BWoo00<007oo
Ool0XWoo001FOol00`?ROomoo`1;Ool00`00Oomoo`2ROol005Ioo`030n9oogoo04]oo`03001oogoo
0:9oo`00EGoo00<3hWooOol0C7oo00<007ooOol0XWoo001EOol00`?ROomoo`1<Ool00`00Oomoo`2R
Ool005Eoo`030n9oogoo04aoo`03001oogoo0:9oo`00E7oo00<3hWooOol0CGoo00<007ooOol0XWoo
001DOol00`?ROomoo`1=Ool00`00Oomoo`2ROol005Aoo`030n9oogoo04eoo`03001oogoo0:9oo`00
Dgoo00<3hWooOol0CWoo0P00Xgoo001COol00`?ROomoo`1>Ool00`00Oomoo`2ROol005=oo`030n9o
ogoo04ioo`03001oogoo0:9oo`00DWoo00<3hWooOol0Cgoo00<007ooOol0XWoo001BOol00`?ROomo
o`1?Ool00`00Oomoo`2ROol0055oo`030n9oogoo051oo`03001oogoo0:9oo`00DGoo00<3hWooOol0
D7oo00<007ooOol0XWoo001AOol00`?ROomoo`0fOol40005Ool20007Ool30005Ool00`00Oomoo`2R
Ool0051oo`030n9oogoo03Ioo`03001oogoo009oo`03001oogoo009oo`8000Qoo`03001oogoo00Ao
o`03001oogoo0:9oo`00D7oo00<3hWooOol0=Woo00<007ooOol00Woo00<007ooOol037oo00<007oo
Ool017oo00<007ooOol0XWoo001@Ool00`?ROomoo`0fOol00`00Oomoo`02Ool00`00Oomoo`08Ool6
0005Ool3002ROol004moo`030n9oogoo03Moo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo
0006Ool00`00Oomoo`2ROol004moo`030n9oogoo03Moo`03001oogoo009oo`03001oogoo00Uoo`04
001oogoo0006Ool00`00Oomoo`2ROol004moo`030n9oogoo03Moo`03001oogoo009oo`03001oogoo
00Yoo`03001oo`0000Ioo`03001oogoo0:9oo`00CWoo00<3hWooOol0>Goo10003Woo0P001Woo00<0
07ooOol0XWoo001>Ool00`?ROomoo`1COol00`00Oomoo`2ROol004ioo`030n9oogoo05=oo`03001o
ogoo0:9oo`00CGoo00<3hWooOol0E7oo00<007ooOol0XWoo001=Ool00`?ROomoo`1DOol00`00Oomo
o`2ROol004aoo`030n9oogoo05Eoo`03001oogoo0:9oo`00C7oo00<3hWooOol0EGoo0P00Xgoo001<
Ool00`?ROomoo`1EOol00`00Oomoo`2ROol004]oo`030n9oogoo05Ioo`03001oogoo0:9oo`00Bgoo
00<3hWooOol0EWoo00<007ooOol0XWoo001;Ool00`?ROomoo`1FOol00`00Oomoo`2ROol004]oo`03
0n9oogoo05Ioo`03001oogoo0:9oo`00BWoo00<3hWooOol0Egoo00<007ooOol0XWoo001:Ool00`?R
Oomoo`1GOol00`00Oomoo`2ROol004Yoo`030n9oogoo05Moo`03001oogoo0:9oo`00BWoo00<3hWoo
Ool0Egoo00<007ooOol0XWoo0019Ool00`?ROomoo`1HOol2002SOol004Uoo`030n9oogoo05Qoo`03
001oogoo0:9oo`00BGoo00<3hWooOol0F7oo00<007ooOol0XWoo0019Ool00`?ROomoo`1HOol00`00
Oomoo`2ROol004Qoo`030n9oogoo05Uoo`03001oogoo0:9oo`00B7oo00<3hWooOol0FGoo00<007oo
Ool0XWoo0018Ool00`?ROomoo`1IOol00`00Oomoo`2ROol004Qoo`030n9oogoo05Uoo`03001oogoo
0:9oo`00B7oo00<3hWooOol0FGoo00<007ooOol0XWoo0017Ool00`?ROomoo`1JOol00`00Oomoo`2R
Ool004Moo`030n9oogoo05Yoo`800:=oo`00Agoo00<3hWooOol0FWoo00<007ooOol0XWoo0017Ool0
0`?ROomoo`1JOol00`00Oomoo`2ROol004Ioo`030n9oogoo05]oo`03001oogoo0:9oo`00AWoo00<3
hWooOol0Fgoo00<007ooOol0XWoo0016Ool00`?ROomoo`1KOol00`00Oomoo`2ROol004Ioo`030n9o
ogoo05]oo`03001oogoo0:9oo`00AGoo00<3hWooOol0G7oo00<007ooOol0XWoo0015Ool00`?ROomo
o`1LOol00`00Oomoo`2ROol004Eoo`030n9oogoo05aoo`03001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 .4 r
.5 Mabswid
.18922 .61803 m
.22272 .49693 L
.26171 .39227 L
.28302 .34867 L
.30316 .3155 L
.32313 .28977 L
.34157 .27187 L
.35059 .26503 L
.36029 .259 L
.37094 .25389 L
.38092 .25047 L
.38616 .24917 L
.39102 .24827 L
.39382 .24788 L
.39636 .2476 L
.39777 .24748 L
.39929 .24738 L
.40073 .2473 L
.40142 .24727 L
.40205 .24725 L
.40322 .24723 L
.40446 .24721 L
.40562 .24722 L
.40671 .24723 L
.40798 .24727 L
.40916 .24732 L
.41045 .24739 L
.41182 .24748 L
.41435 .24771 L
.41673 .24797 L
.42214 .2488 L
.42684 .24975 L
.43198 .25102 L
.44233 .2543 L
.46083 .26233 L
.48044 .27347 L
.50139 .28778 L
.54289 .32105 L
.58287 .35546 L
.62134 .38661 L
.64082 .40039 L
.66226 .4132 L
.67207 .41807 L
.68261 .42249 L
.6925 .42582 L
.70166 .42813 L
.70657 .42904 L
.70908 .42942 L
.71179 .42975 L
.71335 .42991 L
Mistroke
.71478 .43004 L
.71612 .43013 L
.71759 .43022 L
.71891 .43028 L
.72014 .43031 L
.72144 .43033 L
.72217 .43033 L
.72284 .43033 L
.72408 .43032 L
.72471 .4303 L
.72541 .43028 L
.72664 .43023 L
.72779 .43016 L
.73038 .42997 L
.73316 .42967 L
.73565 .42932 L
.73827 .42888 L
.74294 .42789 L
.75251 .42502 L
.75786 .42289 L
.76272 .42064 L
.7811 .4091 L
.79111 .40073 L
.80032 .39163 L
.82113 .36593 L
.83993 .33614 L
.86059 .29565 L
.90098 .19076 L
.93986 .05415 L
Mfstroke
.93986 .05415 m
.95193 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00SGoo00<3k7ooOol04Woo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0SGoo00<3k7oo
Ool04Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0SGoo
00<3k7ooOol04Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`2<Ool00`?/Oomoo`0COol008Yoo`@000ioo`8000Ioo`03001oogoo08aoo`030naoogoo01=oo`00
Y7oo00<007ooOol0S7oo00<3k7ooOol04goo002TOol00`00Oomoo`2<Ool00`?/Oomoo`0COol00:Ao
o`03001oogoo08]oo`030naoogoo01Aoo`00Y7oo00<007ooOol0Rgoo00<3k7ooOol057oo002TOol0
0`00Oomoo`2;Ool00`?/Oomoo`0DOol00:Aoo`8008aoo`030naoogoo01Aoo`00Y7oo00<007ooOol0
RWoo00<3k7ooOol05Goo002TOol00`00Oomoo`2:Ool00`?/Oomoo`0EOol00:Aoo`03001oogoo08Yo
o`030naoogoo01Eoo`00Y7oo00<007ooOol0RWoo00<3k7ooOol05Goo002TOol00`00Oomoo`29Ool0
0`?/Oomoo`0FOol00:Aoo`03001oogoo08Uoo`030naoogoo01Ioo`00Y7oo00<007ooOol0RGoo00<3
k7ooOol05Woo002TOol00`00Oomoo`29Ool00`?/Oomoo`0FOol00:Aoo`8008Uoo`030naoogoo01Mo
o`00Y7oo00<007ooOol0R7oo00<3k7ooOol05goo002TOol00`00Oomoo`28Ool00`?/Oomoo`0GOol0
0:Aoo`03001oogoo08Moo`030naoogoo01Qoo`00Y7oo00<007ooOol0Qgoo00<3k7ooOol067oo002T
Ool00`00Oomoo`27Ool00`?/Oomoo`0HOol00:Aoo`03001oogoo08Moo`030naoogoo01Qoo`00Y7oo
00<007ooOol0QWoo00<3k7ooOol06Goo002TOol00`00Oomoo`26Ool00`?/Oomoo`0IOol00:Aoo`03
001oogoo08Ioo`030naoogoo01Uoo`00Y7oo0P00QWoo00<3k7ooOol06Woo002TOol00`00Oomoo`25
Ool00`?/Oomoo`0JOol00:Aoo`03001oogoo08Eoo`030naoogoo01Yoo`00Y7oo00<007ooOol0Q7oo
00<3k7ooOol06goo002TOol00`00Oomoo`24Ool00`?/Oomoo`0KOol00:Aoo`03001oogoo08Aoo`03
0naoogoo01]oo`00Y7oo00<007ooOol0Q7oo00<3k7ooOol06goo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`23Ool00`?/Oomoo`0LOol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`23Ool00`?/Oomoo`0LOol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo08=oo`030naoogoo01aoo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00PWoo00<3k7ooOol07Goo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`22Ool00`?/Oomoo`0MOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo089oo`030naoogoo01eo
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo085oo`03
0naoogoo01ioo`00RWoo100037oo0`001goo00<007ooOol0PGoo00<3k7ooOol07Woo002TOol00`00
Oomoo`21Ool00`?/Oomoo`0NOol00:Aoo`03001oogoo085oo`030naoogoo01ioo`00Y7oo00<007oo
Ool0P7oo00<3k7ooOol07goo002TOol00`00Oomoo`20Ool00`?/Oomoo`0OOol00:Aoo`03001oogoo
081oo`030naoogoo01moo`00Y7oo0P00P7oo00<3k7ooOol087oo002TOol00`00Oomoo`1oOol00`?/
Oomoo`0POol00:Aoo`03001oogoo07moo`030naoogoo021oo`00Y7oo00<007ooOol0OWoo00<3k7oo
Ool08Goo002TOol00`00Oomoo`1nOol00`?/Oomoo`0QOol00:Aoo`03001oogoo07ioo`030naoogoo
025oo`00Y7oo00<007ooOol0OWoo00<3k7ooOol08Goo002TOol00`00Oomoo`1mOol00`?/Oomoo`0R
Ool00:Aoo`03001oogoo07eoo`030naoogoo029oo`00Y7oo00<007ooOol0OGoo00<3k7ooOol08Woo
002TOol2001mOol00`?/Oomoo`0SOol00:Aoo`03001oogoo07aoo`030naoogoo02=oo`00Y7oo00<0
07ooOol0O7oo00<3k7ooOol08goo002TOol00`00Oomoo`1kOol00`?/Oomoo`0TOol000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D0031oo`030naoogoo01=oo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo02moo`030naoogoo01Aoo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo02mo
o`030naoogoo01Eoo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol0;goo00<3k7ooOol05Woo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0^Ool00`?/Oomoo`0HOol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
02ioo`030naoogoo01Uoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<0031oo`030naoogoo01Eoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo02eoo`030naoogoo01Moo`<000eoo`00Y7oo00<007ooOol0N7oo00<3
k7ooOol09goo002TOol00`00Oomoo`1gOol00`?/Oomoo`0XOol00:Aoo`03001oogoo07Moo`030nao
ogoo02Qoo`00Y7oo00<007ooOol0Mgoo00<3k7ooOol0:7oo002TOol00`00Oomoo`1fOol00`?/Oomo
o`0YOol00:Aoo`03001oogoo07Ioo`030naoogoo02Uoo`00Y7oo00<007ooOol0MGoo00<3k7ooOol0
:Woo0004Oomo00060nbC00000`?/0000000U0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00Eoo`H3k004Ool007ooOol50n`7Ool00`00Oomoo`0=Ool00`00Oomoo`0<Ool00`00
Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0=Ool00`00
Oomoo`0<Ool00`00Oomoo`0;Ool00`?/001oo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool000ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00=oo`83k0Moo`03001oogoo00Eoo`<3k0Ao
o`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00Yoo`030naoo`0000io
o`03001oogoo00aoo`03001oogoo00]oo`00NWoo0P?/57oo0`?/4Goo00<007ooOol0M7oo00<3k7oo
Ool0:goo001gOol30n`IOol30n`>Ool00`00Oomoo`1dOol00`?/Oomoo`0[Ool007Eoo`83k1moo`83
k0aoo`03001oogoo07=oo`030naoogoo02aoo`00M7oo00<3k7ooOol08Goo0P?/2Woo00<007ooOol0
Lgoo00<3k7ooOol0;7oo001bOol20n`VOol00`?/Oomoo`07Ool00`00Oomoo`1bOol00`?/Oomoo`0]
Ool0075oo`030naoogoo02Moo`83k0Moo`03001oogoo079oo`030naoogoo02eoo`00L7oo00<3k7oo
Ool0:Woo00<3k7ooOol017oo00<007ooOol0LWoo00<3k7ooOol0;Goo001_Ool00`?/Oomoo`0/Ool2
0n`4Ool2001bOol00`?/Oomoo`0^Ool006ioo`030naoogoo02moo`83k09oo`03001oogoo075oo`03
0naoogoo02ioo`00KGoo00<3k7ooOol0<Woo0P?/00<007ooOol0LGoo00<3k7ooOol0;Woo001/Ool0
0`?/Oomoo`0eOol00`?/Oomoo`1`Ool00`?/Oomoo`0_Ool006]oo`030naoogoo03Ioo`030003k7oo
071oo`030naoogoo02moo`00JWoo00<3k7ooOol0=goo00<007oo0n`0Kgoo00<3k7ooOol0<7oo001Y
Ool00`?/Oomoo`0hOol00`00Oomoo`020na]Ool00`?/Oomoo`0`Ool006Uoo`030naoogoo03Qoo`03
001oogoo009oo`030naoogoo06Yoo`030naoogoo031oo`00J7oo00<3k7ooOol0>Goo00<007ooOol0
0goo00<3k7ooOol0J7oo00<3k7ooOol0<Goo001WOol00`?/Oomoo`0jOol00`00Oomoo`04Ool00`?/
Oomoo`1WOol00`?/Oomoo`0aOol006Ioo`030naoogoo03]oo`8000Ioo`030naoogoo06Eoo`030nao
ogoo039oo`00IWoo00<3k7ooOol0>goo00<007ooOol01Woo0P?/IGoo00<3k7ooOol0<Woo001UOol0
0`?/Oomoo`0lOol00`00Oomoo`08Ool00`?/Oomoo`1QOol00`?/Oomoo`0cOol006Aoo`030naoogoo
03eoo`03001oogoo00Uoo`030naoogoo061oo`030naoogoo03=oo`00I7oo00<3k7ooOol0?Goo00<0
07ooOol02Woo00<3k7ooOol0GWoo00<3k7ooOol0=7oo001SOol00`?/Oomoo`0nOol00`00Oomoo`0;
Ool00`?/Oomoo`1MOol00`?/Oomoo`0dOol006=oo`030naoogoo03ioo`03001oogoo00aoo`030nao
ogoo05]oo`030naoogoo03Eoo`00HWoo00<3k7ooOol0?goo00<007ooOol03Goo0P?/Fgoo00<3k7oo
Ool0=Goo001ROol00`?/Oomoo`0oOol00`00Oomoo`0?Ool00`?/Oomoo`1GOol00`?/Oomoo`0fOol0
065oo`030naoogoo041oo`03001oogoo011oo`030naoogoo05Ioo`030naoogoo03Ioo`00HGoo00<3
k7ooOol0@7oo0P004Woo00<3k7ooOol0E7oo00<3k7ooOol0=goo001POol00`?/Oomoo`11Ool00`00
Oomoo`0BOol00`?/Oomoo`1COol00`?/Oomoo`0gOol0061oo`030naoogoo045oo`03001oogoo01=o
o`83k59oo`030naoogoo03Qoo`00Ggoo00<3k7ooOol0@Woo00<007ooOol05Goo00<3k7ooOol0CWoo
00<3k7ooOol0>Goo001NOol00`?/Oomoo`13Ool00`00Oomoo`0FOol00`?/Oomoo`1=Ool00`?/Oomo
o`0iOol005ioo`030naoogoo04=oo`03001oogoo01Moo`030naoogoo04]oo`030naoogoo03Yoo`00
GGoo00<3k7ooOol0A7oo00<007ooOol067oo00<3k7ooOol0BGoo00<3k7ooOol0>goo001MOol00`?/
Oomoo`0ZOol40005Ool20004Ool50006Ool00`00Oomoo`0IOol00`?/Oomoo`18Ool00`?/Oomoo`0k
Ool005aoo`030naoogoo02Yoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol0
0006Ool00`00Oomoo`0JOol20na7Ool00`?/Oomoo`0lOol005aoo`030naoogoo02Yoo`03001oogoo
009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo01aoo`030naoogoo04=oo`030naoogoo
03eoo`00Fgoo00<3k7ooOol0:goo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00
7Goo00<3k7ooOol0@Goo00<3k7ooOol0?Woo001KOol00`?/Oomoo`0[Ool00`00Oomoo`02Ool00`00
Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`0NOol00`?/Oomoo`0oOol00`?/Oomoo`0oOol005Yo
o`030naoogoo02aoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo01mo
o`030naoogoo03eoo`030naoogoo041oo`00FWoo00<3k7ooOol0;7oo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`0000Ioo`03001oogoo021oo`83k3eoo`030naoogoo041oo`00FGoo00<3
k7ooOol0;Woo100037oo0`001goo00<007ooOol08Woo00<3k7ooOol0>Goo00<3k7ooOol0@Goo001I
Ool00`?/Oomoo`18Ool00`00Oomoo`0SOol00`?/Oomoo`0gOol00`?/Oomoo`12Ool005Qoo`030nao
ogoo04Uoo`03001oogoo02Aoo`83k3Ioo`030naoogoo04=oo`00F7oo00<3k7ooOol0BGoo00<007oo
Ool09Woo00<3k7ooOol0<Woo00<3k7ooOol0A7oo001HOol00`?/Oomoo`19Ool00`00Oomoo`0WOol2
0n`aOol00`?/Oomoo`15Ool005Moo`030naoogoo04Yoo`03001oogoo02Uoo`030naoogoo02eoo`03
0naoogoo04Ioo`00Egoo00<3k7ooOol0BWoo0P00:goo0P?/;7oo00<3k7ooOol0Agoo001FOol00`?/
Oomoo`1;Ool00`00Oomoo`0/Ool20n`YOol00`?/Oomoo`18Ool005Ioo`030naoogoo04]oo`03001o
ogoo02ioo`83k2Ioo`030naoogoo04Uoo`00EWoo00<3k7ooOol0Bgoo00<007ooOol0<7oo00<3k7oo
Ool08Goo0P?/C7oo001EOol00`?/Oomoo`1<Ool00`00Oomoo`0aOol20n`POol00`?/Oomoo`1<Ool0
05Eoo`030naoogoo04aoo`03001oogoo03=oo`83k1aoo`83k4moo`00E7oo00<3k7ooOol0CGoo00<0
07ooOol0=Goo10?/5Woo0P?/DGoo001DOol00`?/Oomoo`1=Ool00`00Oomoo`0iOol30n`@Ool30naC
Ool005Aoo`030naoogoo04eoo`03001oogoo03aoo`@3k0Qoo`@3k5Ioo`00Dgoo00<3k7ooOol0CWoo
0P00@Goo20?/FWoo001COol00`?/Oomoo`1>Ool00`00Oomoo`2ROol0059oo`030naoogoo04moo`03
001oogoo0:9oo`00DWoo00<3k7ooOol0Cgoo00<007ooOol0XWoo001BOol00`?/Oomoo`1?Ool00`00
Oomoo`2ROol0055oo`030naoogoo051oo`03001oogoo0:9oo`00DGoo00<3k7ooOol0D7oo00<007oo
Ool0XWoo001AOol00`?/Oomoo`1@Ool00`00Oomoo`2ROol0051oo`030naoogoo055oo`03001oogoo
0:9oo`00D7oo00<3k7ooOol0DGoo00<007ooOol0XWoo001?Ool00`?/Oomoo`1BOol2002SOol004mo
o`030naoogoo059oo`03001oogoo0:9oo`00Cgoo00<3k7ooOol0DWoo00<007ooOol0XWoo001>Ool0
0`?/Oomoo`1COol00`00Oomoo`2ROol004ioo`030naoogoo05=oo`03001oogoo0:9oo`00CGoo00<3
k7ooOol0E7oo00<007ooOol0XWoo001=Ool00`?/Oomoo`1DOol00`00Oomoo`2ROol004eoo`030nao
ogoo03Yoo`@000Eoo`8000Moo`<000Eoo`03001oogoo0:9oo`00C7oo00<3k7ooOol0>Woo00<007oo
Ool00Woo00<007ooOol00Woo0P0027oo00<007ooOol017oo00<007ooOol0XWoo001<Ool00`?/Oomo
o`0jOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`2ROol004]oo`03
0naoogoo03]oo`03001oogoo009oo`03001oogoo00Qoo`H000Eoo`<00:9oo`00Bgoo00<3k7ooOol0
>goo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo0:9oo`00Bgoo00<3
k7ooOol0>goo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo0:9oo`00
BWoo00<3k7ooOol0?7oo00<007ooOol00Woo00<007ooOol02Woo00<007oo00001Woo00<007ooOol0
XWoo001:Ool00`?/Oomoo`0mOol4000>Ool20006Ool00`00Oomoo`2ROol004Yoo`030naoogoo05Mo
o`03001oogoo0:9oo`00BWoo00<3k7ooOol0Egoo00<007ooOol0XWoo0019Ool00`?/Oomoo`1HOol0
0`00Oomoo`2ROol004Uoo`030naoogoo05Qoo`03001oogoo0:9oo`00BGoo00<3k7ooOol0F7oo00<0
07ooOol0XWoo0019Ool00`?/Oomoo`1HOol2002SOol004Qoo`030naoogoo05Uoo`03001oogoo0:9o
o`00B7oo00<3k7ooOol0FGoo00<007ooOol0XWoo0018Ool00`?/Oomoo`1IOol00`00Oomoo`2ROol0
04Qoo`030naoogoo05Uoo`03001oogoo0:9oo`00Agoo00<3k7ooOol0FWoo00<007ooOol0XWoo0017
Ool00`?/Oomoo`1JOol00`00Oomoo`2ROol004Moo`030naoogoo05Yoo`03001oogoo0:9oo`00Agoo
00<3k7ooOol0FWoo00<007ooOol0XWoo0016Ool00`?/Oomoo`1KOol00`00Oomoo`2ROol004Ioo`03
0naoogoo05]oo`800:=oo`00AWoo00<3k7ooOol0Fgoo00<007ooOol0XWoo0015Ool00`?/Oomoo`1L
Ool00`00Oomoo`2ROol004Eoo`030naoogoo05aoo`03001oogoo0:9oo`00AGoo00<3k7ooOol0G7oo
00<007ooOol0XWoo0015Ool00`?/Oomoo`1LOol00`00Oomoo`2ROol004Aoo`030naoogoo05eoo`03
001oogoo0:9oo`00A7oo00<3k7ooOol0GGoo00<007ooOol0XWoo0014Ool00`?/Oomoo`1MOol00`00
Oomoo`2ROol004Aoo`030naoogoo05eoo`03001oogoo0:9oo`00@goo00<3k7ooOol0GWoo0P00Xgoo
0013Ool00`?/Oomoo`1NOol00`00Oomoo`2ROol004=oo`030naoogoo05ioo`03001oogoo0:9oo`00
@goo00<3k7ooOol0GWoo00<007ooOol0XWoo0012Ool00`?/Oomoo`1OOol00`00Oomoo`2ROol0049o
o`030naoogoo05moo`03001oogoo0:9oo`00@Woo00<3k7ooOol0Ggoo00<007ooOol0XWoo0012Ool0
0`?/Oomoo`1OOol00`00Oomoo`2ROol0045oo`030naoogoo061oo`03001oogoo0:9oo`00@Goo00<3
k7ooOol0H7oo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 .7 r
.5 Mabswid
.17713 .61803 m
.18221 .59609 L
.22272 .46139 L
.26171 .36679 L
.28302 .32815 L
.30316 .29934 L
.32313 .2776 L
.34157 .2631 L
.35124 .25748 L
.36029 .25339 L
.36539 .25156 L
.37023 .25014 L
.37581 .24885 L
.37844 .24838 L
.38092 .24801 L
.38334 .24772 L
.38461 .24759 L
.38595 .24748 L
.38708 .2474 L
.38832 .24733 L
.38945 .24728 L
.39051 .24724 L
.39114 .24723 L
.39183 .24722 L
.39309 .24721 L
.39431 .24723 L
.39544 .24725 L
.39666 .24729 L
.398 .24736 L
.39941 .24744 L
.40073 .24755 L
.40534 .24804 L
.40957 .24868 L
.41422 .24959 L
.41911 .25076 L
.42866 .25367 L
.43885 .25763 L
.45722 .26674 L
.49872 .29472 L
.5387 .32765 L
.57717 .36072 L
.61809 .39295 L
.63844 .40643 L
.65749 .41681 L
.67575 .4243 L
.68101 .42594 L
.68601 .42728 L
.69084 .42835 L
.69538 .42916 L
.6978 .4295 L
Mistroke
.70042 .42981 L
.7028 .43003 L
.70499 .43018 L
.70622 .43024 L
.70736 .43029 L
.70862 .43032 L
.70933 .43033 L
.70997 .43033 L
.71126 .43033 L
.71199 .43032 L
.71267 .4303 L
.71391 .43026 L
.71522 .4302 L
.7174 .43006 L
.71974 .42984 L
.72397 .42929 L
.72643 .42887 L
.72901 .42836 L
.73362 .42723 L
.74319 .42404 L
.7534 .4193 L
.76304 .41351 L
.77178 .40708 L
.79101 .38883 L
.81182 .36221 L
.83173 .32949 L
.85279 .28659 L
.89073 .1857 L
.93112 .04135 L
Mfstroke
.93112 .04135 m
.9401 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00RGoo00<3mGooOol05Woo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0RGoo00<3mGoo
Ool05Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0RGoo
00<3mGooOol05Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`28Ool00`?eOomoo`0GOol008Yoo`@000ioo`8000Ioo`03001oogoo08Qoo`030oEoogoo01Moo`00
Y7oo00<007ooOol0R7oo00<3mGooOol05goo002TOol00`00Oomoo`28Ool00`?eOomoo`0GOol00:Ao
o`03001oogoo08Moo`030oEoogoo01Qoo`00Y7oo00<007ooOol0Qgoo00<3mGooOol067oo002TOol0
0`00Oomoo`27Ool00`?eOomoo`0HOol00:Aoo`8008Qoo`030oEoogoo01Qoo`00Y7oo00<007ooOol0
QWoo00<3mGooOol06Goo002TOol00`00Oomoo`26Ool00`?eOomoo`0IOol00:Aoo`03001oogoo08Io
o`030oEoogoo01Uoo`00Y7oo00<007ooOol0QWoo00<3mGooOol06Goo002TOol00`00Oomoo`25Ool0
0`?eOomoo`0JOol00:Aoo`03001oogoo08Eoo`030oEoogoo01Yoo`00Y7oo00<007ooOol0QGoo00<3
mGooOol06Woo002TOol00`00Oomoo`25Ool00`?eOomoo`0JOol00:Aoo`8008Eoo`030oEoogoo01]o
o`00Y7oo00<007ooOol0Q7oo00<3mGooOol06goo002TOol00`00Oomoo`24Ool00`?eOomoo`0KOol0
0:Aoo`03001oogoo08=oo`030oEoogoo01aoo`00Y7oo00<007ooOol0Pgoo00<3mGooOol077oo002T
Ool00`00Oomoo`23Ool00`?eOomoo`0LOol00:Aoo`03001oogoo08=oo`030oEoogoo01aoo`00Y7oo
00<007ooOol0PWoo00<3mGooOol07Goo002TOol00`00Oomoo`22Ool00`?eOomoo`0MOol00:Aoo`03
001oogoo089oo`030oEoogoo01eoo`00Y7oo0P00PWoo00<3mGooOol07Woo002TOol00`00Oomoo`21
Ool00`?eOomoo`0NOol00:Aoo`03001oogoo085oo`030oEoogoo01ioo`00Y7oo00<007ooOol0PGoo
00<3mGooOol07Woo002TOol00`00Oomoo`20Ool00`?eOomoo`0OOol00:Aoo`03001oogoo081oo`03
0oEoogoo01moo`00Y7oo00<007ooOol0P7oo00<3mGooOol07goo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1oOol00`?eOomoo`0POol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1oOol00`?eOomoo`0POol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo07moo`030oEoogoo021oo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00Ogoo00<3mGooOol087oo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1nOol00`?eOomoo`0QOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo07ioo`030oEoogoo025o
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo07ioo`03
0oEoogoo025oo`00RWoo100037oo0`001goo00<007ooOol0OWoo00<3mGooOol08Goo002TOol00`00
Oomoo`1mOol00`?eOomoo`0ROol00:Aoo`03001oogoo07eoo`030oEoogoo029oo`00Y7oo00<007oo
Ool0OGoo00<3mGooOol08Woo002TOol00`00Oomoo`1lOol00`?eOomoo`0SOol00:Aoo`03001oogoo
07aoo`030oEoogoo02=oo`00Y7oo0P00OGoo00<3mGooOol08goo002TOol00`00Oomoo`1lOol00`?e
Oomoo`0SOol00:Aoo`03001oogoo07]oo`030oEoogoo02Aoo`00Y7oo00<007ooOol0Ngoo00<3mGoo
Ool097oo002TOol00`00Oomoo`1kOol00`?eOomoo`0TOol00:Aoo`03001oogoo07Yoo`030oEoogoo
02Eoo`00Y7oo00<007ooOol0NWoo00<3mGooOol09Goo002TOol00`00Oomoo`1jOol00`?eOomoo`0U
Ool00:Aoo`03001oogoo07Yoo`030oEoogoo02Eoo`00Y7oo00<007ooOol0NGoo00<3mGooOol09Woo
002TOol2001jOol00`?eOomoo`0VOol00:Aoo`03001oogoo07Uoo`030oEoogoo02Ioo`00Y7oo00<0
07ooOol0N7oo00<3mGooOol09goo002TOol00`00Oomoo`1hOol00`?eOomoo`0WOol000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D002aoo`030oEoogoo01Moo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo02aoo`030oEoogoo01Moo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo02ao
o`030oEoogoo01Qoo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol0:goo00<3mGooOol06Woo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0[Ool00`?eOomoo`0KOol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
02]oo`030oEoogoo01aoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<002aoo`030oEoogoo01Uoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo02Yoo`030oEoogoo01Yoo`<000eoo`00Y7oo00<007ooOol0M7oo00<3
mGooOol0:goo002TOol00`00Oomoo`1dOol00`?eOomoo`0[Ool00:Aoo`03001oogoo07Aoo`030oEo
ogoo02]oo`00Y7oo00<007ooOol0Lgoo00<3mGooOol0;7oo002TOol00`00Oomoo`1cOol00`?eOomo
o`0/Ool00:Aoo`03001oogoo07=oo`030oEoogoo02aoo`00Y7oo00<007ooOol0LWoo00<3mGooOol0
;Goo0004Oomk00060oFD00000`?e0000000X0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`04001oogooOol60oD4Ool50oD;Ool00`00Oomoo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool0
0`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0=Ool00`00Oomoo`0<Ool0
0`00Oomoo`07Ool00`?eOomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool0
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00aoo`040003m@?e0oD;Ool01000Oomoogoo1@?e1Woo00<0
07ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol01goo00<3mGooOol00Woo00<0
07ooOol037oo00<007ooOol037oo00<007ooOol02goo001eOol20oDGOol20oDDOol00`00Oomoo`1a
Ool00`?eOomoo`0^Ool007=oo`83mA]oo`030oEoogoo015oo`03001oogoo071oo`030oEoogoo02mo
o`00LGoo0P?e7Woo0P?e4Goo00<007ooOol0L7oo00<3mGooOol0;goo001`Ool00`?eOomoo`0POol2
0oD?Ool00`00Oomoo`1`Ool00`?eOomoo`0_Ool006moo`030oEoogoo02=oo`83m@eoo`03001oogoo
06moo`030oEoogoo031oo`00KGoo0P?e:7oo0P?e2goo00<007ooOol0Kgoo00<3mGooOol0<7oo001/
Ool00`?eOomoo`0ZOol00`?eOomoo`08Ool00`00Oomoo`1^Ool00`?eOomoo`0aOol006]oo`030oEo
ogoo02aoo`83m@Qoo`8006moo`030oEoogoo035oo`00JWoo00<3mGooOol0;goo00<3mGooOol01Goo
00<007ooOol0KWoo00<3mGooOol0<Goo001YOol00`?eOomoo`0aOol00`?eOomoo`04Ool00`00Oomo
o`1]Ool00`?eOomoo`0bOol006Qoo`030oEoogoo03=oo`83m@Aoo`03001oogoo06eoo`030oEoogoo
039oo`00J7oo00<3mGooOol0=Goo00D3mGooOomoo`0006ioo`030oEoogoo03=oo`00Igoo00<3mGoo
Ool0=goo0P?e00=oo`00Ool0KGoo00<3mGooOol0<goo001VOol00`?eOomoo`0jOol00`?e001oo`1/
Ool00`?eOomoo`0dOol006Eoo`030oEoogoo03aoo`030oEoogoo06]oo`030oEoogoo03Aoo`00I7oo
00<3mGooOol0?Goo00<000?e0oD0JWoo00<3mGooOol0=Goo001TOol00`?eOomoo`0mOol01000Oomo
o`?eJGoo00<3mGooOol0=Goo001SOol00`?eOomoo`0nOol20002Ool00`?eOomoo`1UOol00`?eOomo
o`0fOol0069oo`030oEoogoo03moo`03001oogoo009oo`83mFEoo`030oEoogoo03Ioo`00HWoo00<3
mGooOol0?goo00<007ooOol017oo00<3mGooOol0HGoo00<3mGooOol0=goo001QOol00`?eOomoo`10
Ool00`00Oomoo`05Ool00`?eOomoo`1POol00`?eOomoo`0gOol0061oo`030oEoogoo045oo`03001o
ogoo00Ioo`83mEmoo`030oEoogoo03Qoo`00H7oo00<3mGooOol0@Goo00<007ooOol027oo00<3mGoo
Ool0G7oo00<3mGooOol0>7oo001OOol00`?eOomoo`12Ool00`00Oomoo`09Ool00`?eOomoo`1JOol0
0`?eOomoo`0iOol005ioo`030oEoogoo04=oo`03001oogoo00Yoo`030oEoogoo05Uoo`030oEoogoo
03Uoo`00GWoo00<3mGooOol0@goo00<007ooOol02goo00<3mGooOol0Egoo00<3mGooOol0>Woo001M
Ool00`?eOomoo`14Ool00`00Oomoo`0<Ool00`?eOomoo`1FOol00`?eOomoo`0jOol005eoo`030oEo
ogoo04Aoo`8000ioo`030oEoogoo05Aoo`030oEoogoo03]oo`00G7oo00<3mGooOol0AGoo00<007oo
Ool03Woo00<3mGooOol0Dgoo00<3mGooOol0>goo001KOol00`?eOomoo`16Ool00`00Oomoo`0?Ool2
0oEBOol00`?eOomoo`0lOol005]oo`030oEoogoo04Ioo`03001oogoo015oo`030oEoogoo04ioo`03
0oEoogoo03eoo`00FWoo00<3mGooOol0Agoo00<007ooOol04Woo00<3mGooOol0CGoo00<3mGooOol0
?Goo001JOol00`?eOomoo`17Ool00`00Oomoo`0COol00`?eOomoo`1;Ool00`?eOomoo`0nOol005Uo
o`030oEoogoo04Qoo`03001oogoo01Aoo`030oEoogoo04Yoo`030oEoogoo03ioo`00FGoo00<3mGoo
Ool0;Woo10001Goo0P0017oo1@001Woo00<007ooOol05Goo00<3mGooOol0B7oo00<3mGooOol0?goo
001HOol00`?eOomoo`0^Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo0000
1Woo00<007ooOol05Woo00<3mGooOol0AWoo00<3mGooOol0@7oo001HOol00`?eOomoo`0^Ool00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`0GOol20oE5Ool00`?eOomoo`11
Ool005Moo`030oEoogoo02moo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo00Ioo`<001Uo
o`030oEoogoo049oo`030oEoogoo045oo`00Egoo00<3mGooOol0;goo00<007ooOol00Woo00<007oo
Ool02goo00<007ooOol01Goo00<007ooOol06Woo00<3mGooOol0@7oo00<3mGooOol0@Woo001FOol0
0`?eOomoo`0`Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`0KOol2
0oDoOol00`?eOomoo`13Ool005Ioo`030oEoogoo031oo`03001oogoo009oo`03001oogoo00Qoo`05
001oogooOol00006Ool00`00Oomoo`0MOol00`?eOomoo`0kOol00`?eOomoo`14Ool005Eoo`030oEo
ogoo039oo`@000aoo`<000Moo`03001oogoo01ioo`030oEoogoo03Yoo`030oEoogoo04Aoo`00EGoo
00<3mGooOol0C7oo00<007ooOol07goo0P?e>Goo00<3mGooOol0AGoo001EOol00`?eOomoo`1<Ool0
0`00Oomoo`0QOol00`?eOomoo`0eOol00`?eOomoo`16Ool005Aoo`030oEoogoo04eoo`03001oogoo
029oo`030oEoogoo03=oo`030oEoogoo04Moo`00E7oo00<3mGooOol0CGoo00<007ooOol08goo0P?e
<Woo00<3mGooOol0B7oo001COol00`?eOomoo`1>Ool00`00Oomoo`0UOol20oD^Ool20oE;Ool005=o
o`030oEoogoo04ioo`8002Qoo`83mB]oo`030oEoogoo04]oo`00Dgoo00<3mGooOol0CWoo00<007oo
Ool0:Goo00<3mGooOol09goo00<3mGooOol0C7oo001BOol00`?eOomoo`1?Ool00`00Oomoo`0ZOol2
0oDUOol20oE?Ool0059oo`030oEoogoo04moo`03001oogoo02aoo`83mB9oo`030oEoogoo04moo`00
DGoo00<3mGooOol0D7oo00<007ooOol0;Woo0P?e7Woo0P?eDWoo001AOol00`?eOomoo`1@Ool00`00
Oomoo`0`Ool20oDKOol00`?eOomoo`1BOol0051oo`030oEoogoo055oo`03001oogoo039oo`83mAMo
o`83mEEoo`00D7oo00<3mGooOol0DGoo00<007ooOol0=7oo0`?e4Woo0P?eEgoo001@Ool00`?eOomo
o`1AOol00`00Oomoo`0gOol60oD7Ool50oEIOol004moo`030oEoogoo059oo`8003eoo`P3mEioo`00
Cgoo00<3mGooOol0DWoo00<007ooOol0XWoo001>Ool00`?eOomoo`1COol00`00Oomoo`2ROol004io
o`030oEoogoo05=oo`03001oogoo0:9oo`00CWoo00<3mGooOol0Dgoo00<007ooOol0XWoo001=Ool0
0`?eOomoo`1DOol00`00Oomoo`2ROol004eoo`030oEoogoo05Aoo`03001oogoo0:9oo`00C7oo00<3
mGooOol0EGoo00<007ooOol0XWoo001<Ool00`?eOomoo`1EOol00`00Oomoo`2ROol004]oo`030oEo
ogoo05Ioo`03001oogoo0:9oo`00Bgoo00<3mGooOol0EWoo0P00Xgoo001;Ool00`?eOomoo`1FOol0
0`00Oomoo`2ROol004Yoo`030oEoogoo05Moo`03001oogoo0:9oo`00BWoo00<3mGooOol0Egoo00<0
07ooOol0XWoo001:Ool00`?eOomoo`1GOol00`00Oomoo`2ROol004Uoo`030oEoogoo05Qoo`03001o
ogoo0:9oo`00BGoo00<3mGooOol0F7oo00<007ooOol0XWoo0019Ool00`?eOomoo`0nOol40005Ool2
0007Ool30005Ool00`00Oomoo`2ROol004Uoo`030oEoogoo03eoo`03001oogoo009oo`03001oogoo
009oo`8000Qoo`03001oogoo00Aoo`03001oogoo0:9oo`00B7oo00<3mGooOol0?Woo00<007ooOol0
0Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol0XWoo0018Ool00`?eOomoo`0nOol00`00
Oomoo`02Ool00`00Oomoo`08Ool60005Ool3002ROol004Qoo`030oEoogoo03ioo`03001oogoo009o
o`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol004Moo`030oEoogoo03moo`03001o
ogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol004Moo`030oEoogoo03mo
o`03001oogoo009oo`03001oogoo00Yoo`03001oo`0000Ioo`03001oogoo0:9oo`00Agoo00<3mGoo
Ool0@7oo10003Woo0P001Woo00<007ooOol0XWoo0016Ool00`?eOomoo`1KOol00`00Oomoo`2ROol0
04Ioo`030oEoogoo05]oo`03001oogoo0:9oo`00AWoo00<3mGooOol0Fgoo00<007ooOol0XWoo0016
Ool00`?eOomoo`1KOol00`00Oomoo`2ROol004Eoo`030oEoogoo05aoo`03001oogoo0:9oo`00AGoo
00<3mGooOol0G7oo0P00Xgoo0015Ool00`?eOomoo`1LOol00`00Oomoo`2ROol004Aoo`030oEoogoo
05eoo`03001oogoo0:9oo`00A7oo00<3mGooOol0GGoo00<007ooOol0XWoo0014Ool00`?eOomoo`1M
Ool00`00Oomoo`2ROol004=oo`030oEoogoo05ioo`03001oogoo0:9oo`00@goo00<3mGooOol0GWoo
00<007ooOol0XWoo0013Ool00`?eOomoo`1NOol00`00Oomoo`2ROol004=oo`030oEoogoo05ioo`03
001oogoo0:9oo`00@Woo00<3mGooOol0Ggoo00<007ooOol0XWoo0012Ool00`?eOomoo`1OOol2002S
Ool0049oo`030oEoogoo05moo`03001oogoo0:9oo`00@Goo00<3mGooOol0H7oo00<007ooOol0XWoo
0011Ool00`?eOomoo`1POol00`00Oomoo`2ROol0045oo`030oEoogoo061oo`03001oogoo0:9oo`00
@7oo00<3mGooOol0HGoo00<007ooOol0XWoo0010Ool00`?eOomoo`1QOol00`00Oomoo`2ROol0041o
o`030oEoogoo065oo`03001oogoo0:9oo`00@7oo00<3mGooOol0HGoo00<007ooOol0XWoo000oOol0
0`?eOomoo`1ROol00`00Oomoo`2ROol003moo`030oEoogoo069oo`800:=oo`00?goo00<3mGooOol0
HWoo00<007ooOol0XWoo000nOol00`?eOomoo`1SOol00`00Oomoo`2ROol003ioo`030oEoogoo06=o
o`03001oogoo0:9oo`00?Woo00<3mGooOol0Hgoo00<007ooOol0XWoo000nOol00`?eOomoo`1SOol0
0`00Oomoo`2ROol003eoo`030oEoogoo06Aoo`03001oogoo0:9oo`00?Goo00<3mGooOol0I7oo00<0
07ooOol0XWoo000mOol00`?eOomoo`1TOol00`00Oomoo`2ROol003eoo`030oEoogoo06Aoo`03001o
ogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 1 r
.5 Mabswid
.16583 .61803 m
.18221 .55239 L
.22272 .42905 L
.26171 .34413 L
.28302 .31025 L
.30316 .2856 L
.31285 .27611 L
.32313 .26765 L
.33276 .26116 L
.34157 .25637 L
.35098 .25242 L
.35617 .25074 L
.3611 .24945 L
.36564 .24853 L
.36985 .2479 L
.37228 .24763 L
.37448 .24745 L
.3757 .24737 L
.37701 .2473 L
.37826 .24725 L
.3794 .24723 L
.38067 .24721 L
.38186 .24722 L
.38294 .24723 L
.3841 .24727 L
.38537 .24732 L
.38672 .24739 L
.38914 .24757 L
.39137 .24779 L
.39346 .24804 L
.39823 .24878 L
.40342 .24983 L
.40817 .25102 L
.41889 .25443 L
.43782 .26273 L
.45852 .27467 L
.49908 .30441 L
.53812 .33742 L
.57962 .3726 L
.6196 .40208 L
.63792 .41292 L
.64833 .4181 L
.65807 .42221 L
.66845 .42575 L
.67794 .42815 L
.68315 .42911 L
.68809 .42977 L
.69079 .43002 L
.69209 .43012 L
.6933 .43019 L
Mistroke
.694 .43023 L
.69475 .43026 L
.69606 .4303 L
.6968 .43032 L
.69758 .43033 L
.69825 .43033 L
.69899 .43033 L
.7003 .43032 L
.70151 .43028 L
.70214 .43026 L
.70284 .43023 L
.70424 .43015 L
.70681 .42994 L
.70922 .42968 L
.71371 .42902 L
.71854 .42803 L
.72386 .42662 L
.72946 .42474 L
.73946 .42036 L
.74903 .41488 L
.75924 .40759 L
.77762 .39044 L
.79901 .36352 L
.81917 .33068 L
.85769 .24578 L
.89866 .11982 L
Mfstroke
.89866 .11982 m
.92814 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00QGoo00<3ogooOol06Woo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0QGoo00<3ogoo
Ool06Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0QGoo
00<3ogooOol06Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`24Ool00`?oOomoo`0KOol008Yoo`@000ioo`8000Ioo`03001oogoo08Aoo`030omoogoo01]oo`00
Y7oo00<007ooOol0Q7oo00<3ogooOol06goo002TOol00`00Oomoo`24Ool00`?oOomoo`0KOol00:Ao
o`03001oogoo08=oo`030omoogoo01aoo`00Y7oo00<007ooOol0Pgoo00<3ogooOol077oo002TOol0
0`00Oomoo`23Ool00`?oOomoo`0LOol00:Aoo`8008Aoo`030omoogoo01aoo`00Y7oo00<007ooOol0
PWoo00<3ogooOol07Goo002TOol00`00Oomoo`22Ool00`?oOomoo`0MOol00:Aoo`03001oogoo089o
o`030omoogoo01eoo`00Y7oo00<007ooOol0PWoo00<3ogooOol07Goo002TOol00`00Oomoo`21Ool0
0`?oOomoo`0NOol00:Aoo`03001oogoo085oo`030omoogoo01ioo`00Y7oo00<007ooOol0PGoo00<3
ogooOol07Woo002TOol00`00Oomoo`21Ool00`?oOomoo`0NOol00:Aoo`80085oo`030omoogoo01mo
o`00Y7oo00<007ooOol0P7oo00<3ogooOol07goo002TOol00`00Oomoo`20Ool00`?oOomoo`0OOol0
0:Aoo`03001oogoo081oo`030omoogoo01moo`00Y7oo00<007ooOol0P7oo00<3ogooOol07goo002T
Ool00`00Oomoo`1oOol00`?oOomoo`0POol00:Aoo`03001oogoo07moo`030omoogoo021oo`00Y7oo
00<007ooOol0Ogoo00<3ogooOol087oo002TOol00`00Oomoo`1oOol00`?oOomoo`0POol00:Aoo`03
001oogoo07ioo`030omoogoo025oo`00Y7oo0P00Ogoo00<3ogooOol08Goo002TOol00`00Oomoo`1n
Ool00`?oOomoo`0QOol00:Aoo`03001oogoo07ioo`030omoogoo025oo`00Y7oo00<007ooOol0OGoo
00<3ogooOol08Woo002TOol00`00Oomoo`1mOol00`?oOomoo`0ROol00:Aoo`03001oogoo07eoo`03
0omoogoo029oo`00Y7oo00<007ooOol0OGoo00<3ogooOol08Woo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1lOol00`?oOomoo`0SOol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1lOol00`?oOomoo`0SOol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo07aoo`030omoogoo02=oo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00O7oo00<3ogooOol08goo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1kOol00`?oOomoo`0TOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo07]oo`030omoogoo02Ao
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo07]oo`03
0omoogoo02Aoo`00RWoo100037oo0`001goo00<007ooOol0NWoo00<3ogooOol09Goo002TOol00`00
Oomoo`1jOol00`?oOomoo`0UOol00:Aoo`03001oogoo07Yoo`030omoogoo02Eoo`00Y7oo00<007oo
Ool0NGoo00<3ogooOol09Woo002TOol00`00Oomoo`1iOol00`?oOomoo`0VOol00:Aoo`03001oogoo
07Uoo`030omoogoo02Ioo`00Y7oo0P00NGoo00<3ogooOol09goo002TOol00`00Oomoo`1hOol00`?o
Oomoo`0WOol00:Aoo`03001oogoo07Qoo`030omoogoo02Moo`00Y7oo00<007ooOol0Mgoo00<3ogoo
Ool0:7oo002TOol00`00Oomoo`1gOol00`?oOomoo`0XOol00:Aoo`03001oogoo07Moo`030omoogoo
02Qoo`00Y7oo00<007ooOol0MWoo00<3ogooOol0:Goo002TOol00`00Oomoo`1fOol00`?oOomoo`0Y
Ool00:Aoo`03001oogoo07Ioo`030omoogoo02Uoo`00Y7oo00<007ooOol0MGoo00<3ogooOol0:Woo
002TOol2001fOol00`?oOomoo`0ZOol00:Aoo`03001oogoo07Eoo`030omoogoo02Yoo`00Y7oo00<0
07ooOol0MGoo00<3ogooOol0:Woo002TOol00`00Oomoo`1dOol00`?oOomoo`0[Ool000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D002Uoo`030omoogoo01Yoo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo02Uoo`030omoogoo01Yoo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo02Qo
o`030omoogoo01aoo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol0:7oo00<3ogooOol07Goo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0XOol00`?oOomoo`0NOol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
02Moo`030omoogoo021oo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<002Uoo`030omoogoo01aoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo02Moo`030omoogoo01eoo`<000eoo`00Y7oo00<007ooOol0LGoo00<3
ogooOol0;Woo002TOol00`00Oomoo`1aOol00`?oOomoo`0^Ool00:Aoo`03001oogoo075oo`030omo
ogoo02ioo`00Y7oo00<007ooOol0L7oo00<3ogooOol0;goo002TOol00`00Oomoo`1`Ool00`?oOomo
o`0_Ool00:Aoo`03001oogoo071oo`030omoogoo02moo`00Y7oo00<007ooOol0Kgoo00<3ogooOol0
<7oo0004Oomh00050onE00000`?o0000000[0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`030003o`?o00<3o`Aoo`H3o`ioo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03
001oogoo00Eoo`030omoogoo00Aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol02Goo10?o3Woo00<000?o0ol037oo00<007ooOol03Goo00<0
07ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol03Goo00<007ooOol037oo00<007ooOol017oo00<3ogooOol01Goo00<007ooOol037oo00<0
07ooOol037oo00<007ooOol02goo001aOol20olEOol40olHOol00`00Oomoo`1^Ool00`?oOomoo`0a
Ool006moo`83oa]oo`<3oaEoo`03001oogoo06eoo`030omoogoo039oo`00KWoo00<3ogooOol07Woo
0P?o4goo00<007ooOol0KGoo00<3ogooOol0<Woo001/Ool20olSOol20olAOol00`00Oomoo`1/Ool0
0`?oOomoo`0cOol006]oo`030omoogoo02Eoo`030omoogoo00ioo`03001oogoo06aoo`030omoogoo
03=oo`00JWoo00<3ogooOol09goo0P?o3Woo00<007ooOol0Jgoo00<3ogooOol0=7oo001YOol00`?o
Oomoo`0ZOol00`?oOomoo`0;Ool00`00Oomoo`1[Ool00`?oOomoo`0dOol006Qoo`030omoogoo02ao
o`030omoogoo00Yoo`8006]oo`030omoogoo03Eoo`00Igoo00<3ogooOol0;Woo0P?o2Woo00<007oo
Ool0JWoo00<3ogooOol0=Goo001VOol00`?oOomoo`0aOol00`?oOomoo`07Ool00`00Oomoo`1YOol0
0`?oOomoo`0fOol006Eoo`030omoogoo03=oo`030omoogoo00Ioo`03001oogoo06Uoo`030omoogoo
03Ioo`00I7oo00<3ogooOol0=Goo0P?o1Woo00<007ooOol0J7oo00<3ogooOol0=goo001SOol00`?o
Oomoo`0hOol00`?oOomoo`03Ool00`00Oomoo`1XOol00`?oOomoo`0gOol0069oo`030omoogoo03Yo
o`030omoogoo009oo`03001oogoo06Moo`030omoogoo03Qoo`00HWoo00<3ogooOol0>goo0P?o0Woo
00<007ooOol0Igoo00<3ogooOol0>7oo001QOol00`?oOomoo`0nOol00`?oOol0001XOol00`?oOomo
o`0iOol0061oo`030omoogoo041oo`030ol007oo06Moo`030omoogoo03Uoo`00Ggoo00<3ogooOol0
@Woo00<3o`00Ool0IGoo00<3ogooOol0>Woo001NOol00`?oOomoo`13Ool00`000ol3o`1UOol00`?o
Oomoo`0jOol005ioo`030omoogoo04=oo`04001oogoo0omSOol00`?oOomoo`0kOol005eoo`030omo
ogoo04Aoo`05001oogooOol3o`1ROol00`?oOomoo`0kOol005aoo`030omoogoo04Eoo`03001oogoo
009oo`83oemoo`030omoogoo03aoo`00G7oo00<3ogooOol0AGoo00<007ooOol017oo00<3ogooOol0
G7oo00<3ogooOol0?7oo001KOol00`?oOomoo`16Ool00`00Oomoo`05Ool00`?oOomoo`1JOol00`?o
Oomoo`0mOol005]oo`030omoogoo04Ioo`03001oogoo00Ioo`83oeYoo`030omoogoo03eoo`00FWoo
00<3ogooOol0Agoo00<007ooOol027oo00<3ogooOol0EWoo00<3ogooOol0?Woo001IOol00`?oOomo
o`18Ool00`00Oomoo`09Ool00`?oOomoo`1EOol00`?oOomoo`0nOol005Uoo`030omoogoo04Qoo`80
00]oo`030omoogoo05=oo`030omoogoo03moo`00F7oo00<3ogooOol0BGoo00<007ooOol02goo00<3
ogooOol0DWoo00<3ogooOol0?goo001HOol00`?oOomoo`19Ool00`00Oomoo`0<Ool20omAOol00`?o
Oomoo`10Ool005Moo`030omoogoo04Yoo`03001oogoo00ioo`030omoogoo04eoo`030omoogoo045o
o`00Egoo00<3ogooOol0BWoo00<007ooOol03goo00<3ogooOol0C7oo00<3ogooOol0@Goo001FOol0
0`?oOomoo`1;Ool00`00Oomoo`0@Ool00`?oOomoo`1:Ool00`?oOomoo`12Ool005Ioo`030omoogoo
04]oo`03001oogoo015oo`030omoogoo04Uoo`030omoogoo049oo`00EGoo00<3ogooOol0<Woo1000
1Goo0P0017oo1@001Woo00<007ooOol04Woo0P?oB7oo00<3ogooOol0@goo001EOol00`?oOomoo`0a
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00001Woo00<007ooOol057oo
00<3ogooOol0A7oo00<3ogooOol0A7oo001DOol00`?oOomoo`0bOol00`00Oomoo`02Ool00`00Oomo
o`09Ool00`00Oomoo`07Ool00`00Oomoo`0EOol00`?oOomoo`12Ool00`?oOomoo`15Ool005Aoo`03
0omoogoo039oo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo00Ioo`<001Ioo`030omoogoo
045oo`030omoogoo04Eoo`00Dgoo00<3ogooOol0<goo00<007ooOol00Woo00<007ooOol02goo00<0
07ooOol01Goo00<007ooOol05goo00<3ogooOol0?goo00<3ogooOol0AWoo001COol00`?oOomoo`0c
Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`0HOol20olnOol00`?o
Oomoo`17Ool0059oo`030omoogoo03Aoo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol0
0006Ool00`00Oomoo`0JOol00`?oOomoo`0jOol00`?oOomoo`18Ool0059oo`030omoogoo03Eoo`@0
00aoo`<000Moo`03001oogoo01]oo`030omoogoo03Uoo`030omoogoo04Qoo`00DGoo00<3ogooOol0
D7oo00<007ooOol077oo0P?o>7oo00<3ogooOol0BGoo001AOol00`?oOomoo`1@Ool00`00Oomoo`0N
Ool00`?oOomoo`0dOol00`?oOomoo`1:Ool0051oo`030omoogoo055oo`03001oogoo01moo`030omo
ogoo039oo`030omoogoo04]oo`00D7oo00<3ogooOol0DGoo00<007ooOol087oo0P?o<Goo00<3ogoo
Ool0C7oo001?Ool00`?oOomoo`1BOol00`00Oomoo`0ROol00`?oOomoo`0/Ool20om?Ool004moo`03
0omoogoo059oo`8002Aoo`030omoogoo02Yoo`030omoogoo04moo`00CWoo00<3ogooOol0Dgoo00<0
07ooOol097oo0P?o:Goo00<3ogooOol0D7oo001>Ool00`?oOomoo`1COol00`00Oomoo`0VOol20olV
Ool00`?oOomoo`1AOol004eoo`030omoogoo05Aoo`03001oogoo02Qoo`83ob=oo`030omoogoo059o
o`00CGoo00<3ogooOol0E7oo00<007ooOol0:Woo0P?o87oo00<3ogooOol0Dgoo001<Ool00`?oOomo
o`1EOol00`00Oomoo`0/Ool20olLOol20omFOol004aoo`030omoogoo05Eoo`03001oogoo02ioo`<3
oaMoo`83oeQoo`00Bgoo00<3ogooOol0EWoo00<007ooOol0<Goo0`?o4Woo0P?oFWoo001;Ool00`?o
Oomoo`1FOol00`00Oomoo`0dOol40ol9Ool50omLOol004]oo`030omoogoo05Ioo`8003Uoo`T3of5o
o`00BWoo00<3ogooOol0Egoo00<007ooOol0XWoo001:Ool00`?oOomoo`1GOol00`00Oomoo`2ROol0
04Yoo`030omoogoo05Moo`03001oogoo0:9oo`00BGoo00<3ogooOol0F7oo00<007ooOol0XWoo0019
Ool00`?oOomoo`1HOol00`00Oomoo`2ROol004Uoo`030omoogoo05Qoo`03001oogoo0:9oo`00B7oo
00<3ogooOol0FGoo00<007ooOol0XWoo0018Ool00`?oOomoo`1IOol00`00Oomoo`2ROol004Qoo`03
0omoogoo05Uoo`03001oogoo0:9oo`00Agoo00<3ogooOol0FWoo0P00Xgoo0017Ool00`?oOomoo`1J
Ool00`00Oomoo`2ROol004Moo`030omoogoo05Yoo`03001oogoo0:9oo`00AWoo00<3ogooOol0Fgoo
00<007ooOol0XWoo0016Ool00`?oOomoo`1KOol00`00Oomoo`2ROol004Ioo`030omoogoo05]oo`03
001oogoo0:9oo`00AGoo00<3ogooOol0G7oo00<007ooOol0XWoo0015Ool00`?oOomoo`12Ool40005
Ool20007Ool30005Ool00`00Oomoo`2ROol004Eoo`030omoogoo045oo`03001oogoo009oo`03001o
ogoo009oo`8000Qoo`03001oogoo00Aoo`03001oogoo0:9oo`00A7oo00<3ogooOol0@Woo00<007oo
Ool00Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol0XWoo0014Ool00`?oOomoo`12Ool0
0`00Oomoo`02Ool00`00Oomoo`08Ool60005Ool3002ROol004Aoo`030omoogoo049oo`03001oogoo
009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol004Aoo`030omoogoo049oo`03
001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol004=oo`030omoogoo
04=oo`03001oogoo009oo`03001oogoo00Yoo`03001oo`0000Ioo`03001oogoo0:9oo`00@goo00<3
ogooOol0A7oo10003Woo0P001Woo00<007ooOol0XWoo0013Ool00`?oOomoo`1NOol00`00Oomoo`2R
Ool0049oo`030omoogoo05moo`03001oogoo0:9oo`00@Woo00<3ogooOol0Ggoo00<007ooOol0XWoo
0012Ool00`?oOomoo`1OOol00`00Oomoo`2ROol0045oo`030omoogoo061oo`03001oogoo0:9oo`00
@Goo00<3ogooOol0H7oo0P00Xgoo0011Ool00`?oOomoo`1POol00`00Oomoo`2ROol0041oo`030omo
ogoo065oo`03001oogoo0:9oo`00@7oo00<3ogooOol0HGoo00<007ooOol0XWoo0010Ool00`?oOomo
o`1QOol00`00Oomoo`2ROol003moo`030omoogoo069oo`03001oogoo0:9oo`00?goo00<3ogooOol0
HWoo00<007ooOol0XWoo000oOol00`?oOomoo`1ROol00`00Oomoo`2ROol003ioo`030omoogoo06=o
o`03001oogoo0:9oo`00?Woo00<3ogooOol0Hgoo00<007ooOol0XWoo000nOol00`?oOomoo`1SOol2
002SOol003eoo`030omoogoo06Aoo`03001oogoo0:9oo`00?Goo00<3ogooOol0I7oo00<007ooOol0
XWoo000mOol00`?oOomoo`1TOol00`00Oomoo`2ROol003eoo`030omoogoo06Aoo`03001oogoo0:9o
o`00?7oo00<3ogooOol0IGoo00<007ooOol0XWoo000lOol00`?oOomoo`1UOol00`00Oomoo`2ROol0
03aoo`030omoogoo06Eoo`03001oogoo0:9oo`00?7oo00<3ogooOol0IGoo00<007ooOol0XWoo000k
Ool00`?oOomoo`1VOol00`00Oomoo`2ROol003]oo`030omoogoo06Ioo`800:=oo`00>goo00<3ogoo
Ool0IWoo00<007ooOol0XWoo000kOol00`?oOomoo`1VOol00`00Oomoo`2ROol003Yoo`030omoogoo
06Moo`03001oogoo0:9oo`00>Woo00<3ogooOol0Igoo00<007ooOol0XWoo000jOol00`?oOomoo`1W
Ool00`00Oomoo`2ROol003Yoo`030omoogoo06Moo`03001oogoo0:9oo`00>Goo00<3ogooOol0J7oo
00<007ooOol0XWoo000iOol00`?oOomoo`1XOol00`00Oomoo`2ROol003Uoo`030omoogoo06Qoo`03
001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .7 1 r
.5 Mabswid
.15363 .61803 m
.18221 .51217 L
.20342 .44876 L
.22272 .3998 L
.26171 .32417 L
.28086 .29746 L
.29075 .28613 L
.30164 .27549 L
.3112 .26767 L
.32148 .26078 L
.33233 .25513 L
.33761 .25296 L
.34251 .25127 L
.34781 .24978 L
.35261 .24874 L
.35518 .24829 L
.35795 .2479 L
.35948 .24772 L
.36088 .24758 L
.36221 .24747 L
.36364 .24737 L
.3649 .24731 L
.36605 .24726 L
.3672 .24723 L
.3683 .24722 L
.36957 .24722 L
.37075 .24723 L
.37204 .24726 L
.37269 .24729 L
.37341 .24732 L
.37597 .24747 L
.37741 .24759 L
.37873 .24771 L
.38373 .24835 L
.38847 .24919 L
.39353 .25031 L
.40265 .25294 L
.4135 .25698 L
.42335 .26146 L
.46334 .28608 L
.5018 .3165 L
.54272 .35167 L
.58212 .38396 L
.62001 .4096 L
.63946 .41946 L
.65038 .42376 L
.66035 .42681 L
.66513 .42796 L
.67022 .42894 L
.6727 .42933 L
Mistroke
.67503 .42963 L
.6771 .42986 L
.67938 .43006 L
.6806 .43015 L
.6819 .43022 L
.68263 .43025 L
.68328 .43028 L
.68457 .43031 L
.68575 .43033 L
.68702 .43033 L
.68823 .43032 L
.68934 .43029 L
.69063 .43024 L
.69183 .43018 L
.69315 .43009 L
.69457 .42997 L
.69746 .42967 L
.70011 .4293 L
.70487 .42843 L
.70994 .42719 L
.71907 .42416 L
.72993 .41912 L
.73979 .41313 L
.75901 .39732 L
.77982 .37357 L
.79974 .34383 L
.82079 .30432 L
.85873 .21017 L
.89913 .07389 L
Mfstroke
.89913 .07389 m
.91598 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00PGoo00<2_gooOol07Woo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0PGoo00<2_goo
Ool07Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0PGoo
00<2_gooOol07Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`20Ool00`:oOomoo`0OOol008Yoo`@000ioo`8000Ioo`03001oogoo081oo`030[moogoo01moo`00
Y7oo00<007ooOol0P7oo00<2_gooOol07goo002TOol00`00Oomoo`20Ool00`:oOomoo`0OOol00:Ao
o`03001oogoo07moo`030[moogoo021oo`00Y7oo00<007ooOol0Ogoo00<2_gooOol087oo002TOol0
0`00Oomoo`1oOol00`:oOomoo`0POol00:Aoo`80081oo`030[moogoo021oo`00Y7oo00<007ooOol0
Ogoo00<2_gooOol087oo002TOol00`00Oomoo`1nOol00`:oOomoo`0QOol00:Aoo`03001oogoo07io
o`030[moogoo025oo`00Y7oo00<007ooOol0OWoo00<2_gooOol08Goo002TOol00`00Oomoo`1nOol0
0`:oOomoo`0QOol00:Aoo`03001oogoo07ioo`030[moogoo025oo`00Y7oo00<007ooOol0OGoo00<2
_gooOol08Woo002TOol00`00Oomoo`1mOol00`:oOomoo`0ROol00:Aoo`8007ioo`030[moogoo029o
o`00Y7oo00<007ooOol0OGoo00<2_gooOol08Woo002TOol00`00Oomoo`1lOol00`:oOomoo`0SOol0
0:Aoo`03001oogoo07aoo`030[moogoo02=oo`00Y7oo00<007ooOol0O7oo00<2_gooOol08goo002T
Ool00`00Oomoo`1lOol00`:oOomoo`0SOol00:Aoo`03001oogoo07]oo`030[moogoo02Aoo`00Y7oo
00<007ooOol0Ngoo00<2_gooOol097oo002TOol00`00Oomoo`1kOol00`:oOomoo`0TOol00:Aoo`03
001oogoo07]oo`030[moogoo02Aoo`00Y7oo0P00Ngoo00<2_gooOol09Goo002TOol00`00Oomoo`1j
Ool00`:oOomoo`0UOol00:Aoo`03001oogoo07Yoo`030[moogoo02Eoo`00Y7oo00<007ooOol0NGoo
00<2_gooOol09Woo002TOol00`00Oomoo`1iOol00`:oOomoo`0VOol00:Aoo`03001oogoo07Uoo`03
0[moogoo02Ioo`00Y7oo00<007ooOol0N7oo00<2_gooOol09goo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1hOol00`:oOomoo`0WOol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1hOol00`:oOomoo`0WOol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo07Qoo`030[moogoo02Moo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00Mgoo00<2_gooOol0:7oo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1gOol00`:oOomoo`0XOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo07Moo`030[moogoo02Qo
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo07Ioo`03
0[moogoo02Uoo`00RWoo100037oo0`001goo00<007ooOol0MWoo00<2_gooOol0:Goo002TOol00`00
Oomoo`1fOol00`:oOomoo`0YOol00:Aoo`03001oogoo07Eoo`030[moogoo02Yoo`00Y7oo00<007oo
Ool0MGoo00<2_gooOol0:Woo002TOol00`00Oomoo`1eOol00`:oOomoo`0ZOol00:Aoo`03001oogoo
07Eoo`030[moogoo02Yoo`00Y7oo0P00MGoo00<2_gooOol0:goo002TOol00`00Oomoo`1dOol00`:o
Oomoo`0[Ool00:Aoo`03001oogoo07Aoo`030[moogoo02]oo`00Y7oo00<007ooOol0Lgoo00<2_goo
Ool0;7oo002TOol00`00Oomoo`1cOol00`:oOomoo`0/Ool00:Aoo`03001oogoo07=oo`030[moogoo
02aoo`00Y7oo00<007ooOol0Lgoo00<2_gooOol0;7oo002TOol00`00Oomoo`1bOol00`:oOomoo`0]
Ool00:Aoo`03001oogoo079oo`030[moogoo02eoo`00Y7oo00<007ooOol0LWoo00<2_gooOol0;Goo
002TOol2001bOol00`:oOomoo`0^Ool00:Aoo`03001oogoo075oo`030[moogoo02ioo`00Y7oo00<0
07ooOol0LGoo00<2_gooOol0;Woo002TOol00`00Oomoo`1`Ool00`:oOomoo`0_Ool000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D002Eoo`030[moogoo01ioo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo02Eoo`030[moogoo01ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo02Eo
o`030[moogoo01moo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol097oo00<2_gooOol08Goo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0TOol00`:oOomoo`0ROol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
02Aoo`030[moogoo02=oo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<002Eoo`030[moogoo021oo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo02=oo`030[moogoo025oo`<000eoo`00Y7oo00<007ooOol0KGoo00<2
_gooOol0<Woo002TOol00`00Oomoo`1]Ool00`:oOomoo`0bOol00:Aoo`03001oogoo06eoo`030[mo
ogoo039oo`00Y7oo00<007ooOol0K7oo00<2_gooOol0<goo002TOol00`00Oomoo`1/Ool00`:oOomo
o`0cOol00:Aoo`03001oogoo06]oo`030[moogoo03Aoo`00Y7oo00<007ooOol0Jgoo00<2_gooOol0
=7oo0004Oomd00050[nE00000`:o0000000_0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Uo
o`D2_`Eoo`L2_`03Ool007oo00eoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`04
001oogoo0[l;Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool000aoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo
00aoo`03001oogoo00Ioo`<2_`=oo`03001oogoo00]oo`82_`ioo`03001oogoo00eoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo
00eoo`03001oogoo00aoo`04001oogoo0[l;Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomo
o`0;Ool006ioo`82_aIoo`82_aaoo`03001oogoo06Uoo`030[moogoo03Ioo`00K7oo0P:o6Woo0P:o
6Woo00<007ooOol0JGoo00<2_gooOol0=Woo001[Ool00`:oOomoo`0LOol20[lHOol00`00Oomoo`1Y
Ool00`:oOomoo`0fOol006Uoo`82_b5oo`82_aIoo`03001oogoo06Qoo`030[moogoo03Moo`00J7oo
00<2_gooOol08goo0P:o57oo00<007ooOol0J7oo00<2_gooOol0=goo001VOol20[lXOol00`:oOomo
o`0AOol00`00Oomoo`1WOol00`:oOomoo`0hOol006Aoo`82_b]oo`82_a5oo`03001oogoo06Moo`03
0[moogoo03Qoo`00Hgoo00<2_gooOol0;Goo00<2_gooOol03Woo0P00J7oo00<2_gooOol0>7oo001R
Ool00`:oOomoo`0_Ool20[l>Ool00`00Oomoo`1VOol00`:oOomoo`0iOol0069oo`030[moogoo035o
o`82_`aoo`03001oogoo06Ioo`030[moogoo03Uoo`00HGoo00<2_gooOol0=7oo00<2_gooOol02Goo
00<007ooOol0IGoo00<2_gooOol0>Woo001POol00`:oOomoo`0fOol00`:oOomoo`08Ool00`00Oomo
o`1UOol00`:oOomoo`0jOol005moo`030[moogoo03Qoo`82_`Qoo`03001oogoo06Eoo`030[moogoo
03Yoo`00GWoo00<2_gooOol0>goo00<2_gooOol01Goo00<007ooOol0I7oo00<2_gooOol0>goo001M
Ool00`:oOomoo`0mOol00`:oOomoo`04Ool00`00Oomoo`1TOol00`:oOomoo`0kOol005eoo`030[mo
ogoo03ioo`82_`Aoo`03001oogoo06=oo`030[moogoo03aoo`00G7oo00<2_gooOol0@Goo00D2_goo
Oomoo`0006Eoo`030[moogoo03aoo`00Fgoo00<2_gooOol0@goo00<2_gooOol00P00Hgoo00<2_goo
Ool0?Goo001KOol00`:oOomoo`14Ool20[l00`00Oomoo`1ROol00`:oOomoo`0mOol005Yoo`030[mo
ogoo04Moo`030[moogoo065oo`030[moogoo03ioo`00FGoo00<2_gooOol0B7oo00<000:oOol0HGoo
00<2_gooOol0?Woo001IOol00`:oOomoo`18Ool00`00Ool2_`1POol00`:oOomoo`0oOol005Qoo`03
0[moogoo04Uoo`04001oogoo0[mNOol00`:oOomoo`10Ool005Moo`030[moogoo04Yoo`05001oogoo
Ool2_`1MOol00`:oOomoo`10Ool005Moo`030[moogoo04Yoo`03001oogoo009oo`030[moogoo05Uo
o`030[moogoo045oo`00EWoo00<2_gooOol0Bgoo00<007ooOol00goo0P:oFGoo00<2_gooOol0@Goo
001FOol00`:oOomoo`1;Ool00`00Oomoo`05Ool00`:oOomoo`1EOol00`:oOomoo`12Ool005Eoo`03
0[moogoo04aoo`8000Moo`030[moogoo05Aoo`030[moogoo049oo`00EGoo00<2_gooOol0C7oo00<0
07ooOol01goo00<2_gooOol0DWoo00<2_gooOol0@goo001DOol00`:oOomoo`1=Ool00`00Oomoo`08
Ool00`:oOomoo`1@Ool00`:oOomoo`14Ool005Aoo`030[moogoo04eoo`03001oogoo00Uoo`030[mo
ogoo04moo`030[moogoo04Aoo`00Dgoo00<2_gooOol0CWoo00<007ooOol02Woo00<2_gooOol0CGoo
00<2_gooOol0AGoo001COol00`:oOomoo`1>Ool00`00Oomoo`0;Ool00`:oOomoo`1<Ool00`:oOomo
o`15Ool0059oo`030[moogoo04moo`03001oogoo00aoo`82_d]oo`030[moogoo04Ioo`00DGoo00<2
_gooOol0=Woo10001Goo0P0017oo1@001Woo00<007ooOol03Woo00<2_gooOol0Agoo00<2_gooOol0
Agoo001AOol00`:oOomoo`0eOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo
00001Woo00<007ooOol03goo00<2_gooOol0AWoo00<2_gooOol0Agoo001@Ool00`:oOomoo`0fOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`0@Ool20[m5Ool00`:oOomo
o`18Ool0051oo`030[moogoo03Ioo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo00Ioo`<0
019oo`030[moogoo049oo`030[moogoo04Qoo`00Cgoo00<2_gooOol0=goo00<007ooOol00Woo00<0
07ooOol02goo00<007ooOol01Goo00<007ooOol04goo00<2_gooOol0@7oo00<2_gooOol0BGoo001?
Ool00`:oOomoo`0gOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`0D
Ool20[loOol00`:oOomoo`1:Ool004ioo`030[moogoo03Qoo`03001oogoo009oo`03001oogoo00Qo
o`05001oogooOol00006Ool00`00Oomoo`0FOol00`:oOomoo`0kOol00`:oOomoo`1;Ool004ioo`03
0[moogoo03Uoo`@000aoo`<000Moo`03001oogoo01Moo`030[moogoo03Uoo`030[moogoo04aoo`00
CGoo00<2_gooOol0E7oo00<007ooOol067oo0P:o>7oo00<2_gooOol0CGoo001=Ool00`:oOomoo`1D
Ool00`00Oomoo`0JOol00`:oOomoo`0dOol00`:oOomoo`1>Ool004aoo`030[moogoo05Eoo`03001o
ogoo01]oo`82_c=oo`030[moogoo04moo`00C7oo00<2_gooOol0EGoo00<007ooOol07Goo00<2_goo
Ool0;goo00<2_gooOol0D7oo001;Ool00`:oOomoo`1FOol00`00Oomoo`0NOol20[l^Ool00`:oOomo
o`1AOol004]oo`030[moogoo05Ioo`80025oo`030[moogoo02Yoo`030[moogoo059oo`00BWoo00<2
_gooOol0Egoo00<007ooOol08Goo0P:o:7oo0P:oEGoo001:Ool00`:oOomoo`1GOol00`00Oomoo`0S
Ool00`:oOomoo`0TOol00`:oOomoo`1EOol004Uoo`030[moogoo05Qoo`03001oogoo02Aoo`82_b=o
o`030[moogoo05Ioo`00BGoo00<2_gooOol0F7oo00<007ooOol09Woo0P:o7goo0P:oFGoo0019Ool0
0`:oOomoo`1HOol00`00Oomoo`0XOol20[lLOol00`:oOomoo`1IOol004Qoo`030[moogoo05Uoo`03
001oogoo02Yoo`82_aQoo`82_eaoo`00B7oo00<2_gooOol0FGoo00<007ooOol0;7oo0`:o4Woo0`:o
GWoo0018Ool00`:oOomoo`1IOol00`00Oomoo`0_Ool60[l7Ool50[mQOol004Moo`030[moogoo05Yo
o`8003Eoo`T2_fEoo`00Agoo00<2_gooOol0FWoo00<007ooOol0XWoo0016Ool00`:oOomoo`1KOol0
0`00Oomoo`2ROol004Ioo`030[moogoo05]oo`03001oogoo0:9oo`00AWoo00<2_gooOol0Fgoo00<0
07ooOol0XWoo0015Ool00`:oOomoo`1LOol00`00Oomoo`2ROol004Eoo`030[moogoo05aoo`03001o
ogoo0:9oo`00AGoo00<2_gooOol0G7oo00<007ooOol0XWoo0014Ool00`:oOomoo`1MOol00`00Oomo
o`2ROol004Aoo`030[moogoo05eoo`03001oogoo0:9oo`00A7oo00<2_gooOol0GGoo0P00Xgoo0013
Ool00`:oOomoo`1NOol00`00Oomoo`2ROol004=oo`030[moogoo05ioo`03001oogoo0:9oo`00@goo
00<2_gooOol0GWoo00<007ooOol0XWoo0012Ool00`:oOomoo`1OOol00`00Oomoo`2ROol0049oo`03
0[moogoo05moo`03001oogoo0:9oo`00@Goo00<2_gooOol0H7oo00<007ooOol0XWoo0011Ool00`:o
Oomoo`16Ool40005Ool20007Ool30005Ool00`00Oomoo`2ROol0045oo`030[moogoo04Eoo`03001o
ogoo009oo`03001oogoo009oo`8000Qoo`03001oogoo00Aoo`03001oogoo0:9oo`00@7oo00<2_goo
Ool0AWoo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol0XWoo0010Ool0
0`:oOomoo`16Ool00`00Oomoo`02Ool00`00Oomoo`08Ool60005Ool3002ROol0041oo`030[moogoo
04Ioo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol003moo`03
0[moogoo04Moo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol0
03moo`030[moogoo04Moo`03001oogoo009oo`03001oogoo00Yoo`03001oo`0000Ioo`03001oogoo
0:9oo`00?goo00<2_gooOol0B7oo10003Woo0P001Woo00<007ooOol0XWoo000nOol00`:oOomoo`1S
Ool00`00Oomoo`2ROol003ioo`030[moogoo06=oo`03001oogoo0:9oo`00?Woo00<2_gooOol0Hgoo
00<007ooOol0XWoo000mOol00`:oOomoo`1TOol00`00Oomoo`2ROol003eoo`030[moogoo06Aoo`03
001oogoo0:9oo`00?Goo00<2_gooOol0I7oo0P00Xgoo000mOol00`:oOomoo`1TOol00`00Oomoo`2R
Ool003aoo`030[moogoo06Eoo`03001oogoo0:9oo`00?7oo00<2_gooOol0IGoo00<007ooOol0XWoo
000lOol00`:oOomoo`1UOol00`00Oomoo`2ROol003aoo`030[moogoo06Eoo`03001oogoo0:9oo`00
>goo00<2_gooOol0IWoo00<007ooOol0XWoo000kOol00`:oOomoo`1VOol00`00Oomoo`2ROol003]o
o`030[moogoo06Ioo`03001oogoo0:9oo`00>Woo00<2_gooOol0Igoo00<007ooOol0XWoo000jOol0
0`:oOomoo`1WOol2002SOol003Yoo`030[moogoo06Moo`03001oogoo0:9oo`00>Woo00<2_gooOol0
Igoo00<007ooOol0XWoo000iOol00`:oOomoo`1XOol00`00Oomoo`2ROol003Uoo`030[moogoo06Qo
o`03001oogoo0:9oo`00>Goo00<2_gooOol0J7oo00<007ooOol0XWoo000iOol00`:oOomoo`1XOol0
0`00Oomoo`2ROol003Qoo`030[moogoo06Uoo`03001oogoo0:9oo`00>7oo00<2_gooOol0JGoo00<0
07ooOol0XWoo000hOol00`:oOomoo`1YOol00`00Oomoo`2ROol003Moo`030[moogoo06Yoo`800:=o
o`00=goo00<2_gooOol0JWoo00<007ooOol0XWoo000gOol00`:oOomoo`1ZOol00`00Oomoo`2ROol0
03Moo`030[moogoo06Yoo`03001oogoo0:9oo`00=Woo00<2_gooOol0Jgoo00<007ooOol0XWoo000f
Ool00`:oOomoo`1[Ool00`00Oomoo`2ROol003Ioo`030[moogoo06]oo`03001oogoo0:9oo`00=Woo
00<2_gooOol0Jgoo00<007ooOol0XWoo000eOol00`:oOomoo`1/Ool00`00Oomoo`2ROol003Eoo`03
0[moogoo06aoo`03001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.14122 .61803 m
.14415 .60511 L
.18221 .47531 L
.20342 .41761 L
.22272 .37352 L
.24299 .33527 L
.26171 .30681 L
.28086 .28402 L
.29159 .27386 L
.30164 .26596 L
.31142 .2597 L
.32037 .25516 L
.3303 .25136 L
.33578 .24981 L
.34099 .24868 L
.34358 .24825 L
.34602 .2479 L
.34823 .24765 L
.35058 .24745 L
.3518 .24737 L
.35313 .2473 L
.35435 .24726 L
.35549 .24723 L
.35617 .24722 L
.35683 .24721 L
.35805 .24722 L
.35936 .24724 L
.36011 .24726 L
.3608 .24729 L
.36185 .24733 L
.36298 .2474 L
.36503 .24755 L
.36747 .24778 L
.36971 .24805 L
.37433 .24876 L
.37918 .24974 L
.38873 .25229 L
.39892 .25589 L
.41729 .26444 L
.45879 .29151 L
.49877 .32403 L
.53724 .35715 L
.57816 .3899 L
.59851 .40382 L
.61756 .41472 L
.63582 .42281 L
.64608 .42617 L
.65545 .42841 L
.66023 .42924 L
.66285 .4296 L
Mistroke
.66532 .42987 L
.66763 .43007 L
.66884 .43016 L
.67012 .43023 L
.6712 .43027 L
.67239 .43031 L
.67347 .43033 L
.67447 .43033 L
.67576 .43033 L
.67649 .43032 L
.67716 .4303 L
.6784 .43026 L
.67971 .43019 L
.68198 .43003 L
.68449 .42979 L
.68715 .42945 L
.69002 .429 L
.69521 .42792 L
.70018 .42658 L
.7048 .42505 L
.71529 .42054 L
.7255 .4147 L
.7364 .40682 L
.75779 .38603 L
.77795 .35948 L
.81647 .28795 L
.83638 .2392 L
.85744 .17815 L
.89538 .04146 L
Mfstroke
.89538 .04146 m
.90434 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00OGoo00<1WgooOol08Woo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0OGoo00<1Wgoo
Ool08Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0OGoo
00<1WgooOol08Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`1mOol00`6OOomoo`0ROol008Yoo`@000ioo`8000Ioo`03001oogoo07aoo`030Imoogoo02=oo`00
Y7oo00<007ooOol0O7oo00<1WgooOol08goo002TOol00`00Oomoo`1lOol00`6OOomoo`0SOol00:Ao
o`03001oogoo07aoo`030Imoogoo02=oo`00Y7oo00<007ooOol0O7oo00<1WgooOol08goo002TOol0
0`00Oomoo`1lOol00`6OOomoo`0SOol00:Aoo`8007aoo`030Imoogoo02Aoo`00Y7oo00<007ooOol0
Ngoo00<1WgooOol097oo002TOol00`00Oomoo`1kOol00`6OOomoo`0TOol00:Aoo`03001oogoo07]o
o`030Imoogoo02Aoo`00Y7oo00<007ooOol0Ngoo00<1WgooOol097oo002TOol00`00Oomoo`1jOol0
0`6OOomoo`0UOol00:Aoo`03001oogoo07Yoo`030Imoogoo02Eoo`00Y7oo00<007ooOol0NWoo00<1
WgooOol09Goo002TOol00`00Oomoo`1iOol00`6OOomoo`0VOol00:Aoo`8007Yoo`030Imoogoo02Io
o`00Y7oo00<007ooOol0NGoo00<1WgooOol09Woo002TOol00`00Oomoo`1iOol00`6OOomoo`0VOol0
0:Aoo`03001oogoo07Qoo`030Imoogoo02Moo`00Y7oo00<007ooOol0N7oo00<1WgooOol09goo002T
Ool00`00Oomoo`1hOol00`6OOomoo`0WOol00:Aoo`03001oogoo07Moo`030Imoogoo02Qoo`00Y7oo
00<007ooOol0Mgoo00<1WgooOol0:7oo002TOol00`00Oomoo`1gOol00`6OOomoo`0XOol00:Aoo`03
001oogoo07Ioo`030Imoogoo02Uoo`00Y7oo0P00Mgoo00<1WgooOol0:Goo002TOol00`00Oomoo`1f
Ool00`6OOomoo`0YOol00:Aoo`03001oogoo07Ioo`030Imoogoo02Uoo`00Y7oo00<007ooOol0MGoo
00<1WgooOol0:Woo002TOol00`00Oomoo`1eOol00`6OOomoo`0ZOol00:Aoo`03001oogoo07Eoo`03
0Imoogoo02Yoo`00Y7oo00<007ooOol0M7oo00<1WgooOol0:goo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1dOol00`6OOomoo`0[Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1dOol00`6OOomoo`0[Ool008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo07=oo`030Imoogoo02aoo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00Lgoo00<1WgooOol0;7oo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1cOol00`6OOomoo`0/Ool008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo07=oo`030Imoogoo02ao
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo079oo`03
0Imoogoo02eoo`00RWoo100037oo0`001goo00<007ooOol0LWoo00<1WgooOol0;Goo002TOol00`00
Oomoo`1bOol00`6OOomoo`0]Ool00:Aoo`03001oogoo075oo`030Imoogoo02ioo`00Y7oo00<007oo
Ool0LGoo00<1WgooOol0;Woo002TOol00`00Oomoo`1aOol00`6OOomoo`0^Ool00:Aoo`03001oogoo
071oo`030Imoogoo02moo`00Y7oo0P00LGoo00<1WgooOol0;goo002TOol00`00Oomoo`1`Ool00`6O
Oomoo`0_Ool00:Aoo`03001oogoo071oo`030Imoogoo02moo`00Y7oo00<007ooOol0Kgoo00<1Wgoo
Ool0<7oo002TOol00`00Oomoo`1_Ool00`6OOomoo`0`Ool00:Aoo`03001oogoo06moo`030Imoogoo
031oo`00Y7oo00<007ooOol0KWoo00<1WgooOol0<Goo002TOol00`00Oomoo`1^Ool00`6OOomoo`0a
Ool00:Aoo`03001oogoo06ioo`030Imoogoo035oo`00Y7oo00<007ooOol0KGoo00<1WgooOol0<Woo
002TOol2001^Ool00`6OOomoo`0bOol00:Aoo`03001oogoo06eoo`030Imoogoo039oo`00Y7oo00<0
07ooOol0K7oo00<1WgooOol0<goo002TOol00`00Oomoo`1/Ool00`6OOomoo`0cOol000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D0025oo`030Imoogoo029oo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo025oo`030Imoogoo029oo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo021o
o`030Imoogoo02Aoo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol087oo00<1WgooOol09Goo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0POol00`6OOomoo`0VOol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
01moo`030Imoogoo02Qoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<0025oo`030Imoogoo02Aoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo01moo`030Imoogoo02Eoo`<000eoo`00Y7oo00<007ooOol0JGoo00<1
WgooOol0=Woo002TOol00`00Oomoo`1YOol00`6OOomoo`0fOol00:Aoo`03001oogoo06Uoo`030Imo
ogoo03Ioo`00Y7oo00<007ooOol0JGoo00<1WgooOol0=Woo002TOol00`00Oomoo`1XOol00`6OOomo
o`0gOol00:Aoo`03001oogoo06Qoo`030Imoogoo03Moo`00Y7oo00<007ooOol0J7oo00<1WgooOol0
=goo0004Oom`00050InE00000`6O0000000c0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Eo
o`D1W`9oo`03001oogoo00H1W`Ioo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03
001oogoo00aoo`030Imoogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol00goo0P6O1goo00<007ooOol01Woo0`6O0goo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol02goo00<1W`00Ool03Goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol02goo001ZOol30IlEOol20IlPOol00`00Oomoo`1VOol00`6O
Oomoo`0iOol006Qoo`81WaYoo`81Waioo`03001oogoo06Eoo`030Imoogoo03Yoo`00IWoo0P6O7Woo
0P6O77oo00<007ooOol0IGoo00<1WgooOol0>Woo001TOol20IlROol20IlJOol00`00Oomoo`1TOol0
0`6OOomoo`0kOol006=oo`030Imoogoo02Aoo`81WaQoo`03001oogoo06Aoo`030Imoogoo03]oo`00
HWoo00<1WgooOol09goo00<1WgooOol05Goo00<007ooOol0Hgoo00<1WgooOol0?7oo001QOol00`6O
Oomoo`0YOol20IlEOol00`00Oomoo`1SOol00`6OOomoo`0lOol0061oo`030Imoogoo02aoo`030Imo
ogoo019oo`8006=oo`030Imoogoo03eoo`00Ggoo00<1WgooOol0;Woo0P6O4Woo00<007ooOol0HWoo
00<1WgooOol0?Goo001NOol00`6OOomoo`0aOol20Il@Ool00`00Oomoo`1QOol00`6OOomoo`0nOol0
05eoo`030Imoogoo03Aoo`030Imoogoo00eoo`03001oogoo065oo`030Imoogoo03ioo`00G7oo00<1
WgooOol0=Woo0P6O3Goo00<007ooOol0H7oo00<1WgooOol0?goo001KOol00`6OOomoo`0iOol00`6O
Oomoo`0:Ool00`00Oomoo`1POol00`6OOomoo`0oOol005]oo`030Imoogoo03Yoo`030Imoogoo00Uo
o`03001oogoo05moo`030Imoogoo041oo`00FWoo00<1WgooOol0?7oo00<1WgooOol027oo00<007oo
Ool0Ggoo00<1WgooOol0@7oo001IOol00`6OOomoo`0nOol20Il8Ool00`00Oomoo`1NOol00`6OOomo
o`11Ool005Qoo`030Imoogoo045oo`030Imoogoo00Eoo`03001oogoo05ioo`030Imoogoo045oo`00
Egoo00<1WgooOol0@goo00<1WgooOol017oo0P00GWoo00<1WgooOol0@Woo001GOol00`6OOomoo`14
Ool00`6OOomoo`03Ool00`00Oomoo`1MOol00`6OOomoo`12Ool005Ioo`030Imoogoo04Ioo`030Imo
ogoo009oo`03001oogoo05aoo`030Imoogoo04=oo`00EGoo00<1WgooOol0B7oo0P6O0Woo00<007oo
Ool0G7oo00<1WgooOol0@goo001EOol00`6OOomoo`1:Ool00`6OOol0001MOol00`6OOomoo`14Ool0
05Aoo`030Imoogoo04aoo`030Il007oo05aoo`030Imoogoo04Aoo`00Dgoo00<1WgooOol0CWoo00<1
WgooOol0FWoo00<1WgooOol0AGoo001COol00`6OOomoo`1>Ool00`000Imoo`1JOol00`6OOomoo`15
Ool0059oo`030Imoogoo04moo`04001oo`6O0ImHOol00`6OOomoo`16Ool0055oo`030Imoogoo051o
o`05001oogooOol1W`1GOol00`6OOomoo`16Ool0055oo`030Imoogoo051oo`8000=oo`030Imoogoo
05=oo`030Imoogoo04Moo`00D7oo00<1WgooOol0DGoo00<007ooOol00goo00<1WgooOol0DWoo00<1
WgooOol0Agoo001@Ool00`6OOomoo`1AOol00`00Oomoo`04Ool00`6OOomoo`1@Ool00`6OOomoo`18
Ool004moo`030Imoogoo059oo`03001oogoo00Eoo`81We1oo`030Imoogoo04Qoo`00Cgoo00<1Wgoo
Ool0DWoo00<007ooOol01goo00<1WgooOol0C7oo00<1WgooOol0BGoo001>Ool00`6OOomoo`1COol0
0`00Oomoo`08Ool00`6OOomoo`1;Ool00`6OOomoo`19Ool004ioo`030Imoogoo05=oo`03001oogoo
00Uoo`030Imoogoo04Uoo`030Imoogoo04Yoo`00CGoo00<1WgooOol0>Woo10001Goo0P0017oo1@00
1Woo00<007ooOol02Woo0P6OB7oo00<1WgooOol0Bgoo001=Ool00`6OOomoo`0iOol00`00Oomoo`02
Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00001Woo00<007ooOol037oo00<1WgooOol0AGoo
00<1WgooOol0Bgoo001<Ool00`6OOomoo`0jOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomo
o`07Ool00`00Oomoo`0=Ool00`6OOomoo`13Ool00`6OOomoo`1<Ool004aoo`030Imoogoo03Yoo`03
001oogoo009oo`03001oogoo00Yoo`03001oogoo00Ioo`<000ioo`030Imoogoo045oo`030Imoogoo
04eoo`00Bgoo00<1WgooOol0>goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol01Goo00<0
07ooOol03goo0P6O@Goo00<1WgooOol0CGoo001;Ool00`6OOomoo`0kOol00`00Oomoo`02Ool00`00
Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`0AOol00`6OOomoo`0mOol00`6OOomoo`1>Ool004Yo
o`030Imoogoo03aoo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol00006Ool00`00Oomo
o`0BOol00`6OOomoo`0kOol00`6OOomoo`1?Ool004Yoo`030Imoogoo03eoo`@000aoo`<000Moo`03
001oogoo01=oo`81Wc]oo`030Imoogoo04moo`00BGoo00<1WgooOol0F7oo00<007ooOol05Goo00<1
WgooOol0=goo00<1WgooOol0D7oo0019Ool00`6OOomoo`1HOol00`00Oomoo`0FOol00`6OOomoo`0e
Ool00`6OOomoo`1AOol004Qoo`030Imoogoo05Uoo`03001oogoo01Moo`81WcAoo`030Imoogoo059o
o`00B7oo00<1WgooOol0FGoo00<007ooOol06Goo00<1WgooOol0;goo0P6OEGoo0018Ool00`6OOomo
o`1IOol00`00Oomoo`0JOol20Il^Ool00`6OOomoo`1EOol004Moo`030Imoogoo05Yoo`8001eoo`03
0Imoogoo02Yoo`030Imoogoo05Ioo`00Agoo00<1WgooOol0FWoo00<007ooOol07Goo0P6O:Goo00<1
WgooOol0Egoo0016Ool00`6OOomoo`1KOol00`00Oomoo`0OOol00`6OOomoo`0UOol00`6OOomoo`1H
Ool004Ioo`030Imoogoo05]oo`03001oogoo021oo`81Wb=oo`81We]oo`00AGoo00<1WgooOol0G7oo
00<007ooOol08Woo0P6O87oo00<1WgooOol0Fgoo0015Ool00`6OOomoo`1LOol00`00Oomoo`0TOol3
0IlKOol20ImNOol004Eoo`030Imoogoo05aoo`03001oogoo02Moo`<1WaIoo`81Wf1oo`00A7oo00<1
WgooOol0GGoo00<007ooOol0:Woo0`6O4Goo0P6OHWoo0014Ool00`6OOomoo`1MOol00`00Oomoo`0]
Ool40Il7Ool60ImTOol004=oo`030Imoogoo05ioo`80039oo`L1WfYoo`00@goo00<1WgooOol0GWoo
00<007ooOol0XWoo0013Ool00`6OOomoo`1NOol00`00Oomoo`2ROol0049oo`030Imoogoo05moo`03
001oogoo0:9oo`00@Woo00<1WgooOol0Ggoo00<007ooOol0XWoo0011Ool00`6OOomoo`1POol00`00
Oomoo`2ROol0045oo`030Imoogoo061oo`03001oogoo0:9oo`00@Goo00<1WgooOol0H7oo00<007oo
Ool0XWoo0010Ool00`6OOomoo`1QOol00`00Oomoo`2ROol0041oo`030Imoogoo065oo`03001oogoo
0:9oo`00@7oo00<1WgooOol0HGoo0P00Xgoo000oOol00`6OOomoo`1ROol00`00Oomoo`2ROol003mo
o`030Imoogoo069oo`03001oogoo0:9oo`00?Woo00<1WgooOol0Hgoo00<007ooOol0XWoo000nOol0
0`6OOomoo`1SOol00`00Oomoo`2ROol003ioo`030Imoogoo06=oo`03001oogoo0:9oo`00?Goo00<1
WgooOol0I7oo00<007ooOol0XWoo000mOol00`6OOomoo`1:Ool40005Ool20007Ool30005Ool00`00
Oomoo`2ROol003eoo`030Imoogoo04Uoo`03001oogoo009oo`03001oogoo009oo`8000Qoo`03001o
ogoo00Aoo`03001oogoo0:9oo`00?Goo00<1WgooOol0BGoo00<007ooOol00Woo00<007ooOol037oo
00<007ooOol017oo00<007ooOol0XWoo000lOol00`6OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomo
o`08Ool60005Ool3002ROol003aoo`030Imoogoo04Yoo`03001oogoo009oo`03001oogoo00Uoo`04
001oogoo0006Ool00`00Oomoo`2ROol003aoo`030Imoogoo04Yoo`03001oogoo009oo`03001oogoo
00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol003]oo`030Imoogoo04]oo`03001oogoo009oo`03
001oogoo00Yoo`03001oo`0000Ioo`03001oogoo0:9oo`00>goo00<1WgooOol0C7oo10003Woo0P00
1Woo00<007ooOol0XWoo000kOol00`6OOomoo`1VOol00`00Oomoo`2ROol003Yoo`030Imoogoo06Mo
o`03001oogoo0:9oo`00>Woo00<1WgooOol0Igoo00<007ooOol0XWoo000jOol00`6OOomoo`1WOol0
0`00Oomoo`2ROol003Yoo`030Imoogoo06Moo`03001oogoo0:9oo`00>Goo00<1WgooOol0J7oo0P00
Xgoo000iOol00`6OOomoo`1XOol00`00Oomoo`2ROol003Uoo`030Imoogoo06Qoo`03001oogoo0:9o
o`00>7oo00<1WgooOol0JGoo00<007ooOol0XWoo000hOol00`6OOomoo`1YOol00`00Oomoo`2ROol0
03Qoo`030Imoogoo06Uoo`03001oogoo0:9oo`00>7oo00<1WgooOol0JGoo00<007ooOol0XWoo000g
Ool00`6OOomoo`1ZOol00`00Oomoo`2ROol003Moo`030Imoogoo06Yoo`03001oogoo0:9oo`00=goo
00<1WgooOol0JWoo00<007ooOol0XWoo000fOol00`6OOomoo`1[Ool2002SOol003Ioo`030Imoogoo
06]oo`03001oogoo0:9oo`00=Woo00<1WgooOol0Jgoo00<007ooOol0XWoo000fOol00`6OOomoo`1[
Ool00`00Oomoo`2ROol003Eoo`030Imoogoo06aoo`03001oogoo0:9oo`00=Goo00<1WgooOol0K7oo
00<007ooOol0XWoo000eOol00`6OOomoo`1/Ool00`00Oomoo`2ROol003Aoo`030Imoogoo06eoo`03
001oogoo0:9oo`00=7oo00<1WgooOol0KGoo00<007ooOol0XWoo000dOol00`6OOomoo`1]Ool00`00
Oomoo`2ROol003=oo`030Imoogoo06ioo`800:=oo`00<goo00<1WgooOol0KWoo00<007ooOol0XWoo
000cOol00`6OOomoo`1^Ool00`00Oomoo`2ROol003=oo`030Imoogoo06ioo`03001oogoo0:9oo`00
<Woo00<1WgooOol0Kgoo00<007ooOol0XWoo000bOol00`6OOomoo`1_Ool00`00Oomoo`2ROol0039o
o`030Imoogoo06moo`03001oogoo0:9oo`00<Goo00<1WgooOol0L7oo00<007ooOol0XWoo000aOol0
0`6OOomoo`1`Ool00`00Oomoo`2ROol0035oo`030Imoogoo071oo`03001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .1 1 r
.5 Mabswid
.13013 .61803 m
.14415 .56071 L
.18221 .4417 L
.20342 .3895 L
.22272 .3501 L
.24299 .31644 L
.26171 .29192 L
.28086 .27286 L
.29094 .26511 L
.30164 .25852 L
.31105 .25404 L
.31624 .25208 L
.32117 .25053 L
.32574 .24937 L
.33073 .2484 L
.33293 .24806 L
.33527 .24777 L
.33747 .24755 L
.33947 .2474 L
.34068 .24733 L
.3418 .24728 L
.34303 .24724 L
.34435 .24722 L
.34501 .24721 L
.34573 .24721 L
.34704 .24723 L
.34832 .24726 L
.3495 .24731 L
.3506 .24737 L
.35162 .24743 L
.35397 .24762 L
.35626 .24786 L
.35872 .24818 L
.36401 .24906 L
.36958 .25028 L
.37954 .25317 L
.38909 .25673 L
.39928 .26133 L
.41765 .27145 L
.45915 .30102 L
.49913 .33459 L
.5376 .36743 L
.57851 .39853 L
.59887 .4111 L
.60882 .4163 L
.61792 .42043 L
.62666 .42379 L
.63618 .42672 L
.64141 .42797 L
.64625 .42891 L
Mistroke
.65088 .42959 L
.65346 .42988 L
.6558 .43008 L
.65693 .43016 L
.65814 .43022 L
.65883 .43025 L
.65946 .43028 L
.6607 .43031 L
.66197 .43033 L
.66268 .43033 L
.66335 .43033 L
.66456 .43032 L
.66585 .43028 L
.66695 .43024 L
.66812 .43017 L
.67025 .43002 L
.67278 .42977 L
.67509 .42948 L
.67994 .42866 L
.68525 .42743 L
.69078 .42578 L
.69592 .4239 L
.70647 .41893 L
.71642 .41283 L
.73502 .39749 L
.75507 .3748 L
.77354 .34778 L
.81299 .26834 L
.85093 .16084 L
.89133 .00861 L
Mfstroke
.89133 .00861 m
.89311 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00NWoo00<0GgooOol09Goo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0NGoo00<0Ggoo
Ool09Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0NGoo
00<0GgooOol09Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`1iOol00`1OOomoo`0VOol008Yoo`@000ioo`8000Ioo`03001oogoo07Qoo`0305moogoo02Moo`00
Y7oo00<007ooOol0N7oo00<0GgooOol09goo002TOol00`00Oomoo`1hOol00`1OOomoo`0WOol00:Ao
o`03001oogoo07Qoo`0305moogoo02Moo`00Y7oo00<007ooOol0Mgoo00<0GgooOol0:7oo002TOol0
0`00Oomoo`1gOol00`1OOomoo`0XOol00:Aoo`8007Qoo`0305moogoo02Qoo`00Y7oo00<007ooOol0
Mgoo00<0GgooOol0:7oo002TOol00`00Oomoo`1fOol00`1OOomoo`0YOol00:Aoo`03001oogoo07Io
o`0305moogoo02Uoo`00Y7oo00<007ooOol0MWoo00<0GgooOol0:Goo002TOol00`00Oomoo`1fOol0
0`1OOomoo`0YOol00:Aoo`03001oogoo07Eoo`0305moogoo02Yoo`00Y7oo00<007ooOol0MGoo00<0
GgooOol0:Woo002TOol00`00Oomoo`1eOol00`1OOomoo`0ZOol00:Aoo`8007Eoo`0305moogoo02]o
o`00Y7oo00<007ooOol0M7oo00<0GgooOol0:goo002TOol00`00Oomoo`1dOol00`1OOomoo`0[Ool0
0:Aoo`03001oogoo07Aoo`0305moogoo02]oo`00Y7oo00<007ooOol0Lgoo00<0GgooOol0;7oo002T
Ool00`00Oomoo`1cOol00`1OOomoo`0/Ool00:Aoo`03001oogoo07=oo`0305moogoo02aoo`00Y7oo
00<007ooOol0Lgoo00<0GgooOol0;7oo002TOol00`00Oomoo`1bOol00`1OOomoo`0]Ool00:Aoo`03
001oogoo079oo`0305moogoo02eoo`00Y7oo0P00Lgoo00<0GgooOol0;Goo002TOol00`00Oomoo`1b
Ool00`1OOomoo`0]Ool00:Aoo`03001oogoo075oo`0305moogoo02ioo`00Y7oo00<007ooOol0LGoo
00<0GgooOol0;Woo002TOol00`00Oomoo`1aOol00`1OOomoo`0^Ool00:Aoo`03001oogoo075oo`03
05moogoo02ioo`00Y7oo00<007ooOol0L7oo00<0GgooOol0;goo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1`Ool00`1OOomoo`0_Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1`Ool00`1OOomoo`0_Ool008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo06moo`0305moogoo031oo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00Kgoo00<0GgooOol0<7oo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1_Ool00`1OOomoo`0`Ool008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo06moo`0305moogoo031o
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo06ioo`03
05moogoo035oo`00RWoo100037oo0`001goo00<007ooOol0KWoo00<0GgooOol0<Goo002TOol00`00
Oomoo`1^Ool00`1OOomoo`0aOol00:Aoo`03001oogoo06ioo`0305moogoo035oo`00Y7oo00<007oo
Ool0KGoo00<0GgooOol0<Woo002TOol00`00Oomoo`1]Ool00`1OOomoo`0bOol00:Aoo`03001oogoo
06eoo`0305moogoo039oo`00Y7oo0P00KWoo00<0GgooOol0<Woo002TOol00`00Oomoo`1/Ool00`1O
Oomoo`0cOol00:Aoo`03001oogoo06aoo`0305moogoo03=oo`00Y7oo00<007ooOol0K7oo00<0Ggoo
Ool0<goo002TOol00`00Oomoo`1[Ool00`1OOomoo`0dOol00:Aoo`03001oogoo06]oo`0305moogoo
03Aoo`00Y7oo00<007ooOol0Jgoo00<0GgooOol0=7oo002TOol00`00Oomoo`1ZOol00`1OOomoo`0e
Ool00:Aoo`03001oogoo06Yoo`0305moogoo03Eoo`00Y7oo00<007ooOol0JWoo00<0GgooOol0=Goo
002TOol2001ZOol00`1OOomoo`0fOol00:Aoo`03001oogoo06Uoo`0305moogoo03Ioo`00Y7oo00<0
07ooOol0J7oo00<0GgooOol0=goo002TOol00`00Oomoo`1XOol00`1OOomoo`0gOol000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D001eoo`0305moogoo02Ioo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo01aoo`0305moogoo02Moo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo01ao
o`0305moogoo02Qoo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol077oo00<0GgooOol0:Goo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0KOol00`1OOomoo`0[Ool0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
01]oo`0305moogoo02aoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<001eoo`0305moogoo02Qoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo01Yoo`0305moogoo02Yoo`<000eoo`00Y7oo00<007ooOol0IGoo00<0
GgooOol0>Woo002TOol00`00Oomoo`1UOol00`1OOomoo`0jOol00:Aoo`03001oogoo06Aoo`0305mo
ogoo03]oo`00Y7oo00<007ooOol0I7oo00<0GgooOol0>goo002TOol00`00Oomoo`1TOol00`1OOomo
o`0kOol00:Aoo`03001oogoo06=oo`0305moogoo03aoo`00Y7oo00<007ooOol0Hgoo00<0GgooOol0
?7oo0004Oom]000405nD00000`1O0000000h0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`04001oogooOol6
05l4Ool705l9Ool00`00Oomoo`0<Ool00`00Oomoo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool0
0`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool0
0`1OOomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool0
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo
00aoo`03001oogoo00aoo`04001oo`1O05l;Ool00`00Oomoo`03Ool305l6Ool00`00Oomoo`0<Ool0
0`00Oomoo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool0
0`00Oomoo`0<Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool00`1OOomoo`02Ool00`00Oomoo`0<Ool0
0`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool006Ioo`<0GaIoo`80Gb=oo`03001oogoo
065oo`0305moogoo03ioo`00I7oo0P1O6goo0P1O8Goo00<007ooOol0HGoo00<0GgooOol0?Woo001R
Ool205lOOol205lOOol00`00Oomoo`1QOol00`1OOomoo`0nOol0065oo`0305moogoo025oo`80Gaeo
o`03001oogoo061oo`0305moogoo03moo`00H7oo00<0GgooOol097oo0P1O6goo00<007ooOol0H7oo
00<0GgooOol0?goo001OOol00`1OOomoo`0WOol00`1OOomoo`0HOol00`00Oomoo`1POol00`1OOomo
o`0oOol005ioo`0305moogoo02Uoo`80GaQoo`03001oogoo05moo`0305moogoo041oo`00GGoo00<0
GgooOol0;7oo00<0GgooOol05Goo0P00H7oo00<0GgooOol0@7oo001LOol00`1OOomoo`0^Ool00`1O
Oomoo`0DOol00`00Oomoo`1NOol00`1OOomoo`11Ool005]oo`0305moogoo031oo`80GaAoo`03001o
ogoo05ioo`0305moogoo045oo`00FWoo00<0GgooOol0<goo00<0GgooOol04Goo00<007ooOol0GGoo
00<0GgooOol0@Woo001IOol00`1OOomoo`0eOol205lAOol00`00Oomoo`1MOol00`1OOomoo`12Ool0
05Qoo`0305moogoo03Qoo`0305moogoo00ioo`03001oogoo05aoo`0305moogoo04=oo`00Egoo00<0
GgooOol0>Woo00<0GgooOol03Goo00<007ooOol0G7oo00<0GgooOol0@goo001FOol00`1OOomoo`0l
Ool205l=Ool00`00Oomoo`1KOol00`1OOomoo`14Ool005Eoo`0305moogoo03moo`0305moogoo00Yo
o`03001oogoo05]oo`0305moogoo04Aoo`00EGoo00<0GgooOol0@7oo00<0GgooOol02Goo00<007oo
Ool0FWoo00<0GgooOol0AGoo001DOol00`1OOomoo`12Ool00`1OOomoo`08Ool2001KOol00`1OOomo
o`15Ool005=oo`0305moogoo04Aoo`80G`Qoo`03001oogoo05Uoo`0305moogoo04Ioo`00DWoo00<0
GgooOol0Agoo00<0GgooOol01Goo00<007ooOol0FGoo00<0GgooOol0AWoo001AOol00`1OOomoo`19
Ool00`1OOomoo`04Ool00`00Oomoo`1HOol00`1OOomoo`17Ool0055oo`0305moogoo04Yoo`0305mo
ogoo00=oo`03001oogoo05Qoo`0305moogoo04Moo`00D7oo00<0GgooOol0C7oo00<0GgooOol00Woo
00<007ooOol0Egoo00<0GgooOol0B7oo001?Ool00`1OOomoo`1>Ool205l2Ool00`00Oomoo`1GOol0
0`1OOomoo`18Ool004moo`0305moogoo051oo`0305moo`0005Qoo`0305moogoo04Uoo`00CWoo00<0
GgooOol0DWoo00<0G`00Ool0Egoo00<0GgooOol0BGoo001>Ool00`1OOomoo`1COol00`1OOomoo`1E
Ool00`1OOomoo`1:Ool004eoo`0305moogoo05Aoo`030000Ggoo05Eoo`0305moogoo04Yoo`00C7oo
00<0GgooOol0EGoo00@007oo05l0Ge=oo`0305moogoo04]oo`00C7oo00<0GgooOol0EGoo00D007oo
Oomoo`1O059oo`0305moogoo04]oo`00Bgoo00<0GgooOol0EWoo00<007ooOol00Woo00<0GgooOol0
CWoo00<0GgooOol0C7oo001;Ool00`1OOomoo`1FOol00`00Oomoo`03Ool00`1OOomoo`1=Ool00`1O
Oomoo`1<Ool004Yoo`0305moogoo05Moo`03001oogoo00Aoo`0305moogoo04]oo`0305moogoo04eo
o`00BWoo00<0GgooOol0Egoo00<007ooOol01Goo0P1OBWoo00<0GgooOol0CWoo0019Ool00`1OOomo
o`0nOol40005Ool20004Ool50006Ool00`00Oomoo`07Ool00`1OOomoo`17Ool00`1OOomoo`1>Ool0
04Uoo`0305moogoo03eoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol00006
Ool00`00Oomoo`08Ool00`1OOomoo`15Ool00`1OOomoo`1?Ool004Qoo`0305moogoo03ioo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo00Uoo`0305moogoo04=oo`0305mo
ogoo051oo`00B7oo00<0GgooOol0?Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo
0`002Woo00<0GgooOol0@Woo00<0GgooOol0D7oo0017Ool00`1OOomoo`0oOol00`00Oomoo`02Ool0
0`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`0;Ool205m1Ool00`1OOomoo`1AOol004Moo`03
05moogoo03moo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo00eoo`03
05moogoo03eoo`0305moogoo059oo`00AWoo00<0GgooOol0@7oo00<007ooOol00Woo00<007ooOol0
27oo00D007ooOomoo`0000Ioo`03001oogoo00ioo`0305moogoo03]oo`0305moogoo05=oo`00AWoo
00<0GgooOol0@Goo100037oo0`001goo00<007ooOol03goo0P1O>Woo00<0GgooOol0E7oo0015Ool0
0`1OOomoo`1LOol00`00Oomoo`0AOol00`1OOomoo`0fOol00`1OOomoo`1EOol004Eoo`0305moogoo
05aoo`03001oogoo019oo`0305moogoo03Aoo`0305moogoo05Ioo`00AGoo00<0GgooOol0G7oo00<0
07ooOol04goo0P1O<goo00<0GgooOol0Egoo0014Ool00`1OOomoo`1MOol00`00Oomoo`0EOol00`1O
Oomoo`0_Ool00`1OOomoo`1HOol004Aoo`0305moogoo05eoo`03001oogoo01Ioo`0305moogoo02eo
o`0305moogoo05Uoo`00@goo00<0GgooOol0GWoo0P0067oo0P1O;7oo00<0GgooOol0FWoo0013Ool0
0`1OOomoo`1NOol00`00Oomoo`0IOol00`1OOomoo`0XOol00`1OOomoo`1KOol0049oo`0305moogoo
05moo`03001oogoo01Yoo`80GbMoo`0305moogoo05aoo`00@Woo00<0GgooOol0Ggoo00<007ooOol0
77oo0P1O97oo00<0GgooOol0GGoo0011Ool00`1OOomoo`1POol00`00Oomoo`0NOol205lPOol205mP
Ool0045oo`0305moogoo061oo`03001oogoo021oo`80Gaaoo`80Gf9oo`00@Goo00<0GgooOol0H7oo
00<007ooOol08Woo0P1O67oo0P1OI7oo0010Ool00`1OOomoo`1QOol00`00Oomoo`0TOol305lBOol3
05mVOol0041oo`0305moogoo065oo`03001oogoo02Moo`L0G`Ioo`D0GfUoo`00?goo00<0GgooOol0
HWoo0P00;Woo201OKGoo000oOol00`1OOomoo`1ROol00`00Oomoo`2ROol003ioo`0305moogoo06=o
o`03001oogoo0:9oo`00?Woo00<0GgooOol0Hgoo00<007ooOol0XWoo000nOol00`1OOomoo`1SOol0
0`00Oomoo`2ROol003eoo`0305moogoo06Aoo`03001oogoo0:9oo`00?Goo00<0GgooOol0I7oo00<0
07ooOol0XWoo000mOol00`1OOomoo`1TOol00`00Oomoo`2ROol003aoo`0305moogoo06Eoo`03001o
ogoo0:9oo`00?7oo00<0GgooOol0IGoo00<007ooOol0XWoo000lOol00`1OOomoo`1UOol2002SOol0
03]oo`0305moogoo06Ioo`03001oogoo0:9oo`00>goo00<0GgooOol0IWoo00<007ooOol0XWoo000k
Ool00`1OOomoo`1VOol00`00Oomoo`2ROol003]oo`0305moogoo06Ioo`03001oogoo0:9oo`00>Woo
00<0GgooOol0Igoo00<007ooOol0XWoo000jOol00`1OOomoo`1WOol00`00Oomoo`2ROol003Yoo`03
05moogoo04eoo`@000Eoo`8000Moo`<000Eoo`03001oogoo0:9oo`00>Goo00<0GgooOol0CGoo00<0
07ooOol00Woo00<007ooOol00Woo0P0027oo00<007ooOol017oo00<007ooOol0XWoo000iOol00`1O
Oomoo`1=Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`2ROol003Uo
o`0305moogoo04eoo`03001oogoo009oo`03001oogoo00Qoo`H000Eoo`<00:9oo`00>7oo00<0Ggoo
Ool0CWoo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo0:9oo`00>7oo
00<0GgooOol0CWoo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo0:9o
o`00>7oo00<0GgooOol0CWoo00<007ooOol00Woo00<007ooOol02Woo00<007oo00001Woo00<007oo
Ool0XWoo000gOol00`1OOomoo`1@Ool4000>Ool20006Ool00`00Oomoo`2ROol003Moo`0305moogoo
06Yoo`03001oogoo0:9oo`00=goo00<0GgooOol0JWoo00<007ooOol0XWoo000fOol00`1OOomoo`1[
Ool00`00Oomoo`2ROol003Ioo`0305moogoo06]oo`03001oogoo0:9oo`00=Woo00<0GgooOol0Jgoo
00<007ooOol0XWoo000eOol00`1OOomoo`1/Ool2002SOol003Eoo`0305moogoo06aoo`03001oogoo
0:9oo`00=Goo00<0GgooOol0K7oo00<007ooOol0XWoo000eOol00`1OOomoo`1/Ool00`00Oomoo`2R
Ool003Aoo`0305moogoo06eoo`03001oogoo0:9oo`00=7oo00<0GgooOol0KGoo00<007ooOol0XWoo
000dOol00`1OOomoo`1]Ool00`00Oomoo`2ROol003=oo`0305moogoo06ioo`03001oogoo0:9oo`00
<goo00<0GgooOol0KWoo00<007ooOol0XWoo000cOol00`1OOomoo`1^Ool00`00Oomoo`2ROol0039o
o`0305moogoo06moo`800:=oo`00<Woo00<0GgooOol0Kgoo00<007ooOol0XWoo000bOol00`1OOomo
o`1_Ool00`00Oomoo`2ROol0039oo`0305moogoo06moo`03001oogoo0:9oo`00<Goo00<0GgooOol0
L7oo00<007ooOol0XWoo000aOol00`1OOomoo`1`Ool00`00Oomoo`2ROol0035oo`0305moogoo071o
o`03001oogoo0:9oo`00<Goo00<0GgooOol0L7oo00<007ooOol0XWoo000`Ool00`1OOomoo`1aOol0
0`00Oomoo`2ROol0031oo`0305moogoo075oo`03001oogoo0:9oo`00<7oo00<0GgooOol0LGoo0P00
Xgoo000`Ool00`1OOomoo`1aOol00`00Oomoo`2ROol0031oo`0305moogoo075oo`03001oogoo0:9o
o`00;goo00<0GgooOol0LWoo00<007ooOol0XWoo000_Ool00`1OOomoo`1bOol00`00Oomoo`2ROol0
02moo`0305moogoo079oo`03001oogoo0:9oo`00;goo00<0GgooOol0LWoo00<007ooOol0XWoo000^
Ool00`1OOomoo`1cOol00`00Oomoo`2ROol002ioo`0305moogoo07=oo`03001oogoo0:9oo`00;Woo
00<0GgooOol0Lgoo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 0 1 r
.5 Mabswid
.11818 .61803 m
.14415 .51981 L
.18221 .41122 L
.20342 .36432 L
.22272 .32941 L
.24299 .30014 L
.26171 .27938 L
.28086 .26388 L
.29094 .25788 L
.30164 .25305 L
.31105 .25005 L
.31634 .24884 L
.31885 .24839 L
.32117 .24804 L
.32353 .24775 L
.32566 .24754 L
.32803 .24737 L
.32933 .2473 L
.33056 .24726 L
.33164 .24723 L
.33279 .24722 L
.33377 .24721 L
.33484 .24723 L
.336 .24725 L
.33724 .2473 L
.33841 .24735 L
.33947 .24742 L
.34176 .24759 L
.34428 .24785 L
.34939 .24857 L
.35412 .24947 L
.35856 .2505 L
.36855 .25347 L
.37932 .25763 L
.39936 .26768 L
.42046 .28102 L
.45857 .31022 L
.49913 .34488 L
.53817 .37755 L
.55809 .39261 L
.57967 .40688 L
.60047 .41799 L
.61038 .42219 L
.61965 .42539 L
.6287 .4278 L
.63378 .42881 L
.63842 .42952 L
.64105 .42983 L
.64348 .43005 L
.64486 .43015 L
Mistroke
.64616 .43022 L
.64688 .43025 L
.64765 .43028 L
.64836 .4303 L
.64901 .43032 L
.65021 .43033 L
.65134 .43033 L
.65257 .43032 L
.6539 .43028 L
.65456 .43026 L
.65528 .43022 L
.6566 .43015 L
.65906 .42996 L
.6614 .42971 L
.66392 .42937 L
.66848 .42857 L
.6739 .42728 L
.67887 .42578 L
.68912 .42168 L
.69989 .41584 L
.71967 .40073 L
.73805 .38122 L
.75855 .35272 L
.77715 .32021 L
.81718 .22669 L
.8557 .10297 L
Mfstroke
.8557 .10297 m
.88018 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00MWoo00<D7gooOol0:Goo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0MWoo00<D7goo
Ool0:Goo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0MGoo
00<D7gooOol0:Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`1eOol00a@OOomoo`0ZOol008Yoo`@000ioo`8000Ioo`03001oogoo07Eoo`0351moogoo02Yoo`00
Y7oo00<007ooOol0MGoo00<D7gooOol0:Woo002TOol00`00Oomoo`1dOol00a@OOomoo`0[Ool00:Ao
o`03001oogoo07Aoo`0351moogoo02]oo`00Y7oo00<007ooOol0M7oo00<D7gooOol0:goo002TOol0
0`00Oomoo`1dOol00a@OOomoo`0[Ool00:Aoo`8007Aoo`0351moogoo02aoo`00Y7oo00<007ooOol0
Lgoo00<D7gooOol0;7oo002TOol00`00Oomoo`1cOol00a@OOomoo`0/Ool00:Aoo`03001oogoo07=o
o`0351moogoo02aoo`00Y7oo00<007ooOol0LWoo00<D7gooOol0;Goo002TOol00`00Oomoo`1bOol0
0a@OOomoo`0]Ool00:Aoo`03001oogoo079oo`0351moogoo02eoo`00Y7oo00<007ooOol0LWoo00<D
7gooOol0;Goo002TOol00`00Oomoo`1aOol00a@OOomoo`0^Ool00:Aoo`80079oo`0351moogoo02io
o`00Y7oo00<007ooOol0LGoo00<D7gooOol0;Woo002TOol00`00Oomoo`1aOol00a@OOomoo`0^Ool0
0:Aoo`03001oogoo071oo`0351moogoo02moo`00Y7oo00<007ooOol0L7oo00<D7gooOol0;goo002T
Ool00`00Oomoo`1`Ool00a@OOomoo`0_Ool00:Aoo`03001oogoo071oo`0351moogoo02moo`00Y7oo
00<007ooOol0Kgoo00<D7gooOol0<7oo002TOol00`00Oomoo`1_Ool00a@OOomoo`0`Ool00:Aoo`03
001oogoo06moo`0351moogoo031oo`00Y7oo0P00L7oo00<D7gooOol0<7oo002TOol00`00Oomoo`1^
Ool00a@OOomoo`0aOol00:Aoo`03001oogoo06ioo`0351moogoo035oo`00Y7oo00<007ooOol0KWoo
00<D7gooOol0<Goo002TOol00`00Oomoo`1^Ool00a@OOomoo`0aOol00:Aoo`03001oogoo06eoo`03
51moogoo039oo`00Y7oo00<007ooOol0KGoo00<D7gooOol0<Woo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1]Ool00a@OOomoo`0bOol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1/Ool00a@OOomoo`0cOol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo06aoo`0351moogoo03=oo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00K7oo00<D7gooOol0<goo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1/Ool00a@OOomoo`0cOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo06]oo`0351moogoo03Ao
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo06]oo`03
51moogoo03Aoo`00RWoo100037oo0`001goo00<007ooOol0Jgoo00<D7gooOol0=7oo002TOol00`00
Oomoo`1ZOol00a@OOomoo`0eOol00:Aoo`03001oogoo06Yoo`0351moogoo03Eoo`00Y7oo00<007oo
Ool0JWoo00<D7gooOol0=Goo002TOol00`00Oomoo`1YOol00a@OOomoo`0fOol00:Aoo`03001oogoo
06Uoo`0351moogoo03Ioo`00Y7oo0P00JWoo00<D7gooOol0=Woo002TOol00`00Oomoo`1YOol00a@O
Oomoo`0fOol00:Aoo`03001oogoo06Qoo`0351moogoo03Moo`00Y7oo00<007ooOol0J7oo00<D7goo
Ool0=goo002TOol00`00Oomoo`1XOol00a@OOomoo`0gOol00:Aoo`03001oogoo06Moo`0351moogoo
03Qoo`00Y7oo00<007ooOol0Igoo00<D7gooOol0>7oo002TOol00`00Oomoo`1WOol00a@OOomoo`0h
Ool00:Aoo`03001oogoo06Ioo`0351moogoo03Uoo`00Y7oo00<007ooOol0IWoo00<D7gooOol0>Goo
002TOol2001WOol00a@OOomoo`0iOol00:Aoo`03001oogoo06Ioo`0351moogoo03Uoo`00Y7oo00<0
07ooOol0IGoo00<D7gooOol0>Woo002TOol00`00Oomoo`1UOol00a@OOomoo`0jOol000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D001Yoo`0351moogoo02Uoo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo01Uoo`0351moogoo02Yoo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo01Uo
o`0351moogoo02]oo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol06Goo00<D7gooOol0;7oo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0HOol00a@OOomoo`0^Ool0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
01Qoo`0351moogoo02moo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<001Yoo`0351moogoo02]oo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo01Qoo`0351moogoo02aoo`<000eoo`00Y7oo00<007ooOol0HWoo00<D
7gooOol0?Goo002TOol00`00Oomoo`1ROol00a@OOomoo`0mOol00:Aoo`03001oogoo069oo`0351mo
ogoo03eoo`00Y7oo00<007ooOol0HGoo00<D7gooOol0?Woo002TOol00`00Oomoo`1QOol00a@OOomo
o`0nOol00:Aoo`03001oogoo061oo`0351moogoo03moo`00Y7oo00<007ooOol0H7oo00<D7gooOol0
?goo0004OomY000551nD00000a@O0000000k0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00]oo`LD7`Aoo`PD7`ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00Aoo`0351moogoo00Eo
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`0037oo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007oo
Ool02Goo0Q@O00=oo`00Ool03Goo00<007ooOol00Q@O2Woo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo
00<007ooOol03Goo00<007ooOol017oo00<D7gooOol01Goo00<007ooOol037oo00<007ooOol037oo
00<007ooOol037oo00<007ooOol02goo001ROol251lGOol251lWOol00`00Oomoo`1NOol00a@OOomo
o`11Ool0065oo`0351moogoo01Uoo`8D7bEoo`03001oogoo05ioo`0351moogoo045oo`00Ggoo0Q@O
7Woo0Q@O8goo00<007ooOol0GGoo00<D7gooOol0@Woo001NOol00a@OOomoo`0POol251lQOol00`00
Oomoo`1MOol00a@OOomoo`12Ool005eoo`0351moogoo02=oo`8D7amoo`03001oogoo05aoo`0351mo
ogoo04=oo`00G7oo00<D7gooOol09Woo0Q@O7Goo00<007ooOol0G7oo00<D7gooOol0@goo001JOol2
51l[Ool00a@OOomoo`0JOol00`00Oomoo`1KOol00a@OOomoo`14Ool005Uoo`0351moogoo02aoo`8D
7aYoo`8005aoo`0351moogoo04Aoo`00F7oo00<D7gooOol0;goo00<D7gooOol05goo00<007ooOol0
Fgoo00<D7gooOol0A7oo001GOol00a@OOomoo`0aOol00a@OOomoo`0FOol00`00Oomoo`1JOol00a@O
Oomoo`15Ool005Ioo`0351moogoo03=oo`8D7aIoo`03001oogoo05Yoo`0351moogoo04Eoo`00EGoo
00<D7gooOol0=Woo00<D7gooOol04goo00<007ooOol0FGoo00<D7gooOol0AWoo001DOol00a@OOomo
o`0hOol00a@OOomoo`0BOol00`00Oomoo`1IOol00a@OOomoo`16Ool005=oo`0351moogoo03Yoo`8D
7a9oo`03001oogoo05Qoo`0351moogoo04Moo`00DWoo00<D7gooOol0?Goo00<D7gooOol03goo00<0
07ooOol0F7oo00<D7gooOol0Agoo001AOol00a@OOomoo`0oOol00a@OOomoo`0>Ool00`00Oomoo`1H
Ool00a@OOomoo`17Ool0055oo`0351moogoo041oo`8D7`ioo`03001oogoo05Moo`0351moogoo04Qo
o`00D7oo00<D7gooOol0@goo00<D7gooOol02goo0P00F7oo00<D7gooOol0B7oo001?Ool00a@OOomo
o`15Ool00a@OOomoo`0:Ool00`00Oomoo`1FOol00a@OOomoo`19Ool004ioo`0351moogoo04Moo`03
51moogoo00Uoo`03001oogoo05Ioo`0351moogoo04Uoo`00CWoo00<D7gooOol0B7oo00<D7gooOol0
27oo00<007ooOol0EGoo00<D7gooOol0BWoo001=Ool00a@OOomoo`1:Ool00a@OOomoo`07Ool00`00
Oomoo`1EOol00a@OOomoo`1:Ool004aoo`0351moogoo04aoo`0351moogoo00Ioo`03001oogoo05Ao
o`0351moogoo04]oo`00C7oo00<D7gooOol0CGoo0Q@O1Woo00<007ooOol0E7oo00<D7gooOol0Bgoo
001;Ool00a@OOomoo`1@Ool00a@OOomoo`03Ool00`00Oomoo`1COol00a@OOomoo`1<Ool004Yoo`03
51moogoo059oo`0351moogoo009oo`03001oogoo05=oo`0351moogoo04aoo`00BWoo00<D7gooOol0
Dgoo00DD7gooOomoo`0005Aoo`0351moogoo04eoo`00BGoo00<D7gooOol0EGoo00<D7gooOol00P00
DWoo00<D7gooOol0CWoo0019Ool00a@OOomoo`1FOol00a@OOol0001COol00a@OOomoo`1>Ool004Qo
o`0351moogoo05Qoo`0351l007oo055oo`0351moogoo04moo`00B7oo00<D7gooOol0FGoo00<D7goo
Ool0D7oo00<D7gooOol0Cgoo0017Ool00a@OOomoo`1JOol00`0051lD7`1?Ool00a@OOomoo`1@Ool0
04Moo`0351moogoo05Yoo`04001oogoo51m=Ool00a@OOomoo`1AOol004Ioo`0351moogoo05]oo`05
001oogooOolD7`1;Ool00a@OOomoo`1BOol004Ioo`0351moogoo045oo`@000Eoo`8000Aoo`D000Io
o`03001oogoo009oo`8D7dUoo`0351moogoo059oo`00AGoo00<D7gooOol0@Goo00<007ooOol00Woo
00<007ooOol00Woo0P0017oo00D007ooOomoo`0000Ioo`03001oogoo00Aoo`0351moogoo04Eoo`03
51moogoo05=oo`00AGoo00<D7gooOol0@Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
1goo00<007ooOol01Goo00<D7gooOol0@goo00<D7gooOol0E7oo0014Ool00a@OOomoo`12Ool00`00
Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool30006Ool251m2Ool00a@OOomoo`1EOol004Ao
o`0351moogoo049oo`03001oogoo009oo`03001oogoo00]oo`03001oogoo00Eoo`03001oogoo00Qo
o`0351moogoo03moo`0351moogoo05Eoo`00@goo00<D7gooOol0@goo00<007ooOol00Woo00<007oo
Ool037oo00<007ooOol017oo00<007ooOol02Goo00<D7gooOol0?Goo00<D7gooOol0EWoo0013Ool0
0a@OOomoo`13Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007ooOol0
2Woo00<D7gooOol0>goo00<D7gooOol0Egoo0012Ool00a@OOomoo`15Ool4000<Ool30007Ool00`00
Oomoo`0;Ool00a@OOomoo`0iOol00a@OOomoo`1HOol0049oo`0351moogoo05moo`03001oogoo00ao
o`8D7cQoo`0351moogoo05Uoo`00@Goo00<D7gooOol0H7oo00<007ooOol03Woo00<D7gooOol0=7oo
00<D7gooOol0FWoo0011Ool00a@OOomoo`1POol00`00Oomoo`0?Ool00a@OOomoo`0cOol00a@OOomo
o`1JOol0041oo`0351moogoo065oo`03001oogoo011oo`8D7c9oo`0351moogoo05]oo`00@7oo00<D
7gooOol0HGoo00<007ooOol04Woo0Q@O;goo00<D7gooOol0G7oo000oOol00a@OOomoo`1ROol2000E
Ool251l[Ool251mOOol003moo`0351moogoo069oo`03001oogoo01Ioo`0351moogoo02Moo`0351mo
ogoo05moo`00?Woo00<D7gooOol0Hgoo00<007ooOol05goo0Q@O9Woo00<D7gooOol0H7oo000nOol0
0a@OOomoo`1SOol00`00Oomoo`0IOol251lROol251mSOol003ioo`0351moogoo06=oo`03001oogoo
01]oo`8D7amoo`0351moogoo06=oo`00?Goo00<D7gooOol0I7oo00<007ooOol07Goo0Q@O6goo0Q@O
IWoo000mOol00a@OOomoo`1TOol00`00Oomoo`0OOol351lFOol251mXOol003eoo`0351moogoo06Ao
o`03001oogoo029oo`<D7a5oo`8D7fYoo`00?7oo00<D7gooOol0IGoo00<007ooOol09Goo1A@O1goo
1A@OK7oo000lOol00a@OOomoo`1UOol2000[Ool751maOol003aoo`0351moogoo06Eoo`03001oogoo
0:9oo`00>goo00<D7gooOol0IWoo00<007ooOol0XWoo000kOol00a@OOomoo`1VOol00`00Oomoo`2R
Ool003Yoo`0351moogoo06Moo`03001oogoo0:9oo`00>Woo00<D7gooOol0Igoo00<007ooOol0XWoo
000jOol00a@OOomoo`1WOol00`00Oomoo`2ROol003Uoo`0351moogoo06Qoo`03001oogoo0:9oo`00
>Goo00<D7gooOol0J7oo00<007ooOol0XWoo000iOol00a@OOomoo`1XOol00`00Oomoo`2ROol003Qo
o`0351moogoo06Uoo`800:=oo`00>7oo00<D7gooOol0JGoo00<007ooOol0XWoo000hOol00a@OOomo
o`1YOol00`00Oomoo`2ROol003Moo`0351moogoo06Yoo`03001oogoo0:9oo`00=goo00<D7gooOol0
JWoo00<007ooOol0XWoo000gOol00a@OOomoo`1ZOol00`00Oomoo`2ROol003Ioo`0351moogoo06]o
o`03001oogoo0:9oo`00=Woo00<D7gooOol0DGoo10001Goo0P001goo0`001Goo00<007ooOol0XWoo
000fOol00a@OOomoo`1@Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`04Ool0
0`00Oomoo`2ROol003Eoo`0351moogoo055oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo
00Aoo`03001oogoo0:9oo`00=Goo00<D7gooOol0DGoo00<007ooOol00Woo00<007ooOol027oo1P00
1Goo0`00XWoo000dOol00a@OOomoo`1BOol00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`00
1Woo00<007ooOol0XWoo000dOol00a@OOomoo`1BOol00`00Oomoo`02Ool00`00Oomoo`09Ool01000
Oomoo`001Woo00<007ooOol0XWoo000dOol00a@OOomoo`1BOol00`00Oomoo`02Ool00`00Oomoo`0:
Ool00`00Ool00006Ool00`00Oomoo`2ROol003=oo`0351moogoo05Aoo`@000ioo`8000Ioo`03001o
ogoo0:9oo`00<goo00<D7gooOol0KWoo00<007ooOol0XWoo000cOol00a@OOomoo`1^Ool00`00Oomo
o`2ROol0039oo`0351moogoo06moo`03001oogoo0:9oo`00<Woo00<D7gooOol0Kgoo00<007ooOol0
XWoo000bOol00a@OOomoo`1_Ool00`00Oomoo`2ROol0035oo`0351moogoo071oo`800:=oo`00<Goo
00<D7gooOol0L7oo00<007ooOol0XWoo000aOol00a@OOomoo`1`Ool00`00Oomoo`2ROol0035oo`03
51moogoo071oo`03001oogoo0:9oo`00<7oo00<D7gooOol0LGoo00<007ooOol0XWoo000`Ool00a@O
Oomoo`1aOol00`00Oomoo`2ROol0031oo`0351moogoo075oo`03001oogoo0:9oo`00<7oo00<D7goo
Ool0LGoo00<007ooOol0XWoo000_Ool00a@OOomoo`1bOol00`00Oomoo`2ROol002moo`0351moogoo
079oo`03001oogoo0:9oo`00;goo00<D7gooOol0LWoo0P00Xgoo000_Ool00a@OOomoo`1bOol00`00
Oomoo`2ROol002ioo`0351moogoo07=oo`03001oogoo0:9oo`00;Woo00<D7gooOol0Lgoo00<007oo
Ool0XWoo000^Ool00a@OOomoo`1cOol00`00Oomoo`2ROol002ioo`0351moogoo07=oo`03001oogoo
0:9oo`00;Goo00<D7gooOol0M7oo00<007ooOol0XWoo000]Ool00a@OOomoo`1dOol00`00Oomoo`2R
Ool002eoo`0351moogoo07Aoo`03001oogoo0:9oo`00;Goo00<D7gooOol0M7oo00<007ooOol0XWoo
000/Ool00a@OOomoo`1eOol2002SOol002aoo`0351moogoo07Eoo`03001oogoo0:9oo`00;7oo00<D
7gooOol0MGoo00<007ooOol0XWoo000/Ool00a@OOomoo`1eOol00`00Oomoo`2ROol002]oo`0351mo
ogoo07Ioo`03001oogoo0:9oo`00:goo00<D7gooOol0MWoo00<007ooOol0XWoo000[Ool00a@OOomo
o`1fOol00`00Oomoo`2ROol002]oo`0351moogoo07Ioo`03001oogoo0:9oo`00:Woo00<D7gooOol0
Mgoo00<007ooOol0XWoo000ZOol00a@OOomoo`1gOol00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 0 1 r
.5 Mabswid
.10522 .61803 m
.14415 .4823 L
.18221 .38376 L
.20178 .34486 L
.22272 .31134 L
.24402 .28518 L
.2538 .27569 L
.26416 .26724 L
.27367 .2609 L
.28414 .25539 L
.28872 .25344 L
.29366 .25166 L
.29797 .25036 L
.30258 .24923 L
.30532 .24868 L
.30782 .24825 L
.31035 .2479 L
.31268 .24764 L
.31541 .24741 L
.31684 .24733 L
.31758 .2473 L
.31836 .24727 L
.31968 .24723 L
.32091 .24722 L
.32166 .24721 L
.32238 .24722 L
.32301 .24723 L
.32371 .24724 L
.32495 .24728 L
.32612 .24733 L
.32739 .24741 L
.32877 .2475 L
.33157 .24776 L
.33415 .24807 L
.33885 .24881 L
.3438 .24981 L
.35335 .25239 L
.36354 .25603 L
.38191 .26462 L
.42341 .29176 L
.46339 .32432 L
.50186 .35743 L
.54277 .39014 L
.56313 .40403 L
.58218 .41489 L
.60044 .42293 L
.6107 .42626 L
.62006 .42848 L
.62485 .42929 L
.62747 .42964 L
Mistroke
.62994 .42991 L
.63224 .4301 L
.63354 .43018 L
.63474 .43024 L
.63575 .43028 L
.63685 .43031 L
.63801 .43033 L
.63909 .43033 L
.64038 .43032 L
.64111 .43031 L
.64178 .43029 L
.64302 .43024 L
.64433 .43017 L
.6466 .43001 L
.6491 .42975 L
.65177 .42941 L
.65464 .42894 L
.65983 .42784 L
.6648 .42648 L
.66942 .42493 L
.6799 .42037 L
.69012 .41449 L
.70102 .40655 L
.7224 .38565 L
.74257 .35898 L
.78109 .2872 L
.801 .23831 L
.82206 .1771 L
.86 .0401 L
Mfstroke
.86 .0401 m
.86865 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00LWoo00<l7gooOol0;Goo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0LWoo00<l7goo
Ool0;Goo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0LGoo
00<l7gooOol0;Woo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`1aOol00c`OOomoo`0^Ool008Yoo`@000ioo`8000Ioo`03001oogoo075oo`03?1moogoo02ioo`00
Y7oo00<007ooOol0LGoo00<l7gooOol0;Woo002TOol00`00Oomoo`1`Ool00c`OOomoo`0_Ool00:Ao
o`03001oogoo071oo`03?1moogoo02moo`00Y7oo00<007ooOol0L7oo00<l7gooOol0;goo002TOol0
0`00Oomoo`1`Ool00c`OOomoo`0_Ool00:Aoo`80071oo`03?1moogoo031oo`00Y7oo00<007ooOol0
Kgoo00<l7gooOol0<7oo002TOol00`00Oomoo`1_Ool00c`OOomoo`0`Ool00:Aoo`03001oogoo06mo
o`03?1moogoo031oo`00Y7oo00<007ooOol0KWoo00<l7gooOol0<Goo002TOol00`00Oomoo`1^Ool0
0c`OOomoo`0aOol00:Aoo`03001oogoo06ioo`03?1moogoo035oo`00Y7oo00<007ooOol0KWoo00<l
7gooOol0<Goo002TOol00`00Oomoo`1]Ool00c`OOomoo`0bOol00:Aoo`8006ioo`03?1moogoo039o
o`00Y7oo00<007ooOol0KGoo00<l7gooOol0<Woo002TOol00`00Oomoo`1]Ool00c`OOomoo`0bOol0
0:Aoo`03001oogoo06aoo`03?1moogoo03=oo`00Y7oo00<007ooOol0K7oo00<l7gooOol0<goo002T
Ool00`00Oomoo`1/Ool00c`OOomoo`0cOol00:Aoo`03001oogoo06]oo`03?1moogoo03Aoo`00Y7oo
00<007ooOol0Jgoo00<l7gooOol0=7oo002TOol00`00Oomoo`1[Ool00c`OOomoo`0dOol00:Aoo`03
001oogoo06]oo`03?1moogoo03Aoo`00Y7oo0P00Jgoo00<l7gooOol0=Goo002TOol00`00Oomoo`1Z
Ool00c`OOomoo`0eOol00:Aoo`03001oogoo06Yoo`03?1moogoo03Eoo`00Y7oo00<007ooOol0JWoo
00<l7gooOol0=Goo002TOol00`00Oomoo`1YOol00c`OOomoo`0fOol00:Aoo`03001oogoo06Uoo`03
?1moogoo03Ioo`00Y7oo00<007ooOol0JGoo00<l7gooOol0=Woo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1XOol00c`OOomoo`0gOol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1XOol00c`OOomoo`0gOol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo06Qoo`03?1moogoo03Moo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00J7oo00<l7gooOol0=goo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1WOol00c`OOomoo`0hOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo06Moo`03?1moogoo03Qo
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo06Moo`03
?1moogoo03Qoo`00RWoo100037oo0`001goo00<007ooOol0Igoo00<l7gooOol0>7oo002TOol00`00
Oomoo`1VOol00c`OOomoo`0iOol00:Aoo`03001oogoo06Ioo`03?1moogoo03Uoo`00Y7oo00<007oo
Ool0IWoo00<l7gooOol0>Goo002TOol00`00Oomoo`1UOol00c`OOomoo`0jOol00:Aoo`03001oogoo
06Eoo`03?1moogoo03Yoo`00Y7oo0P00IWoo00<l7gooOol0>Woo002TOol00`00Oomoo`1UOol00c`O
Oomoo`0jOol00:Aoo`03001oogoo06Aoo`03?1moogoo03]oo`00Y7oo00<007ooOol0I7oo00<l7goo
Ool0>goo002TOol00`00Oomoo`1TOol00c`OOomoo`0kOol00:Aoo`03001oogoo06Aoo`03?1moogoo
03]oo`00Y7oo00<007ooOol0Hgoo00<l7gooOol0?7oo002TOol00`00Oomoo`1SOol00c`OOomoo`0l
Ool00:Aoo`03001oogoo06=oo`03?1moogoo03aoo`00Y7oo00<007ooOol0HWoo00<l7gooOol0?Goo
002TOol2001SOol00c`OOomoo`0mOol00:Aoo`03001oogoo069oo`03?1moogoo03eoo`00Y7oo00<0
07ooOol0HGoo00<l7gooOol0?Woo002TOol00`00Oomoo`1QOol00c`OOomoo`0nOol000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D001Ioo`03?1moogoo02eoo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo01Eoo`03?1moogoo02ioo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo01Eo
o`03?1moogoo02moo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol057oo00<l7gooOol0<Goo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0DOol00c`OOomoo`0bOol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
01Aoo`03?1moogoo03=oo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<001Eoo`03?1moogoo031oo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo01=oo`03?1moogoo035oo`<000eoo`00Y7oo00<007ooOol0GWoo00<l
7gooOol0@Goo002TOol00`00Oomoo`1MOol00c`OOomoo`12Ool00:Aoo`03001oogoo05eoo`03?1mo
ogoo049oo`00Y7oo00<007ooOol0GGoo00<l7gooOol0@Woo002TOol00`00Oomoo`1LOol00c`OOomo
o`13Ool00:Aoo`03001oogoo05aoo`03?1moogoo04=oo`00Y7oo00<007ooOol0G7oo00<l7gooOol0
@goo0004OomU0005?1nD00000c`O0000000o0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00Qoo`Hl7`Aoo`Ll7`9o
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`04001oogoo?1l;
Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool000aoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001o
ogoo00Eoo`<l7`Aoo`03001oogoo00Yoo`<l7`ioo`03001oogoo00aoo`03001oogoo00eoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00eoo`03001ooc`O00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00]oo`00Ggoo00<l7gooOol05Goo0S`O:goo00<007ooOol0FWoo00<l7gooOol0AGoo001MOol2
?1lJOol2?1lYOol00`00Oomoo`1JOol00c`OOomoo`15Ool005aoo`03?1moogoo01aoo`8l7bMoo`03
001oogoo05Uoo`03?1moogoo04Ioo`00FWoo0S`O8Goo0S`O9Goo00<007ooOol0FGoo00<l7gooOol0
AWoo001IOol00c`OOomoo`0SOol2?1lSOol00`00Oomoo`1HOol00c`OOomoo`17Ool005Moo`8l7bQo
o`03?1moogoo021oo`03001oogoo05Qoo`03?1moogoo04Moo`00EGoo0S`O:goo0S`O87oo00<007oo
Ool0F7oo00<l7gooOol0Agoo001DOol00c`OOomoo`0]Ool00c`OOomoo`0MOol2001HOol00c`OOomo
o`18Ool005=oo`03?1moogoo02moo`03?1moogoo01aoo`03001oogoo05Moo`03?1moogoo04Qoo`00
Dgoo00<l7gooOol0<7oo0S`O77oo00<007ooOol0EWoo00<l7gooOol0BGoo001BOol00c`OOomoo`0c
Ool00c`OOomoo`0IOol00`00Oomoo`1FOol00c`OOomoo`19Ool0055oo`03?1moogoo03Eoo`8l7aUo
o`03001oogoo05Eoo`03?1moogoo04Yoo`00D7oo00<l7gooOol0>7oo00<l7gooOol05Woo00<007oo
Ool0EGoo00<l7gooOol0BWoo001?Ool00c`OOomoo`0jOol00c`OOomoo`0EOol00`00Oomoo`1DOol0
0c`OOomoo`1;Ool004ioo`03?1moogoo03aoo`8l7aEoo`03001oogoo05Aoo`03?1moogoo04]oo`00
CWoo00<l7gooOol0?Woo00<l7gooOol04Woo00<007ooOol0Dgoo00<l7gooOol0C7oo001=Ool00c`O
Oomoo`10Ool00c`OOomoo`0AOol00`00Oomoo`1COol00c`OOomoo`1<Ool004aoo`03?1moogoo049o
o`8l7a5oo`8005=oo`03?1moogoo04eoo`00Bgoo00<l7gooOol0AGoo00<l7gooOol03Woo00<007oo
Ool0DWoo00<l7gooOol0CGoo001:Ool00c`OOomoo`17Ool00c`OOomoo`0=Ool00`00Oomoo`1AOol0
0c`OOomoo`1>Ool004Yoo`03?1moogoo04Qoo`8l7`eoo`03001oogoo055oo`03?1moogoo04ioo`00
BGoo00<l7gooOol0Bgoo00<l7gooOol02Woo00<007ooOol0D7oo00<l7gooOol0Cgoo0019Ool00c`O
Oomoo`1<Ool00c`OOomoo`09Ool00`00Oomoo`1@Ool00c`OOomoo`1?Ool004Qoo`03?1moogoo04io
o`03?1moogoo00Qoo`03001oogoo04moo`03?1moogoo051oo`00B7oo00<l7gooOol0Cgoo00<l7goo
Ool01goo00<007ooOol0Cgoo00<l7gooOol0D7oo0017Ool00c`OOomoo`1AOol00c`OOomoo`06Ool0
0`00Oomoo`1>Ool00c`OOomoo`1AOol004Moo`03?1moogoo059oo`03?1moogoo00Eoo`03001oogoo
04ioo`03?1moogoo055oo`00AWoo00<l7gooOol0E7oo00<l7gooOol017oo0P00CWoo00<l7gooOol0
DWoo0016Ool00c`OOomoo`1EOol2?1l4Ool00`00Oomoo`1=Ool00c`OOomoo`1BOol004Eoo`03?1mo
ogoo05Qoo`05?1moogooOol0001>Ool00c`OOomoo`1COol004Aoo`03?1moogoo05Yoo`04?1moogoo
001>Ool00c`OOomoo`1COol004Aoo`03?1moogoo05]oo`03?1moo`0004eoo`03?1moogoo05Aoo`00
@goo00<l7gooOol0GGoo00<l7`00Ool0C7oo00<l7gooOol0E7oo0013Ool00c`OOomoo`1NOol00c`O
Oomoo`1:Ool00c`OOomoo`1EOol0049oo`03?1moogoo04Eoo`@000Eoo`8000Aoo`D000Ioo`03000l
7goo04Uoo`03?1moogoo05Ioo`00@Goo00<l7gooOol0AGoo00<007ooOol00Woo00<007ooOol00Woo
0P0017oo00D007ooOomoo`0000Ioo`04001ooc`O?1m7Ool00c`OOomoo`1GOol0045oo`03?1moogoo
04Eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`05001oogooOoll7`15Ool00c`O
Oomoo`1HOol0041oo`03?1moogoo04Ioo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo00Io
o`<0009oo`03?1moogoo045oo`03?1moogoo05Uoo`00@7oo00<l7gooOol0AWoo00<007ooOol00Woo
00<007ooOol02goo00<007ooOol01Goo00<007ooOol00goo0S`O@Goo00<l7gooOol0FGoo000oOol0
0c`OOomoo`17Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`05Ool0
0c`OOomoo`0mOol00c`OOomoo`1JOol003moo`03?1moogoo04Moo`03001oogoo009oo`03001oogoo
00Qoo`05001oogooOol00006Ool00`00Oomoo`06Ool00c`OOomoo`0kOol00c`OOomoo`1KOol003io
o`03?1moogoo04Uoo`@000aoo`<000Moo`03001oogoo00Moo`8l7cYoo`03?1moogoo05aoo`00?Woo
00<l7gooOol0Hgoo00<007ooOol02Goo00<l7gooOol0=Woo00<l7gooOol0GGoo000mOol00c`OOomo
o`1TOol00`00Oomoo`0:Ool00c`OOomoo`0dOol00c`OOomoo`1NOol003eoo`03?1moogoo06Aoo`03
001oogoo00]oo`8l7c=oo`03?1moogoo05moo`00?7oo00<l7gooOol0IGoo00<007ooOol03Goo0S`O
<Goo00<l7gooOol0Ggoo000lOol00c`OOomoo`1UOol00`00Oomoo`0?Ool2?1l^Ool00c`OOomoo`1P
Ool003aoo`03?1moogoo06Eoo`80019oo`03?1moogoo02Yoo`03?1moogoo065oo`00>goo00<l7goo
Ool0IWoo00<007ooOol04Woo0S`O:Goo00<l7gooOol0HWoo000kOol00c`OOomoo`1VOol00`00Oomo
o`0DOol00c`OOomoo`0UOol00c`OOomoo`1SOol003]oo`03?1moogoo06Ioo`03001oogoo01Eoo`8l
7b=oo`8l7fIoo`00>Woo00<l7gooOol0Igoo00<007ooOol05goo0S`O87oo00<l7gooOol0IWoo000j
Ool00c`OOomoo`1WOol00`00Oomoo`0IOol3?1lKOol2?1mYOol003Uoo`03?1moogoo06Qoo`03001o
ogoo01aoo`<l7aIoo`8l7f]oo`00>Goo00<l7gooOol0J7oo00<007ooOol07goo0c`O3goo13`OKGoo
000iOol00c`OOomoo`1XOol00`00Oomoo`0ROol3?1l8Ool4?1maOol003Qoo`03?1moogoo06Uoo`80
02Ioo`Pl7gEoo`00>7oo00<l7gooOol0JGoo00<007ooOol0XWoo000gOol00c`OOomoo`1ZOol00`00
Oomoo`2ROol003Moo`03?1moogoo06Yoo`03001oogoo0:9oo`00=goo00<l7gooOol0JWoo00<007oo
Ool0XWoo000fOol00c`OOomoo`1[Ool00`00Oomoo`2ROol003Ioo`03?1moogoo06]oo`03001oogoo
0:9oo`00=Goo00<l7gooOol0K7oo00<007ooOol0XWoo000eOol00c`OOomoo`1/Ool00`00Oomoo`2R
Ool003Eoo`03?1moogoo06aoo`03001oogoo0:9oo`00=7oo00<l7gooOol0KGoo0P00Xgoo000dOol0
0c`OOomoo`1]Ool00`00Oomoo`2ROol003Aoo`03?1moogoo06eoo`03001oogoo0:9oo`00<goo00<l
7gooOol0KWoo00<007ooOol0XWoo000cOol00c`OOomoo`1^Ool00`00Oomoo`2ROol0039oo`03?1mo
ogoo06moo`03001oogoo0:9oo`00<Woo00<l7gooOol0Kgoo00<007ooOol0XWoo000bOol00c`OOomo
o`1EOol40005Ool20007Ool30005Ool00`00Oomoo`2ROol0035oo`03?1moogoo05Eoo`03001oogoo
009oo`03001oogoo009oo`8000Qoo`03001oogoo00Aoo`03001oogoo0:9oo`00<Goo00<l7gooOol0
EGoo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol0XWoo000aOol00c`O
Oomoo`1EOol00`00Oomoo`02Ool00`00Oomoo`08Ool60005Ool3002ROol0035oo`03?1moogoo05Eo
o`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol0031oo`03?1mo
ogoo05Ioo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol0031o
o`03?1moogoo05Ioo`03001oogoo009oo`03001oogoo00Yoo`03001oo`0000Ioo`03001oogoo0:9o
o`00<7oo00<l7gooOol0Egoo10003Woo0P001Woo00<007ooOol0XWoo000_Ool00c`OOomoo`1bOol0
0`00Oomoo`2ROol002moo`03?1moogoo079oo`03001oogoo0:9oo`00;goo00<l7gooOol0LWoo00<0
07ooOol0XWoo000_Ool00c`OOomoo`1bOol00`00Oomoo`2ROol002ioo`03?1moogoo07=oo`03001o
ogoo0:9oo`00;Woo00<l7gooOol0Lgoo0P00Xgoo000^Ool00c`OOomoo`1cOol00`00Oomoo`2ROol0
02ioo`03?1moogoo07=oo`03001oogoo0:9oo`00;Goo00<l7gooOol0M7oo00<007ooOol0XWoo000]
Ool00c`OOomoo`1dOol00`00Oomoo`2ROol002eoo`03?1moogoo07Aoo`03001oogoo0:9oo`00;7oo
00<l7gooOol0MGoo00<007ooOol0XWoo000/Ool00c`OOomoo`1eOol00`00Oomoo`2ROol002aoo`03
?1moogoo07Eoo`03001oogoo0:9oo`00;7oo00<l7gooOol0MGoo00<007ooOol0XWoo000[Ool00c`O
Oomoo`1fOol2002SOol002]oo`03?1moogoo07Ioo`03001oogoo0:9oo`00:goo00<l7gooOol0MWoo
00<007ooOol0XWoo000ZOol00c`OOomoo`1gOol00`00Oomoo`2ROol002Yoo`03?1moogoo07Moo`03
001oogoo0:9oo`00:Woo00<l7gooOol0Mgoo00<007ooOol0XWoo000ZOol00c`OOomoo`1gOol00`00
Oomoo`2ROol002Uoo`03?1moogoo07Qoo`03001oogoo0:9oo`00:Goo00<l7gooOol0N7oo00<007oo
Ool0XWoo000YOol00c`OOomoo`1hOol00`00Oomoo`2ROol002Uoo`03?1moogoo07Qoo`800:=oo`00
:7oo00<l7gooOol0NGoo00<007ooOol0XWoo000XOol00c`OOomoo`1iOol00`00Oomoo`2ROol002Qo
o`03?1moogoo07Uoo`03001oogoo0:9oo`009goo00<l7gooOol0NWoo00<007ooOol0XWoo000WOol0
0c`OOomoo`1jOol00`00Oomoo`2ROol002Moo`03?1moogoo07Yoo`03001oogoo0:9oo`009goo00<l
7gooOol0NWoo00<007ooOol0XWoo000VOol00c`OOomoo`1kOol00`00Oomoo`2ROol002Ioo`03?1mo
ogoo07]oo`03001oogoo0:9oo`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.8 0 1 r
.5 Mabswid
.09432 .61803 m
.10458 .57471 L
.14415 .44806 L
.18221 .3592 L
.20178 .32481 L
.22272 .29578 L
.23293 .28433 L
.24402 .27382 L
.25361 .26626 L
.26416 .2595 L
.2744 .25443 L
.284 .25096 L
.28929 .24954 L
.29413 .24855 L
.2968 .24812 L
.29972 .24775 L
.30105 .24761 L
.30247 .24749 L
.30379 .24739 L
.30503 .24732 L
.30627 .24727 L
.30693 .24725 L
.30763 .24723 L
.30837 .24722 L
.30907 .24721 L
.31039 .24722 L
.31161 .24724 L
.31275 .24727 L
.31399 .24732 L
.31531 .24739 L
.31804 .2476 L
.3206 .24787 L
.32644 .24872 L
.3315 .24973 L
.33615 .25086 L
.34661 .25413 L
.36553 .2623 L
.38624 .27412 L
.4268 .30372 L
.46584 .33669 L
.50734 .37191 L
.54732 .40153 L
.56564 .41246 L
.57605 .4177 L
.58579 .42188 L
.59617 .42549 L
.60566 .42797 L
.61087 .42897 L
.61581 .42967 L
.61851 .42995 L
Mistroke
.62102 .43014 L
.62247 .43022 L
.62378 .43028 L
.6245 .4303 L
.62529 .43032 L
.62603 .43033 L
.62671 .43033 L
.62797 .43033 L
.62917 .43031 L
.63025 .43028 L
.63142 .43023 L
.63269 .43015 L
.63404 .43006 L
.63647 .42983 L
.6387 .42957 L
.6408 .42926 L
.64557 .42838 L
.65077 .4271 L
.65553 .42563 L
.66625 .42124 L
.67607 .41584 L
.68521 .4096 L
.70592 .39074 L
.72642 .36518 L
.74502 .33556 L
.78505 .24892 L
.82357 .1327 L
Mfstroke
.82357 .1327 m
.85683 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00KWoo00=T7gooOol0<Goo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0KWoo00=T7goo
Ool0<Goo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0KWoo
00=T7gooOol0<Goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`1]Ool00f@OOomoo`0bOol008Yoo`@000ioo`8000Ioo`03001oogoo06eoo`03I1moogoo039oo`00
Y7oo00<007ooOol0KGoo00=T7gooOol0<Woo002TOol00`00Oomoo`1]Ool00f@OOomoo`0bOol00:Ao
o`03001oogoo06aoo`03I1moogoo03=oo`00Y7oo00<007ooOol0K7oo00=T7gooOol0<goo002TOol0
0`00Oomoo`1/Ool00f@OOomoo`0cOol00:Aoo`8006eoo`03I1moogoo03=oo`00Y7oo00<007ooOol0
Jgoo00=T7gooOol0=7oo002TOol00`00Oomoo`1[Ool00f@OOomoo`0dOol00:Aoo`03001oogoo06]o
o`03I1moogoo03Aoo`00Y7oo00<007ooOol0Jgoo00=T7gooOol0=7oo002TOol00`00Oomoo`1ZOol0
0f@OOomoo`0eOol00:Aoo`03001oogoo06Yoo`03I1moogoo03Eoo`00Y7oo00<007ooOol0JWoo00=T
7gooOol0=Goo002TOol00`00Oomoo`1ZOol00f@OOomoo`0eOol00:Aoo`8006Yoo`03I1moogoo03Io
o`00Y7oo00<007ooOol0JGoo00=T7gooOol0=Woo002TOol00`00Oomoo`1YOol00f@OOomoo`0fOol0
0:Aoo`03001oogoo06Uoo`03I1moogoo03Ioo`00Y7oo00<007ooOol0JGoo00=T7gooOol0=Woo002T
Ool00`00Oomoo`1XOol00f@OOomoo`0gOol00:Aoo`03001oogoo06Qoo`03I1moogoo03Moo`00Y7oo
00<007ooOol0J7oo00=T7gooOol0=goo002TOol00`00Oomoo`1XOol00f@OOomoo`0gOol00:Aoo`03
001oogoo06Moo`03I1moogoo03Qoo`00Y7oo0P00J7oo00=T7gooOol0>7oo002TOol00`00Oomoo`1W
Ool00f@OOomoo`0hOol00:Aoo`03001oogoo06Moo`03I1moogoo03Qoo`00Y7oo00<007ooOol0IWoo
00=T7gooOol0>Goo002TOol00`00Oomoo`1VOol00f@OOomoo`0iOol00:Aoo`03001oogoo06Ioo`03
I1moogoo03Uoo`00Y7oo00<007ooOol0IWoo00=T7gooOol0>Goo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1UOol00f@OOomoo`0jOol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1UOol00f@OOomoo`0jOol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo06Eoo`03I1moogoo03Yoo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00IGoo00=T7gooOol0>Woo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1TOol00f@OOomoo`0kOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo06Aoo`03I1moogoo03]o
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo06Aoo`03
I1moogoo03]oo`00RWoo100037oo0`001goo00<007ooOol0I7oo00=T7gooOol0>goo002TOol00`00
Oomoo`1SOol00f@OOomoo`0lOol00:Aoo`03001oogoo06=oo`03I1moogoo03aoo`00Y7oo00<007oo
Ool0Hgoo00=T7gooOol0?7oo002TOol00`00Oomoo`1ROol00f@OOomoo`0mOol00:Aoo`03001oogoo
069oo`03I1moogoo03eoo`00Y7oo0P00Hgoo00=T7gooOol0?Goo002TOol00`00Oomoo`1QOol00f@O
Oomoo`0nOol00:Aoo`03001oogoo065oo`03I1moogoo03ioo`00Y7oo00<007ooOol0H7oo00=T7goo
Ool0?goo002TOol00`00Oomoo`1POol00f@OOomoo`0oOol00:Aoo`03001oogoo061oo`03I1moogoo
03moo`00Y7oo00<007ooOol0Ggoo00=T7gooOol0@7oo002TOol00`00Oomoo`1OOol00f@OOomoo`10
Ool00:Aoo`03001oogoo05moo`03I1moogoo041oo`00Y7oo00<007ooOol0GWoo00=T7gooOol0@Goo
002TOol2001OOol00f@OOomoo`11Ool00:Aoo`03001oogoo05ioo`03I1moogoo045oo`00Y7oo00<0
07ooOol0GGoo00=T7gooOol0@Woo002TOol00`00Oomoo`1MOol00f@OOomoo`12Ool000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D0019oo`03I1moogoo035oo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo015oo`03I1moogoo039oo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo015o
o`03I1moogoo03=oo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol04Goo00=T7gooOol0=7oo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0@Ool00f@OOomoo`0fOol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
011oo`03I1moogoo03Moo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<0019oo`03I1moogoo03=oo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo00moo`03I1moogoo03Eoo`<000eoo`00Y7oo00<007ooOol0FWoo00=T
7gooOol0AGoo002TOol00`00Oomoo`1IOol00f@OOomoo`16Ool00:Aoo`03001oogoo05Uoo`03I1mo
ogoo04Ioo`00Y7oo00<007ooOol0FGoo00=T7gooOol0AWoo002TOol00`00Oomoo`1HOol00f@OOomo
o`17Ool00:Aoo`03001oogoo05Qoo`03I1moogoo04Moo`00Y7oo00<007ooOol0F7oo00=T7gooOol0
Agoo0004OomQ0005I1nD00000f@O000000130005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00Ioo`AT7`9oo`03001o
ogoo00ET7`Moo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03
I1l007oo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol00goo0f@O1Woo00<007ooOol01Goo0V@O1Goo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00=T7`00Ool03Goo00<007ooOol037oo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol02goo001KOol3I1lCOol4I1l_Ool00`00Oomoo`1FOol00f@O
Oomoo`19Ool005Uoo`9T7aYoo`=T7baoo`03001oogoo05Ioo`03I1moogoo04Uoo`00Egoo0V@O7goo
0V@O:Woo00<007ooOol0EGoo00=T7gooOol0BWoo001EOol2I1lSOol2I1lXOol00`00Oomoo`1EOol0
0f@OOomoo`1:Ool005Aoo`03I1moogoo02Eoo`03I1moogoo02Eoo`03001oogoo05Aoo`03I1moogoo
04]oo`00Dgoo00=T7gooOol09goo0V@O9Goo00<007ooOol0E7oo00=T7gooOol0Bgoo001BOol00f@O
Oomoo`0ZOol00f@OOomoo`0ROol00`00Oomoo`1DOol00f@OOomoo`1;Ool0055oo`03I1moogoo02ao
o`9T7b9oo`8005Aoo`03I1moogoo04aoo`00D7oo00=T7gooOol0;goo00=T7gooOol07goo00<007oo
Ool0Dgoo00=T7gooOol0C7oo001?Ool00f@OOomoo`0aOol2I1lOOol00`00Oomoo`1BOol00f@OOomo
o`1=Ool004ioo`03I1moogoo03Aoo`03I1moogoo01aoo`03001oogoo059oo`03I1moogoo04eoo`00
CGoo00=T7gooOol0=Woo00=T7gooOol06goo00<007ooOol0DGoo00=T7gooOol0CWoo001<Ool00f@O
Oomoo`0hOol2I1lKOol00`00Oomoo`1AOol00f@OOomoo`1>Ool004]oo`03I1moogoo03]oo`03I1mo
ogoo01Qoo`03001oogoo055oo`03I1moogoo04ioo`00BWoo00=T7gooOol0?Goo0V@O67oo00<007oo
Ool0D7oo00=T7gooOol0Cgoo001:Ool00f@OOomoo`0oOol00f@OOomoo`0EOol00`00Oomoo`1@Ool0
0f@OOomoo`1?Ool004Uoo`03I1moogoo045oo`03I1moogoo01Aoo`03001oogoo04moo`03I1moogoo
051oo`00B7oo00=T7gooOol0@goo00=T7gooOol04goo0P00D7oo00=T7gooOol0D7oo0018Ool00f@O
Oomoo`14Ool2I1lCOol00`00Oomoo`1>Ool00f@OOomoo`1AOol004Moo`03I1moogoo04Moo`03I1mo
ogoo011oo`03001oogoo04ioo`03I1moogoo055oo`00AWoo00=T7gooOol0BGoo00=T7gooOol03goo
00<007ooOol0CWoo00=T7gooOol0DGoo0016Ool00f@OOomoo`1:Ool00f@OOomoo`0>Ool00`00Oomo
o`1=Ool00f@OOomoo`1BOol004Eoo`03I1moogoo04aoo`03I1moogoo00eoo`03001oogoo04eoo`03
I1moogoo059oo`00A7oo00=T7gooOol0CWoo0V@O3Goo00<007ooOol0C7oo00=T7gooOol0Dgoo0014
Ool00f@OOomoo`1@Ool00f@OOomoo`0:Ool00`00Oomoo`1<Ool00f@OOomoo`1COol004=oo`03I1mo
ogoo059oo`03I1moogoo00Uoo`03001oogoo04]oo`03I1moogoo05Aoo`00@Woo00=T7gooOol0E7oo
00=T7gooOol027oo00<007ooOol0Bgoo00=T7gooOol0E7oo0012Ool00f@OOomoo`1EOol00f@OOomo
o`07Ool2001;Ool00f@OOomoo`1EOol0045oo`03I1moogoo05Moo`03I1moogoo00Ioo`03001oogoo
04Yoo`03I1moogoo05Eoo`00@Goo00=T7gooOol0F7oo0V@O1Woo00<007ooOol0BGoo00=T7gooOol0
EWoo0010Ool00f@OOomoo`1KOol00f@OOomoo`03Ool00`00Oomoo`18Ool00f@OOomoo`1GOol003mo
o`03I1moogoo05eoo`03I1moogoo009oo`03001oogoo04Qoo`03I1moogoo05Moo`00?goo00=T7goo
Ool0GWoo00ET7gooOomoo`0004Uoo`03I1moogoo05Qoo`00?Woo00=T7gooOol0H7oo00AT7gooOol0
04Qoo`03I1moogoo05Uoo`00?Woo00=T7gooOol0BGoo10001Goo0P0017oo1@0017oo0V@O00<007oo
Ool0AWoo00=T7gooOol0FGoo000mOol00f@OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2
0004Ool01@00Oomoogoo00001Woo00=T7gooOol0AGoo00=T7gooOol0FWoo000mOol00f@OOomoo`19
Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`07Ool00`00I1moo`14Ool00f@OOomoo`1K
Ool003aoo`03I1moogoo04Yoo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo00Ioo`800003
I1moogoo045oo`03I1moogoo05aoo`00?7oo00=T7gooOol0BWoo00<007ooOol00Woo00<007ooOol0
2goo00<007ooOol01Goo00@007ooOomT7d5oo`03I1moogoo05eoo`00>goo00=T7gooOol0Bgoo00<0
07ooOol00Woo00<007ooOol037oo00<007ooOol017oo00@007ooOomoo`9T7cioo`03I1moogoo05io
o`00>goo00=T7gooOol0Bgoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03
001oogoo00=oo`03I1moogoo03]oo`03I1moogoo05ioo`00>goo00=T7gooOol0C7oo100037oo0`00
1goo00<007ooOol017oo00=T7gooOol0>Goo00=T7gooOol0Ggoo000jOol00f@OOomoo`1WOol00`00
Oomoo`05Ool2I1lhOol00f@OOomoo`1POol003Yoo`03I1moogoo06Moo`03001oogoo00Moo`03I1mo
ogoo03Aoo`03I1moogoo065oo`00>Goo00=T7gooOol0J7oo00<007ooOol027oo00=T7gooOol0<Woo
00=T7gooOol0HWoo000iOol00f@OOomoo`1XOol00`00Oomoo`09Ool2I1laOol00f@OOomoo`1SOol0
03Qoo`03I1moogoo06Uoo`03001oogoo00]oo`03I1moogoo02eoo`03I1moogoo06Aoo`00>7oo00=T
7gooOol0JGoo0P003Goo00=T7gooOol0:goo00=T7gooOol0IGoo000hOol00f@OOomoo`1YOol00`00
Oomoo`0=Ool2I1lZOol00f@OOomoo`1VOol003Moo`03I1moogoo06Yoo`03001oogoo00moo`9T7bMo
o`03I1moogoo06Moo`00=goo00=T7gooOol0JWoo00<007ooOol04Goo0V@O8goo0V@OJWoo000fOol0
0f@OOomoo`1[Ool00`00Oomoo`0COol2I1lPOol00f@OOomoo`1ZOol003Ioo`03I1moogoo06]oo`03
001oogoo01Eoo`9T7aaoo`9T7feoo`00=Goo00=T7gooOol0K7oo00<007ooOol05goo0f@O5goo0V@O
Kgoo000eOol00f@OOomoo`1/Ool00`00Oomoo`0JOol3I1lAOol3I1maOol003Eoo`03I1moogoo06ao
o`03001oogoo01eoo`AT7`Qoo`ET7gAoo`00=7oo00=T7gooOol0KGoo0P008Woo26@ONGoo000dOol0
0f@OOomoo`1]Ool00`00Oomoo`2ROol003=oo`03I1moogoo06ioo`03001oogoo0:9oo`00<goo00=T
7gooOol0KWoo00<007ooOol0XWoo000bOol00f@OOomoo`1_Ool00`00Oomoo`2ROol0039oo`03I1mo
ogoo06moo`03001oogoo0:9oo`00<Woo00=T7gooOol0Kgoo00<007ooOol0XWoo000aOol00f@OOomo
o`1`Ool00`00Oomoo`2ROol0035oo`03I1moogoo071oo`03001oogoo0:9oo`00<Goo00=T7gooOol0
L7oo00<007ooOol0XWoo000aOol00f@OOomoo`1`Ool2002SOol0031oo`03I1moogoo075oo`03001o
ogoo0:9oo`00<7oo00=T7gooOol0LGoo00<007ooOol0XWoo000`Ool00f@OOomoo`1aOol00`00Oomo
o`2ROol002moo`03I1moogoo079oo`03001oogoo0:9oo`00;goo00=T7gooOol0LWoo00<007ooOol0
XWoo000_Ool00f@OOomoo`1bOol00`00Oomoo`2ROol002ioo`03I1moogoo05Uoo`@000Eoo`8000Mo
o`<000Eoo`03001oogoo0:9oo`00;Woo00=T7gooOol0F7oo00<007ooOol00Woo00<007ooOol00Woo
0P0027oo00<007ooOol017oo00<007ooOol0XWoo000^Ool00f@OOomoo`1HOol00`00Oomoo`02Ool0
0`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`2ROol002ioo`03I1moogoo05Qoo`03001oogoo
009oo`03001oogoo00Qoo`H000Eoo`<00:9oo`00;Goo00=T7gooOol0FGoo00<007ooOol00Woo00<0
07ooOol02Goo00@007ooOol000Ioo`03001oogoo0:9oo`00;Goo00=T7gooOol0FGoo00<007ooOol0
0Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo0:9oo`00;Goo00=T7gooOol0FGoo00<0
07ooOol00Woo00<007ooOol02Woo00<007oo00001Woo00<007ooOol0XWoo000/Ool00f@OOomoo`1K
Ool4000>Ool20006Ool00`00Oomoo`2ROol002aoo`03I1moogoo07Eoo`03001oogoo0:9oo`00;7oo
00=T7gooOol0MGoo00<007ooOol0XWoo000/Ool00f@OOomoo`1eOol00`00Oomoo`2ROol002]oo`03
I1moogoo07Ioo`03001oogoo0:9oo`00:goo00=T7gooOol0MWoo00<007ooOol0XWoo000[Ool00f@O
Oomoo`1fOol2002SOol002Yoo`03I1moogoo07Moo`03001oogoo0:9oo`00:Woo00=T7gooOol0Mgoo
00<007ooOol0XWoo000ZOol00f@OOomoo`1gOol00`00Oomoo`2ROol002Yoo`03I1moogoo07Moo`03
001oogoo0:9oo`00:Goo00=T7gooOol0N7oo00<007ooOol0XWoo000YOol00f@OOomoo`1hOol00`00
Oomoo`2ROol002Uoo`03I1moogoo07Qoo`03001oogoo0:9oo`00:7oo00=T7gooOol0NGoo00<007oo
Ool0XWoo000XOol00f@OOomoo`1iOol00`00Oomoo`2ROol002Qoo`03I1moogoo07Uoo`800:=oo`00
9goo00=T7gooOol0NWoo00<007ooOol0XWoo000WOol00f@OOomoo`1jOol00`00Oomoo`2ROol002Mo
o`03I1moogoo07Yoo`03001oogoo0:9oo`009goo00=T7gooOol0NWoo00<007ooOol0XWoo000VOol0
0f@OOomoo`1kOol00`00Oomoo`2ROol002Ioo`03I1moogoo07]oo`03001oogoo0:9oo`009Woo00=T
7gooOol0Ngoo00<007ooOol0XWoo000UOol00f@OOomoo`1lOol00`00Oomoo`2ROol002Eoo`03I1mo
ogoo07aoo`03001oogoo0:9oo`009Goo00=T7gooOol0O7oo0P00Xgoo000TOol00f@OOomoo`1mOol0
0`00Oomoo`2ROol002Aoo`03I1moogoo07eoo`03001oogoo0:9oo`0097oo00=T7gooOol0OGoo00<0
07ooOol0XWoo000TOol00f@OOomoo`1mOol00`00Oomoo`2ROol002=oo`03I1moogoo07ioo`03001o
ogoo0:9oo`008goo00=T7gooOol0OWoo00<007ooOol0XWoo000SOol00f@OOomoo`1nOol00`00Oomo
o`2ROol0029oo`03I1moogoo07moo`03001oogoo0:9oo`008Woo00=T7gooOol0Ogoo00<007ooOol0
XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 .9 r
.5 Mabswid
.08277 .61803 m
.10458 .53269 L
.14415 .41697 L
.18221 .33742 L
.20178 .30736 L
.22272 .28261 L
.23293 .27312 L
.24402 .26463 L
.25361 .25875 L
.26416 .25374 L
.2691 .25191 L
.2744 .25029 L
.27941 .24909 L
.284 .24825 L
.28667 .24788 L
.28915 .24761 L
.29056 .24749 L
.29188 .2474 L
.2934 .24731 L
.29406 .24728 L
.29478 .24726 L
.29603 .24723 L
.29734 .24721 L
.29856 .24722 L
.2997 .24724 L
.30039 .24726 L
.30105 .24728 L
.30227 .24733 L
.30359 .24741 L
.30503 .24751 L
.30736 .24772 L
.30988 .24801 L
.31443 .2487 L
.31984 .24978 L
.3248 .25101 L
.33504 .25425 L
.34581 .25859 L
.38392 .28045 L
.42448 .31157 L
.46353 .34498 L
.50502 .37957 L
.52583 .39505 L
.54501 .40751 L
.56488 .41805 L
.57459 .42216 L
.58347 .42525 L
.59252 .42769 L
.5975 .42871 L
.60223 .42946 L
.60472 .42976 L
Mistroke
.60736 .43002 L
.60864 .43011 L
.60985 .43019 L
.61093 .43024 L
.61211 .43029 L
.61342 .43032 L
.61414 .43033 L
.61481 .43033 L
.616 .43033 L
.61728 .43031 L
.61801 .43029 L
.61879 .43026 L
.62021 .43019 L
.6216 .4301 L
.62287 .43 L
.6253 .42975 L
.62752 .42947 L
.63253 .42861 L
.63694 .42761 L
.64158 .42629 L
.65143 .42258 L
.66219 .41704 L
.67249 .4102 L
.68184 .40263 L
.70281 .38065 L
.72203 .35398 L
.74284 .31749 L
.78381 .22015 L
.82327 .09078 L
Mfstroke
.82327 .09078 m
.84461 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00JWoo00=l77ooOol0=Goo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0JWoo00=l77oo
Ool0=Goo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0JWoo
00=l77ooOol0=Goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`1YOol00g`LOomoo`0fOol008Yoo`@000ioo`8000Ioo`03001oogoo06Uoo`03O1aoogoo03Ioo`00
Y7oo00<007ooOol0JGoo00=l77ooOol0=Woo002TOol00`00Oomoo`1YOol00g`LOomoo`0fOol00:Ao
o`03001oogoo06Uoo`03O1aoogoo03Ioo`00Y7oo00<007ooOol0J7oo00=l77ooOol0=goo002TOol0
0`00Oomoo`1XOol00g`LOomoo`0gOol00:Aoo`8006Uoo`03O1aoogoo03Moo`00Y7oo00<007ooOol0
J7oo00=l77ooOol0=goo002TOol00`00Oomoo`1XOol00g`LOomoo`0gOol00:Aoo`03001oogoo06Mo
o`03O1aoogoo03Qoo`00Y7oo00<007ooOol0Igoo00=l77ooOol0>7oo002TOol00`00Oomoo`1WOol0
0g`LOomoo`0hOol00:Aoo`03001oogoo06Moo`03O1aoogoo03Qoo`00Y7oo00<007ooOol0IWoo00=l
77ooOol0>Goo002TOol00`00Oomoo`1VOol00g`LOomoo`0iOol00:Aoo`8006Moo`03O1aoogoo03Uo
o`00Y7oo00<007ooOol0IWoo00=l77ooOol0>Goo002TOol00`00Oomoo`1VOol00g`LOomoo`0iOol0
0:Aoo`03001oogoo06Eoo`03O1aoogoo03Yoo`00Y7oo00<007ooOol0IGoo00=l77ooOol0>Woo002T
Ool00`00Oomoo`1UOol00g`LOomoo`0jOol00:Aoo`03001oogoo06Eoo`03O1aoogoo03Yoo`00Y7oo
00<007ooOol0IGoo00=l77ooOol0>Woo002TOol00`00Oomoo`1TOol00g`LOomoo`0kOol00:Aoo`03
001oogoo06Aoo`03O1aoogoo03]oo`00Y7oo0P00IGoo00=l77ooOol0>goo002TOol00`00Oomoo`1T
Ool00g`LOomoo`0kOol00:Aoo`03001oogoo06=oo`03O1aoogoo03aoo`00Y7oo00<007ooOol0Hgoo
00=l77ooOol0?7oo002TOol00`00Oomoo`1SOol00g`LOomoo`0lOol00:Aoo`03001oogoo069oo`03
O1aoogoo03eoo`00Y7oo00<007ooOol0HWoo00=l77ooOol0?Goo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1ROol00g`LOomoo`0mOol008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1QOol00g`LOomoo`0nOol008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo065oo`03O1aoogoo03ioo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00HGoo00=l77ooOol0?Woo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1QOol00g`LOomoo`0nOol008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo061oo`03O1aoogoo03mo
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo061oo`03
O1aoogoo03moo`00RWoo100037oo0`001goo00<007ooOol0H7oo00=l77ooOol0?goo002TOol00`00
Oomoo`1OOol00g`LOomoo`10Ool00:Aoo`03001oogoo05moo`03O1aoogoo041oo`00Y7oo00<007oo
Ool0Ggoo00=l77ooOol0@7oo002TOol00`00Oomoo`1NOol00g`LOomoo`11Ool00:Aoo`03001oogoo
05ioo`03O1aoogoo045oo`00Y7oo0P00Ggoo00=l77ooOol0@Goo002TOol00`00Oomoo`1MOol00g`L
Oomoo`12Ool00:Aoo`03001oogoo05eoo`03O1aoogoo049oo`00Y7oo00<007ooOol0GGoo00=l77oo
Ool0@Woo002TOol00`00Oomoo`1LOol00g`LOomoo`13Ool00:Aoo`03001oogoo05aoo`03O1aoogoo
04=oo`00Y7oo00<007ooOol0G7oo00=l77ooOol0@goo002TOol00`00Oomoo`1KOol00g`LOomoo`14
Ool00:Aoo`03001oogoo05]oo`03O1aoogoo04Aoo`00Y7oo00<007ooOol0Fgoo00=l77ooOol0A7oo
002TOol2001KOol00g`LOomoo`15Ool00:Aoo`03001oogoo05Yoo`03O1aoogoo04Eoo`00Y7oo00<0
07ooOol0FWoo00=l77ooOol0AGoo002TOol00`00Oomoo`1JOol00g`LOomoo`15Ool000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D000ioo`03O1aoogoo03Eoo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo00ioo`03O1aoogoo03Eoo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo00io
o`03O1aoogoo03Ioo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol03Goo00=l77ooOol0>7oo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`0=Ool00g`LOomoo`0iOol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
00eoo`03O1aoogoo03Yoo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<000ioo`03O1aoogoo03Moo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo00aoo`03O1aoogoo03Qoo`<000eoo`00Y7oo00<007ooOol0Egoo00=l
77ooOol0B7oo002TOol00`00Oomoo`1FOol00g`LOomoo`19Ool00:Aoo`03001oogoo05Ioo`03O1ao
ogoo04Uoo`00Y7oo00<007ooOol0EGoo00=l77ooOol0BWoo002TOol00`00Oomoo`1EOol00g`LOomo
o`1:Ool00:Aoo`03001oogoo05Aoo`03O1aoogoo04]oo`00Y7oo00<007ooOol0E7oo00=l77ooOol0
Bgoo0004OomM0005O1bE00000g`L000000160005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`04001oogooOol5O1`5Ool5O1`;Ool0
0`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool0
0`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00g`LOomoo`02Ool0
0`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool0
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo
00aoo`04001l77`LO1`;Ool01000Oomoogoo0g`L27oo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol03Goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol037oo00<007ooOol027oo00=l77ooOol00Woo00<007ooOol037oo00<007ooOol037oo00<0
07ooOol037oo00<007ooOol037oo00<007ooOol02goo001GOol2O1`EOol3O1`cOol00`00Oomoo`1B
Ool00g`LOomoo`1=Ool005Eoo`9l71Yoo`=l731oo`03001oogoo059oo`03O1aoogoo04eoo`00Dgoo
0W`L7goo0W`L;Woo00<007ooOol0DWoo00=l77ooOol0CGoo001BOol00g`LOomoo`0QOol2O1`/Ool0
0`00Oomoo`1AOol00g`LOomoo`1>Ool0055oo`03O1aoogoo02Aoo`03O1aoogoo02Uoo`03001oogoo
055oo`03O1aoogoo04ioo`00D7oo00=l77ooOol09Woo0W`L:Goo00<007ooOol0D7oo00=l77ooOol0
Cgoo001?Ool00g`LOomoo`0YOol2O1`WOol00`00Oomoo`1@Ool00g`LOomoo`1?Ool004ioo`03O1ao
ogoo02aoo`9l72Eoo`80051oo`03O1aoogoo051oo`00C7oo0W`L<Goo00=l77ooOol08Woo00<007oo
Ool0Cgoo00=l77ooOol0D7oo001;Ool00g`LOomoo`0bOol00g`LOomoo`0QOol00`00Oomoo`1?Ool0
0g`LOomoo`1@Ool004Yoo`03O1aoogoo03Aoo`9l725oo`03001oogoo04ioo`03O1aoogoo055oo`00
BGoo00=l77ooOol0=goo00=l77ooOol07Woo00<007ooOol0CWoo00=l77ooOol0DGoo0019Ool00g`L
Oomoo`0hOol00g`LOomoo`0MOol00`00Oomoo`1=Ool00g`LOomoo`1BOol004Qoo`03O1aoogoo03Yo
o`9l71eoo`03001oogoo04eoo`03O1aoogoo059oo`00Agoo00=l77ooOol0?Goo00=l77ooOol06Woo
00<007ooOol0CGoo00=l77ooOol0DWoo0016Ool00g`LOomoo`0oOol00g`LOomoo`0IOol00`00Oomo
o`1<Ool00g`LOomoo`1COol004Ioo`03O1aoogoo041oo`9l71Uoo`03001oogoo04aoo`03O1aoogoo
05=oo`00AGoo00=l77ooOol0@goo00=l77ooOol05Woo0P00C7oo00=l77ooOol0E7oo0014Ool00g`L
Oomoo`15Ool00g`LOomoo`0EOol00`00Oomoo`1;Ool00g`LOomoo`1DOol004=oo`03O1aoogoo04Mo
o`03O1aoogoo01Aoo`03001oogoo04Yoo`03O1aoogoo05Eoo`00@goo00=l77ooOol0B7oo00=l77oo
Ool04goo00<007ooOol0BWoo00=l77ooOol0EGoo0012Ool00g`LOomoo`1:Ool00g`LOomoo`0BOol0
0`00Oomoo`19Ool00g`LOomoo`1FOol0045oo`03O1aoogoo04aoo`03O1aoogoo015oo`03001oogoo
04Uoo`03O1aoogoo05Ioo`00@7oo00=l77ooOol0CWoo00=l77ooOol047oo00<007ooOol0B7oo00=l
77ooOol0Egoo0010Ool00g`LOomoo`1?Ool2O1`@Ool00`00Oomoo`17Ool00g`LOomoo`1HOol003mo
o`03O1aoogoo059oo`03O1aoogoo00eoo`03001oogoo04Moo`03O1aoogoo05Qoo`00?Woo00=l77oo
Ool0E7oo00=l77ooOol037oo00<007ooOol0AWoo00=l77ooOol0FGoo000nOol00g`LOomoo`1EOol0
0g`LOomoo`0;Ool20017Ool00g`LOomoo`1IOol003eoo`03O1aoogoo05Moo`03O1aoogoo00Yoo`03
001oogoo04Eoo`03O1aoogoo05Yoo`00?Goo00=l77ooOol0F7oo00=l77ooOol02Goo00<007ooOol0
A7oo00=l77ooOol0Fgoo000lOol00g`LOomoo`1JOol00g`LOomoo`08Ool00`00Oomoo`14Ool00g`L
Oomoo`1KOol003aoo`03O1aoogoo05]oo`03O1aoogoo00Moo`03001oogoo04=oo`03O1aoogoo05ao
o`00>goo00=l77ooOol0GGoo0W`L1goo00<007ooOol0@Woo00=l77ooOol0GGoo000kOol00g`LOomo
o`1OOol00g`LOomoo`04Ool00`00Oomoo`12Ool00g`LOomoo`1MOol003Yoo`03O1aoogoo04eoo`@0
00Eoo`8000Aoo`D00003O1aoogoo00=oo`03001oogoo045oo`03O1aoogoo05ioo`00>Woo00=l77oo
Ool0C7oo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00L007ooOomoo`00Ooml7004Ool00`00
Oomoo`10Ool00g`LOomoo`1OOol003Uoo`03O1aoogoo04eoo`03001oogoo009oo`03001oogoo00Uo
o`03001oogoo00=oo`05O1aoogooOol00012Ool00g`LOomoo`1OOol003Uoo`03O1aoogoo04eoo`03
001oogoo009oo`03001oogoo00Yoo`03001oogoo00=oo`9l7004Ool00000000oOol00g`LOomoo`1P
Ool003Qoo`03O1aoogoo04ioo`03001oogoo009oo`03001oogoo00]oo`03001oogoo00Aoo`03O1`0
07oo03moo`03O1aoogoo065oo`00>7oo00=l77ooOol0CWoo00<007ooOol00Woo00<007ooOol037oo
00<007ooOol017oo00=l77ooOol0?Woo00=l77ooOol0HGoo000gOol00g`LOomoo`1?Ool00`00Oomo
o`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Woo00<007`LOol0?Goo00=l77ooOol0HWoo000g
Ool00g`LOomoo`1@Ool4000<Ool30007Ool01000Ooml77`L>goo00=l77ooOol0Hgoo000fOol00g`L
Oomoo`1[Ool01000Oomoogoo0W`L>7oo00=l77ooOol0I7oo000fOol00g`LOomoo`1[Ool00`00Oomo
o`03Ool2O1`eOol00g`LOomoo`1UOol003Eoo`03O1aoogoo06aoo`03001oogoo00Eoo`03O1aoogoo
039oo`03O1aoogoo06Eoo`00=Goo00=l77ooOol0K7oo00<007ooOol01Woo0W`L<Goo00=l77ooOol0
IWoo000dOol00g`LOomoo`1]Ool00`00Oomoo`08Ool00g`LOomoo`0]Ool00g`LOomoo`1WOol003Ao
o`03O1aoogoo06eoo`8000Yoo`9l72aoo`03O1aoogoo06Qoo`00<goo00=l77ooOol0KWoo00<007oo
Ool02goo00=l77ooOol09goo0W`LJgoo000cOol00g`LOomoo`1^Ool00`00Oomoo`0<Ool2O1`VOol0
0g`LOomoo`1[Ool0039oo`03O1aoogoo06moo`03001oogoo00ioo`03O1aoogoo025oo`9l76ioo`00
<Woo00=l77ooOol0Kgoo00<007ooOol03goo0W`L7goo0W`LL7oo000bOol00g`LOomoo`1_Ool00`00
Oomoo`0AOol2O1`KOol2O1abOol0035oo`03O1aoogoo071oo`03001oogoo01=oo`=l71Ioo`9l77Ao
o`00<Goo00=l77ooOol0L7oo00<007ooOol05Woo0g`L4Goo0W`LMWoo000aOol00g`LOomoo`1`Ool0
0`00Oomoo`0IOol5O1`7Ool5O1ahOol0031oo`03O1aoogoo075oo`8001moo`Ql77aoo`00<7oo00=l
77ooOol0LGoo00<007ooOol0XWoo000`Ool00g`LOomoo`1aOol00`00Oomoo`2ROol002moo`03O1ao
ogoo079oo`03001oogoo0:9oo`00;goo00=l77ooOol0LWoo00<007ooOol0XWoo000_Ool00g`LOomo
o`1bOol00`00Oomoo`2ROol002ioo`03O1aoogoo07=oo`03001oogoo0:9oo`00;Woo00=l77ooOol0
Lgoo00<007ooOol0XWoo000^Ool00g`LOomoo`1cOol00`00Oomoo`2ROol002eoo`03O1aoogoo07Ao
o`03001oogoo0:9oo`00;Goo00=l77ooOol0M7oo0P00Xgoo000]Ool00g`LOomoo`1dOol00`00Oomo
o`2ROol002aoo`03O1aoogoo07Eoo`03001oogoo0:9oo`00;7oo00=l77ooOol0MGoo00<007ooOol0
XWoo000/Ool00g`LOomoo`1eOol00`00Oomoo`2ROol002aoo`03O1aoogoo07Eoo`03001oogoo0:9o
o`00:goo00=l77ooOol0MWoo00<007ooOol0XWoo000[Ool00g`LOomoo`1LOol40005Ool20007Ool3
0005Ool00`00Oomoo`2ROol002]oo`03O1aoogoo05]oo`03001oogoo009oo`03001oogoo009oo`80
00Qoo`03001oogoo00Aoo`03001oogoo0:9oo`00:Woo00=l77ooOol0G7oo00<007ooOol00Woo00<0
07ooOol037oo00<007ooOol017oo00<007ooOol0XWoo000ZOol00g`LOomoo`1LOol00`00Oomoo`02
Ool00`00Oomoo`08Ool60005Ool3002ROol002Yoo`03O1aoogoo05aoo`03001oogoo009oo`03001o
ogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol002Uoo`03O1aoogoo05eoo`03001oogoo009o
o`03001oogoo00Uoo`04001oogoo0006Ool00`00Oomoo`2ROol002Uoo`03O1aoogoo05eoo`03001o
ogoo009oo`03001oogoo00Yoo`03001oo`0000Ioo`03001oogoo0:9oo`00:Goo00=l77ooOol0GWoo
10003Woo0P001Woo00<007ooOol0XWoo000XOol00g`LOomoo`1iOol00`00Oomoo`2ROol002Qoo`03
O1aoogoo07Uoo`03001oogoo0:9oo`00:7oo00=l77ooOol0NGoo00<007ooOol0XWoo000WOol00g`L
Oomoo`1jOol00`00Oomoo`2ROol002Moo`03O1aoogoo07Yoo`03001oogoo0:9oo`009goo00=l77oo
Ool0NWoo0P00Xgoo000VOol00g`LOomoo`1kOol00`00Oomoo`2ROol002Ioo`03O1aoogoo07]oo`03
001oogoo0:9oo`009Woo00=l77ooOol0Ngoo00<007ooOol0XWoo000UOol00g`LOomoo`1lOol00`00
Oomoo`2ROol002Eoo`03O1aoogoo07aoo`03001oogoo0:9oo`009Goo00=l77ooOol0O7oo00<007oo
Ool0XWoo000UOol00g`LOomoo`1lOol00`00Oomoo`2ROol002Aoo`03O1aoogoo07eoo`03001oogoo
0:9oo`0097oo00=l77ooOol0OGoo00<007ooOol0XWoo000TOol00g`LOomoo`1mOol2002SOol002Ao
o`03O1aoogoo07eoo`03001oogoo0:9oo`008goo00=l77ooOol0OWoo00<007ooOol0XWoo000SOol0
0g`LOomoo`1nOol00`00Oomoo`2ROol002=oo`03O1aoogoo07ioo`03001oogoo0:9oo`008goo00=l
77ooOol0OWoo00<007ooOol0XWoo000ROol00g`LOomoo`1oOol00`00Oomoo`2ROol0029oo`03O1ao
ogoo07moo`03001oogoo0:9oo`008Woo00=l77ooOol0Ogoo00<007ooOol0XWoo000ROol00g`LOomo
o`1oOol00`00Oomoo`2ROol0025oo`03O1aoogoo081oo`800:=oo`008Goo00=l77ooOol0P7oo00<0
07ooOol0XWoo000QOol00g`LOomoo`20Ool00`00Oomoo`2ROol0025oo`03O1aoogoo081oo`03001o
ogoo0:9oo`0087oo00=l77ooOol0PGoo00<007ooOol0XWoo000POol00g`LOomoo`21Ool00`00Oomo
o`2ROol0021oo`03O1aoogoo085oo`03001oogoo0:9oo`0087oo00=l77ooOol0PGoo00<007ooOol0
XWoo000OOol00g`LOomoo`22Ool00`00Oomoo`2ROol001moo`03O1aoogoo089oo`03001oogoo0:9o
o`00\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 .6 r
.5 Mabswid
.07028 .61803 m
.10458 .49409 L
.12507 .43535 L
.14415 .38893 L
.18221 .31831 L
.20262 .29141 L
.2212 .27297 L
.23049 .26576 L
.24035 .2595 L
.25115 .2542 L
.25636 .2522 L
.26113 .25068 L
.26563 .24951 L
.27054 .24851 L
.27323 .24808 L
.27573 .24777 L
.27812 .24753 L
.27945 .24743 L
.28067 .24735 L
.28182 .2473 L
.28304 .24725 L
.28426 .24723 L
.28496 .24722 L
.28561 .24721 L
.28678 .24722 L
.28785 .24724 L
.28909 .24728 L
.29026 .24733 L
.29243 .24746 L
.29443 .24762 L
.29897 .24814 L
.3036 .24889 L
.30859 .24993 L
.31763 .25239 L
.32838 .25625 L
.33823 .26059 L
.37786 .28454 L
.41596 .3144 L
.45653 .34921 L
.49557 .38148 L
.51548 .39614 L
.53707 .40982 L
.54717 .41525 L
.55787 .42021 L
.56789 .42405 L
.57705 .42682 L
.58157 .4279 L
.58649 .42887 L
.58919 .4293 L
.59169 .42963 L
Mistroke
.59423 .42991 L
.59662 .4301 L
.59771 .43017 L
.59886 .43023 L
.60012 .43028 L
.60128 .43032 L
.60232 .43033 L
.60329 .43033 L
.60436 .43033 L
.60549 .43031 L
.60671 .43027 L
.60803 .4302 L
.60928 .43013 L
.61044 .43004 L
.61262 .42984 L
.61494 .42956 L
.61984 .42877 L
.62433 .42779 L
.63445 .42465 L
.64337 .42079 L
.65274 .41555 L
.67252 .4003 L
.6909 .38065 L
.7114 .35198 L
.73 .31931 L
.77003 .22539 L
.80855 .10125 L
Mfstroke
.80855 .10125 m
.83255 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00Igoo00=l4WooOol0>7oo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0Igoo00=l4Woo
Ool0>7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0IWoo
00=l4WooOol0>Goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`1VOol00g`BOomoo`0iOol008Yoo`@000ioo`8000Ioo`03001oogoo06Ioo`03O19oogoo03Uoo`00
Y7oo00<007ooOol0IWoo00=l4WooOol0>Goo002TOol00`00Oomoo`1UOol00g`BOomoo`0jOol00:Ao
o`03001oogoo06Eoo`03O19oogoo03Yoo`00Y7oo00<007ooOol0IGoo00=l4WooOol0>Woo002TOol0
0`00Oomoo`1UOol00g`BOomoo`0jOol00:Aoo`8006Eoo`03O19oogoo03]oo`00Y7oo00<007ooOol0
I7oo00=l4WooOol0>goo002TOol00`00Oomoo`1TOol00g`BOomoo`0kOol00:Aoo`03001oogoo06Ao
o`03O19oogoo03]oo`00Y7oo00<007ooOol0Hgoo00=l4WooOol0?7oo002TOol00`00Oomoo`1SOol0
0g`BOomoo`0lOol00:Aoo`03001oogoo06=oo`03O19oogoo03aoo`00Y7oo00<007ooOol0Hgoo00=l
4WooOol0?7oo002TOol00`00Oomoo`1ROol00g`BOomoo`0mOol00:Aoo`8006=oo`03O19oogoo03eo
o`00Y7oo00<007ooOol0HWoo00=l4WooOol0?Goo002TOol00`00Oomoo`1ROol00g`BOomoo`0mOol0
0:Aoo`03001oogoo065oo`03O19oogoo03ioo`00Y7oo00<007ooOol0HGoo00=l4WooOol0?Woo002T
Ool00`00Oomoo`1QOol00g`BOomoo`0nOol00:Aoo`03001oogoo065oo`03O19oogoo03ioo`00Y7oo
00<007ooOol0H7oo00=l4WooOol0?goo002TOol00`00Oomoo`1POol00g`BOomoo`0oOol00:Aoo`03
001oogoo061oo`03O19oogoo03moo`00Y7oo0P00HGoo00=l4WooOol0?goo002TOol00`00Oomoo`1O
Ool00g`BOomoo`10Ool00:Aoo`03001oogoo05moo`03O19oogoo041oo`00Y7oo00<007ooOol0Ggoo
00=l4WooOol0@7oo002TOol00`00Oomoo`1OOol00g`BOomoo`10Ool00:Aoo`03001oogoo05ioo`03
O19oogoo045oo`00Y7oo00<007ooOol0GWoo00=l4WooOol0@Goo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1NOol00g`BOomoo`11Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1MOol00g`BOomoo`12Ool008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo05eoo`03O19oogoo049oo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00GGoo00=l4WooOol0@Woo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1MOol00g`BOomoo`12Ool008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo05aoo`03O19oogoo04=o
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo05aoo`03
O19oogoo04=oo`00RWoo100037oo0`001goo00<007ooOol0G7oo00=l4WooOol0@goo002TOol00`00
Oomoo`1KOol00g`BOomoo`14Ool00:Aoo`03001oogoo05]oo`03O19oogoo04Aoo`00Y7oo00<007oo
Ool0Fgoo00=l4WooOol0A7oo002TOol00`00Oomoo`1JOol00g`BOomoo`15Ool00:Aoo`03001oogoo
05Yoo`03O19oogoo04Eoo`00Y7oo0P00Fgoo00=l4WooOol0AGoo002TOol00`00Oomoo`1IOol00g`B
Oomoo`16Ool00:Aoo`03001oogoo05Uoo`03O19oogoo04Ioo`00Y7oo00<007ooOol0FGoo00=l4Woo
Ool0AWoo002TOol00`00Oomoo`1IOol00g`BOomoo`16Ool00:Aoo`03001oogoo05Qoo`03O19oogoo
04Moo`00Y7oo00<007ooOol0F7oo00=l4WooOol0Agoo002TOol00`00Oomoo`1HOol00g`BOomoo`17
Ool00:Aoo`03001oogoo05Moo`03O19oogoo04Qoo`00Y7oo00<007ooOol0Egoo00=l4WooOol0B7oo
002TOol2001HOol00g`BOomoo`18Ool00:Aoo`03001oogoo05Ioo`03O19oogoo04Uoo`00Y7oo00<0
07ooOol0EWoo00=l4WooOol0BGoo002TOol00`00Oomoo`1FOol00g`BOomoo`19Ool000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D000Yoo`03O19oogoo03Uoo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo00Yoo`03O19oogoo03Uoo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo00Yo
o`03O19oogoo03Yoo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol02Woo00=l4WooOol0>goo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`09Ool00g`BOomoo`0mOol0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
00Uoo`03O19oogoo03ioo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<000]oo`03O19oogoo03Yoo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo00Qoo`03O19oogoo03aoo`<000eoo`00Y7oo00<007ooOol0Dgoo00=l
4WooOol0C7oo002TOol00`00Oomoo`1COol00g`BOomoo`1<Ool00:Aoo`03001oogoo059oo`03O19o
ogoo04eoo`00Y7oo00<007ooOol0DWoo00=l4WooOol0CGoo002TOol00`00Oomoo`1AOol00g`BOomo
o`1>Ool00:Aoo`03001oogoo055oo`03O19oogoo04ioo`00Y7oo00<007ooOol0D7oo00=l4WooOol0
Cgoo0004OomI0006O1:D00000g`B0000001:0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001l4W`B00=l4PAoo`Ml4Peoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Eoo`03O19oogoo00Eoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`00
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
2Woo0g`B3Woo00<007ooO1800W`B2Woo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo
00<007ooOol017oo00=l4WooOol01Woo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo
00<007ooOol037oo00<007ooOol02goo001COol3O18FOol2O18fOol00`00Oomoo`1?Ool00g`BOomo
o`1@Ool0055oo`9l4Q]oo`9l4SAoo`03001oogoo04ioo`03O19oogoo055oo`00Cgoo0W`B7goo00=l
4WooOol0<Goo00<007ooOol0CWoo00=l4WooOol0DGoo001>Ool00g`BOomoo`0POol2O18aOol00`00
Oomoo`1=Ool00g`BOomoo`1BOol004eoo`03O19oogoo02=oo`9l4Rmoo`03001oogoo04eoo`03O19o
ogoo059oo`00C7oo00=l4WooOol09Woo0W`B;Goo00<007ooOol0C7oo00=l4WooOol0Dgoo001;Ool0
0g`BOomoo`0YOol2O18[Ool00`00Oomoo`1<Ool00g`BOomoo`1COol004Yoo`03O19oogoo02aoo`9l
4RUoo`8004eoo`03O19oogoo05=oo`00BGoo00=l4WooOol0;goo0W`B9goo00<007ooOol0Bgoo00=l
4WooOol0E7oo0017Ool2O18dOol00g`BOomoo`0TOol00`00Oomoo`1;Ool00g`BOomoo`1DOol004Io
o`03O19oogoo03Eoo`03O19oogoo02=oo`03001oogoo04Yoo`03O19oogoo05Eoo`00AGoo00=l4Woo
Ool0=goo00=l4WooOol08Woo00<007ooOol0BWoo00=l4WooOol0EGoo0014Ool00g`BOomoo`0iOol2
O18ROol00`00Oomoo`19Ool00g`BOomoo`1FOol004=oo`03O19oogoo03aoo`03O19oogoo01moo`03
001oogoo04Uoo`03O19oogoo05Ioo`00@goo00=l4WooOol0?Goo00=l4WooOol07Woo00<007ooOol0
BGoo00=l4WooOol0EWoo0012Ool00g`BOomoo`0oOol00g`BOomoo`0MOol00`00Oomoo`18Ool00g`B
Oomoo`1GOol0045oo`03O19oogoo045oo`03O19oogoo01aoo`03001oogoo04Qoo`03O19oogoo05Mo
o`00@7oo00=l4WooOol0@goo0W`B77oo0P00B7oo00=l4WooOol0F7oo0010Ool00g`BOomoo`15Ool0
0g`BOomoo`0IOol00`00Oomoo`17Ool00g`BOomoo`1HOol003moo`03O19oogoo04Moo`03O19oogoo
01Qoo`03001oogoo04Ioo`03O19oogoo05Uoo`00?Woo00=l4WooOol0BGoo00=l4WooOol05goo00<0
07ooOol0AWoo00=l4WooOol0FGoo000mOol00g`BOomoo`1;Ool00g`BOomoo`0FOol00`00Oomoo`15
Ool00g`BOomoo`1JOol003eoo`03O19oogoo04aoo`9l4QIoo`03001oogoo04Eoo`03O19oogoo05Yo
o`00?7oo00=l4WooOol0Cgoo00=l4WooOol04goo00<007ooOol0A7oo00=l4WooOol0Fgoo000lOol0
0g`BOomoo`1@Ool00g`BOomoo`0BOol00`00Oomoo`14Ool00g`BOomoo`1KOol003]oo`03O19oogoo
059oo`03O19oogoo015oo`03001oogoo04=oo`03O19oogoo05aoo`00>goo00=l4WooOol0Dgoo00=l
4WooOol047oo00<007ooOol0@goo00=l4WooOol0G7oo000jOol00g`BOomoo`1EOol2O18@Ool20013
Ool00g`BOomoo`1MOol003Yoo`03O19oogoo05Moo`03O19oogoo00eoo`03001oogoo049oo`03O19o
ogoo05eoo`00>Goo00=l4WooOol0FGoo00=l4WooOol037oo00<007ooOol0@Goo00=l4WooOol0GWoo
000iOol00g`BOomoo`1JOol00g`BOomoo`0;Ool00`00Oomoo`11Ool00g`BOomoo`1NOol003Qoo`03
O19oogoo05aoo`03O19oogoo00Yoo`03001oogoo041oo`03O19oogoo05moo`00>7oo00=l4WooOol0
GGoo00=l4WooOol02Goo00<007ooOol0?goo00=l4WooOol0H7oo000gOol00g`BOomoo`1OOol2O189
Ool00`00Oomoo`0nOol00g`BOomoo`1QOol003Moo`03O19oogoo051oo`@000Eoo`8000Aoo`800003
O180000000Ioo`03001oogoo03ioo`03O19oogoo065oo`00=Woo00=l4WooOol0D7oo00<007ooOol0
0Woo00<007ooOol00Woo0P0017oo00D007ooOoml4P0000Ioo`03001oogoo03eoo`03O19oogoo069o
o`00=Woo00=l4WooOol0D7oo00<007ooOol00Woo00<007ooOol02Goo00@007ooOoml4PIoo`03001o
ogoo03aoo`03O19oogoo06=oo`00=Goo00=l4WooOol0DGoo00<007ooOol00Woo00<007ooOol02Woo
00@007ooOoml4PEoo`<003]oo`03O19oogoo06Aoo`00=Goo00=l4WooOol0DGoo00<007ooOol00Woo
00<007ooOol02goo00<007ooOol00W`B0goo00<007ooOol0>goo00=l4WooOol0I7oo000dOol00g`B
Oomoo`1BOol00`00Oomoo`02Ool00`00Oomoo`0<Ool01@00OomoogooO1800Woo00<007ooOol0>Woo
00=l4WooOol0IGoo000dOol00g`BOomoo`1BOol00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomo
ogoo000017oo00=l4Woo0000>goo00=l4WooOol0IWoo000cOol00g`BOomoo`1DOol4000<Ool30006
Ool2O18jOol00g`BOomoo`1WOol003=oo`03O19oogoo06ioo`03001l4Woo03Moo`03O19oogoo06Qo
o`00<Woo00=l4WooOol0Kgoo00<007ooO180=Woo00=l4WooOol0JGoo000bOol00g`BOomoo`1_Ool0
0`00Oomoo`02O18dOol00g`BOomoo`1YOol0035oo`03O19oogoo071oo`03001oogoo009oo`03O19o
ogoo031oo`03O19oogoo06Yoo`00<Goo00=l4WooOol0L7oo00<007ooOol00goo0W`B;goo00=l4Woo
Ool0Jgoo000`Ool00g`BOomoo`1aOol20006Ool00g`BOomoo`0ZOol2O19^Ool0031oo`03O19oogoo
075oo`03001oogoo00Ioo`9l4RUoo`03O19oogoo06ioo`00;goo00=l4WooOol0LWoo00<007ooOol0
27oo00=l4WooOol09Goo00=l4WooOol0Kgoo000_Ool00g`BOomoo`1bOol00`00Oomoo`09Ool2O18S
Ool2O19bOol002moo`03O19oogoo079oo`03001oogoo00]oo`9l4R1oo`03O19oogoo079oo`00;Woo
00=l4WooOol0Lgoo00<007ooOol03Goo0W`B77oo0W`BMGoo000^Ool00g`BOomoo`1cOol00`00Oomo
o`0?Ool2O18HOol2O19gOol002eoo`03O19oogoo07Aoo`03001oogoo015oo`=l4Q9oo`=l4WUoo`00
;Goo00=l4WooOol0M7oo00<007ooOol057oo1W`B1goo1G`BO7oo000/Ool00g`BOomoo`1eOol2000K
Ool7O1:1Ool002aoo`03O19oogoo07Eoo`03001oogoo0:9oo`00;7oo00=l4WooOol0MGoo00<007oo
Ool0XWoo000[Ool00g`BOomoo`1fOol00`00Oomoo`2ROol002]oo`03O19oogoo07Ioo`03001oogoo
0:9oo`00:goo00=l4WooOol0MWoo00<007ooOol0XWoo000ZOol00g`BOomoo`1gOol00`00Oomoo`2R
Ool002Yoo`03O19oogoo07Moo`03001oogoo0:9oo`00:Woo00=l4WooOol0Mgoo00<007ooOol0XWoo
000YOol00g`BOomoo`1hOol00`00Oomoo`2ROol002Uoo`03O19oogoo07Qoo`800:=oo`00:Goo00=l
4WooOol0N7oo00<007ooOol0XWoo000YOol00g`BOomoo`1hOol00`00Oomoo`2ROol002Qoo`03O19o
ogoo07Uoo`03001oogoo0:9oo`00:7oo00=l4WooOol0NGoo00<007ooOol0XWoo000XOol00g`BOomo
o`1iOol00`00Oomoo`2ROol002Moo`03O19oogoo07Yoo`03001oogoo0:9oo`009goo00=l4WooOol0
H7oo10001Goo0P001goo0`001Goo00<007ooOol0XWoo000WOol00g`BOomoo`1OOol00`00Oomoo`02
Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`04Ool00`00Oomoo`2ROol002Ioo`03O19oogoo061o
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo0:9oo`009Woo00=l4Woo
Ool0H7oo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00XWoo000VOol00g`BOomoo`1POol0
0`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo000UOol00g`BOomo
o`1QOol00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0XWoo000UOol0
0g`BOomoo`1QOol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol0
02Eoo`03O19oogoo069oo`@000ioo`8000Ioo`03001oogoo0:9oo`009Goo00=l4WooOol0O7oo00<0
07ooOol0XWoo000TOol00g`BOomoo`1mOol00`00Oomoo`2ROol002Aoo`03O19oogoo07eoo`03001o
ogoo0:9oo`0097oo00=l4WooOol0OGoo00<007ooOol0XWoo000SOol00g`BOomoo`1nOol00`00Oomo
o`2ROol002=oo`03O19oogoo07ioo`800:=oo`008goo00=l4WooOol0OWoo00<007ooOol0XWoo000S
Ool00g`BOomoo`1nOol00`00Oomoo`2ROol0029oo`03O19oogoo07moo`03001oogoo0:9oo`008Woo
00=l4WooOol0Ogoo00<007ooOol0XWoo000ROol00g`BOomoo`1oOol00`00Oomoo`2ROol0025oo`03
O19oogoo081oo`03001oogoo0:9oo`008Goo00=l4WooOol0P7oo00<007ooOol0XWoo000QOol00g`B
Oomoo`20Ool00`00Oomoo`2ROol0025oo`03O19oogoo081oo`03001oogoo0:9oo`0087oo00=l4Woo
Ool0PGoo0P00Xgoo000POol00g`BOomoo`21Ool00`00Oomoo`2ROol0021oo`03O19oogoo085oo`03
001oogoo0:9oo`0087oo00=l4WooOol0PGoo00<007ooOol0XWoo000OOol00g`BOomoo`22Ool00`00
Oomoo`2ROol001moo`03O19oogoo089oo`03001oogoo0:9oo`007goo00=l4WooOol0PWoo00<007oo
Ool0XWoo000NOol00g`BOomoo`23Ool00`00Oomoo`2ROol001ioo`03O19oogoo08=oo`03001oogoo
0:9oo`007Woo00=l4WooOol0Pgoo00<007ooOol0XWoo000NOol00g`BOomoo`23Ool2002SOol001eo
o`03O19oogoo08Aoo`03001oogoo0:9oo`007Goo00=l4WooOol0Q7oo00<007ooOol0XWoo000MOol0
0g`BOomoo`24Ool00`00Oomoo`2ROol001aoo`03O19oogoo08Eoo`03001oogoo0:9oo`0077oo00=l
4WooOol0QGoo00<007ooOol0XWoo000LOol00g`BOomoo`25Ool00`00Oomoo`2ROol001aoo`03O19o
ogoo08Eoo`03001oogoo0:9oo`006goo00=l4WooOol0QWoo00<007ooOol0XWoo000KOol00g`BOomo
o`26Ool00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 .3 r
.5 Mabswid
.05803 .61803 m
.06244 .59883 L
.10458 .4588 L
.12507 .40549 L
.14415 .3638 L
.16371 .32856 L
.18221 .30175 L
.20262 .27896 L
.2212 .26397 L
.2309 .25816 L
.24117 .25342 L
.24995 .25047 L
.25494 .24923 L
.25962 .24834 L
.26219 .24797 L
.26458 .24769 L
.2672 .24746 L
.26867 .24736 L
.27 .24729 L
.27127 .24725 L
.27244 .24722 L
.27372 .24721 L
.27437 .24722 L
.27508 .24722 L
.27627 .24725 L
.27755 .24729 L
.27876 .24735 L
.27986 .24741 L
.28223 .24759 L
.28442 .24781 L
.28938 .24849 L
.29374 .24929 L
.29839 .25034 L
.30776 .25305 L
.31786 .25681 L
.33614 .26562 L
.37728 .29289 L
.4169 .32529 L
.45501 .35809 L
.49557 .39045 L
.51431 .40326 L
.53462 .41492 L
.54572 .42011 L
.55596 .42404 L
.56575 .42698 L
.57069 .42812 L
.57611 .42912 L
.57861 .42948 L
.58133 .42981 L
.5839 .43004 L
Mistroke
.58512 .43013 L
.58628 .4302 L
.58741 .43025 L
.58864 .4303 L
.58975 .43032 L
.59077 .43033 L
.59188 .43033 L
.5931 .43032 L
.59438 .43028 L
.59556 .43023 L
.59686 .43016 L
.59828 .43006 L
.60084 .42983 L
.60334 .42952 L
.60565 .42917 L
.61089 .42815 L
.61645 .42669 L
.62585 .42334 L
.63596 .41842 L
.65426 .40585 L
.66385 .39724 L
.67434 .38616 L
.69545 .35823 L
.7151 .32502 L
.73606 .28131 L
.77761 .16699 L
.81765 .01819 L
Mfstroke
.81765 .01819 m
.82147 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00Hgoo00=l2GooOol0?7oo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0Hgoo00=l2Goo
Ool0?7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0Hgoo
00=l2GooOol0?7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`1ROol00g`9Oomoo`0mOol008Yoo`@000ioo`8000Ioo`03001oogoo069oo`03O0Uoogoo03eoo`00
Y7oo00<007ooOol0HWoo00=l2GooOol0?Goo002TOol00`00Oomoo`1ROol00g`9Oomoo`0mOol00:Ao
o`03001oogoo065oo`03O0Uoogoo03ioo`00Y7oo00<007ooOol0HGoo00=l2GooOol0?Woo002TOol0
0`00Oomoo`1QOol00g`9Oomoo`0nOol00:Aoo`80069oo`03O0Uoogoo03ioo`00Y7oo00<007ooOol0
H7oo00=l2GooOol0?goo002TOol00`00Oomoo`1POol00g`9Oomoo`0oOol00:Aoo`03001oogoo061o
o`03O0Uoogoo03moo`00Y7oo00<007ooOol0H7oo00=l2GooOol0?goo002TOol00`00Oomoo`1OOol0
0g`9Oomoo`10Ool00:Aoo`03001oogoo05moo`03O0Uoogoo041oo`00Y7oo00<007ooOol0Ggoo00=l
2GooOol0@7oo002TOol00`00Oomoo`1NOol00g`9Oomoo`11Ool00:Aoo`8005moo`03O0Uoogoo045o
o`00Y7oo00<007ooOol0GWoo00=l2GooOol0@Goo002TOol00`00Oomoo`1NOol00g`9Oomoo`11Ool0
0:Aoo`03001oogoo05eoo`03O0Uoogoo049oo`00Y7oo00<007ooOol0GGoo00=l2GooOol0@Woo002T
Ool00`00Oomoo`1MOol00g`9Oomoo`12Ool00:Aoo`03001oogoo05eoo`03O0Uoogoo049oo`00Y7oo
00<007ooOol0G7oo00=l2GooOol0@goo002TOol00`00Oomoo`1LOol00g`9Oomoo`13Ool00:Aoo`03
001oogoo05aoo`03O0Uoogoo04=oo`00Y7oo0P00G7oo00=l2GooOol0A7oo002TOol00`00Oomoo`1K
Ool00g`9Oomoo`14Ool00:Aoo`03001oogoo05]oo`03O0Uoogoo04Aoo`00Y7oo00<007ooOol0Fgoo
00=l2GooOol0A7oo002TOol00`00Oomoo`1JOol00g`9Oomoo`15Ool00:Aoo`03001oogoo05Yoo`03
O0Uoogoo04Eoo`00Y7oo00<007ooOol0FWoo00=l2GooOol0AGoo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1JOol00g`9Oomoo`15Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1IOol00g`9Oomoo`16Ool008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo05Uoo`03O0Uoogoo04Ioo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00FGoo00=l2GooOol0AWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1IOol00g`9Oomoo`16Ool008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo05Qoo`03O0Uoogoo04Mo
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo05Qoo`03
O0Uoogoo04Moo`00RWoo100037oo0`001goo00<007ooOol0F7oo00=l2GooOol0Agoo002TOol00`00
Oomoo`1GOol00g`9Oomoo`18Ool00:Aoo`03001oogoo05Moo`03O0Uoogoo04Qoo`00Y7oo00<007oo
Ool0Egoo00=l2GooOol0B7oo002TOol00`00Oomoo`1GOol00g`9Oomoo`18Ool00:Aoo`03001oogoo
05Ioo`03O0Uoogoo04Uoo`00Y7oo0P00Egoo00=l2GooOol0BGoo002TOol00`00Oomoo`1FOol00g`9
Oomoo`19Ool00:Aoo`03001oogoo05Ioo`03O0Uoogoo04Uoo`00Y7oo00<007ooOol0EGoo00=l2Goo
Ool0BWoo002TOol00`00Oomoo`1EOol00g`9Oomoo`1:Ool00:Aoo`03001oogoo05Eoo`03O0Uoogoo
04Yoo`00Y7oo00<007ooOol0E7oo00=l2GooOol0Bgoo002TOol00`00Oomoo`1DOol00g`9Oomoo`1;
Ool00:Aoo`03001oogoo05Aoo`03O0Uoogoo04]oo`00Y7oo00<007ooOol0Dgoo00=l2GooOol0C7oo
002TOol2001DOol00g`9Oomoo`1<Ool00:Aoo`03001oogoo059oo`03O0Uoogoo04eoo`00Y7oo00<0
07ooOol0DWoo00=l2GooOol0CGoo002TOol00`00Oomoo`1BOol00g`9Oomoo`1=Ool000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D000Ioo`03O0Uoogoo03eoo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo00Ioo`03O0Uoogoo03eoo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo00Io
o`03O0Uoogoo03ioo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol01Goo00=l2GooOol0@7oo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool00`00Oomoo`05Ool00g`9Oomoo`11Ool0
0`00Oomoo`0;Ool0015oo`03001oogoo04Qoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo
00Eoo`03O0Uoogoo049oo`03001oogoo00Yoo`003Goo00D007ooOomoo`0004Qoo`<004Moo`8004Mo
o`<000Ioo`03O0Uoogoo03moo`05001oogooOol0000<Ool000ioo`<004]oo`03001oogoo04Eoo`03
001oogoo04Qoo`03001oogoo00Aoo`03O0Uoogoo041oo`<000eoo`00Y7oo00<007ooOol0CWoo00=l
2GooOol0DGoo002TOol00`00Oomoo`1>Ool00g`9Oomoo`1AOol00:Aoo`03001oogoo04ioo`03O0Uo
ogoo055oo`00Y7oo00<007ooOol0CGoo00=l2GooOol0DWoo002TOol00`00Oomoo`1=Ool00g`9Oomo
o`1BOol00:Aoo`03001oogoo04eoo`03O0Uoogoo059oo`00Y7oo00<007ooOol0C7oo00=l2GooOol0
Dgoo0004OomE0006O0VD00000g`90000001>0005Ool000aoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00Moo`Ml2@Aoo`Ml2@9oo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00ao
o`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`05001oogooOoml2@0;Ool00`00Oomo
o`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool000aoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00Eoo`9l
2@Eoo`03001oogoo00Yoo`=l2@ioo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03
001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`04
001oogooO0T<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool0
0`00Oomoo`0;Ool004moo`9l2AMoo`=l2CUoo`03001oogoo04]oo`03O0Uoogoo05Aoo`00CWoo00=l
2GooOol06Woo0W`9=goo00<007ooOol0Bgoo00=l2GooOol0E7oo001<Ool2O0TOOol2O0TeOol00`00
Oomoo`1:Ool00g`9Oomoo`1EOol004]oo`03O0Uoogoo025oo`03O0Uoogoo039oo`03001oogoo04Yo
o`03O0Uoogoo05Eoo`00BWoo00=l2GooOol08goo0W`9<Woo00<007ooOol0BGoo00=l2GooOol0EWoo
0019Ool00g`9Oomoo`0VOol00g`9Oomoo`0_Ool00`00Oomoo`19Ool00g`9Oomoo`1FOol004Moo`9l
2BYoo`9l2Bmoo`03001oogoo04Uoo`03O0Uoogoo05Ioo`00AWoo00=l2GooOol0;7oo00=l2GooOol0
;7oo0P00BGoo00=l2GooOol0Egoo0015Ool00g`9Oomoo`0^Ool2O0T/Ool00`00Oomoo`18Ool00g`9
Oomoo`1GOol004Aoo`03O0Uoogoo035oo`9l2BYoo`03001oogoo04Moo`03O0Uoogoo05Qoo`00@goo
00=l2GooOol0=7oo00=l2GooOol09goo00<007ooOol0Agoo00=l2GooOol0F7oo0012Ool00g`9Oomo
o`0fOol2O0TWOol00`00Oomoo`16Ool00g`9Oomoo`1IOol0045oo`03O0Uoogoo03Uoo`03O0Uoogoo
02Aoo`03001oogoo04Ioo`03O0Uoogoo05Uoo`00@7oo00=l2GooOol0>goo00=l2GooOol08goo00<0
07ooOol0AGoo00=l2GooOol0FWoo000oOol00g`9Oomoo`0mOol00g`9Oomoo`0ROol00`00Oomoo`15
Ool00g`9Oomoo`1JOol003ioo`03O0Uoogoo03moo`9l2B9oo`03001oogoo04Aoo`03O0Uoogoo05]o
o`00?Goo00=l2GooOol0@Woo00=l2GooOol07goo00<007ooOol0A7oo00=l2GooOol0Fgoo000mOol0
0g`9Oomoo`13Ool00g`9Oomoo`0NOol20014Ool00g`9Oomoo`1LOol003aoo`03O0Uoogoo04Eoo`03
O0Uoogoo01eoo`03001oogoo04=oo`03O0Uoogoo05aoo`00>goo00=l2GooOol0Agoo00=l2GooOol0
77oo00<007ooOol0@Woo00=l2GooOol0GGoo000kOol00g`9Oomoo`18Ool2O0TLOol00`00Oomoo`12
Ool00g`9Oomoo`1MOol003Yoo`03O0Uoogoo04]oo`03O0Uoogoo01Uoo`03001oogoo045oo`03O0Uo
ogoo05ioo`00>Woo00=l2GooOol0C7oo00=l2GooOol067oo00<007ooOol0@Goo00=l2GooOol0GWoo
000iOol00g`9Oomoo`1>Ool00g`9Oomoo`0GOol00`00Oomoo`10Ool00g`9Oomoo`1OOol003Qoo`03
O0Uoogoo051oo`03O0Uoogoo01Ioo`03001oogoo041oo`03O0Uoogoo05moo`00>7oo00=l2GooOol0
DGoo00=l2GooOol05Goo00<007ooOol0?goo00=l2GooOol0H7oo000gOol00g`9Oomoo`1COol00g`9
Oomoo`0DOol00`00Oomoo`0oOol00g`9Oomoo`1POol003Moo`03O0Uoogoo05Aoo`03O0Uoogoo01=o
o`8003moo`03O0Uoogoo065oo`00=Woo00=l2GooOol0EWoo0W`94goo00<007ooOol0?Woo00=l2Goo
Ool0HGoo000eOol00g`9Oomoo`1IOol00g`9Oomoo`0@Ool00`00Oomoo`0mOol00g`9Oomoo`1ROol0
03Eoo`03O0Uoogoo05Yoo`03O0Uoogoo00moo`03001oogoo03eoo`03O0Uoogoo069oo`00=7oo00=l
2GooOol0G7oo00=l2GooOol03Woo00<007ooOol0?7oo00=l2GooOol0Hgoo000dOol00g`9Oomoo`1M
Ool00g`9Oomoo`0=Ool00`00Oomoo`0lOol00g`9Oomoo`1SOol003=oo`03O0Uoogoo05moo`03O0Uo
ogoo00aoo`03001oogoo03]oo`03O0Uoogoo06Aoo`00<goo00=l2GooOol0E7oo10001Goo0P0000Ao
og`9Oomoo`D000Ioo`03001oogoo03Yoo`03O0Uoogoo06Eoo`00<Woo00=l2GooOol0E7oo00<007oo
Ool00Woo00<007ooOol00Woo0P000Woo0W`900D007ooOomoo`0000Ioo`03001oogoo03Uoo`03O0Uo
ogoo06Ioo`00<Woo00=l2GooOol0E7oo00<007ooOol00Woo00<007ooOol027oo00=l2@00Ool027oo
00<007ooOol0>Goo00=l2GooOol0IWoo000aOol00g`9Oomoo`1EOol00`00Oomoo`02Ool00`00Oomo
o`09Ool00g`9001oo`07Ool3000hOol00g`9Oomoo`1WOol0035oo`03O0Uoogoo05Eoo`03001oogoo
009oo`03001oogoo00Yoo`9l2@Moo`03001oogoo03Moo`03O0Uoogoo06Qoo`00<7oo00=l2GooOol0
EWoo00<007ooOol00Woo00<007ooOol037oo00=l2GooOol017oo00<007ooOol0=Woo00=l2GooOol0
JGoo000`Ool00g`9Oomoo`1FOol00`00Oomoo`02Ool00`00Oomoo`08Ool01P00Oomoogoo001l2@Eo
o`03001oogoo03Ioo`03O0Uoogoo06Uoo`00;goo00=l2GooOol0F7oo100037oo0`000Woo0W`90goo
00<007ooOol0=Goo00=l2GooOol0JWoo000_Ool00g`9Oomoo`1_Ool017`9Oomoo`00=Woo00=l2Goo
Ool0Jgoo000^Ool00g`9Oomoo`1aOol00g`9Ool0000eOol00g`9Oomoo`1/Ool002ioo`03O0Uoogoo
079oo`9l2CAoo`03O0Uoogoo06eoo`00;Goo00=l2GooOol0M7oo00<007`9Ool0<Goo00=l2GooOol0
KWoo000]Ool00g`9Oomoo`1dOol01000Ooml2G`9;goo00=l2GooOol0Kgoo000/Ool00g`9Oomoo`1e
Ool20002Ool00g`9Oomoo`0[Ool00g`9Oomoo`1`Ool002aoo`03O0Uoogoo07Eoo`03001oogoo009o
o`9l2BYoo`03O0Uoogoo075oo`00;7oo00=l2GooOol0MGoo00<007ooOol017oo0W`99Woo0W`9M7oo
000[Ool00g`9Oomoo`1fOol00`00Oomoo`06Ool2O0TSOol00g`9Oomoo`1dOol002]oo`03O0Uoogoo
07Ioo`03001oogoo00Qoo`9l2Amoo`9l2GMoo`00:goo00=l2GooOol0MWoo00<007ooOol02Woo0W`9
6goo0W`9NGoo000ZOol00g`9Oomoo`1gOol00`00Oomoo`0<Ool2O0TGOol2O0UkOol002Yoo`03O0Uo
ogoo07Moo`03001oogoo00ioo`9l2A=oo`9l2Geoo`00:Woo00=l2GooOol0Mgoo00<007ooOol047oo
1g`91goo1G`9Ogoo000YOol00g`9Oomoo`1hOol2000HOol7O0V4Ool002Uoo`03O0Uoogoo07Qoo`03
001oogoo0:9oo`00:7oo00=l2GooOol0NGoo00<007ooOol0XWoo000XOol00g`9Oomoo`1iOol00`00
Oomoo`2ROol002Qoo`03O0Uoogoo07Uoo`03001oogoo0:9oo`009goo00=l2GooOol0NWoo00<007oo
Ool0XWoo000WOol00g`9Oomoo`1jOol00`00Oomoo`2ROol002Moo`03O0Uoogoo07Yoo`03001oogoo
0:9oo`009Woo00=l2GooOol0Ngoo00<007ooOol0XWoo000VOol00g`9Oomoo`1kOol00`00Oomoo`2R
Ool002Ioo`03O0Uoogoo07]oo`800:=oo`009Goo00=l2GooOol0O7oo00<007ooOol0XWoo000UOol0
0g`9Oomoo`1lOol00`00Oomoo`2ROol002Eoo`03O0Uoogoo07aoo`03001oogoo0:9oo`0097oo00=l
2GooOol0OGoo00<007ooOol0XWoo000TOol00g`9Oomoo`1mOol00`00Oomoo`2ROol002Aoo`03O0Uo
ogoo07eoo`03001oogoo0:9oo`008goo00=l2GooOol0I7oo10001Goo0P001goo0`001Goo00<007oo
Ool0XWoo000SOol00g`9Oomoo`1SOol00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomo
o`04Ool00`00Oomoo`2ROol002=oo`03O0Uoogoo06=oo`03001oogoo009oo`03001oogoo00aoo`03
001oogoo00Aoo`03001oogoo0:9oo`008Woo00=l2GooOol0I7oo00<007ooOol00Woo00<007ooOol0
27oo1P001Goo0`00XWoo000ROol00g`9Oomoo`1TOol00`00Oomoo`02Ool00`00Oomoo`09Ool01000
Oomoo`001Woo00<007ooOol0XWoo000ROol00g`9Oomoo`1TOol00`00Oomoo`02Ool00`00Oomoo`09
Ool01000Oomoo`001Woo00<007ooOol0XWoo000ROol00g`9Oomoo`1TOol00`00Oomoo`02Ool00`00
Oomoo`0:Ool00`00Ool00006Ool00`00Oomoo`2ROol0025oo`03O0Uoogoo06Ioo`@000ioo`8000Io
o`03001oogoo0:9oo`008Goo00=l2GooOol0P7oo00<007ooOol0XWoo000QOol00g`9Oomoo`20Ool0
0`00Oomoo`2ROol0021oo`03O0Uoogoo085oo`03001oogoo0:9oo`0087oo00=l2GooOol0PGoo00<0
07ooOol0XWoo000POol00g`9Oomoo`21Ool00`00Oomoo`2ROol001moo`03O0Uoogoo089oo`800:=o
o`007goo00=l2GooOol0PWoo00<007ooOol0XWoo000OOol00g`9Oomoo`22Ool00`00Oomoo`2ROol0
01ioo`03O0Uoogoo08=oo`03001oogoo0:9oo`007Woo00=l2GooOol0Pgoo00<007ooOol0XWoo000N
Ool00g`9Oomoo`23Ool00`00Oomoo`2ROol001eoo`03O0Uoogoo08Aoo`03001oogoo0:9oo`007Goo
00=l2GooOol0Q7oo00<007ooOol0XWoo000MOol00g`9Oomoo`24Ool00`00Oomoo`2ROol001aoo`03
O0Uoogoo08Eoo`03001oogoo0:9oo`0077oo00=l2GooOol0QGoo0P00Xgoo000LOol00g`9Oomoo`25
Ool00`00Oomoo`2ROol001]oo`03O0Uoogoo08Ioo`03001oogoo0:9oo`006goo00=l2GooOol0QWoo
00<007ooOol0XWoo000KOol00g`9Oomoo`26Ool00`00Oomoo`2ROol001]oo`03O0Uoogoo08Ioo`03
001oogoo0:9oo`006Woo00=l2GooOol0Qgoo00<007ooOol0XWoo000JOol00g`9Oomoo`27Ool00`00
Oomoo`2ROol001Yoo`03O0Uoogoo08Moo`03001oogoo0:9oo`006Goo00=l2GooOol0R7oo00<007oo
Ool0XWoo000IOol00g`9Oomoo`28Ool2002SOol001Uoo`03O0Uoogoo08Qoo`03001oogoo0:9oo`00
67oo00=l2GooOol0RGoo00<007ooOol0XWoo000HOol00g`9Oomoo`29Ool00`00Oomoo`2ROol001Qo
o`03O0Uoogoo08Uoo`03001oogoo0:9oo`0067oo00=l2GooOol0RGoo00<007ooOol0XWoo000GOol0
0g`9Oomoo`2:Ool00`00Oomoo`2ROol001Moo`03O0Uoogoo08Yoo`03001oogoo0:9oo`005goo00=l
2GooOol0RWoo00<007ooOol0XWoo000GOol00g`9Oomoo`2:Ool00`00Oomoo`2ROol00001\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.247214 0.618034 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -18 -4.5 ]
[.4875 .49443 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .24721 m
.02381 .25346 L
s
[(-2)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-1)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(1)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(2)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.07143 .24721 m
.07143 .25096 L
s
.11905 .24721 m
.11905 .25096 L
s
.16667 .24721 m
.16667 .25096 L
s
.21429 .24721 m
.21429 .25096 L
s
.30952 .24721 m
.30952 .25096 L
s
.35714 .24721 m
.35714 .25096 L
s
.40476 .24721 m
.40476 .25096 L
s
.45238 .24721 m
.45238 .25096 L
s
.54762 .24721 m
.54762 .25096 L
s
.59524 .24721 m
.59524 .25096 L
s
.64286 .24721 m
.64286 .25096 L
s
.69048 .24721 m
.69048 .25096 L
s
.78571 .24721 m
.78571 .25096 L
s
.83333 .24721 m
.83333 .25096 L
s
.88095 .24721 m
.88095 .25096 L
s
.92857 .24721 m
.92857 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-0.4)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.2)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(0.4)] .4875 .49443 1 0 Mshowa
.125 Mabswid
.5 .0309 m
.50375 .0309 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.0468 .61803 m
.06244 .55492 L
.10458 .42671 L
.12507 .37861 L
.14415 .34149 L
.16371 .31061 L
.18221 .28763 L
.192 .27776 L
.20262 .26875 L
.21222 .26208 L
.2212 .25702 L
.23064 .25289 L
.23607 .25105 L
.24104 .24969 L
.24623 .2486 L
.24862 .2482 L
.25117 .24786 L
.25387 .24757 L
.25508 .24747 L
.25638 .24738 L
.25718 .24734 L
.25792 .2473 L
.25861 .24727 L
.25936 .24725 L
.26068 .24722 L
.2614 .24722 L
.26207 .24721 L
.26333 .24722 L
.26397 .24724 L
.26467 .24725 L
.26591 .2473 L
.26707 .24736 L
.26969 .24754 L
.27252 .24781 L
.27768 .24853 L
.28242 .24941 L
.29146 .25168 L
.30098 .25485 L
.32072 .26374 L
.33908 .27442 L
.37813 .30288 L
.41963 .3379 L
.45961 .37182 L
.49808 .40046 L
.51756 .41222 L
.52789 .41745 L
.53899 .4222 L
.54963 .42582 L
.55935 .42824 L
.56403 .42909 L
Mistroke
.56649 .42946 L
.56912 .42978 L
.57165 .43002 L
.57394 .43018 L
.57504 .43023 L
.57623 .43028 L
.57736 .43031 L
.5784 .43033 L
.57967 .43033 L
.58087 .43032 L
.58194 .4303 L
.58311 .43026 L
.58438 .4302 L
.58574 .43011 L
.58816 .42991 L
.59039 .42966 L
.59249 .42937 L
.59726 .42852 L
.60246 .42729 L
.60722 .42586 L
.61794 .42157 L
.62777 .41627 L
.6369 .41011 L
.65761 .39147 L
.67811 .36616 L
.69671 .33678 L
.73675 .2507 L
.77526 .13508 L
Mfstroke
.77526 .13508 m
.80927 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.438, 162.75},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000ba000`40O003h00OogooBWoo003oOom:
Ool00?moodYoo`00RWoo10001Goo0P001goo0`00ZWoo0029Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20008Ool00`00Oomoo`2YOol008Uoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo0:Uo
o`00PGoo1P000Woo00<007ooOol00Woo00<007ooOol027oo1P001Goo0`00Ggoo00=l07ooOol0@7oo
0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0Ggoo00=l07oo
Ool0@7oo0029Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0GWoo
00=l07ooOol0@Goo0029Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool00006Ool00`00Oomo
o`1NOol00g`0Oomoo`11Ool008Yoo`@000ioo`8000Ioo`03001oogoo05ioo`03O01oogoo045oo`00
Y7oo00<007ooOol0GWoo00=l07ooOol0@Goo002TOol00`00Oomoo`1MOol00g`0Oomoo`12Ool00:Ao
o`03001oogoo05eoo`03O01oogoo049oo`00Y7oo00<007ooOol0GGoo00=l07ooOol0@Woo002TOol0
0`00Oomoo`1MOol00g`0Oomoo`12Ool00:Aoo`8005eoo`03O01oogoo04=oo`00Y7oo00<007ooOol0
G7oo00=l07ooOol0@goo002TOol00`00Oomoo`1LOol00g`0Oomoo`13Ool00:Aoo`03001oogoo05ao
o`03O01oogoo04=oo`00Y7oo00<007ooOol0Fgoo00=l07ooOol0A7oo002TOol00`00Oomoo`1KOol0
0g`0Oomoo`14Ool00:Aoo`03001oogoo05]oo`03O01oogoo04Aoo`00Y7oo00<007ooOol0Fgoo00=l
07ooOol0A7oo002TOol00`00Oomoo`1JOol00g`0Oomoo`15Ool00:Aoo`8005]oo`03O01oogoo04Eo
o`00Y7oo00<007ooOol0FWoo00=l07ooOol0AGoo002TOol00`00Oomoo`1JOol00g`0Oomoo`15Ool0
0:Aoo`03001oogoo05Uoo`03O01oogoo04Ioo`00Y7oo00<007ooOol0FGoo00=l07ooOol0AWoo002T
Ool00`00Oomoo`1IOol00g`0Oomoo`16Ool00:Aoo`03001oogoo05Uoo`03O01oogoo04Ioo`00Y7oo
00<007ooOol0F7oo00=l07ooOol0Agoo002TOol00`00Oomoo`1HOol00g`0Oomoo`17Ool00:Aoo`03
001oogoo05Qoo`03O01oogoo04Moo`00Y7oo0P00FGoo00=l07ooOol0Agoo002TOol00`00Oomoo`1G
Ool00g`0Oomoo`18Ool00:Aoo`03001oogoo05Moo`03O01oogoo04Qoo`00Y7oo00<007ooOol0Egoo
00=l07ooOol0B7oo002TOol00`00Oomoo`1GOol00g`0Oomoo`18Ool00:Aoo`03001oogoo05Ioo`03
O01oogoo04Uoo`00Y7oo00<007ooOol0EWoo00=l07ooOol0BGoo002:Ool40005Ool20004Ool50006
Ool00`00Oomoo`1FOol00g`0Oomoo`19Ool008Uoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`05001oogooOol00006Ool00`00Oomoo`1FOol00g`0Oomoo`19Ool008Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo05Eoo`03O01oogoo04Yoo`00PGoo1P000Woo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol01Woo0`00EGoo00=l07ooOol0BWoo0029Ool00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1EOol00g`0Oomoo`1:Ool008Uo
o`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Aoo`03001oogoo05Eoo`03O01oogoo04Yo
o`00RGoo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ioo`03001oogoo05Aoo`03
O01oogoo04]oo`00RWoo100037oo0`001goo00<007ooOol0E7oo00=l07ooOol0Bgoo002TOol00`00
Oomoo`1DOol00g`0Oomoo`1;Ool00:Aoo`03001oogoo05=oo`03O01oogoo04aoo`00Y7oo00<007oo
Ool0Dgoo00=l07ooOol0C7oo002TOol00`00Oomoo`1COol00g`0Oomoo`1<Ool00:Aoo`03001oogoo
059oo`03O01oogoo04eoo`00Y7oo0P00Dgoo00=l07ooOol0CGoo002TOol00`00Oomoo`1BOol00g`0
Oomoo`1=Ool00:Aoo`03001oogoo055oo`03O01oogoo04ioo`00Y7oo00<007ooOol0DGoo00=l07oo
Ool0CWoo002TOol00`00Oomoo`1AOol00g`0Oomoo`1>Ool00:Aoo`03001oogoo051oo`03O01oogoo
04moo`00Y7oo00<007ooOol0D7oo00=l07ooOol0Cgoo002TOol00`00Oomoo`1@Ool00g`0Oomoo`1?
Ool00:Aoo`03001oogoo04moo`03O01oogoo051oo`00Y7oo00<007ooOol0Cgoo00=l07ooOol0D7oo
002TOol2001@Ool00g`0Oomoo`1@Ool00:Aoo`03001oogoo04ioo`03O01oogoo055oo`00Y7oo00<0
07ooOol0CWoo00=l07ooOol0DGoo002TOol00`00Oomoo`1>Ool00g`0Oomoo`1AOol000eoo`D004Qo
o`D004Eoo`03001oogoo04Ioo`D000=oo`03O01oogoo041oo`D000aoo`003Goo00D007ooOomoo`00
04Yoo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo009oo`03O01oogoo045oo`05001oogoo
Ool0000<Ool000ioo`03001oogoo04]oo`03001oogoo04Eoo`03001oogoo04Qoo`03001oogoo009o
o`03O01oogoo049oo`03001oogoo00eoo`001Goo1P0017oo00<007ooOol0?goo1P001Goo00<007oo
Ool0AGoo00<007ooOol0B7oo00<007ooOol00Woo00=l07ooOol0@goo00<007ooOol037oo000@Ool0
0`00Oomoo`19Ool00`00Oomoo`15Ool00`00Oomoo`18Ool01@00OomoogooO000Agoo00<007ooOol0
2goo000AOol00`00Oomoo`18Ool00`00Oomoo`15Ool00`00Oomoo`18Ool01@00OomoogooO000B7oo
00<007ooOol02Woo000=Ool01@00Oomoogoo0000B7oo0`00Agoo0P00Agoo0`000goo00=l07ooOol0
@Woo00D007ooOomoo`0000aoo`003Woo0`00Bgoo00<007ooOol0AGoo00<007ooOol0B7oo00@007oo
Ooml04Ioo`<000eoo`00Y7oo00<007ooOol0Bgoo00=l07ooOol0E7oo002TOol00`00Oomoo`1;Ool0
0g`0Oomoo`1DOol00:Aoo`03001oogoo04Yoo`03O01oogoo05Eoo`00Y7oo00<007ooOol0BWoo00=l
07ooOol0EGoo002TOol00`00Oomoo`1:Ool00g`0Oomoo`1EOol00:Aoo`03001oogoo04Uoo`03O01o
ogoo05Ioo`00Y7oo00<007ooOol0BGoo00=l07ooOol0EWoo0004OomB0004O02F00000g`00000001A
0005Ool000aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00eoo`03
001oogoo00Eoo`El009oo`03001oog`000El00Moo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00aoo`03O01oogoo00eoo`03001oogoo00aoo`03001oogoo00aoo`03001o
ogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`0037oo00<007ooOol037oo00<007ooOol037oo
00<007ooOol037oo00<007ooOol03Goo00<007ooOol00Woo0g`01goo00<007ooOol01Goo0g`017oo
00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo
00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00=l07ooOol03Goo
00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol02goo
001<Ool2O00EOol3O00nOol00`00Oomoo`18Ool00g`0Oomoo`1GOol004Yoo`9l01Yoo`9l03aoo`03
001oogoo04Moo`03O01oogoo05Qoo`00B7oo0W`07Woo0W`0>Woo00<007ooOol0Agoo00=l07ooOol0
F7oo0016Ool2O00ROol2O00hOol00`00Oomoo`16Ool00g`0Oomoo`1IOol004Eoo`03O01oogoo02Ao
o`9l03Ioo`03001oogoo04Ioo`03O01oogoo05Uoo`00A7oo00=l07ooOol09goo0W`0=7oo00<007oo
Ool0AGoo00=l07ooOol0FWoo0013Ool00g`0Oomoo`0ZOol00g`0Oomoo`0aOol00`00Oomoo`15Ool0
0g`0Oomoo`1JOol0049oo`03O01oogoo02aoo`9l035oo`8004Eoo`03O01oogoo05]oo`00@Goo00=l
07ooOol0;goo00=l07ooOol0;Woo00<007ooOol0A7oo00=l07ooOol0Fgoo000oOol2O00cOol2O00^
Ool00`00Oomoo`13Ool00g`0Oomoo`1LOol003ioo`03O01oogoo03Eoo`03O01oogoo02]oo`03001o
ogoo04=oo`03O01oogoo05aoo`00?Goo00=l07ooOol0=goo00=l07ooOol0:Woo00<007ooOol0@Woo
00=l07ooOol0GGoo000mOol00g`0Oomoo`0hOol2O00ZOol00`00Oomoo`12Ool00g`0Oomoo`1MOol0
03aoo`03O01oogoo03]oo`03O01oogoo02Moo`03001oogoo045oo`03O01oogoo05ioo`00>goo00=l
07ooOol0?Goo0W`09goo00<007ooOol0@Goo00=l07ooOol0GWoo000kOol00g`0Oomoo`0oOol00g`0
Oomoo`0TOol00`00Oomoo`10Ool00g`0Oomoo`1OOol003Yoo`03O01oogoo045oo`03O01oogoo02=o
o`03001oogoo041oo`03O01oogoo05moo`00>Woo00=l07ooOol0@Woo00=l07ooOol08Woo0P00@7oo
00=l07ooOol0H7oo000iOol00g`0Oomoo`14Ool2O00ROol00`00Oomoo`0oOol00g`0Oomoo`1POol0
03Qoo`03O01oogoo04Moo`03O01oogoo01moo`03001oogoo03ioo`03O01oogoo065oo`00=goo00=l
07ooOol0BGoo00=l07ooOol07Woo00<007ooOol0?Woo00=l07ooOol0HGoo000gOol00g`0Oomoo`1:
Ool00g`0Oomoo`0MOol00`00Oomoo`0mOol00g`0Oomoo`1ROol003Ioo`03O01oogoo04aoo`03O01o
ogoo01aoo`03001oogoo03eoo`03O01oogoo069oo`00=Goo00=l07ooOol0CWoo0W`077oo00<007oo
Ool0?7oo00=l07ooOol0Hgoo000dOol00g`0Oomoo`1AOol00g`0Oomoo`0IOol00`00Oomoo`0lOol0
0g`0Oomoo`1SOol003Aoo`03O01oogoo059oo`03O01oogoo01Qoo`03001oogoo03]oo`03O01oogoo
06Aoo`00<goo00=l07ooOol0E7oo00=l07ooOol05goo00<007ooOol0>goo00=l07ooOol0I7oo000b
Ool00g`0Oomoo`1FOol00g`0Oomoo`0FOol2000kOol00g`0Oomoo`1UOol0035oo`03O01oogoo05Qo
o`03O01oogoo01Eoo`03001oogoo03Yoo`03O01oogoo06Eoo`00<Goo00=l07ooOol0FGoo0W`05Goo
00<007ooOol0>Goo00=l07ooOol0IWoo000`Ool00g`0Oomoo`1LOol00g`0Oomoo`0BOol00`00Oomo
o`0hOol00g`0Oomoo`1WOol0031oo`03O01oogoo05eoo`03O01oogoo015oo`03001oogoo03Qoo`03
O01oogoo06Moo`00;goo00=l07ooOol0Ggoo00=l07ooOol047oo00<007ooOol0=goo00=l07ooOol0
J7oo000_Ool00g`0Oomoo`1POol00g`0Oomoo`0?Ool00`00Oomoo`0fOol00g`0Oomoo`1YOol002io
o`03O01oogoo05Uoo`@000Eoo`9l00Aoo`D000Ioo`03001oogoo03Ioo`03O01oogoo06Uoo`00;Woo
00=l07ooOol0F7oo00<007ooOol00Woo00<007ooOol00Woo0P0000El07ooOomoo`0000=oo`03001o
ogoo00Aoo`03001oogoo03Eoo`03O01oogoo06Yoo`00;Goo00=l07ooOol0FGoo00<007ooOol00Woo
00<007ooOol01Goo00El07ooOomoo`0000Uoo`03001oogoo03Aoo`03O01oogoo06]oo`00;Goo00=l
07ooOol0FGoo00<007ooOol00Woo00<007ooOol01Woo00El07ooOomoo`0000Qoo`<003=oo`03O01o
ogoo06aoo`00;7oo00=l07ooOol0FWoo00<007ooOol00Woo00<007ooOol01goo00El07ooOomoo`00
00Moo`03001oogoo03=oo`03O01oogoo06aoo`00;7oo00=l07ooOol0FWoo00<007ooOol00Woo00<0
07ooOol027oo0W`00Woo00<007ooOol017oo00<007ooOol0<Woo00=l07ooOol0KGoo000/Ool00g`0
Oomoo`1JOol00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Ooml07oo00001Woo00<007ooOol0<Goo
00=l07ooOol0KWoo000[Ool00g`0Oomoo`1LOol4000<Ool200000g`0Oomoo`05Ool00`00Oomoo`0`
Ool00g`0Oomoo`1_Ool002]oo`03O01oogoo06moo`9l00Eoo`03001oogoo031oo`03O01oogoo06mo
o`00:Woo00=l07ooOol0LWoo00=l07ooOol00Woo00<007ooOol0;goo00=l07ooOol0L7oo000ZOol0
0g`0Oomoo`1cOol01G`0Oomoogoo0000<7oo00=l07ooOol0LGoo000ZOol00g`0Oomoo`1dOol2O000
0goo001oo`0^Ool00g`0Oomoo`1bOol002Uoo`03O01oogoo07Moo`03O00007oo02aoo`9l07Eoo`00
:Goo00=l07ooOol0N7oo0W`0:goo00=l07ooOol0MGoo000YOol00g`0Oomoo`1hOol00`00Ooml000Y
Ool00g`0Oomoo`1fOol002Qoo`03O01oogoo07Uoo`03001oogoo009l02Ioo`03O01oogoo07Moo`00
:7oo00=l07ooOol0NGoo00<007ooOol00Woo00=l07ooOol08Goo0W`0NWoo000WOol00g`0Oomoo`1j
Ool00`00Oomoo`03Ool2O00POol00g`0Oomoo`1jOol002Moo`03O01oogoo07Yoo`03001oogoo00Eo
o`=l01]oo`9l07eoo`009goo00=l07ooOol0NWoo00<007ooOol027oo0g`05Woo0W`0Ogoo000VOol0
0g`0Oomoo`1kOol00`00Oomoo`0;Ool3O00AOol2O021Ool002Ioo`03O01oogoo07]oo`03001oogoo
00ioo`El00Moo`El08=oo`009Woo00=l07ooOol0Ngoo0P0057oo1g`0R7oo000UOol00g`0Oomoo`1l
Ool00`00Oomoo`2ROol002Eoo`03O01oogoo07aoo`03001oogoo0:9oo`009Goo00=l07ooOol0O7oo
00<007ooOol0XWoo000TOol00g`0Oomoo`1mOol00`00Oomoo`2ROol002Aoo`03O01oogoo07eoo`03
001oogoo0:9oo`0097oo00=l07ooOol0OGoo00<007ooOol0XWoo000SOol00g`0Oomoo`1nOol00`00
Oomoo`2ROol002=oo`03O01oogoo07ioo`03001oogoo0:9oo`008Woo00=l07ooOol0Ogoo00<007oo
Ool0XWoo000ROol00g`0Oomoo`1oOol2002SOol0029oo`03O01oogoo07moo`03001oogoo0:9oo`00
8Goo00=l07ooOol0P7oo00<007ooOol0XWoo000QOol00g`0Oomoo`20Ool00`00Oomoo`2ROol0025o
o`03O01oogoo081oo`03001oogoo0:9oo`0087oo00=l07ooOol0PGoo00<007ooOol0XWoo000POol0
0g`0Oomoo`21Ool00`00Oomoo`2ROol0021oo`03O01oogoo06Moo`@000Eoo`8000Moo`<000Eoo`03
001oogoo0:9oo`007goo00=l07ooOol0Igoo00<007ooOol00Woo00<007ooOol00Woo0P0027oo00<0
07ooOol017oo00<007ooOol0XWoo000OOol00g`0Oomoo`1WOol00`00Oomoo`02Ool00`00Oomoo`0<
Ool00`00Oomoo`04Ool00`00Oomoo`2ROol001moo`03O01oogoo06Moo`03001oogoo009oo`03001o
ogoo00Qoo`H000Eoo`<00:9oo`007Woo00=l07ooOol0J7oo00<007ooOol00Woo00<007ooOol02Goo
00@007ooOol000Ioo`03001oogoo0:9oo`007Woo00=l07ooOol0J7oo00<007ooOol00Woo00<007oo
Ool02Goo00@007ooOol000Ioo`03001oogoo0:9oo`007Woo00=l07ooOol0J7oo00<007ooOol00Woo
00<007ooOol02Woo00<007oo00001Woo00<007ooOol0XWoo000MOol00g`0Oomoo`1ZOol4000>Ool2
0006Ool00`00Oomoo`2ROol001eoo`03O01oogoo08Aoo`03001oogoo0:9oo`007Goo00=l07ooOol0
Q7oo00<007ooOol0XWoo000LOol00g`0Oomoo`25Ool00`00Oomoo`2ROol001aoo`03O01oogoo08Eo
o`03001oogoo0:9oo`006goo00=l07ooOol0QWoo00<007ooOol0XWoo000KOol00g`0Oomoo`26Ool2
002SOol001]oo`03O01oogoo08Ioo`03001oogoo0:9oo`006Woo00=l07ooOol0Qgoo00<007ooOol0
XWoo000JOol00g`0Oomoo`27Ool00`00Oomoo`2ROol001Yoo`03O01oogoo08Moo`03001oogoo0:9o
o`006Goo00=l07ooOol0R7oo00<007ooOol0XWoo000IOol00g`0Oomoo`28Ool00`00Oomoo`2ROol0
01Uoo`03O01oogoo08Qoo`03001oogoo0:9oo`0067oo00=l07ooOol0RGoo00<007ooOol0XWoo000H
Ool00g`0Oomoo`29Ool00`00Oomoo`2ROol001Qoo`03O01oogoo08Uoo`800:=oo`005goo00=l07oo
Ool0RWoo00<007ooOol0XWoo000GOol00g`0Oomoo`2:Ool00`00Oomoo`2ROol001Moo`03O01oogoo
08Yoo`03001oogoo0:9oo`005goo00=l07ooOol0RWoo00<007ooOol0XWoo000FOol00g`0Oomoo`2;
Ool00`00Oomoo`2ROol001Ioo`03O01oogoo08]oo`03001oogoo0:9oo`005Woo00=l07ooOol0Rgoo
00<007ooOol0XWoo000FOol00g`0Oomoo`2;Ool00`00Oomoo`2ROol001Eoo`03O01oogoo08aoo`03
001oogoo0:9oo`005Goo00=l07ooOol0S7oo0P00Xgoo000EOol00g`0Oomoo`2<Ool00`00Oomoo`2R
Ool001Eoo`03O01oogoo08aoo`03001oogoo0:9oo`0057oo00=l07ooOol0SGoo00<007ooOol0XWoo
000DOol00g`0Oomoo`2=Ool00`00Oomoo`2ROol001Aoo`03O01oogoo08eoo`03001oogoo0:9oo`00
57oo00=l07ooOol0SGoo00<007ooOol0XWoo000COol00g`0Oomoo`2>Ool00`00Oomoo`2ROol001=o
o`03O01oogoo08ioo`03001oogoo0:9oo`004goo00=l07ooOol0SWoo00<007ooOol0XWoo0000\
\>"],
  ImageRangeCache->{{{0, 328.25}, {202.438, 0}} -> {-2.16464, -0.428586, \
0.0164862, 0.00635125}}]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  "The sequence of graphs shows a continuous movement of the curve along the \
horizontal axis. This movement is created by the translation operator ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\[Epsilon]\)]],
  " if we continuously change \[Epsilon]. Each value of \[Epsilon] is \
represented by a different color in the animation. Another property of our \
translation is the associativity of the transformation which can be \
formulated by"
}], "Text",
  CellTags->{"continuous movement", "associativity"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(T[T[T[f[x], \[Alpha]], \[Beta]], \[Chi]] == 
      T[T[T[f[x], \[Alpha]], \[Chi]], \[Beta]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result ",
  StyleBox["True",
    FontSlant->"Italic"],
  " states that the exchange of two of the three parameters \[Alpha], \
\[Beta], and \[Chi] does not alter the final result. This specialty is not \
contained in the basic properties of a group. However, if a group satisfies \
the associativity, we call it an Abelian group. "
}], "Text",
  CellTags->"Abelian group"],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Another simple example of a one-parameter group is given by a rotation in \
the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane. This sort of point transformation is represented by the rules"
}], "Text",
  CellTags->{"rotation", "point transformation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rotation = {
        X \[Rule] 
          Function[{x, u, \[Epsilon]}, 
            x\ Cos[\[Epsilon]] - u\ Sin[\[Epsilon]]], \n\t\t
        U \[Rule] 
          Function[{x, u, \[Epsilon]}, 
            x\ Sin[\[Epsilon]] + u\ Cos[\[Epsilon]]]}\)], "Input",
  CellTags->"rule3"],

Cell[BoxData[
    \({X \[Rule] 
        Function[{x, u, \[Epsilon]}, 
          x\ Cos[\[Epsilon]] - u\ Sin[\[Epsilon]]], 
      U \[Rule] 
        Function[{x, u, \[Epsilon]}, x\ Sin[\[Epsilon]] + u\ Cos[\[Epsilon]]]}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The one-parameter group defined in ",
  StyleBox["rotation",
    FontSlant->"Italic"],
  " and its action can be visualized as motion in an ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane. To show the action, we take for \[Epsilon] = 0 an arbitrary point \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\((x\_0\),
            "TraditionalForm"], ",", \(u\_0\)}], TraditionalForm]]],
  ") in the plane and follow the motion of the point when \[Epsilon] varies. \
The image of the initial point will move along some curve. "
}], "Text",
  CellTags->"animation of a rotation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\tTable[
      ParametricPlot[
        Evaluate[\n\t
          \({X[x, u, \[Epsilon]], U[x, u, \[Epsilon]]} /. rotation\) /. {
              x \[Rule] 1, u \[Rule] 1}], \n\t\t{\[Epsilon], 0, end}, \n\t
        AspectRatio \[Rule] Automatic, 
        PlotRange \[Rule] {{\(-1.5\), 1.5}, {\(-1.5\), 1.5}}, 
        PlotStyle \[Rule] RGBColor[0, 0, 1], \n\t\t
        AxesLabel \[Rule] {"\<x\>", "\<u\>"}], 
      \t{end, N[2  \[Pi]\/20], N[2  \[Pi]], N[2  \[Pi]\/20]}]\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.82906 .83755 L
.82433 .8421 L
.81984 .8463 L
.81547 .85029 L
.81076 .85447 L
.80618 .85844 L
.80125 .86259 L
.79645 .86653 L
.79178 .87025 L
.78676 .87415 L
.78188 .87784 L
.77714 .88133 L
.77205 .88498 L
.7671 .88843 L
.7618 .89203 L
.75664 .89542 L
.75164 .89862 L
.74627 .90196 L
.74106 .90511 L
.73548 .90838 L
.73006 .91145 L
.72481 .91434 L
.71919 .91735 L
.71401 .92002 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00LGoo1P001Goo00<007ooOol0
17oo0`00R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00NWoo0`001Woo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo
00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00JWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo001Y
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qo
o`00HGoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00R7oo001YOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo001ZOol4000<Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0009Ool50004Ool20005Ool4000JOol5000JOol40005Ool20005Ool4
000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool0
00]oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03
001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<0
07ooOol03goo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol06Woo00<0
07ooOol077oo00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`0?Ool00`00Oomo
o`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomo
o`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001oogoo00]oo`@001aoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol0
2goo00<007ooOol07Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
6Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol07Woo00<007ooOol0
77oo00<007ooOol02goo00<007ooOol03Goo0009Ool3000=Ool00`00Oomoo`0KOol3000KOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0JOol2000JOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0LOol3000LOol3000=Ool00`00Oomoo`0=Ool000]oo`03001oogoo00]oo`D001]o
o`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo01ao
o`03001oogoo00]oo`D000]oo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo07]oo`80009oo`8000Moo`00Pgoo00<007ooOol0O7oo00@007ooOol000Qoo`00Pgoo00<0
07ooOol0OGoo0P002Goo0023Ool00`00Oomoo`1mOol20009Ool000moonX000Uoo`04001oogoo0008
Ool000moo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00
Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool0
0`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol40005Ool20005
Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0R7oo001YOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool30028Ool006Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`00
JGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo001YOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool006Yoo`@000aoo`D000Ao
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo
08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001jOol50004Ool00`00Oomoo`28Ool0
07aoo`03001oogoo00Aoo`03001oogoo08Qoo`00O7oo00<007ooOol017oo00<007ooOol0R7oo001l
Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol007aoo`03001oogoo00Aoo`03001oogoo04Yo
o`0301moogoo03]oo`00O7oo00<007ooOol017oo00<007ooOol0BGoo00<07gooOol0?7oo001jOol3
0006Ool00`00Oomoo`18Ool00`0OOomoo`0mOol007aoo`03001oogoo00Aoo`03001oogoo04Moo`03
01moogoo03ioo`00Pgoo00<007ooOol0AWoo00<07gooOol0?goo0023Ool00`00Oomoo`14Ool201m2
Ool008=oo`03001oogoo049oo`807dAoo`00Pgoo0P00@Woo00<07gooOol0A7oo0023Ool00`00Oomo
o`10Ool00`0OOomoo`15Ool008=oo`03001oogoo03moo`0301moogoo04Ioo`00Pgoo00<007ooOol0
?Woo00<07gooOol0Agoo0023Ool00`00Oomoo`0mOol00`0OOomoo`18Ool008=oo`03001oogoo03Yo
o`<07d]oo`00Pgoo00<007ooOol0>Goo00<07gooOol0C7oo0023Ool2000iOol00`0OOomoo`1=Ool0
08=oo`03001oogoo03Eoo`<07e1oo`00Pgoo00<007ooOol0=7oo00<07gooOol0DGoo0023Ool00`00
Oomoo`0cOol00`0OOomoo`1BOol008=oo`03001oogoo031oo`<07eEoo`00Pgoo00<007ooOol0;goo
00<07gooOol0EWoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo0P00RGoo0023
Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=o
o`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00
Pgoo00<007ooOol0R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001o
ogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007oo
Ool03goo00<007ooOol00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool3
0028Ool006aoo`03001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001Z
Ool3000=Ool00`00Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool0
0?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0
000008Qoo`00P7oo00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomo
ogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo
3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0
0?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.82473 .84172 L
.81511 .85061 L
.80585 .85872 L
.79674 .86629 L
.78685 .87408 L
.77713 .88134 L
.7666 .88877 L
.75627 .89566 L
.74616 .90203 L
.73524 .90852 L
.72455 .91449 L
.71414 .91996 L
.7029 .9255 L
.69195 .93055 L
.68017 .93561 L
.6687 .94018 L
.65756 .9443 L
.64559 .94836 L
.63397 .95197 L
.62152 .95547 L
.60944 .95853 L
.59774 .96116 L
.58523 .96364 L
.57374 .9656 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00LGoo1P001Goo00<007ooOol0
17oo0`00R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00NWoo0`001Woo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo
00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00JWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo001Y
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qo
o`00HGoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00R7oo001YOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo001ZOol4000<Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0009Ool50004Ool20005Ool4000JOol5000JOol40005Ool20005Ool4
000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool0
00]oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03
001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<0
07ooOol03goo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol06Woo00<0
07ooOol077oo00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`0?Ool00`00Oomo
o`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomo
o`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001oogoo00]oo`@001aoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol0
2goo00<007ooOol07Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
6Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol07Woo00<007ooOol0
77oo00<007ooOol02goo00<007ooOol03Goo0009Ool3000=Ool00`00Oomoo`0KOol3000KOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0JOol2000JOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0LOol3000LOol3000=Ool00`00Oomoo`0=Ool000]oo`03001oogoo00]oo`D001]o
o`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo01ao
o`03001oogoo00]oo`D000]oo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo07]oo`80009oo`8000Moo`00Pgoo00<007ooOol0O7oo00@007ooOol000Qoo`00Pgoo00<0
07ooOol0OGoo0P002Goo0023Ool00`00Oomoo`1mOol20009Ool000moonX000Uoo`04001oogoo0008
Ool000moo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00
Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool0
0`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol40005Ool20005
Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0R7oo001YOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool30028Ool006Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`00
JGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo001YOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool006Yoo`@000aoo`D000Ao
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo
08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001jOol50004Ool00`00Oomoo`28Ool0
07aoo`03001oogoo00Aoo`03001oogoo08Qoo`00O7oo00<007ooOol017oo00<007ooOol0R7oo001l
Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol007aoo`03001oogoo00Aoo`03001oogoo04Yo
o`0301moogoo03]oo`00O7oo00<007ooOol017oo00<007ooOol0BGoo00<07gooOol0?7oo001jOol3
0006Ool00`00Oomoo`18Ool00`0OOomoo`0mOol007aoo`03001oogoo00Aoo`03001oogoo04Moo`03
01moogoo03ioo`00Pgoo00<007ooOol0AGoo0P0O@Goo0023Ool00`00Oomoo`14Ool00`0OOomoo`11
Ool008=oo`03001oogoo049oo`807dAoo`00Pgoo0P00@Woo00<07gooOol0A7oo0023Ool00`00Oomo
o`10Ool00`0OOomoo`15Ool008=oo`03001oogoo03moo`0301moogoo04Ioo`00Pgoo00<007ooOol0
?Woo00<07gooOol0Agoo0023Ool00`00Oomoo`0lOol201m:Ool008=oo`03001oogoo03]oo`0301mo
ogoo04Yoo`00Pgoo00<007ooOol0>Goo0P0OCGoo0023Ool2000hOol201m?Ool008=oo`03001oogoo
03Ioo`0301moogoo04moo`00Pgoo00<007ooOol0=7oo0P0ODWoo0023Ool00`00Oomoo`0bOol201mD
Ool008=oo`03001oogoo035oo`0301moogoo05Aoo`00Pgoo00<007ooOol0;Woo0`0OEgoo0023Ool0
0`00Oomoo`0/Ool201mJOol008=oo`03001oogoo02Yoo`807eaoo`00Pgoo0P00:Goo0P0OGWoo0023
Ool00`00Oomoo`0VOol201mPOol008=oo`03001oogoo02Aoo`807f9oo`00Pgoo00<007ooOol08Goo
0`0OI7oo0023Ool00`00Oomoo`0KOol601mWOol008=oo`03001oogoo01Uoo`807feoo`00Pgoo00<0
07ooOol05Woo0`0OKgoo0023Ool00`00Oomoo`0@Ool601mbOol008=oo`8000moo`807gQoo`00Pgoo
00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007oo
Ool00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03
001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00
Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo
00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020
Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool0
0?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.82035 .84583 L
.80565 .85888 L
.79137 .87058 L
.77721 .88128 L
.76171 .89209 L
.74639 .90189 L
.7297 .91166 L
.71326 .92041 L
.69713 .92821 L
.67965 .93583 L
.66255 .94249 L
.64587 .94827 L
.62789 .95373 L
.61039 .9583 L
.59161 .96242 L
.57337 .96566 L
.55572 .9681 L
.54583 .96917 L
.53685 .96996 L
.52748 .9706 L
.51863 .97104 L
.51408 .97119 L
.51159 .97126 L
.50927 .97131 L
.50729 .97135 L
.50516 .97138 L
.50395 .97139 L
.50335 .97139 L
.5028 .9714 L
.50231 .9714 L
.50177 .9714 L
.50123 .9714 L
.50065 .9714 L
.50008 .9714 L
.49956 .9714 L
.49898 .9714 L
.49865 .9714 L
.49836 .9714 L
.49776 .9714 L
.49712 .9714 L
.49594 .97139 L
.49485 .97138 L
.4937 .97136 L
.49163 .97133 L
.48923 .97128 L
.487 .97123 L
.4819 .97106 L
.47705 .97085 L
.47245 .9706 L
Mistroke
.46382 .97001 L
.44606 .96831 L
.42725 .96576 L
.42626 .9656 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00LGoo1P001Goo00<007ooOol0
17oo0`00R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00NWoo0`001Woo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo
00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00JWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo001Y
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qo
o`00HGoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00R7oo001YOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo001ZOol4000<Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0009Ool50004Ool20005Ool4000JOol5000JOol40005Ool20005Ool4
000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool0
00]oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03
001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<0
07ooOol03goo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol06Woo00<0
07ooOol077oo00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`0?Ool00`00Oomo
o`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomo
o`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001oogoo00]oo`@001aoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol0
2goo00<007ooOol07Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
6Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol07Woo00<007ooOol0
77oo00<007ooOol02goo00<007ooOol03Goo0009Ool3000=Ool00`00Oomoo`0KOol3000KOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0JOol2000JOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0LOol3000LOol3000=Ool00`00Oomoo`0=Ool000]oo`03001oogoo00]oo`D001]o
o`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo01ao
o`03001oogoo00]oo`D000]oo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo07]oo`80009oo`8000Moo`00Pgoo00<007ooOol0O7oo00@007ooOol000Qoo`00Pgoo00<0
07ooOol0OGoo0P002Goo0023Ool00`00Oomoo`1mOol20009Ool000moonX000Uoo`04001oogoo0008
Ool000moo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00
Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool0
0`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol40005Ool20005
Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0R7oo001YOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool30028Ool006Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`00
JGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo001YOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool006Yoo`@000aoo`D000Ao
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo
08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001jOol50004Ool00`00Oomoo`28Ool0
07aoo`03001oogoo00Aoo`03001oogoo08Qoo`00O7oo00<007ooOol017oo00<007ooOol0R7oo001l
Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol007aoo`03001oogoo00Aoo`03001oogoo04Yo
o`0301moogoo03]oo`00O7oo00<007ooOol017oo00<007ooOol0BGoo00<07gooOol0?7oo001jOol3
0006Ool00`00Oomoo`18Ool00`0OOomoo`0mOol007aoo`03001oogoo00Aoo`03001oogoo04Moo`03
01moogoo03ioo`00Pgoo00<007ooOol0AGoo0P0O@Goo0023Ool00`00Oomoo`14Ool00`0OOomoo`11
Ool008=oo`03001oogoo049oo`807dAoo`00Pgoo0P00@Woo00<07gooOol0A7oo0023Ool00`00Oomo
o`10Ool00`0OOomoo`15Ool008=oo`03001oogoo03moo`0301moogoo04Ioo`00Pgoo00<007ooOol0
?Woo00<07gooOol0Agoo0023Ool00`00Oomoo`0lOol201m:Ool008=oo`03001oogoo03Yoo`807dao
o`00Pgoo00<007ooOol0>Goo00<07gooOol0C7oo0023Ool2000iOol00`0OOomoo`1=Ool008=oo`03
001oogoo03Moo`0301moogoo04ioo`00Pgoo00<007ooOol0=Goo0P0ODGoo0023Ool00`00Oomoo`0c
Ool201mCOol008=oo`03001oogoo035oo`807eEoo`00Pgoo00<007ooOol0;goo0P0OEgoo0023Ool0
0`00Oomoo`0]Ool201mIOol008=oo`03001oogoo02]oo`807e]oo`00Pgoo0P00:Woo0P0OGGoo0023
Ool00`00Oomoo`0VOol301mOOol008=oo`03001oogoo02=oo`<07f9oo`00Pgoo00<007ooOol08Goo
0P0OIGoo0023Ool00`00Oomoo`0NOol301mWOol008=oo`03001oogoo01Yoo`@07fYoo`00Pgoo00<0
07ooOol05Goo1@0OKWoo0023Ool00`00Oomoo`0AOol401mcOol0079oo`L07`Yoo`8000Uoo`T07gMo
o`00NGoo5@0OP7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007oo
Ool00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03
001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00
Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo
00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020
Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool0
0?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.81591 .84989 L
.79598 .8669 L
.77643 .88185 L
.75692 .89524 L
.73544 .9084 L
.71412 .91997 L
.69085 .93105 L
.66788 .9405 L
.64535 .94844 L
.62097 .95562 L
.59716 .96128 L
.57402 .96556 L
.56107 .96743 L
.54918 .96883 L
.53687 .96996 L
.52514 .97073 L
.51918 .97101 L
.51591 .97114 L
.51283 .97123 L
.50995 .9713 L
.50844 .97133 L
.50683 .97135 L
.50548 .97137 L
.50477 .97138 L
.504 .97139 L
.5033 .97139 L
.50265 .9714 L
.50201 .9714 L
.5014 .9714 L
.50069 .9714 L
.49992 .9714 L
.4992 .9714 L
.49854 .9714 L
.49781 .9714 L
.49701 .9714 L
.49617 .97139 L
.49539 .97138 L
.49378 .97136 L
.49231 .97134 L
.48901 .97128 L
.48619 .9712 L
.48312 .9711 L
.47756 .97087 L
.47168 .97055 L
.46522 .97012 L
.45219 .96897 L
.44017 .96759 L
.4273 .96577 L
.40206 .96112 L
Mistroke
.37801 .95535 L
.3552 .94861 L
.33133 .94019 L
.3088 .93089 L
.28599 .92002 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00LGoo1P001Goo00<007ooOol0
17oo0`00R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00NWoo0`001Woo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo
00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00JWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo001Y
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qo
o`00HGoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00R7oo001YOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo001ZOol4000<Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0009Ool50004Ool20005Ool4000JOol5000JOol40005Ool20005Ool4
000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool0
00]oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03
001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<0
07ooOol03goo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol06Woo00<0
07ooOol077oo00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`0?Ool00`00Oomo
o`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomo
o`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001oogoo00]oo`@001aoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol0
2goo00<007ooOol07Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
6Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol07Woo00<007ooOol0
77oo00<007ooOol02goo00<007ooOol03Goo0009Ool3000=Ool00`00Oomoo`0KOol3000KOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0JOol2000JOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0LOol3000LOol3000=Ool00`00Oomoo`0=Ool000]oo`03001oogoo00]oo`D001]o
o`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo01ao
o`03001oogoo00]oo`D000]oo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo07]oo`80009oo`8000Moo`00Pgoo00<007ooOol0O7oo00@007ooOol000Qoo`00Pgoo00<0
07ooOol0OGoo0P002Goo0023Ool00`00Oomoo`1mOol20009Ool000moonX000Uoo`04001oogoo0008
Ool000moo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00
Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool0
0`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol40005Ool20005
Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0R7oo001YOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool30028Ool006Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`00
JGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo001YOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool006Yoo`@000aoo`D000Ao
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo
08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001jOol50004Ool00`00Oomoo`28Ool0
07aoo`03001oogoo00Aoo`03001oogoo08Qoo`00O7oo00<007ooOol017oo00<007ooOol0R7oo001l
Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol007aoo`03001oogoo00Aoo`03001oogoo04Yo
o`0301moogoo03]oo`00O7oo00<007ooOol017oo00<007ooOol0BGoo00<07gooOol0?7oo001jOol3
0006Ool00`00Oomoo`18Ool00`0OOomoo`0mOol007aoo`03001oogoo00Aoo`03001oogoo04Moo`03
01moogoo03ioo`00Pgoo00<007ooOol0AWoo00<07gooOol0?goo0023Ool00`00Oomoo`14Ool201m2
Ool008=oo`03001oogoo04=oo`0301moogoo049oo`00Pgoo0P00@goo00<07gooOol0@goo0023Ool0
0`00Oomoo`11Ool00`0OOomoo`14Ool008=oo`03001oogoo03moo`807dMoo`00Pgoo00<007ooOol0
?Woo00<07gooOol0Agoo0023Ool00`00Oomoo`0lOol201m:Ool008=oo`03001oogoo03Yoo`807dao
o`00Pgoo00<007ooOol0>Goo00<07gooOol0C7oo0023Ool2000hOol201m?Ool008=oo`03001oogoo
03Eoo`807e5oo`00Pgoo00<007ooOol0=7oo00<07gooOol0DGoo0023Ool00`00Oomoo`0bOol201mD
Ool008=oo`03001oogoo031oo`807eIoo`00DGoo0P0O<7oo00<007ooOol0;goo00<07gooOol0EWoo
001COol301l]Ool00`00Oomoo`0]Ool201mIOol005Ioo`807b]oo`03001oogoo02]oo`807e]oo`00
F7oo0P0O:Goo0P00:Woo0P0OGGoo001JOol201lWOol00`00Oomoo`0VOol301mOOol005aoo`807bEo
o`03001oogoo02=oo`<07f9oo`00GWoo0P0O8goo00<007ooOol08Goo0P0OIGoo001POol401lOOol0
0`00Oomoo`0MOol401mWOol006Aoo`D07aYoo`03001oogoo01Qoo`D07f]oo`00JGoo0P0O67oo00<0
07ooOol05Woo0P0OL7oo001[Ool401lDOol00`00Oomoo`0BOol401mbOol006moo`/07`Uoo`8000Uo
o`X07gIoo`00NWoo500OP7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Ao
o`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo
00<007ooOol00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool0
06aoo`03001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=
Ool00`00Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qo
o`00P7oo00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000
RGoo0020Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003o
Ool?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.81143 .85388 L
.78611 .87465 L
.76106 .89252 L
.73593 .90812 L
.70815 .92296 L
.68054 .93546 L
.65037 .94678 L
.62064 .95571 L
.59155 .96243 L
.57667 .96513 L
.5602 .96755 L
.5445 .9693 L
.53745 .96991 L
.52975 .97047 L
.52557 .97071 L
.52169 .97091 L
.51767 .97107 L
.51402 .9712 L
.51043 .97129 L
.50879 .97132 L
.50705 .97135 L
.50519 .97138 L
.50437 .97138 L
.50348 .97139 L
.50253 .9714 L
.50164 .9714 L
.5011 .9714 L
.50058 .9714 L
.49962 .9714 L
.49873 .9714 L
.49778 .9714 L
.49688 .97139 L
.49605 .97139 L
.49413 .97137 L
.49211 .97134 L
.49014 .9713 L
.48831 .97126 L
.48414 .97114 L
.47723 .97085 L
.46984 .97044 L
.4619 .96986 L
.4533 .96909 L
.43774 .96727 L
.42245 .96498 L
.40637 .96201 L
.3777 .95526 L
.3477 .94612 L
.31946 .93546 L
.29026 .92217 L
Mistroke
.26304 .90752 L
.23783 .89177 L
.21214 .87331 L
.18863 .85394 L
.16667 .83333 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00LGoo1P001Goo00<007ooOol0
17oo0`00R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00NWoo0`001Woo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo
00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00JWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo001Y
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qo
o`00HGoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00R7oo001YOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo001ZOol4000<Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0009Ool50004Ool20005Ool4000JOol5000JOol40005Ool20005Ool4
000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool0
00]oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03
001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<0
07ooOol03goo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol06Woo00<0
07ooOol077oo00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`0?Ool00`00Oomo
o`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomo
o`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001oogoo00]oo`@001aoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol0
2goo00<007ooOol07Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
6Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol07Woo00<007ooOol0
77oo00<007ooOol02goo00<007ooOol03Goo0009Ool3000=Ool00`00Oomoo`0KOol3000KOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0JOol2000JOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0LOol3000LOol3000=Ool00`00Oomoo`0=Ool000]oo`03001oogoo00]oo`D001]o
o`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo01ao
o`03001oogoo00]oo`D000]oo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo07]oo`80009oo`8000Moo`00Pgoo00<007ooOol0O7oo00@007ooOol000Qoo`00Pgoo00<0
07ooOol0OGoo0P002Goo0023Ool00`00Oomoo`1mOol20009Ool000moonX000Uoo`04001oogoo0008
Ool000moo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00
Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool0
0`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol40005Ool20005
Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0R7oo001YOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool30028Ool006Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`00
JGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo001YOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool006Yoo`@000aoo`D000Ao
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo
08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001jOol50004Ool00`00Oomoo`28Ool0
07aoo`03001oogoo00Aoo`03001oogoo08Qoo`00O7oo00<007ooOol017oo00<007ooOol0R7oo000e
Ool00`0OOomoo`14Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Ioo`0301moogoo04=o
o`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo03]oo`00=goo00<07gooOol0@Woo00<007oo
Ool017oo00<007ooOol0BGoo00<07gooOol0?7oo000hOol00`0OOomoo`0oOol30006Ool00`00Oomo
o`18Ool00`0OOomoo`0mOol003Uoo`0301moogoo041oo`03001oogoo00Aoo`03001oogoo04Moo`03
01moogoo03ioo`00>Woo00<07gooOol0AWoo00<007ooOol0AWoo00<07gooOol0?goo000kOol201m6
Ool00`00Oomoo`14Ool201m2Ool003eoo`0301moogoo04=oo`03001oogoo04=oo`0301moogoo049o
o`00?Woo0P0O@goo0P00@Woo0P0OAGoo0010Ool00`0OOomoo`10Ool00`00Oomoo`10Ool00`0OOomo
o`15Ool0045oo`807d1oo`03001oogoo03moo`0301moogoo04Ioo`00@goo00<07gooOol0?Goo00<0
07ooOol0?Woo00<07gooOol0Agoo0014Ool201lmOol00`00Oomoo`0lOol201m:Ool004Ioo`0301mo
ogoo03Yoo`03001oogoo03]oo`0301moogoo04Yoo`00Agoo0P0O>Woo00<007ooOol0>Woo00<07goo
Ool0Bgoo0019Ool00`0OOomoo`0gOol2000iOol201m>Ool004Yoo`807cMoo`03001oogoo03Ioo`80
7e1oo`00C7oo00<07gooOol0=7oo00<007ooOol0=7oo0P0ODWoo001=Ool201ldOol00`00Oomoo`0b
Ool201mDOol004moo`807c9oo`03001oogoo035oo`0301moogoo05Aoo`00DGoo0P0O<7oo00<007oo
Ool0;goo0P0OEgoo001COol201l^Ool00`00Oomoo`0]Ool201mIOol005Eoo`807baoo`03001oogoo
02]oo`807e]oo`00Egoo0P0O:Woo0P00:Woo0P0OGGoo001IOol201lXOol00`00Oomoo`0VOol301mO
Ool005]oo`@07bAoo`03001oogoo029oo`@07f9oo`00Ggoo0`0O8Goo00<007ooOol07goo0`0OIWoo
001ROol401lMOol00`00Oomoo`0KOol401mYOol006Ioo`<07aYoo`03001oogoo01Qoo`<07feoo`00
JGoo0`0O5goo00<007ooOol057oo100OL7oo001/Ool701l@Ool00`00Oomoo`0>Ool601mdOol007=o
o`H07`Yoo`8000Qoo`L07gYoo`00NGoo500OPGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo
08Qoo`00Pgoo00<007ooOol0R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006ao
o`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo
00<007ooOol03goo00<007ooOol00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomo
o`02Ool30028Ool006aoo`03001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0
TGoo001ZOol3000=Ool00`00Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003o
Ool?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`80
0003Ool0000008Qoo`00P7oo00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool0
1@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003o
Ool?Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.8069 .85782 L
.77602 .88214 L
.74528 .90257 L
.71429 .91988 L
.67997 .9357 L
.64585 .94828 L
.6281 .95366 L
.60862 .95872 L
.5913 .96248 L
.57207 .96586 L
.55373 .96833 L
.54365 .96938 L
.5342 .97016 L
.52958 .97048 L
.52453 .97077 L
.52008 .97098 L
.51533 .97116 L
.51291 .97123 L
.51063 .97128 L
.50841 .97133 L
.50637 .97136 L
.50443 .97138 L
.50345 .97139 L
.50238 .9714 L
.5013 .9714 L
.50014 .9714 L
.49905 .9714 L
.49805 .9714 L
.49695 .97139 L
.49592 .97139 L
.49479 .97138 L
.49357 .97136 L
.49108 .97132 L
.4888 .97127 L
.48464 .97115 L
.48025 .97099 L
.47101 .97051 L
.46092 .96978 L
.44272 .96791 L
.42337 .96514 L
.4038 .96148 L
.38547 .95728 L
.35102 .94725 L
.31533 .93373 L
.2821 .91802 L
.2514 .90052 L
.22024 .87942 L
.19194 .85682 L
.16385 .8305 L
Mistroke
.13891 .80305 L
.11703 .77487 L
.09615 .74317 L
.07998 .71401 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00LGoo1P001Goo00<007ooOol0
17oo0`00R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00NWoo0`001Woo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo
00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00JWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo001Y
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qo
o`00HGoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00R7oo001YOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo001ZOol4000<Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0009Ool50004Ool20005Ool4000JOol5000JOol40005Ool20005Ool4
000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool0
00]oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03
001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<0
07ooOol03goo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol06Woo00<0
07ooOol077oo00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`0?Ool00`00Oomo
o`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomo
o`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001oogoo00]oo`@001aoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol0
2goo00<007ooOol07Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
6Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol07Woo00<007ooOol0
77oo00<007ooOol02goo00<007ooOol03Goo0009Ool3000=Ool00`00Oomoo`0KOol3000KOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0JOol2000JOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0LOol3000LOol3000=Ool00`00Oomoo`0=Ool000]oo`03001oogoo00]oo`D001]o
o`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo01ao
o`03001oogoo00]oo`D000]oo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo07]oo`80009oo`8000Moo`00Pgoo00<007ooOol0O7oo00@007ooOol000Qoo`00Pgoo00<0
07ooOol0OGoo0P002Goo0023Ool00`00Oomoo`1mOol20009Ool000moonX000Uoo`04001oogoo0008
Ool000moo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00
Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool0
0`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol40005Ool20005
Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0R7oo001YOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool30028Ool006Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`00
JGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo001YOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool006Yoo`@000aoo`D000Ao
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo
08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`008Goo00<07goo
Ool0Ggoo00<007ooOol0R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool0029oo`0301moogoo
05ioo`03001oogoo08Qoo`008goo00<07gooOol0GGoo00<007ooOol0R7oo000SOol00`0OOomoo`1M
Ool20029Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`0097oo00<07gooOol0G7oo00<007oo
Ool0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo
08Qoo`009Woo00<07gooOol0FWoo00<007ooOol0R7oo000WOol00`0OOomoo`1IOol00`00Oomoo`28
Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qoo`00:Goo00<07gooOol0Egoo0P00RGoo000YOol0
0`0OOomoo`1GOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qoo`00:goo00<0
7gooOol0EGoo00<007ooOol0R7oo000[Ool00`0OOomoo`1EOol00`00Oomoo`28Ool002aoo`0301mo
ogoo05Aoo`03001oogoo08Qoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo000^Ool00`0OOomo
o`1BOol00`00Oomoo`28Ool002ioo`0301moogoo059oo`8008Uoo`00;goo00<07gooOol0DGoo00<0
07ooOol0R7oo000`Ool00`0OOomoo`1@Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03001o
ogoo08Qoo`00<Woo00<07gooOol0CWoo00<007ooOol0R7oo000cOol00`0OOomoo`14Ool50004Ool0
0`00Oomoo`28Ool003Aoo`0301moogoo04Eoo`03001oogoo00Aoo`03001oogoo08Qoo`00=Goo00<0
7gooOol0A7oo00<007ooOol017oo00<007ooOol0R7oo000fOol00`0OOomoo`13Ool00`00Oomoo`04
Ool3001;Ool00`0OOomoo`0jOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001oogoo04Yo
o`0301moogoo03]oo`00>7oo00<07gooOol0@Goo00<007ooOol017oo00<007ooOol0BGoo00<07goo
Ool0?7oo000iOol00`0OOomoo`0nOol30006Ool00`00Oomoo`17Ool201loOol003Yoo`0301moogoo
03moo`03001oogoo00Aoo`03001oogoo04Ioo`0301moogoo03moo`00>goo00<07gooOol0AGoo00<0
07ooOol0AGoo00<07gooOol0@7oo000lOol201m5Ool00`00Oomoo`14Ool00`0OOomoo`11Ool003io
o`0301moogoo049oo`03001oogoo049oo`807dAoo`00?goo00<07gooOol0@Goo0P00@Woo00<07goo
Ool0A7oo0010Ool201m1Ool00`00Oomoo`10Ool00`0OOomoo`15Ool0049oo`0301moogoo03ioo`03
001oogoo03ioo`807dQoo`00@goo0P0O?Woo00<007ooOol0?Goo00<07gooOol0B7oo0015Ool00`0O
Oomoo`0kOol00`00Oomoo`0kOol201m;Ool004Ioo`0301moogoo03Yoo`03001oogoo03Yoo`0301mo
ogoo04]oo`00Agoo0P0O>Woo00<007ooOol0>Goo00<07gooOol0C7oo0019Ool00`0OOomoo`0gOol2
000hOol201m?Ool004Yoo`807cMoo`03001oogoo03Ioo`0301moogoo04moo`00C7oo0P0O=Goo00<0
07ooOol0=7oo0P0ODWoo001>Ool201lcOol00`00Oomoo`0bOol201mDOol0051oo`0301moogoo031o
o`03001oogoo031oo`807eIoo`00DGoo0P0O<7oo00<007ooOol0;goo00<07gooOol0EWoo001COol2
01l^Ool00`00Oomoo`0]Ool201mIOol005Eoo`807baoo`03001oogoo02]oo`807e]oo`00Egoo0`0O
:Goo0P00:Woo0P0OGGoo001JOol201lWOol00`00Oomoo`0VOol301mOOol005aoo`<07bAoo`03001o
ogoo02Aoo`807f9oo`00Ggoo0`0O8Goo00<007ooOol08Goo0`0OI7oo001ROol201lOOol00`00Oomo
o`0NOol301mWOol006Aoo`<07aaoo`03001oogoo01Uoo`D07fYoo`00Igoo100O67oo00<007ooOol0
5Goo100OKgoo001[Ool901l?Ool00`00Oomoo`0AOol401mcOol007Aoo`@07`]oo`8000Qoo`X07gMo
o`00N7oo5@0OPGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007oo
Ool00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03
001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00
Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo
00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020
Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool0
0?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.80231 .86171 L
.76574 .88936 L
.72911 .91199 L
.69207 .9305 L
.65102 .94656 L
.61025 .95833 L
.58758 .9632 L
.56595 .96677 L
.55549 .96813 L
.54436 .96931 L
.53485 .97011 L
.52435 .97078 L
.5187 .97103 L
.51591 .97114 L
.51332 .97122 L
.51079 .97128 L
.5085 .97133 L
.50595 .97137 L
.50455 .97138 L
.50323 .97139 L
.50191 .9714 L
.50116 .9714 L
.50046 .9714 L
.49906 .9714 L
.49826 .9714 L
.49754 .9714 L
.49626 .97139 L
.49486 .97138 L
.49354 .97136 L
.49231 .97134 L
.48959 .97129 L
.48659 .97121 L
.48051 .971 L
.47516 .97075 L
.46954 .97042 L
.45949 .96966 L
.4487 .96861 L
.43693 .96717 L
.41585 .96383 L
.39352 .95922 L
.35007 .94693 L
.30951 .9312 L
.27201 .9126 L
.2341 .88925 L
.19983 .86348 L
.16922 .83587 L
.13941 .80365 L
.11368 .77014 L
.08972 .73215 L
Mistroke
.07017 .69356 L
.05477 .6549 L
.04768 .63276 L
.0422 .61243 L
.0344 .57374 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00LGoo1P001Goo00<007ooOol0
17oo0`00R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00NWoo0`001Woo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo
00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00JWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo001Y
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qo
o`00HGoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00R7oo001YOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo001ZOol4000<Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0009Ool50004Ool20005Ool4000JOol5000JOol40005Ool20005Ool4
000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool0
00]oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03
001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<0
07ooOol03goo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol06Woo00<0
07ooOol077oo00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`0?Ool00`00Oomo
o`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomo
o`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001oogoo00]oo`@001aoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol0
2goo00<007ooOol07Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
6Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol07Woo00<007ooOol0
77oo00<007ooOol02goo00<007ooOol03Goo0009Ool3000=Ool00`00Oomoo`0KOol3000KOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0JOol2000JOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0LOol3000LOol3000=Ool00`00Oomoo`0=Ool000]oo`03001oogoo00]oo`D001]o
o`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo01ao
o`03001oogoo00]oo`D000]oo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo07]oo`80009oo`8000Moo`00Pgoo00<007ooOol0O7oo00@007ooOol000Qoo`00Pgoo00<0
07ooOol0OGoo0P002Goo0023Ool00`00Oomoo`1mOol20009Ool000moonX000Uoo`04001oogoo0008
Ool000moo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`005goo00<07gooOol0JGoo00<007ooOol0
R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qo
o`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool0
01Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo0P00RGoo000HOol00`0O
Oomoo`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<07goo
Ool0J7oo00<007ooOol0R7oo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Uoo`0301moogoo
06Moo`03001oogoo08Qoo`006Goo00<07gooOol0Igoo00<007ooOol0R7oo000JOol00`0OOomoo`1V
Ool00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`006Woo00<07gooOol0IWoo00<007oo
Ool0R7oo000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001]oo`0301moogoo06Eoo`03001oogoo
08Qoo`006goo00<07gooOol0IGoo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool40005Ool20005
Ool40005Ool00`00Oomoo`28Ool001]oo`0301moogoo04]oo`03001oogoo009oo`03001oogoo009o
o`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`0077oo00<07gooOol0BWoo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0R7oo000LOol00`0OOomo
o`1:Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool30028Ool001eoo`0301moogoo
04Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`007Goo00<07gooOol0
BGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo000NOol00`0O
Oomoo`18Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool001io
o`0301moogoo04Uoo`@000aoo`D000Aoo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007oo
Ool0R7oo000OOol00`0OOomoo`1QOol00`00Oomoo`28Ool001moo`0301moogoo065oo`03001oogoo
08Qoo`0087oo00<07gooOol0H7oo0P00RGoo000POol00`0OOomoo`1POol00`00Oomoo`28Ool0025o
o`0301moogoo05moo`03001oogoo08Qoo`008Goo00<07gooOol0Ggoo00<007ooOol0R7oo000ROol0
0`0OOomoo`1NOol00`00Oomoo`28Ool0029oo`0301moogoo05ioo`03001oogoo08Qoo`008goo00<0
7gooOol0GGoo00<007ooOol0R7oo000SOol00`0OOomoo`1MOol20029Ool002Aoo`0301moogoo05ao
o`03001oogoo08Qoo`0097oo00<07gooOol0G7oo00<007ooOol0R7oo000UOol00`0OOomoo`1KOol0
0`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009Woo00<07gooOol0FWoo00<0
07ooOol0R7oo000WOol00`0OOomoo`1IOol00`00Oomoo`28Ool002Qoo`0301moogoo05Qoo`03001o
ogoo08Qoo`00:7oo00<07gooOol0F7oo0P00RGoo000YOol00`0OOomoo`1GOol00`00Oomoo`28Ool0
02Yoo`0301moogoo05Ioo`03001oogoo08Qoo`00:goo00<07gooOol0EGoo00<007ooOol0R7oo000[
Ool00`0OOomoo`1EOol00`00Oomoo`28Ool002aoo`0301moogoo05Aoo`03001oogoo08Qoo`00;Goo
00<07gooOol0Dgoo00<007ooOol0R7oo000^Ool00`0OOomoo`1BOol00`00Oomoo`28Ool002ioo`03
01moogoo059oo`8008Uoo`00;goo00<07gooOol0DGoo00<007ooOol0R7oo000`Ool00`0OOomoo`1@
Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03001oogoo08Qoo`00<Woo00<07gooOol0CWoo
00<007ooOol0R7oo000cOol00`0OOomoo`14Ool50004Ool00`00Oomoo`28Ool003Aoo`0301moogoo
04Eoo`03001oogoo00Aoo`03001oogoo08Qoo`00=Goo00<07gooOol0A7oo00<007ooOol017oo00<0
07ooOol0R7oo000fOol00`0OOomoo`13Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Mo
o`0301moogoo049oo`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo03]oo`00>7oo00<07goo
Ool0@Goo00<007ooOol017oo00<007ooOol0BGoo00<07gooOol0?7oo000iOol00`0OOomoo`0nOol3
0006Ool00`00Oomoo`17Ool201loOol003Yoo`0301moogoo03moo`03001oogoo00Aoo`03001oogoo
04Ioo`0301moogoo03moo`00>goo00<07gooOol0AGoo00<007ooOol0AGoo00<07gooOol0@7oo000l
Ool00`0OOomoo`14Ool00`00Oomoo`14Ool00`0OOomoo`11Ool003eoo`0301moogoo04=oo`03001o
ogoo04=oo`0301moogoo049oo`00?Woo00<07gooOol0@Woo0P00@Woo0P0OAGoo000oOol201m2Ool0
0`00Oomoo`10Ool00`0OOomoo`15Ool0045oo`0301moogoo03moo`03001oogoo03moo`0301moogoo
04Ioo`00@Woo00<07gooOol0?Woo00<007ooOol0?Goo0P0OBGoo0013Ool201lnOol00`00Oomoo`0l
Ool00`0OOomoo`19Ool004Eoo`0301moogoo03]oo`03001oogoo03]oo`0301moogoo04Yoo`00AWoo
0P0O>goo00<007ooOol0>Goo0P0OCGoo0018Ool201liOol2000iOol00`0OOomoo`1=Ool004Yoo`80
7cMoo`03001oogoo03Ioo`807e1oo`00C7oo0P0O=Goo00<007ooOol0=7oo0P0ODWoo001>Ool00`0O
Oomoo`0bOol00`00Oomoo`0bOol201mDOol004moo`807c9oo`03001oogoo031oo`807eIoo`00DGoo
0P0O<7oo00<007ooOol0;Woo0P0OF7oo001COol201l^Ool00`00Oomoo`0/Ool201mJOol005Eoo`80
7baoo`03001oogoo02Uoo`<07eaoo`00Egoo0P0O:Woo0P00:7oo0P0OGgoo001IOol301lWOol00`00
Oomoo`0TOol301mQOol005aoo`<07bAoo`03001oogoo029oo`807fAoo`00Ggoo0`0O8Goo00<007oo
Ool07goo0`0OIWoo001ROol301lNOol00`00Oomoo`0LOol301mYOol006Eoo`@07aYoo`03001oogoo
01Uoo`<07faoo`00JGoo100O5Woo00<007ooOol05Goo100OKgoo001]Ool501lAOol00`00Oomoo`0@
Ool501mcOol0079oo`L07`Yoo`8000Qoo`T07gQoo`00NGoo500OPGoo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol50004Ool20005Ool40005Ool00`00
Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo08Qoo`00K7oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0R7oo001/Ool00`00Oomo
o`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03001oogoo00]oo`@0091oo`00K7oo00<007ooOol0
2goo00<007ooOol0TGoo001ZOol3000=Ool00`00Oomoo`2AOol006aoo`03001oogoo00]oo`D008mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003o
Ool?Ool0085oo`800003Ool0000008Qoo`00P7oo00<007ooOol00P00RGoo0020Ool01@00Oomoogoo
0000RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo001oOol20002Ool2
0029Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.79768 .86553 L
.75528 .8963 L
.71258 .92075 L
.66932 .93995 L
.64444 .94873 L
.62141 .9555 L
.59688 .96134 L
.57398 .96556 L
.55038 .96871 L
.53788 .96988 L
.53095 .97039 L
.52461 .97076 L
.51861 .97104 L
.51291 .97123 L
.50979 .9713 L
.50689 .97135 L
.50522 .97138 L
.50371 .97139 L
.50287 .9714 L
.50196 .9714 L
.50032 .9714 L
.49889 .9714 L
.49757 .9714 L
.49611 .97139 L
.49455 .97137 L
.49291 .97135 L
.49137 .97133 L
.48846 .97126 L
.48324 .97111 L
.47756 .97087 L
.47154 .97054 L
.46589 .97017 L
.45303 .96906 L
.44053 .96764 L
.42711 .96574 L
.40259 .96123 L
.37708 .9551 L
.33201 .94046 L
.28591 .91999 L
.24385 .89574 L
.20213 .86537 L
.16531 .83197 L
.13339 .79635 L
.10359 .75511 L
.07925 .71259 L
.06013 .66953 L
.05139 .64481 L
.04461 .62183 L
.03878 .59746 L
Mistroke
.03454 .57462 L
.03138 .55117 L
.03019 .53873 L
.02967 .53182 L
.02928 .52546 L
.02899 .51922 L
.02887 .51605 L
.02877 .51264 L
.02872 .51085 L
.02869 .50922 L
.02866 .50756 L
.02863 .50603 L
.02861 .50425 L
.02861 .50331 L
.0286 .50231 L
.0286 .50144 L
.0286 .50063 L
.0286 .49974 L
.0286 .49879 L
.0286 .4972 L
.02861 .49573 L
.02863 .49412 L
.02866 .4924 L
.02873 .48888 L
.02881 .48568 L
.02904 .47951 L
.02933 .47369 L
.03016 .46164 L
.03137 .44893 L
.0344 .42626 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00LGoo1P001Goo00<007ooOol0
17oo0`00R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00NWoo0`001Woo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo
00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomo
o`28Ool008=oo`03001oogoo08Qoo`00JWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo001Y
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool006Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qo
o`00HGoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00R7oo001YOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`28Ool006Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo08Qoo`00JGoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo001ZOol4000<Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28
Ool001Moo`0301moogoo06Uoo`8008Uoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo0009Ool5
0004Ool20002Ool00`0OOomoo`04000JOol5000JOol40005Ool20005Ool4000IOol00`00Oomoo`0J
Ool40005Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool000]oo`03001oogoo00Ao
o`80009oo`0301moo`0000Aoo`03001oogoo01Uoo`03001oogoo01Uoo`03001oogoo009oo`03001o
ogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo01Uoo`03001oogoo009o
o`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03001oogoo01aoo`03001o
ogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<007ooOol027oo00<07goo
Ool017oo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool05Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol06Woo00<007oo
Ool077oo00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`08Ool00`0OOomoo`04
Ool00`00Oomoo`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=
Ool00`00Oomoo`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0J
Ool00`00Oomoo`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001oogoo00Qoo`0301mo
ogoo00@001aoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@0
00aoo`002goo00<007ooOol027oo00@07gooOol001moo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo01Yoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo01ioo`03001oogoo01aoo`03001oogoo00]oo`03001oogoo00eoo`002Goo0`002Woo00@0
7gooOol001eoo`<001]oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03
001oogoo009oo`03001oogoo00Uoo`03001oogoo01aoo`<001aoo`<000eoo`03001oogoo00eoo`00
2goo00<007ooOol01goo00@07gooOomoo`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001o
ogoo01Yoo`@000aoo`D001aoo`03001oogoo01aoo`03001oogoo00]oo`D000]oo`005Goo00<07goo
Ool0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo
06]oo`03001oogoo07]oo`80009oo`8000Moo`005Goo00<07gooOol0Jgoo00<007ooOol0O7oo00@0
07ooOol000Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0OGoo0P002Goo000EOol00`0OOomoo`1[
Ool00`00Oomoo`1mOol20009Ool000moo`H0000301l000000>4000Uoo`04001oogoo0008Ool000mo
o`03001oogoo00=oo`0301l007oo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Ioo`80009oo`8000Moo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol0
0`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<0
7gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301mo
ogoo06]oo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo0P00RGoo000FOol00`0OOomoo`1ZOol0
0`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<0
07ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001o
ogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomo
o`28Ool001Moo`0301moogoo06Uoo`8008Uoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000G
Ool00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`0067oo
00<07gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qoo`03
01moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo0P00RGoo000HOol00`0OOomoo`1X
Ool00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`006Goo00<07gooOol0Igoo
00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uoo`0301moogoo06Moo`03
001oogoo08Qoo`006Goo00<07gooOol0Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00
Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo
000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`03001oogoo08Qoo`00
6goo00<07gooOol0IGoo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool40005Ool20005Ool40005
Ool00`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`0077oo00<07gooOol0BWoo00<007oo
Ool00Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool30028Ool001eoo`0301moogoo04Uoo`03
001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`007Goo00<07gooOol0BGoo00<0
07ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo000NOol00`0OOomoo`18
Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool001ioo`0301mo
ogoo04Uoo`@000aoo`D000Aoo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo
000OOol00`0OOomoo`1QOol00`00Oomoo`28Ool001moo`0301moogoo065oo`03001oogoo08Qoo`00
87oo00<07gooOol0H7oo0P00RGoo000POol00`0OOomoo`1POol00`00Oomoo`28Ool0025oo`0301mo
ogoo05moo`03001oogoo08Qoo`008Goo00<07gooOol0Ggoo00<007ooOol0R7oo000ROol00`0OOomo
o`1NOol00`00Oomoo`28Ool0029oo`0301moogoo05ioo`03001oogoo08Qoo`008goo00<07gooOol0
GGoo00<007ooOol0R7oo000SOol00`0OOomoo`1MOol20029Ool002Aoo`0301moogoo05aoo`03001o
ogoo08Qoo`009Goo00<07gooOol0Fgoo00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomo
o`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009Woo00<07gooOol0FWoo00<007ooOol0
R7oo000WOol00`0OOomoo`1IOol00`00Oomoo`28Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qo
o`00:Goo00<07gooOol0Egoo0P00RGoo000YOol00`0OOomoo`1GOol00`00Oomoo`28Ool002Yoo`03
01moogoo05Ioo`03001oogoo08Qoo`00:goo00<07gooOol0EGoo00<007ooOol0R7oo000/Ool00`0O
Oomoo`1DOol00`00Oomoo`28Ool002aoo`0301moogoo05Aoo`03001oogoo08Qoo`00;Goo00<07goo
Ool0Dgoo00<007ooOol0R7oo000^Ool00`0OOomoo`1BOol00`00Oomoo`28Ool002moo`0301moogoo
055oo`8008Uoo`00<7oo00<07gooOol0D7oo00<007ooOol0R7oo000aOol00`0OOomoo`1?Ool00`00
Oomoo`28Ool0039oo`0301moogoo04ioo`03001oogoo08Qoo`00<Woo00<07gooOol0CWoo00<007oo
Ool0R7oo000cOol00`0OOomoo`14Ool50004Ool00`00Oomoo`28Ool003Aoo`0301moogoo04Eoo`03
001oogoo00Aoo`03001oogoo08Qoo`00=Goo00<07gooOol0A7oo00<007ooOol017oo00<007ooOol0
R7oo000fOol00`0OOomoo`13Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Moo`0301mo
ogoo049oo`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo03]oo`00>7oo00<07gooOol0@Goo
00<007ooOol017oo00<007ooOol0B7oo0P0O?Woo000iOol201loOol30006Ool00`00Oomoo`17Ool0
0`0OOomoo`0nOol003]oo`0301moogoo03ioo`03001oogoo00Aoo`03001oogoo04Ioo`0301moogoo
03moo`00?7oo00<07gooOol0A7oo00<007ooOol0A7oo0P0O@Woo000mOol00`0OOomoo`13Ool00`00
Oomoo`13Ool00`0OOomoo`12Ool003ioo`0301moogoo049oo`03001oogoo049oo`0301moogoo04=o
o`00?goo00<07gooOol0@Goo0P00@Woo00<07gooOol0A7oo0010Ool201m1Ool00`00Oomoo`0oOol2
01m7Ool0049oo`0301moogoo03ioo`03001oogoo03ioo`0301moogoo04Moo`00@goo00<07gooOol0
?Goo00<007ooOol0?Goo00<07gooOol0B7oo0014Ool201lmOol00`00Oomoo`0kOol201m;Ool004Io
o`0301moogoo03Yoo`03001oogoo03Yoo`0301moogoo04]oo`00Agoo00<07gooOol0>Goo00<007oo
Ool0>Goo00<07gooOol0C7oo0018Ool201liOol2000hOol201m?Ool004Yoo`807cMoo`03001oogoo
03Eoo`807e5oo`00C7oo00<07gooOol0=7oo00<007ooOol0=7oo00<07gooOol0DGoo001=Ool201ld
Ool00`00Oomoo`0bOol201mDOol004moo`807c9oo`03001oogoo031oo`807eIoo`00DGoo0P0O<7oo
00<007ooOol0;goo00<07gooOol0EWoo001COol201l^Ool00`00Oomoo`0]Ool201mIOol005Eoo`80
7baoo`03001oogoo02]oo`807e]oo`00Egoo0P0O:Woo0P00:Woo0P0OGGoo001IOol201lXOol00`00
Oomoo`0WOol201mOOol005]oo`<07bEoo`03001oogoo02Aoo`<07f5oo`00GWoo0`0O8Woo00<007oo
Ool08Goo0`0OI7oo001QOol401lNOol00`00Oomoo`0MOol401mWOol006Eoo`<07a]oo`03001oogoo
01Qoo`D07f]oo`00J7oo0`0O67oo00<007ooOol05Woo0P0OL7oo001[Ool401lDOol00`00Oomoo`0B
Ool401mbOol006moo`/07`Uoo`8000Uoo`X07gIoo`00NWoo500OP7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol50004Ool20005Ool40005Ool00`00
Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo08Qoo`00K7oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0R7oo001/Ool00`00Oomo
o`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03001oogoo00]oo`@0091oo`00K7oo00<007ooOol0
2goo00<007ooOol0TGoo001ZOol3000=Ool00`00Oomoo`2AOol006aoo`03001oogoo00]oo`D008mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003o
Ool?Ool0085oo`800003Ool0000008Qoo`00P7oo00<007ooOol00P00RGoo0020Ool01@00Oomoogoo
0000RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo001oOol20002Ool2
0029Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.79299 .86929 L
.74463 .90296 L
.69571 .92886 L
.64611 .94819 L
.61984 .95592 L
.59129 .96248 L
.57722 .96504 L
.56187 .96733 L
.54732 .96902 L
.53384 .97019 L
.52733 .97061 L
.52033 .97097 L
.51694 .9711 L
.51371 .97121 L
.51082 .97128 L
.50766 .97134 L
.5057 .97137 L
.50386 .97139 L
.5022 .9714 L
.50041 .9714 L
.49948 .9714 L
.49846 .9714 L
.49739 .9714 L
.49639 .97139 L
.4946 .97137 L
.49269 .97135 L
.4909 .97132 L
.48896 .97128 L
.48542 .97118 L
.4788 .97093 L
.47202 .97057 L
.46567 .97015 L
.45121 .96887 L
.43716 .9672 L
.42208 .96492 L
.39457 .95946 L
.36602 .95196 L
.31585 .93395 L
.26505 .90868 L
.21936 .87877 L
.17494 .84141 L
.1368 .80051 L
.10492 .75717 L
.07667 .7074 L
.06492 .68145 L
.05536 .65657 L
.04707 .63067 L
.04059 .60567 L
.03774 .59239 L
Mistroke
.03506 .57783 L
.03305 .56462 L
.03149 .55214 L
.03077 .54522 L
.03011 .53773 L
.02965 .53149 L
.02924 .52465 L
.02891 .51721 L
.02878 .51314 L
.02873 .5112 L
.02869 .50935 L
.02866 .50765 L
.02863 .5058 L
.02861 .50412 L
.0286 .50256 L
.0286 .50088 L
.0286 .49903 L
.0286 .4981 L
.0286 .4971 L
.02862 .49529 L
.02864 .49352 L
.02866 .49192 L
.02874 .48833 L
.02883 .485 L
.02894 .48186 L
.02927 .47483 L
.02974 .46721 L
.03106 .45189 L
.03271 .43782 L
.03691 .41185 L
.04318 .38364 L
.05067 .35742 L
.06038 .32982 L
.07998 .28599 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00LGoo1P001Goo00<007ooOol0
17oo0`00R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00NWoo0`001Woo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uo
o`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03
001oogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo
00<007ooOol0R7oo000QOol00`0OOomoo`1OOol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03
001oogoo08Qoo`0087oo00<07gooOol0H7oo00<007ooOol0R7oo000POol00`0OOomoo`1POol20029
Ool001moo`0301moogoo065oo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo
000OOol00`0OOomoo`1QOol00`00Oomoo`28Ool001ioo`0301moogoo069oo`03001oogoo08Qoo`00
7Woo00<07gooOol0BGoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo000MOol00`0OOomoo`19
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009o
o`03001oogoo08Qoo`007Goo00<07gooOol0@Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo0`00R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool4
0005Ool00`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Ioo`03001oogoo08Qoo`006goo00<07gooOol0Bgoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool4000<Ool50004Ool00`00
Oomoo`28Ool001Yoo`0301moogoo06Ioo`03001oogoo08Qoo`006Woo00<07gooOol0IWoo00<007oo
Ool0R7oo000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`00
6Goo00<07gooOol0Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uo
o`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<07gooOol0Igoo00<007ooOol0R7oo000IOol0
0`0OOomoo`1WOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<0
7gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomoo`1XOol20029Ool001Moo`0301moogoo06Uo
o`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol0
0`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<0
07ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`8008Uo
o`005Woo00<07gooOol0JWoo00<007ooOol0R7oo0009Ool50004Ool20002Ool00`0OOomoo`04000J
Ool5000JOol40005Ool20005Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000J
Ool50004Ool20005Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001o
ogoo01Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009o
o`03001oogoo01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001o
ogoo009oo`03001oogoo01Yoo`03001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009o
o`03001oogoo00Uoo`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007oo
Ool06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007oo
Ool00Woo00<007ooOol03Goo00<007ooOol06Woo00<007ooOol077oo00<007ooOol03goo00<007oo
Ool02Goo00060005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00
Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0I
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`00Oomoo`0?
Ool00`00Oomoo`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo
00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol01goo00D0
7gooOomoo`0001moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yo
o`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01ao
o`03001oogoo00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03
001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo
00Uoo`03001oogoo01aoo`<001aoo`<000eoo`03001oogoo00eoo`002goo00<007ooOol01goo00@0
7gooOomoo`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001ao
o`03001oogoo01aoo`03001oogoo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo
000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo07]oo`80
009oo`8000Moo`005Goo00<07gooOol0Jgoo00<007ooOol0O7oo00@007ooOol000Qoo`005Goo00<0
7gooOol0Jgoo00<007ooOol0OGoo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1mOol20009
Ool000moo`H0000301l000000>4000Uoo`04001oogoo0008Ool000moo`03001oogoo00=oo`0301l0
07oo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`80009o
o`8000Moo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomo
o`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0
R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qo
o`005Woo00<07gooOol0JWoo0P00RGoo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`03
01moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0O
Oomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07goo
Ool0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo
06Yoo`8008Uoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00
Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007oo
Ool0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo
08Qoo`005goo00<07gooOol0JGoo0P00RGoo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qo
o`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000HOol0
0`0OOomoo`1XOol00`00Oomoo`28Ool001Uoo`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<0
7gooOol0Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uoo`0301mo
ogoo06Moo`8008Uoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000JOol00`0OOomoo`1VOol0
0`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`03001oogoo08Qoo`006Woo00<07gooOol0IWoo00<0
07ooOol0R7oo000KOol00`0OOomoo`1<Ool40005Ool20005Ool40005Ool00`00Oomoo`28Ool001]o
o`0301moogoo04]oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo08Qoo`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool30028Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo
00Uoo`@000Eoo`03001oogoo08Qoo`007Goo00<07gooOol0BGoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo000NOol00`0OOomoo`18Ool00`00Oomoo`02Ool00`00
Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool001ioo`0301moogoo04Uoo`@000aoo`D000Ao
o`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000OOol00`0OOomoo`1QOol0
0`00Oomoo`28Ool001moo`0301moogoo065oo`03001oogoo08Qoo`0087oo00<07gooOol0H7oo0P00
RGoo000POol00`0OOomoo`1POol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qo
o`008Goo00<07gooOol0Ggoo00<007ooOol0R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool0
029oo`0301moogoo05ioo`03001oogoo08Qoo`008goo00<07gooOol0GGoo00<007ooOol0R7oo000T
Ool00`0OOomoo`1LOol20029Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`009Goo00<07goo
Ool0Fgoo00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Ioo`0301moogoo
05Yoo`03001oogoo08Qoo`009Woo00<07gooOol0FWoo00<007ooOol0R7oo000WOol00`0OOomoo`1I
Ool00`00Oomoo`28Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qoo`00:7oo00<07gooOol0F7oo
0P00RGoo000YOol00`0OOomoo`1GOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo
08Qoo`00:goo00<07gooOol0EGoo00<007ooOol0R7oo000[Ool00`0OOomoo`1EOol00`00Oomoo`28
Ool002aoo`0301moogoo05Aoo`03001oogoo08Qoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo
000]Ool00`0OOomoo`1COol00`00Oomoo`28Ool002ioo`0301moogoo059oo`8008Uoo`00;goo00<0
7gooOol0DGoo00<007ooOol0R7oo000`Ool00`0OOomoo`1@Ool00`00Oomoo`28Ool0035oo`0301mo
ogoo04moo`03001oogoo08Qoo`00<Woo00<07gooOol0CWoo00<007ooOol0R7oo000cOol00`0OOomo
o`14Ool50004Ool00`00Oomoo`28Ool003=oo`0301moogoo04Ioo`03001oogoo00Aoo`03001oogoo
08Qoo`00=7oo00<07gooOol0AGoo00<007ooOol017oo00<007ooOol0R7oo000eOol00`0OOomoo`14
Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Ioo`0301moogoo04=oo`03001oogoo00Ao
o`03001oogoo04Yoo`0301moogoo03]oo`00=goo00<07gooOol0@Woo00<007ooOol017oo00<007oo
Ool0B7oo0P0O?Woo000hOol201m0Ool30006Ool00`00Oomoo`17Ool00`0OOomoo`0nOol003Yoo`03
01moogoo03moo`03001oogoo00Aoo`03001oogoo04Ioo`0301moogoo03moo`00>goo00<07gooOol0
AGoo00<007ooOol0AGoo00<07gooOol0@7oo000lOol201m5Ool00`00Oomoo`13Ool201m3Ool003io
o`0301moogoo049oo`03001oogoo049oo`0301moogoo04=oo`00?goo00<07gooOol0@Goo0P00@Woo
00<07gooOol0A7oo0010Ool201m1Ool00`00Oomoo`0oOol201m7Ool0049oo`0301moogoo03ioo`03
001oogoo03ioo`0301moogoo04Moo`00@goo0P0O?Woo00<007ooOol0?Goo00<07gooOol0B7oo0015
Ool00`0OOomoo`0kOol00`00Oomoo`0kOol201m;Ool004Ioo`0301moogoo03Yoo`03001oogoo03Yo
o`0301moogoo04]oo`00Agoo0P0O>Woo00<007ooOol0>Goo00<07gooOol0C7oo0019Ool00`0OOomo
o`0gOol2000hOol201m?Ool004Yoo`807cMoo`03001oogoo03Ioo`0301moogoo04moo`00C7oo00<0
7gooOol0=7oo00<007ooOol0=7oo0P0ODWoo001=Ool201ldOol00`00Oomoo`0bOol201mDOol004mo
o`807c9oo`03001oogoo031oo`807eIoo`00DGoo0P0O<7oo00<007ooOol0;Woo0P0OF7oo001COol2
01l^Ool00`00Oomoo`0/Ool201mJOol005Eoo`807baoo`03001oogoo02Yoo`807eaoo`00Egoo0`0O
:Goo0P00:Goo0P0OGWoo001JOol301lVOol00`00Oomoo`0VOol201mPOol005eoo`<07b=oo`03001o
ogoo02=oo`<07f9oo`00H7oo0`0O87oo00<007ooOol08Goo0P0OIGoo001SOol301lMOol00`00Oomo
o`0MOol401mWOol006Ioo`@07aUoo`03001oogoo01Qoo`D07f]oo`00JWoo100O5Goo00<007ooOol0
57oo100OL7oo001^Ool501l@Ool00`00Oomoo`0>Ool601mdOol007=oo`L07`Uoo`8000Qoo`L07gYo
o`00NWoo4`0OPGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007oo
Ool00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03
001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00
Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo
00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020
Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool0
0?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.78826 .873 L
.73381 .90934 L
.70563 .92419 L
.67854 .93629 L
.65003 .94689 L
.62251 .95521 L
.59159 .96242 L
.5631 .96716 L
.54813 .96894 L
.53992 .96971 L
.53221 .9703 L
.52565 .97071 L
.51859 .97104 L
.51456 .97118 L
.51074 .97128 L
.50908 .97132 L
.50731 .97135 L
.50536 .97137 L
.50356 .97139 L
.50163 .9714 L
.50053 .9714 L
.49951 .9714 L
.49843 .9714 L
.49744 .9714 L
.49631 .97139 L
.49523 .97138 L
.49332 .97136 L
.49156 .97133 L
.48757 .97124 L
.48358 .97112 L
.47918 .97094 L
.47029 .97047 L
.46252 .96991 L
.45416 .96917 L
.43907 .96745 L
.42435 .96529 L
.40832 .9624 L
.37639 .95491 L
.34724 .94597 L
.31681 .93435 L
.25925 .90529 L
.20804 .87011 L
.16355 .83019 L
.12218 .78191 L
.08883 .73057 L
.0633 .67751 L
.05281 .64915 L
.0436 .618 L
.03992 .60269 L
Mistroke
.03648 .58586 L
.03377 .56969 L
.03181 .55496 L
.03099 .54742 L
.03023 .53925 L
.0297 .53218 L
.02923 .52442 L
.02904 .52043 L
.02887 .51616 L
.0288 .51379 L
.02874 .51164 L
.02869 .50945 L
.02865 .50743 L
.02863 .50556 L
.02861 .50358 L
.0286 .50159 L
.0286 .50046 L
.0286 .4994 L
.0286 .49749 L
.02861 .49574 L
.02864 .49382 L
.02867 .4918 L
.02875 .48779 L
.02887 .484 L
.02916 .47693 L
.0296 .46932 L
.0302 .46109 L
.03167 .44628 L
.03343 .43269 L
.03849 .4039 L
.04611 .37271 L
.05522 .34382 L
.06704 .31354 L
.0964 .25643 L
.13177 .20567 L
.16667 .16667 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001o
ogoo08Qoo`00Pgoo0P00RGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28
Ool008=oo`03001oogoo08Qoo`00NWoo1@0017oo00<007ooOol0R7oo001lOol00`00Oomoo`04Ool0
0`00Oomoo`28Ool007aoo`03001oogoo00Aoo`03001oogoo08Qoo`00=Goo00<07gooOol0>Goo1P00
1Goo00<007ooOol017oo0`00R7oo000dOol00`0OOomoo`15Ool00`00Oomoo`04Ool00`00Oomoo`28
Ool003=oo`0301moogoo04Ioo`03001oogoo00Aoo`03001oogoo08Qoo`00<Woo00<07gooOol0AGoo
0`001Woo00<007ooOol0R7oo000aOol00`0OOomoo`18Ool00`00Oomoo`04Ool00`00Oomoo`28Ool0
035oo`0301moogoo04moo`03001oogoo08Qoo`00<7oo00<07gooOol0D7oo00<007ooOol0R7oo000_
Ool00`0OOomoo`1AOol00`00Oomoo`28Ool002ioo`0301moogoo059oo`8008Uoo`00;Goo00<07goo
Ool0Dgoo00<007ooOol0R7oo000/Ool00`0OOomoo`1DOol00`00Oomoo`28Ool002aoo`0301moogoo
05Aoo`03001oogoo08Qoo`00:goo00<07gooOol0EGoo00<007ooOol0R7oo000ZOol00`0OOomoo`1F
Ool00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qoo`00:Goo00<07gooOol0Egoo
00<007ooOol0R7oo000XOol00`0OOomoo`1HOol20029Ool002Qoo`0301moogoo05Qoo`03001oogoo
08Qoo`009goo00<07gooOol0FGoo00<007ooOol0R7oo000VOol00`0OOomoo`1JOol00`00Oomoo`28
Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009Goo00<07gooOol0Fgoo00<007ooOol0R7oo
000TOol00`0OOomoo`1LOol00`00Oomoo`28Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`00
8goo00<07gooOol0GGoo0P00RGoo000SOol00`0OOomoo`1MOol00`00Oomoo`28Ool0029oo`0301mo
ogoo05ioo`03001oogoo08Qoo`008Woo00<07gooOol0GWoo00<007ooOol0R7oo000QOol00`0OOomo
o`1OOol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`0087oo00<07gooOol0
H7oo00<007ooOol0R7oo000POol00`0OOomoo`1POol20029Ool001moo`0301moogoo065oo`03001o
ogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000NOol00`0OOomoo`1ROol00`00Oomo
o`28Ool001ioo`0301moogoo069oo`03001oogoo08Qoo`007Woo00<07gooOol0BGoo10001Goo0P00
1Goo10001Goo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`28Ool001eoo`0301moogoo04Uo
o`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qoo`0077oo00<07goo
Ool0@Woo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00R7oo000LOol0
0`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`28Ool001]oo`03
01moogoo04]oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo08Qoo`00
6goo00<07gooOol0Bgoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0
R7oo000KOol00`0OOomoo`1<Ool4000<Ool50004Ool00`00Oomoo`28Ool001Yoo`0301moogoo06Io
o`03001oogoo08Qoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000JOol00`0OOomoo`1VOol0
0`00Oomoo`28Ool001Uoo`0301moogoo06Moo`8008Uoo`006Goo00<07gooOol0Igoo00<007ooOol0
R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qo
o`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool0
01Qoo`0301moogoo06Qoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000G
Ool00`0OOomoo`1YOol20029Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07goo
Ool0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Ioo`0301moogoo
06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1Z
Ool00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`8008Uoo`005Woo00<07gooOol0JWoo00<007oo
Ool0R7oo0009Ool50004Ool20002Ool00`0OOomoo`04000JOol5000JOol40005Ool20005Ool4000I
Ool00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool000]o
o`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001oogoo01Uoo`03001oogoo01Uoo`03001o
ogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo01Uo
o`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03001o
ogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<007oo
Ool027oo00<07gooOol017oo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007oo
Ool03Goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool06Woo00<007ooOol077oo00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`08
Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02
Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=
Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001o
ogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@0
01Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001eoo`03001oogoo01aoo`03
001oogoo00]oo`@000aoo`002goo00<007ooOol027oo00@07gooOol001moo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`03001oogoo00]oo`03001oogoo00eoo`00
2Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001oogoo009oo`03001oogoo00Uoo`03001o
ogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01aoo`<001aoo`<000eo
o`03001oogoo00eoo`002goo00<007ooOol01goo00@07gooOomoo`D001]oo`03001oogoo01Yoo`@0
00aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo01aoo`03001oogoo00]oo`D0
00]oo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28
Ool001Eoo`0301moogoo06]oo`03001oogoo07]oo`80009oo`8000Moo`005Goo00<07gooOol0Jgoo
00<007ooOol0O7oo00@007ooOol000Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0OGoo0P002Goo
000EOol00`0OOomoo`1[Ool00`00Oomoo`1mOol20009Ool000moo`H0000301l000000>4000Uoo`04
001oogoo0008Ool000moo`03001oogoo00=oo`0301l007oo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`005Goo00<07gooOol0Jgoo00<0
07ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001o
ogoo08Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomo
o`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<07gooOol0Jgoo0P00RGoo000F
Ool00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo
00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`03
01moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0O
Oomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`8008Uoo`005Woo00<07gooOol0JWoo
00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03
001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00
Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo0P00RGoo
000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`00
6Goo00<07gooOol0Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uo
o`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<07gooOol0Igoo00<007ooOol0R7oo000JOol0
0`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`006Woo00<07gooOol0
IWoo00<007ooOol0R7oo000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001]oo`0301moogoo06Eo
o`03001oogoo08Qoo`006goo00<07gooOol0IGoo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool4
0005Ool20005Ool40005Ool00`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03
001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`0077oo00<0
7gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0R7oo000L
Ool00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool30028Ool001eo
o`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`007Goo
00<07gooOol0BGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo
000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomo
o`28Ool001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03001oogoo08Qoo`007Woo00<07gooOol0
HWoo00<007ooOol0R7oo000OOol00`0OOomoo`1QOol00`00Oomoo`28Ool001moo`0301moogoo065o
o`03001oogoo08Qoo`0087oo00<07gooOol0H7oo0P00RGoo000POol00`0OOomoo`1POol00`00Oomo
o`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`008Goo00<07gooOol0Ggoo00<007ooOol0
R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool0029oo`0301moogoo05ioo`03001oogoo08Qo
o`008goo00<07gooOol0GGoo00<007ooOol0R7oo000SOol00`0OOomoo`1MOol20029Ool002Aoo`03
01moogoo05aoo`03001oogoo08Qoo`0097oo00<07gooOol0G7oo00<007ooOol0R7oo000UOol00`0O
Oomoo`1KOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009Woo00<07goo
Ool0FWoo00<007ooOol0R7oo000WOol00`0OOomoo`1IOol00`00Oomoo`28Ool002Qoo`0301moogoo
05Qoo`03001oogoo08Qoo`00:7oo00<07gooOol0F7oo0P00RGoo000YOol00`0OOomoo`1GOol00`00
Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qoo`00:Woo00<07gooOol0EWoo00<007oo
Ool0R7oo000[Ool00`0OOomoo`1EOol00`00Oomoo`28Ool002aoo`0301moogoo05Aoo`03001oogoo
08Qoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo000^Ool00`0OOomoo`1BOol00`00Oomoo`28
Ool002moo`0301moogoo055oo`8008Uoo`00<7oo00<07gooOol0D7oo00<007ooOol0R7oo000`Ool0
0`0OOomoo`1@Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03001oogoo08Qoo`00<Woo00<0
7gooOol0CWoo00<007ooOol0R7oo000cOol00`0OOomoo`14Ool50004Ool00`00Oomoo`28Ool003Ao
o`0301moogoo04Eoo`03001oogoo00Aoo`03001oogoo08Qoo`00=Goo00<07gooOol0A7oo00<007oo
Ool017oo00<007ooOol0R7oo000fOol00`0OOomoo`13Ool00`00Oomoo`04Ool3001;Ool00`0OOomo
o`0jOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo03]oo`00
>7oo00<07gooOol0@Goo00<007ooOol017oo00<007ooOol0B7oo0P0O?Woo000iOol00`0OOomoo`0n
Ool30006Ool00`00Oomoo`17Ool00`0OOomoo`0nOol003Yoo`807d1oo`03001oogoo00Aoo`03001o
ogoo04Ioo`0301moogoo03moo`00?7oo00<07gooOol0A7oo00<007ooOol0AGoo00<07gooOol0@7oo
000mOol00`0OOomoo`13Ool00`00Oomoo`14Ool00`0OOomoo`11Ool003ioo`0301moogoo049oo`03
001oogoo049oo`807dAoo`00?goo00<07gooOol0@Goo0P00@Woo00<07gooOol0A7oo0010Ool00`0O
Oomoo`10Ool00`00Oomoo`10Ool00`0OOomoo`15Ool0045oo`807d1oo`03001oogoo03ioo`807dQo
o`00@goo00<07gooOol0?Goo00<007ooOol0?Goo00<07gooOol0B7oo0014Ool00`0OOomoo`0lOol0
0`00Oomoo`0kOol201m;Ool004Eoo`807caoo`03001oogoo03Yoo`0301moogoo04]oo`00Agoo00<0
7gooOol0>Goo00<007ooOol0>7oo0P0OCWoo0018Ool00`0OOomoo`0hOol2000hOol00`0OOomoo`1>
Ool004Uoo`807cQoo`03001oogoo03Eoo`807e5oo`00Bgoo0P0O=Woo00<007ooOol0=7oo00<07goo
Ool0DGoo001=Ool201ldOol00`00Oomoo`0bOol201mDOol004moo`807c9oo`03001oogoo031oo`80
7eIoo`00DGoo0P0O<7oo00<007ooOol0;Woo0P0OF7oo001COol201l^Ool00`00Oomoo`0]Ool00`0O
Oomoo`1HOol005Eoo`807baoo`03001oogoo02]oo`807e]oo`00Egoo0`0O:Goo0P00:Woo0P0OGGoo
001JOol201lWOol00`00Oomoo`0VOol301mOOol005aoo`807bEoo`03001oogoo029oo`@07f9oo`00
GWoo0`0O8Woo00<007ooOol07goo0`0OIWoo001QOol401lNOol00`00Oomoo`0LOol301mYOol006Eo
o`<07a]oo`03001oogoo01Uoo`<07faoo`00J7oo100O5goo00<007ooOol05Goo100OKgoo001/Ool4
01lCOol00`00Oomoo`0@Ool501mcOol0071oo`T07`Yoo`8000Uoo`P07gQoo`00NGoo5@0OP7oo0023
Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol50004Ool2
0005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03
001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0
R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03001oogoo00]oo`@0091o
o`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00Oomoo`2AOol006aoo`03
001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?mo
o`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo00<007ooOol00P00RGoo
0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000
RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo
003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.78349 .87664 L
.75527 .8963 L
.72282 .91542 L
.66108 .94303 L
.62924 .95334 L
.59446 .96184 L
.57728 .96503 L
.55851 .96776 L
.54987 .96876 L
.5407 .96964 L
.53209 .97031 L
.5242 .97078 L
.52026 .97097 L
.51595 .97113 L
.51189 .97125 L
.51007 .9713 L
.50811 .97133 L
.50693 .97135 L
.50585 .97137 L
.50372 .97139 L
.50178 .9714 L
.49973 .9714 L
.49753 .9714 L
.49547 .97138 L
.49321 .97136 L
.4908 .97131 L
.48677 .97122 L
.48239 .97108 L
.47443 .97071 L
.4667 .97023 L
.45954 .96967 L
.44316 .96797 L
.42785 .96585 L
.39326 .95916 L
.35995 .95012 L
.33007 .93971 L
.26882 .91082 L
.2144 .87504 L
.16249 .8291 L
.1194 .77814 L
.10031 .74994 L
.08198 .7179 L
.05487 .65518 L
.04485 .6227 L
.04064 .60587 L
.03681 .58763 L
.03388 .57038 L
.03176 .55454 L
.03093 .54689 L
Mistroke
.03017 .53854 L
.02963 .53123 L
.02917 .52332 L
.02896 .51858 L
.02881 .51421 L
.0287 .51004 L
.02866 .50794 L
.02864 .50676 L
.02863 .50564 L
.02861 .50354 L
.0286 .50163 L
.0286 .49958 L
.0286 .49735 L
.02862 .4954 L
.02864 .49333 L
.02867 .49156 L
.02871 .48962 L
.02884 .48496 L
.02899 .4807 L
.02948 .47111 L
.03008 .46266 L
.03087 .45379 L
.03275 .43753 L
.03539 .42027 L
.04173 .38948 L
.05168 .35429 L
.06353 .32191 L
.0926 .26284 L
.13222 .20511 L
.17806 .15565 L
.22836 .11473 L
.28599 .07998 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`8008Uoo`00
Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007oo
Ool0R7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023
Ool20029Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001AOol00`0OOomoo`0_Ool0
0`00Oomoo`28Ool004moo`807c9oo`03001oogoo08Qoo`00CGoo0P0O=7oo00<007ooOol0R7oo001<
Ool00`0OOomoo`0dOol00`00Oomoo`28Ool004Yoo`807cMoo`03001oogoo08Qoo`00BGoo00<07goo
Ool0=goo0P00RGoo0017Ool201ljOol00`00Oomoo`28Ool004Eoo`807caoo`03001oogoo08Qoo`00
A7oo00<07gooOol0?7oo00<007ooOol0R7oo0013Ool00`0OOomoo`0mOol00`00Oomoo`28Ool0049o
o`0301moogoo03ioo`03001oogoo08Qoo`00@7oo0P0O@Goo00<007ooOol0R7oo000oOol00`0OOomo
o`11Ool00`00Oomoo`28Ool003ioo`0301moogoo049oo`8008Uoo`00?Goo00<07gooOol0@goo00<0
07ooOol0R7oo000lOol00`0OOomoo`14Ool00`00Oomoo`28Ool003Yoo`807dMoo`03001oogoo08Qo
o`00>Goo00<07gooOol0?Woo1@0017oo00<007ooOol0R7oo000hOol00`0OOomoo`11Ool00`00Oomo
o`04Ool00`00Oomoo`28Ool003Moo`0301moogoo049oo`03001oogoo00Aoo`03001oogoo08Qoo`00
=Woo00<07gooOol0>7oo1P001Goo00<007ooOol017oo0`00R7oo000eOol00`0OOomoo`14Ool00`00
Oomoo`04Ool00`00Oomoo`28Ool003Aoo`0301moogoo04Eoo`03001oogoo00Aoo`03001oogoo08Qo
o`00<goo00<07gooOol0A7oo0`001Woo00<007ooOol0R7oo000bOol00`0OOomoo`17Ool00`00Oomo
o`04Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03001oogoo08Qoo`00<7oo00<07gooOol0
D7oo00<007ooOol0R7oo000_Ool00`0OOomoo`1AOol00`00Oomoo`28Ool002ioo`0301moogoo059o
o`8008Uoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo000/Ool00`0OOomoo`1DOol00`00Oomo
o`28Ool002aoo`0301moogoo05Aoo`03001oogoo08Qoo`00:goo00<07gooOol0EGoo00<007ooOol0
R7oo000ZOol00`0OOomoo`1FOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qo
o`00:Goo00<07gooOol0Egoo00<007ooOol0R7oo000XOol00`0OOomoo`1HOol20029Ool002Qoo`03
01moogoo05Qoo`03001oogoo08Qoo`009goo00<07gooOol0FGoo00<007ooOol0R7oo000WOol00`0O
Oomoo`1IOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009Goo00<07goo
Ool0Fgoo00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Aoo`0301moogoo
05aoo`03001oogoo08Qoo`008goo00<07gooOol0GGoo0P00RGoo000SOol00`0OOomoo`1MOol00`00
Oomoo`28Ool0029oo`0301moogoo05ioo`03001oogoo08Qoo`008Woo00<07gooOol0GWoo00<007oo
Ool0R7oo000QOol00`0OOomoo`1OOol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo
08Qoo`0087oo00<07gooOol0H7oo00<007ooOol0R7oo000POol00`0OOomoo`1POol20029Ool001mo
o`0301moogoo065oo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000NOol0
0`0OOomoo`1ROol00`00Oomoo`28Ool001ioo`0301moogoo069oo`03001oogoo08Qoo`007Goo00<0
7gooOol0BWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`28
Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001o
ogoo08Qoo`0077oo00<07gooOol0@Woo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo0`00R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00Ioo`03001oogoo08Qoo`006goo00<07gooOol0Bgoo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol01Woo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool4000<Ool50004Ool00`00Oomoo`28
Ool001]oo`0301moogoo06Eoo`03001oogoo08Qoo`006goo00<07gooOol0IGoo00<007ooOol0R7oo
000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`006Goo00<0
7gooOol0Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uoo`0301mo
ogoo06Moo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomo
o`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0
J7oo00<007ooOol0R7oo000HOol00`0OOomoo`1XOol20029Ool001Moo`0301moogoo06Uoo`03001o
ogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomo
o`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0
R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`8008Uoo`005Woo
00<07gooOol0JWoo00<007ooOol0R7oo0009Ool50004Ool20002Ool00`0OOomoo`04000JOol5000J
Ool40005Ool20005Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004
Ool20005Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001oogoo01Uo
o`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001o
ogoo01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009o
o`03001oogoo01Yoo`03001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001o
ogoo00Uoo`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007ooOol06Goo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo
00<007ooOol03Goo00<007ooOol06Woo00<007ooOol077oo00<007ooOol03goo00<007ooOol02Goo
00060005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00Oomoo`0A
Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0IOol00`00
Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`00Oomoo`0?Ool00`00
Oomoo`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03001oogoo
009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@0
01eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol027oo00@07gooOol0
01moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`03001oogoo
00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001oogoo009o
o`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uoo`03001o
ogoo01aoo`<001aoo`<000eoo`03001oogoo00eoo`002goo00<007ooOol01goo00@07gooOomoo`D0
01]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo
01aoo`03001oogoo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0O
Oomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo07]oo`80009oo`8000Mo
o`005Goo00<07gooOol0Jgoo00<007ooOol0O7oo00@007ooOol000Qoo`005Goo00<07gooOol0Jgoo
00<007ooOol0OGoo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1mOol20009Ool000moo`H0
000301l000000>4000Uoo`04001oogoo0008Ool000moo`03001oogoo00=oo`0301l007oo00Ioo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`00
5Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eo
o`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol0
0`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Woo00<0
7gooOol0JWoo0P00RGoo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yo
o`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol0
0`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<0
07ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`8008Uo
o`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool0
01Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000G
Ool00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`0067oo
00<07gooOol0J7oo0P00RGoo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo
06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000IOol00`0OOomoo`1W
Ool00`00Oomoo`28Ool001Uoo`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<07gooOol0Igoo
00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`80
08Uoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000JOol00`0OOomoo`1VOol00`00Oomoo`28
Ool001Yoo`0301moogoo06Ioo`03001oogoo08Qoo`006goo00<07gooOol0IGoo00<007ooOol0R7oo
000KOol00`0OOomoo`1<Ool40005Ool20005Ool40005Ool00`00Oomoo`28Ool001]oo`0301moogoo
04]oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03
001oogoo08Qoo`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol0
0Woo00<007ooOol0R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00
Oomoo`02Ool30028Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eo
o`03001oogoo08Qoo`007Goo00<07gooOol0BGoo00<007ooOol00Woo00<007ooOol02Goo00<007oo
Ool01Woo00<007ooOol0R7oo000NOol00`0OOomoo`18Ool00`00Oomoo`02Ool00`00Oomoo`09Ool0
0`00Oomoo`06Ool00`00Oomoo`28Ool001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03001oogoo
08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000OOol00`0OOomoo`1QOol00`00Oomoo`28
Ool0021oo`0301moogoo061oo`03001oogoo08Qoo`0087oo00<07gooOol0H7oo0P00RGoo000QOol0
0`0OOomoo`1OOol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`008Woo00<0
7gooOol0GWoo00<007ooOol0R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool002=oo`0301mo
ogoo05eoo`03001oogoo08Qoo`008goo00<07gooOol0GGoo00<007ooOol0R7oo000TOol00`0OOomo
o`1LOol20029Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`009Goo00<07gooOol0Fgoo00<0
07ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001o
ogoo08Qoo`009goo00<07gooOol0FGoo00<007ooOol0R7oo000WOol00`0OOomoo`1IOol00`00Oomo
o`28Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qoo`00:7oo00<07gooOol0F7oo0P00RGoo000Y
Ool00`0OOomoo`1GOol00`00Oomoo`28Ool002Uoo`0301moogoo05Moo`03001oogoo08Qoo`00:Woo
00<07gooOol0EWoo00<007ooOol0R7oo000[Ool00`0OOomoo`1EOol00`00Oomoo`28Ool002aoo`03
01moogoo05Aoo`03001oogoo08Qoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo000]Ool00`0O
Oomoo`1COol00`00Oomoo`28Ool002ioo`0301moogoo059oo`8008Uoo`00;goo00<07gooOol0DGoo
00<007ooOol0R7oo000`Ool00`0OOomoo`1@Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03
001oogoo08Qoo`00<Woo00<07gooOol0CWoo00<007ooOol0R7oo000bOol00`0OOomoo`15Ool50004
Ool00`00Oomoo`28Ool003=oo`0301moogoo04Ioo`03001oogoo00Aoo`03001oogoo08Qoo`00=7oo
00<07gooOol0AGoo00<007ooOol017oo00<007ooOol0R7oo000eOol00`0OOomoo`14Ool00`00Oomo
o`04Ool3001;Ool00`0OOomoo`0jOol003Ioo`0301moogoo04=oo`03001oogoo00Aoo`03001oogoo
04Yoo`0301moogoo03]oo`00=goo0P0O@goo00<007ooOol017oo00<007ooOol0BGoo00<07gooOol0
?7oo000iOol00`0OOomoo`0nOol30006Ool00`00Oomoo`17Ool201loOol003Yoo`0301moogoo03mo
o`03001oogoo00Aoo`03001oogoo04Ioo`0301moogoo03moo`00>goo00<07gooOol0AGoo00<007oo
Ool0AGoo00<07gooOol0@7oo000lOol00`0OOomoo`14Ool00`00Oomoo`14Ool00`0OOomoo`11Ool0
03eoo`807dAoo`03001oogoo04=oo`0301moogoo049oo`00?goo00<07gooOol0@Goo0P00@Woo0P0O
AGoo0010Ool00`0OOomoo`10Ool00`00Oomoo`10Ool00`0OOomoo`15Ool0045oo`807d1oo`03001o
ogoo03moo`0301moogoo04Ioo`00@goo00<07gooOol0?Goo00<007ooOol0?Goo0P0OBGoo0014Ool2
01lmOol00`00Oomoo`0lOol00`0OOomoo`19Ool004Ioo`0301moogoo03Yoo`03001oogoo03Yoo`80
7daoo`00Agoo00<07gooOol0>Goo00<007ooOol0>Goo00<07gooOol0C7oo0018Ool201liOol2000h
Ool201m?Ool004Yoo`0301moogoo03Ioo`03001oogoo03Ioo`0301moogoo04moo`00Bgoo0P0O=Woo
00<007ooOol0=7oo0P0ODWoo001=Ool00`0OOomoo`0cOol00`00Oomoo`0bOol201mDOol004ioo`80
7c=oo`03001oogoo031oo`807eIoo`00D7oo0P0O<Goo00<007ooOol0;Woo0P0OF7oo001BOol201l_
Ool00`00Oomoo`0/Ool201mJOol005Aoo`807beoo`03001oogoo02Uoo`<07eaoo`00EWoo0P0O:goo
0P00:7oo0P0OGgoo001HOol201lYOol00`00Oomoo`0UOol201mQOol005Yoo`<07bIoo`03001oogoo
029oo`<07f=oo`00GGoo100O8Woo00<007ooOol087oo0P0OIWoo001QOol301lOOol00`00Oomoo`0M
Ool301mXOol006Aoo`@07a]oo`03001oogoo01Yoo`<07f]oo`00J7oo100O5goo00<007ooOol05Woo
100OKWoo001/Ool401lCOol00`00Oomoo`0>Ool801mbOol0071oo`P07`]oo`8000Yoo`D07gYoo`00
N7oo5`0OOgoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03
001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007ooOol0
0Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03001o
ogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00Oomo
o`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo
003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo00<0
07ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool0
1@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool00?mo
o`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo
0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.77866 .88022 L
.74755 .90118 L
.71167 .92121 L
.67645 .93713 L
.64337 .94907 L
.60819 .95882 L
.58855 .96301 L
.56983 .9662 L
.55189 .96854 L
.54281 .96946 L
.53279 .97026 L
.52425 .97078 L
.51945 .971 L
.51505 .97116 L
.51097 .97128 L
.50866 .97132 L
.50652 .97136 L
.50446 .97138 L
.50259 .9714 L
.50044 .9714 L
.49841 .9714 L
.49624 .97139 L
.49392 .97137 L
.49172 .97133 L
.48973 .97129 L
.48483 .97116 L
.4802 .97099 L
.47099 .97051 L
.46099 .96979 L
.44318 .96797 L
.42677 .96568 L
.3926 .95901 L
.35556 .94873 L
.32165 .93637 L
.28628 .92017 L
.22098 .87996 L
.16506 .83171 L
.11901 .77761 L
.09703 .74462 L
.07953 .71313 L
.06377 .67867 L
.05173 .64587 L
.04196 .61144 L
.03763 .59186 L
.03434 .57339 L
.03201 .55668 L
.03105 .54805 L
.03018 .53864 L
.02977 .5333 L
Mistroke
.02945 .52834 L
.02917 .5232 L
.02896 .51855 L
.0288 .51396 L
.02869 .50965 L
.02865 .50727 L
.02862 .50509 L
.0286 .50269 L
.0286 .50149 L
.0286 .50017 L
.0286 .49772 L
.02862 .49546 L
.02863 .49429 L
.02865 .49299 L
.02869 .49036 L
.02875 .48805 L
.02882 .48557 L
.02898 .48108 L
.02943 .47202 L
.02999 .46373 L
.03078 .45466 L
.03184 .44478 L
.03461 .42496 L
.03805 .40605 L
.04184 .38902 L
.05262 .35143 L
.06521 .31785 L
.08167 .28269 L
.12225 .21799 L
.17071 .16267 L
.22489 .1172 L
.25782 .09556 L
.28934 .07828 L
.32096 .06392 L
.35647 .05098 L
.39239 .04104 L
.42626 .0344 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo0023Ool00`00Oomoo`28Ool0075oo`807a1oo`80
08Uoo`00KGoo100O4Woo00<007ooOol0R7oo001YOol401lFOol00`00Oomoo`28Ool006Eoo`@07aYo
o`03001oogoo08Qoo`00HGoo100O7Woo00<007ooOol0R7oo001NOol301lROol00`00Oomoo`28Ool0
05]oo`<07bEoo`03001oogoo08Qoo`00FGoo0P0O:7oo00<007ooOol0R7oo001GOol201lZOol20029
Ool005Eoo`807baoo`03001oogoo08Qoo`00Dgoo0P0O;Woo00<007ooOol0R7oo001BOol00`0OOomo
o`0^Ool00`00Oomoo`28Ool0051oo`807c5oo`03001oogoo08Qoo`00CWoo0P0O<goo00<007ooOol0
R7oo001<Ool201leOol00`00Oomoo`28Ool004]oo`0301moogoo03Eoo`03001oogoo08Qoo`00BGoo
0P0O>7oo0P00RGoo0018Ool00`0OOomoo`0hOol00`00Oomoo`28Ool004Ioo`807c]oo`03001oogoo
08Qoo`00A7oo0P0O?Goo00<007ooOol0R7oo0013Ool00`0OOomoo`0mOol00`00Oomoo`28Ool0049o
o`0301moogoo03ioo`03001oogoo08Qoo`00@7oo0P0O@Goo00<007ooOol0R7oo000oOol00`0OOomo
o`11Ool00`00Oomoo`28Ool003ioo`0301moogoo049oo`8008Uoo`00?7oo0P0OAGoo00<007ooOol0
R7oo000kOol00`0OOomoo`15Ool00`00Oomoo`28Ool003Yoo`0301moogoo04Ioo`03001oogoo08Qo
o`00>7oo0P0O@7oo1@0017oo00<007ooOol0R7oo000gOol00`0OOomoo`12Ool00`00Oomoo`04Ool0
0`00Oomoo`28Ool003Ioo`0301moogoo04=oo`03001oogoo00Aoo`03001oogoo08Qoo`00=Goo00<0
7gooOol0>Goo1P001Goo00<007ooOol017oo0`00R7oo000dOol00`0OOomoo`15Ool00`00Oomoo`04
Ool00`00Oomoo`28Ool003=oo`0301moogoo04Ioo`03001oogoo00Aoo`03001oogoo08Qoo`00<goo
00<07gooOol0A7oo0`001Woo00<007ooOol0R7oo000bOol00`0OOomoo`17Ool00`00Oomoo`04Ool0
0`00Oomoo`28Ool0035oo`0301moogoo04moo`03001oogoo08Qoo`00<7oo00<07gooOol0D7oo00<0
07ooOol0R7oo000_Ool00`0OOomoo`1AOol00`00Oomoo`28Ool002ioo`0301moogoo059oo`8008Uo
o`00;Woo00<07gooOol0DWoo00<007ooOol0R7oo000]Ool00`0OOomoo`1COol00`00Oomoo`28Ool0
02aoo`0301moogoo05Aoo`03001oogoo08Qoo`00:goo00<07gooOol0EGoo00<007ooOol0R7oo000Z
Ool00`0OOomoo`1FOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qoo`00:Goo
00<07gooOol0Egoo00<007ooOol0R7oo000YOol00`0OOomoo`1GOol20029Ool002Qoo`0301moogoo
05Qoo`03001oogoo08Qoo`009goo00<07gooOol0FGoo00<007ooOol0R7oo000WOol00`0OOomoo`1I
Ool00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009Woo00<07gooOol0FWoo
00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Aoo`0301moogoo05aoo`03
001oogoo08Qoo`0097oo00<07gooOol0G7oo0P00RGoo000SOol00`0OOomoo`1MOol00`00Oomoo`28
Ool002=oo`0301moogoo05eoo`03001oogoo08Qoo`008Woo00<07gooOol0GWoo00<007ooOol0R7oo
000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`00
8Goo00<07gooOol0Ggoo00<007ooOol0R7oo000POol00`0OOomoo`1POol20029Ool0021oo`0301mo
ogoo061oo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000OOol00`0OOomo
o`1QOol00`00Oomoo`28Ool001ioo`0301moogoo069oo`03001oogoo08Qoo`007Woo00<07gooOol0
BGoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo000NOol00`0OOomoo`18Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`28Ool001eo
o`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo08Qo
o`007Goo00<07gooOol0@Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo
0`00R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomo
o`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03
001oogoo08Qoo`006goo00<07gooOol0Bgoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
1Woo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool4000<Ool50004Ool00`00Oomoo`28Ool001]o
o`0301moogoo06Eoo`03001oogoo08Qoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000JOol0
0`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`006Goo00<07gooOol0
Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uoo`0301moogoo06Mo
o`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomoo`1XOol0
0`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<0
07ooOol0R7oo000GOol00`0OOomoo`1YOol20029Ool001Moo`0301moogoo06Uoo`03001oogoo08Qo
o`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool0
01Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000G
Ool00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`8008Uoo`005Woo00<07goo
Ool0JWoo00<007ooOol0R7oo0009Ool50004Ool20002Ool00`0OOomoo`04000JOol5000JOol40005
Ool20005Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004Ool20005
Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001oogoo01Uoo`03001o
ogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Io
o`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001o
ogoo01Yoo`03001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00Uo
o`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007ooOol06Goo00<007oo
Ool00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<007oo
Ool03Goo00<007ooOol06Woo00<007ooOol077oo00<007ooOol03goo00<007ooOol02Goo00060005
Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00Oomoo`0AOol60002
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0IOol00`00Oomoo`02
Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`00Oomoo`0?Ool00`00Oomoo`09
Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03001oogoo009oo`03
001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001eoo`03
001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol01goo00D07gooOomoo`0001mo
o`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03001oogoo01Uo
o`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`03001oogoo00]o
o`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
01aoo`<001aoo`<000eoo`03001oogoo00eoo`002goo00<007ooOol01goo00@07gooOomoo`D001]o
o`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001oogoo01ao
o`03001oogoo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomo
o`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo07]oo`80009oo`8000Moo`00
5Goo00<07gooOol0Jgoo00<007ooOol0O7oo00@007ooOol000Qoo`005Goo00<07gooOol0Jgoo00<0
07ooOol0OGoo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1mOol20009Ool000moo`H00003
01l000000>4000Uoo`04001oogoo0008Ool000moo`03001oogoo00=oo`0301l007oo00Ioo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`005Goo
00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`03
01moogoo06]oo`03001oogoo08Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0O
Oomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<07goo
Ool0Jgoo0P00RGoo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03
001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00
Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007oo
Ool0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`8008Uoo`00
5goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Mo
o`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol0
0`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<0
7gooOol0JGoo0P00RGoo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qo
o`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomoo`1XOol0
0`00Oomoo`28Ool001Uoo`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<07gooOol0Igoo00<0
07ooOol0R7oo000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uo
o`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000KOol00`0OOomoo`1UOol00`00Oomoo`28Ool0
01]oo`0301moogoo06Eoo`03001oogoo08Qoo`006goo00<07gooOol0IGoo00<007ooOol0R7oo000L
Ool00`0OOomoo`1;Ool40005Ool20005Ool40005Ool00`00Oomoo`28Ool001aoo`0301moogoo04Yo
o`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo08Qoo`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol0R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool30028Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03
001oogoo08Qoo`007Goo00<07gooOol0BGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
1Woo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00
Oomoo`06Ool00`00Oomoo`28Ool001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03001oogoo08Qo
o`007Woo00<07gooOol0HWoo00<007ooOol0R7oo000OOol00`0OOomoo`1QOol00`00Oomoo`28Ool0
01moo`0301moogoo065oo`03001oogoo08Qoo`0087oo00<07gooOol0H7oo0P00RGoo000POol00`0O
Oomoo`1POol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`008Goo00<07goo
Ool0Ggoo00<007ooOol0R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool0029oo`0301moogoo
05ioo`03001oogoo08Qoo`008goo00<07gooOol0GGoo00<007ooOol0R7oo000SOol00`0OOomoo`1M
Ool20029Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`0097oo00<07gooOol0G7oo00<007oo
Ool0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo
08Qoo`009Woo00<07gooOol0FWoo00<007ooOol0R7oo000WOol00`0OOomoo`1IOol00`00Oomoo`28
Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qoo`00:7oo00<07gooOol0F7oo0P00RGoo000YOol0
0`0OOomoo`1GOol00`00Oomoo`28Ool002Uoo`0301moogoo05Moo`03001oogoo08Qoo`00:Woo00<0
7gooOol0EWoo00<007ooOol0R7oo000[Ool00`0OOomoo`1EOol00`00Oomoo`28Ool002aoo`0301mo
ogoo05Aoo`03001oogoo08Qoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo000^Ool00`0OOomo
o`1BOol00`00Oomoo`28Ool002moo`0301moogoo055oo`8008Uoo`00<7oo00<07gooOol0D7oo00<0
07ooOol0R7oo000`Ool00`0OOomoo`1@Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03001o
ogoo08Qoo`00<Woo00<07gooOol0CWoo00<007ooOol0R7oo000cOol00`0OOomoo`14Ool50004Ool0
0`00Oomoo`28Ool003Aoo`0301moogoo04Eoo`03001oogoo00Aoo`03001oogoo08Qoo`00=Goo00<0
7gooOol0A7oo00<007ooOol017oo00<007ooOol0R7oo000fOol00`0OOomoo`13Ool00`00Oomoo`04
Ool3001;Ool00`0OOomoo`0jOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001oogoo04Yo
o`0301moogoo03]oo`00>7oo00<07gooOol0@Goo00<007ooOol017oo00<007ooOol0BGoo00<07goo
Ool0?7oo000iOol00`0OOomoo`0nOol30006Ool00`00Oomoo`17Ool201loOol003Yoo`0301moogoo
03moo`03001oogoo00Aoo`03001oogoo04Ioo`0301moogoo03moo`00>goo0P0OAWoo00<007ooOol0
AGoo00<07gooOol0@7oo000mOol00`0OOomoo`13Ool00`00Oomoo`14Ool00`0OOomoo`11Ool003io
o`0301moogoo049oo`03001oogoo04=oo`0301moogoo049oo`00?goo00<07gooOol0@Goo0P00@Woo
0P0OAGoo0010Ool00`0OOomoo`10Ool00`00Oomoo`10Ool00`0OOomoo`15Ool0045oo`0301moogoo
03moo`03001oogoo03moo`0301moogoo04Ioo`00@Woo00<07gooOol0?Woo00<007ooOol0?Woo00<0
7gooOol0Agoo0013Ool201lnOol00`00Oomoo`0lOol201m:Ool004Eoo`807caoo`03001oogoo03]o
o`0301moogoo04Yoo`00Agoo00<07gooOol0>Goo00<007ooOol0>Woo00<07gooOol0Bgoo0018Ool2
01liOol2000iOol201m>Ool004Yoo`807cMoo`03001oogoo03Ioo`807e1oo`00C7oo00<07gooOol0
=7oo00<007ooOol0=7oo0P0ODWoo001=Ool201ldOol00`00Oomoo`0bOol201mDOol004moo`807c9o
o`03001oogoo031oo`807eIoo`00DGoo0P0O<7oo00<007ooOol0;Woo0P0OF7oo001COol201l^Ool0
0`00Oomoo`0/Ool201mJOol005Eoo`807baoo`03001oogoo02Yoo`807eaoo`00Egoo0P0O:Woo0P00
:Goo0P0OGWoo001IOol301lWOol00`00Oomoo`0UOol301mPOol005aoo`807bEoo`03001oogoo02=o
o`807f=oo`00GWoo0P0O8goo00<007ooOol08Goo0P0OIGoo001POol401lOOol00`00Oomoo`0MOol4
01mWOol006Aoo`@07a]oo`03001oogoo01Uoo`@07f]oo`00J7oo100O5goo00<007ooOol05Goo100O
Kgoo001/Ool401lCOol00`00Oomoo`0@Ool501mcOol0071oo`P07`]oo`8000Qoo`T07gQoo`00N7oo
5@0OPGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001Z
Ool50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007ooOol00Woo
00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03001oogoo
00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00Oomoo`2A
Ool006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003o
Ool?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo00<007oo
Ool00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00
Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000
\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.80539 .8591 L
.7738 .88374 L
.73675 .90764 L
.70038 .9267 L
.66392 .94199 L
.62839 .95358 L
.60924 .95857 L
.58823 .96307 L
.56898 .96633 L
.55111 .96863 L
.54174 .96955 L
.53164 .97034 L
.52675 .97065 L
.52209 .97089 L
.51751 .97108 L
.51335 .97122 L
.51078 .97128 L
.50835 .97133 L
.50579 .97137 L
.50434 .97138 L
.50301 .97139 L
.50079 .9714 L
.49835 .9714 L
.4958 .97139 L
.49342 .97136 L
.49207 .97134 L
.4906 .97131 L
.48793 .97125 L
.48292 .97109 L
.47708 .97085 L
.47168 .97055 L
.46233 .9699 L
.45228 .96898 L
.43414 .96678 L
.41271 .96325 L
.39322 .95915 L
.35635 .94898 L
.31711 .93448 L
.28126 .91758 L
.24468 .89627 L
.21181 .87305 L
.17856 .84482 L
.12444 .78492 L
.10155 .75192 L
.08047 .71499 L
.06375 .67864 L
.05122 .64429 L
.04076 .60641 L
.03636 .5852 L
Mistroke
.03308 .56489 L
.03081 .5456 L
.02988 .53478 L
.02953 .52967 L
.02926 .52497 L
.02904 .52058 L
.02886 .51577 L
.02872 .51093 L
.02867 .50828 L
.02863 .50582 L
.02861 .50347 L
.0286 .50126 L
.0286 .49927 L
.0286 .49711 L
.02862 .49476 L
.02866 .49226 L
.0287 .49013 L
.02875 .48779 L
.0289 .48302 L
.02912 .47782 L
.02973 .46736 L
.0305 .45768 L
.0314 .4487 L
.03405 .42846 L
.03786 .40702 L
.04831 .36509 L
.06165 .32659 L
.07816 .28958 L
.09613 .25687 L
.14284 .19233 L
.19739 .13855 L
.23132 .11266 L
.26421 .0918 L
.30039 .07294 L
.33522 .05833 L
.37183 .04635 L
.39277 .04095 L
.41266 .03676 L
.43053 .03374 L
.44993 .03126 L
.46045 .03026 L
.4662 .02981 L
.47156 .02945 L
.47653 .02918 L
.48105 .02898 L
.48608 .0288 L
.48885 .02873 L
.49146 .02867 L
.49378 .02864 L
.49628 .02861 L
Mistroke
.49864 .0286 L
.5008 .0286 L
.50332 .02861 L
.50475 .02862 L
.50607 .02863 L
.5085 .02867 L
.51108 .02873 L
.51669 .02889 L
.52198 .02911 L
.53184 .02967 L
.54115 .03039 L
.54969 .03122 L
.56891 .03366 L
.57374 .0344 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001iOolC01n2Ool0079oo`L07`Yoo`8000Moo`T0
7gUoo`00KGoo1@0O4Goo00<007ooOol0R7oo001XOol501lFOol00`00Oomoo`28Ool006Aoo`@07a]o
o`03001oogoo08Qoo`00HWoo0P0O7goo00<007ooOol0R7oo001OOol301lQOol00`00Oomoo`28Ool0
05aoo`<07bAoo`03001oogoo08Qoo`00FWoo0P0O9goo00<007ooOol0R7oo001GOol301lYOol20029
Ool005Eoo`807baoo`03001oogoo08Qoo`00Dgoo0P0O;Woo00<007ooOol0R7oo001AOol201l`Ool0
0`00Oomoo`28Ool004moo`807c9oo`03001oogoo08Qoo`00CGoo0P0O=7oo00<007ooOol0R7oo001<
Ool00`0OOomoo`0dOol00`00Oomoo`28Ool004Yoo`807cMoo`03001oogoo08Qoo`00BGoo00<07goo
Ool0=goo0P00RGoo0017Ool201ljOol00`00Oomoo`28Ool004Eoo`807caoo`03001oogoo08Qoo`00
A7oo00<07gooOol0?7oo00<007ooOol0R7oo0013Ool00`0OOomoo`0mOol00`00Oomoo`28Ool0049o
o`0301moogoo03ioo`03001oogoo08Qoo`00@7oo0P0O@Goo00<007ooOol0R7oo000oOol00`0OOomo
o`11Ool00`00Oomoo`28Ool003ioo`0301moogoo049oo`8008Uoo`00?Goo00<07gooOol0@goo00<0
07ooOol0R7oo000lOol00`0OOomoo`14Ool00`00Oomoo`28Ool003]oo`0301moogoo04Eoo`03001o
ogoo08Qoo`00>Woo00<07gooOol0?Goo1@0017oo00<007ooOol0R7oo000iOol00`0OOomoo`10Ool0
0`00Oomoo`04Ool00`00Oomoo`28Ool003Qoo`0301moogoo045oo`03001oogoo00Aoo`03001oogoo
08Qoo`00=Woo0P0O>Goo1P001Goo00<007ooOol017oo0`00R7oo000eOol00`0OOomoo`14Ool00`00
Oomoo`04Ool00`00Oomoo`28Ool003Aoo`0301moogoo04Eoo`03001oogoo00Aoo`03001oogoo08Qo
o`00<goo00<07gooOol0A7oo0`001Woo00<007ooOol0R7oo000bOol00`0OOomoo`17Ool00`00Oomo
o`04Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03001oogoo08Qoo`00<7oo00<07gooOol0
D7oo00<007ooOol0R7oo000_Ool00`0OOomoo`1AOol00`00Oomoo`28Ool002moo`0301moogoo055o
o`8008Uoo`00;Woo00<07gooOol0DWoo00<007ooOol0R7oo000]Ool00`0OOomoo`1COol00`00Oomo
o`28Ool002aoo`0301moogoo05Aoo`03001oogoo08Qoo`00;7oo00<07gooOol0E7oo00<007ooOol0
R7oo000[Ool00`0OOomoo`1EOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qo
o`00:Goo00<07gooOol0Egoo00<007ooOol0R7oo000YOol00`0OOomoo`1GOol20029Ool002Qoo`03
01moogoo05Qoo`03001oogoo08Qoo`009goo00<07gooOol0FGoo00<007ooOol0R7oo000VOol00`0O
Oomoo`1JOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009Goo00<07goo
Ool0Fgoo00<007ooOol0R7oo000TOol00`0OOomoo`1LOol00`00Oomoo`28Ool002Aoo`0301moogoo
05aoo`03001oogoo08Qoo`008goo00<07gooOol0GGoo0P00RGoo000SOol00`0OOomoo`1MOol00`00
Oomoo`28Ool0029oo`0301moogoo05ioo`03001oogoo08Qoo`008Woo00<07gooOol0GWoo00<007oo
Ool0R7oo000QOol00`0OOomoo`1OOol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo
08Qoo`008Goo00<07gooOol0Ggoo00<007ooOol0R7oo000POol00`0OOomoo`1POol20029Ool0021o
o`0301moogoo061oo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000OOol0
0`0OOomoo`1QOol00`00Oomoo`28Ool001ioo`0301moogoo069oo`03001oogoo08Qoo`007Woo00<0
7gooOol0BGoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`28
Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001o
ogoo08Qoo`007Goo00<07gooOol0@Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo0`00R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00Ioo`03001oogoo08Qoo`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol01Woo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool4000<Ool50004Ool00`00Oomoo`28
Ool001]oo`0301moogoo06Eoo`03001oogoo08Qoo`006goo00<07gooOol0IGoo00<007ooOol0R7oo
000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`006Woo00<0
7gooOol0IWoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uoo`0301mo
ogoo06Moo`03001oogoo08Qoo`006Goo00<07gooOol0Igoo00<007ooOol0R7oo000HOol00`0OOomo
o`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0
J7oo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol20029Ool001Moo`0301moogoo06Uoo`03001o
ogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomo
o`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0
R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`8008Uoo`005Woo
00<07gooOol0JWoo00<007ooOol0R7oo0009Ool50004Ool20002Ool00`0OOomoo`04000JOol5000J
Ool40005Ool20005Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004
Ool20005Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001oogoo01Uo
o`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001o
ogoo01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009o
o`03001oogoo01Yoo`03001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001o
ogoo00Uoo`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007ooOol06Goo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo
00<007ooOol03Goo00<007ooOol06Woo00<007ooOol077oo00<007ooOol03goo00<007ooOol02Goo
00060005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00Oomoo`0A
Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0IOol00`00
Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`00Oomoo`0?Ool00`00
Oomoo`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03001oogoo
009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@0
01eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol01goo00D07gooOomo
o`0001moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03001o
ogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`03001o
ogoo00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001oogoo
009oo`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo01aoo`<001aoo`<000eoo`03001oogoo00eoo`002goo00<007ooOol01goo00@07gooOomo
o`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001o
ogoo01aoo`03001oogoo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol0
0`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo07]oo`80009oo`80
00Moo`005Goo00<07gooOol0Jgoo00<007ooOol0O7oo00@007ooOol000Qoo`005Goo00<07gooOol0
Jgoo00<007ooOol0OGoo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1mOol20009Ool000mo
o`H0000301l000000>4000Uoo`04001oogoo0008Ool000moo`03001oogoo00=oo`0301l007oo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`80009oo`8000Mo
o`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool0
01Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000E
Ool00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo
00<07gooOol0Jgoo0P00RGoo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Ioo`0301moogoo
06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1Z
Ool00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo
00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`80
08Uoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28
Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo
000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`00
67oo00<07gooOol0J7oo0P00RGoo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qoo`0301mo
ogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomo
o`1XOol00`00Oomoo`28Ool001Uoo`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<07gooOol0
Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uoo`0301moogoo06Mo
o`8008Uoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000JOol00`0OOomoo`1VOol00`00Oomo
o`28Ool001Yoo`0301moogoo06Ioo`03001oogoo08Qoo`006Woo00<07gooOol0IWoo00<007ooOol0
R7oo000KOol00`0OOomoo`1<Ool40005Ool20005Ool40005Ool00`00Oomoo`28Ool001]oo`0301mo
ogoo04]oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009o
o`03001oogoo08Qoo`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol0R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool30028Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo00Uoo`@0
00Eoo`03001oogoo08Qoo`007Goo00<07gooOol0BGoo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol01Woo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`06Ool00`00Oomoo`28Ool001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03001o
ogoo08Qoo`007Woo00<07gooOol0HWoo00<007ooOol0R7oo000OOol00`0OOomoo`1QOol00`00Oomo
o`28Ool001moo`0301moogoo065oo`03001oogoo08Qoo`0087oo00<07gooOol0H7oo0P00RGoo000P
Ool00`0OOomoo`1POol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`008Goo
00<07gooOol0Ggoo00<007ooOol0R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool0029oo`03
01moogoo05ioo`03001oogoo08Qoo`008goo00<07gooOol0GGoo00<007ooOol0R7oo000SOol00`0O
Oomoo`1MOol20029Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`0097oo00<07gooOol0G7oo
00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Eoo`0301moogoo05]oo`03
001oogoo08Qoo`009Woo00<07gooOol0FWoo00<007ooOol0R7oo000WOol00`0OOomoo`1IOol00`00
Oomoo`28Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qoo`00:Goo00<07gooOol0Egoo0P00RGoo
000YOol00`0OOomoo`1GOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qoo`00
:goo00<07gooOol0EGoo00<007ooOol0R7oo000/Ool00`0OOomoo`1DOol00`00Oomoo`28Ool002eo
o`0301moogoo05=oo`03001oogoo08Qoo`00;Woo00<07gooOol0DWoo00<007ooOol0R7oo000_Ool0
0`0OOomoo`1AOol00`00Oomoo`28Ool002moo`0301moogoo055oo`8008Uoo`00<7oo00<07gooOol0
D7oo00<007ooOol0R7oo000aOol00`0OOomoo`1?Ool00`00Oomoo`28Ool0039oo`0301moogoo04io
o`03001oogoo08Qoo`00<goo00<07gooOol0CGoo00<007ooOol0R7oo000dOol00`0OOomoo`13Ool5
0004Ool00`00Oomoo`28Ool003Eoo`0301moogoo04Aoo`03001oogoo00Aoo`03001oogoo08Qoo`00
=Goo00<07gooOol0A7oo00<007ooOol017oo00<007ooOol0R7oo000fOol00`0OOomoo`13Ool00`00
Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001o
ogoo04Yoo`0301moogoo03]oo`00>7oo00<07gooOol0@Goo00<007ooOol017oo00<007ooOol0BGoo
00<07gooOol0?7oo000iOol00`0OOomoo`0nOol30006Ool00`00Oomoo`17Ool201loOol003Yoo`03
01moogoo03moo`03001oogoo00Aoo`03001oogoo04Ioo`0301moogoo03moo`00>goo00<07gooOol0
AGoo00<007ooOol0AGoo00<07gooOol0@7oo000lOol201m5Ool00`00Oomoo`14Ool00`0OOomoo`11
Ool003ioo`0301moogoo049oo`03001oogoo049oo`807dAoo`00?goo00<07gooOol0@Goo0P00@Woo
00<07gooOol0A7oo0010Ool00`0OOomoo`10Ool00`00Oomoo`10Ool00`0OOomoo`15Ool0045oo`80
7d1oo`03001oogoo03ioo`807dQoo`00@goo00<07gooOol0?Goo00<007ooOol0?Goo00<07gooOol0
B7oo0014Ool201lmOol00`00Oomoo`0kOol201m;Ool004Ioo`807c]oo`03001oogoo03Yoo`0301mo
ogoo04]oo`00B7oo00<07gooOol0>7oo00<007ooOol0>7oo0P0OCWoo0019Ool201lhOol2000hOol0
0`0OOomoo`1>Ool004]oo`0301moogoo03Eoo`03001oogoo03Eoo`807e5oo`00C7oo0P0O=Goo00<0
07ooOol0=7oo00<07gooOol0DGoo001>Ool201lcOol00`00Oomoo`0bOol201mDOol0051oo`0301mo
ogoo031oo`03001oogoo035oo`0301moogoo05Aoo`00DGoo0P0O<7oo00<007ooOol0;goo0P0OEgoo
001COol201l^Ool00`00Oomoo`0]Ool201mIOol005Eoo`807baoo`03001oogoo02]oo`807e]oo`00
Egoo0`0O:Goo0P00:Goo0`0OGGoo001JOol201lWOol00`00Oomoo`0UOol301mPOol005aoo`<07bAo
o`03001oogoo029oo`<07f=oo`00Ggoo0P0O8Woo00<007ooOol087oo0P0OIWoo001QOol301lOOol0
0`00Oomoo`0MOol301mXOol006Aoo`@07a]oo`03001oogoo01Yoo`<07f]oo`00J7oo1@0O5Woo00<0
07ooOol05Goo1@0OKWoo001]Ool501lAOol00`00Oomoo`0@Ool501mcOol0079oo`L07`Yoo`8000Yo
o`L07gQoo`00NGoo5P0OOgoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<0
07ooOol0R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Ao
o`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo
00<007ooOol00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool0
06aoo`03001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=
Ool00`00Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qo
o`00P7oo00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000
RGoo0020Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003o
Ool?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.80316 .86099 L
.76888 .8872 L
.72858 .91228 L
.68894 .93188 L
.65163 .94635 L
.61052 .95827 L
.58878 .96297 L
.57724 .96503 L
.56496 .96691 L
.5542 .96828 L
.54232 .9695 L
.53148 .97035 L
.52656 .97066 L
.52132 .97092 L
.51572 .97114 L
.51322 .97122 L
.51052 .97129 L
.50886 .97132 L
.50734 .97135 L
.50591 .97137 L
.50434 .97138 L
.50161 .9714 L
.50012 .9714 L
.49873 .9714 L
.49594 .97139 L
.49331 .97136 L
.49094 .97132 L
.48836 .97126 L
.48259 .97108 L
.47726 .97086 L
.46798 .97032 L
.45775 .96951 L
.43711 .96719 L
.41541 .96375 L
.39567 .95971 L
.35195 .94755 L
.31345 .93292 L
.27298 .91314 L
.23359 .8889 L
.20001 .86363 L
.13966 .80394 L
.11418 .77086 L
.08998 .73261 L
.07074 .69483 L
.05359 .65145 L
.04718 .63107 L
.04134 .60888 L
.03685 .58784 L
.03355 .56817 L
Mistroke
.03087 .54628 L
.02987 .53468 L
.02944 .52819 L
.02912 .5223 L
.02889 .51666 L
.02874 .51147 L
.02868 .50875 L
.02865 .50719 L
.02863 .50577 L
.02861 .50427 L
.0286 .50266 L
.0286 .50117 L
.0286 .49976 L
.0286 .4972 L
.02863 .49448 L
.02866 .49216 L
.02871 .4896 L
.02878 .48685 L
.02887 .4839 L
.02908 .47856 L
.02935 .47332 L
.0297 .46774 L
.0305 .45771 L
.03172 .44581 L
.03309 .43504 L
.03694 .4117 L
.04163 .3899 L
.05378 .34798 L
.06835 .31053 L
.08808 .27077 L
.10983 .23545 L
.16192 .17149 L
.1942 .14124 L
.22601 .11639 L
.26383 .09202 L
.30076 .07277 L
.33807 .05728 L
.35763 .05061 L
.37904 .04438 L
.4005 .03922 L
.42039 .03537 L
.43954 .03249 L
.44997 .03126 L
.45983 .03031 L
.46503 .02989 L
.47067 .02951 L
.47536 .02924 L
.48054 .029 L
.48613 .0288 L
.4892 .02872 L
Mistroke
.49207 .02866 L
.49475 .02862 L
.4972 .0286 L
.50002 .0286 L
.50271 .0286 L
.50523 .02862 L
.50751 .02866 L
.51014 .0287 L
.51262 .02876 L
.51704 .0289 L
.52182 .0291 L
.53266 .02973 L
.54262 .03053 L
.5637 .03292 L
.58325 .03601 L
.60454 .04033 L
.62709 .04605 L
.67097 .06069 L
.711 .07846 L
.71401 .07998 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001kOolA01n2Ool007Aoo`L07`Qoo`8000Moo`P0
7gYoo`00Kgoo1@0O3goo00<007ooOol03Woo1@0OMGoo001ZOol501lDOol00`00Oomoo`0COol501m`
Ool006Eoo`D07aUoo`03001oogoo01Qoo`D07f]oo`00HGoo100O7Woo00<007ooOol07Goo0P0OJGoo
001OOol201lROol00`00Oomoo`0OOol301mVOol005aoo`<07bAoo`03001oogoo029oo`807fAoo`00
FWoo0P0O9goo00<007ooOol097oo0`0OHGoo001GOol301lYOol2000XOol201mOOol005Eoo`807bao
o`03001oogoo02Uoo`807eeoo`00Dgoo0P0O;Woo00<007ooOol0:goo0P0OFgoo001AOol201l`Ool0
0`00Oomoo`0]Ool301mHOol004moo`807c9oo`03001oogoo08Qoo`00CGoo0P0O=7oo00<007ooOol0
R7oo001<Ool00`0OOomoo`0dOol00`00Oomoo`28Ool004Yoo`807cMoo`03001oogoo08Qoo`00BGoo
00<07gooOol0=goo0P00RGoo0017Ool201ljOol00`00Oomoo`28Ool004Ioo`0301moogoo03Yoo`03
001oogoo08Qoo`00A7oo0P0O?Goo00<007ooOol0R7oo0013Ool00`0OOomoo`0mOol00`00Oomoo`28
Ool0045oo`807d1oo`03001oogoo08Qoo`00@7oo00<07gooOol0@7oo00<007ooOol0R7oo000oOol0
0`0OOomoo`11Ool00`00Oomoo`28Ool003eoo`807dAoo`8008Uoo`00?7oo00<07gooOol0A7oo00<0
07ooOol0R7oo000kOol00`0OOomoo`15Ool00`00Oomoo`28Ool003Yoo`0301moogoo04Ioo`03001o
ogoo08Qoo`00>Goo00<07gooOol0?Woo1@0017oo00<007ooOol0R7oo000gOol201m3Ool00`00Oomo
o`04Ool00`00Oomoo`28Ool003Ioo`0301moogoo04=oo`03001oogoo00Aoo`03001oogoo08Qoo`00
=Goo00<07gooOol0>Goo1P001Goo00<007ooOol017oo0`00R7oo000dOol00`0OOomoo`15Ool00`00
Oomoo`04Ool00`00Oomoo`28Ool003=oo`0301moogoo04Ioo`03001oogoo00Aoo`03001oogoo08Qo
o`00<Woo00<07gooOol0AGoo0`001Woo00<007ooOol0R7oo000bOol00`0OOomoo`17Ool00`00Oomo
o`04Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03001oogoo08Qoo`00<7oo00<07gooOol0
D7oo00<007ooOol0R7oo000_Ool00`0OOomoo`1AOol00`00Oomoo`28Ool002ioo`0301moogoo059o
o`8008Uoo`00;Woo00<07gooOol0DWoo00<007ooOol0R7oo000]Ool00`0OOomoo`1COol00`00Oomo
o`28Ool002aoo`0301moogoo05Aoo`03001oogoo08Qoo`00:goo00<07gooOol0EGoo00<007ooOol0
R7oo000ZOol00`0OOomoo`1FOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qo
o`00:Goo00<07gooOol0Egoo00<007ooOol0R7oo000XOol00`0OOomoo`1HOol20029Ool002Moo`03
01moogoo05Uoo`03001oogoo08Qoo`009goo00<07gooOol0FGoo00<007ooOol0R7oo000VOol00`0O
Oomoo`1JOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009Goo00<07goo
Ool0Fgoo00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Aoo`0301moogoo
05aoo`03001oogoo08Qoo`0097oo00<07gooOol0G7oo0P00RGoo000SOol00`0OOomoo`1MOol00`00
Oomoo`28Ool0029oo`0301moogoo05ioo`03001oogoo08Qoo`008Woo00<07gooOol0GWoo00<007oo
Ool0R7oo000QOol00`0OOomoo`1OOol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo
08Qoo`0087oo00<07gooOol0H7oo00<007ooOol0R7oo000POol00`0OOomoo`1POol20029Ool001mo
o`0301moogoo065oo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000NOol0
0`0OOomoo`1ROol00`00Oomoo`28Ool001ioo`0301moogoo069oo`03001oogoo08Qoo`007Goo00<0
7gooOol0BWoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`28
Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001o
ogoo08Qoo`0077oo00<07gooOol0@Woo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo0`00R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00Ioo`03001oogoo08Qoo`006goo00<07gooOol0Bgoo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol01Woo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool4000<Ool50004Ool00`00Oomoo`28
Ool001]oo`0301moogoo06Eoo`03001oogoo08Qoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo
000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`006Goo00<0
7gooOol0Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uoo`0301mo
ogoo06Moo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomo
o`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0
J7oo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol20029Ool001Moo`0301moogoo06Uoo`03001o
ogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomo
o`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0
R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`8008Uoo`005Woo
00<07gooOol0JWoo00<007ooOol0R7oo0009Ool50004Ool20002Ool00`0OOomoo`04000JOol5000J
Ool40005Ool20005Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004
Ool20005Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001oogoo01Uo
o`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001o
ogoo01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009o
o`03001oogoo01Yoo`03001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001o
ogoo00Uoo`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007ooOol06Goo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo
00<007ooOol03Goo00<007ooOol06Woo00<007ooOol077oo00<007ooOol03goo00<007ooOol02Goo
00060005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00Oomoo`0A
Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0IOol00`00
Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`00Oomoo`0?Ool00`00
Oomoo`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03001oogoo
009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@0
01eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol01goo00D07gooOomo
o`0001moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03001o
ogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`03001o
ogoo00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001oogoo
009oo`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo01aoo`<001aoo`<000eoo`03001oogoo00eoo`002goo00<007ooOol01goo00@07gooOomo
o`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001o
ogoo01aoo`03001oogoo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol0
0`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo07]oo`80009oo`80
00Moo`005Goo00<07gooOol0Jgoo00<007ooOol0O7oo00@007ooOol000Qoo`005Goo00<07gooOol0
Jgoo00<007ooOol0OGoo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1mOol20009Ool000mo
o`H0000301l000000>4000Uoo`04001oogoo0008Ool000moo`03001oogoo00=oo`0301l007oo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`80009oo`8000Mo
o`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool0
01Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000E
Ool00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo
00<07gooOol0Jgoo0P00RGoo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Ioo`0301moogoo
06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1Z
Ool00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo
00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`80
08Uoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28
Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo
000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`00
67oo00<07gooOol0J7oo0P00RGoo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qoo`0301mo
ogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000IOol00`0OOomo
o`1WOol00`00Oomoo`28Ool001Uoo`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<07gooOol0
Igoo00<007ooOol0R7oo000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Io
o`8008Uoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000KOol00`0OOomoo`1UOol00`00Oomo
o`28Ool001]oo`0301moogoo06Eoo`03001oogoo08Qoo`006goo00<07gooOol0IGoo00<007ooOol0
R7oo000KOol00`0OOomoo`1<Ool40005Ool20005Ool40005Ool00`00Oomoo`28Ool001aoo`0301mo
ogoo04Yoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009o
o`03001oogoo08Qoo`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool30028Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00Uoo`@0
00Eoo`03001oogoo08Qoo`007Goo00<07gooOol0BGoo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol01Woo00<007ooOol0R7oo000NOol00`0OOomoo`18Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`06Ool00`00Oomoo`28Ool001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03001o
ogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000OOol00`0OOomoo`1QOol00`00Oomo
o`28Ool001moo`0301moogoo065oo`03001oogoo08Qoo`0087oo00<07gooOol0H7oo0P00RGoo000P
Ool00`0OOomoo`1POol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`008Goo
00<07gooOol0Ggoo00<007ooOol0R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool0029oo`03
01moogoo05ioo`03001oogoo08Qoo`008goo00<07gooOol0GGoo00<007ooOol0R7oo000SOol00`0O
Oomoo`1MOol20029Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`0097oo00<07gooOol0G7oo
00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03
001oogoo08Qoo`009Woo00<07gooOol0FWoo00<007ooOol0R7oo000WOol00`0OOomoo`1IOol00`00
Oomoo`28Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qoo`00:7oo00<07gooOol0F7oo0P00RGoo
000YOol00`0OOomoo`1GOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qoo`00
:goo00<07gooOol0EGoo00<007ooOol0R7oo000[Ool00`0OOomoo`1EOol00`00Oomoo`28Ool002ao
o`0301moogoo05Aoo`03001oogoo08Qoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo000^Ool0
0`0OOomoo`1BOol00`00Oomoo`28Ool002ioo`0301moogoo059oo`8008Uoo`00;goo00<07gooOol0
DGoo00<007ooOol0R7oo000`Ool00`0OOomoo`1@Ool00`00Oomoo`28Ool0035oo`0301moogoo04mo
o`03001oogoo08Qoo`00<Woo00<07gooOol0CWoo00<007ooOol0R7oo000cOol00`0OOomoo`14Ool5
0004Ool00`00Oomoo`28Ool003Aoo`0301moogoo04Eoo`03001oogoo00Aoo`03001oogoo08Qoo`00
=Goo00<07gooOol0A7oo00<007ooOol017oo00<007ooOol0R7oo000fOol00`0OOomoo`13Ool00`00
Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001o
ogoo04Yoo`0301moogoo03]oo`00>7oo00<07gooOol0@Goo00<007ooOol017oo00<007ooOol0BGoo
00<07gooOol0?7oo000iOol00`0OOomoo`0nOol30006Ool00`00Oomoo`17Ool201loOol003Yoo`03
01moogoo03moo`03001oogoo00Aoo`03001oogoo04Ioo`0301moogoo03moo`00>goo00<07gooOol0
AGoo00<007ooOol0AGoo00<07gooOol0@7oo000lOol00`0OOomoo`14Ool00`00Oomoo`14Ool00`0O
Oomoo`11Ool003eoo`0301moogoo04=oo`03001oogoo04=oo`0301moogoo049oo`00?Woo00<07goo
Ool0@Woo0P00@Woo0P0OAGoo000oOol201m2Ool00`00Oomoo`10Ool00`0OOomoo`15Ool0045oo`03
01moogoo03moo`03001oogoo03moo`0301moogoo04Ioo`00@Woo00<07gooOol0?Woo00<007ooOol0
?Goo0P0OBGoo0013Ool201lnOol00`00Oomoo`0lOol00`0OOomoo`19Ool004Eoo`0301moogoo03]o
o`03001oogoo03Yoo`807daoo`00AWoo0P0O>goo00<007ooOol0>7oo0P0OCWoo0018Ool201liOol2
000hOol00`0OOomoo`1>Ool004Yoo`807cMoo`03001oogoo03Eoo`807e5oo`00C7oo0P0O=Goo00<0
07ooOol0<goo0P0ODgoo001>Ool00`0OOomoo`0bOol00`00Oomoo`0bOol00`0OOomoo`1COol004mo
o`807c9oo`03001oogoo031oo`807eIoo`00DGoo0P0O<7oo00<007ooOol0;Woo0P0OF7oo001COol2
01l^Ool00`00Oomoo`0/Ool201mJOol005Eoo`807baoo`03001oogoo02Yoo`807eaoo`00Egoo0`0O
:Goo0P00:Goo0P0OGWoo001JOol301lVOol00`00Oomoo`0UOol301mPOol005eoo`<07b=oo`03001o
ogoo029oo`<07f=oo`00H7oo0`0O87oo00<007ooOol07goo0`0OIWoo001SOol301lMOol00`00Oomo
o`0LOol301mYOol006Ioo`@07aUoo`03001oogoo01Uoo`<07faoo`00JWoo0`0O5Woo00<007ooOol0
5Goo100OKgoo001]Ool501lAOol00`00Oomoo`0>Ool701mcOol0079oo`T07`Qoo`8000Moo`P07gYo
o`00Ngoo4@0OPWoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007oo
Ool00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03
001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00
Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo
00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020
Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool0
0?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.80092 .86287 L
.76393 .8906 L
.72031 .91675 L
.67737 .93676 L
.63695 .95107 L
.61396 .95742 L
.59247 .96225 L
.569 .96633 L
.55655 .968 L
.54332 .96941 L
.53778 .96989 L
.53181 .97033 L
.52665 .97065 L
.52102 .97094 L
.5176 .97108 L
.51443 .97118 L
.51115 .97127 L
.50817 .97133 L
.50524 .97138 L
.50247 .9714 L
.49956 .9714 L
.49792 .9714 L
.4964 .97139 L
.49346 .97136 L
.49067 .97131 L
.48817 .97126 L
.48545 .97118 L
.47935 .97095 L
.47371 .97067 L
.46345 .96999 L
.45258 .96901 L
.42985 .96616 L
.40495 .96172 L
.38202 .9564 L
.36126 .95052 L
.31558 .93384 L
.27583 .91469 L
.2346 .8896 L
.19518 .85959 L
.16226 .82887 L
.1054 .75791 L
.08274 .71935 L
.06241 .67532 L
.04731 .63151 L
.04135 .60891 L
.03609 .58375 L
.03409 .57176 L
.03247 .56033 L
.03124 .54991 L
Mistroke
.03019 .53879 L
.02971 .53246 L
.02935 .52672 L
.02906 .52088 L
.02885 .51552 L
.02876 .51245 L
.02869 .50922 L
.02866 .50754 L
.02863 .50598 L
.02861 .50426 L
.0286 .50242 L
.0286 .50084 L
.0286 .49911 L
.0286 .49748 L
.02861 .49597 L
.02865 .49313 L
.0287 .4901 L
.02876 .48744 L
.02885 .48453 L
.02908 .47867 L
.02936 .47325 L
.02967 .46821 L
.03058 .45683 L
.03185 .44472 L
.035 .42258 L
.03876 .40263 L
.05009 .35927 L
.06694 .31377 L
.08736 .27207 L
.11331 .23039 L
.17042 .16296 L
.20439 .1328 L
.24389 .10424 L
.2838 .0811 L
.3296 .06047 L
.35159 .05257 L
.37536 .04537 L
.39796 .03977 L
.41892 .03562 L
.44049 .03237 L
.45188 .03106 L
.46391 .02998 L
.46899 .02962 L
.47442 .02929 L
.47912 .02906 L
.48422 .02886 L
.48734 .02877 L
.49022 .0287 L
.49297 .02865 L
.49588 .02861 L
Mistroke
.49849 .0286 L
.50093 .0286 L
.50361 .02861 L
.50649 .02864 L
.50809 .02866 L
.5096 .02869 L
.51241 .02876 L
.51872 .02897 L
.52417 .02922 L
.53006 .02956 L
.54343 .0306 L
.55569 .0319 L
.57826 .03514 L
.60188 .03974 L
.64609 .0518 L
.6861 .06688 L
.72873 .08781 L
.76557 .11052 L
.83333 .16667 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001jOolB01n2Ool007=oo`L07`Uoo`8000Moo`L0
7g]oo`00KWoo1@0O47oo00<007ooOol03Goo1@0OMWoo001YOol501lEOol00`00Oomoo`0BOol501ma
Ool006Eoo`@07aYoo`03001oogoo01Moo`<07fioo`00HWoo0`0O7Woo00<007ooOol06Woo100OJWoo
001OOol301lQOol00`00Oomoo`0NOol301mWOol005eoo`807bAoo`03001oogoo025oo`<07fAoo`00
FWoo0`0O9Woo00<007ooOol097oo0`0OHGoo001HOol201lYOol2000XOol201mOOol005Eoo`<07b]o
o`03001oogoo02Uoo`807eeoo`00Dgoo0P0O;Woo00<007ooOol0:goo0P0OFgoo001AOol201l`Ool0
0`00Oomoo`0]Ool201mIOol004moo`807c9oo`03001oogoo02moo`807eMoo`00CGoo0P0O=7oo00<0
07ooOol0<Goo0P0OEGoo001<Ool00`0OOomoo`0dOol00`00Oomoo`0cOol201mCOol004Yoo`807cMo
o`03001oogoo03Eoo`807e5oo`00B7oo0P0O>Goo0P00>7oo0P0OCgoo0017Ool00`0OOomoo`0iOol0
0`00Oomoo`0iOol201m=Ool004Eoo`807caoo`03001oogoo03]oo`0301moogoo04Yoo`00A7oo00<0
7gooOol0?7oo00<007ooOol0?7oo00<07gooOol0BGoo0012Ool201loOol00`00Oomoo`0mOol201m9
Ool0045oo`0301moogoo03moo`03001oogoo03moo`0301moogoo04Ioo`00?goo0P0O@Woo00<007oo
Ool0@7oo00<07gooOol0AGoo000nOol00`0OOomoo`12Ool00`00Oomoo`11Ool00`0OOomoo`14Ool0
03eoo`0301moogoo04=oo`8004=oo`0301moogoo04=oo`00?7oo00<07gooOol0A7oo00<007ooOol0
@goo0P0O@goo000kOol00`0OOomoo`15Ool00`00Oomoo`15Ool00`0OOomoo`10Ool003Uoo`807dQo
o`03001oogoo04Ioo`0301moogoo03moo`00>7oo00<07gooOol0?goo1@0017oo00<007ooOol0Agoo
00<07gooOol0?Woo000gOol00`0OOomoo`12Ool00`00Oomoo`04Ool00`00Oomoo`18Ool201lnOol0
03Ioo`0301moogoo04=oo`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo03]oo`00=Goo00<0
7gooOol0>Goo1P001Goo00<007ooOol017oo0`00Bgoo00<07gooOol0>Woo000dOol00`0OOomoo`15
Ool00`00Oomoo`04Ool00`00Oomoo`28Ool003Aoo`0301moogoo04Eoo`03001oogoo00Aoo`03001o
ogoo08Qoo`00<goo00<07gooOol0A7oo0`001Woo00<007ooOol0R7oo000bOol00`0OOomoo`17Ool0
0`00Oomoo`04Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03001oogoo08Qoo`00<7oo00<0
7gooOol0D7oo00<007ooOol0R7oo000_Ool00`0OOomoo`1AOol00`00Oomoo`28Ool002moo`0301mo
ogoo055oo`8008Uoo`00;Woo00<07gooOol0DWoo00<007ooOol0R7oo000]Ool00`0OOomoo`1COol0
0`00Oomoo`28Ool002aoo`0301moogoo05Aoo`03001oogoo08Qoo`00:goo00<07gooOol0EGoo00<0
07ooOol0R7oo000[Ool00`0OOomoo`1EOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001o
ogoo08Qoo`00:Goo00<07gooOol0Egoo00<007ooOol0R7oo000XOol00`0OOomoo`1HOol20029Ool0
02Qoo`0301moogoo05Qoo`03001oogoo08Qoo`009goo00<07gooOol0FGoo00<007ooOol0R7oo000W
Ool00`0OOomoo`1IOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009Goo
00<07gooOol0Fgoo00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Aoo`03
01moogoo05aoo`03001oogoo08Qoo`0097oo00<07gooOol0G7oo0P00RGoo000SOol00`0OOomoo`1M
Ool00`00Oomoo`28Ool0029oo`0301moogoo05ioo`03001oogoo08Qoo`008Woo00<07gooOol0GWoo
00<007ooOol0R7oo000QOol00`0OOomoo`1OOol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03
001oogoo08Qoo`0087oo00<07gooOol0H7oo00<007ooOol0R7oo000POol00`0OOomoo`1POol20029
Ool001moo`0301moogoo065oo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo
000NOol00`0OOomoo`1ROol00`00Oomoo`28Ool001ioo`0301moogoo069oo`03001oogoo08Qoo`00
7Woo00<07gooOol0BGoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo000MOol00`0OOomoo`19
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`28Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009o
o`03001oogoo08Qoo`0077oo00<07gooOol0@Woo1P000Woo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo0`00R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool4
0005Ool00`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Ioo`03001oogoo08Qoo`006goo00<07gooOol0Bgoo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool4000<Ool50004Ool00`00
Oomoo`28Ool001Yoo`0301moogoo06Ioo`03001oogoo08Qoo`006Woo00<07gooOol0IWoo00<007oo
Ool0R7oo000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`00
6Goo00<07gooOol0Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uo
o`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<07gooOol0Igoo00<007ooOol0R7oo000IOol0
0`0OOomoo`1WOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<0
7gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomoo`1XOol20029Ool001Qoo`0301moogoo06Qo
o`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol0
0`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<0
07ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`8008Uo
o`005Woo00<07gooOol0JWoo00<007ooOol0R7oo0009Ool50004Ool20002Ool00`0OOomoo`04000J
Ool5000JOol40005Ool20005Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000J
Ool50004Ool20005Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001o
ogoo01Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009o
o`03001oogoo01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001o
ogoo009oo`03001oogoo01Yoo`03001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009o
o`03001oogoo00Uoo`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007oo
Ool06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007oo
Ool00Woo00<007ooOol03Goo00<007ooOol06Woo00<007ooOol077oo00<007ooOol03goo00<007oo
Ool02Goo00060005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00
Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0I
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`00Oomoo`0?
Ool00`00Oomoo`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo
00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol027oo00@0
7gooOol001moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03
001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`03
001oogoo00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uo
o`03001oogoo01aoo`<001aoo`<000eoo`03001oogoo00eoo`002goo00<007ooOol01goo00@07goo
Oomoo`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03
001oogoo01aoo`03001oogoo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000E
Ool00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo07]oo`80009o
o`8000Moo`005Goo00<07gooOol0Jgoo00<007ooOol0O7oo00@007ooOol000Qoo`005Goo00<07goo
Ool0Jgoo00<007ooOol0OGoo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1mOol20009Ool0
00moo`H0000301l000000>4000Uoo`04001oogoo0008Ool000moo`03001oogoo00=oo`0301l007oo
00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`80009oo`80
00Moo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28
Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo
000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`00
5Goo00<07gooOol0Jgoo0P00RGoo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301mo
ogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomo
o`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0
JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yo
o`8008Uoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomo
o`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0
R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qo
o`0067oo00<07gooOol0J7oo0P00RGoo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qoo`03
01moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000IOol00`0O
Oomoo`1WOol00`00Oomoo`28Ool001Uoo`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<07goo
Ool0Igoo00<007ooOol0R7oo000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo
06Ioo`8008Uoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000KOol00`0OOomoo`1UOol00`00
Oomoo`28Ool001]oo`0301moogoo06Eoo`03001oogoo08Qoo`006goo00<07gooOol0IGoo00<007oo
Ool0R7oo000LOol00`0OOomoo`1;Ool40005Ool20005Ool40005Ool00`00Oomoo`28Ool001aoo`03
01moogoo04Yoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo
009oo`03001oogoo08Qoo`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol00Woo00<007ooOol0R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool30028Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00Uo
o`@000Eoo`03001oogoo08Qoo`007Goo00<07gooOol0BGoo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol01Woo00<007ooOol0R7oo000NOol00`0OOomoo`18Ool00`00Oomoo`02Ool00`00Oomo
o`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03
001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000OOol00`0OOomoo`1QOol00`00
Oomoo`28Ool0021oo`0301moogoo061oo`03001oogoo08Qoo`0087oo00<07gooOol0H7oo0P00RGoo
000QOol00`0OOomoo`1OOol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`00
8Woo00<07gooOol0GWoo00<007ooOol0R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool002=o
o`0301moogoo05eoo`03001oogoo08Qoo`008goo00<07gooOol0GGoo00<007ooOol0R7oo000TOol0
0`0OOomoo`1LOol20029Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`009Goo00<07gooOol0
Fgoo00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yo
o`03001oogoo08Qoo`009Woo00<07gooOol0FWoo00<007ooOol0R7oo000WOol00`0OOomoo`1IOol0
0`00Oomoo`28Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qoo`00:Goo00<07gooOol0Egoo0P00
RGoo000YOol00`0OOomoo`1GOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qo
o`00:goo00<07gooOol0EGoo00<007ooOol0R7oo000/Ool00`0OOomoo`1DOol00`00Oomoo`28Ool0
02aoo`0301moogoo05Aoo`03001oogoo08Qoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo000^
Ool00`0OOomoo`1BOol00`00Oomoo`28Ool002moo`0301moogoo055oo`8008Uoo`00;goo00<07goo
Ool0DGoo00<007ooOol0R7oo000`Ool00`0OOomoo`1@Ool00`00Oomoo`28Ool0035oo`0301moogoo
04moo`03001oogoo08Qoo`00<Woo00<07gooOol0CWoo00<007ooOol0R7oo000bOol00`0OOomoo`15
Ool50004Ool00`00Oomoo`28Ool003=oo`0301moogoo04Ioo`03001oogoo00Aoo`03001oogoo08Qo
o`00=7oo00<07gooOol0AGoo00<007ooOol017oo00<007ooOol0R7oo000eOol00`0OOomoo`14Ool0
0`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Ioo`0301moogoo04=oo`03001oogoo00Aoo`03
001oogoo04Yoo`0301moogoo03]oo`00=goo00<07gooOol0@Woo00<007ooOol017oo00<007ooOol0
BGoo00<07gooOol0?7oo000hOol201m0Ool30006Ool00`00Oomoo`18Ool00`0OOomoo`0mOol003Yo
o`0301moogoo03moo`03001oogoo00Aoo`03001oogoo04Ioo`807d1oo`00>goo00<07gooOol0AGoo
00<007ooOol0AGoo00<07gooOol0@7oo000lOol00`0OOomoo`14Ool00`00Oomoo`14Ool00`0OOomo
o`11Ool003eoo`0301moogoo04=oo`03001oogoo04=oo`0301moogoo049oo`00?Woo0P0O@goo0P00
@goo00<07gooOol0@goo0010Ool00`0OOomoo`10Ool00`00Oomoo`10Ool201m6Ool0045oo`0301mo
ogoo03moo`03001oogoo03moo`0301moogoo04Ioo`00@Woo0P0O?goo00<007ooOol0?Woo00<07goo
Ool0Agoo0014Ool00`0OOomoo`0lOol00`00Oomoo`0lOol201m:Ool004Eoo`0301moogoo03]oo`03
001oogoo03]oo`0301moogoo04Yoo`00AWoo0P0O>goo00<007ooOol0>Goo0P0OCGoo0018Ool201li
Ool2000hOol201m?Ool004Yoo`0301moogoo03Ioo`03001oogoo03Eoo`807e5oo`00Bgoo0P0O=Woo
00<007ooOol0<goo0P0ODgoo001=Ool201ldOol00`00Oomoo`0aOol201mEOol004moo`807c9oo`03
001oogoo031oo`0301moogoo05Eoo`00DGoo0P0O<7oo00<007ooOol0;Woo0P0OF7oo001COol201l^
Ool00`00Oomoo`0/Ool201mJOol005Eoo`807baoo`03001oogoo02Yoo`807eaoo`00Egoo0`0O:Goo
0P00:Goo0P0OGWoo001JOol301lVOol00`00Oomoo`0UOol301mPOol005eoo`807bAoo`03001oogoo
029oo`<07f=oo`00Ggoo0`0O8Goo00<007ooOol07goo0`0OIWoo001ROol401lMOol00`00Oomoo`0L
Ool301mYOol006Ioo`@07aUoo`03001oogoo01Yoo`807faoo`00JWoo0P0O5goo00<007ooOol05Woo
100OKWoo001/Ool401lCOol00`00Oomoo`0AOol501mbOol0071oo`X07`Uoo`8000Qoo`X07gMoo`00
NWoo4`0OPGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo
001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03
001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007ooOol0
0Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03001o
ogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00Oomo
o`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo
003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo00<0
07ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool0
1@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool00?mo
o`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo
0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.79866 .86473 L
.75893 .89393 L
.71574 .91914 L
.66567 .94133 L
.61928 .95607 L
.5927 .9622 L
.58086 .96442 L
.56826 .96644 L
.55657 .968 L
.54366 .96938 L
.538 .96987 L
.5319 .97032 L
.52617 .97068 L
.52085 .97094 L
.51424 .97119 L
.51074 .97128 L
.50895 .97132 L
.50702 .97135 L
.50516 .97138 L
.50346 .97139 L
.50183 .9714 L
.50011 .9714 L
.49713 .9714 L
.49386 .97136 L
.49063 .97131 L
.48769 .97124 L
.4843 .97114 L
.48108 .97102 L
.47538 .97076 L
.46917 .9704 L
.45715 .96945 L
.44588 .96829 L
.42034 .96462 L
.39567 .95971 L
.36941 .95296 L
.32232 .93664 L
.2749 .91419 L
.23304 .88853 L
.19669 .86087 L
.12927 .79117 L
.09888 .74765 L
.07486 .70367 L
.05576 .65771 L
.04253 .61376 L
.03731 .59022 L
.03352 .56798 L
.03183 .55515 L
.0306 .5434 L
.03004 .53689 L
Mistroke
.02954 .52979 L
.02916 .52308 L
.0289 .51686 L
.02879 .51365 L
.02871 .51026 L
.02865 .50736 L
.02861 .50419 L
.0286 .5024 L
.0286 .50077 L
.0286 .49889 L
.0286 .49711 L
.02863 .49394 L
.02866 .49215 L
.02869 .4905 L
.02876 .48755 L
.02884 .48478 L
.02909 .47848 L
.02941 .47234 L
.02984 .46573 L
.03085 .45399 L
.03222 .44167 L
.03547 .41977 L
.04012 .39642 L
.04636 .3718 L
.06091 .32846 L
.08303 .2801 L
.10875 .23705 L
.16989 .16347 L
.20702 .1307 L
.24978 .10048 L
.29241 .07677 L
.33425 .0587 L
.35879 .05024 L
.38246 .04349 L
.40381 .03851 L
.42764 .03418 L
.43906 .03255 L
.45142 .03111 L
.45824 .03045 L
.46451 .02993 L
.47089 .0295 L
.47684 .02916 L
.48198 .02894 L
.48748 .02876 L
.49062 .02869 L
.49358 .02864 L
.49624 .02861 L
.49913 .0286 L
.50196 .0286 L
.50507 .02862 L
Mistroke
.50832 .02867 L
.51136 .02873 L
.5142 .02881 L
.51679 .02889 L
.52263 .02914 L
.52885 .02948 L
.53448 .02986 L
.54708 .03095 L
.55872 .03227 L
.56965 .03377 L
.59406 .03807 L
.62014 .04416 L
.66739 .05932 L
.71526 .08062 L
.75753 .10516 L
.79448 .13189 L
.86339 .19972 L
.89472 .24228 L
.91982 .28558 L
.92002 .28599 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001kOolB01n1Ool0071oo`/07`Qoo`8000Qoo`T0
7gQoo`00K7oo100O4goo00<007ooOol047oo1@0OLgoo001ZOol201lGOol00`00Oomoo`0EOol301m`
Ool006Ioo`@07aUoo`03001oogoo01Qoo`<07feoo`00HGoo1@0O7Goo00<007ooOol06goo100OJGoo
001NOol301lROol00`00Oomoo`0OOol401mUOol005]oo`<07bEoo`03001oogoo02=oo`<07f9oo`00
FGoo0P0O:7oo00<007ooOol09Woo0P0OH7oo001GOol201lZOol2000YOol201mNOol005Eoo`807bao
o`03001oogoo02Yoo`807eaoo`00Dgoo0P0O;Woo00<007ooOol0;7oo0P0OFWoo001AOol201l`Ool0
0`00Oomoo`0^Ool201mHOol004moo`807c9oo`03001oogoo031oo`807eIoo`00CWoo00<07gooOol0
<Woo00<007ooOol0<Woo0P0OE7oo001<Ool201leOol00`00Oomoo`0dOol00`0OOomoo`1AOol004Yo
o`807cMoo`03001oogoo03Eoo`807e5oo`00BGoo00<07gooOol0=goo0P00>7oo0P0OCgoo0017Ool2
01ljOol00`00Oomoo`0iOol00`0OOomoo`1<Ool004Ioo`0301moogoo03Yoo`03001oogoo03Yoo`80
7daoo`00AGoo00<07gooOol0>goo00<007ooOol0?7oo00<07gooOol0BGoo0013Ool201lnOol00`00
Oomoo`0mOol201m9Ool0049oo`0301moogoo03ioo`03001oogoo03moo`0301moogoo04Ioo`00@7oo
0P0O@Goo00<007ooOol0@7oo0P0OAWoo000oOol00`0OOomoo`11Ool00`00Oomoo`12Ool00`0OOomo
o`13Ool003ioo`0301moogoo049oo`8004Aoo`0301moogoo049oo`00?Goo00<07gooOol0@goo00<0
07ooOol0A7oo00<07gooOol0@Goo000lOol00`0OOomoo`14Ool00`00Oomoo`15Ool00`0OOomoo`10
Ool003Yoo`807dMoo`03001oogoo04Ioo`0301moogoo03moo`00>Goo00<07gooOol0?Woo1@0017oo
00<007ooOol0Agoo00<07gooOol0?Woo000hOol00`0OOomoo`11Ool00`00Oomoo`04Ool00`00Oomo
o`18Ool00`0OOomoo`0mOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001oogoo04Uoo`03
01moogoo03aoo`00=Woo00<07gooOol0>7oo1P001Goo00<007ooOol017oo0`00BWoo00<07gooOol0
>goo000eOol00`0OOomoo`14Ool00`00Oomoo`04Ool00`00Oomoo`1;Ool00`0OOomoo`0jOol003Ao
o`0301moogoo04Eoo`03001oogoo00Aoo`03001oogoo04aoo`0301moogoo03Uoo`00=7oo00<07goo
Ool0@goo0`001Woo00<007ooOol0CGoo00<07gooOol0>7oo000cOol00`0OOomoo`16Ool00`00Oomo
o`04Ool00`00Oomoo`1>Ool00`0OOomoo`0gOol0039oo`0301moogoo04ioo`03001oogoo04moo`03
01moogoo03Ioo`00<Goo00<07gooOol0Cgoo00<007ooOol0D7oo00<07gooOol0=Goo000`Ool00`0O
Oomoo`1@Ool00`00Oomoo`1AOol00`0OOomoo`0dOol002moo`0301moogoo055oo`8005=oo`0301mo
ogoo03=oo`00;goo00<07gooOol0DGoo00<007ooOol0Dgoo00<07gooOol0<Woo000^Ool00`0OOomo
o`1BOol00`00Oomoo`1COol00`0OOomoo`0bOol002eoo`0301moogoo05=oo`03001oogoo05Aoo`03
01moogoo035oo`00;7oo00<07gooOol0E7oo00<007ooOol0EGoo00<07gooOol0<7oo000[Ool00`0O
Oomoo`1EOol00`00Oomoo`1FOol00`0OOomoo`0_Ool002Yoo`0301moogoo05Ioo`03001oogoo05Io
o`0301moogoo02moo`00:Woo00<07gooOol0EWoo00<007ooOol0Egoo00<07gooOol0;Woo000YOol0
0`0OOomoo`1GOol2001IOol00`0OOomoo`0]Ool002Qoo`0301moogoo05Qoo`03001oogoo05Qoo`03
01moogoo02eoo`009goo00<07gooOol0FGoo00<007ooOol0FGoo00<07gooOol0;7oo000WOol00`0O
Oomoo`1IOol00`00Oomoo`1JOol00`0OOomoo`0[Ool002Ioo`0301moogoo05Yoo`03001oogoo05Yo
o`0301moogoo02]oo`009Woo00<07gooOol0FWoo00<007ooOol0Fgoo00<07gooOol0:Woo000UOol0
0`0OOomoo`1KOol00`00Oomoo`1KOol00`0OOomoo`0ZOol002Aoo`0301moogoo05aoo`03001oogoo
05aoo`0301moogoo02Uoo`0097oo00<07gooOol0G7oo0P00GWoo00<07gooOol0:7oo000SOol00`0O
Oomoo`1MOol00`00Oomoo`1MOol00`0OOomoo`0XOol002=oo`0301moogoo05eoo`03001oogoo05io
o`0301moogoo02Moo`008Woo00<07gooOol0GWoo00<007ooOol0GWoo00<07gooOol09goo000ROol0
0`0OOomoo`1NOol00`00Oomoo`1OOol00`0OOomoo`0VOol0025oo`0301moogoo05moo`03001oogoo
08Qoo`008Goo00<07gooOol0Ggoo00<007ooOol0R7oo000POol00`0OOomoo`1POol20029Ool0021o
o`0301moogoo061oo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000OOol0
0`0OOomoo`1QOol00`00Oomoo`28Ool001ioo`0301moogoo069oo`03001oogoo08Qoo`007Woo00<0
7gooOol0BGoo10001Goo0P001Goo10001Goo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`28
Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001o
ogoo08Qoo`007Goo00<07gooOol0@Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo0`00R7oo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00Ioo`03001oogoo08Qoo`006goo00<07gooOol0Bgoo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol01Woo00<007ooOol0R7oo000KOol00`0OOomoo`1<Ool4000<Ool50004Ool00`00Oomoo`28
Ool001]oo`0301moogoo06Eoo`03001oogoo08Qoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo
000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Uoo`0301moogoo06Moo`8008Uoo`006Goo00<0
7gooOol0Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Uoo`0301mo
ogoo06Moo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomo
o`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0
J7oo00<007ooOol0R7oo000HOol00`0OOomoo`1XOol20029Ool001Qoo`0301moogoo06Qoo`03001o
ogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomo
o`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0
R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`8008Uoo`005Woo
00<07gooOol0JWoo00<007ooOol0R7oo0009Ool50004Ool20002Ool00`0OOomoo`04000JOol5000J
Ool40005Ool20005Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol50004
Ool20005Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001oogoo01Uo
o`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001o
ogoo01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009o
o`03001oogoo01Yoo`03001oogoo01aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001o
ogoo00Uoo`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007ooOol06Goo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo
00<007ooOol03Goo00<007ooOol06Woo00<007ooOol077oo00<007ooOol03goo00<007ooOol02Goo
00060005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00Oomoo`0A
Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0IOol00`00
Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`00Oomoo`0?Ool00`00
Oomoo`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03001oogoo
009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@0
01eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`002goo00<007ooOol01goo00D07gooOomo
o`0001moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03001o
ogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`03001o
ogoo00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001oogoo
009oo`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo01aoo`<001aoo`<000eoo`03001oogoo00eoo`002goo00<007ooOol01goo00@07gooOomo
o`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001aoo`03001o
ogoo01aoo`03001oogoo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol0
0`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo07]oo`80009oo`80
00Moo`005Goo00<07gooOol0Jgoo00<007ooOol0O7oo00@007ooOol000Qoo`005Goo00<07gooOol0
Jgoo00<007ooOol0OGoo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1mOol20009Ool000mo
o`H0000301l000000>4000Uoo`04001oogoo0008Ool000moo`03001oogoo00=oo`0301l007oo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`80009oo`8000Mo
o`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool0
01Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000E
Ool00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Woo
00<07gooOol0JWoo0P00RGoo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo
06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1Z
Ool00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo
00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`80
08Uoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28
Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo
000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`00
5goo00<07gooOol0JGoo0P00RGoo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qoo`0301mo
ogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000HOol00`0OOomo
o`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`006Goo00<07gooOol0
Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomoo`28Ool001Yoo`0301moogoo06Io
o`8008Uoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000JOol00`0OOomoo`1VOol00`00Oomo
o`28Ool001]oo`0301moogoo06Eoo`03001oogoo08Qoo`006goo00<07gooOol0IGoo00<007ooOol0
R7oo000LOol00`0OOomoo`1;Ool40005Ool20005Ool40005Ool00`00Oomoo`28Ool001aoo`0301mo
ogoo04Yoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009o
o`03001oogoo08Qoo`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool30028Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00Uoo`@0
00Eoo`03001oogoo08Qoo`007Goo00<07gooOol0BGoo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol01Woo00<007ooOol0R7oo000NOol00`0OOomoo`18Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`06Ool00`00Oomoo`28Ool001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03001o
ogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000OOol00`0OOomoo`1QOol00`00Oomo
o`28Ool001moo`0301moogoo065oo`03001oogoo08Qoo`0087oo00<07gooOol0H7oo0P00RGoo000P
Ool00`0OOomoo`1POol00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`008Goo
00<07gooOol0Ggoo00<007ooOol0R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool0029oo`03
01moogoo05ioo`03001oogoo08Qoo`008goo00<07gooOol0GGoo00<007ooOol0R7oo000TOol00`0O
Oomoo`1LOol20029Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`009Goo00<07gooOol0Fgoo
00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03
001oogoo08Qoo`009goo00<07gooOol0FGoo00<007ooOol0R7oo000WOol00`0OOomoo`1IOol00`00
Oomoo`28Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qoo`00:Goo00<07gooOol0Egoo0P00RGoo
000ZOol00`0OOomoo`1FOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qoo`00
:goo00<07gooOol0EGoo00<007ooOol0R7oo000/Ool00`0OOomoo`1DOol00`00Oomoo`28Ool002ao
o`0301moogoo05Aoo`03001oogoo08Qoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo000^Ool0
0`0OOomoo`1BOol00`00Oomoo`28Ool002moo`0301moogoo055oo`8008Uoo`00<7oo00<07gooOol0
D7oo00<007ooOol0R7oo000aOol00`0OOomoo`1?Ool00`00Oomoo`28Ool0039oo`0301moogoo04io
o`03001oogoo08Qoo`00<goo00<07gooOol0CGoo00<007ooOol0R7oo000dOol00`0OOomoo`13Ool5
0004Ool00`00Oomoo`28Ool003Eoo`0301moogoo04Aoo`03001oogoo00Aoo`03001oogoo08Qoo`00
=Goo00<07gooOol0A7oo00<007ooOol017oo00<007ooOol0R7oo000fOol00`0OOomoo`13Ool00`00
Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001o
ogoo04Yoo`0301moogoo03]oo`00>7oo00<07gooOol0@Goo00<007ooOol017oo00<007ooOol0BGoo
00<07gooOol0?7oo000iOol00`0OOomoo`0nOol30006Ool00`00Oomoo`18Ool00`0OOomoo`0mOol0
03Yoo`0301moogoo03moo`03001oogoo00Aoo`03001oogoo04Ioo`807d1oo`00>goo00<07gooOol0
AGoo00<007ooOol0AGoo00<07gooOol0@7oo000lOol00`0OOomoo`14Ool00`00Oomoo`14Ool00`0O
Oomoo`11Ool003eoo`0301moogoo04=oo`03001oogoo04=oo`0301moogoo049oo`00?Woo0P0O@goo
0P00@Woo0P0OAGoo0010Ool00`0OOomoo`10Ool00`00Oomoo`10Ool00`0OOomoo`15Ool0045oo`03
01moogoo03moo`03001oogoo03moo`0301moogoo04Ioo`00@Woo0P0O?goo00<007ooOol0?Goo0P0O
BGoo0014Ool00`0OOomoo`0lOol00`00Oomoo`0lOol00`0OOomoo`19Ool004Eoo`0301moogoo03]o
o`03001oogoo03Yoo`807daoo`00AWoo0P0O>goo00<007ooOol0>Goo00<07gooOol0C7oo0018Ool2
01liOol2000hOol201m?Ool004Yoo`0301moogoo03Ioo`03001oogoo03Eoo`807e5oo`00Bgoo0P0O
=Woo00<007ooOol0=7oo00<07gooOol0DGoo001=Ool201ldOol00`00Oomoo`0bOol201mDOol004mo
o`807c9oo`03001oogoo031oo`807eIoo`00DGoo0P0O<7oo00<007ooOol0;Woo0P0OF7oo001COol2
01l^Ool00`00Oomoo`0/Ool201mJOol005Eoo`807baoo`03001oogoo02Yoo`807eaoo`00Egoo0P0O
:Woo0P00:Goo0P0OGWoo001IOol301lWOol00`00Oomoo`0VOol201mPOol005aoo`<07bAoo`03001o
ogoo02=oo`<07f9oo`00Ggoo0P0O8Woo00<007ooOol07goo100OIGoo001QOol301lOOol00`00Oomo
o`0KOol401mYOol006Aoo`@07a]oo`03001oogoo01Qoo`<07feoo`00J7oo1P0O5Goo00<007ooOol0
5Goo0`0OL7oo001^Ool601l?Ool00`00Oomoo`0?Ool601mcOol007Aoo`L07`Qoo`8000Qoo`P07gUo
o`00Ngoo4P0OPGoo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0
R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007oo
Ool00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03
001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00
Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo
00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020
Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool0
0?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo
3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.79639 .86657 L
.75389 .8972 L
.70758 .92324 L
.67979 .93577 L
.65385 .94559 L
.6302 .95307 L
.60412 .95976 L
.58964 .9628 L
.5762 .96521 L
.56338 .96712 L
.54955 .96879 L
.54274 .96946 L
.53625 .97001 L
.52994 .97045 L
.52407 .97079 L
.51853 .97104 L
.5157 .97114 L
.51263 .97124 L
.50926 .97131 L
.50608 .97137 L
.50298 .9714 L
.50014 .9714 L
.49698 .97139 L
.4936 .97136 L
.49041 .97131 L
.4875 .97124 L
.48409 .97114 L
.48038 .971 L
.47364 .97067 L
.4666 .97022 L
.45913 .96963 L
.44573 .96827 L
.42121 .96477 L
.39503 .95957 L
.37061 .9533 L
.34855 .94641 L
.30212 .92786 L
.2539 .90206 L
.21126 .87262 L
.16957 .83621 L
.13179 .79435 L
.10094 .75095 L
.07535 .70468 L
.05648 .65972 L
.04216 .61225 L
.03627 .58469 L
.03226 .55863 L
.0308 .54555 L
.03018 .53862 L
Mistroke
.02963 .53125 L
.02921 .52415 L
.02893 .51771 L
.02882 .5146 L
.02873 .51124 L
.02866 .50807 L
.02862 .50515 L
.0286 .50231 L
.0286 .49926 L
.02861 .49639 L
.02864 .49378 L
.02869 .4907 L
.02876 .48737 L
.02886 .48422 L
.02897 .48131 L
.02923 .47551 L
.02961 .46912 L
.03063 .45621 L
.03202 .44325 L
.03387 .42966 L
.03816 .40555 L
.04416 .37988 L
.05234 .35226 L
.0713 .30393 L
.09726 .25501 L
.12946 .20858 L
.16471 .16863 L
.20053 .13594 L
.24352 .10447 L
.2892 .07835 L
.31562 .06615 L
.34034 .05646 L
.36375 .04871 L
.38966 .04169 L
.41743 .03588 L
.43111 .03366 L
.44403 .03193 L
.45589 .03066 L
.46872 .02963 L
.47567 .02922 L
.47946 .02904 L
.483 .0289 L
.48627 .0288 L
.48925 .02872 L
.49256 .02865 L
.49439 .02863 L
.49611 .02861 L
.49931 .0286 L
.50113 .0286 L
.50283 .0286 L
Mistroke
.50626 .02864 L
.50819 .02867 L
.50995 .0287 L
.51309 .02878 L
.5165 .02888 L
.52272 .02914 L
.52997 .02955 L
.53767 .0301 L
.55151 .03142 L
.56558 .03318 L
.57847 .03517 L
.60731 .04097 L
.6324 .04757 L
.65845 .05602 L
.70632 .07614 L
.74874 .09956 L
.82956 .16294 L
.8673 .20452 L
.89824 .24776 L
.92388 .29374 L
.9429 .33856 L
.9558 .37971 L
.96144 .4036 L
.9656 .42626 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001kOolC01n0Ool0079oo`T07`Qoo`8000Uoo`H0
7gYoo`00KGoo1@0O4Goo00<007ooOol03Woo1@0OMGoo001XOol501lFOol00`00Oomoo`0COol501m`
Ool006Eoo`<07a]oo`03001oogoo01Qoo`<07feoo`00HWoo0`0O7Woo00<007ooOol06goo100OJGoo
001POol201lQOol00`00Oomoo`0OOol501mTOol005eoo`<07b=oo`03001oogoo02Aoo`807f9oo`00
FWoo0`0O9Woo00<007ooOol09Woo0P0OH7oo001HOol201lYOol2000YOol201mNOol005Ioo`807b]o
o`03001oogoo02Yoo`807eaoo`00E7oo0P0O;Goo00<007ooOol0;7oo0P0OFWoo001BOol201l_Ool0
0`00Oomoo`0^Ool201mHOol0051oo`807c5oo`03001oogoo031oo`807eIoo`00CWoo0P0O<goo00<0
07ooOol0<Woo00<07gooOol0Dgoo001<Ool201leOol00`00Oomoo`0cOol201mCOol004Yoo`807cMo
o`03001oogoo03Eoo`807e5oo`00B7oo0P0O>Goo0P00>7oo00<07gooOol0CWoo0017Ool00`0OOomo
o`0iOol00`00Oomoo`0hOol201m>Ool004Eoo`807caoo`03001oogoo03Yoo`0301moogoo04]oo`00
A7oo00<07gooOol0?7oo00<007ooOol0>goo00<07gooOol0BWoo0013Ool00`0OOomoo`0mOol00`00
Oomoo`0lOol201m:Ool0045oo`807d1oo`03001oogoo03ioo`0301moogoo04Moo`00@7oo00<07goo
Ool0@7oo00<007ooOol0?goo00<07gooOol0AWoo000nOol201m3Ool00`00Oomoo`10Ool201m6Ool0
03eoo`0301moogoo04=oo`8004=oo`0301moogoo04=oo`00?7oo00<07gooOol0A7oo00<007ooOol0
@goo00<07gooOol0@Woo000kOol00`0OOomoo`15Ool00`00Oomoo`14Ool201m2Ool003Yoo`0301mo
ogoo04Ioo`03001oogoo04Ioo`0301moogoo03moo`00>Goo00<07gooOol0?Woo1@0017oo00<007oo
Ool0Agoo00<07gooOol0?Woo000hOol00`0OOomoo`11Ool00`00Oomoo`04Ool00`00Oomoo`18Ool2
01lnOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo03]oo`00
=Woo00<07gooOol0>7oo1P001Goo00<007ooOol017oo0`00Bgoo00<07gooOol0>Woo000eOol00`0O
Oomoo`14Ool00`00Oomoo`04Ool00`00Oomoo`1<Ool00`0OOomoo`0iOol003Aoo`0301moogoo04Eo
o`03001oogoo00Aoo`03001oogoo04eoo`0301moogoo03Qoo`00<goo00<07gooOol0A7oo0`001Woo
00<007ooOol0CWoo00<07gooOol0=goo000bOol00`0OOomoo`17Ool00`00Oomoo`04Ool00`00Oomo
o`1?Ool00`0OOomoo`0fOol0035oo`0301moogoo04moo`03001oogoo04moo`0301moogoo03Ioo`00
<Goo00<07gooOol0Cgoo00<007ooOol0D7oo00<07gooOol0=Goo000`Ool00`0OOomoo`1@Ool00`00
Oomoo`1AOol00`0OOomoo`0dOol002moo`0301moogoo055oo`8005=oo`0301moogoo03=oo`00;Woo
00<07gooOol0DWoo00<007ooOol0Dgoo00<07gooOol0<Woo000]Ool00`0OOomoo`1COol00`00Oomo
o`1DOol00`0OOomoo`0aOol002aoo`0301moogoo05Aoo`03001oogoo05Aoo`0301moogoo035oo`00
;7oo00<07gooOol0E7oo00<007ooOol0EGoo00<07gooOol0<7oo000[Ool00`0OOomoo`1EOol00`00
Oomoo`1FOol00`0OOomoo`0_Ool002Yoo`0301moogoo05Ioo`03001oogoo05Moo`0301moogoo02io
o`00:Goo00<07gooOol0Egoo00<007ooOol0Egoo00<07gooOol0;Woo000YOol00`0OOomoo`1GOol2
001IOol00`0OOomoo`0]Ool002Qoo`0301moogoo05Qoo`03001oogoo05Uoo`0301moogoo02aoo`00
9goo00<07gooOol0FGoo00<007ooOol0FGoo00<07gooOol0;7oo000VOol00`0OOomoo`1JOol00`00
Oomoo`1JOol00`0OOomoo`0[Ool002Ioo`0301moogoo05Yoo`03001oogoo05]oo`0301moogoo02Yo
o`009Goo00<07gooOol0Fgoo00<007ooOol0Fgoo00<07gooOol0:Woo000TOol00`0OOomoo`1LOol0
0`00Oomoo`1LOol00`0OOomoo`0YOol002Aoo`0301moogoo05aoo`03001oogoo05aoo`0301moogoo
02Uoo`008goo00<07gooOol0GGoo0P00GWoo00<07gooOol0:7oo000SOol00`0OOomoo`1MOol00`00
Oomoo`1MOol00`0OOomoo`0XOol0029oo`0301moogoo05ioo`03001oogoo05ioo`0301moogoo02Mo
o`008Woo00<07gooOol0GWoo00<007ooOol0GWoo00<07gooOol09goo000QOol00`0OOomoo`1OOol0
0`00Oomoo`1OOol00`0OOomoo`0VOol0025oo`0301moogoo05moo`03001oogoo05moo`0301moogoo
02Ioo`0087oo00<07gooOol0H7oo00<007ooOol0H7oo00<07gooOol09Goo000POol00`0OOomoo`1P
Ool2001QOol00`0OOomoo`0UOol001moo`0301moogoo065oo`03001oogoo065oo`0301moogoo02Ao
o`007goo00<07gooOol0HGoo00<007ooOol0HGoo00<07gooOol097oo000NOol00`0OOomoo`1ROol0
0`00Oomoo`1ROol00`0OOomoo`0SOol001ioo`0301moogoo069oo`03001oogoo069oo`0301moogoo
02=oo`007Woo00<07gooOol0BGoo10001Goo0P001Goo10001Goo00<007ooOol0HWoo00<07gooOol0
8goo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`1SOol00`0OOomoo`0ROol001eoo`0301moogoo04Uoo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo06=oo`0301moogoo029oo`007Goo
00<07gooOol0@Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00I7oo
00<07gooOol08Goo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`1TOol00`0OOomoo`0QOol001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo
00Uoo`03001oogoo00Ioo`03001oogoo06Aoo`0301moogoo025oo`0077oo00<07gooOol0BWoo00<0
07ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0IGoo00<07gooOol087oo000K
Ool00`0OOomoo`1<Ool4000<Ool50004Ool00`00Oomoo`1UOol00`0OOomoo`0POol001]oo`0301mo
ogoo06Eoo`03001oogoo06Eoo`0301moogoo021oo`006goo00<07gooOol0IGoo00<007ooOol0IWoo
00<07gooOol07goo000JOol00`0OOomoo`1VOol00`00Oomoo`1VOol00`0OOomoo`0OOol001Yoo`03
01moogoo06Ioo`8006Moo`0301moogoo01moo`006Woo00<07gooOol0IWoo00<007ooOol0IWoo00<0
7gooOol07goo000IOol00`0OOomoo`1WOol00`00Oomoo`1WOol00`0OOomoo`0NOol001Uoo`0301mo
ogoo06Moo`03001oogoo06Moo`0301moogoo01ioo`006Goo00<07gooOol0Igoo00<007ooOol0Igoo
00<07gooOol07Woo000HOol00`0OOomoo`1XOol00`00Oomoo`1XOol00`0OOomoo`0MOol001Qoo`03
01moogoo06Qoo`03001oogoo06Qoo`0301moogoo01eoo`0067oo00<07gooOol0J7oo00<007ooOol0
J7oo00<07gooOol07Goo000GOol00`0OOomoo`1YOol2001ZOol00`0OOomoo`0LOol001Moo`0301mo
ogoo06Uoo`03001oogoo06Uoo`0301moogoo01aoo`005goo00<07gooOol0JGoo00<007ooOol0JGoo
00<07gooOol077oo000GOol00`0OOomoo`1YOol00`00Oomoo`1YOol00`0OOomoo`0LOol001Ioo`03
01moogoo06Yoo`03001oogoo06Yoo`0301moogoo01]oo`005Woo00<07gooOol0JWoo00<007ooOol0
JWoo00<07gooOol06goo000FOol00`0OOomoo`1ZOol00`00Oomoo`1ZOol00`0OOomoo`0KOol001Io
o`0301moogoo06Yoo`8008Uoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo0009Ool50004Ool2
0002Ool00`0OOomoo`04000JOol5000JOol40005Ool20005Ool4000IOol00`00Oomoo`0JOol40005
Ool20005Ool4000KOol5000JOol50004Ool20005Ool4000<Ool000]oo`03001oogoo00Aoo`80009o
o`0301moo`0000Aoo`03001oogoo01Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009o
o`8000Aoo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001o
ogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01Yoo`03001oogoo01aoo`03001oogoo00Ao
o`8000Aoo`03001oogoo009oo`03001oogoo00Uoo`002goo00<007ooOol027oo00<07gooOol017oo
00<007ooOol06Goo00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo
00<007ooOol06Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol06Woo00<007ooOol077oo
00<007ooOol03goo00<007ooOol02Goo00060005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00
Oomoo`0>Ool60005Ool00`00Oomoo`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00
Oomoo`0FOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00
Oomoo`0LOol00`00Oomoo`0?Ool00`00Oomoo`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@0
01aoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo00Uoo`@001eoo`03001oogoo01aoo`03001oogoo00]oo`@000aoo`00
2goo00<007ooOol027oo00@07gooOol001moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo
00Uoo`03001oogoo01Yoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
01ioo`03001oogoo01aoo`03001oogoo00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomo
o`0001eoo`<001]oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo01aoo`<001aoo`<000eoo`03001oogoo00eoo`002goo
00<007ooOol01goo00@07gooOomoo`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo
01Yoo`@000aoo`D001aoo`03001oogoo01aoo`03001oogoo00]oo`D000]oo`005Goo00<07gooOol0
Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]o
o`03001oogoo07]oo`80009oo`8000Moo`005Goo00<07gooOol0Jgoo00<007ooOol0O7oo00@007oo
Ool000Qoo`005Goo00<07gooOol0Jgoo00<007ooOol0OGoo0P002Goo000EOol00`0OOomoo`1[Ool0
0`00Oomoo`1mOol20009Ool000moo`H0000301l000000>4000Uoo`04001oogoo0008Ool000moo`03
001oogoo00=oo`0301l007oo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Ioo`80009oo`8000Moo`005Goo00<07gooOol0Jgoo00<007ooOol0R7oo000EOol00`0O
Oomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo06]oo`03001oogoo08Qoo`005Goo00<07goo
Ool0Jgoo00<007ooOol0R7oo000EOol00`0OOomoo`1[Ool00`00Oomoo`28Ool001Eoo`0301moogoo
06]oo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo0P00RGoo000FOol00`0OOomoo`1ZOol00`00
Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo08Qoo`005Woo00<07gooOol0JWoo00<007oo
Ool0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28Ool001Ioo`0301moogoo06Yoo`03001oogoo
08Qoo`005Woo00<07gooOol0JWoo00<007ooOol0R7oo000FOol00`0OOomoo`1ZOol00`00Oomoo`28
Ool001Ioo`0301moogoo06Yoo`8008Uoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol0
0`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<0
7gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301mo
ogoo06Uoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo0P00RGoo000HOol00`0OOomoo`1XOol0
0`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001oogoo08Qoo`0067oo00<07gooOol0J7oo00<0
07ooOol0R7oo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Uoo`0301moogoo06Moo`03001o
ogoo08Qoo`006Goo00<07gooOol0Igoo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomo
o`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`006Woo00<07gooOol0IWoo00<007ooOol0R7oo000K
Ool00`0OOomoo`1UOol00`00Oomoo`28Ool001]oo`0301moogoo06Eoo`03001oogoo08Qoo`006goo
00<07gooOol0IGoo00<007ooOol0R7oo000LOol00`0OOomoo`1;Ool40005Ool20005Ool40005Ool0
0`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03
001oogoo009oo`03001oogoo009oo`03001oogoo08Qoo`0077oo00<07gooOol0BWoo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0R7oo000MOol00`0OOomoo`19Ool00`00
Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool30028Ool001eoo`0301moogoo04Uoo`03001o
ogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo08Qoo`007Goo00<07gooOol0BGoo00<007oo
Ool00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0R7oo000NOol00`0OOomoo`18Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`28Ool001ioo`0301moogoo
04Uoo`@000aoo`D000Aoo`03001oogoo08Qoo`007goo00<07gooOol0HGoo00<007ooOol0R7oo000O
Ool00`0OOomoo`1QOol00`00Oomoo`28Ool001moo`0301moogoo065oo`03001oogoo08Qoo`0087oo
00<07gooOol0H7oo0P00RGoo000POol00`0OOomoo`1POol00`00Oomoo`28Ool0025oo`0301moogoo
05moo`03001oogoo08Qoo`008Goo00<07gooOol0Ggoo00<007ooOol0R7oo000ROol00`0OOomoo`1N
Ool00`00Oomoo`28Ool0029oo`0301moogoo05ioo`03001oogoo08Qoo`008goo00<07gooOol0GGoo
00<007ooOol0R7oo000SOol00`0OOomoo`1MOol20029Ool002Aoo`0301moogoo05aoo`03001oogoo
08Qoo`0097oo00<07gooOol0G7oo00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomoo`28
Ool002Eoo`0301moogoo05]oo`03001oogoo08Qoo`009Woo00<07gooOol0FWoo00<007ooOol0R7oo
000WOol00`0OOomoo`1IOol00`00Oomoo`28Ool002Moo`0301moogoo05Uoo`03001oogoo08Qoo`00
:7oo00<07gooOol0F7oo0P00RGoo000YOol00`0OOomoo`1GOol00`00Oomoo`28Ool002Yoo`0301mo
ogoo05Ioo`03001oogoo08Qoo`00:Woo00<07gooOol0EWoo00<007ooOol0R7oo000[Ool00`0OOomo
o`1EOol00`00Oomoo`28Ool002aoo`0301moogoo05Aoo`03001oogoo08Qoo`00;7oo00<07gooOol0
E7oo00<007ooOol0R7oo000]Ool00`0OOomoo`1COol00`00Oomoo`28Ool002ioo`0301moogoo059o
o`8008Uoo`00;goo00<07gooOol0DGoo00<007ooOol0R7oo000`Ool00`0OOomoo`1@Ool00`00Oomo
o`28Ool0035oo`0301moogoo04moo`03001oogoo08Qoo`00<Woo00<07gooOol0CWoo00<007ooOol0
R7oo000cOol00`0OOomoo`14Ool50004Ool00`00Oomoo`28Ool003Aoo`0301moogoo04Eoo`03001o
ogoo00Aoo`03001oogoo08Qoo`00=Goo00<07gooOol0A7oo00<007ooOol017oo00<007ooOol0R7oo
000fOol00`0OOomoo`13Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Moo`0301moogoo
049oo`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo03]oo`00>7oo00<07gooOol0@Goo00<0
07ooOol017oo00<007ooOol0B7oo0P0O?Woo000iOol00`0OOomoo`0nOol30006Ool00`00Oomoo`17
Ool00`0OOomoo`0nOol003Yoo`0301moogoo03moo`03001oogoo00Aoo`03001oogoo04Ioo`0301mo
ogoo03moo`00>goo0P0OAWoo00<007ooOol0A7oo0P0O@Woo000mOol00`0OOomoo`13Ool00`00Oomo
o`13Ool00`0OOomoo`12Ool003ioo`0301moogoo049oo`03001oogoo049oo`0301moogoo04=oo`00
?goo00<07gooOol0@Goo0P00@Woo00<07gooOol0A7oo0010Ool00`0OOomoo`10Ool00`00Oomoo`0o
Ool201m7Ool0045oo`807d1oo`03001oogoo03ioo`0301moogoo04Moo`00@goo00<07gooOol0?Goo
00<007ooOol0?Goo00<07gooOol0B7oo0014Ool00`0OOomoo`0lOol00`00Oomoo`0lOol00`0OOomo
o`19Ool004Eoo`807caoo`03001oogoo03Yoo`807daoo`00Agoo00<07gooOol0>Goo00<007ooOol0
>Goo00<07gooOol0C7oo0018Ool201liOol2000iOol00`0OOomoo`1=Ool004Yoo`0301moogoo03Io
o`03001oogoo03Ioo`807e1oo`00Bgoo0P0O=Woo00<007ooOol0=7oo0P0ODWoo001=Ool201ldOol0
0`00Oomoo`0bOol201mDOol004moo`807c9oo`03001oogoo031oo`807eIoo`00DGoo0P0O<7oo00<0
07ooOol0;Woo0P0OF7oo001COol201l^Ool00`00Oomoo`0]Ool00`0OOomoo`1HOol005Eoo`807bao
o`03001oogoo02]oo`807e]oo`00Egoo0`0O:Goo0P00:Woo0P0OGGoo001JOol201lWOol00`00Oomo
o`0VOol301mOOol005aoo`<07bAoo`03001oogoo02=oo`<07f9oo`00Ggoo0`0O8Goo00<007ooOol0
87oo0`0OIGoo001ROol201lOOol00`00Oomoo`0MOol301mXOol006Aoo`@07a]oo`03001oogoo01Uo
o`@07f]oo`00J7oo1P0O5Goo00<007ooOol057oo1@0OKgoo001^Ool601l?Ool00`00Oomoo`0>Ool6
01mdOol007Aoo`@07`]oo`8000Qoo`L07gYoo`00N7oo5@0OPGoo0023Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol50004Ool20005Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo
08Qoo`00K7oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0?
Ool00`00Oomoo`02Ool30028Ool006aoo`03001oogoo00]oo`@0091oo`00K7oo00<007ooOol02goo
00<007ooOol0TGoo001ZOol3000=Ool00`00Oomoo`2AOol006aoo`03001oogoo00]oo`D008moo`00
ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?
Ool0085oo`800003Ool0000008Qoo`00P7oo00<007ooOol00P00RGoo0020Ool01@00Oomoogoo0000
RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo001oOol20002Ool20029
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00
ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.79411 .8684 L
.7488 .9004 L
.69934 .92718 L
.66964 .93982 L
.64193 .94953 L
.61667 .95674 L
.58885 .96296 L
.57342 .96565 L
.5591 .96769 L
.54536 .96922 L
.53788 .96988 L
.53076 .9704 L
.52419 .97078 L
.52072 .97095 L
.51702 .9711 L
.5136 .97121 L
.51049 .97129 L
.50738 .97135 L
.50444 .97138 L
.50099 .9714 L
.49735 .9714 L
.49424 .97137 L
.49083 .97132 L
.48715 .97123 L
.48321 .97111 L
.47611 .9708 L
.46953 .97042 L
.46238 .9699 L
.4494 .96868 L
.43681 .96715 L
.42519 .96543 L
.39873 .9604 L
.37418 .9543 L
.31968 .93556 L
.26891 .91088 L
.22525 .88306 L
.18403 .84983 L
.14352 .80846 L
.1101 .76495 L
.08024 .71453 L
.06798 .68862 L
.05649 .65975 L
.04811 .63423 L
.04059 .60567 L
.03768 .59212 L
.03501 .57748 L
.03306 .56476 L
.03134 .55084 L
.03053 .54269 L
Mistroke
.02991 .53512 L
.02938 .52727 L
.0292 .52385 L
.02903 .52016 L
.02888 .5165 L
.02878 .51314 L
.0287 .50993 L
.02864 .50654 L
.0286 .50296 L
.0286 .49962 L
.02861 .49596 L
.02863 .49391 L
.02866 .49204 L
.02873 .48873 L
.02881 .48562 L
.02908 .47855 L
.02945 .47166 L
.02995 .46425 L
.03116 .45089 L
.0326 .43869 L
.03713 .41071 L
.04369 .38165 L
.05115 .35592 L
.06071 .32899 L
.08195 .28216 L
.1129 .23097 L
.1478 .18666 L
.18397 .15022 L
.22801 .11497 L
.27533 .08558 L
.30289 .07178 L
.32877 .06079 L
.35335 .05199 L
.38061 .04396 L
.40989 .03729 L
.42435 .03471 L
.438 .03269 L
.4516 .03109 L
.46412 .02996 L
.4709 .02949 L
.47805 .02911 L
.48152 .02896 L
.48523 .02883 L
.48736 .02876 L
.4893 .02872 L
.49111 .02868 L
.4931 .02865 L
.49676 .02861 L
.49876 .0286 L
.50064 .0286 L
Mistroke
.50399 .02861 L
.50759 .02866 L
.50961 .02869 L
.5118 .02874 L
.5158 .02886 L
.52331 .02917 L
.53047 .02958 L
.53809 .03014 L
.55177 .03145 L
.56666 .03333 L
.5803 .03548 L
.6108 .0418 L
.6373 .04903 L
.66477 .05833 L
.71507 .08051 L
.75938 .10637 L
.80497 .14054 L
.84266 .17626 L
.87978 .22074 L
.90902 .26564 L
.93236 .31215 L
.94227 .33684 L
.95137 .36402 L
.95875 .39151 L
.96405 .41704 L
.96778 .44169 L
.96917 .45415 L
.9703 .46781 L
.97071 .47445 L
.97089 .47794 L
.97105 .48165 L
.97116 .48489 L
.97126 .48845 L
.97133 .49169 L
.97137 .49472 L
.9714 .49788 L
.9714 .50088 L
.97139 .50358 L
.97136 .50651 L
.9713 .50969 L
.97122 .51308 L
.97101 .51917 L
.97067 .5263 L
.97018 .53399 L
.96897 .5479 L
.96739 .56139 L
.9656 .57374 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001jOolD01n0Ool007Aoo`H07`Uoo`8000Uoo`L0
7gUoo`00KGoo1`0O3goo00<007ooOol03goo1@0OM7oo001YOol401lFOol00`00Oomoo`0DOol501m_
Ool006Ioo`<07aYoo`03001oogoo01Uoo`<07faoo`00Hgoo0`0O7Goo00<007ooOol077oo0`0OJGoo
001POol301lPOol00`00Oomoo`0OOol401mUOol005eoo`<07b=oo`03001oogoo02=oo`<07f9oo`00
FWoo0`0O9Woo00<007ooOol09Woo0P0OH7oo001GOol301lYOol2000YOol201mNOol005Eoo`807bao
o`03001oogoo02Yoo`807eaoo`00Dgoo0P0O;Woo00<007ooOol0;7oo0P0OFWoo001AOol201l`Ool0
0`00Oomoo`0^Ool201mHOol004moo`807c9oo`03001oogoo031oo`807eIoo`00CGoo0P0O=7oo00<0
07ooOol0<Woo0P0OE7oo001<Ool00`0OOomoo`0dOol00`00Oomoo`0dOol201mBOol004Yoo`807cMo
o`03001oogoo03Ioo`807e1oo`00B7oo0P0O>Goo0P00>Goo0P0OCWoo0017Ool00`0OOomoo`0iOol0
0`00Oomoo`0jOol00`0OOomoo`1;Ool004Eoo`807caoo`03001oogoo03]oo`0301moogoo04Yoo`00
A7oo00<07gooOol0?7oo00<007ooOol0?7oo0P0OBWoo0012Ool201loOol00`00Oomoo`0nOol00`0O
Oomoo`17Ool0045oo`0301moogoo03moo`03001oogoo03moo`0301moogoo04Ioo`00@7oo00<07goo
Ool0@7oo00<007ooOol0@7oo00<07gooOol0AGoo000nOol201m3Ool00`00Oomoo`11Ool201m5Ool0
03eoo`0301moogoo04=oo`8004Aoo`0301moogoo049oo`00?7oo00<07gooOol0A7oo00<007ooOol0
A7oo00<07gooOol0@Goo000jOol201m7Ool00`00Oomoo`15Ool00`0OOomoo`10Ool003Uoo`0301mo
ogoo04Moo`03001oogoo04Ioo`0301moogoo03moo`00>7oo00<07gooOol0?goo1@0017oo00<007oo
Ool0Agoo00<07gooOol0?Woo000gOol00`0OOomoo`12Ool00`00Oomoo`04Ool00`00Oomoo`18Ool0
0`0OOomoo`0mOol003Ioo`0301moogoo04=oo`03001oogoo00Aoo`03001oogoo04Uoo`0301moogoo
03aoo`00=Goo00<07gooOol0>Goo1P001Goo00<007ooOol017oo0`00BWoo00<07gooOol0>goo000e
Ool00`0OOomoo`14Ool00`00Oomoo`04Ool00`00Oomoo`1;Ool00`0OOomoo`0jOol003Aoo`0301mo
ogoo04Eoo`03001oogoo00Aoo`03001oogoo04aoo`0301moogoo03Uoo`00<goo00<07gooOol0A7oo
0`001Woo00<007ooOol0CGoo00<07gooOol0>7oo000bOol00`0OOomoo`17Ool00`00Oomoo`04Ool0
0`00Oomoo`1>Ool00`0OOomoo`0gOol0035oo`0301moogoo04moo`03001oogoo04moo`0301moogoo
03Ioo`00<7oo00<07gooOol0D7oo00<007ooOol0D7oo00<07gooOol0=Goo000_Ool00`0OOomoo`1A
Ool00`00Oomoo`1AOol00`0OOomoo`0dOol002moo`0301moogoo055oo`8005=oo`0301moogoo03=o
o`00;Woo00<07gooOol0DWoo00<007ooOol0DWoo00<07gooOol0<goo000]Ool00`0OOomoo`1COol0
0`00Oomoo`1COol00`0OOomoo`0bOol002aoo`0301moogoo05Aoo`03001oogoo05Aoo`0301moogoo
035oo`00:goo00<07gooOol0EGoo00<007ooOol0EGoo00<07gooOol0<7oo000[Ool00`0OOomoo`1E
Ool00`00Oomoo`1FOol00`0OOomoo`0_Ool002Yoo`0301moogoo05Ioo`03001oogoo05Moo`0301mo
ogoo02ioo`00:Goo00<07gooOol0Egoo00<007ooOol0Egoo00<07gooOol0;Woo000XOol00`0OOomo
o`1HOol2001IOol00`0OOomoo`0]Ool002Qoo`0301moogoo05Qoo`03001oogoo05Qoo`0301moogoo
02eoo`009goo00<07gooOol0FGoo00<007ooOol0FGoo00<07gooOol0;7oo000WOol00`0OOomoo`1I
Ool00`00Oomoo`1JOol00`0OOomoo`0[Ool002Ioo`0301moogoo05Yoo`03001oogoo05Yoo`0301mo
ogoo02]oo`009Goo00<07gooOol0Fgoo00<007ooOol0Fgoo00<07gooOol0:Woo000UOol00`0OOomo
o`1KOol00`00Oomoo`1KOol00`0OOomoo`0ZOol002Aoo`0301moogoo05aoo`03001oogoo05aoo`03
01moogoo02Uoo`0097oo00<07gooOol0G7oo0P00GWoo00<07gooOol0:7oo000SOol00`0OOomoo`1M
Ool00`00Oomoo`1MOol00`0OOomoo`0XOol002=oo`0301moogoo05eoo`03001oogoo05ioo`0301mo
ogoo02Moo`008Woo00<07gooOol0GWoo00<007ooOol0GWoo00<07gooOol09goo000ROol00`0OOomo
o`1NOol00`00Oomoo`1OOol00`0OOomoo`0VOol0025oo`0301moogoo05moo`03001oogoo05moo`03
01moogoo02Ioo`008Goo00<07gooOol0Ggoo00<007ooOol0H7oo00<07gooOol09Goo000POol00`0O
Oomoo`1POol2001QOol00`0OOomoo`0UOol0021oo`0301moogoo061oo`03001oogoo065oo`0301mo
ogoo02Aoo`007goo00<07gooOol0HGoo00<007ooOol0HGoo00<07gooOol097oo000OOol00`0OOomo
o`1QOol00`00Oomoo`1ROol00`0OOomoo`0SOol001ioo`0301moogoo069oo`03001oogoo069oo`03
01moogoo02=oo`007Woo00<07gooOol0BGoo10001Goo0P001Goo10001Goo00<007ooOol0Hgoo00<0
7gooOol08Woo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1SOol00`0OOomoo`0ROol001eoo`0301moogoo04Uo
o`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo06=oo`0301moogoo029o
o`0077oo00<07gooOol0@Woo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo
0`00I7oo00<07gooOol08Goo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool4
0005Ool00`00Oomoo`1TOol00`0OOomoo`0QOol001]oo`0301moogoo04]oo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo06Aoo`0301moogoo025oo`006goo00<07gooOol0
Bgoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0IGoo00<07gooOol0
87oo000JOol00`0OOomoo`1=Ool4000<Ool50004Ool00`00Oomoo`1UOol00`0OOomoo`0POol001Yo
o`0301moogoo06Ioo`03001oogoo06Eoo`0301moogoo021oo`006Woo00<07gooOol0IWoo00<007oo
Ool0IWoo00<07gooOol07goo000JOol00`0OOomoo`1VOol00`00Oomoo`1VOol00`0OOomoo`0OOol0
01Uoo`0301moogoo06Moo`8006Moo`0301moogoo01moo`006Goo00<07gooOol0Igoo00<007ooOol0
Igoo00<07gooOol07Woo000IOol00`0OOomoo`1WOol00`00Oomoo`1WOol00`0OOomoo`0NOol001Uo
o`0301moogoo06Moo`03001oogoo06Moo`0301moogoo01ioo`006Goo00<07gooOol0Igoo00<007oo
Ool0Igoo00<07gooOol07Woo000HOol00`0OOomoo`1XOol00`00Oomoo`1XOol00`0OOomoo`0MOol0
01Qoo`0301moogoo06Qoo`03001oogoo06Qoo`0301moogoo01eoo`0067oo00<07gooOol0J7oo00<0
07ooOol0J7oo00<07gooOol07Goo000HOol00`0OOomoo`1XOol2001YOol00`0OOomoo`0MOol001Mo
o`0301moogoo06Uoo`03001oogoo06Uoo`0301moogoo01aoo`005goo00<07gooOol0JGoo00<007oo
Ool0JGoo00<07gooOol077oo000GOol00`0OOomoo`1YOol00`00Oomoo`1YOol00`0OOomoo`0LOol0
01Moo`0301moogoo06Uoo`03001oogoo06Uoo`0301moogoo01aoo`005goo00<07gooOol0JGoo00<0
07ooOol0JGoo00<07gooOol077oo000FOol00`0OOomoo`1ZOol00`00Oomoo`1YOol00`0OOomoo`0L
Ool001Ioo`0301moogoo06Yoo`8006]oo`0301moogoo01]oo`005Woo00<07gooOol0JWoo00<007oo
Ool0JWoo00<07gooOol06goo0009Ool50004Ool20002Ool00`0OOomoo`04000JOol5000JOol40005
Ool20005Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol200000`0O0000
0004Ool20005Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001oogoo
01Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03
001oogoo01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo
009oo`03001oogoo01Yoo`03001oogoo01aoo`0301moogoo00Aoo`8000Aoo`03001oogoo009oo`03
001oogoo00Uoo`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007ooOol0
6Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol06Woo00<007ooOol077oo00<07gooOol03goo00<007ooOol0
2Goo00060005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00Oomo
o`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0IOol0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`0OOomoo`0?Ool0
0`00Oomoo`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03001o
ogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uo
o`@001eoo`03001oogoo01aoo`0301moogoo00]oo`@000aoo`002goo00<007ooOol01goo00D07goo
Oomoo`0001moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03
001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`03
00007goo00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uo
o`03001oogoo01aoo`<001aoo`<0000301moogoo00Yoo`03001oogoo00eoo`002goo00<007ooOol0
1goo00@07gooOomoo`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000ao
o`D001aoo`03001oogoo01aoo`0300007goo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007oo
Ool0Jgoo00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0JOol0
01Eoo`0301moogoo06]oo`03001oogoo06]oo`0301moogoo00eoo`80009oo`8000Moo`005Goo00<0
7gooOol0Jgoo00<007ooOol0Jgoo00<07gooOol03Woo00@007ooOol000Qoo`005Goo00<07gooOol0
Jgoo00<007ooOol0Jgoo00<07gooOol03goo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[
Ool00`0OOomoo`0?Ool20009Ool000moo`H0000301l000000=T0000301l0000000D000Uoo`04001o
ogoo0008Ool000moo`03001oogoo00=oo`0301l007oo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`0300007goo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`005Goo00<07gooOol0Jgoo00<007oo
Ool0Jgoo00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0JOol0
01Eoo`0301moogoo06]oo`03001oogoo06]oo`0301moogoo01Yoo`005Goo00<07gooOol0Jgoo00<0
07ooOol0Jgoo00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0J
Ool001Eoo`0301moogoo06]oo`03001oogoo06]oo`0301moogoo01Yoo`005Goo00<07gooOol0Jgoo
0P00K7oo00<07gooOol06Woo000FOol00`0OOomoo`1ZOol00`00Oomoo`1[Ool00`0OOomoo`0JOol0
01Ioo`0301moogoo06Yoo`03001oogoo06Yoo`0301moogoo01]oo`005Woo00<07gooOol0JWoo00<0
07ooOol0JWoo00<07gooOol06goo000FOol00`0OOomoo`1ZOol00`00Oomoo`1ZOol00`0OOomoo`0K
Ool001Ioo`0301moogoo06Yoo`03001oogoo06Yoo`0301moogoo01]oo`005Woo00<07gooOol0JWoo
00<007ooOol0JWoo00<07gooOol06goo000FOol00`0OOomoo`1ZOol00`00Oomoo`1ZOol00`0OOomo
o`0KOol001Ioo`0301moogoo06Yoo`8006]oo`0301moogoo01]oo`005goo00<07gooOol0JGoo00<0
07ooOol0JWoo00<07gooOol06goo000GOol00`0OOomoo`1YOol00`00Oomoo`28Ool001Moo`0301mo
ogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0JGoo00<007ooOol0R7oo000GOol00`0OOomo
o`1YOol00`00Oomoo`28Ool001Moo`0301moogoo06Uoo`03001oogoo08Qoo`005goo00<07gooOol0
JGoo0P00RGoo000HOol00`0OOomoo`1XOol00`00Oomoo`28Ool001Qoo`0301moogoo06Qoo`03001o
ogoo08Qoo`0067oo00<07gooOol0J7oo00<007ooOol0R7oo000IOol00`0OOomoo`1WOol00`00Oomo
o`28Ool001Uoo`0301moogoo06Moo`03001oogoo08Qoo`006Goo00<07gooOol0Igoo00<007ooOol0
R7oo000JOol00`0OOomoo`1VOol00`00Oomoo`28Ool001Yoo`0301moogoo06Ioo`8008Uoo`006Woo
00<07gooOol0IWoo00<007ooOol0R7oo000KOol00`0OOomoo`1UOol00`00Oomoo`28Ool001]oo`03
01moogoo06Eoo`03001oogoo08Qoo`006goo00<07gooOol0IGoo00<007ooOol0R7oo000LOol00`0O
Oomoo`1;Ool40005Ool20005Ool40005Ool00`00Oomoo`28Ool001aoo`0301moogoo04Yoo`03001o
ogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08Qo
o`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo00<007oo
Ool0R7oo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool3
0028Ool001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo
08Qoo`007Goo00<07gooOol0BGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<0
07ooOol0R7oo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06
Ool00`00Oomoo`28Ool001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03001oogoo08Qoo`007Woo
00<07gooOol0HWoo00<007ooOol0R7oo000OOol00`0OOomoo`1QOol00`00Oomoo`28Ool001moo`03
01moogoo065oo`03001oogoo08Qoo`0087oo00<07gooOol0H7oo0P00RGoo000POol00`0OOomoo`1P
Ool00`00Oomoo`28Ool0025oo`0301moogoo05moo`03001oogoo08Qoo`008Goo00<07gooOol0Ggoo
00<007ooOol0R7oo000ROol00`0OOomoo`1NOol00`00Oomoo`28Ool0029oo`0301moogoo05ioo`03
001oogoo08Qoo`008goo00<07gooOol0GGoo00<007ooOol0R7oo000SOol00`0OOomoo`1MOol20029
Ool002Aoo`0301moogoo05aoo`03001oogoo08Qoo`009Goo00<07gooOol0Fgoo00<007ooOol0R7oo
000UOol00`0OOomoo`1KOol00`00Oomoo`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`00
9Woo00<07gooOol0FWoo00<007ooOol0R7oo000WOol00`0OOomoo`1IOol00`00Oomoo`28Ool002Mo
o`0301moogoo05Uoo`03001oogoo08Qoo`00:7oo00<07gooOol0F7oo0P00RGoo000YOol00`0OOomo
o`1GOol00`00Oomoo`28Ool002Yoo`0301moogoo05Ioo`03001oogoo08Qoo`00:Woo00<07gooOol0
EWoo00<007ooOol0R7oo000[Ool00`0OOomoo`1EOol00`00Oomoo`28Ool002aoo`0301moogoo05Ao
o`03001oogoo08Qoo`00;Goo00<07gooOol0Dgoo00<007ooOol0R7oo000^Ool00`0OOomoo`1BOol0
0`00Oomoo`28Ool002ioo`0301moogoo059oo`8008Uoo`00;goo00<07gooOol0DGoo00<007ooOol0
R7oo000`Ool00`0OOomoo`1@Ool00`00Oomoo`28Ool0035oo`0301moogoo04moo`03001oogoo08Qo
o`00<Woo00<07gooOol0CWoo00<007ooOol0R7oo000cOol00`0OOomoo`14Ool50004Ool00`00Oomo
o`28Ool003Aoo`0301moogoo04Eoo`03001oogoo00Aoo`03001oogoo08Qoo`00=Goo00<07gooOol0
A7oo00<007ooOol017oo00<007ooOol0R7oo000eOol00`0OOomoo`14Ool00`00Oomoo`04Ool3001;
Ool00`0OOomoo`0jOol003Ioo`0301moogoo04=oo`03001oogoo00Aoo`03001oogoo04Yoo`0301mo
ogoo03]oo`00=goo00<07gooOol0@Woo00<007ooOol017oo00<007ooOol0BGoo00<07gooOol0?7oo
000hOol00`0OOomoo`0oOol30006Ool00`00Oomoo`18Ool00`0OOomoo`0mOol003Uoo`0301moogoo
041oo`03001oogoo00Aoo`03001oogoo04Ioo`807d1oo`00>Woo0P0OAgoo00<007ooOol0AGoo00<0
7gooOol0@7oo000lOol00`0OOomoo`14Ool00`00Oomoo`14Ool00`0OOomoo`11Ool003eoo`0301mo
ogoo04=oo`03001oogoo04=oo`0301moogoo049oo`00?Woo0P0O@goo0P00@goo00<07gooOol0@goo
0010Ool00`0OOomoo`10Ool00`00Oomoo`10Ool201m6Ool0045oo`807d1oo`03001oogoo03moo`03
01moogoo04Ioo`00@goo00<07gooOol0?Goo00<007ooOol0?Goo0P0OBGoo0014Ool201lmOol00`00
Oomoo`0kOol201m;Ool004Ioo`0301moogoo03Yoo`03001oogoo03Yoo`0301moogoo04]oo`00Agoo
00<07gooOol0>Goo00<007ooOol0>7oo0P0OCWoo0018Ool201liOol2000hOol00`0OOomoo`1>Ool0
04Yoo`0301moogoo03Ioo`03001oogoo03Eoo`807e5oo`00Bgoo0P0O=Woo00<007ooOol0=7oo00<0
7gooOol0DGoo001=Ool00`0OOomoo`0cOol00`00Oomoo`0bOol201mDOol004ioo`807c=oo`03001o
ogoo031oo`807eIoo`00D7oo0P0O<Goo00<007ooOol0;goo00<07gooOol0EWoo001BOol201l_Ool0
0`00Oomoo`0]Ool201mIOol005Aoo`807beoo`03001oogoo02]oo`807e]oo`00EWoo0P0O:goo0P00
:Woo0P0OGGoo001HOol301lXOol00`00Oomoo`0WOol201mOOol005]oo`<07bEoo`03001oogoo02Ao
o`<07f5oo`00GWoo100O8Goo00<007ooOol087oo100OI7oo001ROol301lNOol00`00Oomoo`0MOol3
01mXOol006Eoo`@07aYoo`03001oogoo01Yoo`<07f]oo`00JGoo100O5Woo00<007ooOol05Woo100O
KWoo001]Ool401lBOol00`00Oomoo`0AOol501mbOol0075oo`P07`Yoo`8000Uoo`T07gMoo`00NGoo
5@0OP7oo0023Ool00`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001Z
Ool50004Ool20005Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007ooOol00Woo
00<007ooOol0R7oo001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03001oogoo
00]oo`@0091oo`00K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00Oomoo`2A
Ool006aoo`03001oogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003o
Ool?Ool00?moo`moo`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo00<007oo
Ool00P00RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00
Oomoogoo0000RGoo001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000
\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.79182 .87022 L
.74368 .90354 L
.69102 .93097 L
.65976 .94351 L
.6299 .95315 L
.59983 .96071 L
.58489 .9637 L
.57101 .96603 L
.55861 .96775 L
.5449 .96926 L
.53107 .97038 L
.5235 .97082 L
.51639 .97112 L
.51272 .97123 L
.5107 .97128 L
.50879 .97132 L
.50509 .97138 L
.50173 .9714 L
.49979 .9714 L
.49773 .9714 L
.49405 .97137 L
.492 .97134 L
.49008 .9713 L
.48573 .97119 L
.48195 .97106 L
.47838 .97091 L
.47168 .97055 L
.46447 .97006 L
.45664 .96941 L
.44293 .96794 L
.42843 .96594 L
.40255 .96122 L
.37565 .95471 L
.34713 .94593 L
.29716 .92553 L
.24545 .89677 L
.19535 .85974 L
.15329 .81939 L
.1189 .77746 L
.08655 .72645 L
.06303 .67685 L
.05345 .65105 L
.04497 .62316 L
.03767 .59204 L
.03491 .57689 L
.03282 .56297 L
.03113 .54877 L
.02992 .53525 L
.02942 .52783 L
Mistroke
.02906 .52095 L
.0289 .51698 L
.02879 .51338 L
.02873 .51139 L
.02869 .50924 L
.02863 .50533 L
.0286 .50194 L
.0286 .49879 L
.02862 .49532 L
.02867 .49161 L
.02876 .48772 L
.02887 .48404 L
.02915 .47714 L
.02951 .4707 L
.02992 .46475 L
.03112 .45131 L
.03273 .43767 L
.03492 .42305 L
.04003 .39681 L
.04803 .36604 L
.05716 .3384 L
.07944 .28704 L
.11055 .23438 L
.14613 .18855 L
.18998 .14488 L
.24022 .10663 L
.29187 .07703 L
.31809 .06511 L
.34654 .05427 L
.37377 .04581 L
.39903 .03954 L
.4265 .03436 L
.44174 .03221 L
.45625 .03063 L
.46275 .03007 L
.46967 .02957 L
.47566 .02922 L
.48212 .02893 L
.48572 .02881 L
.48903 .02872 L
.49219 .02866 L
.49552 .02862 L
.49918 .0286 L
.50259 .0286 L
.50634 .02864 L
.50843 .02867 L
.51033 .02871 L
.51385 .0288 L
.51714 .02891 L
.52462 .02924 L
Mistroke
.53191 .02968 L
.53973 .03027 L
.55385 .03168 L
.56672 .03334 L
.59773 .03884 L
.62679 .04597 L
.68207 .06517 L
.73087 .089 L
.78172 .12204 L
.82379 .15739 L
.8627 .19888 L
.8988 .24865 L
.92704 .30035 L
.93889 .32796 L
.94961 .35832 L
.9578 .38757 L
.96361 .41463 L
.96584 .42778 L
.96784 .44214 L
.96932 .45575 L
.97034 .46837 L
.97077 .4755 L
.97106 .48205 L
.97118 .48549 L
.97128 .48924 L
.97132 .49114 L
.97135 .49317 L
.97139 .49681 L
.9714 .50027 L
.97139 .50402 L
.97134 .50755 L
.97128 .51081 L
.9712 .51376 L
.9711 .51699 L
.97082 .52352 L
.97036 .53144 L
.96982 .53866 L
.9682 .55487 L
.9662 .56983 L
.96387 .58396 L
.95796 .61177 L
.94985 .64091 L
.93065 .69174 L
.92002 .71401 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001jOolD01n0Ool0075oo`T07`Uoo`8000Uoo`T0
7gMoo`00KWoo0`0O4Woo00<007ooOol04Goo1@0OLWoo001ZOol401lEOol00`00Oomoo`0FOol401m^
Ool006Eoo`D07aUoo`03001oogoo01Yoo`<07f]oo`00HGoo100O7Woo00<007ooOol07Goo0P0OJGoo
001OOol201lROol00`00Oomoo`0OOol301mVOol005eoo`807bAoo`03001oogoo029oo`<07f=oo`00
Fgoo0P0O9Woo00<007ooOol09Goo0P0OHGoo001HOol301lXOol2000XOol301mNOol005Eoo`<07b]o
o`03001oogoo02Yoo`807eaoo`00Dgoo0P0O;Woo00<007ooOol0;7oo0P0OFWoo001AOol201l`Ool0
0`00Oomoo`0^Ool201mHOol004moo`807c9oo`03001oogoo031oo`807eIoo`00CWoo00<07gooOol0
<Woo00<007ooOol0<Woo0P0OE7oo001<Ool201leOol00`00Oomoo`0dOol201mBOol004Yoo`807cMo
o`03001oogoo03Ioo`0301moogoo04moo`00B7oo0P0O>Goo0P00>7oo0P0OCgoo0017Ool00`0OOomo
o`0iOol00`00Oomoo`0iOol00`0OOomoo`1<Ool004Ioo`0301moogoo03Yoo`03001oogoo03Yoo`80
7daoo`00A7oo0P0O?Goo00<007ooOol0?7oo00<07gooOol0BGoo0013Ool00`0OOomoo`0mOol00`00
Oomoo`0mOol201m9Ool0049oo`0301moogoo03ioo`03001oogoo03moo`0301moogoo04Ioo`00@7oo
0P0O@Goo00<007ooOol0@7oo00<07gooOol0AGoo000oOol00`0OOomoo`11Ool00`00Oomoo`11Ool2
01m5Ool003ioo`0301moogoo049oo`8004Aoo`0301moogoo049oo`00?7oo0P0OAGoo00<007ooOol0
A7oo00<07gooOol0@Goo000kOol00`0OOomoo`15Ool00`00Oomoo`15Ool00`0OOomoo`10Ool003Yo
o`0301moogoo04Ioo`03001oogoo04Ioo`807d1oo`00>Goo00<07gooOol0?Woo1@0017oo00<007oo
Ool0B7oo00<07gooOol0?Goo000hOol00`0OOomoo`11Ool00`00Oomoo`04Ool00`00Oomoo`19Ool0
0`0OOomoo`0lOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo
03]oo`00=Woo00<07gooOol0>7oo1P001Goo00<007ooOol017oo0`00Bgoo00<07gooOol0>Woo000e
Ool00`0OOomoo`14Ool00`00Oomoo`04Ool00`00Oomoo`1<Ool00`0OOomoo`0iOol003Aoo`0301mo
ogoo04Eoo`03001oogoo00Aoo`03001oogoo04eoo`0301moogoo03Qoo`00<goo00<07gooOol0A7oo
0`001Woo00<007ooOol0CWoo00<07gooOol0=goo000bOol00`0OOomoo`17Ool00`00Oomoo`04Ool0
0`00Oomoo`1>Ool00`0OOomoo`0gOol0035oo`0301moogoo04moo`03001oogoo04moo`0301moogoo
03Ioo`00<7oo00<07gooOol0D7oo00<007ooOol0D7oo00<07gooOol0=Goo000_Ool00`0OOomoo`1A
Ool00`00Oomoo`1AOol00`0OOomoo`0dOol002moo`0301moogoo055oo`8005=oo`0301moogoo03=o
o`00;Woo00<07gooOol0DWoo00<007ooOol0Dgoo00<07gooOol0<Woo000]Ool00`0OOomoo`1COol0
0`00Oomoo`1COol00`0OOomoo`0bOol002aoo`0301moogoo05Aoo`03001oogoo05Aoo`0301moogoo
035oo`00:goo00<07gooOol0EGoo00<007ooOol0EGoo00<07gooOol0<7oo000ZOol00`0OOomoo`1F
Ool00`00Oomoo`1FOol00`0OOomoo`0_Ool002Yoo`0301moogoo05Ioo`03001oogoo05Ioo`0301mo
ogoo02moo`00:Goo00<07gooOol0Egoo00<007ooOol0Egoo00<07gooOol0;Woo000XOol00`0OOomo
o`1HOol2001IOol00`0OOomoo`0]Ool002Moo`0301moogoo05Uoo`03001oogoo05Uoo`0301moogoo
02aoo`009goo00<07gooOol0FGoo00<007ooOol0FGoo00<07gooOol0;7oo000VOol00`0OOomoo`1J
Ool00`00Oomoo`1JOol00`0OOomoo`0[Ool002Ioo`0301moogoo05Yoo`03001oogoo05]oo`0301mo
ogoo02Yoo`009Goo00<07gooOol0Fgoo00<007ooOol0Fgoo00<07gooOol0:Woo000TOol00`0OOomo
o`1LOol00`00Oomoo`1LOol00`0OOomoo`0YOol002Aoo`0301moogoo05aoo`03001oogoo05aoo`03
01moogoo02Uoo`008goo00<07gooOol0GGoo0P00GWoo00<07gooOol0:7oo000SOol00`0OOomoo`1M
Ool00`00Oomoo`1NOol00`0OOomoo`0WOol0029oo`0301moogoo05ioo`03001oogoo05ioo`0301mo
ogoo02Moo`008Woo00<07gooOol0GWoo00<007ooOol0Ggoo00<07gooOol09Woo000QOol00`0OOomo
o`1OOol00`00Oomoo`1OOol00`0OOomoo`0VOol0025oo`0301moogoo05moo`03001oogoo061oo`03
01moogoo02Eoo`0087oo00<07gooOol0H7oo00<007ooOol0H7oo00<07gooOol09Goo000POol00`0O
Oomoo`1POol2001ROol00`0OOomoo`0TOol001moo`0301moogoo065oo`03001oogoo065oo`0301mo
ogoo02Aoo`007goo00<07gooOol0HGoo00<007ooOol0HWoo00<07gooOol08goo000NOol00`0OOomo
o`1ROol00`00Oomoo`1ROol00`0OOomoo`0SOol001ioo`0301moogoo069oo`03001oogoo069oo`03
01moogoo02=oo`007Woo00<07gooOol0BGoo10001Goo0P001Goo10001Goo00<007ooOol0HWoo00<0
7gooOol08goo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1SOol00`0OOomoo`0ROol001eoo`0301moogoo04Uo
o`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo06=oo`0301moogoo029o
o`0077oo00<07gooOol0@Woo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo
0`00Hgoo00<07gooOol08Woo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool4
0005Ool00`00Oomoo`1TOol00`0OOomoo`0QOol001aoo`0301moogoo04Yoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo06Aoo`0301moogoo025oo`006goo00<07gooOol0
Bgoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0IGoo00<07gooOol0
87oo000KOol00`0OOomoo`1<Ool4000<Ool50004Ool00`00Oomoo`1UOol00`0OOomoo`0POol001]o
o`0301moogoo06Eoo`03001oogoo06Ioo`0301moogoo01moo`006goo00<07gooOol0IGoo00<007oo
Ool0IWoo00<07gooOol07goo000JOol00`0OOomoo`1VOol00`00Oomoo`1VOol00`0OOomoo`0OOol0
01Yoo`0301moogoo06Ioo`8006Qoo`0301moogoo01ioo`006Woo00<07gooOol0IWoo00<007ooOol0
Igoo00<07gooOol07Woo000IOol00`0OOomoo`1WOol00`00Oomoo`1WOol00`0OOomoo`0NOol001Uo
o`0301moogoo06Moo`03001oogoo06Moo`0301moogoo01ioo`006Goo00<07gooOol0Igoo00<007oo
Ool0J7oo00<07gooOol07Goo000IOol00`0OOomoo`1WOol00`00Oomoo`1XOol00`0OOomoo`0MOol0
01Qoo`0301moogoo06Qoo`03001oogoo06Qoo`0301moogoo01eoo`0067oo00<07gooOol0J7oo00<0
07ooOol0J7oo00<07gooOol07Goo000HOol00`0OOomoo`1XOol2001ZOol00`0OOomoo`0LOol001Qo
o`0301moogoo06Qoo`03001oogoo06Uoo`0301moogoo01aoo`005goo00<07gooOol0JGoo00<007oo
Ool0JGoo00<07gooOol077oo000GOol00`0OOomoo`1YOol00`00Oomoo`1YOol00`0OOomoo`0LOol0
01Moo`0301moogoo06Uoo`03001oogoo06Uoo`0301moogoo01aoo`005goo00<07gooOol0JGoo00<0
07ooOol0JWoo00<07gooOol06goo000GOol00`0OOomoo`1YOol00`00Oomoo`1ZOol00`0OOomoo`0K
Ool001Ioo`0301moogoo06Yoo`8006]oo`0301moogoo01]oo`005Woo00<07gooOol0JWoo00<007oo
Ool0JWoo00<07gooOol06goo0009Ool50004Ool20002Ool00`0OOomoo`04000JOol5000JOol40005
Ool20005Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol200000`0O0000
0004Ool20005Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001oogoo
01Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03
001oogoo01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo
009oo`03001oogoo01Yoo`03001oogoo01aoo`0301moogoo00Aoo`8000Aoo`03001oogoo009oo`03
001oogoo00Uoo`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007ooOol0
6Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol06Woo00<007ooOol077oo00<07gooOol03goo00<007ooOol0
2Goo00060005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00Oomo
o`0AOol60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0IOol0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`0001moo`0?Ool0
0`00Oomoo`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03001o
ogoo009oo`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uo
o`@001eoo`03001oogoo01aoo`0300007goo00]oo`@000aoo`002goo00<007ooOol01goo00D07goo
Oomoo`0001moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03
001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`03
00007goo00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uo
o`03001oogoo01aoo`<001aoo`<0000301moogoo00Yoo`03001oogoo00eoo`002goo00<007ooOol0
1goo00@07gooOomoo`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000ao
o`D001aoo`03001oogoo01aoo`0300007goo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007oo
Ool0Jgoo00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0JOol0
01Eoo`0301moogoo06]oo`03001oogoo06]oo`0301moogoo00eoo`80009oo`8000Moo`005Goo00<0
7gooOol0Jgoo00<007ooOol0Jgoo00<07gooOol03Woo00@007ooOol000Qoo`005Goo00<07gooOol0
Jgoo00<007ooOol0Jgoo00<07gooOol03goo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[
Ool00`0OOomoo`0?Ool20009Ool000moo`H0000301l000000=T0000301l0000000D000Uoo`04001o
ogoo0008Ool000moo`03001oogoo00=oo`0301l007oo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`0300007goo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`005Goo00<07gooOol0Jgoo00<007oo
Ool0Jgoo00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0JOol0
01Eoo`0301moogoo06]oo`03001oogoo06]oo`0301moogoo01Yoo`005Goo00<07gooOol0Jgoo00<0
07ooOol0Jgoo00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0J
Ool001Eoo`0301moogoo06]oo`03001oogoo06]oo`0301moogoo01Yoo`005Goo00<07gooOol0Jgoo
0P00K7oo00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0JOol0
01Ioo`0301moogoo06Yoo`03001oogoo06]oo`0301moogoo01Yoo`005Woo00<07gooOol0JWoo00<0
07ooOol0JWoo00<07gooOol06goo000FOol00`0OOomoo`1ZOol00`00Oomoo`1ZOol00`0OOomoo`0K
Ool001Ioo`0301moogoo06Yoo`03001oogoo06Yoo`0301moogoo01]oo`005Woo00<07gooOol0JWoo
00<007ooOol0JWoo00<07gooOol06goo000FOol00`0OOomoo`1ZOol00`00Oomoo`1ZOol00`0OOomo
o`0KOol001Ioo`0301moogoo06Yoo`8006]oo`0301moogoo01]oo`005goo00<07gooOol0JGoo00<0
07ooOol0JWoo00<07gooOol06goo000GOol00`0OOomoo`1YOol00`00Oomoo`1YOol00`0OOomoo`0L
Ool001Moo`0301moogoo06Uoo`03001oogoo06Uoo`0301moogoo01aoo`005goo00<07gooOol0JGoo
00<007ooOol0JGoo00<07gooOol077oo000GOol00`0OOomoo`1YOol00`00Oomoo`1YOol00`0OOomo
o`0LOol001Moo`0301moogoo06Uoo`03001oogoo06Uoo`0301moogoo01aoo`0067oo00<07gooOol0
J7oo0P00JGoo00<07gooOol07Goo000HOol00`0OOomoo`1XOol00`00Oomoo`1XOol00`0OOomoo`0M
Ool001Qoo`0301moogoo06Qoo`03001oogoo06Qoo`0301moogoo01eoo`0067oo00<07gooOol0J7oo
00<007ooOol0J7oo00<07gooOol07Goo000IOol00`0OOomoo`1WOol00`00Oomoo`1XOol00`0OOomo
o`0MOol001Uoo`0301moogoo06Moo`03001oogoo06Moo`0301moogoo01ioo`006Goo00<07gooOol0
Igoo00<007ooOol0Igoo00<07gooOol07Woo000IOol00`0OOomoo`1WOol00`00Oomoo`1WOol00`0O
Oomoo`0NOol001Yoo`0301moogoo06Ioo`8006Qoo`0301moogoo01ioo`006Woo00<07gooOol0IWoo
00<007ooOol0IWoo00<07gooOol07goo000JOol00`0OOomoo`1VOol00`00Oomoo`1VOol00`0OOomo
o`0OOol001]oo`0301moogoo06Eoo`03001oogoo06Ioo`0301moogoo01moo`006goo00<07gooOol0
IGoo00<007ooOol0IGoo00<07gooOol087oo000KOol00`0OOomoo`1<Ool40005Ool20005Ool40005
Ool00`00Oomoo`1UOol00`0OOomoo`0POol001aoo`0301moogoo04Yoo`03001oogoo009oo`03001o
ogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo06Eoo`0301moogoo021o
o`0077oo00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo00<007oo
Ool0I7oo00<07gooOol08Goo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool3001TOol00`0OOomoo`0QOol001eoo`0301moogoo04Uoo`03001oogoo009oo`03
001oogoo00Uoo`@000Eoo`03001oogoo06Aoo`0301moogoo025oo`007Goo00<07gooOol0BGoo00<0
07ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0Hgoo00<07gooOol08Woo000N
Ool00`0OOomoo`18Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`1S
Ool00`0OOomoo`0ROol001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03001oogoo06=oo`0301mo
ogoo029oo`007goo00<07gooOol0HGoo00<007ooOol0HWoo00<07gooOol08goo000OOol00`0OOomo
o`1QOol00`00Oomoo`1ROol00`0OOomoo`0SOol0021oo`0301moogoo061oo`03001oogoo065oo`03
01moogoo02Aoo`0087oo00<07gooOol0H7oo0P00HWoo00<07gooOol097oo000QOol00`0OOomoo`1O
Ool00`00Oomoo`1POol00`0OOomoo`0UOol0025oo`0301moogoo05moo`03001oogoo061oo`0301mo
ogoo02Eoo`008Woo00<07gooOol0GWoo00<007ooOol0Ggoo00<07gooOol09Woo000ROol00`0OOomo
o`1NOol00`00Oomoo`28Ool002=oo`0301moogoo05eoo`03001oogoo08Qoo`008goo00<07gooOol0
GGoo00<007ooOol0R7oo000TOol00`0OOomoo`1LOol20029Ool002Aoo`0301moogoo05aoo`03001o
ogoo08Qoo`009Goo00<07gooOol0Fgoo00<007ooOol0R7oo000UOol00`0OOomoo`1KOol00`00Oomo
o`28Ool002Ioo`0301moogoo05Yoo`03001oogoo08Qoo`009goo00<07gooOol0FGoo00<007ooOol0
R7oo000WOol00`0OOomoo`1IOol00`00Oomoo`28Ool002Qoo`0301moogoo05Qoo`03001oogoo08Qo
o`00:7oo00<07gooOol0F7oo0P00RGoo000YOol00`0OOomoo`1GOol00`00Oomoo`28Ool002Uoo`03
01moogoo05Moo`03001oogoo08Qoo`00:Woo00<07gooOol0EWoo00<007ooOol0R7oo000[Ool00`0O
Oomoo`1EOol00`00Oomoo`28Ool002aoo`0301moogoo05Aoo`03001oogoo08Qoo`00;Goo00<07goo
Ool0Dgoo00<007ooOol0R7oo000^Ool00`0OOomoo`1BOol00`00Oomoo`28Ool002ioo`0301moogoo
059oo`8008Uoo`00;goo00<07gooOol0DGoo00<007ooOol0R7oo000`Ool00`0OOomoo`1@Ool00`00
Oomoo`28Ool0035oo`0301moogoo04moo`03001oogoo08Qoo`00<Woo00<07gooOol0CWoo00<007oo
Ool0R7oo000cOol00`0OOomoo`14Ool50004Ool00`00Oomoo`28Ool003Aoo`0301moogoo04Eoo`03
001oogoo00Aoo`03001oogoo08Qoo`00=Goo00<07gooOol0A7oo00<007ooOol017oo00<007ooOol0
R7oo000fOol00`0OOomoo`13Ool00`00Oomoo`04Ool3001;Ool00`0OOomoo`0jOol003Moo`0301mo
ogoo049oo`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo03]oo`00>7oo00<07gooOol0@Goo
00<007ooOol017oo00<007ooOol0B7oo0P0O?Woo000iOol00`0OOomoo`0nOol30006Ool00`00Oomo
o`17Ool00`0OOomoo`0nOol003Yoo`0301moogoo03moo`03001oogoo00Aoo`03001oogoo04Ioo`03
01moogoo03moo`00>goo00<07gooOol0AGoo00<007ooOol0AGoo00<07gooOol0@7oo000lOol00`0O
Oomoo`14Ool00`00Oomoo`13Ool201m3Ool003eoo`0301moogoo04=oo`03001oogoo049oo`0301mo
ogoo04=oo`00?Woo0P0O@goo0P00@Woo00<07gooOol0A7oo0010Ool00`0OOomoo`10Ool00`00Oomo
o`0oOol201m7Ool0045oo`0301moogoo03moo`03001oogoo03ioo`0301moogoo04Moo`00@Woo0P0O
?goo00<007ooOol0?Goo00<07gooOol0B7oo0014Ool00`0OOomoo`0lOol00`00Oomoo`0kOol201m;
Ool004Eoo`0301moogoo03]oo`03001oogoo03Yoo`0301moogoo04]oo`00AWoo0P0O>goo00<007oo
Ool0>Goo00<07gooOol0C7oo0018Ool00`0OOomoo`0hOol2000hOol201m?Ool004Uoo`807cQoo`03
001oogoo03Ioo`0301moogoo04moo`00Bgoo0P0O=Woo00<007ooOol0=7oo0P0ODWoo001=Ool201ld
Ool00`00Oomoo`0bOol201mDOol004moo`807c9oo`03001oogoo035oo`0301moogoo05Aoo`00DGoo
0P0O<7oo00<007ooOol0;goo0P0OEgoo001COol301l]Ool00`00Oomoo`0]Ool201mIOol005Ioo`80
7b]oo`03001oogoo02]oo`807e]oo`00F7oo0P0O:Goo0P00:Woo0P0OGGoo001JOol201lWOol00`00
Oomoo`0UOol401mOOol005aoo`807bEoo`03001oogoo025oo`@07f=oo`00GWoo0`0O8Woo00<007oo
Ool07goo0P0OIgoo001QOol401lNOol00`00Oomoo`0MOol201mYOol006Eoo`<07a]oo`03001oogoo
01Qoo`D07f]oo`00J7oo0`0O67oo00<007ooOol04goo1@0OL7oo001[Ool401lDOol00`00Oomoo`0@
Ool301meOol006moo`/07`Uoo`8000Qoo`T07gQoo`00NWoo4`0OPGoo0023Ool00`00Oomoo`28Ool0
08=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol50004Ool20005Ool40005Ool00`00
Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo08Qoo`00K7oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0R7oo001/Ool00`00Oomo
o`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03001oogoo00]oo`@0091oo`00K7oo00<007ooOol0
2goo00<007ooOol0TGoo001ZOol3000=Ool00`00Oomoo`2AOol006aoo`03001oogoo00]oo`D008mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003o
Ool?Ool0085oo`800003Ool0000008Qoo`00P7oo00<007ooOol00P00RGoo0020Ool01@00Oomoogoo
0000RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo001oOol20002Ool2
0029Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[0 .4875 -12 -9 ]
[0 .4875 12 0 ]
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[1 .4875 -9 -9 ]
[1 .4875 9 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[.4875 1 -18 -4.5 ]
[.4875 1 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .5 m
0 .50625 L
s
[(-1.5)] 0 .4875 0 1 Mshowa
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
1 .5 m
1 .50625 L
s
[(1.5)] 1 .4875 0 1 Mshowa
.125 Mabswid
.03333 .5 m
.03333 .50375 L
s
.06667 .5 m
.06667 .50375 L
s
.1 .5 m
.1 .50375 L
s
.13333 .5 m
.13333 .50375 L
s
.2 .5 m
.2 .50375 L
s
.23333 .5 m
.23333 .50375 L
s
.26667 .5 m
.26667 .50375 L
s
.3 .5 m
.3 .50375 L
s
.36667 .5 m
.36667 .50375 L
s
.4 .5 m
.4 .50375 L
s
.43333 .5 m
.43333 .50375 L
s
.46667 .5 m
.46667 .50375 L
s
.53333 .5 m
.53333 .50375 L
s
.56667 .5 m
.56667 .50375 L
s
.6 .5 m
.6 .50375 L
s
.63333 .5 m
.63333 .50375 L
s
.7 .5 m
.7 .50375 L
s
.73333 .5 m
.73333 .50375 L
s
.76667 .5 m
.76667 .50375 L
s
.8 .5 m
.8 .50375 L
s
.86667 .5 m
.86667 .50375 L
s
.9 .5 m
.9 .50375 L
s
.93333 .5 m
.93333 .50375 L
s
.96667 .5 m
.96667 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 1 m
.50625 1 L
s
[(1.5)] .4875 1 1 0 Mshowa
.125 Mabswid
.5 .03333 m
.50375 .03333 L
s
.5 .06667 m
.50375 .06667 L
s
.5 .1 m
.50375 .1 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .2 m
.50375 .2 L
s
.5 .23333 m
.50375 .23333 L
s
.5 .26667 m
.50375 .26667 L
s
.5 .3 m
.50375 .3 L
s
.5 .36667 m
.50375 .36667 L
s
.5 .4 m
.50375 .4 L
s
.5 .43333 m
.50375 .43333 L
s
.5 .46667 m
.50375 .46667 L
s
.5 .53333 m
.50375 .53333 L
s
.5 .56667 m
.50375 .56667 L
s
.5 .6 m
.50375 .6 L
s
.5 .63333 m
.50375 .63333 L
s
.5 .7 m
.50375 .7 L
s
.5 .73333 m
.50375 .73333 L
s
.5 .76667 m
.50375 .76667 L
s
.5 .8 m
.50375 .8 L
s
.5 .86667 m
.50375 .86667 L
s
.5 .9 m
.50375 .9 L
s
.5 .93333 m
.50375 .93333 L
s
.5 .96667 m
.50375 .96667 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.83333 .83333 m
.78952 .87203 L
.73852 .90661 L
.68264 .93459 L
.64946 .94708 L
.61778 .95645 L
.60256 .96011 L
.58592 .96351 L
.57115 .966 L
.55542 .96814 L
.5412 .9696 L
.5331 .97024 L
.52549 .97071 L
.52192 .97089 L
.51853 .97104 L
.51544 .97115 L
.51215 .97125 L
.50858 .97133 L
.50527 .97138 L
.50134 .9714 L
.49777 .9714 L
.49404 .97137 L
.49055 .97131 L
.48672 .97122 L
.48262 .97108 L
.47425 .9707 L
.46663 .97022 L
.45195 .96895 L
.4381 .96732 L
.40751 .96224 L
.39039 .95848 L
.37469 .95444 L
.31982 .93561 L
.28975 .92192 L
.26246 .90718 L
.21051 .87204 L
.16735 .83402 L
.12835 .79 L
.09233 .7367 L
.0652 .68212 L
.05316 .65019 L
.04425 .62048 L
.03731 .59023 L
.03269 .56199 L
.03096 .54713 L
.03018 .53856 L
.0296 .53073 L
.02913 .52246 L
.02894 .5179 L
.02879 .51356 L
Mistroke
.02869 .50957 L
.02863 .50587 L
.0286 .50181 L
.0286 .49954 L
.0286 .49749 L
.02864 .49373 L
.0287 .49023 L
.02879 .48639 L
.02893 .48228 L
.02932 .47389 L
.0298 .46626 L
.03109 .45156 L
.03273 .43769 L
.03785 .40707 L
.04162 .38995 L
.04567 .37426 L
.0646 .3193 L
.07835 .28921 L
.09313 .26193 L
.12841 .20993 L
.16653 .16681 L
.21071 .1278 L
.26411 .09186 L
.31885 .06479 L
.35086 .05281 L
.38058 .04397 L
.41093 .03709 L
.43922 .03253 L
.45411 .03083 L
.46269 .03007 L
.47053 .02952 L
.47881 .02907 L
.48338 .02889 L
.48771 .02876 L
.4917 .02867 L
.4954 .02862 L
.49946 .0286 L
.50151 .0286 L
.50377 .02861 L
.50754 .02866 L
.51106 .02873 L
.51491 .02883 L
.51903 .02898 L
.52744 .02939 L
.53508 .0299 L
.5498 .03123 L
.56367 .03292 L
.59433 .03813 L
.61145 .04196 L
.62711 .04606 L
Mistroke
.68212 .0652 L
.71221 .07906 L
.73944 .09393 L
.79142 .12946 L
.83443 .16777 L
.87334 .21218 L
.90909 .26577 L
.93599 .32073 L
.94784 .35282 L
.95655 .38259 L
.96009 .39735 L
.96332 .41305 L
.96567 .4267 L
.96775 .44139 L
.96871 .4497 L
.96946 .45728 L
.9701 .46499 L
.97058 .47214 L
.971 .48047 L
.97116 .48486 L
.97123 .48711 L
.97129 .48953 L
.97136 .49357 L
.9714 .49736 L
.9714 .49956 L
.9714 .50187 L
.97139 .50385 L
.97137 .50601 L
.9713 .51012 L
.9712 .5139 L
.97106 .51806 L
.97087 .52246 L
.97046 .52984 L
.96987 .53795 L
.96843 .55289 L
.96665 .56682 L
.96116 .59776 L
.95298 .63049 L
.94325 .66048 L
.93038 .69234 L
.90116 .74757 L
.8708 .79109 L
.83333 .83333 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 216},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00JWoo1@0017oo0P001Goo1000T7oo001/Ool00`00Oomoo`04Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool006aoo`03001oogoo00moo`03001oogoo08eoo`00HGoo1P001Goo
00<007ooOol03goo00<007ooOol00Woo0`00R7oo001/Ool00`00Oomoo`0;Ool40005Ool00`00Oomo
o`28Ool006aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo08Qoo`00JWoo0`003Goo00<0
07ooOol01Woo00<007ooOol0R7oo001/Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`28Ool008=o
o`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001jOolC01n1Ool0079oo`P07`Uoo`8000Qoo`T0
7gQoo`00KGoo1@0O4Goo00<007ooOol047oo1@0OLgoo001YOol401lFOol00`00Oomoo`0EOol401m_
Ool006Ioo`<07aYoo`03001oogoo01Uoo`@07f]oo`00HWoo100O7Goo00<007ooOol07Goo0P0OJGoo
001OOol301lQOol00`00Oomoo`0OOol301mVOol005eoo`807bAoo`03001oogoo029oo`<07f=oo`00
Fgoo0P0O9Woo00<007ooOol09Goo0P0OHGoo001HOol301lXOol2000XOol301mNOol005Ioo`807b]o
o`03001oogoo02Yoo`807eaoo`00E7oo0P0O;Goo00<007ooOol0;7oo0P0OFWoo001BOol201l_Ool0
0`00Oomoo`0^Ool201mHOol0051oo`807c5oo`03001oogoo031oo`807eIoo`00CWoo0P0O<goo00<0
07ooOol0<Woo0P0OE7oo001<Ool201leOol00`00Oomoo`0dOol201mBOol004Yoo`807cMoo`03001o
ogoo03Ioo`0301moogoo04moo`00BGoo00<07gooOol0=goo0P00>7oo0P0OCgoo0017Ool201ljOol0
0`00Oomoo`0iOol00`0OOomoo`1<Ool004Ioo`0301moogoo03Yoo`03001oogoo03Yoo`0301moogoo
04]oo`00A7oo0P0O?Goo00<007ooOol0>goo0P0OBgoo0013Ool00`0OOomoo`0mOol00`00Oomoo`0m
Ool00`0OOomoo`18Ool0045oo`807d1oo`03001oogoo03ioo`0301moogoo04Moo`00@7oo00<07goo
Ool0@7oo00<007ooOol0?goo0P0OAgoo000oOol00`0OOomoo`11Ool00`00Oomoo`11Ool00`0OOomo
o`14Ool003eoo`807dAoo`8004=oo`0301moogoo04=oo`00?7oo00<07gooOol0A7oo00<007ooOol0
@goo00<07gooOol0@Woo000kOol00`0OOomoo`15Ool00`00Oomoo`14Ool00`0OOomoo`11Ool003Yo
o`0301moogoo04Ioo`03001oogoo04Eoo`0301moogoo041oo`00>Goo00<07gooOol0?Woo1@0017oo
00<007ooOol0AWoo0P0O@7oo000gOol201m3Ool00`00Oomoo`04Ool00`00Oomoo`18Ool00`0OOomo
o`0mOol003Ioo`0301moogoo04=oo`03001oogoo00Aoo`03001oogoo04Uoo`0301moogoo03aoo`00
=Goo00<07gooOol0>Goo1P001Goo00<007ooOol017oo0`00BWoo00<07gooOol0>goo000dOol00`0O
Oomoo`15Ool00`00Oomoo`04Ool00`00Oomoo`1;Ool00`0OOomoo`0jOol003=oo`0301moogoo04Io
o`03001oogoo00Aoo`03001oogoo04aoo`0301moogoo03Uoo`00<Woo00<07gooOol0AGoo0`001Woo
00<007ooOol0CGoo00<07gooOol0>7oo000aOol00`0OOomoo`18Ool00`00Oomoo`04Ool00`00Oomo
o`1>Ool00`0OOomoo`0gOol0031oo`0301moogoo051oo`03001oogoo04moo`0301moogoo03Ioo`00
<7oo00<07gooOol0D7oo00<007ooOol0D7oo00<07gooOol0=Goo000_Ool00`0OOomoo`1AOol00`00
Oomoo`1@Ool00`0OOomoo`0eOol002ioo`0301moogoo059oo`80059oo`0301moogoo03Aoo`00;Goo
00<07gooOol0Dgoo00<007ooOol0DWoo00<07gooOol0<goo000/Ool00`0OOomoo`1DOol00`00Oomo
o`1COol00`0OOomoo`0bOol002]oo`0301moogoo05Eoo`03001oogoo05Aoo`0301moogoo035oo`00
:goo00<07gooOol0EGoo00<007ooOol0EGoo00<07gooOol0<7oo000ZOol00`0OOomoo`1FOol00`00
Oomoo`1EOol00`0OOomoo`0`Ool002Yoo`0301moogoo05Ioo`03001oogoo05Ioo`0301moogoo02mo
o`00:Goo00<07gooOol0Egoo00<007ooOol0Egoo00<07gooOol0;Woo000XOol00`0OOomoo`1HOol2
001HOol00`0OOomoo`0^Ool002Qoo`0301moogoo05Qoo`03001oogoo05Qoo`0301moogoo02eoo`00
9goo00<07gooOol0FGoo00<007ooOol0FGoo00<07gooOol0;7oo000VOol00`0OOomoo`1JOol00`00
Oomoo`1IOol00`0OOomoo`0/Ool002Ioo`0301moogoo05Yoo`03001oogoo05Yoo`0301moogoo02]o
o`009Goo00<07gooOol0Fgoo00<007ooOol0Fgoo00<07gooOol0:Woo000UOol00`0OOomoo`1KOol0
0`00Oomoo`1KOol00`0OOomoo`0ZOol002Aoo`0301moogoo05aoo`03001oogoo05aoo`0301moogoo
02Uoo`008goo00<07gooOol0GGoo0P00GWoo00<07gooOol0:7oo000SOol00`0OOomoo`1MOol00`00
Oomoo`1MOol00`0OOomoo`0XOol0029oo`0301moogoo05ioo`03001oogoo05ioo`0301moogoo02Mo
o`008Woo00<07gooOol0GWoo00<007ooOol0GWoo00<07gooOol09goo000QOol00`0OOomoo`1OOol0
0`00Oomoo`1OOol00`0OOomoo`0VOol0025oo`0301moogoo05moo`03001oogoo05moo`0301moogoo
02Ioo`008Goo00<07gooOol0Ggoo00<007ooOol0H7oo00<07gooOol09Goo000POol00`0OOomoo`1P
Ool2001QOol00`0OOomoo`0UOol0021oo`0301moogoo061oo`03001oogoo065oo`0301moogoo02Ao
o`007goo00<07gooOol0HGoo00<007ooOol0HGoo00<07gooOol097oo000OOol00`0OOomoo`1QOol0
0`00Oomoo`1ROol00`0OOomoo`0SOol001ioo`0301moogoo069oo`03001oogoo069oo`0301moogoo
02=oo`007Woo00<07gooOol0BGoo10001Goo0P001Goo10001Goo00<007ooOol0Hgoo00<07gooOol0
8Woo000NOol00`0OOomoo`18Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`1SOol00`0OOomoo`0ROol001eoo`0301moogoo04Uoo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo06Aoo`0301moogoo025oo`007Goo
00<07gooOol0@Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0`00I7oo
00<07gooOol08Goo000LOol00`0OOomoo`1:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`1UOol00`0OOomoo`0POol001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo
00Uoo`03001oogoo00Ioo`03001oogoo06Eoo`0301moogoo021oo`0077oo00<07gooOol0BWoo00<0
07ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0IGoo00<07gooOol087oo000K
Ool00`0OOomoo`1<Ool4000<Ool50004Ool00`00Oomoo`1VOol00`0OOomoo`0OOol001]oo`0301mo
ogoo06Eoo`03001oogoo06Ioo`0301moogoo01moo`006goo00<07gooOol0IGoo00<007ooOol0IWoo
00<07gooOol07goo000JOol00`0OOomoo`1VOol00`00Oomoo`1WOol00`0OOomoo`0NOol001Yoo`03
01moogoo06Ioo`8006Qoo`0301moogoo01ioo`006Goo00<07gooOol0Igoo00<007ooOol0Igoo00<0
7gooOol07Woo000IOol00`0OOomoo`1WOol00`00Oomoo`1WOol00`0OOomoo`0NOol001Uoo`0301mo
ogoo06Moo`03001oogoo06Qoo`0301moogoo01eoo`0067oo00<07gooOol0J7oo00<007ooOol0J7oo
00<07gooOol07Goo000HOol00`0OOomoo`1XOol00`00Oomoo`1XOol00`0OOomoo`0MOol001Qoo`03
01moogoo06Qoo`03001oogoo06Qoo`0301moogoo01eoo`005goo00<07gooOol0JGoo00<007ooOol0
J7oo00<07gooOol07Goo000GOol00`0OOomoo`1YOol2001YOol00`0OOomoo`0MOol001Moo`0301mo
ogoo06Uoo`03001oogoo06Uoo`0301moogoo01aoo`005goo00<07gooOol0JGoo00<007ooOol0JGoo
00<07gooOol077oo000GOol00`0OOomoo`1YOol00`00Oomoo`1YOol00`0OOomoo`0LOol001Moo`03
01moogoo06Uoo`03001oogoo06Uoo`0301moogoo01aoo`005Woo00<07gooOol0JWoo00<007ooOol0
JWoo00<07gooOol06goo000FOol00`0OOomoo`1ZOol00`00Oomoo`1ZOol00`0OOomoo`0KOol001Io
o`0301moogoo06Yoo`8006]oo`0301moogoo01]oo`005Woo00<07gooOol0JWoo00<007ooOol0JWoo
00<07gooOol06goo0009Ool50004Ool20002Ool00`0OOomoo`04000JOol5000JOol40005Ool20005
Ool4000IOol00`00Oomoo`0JOol40005Ool20005Ool4000KOol5000JOol200000`0O00000004Ool2
0005Ool4000<Ool000]oo`03001oogoo00Aoo`80009oo`0301moo`0000Aoo`03001oogoo01Uoo`03
001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo
01Ioo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03
001oogoo01Yoo`03001oogoo01aoo`0301moogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo
00Uoo`002goo00<007ooOol027oo00<07gooOol017oo00<007ooOol06Goo00<007ooOol06Goo00<0
07ooOol00Woo00<007ooOol03Goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol00Woo00<0
07ooOol03Goo00<007ooOol06Woo00<007ooOol077oo00<07gooOol03goo00<007ooOol02Goo0006
0005Ool00`00Oomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0>Ool60005Ool00`00Oomoo`0AOol6
0002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0FOol00`00Oomoo`0IOol00`00Oomo
o`02Ool00`00Oomoo`0=Ool00`00Oomoo`0JOol00`00Oomoo`0LOol00`0001moo`0?Ool00`00Oomo
o`09Ool000]oo`03001oogoo00Qoo`0301moogoo00@001aoo`03001oogoo01Uoo`03001oogoo009o
o`03001oogoo00Uoo`@001Uoo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@001eo
o`03001oogoo01aoo`0300007goo00]oo`@000aoo`002goo00<007ooOol01goo00D07gooOomoo`00
01moo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Yoo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01ioo`03001oogoo01aoo`0300007goo
00]oo`03001oogoo00eoo`002Goo0`002Goo00D07gooOomoo`0001eoo`<001]oo`03001oogoo009o
o`03001oogoo00Uoo`03001oogoo01Yoo`8001Yoo`03001oogoo009oo`03001oogoo00Uoo`03001o
ogoo01aoo`<001aoo`<0000301moogoo00Yoo`03001oogoo00eoo`002goo00<007ooOol01goo00@0
7gooOomoo`D001]oo`03001oogoo01Yoo`@000aoo`D001Qoo`03001oogoo01Yoo`@000aoo`D001ao
o`03001oogoo01aoo`0300007goo00]oo`D000]oo`005Goo00<07gooOol0Jgoo00<007ooOol0Jgoo
00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0JOol001Eoo`03
01moogoo06]oo`03001oogoo06]oo`0301moogoo00eoo`80009oo`8000Moo`005Goo00<07gooOol0
Jgoo00<007ooOol0Jgoo00<07gooOol03Woo00@007ooOol000Qoo`005Goo00<07gooOol0Jgoo00<0
07ooOol0Jgoo00<07gooOol03goo0P002Goo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0O
Oomoo`0?Ool20009Ool000moo`H0000301l000000=T0000301l0000000D000Uoo`04001oogoo0008
Ool000moo`03001oogoo00=oo`0301l007oo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`030000
7goo00Eoo`03001oogoo00Ioo`80009oo`8000Moo`005Goo00<07gooOol0Jgoo00<007ooOol0Jgoo
00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0JOol001Eoo`03
01moogoo06]oo`03001oogoo06]oo`0301moogoo01Yoo`005Goo00<07gooOol0Jgoo00<007ooOol0
Jgoo00<07gooOol06Woo000EOol00`0OOomoo`1[Ool00`00Oomoo`1[Ool00`0OOomoo`0JOol001Eo
o`0301moogoo06]oo`03001oogoo06]oo`0301moogoo01Yoo`005Woo00<07gooOol0JWoo0P00K7oo
00<07gooOol06Woo000FOol00`0OOomoo`1ZOol00`00Oomoo`1[Ool00`0OOomoo`0JOol001Ioo`03
01moogoo06Yoo`03001oogoo06]oo`0301moogoo01Yoo`005Woo00<07gooOol0JWoo00<007ooOol0
JWoo00<07gooOol06goo000FOol00`0OOomoo`1ZOol00`00Oomoo`1ZOol00`0OOomoo`0KOol001Io
o`0301moogoo06Yoo`03001oogoo06Yoo`0301moogoo01]oo`005Woo00<07gooOol0JWoo00<007oo
Ool0JWoo00<07gooOol06goo000FOol00`0OOomoo`1ZOol00`00Oomoo`1ZOol00`0OOomoo`0KOol0
01Ioo`0301moogoo06Yoo`8006]oo`0301moogoo01]oo`005Woo00<07gooOol0JWoo00<007ooOol0
JWoo00<07gooOol06goo000GOol00`0OOomoo`1YOol00`00Oomoo`1ZOol00`0OOomoo`0KOol001Mo
o`0301moogoo06Uoo`03001oogoo06Yoo`0301moogoo01]oo`005goo00<07gooOol0JGoo00<007oo
Ool0JGoo00<07gooOol077oo000GOol00`0OOomoo`1YOol00`00Oomoo`1YOol00`0OOomoo`0LOol0
01Moo`0301moogoo06Uoo`03001oogoo06Uoo`0301moogoo01aoo`0067oo00<07gooOol0J7oo0P00
JWoo00<07gooOol077oo000HOol00`0OOomoo`1XOol00`00Oomoo`1YOol00`0OOomoo`0LOol001Qo
o`0301moogoo06Qoo`03001oogoo06Qoo`0301moogoo01eoo`0067oo00<07gooOol0J7oo00<007oo
Ool0J7oo00<07gooOol07Goo000IOol00`0OOomoo`1WOol00`00Oomoo`1XOol00`0OOomoo`0MOol0
01Uoo`0301moogoo06Moo`03001oogoo06Qoo`0301moogoo01eoo`006Goo00<07gooOol0Igoo00<0
07ooOol0Igoo00<07gooOol07Woo000JOol00`0OOomoo`1VOol00`00Oomoo`1WOol00`0OOomoo`0N
Ool001Yoo`0301moogoo06Ioo`8006Qoo`0301moogoo01ioo`006Woo00<07gooOol0IWoo00<007oo
Ool0IWoo00<07gooOol07goo000JOol00`0OOomoo`1VOol00`00Oomoo`1VOol00`0OOomoo`0OOol0
01]oo`0301moogoo06Eoo`03001oogoo06Eoo`0301moogoo021oo`006goo00<07gooOol0IGoo00<0
07ooOol0IGoo00<07gooOol087oo000KOol00`0OOomoo`1<Ool40005Ool20005Ool40005Ool00`00
Oomoo`1TOol00`0OOomoo`0QOol001aoo`0301moogoo04Yoo`03001oogoo009oo`03001oogoo009o
o`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo06Aoo`0301moogoo025oo`0077oo
00<07gooOol0BWoo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0I7oo
00<07gooOol08Goo000MOol00`0OOomoo`19Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool3001SOol00`0OOomoo`0ROol001eoo`0301moogoo04Uoo`03001oogoo009oo`03001oogoo
00Uoo`@000Eoo`03001oogoo06=oo`0301moogoo029oo`007Woo00<07gooOol0B7oo00<007ooOol0
0Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0HWoo00<07gooOol08goo000NOol00`0O
Oomoo`18Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`1ROol00`0O
Oomoo`0SOol001ioo`0301moogoo04Uoo`@000aoo`D000Aoo`03001oogoo069oo`0301moogoo02=o
o`007goo00<07gooOol0HGoo00<007ooOol0HGoo00<07gooOol097oo000OOol00`0OOomoo`1QOol0
0`00Oomoo`1QOol00`0OOomoo`0TOol0021oo`0301moogoo061oo`03001oogoo065oo`0301moogoo
02Aoo`0087oo00<07gooOol0H7oo0P00HGoo00<07gooOol09Goo000QOol00`0OOomoo`1OOol00`00
Oomoo`1POol00`0OOomoo`0UOol0025oo`0301moogoo05moo`03001oogoo05moo`0301moogoo02Io
o`008Woo00<07gooOol0GWoo00<007ooOol0Ggoo00<07gooOol09Woo000ROol00`0OOomoo`1NOol0
0`00Oomoo`1NOol00`0OOomoo`0WOol002=oo`0301moogoo05eoo`03001oogoo05ioo`0301moogoo
02Moo`008goo00<07gooOol0GGoo00<007ooOol0GGoo00<07gooOol0:7oo000TOol00`0OOomoo`1L
Ool2001NOol00`0OOomoo`0XOol002Aoo`0301moogoo05aoo`03001oogoo05aoo`0301moogoo02Uo
o`009Goo00<07gooOol0Fgoo00<007ooOol0G7oo00<07gooOol0:Goo000UOol00`0OOomoo`1KOol0
0`00Oomoo`1KOol00`0OOomoo`0ZOol002Ioo`0301moogoo05Yoo`03001oogoo05]oo`0301moogoo
02Yoo`009Woo00<07gooOol0FWoo00<007ooOol0FWoo00<07gooOol0:goo000WOol00`0OOomoo`1I
Ool00`00Oomoo`1JOol00`0OOomoo`0[Ool002Qoo`0301moogoo05Qoo`03001oogoo05Uoo`0301mo
ogoo02aoo`00:7oo00<07gooOol0F7oo0P00FGoo00<07gooOol0;Goo000YOol00`0OOomoo`1GOol0
0`00Oomoo`1GOol00`0OOomoo`0^Ool002Yoo`0301moogoo05Ioo`03001oogoo05Moo`0301moogoo
02ioo`00:Woo00<07gooOol0EWoo00<007ooOol0EWoo00<07gooOol0;goo000[Ool00`0OOomoo`1E
Ool00`00Oomoo`1EOol00`0OOomoo`0`Ool002]oo`0301moogoo05Eoo`03001oogoo05Eoo`0301mo
ogoo031oo`00;7oo00<07gooOol0E7oo00<007ooOol0E7oo00<07gooOol0<Goo000]Ool00`0OOomo
o`1COol00`00Oomoo`1COol00`0OOomoo`0bOol002ioo`0301moogoo059oo`8005=oo`0301moogoo
03=oo`00;goo00<07gooOol0DGoo00<007ooOol0DGoo00<07gooOol0=7oo000`Ool00`0OOomoo`1@
Ool00`00Oomoo`1@Ool00`0OOomoo`0eOol0035oo`0301moogoo04moo`03001oogoo04moo`0301mo
ogoo03Ioo`00<Woo00<07gooOol0CWoo00<007ooOol0Cgoo00<07gooOol0=Woo000cOol00`0OOomo
o`14Ool50004Ool00`00Oomoo`1>Ool00`0OOomoo`0gOol003Aoo`0301moogoo04Eoo`03001oogoo
00Aoo`03001oogoo04eoo`0301moogoo03Qoo`00=Goo00<07gooOol0A7oo00<007ooOol017oo00<0
07ooOol0C7oo00<07gooOol0>Goo000fOol00`0OOomoo`13Ool00`00Oomoo`04Ool3001;Ool00`0O
Oomoo`0jOol003Moo`0301moogoo049oo`03001oogoo00Aoo`03001oogoo04Yoo`0301moogoo03]o
o`00>7oo00<07gooOol0@Goo00<007ooOol017oo00<007ooOol0BGoo00<07gooOol0?7oo000iOol0
0`0OOomoo`0nOol30006Ool00`00Oomoo`18Ool00`0OOomoo`0mOol003Yoo`0301moogoo03moo`03
001oogoo00Aoo`03001oogoo04Moo`0301moogoo03ioo`00>goo0P0OAWoo00<007ooOol0AGoo0P0O
@Goo000mOol00`0OOomoo`13Ool00`00Oomoo`14Ool00`0OOomoo`11Ool003ioo`0301moogoo049o
o`03001oogoo04=oo`0301moogoo049oo`00?goo00<07gooOol0@Goo0P00@goo00<07gooOol0@goo
0010Ool00`0OOomoo`10Ool00`00Oomoo`11Ool00`0OOomoo`14Ool0045oo`807d1oo`03001oogoo
03moo`807dMoo`00@goo00<07gooOol0?Goo00<007ooOol0?Woo00<07gooOol0Agoo0014Ool201lm
Ool00`00Oomoo`0lOol201m:Ool004Ioo`0301moogoo03Yoo`03001oogoo03]oo`0301moogoo04Yo
o`00Agoo0P0O>Woo00<007ooOol0>Goo0P0OCGoo0019Ool00`0OOomoo`0gOol2000iOol00`0OOomo
o`1=Ool004Yoo`807cMoo`03001oogoo03Ioo`807e1oo`00C7oo00<07gooOol0=7oo00<007ooOol0
=7oo0P0ODWoo001=Ool201ldOol00`00Oomoo`0bOol201mDOol004moo`807c9oo`03001oogoo031o
o`807eIoo`00DGoo0P0O<7oo00<007ooOol0;Woo0P0OF7oo001COol201l^Ool00`00Oomoo`0/Ool2
01mJOol005Eoo`807baoo`03001oogoo02Yoo`807eaoo`00Egoo0P0O:Woo0P00:7oo0`0OGWoo001I
Ool201lXOol00`00Oomoo`0UOol201mQOol005]oo`<07bEoo`03001oogoo029oo`<07f=oo`00GWoo
100O8Goo00<007ooOol07goo0`0OIWoo001ROol301lNOol00`00Oomoo`0KOol401mYOol006Eoo`<0
7a]oo`03001oogoo01Qoo`<07feoo`00J7oo100O5goo00<007ooOol057oo100OL7oo001/Ool601lA
Ool00`00Oomoo`0@Ool401mdOol0079oo`P07`Uoo`8000Yoo`L07gQoo`00NWoo5@0OOgoo0023Ool0
0`00Oomoo`28Ool008=oo`03001oogoo08Qoo`00Pgoo00<007ooOol0R7oo001ZOol50004Ool20005
Ool40005Ool00`00Oomoo`28Ool006aoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo08Qoo`00K7oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0R7oo
001/Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool30028Ool006aoo`03001oogoo00]oo`@0091oo`00
K7oo00<007ooOol02goo00<007ooOol0TGoo001ZOol3000=Ool00`00Oomoo`2AOol006aoo`03001o
ogoo00]oo`D008moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`mo
o`00ogoo3goo003oOol?Ool0085oo`800003Ool0000008Qoo`00P7oo00<007ooOol00P00RGoo0020
Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo0020Ool01@00Oomoogoo0000RGoo
001oOol20002Ool20029Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003o
Ool?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-1.69301, -1.57641, 0.0160828, \
0.0160828}}]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  "The animation shows that an initial point ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_0, u\_0)\)\)]],
  " moves along a circle if we change the group parameter \[Epsilon]. By \
repeating this kind of transformation for different initial points, a picture \
representing the global action of the transformation in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane is gained. The following picture contains the orbits of the \
transformation given in ",
  StyleBox["rotation",
    FontSlant->"Italic"],
  " for several initial points. The initial points are chosen along the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis."
}], "Text",
  CellTags->{
  "transformation", "orbits of the transformation", "initial points"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[
      Evaluate[\n\t\t
        Table[\({X[x, u, e], U[x, u, e]} /. rotation\) /. {x \[Rule] xo, 
              u \[Rule] 1}, \n\t\t\t{xo, 1, 5, 1\/2}]], {e, 0, 2\ \[Pi]}, \n\t
      AspectRatio \[Rule] Automatic, 
      PlotStyle \[Rule] Table[Hue[x], \n\t\t\t{x, 0, 1, 1\/5}], 
      AxesLabel \[Rule] {"\<x\>", "\<u\>"}]\)], "Input",
  CellMargins->{{Inherited, Inherited}, {0, Inherited}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.499999 0.0933889 0.500001 0.0933889 [
[.12644 .4875 -6 -9 ]
[.12644 .4875 6 0 ]
[.31322 .4875 -6 -9 ]
[.31322 .4875 6 0 ]
[.68678 .4875 -3 -9 ]
[.68678 .4875 3 0 ]
[.87355 .4875 -3 -9 ]
[.87355 .4875 3 0 ]
[1.025 .5 0 -9.5 ]
[1.025 .5 12 9.5 ]
[.4875 .12645 -12 -4.5 ]
[.4875 .12645 0 4.5 ]
[.4875 .31322 -12 -4.5 ]
[.4875 .31322 0 4.5 ]
[.4875 .68678 -6 -4.5 ]
[.4875 .68678 0 4.5 ]
[.4875 .87356 -6 -4.5 ]
[.4875 .87356 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.12644 .5 m
.12644 .50625 L
s
[(-4)] .12644 .4875 0 1 Mshowa
.31322 .5 m
.31322 .50625 L
s
[(-2)] .31322 .4875 0 1 Mshowa
.68678 .5 m
.68678 .50625 L
s
[(2)] .68678 .4875 0 1 Mshowa
.87355 .5 m
.87355 .50625 L
s
[(4)] .87355 .4875 0 1 Mshowa
.125 Mabswid
.17314 .5 m
.17314 .50375 L
s
.21983 .5 m
.21983 .50375 L
s
.26653 .5 m
.26653 .50375 L
s
.35992 .5 m
.35992 .50375 L
s
.40661 .5 m
.40661 .50375 L
s
.4533 .5 m
.4533 .50375 L
s
.54669 .5 m
.54669 .50375 L
s
.59339 .5 m
.59339 .50375 L
s
.64008 .5 m
.64008 .50375 L
s
.73347 .5 m
.73347 .50375 L
s
.78017 .5 m
.78017 .50375 L
s
.82686 .5 m
.82686 .50375 L
s
.07975 .5 m
.07975 .50375 L
s
.03305 .5 m
.03305 .50375 L
s
.92025 .5 m
.92025 .50375 L
s
.96694 .5 m
.96694 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 .12645 m
.50625 .12645 L
s
[(-4)] .4875 .12645 1 0 Mshowa
.5 .31322 m
.50625 .31322 L
s
[(-2)] .4875 .31322 1 0 Mshowa
.5 .68678 m
.50625 .68678 L
s
[(2)] .4875 .68678 1 0 Mshowa
.5 .87356 m
.50625 .87356 L
s
[(4)] .4875 .87356 1 0 Mshowa
.125 Mabswid
.5 .17314 m
.50375 .17314 L
s
.5 .21983 m
.50375 .21983 L
s
.5 .26653 m
.50375 .26653 L
s
.5 .35992 m
.50375 .35992 L
s
.5 .40661 m
.50375 .40661 L
s
.5 .45331 m
.50375 .45331 L
s
.5 .54669 m
.50375 .54669 L
s
.5 .59339 m
.50375 .59339 L
s
.5 .64008 m
.50375 .64008 L
s
.5 .73347 m
.50375 .73347 L
s
.5 .78017 m
.50375 .78017 L
s
.5 .82686 m
.50375 .82686 L
s
.5 .07975 m
.50375 .07975 L
s
.5 .03306 m
.50375 .03306 L
s
.5 .92025 m
.50375 .92025 L
s
.5 .96694 m
.50375 .96694 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.59339 .59339 m
.58111 .60423 L
.56682 .61392 L
.55117 .62176 L
.54187 .62526 L
.533 .62788 L
.52873 .62891 L
.52407 .62986 L
.51993 .63056 L
.51552 .63116 L
.51154 .63157 L
.50927 .63175 L
.50714 .63188 L
.50614 .63193 L
.50519 .63197 L
.50432 .632 L
.5034 .63203 L
.5024 .63205 L
.50148 .63206 L
.50037 .63207 L
.49938 .63207 L
.49833 .63206 L
.49735 .63205 L
.49628 .63202 L
.49513 .63198 L
.49278 .63188 L
.49065 .63174 L
.48654 .63138 L
.48266 .63093 L
.47409 .62951 L
.46929 .62845 L
.46489 .62732 L
.44952 .62204 L
.44109 .61821 L
.43345 .61408 L
.41889 .60423 L
.4068 .59358 L
.39587 .58125 L
.38578 .56632 L
.37818 .55103 L
.37481 .54208 L
.37231 .53376 L
.37037 .52528 L
.36907 .51737 L
.36859 .5132 L
.36837 .5108 L
.36821 .50861 L
.36808 .50629 L
.36802 .50501 L
.36798 .5038 L
Mistroke
.36795 .50268 L
.36794 .50165 L
.36793 .50051 L
.36793 .49987 L
.36793 .4993 L
.36794 .49824 L
.36796 .49726 L
.36798 .49619 L
.36802 .49504 L
.36813 .49269 L
.36827 .49055 L
.36863 .48643 L
.36909 .48254 L
.37052 .47396 L
.37158 .46917 L
.37271 .46477 L
.37802 .44937 L
.38187 .44094 L
.38601 .4333 L
.39589 .41873 L
.40657 .40665 L
.41895 .39572 L
.43391 .38565 L
.44925 .37807 L
.45821 .37471 L
.46654 .37224 L
.47504 .37031 L
.48297 .36903 L
.48714 .36856 L
.48955 .36834 L
.49174 .36819 L
.49406 .36806 L
.49534 .36801 L
.49655 .36797 L
.49767 .36795 L
.49871 .36794 L
.49985 .36793 L
.50042 .36793 L
.50106 .