(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2183128,      49441]*)
(*NotebookOutlinePosition[   2224529,      50414]*)
(*  CellTagsIndexPosition[   2218501,      50273]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["4.4.2 Second-Order Ordinary Differential Equations", "Section",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 56}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Second order ordinary differential equations"],

Cell[TextData[{
  "Second-order ordinary differential equations are very important for \
applications in physics and engineering. All equations based on Newton\
\[CloseCurlyQuote]s second law are second-order equations. Thus, mechanics, \
for example, is mainly based on second-order ordinary differential equations. \
The integration theory of second-order ODEs was developed by Lie during the \
years ",
  ButtonBox["1871",
    ButtonData:>{"Literat.nb", "Lie-1874"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["\[Dash]",
    ButtonData:>{"Literat.nb", "Lie-1874"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["1874",
    ButtonData:>{"Literat.nb", "Lie-1874"},
    ButtonStyle->"Hyperlink"],
  ". In 1891, Lie\[CloseCurlyQuote]s theory of integration was published by \
",
  ButtonBox["Scheffers and Lie [1891]",
    ButtonData:>{"Literat.nb", "Sche-1891"},
    ButtonStyle->"Hyperlink"],
  " in ",
  StyleBox["Vorlesungen \[UDoubleDot]ber Differentialgleichungen mit \
bekannten infinitesimalen Transformationen",
    FontSlant->"Italic"],
  ". Scheffers, a student of Lie, assembled all of Lie\[CloseCurlyQuote]s \
work on ordinary differential equations in a beginner\[CloseCurlyQuote]s \
book. In another series of books compiled by ",
  ButtonBox["Lie and Engel [1888],",
    ButtonData:>{"Literat.nb", "Lie-88"},
    ButtonStyle->"Hyperlink"],
  " Lie describes the problem of integrating a differential equation as \
follows: "
}], "Text",
  CellTags->{
  "second-order ordinary differential equations", "engineering", "physics", 
    "Newton's second law", "mechanics"}],

Cell[TextData[
"\[OpenCurlyDoubleQuote]I observed that a large number of ordinary \
differential equations integrated by older integration methods are invariant \
under easily derivable classes of transformations. The older integration \
methods are all based on the transformation properties of the equation. In \
other words, I realized that the term differential invariant of a finite \
continuous group is contained implicitly in every textbook on ordinary \
differential equations. Discovering the connection between transformation \
groups and older integration strategies I started to develop a general \
integration theory based on the finite or infinitesimal transformation of the \
equation. In my investigations it was clear from the beginning that the \
related transformations always created a group for each case.\
\[CloseCurlyDoubleQuote]"], "Text",
  CellTags->{
  "transformation groups", "integration strategies", 
    "general integration theory", "infinitesimal transformation", "group"}],

Cell[TextData[
"We will exemplify Lie\[CloseCurlyQuote]s line of thought below. The most \
general form of a second-order ODE is given by"], "Text",
  CellTags->"second-order ODE"],

Cell[BoxData[
    \(TraditionalForm\`\(F(x, u, u', \(u'\)')\  = \ 0, \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where primes denote differentiation with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". For our purposes, we assume that equation (4.57) is solvable with \
respect to the second-order derivative. Thus, we consider equations in the \
form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(u'\)'\  = \ \[Omega](x, u, u'), \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where \[Omega] is a given function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  "."
}], "Text"],

Cell["\<\
For the general equation (4.58) or (4.57), there exist several \
procedures to derive the solution. Common to each method is the symmetry of \
the equation. In contrast to first-order equations, the determination of \
symmetries is not difficult. However, the problem here is to apply the \
appropriate solution procedure to a specific equation. In the following, we \
discuss three methods which allow us to identify the solution of a \
second-order ODE.\
\>", "Text",
  CellTags->{"solution of a second-order ODE", "symmetry of an equation"}],

Cell[CellGroupData[{

Cell["4.4.2.1 Integration by Group Classification", "Subsection",
  CellTags->"Algorithm of Integration"],

Cell[TextData[{
  "Following the reasoning of ",
  ButtonBox["Lie,",
    ButtonData:>{"Literat.nb", "Enge-12"},
    ButtonStyle->"Hyperlink"],
  " we can solve a second-order ODE if we can classify the group. The idea is \
 the following: If a second-order equation admits a Lie algebra of dimension \
",
  Cell[BoxData[
      \(TraditionalForm\`r \[GreaterEqual] 2\)]],
  ", it can be integrated by a group-theoretic quadrature method. This can be \
 done in various ways, one of which is given by the following algorithm:"
}], "Text",
  CellTags->{
  "second-order ODE", "Lie algebra", "group theoretic quadrature", 
    "quadrature method", "algorithm"}],

Cell[TextData[{
  "Compute the admitted Lie algebra ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(L\_r\),
          "InlineFormula"], TraditionalForm]]],
  ". A basis of  ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  " is the set  ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_1\)], "InlineFormula"],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_2\)], "InlineFormula"],
  ", \[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_r\)], "InlineFormula"],
  "."
}], "ListItem",
  CellDingbat->"1.",
  CellTags->{"admitted Lie algebra", "Lie algebra"}],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`r = 2\)]],
  ", go to the next step;\nif ",
  Cell[BoxData[
      \(TraditionalForm\`r > 2\)]],
  ", then distinguish any two-dimensional subalgebra ",
  Cell[BoxData[
      \(TraditionalForm\`L\_2\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  ".\nIf ",
  Cell[BoxData[
      \(TraditionalForm\`r = 1\)]],
  ", The order of the equation may be lowered;\nif ",
  Cell[BoxData[
      \(TraditionalForm\`r = 0\)]],
  ", the group method is not useful."
}], "ListItem",
  CellDingbat->"2."],

Cell[TextData[{
  "Determine the type of the algebra ",
  Cell[BoxData[
      \(TraditionalForm\`L\_2\)]],
  " obtained by the following table:"
}], "ListItem",
  CellDingbat->"3."],

Cell[TextData[Cell[BoxData[GridBox[{
        {"I", 
          RowBox[{
            RowBox[{"[", 
              RowBox[{
                SubscriptBox[
                  StyleBox[
                    OverscriptBox["v", 
                      AdjustmentBox["\[RightVector]",
                        BoxMargins->{{0, 0}, {0.375, -0.375}},
                        BoxBaselineShift->-0.375]],
                    FontSlant->"Italic"], "1"], ",", 
                SubscriptBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]], "2"]}], "]"}], "=", "0"}], 
          RowBox[{
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "1"], "\[CircleTimes]", 
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "2"]}], "\[NotEqual]", "0"}], 
          RowBox[{
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "1"], "=", \(\[PartialD]\_x\)}], ",", 
            " ", 
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "2"], "=", \(\[PartialD]\_u\)}]}], 
          \(\(u\^\*"\""\) = f \((u')\)\)},
        {"II", 
          RowBox[{
            RowBox[{"[", 
              RowBox[{
                SubscriptBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                      BoxBaselineShift->-0.26087]], "1"], ",", 
                \(v\&\[RightVector]\_2\)}], "]"}], "=", "0"}], 
          RowBox[{
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "1"], "\[CircleTimes]", 
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "2"]}], "=", "0"}], 
          RowBox[{
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "1"], "=", \(\[PartialD]\_u\)}], ",", 
            " ", 
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "2"], "=", \(\[PartialD]\_x\)}]}], 
          \(\(u\^\*"\""\) = f \((x)\)\)},
        {"III", 
          RowBox[{
            RowBox[{"[", 
              RowBox[{
                SubscriptBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                      BoxBaselineShift->-0.26087]], "1"], ",", 
                \(v\&\[RightVector]\_2\)}], "]"}], "=", 
            \(v\&\[RightVector]\_1\)}], 
          RowBox[{
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "1"], "\[CircleTimes]", 
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "2"]}], "\[NotEqual]", "0"}], 
          RowBox[{
            RowBox[{
              RowBox[{
                SubscriptBox[
                  StyleBox[
                    OverscriptBox["v", 
                      AdjustmentBox["\[RightVector]",
                        BoxMargins->{{0, 0}, {0.375, -0.375}},
                        BoxBaselineShift->-0.375]],
                    FontSlant->"Italic"], "1"], "=", \(\[PartialD]\_u\)}], 
              ",", " ", 
              RowBox[{
                SubscriptBox[
                  StyleBox[
                    OverscriptBox["v", 
                      AdjustmentBox["\[RightVector]",
                        BoxMargins->{{0, 0}, {0.375, -0.375}},
                        BoxBaselineShift->-0.375]],
                    FontSlant->"Italic"], "2"], "=", 
                \(x \[PartialD]\_x\(+u\)\ \[PartialD]\_u\)}]}], " "}], 
          \(\(u\^\*"\""\) = f \((u')\)/x\)},
        {\(\ IV\), 
          RowBox[{
            RowBox[{"[", 
              RowBox[{
                SubscriptBox[
                  StyleBox[
                    OverscriptBox["v", 
                      AdjustmentBox["\[RightVector]",
                        BoxMargins->{{0, 0}, {0.375, -0.375}},
                        BoxBaselineShift->-0.375]],
                    FontSlant->"Italic"], "1"], ",", 
                \(v\&\[RightVector]\_2\)}], "]"}], "=", 
            \(v\&\[RightVector]\_1\)}], 
          RowBox[{
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "1"], "\[CircleTimes]", 
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "2"]}], "=", "0"}], 
          RowBox[{
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "1"], "=", \(\[PartialD]\_u\)}], ",", 
            " ", 
            RowBox[{
              SubscriptBox[
                StyleBox[
                  OverscriptBox["v", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.375, -0.375}},
                      BoxBaselineShift->-0.375]],
                  FontSlant->"Italic"], "2"], "=", \(u \[PartialD]\_u\)}]}], 
          \(\(u\^\*"\""\) = f \((x)\) u'\)}
        },
      ColumnAlignments->{Center, Left},
      RowLines->True,
      ColumnLines->True]],
  FontSize->8]], "NumberedEquation",
  CellMargins->{{64, Inherited}, {-4, 6}},
  TextAlignment->Left,
  TextJustification->0,
  CellTags->"classification of second order algebras"],

Cell[TextData[{
  "Cases I to IV of the table are identified by computing the commutator [",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_2\)]],
  "] of ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_2\)]],
  ", and their pseudo-scalar product  ",
  Cell[BoxData[
      \(v\&\[RightVector]\_1\[CircleTimes]v\&\[RightVector]\_2\)]],
  "= ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  " \[Dash] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ". The subscripts of the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i\)]],
  " denote the number of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  ". If [",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_2\)]],
  "] is neither 0 nor ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1\)]],
  ", then choose a new basis ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox[
          OverscriptBox[
            StyleBox["v",
              FontSlant->"Italic"], "\[RightVector]"], "1", "\[Prime]"], 
        TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox[
          OverscriptBox[
            StyleBox["v",
              FontSlant->"Italic"], "\[RightVector]"], "2", "\[Prime]"], 
        TraditionalForm]]],
  ", such that ",
  Cell[BoxData[
      StyleBox[
        \(\([v\&\[RightVector]\_1\%\[Prime], v\&\[RightVector]\_2\%\[Prime]]
            \) = \(v\&\[RightVector]\_1\%'\)\),
        "InlineFormula",
        FontFamily->"Times"]]],
  "."
}], "ListItem",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  CellTags->{"commutator", "pseudo scalar product", "infinitesimals"}],

Cell[TextData[{
  "Bring the basis of ",
  Cell[BoxData[
      \(TraditionalForm\`L\_2\)]],
  " into agreement with cases I\[Dash]IV by going over to canonical variables \
",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  ". Rewrite the equation in canonical variables and integrate it."
}], "ListItem",
  CellDingbat->"4.",
  CellTags->"canonical variables"],

Cell["Rewrite the solution in terms of the original variables.", "ListItem",
  CellDingbat->"5."],

Cell[TextData[{
  "The stated algorithm is based on the fact that in the complex case, any \
Lie algebra of dimensionality ",
  Cell[BoxData[
      \(TraditionalForm\`r > 2\)]],
  " has a distinguished two-dimensional subalgebra. However, the structure of \
a two-dimensional Lie algebra with bases ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_2\)]],
  " can be described in terms of the commutator ",
  Cell[BoxData[
      StyleBox[
        \(\([v\&\[RightVector]\_1, v\&\[RightVector]\_2]\) = 
          \(v\&\[RightVector]\_1\) v\&\[RightVector]\_2 - 
            \(v\&\[RightVector]\_2\) v\&\[RightVector]\_1\),
        "InlineFormula",
        FontFamily->"Times"]]],
  " and the pseudo-scalar product ",
  Cell[BoxData[
      \(v\&\[RightVector]\_1\[CircleTimes]v\&\[RightVector]\_2\)], 
    "InlineFormula",
    FontFamily->"Times"],
  StyleBox["= ", "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)], "InlineFormula"],
  StyleBox[" ", "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)], "InlineFormula"],
  StyleBox[" \[Dash] ", "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)], "InlineFormula"],
  StyleBox[" ", "InlineFormula"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Xi]\_2\),
          "InlineFormula"], TraditionalForm]]],
  ". For more details compare the work by ",
  ButtonBox["Scheffers and Lie [1891]",
    ButtonData:>{"Literat.nb", "Sche-1891"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ", and ",
  ButtonBox["Bluman and Kumei [1989]",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  ". Let us demonstrate these five steps by two examples."
}], "Text",
  CellTags->{
  "subalgebra", "Lie algebra", "commutator", "pseudo scalar product"}],

Cell["Example 1", "Example",
  CellTags->"Example: 1"],

Cell[TextData[{
  "The first example considers a second-order ODE. This equation was \
discussed by ",
  ButtonBox["Ibragimov [1994]",
    ButtonData:>{"Literat.nb", "Ibragimov-1994"},
    ButtonStyle->"Hyperlink"],
  " in connection with Lie\[CloseCurlyQuote]s group classification. We use \
the same example here to demonstrate how symbolic calculations with a \
computer can clarify the solution steps. The equation reads"
}], "Text",
  CellTags->{"second-order ODE", "Lie\.b4s group classification"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(equation = {
        \[PartialD]\_{x, 2}u[x] - \[PartialD]\_x u[x]\/u[x]\^2 + 
          1\/\(u[x]\ x\)}; equation // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(1\/\(u\ x\)\),
                  ScriptLevel->0], "-", 
                StyleBox[\(u\_x\/u\^2\),
                  ScriptLevel->0], "+", \(u\_\(x, x\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The first step of the algorithm consists in finding the Lie algebra of the \
equation. This step is practically revealed by using the package ",
  StyleBox["MathLie.",
    FontSlant->"Italic"],
  " ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " contains a function designed to determine the infinitesimal \
transformations. The name of the function is ",
  StyleBox["Infinitesimals[]", "MmaText"],
  " and has a symbolic template of the form",
  StyleBox[" ", "MmaText"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            TagBox["\[ScriptCapitalP]\[ScriptCapitalS]",
              NotationBoxTag,
              Editable->True], \(u, x\), "\[Gamma]"], "[", "\[CapitalDelta]", 
          "]"}], TraditionalForm]], "MmaText"],
  ". This operator takes the independent and dependent variables as \
subscripts and the parameters as superscripts. The equation is given as a \
fourth argument. The equation above is free of any parameters. The \
determination of the infinitesimals is carried out by"
}], "Text",
  CellTags->{
  "Lie algebra", "Infinitesimals[]", "symbolic template", 
    "calculation of the infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"infi", " ", "=", " ", 
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptCapitalP]\[ScriptCapitalS]",
                  FontSize->10],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \({u}, {x}\), \({}\)], "[", "equation", "]"}]}], 
      ";", \(infi // LTF\)}]], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 1\/2\ u\ \((k1 + 2\ k2\ x)\)\)},
          {\(\[Xi]\_1 == x\ \((k1 + k2\ x)\)\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 2], u, 
            Plus[ k1, 
              Times[ 2, k2, x]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ x, 
            Plus[ k1, 
              Times[ k2, x]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a representation of the infinitesimals for the independent \
and dependent variables. ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] corresponds to the independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  StyleBox["phi",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] to the dependent variable ",
  StyleBox["u.",
    FontSlant->"Italic"],
  " It turns out that our equation admits a two-dimensional Lie group. The \
two parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`k2\)]],
  " are the group parameters. As discussed in ",
  ButtonBox["Chapter 2",
    ButtonData:>{"Algebra.nb", "Lie algebras"},
    ButtonStyle->"Hyperlink"],
  ", to each symmetry group there exists a related Lie algebra. We can \
inspect the structure of this algebra again by applying ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The package provides tools to calculate the commutator table and the \
structure constants. The commutator table is created by"
}], "Text",
  CellTags->{
  "Lie group", "symmetry group", "Lie algebra", "commutator table", 
    "calculate the commutator table", "structure constants"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieCommutatorTable[infi, {u}, {x}] // TableForm\)], "Input",
  CellTags->"LieCommutatorTable[]"],

Cell[BoxData[
    TagBox[GridBox[{
          {"0", \(-V[2]\)},
          {\(V[2]\), "0"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of this calculation shows that the corresponding algebra ",
  Cell[BoxData[
      \(TraditionalForm\`L\_2\)]],
  " belongs to type III of ",
  ButtonBox[" Lie's classification",
    ButtonData:>"classification of second order algebras",
    ButtonStyle->"Hyperlink"],
  ". This becomes obvious if we interchange the vector fields ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  " and calculate the pseudo-scalar product of the infinitesimals "
}], "Text",
  CellTags->{
  "algebra", "Lie's classification", "pseudo scalar product", 
    "infinitesimals"}],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(v\&\[RightVector]\_1\[CircleTimes]v\&\[RightVector]\_2\), "=", " ", 
        RowBox[{
          RowBox[{
            FormBox[\(\[Xi]\_1\),
              "TraditionalForm"], " ", 
            FormBox[\(\[Phi]\_2\),
              "TraditionalForm"]}], " ", "-", " ", 
          RowBox[{
            FormBox[\(\[Phi]\_1\),
              "TraditionalForm"], " ", 
            FormBox[\(\[Xi]\_2\  = \ \(u\ x\^2\)\/2 \[NotEqual] \(0 . \)\),
              "TraditionalForm"]}]}]}], TraditionalForm]], "DisplayFormula",
  TextAlignment->Center],

Cell[TextData[{
  "The calculation of the pseudo-scalar product in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " needs the lines"
}], "Text",
  CellTags->"pseudo scalar product"],

Cell[BoxData[
    \(\(infi1\  = 
      \({\(xi[1]\)[x, u], \(phi[1]\)[x, u]} /. \ infi\)\  /. {k1 \[Rule] 1, 
          k2 \[Rule] 0}; \)\)], "Input"],

Cell[BoxData[
    \(\(infi2\  = 
      \({\(xi[1]\)[x, u], \(phi[1]\)[x, u]} /. \ infi\)\  /. {k1 \[Rule] 0, 
          k2 \[Rule] 1}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pseudoScalarProduct\  = \ 
      infi1\[LeftDoubleBracket]1\[RightDoubleBracket]\ 
          infi2\[LeftDoubleBracket]2\[RightDoubleBracket] - 
        infi1\[LeftDoubleBracket]2\[RightDoubleBracket]\ 
          infi2\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \(\(u\ x\^2\)\/2\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "In step 4 of the integration algorithm, we introduce ",
  ButtonBox["canonical variables ",
    ButtonData:>{"symmet11.nb", "Canonical variables"},
    ButtonStyle->"Hyperlink"],
  "which have to satisfy the conditions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(v\&\[RightVector]\_1\),
              "TraditionalForm"], "(", "t", ")"}], "=", "0"}], 
        TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(v\&\[RightVector]\_1\),
              "TraditionalForm"], "(", "u", ")"}], "=", "1"}], 
        TraditionalForm]]],
  ". Solving the related characteristic equations by conducting the function \
",
  StyleBox["CanonicalVariables[]", "MmaText"],
  ", we end up with transformations probably simplifying the original \
equation. In the following ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " line, the first two arguments, ",
  Cell[BoxData[
      \(TraditionalForm\`{u}\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`{x}\)]],
  ", denote the dependent and independent variables, and the next two, ",
  Cell[BoxData[
      \(TraditionalForm\`{x}\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`{u\/2}\)]],
  ", are the infinitesimals for ",
  Cell[BoxData[
      \(TraditionalForm\`k1 = 1\)]],
  " and k2 = 0 of the independent and dependent variables, respectively. The \
last pair ",
  Cell[BoxData[
      \(TraditionalForm\`{w}\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`{t}\)]],
  " are the new dependent and independent canonical variables, respectively:"
}], "Text",
  CellTags->{
  "integration algorithm", "canonical variables", "characteristic equation", 
    "CanonicalVariables[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(substitution = CanonicalVariables[{u}, {x}, {x}, {u\/2}, {w}, {t}]; 
    substitution // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(t == Log[x]\)},
          {
            RowBox[{"w", "==", 
              StyleBox[\(u\/\@x\),
                ScriptLevel->0]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, 
          Log[ x]], 
        Equal[ w, 
          Times[ u, 
            Power[ x, 
              Rational[ -1, 2]]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
The result belongs to the subgroup with k1 = 1 and k2 = 0. The \
second set of transformations follows by the choice k1 = 0 and k2 = 1:\
\>", 
  "Text",
  CellTags->"transformations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(secondtransformation\  = \ \n
      CanonicalVariables[{u}, {x}, {x\^2}, {x\ u}, {w}, {t}]; 
    secondtransformation // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{"t", "==", 
              RowBox[{"-", 
                StyleBox[\(1\/x\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{"w", "==", 
              StyleBox[\(u\/x\),
                ScriptLevel->0]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, 
          Times[ -1, 
            Power[ x, -1]]], 
        Equal[ w, 
          Times[ u, 
            Power[ x, -1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The next step in the algorithm is to use these transformations to change \
the representation of the equation. For this kind of calculation, ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " offers the function ",
  StyleBox["CanonicalRepresentation[]", "MmaText"],
  ". This function needs the input of the original equation, the canonical \
transformations given by rules, and the target variables. The first set of \
canonical variables descending from the subgroup with k1 = 1 and k2\
\[NonBreakingSpace]\[NoBreak]= 0 leads to the reduced equation"
}], "Text",
  CellTags->{"CanonicalRepresentation[]", "canonical variables"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(canonical1\  = \ 
      CanonicalRepresentation[
        equation\[LeftDoubleBracket]1\[RightDoubleBracket], u, 
        x, {w \[Rule] u\/\@x, t \[Rule] Log[x]}, w, t]; canonical1 // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(2\ w - w\^3 - 4\ w\_t + 4\ w\^2\ w\_\(t, t\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "At this stage of the calculation, we can use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["DSolve[]", "MmaText"],
  " to solve the second-order equation. We note that the achieved equation is \
as complicated as the original equation and, thus, ",
  StyleBox["DSolve[]", "MmaText"],
  " may fail to find a solution. In fact, we get"
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ DSolve[canonical1, w, t]\)], "Input"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{\(2\ w[t]\), "-", \(w[t]\^3\), "-", 
            RowBox[{"4", " ", 
              RowBox[{
                SuperscriptBox["w", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{"4", " ", \(w[t]\^2\), " ", 
              RowBox[{
                SuperscriptBox["w", "\[DoublePrime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}], 
        ",", "w", ",", "t"}], "]"}]], "Output"]
}, Open  ]],

Cell["\<\
However, using the second set of canonical variables, we discover \
the reduction\
\>", "Text",
  CellTags->"canonical variables"],

Cell[CellGroupData[{

Cell[BoxData[
    \(canonical2\  = \ 
      CanonicalRepresentation[
        equation\[LeftDoubleBracket]1\[RightDoubleBracket], u, 
        x, {w \[Rule] u\/x, t \[Rule] \(-1\)\/x}, w, t]; 
    canonical2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(t\^3\), " ", 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox[\(w\_t\/w\^2\),
                      ScriptLevel->0], "-", \(w\_\(t, t\)\)}], ")"}]}], "==", 
              "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "which looks much simpler. This simplification is one aim of symmetry \
analysis. Exerting the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["DSolve[]", "MmaText"],
  " to this equation, we acquire"
}], "Text",
  CellTags->{"simplification of ODEs", "symmetry analysis", "DSolve[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ DSolve[canonical2, w, t]\)], "Input"],

Cell[BoxData[
    \(InverseFunction::"ifun" \( : \ \) 
      "Warning: Inverse functions are being used. Values may be lost for  \
multivalued inverses."\)], "Message"],

Cell[BoxData[
    \({{w \[Rule] 
          \((\(1 + ProductLog[E\^\(\(-1\) + C[1]\^2\ \((#1 - C[2])\)\)]\)\/C[
                  1]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "As expected, the solution of the equation in canonical variables is given \
by a function containing two constants of integration. The ",
  StyleBox["ProductLog[]", "MmaText"],
  StyleBox[" function", "TB"],
  " depicts the solution for ",
  Cell[BoxData[
      \(TraditionalForm\`w\)], "InlineFormula",
    CellTags->"S3.2.10"],
  " in ",
  Cell[BoxData[
      FormBox[
        RowBox[{"z", "=", 
          SuperscriptBox[
            StyleBox["we",
              FontSlant->"Italic"], "w"]}], TraditionalForm]], 
    "InlineFormula",
    CellTags->"S3.2.10"],
  ". The function is a generalization of a logarithm. It can be used to \
represent solutions to a variety of transcendental equations."
}], "Text",
  CellTags->{
  "constants of integration", "ProductLog[]", 
    "generalization of a logarithm", "transcendental equation"}],

Cell[TextData[{
  "The last step of the integration procedure by Lie is the inversion of the \
transformation. This back substitution of the canonical variables is also \
supported by the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The related function is ",
  StyleBox["BackTrafoCanonical[]", "MmaText"],
  ". For the inverse canonical transformation, we need the solution in \
canonical variables, the set of canonical variables themselves, the original \
variables, and the transformation between the two sets of variables. Knowing \
these quantities, we are able to apply the function to the solution:"
}], "Text",
  CellTags->{"inversion of a transformation", "BackTrafoCanonical[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solu\  = 
      BackTrafoCanonical[sol2, w, t, u, 
        x, {u \[Rule] w\ x, t \[Rule] \(-1\)/x}]\)], "Input"],

Cell[BoxData[
    \({u \[Rule] 
        Function[x, 
          \(x\ \((1 + 
                  ProductLog[
                    E\^\(\(-1\) + C[1]\^2\ \((\(-\(1\/x\)\) - C[2])\)\)])
                \)\)\/C[1]]}\)], "Output"]
}, Open  ]],

Cell["\<\
The derived solution satisfies the original equation. We can check \
this by inserting the solution into the equation:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(equation\  /. \ solu // FullSimplify\)], "Input"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result confirms the solution. Since the solution contains a special \
function, we have no clear idea of the graph of this function. We can \
graphically represent the solution by specifying the constants of \
integration. For a set of five constants ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] at fixed ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2], we create a table containing the different solutions:"
}], "Text",
  CellTags->"special function"],

Cell[BoxData[
    \(\(soluC\  = \ 
      Table[\(u[x]\  /. \ solu\)\  /. {C[1] \[Rule] \[Epsilon], 
            C[2] \[Rule] 1}, {\[Epsilon], 1, 5}]; \)\)], "Input"],

Cell[TextData[{
  "A LogLog plot shows that the solutions with fixed ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2] have a common slope:"
}], "Text"],

Cell[BoxData[
    \(<< Graphics`Graphics`\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(LogLogPlot[Evaluate[soluC], {x, 0.001, 10}, 
      PlotStyle 
        \[Rule] {RGBColor[0, \ 0, \ 0.250004], RGBColor[0.996109, \ 0, \ 0], 
          RGBColor[0, \ 0.500008, \ 0], RGBColor[0.500008, \ 0, \ 0.250004], 
          RGBColor[0.700008, \ 0, \ 0]}, AxesLabel \[Rule] {"\<x\>", "\<u\>"}]
      \ \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.455674 0.520516 0.371077 0.222195 [
[.09185 -0.0125 -11 -15 ]
[.09185 -0.0125 11 0 ]
[.29898 -0.0125 -11 -15 ]
[.29898 -0.0125 11 0 ]
[.45567 -0.0125 -5 -15 ]
[.45567 -0.0125 5 0 ]
[.61237 -0.0125 -5 -15 ]
[.61237 -0.0125 5 0 ]
[.8195 -0.0125 -5 -15 ]
[.8195 -0.0125 5 0 ]
[.97619 -0.0125 -8 -15 ]
[.97619 -0.0125 8 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .082 -28 -7.5 ]
[-0.0125 .082 0 7.5 ]
[-0.0125 .14888 -22 -7.5 ]
[-0.0125 .14888 0 7.5 ]
[-0.0125 .30419 -22 -7.5 ]
[-0.0125 .30419 0 7.5 ]
[-0.0125 .37108 -10 -7.5 ]
[-0.0125 .37108 0 7.5 ]
[-0.0125 .52638 -10 -7.5 ]
[-0.0125 .52638 0 7.5 ]
[-0.0125 .59327 -16 -7.5 ]
[-0.0125 .59327 0 7.5 ]
[0 .64303 -5 0 ]
[0 .64303 5 15 ]
[ -0.0005 -0.0005 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.09185 0 m
.09185 .00625 L
s
gsave
.09185 -0.0125 -72 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.29898 0 m
.29898 .00625 L
s
gsave
.29898 -0.0125 -72 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.45567 0 m
.45567 .00625 L
s
gsave
.45567 -0.0125 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.61237 0 m
.61237 .00625 L
s
gsave
.61237 -0.0125 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.8195 0 m
.8195 .00625 L
s
gsave
.8195 -0.0125 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.001 w
.18351 0 m
.18351 .00375 L
s
.24854 0 m
.24854 .00375 L
s
.3402 0 m
.3402 .00375 L
s
.37505 0 m
.37505 .00375 L
s
.40523 0 m
.40523 .00375 L
s
.43186 0 m
.43186 .00375 L
s
.70402 0 m
.70402 .00375 L
s
.76906 0 m
.76906 .00375 L
s
.86071 0 m
.86071 .00375 L
s
.89556 0 m
.89556 .00375 L
s
.92575 0 m
.92575 .00375 L
s
.95237 0 m
.95237 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .082 m
.00625 .082 L
s
gsave
-0.0125 .082 -89 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.05) show
87.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .14888 m
.00625 .14888 L
s
gsave
-0.0125 .14888 -83 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.1) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .30419 m
.00625 .30419 L
s
gsave
-0.0125 .30419 -83 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .37108 m
.00625 .37108 L
s
gsave
-0.0125 .37108 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .52638 m
.00625 .52638 L
s
gsave
-0.0125 .52638 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .59327 m
.00625 .59327 L
s
gsave
-0.0125 .59327 -77 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.001 w
0 .0327 m
.00375 .0327 L
s
0 .06046 m
.00375 .06046 L
s
0 .09959 m
.00375 .09959 L
s
0 .11446 m
.00375 .11446 L
s
0 .12735 m
.00375 .12735 L
s
0 .13872 m
.00375 .13872 L
s
0 .21577 m
.00375 .21577 L
s
0 .2549 m
.00375 .2549 L
s
0 .28266 m
.00375 .28266 L
s
0 .32178 m
.00375 .32178 L
s
0 .33666 m
.00375 .33666 L
s
0 .34954 m
.00375 .34954 L
s
0 .36091 m
.00375 .36091 L
s
0 .43796 m
.00375 .43796 L
s
0 .47709 m
.00375 .47709 L
s
0 .50485 m
.00375 .50485 L
s
0 .54398 m
.00375 .54398 L
s
0 .55885 m
.00375 .55885 L
s
0 .57174 m
.00375 .57174 L
s
0 .5831 m
.00375 .5831 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 .25 r
.5 Mabswid
0 .17746 m
.25226 .28534 L
.41867 .35907 L
.50872 .39915 L
.57079 .42668 L
.62224 .44939 L
.66269 .46718 L
.69898 .48309 L
.72917 .49629 L
.75485 .50749 L
.7793 .51814 L
.80058 .52739 L
.81931 .53552 L
.83768 .54349 L
.85406 .55058 L
.87026 .55759 L
.88483 .5639 L
.89802 .5696 L
.91126 .57532 L
.92331 .58052 L
.93544 .58576 L
.94655 .59055 L
.95675 .59494 L
.96712 .59941 L
.97619 .60332 L
s
.996 0 0 r
0 .10967 m
.25226 .21736 L
.41867 .2884 L
.50872 .32686 L
.57079 .35339 L
.62224 .37539 L
.66269 .39269 L
.69898 .40822 L
.72917 .42114 L
.75485 .43212 L
.7793 .44259 L
.80058 .45169 L
.81931 .45971 L
.83768 .46757 L
.85406 .47457 L
.87026 .4815 L
.88483 .48774 L
.89802 .49338 L
.91126 .49905 L
.92331 .5042 L
.93544 .50939 L
.94655 .51414 L
.95675 .5185 L
.96712 .52294 L
.97619 .52682 L
s
0 .5 0 r
0 .07055 m
.25226 .17823 L
.41867 .24927 L
.50872 .28771 L
.57079 .3142 L
.62224 .33617 L
.66269 .35343 L
.69898 .36893 L
.72917 .38181 L
.75485 .39277 L
.7793 .40321 L
.80058 .4123 L
.81931 .42029 L
.83768 .42813 L
.85406 .43512 L
.87026 .44204 L
.88483 .44826 L
.89802 .45389 L
.91126 .45954 L
.92331 .46468 L
.93544 .46987 L
.94655 .47461 L
.95675 .47896 L
.96712 .48339 L
.97619 .48726 L
s
.5 0 .25 r
0 .04279 m
.25226 .15047 L
.41867 .22151 L
.50872 .25995 L
.57079 .28644 L
.62224 .30841 L
.66269 .32567 L
.69898 .34116 L
.72917 .35405 L
.75485 .36501 L
.7793 .37545 L
.80058 .38453 L
.81931 .39253 L
.83768 .40037 L
.85406 .40736 L
.87026 .41428 L
.88483 .4205 L
.89802 .42613 L
.91126 .43178 L
.92331 .43692 L
.93544 .4421 L
.94655 .44685 L
.95675 .4512 L
.96712 .45562 L
.97619 .4595 L
s
.7 0 0 r
0 .02125 m
.25226 .12894 L
.41867 .19997 L
.50872 .23841 L
.57079 .26491 L
.62224 .28687 L
.66269 .30414 L
.69898 .31963 L
.72917 .33252 L
.75485 .34348 L
.7793 .35392 L
.80058 .363 L
.81931 .371 L
.83768 .37884 L
.85406 .38583 L
.87026 .39274 L
.88483 .39897 L
.89802 .4046 L
.91126 .41025 L
.92331 .41539 L
.93544 .42057 L
.94655 .42531 L
.95675 .42967 L
.96712 .43409 L
.97619 .43796 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 136.938},
  ImageMargins->{{51, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>0000Za000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo000dOol40005Ool20004Ool5
000FOol40005Ool20005Ool4000COol5000JOol5000VOol4000HOol50003Ool4000GOol003=oo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol0000EOol00`00Oomoo`02Ool00`00
Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0BOol00`00Oomoo`0JOol01@00Oomoogoo
00009Goo00<007ooOol00Woo00<007ooOol05goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool057oo000cOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0FOol00`00Oomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`0BOol00`00Oomoo`0KOol00`00Oomoo`0[Ool00`00Oomoo`0GOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0DOol003=oo`03001oogoo009oo`03001oogoo
00Yoo`03001oogoo01Eoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo019oo`03001oogoo
01aoo`03001oogoo02Yoo`03001oogoo01Moo`03001oogoo009oo`03001oogoo009oo`03001oogoo
01Aoo`00<goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol057oo00<007ooOol00Woo00<0
07ooOol02Goo10005Goo00<007ooOol07Goo00<007ooOol09Goo10006Woo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol057oo000cOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`0C
Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0FOol00`00Oomoo`0NOol00`00Oomoo`0T
Ool00`00Oomoo`0KOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0DOol003=oo`03001o
ogoo009oo`03001oogoo00Qoo`05001oogooOol0000EOol00`00Oomoo`02Ool00`00Oomoo`09Ool0
0`00Oomoo`0DOol3000LOol01@00Oomoogoo00009Woo00<007ooOol06Goo0`0017oo00<007ooOol0
0Woo00<007ooOol057oo000dOol4000<Ool3000GOol4000<Ool5000DOol00`00Oomoo`0KOol3000W
Ool5000IOol00`00Oomoo`03Ool4000GOol00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00
oWoo0P000Woo0P002Woo003oOol01000Oomoo`002goo003oOol1Ool2000<Ool002]ool/000Yoo`80
00aoo`00:goo00<007ooOol03goo00<007ooOol09goo00<007ooOol07Goo00<007ooOol07Goo00<0
07ooOol09goo00<007ooOol077oo00<007ooOol037oo00@007ooOol000]oo`00:goo00<007ooOol0
d7oo0P000Woo0P002Woo000[Ool00`00Oomoo`3POol002]oo`9D0>5oo`00:goo00@007ooE01D0=mo
o`00:goo0P000Woo0U@0gGoo000[Ool00`00Oomoo`03Ool3E03JOol002]oo`8l1`Moo`9D0=Qoo`00
:goo00@007oo?0Ll1`Moo`9D0=Ioo`00:goo00@007ooOomoo`8l1`Moo`=D0==oo`00:goo00<007oo
Ool00goo0c`71goo0U@0dGoo000[Ool20007Ool2?0L7Ool2E03?Ool002]oo`03001oogoo00Qoo`8l
1`Moo`=D0<aoo`002Woo10001Goo0P001Goo100017oo10001Goo0P7P2goo0c`71goo0U@0bWoo0009
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<0
07ooOol00Woo00@007oo0N01h0aoo`8l1`Moo`9D0<Qoo`002Goo00<007ooOol00Woo00<007ooOol0
27oo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol00Woo0P000Woo0P7P37oo0S`71goo0U@0
aWoo0009Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool30N0;Ool3?0L6Ool3E033Ool000Uoo`03001oogoo009oo`03001o
ogoo00Qoo`03001oogoo009oo`04001oogooOol40005Ool00`00Oomoo`06Ool20N0<Ool2?0L7Ool2
E031Ool000Uoo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`05001oogooOol00008
Ool00`00Oomoo`08Ool20N0<Ool2?0L7Ool2E02oOol000Uoo`03001oogoo009oo`03001oogoo00Qo
o`03001oogoo009oo`05001oogooOol00008Ool2000;Ool30N0;Ool2?0L7Ool3E02lOol000Yoo`@0
00aoo`@000Aoo`D000Aoo`03001oogoo00eoo`81h0]oo`<l1`Moo`9D0;Yoo`00:goo0W`047oo0P7P
37oo0S`71goo0U@0^7oo000[Ool20002O00@Ool30N0;Ool2?0L7Ool3E02eOol002]oo`04001oogoo
Ool2O00AOol20N0;Ool3?0L7Ool2E02cOol002]oo`8000Aoo`=l011oo`81h0aoo`8l1`Moo`9D0;5o
o`00:goo00<007ooOol01Woo0W`047oo0P7P37oo0S`71goo0e@0[Woo000AOol40005Ool20005Ool5
0005Ool00`00Oomoo`08Ool2O00@Ool30N0;Ool3?0L7Ool2E02/Ool0011oo`03001oogoo009oo`03
001oogoo009oo`8000Moo`03001oogoo00Eoo`8000]oo`=l011oo`81h0aoo`8l1`Moo`=D0:Uoo`00
47oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol01Goo00<007ooOol03Goo0W`047oo0P7P
37oo0S`727oo0U@0Ygoo000@Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool2000@
Ool2O00@Ool30N0;Ool3?0L7Ool2E02UOol0011oo`03001oogoo009oo`03001oogoo00]oo`03001o
ogoo00Eoo`03001oogoo015oo`=l011oo`81h0aoo`8l1`Moo`=D0:9oo`0047oo00<007ooOol00Woo
00<007ooOol02goo00<007ooOol01Goo00<007ooOol057oo0W`047oo0P7P37oo0c`71goo0U@0X7oo
000@Ool00`00Oomoo`02Ool00`00Oomoo`09Ool30007Ool00`00Oomoo`0FOol2O00@Ool30N0<Ool2
?0L7Ool3E02MOol0015oo`@000ioo`03001oogoo00Eoo`03001oogoo01Qoo`9l015oo`81h0aoo`8l
1`Qoo`9D09]oo`00:goo00<007ooOol06Woo0g`047oo0P7P37oo0c`71goo0e@0V7oo000[Ool200LN
Ool2O00@Ool30N0<Ool2?0L8Ool2E02FOol002]oo`04001oo`0700LNOol2O00AOol20N0<Ool3?0L7
Ool2E02DOol002]oo`04001oogooOol300LMOol3O00@Ool30N0<Ool2?0L7Ool3E02AOol002]oo`03
001oogoo00Aoo`801aioo`9l015oo`81h0aoo`<l1`Moo`9D08moo`00:goo00<007ooOol01Woo0P07
7Woo0W`04Goo0P7P3Goo0S`71goo0e@0S7oo000[Ool00`00Oomoo`08Ool300LMOol3O00@Ool30N0<
Ool2?0L8Ool2E02:Ool002]oo`03001oogoo00]oo`801aioo`9l015oo`81h0aoo`<l1`Moo`9D08Qo
o`00:goo0P003Woo0`077Goo0W`04Goo0`7P37oo0S`71goo0U@0QWoo000[Ool00`00Oomoo`0@Ool2
00LMOol3O00AOol20N0<Ool3?0L6Ool3E023Ool002]oo`03001oogoo019oo`<01aeoo`9l015oo`<1
h0aoo`8l1`Moo`9D085oo`00:goo00<007ooOol05Goo0P077Goo0g`04Goo0P7P37oo0S`71goo0U@0
Ogoo000[Ool00`00Oomoo`0GOol200LNOol2O00AOol20N0<Ool2?0L7Ool2E01mOol002]oo`03001o
ogoo01Uoo`<01aeoo`9l015oo`<1h0]oo`<l1`Ioo`=D07Yoo`00:goo00<007ooOol077oo0P077Goo
0g`04Goo0P7P37oo0S`71goo0U@0N7oo000[Ool00`00Oomoo`0NOol300LMOol2O00AOol30N0;Ool2
?0L7Ool2E01fOol002]oo`80029oo`801aeoo`=l015oo`81h0]oo`8l1`Moo`=D07=oo`00:goo00<0
07ooOol08goo0`077Goo0W`04Goo0P7P2goo0S`727oo0U@0LGoo000[Ool00`00Oomoo`0VOol200LM
Ool3O00@Ool20N0;Ool2?0L8Ool3E01^Ool002]oo`03001oogoo02Qoo`801aioo`9l011oo`<1h0Yo
o`8l1`Uoo`9D06aoo`00:goo00<007ooOol0:Woo0`077Goo0W`04Goo0P7P2Woo0S`72Goo0U@0JWoo
000[Ool00`00Oomoo`0]Ool200LMOol3O00@Ool20N0:Ool2?0L9Ool2E01XOol002]oo`80031oo`<0
1aeoo`9l011oo`81h0Yoo`8l1`Uoo`9D06Ioo`00:goo00<007ooOol0<Woo0P077Goo0g`03goo0`7P
2Goo0c`727oo0e@0Hgoo000AOol40005Ool20005Ool40006Ool00`00Oomoo`0dOol200LNOol2O00@
Ool20N0:Ool3?0L8Ool2E01QOol0011oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001o
ogoo009oo`03001oogoo00=oo`03001oogoo03Ioo`801aioo`9l011oo`81h0]oo`8l1`Qoo`=D05io
o`0047oo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00goo0P00>Goo0`077Goo0W`047oo
0`7P2Woo0c`727oo0e@0Fgoo000@Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`03Ool0
0`00Oomoo`0kOol200LMOol3O00@Ool20N0;Ool2?0L9Ool2E01IOol0011oo`03001oogoo009oo`03
001oogoo00Uoo`@000Ioo`03001oogoo03eoo`801aioo`9l011oo`<1h0Yoo`8l1`Uoo`9D05Moo`00
47oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol0?goo0P077Woo0W`0
4Goo0P7P2Woo0S`72Goo0U@0EGoo000@Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`07
Ool20012Ool300LMOol2O00AOol20N0:Ool2?0L9Ool2E01COol0015oo`@000aoo`D000Eoo`03001o
ogoo04Aoo`801aeoo`=l011oo`81h0Yoo`<l1`Qoo`9D055oo`00:goo00<007ooOol0AWoo0P077Woo
0W`047oo0P7P2goo0S`727oo0e@0CWoo000[Ool20019Ool300LMOol2O00@Ool30N0:Ool2?0L9Ool3
E01;Ool002]oo`03001oogoo04]oo`801aeoo`=l011oo`81h0Yoo`<l1`Uoo`9D04Uoo`00:goo0P00
CWoo0P077Woo0W`047oo0`7P2Woo0c`727oo0U@0Agoo000[Ool00`00Oomoo`1?Ool200LNOol3O00@
Ool30N0:Ool3?0L7Ool3E014Ool0021oo`D000Ioo`03001oogoo055oo`<01aioo`9l015oo`81h0]o
o`<l1`Moo`9D049oo`008Woo00<007ooOol01Woo0P00EGoo0P077Woo0W`04Goo0P7P37oo0S`71goo
0U@0@7oo000ROol00`00Oomoo`06Ool00`00Oomoo`1FOol200LNOol2O00AOol20N0<Ool00c`7Oomo
o`06Ool2E00nOol0029oo`03001oogoo00Ioo`8005Uoo`801aioo`9l015oo`81h0]oo`8l1`Qoo`=D
03]oo`008Woo00<007ooOol01Woo00<007ooOol0FWoo0`077Goo0g`047oo0P7P2goo0c`727oo0U@0
>Goo000ROol00`00Oomoo`06Ool00`00Oomoo`1MOol200LNOol2O00@Ool30N0;Ool3?0L7Ool2E00g
Ool0021oo`<000Qoo`03001oogoo05moo`801aioo`=l011oo`<1h0]oo`8l1`Moo`=D03Aoo`008Woo
00<007ooOol01Woo00<007ooOol0HGoo0P077goo0g`047oo0P7P2goo0S`727oo0e@0<Goo000[Ool0
0`00Oomoo`1SOol200LPOol2O00@Ool20N0;Ool2?0L9Ool2E00_Ool002]oo`03001oogoo06Eoo`80
1b1oo`9l011oo`<1h0Yoo`8l1`Uoo`9D02eoo`00:goo00<007ooOol0Igoo0P0787oo0W`04Goo0P7P
2Woo13`71goo00=D07ooOol0:Woo000[Ool00`00Oomoo`1YOol200LPOol2O00AOol20N0<Ool2?0L6
Ool3E00YOol002]oo`03001oogoo06]oo`801b1oo`9l015oo`81h0aoo`8l1`Moo`9D02Moo`00:goo
00<007ooOol0KGoo0P0787oo0g`047oo0`7P2goo0S`71goo0U@09Goo000[Ool00`00Oomoo`1_Ool3
00LPOol3O00@Ool20N0;Ool2?0L7Ool2E00SOol002]oo`03001oogoo079oo`801b5oo`9l011oo`81
h0]oo`<l1`Ioo`AD01moo`00:goo0P00MGoo0P078Goo0W`047oo0`7P2goo0S`727oo0U@07Goo000[
Ool00`00Oomoo`1fOol200LQOol3O00@Ool30N0:Ool2?0LUOol002]oo`03001oogoo07Qoo`801b9o
o`9l015oo`<1h0Uoo`8l1b=oo`00:goo00<007ooOol0NWoo0`078Goo0W`04Woo0P7P2Goo0S`78Goo
000[Ool00`00Oomoo`1mOol200LQOol2O00BOol00`7POomoo`08Ool2?0LOOol002]oo`03001oogoo
07moo`<01b1oo`=l011oo`81h0Yoo`8l1aeoo`00:goo00<007ooOol0PWoo0`0787oo0W`047oo0P7P
9goo000[Ool00`00Oomoo`25Ool200LPOol2O00@Ool20N0UOol002]oo`8008Qoo`801b1oo`=l00mo
o`81h2=oo`00:goo00<007ooOol0RGoo0P078Goo0g`03Woo107P7goo000[Ool00`00Oomoo`2;Ool2
00LROol3O00?Ool20N0MOol002]oo`03001oogoo08eoo`801b=oo`9l02aoo`00:goo00<007ooOol0
Sgoo0`078Woo00=l07ooOol0:Goo000[Ool00`00Oomoo`2BOol300LPOol2O00YOol002]oo`8009Io
o`801b1oo`9l02Moo`00:goo00<007ooOol0Ugoo0P0787oo0W`09Goo000POol40007Ool00`00Oomo
o`2IOol300LOOol2O00SOol001moo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo09aoo`80
1amoo`Al01moo`0097oo00<007ooOol017oo0P00Wgoo0P078Goo0W`07Goo000TOol00`00Oomoo`04
Ool00`00Oomoo`2POol200LnOol0021oo`@000Moo`03001oogoo0:9oo`801caoo`0087oo00<007oo
Ool027oo00<007ooOol0Y7oo0P07>Woo000POol00`00Oomoo`08Ool2002WOol200LhOol0021oo`D0
00Ioo`03001oogoo0:Qoo`@01cAoo`00:goo00<007ooOol0[7oo0P07<Woo000[Ool2002_Ool200L`
Ool002]oo`03001oogoo0;1oo`801bioo`00:goo0P00/goo0P07;7oo000[Ool00`00Oomoo`2dOol3
00LYOol001Uoo`D000=oo`@000Ioo`03001oogoo0;Moo`801bMoo`006goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol00goo0P00^Woo0P079Goo000KOol00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`2kOol200LSOol001]oo`03001oogoo009oo`03001oogoo009o
o`03001oogoo00=oo`800;ioo`801b5oo`006goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool00goo00<007ooOol0_goo0P077goo000KOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool00`00Oomoo`31Ool200LMOol001Uoo`<000Aoo`03001oogoo009oo`03001oogoo00=oo`03
001oogoo0>1oo`006goo00<007ooOol00goo10001Woo00<007ooOol0h7oo000[Ool00`00Oomoo`3P
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00
ogoo3goo003oOol?Ool00?moo`moo`00:Woo0P0000=oo`000000ggoo000YOol00`00Oomoo`02003P
Ool002Uoo`05001oogooOol0003POol002Uoo`05001oogooOol0003POol002Uoo`05001oogooOol0
003POol002Qoo`80009oo`800>1oo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {170.125, 0}} -> {-1.28687, -2.14342, \
0.0118699, 0.0278066}}]
}, Open  ]],

Cell[TextData[{
  "Varying ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2] we observe only a minor change in the slope:"
}], "Text"],

Cell[BoxData[
    \(\(soluC\  = \ 
      Table[\(u[x]\  /. \ solu\)\  /. {C[1] \[Rule] 1, C[2] \[Rule] y}, {y, 
          1, 5, 1}]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(LogLogPlot[Evaluate[soluC], {x, 0.001, 10}, 
      PlotStyle 
        \[Rule] {RGBColor[0, \ 0, \ 0.250004], RGBColor[0.996109, \ 0, \ 0], 
          RGBColor[0, \ 0.500008, \ 0], RGBColor[0.500008, \ 0, \ 0.250004], 
          RGBColor[0.700008, \ 0, \ 0]}, AxesLabel \[Rule] {"\<x\>", "\<u\>"}]
      \ \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.455674 0.520516 0.279902 0.309426 [
[.09185 -0.0125 -11 -15 ]
[.09185 -0.0125 11 0 ]
[.29898 -0.0125 -11 -15 ]
[.29898 -0.0125 11 0 ]
[.45567 -0.0125 -5 -15 ]
[.45567 -0.0125 5 0 ]
[.61237 -0.0125 -5 -15 ]
[.61237 -0.0125 5 0 ]
[.8195 -0.0125 -5 -15 ]
[.8195 -0.0125 5 0 ]
[.97619 -0.0125 -8 -15 ]
[.97619 -0.0125 8 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .06362 -22 -7.5 ]
[-0.0125 .06362 0 7.5 ]
[-0.0125 .18676 -22 -7.5 ]
[-0.0125 .18676 0 7.5 ]
[-0.0125 .2799 -10 -7.5 ]
[-0.0125 .2799 0 7.5 ]
[-0.0125 .37305 -10 -7.5 ]
[-0.0125 .37305 0 7.5 ]
[-0.0125 .49618 -10 -7.5 ]
[-0.0125 .49618 0 7.5 ]
[-0.0125 .58933 -16 -7.5 ]
[-0.0125 .58933 0 7.5 ]
[0 .64303 -5 0 ]
[0 .64303 5 15 ]
[ -0.0005 -0.0005 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.09185 0 m
.09185 .00625 L
s
gsave
.09185 -0.0125 -72 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.29898 0 m
.29898 .00625 L
s
gsave
.29898 -0.0125 -72 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.45567 0 m
.45567 .00625 L
s
gsave
.45567 -0.0125 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.61237 0 m
.61237 .00625 L
s
gsave
.61237 -0.0125 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.8195 0 m
.8195 .00625 L
s
gsave
.8195 -0.0125 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.001 w
.18351 0 m
.18351 .00375 L
s
.24854 0 m
.24854 .00375 L
s
.3402 0 m
.3402 .00375 L
s
.37505 0 m
.37505 .00375 L
s
.40523 0 m
.40523 .00375 L
s
.43186 0 m
.43186 .00375 L
s
.70402 0 m
.70402 .00375 L
s
.76906 0 m
.76906 .00375 L
s
.86071 0 m
.86071 .00375 L
s
.89556 0 m
.89556 .00375 L
s
.92575 0 m
.92575 .00375 L
s
.95237 0 m
.95237 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .06362 m
.00625 .06362 L
s
gsave
-0.0125 .06362 -83 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .18676 m
.00625 .18676 L
s
gsave
-0.0125 .18676 -83 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .2799 m
.00625 .2799 L
s
gsave
-0.0125 .2799 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .37305 m
.00625 .37305 L
s
gsave
-0.0125 .37305 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .49618 m
.00625 .49618 L
s
gsave
-0.0125 .49618 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .58933 m
.00625 .58933 L
s
gsave
-0.0125 .58933 -77 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.001 w
0 .11811 m
.00375 .11811 L
s
0 .15677 m
.00375 .15677 L
s
0 .21126 m
.00375 .21126 L
s
0 .23197 m
.00375 .23197 L
s
0 .24992 m
.00375 .24992 L
s
0 .26574 m
.00375 .26574 L
s
0 .42754 m
.00375 .42754 L
s
0 .46619 m
.00375 .46619 L
s
0 .52068 m
.00375 .52068 L
s
0 .5414 m
.00375 .5414 L
s
0 .55934 m
.00375 .55934 L
s
0 .57517 m
.00375 .57517 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 .25 r
.5 Mabswid
0 .01027 m
.25226 .16051 L
.41867 .26318 L
.50872 .319 L
.57079 .35733 L
.62224 .38896 L
.66269 .41373 L
.69898 .43589 L
.72917 .45427 L
.75485 .46987 L
.7793 .48469 L
.80058 .49758 L
.81931 .5089 L
.83768 .52 L
.85406 .52988 L
.87026 .53964 L
.88483 .54842 L
.89802 .55636 L
.91126 .56432 L
.92331 .57157 L
.93544 .57886 L
.94655 .58553 L
.95675 .59166 L
.96712 .59788 L
.97619 .60332 L
s
.996 0 0 r
0 .00948 m
.25226 .15955 L
.41867 .25992 L
.50872 .31437 L
.57079 .35186 L
.62224 .38288 L
.66269 .40724 L
.69898 .42906 L
.72917 .44719 L
.75485 .4626 L
.7793 .47726 L
.80058 .49002 L
.81931 .50123 L
.83768 .51223 L
.85406 .52203 L
.87026 .53172 L
.88483 .54044 L
.89802 .54832 L
.91126 .55623 L
.92331 .56343 L
.93544 .57068 L
.94655 .57731 L
.95675 .5834 L
.96712 .58959 L
.97619 .595 L
s
0 .5 0 r
0 .00919 m
.25226 .15919 L
.41867 .25866 L
.50872 .31254 L
.57079 .34966 L
.62224 .38042 L
.66269 .40458 L
.69898 .42626 L
.72917 .44428 L
.75485 .4596 L
.7793 .47418 L
.80058 .48687 L
.81931 .49804 L
.83768 .50899 L
.85406 .51875 L
.87026 .5284 L
.88483 .53709 L
.89802 .54495 L
.91126 .55283 L
.92331 .56001 L
.93544 .56724 L
.94655 .57385 L
.95675 .57993 L
.96712 .5861 L
.97619 .5915 L
s
.5 0 .25 r
0 .00908 m
.25226 .15906 L
.41867 .25818 L
.50872 .31184 L
.57079 .34883 L
.62224 .37948 L
.66269 .40357 L
.69898 .42518 L
.72917 .44315 L
.75485 .45844 L
.7793 .47299 L
.80058 .48566 L
.81931 .4968 L
.83768 .50774 L
.85406 .51748 L
.87026 .52712 L
.88483 .53579 L
.89802 .54364 L
.91126 .55151 L
.92331 .55868 L
.93544 .5659 L
.94655 .57251 L
.95675 .57858 L
.96712 .58474 L
.97619 .59014 L
s
.7 0 0 r
0 .00904 m
.25226 .15901 L
.41867 .25801 L
.50872 .31159 L
.57079 .34852 L
.62224 .37913 L
.66269 .40319 L
.69898 .42477 L
.72917 .44273 L
.75485 .458 L
.7793 .47255 L
.80058 .4852 L
.81931 .49634 L
.83768 .50727 L
.85406 .517 L
.87026 .52664 L
.88483 .5353 L
.89802 .54315 L
.91126 .55102 L
.92331 .55818 L
.93544 .5654 L
.94655 .57201 L
.95675 .57807 L
.96712 .58423 L
.97619 .58963 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{217.875, 129.125},
  ImageMargins->{{51.3125, 0}, {0, 0}},
  ImageRegion->{{-0.029344, 1.02705}, {-0.000351, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004@0000XA000`40O003h00Oogoo4Goo003oOolA
Ool00?mooa5oo`00ogoo4Goo003oOolAOol00?mooa5oo`00ogoo4Goo000hOol40005Ool20004Ool5
000BOol40005Ool20005Ool4000AOol5000HOol5000ROol4000FOol50003Ool4000SOol003Moo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol0000AOol00`00Oomoo`02Ool00`00
Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`0HOol01@00Oomoogoo
00008Goo00<007ooOol00Woo00<007ooOol05Goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool087oo000gOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0BOol00`00Oomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`0@Ool00`00Oomoo`0IOol00`00Oomoo`0WOol00`00Oomoo`0EOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0POol003Moo`03001oogoo009oo`03001oogoo
00Yoo`03001oogoo015oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo011oo`03001oogoo
01Yoo`03001oogoo02Ioo`03001oogoo01Eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo
021oo`00=goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol047oo00<007ooOol00Woo00<0
07ooOol02Goo10004goo00<007ooOol06goo00<007ooOol08Goo100067oo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol087oo000gOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`0?
Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0DOol00`00Oomoo`0LOol00`00Oomoo`0P
Ool00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0POol003Moo`03001o
ogoo009oo`03001oogoo00Qoo`05001oogooOol0000AOol00`00Oomoo`02Ool00`00Oomoo`09Ool0
0`00Oomoo`0BOol3000JOol01@00Oomoogoo00008Woo00<007ooOol05goo0`0017oo00<007ooOol0
0Woo00<007ooOol087oo000hOol4000<Ool3000COol4000<Ool5000BOol00`00Oomoo`0IOol3000S
Ool5000GOol00`00Oomoo`03Ool4000SOol00?mooa5oo`00ogoo4Goo003oOolAOol00?mooa5oo`00
lgoo0P000Woo0P005goo003dOol01000Oomoo`0067oo000_Oonm0009Ool2000IOol002moo`03001o
ogoo00moo`03001oogoo00ioo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo01Yoo`03001o
ogoo00ioo`03001oogoo00Yoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo009oo`05001oogooOol0000>Ool2000IOol002moo`03E01oogoo0<9oo`04
001oogoo000HOol002moo`03001D05@00<5oo`80009oo`8001Moo`00;goo00<007ooOol00U@0g7oo
000_Ool00`00Oomoo`02Ool00e@0Oomoo`3IOol002moo`03001oogoo00=oo`9D0=Uoo`00;goo00<0
07ooOol01Goo0U@0egoo000_Ool00`00Oomoo`07Ool2E03EOol002moo`03001oogoo00Uoo`03E01o
ogoo0=9oo`005Woo10001Goo0P0017oo1@001Goo00<007ooOol02Woo0U@0dWoo000EOol00`00Oomo
o`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00001Goo00<007ooOol037oo0U@0d7oo000E
Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool3000>Ool00e@0Oomoo`3=Ool001Eo
o`03001oogoo009oo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo00moo`9D0<eoo`005Goo
00<007ooOol00Woo00<007ooOol02goo00<007ooOol017oo00<007ooOol04Goo0U@0bgoo000EOol0
0`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool00`00Oomoo`0COol2E039Ool001Eoo`03
001oogoo009oo`03001oogoo00Qoo`05001oogooOol00005Ool00`00Oomoo`0EOol00e@0Oomoo`36
Ool001Ioo`@000aoo`<000Ioo`03001oogoo01Ioo`9D0<Ioo`00;goo00<007ooOol067oo0U@0a7oo
000_Ool00`00Oomoo`0JOol00e@0Oomoo`31Ool002moo`03001oogoo01]oo`9D0<5oo`00;goo00<0
07ooOol07Goo0U@0_goo000_Ool2000POol2E02mOol002moo`03001oogoo025oo`03E01oogoo0;Yo
o`00;goo00<007ooOol08Woo0U@0^Woo000_Ool00`00Oomoo`0TOol2E02hOol002moo`03001oogoo
02Ioo`03E01oogoo0;Eoo`00;goo00<007ooOol09goo0U@0]Goo000_Ool00`00Oomoo`0YOol2E02c
Ool002moo`03001oogoo02]oo`9D0;5oo`00;goo0P00;Woo00=D07ooOol0[Woo000_Ool00`00Oomo
o`0^Ool2E02^Ool002moo`03001oogoo031oo`9D0:aoo`005Woo10001Goo0P001Goo10001Goo00<0
07ooOol0<Goo00<01e@0Ool0ZWoo000EOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0cOol2E02YOol001Eoo`03001oogoo009oo`03001o
ogoo00eoo`03001oogoo009oo`<003Aoo`0300MD07oo0:Moo`005Goo00<007ooOol00Woo00<007oo
Ool03Goo00<007ooOol00Woo00<007ooOol0=Woo0U@0YWoo000EOol00`00Oomoo`02Ool00`00Oomo
o`09Ool40005Ool00`00Oomoo`0hOol2E02TOol001Eoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Ioo`03001oogoo03Uoo`0300MD07oo0:9oo`005Goo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol01Woo00<007ooOol0>goo0U@0XGoo000FOol4000<Ool50004Ool2000mOol00`07
E01D002OOol002moo`03001oogoo03ioo`0300MD07oo09eoo`00;goo00<007ooOol0?goo00<01e@0
E000W7oo000_Ool00`00Oomoo`11Ool00`07E01D002JOol002moo`8004=oo`801`03E01oogoo09Mo
o`00;goo00<007ooOol0A7oo00<01e@0E000Ugoo000_Ool00`00Oomoo`16Ool00`07E01oo`2EOol0
02moo`8004Qoo`0300MD05@009Aoo`00;goo00<007ooOol0BGoo00<01e@0E000TWoo000_Ool00`00
Oomoo`1:Ool200L00e@0Oomoo`2?Ool002Eoo`D000Eoo`8004eoo`0300MD05@008moo`009goo00<0
07ooOol01Goo00<007ooOol0CGoo0P070U@0SGoo000WOol00`00Oomoo`05Ool00`00Oomoo`1?Ool2
00L00e@0Oomoo`2:Ool002Moo`03001oogoo00Eoo`<0055oo`0300MD05@008Yoo`009goo00<007oo
Ool01Goo00<007ooOol0DWoo0P070U@0R7oo000WOol00`00Oomoo`05Ool00`00Oomoo`1DOol200L2
E026Ool002Eoo`<000Moo`03001oogoo05Ioo`801`03E01oogoo08=oo`009goo00<007ooOol01Goo
00<007ooOol0F7oo00<01e@0E000Pgoo000_Ool00`00Oomoo`1IOol200L2E021Ool002moo`03001o
ogoo05]oo`801`03E01oogoo07ioo`00;goo00<007ooOol0GGoo00<01e@0E000OWoo000_Ool00`00
Oomoo`1NOol200L00e@0Oomoo`1kOol002moo`03001oogoo061oo`0300MD05@007]oo`00;goo00<0
07ooOol0HGoo0P070U@0NGoo000_Ool00`00Oomoo`1SOol200L00e@0Oomoo`1fOol002moo`03001o
ogoo06Eoo`0300MD05@007Ioo`00;goo00<007ooOol0IWoo0P0700=D07ooOol0Lgoo000_Ool00`00
Oomoo`1XOol00`07E01D001cOol002Aoo`D000Ioo`03001oogoo06Uoo`801`9D075oo`0097oo00D0
07ooOomoo`0000Ioo`03001oogoo06]oo`801`9D06moo`009Goo00<007ooOol01goo0`00KGoo00@0
1`7PE01D06eoo`009Woo00<007ooOol01Woo00<007ooOol0KWoo0P0700<1h5@0E000Jgoo000WOol0
0`00Oomoo`05Ool00`00Oomoo`1`Ool200L00`7PE01D001YOol002Qoo`03001oogoo00Aoo`03001o
ogoo079oo`0400L1h07PE01XOol002Aoo`05001oogooOol00006Ool00`00Oomoo`1cOol200L00`7P
E01D001VOol002Eoo`<000Moo`03001oogoo07Eoo`0300Ml007P009D06Aoo`00;goo00<007ooOol0
MWoo0P0700=l007PE000Hgoo000_Ool00`00Oomoo`1hOol200L00g`0E01D001QOol002moo`03001o
ogoo07Yoo`0300Ml07`0009D05moo`00;goo00<007ooOol0Ngoo0P070W`00U@0GGoo000_Ool2001n
Ool200L2O0000e@0Oomoo`1JOol002moo`03001oogoo07moo`801`03O01D05@005Yoo`00;goo00<0
07ooOol0PGoo00<01g`0O0000U@0F7oo000_Ool00`00Oomoo`22Ool200L2O0000e@0Oomoo`1EOol0
02moo`03001oogoo08Aoo`801`03O01D05@005Eoo`00;goo00<007ooOol0QWoo00<01g`0O0000U@0
Dgoo000_Ool00`00Oomoo`27Ool200L2O0000e@0Oomoo`1@Ool002moo`03001oogoo08Uoo`801`03
O01D05@0051oo`00;goo0P00S7oo00<01g`0O0000U@0CWoo000_Ool00`00Oomoo`2<Ool200L2O000
0e@0Oomoo`1;Ool002moo`03001oogoo08ioo`801`03O01D05@004]oo`009Goo10001Woo00<007oo
Ool0T7oo00<01g`0O0000U@0BGoo000TOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`2A
Ool200L2O002E017Ool002Uoo`03001oogoo00=oo`<009=oo`801`03O001h5@004Ioo`00:Goo00<0
07ooOol00goo00<007ooOol0UGoo00<01goo0N000U@0A7oo000UOol40006Ool00`00Oomoo`2FOol0
1007Ool1h07P0U@0@Woo000UOol00`00Oomoo`07Ool00`00Oomoo`2GOol00`07Oomoo`020N02E010
Ool002Eoo`03001oogoo00Moo`03001oogoo09Qoo`801`9oo`03O001h5@003moo`009Goo1@001Goo
0P00Vgoo0P070Woo00=l05@0E000?Goo000_Ool00`00Oomoo`2LOol200L017ooO01l05@0?7oo000_
Ool00`00Oomoo`2NOol200L00gooO01D000kOol002moo`03001oogoo0:1oo`801`03O01D05@003Uo
o`00;goo0P00Xgoo00<01g`0O0000U@0=goo000_Ool00`00Oomoo`2SOol01@07Ooml07`0E000=Woo
000_Ool00`00Oomoo`2TOol200L017ooO01D05@0=7oo000_Ool2002WOol01007Oomoog`00U@0<Woo
000_Ool00`00Oomoo`2WOol300L017ooO01D05@0<7oo000_Ool00`00Oomoo`2ZOol200L017`00N1D
05@0;Woo000NOol50003Ool40005Ool2002]Ool01@07Ool1h3`7E000;Goo000POol00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`2]Ool01@07Oomooc`7E000;7oo000POol0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`2^Ool200L017ooO01D05@0
:Woo000POol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool3002`Ool200L2O0000e@0
Oomoo`0WOol0021oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo0;9o
o`801`03O01oogoo02Moo`0087oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol0]7oo00<01gooOol09goo000NOol30004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`3NOol0021oo`03001oogoo00=oo`@000Eoo`03001oogoo0=ioo`00;goo00<007ooOol0gWoo
003oOolAOol00?mooa5oo`00ogoo4Goo003oOolAOol00?mooa5oo`00ogoo4Goo003oOolAOol00?mo
oa5oo`00ogoo4Goo003oOolAOol002moo`800003Ool000000=aoo`00;Woo00<007ooOol00P00gGoo
000^Ool01@00Oomoogoo0000gGoo000^Ool01@00Oomoogoo0000gGoo000^Ool01@00Oomoogoo0000
gGoo000]Ool20002Ool2003MOol00?mooa5oo`00ogoo4Goo003oOolAOol00?mooa5oo`00ogoo4Goo
003oOolAOol00?mooa5oo`00\
\>"],
  ImageRangeCache->{{{-7.9375, 278.688}, {160.375, 0}} -> {-1.36722, \
-1.26827, 0.0128118, 0.021552}}]
}, Open  ]],

Cell[TextData[{
  "In conclusion, we see that Lie\[CloseCurlyQuote]s algorithm of group \
classification is straightforward to derive explicit solutions of a \
second-order ODE. All the steps needed to carry out the calculation are \
supported by ",
  StyleBox["MathLie. ",
    FontSlant->"Italic"],
  "Thus, it is fairly easy to construct a solution. The next example \
discusses the solution procedure for a more complicated equation."
}], "Text",
  CellTags->"algorithm of group classification"],

Cell["Example 2", "Example"],

Cell[TextData[{
  "The second example is connected with kinetics and heat transfer (cf. ",
  ButtonBox["Ames [1968]",
    ButtonData:>{"Literat.nb", "Ames-68"},
    ButtonStyle->"Hyperlink"],
  "). Ames' equation also occurs in certain other problems like vortex motion \
of incompressible fluids, in the theory of the space charge of elasticity \
around a glowing wire, and in the nebular theory for the mass distribution of \
gaseous interstellar material under the influence of its own gravitational \
field."
}], "Text",
  CellTags->{
  "heat transfer", "vortex motion", "space charge of elasticity", 
    "glowing wire", "nebular theory", 
    "mass distribution of gaseous interstellar material", 
    "gravitational field"}],

Cell[TextData[{
  "We concentrate our attention on the one-dimensional representations of \
these problems. The equation is discussed in cylindrical coordinates. For \
this special case, the equation reduces to a second-order ordinary \
differential equation (",
  ButtonBox["Ames [1968]",
    ButtonData:>{"Literat.nb", "Ames-68"},
    ButtonStyle->"Hyperlink"],
  ") given by"
}], "Text",
  CellTags->{
  "cylindrical coordinates", "second-order ordinary differential equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ames\  = \ 
      \[PartialD]\_\(x, x\)u[x]\  + \ \(\ \[PartialD]\_x u[x]\)\/x + \ 
        \[Alpha]\ Exp[u[x]]; ames == 0 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(E\^u\ \[Alpha]\), "+", 
                StyleBox[\(u\_x\/x\),
                  ScriptLevel->0], "+", \(u\_\(x, x\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "When trying to solve this simple equation by ",
  StyleBox["DSolve[]", "MmaText"],
  ", we end up with the dissatisfying result"
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[ames == 0, u, x]\)], "Input"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{\(E\^u[x]\ \[Alpha]\), "+", 
            FractionBox[
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], "x"], "+", 
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", "u", ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is unable to find the solution. However, we are currently discussing a \
constructive procedure to derive solutions of second-order equations. Thus, a \
solution should be accessible if we know the symmetry transformations. The \
symmetries of the equation are calculated by the function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  " or the operator ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            SubsuperscriptBox[
              TagBox["\[ScriptCapitalP]\[ScriptCapitalS]",
                NotationBoxTag,
                Editable->True], \(u, x\), "\[Gamma]"], "[", 
            "\[CapitalDelta]", "]"}],
          "MmaText"], TraditionalForm]]],
  ". The application of this operator provides"
}], "Text",
  CellTags->{"symmetry transformation", "Infinitesimals[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SubsuperscriptBox[
          StyleBox[
            TagBox[
              StyleBox["\[ScriptCapitalP]\[ScriptCapitalS]",
                FontSize->9],
              NotationBoxTag,
              Editable->True],
            FontSize->18], \({u}, {x}\), \({\[Alpha]}\)], "[", "ames", "]"}], 
      "//", "LTF"}]], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k2 + k1\ Log[x]\)},
          {\(\[Xi]\_1 == \(-\(1\/2\)\)\ x\ \((\(-k1\) + k2 + k1\ Log[x])\)\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k2, 
            Times[ k1, 
              Log[ x]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Rational[ -1, 2], x, 
            Plus[ 
              Times[ -1, k1], k2, 
              Times[ k1, 
                Log[ x]]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "a two-dimensional symmetry group with group parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`k2\)]],
  ". The subgroups created by the parameters k1 and k2 are the cornerstones \
of the integration process. Let us consider the subgroup related to ",
  Cell[BoxData[
      \(TraditionalForm\`k1 = 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`k2 = 1\)]],
  ". This choice of the group parameters allows to derive the canonical \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " to be"
}], "Text",
  CellTags->{
  "subgroups", "integration process", "group parameter", 
    "canonical variables"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ctransformation\  = \ \n
      CanonicalVariables[{u}, {x}, {\(-x\)/2}, {1}, {w}, {t}]; 
    ctransformation\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(t == \(-2\)\ Log[x]\)},
          {\(w == u + 2\ Log[x]\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, 
          Times[ -2, 
            Log[ x]]], 
        Equal[ w, 
          Plus[ u, 
            Times[ 2, 
              Log[ x]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Converting the original equation ",
  StyleBox["ames",
    FontSlant->"Italic"],
  " into the new coordinates simplifies the representation of the equation:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(canonical\  = \ 
      CanonicalRepresentation[ames, u, 
        x, {w \[Rule] u + 2\ Log[x], t \[Rule] \(-2\)\ Log[x]}, w, t]; 
    canonical // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(E\^t\ \((E\^w\ \[Alpha] + 4\ w\_\(t, t\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The introduction of the canonical variables allows the elimination of the \
term containing first derivatives. As a result, the original equation was \
simplified. Trying again ",
  StyleBox["DSolve[]", "MmaText"],
  " to disclose the solution in canonical coordinates,"
}], "Text",
  CellTags->{"DSolve[]", "canonical coordinates"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(csol\  = \ DSolve[canonical, w, t]\)], "Input"],

Cell[BoxData[
    \({{w \[Rule] 
          \((Log[\(1\/\[Alpha]\) 
                  \((C[1] - 
                      C[1]\ Tanh[
                            1\/4\ \((\@2\ #1\ \@C[1] - \@2\ \@C[1]\ C[2])\)]
                            \^2)\)]&)\)}, {
        w \[Rule] 
          \((Log[\(1\/\[Alpha]\) 
                  \((C[1] - 
                      C[1]\ Tanh[
                            1\/4\ \((\(-\@2\)\ #1\ \@C[1] + \@2\ \@C[1]\ C[2])
                                \)]\^2)\)]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The inversion of the canonical transformation provides the solutions in \
the original variables ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text",
  CellTags->{"inversion", "canonical transformation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ 
      BackTrafoCanonical[sol, w, t, u, 
        x, {u \[Rule] w - 2\ Log[x]\ , t \[Rule] \(-2\)\ Log[x]}]\)], "Input"],

Cell[BoxData[
    \({u \[Rule] 
        Function[x, 
          \(-2\)\ Log[x] + 
            Log[\(1\/\[Alpha]\) 
                \((C[1] - 
                    C[1]\ Tanh[
                          1\/4\ \((
                              \(-\@2\)\ \@C[1]\ C[2] - 2\ \@2\ \@C[1]\ Log[x])
                              \)]^2)\)]], 
      u \[Rule] 
        Function[x, 
          \(-2\)\ Log[x] + 
            Log[\(1\/\[Alpha]\) 
                \((C[1] - 
                    C[1]\ Tanh[
                          1\/4\ \((\@2\ \@C[1]\ C[2] + 2\ \@2\ \@C[1]\ Log[x])
                              \)]^2)\)]]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Inserting the derived solutions into the original equation ",
  StyleBox["ames, ",
    FontSlant->"Italic"],
  "we can check the solution"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ames\  /. \ sol1 // Simplify\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "To get an impression of the solution, we plot it for a set of constants ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] at fixed ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2]",
  StyleBox[" ",
    FontSlant->"Italic"],
  "and \[Alpha]. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[
      Evaluate[Table[
          \(u[x] /. sol1\[LeftDoubleBracket]1\[RightDoubleBracket]\)\  /. {
              C[1] \[Rule] i, C[2] \[Rule] 1, \[Alpha] \[Rule] 1/100}, {i, 1, 
            5, 1}]], {x,  .1, 100}, 
      PlotStyle \[Rule] RGBColor[0.996109, \ 0, \ 0], 
      AxesLabel \[Rule] {"\<x\>", "\<u\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00952381 0.422107 0.0229473 [
[.21429 .40961 -6 -9 ]
[.21429 .40961 6 0 ]
[.40476 .40961 -6 -9 ]
[.40476 .40961 6 0 ]
[.59524 .40961 -6 -9 ]
[.59524 .40961 6 0 ]
[.78571 .40961 -6 -9 ]
[.78571 .40961 6 0 ]
[.97619 .40961 -9 -9 ]
[.97619 .40961 9 0 ]
[1.025 .42211 0 -7.5 ]
[1.025 .42211 10 7.5 ]
[.01131 .0779 -18 -4.5 ]
[.01131 .0779 0 4.5 ]
[.01131 .19263 -18 -4.5 ]
[.01131 .19263 0 4.5 ]
[.01131 .30737 -12 -4.5 ]
[.01131 .30737 0 4.5 ]
[.01131 .53684 -6 -4.5 ]
[.01131 .53684 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.21429 .42211 m
.21429 .42836 L
s
[(20)] .21429 .40961 0 1 Mshowa
.40476 .42211 m
.40476 .42836 L
s
[(40)] .40476 .40961 0 1 Mshowa
.59524 .42211 m
.59524 .42836 L
s
[(60)] .59524 .40961 0 1 Mshowa
.78571 .42211 m
.78571 .42836 L
s
[(80)] .78571 .40961 0 1 Mshowa
.97619 .42211 m
.97619 .42836 L
s
[(100)] .97619 .40961 0 1 Mshowa
.125 Mabswid
.07143 .42211 m
.07143 .42586 L
s
.11905 .42211 m
.11905 .42586 L
s
.16667 .42211 m
.16667 .42586 L
s
.2619 .42211 m
.2619 .42586 L
s
.30952 .42211 m
.30952 .42586 L
s
.35714 .42211 m
.35714 .42586 L
s
.45238 .42211 m
.45238 .42586 L
s
.5 .42211 m
.5 .42586 L
s
.54762 .42211 m
.54762 .42586 L
s
.64286 .42211 m
.64286 .42586 L
s
.69048 .42211 m
.69048 .42586 L
s
.7381 .42211 m
.7381 .42586 L
s
.83333 .42211 m
.83333 .42586 L
s
.88095 .42211 m
.88095 .42586 L
s
.92857 .42211 m
.92857 .42586 L
s
.25 Mabswid
0 .42211 m
1 .42211 L
s
gsave
1.025 .42211 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.02381 .0779 m
.03006 .0779 L
s
[(-15)] .01131 .0779 1 0 Mshowa
.02381 .19263 m
.03006 .19263 L
s
[(-10)] .01131 .19263 1 0 Mshowa
.02381 .30737 m
.03006 .30737 L
s
[(-5)] .01131 .30737 1 0 Mshowa
.02381 .53684 m
.03006 .53684 L
s
[(5)] .01131 .53684 1 0 Mshowa
.125 Mabswid
.02381 .10085 m
.02756 .10085 L
s
.02381 .12379 m
.02756 .12379 L
s
.02381 .14674 m
.02756 .14674 L
s
.02381 .16969 m
.02756 .16969 L
s
.02381 .21558 m
.02756 .21558 L
s
.02381 .23853 m
.02756 .23853 L
s
.02381 .26148 m
.02756 .26148 L
s
.02381 .28442 m
.02756 .28442 L
s
.02381 .33032 m
.02756 .33032 L
s
.02381 .35327 m
.02756 .35327 L
s
.02381 .37621 m
.02756 .37621 L
s
.02381 .39916 m
.02756 .39916 L
s
.02381 .44505 m
.02756 .44505 L
s
.02381 .468 m
.02756 .468 L
s
.02381 .49095 m
.02756 .49095 L
s
.02381 .5139 m
.02756 .5139 L
s
.02381 .05495 m
.02756 .05495 L
s
.02381 .032 m
.02756 .032 L
s
.02381 .00906 m
.02756 .00906 L
s
.02381 .55979 m
.02756 .55979 L
s
.02381 .58274 m
.02756 .58274 L
s
.02381 .60569 m
.02756 .60569 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.996 0 0 r
.5 Mabswid
.02476 .60332 m
.02594 .58597 L
.027 .57399 L
.0294 .55219 L
.03373 .52264 L
.03878 .49733 L
.04355 .47882 L
.05305 .45107 L
.06336 .4289 L
.08525 .39572 L
.10545 .37397 L
.14476 .34362 L
.18256 .32252 L
.22281 .30493 L
.26154 .29106 L
.30272 .27859 L
.34239 .26821 L
.38055 .25937 L
.42115 .25094 L
.46024 .2436 L
.50178 .23649 L
.54181 .2302 L
.58032 .22459 L
.62128 .21903 L
.66073 .21403 L
.69867 .2095 L
.73905 .20495 L
.77792 .20081 L
.81924 .19663 L
.85904 .19281 L
.89734 .1893 L
.93808 .18573 L
.97619 .18253 L
s
.02476 .59722 m
.03373 .53542 L
.04355 .48188 L
.04851 .46265 L
.05381 .44558 L
.06336 .4209 L
.0854 .38081 L
.10545 .35511 L
.14534 .31872 L
.18372 .29357 L
.22454 .27273 L
.26385 .25632 L
.30165 .24291 L
.3419 .23049 L
.38063 .21995 L
.42181 .20993 L
.46148 .20121 L
.49964 .19354 L
.54024 .18602 L
.57933 .17932 L
.62087 .1727 L
.6609 .16675 L
.69941 .16136 L
.74038 .15596 L
.77982 .15104 L
.81776 .14655 L
.85814 .14199 L
.89701 .13781 L
.93833 .13357 L
.97619 .12985 L
s
.02476 .58861 m
.03373 .54172 L
.04355 .48007 L
.04851 .45812 L
.05381 .43876 L
.06336 .41092 L
.07469 .38539 L
.0854 .36597 L
.10545 .33726 L
.14383 .29796 L
.18465 .26808 L
.22396 .24576 L
.26176 .2281 L
.30201 .21214 L
.34074 .19884 L
.38193 .18636 L
.42159 .17564 L
.45975 .16628 L
.50035 .15719 L
.53944 .14914 L
.58098 .14123 L
.62101 .13415 L
.65952 .12777 L
.70049 .12139 L
.73993 .11561 L
.77787 .11034 L
.81825 .10501 L
.85712 .10013 L
.89844 .09519 L
.93825 .09065 L
.97619 .0865 L
s
.02476 .57981 m
.02594 .59272 L
.027 .59522 L
.02824 .59157 L
.0294 .58396 L
.03373 .54544 L
.03884 .50545 L
.04355 .47679 L
.05305 .4342 L
.06336 .40101 L
.07308 .37674 L
.08379 .355 L
.10545 .32087 L
.12484 .29727 L
.1457 .27648 L
.18688 .24424 L
.22655 .22011 L
.26471 .20101 L
.30531 .18375 L
.3444 .16934 L
.38594 .15584 L
.42597 .14423 L
.46448 .13409 L
.50544 .12425 L
.54489 .11552 L
.58282 .10774 L
.62321 .10001 L
.66208 .09305 L
.7034 .0861 L
.7432 .07979 L
.78149 .07404 L
.82224 .06824 L
.86146 .06293 L
.89918 .05805 L
.93934 .05308 L
.97619 .04871 L
s
.02476 .57125 m
.04355 .47296 L
.05312 .4268 L
.06336 .39148 L
.07376 .36388 L
.08345 .3429 L
.10545 .30572 L
.12674 .27828 L
.14686 .25713 L
.18523 .22497 L
.22606 .19827 L
.26537 .17722 L
.30317 .16 L
.34341 .14406 L
.38215 .13051 L
.42333 .11762 L
.463 .10641 L
.50115 .09654 L
.54176 .08687 L
.58085 .07825 L
.62239 .06973 L
.66242 .06206 L
.70093 .05512 L
.74189 .04817 L
.78134 .04183 L
.81927 .03604 L
.85966 .03018 L
.89852 .02479 L
.93984 .01932 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{226.5, 140.688},
  ImageMargins->{{50.625, 0}, {0, 0}},
  ImageRegion->{{-0.062096, 1.06598}, {-0.000534, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004K0000[a000`40O003h00O6Woo00<007ooOol0
oWoo000JOol00`00Oomoo`3nOol001Yoo`800?moo`006Woo00<007ooOol0h7oo1G`06Goo000JOol0
0`00Oomoo`3IOol7O00NOol001Yoo`03001oogoo0=Aoo`El02Eoo`006Woo00<007ooOol0cGoo1g`0
:Woo000JOol20034Ool:O00aOol001Yoo`03001oogoo0;aoo`Ml03]oo`006Woo00<007ooOol0^7oo
17`0@Woo000JOol00`00Oomoo`2`Ool8O016Ool001Yoo`03001oogoo0:Uoo`Ml039oo`=l01Uoo`00
6Woo00<007ooOol0Y7oo1G`0=Goo17`077oo000JOol2002POol5O00cOol7O00POol001Yoo`03001o
ogoo09]oo`Al02ioo`Yl02Moo`006Woo00<007ooOol0UWoo1G`0:Goo2G`0<Goo0009Ool50003Ool4
0005Ool00`00Oomoo`2AOol5O00WOol7O00jOol000]oo`03001oogoo009oo`03001oogoo009oo`03
001oogoo009oo`03001oogoo08aoo`El02Moo`El045oo`002goo00<007ooOol01goo00<007ooOol0
0Woo00<007ooOol0Qgoo1G`09Goo1g`0AWoo00060005Ool00`00Oomoo`07Ool00`00Oomoo`02Ool3
0022Ool5O00SOol7O01=Ool000]oo`03001oogoo00=oo`@000Eoo`03001oogoo07ioo`Al02=oo`El
05Aoo`002goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol0NGoo1G`07goo27`0>goo1G`0
6Goo0009Ool30005Ool00`00Oomoo`06Ool00`00Oomoo`1dOol5O00MOol7O00iOol:O00NOol000]o
o`03001oogoo00=oo`D000Aoo`03001oogoo06moo`El01ioo`Al03Ioo`Yl02Qoo`006Woo0P00K7oo
17`07Woo1G`0<Goo2G`0<Woo000JOol00`00Oomoo`1WOol4O00MOol5O00/Ool:O00kOol001Yoo`03
001oogoo06=oo`Al01aoo`El02Yoo`Ml04Eoo`006Woo00<007ooOol0H7oo0g`077oo17`0:goo17`0
C7oo000JOol00`00Oomoo`1MOol3O00JOol5O00WOol8O01@Ool001Yoo`03001oogoo05Uoo`Al01Qo
o`El02Eoo`Ml05Qoo`006Woo0P00Egoo0g`05goo1G`09Goo1G`0Ggoo000JOol00`00Oomoo`1COol3
O00EOol5O00SOol7O016Ool5O00IOol001Yoo`03001oogoo055oo`9l01Aoo`Al025oo`Ml04=oo`Yl
01ioo`006Woo00<007ooOol0Cgoo0W`04goo0g`087oo1G`0@Goo2G`0:7oo000JOol00`00Oomoo`1=
Ool2O00BOol3O00NOol5O00lOol:O00aOol001Yoo`8004]oo`=l011oo`Al01aoo`El03Qoo`Ul03]o
o`006Woo00<007ooOol0AWoo17`03Woo1G`06goo1G`0<goo2W`0A7oo000JOol00`00Oomoo`13Ool3
O00>Ool4O00LOol4O00aOol7O01>Ool001Yoo`03001oogoo045oo`9l00moo`9l01]oo`El031oo`El
05Eoo`006Woo00<007ooOol0?goo0W`03Woo0g`067oo1G`0;Woo1g`0FWoo000JOol00`00Oomoo`0m
Ool2O00>Ool2O00FOol5O00/Ool7O01QOol001Yoo`8003aoo`9l00eoo`=l01Aoo`Al02aoo`El06Qo
o`006Woo00<007ooOol0>Goo0W`02goo17`04goo17`0:7oo27`0KGoo0009Ool50003Ool40005Ool0
0`00Oomoo`0gOol2O00:Ool3O00COol4O00UOol7O01eOol000]oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo009oo`03001oogoo03Eoo`9l00Uoo`=l01=oo`=l02Aoo`El05ioo`El01Uoo`00
2goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0<goo0W`02Goo0W`0
4goo0g`08Woo1G`0FGoo2W`07Woo00060005Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool3000aOol2O009Ool2O00AOol4O00QOol4O01;OolCO00XOol000]oo`03001oogoo009oo`03
001oogoo009oo`03001oogoo009oo`03001oogoo02moo`9l00Uoo`9l011oo`=l01eoo`Ql04Eoo`Yl
03]oo`002goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0;Woo00=l
07ooOol01Woo0g`03goo0g`06Woo1W`0A7oo2G`0AGoo0009Ool30004Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool00`00Oomoo`0/Ool2O007Ool2O00?Ool3O00JOol3O010Ool:O01>Ool000]oo`03001o
ogoo00=oo`@000Eoo`03001oogoo02Yoo`9l00Moo`9l00ioo`=l01Yoo`=l03aoo`Ml05Qoo`006Woo
00<007ooOol0:Goo00=l07ooOol01Goo0W`03Goo0g`06Goo17`0>goo17`0Ggoo000JOol2000XOol2
O006Ool2O00=Ool2O00GOol5O00gOol8O01SOol001Yoo`03001oogoo02Eoo`9l00Moo`03O01oogoo
00Yoo`=l01Eoo`Al039oo`Yl06]oo`006Woo00<007ooOol097oo00=l07ooOol01Goo0W`02goo0W`0
57oo17`0;goo1g`0MGoo000JOol00`00Oomoo`0SOol00g`0Oomoo`05Ool00g`0Oomoo`08Ool3O00C
Ool3O00_Ool4O01lOol001Yoo`03001oogoo029oo`03O01oogoo00Aoo`9l00Uoo`9l01=oo`=l02Yo
o`Ql081oo`006Woo00<007ooOol08Goo00=l07ooOol017oo00=l07ooOol01goo0W`04Woo0g`09Woo
1g`0R7oo000JOol2000POol2O005Ool2O008Ool2O00AOol3O00TOol5O02?Ool001Yoo`03001oogoo
01ioo`03O01oogoo00Aoo`03O01oogoo00Ioo`9l011oo`=l029oo`El09Aoo`006Woo00<007ooOol0
7Goo00=l07ooOol017oo00=l07ooOol01Goo0W`03Woo17`08Goo17`0VGoo000JOol00`00Oomoo`0L
Ool00g`0Oomoo`03Ool2O006Ool2O00=Ool3O00POol5O02MOol001Yoo`03001oogoo01]oo`03O01o
ogoo00=oo`03O01oogoo00Eoo`03O01oogoo00Yoo`=l01ioo`El0:9oo`006Woo0P006goo00=l07oo
Ool00goo00=l07ooOol017oo0W`02goo0W`077oo1G`0Ygoo000JOol00`00Oomoo`0IOol00g`0Oomo
o`03Ool00g`0Oomoo`03Ool2O00;Ool2O00IOol5O02/Ool001Yoo`03001oogoo01Qoo`03O01oogoo
009oo`9l00Eoo`03O01oogoo00Uoo`9l01Ioo`El0;5oo`006Woo00<007ooOol05goo00=l07ooOol0
0Woo00=l07ooOol00goo0W`02Goo0g`057oo17`0]Woo000JOol00`00Oomoo`0FOol00g`0Oomoo`02
Ool00g`0Oomoo`03Ool00g`0Oomoo`07Ool2O00COol4O02jOol001Yoo`03001oogoo01Eoo`03O01o
ogoo009oo`03O01oogoo009oo`9l00Qoo`9l015oo`Al0;ioo`006Woo0P005Woo00El07ooOomoog`0
00Aoo`03O01oogoo00Ioo`9l011oo`=l0<9oo`006Woo00<007ooOol057oo00El07ooOomoog`000Ao
o`03O01oogoo00Eoo`9l00moo`=l0<Eoo`004Goo10001Goo00<007ooOol04goo00El07ooOomoog`0
00=oo`9l00Moo`03O01oogoo00eoo`9l0<Qoo`0047oo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol04Woo00El07ooOomoog`000=oo`03O01oogoo00Eoo`9l00eoo`=l0<Yoo`005Goo00<007oo
Ool00Woo00<007ooOol04Woo00Al07ooOoml00=oo`03O01oogoo00Eoo`03O01oogoo00]oo`9l0<eo
o`0027oo1P001goo00<007ooOol00Woo0`004Goo00Al07ooOoml00=oo`03O01oogoo00Aoo`9l00]o
o`=l0<moo`004Goo10001Goo00<007ooOol047oo00El07ooOomoog`0009oo`03O01oogoo00Aoo`03
O01oogoo00Uoo`9l0=9oo`004Goo00<007ooOol01Woo00<007ooOol047oo00Al07ooOoml009oo`03
O01oogoo00=oo`9l00Yoo`9l0=Aoo`004Goo00<007ooOol01Woo00<007ooOol03goo00Al07ooOoml
00=oo`03O01oogoo009oo`03O01oogoo00Qoo`9l0=Ioo`004Goo1@0017oo00<007ooOol03goo00=l
07ooO0000goo00=l07ooOol00Woo00=l07ooOol01Woo0g`0f7oo000JOol00`00Oomoo`0>Ool00g`0
Ooml0003Ool00g`0Oomoo`02Ool00g`0Oomoo`05Ool2O03KOol001Yoo`8000moo`03O01oog`0009o
o`03O01oogoo009oo`03O01oogoo00Aoo`9l0=eoo`006Woo00<007ooOol03Goo00=l07ooO0000Woo
00Al07ooOomoo`9l00Eoo`9l0=moo`006Woo00<007ooOol03Goo00El07ooO01oog`000=oo`03O01o
ogoo00=oo`9l0>5oo`006Woo00<007ooOol037oo00El07ooO01oog`000=oo`03O01oogoo00=oo`03
O01oogoo0>5oo`006Woo00<007ooOol02goo00El07ooO01oog`000=oo`03O01oogoo00=oo`03O01o
ogoo0>9oo`006Woo0P0037oo00El07ooO01oog`0009oo`03O01oogoo009oo`9l0>Eoo`006Woo00<0
07ooOol02Woo00El07ooO01oog`0009oo`03O01oogoo009oo`03O01oogoo0>Eoo`006Woo00<007oo
Ool02Woo0W`000Eoog`0Oomoog`000Aoo`03O01oogoo0>Ioo`006Woo00<007ooOol02Goo00Al07oo
O01l009oo`04O01oogooOol2O00?Ool50004Ool4000UOol30003Ool4000SOol30004Ool4000ROol4
0004Ool4000NOol50003Ool40004Ool4000@Ool001Yoo`03001oogoo00Uoo`=l00=oo`04O01oogoo
O00AOol01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol08goo00D007ooOomoo`0000Ao
o`03001oogoo01moo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`0NOol00`00Oomo
o`02Ool01000Oomoo`0017oo00<007ooOol07Goo00<007ooOol00Woo00<007ooOol00Woo00@007oo
Ool000Aoo`03001oogoo00eoo`006Woo00<007ooOol027oo00Al07ooO01l009oo`04O01oogooO00C
Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`0SOol01@00Oomoogoo000017oo00<007oo
Ool07goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo01ioo`03001oogoo009oo`04
001oogoo0004Ool00`00Oomoo`0MOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo
00<007ooOol03Goo000JOol20009Ool3O002Ool017`0Oomoog`05Goo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol07goo1P000Woo00<007ooOol00Woo00<007ooOol07goo00D007ooOomoo`00
009oo`03001oogoo009oo`03001oogoo01ioo`03001oogoo009oo`04001oogoo0004Ool00`00Oomo
o`0MOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007ooOol03Goo000JOol0
0`00Oomoo`08Ool3O0001GooO01oogooO0005goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool087oo00@007ooOol000=oo`03001oogoo009oo`03001oogoo01moo`@000=oo`03001oogoo009o
o`03001oogoo01moo`@000=oo`03001oogoo009oo`03001oogoo01eoo`03001oogoo009oo`03001o
ogoo009oo`04001oogoo0004Ool00`00Oomoo`0=Ool001Yoo`03001oogoo00Qoo`9l009oo`04O01o
ogooO00HOol01@00Oomoogoo000017oo00<007ooOol087oo00@007ooOol000=oo`03001oogoo009o
o`03001oogoo01moo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo01ioo`03001oogoo009o
o`04001oogoo0004Ool00`00Oomoo`0MOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`00
17oo00<007ooOol03Goo000JOol00`00Oomoo`07Ool3O0001GooO01oogooO0005Goo00D007ooOomo
o`0000=oo`03001oogoo009oo`03001oogoo025oo`03001oo`0000=oo`03001oogoo009oo`03001o
ogoo021oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo01ioo`03001oogoo009oo`04001o
ogoo0004Ool00`00Oomoo`0KOol30004Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007ooOol0
3Goo000JOol00`00Oomoo`07Ool2O002Ool00g`0Ooml000GOol30005Ool4000UOol20004Ool4000T
Ool30003Ool4000ROol40004Ool4000POol00`00Oomoo`03Ool40004Ool4000@Ool001Yoo`03001o
ogoo00Moo`9l0004Ooml07ooO03aOol001Yoo`8000Moo`=l0003Ooml07`00?9oo`006Woo00<007oo
Ool01Woo0W`000Aoog`0Ooml0?9oo`006Woo00<007ooOol01Woo0W`000=oog`0O000jGoo0P000Woo
0P0017oo000JOol00`00Oomoo`05Ool4O0000gooO01oo`3YOol01000Oomoo`001Goo000JOol00`00
Oomoo`05Ool2O0000gooO01l003/Ool20006Ool001Aoo`d000El0>8000]oo`8000Ioo`006Woo00<0
07ooOol017oo0W`000Aoog`0O00000Yoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uo
o`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uo
o`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qo
o`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qo
o`03001oogoo00ioo`04001oogoo0005Ool001Yoo`03001oogoo00Aoo`Al02=oo`03001oogoo02ao
o`03001oogoo02]oo`03001oogoo02]oo`03001oogoo02]oo`03001oogoo00eoo`80009oo`8000Ao
o`006Woo00<007ooOol017oo00=l07ooO000mgoo000JOol00`00Oomoo`03Ool4O03gOol001Yoo`03
001oogoo00=oo`=l0?Qoo`006Woo0P0017oo0g`0n7oo000JOol00`00Oomoo`03Ool2O03iOol001Yo
o`03001oogoo00=oo`9l0?Uoo`006Woo00<007ooOol00goo00=l07ooOol0n7oo000JOol00`00Oomo
o`02Ool2O03jOol001Yoo`8000=oo`9l0?Yoo`006Woo00<007ooOol00Woo0W`0nWoo000JOol00`00
Oomoo`02Ool00g`0Oomoo`3iOol001Yoo`03001oogoo009oo`03O01oogoo0?Uoo`006Woo00@007oo
Oomoo`9l0?]oo`006Woo00@007ooOomoo`9l0?]oo`006Woo0P000Woo0W`0ngoo000JOol01@00Oomo
ogooO000o7oo000JOol01@00OomoogooO000o7oo000JOol00`00Oomoo`02O03lOol001Yoo`03001o
ogoo009l0?aoo`006Woo0P0000=oog`0O000o7oo000JOol01000Oomoog`0oGoo000JOol01000Ooml
07`0oGoo000AOol40005Ool01000Ooml07`0oGoo000@Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
1000Ooml07`0oGoo000EOol00`00Oomoo`02Ool01000Ooml07`0oGoo000EOol00`00Oomoo`02Ool2
00000g`0Oomoo`3lOol0015oo`@000Eoo`03001l07`00?ioo`004Goo00<007ooOol01Woo00<007`0
O000oWoo000AOol00`00Oomoo`06Ool00`00O01l003nOol0015oo`D000Aoo`03001l07`00?ioo`00
6Woo00<007`0O000oWoo000JOol3O03nOol001Yoo`9l0?moo`006Woo0W`0ogoo000JOol00`00O01o
o`3nOol001Yoo`9l0?moo`006Woo0W`0ogoo000JOol2O03oOol001Yoo`9l0?moo`006Woo0W`0ogoo
000JOol00g`0Oomoo`3nOol001Yoo`03O01oogoo0?ioo`006Woo0P00ogoo000JOol00`00Oomoo`3n
Ool001Yoo`03001oogoo0?ioo`006Woo00<007ooOol0oWoo003oOolLOol00?mooaaoo`00ogoo77oo
003oOolLOol00?mooaaoo`00ogoo77oo003oOolLOol00?mooaaoo`00ogoo77oo003oOolLOol00?mo
oaaoo`006Goo0P0000=oo`000000oGoo000HOol00`00Oomoo`02003nOol001Qoo`05001oogooOol0
003nOol001Qoo`05001oogooOol0003nOol001Qoo`05001oogooOol0003nOol001Moo`80009oo`80
0?ioo`00ogoo77oo003oOolLOol00?mooaaoo`00ogoo77oo003oOolLOol00?mooaaoo`00ogoo77oo
0000\
\>"],
  ImageRangeCache->{{{-17.5625, 300.75}, {174.875, 0}} -> {-11.4906, \
-18.3948, 0.540583, 0.224358}}]
}, Open  ]],

Cell["\<\
This example shows that solutions of a second-order ordinary \
differential equation are easy to derive if we know the symmetries of the \
equation.\
\>", "Text",
  CellTags->{
  "second-order ordinary differential equation", "classification", 
    "quadrature"}],

Cell[TextData[
"Actually, we did not use in our calculations the complete theory of Lie \
discussed above. In this second example, we only used the existence of a \
certain symmetry. This symmetry is sufficient to determine the corresponding \
canonical variables. Thus, a canonical transformation can be carried out \
independently of the classification scheme by Lie. The canonical \
transformation of the equation into new variables simplified the \
representation. In both examples, this simplification was the main step \
toward the solution. However, in Lie\[CloseCurlyQuote]s theory, there exists \
a more efficient way to detect the solvability of the equation. In turn, \
there is a procedure which reduces the complete calculations to quadratures. \
The following section will discuss this procedure in detail."], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.4.2.2 The Integrating Factor Method", "Subsection",
  CellTags->"Method of integrating factor"],

Cell[TextData[{
  "In S",
  ButtonBox["ection 4.4.1.2,",
    ButtonData:>{"symmet2.nb", "Integrating factor"},
    ButtonStyle->"Hyperlink"],
  " we discussed the method of an integrating factor for a first-order ODE. \
We remarked that this method has a generalization to higher-order equations. \
In this section, we generalize the method to second-order equations. The main \
result of this procedure is that a second-order equation can be solved by \
pure quadratures if the equation possesses an appropriate number of \
symmetries. The solution procedure based on integrating factors is completely \
algorithmic. The algorithm consists of five steps which Lie discussed in his \
numerous papers (cf. ",
  ButtonBox["Engel and Heegaard [1912]",
    ButtonData:>{"Literat.nb", "Enge-12"},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text",
  CellTags->{
  "integrating factor", "quadrature", "algorithm for integrating factors"}],

Cell[TextData[{
  "According to Lie, we can state the integration procedure in the following \
way: If a second-order equation admits a finite symmetry of dimension ",
  Cell[BoxData[
      \(TraditionalForm\`r \[GreaterEqual] 2\)]],
  ", it can be integrated with a group-theoretic quadrature method by"
}], "Text",
  CellTags->{"integration procedure", "group theoretic quadrature"}],

Cell[TextData[{
  "Computing the Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  ". A basis of  ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  " is the set  ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_1\)]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_2\)]],
  ", \[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_r\)]],
  ". The tangent vector fields ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_i\)]],
  " follow by appropriately specifying the group constants."
}], "ListItem",
  CellDingbat->"1.",
  CellTags->{
  "five steps of integration", "Lie algebra", "tangent vector field", 
    "group constant"}],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`r = 2\)]],
  ", go to step 3;\nif ",
  Cell[BoxData[
      \(TraditionalForm\`r > 2\)]],
  ",  distinguish any two-dimensional subalgebra ",
  Cell[BoxData[
      \(TraditionalForm\`L\_2\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  ".\nIf ",
  Cell[BoxData[
      \(TraditionalForm\`r = 1\)]],
  ", the order of the equation may be lowered;\nif ",
  Cell[BoxData[
      \(TraditionalForm\`r = 0\)]],
  ", the group method is not useful."
}], "ListItem",
  CellDingbat->"2."],

Cell[TextData[{
  "Calculate the Lie determinants ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox[
            RowBox[{
              StyleBox["d",
                FontSlant->"Italic"], "\[CapitalDelta]"}]], "i"], 
        TraditionalForm]]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\)]],
  " and determine the two first integrals by integration. The Lie \
determinants are defined by"
}], "ListItem",
  CellDingbat->"3.",
  CellTags->{"determinant", "Lie determinant", "first integrals"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox[
            StyleBox[
              RowBox[{
                StyleBox["d",
                  FontSlant->"Italic"], "\[CapitalDelta]"}]], "1"], " ", "=", 
          " ", 
          RowBox[{"det", "(", GridBox[{
                {
                  StyleBox["dx",
                    FontSlant->"Italic"], 
                  StyleBox["du",
                    FontSlant->"Italic"], 
                  StyleBox[\(du'\),
                    FontSlant->"Italic"]},
                {\(\[Xi]\_2\), \(\[Phi]\_2\), \(\[Phi]\_2\%'\)},
                {"1", \(u'\), "\[Omega]"}
                }], ")"}]}], ",", "        ", 
        RowBox[{
          SubscriptBox[
            StyleBox[
              RowBox[{
                StyleBox["d",
                  FontSlant->"Italic"], "\[CapitalDelta]"}]], "2"], "=", 
          " ", 
          RowBox[{"det", "(", GridBox[{
                {\(\[Xi]\_1\), \(\[Phi]\_1\), \(\[Phi]\_1'\)},
                {
                  StyleBox["dx",
                    FontSlant->"Italic"], 
                  StyleBox["du",
                    FontSlant->"Italic"], 
                  StyleBox[\(du\^'\),
                    FontSlant->"Italic"]},
                {"1", \(u'\), "\[Omega]"}
                }], ")"}]}]}], TraditionalForm]], "NumberedEquation",
  CellTags->"Lie matrix"],

Cell["and", "ListItem"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[CapitalDelta]", " ", "=", " ", 
          RowBox[{"det", 
            FormBox[
              RowBox[{"(", GridBox[{
                    {\(\[Xi]\_1\), \(\[Phi]\_1\), \(\[Phi]\_1\%'\)},
                    {\(\[Xi]\_2\), \(\[Phi]\_2\), \(\[Phi]\_2\%'\)},
                    {"1", \(u'\), "\[Omega]"}
                    }], ")"}],
              "TraditionalForm"]}]}], ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i\)]],
  " are the infinitesimals corresponding to the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Phi]\_i\%'\)\)]],
  " denote the first extensions of the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i\)]],
  ". The first integrals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_i\)]],
  " related to the Lie determinants ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox[
            RowBox[{
              StyleBox["d",
                FontSlant->"Italic"], "\[CapitalDelta]"}]], "i"], 
        TraditionalForm]]],
  " are given by"
}], "ListItem",
  CellTags->"infinitesimals"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Psi]\_i\), " ", "=", " ", 
          RowBox[{
            RowBox[{"\[Integral]", 
              FractionBox[
                SubscriptBox[
                  StyleBox[
                    RowBox[{
                      StyleBox["d",
                        FontSlant->"Italic"], "\[CapitalDelta]"}]], "i"], 
                "\[CapitalDelta]"]}], " ", "=", " ", \(c\_i\)}]}], ",", 
        "         ", \(i = 1\), ",", "2."}], TraditionalForm]], 
  "NumberedEquation",
  CellTags->"eq-21"],

Cell[TextData[{
  "The constants ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " denote the integration constants of the ODE."
}], "ListItem"],

Cell["\<\
Solve one of the two integrals with respect to the first-order \
derivative and substitute the result into the remaining relation.\
\>", 
  "ListItem",
  CellDingbat->"4."],

Cell[TextData[{
  "If we can solve the resulting relation from step 4 with respect to the \
unknown function ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", we end up with an explicit solution. Otherwise, we get the solution in \
an implicit form."
}], "ListItem",
  CellDingbat->"5."],

Cell[TextData[{
  "These five steps are implemented in the package ",
  StyleBox["MathLie.",
    FontSlant->"Italic"],
  " The functions of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " carry out the necessary calculations automatically. To show how the \
solution procedure works interactively, we demonstrate the algorithm by two \
examples. The functions needed for the interactive calculation are ",
  StyleBox["Infinitesimals[]", "MmaText"],
  " for the determination of the symmetries, the function ",
  StyleBox["SecondOrderAlgebras[] for the", "MmaText"],
  " extraction of the second-order subalgebras, the functions ",
  StyleBox["DeltaMatrix[]", "MmaText"],
  ", and the ",
  StyleBox["FirstIntegral[], which", "MmaText"],
  " are responsible for the determination of the integrals."
}], "Text",
  PageBreakBelow->True,
  CellTags->{
  "Infinitesimals[]", "SecondOrderAlgebras[]", "subalgebra", "DeltaMatrix[]", 
    "FirstIntegral[]", "determination of integrals"}],

Cell[TextData[StyleBox["Example 1",
  FontFamily->"Times New Roman",
  FontWeight->"Bold"]], "Text"],

Cell[TextData[
"The first example considers a non-linear second-order equation in which the \
nonlinearity is given by the square of the first derivative. This non-linear \
term is multiplied by a real constant \[Alpha]:"], "Text",
  CellTags->"nonlinear second-order equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(firstExample\  = \ 
      \[PartialD]\_{x, 2}u[x] - \[Alpha]\ \((\[PartialD]\_x u[x])\)\^2; 
    firstExample // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-\[Alpha]\)\ u\_x\%2 + u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The infinitesimal symmetries are derived by the function ",
  StyleBox["Infinitesimals[], ", "MmaText"],
  "which is part of the package ",
  StyleBox["MathLie.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->{"infinitesimal symmetries", "Infinitesimals[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      Infinitesimals[firstExample, u, x, {\[Alpha]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{x, 2}u[x]}]; infi // LTF\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              
              StyleBox[
                \(\(\(-E\^\(\(-u\)\ \[Alpha]\)\)\ k6 + 
                      E\^\(u\ \[Alpha]\)\ k7 + E\^\(u\ \[Alpha]\)\ k1\ x + 
                      k8\ \[Alpha] + k2\ x\ \[Alpha]\)\/\[Alpha]\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{
              "k4", "+", \(\((k5 + E\^\(\(-u\)\ \[Alpha]\)\ k6)\)\ x\), "-", 
                StyleBox[\(\(E\^\(\(-u\)\ \[Alpha]\)\ k3\)\/\[Alpha]\),
                  ScriptLevel->0], "-", \(k2\ x\^2\ \[Alpha]\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Power[ \[Alpha], -1], 
            Plus[ 
              Times[ -1, 
                Power[ E, 
                  Times[ -1, u, \[Alpha]]], k6], 
              Times[ 
                Power[ E, 
                  Times[ u, \[Alpha]]], k7], 
              Times[ 
                Power[ E, 
                  Times[ u, \[Alpha]]], k1, x], 
              Times[ k8, \[Alpha]], 
              Times[ k2, x, \[Alpha]]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k4, 
            Times[ 
              Plus[ k5, 
                Times[ 
                  Power[ E, 
                    Times[ -1, u, \[Alpha]]], k6]], x], 
            Times[ -1, 
              Power[ E, 
                Times[ -1, u, \[Alpha]]], k3, 
              Power[ \[Alpha], -1]], 
            Times[ -1, k2, 
              Power[ x, 2], \[Alpha]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The option ",
  StyleBox["SubstitutionRules", "MmaText"],
  " is set to the second-order derivative ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(x, x\)\)]],
  " to help ",
  StyleBox["Infinitesimals[]", "MmaText"],
  " to find the side conditions more easily. The result is a symmetry group \
with eight group parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k\_i\)]],
  StyleBox[", i ",
    FontSlant->"Italic"],
  "= 1,2,\[Ellipsis]8. The infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1 = xi[1]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1 = \ phi[1]\)]],
  " are represented in a pure function form. The group constants ",
  StyleBox["ki",
    FontSlant->"Italic"],
  " characterize the symmetries of the equation. We note that this \
eight-parameter group is the largest group a second-order ODE can have. Lie \
proved that such an equation allows a transformation reducing the original \
equation to the simple form ",
  Cell[BoxData[
      \(TraditionalForm\`\(y'\)'\  = 0. \)]],
  " This reduction is always possible if a second-order equation allows a \
symmetry group of order eight (Scheffers and ",
  ButtonBox["Lie [1891]",
    ButtonData:>{"Literat.nb", "Sche-1891"},
    ButtonStyle->"Hyperlink"],
  "). Thus, the above equation should be solvable."
}], "Text",
  CellTags->{
  "SubstitutionRules", "Infinitesimals[]", "eight parameter group", 
    "largest group of a second-order ODE", "solvable"}],

Cell[TextData[{
  "To detect that the non-linear second-order ODE is solvable, we examine the \
algebraic properties of the corresponding Lie algebra. If we can find a \
solvable subgroup of order two in the eight-dimensional algebra, we \
succeeded. This argument is based on the fact that all second-order Lie \
algebras are solvable. To detect all the solvable subgroups, we apply the \
function ",
  StyleBox["SecondOrderAlgebras[]", "MmaText"],
  " to the infinitesimals. This function determines all the second-order \
solvable subalgebras and represents them by a set of rules for the group \
constants:"
}], "Text",
  CellTags->{
  "Lie algebra", "subgroup of order two", "SecondOrderAlgebras[]", 
    "second-order solvable subalgebras", "group constants"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(secAlgebras\  = SecondOrderAlgebras[infi, {u}, {x}, {\[Alpha]}]\)], 
  "Input"],

Cell[BoxData[
    \({{{k1 \[Rule] 1}, {k2 \[Rule] 1}}, {{k1 \[Rule] 1}, {k5 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k7 \[Rule] 1}}, {{k1 \[Rule] 1}, {k8 \[Rule] 1}}, {{
          k2 \[Rule] 1}, {k5 \[Rule] 1}}, {{k2 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k2 \[Rule] 1}, {k8 \[Rule] 1}}, {{k3 \[Rule] 1}, {k4 \[Rule] 1}}, {{
          k3 \[Rule] 1}, {k5 \[Rule] 1}}, {{k3 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k3 \[Rule] 1}, {k8 \[Rule] 1}}, {{k4 \[Rule] 1}, {k5 \[Rule] 1}}, {{
          k4 \[Rule] 1}, {k7 \[Rule] 1}}, {{k4 \[Rule] 1}, {k8 \[Rule] 1}}, {{
          k5 \[Rule] 1}, {k6 \[Rule] 1}}, {{k5 \[Rule] 1}, {k7 \[Rule] 1}}, {{
          k5 \[Rule] 1}, {k8 \[Rule] 1}}, {{k6 \[Rule] 1}, {k8 \[Rule] 1}}, {{
          k7 \[Rule] 1}, {k8 \[Rule] 1}}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["SecondOrderAlgebras[]", "MmaText"],
  " returns a list containing substitution rules for second-order algebras. \
The input of the function are the infinitesimals, the dependent and \
independent variables, and the parameters of the equation. This set of rules \
is useful in selecting one of the possible two-dimensional solvable \
subalgebras which will serve to solve the equation. For the following \
calculation, we select the seventh rule to represent the set of \
infinitesimals by"
}], "Text",
  CellTags->{"SecondOrderAlgebras[]", "infinitesimals", "subalgebra"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infhelp\  = \ 
      \(\(\(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\)\  /. 
                k8 \[Rule] \[Beta]\)\  /. 
              secAlgebras\[LeftDoubleBracket]7\[RightDoubleBracket]\)\  /. {
              k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 0, 
              k5 \[Rule] 0, k6 \[Rule] 0, k7 \[Rule] 0, k8 \[Rule] 0}\)\  /. 
          u \[Rule] u[x] // Simplify\)], "Input"],

Cell[BoxData[
    \({{{\(-x\^2\)\ \[Alpha]}, {x + \[Beta]}}, {{0}, {\[Beta]}}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Actually, we changed the subgroup by choosing the group constant ",
  Cell[BoxData[
      \(TraditionalForm\`k8\)]],
  " to be an arbitrary constant \[Beta]. In addition to the infinitesimals of \
the subgroup, we need the ",
  ButtonBox["Lie matrix",
    ButtonData:>"Lie matrix",
    ButtonStyle->"Hyperlink"],
  " for the integration. The function ",
  StyleBox["DeltaMatrix[]", "MmaText"],
  " serves to create this kind of matrix, which is defined by relation \
(4.61). "
}], "Text",
  CellTags->{"Lie matrix", "DeltaMatrix[]", "matrix"}],

Cell[TextData[{
  "Lie's matrix, part of the integrating factor, is calculated by the \
function ",
  StyleBox["DeltaMatrix[]", "MmaText"],
  ". This function needs information on the independent and dependent \
variables on the right-hand side \[Omega] of the ODE, the order of the ODE, \
and the selected subgroup of the algebra:"
}], "Text",
  CellTags->{
  "Lie's matrix", "integrating factor", "DeltaMatrix[]", "subgroup"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalDelta]matrix = 
      DeltaMatrix[x, u, \[Alpha]\ \((\[PartialD]\_x u[x])\)\^2, 2, infhelp
        \ ]; TableForm[\[CapitalDelta]matrix] // LieTraditionalForm\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-x\^2\)\ \[Alpha]\), \(x + \[Beta]\), 
            \(1 + 2\ x\ \[Alpha]\ u\_x\)},
          {"0", "\[Beta]", "0"},
          {"1", \(u\_x\), \(\[Alpha]\ u\_x\%2\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The result is a 3\[Times]3 matrix containing the infinitesimals, \
the first prolongation of the two subgroups, and the right-hand side of the \
equation. The determinant of this matrix \
\>", "Text",
  CellTags->{
  "infinitesimals", "matrix", "first prolongation", "prolongation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(-\[Beta]\) - 2\ x\ \[Alpha]\ \[Beta]\ u\_x - 
      x\^2\ \[Alpha]\^2\ \[Beta]\ u\_x\%2\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "is a non-vanishing expression containing a second-order polynomial of \
first derivatives. The coefficients of this polynomial depend on the \
independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and the parameters \[Alpha] and \[Beta]. Inserting the Lie matrix into \
equation (",
  ButtonBox["4.62",
    ButtonData:>"eq-21",
    ButtonStyle->"Hyperlink"],
  "), we are able to calculate the first integrals of the non-linear ODE"
}], "Text",
  CellTags->{
  "second-order polynomial", "first integral", "calculate first integrals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(integrals\  = \ 
      Thread[FirstIntegral[x, u, \[CapitalDelta]matrix, {1, 2}] == 
          \ {c1, c2}]; \(integrals // LieTraditionalForm\) // TableForm\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(1\/\(x\ \[Alpha]\)\),
                  ScriptLevel->0], "-", 
                StyleBox[\(1\/\(x\ \[Alpha]\ \((1 + x\ \[Alpha]\ u\_x)\)\)\),
                  ScriptLevel->0]}], "==", "c1"}]},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(1\/\(x\ \[Alpha]\)\),
                    ScriptLevel->0]}], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(u\/\[Beta]\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                
                StyleBox[
                  \(Log[1 + x\ \[Alpha]\ u\_x]\/\(\[Alpha]\ \[Beta]\)\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(1\/\(x\ \[Alpha]\ \((1 + x\ \[Alpha]\ u\_x)\)\)\),
                  ScriptLevel->0]}], "==", "c2"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ 
              Power[ x, -1], 
              Power[ \[Alpha], -1]], 
            Times[ -1, 
              Power[ x, -1], 
              Power[ \[Alpha], -1], 
              Power[ 
                Plus[ 1, 
                  Times[ x, \[Alpha], 
                    Subscript[ u, x]]], -1]]], c1], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Power[ x, -1], 
              Power[ \[Alpha], -1]], 
            Times[ u, 
              Power[ \[Beta], -1]], 
            Times[ -1, 
              Power[ \[Alpha], -1], 
              Power[ \[Beta], -1], 
              Log[ 
                Plus[ 1, 
                  Times[ x, \[Alpha], 
                    Subscript[ u, x]]]]], 
            Times[ 
              Power[ x, -1], 
              Power[ \[Alpha], -1], 
              Power[ 
                Plus[ 1, 
                  Times[ x, \[Alpha], 
                    Subscript[ u, x]]], -1]]], c2]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result contains two expressions for the integrals combining the \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and its first-order derivative in an algebraic way. These two first \
integrals define two surfaces in the space ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u, u')\)\)]],
  ". The projection of the intersection of these two surfaces onto the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane defines the solution for which we are looking. The following figure \
 represents a case with fixed values ",
  Cell[BoxData[
      \(TraditionalForm\`c\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_2\)]],
  ". "
}], "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.55112e-017 1.04977 -0.0679587 1.04977 [
[.04138 .24075 -6 -8.74209 ]
[.04138 .24075 0 .25791 ]
[.18378 .18471 -17.6536 -9 ]
[.18378 .18471 .34636 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.49429 .06259 -15.8666 -9 ]
[.49429 .06259 2.13343 0 ]
[.664 -0.00409 -4.99101 -9 ]
[.664 -0.00409 1.00899 0 ]
[.29165 .07573 -9.31117 -15 ]
[.29165 .07573 .68883 0 ]
[.76189 .08851 0 -6.17016 ]
[.76189 .08851 12 2.82984 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.93905 .3598 0 -5.91371 ]
[.93905 .3598 6 3.08629 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02136 .28234 -12 -2.75687 ]
[.02136 .28234 0 6.24313 ]
[.0139 .32909 -24 -2.79643 ]
[.0139 .32909 0 6.20357 ]
[.00622 .37728 -6 -2.83733 ]
[.00622 .37728 0 6.16267 ]
[-0.00171 .42696 -18 -2.87964 ]
[-0.00171 .42696 0 6.12036 ]
[-0.00989 .47822 -6 -2.92343 ]
[-0.00989 .47822 0 6.07657 ]
[-0.05457 .39542 -16 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .84114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.03716 .25514 m
.68874 0 L
s
.05093 .24975 m
.0557 .25425 L
s
[(0)] .04138 .24075 1 .94269 Mshowa
.19287 .19417 m
.19742 .1989 L
s
[(0.5)] .18378 .18471 .96152 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(1)] .3345 .12542 .86223 1 Mshowa
.50225 .07302 m
.50623 .07824 L
s
[(1.5)] .49429 .06259 .76295 1 Mshowa
.67126 .00684 m
.67489 .01231 L
s
[(2)] .664 -0.00409 .66367 1 Mshowa
.125 Mabswid
.07869 .23888 m
.08153 .2416 L
s
.10676 .22788 m
.10957 .23064 L
s
.13514 .21677 m
.13793 .21955 L
s
.16384 .20553 m
.1666 .20834 L
s
.22223 .18267 m
.22493 .18554 L
s
.25192 .17104 m
.25459 .17394 L
s
.28195 .15928 m
.28459 .16221 L
s
.31233 .14739 m
.31494 .15034 L
s
.37416 .12318 m
.37669 .12619 L
s
.40562 .11086 m
.40812 .1139 L
s
.43745 .0984 m
.43991 .10147 L
s
.46966 .08579 m
.47208 .08889 L
s
.53524 .06011 m
.53759 .06327 L
s
.56863 .04703 m
.57093 .05022 L
s
.60242 .0338 m
.60468 .03702 L
s
.63663 .0204 m
.63885 .02365 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.74959 .09308 m
.74344 .09536 L
s
[(-2)] .76189 .08851 -1 .37115 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.92653 .36374 m
.92027 .3657 L
s
[(2)] .93905 .3598 -1 .31416 Mshowa
.125 Mabswid
.77448 .13116 m
.77078 .1325 L
s
.79849 .16789 m
.79478 .16921 L
s
.82168 .20336 m
.81796 .20465 L
s
.86572 .27073 m
.86199 .27197 L
s
.88666 .30275 m
.88291 .30397 L
s
.90691 .33374 m
.90316 .33494 L
s
.72377 .05359 m
.72009 .05499 L
s
.69697 .0126 m
.69331 .01403 L
s
.94552 .3928 m
.94176 .39396 L
s
.96393 .42096 m
.96017 .4221 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
55.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
55.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
56.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.0336 .2776 m
.03972 .27523 L
s
[(-5)] .02136 .28234 1 -0.38736 Mshowa
.02618 .32445 m
.03231 .32212 L
s
[(-2.5)] .0139 .32909 1 -0.37857 Mshowa
.01853 .37273 m
.02468 .37045 L
s
[(0)] .00622 .37728 1 -0.36948 Mshowa
.01064 .42252 m
.01681 .42029 L
s
[(2.5)] -0.00171 .42696 1 -0.36008 Mshowa
.0025 .47388 m
.00869 .47171 L
s
[(5)] -0.00989 .47822 1 -0.35035 Mshowa
.125 Mabswid
.03213 .28686 m
.03581 .28544 L
s
.03066 .29617 m
.03433 .29476 L
s
.02917 .30554 m
.03285 .30413 L
s
.02768 .31496 m
.03136 .31356 L
s
.02467 .33398 m
.02835 .3326 L
s
.02314 .34358 m
.02683 .3422 L
s
.02161 .35324 m
.0253 .35186 L
s
.02007 .36295 m
.02376 .36158 L
s
.01697 .38256 m
.02066 .38121 L
s
.0154 .39246 m
.0191 .39111 L
s
.01382 .40242 m
.01752 .40107 L
s
.01223 .41244 m
.01593 .4111 L
s
.00903 .43266 m
.01273 .43133 L
s
.00741 .44287 m
.01112 .44155 L
s
.00578 .45314 m
.00949 .45183 L
s
.00414 .46348 m
.00786 .46217 L
s
.03506 .2684 m
.03873 .26697 L
s
.03651 .25925 m
.04018 .25782 L
s
.00084 .48435 m
.00455 .48305 L
s
gsave
-0.05457 .39542 -77 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
57.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
57.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(') show
75.000000 14.437500 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .91114 L
0 .91114 L
closepath
clip
newpath
.40857 .71318 m .41716 .69633 L .42971 .70742 L .651 .753 .924 r
F
.40857 .71318 m .39592 .70218 L .41716 .69633 L F
.42971 .70742 m .43857 .69045 L .45101 .70162 L F
.42971 .70742 m .41716 .69633 L .43857 .69045 L F
.39592 .70218 m .40444 .68509 L .41716 .69633 L F
.39592 .70218 m .38309 .69102 L .40444 .68509 L F
.45101 .70162 m .46016 .68451 L .47248 .69578 L F
.45101 .70162 m .43857 .69045 L .46016 .68451 L F
.41716 .69633 m .42595 .67911 L .43857 .69045 L F
.41716 .69633 m .40444 .68509 L .42595 .67911 L F
.47248 .69578 m .48192 .67854 L .49413 .68989 L F
.47248 .69578 m .46016 .68451 L .48192 .67854 L F
.38309 .69102 m .39152 .67367 L .40444 .68509 L F
.38309 .69102 m .37007 .67969 L .39152 .67367 L F
.43857 .69045 m .44765 .67309 L .46016 .68451 L F
.43857 .69045 m .42595 .67911 L .44765 .67309 L F
.49413 .68989 m .50385 .67251 L .51595 .68395 L F
.49413 .68989 m .48192 .67854 L .50385 .67251 L F
.40444 .68509 m .41314 .6676 L .42595 .67911 L F
.40444 .68509 m .39152 .67367 L .41314 .6676 L F
.46016 .68451 m .46952 .66702 L .48192 .67854 L F
.46016 .68451 m .44765 .67309 L .46952 .66702 L F
.51595 .68395 m .52597 .66644 L .53795 .67798 L F
.51595 .68395 m .50385 .67251 L .52597 .66644 L F
.37007 .67969 m .37841 .66208 L .39152 .67367 L F
.37007 .67969 m .35685 .66819 L .37841 .66208 L F
.42595 .67911 m .43495 .66149 L .44765 .67309 L F
.42595 .67911 m .41314 .6676 L .43495 .66149 L F
.48192 .67854 m .49157 .6609 L .50385 .67251 L F
.48192 .67854 m .46952 .66702 L .49157 .6609 L F
.31451 .47225 m .30314 .60192 L .30689 .4878 L 0 0 .355 r
F
.53795 .67798 m .54826 .66033 L .56013 .67195 L .651 .753 .924 r
F
.53795 .67798 m .52597 .66644 L .54826 .66033 L F
.39152 .67367 m .40014 .65592 L .41314 .6676 L F
.39152 .67367 m .37841 .66208 L .40014 .65592 L F
.44765 .67309 m .45693 .65532 L .46952 .66702 L F
.44765 .67309 m .43495 .66149 L .45693 .65532 L F
.50385 .67251 m .5138 .65474 L .52597 .66644 L F
.50385 .67251 m .49157 .6609 L .5138 .65474 L F
.56013 .67195 m .57074 .65416 L .58249 .66588 L F
.56013 .67195 m .54826 .66033 L .57074 .65416 L F
.35685 .66819 m .3651 .65032 L .37841 .66208 L F
.35685 .66819 m .34343 .65653 L .3651 .65032 L F
.41314 .6676 m .42206 .64971 L .43495 .66149 L F
.41314 .6676 m .40014 .65592 L .42206 .64971 L F
.46952 .66702 m .4791 .64911 L .49157 .6609 L F
.46952 .66702 m .45693 .65532 L .4791 .64911 L F
.52597 .66644 m .53621 .64853 L .54826 .66033 L F
.52597 .66644 m .5138 .65474 L .53621 .64853 L F
.58249 .66588 m .59341 .64795 L .60503 .65976 L .65 .753 .924 r
F
.58249 .66588 m .57074 .65416 L .59341 .64795 L F
.31451 .47225 m .31401 .53412 L .30314 .60192 L 0 0 .355 r
F
.30383 .45893 m .31401 .53412 L .31451 .47225 L .867 .699 .174 r
F
.37841 .66208 m .38694 .64406 L .40014 .65592 L .651 .753 .924 r
F
.37841 .66208 m .3651 .65032 L .38694 .64406 L F
.43495 .66149 m .44415 .64345 L .45693 .65532 L F
.43495 .66149 m .42206 .64971 L .44415 .64345 L F
.49157 .6609 m .50144 .64285 L .5138 .65474 L F
.49157 .6609 m .4791 .64911 L .50144 .64285 L F
.54826 .66033 m .55881 .64227 L .57074 .65416 L F
.54826 .66033 m .53621 .64853 L .55881 .64227 L F
.60503 .65976 m .61626 .64169 L .62776 .6536 L .65 .753 .924 r
F
.60503 .65976 m .59341 .64795 L .61626 .64169 L F
.34343 .65653 m .35158 .63837 L .3651 .65032 L .651 .753 .924 r
F
.34343 .65653 m .32981 .64468 L .35158 .63837 L F
.40014 .65592 m .40897 .63775 L .42206 .64971 L F
.40014 .65592 m .38694 .64406 L .40897 .63775 L F
.45693 .65532 m .46643 .63714 L .4791 .64911 L F
.45693 .65532 m .44415 .64345 L .46643 .63714 L F
.5138 .65474 m .52398 .63655 L .53621 .64853 L F
.5138 .65474 m .50144 .64285 L .52398 .63655 L F
.57074 .65416 m .5816 .63596 L .59341 .64795 L .65 .753 .924 r
F
.57074 .65416 m .55881 .64227 L .5816 .63596 L F
.30373 .45807 m .30306 .47498 L .30383 .45893 L .867 .699 .174 r
F
.30383 .45893 m .30306 .47498 L .31401 .53412 L F
.62776 .6536 m .6393 .63538 L .65068 .64739 L .65 .753 .925 r
F
.62776 .6536 m .61626 .64169 L .6393 .63538 L F
.29884 .45275 m .30306 .47498 L .30373 .45807 L .958 .694 .494 r
F
.3651 .65032 m .37354 .63202 L .38694 .64406 L .651 .753 .924 r
F
.3651 .65032 m .35158 .63837 L .37354 .63202 L F
.53818 .73943 m .54853 .70077 L .56063 .72181 L .73 .657 .777 r
F
.53818 .73943 m .52598 .71692 L .54853 .70077 L F
.51576 .76157 m .52598 .71692 L .53818 .73943 L .745 .649 .754 r
F
.42206 .64971 m .43118 .6314 L .44415 .64345 L .651 .753 .924 r
F
.42206 .64971 m .40897 .63775 L .43118 .6314 L F
.51576 .76157 m .50346 .73694 L .52598 .71692 L .745 .649 .754 r
F
.49701 .77148 m .51576 .76157 L .50623 .7743 L .764 .641 .725 r
F
.49701 .77148 m .50346 .73694 L .51576 .76157 L F
.56063 .72181 m .57117 .68703 L .58317 .70699 L .718 .664 .795 r
F
.56063 .72181 m .54853 .70077 L .57117 .68703 L F
.4791 .64911 m .4889 .63079 L .50144 .64285 L .651 .753 .924 r
F
.4791 .64911 m .46643 .63714 L .4889 .63079 L F
.53621 .64853 m .5467 .63019 L .55881 .64227 L F
.53621 .64853 m .52398 .63655 L .5467 .63019 L F
.2994 .44142 m .30306 .47498 L .29884 .45275 L 0 0 .433 r
F
.59341 .64795 m .60458 .6296 L .61626 .64169 L .65 .753 .924 r
F
.59341 .64795 m .5816 .63596 L .60458 .6296 L F
.58317 .70699 m .59394 .67487 L .60582 .69402 L .709 .67 .81 r
F
.58317 .70699 m .57117 .68703 L .59394 .67487 L F
.65068 .64739 m .66254 .62902 L .67379 .64113 L .65 .753 .925 r
F
.65068 .64739 m .6393 .63538 L .66254 .62902 L F
.32981 .64468 m .33786 .62625 L .35158 .63837 L .651 .753 .924 r
F
.32981 .64468 m .31598 .63265 L .33786 .62625 L F
.48303 .76864 m .50346 .73694 L .49701 .77148 L .764 .641 .725 r
F
.38694 .64406 m .39568 .62562 L .40897 .63775 L .651 .753 .924 r
F
.38694 .64406 m .37354 .63202 L .39568 .62562 L F
.48303 .76864 m .48087 .76378 L .50346 .73694 L .764 .641 .725 r
F
.50346 .73694 m .51367 .69449 L .52598 .71692 L .734 .647 .762 r
F
.50346 .73694 m .49107 .71246 L .51367 .69449 L F
.48087 .76378 m .49107 .71246 L .50346 .73694 L .752 .638 .734 r
F
.31401 .53412 m .30306 .47498 L .32208 .51197 L .154 .157 .608 r
F
.30306 .47498 m .3095 .47462 L .32208 .51197 L 0 0 .433 r
F
.2994 .44142 m .3095 .47462 L .30306 .47498 L F
.52598 .71692 m .53631 .67976 L .54853 .70077 L .721 .655 .784 r
F
.52598 .71692 m .51367 .69449 L .53631 .67976 L F
.44415 .64345 m .45358 .62499 L .46643 .63714 L .651 .753 .924 r
F
.44415 .64345 m .43118 .6314 L .45358 .62499 L F
.60582 .69402 m .61684 .6638 L .62861 .68233 L .701 .676 .822 r
F
.60582 .69402 m .59394 .67487 L .61684 .6638 L F
.50144 .64285 m .51155 .62438 L .52398 .63655 L .651 .753 .924 r
F
.50144 .64285 m .4889 .63079 L .51155 .62438 L F
.48033 .76761 m .48087 .76378 L .48303 .76864 L .788 .633 .689 r
F
.54853 .70077 m .55905 .66706 L .57117 .68703 L .71 .663 .801 r
F
.54853 .70077 m .53631 .67976 L .55905 .66706 L F
.55881 .64227 m .56961 .62378 L .5816 .63596 L .65 .753 .924 r
F
.55881 .64227 m .5467 .63019 L .56961 .62378 L F
.47892 .76723 m .48087 .76378 L .48033 .76761 L .788 .633 .689 r
F
.48087 .76378 m .46842 .73616 L .49107 .71246 L .752 .638 .734 r
F
.46442 .76216 m .48087 .76378 L .47892 .76723 L .775 .629 .698 r
F
.46442 .76216 m .46842 .73616 L .48087 .76378 L F
.61626 .64169 m .62775 .62319 L .6393 .63538 L .65 .753 .925 r
F
.61626 .64169 m .60458 .6296 L .62775 .62319 L F
.62861 .68233 m .6399 .65351 L .65156 .67155 L .695 .681 .832 r
F
.62861 .68233 m .61684 .6638 L .6399 .65351 L F
.35158 .63837 m .35993 .61979 L .37354 .63202 L .651 .753 .924 r
F
.35158 .63837 m .33786 .62625 L .35993 .61979 L F
.67379 .64113 m .68598 .62261 L .69709 .63482 L .65 .753 .925 r
F
.67379 .64113 m .66254 .62902 L .68598 .62261 L F
.57117 .68703 m .58192 .65568 L .59394 .67487 L .702 .669 .815 r
F
.57117 .68703 m .55905 .66706 L .58192 .65568 L F
.40897 .63775 m .41801 .61916 L .43118 .6314 L .651 .753 .924 r
F
.40897 .63775 m .39568 .62562 L .41801 .61916 L F
.49107 .71246 m .50125 .67212 L .51367 .69449 L .723 .644 .77 r
F
.49107 .71246 m .47858 .68811 L .50125 .67212 L F
.46842 .73616 m .47858 .68811 L .49107 .71246 L .739 .634 .743 r
F
.29522 .43077 m .3095 .47462 L .2994 .44142 L 0 0 .169 r
F
.46643 .63714 m .47616 .61854 L .4889 .63079 L .651 .753 .924 r
F
.46643 .63714 m .45358 .62499 L .47616 .61854 L F
.51367 .69449 m .52397 .65877 L .53631 .67976 L .71 .653 .791 r
F
.51367 .69449 m .50125 .67212 L .52397 .65877 L F
.45311 .75962 m .46842 .73616 L .46442 .76216 L .775 .629 .698 r
F
.46842 .73616 m .45589 .70877 L .47858 .68811 L .739 .634 .743 r
F
.4477 .75794 m .46842 .73616 L .45311 .75962 L .761 .623 .708 r
F
.4477 .75794 m .45589 .70877 L .46842 .73616 L F
.52398 .63655 m .5344 .61792 L .5467 .63019 L .651 .753 .924 r
F
.52398 .63655 m .51155 .62438 L .5344 .61792 L F
.5816 .63596 m .59272 .61732 L .60458 .6296 L .65 .753 .924 r
F
.5816 .63596 m .56961 .62378 L .59272 .61732 L F
.65156 .67155 m .66313 .64379 L .67466 .66145 L .69 .685 .84 r
F
.65156 .67155 m .6399 .65351 L .66313 .64379 L F
.59394 .67487 m .60494 .64522 L .61684 .6638 L .695 .675 .827 r
F
.59394 .67487 m .58192 .65568 L .60494 .64522 L F
.32503 .59521 m .31401 .53412 L .33461 .54991 L .442 .356 .663 r
F
.30314 .60192 m .31401 .53412 L .32503 .59521 L 0 0 .355 r
F
.31401 .53412 m .32208 .51197 L .33461 .54991 L .154 .157 .608 r
F
.53631 .67976 m .54681 .64708 L .55905 .66706 L .701 .661 .807 r
F
.53631 .67976 m .52397 .65877 L .54681 .64708 L F
.6393 .63538 m .65112 .61673 L .66254 .62902 L .65 .753 .925 r
F
.6393 .63538 m .62775 .62319 L .65112 .61673 L F
.32062 .61557 m .30314 .60192 L .32503 .59521 L .562 .357 .561 r
F
.31598 .63265 m .32097 .6209 L .33786 .62625 L .651 .753 .924 r
F
.32097 .6209 m .32361 .61469 L .32854 .61869 L F
.32097 .6209 m .32854 .61869 L .33786 .62625 L F
.34302 .61446 m .32503 .59521 L .3471 .58846 L .602 .464 .665 r
F
.32361 .61469 m .32361 .61469 L .32912 .61852 L .562 .357 .561 r
F
.32361 .61469 m .32503 .59521 L .32912 .61852 L F
.34302 .61446 m .32912 .61852 L .34302 .61446 L .602 .464 .665 r
F
.33842 .62499 m .32971 .61835 L .34302 .61446 L .651 .753 .924 r
F
.33786 .62625 m .32912 .61852 L .33842 .62499 L F
.32912 .61852 m .32503 .59521 L .34302 .61446 L .602 .464 .665 r
F
.32912 .61852 m .32393 .61394 L .33842 .62499 L .651 .753 .924 r
F
.32361 .61469 m .32912 .61852 L .33786 .62625 L F
.33786 .62625 m .3403 .62069 L .35993 .61979 L F
.3403 .62069 m .34302 .61446 L .35591 .61618 L F
.3403 .62069 m .35591 .61618 L .35993 .61979 L F
.33612 .6584 m .34302 .61446 L .35956 .62766 L .602 .464 .665 r
F
.34302 .61446 m .3471 .58846 L .35591 .61618 L F
.3624 .6143 m .3471 .58846 L .36936 .58164 L .623 .528 .727 r
F
.3624 .6143 m .35591 .61618 L .3624 .6143 L F
.36124 .61689 m .35879 .61535 L .3624 .6143 L .651 .753 .924 r
F
.35993 .61979 m .35591 .61618 L .36124 .61689 L F
.35591 .61618 m .3471 .58846 L .3624 .6143 L .623 .528 .727 r
F
.35591 .61618 m .34611 .60738 L .36124 .61689 L .651 .753 .924 r
F
.37354 .63202 m .35993 .61979 L .3799 .61396 L F
.37354 .63202 m .3799 .61396 L .38095 .61386 L F
.38197 .61376 m .3799 .61396 L .38222 .61239 L .676 .557 .713 r
F
.37354 .63202 m .38105 .61362 L .38197 .61376 L .651 .753 .924 r
F
.37354 .63202 m .38185 .61402 L .39568 .62562 L F
.38197 .61376 m .38197 .61376 L .38284 .61389 L .676 .557 .713 r
F
.38197 .61376 m .38222 .61239 L .38284 .61389 L F
.4025 .61122 m .38222 .61239 L .40482 .60123 L .669 .586 .753 r
F
.4025 .61122 m .38284 .61389 L .4025 .61122 L F
.40005 .61641 m .3844 .61367 L .4025 .61122 L .651 .753 .924 r
F
.39568 .62562 m .38284 .61389 L .40005 .61641 L F
.38284 .61389 m .38222 .61239 L .4025 .61122 L .669 .586 .753 r
F
.38284 .61389 m .38219 .61329 L .40005 .61641 L .651 .753 .924 r
F
.38185 .61402 m .38284 .61389 L .39568 .62562 L F
.4227 .60951 m .40482 .60123 L .4275 .59174 L .665 .609 .782 r
F
.39568 .62562 m .40172 .61287 L .41801 .61916 L .651 .753 .924 r
F
.40172 .61287 m .40477 .61238 L .41801 .61916 L F
.4025 .61122 m .40984 .61157 L .41801 .61916 L F
.43118 .6314 m .41801 .61916 L .44052 .61265 L F
.44268 .60833 m .4275 .59174 L .45032 .58306 L .663 .627 .803 r
F
.41801 .61916 m .42146 .61206 L .44052 .61265 L .651 .753 .924 r
F
.42146 .61206 m .4293 .61068 L .44052 .61265 L F
.42269 .60952 m .4227 .60951 L .437 .60932 L .665 .609 .782 r
F
.4227 .60951 m .4275 .59174 L .437 .60932 L F
.44268 .60833 m .437 .60932 L .44268 .60833 L .663 .627 .803 r
F
.44222 .60926 m .44114 .6086 L .44268 .60833 L .651 .753 .924 r
F
.44052 .61265 m .437 .60932 L .44222 .60926 L F
.437 .60932 m .4275 .59174 L .44268 .60833 L .663 .627 .803 r
F
.437 .60932 m .42726 .60012 L .44222 .60926 L .651 .753 .924 r
F
.42269 .60952 m .437 .60932 L .44052 .61265 L F
.43118 .6314 m .44052 .61265 L .45358 .62499 L F
.45358 .62499 m .44052 .61265 L .45846 .60747 L F
.45358 .62499 m .45846 .60747 L .45992 .60734 L F
.46272 .60708 m .45846 .60747 L .46324 .60528 L .68 .632 .795 r
F
.45358 .62499 m .46004 .60701 L .46272 .60708 L .651 .753 .924 r
F
.46272 .60708 m .46272 .60708 L .4643 .60712 L .68 .632 .795 r
F
.46272 .60708 m .46324 .60528 L .4643 .60712 L F
.4889 .63079 m .49894 .61203 L .51155 .62438 L .651 .753 .924 r
F
.4889 .63079 m .47616 .61854 L .49894 .61203 L F
.48324 .60501 m .48324 .60501 L .49168 .60491 L .675 .645 .812 r
F
.48324 .60501 m .48617 .59584 L .49168 .60491 L F
.51155 .62438 m .52191 .60546 L .5344 .61792 L .651 .753 .924 r
F
.51155 .62438 m .49894 .61203 L .52191 .60546 L F
.50356 .6034 m .50356 .60339 L .51921 .60278 L .672 .655 .825 r
F
.50356 .60339 m .50925 .58698 L .51921 .60278 L F
.53623 .60138 m .5325 .5785 L .54507 .59788 L .669 .664 .836 r
F
.5344 .61792 m .52191 .60546 L .53623 .60138 L .65 .753 .924 r
F
.5344 .61792 m .53623 .60138 L .5383 .6012 L F
.54404 .6007 m .53623 .60138 L .54507 .59788 L .678 .666 .831 r
F
.5344 .61792 m .5384 .60076 L .54404 .6007 L .65 .753 .924 r
F
.5467 .63019 m .5344 .61792 L .55744 .61141 L F
.54404 .6007 m .54404 .6007 L .54687 .60067 L .678 .666 .831 r
F
.54404 .6007 m .54507 .59788 L .54687 .60067 L F
.5467 .63019 m .55744 .61141 L .56961 .62378 L .65 .753 .924 r
F
.56961 .62378 m .58067 .60485 L .59272 .61732 L F
.56961 .62378 m .55744 .61141 L .58067 .60485 L F
.5646 .59889 m .5646 .59889 L .57462 .59858 L .675 .673 .84 r
F
.5646 .59889 m .5684 .58911 L .57462 .59858 L F
.59272 .61732 m .60411 .59824 L .61602 .61081 L .65 .753 .925 r
F
.59272 .61732 m .58067 .60485 L .60411 .59824 L F
.58502 .59742 m .58502 .59741 L .60252 .59656 L .672 .678 .848 r
F
.58502 .59741 m .59191 .58063 L .60252 .59656 L F
.61293 .59575 m .61561 .57233 L .62771 .59034 L .67 .684 .854 r
F
.61602 .61081 m .60411 .59824 L .61293 .59575 L .65 .753 .925 r
F
.60458 .6296 m .61602 .61081 L .62775 .62319 L F
.60458 .6296 m .59272 .61732 L .61602 .61081 L F
.61619 .61722 m .60413 .59897 L .61293 .59575 L .675 .684 .851 r
F
.62585 .59468 m .61293 .59575 L .62771 .59034 L F
.61602 .61081 m .61293 .59575 L .6158 .59551 L .65 .753 .925 r
F
.61602 .61081 m .61579 .59494 L .62585 .59468 L F
.62775 .62319 m .61602 .61081 L .63952 .60425 L F
.62585 .59468 m .62585 .59468 L .63052 .59456 L .675 .684 .851 r
F
.62585 .59468 m .62771 .59034 L .63052 .59456 L F
.62775 .62319 m .63952 .60425 L .65112 .61673 L .65 .753 .925 r
F
.65112 .61673 m .66323 .59763 L .67469 .61022 L F
.65112 .61673 m .63952 .60425 L .66323 .59763 L F
.64646 .59308 m .64647 .59308 L .65864 .59259 L .673 .688 .857 r
F
.64647 .59308 m .65147 .58192 L .65864 .59259 L F
.67469 .61022 m .68713 .59096 L .69846 .60366 L .65 .753 .925 r
F
.67469 .61022 m .66323 .59763 L .68713 .59096 L F
.66695 .59176 m .66696 .59175 L .68691 .59072 L .671 .692 .861 r
F
.66696 .59175 m .67543 .57364 L .68691 .59072 L F
.68842 .59061 m .69959 .56548 L .71116 .58271 L .669 .696 .866 r
F
.69846 .60366 m .68713 .59096 L .68842 .59061 L .65 .753 .925 r
F
.68598 .62261 m .69846 .60366 L .70961 .61615 L F
.68598 .62261 m .67469 .61022 L .69846 .60366 L F
.6987 .60834 m .68714 .59105 L .68842 .59061 L .673 .696 .863 r
F
.70807 .58906 m .68842 .59061 L .71116 .58271 L F
.69846 .60366 m .68842 .59061 L .69235 .5903 L .65 .753 .925 r
F
.69846 .60366 m .69203 .5896 L .70807 .58906 L F
.70961 .61615 m .69846 .60366 L .72243 .59704 L F
.70807 .58906 m .70808 .58905 L .71524 .58882 L .673 .696 .863 r
F
.70808 .58905 m .71116 .58271 L .71524 .58882 L F
.70961 .61615 m .72243 .59704 L .73344 .60964 L .65 .753 .925 r
F
.73344 .60964 m .74661 .59037 L .75748 .60308 L F
.73344 .60964 m .72243 .59704 L .74661 .59037 L F
.72873 .58766 m .72873 .58765 L .74372 .587 L .671 .699 .867 r
F
.72873 .58765 m .73538 .57448 L .74372 .587 L F
.7634 .58575 m .7598 .56633 L .77096 .58317 L .67 .701 .871 r
F
.75748 .60308 m .74661 .59037 L .7634 .58575 L .65 .753 .925 r
F
.75748 .60308 m .7634 .58575 L .76434 .58568 L F
.76985 .58531 m .7634 .58575 L .77096 .58317 L .672 .701 .868 r
F
.75748 .60308 m .76443 .58546 L .76985 .58531 L .65 .753 .925 r
F
.74428 .62205 m .75748 .60308 L .76818 .61559 L F
.74428 .62205 m .73344 .60964 L .75748 .60308 L F
.76818 .61559 m .75748 .60308 L .78172 .59647 L F
.76985 .58531 m .76985 .58531 L .77232 .58524 L .672 .701 .868 r
F
.76985 .58531 m .77096 .58317 L .77232 .58524 L F
.76818 .61559 m .78172 .59647 L .79228 .60908 L .65 .753 .925 r
F
.79228 .60908 m .80618 .5898 L .81659 .60252 L F
.79228 .60908 m .78172 .59647 L .80618 .5898 L F
.79064 .58387 m .79065 .58387 L .80101 .58349 L .671 .704 .872 r
F
.79065 .58387 m .79545 .57499 L .80101 .58349 L F
.81659 .60252 m .83084 .58308 L .8411 .59591 L .65 .753 .925 r
F
.81659 .60252 m .80618 .5898 L .83084 .58308 L F
.81132 .58266 m .81133 .58265 L .82984 .58183 L .67 .706 .875 r
F
.81133 .58265 m .82014 .56687 L .82984 .58183 L F
.83701 .5814 m .84503 .55879 L .85562 .57528 L .668 .708 .877 r
F
.8411 .59591 m .83084 .58308 L .83701 .5814 L .65 .753 .925 r
F
.84147 .59983 m .83087 .58342 L .83701 .5814 L .671 .708 .875 r
F
.85268 .58038 m .83701 .5814 L .85562 .57528 L F
.8411 .59591 m .83701 .5814 L .83924 .58125 L .65 .753 .925 r
F
.8411 .59591 m .83918 .58081 L .85268 .58038 L F
.85268 .58038 m .85268 .58037 L .85875 .58019 L .671 .708 .875 r
F
.85268 .58037 m .85562 .57528 L .85875 .58019 L F
.87348 .57916 m .87348 .57914 L .88779 .57861 L .669 .709 .878 r
F
.87348 .57914 m .88058 .56719 L .88779 .57861 L F
.90957 .57746 m .90574 .55913 L .91589 .57542 L .668 .711 .88 r
F
.89415 .57814 m .90574 .55913 L .90957 .57746 L F
.91195 .57682 m .90613 .56259 L .91593 .57575 L .65 .753 .925 r
F
.89077 .58252 m .89415 .57814 L .91195 .57682 L F
.89415 .57814 m .90613 .56259 L .91195 .57682 L F
.89415 .57814 m .88058 .56719 L .90574 .55913 L .668 .711 .88 r
F
.89397 .57838 m .89365 .57816 L .89415 .57814 L .65 .753 .925 r
F
.89077 .58252 m .88779 .57861 L .89397 .57838 L F
.88779 .57861 m .88058 .56719 L .89415 .57814 L .668 .711 .88 r
F
.88779 .57861 m .88082 .56948 L .89397 .57838 L .65 .753 .925 r
F
.86583 .58924 m .87306 .57971 L .89077 .58252 L F
.87348 .57916 m .85562 .57528 L .88058 .56719 L .669 .709 .878 r
F
.87306 .57971 m .87348 .57916 L .88779 .57861 L .65 .753 .925 r
F
.87306 .57971 m .88779 .57861 L .89077 .58252 L F
.85875 .58019 m .85562 .57528 L .87348 .57916 L .669 .709 .878 r
F
.87303 .57974 m .87063 .57926 L .87348 .57916 L .65 .753 .925 r
F
.86583 .58924 m .85875 .58019 L .87303 .57974 L F
.85875 .58019 m .85572 .57631 L .87303 .57974 L F
.8411 .59591 m .8525 .58063 L .86583 .58924 L F
.8525 .58063 m .85572 .57631 L .85875 .58019 L F
.8525 .58063 m .85875 .58019 L .86583 .58924 L F
.86607 .59164 m .85875 .58019 L .87348 .57916 L .669 .709 .878 r
F
.87348 .57916 m .88082 .56948 L .88746 .57818 L .65 .753 .925 r
F
.87348 .57916 m .88746 .57818 L .88779 .57861 L F
.89088 .58351 m .88779 .57861 L .89415 .57814 L .668 .711 .88 r
F
.89088 .58351 m .89415 .57814 L .90957 .57746 L F
.89415 .57814 m .88082 .56948 L .90613 .56259 L .65 .753 .925 r
F
.89365 .57816 m .88082 .56948 L .89415 .57814 L F
.86607 .59164 m .87348 .57916 L .89088 .58351 L .669 .709 .878 r
F
.87348 .57916 m .88779 .57861 L .89088 .58351 L F
.87348 .57916 m .85572 .57631 L .88082 .56948 L .65 .753 .925 r
F
.87063 .57926 m .85572 .57631 L .87348 .57916 L F
.84147 .59983 m .83701 .5814 L .85268 .58038 L .671 .708 .875 r
F
.83924 .58125 m .83701 .5814 L .83918 .58081 L .65 .753 .925 r
F
.85268 .58038 m .83918 .58081 L .85572 .57631 L F
.84147 .59983 m .85268 .58038 L .86607 .59164 L .671 .708 .875 r
F
.85268 .58038 m .85875 .58019 L .86607 .59164 L F
.83188 .58166 m .84503 .55879 L .83701 .5814 L .668 .708 .877 r
F
.83792 .58115 m .84545 .56316 L .85572 .57631 L .65 .753 .925 r
F
.83084 .58308 m .83188 .58166 L .83792 .58115 L F
.83188 .58166 m .84545 .56316 L .83792 .58115 L F
.83188 .58166 m .82014 .56687 L .84503 .55879 L .668 .708 .877 r
F
.83182 .58175 m .83174 .58167 L .83188 .58166 L .65 .753 .925 r
F
.83084 .58308 m .82984 .58183 L .83182 .58175 L F
.82984 .58183 m .82014 .56687 L .83188 .58166 L .668 .708 .877 r
F
.82984 .58183 m .82041 .57005 L .83182 .58175 L .65 .753 .925 r
F
.80618 .5898 m .81074 .58346 L .83084 .58308 L F
.81132 .58266 m .79545 .57499 L .82014 .56687 L .67 .706 .875 r
F
.81074 .58346 m .81132 .58266 L .82984 .58183 L .65 .753 .925 r
F
.81074 .58346 m .82984 .58183 L .83084 .58308 L F
.80101 .58349 m .79545 .57499 L .81132 .58266 L .67 .706 .875 r
F
.81099 .58312 m .81 .58272 L .81132 .58266 L .65 .753 .925 r
F
.80618 .5898 m .80101 .58349 L .81099 .58312 L F
.80101 .58349 m .7956 .57688 L .81099 .58312 L F
.78172 .59647 m .79031 .58435 L .80618 .5898 L F
.79064 .58387 m .77096 .58317 L .79545 .57499 L .671 .704 .872 r
F
.79031 .58435 m .79064 .58387 L .80101 .58349 L .65 .753 .925 r
F
.79031 .58435 m .80101 .58349 L .80618 .5898 L F
.77232 .58524 m .77096 .58317 L .79064 .58387 L .671 .704 .872 r
F
.79003 .58474 m .78108 .58423 L .79064 .58387 L .65 .753 .925 r
F
.78172 .59647 m .77232 .58524 L .79003 .58474 L F
.77232 .58524 m .771 .58365 L .79003 .58474 L F
.75748 .60308 m .76976 .58543 L .78172 .59647 L F
.76976 .58543 m .771 .58365 L .77232 .58524 L F
.76976 .58543 m .77232 .58524 L .78172 .59647 L F
.78198 .59989 m .77232 .58524 L .79064 .58387 L .671 .704 .872 r
F
.79064 .58387 m .7956 .57688 L .80071 .58312 L .65 .753 .925 r
F
.79064 .58387 m .80071 .58312 L .80101 .58349 L F
.80632 .59161 m .80101 .58349 L .81132 .58266 L .67 .706 .875 r
F
.81132 .58266 m .82041 .57005 L .82935 .58122 L .65 .753 .925 r
F
.81132 .58266 m .82935 .58122 L .82984 .58183 L F
.83087 .58342 m .82984 .58183 L .83188 .58166 L .668 .708 .877 r
F
.83087 .58342 m .83188 .58166 L .83701 .5814 L F
.83188 .58166 m .82041 .57005 L .84545 .56316 L .65 .753 .925 r
F
.83174 .58167 m .82041 .57005 L .83188 .58166 L F
.80632 .59161 m .81132 .58266 L .83087 .58342 L .67 .706 .875 r
F
.81132 .58266 m .82984 .58183 L .83087 .58342 L F
.81132 .58266 m .7956 .57688 L .82041 .57005 L .65 .753 .925 r
F
.81 .58272 m .7956 .57688 L .81132 .58266 L F
.78198 .59989 m .79064 .58387 L .80632 .59161 L .671 .704 .872 r
F
.79064 .58387 m .80101 .58349 L .80632 .59161 L F
.79064 .58387 m .771 .58365 L .7956 .57688 L .65 .753 .925 r
F
.78108 .58423 m .771 .58365 L .79064 .58387 L F
.75783 .60828 m .74668 .59144 L .7634 .58575 L .672 .701 .868 r
F
.75783 .60828 m .7634 .58575 L .76985 .58531 L F
.76434 .58568 m .7634 .58575 L .76443 .58546 L .65 .753 .925 r
F
.76985 .58531 m .76443 .58546 L .771 .58365 L F
.75783 .60828 m .76985 .58531 L .78198 .59989 L .672 .701 .868 r
F
.76985 .58531 m .77232 .58524 L .78198 .59989 L F
.74927 .58649 m .7598 .56633 L .7634 .58575 L .67 .701 .871 r
F
.76645 .58491 m .7601 .57063 L .771 .58365 L .65 .753 .925 r
F
.74661 .59037 m .74927 .58649 L .76645 .58491 L F
.74927 .58649 m .7601 .57063 L .76645 .58491 L F
.74927 .58649 m .73538 .57448 L .7598 .56633 L .67 .701 .871 r
F
.74907 .58677 m .74871 .58652 L .74927 .58649 L .65 .753 .925 r
F
.74661 .59037 m .74372 .587 L .74907 .58677 L F
.74372 .587 m .73538 .57448 L .74927 .58649 L .67 .701 .871 r
F
.74372 .587 m .73557 .57747 L .74907 .58677 L .65 .753 .925 r
F
.72243 .59704 m .72821 .58844 L .74661 .59037 L F
.72873 .58766 m .71116 .58271 L .73538 .57448 L .671 .699 .867 r
F
.72821 .58844 m .72873 .58766 L .74372 .587 L .65 .753 .925 r
F
.72821 .58844 m .74372 .587 L .74661 .59037 L F
.71524 .58882 m .71116 .58271 L .72873 .58766 L .671 .699 .867 r
F
.72824 .58838 m .72579 .58779 L .72873 .58766 L .65 .753 .925 r
F
.72243 .59704 m .71524 .58882 L .72824 .58838 L F
.71524 .58882 m .71125 .58424 L .72824 .58838 L F
.69846 .60366 m .70781 .58946 L .72243 .59704 L F
.70781 .58946 m .71125 .58424 L .71524 .58882 L F
.70781 .58946 m .71524 .58882 L .72243 .59704 L F
.72259 .59982 m .71524 .58882 L .72873 .58766 L .671 .699 .867 r
F
.72873 .58766 m .73557 .57747 L .74322 .58641 L .65 .753 .925 r
F
.72873 .58766 m .74322 .58641 L .74372 .587 L F
.74668 .59144 m .74372 .587 L .74927 .58649 L .67 .701 .871 r
F
.74668 .59144 m .74927 .58649 L .7634 .58575 L F
.74927 .58649 m .73557 .57747 L .7601 .57063 L .65 .753 .925 r
F
.74871 .58652 m .73557 .57747 L .74927 .58649 L F
.72259 .59982 m .72873 .58766 L .74668 .59144 L .671 .699 .867 r
F
.72873 .58766 m .74372 .587 L .74668 .59144 L F
.72873 .58766 m .71125 .58424 L .73557 .57747 L .65 .753 .925 r
F
.72579 .58779 m .71125 .58424 L .72873 .58766 L F
.6987 .60834 m .68842 .59061 L .70807 .58906 L .673 .696 .863 r
F
.69235 .5903 m .68842 .59061 L .69203 .5896 L .65 .753 .925 r
F
.70807 .58906 m .69203 .5896 L .71125 .58424 L F
.6987 .60834 m .70807 .58906 L .72259 .59982 L .673 .696 .863 r
F
.70807 .58906 m .71524 .58882 L .72259 .59982 L F
.68732 .59067 m .69959 .56548 L .68842 .59061 L .669 .696 .866 r
F
.68871 .59052 m .69988 .57124 L .71125 .58424 L .65 .753 .925 r
F
.68713 .59096 m .68732 .59067 L .68871 .59052 L F
.68732 .59067 m .69988 .57124 L .68871 .59052 L F
.68732 .59067 m .67543 .57364 L .69959 .56548 L .669 .696 .866 r
F
.68731 .5907 m .68729 .59068 L .68732 .59067 L .65 .753 .925 r
F
.68713 .59096 m .68691 .59072 L .68731 .5907 L F
.68714 .59105 m .68691 .59072 L .68732 .59067 L .669 .696 .866 r
F
.68691 .59072 m .67543 .57364 L .68732 .59067 L F
.68714 .59105 m .68732 .59067 L .68842 .59061 L F
.68732 .59067 m .67563 .57807 L .69988 .57124 L .65 .753 .925 r
F
.68729 .59068 m .67563 .57807 L .68732 .59067 L F
.68691 .59072 m .67563 .57807 L .68731 .5907 L F
.66323 .59763 m .66695 .59176 L .68713 .59096 L F
.66695 .59176 m .67563 .57807 L .68612 .58983 L F
.66695 .59176 m .68612 .58983 L .68713 .59096 L F
.66695 .59176 m .65147 .58192 L .67543 .57364 L .671 .692 .861 r
F
.65864 .59259 m .65147 .58192 L .66695 .59176 L F
.66662 .59228 m .6657 .59182 L .66695 .59176 L .65 .753 .925 r
F
.66323 .59763 m .65864 .59259 L .66662 .59228 L F
.65864 .59259 m .65158 .58485 L .66662 .59228 L F
.63952 .60425 m .64597 .59388 L .66323 .59763 L F
.64646 .59308 m .62771 .59034 L .65147 .58192 L .673 .688 .857 r
F
.64597 .59388 m .64646 .59308 L .65864 .59259 L .65 .753 .925 r
F
.64597 .59388 m .65864 .59259 L .66323 .59763 L F
.63052 .59456 m .62771 .59034 L .64646 .59308 L .673 .688 .857 r
F
.64579 .59417 m .64005 .59334 L .64646 .59308 L .65 .753 .925 r
F
.63952 .60425 m .63052 .59456 L .64579 .59417 L F
.63052 .59456 m .62774 .59157 L .64579 .59417 L F
.61602 .61081 m .62565 .59501 L .63952 .60425 L F
.62565 .59501 m .62774 .59157 L .63052 .59456 L F
.62565 .59501 m .63052 .59456 L .63952 .60425 L F
.63966 .60825 m .63052 .59456 L .64646 .59308 L .673 .688 .857 r
F
.64646 .59308 m .65158 .58485 L .6581 .59201 L .65 .753 .925 r
F
.64646 .59308 m .6581 .59201 L .65864 .59259 L F
.6633 .59955 m .65864 .59259 L .66695 .59176 L .671 .692 .861 r
F
.6633 .59955 m .66695 .59176 L .68714 .59105 L F
.66695 .59176 m .68691 .59072 L .68714 .59105 L F
.66695 .59176 m .65158 .58485 L .67563 .57807 L .65 .753 .925 r
F
.6657 .59182 m .65158 .58485 L .66695 .59176 L F
.63966 .60825 m .64646 .59308 L .6633 .59955 L .673 .688 .857 r
F
.64646 .59308 m .65864 .59259 L .6633 .59955 L F
.64646 .59308 m .62774 .59157 L .65158 .58485 L .65 .753 .925 r
F
.64005 .59334 m .62774 .59157 L .64646 .59308 L F
.61619 .61722 m .61293 .59575 L .62585 .59468 L .675 .684 .851 r
F
.6158 .59551 m .61293 .59575 L .61579 .59494 L .65 .753 .925 r
F
.62585 .59468 m .61579 .59494 L .62774 .59157 L F
.61619 .61722 m .62585 .59468 L .63966 .60825 L .675 .684 .851 r
F
.62585 .59468 m .63052 .59456 L .63966 .60825 L F
.60531 .59623 m .61561 .57233 L .61293 .59575 L .67 .684 .854 r
F
.61563 .59498 m .61578 .57869 L .62774 .59157 L .65 .753 .925 r
F
.60411 .59824 m .60531 .59623 L .61563 .59498 L F
.60531 .59623 m .61578 .57869 L .61563 .59498 L F
.60531 .59623 m .59191 .58063 L .61561 .57233 L .67 .684 .854 r
F
.60518 .59643 m .60496 .59625 L .60531 .59623 L .65 .753 .925 r
F
.60411 .59824 m .60252 .59656 L .60518 .59643 L F
.60252 .59656 m .59191 .58063 L .60531 .59623 L .67 .684 .854 r
F
.60252 .59656 m .59201 .58546 L .60518 .59643 L .65 .753 .925 r
F
.58067 .60485 m .58423 .59878 L .60411 .59824 L F
.58502 .59742 m .5684 .58911 L .59191 .58063 L .672 .678 .848 r
F
.58423 .59878 m .58502 .59742 L .60252 .59656 L .65 .753 .925 r
F
.58423 .59878 m .60252 .59656 L .60411 .59824 L F
.57462 .59858 m .5684 .58911 L .58502 .59742 L .672 .678 .848 r
F
.58452 .59827 m .58258 .59754 L .58502 .59742 L .65 .753 .925 r
F
.58067 .60485 m .57462 .59858 L .58452 .59827 L F
.57462 .59858 m .56844 .59218 L .58452 .59827 L F
.55744 .61141 m .56411 .59975 L .58067 .60485 L .65 .753 .924 r
F
.5646 .59889 m .54507 .59788 L .5684 .58911 L .675 .673 .84 r
F
.56411 .59975 m .5646 .59889 L .57462 .59858 L .65 .753 .924 r
F
.56411 .59975 m .57462 .59858 L .58067 .60485 L F
.54687 .60067 m .54507 .59788 L .5646 .59889 L .675 .673 .84 r
F
.56368 .60051 m .5505 .59933 L .5646 .59889 L .65 .753 .924 r
F
.55744 .61141 m .54687 .60067 L .56368 .60051 L F
.54687 .60067 m .54508 .59885 L .56368 .60051 L F
.5344 .61792 m .54389 .60097 L .55744 .61141 L F
.54389 .60097 m .54508 .59885 L .54687 .60067 L F
.54389 .60097 m .54687 .60067 L .55744 .61141 L F
.55749 .61719 m .54687 .60067 L .5646 .59889 L .675 .673 .84 r
F
.5646 .59889 m .56844 .59218 L .57401 .59795 L .65 .753 .924 r
F
.5646 .59889 m .57401 .59795 L .57462 .59858 L F
.58072 .60788 m .57462 .59858 L .58502 .59742 L .672 .678 .848 r
F
.58502 .59742 m .59201 .58546 L .60158 .59557 L .65 .753 .925 r
F
.58502 .59742 m .60158 .59557 L .60252 .59656 L F
.60413 .59897 m .60252 .59656 L .60531 .59623 L .67 .684 .854 r
F
.60413 .59897 m .60531 .59623 L .61293 .59575 L F
.60531 .59623 m .59201 .58546 L .61578 .57869 L .65 .753 .925 r
F
.60496 .59625 m .59201 .58546 L .60531 .59623 L F
.58072 .60788 m .58502 .59742 L .60413 .59897 L .672 .678 .848 r
F
.58502 .59742 m .60252 .59656 L .60413 .59897 L F
.58502 .59742 m .56844 .59218 L .59201 .58546 L .65 .753 .925 r
F
.58258 .59754 m .56844 .59218 L .58502 .59742 L F
.55749 .61719 m .5646 .59889 L .58072 .60788 L .675 .673 .84 r
F
.5646 .59889 m .57462 .59858 L .58072 .60788 L F
.5646 .59889 m .54508 .59885 L .56844 .59218 L .65 .753 .924 r
F
.5505 .59933 m .54508 .59885 L .5646 .59889 L F
.53443 .62708 m .52191 .60705 L .53623 .60138 L .678 .666 .831 r
F
.53443 .62708 m .53623 .60138 L .54404 .6007 L F
.5383 .6012 m .53623 .60138 L .5384 .60076 L .65 .753 .924 r
F
.54404 .6007 m .5384 .60076 L .54508 .59885 L F
.53443 .62708 m .54404 .6007 L .55749 .61719 L .678 .666 .831 r
F
.54404 .6007 m .54687 .60067 L .55749 .61719 L F
.52373 .60215 m .5325 .5785 L .53623 .60138 L .669 .664 .836 r
F
.54293 .59946 m .53252 .58609 L .54508 .59885 L .65 .753 .924 r
F
.52191 .60546 m .52373 .60215 L .54293 .59946 L F
.52373 .60215 m .53252 .58609 L .54293 .59946 L F
.52373 .60215 m .50925 .58698 L .5325 .5785 L .669 .664 .836 r
F
.52347 .60261 m .52288 .6022 L .52373 .60215 L .65 .753 .924 r
F
.52191 .60546 m .51921 .60278 L .52347 .60261 L F
.51921 .60278 m .50925 .58698 L .52373 .60215 L .669 .664 .836 r
F
.51921 .60278 m .50922 .59281 L .52347 .60261 L .65 .753 .924 r
F
.49894 .61203 m .50265 .6051 L .52191 .60546 L .651 .753 .924 r
F
.50356 .6034 m .48617 .59584 L .50925 .58698 L .672 .655 .825 r
F
.50265 .6051 m .50356 .6034 L .51921 .60278 L .651 .753 .924 r
F
.50265 .6051 m .51921 .60278 L .52191 .60546 L F
.49168 .60491 m .48617 .59584 L .50356 .6034 L .672 .655 .825 r
F
.50281 .60479 m .499 .60358 L .50356 .6034 L .651 .753 .924 r
F
.49894 .61203 m .49168 .60491 L .50281 .60479 L F
.49168 .60491 m .48613 .59948 L .50281 .60479 L F
.47616 .61854 m .48269 .60606 L .49894 .61203 L F
.48324 .60501 m .46324 .60528 L .48617 .59584 L .675 .645 .812 r
F
.48269 .60606 m .48324 .60501 L .49168 .60491 L .651 .753 .924 r
F
.48269 .60606 m .49168 .60491 L .49894 .61203 L F
.4643 .60712 m .46324 .60528 L .48324 .60501 L .675 .645 .812 r
F
.48189 .60759 m .46323 .60609 L .46632 .6052 L .651 .753 .924 r
F
.48189 .60759 m .46632 .6052 L .48324 .60501 L F
.47616 .61854 m .4643 .60712 L .48189 .60759 L F
.4643 .60712 m .46323 .60609 L .48189 .60759 L F
.45358 .62499 m .4626 .60731 L .47616 .61854 L F
.4626 .60731 m .46323 .60609 L .4643 .60712 L F
.4626 .60731 m .4643 .60712 L .47616 .61854 L F
.47604 .62753 m .4643 .60712 L .48324 .60501 L .675 .645 .812 r
F
.48324 .60501 m .48613 .59948 L .4909 .60415 L .651 .753 .924 r
F
.48324 .60501 m .4909 .60415 L .49168 .60491 L F
.4989 .61682 m .49168 .60491 L .50356 .6034 L .672 .655 .825 r
F
.50356 .6034 m .50922 .59281 L .51799 .60156 L .651 .753 .924 r
F
.50356 .6034 m .51799 .60156 L .51921 .60278 L F
.52191 .60705 m .51921 .60278 L .52373 .60215 L .669 .664 .836 r
F
.52191 .60705 m .52373 .60215 L .53623 .60138 L F
.52373 .60215 m .50922 .59281 L .53252 .58609 L .65 .753 .924 r
F
.52288 .6022 m .50922 .59281 L .52373 .60215 L F
.4989 .61682 m .50356 .6034 L .52191 .60705 L .672 .655 .825 r
F
.50356 .6034 m .51921 .60278 L .52191 .60705 L F
.50356 .6034 m .48613 .59948 L .50922 .59281 L .651 .753 .924 r
F
.499 .60358 m .48613 .59948 L .50356 .6034 L F
.47604 .62753 m .48324 .60501 L .4989 .61682 L .675 .645 .812 r
F
.48324 .60501 m .49168 .60491 L .4989 .61682 L F
.48324 .60501 m .46632 .6052 L .48613 .59948 L .651 .753 .924 r
F
.45327 .63974 m .44045 .6157 L .45846 .60747 L .68 .632 .795 r
F
.45327 .63974 m .45846 .60747 L .46272 .60708 L F
.45992 .60734 m .45846 .60747 L .46004 .60701 L .651 .753 .924 r
F
.46272 .60708 m .46004 .60701 L .46323 .60609 L F
.45327 .63974 m .46272 .60708 L .47604 .62753 L .68 .632 .795 r
F
.46272 .60708 m .4643 .60712 L .47604 .62753 L F
.45846 .60747 m .45032 .58306 L .46324 .60528 L .663 .627 .803 r
F
.44268 .60833 m .45032 .58306 L .45846 .60747 L F
.45846 .60747 m .45009 .59345 L .46323 .60609 L .651 .753 .924 r
F
.44052 .61265 m .44268 .60833 L .45846 .60747 L F
.44268 .60833 m .45009 .59345 L .45846 .60747 L F
.44045 .6157 m .44268 .60833 L .45846 .60747 L .663 .627 .803 r
F
.44045 .6157 m .437 .60932 L .44268 .60833 L F
.44268 .60833 m .42726 .60012 L .45009 .59345 L .651 .753 .924 r
F
.44114 .6086 m .42726 .60012 L .44268 .60833 L F
.42269 .60952 m .43511 .60754 L .437 .60932 L F
.42146 .61206 m .42269 .60952 L .4293 .61068 L F
.41774 .62785 m .42269 .60952 L .44045 .6157 L .665 .609 .782 r
F
.42269 .60952 m .437 .60932 L .44045 .6157 L F
.42269 .60952 m .42726 .60012 L .43511 .60754 L .651 .753 .924 r
F
.42269 .60952 m .40984 .61157 L .4227 .60951 L .665 .609 .782 r
F
.40984 .61157 m .40482 .60123 L .4227 .60951 L F
.4025 .61122 m .40482 .60123 L .40984 .61157 L .669 .586 .753 r
F
.42143 .61212 m .40463 .60673 L .42726 .60012 L .651 .753 .924 r
F
.41801 .61916 m .40984 .61157 L .42143 .61212 L F
.40984 .61157 m .40463 .60673 L .42143 .61212 L F
.4025 .61122 m .4025 .61122 L .40984 .61157 L .669 .586 .753 r
F
.41774 .62785 m .40984 .61157 L .42269 .60952 L .665 .609 .782 r
F
.40172 .61287 m .4025 .61122 L .40477 .61238 L .651 .753 .924 r
F
.4025 .61122 m .40463 .60673 L .40984 .61157 L F
.39501 .64345 m .4025 .61122 L .41774 .62785 L .669 .586 .753 r
F
.4025 .61122 m .40984 .61157 L .41774 .62785 L F
.39501 .64345 m .38284 .61389 L .4025 .61122 L F
.4025 .61122 m .38219 .61329 L .40463 .60673 L .651 .753 .924 r
F
.3844 .61367 m .38219 .61329 L .4025 .61122 L F
.38185 .61402 m .38219 .61329 L .38284 .61389 L F
.37198 .66757 m .35956 .62766 L .3799 .61396 L .676 .557 .713 r
F
.37198 .66757 m .3799 .61396 L .38197 .61376 L F
.38095 .61386 m .3799 .61396 L .38105 .61362 L .651 .753 .924 r
F
.38197 .61376 m .38105 .61362 L .38219 .61329 L F
.37198 .66757 m .38197 .61376 L .39501 .64345 L .676 .557 .713 r
F
.38197 .61376 m .38284 .61389 L .39501 .64345 L F
.3799 .61396 m .36936 .58164 L .38222 .61239 L .623 .528 .727 r
F
.3624 .6143 m .36936 .58164 L .3799 .61396 L F
.3799 .61396 m .36848 .60077 L .38219 .61329 L .651 .753 .924 r
F
.35993 .61979 m .3624 .6143 L .3799 .61396 L F
.3624 .6143 m .36848 .60077 L .3799 .61396 L F
.35956 .62766 m .3624 .6143 L .3799 .61396 L .623 .528 .727 r
F
.35956 .62766 m .35591 .61618 L .3624 .6143 L F
.3624 .6143 m .34611 .60738 L .36848 .60077 L .651 .753 .924 r
F
.35879 .61535 m .34611 .60738 L .3624 .6143 L F
.34302 .61446 m .34302 .61446 L .35591 .61618 L .602 .464 .665 r
F
.34302 .61446 m .35591 .61618 L .35956 .62766 L F
.34302 .61446 m .34611 .60738 L .35591 .61618 L .651 .753 .924 r
F
.33612 .6584 m .32912 .61852 L .34302 .61446 L .602 .464 .665 r
F
.34302 .61446 m .32393 .61394 L .34611 .60738 L .651 .753 .924 r
F
.32971 .61835 m .32393 .61394 L .34302 .61446 L F
.32361 .61469 m .32449 .61443 L .32912 .61852 L F
.31677 .70888 m .32361 .61469 L .33612 .6584 L .562 .357 .561 r
F
.32361 .61469 m .32912 .61852 L .33612 .6584 L F
.3025 .62093 m .30314 .60192 L .32062 .61557 L F
.32062 .61557 m .32503 .59521 L .32361 .61469 L F
.32361 .61469 m .30194 .62044 L .32393 .61394 L .651 .753 .924 r
F
.31598 .63265 m .3025 .62093 L .32361 .61469 L F
.3025 .62093 m .30194 .62044 L .32361 .61469 L F
.29937 .71384 m .32062 .61557 L .31677 .70888 L .562 .357 .561 r
F
.32062 .61557 m .32361 .61469 L .31677 .70888 L F
.29937 .71384 m .3025 .62093 L .32062 .61557 L F
.32361 .61469 m .32393 .61394 L .32449 .61443 L .651 .753 .924 r
F
.69709 .63482 m .70961 .61615 L .72059 .62846 L .65 .753 .925 r
F
.69709 .63482 m .68598 .62261 L .70961 .61615 L F
.43979 .75654 m .45589 .70877 L .4477 .75794 L .761 .623 .708 r
F
.43979 .75654 m .43295 .73876 L .45589 .70877 L F
.45589 .70877 m .46598 .66387 L .47858 .68811 L .724 .629 .752 r
F
.45589 .70877 m .44327 .6816 L .46598 .66387 L F
.43295 .73876 m .44327 .6816 L .45589 .70877 L .743 .617 .718 r
F
.47858 .68811 m .4887 .6498 L .50125 .67212 L .71 .641 .778 r
F
.47858 .68811 m .46598 .66387 L .4887 .6498 L F
.61684 .6638 m .62812 .6354 L .6399 .65351 L .69 .68 .836 r
F
.61684 .6638 m .60494 .64522 L .62812 .6354 L F
.55905 .66706 m .56978 .63646 L .58192 .65568 L .694 .668 .82 r
F
.55905 .66706 m .54681 .64708 L .56978 .63646 L F
.67466 .66145 m .68653 .6345 L .69794 .65184 L .686 .689 .847 r
F
.67466 .66145 m .66313 .64379 L .68653 .6345 L F
.50125 .67212 m .5115 .6378 L .52397 .65877 L .699 .651 .798 r
F
.50125 .67212 m .4887 .6498 L .5115 .6378 L F
.43127 .75299 m .43295 .73876 L .43979 .75654 L .79 .614 .663 r
F
.29522 .43077 m .29686 .43781 L .3095 .47462 L 0 0 .169 r
F
.29418 .42473 m .29686 .43781 L .29522 .43077 L F
.42706 .75191 m .43295 .73876 L .43127 .75299 L .79 .614 .663 r
F
.43295 .73876 m .42037 .70661 L .44327 .6816 L .743 .617 .718 r
F
.415 .74745 m .43295 .73876 L .42706 .75191 L .771 .605 .673 r
F
.415 .74745 m .42037 .70661 L .43295 .73876 L F
.66254 .62902 m .67469 .61022 L .68598 .62261 L .65 .753 .925 r
F
.66254 .62902 m .65112 .61673 L .67469 .61022 L F
.44327 .6816 m .45327 .63974 L .46598 .66387 L .707 .624 .762 r
F
.44327 .6816 m .43055 .65463 L .45327 .63974 L F
.42037 .70661 m .43055 .65463 L .44327 .6816 L .723 .609 .729 r
F
.72059 .62846 m .73344 .60964 L .74428 .62205 L .65 .753 .925 r
F
.72059 .62846 m .70961 .61615 L .73344 .60964 L F
.58192 .65568 m .5929 .62658 L .60494 .64522 L .688 .674 .831 r
F
.58192 .65568 m .56978 .63646 L .5929 .62658 L F
.52397 .65877 m .53443 .62708 L .54681 .64708 L .692 .659 .813 r
F
.52397 .65877 m .5115 .6378 L .53443 .62708 L F
.6399 .65351 m .65146 .62606 L .66313 .64379 L .685 .685 .844 r
F
.6399 .65351 m .62812 .6354 L .65146 .62606 L F
.46598 .66387 m .47604 .62753 L .4887 .6498 L .696 .637 .786 r
F
.46598 .66387 m .45327 .63974 L .47604 .62753 L F
.69794 .65184 m .71011 .62553 L .72139 .64262 L .683 .692 .853 r
F
.69794 .65184 m .68653 .6345 L .71011 .62553 L F
.39963 .74443 m .42037 .70661 L .415 .74745 L .771 .605 .673 r
F
.42037 .70661 m .40773 .67485 L .43055 .65463 L .723 .609 .729 r
F
.39763 .74381 m .42037 .70661 L .39963 .74443 L .747 .594 .685 r
F
.39763 .74381 m .40773 .67485 L .42037 .70661 L F
.32503 .59521 m .33461 .54991 L .3471 .58846 L .442 .356 .663 r
F
.28874 .41458 m .29686 .43781 L .29418 .42473 L .915 .58 .113 r
F
.4887 .6498 m .4989 .61682 L .5115 .6378 L .688 .648 .805 r
F
.4887 .6498 m .47604 .62753 L .4989 .61682 L F
.54681 .64708 m .55749 .61719 L .56978 .63646 L .686 .667 .826 r
F
.54681 .64708 m .53443 .62708 L .55749 .61719 L F
.30194 .62044 m .30978 .60143 L .32393 .61394 L .651 .753 .924 r
F
.30194 .62044 m .28768 .60804 L .30978 .60143 L F
.39494 .74348 m .40773 .67485 L .39763 .74381 L .747 .594 .685 r
F
.39494 .74348 m .38439 .70821 L .40773 .67485 L F
.40773 .67485 m .41774 .62785 L .43055 .65463 L .698 .599 .741 r
F
.40773 .67485 m .39501 .64345 L .41774 .62785 L F
.38439 .70821 m .39501 .64345 L .40773 .67485 L .716 .578 .699 r
F
.60494 .64522 m .61619 .61722 L .62812 .6354 L .684 .68 .84 r
F
.60494 .64522 m .5929 .62658 L .61619 .61722 L F
.43055 .65463 m .44045 .6157 L .45327 .63974 L .687 .617 .772 r
F
.43055 .65463 m .41774 .62785 L .44045 .6157 L F
.66313 .64379 m .67499 .61707 L .68653 .6345 L .682 .689 .85 r
F
.66313 .64379 m .65146 .62606 L .67499 .61707 L F
.72139 .64262 m .73388 .61681 L .74503 .6337 L .68 .696 .858 r
F
.72139 .64262 m .71011 .62553 L .73388 .61681 L F
.38439 .70821 m .37198 .66757 L .39501 .64345 L .716 .578 .699 r
F
.5115 .6378 m .52191 .60705 L .53443 .62708 L .682 .658 .819 r
F
.5115 .6378 m .4989 .61682 L .52191 .60705 L F
.3471 .58846 m .3564 .55119 L .36936 .58164 L .549 .487 .738 r
F
.3471 .58846 m .33461 .54991 L .3564 .55119 L F
.56978 .63646 m .58072 .60788 L .5929 .62658 L .682 .674 .836 r
F
.56978 .63646 m .55749 .61719 L .58072 .60788 L F
.34731 .72382 m .35956 .62766 L .37198 .66757 L .693 .524 .654 r
F
.34731 .72382 m .33612 .6584 L .35956 .62766 L F
.33461 .54991 m .34336 .52102 L .3564 .55119 L .448 .428 .744 r
F
.33461 .54991 m .32208 .51197 L .34336 .52102 L F
.3651 .73136 m .37198 .66757 L .38439 .70821 L .749 .561 .64 r
F
.34822 .7293 m .37198 .66757 L .3651 .73136 L F
.34822 .7293 m .34731 .72382 L .37198 .66757 L F
.32208 .51197 m .33022 .49109 L .34336 .52102 L .307 .342 .734 r
F
.32208 .51197 m .3095 .47462 L .33022 .49109 L F
.62812 .6354 m .63966 .60825 L .65146 .62606 L .68 .684 .847 r
F
.62812 .6354 m .61619 .61722 L .63966 .60825 L F
.38169 .7371 m .38439 .70821 L .39494 .74348 L .785 .584 .628 r
F
.37587 .73578 m .38439 .70821 L .38169 .7371 L F
.3651 .73136 m .38439 .70821 L .37587 .73578 L .749 .561 .64 r
F
.3095 .47462 m .31698 .4614 L .33022 .49109 L .119 .222 .697 r
F
.3095 .47462 m .29686 .43781 L .31698 .4614 L F
.68653 .6345 m .6987 .60834 L .71011 .62553 L .679 .692 .856 r
F
.68653 .6345 m .67499 .61707 L .6987 .60834 L F
.32393 .61394 m .33208 .59477 L .34611 .60738 L .651 .753 .924 r
F
.32393 .61394 m .30978 .60143 L .33208 .59477 L F
.29686 .43781 m .30363 .43193 L .31698 .4614 L 0 .069 .616 r
F
.28827 .40793 m .29686 .43781 L .28874 .41458 L F
.28827 .40793 m .30363 .43193 L .29686 .43781 L F
.38222 .61239 m .3918 .57477 L .40482 .60123 L .634 .57 .766 r
F
.38222 .61239 m .36936 .58164 L .3918 .57477 L F
.74503 .6337 m .75783 .60828 L .76885 .625 L .677 .698 .862 r
F
.74503 .6337 m .73388 .61681 L .75783 .60828 L F
.38219 .61329 m .39104 .59411 L .40463 .60673 L .651 .753 .924 r
F
.38219 .61329 m .36848 .60077 L .39104 .59411 L F
.33245 .71775 m .33612 .6584 L .34731 .72382 L .744 .509 .574 r
F
.32995 .71747 m .33612 .6584 L .33245 .71775 L F
.31677 .70888 m .33612 .6584 L .32995 .71747 L .562 .357 .561 r
F
.5929 .62658 m .60413 .59897 L .61619 .61722 L .678 .679 .844 r
F
.5929 .62658 m .58072 .60788 L .60413 .59897 L F
.65146 .62606 m .6633 .59955 L .67499 .61707 L .677 .689 .853 r
F
.65146 .62606 m .63966 .60825 L .6633 .59955 L F
.36936 .58164 m .37866 .54845 L .3918 .57477 L .591 .55 .777 r
F
.36936 .58164 m .3564 .55119 L .37866 .54845 L F
.40482 .60123 m .41443 .56784 L .4275 .59174 L .641 .6 .792 r
F
.40482 .60123 m .3918 .57477 L .41443 .56784 L F
.71011 .62553 m .72259 .59982 L .73388 .61681 L .676 .696 .861 r
F
.71011 .62553 m .6987 .60834 L .72259 .59982 L F
.28768 .60804 m .29541 .58873 L .30978 .60143 L .651 .753 .924 r
F
.28768 .60804 m .27319 .59544 L .29541 .58873 L F
.76885 .625 m .78198 .59989 L .79286 .61648 L .675 .701 .866 r
F
.76885 .625 m .75783 .60828 L .78198 .59989 L F
.34611 .60738 m .35456 .58805 L .36848 .60077 L .651 .753 .924 r
F
.34611 .60738 m .33208 .59477 L .35456 .58805 L F
.28626 .40192 m .30363 .43193 L .28827 .40793 L 0 0 .493 r
F
.40463 .60673 m .4138 .58739 L .42726 .60012 L .651 .753 .924 r
F
.40463 .60673 m .39104 .59411 L .4138 .58739 L F
.46324 .60528 m .47329 .57484 L .48617 .59584 L .662 .641 .819 r
F
.46324 .60528 m .45032 .58306 L .47329 .57484 L F
.3564 .55119 m .36541 .52226 L .37866 .54845 L .539 .525 .788 r
F
.3564 .55119 m .34336 .52102 L .36541 .52226 L F
.46323 .60609 m .47311 .58673 L .48613 .59948 L .651 .753 .924 r
F
.46323 .60609 m .45009 .59345 L .47311 .58673 L F
.67499 .61707 m .68714 .59105 L .6987 .60834 L .675 .692 .859 r
F
.67499 .61707 m .6633 .59955 L .68714 .59105 L F
.4275 .59174 m .43726 .56086 L .45032 .58306 L .645 .621 .812 r
F
.4275 .59174 m .41443 .56784 L .43726 .56086 L F
.73388 .61681 m .74668 .59144 L .75783 .60828 L .674 .699 .865 r
F
.73388 .61681 m .72259 .59982 L .74668 .59144 L F
.3918 .57477 m .40123 .544 L .41443 .56784 L .612 .588 .802 r
F
.3918 .57477 m .37866 .54845 L .40123 .544 L F
.30978 .60143 m .31782 .58196 L .33208 .59477 L .651 .753 .924 r
F
.30978 .60143 m .29541 .58873 L .31782 .58196 L F
.28626 .40192 m .29018 .40265 L .30363 .43193 L 0 0 .493 r
F
.28388 .39025 m .29018 .40265 L .28626 .40192 L F
.79286 .61648 m .80632 .59161 L .81706 .6081 L .674 .703 .87 r
F
.79286 .61648 m .78198 .59989 L .80632 .59161 L F
.34336 .52102 m .35204 .49617 L .36541 .52226 L .475 .492 .795 r
F
.34336 .52102 m .33022 .49109 L .35204 .49617 L F
.36848 .60077 m .37724 .58128 L .39104 .59411 L .651 .753 .924 r
F
.36848 .60077 m .35456 .58805 L .37724 .58128 L F
.48617 .59584 m .49645 .56687 L .50925 .58698 L .661 .653 .831 r
F
.48617 .59584 m .47329 .57484 L .49645 .56687 L F
.34705 .72841 m .34731 .72382 L .34822 .7293 L .811 .567 .57 r
F
.34697 .72838 m .34731 .72382 L .34705 .72841 L F
.33245 .71775 m .34731 .72382 L .34697 .72838 L .744 .509 .574 r
F
.42726 .60012 m .43675 .58062 L .45009 .59345 L .651 .753 .924 r
F
.42726 .60012 m .4138 .58739 L .43675 .58062 L F
.48613 .59948 m .49634 .57996 L .50922 .59281 L F
.48613 .59948 m .47311 .58673 L .49634 .57996 L F
.54507 .59788 m .55593 .57026 L .5684 .58911 L .667 .671 .845 r
F
.54507 .59788 m .5325 .5785 L .55593 .57026 L F
.45032 .58306 m .46028 .55381 L .47329 .57484 L .648 .638 .826 r
F
.45032 .58306 m .43726 .56086 L .46028 .55381 L F
.54508 .59885 m .55601 .57932 L .56844 .59218 L .65 .753 .924 r
F
.54508 .59885 m .53252 .58609 L .55601 .57932 L F
.37866 .54845 m .3879 .52021 L .40123 .544 L .58 .575 .812 r
F
.37866 .54845 m .36541 .52226 L .3879 .52021 L F
.33022 .49109 m .33853 .47019 L .35204 .49617 L .397 .45 .798 r
F
.33022 .49109 m .31698 .4614 L .33853 .47019 L F
.41443 .56784 m .42406 .53865 L .43726 .56086 L .625 .614 .82 r
F
.41443 .56784 m .40123 .544 L .42406 .53865 L F
.27319 .59544 m .28081 .57582 L .29541 .58873 L .651 .753 .924 r
F
.27319 .59544 m .25848 .58265 L .28081 .57582 L F
.81706 .6081 m .83087 .58342 L .84147 .59983 L .672 .706 .873 r
F
.81706 .6081 m .80632 .59161 L .83087 .58342 L F
.33208 .59477 m .34042 .57514 L .35456 .58805 L .651 .753 .924 r
F
.33208 .59477 m .31782 .58196 L .34042 .57514 L F
.50925 .58698 m .51978 .55906 L .5325 .5785 L .66 .662 .841 r
F
.50925 .58698 m .49645 .56687 L .51978 .55906 L F
.39104 .59411 m .40011 .57446 L .4138 .58739 L .651 .753 .924 r
F
.39104 .59411 m .37724 .58128 L .40011 .57446 L F
.45009 .59345 m .45989 .57379 L .47311 .58673 L F
.45009 .59345 m .43675 .58062 L .45989 .57379 L F
.31698 .4614 m .3249 .44428 L .33853 .47019 L .303 .396 .792 r
F
.31698 .4614 m .30363 .43193 L .3249 .44428 L F
.5684 .58911 m .57955 .56219 L .59191 .58063 L .666 .678 .852 r
F
.5684 .58911 m .55593 .57026 L .57955 .56219 L F
.50922 .59281 m .51976 .57313 L .53252 .58609 L .65 .753 .924 r
F
.50922 .59281 m .49634 .57996 L .51976 .57313 L F
.27654 .37346 m .29018 .40265 L .28388 .39025 L 0 0 .346 r
F
.47329 .57484 m .48349 .5467 L .49645 .56687 L .65 .65 .837 r
F
.47329 .57484 m .46028 .55381 L .48349 .5467 L F
.36541 .52226 m .37443 .49644 L .3879 .52021 L .543 .559 .82 r
F
.36541 .52226 m .35204 .49617 L .37443 .49644 L F
.56844 .59218 m .57971 .57249 L .59201 .58546 L .65 .753 .925 r
F
.56844 .59218 m .55601 .57932 L .57971 .57249 L F
.62771 .59034 m .63949 .56418 L .65147 .58192 L .668 .688 .86 r
F
.62771 .59034 m .61561 .57233 L .63949 .56418 L F
.43726 .56086 m .44711 .53275 L .46028 .55381 L .633 .633 .833 r
F
.43726 .56086 m .42406 .53865 L .44711 .53275 L F
.29541 .58873 m .30333 .56895 L .31782 .58196 L .651 .753 .924 r
F
.29541 .58873 m .28081 .57582 L .30333 .56895 L F
.62774 .59157 m .63975 .57185 L .65158 .58485 L .65 .753 .925 r
F
.62774 .59157 m .61578 .57869 L .63975 .57185 L F
.40123 .544 m .41071 .51644 L .42406 .53865 L .603 .606 .828 r
F
.40123 .544 m .3879 .52021 L .41071 .51644 L F
.5325 .5785 m .54331 .55133 L .55593 .57026 L .66 .67 .849 r
F
.5325 .5785 m .51978 .55906 L .54331 .55133 L F
.35456 .58805 m .36322 .56825 L .37724 .58128 L .651 .753 .924 r
F
.35456 .58805 m .34042 .57514 L .36322 .56825 L F
.4138 .58739 m .42319 .56757 L .43675 .58062 L F
.4138 .58739 m .40011 .57446 L .42319 .56757 L F
.30363 .43193 m .31113 .41844 L .3249 .44428 L .193 .331 .776 r
F
.30363 .43193 m .29018 .40265 L .31113 .41844 L F
.47311 .58673 m .48324 .5669 L .49634 .57996 L .651 .753 .924 r
F
.47311 .58673 m .45989 .57379 L .48324 .5669 L F
.59191 .58063 m .60335 .55422 L .61561 .57233 L .665 .683 .858 r
F
.59191 .58063 m .57955 .56219 L .60335 .55422 L F
.49645 .56687 m .50691 .53954 L .51978 .55906 L .651 .661 .846 r
F
.49645 .56687 m .48349 .5467 L .50691 .53954 L F
.53252 .58609 m .54339 .56625 L .55601 .57932 L .65 .753 .924 r
F
.53252 .58609 m .51976 .57313 L .54339 .56625 L F
.35204 .49617 m .36081 .47269 L .37443 .49644 L .502 .54 .828 r
F
.35204 .49617 m .33853 .47019 L .36081 .47269 L F
.65147 .58192 m .66358 .55612 L .67543 .57364 L .667 .692 .864 r
F
.65147 .58192 m .63949 .56418 L .66358 .55612 L F
.59201 .58546 m .60362 .5656 L .61578 .57869 L .65 .753 .925 r
F
.59201 .58546 m .57971 .57249 L .60362 .5656 L F
.25848 .58265 m .26598 .56272 L .28081 .57582 L .651 .753 .924 r
F
.25848 .58265 m .24354 .56965 L .26598 .56272 L F
.46028 .55381 m .47038 .52647 L .48349 .5467 L .638 .647 .843 r
F
.46028 .55381 m .44711 .53275 L .47038 .52647 L F
.31782 .58196 m .32605 .56201 L .34042 .57514 L .651 .753 .924 r
F
.31782 .58196 m .30333 .56895 L .32605 .56201 L F
.65158 .58485 m .66394 .56497 L .67563 .57807 L .65 .753 .925 r
F
.65158 .58485 m .63975 .57185 L .66394 .56497 L F
.55593 .57026 m .56702 .54366 L .57955 .56219 L .659 .677 .856 r
F
.55593 .57026 m .54331 .55133 L .56702 .54366 L F
.71116 .58271 m .72394 .55738 L .73538 .57448 L .668 .699 .869 r
F
.71116 .58271 m .69959 .56548 L .72394 .55738 L F
.29018 .40265 m .29721 .39266 L .31113 .41844 L .067 .252 .744 r
F
.29018 .40265 m .27661 .37356 L .29721 .39266 L F
.27654 .37346 m .27661 .37356 L .29018 .40265 L 0 0 .346 r
F
.37724 .58128 m .38621 .56132 L .40011 .57446 L .651 .753 .924 r
F
.37724 .58128 m .36322 .56825 L .38621 .56132 L F
.71125 .58424 m .72435 .56435 L .73557 .57747 L .65 .753 .925 r
F
.71125 .58424 m .69988 .57124 L .72435 .56435 L F
.3879 .52021 m .39721 .4942 L .41071 .51644 L .579 .597 .835 r
F
.3879 .52021 m .37443 .49644 L .39721 .4942 L F
.42406 .53865 m .43379 .51164 L .44711 .53275 L .617 .628 .84 r
F
.42406 .53865 m .41071 .51644 L .43379 .51164 L F
.77096 .58317 m .78443 .55823 L .79545 .57499 L .668 .704 .874 r
F
.77096 .58317 m .7598 .56633 L .78443 .55823 L F
.43675 .58062 m .44646 .56063 L .45989 .57379 L .651 .753 .924 r
F
.43675 .58062 m .42319 .56757 L .44646 .56063 L F
.771 .58365 m .78485 .56375 L .7956 .57688 L .65 .753 .925 r
F
.771 .58365 m .7601 .57063 L .78485 .56375 L F
.61561 .57233 m .62736 .54632 L .63949 .56418 L .664 .688 .863 r
F
.61561 .57233 m .60335 .55422 L .62736 .54632 L F
.49634 .57996 m .5068 .55996 L .51976 .57313 L .65 .753 .924 r
F
.49634 .57996 m .48324 .5669 L .5068 .55996 L F
.51978 .55906 m .53052 .53231 L .54331 .55133 L .652 .669 .853 r
F
.51978 .55906 m .50691 .53954 L .53052 .53231 L F
.55601 .57932 m .56722 .5593 L .57971 .57249 L .65 .753 .925 r
F
.55601 .57932 m .54339 .56625 L .56722 .5593 L F
.67543 .57364 m .68786 .54812 L .69959 .56548 L .666 .696 .868 r
F
.67543 .57364 m .66358 .55612 L .68786 .54812 L F
.33853 .47019 m .34704 .44895 L .36081 .47269 L .454 .517 .833 r
F
.33853 .47019 m .3249 .44428 L .34704 .44895 L F
.27647 .37324 m .27661 .37356 L .27654 .37346 L 0 0 .346 r
F
.27625 .37279 m .27661 .37356 L .27647 .37324 L .727 .354 0 r
F
.28081 .57582 m .28862 .55572 L .30333 .56895 L .651 .753 .924 r
F
.28081 .57582 m .26598 .56272 L .28862 .55572 L F
.61578 .57869 m .62773 .55866 L .63975 .57185 L .65 .753 .925 r
F
.61578 .57869 m .60362 .5656 L .62773 .55866 L F
.27661 .37356 m .28315 .36693 L .29721 .39266 L 0 .162 .695 r
F
.27213 .35478 m .27661 .37356 L .27625 .37279 L F
.27213 .35478 m .28315 .36693 L .27661 .37356 L F
.48349 .5467 m .49387 .51993 L .50691 .53954 L .642 .659 .851 r
F
.48349 .5467 m .47038 .52647 L .49387 .51993 L F
.57955 .56219 m .59094 .536 L .60335 .55422 L .659 .683 .861 r
F
.57955 .56219 m .56702 .54366 L .59094 .536 L F
.73538 .57448 m .7485 .54934 L .7598 .56633 L .667 .701 .873 r
F
.73538 .57448 m .72394 .55738 L .7485 .54934 L F
.34042 .57514 m .34897 .55502 L .36322 .56825 L .651 .753 .924 r
F
.34042 .57514 m .32605 .56201 L .34897 .55502 L F
.67563 .57807 m .68834 .55802 L .69988 .57124 L .65 .753 .925 r
F
.67563 .57807 m .66394 .56497 L .68834 .55802 L F
.40011 .57446 m .40941 .55432 L .42319 .56757 L .651 .753 .924 r
F
.40011 .57446 m .38621 .56132 L .40941 .55432 L F
.73557 .57747 m .74903 .55741 L .7601 .57063 L .65 .753 .925 r
F
.73557 .57747 m .72435 .56435 L .74903 .55741 L F
.79545 .57499 m .80926 .55018 L .82014 .56687 L .667 .706 .876 r
F
.79545 .57499 m .78443 .55823 L .80926 .55018 L F
.44711 .53275 m .45711 .50617 L .47038 .52647 L .626 .644 .849 r
F
.44711 .53275 m .43379 .51164 L .45711 .50617 L F
.37443 .49644 m .38355 .47194 L .39721 .4942 L .552 .587 .843 r
F
.37443 .49644 m .36081 .47269 L .38355 .47194 L F
.63949 .56418 m .65156 .53846 L .66358 .55612 L .663 .692 .867 r
F
.63949 .56418 m .62736 .54632 L .65156 .53846 L F
.45989 .57379 m .46994 .55364 L .48324 .5669 L .651 .753 .924 r
F
.45989 .57379 m .44646 .56063 L .46994 .55364 L F
.7956 .57688 m .80982 .5568 L .82041 .57005 L .65 .753 .925 r
F
.7956 .57688 m .78485 .56375 L .80982 .5568 L F
.41071 .51644 m .42031 .49048 L .43379 .51164 L .599 .622 .846 r
F
.41071 .51644 m .39721 .4942 L .42031 .49048 L F
.85562 .57528 m .87014 .55073 L .88058 .56719 L .667 .71 .879 r
F
.85562 .57528 m .84503 .55879 L .87014 .55073 L F
.54331 .55133 m .55434 .52501 L .56702 .54366 L .653 .676 .859 r
F
.54331 .55133 m .53052 .53231 L .55434 .52501 L F
.51976 .57313 m .53056 .55296 L .54339 .56625 L .65 .753 .924 r
F
.51976 .57313 m .5068 .55996 L .53056 .55296 L F
.85572 .57631 m .8707 .55622 L .88082 .56948 L .65 .753 .925 r
F
.85572 .57631 m .84545 .56316 L .8707 .55622 L F
.69959 .56548 m .71234 .54016 L .72394 .55738 L .665 .699 .872 r
F
.69959 .56548 m .68786 .54812 L .71234 .54016 L F
.57971 .57249 m .59126 .5523 L .60362 .5656 L .65 .753 .925 r
F
.57971 .57249 m .56722 .5593 L .59126 .5523 L F
.24354 .56965 m .25091 .54939 L .26598 .56272 L .651 .753 .924 r
F
.24354 .56965 m .22835 .55644 L .25091 .54939 L F
.91589 .57542 m .93113 .55109 L .94112 .56736 L .667 .713 .882 r
F
.91589 .57542 m .90574 .55913 L .93113 .55109 L F
.91593 .57575 m .93168 .55565 L .94131 .56892 L .649 .753 .925 r
F
.91593 .57575 m .90613 .56259 L .93168 .55565 L F
.3249 .44428 m .33312 .42521 L .34704 .44895 L .4 .49 .836 r
F
.3249 .44428 m .31113 .41844 L .33312 .42521 L F
.30333 .56895 m .31146 .54867 L .32605 .56201 L .651 .753 .924 r
F
.30333 .56895 m .28862 .55572 L .31146 .54867 L F
.63975 .57185 m .65206 .55166 L .66394 .56497 L .65 .753 .925 r
F
.63975 .57185 m .62773 .55866 L .65206 .55166 L F
.7598 .56633 m .77326 .54133 L .78443 .55823 L .666 .704 .876 r
F
.7598 .56633 m .7485 .54934 L .77326 .54133 L F
.60335 .55422 m .61507 .52835 L .62736 .54632 L .659 .687 .866 r
F
.60335 .55422 m .59094 .536 L .61507 .52835 L F
.50691 .53954 m .51758 .51318 L .53052 .53231 L .645 .668 .857 r
F
.50691 .53954 m .49387 .51993 L .51758 .51318 L F
.36322 .56825 m .37209 .54797 L .38621 .56132 L .651 .753 .924 r
F
.36322 .56825 m .34897 .55502 L .37209 .54797 L F
.69988 .57124 m .71295 .55102 L .72435 .56435 L .65 .753 .925 r
F
.69988 .57124 m .68834 .55802 L .71295 .55102 L F
.82014 .56687 m .8343 .54214 L .84503 .55879 L .666 .708 .879 r
F
.82014 .56687 m .80926 .55018 L .8343 .54214 L F
.42319 .56757 m .43281 .54727 L .44646 .56063 L .651 .753 .924 r
F
.42319 .56757 m .40941 .55432 L .43281 .54727 L F
.7601 .57063 m .77393 .5504 L .78485 .56375 L .65 .753 .925 r
F
.7601 .57063 m .74903 .55741 L .77393 .5504 L F
.66358 .55612 m .67597 .53062 L .68786 .54812 L .662 .696 .871 r
F
.66358 .55612 m .65156 .53846 L .67597 .53062 L F
.47038 .52647 m .48067 .50023 L .49387 .51993 L .632 .656 .856 r
F
.47038 .52647 m .45711 .50617 L .48067 .50023 L F
.48324 .5669 m .49363 .54658 L .5068 .55996 L .65 .753 .924 r
F
.48324 .5669 m .46994 .55364 L .49363 .54658 L F
.82041 .57005 m .83501 .5498 L .84545 .56316 L .65 .753 .925 r
F
.82041 .57005 m .80982 .5568 L .83501 .5498 L F
.88058 .56719 m .89546 .54269 L .90574 .55913 L .666 .711 .882 r
F
.88058 .56719 m .87014 .55073 L .89546 .54269 L F
.56702 .54366 m .57837 .51766 L .59094 .536 L .654 .682 .864 r
F
.56702 .54366 m .55434 .52501 L .57837 .51766 L F
.36081 .47269 m .36974 .44963 L .38355 .47194 L .523 .575 .849 r
F
.36081 .47269 m .34704 .44895 L .36974 .44963 L F
.54339 .56625 m .55453 .54591 L .56722 .5593 L .65 .753 .925 r
F
.54339 .56625 m .53056 .55296 L .55453 .54591 L F
.88082 .56948 m .89618 .54922 L .90613 .56259 L F
.88082 .56948 m .8707 .55622 L .89618 .54922 L F
.72394 .55738 m .73704 .53221 L .7485 .54934 L .664 .702 .875 r
F
.72394 .55738 m .71234 .54016 L .73704 .53221 L F
.43379 .51164 m .44368 .48579 L .45711 .50617 L .613 .64 .854 r
F
.43379 .51164 m .42031 .49048 L .44368 .48579 L F
.94112 .56736 m .95672 .54305 L .96656 .55932 L .667 .714 .884 r
F
.94112 .56736 m .93113 .55109 L .95672 .54305 L F
.39721 .4942 m .40666 .46925 L .42031 .49048 L .581 .616 .852 r
F
.39721 .4942 m .38355 .47194 L .40666 .46925 L F
.26598 .56272 m .27366 .54229 L .28862 .55572 L .651 .753 .924 r
F
.26598 .56272 m .25091 .54939 L .27366 .54229 L F
.60362 .5656 m .61552 .54524 L .62773 .55866 L .65 .753 .925 r
F
.60362 .5656 m .59126 .5523 L .61552 .54524 L F
.94131 .56892 m .95744 .54865 L .96692 .56204 L .649 .752 .925 r
F
.94131 .56892 m .93168 .55565 L .95744 .54865 L F
.31113 .41844 m .31904 .40146 L .33312 .42521 L .34 .458 .834 r
F
.31113 .41844 m .29721 .39266 L .31904 .40146 L F
.78443 .55823 m .79824 .53333 L .80926 .55018 L .665 .706 .878 r
F
.78443 .55823 m .77326 .54133 L .79824 .53333 L F
.32605 .56201 m .33449 .54157 L .34897 .55502 L .651 .753 .924 r
F
.32605 .56201 m .31146 .54867 L .33449 .54157 L F
.62736 .54632 m .63939 .52068 L .65156 .53846 L .659 .692 .87 r
F
.62736 .54632 m .61507 .52835 L .63939 .52068 L F
.66394 .56497 m .6766 .5446 L .68834 .55802 L .65 .753 .925 r
F
.66394 .56497 m .65206 .55166 L .6766 .5446 L F
.53052 .53231 m .5415 .50625 L .55434 .52501 L .647 .675 .863 r
F
.53052 .53231 m .51758 .51318 L .5415 .50625 L F
.38621 .56132 m .39541 .54085 L .40941 .55432 L .651 .753 .924 r
F
.38621 .56132 m .37209 .54797 L .39541 .54085 L F
.72435 .56435 m .73778 .54396 L .74903 .55741 L .65 .753 .925 r
F
.72435 .56435 m .71295 .55102 L .73778 .54396 L F
.84503 .55879 m .85956 .53412 L .87014 .55073 L .665 .71 .881 r
F
.84503 .55879 m .8343 .54214 L .85956 .53412 L F
.26713 .34224 m .28315 .36693 L .27213 .35478 L 0 .066 .629 r
F
.44646 .56063 m .45642 .54015 L .46994 .55364 L .651 .753 .924 r
F
.44646 .56063 m .43281 .54727 L .45642 .54015 L F
.68786 .54812 m .70059 .52278 L .71234 .54016 L .661 .699 .874 r
F
.68786 .54812 m .67597 .53062 L .70059 .52278 L F
.78485 .56375 m .79905 .54335 L .80982 .5568 L .65 .753 .925 r
F
.78485 .56375 m .77393 .5504 L .79905 .54335 L F
.90574 .55913 m .921 .53465 L .93113 .55109 L .666 .713 .883 r
F
.90574 .55913 m .89546 .54269 L .921 .53465 L F
.5068 .55996 m .51752 .53947 L .53056 .55296 L .65 .753 .924 r
F
.5068 .55996 m .49363 .54658 L .51752 .53947 L F
.84545 .56316 m .86042 .54275 L .8707 .55622 L .65 .753 .925 r
F
.84545 .56316 m .83501 .5498 L .86042 .54275 L F
.49387 .51993 m .50447 .49394 L .51758 .51318 L .637 .666 .862 r
F
.49387 .51993 m .48067 .50023 L .50447 .49394 L F
.59094 .536 m .60261 .51024 L .61507 .52835 L .654 .687 .869 r
F
.59094 .536 m .57837 .51766 L .60261 .51024 L F
.7485 .54934 m .76194 .52428 L .77326 .54133 L .663 .704 .878 r
F
.7485 .54934 m .73704 .53221 L .76194 .52428 L F
.56722 .5593 m .57871 .53879 L .59126 .5523 L .65 .753 .925 r
F
.56722 .5593 m .55453 .54591 L .57871 .53879 L F
.22835 .55644 m .23559 .53586 L .25091 .54939 L .651 .753 .924 r
F
.22835 .55644 m .21292 .54302 L .23559 .53586 L F
.90613 .56259 m .92188 .54216 L .93168 .55565 L .649 .753 .925 r
F
.90613 .56259 m .89618 .54922 L .92188 .54216 L F
.34704 .44895 m .35576 .42728 L .36974 .44963 L .492 .562 .854 r
F
.34704 .44895 m .33312 .42521 L .35576 .42728 L F
.28862 .55572 m .29662 .53512 L .31146 .54867 L .651 .753 .924 r
F
.28862 .55572 m .27366 .54229 L .29662 .53512 L F
.62773 .55866 m .63999 .53813 L .65206 .55166 L .65 .753 .925 r
F
.62773 .55866 m .61552 .54524 L .63999 .53813 L F
.45711 .50617 m .46731 .48044 L .48067 .50023 L .622 .654 .86 r
F
.45711 .50617 m .44368 .48579 L .46731 .48044 L F
.80926 .55018 m .82343 .52534 L .8343 .54214 L .664 .708 .881 r
F
.80926 .55018 m .79824 .53333 L .82343 .52534 L F
.65156 .53846 m .66393 .51299 L .67597 .53062 L .658 .695 .873 r
F
.65156 .53846 m .63939 .52068 L .66393 .51299 L F
.29721 .39266 m .3048 .37768 L .31904 .40146 L .273 .421 .829 r
F
.29721 .39266 m .28315 .36693 L .3048 .37768 L F
.34897 .55502 m .35774 .5344 L .37209 .54797 L .651 .753 .924 r
F
.34897 .55502 m .33449 .54157 L .35774 .5344 L F
.68834 .55802 m .70137 .53748 L .71295 .55102 L .65 .753 .925 r
F
.68834 .55802 m .6766 .5446 L .70137 .53748 L F
.42031 .49048 m .43008 .46532 L .44368 .48579 L .599 .636 .859 r
F
.42031 .49048 m .40666 .46925 L .43008 .46532 L F
.38355 .47194 m .39285 .44796 L .40666 .46925 L .562 .609 .858 r
F
.38355 .47194 m .36974 .44963 L .39285 .44796 L F
.55434 .52501 m .56563 .49919 L .57837 .51766 L .648 .681 .867 r
F
.55434 .52501 m .5415 .50625 L .56563 .49919 L F
.87014 .55073 m .88503 .52609 L .89546 .54269 L .665 .712 .883 r
F
.87014 .55073 m .85956 .53412 L .88503 .52609 L F
.40941 .55432 m .41894 .53368 L .43281 .54727 L .651 .753 .924 r
F
.40941 .55432 m .39541 .54085 L .41894 .53368 L F
.74903 .55741 m .76283 .53685 L .77393 .5504 L .65 .753 .925 r
F
.74903 .55741 m .73778 .54396 L .76283 .53685 L F
.71234 .54016 m .72542 .51493 L .73704 .53221 L .661 .702 .877 r
F
.71234 .54016 m .70059 .52278 L .72542 .51493 L F
.46994 .55364 m .48024 .53298 L .49363 .54658 L .65 .753 .924 r
F
.46994 .55364 m .45642 .54015 L .48024 .53298 L F
.80982 .5568 m .8244 .53623 L .83501 .5498 L .65 .753 .925 r
F
.80982 .5568 m .79905 .54335 L .8244 .53623 L F
.93113 .55109 m .94675 .52661 L .95672 .54305 L .665 .714 .885 r
F
.93113 .55109 m .921 .53465 L .94675 .52661 L F
.53056 .55296 m .54163 .53229 L .55453 .54591 L .65 .753 .925 r
F
.53056 .55296 m .51752 .53947 L .54163 .53229 L F
.8707 .55622 m .88606 .53563 L .89618 .54922 L F
.8707 .55622 m .86042 .54275 L .88606 .53563 L F
.61507 .52835 m .62706 .50275 L .63939 .52068 L .655 .691 .872 r
F
.61507 .52835 m .60261 .51024 L .62706 .50275 L F
.51758 .51318 m .52848 .48737 L .5415 .50625 L .64 .674 .866 r
F
.51758 .51318 m .50447 .49394 L .52848 .48737 L F
.77326 .54133 m .78706 .51633 L .79824 .53333 L .662 .706 .88 r
F
.77326 .54133 m .76194 .52428 L .78706 .51633 L F
.25091 .54939 m .25846 .52863 L .27366 .54229 L .651 .753 .924 r
F
.25091 .54939 m .23559 .53586 L .25846 .52863 L F
.59126 .5523 m .60311 .53161 L .61552 .54524 L .65 .753 .925 r
F
.59126 .5523 m .57871 .53879 L .60311 .53161 L F
.93168 .55565 m .94782 .53505 L .95744 .54865 L .649 .752 .925 r
F
.93168 .55565 m .92188 .54216 L .94782 .53505 L F
.26713 .34224 m .26894 .34122 L .28315 .36693 L 0 .066 .629 r
F
.26544 .33675 m .26894 .34122 L .26713 .34224 L F
.31146 .54867 m .31978 .5279 L .33449 .54157 L .651 .753 .924 r
F
.31146 .54867 m .29662 .53512 L .31978 .5279 L F
.8343 .54214 m .84883 .51734 L .85956 .53412 L .663 .71 .883 r
F
.8343 .54214 m .82343 .52534 L .84883 .51734 L F
.65206 .55166 m .66468 .53095 L .6766 .5446 L .65 .753 .925 r
F
.65206 .55166 m .63999 .53813 L .66468 .53095 L F
.67597 .53062 m .68868 .50526 L .70059 .52278 L .658 .699 .876 r
F
.67597 .53062 m .66393 .51299 L .68868 .50526 L F
.33312 .42521 m .34161 .40487 L .35576 .42728 L .458 .546 .859 r
F
.33312 .42521 m .31904 .40146 L .34161 .40487 L F
.48067 .50023 m .49118 .47459 L .50447 .49394 L .628 .664 .866 r
F
.48067 .50023 m .46731 .48044 L .49118 .47459 L F
.37209 .54797 m .38119 .52717 L .39541 .54085 L .651 .753 .924 r
F
.37209 .54797 m .35774 .5344 L .38119 .52717 L F
.71295 .55102 m .72635 .5303 L .73778 .54396 L .65 .753 .925 r
F
.71295 .55102 m .70137 .53748 L .72635 .5303 L F
.28315 .36693 m .29039 .35386 L .3048 .37768 L .2 .38 .818 r
F
.28315 .36693 m .26894 .34122 L .29039 .35386 L F
.57837 .51766 m .58998 .49199 L .60261 .51024 L .649 .687 .871 r
F
.57837 .51766 m .56563 .49919 L .58998 .49199 L F
.89546 .54269 m .91073 .51805 L .921 .53465 L .664 .713 .885 r
F
.89546 .54269 m .88503 .52609 L .91073 .51805 L F
.43281 .54727 m .44268 .52645 L .45642 .54015 L .651 .753 .924 r
F
.43281 .54727 m .41894 .53368 L .44268 .52645 L F
.77393 .5504 m .78811 .52967 L .79905 .54335 L .65 .753 .925 r
F
.77393 .5504 m .76283 .53685 L .78811 .52967 L F
.73704 .53221 m .75047 .50707 L .76194 .52428 L .661 .704 .879 r
F
.73704 .53221 m .72542 .51493 L .75047 .50707 L F
.44368 .48579 m .45377 .46053 L .46731 .48044 L .612 .651 .865 r
F
.44368 .48579 m .43008 .46532 L .45377 .46053 L F
.49363 .54658 m .50427 .52575 L .51752 .53947 L .65 .753 .924 r
F
.49363 .54658 m .48024 .53298 L .50427 .52575 L F
.36974 .44963 m .37886 .42658 L .39285 .44796 L .541 .602 .863 r
F
.36974 .44963 m .35576 .42728 L .37886 .42658 L F
.83501 .5498 m .84997 .52905 L .86042 .54275 L .65 .753 .925 r
F
.83501 .5498 m .8244 .53623 L .84997 .52905 L F
.40666 .46925 m .4163 .44476 L .43008 .46532 L .585 .632 .864 r
F
.40666 .46925 m .39285 .44796 L .4163 .44476 L F
.26077 .32662 m .26894 .34122 L .26544 .33675 L 0 .013 .584 r
F
.63939 .52068 m .65172 .4952 L .66393 .51299 L .655 .695 .875 r
F
.63939 .52068 m .62706 .50275 L .65172 .4952 L F
.55453 .54591 m .56595 .52506 L .57871 .53879 L .65 .753 .925 r
F
.55453 .54591 m .54163 .53229 L .56595 .52506 L F
.21292 .54302 m .22002 .5221 L .23559 .53586 L .651 .753 .924 r
F
.21292 .54302 m .19724 .52938 L .22002 .5221 L F
.79824 .53333 m .8124 .50837 L .82343 .52534 L .662 .708 .882 r
F
.79824 .53333 m .78706 .51633 L .8124 .50837 L F
.89618 .54922 m .91193 .52845 L .92188 .54216 L .649 .753 .925 r
F
.89618 .54922 m .88606 .53563 L .91193 .52845 L F
.5415 .50625 m .55272 .48058 L .56563 .49919 L .643 .68 .871 r
F
.5415 .50625 m .52848 .48737 L .55272 .48058 L F
.27366 .54229 m .28154 .52135 L .29662 .53512 L .651 .753 .924 r
F
.27366 .54229 m .25846 .52863 L .28154 .52135 L F
.61552 .54524 m .62772 .52438 L .63999 .53813 L .65 .753 .925 r
F
.61552 .54524 m .60311 .53161 L .62772 .52438 L F
.85956 .53412 m .87446 .50932 L .88503 .52609 L .663 .712 .884 r
F
.85956 .53412 m .84883 .51734 L .87446 .50932 L F
.33449 .54157 m .34315 .52061 L .35774 .5344 L .651 .753 .924 r
F
.33449 .54157 m .31978 .5279 L .34315 .52061 L F
.6766 .5446 m .68959 .52371 L .70137 .53748 L .65 .753 .925 r
F
.6766 .5446 m .66468 .53095 L .68959 .52371 L F
.70059 .52278 m .71365 .4975 L .72542 .51493 L .658 .702 .879 r
F
.70059 .52278 m .68868 .50526 L .71365 .4975 L F
.39541 .54085 m .40484 .51988 L .41894 .53368 L .651 .753 .924 r
F
.39541 .54085 m .38119 .52717 L .40484 .51988 L F
.73778 .54396 m .75155 .52306 L .76283 .53685 L .65 .753 .925 r
F
.73778 .54396 m .72635 .5303 L .75155 .52306 L F
.50447 .49394 m .51529 .46836 L .52848 .48737 L .633 .673 .87 r
F
.50447 .49394 m .49118 .47459 L .51529 .46836 L F
.921 .53465 m .93664 .51 L .94675 .52661 L .663 .715 .886 r
F
.921 .53465 m .91073 .51805 L .93664 .51 L F
.60261 .51024 m .61456 .48468 L .62706 .50275 L .65 .691 .875 r
F
.60261 .51024 m .58998 .49199 L .61456 .48468 L F
.26894 .34122 m .2758 .33 L .29039 .35386 L .121 .333 .8 r
F
.2587 .31834 m .26894 .34122 L .26077 .32662 L F
.2587 .31834 m .2758 .33 L .26894 .34122 L F
.31904 .40146 m .32728 .38239 L .34161 .40487 L .422 .529 .862 r
F
.31904 .40146 m .3048 .37768 L .32728 .38239 L F
.45642 .54015 m .46663 .51916 L .48024 .53298 L .65 .753 .924 r
F
.45642 .54015 m .44268 .52645 L .46663 .51916 L F
.76194 .52428 m .77574 .49917 L .78706 .51633 L .66 .707 .882 r
F
.76194 .52428 m .75047 .50707 L .77574 .49917 L F
.79905 .54335 m .81361 .52243 L .8244 .53623 L .65 .753 .925 r
F
.79905 .54335 m .78811 .52967 L .81361 .52243 L F
.51752 .53947 m .52852 .51845 L .54163 .53229 L F
.51752 .53947 m .50427 .52575 L .52852 .51845 L F
.86042 .54275 m .87577 .52182 L .88606 .53563 L F
.86042 .54275 m .84997 .52905 L .87577 .52182 L F
.46731 .48044 m .47772 .45511 L .49118 .47459 L .62 .662 .869 r
F
.46731 .48044 m .45377 .46053 L .47772 .45511 L F
.82343 .52534 m .83796 .50039 L .84883 .51734 L .661 .71 .884 r
F
.82343 .52534 m .8124 .50837 L .83796 .50039 L F
.66393 .51299 m .67661 .48758 L .68868 .50526 L .655 .699 .878 r
F
.66393 .51299 m .65172 .4952 L .67661 .48758 L F
.23559 .53586 m .24302 .51476 L .25846 .52863 L .651 .753 .924 r
F
.23559 .53586 m .22002 .5221 L .24302 .51476 L F
.57871 .53879 m .59049 .51776 L .60311 .53161 L .65 .753 .925 r
F
.57871 .53879 m .56595 .52506 L .59049 .51776 L F
.92188 .54216 m .93803 .52122 L .94782 .53505 L .649 .752 .925 r
F
.92188 .54216 m .91193 .52845 L .93803 .52122 L F
.56563 .49919 m .57719 .4736 L .58998 .49199 L .645 .686 .874 r
F
.56563 .49919 m .55272 .48058 L .57719 .4736 L F
.35576 .42728 m .3647 .40511 L .37886 .42658 L .519 .593 .868 r
F
.35576 .42728 m .34161 .40487 L .3647 .40511 L F
.43008 .46532 m .44005 .44051 L .45377 .46053 L .601 .648 .869 r
F
.43008 .46532 m .4163 .44476 L .44005 .44051 L F
.29662 .53512 m .30482 .514 L .31978 .5279 L .651 .753 .924 r
F
.29662 .53512 m .28154 .52135 L .30482 .514 L F
.63999 .53813 m .65256 .51708 L .66468 .53095 L .65 .753 .925 r
F
.63999 .53813 m .62772 .52438 L .65256 .51708 L F
.88503 .52609 m .90031 .50128 L .91073 .51805 L .662 .713 .886 r
F
.88503 .52609 m .87446 .50932 L .90031 .50128 L F
.39285 .44796 m .40234 .42408 L .4163 .44476 L .571 .627 .869 r
F
.39285 .44796 m .37886 .42658 L .40234 .42408 L F
.72542 .51493 m .73884 .48969 L .75047 .50707 L .658 .704 .881 r
F
.72542 .51493 m .71365 .4975 L .73884 .48969 L F
.35774 .5344 m .36672 .51326 L .38119 .52717 L .651 .753 .924 r
F
.35774 .5344 m .34315 .52061 L .36672 .51326 L F
.70137 .53748 m .71473 .51641 L .72635 .5303 L .65 .753 .925 r
F
.70137 .53748 m .68959 .52371 L .71473 .51641 L F
.41894 .53368 m .42872 .51252 L .44268 .52645 L .651 .753 .924 r
F
.41894 .53368 m .40484 .51988 L .42872 .51252 L F
.76283 .53685 m .77699 .51577 L .78811 .52967 L .65 .753 .925 r
F
.76283 .53685 m .75155 .52306 L .77699 .51577 L F
.62706 .50275 m .63935 .47726 L .65172 .4952 L .651 .695 .878 r
F
.62706 .50275 m .61456 .48468 L .63935 .47726 L F
.52848 .48737 m .53964 .46183 L .55272 .48058 L .637 .68 .874 r
F
.52848 .48737 m .51529 .46836 L .53964 .46183 L F
.78706 .51633 m .80122 .49124 L .8124 .50837 L .66 .709 .884 r
F
.78706 .51633 m .77574 .49917 L .80122 .49124 L F
.48024 .53298 m .4908 .5118 L .50427 .52575 L .65 .753 .924 r
F
.48024 .53298 m .46663 .51916 L .4908 .5118 L F
.8244 .53623 m .83935 .51513 L .84997 .52905 L .65 .753 .925 r
F
.8244 .53623 m .81361 .52243 L .83935 .51513 L F
.3048 .37768 m .31278 .35983 L .32728 .38239 L .382 .51 .863 r
F
.3048 .37768 m .29039 .35386 L .31278 .35983 L F
.54163 .53229 m .55298 .51109 L .56595 .52506 L .65 .753 .925 r
F
.54163 .53229 m .52852 .51845 L .55298 .51109 L F
.19724 .52938 m .2042 .50812 L .22002 .5221 L .651 .753 .924 r
F
.19724 .52938 m .1813 .51552 L .2042 .50812 L F
.88606 .53563 m .90181 .51452 L .91193 .52845 L .649 .753 .925 r
F
.88606 .53563 m .87577 .52182 L .90181 .51452 L F
.84883 .51734 m .86374 .49238 L .87446 .50932 L .661 .712 .886 r
F
.84883 .51734 m .83796 .50039 L .86374 .49238 L F
.68868 .50526 m .70171 .4799 L .71365 .4975 L .655 .702 .881 r
F
.68868 .50526 m .67661 .48758 L .70171 .4799 L F
.49118 .47459 m .50192 .44921 L .51529 .46836 L .627 .671 .873 r
F
.49118 .47459 m .47772 .45511 L .50192 .44921 L F
.25846 .52863 m .26621 .50735 L .28154 .52135 L .651 .753 .924 r
F
.25846 .52863 m .24302 .51476 L .26621 .50735 L F
.60311 .53161 m .61525 .5104 L .62772 .52438 L .65 .753 .925 r
F
.60311 .53161 m .59049 .51776 L .61525 .5104 L F
.58998 .49199 m .60188 .46645 L .61456 .48468 L .646 .691 .877 r
F
.58998 .49199 m .57719 .4736 L .60188 .46645 L F
.31978 .5279 m .32832 .50659 L .34315 .52061 L .651 .753 .924 r
F
.31978 .5279 m .30482 .514 L .32832 .50659 L F
.91073 .51805 m .92639 .49321 L .93664 .51 L .662 .715 .888 r
F
.91073 .51805 m .90031 .50128 L .92639 .49321 L F
.66468 .53095 m .67762 .50972 L .68959 .52371 L .65 .753 .925 r
F
.66468 .53095 m .65256 .51708 L .67762 .50972 L F
.25652 .31267 m .2758 .33 L .2587 .31834 L .038 .281 .776 r
F
.75047 .50707 m .76425 .48183 L .77574 .49917 L .658 .707 .883 r
F
.75047 .50707 m .73884 .48969 L .76425 .48183 L F
.45377 .46053 m .46408 .4355 L .47772 .45511 L .612 .661 .873 r
F
.45377 .46053 m .44005 .44051 L .46408 .4355 L F
.38119 .52717 m .39051 .50584 L .40484 .51988 L .651 .753 .924 r
F
.38119 .52717 m .36672 .51326 L .39051 .50584 L F
.72635 .5303 m .74009 .50905 L .75155 .52306 L .65 .753 .925 r
F
.72635 .5303 m .71473 .51641 L .74009 .50905 L F
.34161 .40487 m .35035 .38354 L .3647 .40511 L .496 .584 .873 r
F
.34161 .40487 m .32728 .38239 L .35035 .38354 L F
.44268 .52645 m .4528 .50511 L .46663 .51916 L .65 .753 .924 r
F
.44268 .52645 m .42872 .51252 L .4528 .50511 L F
.78811 .52967 m .80265 .50841 L .81361 .52243 L .65 .753 .925 r
F
.78811 .52967 m .77699 .51577 L .80265 .50841 L F
.65172 .4952 m .66436 .46974 L .67661 .48758 L .652 .699 .88 r
F
.65172 .4952 m .63935 .47726 L .66436 .46974 L F
.4163 .44476 m .42615 .42036 L .44005 .44051 L .59 .645 .873 r
F
.4163 .44476 m .40234 .42408 L .42615 .42036 L F
.8124 .50837 m .82693 .48327 L .83796 .50039 L .66 .711 .886 r
F
.8124 .50837 m .80122 .49124 L .82693 .48327 L F
.37886 .42658 m .3882 .40329 L .40234 .42408 L .555 .622 .874 r
F
.37886 .42658 m .3647 .40511 L .3882 .40329 L F
.55272 .48058 m .56421 .45505 L .57719 .4736 L .64 .685 .877 r
F
.55272 .48058 m .53964 .46183 L .56421 .45505 L F
.50427 .52575 m .51519 .50438 L .52852 .51845 L .65 .753 .925 r
F
.50427 .52575 m .4908 .5118 L .51519 .50438 L F
.84997 .52905 m .86532 .50778 L .87577 .52182 L F
.84997 .52905 m .83935 .51513 L .86532 .50778 L F
.22002 .5221 m .22731 .50065 L .24302 .51476 L .651 .753 .924 r
F
.22002 .5221 m .2042 .50812 L .22731 .50065 L F
.56595 .52506 m .57766 .50367 L .59049 .51776 L .65 .753 .925 r
F
.56595 .52506 m .55298 .51109 L .57766 .50367 L F
.87446 .50932 m .88975 .48432 L .90031 .50128 L .661 .714 .887 r
F
.87446 .50932 m .86374 .49238 L .88975 .48432 L F
.25652 .31267 m .26103 .30607 L .2758 .33 L .038 .281 .776 r
F
.25236 .29937 m .26103 .30607 L .25652 .31267 L F
.91193 .52845 m .92808 .50716 L .93803 .52122 L .649 .752 .925 r
F
.91193 .52845 m .90181 .51452 L .92808 .50716 L F
.71365 .4975 m .72704 .47214 L .73884 .48969 L .655 .704 .883 r
F
.71365 .4975 m .70171 .4799 L .72704 .47214 L F
.28154 .52135 m .28962 .49987 L .30482 .514 L .651 .753 .924 r
F
.28154 .52135 m .26621 .50735 L .28962 .49987 L F
.62772 .52438 m .64024 .50298 L .65256 .51708 L .65 .753 .925 r
F
.62772 .52438 m .61525 .5104 L .64024 .50298 L F
.29039 .35386 m .29808 .33718 L .31278 .35983 L .34 .489 .862 r
F
.29039 .35386 m .2758 .33 L .29808 .33718 L F
.51529 .46836 m .52637 .44293 L .53964 .46183 L .631 .679 .877 r
F
.51529 .46836 m .50192 .44921 L .52637 .44293 L F
.61456 .48468 m .6268 .45915 L .63935 .47726 L .648 .695 .88 r
F
.61456 .48468 m .60188 .46645 L .6268 .45915 L F
.34315 .52061 m .35202 .49911 L .36672 .51326 L .651 .753 .924 r
F
.34315 .52061 m .32832 .50659 L .35202 .49911 L F
.68959 .52371 m .70291 .5023 L .71473 .51641 L .65 .753 .925 r
F
.68959 .52371 m .67762 .50972 L .70291 .5023 L F
.77574 .49917 m .78988 .47392 L .80122 .49124 L .658 .709 .885 r
F
.77574 .49917 m .76425 .48183 L .78988 .47392 L F
.40484 .51988 m .41452 .49836 L .42872 .51252 L .651 .753 .924 r
F
.40484 .51988 m .39051 .50584 L .41452 .49836 L F
.75155 .52306 m .76568 .50163 L .77699 .51577 L .65 .753 .925 r
F
.75155 .52306 m .74009 .50905 L .76568 .50163 L F
.47772 .45511 m .48837 .42991 L .50192 .44921 L .62 .67 .877 r
F
.47772 .45511 m .46408 .4355 L .48837 .42991 L F
.46663 .51916 m .47711 .49763 L .4908 .5118 L .65 .753 .924 r
F
.46663 .51916 m .4528 .50511 L .47711 .49763 L F
.81361 .52243 m .82855 .50098 L .83935 .51513 L .65 .753 .925 r
F
.81361 .52243 m .80265 .50841 L .82855 .50098 L F
.67661 .48758 m .6896 .46213 L .70171 .4799 L .652 .702 .883 r
F
.67661 .48758 m .66436 .46974 L .6896 .46213 L F
.83796 .50039 m .85287 .47525 L .86374 .49238 L .659 .712 .887 r
F
.83796 .50039 m .82693 .48327 L .85287 .47525 L F
.57719 .4736 m .58902 .44806 L .60188 .46645 L .642 .69 .88 r
F
.57719 .4736 m .56421 .45505 L .58902 .44806 L F
.52852 .51845 m .53979 .4969 L .55298 .51109 L .65 .753 .925 r
F
.52852 .51845 m .51519 .50438 L .53979 .4969 L F
.1813 .51552 m .18811 .4939 L .2042 .50812 L .651 .753 .924 r
F
.1813 .51552 m .16509 .50143 L .18811 .4939 L F
.87577 .52182 m .89152 .50035 L .90181 .51452 L .649 .753 .925 r
F
.87577 .52182 m .86532 .50778 L .89152 .50035 L F
.32728 .38239 m .33581 .36186 L .35035 .38354 L .472 .574 .876 r
F
.32728 .38239 m .31278 .35983 L .33581 .36186 L F
.44005 .44051 m .45025 .41575 L .46408 .4355 L .603 .658 .877 r
F
.44005 .44051 m .42615 .42036 L .45025 .41575 L F
.90031 .50128 m .916 .47623 L .92639 .49321 L .66 .715 .889 r
F
.90031 .50128 m .88975 .48432 L .916 .47623 L F
.24302 .51476 m .25063 .49311 L .26621 .50735 L .651 .753 .924 r
F
.24302 .51476 m .22731 .50065 L .25063 .49311 L F
.59049 .51776 m .60257 .49619 L .61525 .5104 L .65 .753 .925 r
F
.59049 .51776 m .57766 .50367 L .60257 .49619 L F
.73884 .48969 m .7526 .46432 L .76425 .48183 L .656 .707 .885 r
F
.73884 .48969 m .72704 .47214 L .7526 .46432 L F
.40234 .42408 m .41205 .40008 L .42615 .42036 L .578 .642 .877 r
F
.40234 .42408 m .3882 .40329 L .41205 .40008 L F
.3647 .40511 m .37387 .38238 L .3882 .40329 L .539 .617 .878 r
F
.3647 .40511 m .35035 .38354 L .37387 .38238 L F
.30482 .514 m .31324 .49234 L .32832 .50659 L .651 .753 .924 r
F
.30482 .514 m .28962 .49987 L .31324 .49234 L F
.65256 .51708 m .66545 .49549 L .67762 .50972 L .65 .753 .925 r
F
.65256 .51708 m .64024 .50298 L .66545 .49549 L F
.63935 .47726 m .65194 .45173 L .66436 .46974 L .649 .698 .882 r
F
.63935 .47726 m .6268 .45915 L .65194 .45173 L F
.53964 .46183 m .55106 .43634 L .56421 .45505 L .635 .685 .879 r
F
.53964 .46183 m .52637 .44293 L .55106 .43634 L F
.36672 .51326 m .37594 .49157 L .39051 .50584 L .651 .753 .924 r
F
.36672 .51326 m .35202 .49911 L .37594 .49157 L F
.71473 .51641 m .72843 .49481 L .74009 .50905 L .65 .753 .925 r
F
.71473 .51641 m .70291 .5023 L .72843 .49481 L F
.80122 .49124 m .81575 .46596 L .82693 .48327 L .658 .711 .887 r
F
.80122 .49124 m .78988 .47392 L .81575 .46596 L F
.2758 .33 m .28319 .31444 L .29808 .33718 L .295 .466 .859 r
F
.2758 .33 m .26103 .30607 L .28319 .31444 L F
.42872 .51252 m .43874 .49082 L .4528 .50511 L .65 .753 .924 r
F
.42872 .51252 m .41452 .49836 L .43874 .49082 L F
.77699 .51577 m .79151 .49415 L .80265 .50841 L .65 .753 .925 r
F
.77699 .51577 m .76568 .50163 L .79151 .49415 L F
.24527 .28311 m .26103 .30607 L .25236 .29937 L 0 .226 .744 r
F
.86374 .49238 m .87904 .46718 L .88975 .48432 L .659 .714 .889 r
F
.86374 .49238 m .85287 .47525 L .87904 .46718 L F
.4908 .5118 m .50163 .49008 L .51519 .50438 L .65 .753 .925 r
F
.4908 .5118 m .47711 .49763 L .50163 .49008 L F
.70171 .4799 m .71507 .45442 L .72704 .47214 L .653 .704 .885 r
F
.70171 .4799 m .6896 .46213 L .71507 .45442 L F
.83935 .51513 m .85469 .4935 L .86532 .50778 L .65 .753 .925 r
F
.83935 .51513 m .82855 .50098 L .85469 .4935 L F
.50192 .44921 m .51291 .42387 L .52637 .44293 L .626 .678 .88 r
F
.50192 .44921 m .48837 .42991 L .51291 .42387 L F
.2042 .50812 m .21134 .4863 L .22731 .50065 L .651 .753 .924 r
F
.2042 .50812 m .18811 .4939 L .21134 .4863 L F
.55298 .51109 m .56462 .48935 L .57766 .50367 L .65 .753 .925 r
F
.55298 .51109 m .53979 .4969 L .56462 .48935 L F
.60188 .46645 m .61407 .44088 L .6268 .45915 L .644 .695 .882 r
F
.60188 .46645 m .58902 .44806 L .61407 .44088 L F
.90181 .51452 m .91797 .49287 L .92808 .50716 L .649 .752 .925 r
F
.90181 .51452 m .89152 .50035 L .91797 .49287 L F
.26621 .50735 m .27416 .48551 L .28962 .49987 L .651 .753 .924 r
F
.26621 .50735 m .25063 .49311 L .27416 .48551 L F
.61525 .5104 m .62771 .48864 L .64024 .50298 L .65 .753 .925 r
F
.61525 .5104 m .60257 .49619 L .62771 .48864 L F
.76425 .48183 m .77838 .45643 L .78988 .47392 L .656 .709 .887 r
F
.76425 .48183 m .7526 .46432 L .77838 .45643 L F
.46408 .4355 m .47462 .41046 L .48837 .42991 L .613 .669 .88 r
F
.46408 .4355 m .45025 .41575 L .47462 .41046 L F
.32832 .50659 m .33708 .48473 L .35202 .49911 L .651 .753 .924 r
F
.32832 .50659 m .31324 .49234 L .33708 .48473 L F
.67762 .50972 m .6909 .48794 L .70291 .5023 L .65 .753 .925 r
F
.67762 .50972 m .66545 .49549 L .6909 .48794 L F
.31278 .35983 m .32108 .34006 L .33581 .36186 L .447 .563 .879 r
F
.31278 .35983 m .29808 .33718 L .32108 .34006 L F
.66436 .46974 m .67732 .44418 L .6896 .46213 L .65 .702 .884 r
F
.66436 .46974 m .65194 .45173 L .67732 .44418 L F
.39051 .50584 m .40008 .48397 L .41452 .49836 L .651 .753 .924 r
F
.39051 .50584 m .37594 .49157 L .40008 .48397 L F
.82693 .48327 m .84184 .45793 L .85287 .47525 L .658 .713 .889 r
F
.82693 .48327 m .81575 .46596 L .84184 .45793 L F
.74009 .50905 m .75419 .48726 L .76568 .50163 L .65 .753 .925 r
F
.74009 .50905 m .72843 .49481 L .75419 .48726 L F
.56421 .45505 m .57598 .4295 L .58902 .44806 L .638 .69 .882 r
F
.56421 .45505 m .55106 .43634 L .57598 .4295 L F
.42615 .42036 m .43622 .39585 L .45025 .41575 L .594 .656 .88 r
F
.42615 .42036 m .41205 .40008 L .43622 .39585 L F
.4528 .50511 m .46319 .48321 L .47711 .49763 L .65 .753 .924 r
F
.4528 .50511 m .43874 .49082 L .46319 .48321 L F
.35035 .38354 m .35934 .36134 L .37387 .38238 L .523 .611 .882 r
F
.35035 .38354 m .33581 .36186 L .35934 .36134 L F
.80265 .50841 m .81757 .4866 L .82855 .50098 L .65 .753 .925 r
F
.80265 .50841 m .79151 .49415 L .81757 .4866 L F
.3882 .40329 m .39777 .37965 L .41205 .40008 L .567 .638 .881 r
F
.3882 .40329 m .37387 .38238 L .39777 .37965 L F
.88975 .48432 m .90545 .45907 L .916 .47623 L .659 .715 .89 r
F
.88975 .48432 m .87904 .46718 L .90545 .45907 L F
.51519 .50438 m .52639 .48247 L .53979 .4969 L .65 .753 .925 r
F
.51519 .50438 m .50163 .49008 L .52639 .48247 L F
.72704 .47214 m .74078 .44662 L .7526 .46432 L .653 .707 .887 r
F
.72704 .47214 m .71507 .45442 L .74078 .44662 L F
.16509 .50143 m .17176 .47944 L .18811 .4939 L .651 .753 .924 r
F
.16509 .50143 m .14862 .4871 L .17176 .47944 L F
.86532 .50778 m .88106 .48595 L .89152 .50035 L .649 .753 .925 r
F
.86532 .50778 m .85469 .4935 L .88106 .48595 L F
.26103 .30607 m .26811 .29158 L .28319 .31444 L .248 .44 .854 r
F
.26103 .30607 m .24607 .28208 L .26811 .29158 L F
.24527 .28311 m .24607 .28208 L .26103 .30607 L 0 .226 .744 r
F
.22731 .50065 m .23479 .47864 L .25063 .49311 L .651 .753 .924 r
F
.22731 .50065 m .21134 .4863 L .23479 .47864 L F
.57766 .50367 m .58968 .48174 L .60257 .49619 L .65 .753 .925 r
F
.57766 .50367 m .56462 .48935 L .58968 .48174 L F
.52637 .44293 m .53771 .41747 L .55106 .43634 L .63 .684 .882 r
F
.52637 .44293 m .51291 .42387 L .53771 .41747 L F
.6268 .45915 m .63935 .43353 L .65194 .45173 L .646 .698 .884 r
F
.6268 .45915 m .61407 .44088 L .63935 .43353 L F
.28962 .49987 m .29791 .47785 L .31324 .49234 L .651 .753 .924 r
F
.28962 .49987 m .27416 .48551 L .29791 .47785 L F
.78988 .47392 m .8044 .44846 L .81575 .46596 L .656 .711 .888 r
F
.78988 .47392 m .77838 .45643 L .8044 .44846 L F
.64024 .50298 m .65308 .48103 L .66545 .49549 L .65 .753 .925 r
F
.64024 .50298 m .62771 .48864 L .65308 .48103 L F
.35202 .49911 m .36113 .47707 L .37594 .49157 L .651 .753 .924 r
F
.35202 .49911 m .33708 .48473 L .36113 .47707 L F
.70291 .5023 m .71658 .48033 L .72843 .49481 L .65 .753 .925 r
F
.70291 .5023 m .6909 .48794 L .71658 .48033 L F
.48837 .42991 m .49927 .40465 L .51291 .42387 L .62 .677 .882 r
F
.48837 .42991 m .47462 .41046 L .49927 .40465 L F
.6896 .46213 m .70293 .43651 L .71507 .45442 L .65 .704 .886 r
F
.6896 .46213 m .67732 .44418 L .70293 .43651 L F
.85287 .47525 m .86818 .44985 L .87904 .46718 L .657 .714 .89 r
F
.85287 .47525 m .84184 .45793 L .86818 .44985 L F
.41452 .49836 m .42444 .4763 L .43874 .49082 L .65 .753 .924 r
F
.41452 .49836 m .40008 .48397 L .42444 .4763 L F
.76568 .50163 m .78018 .47965 L .79151 .49415 L .65 .753 .925 r
F
.76568 .50163 m .75419 .48726 L .78018 .47965 L F
.58902 .44806 m .60115 .42242 L .61407 .44088 L .641 .694 .884 r
F
.58902 .44806 m .57598 .4295 L .60115 .42242 L F
.24435 .2806 m .24607 .28208 L .24527 .28311 L 0 .226 .744 r
F
.47711 .49763 m .48785 .47554 L .50163 .49008 L .65 .753 .925 r
F
.47711 .49763 m .46319 .48321 L .48785 .47554 L F
.82855 .50098 m .84388 .47898 L .85469 .4935 L F
.82855 .50098 m .81757 .4866 L .84388 .47898 L F
.29808 .33718 m .30614 .31813 L .32108 .34006 L .42 .551 .881 r
F
.29808 .33718 m .28319 .31444 L .30614 .31813 L F
.45025 .41575 m .46068 .39085 L .47462 .41046 L .606 .667 .883 r
F
.45025 .41575 m .43622 .39585 L .46068 .39085 L F
.7526 .46432 m .76671 .43874 L .77838 .45643 L .654 .709 .888 r
F
.7526 .46432 m .74078 .44662 L .76671 .43874 L F
.18811 .4939 m .19511 .47172 L .21134 .4863 L .651 .753 .924 r
F
.18811 .4939 m .17176 .47944 L .19511 .47172 L F
.53979 .4969 m .55136 .47479 L .56462 .48935 L .65 .753 .925 r
F
.53979 .4969 m .52639 .48247 L .55136 .47479 L F
.89152 .50035 m .90768 .47834 L .91797 .49287 L .649 .752 .925 r
F
.89152 .50035 m .88106 .48595 L .90768 .47834 L F
.24183 .27533 m .24607 .28208 L .24435 .2806 L 0 .208 .734 r
F
.25063 .49311 m .25844 .47091 L .27416 .48551 L .651 .753 .924 r
F
.25063 .49311 m .23479 .47864 L .25844 .47091 L F
.60257 .49619 m .61497 .47406 L .62771 .48864 L .65 .753 .925 r
F
.60257 .49619 m .58968 .48174 L .61497 .47406 L F
.41205 .40008 m .422 .37579 L .43622 .39585 L .585 .654 .884 r
F
.41205 .40008 m .39777 .37965 L .422 .37579 L F
.65194 .45173 m .66486 .42604 L .67732 .44418 L .647 .702 .886 r
F
.65194 .45173 m .63935 .43353 L .66486 .42604 L F
.33581 .36186 m .34461 .34015 L .35934 .36134 L .506 .605 .885 r
F
.33581 .36186 m .32108 .34006 L .34461 .34015 L F
.55106 .43634 m .56276 .41076 L .57598 .4295 L .634 .689 .884 r
F
.55106 .43634 m .53771 .41747 L .56276 .41076 L F
.24607 .28208 m .25282 .2686 L .26811 .29158 L .198 .412 .845 r
F
.23722 .26106 m .24607 .28208 L .24183 .27533 L F
.23722 .26106 m .25282 .2686 L .24607 .28208 L F
.81575 .46596 m .83066 .44042 L .84184 .45793 L .656 .713 .89 r
F
.81575 .46596 m .8044 .44846 L .83066 .44042 L F
.37387 .38238 m .38328 .35908 L .39777 .37965 L .555 .635 .885 r
F
.37387 .38238 m .35934 .36134 L .38328 .35908 L F
.31324 .49234 m .32188 .47011 L .33708 .48473 L .651 .753 .924 r
F
.31324 .49234 m .29791 .47785 L .32188 .47011 L F
.66545 .49549 m .67868 .47335 L .6909 .48794 L .65 .753 .925 r
F
.66545 .49549 m .65308 .48103 L .67868 .47335 L F
.37594 .49157 m .3854 .46933 L .40008 .48397 L .651 .753 .924 r
F
.37594 .49157 m .36113 .47707 L .3854 .46933 L F
.72843 .49481 m .74249 .47265 L .75419 .48726 L .65 .753 .925 r
F
.72843 .49481 m .71658 .48033 L .74249 .47265 L F
.87904 .46718 m .89475 .4417 L .90545 .45907 L .657 .716 .891 r
F
.87904 .46718 m .86818 .44985 L .89475 .4417 L F
.71507 .45442 m .72878 .42873 L .74078 .44662 L .651 .707 .888 r
F
.71507 .45442 m .70293 .43651 L .72878 .42873 L F
.43874 .49082 m .44903 .46856 L .46319 .48321 L .65 .753 .924 r
F
.43874 .49082 m .42444 .4763 L .44903 .46856 L F
.79151 .49415 m .80641 .47197 L .81757 .4866 L .65 .753 .925 r
F
.79151 .49415 m .78018 .47965 L .80641 .47197 L F
.51291 .42387 m .52417 .39842 L .53771 .41747 L .626 .683 .885 r
F
.51291 .42387 m .49927 .40465 L .52417 .39842 L F
.61407 .44088 m .62656 .41515 L .63935 .43353 L .643 .698 .886 r
F
.61407 .44088 m .60115 .42242 L .62656 .41515 L F
.50163 .49008 m .51275 .4678 L .52639 .48247 L .65 .753 .925 r
F
.50163 .49008 m .48785 .47554 L .51275 .4678 L F
.14862 .4871 m .15513 .46474 L .17176 .47944 L .651 .753 .924 r
F
.14862 .4871 m .13187 .47253 L .15513 .46474 L F
.85469 .4935 m .87043 .4713 L .88106 .48595 L .649 .753 .925 r
F
.85469 .4935 m .84388 .47898 L .87043 .4713 L F
.77838 .45643 m .79289 .43077 L .8044 .44846 L .654 .711 .89 r
F
.77838 .45643 m .76671 .43874 L .79289 .43077 L F
.21134 .4863 m .21867 .46392 L .23479 .47864 L .651 .753 .924 r
F
.21134 .4863 m .19511 .47172 L .21867 .46392 L F
.56462 .48935 m .57657 .46705 L .58968 .48174 L .65 .753 .925 r
F
.56462 .48935 m .55136 .47479 L .57657 .46705 L F
.47462 .41046 m .48543 .38525 L .49927 .40465 L .614 .676 .885 r
F
.47462 .41046 m .46068 .39085 L .48543 .38525 L F
.27416 .48551 m .28232 .46311 L .29791 .47785 L .651 .753 .924 r
F
.27416 .48551 m .25844 .47091 L .28232 .46311 L F
.62771 .48864 m .6405 .46632 L .65308 .48103 L .65 .753 .925 r
F
.62771 .48864 m .61497 .47406 L .6405 .46632 L F
.28319 .31444 m .291 .29606 L .30614 .31813 L .392 .538 .883 r
F
.28319 .31444 m .26811 .29158 L .291 .29606 L F
.67732 .44418 m .69062 .41841 L .70293 .43651 L .648 .704 .888 r
F
.67732 .44418 m .66486 .42604 L .69062 .41841 L F
.84184 .45793 m .85715 .43231 L .86818 .44985 L .656 .714 .891 r
F
.84184 .45793 m .83066 .44042 L .85715 .43231 L F
.33708 .48473 m .34606 .46231 L .36113 .47707 L .651 .753 .924 r
F
.33708 .48473 m .32188 .47011 L .34606 .46231 L F
.57598 .4295 m .58805 .40378 L .60115 .42242 L .637 .694 .886 r
F
.57598 .4295 m .56276 .41076 L .58805 .40378 L F
.6909 .48794 m .70452 .4656 L .71658 .48033 L .65 .753 .925 r
F
.6909 .48794 m .67868 .47335 L .70452 .4656 L F
.43622 .39585 m .44654 .37106 L .46068 .39085 L .599 .666 .886 r
F
.43622 .39585 m .422 .37579 L .44654 .37106 L F
.40008 .48397 m .4099 .46152 L .42444 .4763 L .65 .753 .924 r
F
.40008 .48397 m .3854 .46933 L .4099 .46152 L F
.75419 .48726 m .76865 .4649 L .78018 .47965 L .65 .753 .925 r
F
.75419 .48726 m .74249 .47265 L .76865 .4649 L F
.74078 .44662 m .75487 .42085 L .76671 .43874 L .652 .709 .89 r
F
.74078 .44662 m .72878 .42873 L .75487 .42085 L F
.32108 .34006 m .32968 .31882 L .34461 .34015 L .489 .598 .889 r
F
.32108 .34006 m .30614 .31813 L .32968 .31882 L F
.46319 .48321 m .47384 .46075 L .48785 .47554 L .65 .753 .925 r
F
.46319 .48321 m .44903 .46856 L .47384 .46075 L F
.81757 .4866 m .83289 .46422 L .84388 .47898 L F
.81757 .4866 m .80641 .47197 L .83289 .46422 L F
.39777 .37965 m .40757 .35556 L .422 .37579 L .576 .651 .887 r
F
.39777 .37965 m .38328 .35908 L .40757 .35556 L F
.35934 .36134 m .36858 .33834 L .38328 .35908 L .543 .631 .888 r
F
.35934 .36134 m .34461 .34015 L .36858 .33834 L F
.63935 .43353 m .65222 .40771 L .66486 .42604 L .644 .701 .888 r
F
.63935 .43353 m .62656 .41515 L .65222 .40771 L F
.17176 .47944 m .1786 .45688 L .19511 .47172 L .651 .753 .924 r
F
.17176 .47944 m .15513 .46474 L .1786 .45688 L F
.52639 .48247 m .53788 .45999 L .55136 .47479 L .65 .753 .925 r
F
.52639 .48247 m .51275 .4678 L .53788 .45999 L F
.53771 .41747 m .54934 .39183 L .56276 .41076 L .63 .689 .886 r
F
.53771 .41747 m .52417 .39842 L .54934 .39183 L F
.88106 .48595 m .89722 .46356 L .90768 .47834 L .649 .752 .925 r
F
.88106 .48595 m .87043 .4713 L .89722 .46356 L F
.8044 .44846 m .8193 .42271 L .83066 .44042 L .654 .713 .891 r
F
.8044 .44846 m .79289 .43077 L .8193 .42271 L F
.23479 .47864 m .24246 .45606 L .25844 .47091 L .651 .753 .924 r
F
.23479 .47864 m .21867 .46392 L .24246 .45606 L F
.58968 .48174 m .60202 .45924 L .61497 .47406 L .65 .753 .925 r
F
.58968 .48174 m .57657 .46705 L .60202 .45924 L F
.29791 .47785 m .30642 .45524 L .32188 .47011 L .651 .753 .924 r
F
.29791 .47785 m .28232 .46311 L .30642 .45524 L F
.65308 .48103 m .66626 .4585 L .67868 .47335 L .65 .753 .925 r
F
.65308 .48103 m .6405 .46632 L .66626 .4585 L F
.70293 .43651 m .71661 .41064 L .72878 .42873 L .649 .707 .89 r
F
.70293 .43651 m .69062 .41841 L .71661 .41064 L F
.23366 .25266 m .25282 .2686 L .23722 .26106 L .147 .383 .835 r
F
.86818 .44985 m .88389 .42413 L .89475 .4417 L .656 .716 .892 r
F
.86818 .44985 m .85715 .43231 L .88389 .42413 L F
.49927 .40465 m .51044 .37918 L .52417 .39842 L .621 .683 .887 r
F
.49927 .40465 m .48543 .38525 L .51044 .37918 L F
.36113 .47707 m .37047 .45444 L .3854 .46933 L .651 .753 .924 r
F
.36113 .47707 m .34606 .46231 L .37047 .45444 L F
.71658 .48033 m .73061 .45779 L .74249 .47265 L .65 .753 .925 r
F
.71658 .48033 m .70452 .4656 L .73061 .45779 L F
.60115 .42242 m .61359 .39658 L .62656 .41515 L .639 .698 .888 r
F
.60115 .42242 m .58805 .40378 L .61359 .39658 L F
.42444 .4763 m .43463 .45365 L .44903 .46856 L .65 .753 .924 r
F
.42444 .4763 m .4099 .46152 L .43463 .45365 L F
.78018 .47965 m .79505 .45709 L .80641 .47197 L .65 .753 .925 r
F
.78018 .47965 m .76865 .4649 L .79505 .45709 L F
.26811 .29158 m .27565 .27385 L .291 .29606 L .363 .525 .883 r
F
.26811 .29158 m .25282 .2686 L .27565 .27385 L F
.76671 .43874 m .7812 .41287 L .79289 .43077 L .652 .711 .891 r
F
.76671 .43874 m .75487 .42085 L .7812 .41287 L F
.48785 .47554 m .49889 .45287 L .51275 .4678 L .65 .753 .925 r
F
.48785 .47554 m .47384 .46075 L .49889 .45287 L F
.13187 .47253 m .13821 .44979 L .15513 .46474 L .651 .753 .924 r
F
.13187 .47253 m .11483 .45772 L .13821 .44979 L F
.46068 .39085 m .47138 .36568 L .48543 .38525 L .609 .675 .888 r
F
.46068 .39085 m .44654 .37106 L .47138 .36568 L F
.84388 .47898 m .85961 .4564 L .87043 .4713 L .649 .753 .925 r
F
.84388 .47898 m .83289 .46422 L .85961 .4564 L F
.19511 .47172 m .20229 .44895 L .21867 .46392 L .651 .753 .924 r
F
.19511 .47172 m .1786 .45688 L .20229 .44895 L F
.55136 .47479 m .56324 .45211 L .57657 .46705 L .65 .753 .925 r
F
.55136 .47479 m .53788 .45999 L .56324 .45211 L F
.66486 .42604 m .67811 .4001 L .69062 .41841 L .646 .704 .89 r
F
.66486 .42604 m .65222 .40771 L .67811 .4001 L F
.56276 .41076 m .57476 .38495 L .58805 .40378 L .634 .694 .888 r
F
.56276 .41076 m .54934 .39183 L .57476 .38495 L F
.83066 .44042 m .84596 .41457 L .85715 .43231 L .654 .715 .892 r
F
.83066 .44042 m .8193 .42271 L .84596 .41457 L F
.422 .37579 m .4322 .3511 L .44654 .37106 L .592 .664 .889 r
F
.422 .37579 m .40757 .35556 L .4322 .3511 L F
.25844 .47091 m .26646 .44812 L .28232 .46311 L .651 .753 .924 r
F
.25844 .47091 m .24246 .45606 L .26646 .44812 L F
.61497 .47406 m .6277 .45136 L .6405 .46632 L .65 .753 .925 r
F
.61497 .47406 m .60202 .45924 L .6277 .45136 L F
.30614 .31813 m .31453 .29732 L .32968 .31882 L .471 .591 .891 r
F
.30614 .31813 m .291 .29606 L .31453 .29732 L F
.32188 .47011 m .33074 .4473 L .34606 .46231 L .651 .753 .924 r
F
.32188 .47011 m .30642 .45524 L .33074 .4473 L F
.67868 .47335 m .69226 .45062 L .70452 .4656 L .65 .753 .925 r
F
.67868 .47335 m .66626 .4585 L .69226 .45062 L F
.38328 .35908 m .39294 .33516 L .40757 .35556 L .567 .649 .89 r
F
.38328 .35908 m .36858 .33834 L .39294 .33516 L F
.23366 .25266 m .23732 .2455 L .25282 .2686 L .147 .383 .835 r
F
.22948 .2413 m .23732 .2455 L .23366 .25266 L F
.34461 .34015 m .35368 .31744 L .36858 .33834 L .53 .627 .892 r
F
.34461 .34015 m .32968 .31882 L .35368 .31744 L F
.72878 .42873 m .74285 .40276 L .75487 .42085 L .65 .709 .891 r
F
.72878 .42873 m .71661 .41064 L .74285 .40276 L F
.3854 .46933 m .39511 .4465 L .4099 .46152 L .65 .753 .924 r
F
.3854 .46933 m .37047 .45444 L .39511 .4465 L F
.74249 .47265 m .75693 .4499 L .76865 .4649 L .65 .753 .925 r
F
.74249 .47265 m .73061 .45779 L .75693 .4499 L F
.52417 .39842 m .53572 .37271 L .54934 .39183 L .626 .688 .889 r
F
.52417 .39842 m .51044 .37918 L .53572 .37271 L F
.62656 .41515 m .63938 .38918 L .65222 .40771 L .641 .701 .89 r
F
.62656 .41515 m .61359 .39658 L .63938 .38918 L F
.44903 .46856 m .45959 .4457 L .47384 .46075 L .65 .753 .925 r
F
.44903 .46856 m .43463 .45365 L .45959 .4457 L F
.80641 .47197 m .8217 .4492 L .83289 .46422 L F
.80641 .47197 m .79505 .45709 L .8217 .4492 L F
.79289 .43077 m .80778 .40479 L .8193 .42271 L .652 .713 .892 r
F
.79289 .43077 m .7812 .41287 L .80778 .40479 L F
.15513 .46474 m .1618 .44179 L .1786 .45688 L .651 .753 .924 r
F
.15513 .46474 m .13821 .44979 L .1618 .44179 L F
.51275 .4678 m .52416 .44492 L .53788 .45999 L .65 .753 .925 r
F
.51275 .4678 m .49889 .45287 L .52416 .44492 L F
.87043 .4713 m .88659 .44852 L .89722 .46356 L .649 .752 .925 r
F
.87043 .4713 m .85961 .4564 L .88659 .44852 L F
.21867 .46392 m .2262 .44095 L .24246 .45606 L .651 .753 .924 r
F
.21867 .46392 m .20229 .44895 L .2262 .44095 L F
.57657 .46705 m .58884 .44416 L .60202 .45924 L .65 .753 .925 r
F
.57657 .46705 m .56324 .45211 L .58884 .44416 L F
.48543 .38525 m .4965 .35975 L .51044 .37918 L .616 .682 .889 r
F
.48543 .38525 m .47138 .36568 L .4965 .35975 L F
.69062 .41841 m .70426 .39235 L .71661 .41064 L .647 .707 .891 r
F
.69062 .41841 m .67811 .4001 L .70426 .39235 L F
.85715 .43231 m .87287 .40634 L .88389 .42413 L .654 .716 .894 r
F
.85715 .43231 m .84596 .41457 L .87287 .40634 L F
.25282 .2686 m .26007 .25148 L .27565 .27385 L .333 .51 .882 r
F
.25282 .2686 m .23732 .2455 L .26007 .25148 L F
.58805 .40378 m .60043 .37781 L .61359 .39658 L .636 .698 .89 r
F
.58805 .40378 m .57476 .38495 L .60043 .37781 L F
.28232 .46311 m .29069 .44012 L .30642 .45524 L .651 .753 .924 r
F
.28232 .46311 m .26646 .44812 L .29069 .44012 L F
.6405 .46632 m .65362 .44341 L .66626 .4585 L .65 .753 .925 r
F
.6405 .46632 m .6277 .45136 L .65362 .44341 L F
.34606 .46231 m .35529 .43929 L .37047 .45444 L .651 .753 .924 r
F
.34606 .46231 m .33074 .4473 L .35529 .43929 L F
.70452 .4656 m .71851 .44267 L .73061 .45779 L .65 .753 .925 r
F
.70452 .4656 m .69226 .45062 L .71851 .44267 L F
.44654 .37106 m .45713 .34591 L .47138 .36568 L .603 .673 .89 r
F
.44654 .37106 m .4322 .3511 L .45713 .34591 L F
.75487 .42085 m .76934 .39476 L .7812 .41287 L .65 .711 .892 r
F
.75487 .42085 m .74285 .40276 L .76934 .39476 L F
.4099 .46152 m .41998 .43849 L .43463 .45365 L .65 .753 .924 r
F
.4099 .46152 m .39511 .4465 L .41998 .43849 L F
.76865 .4649 m .78351 .44195 L .79505 .45709 L .65 .753 .925 r
F
.76865 .4649 m .75693 .4499 L .78351 .44195 L F
.22111 .2232 m .23732 .2455 L .22948 .2413 L .094 .351 .821 r
F
.65222 .40771 m .66542 .38159 L .67811 .4001 L .643 .704 .891 r
F
.65222 .40771 m .63938 .38918 L .66542 .38159 L F
.291 .29606 m .29916 .27565 L .31453 .29732 L .452 .583 .894 r
F
.291 .29606 m .27565 .27385 L .29916 .27565 L F
.47384 .46075 m .48478 .43769 L .49889 .45287 L .65 .753 .925 r
F
.47384 .46075 m .45959 .4457 L .48478 .43769 L F
.11483 .45772 m .121 .43458 L .13821 .44979 L .651 .753 .924 r
F
.11483 .45772 m .0975 .44265 L .121 .43458 L F
.40757 .35556 m .41764 .33095 L .4322 .3511 L .584 .662 .892 r
F
.40757 .35556 m .39294 .33516 L .41764 .33095 L F
.54934 .39183 m .56126 .36591 L .57476 .38495 L .63 .693 .89 r
F
.54934 .39183 m .53572 .37271 L .56126 .36591 L F
.83289 .46422 m .84861 .44125 L .85961 .4564 L .649 .753 .925 r
F
.83289 .46422 m .8217 .4492 L .84861 .44125 L F
.8193 .42271 m .8346 .39661 L .84596 .41457 L .653 .715 .894 r
F
.8193 .42271 m .80778 .40479 L .8346 .39661 L F
.1786 .45688 m .18562 .43372 L .20229 .44895 L .651 .753 .924 r
F
.1786 .45688 m .1618 .44179 L .18562 .43372 L F
.53788 .45999 m .54968 .43691 L .56324 .45211 L .65 .753 .925 r
F
.53788 .45999 m .52416 .44492 L .54968 .43691 L F
.36858 .33834 m .37809 .31458 L .39294 .33516 L .558 .646 .893 r
F
.36858 .33834 m .35368 .31744 L .37809 .31458 L F
.32968 .31882 m .33855 .29636 L .35368 .31744 L .518 .622 .895 r
F
.32968 .31882 m .31453 .29732 L .33855 .29636 L F
.24246 .45606 m .25033 .43288 L .26646 .44812 L .651 .753 .924 r
F
.24246 .45606 m .2262 .44095 L .25033 .43288 L F
.60202 .45924 m .61468 .43614 L .6277 .45136 L .65 .753 .925 r
F
.60202 .45924 m .58884 .44416 L .61468 .43614 L F
.71661 .41064 m .73065 .38445 L .74285 .40276 L .648 .709 .892 r
F
.71661 .41064 m .70426 .39235 L .73065 .38445 L F
.51044 .37918 m .52189 .35339 L .53572 .37271 L .622 .688 .891 r
F
.51044 .37918 m .4965 .35975 L .52189 .35339 L F
.30642 .45524 m .31515 .43204 L .33074 .4473 L .651 .753 .924 r
F
.30642 .45524 m .29069 .44012 L .31515 .43204 L F
.66626 .4585 m .67979 .43538 L .69226 .45062 L .65 .753 .925 r
F
.66626 .4585 m .65362 .44341 L .67979 .43538 L F
.61359 .39658 m .62636 .37044 L .63938 .38918 L .639 .701 .891 r
F
.61359 .39658 m .60043 .37781 L .62636 .37044 L F
.37047 .45444 m .38007 .43121 L .39511 .4465 L .65 .753 .924 r
F
.37047 .45444 m .35529 .43929 L .38007 .43121 L F
.73061 .45779 m .74501 .43465 L .75693 .4499 L .65 .753 .925 r
F
.73061 .45779 m .71851 .44267 L .74501 .43465 L F
.7812 .41287 m .79608 .38665 L .80778 .40479 L .651 .713 .894 r
F
.7812 .41287 m .76934 .39476 L .79608 .38665 L F
.23732 .2455 m .24427 .22894 L .26007 .25148 L .302 .494 .88 r
F
.23732 .2455 m .22161 .22225 L .24427 .22894 L F
.22111 .2232 m .22161 .22225 L .23732 .2455 L .094 .351 .821 r
F
.43463 .45365 m .44509 .4304 L .45959 .4457 L .65 .753 .925 r
F
.43463 .45365 m .41998 .43849 L .44509 .4304 L F
.79505 .45709 m .81033 .43393 L .8217 .4492 L F
.79505 .45709 m .78351 .44195 L .81033 .43393 L F
.47138 .36568 m .48235 .34013 L .4965 .35975 L .611 .681 .892 r
F
.47138 .36568 m .45713 .34591 L .48235 .34013 L F
.13821 .44979 m .14472 .42644 L .1618 .44179 L .651 .753 .924 r
F
.13821 .44979 m .121 .43458 L .14472 .42644 L F
.49889 .45287 m .51021 .4296 L .52416 .44492 L .65 .753 .925 r
F
.49889 .45287 m .48478 .43769 L .51021 .4296 L F
.67811 .4001 m .69172 .37384 L .70426 .39235 L .644 .707 .892 r
F
.67811 .4001 m .66542 .38159 L .69172 .37384 L F
.85961 .4564 m .87576 .43323 L .88659 .44852 L .649 .752 .925 r
F
.85961 .4564 m .84861 .44125 L .87576 .43323 L F
.57476 .38495 m .58706 .35882 L .60043 .37781 L .633 .697 .892 r
F
.57476 .38495 m .56126 .36591 L .58706 .35882 L F
.84596 .41457 m .86168 .38833 L .87287 .40634 L .653 .716 .895 r
F
.84596 .41457 m .8346 .39661 L .86168 .38833 L F
.20229 .44895 m .20966 .42558 L .2262 .44095 L .651 .753 .924 r
F
.20229 .44895 m .18562 .43372 L .20966 .42558 L F
.56324 .45211 m .57544 .42882 L .58884 .44416 L .65 .753 .925 r
F
.56324 .45211 m .54968 .43691 L .57544 .42882 L F
.4322 .3511 m .44266 .32594 L .45713 .34591 L .597 .672 .893 r
F
.4322 .3511 m .41764 .33095 L .44266 .32594 L F
.26646 .44812 m .2747 .42473 L .29069 .44012 L .651 .753 .924 r
F
.26646 .44812 m .25033 .43288 L .2747 .42473 L F
.6277 .45136 m .64077 .42805 L .65362 .44341 L .65 .753 .925 r
F
.6277 .45136 m .61468 .43614 L .64077 .42805 L F
.74285 .40276 m .7573 .37643 L .76934 .39476 L .648 .711 .894 r
F
.74285 .40276 m .73065 .38445 L .7573 .37643 L F
.27565 .27385 m .28356 .25381 L .29916 .27565 L .433 .575 .896 r
F
.27565 .27385 m .26007 .25148 L .28356 .25381 L F
.33074 .4473 m .33984 .42389 L .35529 .43929 L .651 .753 .924 r
F
.33074 .4473 m .31515 .43204 L .33984 .42389 L F
.69226 .45062 m .70621 .42729 L .71851 .44267 L .65 .753 .925 r
F
.69226 .45062 m .67979 .43538 L .70621 .42729 L F
.39294 .33516 m .40286 .3106 L .41764 .33095 L .577 .66 .894 r
F
.39294 .33516 m .37809 .31458 L .40286 .3106 L F
.63938 .38918 m .65254 .36286 L .66542 .38159 L .641 .704 .893 r
F
.63938 .38918 m .62636 .37044 L .65254 .36286 L F
.53572 .37271 m .54756 .34666 L .56126 .36591 L .627 .693 .892 r
F
.53572 .37271 m .52189 .35339 L .54756 .34666 L F
.39511 .4465 m .40508 .42306 L .41998 .43849 L .65 .753 .924 r
F
.39511 .4465 m .38007 .43121 L .40508 .42306 L F
.31453 .29732 m .32321 .27509 L .33855 .29636 L .505 .618 .897 r
F
.31453 .29732 m .29916 .27565 L .32321 .27509 L F
.35368 .31744 m .36301 .2938 L .37809 .31458 L .549 .643 .896 r
F
.35368 .31744 m .33855 .29636 L .36301 .2938 L F
.75693 .4499 m .77176 .42655 L .78351 .44195 L .65 .753 .925 r
F
.75693 .4499 m .74501 .43465 L .77176 .42655 L F
.80778 .40479 m .82307 .37842 L .8346 .39661 L .651 .715 .895 r
F
.80778 .40479 m .79608 .38665 L .82307 .37842 L F
.45959 .4457 m .47043 .42224 L .48478 .43769 L .65 .753 .925 r
F
.45959 .4457 m .44509 .4304 L .47043 .42224 L F
.0975 .44265 m .10349 .41911 L .121 .43458 L .651 .753 .924 r
F
.0975 .44265 m .07988 .42732 L .10349 .41911 L F
.8217 .4492 m .83741 .42583 L .84861 .44125 L .649 .753 .925 r
F
.8217 .4492 m .81033 .43393 L .83741 .42583 L F
.22045 .22157 m .22161 .22225 L .22111 .2232 L .094 .351 .821 r
F
.1618 .44179 m .16866 .41823 L .18562 .43372 L .651 .753 .924 r
F
.1618 .44179 m .14472 .42644 L .16866 .41823 L F
.52416 .44492 m .53588 .42144 L .54968 .43691 L .65 .753 .925 r
F
.52416 .44492 m .51021 .4296 L .53588 .42144 L F
.70426 .39235 m .71826 .36593 L .73065 .38445 L .646 .709 .894 r
F
.70426 .39235 m .69172 .37384 L .71826 .36593 L F
.4965 .35975 m .50786 .33386 L .52189 .35339 L .618 .687 .893 r
F
.4965 .35975 m .48235 .34013 L .50786 .33386 L F
.21858 .2178 m .22161 .22225 L .22045 .22157 L .061 .348 .823 r
F
.2262 .44095 m .23392 .41736 L .25033 .43288 L .651 .753 .924 r
F
.2262 .44095 m .20966 .42558 L .23392 .41736 L F
.58884 .44416 m .60144 .42065 L .61468 .43614 L .65 .753 .925 r
F
.58884 .44416 m .57544 .42882 L .60144 .42065 L F
.60043 .37781 m .61313 .35148 L .62636 .37044 L .636 .701 .893 r
F
.60043 .37781 m .58706 .35882 L .61313 .35148 L F
.22161 .22225 m .22824 .20623 L .24427 .22894 L .27 .478 .877 r
F
.21231 .20103 m .22161 .22225 L .21858 .2178 L F
.21231 .20103 m .22824 .20623 L .22161 .22225 L F
.29069 .44012 m .29929 .41651 L .31515 .43204 L .651 .753 .924 r
F
.29069 .44012 m .2747 .42473 L .29929 .41651 L F
.65362 .44341 m .6671 .41988 L .67979 .43538 L .65 .753 .925 r
F
.65362 .44341 m .64077 .42805 L .6671 .41988 L F
.76934 .39476 m .7842 .36828 L .79608 .38665 L .649 .713 .895 r
F
.76934 .39476 m .7573 .37643 L .7842 .36828 L F
.45713 .34591 m .46798 .32029 L .48235 .34013 L .606 .68 .894 r
F
.45713 .34591 m .44266 .32594 L .46798 .32029 L F
.35529 .43929 m .36476 .41566 L .38007 .43121 L .65 .753 .924 r
F
.35529 .43929 m .33984 .42389 L .36476 .41566 L F
.71851 .44267 m .73288 .41913 L .74501 .43465 L .65 .753 .925 r
F
.71851 .44267 m .70621 .42729 L .73288 .41913 L F
.66542 .38159 m .67898 .3551 L .69172 .37384 L .642 .707 .894 r
F
.66542 .38159 m .65254 .36286 L .67898 .3551 L F
.41998 .43849 m .43034 .41483 L .44509 .4304 L .65 .753 .925 r
F
.41998 .43849 m .40508 .42306 L .43034 .41483 L F
.78351 .44195 m .79876 .41839 L .81033 .43393 L F
.78351 .44195 m .77176 .42655 L .79876 .41839 L F
.56126 .36591 m .57349 .33962 L .58706 .35882 L .63 .697 .893 r
F
.56126 .36591 m .54756 .34666 L .57349 .33962 L F
.8346 .39661 m .85031 .3701 L .86168 .38833 L .652 .716 .896 r
F
.8346 .39661 m .82307 .37842 L .85031 .3701 L F
.41764 .33095 m .42797 .30576 L .44266 .32594 L .591 .671 .895 r
F
.41764 .33095 m .40286 .3106 L .42797 .30576 L F
.121 .43458 m .12733 .41083 L .14472 .42644 L .651 .753 .924 r
F
.121 .43458 m .10349 .41911 L .12733 .41083 L F
.48478 .43769 m .49601 .41401 L .51021 .4296 L .65 .753 .925 r
F
.48478 .43769 m .47043 .42224 L .49601 .41401 L F
.84861 .44125 m .86475 .41767 L .87576 .43323 L .649 .752 .925 r
F
.84861 .44125 m .83741 .42583 L .86475 .41767 L F
.26007 .25148 m .26773 .23178 L .28356 .25381 L .413 .567 .897 r
F
.26007 .25148 m .24427 .22894 L .26773 .23178 L F
.18562 .43372 m .19283 .40994 L .20966 .42558 L .651 .753 .924 r
F
.18562 .43372 m .16866 .41823 L .19283 .40994 L F
.54968 .43691 m .5618 .41321 L .57544 .42882 L .65 .753 .925 r
F
.54968 .43691 m .53588 .42144 L .5618 .41321 L F
.73065 .38445 m .74507 .35787 L .7573 .37643 L .647 .712 .895 r
F
.73065 .38445 m .71826 .36593 L .74507 .35787 L F
.37809 .31458 m .38786 .29005 L .40286 .3106 L .57 .658 .897 r
F
.37809 .31458 m .36301 .2938 L .38786 .29005 L F
.29916 .27565 m .30763 .25363 L .32321 .27509 L .492 .613 .9 r
F
.29916 .27565 m .28356 .25381 L .30763 .25363 L F
.25033 .43288 m .25842 .40907 L .2747 .42473 L .651 .753 .924 r
F
.25033 .43288 m .23392 .41736 L .25842 .40907 L F
.61468 .43614 m .62769 .41242 L .64077 .42805 L .65 .753 .925 r
F
.61468 .43614 m .60144 .42065 L .62769 .41242 L F
.33855 .29636 m .34771 .27282 L .36301 .2938 L .539 .64 .899 r
F
.33855 .29636 m .32321 .27509 L .34771 .27282 L F
.52189 .35339 m .53364 .3272 L .54756 .34666 L .623 .693 .894 r
F
.52189 .35339 m .50786 .33386 L .53364 .3272 L F
.62636 .37044 m .63946 .34391 L .65254 .36286 L .638 .704 .894 r
F
.62636 .37044 m .61313 .35148 L .63946 .34391 L F
.31515 .43204 m .32412 .40821 L .33984 .42389 L .651 .753 .924 r
F
.31515 .43204 m .29929 .41651 L .32412 .40821 L F
.67979 .43538 m .69369 .41164 L .70621 .42729 L .65 .753 .925 r
F
.67979 .43538 m .6671 .41988 L .69369 .41164 L F
.79608 .38665 m .81135 .36001 L .82307 .37842 L .65 .715 .896 r
F
.79608 .38665 m .7842 .36828 L .81135 .36001 L F
.38007 .43121 m .38992 .40736 L .40508 .42306 L .65 .753 .924 r
F
.38007 .43121 m .36476 .41566 L .38992 .40736 L F
.74501 .43465 m .7598 .41089 L .77176 .42655 L .65 .753 .925 r
F
.74501 .43465 m .73288 .41913 L .7598 .41089 L F
.44509 .4304 m .45583 .40653 L .47043 .42224 L F
.44509 .4304 m .43034 .41483 L .45583 .40653 L F
.07988 .42732 m .08568 .40337 L .10349 .41911 L .651 .753 .924 r
F
.07988 .42732 m .06194 .41172 L .08568 .40337 L F
.48235 .34013 m .4936 .31412 L .50786 .33386 L .614 .687 .895 r
F
.48235 .34013 m .46798 .32029 L .4936 .31412 L F
.81033 .43393 m .82602 .41015 L .83741 .42583 L .649 .753 .925 r
F
.81033 .43393 m .79876 .41839 L .82602 .41015 L F
.69172 .37384 m .70568 .34717 L .71826 .36593 L .644 .709 .895 r
F
.69172 .37384 m .67898 .3551 L .70568 .34717 L F
.58706 .35882 m .59969 .33229 L .61313 .35148 L .633 .701 .894 r
F
.58706 .35882 m .57349 .33962 L .59969 .33229 L F
.14472 .42644 m .1514 .40247 L .16866 .41823 L .651 .753 .924 r
F
.14472 .42644 m .12733 .41083 L .1514 .40247 L F
.51021 .4296 m .52184 .40571 L .53588 .42144 L .65 .753 .925 r
F
.51021 .4296 m .49601 .41401 L .52184 .40571 L F
.20966 .42558 m .21723 .40158 L .23392 .41736 L .651 .753 .924 r
F
.20966 .42558 m .19283 .40994 L .21723 .40158 L F
.57544 .42882 m .58796 .4049 L .60144 .42065 L .65 .753 .925 r
F
.57544 .42882 m .5618 .41321 L .58796 .4049 L F
.44266 .32594 m .45339 .30023 L .46798 .32029 L .602 .679 .896 r
F
.44266 .32594 m .42797 .30576 L .45339 .30023 L F
.7573 .37643 m .77213 .34968 L .7842 .36828 L .648 .713 .896 r
F
.7573 .37643 m .74507 .35787 L .77213 .34968 L F
.2747 .42473 m .28315 .4007 L .29929 .41651 L .651 .753 .924 r
F
.2747 .42473 m .25842 .40907 L .28315 .4007 L F
.64077 .42805 m .65419 .40411 L .6671 .41988 L .65 .753 .925 r
F
.64077 .42805 m .62769 .41242 L .65419 .40411 L F
.65254 .36286 m .66605 .33614 L .67898 .3551 L .64 .707 .895 r
F
.65254 .36286 m .63946 .34391 L .66605 .33614 L F
.24427 .22894 m .25167 .20954 L .26773 .23178 L .393 .558 .898 r
F
.24427 .22894 m .22824 .20623 L .25167 .20954 L F
.33984 .42389 m .34919 .39984 L .36476 .41566 L .65 .753 .924 r
F
.33984 .42389 m .32412 .40821 L .34919 .39984 L F
.54756 .34666 m .55971 .32019 L .57349 .33962 L .627 .697 .895 r
F
.54756 .34666 m .53364 .3272 L .55971 .32019 L F
.70621 .42729 m .72053 .40333 L .73288 .41913 L .65 .753 .925 r
F
.70621 .42729 m .69369 .41164 L .72053 .40333 L F
.40286 .3106 m .41305 .28537 L .42797 .30576 L .585 .67 .897 r
F
.40286 .3106 m .38786 .29005 L .41305 .28537 L F
.82307 .37842 m .83877 .35162 L .85031 .3701 L .65 .717 .897 r
F
.82307 .37842 m .81135 .36001 L .83877 .35162 L F
.40508 .42306 m .41532 .39899 L .43034 .41483 L .65 .753 .925 r
F
.40508 .42306 m .38992 .40736 L .41532 .39899 L F
.77176 .42655 m .78698 .40257 L .79876 .41839 L F
.77176 .42655 m .7598 .41089 L .78698 .40257 L F
.36301 .2938 m .37262 .26928 L .38786 .29005 L .563 .656 .899 r
F
.36301 .2938 m .34771 .27282 L .37262 .26928 L F
.28356 .25381 m .29181 .23196 L .30763 .25363 L .478 .608 .902 r
F
.28356 .25381 m .26773 .23178 L .29181 .23196 L F
.10349 .41911 m .10965 .39493 L .12733 .41083 L .651 .753 .924 r
F
.10349 .41911 m .08568 .40337 L .10965 .39493 L F
.47043 .42224 m .48157 .39815 L .49601 .41401 L .65 .753 .925 r
F
.47043 .42224 m .45583 .40653 L .48157 .39815 L F
.83741 .42583 m .85355 .40183 L .86475 .41767 L .649 .752 .925 r
F
.83741 .42583 m .82602 .41015 L .85355 .40183 L F
.32321 .27509 m .33218 .25163 L .34771 .27282 L .529 .637 .901 r
F
.32321 .27509 m .30763 .25363 L .33218 .25163 L F
.71826 .36593 m .73265 .33908 L .74507 .35787 L .645 .712 .896 r
F
.71826 .36593 m .70568 .34717 L .73265 .33908 L F
.16866 .41823 m .1757 .39403 L .19283 .40994 L .651 .753 .924 r
F
.16866 .41823 m .1514 .40247 L .1757 .39403 L F
.50786 .33386 m .51951 .30751 L .53364 .3272 L .62 .692 .896 r
F
.50786 .33386 m .4936 .31412 L .51951 .30751 L F
.53588 .42144 m .54792 .39732 L .5618 .41321 L .65 .753 .925 r
F
.53588 .42144 m .52184 .40571 L .54792 .39732 L F
.61313 .35148 m .62617 .32472 L .63946 .34391 L .636 .704 .895 r
F
.61313 .35148 m .59969 .33229 L .62617 .32472 L F
.23392 .41736 m .24186 .39314 L .25842 .40907 L .651 .753 .924 r
F
.23392 .41736 m .21723 .40158 L .24186 .39314 L F
.60144 .42065 m .61438 .39651 L .62769 .41242 L .65 .753 .925 r
F
.60144 .42065 m .58796 .4049 L .61438 .39651 L F
.7842 .36828 m .79946 .34135 L .81135 .36001 L .648 .715 .897 r
F
.7842 .36828 m .77213 .34968 L .79946 .34135 L F
.29929 .41651 m .30812 .39226 L .32412 .40821 L .651 .753 .924 r
F
.29929 .41651 m .28315 .4007 L .30812 .39226 L F
.6671 .41988 m .68095 .39572 L .69369 .41164 L .65 .753 .925 r
F
.6671 .41988 m .65419 .40411 L .68095 .39572 L F
.46798 .32029 m .47913 .29414 L .4936 .31412 L .61 .686 .897 r
F
.46798 .32029 m .45339 .30023 L .47913 .29414 L F
.36476 .41566 m .37449 .39139 L .38992 .40736 L .65 .753 .924 r
F
.36476 .41566 m .34919 .39984 L .37449 .39139 L F
.73288 .41913 m .74763 .39494 L .7598 .41089 L .65 .753 .925 r
F
.73288 .41913 m .72053 .40333 L .74763 .39494 L F
.67898 .3551 m .6929 .32818 L .70568 .34717 L .642 .709 .896 r
F
.67898 .3551 m .66605 .33614 L .6929 .32818 L F
.57349 .33962 m .58605 .31288 L .59969 .33229 L .631 .701 .896 r
F
.57349 .33962 m .55971 .32019 L .58605 .31288 L F
.43034 .41483 m .44097 .39053 L .45583 .40653 L .65 .753 .925 r
F
.43034 .41483 m .41532 .39899 L .44097 .39053 L F
.06194 .41172 m .06755 .38734 L .08568 .40337 L .651 .753 .924 r
F
.06194 .41172 m .04369 .39585 L .06755 .38734 L F
.79876 .41839 m .81443 .39418 L .82602 .41015 L .649 .753 .925 r
F
.79876 .41839 m .78698 .40257 L .81443 .39418 L F
.42797 .30576 m .43858 .27995 L .45339 .30023 L .597 .678 .898 r
F
.42797 .30576 m .41305 .28537 L .43858 .27995 L F
.12733 .41083 m .13384 .38643 L .1514 .40247 L .651 .753 .924 r
F
.12733 .41083 m .10965 .39493 L .13384 .38643 L F
.49601 .41401 m .50755 .38969 L .52184 .40571 L .65 .753 .925 r
F
.49601 .41401 m .48157 .39815 L .50755 .38969 L F
.74507 .35787 m .75987 .33084 L .77213 .34968 L .646 .714 .897 r
F
.74507 .35787 m .73265 .33908 L .75987 .33084 L F
.19283 .40994 m .20023 .38552 L .21723 .40158 L .651 .753 .924 r
F
.19283 .40994 m .1757 .39403 L .20023 .38552 L F
.5618 .41321 m .57425 .38886 L .58796 .4049 L .65 .753 .925 r
F
.5618 .41321 m .54792 .39732 L .57425 .38886 L F
.63946 .34391 m .65291 .31693 L .66605 .33614 L .638 .707 .896 r
F
.63946 .34391 m .62617 .32472 L .65291 .31693 L F
.38786 .29005 m .3979 .26475 L .41305 .28537 L .579 .668 .9 r
F
.38786 .29005 m .37262 .26928 L .3979 .26475 L F
.53364 .3272 m .54571 .30052 L .55971 .32019 L .624 .697 .897 r
F
.53364 .3272 m .51951 .30751 L .54571 .30052 L F
.25842 .40907 m .26673 .38462 L .28315 .4007 L .651 .753 .924 r
F
.25842 .40907 m .24186 .39314 L .26673 .38462 L F
.62769 .41242 m .64105 .38805 L .65419 .40411 L .65 .753 .925 r
F
.62769 .41242 m .61438 .39651 L .64105 .38805 L F
.81135 .36001 m .82705 .3329 L .83877 .35162 L .649 .717 .898 r
F
.81135 .36001 m .79946 .34135 L .82705 .3329 L F
.26773 .23178 m .27575 .21007 L .29181 .23196 L .465 .603 .904 r
F
.26773 .23178 m .25167 .20954 L .27575 .21007 L F
.32412 .40821 m .33333 .38373 L .34919 .39984 L .65 .753 .924 r
F
.32412 .40821 m .30812 .39226 L .33333 .38373 L F
.34771 .27282 m .35715 .24829 L .37262 .26928 L .555 .654 .901 r
F
.34771 .27282 m .33218 .25163 L .35715 .24829 L F
.69369 .41164 m .70797 .38726 L .72053 .40333 L .65 .753 .925 r
F
.69369 .41164 m .68095 .39572 L .70797 .38726 L F
.30763 .25363 m .3164 .23023 L .33218 .25163 L .52 .634 .903 r
F
.30763 .25363 m .29181 .23196 L .3164 .23023 L F
.38992 .40736 m .40005 .38286 L .41532 .39899 L .65 .753 .925 r
F
.38992 .40736 m .37449 .39139 L .40005 .38286 L F
.7598 .41089 m .775 .38648 L .78698 .40257 L F
.7598 .41089 m .74763 .39494 L .775 .38648 L F
.70568 .34717 m .72003 .32004 L .73265 .33908 L .643 .712 .897 r
F
.70568 .34717 m .6929 .32818 L .72003 .32004 L F
.4936 .31412 m .50516 .28758 L .51951 .30751 L .616 .692 .897 r
F
.4936 .31412 m .47913 .29414 L .50516 .28758 L F
.08568 .40337 m .09164 .37876 L .10965 .39493 L .651 .753 .924 r
F
.08568 .40337 m .06755 .38734 L .09164 .37876 L F
.45583 .40653 m .46686 .382 L .48157 .39815 L .65 .753 .925 r
F
.45583 .40653 m .44097 .39053 L .46686 .382 L F
.82602 .41015 m .84214 .38572 L .85355 .40183 L .649 .752 .925 r
F
.82602 .41015 m .81443 .39418 L .84214 .38572 L F
.59969 .33229 m .61267 .3053 L .62617 .32472 L .634 .704 .897 r
F
.59969 .33229 m .58605 .31288 L .61267 .3053 L F
.1514 .40247 m .15827 .37784 L .1757 .39403 L .651 .753 .924 r
F
.1514 .40247 m .13384 .38643 L .15827 .37784 L F
.52184 .40571 m .53379 .38116 L .54792 .39732 L .65 .753 .925 r
F
.52184 .40571 m .50755 .38969 L .53379 .38116 L F
.77213 .34968 m .78737 .32245 L .79946 .34135 L .647 .715 .898 r
F
.77213 .34968 m .75987 .33084 L .78737 .32245 L F
.21723 .40158 m .225 .37692 L .24186 .39314 L .651 .753 .924 r
F
.21723 .40158 m .20023 .38552 L .225 .37692 L F
.58796 .4049 m .60083 .38033 L .61438 .39651 L .65 .753 .925 r
F
.58796 .4049 m .57425 .38886 L .60083 .38033 L F
.45339 .30023 m .46442 .27393 L .47913 .29414 L .606 .685 .898 r
F
.45339 .30023 m .43858 .27995 L .46442 .27393 L F
.28315 .4007 m .29184 .37602 L .30812 .39226 L .651 .753 .924 r
F
.28315 .4007 m .26673 .38462 L .29184 .37602 L F
.65419 .40411 m .66799 .37951 L .68095 .39572 L .65 .753 .925 r
F
.65419 .40411 m .64105 .38805 L .66799 .37951 L F
.66605 .33614 m .67992 .30894 L .6929 .32818 L .64 .709 .897 r
F
.66605 .33614 m .65291 .31693 L .67992 .30894 L F
.55971 .32019 m .57219 .29322 L .58605 .31288 L .628 .701 .897 r
F
.55971 .32019 m .54571 .30052 L .57219 .29322 L F
.34919 .39984 m .35879 .37513 L .37449 .39139 L .65 .753 .924 r
F
.34919 .39984 m .33333 .38373 L .35879 .37513 L F
.72053 .40333 m .73525 .37871 L .74763 .39494 L .65 .753 .925 r
F
.72053 .40333 m .70797 .38726 L .73525 .37871 L F
.41305 .28537 m .42353 .25943 L .43858 .27995 L .592 .677 .9 r
F
.41305 .28537 m .3979 .26475 L .42353 .25943 L F
.41532 .39899 m .42585 .37426 L .44097 .39053 L .65 .753 .925 r
F
.41532 .39899 m .40005 .38286 L .42585 .37426 L F
.78698 .40257 m .80263 .37794 L .81443 .39418 L .649 .753 .925 r
F
.78698 .40257 m .775 .38648 L .80263 .37794 L F
.73265 .33908 m .74742 .31174 L .75987 .33084 L .644 .714 .898 r
F
.73265 .33908 m .72003 .32004 L .74742 .31174 L F
.10965 .39493 m .11597 .3701 L .13384 .38643 L .651 .753 .924 r
F
.10965 .39493 m .09164 .37876 L .11597 .3701 L F
.48157 .39815 m .49301 .37339 L .50755 .38969 L .65 .753 .925 r
F
.48157 .39815 m .46686 .382 L .49301 .37339 L F
.37262 .26928 m .38252 .2439 L .3979 .26475 L .574 .667 .902 r
F
.37262 .26928 m .35715 .24829 L .38252 .2439 L F
.51951 .30751 m .53148 .28062 L .54571 .30052 L .621 .696 .898 r
F
.51951 .30751 m .50516 .28758 L .53148 .28062 L F
.62617 .32472 m .63956 .29748 L .65291 .31693 L .636 .707 .898 r
F
.62617 .32472 m .61267 .3053 L .63956 .29748 L F
.1757 .39403 m .18294 .36917 L .20023 .38552 L .651 .753 .924 r
F
.1757 .39403 m .15827 .37784 L .18294 .36917 L F
.54792 .39732 m .56029 .37254 L .57425 .38886 L .65 .753 .925 r
F
.54792 .39732 m .53379 .38116 L .56029 .37254 L F
.33218 .25163 m .34144 .22707 L .35715 .24829 L .548 .652 .904 r
F
.33218 .25163 m .3164 .23023 L .34144 .22707 L F
.29181 .23196 m .30038 .20859 L .3164 .23023 L .51 .631 .906 r
F
.29181 .23196 m .27575 .21007 L .30038 .20859 L F
.79946 .34135 m .81514 .31393 L .82705 .3329 L .648 .717 .899 r
F
.79946 .34135 m .78737 .32245 L .81514 .31393 L F
.24186 .39314 m .25001 .36825 L .26673 .38462 L .651 .753 .924 r
F
.24186 .39314 m .225 .37692 L .25001 .36825 L F
.61438 .39651 m .62768 .37171 L .64105 .38805 L .65 .753 .925 r
F
.61438 .39651 m .60083 .38033 L .62768 .37171 L F
.30812 .39226 m .3172 .36734 L .33333 .38373 L .65 .753 .924 r
F
.30812 .39226 m .29184 .37602 L .3172 .36734 L F
.68095 .39572 m .69518 .37089 L .70797 .38726 L .65 .753 .925 r
F
.68095 .39572 m .66799 .37951 L .69518 .37089 L F
.6929 .32818 m .70721 .30075 L .72003 .32004 L .642 .712 .898 r
F
.6929 .32818 m .67992 .30894 L .70721 .30075 L F
.47913 .29414 m .49058 .26741 L .50516 .28758 L .613 .691 .899 r
F
.47913 .29414 m .46442 .27393 L .49058 .26741 L F
.37449 .39139 m .38449 .36645 L .40005 .38286 L .65 .753 .925 r
F
.37449 .39139 m .35879 .37513 L .38449 .36645 L F
.58605 .31288 m .59895 .28562 L .61267 .3053 L .631 .704 .898 r
F
.58605 .31288 m .57219 .29322 L .59895 .28562 L F
.74763 .39494 m .7628 .37009 L .775 .38648 L .65 .753 .925 r
F
.74763 .39494 m .73525 .37871 L .7628 .37009 L F
.44097 .39053 m .4519 .36557 L .46686 .382 L F
.44097 .39053 m .42585 .37426 L .4519 .36557 L F
.81443 .39418 m .83054 .36931 L .84214 .38572 L .649 .752 .925 r
F
.81443 .39418 m .80263 .37794 L .83054 .36931 L F
.75987 .33084 m .77509 .30329 L .78737 .32245 L .646 .715 .899 r
F
.75987 .33084 m .74742 .31174 L .77509 .30329 L F
.43858 .27995 m .44948 .25348 L .46442 .27393 L .602 .685 .9 r
F
.43858 .27995 m .42353 .25943 L .44948 .25348 L F
.13384 .38643 m .14053 .36135 L .15827 .37784 L .651 .753 .924 r
F
.13384 .38643 m .11597 .3701 L .14053 .36135 L F
.50755 .38969 m .51941 .3647 L .53379 .38116 L .65 .753 .925 r
F
.50755 .38969 m .49301 .37339 L .51941 .3647 L F
.20023 .38552 m .20784 .36042 L .225 .37692 L .651 .753 .924 r
F
.20023 .38552 m .18294 .36917 L .20784 .36042 L F
.57425 .38886 m .58704 .36385 L .60083 .38033 L .65 .753 .925 r
F
.57425 .38886 m .56029 .37254 L .58704 .36385 L F
.65291 .31693 m .66673 .28944 L .67992 .30894 L .638 .709 .899 r
F
.65291 .31693 m .63956 .29748 L .66673 .28944 L F
.54571 .30052 m .5581 .27331 L .57219 .29322 L .626 .7 .899 r
F
.54571 .30052 m .53148 .28062 L .5581 .27331 L F
.26673 .38462 m .27527 .35949 L .29184 .37602 L .651 .753 .924 r
F
.26673 .38462 m .25001 .36825 L .27527 .35949 L F
.64105 .38805 m .65479 .36301 L .66799 .37951 L .65 .753 .925 r
F
.64105 .38805 m .62768 .37171 L .65479 .36301 L F
.3979 .26475 m .40824 .23867 L .42353 .25943 L .587 .676 .902 r
F
.3979 .26475 m .38252 .2439 L .40824 .23867 L F
.33333 .38373 m .3428 .35858 L .35879 .37513 L .65 .753 .924 r
F
.33333 .38373 m .3172 .36734 L .3428 .35858 L F
.70797 .38726 m .72265 .3622 L .73525 .37871 L .65 .753 .925 r
F
.70797 .38726 m .69518 .37089 L .72265 .3622 L F
.72003 .32004 m .73477 .29239 L .74742 .31174 L .643 .714 .899 r
F
.72003 .32004 m .70721 .30075 L .73477 .29239 L F
.35715 .24829 m .36688 .2228 L .38252 .2439 L .568 .665 .904 r
F
.35715 .24829 m .34144 .22707 L .36688 .2228 L F
.40005 .38286 m .41045 .35768 L .42585 .37426 L .65 .753 .925 r
F
.40005 .38286 m .38449 .36645 L .41045 .35768 L F
.775 .38648 m .79062 .36139 L .80263 .37794 L .649 .753 .925 r
F
.775 .38648 m .7628 .37009 L .79062 .36139 L F
.50516 .28758 m .51703 .26046 L .53148 .28062 L .619 .696 .9 r
F
.50516 .28758 m .49058 .26741 L .51703 .26046 L F
.61267 .3053 m .62599 .27777 L .63956 .29748 L .634 .707 .899 r
F
.61267 .3053 m .59895 .28562 L .62599 .27777 L F
.3164 .23023 m .32547 .2056 L .34144 .22707 L .54 .65 .906 r
F
.3164 .23023 m .30038 .20859 L .32547 .2056 L F
.46686 .382 m .47821 .3568 L .49301 .37339 L .65 .753 .925 r
F
.46686 .382 m .4519 .36557 L .47821 .3568 L F
.15827 .37784 m .16533 .35252 L .18294 .36917 L .651 .753 .924 r
F
.15827 .37784 m .14053 .36135 L .16533 .35252 L F
.53379 .38116 m .54608 .35593 L .56029 .37254 L .65 .753 .925 r
F
.53379 .38116 m .51941 .3647 L .54608 .35593 L F
.78737 .32245 m .80303 .29469 L .81514 .31393 L .646 .717 .9 r
F
.78737 .32245 m .77509 .30329 L .80303 .29469 L F
.225 .37692 m .233 .35158 L .25001 .36825 L .651 .753 .924 r
F
.225 .37692 m .20784 .36042 L .233 .35158 L F
.60083 .38033 m .61406 .35507 L .62768 .37171 L .65 .753 .925 r
F
.60083 .38033 m .58704 .36385 L .61406 .35507 L F
.46442 .27393 m .47576 .24698 L .49058 .26741 L .61 .691 .901 r
F
.46442 .27393 m .44948 .25348 L .47576 .24698 L F
.67992 .30894 m .69418 .2812 L .70721 .30075 L .64 .712 .899 r
F
.67992 .30894 m .66673 .28944 L .69418 .2812 L F
.29184 .37602 m .30077 .35066 L .3172 .36734 L .65 .753 .924 r
F
.29184 .37602 m .27527 .35949 L .30077 .35066 L F
.57219 .29322 m .58501 .26569 L .59895 .28562 L .629 .704 .899 r
F
.57219 .29322 m .5581 .27331 L .58501 .26569 L F
.66799 .37951 m .68216 .35424 L .69518 .37089 L .65 .753 .925 r
F
.66799 .37951 m .65479 .36301 L .68216 .35424 L F
.35879 .37513 m .36866 .34974 L .38449 .36645 L F
.35879 .37513 m .3428 .35858 L .36866 .34974 L F
.73525 .37871 m .75038 .35342 L .7628 .37009 L F
.73525 .37871 m .72265 .3622 L .75038 .35342 L F
.42353 .25943 m .4343 .23277 L .44948 .25348 L .598 .684 .902 r
F
.42353 .25943 m .40824 .23867 L .4343 .23277 L F
.74742 .31174 m .76261 .28387 L .77509 .30329 L .644 .716 .9 r
F
.74742 .31174 m .73477 .29239 L .76261 .28387 L F
.42585 .37426 m .43666 .34884 L .4519 .36557 L .65 .753 .925 r
F
.42585 .37426 m .41045 .35768 L .43666 .34884 L F
.80263 .37794 m .81872 .35261 L .83054 .36931 L .649 .752 .925 r
F
.80263 .37794 m .79062 .36139 L .81872 .35261 L F
.49301 .37339 m .50478 .34795 L .51941 .3647 L .65 .753 .925 r
F
.49301 .37339 m .47821 .3568 L .50478 .34795 L F
.63956 .29748 m .65332 .26968 L .66673 .28944 L .636 .709 .9 r
F
.63956 .29748 m .62599 .27777 L .65332 .26968 L F
.53148 .28062 m .54378 .25313 L .5581 .27331 L .623 .7 .9 r
F
.53148 .28062 m .51703 .26046 L .54378 .25313 L F
.38252 .2439 m .3927 .21765 L .40824 .23867 L .583 .675 .904 r
F
.38252 .2439 m .36688 .2228 L .3927 .21765 L F
.18294 .36917 m .19038 .34361 L .20784 .36042 L .651 .753 .924 r
F
.18294 .36917 m .16533 .35252 L .19038 .34361 L F
.56029 .37254 m .573 .34707 L .58704 .36385 L .65 .753 .925 r
F
.56029 .37254 m .54608 .35593 L .573 .34707 L F
.25001 .36825 m .2584 .34267 L .27527 .35949 L .651 .753 .924 r
F
.25001 .36825 m .233 .35158 L .2584 .34267 L F
.62768 .37171 m .64135 .34622 L .65479 .36301 L .65 .753 .925 r
F
.62768 .37171 m .61406 .35507 L .64135 .34622 L F
.34144 .22707 m .35099 .20145 L .36688 .2228 L .562 .664 .906 r
F
.34144 .22707 m .32547 .2056 L .35099 .20145 L F
.70721 .30075 m .72191 .27277 L .73477 .29239 L .641 .714 .9 r
F
.70721 .30075 m .69418 .2812 L .72191 .27277 L F
.3172 .36734 m .32653 .34173 L .3428 .35858 L .65 .753 .924 r
F
.3172 .36734 m .30077 .35066 L .32653 .34173 L F
.69518 .37089 m .70981 .34538 L .72265 .3622 L .65 .753 .925 r
F
.69518 .37089 m .68216 .35424 L .70981 .34538 L F
.49058 .26741 m .50234 .24003 L .51703 .26046 L .616 .696 .901 r
F
.49058 .26741 m .47576 .24698 L .50234 .24003 L F
.59895 .28562 m .6122 .25779 L .62599 .27777 L .632 .707 .9 r
F
.59895 .28562 m .58501 .26569 L .6122 .25779 L F
.38449 .36645 m .39478 .34081 L .41045 .35768 L .65 .753 .925 r
F
.38449 .36645 m .36866 .34974 L .39478 .34081 L F
.7628 .37009 m .77839 .34455 L .79062 .36139 L .649 .753 .925 r
F
.7628 .37009 m .75038 .35342 L .77839 .34455 L F
.4519 .36557 m .46313 .33991 L .47821 .3568 L .65 .753 .925 r
F
.4519 .36557 m .43666 .34884 L .46313 .33991 L F
.77509 .30329 m .79073 .27518 L .80303 .29469 L .645 .717 .9 r
F
.77509 .30329 m .76261 .28387 L .79073 .27518 L F
.44948 .25348 m .46069 .22629 L .47576 .24698 L .606 .69 .902 r
F
.44948 .25348 m .4343 .23277 L .46069 .22629 L F
.51941 .3647 m .53161 .33901 L .54608 .35593 L .65 .753 .925 r
F
.51941 .3647 m .50478 .34795 L .53161 .33901 L F
.66673 .28944 m .68093 .26138 L .69418 .2812 L .638 .712 .9 r
F
.66673 .28944 m .65332 .26968 L .68093 .26138 L F
.20784 .36042 m .21567 .33462 L .233 .35158 L .651 .753 .924 r
F
.20784 .36042 m .19038 .34361 L .21567 .33462 L F
.5581 .27331 m .57084 .24548 L .58501 .26569 L .627 .704 .901 r
F
.5581 .27331 m .54378 .25313 L .57084 .24548 L F
.58704 .36385 m .6002 .33814 L .61406 .35507 L .65 .753 .925 r
F
.58704 .36385 m .573 .34707 L .6002 .33814 L F
.27527 .35949 m .28405 .33366 L .30077 .35066 L .65 .753 .924 r
F
.27527 .35949 m .2584 .34267 L .28405 .33366 L F
.65479 .36301 m .66891 .33728 L .68216 .35424 L .65 .753 .925 r
F
.65479 .36301 m .64135 .34622 L .66891 .33728 L F
.40824 .23867 m .41887 .21179 L .4343 .23277 L .594 .683 .904 r
F
.40824 .23867 m .3927 .21765 L .41887 .21179 L F
.3428 .35858 m .35254 .33273 L .36866 .34974 L .65 .753 .925 r
F
.3428 .35858 m .32653 .34173 L .35254 .33273 L F
.73477 .29239 m .74992 .26417 L .76261 .28387 L .643 .716 .901 r
F
.73477 .29239 m .72191 .27277 L .74992 .26417 L F
.72265 .3622 m .73774 .33643 L .75038 .35342 L .65 .753 .925 r
F
.72265 .3622 m .70981 .34538 L .73774 .33643 L F
.41045 .35768 m .42115 .3318 L .43666 .34884 L F
.41045 .35768 m .39478 .34081 L .42115 .3318 L F
.62599 .27777 m .63969 .24965 L .65332 .26968 L .635 .709 .901 r
F
.62599 .27777 m .6122 .25779 L .63969 .24965 L F
.51703 .26046 m .52923 .23269 L .54378 .25313 L .621 .7 .901 r
F
.51703 .26046 m .50234 .24003 L .52923 .23269 L F
.79062 .36139 m .80668 .33561 L .81872 .35261 L .649 .752 .925 r
F
.79062 .36139 m .77839 .34455 L .80668 .33561 L F
.36688 .2228 m .3769 .19637 L .3927 .21765 L .578 .674 .905 r
F
.36688 .2228 m .35099 .20145 L .3769 .19637 L F
.47821 .3568 m .48987 .33089 L .50478 .34795 L .65 .753 .925 r
F
.47821 .3568 m .46313 .33991 L .48987 .33089 L F
.54608 .35593 m .55871 .32999 L .573 .34707 L F
.54608 .35593 m .53161 .33901 L .55871 .32999 L F
.69418 .2812 m .70883 .25288 L .72191 .27277 L .64 .714 .901 r
F
.69418 .2812 m .68093 .26138 L .70883 .25288 L F
.233 .35158 m .24122 .32553 L .2584 .34267 L .651 .753 .924 r
F
.233 .35158 m .21567 .33462 L .24122 .32553 L F
.61406 .35507 m .62767 .32911 L .64135 .34622 L .65 .753 .925 r
F
.61406 .35507 m .6002 .33814 L .62767 .32911 L F
.47576 .24698 m .48741 .21934 L .50234 .24003 L .613 .695 .902 r
F
.47576 .24698 m .46069 .22629 L .48741 .21934 L F
.58501 .26569 m .59818 .23754 L .6122 .25779 L .63 .707 .901 r
F
.58501 .26569 m .57084 .24548 L .59818 .23754 L F
.30077 .35066 m .30996 .32458 L .32653 .34173 L .65 .753 .924 r
F
.30077 .35066 m .28405 .33366 L .30996 .32458 L F
.68216 .35424 m .69674 .32825 L .70981 .34538 L .65 .753 .925 r
F
.68216 .35424 m .66891 .33728 L .69674 .32825 L F
.36866 .34974 m .37881 .32363 L .39478 .34081 L F
.36866 .34974 m .35254 .33273 L .37881 .32363 L F
.75038 .35342 m .76594 .32741 L .77839 .34455 L .649 .753 .925 r
F
.75038 .35342 m .73774 .33643 L .76594 .32741 L F
.76261 .28387 m .77822 .2554 L .79073 .27518 L .644 .717 .901 r
F
.76261 .28387 m .74992 .26417 L .77822 .2554 L F
.4343 .23277 m .44538 .20533 L .46069 .22629 L .603 .69 .904 r
F
.4343 .23277 m .41887 .21179 L .44538 .20533 L F
.43666 .34884 m .44779 .3227 L .46313 .33991 L .65 .753 .925 r
F
.43666 .34884 m .42115 .3318 L .44779 .3227 L F
.65332 .26968 m .66747 .24128 L .68093 .26138 L .637 .712 .901 r
F
.65332 .26968 m .63969 .24965 L .66747 .24128 L F
.54378 .25313 m .55643 .225 L .57084 .24548 L .625 .704 .902 r
F
.54378 .25313 m .52923 .23269 L .55643 .225 L F
.50478 .34795 m .51687 .32179 L .53161 .33901 L .65 .753 .925 r
F
.50478 .34795 m .48987 .33089 L .51687 .32179 L F
.573 .34707 m .58608 .32089 L .6002 .33814 L F
.573 .34707 m .55871 .32999 L .58608 .32089 L F
.3927 .21765 m .40318 .19054 L .41887 .21179 L .59 .683 .905 r
F
.3927 .21765 m .3769 .19637 L .40318 .19054 L F
.2584 .34267 m .26702 .31636 L .28405 .33366 L .65 .753 .924 r
F
.2584 .34267 m .24122 .32553 L .26702 .31636 L F
.64135 .34622 m .65541 .32 L .66891 .33728 L .65 .753 .925 r
F
.64135 .34622 m .62767 .32911 L .65541 .32 L F
.72191 .27277 m .73702 .24419 L .74992 .26417 L .641 .716 .902 r
F
.72191 .27277 m .70883 .25288 L .73702 .24419 L F
.32653 .34173 m .33613 .3154 L .35254 .33273 L .65 .753 .925 r
F
.32653 .34173 m .30996 .32458 L .33613 .3154 L F
.50234 .24003 m .51444 .21197 L .52923 .23269 L .618 .7 .903 r
F
.50234 .24003 m .48741 .21934 L .51444 .21197 L F
.70981 .34538 m .72486 .31914 L .73774 .33643 L .65 .753 .925 r
F
.70981 .34538 m .69674 .32825 L .72486 .31914 L F
.6122 .25779 m .62583 .22934 L .63969 .24965 L .633 .709 .902 r
F
.6122 .25779 m .59818 .23754 L .62583 .22934 L F
.39478 .34081 m .40535 .31445 L .42115 .3318 L .65 .753 .925 r
F
.39478 .34081 m .37881 .32363 L .40535 .31445 L F
.77839 .34455 m .79443 .31829 L .80668 .33561 L .649 .752 .925 r
F
.77839 .34455 m .76594 .32741 L .79443 .31829 L F
.46313 .33991 m .47469 .31352 L .48987 .33089 L .65 .753 .925 r
F
.46313 .33991 m .44779 .3227 L .47469 .31352 L F
.68093 .26138 m .69554 .23269 L .70883 .25288 L .639 .714 .902 r
F
.68093 .26138 m .66747 .24128 L .69554 .23269 L F
.46069 .22629 m .47222 .19836 L .48741 .21934 L .61 .695 .904 r
F
.46069 .22629 m .44538 .20533 L .47222 .19836 L F
.53161 .33901 m .54415 .3126 L .55871 .32999 L .65 .753 .925 r
F
.53161 .33901 m .51687 .32179 L .54415 .3126 L F
.57084 .24548 m .58393 .21701 L .59818 .23754 L .628 .707 .902 r
F
.57084 .24548 m .55643 .225 L .58393 .21701 L F
.6002 .33814 m .61373 .31169 L .62767 .32911 L .65 .753 .925 r
F
.6002 .33814 m .58608 .32089 L .61373 .31169 L F
.28405 .33366 m .29308 .3071 L .30996 .32458 L .65 .753 .924 r
F
.28405 .33366 m .26702 .31636 L .29308 .3071 L F
.66891 .33728 m .68343 .31081 L .69674 .32825 L .65 .753 .925 r
F
.66891 .33728 m .65541 .32 L .68343 .31081 L F
.74992 .26417 m .7655 .23532 L .77822 .2554 L .643 .717 .902 r
F
.74992 .26417 m .73702 .24419 L .7655 .23532 L F
.41887 .21179 m .42981 .18409 L .44538 .20533 L .6 .689 .905 r
F
.41887 .21179 m .40318 .19054 L .42981 .18409 L F
.35254 .33273 m .36256 .30613 L .37881 .32363 L .65 .753 .925 r
F
.35254 .33273 m .33613 .3154 L .36256 .30613 L F
.73774 .33643 m .75326 .30994 L .76594 .32741 L .649 .753 .925 r
F
.73774 .33643 m .72486 .31914 L .75326 .30994 L F
.63969 .24965 m .65377 .22089 L .66747 .24128 L .635 .712 .902 r
F
.63969 .24965 m .62583 .22934 L .65377 .22089 L F
.52923 .23269 m .54178 .20423 L .55643 .225 L .623 .703 .903 r
F
.52923 .23269 m .51444 .21197 L .54178 .20423 L F
.42115 .3318 m .43215 .30518 L .44779 .3227 L .65 .753 .925 r
F
.42115 .3318 m .40535 .31445 L .43215 .30518 L F
.48987 .33089 m .50187 .30424 L .51687 .32179 L F
.48987 .33089 m .47469 .31352 L .50187 .30424 L F
.55871 .32999 m .5717 .30332 L .58608 .32089 L F
.55871 .32999 m .54415 .3126 L .5717 .30332 L F
.70883 .25288 m .7239 .22391 L .73702 .24419 L .64 .716 .902 r
F
.70883 .25288 m .69554 .23269 L .7239 .22391 L F
.62767 .32911 m .64166 .30241 L .65541 .32 L .65 .753 .925 r
F
.62767 .32911 m .61373 .31169 L .64166 .30241 L F
.48741 .21934 m .49939 .19096 L .51444 .21197 L .616 .699 .904 r
F
.48741 .21934 m .47222 .19836 L .49939 .19096 L F
.59818 .23754 m .61173 .20873 L .62583 .22934 L .631 .709 .903 r
F
.59818 .23754 m .58393 .21701 L .61173 .20873 L F
.30996 .32458 m .3194 .29775 L .33613 .3154 L .65 .753 .925 r
F
.30996 .32458 m .29308 .3071 L .3194 .29775 L F
.69674 .32825 m .71174 .30152 L .72486 .31914 L F
.69674 .32825 m .68343 .31081 L .71174 .30152 L F
.37881 .32363 m .38926 .29678 L .40535 .31445 L F
.37881 .32363 m .36256 .30613 L .38926 .29678 L F
.76594 .32741 m .78195 .30065 L .79443 .31829 L .649 .752 .925 r
F
.76594 .32741 m .75326 .30994 L .78195 .30065 L F
.44538 .20533 m .45678 .1771 L .47222 .19836 L .607 .695 .905 r
F
.44538 .20533 m .42981 .18409 L .45678 .1771 L F
.44779 .3227 m .45923 .29582 L .47469 .31352 L .65 .753 .925 r
F
.44779 .3227 m .43215 .30518 L .45923 .29582 L F
.66747 .24128 m .68201 .21221 L .69554 .23269 L .637 .714 .903 r
F
.66747 .24128 m .65377 .22089 L .68201 .21221 L F
.55643 .225 m .56943 .19617 L .58393 .21701 L .626 .707 .903 r
F
.55643 .225 m .54178 .20423 L .56943 .19617 L F
.51687 .32179 m .52932 .29488 L .54415 .3126 L .65 .753 .925 r
F
.51687 .32179 m .50187 .30424 L .52932 .29488 L F
.58608 .32089 m .59954 .29395 L .61373 .31169 L F
.58608 .32089 m .5717 .30332 L .59954 .29395 L F
.73702 .24419 m .75257 .21494 L .7655 .23532 L .642 .718 .903 r
F
.73702 .24419 m .7239 .22391 L .75257 .21494 L F
.65541 .32 m .66987 .29304 L .68343 .31081 L .65 .753 .925 r
F
.65541 .32 m .64166 .30241 L .66987 .29304 L F
.62583 .22934 m .63984 .2002 L .65377 .22089 L .634 .712 .903 r
F
.62583 .22934 m .61173 .20873 L .63984 .2002 L F
.33613 .3154 m .346 .28831 L .36256 .30613 L .65 .753 .925 r
F
.33613 .3154 m .3194 .29775 L .346 .28831 L F
.51444 .21197 m .52688 .18317 L .54178 .20423 L .621 .703 .904 r
F
.51444 .21197 m .49939 .19096 L .52688 .18317 L F
.72486 .31914 m .74034 .29215 L .75326 .30994 L .649 .753 .925 r
F
.72486 .31914 m .71174 .30152 L .74034 .29215 L F
.40535 .31445 m .41623 .28733 L .43215 .30518 L .65 .753 .925 r
F
.40535 .31445 m .38926 .29678 L .41623 .28733 L F
.47469 .31352 m .48658 .28637 L .50187 .30424 L F
.47469 .31352 m .45923 .29582 L .48658 .28637 L F
.69554 .23269 m .71056 .20333 L .7239 .22391 L .639 .716 .903 r
F
.69554 .23269 m .68201 .21221 L .71056 .20333 L F
.54415 .3126 m .55705 .28542 L .5717 .30332 L .65 .753 .925 r
F
.54415 .3126 m .52932 .29488 L .55705 .28542 L F
.47222 .19836 m .48408 .16965 L .49939 .19096 L .613 .699 .905 r
F
.47222 .19836 m .45678 .1771 L .48408 .16965 L F
.58393 .21701 m .5974 .18782 L .61173 .20873 L .629 .709 .904 r
F
.58393 .21701 m .56943 .19617 L .5974 .18782 L F
.61373 .31169 m .62765 .28449 L .64166 .30241 L .65 .753 .925 r
F
.61373 .31169 m .59954 .29395 L .62765 .28449 L F
.68343 .31081 m .69838 .28358 L .71174 .30152 L F
.68343 .31081 m .66987 .29304 L .69838 .28358 L F
.36256 .30613 m .37286 .27878 L .38926 .29678 L F
.36256 .30613 m .346 .28831 L .37286 .27878 L F
.75326 .30994 m .76923 .28268 L .78195 .30065 L .649 .752 .925 r
F
.75326 .30994 m .74034 .29215 L .76923 .28268 L F
.65377 .22089 m .66826 .19143 L .68201 .21221 L .636 .714 .904 r
F
.65377 .22089 m .63984 .2002 L .66826 .19143 L F
.54178 .20423 m .55469 .17504 L .56943 .19617 L .624 .706 .904 r
F
.54178 .20423 m .52688 .18317 L .55469 .17504 L F
.43215 .30518 m .44348 .27779 L .45923 .29582 L .65 .753 .925 r
F
.43215 .30518 m .41623 .28733 L .44348 .27779 L F
.50187 .30424 m .51421 .27682 L .52932 .29488 L F
.50187 .30424 m .48658 .28637 L .51421 .27682 L F
.7239 .22391 m .73941 .19425 L .75257 .21494 L .64 .718 .904 r
F
.7239 .22391 m .71056 .20333 L .73941 .19425 L F
.5717 .30332 m .58507 .27587 L .59954 .29395 L .65 .753 .925 r
F
.5717 .30332 m .55705 .28542 L .58507 .27587 L F
.61173 .20873 m .62568 .1792 L .63984 .2002 L .632 .712 .904 r
F
.61173 .20873 m .5974 .18782 L .62568 .1792 L F
.49939 .19096 m .51172 .1618 L .52688 .18317 L .618 .703 .905 r
F
.49939 .19096 m .48408 .16965 L .51172 .1618 L F
.64166 .30241 m .65606 .27494 L .66987 .29304 L .65 .753 .925 r
F
.64166 .30241 m .62765 .28449 L .65606 .27494 L F
.71174 .30152 m .72718 .27402 L .74034 .29215 L .649 .753 .925 r
F
.71174 .30152 m .69838 .28358 L .72718 .27402 L F
.38926 .29678 m .4 .26915 L .41623 .28733 L .65 .753 .925 r
F
.38926 .29678 m .37286 .27878 L .4 .26915 L F
.68201 .21221 m .69699 .18244 L .71056 .20333 L .638 .716 .904 r
F
.68201 .21221 m .66826 .19143 L .69699 .18244 L F
.45923 .29582 m .471 .26816 L .48658 .28637 L .65 .753 .925 r
F
.45923 .29582 m .44348 .27779 L .471 .26816 L F
.56943 .19617 m .58281 .1666 L .5974 .18782 L .628 .709 .905 r
F
.56943 .19617 m .55469 .17504 L .58281 .1666 L F
.52932 .29488 m .54213 .26719 L .55705 .28542 L .65 .753 .925 r
F
.52932 .29488 m .51421 .27682 L .54213 .26719 L F
.59954 .29395 m .61338 .26623 L .62765 .28449 L F
.59954 .29395 m .58507 .27587 L .61338 .26623 L F
.66987 .29304 m .68476 .26529 L .69838 .28358 L F
.66987 .29304 m .65606 .27494 L .68476 .26529 L F
.63984 .2002 m .65427 .17033 L .66826 .19143 L .634 .714 .905 r
F
.63984 .2002 m .62568 .1792 L .65427 .17033 L F
.52688 .18317 m .53968 .15359 L .55469 .17504 L .623 .706 .905 r
F
.52688 .18317 m .51172 .1618 L .53968 .15359 L F
.74034 .29215 m .75627 .26437 L .76923 .28268 L .649 .752 .925 r
F
.74034 .29215 m .72718 .27402 L .75627 .26437 L F
.41623 .28733 m .42742 .25942 L .44348 .27779 L .65 .753 .925 r
F
.41623 .28733 m .4 .26915 L .42742 .25942 L F
.48658 .28637 m .49882 .25843 L .51421 .27682 L F
.48658 .28637 m .471 .26816 L .49882 .25843 L F
.71056 .20333 m .72602 .17324 L .73941 .19425 L .639 .718 .904 r
F
.71056 .20333 m .69699 .18244 L .72602 .17324 L F
.55705 .28542 m .57034 .25745 L .58507 .27587 L .65 .753 .925 r
F
.55705 .28542 m .54213 .26719 L .57034 .25745 L F
.5974 .18782 m .61126 .15788 L .62568 .1792 L .631 .712 .905 r
F
.5974 .18782 m .58281 .1666 L .61126 .15788 L F
.62765 .28449 m .64199 .25649 L .65606 .27494 L .65 .753 .925 r
F
.62765 .28449 m .61338 .26623 L .64199 .25649 L F
.69838 .28358 m .71376 .25555 L .72718 .27402 L .649 .753 .925 r
F
.69838 .28358 m .68476 .26529 L .71376 .25555 L F
.66826 .19143 m .68317 .16123 L .69699 .18244 L .636 .716 .905 r
F
.66826 .19143 m .65427 .17033 L .68317 .16123 L F
.55469 .17504 m .56797 .14505 L .58281 .1666 L .626 .709 .906 r
F
.55469 .17504 m .53968 .15359 L .56797 .14505 L F
.44348 .27779 m .45513 .2496 L .471 .26816 L .65 .753 .925 r
F
.44348 .27779 m .42742 .25942 L .45513 .2496 L F
.51421 .27682 m .52692 .2486 L .54213 .26719 L F
.51421 .27682 m .49882 .25843 L .52692 .2486 L F
.58507 .27587 m .59884 .24762 L .61338 .26623 L F
.58507 .27587 m .57034 .25745 L .59884 .24762 L F
.62568 .1792 m .64003 .1489 L .65427 .17033 L .633 .714 .905 r
F
.62568 .1792 m .61126 .15788 L .64003 .1489 L F
.65606 .27494 m .67089 .24666 L .68476 .26529 L .65 .753 .925 r
F
.65606 .27494 m .64199 .25649 L .67089 .24666 L F
.72718 .27402 m .74307 .24571 L .75627 .26437 L .649 .752 .925 r
F
.72718 .27402 m .71376 .25555 L .74307 .24571 L F
.69699 .18244 m .7124 .15191 L .72602 .17324 L .638 .718 .905 r
F
.69699 .18244 m .68317 .16123 L .7124 .15191 L F
.471 .26816 m .48313 .23968 L .49882 .25843 L .65 .753 .925 r
F
.471 .26816 m .45513 .2496 L .48313 .23968 L F
.58281 .1666 m .59659 .13623 L .61126 .15788 L .629 .712 .906 r
F
.58281 .1666 m .56797 .14505 L .59659 .13623 L F
.54213 .26719 m .55532 .23868 L .57034 .25745 L .65 .753 .925 r
F
.54213 .26719 m .52692 .2486 L .55532 .23868 L F
.61338 .26623 m .62764 .23769 L .64199 .25649 L F
.61338 .26623 m .59884 .24762 L .62764 .23769 L F
.68476 .26529 m .70009 .23672 L .71376 .25555 L .649 .753 .925 r
F
.68476 .26529 m .67089 .24666 L .70009 .23672 L F
.65427 .17033 m .66911 .13968 L .68317 .16123 L .635 .716 .906 r
F
.65427 .17033 m .64003 .1489 L .66911 .13968 L F
.49882 .25843 m .51142 .22966 L .52692 .2486 L .65 .753 .925 r
F
.49882 .25843 m .48313 .23968 L .51142 .22966 L F
.61126 .15788 m .62553 .12713 L .64003 .1489 L .632 .714 .906 r
F
.61126 .15788 m .59659 .13623 L .62553 .12713 L F
.57034 .25745 m .58402 .22865 L .59884 .24762 L .65 .753 .925 r
F
.57034 .25745 m .55532 .23868 L .58402 .22865 L F
.64199 .25649 m .65675 .22766 L .67089 .24666 L F
.64199 .25649 m .62764 .23769 L .65675 .22766 L F
.71376 .25555 m .72961 .22669 L .74307 .24571 L .649 .752 .925 r
F
.71376 .25555 m .70009 .23672 L .72961 .22669 L F
.68317 .16123 m .69853 .13023 L .7124 .15191 L .637 .718 .906 r
F
.68317 .16123 m .66911 .13968 L .69853 .13023 L F
.52692 .2486 m .54001 .21954 L .55532 .23868 L .65 .753 .925 r
F
.52692 .2486 m .51142 .22966 L .54001 .21954 L F
.59884 .24762 m .61302 .21853 L .62764 .23769 L F
.59884 .24762 m .58402 .22865 L .61302 .21853 L F
.64003 .1489 m .6548 .11778 L .66911 .13968 L .634 .716 .906 r
F
.64003 .1489 m .62553 .12713 L .6548 .11778 L F
.67089 .24666 m .68616 .21753 L .70009 .23672 L .649 .753 .925 r
F
.67089 .24666 m .65675 .22766 L .68616 .21753 L F
.55532 .23868 m .5689 .20932 L .58402 .22865 L .65 .753 .925 r
F
.55532 .23868 m .54001 .21954 L .5689 .20932 L F
.62764 .23769 m .64233 .2083 L .65675 .22766 L F
.62764 .23769 m .61302 .21853 L .64233 .2083 L F
.66911 .13968 m .68441 .10819 L .69853 .13023 L .636 .718 .907 r
F
.66911 .13968 m .6548 .11778 L .68441 .10819 L F
.70009 .23672 m .71589 .2073 L .72961 .22669 L .649 .752 .925 r
F
.70009 .23672 m .68616 .21753 L .71589 .2073 L F
.58402 .22865 m .59811 .19899 L .61302 .21853 L .65 .753 .925 r
F
.58402 .22865 m .5689 .20932 L .59811 .19899 L F
.65675 .22766 m .67195 .19797 L .68616 .21753 L .649 .753 .925 r
F
.65675 .22766 m .64233 .2083 L .67195 .19797 L F
.61302 .21853 m .62763 .18856 L .64233 .2083 L .65 .753 .925 r
F
.61302 .21853 m .59811 .19899 L .62763 .18856 L F
.68616 .21753 m .7019 .18753 L .71589 .2073 L .649 .752 .925 r
F
.68616 .21753 m .67195 .19797 L .7019 .18753 L F
.64233 .2083 m .65746 .17802 L .67195 .19797 L .649 .753 .925 r
F
.64233 .2083 m .62763 .18856 L .65746 .17802 L F
.67195 .19797 m .68763 .16737 L .7019 .18753 L .649 .752 .925 r
F
.67195 .19797 m .65746 .17802 L .68763 .16737 L F
0 g
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.05093 .24975 m
.0557 .25425 L
s
[(0)] .04138 .24075 1 .94269 Mshowa
.19287 .19417 m
.19742 .1989 L
s
[(0.5)] .18378 .18471 .96152 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(1)] .3345 .12542 .86223 1 Mshowa
.50225 .07302 m
.50623 .07824 L
s
[(1.5)] .49429 .06259 .76295 1 Mshowa
.67126 .00684 m
.67489 .01231 L
s
[(2)] .664 -0.00409 .66367 1 Mshowa
.125 Mabswid
.07869 .23888 m
.08153 .2416 L
s
.10676 .22788 m
.10957 .23064 L
s
.13514 .21677 m
.13793 .21955 L
s
.16384 .20553 m
.1666 .20834 L
s
.22223 .18267 m
.22493 .18554 L
s
.25192 .17104 m
.25459 .17394 L
s
.28195 .15928 m
.28459 .16221 L
s
.31233 .14739 m
.31494 .15034 L
s
.37416 .12318 m
.37669 .12619 L
s
.40562 .11086 m
.40812 .1139 L
s
.43745 .0984 m
.43991 .10147 L
s
.46966 .08579 m
.47208 .08889 L
s
.53524 .06011 m
.53759 .06327 L
s
.56863 .04703 m
.57093 .05022 L
s
.60242 .0338 m
.60468 .03702 L
s
.63663 .0204 m
.63885 .02365 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{280, 203.5},
  ImageMargins->{{30, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005N0000oQ000`40O003h00OjGoo1@00L7oo003Y
Ool01@00Oomoogoo0000L7oo003ZOol00`00Oomoo`1aOol00>]oo`03001oogoo071oo`00k7oo00<0
07ooOol0Kgoo003]Ool00`00Oomoo`1^Ool00>Uoo`05001oogooOol0001`Ool00>Yoo`<0075oo`00
ogooGgoo003oOomOOol00?mooemoo`00ogooGgoo003oOomOOol00?Eoo`8006Moo`00lgoo0P0000=o
o`000000IWoo003`Ool30003Ool2001VOol00>ioo`80009oo`07001oogooOol007oo0000IGoo003[
Ool30008Ool200000goo001oo`1SOol00>Moo`@000]oo`04001oogoo001TOol00:]oo`D000Aoo`80
00Eoo`@002Moo`<000eoo`05001oogooOol0001SOol00:eoo`03001oogoo00Aoo`8000Aoo`03001o
ogoo009oo`03001oogoo025oo`<0011oo`03001oogoo009oo`03001oogoo061oo`00[Goo00<007oo
Ool03goo00<007ooOol07goo0P004goo00<007ooOol00Woo00<007ooOol0H7oo001lOol20002Ool2
000[Ool00`00Oomoo`0?Ool00`00Oomoo`0KOol4000FOol00`00Oomoo`02Ool00`00Oomoo`1OOol0
07eoo`04001oogoo000/Ool00`00Oomoo`0;Ool4000MOol3000HOol00`00Oomoo`03Ool00`00Oomo
o`1NOol007ioo`8002eoo`03001oogoo00]oo`03001oogoo01]oo`<001]oo`03001oogoo00=oo`03
001oogoo05ioo`00OWoo0P00:goo0`003Goo00<007ooOol067oo0`007Woo00<007ooOol017oo00<0
07ooOol0GGoo001mOol01000Oomoo`00;7oo00<007ooOol02goo1@004goo0`008Goo00<007ooOol0
17oo00<007ooOol0GGoo001lOol20002Ool2001?Ool4000ROol00`00Oomoo`05Ool00`00Oomoo`1L
Ool00<moo`8002Ioo`03001oogoo00Eoo`8005eoo`00c7oo0`00:7oo00<007ooOol01Woo00<007oo
Ool0Fgoo003:Ool2000[Ool00`00Oomoo`07Ool00`00Oomoo`1JOol00<Moo`<00003Ool007oo02Yo
o`03001oogoo00Qoo`03001oogoo05Uoo`00aGoo0P00<7oo00<007ooOol027oo00<007ooOol03goo
1@00AGoo0030Ool00`00Ool00002000bOol00`00Oomoo`09Ool00`00Oomoo`0>Ool01@00Oomoogoo
0000AGoo002oOol3000eOol00`00Oomoo`0:Ool00`00Oomoo`0>Ool00`00Oomoo`16Ool00;eoo`80
00=oo`03001oogoo039oo`03001oogoo00Yoo`03001oogoo00Eoo`H000Aoo`03001oogoo04Eoo`00
^Woo0`00>Woo00<007ooOol02goo00<007ooOol03goo00<007ooOol0A7oo002;Ool5000WOol3000m
Ool00`00Oomoo`0<Ool00`00Oomoo`0?Ool00`00Oomoo`13Ool008eoo`03001oogoo02Eoo`@003io
o`03001oogoo00aoo`03001oogoo00]oo`05001oogooOol00015Ool008eoo`03001oogoo02=oo`80
049oo`03001oogoo00eoo`03001oogoo00]oo`<004Ioo`00SGoo00<007ooOol087oo0`00AGoo00<0
07ooOol02goo00<007oo0000EGoo002=Ool00`00Oomoo`0MOol30018Ool00`00Oomoo`0=Ool00`00
Oomoo`1COol008eoo`03001oogoo01]oo`80009oo`03001oogoo04Ioo`03001oogoo00ioo`03001o
ogoo059oo`00Rgoo0`006Woo0`00CGoo00<007ooOol03goo00<007ooOol0DGoo002=Ool00`00Oomo
o`0EOol3001@Ool00`00Oomoo`0?Ool00`00Oomoo`1AOol00:=oo`<004aoo`04D]a>_5;LC]`2Ool0
0`00Oomoo`0@Ool00`00Oomoo`1@Ool00:5oo`8004Uoo`Y>g09oo`03001oogoo011oo`03001oogoo
051oo`00WWoo0`00BGoo00mBg4kLD]a>_5;LC]aBg4jlD]a>g5;LC[aBg7oo00004goo00<007ooOol0
Cgoo002LOol20019OolAC]`00`00Oomoo`0BOol00`00Oomoo`1>Ool009Uoo`@004Moo`0ED]a>g5;L
C[]Bg4kLD]a>^e;LC]aBg4jlD]a>g5;LC[aBg4kLD]a>_00001Aoo`03001oogoo04ioo`00UWoo0`00
BGoo5TkL00<007ooOol04goo00<007ooOol0CGoo002COol30019Ool06djlC]a>^e;LC[a>g4jkD]a>
g5;LC[]Bg4kLD]a>^e;LC]aBg4jlD]a>g5;LC[aBg4kL001>^`0COol00`00Ool0001>Ool0095oo`@0
04IooaY>g005D]a>g4kL001Bg00EOol00`00Oomoo`1<Ool008moo`8000=oo`03001oogoo045oo`0S
D]a>_4kLC[]Bg4jlC]a>^e;LC[a>g4jkD]a>_4kLC[]Bg4kLD]a>^e;LC]aBg4jkD]a>g5;LC[]Bg4kL
D]a>^`00C]aBg00EOol00`00Oomoo`1;Ool0051oo`@000Eoo`8000Eoo`@002Qoo`<004Aoob1>g006
D]a>g4kLC]aBg0000TkL00=Bg7ooOol04goo00<007ooOol0BWoo001?Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0SOol20015Ool0:djkC]a>_4kLC[]Bg4jl
C]a>^e;LC[a>g4jkD]a>_4kLC[]Bg4jlC]a>^e;LC[aBg4jkD]a>g5;LC[]Bg4kLD]a>^e;LC]aBg4jk
D]a>g000C[]Bg4kL01Eoo`03001oogoo04Yoo`00Cgoo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol087oo0`0000=oo`00Ool0@Goo00E>_4kLC]a>g4jl029>g005D]a>g4kL001Bg003C]`EOol0
0`00Oomoo`19Ool004moo`03001oogoo009oo`03001oogoo00eoo`03001oogoo01ioo`8004Aoo`0c
C[]>g4jlC]a>^dkLC[a>g4jkC]a>_4kLC[]Bg4jlC]a>^e;LC[a>g4jkD]a>_4kLC[]Bg4jlD]a>^e;L
C]aBg4jkD]a>g5;LC[]Bg4kLD]a>^e;LC]aBg4jkD]`005;LC[]Bg4kL01Eoo`03001oogoo04Qoo`00
Cgoo00<007ooOol00Woo00<007ooOol02Goo10007Goo1000@goo00E>_4kLC[a>g4jl00=>g005C[a>
g4kLC]a>_00NC]`02E;LC]a>g4kLD]a>g000C]aBg002C]`EOol00`00Oomoo`18Ool004moo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo01aoo`@0041oo`0lC[a>g4ZkC]a>_4kLB[]>g4jlC]a>
^dkLC[a>g4jkC]a>_4kLC[]>g4jlC]a>^e;LC[a>g4jkD]a>_4kLC[]Bg4jlD]a>^e;LC[aBg4jkD]a>
g5;LC[]Bg4kLD]a>^e;LC]aBg4jkD]a>g5;L001Bg4kLD]a>^e;L5Goo00<007ooOol0Agoo001?Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0JOol20011Ool00djlC]a>_002C[`02TkLC[a>
g4jlC]a>_4kLC[a>g4jl0dkL00E>_4kLC]a>g4jl01i>g005D]a>g4kLC]`00003C]`00e;LC]a>g00E
Ool00`00Oomoo`16Ool0051oo`@000aoo`D001Eoo`<003ioo`15B[]>g4ZlC]a:^dkLB[a>g4ZkC]a>
_4kLB[]>g4jlC]a:^dkLC[a>g4jkC]a>_4kLC[]>g4jlC]a>^dkLC[a>g4jkD]a>_4kLC[]Bg4jlD]a>
^e;LC[aBg4jkD]a>_5;LC[]Bg4kLD]a>^e;LC]aBg4jkD_e>o5;mC[]Bg000D]a>^e;LC]aBg4jk01Ao
o`8004Qoo`00N7oo0`00?Goo00=:_4jlB[`014jl00E>g4jlC[a>_4kL00=>_006C]a>_4kLC[a>g4jl
0dkL00E>_4kLC]a>g4jl00=>g003C[a>g4kL01M>g00:D_aBoE;lD_eBo5;LC]`004kLD]`3C]`00e;L
C]aoo`0DOol00`00Oomoo`15Ool007Eoo`<003]oo`1?B[a>g4ZkC]a:_4kLB[]>g4ZlC]a:^dkLB[a>
g4ZkC]a:_4kLB[]>g4jlC]a:^dkLC[a>g4ZkC]a>_4kLC[]>g4jlC]a>^dkLC[a>g4jkD]a>_4kLC[]B
g4jlC]a>^e;LC[aBg4jkD]a>_5;LC[]Bg4jlD]a>^e;LC]aBoDklD_e>o5;mC_aBoDklD]`005;LC]aB
g4jkD]a>g5;LC[/05Goo00<007ooOol0A7oo001cOol2000lOol034jlB[a:_4ZlC[a:_4jlB[a>_4Zl
C[a:_0A>_00>C]a>_4jlC[a>g4jlC]a>_4kLC[a>g4jlC]a>_0=>g005C[a>g4kLC]a>_003C]`00djl
C]a>g00@C]`03E;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo00000=>g005D]a>g4kLC]aBg00EOol00`00
Oomoo`14Ool0071oo`<003Uoo`1GC]a:_4jlB[]>g4ZlC[a:^dkLB[a>g4ZkC]a:_4kLB[]>g4ZlC]a:
^dkLB[a>g4ZkC]a:_4kLB[]>g4jlC]a:^dkLC[a>g4ZkC]a>_4kLC[]>g4jlC]a>^dkLC[a>g4jkD]a>
_4kLC[]Bg4jlC]a>^e;LC[aBg4jkD]a>_5;LC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@00D]a>
^e;LC]aBg4jkD]a>g5;L01Eoo`03001oogoo04=oo`00KGoo0`0000=oo`00Ool0=Woo1TZl00E>_4Zl
B[a:_4jl00=:_009C[a:_4jlB[a>_4ZlC[a:_4kL00=>_00>C]a>_4jlC[a>g4jlC]a>_4kLC[a>g4jl
C]a>_0=>g005C[a>g4kLC]a>_00?C]`055;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0
04kLD]`3C]`015;LC]a>g4kL5Goo00<007ooOol0@goo001[Ool2000gOol00dZlB[]>_002B[`0FdZk
C[a:_4ZlB[]>g4ZlC[a:^dkLB[a>_4ZkC]a:_4kLB[]>g4ZlC]a:^dkLB[a>g4ZkC]a:_4kLB[]>g4Zl
C]a:^dkLC[a>g4ZkC]a>_4kLB[]>g4jlC]a>^dkLC[a>g4jkD]a>_4kLC[]Bg4jlC]a>^e;LC[aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_d005;mC]aBg4jkD]a>g5;LC[]Bg4kL
01Eoo`03001oogoo049oo`00J7oo0`00=goo3dZl00i>_4ZlB[a:_4jlB[a>_4ZlC[a:_4jlB[a>_4Zl
0Tjl00E>g4jlC[a>_4kL00=>_00:C]a>_4kLC[a>g4jlC]a>_4kLC[`3C]`01DjlC]a>g4kLC[`01dkL
01UBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo002C]`01E;L
C]a>g4kLD]`00TkL5Woo00<007ooOol05Woo0P0000=oo`0000009Woo001VOol200000goo001oo`0b
Ool034ZLB[a6VdZlBYa:_4JKB[a:W4ZlB[]>_09:_01JB[]>_4ZlB[a:^dkLB[a>_4ZkC]a:_4jlB[]>
g4ZlC]a:^dkLB[a>g4ZkC]a:_4kLB[]>g4ZlC]a:^dkLB[a>g4ZkC]a>_4kLB[]>g4jlC]a:^e;LC[a>
g4jkD]a>_4kLC[]Bg4jlC]a>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;m001BoDklD]a>g5;LC[]Bg4kLD]a>^e;L5Goo00<007ooOol05Goo00<007ooOol00P00
9goo001SOol30003Ool00`00Oomoo`0YOol02DJlAYa:_4JLA[a6W4ZlAYa6_00AB[`02TjlB[a:_4Zl
C[a:_4jlB[a>_4Zl0djl00E:_4jlC[a>_4Zl009>_005C]a>_4jlC[a>g003C[`02TkLC[a>g4jlC]a>
_4kLC[a>g4jl0dkL02E>_4kLC]a>g5;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo002C]`01U;LC]a>g4kLD]a>g1Ioo`03001oogoo01Ao
o`05001oogooOol0000WOol003Ioo`@002Ioo`<000Yoo`037M/Qngoo01ioo`05A[a6W4JL@Y]6_002
AY`04D:KB[a6W4ZlAY]:_4JLB[a6VdZlBYa:_4JKB[a:W4ZlAY/00dZl05e:^djlB[a:_4ZkC[a:_4jl
B[]>g4ZlC[a:^dkLB[a>_4ZkC]a:_4kLB[]>g4ZlC]a:^dkLB[a>g4ZkC]a:_4kLB[]>g4ZlC]a>^dkL
C[a>g4jkC]a>_4kLC[]Bg4jlC]a>^e;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;m001BoDklD_e>^e;LC]aBg4jkD]a>g5;LC[/05Goo0P005Goo
00D007ooOomoo`0002Moo`00=Goo00<007ooOol00Woo00<007ooOol08Goo0`003Goo00@Mfb7K8M/Q
faEoo`Q2W0Q6W008A[a6W4ZlAYa6_4JLB[a6W19:_00:C[a:_4jlB[a>_4ZlC[a:_4jlB[`3C[`01DZl
C[a>_4jlB[`00Tjl00E>g4jlC[a>_4kL00=>_00aC]a>_4kLC[a>g4jlC]a>_4kLC[aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000
D_aBoE;lD_d00dkL00IBg4kLC]a>g5;LC]`EOol00`00Oomoo`0COol01@00Oomoogoo00009goo000e
Ool00`00Oomoo`02Ool00`00Oomoo`0OOol2000@Ool02b7k7M/QnagK8O/^6c8l;Q/b?2hK<S`01goo
0152W3il@W`nNd:L?Wa2O3ikAYa2O4JL@W]6W49lAYa2VdJl0096W00E@Y]6_4JLAYa2VdZlAYa:_4JK
B[a6W4ZlAY]:_4ZLB[a6VdZlBYa:_4JK009:_01MC[a:^djlB[a>_4ZkC[a:_4jlB[]>g4ZlC[a:^dkL
B[a>_4ZkC]a:_4kLB[]>g4ZlC]a:^dkLC[a>g4ZkC]a>_4kLB[]>g4jlC]a>^dkLC[a>g4jkD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_d005;mC_aBoDklD_e>^e;LC]aBg4jkD]a>g5;L01Ioo`03001oogoo015oo`80009oo`80
02Moo`00=Goo00<007ooOol00Woo00<007ooOol077oo0`004goo00<QfagK8M/00R7K00H^>c8l;S`b
?2hk<S`7>U`7?W`8@Y`9AY`01TJlAYa:_4JLA[a6W1A:_00:C[a:_4jlB[a>_4ZlC[a:_4jlB[`3C[`0
14ZlC[a>_4kL0djl00E>g4jlC[a>_4kL00=>_00aC]a>_5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;m
D_aBoE;lD_d00dkL00EBg4kLC]a>g5;L01Ioo`03001oogoo00Moo`@0039oo`00=Goo00<007ooOol0
0Woo00<007ooOol06Goo0`005Woo02@Mfb7k7M/QnagK8O/^6c8l;Q/b?2hK>W`jG3Yl=U/jO3YL>W`n
Nd:L?Wa2O3ik@Y`nO49l@W]6W49lAYa2NdJL@Wa6W4:KA[`2AY`0M4:KA[a6W4JLAY]:_4JLB[a6VdZl
AYa:_4ZKB[a:W4ZlBY]:_4ZLB[a:VdjlB[a>_4ZkC[a:_4jlB[]>_4ZlC[a:^dkLB[a>_4ZkC]a:_4kL
B[]>g4ZlC]a:^dkLB[a>g4ZkC]a>_4kLB[]>g4klD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_`004klD_e>o5;mC_aBg4jkD]a>g5;LC[]Bg4kLD]`EOol00`00Oomoo`06Ool00`00Oomoo`02Ool0
0`00Oomoo`0_Ool003Eoo`03001oogoo009oo`03001oogoo01Moo`8001Yoo`8Qf`097M/Qfb7K<S`^
>c8l;S`b?2hk00LjG0PnO0M2W0Y6W006B[a:W4ZlAYa:_4ZL54Zl00U>_4ZlC[a:_4jlB[a>_4ZlC]`0
0djl00E>g4jlC[a>_4kL00=>_010D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d0
05;mD_aBoE;lD_eBo5;LC]aBg4kLD]a>g5;LC]`FOol00`00Oomoo`05Ool00`00Oomoo`02Ool00`00
Oomoo`0_Ool003Eoo`03001oogoo009oo`03001oogoo01Aoo`<001aoo`0P2GXQfb7k7M/QnagK<S`^
6c8l;Q/b?2hK>W`jG3Yl=U/jO3YL>W`nNd:L?Wa2O3ik@Y`nO4JL@W]6W49lAYa2N`=6W01g@Y]6_4JL
AYa6VdZlAYa6_4JKB[a6W4ZlAY]:_4JLB[a:VdZlBYa:_4ZKB[a:W4ZlBY]>_4ZlC[a:^djlB[a>_4Zk
C[a:^djlB[]>g4ZkC[a:^dkLB[a>g4ZkC]a:_4kLB[]>g4ZlD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_`004klD_e>o5;mC_aBoDklD]a>^e;LC]aBg4jkD]a>g00FOol00`00
Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`0_Ool003Ioo`@001Eoo`80021oo`<Un`088O/UnbGk
<S`^>c8l;S`b?0LjG0PnO0M2W0U6W008B[a6W4ZlBYa:_4JLB[a:W11:_00:C[a:_4ZlB[a>_4ZlC[a:
_4jlB[`2C[`0C4kLC[a>_4jlD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_d005;mD_aBoE;lD_eBo5;mD_aBg4kLD]a>g5;LC]aBg4kL5Goo00<007ooOol017oo00<0
07ooOol00Woo00<007ooOol0;goo001<Ool300000goo001oo`0OOol08@UI9O`QfbGk8M/Uo27K<S`b
>cIL<S/b?3IK>W`jG3Yl=U/jO3YL@Y`nNd:L?Wa2W3ik@Y`nO4JL@W]6W49lAYa2N`02AY`0MdJlAY]:
_4JLA[a6VdZlAYa:_4JKB[a6W4ZlAY]:_4JLB[a:VdZlBYa:_4ZKB[a:W4ZlB[]>_4ZkC[a:^djlB[]>
_4ZkC]a:^djlB[]>g4ZkC[a:^dkLB[a>g4klD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o000C_aBoDklD_e>o5;mC_aBoDkLD]a>^e;LC]aBg4jkD]`05Woo00<0
07ooOol00goo00<007ooOol00Woo00<007ooOol0;goo001:Ool2000UOol22ET39O/01B7k9O/b?38l
<S/00c8l0cYL00HjO3YL>U`jG49l?W`3@W`02Cil@Wa2W4JL@Ya6W4:LAYa2W00:AY`024ZlAYa:_4ZL
B[a6W4ZlBY`<B[`0FdjlB[a:_4ZlC[a:_4jlB[a>_4ZlC[a:_4jlD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_e>
g5;LC]aBg4kLD]a>g5;L01Ioo`03001oogoo009oo`03001oogoo009oo`03001oogoo02moo`00Agoo
0`00:7oo0289FPUI9O`QfbGk8M/Uo38k<S`b>cIL<S/b?3YK?W`jFcil>U/nO3YK@Y`nNd:L?Wa2W3ik
@Ya2O4JL@W]6W49lAYa2N`96W01gA[a6VdZlAYa6_4JKB[a6W4ZlAY]:_4JLB[a6VdZlAYa:_4ZKC[a:
^dZlBY]>_4ZkC[a:^djlB[]>_4ZkC[a:^djlB[]>g4ZkC[a>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`004klD_e>o5;mC_aBoDklD_e>
o5;LC]aBg4jkD]a>fe;LC[]Bg00DOol20005Ool4000bOol004Aoo`<00003Ool007oo02Qoo`89F@05
8O/UnbGk9O/Qn`03<S`0138k<S`b?38l0cYL00HjO3YL>U`jG49l?W`3@W`02Cil@Wa2W4JL@Ya6W4:L
AYa2W009AY`2B[`01DZLB[a:_4ZlBY`02TZl00E>_4ZlB[a:_4jl00=:_01FC[a:_5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d0
05;mD_aBoE;lD_eBo5;mD_aBoE;lD]a>g5;LC]aBg4kLD]a>g1Ioo`03001oogoo03Qoo`00@Woo0P00
;goo01<=NA6J8M/Uo27K9O/QfcIL<S/b?38k=U`b>cil>U/nO3YK?W`jF`02?W`0LD:L?W]2W3il@Y`n
Nd:L@Wa6W49kAYa2O4JL@W]:_4JLA[a6VdZlAYa:_4JKB[a6VdZlAY]:_4JKB[a6VdZlB[]:_4ZKC[a:
^dZlBY]>_4ZkC[a:^djlB[]>_4ZkD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_d00P0001=>o5;mC_aBoDklD_e>o5;mC_aB
oDjkD]a>fe;LC[]Bg4kKD]a>^`0FOol00`00Oomoo`0gOol003moo`<0035oo`<ANP@Un`05<S/b?38l
<S`b>`02<S`01CYl>U`jG3YL>W`00SYL0T9l00dnO49l@Wa2O3ilAYa2W4JL@Ya6W4:LAYa2W009AY`2
B[`01DZLB[a:_4ZlBY`02TZl04E>_4ZlD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d00`0001IBoE;l001Bo5;mD_aBoE;l
D_eBo5;mD_aBoDkLD]a>g5;LC]aBg4kLD]a>g1Eoo`03001oogoo03Moo`00?Goo0P0000=oo`000000
<Woo01@AVPei:Q/UnbXL9O/Z6c8k=U`b>c8l<S/fG38k?W`jFcil>U/nO3YK0Sil06U2W3ik@Y`nO4:L
?W]6W4:KAYa2NdJL@Y]6W49kB[a6VdZlAY]:_4JKB[a6VdZlAY]:_4JKB[a6VdZlAY]:_4ZkB[a:Vdjl
B[]:_4ZKC[a>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_d00`0001UBoDklD_e>o5;m001BoDklD_e>o5;mC_aBoDklD_e>o5;m
C[]Bg4kKD]a>^e;LC]]Bg00FOol00`00Oomoo`0fOol003]oo`8003Qoo`8ANP03:O/UnbWk008Yn`05
=S/f?3Hl=U`f>`02=S`02Cil>U`nO3iL?W`jG3il@Wa2W003@W`00d:L@Wa6W00?AY`3B[`01DZLB[a:
_4ZlBY`01DZl049Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d300007E;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;l
D_eBo5;mD_aBg4kLD]a>g5;LC]aBg4kLD]`05Goo00<007ooOol0=Woo000kOol2000hOol0N@ei4IX=
NBXK9O/Z72Gk:Q/b>cIL<S/fG38k=U`jFcil>U/nO3YK?W`jFd:L@W]2W3ik@Ya2Nd:L@W]6W4:KAYa2
NdJL@Y]6W4JKB[a6VdZlAY]:_4JKB[a6VdZlAY]:_4JKB[a6VdZlAY]>_4klD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl0080
000QD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_d005;mC_aBoDklD_e>o5;mC_aBoDklD]a>^e;LC]]B
g4jkD]a>fe;L01Eoo`03001oogoo03Eoo`00>goo00<007oo0000=goo0QFJ00@ANRWk:O/Un`<Yn`0=
=S/f?3Hl=U`f>cHl?U`nO3YL?W`nG3il>U`00T9l00E2W49l@Wa2O4:L0156W0=:_015BYa:_4ZlD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;l00<0000SD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eB
o5;mD_aBoE;lD]a>g5;LC]aBg4kLD]a>g00FOol00`00Oomoo`0dOol003]oo`800003Ool007oo03Io
o`1b6IXEVQVj9O/Z6bGk:Q`UncIL<S/fG38k=U`b>cil>U/nO3YK?W`jFcil>U]2W49k@Y`nNd:L@W]2
W49kAYa2VdJL@W]6W4:KB[a6VdZlAY]:_4JKB[a6VdZlAY]:_4ZKD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl0`0002M>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o000C_aBoDklD_e>o5;mC_aBoDklD_e>o5;L
C[]Bg4kKD]a>^e;LC]/05Goo00<007ooOol0=7oo000jOol00`00Oomoo`02Ool00`00Oomoo`0dOol4
5IX00bXK:O/Un`02:O/03CIL=S/f?3Hl=U`f>cil?U`nO3YL?W`nG3il00=2O004@Ya2O49l@W`8AY`0
BTZlAYa:W4JLB[a6W4ZLAYaBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`30000:U;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;mC]aBg4kLD]a>g5;LC]aBg1Io
o`8003Aoo`00>Woo00<007oo00000goo00<007ooOol0<goo06`I^QFJ6IXEVRhL:O/^72Wk;Q`YncIL
<S/fG38k=U`jFcil>U/nO3YK?W`jFcil?W]2W49k@Y`nNd:L@W]6W4IkAYa6VdJLAW]6W4JKB[a6VdZl
AY]BoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_`30000;TklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o000C_aBoDklD_e>o5;mC_aBoDklD_e>fe;LC[]Bg4kKD]a>^e;L5Woo00<007oo
Ool0<Woo000jOol20005Ool2000dOol45IX032hK:Q/^6bXK;Q/Z6cYL=S/fG3IK>U`nN`<nO004?W/n
O3il?W`3@W`014:L@Wa2O49l1TJL04ABoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l0`00039Bo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;m
D_aBoE;lD_e>g5;LC]aBg4kLD]a>g5;L5Goo00<007ooOol0<Woo000jOol00`00Oomoo`06Ool00`00
Oomoo`0aOol0IAFJ6KXEVQVJ:O/^72Wk;Q`YnbhL=S/jG3Hk>U`f>cYL?U]2O3iK?W`nFd9l?U/nO49k
AYa2Nd:L@W]6W49kAYa6NdJLC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`00`0003E>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@00D_e>o5;mC_aBoDkl
D_e>o5;mC_aBg4kKD]a>^e;LC]]Bg4jk01Ioo`03001oogoo035oo`00<Goo10001Goo0P0027oo00<0
07ooOol0<7oo00<0eafj5IX00QFJ00dZ6bhK:Q/^6bXK;Q/fFcYL=S/fG3IK>U`nN`03?W`013ik?W`n
O3il0d9l04I2W49l@Wa2O5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo0<0000aD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aB
oE;lD_eBo5;mD_`00e;L00E>g5;LD]aBg4kL01Ioo`03001oogoo031oo`00<7oo00<007ooOol00Woo
00<007ooOol00Woo00<007ooOol027oo00<007ooOol0<7oo05lM^aVj7K/EVRhL:O/^72Wk;Q`YnbhL
=S/jG3Hk>U`f>cYL?U]2O3iK?W`nFd9l?U]2W49kAYa2Ne;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m0080000mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;m001BoDklD_e>o5;mC_aBoDklD_e>o5;LC]]Bg4jkD]a>fe;LC[/05Goo
00<007ooOol0<7oo000eOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0_Ool00`3G7KXM
^P027KX03RhK:Q/^6bXK;Q/Z6cIL=U/jG3Hk=U`fFcil?W/3?W`0ASik?W`nO4:LD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
0`0003QBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;l0e;L
00A>g5;LD]aBg1Ioo`03001oogoo02moo`00:7oo1P001goo00@007ooOomoo`8000aoo`03001oogoo
02moo`1H7KXM^aVj7K/M^S8L;Q/b?2hK<Q`^6cYL=S/jG3Hk>U`f>cil?U]2O3iK?Wa>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_d30000@e;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o000C_aBoDklD_e>o5;mC_aB
oDklD_e>^e;LC]]Bg4jkD]a>fe;L01Ioo`03001oogoo02ioo`00<Goo100017oo00<007ooOol037oo
00<007ooOol0;Woo00<0eafj7KX00Qfj050^6c8K;Q/b6bhK<Q/^6cYL>U/jG3YK>U`jFd9lD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;m0`00041BoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000D_aB
oE;lD_eBo5;mD_aBoE;lD_e>g0=Bg004C]aBg5;LD]`EOol00`00Oomoo`0^Ool0035oo`03001oogoo
00Eoo`03001oogoo00eoo`03001oogoo02eoo`1B1?LM^afj7K/I^Qfk;Q/b72hK<S`^6c8L>S/jG3YK
>U`j>e;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_d30000BU;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_`004klD_e>o5;mC_aBoDklD_e>o5;mC[]Bg4kKD]a>^e;LC]/FOol2000^Ool0035o
o`03001oogoo00Eoo`8000moo`03001oogoo02eoo`031APM^Qfj00<M^P18;Q/b6bhK<Q/^6c8K>U/j
G5;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;m0`0004QBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBo5;mC]`3D]`00dkLD]aBg00EOol2000^Ool0
035oo`D000=oo`03001oogoo00moo`03001oogoo02aoo`1;1AP4mbGK7KXM^aVj7K/^6c8L;Q/b?4kl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;m00<0001AD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;m001BoDklD_e>o5;mC_aBoDklD_e>o5;LC[]Bg4kKD]a>^e;L01Ioo`03
001oogoo02aoo`00>Goo0P004Goo00<007ooOol0:goo0PDH0b7J0Qfj048b6e;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`20000
D5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBo5;LC]`3D]`00dkLD]aoo`0EOol00`00
Oomoo`0[Ool003Qoo`8001=oo`03001oogoo02]oo`151AL564klD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl00<0001HC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_d005;mC_aBoDklD_e>o5;mC_aBoDkKD]a>^e;LC]]Bg4jkD]`FOol00`00
Oomoo`0ZOol003Qoo`03001oogoo01=oo`8002]oo`12D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l0`0005ABo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_d2D]`01DkLD]aBg5;LC]`05Woo00<0
07ooOol0:Woo000hOol3000EOol00`00Oomoo`0VOol0@DklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`00`0005m>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl001>o5;mC_aBoDklD_e>o5;mC_aBoDkKD]a>^e;LC]]Bg4jk
01Ioo`03001oogoo02Uoo`00>7oo00<007ooOol05Woo00<007ooOol08Woo045Bo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l00<0
001LD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eB
o5;mD_aBo@9Bg005C]aBg5;LD]a>g00EOol00`00Oomoo`0YOol001ioo`D000Eoo`8000Eoo`@000Eo
o`03001oogoo01Moo`03001oogoo01ioo`11C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o0030000ITklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@00D_e>o5;mC_aBoDklD_e>o5;mC_aBg4kKD]a>
^e;LC]]Bg1Ioo`03001oogoo02Qoo`007Woo00D007ooOomoo`0000Eoo`8000Aoo`03001oogoo009o
o`03001oogoo009oo`8001Uoo`03001oogoo01Qoo`13D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`00`0006=Bo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aB
oE;lD_eBo5;mD_`00e;L00A>g5;LD]aBg1Eoo`8002Uoo`007goo00<007ooOol04Goo00<007ooOol0
0Woo00<007ooOol06Goo00<007ooOol05Goo049BoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`30000KTklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_d005;mC_aBoDkl
D_e>o5;mC_aBoDklD]a>fe;LC[]Bg4kKD]`EOol00`00Oomoo`0WOol001Ioo`H000Aoo`03001oogoo
011oo`05001oogooOol0000MOol00`00Oomoo`0BOol0@U;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@80001[D_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;m001BoE;lD_eBo5;mD_aBoE;lD_eBo003D]`00e;KD]aBg00FOol00`00Oomoo`07Ool5000JOol0
025oo`03001oogoo00]oo`@000Aoo`8001eoo`03001oogoo00ioo`12C_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m0`0007AB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDkl001>o5;mC_aBoDklD_e>o5;mC_aBoDjkD]a>fe;LC[]Bg4kK5Woo00<007oo
Ool01Woo00D007ooOomoo`0001Yoo`008Woo00<007ooOol02Woo00<007ooOol01Goo00<007ooOol0
7Goo00<007ooOol02goo045BoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m00<0001bD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001B
o5;mD_aBoE;lD_eBo5;mD_aBoE;K0e;L00=Bfe;LOol05Goo00<007ooOol01goo00<007ooOol06goo
000NOol01@00Oomoogoo000037oo00<007ooOol01Goo0P007goo00<007ooOol027oo041>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
o@<0001kD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`004klD_e>o5;mC_aBoDklD_e>o5;L
C[]Bg4kKD]a>^e;L01Ioo`03001oogoo00Moo`03001oogoo01Yoo`007goo0`003Goo1@000goo00<0
07ooOol07goo00<007ooOol017oo041Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@<0001jD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD]aBf`=Bg003D]]Bg7oo01Eoo`03001o
ogoo00Moo`03001oogoo01Uoo`00=goo00<007ooOol087oo04<007ooOomooe;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@030000PU;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_d005;mC_aBoDklD_e>o5;m
C_aBoDklD]a>^e;LC]]Bg4jk5Woo00<007ooOol027oo00<007ooOol067oo000gOol00`00Oomoo`0O
Ool0@E;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_d00`00089BoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eBo5;mD_aBoE;lD]aBf`=Bg003D]]oogoo01Aoo`03001o
ogoo00=oo`05001oogooOol0000JOol003Ioo`03001oogoo01ioo`10C_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_d30000RE;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m001B
oDklD_e>o5;mC_aBoDklD_e>o5;LC[]Bg4kKD]`05Goo0`001Goo0`006goo000fOol00`00Oomoo`0L
Ool0@5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;l0P0008YBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;LD]/3D]`FOol0
0`00Oomoo`0QOol003Ioo`<001Uoo`10D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`30000SdklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl001>o5;mC_aB
oDklD_e>o5;mC_aBoDklD]a>^e;LC]/05goo00<007ooOol087oo000fOol00`00Oomoo`0GOol0?e;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo0030000SU;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;m0U;L00=B
fe;LD]`05goo00<007ooOol07goo000/Ool40006Ool00`00Oomoo`0BOol0@DklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`00`00
09I>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`004klD_e>o5;mC_aBoDklD_e>o5;mC]]Bg4jk
D]`GOol00`00Oomoo`0OOol002]oo`03001oogoo009oo`03001oogoo009oo`<0015oo`10D_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_`30000UE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eB
o5;mD_`00e;L00=Bfe;LOol05Woo00<007ooOol07Woo000[Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`0?Ool0?dklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o0030000WDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;m001BoDklD_e>o5;mC_aBoDklD_e>o5;LC]]Bg4jk01Qoo`03001oogoo01eoo`00
:goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol037oo03mBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`00`0009eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aB
oE;lD_eBo003D]`00e;KOomoo`0EOol00`00Oomoo`0MOol002]oo`03001oogoo009oo`03001oogoo
009oo`8000]oo`0nD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o0<0002UC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;m001BoDklD_e>o5;mC_aBoDklD_e>^e;LD]]Bg4jk01Ioo`8001io
o`00:goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol01Goo045BoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m0080002U
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;K00=Bg003D]]oogoo01Aoo`03001oogoo01aoo`00
2goo0P0000=oo`0000006goo00<007ooOol00Woo00<007ooOol00Woo0P001goo03eBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@030000Ze;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o000C_aBoDklD_e>o5;mC_aBoDklD]a>^e;LD]]Bg00GOol00`00Oomoo`0KOol000Yo
o`03001oogoo008001eoo`@000Eoo`03001oogoo00Moo`0iD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m00<0002/D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;l
D_eBo5;mD_aBoE;lD_eBo5;LD]/3D]`GOol00`00Oomoo`0JOol000Yoo`05001oogooOol0000VOol0
0`00Oomoo`09Ool0=4klD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m0`00
0;=BoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@00D_e>o5;mC_aBoDklD_e>o5;mC_aBg4jkD]aBfe;L
01Ioo`03001oogoo01Yoo`002Woo00D007ooOomoo`0002Eoo`8000aoo`0`D_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;m0`000;MBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
001BoE;lD_eBo5;mD_aBoE;lD_eBo5;LD]]Bg5;KD]`05Woo00<007ooOol06Goo000:Ool01@00Oomo
ogoo000017oo00<007ooOol07Woo00<007ooOol037oo02a>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;m0`000;YBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_d005;mC_aBoDkl
D_e>o5;mC_aBoE;KD]a>^e;LD]/GOol00`00Oomoo`0HOol000Uoo`80009oo`8000Aoo`03001oogoo
01ioo`03001oogoo00eoo`0XD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d30000_U;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBfe;LD]]B
g5;K5Woo00<007ooOol067oo000COol00`00Oomoo`0NOol2000?Ool094klD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@<00031
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`004kl
D_e>o5;mC_aBoDklD_e>o5;mD]]Bg4jkD]`05goo0P0067oo000COol00`00Oomoo`0NOol00`00Oomo
o`0?Ool08E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo0020000aE;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;LD]]Bg5;KD]`05goo00<0
07ooOol05Woo000IOol50005Ool20005Ool40006Ool00`00Oomoo`0@Ool07DklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`00`000<Q>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
001>o5;mC_aBoDklD_e>o5;mC_aBg5;KD]a>^e;L5Woo00<007ooOol05Woo000IOol01@00Oomoogoo
00001Goo0P0017oo00<007ooOol00Woo00<007ooOol00Woo0P004goo01UBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo0030000be;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000
D_aBoE;lD_eBo5;mD_aBoE;KD]aBfe;LD]/05Woo0P005goo000JOol00`00Oomoo`0AOol00`00Oomo
o`02Ool00`00Oomoo`0DOol055;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`3
0000cdklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@00D_e>o5;mC_aBoDklD_e>o5;mC[]Bg5;KD]a>^`0A
Ool400000goo001oo`0FOol001]oo`03001oogoo011oo`03001oogoo009oo`03001oogoo01Eoo`0@
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`30000dU;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBfe;LD]]Bg0ioo`<000Eoo`03001oogoo01Eoo`00
77oo00<007ooOol02goo10001Goo0P0067oo00]>o5;mC_aBoDklD_e>o5;mC_aBoDkl00<0003FC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@00D_e>o5;mC_aBoDklD_e>o5;mC[]B
g5;KD]`:Ool30008Ool00`00Oomoo`0EOol001eoo`03001oogoo00Yoo`03001oogoo00Ioo`03001o
ogoo01Qoo`07D_aBoE;lD_eBo5;mD_`00`000=YBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;KD]aBfe;L1Goo100037oo00<007oo
Ool057oo000IOol01@00Oomoogoo000037oo00<007ooOol01Woo00<007ooOol06Goo00A>o5;mC_aB
o@80003MC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
001>o5;mC_aBoDklD_e>o5;mC_aBoE:kD]aBf`02Ool3000@Ool00`00Oomoo`0DOol001Yoo`<000eo
o`D000=oo`8001]oo`3UD_d00000001BoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;mD]]Bg5;K00004goo00<0
07ooOol057oo000bOol00`00Oomoo`0HOol30000he;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl001>o5;mC_aBoDklD_e>o5;mC_aB
oE:kD]`057oo00<007ooOol057oo000bOol00`00Oomoo`0EOol30004Ool0he;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;m
D_aBoE;lD_eBo5;mD_aBg5;KD]`04goo00<007ooOol057oo000bOol2000COol30008Ool0he;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
o@00D_e>o5;mC_aBoDklD_e>o5;mC_aBg5:kD]`04Woo00<007ooOol057oo000bOol00`00Oomoo`0?
Ool3000<Ool0hU;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eBo5;mD_aBg5;K4Woo00<007ooOol057oo000b
Ool00`00Oomoo`0<Ool3000AOol0hDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl001>o5;mC_aBoDklD_e>o5;mC_aBoE;KD]aB^`0BOol00`00
Oomoo`0COol0035oo`<000Yoo`<001Eoo`3PD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;mD]]Bg19oo`03
001oogoo01=oo`00:7oo10001Woo00<007ooOol01goo0P006Goo0>1>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aB
oDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o000C_aBoDklD_e>o5;mC_aB
oDklD]aBfe;L4Goo00<007ooOol04goo000WOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`05Ool3000LOol0gE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_`00U;K00=Bg7ooOol03Woo00<007ooOol0
4goo000/Ool00`00Oomoo`02Ool20003Ool3000QOol0gU;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_d005;mC_aBoDklD_e>o5;mC_aBoDklD]aBfa1o
o`03001oogoo01=oo`00;7oo00<007ooOol00Woo00<007oo00000P009Goo0=aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aB
oE;lD_eBo09Bf`moo`03001oogoo01=oo`00:7oo10001Goo0P00:Goo0=eBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m001BoDklD_e>o5;mC_aBoDkl
D_eB^e;L00moo`03001oogoo01=oo`00:7oo00<007ooOol01goo00<007ooOol0:7oo0=]BoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eB
o5;mD_aBoE;lD_d00U;K3goo00<007ooOol04Woo000XOol00`00Oomoo`08Ool2000ZOol0g4klD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o000C_aBoDklD_e>
o5;mC_aBoDklD_eB^eKL3Woo00<007ooOol04Woo000XOol50008Ool00`00Oomoo`0XOol0fe;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eB
o5;mD_aBoE;lD]aBf`0>Ool00`00Oomoo`0BOol003Ioo`03001oogoo02Qoo`3KC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl001>o5;mC_aBoDklD_e>o5;m
C_aBg5:k00eoo`03001oogoo019oo`00=goo00<007ooOol0:7oo0=YBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBfe;L3Goo
00<007ooOol04Woo000hOol2000ZOol0fE;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;m001BoDklD_e>o5;mC_aBoDklD_eBfe;L00aoo`03001oogoo019oo`00>Woo
00<007ooOol0:7oo0=MBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBo@00D_eBo5;mD_aBoE;lD_eBo5;m009Bf`]oo`03001oogoo019oo`00>goo00<007ooOol0:7oo
0=UBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@00D_e>o5;m
C_aBoDklD_e>o5KLD]]Bg00;Ool00`00Oomoo`0AOol003aoo`03001oogoo02Qoo`3FD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_`2
D]/;Ool00`00Oomoo`0AOol003eoo`8002Uoo`3HD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDkl001>o5;mC_aBoDklD_e>o5;mC_aFg5;K2Woo00<007ooOol04Goo000o
Ool00`00Oomoo`0WOol0eU;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo000D_aBoE;lD_eBo5;mD_aBoE;l0U;K2Goo00<007ooOol04Goo0010Ool00`00Oomoo`0WOol0
ee;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o000C_aBoDklD_e>
o5;mC_aBoE:kE]`02Goo00<007ooOol04Goo0011Ool00`00Oomoo`0WOol0eE;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eBo5;mD_aBo@02D]/8Ool0
0`00Oomoo`0AOol0049oo`03001oogoo02Qoo`3EC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_d005;mC_aBoDklD_e>o5;mC_aBoE:k00Qoo`03001oogoo015oo`00@goo0P00
:Goo0=EBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aB
oE;lD_eBo5;mD]/027oo00<007ooOol047oo0015Ool00`00Oomoo`0WOol0e4klD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o000C_aBoDklD_e>o5;mC_aBoDklE]`8Ool00`00Oomo
o`0@Ool004Ioo`03001oogoo02Moo`3DD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBf`Moo`03001oogoo011oo`00Agoo00<007ooOol09goo
0==>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`004klD_e>o5;mC_aBoDkl
D_e>o007Ool00`00Oomoo`0@Ool004Qoo`8002Qoo`3CD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_`01Woo00<007ooOol047oo001:Ool00`00
Oomoo`0VOol0dTklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_d005;mC_aBoDkl
D_e>o5;mC_aBo@Ioo`03001oogoo011oo`00Bgoo00<007ooOol09Woo0=9Bo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_d5Ool00`00Oomoo`0@Ool0
04aoo`03001oogoo02Ioo`3>C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBo@00
D_e>o5;mC_aBo@Qoo`03001oogoo011oo`00CGoo0P009goo0<UBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;m00003Goo00<007ooOol03goo001?Ool00`00Oomoo`0UOol0`4klD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBo@Moo`03001oogoo00]oo`03001oogoo00moo`00D7oo00<007ooOol0
9Woo0:aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo0]Bo@06D_aBoE;l
D_eBo5;m2Goo00<007ooOol02Woo00<007ooOol03goo001AOol00`00Oomoo`0WOol0WTklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aFfe:kE]/8D_d04TklD_e>o5;mC_aBoE:kE]]B^eKKD[]Ffe:kE]]B^eKKD[]Fg0eoo`03001oogoo
00Uoo`03001oogoo00moo`00DWoo0P00:7oo095Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE:kD_eBo5;mD_aBoE;lD_eBo009D_d02E:kD]]B^eKKD[]Bfe:kE]]B^`02D]/01UKKD[]Bfe;KE]]B
^`9Bf`07E]]B^e;KD]]Ffe:kD]/047oo00<007ooOol02Goo00<007ooOol03goo001DOol00`00Oomo
o`0VOol0PdklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`01e;m02MB^UKKC_aFfe:jE]]B^UKKD[YFfe:kE]]B
^UKKD[]Ffe:jE]]B^eKKD[YFfe:kE]]B^UKKD[]Ffe:jE]]B^eKKD[YFfe:kE]]B^eKKD[/04goo00<0
07ooOol027oo00<007ooOol03goo001EOol00`00Oomoo`0VOol0Je;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_`01E;m00=Bo5;mD[/01U:k00YF^e:jE[]B^UJkD[YF^e:kE[]B^P9B^`0NE[]B
^U:kD[]Ffe:kE[]B^eKKD[]F^e:kE]]B^e;KD[]Ffe:kD]]B^eKKD[]Ffe:kE]]B^eKKD[]Ffe:k0U;K
00IFfe:kD]]BfeKKD[/IOol00`00Oomoo`07Ool00`00Oomoo`0?Ool005Ioo`03001oogoo02Ioo`2X
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;m
C_aBoDklD_e>o5;mC_aBoDklD_e>o5;mD[YF^e:jE[]B^UJkD[YF^e:jE]]B^UJkD[YFfe:jE[]B^UKK
D[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^eKK
D[YFfe:jE]]B^UKKD[]Ffe:jE]]B^eKKD[YFfe:kE]]B^UKK77oo00<007ooOol01goo00<007ooOol0
3Woo001GOol2000WOol0CE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`02E;m04aBo5;m
D[YF^U:JE[YB^UJjD[YF^U:jE[YB^UJjD[YF^U:jE[YB^UJkD[YF^U:jE[]B^UJjD[YF^e:jE[YB^UJk
D[YF^e:jE[]B^UJkD[YF^e:jE[]B^eJkD[YF^e:kE[]B^UJkD[]Ffe:kE[]B^eKKD[]F^e:kE]]B^eJk
D[]Ffe:kE[]B^eKKD[]Ffe:kE]]B^eKKD[]Ffb5oo`03001oogoo00Moo`03001oogoo00ioo`00FGoo
00<007ooOol09Goo03m>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDkl
D_e>o5;mC_aBoDklD_e>o5JJDWT02E;m05M>o5;mC_aBoE:JE[YBVEJjDYYF^U:IE[YBVUJjDYYF^e:J
E[YBVUJjDYYF^U:JE[]B^UJjDYYF^e:jE[YB^UJkD[YF^e:jE[]B^UJkD[YFfe:jE[]B^UKKD[YF^e:j
E]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:j
E]]B^UKKD[YFfe:jE]]B^eKKD[X097oo00<007ooOol01Woo00<007ooOol03Woo001JOol00`00Oomo
o`0UOol0>E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE9HD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o002D_d025JIDYUFVU:IEYUBVEJJDYT2EYT04UJJDYUFVUJIEYYBVEJJDYYF^U:JE[YBVUJjDYYF^U:j
E[YBVP=F^P0ADYYF^UJjE[YB^UJjD[YF^U:jE[YB^UJkD[YF^U:jE[YB^P03E[X0;U:jE[YB^UJkD[YF
^U:jE[]B^UJkD[YF^e:jE[]F^UJkD[YF^e:kE[]B^UJkD[]F^e:jE[]B^eKKD[]F^e:kE]]B^UJkD[]F
fe:kE[]B^eKKD[]F^e:kE]]B^eKK9goo00<007ooOol01Goo00<007ooOol03Woo001KOol00`00Oomo
o`0UOol0:DklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>
o5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_`00e;m06a>o5;mC_aBoDklD_eBN5JIDWUFVE9hEYUB
NEJIDWQFVU:IEYYBNEJJDYUFVE:IEYYBVEJjDYUF^U:IE[YBVEJjDYYF^U:IE[YBVUJjDYUF^U:JE[YB
VUJjDYYF^U:JE[YBVUJjDYYF^e:jE[YBVUJkD[YF^e:jE[]B^UJkD[YF^e:jE[]B^UKKD[YF^e:jE]]B
^UJkD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B
^UKKD[YFfe:jE]/[Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool005aoo`03001oogoo02Eoo`0ID_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`02E;m0e9H00IBN59H
DUQBF59hDUP3DWT3EWP03EIiEWQFVE:IEYUBNEJIDYUFVE9iEYUBVEJJ00EFV@0@EYYFVEJJDYUFVUJI
EYYBVEJjDYYF^U:JE[YBVUJjEYX3E[X02e:JE[YF^UJjDYYF^U:jE[YB^UJjD[X01EJj00EB^UJjE[YF
^U:j009F^P06E[]B^UJjD[YF^e:j0UJj021F^e:jE[]F^UJkD[YF^eJjE[]B^UJkD[]F^e:jE[]F^UJk
D[YF^e:kE]]B^UJkD[]Ffe:jE[]B^eKKD[]F^e:k;Goo00<007ooOol017oo00<007ooOol03Woo001M
Ool2000WOol0SU;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mC_aBoDklD_e9e4hGCQI>5dWfESIB5EIG
DSMFEe8gEUMB=eIGDSMFEe9HEWQBF5IhDUQFN59HEWQBN5JIDWQFNE9hEYUBN5IiDWQFVE9iEYUBN5JI
DWUFVE9hEYYBVEJIDYUFVU:IEYUBVEJjDYUF^U:IE[YBVEJjDYUF^U:IE[YBVEJjDYUF^U:IE[YBVUJj
DYYF^U:JE[YBVUJjD[YF^U:JE[YB^UJjDYYF^U:jE[]B^UJkD[YF^e:jE[]B^UJkD[YFfe:jE[]B^UKK
D[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:j<goo00<0
07ooOol00goo00<007ooOol03Woo001OOol00`00Oomoo`0UOol01DEaAE55DDEAAG400dEA24WD14hF
00EF=U8fESIF=UIG00=BE`05EUMBEe9GDUMBN003DUP01E9hDUQFN5IhEWT00eIh00YFNEIhEWQFN5Ii
DWUFVE:IEYUBN@=FV@03EWUFVEJI00IFV@0@EYYFVEJJDYUFVUJIEYYFVEJjEYYF^UJJE[YFVUJjEYX3
E[X00e:JE[YF^P0=E[X00e:jE[YF^P04E[X01UJkD[YF^UJjE[]B^P9F^P06E[]B^UJkE[YF^e:j0UJj
00mF^e:jE[]F^UJkD[YF^eJjE[]B^UJkD[]Ffe:jE[/0=Woo00<007ooOol00goo00<007ooOol03Goo
001POol00`00Oomoo`0TOol0RDEAAG51D4EaAE55LD5@AG59]4gEBKA=eDVdCME9]4gEBKA>5e8EESIB
5EHfDQEF=U8gEUMB=eIGDSMFEe8gEUMB=eIhDUQFN5IGEWQBEeIhEUMFNE9hEYUBN5IiDWQFVE9hEWUB
N5JIDWUFVEIhEYUFN5JIDYUFVU:IEYUBVEJJDYUFVE:IE[YBVEJjDYUF^UJIE[YBVEJjDYUF^U:IE[YB
VEJjDYYF^U:JE[YBVEJjEYYF^U:IE[YB^UJjDYYF^U:jE[YBVUJkD[YF^e:jE[]B^UJjD[YF^e:jE[]B
^UKKD[YF^e:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[X0>7oo00<0
07ooOol00goo00<007ooOol03Goo001QOol00`00Oomoo`0SOol2AE401TEaAE55DDEAAG55D@U9e09F
=P08DSIF=UHfESIB=UHfDUMFE`=BE`03EUMBEe9G009FN005EUMFN5IhEWQFE`02EWP01EIiEWQFN5Ih
EWT00eIh00=FVEIiEYT00UJI00=FNEJIEYT035JI00AFVUJIEYUFV@9FVP06E[YFVUJjEYYF^UJJ75Jj
00IF^e:jE[YF^UJkD[X2E[X01EJkE[YF^UJjE[/00eJj00QF^e:jE[]F^UJkD[YF^eJj?7oo00<007oo
Ool00Woo00<007ooOol03Goo001ROol2000SOol0@T5@AG55DDEa@E15LDEAAG51D4gEBKA=eDVdCME9
]4gEEO=F=U8EESIB5EHfDQEF=U8EEUMB=eIGDSMFEe8gEUMFEUYgEUMFN59GEWQFEeIhDUMFN59hEWUB
N5JIDWQFNE9hFYUFN5JIEWQFVEIhEYUFN5JIEWQFVE:IEYYBVEJIDYUJV@9FV@0MDYUF^UJIE[YBVEJj
EYUF^U:IE[YBVEJjDYUF^UJIE[YBVEJjEYYF^U:IE[YFVUJjDYUF^U:jE[YBVP03E[X085:JE[]B^UJj
D[YF^e:jE[YB^UKKD[YF^e:jE]]B^UJkD[YFfe:jE]]B^UKKD[YFfe:jE]]B^UKKD[YFfe:jE]/oOol0
1@00Oomoogoo00003goo001TOol00`00Oomoo`0POol01DEaAE55DDEAAG400dEA00=5LDWDBM@014WD
0eHD0eHf00EB=UHfESIF=U8f009BE`03EUMBEe9G009FE`05EUIFN5IhEWQFE`03EWP015IGEWQFN5Ii
0eIh00=FV5IhEWP00UJI00EFNEJIEYUFVEIi00YFV@05EYYFVEJIEYUFVP03EYT025JjEYYF^UJIE[YF
VEJjEYTTE[X01EJkE[YF^UJjE[/00UJjAGoo00@007ooOol000moo`00IGoo00<007ooOol07goo03]5
DDEa@E15LDEAAG51D4EaAE5=eDVdCME9]4gEBKAJ55GdEQAB5EHfDQEF=U8EESIB5EHfDSMFEe8gFUMF
EUYgEUIJEeIFEWQFEeIhDUMFN5IGEWQBEeJIDWQJV5IhFYUFN5ZHEWQJVEIhEYUFN5JIEWQFVEIh00AF
V@0PFYUFVEJIEYUJVEJIE[YBVEJjEYUF^U:IE[YFVEJjEYUF^UJIE[YFVEJjEYUF^U:IE[YFVUJjDYUF
^UJJE[YBVP=F^P0:DYYF^UJjE[YB^UJkD[YF^U:jE[/2E[X03e:jE]]B^UJkD[YFfe:jE[]B^UKKD[YF
fe:jE]]B^P17Ool01000Oomoo`003goo001VOol00`00Oomoo`0NOol2AE401DEaAE55DDEAAG400TEA
1DWD15HD00=F=U8fESH00UHf00EB=UHfESIF=U9G00=FE`03EUIFEeIG009FE`=FN003EUMFN5Ih00AF
N006EYQFN5IhEWQFV5Ih0eJI00EFNEJIEYUFVEJH00YFV@05EYYFVEJIEYUFVP03EYT025JjEYUF^UJI
E[YFVEJjEYTTE[X00eJkOomoo`18Ool00`00Ool0000?Ool006Moo`8001ioo`0n@E15LDEAAG51D4Ea
AE55LD5@CME9]4gEBKAJ55GdEQAEleXDDQEF=U8EESIB5EHfDQEF=U8EFUMFEUYgEUIJEeIFFWMFEUYG
DUMFN5IGEWQBEeIhEWMJN5IhFYUFN5ZHEWQJVEIhFYQFN5JIEWQFVEIhFYUFN5ZIEWQJV@=FV@0PFYUF
VEJIEYUJVEJIE[YBVEZjEYUF^EJIF[YFVEJjEYUF^UJIE[YFVEJjEYUF^UJIE[YFVEJjEYUF^UJIE[YB
VP=F^P05DYYF^UJjE[YB^P03E[X035:jE[YF^UJjD[YFfe:jE[]B^UKKD[YF^dioo`03001oo`0000io
o`00JGoo00<007ooOol06goo00E5LDEAAE55DDEa00=5D@04AG59e4WDBM@7EQ@2ESH01U8fESIF=UHf
DSIJ=@9FE`05EUIFEeIGEUMFEP02EUL02EIhEUMFN5IhFWQFMeYgEWMFV003EWP01UJHEWQFN5IhEYQF
N@=FV@05EYQFVEJHEYUFV00:EYT01EJiEYUFVEJIE[T00eJI00QF^UJIE[YFVEJjEYUF^EJI7UJjDGoo
0P003Woo001ZOol00`00Oomoo`0JOol0@4EAAG51D4EaAE55LD5@AG55DDEaBKA=eEGdEQAEleXDEOAF
55GcESIB5EHfDQEF=U8EFUIF=EYFEUIJEeIFFWMFEUYGEUIJMeIFEWQBEeYhEWMJN5IGFWQFMeZHEWQJ
VEIhFYQFN5ZIEWQJV5IhFYUFN5ZIEWQJVEIhFYUFN5ZI0eJI01aJVEJHFYUFV5ZjEYUF^EJIF[YFVEJi
EYUF^UJIE[YFVEZjEYUF^UJIF[YFVEJjEYUF^UJIE[YFV@=F^P05DYYF^UJjE[YFV@03E[X01E:jE[YF
^UJjD[X00eJjEGoo0P003Woo001[Ool00`00Oomoo`0IOol2AE401DEaAE55DDEAAG400dEA00=9e5HD
EQ@01UHD00EB=UHfESIF=U8f009J=@03FUEJ=EIG009FE`0@EUIFEeIGEUMFEUIGEWMJN5IgFWMFMeYh
EWMJMeIhEYP3EWP035JHEWQFN5YhFYQFV5JIEYQFVEJHEYUFV0AFV@05FYUFVEJIEYUJV@03EYT03eJi
EYUFVEJIE[UFVEJiEYUF^UJIE[UFVEJjEYUF^@0GE[YGOol2000>Ool006aoo`8001Uoo`1R@E15LDEA
AG51D4EaAE55LD5@AG5Em5HDEO=J55GdEQAEleXDEOAF=U8EESIB5EYFESEJEUXeFUIFEUYgEUIJEeIF
FWMFEUYGFUINMeIgFWQFEeYhEWMJN5IGFWQFN5ZHEWQJVEIhFYQFMeZHEWQJVEIhFYUFN5ZIEWQJVEIh
FYUFV5ZiEYQJVEJHF[UFV5ZIEYUJ^UJIE[UFVEZjEYUJ^EJIF[YFVEJjEYUJ^UJIE[YFVEJjEYUF^UJI
E[YFVEJjEYUJ^P9F^P05EYUF^UJjE[YFV@03E[X00e:jE[Yoo`1DOol4000@Ool006ioo`03001oogoo
01Ioo`05AG55DDEAAE55L@03AE400dEaAE5F5009EQ@01EHfDSIJ=EXeFUD00eXe00=JEEIFEUL00UIG
00eFEUIGFUIJMUYFFWMFMeYhEWMJMeIgFWQFM`02EWP03eJHEWQJV5YhFYQFN5ZHFWQFVEJHEYUFV5JI
EYQFV@02FYP3EYT01EZIEYUFVEJIFYT00eJI00iF^EJIEYUFVEZiEYUF^EJIE[YFVEJiEYUF^UJI0eJj
00EF^EJjE[UF^UJi00UF^UAoo`@001Aoo`00Kgoo00<007ooOol05Goo06=5DDEa@E15LDEAAG51D4Ea
AE55LEGcFQAEm5HDEO=J55GdEQAEleXDDQEJEUHeFUIJ=EYFESEJEUXeFUMFEUYgEUIJEeYFGWMJEUYg
FUIJN5IgFWQFEeYhEWMJN5IGFYQFN5ZHEWMJV5IhFYQFMeZHEWQJVEIhFYUFN5ZIEWQJVEJHFYUFV5Zi
EYQJVEJHF[UFV5JiEYUJ^UJIF[UFVEZiEYUJ^EJIF[YFVEJjEYUJ^UJIE[YFVEZjEYUF^UJIF[YFVEJj
EYT00eJj00=FVEJjE[X0DWoo100067oo001`Ool00`00Oomoo`0COol3AE401DEaAE55DDEAAG400dEA
2UHD0UXe00EJEEXeFSEJ=EYE009J=@9FE`04EUIJEUYFFWH3FUH025YfEWMJMeIgFWQFMeYgEWL2FWL0
35ZHFWQJV5IhFYQJN5ZHEWQJV5JHEYUFV0=JV004EYQJV5ZHFYT3EYT01EZIEYUFVEJIF[T00eJI00YJ
^EJIEYUFVEZiEYUF^EJIE[YFV@9F^@08F[UF^EJjE[UF^UJiE[YF^@EF^U1oo`@001aoo`00LGoo0P00
4goo02m5LD5@AG55DDEa@E15LDEAAG51D4EaFO5F55GcFQAEm5HDEO=J55GdEQAF=EYFFSEJEUHeFUIJ
=EYFESEJEUIFFWMJEUigFUIJMeYFGWMJEUYgEUMJN5IgFWQFEejG009JM`0dEWMJV5IhFYQFMeZHEWQJ
V5IgFYUFV5ZIEWQJVEJHFYUFN5ZIEYQJVEJHF[UFV5ZIEYQJ^EJHF[UFVEZiEYUJ^EJIF[UFVEJjEYUJ
^UJIF[YFVEZjEYUJ^UJIF[YFVEJjEYUJ^UJIE[Y?Ool4000POol007=oo`03001oogoo011oo`03AE55
LDEA0095D@05AG55DDEAAE55L@02GO48EQ@00ehcGSAJ=@02FSD01UYEFSEJ=EXeFUEJ=@9JEP05FWIJ
EUYFFUIJMP03FUH00eYhEWMJM`06FWL02EIhFYQJN5ZHEWQJV5YhFYQJM`03FYP02EJHFYQJV5ZHEYQJ
V5JIFYUFV@03FYT015JHFYUFVEZi0eJI00IJ^EJIEYUFVEZiEYT2E[T02UZiEYUF^EJiE[YF^EJjE[UF
^UJiCWoo0`0097oo001dOol00`00Oomoo`0?Ool0;DEaAE55LD5@AG55DDEa@E15LDEAGQ9IlEXDEOAF
55GcFQAEm5HDEO=N=5hcFUIF=EYFFSEJEUHeFUIJ=EiEFUINMeYFFWMJEUigFUIJMeYFGWMJEUYhFWMN
U`03FWL0<EjGFWMJV5IgFYQFN5ZHEWMNV5YgFYQFN5ZIEYQJVEIhFYUFV5ZIEWQJ^EJHFYUFV5ZiEYQJ
VEJHF[UFVEZiEYUJ^EJIF[UFV5ZiEYUJ^UJIF[YFVEZjEYUJ^UJIE[YFVEZj04aoo`@002Moo`00MGoo
00<007ooOol03Woo0dEA00E5LDEAAE55DDEa0095D@9Ml@MF5005GSAN<ehcFSEJE@03FSD00eYEFSEJ
=@02GUD3FUH01EYfFUIJEUYFFWH00UYF2EYg00YJV5IhFYQJN5ZHFWMJV5YhFYQFV0=JV003EYQJV5ZH
009JV0=JV@05EYQJVEZIFYUFV002EYT02UZiEYUJVEZIF[UFVEZIE[UJ^EJI0UJi00AJ^EJIE[UF^DYo
o`@002]oo`00MWoo0P003Woo01i5LD5@AG55DDEa@E15LDEAAG51D5hBFO5F55GcFQAEm5HDEO=J55hc
GSAJ4ehdFSEJEUHeFUIJ=EYFFU@2GUD02eYgFUINMeYFFWMJEUigFUIJMeYEGYL00eYg01ANUeYgFWMJ
MejGEWQJV5YgGYQJMeZHFWMNV5YgFYQFN5ZIEYQJVEYh0eZH01QFV5ZiEYQJVEJHF[UFV5ZIEYQJ^EJI
F[UFV5ZiEYUJ^EJHF[UFVEZjEYUJ^UJIF[Y8Ool4000_Ool007Qoo`03001oogoo00]oo`03AE55LDEA
0095D@05AG55DDEAAE55L@02GO46EQ@3GS<01EhdGS=J=EXeFUD00UXe1EiE00EJMUYFFUIJEUYf009J
EP9NMP03GUIJMeYg00MJM`0;FWQJV5YgFYQJN5ZHFWMJV5YhFYQFV007FYP01EJHFYUJVEZIEYP00eZI
00EJV5ZIFYUJ^EJI009JV@06F[UFVEJiE[UJ^EJIAWoo1000<goo001iOol00`00Oomoo`0:Ool074Ea
AE55LD5@AG55DDEa@E15LDEAGQ9IlEhBEOAF55GcFQAEm5hdFQ=N=5hcGSAJ4eYFFSEJEUHe0eiE00iJ
E5iEFUIJMeYFGWMJEUYgFUENMUYFGWIJMejG0eYg011NUeYgFWMJMUjHFWMJV5YgGYQJMeZHFWMNV5Yg
FYQJN0=JV00EFWQJV5ZHFYQFV5ZiEYQJVEJHF[UJV5ZIEYQJ^EJIF[UFV5ZiEYUJ^EJH04Ioo`<003Mo
o`00NWoo00<007ooOol02Goo0dEA00E5LDEAAE55DDEa0095D@=Ml@EF5003GS=N=5hc009N<`04GSAJ
=EXeFSD7GUD015YFFWIJEUYF0Uif00ANEUifGWINMPIJM`9NM`0:FWMJV5YhFYQJMeZHFWQJV5YgFYL9
FYP01EZIEYQJVEZHFYT00eZH00IJVEJIFYUJVEZiEYT2FYU3Ool4000jOol007]oo`03001oogoo00Qo
o`0JAG51D4EaAE55LD5@AG55DDEa@E1N4UWaGQ9EleXDEOAF55XCGSAN<ehdFQ=N=5hcFUIF=@=NE@0?
FUANEEiEGUEJE5igFUIJMeYEGWIJEUifFUENMUYF009JM`0AGYMJMeYgFWINUeYfGYMJMejHFWMJV5Yg
GYQJMejHFWMNV002FYP01EYhFYQJV5ZHFWP00UZH00eJVEJHF[UJV5ZIEYQJ^EZHFYUFV5ZiEYUJ^@11
Ool4000nOol007aoo`8000Qoo`03AE55LDEA0095D@04AG55DDEAAE44GO44EQ@01EhdGS=N<ehcGS@0
0ehc00=JEEiEGUD01eiE00AJEUifGWINEP=NMP03GUINMUYg009JM`=NM`09FWMNMeigGWMJMeZHFWQJ
V5Yg009JU`03GYQJMeZH00UJV005FYUJV5ZHFYQJV@03FYP00eZiEYUJV@0nOol40012Ool007ioo`03
001oogoo00Eoo`0IAG55DDEa@E15LDEAAG51D4EaFO5N4UWaGQ9Em5HDEO=N=5hcGSAJ4ehdGS=N=5XC
GS@00UiE00EJE5iEGUENEEYD00=NE@0MFUENMUYFGWIJEEifFUINMUYEGWIJMejGFWINUeYfGYMJMUjG
FWIJV5YgGYQJMejHFWMNV5YgGYQJM`03FYP03eYhFYQJUejHFYMNV5ZHFYUFV5ZiFYQJVEJHF[UJV00l
Ool40016Ool007moo`03001oogoo00Aoo`=5D@06AG55DDEAAE55LDEA15ga0eHD0ehc00IN=5hcGS=N
<ehdGS<9GUD00f9DGWINEP03GWH01EiFGWINMUifGUH00eig00EJMeigGWMNMeYg009NM`06FYQJMeZG
FYMNV5Yg0UZG00=NV5ZHFYP02EZH00IJVEZHFYQJV5ZIFYPiOol4001:Ool0081oo`03001oogoo00Yo
o`0CAE55LEWaGQ9IlEhBFO5J55hcGSAJ4ehdGS=N=5XCGSAN<f9CHS<00eiE039JE5iEGUENEEYDHWEN
E5ifFUENMUYFGWIJEEifFUIRMUiEGYMJMUjGFWINUeYfGYMJMUjGFWMNV5YgGYQJMejHFWMNV5YgGYQJ
N5ZHFYMNV5ZGGYQJUejHFYMJ^EZHFYUFV5Zi>7oo0`00CWoo0021Ool2000<Ool5GO4015HDGS=N<ehd
0ehc00=N=5hcGS<00V9C1eiE00=REEiDHUD00Uif00ENEUifGWINMUiF00=NMP05FWMNMeigGWMJM`03
GWL2GWH00eZGGYQJM`02FYL015jHFWMJUeZG35ZH=Woo1000DGoo0023Ool00`00Oomoo`0;Ool04EWa
GQ9IlEhdFQ=N=5hcGSAJ4ehdGS=N=5XCHU=R<eiEFU@00eiE02aJE5iEGUARMEiDHWEJEUifFUENMUYF
GWINEF9fGWERMUYfGYMJMUjGFWINUeifGYMNMUjHFWMNV5YgGYQJMejHFWMNV5YgGYQJUejHFYMNV5ZG
GYQJUejH=7oo1000EGoo0024Ool00`00Oomoo`0<Ool00egaIS5N=003GS<01ehdGS=N<ehcHU=R<f9C
00INE@05GUAREF9DHUENE003GWH01EiFGWINMUifGWD00Uif00=NMeYgGWL00Uig0eif00INUeifFYMJ
UejHFWL2FYL3GYL8FYPaOol4001IOol008Eoo`03001oogoo00aoo`0=IS5N<ehdFQ=N=5hcGSAJ4ehd
HS=RDf8cHU<00UiE02aJE5iEGUERMEiDHWENE69eGUANMUYFGWINEF9fGWERMUiEHWINMEjGFWINUeif
GYMNMUjGGWINUeYgGYQJMejHFWMNV5YgGYMJMejHFYMNV5ZGGYQJUejH;Woo1000GGoo0026Ool2000A
Ool2GS<00ehdHS=RD`02HU<00f8cGUENE@02GUD0269EHUAREEiDHUERE69EGUH3GWH01UieGWINMUif
GWENMP9NM`=NMP06GYMNMUifGWINUeYg0UZG1ejG0eZH;Goo0`00HGoo0028Ool00`00Oomoo`0AOol0
1V9CHS=RDf8cHU=JE0=NE@0WGUARMEiDHWENE69eGUARMEYEHWINMF9fGUERMUieHWINEF9fGWINUeif
GYMNMUjGGWINUeifGYQJMejHFWMNUeYgGYQJMejGFWMNV5ZG02Yoo`@006Aoo`00RGoo00<007ooOol0
4Woo00=R<f9CHU<00eiE00]RE69EGUAREF9DHUENE69EHUANMUie00=NMP05GWENMUifGWIRM@02GWH0
1EjGGWINMUifGYL00eif2UjG9goo1000J7oo002:Ool00`00Oomoo`0COol0:V9CHS=NEEYDHWENE69e
GUARMEiDHWENE69eGWERMUiEHWINMF9fGUERMUieHWINMEjGGWINUeifGYMNMUjGGWIRUeYgGYMJMejH
FWMNUeYgGYQJMbAoo`@006aoo`00Rgoo0P005Goo00aNEF9EGUAREF9DHUENE69EHUAREF9DHW@2GWH0
1EieGWINMUifGWD00f9e0eif00MNUeifGWINMV:FGWINUP07GYLQOol4001`Ool008eoo`03001oogoo
01Aoo`0T001oogooGUARMEiDHWENE6IdHUARMUieHWINEF9fGWERMUieHYINMF9fGWINUeifGYMNMV:G
GWIRUUifGYQJMejGFWMNV5Yg7Woo1000M7oo002>Ool00`00Oomoo`0COol00`00Oomoo`04Ool3HW@0
1F9DGWINMUifGWD01V9e00YNUeifGWINMV:FGWINUUifHYINMPANUaaoo`<007Qoo`00Sgoo00<007oo
Ool04Woo00<007ooOol027oo01MNEF9fGWERMUieHYINMF9fGWERUUifGYMNMV:GGWIRUUifHYMNMV:F
FWMNV5Yg01Uoo`@007]oo`00T7oo0P004Goo00<007ooOol02goo00=NMV9eHWD01V9e00]NMV:FGWIN
UUifHYINMUjFGWIRUUjG01Ioo`@007moo`00TWoo00<007ooOol03Woo00<007ooOol047oo00iRUUie
HWINMF9eGWIRUUifHYMNMV:FGWIRUeif4goo1000Pgoo002COol00`00Oomoo`0=Ool00`00Oomoo`0D
Ool02F9eGYINMV:FGWINUUifHYINMP0@Ool40027Ool009Aoo`03001oogoo00aoo`03001oogoo01Eo
o`08GWIRUeifHYINMV:GGWIRUPaoo`@008]oo`00UGoo00<007ooOol02goo00<007ooOol06Goo00=R
UUifGYH02Woo0`00Sgoo002FOol2000;Ool00`00Oomoo`0ROol4002BOol009Qoo`03001oogoo00Qo
o`03001oogoo01ioo`@009Ioo`00VGoo00<007ooOol01goo00<007ooOol06Woo1000VWoo002JOol0
0`00Oomoo`06Ool00`00Oomoo`0FOol4002NOol009]oo`8000Ioo`03001oogoo01=oo`<00:9oo`00
WGoo00<007ooOol00goo00<007ooOol03goo1000YGoo002NOol00`00Oomoo`02Ool00`00Oomoo`0;
Ool4002YOol009moo`05001oogooOol00009Ool4002]Ool00:1oo`800003Ool007oo00Aoo`@00;5o
o`00XWoo0P0000=oo`0000000P00]Goo002SOol2002iOol00?mooemoo`00ogooGgoo003oOomOOol0
0?mooemoo`00ogooGgoo003oOomOOol00?mooemoo`00ogooGgoo0000\
\>"],
  ImageRangeCache->{{{0, 349}, {253.375, 0}} -> {-0.163235, 0.0234258, \
0.00415677, 0.00415677}}],

Cell[TextData[{
  StyleBox["Figure 4.1.",
    FontFamily->"B Times Bold"],
  "  Intersection of the two integrals for ",
  StyleBox["c",
    FontSlant->"Italic"],
  "1 = ",
  StyleBox["c",
    FontSlant->"Italic"],
  "2 = ",
  Cell[BoxData[
      \(TraditionalForm\`1\)]],
  ". The parameters \[Alpha] and \[Beta] take the values ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 1/10\)]],
  " and \[Beta]=1. The intersecting line represents the solution of the \
equation if we project the intersection to the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane."
}], "SmallText",
  TextJustification->1],

Cell[TextData[{
  "Since we know two first integrals, we are able to eliminate the \
derivatives from the two integrals analytically. We solve the first relation \
with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  ":"
}], "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ 
      Solve[integrals\[LeftDoubleBracket]1\[RightDoubleBracket], 
          \(u'\)[x]] // Simplify\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          \(\(\(-1\) + E\^\(\[Alpha]\ \((\(-c1\)\ \[Beta] + u[x])\)\)\)\/\(x\ 
                \[Alpha]\)\)}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Substituting this result into both integral expressions \
delivers\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(int21\  = \ 
      \(integrals\  /. sol1\[LeftDoubleBracket]1, 1\[RightDoubleBracket] // 
          PowerExpand\) // Simplify\)], "Input"],

Cell[BoxData[
    \({True, 
      \(1 - E\^\(c1\ \[Alpha]\ \[Beta] - \[Alpha]\ u[x]\)\)\/\(x\ 
            \[Alpha]\) == c2}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting list contains the identity and an implicit representation of \
the solution. The explicit solution follows from the second relation if we \
solve it with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ":"
}], "Text",
  CellTags->"implicit representation of a solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution\  = \ 
      Solve[int21\[LeftDoubleBracket]2\[RightDoubleBracket], u[x]]\)], "Input"],

Cell[BoxData[
    \({{u[x] \[Rule] 
          \(-\(\(\(-c1\)\ \[Alpha]\ \[Beta] + 
                  Log[x\ \((\(-c2\) + 1\/\(x\ \[Alpha]\))\)\ \[Alpha]]
                    \)\/\[Alpha]\)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The constants ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          FormBox["c",
            "TraditionalForm"], "1"], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_2\)]],
  " denote constants of integration. \[Alpha] and \[Beta] are the model \
parameter and the introduced group parameter, respectively. The occurrence of \
the group parameter \[Beta] as a multiplier reminds us of the fact that the \
additive integration constant ",
  Cell[BoxData[
      \(TraditionalForm\`c\_1\)]],
  " is related to the group of translations."
}], "Text",
  CellTags->"translation"],

Cell[TextData[{
  "The solution steps so far discussed are collected in the ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " function ",
  StyleBox["SecondOrderIntegrate[]", "MmaText"],
  ". The application of this function to a second-order ODE is similar to the \
use of ",
  StyleBox["DSolve[]", "MmaText"],
  ". The function needs the equation under discussion, the dependent and \
independent variables, and the parameters contained in the ODE. The example \
discussed above is solved by"
}], "Text",
  CellTags->{"SecondOrderIntegrate[]", "second-order ODE", "DSolve[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(sol\  = \ SecondOrderIntegrate[firstExample, u, \ x, {\[Alpha]}]\ 
    \)\)], "Input"],

Cell[BoxData[
    \({u \[Rule] Function[x, \(-\(Log[\(-x\)\ CI[1] - CI[2]]\/\[Alpha]\)\)]}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  StyleBox["CI\[ThinSpace]",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  StyleBox["]",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " and ",
  StyleBox["CI\[ThinSpace]",
    FontSlant->"Italic"],
  "[",
  StyleBox["2",
    FontSlant->"Italic"],
  "] are constants of integration. The solution obtained looks different in \
comparison with the solution presented above. However, the extraction of the \
multiplier ",
  StyleBox["CI\[ThinSpace]",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] and a rescaling of ",
  StyleBox["CI\[ThinSpace]",
    FontSlant->"Italic"],
  "[",
  StyleBox["2",
    FontSlant->"Italic"],
  "] will create the same representation of the solution. The same solution \
as found by the manual calculation is derived by the function ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[firstExample == 0, u, x]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] \((C[2] - Log[#1\ \[Alpha] - C[1]]\/\[Alpha]&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Again, a constant is extracted from the argument of the logarithm. This \
example shows that the solution steps of Lie\[CloseCurlyQuote]s method of \
first integrals result in the same solution as that of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\[ThickSpace]\[EmptySquare]"
}], "Text",
  CellTags->"Lie's method of first integrals"],

Cell["Example 2", "Example"],

Cell["\<\
The second example for a second-order ODE is related to the problem \
of a suspended cable equation:\
\>", "Text",
  CellTags->"generalized suspended cable equation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_\(x, x\)\  - \ \[Alpha]\ \((1\  - u\_x\%2)\)\^\(1/2\)\  = 0. \)], 
  "NumberedEquation"],

Cell[TextData[{
  "The problem of the suspended cable is discussed by ",
  ButtonBox["Ames [1968]",
    ButtonData:>"Ames-68",
    ButtonStyle->"Hyperlink"],
  ". We examine here a generalization of the cable equation by introducing an \
arbitrary power \[Nu] in the second term of the ODE:"
}], "Text",
  CellTags->"suspended cable"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_\(x, x\)\  - \ \[Alpha]\ \(\((1\  - u\_x\%2)\)\^\[Vee]\)\  = 0. \)], 
  "NumberedEquation"],

Cell[TextData[{
  "The original model follows from our model with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu] = 1/2\)]],
  ". The present problem is similar to the first example we discussed. The \
difference is that we added \[Alpha] to the square of the derivative and \
raised the second term to the \[Nu]th power. These small changes lead to \
substantial variations in the solution:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(secondExample\  = \ 
      \[PartialD]\_\(x, x\)u[x]\  - 
          \[Alpha] \((1 + \ \((\[PartialD]\_x u[x])\)\^2)\)\^\[Nu]\  == 0; 
    secondExample // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-\[Alpha]\)\ \((1 + u\_x\%2)\)\^\[Nu] + u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"In applying Lie\[CloseCurlyQuote]s algorithm to this equation, we first \
calculate the point symmetries of this equation for arbitrary \[Nu]. "], 
  "Text",
  CellTags->{"Lie's integration algorithm", "point symmetries"}],

Cell[TextData[{
  "The infinitesimals follow by applying the ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  " to the equation:"
}], "Text",
  CellTags->{"infinitesimals", "Infinitesimals[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      Infinitesimals[secondExample, u, x, {\[Alpha], \[Nu]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{x, 2}u[x]}]; infi // LTF\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k1\)},
          {\(\[Xi]\_1 == k2\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], k1], 
        Equal[ 
          Subscript[ \[Xi], 1], k2]}]]], "Output"]
}, Open  ]],

Cell["\<\
The result is a two-dimensional symmetry transformation which \
itself is solvable. The symmetries represent translations in the independent \
and dependent variables. The first difference in comparison to Example 1 is \
that the group is smaller. This reduction of the group order has consequences \
with regard to the solutions.\
\>", "Text",
  PageWidth->PaperWidth,
  ShowCellBracket->False,
  CellMargins->{{Inherited, 0}, {Inherited, Inherited}}],

Cell[TextData[{
  "The two subgroups necessary for integration are derived by independently \
setting each of the group parameters ",
  StyleBox["k1 ",
    FontSlant->"Italic"],
  "or ",
  StyleBox["k2",
    FontSlant->"Italic"],
  " to unity. Since the symmetry group is two dimensional, we know from Lie \
that the algebra is always solvable. In the worst case, the solution may in \
the end be represented by an implicit representation. The infinitesimals for \
the two subgroups follow from"
}], "Text",
  CellTags->{"solvable", "infinitesimals"}],

Cell[BoxData[
    \(\(inf1\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\) /. {
            k1 \[Rule] 1, k2 \[Rule] 0}\)\  /. u \[Rule] u[x]; \)\)], "Input"],

Cell[BoxData[
    \(\(inf2\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\) /. {
            k1 \[Rule] 0, k2 \[Rule] 1}\)\  /. u \[Rule] u[x]; \)\)], "Input"],

Cell[TextData[{
  "So far, we put no restrictions on the exponent \[Nu]. The following \
derivation of the solution however assumes a specific value for \[Nu]. We \
arbitrarily choose ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu] = 3\)]],
  ". The related Lie matrix for this case is calculated by"
}], "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalDelta]matrix = 
      DeltaMatrix[x, u, 
        \[Alpha] \((1 + \ \((\[PartialD]\_x u[x])\)\^2)\)\^3\ , 
        2, {inf1, inf2}]; 
    TableForm[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"0", "1", "0"},
          {"1", "0", "0"},
          {"1", \(u\_x\), \(\[Alpha]\ \((1 + u\_x\%2)\)\^3\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The determinant of this matrix is given by a polynomial of sixth order in \
",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  ":"
}], "Text",
  CellTags->"determinant"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(-\[Alpha]\) - 3\ \[Alpha]\ u\_x\%2 - 3\ \[Alpha]\ u\_x\%4 - 
      \[Alpha]\ u\_x\%6\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The first integrals for the generalized cable equation with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu] = 3\)]],
  " follow from"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integrals\  = \ 
      Thread[FirstIntegral[x, u, \[CapitalDelta]matrix, {1, 2}] == 
          \ {c1, c2}]; \(integrals // LieTraditionalForm\) // TableForm\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{"u", "+", 
                StyleBox[\(1\/\(4\ \[Alpha]\ \((1 + u\_x\%2)\)\^2\)\),
                  ScriptLevel->0]}], "==", "c1"}]},
          {
            RowBox[{
              RowBox[{"x", "-", 
                StyleBox[\(\(3\ ArcTan[u\_x]\)\/\(8\ \[Alpha]\)\),
                  ScriptLevel->0], "-", 
                StyleBox[\(u\_x\/\(4\ \[Alpha]\ \((1 + u\_x\%2)\)\^2\)\),
                  ScriptLevel->0], "-", 
                StyleBox[\(\(3\ u\_x\)\/\(8\ \[Alpha]\ \((1 + u\_x\%2)\)\)\),
                  ScriptLevel->0]}], "==", "c2"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ u, 
            Times[ 
              Rational[ 1, 4], 
              Power[ \[Alpha], -1], 
              Power[ 
                Plus[ 1, 
                  Power[ 
                    Subscript[ u, x], 2]], -2]]], c1], 
        Equal[ 
          Plus[ x, 
            Times[ 
              Rational[ -3, 8], 
              Power[ \[Alpha], -1], 
              ArcTan[ 
                Subscript[ u, x]]], 
            Times[ 
              Rational[ -1, 4], 
              Power[ \[Alpha], -1], 
              Subscript[ u, x], 
              Power[ 
                Plus[ 1, 
                  Power[ 
                    Subscript[ u, x], 2]], -2]], 
            Times[ 
              Rational[ -3, 8], 
              Power[ \[Alpha], -1], 
              Subscript[ u, x], 
              Power[ 
                Plus[ 1, 
                  Power[ 
                    Subscript[ u, x], 2]], -1]]], c2]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Solving the first relation with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  " allows us to eliminate this term in the second integral:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ 
      Solve[integrals\[LeftDoubleBracket]1\[RightDoubleBracket], 
          \(u'\)[x]] // Simplify\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(-\@\(\(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                      2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\)\)\)}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(\@\(\(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                      2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\)\)\)}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(-\(\@\(\(\(-2\)\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] + 
                          2\ u[x]\)\/\(c1 - u[x]\)\)\/\@2\)\)}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(\@\(\(\(-2\)\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] + 
                        2\ u[x]\)\/\(c1 - u[x]\)\)\/\@2\)}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution for ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  " consists of four expressions containing square roots of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The differences in the four solutions are the signs in front of the \
first and second terms. Inserting, for example, the second solution into the \
second first integral, we get the final solution in an implicit \
representation:"
}], "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(int21\  = \ 
      integrals\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. 
        sol1\[LeftDoubleBracket]2, 1\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \(x - 
        \(3\ ArcTan[
              \@\(\(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                      2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\)\)]\)\/\(8\ 
            \[Alpha]\) - 
        \@\(\(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 2\ u[x]\)\/\(\(-2\)\ c1 + 
                  2\ u[x]\)\)\/\(4\ \[Alpha]\ 
            \((1 + \(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                      2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\))\)\^2\) - 
        \(3\ \@\(\(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                    2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\)\)\)\/\(8\ \[Alpha]\ 
            \((1 + \(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                    2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\))\)\) == c2\)], 
  "Output"]
}, Open  ]],

Cell["\<\
An explicit solution of this expression is impossible since it \
contains transcendental functions:\
\>", "Text",
  CellTags->"transcendental function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution\  = \ Solve[int21, u[x]]\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Message"],

Cell[BoxData[
    \(Solve[
      x - \(3\ ArcTan[
                \@\(\(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                        2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\)\)]\)\/\(8\ 
              \[Alpha]\) - 
          \@\(\(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                    2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\)\)\/\(4\ \[Alpha]\ 
              \((1 + \(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                        2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\))\)\^2\) - 
          \(3\ \@\(\(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                      2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\)\)\)\/\(8\ \[Alpha]\ 
              \((1 + \(2\ c1 + \@\(c1 - u[x]\)\/\@\[Alpha] - 
                      2\ u[x]\)\/\(\(-2\)\ c1 + 2\ u[x]\))\)\) == c2, u[x]]
      \)], "Output"]
}, Open  ]],

Cell["\<\
At this point, we have to accept that the solution can only be \
represented in an implicit form. The solution of the original equation \
follows in one shot by\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(sol\  = \ 
      SecondOrderIntegrate[secondExample\  /. \[Nu] \[Rule] 3, u, \ 
        x, {\[Alpha]}]\ \)\)], "Input",
  CellTags->"SecondOrderIntegrate[]"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the  \
variables in an essentially non-algebraic way."\)], "Message"],

Cell[BoxData[
    \(\(1\/\(8\ \[Alpha]\)\) 
        \((8\ x\ \[Alpha] + 
            3\ ArcTan[
                \@\(\(2\ CI[1] + \@\(CI[1] - u[x]\)\/\@\[Alpha] - 
                        2\ u[x]\)\/\(\(-2\)\ CI[1] + 2\ u[x]\)\)] + 
            4\ \[Alpha]\ CI[1]\ 
              \@\(\(4\ CI[1] + \(2\ \@\(CI[1] - u[x]\)\)\/\@\[Alpha] - 
                      4\ u[x]\)\/\(\(-CI[1]\) + u[x]\)\) - 
            4\ \[Alpha]\ u[x]\ 
              \@\(\(4\ CI[1] + \(2\ \@\(CI[1] - u[x]\)\)\/\@\[Alpha] - 
                      4\ u[x]\)\/\(\(-CI[1]\) + u[x]\)\) - 
            3\ \@2\ \@\[Alpha]\ \@\(CI[1] - u[x]\)\ 
              \@\(\(2\ CI[1] + \@\(CI[1] - u[x]\)\/\@\[Alpha] - 
                      2\ u[x]\)\/\(\(-CI[1]\) + u[x]\)\))\) == CI[2]\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an implicit representation of the solution. ",
  StyleBox["CI\[ThinSpace]",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] and ",
  StyleBox["CI\[ThinSpace]",
    FontSlant->"Italic"],
  "[",
  StyleBox["2",
    FontSlant->"Italic"],
  "] are the constants of integration. Trying to solve the original equation \
by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we learn that ",
  StyleBox["DSolve[]", "InlineFormula"],
  " is not capable of resolving the relation for the first integral. A glance \
at the result of ",
  StyleBox["DSolve[]", "MmaText"],
  " explains the reason:"
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[secondExample\  /. \ \[Nu] \[Rule] 3, u, x]\)], "Input"],

Cell[BoxData[
    \(Solve::"dinv" \( : \ \) 
      "The expression \!\(\((1 - \(I\\ \(\(\\[LeftSkeleton] 30 \
\\[RightSkeleton]\)[x]\)\))\)\^\(\(\(\\[LeftSkeleton] 30 \
\\[RightSkeleton]\)[x]\)\^2\\ \((2 + \(\\[LeftSkeleton] 1 \\[RightSkeleton]\)\
\^2)\)\)\) involves unknowns in more than one argument, so inverse functions \
cannot be used."\)], "Message"],

Cell[BoxData[
    \(Solve::"dinv" \( : \ \) 
      "The expression \!\(\((1 - \(I\\ \(\(\\[LeftSkeleton] 30 \
\\[RightSkeleton]\)[x]\)\))\)\^\(\(\(\\[LeftSkeleton] 30 \
\\[RightSkeleton]\)[x]\)\^2\\ \((2 + \(\\[LeftSkeleton] 1 \\[RightSkeleton]\)\
\^2)\)\)\) involves unknowns in more than one argument, so inverse functions \
cannot be used."\)], "Message"],

Cell[BoxData[
    RowBox[{
    \(Solve::"dinv"\), \( : \ \), 
      "\<\"The expression \\!\\(\\((1 - \\(I\\\\ \
\\(\\(\\*SuperscriptBox[\\\"u\\\", \\\"\\\\[Prime]\\\", \
Rule[MultilineFunction, \
None]]\\)[x]\\)\\))\\)\\^\\(\\(\\(\\*SuperscriptBox[\\\"u\\\", \
\\\"\\\\[Prime]\\\", Rule[MultilineFunction, None]]\\)[x]\\)\\^2\\\\ \\((2 + \
\\(\\\\[LeftSkeleton] 1 \\\\[RightSkeleton]\\)\\^2)\\)\\)\\) involves \
unknowns in more than one argument, so inverse functions cannot be \
used.\"\>"}]], "Message"],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\(Solve :: \"dinv\"\) will be suppressed during \
this calculation."\)], "Message"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"Solve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"3", " ", 
                    RowBox[{"ArcTan", "[", 
                      RowBox[{
                        SuperscriptBox["u", "\[Prime]",
                          MultilineFunction->None], "[", "#1", "]"}], 
                      "]"}]}], "-", \(8\ \[Alpha]\ #1\), "+", 
                  RowBox[{"5", " ", 
                    RowBox[{
                      SuperscriptBox["u", "\[Prime]",
                        MultilineFunction->None], "[", "#1", "]"}]}], "+", 
                  RowBox[{"6", " ", 
                    RowBox[{"ArcTan", "[", 
                      RowBox[{
                        SuperscriptBox["u", "\[Prime]",
                          MultilineFunction->None], "[", "#1", "]"}], "]"}], 
                    " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["u", "\[Prime]",
                          MultilineFunction->None], "[", "#1", "]"}], "2"]}], 
                  "-", 
                  RowBox[{"16", " ", "\[Alpha]", " ", "#1", " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["u", "\[Prime]",
                          MultilineFunction->None], "[", "#1", "]"}], "2"]}], 
                  "+", 
                  RowBox[{"3", " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["u", "\[Prime]",
                          MultilineFunction->None], "[", "#1", "]"}], "3"]}], 
                  "+", 
                  RowBox[{"3", " ", 
                    RowBox[{"ArcTan", "[", 
                      RowBox[{
                        SuperscriptBox["u", "\[Prime]",
                          MultilineFunction->None], "[", "#1", "]"}], "]"}], 
                    " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["u", "\[Prime]",
                          MultilineFunction->None], "[", "#1", "]"}], "4"]}], 
                  "-", 
                  RowBox[{"8", " ", "\[Alpha]", " ", "#1", " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["u", "\[Prime]",
                          MultilineFunction->None], "[", "#1", "]"}], 
                      "4"]}]}], ")"}], "/", 
              RowBox[{"(", 
                RowBox[{"8", " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{"1", "+", 
                        SuperscriptBox[
                          RowBox[{
                            SuperscriptBox["u", "\[Prime]",
                              MultilineFunction->None], "[", "#1", "]"}], 
                          "2"]}], ")"}], "2"]}], ")"}]}], "==", \(C[1]\)}], 
          ",", 
          RowBox[{"{", 
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "#1", "]"}], "}"}]}], "]"}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[
"The above result shows that a transcendental function is given in an \
essential non-algebraic way. The steps presented above demonstrate that the \
solution of the generalized cable equation is solvable in an implicit form.\
\[ThickSpace]\[EmptySquare]"], "Text",
  CellTags->{"transcendental function", "generalized cable equation"}],

Cell[TextData[{
  "The two examples demonstrate that the technique of an integrating factor \
can be generalized to second-order equations. We also realize that the \
presented procedure is capable of deriving solutions for cases in which ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fails. In S",
  ButtonBox["ection 4.4.3.1, ",
    ButtonData:>{"symmet4.nb", "Integrating factor method"},
    ButtonStyle->"Hyperlink"],
  "we will discuss the extension of the integrating factor technique to a \
general ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th-order ODE. Lie called this procedure the ",
  StyleBox["method of generalized multipliers. ",
    FontSlant->"Italic"],
  "In the following section, we discuss another solution procedure helpful in \
solving second-order ODEs. This method is related to canonical variables and \
the skeleton introduced in Sections ",
  ButtonBox["4.3.4",
    ButtonData:>{"symmet11.nb", "Canonical variables"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["4.4.1.1",
    ButtonData:>{"symmet2.nb", 
      "The skeleton of an ordinary differential equation"},
    ButtonStyle->"Hyperlink"],
  " for first-order ODEs. The following method uses the canonical variables \
to integrate the equation."
}], "Text",
  CellTags->{
  "method of generalized multipliers", "technique of integrating factor", 
    "canonical variables", "skeleton"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.4.2.2 Method of Canonical Variables", "Subsection",
  CellTags->"Method of canonical variables"],

Cell[TextData[{
  "Here, we demonstrate by a single example that the term skeleton is also \
useful for the case of second-order equations. The combination of canonical \
variables and the method of first integrals serves to derive an explicit \
solution for an ODE for which only an implicit representation of the solution \
is known (cf. ",
  ButtonBox["Ibragimov [1994]",
    ButtonData:>{"Literat.nb", "Ibragimov-1994"},
    ButtonStyle->"Hyperlink"],
  "). The considerations serve to demonstrate that a proper combination of \
different methods will lead to a solution of the ODE."
}], "Text",
  CellTags->{
  "skeleton", "second-order equation", "canonical variables", 
    "method of first integrals"}],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Again, we use the equation from ",
  ButtonBox["Example 1",
    ButtonData:>"Example 1",
    ButtonStyle->"Hyperlink"],
  " of Section 4.4.2.1. This second-order ODE serves to show how canonical \
variables simplify the skeleton and the solution steps. The specific example \
we discuss is given by the equation"
}], "Text",
  CellTags->"canonical variables"],

Cell[CellGroupData[{

Cell[BoxData[
    \(firstExample\  = \ 
      \[PartialD]\_\(x, x\)u[x]\  - \((\[PartialD]\_x u[x])\)\/u[x]\^2\  + \ 
        1\/\(x\ u[x]\)\ ; firstExample // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(1\/\(u\ x\)\),
                  ScriptLevel->0], "-", 
                StyleBox[\(u\_x\/u\^2\),
                  ScriptLevel->0], "+", \(u\_\(x, x\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["This second-order equation admits the symmetries", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infinites\  = 
      Infinitesimals[firstExample, u, x, 
        SubstitutionRules \[Rule] {\[PartialD]\_\(x, x\)u[x]}]; 
    infinites // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(1\/2\),
                  ScriptLevel->0], " ", "u", " ", \((k1 + 2\ k2\ x)\)}]}]},
          {\(\[Xi]\_1 == x\ \((k1 + k2\ x)\)\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 2], u, 
            Plus[ k1, 
              Times[ 2, k2, x]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ x, 
            Plus[ k1, 
              Times[ k2, x]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "representing a two-dimensional group of scaling and projections. The \
skeleton of this equation exists in a four-dimensional manifold ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalM] = {x, u, u' = p, \(u'\)' = q}\)]],
  ". Since the dimension of the manifold \[GothicCapitalM] is larger than \
three, we cannot directly represent the skeleton as a surface. However, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with its animation capabilities offers the opportunity to represent the \
fourth dimension in a sequence of figures. The combination of these figures  \
in an animation allows us to represent the manifold \[GothicCapitalM] in a \
special way if one of the coordinates of \[GothicCapitalM] is smoothly \
changed. The resulting sequence creates the impression of an evolution of the \
manifold if one moves along the distinguished coordinate. For the above \
equation, we define the skeleton in the form"
}], "Text",
  CellTags->{
  "group of scaling", "group of projection", "skeleton", "manifold"}],

Cell[BoxData[
    \(skeleton[u_, x_, p_] := p\/u\^2\  - \ 1\/\(x\ u\)\)], "Input"],

Cell[TextData[{
  "representing the surface for ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)' = q\)]],
  " in an explicit form. For our animation, we select the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis as the distinguished coordinate. The three-dimensional surface \
represents the submanifold ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalM]\_s = {u, u' = p, \(u'\)' = q}\)]],
  " for certain values of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The different pictures are created by"
}], "Text",
  CellTags->{"animation", "submanifold"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      Plot3D[skeleton[u, #, p], {u, 0.1, 1}, {p, \(-3\), 3}, 
          PlotRange \[Rule] {\(-200\), 200}, \n\t\tTicks \[Rule] False, 
          PlotPoints \[Rule] 35, Mesh \[Rule] False, 
          AxesLabel \[Rule] {"\<u\>", "\<p\>", "\<q\>"}, 
          ViewPoint -> {0.717, \ \(-2.988\), \ 1.417}, 
          PlotLabel \[Rule] StringJoin["\<x=\>", ToString[#]]]&, 
      Table[i, {i,  .01,  .1,  .01}]]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70824 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.10169 -0.148196 1.10169 [
[.5 .72074 -20 0 ]
[.5 .72074 20 15 ]
[.44797 -0.02478 -4.90556 -15 ]
[.44797 -0.02478 5.09444 0 ]
[.15892 .66839 -5.31917 0 ]
[.15892 .66839 4.68083 15 ]
[-0.06694 .27471 -10 -6.62571 ]
[-0.06694 .27471 0 8.37429 ]
[ 0 0 0 0 ]
[ 1 .70824 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .72074 -81 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.01) show
99.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.02946 .11175 m
.89362 0 L
s
gsave
.44797 -0.02478 -65.9056 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .4272 m
.29069 .70824 L
s
gsave
.15892 .66839 -66.3192 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.02946 .11175 m
0 .4272 L
s
gsave
-0.06694 .27471 -71 -10.6257 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(q) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.29069 .70824 L
s
.29069 .70824 m
.30155 .45044 L
s
.30155 .45044 m
.02946 .11175 L
s
.89362 0 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.89362 0 m
.02946 .11175 L
s
.30155 .45044 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.29069 .70824 L
s
.29069 .70824 m
.30155 .45044 L
s
0 0 m
1 0 L
1 .70824 L
0 .70824 L
closepath
clip
newpath
.617 .786 .963 r
.29526 .44261 .30155 .45044 .32048 .44857 .31431 .44072 Mtetra
.31431 .44072 .32048 .44857 .33948 .44669 .33342 .43882 Mtetra
.33342 .43882 .33948 .44669 .35853 .44482 .35259 .43692 Mtetra
.35259 .43692 .35853 .44482 .37765 .44293 .37182 .43501 Mtetra
.37182 .43501 .37765 .44293 .39682 .44104 .39111 .43309 Mtetra
.39111 .43309 .39682 .44104 .41606 .43914 .41047 .43117 Mtetra
.41047 .43117 .41606 .43914 .43535 .43724 .42988 .42925 Mtetra
.42988 .42925 .43535 .43724 .45471 .43533 .44935 .42731 Mtetra
.44935 .42731 .45471 .43533 .47412 .43342 .46889 .42537 Mtetra
.46889 .42537 .47412 .43342 .4936 .4315 .48849 .42342 Mtetra
.48849 .42342 .4936 .4315 .51314 .42957 .50815 .42147 Mtetra
.50815 .42147 .51314 .42957 .53274 .42764 .52787 .41951 Mtetra
.52787 .41951 .53274 .42764 .5524 .4257 .54766 .41755 Mtetra
.613 .784 .963 r
.54766 .41755 .5524 .4257 .57213 .42441 .56751 .41573 Mtetra
.446 .672 .959 r
.56751 .41573 .57213 .42441 .59197 .4287 .58746 .42009 Mtetra
.464 .685 .962 r
.58746 .42009 .59197 .4287 .6119 .43243 .60751 .42386 Mtetra
.478 .695 .963 r
.60751 .42386 .6119 .43243 .63193 .43566 .62767 .42713 Mtetra
.491 .705 .965 r
.62767 .42713 .63193 .43566 .65205 .43845 .64791 .42996 Mtetra
.502 .712 .966 r
.64791 .42996 .65205 .43845 .67226 .44087 .66825 .4324 Mtetra
.511 .719 .966 r
.66825 .4324 .67226 .44087 .69255 .44295 .68867 .43449 Mtetra
.52 .725 .967 r
.68867 .43449 .69255 .44295 .71293 .44472 .70918 .43629 Mtetra
.527 .73 .967 r
.70918 .43629 .71293 .44472 .7334 .44623 .72977 .43781 Mtetra
.533 .735 .968 r
.72977 .43781 .7334 .44623 .75394 .4475 .75045 .43908 Mtetra
.539 .739 .968 r
.75045 .43908 .75394 .4475 .77457 .44856 .77121 .44014 Mtetra
.544 .743 .968 r
.77121 .44014 .77457 .44856 .79528 .44941 .79205 .441 Mtetra
.548 .746 .968 r
.79205 .441 .79528 .44941 .81606 .45009 .81297 .44168 Mtetra
.552 .749 .969 r
.81297 .44168 .81606 .45009 .83693 .45061 .83397 .44219 Mtetra
.555 .752 .969 r
.83397 .44219 .83693 .45061 .85787 .45097 .85505 .44256 Mtetra
.559 .754 .969 r
.85505 .44256 .85787 .45097 .87889 .4512 .87621 .44278 Mtetra
.561 .756 .969 r
.87621 .44278 .87889 .4512 .89998 .45131 .89745 .44288 Mtetra
.564 .758 .969 r
.89745 .44288 .89998 .45131 .92116 .4513 .91876 .44286 Mtetra
.566 .76 .969 r
.91876 .44286 .92116 .4513 .94241 .45119 .94016 .44274 Mtetra
.569 .762 .969 r
.94016 .44274 .94241 .45119 .96374 .45097 .96163 .44251 Mtetra
.571 .763 .969 r
.96163 .44251 .96374 .45097 .98514 .45067 .98318 .4422 Mtetra
.617 .786 .963 r
.2889 .43469 .29526 .44261 .31431 .44072 .30806 .43277 Mtetra
.30806 .43277 .31431 .44072 .33342 .43882 .32729 .43085 Mtetra
.32729 .43085 .33342 .43882 .35259 .43692 .34658 .42892 Mtetra
.34658 .42892 .35259 .43692 .37182 .43501 .36592 .42699 Mtetra
.36592 .42699 .37182 .43501 .39111 .43309 .38533 .42505 Mtetra
.38533 .42505 .39111 .43309 .41047 .43117 .4048 .4231 Mtetra
.4048 .4231 .41047 .43117 .42988 .42925 .42434 .42114 Mtetra
.42434 .42114 .42988 .42925 .44935 .42731 .44393 .41918 Mtetra
.44393 .41918 .44935 .42731 .46889 .42537 .46359 .41722 Mtetra
.46359 .41722 .46889 .42537 .48849 .42342 .48331 .41525 Mtetra
.48331 .41525 .48849 .42342 .50815 .42147 .50309 .41327 Mtetra
.50309 .41327 .50815 .42147 .52787 .41951 .52294 .41128 Mtetra
.52294 .41128 .52787 .41951 .54766 .41755 .54285 .40929 Mtetra
.54285 .40929 .54766 .41755 .56751 .41573 .56282 .40729 Mtetra
.444 .68 .965 r
.56282 .40729 .56751 .41573 .58746 .42009 .5829 .41136 Mtetra
.462 .684 .962 r
.5829 .41136 .58746 .42009 .60751 .42386 .60307 .41518 Mtetra
.477 .695 .963 r
.60307 .41518 .60751 .42386 .62767 .42713 .62335 .41848 Mtetra
.49 .704 .965 r
.62335 .41848 .62767 .42713 .64791 .42996 .64372 .42134 Mtetra
.501 .712 .966 r
.64372 .42134 .64791 .42996 .66825 .4324 .66418 .42381 Mtetra
.511 .719 .966 r
.66418 .42381 .66825 .4324 .68867 .43449 .68473 .42593 Mtetra
.519 .725 .967 r
.68473 .42593 .68867 .43449 .70918 .43629 .70537 .42773 Mtetra
.526 .73 .967 r
.70537 .42773 .70918 .43629 .72977 .43781 .7261 .42927 Mtetra
.533 .735 .968 r
.7261 .42927 .72977 .43781 .75045 .43908 .74691 .43055 Mtetra
.538 .739 .968 r
.74691 .43055 .75045 .43908 .77121 .44014 .7678 .43161 Mtetra
.543 .742 .968 r
.7678 .43161 .77121 .44014 .79205 .441 .78878 .43248 Mtetra
.548 .746 .968 r
.78878 .43248 .79205 .441 .81297 .44168 .80984 .43315 Mtetra
.552 .749 .969 r
.80984 .43315 .81297 .44168 .83397 .44219 .83097 .43367 Mtetra
.555 .751 .969 r
.83097 .43367 .83397 .44219 .85505 .44256 .85219 .43402 Mtetra
.558 .754 .969 r
.85219 .43402 .85505 .44256 .87621 .44278 .87349 .43424 Mtetra
.561 .756 .969 r
.87349 .43424 .87621 .44278 .89745 .44288 .89487 .43434 Mtetra
.564 .758 .969 r
.89487 .43434 .89745 .44288 .91876 .44286 .91633 .43431 Mtetra
.566 .76 .969 r
.91633 .43431 .91876 .44286 .94016 .44274 .93787 .43417 Mtetra
.568 .762 .969 r
.93787 .43417 .94016 .44274 .96163 .44251 .95949 .43394 Mtetra
.57 .763 .969 r
.95949 .43394 .96163 .44251 .98318 .4422 .98118 .43361 Mtetra
.617 .786 .963 r
.28245 .42666 .2889 .43469 .30806 .43277 .30173 .42472 Mtetra
.30173 .42472 .30806 .43277 .32729 .43085 .32107 .42277 Mtetra
.32107 .42277 .32729 .43085 .34658 .42892 .34048 .42082 Mtetra
.34048 .42082 .34658 .42892 .36592 .42699 .35994 .41886 Mtetra
.35994 .41886 .36592 .42699 .38533 .42505 .37947 .41689 Mtetra
.37947 .41689 .38533 .42505 .4048 .4231 .39906 .41492 Mtetra
.39906 .41492 .4048 .4231 .42434 .42114 .41872 .41294 Mtetra
.41872 .41294 .42434 .42114 .44393 .41918 .43843 .41095 Mtetra
.43843 .41095 .44393 .41918 .46359 .41722 .45821 .40896 Mtetra
.45821 .40896 .46359 .41722 .48331 .41525 .47806 .40696 Mtetra
.47806 .40696 .48331 .41525 .50309 .41327 .49797 .40495 Mtetra
.49797 .40495 .50309 .41327 .52294 .41128 .51794 .40294 Mtetra
.51794 .40294 .52294 .41128 .54285 .40929 .53797 .40092 Mtetra
.53797 .40092 .54285 .40929 .56282 .40729 .55808 .3989 Mtetra
.454 .691 .968 r
.55808 .3989 .56282 .40729 .5829 .41136 .57827 .40251 Mtetra
.461 .683 .962 r
.57827 .40251 .5829 .41136 .60307 .41518 .59857 .40638 Mtetra
.476 .694 .963 r
.59857 .40638 .60307 .41518 .62335 .41848 .61897 .40972 Mtetra
.489 .703 .965 r
.61897 .40972 .62335 .41848 .64372 .42134 .63947 .41261 Mtetra
.5 .711 .965 r
.63947 .41261 .64372 .42134 .66418 .42381 .66006 .4151 Mtetra
.51 .718 .966 r
.66006 .4151 .66418 .42381 .68473 .42593 .68074 .41724 Mtetra
.518 .724 .967 r
.68074 .41724 .68473 .42593 .70537 .42773 .70151 .41907 Mtetra
.526 .73 .967 r
.70151 .41907 .70537 .42773 .7261 .42927 .72237 .42061 Mtetra
.532 .734 .968 r
.72237 .42061 .7261 .42927 .74691 .43055 .74332 .4219 Mtetra
.538 .738 .968 r
.74332 .4219 .74691 .43055 .7678 .43161 .76435 .42297 Mtetra
.543 .742 .968 r
.76435 .42297 .7678 .43161 .78878 .43248 .78546 .42383 Mtetra
.547 .745 .968 r
.78546 .42383 .78878 .43248 .80984 .43315 .80666 .42451 Mtetra
.551 .748 .969 r
.80666 .42451 .80984 .43315 .83097 .43367 .82794 .42502 Mtetra
.555 .751 .969 r
.82794 .42502 .83097 .43367 .85219 .43402 .8493 .42537 Mtetra
.558 .754 .969 r
.8493 .42537 .85219 .43402 .87349 .43424 .87074 .42559 Mtetra
.561 .756 .969 r
.87074 .42559 .87349 .43424 .89487 .43434 .89226 .42567 Mtetra
.564 .758 .969 r
.89226 .42567 .89487 .43434 .91633 .43431 .91387 .42564 Mtetra
.566 .76 .969 r
.91387 .42564 .91633 .43431 .93787 .43417 .93555 .42549 Mtetra
.568 .762 .969 r
.93555 .42549 .93787 .43417 .95949 .43394 .95732 .42524 Mtetra
.57 .763 .969 r
.95732 .42524 .95949 .43394 .98118 .43361 .97916 .4249 Mtetra
.617 .786 .963 r
.27591 .41853 .28245 .42666 .30173 .42472 .29531 .41656 Mtetra
.29531 .41656 .30173 .42472 .32107 .42277 .31477 .41458 Mtetra
.31477 .41458 .32107 .42277 .34048 .42082 .3343 .4126 Mtetra
.3343 .4126 .34048 .42082 .35994 .41886 .35388 .41062 Mtetra
.35388 .41062 .35994 .41886 .37947 .41689 .37353 .40862 Mtetra
.37353 .40862 .37947 .41689 .39906 .41492 .39325 .40662 Mtetra
.39325 .40662 .39906 .41492 .41872 .41294 .41302 .40462 Mtetra
.41302 .40462 .41872 .41294 .43843 .41095 .43286 .4026 Mtetra
.43286 .4026 .43843 .41095 .45821 .40896 .45277 .40059 Mtetra
.45277 .40059 .45821 .40896 .47806 .40696 .47274 .39856 Mtetra
.47274 .39856 .47806 .40696 .49797 .40495 .49277 .39653 Mtetra
.49277 .39653 .49797 .40495 .51794 .40294 .51287 .39449 Mtetra
.51287 .39449 .51794 .40294 .53797 .40092 .53303 .39244 Mtetra
.53303 .39244 .53797 .40092 .55808 .3989 .55326 .39039 Mtetra
.469 .7 .969 r
.55326 .39039 .55808 .3989 .57827 .40251 .57358 .39354 Mtetra
.459 .682 .961 r
.57358 .39354 .57827 .40251 .59857 .40638 .594 .39746 Mtetra
.475 .693 .963 r
.594 .39746 .59857 .40638 .61897 .40972 .61453 .40084 Mtetra
.488 .703 .964 r
.61453 .40084 .61897 .40972 .63947 .41261 .63516 .40376 Mtetra
.499 .711 .965 r
.63516 .40376 .63947 .41261 .66006 .4151 .65588 .40628 Mtetra
.509 .718 .966 r
.65588 .40628 .66006 .4151 .68074 .41724 .67669 .40844 Mtetra
.518 .724 .967 r
.67669 .40844 .68074 .41724 .70151 .41907 .6976 .41028 Mtetra
.525 .729 .967 r
.6976 .41028 .70151 .41907 .72237 .42061 .71859 .41183 Mtetra
.532 .734 .968 r
.71859 .41183 .72237 .42061 .74332 .4219 .73968 .41313 Mtetra
.537 .738 .968 r
.73968 .41313 .74332 .4219 .76435 .42297 .76084 .4142 Mtetra
.542 .742 .968 r
.76084 .4142 .76435 .42297 .78546 .42383 .7821 .41507 Mtetra
.547 .745 .968 r
.7821 .41507 .78546 .42383 .80666 .42451 .80344 .41575 Mtetra
.551 .748 .969 r
.80344 .41575 .80666 .42451 .82794 .42502 .82486 .41625 Mtetra
.555 .751 .969 r
.82486 .41625 .82794 .42502 .8493 .42537 .84636 .4166 Mtetra
.558 .754 .969 r
.84636 .4166 .8493 .42537 .87074 .42559 .86795 .41681 Mtetra
.561 .756 .969 r
.86795 .41681 .87074 .42559 .89226 .42567 .88962 .41689 Mtetra
.563 .758 .969 r
.88962 .41689 .89226 .42567 .91387 .42564 .91137 .41684 Mtetra
.566 .76 .969 r
.91137 .41684 .91387 .42564 .93555 .42549 .9332 .41668 Mtetra
.568 .762 .969 r
.9332 .41668 .93555 .42549 .95732 .42524 .95512 .41642 Mtetra
.57 .763 .969 r
.95512 .41642 .95732 .42524 .97916 .4249 .97711 .41606 Mtetra
.617 .786 .963 r
.26929 .41028 .27591 .41853 .29531 .41656 .28881 .40829 Mtetra
.28881 .40829 .29531 .41656 .31477 .41458 .30839 .40629 Mtetra
.30839 .40629 .31477 .41458 .3343 .4126 .32804 .40428 Mtetra
.32804 .40428 .3343 .4126 .35388 .41062 .34774 .40227 Mtetra
.34774 .40227 .35388 .41062 .37353 .40862 .36752 .40025 Mtetra
.36752 .40025 .37353 .40862 .39325 .40662 .38735 .39822 Mtetra
.38735 .39822 .39325 .40662 .41302 .40462 .40725 .39619 Mtetra
.40725 .39619 .41302 .40462 .43286 .4026 .42722 .39415 Mtetra
.42722 .39415 .43286 .4026 .45277 .40059 .44725 .3921 Mtetra
.44725 .3921 .45277 .40059 .47274 .39856 .46734 .39005 Mtetra
.46734 .39005 .47274 .39856 .49277 .39653 .48751 .38799 Mtetra
.48751 .38799 .49277 .39653 .51287 .39449 .50773 .38592 Mtetra
.50773 .38592 .51287 .39449 .53303 .39244 .52803 .38384 Mtetra
.52803 .38384 .53303 .39244 .55326 .39039 .54839 .38176 Mtetra
.483 .709 .97 r
.54839 .38176 .55326 .39039 .57358 .39354 .56883 .38445 Mtetra
.458 .681 .961 r
.56883 .38445 .57358 .39354 .594 .39746 .58938 .38842 Mtetra
.474 .692 .963 r
.58938 .38842 .594 .39746 .61453 .40084 .61003 .39184 Mtetra
.487 .702 .964 r
.61003 .39184 .61453 .40084 .63516 .40376 .63079 .3948 Mtetra
.499 .71 .965 r
.63079 .3948 .63516 .40376 .65588 .40628 .65164 .39734 Mtetra
.508 .717 .966 r
.65164 .39734 .65588 .40628 .67669 .40844 .67259 .39951 Mtetra
.517 .723 .967 r
.67259 .39951 .67669 .40844 .6976 .41028 .69363 .40137 Mtetra
.525 .729 .967 r
.69363 .40137 .6976 .41028 .71859 .41183 .71477 .40293 Mtetra
.531 .734 .968 r
.71477 .40293 .71859 .41183 .73968 .41313 .73599 .40424 Mtetra
.537 .738 .968 r
.73599 .40424 .73968 .41313 .76084 .4142 .75729 .40532 Mtetra
.542 .742 .968 r
.75729 .40532 .76084 .4142 .7821 .41507 .77869 .40618 Mtetra
.547 .745 .968 r
.77869 .40618 .7821 .41507 .80344 .41575 .80017 .40686 Mtetra
.551 .748 .969 r
.80017 .40686 .80344 .41575 .82486 .41625 .82173 .40736 Mtetra
.554 .751 .969 r
.82173 .40736 .82486 .41625 .84636 .4166 .84338 .40771 Mtetra
.558 .753 .969 r
.84338 .40771 .84636 .4166 .86795 .41681 .86512 .40791 Mtetra
.561 .756 .969 r
.86512 .40791 .86795 .41681 .88962 .41689 .88693 .40797 Mtetra
.563 .758 .969 r
.88693 .40797 .88962 .41689 .91137 .41684 .90883 .40792 Mtetra
.566 .76 .969 r
.90883 .40792 .91137 .41684 .9332 .41668 .93082 .40775 Mtetra
.568 .761 .969 r
.93082 .40775 .9332 .41668 .95512 .41642 .95288 .40748 Mtetra
.57 .763 .969 r
.95288 .40748 .95512 .41642 .97711 .41606 .97503 .4071 Mtetra
.617 .786 .963 r
.26258 .40193 .26929 .41028 .28881 .40829 .28222 .39991 Mtetra
.28222 .39991 .28881 .40829 .30839 .40629 .30192 .39788 Mtetra
.30192 .39788 .30839 .40629 .32804 .40428 .32169 .39584 Mtetra
.32169 .39584 .32804 .40428 .34774 .40227 .34152 .3938 Mtetra
.34152 .3938 .34774 .40227 .36752 .40025 .36142 .39176 Mtetra
.36142 .39176 .36752 .40025 .38735 .39822 .38138 .3897 Mtetra
.38138 .3897 .38735 .39822 .40725 .39619 .4014 .38764 Mtetra
.4014 .38764 .40725 .39619 .42722 .39415 .4215 .38557 Mtetra
.4215 .38557 .42722 .39415 .44725 .3921 .44165 .3835 Mtetra
.44165 .3835 .44725 .3921 .46734 .39005 .46188 .38142 Mtetra
.46188 .38142 .46734 .39005 .48751 .38799 .48217 .37933 Mtetra
.48217 .37933 .48751 .38799 .50773 .38592 .50252 .37723 Mtetra
.50252 .37723 .50773 .38592 .52803 .38384 .52295 .37513 Mtetra
.52295 .37513 .52803 .38384 .54839 .38176 .54344 .37302 Mtetra
.498 .718 .97 r
.54344 .37302 .54839 .38176 .56883 .38445 .56401 .37524 Mtetra
.456 .68 .961 r
.56401 .37524 .56883 .38445 .58938 .38842 .58469 .37925 Mtetra
.472 .692 .963 r
.58469 .37925 .58938 .38842 .61003 .39184 .60547 .38272 Mtetra
.486 .701 .964 r
.60547 .38272 .61003 .39184 .63079 .3948 .62636 .3857 Mtetra
.498 .71 .965 r
.62636 .3857 .63079 .3948 .65164 .39734 .64735 .38827 Mtetra
.508 .717 .966 r
.64735 .38827 .65164 .39734 .67259 .39951 .66843 .39047 Mtetra
.516 .723 .967 r
.66843 .39047 .67259 .39951 .69363 .40137 .68961 .39233 Mtetra
.524 .729 .967 r
.68961 .39233 .69363 .40137 .71477 .40293 .71088 .39391 Mtetra
.531 .733 .968 r
.71088 .39391 .71477 .40293 .73599 .40424 .73224 .39523 Mtetra
.536 .738 .968 r
.73224 .39523 .73599 .40424 .75729 .40532 .75369 .39631 Mtetra
.542 .741 .968 r
.75369 .39631 .75729 .40532 .77869 .40618 .77523 .39717 Mtetra
.546 .745 .968 r
.77523 .39717 .77869 .40618 .80017 .40686 .79686 .39785 Mtetra
.55 .748 .969 r
.79686 .39785 .80017 .40686 .82173 .40736 .81857 .39835 Mtetra
.554 .751 .969 r
.81857 .39835 .82173 .40736 .84338 .40771 .84036 .39869 Mtetra
.557 .753 .969 r
.84036 .39869 .84338 .40771 .86512 .40791 .86225 .39888 Mtetra
.56 .756 .969 r
.86225 .39888 .86512 .40791 .88693 .40797 .88421 .39894 Mtetra
.563 .758 .969 r
.88421 .39894 .88693 .40797 .90883 .40792 .90626 .39887 Mtetra
.566 .76 .969 r
.90626 .39887 .90883 .40792 .93082 .40775 .9284 .39869 Mtetra
.568 .761 .969 r
.9284 .39869 .93082 .40775 .95288 .40748 .95062 .3984 Mtetra
.57 .763 .969 r
.95062 .3984 .95288 .40748 .97503 .4071 .97292 .39802 Mtetra
.617 .786 .963 r
.25578 .39346 .26258 .40193 .28222 .39991 .27554 .39141 Mtetra
.27554 .39141 .28222 .39991 .30192 .39788 .29536 .38936 Mtetra
.29536 .38936 .30192 .39788 .32169 .39584 .31525 .38729 Mtetra
.31525 .38729 .32169 .39584 .34152 .3938 .33521 .38522 Mtetra
.33521 .38522 .34152 .3938 .36142 .39176 .35523 .38315 Mtetra
.35523 .38315 .36142 .39176 .38138 .3897 .37532 .38107 Mtetra
.37532 .38107 .38138 .3897 .4014 .38764 .39547 .37898 Mtetra
.39547 .37898 .4014 .38764 .4215 .38557 .41569 .37688 Mtetra
.41569 .37688 .4215 .38557 .44165 .3835 .43598 .37478 Mtetra
.43598 .37478 .44165 .3835 .46188 .38142 .45633 .37267 Mtetra
.45633 .37267 .46188 .38142 .48217 .37933 .47676 .37055 Mtetra
.47676 .37055 .48217 .37933 .50252 .37723 .49724 .36842 Mtetra
.49724 .36842 .50252 .37723 .52295 .37513 .5178 .36629 Mtetra
.5178 .36629 .52295 .37513 .54344 .37302 .53843 .36415 Mtetra
.512 .727 .97 r
.53843 .36415 .54344 .37302 .56401 .37524 .55913 .3659 Mtetra
.455 .679 .961 r
.55913 .3659 .56401 .37524 .58469 .37925 .57993 .36996 Mtetra
.471 .691 .963 r
.57993 .36996 .58469 .37925 .60547 .38272 .60085 .37347 Mtetra
.485 .701 .964 r
.60085 .37347 .60547 .38272 .62636 .3857 .62187 .37648 Mtetra
.497 .709 .965 r
.62187 .37648 .62636 .3857 .64735 .38827 .643 .37907 Mtetra
.507 .716 .966 r
.643 .37907 .64735 .38827 .66843 .39047 .66422 .38129 Mtetra
.516 .723 .967 r
.66422 .38129 .66843 .39047 .68961 .39233 .68553 .38317 Mtetra
.523 .728 .967 r
.68553 .38317 .68961 .39233 .71088 .39391 .70695 .38476 Mtetra
.53 .733 .968 r
.70695 .38476 .71088 .39391 .73224 .39523 .72845 .38608 Mtetra
.536 .737 .968 r
.72845 .38608 .73224 .39523 .75369 .39631 .75004 .38717 Mtetra
.541 .741 .968 r
.75004 .38717 .75369 .39631 .77523 .39717 .77172 .38804 Mtetra
.546 .745 .968 r
.77172 .38804 .77523 .39717 .79686 .39785 .7935 .38871 Mtetra
.55 .748 .969 r
.7935 .38871 .79686 .39785 .81857 .39835 .81535 .3892 Mtetra
.554 .751 .969 r
.81535 .3892 .81857 .39835 .84036 .39869 .8373 .38954 Mtetra
.557 .753 .969 r
.8373 .38954 .84036 .39869 .86225 .39888 .85933 .38972 Mtetra
.56 .755 .969 r
.85933 .38972 .86225 .39888 .88421 .39894 .88145 .38977 Mtetra
.563 .757 .969 r
.88145 .38977 .88421 .39894 .90626 .39887 .90366 .38969 Mtetra
.565 .759 .969 r
.90366 .38969 .90626 .39887 .9284 .39869 .92595 .3895 Mtetra
.568 .761 .969 r
.92595 .3895 .9284 .39869 .95062 .3984 .94832 .3892 Mtetra
.57 .763 .969 r
.94832 .3892 .95062 .3984 .97292 .39802 .97078 .3888 Mtetra
.617 .786 .963 r
.24888 .38488 .25578 .39346 .27554 .39141 .26877 .3828 Mtetra
.26877 .3828 .27554 .39141 .29536 .38936 .28872 .38072 Mtetra
.28872 .38072 .29536 .38936 .31525 .38729 .30873 .37863 Mtetra
.30873 .37863 .31525 .38729 .33521 .38522 .32882 .37653 Mtetra
.32882 .37653 .33521 .38522 .35523 .38315 .34896 .37442 Mtetra
.34896 .37442 .35523 .38315 .37532 .38107 .36918 .37231 Mtetra
.36918 .37231 .37532 .38107 .39547 .37898 .38946 .37019 Mtetra
.38946 .37019 .39547 .37898 .41569 .37688 .40981 .36807 Mtetra
.40981 .36807 .41569 .37688 .43598 .37478 .43023 .36594 Mtetra
.43023 .36594 .43598 .37478 .45633 .37267 .45072 .3638 Mtetra
.45072 .3638 .45633 .37267 .47676 .37055 .47127 .36165 Mtetra
.47127 .36165 .47676 .37055 .49724 .36842 .49189 .35949 Mtetra
.49189 .35949 .49724 .36842 .5178 .36629 .51258 .35733 Mtetra
.51258 .35733 .5178 .36629 .53843 .36415 .53334 .35517 Mtetra
.526 .735 .97 r
.53334 .35517 .53843 .36415 .55913 .3659 .55417 .35644 Mtetra
.454 .678 .961 r
.55417 .35644 .55913 .3659 .57993 .36996 .57511 .36054 Mtetra
.47 .69 .963 r
.57511 .36054 .57993 .36996 .60085 .37347 .59616 .36409 Mtetra
.484 .7 .964 r
.59616 .36409 .60085 .37347 .62187 .37648 .61732 .36713 Mtetra
.496 .709 .965 r
.61732 .36713 .62187 .37648 .643 .37907 .63858 .36975 Mtetra
.506 .716 .966 r
.63858 .36975 .643 .37907 .66422 .38129 .65994 .37199 Mtetra
.515 .722 .967 r
.65994 .37199 .66422 .38129 .68553 .38317 .6814 .37389 Mtetra
.523 .728 .967 r
.6814 .37389 .68553 .38317 .70695 .38476 .70295 .37548 Mtetra
.53 .733 .968 r
.70295 .37548 .70695 .38476 .72845 .38608 .7246 .37681 Mtetra
.536 .737 .968 r
.7246 .37681 .72845 .38608 .75004 .38717 .74634 .3779 Mtetra
.541 .741 .968 r
.74634 .3779 .75004 .38717 .77172 .38804 .76817 .37877 Mtetra
.546 .744 .968 r
.76817 .37877 .77172 .38804 .7935 .38871 .79009 .37944 Mtetra
.55 .748 .969 r
.79009 .37944 .7935 .38871 .81535 .3892 .8121 .37993 Mtetra
.553 .75 .969 r
.8121 .37993 .81535 .3892 .8373 .38954 .83419 .38026 Mtetra
.557 .753 .969 r
.83419 .38026 .8373 .38954 .85933 .38972 .85638 .38043 Mtetra
.56 .755 .969 r
.85638 .38043 .85933 .38972 .88145 .38977 .87865 .38047 Mtetra
.563 .757 .969 r
.87865 .38047 .88145 .38977 .90366 .38969 .90101 .38038 Mtetra
.565 .759 .969 r
.90101 .38038 .90366 .38969 .92595 .3895 .92346 .38017 Mtetra
.567 .761 .969 r
.92346 .38017 .92595 .3895 .94832 .3892 .94599 .37986 Mtetra
.57 .763 .969 r
.94599 .37986 .94832 .3892 .97078 .3888 .96861 .37944 Mtetra
.617 .786 .963 r
.24189 .37618 .24888 .38488 .26877 .3828 .2619 .37407 Mtetra
.2619 .37407 .26877 .3828 .28872 .38072 .28198 .37196 Mtetra
.28198 .37196 .28872 .38072 .30873 .37863 .30212 .36984 Mtetra
.30212 .36984 .30873 .37863 .32882 .37653 .32233 .36771 Mtetra
.32233 .36771 .32882 .37653 .34896 .37442 .34261 .36558 Mtetra
.34261 .36558 .34896 .37442 .36918 .37231 .36295 .36344 Mtetra
.36295 .36344 .36918 .37231 .38946 .37019 .38337 .36129 Mtetra
.38337 .36129 .38946 .37019 .40981 .36807 .40385 .35913 Mtetra
.40385 .35913 .40981 .36807 .43023 .36594 .4244 .35697 Mtetra
.4244 .35697 .43023 .36594 .45072 .3638 .44502 .3548 Mtetra
.44502 .3548 .45072 .3638 .47127 .36165 .46571 .35262 Mtetra
.46571 .35262 .47127 .36165 .49189 .35949 .48646 .35044 Mtetra
.48646 .35044 .49189 .35949 .51258 .35733 .50729 .34825 Mtetra
.50729 .34825 .51258 .35733 .53334 .35517 .52819 .34605 Mtetra
.539 .743 .97 r
.52819 .34605 .53334 .35517 .55417 .35644 .54915 .34684 Mtetra
.452 .677 .961 r
.54915 .34684 .55417 .35644 .57511 .36054 .57023 .35099 Mtetra
.469 .689 .963 r
.57023 .35099 .57511 .36054 .59616 .36409 .59141 .35457 Mtetra
.483 .699 .964 r
.59141 .35457 .59616 .36409 .61732 .36713 .61271 .35765 Mtetra
.495 .708 .965 r
.61271 .35765 .61732 .36713 .63858 .36975 .6341 .3603 Mtetra
.506 .715 .966 r
.6341 .3603 .63858 .36975 .65994 .37199 .65561 .36255 Mtetra
.514 .722 .967 r
.65561 .36255 .65994 .37199 .6814 .37389 .67721 .36446 Mtetra
.522 .727 .967 r
.67721 .36446 .6814 .37389 .70295 .37548 .6989 .36607 Mtetra
.529 .732 .968 r
.6989 .36607 .70295 .37548 .7246 .37681 .72069 .36741 Mtetra
.535 .737 .968 r
.72069 .36741 .7246 .37681 .74634 .3779 .74258 .3685 Mtetra
.54 .741 .968 r
.74258 .3685 .74634 .3779 .76817 .37877 .76456 .36937 Mtetra
.545 .744 .968 r
.76456 .36937 .76817 .37877 .79009 .37944 .78663 .37003 Mtetra
.549 .747 .969 r
.78663 .37003 .79009 .37944 .8121 .37993 .80879 .37052 Mtetra
.553 .75 .969 r
.80879 .37052 .8121 .37993 .83419 .38026 .83104 .37084 Mtetra
.557 .753 .969 r
.83104 .37084 .83419 .38026 .85638 .38043 .85338 .37101 Mtetra
.56 .755 .969 r
.85338 .37101 .85638 .38043 .87865 .38047 .87581 .37103 Mtetra
.562 .757 .969 r
.87581 .37103 .87865 .38047 .90101 .38038 .89833 .37093 Mtetra
.565 .759 .969 r
.89833 .37093 .90101 .38038 .92346 .38017 .92093 .37071 Mtetra
.567 .761 .969 r
.92093 .37071 .92346 .38017 .94599 .37986 .94363 .37038 Mtetra
.569 .763 .969 r
.94363 .37038 .94599 .37986 .96861 .37944 .96641 .36995 Mtetra
.617 .786 .963 r
.2348 .36736 .24189 .37618 .2619 .37407 .25494 .36522 Mtetra
.25494 .36522 .2619 .37407 .28198 .37196 .27515 .36308 Mtetra
.27515 .36308 .28198 .37196 .30212 .36984 .29542 .36093 Mtetra
.29542 .36093 .30212 .36984 .32233 .36771 .31576 .35877 Mtetra
.31576 .35877 .32233 .36771 .34261 .36558 .33617 .35661 Mtetra
.33617 .35661 .34261 .36558 .36295 .36344 .35664 .35444 Mtetra
.35664 .35444 .36295 .36344 .38337 .36129 .37719 .35226 Mtetra
.37719 .35226 .38337 .36129 .40385 .35913 .3978 .35007 Mtetra
.3978 .35007 .40385 .35913 .4244 .35697 .41849 .34788 Mtetra
.41849 .34788 .4244 .35697 .44502 .3548 .43924 .34568 Mtetra
.43924 .34568 .44502 .3548 .46571 .35262 .46006 .34347 Mtetra
.46006 .34347 .46571 .35262 .48646 .35044 .48096 .34126 Mtetra
.48096 .34126 .48646 .35044 .50729 .34825 .50192 .33904 Mtetra
.50192 .33904 .50729 .34825 .52819 .34605 .52296 .3368 Mtetra
.552 .75 .969 r
.52296 .3368 .52819 .34605 .54915 .34684 .54406 .3371 Mtetra
.451 .676 .961 r
.54406 .3371 .54915 .34684 .57023 .35099 .56527 .34131 Mtetra
.468 .689 .963 r
.56527 .34131 .57023 .35099 .59141 .35457 .58659 .34493 Mtetra
.482 .699 .964 r
.58659 .34493 .59141 .35457 .61271 .35765 .60802 .34804 Mtetra
.494 .707 .965 r
.60802 .34804 .61271 .35765 .6341 .3603 .62956 .35071 Mtetra
.505 .715 .966 r
.62956 .35071 .6341 .3603 .65561 .36255 .65121 .35298 Mtetra
.514 .721 .967 r
.65121 .35298 .65561 .36255 .67721 .36446 .67295 .35491 Mtetra
.522 .727 .967 r
.67295 .35491 .67721 .36446 .6989 .36607 .69479 .35653 Mtetra
.529 .732 .968 r
.69479 .35653 .6989 .36607 .72069 .36741 .71673 .35787 Mtetra
.535 .737 .968 r
.71673 .35787 .72069 .36741 .74258 .3685 .73877 .35896 Mtetra
.54 .74 .968 r
.73877 .35896 .74258 .3685 .76456 .36937 .7609 .35983 Mtetra
.545 .744 .968 r
.7609 .35983 .76456 .36937 .78663 .37003 .78312 .36049 Mtetra
.549 .747 .969 r
.78312 .36049 .78663 .37003 .80879 .37052 .80544 .36097 Mtetra
.553 .75 .969 r
.80544 .36097 .80879 .37052 .83104 .37084 .82784 .36129 Mtetra
.556 .753 .969 r
.82784 .36129 .83104 .37084 .85338 .37101 .85034 .36144 Mtetra
.559 .755 .969 r
.85034 .36144 .85338 .37101 .87581 .37103 .87293 .36146 Mtetra
.562 .757 .969 r
.87293 .36146 .87581 .37103 .89833 .37093 .8956 .36135 Mtetra
.565 .759 .969 r
.8956 .36135 .89833 .37093 .92093 .37071 .91837 .36111 Mtetra
.567 .761 .969 r
.91837 .36111 .92093 .37071 .94363 .37038 .94123 .36077 Mtetra
.569 .763 .969 r
.94123 .36077 .94363 .37038 .96641 .36995 .96417 .36032 Mtetra
.617 .786 .963 r
.22762 .35841 .2348 .36736 .25494 .36522 .24788 .35625 Mtetra
.24788 .35625 .25494 .36522 .27515 .36308 .26822 .35407 Mtetra
.26822 .35407 .27515 .36308 .29542 .36093 .28862 .35189 Mtetra
.28862 .35189 .29542 .36093 .31576 .35877 .30909 .34971 Mtetra
.30909 .34971 .31576 .35877 .33617 .35661 .32963 .34751 Mtetra
.32963 .34751 .33617 .35661 .35664 .35444 .35024 .34531 Mtetra
.35024 .34531 .35664 .35444 .37719 .35226 .37092 .3431 Mtetra
.37092 .3431 .37719 .35226 .3978 .35007 .39167 .34089 Mtetra
.39167 .34089 .3978 .35007 .41849 .34788 .41249 .33866 Mtetra
.41249 .33866 .41849 .34788 .43924 .34568 .43338 .33643 Mtetra
.43338 .33643 .43924 .34568 .46006 .34347 .45434 .33419 Mtetra
.45434 .33419 .46006 .34347 .48096 .34126 .47537 .33194 Mtetra
.47537 .33194 .48096 .34126 .50192 .33904 .49648 .32969 Mtetra
.49648 .32969 .50192 .33904 .52296 .3368 .51766 .32743 Mtetra
.565 .758 .968 r
.51766 .32743 .52296 .3368 .54406 .3371 .5389 .32723 Mtetra
.449 .675 .961 r
.5389 .32723 .54406 .3371 .56527 .34131 .56024 .33148 Mtetra
.466 .688 .963 r
.56024 .33148 .56527 .34131 .58659 .34493 .5817 .33514 Mtetra
.481 .698 .964 r
.5817 .33514 .58659 .34493 .60802 .34804 .60328 .33829 Mtetra
.493 .707 .965 r
.60328 .33829 .60802 .34804 .62956 .35071 .62496 .34098 Mtetra
.504 .714 .966 r
.62496 .34098 .62956 .35071 .65121 .35298 .64674 .34327 Mtetra
.513 .721 .967 r
.64674 .34327 .65121 .35298 .67295 .35491 .66864 .34521 Mtetra
.521 .727 .967 r
.66864 .34521 .67295 .35491 .69479 .35653 .69063 .34684 Mtetra
.528 .732 .968 r
.69063 .34684 .69479 .35653 .71673 .35787 .71272 .34819 Mtetra
.534 .736 .968 r
.71272 .34819 .71673 .35787 .73877 .35896 .7349 .34928 Mtetra
.54 .74 .968 r
.7349 .34928 .73877 .35896 .7609 .35983 .75719 .35015 Mtetra
.545 .744 .968 r
.75719 .35015 .7609 .35983 .78312 .36049 .77956 .35081 Mtetra
.549 .747 .969 r
.77956 .35081 .78312 .36049 .80544 .36097 .80203 .35129 Mtetra
.553 .75 .969 r
.80203 .35129 .80544 .36097 .82784 .36129 .8246 .35159 Mtetra
.556 .752 .969 r
.8246 .35159 .82784 .36129 .85034 .36144 .84725 .35174 Mtetra
.559 .755 .969 r
.84725 .35174 .85034 .36144 .87293 .36146 .87 .35175 Mtetra
.562 .757 .969 r
.87 .35175 .87293 .36146 .8956 .36135 .89284 .35162 Mtetra
.565 .759 .969 r
.89284 .35162 .8956 .36135 .91837 .36111 .91577 .35137 Mtetra
.567 .761 .969 r
.91577 .35137 .91837 .36111 .94123 .36077 .93879 .35101 Mtetra
.569 .762 .969 r
.93879 .35101 .94123 .36077 .96417 .36032 .9619 .35054 Mtetra
.617 .786 .963 r
.22033 .34934 .22762 .35841 .24788 .35625 .24073 .34715 Mtetra
.24073 .34715 .24788 .35625 .26822 .35407 .26119 .34494 Mtetra
.26119 .34494 .26822 .35407 .28862 .35189 .28173 .34273 Mtetra
.28173 .34273 .28862 .35189 .30909 .34971 .30233 .34051 Mtetra
.30233 .34051 .30909 .34971 .32963 .34751 .32301 .33829 Mtetra
.32301 .33829 .32963 .34751 .35024 .34531 .34375 .33606 Mtetra
.34375 .33606 .35024 .34531 .37092 .3431 .36456 .33382 Mtetra
.36456 .33382 .37092 .3431 .39167 .34089 .38545 .33157 Mtetra
.38545 .33157 .39167 .34089 .41249 .33866 .40641 .32931 Mtetra
.40641 .32931 .41249 .33866 .43338 .33643 .42744 .32705 Mtetra
.42744 .32705 .43338 .33643 .45434 .33419 .44854 .32478 Mtetra
.44854 .32478 .45434 .33419 .47537 .33194 .46971 .3225 Mtetra
.46971 .3225 .47537 .33194 .49648 .32969 .49096 .32021 Mtetra
.49096 .32021 .49648 .32969 .51766 .32743 .51228 .31792 Mtetra
.577 .765 .967 r
.51228 .31792 .51766 .32743 .5389 .32723 .53367 .31722 Mtetra
.448 .675 .96 r
.53367 .31722 .5389 .32723 .56024 .33148 .55514 .32152 Mtetra
.465 .687 .963 r
.55514 .32152 .56024 .33148 .5817 .33514 .57674 .32522 Mtetra
.48 .697 .964 r
.57674 .32522 .5817 .33514 .60328 .33829 .59846 .3284 Mtetra
.493 .706 .965 r
.59846 .3284 .60328 .33829 .62496 .34098 .62028 .33111 Mtetra
.503 .714 .966 r
.62028 .33111 .62496 .34098 .64674 .34327 .64222 .33342 Mtetra
.513 .721 .967 r
.64222 .33342 .64674 .34327 .66864 .34521 .66426 .33538 Mtetra
.521 .726 .967 r
.66426 .33538 .66864 .34521 .69063 .34684 .6864 .33702 Mtetra
.528 .731 .968 r
.6864 .33702 .69063 .34684 .71272 .34819 .70864 .33837 Mtetra
.534 .736 .968 r
.70864 .33837 .71272 .34819 .7349 .34928 .73098 .33946 Mtetra
.539 .74 .968 r
.73098 .33946 .7349 .34928 .75719 .35015 .75342 .34033 Mtetra
.544 .744 .968 r
.75342 .34033 .75719 .35015 .77956 .35081 .77595 .34099 Mtetra
.549 .747 .969 r
.77595 .34099 .77956 .35081 .80203 .35129 .79858 .34146 Mtetra
.552 .75 .969 r
.79858 .34146 .80203 .35129 .8246 .35159 .8213 .34176 Mtetra
.556 .752 .969 r
.8213 .34176 .8246 .35159 .84725 .35174 .84412 .34189 Mtetra
.559 .755 .969 r
.84412 .34189 .84725 .35174 .87 .35175 .86703 .34189 Mtetra
.562 .757 .969 r
.86703 .34189 .87 .35175 .89284 .35162 .89003 .34175 Mtetra
.564 .759 .969 r
.89003 .34175 .89284 .35162 .91577 .35137 .91313 .34148 Mtetra
.567 .761 .969 r
.91313 .34148 .91577 .35137 .93879 .35101 .93632 .34111 Mtetra
.569 .762 .969 r
.93632 .34111 .93879 .35101 .9619 .35054 .9596 .34062 Mtetra
.617 .786 .963 r
.21294 .34014 .22033 .34934 .24073 .34715 .23347 .33792 Mtetra
.23347 .33792 .24073 .34715 .26119 .34494 .25407 .33568 Mtetra
.25407 .33568 .26119 .34494 .28173 .34273 .27474 .33344 Mtetra
.27474 .33344 .28173 .34273 .30233 .34051 .29547 .33119 Mtetra
.29547 .33119 .30233 .34051 .32301 .33829 .31628 .32893 Mtetra
.31628 .32893 .32301 .33829 .34375 .33606 .33716 .32667 Mtetra
.33716 .32667 .34375 .33606 .36456 .33382 .35812 .3244 Mtetra
.35812 .3244 .36456 .33382 .38545 .33157 .37914 .32212 Mtetra
.37914 .32212 .38545 .33157 .40641 .32931 .40024 .31983 Mtetra
.40024 .31983 .40641 .32931 .42744 .32705 .42141 .31753 Mtetra
.42141 .31753 .42744 .32705 .44854 .32478 .44265 .31523 Mtetra
.44265 .31523 .44854 .32478 .46971 .3225 .46397 .31292 Mtetra
.46397 .31292 .46971 .3225 .49096 .32021 .48536 .3106 Mtetra
.48536 .3106 .49096 .32021 .51228 .31792 .50682 .30827 Mtetra
.589 .771 .966 r
.50682 .30827 .51228 .31792 .53367 .31722 .52836 .30706 Mtetra
.446 .674 .96 r
.52836 .30706 .53367 .31722 .55514 .32152 .54997 .31141 Mtetra
.464 .686 .962 r
.54997 .31141 .55514 .32152 .57674 .32522 .57171 .31515 Mtetra
.479 .697 .964 r
.57171 .31515 .57674 .32522 .59846 .3284 .59357 .31836 Mtetra
.492 .706 .965 r
.59357 .31836 .59846 .3284 .62028 .33111 .61554 .3211 Mtetra
.503 .714 .966 r
.61554 .3211 .62028 .33111 .64222 .33342 .63763 .32343 Mtetra
.512 .72 .967 r
.63763 .32343 .64222 .33342 .66426 .33538 .65982 .3254 Mtetra
.52 .726 .967 r
.65982 .3254 .66426 .33538 .6864 .33702 .68211 .32705 Mtetra
.527 .731 .968 r
.68211 .32705 .6864 .33702 .70864 .33837 .7045 .3284 Mtetra
.533 .736 .968 r
.7045 .3284 .70864 .33837 .73098 .33946 .727 .3295 Mtetra
.539 .74 .968 r
.727 .3295 .73098 .33946 .75342 .34033 .74959 .33037 Mtetra
.544 .743 .968 r
.74959 .33037 .75342 .34033 .77595 .34099 .77229 .33102 Mtetra
.548 .747 .969 r
.77229 .33102 .77595 .34099 .79858 .34146 .79508 .33148 Mtetra
.552 .749 .969 r
.79508 .33148 .79858 .34146 .8213 .34176 .81796 .33177 Mtetra
.556 .752 .969 r
.81796 .33177 .8213 .34176 .84412 .34189 .84094 .3319 Mtetra
.559 .754 .969 r
.84094 .3319 .84412 .34189 .86703 .34189 .86402 .33188 Mtetra
.562 .757 .969 r
.86402 .33188 .86703 .34189 .89003 .34175 .88719 .33173 Mtetra
.564 .759 .969 r
.88719 .33173 .89003 .34175 .91313 .34148 .91045 .33145 Mtetra
.567 .761 .969 r
.91045 .33145 .91313 .34148 .93632 .34111 .93381 .33105 Mtetra
.569 .762 .969 r
.93381 .33105 .93632 .34111 .9596 .34062 .95726 .33055 Mtetra
.617 .786 .963 r
.20545 .33081 .21294 .34014 .23347 .33792 .22611 .32856 Mtetra
.22611 .32856 .23347 .33792 .25407 .33568 .24684 .32629 Mtetra
.24684 .32629 .25407 .33568 .27474 .33344 .26764 .32402 Mtetra
.26764 .32402 .27474 .33344 .29547 .33119 .28852 .32173 Mtetra
.28852 .32173 .29547 .33119 .31628 .32893 .30947 .31944 Mtetra
.30947 .31944 .31628 .32893 .33716 .32667 .33049 .31715 Mtetra
.33049 .31715 .33716 .32667 .35812 .3244 .35158 .31484 Mtetra
.35158 .31484 .35812 .3244 .37914 .32212 .37274 .31253 Mtetra
.37274 .31253 .37914 .32212 .40024 .31983 .39398 .31021 Mtetra
.39398 .31021 .40024 .31983 .42141 .31753 .41529 .30788 Mtetra
.41529 .30788 .42141 .31753 .44265 .31523 .43668 .30554 Mtetra
.43668 .30554 .44265 .31523 .46397 .31292 .45814 .30319 Mtetra
.45814 .30319 .46397 .31292 .48536 .3106 .47967 .30084 Mtetra
.47967 .30084 .48536 .3106 .50682 .30827 .50128 .29848 Mtetra
.601 .778 .965 r
.50128 .29848 .50682 .30827 .52836 .30706 .52297 .29676 Mtetra
.445 .673 .96 r
.52297 .29676 .52836 .30706 .54997 .31141 .54473 .30116 Mtetra
.463 .685 .962 r
.54473 .30116 .54997 .31141 .57171 .31515 .56661 .30494 Mtetra
.478 .696 .964 r
.56661 .30494 .57171 .31515 .59357 .31836 .58861 .30818 Mtetra
.491 .705 .965 r
.58861 .30818 .59357 .31836 .61554 .3211 .61073 .31094 Mtetra
.502 .713 .966 r
.61073 .31094 .61554 .3211 .63763 .32343 .63297 .31329 Mtetra
.511 .72 .967 r
.63297 .31329 .63763 .32343 .65982 .3254 .65531 .31527 Mtetra
.52 .726 .967 r
.65531 .31527 .65982 .3254 .68211 .32705 .67775 .31693 Mtetra
.527 .731 .968 r
.67775 .31693 .68211 .32705 .7045 .3284 .70031 .31829 Mtetra
.533 .735 .968 r
.70031 .31829 .7045 .3284 .727 .3295 .72296 .31939 Mtetra
.539 .739 .968 r
.72296 .31939 .727 .3295 .74959 .33037 .74571 .32025 Mtetra
.544 .743 .968 r
.74571 .32025 .74959 .33037 .77229 .33102 .76857 .3209 Mtetra
.548 .746 .969 r
.76857 .3209 .77229 .33102 .79508 .33148 .79152 .32136 Mtetra
.552 .749 .969 r
.79152 .32136 .79508 .33148 .81796 .33177 .81457 .32164 Mtetra
.555 .752 .969 r
.81457 .32164 .81796 .33177 .84094 .3319 .83772 .32175 Mtetra
.559 .754 .969 r
.83772 .32175 .84094 .3319 .86402 .33188 .86096 .32172 Mtetra
.561 .757 .969 r
.86096 .32172 .86402 .33188 .88719 .33173 .8843 .32155 Mtetra
.564 .759 .969 r
.8843 .32155 .88719 .33173 .91045 .33145 .90773 .32126 Mtetra
.566 .76 .969 r
.90773 .32126 .91045 .33145 .93381 .33105 .93126 .32085 Mtetra
.569 .762 .969 r
.93126 .32085 .93381 .33105 .95726 .33055 .95489 .32032 Mtetra
.617 .786 .963 r
.19785 .32135 .20545 .33081 .22611 .32856 .21864 .31906 Mtetra
.21864 .31906 .22611 .32856 .24684 .32629 .23951 .31676 Mtetra
.23951 .31676 .24684 .32629 .26764 .32402 .26045 .31446 Mtetra
.26045 .31446 .26764 .32402 .28852 .32173 .28146 .31214 Mtetra
.28146 .31214 .28852 .32173 .30947 .31944 .30255 .30982 Mtetra
.30255 .30982 .30947 .31944 .33049 .31715 .32371 .30749 Mtetra
.32371 .30749 .33049 .31715 .35158 .31484 .34494 .30515 Mtetra
.34494 .30515 .35158 .31484 .37274 .31253 .36625 .3028 Mtetra
.36625 .3028 .37274 .31253 .39398 .31021 .38763 .30045 Mtetra
.38763 .30045 .39398 .31021 .41529 .30788 .40909 .29808 Mtetra
.40909 .29808 .41529 .30788 .43668 .30554 .43062 .29571 Mtetra
.43062 .29571 .43668 .30554 .45814 .30319 .45222 .29333 Mtetra
.45222 .29333 .45814 .30319 .47967 .30084 .47391 .29094 Mtetra
.47391 .29094 .47967 .30084 .50128 .29848 .49567 .28855 Mtetra
.613 .784 .963 r
.49567 .28855 .50128 .29848 .52297 .29676 .5175 .28631 Mtetra
.443 .672 .96 r
.5175 .28631 .52297 .29676 .54473 .30116 .5394 .29076 Mtetra
.462 .685 .962 r
.5394 .29076 .54473 .30116 .56661 .30494 .56143 .29458 Mtetra
.477 .696 .964 r
.56143 .29458 .56661 .30494 .58861 .30818 .58358 .29785 Mtetra
.49 .705 .965 r
.58358 .29785 .58861 .30818 .61073 .31094 .60585 .30064 Mtetra
.501 .713 .966 r
.60585 .30064 .61073 .31094 .63297 .31329 .62824 .303 Mtetra
.511 .719 .967 r
.62824 .303 .63297 .31329 .65531 .31527 .65073 .305 Mtetra
.519 .725 .967 r
.65073 .305 .65531 .31527 .67775 .31693 .67334 .30666 Mtetra
.526 .731 .968 r
.67334 .30666 .67775 .31693 .70031 .31829 .69605 .30803 Mtetra
.533 .735 .968 r
.69605 .30803 .70031 .31829 .72296 .31939 .71886 .30913 Mtetra
.538 .739 .968 r
.71886 .30913 .72296 .31939 .74571 .32025 .74177 .30999 Mtetra
.543 .743 .968 r
.74177 .30999 .74571 .32025 .76857 .3209 .76479 .31063 Mtetra
.548 .746 .969 r
.76479 .31063 .76857 .3209 .79152 .32136 .78791 .31108 Mtetra
.552 .749 .969 r
.78791 .31108 .79152 .32136 .81457 .32164 .81112 .31135 Mtetra
.555 .752 .969 r
.81112 .31135 .81457 .32164 .83772 .32175 .83444 .31146 Mtetra
.558 .754 .969 r
.83444 .31146 .83772 .32175 .86096 .32172 .85785 .31141 Mtetra
.561 .756 .969 r
.85785 .31141 .86096 .32172 .8843 .32155 .88136 .31123 Mtetra
.564 .758 .969 r
.88136 .31123 .8843 .32155 .90773 .32126 .90497 .31091 Mtetra
.566 .76 .969 r
.90497 .31091 .90773 .32126 .93126 .32085 .92868 .31048 Mtetra
.568 .762 .969 r
.92868 .31048 .93126 .32085 .95489 .32032 .95248 .30994 Mtetra
.617 .786 .963 r
.19013 .31175 .19785 .32135 .21864 .31906 .21107 .30943 Mtetra
.21107 .30943 .21864 .31906 .23951 .31676 .23207 .3071 Mtetra
.23207 .3071 .23951 .31676 .26045 .31446 .25315 .30476 Mtetra
.25315 .30476 .26045 .31446 .28146 .31214 .27431 .30241 Mtetra
.27431 .30241 .28146 .31214 .30255 .30982 .29553 .30005 Mtetra
.29553 .30005 .30255 .30982 .32371 .30749 .31684 .29769 Mtetra
.31684 .29769 .32371 .30749 .34494 .30515 .33821 .29531 Mtetra
.33821 .29531 .34494 .30515 .36625 .3028 .35966 .29293 Mtetra
.35966 .29293 .36625 .3028 .38763 .30045 .38119 .29054 Mtetra
.38119 .29054 .38763 .30045 .40909 .29808 .40279 .28814 Mtetra
.40279 .28814 .40909 .29808 .43062 .29571 .42447 .28574 Mtetra
.42447 .28574 .43062 .29571 .45222 .29333 .44622 .28332 Mtetra
.44622 .28332 .45222 .29333 .47391 .29094 .46806 .2809 Mtetra
.46806 .2809 .47391 .29094 .49567 .28855 .48997 .27847 Mtetra
.48997 .27847 .49567 .28855 .5175 .28631 .51195 .27602 Mtetra
.443 .679 .964 r
.51195 .27602 .5175 .28631 .5394 .29076 .534 .2802 Mtetra
.46 .684 .962 r
.534 .2802 .5394 .29076 .56143 .29458 .55618 .28406 Mtetra
.476 .695 .964 r
.55618 .28406 .56143 .29458 .58358 .29785 .57848 .28736 Mtetra
.489 .704 .965 r
.57848 .28736 .58358 .29785 .60585 .30064 .6009 .29017 Mtetra
.5 .712 .966 r
.6009 .29017 .60585 .30064 .62824 .303 .62344 .29256 Mtetra
.51 .719 .967 r
.62344 .29256 .62824 .303 .65073 .305 .64609 .29457 Mtetra
.518 .725 .967 r
.64609 .29457 .65073 .305 .67334 .30666 .66885 .29624 Mtetra
.526 .73 .968 r
.66885 .29624 .67334 .30666 .69605 .30803 .69172 .29761 Mtetra
.532 .735 .968 r
.69172 .29761 .69605 .30803 .71886 .30913 .7147 .29871 Mtetra
.538 .739 .968 r
.7147 .29871 .71886 .30913 .74177 .30999 .73778 .29957 Mtetra
.543 .743 .968 r
.73778 .29957 .74177 .30999 .76479 .31063 .76096 .30021 Mtetra
.547 .746 .969 r
.76096 .30021 .76479 .31063 .78791 .31108 .78424 .30065 Mtetra
.551 .749 .969 r
.78424 .30065 .78791 .31108 .81112 .31135 .80763 .30091 Mtetra
.555 .752 .969 r
.80763 .30091 .81112 .31135 .83444 .31146 .83111 .301 Mtetra
.558 .754 .969 r
.83111 .301 .83444 .31146 .85785 .31141 .8547 .30094 Mtetra
.561 .756 .969 r
.8547 .30094 .85785 .31141 .88136 .31123 .87838 .30074 Mtetra
.564 .758 .969 r
.87838 .30074 .88136 .31123 .90497 .31091 .90217 .30041 Mtetra
.566 .76 .969 r
.90217 .30041 .90497 .31091 .92868 .31048 .92605 .29996 Mtetra
.568 .762 .969 r
.92605 .29996 .92868 .31048 .95248 .30994 .95003 .2994 Mtetra
.617 .786 .963 r
.18231 .30201 .19013 .31175 .21107 .30943 .20338 .29966 Mtetra
.20338 .29966 .21107 .30943 .23207 .3071 .22453 .29729 Mtetra
.22453 .29729 .23207 .3071 .25315 .30476 .24575 .29491 Mtetra
.24575 .29491 .25315 .30476 .27431 .30241 .26704 .29253 Mtetra
.26704 .29253 .27431 .30241 .29553 .30005 .28841 .29014 Mtetra
.28841 .29014 .29553 .30005 .31684 .29769 .30986 .28774 Mtetra
.30986 .28774 .31684 .29769 .33821 .29531 .33138 .28533 Mtetra
.33138 .28533 .33821 .29531 .35966 .29293 .35298 .28292 Mtetra
.35298 .28292 .35966 .29293 .38119 .29054 .37465 .28049 Mtetra
.37465 .28049 .38119 .29054 .40279 .28814 .3964 .27806 Mtetra
.3964 .27806 .40279 .28814 .42447 .28574 .41823 .27561 Mtetra
.41823 .27561 .42447 .28574 .44622 .28332 .44013 .27316 Mtetra
.44013 .27316 .44622 .28332 .46806 .2809 .46212 .2707 Mtetra
.46212 .2707 .46806 .2809 .48997 .27847 .48418 .26823 Mtetra
.48418 .26823 .48997 .27847 .51195 .27602 .50632 .26576 Mtetra
.452 .688 .967 r
.50632 .26576 .51195 .27602 .534 .2802 .52852 .26949 Mtetra
.459 .683 .962 r
.52852 .26949 .534 .2802 .55618 .28406 .55084 .27339 Mtetra
.475 .694 .964 r
.55084 .27339 .55618 .28406 .57848 .28736 .5733 .27672 Mtetra
.488 .704 .965 r
.5733 .27672 .57848 .28736 .6009 .29017 .59587 .27956 Mtetra
.5 .712 .966 r
.59587 .27956 .6009 .29017 .62344 .29256 .61857 .28196 Mtetra
.509 .719 .967 r
.61857 .28196 .62344 .29256 .64609 .29457 .64138 .28398 Mtetra
.518 .725 .967 r
.64138 .28398 .64609 .29457 .66885 .29624 .6643 .28566 Mtetra
.525 .73 .968 r
.6643 .28566 .66885 .29624 .69172 .29761 .68733 .28703 Mtetra
.532 .735 .968 r
.68733 .28703 .69172 .29761 .7147 .29871 .71047 .28813 Mtetra
.537 .739 .968 r
.71047 .28813 .7147 .29871 .73778 .29957 .73372 .28899 Mtetra
.543 .742 .968 r
.73372 .28899 .73778 .29957 .76096 .30021 .75707 .28962 Mtetra
.547 .746 .969 r
.75707 .28962 .76096 .30021 .78424 .30065 .78052 .29005 Mtetra
.551 .749 .969 r
.78052 .29005 .78424 .30065 .80763 .30091 .80408 .2903 Mtetra
.555 .751 .969 r
.80408 .2903 .80763 .30091 .83111 .301 .82774 .29038 Mtetra
.558 .754 .969 r
.82774 .29038 .83111 .301 .8547 .30094 .8515 .29031 Mtetra
.561 .756 .969 r
.8515 .29031 .8547 .30094 .87838 .30074 .87536 .29009 Mtetra
.564 .758 .969 r
.87536 .29009 .87838 .30074 .90217 .30041 .89932 .28974 Mtetra
.566 .76 .969 r
.89932 .28974 .90217 .30041 .92605 .29996 .92338 .28927 Mtetra
.568 .762 .969 r
.92338 .28927 .92605 .29996 .95003 .2994 .94755 .28869 Mtetra
.617 .786 .963 r
.17437 .29213 .18231 .30201 .20338 .29966 .19559 .28974 Mtetra
.19559 .28974 .20338 .29966 .22453 .29729 .21687 .28734 Mtetra
.21687 .28734 .22453 .29729 .24575 .29491 .23824 .28493 Mtetra
.23824 .28493 .24575 .29491 .26704 .29253 .25968 .28251 Mtetra
.25968 .28251 .26704 .29253 .28841 .29014 .28119 .28008 Mtetra
.28119 .28008 .28841 .29014 .30986 .28774 .30278 .27765 Mtetra
.30278 .27765 .30986 .28774 .33138 .28533 .32445 .27521 Mtetra
.32445 .27521 .33138 .28533 .35298 .28292 .34619 .27275 Mtetra
.34619 .27275 .35298 .28292 .37465 .28049 .36802 .27029 Mtetra
.36802 .27029 .37465 .28049 .3964 .27806 .38992 .26782 Mtetra
.38992 .26782 .3964 .27806 .41823 .27561 .4119 .26534 Mtetra
.4119 .26534 .41823 .27561 .44013 .27316 .43395 .26285 Mtetra
.43395 .26285 .44013 .27316 .46212 .2707 .45609 .26036 Mtetra
.45609 .26036 .46212 .2707 .48418 .26823 .47831 .25785 Mtetra
.47831 .25785 .48418 .26823 .50632 .26576 .50061 .25534 Mtetra
.465 .697 .968 r
.50061 .25534 .50632 .26576 .52852 .26949 .52295 .25862 Mtetra
.458 .682 .962 r
.52295 .25862 .52852 .26949 .55084 .27339 .54543 .26256 Mtetra
.474 .694 .964 r
.54543 .26256 .55084 .27339 .5733 .27672 .56804 .26592 Mtetra
.487 .703 .965 r
.56804 .26592 .5733 .27672 .59587 .27956 .59077 .26878 Mtetra
.499 .711 .966 r
.59077 .26878 .59587 .27956 .61857 .28196 .61362 .2712 Mtetra
.509 .718 .967 r
.61362 .2712 .61857 .28196 .64138 .28398 .63659 .27323 Mtetra
.517 .724 .967 r
.63659 .27323 .64138 .28398 .6643 .28566 .65968 .27492 Mtetra
.525 .73 .968 r
.65968 .27492 .6643 .28566 .68733 .28703 .68287 .27629 Mtetra
.531 .734 .968 r
.68287 .27629 .68733 .28703 .71047 .28813 .70618 .2774 Mtetra
.537 .738 .968 r
.70618 .2774 .71047 .28813 .73372 .28899 .72959 .27825 Mtetra
.542 .742 .968 r
.72959 .27825 .73372 .28899 .75707 .28962 .75311 .27887 Mtetra
.547 .746 .969 r
.75311 .27887 .75707 .28962 .78052 .29005 .77674 .2793 Mtetra
.551 .749 .969 r
.77674 .2793 .78052 .29005 .80408 .2903 .80047 .27953 Mtetra
.554 .751 .969 r
.80047 .27953 .80408 .2903 .82774 .29038 .82431 .2796 Mtetra
.558 .754 .969 r
.82431 .2796 .82774 .29038 .8515 .29031 .84825 .27951 Mtetra
.561 .756 .969 r
.84825 .27951 .8515 .29031 .87536 .29009 .87229 .27927 Mtetra
.563 .758 .969 r
.87229 .27927 .87536 .29009 .89932 .28974 .89643 .27891 Mtetra
.566 .76 .969 r
.89643 .27891 .89932 .28974 .92338 .28927 .92067 .27842 Mtetra
.568 .762 .969 r
.92067 .27842 .92338 .28927 .94755 .28869 .94502 .27781 Mtetra
.617 .786 .963 r
.16632 .28211 .17437 .29213 .19559 .28974 .18767 .27968 Mtetra
.18767 .27968 .19559 .28974 .21687 .28734 .2091 .27724 Mtetra
.2091 .27724 .21687 .28734 .23824 .28493 .23061 .2748 Mtetra
.23061 .2748 .23824 .28493 .25968 .28251 .2522 .27234 Mtetra
.2522 .27234 .25968 .28251 .28119 .28008 .27386 .26988 Mtetra
.27386 .26988 .28119 .28008 .30278 .27765 .2956 .26741 Mtetra
.2956 .26741 .30278 .27765 .32445 .27521 .31741 .26493 Mtetra
.31741 .26493 .32445 .27521 .34619 .27275 .33931 .26244 Mtetra
.33931 .26244 .34619 .27275 .36802 .27029 .36128 .25994 Mtetra
.36128 .25994 .36802 .27029 .38992 .26782 .38333 .25743 Mtetra
.38333 .25743 .38992 .26782 .4119 .26534 .40547 .25491 Mtetra
.40547 .25491 .4119 .26534 .43395 .26285 .42768 .25239 Mtetra
.42768 .25239 .43395 .26285 .45609 .26036 .44997 .24985 Mtetra
.44997 .24985 .45609 .26036 .47831 .25785 .47235 .24731 Mtetra
.47235 .24731 .47831 .25785 .50061 .25534 .4948 .24476 Mtetra
.478 .705 .969 r
.4948 .24476 .50061 .25534 .52295 .25862 .51731 .24758 Mtetra
.457 .682 .962 r
.51731 .24758 .52295 .25862 .54543 .26256 .53994 .25156 Mtetra
.473 .693 .964 r
.53994 .25156 .54543 .26256 .56804 .26592 .5627 .25495 Mtetra
.486 .702 .965 r
.5627 .25495 .56804 .26592 .59077 .26878 .58559 .25784 Mtetra
.498 .711 .966 r
.58559 .25784 .59077 .26878 .61362 .2712 .6086 .26028 Mtetra
.508 .718 .967 r
.6086 .26028 .61362 .2712 .63659 .27323 .63173 .26232 Mtetra
.517 .724 .967 r
.63173 .26232 .63659 .27323 .65968 .27492 .65498 .26401 Mtetra
.524 .729 .968 r
.65498 .26401 .65968 .27492 .68287 .27629 .67835 .26539 Mtetra
.531 .734 .968 r
.67835 .26539 .68287 .27629 .70618 .2774 .70182 .26649 Mtetra
.537 .738 .968 r
.70182 .26649 .70618 .2774 .72959 .27825 .72541 .26734 Mtetra
.542 .742 .968 r
.72541 .26734 .72959 .27825 .75311 .27887 .7491 .26796 Mtetra
.546 .745 .969 r
.7491 .26796 .75311 .27887 .77674 .2793 .7729 .26837 Mtetra
.551 .748 .969 r
.7729 .26837 .77674 .2793 .80047 .27953 .79681 .2686 Mtetra
.554 .751 .969 r
.79681 .2686 .80047 .27953 .82431 .2796 .82082 .26865 Mtetra
.558 .754 .969 r
.82082 .26865 .82431 .2796 .84825 .27951 .84494 .26854 Mtetra
.56 .756 .969 r
.84494 .26854 .84825 .27951 .87229 .27927 .86917 .26829 Mtetra
.563 .758 .969 r
.86917 .26829 .87229 .27927 .89643 .27891 .89349 .2679 Mtetra
.566 .76 .969 r
.89349 .2679 .89643 .27891 .92067 .27842 .91792 .26739 Mtetra
.568 .762 .969 r
.91792 .26739 .92067 .27842 .94502 .27781 .94246 .26676 Mtetra
.617 .786 .963 r
.15814 .27193 .16632 .28211 .18767 .27968 .17964 .26947 Mtetra
.17964 .26947 .18767 .27968 .2091 .27724 .20122 .26699 Mtetra
.20122 .26699 .2091 .27724 .23061 .2748 .22287 .26451 Mtetra
.22287 .26451 .23061 .2748 .2522 .27234 .24461 .26202 Mtetra
.24461 .26202 .2522 .27234 .27386 .26988 .26642 .25952 Mtetra
.26642 .25952 .27386 .26988 .2956 .26741 .2883 .25701 Mtetra
.2883 .25701 .2956 .26741 .31741 .26493 .31027 .25449 Mtetra
.31027 .25449 .31741 .26493 .33931 .26244 .33232 .25197 Mtetra
.33232 .25197 .33931 .26244 .36128 .25994 .35445 .24943 Mtetra
.35445 .24943 .36128 .25994 .38333 .25743 .37665 .24688 Mtetra
.37665 .24688 .38333 .25743 .40547 .25491 .39894 .24433 Mtetra
.39894 .24433 .40547 .25491 .42768 .25239 .42131 .24176 Mtetra
.42131 .24176 .42768 .25239 .44997 .24985 .44376 .23919 Mtetra
.44376 .23919 .44997 .24985 .47235 .24731 .46629 .23661 Mtetra
.46629 .23661 .47235 .24731 .4948 .24476 .48891 .23402 Mtetra
.491 .713 .969 r
.48891 .23402 .4948 .24476 .51731 .24758 .51157 .23638 Mtetra
.456 .681 .962 r
.51157 .23638 .51731 .24758 .53994 .25156 .53436 .2404 Mtetra
.472 .692 .964 r
.53436 .2404 .53994 .25156 .5627 .25495 .55728 .24382 Mtetra
.486 .702 .965 r
.55728 .24382 .5627 .25495 .58559 .25784 .58033 .24673 Mtetra
.497 .71 .966 r
.58033 .24673 .58559 .25784 .6086 .26028 .6035 .24918 Mtetra
.507 .717 .967 r
.6035 .24918 .6086 .26028 .63173 .26232 .6268 .25124 Mtetra
.516 .724 .967 r
.6268 .25124 .63173 .26232 .65498 .26401 .65022 .25294 Mtetra
.524 .729 .968 r
.65022 .25294 .65498 .26401 .67835 .26539 .67375 .25432 Mtetra
.53 .734 .968 r
.67375 .25432 .67835 .26539 .70182 .26649 .6974 .25542 Mtetra
.536 .738 .968 r
.6974 .25542 .70182 .26649 .72541 .26734 .72116 .25626 Mtetra
.541 .742 .968 r
.72116 .25626 .72541 .26734 .7491 .26796 .74503 .25687 Mtetra
.546 .745 .969 r
.74503 .25687 .7491 .26796 .7729 .26837 .769 .25728 Mtetra
.55 .748 .969 r
.769 .25728 .7729 .26837 .79681 .2686 .79309 .25749 Mtetra
.554 .751 .969 r
.79309 .25749 .79681 .2686 .82082 .26865 .81729 .25752 Mtetra
.557 .753 .969 r
.81729 .25752 .82082 .26865 .84494 .26854 .84159 .2574 Mtetra
.56 .756 .969 r
.84159 .2574 .84494 .26854 .86917 .26829 .866 .25713 Mtetra
.563 .758 .969 r
.866 .25713 .86917 .26829 .89349 .2679 .89051 .25672 Mtetra
.565 .76 .969 r
.89051 .25672 .89349 .2679 .91792 .26739 .91513 .25619 Mtetra
.568 .761 .969 r
.91513 .25619 .91792 .26739 .94246 .26676 .93985 .25554 Mtetra
.617 .786 .963 r
.14985 .2616 .15814 .27193 .17964 .26947 .17149 .2591 Mtetra
.17149 .2591 .17964 .26947 .20122 .26699 .19322 .25659 Mtetra
.19322 .25659 .20122 .26699 .22287 .26451 .21502 .25407 Mtetra
.21502 .25407 .22287 .26451 .24461 .26202 .2369 .25154 Mtetra
.2369 .25154 .24461 .26202 .26642 .25952 .25886 .249 Mtetra
.25886 .249 .26642 .25952 .2883 .25701 .2809 .24646 Mtetra
.2809 .24646 .2883 .25701 .31027 .25449 .30302 .2439 Mtetra
.30302 .2439 .31027 .25449 .33232 .25197 .32522 .24133 Mtetra
.32522 .24133 .33232 .25197 .35445 .24943 .34751 .23876 Mtetra
.34751 .23876 .35445 .24943 .37665 .24688 .36987 .23618 Mtetra
.36987 .23618 .37665 .24688 .39894 .24433 .39232 .23358 Mtetra
.39232 .23358 .39894 .24433 .42131 .24176 .41484 .23098 Mtetra
.41484 .23098 .42131 .24176 .44376 .23919 .43745 .22837 Mtetra
.43745 .22837 .44376 .23919 .46629 .23661 .46015 .22574 Mtetra
.46015 .22574 .46629 .23661 .48891 .23402 .48293 .22311 Mtetra
.504 .721 .97 r
.48293 .22311 .48891 .23402 .51157 .23638 .50575 .22501 Mtetra
.454 .68 .962 r
.50575 .22501 .51157 .23638 .53436 .2404 .52869 .22906 Mtetra
.471 .692 .963 r
.52869 .22906 .53436 .2404 .55728 .24382 .55177 .23252 Mtetra
.485 .701 .965 r
.55177 .23252 .55728 .24382 .58033 .24673 .57498 .23545 Mtetra
.497 .71 .966 r
.57498 .23545 .58033 .24673 .6035 .24918 .59833 .23792 Mtetra
.507 .717 .967 r
.59833 .23792 .6035 .24918 .6268 .25124 .62179 .23998 Mtetra
.516 .723 .967 r
.62179 .23998 .6268 .25124 .65022 .25294 .64538 .24169 Mtetra
.523 .729 .968 r
.64538 .24169 .65022 .25294 .67375 .25432 .66908 .24307 Mtetra
.53 .733 .968 r
.66908 .24307 .67375 .25432 .6974 .25542 .6929 .24417 Mtetra
.536 .738 .968 r
.6929 .24417 .6974 .25542 .72116 .25626 .71684 .24501 Mtetra
.541 .742 .968 r
.71684 .24501 .72116 .25626 .74503 .25687 .74089 .24561 Mtetra
.546 .745 .969 r
.74089 .24561 .74503 .25687 .769 .25728 .76504 .246 Mtetra
.55 .748 .969 r
.76504 .246 .769 .25728 .79309 .25749 .78931 .2462 Mtetra
.554 .751 .969 r
.78931 .2462 .79309 .25749 .81729 .25752 .81369 .24622 Mtetra
.557 .753 .969 r
.81369 .24622 .81729 .25752 .84159 .2574 .83818 .24608 Mtetra
.56 .756 .969 r
.83818 .24608 .84159 .2574 .866 .25713 .86277 .24579 Mtetra
.563 .758 .969 r
.86277 .24579 .866 .25713 .89051 .25672 .88748 .24536 Mtetra
.565 .76 .969 r
.88748 .24536 .89051 .25672 .91513 .25619 .91229 .24481 Mtetra
.568 .761 .969 r
.91229 .24481 .91513 .25619 .93985 .25554 .9372 .24413 Mtetra
.617 .786 .963 r
.14142 .25112 .14985 .2616 .17149 .2591 .16322 .24858 Mtetra
.16322 .24858 .17149 .2591 .19322 .25659 .18509 .24603 Mtetra
.18509 .24603 .19322 .25659 .21502 .25407 .20704 .24347 Mtetra
.20704 .24347 .21502 .25407 .2369 .25154 .22908 .2409 Mtetra
.22908 .2409 .2369 .25154 .25886 .249 .25119 .23833 Mtetra
.25119 .23833 .25886 .249 .2809 .24646 .27339 .23574 Mtetra
.27339 .23574 .2809 .24646 .30302 .2439 .29566 .23315 Mtetra
.29566 .23315 .30302 .2439 .32522 .24133 .31802 .23054 Mtetra
.31802 .23054 .32522 .24133 .34751 .23876 .34046 .22793 Mtetra
.34046 .22793 .34751 .23876 .36987 .23618 .36298 .2253 Mtetra
.36298 .2253 .36987 .23618 .39232 .23358 .38559 .22267 Mtetra
.38559 .22267 .39232 .23358 .41484 .23098 .40828 .22003 Mtetra
.40828 .22003 .41484 .23098 .43745 .22837 .43105 .21737 Mtetra
.43105 .21737 .43745 .22837 .46015 .22574 .45391 .21471 Mtetra
.45391 .21471 .46015 .22574 .48293 .22311 .47685 .21204 Mtetra
.517 .729 .97 r
.47685 .21204 .48293 .22311 .50575 .22501 .49984 .21346 Mtetra
.453 .679 .962 r
.49984 .21346 .50575 .22501 .52869 .22906 .52294 .21755 Mtetra
.47 .691 .963 r
.52294 .21755 .52869 .22906 .55177 .23252 .54618 .22104 Mtetra
.484 .701 .965 r
.54618 .22104 .55177 .23252 .57498 .23545 .56956 .22399 Mtetra
.496 .709 .966 r
.56956 .22399 .57498 .23545 .59833 .23792 .59307 .22648 Mtetra
.506 .716 .966 r
.59307 .22648 .59833 .23792 .62179 .23998 .6167 .22855 Mtetra
.515 .723 .967 r
.6167 .22855 .62179 .23998 .64538 .24169 .64046 .23027 Mtetra
.523 .728 .968 r
.64046 .23027 .64538 .24169 .66908 .24307 .66434 .23165 Mtetra
.53 .733 .968 r
.66434 .23165 .66908 .24307 .6929 .24417 .68834 .23275 Mtetra
.536 .737 .968 r
.68834 .23275 .6929 .24417 .71684 .24501 .71245 .23358 Mtetra
.541 .741 .968 r
.71245 .23358 .71684 .24501 .74089 .24561 .73668 .23417 Mtetra
.546 .745 .969 r
.73668 .23417 .74089 .24561 .76504 .246 .76102 .23455 Mtetra
.55 .748 .969 r
.76102 .23455 .76504 .246 .78931 .2462 .78548 .23473 Mtetra
.553 .751 .969 r
.78548 .23473 .78931 .2462 .81369 .24622 .81004 .23474 Mtetra
.557 .753 .969 r
.81004 .23474 .81369 .24622 .83818 .24608 .83472 .23458 Mtetra
.56 .755 .969 r
.83472 .23458 .83818 .24608 .86277 .24579 .8595 .23427 Mtetra
.563 .758 .969 r
.8595 .23427 .86277 .24579 .88748 .24536 .8844 .23382 Mtetra
.565 .759 .969 r
.8844 .23382 .88748 .24536 .91229 .24481 .9094 .23324 Mtetra
.567 .761 .969 r
.9094 .23324 .91229 .24481 .9372 .24413 .93451 .23254 Mtetra
.617 .786 .963 r
.13287 .24047 .14142 .25112 .16322 .24858 .15482 .2379 Mtetra
.15482 .2379 .16322 .24858 .18509 .24603 .17684 .23531 Mtetra
.17684 .23531 .18509 .24603 .20704 .24347 .19895 .23271 Mtetra
.19895 .23271 .20704 .24347 .22908 .2409 .22114 .2301 Mtetra
.22114 .2301 .22908 .2409 .25119 .23833 .2434 .22749 Mtetra
.2434 .22749 .25119 .23833 .27339 .23574 .26575 .22486 Mtetra
.26575 .22486 .27339 .23574 .29566 .23315 .28819 .22223 Mtetra
.28819 .22223 .29566 .23315 .31802 .23054 .3107 .21958 Mtetra
.3107 .21958 .31802 .23054 .34046 .22793 .3333 .21693 Mtetra
.3333 .21693 .34046 .22793 .36298 .2253 .35599 .21426 Mtetra
.35599 .21426 .36298 .2253 .38559 .22267 .37876 .21159 Mtetra
.37876 .21159 .38559 .22267 .40828 .22003 .40161 .2089 Mtetra
.40161 .2089 .40828 .22003 .43105 .21737 .42455 .20621 Mtetra
.42455 .20621 .43105 .21737 .45391 .21471 .44757 .2035 Mtetra
.44757 .2035 .45391 .21471 .47685 .21204 .47068 .20079 Mtetra
.529 .736 .97 r
.47068 .20079 .47685 .21204 .49984 .21346 .49384 .20173 Mtetra
.452 .678 .961 r
.49384 .20173 .49984 .21346 .52294 .21755 .5171 .20587 Mtetra
.469 .69 .963 r
.5171 .20587 .52294 .21755 .54618 .22104 .54051 .20938 Mtetra
.483 .7 .965 r
.54051 .20938 .54618 .22104 .56956 .22399 .56405 .21236 Mtetra
.495 .709 .966 r
.56405 .21236 .56956 .22399 .59307 .22648 .58773 .21486 Mtetra
.505 .716 .966 r
.58773 .21486 .59307 .22648 .6167 .22855 .61153 .21694 Mtetra
.514 .722 .967 r
.61153 .21694 .6167 .22855 .64046 .23027 .63547 .21866 Mtetra
.522 .728 .968 r
.63547 .21866 .64046 .23027 .66434 .23165 .65952 .22005 Mtetra
.529 .733 .968 r
.65952 .22005 .66434 .23165 .68834 .23275 .6837 .22114 Mtetra
.535 .737 .968 r
.6837 .22114 .68834 .23275 .71245 .23358 .70799 .22196 Mtetra
.54 .741 .968 r
.70799 .22196 .71245 .23358 .73668 .23417 .73241 .22255 Mtetra
.545 .745 .969 r
.73241 .22255 .73668 .23417 .76102 .23455 .75693 .22292 Mtetra
.549 .748 .969 r
.75693 .22292 .76102 .23455 .78548 .23473 .78157 .22308 Mtetra
.553 .75 .969 r
.78157 .22308 .78548 .23473 .81004 .23474 .80633 .22307 Mtetra
.557 .753 .969 r
.80633 .22307 .81004 .23474 .83472 .23458 .8312 .22289 Mtetra
.56 .755 .969 r
.8312 .22289 .83472 .23458 .8595 .23427 .85617 .22256 Mtetra
.562 .757 .969 r
.85617 .22256 .8595 .23427 .8844 .23382 .88127 .22209 Mtetra
.565 .759 .969 r
.88127 .22209 .8844 .23382 .9094 .23324 .90647 .22148 Mtetra
.567 .761 .969 r
.90647 .22148 .9094 .23324 .93451 .23254 .93178 .22076 Mtetra
.617 .786 .963 r
.12419 .22967 .13287 .24047 .15482 .2379 .14629 .22705 Mtetra
.14629 .22705 .15482 .2379 .17684 .23531 .16847 .22442 Mtetra
.16847 .22442 .17684 .23531 .19895 .23271 .19073 .22178 Mtetra
.19073 .22178 .19895 .23271 .22114 .2301 .21307 .21914 Mtetra
.21307 .21914 .22114 .2301 .2434 .22749 .2355 .21648 Mtetra
.2355 .21648 .2434 .22749 .26575 .22486 .25801 .21381 Mtetra
.25801 .21381 .26575 .22486 .28819 .22223 .2806 .21114 Mtetra
.2806 .21114 .28819 .22223 .3107 .21958 .30328 .20845 Mtetra
.30328 .20845 .3107 .21958 .3333 .21693 .32604 .20576 Mtetra
.32604 .20576 .3333 .21693 .35599 .21426 .34888 .20305 Mtetra
.34888 .20305 .35599 .21426 .37876 .21159 .37182 .20033 Mtetra
.37182 .20033 .37876 .21159 .40161 .2089 .39484 .1976 Mtetra
.39484 .1976 .40161 .2089 .42455 .20621 .41794 .19487 Mtetra
.41794 .19487 .42455 .20621 .44757 .2035 .44113 .19212 Mtetra
.44113 .19212 .44757 .2035 .47068 .20079 .46441 .18936 Mtetra
.541 .743 .969 r
.46441 .18936 .47068 .20079 .49384 .20173 .48775 .18982 Mtetra
.451 .678 .961 r
.48775 .18982 .49384 .20173 .5171 .20587 .51117 .19399 Mtetra
.468 .69 .963 r
.51117 .19399 .5171 .20587 .54051 .20938 .53474 .19754 Mtetra
.482 .7 .965 r
.53474 .19754 .54051 .20938 .56405 .21236 .55845 .20054 Mtetra
.494 .708 .966 r
.55845 .20054 .56405 .21236 .58773 .21486 .5823 .20305 Mtetra
.505 .716 .966 r
.5823 .20305 .58773 .21486 .61153 .21694 .60628 .20515 Mtetra
.514 .722 .967 r
.60628 .20515 .61153 .21694 .63547 .21866 .63039 .20687 Mtetra
.522 .728 .968 r
.63039 .20687 .63547 .21866 .65952 .22005 .65463 .20826 Mtetra
.529 .733 .968 r
.65463 .20826 .65952 .22005 .6837 .22114 .67899 .20934 Mtetra
.535 .737 .968 r
.67899 .20934 .6837 .22114 .70799 .22196 .70347 .21016 Mtetra
.54 .741 .968 r
.70347 .21016 .70799 .22196 .73241 .22255 .72806 .21074 Mtetra
.545 .744 .969 r
.72806 .21074 .73241 .22255 .75693 .22292 .75278 .21109 Mtetra
.549 .747 .969 r
.75278 .21109 .75693 .22292 .78157 .22308 .77761 .21124 Mtetra
.553 .75 .969 r
.77761 .21124 .78157 .22308 .80633 .22307 .80256 .21121 Mtetra
.556 .753 .969 r
.80256 .21121 .80633 .22307 .8312 .22289 .82762 .21101 Mtetra
.56 .755 .969 r
.82762 .21101 .8312 .22289 .85617 .22256 .85279 .21066 Mtetra
.562 .757 .969 r
.85279 .21066 .85617 .22256 .88127 .22209 .87808 .21016 Mtetra
.565 .759 .969 r
.87808 .21016 .88127 .22209 .90647 .22148 .90348 .20954 Mtetra
.567 .761 .969 r
.90348 .20954 .90647 .22148 .93178 .22076 .929 .20878 Mtetra
.617 .786 .963 r
.11538 .21869 .12419 .22967 .14629 .22705 .13763 .21604 Mtetra
.13763 .21604 .14629 .22705 .16847 .22442 .15996 .21337 Mtetra
.15996 .21337 .16847 .22442 .19073 .22178 .18238 .21069 Mtetra
.18238 .21069 .19073 .22178 .21307 .21914 .20488 .208 Mtetra
.20488 .208 .21307 .21914 .2355 .21648 .22747 .2053 Mtetra
.22747 .2053 .2355 .21648 .25801 .21381 .25014 .20259 Mtetra
.25014 .20259 .25801 .21381 .2806 .21114 .27289 .19988 Mtetra
.27289 .19988 .2806 .21114 .30328 .20845 .29573 .19715 Mtetra
.29573 .19715 .30328 .20845 .32604 .20576 .31866 .19441 Mtetra
.31866 .19441 .32604 .20576 .34888 .20305 .34167 .19166 Mtetra
.34167 .19166 .34888 .20305 .37182 .20033 .36477 .1889 Mtetra
.36477 .1889 .37182 .20033 .39484 .1976 .38796 .18613 Mtetra
.38796 .18613 .39484 .1976 .41794 .19487 .41123 .18335 Mtetra
.41123 .18335 .41794 .19487 .44113 .19212 .4346 .18056 Mtetra
.4346 .18056 .44113 .19212 .46441 .18936 .45805 .17776 Mtetra
.552 .75 .969 r
.45805 .17776 .46441 .18936 .48775 .18982 .48156 .17772 Mtetra
.449 .677 .961 r
.48156 .17772 .48775 .18982 .51117 .19399 .50514 .18193 Mtetra
.467 .689 .963 r
.50514 .18193 .51117 .19399 .53474 .19754 .52888 .18551 Mtetra
.481 .699 .965 r
.52888 .18551 .53474 .19754 .55845 .20054 .55277 .18853 Mtetra
.494 .708 .966 r
.55277 .18853 .55845 .20054 .5823 .20305 .57679 .19106 Mtetra
.504 .715 .966 r
.57679 .19106 .5823 .20305 .60628 .20515 .60095 .19317 Mtetra
.513 .722 .967 r
.60095 .19317 .60628 .20515 .63039 .20687 .62524 .19489 Mtetra
.521 .727 .967 r
.62524 .19489 .63039 .20687 .65463 .20826 .64966 .19628 Mtetra
.528 .732 .968 r
.64966 .19628 .65463 .20826 .67899 .20934 .6742 .19736 Mtetra
.534 .737 .968 r
.6742 .19736 .67899 .20934 .70347 .21016 .69886 .19817 Mtetra
.54 .741 .968 r
.69886 .19817 .70347 .21016 .72806 .21074 .72365 .19873 Mtetra
.545 .744 .969 r
.72365 .19873 .72806 .21074 .75278 .21109 .74856 .19907 Mtetra
.549 .747 .969 r
.74856 .19907 .75278 .21109 .77761 .21124 .77358 .19921 Mtetra
.553 .75 .969 r
.77358 .19921 .77761 .21124 .80256 .21121 .79872 .19916 Mtetra
.556 .753 .969 r
.79872 .19916 .80256 .21121 .82762 .21101 .82398 .19894 Mtetra
.559 .755 .969 r
.82398 .19894 .82762 .21101 .85279 .21066 .84936 .19856 Mtetra
.562 .757 .969 r
.84936 .19856 .85279 .21066 .87808 .21016 .87485 .19804 Mtetra
.565 .759 .969 r
.87485 .19804 .87808 .21016 .90348 .20954 .90045 .19739 Mtetra
.567 .761 .969 r
.90045 .19739 .90348 .20954 .929 .20878 .92617 .19661 Mtetra
.617 .786 .963 r
.10642 .20755 .11538 .21869 .13763 .21604 .12883 .20485 Mtetra
.12883 .20485 .13763 .21604 .15996 .21337 .15132 .20214 Mtetra
.15132 .20214 .15996 .21337 .18238 .21069 .1739 .19942 Mtetra
.1739 .19942 .18238 .21069 .20488 .208 .19656 .19669 Mtetra
.19656 .19669 .20488 .208 .22747 .2053 .21931 .19395 Mtetra
.21931 .19395 .22747 .2053 .25014 .20259 .24214 .1912 Mtetra
.24214 .1912 .25014 .20259 .27289 .19988 .26506 .18844 Mtetra
.26506 .18844 .27289 .19988 .29573 .19715 .28807 .18566 Mtetra
.28807 .18566 .29573 .19715 .31866 .19441 .31116 .18288 Mtetra
.31116 .18288 .31866 .19441 .34167 .19166 .33434 .18009 Mtetra
.33434 .18009 .34167 .19166 .36477 .1889 .35761 .17729 Mtetra
.35761 .17729 .36477 .1889 .38796 .18613 .38097 .17447 Mtetra
.38097 .17447 .38796 .18613 .41123 .18335 .40441 .17165 Mtetra
.40441 .17165 .41123 .18335 .4346 .18056 .42795 .16881 Mtetra
.42795 .16881 .4346 .18056 .45805 .17776 .45158 .16596 Mtetra
.564 .757 .968 r
.45158 .16596 .45805 .17776 .48156 .17772 .47527 .16543 Mtetra
.448 .676 .961 r
.47527 .16543 .48156 .17772 .50514 .18193 .49902 .16968 Mtetra
.466 .688 .963 r
.49902 .16968 .50514 .18193 .52888 .18551 .52293 .17329 Mtetra
.48 .699 .965 r
.52293 .17329 .52888 .18551 .55277 .18853 .54699 .17633 Mtetra
.493 .707 .966 r
.54699 .17633 .55277 .18853 .57679 .19106 .57119 .17887 Mtetra
.504 .715 .966 r
.57119 .17887 .57679 .19106 .60095 .19317 .59553 .18099 Mtetra
.513 .721 .967 r
.59553 .18099 .60095 .19317 .62524 .19489 .62 .18272 Mtetra
.521 .727 .967 r
.62 .18272 .62524 .19489 .64966 .19628 .6446 .1841 Mtetra
.528 .732 .968 r
.6446 .1841 .64966 .19628 .6742 .19736 .66933 .18518 Mtetra
.534 .736 .968 r
.66933 .18518 .6742 .19736 .69886 .19817 .69419 .18598 Mtetra
.539 .74 .968 r
.69419 .18598 .69886 .19817 .72365 .19873 .71917 .18653 Mtetra
.544 .744 .969 r
.71917 .18653 .72365 .19873 .74856 .19907 .74427 .18686 Mtetra
.549 .747 .969 r
.74427 .18686 .74856 .19907 .77358 .19921 .76949 .18698 Mtetra
.553 .75 .969 r
.76949 .18698 .77358 .19921 .79872 .19916 .79483 .18691 Mtetra
.556 .753 .969 r
.79483 .18691 .79872 .19916 .82398 .19894 .82029 .18667 Mtetra
.559 .755 .969 r
.82029 .18667 .82398 .19894 .84936 .19856 .84586 .18627 Mtetra
.562 .757 .969 r
.84586 .18627 .84936 .19856 .87485 .19804 .87156 .18572 Mtetra
.565 .759 .969 r
.87156 .18572 .87485 .19804 .90045 .19739 .89737 .18504 Mtetra
.567 .761 .969 r
.89737 .18504 .90045 .19739 .92617 .19661 .9233 .18423 Mtetra
.617 .786 .963 r
.09733 .19623 .10642 .20755 .12883 .20485 .1199 .19349 Mtetra
.1199 .19349 .12883 .20485 .15132 .20214 .14255 .19074 Mtetra
.14255 .19074 .15132 .20214 .1739 .19942 .16529 .18797 Mtetra
.16529 .18797 .1739 .19942 .19656 .19669 .18811 .1852 Mtetra
.18811 .1852 .19656 .19669 .21931 .19395 .21102 .18242 Mtetra
.21102 .18242 .21931 .19395 .24214 .1912 .23402 .17962 Mtetra
.23402 .17962 .24214 .1912 .26506 .18844 .25711 .17682 Mtetra
.25711 .17682 .26506 .18844 .28807 .18566 .28028 .174 Mtetra
.28028 .174 .28807 .18566 .31116 .18288 .30354 .17117 Mtetra
.30354 .17117 .31116 .18288 .33434 .18009 .32689 .16833 Mtetra
.32689 .16833 .33434 .18009 .35761 .17729 .35033 .16549 Mtetra
.35033 .16549 .35761 .17729 .38097 .17447 .37387 .16263 Mtetra
.37387 .16263 .38097 .17447 .40441 .17165 .39749 .15976 Mtetra
.39749 .15976 .40441 .17165 .42795 .16881 .4212 .15687 Mtetra
.4212 .15687 .42795 .16881 .45158 .16596 .44501 .15398 Mtetra
.575 .763 .968 r
.44501 .15398 .45158 .16596 .47527 .16543 .46888 .15295 Mtetra
.447 .675 .961 r
.46888 .15295 .47527 .16543 .49902 .16968 .4928 .15723 Mtetra
.465 .688 .963 r
.4928 .15723 .49902 .16968 .52293 .17329 .51688 .16087 Mtetra
.479 .698 .964 r
.51688 .16087 .52293 .17329 .54699 .17633 .54112 .16393 Mtetra
.492 .707 .966 r
.54112 .16393 .54699 .17633 .57119 .17887 .5655 .16649 Mtetra
.503 .714 .966 r
.5655 .16649 .57119 .17887 .59553 .18099 .59002 .16861 Mtetra
.512 .721 .967 r
.59002 .16861 .59553 .18099 .62 .18272 .61468 .17034 Mtetra
.52 .727 .967 r
.61468 .17034 .62 .18272 .6446 .1841 .63946 .17173 Mtetra
.527 .732 .968 r
.63946 .17173 .6446 .1841 .66933 .18518 .66438 .1728 Mtetra
.534 .736 .968 r
.66438 .1728 .66933 .18518 .69419 .18598 .68943 .17359 Mtetra
.539 .74 .968 r
.68943 .17359 .69419 .18598 .71917 .18653 .71461 .17413 Mtetra
.544 .744 .969 r
.71461 .17413 .71917 .18653 .74427 .18686 .7399 .17444 Mtetra
.548 .747 .969 r
.7399 .17444 .74427 .18686 .76949 .18698 .76532 .17454 Mtetra
.552 .75 .969 r
.76532 .17454 .76949 .18698 .79483 .18691 .79087 .17445 Mtetra
.556 .752 .969 r
.79087 .17445 .79483 .18691 .82029 .18667 .81653 .17419 Mtetra
.559 .755 .969 r
.81653 .17419 .82029 .18667 .84586 .18627 .84231 .17376 Mtetra
.562 .757 .969 r
.84231 .17376 .84586 .18627 .87156 .18572 .86821 .17319 Mtetra
.564 .759 .969 r
.86821 .17319 .87156 .18572 .89737 .18504 .89424 .17248 Mtetra
.567 .761 .969 r
.89424 .17248 .89737 .18504 .9233 .18423 .92038 .17164 Mtetra
.617 .786 .963 r
.0881 .18473 .09733 .19623 .1199 .19349 .11082 .18195 Mtetra
.11082 .18195 .1199 .19349 .14255 .19074 .13364 .17915 Mtetra
.13364 .17915 .14255 .19074 .16529 .18797 .15654 .17634 Mtetra
.15654 .17634 .16529 .18797 .18811 .1852 .17953 .17353 Mtetra
.17953 .17353 .18811 .1852 .21102 .18242 .2026 .1707 Mtetra
.2026 .1707 .21102 .18242 .23402 .17962 .22577 .16786 Mtetra
.22577 .16786 .23402 .17962 .25711 .17682 .24902 .16501 Mtetra
.24902 .16501 .25711 .17682 .28028 .174 .27237 .16215 Mtetra
.27237 .16215 .28028 .174 .30354 .17117 .2958 .15927 Mtetra
.2958 .15927 .30354 .17117 .32689 .16833 .31933 .15639 Mtetra
.31933 .15639 .32689 .16833 .35033 .16549 .34294 .1535 Mtetra
.34294 .1535 .35033 .16549 .37387 .16263 .36665 .15059 Mtetra
.36665 .15059 .37387 .16263 .39749 .15976 .39045 .14767 Mtetra
.39045 .14767 .39749 .15976 .4212 .15687 .41434 .14474 Mtetra
.41434 .14474 .4212 .15687 .44501 .15398 .43833 .1418 Mtetra
.586 .769 .967 r
.43833 .1418 .44501 .15398 .46888 .15295 .46238 .14026 Mtetra
.446 .674 .961 r
.46238 .14026 .46888 .15295 .4928 .15723 .48648 .14458 Mtetra
.463 .687 .963 r
.48648 .14458 .4928 .15723 .51688 .16087 .51074 .14824 Mtetra
.479 .697 .964 r
.51074 .14824 .51688 .16087 .54112 .16393 .53515 .15133 Mtetra
.491 .706 .966 r
.53515 .15133 .54112 .16393 .5655 .16649 .55971 .1539 Mtetra
.502 .714 .966 r
.55971 .1539 .5655 .16649 .59002 .16861 .58442 .15603 Mtetra
.512 .721 .967 r
.58442 .15603 .59002 .16861 .61468 .17034 .60926 .15776 Mtetra
.52 .726 .967 r
.60926 .15776 .61468 .17034 .63946 .17173 .63424 .15915 Mtetra
.527 .731 .968 r
.63424 .15915 .63946 .17173 .66438 .1728 .65936 .16021 Mtetra
.533 .736 .968 r
.65936 .16021 .66438 .1728 .68943 .17359 .6846 .16099 Mtetra
.539 .74 .968 r
.6846 .16099 .68943 .17359 .71461 .17413 .70997 .16152 Mtetra
.544 .744 .969 r
.70997 .16152 .71461 .17413 .7399 .17444 .73547 .16181 Mtetra
.548 .747 .969 r
.73547 .16181 .7399 .17444 .76532 .17454 .76109 .16189 Mtetra
.552 .75 .969 r
.76109 .16189 .76532 .17454 .79087 .17445 .78684 .16178 Mtetra
.556 .752 .969 r
.78684 .16178 .79087 .17445 .81653 .17419 .81271 .1615 Mtetra
.559 .755 .969 r
.81271 .1615 .81653 .17419 .84231 .17376 .8387 .16105 Mtetra
.562 .757 .969 r
.8387 .16105 .84231 .17376 .86821 .17319 .86481 .16045 Mtetra
.564 .759 .969 r
.86481 .16045 .86821 .17319 .89424 .17248 .89105 .15971 Mtetra
.567 .761 .969 r
.89105 .15971 .89424 .17248 .92038 .17164 .91741 .15884 Mtetra
.617 .786 .963 r
.07871 .17305 .0881 .18473 .11082 .18195 .1016 .17022 Mtetra
.1016 .17022 .11082 .18195 .13364 .17915 .12458 .16738 Mtetra
.12458 .16738 .13364 .17915 .15654 .17634 .14765 .16453 Mtetra
.14765 .16453 .15654 .17634 .17953 .17353 .17081 .16167 Mtetra
.17081 .16167 .17953 .17353 .2026 .1707 .19405 .15879 Mtetra
.19405 .15879 .2026 .1707 .22577 .16786 .21739 .15591 Mtetra
.21739 .15591 .22577 .16786 .24902 .16501 .24081 .15301 Mtetra
.24081 .15301 .24902 .16501 .27237 .16215 .26433 .1501 Mtetra
.26433 .1501 .27237 .16215 .2958 .15927 .28794 .14718 Mtetra
.28794 .14718 .2958 .15927 .31933 .15639 .31164 .14425 Mtetra
.31164 .14425 .31933 .15639 .34294 .1535 .33543 .14131 Mtetra
.33543 .14131 .34294 .1535 .36665 .15059 .35932 .13836 Mtetra
.35932 .13836 .36665 .15059 .39045 .14767 .3833 .13539 Mtetra
.3833 .13539 .39045 .14767 .41434 .14474 .40737 .13241 Mtetra
.40737 .13241 .41434 .14474 .43833 .1418 .43154 .12943 Mtetra
.596 .775 .965 r
.43154 .12943 .43833 .1418 .46238 .14026 .45578 .12736 Mtetra
.444 .673 .961 r
.45578 .12736 .46238 .14026 .48648 .14458 .48005 .13173 Mtetra
.462 .686 .963 r
.48005 .13173 .48648 .14458 .51074 .14824 .50449 .13542 Mtetra
.478 .697 .964 r
.50449 .13542 .51074 .14824 .53515 .15133 .52909 .13852 Mtetra
.491 .706 .965 r
.52909 .13852 .53515 .15133 .55971 .1539 .55383 .14111 Mtetra
.502 .714 .966 r
.55383 .14111 .55971 .1539 .58442 .15603 .57873 .14324 Mtetra
.511 .72 .967 r
.57873 .14324 .58442 .15603 .60926 .15776 .60376 .14498 Mtetra
.519 .726 .967 r
.60376 .14498 .60926 .15776 .63424 .15915 .62893 .14636 Mtetra
.527 .731 .968 r
.62893 .14636 .63424 .15915 .65936 .16021 .65424 .14741 Mtetra
.533 .736 .968 r
.65424 .14741 .65936 .16021 .6846 .16099 .67968 .14818 Mtetra
.538 .74 .968 r
.67968 .14818 .6846 .16099 .70997 .16152 .70526 .1487 Mtetra
.543 .743 .969 r
.70526 .1487 .70997 .16152 .73547 .16181 .73096 .14897 Mtetra
.548 .747 .969 r
.73096 .14897 .73547 .16181 .76109 .16189 .75678 .14904 Mtetra
.552 .749 .969 r
.75678 .14904 .76109 .16189 .78684 .16178 .78274 .1489 Mtetra
.555 .752 .969 r
.78274 .1489 .78684 .16178 .81271 .1615 .80882 .14859 Mtetra
.559 .754 .969 r
.80882 .14859 .81271 .1615 .8387 .16105 .83502 .14811 Mtetra
.561 .757 .969 r
.83502 .14811 .8387 .16105 .86481 .16045 .86135 .14748 Mtetra
.564 .759 .969 r
.86135 .14748 .86481 .16045 .89105 .15971 .88781 .14671 Mtetra
.566 .761 .969 r
.88781 .14671 .89105 .15971 .91741 .15884 .91438 .14581 Mtetra
.617 .786 .963 r
.06918 .16119 .07871 .17305 .1016 .17022 .09223 .15831 Mtetra
.09223 .15831 .1016 .17022 .12458 .16738 .11538 .15542 Mtetra
.11538 .15542 .12458 .16738 .14765 .16453 .13862 .15252 Mtetra
.13862 .15252 .14765 .16453 .17081 .16167 .16194 .14961 Mtetra
.16194 .14961 .17081 .16167 .19405 .15879 .18536 .14669 Mtetra
.18536 .14669 .19405 .15879 .21739 .15591 .20887 .14376 Mtetra
.20887 .14376 .21739 .15591 .24081 .15301 .23247 .14082 Mtetra
.23247 .14082 .24081 .15301 .26433 .1501 .25616 .13786 Mtetra
.25616 .13786 .26433 .1501 .28794 .14718 .27994 .13489 Mtetra
.27994 .13489 .28794 .14718 .31164 .14425 .30382 .13192 Mtetra
.30382 .13192 .31164 .14425 .33543 .14131 .3278 .12892 Mtetra
.3278 .12892 .33543 .14131 .35932 .13836 .35186 .12592 Mtetra
.35186 .12592 .35932 .13836 .3833 .13539 .37602 .12291 Mtetra
.37602 .12291 .3833 .13539 .40737 .13241 .40028 .11988 Mtetra
.40028 .11988 .40737 .13241 .43154 .12943 .42464 .11684 Mtetra
.607 .781 .964 r
.42464 .11684 .43154 .12943 .45578 .12736 .44908 .11426 Mtetra
.443 .673 .961 r
.44908 .11426 .45578 .12736 .48005 .13173 .47352 .11866 Mtetra
.461 .685 .963 r
.47352 .11866 .48005 .13173 .50449 .13542 .49814 .12238 Mtetra
.477 .696 .964 r
.49814 .12238 .50449 .13542 .52909 .13852 .52292 .1255 Mtetra
.49 .705 .965 r
.52292 .1255 .52909 .13852 .55383 .14111 .54785 .1281 Mtetra
.501 .713 .966 r
.54785 .1281 .55383 .14111 .57873 .14324 .57294 .13024 Mtetra
.511 .72 .967 r
.57294 .13024 .57873 .14324 .60376 .14498 .59817 .13198 Mtetra
.519 .726 .967 r
.59817 .13198 .60376 .14498 .62893 .14636 .62353 .13335 Mtetra
.526 .731 .968 r
.62353 .13335 .62893 .14636 .65424 .14741 .64904 .1344 Mtetra
.532 .735 .968 r
.64904 .1344 .65424 .14741 .67968 .14818 .67468 .13516 Mtetra
.538 .739 .968 r
.67468 .13516 .67968 .14818 .70526 .1487 .70046 .13566 Mtetra
.543 .743 .969 r
.70046 .13566 .70526 .1487 .73096 .14897 .72637 .13591 Mtetra
.548 .746 .969 r
.72637 .13591 .73096 .14897 .75678 .14904 .75241 .13596 Mtetra
.552 .749 .969 r
.75241 .13596 .75678 .14904 .78274 .1489 .77857 .1358 Mtetra
.555 .752 .969 r
.77857 .1358 .78274 .1489 .80882 .14859 .80487 .13546 Mtetra
.558 .754 .969 r
.80487 .13546 .80882 .14859 .83502 .14811 .83129 .13496 Mtetra
.561 .757 .969 r
.83129 .13496 .83502 .14811 .86135 .14748 .85783 .1343 Mtetra
.564 .759 .969 r
.85783 .1343 .86135 .14748 .88781 .14671 .88451 .1335 Mtetra
.566 .76 .969 r
.88451 .1335 .88781 .14671 .91438 .14581 .91131 .13256 Mtetra
.617 .786 .963 r
.05949 .14913 .06918 .16119 .09223 .15831 .08271 .1462 Mtetra
.08271 .1462 .09223 .15831 .11538 .15542 .10603 .14327 Mtetra
.10603 .14327 .11538 .15542 .13862 .15252 .12944 .14032 Mtetra
.12944 .14032 .13862 .15252 .16194 .14961 .15293 .13737 Mtetra
.15293 .13737 .16194 .14961 .18536 .14669 .17653 .1344 Mtetra
.17653 .1344 .18536 .14669 .20887 .14376 .20021 .13142 Mtetra
.20021 .13142 .20887 .14376 .23247 .14082 .22398 .12842 Mtetra
.22398 .12842 .23247 .14082 .25616 .13786 .24785 .12542 Mtetra
.24785 .12542 .25616 .13786 .27994 .13489 .27182 .1224 Mtetra
.27182 .1224 .27994 .13489 .30382 .13192 .29588 .11937 Mtetra
.29588 .11937 .30382 .13192 .3278 .12892 .32003 .11633 Mtetra
.32003 .11633 .3278 .12892 .35186 .12592 .34428 .11328 Mtetra
.34428 .11328 .35186 .12592 .37602 .12291 .36863 .11022 Mtetra
.36863 .11022 .37602 .12291 .40028 .11988 .39308 .10714 Mtetra
.39308 .10714 .40028 .11988 .42464 .11684 .41762 .10405 Mtetra
.41762 .10405 .42464 .11684 .44908 .11426 .44226 .10095 Mtetra
.442 .672 .961 r
.44226 .10095 .44908 .11426 .47352 .11866 .46689 .10537 Mtetra
.46 .685 .963 r
.46689 .10537 .47352 .11866 .49814 .12238 .49169 .10912 Mtetra
.476 .696 .964 r
.49169 .10912 .49814 .12238 .52292 .1255 .51665 .11226 Mtetra
.489 .705 .965 r
.51665 .11226 .52292 .1255 .54785 .1281 .54177 .11487 Mtetra
.5 .713 .966 r
.54177 .11487 .54785 .1281 .57294 .13024 .56705 .11702 Mtetra
.51 .719 .967 r
.56705 .11702 .57294 .13024 .59817 .13198 .59248 .11876 Mtetra
.518 .725 .967 r
.59248 .11876 .59817 .13198 .62353 .13335 .61804 .12012 Mtetra
.526 .731 .968 r
.61804 .12012 .62353 .13335 .64904 .1344 .64375 .12117 Mtetra
.532 .735 .968 r
.64375 .12117 .64904 .1344 .67468 .13516 .6696 .12191 Mtetra
.538 .739 .968 r
.6696 .12191 .67468 .13516 .70046 .13566 .69558 .12239 Mtetra
.543 .743 .969 r
.69558 .12239 .70046 .13566 .72637 .13591 .7217 .12263 Mtetra
.547 .746 .969 r
.7217 .12263 .72637 .13591 .75241 .13596 .74795 .12265 Mtetra
.551 .749 .969 r
.74795 .12265 .75241 .13596 .77857 .1358 .77433 .12247 Mtetra
.555 .752 .969 r
.77433 .12247 .77857 .1358 .80487 .13546 .80084 .12211 Mtetra
.558 .754 .969 r
.80084 .12211 .80487 .13546 .83129 .13496 .82748 .12157 Mtetra
.561 .756 .969 r
.82748 .12157 .83129 .13496 .85783 .1343 .85425 .12088 Mtetra
.564 .758 .969 r
.85425 .12088 .85783 .1343 .88451 .1335 .88115 .12005 Mtetra
.566 .76 .969 r
.88115 .12005 .88451 .1335 .91131 .13256 .90818 .11908 Mtetra
.617 .786 .963 r
.04964 .13687 .05949 .14913 .08271 .1462 .07304 .1339 Mtetra
.07304 .1339 .08271 .1462 .10603 .14327 .09653 .13092 Mtetra
.09653 .13092 .10603 .14327 .12944 .14032 .12011 .12792 Mtetra
.12011 .12792 .12944 .14032 .15293 .13737 .14378 .12492 Mtetra
.14378 .12492 .15293 .13737 .17653 .1344 .16755 .1219 Mtetra
.16755 .1219 .17653 .1344 .20021 .13142 .19141 .11887 Mtetra
.19141 .11887 .20021 .13142 .22398 .12842 .21536 .11582 Mtetra
.21536 .11582 .22398 .12842 .24785 .12542 .23941 .11277 Mtetra
.23941 .11277 .24785 .12542 .27182 .1224 .26356 .1097 Mtetra
.26356 .1097 .27182 .1224 .29588 .11937 .2878 .10663 Mtetra
.2878 .10663 .29588 .11937 .32003 .11633 .31214 .10354 Mtetra
.31214 .10354 .32003 .11633 .34428 .11328 .33658 .10043 Mtetra
.33658 .10043 .34428 .11328 .36863 .11022 .36112 .09732 Mtetra
.36112 .09732 .36863 .11022 .39308 .10714 .38575 .09419 Mtetra
.38575 .09419 .39308 .10714 .41762 .10405 .41048 .09105 Mtetra
.41048 .09105 .41762 .10405 .44226 .10095 .43532 .08789 Mtetra
.444 .682 .966 r
.43532 .08789 .44226 .10095 .46689 .10537 .46014 .09187 Mtetra
.459 .684 .963 r
.46014 .09187 .46689 .10537 .49169 .10912 .48512 .09564 Mtetra
.475 .695 .964 r
.48512 .09564 .49169 .10912 .51665 .11226 .51028 .0988 Mtetra
.488 .704 .965 r
.51028 .0988 .51665 .11226 .54177 .11487 .53559 .10142 Mtetra
.5 .712 .966 r
.53559 .10142 .54177 .11487 .56705 .11702 .56107 .10357 Mtetra
.509 .719 .967 r
.56107 .10357 .56705 .11702 .59248 .11876 .58669 .10531 Mtetra
.518 .725 .967 r
.58669 .10531 .59248 .11876 .61804 .12012 .61246 .10667 Mtetra
.525 .73 .968 r
.61246 .10667 .61804 .12012 .64375 .12117 .63837 .1077 Mtetra
.532 .735 .968 r
.63837 .1077 .64375 .12117 .6696 .12191 .66443 .10844 Mtetra
.537 .739 .968 r
.66443 .10844 .6696 .12191 .69558 .12239 .69062 .1089 Mtetra
.542 .743 .969 r
.69062 .1089 .69558 .12239 .7217 .12263 .71695 .10912 Mtetra
.547 .746 .969 r
.71695 .10912 .7217 .12263 .74795 .12265 .74342 .10912 Mtetra
.551 .749 .969 r
.74342 .10912 .74795 .12265 .77433 .12247 .77002 .10891 Mtetra
.555 .752 .969 r
.77002 .10891 .77433 .12247 .80084 .12211 .79675 .10852 Mtetra
.558 .754 .969 r
.79675 .10852 .80084 .12211 .82748 .12157 .82362 .10795 Mtetra
.561 .756 .969 r
.82362 .10795 .82748 .12157 .85425 .12088 .85061 .10723 Mtetra
.564 .758 .969 r
.85061 .10723 .85425 .12088 .88115 .12005 .87774 .10636 Mtetra
.566 .76 .969 r
.87774 .10636 .88115 .12005 .90818 .11908 .90499 .10536 Mtetra
.617 .786 .963 r
.03963 .12441 .04964 .13687 .07304 .1339 .0632 .12139 Mtetra
.0632 .12139 .07304 .1339 .09653 .13092 .08686 .11836 Mtetra
.08686 .11836 .09653 .13092 .12011 .12792 .11062 .11531 Mtetra
.11062 .11531 .12011 .12792 .14378 .12492 .13447 .11226 Mtetra
.13447 .11226 .14378 .12492 .16755 .1219 .15842 .10919 Mtetra
.15842 .10919 .16755 .1219 .19141 .11887 .18246 .10611 Mtetra
.18246 .10611 .19141 .11887 .21536 .11582 .2066 .10302 Mtetra
.2066 .10302 .21536 .11582 .23941 .11277 .23083 .09991 Mtetra
.23083 .09991 .23941 .11277 .26356 .1097 .25516 .09679 Mtetra
.25516 .09679 .26356 .1097 .2878 .10663 .27959 .09366 Mtetra
.27959 .09366 .2878 .10663 .31214 .10354 .30412 .09052 Mtetra
.30412 .09052 .31214 .10354 .33658 .10043 .32875 .08736 Mtetra
.32875 .08736 .33658 .10043 .36112 .09732 .35347 .0842 Mtetra
.35347 .0842 .36112 .09732 .38575 .09419 .3783 .08101 Mtetra
.3783 .08101 .38575 .09419 .41048 .09105 .40323 .07782 Mtetra
.40323 .07782 .41048 .09105 .43532 .08789 .42826 .07461 Mtetra
.456 .69 .967 r
.42826 .07461 .43532 .08789 .46014 .09187 .45327 .07813 Mtetra
.458 .683 .963 r
.45327 .07813 .46014 .09187 .48512 .09564 .47845 .08193 Mtetra
.474 .694 .964 r
.47845 .08193 .48512 .09564 .51028 .0988 .50379 .08511 Mtetra
.487 .704 .965 r
.50379 .08511 .51028 .0988 .53559 .10142 .52931 .08774 Mtetra
.499 .712 .966 r
.52931 .08774 .53559 .10142 .56107 .10357 .55498 .0899 Mtetra
.509 .719 .967 r
.55498 .0899 .56107 .10357 .58669 .10531 .5808 .09163 Mtetra
.517 .725 .967 r
.5808 .09163 .58669 .10531 .61246 .10667 .60678 .09299 Mtetra
.525 .73 .968 r
.60678 .09299 .61246 .10667 .63837 .1077 .6329 .09401 Mtetra
.531 .735 .968 r
.6329 .09401 .63837 .1077 .66443 .10844 .65917 .09473 Mtetra
.537 .739 .968 r
.65917 .09473 .66443 .10844 .69062 .1089 .68558 .09517 Mtetra
.542 .743 .969 r
.68558 .09517 .69062 .1089 .71695 .10912 .71212 .09537 Mtetra
.547 .746 .969 r
.71212 .09537 .71695 .10912 .74342 .10912 .73881 .09534 Mtetra
.551 .749 .969 r
.73881 .09534 .74342 .10912 .77002 .10891 .76563 .09511 Mtetra
.554 .751 .969 r
.76563 .09511 .77002 .10891 .79675 .10852 .79259 .09469 Mtetra
.558 .754 .969 r
.79259 .09469 .79675 .10852 .82362 .10795 .81968 .09409 Mtetra
.561 .756 .969 r
.81968 .09409 .82362 .10795 .85061 .10723 .8469 .09334 Mtetra
.563 .758 .969 r
.8469 .09334 .85061 .10723 .87774 .10636 .87426 .09244 Mtetra
.566 .76 .969 r
.87426 .09244 .87774 .10636 .90499 .10536 .90175 .0914 Mtetra
.617 .786 .963 r
.02946 .11175 .03963 .12441 .0632 .12139 .0532 .10868 Mtetra
.0532 .10868 .0632 .12139 .08686 .11836 .07704 .10559 Mtetra
.07704 .10559 .08686 .11836 .11062 .11531 .10098 .1025 Mtetra
.10098 .1025 .11062 .11531 .13447 .11226 .12501 .09939 Mtetra
.12501 .09939 .13447 .11226 .15842 .10919 .14914 .09627 Mtetra
.14914 .09627 .15842 .10919 .18246 .10611 .17336 .09314 Mtetra
.17336 .09314 .18246 .10611 .2066 .10302 .19768 .08999 Mtetra
.19768 .08999 .2066 .10302 .23083 .09991 .2221 .08683 Mtetra
.2221 .08683 .23083 .09991 .25516 .09679 .24662 .08366 Mtetra
.24662 .08366 .25516 .09679 .27959 .09366 .27124 .08048 Mtetra
.27124 .08048 .27959 .09366 .30412 .09052 .29596 .07728 Mtetra
.29596 .07728 .30412 .09052 .32875 .08736 .32078 .07407 Mtetra
.32078 .07407 .32875 .08736 .35347 .0842 .3457 .07085 Mtetra
.3457 .07085 .35347 .0842 .3783 .08101 .37072 .06762 Mtetra
.37072 .06762 .3783 .08101 .40323 .07782 .39585 .06437 Mtetra
.39585 .06437 .40323 .07782 .42826 .07461 .42108 .0611 Mtetra
.468 .698 .968 r
.42108 .0611 .42826 .07461 .45327 .07813 .44629 .06416 Mtetra
.457 .683 .962 r
.44629 .06416 .45327 .07813 .47845 .08193 .47166 .06798 Mtetra
.473 .694 .964 r
.47166 .06798 .47845 .08193 .50379 .08511 .4972 .07118 Mtetra
.487 .703 .965 r
.4972 .07118 .50379 .08511 .52931 .08774 .52291 .07382 Mtetra
.498 .711 .966 r
.52291 .07382 .52931 .08774 .55498 .0899 .54878 .07598 Mtetra
.508 .718 .967 r
.54878 .07598 .55498 .0899 .5808 .09163 .57482 .07772 Mtetra
.517 .724 .967 r
.57482 .07772 .5808 .09163 .60678 .09299 .601 .07907 Mtetra
.524 .73 .968 r
.601 .07907 .60678 .09299 .6329 .09401 .62733 .08007 Mtetra
.531 .734 .968 r
.62733 .08007 .6329 .09401 .65917 .09473 .65382 .08078 Mtetra
.537 .739 .968 r
.65382 .08078 .65917 .09473 .68558 .09517 .68044 .0812 Mtetra
.542 .742 .969 r
.68044 .0812 .68558 .09517 .71212 .09537 .70721 .08138 Mtetra
.546 .746 .969 r
.70721 .08138 .71212 .09537 .73881 .09534 .73412 .08133 Mtetra
.551 .749 .969 r
.73412 .08133 .73881 .09534 .76563 .09511 .76116 .08106 Mtetra
.554 .751 .969 r
.76116 .08106 .76563 .09511 .79259 .09469 .78835 .08061 Mtetra
.558 .754 .969 r
.78835 .08061 .79259 .09469 .81968 .09409 .81567 .07999 Mtetra
.561 .756 .969 r
.81567 .07999 .81968 .09409 .8469 .09334 .84313 .0792 Mtetra
.563 .758 .969 r
.84313 .0792 .8469 .09334 .87426 .09244 .87072 .07826 Mtetra
.566 .76 .969 r
.87072 .07826 .87426 .09244 .90175 .0914 .89845 .07718 Mtetra
0 g
.89362 0 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.89362 0 m
.02946 .11175 L
s
.02946 .11175 m
.89362 0 L
s
gsave
.44797 -0.02478 -65.9056 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .4272 m
.29069 .70824 L
s
gsave
.15892 .66839 -66.3192 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{261.5, 185.125},
  ImageMargins->{{29.5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.2104,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000560000ia000`40O003h00OogooAgoo003oOom7
Ool00?moodMoo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo002SOol200000goo0000002N
Ool00:9oo`03001oogoo008009moo`00XWoo00D007ooOomoo`0009moo`00XWoo00D007ooOomoo`00
09moo`00XWoo00D007ooOomoo`0009moo`00XGoo0P000Woo0P00Wgoo003oOom7Ool00?moodMoo`00
ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7
Ool00?moodMoo`00ogooAgoo003oOolEOol4000^Ool00?moo`eoo`P000=oo`03001oogoo02aoo`00
ogoo1Goo20002goo00<007ooOol0;7oo003mOol7000COol2000]Ool00?Eoo`P001Yoo`8002eoo`00
kGoo20008Woo0P00;Goo003VOol7000ZOol2000]Ool00=ioo`P0035oo`03001oo`0002aoo`00eWoo
2000>Woo0P00;7oo003>Ool80012Ool2000/Ool00<Moo`L004Yoo`8002aoo`00_goo2000DGoo00<0
07oo0000:goo002gOol8001IOol00`00Ool0000[Ool00;1oo`L0065oo`03001oo`0002]oo`00Z7oo
2000J7oo00<007oo0000:goo002POol8001`Ool00`00Ool0000[Ool009Uoo`L007Qoo`04001oogoo
000ZOol0095oo`P0000:Bae?7T/MCci;7C[N=[djgSZn>]ieOol01000Oomoo`00:Woo0029Ool80003
Cah01D/NCai?7TlNBah00dlN00=;7TlN>[h01CZn00Hf_SZn=[hj_SJn>[i^Ool01000Oomoo`00:Woo
0022Ool700006T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln>[hjgSJm
>]h2>[h033JM>[hfWCZn=Ydj_SZm>[hj_CkN>[dj_VMoo`04001oogoo000ZOol007Yoo`P00005Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P07>[h0
1CJn>[hf_SZn=[h01SZn00LngSZn?[hj_SkN>[hn_P06?]iJOol01@00Oomoogoo0000:Goo001bOol8
0000DDlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBadj_SJn>[hf_CZn=[hj_SJM>[hfWCZn=YdngSZm>[hj_CkN>[dngSZm
?]hj_SkN>[dngSjn?]hj_CkN?[hngSjm@]hngT;N?[e2gSkN@]hngD;n?]i2gP16Ool024KnAai6oTLN
A_i77TKn0003Ool00`00Oomoo`0WOol006Yoo`P0009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00U;7TlN
Cai?7SJn>[hf_SZn=[h00cZn00<f_SZn>[h023Zn00HngSZn?[hj_SkN>[h>?]h014;N?]i2gSkN24;N
00E2oT;N@]i2gT;n0092gP92oP05@]i2oT;n@_i2gP03@_h014;N@_i2oTKn0d;n00=6oT;n@_h00TKn
00E2oTKnA_i6oT;n00=6oP03@_i6oTKn01i6oP04001oogoo000YOol006=oo`L0002MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCahf_CZn=[hj_SJm>[hfWCZn=Ydj
_SJM>[hj_CkN>[dj_SZm?]hj_SkN>[dngSZn?]hj_CkN?[hngSZm?]hn_T;N?[e2gSkN@]hn_D;n?]i2
gSkM@_hngT;n?]e2oSkN@_hngD;n@]i2oSkM@_i2gT;n?]e6oT;N@_i2gDKn@]i2oT;NA_i2gTKn@]i6
oT;NA_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN@_i6
oT;nAah00TKn0152oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77P00009oo`03001oogoo02Mo
o`00Fgoo20000dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P03Bai?7TlN00Hf_P<j_P03=[hj_SZn00Hj_P06?]hj_SkN>[hngSZn3SkN00I2gSkN@]hngT;N
?]h8@]h01T;n@]i2gT;N@_i2gP=2oP05@]i2oT;n@_i2gP03@_h014;N@_i2oTKn0d;n00=6oT;nA_h0
0TKn00E2oTKnA_i6oT;n00=6oP03@_i6oTKn01a6oP05001oogooOol0000XOol005=oo`P0002ZBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7CJn=Ydj_SJN=[hfWCZn=[dj_SJM>[hj_CZn>[dngSZm>[hj_CkN>[hn
gSZm?]hj_SkN>[dngSjn?]hj_D;N?]i2gSkM@]hngT;N?]e2oSkN@]hngD;n?]i2oSkM@_hngT;n?]e2
oT;N@_hngD;n@]i2oT;MA_i2gT;n@]e6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@_i6
oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77P96oP03@_i77TKn0096oP0>Aai6oTLN
A_i77TKnAai6oTLNA_i77TKnAah000=oo`03001oogoo02Ioo`00C7oo1`0000=?7T/NCah00TlN00E;
7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?
7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;
7P03Cah01D/NCai?7TlNBah00dlN00=;7TlN=[h01SJn0cZn00<f_SZn>[h01SZn00HngSZn?]hj_SkN
>[h<?]h01T;N?]i2gSkN@]hngPQ2gP08@_i2gT;n@]i2oT;N@_i2gP=2oP03@]i2oT;n00I2oP08A_i2
oTKn@_i6oT;nA_i2oP=6oP05@_i6oTKnA_i2oP03A_h00d;nA_i6oP0JA_h01@00Oomoogoo0000:7oo
0014Ool80000^dlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??SJM=[hfWCZn=Yhf_SJM>[hf_CZn=YdngSZm>[hj_CkN>[dj_SZm?]hj_SkN>[dngSjn?]hj_CkN
?[hngSkM@]hngT;N?]e2gSkN@]hngD;n?]i2gSkM@_hngT;n?]e2oSkN@_hngD;n@]i2oSkM@_i2gT;n
@]e6oT;N@_i2gDKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn
@_i6oT;nAai2oTKn@_i77T;nA_i2oTLN0096oP0A@_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn
Aah00003Ool00`00Oomoo`0VOol003aoo`P0009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?
7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00e;7TlNCai?7T/N=[hfWSJn=Yhf_SJN>[hf_P03>[h0
0cJn>[hj_P04>[h01SkN>[hngSZn?]hj_PhngP04@]hngT;N?]h8@]h01T;n@]i2oT;N@_i2gP=2oP05
@]i2oT;n@_i2gP06@_h01TKn@_i6oT;nA_i2oP=6oP05@_i6oTKnA_i2oP03A_h00d;nA_i6oP0LA_h0
1@00Oomoogoo0000:7oo000hOol40000bDlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBadj_SJM=[hf
WCZn=[dj_SJM>[hf_CZn>[dngSZm>[hj_CkN>[dngSZm?]hj_SkN>[dngSjn?]hj_CkN?[i2gSkM@]hn
gT;N?]e2oSkN@]hngD;n?]i2gSkM@_hngT;n?]e2oSkN@_i2gD;n@]i2oT;MA_i2gT;n@]e6oT;N@_i2
gTKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;nAai2
oTKn@_i77P02A_h04d;nAai6oTKn@_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77P0000Aoo`03001o
ogoo02Eoo`00>7oo00D004lNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P0:Bai?7TlNCahfWSJn=Yhf_SJN
=[h2>[h00cJn>[hj_P07>[h01Cjn?]hj_SkN?[h03SkN00I2gSkN@]hngT;N?]h8@]h01T;n@]i2oT;N
@_i2gP=2oP03@]i2oT;n00Q2oP06A_i2oTKn@_i6oT;n0dKn00=2oTKnA_h08TKn00<004KnOol00Woo
00<007ooOol09Goo000hOol0RP00Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlNBae?7T[mCai;7DlN=Ydj
_SJM=[hfWCZn=[dj_SJM>[hf_C[N>[dngSZm>]hj_CkN>[hngSZm?]hj_SkN>[dngSjn?]hj_@8ngP13
@]hngD;N?]i2gSkM@_hngT;N?]e2oSkN@_hngD;n?]i2oSkM@_i2gT;n@]e2oT;N@_i2gDKn@]i2oT;M
A_i2gTKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i6oT;n
A_i2oTLN@_i6oT;nAah00TKn00=2oTLNA_h00TKn00e77TKnAai6oTLNA_i77TKnAai6oTLN00177P03
Ool00`00Oomoo`0UOol003Qoo`03001ood/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?
7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P=;7P0:Cai;7T/NBahf_SJN
=[hfWSJn=Yh<>[h01SkN?[hngSZn?]hn_PhngP04@]hngT;N?]h2@]h03T;n@]i2gT;N@_i2gT;n@]i2
oT;N@_i2gT;n@]h3@_h00d;N@_i2oP06@_h024Kn@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0PA_h0
0`00A_ioo`02Ool00`00Oomoo`0UOol003Qoo`3A001oogooBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai:oDlN
Bae?7T[mCai;7CJn=Ydj_SJM=[hfWCZn=[dj_SJM>[hf_CkN>[dngSZm?]hj_CkN>[hngSZm?]hj_SkN
>[dngSjn?]hj_D;N?]i2gSkM@]hngT;N?]e2oSkN@]hngD;n?]i2oSkM@_hngT;n@]e2oT;N@_i2gD;n
@]i2oT;MA_i2gT;n@]e6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn
@_i6oT;nA_i2oTLN@_i6oT;nAai2oTKn@_i77P02A_h04D;nAai6oTLNA_i77TKnAai6oTLNA_i77TKn
Aah004LNA_h00goo00<007ooOol097oo000hOol01@00OomoogooBah00dlN00E;7TlNCai?7T/N00=?
7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;
7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN1d/N
00Df_SJN=[hfWSJn00dj_P04?]hn_SkN>[h>?]h01T;N?]i2gSkN@]hngP92gP0:@_i2gT;N@]i2oT;N
@_i2gT;n@]h3@_h01D;N@_i2oT;n@]h00T;n00Y6oT;n@_i2oTKn@_i6oT;nA_i2oP=6oP05@_i6oTKn
A_i2oP0PA_h00`00A_i6oP03Ool00`00Oomoo`0TOol003Moo`03001oogoo009oo`3;Cai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae;7T[mBai:oT/NB_e;7SJM=[hfWCZn=Ydf_SJM>[hf_CZn=Ydj_SZm?]hj_CkN>[dn
gSZm?]hj_SkN>[dngSjn?]hn_CkN?[hngSkM@]hngT;N?]e2gSkN@]hngD;n?]i2gSkM@_hngT;n?]e2
oSkN@_i2gD;n@]i2oT;M@_i2gT;n@]e6oT;N@_i2gTKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@_i6
oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77P02A_h04d;nAai6oTKn@_i77TKnAai6
oTLNA_i77TKnAai6oTLN00177TKn00=oo`03001oogoo02Aoo`00=goo00<007ooOol00goo00=?7T/N
Cah00TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN
Cai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05
Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03
Cah01D/NCai?7TlNBah00TlN1d/N00DfWSJn=Yhf_SJN00`j_P06?]hj_SkN?[hngSZn3SkN00A2gSkN
@]hngPA2gP0:@_i2gT;N@]i2oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn0d;n00Y6oT;n@_i2oTKn@_i6
oT;nA_i2oP=6oP03@_i6oTKn0256oP030016oWoo009oo`03001oogoo02Aoo`00=goo00<007ooOol0
17oo0<]?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci:oT/NB_e;7T[nBai:oCZn=Ydf_SJM>[hfWCZn=Ydj_SJm>[hf
WCkN>[dngSZm?]hj_SkN>[dngSZn?]hn_CkN?[hngSjm?]hn_T;N?]e2gSkN@]hngD;n?]i2gSkM@_hn
gT;n?]e2oSkN@_hngD;n@]i2oT;M@_i2gT;n@]e6oT;N@_i2gDKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2
gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN0096oP03@_i7
7TKn0096oP0=Aai6oTLNA_i77TKnAai6oTLNA_h004KnAah00goo00<007ooOol08goo000gOol00`00
Oomoo`04Ool2Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah0
1D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?
7T/N00=?7P05Bai?7TlNCai;7P03Cah03T/NCai:oT/NB_i;7T[nBahfWSJn=Yhf_SJN=[h<>[h01Cjn
?]hj_SkN?[h03SkN00M2gSkN@]hngT;N?]i2oP03@]h02T;n@]i2oT;N@_i2gT;n@]i2oT;N0d;n00A2
gT;n@_i6oP=2oP0:A_i2oTKn@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0OA_h00`00A_i6oP03Ool0
0`00Oomoo`0SOol003Moo`03001oogoo00Eoo`27Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MBai6oT/NA_e;7TKn
BahfWCZn=Ydj_SJM>[hf_CZn=Ydj_SJm?]hj_CkN>[dngSZm?]hj_SkN>[dngSZn?]hn_CkN?[hngSjm
008ngP13@]hngD;N?]i2gSkM@_hngT;N?]e2oSkN@_hngD;n?]i2oSkM@_i2gT;n@]e2oT;N@_i2gDKn
@]i2oT;MA_i2gTKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn
@_i77T;nA_i2oTLN@_i6oT;nAah00TKn0112oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP00A_i77P=o
o`03001oogoo02=oo`00=goo00<007ooOol01Woo0TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;
7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;
7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN0T/N00]:oT/NB_i;7T[n
=[hfWSJn=Yhf_SJN00`j_P06?]hn_SkN>[hngSjn33kN00I2gSkN@]hngT;N?]h2@]h02T;n@]i2gT;N
@_i2gT;n@]i2oT;N0d;n00E2gT;n@_i2oT;N0092oP0:A_i2oT;n@_i6oT;nA_i2oTKn@_h3A_h01D;n
A_i6oTKn@_h07dKn00<004KnA_h00goo00<007ooOol08goo000gOol00`00Oomoo`07Ool0a4/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7D/NA_i;7TKmBai6oSZn=Ydj_SJM>[hfWCZn=[dj_SJM>[hj_CkN>[dngSZm?]hj
_CkN>[hngSZm?]hn_SkN?[dngSjn?]hngD;N?]i2gSkM@]hngT;N?]e2oSkN@]hngD;n?]i2oSkM@_hn
gT;n@]e2oT;N@_i2gD;n@]i2oT;MA_i2gT;n@]i6oT;NA_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2
gTKn@_i6oT;nA_i2oTKn@_i6oT;nA_i2oTLN0TKn00I2oTLNA_i6oT;nAah2A_h03T;nAai6oTLNA_i7
7TKnAai6oTLNA_h004KnAah3Ool00`00Oomoo`0SOol003Moo`03001oogoo00Qoo`9?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/N
Cai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P=6oP09Bai6oTKn=Yhf_SJN=[hfWSJn00dj_P04?]hn_SkN>[h:?]h00d;N?]hngP02@]h00ckN
@]i2gP04@]h02T;n@]i2gT;N@_i2gT;n@]i2oT;N0d;n00=2gT;n@_h014;n00Y6oT;n@_i2oTKn@_i6
oT;nA_i2oP=6oP03@_i6oTKn01m6oP030016oTKn00Aoo`03001oogoo029oo`00=goo00<007ooOol0
2Goo0<1;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNA_e;7TKnBai6oD/N=Ydj_SJM>[hfWCZn=[dj_SZm>[hf_CkN>[dn
gSZm?]hj_CkN>[dngSZn?]hj_CkN?[hngSjm?]hn_T;N?]e2gSkN@]hngD;N?]i2gSkM@_hngT;N?]e2
oSkN@_hngD;n@]i2oT;M@_i2gT;n@]e6oT;N@_i2gDKn@]i6oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6
oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAah2A_h01T;nAai6oTKn@_i77P96oP0A@_i77TKnAai6
oTLNA_i77TKnAai6oTLNA_h004KnAai6oP03Ool00`00Oomoo`0ROol003Moo`03001oogoo00Uoo`=?
7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;
7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;
7TlNCai?7T/N009?7PM6oP8f_P03=Yhf_SJn00`j_P06?]hj_SkN?[hngSZn1SkN00I2gSkN?]hngT;N
?]h3@]h013kN@]i2gT;n0d;N00Y2oT;N@]i2gT;n@]i2oT;N@_i2gP=2oP04@]i2oT;nA_h3@_h02TKn
@_i6oT;nA_i2oTKn@_i6oT;n0dKn00=2oTKnA_h07DKn00@004KnA_i6oP=oo`03001oogoo029oo`00
=Woo00<007ooOol02goo06E??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MA_i6oDLN0096oP0MA_dj_SJM>[hfWCZn=Ydj
_SJm>[hj_CZn>[dngSZm?]hj_CkN>[hngSZm?]hj_SkN?[dngSjn?]hn_@02?]h0>d;N?]e2gSkN@]hn
gD;n?]i2oSkM@_hngT;n?]e2oSkN@_hngD;n@]i2oT;M@_i2gT;n@]e6oT;N@_i2gDKn@]i6oT;NA_i2
gTKn@]i6oT;nA_i2gTKn@_i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAah00TKn00I2oTLNA_i6
oT;nAah2A_h03d;nAai6oTLNA_i77TKnAai6oT/NA_h004KnBai6oP03Ool00`00Oomoo`0ROol003Io
o`03001oogoo00aoo`=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/N
Cai?7TlNBah00dlN00I;7TlNCai?7T/NCah7A_h3=[h00cJN=[hj_P0;>[h01Cjn?]hj_SkN?[h023kN
00I2gSkN?]hngT;N?]h3@]h013kN@]i2gT;n0d;N00Y2oT;N@_i2gT;n@]i2oT;N@_i2gP=2oP04@]i2
oT;nA_h3@_h01TKn@_i6oT;nA_i2oP=6oP05@_i6oTKnA_i2oP0MA_h01000A_i6oTKn17oo00<007oo
Ool08Goo000fOol00`00Oomoo`0=Ool0`DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln@_i6oT;NA_i2oTKn=Ydj_SJM>[hf
WCZn>[dj_SJm>[hj_CkN>[dngSZn?]hj_CkN>[hngSZm?]hj_SkN?[dngSjn?]hn_D;N?]i2gSkM@]hn
gT;n?]e2oSkN@_hngD;n?]i2oSkM@_hngT;n@]e2oT;N@_i2gD;n@]i2oT;MA_i2gT;n@]e6oT;NA_i2
gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTLN0096oP06@_i7
7TKnA_i2oTLN0dKn00e77TKnAai6oTLNA_i77TKn0016oTLNA_i;7P03Ool00`00Oomoo`0QOol003Io
o`03001oogoo00ioo`=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/N
Cai?7TlNBah00dlN00E;7TlNCai?7T/N00=6oP05@_i6oTKnA_hfWP03=[h00cJN>[hj_P0:>[h013kN
?[hngSjn2SkN00=2gSkN?]h00T;N00DngT;N@]i2gSkN0092gP0:@_i2gT;N@]i2oT;N@_i2gT;n@]h3
@_h00d;N@_i2oP04@_h02TKn@_i2oT;nA_i2oTKn@_i6oT;n0dKn00=2oTKnA_h07DKn00<004KnA_h0
0TKn0goo00<007ooOol08Goo000fOol00`00Oomoo`0?Ool0L4lnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DKn@_i6oT;NA_i2
oSZn=Ydj_SJM>[hfWCZn>[dj_SJm0SZn00XngSZm?]hj_SkN>[dngSZn?]hj_@<ngP0n?[e2gSkN?]hn
gD;N?]i2gSkM@]hngT;n?]e2oSkN@_hngD;n@]i2oSkM@_i2gT;n@]e2oT;N@_i2gDKn@]i2oT;MA_i2
gTKn@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77P96oP06
@_i77TKnA_i2oTLN0TKn0112oTLNA_i77TKnAai6oTLNA_i;7TKn0016oT/NA_i77P=oo`03001oogoo
025oo`00=Woo00<007ooOol03goo00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;
7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?
7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00=;7T;n@_h014;n00@j_SJN=[hf_PPj_P06
?[hj_SZn>[hngSjn0ckN00<n_SkN?]h013kN00I2gSkN?]hngT;N?]h3@]h00ckN@]i2gP04@]h02T;n
@]i2gT;N@_i2gT;n@]i2oT;N0d;n00A2gT;n@_i6oP=2oP0:A_i2oTKn@_i6oT;nA_i2oTKn@_h3A_h0
0d;nA_i6oP0KA_h00`00A_i6oP03A_h3Ool00`00Oomoo`0POol003Ioo`03001oogoo011oo`1nBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlN@]i6oT;NA_i2gTKn=Ydj_SJM>[hfWCZn=[dj_SZm>[hf_CkN>[hngSZm?]hj_SkN>[dn
gSZn?]hj_D;N0SkN03hn_D;N?]i2gSkM@]hngT;N?]e2oSkN@_hngD;n?]i2oSkM@_i2gT;n?]e2oT;N
@_i2gD;n@]i2oT;MA_i2gT;n@]e6oT;NA_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2gTKn@_i6oT;N
A_i2oTKn@_i6oT;nA_i2oTLN0TKn00I2oTLNA_i6oT;nAah2A_h03d;nAai6oTLNA_i77TKnAai6oT/N
00177TKnBai6oP03Ool00`00Oomoo`0POol003Ioo`03001oogoo015oo`05Bai?7TlNCai;7P03Cah0
1D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?
7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7PI2oP03
=[hj_SJN008f_PPj_P03?]hj_SZn008ngP03?[hngSkN00PngP06@]hngSkN?]i2gSkN0d;N00@ngT;N
@]i2oP=2gP0:@_i2gT;n@]i2oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn0d;n00I6oT;nA_i2oTKn@_h3
A_h01D;nA_i6oTKn@_h074Kn00<004KnA_h00TKn0goo00<007ooOol087oo000fOol00`00Oomoo`0B
Ool0OT/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae2oSkN@_i2gT;n?]hj_SJM>[hfWCZn=Ydj_SJm>[hj_CZn>[dngSZn?]hj_CkN
>[hngSZm?]hj_SkN?[e2gP8ngP0i?[e2gSkN@]hngD;N?]i2gSkM@_hngT;n?]e2oT;N@_hngD;n@]i2
oT;M@_i2gT;n@]e2oT;NA_i2gDKn@]i6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@]i6
oT;nA_i2oTKn@_i6oT;n00=6oP06@_i77TKnA_i2oTLN0TKn0152oTLNA_i77TKnAai6oTLNA_i77TKn
Aah004/NA_i77TKn00=oo`03001oogoo021oo`00=Woo00<007ooOol04goo00E;7TlNCai?7T/N00=?
7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;
7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00TlN00I2
oT;N@_i2gT;n@]h2=[h00cZn=Yhf_P09>[h00ckN>[hngP02?]h00cjn?]hngP08?]h01T;N?]hngSkN
@]hngP=2gP04?]i2gT;N@_h3@]h01T;n@]i2oT;N@_i2gP=2oP03@]i2oT;n00A2oP0:A_i2oT;n@_i6
oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0LA_h00`00A_i6oP02A_h3Ool00`00Oomoo`0POol003Eoo`03
001oogoo01Eoo`1nBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci2gT;n?]i2oT;N@_hfWCZn=Ydj_SJM>[hj_CZn>[dj_SZm?]hj_CkN
>[hngSZm?]hj_SkN>[dngSZn?]hn_D;N0SkN03Xn_D;N?]i2gSkM@]hngT;n?]e2oSkN@_hngD;n@]i2
oSkM@_i2gT;n@]e2oT;N@_i2gDKn@]i6oT;MA_i2gTKn@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@]i6
oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77P96oP06@_i77TKnA_i2oTLN0TKn00m2oTLNA_i77TKnAai6
oTLNA_i;7P00Aai6oT/NA_h017oo00<007ooOol07goo000eOol00`00Oomoo`0EOol00dlNBai?7P02
Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN
Cai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P09
Bai?7SkN@]hngT;N?]hj_SJN008f_P03>[hfWSZn00Dj_P06?]hj_SZn>[hngSjn0ckN00<n_SkN?]h0
23kN00=2gSkN?]h00T;N00<ngT;N@]h014;N00Y2oT;N@]i2gT;n@]i2oT;N@_i2gP=2oP04@]i2oT;n
A_h3@_h02TKn@_i6oT;nA_i2oTKn@_i6oT;n0dKn00=2oTKnA_h06TKn00<004KnA_h00dKn0goo00<0
07ooOol07goo000eOol00`00Oomoo`0FOol0KTlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M@_hngT;n?]i2oSkN>[hfWCZn=Ydj_SZm
>[hj_CZn>[d2>[h02ckN>[dngSZn?]hj_CkN>[hngSZm@]h00SkN03hn_D;N?]hngSkM@]hngT;N?]e2
oSkN@_hngD;n?]i2oSkM@_i2gT;n?]e2oT;N@_i2gD;n@]i2oT;MA_i2gTKn@]e6oT;NA_i2gTKn@]i6
oT;NA_i2oTKn@]i6oT;nA_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTLN0TKn00I2oTLNA_i6oT;n
Aah2A_h03T;nAai6oTLNA_i77TKnAah004/NA_i77TKnBah3Ool00`00Oomoo`0OOol003Eoo`03001o
ogoo01Moo`03Cai;7TlN009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?
7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah0
1D/NCai?7TlNBah00dlN00U;7T;N?]i2gSkN@]hngSZn=Yh00SJn23Zn00HngSZn>[hj_SkN?[h3?]h0
0cjn?]hngP04?]h01T;N?]hngSkN@]hngP=2gP04?]i2gT;N@_h3@]h02T;n@]i2oT;N@_i2gT;n@]i2
oT;N0d;n00A2gT;n@_i6oP=2oP06A_i2oTKn@_i6oT;n0dKn00E2oTKnA_i6oT;n01Y6oP030016oTKn
00=6oP=oo`03001oogoo01moo`00=Goo00<007ooOol05goo061;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7SkN@]h3?]h06D;N=Ydj
_SJM>[hfWCZn>[dj_SZm>[hj_CkN>[hngSZm?]hj_SkN>[dngSZn?]hn_D;N008ngP0i?[e2gSkN@]hn
gD;N?]i2gSkM@_hngT;n?]e2oSkN@_hngD;n@]i2oSkM@_i2gT;n@]e2oT;NA_i2gDKn@]i6oT;MA_i2
gTKn@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;n00=6oP06@_i77TKnA_i2
oTLN0TKn0152oTLNA_i77TKnAai6oTLNA_i77P00Aai6oT/NA_i77TKn00=oo`03001oogoo01ioo`00
=Goo00<007ooOol067oo0TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN
Cai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05
Bai?7TlNCai;7P03Cah014/NCai?7TlN1SkN00Df_SZn=[hj_SJn00Pj_P03?]hj_SZn008ngP03?[hn
gSkN00PngP06@]hngSkN?]i2gSkN0d;N00@ngT;N@]i2oP=2gP06@_i2gT;n@]i2oT;N0d;n00=2gT;n
@_h014;n00Y6oT;n@_i2oTKn@_i6oT;nA_i2oP=6oP03@_i6oTKn01Y6oP030016oTKn00A6oP=oo`03
001oogoo01ioo`00=Goo00<007ooOol06Goo05e;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBad00SkN01e2gSkN?]hngSZn=Ydj_SJM>[hf
WCZn>[djgSZm>[hj_CkN>[hngSZm?]hj_SkN>[dngSZn?]hn_D;N008ngP0j?[e2gSkN@]hngD;n?]i2
oSkM@_hngT;n?]e2oT;N@_hngD;n@]i2oT;MA_i2gT;n@]e6oT;NA_i2gDKn@]i6oT;NA_i2gTKn@]i6
oT;nA_i2gTKn@_i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAah2A_h01T;nAai6oTKn@_i77P96
oP0?@_i77TKnAai6oTLNA_i77P00Bai6oTLNA_i;7TKn00=oo`03001oogoo01ioo`00=Goo00<007oo
Ool06Woo0TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;
7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?
7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;
7P03Cah01D/NCai?7SkN>]h00ckN00DjgSZn=[hj_SJn00Pj_P04?[hj_SkN>[h3?]h00cjn?]hngP08
?]h01T;N?]hngSkN@]hngP=2gP04?]i2gT;N@_h3@]h01T;n@]i2oT;N@_i2gP=2oP04@]i2oT;nA_h3
@_h02TKn@_i6oT;nA_i2oTKn@_i6oT;n0dKn00=2oTKnA_h064Kn00<004KnA_h014Kn0goo00<007oo
Ool07Woo000eOol00`00Oomoo`0KOol0Md/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCchj_SkN>[hngSZn?]hfWCZn=Ydj_SJM>[hj_CZn>[dj
gSZm?]hj_CkN>[hngSZm?]hn_SkN>[d00ckN03hn_D;N?]hngSkM@_hngT;N?]e2oSkN@_hngD;n?]i2
oSkM@_i2gT;n?]e2oT;N@_i2gDKn@]i2oT;MA_i2gTKn@]e6oT;NA_i2gTKn@]i6oT;NA_i2oTKn@]i6
oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;nA_i2oTLN0TKn01E2oTLNA_i77TKnAai6oTLNA_i77TKn
Aai6oTLN00177TKnBai6oTLNA_h00goo00<007ooOol07Woo000eOol00`00Oomoo`0LOol2Cah01D/N
Cai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7SkN
?]hjgP03?]h01CJn>[hf_SZn=[h01SZn00HngSZn?[hj_SkN?[h3?]h00cjn?]hngP06?]h014;N?]i2
gSkN0d;N00@ngT;N@]i2oP=2gP0:@_i2gT;n@]i2oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn0d;n00I6
oT;nA_i2oTKn@_h3A_h01D;nA_i6oTKn@_h064Kn00<004KnA_h014Kn17oo00<007ooOol07Goo000d
Ool00`00Oomoo`0NOol0H4/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCchj_SkN>[hngP8j_P0F=Ydj_SJM>[hfWC[N>[dj_SZm>]hj_SkN>[dn
gSZn?]hj_CkN?[hngSZm@]h2?]h0>Cjm@]hngT;N?]e2oSkN@]hngD;n?]i2oSkM@_hngT;n?]e2oT;N
@_hngDKn@]i2oT;MA_i2gTKn@]e6oT;NA_i2gDKn@]i6oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;n
A_i2oTKn@_i6oT;nA_i2oP03A_h00d;nAai6oP02A_h04dLNA_i77TKnAai6oTLNA_i77TKnAai6oP00
A_i77TKnBai6oTLN00=oo`03001oogoo01eoo`00=7oo00<007ooOol07Woo00@004lNCai;7P=?7P05
Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03
Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah02T/NCai?7TlNBai?7SZn>]hj_S[N
0SZn00<f_SZn=[h023Zn00HngSZn?[hj_SkN?[h:?]h01T;N?]i2gSkN@]hngP=2gP04?]i2gT;N@_h3
@]h01T;n@]i2oT;N@_i2gP=2oP05@]i2oT;n@_i2gP02@_h02TKn@_i2oT;nA_i2oTKn@_i6oT;n0dKn
00=2oTKnA_h06DKn00<004KnA_h014Kn0goo00<007ooOol07Goo000dOol00`00Oomoo`0OOol0NDln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
BadjgSZn>]hf_C[N=Ydj_SJM>[hfWCZn>[dngSZm>[hj_CkN>[hngSZm?]hn_SkN>[dngSjn?]hn_D;N
008ngP0j?[e2gSkN@]hngD;n?]i2oSkM@_hngT;n?]e2oT;N@_hngD;n@]i2oT;MA_i2gT;n@]e6oT;N
A_i2gDKn@]i6oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;n
Aah2A_h05T;nAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP00A_i;7TKnAai6oT/N0goo00<007oo
Ool07Goo000JOol3000GOol00`00Oomoo`0POol3Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/N
Cai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P03Bahj_SZn00Dj_P03=[hj_SZn00Hj_P05?[hj_SkN
>[hn_P0;?]h01T;N?]i2gSkN@]hngPQ2gP0:@_i2gT;N@]i2oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn
0d;n00Y6oT;nA_i2oTKn@_i6oT;nA_i2oP=6oP03@_i6oTKn01M6oP030016oTKn00E6oP=oo`03001o
ogoo01aoo`006goo00<007ooOol05Woo00<007ooOol08Goo0;E??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7SJm>]hj_S[N=[dj_SJM>[hfWCZn
=Ydj_SZm?]hj_CZn>[dngSZn?]hj_CkN?[hngSZm?]hn_T;N?[e2gSkN@]hn_D;n?]i2gSkM@_hngT;n
?]e2oSkN@_hngD;n@]i2oSkM@_i2gT;n@]e6oT;N@_i2gDKn@]i6oT;MA_i2gTKn@]i6oT;NA_i2gTKn
@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_i77P02A_h05D;nAai6oTLNA_i77TKn
Aai6oTLNA_i77TKn0016oTLNA_i;7TKnAai6oP03Ool00`00Oomoo`0LOol001Moo`<00003Ool007oo
01Moo`03001oogoo025oo`05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/N
Cai?7TlNBah00dlN00A;7TlNCahj_P<f_P03>[hf_SZn008j_P03=[hj_SZn00@j_P06?]hj_Sjn>[hn
gSZn33kN00A2gSkN@]hngPY2gP0:@_i2gT;N@]i2oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn0d;n00I6
oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0IA_h01000A_i6oTLN0dKn00E77WooOomoo`0001ioo`005Woo
00@007ooOomoo`8001Qoo`03001oogoo029oo`1eBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBadj_SJm>[hf_SZn=Ydj_SJM>[hfWCZn>[dj_SZm
?]hj_CkN>[dngSZn?]hj_CkN?[hngSZm008ngP0k@]hn_D;N?]i2gSkM@_hngT;N?]e2oSkN@_hngD;n
?]i2oSkM@_i2gT;n?]e2oT;N@_i2gDKn@]i2oT;MA_i2gTKn@]e6oT;NA_i2gTKn@]i6oT;NA_i2oTKn
@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77P02A_h00d;nAai6oP02A_h04TLNA_i77TKnAai6oTLN
A_i77TKn0016oT/NA_i77TKnBai6oP=oo`03001oogoo01aoo`005Woo00<007ooOol00Woo00<007oo
Ool05Woo00<007ooOol08goo00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN
Cai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05
Bai?7TlNCai;7P03Cah014/NCahf_SZn0cJn00<j_SJn>[h00SZn00<f_SZn>[h013Zn00@ngSZn?[hj
_P`ngP06@]hngT;N?]i2gSkN1T;N00i2oT;N@]i2gT;n@]i2oT;N@_i2gT;n@]i2oT;N0d;n00A2gT;n
@_i6oP=2oP03A_i2oTKn0096oP05@_i6oTKnA_i2oP0IA_h00`00A_i6oP02A_h00dLNA_i6oP04Ool0
0`00Oomoo`0KOol001Ioo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo02Aoo`2bBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln=Ydf_SJM
>[hfWCZn=Ydj_SJM>[hfWCkN>[dj_SZm?]hj_SkN>[dngSZn?]hj_CkN?[hngSZm@]hngT;N?[e2gSkN
@]hngD;n?]i2gSkM@_hngT;n?]e2oT;N@_hngD;n@]i2oT;MA_i2gT;n@]e6oT;NA_i2gDKn@]i6oT;N
A_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAah2A_h05D;nAai6
oTLNA_i77TKnAai6oTLNA_i77TKn0016oTLNA_i;7TKnAai6oP04Ool00`00Oomoo`0KOol001Ioo`04
001oogooOol2000HOol00`00Oomoo`0UOol01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05
Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03
Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7SJn=[hfWP02=[h00cZn=[hj_P07>[h01SkN>[hngSZn
?]hj_P`ngP04@]hngT;N?]h8@]h02T;n@]i2gT;N@_i2gT;n@]i2oT;N0d;n00=2gT;n@_h00T;n00A6
oT;nA_i2oP=6oP05@_i6oTKnA_i2oP03A_h00d;nA_i6oP0EA_h01000A_i6oTLN0dKn00=77TKnOol0
0Woo00<007ooOol06goo000GOol300000goo0000000GOol00`00Oomoo`0UOol0/dlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?7T/MCai;7CZn=Ydf_SJM>[hf
_CZn=Ydj_SJm>[hj_CkN>[dj_SZm?]hj_SkN>[dngSjn?]hj_CkN?[hngSkM@]hngT;N?]e2gSkN@]hn
gD;n?]i2oSkM@_hngT;n?]e2oT;N@_hngD;n@]i2oT;MA_i2gT;n@]e6oT;NA_i2gDKn@]i6oT;NA_i2
gTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN@_i6oT;nAah00TKn01A2oTLNA_i7
7TKnAai6oTLNA_i77TKn0016oTLNA_i77TKnBai6oTLN0goo00<007ooOol06goo000cOol00`00Oomo
o`0WOol00dlNBai?7P02Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;
7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00Y;
7TlNBai?7T/N=[hfWSJn=Ydf_P8j_P03=[hj_SZn00Hj_P04?]hn_SkN>[h<?]h01T;N?]i2gSkN@]hn
gPI2gP04@_i2gT;n@]h3@_h01D;N@_i2oT;n@]h00T;n00Y6oT;N@_i2oTKn@_i6oT;nA_i2oP=6oP03
@_i6oTKn01]6oP030016oTKn0096oP04Aai6oTKnA_h3Ool00`00Oomoo`0KOol003=oo`03001oogoo
02Qoo`2_Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlN
Bae?7SJM>[hfWCJn=Ydj_SJm>[hfWCZn=[dngSZm?]hj_CkN>[dngSZn?]hj_CkN?[hngSZm?]hn_T;N
?]e2gSkN@]hngD;n?]i2gSkM@_hngT;n?]e2oSkN@_i2gD;n@]i2oT;M@_i2gT;n@]e6oT;N@_i2gDKn
@]i6oT;MA_i2gTKn@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAah00TKn
00=2oTLNA_h00TKn01977TKnAai6oTLNA_i77TKn0016oTLNA_i;7TKnAai6oT/NA_h3Ool00`00Oomo
o`0JOol003=oo`03001oogoo02Uoo`03Cai;7TlN009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN
Cai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P06
Bai?7TlNCai;7TlN1T/N00DfWCJn=Yhf_SJM00Xj_P06?]hj_SkN?[hngSZn33kN00A2gSkN@]hngPI2
gP06@_i2gT;n@]i2oT;N0d;n00E2gT;n@_i6oT;N0092oP0:A_i2gTKn@_i6oT;nA_i2oTKn@_h3A_h0
0d;nA_i6oP0IA_h00`00A_i6oP04A_h00dLNA_i6oP03Ool00`00Oomoo`0JOol003=oo`03001oogoo
02Yoo`1CCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??P02Bah07D[m
Cai;7SJn=Ydj_SJM=[hfWCZn=[dj_SJM>[hj_CkN>[dngSZm?]hj_CkN>[hngSjm?]hn_SkN?[d00SkN
03]2gSkM@]hngT;N?]e2oSkN@]hngD;n?]i2oSkM@_hngT;n@]e2oT;N@_i2gDKn@]i2oT;MA_i2gTKn
@]e6oT;NA_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN
0096oP0E@_i77TKnAai6oTLNA_i77TKnAai6oTLN00177TKnAai6oT/NA_i77TKn00=oo`03001oogoo
01Yoo`00<goo00<007ooOol0:Woo0TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/N
Cai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7PM;7P05=[hfWCJn=Yhf_P0:>[h01Cjn?]hj_SkN?[h033kN00A2gSkN@]hngPQ2gP06@_i2gT;n
@]i2oT;N0d;n00A2gT;n@_i6oP=2oP06A_i2oTKn@_i6oT;n0dKn00=2oTKnA_h074Kn00D004KnA_i6
oTLN00=6oP05AaioogooOol0000LOol003=oo`03001oogoo02]oo`2`Bae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7D/NA_i;7TKmBai6oSZn=Ydj_SJM>[hfWCZn=[dj_SJM
?]hj_CkN>[dngSZn?]hj_CkN>[hngSjm?]hn_SkN?[e2gSkN@]hngD;N?]i2gSkM@_hngT;N?]e2oSkN
@_hngD;n@]i2oT;M@_i2gT;n@]e6oT;N@_i2gDKn@]i6oT;MA_i2gTKn@]i6oT;NA_i2gTKn@_i6oT;N
A_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAai2oTKn@_i77P96oP0C@_i77TKnAai6oTLNA_i77TKnAah0
04LNA_i;7TKnAai6oT/NA_h017oo00<007ooOol06Goo000cOol00`00Oomoo`0/Ool2Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;
7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?
7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00]:oT/NBai;7T[nBahfWSJn=Ydf_SJN00Xj
_P06?]hn_SkN>[hngSjn33kN00E2gSkN@]hngT;n00=2gP0:@_i2gT;n@]i2oT;N@_i2gT;n@]h3@_h0
14;N@_i2oTKn0d;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0JA_h00`00A_i6oP03A_h014LNA_i6
oTKn0goo00<007ooOol06Goo000cOol00`00Oomoo`0]Ool0[4/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNA_e;7TKnBai6oCZn=Ydj_SJM>[hfWCZn=Ydj_SJm>[hj_CkN>[dn
gSZm?]hj_SkN>[dngSjn?]hn_CkN?[hngSkM@]hngT;N?]e2gSkN@]hngD;n?]i2oSkM@_hngT;n@]e2
oT;N@_i2gD;n@]i2oT;MA_i2gT;n@]e6oT;NA_i2gDKn@]i6oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6
oT;nA_i2oTKn@_i77T;nA_i2oTLN0TKn00=2oTLNA_h00TKn01577TKnAai6oTLNA_i77P00Aai6oTLN
A_i;7TKnAai6oT/N00=oo`03001oogoo01Uoo`00<goo00<007ooOol0;Woo0TlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/N
Cai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P=6oP07Bai6oSJn=Yhf_SJM=[h02cZn00@ngSjn?]hj
_P`ngP=2gP04?]i2gT;N@_h3@]h01T;n@]i2oT;N@_i2gP=2oP04@]i2oT;nA_h3@_h02TKn@_i6oT;n
A_i2oTKn@_i6oT;n0dKn00=2oTKnA_h064Kn00D004KnA_i6oTLN00=6oP03Aai6oWoo009oo`03001o
ogoo01Uoo`00<goo00<007ooOol0;Woo071??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7D/NA_e;7TKnBahfWCZn=Ydj_SJM>[hj_CZn=Ydj_SZm?]hj_CkN>[dngSZm?]hj_SkN
>[dngSjn?]hn_@8ngP0g@]hngD;N?]i2gSkM@_hngT;N?]e2oSkN@_hngD;n?]i2oT;M@_i2gT;n@]e6
oT;N@_i2gDKn@]i6oT;MA_i2gTKn@]e6oT;NA_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6
oT;nAah00TKn01U2oTLNA_i6oT;nAai6oTLNA_i77TKnAai6oTLN00177TKnAai6oTLNA_i;7TKnAai6
oP03Ool00`00Oomoo`0HOol0039oo`03001oogoo031oo`=?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;
7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?
7P05Bai?7TlNCai;7P02Cah5A_h01CJN=[hfWSJn=Yh02SZn00@ngSjn?]hn_PPngP06@]hngSkN?]i2
gSkN0d;N00@ngT;N@]i2oP=2gP06@_i2gT;n@]i2oT;N0d;n00A2gT;n@_i6oP=2oP06A_i2oTKn@_i6
oT;n0dKn00=2oTKnA_h05TKn1@001DKn00E77TKnA_i6oTLN00=oo`03001oogoo01Qoo`00<Woo00<0
07ooOol0<Goo0:E??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci6oTLNA_e7
7TKnAahfWCZn=Ydj_SJm>[hj_CZn=[dngSZm?]hj_CkN>[dngSZm?]hj_SkN?[dngSjn?]hn_D;N?]i2
gSkM@]hngT;N?]e2oSkN@]hngD;n?]i2oSkM@_i2gT;n@]e2oT;N@_i2gDKn@]i2oT;MA_i2gTKn@]e6
oT;NA_i2gTKn@_i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAah00TKn00=2oTLN00002@0000m6
oTLNA_i77P00Bai6oTLNA_i;7TKnAai6oT/NA_h00goo00<007ooOol067oo000bOol00`00Oomoo`0b
Ool3Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;
7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01T/NCai?7TlNBai?7P96oP08@_i6oTKn>[hfWSJn
=Yhf_PLj_P08?[hj_SZn?[hngSjn?]hn_PPngP03@]hngSkN0092gP03?]i2gT;N00A2gP0:@_i2gT;n
@]i2oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn0d;n00I6oT;nA_i2oTKn@_h3A_h014;nA_i6oTKn2@00
3dKn00<004KnA_h014Kn00=77TKnA_h00goo00<007ooOol067oo000bOol00`00Oomoo`0cOol0U4ln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae6oT;nA_i2gTKn@_hj_SJM>[hfWCZn
=[dj_SZm>[hj_CkN>[dngSZm?]hj_SkN>[dngSZn?]hn_D;N?[hngSkM@]hngT;N?]e2gSkN@]hngD;n
?]i2gSkM@_i2gT;n?]e2oT;N@_i2gD;n@]i2oT;MA_i2gT;n@]e6oT;NA_i2gDKn@_i6oT;N2P0000M6
oT;nA_i2oTKn@_i77P02A_h06D;nAai6oTKn@_i77TKnAai6oTLNA_i77TKnBai6oP00A_i;7TKnAai6
oT/NA_i77TKn00=oo`03001oogoo01Qoo`00<Woo00<007ooOol0<goo00E;7TlNCai?7T/N00=?7P05
Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03
Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P09Bai6oTKnA_i2oTKn=[hj_SJN008f_PPj_P08?[hj_SkN?[hn
gSjn?]hn_P@ngP06@]hngSkN?]i2gSkN0d;N00@ngT;N@]i2oP=2gP06@_i2gT;n@]i2oT;N0d;n00=2
gT;n@_h02@0000E2oTKn@_i6oT;n00=6oP03@_i6oTKn01M6oP030016oTKn0096oP06Aai6oTKnA_i7
7TKn0goo00<007ooOol05goo000bOol00`00Oomoo`0dOol0P4/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DKn@]i2oT;NA_hfWCZn=Ydj_SJM>[hf_CZn>[dj_SZm?]hj_CkN>[dn
gSZn?]hj_CkN?[hngSjm@]hn_T;N?]e2gSkN@]hngD;n?]i2oSkM@_i2gT;n?]e2oT;N@_h:00005d;N
A_i2gDKn@]i6oT;MA_i2oTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_h00dKn00I2oTLNA_i6oT;n
Aah2A_h054;nAai6oTLNA_i77TKnAai6oP00A_i77TKnBai6oTLNA_i;7TKnAah3Ool00`00Oomoo`0G
Ool0039oo`03001oogoo03Eoo`05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?
7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah5
@_h2=[h00cZn=Yhf_P05>[h013jn>[hj_SZn0Sjn00@ngSjn?]hn_PHngP07@]hngSkN?]i2gSkN@]h0
2@0000I2oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn0d;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0J
A_h00`00A_i6oP03A_h014LNA_i6oTKn0goo00<007ooOol05goo000bOol00`00Oomoo`0fOol0Jd/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCahngT;n?]i2oSkN>[hfWCZn=Ydj_SZm
>[hj_CZn>[dngSZm?]hj_CkN>[dngSZn?]hj_D;N?]h02P0002e2oSkN@_hngD;n@]i2oSkM@_i2gT;n
@]e2oT;N@_i2gDKn@]i6oT;MA_i2gTKn@]e6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn
@_i6oT;nAah00TKn00I2oTLNA_i6oT;nAah2A_h04T;nAai6oTLNA_i77TKnAah004/NA_i77TKnBai6
oTLNA_i;7P=oo`03001oogoo01Moo`00<Woo00<007ooOol0=goo00E;7TlNCai?7T/N00=?7P05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah0
1D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N009?7P0:@_i2gT;n@]i2oSJN>[hf_SZn=Yh6>[h00cjn>[h000080005?]h0
1T;N?]hngSkN@]hngP=2gP04?]i2gT;N@_h3@]h01T;n@]i2oT;N@_i2gP=2oP04@]i2oT;nA_h3@_h0
1TKn@_i6oT;nA_i2oP=6oP03@_i6oTKn01Q6oP050016oTKnA_i77P03A_h00dLNA_ioo`03Ool00`00
Oomoo`0FOol0039oo`03001oogoo03Qoo`1FBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae2oSkN@_hngT;n=Ydj_PX0000:>[dngSZm?]hj_CkN>[hngSjm@]h2?]h0=Sjm@]hngT;N?]e2
gSkN@_hngD;n?]i2oSkM@_i2gT;n?]e2oT;N@_i2gD;n@]i6oT;MA_i2gTKn@]e6oT;NA_i2gDKn@]i6
oT;NA_i2oTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77P96oP0I@_i77TKnA_i2oTLNA_i77TKn
Aai6oTLNA_i;7P00Aai6oT/NA_i77TKnBai6oTLNA_h00goo00<007ooOol05Woo000aOol00`00Oomo
o`0iOol00`00Bai?7P02Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;
7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah900000cZn=[hj_P07>[h00ckN
>[hj_P02?]h00cjn?]hngP08?]h00d;N?]hngP02@]h00ckN@]i2gP04@]h01T;n@]i2oT;N@_i2gP=2
oP03@]i2oT;n00A2oP0:A_i2oT;n@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0GA_h00`00A_i6oP02
A_h01DLNA_i6oTKnAah00goo00<007ooOol05Woo000aOol00`00Oomoo`0jOol0@TlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7@X0000OCai;7Dln?]i2oSkN@_hngSZn=Ydj_SJM>[hj_CZn>[dj_SZm?]hj_CkN>[dngSZn?]hj_CkN
>[hngSjm@]h00SkN034ngD;N?]i2gSkM@_hngT;n?]e2oSkN@_hngD;n@]i2oT;M@_i2gT;n@]e2oT;N
A_i2gDKn@]i6oT;MA_i2gTKn@]e6oT;nA_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oP03A_h01T;n
Aai6oTKn@_i77P96oP0D@_i77TKnAai6oTLNA_i77TKn0016oTLNA_i;7TKnAai6oT/NA_i77P9oo`03
001oogoo01Ioo`00<Goo00<007ooOol0>goo00=?7T/NCah00TlN00E;7TlNCai?7T/N00=?7P05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah0
1D/NCai?7TlNBah00dlN00=;7TlNCah02@0000E;7TlNCai?7T/N00=?7P06Bai?7TlNCai;7TlN13kN
00Df_SZn=[hj_SJn00Hj_P04?[hj_SkN>[h3?]h00cjn?]hngP08?]h00d;N?]i2gP02@]h013kN@]i2
gT;n0d;N00I2oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn0d;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6
oP0IA_h00`00A_i6oP04A_h014LNA_i6oTKn0goo00<007ooOol05Goo000aOol00`00Oomoo`0lOol0
;TlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M2@0001M;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/M00<ngP0F>[hngSJM>[hfWCZn>[dj_SZm>]hj_CZn>[dngSZm
?]hj_CkN?[hngSZm@]h2?]h0=Sjm@]hngT;N?]e2gSkN@]hngD;n?]i2oSkM@_i2gT;n?]e2oT;N@_i2
gDKn@]i2oT;MA_i2gTKn@]e6oT;NA_i2gDKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2
oTKn@_i77P96oP06@_i77TKnA_i2oTLN0dKn01577TKnAai6oTLNA_h004KnBai6oTLNA_i;7TKnAai6
oT/N00=oo`03001oogoo01Eoo`00<Goo00<007ooOol0?7oo0TlN00E;7TlNCai?7T/N00=?7P05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P03Bai?7P0000T00005Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah0
14/N>]hjgSkN0SZn00<f_SZn=[h01SZn00HngSZn?[hj_SkN?[h3?]h00cjn?]hngP04?]h01T;N?]i2
gSkN@]hngP=2gP04?]i2gT;N@_h3@]h01T;n@]i2oT;N@_i2gP=2oP04@]i2oT;nA_h3@_h01TKn@_i6
oT;nA_i2oP=6oP03@_i6oTKn01Q6oP050016oTKnA_i77P03A_h00dLNA_h00003000GOol0035oo`03
001oogoo03eoo`0JBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7PT0000_Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCahj_SkN>[hngP02>[h053JM>[hfWC[N>[dj
_SZm>]hj_CkN>[dngSZm?]hj_CkN?[hngSjm@]h2?]h0=Sjm@]hngT;N?]e2oSkN@_hngD;n?]i2oSkM
@_i2gT;n?]e6oT;N@_i2gDKn@]i6oT;MA_i2gTKn@]e6oT;NA_i2gDKn@_i6oT;NA_i2oTKn@]i6oT;n
A_i2gTKn@_i6oT;nA_i2oTKn@_i77P96oP03@_i77TKn0096oP0CAai6oTLNA_i77TKnAai6oT/N0017
7TKnBai6oTLNA_i;7TKnAah00goo00<007ooOol05Goo000aOol00`00Oomoo`0nOol2Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00X00003Cai;7TlN009?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;
7TlNCai?7T/N00=?7P<j_P03>]hf_SZn008j_P03=[hj_SZn00@j_P06?]hj_Sjn>[hngSjn23kN00A2
gSkN@]hngP=2gP03?]i2gT;N00A2gP0:@_i2gT;n@]i2oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn0d;n
00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0FA_h00`00A_i6oP03A_h01DLNA_i6oTKnAah00Woo00<0
07ooOol05Goo000aOol00`00Oomoo`0oOol01D/MCai;7DlnBad02@0008e;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBadjgSZn>]hj_S[N
=Ydj_SJM>[hfWCkN>[dj_SZm?]hj_CkN>[dngSjn?]hj_CkN?[hngSjm@]hngT;N?[e2oSkN@]hngD;n
?]i2oSkM@_hngT;n?]e2oT;N@_i2gDKn@]i2oT;MA_i2gTKn@]e6oT;NA_i2gDKn@]i6oT;MA_i2oTKn
@]i6oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_h00dKn00=2oTLNA_h00TKn01I77TKnA_i6oTLNA_i77TKn
Aai6oTLNA_h004KnAai6oT/NA_i77TKnBai6oP9oo`03001oogoo01Eoo`00<Goo00<007ooOol0>Woo
2P000TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN
Cai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05
Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00TlN00Hj_SJn>[hf_SZn=[h3>[h00cJn>[hj_P02>[h0
1Cjn>[hngSZn?[h00SkN00<n_SkN?]h01SkN00A2gSkN@]hngPI2gP0:@_i2gT;N@]i2oT;N@_i2gT;n
@]h3@_h014;N@_i2oTKn0d;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0IA_h00`00A_i6oP04A_h0
0dLNA_i6oP02Ool00`00Oomoo`0EOol0035oo`03001oogoo035oo`T000Ioo`2M001;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??SJn>[hf_CZn=[hj_SJM>[hfWCZn>[dngSZm>[hj_CkN>[dngSZm
?]hn_SkN>[dngSjn@]hn_D;N?]i2gSkM@_hngT;N?]e2oSkN@_hngD;n@]i2oSkM@_i2gT;n@]e6oT;N
@_i2gDKn@]i6oT;MA_i2gTKn@]e6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;n
Aah00TKn01U2oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h004KnBai6oTLNA_i;7TKnAai6oP02
Ool00`00Oomoo`0EOol0031oo`03001oogoo02Qoo`X0011oo`04001?7TlNBah3Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN
Cai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P0;
Bai?7TlNCai;7TlN=[hj_SJn>[hf_P0:>[h013jn>[hngSZn2SkN00A2gSkN@]hngPQ2gP0:@_i2gT;N
@]i2oT;N@_i2gT;n@]h3@_h03D;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;n00=6oP03@_i6oTKn01M6
oP030016oTKn0096oP05Aai6oTKnA_i77P02Ool00`00Oomoo`0EOol0031oo`03001oogoo01moo`T0
01]oo`1TCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??SJN=[hfWCZn=Ydj_SJM>[hfWCZn
>[dngSZm?]hj_CkN>[hngSZm?]hn_SkN>[d2?]h0=d;N?[e2gSkN@]hngD;n?]i2oSkM@_hngT;n?]e2
oT;N@_hngD;n@]i2oT;MA_i2gT;n@]e6oT;NA_i2gDKn@]i6oT;MA_i2gTKn@]i6oT;nA_i2oTKn@_i6
oT;nA_i2oTKn@_i6oT;nA_i2oTLN0096oP0H@_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i;7P00Aai6
oT/NA_i77TKnBai6oTLN0Woo00<007ooOol057oo000`Ool00`00Oomoo`0EOol:000UOol3Cah01D/N
Cai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah00d/N=[hf_P03=[h9>[h013kN>[hn_Sjn33kN00A2gSkN@]hngPQ2
gP0:@_i2gT;N@]i2oT;N@_i2gT;n@]h4@_h014Kn@_i6oT;n0dKn00E2oTKnA_i6oT;n00=6oP03@_i6
oTKn01I6oP030016oTKn00=6oP04Aai6oTKnA_h2Ool00`00Oomoo`0DOol0031oo`03001oogoo00ao
o`T002moo`2JBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?7T/MCai;7CZn=Ydj_SJM>[hf_CZn=Ydj
_SZm?[hj_CkN>[hngSZm?]hj_SkN>[dngSjn?]hj_D;N?]i2gSjm@]hngT;N?]e2oSkN@_hngD;n?]i2
oT;M@_i2gT;n@]e6oT;N@_i2gDKn@]i6oT;MA_i2gTKn@]e6oT;NA_i2gDKn@_i6oT;NA_i2oTKn@_i6
oT;nA_i2oTLN@_i6oT;nAah2A_h00d;nAai6oP02A_h05DLNA_i77TKnAai6oTLNA_i77TKnAah004/N
A_i77TKnBai6oTLNA_i;7P02Ool00`00Oomoo`0DOol0031oo`03001oogoo009oo`X003Uoo`05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah0
1D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P09Bai?7T/NCahfWCJn=Yhf_SJM00Tj_P05?[hngSZn?]hn_P0:?]h0
14;N?]i2gSkN2T;N00I2oT;N@_i2gT;n@]h3@_h02D;N@_i2oTKn@_i6oT;nA_i2oP03A_h00d;nA_i6
oP0LA_h01@00A_i6oTKnAah00dKn00E77TKnOomoo`0001Ioo`00<7oo1@00A7oo045;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
00P000Moo`1:=Ydj_SJm>[hfWCkN>[dn_SZm?]hj_SkN>[dngSZn?]hn_CkN?[hngSkM@]hngT;N?]e2
oSkN@]hngD;n?]i2oSkM@_hngT;n@]e2oT;N@_i2gDKn@]i2oT;MA_i2gTKn@]e6oT;NA_i2gDKn@]i6
oT;MA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77P96oP0K@_i77TKnAai6oTLNA_i77TKn
Aai6oTLNA_i;7TKn0016oT/NA_i77TKnBai6oTLNA_ioo`0001Ioo`00<Goo00<007ooOol0AWoo00E;
7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?
7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00I;7TlNCai?7T/NCah7000GOol5>[h013kN
?[hngSZn33kN00A2gSkN@]hngPI2gP0:@_i2gT;n@]i2oT;N@_i2gT;n@]h2@_h02TKn@]i2oT;nA_i2
oTKn@_i6oT;n0dKn00=2oTKnA_h06dKn00<004LNA_h00TKn00M77TKnA_i6oTLNOol0000FOol0039o
o`03001oogoo04Ioo`0[Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBad01`009Woo048j_CkN>[hngSZm
?]hn_SkN?[dngSjn@]hngD;N?]i2gSkM@_hngT;N?]e2oSkN@_hngD;n@]i2oT;M@_i2gT;n@]e6oT;N
@_i2gDKn@]i6oT;MA_i2gTKn@]e6oT;NA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN@_i6oT;n
Aah2A_h06D;nAai6oTLNA_i77TKnAai6oTLNA_i77TKn0016oTLNA_i;7TKnAai6oT/NA_ioo`0001Io
o`00<goo00<007ooOol0AWoo00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7PL003Ioo`XngP03@]hngT;N00M2gP04@_i2gT;n@]h3@_h01D;N
@_i2oT;n@]h00T;n00I6oT;NA_i2oTKn@_h3A_h00d;nA_i6oP0LA_h01DLN0016oTKnAah00dKn00E7
7TKnA_ioo`0001Ioo`00=7oo00<007ooOol0AGoo01I?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7@H004]oo`0`?]i2gSkM@_hngT;n?]e2oSkN@_hngD;n@]i2oT;M@_i2gT;n
@]e6oT;NA_i2gDKn@]i6oT;MA_i2gTKn@]e6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN
0TKn01]2oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77P00Bai6oTLNA_i;7TKnAai6oWoo0000
5Woo000eOol00`00Oomoo`15Ool00dlNBai?7P02Cah01T/NCai?7TlNBai?7PH0061oo`05@]i2oT;N
@_i2gP03@_h014;N@_i2oTKn0d;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0LA_h01@00A_i6oTKn
Aah00dKn00=77TKn00005Woo000fOol00`00Oomoo`15Ool6001jOol04dKn@]e6oT;NA_i2gTKn@_i6
oT;NA_i2oTKn@_i6oT;nA_i2oTLN0096oP0M@_i77TKnA_i2oTLNA_i77TKnAai6oTLNA_i77TKnAai6
oT/N00177TKnBai6oT/NA_i;7TKnBah0000FOol003Moo`03001oogoo04Aoo`03001oogoo0:Aoo`03
001oogoo00Moo`03001oogoo01Aoo`00>7oo00<007ooOol0@goo00<007ooOol0YGoo00<007ooOol0
1Woo00<007ooOol057oo000iOol00`00Oomoo`12Ool00`00Oomoo`2UOol00`00Oomoo`06Ool00`00
Oomoo`0DOol003Yoo`03001oogoo045oo`03001oogoo0:Eoo`03001oogoo00Moo`03001oogoo01=o
o`00>goo00<007ooOol0@7oo00<007ooOol0YWoo00<007ooOol01Woo00<007ooOol04goo000lOol0
0`00Oomoo`0oOol00`00Oomoo`2VOol00`00Oomoo`06Ool00`00Oomoo`0COol003eoo`03001oogoo
03ioo`03001oogoo0:Ioo`03001oogoo00Ioo`03001oogoo01=oo`00?Woo00<007ooOol0?Goo00<0
07ooOol0YWoo00<007ooOol01Woo00<007ooOol04goo000oOol00`00Oomoo`0lOol00`00Oomoo`2W
Ool00`00Oomoo`05Ool00`00Oomoo`0COol0041oo`03001oogoo03]oo`03001oogoo0:Moo`03001o
ogoo00Eoo`03001oogoo01=oo`00@Goo00<007ooOol0>Woo00<007ooOol0Ygoo00<007ooOol01Goo
00<007ooOol04goo0012Ool2000iOol00`00Oomoo`2XOol00`00Oomoo`05Ool00`00Oomoo`0COol0
04Aoo`03001oogoo03Ioo`03001oogoo0:Uoo`03001oogoo00Aoo`03001oogoo01=oo`00AGoo00<0
07ooOol0=Goo00<007ooOol0ZGoo00<007ooOol017oo00<007ooOol04goo0016Ool00`00Oomoo`0d
Ool00`00Oomoo`2YOol00`00Oomoo`04Ool00`00Oomoo`0COol004Moo`03001oogoo03=oo`03001o
ogoo0:Uoo`03001oogoo00Aoo`03001oogoo01=oo`00B7oo00<007ooOol0<Woo00<007ooOol0ZWoo
00<007ooOol00goo00<007ooOol04goo0019Ool00`00Oomoo`0aOol00`00Oomoo`2ZOol00`00Oomo
o`04Ool00`00Oomoo`0BOol004Yoo`03001oogoo031oo`03001oogoo0:Yoo`03001oogoo00Aoo`03
001oogoo019oo`00Bgoo00<007ooOol0;goo00<007ooOol0Zgoo00<007ooOol00goo00<007ooOol0
4Woo001<Ool00`00Oomoo`0^Ool00`00Oomoo`2[Ool00`00Oomoo`03Ool00`00Oomoo`0BOol004eo
o`03001oogoo02eoo`03001oogoo0:]oo`03001oogoo00=oo`03001oogoo019oo`00CWoo00<007oo
Ool0;7oo00<007ooOol0Zgoo00<007ooOol00goo00<007ooOol04Woo001?Ool00`00Oomoo`0[Ool0
0`00Oomoo`2/Ool00`00Oomoo`02Ool00`00Oomoo`0BOol0051oo`03001oogoo02Yoo`03001oogoo
0:aoo`03001oogoo009oo`03001oogoo019oo`00DGoo00<007ooOol0:Goo00<007ooOol0[7oo00<0
07ooOol00Woo00<007ooOol04Woo001BOol00`00Oomoo`0XOol00`00Oomoo`2/Ool00`00Oomoo`02
Ool00`00Oomoo`0BOol005=oo`03001oogoo02Moo`03001oogoo0:eoo`05001oogooOol0000DOol0
05Aoo`03001oogoo02Ioo`03001oogoo0:eoo`05001oogooOol0000DOol005Eoo`03001oogoo02Eo
o`03001oogoo0:eoo`05001oogooOol0000DOol005Ioo`03001oogoo02Aoo`03001oogoo0:eoo`05
001oogooOol0000DOol005Moo`03001oogoo02=oo`03001oogoo0:ioo`05001oogooOol0000COol0
05Qoo`03001oogoo029oo`03001oogoo0:ioo`05001oogooOol0000COol005Uoo`03001oogoo021o
o`03001oogoo0:moo`05001oogooOol0000COol005Yoo`03001oogoo01moo`03001oogoo0:moo`05
001oogooOol0000COol005]oo`03001oogoo01ioo`03001oogoo0;1oo`04001oogoo000COol005ao
o`03001oogoo01eoo`03001oogoo0;1oo`04001oogoo000COol005eoo`03001oogoo01aoo`03001o
ogoo0;1oo`04001oogoo000COol005ioo`03001oogoo01]oo`03001oogoo0;5oo`03001oo`0001=o
o`00Ggoo00<007ooOol06Woo00<007ooOol0/Goo00<007oo00004goo001POol00`00Oomoo`0IOol0
0`00Oomoo`2aOol00`00Ool0000COol0065oo`03001oogoo01Qoo`03001oogoo0;5oo`03001oo`00
01=oo`00HWoo00<007ooOol05goo00<007ooOol0/Woo0P004goo001SOol00`00Oomoo`0FOol00`00
Oomoo`2bOol2000COol006Aoo`03001oogoo01Eoo`03001oogoo0;9oo`8001=oo`00IGoo00<007oo
Ool057oo00<007ooOol0/Woo00<007oo00004Woo001VOol00`00Oomoo`0COol00`00Oomoo`2cOol2
000BOol006Moo`03001oogoo019oo`03001oogoo0;=oo`80019oo`00J7oo0P004Woo00<007ooOol0
/goo0P004Woo001ZOol00`00Oomoo`0?Ool00`00Oomoo`2cOol2000BOol006]oo`03001oogoo00io
o`03001oogoo0;Aoo`03001oogoo011oo`00K7oo00<007ooOol03Goo00<007ooOol0[Woo1`004Woo
001]Ool00`00Oomoo`0<Ool00`00Oomoo`2ROol<000IOol006ioo`03001oogoo00]oo`03001oogoo
09Ioo``002Eoo`00Kgoo00<007ooOol02Woo00<007ooOol0RWoo3000<Goo001`Ool00`00Oomoo`08
Ool00`00Oomoo`1nOol=000mOol0075oo`03001oogoo00Moo`03001oogoo079oo``004Yoo`00LWoo
00<007ooOol01Woo00<007ooOol0IWoo3000EWoo001cOol00`00Oomoo`05Ool00`00Oomoo`1JOol<
001ROol007Aoo`03001oogoo00Aoo`03001oogoo04eoo`d006ioo`00EWoo0`0077oo00<007ooOol0
0goo00<007ooOol0@Goo3000Ngoo001GOol00`00Oomoo`0LOol00`00Oomoo`02Ool00`00Oomoo`0e
Ool<0027Ool005Moo`@001aoo`05001oogooOol0000ZOol=002COol005Moo`05001oogooOol0000L
Ool01000Oomoo`007Woo3000X7oo001GOol01@00Oomoogoo00007Goo00<007oo00004Woo3000[7oo
001GOol01@00Oomoogoo00007Woo0P001Woo3000^7oo001GOol20002Ool00`00Oomoo`0MOol70034
Ool005Ioo`800003Ool000000>]oo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7
Ool00?moodMoo`00ogooAgoo002LOol20002Ool2000:Ool40005Ool20005Ool40004Ool5001mOol0
09eoo`04001oogoo0002Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`03Ool00`00Oomoo`1mOol009ioo`8000]oo`03001oogoo009oo`03001oogoo
00Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo07eoo`00WWoo0P000goo1P000Woo00<0
07ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0OGoo002M
Ool01000Oomoo`002Woo00<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<007ooOol0
0goo00<007ooOol0OGoo002LOol20002Ool20009Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`1mOol00:]oo`03001oogoo009oo`03001oogoo00Qo
o`03001oogoo009oo`04001oogooOol3001oOol00:aoo`@000aoo`@000Ioo`03001oogoo07eoo`00
ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7Ool00001\
\>"],
  ImageRangeCache->{{{0, 325.875}, {230.375, 0}} -> {-0.170136, 0.0462355, \
0.00438569, 0.00438569}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70824 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.10169 -0.148196 1.10169 [
[.5 .72074 -20 0 ]
[.5 .72074 20 15 ]
[.44797 -0.02478 -4.90556 -15 ]
[.44797 -0.02478 5.09444 0 ]
[.15892 .66839 -5.31917 0 ]
[.15892 .66839 4.68083 15 ]
[-0.06694 .27471 -10 -6.62571 ]
[-0.06694 .27471 0 8.37429 ]
[ 0 0 0 0 ]
[ 1 .70824 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .72074 -81 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.02) show
99.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.02946 .11175 m
.89362 0 L
s
gsave
.44797 -0.02478 -65.9056 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .4272 m
.29069 .70824 L
s
gsave
.15892 .66839 -66.3192 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.02946 .11175 m
0 .4272 L
s
gsave
-0.06694 .27471 -71 -10.6257 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(q) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.29069 .70824 L
s
.29069 .70824 m
.30155 .45044 L
s
.30155 .45044 m
.02946 .11175 L
s
.89362 0 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.89362 0 m
.02946 .11175 L
s
.30155 .45044 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.29069 .70824 L
s
.29069 .70824 m
.30155 .45044 L
s
0 0 m
1 0 L
1 .70824 L
0 .70824 L
closepath
clip
newpath
.617 .786 .963 r
.29526 .44261 .30155 .45044 .32048 .44857 .31431 .44072 Mtetra
.31431 .44072 .32048 .44857 .33945 .44752 .33342 .43882 Mtetra
.456 .682 .962 r
.33342 .43882 .33945 .44752 .35824 .45383 .3524 .44255 Mtetra
.414 .595 .919 r
.3524 .44255 .35824 .45383 .37714 .46031 .37137 .44987 Mtetra
.417 .615 .932 r
.37137 .44987 .37714 .46031 .39617 .46624 .39049 .45637 Mtetra
.431 .637 .942 r
.39049 .45637 .39617 .46624 .41532 .47143 .40973 .46196 Mtetra
.449 .658 .95 r
.40973 .46196 .41532 .47143 .4346 .47587 .42911 .4667 Mtetra
.466 .675 .955 r
.42911 .4667 .4346 .47587 .45399 .47963 .44861 .47069 Mtetra
.481 .69 .959 r
.44861 .47069 .45399 .47963 .47348 .48279 .46821 .47402 Mtetra
.495 .703 .962 r
.46821 .47402 .47348 .48279 .49308 .48542 .48792 .47679 Mtetra
.507 .713 .964 r
.48792 .47679 .49308 .48542 .51277 .4876 .50773 .47908 Mtetra
.517 .722 .966 r
.50773 .47908 .51277 .4876 .53255 .48939 .52763 .48094 Mtetra
.526 .73 .967 r
.52763 .48094 .53255 .48939 .55242 .49083 .54762 .48245 Mtetra
.533 .736 .968 r
.54762 .48245 .55242 .49083 .57238 .49197 .5677 .48364 Mtetra
.54 .742 .969 r
.5677 .48364 .57238 .49197 .59241 .49284 .58786 .48456 Mtetra
.546 .746 .97 r
.58786 .48456 .59241 .49284 .61253 .49349 .60811 .48524 Mtetra
.551 .751 .97 r
.60811 .48524 .61253 .49349 .63273 .49393 .62843 .4857 Mtetra
.555 .754 .97 r
.62843 .4857 .63273 .49393 .653 .49418 .64883 .48598 Mtetra
.559 .757 .971 r
.64883 .48598 .653 .49418 .67335 .49428 .66931 .48609 Mtetra
.562 .76 .971 r
.66931 .48609 .67335 .49428 .69378 .49422 .68987 .48604 Mtetra
.565 .763 .971 r
.68987 .48604 .69378 .49422 .71429 .49404 .71051 .48587 Mtetra
.568 .765 .971 r
.71051 .48587 .71429 .49404 .73486 .49374 .73122 .48557 Mtetra
.57 .767 .971 r
.73122 .48557 .73486 .49374 .75552 .49333 .75201 .48516 Mtetra
.572 .769 .972 r
.75201 .48516 .75552 .49333 .77624 .49282 .77287 .48465 Mtetra
.574 .771 .972 r
.77287 .48465 .77624 .49282 .79704 .49223 .79381 .48405 Mtetra
.576 .772 .972 r
.79381 .48405 .79704 .49223 .81792 .49155 .81482 .48336 Mtetra
.578 .773 .972 r
.81482 .48336 .81792 .49155 .83887 .4908 .8359 .4826 Mtetra
.579 .775 .972 r
.8359 .4826 .83887 .4908 .85989 .48997 .85707 .48177 Mtetra
.58 .776 .972 r
.85707 .48177 .85989 .48997 .88099 .48908 .8783 .48087 Mtetra
.581 .777 .972 r
.8783 .48087 .88099 .48908 .90216 .48814 .89962 .47991 Mtetra
.582 .778 .972 r
.89962 .47991 .90216 .48814 .9234 .48713 .921 .47889 Mtetra
.583 .779 .972 r
.921 .47889 .9234 .48713 .94472 .48608 .94246 .47782 Mtetra
.584 .78 .973 r
.94246 .47782 .94472 .48608 .96611 .48498 .964 .47671 Mtetra
.585 .78 .973 r
.964 .47671 .96611 .48498 .98757 .48383 .98561 .47554 Mtetra
.617 .786 .963 r
.2889 .43469 .29526 .44261 .31431 .44072 .30806 .43277 Mtetra
.30806 .43277 .31431 .44072 .33342 .43882 .32729 .43085 Mtetra
.551 .755 .972 r
.32729 .43085 .33342 .43882 .3524 .44255 .3465 .43114 Mtetra
.386 .578 .916 r
.3465 .43114 .3524 .44255 .37137 .44987 .36554 .4393 Mtetra
.397 .603 .93 r
.36554 .4393 .37137 .44987 .39049 .45637 .38473 .44637 Mtetra
.417 .629 .941 r
.38473 .44637 .39049 .45637 .40973 .46196 .40408 .45237 Mtetra
.439 .652 .949 r
.40408 .45237 .40973 .46196 .42911 .4667 .42356 .45742 Mtetra
.458 .671 .955 r
.42356 .45742 .42911 .4667 .44861 .47069 .44316 .46163 Mtetra
.476 .687 .959 r
.44316 .46163 .44861 .47069 .46821 .47402 .46288 .46514 Mtetra
.491 .7 .962 r
.46288 .46514 .46821 .47402 .48792 .47679 .4827 .46804 Mtetra
.503 .711 .964 r
.4827 .46804 .48792 .47679 .50773 .47908 .50263 .47043 Mtetra
.514 .721 .966 r
.50263 .47043 .50773 .47908 .52763 .48094 .52265 .47239 Mtetra
.524 .728 .967 r
.52265 .47239 .52763 .48094 .54762 .48245 .54276 .47396 Mtetra
.532 .735 .968 r
.54276 .47396 .54762 .48245 .5677 .48364 .56296 .47521 Mtetra
.538 .741 .969 r
.56296 .47521 .5677 .48364 .58786 .48456 .58325 .47617 Mtetra
.544 .746 .97 r
.58325 .47617 .58786 .48456 .60811 .48524 .60362 .47688 Mtetra
.55 .75 .97 r
.60362 .47688 .60811 .48524 .62843 .4857 .62407 .47737 Mtetra
.554 .754 .97 r
.62407 .47737 .62843 .4857 .64883 .48598 .6446 .47766 Mtetra
.558 .757 .971 r
.6446 .47766 .64883 .48598 .66931 .48609 .66522 .47778 Mtetra
.561 .76 .971 r
.66522 .47778 .66931 .48609 .68987 .48604 .68591 .47775 Mtetra
.565 .762 .971 r
.68591 .47775 .68987 .48604 .71051 .48587 .70668 .47758 Mtetra
.567 .765 .971 r
.70668 .47758 .71051 .48587 .73122 .48557 .72752 .47729 Mtetra
.57 .767 .971 r
.72752 .47729 .73122 .48557 .75201 .48516 .74845 .47688 Mtetra
.572 .769 .972 r
.74845 .47688 .75201 .48516 .77287 .48465 .76945 .47636 Mtetra
.574 .77 .972 r
.76945 .47636 .77287 .48465 .79381 .48405 .79052 .47576 Mtetra
.576 .772 .972 r
.79052 .47576 .79381 .48405 .81482 .48336 .81167 .47507 Mtetra
.577 .773 .972 r
.81167 .47507 .81482 .48336 .8359 .4826 .8329 .47429 Mtetra
.579 .775 .972 r
.8329 .47429 .8359 .4826 .85707 .48177 .85421 .47345 Mtetra
.58 .776 .972 r
.85421 .47345 .85707 .48177 .8783 .48087 .87559 .47254 Mtetra
.581 .777 .972 r
.87559 .47254 .8783 .48087 .89962 .47991 .89704 .47157 Mtetra
.582 .778 .972 r
.89704 .47157 .89962 .47991 .921 .47889 .91857 .47054 Mtetra
.583 .779 .972 r
.91857 .47054 .921 .47889 .94246 .47782 .94018 .46945 Mtetra
.584 .779 .973 r
.94018 .46945 .94246 .47782 .964 .47671 .96187 .46832 Mtetra
.585 .78 .973 r
.96187 .46832 .964 .47671 .98561 .47554 .98363 .46714 Mtetra
.617 .786 .963 r
.28245 .42666 .2889 .43469 .30806 .43277 .30173 .42472 Mtetra
.30173 .42472 .30806 .43277 .32729 .43085 .32107 .42277 Mtetra
.32107 .42277 .32729 .43085 .3465 .43114 .34048 .42082 Mtetra
.356 .585 .93 r
.34048 .42082 .3465 .43114 .36554 .4393 .35963 .4286 Mtetra
.377 .59 .928 r
.35963 .4286 .36554 .4393 .38473 .44637 .37891 .43625 Mtetra
.403 .62 .94 r
.37891 .43625 .38473 .44637 .40408 .45237 .39835 .44267 Mtetra
.428 .645 .948 r
.39835 .44267 .40408 .45237 .42356 .45742 .41793 .44801 Mtetra
.451 .666 .955 r
.41793 .44801 .42356 .45742 .44316 .46163 .43764 .45245 Mtetra
.47 .683 .959 r
.43764 .45245 .44316 .46163 .46288 .46514 .45747 .45614 Mtetra
.486 .698 .962 r
.45747 .45614 .46288 .46514 .4827 .46804 .47741 .45918 Mtetra
.5 .709 .964 r
.47741 .45918 .4827 .46804 .50263 .47043 .49746 .46168 Mtetra
.512 .719 .966 r
.49746 .46168 .50263 .47043 .52265 .47239 .5176 .46372 Mtetra
.521 .727 .967 r
.5176 .46372 .52265 .47239 .54276 .47396 .53783 .46536 Mtetra
.53 .734 .968 r
.53783 .46536 .54276 .47396 .56296 .47521 .55816 .46666 Mtetra
.537 .74 .969 r
.55816 .46666 .56296 .47521 .58325 .47617 .57857 .46766 Mtetra
.543 .745 .97 r
.57857 .46766 .58325 .47617 .60362 .47688 .59907 .4684 Mtetra
.548 .749 .97 r
.59907 .4684 .60362 .47688 .62407 .47737 .61965 .46892 Mtetra
.553 .753 .97 r
.61965 .46892 .62407 .47737 .6446 .47766 .64032 .46923 Mtetra
.557 .757 .971 r
.64032 .46923 .6446 .47766 .66522 .47778 .66106 .46937 Mtetra
.561 .759 .971 r
.66106 .46937 .66522 .47778 .68591 .47775 .68189 .46935 Mtetra
.564 .762 .971 r
.68189 .46935 .68591 .47775 .70668 .47758 .70279 .46918 Mtetra
.567 .764 .971 r
.70279 .46918 .70668 .47758 .72752 .47729 .72378 .46889 Mtetra
.569 .767 .972 r
.72378 .46889 .72752 .47729 .74845 .47688 .74484 .46848 Mtetra
.571 .768 .972 r
.74484 .46848 .74845 .47688 .76945 .47636 .76598 .46796 Mtetra
.573 .77 .972 r
.76598 .46796 .76945 .47636 .79052 .47576 .78719 .46735 Mtetra
.575 .772 .972 r
.78719 .46735 .79052 .47576 .81167 .47507 .80849 .46665 Mtetra
.577 .773 .972 r
.80849 .46665 .81167 .47507 .8329 .47429 .82986 .46587 Mtetra
.578 .774 .972 r
.82986 .46587 .8329 .47429 .85421 .47345 .8513 .46502 Mtetra
.58 .776 .972 r
.8513 .46502 .85421 .47345 .87559 .47254 .87283 .4641 Mtetra
.581 .777 .972 r
.87283 .4641 .87559 .47254 .89704 .47157 .89443 .46311 Mtetra
.582 .778 .972 r
.89443 .46311 .89704 .47157 .91857 .47054 .91611 .46206 Mtetra
.583 .779 .972 r
.91611 .46206 .91857 .47054 .94018 .46945 .93787 .46096 Mtetra
.584 .779 .973 r
.93787 .46096 .94018 .46945 .96187 .46832 .9597 .45981 Mtetra
.585 .78 .973 r
.9597 .45981 .96187 .46832 .98363 .46714 .98161 .45862 Mtetra
.617 .786 .963 r
.27591 .41853 .28245 .42666 .30173 .42472 .29531 .41656 Mtetra
.29531 .41656 .30173 .42472 .32107 .42277 .31477 .41458 Mtetra
.31477 .41458 .32107 .42277 .34048 .42082 .3343 .4126 Mtetra
.368 .65 .965 r
.3343 .4126 .34048 .42082 .35963 .4286 .35365 .41777 Mtetra
.356 .577 .924 r
.35365 .41777 .35963 .4286 .37891 .43625 .37301 .426 Mtetra
.389 .611 .938 r
.37301 .426 .37891 .43625 .39835 .44267 .39254 .43283 Mtetra
.418 .639 .947 r
.39254 .43283 .39835 .44267 .41793 .44801 .41223 .43848 Mtetra
.443 .661 .954 r
.41223 .43848 .41793 .44801 .43764 .45245 .43205 .44316 Mtetra
.464 .68 .959 r
.43205 .44316 .43764 .45245 .45747 .45614 .45199 .44702 Mtetra
.482 .695 .962 r
.45199 .44702 .45747 .45614 .47741 .45918 .47205 .4502 Mtetra
.496 .707 .964 r
.47205 .4502 .47741 .45918 .49746 .46168 .49221 .4528 Mtetra
.509 .717 .966 r
.49221 .4528 .49746 .46168 .5176 .46372 .51248 .45493 Mtetra
.519 .726 .967 r
.51248 .45493 .5176 .46372 .53783 .46536 .53284 .45664 Mtetra
.528 .733 .968 r
.53284 .45664 .53783 .46536 .55816 .46666 .55329 .45799 Mtetra
.535 .739 .969 r
.55329 .45799 .55816 .46666 .57857 .46766 .57383 .45903 Mtetra
.542 .744 .97 r
.57383 .45903 .57857 .46766 .59907 .4684 .59446 .45981 Mtetra
.547 .749 .97 r
.59446 .45981 .59907 .4684 .61965 .46892 .61518 .46035 Mtetra
.552 .753 .97 r
.61518 .46035 .61965 .46892 .64032 .46923 .63597 .46069 Mtetra
.556 .756 .971 r
.63597 .46069 .64032 .46923 .66106 .46937 .65685 .46084 Mtetra
.56 .759 .971 r
.65685 .46084 .66106 .46937 .68189 .46935 .67782 .46083 Mtetra
.563 .762 .971 r
.67782 .46083 .68189 .46935 .70279 .46918 .69886 .46067 Mtetra
.566 .764 .971 r
.69886 .46067 .70279 .46918 .72378 .46889 .71998 .46037 Mtetra
.569 .766 .972 r
.71998 .46037 .72378 .46889 .74484 .46848 .74118 .45996 Mtetra
.571 .768 .972 r
.74118 .45996 .74484 .46848 .76598 .46796 .76246 .45944 Mtetra
.573 .77 .972 r
.76246 .45944 .76598 .46796 .78719 .46735 .78382 .45883 Mtetra
.575 .771 .972 r
.78382 .45883 .78719 .46735 .80849 .46665 .80525 .45812 Mtetra
.577 .773 .972 r
.80525 .45812 .80849 .46665 .82986 .46587 .82677 .45733 Mtetra
.578 .774 .972 r
.82677 .45733 .82986 .46587 .8513 .46502 .84836 .45647 Mtetra
.579 .775 .972 r
.84836 .45647 .8513 .46502 .87283 .4641 .87003 .45553 Mtetra
.581 .776 .972 r
.87003 .45553 .87283 .4641 .89443 .46311 .89178 .45453 Mtetra
.582 .777 .972 r
.89178 .45453 .89443 .46311 .91611 .46206 .91361 .45347 Mtetra
.583 .778 .972 r
.91361 .45347 .91611 .46206 .93787 .46096 .93552 .45236 Mtetra
.584 .779 .973 r
.93552 .45236 .93787 .46096 .9597 .45981 .9575 .45119 Mtetra
.585 .78 .973 r
.9575 .45119 .9597 .45981 .98161 .45862 .97957 .44997 Mtetra
.617 .786 .963 r
.26929 .41028 .27591 .41853 .29531 .41656 .28881 .40829 Mtetra
.28881 .40829 .29531 .41656 .31477 .41458 .30839 .40629 Mtetra
.30839 .40629 .31477 .41458 .3343 .4126 .32804 .40428 Mtetra
.475 .713 .974 r
.32804 .40428 .3343 .4126 .35365 .41777 .34759 .4068 Mtetra
.335 .563 .921 r
.34759 .4068 .35365 .41777 .37301 .426 .36704 .41562 Mtetra
.374 .601 .936 r
.36704 .41562 .37301 .426 .39254 .43283 .38667 .42287 Mtetra
.407 .632 .946 r
.38667 .42287 .39254 .43283 .41223 .43848 .40645 .42883 Mtetra
.435 .657 .953 r
.40645 .42883 .41223 .43848 .43205 .44316 .42638 .43374 Mtetra
.458 .676 .958 r
.42638 .43374 .43205 .44316 .45199 .44702 .44644 .43778 Mtetra
.477 .692 .962 r
.44644 .43778 .45199 .44702 .47205 .4502 .46662 .4411 Mtetra
.493 .705 .964 r
.46662 .4411 .47205 .4502 .49221 .4528 .4869 .44381 Mtetra
.506 .716 .966 r
.4869 .44381 .49221 .4528 .51248 .45493 .50729 .44602 Mtetra
.517 .724 .967 r
.50729 .44602 .51248 .45493 .53284 .45664 .52778 .4478 Mtetra
.526 .732 .968 r
.52778 .4478 .53284 .45664 .55329 .45799 .54836 .44921 Mtetra
.534 .738 .969 r
.54836 .44921 .55329 .45799 .57383 .45903 .56903 .45029 Mtetra
.54 .743 .97 r
.56903 .45029 .57383 .45903 .59446 .45981 .58979 .4511 Mtetra
.546 .748 .97 r
.58979 .4511 .59446 .45981 .61518 .46035 .61064 .45167 Mtetra
.551 .752 .97 r
.61064 .45167 .61518 .46035 .63597 .46069 .63157 .45202 Mtetra
.556 .756 .971 r
.63157 .45202 .63597 .46069 .65685 .46084 .65259 .45219 Mtetra
.559 .759 .971 r
.65259 .45219 .65685 .46084 .67782 .46083 .67368 .45219 Mtetra
.563 .761 .971 r
.67368 .45219 .67782 .46083 .69886 .46067 .69487 .45203 Mtetra
.566 .764 .971 r
.69487 .45203 .69886 .46067 .71998 .46037 .71613 .45174 Mtetra
.568 .766 .972 r
.71613 .45174 .71998 .46037 .74118 .45996 .73747 .45133 Mtetra
.571 .768 .972 r
.73747 .45133 .74118 .45996 .76246 .45944 .75889 .45081 Mtetra
.573 .77 .972 r
.75889 .45081 .76246 .45944 .78382 .45883 .78039 .45018 Mtetra
.575 .771 .972 r
.78039 .45018 .78382 .45883 .80525 .45812 .80198 .44947 Mtetra
.576 .773 .972 r
.80198 .44947 .80525 .45812 .82677 .45733 .82364 .44867 Mtetra
.578 .774 .972 r
.82364 .44867 .82677 .45733 .84836 .45647 .84538 .44779 Mtetra
.579 .775 .972 r
.84538 .44779 .84836 .45647 .87003 .45553 .8672 .44685 Mtetra
.581 .776 .972 r
.8672 .44685 .87003 .45553 .89178 .45453 .8891 .44583 Mtetra
.582 .777 .972 r
.8891 .44583 .89178 .45453 .91361 .45347 .91108 .44476 Mtetra
.583 .778 .972 r
.91108 .44476 .91361 .45347 .93552 .45236 .93314 .44362 Mtetra
.584 .779 .973 r
.93314 .44362 .93552 .45236 .9575 .45119 .95527 .44244 Mtetra
.585 .78 .973 r
.95527 .44244 .9575 .45119 .97957 .44997 .97749 .4412 Mtetra
.617 .786 .963 r
.26258 .40193 .26929 .41028 .28881 .40829 .28222 .39991 Mtetra
.28222 .39991 .28881 .40829 .30839 .40629 .30192 .39788 Mtetra
.30192 .39788 .30839 .40629 .32804 .40428 .32169 .39584 Mtetra
.564 .761 .97 r
.32169 .39584 .32804 .40428 .34759 .4068 .34145 .39569 Mtetra
.313 .548 .916 r
.34145 .39569 .34759 .4068 .36704 .41562 .36098 .4051 Mtetra
.358 .591 .933 r
.36098 .4051 .36704 .41562 .38667 .42287 .38071 .41278 Mtetra
.396 .625 .945 r
.38071 .41278 .38667 .42287 .40645 .42883 .4006 .41905 Mtetra
.427 .652 .953 r
.4006 .41905 .40645 .42883 .42638 .43374 .42064 .42419 Mtetra
.452 .673 .958 r
.42064 .42419 .42638 .43374 .44644 .43778 .44082 .42841 Mtetra
.473 .689 .962 r
.44082 .42841 .44644 .43778 .46662 .4411 .46111 .43187 Mtetra
.489 .703 .964 r
.46111 .43187 .46662 .4411 .4869 .44381 .48152 .4347 Mtetra
.503 .714 .966 r
.48152 .4347 .4869 .44381 .50729 .44602 .50203 .43699 Mtetra
.514 .723 .967 r
.50203 .43699 .50729 .44602 .52778 .4478 .52264 .43884 Mtetra
.524 .731 .968 r
.52264 .43884 .52778 .4478 .54836 .44921 .54336 .4403 Mtetra
.532 .737 .969 r
.54336 .4403 .54836 .44921 .56903 .45029 .56416 .44143 Mtetra
.539 .743 .97 r
.56416 .44143 .56903 .45029 .58979 .4511 .58505 .44228 Mtetra
.545 .747 .97 r
.58505 .44228 .58979 .4511 .61064 .45167 .60604 .44287 Mtetra
.55 .751 .971 r
.60604 .44287 .61064 .45167 .63157 .45202 .6271 .44324 Mtetra
.555 .755 .971 r
.6271 .44324 .63157 .45202 .65259 .45219 .64826 .44342 Mtetra
.559 .758 .971 r
.64826 .44342 .65259 .45219 .67368 .45219 .6695 .44342 Mtetra
.562 .761 .971 r
.6695 .44342 .67368 .45219 .69487 .45203 .69082 .44327 Mtetra
.565 .763 .971 r
.69082 .44327 .69487 .45203 .71613 .45174 .71222 .44299 Mtetra
.568 .766 .972 r
.71222 .44299 .71613 .45174 .73747 .45133 .73371 .44257 Mtetra
.57 .768 .972 r
.73371 .44257 .73747 .45133 .75889 .45081 .75527 .44205 Mtetra
.572 .769 .972 r
.75527 .44205 .75889 .45081 .78039 .45018 .77692 .44142 Mtetra
.574 .771 .972 r
.77692 .44142 .78039 .45018 .80198 .44947 .79865 .44069 Mtetra
.576 .773 .972 r
.79865 .44069 .80198 .44947 .82364 .44867 .82046 .43988 Mtetra
.578 .774 .972 r
.82046 .43988 .82364 .44867 .84538 .44779 .84235 .439 Mtetra
.579 .775 .972 r
.84235 .439 .84538 .44779 .8672 .44685 .86432 .43803 Mtetra
.58 .776 .972 r
.86432 .43803 .8672 .44685 .8891 .44583 .88637 .43701 Mtetra
.581 .777 .972 r
.88637 .43701 .8891 .44583 .91108 .44476 .90851 .43592 Mtetra
.583 .778 .972 r
.90851 .43592 .91108 .44476 .93314 .44362 .93072 .43477 Mtetra
.583 .779 .973 r
.93072 .43477 .93314 .44362 .95527 .44244 .95301 .43356 Mtetra
.584 .78 .973 r
.95301 .43356 .95527 .44244 .97749 .4412 .97539 .43231 Mtetra
.617 .786 .963 r
.25578 .39346 .26258 .40193 .28222 .39991 .27554 .39141 Mtetra
.27554 .39141 .28222 .39991 .30192 .39788 .29536 .38936 Mtetra
.29536 .38936 .30192 .39788 .32169 .39584 .31525 .38729 Mtetra
.31525 .38729 .32169 .39584 .34145 .39569 .33521 .38522 Mtetra
.287 .549 .923 r
.33521 .38522 .34145 .39569 .36098 .4051 .35486 .39445 Mtetra
.343 .581 .931 r
.35486 .39445 .36098 .4051 .38071 .41278 .37468 .40255 Mtetra
.385 .618 .944 r
.37468 .40255 .38071 .41278 .4006 .41905 .39467 .40914 Mtetra
.419 .647 .952 r
.39467 .40914 .4006 .41905 .42064 .42419 .41482 .41452 Mtetra
.446 .669 .958 r
.41482 .41452 .42064 .42419 .44082 .42841 .43511 .41892 Mtetra
.468 .687 .962 r
.43511 .41892 .44082 .42841 .46111 .43187 .45553 .42252 Mtetra
.486 .701 .964 r
.45553 .42252 .46111 .43187 .48152 .4347 .47606 .42546 Mtetra
.5 .712 .966 r
.47606 .42546 .48152 .4347 .50203 .43699 .4967 .42784 Mtetra
.512 .722 .967 r
.4967 .42784 .50203 .43699 .52264 .43884 .51744 .42976 Mtetra
.522 .73 .968 r
.51744 .42976 .52264 .43884 .54336 .4403 .53828 .43127 Mtetra
.531 .736 .969 r
.53828 .43127 .54336 .4403 .56416 .44143 .55922 .43245 Mtetra
.538 .742 .97 r
.55922 .43245 .56416 .44143 .58505 .44228 .58025 .43332 Mtetra
.544 .747 .97 r
.58025 .43332 .58505 .44228 .60604 .44287 .60137 .43394 Mtetra
.549 .751 .971 r
.60137 .43394 .60604 .44287 .6271 .44324 .62258 .43433 Mtetra
.554 .755 .971 r
.62258 .43433 .6271 .44324 .64826 .44342 .64387 .43453 Mtetra
.558 .758 .971 r
.64387 .43453 .64826 .44342 .6695 .44342 .66525 .43454 Mtetra
.561 .761 .971 r
.66525 .43454 .6695 .44342 .69082 .44327 .68671 .43439 Mtetra
.565 .763 .971 r
.68671 .43439 .69082 .44327 .71222 .44299 .70826 .43411 Mtetra
.567 .765 .972 r
.70826 .43411 .71222 .44299 .73371 .44257 .72989 .43369 Mtetra
.57 .767 .972 r
.72989 .43369 .73371 .44257 .75527 .44205 .75161 .43316 Mtetra
.572 .769 .972 r
.75161 .43316 .75527 .44205 .77692 .44142 .7734 .43253 Mtetra
.574 .771 .972 r
.7734 .43253 .77692 .44142 .79865 .44069 .79528 .43179 Mtetra
.576 .772 .972 r
.79528 .43179 .79865 .44069 .82046 .43988 .81724 .43097 Mtetra
.577 .774 .972 r
.81724 .43097 .82046 .43988 .84235 .439 .83928 .43007 Mtetra
.579 .775 .972 r
.83928 .43007 .84235 .439 .86432 .43803 .86141 .4291 Mtetra
.58 .776 .972 r
.86141 .4291 .86432 .43803 .88637 .43701 .88361 .42805 Mtetra
.581 .777 .972 r
.88361 .42805 .88637 .43701 .90851 .43592 .9059 .42695 Mtetra
.582 .778 .972 r
.9059 .42695 .90851 .43592 .93072 .43477 .92827 .42578 Mtetra
.583 .779 .973 r
.92827 .42578 .93072 .43477 .95301 .43356 .95072 .42456 Mtetra
.584 .78 .973 r
.95072 .42456 .95301 .43356 .97539 .43231 .97325 .42328 Mtetra
.617 .786 .963 r
.24888 .38488 .25578 .39346 .27554 .39141 .26877 .3828 Mtetra
.26877 .3828 .27554 .39141 .29536 .38936 .28872 .38072 Mtetra
.28872 .38072 .29536 .38936 .31525 .38729 .30873 .37863 Mtetra
.30873 .37863 .31525 .38729 .33521 .38522 .32882 .37653 Mtetra
.286 .596 .949 r
.32882 .37653 .33521 .38522 .35486 .39445 .34865 .38366 Mtetra
.327 .571 .928 r
.34865 .38366 .35486 .39445 .37468 .40255 .36856 .39219 Mtetra
.374 .611 .942 r
.36856 .39219 .37468 .40255 .39467 .40914 .38866 .3991 Mtetra
.411 .642 .951 r
.38866 .3991 .39467 .40914 .41482 .41452 .40893 .40472 Mtetra
.44 .665 .957 r
.40893 .40472 .41482 .41452 .43511 .41892 .42933 .4093 Mtetra
.463 .684 .961 r
.42933 .4093 .43511 .41892 .45553 .42252 .44987 .41304 Mtetra
.482 .699 .964 r
.44987 .41304 .45553 .42252 .47606 .42546 .47053 .41609 Mtetra
.497 .711 .966 r
.47053 .41609 .47606 .42546 .4967 .42784 .49129 .41856 Mtetra
.51 .72 .967 r
.49129 .41856 .4967 .42784 .51744 .42976 .51217 .42055 Mtetra
.52 .728 .968 r
.51217 .42055 .51744 .42976 .53828 .43127 .53314 .42212 Mtetra
.529 .735 .969 r
.53314 .42212 .53828 .43127 .55922 .43245 .55421 .42334 Mtetra
.537 .741 .97 r
.55421 .42334 .55922 .43245 .58025 .43332 .57538 .42425 Mtetra
.543 .746 .97 r
.57538 .42425 .58025 .43332 .60137 .43394 .59664 .42489 Mtetra
.548 .75 .971 r
.59664 .42489 .60137 .43394 .62258 .43433 .61798 .4253 Mtetra
.553 .754 .971 r
.61798 .4253 .62258 .43433 .64387 .43453 .63942 .42551 Mtetra
.557 .757 .971 r
.63942 .42551 .64387 .43453 .66525 .43454 .66094 .42553 Mtetra
.561 .76 .971 r
.66094 .42553 .66525 .43454 .68671 .43439 .68255 .42539 Mtetra
.564 .763 .971 r
.68255 .42539 .68671 .43439 .70826 .43411 .70424 .4251 Mtetra
.567 .765 .972 r
.70424 .4251 .70826 .43411 .72989 .43369 .72602 .42469 Mtetra
.569 .767 .972 r
.72602 .42469 .72989 .43369 .75161 .43316 .74788 .42415 Mtetra
.572 .769 .972 r
.74788 .42415 .75161 .43316 .7734 .43253 .76983 .42351 Mtetra
.574 .771 .972 r
.76983 .42351 .7734 .43253 .79528 .43179 .79186 .42276 Mtetra
.575 .772 .972 r
.79186 .42276 .79528 .43179 .81724 .43097 .81397 .42193 Mtetra
.577 .773 .972 r
.81397 .42193 .81724 .43097 .83928 .43007 .83617 .42102 Mtetra
.579 .775 .972 r
.83617 .42102 .83928 .43007 .86141 .4291 .85845 .42003 Mtetra
.58 .776 .972 r
.85845 .42003 .86141 .4291 .88361 .42805 .88081 .41897 Mtetra
.581 .777 .972 r
.88081 .41897 .88361 .42805 .9059 .42695 .90325 .41785 Mtetra
.582 .778 .972 r
.90325 .41785 .9059 .42695 .92827 .42578 .92578 .41666 Mtetra
.583 .779 .973 r
.92578 .41666 .92827 .42578 .95072 .42456 .94839 .41542 Mtetra
.584 .78 .973 r
.94839 .41542 .95072 .42456 .97325 .42328 .97109 .41413 Mtetra
.617 .786 .963 r
.24189 .37618 .24888 .38488 .26877 .3828 .2619 .37407 Mtetra
.2619 .37407 .26877 .3828 .28872 .38072 .28198 .37196 Mtetra
.28198 .37196 .28872 .38072 .30873 .37863 .30212 .36984 Mtetra
.30212 .36984 .30873 .37863 .32882 .37653 .32233 .36771 Mtetra
.379 .656 .966 r
.32233 .36771 .32882 .37653 .34865 .38366 .34235 .37273 Mtetra
.311 .56 .925 r
.34235 .37273 .34865 .38366 .36856 .39219 .36237 .3817 Mtetra
.363 .604 .94 r
.36237 .3817 .36856 .39219 .38866 .3991 .38257 .38892 Mtetra
.403 .637 .95 r
.38257 .38892 .38866 .3991 .40893 .40472 .40295 .39478 Mtetra
.434 .662 .957 r
.40295 .39478 .40893 .40472 .42933 .4093 .42348 .39955 Mtetra
.459 .681 .961 r
.42348 .39955 .42933 .4093 .44987 .41304 .44413 .40343 Mtetra
.478 .696 .964 r
.44413 .40343 .44987 .41304 .47053 .41609 .46492 .40659 Mtetra
.494 .709 .966 r
.46492 .40659 .47053 .41609 .49129 .41856 .48581 .40915 Mtetra
.508 .719 .967 r
.48581 .40915 .49129 .41856 .51217 .42055 .50682 .41121 Mtetra
.518 .727 .968 r
.50682 .41121 .51217 .42055 .53314 .42212 .52793 .41284 Mtetra
.527 .734 .969 r
.52793 .41284 .53314 .42212 .55421 .42334 .54914 .4141 Mtetra
.535 .74 .97 r
.54914 .4141 .55421 .42334 .57538 .42425 .57044 .41504 Mtetra
.542 .745 .97 r
.57044 .41504 .57538 .42425 .59664 .42489 .59184 .41571 Mtetra
.547 .75 .971 r
.59184 .41571 .59664 .42489 .61798 .4253 .61333 .41614 Mtetra
.552 .754 .971 r
.61333 .41614 .61798 .4253 .63942 .42551 .6349 .41636 Mtetra
.557 .757 .971 r
.6349 .41636 .63942 .42551 .66094 .42553 .65657 .41639 Mtetra
.56 .76 .971 r
.65657 .41639 .66094 .42553 .68255 .42539 .67833 .41625 Mtetra
.564 .762 .972 r
.67833 .41625 .68255 .42539 .70424 .4251 .70017 .41597 Mtetra
.566 .765 .972 r
.70017 .41597 .70424 .4251 .72602 .42469 .7221 .41555 Mtetra
.569 .767 .972 r
.7221 .41555 .72602 .42469 .74788 .42415 .74411 .41501 Mtetra
.571 .769 .972 r
.74411 .41501 .74788 .42415 .76983 .42351 .76621 .41436 Mtetra
.573 .77 .972 r
.76621 .41436 .76983 .42351 .79186 .42276 .78839 .41361 Mtetra
.575 .772 .972 r
.78839 .41361 .79186 .42276 .81397 .42193 .81066 .41276 Mtetra
.577 .773 .972 r
.81066 .41276 .81397 .42193 .83617 .42102 .83301 .41184 Mtetra
.578 .775 .972 r
.83301 .41184 .83617 .42102 .85845 .42003 .85544 .41083 Mtetra
.58 .776 .972 r
.85544 .41083 .85845 .42003 .88081 .41897 .87796 .40976 Mtetra
.581 .777 .972 r
.87796 .40976 .88081 .41897 .90325 .41785 .90057 .40861 Mtetra
.582 .778 .972 r
.90057 .40861 .90325 .41785 .92578 .41666 .92326 .40741 Mtetra
.583 .779 .973 r
.92326 .40741 .92578 .41666 .94839 .41542 .94603 .40615 Mtetra
.584 .78 .973 r
.94603 .40615 .94839 .41542 .97109 .41413 .96889 .40484 Mtetra
.617 .786 .963 r
.2348 .36736 .24189 .37618 .2619 .37407 .25494 .36522 Mtetra
.25494 .36522 .2619 .37407 .28198 .37196 .27515 .36308 Mtetra
.27515 .36308 .28198 .37196 .30212 .36984 .29542 .36093 Mtetra
.29542 .36093 .30212 .36984 .32233 .36771 .31576 .35877 Mtetra
.462 .705 .973 r
.31576 .35877 .32233 .36771 .34235 .37273 .33598 .36165 Mtetra
.295 .549 .921 r
.33598 .36165 .34235 .37273 .36237 .3817 .35609 .37106 Mtetra
.351 .596 .938 r
.35609 .37106 .36237 .3817 .38257 .38892 .3764 .37861 Mtetra
.395 .631 .949 r
.3764 .37861 .38257 .38892 .40295 .39478 .39689 .38471 Mtetra
.428 .658 .956 r
.39689 .38471 .40295 .39478 .42348 .39955 .41754 .38966 Mtetra
.454 .678 .961 r
.41754 .38966 .42348 .39955 .44413 .40343 .43832 .39369 Mtetra
.475 .694 .964 r
.43832 .39369 .44413 .40343 .46492 .40659 .45923 .39696 Mtetra
.492 .707 .966 r
.45923 .39696 .46492 .40659 .48581 .40915 .48026 .39961 Mtetra
.505 .718 .967 r
.48026 .39961 .48581 .40915 .50682 .41121 .50139 .40174 Mtetra
.516 .726 .968 r
.50139 .40174 .50682 .41121 .52793 .41284 .52264 .40342 Mtetra
.526 .733 .969 r
.52264 .40342 .52793 .41284 .54914 .4141 .54399 .40473 Mtetra
.534 .74 .97 r
.54399 .40473 .54914 .4141 .57044 .41504 .56543 .4057 Mtetra
.541 .745 .97 r
.56543 .4057 .57044 .41504 .59184 .41571 .58697 .4064 Mtetra
.546 .749 .971 r
.58697 .4064 .59184 .41571 .61333 .41614 .6086 .40685 Mtetra
.551 .753 .971 r
.6086 .40685 .61333 .41614 .6349 .41636 .63033 .40708 Mtetra
.556 .756 .971 r
.63033 .40708 .6349 .41636 .65657 .41639 .65214 .40712 Mtetra
.56 .759 .971 r
.65214 .40712 .65657 .41639 .67833 .41625 .67404 .40699 Mtetra
.563 .762 .972 r
.67404 .40699 .67833 .41625 .70017 .41597 .69603 .4067 Mtetra
.566 .764 .972 r
.69603 .4067 .70017 .41597 .7221 .41555 .71811 .40628 Mtetra
.569 .767 .972 r
.71811 .40628 .7221 .41555 .74411 .41501 .74028 .40573 Mtetra
.571 .768 .972 r
.74028 .40573 .74411 .41501 .76621 .41436 .76253 .40507 Mtetra
.573 .77 .972 r
.76253 .40507 .76621 .41436 .78839 .41361 .78487 .40431 Mtetra
.575 .772 .972 r
.78487 .40431 .78839 .41361 .81066 .41276 .80729 .40346 Mtetra
.577 .773 .972 r
.80729 .40346 .81066 .41276 .83301 .41184 .8298 .40252 Mtetra
.578 .774 .972 r
.8298 .40252 .83301 .41184 .85544 .41083 .8524 .4015 Mtetra
.579 .776 .972 r
.8524 .4015 .85544 .41083 .87796 .40976 .87508 .4004 Mtetra
.581 .777 .972 r
.87508 .4004 .87796 .40976 .90057 .40861 .89784 .39924 Mtetra
.582 .778 .972 r
.89784 .39924 .90057 .40861 .92326 .40741 .9207 .39802 Mtetra
.583 .779 .973 r
.9207 .39802 .92326 .40741 .94603 .40615 .94363 .39674 Mtetra
.584 .779 .973 r
.94363 .39674 .94603 .40615 .96889 .40484 .96666 .39541 Mtetra
.617 .786 .963 r
.22762 .35841 .2348 .36736 .25494 .36522 .24788 .35625 Mtetra
.24788 .35625 .25494 .36522 .27515 .36308 .26822 .35407 Mtetra
.26822 .35407 .27515 .36308 .29542 .36093 .28862 .35189 Mtetra
.28862 .35189 .29542 .36093 .31576 .35877 .30909 .34971 Mtetra
.535 .745 .973 r
.30909 .34971 .31576 .35877 .33598 .36165 .32952 .35043 Mtetra
.278 .538 .917 r
.32952 .35043 .33598 .36165 .35609 .37106 .34973 .36028 Mtetra
.34 .589 .936 r
.34973 .36028 .35609 .37106 .3764 .37861 .37015 .36815 Mtetra
.386 .626 .948 r
.37015 .36815 .3764 .37861 .39689 .38471 .39075 .37449 Mtetra
.422 .654 .956 r
.39075 .37449 .39689 .38471 .41754 .38966 .41151 .37964 Mtetra
.449 .675 .96 r
.41151 .37964 .41754 .38966 .43832 .39369 .43242 .38381 Mtetra
.471 .692 .964 r
.43242 .38381 .43832 .39369 .45923 .39696 .45346 .3872 Mtetra
.489 .705 .966 r
.45346 .3872 .45923 .39696 .48026 .39961 .47462 .38994 Mtetra
.503 .716 .967 r
.47462 .38994 .48026 .39961 .50139 .40174 .49589 .39214 Mtetra
.515 .725 .968 r
.49589 .39214 .50139 .40174 .52264 .40342 .51728 .39387 Mtetra
.524 .732 .969 r
.51728 .39387 .52264 .40342 .54399 .40473 .53876 .39522 Mtetra
.533 .739 .97 r
.53876 .39522 .54399 .40473 .56543 .4057 .56035 .39623 Mtetra
.54 .744 .97 r
.56035 .39623 .56543 .4057 .58697 .4064 .58203 .39695 Mtetra
.546 .749 .971 r
.58203 .39695 .58697 .4064 .6086 .40685 .60381 .39742 Mtetra
.551 .753 .971 r
.60381 .39742 .6086 .40685 .63033 .40708 .62568 .39766 Mtetra
.555 .756 .971 r
.62568 .39766 .63033 .40708 .65214 .40712 .64764 .39771 Mtetra
.559 .759 .971 r
.64764 .39771 .65214 .40712 .67404 .40699 .6697 .39758 Mtetra
.562 .762 .972 r
.6697 .39758 .67404 .40699 .69603 .4067 .69184 .3973 Mtetra
.565 .764 .972 r
.69184 .3973 .69603 .4067 .71811 .40628 .71407 .39687 Mtetra
.568 .766 .972 r
.71407 .39687 .71811 .40628 .74028 .40573 .73639 .39632 Mtetra
.571 .768 .972 r
.73639 .39632 .74028 .40573 .76253 .40507 .7588 .39565 Mtetra
.573 .77 .972 r
.7588 .39565 .76253 .40507 .78487 .40431 .78129 .39488 Mtetra
.575 .772 .972 r
.78129 .39488 .78487 .40431 .80729 .40346 .80388 .39401 Mtetra
.576 .773 .972 r
.80388 .39401 .80729 .40346 .8298 .40252 .82655 .39306 Mtetra
.578 .774 .972 r
.82655 .39306 .8298 .40252 .8524 .4015 .8493 .39202 Mtetra
.579 .775 .972 r
.8493 .39202 .8524 .4015 .87508 .4004 .87215 .39091 Mtetra
.58 .777 .972 r
.87215 .39091 .87508 .4004 .89784 .39924 .89508 .38974 Mtetra
.582 .778 .973 r
.89508 .38974 .89784 .39924 .9207 .39802 .9181 .38849 Mtetra
.583 .778 .973 r
.9181 .38849 .9207 .39802 .94363 .39674 .9412 .38719 Mtetra
.584 .779 .973 r
.9412 .38719 .94363 .39674 .96666 .39541 .9644 .38583 Mtetra
.617 .786 .963 r
.22033 .34934 .22762 .35841 .24788 .35625 .24073 .34715 Mtetra
.24073 .34715 .24788 .35625 .26822 .35407 .26119 .34494 Mtetra
.26119 .34494 .26822 .35407 .28862 .35189 .28173 .34273 Mtetra
.28173 .34273 .28862 .35189 .30909 .34971 .30233 .34051 Mtetra
.597 .777 .966 r
.30233 .34051 .30909 .34971 .32952 .35043 .32298 .33905 Mtetra
.261 .526 .913 r
.32298 .33905 .32952 .35043 .34973 .36028 .34328 .34935 Mtetra
.328 .581 .934 r
.34328 .34935 .34973 .36028 .37015 .36815 .3638 .35755 Mtetra
.378 .621 .947 r
.3638 .35755 .37015 .36815 .39075 .37449 .38452 .36414 Mtetra
.415 .65 .955 r
.38452 .36414 .39075 .37449 .41151 .37964 .40541 .36947 Mtetra
.445 .672 .96 r
.40541 .36947 .41151 .37964 .43242 .38381 .42644 .37379 Mtetra
.467 .69 .963 r
.42644 .37379 .43242 .38381 .45346 .3872 .44761 .3773 Mtetra
.486 .704 .966 r
.44761 .3773 .45346 .3872 .47462 .38994 .4689 .38013 Mtetra
.5 .715 .967 r
.4689 .38013 .47462 .38994 .49589 .39214 .49031 .38239 Mtetra
.513 .724 .968 r
.49031 .38239 .49589 .39214 .51728 .39387 .51184 .38419 Mtetra
.523 .732 .969 r
.51184 .38419 .51728 .39387 .53876 .39522 .53346 .38558 Mtetra
.531 .738 .97 r
.53346 .38558 .53876 .39522 .56035 .39623 .55519 .38662 Mtetra
.538 .743 .97 r
.55519 .38662 .56035 .39623 .58203 .39695 .57702 .38737 Mtetra
.545 .748 .971 r
.57702 .38737 .58203 .39695 .60381 .39742 .59895 .38786 Mtetra
.55 .752 .971 r
.59895 .38786 .60381 .39742 .62568 .39766 .62097 .38811 Mtetra
.554 .756 .971 r
.62097 .38811 .62568 .39766 .64764 .39771 .64308 .38817 Mtetra
.558 .759 .971 r
.64308 .38817 .64764 .39771 .6697 .39758 .66529 .38804 Mtetra
.562 .761 .972 r
.66529 .38804 .6697 .39758 .69184 .3973 .68758 .38776 Mtetra
.565 .764 .972 r
.68758 .38776 .69184 .3973 .71407 .39687 .70997 .38733 Mtetra
.568 .766 .972 r
.70997 .38733 .71407 .39687 .73639 .39632 .73245 .38677 Mtetra
.57 .768 .972 r
.73245 .38677 .73639 .39632 .7588 .39565 .75501 .38609 Mtetra
.572 .77 .972 r
.75501 .38609 .7588 .39565 .78129 .39488 .77767 .38531 Mtetra
.574 .771 .972 r
.77767 .38531 .78129 .39488 .80388 .39401 .80041 .38443 Mtetra
.576 .773 .972 r
.80041 .38443 .80388 .39401 .82655 .39306 .82324 .38346 Mtetra
.578 .774 .972 r
.82324 .38346 .82655 .39306 .8493 .39202 .84616 .38241 Mtetra
.579 .775 .972 r
.84616 .38241 .8493 .39202 .87215 .39091 .86917 .38128 Mtetra
.58 .776 .972 r
.86917 .38128 .87215 .39091 .89508 .38974 .89227 .38008 Mtetra
.581 .777 .973 r
.89227 .38008 .89508 .38974 .9181 .38849 .91546 .37882 Mtetra
.583 .778 .973 r
.91546 .37882 .9181 .38849 .9412 .38719 .93873 .3775 Mtetra
.583 .779 .973 r
.93873 .3775 .9412 .38719 .9644 .38583 .9621 .37612 Mtetra
.617 .786 .963 r
.21294 .34014 .22033 .34934 .24073 .34715 .23347 .33792 Mtetra
.23347 .33792 .24073 .34715 .26119 .34494 .25407 .33568 Mtetra
.25407 .33568 .26119 .34494 .28173 .34273 .27474 .33344 Mtetra
.27474 .33344 .28173 .34273 .30233 .34051 .29547 .33119 Mtetra
.29547 .33119 .30233 .34051 .32298 .33905 .31628 .32893 Mtetra
.236 .542 .926 r
.31628 .32893 .32298 .33905 .34328 .34935 .33674 .33827 Mtetra
.316 .573 .932 r
.33674 .33827 .34328 .34935 .3638 .35755 .35737 .3468 Mtetra
.369 .615 .946 r
.35737 .3468 .3638 .35755 .38452 .36414 .37821 .35364 Mtetra
.409 .646 .954 r
.37821 .35364 .38452 .36414 .40541 .36947 .39922 .35916 Mtetra
.44 .669 .96 r
.39922 .35916 .40541 .36947 .42644 .37379 .42038 .36363 Mtetra
.464 .688 .963 r
.42038 .36363 .42644 .37379 .44761 .3773 .44168 .36725 Mtetra
.483 .702 .966 r
.44168 .36725 .44761 .3773 .4689 .38013 .46311 .37017 Mtetra
.498 .713 .967 r
.46311 .37017 .4689 .38013 .49031 .38239 .48466 .37251 Mtetra
.511 .723 .968 r
.48466 .37251 .49031 .38239 .51184 .38419 .50632 .37436 Mtetra
.521 .731 .969 r
.50632 .37436 .51184 .38419 .53346 .38558 .52809 .3758 Mtetra
.53 .737 .97 r
.52809 .3758 .53346 .38558 .55519 .38662 .54996 .37688 Mtetra
.537 .743 .97 r
.54996 .37688 .55519 .38662 .57702 .38737 .57194 .37765 Mtetra
.544 .747 .971 r
.57194 .37765 .57702 .38737 .59895 .38786 .59401 .37815 Mtetra
.549 .752 .971 r
.59401 .37815 .59895 .38786 .62097 .38811 .61618 .37842 Mtetra
.554 .755 .971 r
.61618 .37842 .62097 .38811 .64308 .38817 .63845 .37848 Mtetra
.558 .758 .971 r
.63845 .37848 .64308 .38817 .66529 .38804 .66081 .37836 Mtetra
.561 .761 .972 r
.66081 .37836 .66529 .38804 .68758 .38776 .68326 .37808 Mtetra
.565 .764 .972 r
.68326 .37808 .68758 .38776 .70997 .38733 .70581 .37764 Mtetra
.567 .766 .972 r
.70581 .37764 .70997 .38733 .73245 .38677 .72844 .37708 Mtetra
.57 .768 .972 r
.72844 .37708 .73245 .38677 .75501 .38609 .75117 .37639 Mtetra
.572 .77 .972 r
.75117 .37639 .75501 .38609 .77767 .38531 .77399 .3756 Mtetra
.574 .771 .972 r
.77399 .3756 .77767 .38531 .80041 .38443 .7969 .3747 Mtetra
.576 .773 .972 r
.7969 .3747 .80041 .38443 .82324 .38346 .81989 .37372 Mtetra
.577 .774 .972 r
.81989 .37372 .82324 .38346 .84616 .38241 .84298 .37265 Mtetra
.579 .775 .972 r
.84298 .37265 .84616 .38241 .86917 .38128 .86616 .3715 Mtetra
.58 .776 .972 r
.86616 .3715 .86917 .38128 .89227 .38008 .88942 .37029 Mtetra
.581 .777 .973 r
.88942 .37029 .89227 .38008 .91546 .37882 .91278 .369 Mtetra
.582 .778 .973 r
.91278 .369 .91546 .37882 .93873 .3775 .93623 .36766 Mtetra
.583 .779 .973 r
.93623 .36766 .93873 .3775 .9621 .37612 .95976 .36625 Mtetra
.617 .786 .963 r
.20545 .33081 .21294 .34014 .23347 .33792 .22611 .32856 Mtetra
.22611 .32856 .23347 .33792 .25407 .33568 .24684 .32629 Mtetra
.24684 .32629 .25407 .33568 .27474 .33344 .26764 .32402 Mtetra
.26764 .32402 .27474 .33344 .29547 .33119 .28852 .32173 Mtetra
.28852 .32173 .29547 .33119 .31628 .32893 .30947 .31944 Mtetra
.276 .588 .946 r
.30947 .31944 .31628 .32893 .33674 .33827 .33011 .32704 Mtetra
.304 .565 .929 r
.33011 .32704 .33674 .33827 .35737 .3468 .35085 .3359 Mtetra
.36 .609 .944 r
.35085 .3359 .35737 .3468 .37821 .35364 .3718 .343 Mtetra
.403 .642 .954 r
.3718 .343 .37821 .35364 .39922 .35916 .39294 .34871 Mtetra
.435 .666 .959 r
.39294 .34871 .39922 .35916 .42038 .36363 .41423 .35333 Mtetra
.46 .685 .963 r
.41423 .35333 .42038 .36363 .44168 .36725 .43566 .35707 Mtetra
.48 .7 .966 r
.43566 .35707 .44168 .36725 .46311 .37017 .45723 .36008 Mtetra
.496 .712 .967 r
.45723 .36008 .46311 .37017 .48466 .37251 .47891 .36249 Mtetra
.509 .722 .968 r
.47891 .36249 .48466 .37251 .50632 .37436 .50072 .3644 Mtetra
.52 .73 .969 r
.50072 .3644 .50632 .37436 .52809 .3758 .52263 .36587 Mtetra
.529 .736 .97 r
.52263 .36587 .52809 .3758 .54996 .37688 .54466 .36699 Mtetra
.536 .742 .97 r
.54466 .36699 .54996 .37688 .57194 .37765 .56678 .36778 Mtetra
.543 .747 .971 r
.56678 .36778 .57194 .37765 .59401 .37815 .58901 .36831 Mtetra
.548 .751 .971 r
.58901 .36831 .59401 .37815 .61618 .37842 .61133 .36859 Mtetra
.553 .755 .971 r
.61133 .36859 .61618 .37842 .63845 .37848 .63375 .36866 Mtetra
.557 .758 .971 r
.63375 .36866 .63845 .37848 .66081 .37836 .65627 .36854 Mtetra
.561 .761 .972 r
.65627 .36854 .66081 .37836 .68326 .37808 .67888 .36825 Mtetra
.564 .763 .972 r
.67888 .36825 .68326 .37808 .70581 .37764 .70158 .36781 Mtetra
.567 .766 .972 r
.70158 .36781 .70581 .37764 .72844 .37708 .72438 .36724 Mtetra
.569 .768 .972 r
.72438 .36724 .72844 .37708 .75117 .37639 .74727 .36654 Mtetra
.572 .769 .972 r
.74727 .36654 .75117 .37639 .77399 .3756 .77025 .36574 Mtetra
.574 .771 .972 r
.77025 .36574 .77399 .3756 .7969 .3747 .79333 .36483 Mtetra
.575 .772 .972 r
.79333 .36483 .7969 .3747 .81989 .37372 .81649 .36383 Mtetra
.577 .774 .972 r
.81649 .36383 .81989 .37372 .84298 .37265 .83975 .36274 Mtetra
.579 .775 .972 r
.83975 .36274 .84298 .37265 .86616 .3715 .86309 .36158 Mtetra
.58 .776 .972 r
.86309 .36158 .86616 .3715 .88942 .37029 .88653 .36034 Mtetra
.581 .777 .973 r
.88653 .36034 .88942 .37029 .91278 .369 .91006 .35903 Mtetra
.582 .778 .973 r
.91006 .35903 .91278 .369 .93623 .36766 .93368 .35766 Mtetra
.583 .779 .973 r
.93368 .35766 .93623 .36766 .95976 .36625 .95739 .35624 Mtetra
.617 .786 .963 r
.19785 .32135 .20545 .33081 .22611 .32856 .21864 .31906 Mtetra
.21864 .31906 .22611 .32856 .24684 .32629 .23951 .31676 Mtetra
.23951 .31676 .24684 .32629 .26764 .32402 .26045 .31446 Mtetra
.26045 .31446 .26764 .32402 .28852 .32173 .28146 .31214 Mtetra
.28146 .31214 .28852 .32173 .30947 .31944 .30255 .30982 Mtetra
.352 .637 .961 r
.30255 .30982 .30947 .31944 .33011 .32704 .32339 .31565 Mtetra
.292 .557 .927 r
.32339 .31565 .33011 .32704 .35085 .3359 .34424 .32485 Mtetra
.352 .604 .943 r
.34424 .32485 .35085 .3359 .3718 .343 .36531 .3322 Mtetra
.396 .638 .953 r
.36531 .3322 .3718 .343 .39294 .34871 .38657 .33811 Mtetra
.43 .663 .959 r
.38657 .33811 .39294 .34871 .41423 .35333 .40799 .34288 Mtetra
.456 .683 .963 r
.40799 .34288 .41423 .35333 .43566 .35707 .42955 .34673 Mtetra
.477 .698 .965 r
.42955 .34673 .43566 .35707 .45723 .36008 .45126 .34984 Mtetra
.493 .71 .967 r
.45126 .34984 .45723 .36008 .47891 .36249 .47309 .35232 Mtetra
.507 .72 .968 r
.47309 .35232 .47891 .36249 .50072 .3644 .49504 .35428 Mtetra
.518 .729 .969 r
.49504 .35428 .50072 .3644 .52263 .36587 .5171 .3558 Mtetra
.527 .736 .97 r
.5171 .3558 .52263 .36587 .54466 .36699 .53927 .35695 Mtetra
.535 .741 .97 r
.53927 .35695 .54466 .36699 .56678 .36778 .56155 .35777 Mtetra
.542 .746 .971 r
.56155 .35777 .56678 .36778 .58901 .36831 .58393 .35831 Mtetra
.547 .751 .971 r
.58393 .35831 .58901 .36831 .61133 .36859 .60641 .35861 Mtetra
.552 .754 .971 r
.60641 .35861 .61133 .36859 .63375 .36866 .62898 .35868 Mtetra
.557 .758 .972 r
.62898 .35868 .63375 .36866 .65627 .36854 .65166 .35856 Mtetra
.56 .76 .972 r
.65166 .35856 .65627 .36854 .67888 .36825 .67443 .35827 Mtetra
.564 .763 .972 r
.67443 .35827 .67888 .36825 .70158 .36781 .6973 .35783 Mtetra
.566 .765 .972 r
.6973 .35783 .70158 .36781 .72438 .36724 .72026 .35725 Mtetra
.569 .767 .972 r
.72026 .35725 .72438 .36724 .74727 .36654 .74331 .35655 Mtetra
.571 .769 .972 r
.74331 .35655 .74727 .36654 .77025 .36574 .76646 .35573 Mtetra
.573 .771 .972 r
.76646 .35573 .77025 .36574 .79333 .36483 .7897 .3548 Mtetra
.575 .772 .972 r
.7897 .3548 .79333 .36483 .81649 .36383 .81303 .35379 Mtetra
.577 .774 .972 r
.81303 .35379 .81649 .36383 .83975 .36274 .83646 .35268 Mtetra
.578 .775 .972 r
.83646 .35268 .83975 .36274 .86309 .36158 .85998 .3515 Mtetra
.58 .776 .972 r
.85998 .3515 .86309 .36158 .88653 .36034 .88359 .35024 Mtetra
.581 .777 .973 r
.88359 .35024 .88653 .36034 .91006 .35903 .9073 .34891 Mtetra
.582 .778 .973 r
.9073 .34891 .91006 .35903 .93368 .35766 .9311 .34752 Mtetra
.583 .779 .973 r
.9311 .34752 .93368 .35766 .95739 .35624 .95499 .34607 Mtetra
.617 .786 .963 r
.19013 .31175 .19785 .32135 .21864 .31906 .21107 .30943 Mtetra
.21107 .30943 .21864 .31906 .23951 .31676 .23207 .3071 Mtetra
.23207 .3071 .23951 .31676 .26045 .31446 .25315 .30476 Mtetra
.25315 .30476 .26045 .31446 .28146 .31214 .27431 .30241 Mtetra
.27431 .30241 .28146 .31214 .30255 .30982 .29553 .30005 Mtetra
.421 .68 .97 r
.29553 .30005 .30255 .30982 .32339 .31565 .31657 .3041 Mtetra
.279 .548 .924 r
.31657 .3041 .32339 .31565 .34424 .32485 .33754 .31365 Mtetra
.343 .598 .941 r
.33754 .31365 .34424 .32485 .36531 .3322 .35872 .32125 Mtetra
.39 .634 .952 r
.35872 .32125 .36531 .3322 .38657 .33811 .3801 .32735 Mtetra
.425 .66 .958 r
.3801 .32735 .38657 .33811 .40799 .34288 .40166 .33227 Mtetra
.452 .681 .963 r
.40166 .33227 .40799 .34288 .42955 .34673 .42336 .33625 Mtetra
.474 .696 .965 r
.42336 .33625 .42955 .34673 .45126 .34984 .4452 .33944 Mtetra
.491 .709 .967 r
.4452 .33944 .45126 .34984 .47309 .35232 .46718 .342 Mtetra
.505 .719 .968 r
.46718 .342 .47309 .35232 .49504 .35428 .48927 .34402 Mtetra
.516 .728 .969 r
.48927 .34402 .49504 .35428 .5171 .3558 .51148 .34559 Mtetra
.526 .735 .97 r
.51148 .34559 .5171 .3558 .53927 .35695 .53381 .34677 Mtetra
.534 .741 .97 r
.53381 .34677 .53927 .35695 .56155 .35777 .55623 .34761 Mtetra
.541 .746 .971 r
.55623 .34761 .56155 .35777 .58393 .35831 .57877 .34817 Mtetra
.547 .75 .971 r
.57877 .34817 .58393 .35831 .60641 .35861 .60141 .34847 Mtetra
.552 .754 .971 r
.60141 .34847 .60641 .35861 .62898 .35868 .62414 .34856 Mtetra
.556 .757 .972 r
.62414 .34856 .62898 .35868 .65166 .35856 .64698 .34844 Mtetra
.56 .76 .972 r
.64698 .34844 .65166 .35856 .67443 .35827 .66991 .34815 Mtetra
.563 .763 .972 r
.66991 .34815 .67443 .35827 .6973 .35783 .69294 .3477 Mtetra
.566 .765 .972 r
.69294 .3477 .6973 .35783 .72026 .35725 .71607 .34711 Mtetra
.569 .767 .972 r
.71607 .34711 .72026 .35725 .74331 .35655 .73929 .3464 Mtetra
.571 .769 .972 r
.73929 .3464 .74331 .35655 .76646 .35573 .76261 .34556 Mtetra
.573 .771 .972 r
.76261 .34556 .76646 .35573 .7897 .3548 .78602 .34463 Mtetra
.575 .772 .972 r
.78602 .34463 .7897 .3548 .81303 .35379 .80953 .34359 Mtetra
.577 .773 .972 r
.80953 .34359 .81303 .35379 .83646 .35268 .83313 .34247 Mtetra
.578 .775 .972 r
.83313 .34247 .83646 .35268 .85998 .3515 .85682 .34126 Mtetra
.579 .776 .972 r
.85682 .34126 .85998 .3515 .88359 .35024 .88061 .33998 Mtetra
.581 .777 .973 r
.88061 .33998 .88359 .35024 .9073 .34891 .9045 .33863 Mtetra
.582 .778 .973 r
.9045 .33863 .9073 .34891 .9311 .34752 .92847 .33722 Mtetra
.583 .779 .973 r
.92847 .33722 .9311 .34752 .95499 .34607 .95255 .33574 Mtetra
.617 .786 .963 r
.18231 .30201 .19013 .31175 .21107 .30943 .20338 .29966 Mtetra
.20338 .29966 .21107 .30943 .23207 .3071 .22453 .29729 Mtetra
.22453 .29729 .23207 .3071 .25315 .30476 .24575 .29491 Mtetra
.24575 .29491 .25315 .30476 .27431 .30241 .26704 .29253 Mtetra
.26704 .29253 .27431 .30241 .29553 .30005 .28841 .29014 Mtetra
.484 .717 .973 r
.28841 .29014 .29553 .30005 .31657 .3041 .30966 .29239 Mtetra
.267 .54 .921 r
.30966 .29239 .31657 .3041 .33754 .31365 .33073 .30228 Mtetra
.334 .592 .94 r
.33073 .30228 .33754 .31365 .35872 .32125 .35204 .31014 Mtetra
.383 .629 .951 r
.35204 .31014 .35872 .32125 .3801 .32735 .37355 .31644 Mtetra
.42 .657 .958 r
.37355 .31644 .3801 .32735 .40166 .33227 .39523 .32151 Mtetra
.449 .678 .962 r
.39523 .32151 .40166 .33227 .42336 .33625 .41708 .32561 Mtetra
.471 .695 .965 r
.41708 .32561 .42336 .33625 .4452 .33944 .43906 .3289 Mtetra
.489 .708 .967 r
.43906 .3289 .4452 .33944 .46718 .342 .46118 .33153 Mtetra
.503 .718 .968 r
.46118 .33153 .46718 .342 .48927 .34402 .48342 .3336 Mtetra
.515 .727 .969 r
.48342 .3336 .48927 .34402 .51148 .34559 .50578 .33521 Mtetra
.525 .734 .97 r
.50578 .33521 .51148 .34559 .53381 .34677 .52826 .33643 Mtetra
.533 .74 .97 r
.52826 .33643 .53381 .34677 .55623 .34761 .55084 .3373 Mtetra
.54 .745 .971 r
.55084 .3373 .55623 .34761 .57877 .34817 .57353 .33787 Mtetra
.546 .75 .971 r
.57353 .33787 .57877 .34817 .60141 .34847 .59633 .33819 Mtetra
.551 .753 .971 r
.59633 .33819 .60141 .34847 .62414 .34856 .61923 .33828 Mtetra
.555 .757 .972 r
.61923 .33828 .62414 .34856 .64698 .34844 .64223 .33816 Mtetra
.559 .76 .972 r
.64223 .33816 .64698 .34844 .66991 .34815 .66533 .33787 Mtetra
.563 .762 .972 r
.66533 .33787 .66991 .34815 .69294 .3477 .68852 .33742 Mtetra
.566 .765 .972 r
.68852 .33742 .69294 .3477 .71607 .34711 .71182 .33682 Mtetra
.568 .767 .972 r
.71182 .33682 .71607 .34711 .73929 .3464 .73521 .33609 Mtetra
.571 .769 .972 r
.73521 .33609 .73929 .3464 .76261 .34556 .7587 .33524 Mtetra
.573 .77 .972 r
.7587 .33524 .76261 .34556 .78602 .34463 .78228 .33429 Mtetra
.575 .772 .972 r
.78228 .33429 .78602 .34463 .80953 .34359 .80597 .33324 Mtetra
.576 .773 .972 r
.80597 .33324 .80953 .34359 .83313 .34247 .82974 .33209 Mtetra
.578 .775 .972 r
.82974 .33209 .83313 .34247 .85682 .34126 .85361 .33087 Mtetra
.579 .776 .972 r
.85361 .33087 .85682 .34126 .88061 .33998 .87758 .32957 Mtetra
.581 .777 .973 r
.87758 .32957 .88061 .33998 .9045 .33863 .90165 .32819 Mtetra
.582 .778 .973 r
.90165 .32819 .9045 .33863 .92847 .33722 .92581 .32675 Mtetra
.583 .779 .973 r
.92581 .32675 .92847 .33722 .95255 .33574 .95006 .32525 Mtetra
.617 .786 .963 r
.17437 .29213 .18231 .30201 .20338 .29966 .19559 .28974 Mtetra
.19559 .28974 .20338 .29966 .22453 .29729 .21687 .28734 Mtetra
.21687 .28734 .22453 .29729 .24575 .29491 .23824 .28493 Mtetra
.23824 .28493 .24575 .29491 .26704 .29253 .25968 .28251 Mtetra
.25968 .28251 .26704 .29253 .28841 .29014 .28119 .28008 Mtetra
.54 .748 .972 r
.28119 .28008 .28841 .29014 .30966 .29239 .30266 .28052 Mtetra
.254 .531 .917 r
.30266 .28052 .30966 .29239 .33073 .30228 .32384 .29075 Mtetra
.325 .586 .938 r
.32384 .29075 .33073 .30228 .35204 .31014 .34526 .29887 Mtetra
.377 .625 .95 r
.34526 .29887 .35204 .31014 .37355 .31644 .3669 .30537 Mtetra
.415 .654 .957 r
.3669 .30537 .37355 .31644 .39523 .32151 .38872 .3106 Mtetra
.445 .676 .962 r
.38872 .3106 .39523 .32151 .41708 .32561 .4107 .31481 Mtetra
.468 .693 .965 r
.4107 .31481 .41708 .32561 .43906 .3289 .43283 .31819 Mtetra
.486 .706 .967 r
.43283 .31819 .43906 .3289 .46118 .33153 .45509 .3209 Mtetra
.501 .717 .968 r
.45509 .3209 .46118 .33153 .48342 .3336 .47748 .32303 Mtetra
.513 .726 .969 r
.47748 .32303 .48342 .3336 .50578 .33521 .5 .32469 Mtetra
.523 .733 .97 r
.5 .32469 .50578 .33521 .52826 .33643 .52263 .32593 Mtetra
.532 .739 .971 r
.52263 .32593 .52826 .33643 .55084 .3373 .54537 .32683 Mtetra
.539 .745 .971 r
.54537 .32683 .55084 .3373 .57353 .33787 .56822 .32742 Mtetra
.545 .749 .971 r
.56822 .32742 .57353 .33787 .59633 .33819 .59118 .32775 Mtetra
.55 .753 .971 r
.59118 .32775 .59633 .33819 .61923 .33828 .61424 .32784 Mtetra
.555 .756 .972 r
.61424 .32784 .61923 .33828 .64223 .33816 .63741 .32773 Mtetra
.559 .759 .972 r
.63741 .32773 .64223 .33816 .66533 .33787 .66067 .32743 Mtetra
.562 .762 .972 r
.66067 .32743 .66533 .33787 .68852 .33742 .68404 .32697 Mtetra
.565 .764 .972 r
.68404 .32697 .68852 .33742 .71182 .33682 .7075 .32637 Mtetra
.568 .767 .972 r
.7075 .32637 .71182 .33682 .73521 .33609 .73107 .32562 Mtetra
.57 .769 .972 r
.73107 .32562 .73521 .33609 .7587 .33524 .75473 .32476 Mtetra
.572 .77 .972 r
.75473 .32476 .7587 .33524 .78228 .33429 .77849 .32379 Mtetra
.574 .772 .972 r
.77849 .32379 .78228 .33429 .80597 .33324 .80235 .32272 Mtetra
.576 .773 .972 r
.80235 .32272 .80597 .33324 .82974 .33209 .8263 .32156 Mtetra
.578 .774 .972 r
.8263 .32156 .82974 .33209 .85361 .33087 .85036 .32031 Mtetra
.579 .776 .972 r
.85036 .32031 .85361 .33087 .87758 .32957 .87451 .31899 Mtetra
.58 .777 .973 r
.87451 .31899 .87758 .32957 .90165 .32819 .89875 .31759 Mtetra
.582 .778 .973 r
.89875 .31759 .90165 .32819 .92581 .32675 .9231 .31612 Mtetra
.583 .779 .973 r
.9231 .31612 .92581 .32675 .95006 .32525 .94754 .31459 Mtetra
.617 .786 .963 r
.16632 .28211 .17437 .29213 .19559 .28974 .18767 .27968 Mtetra
.18767 .27968 .19559 .28974 .21687 .28734 .2091 .27724 Mtetra
.2091 .27724 .21687 .28734 .23824 .28493 .23061 .2748 Mtetra
.23061 .2748 .23824 .28493 .25968 .28251 .2522 .27234 Mtetra
.2522 .27234 .25968 .28251 .28119 .28008 .27386 .26988 Mtetra
.59 .773 .967 r
.27386 .26988 .28119 .28008 .30266 .28052 .29555 .26848 Mtetra
.241 .522 .914 r
.29555 .26848 .30266 .28052 .32384 .29075 .31684 .27905 Mtetra
.316 .58 .936 r
.31684 .27905 .32384 .29075 .34526 .29887 .33839 .28744 Mtetra
.37 .621 .949 r
.33839 .28744 .34526 .29887 .3669 .30537 .36015 .29414 Mtetra
.41 .651 .957 r
.36015 .29414 .3669 .30537 .38872 .3106 .3821 .29952 Mtetra
.441 .673 .962 r
.3821 .29952 .38872 .3106 .4107 .31481 .40422 .30385 Mtetra
.465 .691 .965 r
.40422 .30385 .4107 .31481 .43283 .31819 .4265 .30733 Mtetra
.484 .705 .967 r
.4265 .30733 .43283 .31819 .45509 .3209 .44891 .31011 Mtetra
.499 .716 .968 r
.44891 .31011 .45509 .3209 .47748 .32303 .47145 .3123 Mtetra
.511 .725 .969 r
.47145 .3123 .47748 .32303 .5 .32469 .49412 .314 Mtetra
.522 .732 .97 r
.49412 .314 .5 .32469 .52263 .32593 .51691 .31528 Mtetra
.53 .739 .971 r
.51691 .31528 .52263 .32593 .54537 .32683 .53981 .3162 Mtetra
.538 .744 .971 r
.53981 .3162 .54537 .32683 .56822 .32742 .56283 .31681 Mtetra
.544 .749 .971 r
.56283 .31681 .56822 .32742 .59118 .32775 .58595 .31715 Mtetra
.549 .753 .971 r
.58595 .31715 .59118 .32775 .61424 .32784 .60917 .31724 Mtetra
.554 .756 .972 r
.60917 .31724 .61424 .32784 .63741 .32773 .63251 .31713 Mtetra
.558 .759 .972 r
.63251 .31713 .63741 .32773 .66067 .32743 .65594 .31683 Mtetra
.562 .762 .972 r
.65594 .31683 .66067 .32743 .68404 .32697 .67948 .31637 Mtetra
.565 .764 .972 r
.67948 .31637 .68404 .32697 .7075 .32637 .70312 .31575 Mtetra
.568 .766 .972 r
.70312 .31575 .7075 .32637 .73107 .32562 .72686 .315 Mtetra
.57 .768 .972 r
.72686 .315 .73107 .32562 .75473 .32476 .7507 .31412 Mtetra
.572 .77 .972 r
.7507 .31412 .75473 .32476 .77849 .32379 .77463 .31313 Mtetra
.574 .772 .972 r
.77463 .31313 .77849 .32379 .80235 .32272 .79867 .31204 Mtetra
.576 .773 .972 r
.79867 .31204 .80235 .32272 .8263 .32156 .82281 .31086 Mtetra
.577 .774 .972 r
.82281 .31086 .8263 .32156 .85036 .32031 .84705 .30959 Mtetra
.579 .775 .972 r
.84705 .30959 .85036 .32031 .87451 .31899 .87138 .30824 Mtetra
.58 .777 .973 r
.87138 .30824 .87451 .31899 .89875 .31759 .89582 .30681 Mtetra
.581 .778 .973 r
.89582 .30681 .89875 .31759 .9231 .31612 .92035 .30532 Mtetra
.582 .779 .973 r
.92035 .30532 .9231 .31612 .94754 .31459 .94498 .30376 Mtetra
.617 .786 .963 r
.15814 .27193 .16632 .28211 .18767 .27968 .17964 .26947 Mtetra
.17964 .26947 .18767 .27968 .2091 .27724 .20122 .26699 Mtetra
.20122 .26699 .2091 .27724 .23061 .2748 .22287 .26451 Mtetra
.22287 .26451 .23061 .2748 .2522 .27234 .24461 .26202 Mtetra
.24461 .26202 .2522 .27234 .27386 .26988 .26642 .25952 Mtetra
.26642 .25952 .27386 .26988 .29555 .26848 .2883 .25701 Mtetra
.226 .528 .919 r
.2883 .25701 .29555 .26848 .31684 .27905 .30974 .26719 Mtetra
.307 .574 .934 r
.30974 .26719 .31684 .27905 .33839 .28744 .33141 .27583 Mtetra
.363 .616 .948 r
.33141 .27583 .33839 .28744 .36015 .29414 .3533 .28274 Mtetra
.405 .648 .956 r
.3533 .28274 .36015 .29414 .3821 .29952 .37539 .28828 Mtetra
.437 .671 .961 r
.37539 .28828 .3821 .29952 .40422 .30385 .39765 .29273 Mtetra
.462 .689 .965 r
.39765 .29273 .40422 .30385 .4265 .30733 .42007 .2963 Mtetra
.481 .703 .967 r
.42007 .2963 .4265 .30733 .44891 .31011 .44264 .29915 Mtetra
.497 .715 .968 r
.44264 .29915 .44891 .31011 .47145 .3123 .46533 .3014 Mtetra
.51 .724 .969 r
.46533 .3014 .47145 .3123 .49412 .314 .48816 .30315 Mtetra
.52 .732 .97 r
.48816 .30315 .49412 .314 .51691 .31528 .51111 .30446 Mtetra
.529 .738 .971 r
.51111 .30446 .51691 .31528 .53981 .3162 .53417 .30541 Mtetra
.537 .743 .971 r
.53417 .30541 .53981 .3162 .56283 .31681 .55735 .30603 Mtetra
.543 .748 .971 r
.55735 .30603 .56283 .31681 .58595 .31715 .58063 .30638 Mtetra
.549 .752 .971 r
.58063 .30638 .58595 .31715 .60917 .31724 .60403 .30648 Mtetra
.553 .756 .972 r
.60403 .30648 .60917 .31724 .63251 .31713 .62753 .30637 Mtetra
.558 .759 .972 r
.62753 .30637 .63251 .31713 .65594 .31683 .65114 .30607 Mtetra
.561 .762 .972 r
.65114 .30607 .65594 .31683 .67948 .31637 .67485 .30559 Mtetra
.564 .764 .972 r
.67485 .30559 .67948 .31637 .70312 .31575 .69867 .30497 Mtetra
.567 .766 .972 r
.69867 .30497 .70312 .31575 .72686 .315 .72258 .3042 Mtetra
.57 .768 .972 r
.72258 .3042 .72686 .315 .7507 .31412 .7466 .30331 Mtetra
.572 .77 .972 r
.7466 .30331 .7507 .31412 .77463 .31313 .77072 .3023 Mtetra
.574 .771 .972 r
.77072 .3023 .77463 .31313 .79867 .31204 .79494 .30119 Mtetra
.576 .773 .972 r
.79494 .30119 .79867 .31204 .82281 .31086 .81926 .29999 Mtetra
.577 .774 .972 r
.81926 .29999 .82281 .31086 .84705 .30959 .84368 .29869 Mtetra
.579 .775 .973 r
.84368 .29869 .84705 .30959 .87138 .30824 .86821 .29732 Mtetra
.58 .776 .973 r
.86821 .29732 .87138 .30824 .89582 .30681 .89283 .29587 Mtetra
.581 .777 .973 r
.89283 .29587 .89582 .30681 .92035 .30532 .91755 .29435 Mtetra
.582 .778 .973 r
.91755 .29435 .92035 .30532 .94498 .30376 .94238 .29276 Mtetra
.617 .786 .963 r
.14985 .2616 .15814 .27193 .17964 .26947 .17149 .2591 Mtetra
.17149 .2591 .17964 .26947 .20122 .26699 .19322 .25659 Mtetra
.19322 .25659 .20122 .26699 .22287 .26451 .21502 .25407 Mtetra
.21502 .25407 .22287 .26451 .24461 .26202 .2369 .25154 Mtetra
.2369 .25154 .24461 .26202 .26642 .25952 .25886 .249 Mtetra
.25886 .249 .26642 .25952 .2883 .25701 .2809 .24646 Mtetra
.241 .562 .936 r
.2809 .24646 .2883 .25701 .30974 .26719 .30253 .25515 Mtetra
.297 .567 .932 r
.30253 .25515 .30974 .26719 .33141 .27583 .32433 .26406 Mtetra
.356 .612 .947 r
.32433 .26406 .33141 .27583 .3533 .28274 .34635 .27117 Mtetra
.4 .644 .956 r
.34635 .27117 .3533 .28274 .37539 .28828 .36858 .27686 Mtetra
.433 .669 .961 r
.36858 .27686 .37539 .28828 .39765 .29273 .39099 .28144 Mtetra
.459 .687 .965 r
.39099 .28144 .39765 .29273 .42007 .2963 .41355 .28511 Mtetra
.479 .702 .967 r
.41355 .28511 .42007 .2963 .44264 .29915 .43627 .28803 Mtetra
.495 .713 .968 r
.43627 .28803 .44264 .29915 .46533 .3014 .45912 .29034 Mtetra
.508 .723 .969 r
.45912 .29034 .46533 .3014 .48816 .30315 .4821 .29213 Mtetra
.519 .731 .97 r
.4821 .29213 .48816 .30315 .51111 .30446 .50521 .29348 Mtetra
.528 .737 .971 r
.50521 .29348 .51111 .30446 .53417 .30541 .52844 .29445 Mtetra
.536 .743 .971 r
.52844 .29445 .53417 .30541 .55735 .30603 .55178 .29509 Mtetra
.542 .748 .971 r
.55178 .29509 .55735 .30603 .58063 .30638 .57524 .29545 Mtetra
.548 .752 .971 r
.57524 .29545 .58063 .30638 .60403 .30648 .59881 .29555 Mtetra
.553 .755 .972 r
.59881 .29555 .60403 .30648 .62753 .30637 .62248 .29544 Mtetra
.557 .758 .972 r
.62248 .29544 .62753 .30637 .65114 .30607 .64626 .29513 Mtetra
.561 .761 .972 r
.64626 .29513 .65114 .30607 .67485 .30559 .67015 .29465 Mtetra
.564 .764 .972 r
.67015 .29465 .67485 .30559 .69867 .30497 .69414 .29401 Mtetra
.567 .766 .972 r
.69414 .29401 .69867 .30497 .72258 .3042 .71824 .29323 Mtetra
.569 .768 .972 r
.71824 .29323 .72258 .3042 .7466 .30331 .74244 .29232 Mtetra
.572 .77 .972 r
.74244 .29232 .7466 .30331 .77072 .3023 .76674 .2913 Mtetra
.574 .771 .972 r
.76674 .2913 .77072 .3023 .79494 .30119 .79115 .29017 Mtetra
.575 .773 .972 r
.79115 .29017 .79494 .30119 .81926 .29999 .81566 .28894 Mtetra
.577 .774 .972 r
.81566 .28894 .81926 .29999 .84368 .29869 .84027 .28762 Mtetra
.578 .775 .973 r
.84027 .28762 .84368 .29869 .86821 .29732 .86498 .28622 Mtetra
.58 .776 .973 r
.86498 .28622 .86821 .29732 .89283 .29587 .8898 .28475 Mtetra
.581 .777 .973 r
.8898 .28475 .89283 .29587 .91755 .29435 .91471 .2832 Mtetra
.582 .778 .973 r
.91471 .2832 .91755 .29435 .94238 .29276 .93974 .28158 Mtetra
.617 .786 .963 r
.14142 .25112 .14985 .2616 .17149 .2591 .16322 .24858 Mtetra
.16322 .24858 .17149 .2591 .19322 .25659 .18509 .24603 Mtetra
.18509 .24603 .19322 .25659 .21502 .25407 .20704 .24347 Mtetra
.20704 .24347 .21502 .25407 .2369 .25154 .22908 .2409 Mtetra
.22908 .2409 .2369 .25154 .25886 .249 .25119 .23833 Mtetra
.25119 .23833 .25886 .249 .2809 .24646 .27339 .23574 Mtetra
.305 .605 .952 r
.27339 .23574 .2809 .24646 .30253 .25515 .29522 .24293 Mtetra
.288 .561 .93 r
.29522 .24293 .30253 .25515 .32433 .26406 .31714 .25211 Mtetra
.349 .608 .946 r
.31714 .25211 .32433 .26406 .34635 .27117 .3393 .25942 Mtetra
.395 .641 .955 r
.3393 .25942 .34635 .27117 .36858 .27686 .36166 .26528 Mtetra
.429 .666 .961 r
.36166 .26528 .36858 .27686 .39099 .28144 .38421 .26998 Mtetra
.456 .685 .964 r
.38421 .26998 .39099 .28144 .41355 .28511 .40693 .27374 Mtetra
.476 .7 .967 r
.40693 .27374 .41355 .28511 .43627 .28803 .4298 .27674 Mtetra
.493 .712 .968 r
.4298 .27674 .43627 .28803 .45912 .29034 .45281 .27911 Mtetra
.507 .722 .969 r
.45281 .27911 .45912 .29034 .4821 .29213 .47596 .28094 Mtetra
.518 .73 .97 r
.47596 .28094 .4821 .29213 .50521 .29348 .49923 .28232 Mtetra
.527 .737 .971 r
.49923 .28232 .50521 .29348 .52844 .29445 .52262 .28331 Mtetra
.535 .742 .971 r
.52262 .28331 .52844 .29445 .55178 .29509 .54613 .28397 Mtetra
.542 .747 .971 r
.54613 .28397 .55178 .29509 .57524 .29545 .56976 .28434 Mtetra
.547 .751 .971 r
.56976 .28434 .57524 .29545 .59881 .29555 .5935 .28445 Mtetra
.552 .755 .972 r
.5935 .28445 .59881 .29555 .62248 .29544 .61735 .28434 Mtetra
.556 .758 .972 r
.61735 .28434 .62248 .29544 .64626 .29513 .64131 .28403 Mtetra
.56 .761 .972 r
.64131 .28403 .64626 .29513 .67015 .29465 .66537 .28353 Mtetra
.564 .763 .972 r
.66537 .28353 .67015 .29465 .69414 .29401 .68955 .28288 Mtetra
.566 .766 .972 r
.68955 .28288 .69414 .29401 .71824 .29323 .71383 .28209 Mtetra
.569 .768 .972 r
.71383 .28209 .71824 .29323 .74244 .29232 .73821 .28116 Mtetra
.571 .769 .972 r
.73821 .28116 .74244 .29232 .76674 .2913 .7627 .28012 Mtetra
.573 .771 .972 r
.7627 .28012 .76674 .2913 .79115 .29017 .78729 .27897 Mtetra
.575 .773 .972 r
.78729 .27897 .79115 .29017 .81566 .28894 .81199 .27772 Mtetra
.577 .774 .972 r
.81199 .27772 .81566 .28894 .84027 .28762 .83679 .27638 Mtetra
.578 .775 .973 r
.83679 .27638 .84027 .28762 .86498 .28622 .8617 .27495 Mtetra
.58 .776 .973 r
.8617 .27495 .86498 .28622 .8898 .28475 .88671 .27344 Mtetra
.581 .777 .973 r
.88671 .27344 .8898 .28475 .91471 .2832 .91183 .27187 Mtetra
.582 .778 .973 r
.91183 .27187 .91471 .2832 .93974 .28158 .93705 .27022 Mtetra
.617 .786 .963 r
.13287 .24047 .14142 .25112 .16322 .24858 .15482 .2379 Mtetra
.15482 .2379 .16322 .24858 .18509 .24603 .17684 .23531 Mtetra
.17684 .23531 .18509 .24603 .20704 .24347 .19895 .23271 Mtetra
.19895 .23271 .20704 .24347 .22908 .2409 .22114 .2301 Mtetra
.22114 .2301 .22908 .2409 .25119 .23833 .2434 .22749 Mtetra
.2434 .22749 .25119 .23833 .27339 .23574 .26575 .22486 Mtetra
.365 .644 .963 r
.26575 .22486 .27339 .23574 .29522 .24293 .2878 .23053 Mtetra
.278 .555 .928 r
.2878 .23053 .29522 .24293 .31714 .25211 .30984 .23998 Mtetra
.343 .603 .944 r
.30984 .23998 .31714 .25211 .3393 .25942 .33213 .2475 Mtetra
.39 .638 .954 r
.33213 .2475 .3393 .25942 .36166 .26528 .35464 .25352 Mtetra
.425 .664 .96 r
.35464 .25352 .36166 .26528 .38421 .26998 .37734 .25834 Mtetra
.452 .683 .964 r
.37734 .25834 .38421 .26998 .40693 .27374 .40021 .2622 Mtetra
.474 .699 .967 r
.40021 .2622 .40693 .27374 .4298 .27674 .42323 .26528 Mtetra
.491 .711 .968 r
.42323 .26528 .4298 .27674 .45281 .27911 .4464 .2677 Mtetra
.505 .721 .969 r
.4464 .2677 .45281 .27911 .47596 .28094 .46971 .26958 Mtetra
.516 .729 .97 r
.46971 .26958 .47596 .28094 .49923 .28232 .49315 .27099 Mtetra
.526 .736 .971 r
.49315 .27099 .49923 .28232 .52262 .28331 .51671 .27201 Mtetra
.534 .742 .971 r
.51671 .27201 .52262 .28331 .54613 .28397 .54039 .27268 Mtetra
.541 .747 .971 r
.54039 .27268 .54613 .28397 .56976 .28434 .56419 .27306 Mtetra
.547 .751 .972 r
.56419 .27306 .56976 .28434 .5935 .28445 .58811 .27317 Mtetra
.552 .755 .972 r
.58811 .27317 .5935 .28445 .61735 .28434 .61213 .27306 Mtetra
.556 .758 .972 r
.61213 .27306 .61735 .28434 .64131 .28403 .63627 .27274 Mtetra
.56 .761 .972 r
.63627 .27274 .64131 .28403 .66537 .28353 .66052 .27224 Mtetra
.563 .763 .972 r
.66052 .27224 .66537 .28353 .68955 .28288 .68488 .27158 Mtetra
.566 .765 .972 r
.68488 .27158 .68955 .28288 .71383 .28209 .70934 .27077 Mtetra
.569 .767 .972 r
.70934 .27077 .71383 .28209 .73821 .28116 .73391 .26982 Mtetra
.571 .769 .972 r
.73391 .26982 .73821 .28116 .7627 .28012 .75859 .26876 Mtetra
.573 .771 .972 r
.75859 .26876 .7627 .28012 .78729 .27897 .78338 .26759 Mtetra
.575 .772 .972 r
.78338 .26759 .78729 .27897 .81199 .27772 .80827 .26631 Mtetra
.577 .774 .972 r
.80827 .26631 .81199 .27772 .83679 .27638 .83327 .26494 Mtetra
.578 .775 .973 r
.83327 .26494 .83679 .27638 .8617 .27495 .85837 .26349 Mtetra
.579 .776 .973 r
.85837 .26349 .8617 .27495 .88671 .27344 .88358 .26196 Mtetra
.581 .777 .973 r
.88358 .26196 .88671 .27344 .91183 .27187 .90889 .26035 Mtetra
.582 .778 .973 r
.90889 .26035 .91183 .27187 .93705 .27022 .93432 .25867 Mtetra
.617 .786 .963 r
.12419 .22967 .13287 .24047 .15482 .2379 .14629 .22705 Mtetra
.14629 .22705 .15482 .2379 .17684 .23531 .16847 .22442 Mtetra
.16847 .22442 .17684 .23531 .19895 .23271 .19073 .22178 Mtetra
.19073 .22178 .19895 .23271 .22114 .2301 .21307 .21914 Mtetra
.21307 .21914 .22114 .2301 .2434 .22749 .2355 .21648 Mtetra
.2355 .21648 .2434 .22749 .26575 .22486 .25801 .21381 Mtetra
.421 .679 .969 r
.25801 .21381 .26575 .22486 .2878 .23053 .28027 .21794 Mtetra
.269 .548 .925 r
.28027 .21794 .2878 .23053 .30984 .23998 .30244 .22767 Mtetra
.336 .598 .943 r
.30244 .22767 .30984 .23998 .33213 .2475 .32486 .2354 Mtetra
.385 .635 .954 r
.32486 .2354 .33213 .2475 .35464 .25352 .34751 .24157 Mtetra
.421 .661 .96 r
.34751 .24157 .35464 .25352 .37734 .25834 .37036 .24652 Mtetra
.449 .681 .964 r
.37036 .24652 .37734 .25834 .40021 .2622 .39338 .25048 Mtetra
.471 .697 .966 r
.39338 .25048 .40021 .2622 .42323 .26528 .41656 .25363 Mtetra
.489 .71 .968 r
.41656 .25363 .42323 .26528 .4464 .2677 .43989 .25612 Mtetra
.503 .72 .969 r
.43989 .25612 .4464 .2677 .46971 .26958 .46337 .25804 Mtetra
.515 .728 .97 r
.46337 .25804 .46971 .26958 .49315 .27099 .48697 .25948 Mtetra
.525 .735 .971 r
.48697 .25948 .49315 .27099 .51671 .27201 .5107 .26052 Mtetra
.533 .741 .971 r
.5107 .26052 .51671 .27201 .54039 .27268 .53456 .26121 Mtetra
.54 .746 .971 r
.53456 .26121 .54039 .27268 .56419 .27306 .55853 .2616 Mtetra
.546 .75 .972 r
.55853 .2616 .56419 .27306 .58811 .27317 .58263 .26171 Mtetra
.551 .754 .972 r
.58263 .26171 .58811 .27317 .61213 .27306 .60684 .2616 Mtetra
.555 .757 .972 r
.60684 .2616 .61213 .27306 .63627 .27274 .63116 .26127 Mtetra
.559 .76 .972 r
.63116 .26127 .63627 .27274 .66052 .27224 .65559 .26076 Mtetra
.563 .763 .972 r
.65559 .26076 .66052 .27224 .68488 .27158 .68013 .26009 Mtetra
.566 .765 .972 r
.68013 .26009 .68488 .27158 .70934 .27077 .70479 .25926 Mtetra
.568 .767 .972 r
.70479 .25926 .70934 .27077 .73391 .26982 .72955 .2583 Mtetra
.571 .769 .972 r
.72955 .2583 .73391 .26982 .75859 .26876 .75442 .25721 Mtetra
.573 .771 .972 r
.75442 .25721 .75859 .26876 .78338 .26759 .7794 .25602 Mtetra
.575 .772 .972 r
.7794 .25602 .78338 .26759 .80827 .26631 .80448 .25472 Mtetra
.576 .774 .972 r
.80448 .25472 .80827 .26631 .83327 .26494 .82968 .25332 Mtetra
.578 .775 .973 r
.82968 .25332 .83327 .26494 .85837 .26349 .85498 .25184 Mtetra
.579 .776 .973 r
.85498 .25184 .85837 .26349 .88358 .26196 .88039 .25028 Mtetra
.581 .777 .973 r
.88039 .25028 .88358 .26196 .90889 .26035 .90591 .24864 Mtetra
.582 .778 .973 r
.90591 .24864 .90889 .26035 .93432 .25867 .93154 .24693 Mtetra
.617 .786 .963 r
.11538 .21869 .12419 .22967 .14629 .22705 .13763 .21604 Mtetra
.13763 .21604 .14629 .22705 .16847 .22442 .15996 .21337 Mtetra
.15996 .21337 .16847 .22442 .19073 .22178 .18238 .21069 Mtetra
.18238 .21069 .19073 .22178 .21307 .21914 .20488 .208 Mtetra
.20488 .208 .21307 .21914 .2355 .21648 .22747 .2053 Mtetra
.22747 .2053 .2355 .21648 .25801 .21381 .25014 .20259 Mtetra
.472 .709 .973 r
.25014 .20259 .25801 .21381 .28027 .21794 .27263 .20517 Mtetra
.259 .542 .923 r
.27263 .20517 .28027 .21794 .30244 .22767 .29492 .21517 Mtetra
.329 .594 .942 r
.29492 .21517 .30244 .22767 .32486 .2354 .31748 .22311 Mtetra
.379 .631 .953 r
.31748 .22311 .32486 .2354 .34751 .24157 .34027 .22945 Mtetra
.417 .659 .96 r
.34027 .22945 .34751 .24157 .37036 .24652 .36327 .23452 Mtetra
.446 .679 .964 r
.36327 .23452 .37036 .24652 .39338 .25048 .38645 .23858 Mtetra
.469 .696 .966 r
.38645 .23858 .39338 .25048 .41656 .25363 .40979 .2418 Mtetra
.487 .708 .968 r
.40979 .2418 .41656 .25363 .43989 .25612 .43328 .24434 Mtetra
.502 .719 .969 r
.43328 .24434 .43989 .25612 .46337 .25804 .45692 .24631 Mtetra
.514 .727 .97 r
.45692 .24631 .46337 .25804 .48697 .25948 .4807 .24779 Mtetra
.524 .735 .971 r
.4807 .24779 .48697 .25948 .5107 .26052 .5046 .24885 Mtetra
.532 .74 .971 r
.5046 .24885 .5107 .26052 .53456 .26121 .52863 .24956 Mtetra
.539 .746 .971 r
.52863 .24956 .53456 .26121 .55853 .2616 .55279 .24995 Mtetra
.545 .75 .972 r
.55279 .24995 .55853 .2616 .58263 .26171 .57706 .25007 Mtetra
.55 .754 .972 r
.57706 .25007 .58263 .26171 .60684 .2616 .60145 .24995 Mtetra
.555 .757 .972 r
.60145 .24995 .60684 .2616 .63116 .26127 .62596 .24962 Mtetra
.559 .76 .972 r
.62596 .24962 .63116 .26127 .65559 .26076 .65058 .2491 Mtetra
.562 .763 .972 r
.65058 .2491 .65559 .26076 .68013 .26009 .67531 .24841 Mtetra
.565 .765 .972 r
.67531 .24841 .68013 .26009 .70479 .25926 .70015 .24757 Mtetra
.568 .767 .972 r
.70015 .24757 .70479 .25926 .72955 .2583 .72511 .24658 Mtetra
.57 .769 .972 r
.72511 .24658 .72955 .2583 .75442 .25721 .75018 .24548 Mtetra
.573 .771 .972 r
.75018 .24548 .75442 .25721 .7794 .25602 .77535 .24426 Mtetra
.574 .772 .972 r
.77535 .24426 .7794 .25602 .80448 .25472 .80064 .24293 Mtetra
.576 .773 .972 r
.80064 .24293 .80448 .25472 .82968 .25332 .82603 .24151 Mtetra
.578 .775 .973 r
.82603 .24151 .82968 .25332 .85498 .25184 .85154 .24 Mtetra
.579 .776 .973 r
.85154 .24 .85498 .25184 .88039 .25028 .87715 .23841 Mtetra
.58 .777 .973 r
.87715 .23841 .88039 .25028 .90591 .24864 .90288 .23674 Mtetra
.582 .778 .973 r
.90288 .23674 .90591 .24864 .93154 .24693 .92872 .23499 Mtetra
.617 .786 .963 r
.10642 .20755 .11538 .21869 .13763 .21604 .12883 .20485 Mtetra
.12883 .20485 .13763 .21604 .15996 .21337 .15132 .20214 Mtetra
.15132 .20214 .15996 .21337 .18238 .21069 .1739 .19942 Mtetra
.1739 .19942 .18238 .21069 .20488 .208 .19656 .19669 Mtetra
.19656 .19669 .20488 .208 .22747 .2053 .21931 .19395 Mtetra
.21931 .19395 .22747 .2053 .25014 .20259 .24214 .1912 Mtetra
.52 .736 .973 r
.24214 .1912 .25014 .20259 .27263 .20517 .26487 .1922 Mtetra
.25 .535 .92 r
.26487 .1922 .27263 .20517 .29492 .21517 .28728 .20248 Mtetra
.322 .589 .94 r
.28728 .20248 .29492 .21517 .31748 .22311 .30998 .21063 Mtetra
.374 .628 .952 r
.30998 .21063 .31748 .22311 .34027 .22945 .33292 .21713 Mtetra
.413 .656 .959 r
.33292 .21713 .34027 .22945 .36327 .23452 .35607 .22233 Mtetra
.443 .678 .963 r
.35607 .22233 .36327 .23452 .38645 .23858 .3794 .22648 Mtetra
.466 .694 .966 r
.3794 .22648 .38645 .23858 .40979 .2418 .40291 .22979 Mtetra
.485 .707 .968 r
.40291 .22979 .40979 .2418 .43328 .24434 .42657 .23239 Mtetra
.5 .718 .969 r
.42657 .23239 .43328 .24434 .45692 .24631 .45037 .2344 Mtetra
.512 .727 .97 r
.45037 .2344 .45692 .24631 .4807 .24779 .47432 .23591 Mtetra
.522 .734 .971 r
.47432 .23591 .4807 .24779 .5046 .24885 .4984 .23699 Mtetra
.531 .74 .971 r
.4984 .23699 .5046 .24885 .52863 .24956 .52261 .23771 Mtetra
.538 .745 .971 r
.52261 .23771 .52863 .24956 .55279 .24995 .54695 .23811 Mtetra
.544 .75 .972 r
.54695 .23811 .55279 .24995 .57706 .25007 .5714 .23824 Mtetra
.55 .753 .972 r
.5714 .23824 .57706 .25007 .60145 .24995 .59598 .23811 Mtetra
.554 .757 .972 r
.59598 .23811 .60145 .24995 .62596 .24962 .62067 .23777 Mtetra
.558 .76 .972 r
.62067 .23777 .62596 .24962 .65058 .2491 .64548 .23724 Mtetra
.562 .762 .972 r
.64548 .23724 .65058 .2491 .67531 .24841 .67041 .23654 Mtetra
.565 .765 .972 r
.67041 .23654 .67531 .24841 .70015 .24757 .69545 .23568 Mtetra
.568 .767 .972 r
.69545 .23568 .70015 .24757 .72511 .24658 .7206 .23468 Mtetra
.57 .769 .972 r
.7206 .23468 .72511 .24658 .75018 .24548 .74586 .23355 Mtetra
.572 .77 .972 r
.74586 .23355 .75018 .24548 .77535 .24426 .77124 .2323 Mtetra
.574 .772 .972 r
.77124 .2323 .77535 .24426 .80064 .24293 .79673 .23095 Mtetra
.576 .773 .972 r
.79673 .23095 .80064 .24293 .82603 .24151 .82233 .2295 Mtetra
.578 .775 .973 r
.82233 .2295 .82603 .24151 .85154 .24 .84804 .22796 Mtetra
.579 .776 .973 r
.84804 .22796 .85154 .24 .87715 .23841 .87386 .22633 Mtetra
.58 .777 .973 r
.87386 .22633 .87715 .23841 .90288 .23674 .8998 .22463 Mtetra
.581 .778 .973 r
.8998 .22463 .90288 .23674 .92872 .23499 .92584 .22286 Mtetra
.617 .786 .963 r
.09733 .19623 .10642 .20755 .12883 .20485 .1199 .19349 Mtetra
.1199 .19349 .12883 .20485 .15132 .20214 .14255 .19074 Mtetra
.14255 .19074 .15132 .20214 .1739 .19942 .16529 .18797 Mtetra
.16529 .18797 .1739 .19942 .19656 .19669 .18811 .1852 Mtetra
.18811 .1852 .19656 .19669 .21931 .19395 .21102 .18242 Mtetra
.21102 .18242 .21931 .19395 .24214 .1912 .23402 .17962 Mtetra
.563 .759 .97 r
.23402 .17962 .24214 .1912 .26487 .1922 .25699 .17903 Mtetra
.24 .528 .918 r
.25699 .17903 .26487 .1922 .28728 .20248 .27953 .18959 Mtetra
.315 .584 .939 r
.27953 .18959 .28728 .20248 .30998 .21063 .30237 .19795 Mtetra
.369 .624 .951 r
.30237 .19795 .30998 .21063 .33292 .21713 .32545 .20462 Mtetra
.409 .654 .959 r
.32545 .20462 .33292 .21713 .35607 .22233 .34875 .20995 Mtetra
.44 .676 .963 r
.34875 .20995 .35607 .22233 .3794 .22648 .37225 .2142 Mtetra
.464 .693 .966 r
.37225 .2142 .3794 .22648 .40291 .22979 .39591 .21758 Mtetra
.483 .706 .968 r
.39591 .21758 .40291 .22979 .42657 .23239 .41974 .22024 Mtetra
.498 .717 .969 r
.41974 .22024 .42657 .23239 .45037 .2344 .44372 .22229 Mtetra
.511 .726 .97 r
.44372 .22229 .45037 .2344 .47432 .23591 .46784 .22383 Mtetra
.521 .733 .971 r
.46784 .22383 .47432 .23591 .4984 .23699 .4921 .22494 Mtetra
.53 .739 .971 r
.4921 .22494 .4984 .23699 .52261 .23771 .51649 .22568 Mtetra
.537 .745 .971 r
.51649 .22568 .52261 .23771 .54695 .23811 .54101 .22608 Mtetra
.544 .749 .972 r
.54101 .22608 .54695 .23811 .5714 .23824 .56565 .22621 Mtetra
.549 .753 .972 r
.56565 .22621 .5714 .23824 .59598 .23811 .59042 .22608 Mtetra
.554 .756 .972 r
.59042 .22608 .59598 .23811 .62067 .23777 .6153 .22573 Mtetra
.558 .759 .972 r
.6153 .22573 .62067 .23777 .64548 .23724 .6403 .22519 Mtetra
.561 .762 .972 r
.6403 .22519 .64548 .23724 .67041 .23654 .66542 .22447 Mtetra
.565 .764 .972 r
.66542 .22447 .67041 .23654 .69545 .23568 .69066 .22359 Mtetra
.567 .767 .972 r
.69066 .22359 .69545 .23568 .7206 .23468 .71601 .22257 Mtetra
.57 .768 .972 r
.71601 .22257 .7206 .23468 .74586 .23355 .74148 .22142 Mtetra
.572 .77 .972 r
.74148 .22142 .74586 .23355 .77124 .2323 .76706 .22015 Mtetra
.574 .772 .972 r
.76706 .22015 .77124 .2323 .79673 .23095 .79275 .21877 Mtetra
.576 .773 .972 r
.79275 .21877 .79673 .23095 .82233 .2295 .81856 .21729 Mtetra
.577 .774 .973 r
.81856 .21729 .82233 .2295 .84804 .22796 .84448 .21571 Mtetra
.579 .776 .973 r
.84448 .21571 .84804 .22796 .87386 .22633 .87051 .21406 Mtetra
.58 .777 .973 r
.87051 .21406 .87386 .22633 .8998 .22463 .89666 .21232 Mtetra
.581 .778 .973 r
.89666 .21232 .8998 .22463 .92584 .22286 .92292 .21051 Mtetra
.617 .786 .963 r
.0881 .18473 .09733 .19623 .1199 .19349 .11082 .18195 Mtetra
.11082 .18195 .1199 .19349 .14255 .19074 .13364 .17915 Mtetra
.13364 .17915 .14255 .19074 .16529 .18797 .15654 .17634 Mtetra
.15654 .17634 .16529 .18797 .18811 .1852 .17953 .17353 Mtetra
.17953 .17353 .18811 .1852 .21102 .18242 .2026 .1707 Mtetra
.2026 .1707 .21102 .18242 .23402 .17962 .22577 .16786 Mtetra
.602 .779 .965 r
.22577 .16786 .23402 .17962 .25699 .17903 .24899 .16566 Mtetra
.23 .521 .915 r
.24899 .16566 .25699 .17903 .27953 .18959 .27166 .1765 Mtetra
.307 .58 .937 r
.27166 .1765 .27953 .18959 .30237 .19795 .29463 .18508 Mtetra
.363 .621 .95 r
.29463 .18508 .30237 .19795 .32545 .20462 .31787 .19191 Mtetra
.405 .651 .958 r
.31787 .19191 .32545 .20462 .34875 .20995 .34132 .19736 Mtetra
.437 .674 .963 r
.34132 .19736 .34875 .20995 .37225 .2142 .36497 .20172 Mtetra
.461 .691 .966 r
.36497 .20172 .37225 .2142 .39591 .21758 .38881 .20517 Mtetra
.481 .705 .968 r
.38881 .20517 .39591 .21758 .41974 .22024 .41281 .20789 Mtetra
.497 .716 .969 r
.41281 .20789 .41974 .22024 .44372 .22229 .43696 .20999 Mtetra
.51 .725 .97 r
.43696 .20999 .44372 .22229 .46784 .22383 .46126 .21156 Mtetra
.52 .732 .971 r
.46126 .21156 .46784 .22383 .4921 .22494 .4857 .21269 Mtetra
.529 .739 .971 r
.4857 .21269 .4921 .22494 .51649 .22568 .51027 .21344 Mtetra
.537 .744 .971 r
.51027 .21344 .51649 .22568 .54101 .22608 .53498 .21385 Mtetra
.543 .749 .972 r
.53498 .21385 .54101 .22608 .56565 .22621 .55981 .21398 Mtetra
.548 .753 .972 r
.55981 .21398 .56565 .22621 .59042 .22608 .58476 .21385 Mtetra
.553 .756 .972 r
.58476 .21385 .59042 .22608 .6153 .22573 .60984 .21349 Mtetra
.557 .759 .972 r
.60984 .21349 .6153 .22573 .6403 .22519 .63504 .21294 Mtetra
.561 .762 .972 r
.63504 .21294 .6403 .22519 .66542 .22447 .66036 .2122 Mtetra
.564 .764 .972 r
.66036 .2122 .66542 .22447 .69066 .22359 .68579 .2113 Mtetra
.567 .766 .972 r
.68579 .2113 .69066 .22359 .71601 .22257 .71135 .21026 Mtetra
.569 .768 .972 r
.71135 .21026 .71601 .22257 .74148 .22142 .73702 .20908 Mtetra
.572 .77 .972 r
.73702 .20908 .74148 .22142 .76706 .22015 .7628 .20778 Mtetra
.574 .772 .972 r
.7628 .20778 .76706 .22015 .79275 .21877 .7887 .20637 Mtetra
.575 .773 .973 r
.7887 .20637 .79275 .21877 .81856 .21729 .81472 .20486 Mtetra
.577 .774 .973 r
.81472 .20486 .81856 .21729 .84448 .21571 .84086 .20326 Mtetra
.579 .775 .973 r
.84086 .20326 .84448 .21571 .87051 .21406 .86711 .20157 Mtetra
.58 .777 .973 r
.86711 .20157 .87051 .21406 .89666 .21232 .89347 .1998 Mtetra
.581 .778 .973 r
.89347 .1998 .89666 .21232 .92292 .21051 .91995 .19795 Mtetra
.617 .786 .963 r
.07871 .17305 .0881 .18473 .11082 .18195 .1016 .17022 Mtetra
.1016 .17022 .11082 .18195 .13364 .17915 .12458 .16738 Mtetra
.12458 .16738 .13364 .17915 .15654 .17634 .14765 .16453 Mtetra
.14765 .16453 .15654 .17634 .17953 .17353 .17081 .16167 Mtetra
.17081 .16167 .17953 .17353 .2026 .1707 .19405 .15879 Mtetra
.19405 .15879 .2026 .1707 .22577 .16786 .21739 .15591 Mtetra
.21739 .15591 .22577 .16786 .24899 .16566 .24081 .15301 Mtetra
.22 .533 .922 r
.24081 .15301 .24899 .16566 .27166 .1765 .26366 .1632 Mtetra
.3 .575 .936 r
.26366 .1632 .27166 .1765 .29463 .18508 .28678 .172 Mtetra
.358 .617 .95 r
.28678 .172 .29463 .18508 .31787 .19191 .31016 .179 Mtetra
.401 .648 .958 r
.31016 .179 .31787 .19191 .34132 .19736 .33377 .18458 Mtetra
.434 .672 .963 r
.33377 .18458 .34132 .19736 .36497 .20172 .35759 .18903 Mtetra
.459 .689 .966 r
.35759 .18903 .36497 .20172 .38881 .20517 .38159 .19257 Mtetra
.479 .704 .968 r
.38159 .19257 .38881 .20517 .41281 .20789 .40576 .19534 Mtetra
.495 .715 .969 r
.40576 .19534 .41281 .20789 .43696 .20999 .43009 .19748 Mtetra
.508 .724 .97 r
.43009 .19748 .43696 .20999 .46126 .21156 .45457 .19909 Mtetra
.519 .732 .971 r
.45457 .19909 .46126 .21156 .4857 .21269 .47919 .20024 Mtetra
.528 .738 .971 r
.47919 .20024 .4857 .21269 .51027 .21344 .50395 .201 Mtetra
.536 .744 .971 r
.50395 .201 .51027 .21344 .53498 .21385 .52884 .20142 Mtetra
.542 .748 .972 r
.52884 .20142 .53498 .21385 .55981 .21398 .55386 .20155 Mtetra
.548 .752 .972 r
.55386 .20155 .55981 .21398 .58476 .21385 .57901 .20141 Mtetra
.553 .756 .972 r
.57901 .20141 .58476 .21385 .60984 .21349 .60429 .20105 Mtetra
.557 .759 .972 r
.60429 .20105 .60984 .21349 .63504 .21294 .62969 .20048 Mtetra
.561 .762 .972 r
.62969 .20048 .63504 .21294 .66036 .2122 .6552 .19972 Mtetra
.564 .764 .972 r
.6552 .19972 .66036 .2122 .68579 .2113 .68084 .1988 Mtetra
.567 .766 .972 r
.68084 .1988 .68579 .2113 .71135 .21026 .7066 .19774 Mtetra
.569 .768 .972 r
.7066 .19774 .71135 .21026 .73702 .20908 .73248 .19653 Mtetra
.571 .77 .972 r
.73248 .19653 .73702 .20908 .7628 .20778 .75848 .19521 Mtetra
.573 .771 .972 r
.75848 .19521 .7628 .20778 .7887 .20637 .78459 .19377 Mtetra
.575 .773 .973 r
.78459 .19377 .7887 .20637 .81472 .20486 .81082 .19223 Mtetra
.577 .774 .973 r
.81082 .19223 .81472 .20486 .84086 .20326 .83717 .19059 Mtetra
.578 .775 .973 r
.83717 .19059 .84086 .20326 .86711 .20157 .86364 .18887 Mtetra
.58 .776 .973 r
.86364 .18887 .86711 .20157 .89347 .1998 .89023 .18706 Mtetra
.581 .777 .973 r
.89023 .18706 .89347 .1998 .91995 .19795 .91693 .18517 Mtetra
.617 .786 .963 r
.06918 .16119 .07871 .17305 .1016 .17022 .09223 .15831 Mtetra
.09223 .15831 .1016 .17022 .12458 .16738 .11538 .15542 Mtetra
.11538 .15542 .12458 .16738 .14765 .16453 .13862 .15252 Mtetra
.13862 .15252 .14765 .16453 .17081 .16167 .16194 .14961 Mtetra
.16194 .14961 .17081 .16167 .19405 .15879 .18536 .14669 Mtetra
.18536 .14669 .19405 .15879 .21739 .15591 .20887 .14376 Mtetra
.20887 .14376 .21739 .15591 .24081 .15301 .23247 .14082 Mtetra
.248 .565 .937 r
.23247 .14082 .24081 .15301 .26366 .1632 .25554 .1497 Mtetra
.293 .57 .934 r
.25554 .1497 .26366 .1632 .28678 .172 .27879 .15871 Mtetra
.353 .614 .949 r
.27879 .15871 .28678 .172 .31016 .179 .30233 .16588 Mtetra
.397 .646 .957 r
.30233 .16588 .31016 .179 .33377 .18458 .3261 .17159 Mtetra
.43 .67 .962 r
.3261 .17159 .33377 .18458 .35759 .18903 .35008 .17614 Mtetra
.456 .688 .966 r
.35008 .17614 .35759 .18903 .38159 .19257 .37425 .17975 Mtetra
.477 .702 .968 r
.37425 .17975 .38159 .19257 .40576 .19534 .39859 .18259 Mtetra
.493 .714 .969 r
.39859 .18259 .40576 .19534 .43009 .19748 .4231 .18477 Mtetra
.507 .723 .97 r
.4231 .18477 .43009 .19748 .45457 .19909 .44776 .18641 Mtetra
.518 .731 .971 r
.44776 .18641 .45457 .19909 .47919 .20024 .47257 .18758 Mtetra
.527 .738 .971 r
.47257 .18758 .47919 .20024 .50395 .201 .49752 .18836 Mtetra
.535 .743 .971 r
.49752 .18836 .50395 .201 .52884 .20142 .5226 .18878 Mtetra
.542 .748 .972 r
.5226 .18878 .52884 .20142 .55386 .20155 .54782 .18891 Mtetra
.547 .752 .972 r
.54782 .18891 .55386 .20155 .57901 .20141 .57317 .18877 Mtetra
.552 .755 .972 r
.57317 .18877 .57901 .20141 .60429 .20105 .59864 .18839 Mtetra
.556 .759 .972 r
.59864 .18839 .60429 .20105 .62969 .20048 .62424 .1878 Mtetra
.56 .761 .972 r
.62424 .1878 .62969 .20048 .6552 .19972 .64996 .18703 Mtetra
.563 .764 .972 r
.64996 .18703 .6552 .19972 .68084 .1988 .67581 .18609 Mtetra
.566 .766 .972 r
.67581 .18609 .68084 .1988 .7066 .19774 .70178 .185 Mtetra
.569 .768 .972 r
.70178 .185 .7066 .19774 .73248 .19653 .72787 .18377 Mtetra
.571 .77 .972 r
.72787 .18377 .73248 .19653 .75848 .19521 .75408 .18242 Mtetra
.573 .771 .972 r
.75408 .18242 .75848 .19521 .78459 .19377 .78041 .18095 Mtetra
.575 .773 .973 r
.78041 .18095 .78459 .19377 .81082 .19223 .80686 .17938 Mtetra
.577 .774 .973 r
.80686 .17938 .81082 .19223 .83717 .19059 .83343 .1777 Mtetra
.578 .775 .973 r
.83343 .1777 .83717 .19059 .86364 .18887 .86012 .17594 Mtetra
.58 .776 .973 r
.86012 .17594 .86364 .18887 .89023 .18706 .88693 .1741 Mtetra
.581 .777 .973 r
.88693 .1741 .89023 .18706 .91693 .18517 .91386 .17217 Mtetra
.617 .786 .963 r
.05949 .14913 .06918 .16119 .09223 .15831 .08271 .1462 Mtetra
.08271 .1462 .09223 .15831 .11538 .15542 .10603 .14327 Mtetra
.10603 .14327 .11538 .15542 .13862 .15252 .12944 .14032 Mtetra
.12944 .14032 .13862 .15252 .16194 .14961 .15293 .13737 Mtetra
.15293 .13737 .16194 .14961 .18536 .14669 .17653 .1344 Mtetra
.17653 .1344 .18536 .14669 .20887 .14376 .20021 .13142 Mtetra
.20021 .13142 .20887 .14376 .23247 .14082 .22398 .12842 Mtetra
.3 .601 .95 r
.22398 .12842 .23247 .14082 .25554 .1497 .24728 .13597 Mtetra
.286 .565 .933 r
.24728 .13597 .25554 .1497 .27879 .15871 .27068 .14521 Mtetra
.347 .61 .948 r
.27068 .14521 .27879 .15871 .30233 .16588 .29437 .15254 Mtetra
.393 .643 .957 r
.29437 .15254 .30233 .16588 .3261 .17159 .3183 .15839 Mtetra
.427 .668 .962 r
.3183 .15839 .3261 .17159 .35008 .17614 .34244 .16304 Mtetra
.454 .686 .965 r
.34244 .16304 .35008 .17614 .37425 .17975 .36679 .16673 Mtetra
.475 .701 .968 r
.36679 .16673 .37425 .17975 .39859 .18259 .39131 .16962 Mtetra
.492 .713 .969 r
.39131 .16962 .39859 .18259 .4231 .18477 .416 .17185 Mtetra
.505 .722 .97 r
.416 .17185 .4231 .18477 .44776 .18641 .44085 .17352 Mtetra
.517 .73 .971 r
.44085 .17352 .44776 .18641 .47257 .18758 .46584 .17471 Mtetra
.526 .737 .971 r
.46584 .17471 .47257 .18758 .49752 .18836 .49098 .1755 Mtetra
.534 .743 .971 r
.49098 .1755 .49752 .18836 .5226 .18878 .51626 .17593 Mtetra
.541 .747 .972 r
.51626 .17593 .5226 .18878 .54782 .18891 .54168 .17605 Mtetra
.547 .751 .972 r
.54168 .17605 .54782 .18891 .57317 .18877 .56722 .1759 Mtetra
.552 .755 .972 r
.56722 .1759 .57317 .18877 .59864 .18839 .5929 .17552 Mtetra
.556 .758 .972 r
.5929 .17552 .59864 .18839 .62424 .1878 .6187 .17492 Mtetra
.56 .761 .972 r
.6187 .17492 .62424 .1878 .64996 .18703 .64463 .17413 Mtetra
.563 .764 .972 r
.64463 .17413 .64996 .18703 .67581 .18609 .67069 .17316 Mtetra
.566 .766 .972 r
.67069 .17316 .67581 .18609 .70178 .185 .69687 .17205 Mtetra
.569 .768 .972 r
.69687 .17205 .70178 .185 .72787 .18377 .72317 .17079 Mtetra
.571 .769 .972 r
.72317 .17079 .72787 .18377 .75408 .18242 .7496 .16941 Mtetra
.573 .771 .972 r
.7496 .16941 .75408 .18242 .78041 .18095 .77615 .16791 Mtetra
.575 .773 .973 r
.77615 .16791 .78041 .18095 .80686 .17938 .80282 .1663 Mtetra
.577 .774 .973 r
.80282 .1663 .80686 .17938 .83343 .1777 .82961 .16459 Mtetra
.578 .775 .973 r
.82961 .16459 .83343 .1777 .86012 .17594 .85653 .16279 Mtetra
.579 .776 .973 r
.85653 .16279 .86012 .17594 .88693 .1741 .88357 .16091 Mtetra
.581 .777 .973 r
.88357 .16091 .88693 .1741 .91386 .17217 .91073 .15895 Mtetra
.617 .786 .963 r
.04964 .13687 .05949 .14913 .08271 .1462 .07304 .1339 Mtetra
.07304 .1339 .08271 .1462 .10603 .14327 .09653 .13092 Mtetra
.09653 .13092 .10603 .14327 .12944 .14032 .12011 .12792 Mtetra
.12011 .12792 .12944 .14032 .15293 .13737 .14378 .12492 Mtetra
.14378 .12492 .15293 .13737 .17653 .1344 .16755 .1219 Mtetra
.16755 .1219 .17653 .1344 .20021 .13142 .19141 .11887 Mtetra
.19141 .11887 .20021 .13142 .22398 .12842 .21536 .11582 Mtetra
.35 .634 .96 r
.21536 .11582 .22398 .12842 .24728 .13597 .2389 .12203 Mtetra
.278 .56 .931 r
.2389 .12203 .24728 .13597 .27068 .14521 .26244 .13148 Mtetra
.342 .607 .947 r
.26244 .13148 .27068 .14521 .29437 .15254 .28628 .13899 Mtetra
.389 .64 .956 r
.28628 .13899 .29437 .15254 .3183 .15839 .31037 .14497 Mtetra
.424 .665 .962 r
.31037 .14497 .3183 .15839 .34244 .16304 .33468 .14972 Mtetra
.451 .685 .965 r
.33468 .14972 .34244 .16304 .36679 .16673 .3592 .15349 Mtetra
.473 .7 .967 r
.3592 .15349 .36679 .16673 .39131 .16962 .3839 .15644 Mtetra
.49 .712 .969 r
.3839 .15644 .39131 .16962 .416 .17185 .40878 .15871 Mtetra
.504 .722 .97 r
.40878 .15871 .416 .17185 .44085 .17352 .43381 .16041 Mtetra
.516 .73 .971 r
.43381 .16041 .44085 .17352 .46584 .17471 .459 .16162 Mtetra
.525 .736 .971 r
.459 .16162 .46584 .17471 .49098 .1755 .48433 .16242 Mtetra
.533 .742 .971 r
.48433 .16242 .49098 .1755 .51626 .17593 .50981 .16285 Mtetra
.54 .747 .972 r
.50981 .16285 .51626 .17593 .54168 .17605 .53542 .16298 Mtetra
.546 .751 .972 r
.53542 .16298 .54168 .17605 .56722 .1759 .56117 .16282 Mtetra
.551 .755 .972 r
.56117 .16282 .56722 .1759 .5929 .17552 .58706 .16242 Mtetra
.555 .758 .972 r
.58706 .16242 .5929 .17552 .6187 .17492 .61307 .1618 Mtetra
.559 .761 .972 r
.61307 .1618 .6187 .17492 .64463 .17413 .63921 .16099 Mtetra
.563 .763 .972 r
.63921 .16099 .64463 .17413 .67069 .17316 .66548 .16001 Mtetra
.566 .766 .972 r
.66548 .16001 .67069 .17316 .69687 .17205 .69188 .15887 Mtetra
.568 .768 .972 r
.69188 .15887 .69687 .17205 .72317 .17079 .7184 .15758 Mtetra
.571 .769 .972 r
.7184 .15758 .72317 .17079 .7496 .16941 .74504 .15617 Mtetra
.573 .771 .972 r
.74504 .15617 .7496 .16941 .77615 .16791 .77182 .15463 Mtetra
.575 .772 .973 r
.77182 .15463 .77615 .16791 .80282 .1663 .79871 .15299 Mtetra
.576 .774 .973 r
.79871 .15299 .80282 .1663 .82961 .16459 .82573 .15125 Mtetra
.578 .775 .973 r
.82573 .15125 .82961 .16459 .85653 .16279 .85288 .14941 Mtetra
.579 .776 .973 r
.85288 .14941 .85653 .16279 .88357 .16091 .88015 .14749 Mtetra
.58 .777 .973 r
.88015 .14749 .88357 .16091 .91073 .15895 .90754 .14548 Mtetra
.617 .786 .963 r
.03963 .12441 .04964 .13687 .07304 .1339 .0632 .12139 Mtetra
.0632 .12139 .07304 .1339 .09653 .13092 .08686 .11836 Mtetra
.08686 .11836 .09653 .13092 .12011 .12792 .11062 .11531 Mtetra
.11062 .11531 .12011 .12792 .14378 .12492 .13447 .11226 Mtetra
.13447 .11226 .14378 .12492 .16755 .1219 .15842 .10919 Mtetra
.15842 .10919 .16755 .1219 .19141 .11887 .18246 .10611 Mtetra
.18246 .10611 .19141 .11887 .21536 .11582 .2066 .10302 Mtetra
.398 .664 .966 r
.2066 .10302 .21536 .11582 .2389 .12203 .23037 .10786 Mtetra
.271 .555 .929 r
.23037 .10786 .2389 .12203 .26244 .13148 .25406 .11754 Mtetra
.336 .603 .946 r
.25406 .11754 .26244 .13148 .28628 .13899 .27805 .12521 Mtetra
.384 .638 .955 r
.27805 .12521 .28628 .13899 .31037 .14497 .30231 .13132 Mtetra
.421 .663 .961 r
.30231 .13132 .31037 .14497 .33468 .14972 .3268 .13618 Mtetra
.449 .683 .965 r
.3268 .13618 .33468 .14972 .3592 .15349 .35149 .14002 Mtetra
.471 .698 .967 r
.35149 .14002 .3592 .15349 .3839 .15644 .37637 .14303 Mtetra
.488 .711 .969 r
.37637 .14303 .3839 .15644 .40878 .15871 .40143 .14534 Mtetra
.503 .721 .97 r
.40143 .14534 .40878 .15871 .43381 .16041 .42666 .14708 Mtetra
.514 .729 .971 r
.42666 .14708 .43381 .16041 .459 .16162 .45204 .14831 Mtetra
.524 .736 .971 r
.45204 .14831 .459 .16162 .48433 .16242 .47757 .14912 Mtetra
.532 .741 .971 r
.47757 .14912 .48433 .16242 .50981 .16285 .50325 .14956 Mtetra
.539 .746 .972 r
.50325 .14956 .50981 .16285 .53542 .16298 .52907 .14967 Mtetra
.545 .751 .972 r
.52907 .14967 .53542 .16298 .56117 .16282 .55502 .14951 Mtetra
.55 .754 .972 r
.55502 .14951 .56117 .16282 .58706 .16242 .58111 .1491 Mtetra
.555 .758 .972 r
.58111 .1491 .58706 .16242 .61307 .1618 .60734 .14846 Mtetra
.559 .761 .972 r
.60734 .14846 .61307 .1618 .63921 .16099 .63369 .14763 Mtetra
.562 .763 .972 r
.63369 .14763 .63921 .16099 .66548 .16001 .66018 .14662 Mtetra
.565 .765 .972 r
.66018 .14662 .66548 .16001 .69188 .15887 .68679 .14545 Mtetra
.568 .767 .972 r
.68679 .14545 .69188 .15887 .7184 .15758 .71354 .14414 Mtetra
.57 .769 .972 r
.71354 .14414 .7184 .15758 .74504 .15617 .74041 .14269 Mtetra
.572 .771 .972 r
.74041 .14269 .74504 .15617 .77182 .15463 .76741 .14112 Mtetra
.574 .772 .973 r
.76741 .14112 .77182 .15463 .79871 .15299 .79453 .13944 Mtetra
.576 .774 .973 r
.79453 .13944 .79871 .15299 .82573 .15125 .82178 .13766 Mtetra
.578 .775 .973 r
.82178 .13766 .82573 .15125 .85288 .14941 .84916 .13579 Mtetra
.579 .776 .973 r
.84916 .13579 .85288 .14941 .88015 .14749 .87667 .13382 Mtetra
.58 .777 .973 r
.87667 .13382 .88015 .14749 .90754 .14548 .9043 .13178 Mtetra
.617 .786 .963 r
.02946 .11175 .03963 .12441 .0632 .12139 .0532 .10868 Mtetra
.0532 .10868 .0632 .12139 .08686 .11836 .07704 .10559 Mtetra
.07704 .10559 .08686 .11836 .11062 .11531 .10098 .1025 Mtetra
.10098 .1025 .11062 .11531 .13447 .11226 .12501 .09939 Mtetra
.12501 .09939 .13447 .11226 .15842 .10919 .14914 .09627 Mtetra
.14914 .09627 .15842 .10919 .18246 .10611 .17336 .09314 Mtetra
.17336 .09314 .18246 .10611 .2066 .10302 .19768 .08999 Mtetra
.442 .691 .971 r
.19768 .08999 .2066 .10302 .23037 .10786 .22171 .09346 Mtetra
.264 .55 .927 r
.22171 .09346 .23037 .10786 .25406 .11754 .24554 .10336 Mtetra
.331 .599 .945 r
.24554 .10336 .25406 .11754 .27805 .12521 .26969 .11121 Mtetra
.38 .635 .955 r
.26969 .11121 .27805 .12521 .30231 .13132 .29411 .11745 Mtetra
.418 .661 .961 r
.29411 .11745 .30231 .13132 .3268 .13618 .31877 .12241 Mtetra
.446 .681 .965 r
.31877 .12241 .3268 .13618 .35149 .14002 .34365 .12633 Mtetra
.469 .697 .967 r
.34365 .12633 .35149 .14002 .37637 .14303 .36871 .1294 Mtetra
.487 .71 .969 r
.36871 .1294 .37637 .14303 .40143 .14534 .39396 .13175 Mtetra
.501 .72 .97 r
.39396 .13175 .40143 .14534 .42666 .14708 .41938 .13351 Mtetra
.513 .728 .971 r
.41938 .13351 .42666 .14708 .45204 .14831 .44496 .13477 Mtetra
.523 .735 .971 r
.44496 .13477 .45204 .14831 .47757 .14912 .47069 .13558 Mtetra
.532 .741 .971 r
.47069 .13558 .47757 .14912 .50325 .14956 .49657 .13603 Mtetra
.539 .746 .972 r
.49657 .13603 .50325 .14956 .52907 .14967 .5226 .13614 Mtetra
.545 .75 .972 r
.5226 .13614 .52907 .14967 .55502 .14951 .54876 .13597 Mtetra
.55 .754 .972 r
.54876 .13597 .55502 .14951 .58111 .1491 .57507 .13554 Mtetra
.554 .757 .972 r
.57507 .13554 .58111 .1491 .60734 .14846 .6015 .13489 Mtetra
.558 .76 .972 r
.6015 .13489 .60734 .14846 .63369 .14763 .62808 .13404 Mtetra
.562 .763 .972 r
.62808 .13404 .63369 .14763 .66018 .14662 .65478 .133 Mtetra
.565 .765 .972 r
.65478 .133 .66018 .14662 .68679 .14545 .68162 .1318 Mtetra
.568 .767 .972 r
.68162 .1318 .68679 .14545 .71354 .14414 .70859 .13046 Mtetra
.57 .769 .972 r
.70859 .13046 .71354 .14414 .74041 .14269 .73569 .12898 Mtetra
.572 .771 .973 r
.73569 .12898 .74041 .14269 .76741 .14112 .76292 .12737 Mtetra
.574 .772 .973 r
.76292 .12737 .76741 .14112 .79453 .13944 .79028 .12566 Mtetra
.576 .774 .973 r
.79028 .12566 .79453 .13944 .82178 .13766 .81776 .12384 Mtetra
.577 .775 .973 r
.81776 .12384 .82178 .13766 .84916 .13579 .84538 .12192 Mtetra
.579 .776 .973 r
.84538 .12192 .84916 .13579 .87667 .13382 .87312 .11991 Mtetra
.58 .777 .973 r
.87312 .11991 .87667 .13382 .9043 .13178 .901 .11782 Mtetra
0 g
.89362 0 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.89362 0 m
.02946 .11175 L
s
.02946 .11175 m
.89362 0 L
s
gsave
.44797 -0.02478 -65.9056 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .4272 m
.29069 .70824 L
s
gsave
.15892 .66839 -66.3192 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{261.563, 185.063},
  ImageMargins->{{30.25, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.095767,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000560000ia000`40O003h00OogooAgoo003oOom7
Ool00?moodMoo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo002SOol200000goo0000002N
Ool00:9oo`03001oogoo008009moo`00XWoo00D007ooOomoo`0009moo`00XWoo00D007ooOomoo`00
09moo`00XWoo00D007ooOomoo`0009moo`00XGoo0P000Woo0P00Wgoo003oOom7Ool00?moodMoo`00
ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7
Ool00?moodMoo`00ogooAgoo003oOolEOol4000^Ool00?moo`eoo`P000=oo`03001oogoo02aoo`00
ogoo1Goo20002goo00<007ooOol0;7oo003mOol7000COol2000]Ool00?Eoo`P001Yoo`8002eoo`00
kGoo20008Woo0P00;Goo003VOol7000ZOol2000]Ool00=ioo`P0035oo`03001oo`0002aoo`00eWoo
2000>Woo0P00;7oo003>Ool80012Ool2000/Ool00<Moo`L004Yoo`8002aoo`00_goo2000DGoo00<0
07oo0000:goo002gOol8001IOol00`00Ool0000[Ool00;1oo`L0065oo`03001oo`0002]oo`00Z7oo
2000J7oo00<007oo0000:goo002POol8001`Ool00`00Ool0000[Ool009Uoo`L007Qoo`04001oogoo
000ZOol0095oo`P007moo`04001oogoo000ZOol008Uoo`P008Moo`04001oogoo000ZOol0089oo`L0
08moo`04001oogoo000ZOol007Yoo`P009Ioo`05001oogooOol0000YOol0079oo`P009ioo`05001o
ogooOol0000YOol006Yoo`P00:Moo`04001oogoo000YOol006=oo`L00:moo`04001oogoo000YOol0
05]oo`P00;Ioo`05001oogooOol0000XOol005=oo`P0000:Bae??T/MCai;7DlnBae?7T/M>[h3=[h0
0cZnOomoo`2^Ool01@00Oomoogoo0000:7oo001<Ool700000dlNBai?7P02Cah01D/NCai?7TlNBah0
0dlN00A;7TlNCai?7PHf_P037Qeoogoo0:aoo`05001oogooOol0000XOol004Aoo`P0000KCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCahf_SZn00<f_P06>[hN728m
7Q`R?AhLZGoo00D007ooOomoo`0002Qoo`00?7oo20000TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P0<;YhbWS:N<Yh^WS:N7QdR?AhL
7SdN7BYMYgoo00D007ooOomoo`0002Qoo`00>7oo100003Y??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7RjM<[h^WS:N;Ydb_QhL8SdN728m9UdZGBIM:WhVGJ=oo`03001oogoo009oo`03001oogoo02Eoo`00
>7oo00D004lNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?
7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00D^WS:N<YhbWRjN00<R?@087Q`N
?BIM:UdVGBYM9Ud^OZ5oo`03001oogoo009oo`03001oogoo02Eoo`00>7oo04@004/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7RYm<[h^WS:N;YdR?AhL8SdN72Yn9UdZGBIM:Wh^OBjN;Wdb
WRimWGoo00<007ooOol00Woo00<007ooOol09Goo000hOol00`00Oom;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?
7T/N00=?7P05Bai?7TlN:WhZO@03:Wh041hl8SdR?B8m7S`ZGBIM:UdVGBYM;Wd^ORim;Wh^OCJN0c:N
00<fWS:NOol0Qgoo00m;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN000017oo00<007ooOol09Goo
000hOol0D@00Oom?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBadZWRYm;YhZOBZN7Q`R
?AhL8SdVGBYn9UdZORIM<Yh^OBjN;WdbWS:M=YhbWCJn<YdfWS:M>[hfWSZn=Ydj_P1cOol07T/OA_i;
7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBal000Eoo`03
001oogoo02Aoo`00>7oo00D007ooOom?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN:WhZ
ORYm008ZOPDR?@DZG@07;Wh^OBjN;Wd^OS:N=Yh00c:N00<fWSJn=[h013Jn1CZnGgoo0TLN00E6oTLN
Aai77TKn00=77P05A_i77TLNAai6oP02Aah01D/NAai77TLNBah00dLN01=;7TLNAai77T/NAai;7TLN
Bai77T/NAai;7TLNBai77T/NAah00005Ool00`00Oomoo`0TOol003Moo`03001oogoo009oo`1JCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??R9M:YhZOBjN:WdR?AhL8SdR?28m9UdZORIM:Wh^
OC:N;WdbWRim<YhbWCJN<Ydf_S:M=YhfWCZn=Yhj_SJM>]hj_S[N>[djgSZn?]hj_SkN>[hngSZn1ckN
?7oo0456oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKnBai6oT/OA_i;
7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;
7dKnBai6oT/OA_i;7P0000Eoo`03001oogoo02Aoo`00=goo00<007ooOol00goo00=?7T/NCah00TlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01T/N9UdRGBIN8UdVG@DR?@0::WdZGBYM:UdZOBim;Wh^OBjN;Wd2
<Yh013JN<YhbWS:N1SJn1CZn00LjgSkN>[hngS[N?]hj_P06?]h01D;N?]hngSkN@]h00SkN00M2gT;n
?]i2oT;N@_hngP03@_h00d;N@_ioo`0=Ool02D;nA_i2oTKn@_i6oT;nA_i2oP03A_h00d;nA_i6oP08
A_h01DLNA_i6oTKnAah00dKn01977TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah0
1DKnAai77TLNA_h00dLN00=6oTLNAah014LN00E;7TLNAai77T/N00=77P0BBai77TLNAai;7TLNBai7
7T/NAai;7TLNBai77T/NAai;7P0017oo00<007ooOol097oo000gOol00`00Oomoo`04Ool0FTlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M9WhRGBIN8UdVOR8l8SdN728m8S`ZORIM:WhZGBYn;Wdb
WRim<Yh^OCJn<YdfWS:M=[hbWCZn=Ydj_SJN>[hj_C[N>[hjgSZm>]hj_SkN>[hngSZn?]hj_PHngP1m
@_hngT;n?]i2oSkN@_hngT;n?]i2oSkN@_i2gT;n@]i2oT;N@_i2gT;n@]i6oT;N@_i2gTKn@_i6oT;N
A_i2oTKn@_i77T;nA_i2oTLN@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i77TKn
Aai6oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oTLNA_i;7dKnBai6oT/OA_i;7TKn
Bam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKn
Bai6oT/OA_h00005Ool00`00Oomoo`0SOol003Moo`03001oogoo00Aoo`9?7P05Bai?7TlNCai;7P03
Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00U;7TlNCai?7T/N7SdRGBIN8Ud01B8m00<ZGBYm:Ud00RYM00@bWRim;Wh^O@@bWP03=Yhb
WS:N00Hf_PHj_P05>]hngS[N?]hjgP08?]h03T;N?]hngSkN@]hngT;n@]i2oSkN@_i2gT;n@]h3@_h0
0d;N@_i2oP08@_h02TKn@_i2oT;nA_i2oTKn@_i6oT;n0dKn00E2oTKnA_i6oT;n00Y6oP05Aai6oTKn
A_i77P03A_h04TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6
oP03Aah014KnAai77T/N0dLN00E;7TLNAai77T/N00=77P0@Bai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77T/N0005Ool00`00Oomoo`0SOol003Moo`03001oogoo00Eoo`0_Bae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCahJ?0037Sd09aXl9SdR?28m8S`V?BYM:WhVGBYn:UdbWRim<Yh^OC:N<Ydf_S:M
=[hbWCJn=Yhj_SJM>[hfWS[N>[djgSZn>]hj_CkN>[hngSZn?]hj_P08?]h0Nd;n?]i2oSkN@_hngT;n
?]i2oSkN@_hngT;n@]i2oT;N@_i2gTKn@]i2oT;NA_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nAai2oTKn
@_i77T;nA_i2oTLN@_i6oT;nAai2oTLN@_i77T;nAai2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oT/N
A_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam6oT/N
A_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_h00005Ool00`00
Oomoo`0SOol003Moo`03001oogoo00Ioo`9?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00A;7TlNCai?7PDN
?@@R?@0C:WdZGBYm:UdZOBim<Yh^OBin;WdfWS:N=YhbWSJN<YhfWSJn>[h00cJn1SZn00HngS[N?]hj
gSkN>]h8?]h014;N?]hngSkN0T;N00A2oT;N@_i2gP=2oP05@]i2oT;n@_i2gP0:@_h02TKn@_i2oT;n
A_i2oTKn@_i6oT;n3TKn00E77TKnA_i6oTLN00=6oP0FAai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6
oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00A6oTLNAai;7P=77P05Bai77TLNAai;
7P03Aah03d/NAai;7TLNBai77T/NAai;7TLNBai77T/N001;7P04Ool00`00Oomoo`0SOol003Moo`03
001oogoo00Moo`0_Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCahJ70037Sd09b8l9UdR?BHm
8S`ZORYM:WhZGBYn;WdbWRim<Yh^OCJn<Ydf_S:M=[hbWCZn=[hj_SJM>[hf_S[N>[dngSZn>]hj_SkN
>[hngSZn?]hj_P06?]h0O4;n?]i2oSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oT;N@_i2gT;n@]i6oT;N
@_i2gTKn@]i6oT;nA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAai2oTLN@_i77T;nAai2oTLNA_i77T;n
Aai6oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKn
Bai6oT/NA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKn
Bam6oT/NA_i;7dKnBai6oT/OA_h004Kn17oo00<007ooOol08goo000gOol00`00Oomoo`08Ool2Cah0
1D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P06Bai?7TlN6QdJ71XM0Qhm0b8m018V?B8m:WdZGBYm:UdbWRim<Yh^
OC:N;Wdf_S:N=YhbWSJN<Yh2=[h01CZn=[hf_SZn>]h00cZn0S[N0ckN00<jgSkN?]h023kN00Y2gSkN
?]hngT;n@]i2oT;N@_i2gP=2oP03@]i2oT;n00Q2oP0<A_i2oT;n@_i6oT;nA_i2oTKn@_i6oT;n44Kn
01Y77TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6
oTLNAai77TKn00977P05Bai6oTLNAai;7P03Aah01D/NAai77TLNBah00dLN015;7TLNAai77T/NAai;
7TLNBai77T/NAai;7TLNBah004/N00Eoo`03001oogoo029oo`00=goo00<007ooOol02Goo04];7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBadJ7AXL6QdJ72Hm8S`VGB8m9SdZGBin:Ud^ORYM<Yh^OC:N
;WdbWS:M=[hbWCJn<Ydf_SJM>[hf_SZn=Yd00SZn00XjgSZm?]hj_SkN>[hngSZn?]hj_P@ngP1n@]hn
gSkN?]i2oSkN@_hngT;n?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]i2oT;NA_i2oTKn@]i6oT;nA_i2
oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i77TKnAai2oTLNA_i77TKnAai6
oTLNA_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6
oT/NA_h004Kn1Goo00<007ooOol08Woo000gOol00`00Oomoo`09Ool3Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00A;7TlNCai?7PM;
7P8J70036QdJ72IM00<R?@039SdZGBYm008ZO@09:UdbWRim<Yh^OC:N=Yhf_S:N008fWP8f_P04>[hf
_SZn=[h2>[h01S[N>[hj_SZn?]hjgP<ngP03>]hngSkN00@ngP06@]hngT;N?]i2gSkN0T;N00I2oT;N
@_i2gT;n@]h3@_h00d;N@_i2oP08@_h01TKn@_i2oT;nA_i2oP=6oP03@_i6oTKn0116oP0JAai6oTKn
A_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNBai6
oP02Aah01D/NA_i77TLNBah00dLN00E;7TLNAai77T/N00=77P0?Bai77T/NAai;7TLNBai77T/NAai;
7TLNBah004/N00Eoo`03001oogoo029oo`00=Woo00<007ooOol02goo05U??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai:oDlNBai?7T[mCai;7QhM6O`J7B8m9UdR?2IM8Sd^ORYM;WhZGBin;WdbWRim<Yh^OCJn<Ydf_S:M
=[hbWCZn=Ydj_SJn>[hfWCkN>[hjgSZm?]hj_SkN>[hngSZn?]hj_T;N00<ngP1l@]hngT;n?]i2oSkN
@_hngT;n?]i2oSkN@_hngT;n@]i2oT;N@_i2gT;n@]i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;n
Aai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn
Aai6oT/NA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKn
Bam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oP00A_h5Ool0
0`00Oomoo`0ROol003Ioo`03001oogoo00aoo`=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah014/NCai?7TlN1T/N0QXL00TIo1XL8SdV
GB8m9SdR?Bin:Ud00bYm00D^OC:N<YdbWRim008fWP0:=[hfWSJN=Yhj_SJn>[hf_SZn=[h2>[h00c[N
>[hj_P02?]h00c[N?]hngP08?]h03T;N?]i2gSkN@]hngT;n@]i2oT;N@_i2gT;n@]h3@_h00d;N@_i2
oP08@_h01TKn@_i2oT;nA_i2oP=6oP03@_i6oTKn00a6oP05Aai6oTKnA_i77P03A_h05TLNA_i77TKn
Aai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai;7TKn00977P05Bai6
oTLNAai;7P03Aah01D/NAai77TLNBah00dLN00e;7TLNBai77T/NAai;7TLNBai77T/N001;7P06Ool0
0`00Oomoo`0QOol003Ioo`03001oogoo00eoo`1FCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNB_e?7T/NCai:oDlN
6O`N7AWl7QdR?BIM8S`VGBYM;WhZGBin:UdbWRim<Yh^OC:N<Ydf_S:M=[hbWCJn<Ydj_SJm>[hf_SZn
>[dngSZn>]hj_CkN>[hngSZn?]hj_P8ngP1o@]hngSkN?]i2gSkN@_hngT;n?]i2oSkN@_hngT;n?]i2
oSkN@_i2gT;n@]i2oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN@_i7
7T;nAai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;
7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_h004KnBah01Goo00<007ooOol08Goo000f
Ool00`00Oomoo`0>Ool3Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;
7P03Cah01D/NCai?7TlNBah00dlN00A;7TlNCai?7PI6oP0;7Q`J71Wl9UdV?BIM9SdVGBYm;WhZG@02
:Wd00c:N<WdbWP02<Yh3=Yh023Jn=YhfWSJn>[hf_SZn=[h4>[h00c[N>[hngP02?]h00c[N?]hngP08
?]h014;N?]i2gSkN0T;N00A2oT;N@_i2gPi2oP06A_i2oTKn@_i6oT;n0dKn00=2oTKnA_h044Kn01Y7
7TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLN
Aai77TKn00977P05Bai6oTLNAai;7P03Aah01D/NAai77TLNBah00dLN011;7TLNBai77T/NAai;7TLN
Bai77T/NAai;7P00Bai77PEoo`03001oogoo025oo`00=Woo00<007ooOol03goo04A??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MAai6oTLNA_i77TKn7QdJ71hM6O`VGB8m9UdR?2IM:Ud^ORYM;Wh^OC:N;WdbWRim<YhbWCJn
=Ydf_S:M0SJn010j_SJm>[hf_SkN>[dngSZn?]hj_CkN>[hngSZn?]hj_P8ngP1m@_hngSkN?]i2oSkN
@_hngT;n?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]i2oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;n
Aai2oTKn@_i77T;nA_i2oTLN@_i77T;nAai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i77TKn
Aai6oTLNA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKn
Bam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oP00A_i;7`05
Ool00`00Oomoo`0QOol003Ioo`03001oogoo00moo`05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00TlN1TKn0QhL00/N
7AXL9UdV?BIM9Sd^OBYm;WhZOBim008bWP09<WdbWS:N=[hfWSJn=Yhf_SJN00<j_P04=[hj_SZn>]h3
>[h00c[N?]hngP0;?]h034;N?]i2oSkN@]hngT;n@]i2oT;N@_i2gPi2oP06A_i2oTKn@_i6oT;n0dKn
00=2oTKnA_h044Kn01977TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai7
7TLNA_h00dLN00E6oTLNAai;7TKn00977P05Bai6oTLNAai;7P03Aah01D/NAai77TLNBah00dLN00m;
7TLNBai77T/NAai;7TLNBai77T/N001;7TLNBah01Goo00<007ooOol087oo000fOol00`00Oomoo`0@
Ool0ED/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7D;n?]i2ockN@_hngQhM6Q`N7BHm9UdV?BIM8S`^ORYM;WhZGBin
<WdbWRim<YhbOCJn<Ydf_SJM=[hbWCZn=[hj_SJm>[hf_SkN>[dngSZn?]hj_SkN>[hngSZn00@ngP1l
@_hngSkN?]i2oSkN@_hngT;n?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]i6oT;NA_i2oTKn@]i6oT;n
A_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i77TKnAai6oTLNA_i77TKn
Aai6oTLNA_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKn
Bal004/NA_h5Ool00`00Oomoo`0POol003Ioo`03001oogoo015oo`05Bai?7TlNCai;7P03Cah01D/N
Cai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah034/NCai?7TlNBai?7T;N
@_hngT;n@]i2oP<N70037QdV?BIM008VG@05:Wd^OBYm;WhZO@03<Yh01c:M<YhbWSJn=Yhf_SJN008f
_P<j_P08=[hj_SZn>]hj_S[N>[hjgPdngP04@]hngT;n?]h2@]h014;n@]i2oT;N3T;n00Q6oT;nA_i2
oTKn@_i6oT;n0dKn00=2oTKnA_h044Kn01977TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLN
A_h3Aah01DKnAai77TLNA_h00dLN00E6oTLNAai;7TKn00977P05Bai6oTLNAai;7P03Aah01D/NAai7
7TLNBah00dLN00e;7TLNBai77T/NAai;7TLNBai77P00Aai;7P05Ool00`00Oomoo`0POol003Ioo`03
001oogoo019oo`19Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??SkN@_hngT;o?]i2oQXL7QdN72IM9SdVGBHm9UdZGBin
:Wd^ORYM<YhbOC:N;WdbWSJM=[hbWCJn=Ydj_SJm>[hf_SZn=[d00SZn08PngSZm?]hj_SkN>[hngS[N
?]hj_T;n?]i2gSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oSkN@_i2gT;n@]i6oT;N@_i2gTKn@_i6oT;N
A_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i77TKn
Aai6oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKn
Bai6oT/OAai;7P00Bam77PEoo`03001oogoo021oo`00=Woo00<007ooOol04goo00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P06Bai?7TlN
Cai;7TlN0S[N00@j_S[N>]hjgP<N70059UdV?BIM9Ud^OP03;Wd00bin;WdbWP02<Yh01c:M<YhfWSJn
=Yhf_SJN00Hj_P06>]hj_SkN>[hjgSZn33kN00a2oSkN@]hngT;n?]i2oT;N@_i2gT;n@]h>@_h024Kn
@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP08A_h01DLNA_i6oTKnAah00dKn01977TKnAai6oTLNA_i7
7TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00E6oTLNAai;7TKn00977P05
Bai77TLNAai;7P03Aah054/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN00177T/NAah4Ool0
0`00Oomoo`0POol003Eoo`03001oogoo01Eoo`11Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBadjgcZn>]hj_S[O>[hR?AhL
7QdV?BYM9SdZGBHm;WhZGBin:Wd^OS9m<YhbWC:N<Wdf_SJM=[hbW@02=[h03SZn=[dj_SJn>[hf_CkN
>[hngSZm?]hj_SkN>[h4?]h0OD;n?]i2gSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oSkN@_i2gT;n@]i6
oT;N@_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i7
7T;nAai6oTLN@_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;
7TKnBam6oT/NA_i;7dKnBai6oT/O001;7TKnBal01Goo00<007ooOol07goo000eOol00`00Oomoo`0E
Ool00dlNBai?7P02Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03
Cah01D/NCai?7TlNBah00dlN00E;7S[N>]hjgSZn008jgP037QdN71hM00DVG@06;Wh^OBim;Wd^OS:M
0c:N00HbWCJn=[hf_SJN=[h7>[h01C[N>[hngSZn>]h033kN00=2gT;n?]h00T;N00=2oT;N@_h00T;n
00=2gT;n@_h034;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP08A_h01DLNA_i6oTKnAah00dKn0197
7TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00E6oTLN
Aai;7TKn00977P05Bai6oTLNAai;7P03Aah05T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77P00Aai;7TLN1Goo00<007ooOol07goo000eOol00`00Oomoo`0FOol0@TlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Badf_S:N=[hbWSJn7Q`R?AhL8SdVGBYM9SdZGBim;WhZOBin;WdbWS9m<YhbWC:N=Ydf_SJM=[hfW@8f
_P0:>[hf_C[N=[hngSZm?]hj_SkN>[d3?]h0PCZn?]hngT;N?]i2oSkN@]hngT;n?]i2oSkN@_hngT;n
?]i2oT;N@_hngT;n@]i2oT;NA_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN
@_i77T;nAai2oTLN@_i77TKnAai2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oT/NA_i77TKnBai6oTLN
A_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam6oT/NA_i;7dKnBai6oT/O
A_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/N001;7dLNBai6oP04Ool00`00Oomoo`0O
Ool003Eoo`03001oogoo01Moo`03Cai;7TlN009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah044/N<[hb_SJn<YhR?AhL7QdN72YM9UdZ
GBIM:Ud^OBin0bim00<bWS:M<Yh00S:N00DfWSJn=[hf_SJN00Hj_P06?]hj_S[N>[hngSZn33kN0T;N
00I2oSkN@]i2gT;n@]h3@_h00d;N@_i2oP04@_h01DKn@_i2oT;nA_h00d;n00I6oT;nA_i2oTKn@_h3
A_h00d;nA_i6oP08A_h01DLNA_i6oTKnAah00dKn01977TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKn
Aai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00E6oTLNAai;7TKn00977P05Bai77TLNAai;7P03Aah0
5D/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN00177T/NAai;7P04Ool00`00Oomoo`0OOol0
03Eoo`03001oogoo01Moo`1?Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M;YhbWSJn<YhR?AhL8SdN72YN9UdZGBIM
:Uh^OBin:Wd^OS:M<YhbOCJN<YdbWSJM>[hfWCJn=YdjgSJn>[hf_C[N>[hngSZm?]hj_SkN>[d00ckN
07lj_SkN?]i2gSkN@_hngT;N?]i2oSkN@_hngT;n@]i2oSkN@_i2gT;n?]i6oT;N@_i2gTKn@]i6oT;N
A_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i77TKn
Aai6oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKn
Bai6oT/O001;7TKnBam77P05Ool00`00Oomoo`0NOol003Eoo`03001oogoo01Qoo`9?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah04D/N
Cai?7TlN:Wh^WRin;YhN728m7Q`R?AhL:UdVGBYM9Ud00Rim00<^ORim;Wd00S:N00DbWC:N<Yhf_SJN
00<f_P03=Yhj_SZn00@j_P04?]hj_S[N>[h>?]h2@]h00d;n?]i2gP02@_h00d;N@_i2oP08@_h03TKn
@_i2oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP08A_h01DLNA_i6oTKnAah00dKn0197
7TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00E6oTLN
Aai;7TKn00977P0KBai77TLNAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah004LN
Bai77T/N00Eoo`03001oogoo01ioo`00=Goo00<007ooOol06Goo04A;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN:Wd^
WRYm;YhN728m7Q`R?BIM:WhVGBYM9UdbWRim;Wh^OC:N<YdfWS:M=YhbWCJn=Ydj_SJM=[hf_C[N0SZn
00Tf_C[N>[hngSZm?]hj_SkN>[h00ckN07dj_SkN?]i2gSkN@_hngT;N?]i2oSkN@_hngT;n@]i2oSkN
@_i2gT;n@]i6oT;N@_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77T;n
Aai2oTLN@_i77T;nAai6oTLN@_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i77TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam6oT/NA_i;7dKn
Bai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBah004/OAai;7TKn00Eoo`03001oogoo01ioo`00=Goo00<0
07ooOol06Goo0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P09Bai?7TlNCahVGBjN;WhR?B8l00<R?@DZG@04;Wh^OBin;Wd3<Yh01C:M
<YhbWSJn=Yh00cJn1CZn00HngSZn?]hj_SkN>[h8?]h01T;N?]hngSkN@_hngP92gP03@_hngT;n0092
oP03@]i2oT;n00Q2oP0:A_i2oT;n@_i6oT;nA_i2oTKn@_h3A_h01D;nA_i6oTKn@_h01TKn00E77TKn
A_i6oTLN00=6oP0BAai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai7
7TKn00=77P05A_i77TLNBai6oP02Aah01D/NA_i77TLNBah00dLN01E;7TLNBai77T/NAai;7TLNBai7
7T/NAai;7TLNBai77P00Aai;7TLNBah01Goo00<007ooOol07Woo000eOol00`00Oomoo`0JOol0D4ln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBadVOR9M9WhRGB8m7Q`R?B8L8SdVGBYn9UdZGBim<Yh^OC:N;WdfWS:M=YhbWCJN
=Ydj_SJM>[hfWCZn>[djgSZn>]hj_CkN>[hngSZm?]hj_SkN>[h3?]h0O3Zn@_hngT;n?]i2oSkN@_hn
gT;n?]i2oSkN@_i2gT;n?]i2oT;N@_i2gTKn@]i2oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nA_i2
oTKn@_i77T;nA_i2oTLN@_i77T;nAai6oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;7TKnAai6
oT/NA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam6
oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/O001;7TKnBam77T/N17oo00<007oo
Ool07Woo000eOol00`00Oomoo`0KOol3Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05
Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00A;7TlNCahVGP<VG@048SdR?28m8Sd5:Ud01Bim
;Wh^OBin;Wd00S:N00<fWS:M<Yh00SJn00<fWSJn=[h01SZn00@ngS[N?]hj_PXngP06@]hngSkN@]i2
oSkN0T;N00=2oT;N@_h00T;n00=2gT;n@_h024;n00Y6oT;n@_i2oTKn@_i6oT;nA_i2oP=6oP03@_i6
oTKn00Q6oP05Aai6oTKnA_i77P03A_h04TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6
oP=77P05A_i77TLNAai6oP03Aah01DKnAai77T/NA_h00TLN00E;7TLNAai77T/N00=77P0DBai77T/N
Aai;7TLNBai77T/NAai;7TLNBai77P00Aai;7TLNBai77PEoo`03001oogoo01eoo`00=7oo00<007oo
Ool07Woo04];7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7Ahm8UdVOR8l8SdR728m8Q`ZOBIM:WhZGBYm;WdbWRim<YhbWCJn
<YdfWS:M=[hfWCZn=Ydj_SJM>]hj_C[N>[hjgSZm?]hj_SkN>[d023kN07U2oSkN@_hngT;n?]i2oSkN
@_hngT;n?]i2oT;N@_hngT;n@]i2oT;NA_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;n
A_i2oTLN@_i77T;nAai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i77TKnAai6oT/NA_i77TKn
Bai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7dKn
Bai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKn00177T/NA_i;7`05Ool00`00Oomoo`0M
Ool003Aoo`03001oogoo01ioo`04001?7TlNBah3Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01T/NCai?7TlNBai?7P8N?@036SdN?B8m00<R?@DZG@06<Yh^OBin
;WdbWS:M0S:N00<fWS:M=[h01CJn1SZn00@ngS[N?]hj_PHngP0>@]hngSkN?]i2gSkN@_i2gT;n@]i2
oT;N@_i2gP=2oP03@]i2oT;n00Q2oP08A_i2oT;n@_i6oT;nA_i2oQ16oP05Aai6oTKnA_i77P03A_h0
4TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP03Aah01DKn
Aai77T/NA_h00TLN01];7TLNAai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBah004/N
Aai;7TLNBah017oo00<007ooOol07Goo000dOol00`00Oomoo`0OOol0@4lnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln6SdN
?AXL7SdR?28m8Q`V?BYM:WhZGBin:UdbWRim<Yh^OC:N<Ydf_S:M=YhbWCZn=Ydj_SJM0SZn00XjgSZm
>]hj_S[N>[dngSZn?]hj_@HngP1j@_hngT;n?]i2oSkN@_hngT;n?]i2oSkN@_i2gT;n@]i2oT;NA_i2
gT;n@]i6oT;NA_i2gTKn@_i6oT;NAai2oTKn@_i77T;nA_i2oTLN@_i6oT;nAai6oTLN@_i77TKnAai2
oTLNA_i77T;nAai6oTLNA_i77TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam77P00A_i;7dLNBai6oPAoo`03001oogoo01eoo`006Woo0`005goo00<007ooOol0
87oo0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN
Cai?7T/N00=?7P09Bai?7QXL7SdJ?BHm8SdV?B8m008ZG@0=:WdZGBYM:UdbWRim;Wh^OCJN<YdfWS:N
=Yh00cJn00<j_SJn=[h01CZn00<ngSZn?]h00SkN00<j_SkN?]h013kN00Y2gSkN?]hngT;N?]i2oT;N
@_i2gP=2oP03@]i2oT;n00Q2oP0<A_i2oT;n@_i6oT;nA_i2oTKn@_i6oT;n44Kn00E77TKnA_i6oTLN
00=6oP0>Aai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP02Aah01D/NA_i7
7TLNBah00dLN00E;7TLNAai77T/N00=77P0EBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/N001;
7TLNBai77T/N00Eoo`03001oogoo01aoo`006goo00<007ooOol05Woo00<007ooOol08Goo04Y??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBadN7AXL6QdIo2IM8S`V?B8l;WhZGBYn:Ud^ORim<Yh^OC:N;WdfWS:M=[hbWCJN=Ydj_SJM
>[hfWCkN>[hjgSZm?]hj_SkN>[dngSZn23kN07Q2oSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oT;N@_i2
gT;n@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@_i77T;nA_i2oTLN@_i6oT;nAai2oTKn@_i77TKnAai2
oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam6oT/NA_h004LNBai6oT/OAah5Ool00`00Oomoo`0LOol001Moo`<00003Ool007oo
01Moo`03001oogoo025oo`05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00QXL00lJ7AXL9SdR?BHm8SdZOBYM;WdZGBYm
<WdbWRim<Yh00SJN00@bWSJN=Yhj_P<f_P03>[hf_SZn00@j_P8ngP03>]hngSkN00PngP04@]hngSkN
?]h2@]h014;n@]i2oT;N0d;n00=2gT;n@_h024;n00I6oT;n@_i2oTKn@_h3A_h00d;nA_i6oP0<A_h0
1DLNA_i6oTKnAah00dKn01977TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKn
Aai77T/NA_h00TLN00E;7TKnAai77T/N00=77P05Bai77TLNAai;7P03Aah04d/NAai;7TLNBai77T/N
Aai;7TLNBai77T/N001;7TLNBai77T/N00Eoo`03001oogoo01aoo`005Woo00@007ooOomoo`8001Qo
o`03001oogoo029oo`1;Bae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae;7TKmBai:oT/N6O`N7AXL6QdR?2IM8SdV?BYM;WhZGBin:UdbWRim<Yh^
OC:N<Ydf_S:M=[hbWCZn=Ydj_SJm>[hj_CkN>[hjgSZm?]hj_SkN>[dngSZn008ngP1l@]hngSkN?]i2
oSkN@_hngT;n?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]i6oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6
oT;nAai2oTKn@_i77T;nA_i2oTLN@_i6oT;nAai6oTLN@_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i7
7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_h004KnBam77T/NA_h5
Ool00`00Oomoo`0LOol001Ioo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo02=oo`05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P06Bai?7TlNCai;7TlN0T/N
00Q:oT/NBai;7QWl7Q`J71XM12Hm00TZGBYm:Ud^OBYM<YhbOC:N<Wd00cJN00LbWSJN=[hj_SJn>[hf
_P04>[h00c[N>[hngP02?]h00c[N?]hngP06?]h034;N?]i2gSkN@]hngT;n@]i2oT;N@_i2gP=2oP03
@]i2oT;n00I2oP08A_i2oTKn@_i6oT;nA_i2oP=6oP03@_i6oTKn00a6oP05Aai6oTKnA_i77P03A_h0
4TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNBai6oP02Aah01D/N
Aai77TLNBah00dLN01Y;7TLNAai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7P00Bai77T/N
Aai;7TLN1Goo00<007ooOol06goo000FOol00`00Oomoo`02Ool00`00Oomoo`0FOol00`00Oomoo`0T
Ool0BD/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T[nBai6oD/NB_hN71Wl7QdIo2IM8S`VGB8m9UdZGBin:Ud^ORim<Yh^OC:N;Wdf_S:M=[hbWCJn
=[dj_SJM>[hf_C[N>[dngSZn>]hj_CkN>[hngSZm00@ngP0D@]hngSkN?]i2oSkN@_hngT;n?]i2oSkN
@_hngT;n@]i2oT;N@_i2gP92oP1UA_i2gTKn@_i6oT;nA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAai2
oTLN@_i77T;nAai2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i;7TKnAai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam6
oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_h004LNBai6oT/OAai;7P05Ool00`00Oomoo`0KOol0
01Ioo`04001oogooOol2000HOol00`00Oomoo`0UOol01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N
00=?7P05Bai?7TlNCai;7P03Cah01T/NCai?7TlNBai?7PE2oP057Q`Io1hL7Q`VG@039Sd02Bim:Ud^
OBYm;WdbOC:N<WdbWP03=Yh00cJn=YhfWP02>[h013Jn>[hj_S[N0cZn00<jgSkN?]h02ckN00A2gSkN
@]hngP92gP06@_i2gT;n@]i2oT;N0d;n00=2gT;n@_h014;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6
oP0@A_h05TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLN
Aai77TKn00977P05Bai6oTLNAai;7P03Aah01D/NAai77TLNBah00dLN01A;7TLNBai77T/NAai;7TLN
Bai77T/NAai;7P00Bai77T/NAai;7TLN1Goo00<007ooOol06goo000GOol300000goo0000000GOol0
0`00Oomoo`0UOol0BTlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??T/MCai;7Dln@_i6oT;NA_hN71hM7O`N7BHm9UdV?2IM9Sd^ORYM;WhZGC:N;WdbWS9m<Yhb
WCJn<Ydf_S:M>[hf_SZn=Ydj_SJn?]hj_CkN>[hngSZm?]hj_SkN>[d4?]h0NT;N?]i2oSkN@_hngT;n
?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN
@_i77T;nAai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnBai6oTLN
A_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/O
A_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oP00A_i;7dLNBai6oT/OAah4Ool00`00Oomo
o`0KOol003=oo`03001oogoo02Moo`03Cai;7TlN009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlNCai?7T/N00=?7P04BahjgS[N?]h2>]h47Q`012Hm9UdV?BIM1Bim00DbWS9m<Yhb
WC:N00<fWP03=[hfWSZn008j_P04=[hj_SZn>]h3>[h00c[N?]hngP09?]h03T;N?]i2gSkN@]hngT;n
@]i2oT;N@_i2gT;n@]h:@_h01TKn@_i6oT;nA_i2oP=6oP03@_i6oTKn00a6oP05Aai6oTKnA_i77P03
A_h04TLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNBai6oP02Aah0
1D/NA_i77TLNBah00dLN00E;7TLNAai77T/N00=77P0CBai77T/NAai;7TLNBai77T/NAai;7P00Bai7
7T/NAai;7TLNBah017oo00<007ooOol06goo000cOol00`00Oomoo`0XOol0?TlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7CkO>]hngSZn?]lN71hM
7O`R7BHm9UdV?2IM:Ud^ORYM;WhZGC:N;WdbWS9m=[hbWCJn=Ydf_S:M>[hf_SZn=[d2>[h0QSkN>[dn
gSZn?]hj_CkN>[hngSZm@_hngT;N?]i2oSkN@_hngT;n?]i2oSkN@_i2gT;n?]i2oT;N@_i2gTKn@]i2
oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i7
7TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;
7dKnBai6oP00Aai;7TKnBam77T/NA_h5Ool00`00Oomoo`0JOol003=oo`03001oogoo02Uoo`03Cai;
7TlN009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P<jgP06
?]hjgR8L7Q`R7AhL0RIM00<ZGBIM;Wd012im00HbWC:N<YdbWS:M=[h3=Yh00cJn>[hj_P05>[h013kN
>[hj_SZn33kN00Y2oSkN@]hngT;n@]i2oT;N@_i2gPa2oP08A_i2oTKn@_i6oT;nA_i2oP=6oP03@_i6
oTKn00a6oP0BAai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn
00=77P05A_i77TLNBai6oP02Aah01D/NAai77TLNBah00dLN01U;7TLNBai77T/NAai;7TLNBai77T/N
Aai;7TLNBai77T/N001;7TLNBai77T/NAai;7P05Ool00`00Oomoo`0JOol003=oo`03001oogoo02Yo
o`12Cai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7S:N=[hbWSJn<YhR?AhL8SdN72YM9SdZGBHm;Wh^OBin;Ud^OS9m<YhbOC:N<Wdf_SJM=[hfWCJn=[dj
_SJn>[hf_CkN>[hngSZm0ckN00<j_CkN?]h00SkN07Y2oSkN@]hngT;n?]i2oSkN@_hngT;n?]i2oT;N
@_hngTKn@]i2oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN@_i77T;n
Aai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKn
Bam6oT/NA_i;7dKnBai6oT/OA_i;7P00Bam77T/NA_i;7dLN1Goo00<007ooOol06Woo000cOol00`00
Oomoo`0ZOol2Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah0
14/NCai?7TlN0c:n00Tf_S:n8SdN728M7Q`ZGBIM:Ud00bim00`^ORim;WdbWC:N<YdbWSJN=[hfWSJn
=Yh8>[h00ckN>[hj_P0;?]h2@]h02T;n?]i2gT;N@_i2gT;n@]i2oT;N1T;n00Y6oT;n@_i2oTKn@_i6
oT;nA_i2oP=6oP03@_i6oTKn00Q6oP05Aai6oTKnA_i77P03A_h04TLNA_i6oTKnAai6oTLNA_i77TKn
Aai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP03Aah01DKnAai77T/NA_h00TLN01m;7TLNAai7
7T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah004LNBai77T/NAai;7P05Ool0
0`00Oomoo`0JOol003=oo`03001oogoo02]oo`0kBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN:Wdf_S:N=[hN728m8Q`R?BHm:UdVGBYM;Ud^ORim
;Wh^GCJN<YdfWS9m=YhfWCJn=Ydf_SJM>[hf_@03>[h01CZm?]hj_SkN>[d00ckN07hj_CkN?]i2gSkN
@_hngT;N?]i2oSkN@_hngT;n@]i2oSkN@_i2gT;n@]i6oT;N@_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;n
A_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLNA_i77T;nAai6oTLN@_i77TKnAai6oTLNA_i77TKn
Bai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam77T/NA_i;7`00Bai6oT/OAai;7TKn
Bal5Ool00`00Oomoo`0IOol003=oo`03001oogoo02aoo`9?7P05Bai?7TlNCai;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P04Bai?7TlN:Yh3:Wh01BZN8Q`R?B8L8Sd012YM0bim00L^
ORim<YhbWC:N<YdbWP02=[h00cJN=[hj_P04>[h01SkN>[hjgSZn?]hj_P`ngP92gP08@_hngT;N@]i2
oT;N@_i2gPQ2oP0:A_i2oT;n@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP08A_h01DLNA_i6oTKnAah0
0dKn00i77TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P05A_i77TLN
Bai6oP02Aah01D/NA_i77TLNBah00dLN01Y;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/N
Aah004LNBai77T/NAai;7TLN1Goo00<007ooOol06Goo000cOol00`00Oomoo`0]Ool0:4/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBad^WRYm;YhZOBHm
8Q`R?B8L:UdVGBYm0RYM00d^OC:N;WdbOS:M=YhbWCJN<Ydj_SJM=[hfW@03>[h02CJm>]hj_SkN>[dn
gSZn?]hj_@03?]h0OCZm?]hngT;N?]i2oSkN@]hngT;n?]i2oSkN@_i2gT;n?]i2oT;N@_i2gTKn@]i2
oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i7
7TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam6oT/NA_i;
7dLNBah004/OAai;7TKnBam77T/NA_h017oo00<007ooOol06Goo000cOol00`00Oomoo`0^Ool2Cah0
1D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah014/NCai?7R9M0bYn
00@R?B8l8SdR?@DZG@<^O@06;WhbWC:N<YhfWS:M0cJn00<fWSZn>[h013Zn00@ngSZn?]hj_P`ngP06
@_hngT;N@]i2oSkN0d;n00=2gT;n@_h024;n00Y6oT;n@_i2oTKn@_i6oT;nA_i2oP=6oP03@_i6oTKn
00Q6oP05Aai6oTKnA_i77P03A_h03TLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai7
7TLNA_h00dLN00E6oTLNAai;7TKn00977P05Bai77TLNAai;7P03Aah04T/NAai;7TLNBai77T/NAai;
7TLNBai77T/NAai;7TLN00177P=;7P04Aai;7T/NBah4Ool00`00Oomoo`0IOol003=oo`03001oogoo
02ioo`0iCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/M8UhN?B9N8Q`V?B8L9SdR72im9UdZOBYM<Yh^OC:N;WdfWS:M=YhbWCJN=Ydj_SJM>[hfWC[N
008j_P09=[djgSZn?]hj_CkN>[hngSjm00<ngP1k?[e2oSkN@]hngT;n?]i2oSkN@_hngT;n?]i2oT;N
@_hngT;n@]i2oT;NA_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN@_i77T;n
Aai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bam6oT/NA_i;7dLNBai6oT/O001;7TKnBam77T/NA_i;7dLN00Eoo`03001oogoo01Qoo`00<Woo00<0
07ooOol0<7oo0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00=;7TlNCah00b9M00@V?B8m8S`R?@DZG@08<Wh^OBim;WdfWS:M=YhbWP8fWP<f_P03=Yhj_SZn00<j
_P8ngP03>[hngSkN00PngP06@]hngSkN@]i2oSkN0T;N00=2oT;N@_h00T;n00=2gT;n@_h014;n00a6
oT;n@_i2oTKn@_i6oT;nA_i2oTKn@_h<A_h01DLNA_i6oTKnAah00dKn01977TKnA_i6oTLNA_i77TKn
Aai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00E6oTLNAai;7TKn00977P0BBai7
7TLNAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN1@0000=77T/NAah00d/N00=77T/NOol017oo
00<007ooOol067oo000bOol00`00Oomoo`0aOol07TlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCchJ708N?@0I9SdR?2Hm8S`V?BYM;WdZGBin;WdbWRim
<YhbWCJN<YdfWS:M=YhfWCZn=Ydj_SJM>]h00SZn00Tj_C[N>[hngSZm?]hj_SkN?[d013kN0652oSkN
@]hngT;n?]i2oSkN@_hngT;n@]i2oT;N@_i2gTKn@]i2oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;n
A_i2oTKn@_i77T;nA_i2oTLNA_i77T;nAai6oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;7TKn
Aai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7P0:00003DKnBam77T/N001;7dLNBai6oT/OAai;7TKn00Eoo`03001oogoo01Qoo`00
<Woo00<007ooOol0<Woo0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00E;7TlN6QdN7AXL00<V?@038S`^GBYM00<ZG@0:<WdbWRim<WdbWSJN<YdfWS:N>[h3=[h6
>[h3?]h00cZn?]hngP08?]h01D;N?]i2gT;N@_h00d;N00=2oT;N@_h00T;n00=2gT;n@_h014;n00Y6
oT;n@_i2oTKn@_i6oT;nA_i2oPi6oP05Aai6oTKnA_i77P03A_h03TLNA_i6oTKnAai6oTLNA_i77TKn
Aai6oTLNA_h3Aah01DKnAai77TLNA_h00TLN00I;7TKnAai77T/NA_h2Aah00d/N00000007000044/N
Aai;7TLNBai77T/NAai;7TLNBai77T/NAai;7P000d/N00A77T/NBai;7PEoo`03001oogoo01Qoo`00
<Woo00<007ooOol0<goo041??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNB_e;7T[nBai:oB8M6Q`N?AXL9UdR?2Hm8S`^ORYM;WdZGC:N;WdbWRim<YhbWCJN<Ydf_S:M>[hf
WCZn=Ydj_SZm?]hj_S[N>[dngSZn?]hj_@<ngP03?[dngSkN008ngP1<@_hngT;n?]i2oSkN@_hngT;n
?]i2oT;N@_i2gT;n@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;nAai2oTKn
@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnBai6oT/N
A_i;7TKnBai6oT/NA_h:00008D/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7dKnBai6oT/OA_i;
7TKnBam77P00A_i;7dLNBai6oT/OAai;7P04Ool00`00Oomoo`0HOol0039oo`03001oogoo03=oo`05
Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N009?7PI;7P8N70037QdV?BHm
008V?@09:Ud^GBYM;WdZGC:N<WdbWRim00<fWP07=YdfWSJn>[hf_SZn=[h01SZn0ckN00<j_SkN?]h0
13kN00A2gSkN@]hngPA2gP03@_i2gT;N0092oP03@]i2oT;n00Q2oP06A_i2oT;n@_i6oT;n0dKn00=2
oTKnA_h034Kn00E77TKnA_i6oTLN00=6oP0<Aai6oTLNA_i77TKnAai6oTLNA_i77TKn2@0000E6oTLN
Aai;7TKn00977P05Bai6oTLNAai;7P03Aah05T/NAai77TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77T/N001;7TLN0d/N00=77T/NBah01Goo00<007ooOol05goo000bOol00`00Oomoo`0dOol09d/M
Cci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae;7T[mBai:oT/N7O`R7Agl
8Q`V?2IM9S`VGBYM;WhZG@02;Wd06C:N<WdbWRim=[hbWCJN<Ydf_SJM>[hfWCZn=YdngSZm?]hj_SkN
>[dngSZn?]hj_D;N008ngP0l?]e2gSkN@_hngT;n?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]i6oT;N
A_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;nAai2oTKn@_i77T;nA_i2oTLN@_i77T;nAai6oTLNA_i77TKn
Aai6oTLNA_i77TKnAai6oTLN2P0003E6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam6oT/NA_i;7dLNBai6oP00Aai;7TKnBam7
7T/NA_i;7dLN00Aoo`03001oogoo01Moo`00<Woo00<007ooOol0=Goo00E;7TlNCai?7T/N00=?7P05
Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00TlN1D;n00@R71hL7Q`N70<V?@03;Wd^GBim008^O@05
<WdbWS9m<YhbO@03=Yh01CJM>[hf_SZn=[h01cZn00Dn_SkN?]hngSjn00HngP04@]hngT;N?]h2@]h0
14;n@]i2oT;N0d;n00=2gT;n@_h01T;n00Q6oT;nA_i2oTKn@_i6oT;n4DKn2@0000i77TKnAai6oTLN
A_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai;7TKn00977P06Bai6oTLNAai;7TKn0TLN01Y;7TLN
Aai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P00Aai;7TLN0d/N00=77T/NOol0
0goo00<007ooOol05goo000bOol00`00Oomoo`0fOol0=D/MCci;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlnBae2oT;N@_m2gR8M7Q`R?Agl:UdV?2YM9Sd^ORYM;WhZGBin<WdbWS9m
<YhbWCJn=Ydf_S:M>[hf_CZn=Yd00SZn00/ngSZm?]hj_SkN>[dngSZn?]hngD;N008ngP0W?]e2gSkN
@_hngT;n?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]i6oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;n
Aai2oTKn@_i77T;n00X00018Aai6oTLNA_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnBai6oT/N
A_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/N
A_i;7TKnBai6oT/OA_i;7TKnBam77T/N001;7dLNBai6oT/OAai;7TKn17oo00<007ooOol05goo000b
Ool00`00Oomoo`0gOol01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P02
Cah013[N>[hjgSZn128L00HZGBHm9UdV?Bim;Ud2;Wd01S:N<WdbWS:M<YhfW@8fWP03=[hfWCZn008j
_P04=[hj_SZn>]h3>[h:?]h034;N?]i2gSkN@]hngT;n@]i2oT;N@_i2gP=2oP03@]i2oT;n00A2oP06
A_i2oTKn@_i6oT;n2@002DKn00E77TKnA_i6oTLN00=6oP0BAai6oTKnA_i77TKnAai6oTLNA_i77TKn
Aai6oTLNA_i77TKn0dLN00E6oTLNAai;7TKn00977P05Bai77TLNAai;7P03Aah05T/NAai77TLNBai7
7T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah004LN0d/N00A77T/NBai;7PEoo`03001oogoo01Io
o`00<Woo00<007ooOol0>7oo05I;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??SJn>]hf_S[O=[hV?AhL8SdR72YM9S`ZGBiM;Wh^GBin;UdbWS9m<YhbOCJn=Ydf_SJM=[hf_CZn
=[dj_SJm?]hj_SkN>[dngSZn?]hj_CkN>[i2gSkM@]hngT;N?]e2oSkN@_hngT;n?]i2oSkN@_hngT;n
@]i2oT;N@_i2gT;n2P0005]2oTLN@_i6oT;nAai2oTLN@_i77T;nAai2oTLNA_i77T;nAai6oTLNA_i7
7TKnAai6oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam6oT/NA_i;
7`00Bai6oT/OAai;7TKnBam77P05Ool00`00Oomoo`0FOol0035oo`03001oogoo03Uoo`03001;7TlN
009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00Y;7TlN;YhjgSZn>]hR72Hm8Q`R?0@Z
G@D^O@06<YhbWC:N<Ydf_SJM0SJN00<f_SZn>[h01CZn00<ngSZn>[h02ckN0d;N00@ngT;N@]i2oPT0
0092oP0:A_i2oT;n@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0<A_h05TLNA_i6oTKnAai6oTLNA_i7
7TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00977P05Bai6oTLNAai;7P03
Aah06T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBah004/NAah3Bah0
0dLNBaioo`04Ool00`00Oomoo`0FOol0035oo`03001oogoo03Yoo`0GCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCci;7DlNBadbWP02;Yh01Rim<YhR72Hm8Q`V?@8ZG@0M9S`ZGBim<Wh^
OC9n<WdfWS9m=YhfWCJn=Ydj_SJM>[hf_CZn=[dj_SZm?]hj_SkN>[dngSjn?]hj_@02?]h00d;N?]d0
00090000Kd;n?]i2oT;N@_i2gTKn@]i2oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i7
7T;nAai2oTLN@_i77T;nAai6oTLN@_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBam6oT/NA_i;7dLNBai6oP00Aai;7TKnBam77T/NA_i;7`04Ool00`00Oomo
o`0FOol0035oo`03001oogoo03]oo`03Cai;7TlN009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlN
Bah00dlN00=;7RjN;Yh00RjN00@V?BHl9SdR70@ZG@D^O@09<YdbWS:M<YhfWSJn=Ydf_SJN00Pj_PT0
00<ngP0:@_hngT;N@]i2oSkN@_i2gT;n@]h3@_h00d;N@_i2oP04@_h02TKn@_i2oT;nA_i2oTKn@_i6
oT;n0dKn00=2oTKnA_h034Kn00i77TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai7
7TKn00=77P05A_i77TLNBai6oP02Aah01D/NAai77TLNBah00dLN01Y;7TLNBai77T/NAai;7TLNBai7
7T/NAai;7TLNBai77T/NAai;7TLNBah004/NAai;7TLN0d/N00=77WooOol00goo00<007ooOol05Goo
000aOol00`00Oomoo`0lOol05dlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/M9Uh00RjN00H^OBHm9S`V?B8L;Ud3:Ud033:N;WdbORim=YhbWCJN<Wdj_SJM=[hfW@T00007>[hn
gSZm?]hn_SkN>[d00SkN07U2gSkM@_hngT;n?]i2oSkN@_hngT;n@]i2oSkN@_i2gT;n@]i6oT;NA_i2
gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6
oTLNA_i77TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam7
7P00A_i;7dLNBai6oT/OAai;7P05Ool00`00Oomoo`0EOol0035oo`03001oogoo03aoo`9?7P05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00<RG@069S`V?BHl9SdZGBiM0RYM
00<^OC9m00002@0000<fWCJn>[h013Zn00@ngSZn?]hj_PPngP06@]hngSkN@]i2oSkN0T;N00I2oT;N
@_i2gT;n@]h6@_h02TKn@_i2oT;nA_i2oTKn@_i6oT;n0dKn00=2oTKnA_h044Kn00i77TKnA_i6oTLN
A_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P05A_i77TLNBai6oP02Aah06T/NAai7
7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah2Bah00`00Aai;7P02
Bah00dLNBai;7P06000GOol0035oo`03001oogoo03eoo`0JBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCahR72Hm8UdRGPT0000H<Yh^OC9n;WdfWS:M=YhbWCZn=Ydj_SJM>[hj
_CZn>[djgSZm?]hj_CkN>[hngSZm0ckN07Xj_D;n?]i2gSkM@_hngT;n?]i2oSkN@_hngT;n@]i2oSkN
A_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i6oT;nA_i2oTLN@_i77T;nAai2oTLN@_i77TKn
Aai2oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7dKn
Bai6oT/OA_i;7TKnBal004/NA_i;7dLNBai6oT/O1Goo00<007ooOol05Goo000aOol00`00Oomoo`0n
Ool2Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00X000098SdV?2Hm9Sd^GBYM;UdZGBiM00<b
O@0:<YhbWCJN=YdfWS:M>[hf_SZn=Yh5>[h01Cjn?]hj_SkN?[h023kN00I2gSkN?]i2gT;n?]h2@]h0
1T;n@]i2oT;N@_i2gPI2oP0:A_i2oT;n@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0<A_h04TLNA_i6
oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP03Aah01DKnAai77T/N
A_h00TLN01I;7TLNAai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aah0
04/NBai77P03Bah00dLNBaioo`03Ool00`00Oomoo`0EOol0035oo`03001oogoo03moo`05Bae?7T/M
Cci;7@090000;D/MCci;7DlNBae??T/M8SdR72Hm8Q`ZGBHl:UdV?2im:Ud^OBYM<Yh^OC:N<WdbWS:M
=YhbWCJN=Ydj_SJM>[hfWCkN>[dj_SZm?]hj_SkN>[dngSZn?]hn_@03?]h0NCkM@_hngT;N?]e2oSkN
@_hngT;n@]i2oSkN@_i2gT;n@]i6oT;N@_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;n
Aai2oTLN@_i77T;nAai2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/OAai;7TKnBam77T/NA_h004LNBai6oT/OAai;7TKn00Aoo`03001oogoo
01Eoo`00<Goo00<007ooOol0>Woo2P000TlN00E;7TlNCai?7T/N00=?7P03Bai?7TKn00A6oP0=9S`R
728m8Q`ZGBXm:UdZ?Bim;Ud^OBiM<Yh00c9m00@fWSJM=YhfW@8fWP03>[hf_SZn00Hj_P03?[hngSZn
00XngP05@]hngT;N@]i2oP02@]h2@_h00d;N@_i2oP08@_h00dKn@_i2oP02A_h00d;nA_i6oP0<A_h0
1DLNA_i6oTKnAah00dKn01977TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKn
Aai77T/NA_h00TLN00I;7TKnAai77T/NA_h2Aah05T/NAai77TLNBai77T/NAai;7TLNBai77T/NAai;
7TLNBai77T/NAai;7TLN0d/N00D004/NBai;7TLN00=;7P05AaioogooOol0000GOol0035oo`03001o
ogoo035oo`T000Ioo`0h001;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??TKnAai6oTLN9Q`V
?BHL9SdZ?2YM9S`ZGBXl<WdZGBin;UdbWS9m=YhbOCJN<Ydf_SJM=YhfWCZn=Ydj_SZm?]hj_CZn>[dn
gSZn?]hj_@<ngP1l?[e2gSkN@]hngD;n?]i2gSkN@_hngT;n?]i2oT;N@_i2gT;n@]i6oT;NA_i2gTKn
@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLNA_i77T;nAai6oTLN@_i77TKnAai2oTLN
A_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/N
A_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7TLNBai6oT/O
Aah004KnBam77T/NA_i;7dLNBah3Ool00`00Oomoo`0EOol0031oo`03001oogoo02Qoo`X0011oo`04
001?7TlNBah3Cah01D/NCai?7TlNBah00dlN00=;7TlN>]h00c[N00@V72Hl9Q`V?08ZG@03:SdZGBim
00<^O@0;<WdbWS9m<YdfWCJN=YdfWSJM>[hf_P08>[h3?]h00cjn?]hngP04?]h014;N?]i2gSkN14;N
00=2oT;N@]h00T;n00=2gT;n@_h024;n00=6oT;nA_h00TKn00=2oTKnA_h034Kn00E77TKnA_i6oTLN
00=6oP0>Aai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP02Aah01T/NA_i7
7TLNBai6oP977P0NBai77TLNAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77T/N001;7TLN0d/N00=77T/NBah00goo00<007ooOol05Goo000`Ool00`00Oomoo`0OOol9000K
Ool074lnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCchj_S[N>[hngbHl9SdV72iM:U`^GBXl
0RiM09LbOBiM<WhbOC:N<WdfWSJM=[hfWCJn=Ydj_SJM>[hf_CkN>[dngSZm?]hj_CkN>[hngSZm@]hn
gT;N?]e2gSkN@]hngD;n?]i2gSkN@_hngT;n?]i2oT;N@_i2gT;n@]i6oT;NA_i2gTKn@]i6oT;nA_i2
gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6
oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7TLNBai6oT/O001;7TKnBam7
7T/NA_i;7`04Ool00`00Oomoo`0DOol0031oo`03001oogoo01Eoo`X002Eoo`=?7P05Bai?7TlNCai;
7P03Cah01T/NCai?7TlNBai?7P@^WP03:S`Z?BHl008ZG@04;UdZGC9m<Wd2;Wd2<Yd01cJN<WdfWSJM
=YhfWCJN00Dj_P04?[hj_SZn>[h2?[h3?]h00cjn?]hngP04?]h01D;N?]i2gSkN@_h00d;N00=2oT;N
@_h00T;n00=2gT;n@_h014;n00I6oT;n@_i2oTKn@_h3A_h00d;nA_i6oP0<A_h01DLNA_i6oTKnAah0
0dKn00i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai;7TKn00977P06Bai6oTLN
Aai;7TKn0TLN01I;7TLNAai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05
Aah004/NBai77P03Bah00dLNOomoo`02Ool00`00Oomoo`0DOol0031oo`03001oogoo00aoo`T002mo
o`2eBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7BjN:Wh^WRYm;UdV?2Xm9S`^OBYL;UdZ
?39n;WdbOBiM=YhbOCJN<Wdj_SJM>[hfWCZn=[dj_SJM>[hj_CkN>[dngSZm?]hj_CkN?[hngSkM@]hn
gT;N?]e2gSkN@_hngD;n?]i2oSkN@_hngT;n@]i2oT;N@_i2gT;n@]i6oT;NA_i2gTKn@]i6oT;nA_i2
gTLN@_i6oT;nAai2oTKn@_i77T;nA_i2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oTLNA_i77TKnBai6
oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7dLNBah004/OAai;7TKnBam7
7T/NA_h00goo00<007ooOol057oo000`Ool00`00Oomoo`02Ool:000iOol01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P03BahZGBjN008^WP03:SdZ?2Xm00@^G@05;WdbOC9m<Wd^O@02=Yd01cJN
<YdfWSJN=[hfWCJN00Dj_P04?[hj_SZn>[h;?]h2@]h013kN@]i2gT;n0d;N00=2oT;N@_h00T;n00=2
gT;n@_h014;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0<A_h01DLNA_i6oTKnAah00dKn00i77TKn
Aai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai;7TKn00977P0NBai6oTLNAai;7TLNBai7
7T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0T/N00<004LNBah00T/N
00A77T/NBai;7P=oo`03001oogoo01Aoo`00<7oo1@00A7oo01Y;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7RXl;UdZ?2iM:S`^GBXl;UdZG2im0RiM09LbOC:N<WdbOS9m=YhbOCJN=Ydj_SJM>[hf
WCZn>[dj_SJM>[hj_CkN>[dngSZm?]hj_CkN?[hngSkM@]hngT;N?]e2oSkN@_hngD;n@]i2oSkN@_i2
gT;n@]i6oT;N@_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2oTLN@_i6oT;nAai2oTKn@_i77TKnAai2
oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NAai;7TKnBai77T/NA_i;7dLN0016oT/OAai;7TKnBam77P03Ool00`00Oomoo`0DOol0035oo`03
001oogoo04Ioo`05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00LZ?BYM:Ud^GBiL:SdZ?002
;Ud00bim;UdbO@04<Wd3=Yd01SJN=Ydf_SJN>[hfW@@j_P05?[hj_SkN>[hn_P09?]h00d;N?]i2gP02
@]h02CkN@_i2gT;n@]i2oT;N@_i2gP06@_h02TKn@_i6oT;nA_i2oTKn@_i6oT;n4TKn00E77TKnA_i6
oTLN00=6oP0:Aai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00TLN00I;7TKnAai77T/N
A_h2Aah07T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;
7P00Bai77P=;7P03Aai;7Woo009oo`03001oogoo01Aoo`00<Woo00<007ooOol0AWoo0;9;7DlnBae?
7T/MCci;7DlNBae??T/MA_i2oTLN@_hbGBhl;UdZ?2iM;S`^GBiL<Wd^GC9m;UdfWS9m<YhbOCJN<Ydf
WSJM>[hfWCZn=Ydj_SZm?[hj_CZn>[dngSZm?]hj_CkN?[hngSZm?]hn_T;N?]e2gSkN@]hngD;n?]i2
oSkM@_i2gT;n?]i2oT;N@_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2gTKn@_i6oT;nAai2oTKn@_i7
7T;nA_i2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7TLNBai6oP00Aai;7TKnBam77T/NA_i;7`9oo`03001oogoo
01Aoo`00<goo00<007ooOol0AWoo00E;7TlNCai?7T/N00=?7P05Bai?7TKnA_i2oP02A_h01RiL;S`^
?2hl;Ud^G08^G@05<Wd^GBim;UdfW@03<Wd01SJN=YdfWCJM>[hfW@Pj_P8n_P03?]hj_Sjn00DngP06
@]hngSkN?]i2gSkN0d;N00DngT;n@]i2oT;N00=2oP04@]i2oT;nA_h3@_h01TKn@_i6oT;nA_i2oP=6
oP03@_i6oTKn00a6oP05Aai6oTKnA_i77P03A_h03TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_h3
Aah01DKnAai77T/NA_h00TLN00E;7TLNAai77T/N00=77P0BBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77T/NAai;7TLN0d/N00E77T/NBai;7P0000=;7P05Aai;7T/NBai77P02Ool00`00Oomoo`0DOol0
03Aoo`03001oogoo04Eoo`0JCai;7DlnBae?7T/MCci;7DlNBae??SJM>[hfWCZn;S`bGBhl<Ud^G39m
;S`^GC9M<Wd^G@8bO@0J=YhbOCJN<WdfWSJM>[hfWCZn=Ydj_SJM>[hj_CkN>[dn_SZm?]hj_CkN>[dn
gSjn?]hn_@8ngP1i@]hngD;n?]i2oSkM@_hngT;n@]i2oT;N@_i2gTKn@]i2oT;NA_i2oTKn@]i6oT;n
A_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i77TKnAai6oTLNA_i77TKn
Bai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TLNBai6oT/OAai;7P00
Bam77T/NA_i;7dLNBah00Woo00<007ooOol057oo000eOol00`00Oomoo`15Ool00dlNBai?7P02Cah0
34/NCai?7TlNBai?7SJn>[hf_SZn<U`^G08^?08bG@03;UdbGC9m00<bO@8fW@09<WdfWCJM=YhfWCJN
=Ydj_SZm00Lj_P05?[hngSjn?]hn_P06?]h01D;N?]hngSkN@_h00d;N00I2oT;N@_i2gT;n@]h6@_h0
2TKn@_i2oT;nA_i2oTKn@_i6oT;n4TKn01I77TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLN
A_i77TKnAai6oP=77P05A_i77TLNBai6oP02Aah05T/NAai77TLNBai77T/NAai;7TLNBai77T/NAai;
7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN009;7P0300177T/N009;7P03Aai;7T/N009oo`03
001oogoo01Aoo`00=Woo00<007ooOol0AGoo1P001Woo00Xj_SJM=UdbG39M<U`bOBiL<Wd^G08bO@0K
=WdbOCJM<WdfWS9m=YhfWCZn=Ydj_SJM>[hfWCZn=Ydn_SZm?]hj_CkN>[dngSZm?]hn_D;N008ngP1j
?[e2oSkN@]hngD;n?]i2oSkM@_hngT;n@]i2oT;N@_i2gTKn@]i2oT;NA_i2oTKn@]i6oT;nA_i2oTKn
@_i6oT;nAai2oTKn@_i77TKnAai2oTLNA_i77T;nAai6oTLN@_i77TKnAai6oTLNA_i77TKnBai6oTLN
A_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/N
A_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7TLNBai6oT/O001;7TKnBam77T/N
A_i;7`9oo`03001oogoo01Aoo`00=goo00<007ooOol0A7oo00<007ooOol037oo0S9L00<bGC9L<Wd0
0S9m00<bGC9m<Wd00S9m0cJM00HbOCJN=YdjWSJM=Yh2>[h013Zm>[hj_Sjn0cZn00@ngSjn?]hn_PHn
gP04@]hngT;N?]h2@]h024;n@]i2gT;N@_i2gT;n@]h8@_h01TKn@_i2oT;nA_i2oQI6oP0>Aai6oTKn
A_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNBai6oP02Aah01T/NA_i77TLNBai6oP977P0F
Bai77TLNAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01TLNBai;7T/NAah0
009;7P08Aai;7T/NBai77T/NOol001Ioo`00>7oo00<007ooOol0@goo00<007ooOol04Goo09hfOC9L
=WdbG3JN<WdfOC9m=YhfOCJN=Wdj_SJM>[hfWCZn>Ydj_SZM>[hj_CkN>[dngSZm?]hj_CkN>[e2gSjm
@]hngT;N?[e2oSkN@]hngD;n@]i2oSkM@_i2gT;n@]i2oT;NA_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;n
A_i2oTKn@_i6oT;nAai2oTKn@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i77TKnAai6oT/NA_i77TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7TLNBai6oP00Aai;7TKn
Bam77T/NA_ioo`005Woo000iOol00`00Oomoo`12Ool00`00Oomoo`0COol2<Wd3=Wd6=Yd013ZN>Ydj
_SJM0cZn00Tj_Cjn>[hn_SZn?[hj_SkN?[h023kN00A2gSkN@]hngP92gP03@_i2gT;N0092oP03@]i2
oT;n00I2oP04A_i2oTKn@_h3A_h00d;nA_i6oP0<A_h01DLNA_i6oTKnAah00dKn00i77TKnAai6oTLN
A_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai;7TKn00977P06Bai6oTLNAai;7TKn0TLN01I;7TLN
Aai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBah00003Bah0
1TLNBai;7T/NOol001Ioo`00>Woo00<007ooOol0@Goo00<007ooOol05Woo00<bOCJN<Wd00SJM098j
WSJM>YhfWCZn=Ydj_SJM?[hj_CZn>YdngSZm?]hj_CkN?[dngSZm?]hn_D;N?]e2gSkN@_hngD;n?]i2
oSkM@_i2gT;n?]e2oT;N@_i2gT;n@]i6oT;NA_i2gTKn@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i7
7T;nA_i2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NAai;7TKnBai77T/NA_i;7TLNBai6oT/OAah004KnBam77T/NA_i;7dLN0Woo00<007oo
Ool04goo000kOol00`00Oomoo`10Ool00`00Oomoo`0JOol02SJN=YdfWCJM=YhjWCZn>Ydj_SZm0cZn
00Dj_Cjn?[hngSZn00HngP06@]hngSkN?]i2gSkN1T;N00=2oT;N@_h00T;n00A2gT;n@_i6oP=2oP06
A_i2oTKn@_i6oT;n0dKn00=2oTKnA_h034Kn00E77TKnA_i6oTLN00=6oP0:Aai6oTLNA_i77TKnAai6
oTLNA_h3Aah01DKnAai77TLNA_h00TLN00I;7TKnAai77T/NA_h2Aah05T/NAai77TLNBai77T/NAai;
7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN009;7P0300177T/N009;7P05
Aai;7T/NOol0000EOol003aoo`03001oogoo03moo`03001oogoo01moo`0B>[hfWCZn>Ydj_SZm?[hj
_Cjn>[dngSZm?]hj_CkN?[dngSjm0SkN07e2gSkM@]hngT;n?]e2oSkN@_hngD;n@]i2oSkMA_i2gT;n
@]i6oT;NA_i2gTKn@]i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i6oT;nAai2oTLN@_i77TKnAai6oTLN
A_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/N
A_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TLNBai6oT/N
Aai;7TKnBai77T/NA_i;7`00Bai6oT/OAai;7TKnBamoo`0001Eoo`00?Goo00<007ooOol0?Woo00<0
07ooOol097oo00@n_SZm>[hj_P@n_PPngP03@]hngSkN00E2gP06@_i2gT;n@]i2oT;N0d;n00A2gT;n
@_i6oP=2oP06A_i2oTKn@_i6oT;n0dKn00=2oTKnA_h024Kn00E77TKnA_i6oTLN00=6oP0>Aai6oTKn
A_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNBai6oP02Aah01T/NA_i77TLNBai6oP977P0F
Bai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01TLNBai;7T/NAah0
009;7P07Aai;7T/NBai77Woo00005Goo000nOol00`00Oomoo`0mOol00`00Oomoo`0ZOol0QSZm?]hj
_CkN?[e2gSjm?]hn_D;N?]i2gSkM@]hngT;n?]e2oSkN@_i2gD;n@]i2oT;NA_i2gT;n@]i6oT;NA_i2
gTKn@_i6oT;NA_i2oTKn@_i77T;nA_i2oTLN@_i6oT;nAai6oTLN@_i77TKnAai6oTLNA_i77TKnBai6
oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7TLNBai6oT/NAai;7TKnBam7
7T/N001;7dLNBai6oT/OAai;7Woo000EOol003moo`03001oogoo03aoo`03001oogoo02moo`DngP04
@]hngT;N?]h6@]h01T;n@]i2oT;N@_i2gPI2oP0:A_i2oTKn@_i6oT;nA_i2oTKn@_h>A_h01DLNA_i6
oTKnAah00dKn00i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai;7TKn00977P0N
Bai6oTLNAai;7TKnBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
0d/N00I77T/NBai;7P00Bah6Ool00`00Oomoo`0COol0041oo`03001oogoo03]oo`03001oogoo03Uo
o`0Q@_hngT;n?]e2oT;N@_i2gD;n@]i6oT;NA_i2gTKn@]i6oT;NA_i2gTKn@_i6oT;nA_i2oTKn@_i7
7T;nA_i2oTLN0096oP0l@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/N3goo00<007ooOol01Goo00<007ooOol04goo0011Ool00`00Oomoo`0jOol0
0`00Oomoo`13Ool2@_h014;N@_i2oTKn0d;n00=6oT;nA_h00TKn00=2oTKnA_h044Kn00E77TKnA_i6
oTLN00=6oP0>Aai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77RYoo`03001oogoo00Eoo`03001o
ogoo01=oo`00@Woo0P00>Goo00<007ooOol0Z7oo00<007ooOol01Goo00<007ooOol04goo0014Ool0
0`00Oomoo`0fOol00`00Oomoo`2YOol00`00Oomoo`04Ool00`00Oomoo`0COol004Eoo`03001oogoo
03Eoo`03001oogoo0:Uoo`03001oogoo00Aoo`03001oogoo01=oo`00AWoo00<007ooOol0=7oo00<0
07ooOol0ZGoo00<007ooOol017oo00<007ooOol04goo0017Ool00`00Oomoo`0cOol00`00Oomoo`2Y
Ool00`00Oomoo`04Ool00`00Oomoo`0COol004Qoo`03001oogoo039oo`03001oogoo0:Yoo`03001o
ogoo00=oo`03001oogoo01=oo`00BGoo00<007ooOol0<Goo00<007ooOol0ZWoo00<007ooOol017oo
00<007ooOol04Woo001:Ool00`00Oomoo`0`Ool00`00Oomoo`2ZOol00`00Oomoo`04Ool00`00Oomo
o`0BOol004]oo`03001oogoo02moo`03001oogoo0:]oo`03001oogoo00=oo`03001oogoo019oo`00
C7oo00<007ooOol0;Woo00<007ooOol0Zgoo00<007ooOol00goo00<007ooOol04Woo001=Ool00`00
Oomoo`0]Ool00`00Oomoo`2[Ool00`00Oomoo`03Ool00`00Oomoo`0BOol004ioo`03001oogoo02ao
o`03001oogoo0:]oo`03001oogoo00=oo`03001oogoo019oo`00Cgoo00<007ooOol0:goo00<007oo
Ool0[7oo00<007ooOol00Woo00<007ooOol04Woo001@Ool00`00Oomoo`0ZOol00`00Oomoo`2/Ool0
0`00Oomoo`02Ool00`00Oomoo`0BOol0055oo`03001oogoo02Uoo`03001oogoo0:aoo`03001oogoo
009oo`03001oogoo019oo`00DWoo00<007ooOol0:7oo00<007ooOol0[7oo00<007ooOol00Woo00<0
07ooOol04Woo001COol00`00Oomoo`0WOol00`00Oomoo`2]Ool01@00Oomoogoo000057oo001DOol0
0`00Oomoo`0VOol00`00Oomoo`2]Ool01@00Oomoogoo000057oo001EOol00`00Oomoo`0UOol00`00
Oomoo`2]Ool01@00Oomoogoo000057oo001FOol00`00Oomoo`0TOol00`00Oomoo`2]Ool01@00Oomo
ogoo000057oo001GOol00`00Oomoo`0SOol00`00Oomoo`2^Ool01@00Oomoogoo00004goo001HOol0
0`00Oomoo`0ROol00`00Oomoo`2^Ool01@00Oomoogoo00004goo001IOol00`00Oomoo`0POol00`00
Oomoo`2_Ool01@00Oomoogoo00004goo001JOol00`00Oomoo`0OOol00`00Oomoo`2_Ool01@00Oomo
ogoo00004goo001KOol00`00Oomoo`0NOol00`00Oomoo`2`Ool01000Oomoo`004goo001LOol00`00
Oomoo`0MOol00`00Oomoo`2`Ool01000Oomoo`004goo001MOol00`00Oomoo`0LOol00`00Oomoo`2`
Ool01000Oomoo`004goo001NOol00`00Oomoo`0KOol00`00Oomoo`2aOol00`00Ool0000COol005mo
o`03001oogoo01Yoo`03001oogoo0;5oo`03001oo`0001=oo`00H7oo00<007ooOol06Goo00<007oo
Ool0/Goo00<007oo00004goo001QOol00`00Oomoo`0HOol00`00Oomoo`2aOol00`00Ool0000COol0
069oo`03001oogoo01Moo`03001oogoo0;9oo`8001=oo`00Hgoo00<007ooOol05Woo00<007ooOol0
/Woo0P004goo001TOol00`00Oomoo`0EOol00`00Oomoo`2bOol2000COol006Eoo`03001oogoo01Ao
o`03001oogoo0;9oo`03001oo`00019oo`00IWoo00<007ooOol04goo00<007ooOol0/goo0P004Woo
001WOol00`00Oomoo`0BOol00`00Oomoo`2cOol2000BOol006Qoo`80019oo`03001oogoo0;=oo`80
019oo`00JWoo00<007ooOol03goo00<007ooOol0/goo0P004Woo001[Ool00`00Oomoo`0>Ool00`00
Oomoo`2dOol00`00Oomoo`0@Ool006aoo`03001oogoo00eoo`03001oogoo0:ioo`L0019oo`00KGoo
00<007ooOol037oo00<007ooOol0XWoo30006Goo001^Ool00`00Oomoo`0;Ool00`00Oomoo`2FOol<
000UOol006moo`03001oogoo00Yoo`03001oogoo08Yoo``0035oo`00L7oo00<007ooOol027oo00<0
07ooOol0OWoo3@00?Goo001aOol00`00Oomoo`07Ool00`00Oomoo`1bOol<001:Ool0079oo`03001o
ogoo00Ioo`03001oogoo06Ioo``005Ioo`00Lgoo00<007ooOol01Goo00<007ooOol0FWoo3000HWoo
001dOol00`00Oomoo`04Ool00`00Oomoo`1=Ool=001^Ool005Ioo`<001aoo`03001oogoo00=oo`03
001oogoo045oo``007]oo`00Egoo00<007ooOol077oo00<007ooOol00Woo00<007ooOol0=Goo3000
Qgoo001GOol4000LOol01@00Oomoogoo0000:Woo3@00Tgoo001GOol01@00Oomoogoo000077oo00@0
07ooOol001ioo``00:1oo`00Egoo00D007ooOomoo`0001eoo`03001oo`00019oo``00:aoo`00Egoo
00D007ooOomoo`0001ioo`8000Ioo``00;Qoo`00Egoo0P000Woo00<007ooOol07Goo1`00a7oo001F
Ool200000goo0000003[Ool00?moodMoo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003o
Oom7Ool00?moodMoo`00W7oo0P000Woo0P002Woo10001Goo0P001Goo10000goo1@00OWoo002MOol0
1000Oomoo`000Woo1P000Woo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo
00@007ooOol000=oo`03001oogoo07aoo`00WWoo0P002goo00<007ooOol00Woo00<007ooOol027oo
00<007ooOol00Woo00D007ooOomoo`00085oo`00WWoo0P000goo1P000Woo00<007ooOol00Woo00<0
07ooOol027oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0OWoo002MOol01000Oomoo`00
2Woo00<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
OGoo002LOol20002Ool20009Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00
Oomoo`04Ool00`00Oomoo`1lOol00:]oo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009o
o`04001oogoo0003Ool00`00Oomoo`1lOol00:aoo`@000aoo`@000Aoo`<007moo`00ogooAgoo003o
Oom7Ool00?moodMoo`00ogooAgoo003oOom7Ool00001\
\>"],
  ImageRangeCache->{{{0, 325.938}, {230.313, 0}} -> {-0.170438, 0.0462141, \
0.00438712, 0.00438712}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70824 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.10169 -0.148196 1.10169 [
[.5 .72074 -20 0 ]
[.5 .72074 20 15 ]
[.44797 -0.02478 -4.90556 -15 ]
[.44797 -0.02478 5.09444 0 ]
[.15892 .66839 -5.31917 0 ]
[.15892 .66839 4.68083 15 ]
[-0.06694 .27471 -10 -6.62571 ]
[-0.06694 .27471 0 8.37429 ]
[ 0 0 0 0 ]
[ 1 .70824 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .72074 -81 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.03) show
99.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.02946 .11175 m
.89362 0 L
s
gsave
.44797 -0.02478 -65.9056 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .4272 m
.29069 .70824 L
s
gsave
.15892 .66839 -66.3192 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.02946 .11175 m
0 .4272 L
s
gsave
-0.06694 .27471 -71 -10.6257 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(q) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.29069 .70824 L
s
.29069 .70824 m
.30155 .45044 L
s
.30155 .45044 m
.02946 .11175 L
s
.89362 0 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.89362 0 m
.02946 .11175 L
s
.30155 .45044 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.29069 .70824 L
s
.29069 .70824 m
.30155 .45044 L
s
0 0 m
1 0 L
1 .70824 L
0 .70824 L
closepath
clip
newpath
.832 .74 .763 r
.2912 .5366 .29714 .55519 .31746 .52625 .31147 .51178 Mtetra
.741 .731 .842 r
.31147 .51178 .31746 .52625 .33701 .51579 .33104 .50348 Mtetra
.663 .722 .893 r
.33104 .50348 .33701 .51579 .35634 .51216 .35044 .50113 Mtetra
.61 .717 .921 r
.35044 .50113 .35634 .51216 .37565 .51129 .36982 .50107 Mtetra
.58 .717 .937 r
.36982 .50107 .37565 .51129 .39499 .51154 .38925 .50188 Mtetra
.564 .721 .947 r
.38925 .50188 .39499 .51154 .41439 .51221 .40876 .50294 Mtetra
.557 .727 .953 r
.40876 .50294 .41439 .51221 .43387 .51297 .42835 .50399 Mtetra
.555 .732 .958 r
.42835 .50399 .43387 .51297 .45343 .51367 .44802 .5049 Mtetra
.556 .738 .961 r
.44802 .5049 .45343 .51367 .47307 .51425 .46778 .50564 Mtetra
.557 .744 .964 r
.46778 .50564 .47307 .51425 .49279 .51467 .48761 .50618 Mtetra
.56 .748 .965 r
.48761 .50618 .49279 .51467 .5126 .51493 .50753 .50655 Mtetra
.562 .753 .967 r
.50753 .50655 .5126 .51493 .53247 .51504 .52753 .50673 Mtetra
.565 .756 .968 r
.52753 .50673 .53247 .51504 .55243 .515 .54761 .50675 Mtetra
.567 .76 .969 r
.54761 .50675 .55243 .515 .57246 .51483 .56777 .50663 Mtetra
.57 .763 .969 r
.56777 .50663 .57246 .51483 .59257 .51453 .588 .50637 Mtetra
.572 .765 .97 r
.588 .50637 .59257 .51453 .61275 .51412 .6083 .50598 Mtetra
.574 .768 .97 r
.6083 .50598 .61275 .51412 .633 .5136 .62869 .50549 Mtetra
.576 .77 .971 r
.62869 .50549 .633 .5136 .65333 .51299 .64914 .50489 Mtetra
.577 .772 .971 r
.64914 .50489 .65333 .51299 .67372 .51229 .66967 .5042 Mtetra
.579 .773 .972 r
.66967 .5042 .67372 .51229 .6942 .51152 .69028 .50343 Mtetra
.58 .775 .972 r
.69028 .50343 .6942 .51152 .71474 .51066 .71095 .50258 Mtetra
.581 .776 .972 r
.71095 .50258 .71474 .51066 .73536 .50975 .73171 .50166 Mtetra
.582 .778 .972 r
.73171 .50166 .73536 .50975 .75605 .50877 .75253 .50068 Mtetra
.584 .779 .972 r
.75253 .50068 .75605 .50877 .77681 .50773 .77343 .49964 Mtetra
.584 .78 .973 r
.77343 .49964 .77681 .50773 .79764 .50664 .7944 .49854 Mtetra
.585 .781 .973 r
.7944 .49854 .79764 .50664 .81854 .5055 .81544 .49739 Mtetra
.586 .782 .973 r
.81544 .49739 .81854 .5055 .83952 .50431 .83656 .49619 Mtetra
.587 .782 .973 r
.83656 .49619 .83952 .50431 .86057 .50309 .85775 .49495 Mtetra
.587 .783 .973 r
.85775 .49495 .86057 .50309 .88169 .50182 .87901 .49367 Mtetra
.588 .784 .973 r
.87901 .49367 .88169 .50182 .90289 .50051 .90035 .49236 Mtetra
.589 .784 .973 r
.90035 .49236 .90289 .50051 .92415 .49917 .92176 .491 Mtetra
.589 .785 .973 r
.92176 .491 .92415 .49917 .94549 .4978 .94324 .48961 Mtetra
.59 .786 .973 r
.94324 .48961 .94549 .4978 .96691 .4964 .9648 .48819 Mtetra
.59 .786 .974 r
.9648 .48819 .96691 .4964 .98839 .49497 .98643 .48674 Mtetra
.813 .731 .774 r
.28521 .51783 .2912 .5366 .31147 .51178 .30541 .49716 Mtetra
.717 .719 .851 r
.30541 .49716 .31147 .51178 .33104 .50348 .32501 .49103 Mtetra
.64 .71 .898 r
.32501 .49103 .33104 .50348 .35044 .50113 .34446 .48996 Mtetra
.591 .707 .923 r
.34446 .48996 .35044 .50113 .36982 .50107 .36392 .49073 Mtetra
.565 .709 .938 r
.36392 .49073 .36982 .50107 .38925 .50188 .38345 .49209 Mtetra
.553 .715 .948 r
.38345 .49209 .38925 .50188 .40876 .50294 .40306 .49355 Mtetra
.549 .722 .954 r
.40306 .49355 .40876 .50294 .42835 .50399 .42275 .49488 Mtetra
.549 .729 .958 r
.42275 .49488 .42835 .50399 .44802 .5049 .44254 .49601 Mtetra
.551 .735 .961 r
.44254 .49601 .44802 .5049 .46778 .50564 .46241 .49691 Mtetra
.553 .741 .964 r
.46241 .49691 .46778 .50564 .48761 .50618 .48236 .49759 Mtetra
.556 .747 .966 r
.48236 .49759 .48761 .50618 .50753 .50655 .5024 .49805 Mtetra
.56 .751 .967 r
.5024 .49805 .50753 .50655 .52753 .50673 .52253 .49831 Mtetra
.563 .755 .968 r
.52253 .49831 .52753 .50673 .54761 .50675 .54273 .49839 Mtetra
.566 .759 .969 r
.54273 .49839 .54761 .50675 .56777 .50663 .56301 .49831 Mtetra
.568 .762 .97 r
.56301 .49831 .56777 .50663 .588 .50637 .58337 .49809 Mtetra
.571 .765 .97 r
.58337 .49809 .588 .50637 .6083 .50598 .6038 .49773 Mtetra
.573 .767 .971 r
.6038 .49773 .6083 .50598 .62869 .50549 .62432 .49726 Mtetra
.575 .769 .971 r
.62432 .49726 .62869 .50549 .64914 .50489 .6449 .49668 Mtetra
.576 .771 .971 r
.6449 .49668 .64914 .50489 .66967 .5042 .66557 .496 Mtetra
.578 .773 .972 r
.66557 .496 .66967 .5042 .69028 .50343 .6863 .49523 Mtetra
.58 .775 .972 r
.6863 .49523 .69028 .50343 .71095 .50258 .70712 .49439 Mtetra
.581 .776 .972 r
.70712 .49439 .71095 .50258 .73171 .50166 .728 .49347 Mtetra
.582 .777 .972 r
.728 .49347 .73171 .50166 .75253 .50068 .74896 .49248 Mtetra
.583 .779 .972 r
.74896 .49248 .75253 .50068 .77343 .49964 .77 .49143 Mtetra
.584 .78 .973 r
.77 .49143 .77343 .49964 .7944 .49854 .79111 .49033 Mtetra
.585 .781 .973 r
.79111 .49033 .7944 .49854 .81544 .49739 .81229 .48917 Mtetra
.586 .781 .973 r
.81229 .48917 .81544 .49739 .83656 .49619 .83355 .48796 Mtetra
.587 .782 .973 r
.83355 .48796 .83656 .49619 .85775 .49495 .85488 .48671 Mtetra
.587 .783 .973 r
.85488 .48671 .85775 .49495 .87901 .49367 .87629 .48542 Mtetra
.588 .784 .973 r
.87629 .48542 .87901 .49367 .90035 .49236 .89777 .48408 Mtetra
.89777 .48408 .90035 .49236 .92176 .491 .91933 .48271 Mtetra
.589 .785 .973 r
.91933 .48271 .92176 .491 .94324 .48961 .94096 .48131 Mtetra
.94096 .48131 .94324 .48961 .9648 .48819 .96267 .47987 Mtetra
.59 .786 .974 r
.96267 .47987 .9648 .48819 .98643 .48674 .98445 .4784 Mtetra
.79 .719 .786 r
.27916 .49888 .28521 .51783 .30541 .49716 .29929 .48237 Mtetra
.69 .705 .859 r
.29929 .48237 .30541 .49716 .32501 .49103 .3189 .47843 Mtetra
.615 .696 .902 r
.3189 .47843 .32501 .49103 .34446 .48996 .33841 .47866 Mtetra
.571 .696 .926 r
.33841 .47866 .34446 .48996 .36392 .49073 .35795 .48026 Mtetra
.55 .701 .94 r
.35795 .48026 .36392 .49073 .38345 .49209 .37757 .48219 Mtetra
.542 .709 .948 r
.37757 .48219 .38345 .49209 .40306 .49355 .39728 .48404 Mtetra
.54 .717 .954 r
.39728 .48404 .40306 .49355 .42275 .49488 .41708 .48566 Mtetra
.542 .725 .959 r
.41708 .48566 .42275 .49488 .44254 .49601 .43698 .48701 Mtetra
.545 .733 .962 r
.43698 .48701 .44254 .49601 .46241 .49691 .45697 .48808 Mtetra
.549 .739 .964 r
.45697 .48808 .46241 .49691 .48236 .49759 .47704 .48888 Mtetra
.553 .745 .966 r
.47704 .48888 .48236 .49759 .5024 .49805 .49721 .48943 Mtetra
.557 .75 .967 r
.49721 .48943 .5024 .49805 .52253 .49831 .51745 .48977 Mtetra
.561 .754 .968 r
.51745 .48977 .52253 .49831 .54273 .49839 .53778 .48992 Mtetra
.564 .758 .969 r
.53778 .48992 .54273 .49839 .56301 .49831 .55819 .48988 Mtetra
.567 .761 .97 r
.55819 .48988 .56301 .49831 .58337 .49809 .57868 .4897 Mtetra
.569 .764 .97 r
.57868 .4897 .58337 .49809 .6038 .49773 .59924 .48937 Mtetra
.572 .767 .971 r
.59924 .48937 .6038 .49773 .62432 .49726 .61989 .48892 Mtetra
.574 .769 .971 r
.61989 .48892 .62432 .49726 .6449 .49668 .64061 .48835 Mtetra
.576 .771 .971 r
.64061 .48835 .6449 .49668 .66557 .496 .6614 .48768 Mtetra
.577 .773 .972 r
.6614 .48768 .66557 .496 .6863 .49523 .68228 .48692 Mtetra
.579 .774 .972 r
.68228 .48692 .6863 .49523 .70712 .49439 .70323 .48608 Mtetra
.58 .776 .972 r
.70323 .48608 .70712 .49439 .728 .49347 .72425 .48516 Mtetra
.582 .777 .972 r
.72425 .48516 .728 .49347 .74896 .49248 .74535 .48417 Mtetra
.583 .778 .972 r
.74535 .48417 .74896 .49248 .77 .49143 .76653 .48311 Mtetra
.584 .779 .973 r
.76653 .48311 .77 .49143 .79111 .49033 .78778 .482 Mtetra
.585 .78 .973 r
.78778 .482 .79111 .49033 .81229 .48917 .8091 .48083 Mtetra
.586 .781 .973 r
.8091 .48083 .81229 .48917 .83355 .48796 .8305 .47962 Mtetra
.586 .782 .973 r
.8305 .47962 .83355 .48796 .85488 .48671 .85198 .47835 Mtetra
.587 .783 .973 r
.85198 .47835 .85488 .48671 .87629 .48542 .87353 .47704 Mtetra
.588 .784 .973 r
.87353 .47704 .87629 .48542 .89777 .48408 .89516 .47569 Mtetra
.89516 .47569 .89777 .48408 .91933 .48271 .91686 .47431 Mtetra
.589 .785 .973 r
.91686 .47431 .91933 .48271 .94096 .48131 .93864 .47289 Mtetra
.93864 .47289 .94096 .48131 .96267 .47987 .9605 .47143 Mtetra
.59 .786 .974 r
.9605 .47143 .96267 .47987 .98445 .4784 .98243 .46994 Mtetra
.762 .705 .798 r
.27305 .47974 .27916 .49888 .29929 .48237 .2931 .46742 Mtetra
.659 .689 .867 r
.2931 .46742 .29929 .48237 .3189 .47843 .31272 .46568 Mtetra
.588 .681 .906 r
.31272 .46568 .3189 .47843 .33841 .47866 .33229 .46721 Mtetra
.55 .684 .927 r
.33229 .46721 .33841 .47866 .35795 .48026 .35191 .46965 Mtetra
.534 .692 .94 r
.35191 .46965 .35795 .48026 .37757 .48219 .37162 .47215 Mtetra
.53 .702 .949 r
.37162 .47215 .37757 .48219 .39728 .48404 .39143 .47441 Mtetra
.532 .712 .955 r
.39143 .47441 .39728 .48404 .41708 .48566 .41134 .47632 Mtetra
.535 .722 .959 r
.41134 .47632 .41708 .48566 .43698 .48701 .43135 .47789 Mtetra
.54 .73 .962 r
.43135 .47789 .43698 .48701 .45697 .48808 .45146 .47912 Mtetra
.545 .737 .964 r
.45146 .47912 .45697 .48808 .47704 .48888 .47165 .48005 Mtetra
.55 .743 .966 r
.47165 .48005 .47704 .48888 .49721 .48943 .49194 .48071 Mtetra
.554 .748 .967 r
.49194 .48071 .49721 .48943 .51745 .48977 .51231 .48112 Mtetra
.558 .753 .968 r
.51231 .48112 .51745 .48977 .53778 .48992 .53276 .48133 Mtetra
.562 .757 .969 r
.53276 .48133 .53778 .48992 .55819 .48988 .5533 .48134 Mtetra
.565 .76 .97 r
.5533 .48134 .55819 .48988 .57868 .4897 .57392 .48119 Mtetra
.568 .763 .97 r
.57392 .48119 .57868 .4897 .59924 .48937 .59462 .48089 Mtetra
.571 .766 .971 r
.59462 .48089 .59924 .48937 .61989 .48892 .61539 .48046 Mtetra
.573 .768 .971 r
.61539 .48046 .61989 .48892 .64061 .48835 .63625 .47991 Mtetra
.575 .77 .971 r
.63625 .47991 .64061 .48835 .6614 .48768 .65718 .47925 Mtetra
.577 .772 .972 r
.65718 .47925 .6614 .48768 .68228 .48692 .67819 .4785 Mtetra
.578 .774 .972 r
.67819 .4785 .68228 .48692 .70323 .48608 .69928 .47765 Mtetra
.58 .775 .972 r
.69928 .47765 .70323 .48608 .72425 .48516 .72044 .47673 Mtetra
.581 .777 .972 r
.72044 .47673 .72425 .48516 .74535 .48417 .74169 .47574 Mtetra
.582 .778 .972 r
.74169 .47574 .74535 .48417 .76653 .48311 .763 .47468 Mtetra
.583 .779 .973 r
.763 .47468 .76653 .48311 .78778 .482 .7844 .47356 Mtetra
.584 .78 .973 r
.7844 .47356 .78778 .482 .8091 .48083 .80587 .47238 Mtetra
.585 .781 .973 r
.80587 .47238 .8091 .48083 .8305 .47962 .82741 .47115 Mtetra
.586 .782 .973 r
.82741 .47115 .8305 .47962 .85198 .47835 .84903 .46987 Mtetra
.587 .783 .973 r
.84903 .46987 .85198 .47835 .87353 .47704 .87073 .46855 Mtetra
.87073 .46855 .87353 .47704 .89516 .47569 .89251 .46719 Mtetra
.588 .784 .973 r
.89251 .46719 .89516 .47569 .91686 .47431 .91436 .46578 Mtetra
.589 .785 .973 r
.91436 .46578 .91686 .47431 .93864 .47289 .9363 .46434 Mtetra
.9363 .46434 .93864 .47289 .9605 .47143 .9583 .46287 Mtetra
.59 .786 .974 r
.9583 .46287 .9605 .47143 .98243 .46994 .98039 .46136 Mtetra
.729 .686 .809 r
.26689 .46043 .27305 .47974 .2931 .46742 .28685 .45231 Mtetra
.623 .669 .873 r
.28685 .45231 .2931 .46742 .31272 .46568 .30647 .45278 Mtetra
.558 .665 .908 r
.30647 .45278 .31272 .46568 .33229 .46721 .32609 .45563 Mtetra
.528 .671 .928 r
.32609 .45563 .33229 .46721 .35191 .46965 .34579 .45891 Mtetra
.518 .683 .941 r
.34579 .45891 .35191 .46965 .37162 .47215 .36559 .46198 Mtetra
.518 .695 .949 r
.36559 .46198 .37162 .47215 .39143 .47441 .3855 .46464 Mtetra
.523 .707 .955 r
.3855 .46464 .39143 .47441 .41134 .47632 .40552 .46686 Mtetra
.529 .718 .959 r
.40552 .46686 .41134 .47632 .43135 .47789 .42565 .46864 Mtetra
.535 .727 .962 r
.42565 .46864 .43135 .47789 .45146 .47912 .44587 .47004 Mtetra
.541 .735 .965 r
.44587 .47004 .45146 .47912 .47165 .48005 .46619 .4711 Mtetra
.547 .741 .966 r
.46619 .4711 .47165 .48005 .49194 .48071 .4866 .47186 Mtetra
.552 .747 .967 r
.4866 .47186 .49194 .48071 .51231 .48112 .5071 .47235 Mtetra
.556 .752 .968 r
.5071 .47235 .51231 .48112 .53276 .48133 .52768 .47262 Mtetra
.56 .756 .969 r
.52768 .47262 .53276 .48133 .5533 .48134 .54835 .47268 Mtetra
.564 .759 .97 r
.54835 .47268 .5533 .48134 .57392 .48119 .5691 .47257 Mtetra
.567 .763 .97 r
.5691 .47257 .57392 .48119 .59462 .48089 .58993 .4723 Mtetra
.57 .765 .971 r
.58993 .4723 .59462 .48089 .61539 .48046 .61084 .47189 Mtetra
.572 .768 .971 r
.61084 .47189 .61539 .48046 .63625 .47991 .63183 .47135 Mtetra
.574 .77 .971 r
.63183 .47135 .63625 .47991 .65718 .47925 .6529 .4707 Mtetra
.576 .772 .972 r
.6529 .4707 .65718 .47925 .67819 .4785 .67405 .46995 Mtetra
.578 .774 .972 r
.67405 .46995 .67819 .4785 .69928 .47765 .69528 .46911 Mtetra
.579 .775 .972 r
.69528 .46911 .69928 .47765 .72044 .47673 .71659 .46819 Mtetra
.581 .776 .972 r
.71659 .46819 .72044 .47673 .74169 .47574 .73797 .46719 Mtetra
.582 .778 .973 r
.73797 .46719 .74169 .47574 .763 .47468 .75943 .46613 Mtetra
.583 .779 .973 r
.75943 .46613 .763 .47468 .7844 .47356 .78097 .465 Mtetra
.584 .78 .973 r
.78097 .465 .7844 .47356 .80587 .47238 .80258 .46381 Mtetra
.585 .781 .973 r
.80258 .46381 .80587 .47238 .82741 .47115 .82428 .46257 Mtetra
.586 .782 .973 r
.82428 .46257 .82741 .47115 .84903 .46987 .84605 .46128 Mtetra
.587 .783 .973 r
.84605 .46128 .84903 .46987 .87073 .46855 .8679 .45994 Mtetra
.8679 .45994 .87073 .46855 .89251 .46719 .88983 .45856 Mtetra
.588 .784 .973 r
.88983 .45856 .89251 .46719 .91436 .46578 .91183 .45714 Mtetra
.588 .785 .973 r
.91183 .45714 .91436 .46578 .9363 .46434 .93391 .45568 Mtetra
.589 .785 .973 r
.93391 .45568 .9363 .46434 .9583 .46287 .95608 .45418 Mtetra
.589 .786 .974 r
.95608 .45418 .9583 .46287 .98039 .46136 .97832 .45266 Mtetra
.688 .663 .82 r
.26066 .44092 .26689 .46043 .28685 .45231 .28052 .43702 Mtetra
.583 .646 .878 r
.28052 .43702 .28685 .45231 .30647 .45278 .30015 .43973 Mtetra
.526 .646 .91 r
.30015 .43973 .30647 .45278 .32609 .45563 .31981 .4439 Mtetra
.504 .658 .929 r
.31981 .4439 .32609 .45563 .34579 .45891 .33958 .44804 Mtetra
.501 .673 .941 r
.33958 .44804 .34579 .45891 .36559 .46198 .35948 .45169 Mtetra
.506 .688 .95 r
.35948 .45169 .36559 .46198 .3855 .46464 .3795 .45476 Mtetra
.514 .702 .955 r
.3795 .45476 .3855 .46464 .40552 .46686 .39963 .45727 Mtetra
.522 .714 .96 r
.39963 .45727 .40552 .46686 .42565 .46864 .41987 .45928 Mtetra
.53 .724 .963 r
.41987 .45928 .42565 .46864 .44587 .47004 .44021 .46084 Mtetra
.537 .732 .965 r
.44021 .46084 .44587 .47004 .46619 .4711 .46065 .46203 Mtetra
.544 .739 .966 r
.46065 .46203 .46619 .4711 .4866 .47186 .48119 .46289 Mtetra
.549 .745 .968 r
.48119 .46289 .4866 .47186 .5071 .47235 .50181 .46347 Mtetra
.554 .75 .969 r
.50181 .46347 .5071 .47235 .52768 .47262 .52253 .46379 Mtetra
.558 .755 .969 r
.52253 .46379 .52768 .47262 .54835 .47268 .54333 .46391 Mtetra
.562 .759 .97 r
.54333 .46391 .54835 .47268 .5691 .47257 .56421 .46383 Mtetra
.566 .762 .97 r
.56421 .46383 .5691 .47257 .58993 .4723 .58518 .46359 Mtetra
.568 .765 .971 r
.58518 .46359 .58993 .4723 .61084 .47189 .60622 .46319 Mtetra
.571 .767 .971 r
.60622 .46319 .61084 .47189 .63183 .47135 .62735 .46267 Mtetra
.573 .769 .972 r
.62735 .46267 .63183 .47135 .6529 .4707 .64856 .46203 Mtetra
.575 .771 .972 r
.64856 .46203 .6529 .4707 .67405 .46995 .66985 .46129 Mtetra
.577 .773 .972 r
.66985 .46129 .67405 .46995 .69528 .46911 .69122 .46045 Mtetra
.579 .775 .972 r
.69122 .46045 .69528 .46911 .71659 .46819 .71267 .45953 Mtetra
.58 .776 .972 r
.71267 .45953 .71659 .46819 .73797 .46719 .7342 .45853 Mtetra
.581 .777 .973 r
.7342 .45853 .73797 .46719 .75943 .46613 .75581 .45745 Mtetra
.583 .779 .973 r
.75581 .45745 .75943 .46613 .78097 .465 .77749 .45631 Mtetra
.584 .78 .973 r
.77749 .45631 .78097 .465 .80258 .46381 .79926 .45512 Mtetra
.585 .781 .973 r
.79926 .45512 .80258 .46381 .82428 .46257 .8211 .45386 Mtetra
.585 .782 .973 r
.8211 .45386 .82428 .46257 .84605 .46128 .84302 .45256 Mtetra
.586 .782 .973 r
.84302 .45256 .84605 .46128 .8679 .45994 .86502 .4512 Mtetra
.587 .783 .973 r
.86502 .4512 .8679 .45994 .88983 .45856 .8871 .44981 Mtetra
.588 .784 .973 r
.8871 .44981 .88983 .45856 .91183 .45714 .90926 .44837 Mtetra
.90926 .44837 .91183 .45714 .93391 .45568 .9315 .44689 Mtetra
.589 .785 .973 r
.9315 .44689 .93391 .45568 .95608 .45418 .95382 .44538 Mtetra
.589 .786 .974 r
.95382 .44538 .95608 .45418 .97832 .45266 .97622 .44383 Mtetra
.639 .634 .829 r
.25438 .42123 .26066 .44092 .28052 .43702 .27412 .42157 Mtetra
.537 .619 .881 r
.27412 .42157 .28052 .43702 .30015 .43973 .29374 .42652 Mtetra
.491 .626 .91 r
.29374 .42652 .30015 .43973 .31981 .4439 .31346 .43203 Mtetra
.48 .643 .929 r
.31346 .43203 .31981 .4439 .33958 .44804 .3333 .43702 Mtetra
.484 .663 .941 r
.3333 .43702 .33958 .44804 .35948 .45169 .35329 .44125 Mtetra
.493 .681 .95 r
.35329 .44125 .35948 .45169 .3795 .45476 .37341 .44474 Mtetra
.504 .697 .956 r
.37341 .44474 .3795 .45476 .39963 .45727 .39365 .44755 Mtetra
.515 .71 .96 r
.39365 .44755 .39963 .45727 .41987 .45928 .41401 .44978 Mtetra
.524 .721 .963 r
.41401 .44978 .41987 .45928 .44021 .46084 .43447 .45152 Mtetra
.533 .73 .965 r
.43447 .45152 .44021 .46084 .46065 .46203 .45504 .45284 Mtetra
.54 .738 .967 r
.45504 .45284 .46065 .46203 .48119 .46289 .4757 .4538 Mtetra
.547 .744 .968 r
.4757 .4538 .48119 .46289 .50181 .46347 .49645 .45446 Mtetra
.552 .749 .969 r
.49645 .45446 .50181 .46347 .52253 .46379 .5173 .45485 Mtetra
.557 .754 .969 r
.5173 .45485 .52253 .46379 .54333 .46391 .53823 .45501 Mtetra
.561 .758 .97 r
.53823 .45501 .54333 .46391 .56421 .46383 .55925 .45497 Mtetra
.564 .761 .971 r
.55925 .45497 .56421 .46383 .58518 .46359 .58036 .45475 Mtetra
.567 .764 .971 r
.58036 .45475 .58518 .46359 .60622 .46319 .60154 .45438 Mtetra
.57 .767 .971 r
.60154 .45438 .60622 .46319 .62735 .46267 .62281 .45387 Mtetra
.573 .769 .972 r
.62281 .45387 .62735 .46267 .64856 .46203 .64416 .45324 Mtetra
.575 .771 .972 r
.64416 .45324 .64856 .46203 .66985 .46129 .6656 .45251 Mtetra
.577 .773 .972 r
.6656 .45251 .66985 .46129 .69122 .46045 .68711 .45167 Mtetra
.578 .774 .972 r
.68711 .45167 .69122 .46045 .71267 .45953 .7087 .45074 Mtetra
.58 .776 .972 r
.7087 .45074 .71267 .45953 .7342 .45853 .73038 .44973 Mtetra
.581 .777 .973 r
.73038 .44973 .7342 .45853 .75581 .45745 .75213 .44865 Mtetra
.582 .778 .973 r
.75213 .44865 .75581 .45745 .77749 .45631 .77397 .44751 Mtetra
.583 .779 .973 r
.77397 .44751 .77749 .45631 .79926 .45512 .79588 .4463 Mtetra
.584 .78 .973 r
.79588 .4463 .79926 .45512 .8211 .45386 .81787 .44503 Mtetra
.585 .781 .973 r
.81787 .44503 .8211 .45386 .84302 .45256 .83995 .44371 Mtetra
.586 .782 .973 r
.83995 .44371 .84302 .45256 .86502 .4512 .8621 .44234 Mtetra
.587 .783 .973 r
.8621 .44234 .86502 .4512 .8871 .44981 .88434 .44093 Mtetra
.587 .784 .973 r
.88434 .44093 .8871 .44981 .90926 .44837 .90665 .43947 Mtetra
.588 .784 .973 r
.90665 .43947 .90926 .44837 .9315 .44689 .92905 .43797 Mtetra
.589 .785 .973 r
.92905 .43797 .9315 .44689 .95382 .44538 .95153 .43644 Mtetra
.589 .785 .974 r
.95153 .43644 .95382 .44538 .97622 .44383 .97408 .43487 Mtetra
.578 .596 .835 r
.24803 .40134 .25438 .42123 .27412 .42157 .26765 .40594 Mtetra
.485 .587 .881 r
.26765 .40594 .27412 .42157 .29374 .42652 .28726 .41315 Mtetra
.454 .603 .909 r
.28726 .41315 .29374 .42652 .31346 .43203 .30702 .42001 Mtetra
.454 .628 .928 r
.30702 .42001 .31346 .43203 .3333 .43702 .32694 .42586 Mtetra
.466 .652 .941 r
.32694 .42586 .3333 .43702 .35329 .44125 .34702 .43068 Mtetra
.48 .674 .949 r
.34702 .43068 .35329 .44125 .37341 .44474 .36724 .43458 Mtetra
.495 .691 .956 r
.36724 .43458 .37341 .44474 .39365 .44755 .3876 .4377 Mtetra
.508 .706 .96 r
.3876 .4377 .39365 .44755 .41401 .44978 .40807 .44016 Mtetra
.519 .718 .963 r
.40807 .44016 .41401 .44978 .43447 .45152 .42866 .44207 Mtetra
.529 .728 .965 r
.42866 .44207 .43447 .45152 .45504 .45284 .44935 .44352 Mtetra
.537 .736 .967 r
.44935 .44352 .45504 .45284 .4757 .4538 .47014 .44459 Mtetra
.544 .742 .968 r
.47014 .44459 .4757 .4538 .49645 .45446 .49102 .44532 Mtetra
.55 .748 .969 r
.49102 .44532 .49645 .45446 .5173 .45485 .512 .44577 Mtetra
.555 .753 .97 r
.512 .44577 .5173 .45485 .53823 .45501 .53307 .44598 Mtetra
.559 .757 .97 r
.53307 .44598 .53823 .45501 .55925 .45497 .55423 .44598 Mtetra
.563 .76 .971 r
.55423 .44598 .55925 .45497 .58036 .45475 .57547 .44579 Mtetra
.566 .764 .971 r
.57547 .44579 .58036 .45475 .60154 .45438 .5968 .44544 Mtetra
.569 .766 .971 r
.5968 .44544 .60154 .45438 .62281 .45387 .61821 .44495 Mtetra
.572 .769 .972 r
.61821 .44495 .62281 .45387 .64416 .45324 .6397 .44433 Mtetra
.574 .771 .972 r
.6397 .44433 .64416 .45324 .6656 .45251 .66128 .44359 Mtetra
.576 .772 .972 r
.66128 .44359 .6656 .45251 .68711 .45167 .68294 .44276 Mtetra
.578 .774 .972 r
.68294 .44276 .68711 .45167 .7087 .45074 .70468 .44183 Mtetra
.579 .776 .972 r
.70468 .44183 .7087 .45074 .73038 .44973 .7265 .44082 Mtetra
.581 .777 .973 r
.7265 .44082 .73038 .44973 .75213 .44865 .7484 .43973 Mtetra
.582 .778 .973 r
.7484 .43973 .75213 .44865 .77397 .44751 .77039 .43857 Mtetra
.583 .779 .973 r
.77039 .43857 .77397 .44751 .79588 .4463 .79245 .43735 Mtetra
.584 .78 .973 r
.79245 .43735 .79588 .4463 .81787 .44503 .8146 .43607 Mtetra
.585 .781 .973 r
.8146 .43607 .81787 .44503 .83995 .44371 .83683 .43474 Mtetra
.586 .782 .973 r
.83683 .43474 .83995 .44371 .8621 .44234 .85914 .43335 Mtetra
.587 .783 .973 r
.85914 .43335 .8621 .44234 .88434 .44093 .88153 .43192 Mtetra
.587 .784 .973 r
.88153 .43192 .88434 .44093 .90665 .43947 .90401 .43044 Mtetra
.588 .784 .973 r
.90401 .43044 .90665 .43947 .92905 .43797 .92656 .42893 Mtetra
.588 .785 .973 r
.92656 .42893 .92905 .43797 .95153 .43644 .9492 .42737 Mtetra
.589 .785 .974 r
.9492 .42737 .95153 .43644 .97408 .43487 .97192 .42578 Mtetra
.504 .549 .836 r
.24162 .38126 .24803 .40134 .26765 .40594 .26111 .39013 Mtetra
.427 .55 .877 r
.26111 .39013 .26765 .40594 .28726 .41315 .28071 .39962 Mtetra
.414 .578 .906 r
.28071 .39962 .28726 .41315 .30702 .42001 .3005 .40783 Mtetra
.427 .611 .926 r
.3005 .40783 .30702 .42001 .32694 .42586 .3205 .41456 Mtetra
.447 .641 .94 r
.3205 .41456 .32694 .42586 .34702 .43068 .34067 .41997 Mtetra
.467 .666 .949 r
.34067 .41997 .34702 .43068 .36724 .43458 .361 .42429 Mtetra
.485 .686 .955 r
.361 .42429 .36724 .43458 .3876 .4377 .38146 .42771 Mtetra
.501 .702 .96 r
.38146 .42771 .3876 .4377 .40807 .44016 .40205 .4304 Mtetra
.514 .715 .963 r
.40205 .4304 .40807 .44016 .42866 .44207 .42276 .43249 Mtetra
.524 .725 .965 r
.42276 .43249 .42866 .44207 .44935 .44352 .44358 .43407 Mtetra
.534 .734 .967 r
.44358 .43407 .44935 .44352 .47014 .44459 .4645 .43524 Mtetra
.541 .741 .968 r
.4645 .43524 .47014 .44459 .49102 .44532 .48552 .43606 Mtetra
.548 .747 .969 r
.48552 .43606 .49102 .44532 .512 .44577 .50663 .43657 Mtetra
.553 .752 .97 r
.50663 .43657 .512 .44577 .53307 .44598 .52783 .43683 Mtetra
.558 .756 .97 r
.52783 .43683 .53307 .44598 .55423 .44598 .54913 .43686 Mtetra
.562 .76 .971 r
.54913 .43686 .55423 .44598 .57547 .44579 .57051 .4367 Mtetra
.565 .763 .971 r
.57051 .4367 .57547 .44579 .5968 .44544 .59198 .43637 Mtetra
.568 .766 .971 r
.59198 .43637 .5968 .44544 .61821 .44495 .61354 .4359 Mtetra
.571 .768 .972 r
.61354 .4359 .61821 .44495 .6397 .44433 .63517 .43529 Mtetra
.573 .77 .972 r
.63517 .43529 .6397 .44433 .66128 .44359 .6569 .43456 Mtetra
.575 .772 .972 r
.6569 .43456 .66128 .44359 .68294 .44276 .6787 .43372 Mtetra
.577 .774 .972 r
.6787 .43372 .68294 .44276 .70468 .44183 .70059 .43279 Mtetra
.579 .775 .972 r
.70059 .43279 .70468 .44183 .7265 .44082 .72257 .43177 Mtetra
.58 .777 .973 r
.72257 .43177 .7265 .44082 .7484 .43973 .74462 .43068 Mtetra
.582 .778 .973 r
.74462 .43068 .7484 .43973 .77039 .43857 .76676 .42951 Mtetra
.583 .779 .973 r
.76676 .42951 .77039 .43857 .79245 .43735 .78898 .42827 Mtetra
.584 .78 .973 r
.78898 .42827 .79245 .43735 .8146 .43607 .81128 .42698 Mtetra
.585 .781 .973 r
.81128 .42698 .8146 .43607 .83683 .43474 .83367 .42563 Mtetra
.586 .782 .973 r
.83367 .42563 .83683 .43474 .85914 .43335 .85614 .42423 Mtetra
.586 .783 .973 r
.85614 .42423 .85914 .43335 .88153 .43192 .87869 .42278 Mtetra
.587 .783 .973 r
.87869 .42278 .88153 .43192 .90401 .43044 .90132 .42128 Mtetra
.588 .784 .973 r
.90132 .42128 .90401 .43044 .92656 .42893 .92404 .41975 Mtetra
.588 .785 .973 r
.92404 .41975 .92656 .42893 .9492 .42737 .94684 .41817 Mtetra
.589 .785 .974 r
.94684 .41817 .9492 .42737 .97192 .42578 .96972 .41656 Mtetra
.458 .601 .906 r
.2348 .36736 .24162 .38126 .26111 .39013 .25449 .37414 Mtetra
.363 .508 .869 r
.25449 .37414 .26111 .39013 .28071 .39962 .27407 .38592 Mtetra
.371 .55 .9 r
.27407 .38592 .28071 .39962 .3005 .40783 .2939 .3955 Mtetra
.398 .593 .923 r
.2939 .3955 .3005 .40783 .3205 .41456 .31397 .40311 Mtetra
.427 .629 .938 r
.31397 .40311 .3205 .41456 .34067 .41997 .33423 .40912 Mtetra
.454 .658 .948 r
.33423 .40912 .34067 .41997 .361 .42429 .35466 .41386 Mtetra
.475 .68 .955 r
.35466 .41386 .361 .42429 .38146 .42771 .37524 .41759 Mtetra
.493 .698 .96 r
.37524 .41759 .38146 .42771 .40205 .4304 .39595 .42051 Mtetra
.508 .712 .963 r
.39595 .42051 .40205 .4304 .42276 .43249 .41678 .42277 Mtetra
.52 .723 .965 r
.41678 .42277 .42276 .43249 .44358 .43407 .43773 .42449 Mtetra
.53 .732 .967 r
.43773 .42449 .44358 .43407 .4645 .43524 .45878 .42577 Mtetra
.538 .739 .968 r
.45878 .42577 .4645 .43524 .48552 .43606 .47993 .42666 Mtetra
.545 .745 .969 r
.47993 .42666 .48552 .43606 .50663 .43657 .50118 .42724 Mtetra
.551 .751 .97 r
.50118 .42724 .50663 .43657 .52783 .43683 .52252 .42755 Mtetra
.556 .755 .97 r
.52252 .42755 .52783 .43683 .54913 .43686 .54396 .42762 Mtetra
.56 .759 .971 r
.54396 .42762 .54913 .43686 .57051 .4367 .56548 .42749 Mtetra
.564 .762 .971 r
.56548 .42749 .57051 .4367 .59198 .43637 .5871 .42718 Mtetra
.567 .765 .971 r
.5871 .42718 .59198 .43637 .61354 .4359 .6088 .42671 Mtetra
.57 .768 .972 r
.6088 .42671 .61354 .4359 .63517 .43529 .63058 .42611 Mtetra
.573 .77 .972 r
.63058 .42611 .63517 .43529 .6569 .43456 .65245 .42539 Mtetra
.575 .772 .972 r
.65245 .42539 .6569 .43456 .6787 .43372 .67441 .42455 Mtetra
.577 .774 .972 r
.67441 .42455 .6787 .43372 .70059 .43279 .69645 .42362 Mtetra
.578 .775 .973 r
.69645 .42362 .70059 .43279 .72257 .43177 .71858 .42259 Mtetra
.58 .776 .973 r
.71858 .42259 .72257 .43177 .74462 .43068 .74079 .42149 Mtetra
.581 .778 .973 r
.74079 .42149 .74462 .43068 .76676 .42951 .76308 .42031 Mtetra
.582 .779 .973 r
.76308 .42031 .76676 .42951 .78898 .42827 .78545 .41906 Mtetra
.583 .78 .973 r
.78545 .41906 .78898 .42827 .81128 .42698 .80792 .41776 Mtetra
.584 .781 .973 r
.80792 .41776 .81128 .42698 .83367 .42563 .83046 .41639 Mtetra
.585 .782 .973 r
.83046 .41639 .83367 .42563 .85614 .42423 .85309 .41497 Mtetra
.586 .783 .973 r
.85309 .41497 .85614 .42423 .87869 .42278 .8758 .4135 Mtetra
.587 .783 .973 r
.8758 .4135 .87869 .42278 .90132 .42128 .8986 .41199 Mtetra
.588 .784 .973 r
.8986 .41199 .90132 .42128 .92404 .41975 .92148 .41043 Mtetra
.588 .785 .973 r
.92148 .41043 .92404 .41975 .94684 .41817 .94444 .40883 Mtetra
.589 .785 .974 r
.94444 .40883 .94684 .41817 .96972 .41656 .96749 .40719 Mtetra
.569 .764 .97 r
.22762 .35841 .2348 .36736 .25449 .37414 .24779 .35797 Mtetra
.292 .459 .855 r
.24779 .35797 .25449 .37414 .27407 .38592 .26735 .37206 Mtetra
.325 .52 .892 r
.26735 .37206 .27407 .38592 .2939 .3955 .28722 .38301 Mtetra
.368 .574 .919 r
.28722 .38301 .2939 .3955 .31397 .40311 .30736 .39151 Mtetra
.407 .617 .936 r
.30736 .39151 .31397 .40311 .33423 .40912 .32771 .39812 Mtetra
.44 .649 .947 r
.32771 .39812 .33423 .40912 .35466 .41386 .34824 .40329 Mtetra
.466 .674 .955 r
.34824 .40329 .35466 .41386 .37524 .41759 .36893 .40734 Mtetra
.486 .693 .96 r
.36893 .40734 .37524 .41759 .39595 .42051 .38976 .41049 Mtetra
.503 .708 .963 r
.38976 .41049 .39595 .42051 .41678 .42277 .41072 .41292 Mtetra
.516 .72 .965 r
.41072 .41292 .41678 .42277 .43773 .42449 .4318 .41478 Mtetra
.527 .73 .967 r
.4318 .41478 .43773 .42449 .45878 .42577 .45298 .41616 Mtetra
.536 .738 .968 r
.45298 .41616 .45878 .42577 .47993 .42666 .47427 .41713 Mtetra
.543 .744 .969 r
.47427 .41713 .47993 .42666 .50118 .42724 .49565 .41778 Mtetra
.549 .75 .97 r
.49565 .41778 .50118 .42724 .52252 .42755 .51714 .41813 Mtetra
.555 .754 .97 r
.51714 .41813 .52252 .42755 .54396 .42762 .53871 .41824 Mtetra
.559 .758 .971 r
.53871 .41824 .54396 .42762 .56548 .42749 .56038 .41814 Mtetra
.563 .762 .971 r
.56038 .41814 .56548 .42749 .5871 .42718 .58214 .41785 Mtetra
.566 .765 .972 r
.58214 .41785 .5871 .42718 .6088 .42671 .60399 .4174 Mtetra
.569 .767 .972 r
.60399 .4174 .6088 .42671 .63058 .42611 .62592 .41681 Mtetra
.572 .769 .972 r
.62592 .41681 .63058 .42611 .65245 .42539 .64795 .41608 Mtetra
.574 .771 .972 r
.64795 .41608 .65245 .42539 .67441 .42455 .67005 .41525 Mtetra
.576 .773 .972 r
.67005 .41525 .67441 .42455 .69645 .42362 .69225 .41431 Mtetra
.578 .775 .973 r
.69225 .41431 .69645 .42362 .71858 .42259 .71453 .41328 Mtetra
.579 .776 .973 r
.71453 .41328 .71858 .42259 .74079 .42149 .73689 .41217 Mtetra
.581 .778 .973 r
.73689 .41217 .74079 .42149 .76308 .42031 .75934 .41098 Mtetra
.582 .779 .973 r
.75934 .41098 .76308 .42031 .78545 .41906 .78188 .40972 Mtetra
.583 .78 .973 r
.78188 .40972 .78545 .41906 .80792 .41776 .8045 .40839 Mtetra
.584 .781 .973 r
.8045 .40839 .80792 .41776 .83046 .41639 .8272 .40701 Mtetra
.585 .782 .973 r
.8272 .40701 .83046 .41639 .85309 .41497 .84999 .40557 Mtetra
.586 .782 .973 r
.84999 .40557 .85309 .41497 .8758 .4135 .87287 .40409 Mtetra
.587 .783 .973 r
.87287 .40409 .8758 .4135 .8986 .41199 .89583 .40255 Mtetra
.587 .784 .973 r
.89583 .40255 .8986 .41199 .92148 .41043 .91888 .40097 Mtetra
.588 .784 .974 r
.91888 .40097 .92148 .41043 .94444 .40883 .94201 .39935 Mtetra
.589 .785 .974 r
.94201 .39935 .94444 .40883 .96749 .40719 .96523 .39769 Mtetra
.617 .786 .963 r
.22033 .34934 .22762 .35841 .24779 .35797 .24073 .34715 Mtetra
.188 .493 .903 r
.24073 .34715 .24779 .35797 .26735 .37206 .26054 .35802 Mtetra
.277 .487 .882 r
.26054 .35802 .26735 .37206 .28722 .38301 .28045 .37036 Mtetra
.337 .554 .914 r
.28045 .37036 .28722 .38301 .30736 .39151 .30065 .37975 Mtetra
.387 .604 .934 r
.30065 .37975 .30736 .39151 .32771 .39812 .3211 .38698 Mtetra
.426 .641 .946 r
.3211 .38698 .32771 .39812 .34824 .40329 .34173 .39258 Mtetra
.455 .668 .954 r
.34173 .39258 .34824 .40329 .36893 .40734 .36254 .39693 Mtetra
.479 .689 .96 r
.36254 .39693 .36893 .40734 .38976 .41049 .38349 .40032 Mtetra
.497 .705 .963 r
.38349 .40032 .38976 .41049 .41072 .41292 .40457 .40294 Mtetra
.512 .718 .965 r
.40457 .40294 .41072 .41292 .4318 .41478 .42578 .40493 Mtetra
.523 .728 .967 r
.42578 .40493 .4318 .41478 .45298 .41616 .4471 .40641 Mtetra
.533 .736 .968 r
.4471 .40641 .45298 .41616 .47427 .41713 .46852 .40747 Mtetra
.541 .743 .969 r
.46852 .40747 .47427 .41713 .49565 .41778 .49005 .40818 Mtetra
.548 .749 .97 r
.49005 .40818 .49565 .41778 .51714 .41813 .51167 .40858 Mtetra
.553 .753 .971 r
.51167 .40858 .51714 .41813 .53871 .41824 .53339 .40873 Mtetra
.558 .757 .971 r
.53339 .40873 .53871 .41824 .56038 .41814 .55521 .40865 Mtetra
.562 .761 .971 r
.55521 .40865 .56038 .41814 .58214 .41785 .57712 .40839 Mtetra
.565 .764 .972 r
.57712 .40839 .58214 .41785 .60399 .4174 .59911 .40795 Mtetra
.569 .767 .972 r
.59911 .40795 .60399 .4174 .62592 .41681 .6212 .40736 Mtetra
.571 .769 .972 r
.6212 .40736 .62592 .41681 .64795 .41608 .64337 .40665 Mtetra
.574 .771 .972 r
.64337 .40665 .64795 .41608 .67005 .41525 .66563 .40581 Mtetra
.576 .773 .972 r
.66563 .40581 .67005 .41525 .69225 .41431 .68798 .40487 Mtetra
.577 .775 .973 r
.68798 .40487 .69225 .41431 .71453 .41328 .71042 .40383 Mtetra
.579 .776 .973 r
.71042 .40383 .71453 .41328 .73689 .41217 .73294 .40271 Mtetra
.58 .777 .973 r
.73294 .40271 .73689 .41217 .75934 .41098 .75555 .40151 Mtetra
.582 .778 .973 r
.75555 .40151 .75934 .41098 .78188 .40972 .77825 .40023 Mtetra
.583 .78 .973 r
.77825 .40023 .78188 .40972 .8045 .40839 .80103 .39889 Mtetra
.584 .781 .973 r
.80103 .39889 .8045 .40839 .8272 .40701 .8239 .39749 Mtetra
.585 .781 .973 r
.8239 .39749 .8272 .40701 .84999 .40557 .84685 .39604 Mtetra
.586 .782 .973 r
.84685 .39604 .84999 .40557 .87287 .40409 .86989 .39453 Mtetra
.586 .783 .973 r
.86989 .39453 .87287 .40409 .89583 .40255 .89302 .39297 Mtetra
.587 .784 .973 r
.89302 .39297 .89583 .40255 .91888 .40097 .91624 .39137 Mtetra
.588 .784 .974 r
.91624 .39137 .91888 .40097 .94201 .39935 .93954 .38973 Mtetra
.588 .785 .974 r
.93954 .38973 .94201 .39935 .96523 .39769 .96294 .38805 Mtetra
.617 .786 .963 r
.21294 .34014 .22033 .34934 .24073 .34715 .23347 .33792 Mtetra
.333 .631 .961 r
.23347 .33792 .24073 .34715 .26054 .35802 .25365 .34381 Mtetra
.226 .452 .869 r
.25365 .34381 .26054 .35802 .28045 .37036 .27359 .35755 Mtetra
.305 .532 .908 r
.27359 .35755 .28045 .37036 .30065 .37975 .29386 .36784 Mtetra
.366 .59 .931 r
.29386 .36784 .30065 .37975 .3211 .38698 .31439 .37568 Mtetra
.411 .632 .945 r
.31439 .37568 .3211 .38698 .34173 .39258 .33514 .38171 Mtetra
.445 .662 .954 r
.33514 .38171 .34173 .39258 .36254 .39693 .35606 .38639 Mtetra
.471 .684 .959 r
.35606 .38639 .36254 .39693 .38349 .40032 .37713 .39001 Mtetra
.491 .702 .963 r
.37713 .39001 .38349 .40032 .40457 .40294 .39834 .39281 Mtetra
.507 .715 .965 r
.39834 .39281 .40457 .40294 .42578 .40493 .41968 .39494 Mtetra
.52 .726 .967 r
.41968 .39494 .42578 .40493 .4471 .40641 .44113 .39652 Mtetra
.53 .735 .968 r
.44113 .39652 .4471 .40641 .46852 .40747 .46269 .39767 Mtetra
.539 .742 .969 r
.46269 .39767 .46852 .40747 .49005 .40818 .48436 .39844 Mtetra
.546 .748 .97 r
.48436 .39844 .49005 .40818 .51167 .40858 .50613 .39889 Mtetra
.552 .753 .971 r
.50613 .39889 .51167 .40858 .53339 .40873 .528 .39908 Mtetra
.557 .757 .971 r
.528 .39908 .53339 .40873 .55521 .40865 .54996 .39903 Mtetra
.561 .76 .971 r
.54996 .39903 .55521 .40865 .57712 .40839 .57201 .39878 Mtetra
.565 .763 .972 r
.57201 .39878 .57712 .40839 .59911 .40795 .59416 .39836 Mtetra
.568 .766 .972 r
.59416 .39836 .59911 .40795 .6212 .40736 .6164 .39778 Mtetra
.57 .769 .972 r
.6164 .39778 .6212 .40736 .64337 .40665 .63873 .39707 Mtetra
.573 .771 .972 r
.63873 .39707 .64337 .40665 .66563 .40581 .66115 .39623 Mtetra
.575 .773 .972 r
.66115 .39623 .66563 .40581 .68798 .40487 .68365 .39529 Mtetra
.577 .774 .973 r
.68365 .39529 .68798 .40487 .71042 .40383 .70625 .39424 Mtetra
.579 .776 .973 r
.70625 .39424 .71042 .40383 .73294 .40271 .72893 .39311 Mtetra
.58 .777 .973 r
.72893 .39311 .73294 .40271 .75555 .40151 .7517 .39189 Mtetra
.581 .778 .973 r
.7517 .39189 .75555 .40151 .77825 .40023 .77456 .39061 Mtetra
.583 .779 .973 r
.77456 .39061 .77825 .40023 .80103 .39889 .79751 .38925 Mtetra
.584 .78 .973 r
.79751 .38925 .80103 .39889 .8239 .39749 .82054 .38783 Mtetra
.585 .781 .973 r
.82054 .38783 .8239 .39749 .84685 .39604 .84366 .38636 Mtetra
.585 .782 .973 r
.84366 .38636 .84685 .39604 .86989 .39453 .86688 .38483 Mtetra
.586 .783 .973 r
.86688 .38483 .86989 .39453 .89302 .39297 .89017 .38325 Mtetra
.587 .784 .973 r
.89017 .38325 .89302 .39297 .91624 .39137 .91356 .38163 Mtetra
.588 .784 .974 r
.91356 .38163 .91624 .39137 .93954 .38973 .93704 .37996 Mtetra
.588 .785 .974 r
.93704 .37996 .93954 .38973 .96294 .38805 .9606 .37825 Mtetra
.617 .786 .963 r
.20545 .33081 .21294 .34014 .23347 .33792 .22611 .32856 Mtetra
.527 .743 .974 r
.22611 .32856 .23347 .33792 .25365 .34381 .24668 .32942 Mtetra
.173 .415 .853 r
.24668 .32942 .25365 .34381 .27359 .35755 .26664 .34457 Mtetra
.272 .51 .9 r
.26664 .34457 .27359 .35755 .29386 .36784 .28698 .35577 Mtetra
.344 .576 .927 r
.28698 .35577 .29386 .36784 .31439 .37568 .3076 .36423 Mtetra
.396 .622 .943 r
.3076 .36423 .31439 .37568 .33514 .38171 .32845 .3707 Mtetra
.435 .655 .953 r
.32845 .3707 .33514 .38171 .35606 .38639 .34948 .37569 Mtetra
.463 .68 .959 r
.34948 .37569 .35606 .38639 .37713 .39001 .37068 .37956 Mtetra
.486 .698 .963 r
.37068 .37956 .37713 .39001 .39834 .39281 .39202 .38253 Mtetra
.503 .713 .965 r
.39202 .38253 .39834 .39281 .41968 .39494 .41349 .3848 Mtetra
.516 .724 .967 r
.41349 .3848 .41968 .39494 .44113 .39652 .43508 .3865 Mtetra
.527 .733 .969 r
.43508 .3865 .44113 .39652 .46269 .39767 .45678 .38772 Mtetra
.536 .74 .969 r
.45678 .38772 .46269 .39767 .48436 .39844 .47859 .38856 Mtetra
.544 .747 .97 r
.47859 .38856 .48436 .39844 .50613 .39889 .50051 .38906 Mtetra
.55 .752 .971 r
.50051 .38906 .50613 .39889 .528 .39908 .52252 .38928 Mtetra
.555 .756 .971 r
.52252 .38928 .528 .39908 .54996 .39903 .54463 .38926 Mtetra
.56 .76 .971 r
.54463 .38926 .54996 .39903 .57201 .39878 .56684 .38904 Mtetra
.564 .763 .972 r
.56684 .38904 .57201 .39878 .59416 .39836 .58914 .38863 Mtetra
.567 .766 .972 r
.58914 .38863 .59416 .39836 .6164 .39778 .61153 .38806 Mtetra
.57 .768 .972 r
.61153 .38806 .6164 .39778 .63873 .39707 .63402 .38735 Mtetra
.572 .77 .972 r
.63402 .38735 .63873 .39707 .66115 .39623 .65659 .38651 Mtetra
.574 .772 .972 r
.65659 .38651 .66115 .39623 .68365 .39529 .67926 .38556 Mtetra
.576 .774 .973 r
.67926 .38556 .68365 .39529 .70625 .39424 .70202 .38451 Mtetra
.578 .775 .973 r
.70202 .38451 .70625 .39424 .72893 .39311 .72486 .38336 Mtetra
.58 .777 .973 r
.72486 .38336 .72893 .39311 .7517 .39189 .7478 .38214 Mtetra
.581 .778 .973 r
.7478 .38214 .7517 .39189 .77456 .39061 .77082 .38083 Mtetra
.582 .779 .973 r
.77082 .38083 .77456 .39061 .79751 .38925 .79393 .37946 Mtetra
.583 .78 .973 r
.79393 .37946 .79751 .38925 .82054 .38783 .81714 .37803 Mtetra
.584 .781 .973 r
.81714 .37803 .82054 .38783 .84366 .38636 .84043 .37653 Mtetra
.585 .782 .973 r
.84043 .37653 .84366 .38636 .86688 .38483 .86381 .37498 Mtetra
.586 .783 .973 r
.86381 .37498 .86688 .38483 .89017 .38325 .88728 .37338 Mtetra
.587 .783 .973 r
.88728 .37338 .89017 .38325 .91356 .38163 .91084 .37173 Mtetra
.587 .784 .974 r
.91084 .37173 .91356 .38163 .93704 .37996 .93449 .37004 Mtetra
.588 .785 .974 r
.93449 .37004 .93704 .37996 .9606 .37825 .95824 .36831 Mtetra
.617 .786 .963 r
.19785 .32135 .20545 .33081 .22611 .32856 .21864 .31906 Mtetra
.21864 .31906 .22611 .32856 .24668 .32942 .23951 .31676 Mtetra
.101 .4 .854 r
.23951 .31676 .24668 .32942 .26664 .34457 .2596 .33141 Mtetra
.237 .486 .891 r
.2596 .33141 .26664 .34457 .28698 .35577 .28 .34353 Mtetra
.321 .561 .923 r
.28 .34353 .28698 .35577 .3076 .36423 .30071 .35262 Mtetra
.381 .613 .941 r
.30071 .35262 .3076 .36423 .32845 .3707 .32166 .35953 Mtetra
.424 .649 .952 r
.32166 .35953 .32845 .3707 .34948 .37569 .34281 .36485 Mtetra
.456 .675 .959 r
.34281 .36485 .34948 .37569 .37068 .37956 .36413 .36895 Mtetra
.48 .695 .963 r
.36413 .36895 .37068 .37956 .39202 .38253 .3856 .37211 Mtetra
.498 .71 .965 r
.3856 .37211 .39202 .38253 .41349 .3848 .40721 .37452 Mtetra
.513 .722 .967 r
.40721 .37452 .41349 .3848 .43508 .3865 .42894 .37632 Mtetra
.525 .731 .969 r
.42894 .37632 .43508 .3865 .45678 .38772 .45078 .37763 Mtetra
.534 .739 .97 r
.45078 .37763 .45678 .38772 .47859 .38856 .47274 .37853 Mtetra
.542 .745 .97 r
.47274 .37853 .47859 .38856 .50051 .38906 .4948 .37908 Mtetra
.549 .751 .971 r
.4948 .37908 .50051 .38906 .52252 .38928 .51696 .37935 Mtetra
.554 .755 .971 r
.51696 .37935 .52252 .38928 .54463 .38926 .53923 .37935 Mtetra
.559 .759 .972 r
.53923 .37935 .54463 .38926 .56684 .38904 .56159 .37915 Mtetra
.563 .762 .972 r
.56159 .37915 .56684 .38904 .58914 .38863 .58404 .37875 Mtetra
.566 .765 .972 r
.58404 .37875 .58914 .38863 .61153 .38806 .60659 .37819 Mtetra
.569 .768 .972 r
.60659 .37819 .61153 .38806 .63402 .38735 .62924 .37748 Mtetra
.572 .77 .972 r
.62924 .37748 .63402 .38735 .65659 .38651 .65197 .37664 Mtetra
.574 .772 .973 r
.65197 .37664 .65659 .38651 .67926 .38556 .6748 .37569 Mtetra
.576 .774 .973 r
.6748 .37569 .67926 .38556 .70202 .38451 .69772 .37463 Mtetra
.578 .775 .973 r
.69772 .37463 .70202 .38451 .72486 .38336 .72073 .37347 Mtetra
.579 .777 .973 r
.72073 .37347 .72486 .38336 .7478 .38214 .74383 .37223 Mtetra
.581 .778 .973 r
.74383 .37223 .7478 .38214 .77082 .38083 .76702 .37091 Mtetra
.582 .779 .973 r
.76702 .37091 .77082 .38083 .79393 .37946 .7903 .36952 Mtetra
.583 .78 .973 r
.7903 .36952 .79393 .37946 .81714 .37803 .81368 .36807 Mtetra
.584 .781 .973 r
.81368 .36807 .81714 .37803 .84043 .37653 .83714 .36655 Mtetra
.585 .782 .973 r
.83714 .36655 .84043 .37653 .86381 .37498 .8607 .36498 Mtetra
.586 .783 .973 r
.8607 .36498 .86381 .37498 .88728 .37338 .88434 .36336 Mtetra
.587 .783 .973 r
.88434 .36336 .88728 .37338 .91084 .37173 .90808 .36169 Mtetra
.587 .784 .974 r
.90808 .36169 .91084 .37173 .93449 .37004 .93191 .35997 Mtetra
.588 .785 .974 r
.93191 .35997 .93449 .37004 .95824 .36831 .95583 .35821 Mtetra
.617 .786 .963 r
.19013 .31175 .19785 .32135 .21864 .31906 .21107 .30943 Mtetra
.21107 .30943 .21864 .31906 .23951 .31676 .23207 .3071 Mtetra
.093 .466 .89 r
.23207 .3071 .23951 .31676 .2596 .33141 .25247 .31809 Mtetra
.202 .461 .881 r
.25247 .31809 .2596 .33141 .28 .34353 .27293 .33113 Mtetra
.298 .546 .918 r
.27293 .33113 .28 .34353 .30071 .35262 .29373 .34084 Mtetra
.366 .603 .939 r
.29373 .34084 .30071 .35262 .32166 .35953 .31479 .34821 Mtetra
.413 .642 .951 r
.31479 .34821 .32166 .35953 .34281 .36485 .33605 .35385 Mtetra
.448 .671 .958 r
.33605 .35385 .34281 .36485 .36413 .36895 .3575 .35819 Mtetra
.474 .691 .962 r
.3575 .35819 .36413 .36895 .3856 .37211 .3791 .36154 Mtetra
.494 .707 .965 r
.3791 .36154 .3856 .37211 .40721 .37452 .40084 .36409 Mtetra
.509 .72 .967 r
.40084 .36409 .40721 .37452 .42894 .37632 .42271 .366 Mtetra
.522 .73 .969 r
.42271 .366 .42894 .37632 .45078 .37763 .4447 .36739 Mtetra
.532 .738 .97 r
.4447 .36739 .45078 .37763 .47274 .37853 .4668 .36836 Mtetra
.54 .744 .97 r
.4668 .36836 .47274 .37853 .4948 .37908 .48901 .36896 Mtetra
.547 .75 .971 r
.48901 .36896 .4948 .37908 .51696 .37935 .51132 .36926 Mtetra
.553 .755 .971 r
.51132 .36926 .51696 .37935 .53923 .37935 .53374 .3693 Mtetra
.558 .758 .972 r
.53374 .3693 .53923 .37935 .56159 .37915 .55625 .36911 Mtetra
.562 .762 .972 r
.55625 .36911 .56159 .37915 .58404 .37875 .57887 .36873 Mtetra
.565 .765 .972 r
.57887 .36873 .58404 .37875 .60659 .37819 .60158 .36817 Mtetra
.568 .767 .972 r
.60158 .36817 .60659 .37819 .62924 .37748 .62438 .36746 Mtetra
.571 .77 .972 r
.62438 .36746 .62924 .37748 .65197 .37664 .64728 .36662 Mtetra
.573 .772 .973 r
.64728 .36662 .65197 .37664 .6748 .37569 .67027 .36566 Mtetra
.575 .773 .973 r
.67027 .36566 .6748 .37569 .69772 .37463 .69336 .36459 Mtetra
.577 .775 .973 r
.69336 .36459 .69772 .37463 .72073 .37347 .71653 .36343 Mtetra
.579 .776 .973 r
.71653 .36343 .72073 .37347 .74383 .37223 .7398 .36217 Mtetra
.58 .778 .973 r
.7398 .36217 .74383 .37223 .76702 .37091 .76317 .36084 Mtetra
.582 .779 .973 r
.76317 .36084 .76702 .37091 .7903 .36952 .78662 .35943 Mtetra
.583 .78 .973 r
.78662 .35943 .7903 .36952 .81368 .36807 .81017 .35796 Mtetra
.584 .781 .973 r
.81017 .35796 .81368 .36807 .83714 .36655 .83381 .35642 Mtetra
.585 .782 .973 r
.83381 .35642 .83714 .36655 .8607 .36498 .85754 .35483 Mtetra
.586 .782 .973 r
.85754 .35483 .8607 .36498 .88434 .36336 .88136 .35318 Mtetra
.586 .783 .973 r
.88136 .35318 .88434 .36336 .90808 .36169 .90528 .35149 Mtetra
.587 .784 .974 r
.90528 .35149 .90808 .36169 .93191 .35997 .92929 .34974 Mtetra
.588 .785 .974 r
.92929 .34974 .93191 .35997 .95583 .35821 .95339 .34796 Mtetra
.617 .786 .963 r
.18231 .30201 .19013 .31175 .21107 .30943 .20338 .29966 Mtetra
.20338 .29966 .21107 .30943 .23207 .3071 .22453 .29729 Mtetra
.277 .594 .949 r
.22453 .29729 .23207 .3071 .25247 .31809 .24524 .30458 Mtetra
.165 .435 .869 r
.24524 .30458 .25247 .31809 .27293 .33113 .26576 .31856 Mtetra
.275 .53 .913 r
.26576 .31856 .27293 .33113 .29373 .34084 .28665 .32891 Mtetra
.35 .593 .937 r
.28665 .32891 .29373 .34084 .31479 .34821 .30781 .33672 Mtetra
.402 .635 .95 r
.30781 .33672 .31479 .34821 .33605 .35385 .32919 .34269 Mtetra
.44 .666 .957 r
.32919 .34269 .33605 .35385 .3575 .35819 .35076 .34728 Mtetra
.468 .688 .962 r
.35076 .34728 .3575 .35819 .3791 .36154 .3725 .35081 Mtetra
.489 .705 .965 r
.3725 .35081 .3791 .36154 .40084 .36409 .39437 .3535 Mtetra
.506 .718 .967 r
.39437 .3535 .40084 .36409 .42271 .366 .41638 .35552 Mtetra
.519 .728 .969 r
.41638 .35552 .42271 .366 .4447 .36739 .43852 .357 Mtetra
.53 .736 .97 r
.43852 .357 .4447 .36739 .4668 .36836 .46077 .35803 Mtetra
.538 .743 .97 r
.46077 .35803 .4668 .36836 .48901 .36896 .48313 .35869 Mtetra
.546 .749 .971 r
.48313 .35869 .48901 .36896 .51132 .36926 .5056 .35902 Mtetra
.551 .754 .971 r
.5056 .35902 .51132 .36926 .53374 .3693 .52817 .35909 Mtetra
.557 .758 .972 r
.52817 .35909 .53374 .3693 .55625 .36911 .55084 .35892 Mtetra
.561 .761 .972 r
.55084 .35892 .55625 .36911 .57887 .36873 .57362 .35855 Mtetra
.565 .764 .972 r
.57362 .35855 .57887 .36873 .60158 .36817 .59649 .358 Mtetra
.568 .767 .972 r
.59649 .358 .60158 .36817 .62438 .36746 .61945 .35729 Mtetra
.57 .769 .972 r
.61945 .35729 .62438 .36746 .64728 .36662 .64252 .35645 Mtetra
.573 .771 .973 r
.64252 .35645 .64728 .36662 .67027 .36566 .66567 .35548 Mtetra
.575 .773 .973 r
.66567 .35548 .67027 .36566 .69336 .36459 .68893 .35441 Mtetra
.577 .775 .973 r
.68893 .35441 .69336 .36459 .71653 .36343 .71227 .35323 Mtetra
.579 .776 .973 r
.71227 .35323 .71653 .36343 .7398 .36217 .73572 .35196 Mtetra
.58 .777 .973 r
.73572 .35196 .7398 .36217 .76317 .36084 .75925 .35061 Mtetra
.581 .779 .973 r
.75925 .35061 .76317 .36084 .78662 .35943 .78288 .34919 Mtetra
.583 .78 .973 r
.78288 .34919 .78662 .35943 .81017 .35796 .8066 .34769 Mtetra
.584 .781 .973 r
.8066 .34769 .81017 .35796 .83381 .35642 .83042 .34613 Mtetra
.585 .782 .973 r
.83042 .34613 .83381 .35642 .85754 .35483 .85433 .34452 Mtetra
.85433 .34452 .85754 .35483 .88136 .35318 .87833 .34285 Mtetra
.586 .783 .973 r
.87833 .34285 .88136 .35318 .90528 .35149 .90243 .34112 Mtetra
.587 .784 .974 r
.90243 .34112 .90528 .35149 .92929 .34974 .92662 .33935 Mtetra
.588 .784 .974 r
.92662 .33935 .92929 .34974 .95339 .34796 .95091 .33754 Mtetra
.617 .786 .963 r
.17437 .29213 .18231 .30201 .20338 .29966 .19559 .28974 Mtetra
.19559 .28974 .20338 .29966 .22453 .29729 .21687 .28734 Mtetra
.433 .69 .973 r
.21687 .28734 .22453 .29729 .24524 .30458 .23791 .2909 Mtetra
.128 .408 .857 r
.23791 .2909 .24524 .30458 .26576 .31856 .2585 .30581 Mtetra
.251 .514 .907 r
.2585 .30581 .26576 .31856 .28665 .32891 .27947 .3168 Mtetra
.334 .582 .934 r
.27947 .3168 .28665 .32891 .30781 .33672 .30073 .32507 Mtetra
.391 .628 .948 r
.30073 .32507 .30781 .33672 .32919 .34269 .32224 .33137 Mtetra
.432 .661 .957 r
.32224 .33137 .32919 .34269 .35076 .34728 .34393 .33621 Mtetra
.462 .684 .962 r
.34393 .33621 .35076 .34728 .3725 .35081 .3658 .33992 Mtetra
.485 .702 .965 r
.3658 .33992 .3725 .35081 .39437 .3535 .38782 .34276 Mtetra
.502 .716 .967 r
.38782 .34276 .39437 .3535 .41638 .35552 .40997 .34489 Mtetra
.516 .727 .969 r
.40997 .34489 .41638 .35552 .43852 .357 .43225 .34646 Mtetra
.527 .735 .97 r
.43225 .34646 .43852 .357 .46077 .35803 .45465 .34755 Mtetra
.536 .742 .97 r
.45465 .34755 .46077 .35803 .48313 .35869 .47716 .34826 Mtetra
.544 .748 .971 r
.47716 .34826 .48313 .35869 .5056 .35902 .49979 .34863 Mtetra
.55 .753 .971 r
.49979 .34863 .5056 .35902 .52817 .35909 .52252 .34872 Mtetra
.555 .757 .972 r
.52252 .34872 .52817 .35909 .55084 .35892 .54535 .34857 Mtetra
.56 .761 .972 r
.54535 .34857 .55084 .35892 .57362 .35855 .56828 .34822 Mtetra
.564 .764 .972 r
.56828 .34822 .57362 .35855 .59649 .358 .59132 .34767 Mtetra
.567 .767 .972 r
.59132 .34767 .59649 .358 .61945 .35729 .61445 .34697 Mtetra
.57 .769 .972 r
.61445 .34697 .61945 .35729 .64252 .35645 .63768 .34612 Mtetra
.572 .771 .973 r
.63768 .34612 .64252 .35645 .66567 .35548 .66101 .34515 Mtetra
.575 .773 .973 r
.66101 .34515 .66567 .35548 .68893 .35441 .68443 .34406 Mtetra
.576 .774 .973 r
.68443 .34406 .68893 .35441 .71227 .35323 .70795 .34287 Mtetra
.578 .776 .973 r
.70795 .34287 .71227 .35323 .73572 .35196 .73156 .34159 Mtetra
.58 .777 .973 r
.73156 .34159 .73572 .35196 .75925 .35061 .75527 .34022 Mtetra
.581 .778 .973 r
.75527 .34022 .75925 .35061 .78288 .34919 .77908 .33878 Mtetra
.582 .779 .973 r
.77908 .33878 .78288 .34919 .8066 .34769 .80298 .33726 Mtetra
.583 .78 .973 r
.80298 .33726 .8066 .34769 .83042 .34613 .82697 .33568 Mtetra
.584 .781 .973 r
.82697 .33568 .83042 .34613 .85433 .34452 .85107 .33404 Mtetra
.585 .782 .973 r
.85107 .33404 .85433 .34452 .87833 .34285 .87525 .33235 Mtetra
.586 .783 .973 r
.87525 .33235 .87833 .34285 .90243 .34112 .89954 .3306 Mtetra
.587 .784 .974 r
.89954 .3306 .90243 .34112 .92662 .33935 .92392 .3288 Mtetra
.92392 .3288 .92662 .33935 .95091 .33754 .94839 .32696 Mtetra
.617 .786 .963 r
.16632 .28211 .17437 .29213 .19559 .28974 .18767 .27968 Mtetra
.18767 .27968 .19559 .28974 .21687 .28734 .2091 .27724 Mtetra
.557 .758 .971 r
.2091 .27724 .21687 .28734 .23791 .2909 .23049 .27702 Mtetra
.09 .381 .842 r
.23049 .27702 .23791 .2909 .2585 .30581 .25113 .29289 Mtetra
.226 .497 .9 r
.25113 .29289 .2585 .30581 .27947 .3168 .27219 .30453 Mtetra
.317 .571 .931 r
.27219 .30453 .27947 .3168 .30073 .32507 .29356 .31325 Mtetra
.38 .621 .947 r
.29356 .31325 .30073 .32507 .32224 .33137 .31518 .31989 Mtetra
.424 .656 .956 r
.31518 .31989 .32224 .33137 .34393 .33621 .337 .32498 Mtetra
.456 .681 .962 r
.337 .32498 .34393 .33621 .3658 .33992 .359 .32888 Mtetra
.48 .699 .965 r
.359 .32888 .3658 .33992 .38782 .34276 .38116 .33186 Mtetra
.499 .714 .967 r
.38116 .33186 .38782 .34276 .40997 .34489 .40346 .3341 Mtetra
.513 .725 .969 r
.40346 .3341 .40997 .34489 .43225 .34646 .42589 .33575 Mtetra
.525 .734 .97 r
.42589 .33575 .43225 .34646 .45465 .34755 .44844 .33692 Mtetra
.535 .741 .97 r
.44844 .33692 .45465 .34755 .47716 .34826 .47111 .33767 Mtetra
.542 .747 .971 r
.47111 .33767 .47716 .34826 .49979 .34863 .49389 .33808 Mtetra
.549 .752 .971 r
.49389 .33808 .49979 .34863 .52252 .34872 .51678 .3382 Mtetra
.554 .757 .972 r
.51678 .3382 .52252 .34872 .54535 .34857 .53977 .33807 Mtetra
.559 .76 .972 r
.53977 .33807 .54535 .34857 .56828 .34822 .56287 .33772 Mtetra
.563 .763 .972 r
.56287 .33772 .56828 .34822 .59132 .34767 .58607 .33719 Mtetra
.566 .766 .972 r
.58607 .33719 .59132 .34767 .61445 .34697 .60937 .33649 Mtetra
.569 .768 .973 r
.60937 .33649 .61445 .34697 .63768 .34612 .63277 .33564 Mtetra
.572 .771 .973 r
.63277 .33564 .63768 .34612 .66101 .34515 .65627 .33466 Mtetra
.574 .772 .973 r
.65627 .33466 .66101 .34515 .68443 .34406 .67986 .33356 Mtetra
.576 .774 .973 r
.67986 .33356 .68443 .34406 .70795 .34287 .70356 .33236 Mtetra
.578 .776 .973 r
.70356 .33236 .70795 .34287 .73156 .34159 .72735 .33106 Mtetra
.579 .777 .973 r
.72735 .33106 .73156 .34159 .75527 .34022 .75123 .32967 Mtetra
.581 .778 .973 r
.75123 .32967 .75527 .34022 .77908 .33878 .77522 .32821 Mtetra
.582 .779 .973 r
.77522 .32821 .77908 .33878 .80298 .33726 .7993 .32667 Mtetra
.583 .78 .973 r
.7993 .32667 .80298 .33726 .82697 .33568 .82348 .32507 Mtetra
.584 .781 .973 r
.82348 .32507 .82697 .33568 .85107 .33404 .84775 .3234 Mtetra
.585 .782 .973 r
.84775 .3234 .85107 .33404 .87525 .33235 .87213 .32168 Mtetra
.586 .783 .973 r
.87213 .32168 .87525 .33235 .89954 .3306 .8966 .3199 Mtetra
.587 .784 .974 r
.8966 .3199 .89954 .3306 .92392 .3288 .92117 .31808 Mtetra
.92117 .31808 .92392 .3288 .94839 .32696 .94583 .3162 Mtetra
.617 .786 .963 r
.15814 .27193 .16632 .28211 .18767 .27968 .17964 .26947 Mtetra
.17964 .26947 .18767 .27968 .2091 .27724 .20122 .26699 Mtetra
.20122 .26699 .2091 .27724 .23049 .27702 .22287 .26451 Mtetra
.036 .371 .839 r
.22287 .26451 .23049 .27702 .25113 .29289 .24366 .27979 Mtetra
.201 .479 .893 r
.24366 .27979 .25113 .29289 .27219 .30453 .2648 .29208 Mtetra
.301 .56 .927 r
.2648 .29208 .27219 .30453 .29356 .31325 .28628 .30126 Mtetra
.368 .614 .945 r
.28628 .30126 .29356 .31325 .31518 .31989 .30801 .30824 Mtetra
.416 .651 .955 r
.30801 .30824 .31518 .31989 .337 .32498 .32997 .31357 Mtetra
.45 .677 .961 r
.32997 .31357 .337 .32498 .359 .32888 .3521 .31767 Mtetra
.476 .697 .965 r
.3521 .31767 .359 .32888 .38116 .33186 .3744 .32079 Mtetra
.495 .712 .967 r
.3744 .32079 .38116 .33186 .40346 .3341 .39685 .32315 Mtetra
.511 .723 .969 r
.39685 .32315 .40346 .3341 .42589 .33575 .41943 .32489 Mtetra
.523 .732 .97 r
.41943 .32489 .42589 .33575 .44844 .33692 .44213 .32612 Mtetra
.533 .74 .971 r
.44213 .32612 .44844 .33692 .47111 .33767 .46496 .32692 Mtetra
.541 .746 .971 r
.46496 .32692 .47111 .33767 .49389 .33808 .4879 .32737 Mtetra
.548 .751 .971 r
.4879 .32737 .49389 .33808 .51678 .3382 .51095 .32752 Mtetra
.553 .756 .972 r
.51095 .32752 .51678 .3382 .53977 .33807 .53411 .32741 Mtetra
.558 .76 .972 r
.53411 .32741 .53977 .33807 .56287 .33772 .55737 .32707 Mtetra
.562 .763 .972 r
.55737 .32707 .56287 .33772 .58607 .33719 .58074 .32654 Mtetra
.566 .766 .972 r
.58074 .32654 .58607 .33719 .60937 .33649 .60421 .32584 Mtetra
.569 .768 .973 r
.60421 .32584 .60937 .33649 .63277 .33564 .62778 .32499 Mtetra
.571 .77 .973 r
.62778 .32499 .63277 .33564 .65627 .33466 .65145 .324 Mtetra
.574 .772 .973 r
.65145 .324 .65627 .33466 .67986 .33356 .67522 .32289 Mtetra
.576 .774 .973 r
.67522 .32289 .67986 .33356 .70356 .33236 .69909 .32167 Mtetra
.577 .775 .973 r
.69909 .32167 .70356 .33236 .72735 .33106 .72306 .32036 Mtetra
.579 .777 .973 r
.72306 .32036 .72735 .33106 .75123 .32967 .74713 .31895 Mtetra
.58 .778 .973 r
.74713 .31895 .75123 .32967 .77522 .32821 .7713 .31747 Mtetra
.582 .779 .973 r
.7713 .31747 .77522 .32821 .7993 .32667 .79556 .31591 Mtetra
.583 .78 .973 r
.79556 .31591 .7993 .32667 .82348 .32507 .81993 .31428 Mtetra
.584 .781 .973 r
.81993 .31428 .82348 .32507 .84775 .3234 .84439 .31259 Mtetra
.585 .782 .973 r
.84439 .31259 .84775 .3234 .87213 .32168 .86895 .31084 Mtetra
.586 .783 .974 r
.86895 .31084 .87213 .32168 .8966 .3199 .89361 .30904 Mtetra
.89361 .30904 .8966 .3199 .92117 .31808 .91837 .30718 Mtetra
.587 .784 .974 r
.91837 .30718 .92117 .31808 .94583 .3162 .94323 .30528 Mtetra
.617 .786 .963 r
.14985 .2616 .15814 .27193 .17964 .26947 .17149 .2591 Mtetra
.17149 .2591 .17964 .26947 .20122 .26699 .19322 .25659 Mtetra
.19322 .25659 .20122 .26699 .22287 .26451 .21502 .25407 Mtetra
.042 .425 .867 r
.21502 .25407 .22287 .26451 .24366 .27979 .23608 .2665 Mtetra
.176 .461 .885 r
.23608 .2665 .24366 .27979 .2648 .29208 .25731 .27944 Mtetra
.284 .549 .923 r
.25731 .27944 .2648 .29208 .28628 .30126 .27889 .2891 Mtetra
.356 .606 .943 r
.27889 .2891 .28628 .30126 .30801 .30824 .30074 .29641 Mtetra
.407 .645 .954 r
.30074 .29641 .30801 .30824 .32997 .31357 .32283 .302 Mtetra
.444 .673 .961 r
.32283 .302 .32997 .31357 .3521 .31767 .3451 .30629 Mtetra
.471 .694 .965 r
.3451 .30629 .3521 .31767 .3744 .32079 .36754 .30956 Mtetra
.492 .709 .967 r
.36754 .30956 .3744 .32079 .39685 .32315 .39014 .31203 Mtetra
.508 .722 .969 r
.39014 .31203 .39685 .32315 .41943 .32489 .41287 .31386 Mtetra
.521 .731 .97 r
.41287 .31386 .41943 .32489 .44213 .32612 .43573 .31515 Mtetra
.531 .739 .971 r
.43573 .31515 .44213 .32612 .46496 .32692 .45871 .31601 Mtetra
.539 .745 .971 r
.45871 .31601 .46496 .32692 .4879 .32737 .48181 .31649 Mtetra
.546 .751 .972 r
.48181 .31649 .4879 .32737 .51095 .32752 .50503 .31667 Mtetra
.552 .755 .972 r
.50503 .31667 .51095 .32752 .53411 .32741 .52835 .31658 Mtetra
.557 .759 .972 r
.52835 .31658 .53411 .32741 .55737 .32707 .55179 .31625 Mtetra
.561 .762 .972 r
.55179 .31625 .55737 .32707 .58074 .32654 .57532 .31573 Mtetra
.565 .765 .972 r
.57532 .31573 .58074 .32654 .60421 .32584 .59897 .31502 Mtetra
.568 .768 .973 r
.59897 .31502 .60421 .32584 .62778 .32499 .62271 .31417 Mtetra
.571 .77 .973 r
.62271 .31417 .62778 .32499 .65145 .324 .64656 .31317 Mtetra
.573 .772 .973 r
.64656 .31317 .65145 .324 .67522 .32289 .67051 .31205 Mtetra
.575 .774 .973 r
.67051 .31205 .67522 .32289 .69909 .32167 .69456 .31082 Mtetra
.577 .775 .973 r
.69456 .31082 .69909 .32167 .72306 .32036 .71871 .30949 Mtetra
.579 .777 .973 r
.71871 .30949 .72306 .32036 .74713 .31895 .74296 .30807 Mtetra
.58 .778 .973 r
.74296 .30807 .74713 .31895 .7713 .31747 .76731 .30656 Mtetra
.581 .779 .973 r
.76731 .30656 .7713 .31747 .79556 .31591 .79177 .30498 Mtetra
.583 .78 .973 r
.79177 .30498 .79556 .31591 .81993 .31428 .81632 .30332 Mtetra
.584 .781 .973 r
.81632 .30332 .81993 .31428 .84439 .31259 .84097 .30161 Mtetra
.585 .782 .973 r
.84097 .30161 .84439 .31259 .86895 .31084 .86572 .29983 Mtetra
.586 .783 .974 r
.86572 .29983 .86895 .31084 .89361 .30904 .89058 .298 Mtetra
.89058 .298 .89361 .30904 .91837 .30718 .91553 .29611 Mtetra
.587 .784 .974 r
.91553 .29611 .91837 .30718 .94323 .30528 .94059 .29418 Mtetra
.617 .786 .963 r
.14142 .25112 .14985 .2616 .17149 .2591 .16322 .24858 Mtetra
.16322 .24858 .17149 .2591 .19322 .25659 .18509 .24603 Mtetra
.18509 .24603 .19322 .25659 .21502 .25407 .20704 .24347 Mtetra
.184 .529 .922 r
.20704 .24347 .21502 .25407 .23608 .2665 .2284 .25302 Mtetra
.15 .442 .876 r
.2284 .25302 .23608 .2665 .25731 .27944 .24971 .26663 Mtetra
.266 .537 .919 r
.24971 .26663 .25731 .27944 .27889 .2891 .27139 .27676 Mtetra
.345 .598 .941 r
.27139 .27676 .27889 .2891 .30074 .29641 .29337 .28441 Mtetra
.399 .64 .953 r
.29337 .28441 .30074 .29641 .32283 .302 .31558 .29026 Mtetra
.438 .669 .96 r
.31558 .29026 .32283 .302 .3451 .30629 .33799 .29474 Mtetra
.466 .691 .964 r
.33799 .29474 .3451 .30629 .36754 .30956 .36058 .29816 Mtetra
.488 .707 .967 r
.36058 .29816 .36754 .30956 .39014 .31203 .38332 .30074 Mtetra
.505 .72 .969 r
.38332 .30074 .39014 .31203 .41287 .31386 .40621 .30265 Mtetra
.518 .73 .97 r
.40621 .30265 .41287 .31386 .43573 .31515 .42923 .30402 Mtetra
.529 .738 .971 r
.42923 .30402 .43573 .31515 .45871 .31601 .45237 .30492 Mtetra
.538 .744 .971 r
.45237 .30492 .45871 .31601 .48181 .31649 .47564 .30545 Mtetra
.545 .75 .972 r
.47564 .30545 .48181 .31649 .50503 .31667 .49902 .30565 Mtetra
.551 .755 .972 r
.49902 .30565 .50503 .31667 .52835 .31658 .52251 .30557 Mtetra
.556 .759 .972 r
.52251 .30557 .52835 .31658 .55179 .31625 .54611 .30526 Mtetra
.56 .762 .972 r
.54611 .30526 .55179 .31625 .57532 .31573 .56983 .30474 Mtetra
.564 .765 .972 r
.56983 .30474 .57532 .31573 .59897 .31502 .59364 .30404 Mtetra
.567 .767 .973 r
.59364 .30404 .59897 .31502 .62271 .31417 .61757 .30318 Mtetra
.57 .77 .973 r
.61757 .30318 .62271 .31417 .64656 .31317 .64159 .30217 Mtetra
.573 .772 .973 r
.64159 .30217 .64656 .31317 .67051 .31205 .66572 .30104 Mtetra
.575 .773 .973 r
.66572 .30104 .67051 .31205 .69456 .31082 .68995 .29979 Mtetra
.577 .775 .973 r
.68995 .29979 .69456 .31082 .71871 .30949 .71429 .29844 Mtetra
.578 .776 .973 r
.71429 .29844 .71871 .30949 .74296 .30807 .73873 .297 Mtetra
.58 .778 .973 r
.73873 .297 .74296 .30807 .76731 .30656 .76327 .29547 Mtetra
.581 .779 .973 r
.76327 .29547 .76731 .30656 .79177 .30498 .78791 .29387 Mtetra
.582 .78 .973 r
.78791 .29387 .79177 .30498 .81632 .30332 .81265 .29219 Mtetra
.584 .781 .973 r
.81265 .29219 .81632 .30332 .84097 .30161 .83749 .29044 Mtetra
.584 .782 .973 r
.83749 .29044 .84097 .30161 .86572 .29983 .86244 .28864 Mtetra
.585 .782 .974 r
.86244 .28864 .86572 .29983 .89058 .298 .88749 .28678 Mtetra
.586 .783 .974 r
.88749 .28678 .89058 .298 .91553 .29611 .91265 .28486 Mtetra
.587 .784 .974 r
.91265 .28486 .91553 .29611 .94059 .29418 .9379 .28289 Mtetra
.617 .786 .963 r
.13287 .24047 .14142 .25112 .16322 .24858 .15482 .2379 Mtetra
.15482 .2379 .16322 .24858 .18509 .24603 .17684 .23531 Mtetra
.17684 .23531 .18509 .24603 .20704 .24347 .19895 .23271 Mtetra
.315 .617 .956 r
.19895 .23271 .20704 .24347 .2284 .25302 .2206 .23935 Mtetra
.124 .423 .867 r
.2206 .23935 .2284 .25302 .24971 .26663 .24199 .25363 Mtetra
.249 .525 .915 r
.24199 .25363 .24971 .26663 .27139 .27676 .26378 .26423 Mtetra
.333 .591 .939 r
.26378 .26423 .27139 .27676 .29337 .28441 .28588 .27223 Mtetra
.39 .635 .952 r
.28588 .27223 .29337 .28441 .31558 .29026 .30822 .27834 Mtetra
.431 .666 .96 r
.30822 .27834 .31558 .29026 .33799 .29474 .33078 .28301 Mtetra
.461 .688 .964 r
.33078 .28301 .33799 .29474 .36058 .29816 .35351 .28658 Mtetra
.484 .705 .967 r
.35351 .28658 .36058 .29816 .38332 .30074 .3764 .28928 Mtetra
.502 .718 .969 r
.3764 .28928 .38332 .30074 .40621 .30265 .39944 .29128 Mtetra
.516 .728 .97 r
.39944 .29128 .40621 .30265 .42923 .30402 .42262 .29271 Mtetra
.527 .737 .971 r
.42262 .29271 .42923 .30402 .45237 .30492 .44593 .29366 Mtetra
.536 .744 .971 r
.44593 .29366 .45237 .30492 .47564 .30545 .46936 .29423 Mtetra
.544 .749 .972 r
.46936 .29423 .47564 .30545 .49902 .30565 .49291 .29446 Mtetra
.55 .754 .972 r
.49291 .29446 .49902 .30565 .52251 .30557 .51658 .2944 Mtetra
.555 .758 .972 r
.51658 .2944 .52251 .30557 .54611 .30526 .54035 .2941 Mtetra
.56 .761 .972 r
.54035 .2941 .54611 .30526 .56983 .30474 .56424 .29358 Mtetra
.563 .764 .973 r
.56424 .29358 .56983 .30474 .59364 .30404 .58823 .29288 Mtetra
.567 .767 .973 r
.58823 .29288 .59364 .30404 .61757 .30318 .61234 .29201 Mtetra
.57 .769 .973 r
.61234 .29201 .61757 .30318 .64159 .30217 .63654 .291 Mtetra
.572 .771 .973 r
.63654 .291 .64159 .30217 .66572 .30104 .66086 .28985 Mtetra
.574 .773 .973 r
.66086 .28985 .66572 .30104 .68995 .29979 .68527 .28859 Mtetra
.576 .775 .973 r
.68527 .28859 .68995 .29979 .71429 .29844 .7098 .28722 Mtetra
.578 .776 .973 r
.7098 .28722 .71429 .29844 .73873 .297 .73442 .28576 Mtetra
.58 .777 .973 r
.73442 .28576 .73873 .297 .76327 .29547 .75915 .28421 Mtetra
.581 .779 .973 r
.75915 .28421 .76327 .29547 .78791 .29387 .78399 .28258 Mtetra
.582 .78 .973 r
.78399 .28258 .78791 .29387 .81265 .29219 .80892 .28087 Mtetra
.583 .781 .973 r
.80892 .28087 .81265 .29219 .83749 .29044 .83396 .2791 Mtetra
.584 .782 .973 r
.83396 .2791 .83749 .29044 .86244 .28864 .85911 .27726 Mtetra
.585 .782 .974 r
.85911 .27726 .86244 .28864 .88749 .28678 .88436 .27537 Mtetra
.586 .783 .974 r
.88436 .27537 .88749 .28678 .91265 .28486 .90971 .27342 Mtetra
.587 .784 .974 r
.90971 .27342 .91265 .28486 .9379 .28289 .93517 .27142 Mtetra
.617 .786 .963 r
.12419 .22967 .13287 .24047 .15482 .2379 .14629 .22705 Mtetra
.14629 .22705 .15482 .2379 .17684 .23531 .16847 .22442 Mtetra
.16847 .22442 .17684 .23531 .19895 .23271 .19073 .22178 Mtetra
.43 .687 .972 r
.19073 .22178 .19895 .23271 .2206 .23935 .21269 .22548 Mtetra
.097 .404 .857 r
.21269 .22548 .2206 .23935 .24199 .25363 .23417 .24044 Mtetra
.231 .513 .91 r
.23417 .24044 .24199 .25363 .26378 .26423 .25606 .25152 Mtetra
.32 .583 .937 r
.25606 .25152 .26378 .26423 .28588 .27223 .27828 .25987 Mtetra
.382 .629 .951 r
.27828 .25987 .28588 .27223 .30822 .27834 .30076 .26624 Mtetra
.425 .662 .959 r
.30076 .26624 .30822 .27834 .33078 .28301 .32345 .27111 Mtetra
.457 .685 .964 r
.32345 .27111 .33078 .28301 .35351 .28658 .34633 .27483 Mtetra
.481 .703 .967 r
.34633 .27483 .35351 .28658 .3764 .28928 .36938 .27764 Mtetra
.499 .716 .969 r
.36938 .27764 .3764 .28928 .39944 .29128 .39258 .27973 Mtetra
.514 .727 .97 r
.39258 .27973 .39944 .29128 .42262 .29271 .41592 .28122 Mtetra
.525 .736 .971 r
.41592 .28122 .42262 .29271 .44593 .29366 .43939 .28223 Mtetra
.535 .743 .971 r
.43939 .28223 .44593 .29366 .46936 .29423 .46299 .28283 Mtetra
.542 .748 .972 r
.46299 .28283 .46936 .29423 .49291 .29446 .48671 .28308 Mtetra
.549 .753 .972 r
.48671 .28308 .49291 .29446 .51658 .2944 .51055 .28305 Mtetra
.554 .757 .972 r
.51055 .28305 .51658 .2944 .54035 .2941 .5345 .28275 Mtetra
.559 .761 .972 r
.5345 .28275 .54035 .2941 .56424 .29358 .55856 .28224 Mtetra
.563 .764 .973 r
.55856 .28224 .56424 .29358 .58823 .29288 .58274 .28154 Mtetra
.566 .767 .973 r
.58274 .28154 .58823 .29288 .61234 .29201 .60702 .28066 Mtetra
.569 .769 .973 r
.60702 .28066 .61234 .29201 .63654 .291 .63141 .27964 Mtetra
.572 .771 .973 r
.63141 .27964 .63654 .291 .66086 .28985 .65591 .27848 Mtetra
.574 .773 .973 r
.65591 .27848 .66086 .28985 .68527 .28859 .68052 .2772 Mtetra
.576 .774 .973 r
.68052 .2772 .68527 .28859 .7098 .28722 .70523 .27582 Mtetra
.578 .776 .973 r
.70523 .27582 .7098 .28722 .73442 .28576 .73005 .27433 Mtetra
.579 .777 .973 r
.73005 .27433 .73442 .28576 .75915 .28421 .75497 .27276 Mtetra
.581 .778 .973 r
.75497 .27276 .75915 .28421 .78399 .28258 .78 .2711 Mtetra
.582 .78 .973 r
.78 .2711 .78399 .28258 .80892 .28087 .80513 .26937 Mtetra
.583 .781 .973 r
.80513 .26937 .80892 .28087 .83396 .2791 .83037 .26757 Mtetra
.584 .781 .973 r
.83037 .26757 .83396 .2791 .85911 .27726 .85572 .2657 Mtetra
.585 .782 .974 r
.85572 .2657 .85911 .27726 .88436 .27537 .88117 .26378 Mtetra
.586 .783 .974 r
.88117 .26378 .88436 .27537 .90971 .27342 .90673 .2618 Mtetra
.587 .784 .974 r
.90673 .2618 .90971 .27342 .93517 .27142 .93239 .25976 Mtetra
.617 .786 .963 r
.11538 .21869 .12419 .22967 .14629 .22705 .13763 .21604 Mtetra
.13763 .21604 .14629 .22705 .16847 .22442 .15996 .21337 Mtetra
.15996 .21337 .16847 .22442 .19073 .22178 .18238 .21069 Mtetra
.526 .741 .973 r
.18238 .21069 .19073 .22178 .21269 .22548 .20467 .21141 Mtetra
.071 .384 .846 r
.20467 .21141 .21269 .22548 .23417 .24044 .22623 .22705 Mtetra
.213 .5 .905 r
.22623 .22705 .23417 .24044 .25606 .25152 .24823 .23861 Mtetra
.308 .574 .934 r
.24823 .23861 .25606 .25152 .27828 .25987 .27056 .24732 Mtetra
.373 .624 .95 r
.27056 .24732 .27828 .25987 .30076 .26624 .29317 .25395 Mtetra
.419 .658 .959 r
.29317 .25395 .30076 .26624 .32345 .27111 .31601 .25901 Mtetra
.452 .682 .964 r
.31601 .25901 .32345 .27111 .34633 .27483 .33904 .26289 Mtetra
.477 .701 .967 r
.33904 .26289 .34633 .27483 .36938 .27764 .36224 .26581 Mtetra
.496 .715 .969 r
.36224 .26581 .36938 .27764 .39258 .27973 .3856 .26799 Mtetra
.511 .726 .97 r
.3856 .26799 .39258 .27973 .41592 .28122 .4091 .26955 Mtetra
.523 .734 .971 r
.4091 .26955 .41592 .28122 .43939 .28223 .43274 .27061 Mtetra
.533 .742 .971 r
.43274 .27061 .43939 .28223 .46299 .28283 .45651 .27125 Mtetra
.541 .748 .972 r
.45651 .27125 .46299 .28283 .48671 .28308 .48041 .27153 Mtetra
.548 .753 .972 r
.48041 .27153 .48671 .28308 .51055 .28305 .50442 .27151 Mtetra
.553 .757 .972 r
.50442 .27151 .51055 .28305 .5345 .28275 .52855 .27123 Mtetra
.558 .76 .972 r
.52855 .27123 .5345 .28275 .55856 .28224 .55279 .27072 Mtetra
.562 .764 .973 r
.55279 .27072 .55856 .28224 .58274 .28154 .57715 .27001 Mtetra
.566 .766 .973 r
.57715 .27001 .58274 .28154 .60702 .28066 .60162 .26913 Mtetra
.569 .769 .973 r
.60162 .26913 .60702 .28066 .63141 .27964 .6262 .2681 Mtetra
.571 .771 .973 r
.6262 .2681 .63141 .27964 .65591 .27848 .65089 .26693 Mtetra
.574 .773 .973 r
.65089 .26693 .65591 .27848 .68052 .2772 .67568 .26563 Mtetra
.576 .774 .973 r
.67568 .26563 .68052 .2772 .70523 .27582 .70059 .26422 Mtetra
.577 .776 .973 r
.70059 .26422 .70523 .27582 .73005 .27433 .7256 .26272 Mtetra
.579 .777 .973 r
.7256 .26272 .73005 .27433 .75497 .27276 .75072 .26112 Mtetra
.58 .778 .973 r
.75072 .26112 .75497 .27276 .78 .2711 .77595 .25943 Mtetra
.582 .779 .973 r
.77595 .25943 .78 .2711 .80513 .26937 .80128 .25767 Mtetra
.583 .78 .973 r
.80128 .25767 .80513 .26937 .83037 .26757 .82672 .25584 Mtetra
.584 .781 .973 r
.82672 .25584 .83037 .26757 .85572 .2657 .85227 .25395 Mtetra
.585 .782 .974 r
.85227 .25395 .85572 .2657 .88117 .26378 .87793 .25199 Mtetra
.586 .783 .974 r
.87793 .25199 .88117 .26378 .90673 .2618 .9037 .24997 Mtetra
.586 .784 .974 r
.9037 .24997 .90673 .2618 .93239 .25976 .92957 .24791 Mtetra
.617 .786 .963 r
.10642 .20755 .11538 .21869 .13763 .21604 .12883 .20485 Mtetra
.12883 .20485 .13763 .21604 .15996 .21337 .15132 .20214 Mtetra
.15132 .20214 .15996 .21337 .18238 .21069 .1739 .19942 Mtetra
.606 .781 .965 r
.1739 .19942 .18238 .21069 .20467 .21141 .19653 .19714 Mtetra
.044 .364 .834 r
.19653 .19714 .20467 .21141 .22623 .22705 .21817 .21346 Mtetra
.195 .487 .899 r
.21817 .21346 .22623 .22705 .24823 .23861 .24027 .22551 Mtetra
.296 .566 .932 r
.24027 .22551 .24823 .23861 .27056 .24732 .26273 .23457 Mtetra
.364 .618 .949 r
.26273 .23457 .27056 .24732 .29317 .25395 .28547 .24147 Mtetra
.412 .654 .958 r
.28547 .24147 .29317 .25395 .31601 .25901 .30845 .24674 Mtetra
.447 .679 .963 r
.30845 .24674 .31601 .25901 .33904 .26289 .33163 .25076 Mtetra
.473 .698 .967 r
.33163 .25076 .33904 .26289 .36224 .26581 .35499 .2538 Mtetra
.493 .713 .969 r
.35499 .2538 .36224 .26581 .3856 .26799 .37851 .25607 Mtetra
.509 .724 .97 r
.37851 .25607 .3856 .26799 .4091 .26955 .40218 .2577 Mtetra
.521 .733 .971 r
.40218 .2577 .4091 .26955 .43274 .27061 .42599 .25881 Mtetra
.531 .741 .971 r
.42599 .25881 .43274 .27061 .45651 .27125 .44993 .25948 Mtetra
.54 .747 .972 r
.44993 .25948 .45651 .27125 .48041 .27153 .474 .25979 Mtetra
.547 .752 .972 r
.474 .25979 .48041 .27153 .50442 .27151 .49819 .25979 Mtetra
.552 .756 .972 r
.49819 .25979 .50442 .27151 .52855 .27123 .5225 .25952 Mtetra
.557 .76 .972 r
.5225 .25952 .52855 .27123 .55279 .27072 .54693 .25901 Mtetra
.561 .763 .973 r
.54693 .25901 .55279 .27072 .57715 .27001 .57148 .2583 Mtetra
.565 .766 .973 r
.57148 .2583 .57715 .27001 .60162 .26913 .59613 .25741 Mtetra
.568 .768 .973 r
.59613 .25741 .60162 .26913 .6262 .2681 .6209 .25637 Mtetra
.571 .77 .973 r
.6209 .25637 .6262 .2681 .65089 .26693 .64578 .25518 Mtetra
.573 .772 .973 r
.64578 .25518 .65089 .26693 .67568 .26563 .67077 .25387 Mtetra
.575 .774 .973 r
.67077 .25387 .67568 .26563 .70059 .26422 .69587 .25244 Mtetra
.577 .776 .973 r
.69587 .25244 .70059 .26422 .7256 .26272 .72108 .25091 Mtetra
.579 .777 .973 r
.72108 .25091 .7256 .26272 .75072 .26112 .7464 .24928 Mtetra
.58 .778 .973 r
.7464 .24928 .75072 .26112 .77595 .25943 .77183 .24757 Mtetra
.581 .779 .973 r
.77183 .24757 .77595 .25943 .80128 .25767 .79737 .24578 Mtetra
.583 .78 .973 r
.79737 .24578 .80128 .25767 .82672 .25584 .82301 .24392 Mtetra
.584 .781 .973 r
.82301 .24392 .82672 .25584 .85227 .25395 .84877 .24199 Mtetra
.585 .782 .974 r
.84877 .24199 .85227 .25395 .87793 .25199 .87464 .24 Mtetra
.586 .783 .974 r
.87464 .24 .87793 .25199 .9037 .24997 .90061 .23795 Mtetra
.90061 .23795 .9037 .24997 .92957 .24791 .9267 .23585 Mtetra
.617 .786 .963 r
.09733 .19623 .10642 .20755 .12883 .20485 .1199 .19349 Mtetra
.1199 .19349 .12883 .20485 .15132 .20214 .14255 .19074 Mtetra
.14255 .19074 .15132 .20214 .1739 .19942 .16529 .18797 Mtetra
.16529 .18797 .1739 .19942 .19653 .19714 .18811 .1852 Mtetra
0 .377 .84 r
.18811 .1852 .19653 .19714 .21817 .21346 .20999 .19967 Mtetra
.177 .474 .893 r
.20999 .19967 .21817 .21346 .24027 .22551 .23219 .21221 Mtetra
.283 .557 .929 r
.23219 .21221 .24027 .22551 .26273 .23457 .25478 .22163 Mtetra
.355 .612 .947 r
.25478 .22163 .26273 .23457 .28547 .24147 .27765 .22879 Mtetra
.406 .65 .957 r
.27765 .22879 .28547 .24147 .30845 .24674 .30078 .23426 Mtetra
.442 .676 .963 r
.30078 .23426 .30845 .24674 .33163 .25076 .32411 .23844 Mtetra
.469 .696 .966 r
.32411 .23844 .33163 .25076 .35499 .2538 .34763 .2416 Mtetra
.49 .711 .969 r
.34763 .2416 .35499 .2538 .37851 .25607 .37131 .24396 Mtetra
.506 .723 .97 r
.37131 .24396 .37851 .25607 .40218 .2577 .39515 .24566 Mtetra
.519 .732 .971 r
.39515 .24566 .40218 .2577 .42599 .25881 .41913 .24682 Mtetra
.53 .74 .971 r
.41913 .24682 .42599 .25881 .44993 .25948 .44325 .24753 Mtetra
.538 .746 .972 r
.44325 .24753 .44993 .25948 .474 .25979 .46749 .24786 Mtetra
.545 .751 .972 r
.46749 .24786 .474 .25979 .49819 .25979 .49187 .24787 Mtetra
.551 .756 .972 r
.49187 .24787 .49819 .25979 .5225 .25952 .51636 .24761 Mtetra
.556 .759 .973 r
.51636 .24761 .5225 .25952 .54693 .25901 .54097 .24711 Mtetra
.561 .763 .973 r
.54097 .24711 .54693 .25901 .57148 .2583 .56571 .2464 Mtetra
.564 .766 .973 r
.56571 .2464 .57148 .2583 .59613 .25741 .59055 .2455 Mtetra
.568 .768 .973 r
.59055 .2455 .59613 .25741 .6209 .25637 .61551 .24444 Mtetra
.57 .77 .973 r
.61551 .24444 .6209 .25637 .64578 .25518 .64059 .24324 Mtetra
.573 .772 .973 r
.64059 .24324 .64578 .25518 .67077 .25387 .66577 .24191 Mtetra
.575 .774 .973 r
.66577 .24191 .67077 .25387 .69587 .25244 .69107 .24046 Mtetra
.577 .775 .973 r
.69107 .24046 .69587 .25244 .72108 .25091 .71648 .2389 Mtetra
.578 .777 .973 r
.71648 .2389 .72108 .25091 .7464 .24928 .74201 .23725 Mtetra
.58 .778 .973 r
.74201 .23725 .7464 .24928 .77183 .24757 .76764 .23551 Mtetra
.581 .779 .973 r
.76764 .23551 .77183 .24757 .79737 .24578 .79338 .23369 Mtetra
.582 .78 .973 r
.79338 .23369 .79737 .24578 .82301 .24392 .81924 .2318 Mtetra
.583 .781 .974 r
.81924 .2318 .82301 .24392 .84877 .24199 .84521 .22984 Mtetra
.584 .782 .974 r
.84521 .22984 .84877 .24199 .87464 .24 .87129 .22781 Mtetra
.585 .783 .974 r
.87129 .22781 .87464 .24 .90061 .23795 .89748 .22572 Mtetra
.586 .783 .974 r
.89748 .22572 .90061 .23795 .9267 .23585 .92378 .22358 Mtetra
.617 .786 .963 r
.0881 .18473 .09733 .19623 .1199 .19349 .11082 .18195 Mtetra
.11082 .18195 .1199 .19349 .14255 .19074 .13364 .17915 Mtetra
.13364 .17915 .14255 .19074 .16529 .18797 .15654 .17634 Mtetra
.15654 .17634 .16529 .18797 .18811 .1852 .17953 .17353 Mtetra
.081 .452 .883 r
.17953 .17353 .18811 .1852 .20999 .19967 .20168 .18567 Mtetra
.158 .461 .887 r
.20168 .18567 .20999 .19967 .23219 .21221 .22399 .19871 Mtetra
.27 .549 .926 r
.22399 .19871 .23219 .21221 .25478 .22163 .2467 .20849 Mtetra
.346 .606 .946 r
.2467 .20849 .25478 .22163 .27765 .22879 .26971 .21592 Mtetra
.399 .645 .956 r
.26971 .21592 .27765 .22879 .30078 .23426 .29298 .22159 Mtetra
.437 .673 .963 r
.29298 .22159 .30078 .23426 .32411 .23844 .31647 .22592 Mtetra
.466 .694 .966 r
.31647 .22592 .32411 .23844 .34763 .2416 .34014 .2292 Mtetra
.487 .709 .968 r
.34014 .2292 .34763 .2416 .37131 .24396 .36399 .23165 Mtetra
.504 .721 .97 r
.36399 .23165 .37131 .24396 .39515 .24566 .388 .23342 Mtetra
.517 .731 .971 r
.388 .23342 .39515 .24566 .41913 .24682 .41216 .23463 Mtetra
.528 .739 .971 r
.41216 .23463 .41913 .24682 .44325 .24753 .43645 .23538 Mtetra
.537 .745 .972 r
.43645 .23538 .44325 .24753 .46749 .24786 .46088 .23574 Mtetra
.544 .751 .972 r
.46088 .23574 .46749 .24786 .49187 .24787 .48543 .23577 Mtetra
.55 .755 .972 r
.48543 .23577 .49187 .24787 .51636 .24761 .51011 .23551 Mtetra
.556 .759 .973 r
.51011 .23551 .51636 .24761 .54097 .24711 .53492 .23501 Mtetra
.56 .762 .973 r
.53492 .23501 .54097 .24711 .56571 .2464 .55984 .23429 Mtetra
.564 .765 .973 r
.55984 .23429 .56571 .2464 .59055 .2455 .58488 .23339 Mtetra
.567 .768 .973 r
.58488 .23339 .59055 .2455 .61551 .24444 .61004 .23232 Mtetra
.57 .77 .973 r
.61004 .23232 .61551 .24444 .64059 .24324 .63531 .2311 Mtetra
.572 .772 .973 r
.63531 .2311 .64059 .24324 .66577 .24191 .6607 .22974 Mtetra
.574 .774 .973 r
.6607 .22974 .66577 .24191 .69107 .24046 .6862 .22827 Mtetra
.576 .775 .973 r
.6862 .22827 .69107 .24046 .71648 .2389 .71181 .22669 Mtetra
.578 .777 .973 r
.71181 .22669 .71648 .2389 .74201 .23725 .73754 .22501 Mtetra
.58 .778 .973 r
.73754 .22501 .74201 .23725 .76764 .23551 .76338 .22325 Mtetra
.581 .779 .973 r
.76338 .22325 .76764 .23551 .79338 .23369 .78933 .22139 Mtetra
.582 .78 .973 r
.78933 .22139 .79338 .23369 .81924 .2318 .8154 .21947 Mtetra
.583 .781 .974 r
.8154 .21947 .81924 .2318 .84521 .22984 .84158 .21747 Mtetra
.584 .782 .974 r
.84158 .21747 .84521 .22984 .87129 .22781 .86788 .21541 Mtetra
.585 .783 .974 r
.86788 .21541 .87129 .22781 .89748 .22572 .89429 .21329 Mtetra
.586 .783 .974 r
.89429 .21329 .89748 .22572 .92378 .22358 .92081 .21111 Mtetra
.617 .786 .963 r
.07871 .17305 .0881 .18473 .11082 .18195 .1016 .17022 Mtetra
.1016 .17022 .11082 .18195 .13364 .17915 .12458 .16738 Mtetra
.12458 .16738 .13364 .17915 .15654 .17634 .14765 .16453 Mtetra
.14765 .16453 .15654 .17634 .17953 .17353 .17081 .16167 Mtetra
.189 .53 .923 r
.17081 .16167 .17953 .17353 .20168 .18567 .19325 .17146 Mtetra
.139 .447 .88 r
.19325 .17146 .20168 .18567 .22399 .19871 .21566 .185 Mtetra
.257 .54 .922 r
.21566 .185 .22399 .19871 .2467 .20849 .23849 .19514 Mtetra
.337 .6 .944 r
.23849 .19514 .2467 .20849 .26971 .21592 .26164 .20284 Mtetra
.392 .641 .956 r
.26164 .20284 .26971 .21592 .29298 .22159 .28506 .20872 Mtetra
.432 .67 .962 r
.28506 .20872 .29298 .22159 .31647 .22592 .3087 .21321 Mtetra
.462 .691 .966 r
.3087 .21321 .31647 .22592 .34014 .2292 .33254 .21661 Mtetra
.484 .708 .968 r
.33254 .21661 .34014 .2292 .36399 .23165 .35656 .21914 Mtetra
.502 .72 .97 r
.35656 .21914 .36399 .23165 .388 .23342 .38074 .22098 Mtetra
.515 .73 .971 r
.38074 .22098 .388 .23342 .41216 .23463 .40507 .22224 Mtetra
.527 .738 .971 r
.40507 .22224 .41216 .23463 .43645 .23538 .42954 .22303 Mtetra
.536 .744 .972 r
.42954 .22303 .43645 .23538 .46088 .23574 .45415 .22341 Mtetra
.543 .75 .972 r
.45415 .22341 .46088 .23574 .48543 .23577 .4789 .22345 Mtetra
.549 .755 .972 r
.4789 .22345 .48543 .23577 .51011 .23551 .50377 .22321 Mtetra
.555 .758 .973 r
.50377 .22321 .51011 .23551 .53492 .23501 .52876 .22271 Mtetra
.559 .762 .973 r
.52876 .22271 .53492 .23501 .55984 .23429 .55388 .22199 Mtetra
.563 .765 .973 r
.55388 .22199 .55984 .23429 .58488 .23339 .57911 .22107 Mtetra
.566 .767 .973 r
.57911 .22107 .58488 .23339 .61004 .23232 .60447 .21999 Mtetra
.569 .77 .973 r
.60447 .21999 .61004 .23232 .63531 .2311 .62994 .21875 Mtetra
.572 .772 .973 r
.62994 .21875 .63531 .2311 .6607 .22974 .65553 .21738 Mtetra
.574 .773 .973 r
.65553 .21738 .6607 .22974 .6862 .22827 .68124 .21588 Mtetra
.576 .775 .973 r
.68124 .21588 .6862 .22827 .71181 .22669 .70706 .21427 Mtetra
.578 .776 .973 r
.70706 .21427 .71181 .22669 .73754 .22501 .73299 .21257 Mtetra
.579 .778 .973 r
.73299 .21257 .73754 .22501 .76338 .22325 .75905 .21077 Mtetra
.581 .779 .973 r
.75905 .21077 .76338 .22325 .78933 .22139 .78521 .20889 Mtetra
.582 .78 .973 r
.78521 .20889 .78933 .22139 .8154 .21947 .8115 .20693 Mtetra
.583 .781 .974 r
.8115 .20693 .8154 .21947 .84158 .21747 .8379 .20489 Mtetra
.584 .782 .974 r
.8379 .20489 .84158 .21747 .86788 .21541 .86441 .2028 Mtetra
.585 .782 .974 r
.86441 .2028 .86788 .21541 .89429 .21329 .89104 .20064 Mtetra
.586 .783 .974 r
.89104 .20064 .89429 .21329 .92081 .21111 .91779 .19842 Mtetra
.617 .786 .963 r
.06918 .16119 .07871 .17305 .1016 .17022 .09223 .15831 Mtetra
.09223 .15831 .1016 .17022 .12458 .16738 .11538 .15542 Mtetra
.11538 .15542 .12458 .16738 .14765 .16453 .13862 .15252 Mtetra
.13862 .15252 .14765 .16453 .17081 .16167 .16194 .14961 Mtetra
.291 .6 .95 r
.16194 .14961 .17081 .16167 .19325 .17146 .18469 .15702 Mtetra
.12 .433 .873 r
.18469 .15702 .19325 .17146 .21566 .185 .2072 .17107 Mtetra
.244 .531 .919 r
.2072 .17107 .21566 .185 .23849 .19514 .23015 .18158 Mtetra
.328 .594 .942 r
.23015 .18158 .23849 .19514 .26164 .20284 .25344 .18956 Mtetra
.386 .637 .955 r
.25344 .18956 .26164 .20284 .28506 .20872 .27701 .19564 Mtetra
.427 .667 .962 r
.27701 .19564 .28506 .20872 .3087 .21321 .30081 .20028 Mtetra
.458 .689 .966 r
.30081 .20028 .3087 .21321 .33254 .21661 .32481 .2038 Mtetra
.481 .706 .968 r
.32481 .2038 .33254 .21661 .35656 .21914 .349 .20643 Mtetra
.499 .719 .97 r
.349 .20643 .35656 .21914 .38074 .22098 .37335 .20833 Mtetra
.514 .729 .971 r
.37335 .20833 .38074 .22098 .40507 .22224 .39786 .20965 Mtetra
.525 .737 .971 r
.39786 .20965 .40507 .22224 .42954 .22303 .42252 .21047 Mtetra
.534 .744 .972 r
.42252 .21047 .42954 .22303 .45415 .22341 .44732 .21088 Mtetra
.542 .749 .972 r
.44732 .21088 .45415 .22341 .4789 .22345 .47225 .21094 Mtetra
.548 .754 .972 r
.47225 .21094 .4789 .22345 .50377 .22321 .49731 .2107 Mtetra
.554 .758 .973 r
.49731 .2107 .50377 .22321 .52876 .22271 .5225 .2102 Mtetra
.559 .761 .973 r
.5225 .2102 .52876 .22271 .55388 .22199 .54781 .20947 Mtetra
.562 .764 .973 r
.54781 .20947 .55388 .22199 .57911 .22107 .57325 .20855 Mtetra
.566 .767 .973 r
.57325 .20855 .57911 .22107 .60447 .21999 .5988 .20745 Mtetra
.569 .769 .973 r
.5988 .20745 .60447 .21999 .62994 .21875 .62448 .20619 Mtetra
.571 .771 .973 r
.62448 .20619 .62994 .21875 .65553 .21738 .65028 .2048 Mtetra
.574 .773 .973 r
.65028 .2048 .65553 .21738 .68124 .21588 .67619 .20328 Mtetra
.576 .775 .973 r
.67619 .20328 .68124 .21588 .70706 .21427 .70222 .20164 Mtetra
.577 .776 .973 r
.70222 .20164 .70706 .21427 .73299 .21257 .72837 .19991 Mtetra
.579 .777 .973 r
.72837 .19991 .73299 .21257 .75905 .21077 .75464 .19808 Mtetra
.58 .779 .973 r
.75464 .19808 .75905 .21077 .78521 .20889 .78102 .19616 Mtetra
.582 .78 .973 r
.78102 .19616 .78521 .20889 .8115 .20693 .80753 .19417 Mtetra
.583 .781 .974 r
.80753 .19417 .8115 .20693 .8379 .20489 .83415 .1921 Mtetra
.584 .782 .974 r
.83415 .1921 .8379 .20489 .86441 .2028 .86088 .18996 Mtetra
.585 .782 .974 r
.86088 .18996 .86441 .2028 .89104 .20064 .88774 .18776 Mtetra
.586 .783 .974 r
.88774 .18776 .89104 .20064 .91779 .19842 .91471 .1855 Mtetra
.617 .786 .963 r
.05949 .14913 .06918 .16119 .09223 .15831 .08271 .1462 Mtetra
.08271 .1462 .09223 .15831 .11538 .15542 .10603 .14327 Mtetra
.10603 .14327 .11538 .15542 .13862 .15252 .12944 .14032 Mtetra
.12944 .14032 .13862 .15252 .16194 .14961 .15293 .13737 Mtetra
.384 .659 .967 r
.15293 .13737 .16194 .14961 .18469 .15702 .17599 .14237 Mtetra
.101 .419 .866 r
.17599 .14237 .18469 .15702 .2072 .17107 .19861 .15692 Mtetra
.231 .522 .915 r
.19861 .15692 .2072 .17107 .23015 .18158 .22169 .16781 Mtetra
.318 .588 .94 r
.22169 .16781 .23015 .18158 .25344 .18956 .24511 .17606 Mtetra
.379 .633 .954 r
.24511 .17606 .25344 .18956 .27701 .19564 .26883 .18235 Mtetra
.422 .664 .961 r
.26883 .18235 .27701 .19564 .30081 .20028 .29279 .18715 Mtetra
.454 .687 .966 r
.29279 .18715 .30081 .20028 .32481 .2038 .31696 .19079 Mtetra
.478 .704 .968 r
.31696 .19079 .32481 .2038 .349 .20643 .34132 .1935 Mtetra
.497 .717 .97 r
.34132 .1935 .349 .20643 .37335 .20833 .36585 .19548 Mtetra
.512 .728 .971 r
.36585 .19548 .37335 .20833 .39786 .20965 .39054 .19684 Mtetra
.523 .736 .971 r
.39054 .19684 .39786 .20965 .42252 .21047 .41538 .1977 Mtetra
.533 .743 .972 r
.41538 .1977 .42252 .21047 .44732 .21088 .44037 .19814 Mtetra
.541 .749 .972 r
.44037 .19814 .44732 .21088 .47225 .21094 .46549 .19821 Mtetra
.548 .753 .972 r
.46549 .19821 .47225 .21094 .49731 .2107 .49074 .19798 Mtetra
.553 .758 .973 r
.49074 .19798 .49731 .2107 .5225 .2102 .51613 .19748 Mtetra
.558 .761 .973 r
.51613 .19748 .5225 .2102 .54781 .20947 .54164 .19674 Mtetra
.562 .764 .973 r
.54164 .19674 .54781 .20947 .57325 .20855 .56728 .19581 Mtetra
.565 .767 .973 r
.56728 .19581 .57325 .20855 .5988 .20745 .59304 .19469 Mtetra
.568 .769 .973 r
.59304 .19469 .5988 .20745 .62448 .20619 .61893 .19342 Mtetra
.571 .771 .973 r
.61893 .19342 .62448 .20619 .65028 .2048 .64493 .192 Mtetra
.573 .773 .973 r
.64493 .192 .65028 .2048 .67619 .20328 .67106 .19046 Mtetra
.575 .774 .973 r
.67106 .19046 .67619 .20328 .70222 .20164 .6973 .1888 Mtetra
.577 .776 .973 r
.6973 .1888 .70222 .20164 .72837 .19991 .72367 .18703 Mtetra
.579 .777 .973 r
.72367 .18703 .72837 .19991 .75464 .19808 .75015 .18517 Mtetra
.58 .778 .973 r
.75015 .18517 .75464 .19808 .78102 .19616 .77676 .18322 Mtetra
.582 .78 .973 r
.77676 .18322 .78102 .19616 .80753 .19417 .80348 .18118 Mtetra
.583 .78 .974 r
.80348 .18118 .80753 .19417 .83415 .1921 .83033 .17908 Mtetra
.584 .781 .974 r
.83033 .17908 .83415 .1921 .86088 .18996 .85729 .1769 Mtetra
.585 .782 .974 r
.85729 .1769 .86088 .18996 .88774 .18776 .88438 .17466 Mtetra
.586 .783 .974 r
.88438 .17466 .88774 .18776 .91471 .1855 .91158 .17236 Mtetra
.617 .786 .963 r
.04964 .13687 .05949 .14913 .08271 .1462 .07304 .1339 Mtetra
.07304 .1339 .08271 .1462 .10603 .14327 .09653 .13092 Mtetra
.09653 .13092 .10603 .14327 .12944 .14032 .12011 .12792 Mtetra
.12011 .12792 .12944 .14032 .15293 .13737 .14378 .12492 Mtetra
.467 .708 .973 r
.14378 .12492 .15293 .13737 .17599 .14237 .16716 .12748 Mtetra
.082 .405 .858 r
.16716 .12748 .17599 .14237 .19861 .15692 .18988 .14255 Mtetra
.218 .512 .911 r
.18988 .14255 .19861 .15692 .22169 .16781 .21308 .15381 Mtetra
.309 .582 .938 r
.21308 .15381 .22169 .16781 .24511 .17606 .23665 .16234 Mtetra
.372 .628 .953 r
.23665 .16234 .24511 .17606 .26883 .18235 .26052 .16884 Mtetra
.417 .661 .961 r
.26052 .16884 .26883 .18235 .29279 .18715 .28463 .1738 Mtetra
.45 .684 .965 r
.28463 .1738 .29279 .18715 .31696 .19079 .30897 .17756 Mtetra
.475 .702 .968 r
.30897 .17756 .31696 .19079 .34132 .1935 .33351 .18037 Mtetra
.494 .716 .97 r
.33351 .18037 .34132 .1935 .36585 .19548 .35822 .18241 Mtetra
.51 .726 .971 r
.35822 .18241 .36585 .19548 .39054 .19684 .38309 .18382 Mtetra
.522 .735 .972 r
.38309 .18382 .39054 .19684 .41538 .1977 .40812 .18472 Mtetra
.532 .742 .972 r
.40812 .18472 .41538 .1977 .44037 .19814 .4333 .18518 Mtetra
.54 .748 .972 r
.4333 .18518 .44037 .19814 .46549 .19821 .45861 .18527 Mtetra
.547 .753 .973 r
.45861 .18527 .46549 .19821 .49074 .19798 .48407 .18504 Mtetra
.552 .757 .973 r
.48407 .18504 .49074 .19798 .51613 .19748 .50965 .18454 Mtetra
.557 .761 .973 r
.50965 .18454 .51613 .19748 .54164 .19674 .53537 .1838 Mtetra
.561 .764 .973 r
.53537 .1838 .54164 .19674 .56728 .19581 .56121 .18285 Mtetra
.565 .766 .973 r
.56121 .18285 .56728 .19581 .59304 .19469 .58718 .18172 Mtetra
.568 .769 .973 r
.58718 .18172 .59304 .19469 .61893 .19342 .61328 .18042 Mtetra
.571 .771 .973 r
.61328 .18042 .61893 .19342 .64493 .192 .63949 .17898 Mtetra
.573 .773 .973 r
.63949 .17898 .64493 .192 .67106 .19046 .66583 .17741 Mtetra
.575 .774 .973 r
.66583 .17741 .67106 .19046 .6973 .1888 .6923 .17572 Mtetra
.577 .776 .973 r
.6923 .17572 .6973 .1888 .72367 .18703 .71888 .17392 Mtetra
.579 .777 .973 r
.71888 .17392 .72367 .18703 .75015 .18517 .74559 .17203 Mtetra
.58 .778 .973 r
.74559 .17203 .75015 .18517 .77676 .18322 .77242 .17004 Mtetra
.581 .779 .974 r
.77242 .17004 .77676 .18322 .80348 .18118 .79937 .16797 Mtetra
.582 .78 .974 r
.79937 .16797 .80348 .18118 .83033 .17908 .82645 .16583 Mtetra
.584 .781 .974 r
.82645 .16583 .83033 .17908 .85729 .1769 .85364 .16361 Mtetra
.585 .782 .974 r
.85364 .16361 .85729 .1769 .88438 .17466 .88096 .16133 Mtetra
.585 .783 .974 r
.88096 .16133 .88438 .17466 .91158 .17236 .9084 .15898 Mtetra
.617 .786 .963 r
.03963 .12441 .04964 .13687 .07304 .1339 .0632 .12139 Mtetra
.0632 .12139 .07304 .1339 .09653 .13092 .08686 .11836 Mtetra
.08686 .11836 .09653 .13092 .12011 .12792 .11062 .11531 Mtetra
.11062 .11531 .12011 .12792 .14378 .12492 .13447 .11226 Mtetra
.538 .747 .972 r
.13447 .11226 .14378 .12492 .16716 .12748 .15819 .11236 Mtetra
.063 .39 .85 r
.15819 .11236 .16716 .12748 .18988 .14255 .18102 .12795 Mtetra
.204 .503 .907 r
.18102 .12795 .18988 .14255 .21308 .15381 .20434 .13959 Mtetra
.3 .575 .936 r
.20434 .13959 .21308 .15381 .23665 .16234 .22804 .14839 Mtetra
.365 .624 .952 r
.22804 .14839 .23665 .16234 .26052 .16884 .25206 .1551 Mtetra
.412 .658 .96 r
.25206 .1551 .26052 .16884 .28463 .1738 .27635 .16022 Mtetra
.446 .682 .965 r
.27635 .16022 .28463 .1738 .30897 .17756 .30085 .16411 Mtetra
.472 .7 .968 r
.30085 .16411 .30897 .17756 .33351 .18037 .32556 .16701 Mtetra
.492 .714 .97 r
.32556 .16701 .33351 .18037 .35822 .18241 .35046 .16912 Mtetra
.508 .725 .971 r
.35046 .16912 .35822 .18241 .38309 .18382 .37552 .17058 Mtetra
.52 .734 .972 r
.37552 .17058 .38309 .18382 .40812 .18472 .40074 .17151 Mtetra
.53 .741 .972 r
.40074 .17151 .40812 .18472 .4333 .18518 .42611 .172 Mtetra
.539 .747 .972 r
.42611 .172 .4333 .18518 .45861 .18527 .45162 .1721 Mtetra
.546 .752 .973 r
.45162 .1721 .45861 .18527 .48407 .18504 .47727 .17188 Mtetra
.551 .757 .973 r
.47727 .17188 .48407 .18504 .50965 .18454 .50306 .17137 Mtetra
.556 .76 .973 r
.50306 .17137 .50965 .18454 .53537 .1838 .52898 .17063 Mtetra
.561 .763 .973 r
.52898 .17063 .53537 .1838 .56121 .18285 .55504 .16967 Mtetra
.564 .766 .973 r
.55504 .16967 .56121 .18285 .58718 .18172 .58122 .16852 Mtetra
.567 .768 .973 r
.58122 .16852 .58718 .18172 .61328 .18042 .60753 .1672 Mtetra
.57 .771 .973 r
.60753 .1672 .61328 .18042 .63949 .17898 .63396 .16574 Mtetra
.573 .772 .973 r
.63396 .16574 .63949 .17898 .66583 .17741 .66052 .16414 Mtetra
.575 .774 .973 r
.66052 .16414 .66583 .17741 .6923 .17572 .6872 .16242 Mtetra
.577 .776 .973 r
.6872 .16242 .6923 .17572 .71888 .17392 .71401 .16059 Mtetra
.578 .777 .973 r
.71401 .16059 .71888 .17392 .74559 .17203 .74095 .15866 Mtetra
.58 .778 .973 r
.74095 .15866 .74559 .17203 .77242 .17004 .768 .15663 Mtetra
.581 .779 .974 r
.768 .15663 .77242 .17004 .79937 .16797 .79519 .15452 Mtetra
.582 .78 .974 r
.79519 .15452 .79937 .16797 .82645 .16583 .82249 .15234 Mtetra
.583 .781 .974 r
.82249 .15234 .82645 .16583 .85364 .16361 .84992 .15008 Mtetra
.584 .782 .974 r
.84992 .15008 .85364 .16361 .88096 .16133 .87748 .14775 Mtetra
.585 .783 .974 r
.87748 .14775 .88096 .16133 .9084 .15898 .90516 .14537 Mtetra
.617 .786 .963 r
.02946 .11175 .03963 .12441 .0632 .12139 .0532 .10868 Mtetra
.0532 .10868 .0632 .12139 .08686 .11836 .07704 .10559 Mtetra
.07704 .10559 .08686 .11836 .11062 .11531 .10098 .1025 Mtetra
.10098 .1025 .11062 .11531 .13447 .11226 .12501 .09939 Mtetra
.6 .778 .966 r
.12501 .09939 .13447 .11226 .15819 .11236 .14908 .097 Mtetra
.043 .376 .842 r
.14908 .097 .15819 .11236 .18102 .12795 .172 .11311 Mtetra
.191 .493 .903 r
.172 .11311 .18102 .12795 .20434 .13959 .19545 .12513 Mtetra
.29 .569 .934 r
.19545 .12513 .20434 .13959 .22804 .14839 .2193 .13422 Mtetra
.358 .619 .951 r
.2193 .13422 .22804 .14839 .25206 .1551 .24347 .14114 Mtetra
.407 .654 .96 r
.24347 .14114 .25206 .1551 .27635 .16022 .26792 .14642 Mtetra
.442 .68 .965 r
.26792 .14642 .27635 .16022 .30085 .16411 .2926 .15043 Mtetra
.469 .698 .968 r
.2926 .15043 .30085 .16411 .32556 .16701 .31749 .15342 Mtetra
.49 .713 .97 r
.31749 .15342 .32556 .16701 .35046 .16912 .34256 .1556 Mtetra
.506 .724 .971 r
.34256 .1556 .35046 .16912 .37552 .17058 .36781 .15712 Mtetra
.519 .733 .972 r
.36781 .15712 .37552 .17058 .40074 .17151 .39322 .15808 Mtetra
.529 .74 .972 r
.39322 .15808 .40074 .17151 .42611 .172 .41879 .15859 Mtetra
.538 .747 .972 r
.41879 .15859 .42611 .172 .45162 .1721 .44451 .1587 Mtetra
.545 .752 .973 r
.44451 .1587 .45162 .1721 .47727 .17188 .47036 .15849 Mtetra
.551 .756 .973 r
.47036 .15849 .47727 .17188 .50306 .17137 .49636 .15798 Mtetra
.556 .76 .973 r
.49636 .15798 .50306 .17137 .52898 .17063 .52249 .15723 Mtetra
.56 .763 .973 r
.52249 .15723 .52898 .17063 .55504 .16967 .54875 .15625 Mtetra
.564 .766 .973 r
.54875 .15625 .55504 .16967 .58122 .16852 .57515 .15509 Mtetra
.567 .768 .973 r
.57515 .15509 .58122 .16852 .60753 .1672 .60168 .15375 Mtetra
.57 .77 .973 r
.60168 .15375 .60753 .1672 .63396 .16574 .62833 .15226 Mtetra
.572 .772 .973 r
.62833 .15226 .63396 .16574 .66052 .16414 .65511 .15063 Mtetra
.574 .774 .973 r
.65511 .15063 .66052 .16414 .6872 .16242 .68202 .14888 Mtetra
.576 .775 .973 r
.68202 .14888 .6872 .16242 .71401 .16059 .70906 .14701 Mtetra
.578 .777 .973 r
.70906 .14701 .71401 .16059 .74095 .15866 .73622 .14504 Mtetra
.58 .778 .973 r
.73622 .14504 .74095 .15866 .768 .15663 .76351 .14298 Mtetra
.581 .779 .974 r
.76351 .14298 .768 .15663 .79519 .15452 .79092 .14083 Mtetra
.582 .78 .974 r
.79092 .14083 .79519 .15452 .82249 .15234 .81847 .13861 Mtetra
.583 .781 .974 r
.81847 .13861 .82249 .15234 .84992 .15008 .84614 .13631 Mtetra
.584 .782 .974 r
.84614 .13631 .84992 .15008 .87748 .14775 .87393 .13394 Mtetra
.585 .783 .974 r
.87393 .13394 .87748 .14775 .90516 .14537 .90186 .1315 Mtetra
0 g
.89362 0 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.89362 0 m
.02946 .11175 L
s
.02946 .11175 m
.89362 0 L
s
gsave
.44797 -0.02478 -65.9056 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .4272 m
.29069 .70824 L
s
gsave
.15892 .66839 -66.3192 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{261.563, 185.125},
  ImageMargins->{{30.3125, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.095767,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000560000ia000`40O003h00OogooAgoo003oOom7
Ool00?moodMoo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo002SOol200000goo0000002N
Ool00:9oo`03001oogoo008009moo`00XWoo00D007ooOomoo`0009moo`00XWoo00D007ooOomoo`00
09moo`00XWoo00D007ooOomoo`0009moo`00XGoo0P000Woo0P00Wgoo003oOom7Ool00?moodMoo`00
ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7
Ool00?moodMoo`00ogooAgoo003oOolEOol4000^Ool00?moo`eoo`P000=oo`03001oogoo02aoo`00
ogoo1Goo20002goo00<007ooOol0;7oo003mOol7000COol2000]Ool00?Eoo`P001Yoo`8002eoo`00
kGoo20008Woo0P00;Goo003VOol7000ZOol2000]Ool00=ioo`P0035oo`03001oo`0002aoo`00eWoo
2000>Woo0P00;7oo003>Ool80012Ool2000/Ool00<Moo`L004Yoo`8002aoo`00_goo2000DGoo00<0
07oo0000:goo002gOol8001IOol00`00Ool0000[Ool00;1oo`L0065oo`03001oo`0002]oo`00Z7oo
2000J7oo00<007oo0000:goo002POol8001`Ool00`00Ool0000[Ool009Uoo`L007Qoo`04001oogoo
000ZOol0095oo`P007moo`04001oogoo000ZOol008Uoo`P008Moo`04001oogoo000ZOol0089oo`L0
08moo`04001oogoo000ZOol007Yoo`P009Ioo`05001oogooOol0000YOol0079oo`P009ioo`05001o
ogooOol0000YOol006Yoo`P00:Moo`04001oogoo000YOol006=oo`L00:moo`04001oogoo000YOol0
05]oo`P00;Ioo`05001oogooOol0000XOol005=oo`P00;ioo`05001oogooOol0000XOol004aoo`L0
00E;7/5oo`05001oogooOol0000XOol004Aoo`P00007Cai;7DlnBae?7T[mCah00T/N00A:oDlNBah5
N/1oo`05001oogooOol0000XOol003aoo`P0009?7P05Bai?7TlNCai;7P03Cah014/NCai?7TlN1d/N
0PEj_Woo00D007ooOomoo`0002Qoo`00>7oo100001U??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNB_e?7P02Bah01D[mCah5NPEj1GT0_Goo00<007ooOol00Woo00<007oo
Ool09Goo000hOol01@00Cai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah0
14/NCai?7TlN1T;n0`Ej_7oo00<007ooOol00Woo00<007ooOol09Goo000hOol07`00Bae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M@_i2gTKn0092oP06@]h5
V`Ej1GX5NAGl^Woo00<007ooOol00Woo00<007ooOol09Goo000hOol00`00Oom;7P03Cah01D/NCai?
7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P02Cah6@_h31GX35ObhOol00`00Oomo
o`02Ool00`00Oomoo`0UOol003Qoo`0M001oogooBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai;7DlnBae?7T/MCci;7DlNBae??P02@_h034;NA_i2oT;n1GX5V`Ej1IXEfaGl5M`Eo;Ioo`03001o
ogoo00=oo`03001oogoo02Aoo`00>7oo00D007ooOomood/N00=?7P05Bai?7TlNCai;7P03Cah01D/N
Cai?7TlNBah00dlN00I;7TlNCai?7T/NCah2>]h013Zn>]hjgS[N0`Ej00<5VQGl5O`00QGl00<R?Goo
Ool0/Woo00<007ooOol00goo00<007ooOol097oo000gOol00`00Oomoo`02Ool0;DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??SZn>]hf_S[O>[hjgPEj1I/5
NQWl5O`Io1GL9SdR?2IM8SdV?@2YOol024/OAai;7TLNBam77T/N0005Ool00`00Oomoo`0TOol003Mo
o`03001oogoo00=oo`03Cai;7TlN009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00I;
7TlNCai?7T/NCah2>]h01CZn>]hjgPVK1IX00PEj00@Io1Gl6O`Eo0DR?@03:Weoogoo09ioo`=;7P05
Aai;7T/NBai77P03Bah01DLNBai;7T/N000017oo00<007ooOol097oo000gOol00`00Oomoo`04Ool0
<DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??RjN<Yh^
WC:N;Yh9V`Ej2I/Eo1Wl5O`Io1Gl9UdR?2IM8Sd^ORYM;WhZGBin08ioo`0NAai;7TKnBam77T/NA_i;
7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77P001Goo00<007ooOol08goo
000gOol00`00Oomoo`04Ool2Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P03Cah00d/N;Yh^WP04;Yh00`VK1IX9VP026O`011Gl6O`R?BIM0b8m00H^ORYm:WdZOBin<Yd3
<Yh00c:MOomoo`1gOol05dLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/N
Aah00d/N00E77T/NBai;7TLN00=;7P05Aai;7T/NBai77P03Bah00dLNBah00005Ool00`00Oomoo`0S
Ool003Moo`03001oogoo00Eoo`0mBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/M<Yh^WS:N;YdbWPVJ2I/5NQXM6O`J71Gl6O`R?BIM8S`VGBYM;WhZGBin:Udb
WS9m<YhbWC:N<Wdj_SJN=[hfWCZn=Yh0I7oo03];7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam7
7T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai7
7T/OAai;7TLNBam77T/NAai;7dLNBai77P0000Eoo`03001oogoo02=oo`00=goo00<007ooOol01Woo
0TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00=;7R9M;Yh0
0bjN00<9V`Vk1IX00QWl00XJ71Wl9SdR?BIM8SdV?Bim;WhZO@8^O@03<YhbWC:N008bWP03<Ydf_SJn
00@f_PDj_U5oo`=77P03A_i77TLN00Q77P05Bai77TLNAai;7P03Aah07T/NAai77TLNBai77T/NAai;
7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03
Bah01DLNBai;7T/NAah00d/N00<007ooOol00goo00<007ooOol08goo000gOol00`00Oomoo`07Ool0
>d/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCahRGBIn8UdV
GR9M3K/9VPVk5O`J7AWl6Q`Eo2IM8SdVGB8l;WhZOBin:Ud^ORYm<YhbOC:N<YdbWSJM>[hfWSJn=Yd0
0SZn00/jgSZm>]hj_S[N>[hngSZn?]hj_SkN03Eoo`1MAai6oTLOA_i77TKnAam6oTLNA_i;7dKnAai6
oT/OA_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6
oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6
oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77P0000Eoo`03001oogoo02=oo`00=goo
00<007ooOol027oo0TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah0
0dlN0b9M00DRGR9M2I/9V`Vk00<Io0066Q`V?BIM9SdVGBHm0Rim00<^ORYm;Wd00S:N00@bWC:N<Yhb
WPHf_PDj_P03?]hjgSkN008ngP03>]hngSkN00HngP08@]hngT;n?]i2gSkN@_i2gP=2oP03@]i2oT;n
00Q2oP03A_i2oT;n0096oP05@_i6oTKnA_i2oP0:A_h04TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLN
A_i77TKnAai6oP=77P05A_i77TLNAai6oP03Aah00dKnAai77P08Aah01D/NAai77TLNBah00dLN01Y;
7TLNAai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/N
Bai;7TLN00=;7P05Aai;7T/NBai77P03Bah00dLNBah00006Ool00`00Oomoo`0ROol003Moo`03001o
ogoo00Uoo`18Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7QGl9WhRGBIN2IX=^`VJ2K/Io1hM6O`J728m9UdV?BIM8Sd^ORYm;WhZGBin<YdbWS:M=YhbWC:N=Ydj
_SJN>[hfWC[N>[hjgSZm>]hj_SkN>[hngSZn?]hj_T;n0ckN0152oSkN@_hngT;n?]i2oSkN@_i2gT;n
?]i2oT;N@_i2gTKn0092oP1k@]i6oT;nA_i2oTKo@_i6oT;nA_m2oTKn@_i77d;nA_i2oTLO@_i77T;n
Aam2oTLN@_i77dKnAai2oTLOA_i77TKnAam6oTLNA_i;7dKnAai6oT/OA_i77TKnBam6oTLNA_i;7dKn
Bai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKn
Bam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLN
Bai77T/OAai;7TLNBam77T/NAah004LN00Eoo`03001oogoo029oo`00=goo00<007ooOol02Goo0dlN
00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00TlN00DF7AHL5QdRGB9N
008=^`032I/N71Wl008J70059UdV?BIM9SdVG@03;Wd00bin;WdbWP02<Yh00c:M<YhbWP06=[h2>[h0
1S[N>[hj_SZn?]hjgP<ngP03>]hngSkN00@ngP07@_hngT;N?]i2oSkN@]h00T;n00=2gT;n@_h024;n
00I6oT;n@_i2oTKn@_h3A_h00d;nA_i6oP08A_h01DLNA_i6oTKnAah00dKn00i77TKnAai6oTLNA_i7
7TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3Aah01D/NAai77TLNBah0
0dLN00E;7TLNAai77T/N00=77P0FBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai7
7T/NAah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00=;7P03001;7Woo00Aoo`03001oogoo
029oo`00=Woo00<007ooOol02goo05e??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/M5QdEo1HM5Q`=^`VJ3K/9VahM6O`N7AWl9UdR?BIM9SdVGBYm;Wh^OBin:Wdf
_S:M=YhbWCJn<Ydj_SJM>[hfWSZn>[djgSZn>]hj_C[N>[hngSZn?]hj_SkN>[i2oSkN@]hngT;n?]i2
oSkN@_hngT;n?]i2oT;N@_hngT;n@]i2oT;NA_h00T;n07U2gTKn@_i6oT;nA_m2oTKn@_i77d;nA_i2
oTLO@_i77T;nAam2oTLN@_i77d;nAai2oTLOA_i77T;nAam6oTLNA_i77dKnAai6oT/OA_i77TKnBam6
oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLN00177P05Ool00`00Oomoo`0ROol003Ioo`03
001oogoo00aoo`=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N009?
7P052M/F71HM5Q`A^`033K/011hM6O`J71XL12IM00H^ORim;Wd^OBin;Wd6<Yh013Zn=[hf_SJn13Zn
00<jgSZn>[h00SkN00<jgSkN?]h01ckN00=2gT;n?]h00T;N00=2oSkN@_h00T;n00=2gT;n@_h024;n
00I6oT;n@_i2oTKn@_h3A_h00d;nA_i6oP08A_h04TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i7
7TKnAai6oP=77P05A_i77TLNAai6oP03Aah00dKnAai77P04Aah01D/NAai77TLNBah00dLN029;7TLN
Aai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77P=;7P05Aai;7T/NBai77P03Bah00dLNBai;7P03Bah00`00Baioo`05Ool00`00Oomoo`0QOol0
03Ioo`03001oogoo00eoo`0OCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7Dln
Bae?7T/MCci;7@WL1K/F7@fk4M/00Pfk01<J71hM6O`N7AXL9UdV?BYM9Sd^WRim<Yh^OBjN;Wdf_S:M
=YhbW@02=[h043Zn=Ydj_SJn>[hj_CkN>[hjgSZm?]hj_SkN>[hngSZn0SkN0112oSkN@]hngT;n?]i2
oSkN@_hngT;n?]i2oT;N@_hngP=2oP1l@]i6oT;n@_i2gTKo@_i6oT;nA_m2oTKn@_i77d;nA_i2oTLO
@_i77T;nAam2oTLN@_i77dKnAai2oTLOA_i77TKnAam6oTLNA_i77dKnAai6oT/OA_i77TKnBam6oTLN
A_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/O
A_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/N
A_i;7dLNBai77T/OAai;7TLNBam77T/NAah004LNBah5Ool00`00Oomoo`0QOol003Ioo`03001oogoo
00ioo`=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N009?7P052M/5
^`Vk3K/A^`023K/00ahL7QdN70027Q`02bYM9UdVGBIM;Wh^OBin;Wd^ORim=Yh013:N00<f_SZn=[h0
0SJn00HjgSZn>[hj_S[N>[h<?]h2@]h01T;n?]i2gT;N@_i2gP=2oP03@]i2oT;n00Q2oP06A_i2oT;n
@_i6oT;n0dKn00=2oTKnA_h024Kn01977TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3
Aah01DKnAai77TLNA_h00dLN00A6oTLNAai;7P=77P05Bai77TLNAai;7P03Aah05T/NAai;7TLNBai7
7T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;7T/N
Bai77P03Bah00dLNBai;7P05Bah00`00Bai;7P05Ool00`00Oomoo`0QOol003Ioo`03001oogoo00mo
o`1HCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7@WL1K/9
g0fk4M/=^a7L7Q`N7AWl7QdVGBYM9UdZGRIM;Yh^OC:N;Wd^WS:M=[hbWCJN<Ydj_SJn>[hfWCZn=[hj
gSZm?]hj_S[N>[hngS[N?]hj_SkN>]i2gSkN@_hngT;N?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]h2
@_h0NdKn@]i6oT;nA_i2oTKo@_i6oT;nA_m2oTKn@_i77d;nA_i2oTLO@_i77T;nAam2oTLN@_i77dKn
Aai2oTLOA_i77TKnAam6oTLNA_i77dKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKn
Bam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLN
Bai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLN
Bam77P00Aai;7`05Ool00`00Oomoo`0QOol003Ioo`03001oogoo00moo`05Bai?7TlNCai;7P03Cah0
1D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7P5j2M/5^`024M/01A6k3K/N7AhL7Qd0
0QhL00<VGBYM9Ud00RIM00h^WRim;Wh^OBin<YhfWS:N=YhbWSZn=[hj_SJn0SZn00DjgSZn>[hj_S[N
00dngP08@_i2gT;n?]i2oT;N@_i2gP=2oP03@]i2oT;n00I2oP04A_i2oTKn@_h3A_h01D;nA_i6oTKn
@_h02TKn01977TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h0
0dLN00A6oTLNAai;7P=77P05Bai77TLNAai;7P03Aah05T/NAai;7TLNBai77T/NAai;7TLNBai77T/N
Aai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;7T/NBai77P03Bah00dLNBai;
7P03Bah00`00Bai;7P06Ool00`00Oomoo`0POol003Ioo`03001oogoo011oo`0JBae??T/MCai;7Dln
Bae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??P81NP0M1K/Ag16k4M/=^b8m7Q`N
?AhL:UhVGBYM9UdZGRim<Yh^OC:N;WdfWS:M=[hbWCJN=Ydj_SJn>[hfW@02>[h01SkN>[dngSZn?]hj
_P<ngP2@>[hngSkN@]hngT;n?]i2gSkN@_hngT;n?]i2oT;N@_i2gT;n@]i2oT;NA_i2oTKn@]i6oT;n
A_i2oTKo@_i6oT;nA_m2oTKn@_i77d;nA_i2oTLO@_i77T;nAam2oTLN@_i77dKnAai2oTLOA_i77TKn
Aam6oTLNA_i;7dKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKn
Bai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKn
Bam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBal004/N1Woo00<0
07ooOol087oo000fOol00`00Oomoo`0AOol01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P04
Bai?7TlNCah3Bah00dlNBai;7P020GX34M/02A7L7Q`N7AhL7QdN72YM9UdZG@029Ud01bim;Yh^OBin
;WdfWS:N00<fWP0;=[hj_SJn>[hf_S[N>[hjgSZn>]hj_P08?]h02T;N?]hngSkN@]hngT;n@]i2oSkN
3T;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP08A_h05TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLN
A_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3Aah01D/NAai77TLN
Bah00dLN01I;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;
7T/NBai77P03Bah01DLNBai;7T/NAah00d/N00=77T/NBah00T/N00<004/NOol01Goo00<007ooOol0
87oo000fOol00`00Oomoo`0BOol06T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/M
Cai:oDlNBai?7T[m1GX20GX09A7K4M`A^a7L7Q`R?AhL7SdVGBYn9UdZGBIM<Yh^OC:N;WdbWS:M=[hb
WCJn<Ydf_SJm>[hf_SZn=[dngSZn?]hj_CkN>[hngSZn00<ngP2>>[i2oSkN@_hngT;n?]i2oSkN@_hn
gT;n?]i2oT;N@_i2gT;n@]i2oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAam2oTLN@_i77d;nAai2
oTLO@_i77T;nAam6oTLN@_i77dKnAai2oTLOA_i77TKnAam6oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6
oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam7
7T/NAai;7dLNBai77T/OAai;7P00Bal6Ool00`00Oomoo`0POol003Ioo`03001oogoo01=oo`05Bai?
7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00A;7TlNBai?7P=;7P0=Cai;7PEj0GXEg17K5M`Afb8m
7Q`R?B8M8Sd01BYM00DbWRim<Yh^OC:N008fWP05<YhfWSJN>[hf_P03>[h01SJn>]hj_SkN>[hjgPTn
gP0:@]hngSkN?]i2oSkN@_i2gT;n?]h<@_h024Kn@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP08A_h0
4TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP03Aah014Kn
Aai77T/N0dLN00E;7TLNAai77T/N00=77P0FBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;
7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00=;7P03Aai;7T/N00A;7P03
001;7T/N00Eoo`03001oogoo021oo`00=Goo00<007ooOol05Goo03e;7DlnBae?7T/MCci;7DlNBae?
?T/MCai;7DlnBae?7T/MCci;7TlNB_e?7T/NCah5F@Ej0GXEg17K5O`Afb8m7Q`R?AhL8SdZGBYn9UdZ
GBim<Yh^OC:N;WdbWS:M=[hbWCJn<Ydj_SJm>[hf_SZn>[dngSZn?]hj_@03?]h0TC[N?]hngSkN>]i2
oSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oT;N@_i2gT;n@]i6oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6
oT;nAam2oTLN@_i77dKnAai2oTLOA_i77T;nAam6oTLN@_i77dKnAai6oTLOA_i77TKnAam6oTLNA_i;
7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;
7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;
7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/O001;7TLN00Ioo`03001oogoo01moo`00=Goo
00<007ooOol05Goo00=?7T/NCah00TlN00E;7TlNCai?7T/N00=?7P06Bai?7TlNCai;7TlN0T;n0112
gT;n@_i2oPEI1GXEfaGL4M/Eg1GK8SdN728m8QdZO@<ZG@06:Wd^OC:N;WdbWRim0SJN00@f_SJN=Yhf
WPHj_P04>]hj_SkN>[h:?]h024;N?]hngT;N@_i2gT;n@]h>@_h024Kn@_i6oT;nA_i2oTKn@_h3A_h0
0d;nA_i6oP08A_h04TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLN
Aai6oP03Aah014KnAai77T/N0dLN00E;7TLNAai77T/N00=77P0FBai77T/NAai;7TLNBai77T/NAai;
7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00=;7P03
Aai;7T/N009;7P03001;7T/N00Ioo`03001oogoo01moo`00=Goo00<007ooOol05Woo01U?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae2ockN@_hngT;o?]h9VP021GX05aGK5M`AfaGl8Q`R
?B8L8SdN72Yn:UdZORYM:Wh^OC:N;WdbWRim=[hbWCJn<Yd00SJn00Xj_SJm>[hf_SZn>[dngSZn?]hj
_@<ngP03>]hngSkN008ngP0@@_hngT;n?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]h2@_h0NDKn@]i6
oT;nA_i2oTLN@_i6oT;nAai2oTLN@_i77d;nAai2oTLOA_i77T;nAam6oTLN@_i77dKnAai2oTLOA_i7
7TKnAam6oTLNA_i;7dKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;
7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;
7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7P00Bam77T/N00Eo
o`03001oogoo01moo`00=Goo00<007ooOol05goo00=?7T/NCah00TlN00E;7TlNCai?7T/N00=?7P05
Bai?7TlNCai;7P03@_h00d;N@_i2oP031GX011GL5O`AfaGL0R8m00@R?28m:UdZO@<ZG@05<YhbOC:N
<YdbWP03=Yh00cJn=YhfWP05>[h01SkN>[hjgS[N?]hj_PHngP0<@]hngSkN?]i2gSkN@_i2gT;n@]i2
oT;N3T;n00A6oT;nA_i2oP=6oP05@_i6oTKnA_i2oP06A_h01DLNA_i6oTKnAah00dKn00I77TKnAai6
oTLNA_h3Aah01DKnAai77TLNA_h00dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3Aah01D/NAai7
7TLNBah00dLN01I;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05
Aai;7T/NBai77P03Bah01DLNBai;7T/NAah01T/N00@004/NBai;7PEoo`03001oogoo01moo`00=Goo
00<007ooOol05goo03e;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7CJn<[hf_S:N
=[h5NPVJ1GX9VQGK5O`Efb8m8Q`R?B8L8SdZGBin:Ud^ORYM<Yh^OC:N;WdbWS:M=[hfWCJn<Ydj_SJn
>[hf_CZn=[hngSZm?]hj_P08?]h0Rd;n?]i2oSkN@_hngT;n?]i2oSkN@_hngT;n@]i6oT;N@_i2gTKn
@_i6oT;NA_i2oTKn@_i77T;nA_i2oTLN@_i77T;nAam2oTLN@_i77dKnAai2oTLOA_i77TKnAam6oTLN
A_i77dKnAai6oTLOA_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/O
A_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/N
A_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7`00Bai77T/O
00Ioo`03001oogoo01ioo`00=Goo00<007ooOol067oo0TlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P03Cah00d/N=[hf_P03=[h01`VJ1GX5NPEj5M`Eo1GL00<R?@0A8S`ZOBYM:WdZGBYm:UdbWS9m
<YhbWCJn=Yhf_SJN=[hfWP05>[h00c[N?]hj_P02>]h8?]h014;N?]hngSkN0T;N00A2oT;N@_i2gPY2
oP0:A_i2oT;n@_i6oT;nA_i2oTKn@_h:A_h01DLNA_i6oTKnAah00dKn00Y77TKnAai6oTLNA_i77TKn
Aai6oP=77P05A_i77TLNAai6oP03Aah00dKnAai77P08Aah01D/NAai77TLNBah00dLN01I;7TLNAai7
7T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah01DLN
Bai;7T/NAah00d/N00=77T/NBah00T/N00<004/NBah00T/N1Goo00<007ooOol07Woo000eOol00`00
Oomoo`0IOol074/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/M9Whb_SJn<Yh9V`VJ
2I/5NQWl0QGl01HR?2Hm8S`V?B8l;WhZGBin:Ud^OS9m<Yh^OC:N<Wdf_S:M=[hfWCJn=[djgP8j_P07
=[djgSZn?]hj_CkN>[h00SkN0912gSkN?]hngT;n?]i2oSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oT;N
A_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nAai2oTKn@_i77d;nAai2oTLO@_i77T;nAam6oTLN@_i77dKn
Aai6oTLOA_i77TKnBam6oTLNA_i;7dKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKn
Bam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLN
Bai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7P00
Bam77T/NAah5Ool00`00Oomoo`0NOol003Eoo`03001oogoo01Yoo`9?7P05Bai?7TlNCai;7P03Cah0
1D/NCai?7TlNBah00dlN00E;7RIn9WdVORIM0089VP032I/9VQWl008Io0<R?@0>9SdR?Bim:UdZOBYM
:WdbWC:N<YdbWS:M=[hfWP<f_PDj_P06?]hjgSkN>[hngS[N1SkN00Q2gSkN@_hngT;N?]i2oT;N0d;n
00=2gT;n@_h024;n00Y6oT;n@_i2oTKn@_i6oT;nA_i2oPI6oP05Aai6oTKnA_i77P03A_h03TLNA_i6
oTKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h02TLN00E;7TLNAai77T/N00=77P0J
Bai77TLNAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;
7T/NBai77P03Bah01DLNBai;7T/NAah00d/N00A77T/NBah000A;7PEoo`03001oogoo01ioo`00=Goo
00<007ooOol06goo03e;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7BIn9UdVORIM
2I/9VPVK2GXIo1Gl6O`R?2Hm8S`V?BYM;WhZGBin:UdbWS9m<Yh^OC:N=Ydf_SJM>[hfWCJn>[djgSZn
>]hj_CkN>[hngSZm?]hj_P02?]h0Sd;N?]hngSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oSkNA_i2gT;n
@]i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLO@_i77T;nAam6oTLN@_i77dKnAai2oTLO
A_i77TKnAam6oTLNA_i;7dKnAai6oT/OA_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/N
A_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/O
Aai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBal004/N
Aai;7dLNBah017oo00<007ooOol07Woo000eOol00`00Oomoo`0LOol2Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P08BahVORIm9Wh=VPfk2IX9V`<Io0DV?@05:Wd^OBim;WdZO@03<Yh01C:M
<Yhf_SJn=Yh00SJn1SZn0ckN00<jgSkN?]h01SkN00E2gSkN@_hngT;N0092oP05@]i2oT;n@_i2gP06
@_h034Kn@_i2oT;nA_i2oTKn@_i6oT;nA_i2oPQ6oP05Aai6oTKnA_i77P03A_h02TLNA_i6oTKnAai6
oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3Aah01D/NAai77TLNBah00dLN00E;
7TLNAai77T/N00=77P0>Bai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03
Bah01DLNBai;7T/NAah00d/N00=77T/NBah01T/N00<004/NBah00d/N1Goo00<007ooOol07Goo000d
Ool00`00Oomoo`0NOol0>d/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7Q7l5QdVGBIn
2IX=^`VJ2I/Io1hL6O`VGB8l9UdR?BIM:Ud^ORYM;WhbOCJN<YdbWS9m=YhfWCZn=Ydj_SJM>]hj_C[N
>[hjgSZn?]hj_SkN>[h013kN08e2oSkN?]hngT;n?]i2oSkN@_i2gT;n?]i2oT;N@_i2gTKn@]i2oT;N
A_i2gTKn@_i6oT;nA_i2oTLN@_i6oT;nAai2oTLN@_i77d;nAai2oTLOA_i77T;nAam6oTLNA_i77dKn
Aai6oTLOA_i77TKnBam6oTLNA_i;7dKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKn
Bam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLN
Bai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77P00Aai;7TLN
Bal01Goo00<007ooOol07Goo000dOol00`00Oomoo`0NOol01000Cai?7T/N0dlN00E;7TlNCai?7T/N
00=?7P0<Bai?7TlNCahF71HM5Q`=^`fJ3K/=VahL0aWl00DVGBHm9SdV?Bin00<^O@03;WhbWC:N008b
WP05<Ydf_SJn=[hfWP02=[h5>[h01C[N?]hngSkN>]h01SkN00I2oSkN@]hngT;n?]h3@_h00d;N@_i2
oP08@_h01TKn@_i2oT;nA_i2oP=6oP03@_i6oTKn00Q6oP0BAai6oTKnA_i77TKnAai6oTLNA_i77TKn
Aai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3Aah01D/NAai77TLNBah00dLN
01I;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai7
7P03Bah01DLNBai;7T/NAah02d/N00<004/NBah00T/N1Goo00<007ooOol07Goo000dOol00`00Oomo
o`0OOol0<4lnBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN4O`F7AHL4K/9VPfk3IXN
71Wl7Q`V?BIM9S`VGB8m;WhZGBin;Wd^OS:M=YhbWCJN<Ydj_SJM>[hfW@8j_P0;>]hj_CkN>[hjgSZn
?]hj_SkN>[i2oP03?]h0Rd;n?]i2oSkN@_hngT;n?]i2oT;N@_hngT;n@]i2oT;NA_i2gT;n@]i6oT;n
A_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLO@_i77T;nAam6oTLN@_i77dKnAai6oTLOA_i77TKn
Bam6oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKn
Bai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKn
Bam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAah004LNBam77T/N00Eoo`03
001oogoo01eoo`006Woo0`005goo00<007ooOol087oo0dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlN
Cai;7P02Cah00`Fk1IXF7@034K/00`fk7Q`N70026O`29Ud012Hm9Ud^OBin0bim00HfWS:M<YhbWSJN
<Yd2=[h00cZn=[hf_P05>[h<?]h01T;n?]i2gT;N@_hngP=2oP03@]i2oT;n00I2oP08A_i2oTKn@_i6
oT;nA_i2oP=6oP03@_i6oTKn00Q6oP0BAai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn
0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3Aah01D/NAai77TLNBah00dLN019;7TLNBai77T/N
Aai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00=;
7P03Aai;7T/N00M;7P03001;7T/N009;7PIoo`03001oogoo01aoo`006goo00<007ooOol05Woo00<0
07ooOol08Goo031??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7DlnBad5^`FJ1K/=^a6k3K/A
fagl7QdIo2YM9SdVGBHl:Ud^OBin;WdbWRim=YhbWCJN<YdfWSJM>[hfWCZn=Yd2>[h023kN>[dngSZn
?]hj_SkN>[h2?]h044;n?]i2gSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oSkN0T;n07a6oT;NA_i2oTKn
@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAam6oTLN@_i77dKnAai6oTLO
A_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/N
A_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/O
Aai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77P00Aai;7TLNBam77PEo
o`03001oogoo01aoo`005goo0`0000=oo`00Ool05goo00<007ooOol08Goo00E;7TlNCai?7T/N00=?
7P05Bai?7TlNCai;7P03Cah01T/NCai?7PFk1IX5^`@A^`<N7004:UdVGBIM9Sd2;Wd02Bin;Wd^OBim
=YhbWCJN<YhfWP03=[h01CZn=[hj_SZn>]h00cZn2ckN00=2gT;n?]h00T;N00=2oT;N@_h00T;n00=2
gT;n@_h01T;n00Q6oT;nA_i2oTKn@_i6oT;n0dKn00=2oTKnA_h014Kn01977TKnA_i6oTLNA_i77TKn
Aai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00A6oTLNAai;7P=77P05Bai77TLN
Aai;7P03Aah05T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E7
7T/NBai;7TLN00=;7P05Aai;7T/NBai77P0;Bah00`00Bai;7P03Bah5Ool00`00Oomoo`0LOol001Io
o`04001oogooOol2000HOol00`00Oomoo`0ROol05T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;
7DlNBae??PEI1K/5VQGL0Q6k02<=^b8m7Q`N7BHm:UdVGBYM9SdbWRim;Wh^OC:N<YdfWS:M=[hbWCJN
=Ydj_SJm>[hfWCkN>[hngSZm?]hjgSkN>[hngS[N008ngP0@@_hngT;N?]i2oSkN@_hngT;n?]i2oT;N
@_i2gT;n@]h2@_h0NTKn@]i6oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN@_i77T;nAai2
oTLN@_i77dKnAai2oTLOA_i77TKnAam6oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai7
7T/OAah004LNBam77T/NAah5Ool00`00Oomoo`0LOol001Ioo`03001oogoo009oo`03001oogoo01Io
o`03001oogoo02=oo`05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00E;7TlN1GX5NPFJ008E
f`8A^`048Q`N728M9Ud3:Ud012IM;Wd^OC9n0Rim00TbWSJN<YdfWS:N>[hf_SZn=[h013Zn00<ngSZn
>[h02ckN0T;N00I2oSkN@]i2gT;n@]h3@_h00d;N@_i2oP04@_h01TKn@_i6oT;nA_i2oP=6oP03@_i6
oTKn00Q6oP0BAai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn
00=77P04A_i77TLNBah3Aah01D/NAai77TLNBah00dLN01I;7TLNBai77T/NAai;7TLNBai77T/NAai;
7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah01DLNBai;7T/NAah02D/N00<004/N
Bah014/N1Goo00<007ooOol06goo000FOol00`00Oomoo`02Ool00`00Oomoo`0FOol00`00Oomoo`0T
Ool074/MCci;7DlNBae??T/MCai;7DlnBae?7T;nAai2oTLN@_i77PEI1GXA^aGL4K/Eg1hL8SdN728M
0RYM01LVGBYM;WdbWRim<Yh^OC:N<YdfWS:M=[hbWCZn=Ydj_SJm>[hj_CkN>[hngSZm00<ngP2@>[hn
gSkN@]hngT;n?]i2gSkN@_hngT;n?]i2oSkN@_i2gT;n@]i2oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6
oT;nAai2oTKn@_i77T;nAai2oTLN@_i77T;nAai6oTLN@_i77dKnAai6oTLOA_i77TKnAam6oTLNA_i;
7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;
7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;
7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77P00Aai;7TLNBam77T/N1Goo00<007ooOol06goo
000FOol01000Oomoogoo0P0067oo00<007ooOol09Goo00E;7TlNCai?7T/N00=?7P03Bai?7TlN00I6
oP032GX5NPEj00@Ef`8R70037Q`ZGBYM00<ZG@<^O@03<Wh^OCJN008fWP08=YdfWSJn>[hf_SZn=[hn
gP<j_P03?]hj_SkN00DngP04@]hngSkN?]h2@]h014;n@]i2oT;N3T;n00I6oT;nA_i2oTKn@_h3A_h0
0d;nA_i6oP08A_h04TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLN
Aai6oP03Aah014KnAai77T/N0dLN00E;7TLNAai77T/N00=77P0BBai77T/NAai;7TLNBai77T/NAai;
7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;7T/NBai77P03Bah00dLNBai;7P05
Bah00`00Bai;7P04Bah5Ool00`00Oomoo`0KOol001Moo`<00003Ool0000001Moo`03001oogoo02Eo
o`0LCai;7DlnBae?7T/MCci;7DlNBae??T/MAai2oTLN@_i77T;n2IX9NQWl5M/Io16k8SdR728m8Q`2
:Ud062Ym:UdZGBim<Yh^OC:N;Wdf_S:M=[hbWCZn=[dj_SJm>[hf_CkN>[dngSZn?]hj_P<ngP2>>[hn
gSkN@_hngT;n?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]i2oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6
oT;nAai2oTKn@_i77TKnAai2oTLNA_i77T;nAam6oTLNA_i77dKnAai6oTLOA_i77TKnBam6oTLNA_i;
7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;
7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;
7dLNBai77T/OAai;7TLNBam77T/NAai;7dLN00177T/OAai;7TLNBal5Ool00`00Oomoo`0KOol003=o
o`03001oogoo02Moo`03Cai;7TlN009?7P05Bai?7TlNCai;7P02Cah5=[h32GX02AWL5M/Eg1GK8SdR
728m8Q`^O@03:Ud01S:N<WdbOC9m<YhbO@<fWP03=Ydj_SZn00@j_P04?]hj_S[N>[h8?]h02T;N?]hn
gSkN@_i2gT;n@]i2oT;N3T;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP08A_h04TLNA_i6oTKnAai6
oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP06Aah01D/NAai77TLNBah00dLN
01I;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai7
7P03Bah01DLNBai;7T/NAah02D/N00<004/NBah014/N1Goo00<007ooOol06goo000cOol00`00Oomo
o`0XOol0;TlNBae??T/MCai;7DlnBae?7T/MCci;7CJn<[hf_c:n3I/5N@VJ2GXIo1GK6O`R?2Hm8Q`R
?BYM;WdZGBin:UdbWRim<Yh^OC:N=Ydf_SJM=[hf_CZn=[dj_SJm0SZn00HngSZm?]hj_SkN?[h3?]h0
S3jn@_hngT;n?]i2oSkN@_hngT;n?]i2oSkNA_i2gT;n@]i6oT;NA_i2gTKn@_i6oT;NAai2oTKn@_i7
7T;nAai2oTLN@_i77T;nAai6oTLN@_i77TKnAai6oTLOA_i77TKnAam6oTLNA_i;7dKnAai6oT/OA_i7
7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;
7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;
7TLNBam77T/NAai;7dLNBai77T/OAai;7TLN00177T/NAai;7dLNBah6Ool00`00Oomoo`0JOol003=o
o`03001oogoo02Uoo`03Cai;7TlN009?7P05Bai?7TlNCai;7P02Cah01b9M=[hf_SJn3I/=VPUj008I
o0085M/Eg2Hm9SdR?2Hm:Ud^O@<ZG@06<YhbOC:N<YdbWSJM0SJN00<f_SZn>[h01CZn00@ngSZn?]hj
_PHngP04@]hngT;N?]h2@]h014;n@]i2oT;N24;n00a6oT;n@_i2oTKn@_i6oT;nA_i2oTKn@_h<A_h0
4TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP03Aah014Kn
Aai77T/N0dLN00E;7TLNAai77T/N00=77P0FBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;
7TLNBai77T/NAah3Bah01DLNBai;7T/NAah03d/N00<004/NBah01D/N1Goo00<007ooOol06Woo000c
Ool00`00Oomoo`0ZOol0=4lNBae??T/MCai;7DlnBae?7T/MCchNGB9N7UdRGPfJ3I/=VPfK6O/Io1WK
9SdR?2Hm8Q`V?BYM;WdZGBin<WdbWS9m<YhbOCJn=Ydf_SJM>[hf_CZn>[dj_SJm?]hj_SkN>[dngSZn
0SkN08i2gSkN?]hngT;n?]i2oSkN@_hngT;n?]i2oSkN@_i2gTKn@]i2oT;NA_i2oTKn@]i6oT;nA_i2
oTLN@_i6oT;nAai2oTLN@_i77T;nAai2oTLNA_i77T;nAai6oTLNA_i77dKnAai6oT/OA_i77TKnBam6
oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBah004/OAai;7TLNBam77PEoo`03001oogoo
01Yoo`00<goo00<007ooOol0:Woo0TlN00E;7TlNCai?7T/N00=?7P03Bai?7R9M00<RG@043IX=V`fJ
3IX36O`39Sd03b8l;Wd^OBim;Ud^OC:M<YhbOC:N<Ydf_SJN=[hfWP06>[h013kN>[hngSZn23kN00A2
gSkN@]hngP92gP04@_i2gT;n@]h8@_h01TKn@_i2oT;nA_i2oP=6oP03@_i6oTKn00Q6oP05Aai6oTKn
A_i77P03A_h01TLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP03Aah01DKnAai77T/NA_h00TLN00E;
7TKnAai77T/N00=77P05Bai77TLNAai;7P03Aah03T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3
Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00i;7P03001;7T/N00A;7PEoo`03001oogoo01Yo
o`00<goo00<007ooOol0:goo02a;7DlNBae??T/MCai;7DlnBae?7T/MCchNGB9N7UdE^a6j3I/=VQhL
7O`Io2Hl:UdV?2IM9S`^ORYM;WdZGBin<WdfWS9m=YhfWCJn=Ydj_SJM>[hj_C[N0SZn00Dj_CkN>[hn
gSZm00@ngP2=@]hngSkN?]i2oSkN@_hngT;n@]i2oSkN@_i2gT;n@]i6oT;N@_i2gTKn@_i6oT;NA_i2
oTKn@_i77T;nA_i2oTLN@_i77T;nAai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;7dKnAai6
oT/OA_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6
oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai7
7T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBal004/NAai;7dLNBai77T/O00Eoo`03001o
ogoo01Uoo`00<goo00<007ooOol0;7oo0TlN00E;7TlNCai?7T/N00=?7P03Bai?7PWK008RG@8A^`05
3I/=VQgl7O`N70059Sd3;Wd02BiM<YhbWC:N<YdbWSJn>[hfWP02=[h6>[h3?]h00cZn?]hngP06?]h2
@]h024;n?]i2oT;N@_i2gT;n@]h8@_h01TKn@_i2oT;nA_i2oP=6oP03@_i6oTKn00A6oP05Aai6oTKn
A_i77P03A_h02TLNA_i6oTKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3
Aah01D/NAai77TLNBah00dLN019;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah0
1DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00=;7P03Aai;7T/N00Y;7P03001;7T/N00E;7PEoo`03
001oogoo01Uoo`00<goo00<007ooOol0;Goo04U;7DlNBae??T/MCai;7DlnBae?7T/MCch9f`WL4IXE
^a6j5K/Mo1hL7O`N72Hl:UdV?2IM;UdbORiM;Wh^GCJN<WdfWS9m>[hfWCZn=Ydj_SJM>]hj_CkN>[hj
gSZm?]hj_SkN>[e2gSkN@]hngT;N?]i2oSkN@_hngT;n?]i2oT;N@_hngT;n@]i2oT;NA_i2gP02@_h0
MdKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN@_i77T;nAai6oTLN@_i77TKnAai6oTLNA_i77TKnAai6
oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7P00Bam77T/NAai;7dLNBah0
1Goo00<007ooOol06Goo000cOol00`00Oomoo`0^Ool2Cah01D/NCai?7TlNBah00dlN00E;7PVJ2M/9
g1GK00<A^`088Q`Mo1gl:UdV?BYM:SdZG@@^O@05<YdfWS:M=YhbW@02=[h00cZn=Yhf_P06>[h;?]h0
1T;n?]i2gT;N@_i2gP=2oP03@]i2oT;n00Q2oP03A_i2oT;n0096oP03@_i6oTKn00Q6oP05Aai6oTKn
A_i77P03A_h02TLNA_i6oTKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3
Aah06T/NAai77TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah0
1DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00i;7P03001;7T/N00E;7PEoo`03001oogoo01Uoo`00
<goo00<007ooOol0;Woo02Q??T/MCai;7DlnBae?7T/MCci;7DlNBad=V`Uj6M/E^aWL4KXR71gl8QdN
72YM9S`ZGBHm:Ud^OC9n;Ud^OS9m=YhbWCJN<Wdj_SJM>[hfW@8j_P08>]hj_CkN>[hngSZm?]hj_P8n
gP2=@_hngT;N?]i2oSkN@_hngT;n?]i2oSkN@_i2gT;n?]i6oT;N@_i2gTKn@]i6oT;nA_i2oTKn@_i7
7T;nA_i2oTLN@_i77T;nAai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;7dKnAai6oT/OA_i7
7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;
7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;
7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBal004/NAai;7dLNBai77T/O00Ioo`03001oogoo01Qo
o`00<Woo00<007ooOol0<7oo0dlN00=;7TlNCah01D;n0`VJ00@IfaGK5M/Ef`@R700B:UdV?BYM:Sdb
OBim<Wd^OCJN<YdfWS:M=Yhf_SZn=[hj_SJn1SZn2ckN00=2gT;n?]h00T;N00=2oT;N@_h00T;n00=2
gT;n@_h014;n00I6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP08A_h04TLNA_i6oTKnAai6oTLNA_i77TKn
Aai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP06Aah01D/NAai77TLNBah00dLN01I;7TLNBai7
7T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah01DLN
Bai;7T/NAah024/N1@001d/N1Woo00<007ooOol067oo000bOol00`00Oomoo`0aOol05DlnBae?7T/M
Cci;7D;n?]i2ockN@_h9NPfK2GXIfaFk6M`R72Hm7O`R7@02:Ud0TRXl;UdZGC9n;WdbORim=YhbWCJn
<YdfWSJM>[hfWCZn=YdngSZn?]hj_CkN?[hngSZm?]hn_T;N?]i2oSkN@]hngT;n?]i2oSkN@_hngT;n
@]i2oT;N@_i2gTKn@]i6oT;NA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAai2oTLN@_i77T;nAai2oTLN
A_i77T;nAai6oTLNA_i77TKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/N
A_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/O
Aai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBal:00003DLNBam77T/N001;7dLNBai77T/OAai;
7TLN00Eoo`03001oogoo01Qoo`00<Woo00<007ooOol0<Woo0dlN00=;7TlN@_h014;n00DEVQ6J2IXI
fagl008Ef`048Q`V?B8L9Q`4:Ud02S9m<Wh^OC9m=YdfWSJM=YhfWCJN2SZn1CkN00I2gSkN?]hngT;N
?]h2@]h01T;n@]i2gT;N@_i2gPY2oP06A_i2oTKn@_i6oT;n0dKn00=2oTKnA_h024Kn00i77TKnA_i6
oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3Aah01D/NAai7
7TLNBah00dLN019;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah014LNBai;7T/N
2@000d/N00=77T/NBah02D/N00<004/NBah01D/N1Goo00<007ooOol067oo000bOol00`00Oomoo`0c
Ool05DlnBae?7T/MCchVOBYn9WdZWRIm5K/AVQFk6M/Mo1WK9SdR72Hm8Q`V?@02:Ud06BXl;Ud^OC:N
;WdbWS:M=YhbWCJn<Ydj_SJM>[hf_CZn>[dngSZn?]hj_CkN?[hngSZm008ngP1R@]hngT;n?]i2gSkN
@_hngT;n?]i2oT;N@_i2gT;n@]i2oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77TKn
Aai2oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;7TKn
Bam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLN
Bai6oPX0000QBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLN0017
7T/OAai;7TLNBam77T/N00Aoo`03001oogoo01Qoo`00<Woo00<007ooOol0<goo00I;7TlNCai?7T/N
Cah2:Wh03BIn:WhI^aFJ4IXEVQWK7O`IfbHm8Q`V?B8L00<^G@04:UdbOC9m<Wh2<Wd01CJM=YhfWCJN
=Yd01SZn00@n_SZn?]hj_PHngP04@]hngSkN?]h4@]h00d;n@]i2gP02@_h00d;N@_i2oP06@_h024Kn
@_i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP04A_h04TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i7
7TKnAai6oP=77P05A_i77TLNBai6oP02Aah01D/NA_i77TLNBah00dLN00E;7TLNAai77T/N00=77P04
Bai77T/NAah900001DLNBai77T/NAah00d/N00E77T/NBai;7TLN00=;7P05Aai;7T/NBai77P0=Bah0
0`00Bai;7P06Bah5Ool00`00Oomoo`0GOol0039oo`03001oogoo03Aoo`0]Bae??T/MCai;7Dln9WdZ
ORIm:YhI^QFk4IXR71gk7O`V72Xm9S`V?B8L;WdZGBim:UdfWRim<Yh^OCJn=Ydf_SJM=[hfWCZn=[dj
_SZm?]hj_CkN>[hngSjm00<ngP1@?[dngSkN@_hngT;n?]i2oSkN@_hngT;n?]i6oT;N@_i2gTKn@]i6
oT;NA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;
7TKnAai6oT/NA_i77TKnBai6oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;
7PX0000dA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLN
Bam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAah004LNBai77T/OAai;7TLNBal5Ool00`00Oomo
o`0GOol0039oo`03001oogoo03Eoo`05Bai?7TlNCai;7P025O`01RYn9WhI^aVk6M/AVP<Qo0059S`V
?BHl9SdZG@03;Ud02S9m<YdbOC:N<WdfWSJM=YhfWCJN1CZn00@ngSZn?]hn_PPngP0:@]hngT;N?]i2
oT;N@_i2gT;n@]h3@_h014;N@_i2oTKn0d;n00I6oT;nA_i2oTKn@_h>A_h04TLNA_i6oTKnAai6oTLN
A_i77TKnAai6oTLNA_i77TKnAai6oP=77P06A_i77TLNBai6oTLN2@00019;7TLNBai77T/NAai;7TLN
Bai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00=;7P05Aai;
7T/NBai77P0<Bah00`00Bai;7P05Bah5Ool00`00Oomoo`0GOol0039oo`03001oogoo03Ioo`0UBae?
?T/MCai;7AGl5M`Eo1Vj7M/I^QWK7O/R71gk8Q`Z?2Xm9S`Z?BiM<Wd^GBim<WdfWS9m<YhbOCZn=Ydj
_SJM>[hj_CZn=[d00SZn00LngSZm?]hj_SkN?[e2gP02?]h0>cjm@_hngT;n?]i2oSkN@_hngT;n?]i2
oT;NA_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAai6oTLN@_i7
7TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_h02P0004M;7dKnBai6oT/OA_i;7TKnBam6
oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6
oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBah004/OAai;7TLNBam7
7T/N00Eoo`03001oogoo01Moo`00<Woo00<007ooOol0=goo0dKn00=77TKn5O`00QGl00DQfaVk6K/I
fbHL008Qo009:UdZ?2Xm9S`^OBiM;Wd^GBim008bW@03<WdbWSJM008fWP03=[hfWCZn00@j_P05?[hn
gSZn?]hn_P06?]h014;N?]i2gSkN0T;N00A2oT;N@_i2gPQ2oP06A_i2oT;n@_i6oT;n0dKn00=2oTKn
A_h034Kn00I77TKnA_i6oTLNA_h900000dKnAai6oP03Aah01DKnAai77T/NA_h00TLN01Y;7TLNAai7
7T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN
00=;7P05Aai;7T/NBai77P0BBah00`00Bai;7P05Bah6Ool00`00Oomoo`0FOol0039oo`03001oogoo
03Qoo`1FA_i;7TKnAahQ^QGl5M`QnagK8O`I^RHL8Q`V728L:UdZ?2YM:S`^OBiM<Wd^GCJN<WdfWS9m
=YhfWCZn=Ydj_SJM?[hj_CZn>[dn_SZn?]hj_CkN>[i2gSkM@]hngT;N?]i2oSkN@_hngT;n@]i2oSkN
@_i2gT;n@]i6oT;N@_i2gTKn@_i6oT;NA_i2oTKn@_i77T;nA_i2oTLN@_i77T;nAai2oTLN@_i77PX0
001KA_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBal004/NAai;7dLNBai7
7T/OAah01Goo00<007ooOol05Woo000aOol00`00Oomoo`0iOol03000=Ua6oTKnAahQ^R7J5O`Qnb7K
8O/Qf`@V7006;UdZ?2Xm:SdbOBim0S9m00PfWS:M=YdbWCJN=Ydj_SJN1SZn00HngSjn?]hn_SkN?[h6
?]h3@]h01ckN@]i2gT;n@]i2oT;N00Q2oP03A_i2oT;n0096oP04@_i6oTKnA_h90006A_h02TLNA_i6
oTKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P05A_i77TLNBai6oP02Aah05T/NAai77TLN
Bai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;
7T/NBai77P03Bah00dLNBai;7P0?Bah00`00Bai;7P05Bah5Ool00`00Oomoo`0FOol0035oo`03001o
ogoo03Yoo`0;>U`fFcYl=U`Ufb6j9M/Mfb7k7M/Qo0029Q`07B8L9Q`ZG2iM:S`^GBim<Wd^GC9n;Wdf
WS9m=YhfWCZn=Ydj_SJM>[hj_CkN>[dn_SZm?]hj_SkN>[d00SkN01I2gSkM@]hngT;n?]i2oSkN@_hn
gT;n@]i2oT;N@_i2gTKn@]i6oT;NA_i2gPX0001_A_i2oTLN@_i77T;nAai6oTLN@_i77TKnAai6oTLN
A_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/N
A_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/O
Aai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLN00177T/N
Aai;7dLNBai77T/O00Aoo`03001oogoo01Ioo`00<Goo00<007ooOol0>goo00/jG3IL>U`jG27J8KXQ
fRHK8O/Qfb7k008Z?08V708^G@08:Ud^GC9m<Wd^OC9m=YdfWP<fW@03>[hj_CZn00Lj_P<ngP04?[hn
gSkN@]h3?]h00d;N?]i2gP02@]h00ckN@_i2gP0900001D;nA_i2oTKn@_h00dKn00=2oTKnA_h024Kn
00E77TKnA_i6oTLN00=6oP0:Aai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00TLN00E;
7TLNAai77T/N00=77P0FBai77TLNAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3
Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN01=;7P03001;7T/N00I;7PEoo`03001oogoo01Eo
o`00<Goo00<007ooOol0>goo01@fG3YL=U/jO2Wj;Q/Q^RXL9O/Z72Gk:SdV72Xl9Q`^GBYL;UdZ?3JN
0c9m01PfWSJM=YhbOCJN=Ydj_SJM>[hfWCZn>[dngSZm?]hj_CkN?[hngSZm@]hngT;N?]d90000PT;N
@_i2gT;n@]i6oT;NA_i2gTKn@_i6oT;nA_i2oTLN@_i6oT;nAai2oTLN@_i77TKnAai2oTLNA_i77TKn
Aai6oTLNA_i77TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKn
Bai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKn
Bam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLN
00177T/OAai;7TLNBam77T/N1Goo00<007ooOol05Goo000aOol00`00Oomoo`0kOol03Chj?QXjG3IL
>U`Ynbgk:O/V72HK:Q`Unbhl008Z?005:Q`^GBiM<Ud^G@04<Wd01CJN=YdfWSJM=Yh00SZn00Hj_CZn
>[hn_SZn?[h:0003?]h01T;n@]i2gT;N@_i2gP=2oP03@]i2oT;n00A2oP06A_i2oTKn@_i6oT;n0dKn
00=2oTKnA_h024Kn00E77TKnA_i6oTLN00=6oP06Aai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=7
7P04A_i77TLNBah3Aah01D/NAai77TLNBah00dLN019;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77T/NAah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN019;7P03001;7T/N00E;7PH001Mo
o`00<Goo00<007ooOol0>goo00hn6D8j?QTn>ShI;Q/YnRhK:OXZ72Gk:Q`Z?2iM0RXl00H^G39m;Udb
OBiL=Yh3<Wd00cZn=YdfWP090000UCkN>[dngSjm?]hn_SkN?[e2oSkN@]hngD;n?]i2oSkN@_hngT;n
@]i2oT;N@_i2gTKn@]i6oT;NA_i2gTKn@_i6oT;nA_i2oTLN@_i6oT;nAai6oTLN@_i77TKnAai6oTLN
A_i77TKnAai6oTLNA_i77TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam6oT/N
A_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/O
Aai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/N
Aai;7`00Bai77T/OAai;7TLNBal01Goo00<007ooOol05Goo000aOol00`00Oomoo`0lOol033hJ?SXn
6Shj<Q/]nbWk;O/^72hl9Q/Z70<^?003;Sd^G@0000T00003=YhfWCZn008j_P05>[dj_Sjn?]hj_P02
?[h6?]h014;N?]i2gSkN0T;N00I2oT;N@]i2gT;n@]h3@_h014;N@_i2oTKn0d;n00A6oT;nA_i2oQ16
oP0>Aai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP03Aah014KnAai77T/N
0dLN019;7TLNAai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00d/N
00E77T/NBai;7TLN00=;7P05Aai;7T/NBai77P0@Bah00`00Bai;7P06Bah4Ool00`00Oomoo`0EOol0
035oo`03001oogoo03aoo`08?SXn6D8j?QTn>S8K=S/YnPT00003<U`bOC9M008bO@0E=YhbOCJN=Ydj
_SJM>[hfWCZn>[dj_SZM>[hj_CkN>[dngSZm?]hn_D;N008ngP2=?]e2oSkN@]hngD;n?]i2oSkN@_hn
gT;n@]i6oT;N@_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAai6oTLN@_i77TKnAai6
oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam6
oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6
oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam7
7T/NAah004LNBai77T/OAai;7TLN00Aoo`03001oogoo01Eoo`00<Goo00<007ooOol0>Woo2P0000Hf
6bhl;Q`^?2hL<Ud3;S`0139m<UdbOC9m0cJM00LfOCZn=YdjWSJM>[hj_@03>[h01SZm?[hn_SkN>[hn
_PLngP=2gP05?]i2oT;N@_i2gP03@_h00d;N@_i2oP04@_h00dKn@_i6oP02A_h00d;nA_i6oP0<A_h0
4TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNBai6oP02Aah01D/N
Aai77TLNBah00dLN019;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;
7T/NAah00d/N00E77T/NBai;7TLN01M;7P03001;7T/N00E;7PAoo`03001oogoo01Eoo`00<Goo00<0
07ooOol0<Goo2@000Woo011:FTIIBUY6FDYJ<Q/f>c8K=S/b?39L:Q/^?2iL<Ud^?08bG@0F<WdbG39m
<UdfWSIm=YhfOCZn=Ydj_SJM>[hj_Cjn>[dn_SZm?]hn_CkN>[d3?]h0Scjm@]hngT;N?]e2oSkN@]hn
gD;n@]i2oSkM@_i2gT;n@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@_i6oT;nA_i2oTLN@_i6oT;nAai6
oTLN@_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai7
7T/OAai;7TLNBam77P00Aai;7dLNBai77T/OAah017oo00<007ooOol05Goo000`Ool00`00Oomoo`0X
Ool:000<Ool2AUX02DYJAUU6FSYK=S/b6cHk<S`bG002<S`0139L<Ud^G39M0SIm00<bOCIm=Yd013JM
00Hj_SZM>[hjWCZn>[d3>[h01CZm?]hn_SkN?[h00SkN00I2gSkN?]hngT;N?]h4@]h014;n@]i2oT;N
0d;n00A2gT;n@_i6oP=2oP03A_i2oTKn0096oP03@_i6oTKn00a6oP0BAai6oTKnA_i77TKnAai6oTLN
A_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai;7TKn00977P0FBai77TLNAai;7TLNBai77T/NAai;
7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN01U;7P03
001;7T/N00E;7PAoo`03001oogoo01Eoo`00<7oo00<007ooOol07goo2@005Woo01E6FDYJAUU:FTII
?U`j>ciK>S/fG38l<U`b>cIm<U`bGBhl=YdbOCIm<Wd00SJM0:<jWSJM>YhfWCZn=Ydj_SZM?[hj_CkN
>[dn_Sjm?]hn_CkN?[e2gSkN@]hn_D;N?]i2oSkM@_hngT;n@]e2oT;N@_i2gDKn@]i6oT;NA_i2gTKn
@]i6oT;nA_i2oTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oT/N
A_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/OA_i;7TKnBam6oT/N
A_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/O
Aai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/O001;7TLNBam77T/N
Aai;7`04Ool00`00Oomoo`0DOol0031oo`03001oogoo01Eoo`X0021oo`0AAUU6FTIJBUY6FCiK>U/n
FcYK>U`b?39L<S`fOCIM=WdbG003=Wd03c9m>YdfWCZM=YdjWCZm>[hj_CZn>[dn_SZm?[hj_P02?[h3
?]h01Cjn@]hngT;N?]h00d;N00TngT;N@]i2oT;N@_i2gT;n@]h01T;n00I6oT;nA_i2oTKn@_h3A_h0
0d;nA_i6oP0<A_h03TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77T/NA_h00TLN
00E;7TKnAai77T/N00=77P0BBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E7
7T/NBai;7TLN00=;7P05Aai;7T/NBai77P0HBah00`00Bai;7P05Bah4Ool00`00Oomoo`0DOol0031o
o`03001oogoo00aoo`T002Yoo`2iBUY6FDYJAUU:FSXk?U`j>ciK=U`jO3IL>W`bG3Im<U`fOC9L>Ydf
OCZM=WdjWSJM>YhfWCZN>Ydj_SZM?[hjWCkN>[dngSZm?]hn_CkN?[dngSkM@]hngT;N?]e2gSkN@_hn
gD;n?]i2oT;MA_i2gT;n@]i6oT;NA_i2gTKn@_i6oT;NA_i2oTKn@_i77T;nA_i2oTLNA_i77T;nAai6
oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai7
7T/OAai;7TLNBam77T/N001;7dLNBai77T/OAai;7P04Ool00`00Oomoo`0DOol0031oo`03001oogoo
009oo`X003=oo`0GCWUBNTiiCWY>NE9j@W/nFcYK?U/fG3YL=U`jG3Il>WdfOCYm=W`fWCIm=YdfO@04
>Yd01CZn>[dj_SZm>[h00Sjn00<n_Cjn?[h01SkN00A2gSkN@]hngPI2gP04@_i2gT;n@]h4@_h024Kn
@_i6oT;nA_i2oTKn@_h<A_h01DLNA_i6oTKnAah00dKn00i77TKnAai6oTLNA_i77TKnAai6oTLNA_i7
7TKn0dLN00E6oTLNAai;7TKn00977P05Bai77TLNAai;7P03Aah04T/NAai;7TLNBai77T/NAai;7TLN
Bai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah01DLNBai;7T/NAah05T/N00<004/NBah0
1D/N17oo00<007ooOol057oo000`Ool5000mOol0^E:JCWUBVTiiDYY>ND9k@U]6O49K>W`fG3Yl=U`j
OCIl>WdfO3Ym=WdjWCIm>YdfWCZn>Ydj_SJM?[hj_Cjn>Ydn_SZm?]hj_CkN?[e2gSjm@]hn_D;N?]e2
oSkN@]hngD;n@]i2oSkM@_i2gT;n@]e6oT;NA_i2gTKn@]i6oT;NA_i2oTKn@]i6oT;nA_i2oTLN@_i6
oT;nAai6oTLN@_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;
7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;
7dLNBai77T/OAai;7TLNBam77T/NAai;7dLN00177T/OAai;7TLNBal017oo00<007ooOol057oo000a
Ool00`00Oomoo`0oOol01TijCWUBNTiiCWY>N@A2N`09?W`jO3il?W`jOCIl>WdfOCYm00PjW@05>[dn
_SZm?[hj_@02?[h00ckN?[dn_P05?]h00d;N?]i2gP05@]h00d;n@]i2gP02@_h014;N@_i2oTKn0d;n
00=6oT;nA_h00TKn00=2oTKnA_h034Kn00E77TKnA_i6oTLN00=6oP06Aai6oTLNA_i77TKn0dLN00E6
oTLNAai77TKn00977P05Bai6oTLNAai;7P03Aah04T/NAai77TLNBai77T/NAai;7TLNBai77T/NAai;
7TLNBai77P=;7P05Aai;7T/NBai77P03Bah01DLNBai;7T/NAah07D/N00<004/NBah01D/N0goo00<0
07ooOol057oo000bOol00`00Oomoo`0nOol05diiDYY>NE:JCWUBVT9K@W]2FdIl>W`nO3Yl?W`jO3jM
>W`nWCYl>YdfOCZM>Wd00SZM0:0n_SZM?[hjWCjn>[dn_SZM?]hn_CkN?[dngSkM@]hn_D;N?]e2gSkM
@_hngT;N?]e2oT;N@_hngDKn@]i2oT;MA_i2gTKn@]i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i77T;n
Aai2oTLNA_i77T;nAai6oTLNA_i77TKnAai6oT/NA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLN
Bai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLN
Bam77T/NAai;7dLNBai77T/OAai;7TLN00177T/NAai;7dLNBai77P=oo`03001oogoo01Aoo`00<goo
00<007ooOol0?Goo1UJI0dZK00a6NdZK?W`nO3Yl?W`jOCZM>W`jWCYm?Yd3>Yd02SZm>Ydj_CZM>[dn
_Cjn?[dn_Sjm0Sjn00DngSjm?[hngT;N008ngPU2gP03@_i2gT;n0092oP09@]i2oT;nA_i2oTKn@_i6
oT;n00=6oP03@_i6oTKn00a6oP0>Aai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLN
Bai6oP02Aah01D/NA_i77TLNBah00dLN019;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/N
Aah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN01];7P03001;7T/N00I;7P9oo`03001oogoo
01Aoo`00=7oo00<007ooOol0?7oo0eJI0;MF^UJIEYUFVDZKAW]:VdIk@Y`nO4:L?Wa2W3Yl?YdjO3jM
>YdnWCZM?[djWCjn>Ydn_SZM?[hj_Cjn>[dn_Sjm@]hn_D;N?[e2gSkM@]hn_D;N?]i2gSkM@_hngT;n
@]e2oT;N@_i2gDKn@]i6oT;MA_i2oTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77TKnAai2oTLN
A_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/N
A_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/O
Aai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/N
Aai;7dLNBai77T/OAai;7P00Bam77T/NAai;7dLNBah00Woo00<007ooOol057oo000eOol00`00Oomo
o`0lOol6EYT01DIkBY]:VdZKAW/00d:L00Q2O3jM?YdnWCjL?YdjWCjM0SZM00<n_Cjn?[d00Sjm00hn
_Sjm?[hn_Cjn?[dngSjn?]hn_D;N?]i2gSkN1T;N00I2oT;N@_i2gT;n@]h2@_h01TKn@]i6oT;nA_i2
oP=6oP03@_i6oTKn00a6oP0BAai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6
oTLNAai;7TKn00977P0FBai77TLNAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3
Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN01i;7P03001;7T/N00E;7P9oo`03001oogoo01Ao
o`00=Woo00<007ooOol0>goo04UF^UJIEYUFVEJjEYU:VdIkBY]6NdZK?Wa2W3il@Y`nO4:M?Y`nWCjL
?[dnWCjm?Ydn_CZM?[hjWCjn>YdngSjm@]hn_D;N?[e2gSjm@]hn_D;N?]e2gSjm@_i2gT;n?]e2oT;N
@_i2gDKn@]i2oT;MA_i2gTKn@]e6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i77P02A_h0KT;nAai6oTLN
A_i77TKnAai6oTLNA_i77TKnBai6oTLNA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/N
A_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/N
A_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/O
Aai;7TLNBam77T/NAai;7`00Bai77T/oAai;7TLNBcl2Ool00`00Oomoo`0DOol003Moo`03001oogoo
03]oo`=FV@=J^@05C[]>VdjKCY]>^`04AY`02CjL?YdnWCjM?Y`n_CjM?[dnW@02?[d02Sjn?[dn_Cjm
?[hn_Cjn?[e2gSjm0SkN34;N00I2oT;N@_i2gTKn@]h2@_h01TKn@_i6oT;nA_i2oQ96oP0BAai6oTKn
A_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i;7TKn0TLN00I;7TKnAai77T/NA_h2Aah05T/NAai77TLN
Bai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;
7T/NBai77P0LBah00`00Bai;7P05Bah2Ool00`00Oomoo`0DOol003Qoo`03001oogoo03Yoo`2kFYQN
^EZiG[UJV5jiCY]>^dZJC[]>VdJl@Ya6_4:LA[`nW4:m@Ya2_CjM?[dnWCjm?Ye2_Sjm?[hn_D:n?[e2
gSjm@]hn_D;N?[e2gSjm@]hngD;N?]e2gT;M@_i2gT;n@]e2oT;NA_i2gDKn@]i6oT;MA_i2gTKn@]i6
oT;nA_i2gTKn@_i6oT;nAai2oTLN@_i77TKnAai2oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i7
7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;
7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;
7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLN00177T/NAai;
?dLNBai77Woo00005Woo000iOol00`00Oomoo`0iOol7F[T00djKC[]>V`02CY/4AY`02D:m@Ya2WD:M
@[dn_D:m?[e2_@03?[d01cjn?[dn_Cjm@]hn_Cjn0092gP03?]e2gT;N00Y2gP0<@_i2gT;n@]i2oT;N
A_i2oTKn@_i6oT;n0dKn00=2oTKnA_h044Kn00i77TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKn0TLN
00I;7TKnAai77T/NA_h2Aah04T/NA_i;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05
Aai;7T/NBai77P03Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN01];7P03001;7T/N00E;7P03
Ool007oo01Eoo`00>Woo00<007ooOol0>Goo0;=N^EZHG[UJ^EjiFYQ>^djKC[]:VTjk@Ya6_4:LA[a2
W4:m?Ya2_D:L@[dnWD:m?Ye2_CjM@]hn_D:n?[e2gSjm@]hn_D;N?[e2gSjm@]hn_D;N?]e2oT;M@]i2
gDKn@]i2oT;MA_i2gTKn@]e6oT;NA_i2gDKn@]i6oT;NA_i2oTKn@]i77T;nA_i2oTLNA_i77T;nAai6
oTLNA_i77TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai7
7T/OAai;7TLNBam77T/NAai;7dLN00177T/O009;7P03Aai;?d/N009oo`03001oogoo01=oo`00>goo
00<007ooOol0>7oo1EZi00=RfE:jD[/00U:k00=B^U:kB[`014Zl00=6_D:lA[d00T:m00dn_D:m?[e2
_Cjm@[dn_D:m?[e2gT:m@]hn_@03@]h00d;M@]i2gP04@]h01T;n@]i2gT;N@_i2gP92oP0:A_i2gT;n
@_i6oT;nA_i2oTKn@_h>A_h01DLNA_i6oTKnAah00dKn00i77TKnA_i6oTLNA_i77TKnAai6oTLNA_i7
7TKn0TLN00I;7TKnAai77T/NA_h2Aah04T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai7
7P=;7P05Aai;7T/NBai77P03Bah01DLNBai;7T/NAah08T/N00<004/NBah014/N0Woo00<007ooOol0
4goo000lOol00`00Oomoo`0hOol05EZiG[UN^6;IG[QRfE:jD[]B^U:kD[Y:_4JLB[a6VdZl@[a6_D:L
A[e2_002@[d0WD;M@[e2_Cjm@]i2_D;N?[e2gSjm@]hn_D;N@]e2gSjm@]i2gD;n@]e2oT;MA_i2gDKn
@]i6oT;MA_i2gTKn@]e6oT;nA_i2gDKn@_i6oT;mA_i2oTKn@_i77T;nA_i2oTLNA_i77T;nAai6oTLN
A_i;7TKnAai6oT/NA_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/N
A_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/N
A_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/O
Aai;7TLNBam77T/NAai;7`00Bai77T/o009;7P04Aai;?goo000EOol003eoo`03001oogoo03Moo`08
G]UN^6;IG[QNfEjhD[]B^P=B^`03D[Y:_4Zl00=:_004@[e6_D:lA[d5@[d014;M@[e2_D:m0T;M00A2
gT;M@]i2g@=2gP03@]e2gT;N00A2gP0:@_i2gT;n@]i2oT;NA_i2oTKn@]h3A_h00d;nA_i6oP0@A_h0
1DLNA_i6oTKnAah00dKn00Y77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNBai6oP02Aah05T/N
Aai77TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;
7P05Aai;7T/NBai77P0PBah00`00Bai;7P05Bah00goo001oo`0DOol003ioo`03001oogoo03Ioo`0F
G[QRfEjhH]UN^6;IE[YFfeJjE]]F^UKKB[]>g4ZkC]a:^d[MA[a:gDJlB]d3@[d0;D;M@[e2gSjm@]i2
_D;N@[e2gT:m@]i2gD;N@]e2gT;M@]i2gDKn@]e6oT;MA_i2gDKn@]e6oT;MA_i2gTKn@]e6oT;nA_i2
gDKn@_i6oT;mA_i2oTKn@_i77P03A_h0JDLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/NA_i77TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NAai;7TKnBai77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam7
7T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/N001;7`02Bah0
1TLNBcm;7T/NOol001Eoo`00?goo00<007ooOol0=Goo00ERfEjhG]UN^6;I009Rf007E[YFfeJjE]YF
^UKKB[`00djl00Y:_4JmA[e6_DJlA[e2_DKM@[e6_@92g@09@[e2gD;M@]i2gD;N@]e2gT;M00=2gP03
@]e2gT;N00A2gP0:A_i2gT;n@]i6oT;nA_i2oTKn@_h3A_h00d;nA_i6oP0@A_h03TLNA_i6oTKnAai6
oTLNA_i77TKnAai6oTLNA_h2Aah01T/NA_i77TLNBai6oP977P05Bai6oTLNAai;7P03Aah02T/NAai;
7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;7T/NBai77P0WBah00`00Bai;7P04
Bah00goo001oo`0DOol0041oo`03001oogoo03Eoo`12H]UN^6;IH]QVf6;HE]]F^UKKE[YFfeJjC]a:
^dkLB[]>g4JlB]e6_4[MA[a6gD:mA]e2_DKM@[e6gT:mA]i2_DKN@[e6gT;MA]i2gDKn@]e6gT;MA_i2
gDKn@]e6oT;MA_i2gDKn@]i6oT;MA_i2gTKn@]e6oT;nA_i2gDKn@_i6oT;m0dKn06i2oTLNA_i77TKn
Aai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7TLNBai6oT/OAai;7TKn
Bam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLN
Bai77T/OAai;7TLNBam77T/NAai;7dLN00177T/o0T/N00A77T/oBah001Eoo`00@Goo00<007ooOol0
=7oo00=N^6;HH]P016;H00=FfUJjE]/00e[J00YBg4jkC]a>g5;LB[a:gDZlB]e:_0=6g@05A[e2gD;M
@]e2_@02@]d01T;N@]e2gT;M@]i2g@I2gP06A_i2gTKn@_i6oT;N0dKn00=2oTKnA_h064Kn00i77TKn
A_i6oTLNA_i77TKnAai6oTLNA_i77TKn0TLN00I;7TKnAai77T/NA_h2Aah04T/NAai;7TLNBai77T/N
Aai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah01DLNBai;7T/NAah09D/N00<0
04/NBah01D/N00<007ooOol04goo0012Ool2000dOol02FKIH]QVf6;HI]URf6KHE]YJf`02F]X0=UKJ
F]]>^e;LC[]Bg4jkB]e6_4[MB[a:gDJmA]e6_DKMA[e6gT;MA]i2_DKN@]e6gT;MA]i2gDKn@]e6oT;M
A_i2gDKn@]e6oT;MA_i2gDKn@]e6oT;NA_i2gDKn@]i6oT;MA_i2oTKn@_e77P96oP1Z@_e77TKnAai6
oTLNA_i77TKnBai6oTLNA_i;7TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6
oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7dLNBai6
oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam7
7T/NAai;7dLNBai77T/OAai;7TLNBal2Bah00dLN001;7P06Ool00`00Oomoo`0COol004Aoo`03001o
ogoo035oo`IRf003I]QVn5[J00EJfP03C]aBg4jk009>g006B]e:_4[MB[a:gDJm0dKM01E6_DKMA]e6
gD;MA]e2gDKN@]e6gT;NA]i2gDKN@]i6gT;NA_i6gTKn@]h00dKn00=2gTKnA_h054Kn00E77TKnA_i6
oTLN00=6oP0>Aai6oTLNA_i77TKnAai6oT/NA_i77TKnBai6oP977P06Bai6oTLNAai;7TKn0TLN019;
7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00d/N00=77T/N
Bah05d/N3goo00<007ooOol017oo00<007ooOol04goo0015Ool00`00Oomoo`0aOol02V;HI]URf6KH
I]MVn6KGF]YFfU[K0U[J02eFfUKLD]]Bg5;KE]a:g4kMB[a>gD[LB]e6_4[MA]e:gDKMA]i6gDKNA]e6
oT;MA_i2gDKn@]e6oT;MA_i2gDKn@]e6oT;MA_i2gDKn@]e6oT;MA_i2oTKn@]d00dKn00I2oDKnA_i6
oTKmAah2A_h0C4KmAai6oTLNA_i77TKnAai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKn
Bai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai77T/NA_i;7TLN
Bai6oT/NAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/N87oo00<007ooOol017oo00<0
07ooOol04goo0016Ool00`00Oomoo`0`Ool3H]P00fKHI_QVf002I]P3F]X04UkJG_YBfe;LD]]Bg5;K
D]a:g4kMB]a>g4[LB]e6gD[MA]e:g@M6g@06A]i6gDKMA]i6oTKM0TKN00A6oTKNA_i6gQa6oP05Aai6
oTKnA_i77P03A_h01TLNA_i77TKnAai6oP977P06Bai6oTLNAai;7TKn0TLN01I;7TKnBai77T/NA_i;
7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P03Aai;7T/N031oo`03001oogoo00Aoo`03
001oogoo01=oo`00Agoo00<007ooOol0<7oo03IVf6KGI_QVefKhI]MVn5[JG_YJfEkjF]YNnU;KE]aB
fe;LD]]>gD[LC]e:_4kMA]e:gDJlB]e6gDKNA]e6gTKMA]i2gDKn@]e6oT;MA_i2gDKn@]e6oT;MA_i2
gDKn@]e6oT;MA_i2gDKn@]d3A_h01D;MA_i6oTKn@_d00dKn00=6oDLNA_h00TKn02A;7TKnAai6oT/N
A_i77TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/NA_i;7TKnBai6oT/N
A_i5Ool00`00Oomoo`04Ool00`00Oomoo`0COol004Qoo`03001oogoo02moo`03I]QVn6KH009Vf006
I_QVeekJG]YNnU[J0UkJ;Woo2TKnJgoo00<007ooOol00goo00<007ooOol04goo0019Ool00`00Oomo
o`0^Ool02fKhI]MVn6KGI_QVef[hI]MNnU[JG_X0YGoo00<007ooOol017oo00<007ooOol04Woo001:
Ool00`00Oomoo`0]Ool3I]P01FKhI]MZmfKgJ_P0Z7oo00<007ooOol017oo00<007ooOol04Woo001;
Ool00`00Oomoo`0]Ool01VKGI_QVef[hI]MZn:Yoo`03001oogoo00=oo`03001oogoo019oo`00C7oo
00<007ooOol0;7oo00IVn6KGJ_MVmf[hI]NZOol00`00Oomoo`03Ool00`00Oomoo`0BOol004eoo`03
001oogoo02]oo`05I]MZn6KGJ_QVe`2[Ool00`00Oomoo`03Ool00`00Oomoo`0BOol004ioo`03001o
ogoo02Yoo`05J_MVmf[hI]MZm`2[Ool00`00Oomoo`03Ool00`00Oomoo`0BOol004moo`03001oogoo
02Yoo`03J_QVef[h0:eoo`03001oogoo009oo`03001oogoo019oo`00D7oo00<007ooOol0:Goo00=V
ef[gOol0[Goo00<007ooOol00Woo00<007ooOol04Woo001AOol00`00Oomoo`0YOol00fKGOomoo`2/
Ool00`00Oomoo`02Ool00`00Oomoo`0BOol0059oo`03001oogoo02Qoo`03001oogoo0:aoo`03001o
ogoo009oo`03001oogoo019oo`00Dgoo00<007ooOol09goo00<007ooOol0[Goo00D007ooOomoo`00
01Aoo`00E7oo00<007ooOol09Woo00<007ooOol0[Goo00D007ooOomoo`0001Aoo`00EGoo00<007oo
Ool09Goo00<007ooOol0[Goo00D007ooOomoo`0001Aoo`00EWoo00<007ooOol097oo00<007ooOol0
[Goo00D007ooOomoo`0001Aoo`00Egoo00<007ooOol08goo00<007ooOol0[Woo00D007ooOomoo`00
01=oo`00F7oo00<007ooOol08Woo00<007ooOol0[Woo00D007ooOomoo`0001=oo`00FGoo00<007oo
Ool087oo00<007ooOol0[goo00D007ooOomoo`0001=oo`00FWoo00<007ooOol07goo00<007ooOol0
[goo00D007ooOomoo`0001=oo`00Fgoo00<007ooOol07Woo00<007ooOol0/7oo00@007ooOol001=o
o`00G7oo00<007ooOol07Goo00<007ooOol0/7oo00@007ooOol001=oo`00GGoo00<007ooOol077oo
00<007ooOol0/7oo00@007ooOol001=oo`00GWoo00<007ooOol06goo00<007ooOol0/Goo00<007oo
00004goo001OOol00`00Oomoo`0JOol00`00Oomoo`2aOol00`00Ool0000COol0061oo`03001oogoo
01Uoo`03001oogoo0;5oo`03001oo`0001=oo`00HGoo00<007ooOol067oo00<007ooOol0/Goo00<0
07oo00004goo001ROol00`00Oomoo`0GOol00`00Oomoo`2bOol2000COol006=oo`03001oogoo01Io
o`03001oogoo0;9oo`8001=oo`00I7oo00<007ooOol05Goo00<007ooOol0/Woo0P004goo001UOol0
0`00Oomoo`0DOol00`00Oomoo`2bOol00`00Ool0000BOol006Ioo`03001oogoo01=oo`03001oogoo
0;=oo`80019oo`00Igoo00<007ooOol04Woo00<007ooOol0/goo0P004Woo001XOol2000BOol00`00
Oomoo`2cOol2000BOol006Yoo`03001oogoo00moo`03001oogoo0;=oo`80019oo`00Jgoo00<007oo
Ool03Woo00<007ooOol0]7oo00<007ooOol047oo001/Ool00`00Oomoo`0=Ool00`00Oomoo`2^Ool7
000BOol006eoo`03001oogoo00aoo`03001oogoo0:9oo``001Uoo`00KWoo00<007ooOol02goo00<0
07ooOol0UWoo30009Goo001_Ool00`00Oomoo`0:Ool00`00Oomoo`2:Ool<000aOol0071oo`03001o
ogoo00Qoo`03001oogoo07ioo`d003eoo`00LGoo00<007ooOol01goo00<007ooOol0LWoo3000BWoo
001bOol00`00Oomoo`06Ool00`00Oomoo`1VOol<001FOol007=oo`03001oogoo00Eoo`03001oogoo
05Yoo``0069oo`00M7oo00<007ooOol017oo00<007ooOol0CGoo3@00KWoo001FOol3000LOol00`00
Oomoo`03Ool00`00Oomoo`11Ool<001kOol005Moo`03001oogoo01aoo`03001oogoo009oo`03001o
ogoo03Eoo``008Moo`00Egoo100077oo00D007ooOomoo`0002Yoo`d009=oo`00Egoo00D007ooOomo
o`0001aoo`04001oogoo000NOol<002POol005Moo`05001oogooOol0000MOol00`00Ool0000BOol<
002/Ool005Moo`05001oogooOol0000NOol20006Ool<002hOol005Moo`80009oo`03001oogoo01eo
o`L00<Aoo`00EWoo0P0000=oo`000000jgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7Ool0
0?moodMoo`00ogooAgoo003oOom7Ool009aoo`80009oo`8000Yoo`@000Eoo`8000Eoo`@000Aoo`<0
07moo`00WGoo00@007ooOol0009oo`H0009oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03
001oogoo009oo`04001oogoo0003Ool00`00Oomoo`1lOol009ioo`8000]oo`03001oogoo009oo`03
001oogoo00Qoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo07aoo`00WWoo0P000goo1P00
0Woo00<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0
O7oo002MOol01000Oomoo`002Woo00<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<0
07ooOol00Woo0P00Ogoo002LOol20002Ool20009Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00
Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`1lOol00:]oo`03001oogoo009oo`03001oogoo00Qo
o`03001oogoo009oo`04001oogoo0003Ool00`00Oomoo`1lOol00:aoo`@000aoo`@000Aoo`<007mo
o`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7Ool00001\
\>"],
  ImageRangeCache->{{{0, 325.938}, {230.375, 0}} -> {-0.170246, 0.0462355, \
0.00438569, 0.00438569}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70824 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.10169 -0.148196 1.10169 [
[.5 .72074 -20 0 ]
[.5 .72074 20 15 ]
[.44797 -0.02478 -4.90556 -15 ]
[.44797 -0.02478 5.09444 0 ]
[.15892 .66839 -5.31917 0 ]
[.15892 .66839 4.68083 15 ]
[-0.06694 .27471 -10 -6.62571 ]
[-0.06694 .27471 0 8.37429 ]
[ 0 0 0 0 ]
[ 1 .70824 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .72074 -81 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.04) show
99.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.02946 .11175 m
.89362 0 L
s
gsave
.44797 -0.02478 -65.9056 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .4272 m
.29069 .70824 L
s
gsave
.15892 .66839 -66.3192 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.02946 .11175 m
0 .4272 L
s
gsave
-0.06694 .27471 -71 -10.6257 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(q) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.29069 .70824 L
s
.29069 .70824 m
.30155 .45044 L
s
.30155 .45044 m
.02946 .11175 L
s
.89362 0 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.89362 0 m
.02946 .11175 L
s
.30155 .45044 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.29069 .70824 L
s
.29069 .70824 m
.30155 .45044 L
s
0 0 m
1 0 L
1 .70824 L
0 .70824 L
closepath
clip
newpath
.872 .759 .735 r
.28887 .59047 .29487 .60897 .31582 .56837 .30978 .55403 Mtetra
.804 .762 .815 r
.30978 .55403 .31582 .56837 .33577 .55052 .32976 .53834 Mtetra
.736 .76 .872 r
.32976 .53834 .33577 .55052 .35538 .54176 .34944 .53085 Mtetra
.682 .756 .907 r
.34944 .53085 .35538 .54176 .37489 .5371 .36904 .527 Mtetra
.644 .754 .929 r
.36904 .527 .37489 .5371 .39439 .53445 .38863 .5249 Mtetra
.62 .753 .942 r
.38863 .5249 .39439 .53445 .41392 .53281 .40827 .52364 Mtetra
.604 .755 .95 r
.40827 .52364 .41392 .53281 .43351 .5317 .42796 .5228 Mtetra
.595 .757 .955 r
.42796 .5228 .43351 .5317 .45315 .53084 .44772 .52215 Mtetra
.589 .759 .959 r
.44772 .52215 .45315 .53084 .47287 .5301 .46755 .52157 Mtetra
.586 .762 .962 r
.46755 .52157 .47287 .5301 .49265 .5294 .48746 .52099 Mtetra
.585 .764 .964 r
.48746 .52099 .49265 .5294 .51251 .52869 .50743 .52038 Mtetra
.584 .767 .966 r
.50743 .52038 .51251 .52869 .53243 .52795 .52748 .51971 Mtetra
.584 .769 .967 r
.52748 .51971 .53243 .52795 .55243 .52717 .5476 .51898 Mtetra
.584 .771 .968 r
.5476 .51898 .55243 .52717 .5725 .52633 .5678 .51819 Mtetra
.584 .773 .969 r
.5678 .51819 .5725 .52633 .59264 .52544 .58807 .51733 Mtetra
.585 .775 .97 r
.58807 .51733 .59264 .52544 .61285 .52449 .6084 .51641 Mtetra
.585 .776 .97 r
.6084 .51641 .61285 .52449 .63313 .52349 .62882 .51543 Mtetra
.586 .778 .971 r
.62882 .51543 .63313 .52349 .65349 .52244 .6493 .51439 Mtetra
.586 .779 .971 r
.6493 .51439 .65349 .52244 .67391 .52134 .66985 .5133 Mtetra
.587 .78 .972 r
.66985 .5133 .67391 .52134 .6944 .5202 .69048 .51216 Mtetra
.588 .781 .972 r
.69048 .51216 .6944 .5202 .71497 .51901 .71118 .51097 Mtetra
.588 .782 .972 r
.71118 .51097 .71497 .51901 .73561 .51778 .73195 .50974 Mtetra
.589 .783 .972 r
.73195 .50974 .73561 .51778 .75631 .51651 .75279 .50847 Mtetra
.589 .784 .973 r
.75279 .50847 .75631 .51651 .77709 .51521 .77371 .50716 Mtetra
.59 .784 .973 r
.77371 .50716 .77709 .51521 .79794 .51387 .79469 .50581 Mtetra
.59 .785 .973 r
.79469 .50581 .79794 .51387 .81886 .5125 .81575 .50443 Mtetra
.59 .786 .973 r
.81575 .50443 .81886 .5125 .83985 .5111 .83688 .50301 Mtetra
.591 .786 .973 r
.83688 .50301 .83985 .5111 .86091 .50966 .85809 .50157 Mtetra
.591 .787 .973 r
.85809 .50157 .86091 .50966 .88204 .50821 .87936 .5001 Mtetra
.591 .787 .974 r
.87936 .5001 .88204 .50821 .90325 .50672 .90071 .4986 Mtetra
.592 .788 .974 r
.90071 .4986 .90325 .50672 .92453 .50521 .92213 .49707 Mtetra
.92213 .49707 .92453 .50521 .94588 .50368 .94363 .49552 Mtetra
.592 .789 .974 r
.94363 .49552 .94588 .50368 .9673 .50213 .9652 .49395 Mtetra
.9652 .49395 .9673 .50213 .9888 .50055 .98684 .49236 Mtetra
.859 .754 .745 r
.28282 .57179 .28887 .59047 .30978 .55403 .30367 .53953 Mtetra
.787 .755 .824 r
.30367 .53953 .30978 .55403 .32976 .53834 .32368 .52602 Mtetra
.719 .752 .878 r
.32368 .52602 .32976 .53834 .34944 .53085 .34343 .51981 Mtetra
.667 .749 .911 r
.34343 .51981 .34944 .53085 .36904 .527 .36311 .51678 Mtetra
.632 .748 .931 r
.36311 .51678 .36904 .527 .38863 .5249 .3828 .51522 Mtetra
.61 .748 .943 r
.3828 .51522 .38863 .5249 .40827 .52364 .40254 .51435 Mtetra
.597 .751 .951 r
.40254 .51435 .40827 .52364 .42796 .5228 .42235 .5138 Mtetra
.589 .754 .956 r
.42235 .5138 .42796 .5228 .44772 .52215 .44222 .51336 Mtetra
.585 .757 .96 r
.44222 .51336 .44772 .52215 .46755 .52157 .46217 .51293 Mtetra
.583 .76 .963 r
.46217 .51293 .46755 .52157 .48746 .52099 .48219 .51247 Mtetra
.582 .763 .965 r
.48219 .51247 .48746 .52099 .50743 .52038 .50229 .51195 Mtetra
.581 .765 .966 r
.50229 .51195 .50743 .52038 .52748 .51971 .52246 .51135 Mtetra
.582 .768 .968 r
.52246 .51135 .52748 .51971 .5476 .51898 .54271 .51068 Mtetra
.582 .77 .969 r
.54271 .51068 .5476 .51898 .5678 .51819 .56303 .50993 Mtetra
.583 .772 .969 r
.56303 .50993 .5678 .51819 .58807 .51733 .58343 .50911 Mtetra
.583 .774 .97 r
.58343 .50911 .58807 .51733 .6084 .51641 .6039 .50821 Mtetra
.584 .776 .971 r
.6039 .50821 .6084 .51641 .62882 .51543 .62444 .50725 Mtetra
.585 .777 .971 r
.62444 .50725 .62882 .51543 .6493 .51439 .64505 .50623 Mtetra
.586 .778 .971 r
.64505 .50623 .6493 .51439 .66985 .5133 .66574 .50515 Mtetra
.586 .78 .972 r
.66574 .50515 .66985 .5133 .69048 .51216 .6865 .50401 Mtetra
.587 .781 .972 r
.6865 .50401 .69048 .51216 .71118 .51097 .70734 .50282 Mtetra
.588 .782 .972 r
.70734 .50282 .71118 .51097 .73195 .50974 .72824 .50159 Mtetra
.588 .783 .973 r
.72824 .50159 .73195 .50974 .75279 .50847 .74922 .50031 Mtetra
.589 .783 .973 r
.74922 .50031 .75279 .50847 .77371 .50716 .77028 .49899 Mtetra
.589 .784 .973 r
.77028 .49899 .77371 .50716 .79469 .50581 .7914 .49764 Mtetra
.59 .785 .973 r
.7914 .49764 .79469 .50581 .81575 .50443 .8126 .49625 Mtetra
.8126 .49625 .81575 .50443 .83688 .50301 .83388 .49482 Mtetra
.59 .786 .973 r
.83388 .49482 .83688 .50301 .85809 .50157 .85522 .49336 Mtetra
.591 .787 .973 r
.85522 .49336 .85809 .50157 .87936 .5001 .87664 .49188 Mtetra
.591 .787 .974 r
.87664 .49188 .87936 .5001 .90071 .4986 .89814 .49036 Mtetra
.592 .788 .974 r
.89814 .49036 .90071 .4986 .92213 .49707 .9197 .48882 Mtetra
.9197 .48882 .92213 .49707 .94363 .49552 .94135 .48725 Mtetra
.94135 .48725 .94363 .49552 .9652 .49395 .96307 .48566 Mtetra
.592 .789 .974 r
.96307 .48566 .9652 .49395 .98684 .49236 .98486 .48405 Mtetra
.845 .747 .756 r
.2767 .55293 .28282 .57179 .30367 .53953 .2975 .52487 Mtetra
.769 .747 .833 r
.2975 .52487 .30367 .53953 .32368 .52602 .31753 .51355 Mtetra
.701 .743 .885 r
.31753 .51355 .32368 .52602 .34343 .51981 .33734 .50863 Mtetra
.651 .741 .915 r
.33734 .50863 .34343 .51981 .36311 .51678 .35711 .50642 Mtetra
.619 .741 .933 r
.35711 .50642 .36311 .51678 .3828 .51522 .3769 .50542 Mtetra
.6 .743 .945 r
.3769 .50542 .3828 .51522 .40254 .51435 .39674 .50494 Mtetra
.589 .747 .952 r
.39674 .50494 .40254 .51435 .42235 .5138 .41666 .50467 Mtetra
.583 .75 .957 r
.41666 .50467 .42235 .5138 .44222 .51336 .43665 .50444 Mtetra
.58 .754 .961 r
.43665 .50444 .44222 .51336 .46217 .51293 .45671 .50417 Mtetra
.579 .758 .963 r
.45671 .50417 .46217 .51293 .48219 .51247 .47686 .50384 Mtetra
.578 .761 .965 r
.47686 .50384 .48219 .51247 .50229 .51195 .49708 .50341 Mtetra
.579 .764 .967 r
.49708 .50341 .50229 .51195 .52246 .51135 .51738 .50289 Mtetra
.579 .767 .968 r
.51738 .50289 .52246 .51135 .54271 .51068 .53775 .50227 Mtetra
.58 .769 .969 r
.53775 .50227 .54271 .51068 .56303 .50993 .5582 .50157 Mtetra
.581 .771 .969 r
.5582 .50157 .56303 .50993 .58343 .50911 .57873 .50078 Mtetra
.582 .773 .97 r
.57873 .50078 .58343 .50911 .6039 .50821 .59933 .49991 Mtetra
.583 .775 .971 r
.59933 .49991 .6039 .50821 .62444 .50725 .62 .49896 Mtetra
.584 .777 .971 r
.62 .49896 .62444 .50725 .64505 .50623 .64075 .49795 Mtetra
.585 .778 .971 r
.64075 .49795 .64505 .50623 .66574 .50515 .66157 .49688 Mtetra
.586 .779 .972 r
.66157 .49688 .66574 .50515 .6865 .50401 .68247 .49575 Mtetra
.586 .78 .972 r
.68247 .49575 .6865 .50401 .70734 .50282 .70344 .49456 Mtetra
.587 .781 .972 r
.70344 .49456 .70734 .50282 .72824 .50159 .72449 .49333 Mtetra
.588 .782 .973 r
.72449 .49333 .72824 .50159 .74922 .50031 .74561 .49204 Mtetra
.588 .783 .973 r
.74561 .49204 .74922 .50031 .77028 .49899 .7668 .49072 Mtetra
.589 .784 .973 r
.7668 .49072 .77028 .49899 .7914 .49764 .78807 .48935 Mtetra
.589 .785 .973 r
.78807 .48935 .7914 .49764 .8126 .49625 .80941 .48795 Mtetra
.59 .785 .973 r
.80941 .48795 .8126 .49625 .83388 .49482 .83083 .48651 Mtetra
.59 .786 .973 r
.83083 .48651 .83388 .49482 .85522 .49336 .85232 .48504 Mtetra
.591 .786 .973 r
.85232 .48504 .85522 .49336 .87664 .49188 .87388 .48354 Mtetra
.591 .787 .974 r
.87388 .48354 .87664 .49188 .89814 .49036 .89552 .48201 Mtetra
.89552 .48201 .89814 .49036 .9197 .48882 .91724 .48045 Mtetra
.592 .788 .974 r
.91724 .48045 .9197 .48882 .94135 .48725 .93903 .47886 Mtetra
.93903 .47886 .94135 .48725 .96307 .48566 .9609 .47725 Mtetra
.592 .789 .974 r
.9609 .47725 .96307 .48566 .98486 .48405 .98285 .47562 Mtetra
.827 .739 .767 r
.27053 .53388 .2767 .55293 .2975 .52487 .29125 .51005 Mtetra
.748 .737 .842 r
.29125 .51005 .2975 .52487 .31753 .51355 .31131 .50094 Mtetra
.681 .734 .891 r
.31131 .50094 .31753 .51355 .33734 .50863 .33118 .49732 Mtetra
.634 .733 .919 r
.33118 .49732 .33734 .50863 .35711 .50642 .35103 .49594 Mtetra
.606 .734 .936 r
.35103 .49594 .35711 .50642 .3769 .50542 .37091 .49549 Mtetra
.59 .738 .946 r
.37091 .49549 .3769 .50542 .39674 .50494 .39087 .49541 Mtetra
.581 .743 .953 r
.39087 .49541 .39674 .50494 .41666 .50467 .41089 .49542 Mtetra
.577 .747 .958 r
.41089 .49542 .41666 .50467 .43665 .50444 .431 .49541 Mtetra
.575 .752 .961 r
.431 .49541 .43665 .50444 .45671 .50417 .45119 .4953 Mtetra
.575 .756 .964 r
.45119 .4953 .45671 .50417 .47686 .50384 .47145 .49509 Mtetra
.575 .759 .965 r
.47145 .49509 .47686 .50384 .49708 .50341 .4918 .49476 Mtetra
.576 .763 .967 r
.4918 .49476 .49708 .50341 .51738 .50289 .51222 .49431 Mtetra
.577 .766 .968 r
.51222 .49431 .51738 .50289 .53775 .50227 .53273 .49375 Mtetra
.579 .768 .969 r
.53273 .49375 .53775 .50227 .5582 .50157 .55331 .49309 Mtetra
.58 .771 .97 r
.55331 .49309 .5582 .50157 .57873 .50078 .57396 .49233 Mtetra
.581 .773 .97 r
.57396 .49233 .57873 .50078 .59933 .49991 .5947 .49149 Mtetra
.582 .774 .971 r
.5947 .49149 .59933 .49991 .62 .49896 .6155 .49056 Mtetra
.583 .776 .971 r
.6155 .49056 .62 .49896 .64075 .49795 .63639 .48957 Mtetra
.584 .777 .972 r
.63639 .48957 .64075 .49795 .66157 .49688 .65735 .4885 Mtetra
.585 .779 .972 r
.65735 .4885 .66157 .49688 .68247 .49575 .67838 .48737 Mtetra
.586 .78 .972 r
.67838 .48737 .68247 .49575 .70344 .49456 .69949 .48619 Mtetra
.587 .781 .972 r
.69949 .48619 .70344 .49456 .72449 .49333 .72068 .48495 Mtetra
.587 .782 .973 r
.72068 .48495 .72449 .49333 .74561 .49204 .74194 .48366 Mtetra
.588 .783 .973 r
.74194 .48366 .74561 .49204 .7668 .49072 .76328 .48233 Mtetra
.588 .784 .973 r
.76328 .48233 .7668 .49072 .78807 .48935 .78469 .48095 Mtetra
.589 .784 .973 r
.78469 .48095 .78807 .48935 .80941 .48795 .80617 .47954 Mtetra
.59 .785 .973 r
.80617 .47954 .80941 .48795 .83083 .48651 .82773 .47809 Mtetra
.59 .786 .973 r
.82773 .47809 .83083 .48651 .85232 .48504 .84937 .4766 Mtetra
.84937 .4766 .85232 .48504 .87388 .48354 .87109 .47508 Mtetra
.591 .787 .974 r
.87109 .47508 .87388 .48354 .89552 .48201 .89288 .47354 Mtetra
.89288 .47354 .89552 .48201 .91724 .48045 .91474 .47196 Mtetra
.591 .788 .974 r
.91474 .47196 .91724 .48045 .93903 .47886 .93669 .47036 Mtetra
.592 .788 .974 r
.93669 .47036 .93903 .47886 .9609 .47725 .95871 .46873 Mtetra
.592 .789 .974 r
.95871 .46873 .9609 .47725 .98285 .47562 .9808 .46707 Mtetra
.806 .729 .779 r
.26429 .51465 .27053 .53388 .29125 .51005 .28494 .49506 Mtetra
.724 .726 .851 r
.28494 .49506 .29125 .51005 .31131 .50094 .30501 .48817 Mtetra
.659 .723 .896 r
.30501 .48817 .31131 .50094 .33118 .49732 .32494 .48586 Mtetra
.617 .723 .922 r
.32494 .48586 .33118 .49732 .35103 .49594 .34487 .48532 Mtetra
.592 .727 .938 r
.34487 .48532 .35103 .49594 .37091 .49549 .36486 .48544 Mtetra
.58 .733 .947 r
.36486 .48544 .37091 .49549 .39087 .49541 .38491 .48575 Mtetra
.573 .738 .954 r
.38491 .48575 .39087 .49541 .41089 .49542 .40505 .48605 Mtetra
.571 .744 .958 r
.40505 .48605 .41089 .49542 .431 .49541 .42528 .48625 Mtetra
.57 .749 .962 r
.42528 .48625 .431 .49541 .45119 .4953 .44558 .48631 Mtetra
.571 .754 .964 r
.44558 .48631 .45119 .4953 .47145 .49509 .46597 .48622 Mtetra
.572 .758 .966 r
.46597 .48622 .47145 .49509 .4918 .49476 .48645 .48598 Mtetra
.574 .761 .967 r
.48645 .48598 .4918 .49476 .51222 .49431 .507 .48561 Mtetra
.575 .764 .968 r
.507 .48561 .51222 .49431 .53273 .49375 .52763 .48511 Mtetra
.577 .767 .969 r
.52763 .48511 .53273 .49375 .55331 .49309 .54834 .48449 Mtetra
.578 .77 .97 r
.54834 .48449 .55331 .49309 .57396 .49233 .56913 .48377 Mtetra
.58 .772 .97 r
.56913 .48377 .57396 .49233 .5947 .49149 .59 .48295 Mtetra
.581 .774 .971 r
.59 .48295 .5947 .49149 .6155 .49056 .61094 .48205 Mtetra
.582 .775 .971 r
.61094 .48205 .6155 .49056 .63639 .48957 .63197 .48106 Mtetra
.583 .777 .972 r
.63197 .48106 .63639 .48957 .65735 .4885 .65306 .48 Mtetra
.584 .778 .972 r
.65306 .48 .65735 .4885 .67838 .48737 .67424 .47888 Mtetra
.585 .78 .972 r
.67424 .47888 .67838 .48737 .69949 .48619 .69549 .47769 Mtetra
.586 .781 .972 r
.69549 .47769 .69949 .48619 .72068 .48495 .71682 .47645 Mtetra
.587 .782 .973 r
.71682 .47645 .72068 .48495 .74194 .48366 .73822 .47516 Mtetra
.587 .783 .973 r
.73822 .47516 .74194 .48366 .76328 .48233 .7597 .47382 Mtetra
.588 .783 .973 r
.7597 .47382 .76328 .48233 .78469 .48095 .78126 .47243 Mtetra
.589 .784 .973 r
.78126 .47243 .78469 .48095 .80617 .47954 .80289 .47101 Mtetra
.589 .785 .973 r
.80289 .47101 .80617 .47954 .82773 .47809 .8246 .46954 Mtetra
.59 .786 .973 r
.8246 .46954 .82773 .47809 .84937 .4766 .84639 .46804 Mtetra
.59 .786 .974 r
.84639 .46804 .84937 .4766 .87109 .47508 .86825 .46651 Mtetra
.591 .787 .974 r
.86825 .46651 .87109 .47508 .89288 .47354 .89019 .46494 Mtetra
.89019 .46494 .89288 .47354 .91474 .47196 .91221 .46335 Mtetra
.591 .788 .974 r
.91221 .46335 .91474 .47196 .93669 .47036 .93431 .46173 Mtetra
.592 .788 .974 r
.93431 .46173 .93669 .47036 .95871 .46873 .95648 .46008 Mtetra
.95648 .46008 .95871 .46873 .9808 .46707 .97873 .4584 Mtetra
.782 .717 .791 r
.258 .49523 .26429 .51465 .28494 .49506 .27856 .47991 Mtetra
.697 .712 .86 r
.27856 .47991 .28494 .49506 .30501 .48817 .29864 .47525 Mtetra
.635 .71 .901 r
.29864 .47525 .30501 .48817 .32494 .48586 .31863 .47426 Mtetra
.598 .714 .925 r
.31863 .47426 .32494 .48586 .34487 .48532 .33864 .47456 Mtetra
.578 .72 .939 r
.33864 .47456 .34487 .48532 .36486 .48544 .35872 .47525 Mtetra
.569 .727 .949 r
.35872 .47525 .36486 .48544 .38491 .48575 .37888 .47597 Mtetra
.565 .734 .955 r
.37888 .47597 .38491 .48575 .40505 .48605 .39914 .47656 Mtetra
.565 .741 .959 r
.39914 .47656 .40505 .48605 .42528 .48625 .41948 .47697 Mtetra
.566 .746 .962 r
.41948 .47697 .42528 .48625 .44558 .48631 .43991 .47719 Mtetra
.567 .752 .964 r
.43991 .47719 .44558 .48631 .46597 .48622 .46042 .47723 Mtetra
.569 .756 .966 r
.46042 .47723 .46597 .48622 .48645 .48598 .48102 .47709 Mtetra
.571 .76 .967 r
.48102 .47709 .48645 .48598 .507 .48561 .5017 .47679 Mtetra
.573 .763 .968 r
.5017 .47679 .507 .48561 .52763 .48511 .52247 .47635 Mtetra
.575 .766 .969 r
.52247 .47635 .52763 .48511 .54834 .48449 .54331 .47578 Mtetra
.577 .769 .97 r
.54331 .47578 .54834 .48449 .56913 .48377 .56423 .47509 Mtetra
.579 .771 .97 r
.56423 .47509 .56913 .48377 .59 .48295 .58524 .4743 Mtetra
.58 .773 .971 r
.58524 .4743 .59 .48295 .61094 .48205 .60632 .47341 Mtetra
.581 .775 .971 r
.60632 .47341 .61094 .48205 .63197 .48106 .62748 .47244 Mtetra
.583 .777 .972 r
.62748 .47244 .63197 .48106 .65306 .48 .64872 .47139 Mtetra
.584 .778 .972 r
.64872 .47139 .65306 .48 .67424 .47888 .67003 .47026 Mtetra
.585 .779 .972 r
.67003 .47026 .67424 .47888 .69549 .47769 .69143 .46908 Mtetra
.586 .78 .972 r
.69143 .46908 .69549 .47769 .71682 .47645 .7129 .46783 Mtetra
.586 .781 .973 r
.7129 .46783 .71682 .47645 .73822 .47516 .73445 .46653 Mtetra
.587 .782 .973 r
.73445 .46653 .73822 .47516 .7597 .47382 .75607 .46519 Mtetra
.588 .783 .973 r
.75607 .46519 .7597 .47382 .78126 .47243 .77778 .46379 Mtetra
.588 .784 .973 r
.77778 .46379 .78126 .47243 .80289 .47101 .79956 .46235 Mtetra
.589 .785 .973 r
.79956 .46235 .80289 .47101 .8246 .46954 .82142 .46087 Mtetra
.82142 .46087 .8246 .46954 .84639 .46804 .84336 .45936 Mtetra
.59 .786 .974 r
.84336 .45936 .84639 .46804 .86825 .46651 .86537 .45781 Mtetra
.59 .787 .974 r
.86537 .45781 .86825 .46651 .89019 .46494 .88747 .45623 Mtetra
.591 .787 .974 r
.88747 .45623 .89019 .46494 .91221 .46335 .90964 .45461 Mtetra
.591 .788 .974 r
.90964 .45461 .91221 .46335 .93431 .46173 .93189 .45297 Mtetra
.93189 .45297 .93431 .46173 .95648 .46008 .95422 .4513 Mtetra
.592 .788 .974 r
.95422 .4513 .95648 .46008 .97873 .4584 .97663 .4496 Mtetra
.752 .701 .804 r
.25164 .47562 .258 .49523 .27856 .47991 .2721 .46458 Mtetra
.666 .696 .868 r
.2721 .46458 .27856 .47991 .29864 .47525 .29219 .46218 Mtetra
.609 .697 .906 r
.29219 .46218 .29864 .47525 .31863 .47426 .31223 .46252 Mtetra
.578 .703 .928 r
.31223 .46252 .31863 .47426 .33864 .47456 .33232 .46367 Mtetra
.563 .712 .941 r
.33232 .46367 .33864 .47456 .35872 .47525 .3525 .46494 Mtetra
.558 .721 .949 r
.3525 .46494 .35872 .47525 .37888 .47597 .37277 .46605 Mtetra
.557 .729 .955 r
.37277 .46605 .37888 .47597 .39914 .47656 .39314 .46694 Mtetra
.558 .737 .959 r
.39314 .46694 .39914 .47656 .41948 .47697 .4136 .46757 Mtetra
.561 .744 .962 r
.4136 .46757 .41948 .47697 .43991 .47719 .43415 .46796 Mtetra
.563 .749 .965 r
.43415 .46796 .43991 .47719 .46042 .47723 .45479 .46812 Mtetra
.566 .754 .966 r
.45479 .46812 .46042 .47723 .48102 .47709 .47552 .46808 Mtetra
.569 .759 .968 r
.47552 .46808 .48102 .47709 .5017 .47679 .49633 .46785 Mtetra
.571 .762 .969 r
.49633 .46785 .5017 .47679 .52247 .47635 .51723 .46747 Mtetra
.573 .765 .969 r
.51723 .46747 .52247 .47635 .54331 .47578 .53821 .46694 Mtetra
.575 .768 .97 r
.53821 .46694 .54331 .47578 .56423 .47509 .55927 .46629 Mtetra
.577 .77 .971 r
.55927 .46629 .56423 .47509 .58524 .4743 .58041 .46552 Mtetra
.579 .773 .971 r
.58041 .46552 .58524 .4743 .60632 .47341 .60163 .46465 Mtetra
.58 .774 .971 r
.60163 .46465 .60632 .47341 .62748 .47244 .62293 .46369 Mtetra
.582 .776 .972 r
.62293 .46369 .62748 .47244 .64872 .47139 .64431 .46265 Mtetra
.583 .778 .972 r
.64431 .46265 .64872 .47139 .67003 .47026 .66577 .46153 Mtetra
.584 .779 .972 r
.66577 .46153 .67003 .47026 .69143 .46908 .68731 .46034 Mtetra
.585 .78 .973 r
.68731 .46034 .69143 .46908 .7129 .46783 .70893 .45909 Mtetra
.586 .781 .973 r
.70893 .45909 .7129 .46783 .73445 .46653 .73062 .45779 Mtetra
.587 .782 .973 r
.73062 .45779 .73445 .46653 .75607 .46519 .7524 .45643 Mtetra
.587 .783 .973 r
.7524 .45643 .75607 .46519 .77778 .46379 .77425 .45503 Mtetra
.588 .784 .973 r
.77425 .45503 .77778 .46379 .79956 .46235 .79618 .45357 Mtetra
.589 .785 .973 r
.79618 .45357 .79956 .46235 .82142 .46087 .81819 .45208 Mtetra
.81819 .45208 .82142 .46087 .84336 .45936 .84028 .45055 Mtetra
.59 .786 .974 r
.84028 .45055 .84336 .45936 .86537 .45781 .86245 .44899 Mtetra
.86245 .44899 .86537 .45781 .88747 .45623 .8847 .44738 Mtetra
.591 .787 .974 r
.8847 .44738 .88747 .45623 .90964 .45461 .90703 .44575 Mtetra
.90703 .44575 .90964 .45461 .93189 .45297 .92944 .44409 Mtetra
.591 .788 .974 r
.92944 .44409 .93189 .45297 .95422 .4513 .95193 .4424 Mtetra
.592 .788 .974 r
.95193 .4424 .95422 .4513 .97663 .4496 .9745 .44068 Mtetra
.715 .681 .815 r
.24522 .45582 .25164 .47562 .2721 .46458 .26557 .44908 Mtetra
.631 .676 .875 r
.26557 .44908 .2721 .46458 .29219 .46218 .28566 .44895 Mtetra
.581 .681 .909 r
.28566 .44895 .29219 .46218 .31223 .46252 .30575 .45063 Mtetra
.557 .691 .929 r
.30575 .45063 .31223 .46252 .33232 .46367 .32593 .45263 Mtetra
.548 .703 .942 r
.32593 .45263 .33232 .46367 .3525 .46494 .3462 .45448 Mtetra
.546 .715 .95 r
.3462 .45448 .3525 .46494 .37277 .46605 .36658 .45601 Mtetra
.548 .725 .956 r
.36658 .45601 .37277 .46605 .39314 .46694 .38706 .45719 Mtetra
.552 .734 .96 r
.38706 .45719 .39314 .46694 .4136 .46757 .40764 .45804 Mtetra
.556 .741 .963 r
.40764 .45804 .4136 .46757 .43415 .46796 .42832 .45859 Mtetra
.559 .747 .965 r
.42832 .45859 .43415 .46796 .45479 .46812 .44908 .45888 Mtetra
.563 .753 .966 r
.44908 .45888 .45479 .46812 .47552 .46808 .46994 .45894 Mtetra
.566 .757 .968 r
.46994 .45894 .47552 .46808 .49633 .46785 .49089 .45879 Mtetra
.569 .761 .969 r
.49089 .45879 .49633 .46785 .51723 .46747 .51192 .45847 Mtetra
.572 .764 .97 r
.51192 .45847 .51723 .46747 .53821 .46694 .53303 .45798 Mtetra
.574 .767 .97 r
.53303 .45798 .53821 .46694 .55927 .46629 .55423 .45736 Mtetra
.576 .77 .971 r
.55423 .45736 .55927 .46629 .58041 .46552 .57551 .45662 Mtetra
.578 .772 .971 r
.57551 .45662 .58041 .46552 .60163 .46465 .59688 .45577 Mtetra
.579 .774 .971 r
.59688 .45577 .60163 .46465 .62293 .46369 .61832 .45482 Mtetra
.581 .776 .972 r
.61832 .45482 .62293 .46369 .64431 .46265 .63984 .45378 Mtetra
.582 .777 .972 r
.63984 .45378 .64431 .46265 .66577 .46153 .66145 .45267 Mtetra
.583 .779 .972 r
.66145 .45267 .66577 .46153 .68731 .46034 .68313 .45148 Mtetra
.584 .78 .973 r
.68313 .45148 .68731 .46034 .70893 .45909 .7049 .45023 Mtetra
.585 .781 .973 r
.7049 .45023 .70893 .45909 .73062 .45779 .72674 .44892 Mtetra
.586 .782 .973 r
.72674 .44892 .73062 .45779 .7524 .45643 .74867 .44755 Mtetra
.587 .783 .973 r
.74867 .44755 .7524 .45643 .77425 .45503 .77067 .44613 Mtetra
.588 .784 .973 r
.77067 .44613 .77425 .45503 .79618 .45357 .79275 .44467 Mtetra
.79275 .44467 .79618 .45357 .81819 .45208 .81492 .44316 Mtetra
.589 .785 .973 r
.81492 .44316 .81819 .45208 .84028 .45055 .83716 .44162 Mtetra
.589 .786 .974 r
.83716 .44162 .84028 .45055 .86245 .44899 .85949 .44003 Mtetra
.59 .786 .974 r
.85949 .44003 .86245 .44899 .8847 .44738 .8819 .43841 Mtetra
.59 .787 .974 r
.8819 .43841 .8847 .44738 .90703 .44575 .90438 .43676 Mtetra
.591 .787 .974 r
.90438 .43676 .90703 .44575 .92944 .44409 .92695 .43508 Mtetra
.591 .788 .974 r
.92695 .43508 .92944 .44409 .95193 .4424 .9496 .43336 Mtetra
.9496 .43336 .95193 .4424 .9745 .44068 .97234 .43162 Mtetra
.67 .655 .826 r
.23874 .43582 .24522 .45582 .26557 .44908 .25897 .43341 Mtetra
.591 .653 .88 r
.25897 .43341 .26557 .44908 .28566 .44895 .27905 .43555 Mtetra
.55 .664 .912 r
.27905 .43555 .28566 .44895 .30575 .45063 .29919 .43858 Mtetra
.535 .679 .931 r
.29919 .43858 .30575 .45063 .32593 .45263 .31945 .44146 Mtetra
.532 .694 .943 r
.31945 .44146 .32593 .45263 .3462 .45448 .33982 .44389 Mtetra
.535 .708 .951 r
.33982 .44389 .3462 .45448 .36658 .45601 .3603 .44582 Mtetra
.54 .72 .956 r
.3603 .44582 .36658 .45601 .38706 .45719 .3809 .4473 Mtetra
.545 .73 .96 r
.3809 .4473 .38706 .45719 .40764 .45804 .4016 .44838 Mtetra
.55 .738 .963 r
.4016 .44838 .40764 .45804 .42832 .45859 .4224 .4491 Mtetra
.555 .745 .965 r
.4224 .4491 .42832 .45859 .44908 .45888 .4433 .44951 Mtetra
.56 .751 .967 r
.4433 .44951 .44908 .45888 .46994 .45894 .46429 .44967 Mtetra
.564 .756 .968 r
.46429 .44967 .46994 .45894 .49089 .45879 .48537 .4496 Mtetra
.567 .76 .969 r
.48537 .4496 .49089 .45879 .51192 .45847 .50653 .44933 Mtetra
.57 .763 .97 r
.50653 .44933 .51192 .45847 .53303 .45798 .52779 .4489 Mtetra
.572 .766 .97 r
.52779 .4489 .53303 .45798 .55423 .45736 .54913 .44831 Mtetra
.575 .769 .971 r
.54913 .44831 .55423 .45736 .57551 .45662 .57055 .4476 Mtetra
.577 .771 .971 r
.57055 .4476 .57551 .45662 .59688 .45577 .59205 .44676 Mtetra
.579 .773 .972 r
.59205 .44676 .59688 .45577 .61832 .45482 .61364 .44582 Mtetra
.58 .775 .972 r
.61364 .44582 .61832 .45482 .63984 .45378 .63531 .4448 Mtetra
.582 .777 .972 r
.63531 .4448 .63984 .45378 .66145 .45267 .65706 .44368 Mtetra
.583 .778 .972 r
.65706 .44368 .66145 .45267 .68313 .45148 .67889 .44249 Mtetra
.584 .779 .973 r
.67889 .44249 .68313 .45148 .7049 .45023 .70081 .44124 Mtetra
.585 .781 .973 r
.70081 .44124 .7049 .45023 .72674 .44892 .7228 .43992 Mtetra
.586 .782 .973 r
.7228 .43992 .72674 .44892 .74867 .44755 .74488 .43854 Mtetra
.587 .783 .973 r
.74488 .43854 .74867 .44755 .77067 .44613 .76704 .43711 Mtetra
.76704 .43711 .77067 .44613 .79275 .44467 .78928 .43564 Mtetra
.588 .784 .973 r
.78928 .43564 .79275 .44467 .81492 .44316 .8116 .43411 Mtetra
.589 .785 .973 r
.8116 .43411 .81492 .44316 .83716 .44162 .834 .43255 Mtetra
.589 .786 .974 r
.834 .43255 .83716 .44162 .85949 .44003 .85648 .43095 Mtetra
.59 .786 .974 r
.85648 .43095 .85949 .44003 .8819 .43841 .87905 .42931 Mtetra
.59 .787 .974 r
.87905 .42931 .8819 .43841 .90438 .43676 .9017 .42764 Mtetra
.591 .787 .974 r
.9017 .42764 .90438 .43676 .92695 .43508 .92443 .42593 Mtetra
.591 .788 .974 r
.92443 .42593 .92695 .43508 .9496 .43336 .94724 .4242 Mtetra
.94724 .4242 .9496 .43336 .97234 .43162 .97014 .42243 Mtetra
.615 .622 .834 r
.23219 .41562 .23874 .43582 .25897 .43341 .25229 .41755 Mtetra
.545 .627 .884 r
.25229 .41755 .25897 .43341 .27905 .43555 .27236 .42199 Mtetra
.517 .644 .913 r
.27236 .42199 .27905 .43555 .29919 .43858 .29255 .42638 Mtetra
.511 .665 .932 r
.29255 .42638 .29919 .43858 .31945 .44146 .31288 .43013 Mtetra
.515 .685 .943 r
.31288 .43013 .31945 .44146 .33982 .44389 .33335 .43315 Mtetra
.523 .701 .951 r
.33335 .43315 .33982 .44389 .3603 .44582 .35394 .4355 Mtetra
.531 .715 .957 r
.35394 .4355 .3603 .44582 .3809 .4473 .37465 .43728 Mtetra
.538 .726 .961 r
.37465 .43728 .3809 .4473 .4016 .44838 .39548 .43858 Mtetra
.545 .735 .963 r
.39548 .43858 .4016 .44838 .4224 .4491 .4164 .43947 Mtetra
.551 .743 .965 r
.4164 .43947 .4224 .4491 .4433 .44951 .43743 .44002 Mtetra
.556 .749 .967 r
.43743 .44002 .4433 .44951 .46429 .44967 .45855 .44027 Mtetra
.561 .754 .968 r
.45855 .44027 .46429 .44967 .48537 .4496 .47977 .44028 Mtetra
.565 .759 .969 r
.47977 .44028 .48537 .4496 .50653 .44933 .50107 .44007 Mtetra
.568 .762 .97 r
.50107 .44007 .50653 .44933 .52779 .4489 .52247 .43968 Mtetra
.571 .766 .97 r
.52247 .43968 .52779 .4489 .54913 .44831 .54395 .43913 Mtetra
.574 .768 .971 r
.54395 .43913 .54913 .44831 .57055 .4476 .56551 .43844 Mtetra
.576 .771 .971 r
.56551 .43844 .57055 .4476 .59205 .44676 .58716 .43762 Mtetra
.578 .773 .972 r
.58716 .43762 .59205 .44676 .61364 .44582 .60889 .4367 Mtetra
.579 .775 .972 r
.60889 .4367 .61364 .44582 .63531 .4448 .63071 .43568 Mtetra
.581 .776 .972 r
.63071 .43568 .63531 .4448 .65706 .44368 .65261 .43456 Mtetra
.582 .778 .972 r
.65261 .43456 .65706 .44368 .67889 .44249 .6746 .43337 Mtetra
.583 .779 .973 r
.6746 .43337 .67889 .44249 .70081 .44124 .69666 .43211 Mtetra
.584 .78 .973 r
.69666 .43211 .70081 .44124 .7228 .43992 .71881 .43079 Mtetra
.585 .781 .973 r
.71881 .43079 .7228 .43992 .74488 .43854 .74104 .4294 Mtetra
.586 .782 .973 r
.74104 .4294 .74488 .43854 .76704 .43711 .76335 .42796 Mtetra
.587 .783 .973 r
.76335 .42796 .76704 .43711 .78928 .43564 .78575 .42647 Mtetra
.588 .784 .973 r
.78575 .42647 .78928 .43564 .8116 .43411 .80823 .42493 Mtetra
.588 .785 .973 r
.80823 .42493 .8116 .43411 .834 .43255 .83079 .42335 Mtetra
.589 .785 .974 r
.83079 .42335 .834 .43255 .85648 .43095 .85343 .42173 Mtetra
.589 .786 .974 r
.85343 .42173 .85648 .43095 .87905 .42931 .87616 .42007 Mtetra
.59 .787 .974 r
.87616 .42007 .87905 .42931 .9017 .42764 .89897 .41838 Mtetra
.89897 .41838 .9017 .42764 .92443 .42593 .92187 .41665 Mtetra
.591 .788 .974 r
.92187 .41665 .92443 .42593 .94724 .4242 .94485 .41489 Mtetra
.94485 .41489 .94724 .4242 .97014 .42243 .96791 .41311 Mtetra
.548 .58 .839 r
.22558 .39522 .23219 .41562 .25229 .41755 .24553 .40151 Mtetra
.493 .595 .884 r
.24553 .40151 .25229 .41755 .27236 .42199 .26559 .40826 Mtetra
.481 .623 .913 r
.26559 .40826 .27236 .42199 .29255 .42638 .28582 .41403 Mtetra
.487 .651 .932 r
.28582 .41403 .29255 .42638 .31288 .43013 .30623 .41865 Mtetra
.498 .675 .944 r
.30623 .41865 .31288 .43013 .33335 .43315 .32679 .42227 Mtetra
.51 .694 .952 r
.32679 .42227 .33335 .43315 .35394 .4355 .34749 .42504 Mtetra
.522 .71 .957 r
.34749 .42504 .35394 .4355 .37465 .43728 .36832 .42713 Mtetra
.532 .722 .961 r
.36832 .42713 .37465 .43728 .39548 .43858 .38927 .42865 Mtetra
.54 .732 .964 r
.38927 .42865 .39548 .43858 .4164 .43947 .41032 .42971 Mtetra
.547 .741 .966 r
.41032 .42971 .4164 .43947 .43743 .44002 .43148 .43039 Mtetra
.553 .747 .967 r
.43148 .43039 .43743 .44002 .45855 .44027 .45274 .43074 Mtetra
.558 .753 .968 r
.45274 .43074 .45855 .44027 .47977 .44028 .47409 .43083 Mtetra
.563 .757 .969 r
.47409 .43083 .47977 .44028 .50107 .44007 .49553 .43068 Mtetra
.566 .761 .97 r
.49553 .43068 .50107 .44007 .52247 .43968 .51707 .43033 Mtetra
.57 .765 .971 r
.51707 .43033 .52247 .43968 .54395 .43913 .53869 .42982 Mtetra
.572 .768 .971 r
.53869 .42982 .54395 .43913 .56551 .43844 .5604 .42915 Mtetra
.575 .77 .971 r
.5604 .42915 .56551 .43844 .58716 .43762 .5822 .42835 Mtetra
.577 .772 .972 r
.5822 .42835 .58716 .43762 .60889 .4367 .60408 .42744 Mtetra
.579 .774 .972 r
.60408 .42744 .60889 .4367 .63071 .43568 .62605 .42642 Mtetra
.58 .776 .972 r
.62605 .42642 .63071 .43568 .65261 .43456 .6481 .42531 Mtetra
.582 .777 .972 r
.6481 .42531 .65261 .43456 .6746 .43337 .67023 .42412 Mtetra
.583 .779 .973 r
.67023 .42412 .6746 .43337 .69666 .43211 .69245 .42286 Mtetra
.584 .78 .973 r
.69245 .42286 .69666 .43211 .71881 .43079 .71476 .42152 Mtetra
.585 .781 .973 r
.71476 .42152 .71881 .43079 .74104 .4294 .73714 .42012 Mtetra
.586 .782 .973 r
.73714 .42012 .74104 .4294 .76335 .42796 .75961 .41867 Mtetra
.587 .783 .973 r
.75961 .41867 .76335 .42796 .78575 .42647 .78217 .41717 Mtetra
.587 .784 .973 r
.78217 .41717 .78575 .42647 .80823 .42493 .80481 .41561 Mtetra
.588 .785 .973 r
.80481 .41561 .80823 .42493 .83079 .42335 .82753 .41401 Mtetra
.589 .785 .974 r
.82753 .41401 .83079 .42335 .85343 .42173 .85034 .41237 Mtetra
.589 .786 .974 r
.85034 .41237 .85343 .42173 .87616 .42007 .87323 .4107 Mtetra
.59 .786 .974 r
.87323 .4107 .87616 .42007 .89897 .41838 .89621 .40898 Mtetra
.59 .787 .974 r
.89621 .40898 .89897 .41838 .92187 .41665 .91927 .40723 Mtetra
.591 .787 .974 r
.91927 .40723 .92187 .41665 .94485 .41489 .94242 .40545 Mtetra
.591 .788 .974 r
.94242 .40545 .94485 .41489 .96791 .41311 .96565 .40364 Mtetra
.465 .526 .836 r
.2189 .37462 .22558 .39522 .24553 .40151 .23869 .38528 Mtetra
.435 .558 .881 r
.23869 .38528 .24553 .40151 .26559 .40826 .25873 .39436 Mtetra
.442 .599 .911 r
.25873 .39436 .26559 .40826 .28582 .41403 .27901 .40151 Mtetra
.461 .635 .931 r
.27901 .40151 .28582 .41403 .30623 .41865 .29949 .40702 Mtetra
.48 .664 .943 r
.29949 .40702 .30623 .41865 .32679 .42227 .32014 .41124 Mtetra
.498 .687 .952 r
.32014 .41124 .32679 .42227 .34749 .42504 .34095 .41444 Mtetra
.513 .705 .957 r
.34095 .41444 .34749 .42504 .36832 .42713 .3619 .41683 Mtetra
.525 .719 .961 r
.3619 .41683 .36832 .42713 .38927 .42865 .38297 .41858 Mtetra
.535 .73 .964 r
.38297 .41858 .38927 .42865 .41032 .42971 .40415 .41981 Mtetra
.543 .738 .966 r
.40415 .41981 .41032 .42971 .43148 .43039 .42545 .42062 Mtetra
.55 .745 .967 r
.42545 .42062 .43148 .43039 .45274 .43074 .44684 .42108 Mtetra
.556 .751 .969 r
.44684 .42108 .45274 .43074 .47409 .43083 .46833 .42124 Mtetra
.56 .756 .969 r
.46833 .42124 .47409 .43083 .49553 .43068 .48991 .42115 Mtetra
.565 .76 .97 r
.48991 .42115 .49553 .43068 .51707 .43033 .51159 .42085 Mtetra
.568 .764 .971 r
.51159 .42085 .51707 .43033 .53869 .42982 .53336 .42037 Mtetra
.571 .767 .971 r
.53336 .42037 .53869 .42982 .5604 .42915 .55522 .41973 Mtetra
.574 .77 .971 r
.55522 .41973 .5604 .42915 .5822 .42835 .57716 .41895 Mtetra
.576 .772 .972 r
.57716 .41895 .5822 .42835 .60408 .42744 .59919 .41805 Mtetra
.578 .774 .972 r
.59919 .41805 .60408 .42744 .62605 .42642 .62131 .41704 Mtetra
.579 .776 .972 r
.62131 .41704 .62605 .42642 .6481 .42531 .64352 .41593 Mtetra
.581 .777 .973 r
.64352 .41593 .6481 .42531 .67023 .42412 .66581 .41473 Mtetra
.582 .779 .973 r
.66581 .41473 .67023 .42412 .69245 .42286 .68818 .41346 Mtetra
.584 .78 .973 r
.68818 .41346 .69245 .42286 .71476 .42152 .71064 .41212 Mtetra
.585 .781 .973 r
.71064 .41212 .71476 .42152 .73714 .42012 .73319 .41071 Mtetra
.586 .782 .973 r
.73319 .41071 .73714 .42012 .75961 .41867 .75582 .40925 Mtetra
.586 .783 .973 r
.75582 .40925 .75961 .41867 .78217 .41717 .77854 .40772 Mtetra
.587 .784 .973 r
.77854 .40772 .78217 .41717 .80481 .41561 .80134 .40615 Mtetra
.588 .784 .974 r
.80134 .40615 .80481 .41561 .82753 .41401 .82422 .40454 Mtetra
.588 .785 .974 r
.82422 .40454 .82753 .41401 .85034 .41237 .8472 .40288 Mtetra
.589 .786 .974 r
.8472 .40288 .85034 .41237 .87323 .4107 .87026 .40118 Mtetra
.59 .786 .974 r
.87026 .40118 .87323 .4107 .89621 .40898 .8934 .39944 Mtetra
.59 .787 .974 r
.8934 .39944 .89621 .40898 .91927 .40723 .91663 .39767 Mtetra
.91663 .39767 .91927 .40723 .94242 .40545 .93995 .39586 Mtetra
.591 .788 .974 r
.93995 .39586 .94242 .40545 .96565 .40364 .96336 .39403 Mtetra
.366 .459 .824 r
.21215 .3538 .2189 .37462 .23869 .38528 .23178 .36886 Mtetra
.37 .516 .873 r
.23178 .36886 .23869 .38528 .25873 .39436 .25179 .38029 Mtetra
.4 .573 .907 r
.25179 .38029 .25873 .39436 .27901 .40151 .2721 .38883 Mtetra
.433 .619 .929 r
.2721 .38883 .27901 .40151 .29949 .40702 .29266 .39524 Mtetra
.462 .653 .943 r
.29266 .39524 .29949 .40702 .32014 .41124 .31341 .40006 Mtetra
.485 .68 .952 r
.31341 .40006 .32014 .41124 .34095 .41444 .33433 .40368 Mtetra
.503 .699 .958 r
.33433 .40368 .34095 .41444 .3619 .41683 .35539 .40638 Mtetra
.518 .715 .961 r
.35539 .40638 .3619 .41683 .38297 .41858 .37659 .40837 Mtetra
.529 .727 .964 r
.37659 .40837 .38297 .41858 .40415 .41981 .3979 .40977 Mtetra
.539 .736 .966 r
.3979 .40977 .40415 .41981 .42545 .42062 .41932 .41071 Mtetra
.547 .744 .968 r
.41932 .41071 .42545 .42062 .44684 .42108 .44085 .41127 Mtetra
.553 .75 .969 r
.44085 .41127 .44684 .42108 .46833 .42124 .46249 .41151 Mtetra
.558 .755 .97 r
.46249 .41151 .46833 .42124 .48991 .42115 .48421 .41148 Mtetra
.563 .759 .97 r
.48421 .41148 .48991 .42115 .51159 .42085 .50604 .41123 Mtetra
.567 .763 .971 r
.50604 .41123 .51159 .42085 .53336 .42037 .52795 .41078 Mtetra
.57 .766 .971 r
.52795 .41078 .53336 .42037 .55522 .41973 .54996 .41017 Mtetra
.573 .769 .972 r
.54996 .41017 .55522 .41973 .57716 .41895 .57205 .40941 Mtetra
.575 .771 .972 r
.57205 .40941 .57716 .41895 .59919 .41805 .59424 .40851 Mtetra
.577 .773 .972 r
.59424 .40851 .59919 .41805 .62131 .41704 .61651 .40751 Mtetra
.579 .775 .972 r
.61651 .40751 .62131 .41704 .64352 .41593 .63887 .4064 Mtetra
.58 .777 .973 r
.63887 .4064 .64352 .41593 .66581 .41473 .66132 .40521 Mtetra
.582 .778 .973 r
.66132 .40521 .66581 .41473 .68818 .41346 .68385 .40393 Mtetra
.583 .779 .973 r
.68385 .40393 .68818 .41346 .71064 .41212 .70647 .40258 Mtetra
.584 .781 .973 r
.70647 .40258 .71064 .41212 .73319 .41071 .72918 .40116 Mtetra
.585 .782 .973 r
.72918 .40116 .73319 .41071 .75582 .40925 .75197 .39968 Mtetra
.586 .783 .973 r
.75197 .39968 .75582 .40925 .77854 .40772 .77485 .39814 Mtetra
.587 .783 .973 r
.77485 .39814 .77854 .40772 .80134 .40615 .79781 .39655 Mtetra
.588 .784 .974 r
.79781 .39655 .80134 .40615 .82422 .40454 .82087 .39492 Mtetra
.588 .785 .974 r
.82087 .39492 .82422 .40454 .8472 .40288 .84401 .39324 Mtetra
.589 .786 .974 r
.84401 .39324 .8472 .40288 .87026 .40118 .86724 .39152 Mtetra
.86724 .39152 .87026 .40118 .8934 .39944 .89055 .38976 Mtetra
.59 .787 .974 r
.89055 .38976 .8934 .39944 .91663 .39767 .91395 .38796 Mtetra
.91395 .38796 .91663 .39767 .93995 .39586 .93745 .38613 Mtetra
.591 .788 .974 r
.93745 .38613 .93995 .39586 .96336 .39403 .96103 .38427 Mtetra
.249 .378 .798 r
.20533 .33277 .21215 .3538 .23178 .36886 .22478 .35225 Mtetra
.298 .467 .859 r
.22478 .35225 .23178 .36886 .25179 .38029 .24476 .36604 Mtetra
.355 .544 .901 r
.24476 .36604 .25179 .38029 .2721 .38883 .26511 .37599 Mtetra
.405 .601 .926 r
.26511 .37599 .2721 .38883 .29266 .39524 .28573 .38329 Mtetra
.443 .642 .942 r
.28573 .38329 .29266 .39524 .31341 .40006 .30658 .38873 Mtetra
.472 .672 .951 r
.30658 .38873 .31341 .40006 .33433 .40368 .32761 .39278 Mtetra
.494 .694 .957 r
.32761 .39278 .33433 .40368 .35539 .40638 .34879 .39579 Mtetra
.511 .711 .962 r
.34879 .39579 .35539 .40638 .37659 .40837 .37011 .39801 Mtetra
.524 .723 .964 r
.37011 .39801 .37659 .40837 .3979 .40977 .39155 .39959 Mtetra
.535 .734 .966 r
.39155 .39959 .3979 .40977 .41932 .41071 .41312 .40066 Mtetra
.543 .742 .968 r
.41312 .40066 .41932 .41071 .44085 .41127 .43478 .40132 Mtetra
.55 .748 .969 r
.43478 .40132 .44085 .41127 .46249 .41151 .45656 .40164 Mtetra
.556 .754 .97 r
.45656 .40164 .46249 .41151 .48421 .41148 .47843 .40168 Mtetra
.561 .758 .97 r
.47843 .40168 .48421 .41148 .50604 .41123 .5004 .40147 Mtetra
.565 .762 .971 r
.5004 .40147 .50604 .41123 .52795 .41078 .52246 .40106 Mtetra
.569 .766 .971 r
.52246 .40106 .52795 .41078 .54996 .41017 .54462 .40047 Mtetra
.571 .768 .972 r
.54462 .40047 .54996 .41017 .57205 .40941 .56687 .39972 Mtetra
.574 .771 .972 r
.56687 .39972 .57205 .40941 .59424 .40851 .58921 .39884 Mtetra
.576 .773 .972 r
.58921 .39884 .59424 .40851 .61651 .40751 .61163 .39784 Mtetra
.578 .775 .972 r
.61163 .39784 .61651 .40751 .63887 .4064 .63415 .39674 Mtetra
.58 .776 .973 r
.63415 .39674 .63887 .4064 .66132 .40521 .65676 .39554 Mtetra
.581 .778 .973 r
.65676 .39554 .66132 .40521 .68385 .40393 .67945 .39425 Mtetra
.583 .779 .973 r
.67945 .39425 .68385 .40393 .70647 .40258 .70223 .39289 Mtetra
.584 .78 .973 r
.70223 .39289 .70647 .40258 .72918 .40116 .7251 .39146 Mtetra
.585 .781 .973 r
.7251 .39146 .72918 .40116 .75197 .39968 .74806 .38997 Mtetra
.586 .782 .973 r
.74806 .38997 .75197 .39968 .77485 .39814 .7711 .38841 Mtetra
.587 .783 .973 r
.7711 .38841 .77485 .39814 .79781 .39655 .79424 .38681 Mtetra
.587 .784 .974 r
.79424 .38681 .79781 .39655 .82087 .39492 .81746 .38515 Mtetra
.588 .785 .974 r
.81746 .38515 .82087 .39492 .84401 .39324 .84077 .38345 Mtetra
.589 .785 .974 r
.84077 .38345 .84401 .39324 .86724 .39152 .86417 .38171 Mtetra
.589 .786 .974 r
.86417 .38171 .86724 .39152 .89055 .38976 .88766 .37993 Mtetra
.59 .787 .974 r
.88766 .37993 .89055 .38976 .91395 .38796 .91124 .37811 Mtetra
.91124 .37811 .91395 .38796 .93745 .38613 .9349 .37625 Mtetra
.591 .788 .974 r
.9349 .37625 .93745 .38613 .96103 .38427 .95866 .37436 Mtetra
.038 .383 .846 r
.19785 .32135 .20533 .33277 .22478 .35225 .2177 .33545 Mtetra
.219 .413 .84 r
.2177 .33545 .22478 .35225 .24476 .36604 .23764 .3516 Mtetra
.308 .512 .892 r
.23764 .3516 .24476 .36604 .26511 .37599 .25802 .36297 Mtetra
.375 .582 .923 r
.25802 .36297 .26511 .37599 .28573 .38329 .27871 .37119 Mtetra
.423 .63 .94 r
.27871 .37119 .28573 .38329 .30658 .38873 .29966 .37724 Mtetra
.458 .664 .951 r
.29966 .37724 .30658 .38873 .32761 .39278 .32079 .38172 Mtetra
.484 .688 .957 r
.32079 .38172 .32761 .39278 .34879 .39579 .34209 .38505 Mtetra
.504 .706 .962 r
.34209 .38505 .34879 .39579 .37011 .39801 .36354 .3875 Mtetra
.519 .72 .964 r
.36354 .3875 .37011 .39801 .39155 .39959 .38512 .38926 Mtetra
.531 .731 .966 r
.38512 .38926 .39155 .39959 .41312 .40066 .40682 .39047 Mtetra
.54 .74 .968 r
.40682 .39047 .41312 .40066 .43478 .40132 .42863 .39123 Mtetra
.548 .747 .969 r
.42863 .39123 .43478 .40132 .45656 .40164 .45054 .39163 Mtetra
.554 .753 .97 r
.45054 .39163 .45656 .40164 .47843 .40168 .47256 .39173 Mtetra
.559 .757 .97 r
.47256 .39173 .47843 .40168 .5004 .40147 .49468 .39157 Mtetra
.564 .761 .971 r
.49468 .39157 .5004 .40147 .52246 .40106 .51689 .39119 Mtetra
.567 .765 .971 r
.51689 .39119 .52246 .40106 .54462 .40047 .5392 .39062 Mtetra
.57 .768 .972 r
.5392 .39062 .54462 .40047 .56687 .39972 .56161 .38989 Mtetra
.573 .77 .972 r
.56161 .38989 .56687 .39972 .58921 .39884 .5841 .38902 Mtetra
.575 .772 .972 r
.5841 .38902 .58921 .39884 .61163 .39784 .60669 .38803 Mtetra
.577 .774 .972 r
.60669 .38803 .61163 .39784 .63415 .39674 .62936 .38692 Mtetra
.579 .776 .973 r
.62936 .38692 .63415 .39674 .65676 .39554 .65213 .38572 Mtetra
.581 .778 .973 r
.65213 .38572 .65676 .39554 .67945 .39425 .67498 .38443 Mtetra
.582 .779 .973 r
.67498 .38443 .67945 .39425 .70223 .39289 .69793 .38306 Mtetra
.583 .78 .973 r
.69793 .38306 .70223 .39289 .7251 .39146 .72097 .38162 Mtetra
.584 .781 .973 r
.72097 .38162 .7251 .39146 .74806 .38997 .74409 .38011 Mtetra
.585 .782 .973 r
.74409 .38011 .74806 .38997 .7711 .38841 .7673 .37854 Mtetra
.586 .783 .973 r
.7673 .37854 .7711 .38841 .79424 .38681 .79061 .37691 Mtetra
.587 .784 .974 r
.79061 .37691 .79424 .38681 .81746 .38515 .814 .37524 Mtetra
.588 .785 .974 r
.814 .37524 .81746 .38515 .84077 .38345 .83748 .37352 Mtetra
.83748 .37352 .84077 .38345 .86417 .38171 .86106 .37175 Mtetra
.589 .786 .974 r
.86106 .37175 .86417 .38171 .88766 .37993 .88472 .36994 Mtetra
.88472 .36994 .88766 .37993 .91124 .37811 .90847 .3681 Mtetra
.59 .787 .974 r
.90847 .3681 .91124 .37811 .9349 .37625 .93232 .36622 Mtetra
.93232 .36622 .9349 .37625 .95866 .37436 .95626 .3643 Mtetra
.294 .608 .954 r
.19013 .31175 .19785 .32135 .2177 .33545 .21054 .31844 Mtetra
.135 .352 .813 r
.21054 .31844 .2177 .33545 .23764 .3516 .23043 .33699 Mtetra
.258 .478 .881 r
.23043 .33699 .23764 .3516 .25802 .36297 .25083 .34978 Mtetra
.343 .562 .918 r
.25083 .34978 .25802 .36297 .27871 .37119 .2716 .35892 Mtetra
.402 .617 .938 r
.2716 .35892 .27871 .37119 .29966 .37724 .29263 .36559 Mtetra
.444 .655 .95 r
.29263 .36559 .29966 .37724 .32079 .38172 .31388 .37051 Mtetra
.474 .682 .957 r
.31388 .37051 .32079 .38172 .34209 .38505 .3353 .37416 Mtetra
.496 .702 .962 r
.3353 .37416 .34209 .38505 .36354 .3875 .35688 .37684 Mtetra
.513 .717 .965 r
.35688 .37684 .36354 .3875 .38512 .38926 .37859 .37878 Mtetra
.526 .729 .967 r
.37859 .37878 .38512 .38926 .40682 .39047 .40043 .38012 Mtetra
.537 .738 .968 r
.40043 .38012 .40682 .39047 .42863 .39123 .42238 .38099 Mtetra
.545 .745 .969 r
.42238 .38099 .42863 .39123 .45054 .39163 .44444 .38147 Mtetra
.552 .751 .97 r
.44444 .38147 .45054 .39163 .47256 .39173 .46661 .38163 Mtetra
.557 .756 .971 r
.46661 .38163 .47256 .39173 .49468 .39157 .48887 .38151 Mtetra
.562 .761 .971 r
.48887 .38151 .49468 .39157 .51689 .39119 .51124 .38117 Mtetra
.566 .764 .971 r
.51124 .38117 .51689 .39119 .5392 .39062 .53371 .38063 Mtetra
.569 .767 .972 r
.53371 .38063 .5392 .39062 .56161 .38989 .55626 .37992 Mtetra
.572 .77 .972 r
.55626 .37992 .56161 .38989 .5841 .38902 .57892 .37906 Mtetra
.575 .772 .972 r
.57892 .37906 .5841 .38902 .60669 .38803 .60166 .37807 Mtetra
.577 .774 .973 r
.60166 .37807 .60669 .38803 .62936 .38692 .6245 .37696 Mtetra
.579 .776 .973 r
.6245 .37696 .62936 .38692 .65213 .38572 .64743 .37576 Mtetra
.58 .777 .973 r
.64743 .37576 .65213 .38572 .67498 .38443 .67045 .37446 Mtetra
.582 .779 .973 r
.67045 .37446 .67498 .38443 .69793 .38306 .69356 .37308 Mtetra
.583 .78 .973 r
.69356 .37308 .69793 .38306 .72097 .38162 .71677 .37162 Mtetra
.584 .781 .973 r
.71677 .37162 .72097 .38162 .74409 .38011 .74006 .3701 Mtetra
.585 .782 .973 r
.74006 .3701 .74409 .38011 .7673 .37854 .76344 .36851 Mtetra
.586 .783 .973 r
.76344 .36851 .7673 .37854 .79061 .37691 .78692 .36687 Mtetra
.587 .784 .974 r
.78692 .36687 .79061 .37691 .814 .37524 .81049 .36517 Mtetra
.588 .784 .974 r
.81049 .36517 .814 .37524 .83748 .37352 .83415 .36343 Mtetra
.588 .785 .974 r
.83415 .36343 .83748 .37352 .86106 .37175 .85789 .36164 Mtetra
.589 .786 .974 r
.85789 .36164 .86106 .37175 .88472 .36994 .88174 .3598 Mtetra
.88174 .3598 .88472 .36994 .90847 .3681 .90567 .35793 Mtetra
.59 .787 .974 r
.90567 .35793 .90847 .3681 .93232 .36622 .9297 .35603 Mtetra
.9297 .35603 .93232 .36622 .95626 .3643 .95381 .35408 Mtetra
.575 .767 .97 r
.18231 .30201 .19013 .31175 .21054 .31844 .20329 .30123 Mtetra
.047 .287 .779 r
.20329 .30123 .21054 .31844 .23043 .33699 .22312 .32218 Mtetra
.205 .441 .866 r
.22312 .32218 .23043 .33699 .25083 .34978 .24355 .33641 Mtetra
.311 .54 .911 r
.24355 .33641 .25083 .34978 .2716 .35892 .26439 .34647 Mtetra
.381 .604 .936 r
.26439 .34647 .2716 .35892 .29263 .36559 .28552 .35377 Mtetra
.43 .647 .949 r
.28552 .35377 .29263 .36559 .31388 .37051 .30687 .35914 Mtetra
.464 .676 .957 r
.30687 .35914 .31388 .37051 .3353 .37416 .32842 .36311 Mtetra
.489 .698 .962 r
.32842 .36311 .3353 .37416 .35688 .37684 .35012 .36603 Mtetra
.508 .714 .965 r
.35012 .36603 .35688 .37684 .37859 .37878 .37197 .36815 Mtetra
.522 .726 .967 r
.37197 .36815 .37859 .37878 .40043 .38012 .39394 .36963 Mtetra
.533 .736 .968 r
.39394 .36963 .40043 .38012 .42238 .38099 .41604 .3706 Mtetra
.542 .744 .969 r
.41604 .3706 .42238 .38099 .44444 .38147 .43825 .37116 Mtetra
.55 .75 .97 r
.43825 .37116 .44444 .38147 .46661 .38163 .46056 .37138 Mtetra
.556 .755 .971 r
.46056 .37138 .46661 .38163 .48887 .38151 .48298 .37131 Mtetra
.561 .76 .971 r
.48298 .37131 .48887 .38151 .51124 .38117 .5055 .371 Mtetra
.565 .763 .972 r
.5055 .371 .51124 .38117 .53371 .38063 .52813 .37048 Mtetra
.568 .766 .972 r
.52813 .37048 .53371 .38063 .55626 .37992 .55084 .36979 Mtetra
.571 .769 .972 r
.55084 .36979 .55626 .37992 .57892 .37906 .57366 .36894 Mtetra
.574 .771 .972 r
.57366 .36894 .57892 .37906 .60166 .37807 .59656 .36796 Mtetra
.576 .774 .973 r
.59656 .36796 .60166 .37807 .6245 .37696 .61957 .36685 Mtetra
.578 .775 .973 r
.61957 .36685 .6245 .37696 .64743 .37576 .64266 .36564 Mtetra
.58 .777 .973 r
.64266 .36564 .64743 .37576 .67045 .37446 .66585 .36433 Mtetra
.581 .778 .973 r
.66585 .36433 .67045 .37446 .69356 .37308 .68913 .36294 Mtetra
.583 .78 .973 r
.68913 .36294 .69356 .37308 .71677 .37162 .7125 .36147 Mtetra
.584 .781 .973 r
.7125 .36147 .71677 .37162 .74006 .3701 .73597 .35993 Mtetra
.585 .782 .973 r
.73597 .35993 .74006 .3701 .76344 .36851 .75953 .35833 Mtetra
.586 .783 .974 r
.75953 .35833 .76344 .36851 .78692 .36687 .78318 .35666 Mtetra
.587 .784 .974 r
.78318 .35666 .78692 .36687 .81049 .36517 .80692 .35495 Mtetra
.80692 .35495 .81049 .36517 .83415 .36343 .83076 .35318 Mtetra
.588 .785 .974 r
.83076 .35318 .83415 .36343 .85789 .36164 .85468 .35137 Mtetra
.589 .786 .974 r
.85468 .35137 .85789 .36164 .88174 .3598 .87871 .34951 Mtetra
.87871 .34951 .88174 .3598 .90567 .35793 .90282 .34761 Mtetra
.59 .787 .974 r
.90282 .34761 .90567 .35793 .9297 .35603 .92703 .34567 Mtetra
.92703 .34567 .9297 .35603 .95381 .35408 .95134 .3437 Mtetra
.617 .786 .963 r
.17437 .29213 .18231 .30201 .20329 .30123 .19559 .28974 Mtetra
0 .254 .76 r
.19559 .28974 .20329 .30123 .22312 .32218 .21572 .30719 Mtetra
.15 .402 .849 r
.21572 .30719 .22312 .32218 .24355 .33641 .23618 .32286 Mtetra
.277 .517 .904 r
.23618 .32286 .24355 .33641 .26439 .34647 .25708 .33386 Mtetra
.36 .59 .932 r
.25708 .33386 .26439 .34647 .28552 .35377 .2783 .34179 Mtetra
.415 .638 .948 r
.2783 .34179 .28552 .35377 .30687 .35914 .29976 .34761 Mtetra
.454 .67 .956 r
.29976 .34761 .30687 .35914 .32842 .36311 .32143 .3519 Mtetra
.481 .694 .961 r
.32143 .3519 .32842 .36311 .35012 .36603 .34326 .35506 Mtetra
.502 .711 .965 r
.34326 .35506 .35012 .36603 .37197 .36815 .36524 .35736 Mtetra
.518 .724 .967 r
.36524 .35736 .37197 .36815 .39394 .36963 .38736 .35898 Mtetra
.53 .734 .968 r
.38736 .35898 .39394 .36963 .41604 .3706 .4096 .36005 Mtetra
.54 .742 .969 r
.4096 .36005 .41604 .3706 .43825 .37116 .43196 .36069 Mtetra
.547 .749 .97 r
.43196 .36069 .43825 .37116 .46056 .37138 .45443 .36097 Mtetra
.554 .754 .971 r
.45443 .36097 .46056 .37138 .48298 .37131 .477 .36095 Mtetra
.559 .759 .971 r
.477 .36095 .48298 .37131 .5055 .371 .49968 .36068 Mtetra
.563 .763 .972 r
.49968 .36068 .5055 .371 .52813 .37048 .52246 .36019 Mtetra
.567 .766 .972 r
.52246 .36019 .52813 .37048 .55084 .36979 .54534 .35951 Mtetra
.57 .769 .972 r
.54534 .35951 .55084 .36979 .57366 .36894 .56831 .35867 Mtetra
.573 .771 .972 r
.56831 .35867 .57366 .36894 .59656 .36796 .59139 .35769 Mtetra
.575 .773 .973 r
.59139 .35769 .59656 .36796 .61957 .36685 .61455 .35658 Mtetra
.577 .775 .973 r
.61455 .35658 .61957 .36685 .64266 .36564 .63782 .35537 Mtetra
.579 .777 .973 r
.63782 .35537 .64266 .36564 .66585 .36433 .66118 .35405 Mtetra
.581 .778 .973 r
.66118 .35405 .66585 .36433 .68913 .36294 .68463 .35265 Mtetra
.582 .779 .973 r
.68463 .35265 .68913 .36294 .7125 .36147 .70817 .35116 Mtetra
.583 .781 .973 r
.70817 .35116 .7125 .36147 .73597 .35993 .73181 .34961 Mtetra
.584 .782 .973 r
.73181 .34961 .73597 .35993 .75953 .35833 .75555 .34798 Mtetra
.585 .782 .974 r
.75555 .34798 .75953 .35833 .78318 .35666 .77937 .3463 Mtetra
.586 .783 .974 r
.77937 .3463 .78318 .35666 .80692 .35495 .8033 .34456 Mtetra
.587 .784 .974 r
.8033 .34456 .80692 .35495 .83076 .35318 .82731 .34277 Mtetra
.588 .785 .974 r
.82731 .34277 .83076 .35318 .85468 .35137 .85142 .34093 Mtetra
.85142 .34093 .85468 .35137 .87871 .34951 .87563 .33905 Mtetra
.589 .786 .974 r
.87563 .33905 .87871 .34951 .90282 .34761 .89993 .33712 Mtetra
.589 .787 .974 r
.89993 .33712 .90282 .34761 .92703 .34567 .92432 .33516 Mtetra
.59 .787 .974 r
.92432 .33516 .92703 .34567 .95134 .3437 .94882 .33316 Mtetra
.617 .786 .963 r
.16632 .28211 .17437 .29213 .19559 .28974 .18767 .27968 Mtetra
.021 .414 .86 r
.18767 .27968 .19559 .28974 .21572 .30719 .20823 .29199 Mtetra
.094 .361 .828 r
.20823 .29199 .21572 .30719 .23618 .32286 .2287 .30913 Mtetra
.242 .493 .895 r
.2287 .30913 .23618 .32286 .25708 .33386 .24966 .32107 Mtetra
.337 .575 .929 r
.24966 .32107 .25708 .33386 .2783 .34179 .27097 .32964 Mtetra
.4 .628 .946 r
.27097 .32964 .2783 .34179 .29976 .34761 .29255 .3359 Mtetra
.443 .664 .956 r
.29255 .3359 .29976 .34761 .32143 .3519 .31434 .34052 Mtetra
.474 .689 .961 r
.31434 .34052 .32143 .3519 .34326 .35506 .3363 .34393 Mtetra
.496 .708 .965 r
.3363 .34393 .34326 .35506 .36524 .35736 .35842 .34641 Mtetra
.513 .721 .967 r
.35842 .34641 .36524 .35736 .38736 .35898 .38068 .34816 Mtetra
.526 .732 .968 r
.38068 .34816 .38736 .35898 .4096 .36005 .40307 .34935 Mtetra
.537 .741 .969 r
.40307 .34935 .4096 .36005 .43196 .36069 .42558 .35007 Mtetra
.545 .748 .97 r
.42558 .35007 .43196 .36069 .45443 .36097 .4482 .35041 Mtetra
.552 .753 .971 r
.4482 .35041 .45443 .36097 .477 .36095 .47093 .35044 Mtetra
.558 .758 .971 r
.47093 .35044 .477 .36095 .49968 .36068 .49377 .3502 Mtetra
.562 .762 .972 r
.49377 .3502 .49968 .36068 .52246 .36019 .51671 .34973 Mtetra
.566 .765 .972 r
.51671 .34973 .52246 .36019 .54534 .35951 .53975 .34907 Mtetra
.569 .768 .972 r
.53975 .34907 .54534 .35951 .56831 .35867 .56289 .34824 Mtetra
.572 .771 .972 r
.56289 .34824 .56831 .35867 .59139 .35769 .58613 .34726 Mtetra
.575 .773 .973 r
.58613 .34726 .59139 .35769 .61455 .35658 .60947 .34616 Mtetra
.577 .775 .973 r
.60947 .34616 .61455 .35658 .63782 .35537 .6329 .34493 Mtetra
.579 .776 .973 r
.6329 .34493 .63782 .35537 .66118 .35405 .65643 .34361 Mtetra
.58 .778 .973 r
.65643 .34361 .66118 .35405 .68463 .35265 .68005 .34219 Mtetra
.582 .779 .973 r
.68005 .34219 .68463 .35265 .70817 .35116 .70377 .3407 Mtetra
.583 .78 .973 r
.70377 .3407 .70817 .35116 .73181 .34961 .72759 .33912 Mtetra
.584 .781 .973 r
.72759 .33912 .73181 .34961 .75555 .34798 .7515 .33748 Mtetra
.585 .782 .974 r
.7515 .33748 .75555 .34798 .77937 .3463 .77551 .33578 Mtetra
.586 .783 .974 r
.77551 .33578 .77937 .3463 .8033 .34456 .79961 .33401 Mtetra
.587 .784 .974 r
.79961 .33401 .8033 .34456 .82731 .34277 .82381 .3322 Mtetra
.588 .785 .974 r
.82381 .3322 .82731 .34277 .85142 .34093 .84811 .33033 Mtetra
.84811 .33033 .85142 .34093 .87563 .33905 .8725 .32842 Mtetra
.589 .786 .974 r
.8725 .32842 .87563 .33905 .89993 .33712 .89699 .32647 Mtetra
.589 .787 .974 r
.89699 .32647 .89993 .33712 .92432 .33516 .92157 .32448 Mtetra
.59 .787 .974 r
.92157 .32448 .92432 .33516 .94882 .33316 .94626 .32244 Mtetra
.617 .786 .963 r
.15814 .27193 .16632 .28211 .18767 .27968 .17964 .26947 Mtetra
.282 .598 .95 r
.17964 .26947 .18767 .27968 .20823 .29199 .20063 .2766 Mtetra
.036 .318 .804 r
.20063 .2766 .20823 .29199 .2287 .30913 .22112 .29521 Mtetra
.206 .468 .885 r
.22112 .29521 .2287 .30913 .24966 .32107 .24214 .3081 Mtetra
.314 .56 .924 r
.24214 .3081 .24966 .32107 .27097 .32964 .26355 .31731 Mtetra
.385 .619 .944 r
.26355 .31731 .27097 .32964 .29255 .3359 .28523 .32403 Mtetra
.432 .657 .955 r
.28523 .32403 .29255 .3359 .31434 .34052 .30714 .32898 Mtetra
.466 .685 .961 r
.30714 .32898 .31434 .34052 .3363 .34393 .32924 .33263 Mtetra
.491 .704 .965 r
.32924 .33263 .3363 .34393 .35842 .34641 .3515 .33529 Mtetra
.509 .719 .967 r
.3515 .33529 .35842 .34641 .38068 .34816 .3739 .33719 Mtetra
.523 .73 .969 r
.3739 .33719 .38068 .34816 .40307 .34935 .39644 .33848 Mtetra
.534 .739 .97 r
.39644 .33848 .40307 .34935 .42558 .35007 .4191 .33929 Mtetra
.543 .746 .97 r
.4191 .33929 .42558 .35007 .4482 .35041 .44188 .33969 Mtetra
.55 .752 .971 r
.44188 .33969 .4482 .35041 .47093 .35044 .46477 .33976 Mtetra
.556 .757 .971 r
.46477 .33976 .47093 .35044 .49377 .3502 .48776 .33956 Mtetra
.561 .761 .972 r
.48776 .33956 .49377 .3502 .51671 .34973 .51087 .33911 Mtetra
.565 .765 .972 r
.51087 .33911 .51671 .34973 .53975 .34907 .53407 .33847 Mtetra
.568 .768 .972 r
.53407 .33847 .53975 .34907 .56289 .34824 .55738 .33765 Mtetra
.571 .77 .973 r
.55738 .33765 .56289 .34824 .58613 .34726 .58079 .33667 Mtetra
.574 .772 .973 r
.58079 .33667 .58613 .34726 .60947 .34616 .6043 .33557 Mtetra
.576 .774 .973 r
.6043 .33557 .60947 .34616 .6329 .34493 .6279 .33434 Mtetra
.578 .776 .973 r
.6279 .33434 .6329 .34493 .65643 .34361 .65161 .33301 Mtetra
.58 .777 .973 r
.65161 .33301 .65643 .34361 .68005 .34219 .67541 .33158 Mtetra
.581 .779 .973 r
.67541 .33158 .68005 .34219 .70377 .3407 .69931 .33006 Mtetra
.583 .78 .973 r
.69931 .33006 .70377 .3407 .72759 .33912 .7233 .32847 Mtetra
.584 .781 .973 r
.7233 .32847 .72759 .33912 .7515 .33748 .7474 .32681 Mtetra
.585 .782 .974 r
.7474 .32681 .7515 .33748 .77551 .33578 .77159 .32508 Mtetra
.586 .783 .974 r
.77159 .32508 .77551 .33578 .79961 .33401 .79587 .3233 Mtetra
.587 .784 .974 r
.79587 .3233 .79961 .33401 .82381 .3322 .82026 .32146 Mtetra
.587 .785 .974 r
.82026 .32146 .82381 .3322 .84811 .33033 .84474 .31957 Mtetra
.588 .785 .974 r
.84474 .31957 .84811 .33033 .8725 .32842 .86932 .31763 Mtetra
.589 .786 .974 r
.86932 .31763 .8725 .32842 .89699 .32647 .894 .31564 Mtetra
.894 .31564 .89699 .32647 .92157 .32448 .91878 .31362 Mtetra
.59 .787 .974 r
.91878 .31362 .92157 .32448 .94626 .32244 .94366 .31156 Mtetra
.617 .786 .963 r
.14985 .2616 .15814 .27193 .17964 .26947 .17149 .2591 Mtetra
.49 .723 .975 r
.17149 .2591 .17964 .26947 .20063 .2766 .19294 .26101 Mtetra
0 .273 .777 r
.19294 .26101 .20063 .2766 .22112 .29521 .21343 .2811 Mtetra
.169 .442 .874 r
.21343 .2811 .22112 .29521 .24214 .3081 .23452 .29494 Mtetra
.291 .545 .919 r
.23452 .29494 .24214 .3081 .26355 .31731 .25601 .30481 Mtetra
.369 .609 .942 r
.25601 .30481 .26355 .31731 .28523 .32403 .27781 .31199 Mtetra
.422 .651 .954 r
.27781 .31199 .28523 .32403 .30714 .32898 .29984 .31727 Mtetra
.458 .68 .96 r
.29984 .31727 .30714 .32898 .32924 .33263 .32207 .32116 Mtetra
.485 .701 .964 r
.32207 .32116 .32924 .33263 .3515 .33529 .34447 .32401 Mtetra
.504 .716 .967 r
.34447 .32401 .3515 .33529 .3739 .33719 .36702 .32605 Mtetra
.52 .728 .969 r
.36702 .32605 .3739 .33719 .39644 .33848 .38971 .32745 Mtetra
.531 .738 .97 r
.38971 .32745 .39644 .33848 .4191 .33929 .41252 .32834 Mtetra
.541 .745 .97 r
.41252 .32834 .4191 .33929 .44188 .33969 .43546 .3288 Mtetra
.548 .751 .971 r
.43546 .3288 .44188 .33969 .46477 .33976 .45851 .32892 Mtetra
.554 .756 .972 r
.45851 .32892 .46477 .33976 .48776 .33956 .48167 .32875 Mtetra
.56 .76 .972 r
.48167 .32875 .48776 .33956 .51087 .33911 .50494 .32833 Mtetra
.564 .764 .972 r
.50494 .32833 .51087 .33911 .53407 .33847 .52831 .3277 Mtetra
.568 .767 .972 r
.52831 .3277 .53407 .33847 .55738 .33765 .55179 .32689 Mtetra
.571 .77 .973 r
.55179 .32689 .55738 .33765 .58079 .33667 .57537 .32592 Mtetra
.573 .772 .973 r
.57537 .32592 .58079 .33667 .6043 .33557 .59905 .32481 Mtetra
.576 .774 .973 r
.59905 .32481 .6043 .33557 .6279 .33434 .62283 .32358 Mtetra
.578 .776 .973 r
.62283 .32358 .6279 .33434 .65161 .33301 .64671 .32223 Mtetra
.579 .777 .973 r
.64671 .32223 .65161 .33301 .67541 .33158 .67069 .32079 Mtetra
.581 .779 .973 r
.67069 .32079 .67541 .33158 .69931 .33006 .69477 .31926 Mtetra
.582 .78 .973 r
.69477 .31926 .69931 .33006 .7233 .32847 .71895 .31765 Mtetra
.583 .781 .973 r
.71895 .31765 .7233 .32847 .7474 .32681 .74322 .31597 Mtetra
.584 .782 .974 r
.74322 .31597 .7474 .32681 .77159 .32508 .7676 .31422 Mtetra
.585 .783 .974 r
.7676 .31422 .77159 .32508 .79587 .3233 .79208 .31241 Mtetra
.586 .784 .974 r
.79208 .31241 .79587 .3233 .82026 .32146 .81665 .31054 Mtetra
.587 .784 .974 r
.81665 .31054 .82026 .32146 .84474 .31957 .84132 .30862 Mtetra
.588 .785 .974 r
.84132 .30862 .84474 .31957 .86932 .31763 .8661 .30666 Mtetra
.588 .786 .974 r
.8661 .30666 .86932 .31763 .894 .31564 .89097 .30464 Mtetra
.589 .786 .974 r
.89097 .30464 .894 .31564 .91878 .31362 .91594 .30259 Mtetra
.589 .787 .974 r
.91594 .30259 .91878 .31362 .94366 .31156 .94101 .3005 Mtetra
.617 .786 .963 r
.14142 .25112 .14985 .2616 .17149 .2591 .16322 .24858 Mtetra
.16322 .24858 .17149 .2591 .19294 .26101 .18509 .24603 Mtetra
0 .233 .752 r
.18509 .24603 .19294 .26101 .21343 .2811 .20564 .26679 Mtetra
.131 .415 .861 r
.20564 .26679 .21343 .2811 .23452 .29494 .22679 .2816 Mtetra
.267 .528 .914 r
.22679 .2816 .23452 .29494 .25601 .30481 .24837 .29212 Mtetra
.353 .598 .939 r
.24837 .29212 .25601 .30481 .27781 .31199 .27027 .29976 Mtetra
.411 .644 .953 r
.27027 .29976 .27781 .31199 .29984 .31727 .29243 .30538 Mtetra
.45 .675 .96 r
.29243 .30538 .29984 .31727 .32207 .32116 .31479 .30953 Mtetra
.479 .697 .964 r
.31479 .30953 .32207 .32116 .34447 .32401 .33734 .31256 Mtetra
.5 .714 .967 r
.33734 .31256 .34447 .32401 .36702 .32605 .36003 .31474 Mtetra
.516 .726 .969 r
.36003 .31474 .36702 .32605 .38971 .32745 .38287 .31625 Mtetra
.529 .736 .97 r
.38287 .31625 .38971 .32745 .41252 .32834 .40584 .31722 Mtetra
.538 .744 .971 r
.40584 .31722 .41252 .32834 .43546 .3288 .42894 .31775 Mtetra
.546 .75 .971 r
.42894 .31775 .43546 .3288 .45851 .32892 .45215 .31792 Mtetra
.553 .755 .972 r
.45215 .31792 .45851 .32892 .48167 .32875 .47548 .31778 Mtetra
.558 .76 .972 r
.47548 .31778 .48167 .32875 .50494 .32833 .49891 .31738 Mtetra
.563 .763 .972 r
.49891 .31738 .50494 .32833 .52831 .3277 .52246 .31677 Mtetra
.567 .766 .972 r
.52246 .31677 .52831 .3277 .55179 .32689 .54611 .31596 Mtetra
.57 .769 .973 r
.54611 .31596 .55179 .32689 .57537 .32592 .56986 .315 Mtetra
.573 .771 .973 r
.56986 .315 .57537 .32592 .59905 .32481 .59372 .31388 Mtetra
.575 .774 .973 r
.59372 .31388 .59905 .32481 .62283 .32358 .61767 .31264 Mtetra
.577 .775 .973 r
.61767 .31264 .62283 .32358 .64671 .32223 .64174 .31129 Mtetra
.579 .777 .973 r
.64174 .31129 .64671 .32223 .67069 .32079 .6659 .30983 Mtetra
.58 .778 .973 r
.6659 .30983 .67069 .32079 .69477 .31926 .69016 .30829 Mtetra
.582 .78 .973 r
.69016 .30829 .69477 .31926 .71895 .31765 .71452 .30666 Mtetra
.583 .781 .974 r
.71452 .30666 .71895 .31765 .74322 .31597 .73899 .30495 Mtetra
.584 .782 .974 r
.73899 .30495 .74322 .31597 .7676 .31422 .76355 .30318 Mtetra
.585 .783 .974 r
.76355 .30318 .7676 .31422 .79208 .31241 .78821 .30134 Mtetra
.586 .784 .974 r
.78821 .30134 .79208 .31241 .81665 .31054 .81298 .29945 Mtetra
.587 .784 .974 r
.81298 .29945 .81665 .31054 .84132 .30862 .83785 .2975 Mtetra
.588 .785 .974 r
.83785 .2975 .84132 .30862 .8661 .30666 .86281 .29551 Mtetra
.588 .786 .974 r
.86281 .29551 .8661 .30666 .89097 .30464 .88788 .29346 Mtetra
.589 .786 .974 r
.88788 .29346 .89097 .30464 .91594 .30259 .91305 .29138 Mtetra
.589 .787 .974 r
.91305 .29138 .91594 .30259 .94101 .3005 .93833 .28925 Mtetra
.617 .786 .963 r
.13287 .24047 .14142 .25112 .16322 .24858 .15482 .2379 Mtetra
.15482 .2379 .16322 .24858 .18509 .24603 .17684 .23531 Mtetra
0 .241 .741 r
.17684 .23531 .18509 .24603 .20564 .26679 .19774 .25229 Mtetra
.093 .387 .846 r
.19774 .25229 .20564 .26679 .22679 .2816 .21894 .26807 Mtetra
.242 .512 .907 r
.21894 .26807 .22679 .2816 .24837 .29212 .24061 .27925 Mtetra
.337 .588 .937 r
.24061 .27925 .24837 .29212 .27027 .29976 .26263 .28736 Mtetra
.399 .637 .951 r
.26263 .28736 .27027 .29976 .29243 .30538 .28491 .29332 Mtetra
.442 .67 .959 r
.28491 .29332 .29243 .30538 .31479 .30953 .30741 .29771 Mtetra
.473 .694 .964 r
.30741 .29771 .31479 .30953 .33734 .31256 .33009 .30093 Mtetra
.495 .711 .967 r
.33009 .30093 .33734 .31256 .36003 .31474 .35294 .30326 Mtetra
.513 .724 .969 r
.35294 .30326 .36003 .31474 .38287 .31625 .37593 .30488 Mtetra
.526 .734 .97 r
.37593 .30488 .38287 .31625 .40584 .31722 .39906 .30593 Mtetra
.536 .742 .971 r
.39906 .30593 .40584 .31722 .42894 .31775 .42232 .30652 Mtetra
.545 .749 .971 r
.42232 .30652 .42894 .31775 .45215 .31792 .44569 .30673 Mtetra
.551 .754 .972 r
.44569 .30673 .45215 .31792 .47548 .31778 .46919 .30663 Mtetra
.557 .759 .972 r
.46919 .30663 .47548 .31778 .49891 .31738 .49279 .30626 Mtetra
.562 .763 .972 r
.49279 .30626 .49891 .31738 .52246 .31677 .51651 .30566 Mtetra
.566 .766 .973 r
.51651 .30566 .52246 .31677 .54611 .31596 .54033 .30486 Mtetra
.569 .769 .973 r
.54033 .30486 .54611 .31596 .56986 .315 .56426 .3039 Mtetra
.572 .771 .973 r
.56426 .3039 .56986 .315 .59372 .31388 .5883 .30278 Mtetra
.574 .773 .973 r
.5883 .30278 .59372 .31388 .61767 .31264 .61244 .30153 Mtetra
.577 .775 .973 r
.61244 .30153 .61767 .31264 .64174 .31129 .63668 .30017 Mtetra
.578 .777 .973 r
.63668 .30017 .64174 .31129 .6659 .30983 .66103 .2987 Mtetra
.58 .778 .973 r
.66103 .2987 .6659 .30983 .69016 .30829 .68547 .29713 Mtetra
.581 .779 .973 r
.68547 .29713 .69016 .30829 .71452 .30666 .71002 .29548 Mtetra
.583 .781 .974 r
.71002 .29548 .71452 .30666 .73899 .30495 .73468 .29376 Mtetra
.584 .782 .974 r
.73468 .29376 .73899 .30495 .76355 .30318 .75943 .29196 Mtetra
.585 .782 .974 r
.75943 .29196 .76355 .30318 .78821 .30134 .78429 .2901 Mtetra
.586 .783 .974 r
.78429 .2901 .78821 .30134 .81298 .29945 .80925 .28818 Mtetra
.587 .784 .974 r
.80925 .28818 .81298 .29945 .83785 .2975 .83431 .2862 Mtetra
.587 .785 .974 r
.83431 .2862 .83785 .2975 .86281 .29551 .85948 .28418 Mtetra
.588 .785 .974 r
.85948 .28418 .86281 .29551 .88788 .29346 .88475 .2821 Mtetra
.589 .786 .974 r
.88475 .2821 .88788 .29346 .91305 .29138 .91012 .27998 Mtetra
.589 .787 .974 r
.91012 .27998 .91305 .29138 .93833 .28925 .9356 .27782 Mtetra
.617 .786 .963 r
.12419 .22967 .13287 .24047 .15482 .2379 .14629 .22705 Mtetra
.14629 .22705 .15482 .2379 .17684 .23531 .16847 .22442 Mtetra
.002 .397 .849 r
.16847 .22442 .17684 .23531 .19774 .25229 .18973 .23758 Mtetra
.054 .358 .83 r
.18973 .23758 .19774 .25229 .21894 .26807 .21098 .25434 Mtetra
.217 .494 .9 r
.21098 .25434 .21894 .26807 .24061 .27925 .23274 .26619 Mtetra
.32 .577 .933 r
.23274 .26619 .24061 .27925 .26263 .28736 .25487 .27477 Mtetra
.388 .63 .95 r
.25487 .27477 .26263 .28736 .28491 .29332 .27727 .28107 Mtetra
.434 .665 .959 r
.27727 .28107 .28491 .29332 .30741 .29771 .29991 .28571 Mtetra
.467 .69 .964 r
.29991 .28571 .30741 .29771 .33009 .30093 .32274 .28913 Mtetra
.491 .708 .967 r
.32274 .28913 .33009 .30093 .35294 .30326 .34573 .2916 Mtetra
.509 .722 .969 r
.34573 .2916 .35294 .30326 .37593 .30488 .36888 .29332 Mtetra
.523 .733 .97 r
.36888 .29332 .37593 .30488 .39906 .30593 .39217 .29446 Mtetra
.534 .741 .971 r
.39217 .29446 .39906 .30593 .42232 .30652 .41559 .29512 Mtetra
.543 .748 .971 r
.41559 .29512 .42232 .30652 .44569 .30673 .43913 .29538 Mtetra
.55 .754 .972 r
.43913 .29538 .44569 .30673 .46919 .30663 .4628 .29531 Mtetra
.556 .758 .972 r
.4628 .29531 .46919 .30663 .49279 .30626 .48658 .29496 Mtetra
.561 .762 .972 r
.48658 .29496 .49279 .30626 .51651 .30566 .51047 .29437 Mtetra
.565 .765 .973 r
.51047 .29437 .51651 .30566 .54033 .30486 .53447 .29359 Mtetra
.568 .768 .973 r
.53447 .29359 .54033 .30486 .56426 .3039 .55858 .29262 Mtetra
.571 .771 .973 r
.55858 .29262 .56426 .3039 .5883 .30278 .58279 .2915 Mtetra
.574 .773 .973 r
.58279 .2915 .5883 .30278 .61244 .30153 .60712 .29024 Mtetra
.576 .775 .973 r
.60712 .29024 .61244 .30153 .63668 .30017 .63154 .28887 Mtetra
.578 .776 .973 r
.63154 .28887 .63668 .30017 .66103 .2987 .65608 .28738 Mtetra
.58 .778 .973 r
.65608 .28738 .66103 .2987 .68547 .29713 .68071 .2858 Mtetra
.581 .779 .973 r
.68071 .2858 .68547 .29713 .71002 .29548 .70545 .28413 Mtetra
.582 .78 .974 r
.70545 .28413 .71002 .29548 .73468 .29376 .7303 .28238 Mtetra
.584 .781 .974 r
.7303 .28238 .73468 .29376 .75943 .29196 .75525 .28056 Mtetra
.585 .782 .974 r
.75525 .28056 .75943 .29196 .78429 .2901 .7803 .27867 Mtetra
.586 .783 .974 r
.7803 .27867 .78429 .2901 .80925 .28818 .80546 .27672 Mtetra
.586 .784 .974 r
.80546 .27672 .80925 .28818 .83431 .2862 .83072 .27471 Mtetra
.587 .785 .974 r
.83072 .27471 .83431 .2862 .85948 .28418 .85609 .27266 Mtetra
.588 .785 .974 r
.85609 .27266 .85948 .28418 .88475 .2821 .88156 .27055 Mtetra
.588 .786 .974 r
.88156 .27055 .88475 .2821 .91012 .27998 .90714 .2684 Mtetra
.589 .787 .974 r
.90714 .2684 .91012 .27998 .9356 .27782 .93282 .2662 Mtetra
.617 .786 .963 r
.11538 .21869 .12419 .22967 .14629 .22705 .13763 .21604 Mtetra
.13763 .21604 .14629 .22705 .16847 .22442 .15996 .21337 Mtetra
.193 .537 .926 r
.15996 .21337 .16847 .22442 .18973 .23758 .1816 .22265 Mtetra
.015 .328 .813 r
.1816 .22265 .18973 .23758 .21098 .25434 .20291 .24041 Mtetra
.191 .476 .893 r
.20291 .24041 .21098 .25434 .23274 .26619 .22475 .25293 Mtetra
.304 .566 .93 r
.22475 .25293 .23274 .26619 .25487 .27477 .24699 .26199 Mtetra
.377 .623 .948 r
.24699 .26199 .25487 .27477 .27727 .28107 .26952 .26863 Mtetra
.426 .66 .958 r
.26952 .26863 .27727 .28107 .29991 .28571 .29229 .27353 Mtetra
.461 .687 .964 r
.29229 .27353 .29991 .28571 .32274 .28913 .31527 .27714 Mtetra
.486 .706 .967 r
.31527 .27714 .32274 .28913 .34573 .2916 .33842 .27975 Mtetra
.505 .72 .969 r
.33842 .27975 .34573 .2916 .36888 .29332 .36172 .28159 Mtetra
.52 .731 .97 r
.36172 .28159 .36888 .29332 .39217 .29446 .38517 .28281 Mtetra
.532 .74 .971 r
.38517 .28281 .39217 .29446 .41559 .29512 .40876 .28353 Mtetra
.541 .747 .971 r
.40876 .28353 .41559 .29512 .43913 .29538 .43247 .28384 Mtetra
.548 .753 .972 r
.43247 .28384 .43913 .29538 .4628 .29531 .45631 .2838 Mtetra
.554 .757 .972 r
.45631 .2838 .4628 .29531 .48658 .29496 .48026 .28348 Mtetra
.56 .761 .972 r
.48026 .28348 .48658 .29496 .51047 .29437 .50433 .28291 Mtetra
.564 .765 .973 r
.50433 .28291 .51047 .29437 .53447 .29359 .52851 .28213 Mtetra
.567 .768 .973 r
.52851 .28213 .53447 .29359 .55858 .29262 .5528 .28116 Mtetra
.57 .77 .973 r
.5528 .28116 .55858 .29262 .58279 .2915 .5772 .28004 Mtetra
.573 .772 .973 r
.5772 .28004 .58279 .2915 .60712 .29024 .60171 .27877 Mtetra
.575 .774 .973 r
.60171 .27877 .60712 .29024 .63154 .28887 .62632 .27738 Mtetra
.577 .776 .973 r
.62632 .27738 .63154 .28887 .65608 .28738 .65104 .27588 Mtetra
.579 .778 .973 r
.65104 .27588 .65608 .28738 .68071 .2858 .67587 .27428 Mtetra
.581 .779 .973 r
.67587 .27428 .68071 .2858 .70545 .28413 .70081 .27259 Mtetra
.582 .78 .974 r
.70081 .27259 .70545 .28413 .7303 .28238 .72585 .27081 Mtetra
.583 .781 .974 r
.72585 .27081 .7303 .28238 .75525 .28056 .75099 .26897 Mtetra
.584 .782 .974 r
.75099 .26897 .75525 .28056 .7803 .27867 .77625 .26705 Mtetra
.585 .783 .974 r
.77625 .26705 .7803 .27867 .80546 .27672 .80161 .26507 Mtetra
.586 .784 .974 r
.80161 .26507 .80546 .27672 .83072 .27471 .82707 .26303 Mtetra
.587 .785 .974 r
.82707 .26303 .83072 .27471 .85609 .27266 .85264 .26094 Mtetra
.588 .785 .974 r
.85264 .26094 .85609 .27266 .88156 .27055 .87832 .2588 Mtetra
.588 .786 .974 r
.87832 .2588 .88156 .27055 .90714 .2684 .90411 .25661 Mtetra
.589 .786 .974 r
.90411 .25661 .90714 .2684 .93282 .2662 .93 .25438 Mtetra
.617 .786 .963 r
.10642 .20755 .11538 .21869 .13763 .21604 .12883 .20485 Mtetra
.12883 .20485 .13763 .21604 .15996 .21337 .15132 .20214 Mtetra
.363 .649 .965 r
.15132 .20214 .15996 .21337 .1816 .22265 .17336 .20752 Mtetra
0 .298 .794 r
.17336 .20752 .1816 .22265 .20291 .24041 .19471 .22627 Mtetra
.165 .458 .884 r
.19471 .22627 .20291 .24041 .22475 .25293 .21664 .23947 Mtetra
.286 .554 .926 r
.21664 .23947 .22475 .25293 .24699 .26199 .23899 .24901 Mtetra
.365 .615 .947 r
.23899 .24901 .24699 .26199 .26952 .26863 .26165 .256 Mtetra
.418 .655 .957 r
.26165 .256 .26952 .26863 .29229 .27353 .28456 .26116 Mtetra
.455 .683 .963 r
.28456 .26116 .29229 .27353 .31527 .27714 .30768 .26496 Mtetra
.482 .703 .967 r
.30768 .26496 .31527 .27714 .33842 .27975 .33098 .26772 Mtetra
.502 .718 .969 r
.33098 .26772 .33842 .27975 .36172 .28159 .35445 .26967 Mtetra
.517 .729 .97 r
.35445 .26967 .36172 .28159 .38517 .28281 .37806 .27098 Mtetra
.529 .739 .971 r
.37806 .27098 .38517 .28281 .40876 .28353 .40182 .27176 Mtetra
.539 .746 .971 r
.40182 .27176 .40876 .28353 .43247 .28384 .4257 .27211 Mtetra
.547 .752 .972 r
.4257 .27211 .43247 .28384 .45631 .2838 .44971 .27211 Mtetra
.553 .757 .972 r
.44971 .27211 .45631 .2838 .48026 .28348 .47384 .27181 Mtetra
.558 .761 .972 r
.47384 .27181 .48026 .28348 .50433 .28291 .49809 .27125 Mtetra
.563 .764 .973 r
.49809 .27125 .50433 .28291 .52851 .28213 .52245 .27048 Mtetra
.567 .767 .973 r
.52245 .27048 .52851 .28213 .5528 .28116 .54693 .26952 Mtetra
.57 .77 .973 r
.54693 .26952 .5528 .28116 .5772 .28004 .57151 .26839 Mtetra
.573 .772 .973 r
.57151 .26839 .5772 .28004 .60171 .27877 .59621 .26711 Mtetra
.575 .774 .973 r
.59621 .26711 .60171 .27877 .62632 .27738 .62101 .26571 Mtetra
.577 .776 .973 r
.62101 .26571 .62632 .27738 .65104 .27588 .64593 .26419 Mtetra
.579 .777 .973 r
.64593 .26419 .65104 .27588 .67587 .27428 .67095 .26257 Mtetra
.58 .779 .974 r
.67095 .26257 .67587 .27428 .70081 .27259 .69608 .26085 Mtetra
.582 .78 .974 r
.69608 .26085 .70081 .27259 .72585 .27081 .72132 .25906 Mtetra
.583 .781 .974 r
.72132 .25906 .72585 .27081 .75099 .26897 .74667 .25718 Mtetra
.584 .782 .974 r
.74667 .25718 .75099 .26897 .77625 .26705 .77212 .25524 Mtetra
.585 .783 .974 r
.77212 .25524 .77625 .26705 .80161 .26507 .79769 .25323 Mtetra
.586 .784 .974 r
.79769 .25323 .80161 .26507 .82707 .26303 .82336 .25116 Mtetra
.587 .784 .974 r
.82336 .25116 .82707 .26303 .85264 .26094 .84914 .24903 Mtetra
.588 .785 .974 r
.84914 .24903 .85264 .26094 .87832 .2588 .87503 .24686 Mtetra
.588 .786 .974 r
.87503 .24686 .87832 .2588 .90411 .25661 .90102 .24464 Mtetra
.589 .786 .974 r
.90102 .24464 .90411 .25661 .93 .25438 .92713 .24237 Mtetra
.617 .786 .963 r
.09733 .19623 .10642 .20755 .12883 .20485 .1199 .19349 Mtetra
.1199 .19349 .12883 .20485 .15132 .20214 .14255 .19074 Mtetra
.503 .729 .974 r
.14255 .19074 .15132 .20214 .17336 .20752 .165 .19217 Mtetra
0 .267 .774 r
.165 .19217 .17336 .20752 .19471 .22627 .1864 .21193 Mtetra
.139 .439 .875 r
.1864 .21193 .19471 .22627 .21664 .23947 .20841 .22582 Mtetra
.269 .543 .922 r
.20841 .22582 .21664 .23947 .23899 .24901 .23087 .23583 Mtetra
.353 .607 .945 r
.23087 .23583 .23899 .24901 .26165 .256 .25365 .24318 Mtetra
.409 .65 .956 r
.25365 .24318 .26165 .256 .28456 .26116 .2767 .2486 Mtetra
.449 .679 .963 r
.2767 .2486 .28456 .26116 .30768 .26496 .29997 .25259 Mtetra
.477 .7 .966 r
.29997 .25259 .30768 .26496 .33098 .26772 .32343 .2555 Mtetra
.498 .716 .969 r
.32343 .2555 .33098 .26772 .35445 .26967 .34706 .25756 Mtetra
.514 .728 .97 r
.34706 .25756 .35445 .26967 .37806 .27098 .37084 .25895 Mtetra
.527 .737 .971 r
.37084 .25895 .37806 .27098 .40182 .27176 .39476 .2598 Mtetra
.537 .745 .972 r
.39476 .2598 .40182 .27176 .4257 .27211 .41882 .2602 Mtetra
.545 .751 .972 r
.41882 .2602 .4257 .27211 .44971 .27211 .44301 .26023 Mtetra
.552 .756 .972 r
.44301 .26023 .44971 .27211 .47384 .27181 .46732 .25995 Mtetra
.557 .76 .973 r
.46732 .25995 .47384 .27181 .49809 .27125 .49175 .25941 Mtetra
.562 .764 .973 r
.49175 .25941 .49809 .27125 .52245 .27048 .51629 .25864 Mtetra
.566 .767 .973 r
.51629 .25864 .52245 .27048 .54693 .26952 .54096 .25768 Mtetra
.569 .769 .973 r
.54096 .25768 .54693 .26952 .57151 .26839 .56573 .25654 Mtetra
.572 .772 .973 r
.56573 .25654 .57151 .26839 .59621 .26711 .59062 .25526 Mtetra
.574 .774 .973 r
.59062 .25526 .59621 .26711 .62101 .26571 .61562 .25384 Mtetra
.576 .775 .973 r
.61562 .25384 .62101 .26571 .64593 .26419 .64073 .2523 Mtetra
.578 .777 .973 r
.64073 .2523 .64593 .26419 .67095 .26257 .66595 .25066 Mtetra
.58 .778 .974 r
.66595 .25066 .67095 .26257 .69608 .26085 .69128 .24893 Mtetra
.581 .78 .974 r
.69128 .24893 .69608 .26085 .72132 .25906 .71672 .2471 Mtetra
.583 .781 .974 r
.71672 .2471 .72132 .25906 .74667 .25718 .74227 .2452 Mtetra
.584 .782 .974 r
.74227 .2452 .74667 .25718 .77212 .25524 .76793 .24322 Mtetra
.585 .783 .974 r
.76793 .24322 .77212 .25524 .79769 .25323 .7937 .24118 Mtetra
.586 .784 .974 r
.7937 .24118 .79769 .25323 .82336 .25116 .81958 .23908 Mtetra
.587 .784 .974 r
.81958 .23908 .82336 .25116 .84914 .24903 .84557 .23692 Mtetra
.587 .785 .974 r
.84557 .23692 .84914 .24903 .87503 .24686 .87167 .23471 Mtetra
.588 .786 .974 r
.87167 .23471 .87503 .24686 .90102 .24464 .89789 .23245 Mtetra
.589 .786 .974 r
.89789 .23245 .90102 .24464 .92713 .24237 .92421 .23014 Mtetra
.617 .786 .963 r
.0881 .18473 .09733 .19623 .1199 .19349 .11082 .18195 Mtetra
.11082 .18195 .1199 .19349 .14255 .19074 .13364 .17915 Mtetra
.611 .783 .964 r
.13364 .17915 .14255 .19074 .165 .19217 .15652 .1766 Mtetra
0 .236 .753 r
.15652 .1766 .165 .19217 .1864 .21193 .17796 .19737 Mtetra
.112 .419 .865 r
.17796 .19737 .1864 .21193 .20841 .22582 .20006 .21195 Mtetra
.251 .53 .918 r
.20006 .21195 .20841 .22582 .23087 .23583 .22262 .22246 Mtetra
.341 .6 .943 r
.22262 .22246 .23087 .23583 .25365 .24318 .24554 .23015 Mtetra
.401 .645 .956 r
.24554 .23015 .25365 .24318 .2767 .2486 .26873 .23584 Mtetra
.442 .675 .962 r
.26873 .23584 .2767 .2486 .29997 .25259 .29214 .24003 Mtetra
.472 .697 .966 r
.29214 .24003 .29997 .25259 .32343 .2555 .31576 .24308 Mtetra
.495 .714 .969 r
.31576 .24308 .32343 .2555 .34706 .25756 .33955 .24526 Mtetra
.512 .726 .97 r
.33955 .24526 .34706 .25756 .37084 .25895 .3635 .24673 Mtetra
.525 .736 .971 r
.3635 .24673 .37084 .25895 .39476 .2598 .3876 .24764 Mtetra
.535 .744 .972 r
.3876 .24764 .39476 .2598 .41882 .2602 .41183 .24809 Mtetra
.544 .75 .972 r
.41183 .24809 .41882 .2602 .44301 .26023 .43619 .24816 Mtetra
.55 .755 .972 r
.43619 .24816 .44301 .26023 .46732 .25995 .46069 .2479 Mtetra
.556 .759 .973 r
.46069 .2479 .46732 .25995 .49175 .25941 .4853 .24737 Mtetra
.561 .763 .973 r
.4853 .24737 .49175 .25941 .51629 .25864 .51004 .24661 Mtetra
.565 .766 .973 r
.51004 .24661 .51629 .25864 .54096 .25768 .53489 .24564 Mtetra
.568 .769 .973 r
.53489 .24564 .54096 .25768 .56573 .25654 .55986 .2445 Mtetra
.571 .771 .973 r
.55986 .2445 .56573 .25654 .59062 .25526 .58494 .24321 Mtetra
.574 .773 .973 r
.58494 .24321 .59062 .25526 .61562 .25384 .61013 .24177 Mtetra
.576 .775 .973 r
.61013 .24177 .61562 .25384 .64073 .2523 .63544 .24022 Mtetra
.578 .777 .973 r
.63544 .24022 .64073 .2523 .66595 .25066 .66086 .23856 Mtetra
.58 .778 .974 r
.66086 .23856 .66595 .25066 .69128 .24893 .6864 .23679 Mtetra
.581 .779 .974 r
.6864 .23679 .69128 .24893 .71672 .2471 .71204 .23494 Mtetra
.582 .781 .974 r
.71204 .23494 .71672 .2471 .74227 .2452 .7378 .23301 Mtetra
.584 .782 .974 r
.7378 .23301 .74227 .2452 .76793 .24322 .76367 .23101 Mtetra
.585 .783 .974 r
.76367 .23101 .76793 .24322 .7937 .24118 .78965 .22893 Mtetra
.586 .783 .974 r
.78965 .22893 .7937 .24118 .81958 .23908 .81574 .2268 Mtetra
.586 .784 .974 r
.81574 .2268 .81958 .23908 .84557 .23692 .84195 .2246 Mtetra
.587 .785 .974 r
.84195 .2246 .84557 .23692 .87167 .23471 .86827 .22236 Mtetra
.588 .786 .974 r
.86827 .22236 .87167 .23471 .89789 .23245 .8947 .22006 Mtetra
.8947 .22006 .89789 .23245 .92421 .23014 .92124 .21771 Mtetra
.617 .786 .963 r
.07871 .17305 .0881 .18473 .11082 .18195 .1016 .17022 Mtetra
.1016 .17022 .11082 .18195 .13364 .17915 .12458 .16738 Mtetra
.12458 .16738 .13364 .17915 .15652 .1766 .14765 .16453 Mtetra
0 .234 .738 r
.14765 .16453 .15652 .1766 .17796 .19737 .16939 .18259 Mtetra
.086 .399 .855 r
.16939 .18259 .17796 .19737 .20006 .21195 .19157 .19787 Mtetra
.233 .518 .913 r
.19157 .19787 .20006 .21195 .22262 .22246 .21425 .20887 Mtetra
.329 .592 .94 r
.21425 .20887 .22262 .22246 .24554 .23015 .23729 .21692 Mtetra
.392 .639 .954 r
.23729 .21692 .24554 .23015 .26873 .23584 .26062 .22287 Mtetra
.436 .672 .962 r
.26062 .22287 .26873 .23584 .29214 .24003 .28419 .22726 Mtetra
.468 .695 .966 r
.28419 .22726 .29214 .24003 .31576 .24308 .30797 .23047 Mtetra
.491 .712 .969 r
.30797 .23047 .31576 .24308 .33955 .24526 .33192 .23275 Mtetra
.509 .724 .97 r
.33192 .23275 .33955 .24526 .3635 .24673 .35604 .23431 Mtetra
.522 .735 .971 r
.35604 .23431 .3635 .24673 .3876 .24764 .38031 .23529 Mtetra
.533 .743 .972 r
.38031 .23529 .3876 .24764 .41183 .24809 .40472 .23578 Mtetra
.542 .749 .972 r
.40472 .23578 .41183 .24809 .43619 .24816 .42927 .23588 Mtetra
.549 .754 .972 r
.42927 .23588 .43619 .24816 .46069 .2479 .45395 .23565 Mtetra
.555 .759 .973 r
.45395 .23565 .46069 .2479 .4853 .24737 .47875 .23513 Mtetra
.56 .763 .973 r
.47875 .23513 .4853 .24737 .51004 .24661 .50367 .23437 Mtetra
.564 .766 .973 r
.50367 .23437 .51004 .24661 .53489 .24564 .52872 .23341 Mtetra
.568 .769 .973 r
.52872 .23341 .53489 .24564 .55986 .2445 .55388 .23226 Mtetra
.571 .771 .973 r
.55388 .23226 .55986 .2445 .58494 .24321 .57916 .23095 Mtetra
.573 .773 .973 r
.57916 .23095 .58494 .24321 .61013 .24177 .60456 .2295 Mtetra
.576 .775 .973 r
.60456 .2295 .61013 .24177 .63544 .24022 .63007 .22793 Mtetra
.578 .777 .974 r
.63007 .22793 .63544 .24022 .66086 .23856 .65569 .22624 Mtetra
.579 .778 .974 r
.65569 .22624 .66086 .23856 .6864 .23679 .68143 .22446 Mtetra
.581 .779 .974 r
.68143 .22446 .6864 .23679 .71204 .23494 .70729 .22258 Mtetra
.582 .78 .974 r
.70729 .22258 .71204 .23494 .7378 .23301 .73325 .22062 Mtetra
.583 .781 .974 r
.73325 .22062 .7378 .23301 .76367 .23101 .75933 .21858 Mtetra
.584 .782 .974 r
.75933 .21858 .76367 .23101 .78965 .22893 .78553 .21648 Mtetra
.585 .783 .974 r
.78553 .21648 .78965 .22893 .81574 .2268 .81184 .2143 Mtetra
.586 .784 .974 r
.81184 .2143 .81574 .2268 .84195 .2246 .83826 .21207 Mtetra
.587 .785 .974 r
.83826 .21207 .84195 .2246 .86827 .22236 .8648 .20979 Mtetra
.588 .785 .974 r
.8648 .20979 .86827 .22236 .8947 .22006 .89145 .20745 Mtetra
.588 .786 .974 r
.89145 .20745 .8947 .22006 .92124 .21771 .91822 .20506 Mtetra
.617 .786 .963 r
.06918 .16119 .07871 .17305 .1016 .17022 .09223 .15831 Mtetra
.09223 .15831 .1016 .17022 .12458 .16738 .11538 .15542 Mtetra
.11538 .15542 .12458 .16738 .14765 .16453 .13862 .15252 Mtetra
0 .343 .815 r
.13862 .15252 .14765 .16453 .16939 .18259 .1607 .16759 Mtetra
.058 .379 .843 r
.1607 .16759 .16939 .18259 .19157 .19787 .18296 .18357 Mtetra
.215 .505 .907 r
.18296 .18357 .19157 .19787 .21425 .20887 .20574 .19507 Mtetra
.316 .583 .938 r
.20574 .19507 .21425 .20887 .23729 .21692 .22891 .20348 Mtetra
.383 .634 .953 r
.22891 .20348 .23729 .21692 .26062 .22287 .25239 .2097 Mtetra
.43 .668 .961 r
.25239 .2097 .26062 .22287 .28419 .22726 .27611 .21429 Mtetra
.463 .692 .966 r
.27611 .21429 .28419 .22726 .30797 .23047 .30004 .21764 Mtetra
.487 .709 .968 r
.30004 .21764 .30797 .23047 .33192 .23275 .32417 .22005 Mtetra
.506 .723 .97 r
.32417 .22005 .33192 .23275 .35604 .23431 .34846 .22169 Mtetra
.52 .733 .971 r
.34846 .22169 .35604 .23431 .38031 .23529 .3729 .22273 Mtetra
.531 .741 .972 r
.3729 .22273 .38031 .23529 .40472 .23578 .3975 .22327 Mtetra
.54 .748 .972 r
.3975 .22327 .40472 .23578 .42927 .23588 .42223 .2234 Mtetra
.548 .754 .972 r
.42223 .2234 .42927 .23588 .45395 .23565 .44709 .22319 Mtetra
.554 .758 .973 r
.44709 .22319 .45395 .23565 .47875 .23513 .47209 .22269 Mtetra
.559 .762 .973 r
.47209 .22269 .47875 .23513 .50367 .23437 .4972 .22193 Mtetra
.563 .765 .973 r
.4972 .22193 .50367 .23437 .52872 .23341 .52244 .22097 Mtetra
.567 .768 .973 r
.52244 .22097 .52872 .23341 .55388 .23226 .5478 .21981 Mtetra
.57 .771 .973 r
.5478 .21981 .55388 .23226 .57916 .23095 .57329 .21849 Mtetra
.573 .773 .973 r
.57329 .21849 .57916 .23095 .60456 .2295 .59888 .21702 Mtetra
.575 .775 .973 r
.59888 .21702 .60456 .2295 .63007 .22793 .6246 .21543 Mtetra
.577 .776 .974 r
.6246 .21543 .63007 .22793 .65569 .22624 .65043 .21372 Mtetra
.579 .778 .974 r
.65043 .21372 .65569 .22624 .68143 .22446 .67638 .21191 Mtetra
.58 .779 .974 r
.67638 .21191 .68143 .22446 .70729 .22258 .70244 .21 Mtetra
.582 .78 .974 r
.70244 .21 .70729 .22258 .73325 .22062 .72863 .20801 Mtetra
.583 .781 .974 r
.72863 .20801 .73325 .22062 .75933 .21858 .75492 .20594 Mtetra
.584 .782 .974 r
.75492 .20594 .75933 .21858 .78553 .21648 .78133 .2038 Mtetra
.585 .783 .974 r
.78133 .2038 .78553 .21648 .81184 .2143 .80786 .20159 Mtetra
.586 .784 .974 r
.80786 .20159 .81184 .2143 .83826 .21207 .83451 .19932 Mtetra
.587 .785 .974 r
.83451 .19932 .83826 .21207 .8648 .20979 .86127 .197 Mtetra
.86127 .197 .8648 .20979 .89145 .20745 .88815 .19462 Mtetra
.588 .786 .974 r
.88815 .19462 .89145 .20745 .91822 .20506 .91514 .19219 Mtetra
.617 .786 .963 r
.05949 .14913 .06918 .16119 .09223 .15831 .08271 .1462 Mtetra
.08271 .1462 .09223 .15831 .11538 .15542 .10603 .14327 Mtetra
.10603 .14327 .11538 .15542 .13862 .15252 .12944 .14032 Mtetra
.082 .455 .884 r
.12944 .14032 .13862 .15252 .1607 .16759 .15187 .15236 Mtetra
.031 .358 .831 r
.15187 .15236 .1607 .16759 .18296 .18357 .17421 .16905 Mtetra
.197 .492 .902 r
.17421 .16905 .18296 .18357 .20574 .19507 .1971 .18105 Mtetra
.304 .575 .935 r
.1971 .18105 .20574 .19507 .22891 .20348 .2204 .18983 Mtetra
.375 .628 .952 r
.2204 .18983 .22891 .20348 .25239 .2097 .24402 .19631 Mtetra
.423 .664 .961 r
.24402 .19631 .25239 .2097 .27611 .21429 .26789 .2011 Mtetra
.458 .689 .966 r
.26789 .2011 .27611 .21429 .30004 .21764 .29199 .20461 Mtetra
.484 .707 .968 r
.29199 .20461 .30004 .21764 .32417 .22005 .31628 .20713 Mtetra
.503 .721 .97 r
.31628 .20713 .32417 .22005 .34846 .22169 .34075 .20886 Mtetra
.518 .732 .971 r
.34075 .20886 .34846 .22169 .3729 .22273 .36538 .20996 Mtetra
.529 .74 .972 r
.36538 .20996 .3729 .22273 .3975 .22327 .39015 .21055 Mtetra
.539 .747 .972 r
.39015 .21055 .3975 .22327 .42223 .2234 .41507 .21072 Mtetra
.547 .753 .973 r
.41507 .21072 .42223 .2234 .44709 .22319 .44012 .21052 Mtetra
.553 .758 .973 r
.44012 .21052 .44709 .22319 .47209 .22269 .46531 .21003 Mtetra
.558 .762 .973 r
.46531 .21003 .47209 .22269 .4972 .22193 .49062 .20928 Mtetra
.563 .765 .973 r
.49062 .20928 .4972 .22193 .52244 .22097 .51606 .20831 Mtetra
.566 .768 .973 r
.51606 .20831 .52244 .22097 .5478 .21981 .54163 .20715 Mtetra
.569 .77 .973 r
.54163 .20715 .5478 .21981 .57329 .21849 .56731 .20581 Mtetra
.572 .772 .973 r
.56731 .20581 .57329 .21849 .59888 .21702 .59311 .20433 Mtetra
.575 .774 .973 r
.59311 .20433 .59888 .21702 .6246 .21543 .61904 .20272 Mtetra
.577 .776 .974 r
.61904 .20272 .6246 .21543 .65043 .21372 .64508 .20098 Mtetra
.578 .778 .974 r
.64508 .20098 .65043 .21372 .67638 .21191 .67124 .19914 Mtetra
.58 .779 .974 r
.67124 .19914 .67638 .21191 .70244 .21 .69752 .19721 Mtetra
.582 .78 .974 r
.69752 .19721 .70244 .21 .72863 .20801 .72392 .19518 Mtetra
.583 .781 .974 r
.72392 .19518 .72863 .20801 .75492 .20594 .75043 .19308 Mtetra
.584 .782 .974 r
.75043 .19308 .75492 .20594 .78133 .2038 .77707 .1909 Mtetra
.585 .783 .974 r
.77707 .1909 .78133 .2038 .80786 .20159 .80382 .18866 Mtetra
.586 .784 .974 r
.80382 .18866 .80786 .20159 .83451 .19932 .83069 .18635 Mtetra
.587 .785 .974 r
.83069 .18635 .83451 .19932 .86127 .197 .85768 .18398 Mtetra
.85768 .18398 .86127 .197 .88815 .19462 .88479 .18156 Mtetra
.588 .786 .974 r
.88479 .18156 .88815 .19462 .91514 .19219 .91201 .17909 Mtetra
.617 .786 .963 r
.04964 .13687 .05949 .14913 .08271 .1462 .07304 .1339 Mtetra
.07304 .1339 .08271 .1462 .10603 .14327 .09653 .13092 Mtetra
.09653 .13092 .10603 .14327 .12944 .14032 .12011 .12792 Mtetra
.222 .555 .933 r
.12011 .12792 .12944 .14032 .15187 .15236 .14291 .1369 Mtetra
.004 .337 .819 r
.14291 .1369 .15187 .15236 .17421 .16905 .16532 .15431 Mtetra
.178 .479 .896 r
.16532 .15431 .17421 .16905 .1971 .18105 .18832 .16681 Mtetra
.291 .566 .933 r
.18832 .16681 .1971 .18105 .2204 .18983 .21175 .17596 Mtetra
.366 .622 .951 r
.21175 .17596 .2204 .18983 .24402 .19631 .23551 .18271 Mtetra
.417 .66 .96 r
.23551 .18271 .24402 .19631 .26789 .2011 .25954 .1877 Mtetra
.453 .686 .965 r
.25954 .1877 .26789 .2011 .29199 .20461 .28381 .19136 Mtetra
.48 .705 .968 r
.28381 .19136 .29199 .20461 .31628 .20713 .30827 .19399 Mtetra
.5 .719 .97 r
.30827 .19399 .31628 .20713 .34075 .20886 .33291 .19581 Mtetra
.515 .73 .971 r
.33291 .19581 .34075 .20886 .36538 .20996 .35772 .19698 Mtetra
.528 .739 .972 r
.35772 .19698 .36538 .20996 .39015 .21055 .38268 .19762 Mtetra
.537 .746 .972 r
.38268 .19762 .39015 .21055 .41507 .21072 .40779 .19781 Mtetra
.545 .752 .973 r
.40779 .19781 .41507 .21072 .44012 .21052 .43304 .19764 Mtetra
.552 .757 .973 r
.43304 .19764 .44012 .21052 .46531 .21003 .45842 .19716 Mtetra
.557 .761 .973 r
.45842 .19716 .46531 .21003 .49062 .20928 .48393 .19641 Mtetra
.562 .764 .973 r
.48393 .19641 .49062 .20928 .51606 .20831 .50957 .19544 Mtetra
.566 .767 .973 r
.50957 .19544 .51606 .20831 .54163 .20715 .53534 .19427 Mtetra
.569 .77 .973 r
.53534 .19427 .54163 .20715 .56731 .20581 .56123 .19292 Mtetra
.572 .772 .973 r
.56123 .19292 .56731 .20581 .59311 .20433 .58724 .19142 Mtetra
.574 .774 .974 r
.58724 .19142 .59311 .20433 .61904 .20272 .61338 .18978 Mtetra
.576 .776 .974 r
.61338 .18978 .61904 .20272 .64508 .20098 .63964 .18802 Mtetra
.578 .777 .974 r
.63964 .18802 .64508 .20098 .67124 .19914 .66601 .18615 Mtetra
.58 .779 .974 r
.66601 .18615 .67124 .19914 .69752 .19721 .69251 .18419 Mtetra
.581 .78 .974 r
.69251 .18419 .69752 .19721 .72392 .19518 .71913 .18213 Mtetra
.583 .781 .974 r
.71913 .18213 .72392 .19518 .75043 .19308 .74587 .17999 Mtetra
.584 .782 .974 r
.74587 .17999 .75043 .19308 .77707 .1909 .77272 .17778 Mtetra
.585 .783 .974 r
.77272 .17778 .77707 .1909 .80382 .18866 .7997 .17549 Mtetra
.586 .784 .974 r
.7997 .17549 .80382 .18866 .83069 .18635 .8268 .17315 Mtetra
.8268 .17315 .83069 .18635 .85768 .18398 .85402 .17074 Mtetra
.587 .785 .974 r
.85402 .17074 .85768 .18398 .88479 .18156 .88137 .16827 Mtetra
.588 .786 .974 r
.88137 .16827 .88479 .18156 .91201 .17909 .90883 .16576 Mtetra
.617 .786 .963 r
.03963 .12441 .04964 .13687 .07304 .1339 .0632 .12139 Mtetra
.0632 .12139 .07304 .1339 .09653 .13092 .08686 .11836 Mtetra
.08686 .11836 .09653 .13092 .12011 .12792 .11062 .11531 Mtetra
.348 .638 .962 r
.11062 .11531 .12011 .12792 .14291 .1369 .1338 .1212 Mtetra
0 .316 .806 r
.1338 .1212 .14291 .1369 .16532 .15431 .1563 .13933 Mtetra
.159 .466 .89 r
.1563 .13933 .16532 .15431 .18832 .16681 .1794 .15234 Mtetra
.278 .558 .93 r
.1794 .15234 .18832 .16681 .21175 .17596 .20296 .16185 Mtetra
.357 .616 .949 r
.20296 .16185 .21175 .17596 .23551 .18271 .22687 .16888 Mtetra
.41 .656 .959 r
.22687 .16888 .23551 .18271 .25954 .1877 .25106 .17408 Mtetra
.448 .683 .965 r
.25106 .17408 .25954 .1877 .28381 .19136 .27548 .17789 Mtetra
.476 .703 .968 r
.27548 .17789 .28381 .19136 .30827 .19399 .30012 .18064 Mtetra
.497 .718 .97 r
.30012 .18064 .30827 .19399 .33291 .19581 .32494 .18255 Mtetra
.513 .729 .971 r
.32494 .18255 .33291 .19581 .35772 .19698 .34993 .18378 Mtetra
.526 .738 .972 r
.34993 .18378 .35772 .19698 .38268 .19762 .37509 .18446 Mtetra
.536 .745 .972 r
.37509 .18446 .38268 .19762 .40779 .19781 .40039 .18469 Mtetra
.544 .751 .973 r
.40039 .18469 .40779 .19781 .43304 .19764 .42583 .18454 Mtetra
.551 .756 .973 r
.42583 .18454 .43304 .19764 .45842 .19716 .45141 .18407 Mtetra
.556 .76 .973 r
.45141 .18407 .45842 .19716 .48393 .19641 .47712 .18332 Mtetra
.561 .764 .973 r
.47712 .18332 .48393 .19641 .50957 .19544 .50297 .18235 Mtetra
.565 .767 .973 r
.50297 .18235 .50957 .19544 .53534 .19427 .52894 .18116 Mtetra
.568 .77 .973 r
.52894 .18116 .53534 .19427 .56123 .19292 .55504 .1798 Mtetra
.571 .772 .973 r
.55504 .1798 .56123 .19292 .58724 .19142 .58127 .17828 Mtetra
.574 .774 .974 r
.58127 .17828 .58724 .19142 .61338 .18978 .60762 .17662 Mtetra
.576 .775 .974 r
.60762 .17662 .61338 .18978 .63964 .18802 .63409 .17483 Mtetra
.578 .777 .974 r
.63409 .17483 .63964 .18802 .66601 .18615 .66069 .17294 Mtetra
.579 .778 .974 r
.66069 .17294 .66601 .18615 .69251 .18419 .68741 .17094 Mtetra
.581 .78 .974 r
.68741 .17094 .69251 .18419 .71913 .18213 .71425 .16885 Mtetra
.582 .781 .974 r
.71425 .16885 .71913 .18213 .74587 .17999 .74122 .16667 Mtetra
.583 .782 .974 r
.74122 .16667 .74587 .17999 .77272 .17778 .7683 .16442 Mtetra
.584 .783 .974 r
.7683 .16442 .77272 .17778 .7997 .17549 .79551 .16209 Mtetra
.585 .784 .974 r
.79551 .16209 .7997 .17549 .8268 .17315 .82285 .15971 Mtetra
.586 .784 .974 r
.82285 .15971 .8268 .17315 .85402 .17074 .8503 .15725 Mtetra
.587 .785 .974 r
.8503 .15725 .85402 .17074 .88137 .16827 .87788 .15475 Mtetra
.588 .786 .974 r
.87788 .15475 .88137 .16827 .90883 .16576 .90559 .15219 Mtetra
.617 .786 .963 r
.02946 .11175 .03963 .12441 .0632 .12139 .0532 .10868 Mtetra
.0532 .10868 .0632 .12139 .08686 .11836 .07704 .10559 Mtetra
.07704 .10559 .08686 .11836 .11062 .11531 .10098 .1025 Mtetra
.458 .704 .973 r
.10098 .1025 .11062 .11531 .1338 .1212 .12456 .10525 Mtetra
0 .294 .792 r
.12456 .10525 .1338 .1212 .1563 .13933 .14713 .12411 Mtetra
.14 .452 .883 r
.14713 .12411 .1563 .13933 .1794 .15234 .17034 .13763 Mtetra
.265 .549 .926 r
.17034 .13763 .1794 .15234 .20296 .16185 .19403 .14752 Mtetra
.348 .61 .948 r
.19403 .14752 .20296 .16185 .22687 .16888 .21808 .15482 Mtetra
.404 .651 .959 r
.21808 .15482 .22687 .16888 .25106 .17408 .24243 .16023 Mtetra
.443 .68 .965 r
.24243 .16023 .25106 .17408 .27548 .17789 .26702 .1642 Mtetra
.472 .7 .968 r
.26702 .1642 .27548 .17789 .30012 .18064 .29183 .16706 Mtetra
.494 .716 .97 r
.29183 .16706 .30012 .18064 .32494 .18255 .31684 .16906 Mtetra
.511 .728 .971 r
.31684 .16906 .32494 .18255 .34993 .18378 .34202 .17035 Mtetra
.524 .737 .972 r
.34202 .17035 .34993 .18378 .37509 .18446 .36736 .17108 Mtetra
.534 .744 .972 r
.36736 .17108 .37509 .18446 .40039 .18469 .39285 .17134 Mtetra
.543 .751 .973 r
.39285 .17134 .40039 .18469 .42583 .18454 .4185 .17121 Mtetra
.55 .756 .973 r
.4185 .17121 .42583 .18454 .45141 .18407 .44428 .17075 Mtetra
.555 .76 .973 r
.44428 .17075 .45141 .18407 .47712 .18332 .4702 .17001 Mtetra
.56 .763 .973 r
.4702 .17001 .47712 .18332 .50297 .18235 .49625 .16902 Mtetra
.564 .766 .973 r
.49625 .16902 .50297 .18235 .52894 .18116 .52244 .16783 Mtetra
.568 .769 .973 r
.52244 .16783 .52894 .18116 .55504 .1798 .54875 .16645 Mtetra
.571 .771 .973 r
.54875 .16645 .55504 .1798 .58127 .17828 .57519 .16491 Mtetra
.573 .773 .974 r
.57519 .16491 .58127 .17828 .60762 .17662 .60176 .16322 Mtetra
.575 .775 .974 r
.60176 .16322 .60762 .17662 .63409 .17483 .62846 .16141 Mtetra
.577 .777 .974 r
.62846 .16141 .63409 .17483 .66069 .17294 .65528 .15948 Mtetra
.579 .778 .974 r
.65528 .15948 .66069 .17294 .68741 .17094 .68222 .15745 Mtetra
.581 .779 .974 r
.68222 .15745 .68741 .17094 .71425 .16885 .70929 .15532 Mtetra
.582 .781 .974 r
.70929 .15532 .71425 .16885 .74122 .16667 .73649 .15311 Mtetra
.583 .782 .974 r
.73649 .15311 .74122 .16667 .7683 .16442 .76381 .15082 Mtetra
.584 .783 .974 r
.76381 .15082 .7683 .16442 .79551 .16209 .79125 .14845 Mtetra
.585 .783 .974 r
.79125 .14845 .79551 .16209 .82285 .15971 .81882 .14602 Mtetra
.586 .784 .974 r
.81882 .14602 .82285 .15971 .8503 .15725 .84652 .14353 Mtetra
.587 .785 .974 r
.84652 .14353 .8503 .15725 .87788 .15475 .87434 .14097 Mtetra
.588 .785 .974 r
.87434 .14097 .87788 .15475 .90559 .15219 .90229 .13837 Mtetra
0 g
.89362 0 m
.98022 .38351 L
s
.98022 .38351 m
1 .65325 L
s
1 .65325 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.02946 .11175 m
0 .4272 L
s
0 .4272 m
.91448 .33294 L
s
.91448 .33294 m
.89362 0 L
s
.89362 0 m
.02946 .11175 L
s
.02946 .11175 m
.89362 0 L
s
gsave
.44797 -0.02478 -65.9056 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .4272 m
.29069 .70824 L
s
gsave
.15892 .66839 -66.3192 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{261.563, 185.125},
  ImageMargins->{{30.3125, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.095767,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000560000ia000`40O003h00OogooAgoo003oOom7
Ool00?moodMoo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo002SOol200000goo0000002N
Ool00:9oo`03001oogoo008009moo`00XWoo00D007ooOomoo`0009moo`00XWoo00D007ooOomoo`00
09moo`00XWoo00D007ooOomoo`0009moo`00XGoo0P000Woo0P00Wgoo003oOom7Ool00?moodMoo`00
ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7Ool00?moodMoo`00ogooAgoo003oOom7
Ool00?moodMoo`00ogooAgoo003oOolEOol4000^Ool00?moo`eoo`P000=oo`03001oogoo02aoo`00
ogoo1Goo20002goo00<007ooOol0;7oo003mOol7000COol2000]Ool00?Eoo`P001Yoo`8002eoo`00
kGoo20008Woo0P00;Goo003VOol7000ZOol2000]Ool00=ioo`P0035oo`03001oo`0002aoo`00eWoo
2000>Woo0P00;7oo003>Ool80012Ool2000/Ool00<Moo`L004Yoo`8002aoo`00_goo2000DGoo00<0
07oo0000:goo002gOol8001IOol00`00Ool0000[Ool00;1oo`L0065oo`03001oo`0002]oo`00Z7oo
2000J7oo00<007oo0000:goo002POol8001`Ool00`00Ool0000[Ool009Uoo`L007Qoo`04001oogoo
000ZOol0095oo`P007moo`04001oogoo000ZOol008Uoo`P008Moo`04001oogoo000ZOol0089oo`L0
08moo`04001oogoo000ZOol007Yoo`P009Ioo`05001oogooOol0000YOol0079oo`P009ioo`05001o
ogooOol0000YOol006Yoo`P00:Moo`04001oogoo000YOol006=oo`L00:moo`04001oogoo000YOol0
05]oo`P00;Ioo`05001oogooOol0000XOol005=oo`P00;ioo`05001oogooOol0000XOol004aoo`L0
0<Ioo`05001oogooOol0000XOol004Aoo`P00<eoo`05001oogooOol0000XOol003aoo`P0009?7P0:
Bai?7TlNCai;7S[N>[hjgSJn>]k9Ool01@00Oomoogoo0000:7oo000hOol400005DlnBae?7T/MCci;
7DlNBae??T/MCai;7DlnBae?7T/M>]lf_S[N=[hjg`38Ool00`00Oomoo`02Ool00`00Oomoo`0UOol0
03Qoo`05001?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN00];7TlNCai?7T/N>]hj_S[N=[hjgP4H
0<Ioo`03001oogoo009oo`03001oogoo02Eoo`00>7oo01`004/MCci;7DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlNBae??T/MCai;7BjN=[hjgSJn0CT16<Eoo`03001oogoo009oo`03001oogoo02Eoo`00
>7oo00<007ooBah00dlN00E;7TlNCai?7T/N00=?7P05Bai?7TlNCai;7P03Cah3:Wh01BZN:Wh1604H
0CP0`goo00<007ooOol00Woo00<007ooOol09Goo000hOol07`00Oomood/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/MCahZOBjN:WdZWRYm0CT1604i0<9oo`03001oogoo00=oo`03001o
ogoo02Aoo`00>7oo00D007ooOomood/N00=?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00dlN
00DJ?BYn:WhZWP4i008160034M/=^goo0;moo`03001oogoo00=oo`03001oogoo02Aoo`00=goo00<0
07ooOol00Woo01i?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCahJ71Xm:WdZ
WP4h0CT1617L3K^oOol00`00Oomoo`03Ool00`00Oomoo`0TOol003Moo`03001oogoo00=oo`03Cai;
7TlN009?7P05Bai?7TlNCai;7P03Cah01D/NCai?7TlNBah00TlN11Xm0`4i00@=^a7K3K/=^kioo`03
001oogoo009oo`03001oogoo02Aoo`00=goo00<007ooOol017oo021?7T/MCci;7DlNBae??T/MCai;
7DlnBae?7T/MCci;7DlNBae??T/M6SdJ71Xm6Q`1>@4h0CT=^a7L3K/Ag1hL]7oo00U;7TLNBam77T/N
Aai;7goo00001Goo00<007ooOol08goo000gOol00`00Oomoo`04Ool2Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P03Bai?7TlN00<J?@81F@81>@8Af`063K/N?AhM8SdN71hmXWoo5T/N00<0
07ooOol00goo00<007ooOol08goo000gOol00`00Oomoo`05Ool09D/MCai;7DlnBae?7T/MCci;7DlN
Bae??T/MCai;7DlnBae?7T/MCch5^`WL6Q`J?@4i0ET1>17L4M/Ag0fk8SdN728m7Q`R?BYM09Uoo`0N
Aai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77P00
1Goo00<007ooOol08goo000gOol00`00Oomoo`06Ool2Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?
7T/N00=?7P05Bai?7PFk2M/5^`040ET24M/02a7L7Q`N?AhM8SdN71hm:UdZOBYM:Wd0Qgoo0d/N00E7
7T/NBai;7TLN00=;7P05Aai;7T/NBai77P03Bah00dLNBai;7P0EBah00`00Oomoo`03Ool00`00Oomo
o`0SOol003Moo`03001oogoo00Moo`0YBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlN
Bae??PFk2M`5^`EJ0CT1F@4i5O`Afa7L7Q`R?AhL8SdN72in:UdZORYM;WhbO@1gOol0>TLNBai6oT/O
Aai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/N
Aai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/oAai;7TLNBcm77P001Goo00<007ooOol0
8goo000gOol00`00Oomoo`08Ool2Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P06Bah1
F@5I2M/5^`EJ0P5I00@AfaGL5M`Ag0DR?@05:WdZGBYm:UdZO@02<Yh00c:M<YhbWP1[Ool05dLNBai7
7T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah00d/N00E77T/NBai;7TLN00=;
7P05Aai;7T/NBai77P03Bah00dLNBai;7P0CBah00`00Oomoo`04Ool00`00Oomoo`0ROol003Moo`03
001oogoo00Uoo`0CBae?7T/MCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBad00P5I01d9g05I
1GX1>@5I4M/Eo17K5O`N728m8Q`R?AhL;WhZGBYn:UdbWS9m<Yh^OC:N<Wdf_SJM>[hfWSJn05Moo`1?
Bai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKn
Bam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLN
Bai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/oAai;7TLN00001Woo00<007ooOol08Woo000gOol0
0`00Oomoo`09Ool3Cah01D/NCai?7TlNBah00dlN00E;7TlNCai?7T/N00=?7P09Bah1F@5I0ET5F@EJ
1ETEg17K00<Eg0@R?@05:UdZOBYm;WdZG@03<Yh00c:M<Yhf_P05=[h3>[h00c[N>[hj_P0kOol024LN
A_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00A6oTLNAai;7P=77P05Bai77TLNAai;7P03
Aah05T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;
7TLN00=;7P05Aai;7T/NBai77P03Bah00dLNBai;7P0EBah00`00Oomoo`04Ool00`00Oomoo`0ROol0
03Ioo`03001oogoo00]oo`0DCci;7DlNBae??T/MCai;7DlnBae?7T/MCci;7DlNBae??T/MCai;7@@1
F@0P1GX5FAWl4M/Eo17K9SdR?2Hm8Q`R?BYM;WhZGBin:UdbWS:M<YhbOC:N=Yhf_SJM>[hfWS[N>[dj
gSZn>]hj_@8jgP04?]hj_SkN>]h2?]h02d;n?]i2oSkN@_hngT;n?]i2oSkN@_h03Goo08177d;nA_i2
oTLO@_i6oT;nAam2oTLN@_i77d;nAai2oTLOA_i77T;nAam6oTLNA_i77dKnAai6oT/OA_i77TKnBam6
oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam7
7T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;?dLNBai7
7T/oAah004LN1Goo00<007ooOol08Woo000fOol00`00Oomoo`0<Ool3Cah01D/NCai?7TlNBah00dlN
00E;7TlNCai?7T/N00=?7P06Bah0e`5I1GX5F@EJ0QGl0aGL128m00H^OBYM:WdZOBim<Yd3<Yh00c:M
<Yhf_P04=[h01S[N>[hj_SZn>]hj_PdngP05@]i2oT;N@_i2gP08@_h034Kn@_i2oT;nA_i2oTKn@_i6
oT;nA_i2oPQ6oP0FAai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah0
1DKnAai77TLNA_h00dLN00A6oTLNAai;7P=77P05Bai77TLNAai;7P03Aah05T/NAai;7TLNBai77T/N
Aai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P03Aai;7T/N01];
7P03001;7Woo00Eoo`03001oogoo025oo`00=Woo00<007ooOol03Goo051??T/MCai;7DlnBae?7T/M
Cci;7DlNBae??T/MCai;7DlNBae?7T/M0?L1F@Ej1GT5NQGK6O`EfaWl8S`V?B8l9SdR?2in:Ud^ORYM
;WhbOC:N<YdbWS9m>[hfWSZn=Ydj_SJN>]hj_CkN>[hjgSZm?]hjgSkN>[hngS[N@_hngT;n?]i2oSkN
@_hngT;n?]i2oSkN@_i2gT;n@]i2oT;N0T;n08A6oT;nA_m2oTKn@_i77d;nA_i2oTLO@_i6oT;nAam2
oTLN@_i77dKnAai2oTLOA_i77T;nAam6oTLNA_i77dKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam7
7T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai7
7T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;?dLNBai77P00Aah6Ool00`00
Oomoo`0QOol003Ioo`03001oogoo00ioo`=?7P05Bai?7TlNCai;7P03Cah024/NCai;7TlNBai?7T/N
Cah20=L31GX35O`00aGL5O`V?@038Sd00bim;WhZO@02;Wd00c:N<YdbWP02<Yh00c:M=[hf_P03=[h0
0cZn>]hj_P02>[h00c[N>[hngP0;?]h01T;n@]i2oT;N@_i2gPQ2oP0<A_i2oT;n@_i6oT;nA_i2oTKn
@_i6oT;n24Kn00i77TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P03
A_i77TLN00Q77P05Bai77TLNAai;7P03Aah04T/NAai77TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77P=;7P05Aai;7T/NBai77P03Bah01DLNBai;7T/NAah00d/N00=77T/NBah06D/N00<004/NOol0
1Goo00<007ooOol08Goo000fOol00`00Oomoo`0?Ool05DlnBae?7T/MCci;7DlNBae??T/MCai;7DlN
Bae?7T/MCai;7DlN0=L0m`021GX06@Ei6Q`EfaWl5M/VGB8m9UdR?2IM:Wd^ORYM;WhZOCJN<YdfWS:M
=YhfWCZn=Yhj_SJM008j_P06>]hj_CkN>[hjgSZn0ckN09Xj_SkN?]i2oSkN@_hngT;n?]i2oSkN@_hn
gT;n?]i2oT;NA_i2gT;n@]i6oT;nA_i2oTKo@_i6oT;nAam2oTKn@_i77d;nAai2oTLO@_i77T;nAam6
oTLN@_i77dKnAai6oTLOA_i77TKnAam6oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai7
7T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBcm77P00Aai;?`Eoo`03001oogoo025oo`00
=Woo00<007ooOol03goo00E;7TlNCai?7T/N00=?7P0=Bai?7TlNCai;7TlNBai?7T/NCai;7P3g0=L0
0`VJ00D5NQWl6O`Eo1GL008V?@079UdR?BHm;Wd^ORYm;Wd00S:N00@bWC:N<YhbWP<f_P05>[hf_SZn
>[hjgP03>[h00c[N?]hngP05?]h014;N?]hngSkN0T;N00A2oT;N@_i2gPY2oP06A_i2oT;n@_i6oT;n
0dKn00=2oTKnA_h024Kn00i77TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn
00Y77P05Bai77TLNAai;7P03Aah05T/NAai77TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/N
Aai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;7T/NBai77P0MBah00`00Bai;7P06Ool00`00Oomo
o`0POol003Ioo`03001oogoo011oo`0JBae??T/MCai;7DlnBae?7T/MCci;7DlNBadnockN?_hngSko
?]h0m`3G2I/5NPVK1GXJ708Io00M8S`VGB8m9UdR?2in;Wd^ORYm;WhbWCJN<YdfWS:M>[hfWCZn=[hj
_SJM?]hj_SkN>[dngSZn?]hjgP03?]h0V3[N@_hngT;n?]i2oSkN@_hngT;n?]i2oSkN@_i2gT;n@]i6
oT;N@_i2gTKo@_i6oT;nA_m2oTKn@_i77d;nA_i2oTLO@_i77T;nAam2oTLN@_i77dKnAai2oTLOA_i7
7TKnAam6oTLNA_i77dKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;
7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;
7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;
7dLNBai77T/OAai;7TLNBcm77T/NAai;?`00Bah6Ool00`00Oomoo`0POol003Ioo`03001oogoo015o
o`05Bai?7TlNCai;7P03Cah014/NCai?7TlN1SkN00<0n03g0=L010VJ0aWl0bHm00DVGB8m;Wd^OBin
008^O@06<YhfWS:N=YhbWSZn0cJn00Pj_SJn>]hj_S[N>[hjgSZn23kN00A2gSkN?]hngP92gP=2oP03
@]i2oT;n00Q2oP06A_i2oT;n@_i6oT;n0dKn00=2oTKnA_h024Kn00Y77TKnA_i6oTLNA_i77TKnAai6
oP=77P05A_i77TLNAai6oP03Aah00dKnAai77P08Aah01D/NAai77TLNBah00dLN019;7TLNAai77T/N
Aai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00=;
7P03Aai;7T/N01Y;7P03001;7T/N00Eoo`03001oogoo021oo`00=Woo00<007ooOol04Woo019;7Dln
Bae?7T/MCci;7DlNBae??T/MCahngSko?]hnoSkN?_l20?L09@VJ3K/5NPVK6O`N7AWl9UdV?BIM9SdV
GBYm;Wh^OBin:Wdf_S:M=YhbWCJn<Ydj_SJm>[hf_SZn=[dngSZn?]hj_CkN>[hngS[N00@ngP0B@_hn
gT;n?]i2oSkN@_hngT;n@]i2oSkNA_i2gT;n@]i6oT;N0T;n0896od;nA_i2oTKo@_i6oT;nAam2oTKn
@_i77d;nAai2oTLO@_i77T;nAam6oTLN@_i77dKnAai6oTLOA_i77TKnBam6oTLNA_i;7dKnAai6oT/O
A_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/N
A_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/O
Aai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/oAai;7P00Bcm77PEo
o`03001oogoo021oo`00=Woo00<007ooOol04goo00E;7TlNCai?7T/N00=?7P0>Bai?7TlNCahZWRjN
:Yh^WRZN0AP0n03g2IX=V`89VP056O`J71Wl9UdV?@039Ud3;Wd01bin;WdfWS:N=YhbWSJN008j_P0:
=[hj_SZn>[hf_S[N>[hngSZn>]h9?]h01T;N?]hngSkN@_i2gP=2oP03@]i2oT;n00A2oP05A_i2oT;n
@_i6oP02@_h2A_h00d;nA_i6oP08A_h01DLNA_i6oTKnAah00dKn00I77TKnAai6oTLNA_h3Aah01DKn
Aai77TLNA_h00dLN00A6oTLNAai;7P=77P05Bai77TLNAai;7P03Aah01D/NAai77TLNBah00dLN00i;
7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;7T/NBai77P03
Bah00dLNBai;7P0HBah00`00Bai;7P05Ool00`00Oomoo`0POol003Eoo`03001oogoo01Eoo`0YBae?
?T/MCai;7DlnBae?7T/MCci;7DlN:Wd^WRYn;YhZO@4H0?L=^`VJ3K/9VQhL6O`N7AWl:UdV?BIM9Sdb
WRim<Yh^OC:N<Ydf_S:M=YhbW@02=[h02SZn=[dj_SJn>[hj_CkN>[hngSZm23kN09A2oSkN@_hngT;n
@]i2oSkN@_i2gT;n@]i6oT;N@_i2gTKn@_i6oT;nA_m2oTKn@_i77d;nA_i2oTLO@_i77T;nAam2oTLN
@_i77d;nAai6oTLOA_i77TKnAam6oTLNA_i77dKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/O
A_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/N
A_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/O
Aai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;?`00Bai77PIoo`03001oogoo01mo
o`00=Goo00<007ooOol05Goo00=?7T/NCah00TlN00E;7TlNCai?7T/N00=?7P045Q`^WRZN;Yh20AP0
3P3h3K/9VPfK2I/N7AWl6Q`Io2YM9UdZGBIM;Wh3;Wd01Rin=YhfWSJN=[hfWP<j_P03=[hj_SZn008j
_P04>]hj_SkN>[h6?]h01T;n?]i2gSkN@_hngP=2oP03@]i2oT;n00Q2oP06A_i2oTKn@_i6oT;n0dKn
00A2oTKnA_i77P=6oP05Aai6oTKnA_i77P03A_h02TLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLN
Aai77TKn00=77P04A_i77TLNBah3Aah01D/NAai77TLNBah00dLN01I;7TLNBai77T/NAai;7TLNBai7
7T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah01DLNBai;7T/NAah074/N
00<004/NBah01Woo00<007ooOol07goo000eOol00`00Oomoo`0FOol04DlNBae??T/MCai;7DlnBae?
7T/MCci;7DlN5Q`J?BYn;Yh00P4H02<=^a6k2IX=^ahL7QdMo1hM9UdZGBHm:UdVGC:N;WdbWRim=[hb
WCJn<Ydf_S:M>]hf_SZn=[djgSJn?]hj_CkN>[hngSZm00HngP0?@_hngT;n?]i2oSkN@_i2gT;n?]i2
oT;N@_i2gTKn0092oP23@]i6od;nA_i2oTKo@_i6oT;nAam2oTLN@_i77d;nAai2oTLO@_i77T;nAam6
oTLNA_i77dKnAai6oTLOA_i77TKnAam6oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai7
7T/OAai;7TLNBam77T/NAai;7dLNBai77T/oAai;7P00Bcm77P06Ool00`00Oomoo`0OOol003Eoo`03
001oogoo01Moo`03Cai;7TlN009?7P05Bai?7TlNCai;7P03Cah011HL5QdF7@4i0P4H00H=^a6k2IX=
VahL7Qd27Q`02RIM:UdVGBYM9UdbWRim<Wh^OCJn0cJN00<f_SJN>[h01CZn00HngSZn?]hjgSkN>[h6
?]h01T;n?]i2gSkN@_i2gP=2oP03@]i2oT;n00I2oP08A_i2oTKn@_i6oT;nA_i2oP=6oP04@_i6oTKn
Aah3A_h01DLNA_i6oTKnAah00dKn00I77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00=6oTLN
Aah014LN00E;7TLNAai77T/N00=77P0FBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77T/NAah3Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00=;7P03Aai;7T/N01Q;7P03001;
7T/N00Ioo`03001oogoo01moo`00=Goo00<007ooOol05goo01a;7DlNBae??T/MCai;7DlnBae?7T/M
Cci;7DlN5Q`J?AHL0CT1616k3K/A^`fj7QdN71hM7O`N7@8ZG@0G9SdZGBim<Yh^OC:N;Wdf_S:M=[hf
WCJn<YdjgSJn>[hf_C[N>[hngSZm?]hj_P02?]h0VD;n?]hngSkN@_hngT;n?]i2oSkN@_hngT;n@]i2
oSkN@_i2gTKn@]i6oT;nA_i2gTLN@_i6oT;nAai2oTLN@_i77d;nAai2oTLOA_i77T;nAam6oTLNA_i7
7dKnAai6oTLOA_i77TKnBam6oTLNA_i;7dKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;
7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;
7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;
7TLNBam77T/NAai;?dLNBai77T/oAai;7TLNBcl004/NAai;?`06Ool00`00Oomoo`0NOol003Eoo`03
001oogoo01Qoo`9?7P05Bai?7TlNCai;7P03Cah04D/NCai?7P6J5Q`F7@4i1ET1617K3K/A^`fk8QdN
71hM7Q`01BYM00/^OC:N;WdbORim=[hfWSJn=Yhf_SJN00Dj_P05>]hngSZn?]hjgP06?]h2@]h01T;n
?]i2gT;N@_i2gP=2oP03@]i2oT;n00I2oP08A_i2oTKn@_i6oT;nA_i2oP=6oP04@_i6oTKnAah3A_h0
1DLNA_i6oTKnAah00dKn00I77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00A6oTLNAai;7P=7
7P05Bai77TLNAai;7P03Aah05T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;
7TLN0d/N00E77T/NBai;7TLN00=;7P03Aai;7T/N01i;7P04001;7T/NBah6Ool00`00Oomoo`0NOol0
03Eoo`03001oogoo01Uoo`0DBae?7T/MCci;7DlNBae??T/MCai;7DlnBad1VP5j6Sd1>@EI0APEg08A
^`067Q`R?AhL8SdN72Yn0RYM00hVGBYn;WdbWRim<Yh^OCJn<Ydf_SJM=[hf_C[N0SZn00Lf_C[N>[hn
gSZn?]hj_P02?]h044;n?]i2gSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oSkN0T;n08E6oT;NA_i2oTKn
@_i77T;nA_i2oTLN@_i77T;nAam2oTLN@_i77dKnAai2oTLOA_i77TKnAam6oTLNA_i77dKnAai6oT/O
A_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/N
A_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/O
Aai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBcm77T/N
Aai;?dLNBah004/oAai;7P06Ool00`00Oomoo`0NOol003Eoo`03001oogoo01Yoo`9?7P05Bai?7TlN
Cai;7P03Cah01D/NCai?7P6J0GX00P4i00<5F@4i4M/00Q7K00DN728M7Q`R?AhL00@ZG@0;<YhbWC:N
<WdbWS:M=[hfWSJn=Yhf_P05>[h3?]h00c[N?]hngP06?]h01T;n@]i2oSkN@_i2gPi2oP04A_i2oTKn
@_h:A_h04TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP03
Aah014KnAai77T/N0dLN00E;7TLNAai77T/N00=77P0FBai77T/NAai;7TLNBai77T/NAai;7TLNBai7
7T/NAai;7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00d/N00=77T/NBah074/N00<004/NBah00T/N
1Goo00<007ooOol07Woo000eOol00`00Oomoo`0KOol0cD/MCai;7DlnBae?7T/MCci;7DlNBae??P3F
0IX1NPEI0CT5F@4i5M`A^aGL8Q`R?AhL8SdZGBin:Ud^OBYM<Yh^OC:N;WdbWSJM=[hfWCZn=Ydf_SZm
>]hj_S[N>[dngSZn?]hj_SkN>[i2gSkN@_hngT;N?]i2oSkN@_hngT;n@]i2oT;N@_i2gT;n@]i6oT;n
A_i2gTKn@_i6oT;nAai2oTKn@_i77d;nAai2oTLO@_i77T;nAam6oTLN@_i77dKnAai6oTLOA_i77TKn
Bam6oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKn
Bai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLN
Bam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;?dLN
Bai77T/oAai;7TLNBcl004/NAai;?dLN00Eoo`03001oogoo01ioo`00=Goo00<007ooOol077oo0TlN
00E;7TlNCai?7T/N00=?7P09Bai?7P3g0IX5F@EJ0CT5FAGK008Af`058SdR728m7Q`R?@03:Ud032Ym
:UdbWS:M<YhbOC:N=Yhf_SJN=[hfWPHj_P`ngP04@_i2gT;n?]h>@_h01TKn@_i6oT;nA_i2oPY6oP0B
Aai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00I77P05Bai7
7TLNAai;7P03Aah05T/NAai77TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N
00E77T/NBai;7TLN00=;7P03Aai;7T/N01i;7P03001;7T/N009;7PIoo`03001oogoo01eoo`00=7oo
00<007ooOol07Woo03=;7DlNBae??T/MCai;7DlnBae?7T/MCch0eP6J1ET5NP4i1ETEfaGl4K/R?B8L
9SdR72im:Ud^ORYM;WdbOC:N<WdbWS9m>[hfWCJn=Ydj_SJM>]hj_C[N>[hjgSZn?]hj_SkN>[h00SkN
09M2gSkN@_hngT;N?]i2oSkN@_hngT;n@]i2oT;N@_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nAai2oTKn
@_i77d;nAai2oTLO@_i77T;nAam6oTLN@_i77dKnAai6oTLOA_i77TKnBam6oTLNA_i;7dKnBai6oT/O
A_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/N
A_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/O
Aai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;?dLNBai77T/oAai;7TLN00177T/N
Aai;?`05Ool00`00Oomoo`0MOol003Aoo`03001oogoo01ioo`04001?7TlNBah3Cah03T/NCai?7TlN
Bah0e`3g1GX5F@EJ1ETEg1GK5M`28Sd0128L8SdR?Bim0bYM00HZOC:M<YhbWC:N<Yd3=[h00cJN=[hj
_P05>[h7?]h02T;N?]hngSkN@_i2gT;n@]i2oT;N2T;n00Q6oT;n@_i2oTKn@_i6oT;n24Kn01977TKn
A_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00A6oTLNAai;
7P=77P05Bai77TLNAai;7P03Aah03T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;
7T/NAah00d/N00E77T/NBai;7TLN00=;7P03Aai;7T/N01e;7P03001;7T/N009;7PEoo`03001oogoo
01eoo`00=7oo00<007ooOol07goo02Q??T/MCai;7DlnBae?7T/MCci;7DlNBad0m`3F1GX5F@Ej1ETE
g1GK5O`R?28m8Q`V?BYM;WhZGBin:UdbWS9m<YhbOC:N=Ydj_SJM>[hfW@8j_P06?]hj_CkN>[hngSZn
0ckN09Pj_T;n?]i2gSkN@_hngT;n?]i2oSkN@_hngT;n@]i2oT;N@_i2gTKn@]i6oT;nA_i2gTKn@_i6
oT;nAai2oTKn@_i77d;nAai2oTLOA_i77T;nAam6oTLN@_i77dKnAai6oTLOA_i77TKnBam6oTLNA_i;
7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;
7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;
7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;?dLNBai77T/oAah0
04LNBcm77T/N1Goo00<007ooOol07Goo000JOol3000GOol00`00Oomoo`0POol3Cah01D/NCai?7SkN
>]h00ckN0P3G00@9NPVJ1ET5FP8Io0065M/V?BHm9SdR?BHm0Rim00LZGBim;WdfWS:M<YhbW@02=Yh3
=[h013JN>[hj_S[N0cZn23kN00Y2gSkN?]hngT;n@]i2oT;N@_i2gPI2oP0<A_i2oT;n@_i6oT;nA_i2
oTKn@_i6oT;n24Kn01977TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah00dKnAai7
7P08Aah01D/NAai77TLNBah00dLN019;7TLNAai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3
Bah01DLNBai;7T/NAah00d/N00E77T/NBai;7TLN00=;7P03Aai;7T/N01];7P03001;7T/N009;7PIo
o`03001oogoo01aoo`006goo00<007ooOol05Woo00<007ooOol08Goo031??T/MCai;7Dln>]hngS[N
?_ljgSkN0=L0m`Uj2IX5F@Ej6M/Io1GK9SdR?2Hm8S`V?Bim;WhZGBin<YdfWS9m=YhbWCJN=Ydj_SJM
>[hfWCkN>[hngSZm?]hj_SkN>[h4?]h0UD;n?]i2oSkN@_hngT;n?]i2oSkN@_i2gTKn@]i2oT;NA_i2
oTKn@_i6oT;nA_i2oTLN@_i6oT;nAai2oTLN@_i77d;nAai2oTLOA_i77T;nAam6oTLNA_i77dKnAai6
oTLOA_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6
oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai7
7T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBcm7
7T/NAai;?dLNBai77P00Aai;7TLNBcl01Woo00<007ooOol077oo000GOol300000goo001oo`0GOol0
0`00Oomoo`0QOol01T/NCai?7TlNBai?7P8ngP04>]hngSkN0AP20=L00`Uj2IX9NP046O`39Sd00b8m
;Wd^O@03;Wd02c:M=YhbWC:N<Ydj_SJn>[hf_SZn=[h00SZn00<ngSZn>[h02CkN00Q2gSkN?]i2gT;n
@]i2oT;N24;n00I6oT;n@_i2oTKn@_h3A_h00d;nA_i6oP08A_h04TLNA_i6oTKnAai6oTLNA_i77TKn
Aai6oTLNA_i77TKnAai6oP=77P04A_i77TLNBah3Aah01D/NAai77TLNBah00dLN01I;7TLNBai77T/N
Aai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah01DLNBai;
7T/NAah07d/N00<004/NBah00T/N1Woo00<007ooOol077oo000FOol01000Oomoogoo0P0067oo00<0
07ooOol08Woo02e;7DlnBae?7T/MCchRGCkN>]hnoc[N0AP0ea6k3IX9VPEj6O`IfaWl9S`ZGBHl9UdV
?2in;Wd^ORiM;WhbWCJN<YdfWS:M>[hfWCZn=Ydj_SZm?]hj_SkN>[d00ckN00<n_SkN?]h00SkN09A2
oSkN@_hngT;n@]i2oSkN@_i2gT;n@]i6oT;N@_i2gTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLN@_i7
7T;nAai2oTLNA_i77dKnAai6oTLOA_i77TKnBam6oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;
7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;
7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;
7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/oAai;7TLNBcm77P00Aai;?dLNBai77PEoo`03
001oogoo01aoo`005Woo00<007ooOol00Woo00<007ooOol05Woo00<007ooOol08goo00Q;7TlNCai?
7T/NCahRGB9N0R9M0P4H00H0e`fK3IX9VQWl7O`26O`39Sd00bIM9Sd^O@03;Wd3=Yh00c:M=YhfWP08
>[h00ckN>[hngP05?]h01T;N?]i2gSkN@]hngP=2oP03@]i2oT;n00I2oP08A_i2oTKn@_i6oT;nA_i2
oP=6oP03@_i6oTKn00Q6oP0:Aai6oTKnA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00A6
oTLNAai;7P=77P05Bai77TLNAai;7P03Aah05T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;7T/NBai77P0MBah00`00Bai;7P03Bah6
Ool00`00Oomoo`0KOol001Ioo`03001oogoo009oo`03001oogoo01Ioo`03001oogoo02Aoo`0]Bae?
?T/MCai;7Dln8UdRGR9M8Wh0m`4H3IXA^`fJ3K/Io1hL6O`VGBHl:UdV?2IM;WdbWRim<Wh^OCJN<Ydf
WS:M=Yhf_CZn=Ydj_SJm>[hj_CkN>[hngSZm00<ngP0C?[hngSkN@_hngT;n?]i2oSkN@_i2gT;n?]i2
oT;N@_i2gTKn@]h00T;n0896oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77TKnAam6
oTLNA_i77dKnAai6oT/OA_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai7
7T/OAai;7TLNBam77T/NAai;?dLNBai77P00Aai;7TLNBcm77PIoo`03001oogoo01]oo`005Woo00@0
07ooOomoo`8001Qoo`03001oogoo02Eoo`0:Bai?7TlNCai;7TlN8UdRGR9M1CT20AP01@fJ3I/=VPfK
6O`00Qgl00DZGBHm9SdV?BIM00<^O@03<Wh^OCJN008fWP03=YdfWSZn00@j_P04?]hj_SkN>[h7?]h0
0d;N@_hngP02@]h00d;n@]i2oP02@_h00d;N@_i2oP06@_h014Kn@_i6oT;n0dKn00=2oTKnA_h024Kn
00i77TKnA_i6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3
Aah06T/NAai77TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah0
1DLNBai;7T/NAah00d/N00=77T/NBah08D/N00<004/NBah014/N1Goo00<007ooOol06goo000GOol3
00000goo0000000GOol00`00Oomoo`0UOol0;4lNBae??T/MCai;7Dln0IXRGR9M1ET0maFk4KXA^`fJ
8Q`Mo1hL9SdZGBHl:UdV?C9n;WdbWRim<WhbWCJn=Ydf_S:M=[hj_CZn=[dj_SZm?]hj_CkN>[h2?]h0
44;N?]hngSkN@]hngT;n?]i2oSkN@_i2gT;n@]i2oT;N0T;n08M6oT;NA_i2oTKn@_i6oT;nA_i2oTKn
@_i6oT;nAai2oTKn@_i77TKnAai2oTLNA_i77TKnAam6oTLNA_i;7dKnAai6oT/OA_i77TKnBam6oTLN
A_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/O
Aai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/N
Aai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBcm77T/NAai;?dLN00177T/o
Aai;7TLNBcl01Goo00<007ooOol06goo000cOol00`00Oomoo`0WOol00dlNBai?7P02Cah03T/NCah5
VPFK1CP5>@4H5K/A^`fK3IXR71hL8Q`5:Ud01S:N<WdbOC9m<YhfW@<fWP03=Ydj_SZn00<j_P8ngP03
>[hngSkN00HngP92gP06@_hngT;N@]i2oT;N0d;n00=2gT;n@_h014;n00I6oT;nA_i2oTKn@_h3A_h0
0d;nA_i6oP08A_h03TLNA_i6oTKnAai6oTLNA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00TLN
00E;7TLNAai77T/N00=77P0JBai77TLNAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/N
Aai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah00dLNBai;7P0OBah00`00Bai;7P04Bah5Ool00`00
Oomoo`0KOol003=oo`03001oogoo02Qoo`0CCai;7DlnBae?7T/M0AP1VPFK1CP5FA6k5K/A^QGK7Q`R
71gl8Qd00RYM014V?2YM;WdbWRim<Yh^OC:N=Ydj_SJM=[hfWCZn>[dj_SJm008j_P2M?]hj_CkN>[i2
gSkN@]hngT;N?]i2oSkN@_hngT;n?]i2oT;N@_i2gT;n@]i6oT;nA_i2gTKn@_i6oT;nA_i2oTKn@_i7
7T;nA_i2oTLN@_i77T;nAai6oTLN@_i77TKnAai6oTLOA_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;
7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;
7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;
7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBcm77T/NAai;?dLNBai77T/oAai;7TLN00177T/NAai;
?dLNBah01Woo00<007ooOol06Woo000cOol00`00Oomoo`0YOol00dlNBai?7P02Cah024/N0?L5VPUj
1CP5>AGK5K/24K/28Q`00ahL:UdZG@03:Ud00c9m<YhbO@02<Wd01CJn=YdfWSJN=[h01CZn0ckN00<j
_SkN?]h01SkN0T;N00=2oSkN@]h00T;n00=2gT;n@_h014;n00Q6oT;n@_i2oTKn@_i6oT;n24Kn00E7
7TKnA_i6oTLN00=6oP0:Aai6oTKnA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00A6oTLN
Aai;7P=77P05Bai77TLNAai;7P03Aah03T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLN
Bai;7T/NAah00d/N00E77T/NBai;7TLN02=;7P03001;7T/N00A;7PIoo`03001oogoo01Yoo`00<goo
00<007ooOol0:Woo02Y;7TKnBai6oT/N1AL1606J2GX9FAWL5M/Ig16j9SdR72Hm8Q`^OBYM;UdZGBim
<WdbWS9m=YhbOCJn=Ydj_SJM=[hj_CkN>[dj_SZm?]hj_SkN>[d2?]h0Ud;N?]i2gSkN@]hngT;n?]i2
oSkN@_i2gT;n@]i2oT;N@_i2gTKn@_i6oT;NA_i2oTKn@_i77T;nA_i2oTLN@_i77T;nAai6oTLN@_i7
7TKnAai2oTLOA_i77TKnAam6oTLNA_i;7dKnAai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;
7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;
7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;
7TLNBam77T/NAai;?dLNBai77T/oAai;7TLNBcm77T/N001;?dLNBai77T/o00Ioo`03001oogoo01Yo
o`00<goo00<007ooOol0:Woo00E6oT/NA_i77TKn008560080?L9F@Uj2ETIfaGK6M/Ef`8R70038SdR
72iM00<ZG@0:<YdbOC:N<WdbWC9m>[hfWCJn=Yh5>[h7?]h014;N?]hngSkN14;N00=2oT;N@]h00T;n
00A2gT;n@_i6oP=2oP08A_i2oTKn@_i6oT;nA_i2oPQ6oP0BAai6oTKnA_i77TKnAai6oTLNA_i77TKn
Aai6oTLNA_i77TKn0dLN00E6oTLNAai77TKn00=77P04A_i77TLNBah3Aah01D/NAai77TLNBah00dLN
00i;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;7TLN00=;7P05Aai;7T/NBai7
7P0RBah00`00Bai;7P04Bah5Ool00`00Oomoo`0JOol003=oo`03001oogoo02]oo`33A_i;7TKnBai6
oPDH1AL160UI2GX9FAgl5M/Ig1Fk9SdR72Hm:Ud^ORYM;WdZGCJN<WdbWS9m=YhfWCZn=Ydj_SJM?]hj
_CkN>[dngSZm?]hj_SkN>[e2oSkN@]hngT;n?]i2oSkN@_hngT;n?]i6oT;N@_i2gTKn@]i6oT;NA_i2
oTKn@]i77T;nA_i2oTLN@_i77T;nAai2oTLN@_i77TKnAai2oTLNA_i77TKnAam6oTLNA_i77dKnAai6
oT/OA_i77TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam7
7T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai7
7T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/oAai;7TLNBcm7
7T/NAai;?`00Bai77T/oAai;7TLN00Ioo`03001oogoo01Uoo`00<goo00<007ooOol0;7oo00@RGD/N
A_i77P8560050?LAVPUI2GXIn`027O`01AWK9S`V?BHl9Sd00biM00H^OBiM=YhbWCJN<Yd2=Yh00cZn
=Ydf_P06>[h7?]h01D;N?]hngSkN@_h00d;N00=2oT;N@_h00T;n00A2gT;n@_i6oP=2oP03A_i2oTKn
0096oP03@_i6oTKn00Q6oP0BAai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oTLNA_i77TKn0dLN00A6
oTLNAai;7P=77P05Bai77TLNAai;7P03Aah04T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN
Bai77P=;7P05Aai;7T/NBai77P03Bah01DLNBai;7T/NAah00d/N00=77T/NBah07T/N00<004/NBah0
14/N1Woo00<007ooOol06Goo000cOol00`00Oomoo`0]Ool0129M9WhRG@Dh0PDH0;H0ma6K3GX9NQWK
7O`Ifagl9Q`V?BHl9Sd^GBin:Ud^OC9m=YhbOCJN<Wdj_SJM>[hfWCZn>[dngSZm?]hj_CkN>[dngSjn
?]hj_D;n?]i2gSkN@_hngT;n?]i2oT;N@_hngTKn@]i2oT;NA_i2gTKn@]i6oT;nA_i2oTLN@_i6oT;n
Aai2oTLN@_i77T;nAai2oTLNA_i77TKnAai6oTLNA_i;7TKnAai6oT/OA_i77TKnBam6oT/NA_i;7dKn
Bai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKn
Bam77T/NA_i;7dLNBai6oT/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLN
Bai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/oAai;7TLNBcm77T/NAai;?dLNBah004/o0T/N00A7
7T/oBai;7PEoo`03001oogoo01Uoo`00<goo00<007ooOol0;Woo00<RGBIn8Ud00`DH0a6J00<Mo1Wk
7O`00Qgl00<V?2Hm9S`01Bim00DbWCJN<YdfWS:M00<j_P07=[dj_SZn?]hj_Sjn>[h01SkN00A2gSkN
@]hngP92gP04@_i2gT;n@]h8@_h01TKn@_i2oT;nA_i2oP=6oP03@_i6oTKn00Q6oP0>Aai6oTKnA_i7
7TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP02Aah01D/NAai77TLNBah00dLN01I;7TLN
Bai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah0
1DLNBai;7T/NAah08T/N00<004/NBah01D/N1Goo00<007ooOol06Goo000cOol00`00Oomoo`0^Ool0
1@FJ8UdVOPeI4GT00PDH028=NQ6K3GXR71WK7O`IfbYM9S`V?BHl<Wd^GC9n;UdbOC:M=YhbWCJN=Ydj
_SJM>[hfWCkN>[dngSZm?]hj_CkN?[e2gP<ngP2A@_hngT;N?]i2oT;N@_hngT;n@]i2oT;NA_i2gT;n
@]i6oT;nA_i2gTKn@_i6oT;nAai2oTKn@_i77T;nAai2oTLN@_i77TKnAai6oTLNA_i77TKnAai6oT/N
A_i77TKnBam6oTLNA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/N
A_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai77T/O
Aai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBcm77T/N
Aai;?dLNBai77T/o001;7TLNBcl00T/N00=77T/oOol01Goo00<007ooOol067oo000bOol00`00Oomo
o`0`Ool21GX02RIn3ET=F@DH6K/E^Q6J8O`R727l0Qgl00<ZGBXl:Sd01Bim00DfWSJM=YhfWCJN00Dj
_P05?[hj_SkN>[hn_P07?]h3@]h01ckN@]i2gT;n@]i2oT;N00I2oP08A_i2oTKn@_i6oT;nA_i2oP=6
oP03@_i6oTKn00A6oP0>Aai6oTKnA_i77TKnAai6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP06
Aah01D/NAai77TLNBah00dLN00i;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLN0d/N00E77T/NBai;
7TLN00=;7P05Aai;7T/NBai77P03Bah00dLNBai;7P0NBah50007Bah6Ool00`00Oomoo`0HOol0039o
o`03001oogoo031oo`0U6GP5VPEj4GT=FA5i3ETI^aFj6K/Mo28L7O/R72Hl:UdV?2YM;WdbORim<Wh^
OCJN<YdfWS:M>[hfWCZn>[dj_SJM?]hj_SkN>[d00ckN088n_D;N?]i2oSkN@_hngT;n?]i2oT;N@_hn
gT;n@]i6oT;NA_i2gTKn@]i6oT;nA_i2oTKn@_i6oT;nAai2oTKn@_i77TKnAai2oTLNA_i77TKnAai6
oTLNA_i;7TKnAai6oT/NA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6
oT/OA_i;7TKnBam6oT/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam7
7T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/OAai;7TLNBam77T/NAai;7`X00006
Aai;?dLNBah004/o0T/N00A77T/oBai;7PIoo`03001oogoo01Qoo`00<Woo00<007ooOol0<Goo00<M
N0Ej1GX010eI00LI^aFj6K/Qo28L8O`^G@02:Ud00bXl<WdbO@04<Wd013JN=YdfWSJM1SZn00@ngSjn
?]hj_PHngP03@]hngT;N0092gP05?]i2oT;N@_i2gP08@_h014Kn@_i6oT;n0dKn00=2oTKnA_h024Kn
00Y77TKnA_i6oTLNA_i77TKnAai6oP=77P05A_i77TLNAai6oP03Aah014KnAai77T/N0dLN00E;7TLN
Aai77T/N00=77P0>Bai77T/NAai;7TLNBai77T/NAai;7TLNBai77P=;7P05Aai;7T/NBai77P03Bah0
1DLNBai;7T/NAah03d/N2@003d/N00<004/NBah01D/N1Goo00<007ooOol067oo000bOol00`00Oomo
o`0aOol00aei6GP5VP026IX0T@eI4GTMfaVk5KXV?BHL8Q`MnbiM:U`^GBXl<Wh^OC9n;WdbOSJM=Yhf
WCZn=Ydj_SZm?[hj_CZn>[dngSZn?]hj_D;N?]i2gSkM@]hngT;n?]i2oSkN@_i2gT;n@]i2oT;N@_i2
gTKn@]i6oT;NA_i2oTKn@_i6oT;nA_i2oTKn@_i77T;nA_i2oTLNA_i77T;nAai6oTLNA_i77TKnAai6
oT/NA_i77TKnBai6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6oT/NA_i;7dKnBai6oT/OA_i;7TKnBam6
oT/NA_i;7dKnBai6oT/OAai;7TKnBam77T/NA_i;7dLNBai6oT/OAai;7TKnBam77T/NAai;7dLNBai7
7T/OAai;7TLN00X0000KBai77T/OAai;7TLNBam77T/NAai;7dLNBai77T/oAai;7TLNBcm77T/NAai;
?dLN00177T/o009;7P03Aai;?d/N00Eoo`03001oogoo01Qoo`00<Woo00<007ooOol0<Goo00@MN1ei
7GP5NP8IVP8=F@8Mf`095KXV72HL9Q`ZGBiM:Ud^GBYM008bO@07<YdbOC9m=YdfWSJM=Yh01SZn00Dn
_SkN?]hngSjn00HngP03@]hngT;N00=2gP=2oP04@]i2oT;nA_h3@_h01TKn@_i6oT;nA_i2oPi6oP0:
Aai6oTKnA_i77TKnAai6oTLNA_h3Aah01DKnAai77TLNA_h00dLN00A6oTLNAai;7P=77P0FBai77T/N
Aai;7TLNBai77T/NAai;7TLNBai77T/NAai;7TLNBai77T/NAah3Bah01DLNBai;7T/NAah00T/N2@00
8T/N00<004/NBah01D/N1Woo00<007ooOol05goo000bOol00`00Oomoo`0bOol011eh7GTIN1Vj0QVJ
07`IVB7l7M/Qnb8L9SdV72Hl;U`^GBYL;UdbOCJN<WdfWS9m>[hfWCZn=Ydj_SZm>[hj_Cjn>[dngSZm
?]hj_SkN>[e2gSkN@]hngD;N?]i2oSkM@_hngT;n@]i2oT;N@_i2gTKn@]i6oT;NA_i2gTKn@_i6oT;n
A_i2oTLN@_i6oT;nAai2oTLN@_i77TKnAai2oTLN