(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     88881,       3359]*)
(*NotebookOutlinePosition[    104345,       3747]*)
(*  CellTagsIndexPosition[    102203,       3688]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["4.4.3 Higher-Order Ordinary Differential Equations", "Section",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 64}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Higher order ordinary differential equations"],

Cell["\<\
Differential equations of higher order arise naturally in physics. \
For example, third-order ODEs come up in fluid dynamics and fourth-order ODEs \
in elasticity. For general higher-order equations, there exist hardly any \
techniques for obtaining explicit symbolic solutions. This means that \
higher-order ODEs are thus not well studied in the literature. In the \
following, we will present a symbolic technique for producing explicit \
solutions independent of the order of the equation. The method described in \
the preceding sections can, without essential changes, be generalized to the \
solution of differential equations of higher order.\
\>", "Text",
  CellTags->{
  "fluid dynamics", "elasticity", "symbolic solution", 
    "symbolic technique producing explicit solutions"}],

Cell[CellGroupData[{

Cell["4.4.3.1 Integrating Factor Method", "Subsection",
  CellTags->"Integrating factor method"],

Cell[TextData[{
  "The essential change in the theory of an integrating factor for \
higher-order ODEs is the extension of the Lie matrix to higher prolongations. \
Extending the Lie matrix to higher prolongations is the key step for \
generalizing the procedure of integrating factors. ",
  ButtonBox["Lie",
    ButtonData:>{"Literat.nb", "Enge-12"},
    ButtonStyle->"Hyperlink"],
  " called this extension the determination of the multiplier of the \
differential equation."
}], "Text",
  CellTags->{
  "integrating factor", "Lie matrix", "higher prolongation", "prolongation", 
    "determination of the multiplier of adifferential equation"}],

Cell[TextData[{
  "The ",
  ButtonBox["five steps of integration",
    ButtonData:>{"symmet3.nb", "five steps of integration"},
    ButtonStyle->"Hyperlink"],
  " discussed for second-order equations remain the same for higher-order \
equations. However, the dimension of the Lie matrix changes from a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Times]3\)]],
  " matrix to an ",
  Cell[BoxData[
      \(TraditionalForm\`\((n + 1)\)\[Times]\((n + 1)\)\)]],
  " matrix. Before we discuss the algorithm, let us state the general \
settings for higher-order equations."
}], "Text",
  CellTags->{"Lie matrix", "algorithm", "higher-order equation"}],

Cell[TextData[{
  "The most general form of an ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th-order ODE is given by"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(F(x, u, u', \(u'\)', \[Ellipsis], u\_\((n)\))\  = \ 0, \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u\_\((n)\)\), "=", 
          FractionBox[\(\(d\^n\) u\), 
            SuperscriptBox[
              StyleBox["dx",
                FontSlant->"Italic"], "n"]]}], TraditionalForm]]],
  " denotes the ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". In the following, we assume that equation (4.65) can be solved with \
respect to the ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th derivative. Thus, the actual equation under consideration is"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_\((n)\)\  = \ \[Omega](x, u, u', \[Ellipsis], u\_\((n - 1)\)), 
    \)\)], "NumberedEquation"],

Cell[TextData[{
  "where \[Omega] is a given function of ",
  Cell[BoxData[
      \(TraditionalForm\`x, u\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u', \[Ellipsis], u\_\((n - 1)\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "If an ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th-order equation admits a finite symmetry of dimension ",
  Cell[BoxData[
      \(TraditionalForm\`r \[GreaterEqual] n\)]],
  ", then the equation can be integrated by group-theoretic quadrature \
methods. This, also, can be done in various ways. For a discussion of other \
procedures, compare Sections ",
  ButtonBox["4.4.1",
    ButtonData:>{"symmet2.nb", "First order equations"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["4.4.2",
    ButtonData:>{"symmet3.nb", 
      "Second order ordinary differential equations"},
    ButtonStyle->"Hyperlink"],
  ". One of the group-theoretic algorithms is based on first integrals. The \
algorithm for an ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th-order ODE is summarized as follows:"
}], "Text",
  CellTags->{
  "finite symmetry", "quadrature method", "group theoretic algorithm"}],

Cell[TextData[{
  "Compute the Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  ". A basis for  ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  " is the set  ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_1\)]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_2\)]],
  ", \[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_r\)]],
  ". The tangent vector fields ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_i\)]],
  " follow from appropriately specifying the group constants."
}], "ListItem",
  CellDingbat->"1.",
  CellTags->{"Lie algebra", "tangent vector", "group constant"}],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`r = n\)]],
  ", go to the next step;\nif ",
  Cell[BoxData[
      \(TraditionalForm\`r > n\)]],
  ",  distinguish any ",
  StyleBox["n",
    FontSlant->"Italic"],
  "-dimensional subalgebra ",
  Cell[BoxData[
      \(TraditionalForm\`L\_n\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  ".\nIf ",
  Cell[BoxData[
      \(TraditionalForm\`r = n - 1\)]],
  ", the order of the equation may be lowered;\nif ",
  Cell[BoxData[
      \(TraditionalForm\`r = 0\)]],
  ", the group method is not useful."
}], "ListItem",
  CellDingbat->"2."],

Cell[TextData[{
  "Calculate the Lie determinants ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox[
            RowBox[{
              StyleBox["d",
                FontSlant->"Italic"], "\[CapitalDelta]"}]], "i"], 
        TraditionalForm]]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\)]],
  ", and if possible, determine the ",
  StyleBox["n",
    FontSlant->"Italic"],
  " first integrals by integration. The Lie determinants are defined by"
}], "ListItem",
  CellDingbat->"3.",
  CellTags->{"Lie determinant", "first integral"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox[
                RowBox[{
                  StyleBox["d",
                    FontSlant->"Italic"], "\[CapitalDelta]"}]], "1"], " ", 
            "=", " ", 
            RowBox[{"det", "(", GridBox[{
                  {
                    StyleBox["dx",
                      FontSlant->"Italic"], 
                    StyleBox["du",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["du",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontSlant->"Plain"]}], "\[Ellipsis]", 
                    SuperscriptBox[
                      StyleBox["du",
                        FontSlant->"Italic"], \((n - 1)\)]},
                  {\(\[Xi]\_2\), \(\[Phi]\_2\), \(\[Phi]\_2\%'\), 
                    "\[Ellipsis]", \(\[Phi]\_2\%\((n - 1)\)\)},
                  {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
                    "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
                    "\[VerticalEllipsis]"},
                  {"1", \(u'\), \(\(u'\)'\), "\[Ellipsis]", "\[Omega]"}
                  }], ")"}]}], ","}], " "}], TraditionalForm]]]], 
  "NumberedEquation"],

Cell["and", "ListItem",
  TextAlignment->Left,
  TextJustification->0],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          StyleBox[
            RowBox[{
              StyleBox["d",
                FontSlant->"Italic"], "\[CapitalDelta]"}]], "i"], "=", " ", 
        RowBox[{"det", "(", GridBox[{
              {\(\[Xi]\_1\), \(\[Phi]\_1\), \(\[Phi]\_1'\), "\[Ellipsis]", 
                \(\[Phi]\_1\%\((n - 1)\)\)},
              {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
                "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
                "\[VerticalEllipsis]"},
              {
                StyleBox["dx",
                  FontSlant->"Italic"], 
                StyleBox["du",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["du",
                    FontSlant->"Italic"], "'"}], "\[Ellipsis]", 
                SuperscriptBox[
                  StyleBox["du",
                    FontSlant->"Italic"], \((n - 1)\)]},
              {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
                "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
                "\[VerticalEllipsis]"},
              {"1", \(u'\), \(\(u'\)'\), "\[CenterEllipsis]", "\[Omega]"}
              }], ")"}]}], TraditionalForm]]]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  StyleBox["i",
    FontSlant->"Italic"],
  " denotes the row of the Lie matrix in which infinitesimals are replaced by \
 differentials. The ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontSlant->"Italic"], "\[Times]", 
          StyleBox["n",
            FontSlant->"Italic"]}], TraditionalForm]]],
  " Lie determinant \[CapitalDelta] reads"
}], "ListItem",
  CellTags->{"Lie matrix", "Lie determinant"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[CapitalDelta]", " ", "=", " ", 
          RowBox[{"det", 
            FormBox[
              RowBox[{"(", GridBox[{
                    {\(\[Xi]\_1\), \(\[Phi]\_1\), \(\[Phi]\_1\%'\), 
                      "\[Ellipsis]", \(\[Phi]\_1\%\((n - 1)\)\)},
                    {\(\[Xi]\_2\), \(\[Phi]\_2\), \(\[Phi]\_2\%'\), 
                      "\[Ellipsis]", \(\[Phi]\_2\%\((n - 1)\)\)},
                    {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
                      "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
                      "\[VerticalEllipsis]"},
                    {"1", \(u'\), \(\(u'\)'\), "\[Ellipsis]", "\[Omega]"}
                    }], ")"}],
              "TraditionalForm"]}]}], " ", ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i\)]],
  " are the infinitesimals of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Phi]\_i\%'\)\)]],
  " denotes the first and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i\%\((n - 1)\)\)]],
  " the (",
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["\[Dash]1",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[")",
    FontSlant->"Italic"],
  "th extension of the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i\)]],
  ". The corresponding first integrals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_i\)]],
  " are given by"
}], "ListItem",
  CellTags->{"infinitesimals", "first integral"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Psi]\_i\), " ", "=", " ", 
          RowBox[{
            RowBox[{"\[Integral]", 
              FractionBox[
                SubscriptBox[
                  StyleBox[
                    RowBox[{
                      StyleBox["d",
                        FontSlant->"Italic"], "\[CapitalDelta]"}]], "i"], 
                "\[CapitalDelta]"]}], " ", "=", " ", \(c\_i\)}]}], ",", 
        "         ", \(i = 1\), ",", "2", ",", "\[Ellipsis]", ",", 
        \(n . \)}], TraditionalForm]], "NumberedEquation",
  CellTags->"eq-27"],

Cell[TextData[{
  "The constants ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " denote the integration constants of the ODE."
}], "ListItem"],

Cell[TextData[{
  "Solve one of the ",
  StyleBox["n",
    FontSlant->"Italic"],
  " integrals with respect to the (",
  StyleBox["n\[Dash]",
    FontSlant->"Italic"],
  "1",
  StyleBox[")",
    FontSlant->"Italic"],
  "th-order derivative and substitute the result into the remaining \
relations. Repeat this procedure until no derivative remains in the \
relations."
}], "ListItem",
  CellDingbat->"4."],

Cell[TextData[{
  "If we can solve the resulting relation with respect to the unknown \
function ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", we have found an explicit solution. Otherwise, our solution is \
implicit."
}], "ListItem",
  CellDingbat->"5."],

Cell["\<\
This procedure becomes very cumbersome with increasing orders of \
the equation if done by hand. In principle, the procedure can be applied to \
any kind of linear or non-linear ODE. How the algorithm works in particular \
examples is demonstrated below.\
\>", "Text"],

Cell["Example 1 ", "Example"],

Cell[TextData[{
  "The first example is a third-order equation listed by ",
  ButtonBox["Kamke [1977]",
    ButtonData:>{"Literat.nb", "Kamke-1977"},
    ButtonStyle->"Hyperlink"],
  " as No. 7.13:"
}], "Text",
  CellTags->"third-order equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(thirdOrderExample\  = \ 
      \[PartialD]\_\(x, x\)u[x] \[PartialD]\_{x, 3}u[x] - 
        \[Alpha] 
          \@\( 1 + \(\[Beta]\^2\) \((\[PartialD]\_\(x, x\)u[x])\)\^2\)\ ; 
    \(Map[# == 0&, {thirdOrderExample}] // LieTraditionalForm\) // TableForm
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\[Alpha]\)\ \@\(1 + \[Beta]\^2\ u\_\(x, x\)\%2\) + 
                u\_\(x, x\)\ u\_\(x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, \[Alpha], 
              Power[ 
                Plus[ 1, 
                  Times[ 
                    Power[ \[Beta], 2], 
                    Power[ 
                      Subscript[ u, x, x], 2]]], 
                Rational[ 1, 2]]], 
            Times[ 
              Subscript[ u, x, x], 
              Subscript[ u, x, x, x]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The parameters \[Alpha] and \[Beta] are real constants. According to \
Kamke, this third-order ODE is solvable and the solution can only be \
represented in parametric form. We will show here that an explicit solution \
of the equation is possible. First, let us check if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can solve the third-order equation."
}], "Text",
  CellTags->"Kamke"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[thirdOrderExample == 0, u, x]\)], "Input"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(-\[Alpha]\), " ", 
              SqrtBox[
                RowBox[{"1", "+", 
                  RowBox[{\(\[Beta]\^2\), " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["u", "\[DoublePrime]",
                          MultilineFunction->None], "[", "x", "]"}], 
                      "2"]}]}]]}], "+", 
            RowBox[{
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], " ", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}]}], "==", "0"}], 
        ",", "u", ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The above line shows that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is not capable of solving the equation. The question now is: Can we \
derive the necessary number of symmetries in order to integrate the equation? \
Deriving the symmetries is the first step in the general algorithm. The \
calculation of symmetries is carried out by the ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Infinitesimals[]", "MmaText"]
}], "Text",
  CellTags->{"necessary number of symmetries", "Infinitesimals[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      Infinitesimals[thirdOrderExample, u, x, {\[Alpha], \[Beta]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{x, 3}u[x]}]\)], "Input"],

Cell[BoxData[
    \({phi[1] \[Rule] Function[{x, u}, k2 + k3\ x], 
      xi[1] \[Rule] Function[{x, u}, k1]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a symmetry group of order three. The number of group \
constants is equal to the order of the equation. This allows us to apply the \
integrating algorithm discussed above. The specific symmetries are denoted by \
the group constants ",
  StyleBox["k1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["k2",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["k3",
    FontSlant->"Italic"],
  ". Each of these parameters is related to a vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`i = 1, 2, 3\)]],
  ". Since the number of vector fields is equal to the order of the equation, \
we can go to step 3 of the algorithm. In the third step, we determine the Lie \
matrix by inserting the prolongations of the infinitesimals and the equation \
itself:"
}], "Text",
  CellTags->{
  "symmetry group", "group constants", "order of equation", 
    "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],

Cell[BoxData[
    \(\(inf1\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\) /. {
            k1 \[Rule] 1, k2 \[Rule] 0, k3 \[Rule] 0}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(inf2\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\)\  /. {
            k1 \[Rule] 0, k2 \[Rule] 1, k3 \[Rule] 0}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(inf3\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\)\  /. {
            k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 1}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell["The Lie matrix is derived by", "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalDelta]matrix = 
      DeltaMatrix[x, u, 
        \(\[Alpha] 
            \@\( 1 + 
                \(\[Beta]\^2\) 
                  \((\[PartialD]\_\(x, x\)u[x])\)\^2\)\)\/\[PartialD]\_\(x, x
              \)u[x], 3, {inf1, inf2, inf3}]; 
    TableForm[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "x", "1", "0"},
          {"1", \(u\_x\), \(u\_\(x, x\)\), 
            
            StyleBox[
              \(\(\[Alpha]\ \@\(1 + \[Beta]\^2\ u\_\(x, x\)\%2\)\)\/u\_\(x, x
                    \)\),
              ScriptLevel->0]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["One of the three first integrals is ", "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ1\  = \ 
      FirstIntegral[x, u, \[CapitalDelta]matrix, 1] == \ c1 // Simplify; 
    integ1 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(x - \@\(1 + \[Beta]\^2\ u\_\(x, x\)\%2\)\/\(\[Alpha]\ \[Beta]\^2\) == c1
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result depends on ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " and now allows us to rewrite all terms containing ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " in the Lie matrices. Next, we solve the first integral with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  ". Since the integral depends quadratically on ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  ", we get two solutions:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ Solve[integ1, \[PartialD]\_\(x, x\)u[x]]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(-\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\)}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\)}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The first of the two solutions is used to replace ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " in the Lie matrix. The reader can easily do the calculation for the \
second solution by himself:"
}], "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dmat\  = \ 
      \[CapitalDelta]matrix /. 
        sol1\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \({1, 0, 0, 0}\), ",", \({0, 1, 0, 0}\), ",", \({0, x, 1, 0}\), ",", 
        RowBox[{"{", 
          RowBox[{"1", ",", 
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], ",", 
            \(-\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\), ",", 
            \(-\(\((\[Alpha]\ 
                    \[Sqrt]\((
                        1 + \[Beta]\^2\ 
                            \((\(-\(1\/\[Beta]\^2\)\) + 
                                c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                                2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                                x\^2\ \[Alpha]\^2\ \[Beta]\^2)\))\))\)/
                \((\@\(\(-\(1\/\[Beta]\^2\)\) + 
                      c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                      2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                      x\^2\ \[Alpha]\^2\ \[Beta]\^2\))\)\)\)}], "}"}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The simplified Lie matrix is used again to calculate the second \
first integral of the third-order equation:\
\>", "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ2\  = \ FirstIntegral[x, u, dmat, 3] == \ c2 // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"(", 
          RowBox[{
          \(\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\ 
              \((\(-1\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^4 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^4)\)\), "+", 
            RowBox[{
            "\[Alpha]", " ", \(\[Beta]\^2\), " ", 
              \(\@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\)\), " ", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}]}], ")"}], "/", 
        \((\[Alpha]\ \[Beta]\^2\ 
            \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))\)}], "==", 
      "c2"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "As expected, we find the integral depending only on first derivatives of ",
  
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Since this integral is linear in ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  ", it is uniquely solvable in ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ Solve[integ2, \(u'\)[x]] // Simplify\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          \(c2 - \((
                \[Sqrt]\((
                      \(-\(1\/\[Beta]\^2\)\) + 
                        c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                        2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                        x\^2\ \[Alpha]\^2\ \[Beta]\^2)\)\ 
                  \((\(-1\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^4 - 
                      2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4 + 
                      x\^2\ \[Alpha]\^2\ \[Beta]\^4)\))\)/
              \((\[Alpha]\ \[Beta]\^2\ 
                  \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))\)\)}], 
        "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resultant expression contains radicals of quadratic polynomials in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Inserting this result into the Lie matrix, we are able to eliminate the \
dependencies on ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  ". We find"
}], "Text",
  CellTags->{"quadratic polynomial", "Lie matrix"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(dmat1\  = \ 
      dmat\  /. \ sol2\[LeftDoubleBracket]1, 1\[RightDoubleBracket] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 1, 0, 0}, {0, x, 1, 0}, {1, 
        c2 - \((\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                    2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                    x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\ 
                \((\(-1\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^4 - 
                    2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4 + 
                    x\^2\ \[Alpha]\^2\ \[Beta]\^4)\))\)/
            \((\[Alpha]\ \[Beta]\^2\ 
                \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))\), 
        \(-\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
              2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
              x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\), 
        \(-\(\(\[Alpha]\ 
                \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\)\)\/\@\(\(-
                    \(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The last step of integration is inserting the Lie matrices into the third \
first integral depending on ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ3\  = \ FirstIntegral[x, u, dmat1, 2] == \ c3 // Simplify\)], 
  "Input"],

Cell[BoxData[
    \(\((\(-c2\)\ x\^3\ \[Alpha]\^4\ \[Beta]\^8 + 
            c2\ \[Alpha]\ \[Beta]\^2\ 
              \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) - 
            c2\ x\^2\ \[Alpha]\^3\ \[Beta]\^6\ 
              \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) + 
            \@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                x\^2\ \[Alpha]\^2\ \[Beta]\^2\) - 
            2\ x\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
              \@\(\(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\) + 
            c1\^4\ \[Alpha]\^4\ \[Beta]\^8\ 
              \@\(\(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\) - 
            4\ c1\^3\ x\ \[Alpha]\^4\ \[Beta]\^8\ 
              \@\(\(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\) + 
            x\^4\ \[Alpha]\^4\ \[Beta]\^8\ 
              \@\(\(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\) + 
            2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4\ 
              \((c2\ x\ \[Alpha]\^2\ \[Beta]\^4 + 
                  c2\ \[Alpha]\ \[Beta]\^2\ 
                    \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) + 
                  2\ \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\) - 
                  2\ x\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
                    \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\))\) + 
            c1\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
              \((\(-c2\)\ x\ \[Alpha]\^2\ \[Beta]\^4 - 
                  c2\ \[Alpha]\ \[Beta]\^2\ 
                    \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) - 
                  2\ \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\) + 
                  6\ x\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
                    \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\))\) + 
            \((c1 - x)\)\^2\ \[Alpha]\^4\ \[Beta]\^8\ u[x])\)/
        \((\((c1 - x)\)\^2\ \[Alpha]\^4\ \[Beta]\^8)\) == c3\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The integral contains the dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " again as a linear variable. In turn, we end up with a unique solution for \
the Kamke equation 7.13, which is"
}], "Text",
  CellTags->"unique solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution\  = \ Solve[integ3, u[x]] // Simplify\)], "Input"],

Cell[BoxData[
    \({{u[x] \[Rule] 
          c3 - \((c1\^4\ \[Alpha]\^4\ \[Beta]\^8\ 
                    \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\) - 
                  4\ c1\^3\ x\ \[Alpha]\^4\ \[Beta]\^8\ 
                    \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\) + 
                  \[Sqrt]\((
                        \(-\(1\/\[Beta]\^2\)\) + 
                          c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\)\ 
                    \((\(-1\) + x\^2\ \[Alpha]\^2\ \[Beta]\^4)\)\^2 - 
                  c2\ \[Alpha]\ \[Beta]\^2\ 
                    \((x\^3\ \[Alpha]\^3\ \[Beta]\^6 - 
                        \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) + 
                        x\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
                          \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))\) + 
                  c1\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
                    \((2\ \[Sqrt]\((
                              \(-1\)\/\[Beta]\^2 + 
                                c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                                2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                                x\^2\ \[Alpha]\^2\ \[Beta]\^2)\)\ 
                          \((\(-1\) + 3\ x\^2\ \[Alpha]\^2\ \[Beta]\^4)\) - 
                        c2\ \[Alpha]\ \[Beta]\^2\ 
                          \((x\ \[Alpha]\ \[Beta]\^2 + 
                              \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))
                            \))\) + 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4\ 
                    \((\(-2\)\ 
                          \[Sqrt]\((
                              \(-1\)\/\[Beta]\^2 + 
                                c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                                2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                                x\^2\ \[Alpha]\^2\ \[Beta]\^2)\)\ 
                          \((\(-1\) + x\^2\ \[Alpha]\^2\ \[Beta]\^4)\) + 
                        c2\ \[Alpha]\ \[Beta]\^2\ 
                          \((x\ \[Alpha]\ \[Beta]\^2 + 
                              \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))
                            \))\))\)/
              \((\((c1 - x)\)\^2\ \[Alpha]\^4\ \[Beta]\^8)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution depends on three constants ",
  StyleBox["c1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["c2",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["c3, ",
    FontSlant->"Italic"],
  "all of which are constants of integration. The parameters \[Alpha] and \
\[Beta] are the parameters of the original equation. To get a feeling how the \
solution evolves, we plot the solution for different parameter sets ",
  StyleBox["c1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["c2",
    FontSlant->"Italic"],
  ",",
  StyleBox[" c3 ",
    FontSlant->"Italic"],
  "at fixed \[Alpha] and \[Beta]:"
}], "Text"],

Cell[BoxData[
    \(\(s1\  = \ 
      Table[\((\(u[x]\  /. solution\)\  /. {c1 \[Rule] 1, c2 \[Rule] 1\/2, 
                c3 \[Rule] i, \[Alpha] \[Rule] 1, \[Beta] \[Rule] 1\/2})
            \)\[LeftDoubleBracket]1\[RightDoubleBracket], {i, 0, 5}]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[s1], {x, 5, 7}, 
      PlotStyle 
        \[Rule] {RGBColor[0, \ 0, \ 0.996109], RGBColor[0, \ 0, \ 0.62501], 
          RGBColor[0.500008, \ 0, \ 0.500008], 
          RGBColor[0.500008, \ 0, \ 0.996109], 
          RGBColor[0.996109, \ 0, \ 0.500008], 
          RGBColor[0.500008, \ 0, \ 0.250004]}, 
      AxesLabel \[Rule] {"\<x\>", "\<u\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

-2.35714 0.476191 0.437763 0.0214979 [

[.2619 .42526 -9 -9 ]

[.2619 .42526 9 0 ]

[.5 .42526 -3 -9 ]

[.5 .42526 3 0 ]

[.7381 .42526 -9 -9 ]

[.7381 .42526 9 0 ]

[.97619 .42526 -3 -9 ]

[.97619 .42526 3 0 ]

[1.025 .43776 0 -7.5 ]

[1.025 .43776 10 7.5 ]

[.01131 .0078 -18 -4.5 ]

[.01131 .0078 0 4.5 ]

[.01131 .11529 -18 -4.5 ]

[.01131 .11529 0 4.5 ]

[.01131 .22278 -18 -4.5 ]

[.01131 .22278 0 4.5 ]

[.01131 .33027 -12 -4.5 ]

[.01131 .33027 0 4.5 ]

[.01131 .54525 -6 -4.5 ]

[.01131 .54525 0 4.5 ]

[.02381 .64303 -5 0 ]

[.02381 .64303 5 15 ]

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

.2619 .43776 m

.2619 .44401 L

s

[(5.5)] .2619 .42526 0 1 Mshowa

.5 .43776 m

.5 .44401 L

s

[(6)] .5 .42526 0 1 Mshowa

.7381 .43776 m

.7381 .44401 L

s

[(6.5)] .7381 .42526 0 1 Mshowa

.97619 .43776 m

.97619 .44401 L

s

[(7)] .97619 .42526 0 1 Mshowa

.125 Mabswid

.07143 .43776 m

.07143 .44151 L

s

.11905 .43776 m

.11905 .44151 L

s

.16667 .43776 m

.16667 .44151 L

s

.21429 .43776 m

.21429 .44151 L

s

.30952 .43776 m

.30952 .44151 L

s

.35714 .43776 m

.35714 .44151 L

s

.40476 .43776 m

.40476 .44151 L

s

.45238 .43776 m

.45238 .44151 L

s

.54762 .43776 m

.54762 .44151 L

s

.59524 .43776 m

.59524 .44151 L

s

.64286 .43776 m

.64286 .44151 L

s

.69048 .43776 m

.69048 .44151 L

s

.78571 .43776 m

.78571 .44151 L

s

.83333 .43776 m

.83333 .44151 L

s

.88095 .43776 m

.88095 .44151 L

s

.92857 .43776 m

.92857 .44151 L

s

.25 Mabswid

0 .43776 m

1 .43776 L

s

gsave

1.025 .43776 -61 -11.5 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Courier

%%DocumentNeededFonts: Courier

%%DocumentFonts: font Courier

grestore

.02381 .0078 m

.03006 .0078 L

s

[(-20)] .01131 .0078 1 0 Mshowa

.02381 .11529 m

.03006 .11529 L

s

[(-15)] .01131 .11529 1 0 Mshowa

.02381 .22278 m

.03006 .22278 L

s

[(-10)] .01131 .22278 1 0 Mshowa

.02381 .33027 m

.03006 .33027 L

s

[(-5)] .01131 .33027 1 0 Mshowa

.02381 .54525 m

.03006 .54525 L

s

[(5)] .01131 .54525 1 0 Mshowa

.125 Mabswid

.02381 .0293 m

.02756 .0293 L

s

.02381 .0508 m

.02756 .0508 L

s

.02381 .0723 m

.02756 .0723 L

s

.02381 .0938 m

.02756 .0938 L

s

.02381 .13679 m

.02756 .13679 L

s

.02381 .15829 m

.02756 .15829 L

s

.02381 .17979 m

.02756 .17979 L

s

.02381 .20129 m

.02756 .20129 L

s

.02381 .24428 m

.02756 .24428 L

s

.02381 .26578 m

.02756 .26578 L

s

.02381 .28728 m

.02756 .28728 L

s

.02381 .30878 m

.02756 .30878 L

s

.02381 .35177 m

.02756 .35177 L

s

.02381 .37327 m

.02756 .37327 L

s

.02381 .39477 m

.02756 .39477 L

s

.02381 .41626 m

.02756 .41626 L

s

.02381 .45926 m

.02756 .45926 L

s

.02381 .48076 m

.02756 .48076 L

s

.02381 .50226 m

.02756 .50226 L

s

.02381 .52375 m

.02756 .52375 L

s

.02381 .56675 m

.02756 .56675 L

s

.02381 .58825 m

.02756 .58825 L

s

.02381 .60975 m

.02756 .60975 L

s

.25 Mabswid

.02381 0 m

.02381 .61803 L

s

gsave

.02381 .64303 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Courier

%%DocumentNeededFonts: Courier

%%DocumentFonts: font Courier

grestore

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

0 0 .996 r

.5 Mabswid

.02381 .49151 m

.04262 .49274 L

.06244 .49388 L

.08255 .49481 L

.09396 .49522 L

.09905 .49537 L

.10458 .49551 L

.11004 .49562 L

.11508 .4957 L

.11989 .49576 L

.12232 .49579 L

.12369 .4958 L

.125 .49581 L

.12615 .49581 L

.12741 .49582 L

.12855 .49582 L

.12962 .49583 L

.13088 .49583 L

.13202 .49583 L

.13334 .49583 L

.13459 .49583 L

.13568 .49582 L

.13684 .49582 L

.1389 .49581 L

.14113 .49579 L

.14357 .49577 L

.14881 .4957 L

.15378 .49561 L

.16308 .49538 L

.1731 .49504 L

.184 .49455 L

.20377 .49334 L

.22478 .49159 L

.26253 .48718 L

.30273 .4806 L

.34142 .47234 L

.38256 .46139 L

.42218 .44865 L

.46029 .43431 L

.50085 .41673 L

.5399 .39749 L

.5814 .3745 L

.62138 .34982 L

.65984 .32368 L

.70076 .29326 L

.74017 .26136 L

.77805 .22824 L

.81839 .19032 L

.85722 .15117 L

.89849 .10667 L

Mistroke

.93826 .06096 L

.97619 .01472 L

Mfstroke

0 0 .625 r

.02381 .51301 m

.04262 .51424 L

.06244 .51538 L

.08255 .51631 L

.09396 .51671 L

.09905 .51686 L

.10458 .517 L

.11004 .51712 L

.11508 .5172 L

.11989 .51726 L

.12232 .51729 L

.12369 .5173 L

.125 .51731 L

.12615 .51731 L

.12741 .51732 L

.12855 .51732 L

.12962 .51732 L

.13088 .51733 L

.13202 .51733 L

.13334 .51733 L

.13459 .51732 L

.13568 .51732 L

.13684 .51732 L

.1389 .51731 L

.14113 .51729 L

.14357 .51727 L

.14881 .5172 L

.15378 .51711 L

.16308 .51688 L

.1731 .51653 L

.184 .51604 L

.20377 .51484 L

.22478 .51309 L

.26253 .50868 L

.30273 .5021 L

.34142 .49384 L

.38256 .48289 L

.42218 .47015 L

.46029 .45581 L

.50085 .43823 L

.5399 .41899 L

.5814 .396 L

.62138 .37132 L

.65984 .34518 L

.70076 .31475 L

.74017 .28286 L

.77805 .24974 L

.81839 .21181 L

.85722 .17267 L

.89849 .12817 L

Mistroke

.93826 .08246 L

.97619 .03621 L

Mfstroke

.5 0 .5 r

.02381 .5345 m

.04262 .53574 L

.06244 .53688 L

.08255 .53781 L

.09396 .53821 L

.09905 .53836 L

.10458 .5385 L

.11004 .53862 L

.11508 .5387 L

.11989 .53876 L

.12232 .53878 L

.12369 .53879 L

.125 .5388 L

.12615 .53881 L

.12741 .53882 L

.12855 .53882 L

.12962 .53882 L

.13088 .53882 L

.13202 .53883 L

.13334 .53882 L

.13459 .53882 L

.13568 .53882 L

.13684 .53881 L

.1389 .5388 L

.14113 .53879 L

.14357 .53876 L

.14881 .5387 L

.15378 .53861 L

.16308 .53838 L

.1731 .53803 L

.184 .53754 L

.20377 .53634 L

.22478 .53459 L

.26253 .53018 L

.30273 .5236 L

.34142 .51534 L

.38256 .50438 L

.42218 .49165 L

.46029 .47731 L

.50085 .45973 L

.5399 .44049 L

.5814 .4175 L

.62138 .39282 L

.65984 .36668 L

.70076 .33625 L

.74017 .30435 L

.77805 .27124 L

.81839 .23331 L

.85722 .19417 L

.89849 .14967 L

Mistroke

.93826 .10396 L

.97619 .05771 L

Mfstroke

.5 0 .996 r

.02381 .556 m

.04262 .55723 L

.06244 .55838 L

.08255 .5593 L

.09396 .55971 L

.09905 .55986 L

.10458 .56 L

.11004 .56011 L

.11508 .5602 L

.11989 .56026 L

.12232 .56028 L

.12369 .56029 L

.125 .5603 L

.12615 .56031 L

.12741 .56031 L

.12855 .56032 L

.12962 .56032 L

.13088 .56032 L

.13202 .56032 L

.13334 .56032 L

.13459 .56032 L

.13568 .56032 L

.13684 .56031 L

.1389 .5603 L

.14113 .56029 L

.14357 .56026 L

.14881 .56019 L

.15378 .5601 L

.16308 .55987 L

.1731 .55953 L

.184 .55904 L

.20377 .55783 L

.22478 .55608 L

.26253 .55168 L

.30273 .5451 L

.34142 .53683 L

.38256 .52588 L

.42218 .51315 L

.46029 .4988 L

.50085 .48122 L

.5399 .46199 L

.5814 .439 L

.62138 .41432 L

.65984 .38818 L

.70076 .35775 L

.74017 .32585 L

.77805 .29274 L

.81839 .25481 L

.85722 .21567 L

.89849 .17117 L

Mistroke

.93826 .12546 L

.97619 .07921 L

Mfstroke

.996 0 .5 r

.02381 .5775 m

.04262 .57873 L

.06244 .57987 L

.08255 .5808 L

.09396 .58121 L

.09905 .58136 L

.10458 .5815 L

.11004 .58161 L

.11508 .5817 L

.11989 .58176 L

.12232 .58178 L

.12369 .58179 L

.125 .5818 L

.12615 .58181 L

.12741 .58181 L

.12855 .58182 L

.12962 .58182 L

.13088 .58182 L

.13202 .58182 L

.13334 .58182 L

.13459 .58182 L

.13568 .58181 L

.13684 .58181 L

.1389 .5818 L

.14113 .58178 L

.14357 .58176 L

.14881 .58169 L

.15378 .5816 L

.16308 .58137 L

.1731 .58103 L

.184 .58054 L

.20377 .57933 L

.22478 .57758 L

.26253 .57317 L

.30273 .56659 L

.34142 .55833 L

.38256 .54738 L

.42218 .53464 L

.46029 .5203 L

.50085 .50272 L

.5399 .48349 L

.5814 .4605 L

.62138 .43581 L

.65984 .40967 L

.70076 .37925 L

.74017 .34735 L

.77805 .31424 L

.81839 .27631 L

.85722 .23716 L

.89849 .19267 L

Mistroke

.93826 .14696 L

.97619 .10071 L

Mfstroke

.5 0 .25 r

.02381 .599 m

.04262 .60023 L

.06244 .60137 L

.08255 .6023 L

.09396 .60271 L

.09905 .60285 L

.10458 .603 L

.11004 .60311 L

.11508 .60319 L

.11989 .60325 L

.12232 .60328 L

.12369 .60329 L

.125 .6033 L

.12615 .6033 L

.12741 .60331 L

.12855 .60331 L

.12962 .60332 L

.13088 .60332 L

.13202 .60332 L

.13334 .60332 L

.13459 .60332 L

.13568 .60331 L

.13684 .60331 L

.1389 .6033 L

.14113 .60328 L

.14357 .60326 L

.14881 .60319 L

.15378 .6031 L

.16308 .60287 L

.1731 .60253 L

.184 .60204 L

.20377 .60083 L

.22478 .59908 L

.26253 .59467 L

.30273 .58809 L

.34142 .57983 L

.38256 .56888 L

.42218 .55614 L

.46029 .5418 L

.50085 .52422 L

.5399 .50498 L

.5814 .48199 L

.62138 .45731 L

.65984 .43117 L

.70076 .40075 L

.74017 .36885 L

.77805 .33573 L

.81839 .29781 L

.85722 .25866 L

.89849 .21416 L

Mistroke

.93826 .16845 L

.97619 .1222 L

Mfstroke

% End of Graphics

MathPictureEnd


\
\>"], "Output",
  CellMargins->{{110, Inherited}, {Inherited, Inherited}},
  ImageSize->{216, 133.25},
  ImageMargins->{{24, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>0000YQ000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`002goo1@0017oo1000mWoo000;Ool01@00Oomoogoo00000goo00<007ooOol00Woo
00<007ooOol00Woo00<007ooOol0kWoo000<Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`3^Ool000=oo`H000Aoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
009oo`<00>ioo`003Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
dGoo00<07gooOol06Woo000?Ool01@00Oomoogoo000017oo00<007ooOol00Woo00<007ooOol0d7oo
00<07gooOol06goo000;Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol0cgoo00<07gooOol077oo000<Ool30005Ool40005Ool2003?Ool00`0OOomoo`0MOol001eo
o`03001oogoo0<eoo`0301moogoo01ioo`007Goo00<007ooOol0cGoo00D07gooOomoo`0C01aoo`00
7Goo00<007ooOol0c7oo00D07gooOomoo`0C01eoo`007Goo00<007ooOol0bgoo00D07gooOomoo`0C
01ioo`007Goo0P00bgoo00D07gooOomoo`0C01moo`007Goo00<007ooOol0bGoo00D07gooOomoo`0C
021oo`007Goo00<007ooOol0b7oo00<07gooOol00Woo00D04gooOomooc`?01aoo`007Goo00<007oo
Ool0agoo00<07gooOol00Woo00D04gooOomooc`?01eoo`007Goo00<007ooOol0agoo00D07gooOomo
o`0C00=oo`03?0moogoo01aoo`007Goo0P00agoo00D07gooOomoo`0C00=oo`03?0moogoo01eoo`00
7Goo00<007ooOol0aGoo00D07gooOomoo`0C00=oo`05?0moogooOoll7`0LOol001eoo`03001oogoo
0<Aoo`0501moogooOol04`04Ool013`?Oomooc`O7Goo000MOol00`00Oomoo`34Ool0100OOomoo`0C
17oo00@l3gooOoll7aioo`007Goo00<007ooOol0`goo00@07gooOol04`Aoo`05?0moogooOoll7`0N
Ool001eoo`800<=oo`0501moogooOol04`03Ool01C`?Oomoogoo?1l07goo000<Ool50003Ool40005
Ool00`00Oomoo`31Ool01@0OOomoogoo01<00goo00Dl3gooOomooc`O00=oo`03O0moogoo01Yoo`00
3Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0`Goo00@07gooOol0
4`=oo`05?0moogooOoll7`03Ool00g`?Oomoo`0KOol000ioo`03001oogoo00Moo`03001oogoo009o
o`03001oogoo0<1oo`0401moogoo01<3Ool01C`?Oomoogoo?1l00goo00=l3gooOol077oo0003Ool6
0005Ool00`00Oomoo`07Ool00`00Oomoo`02Ool3002oOol0100OOomoo`0C0goo00Dl3gooOomooc`O
00=oo`03O0moogoo01eoo`003Woo00<007ooOol00goo10001Goo00<007ooOol0_Woo00D07gooOomo
o`0C00=oo`05?0moogooOoll7`02Ool00g`?Oomoo`0NOol000ioo`03001oogoo00=oo`03001oogoo
00Ioo`03001oogoo0;eoo`0501moogooOol04`03Ool01C`?Oomoogoo?1l00goo00El3gooOomooc`7
01aoo`0037oo0`001Goo00<007ooOol01Woo00<007ooOol0^goo0P0O0goo00D04gooOomooc`?00=o
o`05?1moogooOoml3`03Ool00c`7Oomoo`0KOol000ioo`03001oogoo00=oo`D000Aoo`03001oogoo
0;Yoo`0301moogoo009oo`0501=oogooOoll3`03Ool01C`OOomoogooO0l00goo00<l1gooOol077oo
000MOol2002jOol00`0OOomoo`02Ool01@0COomoogoo?0l00goo00Dl7gooOomoog`?00=oo`03?0Mo
ogoo01eoo`007Goo00<007ooOol0^7oo00<07gooOol00Woo00<04gooOol00Woo00Dl3gooOomooc`O
009oo`05O0moogooOoll1`0POol001eoo`03001oogoo0;Moo`0301moogoo009oo`0301=oogoo009o
o`05?0moogooOoll7`02Ool00g`?Oomoo`02Ool00c`7Oomoo`0NOol001eoo`03001oogoo0;Ioo`03
01moogoo009oo`0301=oogoo009oo`05?0moogooOoll7`02Ool00g`?Oomoo`02Ool00c`7Oomoo`0O
Ool001eoo`03001oogoo0;Eoo`0301moogoo009oo`0301=oogoo009oo`05?0moogooOoll7`03Ool0
1G`?Oomoogoo?0L08Woo000MOol2002eOol00`0OOomoo`02Ool00`0COomoo`02Ool01C`?Oomoogoo
?1l00goo00El3gooOomooc`702=oo`007Goo00<007ooOol0/goo00<07gooOol00Woo00<04gooOol0
0Woo00<l3gooOol00Woo00@l7gooOoml3`=oo`03?0Moogoo029oo`007Goo00<007ooOol0/Woo00<0
7gooOol00Woo00<04gooOol00Woo00<l3gooOol00Woo00@l7gooOoml3`=oo`03?0Moogoo02=oo`00
7Goo00<007ooOol0/Woo00D07gooOomoo`0C00Aoo`03?0moogoo009oo`05?1moogooOoml3`02Ool0
0c`7Oomoo`0TOol001eoo`03001oogoo0;5oo`0501moogooOol04`04Ool00c`?Oomoo`02Ool01C`O
OomoogooO0l00Woo00<l1gooOol09Goo000MOol2002aOol01@0OOomoogoo01<017oo00<l3gooOol0
0Woo00Dl7gooOomoog`?00=oo`03?0Moogoo02Eoo`007Goo00<007ooOol0[goo00D07gooOomoo`0C
00Aoo`03?0moogoo009oo`05?1moogooOoml3`03Ool00c`7Oomoo`0VOol001eoo`03001oogoo0:io
o`0501moogooOol04`04Ool00c`?Oomoo`02Ool00c`OOomoo`02Ool017`?Oomooc`7:Goo000MOol0
0`00Oomoo`2]Ool00`0OOomoo`02Ool01@0COomoogoo?0l017oo00<l7gooOol00Woo00Al3gooOoll
1bYoo`007Goo00<007ooOol0[7oo00<07gooOol00Woo00D04gooOomooc`?00Aoo`03?1moogoo009o
o`04O0moogoo?0L[Ool001eoo`800:aoo`0301moogoo009oo`0501=oogooOoll3`04Ool00c`OOomo
o`02Ool01G`?Oomoogoo?0L0:goo000<Ool50003Ool40005Ool00`00Oomoo`2ZOol00`0OOomoo`02
Ool01@0COomoogoo?0l017oo00<l7gooOol00Woo00El3gooOomooc`702aoo`003Woo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0ZGoo00<07gooOol00Woo00D04gooOomo
oc`?00Aoo`03?1moogoo009oo`05O0moogooOoll1`0]Ool000ioo`03001oogoo009oo`03001oogoo
009oo`03001oogoo009oo`03001oogoo0:Qoo`0301moogoo009oo`0301=oogoo009oo`05?0moogoo
Ooll7`04Ool01G`?Oomoogoo?0L0;Woo0003Ool60005Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool3002WOol00`0OOomoo`02Ool00`0COomoo`02Ool01C`?Oomoogoo?1l017oo00El
3gooOomooc`702moo`003Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool0YWoo00<07gooOol00Woo00<04gooOol00Woo00Dl3gooOomooc`O00Aoo`05O0moogooOoll1`0`
Ool000ioo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo0:Eoo`0401mo
ogooOol201<4Ool01C`?Oomoogoo?1l017oo00El3gooOomooc`7035oo`0037oo0`0017oo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0Y7oo00D07gooOomoo`0C00Eoo`05?0moogooOoll7`04
Ool01G`?Oomoogoo?0L0<Woo000>Ool00`00Oomoo`03Ool40005Ool00`00Oomoo`2ROol201l3Ool0
0`0COomoo`03Ool01C`?Oomoogoo?1l017oo00El3gooOomooc`703=oo`007Goo0P00XWoo00<07goo
Ool00Woo00<04gooOol00goo00Dl3gooOomooc`O00Aoo`05O0moogooOoll1`0dOol001eoo`03001o
ogoo0:1oo`0301moogoo009oo`0301=oogoo00=oo`05?0moogooOoll7`04Ool01G`?Oomoogoo?0L0
=Goo000MOol00`00Oomoo`2NOol201l4Ool00`0COomoo`02Ool2?0l3Ool00c`OOomoo`02Ool01G`?
Oomoogoo?0L0=Woo000MOol00`00Oomoo`2MOol00`0OOomoo`03Ool00`0COomoo`02Ool00c`?Oomo
o`02Ool00c`OOomoo`02Ool01G`?Oomoogoo?0L0=goo000MOol00`00Oomoo`2LOol00`0OOomoo`03
Ool00`0COomoo`02Ool00c`?Oomoo`02Ool00c`OOomoo`02Ool01G`?Oomoogoo?0L0>7oo000MOol2
002LOol00`0OOomoo`02Ool201<4Ool00c`?Oomoo`02Ool00c`OOomoo`02Ool01G`?Oomoogoo?0L0
>Goo000MOol00`00Oomoo`2JOol00`0OOomoo`02Ool00`0COomoo`03Ool00c`?Oomoo`02Ool00c`O
Oomoo`02Ool01G`?Oomoogoo?0L0>Woo000MOol00`00Oomoo`2HOol201l4Ool00`0COomoo`03Ool0
0c`?Oomoo`02Ool00c`OOomoo`02Ool01G`?Oomoogoo?0L0>goo000MOol00`00Oomoo`2GOol00`0O
Oomoo`03Ool00`0COomoo`02Ool2?0l4Ool00c`OOomoo`02Ool00g`?Oomoo`02Ool00c`7Oomoo`0i
Ool001eoo`03001oogoo09Ioo`0301moogoo00=oo`0301=oogoo009oo`03?0moogoo00=oo`03?1mo
ogoo009oo`03O0moogoo009oo`03?0Moogoo03Yoo`007Goo0P00UWoo00<07gooOol00goo00<04goo
Ool00Woo00<l3gooOol00goo00<l7gooOol00Woo00=l3gooOol00Woo00<l1gooOol0>goo000MOol0
0`00Oomoo`2DOol00`0OOomoo`03Ool0100COomoogoo0S`?1Goo00<l7gooOol00Woo00=l3gooOol0
0Woo00<l1gooOol0?7oo000MOol00`00Oomoo`2BOol201l4Ool201<3Ool00c`?Oomoo`04Ool00c`O
Oomoo`02Ool00g`?Oomoo`02Ool00c`7Oomoo`0mOol001eoo`03001oogoo095oo`0301moogoo00=o
o`0301=oogoo009oo`03?0moogoo00=oo`8l7`Aoo`03O0moogoo009oo`03?0Moogoo03ioo`007Goo
0P00T7oo0P0O1Goo00<04gooOol00Woo00<l3gooOol00goo00<l7gooOol00goo00=l3gooOol00Woo
00<l1gooOol0?goo000MOol00`00Oomoo`2>Ool00`0OOomoo`04Ool00`0COomoo`02Ool00c`?Oomo
o`03Ool00c`OOomoo`03Ool00g`?Oomoo`02Ool00c`7Oomoo`10Ool001Aoo`@000Eoo`03001oogoo
08eoo`0301moogoo00Aoo`0301=oogoo009oo`03?0moogoo009oo`8l7`Eoo`04O0moogooOol2?0M3
Ool001=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo08]oo`807`Eoo`804`Aoo`03?0mo
ogoo009oo`03?1moogoo00Aoo`05O0moogooOoll1`15Ool001Qoo`03001oogoo009oo`03001oogoo
08Yoo`0301moogoo00Aoo`0301=oogoo00=oo`03?0moogoo009oo`03?1moogoo00=oo`9l3`=oo`03
?0Moogoo04Aoo`002goo1P001goo00<007ooOol00Woo0`00R7oo0P0O1Goo0P0C1Goo00<l3gooOol0
0Woo00<l7gooOol00goo00=l3gooOol00Woo00<l1gooOol0AGoo000DOol40005Ool00`00Oomoo`27
Ool00`0OOomoo`04Ool00`0COomoo`04Ool00c`?Oomoo`02Ool00c`OOomoo`03Ool00g`?Oomoo`02
Ool00c`7Oomoo`16Ool001Aoo`03001oogoo00Ioo`03001oogoo08Ioo`0301moogoo00Aoo`0301=o
ogoo00Aoo`04?0moogooOol2?1l4Ool2O0l4Ool00c`7Oomoo`17Ool001Aoo`03001oogoo00Ioo`03
001oogoo08Aoo`807`Eoo`804`Eoo`8l3`=oo`03?1moogoo00=oo`03O0moogoo00=oo`03?0Moogoo
04Qoo`0057oo1@0017oo00<007ooOol0Pgoo00<07gooOol017oo00<04gooOol00goo0S`?17oo00<l
7gooOol00goo00=l3gooOol00goo00<l1gooOol0BGoo000MOol20023Ool00`0OOomoo`03Ool201<5
Ool00c`?Oomoo`03Ool00c`OOomoo`03Ool00g`?Oomoo`02Ool2?0M<Ool001eoo`03001oogoo081o
o`807`Aoo`804`Eoo`8l3`Eoo`03?1moogoo00=oo`03O0moogoo009oo`03?0Moogoo04aoo`007Goo
00<007ooOol0OWoo0P0O1Goo00<04gooOol00goo0S`?1Goo0S`O17oo0W`?17oo00<l1gooOol0CGoo
000MOol00`00Oomoo`1lOol201l5Ool201<5Ool00c`?Oomoo`04Ool00c`OOomoo`03Ool00g`?Oomo
o`03Ool00c`7Oomoo`1>Ool001eoo`03001oogoo07Yoo`807`Ioo`0301=oogoo00=oo`8l3`Eoo`8l
7`Eoo`03O0moogoo00=oo`03?0Moogoo04moo`007Goo0P00:Goo10001Goo0P001Goo1000:Woo0`00
47oo00<07gooOol017oo0P0C1Goo00<l3gooOol017oo00<l7gooOol00Woo0P0000=l3gooOol00goo
00<l1`00Ool017oo1000:goo00<007ooOol06Woo000MOol00`00Oomoo`0WOol00`00Oomoo`02Ool0
0`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0VOol01@00Oomoogoo00003Goo0P0O
1Woo00<04gooOol017oo00<l3gooOol017oo00<l7gooOol00Woo00D007ooO0moo`0000=oo`03?0L0
000000Aoo`03001oogoo009oo`03001oogoo02Qoo`03001oogoo01Yoo`007Goo00<007ooOol0;7oo
00<007ooOol03Goo00<007ooOol09Woo00D007ooOomoo`0000]oo`807`Ioo`804`Eoo`8l3`Eoo`8l
7`Eoo`9l3`9oo`04001ooc`7?0L<Ool00`00Oomoo`0XOol00`00Oomoo`0JOol001eoo`03001oogoo
02aoo`03001oogoo00eoo`03001oogoo02Ioo`05001oogooOol00009Ool201l7Ool00`0COomoo`04
Ool00c`?Oomoo`04Ool00c`OOomoo`04Ool00g`?001oo`02Ool00`00?0Moo`0=Ool00`00Oomoo`0Y
Ool00`00Oomoo`0IOol001eoo`03001oogoo02Qoo`@000aoo`@002Uoo`@000Qoo`807`Moo`804`Io
o`03?0moogoo00=oo`8l7`Eoo`9l3`03Ool0000000800003?0Moogoo00Uoo`@002aoo`03001oogoo
01Uoo`007Goo0P00:Goo00<007ooOol03Goo00<007ooOol0:Woo00<007ooOol01goo0P0O27oo00<0
4gooOol017oo0S`?1Goo00<l7gooOol017oo00El3gooOomoo`00009oo`03?0Moogoo00Yoo`03001o
ogoo02ioo`03001oogoo01Qoo`007Goo00<007ooOol0:7oo00<007ooOol03Goo00<007ooOol0:goo
00<007ooOol017oo0P0O27oo0P0C1Woo00<l3gooOol017oo00<l7gooOol017oo00=l3gooOol00goo
00<003`7Ool037oo00<007ooOol0:Goo00<007ooOol00Woo00<007ooOol067oo000MOol00`00Oomo
o`0XOol5000;Ool5000ZOol300000goo01l07`08Ool201<6Ool2?0l5Ool2?1l5Ool2O0l5Ool2?0L3
000;Ool5000WOol6000JOol001eoo`03001oogoo06Uoo`807`Qoo`804`Moo`03?0moogoo00Aoo`03
?1moogoo00Aoo`03O0moogoo00Aoo`03?0Moogoo05Yoo`007Goo0P00Igoo0`0O27oo0P0C1goo0S`?
1Woo00<l7gooOol00goo0W`?1Goo0S`7GGoo000MOol00`00Oomoo`1TOol201l9Ool201<8Ool00c`?
Oomoo`04Ool2?1l5Ool00g`?Oomoo`04Ool00c`7Oomoo`1MOol001eoo`03001oogoo069oo`807`Uo
o`804`Qoo`8l3`Eoo`8l7`Ioo`03O0moogoo00Aoo`03?0Moogoo04moo`80009oo`8000Uoo`007Goo
00<007ooOol0H7oo0P0O2Goo0P0C27oo0S`?1Goo0S`O1Woo0W`?1Goo0S`7Dgoo00@007ooOol000Yo
o`007Goo00<007ooOol0GGoo0`0O2Goo0P0C27oo0S`?1Goo0S`O1goo00=l3gooOol017oo00<l1goo
Ool0E7oo0P002goo000HOomS000201l9000301<80002?0l600000c`O0000000600000g`?00000003
0002?0M=000:Ool2000;Ool001eoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Qoo`03
001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Qoo`03
001oogoo00Aoo`807`03Ool007oo00Ioo`804`03Ool007oo00Ioo`8l3`03Ool007oo00=oo`8l7`=o
o`04001oogooOol2O0l4Ool2?0L9Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`08Ool0
0`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool01000Oomoo`002Woo
000MOol00`00Oomoo`0bOol00`00Oomoo`0ROol201l9Ool201<3Ool00`00Oomoo`03Ool2?0l7Ool0
0c`OOomoo`05Ool2O0l5Ool00c`7Oomoo`0DOol00`00Oomoo`0bOol00`00Oomoo`0;Ool20002Ool2
0009Ool001eoo`03001oogoo05Aoo`<07`Uoo`804`Uoo`8l3`Moo`8l7`Ioo`9l3`Eoo`8l1fUoo`00
7Goo00<007ooOol0D7oo100O2Goo0`0C2Goo0S`?27oo00<l7gooOol017oo0W`?1Woo00<l1gooOol0
JGoo000MOol2001=Ool401l:Ool301<9Ool3?0l8Ool2?1l6Ool00g`?Oomoo`04Ool2?0M/Ool001eo
o`03001oogoo04Uoo`<07`aoo`804`Yoo`8l3`Uoo`8l7`Ioo`9l3`Ioo`03?0Moogoo06aoo`007Goo
00<007ooOol0AWoo0`0O37oo0`0C2Woo0S`?2Goo0S`O1Woo0W`?1Woo0S`7Kgoo000MOol00`00Oomo
o`12Ool401l<Ool301<;Ool2?0l9Ool2?1l6Ool2O0l7Ool00c`7Oomoo`1_Ool001eoo`03001oogoo
03ioo`@07`eoo`<04`]oo`<l3`Uoo`8l7`Ioo`9l3`Moo`8l1g9oo`007Goo0P00>7oo1`0O3Woo0`0C
2goo0c`?2Goo0c`O1goo00=l3gooOol01Woo00<l1gooOol0LWoo000MOol00`00Oomoo`0^Ool901lB
Ool301<<Ool2?0l:Ool2?1l8Ool2O0l7Ool2?0MeOol001eoo`L07amoo`/07aQoo`<04`aoo`<l3`Yo
o`8l7`Qoo`9l3`Moo`8l1gMoo`007Goo00<007ooOol017oo7`0O7Goo1P0C37oo0c`?2goo0S`O27oo
0W`?1goo0S`7NGoo000MOol2000jOol701<?Ool3?0l;Ool3?1l8Ool2O0l7Ool2?0MkOol001eoo`03
001oogoo03Eoo`@04a9oo`@l3`]oo`<l7`Uoo`9l3`Moo`8l1geoo`007Goo00<007ooOol0;Woo1`0C
4Woo13`?3Goo0S`O2Goo0g`?1goo0S`7Ogoo000MOol;01<KOol;01<DOol5?0l>Ool3?1l8Ool3O0l8
Ool2?0N1Ool001eoo`03001oogoo00Qooa/04a]oo`@l3a1oo`<l7`Qoo`=l3`Uoo`8l1h=oo`007Goo
0P00>Woo1C`?4Goo0c`O2Goo0W`?2Goo0c`7QGoo000MOol00`00Oomoo`0eOol4?0lBOol4?1l:Ool2
O0l9Ool2?0N8Ool001Aoo`@000Eoo`03001oogoo02ioo`Ll3a9oo`@l7`aoo`9l3`Uoo`8l1hYoo`00
4goo00<007ooOol00Woo00<007ooOol00Woo4S`?37oo4c`?57oo1C`O3Goo0g`?2Goo0S`7S7oo000H
Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool<?0lSOol4?1l>Ool4O0l9Ool3?0N>Ool001Qoo`03001o
ogoo009oo`<003Moo`Ll7`ioo`Al3`Yoo`<l1i5oo`0057oo10001Goo00<007ooOol0;Woo2C`O4Woo
0g`?37oo0S`7U7oo000DOol00`00Oomoo`06Ool2?1lYOol6?1lHOol3O0l<Ool3?0NFOol001Aoo`03
001oogoo00Ioo`03001ooc`O02Pl7aYoo`Al3`aoo`<l1iUoo`0057oo1@0017oo00<007ooOol0?Woo
17`?3Goo0c`7W7oo000MOol2000hOol7O0l>Ool3?0NOOol001eoo`03001oogoo02ioo`Ul3a9oo`<l
1j9oo`007Goo1g`?97oo1W`?67oo0c`7YGoo000MOol00`00Oomoo`04OolTO0lJOol4?0NXOol001eo
o`03001oogoo03ioo`@l1jaoo`007Goo0P00>7oo1c`7/7oo000MOol00`00Oomoo`0^Ool9?0NgOol0
01eoo`/l1a]oo`/l1l1oo`007Goo00<007ooOol027oo6c`7bgoo000MOol2003_Ool001eoo`03001o
ogoo0>ioo`007Goo00<007ooOol0kWoo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?mo
o`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`0077oo0P00
00=oo`000000kGoo000KOol00`00Oomoo`02003^Ool001]oo`05001oogooOol0003^Ool001]oo`05
001oogooOol0003^Ool001]oo`05001oogooOol0003^Ool001Yoo`80009oo`800>ioo`00ogoo3goo
003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {165.563, 0}} -> {4.72006, -21.1776, \
0.0118105, 0.261609}}]
}, Open  ]],

Cell["\<\
The figure represents the real valued solutions of the \
equation\
\>", "Text",
  TextJustification->1],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(\[PartialD]\_\(x, x\)u[x] \[PartialD]\_{x, 3}u[x]\),
          "Text",
          FontFamily->"Times"], 
        StyleBox[\(-\ \),
          "Text",
          FontFamily->"Times"], 
        StyleBox["\[Alpha]",
          "Text",
          FontFamily->"Times"], 
        StyleBox[
          \(\@\(1 + \(\(\[Beta]\^2\)(\[PartialD]\_\(x, x\)u[x])\)\^2\)\),
          ScriptLevel->1,
          FontFamily->"Times"], 
        StyleBox[" ",
          "Text",
          FontFamily->"Times"], 
        StyleBox[\( = 0. \),
          "Text",
          FontFamily->"Times"]}], TraditionalForm]], "DisplayFormula",
  TextJustification->1],

Cell[TextData[{
  "The different curves represent the solutions for values of  ",
  Cell[BoxData[
      \(TraditionalForm\`c3\  \[Element] {0, 1, 2, 3, 4, 5}\)]],
  " and fixed values for c2 = 1/2, c1 = 1. The parameters of the equation are \
\[Alpha] = 1 and \[Beta] = 1/2."
}], "Text",
  TextJustification->1],

Cell[TextData[{
  "We note that the solution is explicitly represented by a complicated \
expression containing radicals and polynomials. This result is new, as Kamke \
only offers a parametric representation of the solution. The example shows \
that with Lie\[CloseCurlyQuote]s procedure, we are able to arrive at a \
solution for higher-order ODEs. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", by itself, is not yet able to handle this type of equation.\[ThickSpace]\
\[EmptySquare]"
}], "Text",
  CellTags->"radical"],

Cell["Example 2", "Example"],

Cell["\<\
The second example for higher-order equations is a third-order \
equation. In this case, the equation has no direct physical origin. It is \
only used for checking the integration procedure:\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_\(x, x, x\) + \ 
        \[GothicCapitalR]\[GothicE]\ 
          \((u\_x\ u\_\(x, x\) - \ \(u(x)\)\ u\_\(x, x, x\))\)\  = \ 0, 
    \)\)], "NumberedEquation"],

Cell[TextData[{
  "where \[GothicCapitalR]\[GothicE] is a positive constant. The equation has \
some resemblance to hydrodynamic equations if the first term of the equation \
is replaced by a fourth-order derivative ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(x, x, x, x\)\)]],
  ". However, the fourth-order equation does not possess the necessary number \
of symmetries to start the integration process. The reader may check this. \
The equation under consideration is thus"
}], "Text",
  CellTags->{
  "hydrodynamic equations", "necessary number of symmetries", 
    "integration process"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(thirdOrder\  = \ 
      \[PartialD]\_\(x, x, x\)u[x] + \ 
        \[GothicCapitalR]\[GothicE]\ 
          \((\[PartialD]\_x u[x] \[PartialD]\_\(x, x\)u[x] - \ 
              u[x] \[PartialD]\_\(x, x, x\)u[x])\); 
    \(Map[# == 0&, {thirdOrder}] // LieTraditionalForm\) // TableForm\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(u\_\(x, x, x\) + 
                \[GothicCapitalR]\[GothicE]\ 
                  \((u\_x\ u\_\(x, x\) - u\ u\_\(x, x, x\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Subscript[ u, x, x, x], 
            Times[ \[GothicCapitalR]\[GothicE], 
              Plus[ 
                Times[ 
                  Subscript[ u, x], 
                  Subscript[ u, x, x]], 
                Times[ -1, u, 
                  Subscript[ u, x, x, x]]]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[
"where \[GothicCapitalR]\[GothicE] is a real constant. The equation has a \
minimum of required symmetries given by"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      Infinitesimals[thirdOrder\ , u, x, {\[GothicCapitalR]\[GothicE]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{x, 3}u[x]}]\)], "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, u}, k1 + k2\ x], 
      phi[1] \[Rule] 
        Function[{x, u}, 
          \(k3\ \((\(-1\) + u\ \[GothicCapitalR]\[GothicE])
                \)\)\/\[GothicCapitalR]\[GothicE]]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The calculation below shows that the functions of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " are not able to find all first integrals in a single run. We need to \
split the integration into a few steps considering the symmetries given by \
the vector fields ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  ". The three symmetries related to the vector fields are given by"
}], "Text",
  CellTags->{"first integrals", "vector field"}],

Cell[BoxData[
    \(\(inf1\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\) /. {
            k1 \[Rule] 1, k2 \[Rule] 0, k3 \[Rule] 0}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(inf2\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\)\  /. {
            k1 \[Rule] 0, k2 \[Rule] 1, k3 \[Rule] 0}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(inf3\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\)\  /. {
            k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 1}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[TextData[
"The right-hand side of the third-order equation \[Omega] is given by"], 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Omega]\  = \ 
      \((Solve[thirdOrder == 0, \[PartialD]\_\(x, x, x\)u[x]])
          \)\[LeftDoubleBracket]1, 1, 2\[RightDoubleBracket]; 
    \[Omega] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(\[GothicCapitalR]\[GothicE]\ u\_x\ u\_\(x, x\)\)\/\(\(-1\) + 
        u\ \[GothicCapitalR]\[GothicE]\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`4\[Times]4\)]],
  " Lie matrix follows by inserting the infinitesimals of the vector fields \
and \[Omega] into the function ",
  StyleBox["DeltaMatrix[]:", "MmaText"]
}], "Text",
  CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalDelta]matrix = 
      DeltaMatrix[x, u, \[Omega], 3, {inf1, inf2, inf3}]; 
    TableForm[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "0", "0", "0"},
          {"x", "0", \(-u\_x\), \(\(-2\)\ u\_\(x, x\)\)},
          {"0", 
            RowBox[{
              
              StyleBox[
                \(\(\(-1\) + 
                      u\ \[GothicCapitalR]\[GothicE]\)\/\[GothicCapitalR]\),
                ScriptLevel->0], "\[GothicE]"}], \(u\_x\), \(u\_\(x, x\)\)},
          {"1", \(u\_x\), \(u\_\(x, x\)\), 
            
            StyleBox[
              \(\(\[GothicCapitalR]\[GothicE]\ u\_x\ 
                    u\_\(x, x\)\)\/\(\(-1\) + 
                    u\ \[GothicCapitalR]\[GothicE]\)\),
              ScriptLevel->0]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The determinant of the Lie matrix is a polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`u, u'\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  ":"
}], "Text",
  CellTags->{"determinant", "Lie matrix"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(2\ u\_x\%2\ u\_\(x, x\) - 2\ u\ u\_\(x, x\)\%2 + 
      \(2\ u\_\(x, x\)\%2\)\/\[GothicCapitalR]\[GothicE]\)], "Output"]
}, Open  ]],

Cell[TextData[
"In order to obtain first integrals for the equation, the second line of the \
above \[CapitalDelta] matrix is replaced by the differentials:"], "Text",
  CellTags->"matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ1\  = \ 
      FirstIntegral[x, u, \[CapitalDelta]matrix, 2] == \ c1 // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(1\/2\), " ", 
        RowBox[{"(", 
          RowBox[{\(Log[\(-1\) + \[GothicCapitalR]\[GothicE]\ u[x]]\), "-", 
            RowBox[{"Log", "[", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], "]"}]}], 
          ")"}]}], "==", "c1"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The remaining two integrals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_3\)]],
  " are not accessible to ",
  StyleBox["FirstIntegral[]", "MmaText"],
  ". The reason for this is that the function ",
  StyleBox["Integrate[]", "MmaText"],
  " of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " cannot solve certain types of integrals. However, the result so far \
derived is helpful to find a solution of the equation. If we look at the \
first integral ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_2\)]],
  ", we observe that this relation is a second-order ODE. The solution for ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " clearly shows"
}], "Text",
  CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ Solve[integ1, \[PartialD]\_\(x, x\)u[x]] // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          \(E\^\(\(-2\)\ c1\)\ 
            \((\(-1\) + \[GothicCapitalR]\[GothicE]\ u[x])\)\)}], "}"}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we transform ",
  StyleBox["Rule",
    FontSlant->"Italic"],
  " to ",
  StyleBox["Equal",
    FontSlant->"Italic"],
  ", we get the equation"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqh\  = \ 
      \((sol1\  /. \ Rule \[Rule] Equal)\)\[LeftDoubleBracket]1, 1
        \[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["u", "\[DoublePrime]",
          MultilineFunction->None], "[", "x", "]"}], "==", 
      \(E\^\(\(-2\)\ c1\)\ 
        \((\(-1\) + \[GothicCapitalR]\[GothicE]\ u[x])\)\)}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "a second-order equation which is now solvable by ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ DSolve[eqh, u, x]\  /. \ c1 \[Rule] C[3]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] 
          \((1\/\[GothicCapitalR]\[GothicE] + 
                E\^\(\(-E\^\(-C[3]\)\)\ \@\[GothicCapitalR]\[GothicE]\ #1\)\ 
                  C[1] + E
                    \^\(E\^\(-C[3]\)\ \@\[GothicCapitalR]\[GothicE]\ #1\)\ 
                  C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
Inserting this solution into the original equation, we can verify \
that the original equation is satisfied,\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(thirdOrder\  /. \ sol2 // Simplify\)], "Input"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "meaning that the left-hand side of the equation vanishes, and, in turn, \
equality has been established. Solving the original equation with ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " we get"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[thirdOrder == 0, u, x]\)], "Input"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["u", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}], "+", 
            RowBox[{"\[GothicCapitalR]\[GothicE]", " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["u", "\[Prime]",
                        MultilineFunction->None], "[", "x", "]"}], " ", 
                    RowBox[{
                      SuperscriptBox["u", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}]}], "-", 
                  RowBox[{\(u[x]\), " ", 
                    RowBox[{
                      SuperscriptBox["u", 
                        TagBox[\((3)\),
                          Derivative],
                        MultilineFunction->None], "[", "x", "]"}]}]}], 
                ")"}]}]}], "==", "0"}], ",", "u", ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "showing us that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in the present form is not capable of handling third-order equations."
}], "Text"],

Cell[TextData[
"The example demonstrates that we can even find solutions for cases where we \
know fewer first integrals than the order of the equation. The procedure of \
integration splits heterogeneously using different tools to solve the reduced \
equation. This behavior of higher-order ODEs creates some difficulties in the \
automatic solution process.\[ThickSpace]\[EmptySquare]"], "Text",
  CellTags->"higher-order ODE"],

Cell["Example 3", "Example"],

Cell[TextData[{
  "The third example considers the fourth-order ODE No. 7.16 of ",
  ButtonBox["Kamke [1977]",
    ButtonData:>{"Literat.nb", "Kamke-1977"},
    ButtonStyle->"Hyperlink"],
  ". This equation is a non-linear ODE containing second-, third-, and \
fourth-order derivatives. The problem with such an equation is that no \
standard procedure in literature offers a way to construct the solution given \
by Kamke. We will demonstrate that the integrating factor method is very \
effective for the construction of the solution. The equation No. 7.16 by \
Kamke reads"
}], "Text",
  CellTags->{"fourth-order ODE", "integrating factor method"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(kamke716\  = 
      3\ \[PartialD]\_\(x, x\)u[x] \[PartialD]\_{x, 4}u[x]\  - 
          5\ \((\[PartialD]\_\(x, x, x\)u[x])\)\^2 == 0; 
    kamke716 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(-5\)\ u\_\(x, x, x\)\%2 + 3\ u\_\(x, x\)\ u\_\(x, x, x, x\) == 0\)], 
  "Output"]
}, Open  ]],

Cell["\<\
Kamke also lists the solution of the above ODE in implicit \
form:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", 
        RowBox[{
          RowBox[{\(u(x)\), " ", "+", 
            
            FormBox[\(\(\(C\_1\) x\  + \ C\_2)\)\^2\  = \ 
                \(C\_3\) x\  + \ C\_4\),
              "TraditionalForm"]}], ","}]}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`C\_1, C\_2, C\_3\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`C\_4\)]],
  " are real constants. The following examinations will demonstrate that this \
simple solution follows from our procedure. The first step of Lie's procedure \
is the determination of the infinitesimals:"
}], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infkamke\  = \ 
      Infinitesimals[kamke716, u, x, 
        SubstitutionRules \[Rule] {\[PartialD]\_{x, 4}\ u[x]}]\)], "Input"],

Cell[BoxData[
    \({phi[1] \[Rule] Function[{x, u}, k3 + k1\ u + k4\ x], 
      xi[1] \[Rule] Function[{x, u}, k5 + k2\ u + k6\ x]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of this calculation is a symmetry group containing six group \
parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k\_i\)]],
  ". The second step consists in finding a solvable subalgebra of dimension \
four from these infinitesimals. The determination of all solvable subalgebras \
of dimension four is carried out with"
}], "Text",
  CellTags->{"symmetry group", "group parameter", "solvable subalgebra"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solvable\  = \ SolvableAlgebrasOfOrderN[infkamke, {u}, {x}, 4]\)], 
  "Input",
  CellTags->"SolvableAlgebrasOfOrderN[]"],

Cell[BoxData[
    \({{{k1 \[Rule] 1}, {k2 \[Rule] 1}, {k3 \[Rule] 1}, {k5 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k2 \[Rule] 1}, {k4 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k2 \[Rule] 1}, {k5 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k3 \[Rule] 1}, {k4 \[Rule] 1}, {k5 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k3 \[Rule] 1}, {k4 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k3 \[Rule] 1}, {k5 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k2 \[Rule] 1}, {k3 \[Rule] 1}, {k5 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k3 \[Rule] 1}, {k4 \[Rule] 1}, {k5 \[Rule] 1}, {k6 \[Rule] 1}}}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
From the result, we can choose one of the eight solvable algebras. \
The related coefficients of the vector fields creating these subalgebras are \
derived by inserting the above result and assuming the other group constants \
equal to zero:\
\>", "Text",
  CellTags->"subalgebra"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vectorBasis\  = 
      Map[\((\(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}} /. infkamke\) /. #
                \) /. {k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, 
                k4 \[Rule] 0, k5 \[Rule] 0, k6 \[Rule] 0, u \[Rule] u[x]})
            \)&, solvable]\)], "Input"],

Cell[BoxData[
    \({{{{0}, {u[x]}}, {{u[x]}, {0}}, {{0}, {1}}, {{1}, {0}}}, {{{0}, {
            u[x]}}, {{u[x]}, {0}}, {{0}, {x}}, {{x}, {0}}}, {{{0}, {u[x]}}, {{
            u[x]}, {0}}, {{1}, {0}}, {{x}, {0}}}, {{{0}, {u[x]}}, {{0}, {
            1}}, {{0}, {x}}, {{1}, {0}}}, {{{0}, {u[x]}}, {{0}, {1}}, {{0}, {
            x}}, {{x}, {0}}}, {{{0}, {u[x]}}, {{0}, {1}}, {{1}, {0}}, {{x}, {
            0}}}, {{{u[x]}, {0}}, {{0}, {1}}, {{1}, {0}}, {{x}, {0}}}, {{{
            0}, {1}}, {{0}, {x}}, {{1}, {0}}, {{x}, {0}}}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Knowing the infinitesimals of the solvable subalgebras, we can proceed to \
the integration step of the algorithm. The information from the original \
equation ",
  StyleBox["kamke176",
    FontSlant->"Italic"],
  " about the right-hand side of the equation is extracted by"
}], "Text",
  CellTags->{"infinitesimals", "algorithm"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Omega]\  = \ 
      \(Solve[kamke716, \[PartialD]\_{x, 4}u[x]]\)[\([1, 1, 2]\)]; 
    \[Omega] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(5\ u\_\(x, x, x\)\%2\)\/\(3\ u\_\(x, x\)\)\)], "Output"]
}, Open  ]],

Cell["\<\
The Lie matrix of the equation is then calculated for the fourth \
subalgebra by\
\>", "Text",
  CellTags->{"Lie matrix", "subalgebra"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalDelta]matrix = 
      DeltaMatrix[x, u, \[Omega], 4, 
        vectorBasis\[LeftDoubleBracket]4\[RightDoubleBracket]]; 
    TableForm[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"0", "u", \(u\_x\), \(u\_\(x, x\)\), \(u\_\(x, x, x\)\)},
          {"0", "1", "0", "0", "0"},
          {"0", "x", "1", "0", "0"},
          {"1", "0", "0", "0", "0"},
          {"1", \(u\_x\), \(u\_\(x, x\)\), \(u\_\(x, x, x\)\), 
            StyleBox[\(\(5\ u\_\(x, x, x\)\%2\)\/\(3\ u\_\(x, x\)\)\),
              ScriptLevel->0]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData["The determinant of the \[CapitalDelta] matrix is"], "Text",
  CellTags->"determinant"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(-\(2\/3\)\)\ u\_\(x, x, x\)\%2\)], "Output"]
}, Open  ]],

Cell[TextData[
"Knowing that the determinant of Lie\[CloseCurlyQuote]s matrix is a \
non-vanishing quantity, we can calculate the first integrals of the equation. \
One of these integrals is"], "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ1\  = \ 
      FirstIntegral[x, u, \[CapitalDelta]matrix, 1] == \ c1 // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(1\/2\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"5", " ", 
              RowBox[{"Log", "[", 
                RowBox[{
                  SuperscriptBox["u", "\[DoublePrime]",
                    MultilineFunction->None], "[", "x", "]"}], "]"}]}], "-", 
            RowBox[{"3", " ", 
              RowBox[{"Log", "[", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((3)\),
                      Derivative],
                    MultilineFunction->None], "[", "x", "]"}], "]"}]}]}], 
          ")"}]}], "==", "c1"}]], "Output"]
}, Open  ]],

Cell["A second first integral follows by", "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ2\  = \ 
      FirstIntegral[x, u, \[CapitalDelta]matrix, 4] == \ c2 // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"x", "+", 
        FractionBox[
          RowBox[{"3", " ", 
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], 
          RowBox[{"2", " ", 
            RowBox[{
              SuperscriptBox["u", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}]]}], "==", 
      "c2"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "At this point of our calculation, we know that equation No. 7.16 by Kamke \
allows two conserved quantities given by ",
  StyleBox["integ1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["integ2",
    FontSlant->"Italic"],
  ". The right-hand sides of these differential expressions ",
  StyleBox["c1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["c2",
    FontSlant->"Italic"],
  " are two real constants. The two integrals contain derivatives of third \
and second order. Since we know that both expressions are conserved, we can \
use one of these quantities to eliminate higher derivatives. We decide to \
eliminate the third-order derivative in the first integral ",
  StyleBox["integ1",
    FontSlant->"Italic"],
  " by"
}], "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1\  = \ Solve[integ2, \[PartialD]\_\(x, x, x\)u[x]] // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          FractionBox[
            RowBox[{"3", " ", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], 
            \(2\ c2 - 2\ x\)]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The elimination of the third-order derivative in ",
  StyleBox["integ1",
    FontSlant->"Italic"],
  " gives us"
}], "Text",
  CellTags->"third-order derivative"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ1Help\  = \ 
      integ1\  /. s1\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(1\/2\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"5", " ", 
              RowBox[{"Log", "[", 
                RowBox[{
                  SuperscriptBox["u", "\[DoublePrime]",
                    MultilineFunction->None], "[", "x", "]"}], "]"}]}], "-", 
            RowBox[{"3", " ", 
              RowBox[{"Log", "[", 
                FractionBox[
                  RowBox[{"3", " ", 
                    RowBox[{
                      SuperscriptBox["u", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}]}], 
                  \(2\ c2 - 2\ x\)], "]"}]}]}], ")"}]}], "==", "c1"}]], 
  "Output"]
}, Open  ]],

Cell["\<\
representing an integral containing only second-order derivatives. \
The solution of this expression with respect to the second integral \
delivers\
\>", "Text",
  CellTags->"second-order derivative"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s2\  = \ Solve[integ1Help, \[PartialD]\_\(x, x\)u[x]]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(-\(\(3\ \@3\ 
                    E\^c1\)\/\@\(8\ c2\^3 - 24\ c2\^2\ x + 24\ c2\ x\^2 - 
                      8\ x\^3\)\)\)}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(\(3\ \@3\ 
                  E\^c1\)\/\@\(8\ c2\^3 - 24\ c2\^2\ x + 24\ c2\ x\^2 - 
                    8\ x\^3\)\)}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The two resulting expressions can be integrated twice to find the \
solution. However, we apply ",
  StyleBox["DSolve[]", "MmaText"],
  " to the expressions to find the solution. Before we can use ",
  StyleBox["DSolve[],", "MmaText"],
  " we need to transform the rules to equations by"
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqh\  = \ s2\  /. Rule \[Rule] Equal // Flatten\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "==", 
          \(-\(\(3\ \@3\ 
                  E\^c1\)\/\@\(8\ c2\^3 - 24\ c2\^2\ x + 24\ c2\ x\^2 - 
                    8\ x\^3\)\)\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "==", 
          \(\(3\ \@3\ 
                E\^c1\)\/\@\(8\ c2\^3 - 24\ c2\^2\ x + 24\ c2\ x\^2 - 
                  8\ x\^3\)\)}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Solving the first equation gives us", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ DSolve[eqh[\([1]\)], u, x]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] 
          \((C[1] + C[2]\ #1 - 
                \(3\ \@3\ E\^c1\ 
                    \@\(8\ c2\^3 - 24\ c2\^2\ #1 + 24\ c2\ #1\^2 - 
                        8\ #1\^3\)\)\/\(2\ \((\(-c2\) + #1)\)\)&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The second relation for ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " delivers the second solution"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ DSolve[eqh[\([2]\)], u, x]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] 
          \((C[1] + C[2]\ #1 + 
                \(3\ \@3\ E\^c1\ 
                    \@\(8\ c2\^3 - 24\ c2\^2\ #1 + 24\ c2\ #1\^2 - 
                        8\ #1\^3\)\)\/\(2\ \((\(-c2\) + #1)\)\)&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "In conclusion, we find two solutions in an explicit representation. This \
has to be expected since the solution given by Kamke contains the unknown \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " in quadratic form. The derived solution can be inserted into the original \
equation to verify that the gained results are correct. For the first \
solution, we find"
}], "Text",
  CellTags->"Kamke"],

Cell[CellGroupData[{

Cell[BoxData[
    \(kamke716 /. sol1 // Simplify\)], "Input"],

Cell[BoxData[
    \({True}\)], "Output"]
}, Open  ]],

Cell["\<\
meaning that the first solution satisfies the equation. The second \
solution also satisfies the equation\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(kamke716 /. sol2 // Simplify\)], "Input"],

Cell[BoxData[
    \({True}\)], "Output"]
}, Open  ]],

Cell[TextData[
"At the end, we demonstrated that the integrating factor method is capable of \
solving a fourth-order equation.\[ThickSpace]\[EmptySquare]"], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet5.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
AutoGeneratedPackage->Automatic,
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{729, 668},
WindowMargins->{{8, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->205,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Symmetries of Ordinary Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Analysis of Ordinary Differential Equations", FontSlant -> 
            "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"Hyperlinks"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Higher order ordinary differential equations"->{
    Cell[1739, 51, 407, 5, 52, "Section",
      CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 64}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Higher order ordinary differential equations"]},
  "fluid dynamics"->{
    Cell[2149, 58, 800, 13, 159, "Text",
      CellTags->{
      "fluid dynamics", "elasticity", "symbolic solution", 
        "symbolic technique producing explicit solutions"}]},
  "elasticity"->{
    Cell[2149, 58, 800, 13, 159, "Text",
      CellTags->{
      "fluid dynamics", "elasticity", "symbolic solution", 
        "symbolic technique producing explicit solutions"}]},
  "symbolic solution"->{
    Cell[2149, 58, 800, 13, 159, "Text",
      CellTags->{
      "fluid dynamics", "elasticity", "symbolic solution", 
        "symbolic technique producing explicit solutions"}]},
  "symbolic technique producing explicit solutions"->{
    Cell[2149, 58, 800, 13, 159, "Text",
      CellTags->{
      "fluid dynamics", "elasticity", "symbolic solution", 
        "symbolic technique producing explicit solutions"}]},
  "Integrating factor method"->{
    Cell[2974, 75, 96, 1, 49, "Subsection",
      CellTags->"Integrating factor method"]},
  "integrating factor"->{
    Cell[3073, 78, 647, 13, 96, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}]},
  "Lie matrix"->{
    Cell[3073, 78, 647, 13, 96, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}],
    Cell[3723, 93, 646, 15, 96, "Text",
      CellTags->{"Lie matrix", "algorithm", "higher-order equation"}],
    Cell[11200, 329, 477, 15, 45, "ListItem",
      CellTags->{"Lie matrix", "Lie determinant"}],
    Cell[18785, 571, 1021, 26, 138, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],
    Cell[20416, 617, 70, 1, 33, "Text",
      CellTags->"Lie matrix"],
    Cell[23219, 709, 266, 7, 54, "Text",
      CellTags->"Lie matrix"],
    Cell[27207, 824, 365, 10, 54, "Text",
      CellTags->{"quadratic polynomial", "Lie matrix"}],
    Cell[66481, 2627, 309, 8, 54, "Text",
      CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}],
    Cell[67828, 2670, 253, 9, 33, "Text",
      CellTags->{"determinant", "Lie matrix"}],
    Cell[79114, 3024, 146, 4, 33, "Text",
      CellTags->{"Lie matrix", "subalgebra"}],
    Cell[80361, 3067, 227, 4, 54, "Text",
      CellTags->"Lie matrix"]},
  "higher prolongation"->{
    Cell[3073, 78, 647, 13, 96, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}]},
  "prolongation"->{
    Cell[3073, 78, 647, 13, 96, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}],
    Cell[18785, 571, 1021, 26, 138, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", 
        "prolongation"}]},
  "determination of the multiplier of adifferential equation"->{
    Cell[3073, 78, 647, 13, 96, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}]},
  "algorithm"->{
    Cell[3723, 93, 646, 15, 96, "Text",
      CellTags->{"Lie matrix", "algorithm", "higher-order equation"}],
    Cell[18785, 571, 1021, 26, 138, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],
    Cell[78492, 3003, 350, 8, 75, "Text",
      CellTags->{"infinitesimals", "algorithm"}]},
  "higher-order equation"->{
    Cell[3723, 93, 646, 15, 96, "Text",
      CellTags->{"Lie matrix", "algorithm", "higher-order equation"}]},
  "finite symmetry"->{
    Cell[5679, 162, 920, 25, 96, "Text",
      CellTags->{
      "finite symmetry", "quadrature method", "group theoretic algorithm"}]},
  "quadrature method"->{
    Cell[5679, 162, 920, 25, 96, "Text",
      CellTags->{
      "finite symmetry", "quadrature method", "group theoretic algorithm"}]},
  "group theoretic algorithm"->{
    Cell[5679, 162, 920, 25, 96, "Text",
      CellTags->{
      "finite symmetry", "quadrature method", "group theoretic algorithm"}]},
  "Lie algebra"->{
    Cell[6602, 189, 708, 22, 45, "ListItem",
      CellTags->{"Lie algebra", "tangent vector", "group constant"}]},
  "tangent vector"->{
    Cell[6602, 189, 708, 22, 45, "ListItem",
      CellTags->{"Lie algebra", "tangent vector", "group constant"}]},
  "group constant"->{
    Cell[6602, 189, 708, 22, 45, "ListItem",
      CellTags->{"Lie algebra", "tangent vector", "group constant"}]},
  "Lie determinant"->{
    Cell[7935, 239, 584, 19, 45, "ListItem",
      CellTags->{"Lie determinant", "first integral"}],
    Cell[11200, 329, 477, 15, 45, "ListItem",
      CellTags->{"Lie matrix", "Lie determinant"}]},
  "first integral"->{
    Cell[7935, 239, 584, 19, 45, "ListItem",
      CellTags->{"Lie determinant", "first integral"}],
    Cell[12511, 365, 883, 31, 45, "ListItem",
      CellTags->{"infinitesimals", "first integral"}],
    Cell[21381, 651, 82, 1, 33, "Text",
      CellTags->"first integral"],
    Cell[24785, 751, 163, 4, 33, "Text",
      CellTags->"first integral"],
    Cell[28764, 863, 280, 10, 54, "Text",
      CellTags->"first integral"],
    Cell[81394, 3100, 80, 1, 33, "Text",
      CellTags->"first integral"],
    Cell[82118, 3127, 793, 22, 117, "Text",
      CellTags->"first integral"]},
  "infinitesimals"->{
    Cell[12511, 365, 883, 31, 45, "ListItem",
      CellTags->{"infinitesimals", "first integral"}],
    Cell[66481, 2627, 309, 8, 54, "Text",
      CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}],
    Cell[75320, 2921, 400, 11, 75, "Text",
      CellTags->"infinitesimals"],
    Cell[78492, 3003, 350, 8, 75, "Text",
      CellTags->{"infinitesimals", "algorithm"}]},
  "eq-27"->{
    Cell[13397, 398, 589, 15, 44, "NumberedEquation",
      CellTags->"eq-27"]},
  "third-order equation"->{
    Cell[15133, 457, 246, 7, 33, "Text",
      CellTags->"third-order equation"]},
  "Kamke"->{
    Cell[16454, 502, 419, 9, 96, "Text",
      CellTags->"Kamke"],
    Cell[87688, 3313, 433, 10, 96, "Text",
      CellTags->"Kamke"]},
  "necessary number of symmetries"->{
    Cell[17883, 544, 564, 13, 96, "Text",
      CellTags->{"necessary number of symmetries", "Infinitesimals[]"}],
    Cell[62641, 2511, 598, 12, 96, "Text",
      CellTags->{
      "hydrodynamic equations", "necessary number of symmetries", 
        "integration process"}]},
  "Infinitesimals[]"->{
    Cell[17883, 544, 564, 13, 96, "Text",
      CellTags->{"necessary number of symmetries", "Infinitesimals[]"}]},
  "symmetry group"->{
    Cell[18785, 571, 1021, 26, 138, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],
    Cell[76058, 2946, 440, 9, 75, "Text",
      CellTags->{
      "symmetry group", "group parameter", "solvable subalgebra"}]},
  "group constants"->{
    Cell[18785, 571, 1021, 26, 138, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", 
        "prolongation"}]},
  "order of equation"->{
    Cell[18785, 571, 1021, 26, 138, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", 
        "prolongation"}]},
  "integrating algorithm"->{
    Cell[18785, 571, 1021, 26, 138, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", 
        "prolongation"}]},
  "quadratic polynomial"->{
    Cell[27207, 824, 365, 10, 54, "Text",
      CellTags->{"quadratic polynomial", "Lie matrix"}]},
  "unique solution"->{
    Cell[32176, 936, 272, 7, 54, "Text",
      CellTags->"unique solution"]},
  "radical"->{
    Cell[61647, 2483, 535, 11, 96, "Text",
      CellTags->"radical"]},
  "hydrodynamic equations"->{
    Cell[62641, 2511, 598, 12, 96, "Text",
      CellTags->{
      "hydrodynamic equations", "necessary number of symmetries", 
        "integration process"}]},
  "integration process"->{
    Cell[62641, 2511, 598, 12, 96, "Text",
      CellTags->{
      "hydrodynamic equations", "necessary number of symmetries", 
        "integration process"}]},
  "first integrals"->{
    Cell[64894, 2579, 489, 11, 75, "Text",
      CellTags->{"first integrals", "vector field"}]},
  "vector field"->{
    Cell[64894, 2579, 489, 11, 75, "Text",
      CellTags->{"first integrals", "vector field"}]},
  "DeltaMatrix[]"->{
    Cell[66481, 2627, 309, 8, 54, "Text",
      CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}]},
  "determinant"->{
    Cell[67828, 2670, 253, 9, 33, "Text",
      CellTags->{"determinant", "Lie matrix"}],
    Cell[80070, 3055, 101, 1, 33, "Text",
      CellTags->"determinant"]},
  "matrix"->{
    Cell[68345, 2691, 189, 3, 54, "Text",
      CellTags->"matrix"]},
  "FirstIntegral[]"->{
    Cell[69078, 2715, 846, 24, 96, "Text",
      CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}]},
  "Integrate[]"->{
    Cell[69078, 2715, 846, 24, 96, "Text",
      CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}]},
  "second-order ODE"->{
    Cell[69078, 2715, 846, 24, 96, "Text",
      CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}]},
  "DSolve[]"->{
    Cell[71009, 2785, 141, 4, 33, "Text",
      CellTags->"DSolve[]"],
    Cell[85660, 3242, 342, 8, 75, "Text",
      CellTags->"DSolve[]"]},
  "higher-order ODE"->{
    Cell[73459, 2868, 429, 6, 96, "Text",
      CellTags->"higher-order ODE"]},
  "fourth-order ODE"->{
    Cell[73922, 2878, 651, 12, 117, "Text",
      CellTags->{"fourth-order ODE", "integrating factor method"}]},
  "integrating factor method"->{
    Cell[73922, 2878, 651, 12, 117, "Text",
      CellTags->{"fourth-order ODE", "integrating factor method"}]},
  "group parameter"->{
    Cell[76058, 2946, 440, 9, 75, "Text",
      CellTags->{
      "symmetry group", "group parameter", "solvable subalgebra"}]},
  "solvable subalgebra"->{
    Cell[76058, 2946, 440, 9, 75, "Text",
      CellTags->{
      "symmetry group", "group parameter", "solvable subalgebra"}]},
  "SolvableAlgebrasOfOrderN[]"->{
    Cell[76523, 2959, 140, 3, 27, "Input",
      CellTags->"SolvableAlgebrasOfOrderN[]"]},
  "subalgebra"->{
    Cell[77323, 2976, 291, 6, 75, "Text",
      CellTags->"subalgebra"],
    Cell[79114, 3024, 146, 4, 33, "Text",
      CellTags->{"Lie matrix", "subalgebra"}]},
  "third-order derivative"->{
    Cell[83555, 3174, 181, 6, 33, "Text",
      CellTags->"third-order derivative"]},
  "second-order derivative"->{
    Cell[84590, 3209, 210, 5, 54, "Text",
      CellTags->"second-order derivative"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Higher order ordinary differential equations", 90629, 3407},
  {"fluid dynamics", 90999, 3414},
  {"elasticity", 91198, 3419},
  {"symbolic solution", 91404, 3424},
  {"symbolic technique producing explicit solutions", 91640, 3429},
  {"Integrating factor method", 91854, 3434},
  {"integrating factor", 91971, 3437},
  {"Lie matrix", 92210, 3443},
  {"higher prolongation", 93476, 3471},
  {"prolongation", 93717, 3477},
  {"determination of the multiplier of adifferential equation", 94217, 3488},
  {"algorithm", 94455, 3494},
  {"higher-order equation", 94893, 3503},
  {"finite symmetry", 95028, 3506},
  {"quadrature method", 95190, 3510},
  {"group theoretic algorithm", 95360, 3514},
  {"Lie algebra", 95516, 3518},
  {"tangent vector", 95654, 3521},
  {"group constant", 95792, 3524},
  {"Lie determinant", 95931, 3527},
  {"first integral", 96153, 3532},
  {"infinitesimals", 96761, 3547},
  {"eq-27", 97156, 3556},
  {"third-order equation", 97265, 3559},
  {"Kamke", 97361, 3562},
  {"necessary number of symmetries", 97536, 3567},
  {"Infinitesimals[]", 97837, 3574},
  {"symmetry group", 97975, 3577},
  {"group constants", 98332, 3585},
  {"order of equation", 98572, 3591},
  {"integrating algorithm", 98816, 3597},
  {"quadratic polynomial", 99059, 3603},
  {"unique solution", 99182, 3606},
  {"radical", 99275, 3609},
  {"hydrodynamic equations", 99377, 3612},
  {"integration process", 99566, 3617},
  {"first integrals", 99751, 3622},
  {"vector field", 99869, 3625},
  {"DeltaMatrix[]", 99988, 3628},
  {"determinant", 100118, 3631},
  {"matrix", 100297, 3636},
  {"FirstIntegral[]", 100390, 3639},
  {"Integrate[]", 100526, 3642},
  {"second-order ODE", 100667, 3645},
  {"DSolve[]", 100800, 3648},
  {"higher-order ODE", 100967, 3653},
  {"fourth-order ODE", 101071, 3656},
  {"integrating factor method", 101217, 3659},
  {"group parameter", 101353, 3662},
  {"solvable subalgebra", 101509, 3666},
  {"SolvableAlgebrasOfOrderN[]", 101672, 3670},
  {"subalgebra", 101781, 3673},
  {"third-order derivative", 101974, 3678},
  {"second-order derivative", 102091, 3681}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 407, 5, 52, "Section",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 64}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Higher order ordinary differential equations"],
Cell[2149, 58, 800, 13, 159, "Text",
  CellTags->{
  "fluid dynamics", "elasticity", "symbolic solution", 
    "symbolic technique producing explicit solutions"}],

Cell[CellGroupData[{
Cell[2974, 75, 96, 1, 49, "Subsection",
  CellTags->"Integrating factor method"],
Cell[3073, 78, 647, 13, 96, "Text",
  CellTags->{
  "integrating factor", "Lie matrix", "higher prolongation", "prolongation", 
    "determination of the multiplier of adifferential equation"}],
Cell[3723, 93, 646, 15, 96, "Text",
  CellTags->{"Lie matrix", "algorithm", "higher-order equation"}],
Cell[4372, 110, 132, 5, 33, "Text"],
Cell[4507, 117, 128, 3, 30, "NumberedEquation"],
Cell[4638, 122, 677, 23, 76, "Text"],
Cell[5318, 147, 141, 3, 30, "NumberedEquation"],
Cell[5462, 152, 214, 8, 33, "Text"],
Cell[5679, 162, 920, 25, 96, "Text",
  CellTags->{
  "finite symmetry", "quadrature method", "group theoretic algorithm"}],
Cell[6602, 189, 708, 22, 45, "ListItem",
  CellTags->{"Lie algebra", "tangent vector", "group constant"}],
Cell[7313, 213, 619, 24, 83, "ListItem"],
Cell[7935, 239, 584, 19, 45, "ListItem",
  CellTags->{"Lie determinant", "first integral"}],
Cell[8522, 260, 1336, 32, 87, "NumberedEquation"],
Cell[9861, 294, 70, 2, 26, "ListItem"],
Cell[9934, 298, 1263, 29, 107, "NumberedEquation"],
Cell[11200, 329, 477, 15, 45, "ListItem",
  CellTags->{"Lie matrix", "Lie determinant"}],
Cell[11680, 346, 828, 17, 92, "NumberedEquation"],
Cell[12511, 365, 883, 31, 45, "ListItem",
  CellTags->{"infinitesimals", "first integral"}],
Cell[13397, 398, 589, 15, 44, "NumberedEquation",
  CellTags->"eq-27"],
Cell[13989, 415, 152, 5, 26, "ListItem"],
Cell[14144, 422, 405, 14, 45, "ListItem"],
Cell[14552, 438, 265, 8, 45, "ListItem"],
Cell[14820, 448, 278, 5, 75, "Text"],
Cell[15101, 455, 29, 0, 33, "Example"],
Cell[15133, 457, 246, 7, 33, "Text",
  CellTags->"third-order equation"],

Cell[CellGroupData[{
Cell[15404, 468, 293, 6, 50, "Input"],
Cell[15700, 476, 739, 23, 37, "Output"]
}, Open  ]],
Cell[16454, 502, 419, 9, 96, "Text",
  CellTags->"Kamke"],

Cell[CellGroupData[{
Cell[16898, 515, 69, 1, 27, "Input"],
Cell[16970, 518, 898, 23, 38, "Output"]
}, Open  ]],
Cell[17883, 544, 564, 13, 96, "Text",
  CellTags->{"necessary number of symmetries", "Infinitesimals[]"}],

Cell[CellGroupData[{
Cell[18472, 561, 173, 3, 46, "Input"],
Cell[18648, 566, 122, 2, 30, "Output"]
}, Open  ]],
Cell[18785, 571, 1021, 26, 138, "Text",
  CellTags->{
  "symmetry group", "group constants", "order of equation", 
    "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],
Cell[19809, 599, 198, 4, 27, "Input"],
Cell[20010, 605, 200, 4, 27, "Input"],
Cell[20213, 611, 200, 4, 27, "Input"],
Cell[20416, 617, 70, 1, 33, "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{
Cell[20511, 622, 340, 8, 70, "Input"],
Cell[20854, 632, 512, 16, 105, "Output"]
}, Open  ]],
Cell[21381, 651, 82, 1, 33, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[21488, 656, 153, 3, 45, "Input"],
Cell[21644, 661, 113, 2, 55, "Output"]
}, Open  ]],
Cell[21772, 666, 486, 14, 75, "Text"],

Cell[CellGroupData[{
Cell[22283, 684, 84, 1, 27, "Input"],
Cell[22370, 687, 834, 19, 103, "Output"]
}, Open  ]],
Cell[23219, 709, 266, 7, 54, "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{
Cell[23510, 720, 131, 3, 27, "Input"],
Cell[23644, 725, 1126, 23, 166, "Output"]
}, Open  ]],
Cell[24785, 751, 163, 4, 33, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[24973, 759, 97, 2, 27, "Input"],
Cell[25073, 763, 863, 19, 107, "Output"]
}, Open  ]],
Cell[25951, 785, 330, 11, 54, "Text"],

Cell[CellGroupData[{
Cell[26306, 800, 80, 1, 27, "Input"],
Cell[26389, 803, 803, 18, 79, "Output"]
}, Open  ]],
Cell[27207, 824, 365, 10, 54, "Text",
  CellTags->{"quadratic polynomial", "Lie matrix"}],

Cell[CellGroupData[{
Cell[27597, 838, 134, 3, 27, "Input"],
Cell[27734, 843, 1015, 17, 191, "Output"]
}, Open  ]],
Cell[28764, 863, 280, 10, 54, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[29069, 877, 98, 2, 27, "Input"],
Cell[29170, 881, 2991, 52, 501, "Output"]
}, Open  ]],
Cell[32176, 936, 272, 7, 54, "Text",
  CellTags->"unique solution"],

Cell[CellGroupData[{
Cell[32473, 947, 79, 1, 27, "Input"],
Cell[32555, 950, 2649, 46, 293, "Output"]
}, Open  ]],
Cell[35219, 999, 632, 22, 75, "Text"],
Cell[35854, 1023, 269, 5, 38, "Input"],

Cell[CellGroupData[{
Cell[36148, 1032, 394, 8, 99, "Input"],
Cell[36545, 1042, 23967, 1399, 178, 10479, 1228, "GraphicsData", \
"PostScript", "Output"]
}, Open  ]],
Cell[60527, 2444, 113, 4, 33, "Text"],
Cell[60643, 2450, 687, 22, 37, "DisplayFormula"],
Cell[61333, 2474, 311, 7, 54, "Text"],
Cell[61647, 2483, 535, 11, 96, "Text",
  CellTags->"radical"],
Cell[62185, 2496, 28, 0, 33, "Example"],
Cell[62216, 2498, 214, 4, 54, "Text"],
Cell[62433, 2504, 205, 5, 29, "NumberedEquation"],
Cell[62641, 2511, 598, 12, 96, "Text",
  CellTags->{
  "hydrodynamic equations", "necessary number of symmetries", 
    "integration process"}],

Cell[CellGroupData[{
Cell[63264, 2527, 318, 7, 45, "Input"],
Cell[63585, 2536, 693, 21, 30, "Output"]
}, Open  ]],
Cell[64293, 2560, 141, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[64459, 2566, 178, 3, 28, "Input"],
Cell[64640, 2571, 239, 5, 64, "Output"]
}, Open  ]],
Cell[64894, 2579, 489, 11, 75, "Text",
  CellTags->{"first integrals", "vector field"}],
Cell[65386, 2592, 198, 4, 27, "Input"],
Cell[65587, 2598, 200, 4, 27, "Input"],
Cell[65790, 2604, 200, 4, 27, "Input"],
Cell[65993, 2610, 98, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[66116, 2616, 209, 4, 27, "Input"],
Cell[66328, 2622, 138, 2, 42, "Output"]
}, Open  ]],
Cell[66481, 2627, 309, 8, 54, "Text",
  CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}],

Cell[CellGroupData[{
Cell[66815, 2639, 175, 3, 45, "Input"],
Cell[66993, 2644, 820, 23, 109, "Output"]
}, Open  ]],
Cell[67828, 2670, 253, 9, 33, "Text",
  CellTags->{"determinant", "Lie matrix"}],

Cell[CellGroupData[{
Cell[68106, 2683, 81, 1, 27, "Input"],
Cell[68190, 2686, 140, 2, 46, "Output"]
}, Open  ]],
Cell[68345, 2691, 189, 3, 54, "Text",
  CellTags->"matrix"],

Cell[CellGroupData[{
Cell[68559, 2698, 121, 3, 27, "Input"],
Cell[68683, 2703, 380, 9, 42, "Output"]
}, Open  ]],
Cell[69078, 2715, 846, 24, 96, "Text",
  CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}],

Cell[CellGroupData[{
Cell[69949, 2743, 99, 2, 27, "Input"],
Cell[70051, 2747, 336, 9, 30, "Output"]
}, Open  ]],
Cell[70402, 2759, 176, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[70603, 2771, 140, 3, 27, "Input"],
Cell[70746, 2776, 248, 6, 30, "Output"]
}, Open  ]],
Cell[71009, 2785, 141, 4, 33, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[71175, 2793, 84, 1, 27, "Input"],
Cell[71262, 2796, 303, 6, 43, "Output"]
}, Open  ]],
Cell[71580, 2805, 132, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[71737, 2812, 67, 1, 27, "Input"],
Cell[71807, 2815, 37, 1, 30, "Output"]
}, Open  ]],
Cell[71859, 2819, 238, 6, 54, "Text"],

Cell[CellGroupData[{
Cell[72122, 2829, 62, 1, 27, "Input"],
Cell[72187, 2832, 1078, 26, 30, "Output"]
}, Open  ]],
Cell[73280, 2861, 176, 5, 33, "Text"],
Cell[73459, 2868, 429, 6, 96, "Text",
  CellTags->"higher-order ODE"],
Cell[73891, 2876, 28, 0, 33, "Example"],
Cell[73922, 2878, 651, 12, 117, "Text",
  CellTags->{"fourth-order ODE", "integrating factor method"}],

Cell[CellGroupData[{
Cell[74598, 2894, 203, 4, 28, "Input"],
Cell[74804, 2900, 103, 2, 30, "Output"]
}, Open  ]],
Cell[74922, 2905, 90, 3, 33, "Text"],
Cell[75015, 2910, 302, 9, 34, "NumberedEquation"],
Cell[75320, 2921, 400, 11, 75, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[75745, 2936, 149, 3, 28, "Input"],
Cell[75897, 2941, 146, 2, 50, "Output"]
}, Open  ]],
Cell[76058, 2946, 440, 9, 75, "Text",
  CellTags->{"symmetry group", "group parameter", "solvable subalgebra"}],

Cell[CellGroupData[{
Cell[76523, 2959, 140, 3, 27, "Input",
  CellTags->"SolvableAlgebrasOfOrderN[]"],
Cell[76666, 2964, 642, 9, 170, "Output"]
}, Open  ]],
Cell[77323, 2976, 291, 6, 75, "Text",
  CellTags->"subalgebra"],

Cell[CellGroupData[{
Cell[77639, 2986, 293, 5, 45, "Input"],
Cell[77935, 2993, 542, 7, 170, "Output"]
}, Open  ]],
Cell[78492, 3003, 350, 8, 75, "Text",
  CellTags->{"infinitesimals", "algorithm"}],

Cell[CellGroupData[{
Cell[78867, 3015, 151, 3, 28, "Input"],
Cell[79021, 3020, 78, 1, 49, "Output"]
}, Open  ]],
Cell[79114, 3024, 146, 4, 33, "Text",
  CellTags->{"Lie matrix", "subalgebra"}],

Cell[CellGroupData[{
Cell[79285, 3032, 219, 4, 45, "Input"],
Cell[79507, 3038, 548, 14, 115, "Output"]
}, Open  ]],
Cell[80070, 3055, 101, 1, 33, "Text",
  CellTags->"determinant"],

Cell[CellGroupData[{
Cell[80196, 3060, 81, 1, 27, "Input"],
Cell[80280, 3063, 66, 1, 42, "Output"]
}, Open  ]],
Cell[80361, 3067, 227, 4, 54, "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{
Cell[80613, 3075, 121, 3, 27, "Input"],
Cell[80737, 3080, 642, 17, 42, "Output"]
}, Open  ]],
Cell[81394, 3100, 80, 1, 33, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[81499, 3105, 121, 3, 27, "Input"],
Cell[81623, 3110, 480, 14, 44, "Output"]
}, Open  ]],
Cell[82118, 3127, 793, 22, 117, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[82936, 3153, 100, 2, 27, "Input"],
Cell[83039, 3157, 501, 14, 42, "Output"]
}, Open  ]],
Cell[83555, 3174, 181, 6, 33, "Text",
  CellTags->"third-order derivative"],

Cell[CellGroupData[{
Cell[83761, 3184, 113, 2, 27, "Input"],
Cell[83877, 3188, 698, 18, 42, "Output"]
}, Open  ]],
Cell[84590, 3209, 210, 5, 54, "Text",
  CellTags->"second-order derivative"],

Cell[CellGroupData[{
Cell[84825, 3218, 86, 1, 27, "Input"],
Cell[84914, 3221, 731, 18, 115, "Output"]
}, Open  ]],
Cell[85660, 3242, 342, 8, 75, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[86027, 3254, 80, 1, 27, "Input"],
Cell[86110, 3257, 635, 16, 115, "Output"]
}, Open  ]],
Cell[86760, 3276, 51, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[86836, 3280, 70, 1, 27, "Input"],
Cell[86909, 3283, 253, 6, 63, "Output"]
}, Open  ]],
Cell[87177, 3292, 145, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[87347, 3301, 70, 1, 27, "Input"],
Cell[87420, 3304, 253, 6, 63, "Output"]
}, Open  ]],
Cell[87688, 3313, 433, 10, 96, "Text",
  CellTags->"Kamke"],

Cell[CellGroupData[{
Cell[88146, 3327, 61, 1, 27, "Input"],
Cell[88210, 3330, 40, 1, 30, "Output"]
}, Open  ]],
Cell[88265, 3334, 129, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[88419, 3341, 61, 1, 27, "Input"],
Cell[88483, 3344, 40, 1, 30, "Output"]
}, Open  ]],
Cell[88538, 3348, 165, 2, 54, "Text"],
Cell[88706, 3352, 147, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

