(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    961412,      41919]*)
(*NotebookOutlinePosition[    982826,      42418]*)
(*  CellTagsIndexPosition[    979761,      42343]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6 Working Examples", "Section",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 47}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Working examples"],

Cell[TextData[{
  "This section contains some working examples to show the application of the \
package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". We discuss the necessary steps for solving some physical and \
mathematical problems. The first example deals with the diffusion equation \
applied to the problem of thermal oscillations on a surface. A second example \
discusses the application of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " in the derivation of symmetries for a model describing a single flux line \
in a superconductor. Several applications from hydrodynamics demonstrate the \
engineering challenge of the symmetry method. The first atomic explosion \
serves to demonstrate the extraordinary success of symmetry analysis for \
estimating unknown quantities from a movie. The formation of droplets is an \
example currently under discussion in industrial applications."
}], "Text",
  CellTags->{
  "solve physical and mathematical problems", "diffusion equation", 
    "thermal oscillations", "single flux line in a superconductor", 
    "hydrodynamics", "first atomic explosion", "symmetry analysis", 
    "formation of droplets", "industrial applications"}],

Cell[CellGroupData[{

Cell["5.6.1 The Diffusion Equation", "Subsection",
  CellTags->"The diffusion equation"],

Cell[TextData[{
  "The diffusion equation is one of the extensively discussed examples in \
symmetry analysis. Since the beginning of the theory, this equation was used \
to demonstrate the usefulness of the symmetry method to derive solutions. ",
  ButtonBox["Lie",
    ButtonData:>{"Literat.nb", "Lie-Engel-1899"},
    ButtonStyle->"Hyperlink"],
  " himself used the diffusion equation as an example to illustrate the \
capabilities of the method. In his work, the diffusion equation is one of the \
equations comprehensively discussed. The diffusion equation is used by many \
other authors to introduce the method and show how the symmetry method can be \
extended in different ways. The diffusion equation here is chosen as a \
reminiscence to the tremendous work of Lie. The example of the diffusion \
equation illustrates how ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " can be exerted to derive the symmetries of this equation. We also will \
show how the gained information can be employed to solve a particular \
problem. The problem we discuss is a boundary value problem concerned with \
the seasonal oscillations of the temperature on the surface of the earth."
}], "Text",
  CellTags->{
  "diffusion equation", "derive the symmetries", "boundary value problem", 
    "seasonal oscillations of the temperature"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"5.6.2 The Earthworm\[CloseCurlyQuote]s New Year Problem"], "Subsection",
  CellTags->"The earthworm's New Year problem"],

Cell[TextData[{
  "This problem is concerned with the propagation of damped temperature waves \
into the earth due to annual temperature variation. This example is discussed \
extensively by ",
  ButtonBox["Bluman and Cole [1974].",
    ButtonData:>{"Literat.nb", "Bum-74"},
    ButtonStyle->"Hyperlink"],
  " Imagine a worm has to decide when he has to celebrate New Year. The only \
indicator of seasonal changes he has is the variation of temperature. Let us \
assume that the worm will celebrate New Year when he measures the lowest \
temperature in the year. The propagation of the seasonal temperature wave the \
worm must follow is described by a diffusion process. The measured quantity \
is the temperature denoted by the variable "
}], "Text",
  CellTags->{"damped temperature waves", "New Year problem"}],

Cell[BoxData[
    \(\(U = u[x, t]; \)\)], "Input"],

Cell[TextData[{
  "The field ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " measures the temperature variation toward the center of the earth ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((x\  > 0)\)\ \)\)]],
  "at a certain time ",
  Cell[BoxData[
      \(TraditionalForm\`\((t > 0)\)\)]],
  ". The diffusion process of heat is governed by the equation"
}], "Text",
  CellTags->"temperature variation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(diffusion = {\[PartialD]\_t U - \[PartialD]\_{x, 2}U}; 
    diffusion // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
A sketch of the physical situation we have in mind is given in the \
following figure:\
\>", "Text",
  ImageMargins->{{Inherited, Inherited}, {5, 0}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.01 -0.5 0.01 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .6 L
0 .6 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
newpath
0 -0.5 1 36 81 arc
s
0 0 1 r
0 -0.5 m
0 -0.5 1 36 81 arc
F
.502 0 1 r
0 -0.5 m
0 -0.5 .98 36 81 arc
F
.502 0 .502 r
0 -0.5 m
0 -0.5 .96 36 81 arc
F
.502 0 .251 r
0 -0.5 m
0 -0.5 .94 36 81 arc
F
1 0 .502 r
0 -0.5 m
0 -0.5 .92 36 81 arc
F
.502 0 0 r
0 -0.5 m
0 -0.5 .9 36 81 arc
F
1 0 0 r
0 -0.5 m
0 -0.5 .88 36 81 arc
F
0 g
.5 0 m
.70711 .20711 L
s
% Start of user PostScript
0 0 70.7107 70.7107 MAarrowhead1
% End of user PostScript
gsave
.74246 .24246 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
1 1 0 r
gsave
.4 .19282 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
(T) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
(3) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .502 0 r
gsave
.75 .36603 -101.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
55.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
55.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(T) show
61.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(2) show
71.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(Cos) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
89.562500 14.437500 moveto
(@) show
95.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(2) show
107.562500 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(p) show
119.625000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(t) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
125.625000 14.437500 moveto
(D) show
139.625000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Math2Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Math2Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Math2Mono
%%DocumentFonts: + font Courier
grestore
1 1 0 r
gsave
.56569 .06569 -69 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
(-) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
(x) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{240, 153.25},
  ImageMargins->{{45.125, 0}, {Inherited, Inherited}},
  ImageRegion->{{-0.095398, 1.20426}, {-0.156627, 1.16954}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000_a000`40O003h00O0WooY7`000<007`0
O000Ag`0?7oo0002OonUO0000`00O01l0017O00kOol0009oojIl0003001l07`004Ml03Yoo`000Woo
Yg`000<007`0O000B7`0>7oo0002OonXO0000`00O01l0018O00gOol0009oojUl0003001l07`004Ql
0003?0moogoo03=oo`000gooZG`000<007`0O000BG`0=7oo0003OonZO0000`00O01l0018O0000g`?
Oomoo`0aOol000=ooj]l0003001l07`004Il00<l0003?0moogoo02moo`000goo[7`000<007`0O000
@g`01S`000=l3gooOol0;Woo0003Oon]O0000`00O01l0012O007?0000g`??0moo`0]Ool000=oojil
0003001l07`0041l00Xl0003?0moogoo02]oo`000goo[g`000<007`0O000?g`02C`00g`?;7oo0004
Oon_O0000`00O01l000mO009?005O0l00c`?Oomoo`0XOol000Aook1l0003001l07`003Yl00Xl00Ml
3`03?0Moogoo02Moo`0017oo/G`000<007`0O000>G`02S`02G`?:7oo0004OonbO0000`00O01l000g
O00:?00:O0l00c`7?0moo`0UOol000Aook=l0003001l07`003Il00Tl00Yl3`@l1bEoo`0017oo]7`0
00<007`0O000=7`02S`02W`?1C`700<l3gooOol08Goo0005OondO0000`00O01l000bO00:?00:O0l7
?0L00c`?Oomoo`0POol000EookEl0003001l07`0031l00Xl00Ul3`/l1b5oo`001Goo]W`000<007`0
O000;W`02S`02W`?2C`713`?7goo0005OongO0001000O01l07`00WoP0W`00WoP9W`02C`02W`?2S`7
1C`?7Woo0005OonhO0001@00O01l07`0On000W`000=oh7`0O00097`02S`02W`?2C`71c`?7Goo0005
OoncO006On001000O01l07`00WoP9W`02S`02W`?2S`72C`?6goo0005OonjO0000`00O01l0002On0U
O00:?00:O0l:?0L:?0l00`0OOomoo`0HOol000IookYl0005001oh7`0O01oh00SO00:?00:O0l:?0L:
?0l3?1lIOol000IookYl009oh09l009oh25l00Xl00Yl3`Xl1`Xl3`Dl7`0301moogoo01Eoo`001Woo
_7`000<007`0O0008G`02c`02W`?2S`72C`?1c`O00<07gooOol057oo0006OonmO0000`00O01l000O
O00;?00:O0l:?0L:?0l9?1lEOol000Iookil0003001l07`001il00Xl00Yl3`Xl1`Xl3`Xl7`807a=o
o`001Woo_g`000<007`0O00077`02S`02W`?2S`72S`?2S`O100O4Woo0007OonoO0000`00O01l000J
O00:?00:O0l:?0L:?0l:?1l601lAOol000Mool1l0003001l07`001Ql00Xl00Yl3`/l1`Tl3`Xl7`T0
7`03001oogoo00aoo`001goo`G`000<007`0O0005W`02S`02W`?2c`72S`?2C`O2P0O3goo0007Ooo2
O0000`00O01l000DO00;?00:O0l:?0L:?0l:?1l901l00`00Oomoo`0=Ool000Mool=l0003001l07`0
019l00/l00Yl3`Xl1`Xl3`Xl7`X07a1oo`001gooa7`000<007`0O00047`02c`02W`?2S`72S`?2S`O
2P0O00<007ooOol03Woo0008Ooo4O0000`00O01l000>O00;?00:O0l:?0L;?0l9?1l:01l00`00Oomo
o`0?Ool000QoolEl0003001l07`000el00Xl00Yl3`Xl1`/l3`Xl7`T07`03001oogoo011oo`0027oo
aW`000<007`0O0002g`02S`02g`?2S`72S`?2S`O2P0O4goo0008Ooo7O0000`00O01l0008O00;?00;
O0l:?0L:?0l:?1l:01l00`00Oomoo`0AOol000QoolQl0003001l07`000Il00/l00Yl3``l1`Tl3`Xl
7`X07`03001oogoo019oo`0027oobG`000<007`0O00017`033`02W`?2c`72C`?2c`O2@0O00<007oo
Ool04goo0008Ooo:O0000`00O01l0002O00<?00:O0l:?0L:?0l;?1l:01lFOol000UoolYl0003001l
07`000/l00]l3`/l1`Xl3`Tl7`/07`03001oogoo01Aoo`002Goobg`000<003`0?0002S`02W`?2c`7
2S`?2S`O2P0O00<007ooOol05Goo0009Ooo;O0000c`0000l0009?00:O0l;?0L:?0l:?1l:01l00`00
Oomoo`0FOol000UoolYl00<l0003000l03`000Dl00]l3`/l1`Xl3`Xl7`/07aUoo`002GoobG`01C`0
00<003`0?00013`02W`?2c`72S`?2S`O2`0O00<007ooOol05goo0009Ooo8O007?0000`00?00l0002
?00;O0l:?0L:?0l;?1l901l2000JOol000YoolIl00Tl0003000l07`?00]l3`Xl1`Xl3`/l7`X07aao
o`002WooaG`02c`000<007`?O0l027`?33`72S`?2S`O2P0O00<007ooOol06Woo000:Ooo4O00<?000
0g`?001l3`08O0l;?0L:?0l:?1l:01l00`00Oomoo`0KOol000YoolAl00Xl00Al3`03001l3g`?00El
3`Xl1`Xl3`/l7`X07`03001oogoo01aoo`002Woo`g`02c`01G`?00<007`?O0l00W`?33`72S`?2S`O
2`0O7goo000:Ooo1O00<?007O0l01000O0ml3g`?2c`72S`?2S`O2`0O00<007ooOol07Goo000;Oono
O00;?00:O0l00`00O0ll1`09?0L;?0l;?1l:01l00`00Oomoo`0NOol000]ookil00`l00Yl3`03?0L0
03`700Pl1`/l3`/l7`X07`03001oogoo01moo`002goo_G`033`02g`?0S`700<003`7?0L01C`733`?
2S`O2`0O8Woo000;OonlO00;?00<O0l4?0L00`00?0Ll1`04?0L;?0l:?1l;01l00`00Oomoo`0POol0
00]ook]l00/l00]l3`Ll1`03000l1c`7008l1`Xl3`/l7`X07`8002=oo`002goo^W`02c`037`?23`7
00<003`7?0l02c`?2S`O2`0O9Goo000;OonhO00<?00<O0l:?0L00`00?0ll3`04?0l00`00?0ll3`02
?0l:?1l;01l00`00Oomoo`0SOol000aookIl00`l00]l3``l1`03?0l003`?00<l3`<0008l3`Xl7`/0
7`03001oogoo02Aoo`0037oo]G`033`02g`?2c`713`?00<003`??0l0100000<l3c`O?1l023`O2`0O
00<007ooOol09Goo000<OondO00<?00;O0l<?0L5?0l7000:?1l:01l00`00Oomoo`0VOol000aook=l
00`l00]l3``l1`Dl3`P000Tl7`X07`03001oogoo02Moo`0037oo/W`033`02g`?33`71C`?2P001S`O
2`0O00<007ooOol0:7oo000<OonaO00;?00<O0l<?0L5?0l<0005?1l:01l00`00Oomoo`0YOol000eo
og=l009oh3Ul00`l00al3`/l1`Pl3`/000@l7`X07`03001oogoo02Yoo`003GooMG`000=oh7`0O000
=G`033`037`?33`72S`?2P000S`O2`0O;Goo000=Oom^O003On03O0000goPO01l000dO00=?00<O0l<
?0L;?0l00c`O0000000700000c`O01l07`0901l00`00Oomoo`0[Ool000eoofml0003On1l07`000=l
0003On1l07`0039l00dl00]l3``l1``l3`@l7`P000X07`03001oogoo02aoo`003GooKg`000Moh7`0
O01l07oPO01oh00cO00=?00<O0l;?0L;?0l7?1l7000901l00`00Oomoo`0]Ool000eoofml0003On1l
07`0009l0003On1l07`0035l00dl00al3`/l1``l3`Tl7`H000H07`80031oo`003GooKg`000=oh7`0
O000=7`03C`037`?33`733`?2c`O00<07`0000000`001@0O<Woo000>Oom^O0000goPO01l000cO00=
?00<O0l<?0L;?0l<?1l301l4000401l00`00Oomoo`0`Ool000ioof]l0004On1l07`0On02O0000goP
O01l000_O00=?00<O0l<?0L;?0l;?1l701l3000201l00`00Oomoo`0aOol000ioof]l00Moh31l00dl
00al3`/l1``l3``l7`P07`80000301l007oo03=oo`003WooX7`03C`03G`?33`72c`?33`O2P0O0P00
=Goo000>OonNO00>?00=O0l<?0L;?0l;?1l;01l00`00Oomoo`0eOol000iooiil00dl00al3``l1``l
3`/l7`/07`03001oogoo03Ioo`003gooW7`03C`02g`?3C`733`?2c`O300O>Goo000?OonJO00=?00=
O0l<?0L<?0l<?1l;01l00`00Oomoo`0gOol000mooiQl00dl00il3``l1``l3``l7`X07`8003Yoo`00
3gooUg`03C`03G`?33`73C`?2c`O2`0O00<007ooOol0>Woo000?OonEO00>?00<O0l=?0L=?0l;?1l;
01l00`00Oomoo`0kOol000mooiAl00hl00el3``l1``l3``l7``07cioo`0047ooTW`03C`03W`?2c`7
3C`?2c`O3@0O00<007ooOol057oo1@008goo000@Oon@O00=?00>O0l=?0L<?0l<?1l;01l2000IOol0
0`00Oomoo`0SOol0011oohml00dl00el3`hl1``l3``l7`/07`03001oogoo01=oo`<000=oo`03001o
ogoo02=oo`0047ooSG`03S`03G`?3C`733`?33`O300O00<007ooOol05Goo00<007ooOol00Woo00<0
07ooOol08goo000@Oon;O00??00=O0l=?0L<?0l<?1l<01l00`00Oomoo`0FOol00`00Oomoo`02Ool0
0`00Oomoo`0SOol0011oohUl00ll00il3`dl1``l3``l7``07`03001oogoo01Moo`04001oogooOol2
000UOol0011oohQl00hl00il3`dl1``l3``l7`d07`03001oogoo01Qoo`03001oogoo02Qoo`004Goo
QW`03S`03W`?3C`733`?3C`O300O00<007ooOol06Goo00<007ooOol0:7oo000AOon5O00=?00?O0l=
?0L<?0l=?1l<01l00`00Oomoo`0GOol01000Oomoo`000Woo00<007ooOol09Goo000AOon3O00>?00>
O0l>?0L<?0l<?1l<01l2000JOol7000WOol0015ooh5l00ll00el3`hl1`dl3``l7``07`03001oogoo
04Qoo`004GooOg`03c`03W`?3C`73S`?33`O300O00<007ooOol0BGoo000AOomnO00>?00?O0l=?0L=
?0l<?1l<01l2001<Ool0019oog]l00ll00ml3`dl1``l3`dl7`d07dioo`004WooNG`03c`03g`?3C`7
3C`?3C`O3@0O00<007ooOol0C7oo000BOomgO00??00?O0l>?0L=?0l<?1l=01l2001?Ool0019oogEl
00ll00ml3`hl1`hl3`dl7``07`03001oogoo04moo`004WooLg`043`03W`?3c`73S`?3C`O300O00<0
07ooOol0D7oo000BOomaO00A?00?O0l>?0L>?0l<?1l<01l2001COol001=oofml010l011l3`dl1`hl
3`dl7``07`03001oogoo05=oo`004gooKG`04C`03g`?3C`73S`?3S`O300O00<007ooOol0E7oo000C
Oom[O00A?00?O0l=?0L??0l=?1l<01l2001GOol001=oofUl014l00ml3`hl1`ll3``l7`d07`03001o
ogoo05Moo`004gooIg`04C`03g`?3c`73S`?3C`O3@0O00<007ooOol0F7oo000COomUO00A?00?O0l@
?0L=?0l>?1l=01l00`00Oomoo`1IOol001=oof=l014l00ml3a0l1`dl3`hl7`h07`03001oogoo05Yo
o`0057ooGg`04S`03g`?43`73c`?3C`O3P0O00<007ooOol0Fgoo000DOomMO00B?00?O0l@?0L@?0l=
?1l=01l2001NOol001Aooe]l018l015l3`ll1`ll3`hl7`d07`03001oogoo05ioo`0057ooFG`04c`0
4G`?3c`73S`?3S`O3P0O00<007ooOol0Ggoo000DOomGO00C?00AO0l??0L>?0l??1l=01l2001ROol0
01AooeEl01<l015l3`ll1`ll3`ll7``07`8006Aoo`005GooD7`05C`04G`?3c`743`?3S`O3@0O00<0
07ooOol0I7oo000EOom>O00E?00AO0l??0L@?0l>?1l>01l00`00Oomoo`1UOol001Eoodal01<l01=l
3`ll1a0l3`hl7`h07`8006Qoo`005GooBW`04c`04g`?3c`743`?3c`O3P0O00<007ooOol0J7oo000E
Oom6O00E?00CO0l??0L@?0l@?1l>01l00`00Oomoo`1YOol001EoodAl01Dl01=l3a0l1a0l3`ll7`h0
7`8006aoo`005Goo@W`05C`04g`?4C`743`?3S`O3P0O0P00KWoo000FOolmO00G?00CO0lA?0L@?0l>
?1l?01l00`00Oomoo`1^Ool001Iooc]l01Dl01El3a4l1a0l3`ll7`l07`03001oogoo06moo`005Woo
=g`05c`04g`?4c`743`?43`O3P0O0P00LWoo000FOoleO00G?00CO0lC?0L@?0l@?1l>01l2001dOol0
01Iooc5l01Tl01=l3a<l1a0l3a0l7`l07`03001oogoo07Aoo`005Woo;G`06C`05G`?4c`743`?43`O
400O00<007ooOol0MGoo000GOolZO00I?00EO0lC?0L@?0lA?1l?01l2001hOol001MoobIl01/l01El
3a<l1a4l3a4l7`h07`8007Yoo`005goo8W`06c`05g`?4c`74S`?43`O3P0O0P00O7oo000GOolNO00M
?00EO0lE?0LB?0l@?1l?01l00`00Oomoo`0UOol30N0TOol20N0YOol20N03Ool001MooaYl01dl01Ml
3a<l1a@l3a0l7a007`03001oogoo02Ioo`030N1oogoo02Aoo`030N1oogoo02Uoo`030N1oogoo005o
o`005goo5W`07c`05g`?4c`753`?43`O400O0P008goo0`7P17oo00<1h7ooOol02goo0`7P17oo107P
0goo1@7P1Goo00@1h7ooOomoo`D1h0Uoo`030N1oogoo00=oo`030N1oogoo00Uoo`<1h0Eoo`030N1o
ogoo005oo`0067oo4G`07c`06G`?4c`753`?43`O400O0P009Woo00<1h7ooOol00goo00<1h7ooOol0
2Woo00D1h7ooOomoo`7P009oo`030N1oogoo009oo`040N1oogoo0N04Ool00`7POomoo`02Ool01@7P
Oomoogoo0N000goo00<1h7ooOol027oo00D1h7ooOomoo`7P00]oo`050N1oogooOol1h004Ool00`7P
Oomoo`01Ool001Qoo`el024l01Ml3aDl1a@l3a0l7a007`8002Qoo`030N1oogoo009oo`030N1oo`7P
00Yoo`030N1oogoo00Eoo`030N1oogoo009oo`030N1oogoo00Eoo`030N1oogoo009oo`030N1oogoo
009oo`030N1oogoo00aoo`040N1oogoo0N0;Ool00`7POomoo`06Ool00`7POomoo`01Ool001Qoo`Ml
02<l01Ul3aDl1a@l3a0l7a007`8002Yoo`030N1oogoo00=oo`030N1oogoo00Uoo`030N1oogoo00Eo
o`030N1oogoo009oo`040N1oogooOol40N05Ool00`7POomoo`03Ool00`7POomoo`0<Ool00`7POol1
h00;Ool00`7POomoo`06Ool00`7POomoo`01Ool001Qoo`03?0Ll03`0028l01al3aDl1a@l3a0l7a40
7`03001oogoo02Yoo`030N1oogoo00moo`030N1oogoo00Eoo`030N1oogoo009oo`040N1oogoo0N04
Ool00`7POomoo`02Ool00`7POomoo`04Ool00`7POomoo`0;Ool00`7POol1h00;Ool00`7POomoo`06
Ool00`7POomoo`01Ool001Qoo`03?0ll03`001hl01]l3aPl1a@l3a4l7a407`03001oogoo02]oo`03
0N1oogoo00moo`030N1oogoo00Ioo`@1h0Aoo`D1h0Aoo`030N1oogoo00Eoo`030N1oogoo00Qoo`L1
h0Qoo`D1h0Eoo`030N1oogoo005oo`006Goo73`07G`?63`753`?4S`O400O0P00:goo00@1h7ooOol1
h09oo`030N1oogoo00eoo`050N1oogooOol1h00DOol01@7POomoogoo0N000goo00<1h7ooOol067oo
00<1h7ooOol01Woo00<1h7ooOol00Goo000IOolH?00MO0lH?0LE?0lB?1lA01l2000]Ool70N0@Ool4
0N0DOol20N03Ool30N0SOol20N03Ool001Uoo`03O0ll03`0014l01ml3aPl1a<l3a@l7a007`8008mo
o`006Goo00=l3c`0?00033`087`?6C`753`?53`O400O0P00TGoo000IOol00c`7?00l0008?00RO0lG
?0LF?0lD?1l@01l2002COol001Uoo`03?0Ll03`0008l02=l3aXl1aHl3a@l7a007`8009Eoo`006Woo
8g`?73`75S`?53`O400O0P00Ugoo000JOolOO0lL?0LH?0lD?1lA01l00`00Oomoo`2GOol001Yooael
3a`l1aPl3a@l7a807`03001oogoo09Qoo`006Woo6G`?7C`75S`?5S`O4`0O0P00Vgoo000JOol00c`7
O0ml3`0AO0lN?0LH?0lD?1lE01l2002MOol001Yoo`03?0Ml3g`?00]l3b0l1aXl3a@l7a@07`800:1o
o`006Woo00<l3g`?O0l01g`?8S`76S`?53`O500O0P00XWoo000KOol2O0lT?0LJ?0lG?1lD01l2002T
Ool001]oob8l1a`l3aLl7a@07`800:Ioo`006goo83`773`?5S`O5@0O0P00Z7oo000KOolL?0LL?0lH
?1lE01l2002ZOol001]ooaLl1all3aHl7aH07`800:eoo`006goo00<l3c`7?0L043`77S`?6C`O5P0O
0P00[goo000LOol;?0LS?0lH?1lE01l2002cOol001aoo`Ll1b<l3aXl7aD07`800;Eoo`0077oo9C`?
6c`O5P0O0P00^7oo000LOolS?0lK?1lF01l2002jOol001aooall3a`l7aL07`800;aoo`0077oo6S`?
7C`O6@0O0P00_Woo000MOolE?0lO?1lI01l20030Ool001eooa0l3all7aT07`800<Eoo`007Goo33`?
8C`O6@0O0P00agoo000MOol5?0lS?1lL01l20039Ool001ioobDl7a/07`800<aoo`007Woo8C`O6`0O
0P00d7oo000NOolL?1lM01l2003COol001iooaPl7ad07`800=Moo`007Woo00<07c`O?1l043`O800O
0P00fGoo000NOol00`0O?1ll7`0;?1lR01l2003LOol001moo`Tl7b807`800>1oo`007goo0S`O900O
0P00iGoo000OOolT01l2003WOol001mooal07`800>aoo`007goo6`0O0P00l7oo000OOolF01l2003e
Ool0021ooa007`800?Yoo`0087oo300O0P00oWoo000POol701l2003oOol4Ool0021oo`800?moo`]o
o`00ogoo;Goo0000\
\>"],
  ImageRangeCache->{{{-28.5625, 360.25}, {220.563, -32.4375}} -> {7.34566, \
34.1219, 0.321495, 0.321495}}],

Cell[TextData[{
  "The constant temperatures ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_3\)]],
  " describe the temperature on the surface and in the interior of the earth \
at a certain depth. The seasonal changes of the temperature near the surface \
are assumed to be ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\ \(cos(2\ \[Pi]t)\)\)]],
  " and are due to radiation changes of the sun. So, besides the diffusion \
equation, the solution of the problem has to satisfy additionally boundary \
conditions. In deriving the solution of this boundary value problem, we have \
to solve the diffusion equation for the given boundary conditions on the \
surface and in the center. Examining the symmetries of the diffusion equation \
allows us to decide how the general equation is transformed and what types of \
transformation are allowed to find the solution. We use the functions ",
  StyleBox["LieEquations[]", "MmaText"],
  " and ",
  StyleBox["LieSolve[]", "MmaText"],
  " of the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " to create another example in our data basis. We start with the creation \
of the information file and carry out the symmetry analysis by applying the \
function ",
  StyleBox["LieSolve[]", "MmaText"],
  ". After the derivation of the symmetries, we will consider the boundary \
values and check the invariance of these conditions under the symmetry \
transformations. In a last step, we will reduce the partial differential \
equation to an ordinary differential equation. The solution of this ODE will \
provide us with the information the worm needs to decide when the turn of the \
year happens."
}], "Text",
  CellTags->{
  "temperature on the surface", "radiation changes", "LieEquations[]", 
    "LieSolve[]", "symmetry analysis", "boundary values"}],

Cell[CellGroupData[{

Cell["5.6.2.1 Symmetry Analysis", "Subsubsection"],

Cell[TextData[{
  "The first step in an automatic symmetry analysis is the collection of all \
the information available on the equation. The package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " offers the function ",
  StyleBox["LieEquations[]", "MmaText"],
  " to collect this information. If you solve a differential equation with \
pencil and paper, you need to know the equation itself. You also have to know \
the names of the dependent variables and the independent variables. \
Sometimes, the equation contains some parameters which you can also save by \
using the function ",
  StyleBox["LieEquations[]", "MmaText"],
  ". If you assemble a greater number of equations in a database, it is good \
practice to supply the files with information on the problem and on the \
sources from which the equation comes. In ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ", all this information is stored in a single file whose name is used by ",
  StyleBox["LieEquation[]", "MmaText"],
  " as first argument. The information we need to handle in the example for \
the earthworm\[CloseCurlyQuote]s New Year problem is given below:"
}], "Text",
  CellTags->{
  "automatic symmetry analysis", "pencil and paper", "equation parameters"}],

Cell[BoxData[
    \(LieEquations["\<diffuw.dgl\>", diffusion, {u}, {x, t}, {}, \n
      \t{"\<The earthworm's New Year problem\>"}, \n
      \t{{"\<G.W. Bluman and J.D. Cole\>"}, \n
        \t\t{"\<Similarity Methods for Differential Equations\>"}, \n
        \t\t{"\<Springer, New York, 1974\>"}, {"\<pp. 233\>"}}]\)], "Input"],

Cell[TextData[{
  "After the completion of these lines, the function ",
  StyleBox["LieEquations[]", "MmaText"],
  " created a file containing the information necessary for the symmetry \
analysis. The content of the file ",
  StyleBox["diffuw.dgl", "MmaText",
    FontSlant->"Italic"],
  " looks like"
}], "Text",
  CellTags->"LieEquations[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(! \(! diffuw . dgl\)\)\)], "Input"],

Cell[BoxData[{
    \(Title\  = \ {"The earthworm's New Year problem"}\), 
    \(Source\  = 
      \ {{"G.W. Bluman and J.D. Cole"}, \ \n
        \ \ \ {"Similarity Methods for Differential Equations"}, \ \n
        \ \ \ {"Springer, New York, 1974"}, \ {"pp. 233"}}\), 
    \(IndepVar\  = \ {x, \ t}\), 
    \(DependVar\  = \ {u}\), 
    \(EqList\  = 
      \ {\(\(Derivative[0, \ 1]\)[u]\)[x, \ t]\  - \ 
          \(\(Derivative[2, \ 0]\)[u]\)[x, \ t]}\), 
    \(SubsList\  = \ {\(\(Derivative[0, \ 1]\)[u]\)[x, \ t]}\), 
    \(ParameterS\  = \ {}\), 
    \(ListXi\  = \ {}\), 
    \(ListPhi\  = \ {}\)}], "Output",
  Evaluatable->False,
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell[TextData[{
  "The symmetries of the diffusion equation are calculated by applying the \
function ",
  StyleBox["LieSolve[]", "MmaText"],
  " to the collected information. The function ",
  StyleBox["LieSolve[]", "MmaText"],
  " exerts the invariance condition based on the prolongation formalism. The \
prolongation of the equation is calculated by using the Fr\[EAcute]chet \
derivative. Knowing the prolongation of the equation, the coefficients of the \
derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " are extracted. The redundant information contained in these equations is \
eliminated in the next step by inserting the diffusion equation itself into \
the prolongation. After the extraction of the coefficients of the \
derivatives, a system of determining equations for the infinitesimals \
results. The determining equations are linear but coupled. In the next step, \
a general canonical representation of these equations is calculated by ",
  StyleBox["LieSolve[]", "MmaText"],
  ". The last calculation step of ",
  StyleBox["LieSolve[]", "MmaText"],
  " solves the general canonical form. The result of this sequence of steps \
is an explicit representation of the infinitesimals for the diffusion \
equation:"
}], "Text",
  CellTags->{
  "LieSolve[]", "prolongation formalism", "invariance condition", 
    "system of determining equations", "general canonical form"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieSolve["\<diffuw.dgl\>"] // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {\(\[Xi]\_1 == k5 - 2\ k2\ t + k6\ x + k4\ t\ x\)},
          {\(\[Xi]\_2 == k3 + t\ \((2\ k6 + k4\ t)\)\)},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                RowBox[{"u", " ", 
                  RowBox[{"(", 
                    RowBox[{"k1", "-", 
                      StyleBox[\(\(k4\ t\)\/2\),
                        ScriptLevel->0], "+", \(k2\ x\), "-", 
                      StyleBox[\(\(k4\ x\^2\)\/4\),
                        ScriptLevel->0]}], ")"}]}], "+", 
                \(\[ScriptCapitalF]\_1\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k5, 
            Times[ -2, k2, t], 
            Times[ k6, x], 
            Times[ k4, t, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k3, 
            Times[ t, 
              Plus[ 
                Times[ 2, k6], 
                Times[ k4, t]]]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ u, 
              Plus[ k1, 
                Times[ 
                  Rational[ -1, 2], k4, t], 
                Times[ k2, x], 
                Times[ 
                  Rational[ -1, 4], k4, 
                  Power[ x, 2]]]], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an infinite dimensional Lie group containing a \
six-dimensional discrete subgroup. The group parameters are denoted by ",
  StyleBox["k1\[Dash]k6",
    FontSlant->"Italic"],
  ". The discrete symmetries serve to construct similarity solutions."
}], "Text",
  CellTags->{
  "infinite-dimensional Lie group", "discrete subgroup", 
    "similarity solution"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.6.2.2. Similarity Solution", "Subsubsection"],

Cell[TextData[
"Knowing the infinitesimals of the diffusion equation, we are ready to solve \
the boundary value problem for the earthworm\[CloseCurlyQuote]s problem. The \
additional condition that the symmetries have to satisfy are confined in the \
side conditions on the surface and in the center of the earth. These boundary \
conditions are"], "Text",
  CellTags->"boundary value problem"],

Cell[CellGroupData[{

Cell[BoxData[
    \(b1 = v[0, t] == T\_2\ Exp[I\ 2\ \[Pi]\ t]\)], "Input"],

Cell[BoxData[
    \(v[0, t] == E\^\(2\ I\ \[Pi]\ t\)\ T\_2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b2 = v[\[Infinity], t] == 0\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"v", "[", 
        RowBox[{
          InterpretationBox["\[Infinity]",
            DirectedInfinity[ 1]], ",", "t"}], "]"}], "==", "0"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Using this complex-valued representation for the temperature, ",
  Cell[BoxData[
      \(TraditionalForm\`u = Re(v)\)]],
  ", we can check the invariance of the boundary conditions by using the \
infinitesimals. The invariance of ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  " implies that"
}], "Text",
  CellTags->{"invariance of the boundary conditions", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((ListXi\[LeftDoubleBracket]1\[RightDoubleBracket] /. x \[Rule] 0)
        \) == 0\)], "Input"],

Cell[BoxData[
    \(k5 - 2\ k2\ t == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "From this relation, it follows that the group constants ",
  StyleBox["k5",
    FontSlant->"Italic"],
  " and",
  StyleBox[" k2 ",
    FontSlant->"Italic"],
  "have to",
  StyleBox[" ",
    FontSlant->"Italic"],
  "vanish. We collect these results in a list of rules:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rule = {k5 \[Rule] 0, k2 \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({k5 \[Rule] 0, k2 \[Rule] 0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The invariance of the first boundary condition ",
  StyleBox["b1",
    FontSlant->"Italic"],
  ", on the other hand, yields the relation"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(equt1 = 
      k1 - \(k4\ t\)\/2 == 
        I\ 2\ \[Pi]\ 
          \((ListXi\[LeftDoubleBracket]2\[RightDoubleBracket] /. x \[Rule] 0)
            \)\)], "Input"],

Cell[BoxData[
    \(k1 - \(k4\ t\)\/2 == 2\ I\ \[Pi]\ \((k3 + t\ \((2\ k6 + k4\ t)\))\)\)], 
  "Output"]
}, Open  ]],

Cell["which has the general solutions", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(res = 
      Reduce[CoefficientList[equt1 /. l_ == r_ \[Rule] l - r, t]\n
          \t == {0, 0, 0}, {k1, k3, k4, k6}]\)], "Input"],

Cell[BoxData[
    \(k1 == 2\ I\ k3\ \[Pi] && k4 == 0 && k6 == 0\)], "Output"]
}, Open  ]],

Cell["\<\
We transform the equations to rules and add it to the list of rules \
for the group constants:\
\>", "Text",
  CellTags->"group constants"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[rule, ToRules[res]]; rule = Flatten[rule]\)], "Input"],

Cell[BoxData[
    \({k5 \[Rule] 0, k2 \[Rule] 0, k1 \[Rule] 2\ I\ k3\ \[Pi], k4 \[Rule] 0, 
      k6 \[Rule] 0}\)], "Output"]
}, Open  ]],

Cell["\<\
The general representation of the infinitesimals for the diffusion \
equation thus reduces to\
\>", "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Infinitesimals = 
      \({ListXi, ListPhi} /. rule\) /. \n
        \t\t{\(free[_]\)[___] \[Rule] 0, u[___] \[Rule] u}\)], "Input"],

Cell[BoxData[
    \({{0, k3}, {2\ I\ k3\ \[Pi]\ u}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The reduction of the original equation follows by applying the function ",
  StyleBox["LieReduction[]", "MmaText"],
  " in the subgroup of the diffusion equation:"
}], "Text",
  Evaluatable->False,
  CellTags->"LieRedunction[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LTF[
        Flatten[LieReduction[diffusion, {u}, {x, t}, \n\t
            Infinitesimals\[LeftDoubleBracket]1\[RightDoubleBracket], 
            Infinitesimals\[LeftDoubleBracket]2\[RightDoubleBracket]]]] /. 
      zeta1 \[Rule] \[Zeta]\_1\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {\(x - \[Zeta]\_1 == 0\)},
          {\(E\^\(\(-2\)\ I\ \[Pi]\ t\)\ u - F\_1 == 0\)},
          {
            \(I\ E\^\(2\ I\ \[Pi]\ t\)\ 
                \((2\ \[Pi]\ F\_1 + I\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\))
                  \) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The similarity variable is ",
  StyleBox["zeta1 = x",
    FontSlant->"Italic"],
  " and the solution has the similarity form"
}], "Text",
  CellTags->"similarity form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SimilaritySolution = 
      u \[Rule] Function[{x, t}, \n\t\t\tExp[I\ 2\ \[Pi]\ t]\ F1[x]]\)], 
  "Input"],

Cell[BoxData[
    \(u \[Rule] Function[{x, t}, Exp[I\ 2\ \[Pi]\ t]\ F1[x]]\)], "Output"]
}, Open  ]],

Cell["\<\
Substituting the similarity solution into the diffusion equation \
gives us\
\>", "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(equat2 = 
      \(Expand[\(diffusion /. SimilaritySolution\)\/Exp[I\ 2\ \[Pi]\ t]]
            \)\[LeftDoubleBracket]1\[RightDoubleBracket] == 0; 
    equat2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(2\ I\ \[Pi]\ F\_1 - \((F\_1)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This second-order equation also contained in the result of ",
  StyleBox["LieReduction[]", "MmaText"],
  " is solved by applying the function ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"LieReduction[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(res2 = Simplify[DSolve[equat2, F1, x]]\)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((E\^\(\((\(-1\) - I)\)\ \@\[Pi]\ #1\)\ C[1] + 
                E\^\(\((1 + I)\)\ \@\[Pi]\ #1\)\ C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Examining the behavior for ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] \[Infinity]\)]],
  ", we find that the second constant of integration ",
  StyleBox["C[2]",
    FontSlant->"Italic"],
  " has to vanish to satisfy the second boundary condition ",
  StyleBox["b2",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(h1 = 
      Factor[Expand[
            Simplify[\n\t\t\t\tTrigToExp[ComplexExpand[F1[x] /. res2]]]] /. \n
          \t\t\t{C[2] \[Rule] 0}]\)], "Input"],

Cell[BoxData[
    \({E\^\(\((\(-1\) - I)\)\ \@\[Pi]\ x\)\ C[1]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing the result with the first boundary condition, we observe that \
the real part of ",
  StyleBox["C[1]",
    FontSlant->"Italic"],
  " is given by ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(h2 = 
      \((h1 /. C[1] \[Rule] T\_2)\)\[LeftDoubleBracket]1
        \[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \(E\^\(\((\(-1\) - I)\)\ \@\[Pi]\ x\)\ T\_2\)], "Output"]
}, Open  ]],

Cell["The complete solution is thus given by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SimSol = SimilaritySolution /. F1[x] \[Rule] h2\)], "Input"],

Cell[BoxData[
    \(u \[Rule] 
      Function[{x, t}, 
        Exp[I\ 2\ \[Pi]\ t]\ \((E\^\(\((\(-1\) - I)\)\ \@\[Pi]\ x\)\ T\_2)\)]
        \)], "Output"]
}, Open  ]],

Cell["After a rearrangement of terms in the exponent,", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      \(u[x, t] /. SimSol\) /. \n\t\t
        c_. \ Exp[a_. \ Complex[d_, e_] + b_. \ Complex[f_, g_]] \[Rule] \n
          \t\t\tc\ Exp[\((a\ d + b\ f)\) + \((a\ e + b\ g)\)\ I]\)], "Input"],

Cell[BoxData[
    \(E\^\(\(-\@\[Pi]\)\ x + I\ \((2\ \[Pi]\ t - \@\[Pi]\ x)\)\)\ T\_2\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Re[sol]\)], "Input"],

Cell[BoxData[
    \(Re[E\^\(\(-\@\[Pi]\)\ x + I\ \((2\ \[Pi]\ t - \@\[Pi]\ x)\)\)\ T\_2]
      \)], "Output"]
}, Open  ]],

Cell["we can extract the real part of the solution by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution = Re[ExpToTrig[sol]] // Simplify\)], "Input"],

Cell[BoxData[
    \(Re[\((
          Cosh[\((1 + I)\)\ 
                \((\((\(-1\) - I)\)\ \[Pi]\ t + 
                    x\ \((Cosh[Log[\[Pi]]\/2] + Sinh[Log[\[Pi]]\/2])\))\)] - 
            Sinh[\((1 + I)\)\ 
                \((\((\(-1\) - I)\)\ \[Pi]\ t + 
                    x\ \((Cosh[Log[\[Pi]]\/2] + Sinh[Log[\[Pi]]\/2])\))\)])
          \)\ T\_2]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The derived solution describes the temperature variation near the surface \
of the earth. The solution indicates that the spatial and temporal \
coordinates are coupled. If now ",
  Cell[BoxData[
      \(TraditionalForm\`t = T\)]],
  " is the New Year of a person on the surface, then an earthworm will \
celebrate New Year at time ",
  Cell[BoxData[
      FormBox[
        RowBox[{"t", " ", "=", 
          RowBox[{"T", "+", 
            StyleBox[" ",
              ScriptLevel->1], 
            StyleBox[
              FormBox[\(\(\@\(1/2 \[Pi]\ \)\) x\_l\),
                "TraditionalForm"],
              ScriptLevel->1]}]}], TraditionalForm]]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\_l\)]],
  " is the depth of the earthworm. The solution in the time and spatial \
coordinate with unique ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  " looks like"
}], "Text",
  CellTags->"temperature variation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[solution /. T\_2 \[Rule] 1, {x, 0, 2}, {t, 0, 1}, \n\t
      PlotRange \[Rule] All, PlotPoints \[Rule] 30, \n\t
      AxesLabel \[Rule] {"\<x\>", "\<t\>", "\<u\>"}, \n\t
      ViewPoint \[Rule] {\(-2.468\), \(-2.587\), 1.256}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .60304 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00421689 1.00422 -0.152798 1.00422 [
[.48417 -0.01255 -2.99423 -9 ]
[.48417 -0.01255 3.00577 0 ]
[.62672 .04935 -9.1611 -9 ]
[.62672 .04935 8.8389 0 ]
[.75605 .10553 -3.10678 -9 ]
[.75605 .10553 2.89322 0 ]
[.87394 .15674 -9.46337 -9 ]
[.87394 .15674 8.53663 0 ]
[.98184 .2036 -3.19751 -9 ]
[.98184 .2036 2.80249 0 ]
[.75382 .04281 -5.17797 -15 ]
[.75382 .04281 4.82203 0 ]
[.48417 -0.01255 -2.99423 -9 ]
[.48417 -0.01255 3.00577 0 ]
[.3756 .03977 -8.84686 -9 ]
[.3756 .03977 9.15314 0 ]
[.27559 .08797 -8.72348 -9 ]
[.27559 .08797 9.27652 0 ]
[.18316 .13252 -8.6109 -9 ]
[.18316 .13252 9.3891 0 ]
[.0975 .17381 -8.50778 -9 ]
[.0975 .17381 9.49222 0 ]
[.01787 .21218 -2.80432 -9 ]
[.01787 .21218 3.19568 0 ]
[.23081 .04795 -4.81441 -15 ]
[.23081 .04795 5.18559 0 ]
[.99492 .21749 0 -6.00518 ]
[.99492 .21749 12 2.99482 ]
[.99903 .279 0 -5.91574 ]
[.99903 .279 24 3.08426 ]
[1.0032 .34155 0 -5.82504 ]
[1.0032 .34155 6 3.17496 ]
[1.00744 .40515 0 -5.73304 ]
[1.00744 .40515 18 3.26696 ]
[1.01174 .46985 0 -5.63972 ]
[1.01174 .46985 6 3.36028 ]
[1.06343 .3242 0 -9.7075 ]
[1.06343 .3242 10 5.2925 ]
[ 0 0 0 0 ]
[ 1 .60304 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.48415 0 m
.98267 .21613 L
s
.48415 0 m
.48414 .00628 L
s
[(0)] .48417 -0.01255 -0.00192 1 Mshowa
.62694 .06191 m
.62705 .06818 L
s
[(0.5)] .62672 .04935 .0179 1 Mshowa
.7565 .11808 m
.75672 .12435 L
s
[(1)] .75605 .10553 .03559 1 Mshowa
.87459 .16927 m
.87491 .17554 L
s
[(1.5)] .87394 .15674 .05149 1 Mshowa
.98267 .21613 m
.98308 .22239 L
s
[(2)] .98184 .2036 .06584 1 Mshowa
.125 Mabswid
.51386 .01288 m
.51387 .01665 L
s
.54298 .02551 m
.543 .02927 L
s
.57152 .03788 m
.57156 .04164 L
s
.5995 .05001 m
.59956 .05378 L
s
.65385 .07357 m
.65393 .07734 L
s
.68025 .08502 m
.68034 .08878 L
s
.70614 .09624 m
.70625 .10001 L
s
.73156 .10726 m
.73168 .11103 L
s
.78099 .12869 m
.78113 .13245 L
s
.80503 .13911 m
.80518 .14288 L
s
.82863 .14935 m
.8288 .15311 L
s
.85182 .1594 m
.852 .16316 L
s
.89696 .17897 m
.89717 .18273 L
s
.91895 .1885 m
.91916 .19226 L
s
.94055 .19787 m
.94078 .20163 L
s
.96179 .20708 m
.96203 .21083 L
s
gsave
.75382 .04281 -66.178 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.48415 0 m
.01705 .22471 L
s
.48415 0 m
.48414 .00628 L
s
[(0)] .48417 -0.01255 -0.00192 1 Mshowa
.37539 .05232 m
.37528 .0586 L
s
[(0.2)] .3756 .03977 -0.01702 1 Mshowa
.2752 .10052 m
.27501 .10679 L
s
[(0.4)] .27559 .08797 -0.03072 1 Mshowa
.18262 .14506 m
.18235 .15133 L
s
[(0.6)] .18316 .13252 -0.04323 1 Mshowa
.09681 .18634 m
.09647 .19261 L
s
[(0.8)] .0975 .17381 -0.05469 1 Mshowa
.01705 .22471 m
.01664 .23097 L
s
[(1)] .01787 .21218 -0.06523 1 Mshowa
.125 Mabswid
.45609 .0135 m
.45607 .01726 L
s
.42863 .02671 m
.42859 .03048 L
s
.40173 .03965 m
.40168 .04341 L
s
.34958 .06474 m
.3495 .0685 L
s
.32429 .07691 m
.3242 .08067 L
s
.2995 .08883 m
.2994 .09259 L
s
.25138 .11198 m
.25125 .11574 L
s
.22802 .12322 m
.22788 .12698 L
s
.2051 .13424 m
.20495 .13801 L
s
.16056 .15567 m
.16039 .15943 L
s
.13892 .16608 m
.13873 .16984 L
s
.11767 .1763 m
.11747 .18007 L
s
.07633 .19619 m
.07611 .19995 L
s
.05621 .20587 m
.05599 .20963 L
s
.03646 .21537 m
.03622 .21913 L
s
gsave
.23081 .04795 -65.8144 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.98267 .21613 m
1 .47942 L
s
.98302 .22147 m
.97707 .22346 L
s
[(-1)] .99492 .21749 -1 .33448 Mshowa
.98705 .28277 m
.98107 .28465 L
s
[(-0.5)] .99903 .279 -1 .31461 Mshowa
.99116 .34509 m
.98514 .34687 L
s
[(0)] 1.0032 .34155 -1 .29445 Mshowa
.99533 .40847 m
.98928 .41013 L
s
[(0.5)] 1.00744 .40515 -1 .27401 Mshowa
.99957 .47293 m
.99349 .47447 L
s
[(1)] 1.01174 .46985 -1 .25327 Mshowa
.125 Mabswid
.98382 .23365 m
.98024 .23483 L
s
.98462 .24587 m
.98104 .24704 L
s
.98543 .25813 m
.98185 .25928 L
s
.98624 .27043 m
.98265 .27157 L
s
.98787 .29515 m
.98427 .29627 L
s
.98869 .30757 m
.98509 .30868 L
s
.98951 .32004 m
.9859 .32113 L
s
.99033 .33254 m
.98672 .33362 L
s
.99199 .35768 m
.98837 .35873 L
s
.99282 .37032 m
.9892 .37135 L
s
.99365 .38299 m
.99003 .38402 L
s
.99449 .39571 m
.99086 .39672 L
s
.99617 .42128 m
.99254 .42226 L
s
.99702 .43413 m
.99338 .43509 L
s
.99787 .44702 m
.99422 .44797 L
s
.99872 .45995 m
.99507 .46089 L
s
gsave
1.06343 .3242 -61 -13.7075 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.48415 0 m
.48355 .31002 L
s
.48355 .31002 m
0 .4861 L
s
0 .4861 m
.01705 .22471 L
s
.01705 .22471 m
.48415 0 L
s
.98267 .21613 m
.50758 .37586 L
s
.50758 .37586 m
.50787 .60304 L
s
.50787 .60304 m
1 .47942 L
s
1 .47942 m
.98267 .21613 L
s
.48415 0 m
.48355 .31002 L
s
.48355 .31002 m
1 .47942 L
s
1 .47942 m
.98267 .21613 L
s
.98267 .21613 m
.48415 0 L
s
.01705 .22471 m
.50758 .37586 L
s
.50758 .37586 m
.50787 .60304 L
s
.50787 .60304 m
0 .4861 L
s
0 .4861 m
.01705 .22471 L
s
0 0 m
1 0 L
1 .60304 L
0 .60304 L
closepath
clip
newpath
.5 Mabswid
.559 .795 .987 r
.50714 .4761 .49296 .48004 .50772 .48456 .52191 .4807 Metetra
.562 .794 .986 r
.49222 .47139 .47805 .47545 .49296 .48004 .50714 .4761 Metetra
.566 .794 .985 r
.47715 .4666 .46299 .47079 .47805 .47545 .49222 .47139 Metetra
.571 .794 .983 r
.46193 .46172 .44778 .46607 .46299 .47079 .47715 .4666 Metetra
.577 .794 .981 r
.44655 .45678 .43241 .46133 .44778 .46607 .46193 .46172 Metetra
.584 .794 .979 r
.43101 .45178 .41688 .45657 .43241 .46133 .44655 .45678 Metetra
.593 .796 .977 r
.41532 .44675 .4012 .45183 .41688 .45657 .43101 .45178 Metetra
.602 .797 .974 r
.39946 .44172 .38535 .44714 .4012 .45183 .41532 .44675 Metetra
.612 .799 .971 r
.38343 .43674 .36933 .44254 .38535 .44714 .39946 .44172 Metetra
.624 .802 .968 r
.36724 .43184 .35314 .43808 .36933 .44254 .38343 .43674 Metetra
.636 .806 .964 r
.35087 .42707 .33677 .43382 .35314 .43808 .36724 .43184 Metetra
.649 .81 .961 r
.33431 .42251 .32022 .42983 .33677 .43382 .35087 .42707 Metetra
.663 .815 .956 r
.31757 .41823 .30348 .42616 .32022 .42983 .33431 .42251 Metetra
.678 .821 .952 r
.30064 .4143 .28654 .42291 .30348 .42616 .31757 .41823 Metetra
.693 .828 .948 r
.2835 .41082 .26939 .42015 .28654 .42291 .30064 .4143 Metetra
.708 .836 .943 r
.26615 .4079 .25203 .41799 .26939 .42015 .2835 .41082 Metetra
.723 .845 .939 r
.24858 .40565 .23444 .41652 .25203 .41799 .26615 .4079 Metetra
.738 .855 .935 r
.23077 .40418 .21661 .41585 .23444 .41652 .24858 .40565 Metetra
.753 .866 .931 r
.21271 .40362 .19852 .41607 .21661 .41585 .23077 .40418 Metetra
.767 .88 .928 r
.19438 .40411 .18017 .41728 .19852 .41607 .21271 .40362 Metetra
.779 .894 .925 r
.17577 .40576 .16153 .41958 .18017 .41728 .19438 .40411 Metetra
.79 .911 .923 r
.15686 .40871 .14259 .42303 .16153 .41958 .17577 .40576 Metetra
.798 .93 .92 r
.13762 .41307 .12333 .42771 .14259 .42303 .15686 .40871 Metetra
.801 .951 .917 r
.11804 .41893 .10374 .43363 .12333 .42771 .13762 .41307 Metetra
.795 .972 .911 r
.09809 .42636 .0838 .44079 .10374 .43363 .11804 .41893 Metetra
.769 .988 .895 r
.07776 .43539 .06351 .44914 .0838 .44079 .09809 .42636 Metetra
.706 .985 .856 r
.05703 .44602 .04285 .45854 .06351 .44914 .07776 .43539 Metetra
.569 .927 .759 r
.03589 .45814 .02181 .46881 .04285 .45854 .05703 .44602 Metetra
.01432 .47159 .00042 .47966 .02181 .46881 .03589 .45814 Metetra
.553 .794 .988 r
.52147 .47226 .50714 .4761 .52191 .4807 .53625 .47692 Metetra
.555 .792 .987 r
.50654 .46747 .49222 .47139 .50714 .4761 .52147 .47226 Metetra
.558 .791 .986 r
.49146 .46258 .47715 .4666 .49222 .47139 .50654 .46747 Metetra
.562 .791 .985 r
.47623 .45757 .46193 .46172 .47715 .4666 .49146 .46258 Metetra
.567 .79 .983 r
.46084 .45245 .44655 .45678 .46193 .46172 .47623 .45757 Metetra
.574 .79 .981 r
.4453 .44724 .43101 .45178 .44655 .45678 .46084 .45245 Metetra
.581 .79 .979 r
.42959 .44196 .41532 .44675 .43101 .45178 .4453 .44724 Metetra
.59 .791 .976 r
.41372 .43663 .39946 .44172 .41532 .44675 .42959 .44196 Metetra
.6 .793 .973 r
.39768 .43128 .38343 .43674 .39946 .44172 .41372 .43663 Metetra
.611 .795 .969 r
.38148 .42595 .36724 .43184 .38343 .43674 .39768 .43128 Metetra
.624 .798 .966 r
.3651 .4207 .35087 .42707 .36724 .43184 .38148 .42595 Metetra
.637 .801 .961 r
.34855 .41557 .33431 .42251 .35087 .42707 .3651 .4207 Metetra
.652 .805 .957 r
.33181 .41065 .31757 .41823 .33431 .42251 .34855 .41557 Metetra
.667 .81 .952 r
.31488 .40601 .30064 .4143 .31757 .41823 .33181 .41065 Metetra
.683 .816 .946 r
.29775 .40175 .2835 .41082 .30064 .4143 .31488 .40601 Metetra
.7 .823 .941 r
.28041 .39797 .26615 .4079 .2835 .41082 .29775 .40175 Metetra
.717 .831 .935 r
.26286 .39481 .24858 .40565 .26615 .4079 .28041 .39797 Metetra
.734 .839 .93 r
.24507 .39238 .23077 .40418 .24858 .40565 .26286 .39481 Metetra
.75 .849 .924 r
.22704 .39084 .21271 .40362 .23077 .40418 .24507 .39238 Metetra
.767 .861 .919 r
.20875 .39034 .19438 .40411 .21271 .40362 .22704 .39084 Metetra
.783 .874 .914 r
.19018 .39103 .17577 .40576 .19438 .40411 .20875 .39034 Metetra
.799 .888 .909 r
.17131 .39309 .15686 .40871 .17577 .40576 .19018 .39103 Metetra
.813 .905 .905 r
.15211 .39668 .13762 .41307 .15686 .40871 .17131 .39309 Metetra
.825 .924 .9 r
.13257 .40195 .11804 .41893 .13762 .41307 .15211 .39668 Metetra
.834 .945 .895 r
.11266 .40905 .09809 .42636 .11804 .41893 .13257 .40195 Metetra
.835 .968 .887 r
.09234 .4181 .07776 .43539 .09809 .42636 .11266 .40905 Metetra
.824 .989 .873 r
.0716 .42918 .05703 .44602 .07776 .43539 .09234 .4181 Metetra
.784 .998 .839 r
.05041 .44232 .03589 .45814 .05703 .44602 .0716 .42918 Metetra
.684 .968 .761 r
.02875 .45749 .01432 .47159 .03589 .45814 .05041 .44232 Metetra
.547 .793 .99 r
.53596 .4685 .52147 .47226 .53625 .47692 .55075 .4732 Metetra
.548 .791 .989 r
.52102 .46367 .50654 .46747 .52147 .47226 .53596 .4685 Metetra
.55 .79 .988 r
.50594 .4587 .49146 .46258 .50654 .46747 .52102 .46367 Metetra
.553 .788 .986 r
.49069 .45359 .47623 .45757 .49146 .46258 .50594 .4587 Metetra
.557 .787 .985 r
.47529 .44835 .46084 .45245 .47623 .45757 .49069 .45359 Metetra
.562 .786 .983 r
.45973 .44298 .4453 .44724 .46084 .45245 .47529 .44835 Metetra
.569 .786 .981 r
.44402 .43748 .42959 .44196 .4453 .44724 .45973 .44298 Metetra
.577 .786 .978 r
.42813 .43188 .41372 .43663 .42959 .44196 .44402 .43748 Metetra
.586 .786 .975 r
.41209 .42621 .39768 .43128 .41372 .43663 .42813 .43188 Metetra
.597 .788 .972 r
.39587 .42049 .38148 .42595 .39768 .43128 .41209 .42621 Metetra
.609 .789 .968 r
.37949 .41477 .3651 .4207 .38148 .42595 .39587 .42049 Metetra
.623 .792 .963 r
.36292 .4091 .34855 .41557 .3651 .4207 .37949 .41477 Metetra
.637 .795 .958 r
.34618 .40355 .33181 .41065 .34855 .41557 .36292 .4091 Metetra
.653 .799 .953 r
.32925 .39819 .31488 .40601 .33181 .41065 .34618 .40355 Metetra
.67 .804 .947 r
.31213 .39311 .29775 .40175 .31488 .40601 .32925 .39819 Metetra
.687 .81 .941 r
.29481 .38843 .28041 .39797 .29775 .40175 .31213 .39311 Metetra
.705 .816 .934 r
.27727 .38427 .26286 .39481 .28041 .39797 .29481 .38843 Metetra
.724 .824 .927 r
.25951 .38076 .24507 .39238 .26286 .39481 .27727 .38427 Metetra
.742 .832 .92 r
.24152 .37807 .22704 .39084 .24507 .39238 .25951 .38076 Metetra
.761 .842 .913 r
.22327 .37636 .20875 .39034 .22704 .39084 .24152 .37807 Metetra
.779 .853 .906 r
.20474 .37582 .19018 .39103 .20875 .39034 .22327 .37636 Metetra
.798 .866 .899 r
.18593 .37665 .17131 .39309 .19018 .39103 .20474 .37582 Metetra
.815 .88 .892 r
.16679 .37905 .15211 .39668 .17131 .39309 .18593 .37665 Metetra
.832 .896 .886 r
.14732 .38324 .13257 .40195 .15211 .39668 .16679 .37905 Metetra
.847 .914 .879 r
.12746 .38942 .11266 .40905 .13257 .40195 .14732 .38324 Metetra
.86 .935 .872 r
.10721 .39779 .09234 .4181 .11266 .40905 .12746 .38942 Metetra
.868 .957 .862 r
.08651 .40854 .0716 .42918 .09234 .4181 .10721 .39779 Metetra
.867 .98 .847 r
.06534 .4218 .05041 .44232 .0716 .42918 .08651 .40854 Metetra
.846 .998 .818 r
.04367 .4377 .02875 .45749 .05041 .44232 .06534 .4218 Metetra
.542 .793 .991 r
.55061 .46481 .53596 .4685 .55075 .4732 .5654 .46951 Metetra
.542 .791 .99 r
.53567 .45996 .52102 .46367 .53596 .4685 .55061 .46481 Metetra
.543 .789 .989 r
.52057 .45495 .50594 .4587 .52102 .46367 .53567 .45996 Metetra
.545 .787 .988 r
.50532 .44979 .49069 .45359 .50594 .4587 .52057 .45495 Metetra
.547 .785 .987 r
.4899 .44446 .47529 .44835 .49069 .45359 .50532 .44979 Metetra
.551 .783 .985 r
.47433 .43896 .45973 .44298 .47529 .44835 .4899 .44446 Metetra
.556 .782 .983 r
.4586 .43331 .44402 .43748 .45973 .44298 .47433 .43896 Metetra
.563 .781 .981 r
.44271 .4275 .42813 .43188 .44402 .43748 .4586 .43331 Metetra
.571 .781 .978 r
.42665 .42155 .41209 .42621 .42813 .43188 .44271 .4275 Metetra
.581 .781 .974 r
.41042 .41549 .39587 .42049 .41209 .42621 .42665 .42155 Metetra
.592 .782 .97 r
.39402 .40936 .37949 .41477 .39587 .42049 .41042 .41549 Metetra
.605 .783 .966 r
.37745 .40319 .36292 .4091 .37949 .41477 .39402 .40936 Metetra
.62 .785 .961 r
.3607 .39704 .34618 .40355 .36292 .4091 .37745 .40319 Metetra
.636 .788 .955 r
.34377 .39098 .32925 .39819 .34618 .40355 .3607 .39704 Metetra
.653 .792 .949 r
.32665 .38509 .31213 .39311 .32925 .39819 .34377 .39098 Metetra
.671 .797 .942 r
.30934 .37949 .29481 .38843 .31213 .39311 .32665 .38509 Metetra
.69 .802 .934 r
.29181 .37429 .27727 .38427 .29481 .38843 .30934 .37949 Metetra
.709 .808 .927 r
.27408 .36963 .25951 .38076 .27727 .38427 .29181 .37429 Metetra
.729 .816 .918 r
.25611 .36567 .24152 .37807 .25951 .38076 .27408 .36963 Metetra
.749 .824 .91 r
.23791 .36259 .22327 .37636 .24152 .37807 .25611 .36567 Metetra
.769 .833 .901 r
.21944 .36059 .20474 .37582 .22327 .37636 .23791 .36259 Metetra
.789 .844 .893 r
.20069 .3599 .18593 .37665 .20474 .37582 .21944 .36059 Metetra
.809 .856 .884 r
.18163 .36075 .16679 .37905 .18593 .37665 .20069 .3599 Metetra
.828 .869 .875 r
.16223 .3634 .14732 .38324 .16679 .37905 .18163 .36075 Metetra
.847 .884 .867 r
.14247 .3681 .12746 .38942 .14732 .38324 .16223 .3634 Metetra
.864 .901 .858 r
.1223 .37515 .10721 .39779 .12746 .38942 .14247 .3681 Metetra
.88 .921 .848 r
.1017 .38479 .08651 .40854 .10721 .39779 .1223 .37515 Metetra
.893 .942 .837 r
.08061 .39729 .06534 .4218 .08651 .40854 .1017 .38479 Metetra
.899 .965 .821 r
.059 .41288 .04367 .4377 .06534 .4218 .08061 .39729 Metetra
.539 .794 .992 r
.56542 .46114 .55061 .46481 .5654 .46951 .58022 .46582 Metetra
.537 .791 .991 r
.55047 .4563 .53567 .45996 .55061 .46481 .56542 .46114 Metetra
.537 .789 .991 r
.53537 .4513 .52057 .45495 .53567 .45996 .55047 .4563 Metetra
.537 .786 .99 r
.5201 .44612 .50532 .44979 .52057 .45495 .53537 .4513 Metetra
.538 .784 .989 r
.50468 .44075 .4899 .44446 .50532 .44979 .5201 .44612 Metetra
.54 .781 .987 r
.4891 .43518 .47433 .43896 .4899 .44446 .50468 .44075 Metetra
.543 .779 .985 r
.47335 .42942 .4586 .43331 .47433 .43896 .4891 .43518 Metetra
.548 .777 .983 r
.45745 .42345 .44271 .4275 .4586 .43331 .47335 .42942 Metetra
.555 .775 .981 r
.44137 .4173 .42665 .42155 .44271 .4275 .45745 .42345 Metetra
.563 .775 .978 r
.42513 .41097 .41042 .41549 .42665 .42155 .44137 .4173 Metetra
.574 .774 .974 r
.40872 .40448 .39402 .40936 .41042 .41549 .42513 .41097 Metetra
.586 .775 .969 r
.39213 .39788 .37745 .40319 .39402 .40936 .40872 .40448 Metetra
.6 .776 .964 r
.37537 .39119 .3607 .39704 .37745 .40319 .39213 .39788 Metetra
.615 .777 .959 r
.35844 .38449 .34377 .39098 .3607 .39704 .37537 .39119 Metetra
.632 .78 .952 r
.34131 .37784 .32665 .38509 .34377 .39098 .35844 .38449 Metetra
.651 .784 .945 r
.324 .37134 .30934 .37949 .32665 .38509 .34131 .37784 Metetra
.67 .788 .937 r
.30649 .3651 .29181 .37429 .30934 .37949 .324 .37134 Metetra
.691 .793 .928 r
.28877 .35925 .27408 .36963 .29181 .37429 .30649 .3651 Metetra
.712 .799 .919 r
.27084 .35396 .25611 .36567 .27408 .36963 .28877 .35925 Metetra
.733 .806 .91 r
.25267 .34941 .23791 .36259 .25611 .36567 .27084 .35396 Metetra
.754 .814 .9 r
.23425 .3458 .21944 .36059 .23791 .36259 .25267 .34941 Metetra
.776 .823 .889 r
.21557 .34336 .20069 .3599 .21944 .36059 .23425 .3458 Metetra
.797 .833 .879 r
.19659 .34236 .18163 .36075 .20069 .3599 .21557 .34336 Metetra
.818 .844 .869 r
.17729 .34309 .16223 .3634 .18163 .36075 .19659 .34236 Metetra
.838 .856 .858 r
.15763 .34585 .14247 .3681 .16223 .3634 .17729 .34309 Metetra
.858 .87 .848 r
.13759 .35096 .1223 .37515 .14247 .3681 .15763 .34585 Metetra
.877 .886 .837 r
.11711 .35878 .1017 .38479 .1223 .37515 .13759 .35096 Metetra
.894 .904 .826 r
.09615 .36965 .08061 .39729 .1017 .38479 .11711 .35878 Metetra
.91 .924 .812 r
.07467 .38391 .059 .41288 .08061 .39729 .09615 .36965 Metetra
.536 .795 .993 r
.5804 .45747 .56542 .46114 .58022 .46582 .5952 .46211 Metetra
.533 .792 .992 r
.56545 .45267 .55047 .4563 .56542 .46114 .5804 .45747 Metetra
.531 .789 .992 r
.55033 .4477 .53537 .4513 .55047 .4563 .56545 .45267 Metetra
.53 .786 .991 r
.53506 .44254 .5201 .44612 .53537 .4513 .55033 .4477 Metetra
.529 .783 .99 r
.51963 .43717 .50468 .44075 .5201 .44612 .53506 .44254 Metetra
.529 .78 .989 r
.50403 .43159 .4891 .43518 .50468 .44075 .51963 .43717 Metetra
.531 .777 .988 r
.48828 .42578 .47335 .42942 .4891 .43518 .50403 .43159 Metetra
.534 .774 .986 r
.47235 .41973 .45745 .42345 .47335 .42942 .48828 .42578 Metetra
.539 .771 .984 r
.45626 .41344 .44137 .4173 .45745 .42345 .47235 .41973 Metetra
.545 .769 .981 r
.44 .40691 .42513 .41097 .44137 .4173 .45626 .41344 Metetra
.554 .767 .977 r
.42358 .40015 .40872 .40448 .42513 .41097 .44 .40691 Metetra
.564 .767 .973 r
.40698 .39319 .39213 .39788 .40872 .40448 .42358 .40015 Metetra
.577 .766 .969 r
.3902 .38606 .37537 .39119 .39213 .39788 .40698 .39319 Metetra
.592 .767 .963 r
.37325 .37879 .35844 .38449 .37537 .39119 .3902 .38606 Metetra
.608 .768 .956 r
.35612 .37144 .34131 .37784 .35844 .38449 .37325 .37879 Metetra
.627 .771 .949 r
.33881 .36411 .324 .37134 .34131 .37784 .35612 .37144 Metetra
.647 .774 .941 r
.3213 .35688 .30649 .3651 .324 .37134 .33881 .36411 Metetra
.668 .778 .932 r
.30359 .34988 .28877 .35925 .30649 .3651 .3213 .35688 Metetra
.689 .783 .922 r
.28568 .34326 .27084 .35396 .28877 .35925 .30359 .34988 Metetra
.712 .789 .912 r
.26755 .33719 .25267 .34941 .27084 .35396 .28568 .34326 Metetra
.734 .795 .901 r
.24918 .33187 .23425 .3458 .25267 .34941 .26755 .33719 Metetra
.757 .803 .89 r
.23055 .32755 .21557 .34336 .23425 .3458 .24918 .33187 Metetra
.78 .811 .878 r
.21165 .3245 .19659 .34236 .21557 .34336 .23055 .32755 Metetra
.802 .821 .866 r
.19245 .323 .17729 .34309 .19659 .34236 .21165 .3245 Metetra
.823 .831 .854 r
.17292 .32342 .15763 .34585 .17729 .34309 .19245 .323 Metetra
.845 .842 .842 r
.15301 .3261 .13759 .35096 .15763 .34585 .17292 .32342 Metetra
.865 .855 .83 r
.13269 .33146 .11711 .35878 .13759 .35096 .15301 .3261 Metetra
.885 .87 .818 r
.1119 .33991 .09615 .36965 .11711 .35878 .13269 .33146 Metetra
.904 .886 .804 r
.0906 .3519 .07467 .38391 .09615 .36965 .1119 .33991 Metetra
.535 .797 .994 r
.59555 .45376 .5804 .45747 .5952 .46211 .61035 .45833 Metetra
.531 .794 .993 r
.58059 .44902 .56545 .45267 .5804 .45747 .59555 .45376 Metetra
.528 .791 .993 r
.56547 .44411 .55033 .4477 .56545 .45267 .58059 .44902 Metetra
.525 .787 .993 r
.55019 .43901 .53506 .44254 .55033 .4477 .56547 .44411 Metetra
.522 .784 .992 r
.53475 .43369 .51963 .43717 .53506 .44254 .55019 .43901 Metetra
.521 .78 .991 r
.51914 .42814 .50403 .43159 .51963 .43717 .53475 .43369 Metetra
.52 .776 .99 r
.50337 .42234 .48828 .42578 .50403 .43159 .51914 .42814 Metetra
.521 .772 .988 r
.48743 .41627 .47235 .41973 .48828 .42578 .50337 .42234 Metetra
.523 .768 .986 r
.47133 .40992 .45626 .41344 .47235 .41973 .48743 .41627 Metetra
.527 .765 .984 r
.45505 .40328 .44 .40691 .45626 .41344 .47133 .40992 Metetra
.533 .762 .981 r
.43861 .39635 .42358 .40015 .44 .40691 .45505 .40328 Metetra
.542 .759 .977 r
.42199 .38913 .40698 .39319 .42358 .40015 .43861 .39635 Metetra
.552 .758 .973 r
.4052 .38164 .3902 .38606 .40698 .39319 .42199 .38913 Metetra
.566 .757 .968 r
.38823 .37391 .37325 .37879 .3902 .38606 .4052 .38164 Metetra
.581 .757 .962 r
.37109 .36598 .35612 .37144 .37325 .37879 .38823 .37391 Metetra
.599 .758 .955 r
.35376 .35792 .33881 .36411 .35612 .37144 .37109 .36598 Metetra
.619 .76 .946 r
.33625 .34979 .3213 .35688 .33881 .36411 .35376 .35792 Metetra
.64 .763 .937 r
.31855 .34171 .30359 .34988 .3213 .35688 .33625 .34979 Metetra
.662 .767 .927 r
.30065 .33381 .28568 .34326 .30359 .34988 .31855 .34171 Metetra
.686 .771 .916 r
.28254 .32625 .26755 .33719 .28568 .34326 .30065 .33381 Metetra
.71 .777 .905 r
.26421 .31922 .24918 .33187 .26755 .33719 .28254 .32625 Metetra
.734 .783 .892 r
.24564 .31295 .23055 .32755 .24918 .33187 .26421 .31922 Metetra
.757 .79 .88 r
.22682 .30771 .21165 .3245 .23055 .32755 .24564 .31295 Metetra
.781 .798 .867 r
.20771 .3038 .19245 .323 .21165 .3245 .22682 .30771 Metetra
.804 .807 .853 r
.1883 .30159 .17292 .32342 .19245 .323 .20771 .3038 Metetra
.827 .817 .84 r
.16853 .30145 .15301 .3261 .17292 .32342 .1883 .30159 Metetra
.848 .827 .827 r
.14838 .30383 .13269 .33146 .15301 .3261 .16853 .30145 Metetra
.869 .839 .813 r
.12779 .3092 .1119 .33991 .13269 .33146 .14838 .30383 Metetra
.89 .853 .8 r
.10671 .31808 .0906 .3519 .1119 .33991 .12779 .3092 Metetra
.535 .8 .994 r
.61087 .44996 .59555 .45376 .61035 .45833 .62567 .45447 Metetra
.53 .797 .994 r
.5959 .44531 .58059 .44902 .59555 .45376 .61087 .44996 Metetra
.526 .793 .994 r
.58078 .44049 .56547 .44411 .58059 .44902 .5959 .44531 Metetra
.521 .79 .994 r
.56549 .43547 .55019 .43901 .56547 .44411 .58078 .44049 Metetra
.517 .785 .994 r
.55004 .43024 .53475 .43369 .55019 .43901 .56549 .43547 Metetra
.513 .781 .993 r
.53443 .42477 .51914 .42814 .53475 .43369 .55004 .43024 Metetra
.511 .776 .992 r
.51865 .41904 .50337 .42234 .51914 .42814 .53443 .42477 Metetra
.509 .771 .991 r
.50269 .41302 .48743 .41627 .50337 .42234 .51865 .41904 Metetra
.508 .766 .989 r
.48657 .40668 .47133 .40992 .48743 .41627 .50269 .41302 Metetra
.509 .762 .987 r
.47028 .40002 .45505 .40328 .47133 .40992 .48657 .40668 Metetra
.513 .757 .985 r
.45381 .39301 .43861 .39635 .45505 .40328 .47028 .40002 Metetra
.518 .753 .981 r
.43718 .38564 .42199 .38913 .43861 .39635 .45381 .39301 Metetra
.527 .75 .977 r
.42036 .37792 .4052 .38164 .42199 .38913 .43718 .38564 Metetra
.538 .747 .973 r
.40338 .36986 .38823 .37391 .4052 .38164 .42036 .37792 Metetra
.551 .746 .967 r
.38621 .36147 .37109 .36598 .38823 .37391 .40338 .36986 Metetra
.568 .745 .96 r
.36887 .3528 .35376 .35792 .37109 .36598 .38621 .36147 Metetra
.586 .746 .953 r
.35135 .34391 .33625 .34979 .35376 .35792 .36887 .3528 Metetra
.607 .747 .944 r
.33364 .33488 .31855 .34171 .33625 .34979 .35135 .34391 Metetra
.63 .75 .934 r
.31574 .32581 .30065 .33381 .31855 .34171 .33364 .33488 Metetra
.654 .753 .923 r
.29765 .31685 .28254 .32625 .30065 .33381 .31574 .32581 Metetra
.679 .758 .91 r
.27934 .30816 .26421 .31922 .28254 .32625 .29765 .31685 Metetra
.705 .763 .898 r
.26082 .29997 .24564 .31295 .26421 .31922 .27934 .30816 Metetra
.73 .769 .884 r
.24206 .29252 .22682 .30771 .24564 .31295 .26082 .29997 Metetra
.755 .776 .87 r
.22304 .28611 .20771 .3038 .22682 .30771 .24206 .29252 Metetra
.78 .784 .856 r
.20374 .2811 .1883 .30159 .20771 .3038 .22304 .28611 Metetra
.804 .792 .842 r
.18412 .27787 .16853 .30145 .1883 .30159 .20374 .2811 Metetra
.827 .802 .827 r
.16415 .27688 .14838 .30383 .16853 .30145 .18412 .27787 Metetra
.849 .812 .813 r
.14377 .27865 .12779 .3092 .14838 .30383 .16415 .27688 Metetra
.871 .823 .798 r
.12292 .28373 .10671 .31808 .12779 .3092 .14377 .27865 Metetra
.536 .803 .995 r
.62635 .44605 .61087 .44996 .62567 .45447 .64116 .45047 Metetra
.531 .8 .995 r
.61139 .44149 .5959 .44531 .61087 .44996 .62635 .44605 Metetra
.526 .797 .995 r
.59627 .43677 .58078 .44049 .5959 .44531 .61139 .44149 Metetra
.52 .793 .995 r
.58098 .43187 .56549 .43547 .58078 .44049 .59627 .43677 Metetra
.514 .788 .995 r
.56552 .42677 .55004 .43024 .56549 .43547 .58098 .43187 Metetra
.509 .783 .994 r
.5499 .42142 .53443 .42477 .55004 .43024 .56552 .42677 Metetra
.504 .778 .994 r
.5341 .41581 .51865 .41904 .53443 .42477 .5499 .42142 Metetra
.499 .772 .993 r
.51814 .40989 .50269 .41302 .51865 .41904 .5341 .41581 Metetra
.496 .766 .992 r
.502 .40365 .48657 .40668 .50269 .41302 .51814 .40989 Metetra
.494 .76 .99 r
.48569 .39705 .47028 .40002 .48657 .40668 .502 .40365 Metetra
.493 .754 .988 r
.46921 .39006 .45381 .39301 .47028 .40002 .48569 .39705 Metetra
.496 .748 .985 r
.45255 .38266 .43718 .38564 .45381 .39301 .46921 .39006 Metetra
.5 .743 .982 r
.43571 .37484 .42036 .37792 .43718 .38564 .45255 .38266 Metetra
.508 .739 .978 r
.4187 .36658 .40338 .36986 .42036 .37792 .43571 .37484 Metetra
.519 .735 .973 r
.40151 .35788 .38621 .36147 .40338 .36986 .4187 .36658 Metetra
.533 .733 .967 r
.38415 .34877 .36887 .3528 .38621 .36147 .40151 .35788 Metetra
.55 .732 .959 r
.36661 .33927 .35135 .34391 .36887 .3528 .38415 .34877 Metetra
.57 .731 .951 r
.34888 .32945 .33364 .33488 .35135 .34391 .36661 .33927 Metetra
.593 .733 .941 r
.33098 .31938 .31574 .32581 .33364 .33488 .34888 .32945 Metetra
.617 .735 .93 r
.31288 .30917 .29765 .31685 .31574 .32581 .33098 .31938 Metetra
.643 .738 .918 r
.29459 .29897 .27934 .30816 .29765 .31685 .31288 .30917 Metetra
.67 .743 .905 r
.2761 .28896 .26082 .29997 .27934 .30816 .29459 .29897 Metetra
.697 .748 .891 r
.25739 .27938 .24206 .29252 .26082 .29997 .2761 .28896 Metetra
.724 .754 .876 r
.23844 .27048 .22304 .28611 .24206 .29252 .25739 .27938 Metetra
.75 .761 .861 r
.21924 .26262 .20374 .2811 .22304 .28611 .23844 .27048 Metetra
.776 .768 .846 r
.19975 .25617 .18412 .27787 .20374 .2811 .21924 .26262 Metetra
.801 .777 .83 r
.17994 .25159 .16415 .27688 .18412 .27787 .19975 .25617 Metetra
.825 .786 .815 r
.15977 .2494 .14377 .27865 .16415 .27688 .17994 .25159 Metetra
.848 .795 .8 r
.13918 .25018 .12292 .28373 .14377 .27865 .15977 .2494 Metetra
.539 .806 .995 r
.64202 .44198 .62635 .44605 .64116 .45047 .65682 .44632 Metetra
.534 .804 .995 r
.62706 .43752 .61139 .44149 .62635 .44605 .64202 .44198 Metetra
.528 .8 .996 r
.61193 .43293 .59627 .43677 .61139 .44149 .62706 .43752 Metetra
.521 .797 .996 r
.59664 .42816 .58098 .43187 .59627 .43677 .61193 .43293 Metetra
.514 .792 .996 r
.58118 .4232 .56552 .42677 .58098 .43187 .59664 .42816 Metetra
.507 .787 .996 r
.56555 .41801 .5499 .42142 .56552 .42677 .58118 .4232 Metetra
.499 .781 .995 r
.54975 .41256 .5341 .41581 .5499 .42142 .56555 .41801 Metetra
.492 .775 .995 r
.53377 .40682 .51814 .40989 .5341 .41581 .54975 .41256 Metetra
.486 .768 .994 r
.51762 .40073 .502 .40365 .51814 .40989 .53377 .40682 Metetra
.48 .76 .992 r
.50129 .39428 .48569 .39705 .502 .40365 .51762 .40073 Metetra
.476 .753 .99 r
.48479 .38741 .46921 .39006 .48569 .39705 .50129 .39428 Metetra
.475 .745 .988 r
.46811 .38009 .45255 .38266 .46921 .39006 .48479 .38741 Metetra
.475 .738 .985 r
.45125 .37229 .43571 .37484 .45255 .38266 .46811 .38009 Metetra
.479 .732 .982 r
.43421 .36398 .4187 .36658 .43571 .37484 .45125 .37229 Metetra
.485 .726 .977 r
.417 .35514 .40151 .35788 .4187 .36658 .43421 .36398 Metetra
.496 .721 .972 r
.3996 .34576 .38415 .34877 .40151 .35788 .417 .35514 Metetra
.51 .717 .966 r
.38203 .33586 .36661 .33927 .38415 .34877 .3996 .34576 Metetra
.528 .715 .958 r
.36429 .32544 .34888 .32945 .36661 .33927 .38203 .33586 Metetra
.549 .715 .949 r
.34636 .31458 .33098 .31938 .34888 .32945 .36429 .32544 Metetra
.573 .715 .939 r
.32825 .30333 .31288 .30917 .33098 .31938 .34636 .31458 Metetra
.6 .717 .927 r
.30996 .29182 .29459 .29897 .31288 .30917 .32825 .30333 Metetra
.628 .721 .914 r
.29148 .28018 .2761 .28896 .29459 .29897 .30996 .29182 Metetra
.656 .725 .9 r
.2728 .26862 .25739 .27938 .2761 .28896 .29148 .28018 Metetra
.686 .731 .885 r
.25391 .25737 .23844 .27048 .25739 .27938 .2728 .26862 Metetra
.715 .737 .869 r
.23479 .24674 .21924 .26262 .23844 .27048 .25391 .25737 Metetra
.743 .744 .853 r
.21541 .23709 .19975 .25617 .21924 .26262 .23479 .24674 Metetra
.77 .752 .836 r
.19575 .22884 .17994 .25159 .19975 .25617 .21541 .23709 Metetra
.796 .76 .82 r
.17578 .22251 .15977 .2494 .17994 .25159 .19575 .22884 Metetra
.821 .769 .804 r
.15543 .21868 .13918 .25018 .15977 .2494 .17578 .22251 Metetra
.544 .81 .995 r
.65786 .43774 .64202 .44198 .65682 .44632 .67266 .442 Metetra
.538 .807 .996 r
.6429 .43338 .62706 .43752 .64202 .44198 .65786 .43774 Metetra
.531 .805 .996 r
.62778 .4289 .61193 .43293 .62706 .43752 .6429 .43338 Metetra
.524 .801 .996 r
.61248 .42428 .59664 .42816 .61193 .43293 .62778 .4289 Metetra
.516 .797 .997 r
.59702 .41948 .58118 .4232 .59664 .42816 .61248 .42428 Metetra
.507 .792 .997 r
.58139 .41447 .56555 .41801 .58118 .4232 .59702 .41948 Metetra
.498 .786 .997 r
.56558 .40923 .54975 .41256 .56555 .41801 .58139 .41447 Metetra
.489 .779 .996 r
.5496 .40369 .53377 .40682 .54975 .41256 .56558 .40923 Metetra
.48 .771 .995 r
.53343 .39783 .51762 .40073 .53377 .40682 .5496 .40369 Metetra
.471 .763 .994 r
.51709 .39159 .50129 .39428 .51762 .40073 .53343 .39783 Metetra
.463 .754 .993 r
.50057 .38494 .48479 .38741 .50129 .39428 .51709 .39159 Metetra
.456 .745 .991 r
.48387 .37781 .46811 .38009 .48479 .38741 .50057 .38494 Metetra
.452 .735 .988 r
.46698 .37016 .45125 .37229 .46811 .38009 .48387 .37781 Metetra
.45 .726 .985 r
.44992 .36195 .43421 .36398 .45125 .37229 .46698 .37016 Metetra
.452 .718 .981 r
.43267 .35313 .417 .35514 .43421 .36398 .44992 .36195 Metetra
.457 .71 .977 r
.41525 .34368 .3996 .34576 .417 .35514 .43267 .35313 Metetra
.467 .704 .971 r
.39765 .33357 .38203 .33586 .3996 .34576 .41525 .34368 Metetra
.481 .699 .965 r
.37987 .3228 .36429 .32544 .38203 .33586 .39765 .33357 Metetra
.5 .696 .957 r
.36191 .31138 .34636 .31458 .36429 .32544 .37987 .3228 Metetra
.522 .695 .947 r
.34378 .29935 .32825 .30333 .34636 .31458 .36191 .31138 Metetra
.548 .695 .936 r
.32547 .28678 .30996 .29182 .32825 .30333 .34378 .29935 Metetra
.577 .697 .924 r
.30699 .27378 .29148 .28018 .30996 .29182 .32547 .28678 Metetra
.607 .701 .91 r
.28831 .2605 .2728 .26862 .29148 .28018 .30699 .27378 Metetra
.639 .705 .895 r
.26945 .24713 .25391 .25737 .2728 .26862 .28831 .2605 Metetra
.67 .711 .879 r
.25038 .23392 .23479 .24674 .25391 .25737 .26945 .24713 Metetra
.702 .718 .862 r
.2311 .22121 .21541 .23709 .23479 .24674 .25038 .23392 Metetra
.732 .725 .845 r
.21156 .20939 .19575 .22884 .21541 .23709 .2311 .22121 Metetra
.761 .734 .828 r
.19175 .19892 .17578 .22251 .19575 .22884 .21156 .20939 Metetra
.788 .742 .811 r
.17163 .19037 .15543 .21868 .17578 .22251 .19175 .19892 Metetra
.549 .813 .995 r
.67388 .43328 .65786 .43774 .67266 .442 .68867 .43747 Metetra
.543 .811 .996 r
.65892 .42902 .6429 .43338 .65786 .43774 .67388 .43328 Metetra
.537 .809 .996 r
.6438 .42466 .62778 .4289 .6429 .43338 .65892 .42902 Metetra
.529 .806 .997 r
.62851 .42018 .61248 .42428 .62778 .4289 .6438 .42466 Metetra
.521 .802 .997 r
.61305 .41555 .59702 .41948 .61248 .42428 .62851 .42018 Metetra
.511 .798 .997 r
.59742 .41074 .58139 .41447 .59702 .41948 .61305 .41555 Metetra
.501 .792 .997 r
.5816 .40571 .56558 .40923 .58139 .41447 .59742 .41074 Metetra
.489 .785 .997 r
.56561 .40043 .5496 .40369 .56558 .40923 .5816 .40571 Metetra
.478 .777 .997 r
.54944 .39483 .53343 .39783 .5496 .40369 .56561 .40043 Metetra
.466 .768 .996 r
.53309 .38888 .51709 .39159 .53343 .39783 .54944 .39483 Metetra
.454 .758 .995 r
.51655 .38251 .50057 .38494 .51709 .39159 .53309 .38888 Metetra
.442 .747 .993 r
.49983 .37567 .48387 .37781 .50057 .38494 .51655 .38251 Metetra
.433 .735 .99 r
.48292 .3683 .46698 .37016 .48387 .37781 .49983 .37567 Metetra
.425 .724 .988 r
.46583 .36033 .44992 .36195 .46698 .37016 .48292 .3683 Metetra
.42 .712 .984 r
.44855 .3517 .43267 .35313 .44992 .36195 .46583 .36033 Metetra
.419 .701 .98 r
.43109 .34237 .41525 .34368 .43267 .35313 .44855 .3517 Metetra
.423 .691 .975 r
.41345 .33227 .39765 .33357 .41525 .34368 .43109 .34237 Metetra
.431 .683 .969 r
.39564 .32139 .37987 .3228 .39765 .33357 .41345 .33227 Metetra
.445 .677 .962 r
.37764 .30968 .36191 .31138 .37987 .3228 .39564 .32139 Metetra
.464 .672 .954 r
.35948 .29716 .34378 .29935 .36191 .31138 .37764 .30968 Metetra
.488 .67 .944 r
.34114 .28385 .32547 .28678 .34378 .29935 .35948 .29716 Metetra
.516 .67 .933 r
.32263 .26981 .30699 .27378 .32547 .28678 .34114 .28385 Metetra
.548 .673 .92 r
.30394 .25513 .28831 .2605 .30699 .27378 .32263 .26981 Metetra
.581 .677 .905 r
.28509 .23996 .26945 .24713 .28831 .2605 .30394 .25513 Metetra
.616 .682 .89 r
.26605 .2245 .25038 .23392 .26945 .24713 .28509 .23996 Metetra
.65 .689 .873 r
.24681 .20901 .2311 .22121 .25038 .23392 .26605 .2245 Metetra
.684 .697 .855 r
.22737 .19385 .21156 .20939 .2311 .22121 .24681 .20901 Metetra
.717 .705 .838 r
.2077 .17942 .19175 .19892 .21156 .20939 .22737 .19385 Metetra
.748 .714 .82 r
.18776 .16624 .17163 .19037 .19175 .19892 .2077 .17942 Metetra
.555 .816 .994 r
.69008 .42861 .67388 .43328 .68867 .43747 .70486 .43275 Metetra
.55 .815 .995 r
.67513 .42442 .65892 .42902 .67388 .43328 .69008 .42861 Metetra
.543 .814 .996 r
.66001 .42016 .6438 .42466 .65892 .42902 .67513 .42442 Metetra
.536 .811 .997 r
.64473 .41582 .62851 .42018 .6438 .42466 .66001 .42016 Metetra
.527 .808 .997 r
.62927 .41136 .61305 .41555 .62851 .42018 .64473 .41582 Metetra
.517 .804 .998 r
.61363 .40675 .59742 .41074 .61305 .41555 .62927 .41136 Metetra
.506 .799 .998 r
.59782 .40195 .5816 .40571 .59742 .41074 .61363 .40675 Metetra
.494 .792 .998 r
.58183 .39693 .56561 .40043 .5816 .40571 .59782 .40195 Metetra
.48 .784 .998 r
.56565 .39164 .54944 .39483 .56561 .40043 .58183 .39693 Metetra
.465 .775 .997 r
.54929 .38602 .53309 .38888 .54944 .39483 .56565 .39164 Metetra
.45 .764 .996 r
.53273 .38 .51655 .38251 .53309 .38888 .54929 .38602 Metetra
.434 .752 .994 r
.516 .37353 .49983 .37567 .51655 .38251 .53273 .38 Metetra
.419 .739 .992 r
.49907 .36654 .48292 .3683 .49983 .37567 .516 .37353 Metetra
.405 .724 .989 r
.48195 .35894 .46583 .36033 .48292 .3683 .49907 .36654 Metetra
.393 .71 .986 r
.46464 .35066 .44855 .3517 .46583 .36033 .48195 .35894 Metetra
.384 .695 .982 r
.44715 .34163 .43109 .34237 .44855 .3517 .46464 .35066 Metetra
.38 .681 .977 r
.42947 .33178 .41345 .33227 .43109 .34237 .44715 .34163 Metetra
.38 .668 .972 r
.41161 .32102 .39564 .32139 .41345 .33227 .42947 .33178 Metetra
.387 .657 .965 r
.39357 .30932 .37764 .30968 .39564 .32139 .41161 .32102 Metetra
.4 .649 .958 r
.37536 .29662 .35948 .29716 .37764 .30968 .39357 .30932 Metetra
.419 .643 .95 r
.35698 .28291 .34114 .28385 .35948 .29716 .37536 .29662 Metetra
.445 .64 .94 r
.33843 .26819 .32263 .26981 .34114 .28385 .35698 .28291 Metetra
.476 .641 .928 r
.31971 .2525 .30394 .25513 .32263 .26981 .33843 .26819 Metetra
.51 .643 .915 r
.30083 .23594 .28509 .23996 .30394 .25513 .31971 .2525 Metetra
.548 .648 .9 r
.28179 .21863 .26605 .2245 .28509 .23996 .30083 .23594 Metetra
.586 .655 .884 r
.26258 .20078 .24681 .20901 .26605 .2245 .28179 .21863 Metetra
.625 .663 .867 r
.24319 .18266 .22737 .19385 .24681 .20901 .26258 .20078 Metetra
.662 .672 .849 r
.22361 .16461 .2077 .17942 .22737 .19385 .24319 .18266 Metetra
.698 .682 .831 r
.20382 .1471 .18776 .16624 .2077 .17942 .22361 .16461 Metetra
.561 .819 .994 r
.70646 .4237 .69008 .42861 .70486 .43275 .72123 .42781 Metetra
.556 .819 .995 r
.69152 .41957 .67513 .42442 .69008 .42861 .70646 .4237 Metetra
.551 .818 .996 r
.67641 .4154 .66001 .42016 .67513 .42442 .69152 .41957 Metetra
.544 .816 .996 r
.66113 .41117 .64473 .41582 .66001 .42016 .67641 .4154 Metetra
.536 .814 .997 r
.64567 .40686 .62927 .41136 .64473 .41582 .66113 .41117 Metetra
.526 .811 .998 r
.63004 .40244 .61363 .40675 .62927 .41136 .64567 .40686 Metetra
.515 .806 .998 r
.61423 .39787 .59782 .40195 .61363 .40675 .63004 .40244 Metetra
.502 .8 .999 r
.59824 .39313 .58183 .39693 .59782 .40195 .61423 .39787 Metetra
.487 .793 .999 r
.58206 .38815 .56565 .39164 .58183 .39693 .59824 .39313 Metetra
.47 .784 .998 r
.56569 .38288 .54929 .38602 .56565 .39164 .58206 .38815 Metetra
.452 .773 .997 r
.54913 .37727 .53273 .38 .54929 .38602 .56569 .38288 Metetra
.432 .76 .996 r
.53238 .37124 .516 .37353 .53273 .38 .54913 .37727 Metetra
.412 .746 .994 r
.51543 .3647 .49907 .36654 .516 .37353 .53238 .37124 Metetra
.392 .729 .99 r
.49829 .35759 .48195 .35894 .49907 .36654 .51543 .3647 Metetra
.372 .711 .987 r
.48095 .3498 .46464 .35066 .48195 .35894 .49829 .35759 Metetra
.355 .693 .982 r
.46343 .34125 .44715 .34163 .46464 .35066 .48095 .3498 Metetra
.34 .674 .977 r
.44571 .33184 .42947 .33178 .44715 .34163 .46343 .34125 Metetra
.331 .656 .971 r
.4278 .32146 .41161 .32102 .42947 .33178 .44571 .33184 Metetra
.328 .639 .965 r
.40972 .31004 .39357 .30932 .41161 .32102 .4278 .32146 Metetra
.331 .625 .958 r
.39145 .29749 .37536 .29662 .39357 .30932 .40972 .31004 Metetra
.343 .614 .951 r
.37301 .28374 .35698 .28291 .37536 .29662 .39145 .29749 Metetra
.362 .607 .942 r
.35441 .26875 .33843 .26819 .35698 .28291 .37301 .28374 Metetra
.39 .603 .933 r
.33564 .2525 .31971 .2525 .33843 .26819 .35441 .26875 Metetra
.423 .603 .921 r
.31672 .23501 .30083 .23594 .31971 .2525 .33564 .2525 Metetra
.462 .607 .909 r
.29765 .21635 .28179 .21863 .30083 .23594 .31672 .23501 Metetra
.504 .613 .894 r
.27842 .19664 .26258 .20078 .28179 .21863 .29765 .21635 Metetra
.548 .622 .878 r
.25905 .17607 .24319 .18266 .26258 .20078 .27842 .19664 Metetra
.591 .632 .86 r
.23952 .15491 .22361 .16461 .24319 .18266 .25905 .17607 Metetra
.634 .644 .842 r
.21982 .13353 .20382 .1471 .22361 .16461 .23952 .15491 Metetra
.567 .821 .993 r
.72302 .41857 .70646 .4237 .72123 .42781 .73779 .42267 Metetra
.564 .822 .994 r
.70809 .41446 .69152 .41957 .70646 .4237 .72302 .41857 Metetra
.559 .821 .995 r
.69299 .41035 .67641 .4154 .69152 .41957 .70809 .41446 Metetra
.553 .821 .996 r
.67772 .40621 .66113 .41117 .67641 .4154 .69299 .41035 Metetra
.546 .819 .997 r
.66227 .40202 .64567 .40686 .66113 .41117 .67772 .40621 Metetra
.537 .817 .998 r
.64664 .39777 .63004 .40244 .64567 .40686 .66227 .40202 Metetra
.526 .814 .998 r
.63084 .39342 .61423 .39787 .63004 .40244 .64664 .39777 Metetra
.513 .809 .999 r
.61485 .38893 .59824 .39313 .61423 .39787 .63084 .39342 Metetra
.497 .803 .999 r
.59867 .38427 .58206 .38815 .59824 .39313 .61485 .38893 Metetra
.48 .795 .999 r
.5823 .37937 .56569 .38288 .58206 .38815 .59867 .38427 Metetra
.46 .784 .999 r
.56573 .37418 .54913 .37727 .56569 .38288 .5823 .37937 Metetra
.438 .772 .997 r
.54897 .36862 .53238 .37124 .54913 .37727 .56573 .37418 Metetra
.413 .757 .995 r
.53201 .36262 .51543 .3647 .53238 .37124 .54897 .36862 Metetra
.387 .739 .991 r
.51485 .35608 .49829 .35759 .51543 .3647 .53201 .36262 Metetra
.36 .718 .987 r
.49749 .3489 .48095 .3498 .49829 .35759 .51485 .35608 Metetra
.334 .696 .982 r
.47993 .34097 .46343 .34125 .48095 .3498 .49749 .3489 Metetra
.309 .672 .975 r
.46218 .33218 .44571 .33184 .46343 .34125 .47993 .34097 Metetra
.288 .648 .968 r
.44423 .32242 .4278 .32146 .44571 .33184 .46218 .33218 Metetra
.271 .624 .96 r
.42609 .31155 .40972 .31004 .4278 .32146 .44423 .32242 Metetra
.262 .602 .953 r
.40777 .29946 .39145 .29749 .40972 .31004 .42609 .31155 Metetra
.261 .584 .945 r
.38926 .28605 .37301 .28374 .39145 .29749 .40777 .29946 Metetra
.27 .569 .937 r
.37059 .27121 .35441 .26875 .37301 .28374 .38926 .28605 Metetra
.29 .56 .929 r
.35176 .25486 .33564 .2525 .35441 .26875 .37059 .27121 Metetra
.318 .555 .92 r
.33277 .23696 .31672 .23501 .33564 .2525 .35176 .25486 Metetra
.356 .556 .91 r
.31364 .21751 .29765 .21635 .31672 .23501 .33277 .23696 Metetra
.4 .561 .898 r
.29438 .19653 .27842 .19664 .29765 .21635 .31364 .21751 Metetra
.448 .57 .885 r
.27498 .17414 .25905 .17607 .27842 .19664 .29438 .19653 Metetra
.499 .582 .869 r
.25545 .1505 .23952 .15491 .25905 .17607 .27498 .17414 Metetra
.549 .595 .853 r
.23579 .12589 .21982 .13353 .23952 .15491 .25545 .1505 Metetra
.573 .823 .992 r
.73977 .4132 .72302 .41857 .73779 .42267 .75453 .41732 Metetra
.571 .824 .993 r
.72485 .4091 .70809 .41446 .72302 .41857 .73977 .4132 Metetra
.567 .824 .994 r
.70976 .40501 .69299 .41035 .70809 .41446 .72485 .4091 Metetra
.562 .825 .995 r
.69449 .40092 .67772 .40621 .69299 .41035 .70976 .40501 Metetra
.556 .824 .996 r
.67906 .39683 .66227 .40202 .67772 .40621 .69449 .40092 Metetra
.548 .823 .997 r
.66344 .39271 .64664 .39777 .66227 .40202 .67906 .39683 Metetra
.538 .821 .998 r
.64764 .38854 .63084 .39342 .64664 .39777 .66344 .39271 Metetra
.526 .818 .999 r
.63166 .38429 .61485 .38893 .63084 .39342 .64764 .38854 Metetra
.512 .813 1 r
.61548 .37992 .59867 .38427 .61485 .38893 .63166 .38429 Metetra
.494 .806 1 r
.59911 .37539 .5823 .37937 .59867 .38427 .61548 .37992 Metetra
.474 .797 .999 r
.58254 .37062 .56573 .37418 .5823 .37937 .59911 .37539 Metetra
.45 .786 .998 r
.56578 .36556 .54897 .36862 .56573 .37418 .58254 .37062 Metetra
.423 .771 .996 r
.54881 .36012 .53201 .36262 .54897 .36862 .56578 .36556 Metetra
.392 .753 .993 r
.53163 .3542 .51485 .35608 .53201 .36262 .54881 .36012 Metetra
.359 .731 .988 r
.51426 .34772 .49749 .3489 .51485 .35608 .53163 .3542 Metetra
.325 .706 .981 r
.49667 .34054 .47993 .34097 .49749 .3489 .51426 .34772 Metetra
.289 .677 .973 r
.47888 .33253 .46218 .33218 .47993 .34097 .49667 .34054 Metetra
.255 .647 .964 r
.46089 .32357 .44423 .32242 .46218 .33218 .47888 .33253 Metetra
.224 .615 .953 r
.4427 .31351 .42609 .31155 .44423 .32242 .46089 .32357 Metetra
.198 .584 .943 r
.42432 .30219 .40777 .29946 .42609 .31155 .4427 .31351 Metetra
.181 .555 .932 r
.40575 .28946 .38926 .28605 .40777 .29946 .42432 .30219 Metetra
.174 .53 .922 r
.38701 .27518 .37059 .27121 .38926 .28605 .40575 .28946 Metetra
.179 .511 .913 r
.3681 .25922 .35176 .25486 .37059 .27121 .38701 .27518 Metetra
.197 .498 .905 r
.34903 .24145 .33277 .23696 .35176 .25486 .3681 .25922 Metetra
.227 .493 .898 r
.32982 .2218 .31364 .21751 .33277 .23696 .34903 .24145 Metetra
.268 .495 .89 r
.31047 .20022 .29438 .19653 .31364 .21751 .32982 .2218 Metetra
.319 .502 .881 r
.29101 .17671 .27498 .17414 .29438 .19653 .31047 .20022 Metetra
.375 .515 .87 r
.27144 .15134 .25545 .1505 .27498 .17414 .29101 .17671 Metetra
.435 .531 .857 r
.25176 .12428 .23579 .12589 .25545 .1505 .27144 .15134 Metetra
.579 .824 .991 r
.75671 .40762 .73977 .4132 .75453 .41732 .77145 .4118 Metetra
.577 .825 .992 r
.7418 .40349 .72485 .4091 .73977 .4132 .75671 .40762 Metetra
.575 .827 .993 r
.72672 .39938 .70976 .40501 .72485 .4091 .7418 .40349 Metetra
.571 .828 .994 r
.71146 .39532 .69449 .40092 .70976 .40501 .72672 .39938 Metetra
.566 .828 .995 r
.69604 .39127 .67906 .39683 .69449 .40092 .71146 .39532 Metetra
.56 .828 .996 r
.68043 .38725 .66344 .39271 .67906 .39683 .69604 .39127 Metetra
.552 .828 .997 r
.66464 .38322 .64764 .38854 .66344 .39271 .68043 .38725 Metetra
.541 .826 .998 r
.64866 .37917 .63166 .38429 .64764 .38854 .66464 .38322 Metetra
.528 .823 .999 r
.63249 .37506 .61548 .37992 .63166 .38429 .64866 .37917 Metetra
.512 .818 1 r
.61613 .37085 .59911 .37539 .61548 .37992 .63249 .37506 Metetra
.492 .811 1 r
.59957 .36648 .58254 .37062 .59911 .37539 .61613 .37085 Metetra
.468 .801 .999 r
.5828 .3619 .56578 .36556 .58254 .37062 .59957 .36648 Metetra
.44 .788 .998 r
.56583 .35703 .54881 .36012 .56578 .36556 .5828 .3619 Metetra
.407 .77 .994 r
.54865 .35178 .53163 .3542 .54881 .36012 .56583 .35703 Metetra
.37 .749 .989 r
.53125 .34603 .51426 .34772 .53163 .3542 .54865 .35178 Metetra
.329 .722 .982 r
.51365 .33968 .49667 .34054 .51426 .34772 .53125 .34603 Metetra
.284 .691 .972 r
.49583 .33258 .47888 .33253 .49667 .34054 .51365 .33968 Metetra
.237 .655 .96 r
.4778 .32459 .46089 .32357 .47888 .33253 .49583 .33258 Metetra
.191 .615 .945 r
.45957 .31554 .4427 .31351 .46089 .32357 .4778 .32459 Metetra
.147 .574 .93 r
.44113 .30525 .42432 .30219 .4427 .31351 .45957 .31554 Metetra
.11 .533 .913 r
.4225 .29354 .40575 .28946 .42432 .30219 .44113 .30525 Metetra
.082 .494 .898 r
.40368 .28022 .38701 .27518 .40575 .28946 .4225 .29354 Metetra
.066 .461 .885 r
.38468 .2651 .3681 .25922 .38701 .27518 .40368 .28022 Metetra
.065 .436 .874 r
.36552 .24801 .34903 .24145 .3681 .25922 .38468 .2651 Metetra
.08 .419 .866 r
.3462 .22878 .32982 .2218 .34903 .24145 .36552 .24801 Metetra
.11 .412 .861 r
.32676 .20728 .31047 .20022 .32982 .2218 .3462 .22878 Metetra
.156 .415 .856 r
.3072 .18342 .29101 .17671 .31047 .20022 .32676 .20728 Metetra
.214 .426 .852 r
.28754 .15716 .27144 .15134 .29101 .17671 .3072 .18342 Metetra
.28 .444 .846 r
.2678 .12854 .25176 .12428 .27144 .15134 .28754 .15716 Metetra
.583 .824 .99 r
.77384 .40186 .75671 .40762 .77145 .4118 .78857 .40612 Metetra
.583 .826 .991 r
.75894 .39765 .7418 .40349 .75671 .40762 .77384 .40186 Metetra
.582 .828 .991 r
.74387 .3935 .72672 .39938 .7418 .40349 .75894 .39765 Metetra
.579 .83 .992 r
.72863 .3894 .71146 .39532 .72672 .39938 .74387 .3935 Metetra
.576 .831 .993 r
.71321 .38537 .69604 .39127 .71146 .39532 .72863 .3894 Metetra
.572 .832 .994 r
.69761 .38139 .68043 .38725 .69604 .39127 .71321 .38537 Metetra
.565 .833 .996 r
.68183 .37745 .66464 .38322 .68043 .38725 .69761 .38139 Metetra
.557 .833 .997 r
.66587 .37354 .64866 .37917 .66464 .38322 .68183 .37745 Metetra
.546 .832 .998 r
.64971 .36963 .63249 .37506 .64866 .37917 .66587 .37354 Metetra
.531 .829 .999 r
.63335 .3657 .61613 .37085 .63249 .37506 .64971 .36963 Metetra
.513 .824 1 r
.6168 .36169 .59957 .36648 .61613 .37085 .63335 .3657 Metetra
.491 .817 1 r
.60004 .35756 .5828 .3619 .59957 .36648 .6168 .36169 Metetra
.464 .806 .999 r
.58307 .35323 .56583 .35703 .5828 .3619 .60004 .35756 Metetra
.431 .791 .996 r
.56588 .34863 .54865 .35178 .56583 .35703 .58307 .35323 Metetra
.392 .771 .991 r
.54848 .34364 .53125 .34603 .54865 .35178 .56588 .34863 Metetra
.347 .745 .984 r
.53086 .33816 .51365 .33968 .53125 .34603 .54848 .34364 Metetra
.295 .712 .973 r
.51303 .33204 .49583 .33258 .51365 .33968 .53086 .33816 Metetra
.238 .673 .958 r
.49497 .32513 .4778 .32459 .49583 .33258 .51303 .33204 Metetra
.177 .627 .939 r
.4767 .31725 .45957 .31554 .4778 .32459 .49497 .32513 Metetra
.116 .576 .917 r
.45821 .30821 .44113 .30525 .45957 .31554 .4767 .31725 Metetra
.057 .522 .893 r
.43951 .2978 .4225 .29354 .44113 .30525 .45821 .30821 Metetra
.005 .468 .868 r
.42061 .28579 .40368 .28022 .4225 .29354 .43951 .2978 Metetra
0 .417 .845 r
.40153 .27196 .38468 .2651 .40368 .28022 .42061 .28579 Metetra
0 .373 .825 r
.38226 .25606 .36552 .24801 .38468 .2651 .40153 .27196 Metetra
0 .338 .811 r
.36284 .23786 .3462 .22878 .36552 .24801 .38226 .25606 Metetra
0 .316 .803 r
.34328 .21715 .32676 .20728 .3462 .22878 .36284 .23786 Metetra
0 .307 .8 r
.32359 .19373 .3072 .18342 .32676 .20728 .34328 .21715 Metetra
.014 .311 .801 r
.30381 .16747 .28754 .15716 .3072 .18342 .32359 .19373 Metetra
.08 .326 .804 r
.28395 .13825 .2678 .12854 .28754 .15716 .30381 .16747 Metetra
.587 .823 .989 r
.79116 .39594 .77384 .40186 .78857 .40612 .80589 .40031 Metetra
.587 .826 .989 r
.77627 .39162 .75894 .39765 .77384 .40186 .79116 .39594 Metetra
.587 .828 .99 r
.76121 .38738 .74387 .3935 .75894 .39765 .77627 .39162 Metetra
.587 .83 .991 r
.74599 .38321 .72863 .3894 .74387 .3935 .76121 .38738 Metetra
.585 .833 .992 r
.73058 .37913 .71321 .38537 .72863 .3894 .74599 .38321 Metetra
.582 .835 .993 r
.715 .37514 .69761 .38139 .71321 .38537 .73058 .37913 Metetra
.578 .837 .994 r
.69923 .37123 .68183 .37745 .69761 .38139 .715 .37514 Metetra
.572 .838 .995 r
.68327 .3674 .66587 .37354 .68183 .37745 .69923 .37123 Metetra
.563 .839 .997 r
.66713 .36364 .64971 .36963 .66587 .37354 .68327 .3674 Metetra
.552 .838 .998 r
.65078 .35991 .63335 .3657 .64971 .36963 .66713 .36364 Metetra
.537 .836 .999 r
.63424 .3562 .6168 .36169 .63335 .3657 .65078 .35991 Metetra
.517 .831 1 r
.61748 .35245 .60004 .35756 .6168 .36169 .63424 .3562 Metetra
.492 .824 .999 r
.60052 .34862 .58307 .35323 .60004 .35756 .61748 .35245 Metetra
.462 .812 .998 r
.58334 .34462 .56588 .34863 .58307 .35323 .60052 .34862 Metetra
.424 .795 .994 r
.56594 .34036 .54848 .34364 .56588 .34863 .58334 .34462 Metetra
.377 .772 .987 r
.54832 .33574 .53086 .33816 .54848 .34364 .56594 .34036 Metetra
.322 .741 .976 r
.53047 .33063 .51303 .33204 .53086 .33816 .54832 .33574 Metetra
.258 .701 .96 r
.51239 .32486 .49497 .32513 .51303 .33204 .53047 .33063 Metetra
.187 .652 .938 r
.49408 .31826 .4767 .31725 .49497 .32513 .51239 .32486 Metetra
.109 .593 .91 r
.47555 .31063 .45821 .30821 .4767 .31725 .49408 .31826 Metetra
.03 .527 .876 r
.4568 .30174 .43951 .2978 .45821 .30821 .47555 .31063 Metetra
0 .457 .839 r
.43783 .29135 .42061 .28579 .43951 .2978 .4568 .30174 Metetra
0 .386 .801 r
.41866 .27917 .40153 .27196 .42061 .28579 .43783 .29135 Metetra
0 .32 .766 r
.3993 .26493 .38226 .25606 .40153 .27196 .41866 .27917 Metetra
0 .263 .737 r
.37975 .24834 .36284 .23786 .38226 .25606 .3993 .26493 Metetra
0 .219 .717 r
.36006 .2291 .34328 .21715 .36284 .23786 .37975 .24834 Metetra
0 .189 .707 r
.34023 .20692 .32359 .19373 .34328 .21715 .36006 .2291 Metetra
0 .176 .707 r
.32029 .18155 .30381 .16747 .32359 .19373 .34023 .20692 Metetra
0 .18 .714 r
.30028 .15277 .28395 .13825 .30381 .16747 .32029 .18155 Metetra
.589 .822 .988 r
.80869 .38989 .79116 .39594 .80589 .40031 .8234 .3944 Metetra
.591 .824 .988 r
.79381 .38543 .77627 .39162 .79116 .39594 .80869 .38989 Metetra
.592 .827 .989 r
.77876 .38106 .76121 .38738 .77627 .39162 .79381 .38543 Metetra
.593 .83 .989 r
.76354 .37678 .74599 .38321 .76121 .38738 .77876 .38106 Metetra
.593 .833 .99 r
.74815 .3726 .73058 .37913 .74599 .38321 .76354 .37678 Metetra
.592 .836 .991 r
.73258 .36854 .715 .37514 .73058 .37913 .74815 .3726 Metetra
.59 .839 .992 r
.71682 .3646 .69923 .37123 .715 .37514 .73258 .36854 Metetra
.586 .842 .993 r
.70088 .36077 .68327 .3674 .69923 .37123 .71682 .3646 Metetra
.58 .844 .995 r
.68475 .35707 .66713 .36364 .68327 .3674 .70088 .36077 Metetra
.572 .846 .996 r
.66842 .35348 .65078 .35991 .66713 .36364 .68475 .35707 Metetra
.56 .846 .997 r
.65189 .34998 .63424 .3562 .65078 .35991 .66842 .35348 Metetra
.544 .844 .999 r
.63514 .34653 .61748 .35245 .63424 .3562 .65189 .34998 Metetra
.523 .84 .999 r
.61819 .34311 .60052 .34862 .61748 .35245 .63514 .34653 Metetra
.496 .833 .998 r
.60102 .33964 .58334 .34462 .60052 .34862 .61819 .34311 Metetra
.462 .82 .996 r
.58363 .33605 .56594 .34036 .58334 .34462 .60102 .33964 Metetra
.418 .802 .99 r
.566 .33224 .54832 .33574 .56594 .34036 .58363 .33605 Metetra
.364 .775 .981 r
.54815 .32811 .53047 .33063 .54832 .33574 .566 .33224 Metetra
.298 .738 .965 r
.53006 .32349 .51239 .32486 .53047 .33063 .54815 .32811 Metetra
.22 .689 .942 r
.51174 .31821 .49408 .31826 .51239 .32486 .53006 .32349 Metetra
.131 .627 .909 r
.49317 .31208 .47555 .31063 .49408 .31826 .51174 .31821 Metetra
.034 .552 .867 r
.47438 .30487 .4568 .30174 .47555 .31063 .49317 .31208 Metetra
0 .468 .817 r
.45535 .2963 .43783 .29135 .4568 .30174 .47438 .30487 Metetra
0 .378 .763 r
.4361 .28609 .41866 .27917 .43783 .29135 .45535 .2963 Metetra
0 .289 .708 r
.41664 .27391 .3993 .26493 .41866 .27917 .4361 .28609 Metetra
0 .207 .658 r
.39698 .25943 .37975 .24834 .3993 .26493 .41664 .27391 Metetra
0 .137 .618 r
.37714 .24228 .36006 .2291 .37975 .24834 .39698 .25943 Metetra
0 .082 .59 r
.35716 .2221 .34023 .20692 .36006 .2291 .37714 .24228 Metetra
0 .044 .576 r
.33705 .19852 .32029 .18155 .34023 .20692 .35716 .2221 Metetra
0 .025 .577 r
.31685 .17121 .30028 .15277 .32029 .18155 .33705 .19852 Metetra
.591 .82 .987 r
.82642 .38375 .80869 .38989 .8234 .3944 .84112 .38843 Metetra
.593 .823 .987 r
.81155 .37913 .79381 .38543 .80869 .38989 .82642 .38375 Metetra
.595 .826 .987 r
.79651 .37459 .77876 .38106 .79381 .38543 .81155 .37913 Metetra
.597 .829 .988 r
.78131 .37015 .76354 .37678 .77876 .38106 .79651 .37459 Metetra
.599 .832 .988 r
.76593 .36582 .74815 .3726 .76354 .37678 .78131 .37015 Metetra
.6 .836 .989 r
.75037 .36163 .73258 .36854 .74815 .3726 .76593 .36582 Metetra
.599 .84 .99 r
.73462 .35759 .71682 .3646 .73258 .36854 .75037 .36163 Metetra
.598 .844 .991 r
.71869 .3537 .70088 .36077 .71682 .3646 .73462 .35759 Metetra
.595 .847 .992 r
.70257 .34998 .68475 .35707 .70088 .36077 .71869 .3537 Metetra
.59 .85 .994 r
.68626 .34642 .66842 .35348 .68475 .35707 .70257 .34998 Metetra
.582 .853 .995 r
.66974 .34303 .65189 .34998 .66842 .35348 .68626 .34642 Metetra
.57 .854 .997 r
.65301 .33979 .63514 .34653 .65189 .34998 .66974 .34303 Metetra
.554 .854 .998 r
.63608 .33667 .61819 .34311 .63514 .34653 .65301 .33979 Metetra
.533 .85 .998 r
.61892 .33362 .60102 .33964 .61819 .34311 .63608 .33667 Metetra
.504 .843 .997 r
.60154 .3306 .58363 .33605 .60102 .33964 .61892 .33362 Metetra
.466 .831 .993 r
.58392 .32752 .566 .33224 .58363 .33605 .60154 .3306 Metetra
.416 .811 .986 r
.56607 .32428 .54815 .32811 .566 .33224 .58392 .32752 Metetra
.353 .78 .972 r
.54798 .32075 .53006 .32349 .54815 .32811 .56607 .32428 Metetra
.275 .736 .95 r
.52965 .31678 .51174 .31821 .53006 .32349 .54798 .32075 Metetra
.181 .676 .917 r
.51107 .31217 .49317 .31208 .51174 .31821 .52965 .31678 Metetra
.072 .599 .871 r
.49224 .3067 .47438 .30487 .49317 .31208 .51107 .31217 Metetra
0 .505 .811 r
.47316 .30009 .45535 .2963 .47438 .30487 .49224 .3067 Metetra
0 .399 .74 r
.45385 .29206 .4361 .28609 .45535 .2963 .47316 .30009 Metetra
0 .288 .664 r
.4343 .28225 .41664 .27391 .4361 .28609 .45385 .29206 Metetra
.382 0 0 r
.41453 .2703 .39698 .25943 .41664 .27391 .4343 .28225 Metetra
.463 0 0 r
.39457 .25578 .37714 .24228 .39698 .25943 .41453 .2703 Metetra
.522 0 0 r
.37442 .23827 .35716 .2221 .37714 .24228 .39457 .25578 Metetra
.56 .06 0 r
.35413 .21732 .33705 .19852 .35716 .2221 .37442 .23827 Metetra
.575 .105 0 r
.33372 .19246 .31685 .17121 .33705 .19852 .35413 .21732 Metetra
.591 .817 .986 r
.84436 .37756 .82642 .38375 .84112 .38843 .85905 .38243 Metetra
.594 .82 .986 r
.8295 .37275 .81155 .37913 .82642 .38375 .84436 .37756 Metetra
.597 .823 .986 r
.81448 .36801 .79651 .37459 .81155 .37913 .8295 .37275 Metetra
.6 .827 .986 r
.79928 .36337 .78131 .37015 .79651 .37459 .81448 .36801 Metetra
.603 .83 .986 r
.78391 .35885 .76593 .36582 .78131 .37015 .79928 .36337 Metetra
.605 .835 .987 r
.76836 .35448 .75037 .36163 .76593 .36582 .78391 .35885 Metetra
.607 .839 .988 r
.75263 .35026 .73462 .35759 .75037 .36163 .76836 .35448 Metetra
.608 .843 .988 r
.73671 .34623 .71869 .3537 .73462 .35759 .75263 .35026 Metetra
.607 .848 .989 r
.72061 .34241 .70257 .34998 .71869 .3537 .73671 .34623 Metetra
.605 .853 .991 r
.70431 .3388 .68626 .34642 .70257 .34998 .72061 .34241 Metetra
.601 .857 .992 r
.6878 .33541 .66974 .34303 .68626 .34642 .70431 .3388 Metetra
.594 .861 .994 r
.67109 .33225 .65301 .33979 .66974 .34303 .6878 .33541 Metetra
.583 .864 .995 r
.65417 .32931 .63608 .33667 .65301 .33979 .67109 .33225 Metetra
.568 .864 .996 r
.63703 .32656 .61892 .33362 .63608 .33667 .65417 .32931 Metetra
.545 .862 .996 r
.61967 .32397 .60154 .3306 .61892 .33362 .63703 .32656 Metetra
.515 .856 .994 r
.60207 .32148 .58392 .32752 .60154 .3306 .61967 .32397 Metetra
.473 .844 .99 r
.58423 .31902 .56607 .32428 .58392 .32752 .60207 .32148 Metetra
.418 .822 .98 r
.56615 .31647 .54798 .32075 .56607 .32428 .58423 .31902 Metetra
.346 .788 .961 r
.54781 .31371 .52965 .31678 .54798 .32075 .56615 .31647 Metetra
.255 .736 .931 r
.52923 .31055 .51107 .31217 .52965 .31678 .54781 .31371 Metetra
.142 .663 .885 r
.51038 .3068 .49224 .3067 .51107 .31217 .52923 .31055 Metetra
.012 .567 .821 r
.49127 .3022 .47316 .30009 .49224 .3067 .51038 .3068 Metetra
0 .451 .738 r
.47191 .29645 .45385 .29206 .47316 .30009 .49127 .3022 Metetra
.267 0 0 r
.45229 .28921 .4343 .28225 .45385 .29206 .47191 .29645 Metetra
.395 0 0 r
.43243 .28008 .41453 .2703 .4343 .28225 .45229 .28921 Metetra
.502 0 0 r
.41234 .26863 .39457 .25578 .41453 .2703 .43243 .28008 Metetra
.587 .035 0 r
.39204 .25436 .37442 .23827 .39457 .25578 .41234 .26863 Metetra
.649 .123 0 r
.37157 .23675 .35413 .21732 .37442 .23827 .39204 .25436 Metetra
.69 .191 0 r
.35094 .21526 .33372 .19246 .35413 .21732 .37157 .23675 Metetra
.59 .814 .985 r
.86251 .37136 .84436 .37756 .85905 .38243 .87719 .37642 Metetra
.593 .817 .985 r
.84767 .36633 .8295 .37275 .84436 .37756 .86251 .37136 Metetra
.597 .82 .985 r
.83265 .36138 .81448 .36801 .8295 .37275 .84767 .36633 Metetra
.601 .824 .985 r
.81747 .35651 .79928 .36337 .81448 .36801 .83265 .36138 Metetra
.605 .827 .985 r
.80211 .35175 .78391 .35885 .79928 .36337 .81747 .35651 Metetra
.609 .832 .985 r
.78657 .34714 .76836 .35448 .78391 .35885 .80211 .35175 Metetra
.612 .836 .985 r
.77085 .34269 .75263 .35026 .76836 .35448 .78657 .34714 Metetra
.615 .842 .986 r
.75494 .33845 .73671 .34623 .75263 .35026 .77085 .34269 Metetra
.617 .847 .987 r
.73885 .33443 .72061 .34241 .73671 .34623 .75494 .33845 Metetra
.618 .853 .988 r
.72256 .33066 .70431 .3388 .72061 .34241 .73885 .33443 Metetra
.617 .858 .989 r
.70607 .32717 .6878 .33541 .70431 .3388 .72256 .33066 Metetra
.615 .864 .99 r
.68938 .32397 .67109 .33225 .6878 .33541 .70607 .32717 Metetra
.609 .869 .991 r
.67248 .32107 .65417 .32931 .67109 .33225 .68938 .32397 Metetra
.599 .874 .993 r
.65536 .31847 .63703 .32656 .65417 .32931 .67248 .32107 Metetra
.584 .876 .994 r
.63801 .31615 .61967 .32397 .63703 .32656 .65536 .31847 Metetra
.562 .876 .993 r
.62043 .31409 .60207 .32148 .61967 .32397 .63801 .31615 Metetra
.53 .871 .991 r
.60262 .31223 .58423 .31902 .60207 .32148 .62043 .31409 Metetra
.486 .859 .985 r
.58455 .3105 .56615 .31647 .58423 .31902 .60262 .31223 Metetra
.426 .836 .971 r
.56623 .30879 .54781 .31371 .56615 .31647 .58455 .3105 Metetra
.345 .798 .948 r
.54764 .30696 .52923 .31055 .54781 .31371 .56623 .30879 Metetra
.239 .737 .908 r
.52879 .30482 .51038 .3068 .52923 .31055 .54764 .30696 Metetra
.108 .649 .846 r
.50967 .30216 .49127 .3022 .51038 .3068 .52879 .30482 Metetra
0 .533 .759 r
.49028 .29869 .47191 .29645 .49127 .3022 .50967 .30216 Metetra
.204 0 0 r
.47061 .29409 .45229 .28921 .47191 .29645 .49028 .29869 Metetra
.358 0 0 r
.45067 .28795 .43243 .28008 .45229 .28921 .47061 .29409 Metetra
.492 0 0 r
.43048 .27984 .41234 .26863 .43243 .28008 .45067 .28795 Metetra
.6 .032 0 r
.41005 .26924 .39204 .25436 .41234 .26863 .43048 .27984 Metetra
.683 .141 0 r
.38941 .25557 .37157 .23675 .39204 .25436 .41005 .26924 Metetra
.743 .23 0 r
.36857 .23821 .35094 .21526 .37157 .23675 .38941 .25557 Metetra
.588 .811 .985 r
.88089 .36518 .86251 .37136 .87719 .37642 .89556 .37045 Metetra
.592 .814 .984 r
.86606 .35993 .84767 .36633 .86251 .37136 .88089 .36518 Metetra
.596 .817 .984 r
.85105 .35473 .83265 .36138 .84767 .36633 .86606 .35993 Metetra
.601 .82 .984 r
.83587 .34961 .81747 .35651 .83265 .36138 .85105 .35473 Metetra
.606 .824 .984 r
.82052 .34458 .80211 .35175 .81747 .35651 .83587 .34961 Metetra
.61 .828 .983 r
.80499 .33969 .78657 .34714 .80211 .35175 .82052 .34458 Metetra
.615 .833 .983 r
.78928 .33496 .77085 .34269 .78657 .34714 .80499 .33969 Metetra
.62 .838 .984 r
.77339 .33043 .75494 .33845 .77085 .34269 .78928 .33496 Metetra
.624 .844 .984 r
.75731 .32614 .73885 .33443 .75494 .33845 .77339 .33043 Metetra
.627 .85 .984 r
.74103 .32213 .72256 .33066 .73885 .33443 .75731 .32614 Metetra
.63 .857 .985 r
.72456 .31842 .70607 .32717 .72256 .33066 .74103 .32213 Metetra
.631 .864 .986 r
.70788 .31505 .68938 .32397 .70607 .32717 .72456 .31842 Metetra
.63 .871 .987 r
.691 .31204 .67248 .32107 .68938 .32397 .70788 .31505 Metetra
.625 .878 .988 r
.6739 .30943 .65536 .31847 .67248 .32107 .691 .31204 Metetra
.617 .884 .99 r
.65657 .30721 .63801 .31615 .65536 .31847 .6739 .30943 Metetra
.604 .889 .99 r
.63902 .30538 .62043 .31409 .63801 .31615 .65657 .30721 Metetra
.583 .89 .989 r
.62122 .30393 .60262 .31223 .62043 .31409 .63902 .30538 Metetra
.551 .888 .986 r
.60318 .3028 .58455 .3105 .60262 .31223 .62122 .30393 Metetra
.505 .877 .978 r
.58488 .30193 .56623 .30879 .58455 .3105 .60318 .3028 Metetra
.441 .854 .961 r
.56631 .30121 .54764 .30696 .56623 .30879 .58488 .30193 Metetra
.351 .811 .931 r
.54747 .3005 .52879 .30482 .54764 .30696 .56631 .30121 Metetra
.231 .741 .879 r
.52835 .29961 .50967 .30216 .52879 .30482 .54747 .3005 Metetra
.081 .637 .799 r
.50894 .2983 .49028 .29869 .50967 .30216 .52835 .29961 Metetra
.092 0 0 r
.48925 .29627 .47061 .29409 .49028 .29869 .50894 .2983 Metetra
.269 0 0 r
.46926 .29315 .45067 .28795 .47061 .29409 .48925 .29627 Metetra
.432 0 0 r
.449 .2885 .43048 .27984 .45067 .28795 .46926 .29315 Metetra
.566 0 0 r
.42846 .28181 .41005 .26924 .43048 .27984 .449 .2885 Metetra
.671 .119 0 r
.40766 .27249 .38941 .25557 .41005 .26924 .42846 .28181 Metetra
.748 .227 0 r
.38663 .25987 .36857 .23821 .38941 .25557 .40766 .27249 Metetra
.585 .808 .985 r
.8995 .35906 .88089 .36518 .89556 .37045 .91416 .36454 Metetra
.589 .81 .984 r
.88467 .35358 .86606 .35993 .88089 .36518 .8995 .35906 Metetra
.594 .813 .983 r
.86968 .34813 .85105 .35473 .86606 .35993 .88467 .35358 Metetra
.599 .816 .983 r
.85451 .34273 .83587 .34961 .85105 .35473 .86968 .34813 Metetra
.604 .819 .982 r
.83917 .33741 .82052 .34458 .83587 .34961 .85451 .34273 Metetra
.61 .823 .982 r
.82365 .33221 .80499 .33969 .82052 .34458 .83917 .33741 Metetra
.616 .828 .982 r
.80795 .32715 .78928 .33496 .80499 .33969 .82365 .33221 Metetra
.622 .833 .981 r
.79206 .32228 .77339 .33043 .78928 .33496 .80795 .32715 Metetra
.628 .839 .981 r
.77599 .31765 .75731 .32614 .77339 .33043 .79206 .32228 Metetra
.633 .846 .981 r
.75972 .31329 .74103 .32213 .75731 .32614 .77599 .31765 Metetra
.638 .853 .982 r
.74326 .30925 .72456 .31842 .74103 .32213 .75972 .31329 Metetra
.642 .861 .982 r
.7266 .30559 .70788 .31505 .72456 .31842 .74326 .30925 Metetra
.645 .87 .983 r
.70973 .30234 .691 .31204 .70788 .31505 .7266 .30559 Metetra
.646 .878 .984 r
.69265 .29954 .6739 .30943 .691 .31204 .70973 .30234 Metetra
.644 .887 .985 r
.67535 .29723 .65657 .30721 .6739 .30943 .69265 .29954 Metetra
.638 .895 .985 r
.65782 .29543 .63902 .30538 .65657 .30721 .67535 .29723 Metetra
.627 .902 .985 r
.64005 .29415 .62122 .30393 .63902 .30538 .65782 .29543 Metetra
.607 .906 .984 r
.62203 .29338 .60318 .3028 .62122 .30393 .64005 .29415 Metetra
.577 .906 .979 r
.60376 .29309 .58488 .30193 .60318 .3028 .62203 .29338 Metetra
.531 .897 .969 r
.58522 .29322 .56631 .30121 .58488 .30193 .60376 .29309 Metetra
.463 .874 .949 r
.5664 .29367 .54747 .3005 .56631 .30121 .58522 .29322 Metetra
.366 .828 .911 r
.5473 .2943 .52835 .29961 .54747 .3005 .5664 .29367 Metetra
.233 .749 .846 r
.5279 .29491 .50894 .2983 .52835 .29961 .5473 .2943 Metetra
.064 .629 .745 r
.5082 .29525 .48925 .29627 .50894 .2983 .5279 .29491 Metetra
.127 0 0 r
.48819 .29501 .46926 .29315 .48925 .29627 .5082 .29525 Metetra
.318 0 0 r
.46787 .29377 .449 .2885 .46926 .29315 .48819 .29501 Metetra
.484 0 0 r
.44725 .29105 .42846 .28181 .449 .2885 .46787 .29377 Metetra
.616 .056 0 r
.42634 .28628 .40766 .27249 .42846 .28181 .44725 .29105 Metetra
.714 .187 0 r
.40515 .27878 .38663 .25987 .40766 .27249 .42634 .28628 Metetra
.581 .805 .985 r
.91834 .35302 .8995 .35906 .91416 .36454 .93298 .3587 Metetra
.585 .806 .984 r
.90353 .34732 .88467 .35358 .8995 .35906 .91834 .35302 Metetra
.59 .808 .983 r
.88854 .34162 .86968 .34813 .88467 .35358 .90353 .34732 Metetra
.595 .811 .982 r
.87338 .33593 .85451 .34273 .86968 .34813 .88854 .34162 Metetra
.601 .814 .982 r
.85805 .33031 .83917 .33741 .85451 .34273 .87338 .33593 Metetra
.607 .818 .981 r
.84254 .32476 .82365 .33221 .83917 .33741 .85805 .33031 Metetra
.614 .822 .98 r
.82684 .31934 .80795 .32715 .82365 .33221 .84254 .32476 Metetra
.621 .828 .98 r
.81096 .31409 .79206 .32228 .80795 .32715 .82684 .31934 Metetra
.628 .834 .979 r
.7949 .30905 .77599 .31765 .79206 .32228 .81096 .31409 Metetra
.636 .84 .979 r
.77864 .30427 .75972 .31329 .77599 .31765 .7949 .30905 Metetra
.643 .848 .979 r
.76219 .29982 .74326 .30925 .75972 .31329 .77864 .30427 Metetra
.65 .856 .978 r
.74554 .29575 .7266 .30559 .74326 .30925 .76219 .29982 Metetra
.656 .865 .978 r
.72868 .29211 .70973 .30234 .7266 .30559 .74554 .29575 Metetra
.661 .874 .979 r
.71162 .28897 .69265 .29954 .70973 .30234 .72868 .29211 Metetra
.664 .885 .979 r
.69434 .28638 .67535 .29723 .69265 .29954 .71162 .28897 Metetra
.665 .895 .979 r
.67683 .28439 .65782 .29543 .67535 .29723 .69434 .28638 Metetra
.661 .905 .979 r
.65908 .28304 .64005 .29415 .65782 .29543 .67683 .28439 Metetra
.653 .915 .979 r
.6411 .28236 .62203 .29338 .64005 .29415 .65908 .28304 Metetra
.636 .922 .976 r
.62286 .28236 .60376 .29309 .62203 .29338 .6411 .28236 Metetra
.608 .924 .971 r
.60435 .28302 .58522 .29322 .60376 .29309 .62286 .28236 Metetra
.564 .918 .958 r
.58557 .28429 .5664 .29367 .58522 .29322 .60435 .28302 Metetra
.495 .896 .933 r
.5665 .28609 .5473 .2943 .5664 .29367 .58557 .28429 Metetra
.392 .849 .887 r
.54712 .28829 .5279 .29491 .5473 .2943 .5665 .28609 Metetra
.248 .762 .809 r
.52744 .29068 .5082 .29525 .5279 .29491 .54712 .28829 Metetra
.50743 .29303 .48819 .29501 .5082 .29525 .52744 .29068 Metetra
.146 0 0 r
.48709 .29497 .46787 .29377 .48819 .29501 .50743 .29303 Metetra
.346 0 0 r
.46643 .29608 .44725 .29105 .46787 .29377 .48709 .29497 Metetra
.514 0 0 r
.44543 .29583 .42634 .28628 .44725 .29105 .46643 .29608 Metetra
.642 .108 0 r
.42412 .29357 .40515 .27878 .42634 .28628 .44543 .29583 Metetra
.577 .802 .985 r
.93742 .34709 .91834 .35302 .93298 .3587 .95205 .35296 Metetra
.581 .803 .984 r
.92262 .34117 .90353 .34732 .91834 .35302 .93742 .34709 Metetra
.585 .804 .983 r
.90765 .33522 .88854 .34162 .90353 .34732 .92262 .34117 Metetra
.591 .806 .982 r
.8925 .32926 .87338 .33593 .88854 .34162 .90765 .33522 Metetra
.597 .809 .981 r
.87717 .32332 .85805 .33031 .87338 .33593 .8925 .32926 Metetra
.603 .812 .98 r
.86167 .31743 .84254 .32476 .85805 .33031 .87717 .32332 Metetra
.61 .816 .979 r
.84598 .31162 .82684 .31934 .84254 .32476 .86167 .31743 Metetra
.618 .821 .978 r
.8301 .30595 .81096 .31409 .82684 .31934 .84598 .31162 Metetra
.626 .827 .977 r
.81404 .30046 .7949 .30905 .81096 .31409 .8301 .30595 Metetra
.635 .833 .977 r
.79779 .29521 .77864 .30427 .7949 .30905 .81404 .30046 Metetra
.644 .84 .976 r
.78135 .29026 .76219 .29982 .77864 .30427 .79779 .29521 Metetra
.653 .848 .975 r
.76471 .28567 .74554 .29575 .76219 .29982 .78135 .29026 Metetra
.662 .858 .975 r
.74786 .28153 .72868 .29211 .74554 .29575 .76471 .28567 Metetra
.67 .868 .974 r
.73081 .27789 .71162 .28897 .72868 .29211 .74786 .28153 Metetra
.677 .879 .974 r
.71354 .27484 .69434 .28638 .71162 .28897 .73081 .27789 Metetra
.683 .89 .973 r
.69605 .27244 .67683 .28439 .69434 .28638 .71354 .27484 Metetra
.686 .902 .973 r
.67834 .27078 .65908 .28304 .67683 .28439 .69605 .27244 Metetra
.686 .915 .972 r
.66038 .26991 .6411 .28236 .65908 .28304 .67834 .27078 Metetra
.681 .927 .97 r
.64217 .26987 .62286 .28236 .6411 .28236 .66038 .26991 Metetra
.669 .937 .967 r
.6237 .27071 .60435 .28302 .62286 .28236 .64217 .26987 Metetra
.644 .943 .959 r
.60496 .27243 .58557 .28429 .60435 .28302 .6237 .27071 Metetra
.602 .94 .944 r
.58593 .275 .5665 .28609 .58557 .28429 .60496 .27243 Metetra
.535 .92 .915 r
.56659 .27835 .54712 .28829 .5665 .28609 .58593 .275 Metetra
.43 .872 .861 r
.54694 .28237 .52744 .29068 .54712 .28829 .56659 .27835 Metetra
.277 .778 .769 r
.52696 .28687 .50743 .29303 .52744 .29068 .54694 .28237 Metetra
.50664 .2916 .48709 .29497 .50743 .29303 .52696 .28687 Metetra
.144 0 0 r
.48596 .29619 .46643 .29608 .48709 .29497 .50664 .2916 Metetra
.352 0 0 r
.46492 .30019 .44543 .29583 .46643 .29608 .48596 .29619 Metetra
.521 0 0 r
.44353 .30303 .42412 .29357 .44543 .29583 .46492 .30019 Metetra
.572 .799 .985 r
.95676 .34127 .93742 .34709 .95205 .35296 .97137 .34731 Metetra
.575 .799 .984 r
.94197 .33515 .92262 .34117 .93742 .34709 .95676 .34127 Metetra
.58 .8 .983 r
.92701 .32897 .90765 .33522 .92262 .34117 .94197 .33515 Metetra
.585 .802 .982 r
.91187 .32275 .8925 .32926 .90765 .33522 .92701 .32897 Metetra
.591 .804 .981 r
.89655 .3165 .87717 .32332 .8925 .32926 .91187 .32275 Metetra
.597 .807 .98 r
.88105 .31026 .86167 .31743 .87717 .32332 .89655 .3165 Metetra
.605 .81 .979 r
.86537 .30407 .84598 .31162 .86167 .31743 .88105 .31026 Metetra
.613 .814 .977 r
.8495 .29796 .8301 .30595 .84598 .31162 .86537 .30407 Metetra
.622 .819 .976 r
.83344 .29199 .81404 .30046 .8301 .30595 .8495 .29796 Metetra
.631 .825 .975 r
.81719 .28622 .79779 .29521 .81404 .30046 .83344 .29199 Metetra
.641 .832 .974 r
.80075 .28071 .78135 .29026 .79779 .29521 .81719 .28622 Metetra
.652 .84 .972 r
.78411 .27553 .76471 .28567 .78135 .29026 .80075 .28071 Metetra
.663 .848 .971 r
.76727 .27077 .74786 .28153 .76471 .28567 .78411 .27553 Metetra
.673 .858 .97 r
.75023 .2665 .73081 .27789 .74786 .28153 .76727 .27077 Metetra
.684 .869 .969 r
.73297 .26282 .71354 .27484 .73081 .27789 .75023 .2665 Metetra
.694 .882 .968 r
.7155 .25983 .69605 .27244 .71354 .27484 .73297 .26282 Metetra
.702 .895 .967 r
.6978 .25761 .67834 .27078 .69605 .27244 .7155 .25983 Metetra
.709 .909 .965 r
.67987 .25627 .66038 .26991 .67834 .27078 .6978 .25761 Metetra
.713 .923 .963 r
.6617 .25588 .64217 .26987 .66038 .26991 .67987 .25627 Metetra
.712 .937 .96 r
.64327 .25654 .6237 .27071 .64217 .26987 .6617 .25588 Metetra
.703 .95 .955 r
.62456 .25829 .60496 .27243 .6237 .27071 .64327 .25654 Metetra
.684 .959 .945 r
.60558 .26117 .58593 .275 .60496 .27243 .62456 .25829 Metetra
.647 .96 .927 r
.58629 .26519 .56659 .27835 .58593 .275 .60558 .26117 Metetra
.583 .944 .893 r
.56669 .27031 .54694 .28237 .56659 .27835 .58629 .26519 Metetra
.479 .897 .832 r
.54676 .27642 .52696 .28687 .54694 .28237 .56669 .27031 Metetra
.322 .8 .728 r
.52647 .28337 .50664 .2916 .52696 .28687 .54676 .27642 Metetra
.50582 .2909 .48596 .29619 .50664 .2916 .52647 .28337 Metetra
.119 0 0 r
.48478 .29866 .46492 .30019 .48596 .29619 .50582 .2909 Metetra
.335 0 0 r
.46336 .30617 .44353 .30303 .46492 .30019 .48478 .29866 Metetra
.567 .796 .986 r
.97634 .33557 .95676 .34127 .97137 .34731 .99094 .34176 Metetra
.57 .796 .985 r
.96157 .32928 .94197 .33515 .95676 .34127 .97634 .33557 Metetra
.574 .797 .984 r
.94662 .32289 .92701 .32897 .94197 .33515 .96157 .32928 Metetra
.578 .797 .982 r
.9315 .31642 .91187 .32275 .92701 .32897 .94662 .32289 Metetra
.584 .799 .981 r
.91619 .30988 .89655 .3165 .91187 .32275 .9315 .31642 Metetra
.59 .801 .98 r
.9007 .30331 .88105 .31026 .89655 .3165 .91619 .30988 Metetra
.598 .803 .979 r
.88502 .29674 .86537 .30407 .88105 .31026 .9007 .30331 Metetra
.606 .807 .977 r
.86915 .2902 .8495 .29796 .86537 .30407 .88502 .29674 Metetra
.615 .811 .975 r
.8531 .28375 .83344 .29199 .8495 .29796 .86915 .2902 Metetra
.625 .816 .974 r
.83685 .27743 .81719 .28622 .83344 .29199 .8531 .28375 Metetra
.636 .822 .972 r
.82041 .27132 .80075 .28071 .81719 .28622 .83685 .27743 Metetra
.647 .829 .97 r
.80377 .26549 .78411 .27553 .80075 .28071 .82041 .27132 Metetra
.659 .838 .969 r
.78693 .26002 .76727 .27077 .78411 .27553 .80377 .26549 Metetra
.672 .847 .967 r
.76989 .25502 .75023 .2665 .76727 .27077 .78693 .26002 Metetra
.685 .858 .965 r
.75264 .25057 .73297 .26282 .75023 .2665 .76989 .25502 Metetra
.698 .87 .963 r
.73518 .24679 .7155 .25983 .73297 .26282 .75264 .25057 Metetra
.71 .883 .961 r
.7175 .24381 .6978 .25761 .7155 .25983 .73518 .24679 Metetra
.722 .898 .959 r
.69958 .24173 .67987 .25627 .6978 .25761 .7175 .24381 Metetra
.732 .913 .956 r
.68144 .24069 .6617 .25588 .67987 .25627 .69958 .24173 Metetra
.74 .929 .952 r
.66304 .24079 .64327 .25654 .6617 .25588 .68144 .24069 Metetra
.743 .946 .947 r
.64438 .24216 .62456 .25829 .64327 .25654 .66304 .24079 Metetra
.739 .961 .94 r
.62544 .24488 .60558 .26117 .62456 .25829 .64438 .24216 Metetra
.725 .973 .927 r
.60621 .24903 .58629 .26519 .60558 .26117 .62544 .24488 Metetra
.695 .977 .906 r
.58667 .25465 .56669 .27031 .58629 .26519 .60621 .24903 Metetra
.637 .965 .868 r
.56679 .26175 .54676 .27642 .56669 .27031 .58667 .25465 Metetra
.537 .921 .8 r
.54657 .27024 .52647 .28337 .54676 .27642 .56679 .26175 Metetra
.382 .824 .688 r
.52597 .28001 .50582 .2909 .52647 .28337 .54657 .27024 Metetra
.50497 .29082 .48478 .29866 .50582 .2909 .52597 .28001 Metetra
.072 0 0 r
.48357 .30233 .46336 .30617 .48478 .29866 .50497 .29082 Metetra
0 g
.25 Mabswid
.48415 0 m
.48355 .31002 L
s
.48355 .31002 m
0 .4861 L
s
0 .4861 m
.01705 .22471 L
s
.01705 .22471 m
.48415 0 L
s
.48415 0 m
.48355 .31002 L
s
.48355 .31002 m
1 .47942 L
s
1 .47942 m
.98267 .21613 L
s
.98267 .21613 m
.48415 0 L
s
.48415 0 m
.98267 .21613 L
s
.48415 0 m
.48414 .00628 L
s
[(0)] .48417 -0.01255 -0.00192 1 Mshowa
.62694 .06191 m
.62705 .06818 L
s
[(0.5)] .62672 .04935 .0179 1 Mshowa
.7565 .11808 m
.75672 .12435 L
s
[(1)] .75605 .10553 .03559 1 Mshowa
.87459 .16927 m
.87491 .17554 L
s
[(1.5)] .87394 .15674 .05149 1 Mshowa
.98267 .21613 m
.98308 .22239 L
s
[(2)] .98184 .2036 .06584 1 Mshowa
.125 Mabswid
.51386 .01288 m
.51387 .01665 L
s
.54298 .02551 m
.543 .02927 L
s
.57152 .03788 m
.57156 .04164 L
s
.5995 .05001 m
.59956 .05378 L
s
.65385 .07357 m
.65393 .07734 L
s
.68025 .08502 m
.68034 .08878 L
s
.70614 .09624 m
.70625 .10001 L
s
.73156 .10726 m
.73168 .11103 L
s
.78099 .12869 m
.78113 .13245 L
s
.80503 .13911 m
.80518 .14288 L
s
.82863 .14935 m
.8288 .15311 L
s
.85182 .1594 m
.852 .16316 L
s
.89696 .17897 m
.89717 .18273 L
s
.91895 .1885 m
.91916 .19226 L
s
.94055 .19787 m
.94078 .20163 L
s
.96179 .20708 m
.96203 .21083 L
s
gsave
.75382 .04281 -66.178 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{288, 173.625},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000fA000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00Vgoo1000bGoo002JOol00`00Oomoo`02Ool00`00Oomoo`36Ool009Yoo`03001o
ogoo009oo`03001oogoo0<Ioo`00VWoo00<007ooOol00Woo00<007ooOol0aWoo002JOol00`00Oomo
o`02Ool00`00Oomoo`36Ool009Yoo`03001oogoo009oo`03001oogoo0<Ioo`00VWoo00<007ooOol0
0Woo00<007ooOol0aWoo002KOol40039Ool00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00
ogooJGoo003oOomYOol00?moofUoo`00W7oo0`00bGoo002JOol200000goo001oo`020037Ool0071o
o`@000Eoo`8000Aoo`D001Aoo`8000=oo`04001oogooOol2001?Ool20002Ool2001`Ool006moo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`05001oogooOol0000BOol20005Ool00`00Oomoo`03
Ool3001=Ool01000Oomoo`00LGoo001:Ool3000ROol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00
Oomoo`0AOol20007Ool00`00Oomoo`06Ool2001<Ool2001bOol004Uoo`05001oogooOol0000QOol0
0`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0>Ool30008Ool00`00Oomoo`07Ool3000GOol4
0005Ool20005Ool4000OOol2001bOol004Uoo`03001oogoo02=oo`03001oogoo009oo`03001oogoo
00]oo`03001oogoo00]oo`80009oo`03001oogoo00Ioo`03001oogoo00Yoo`<001=oo`03001oogoo
009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo01]oo`04001oogoo001aOol0
04Uoo`03001oogoo02=oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00Qoo`8000eoo`03
001oogoo00eoo`80015oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo01Yoo`80009oo`80
071oo`00BGoo00<007ooOol08goo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Qo
o`8000moo`03001oogoo00moo`8000moo`03001oogoo009oo`03001oogoo00eoo`03001oogoo091o
o`00B7oo1@008goo100037oo0`001goo0P004Goo00<007ooOol047oo100037oo00<007ooOol00Woo
00<007ooOol02Goo1000Tgoo0019Ool00`00Oomoo`0lOol200000goo001oo`0@Ool00`00Oomoo`0D
Ool2000:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`2DOol008Ioo`8001Eoo`03001o
ogoo01Ioo`8000Qoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo09Aoo`00Pgoo0`005goo
00<007ooOol067oo0`001Woo100037oo1@00TWoo0021Ool2000JOol00`00Oomoo`0JOol3002[Ool0
07moo`800003Ool007oo01Uoo`03001oogoo01eoo`800:Uoo`00OGoo0P007Woo00<007ooOol07goo
0`00YWoo001kOol2000POol00`00Oomoo`0ROol2002TOol007Uoo`80029oo`03001oogoo02=oo`<0
0:9oo`00D7oo10001Goo0P001goo0`004Woo0P0000=oo`00Ool08Goo00<007ooOol09Woo0`00Wgoo
001?Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`0?Ool20003Ool00`00Oomo
o`0POol00`00Oomoo`0YOol2002MOol004moo`03001oogoo009oo`03001oogoo00aoo`03001oogoo
00eoo`8002Qoo`03001oogoo02]oo`8009]oo`00Cgoo00<007ooOol00Woo00<007ooOol027oo1P00
37oo0P00:Woo00<007ooOol0;7oo1000V7oo001?Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000
Oomoo`002goo0`00:goo00<007ooOol0;7oo00@007ooOomoo`8009Ioo`00Cgoo00<007ooOol00Woo
00<007ooOol02Goo00@007ooOol000Uoo`8002ioo`03001oogoo039oo`80021oo`D006moo`00Cgoo
00<007ooOol00Woo00<007ooOol02Woo00<007oo00001Woo0`00<7oo00<007ooOol0=7oo0`007goo
00<007ooOol0Kgoo001@Ool4000>Ool20004Ool2000cOol00`00Oomoo`0eOol01000Ool000007Goo
00<007ooOol0Kgoo001VOol200000goo001oo`0bOol00`00Oomoo`0iOol2000KOol00`00Oomoo`1_
Ool006Aoo`8003Moo`03001oogoo03]oo`<001Qoo`03001oogoo06moo`00HWoo0P00>Goo00<007oo
Ool0?Goo0`005Woo00<007ooOol0Kgoo001POol2000kOol00`00Oomoo`0mOol00`00Oomoo`02000B
Ool3001aOol005ioo`800003Ool007oo03Yoo`03001oogoo049oo`<0015oo`03001oogoo06moo`00
G7oo0P00?goo00<007ooOol0AGoo0P00PGoo000bOol40005Ool20006Ool3000DOol20011Ool00`00
Oomoo`16Ool3001oOol0035oo`03001oogoo009oo`03001oogoo009oo`8000Eoo`05001oogooOol0
000AOol20013Ool00`00Oomoo`16Ool00`00Oomoo`03001lOol0035oo`03001oogoo009oo`03001o
ogoo00Uoo`05001oogooOol0000?Ool200000goo001oo`12Ool00`00Oomoo`1<Ool2001jOol0035o
o`03001oogoo009oo`03001oogoo00Uoo`05001oogooOol0000=Ool20003Ool00`00Oomoo`11Ool0
0`00Oomoo`1>Ool2001hOol0035oo`03001oogoo009oo`03001oogoo00Uoo`@000]oo`<004Uoo`03
001oogoo04ioo`04001oo`00001fOol0035oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00Yoo`<004]oo`03001oogoo059oo`<007=oo`00<Goo00<007ooOol00Woo00<007ooOol02Woo00<0
07ooOol01goo0P000Woo00<007ooOol0BGoo00<007ooOol0EGoo0P00LGoo000bOol4000>Ool30004
Ool2001@Ool00`00Oomoo`1FOol3001_Ool004Uoo`8000Eoo`@004Uoo`03001oogoo05Ioo`03001o
ogoo00<001Ioo`D000Aoo`8000Eoo`@0049oo`00Agoo0P0000=oo`000000100000<f6SHK=QX00`00
Agoo00<007ooOol0G7oo0P005Woo00<007ooOol017oo0P0017oo00<007ooOol00Woo00<007ooOol0
?goo0015Ool20002Ool200002d9JAU/003HK<OXf6cHJ=Q/0027J8KX00P00AGoo00<007ooOol0GWoo
0P0057oo00<007ooOol03goo00<007ooOol0?goo0013Ool20002Ool200001dIJ@UY6FT9JAUX003HK
00<f6P03=Q/0026j008Q^P8004=oo`03001oogoo05ioo`03001oo`000080015oo`03001oogoo00mo
o`03001oogoo03moo`00@Goo0P000goo01@004ij0012FTIK@UY6Fd9JAU/003HK<OXf6cHJ=Q/0027J
8KX000Dh0P00@Goo00<007ooOol0Hgoo0P003goo00<007ooOol02goo1000@Woo000oOol200004Goo
001oogoo001>NTjJCWX0049JAUY2FTIJ@UY6FP00=Q/00cHJ00P0026j8KXQ^P001CP9>@00@7oo00<0
07ooOol0IGoo0P003Goo00<007ooOol02goo00<007ooOol0@goo000FOol40005Ool20005Ool4000C
Ool20005Ool06P00CWYBVTiiDYY>NP00@UY6Fd9JAU]2FP00=QXf6c7j=Q/f6P007KXQfR6j0005>0UI
000oOol00`00Oomoo`1VOol40008Ool3000=Ool00`00Oomoo`13Ool001Eoo`03001oogoo009oo`03
001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00ioo`8000Ioo`0A001>NTjJCWY>VTij
CYY>NP00@UY6FT9JAUY2FP00=QXf6`03=QX01P008KXQ^P002ET5>08003ioo`03001oogoo06Yoo`80
00Qoo`03001oogoo00]oo`D0045oo`005Goo00<007ooOol00Woo00<007ooOol027oo00<007ooOol0
0Woo00<007ooOol037oo0`001Woo01`004ijDYY>NE:JCWYBVTiiDYY>NP00@UY6Fd9JAU]2FP00=QXf
6c7j=Q/0026j7KXQfP002ET5>08003eoo`03001oogoo06aoo`8005Yoo`005Goo00<007ooOol00Woo
00<007ooOol027oo00<007ooOol00Woo00<007ooOol02Goo0`000Woo00<007ooOol00goo010005Ji
001>NTjJCWY>VTijCYY>NTjJCWX0049JAUY2FPT0008Q^P030009F@Dh008003aoo`03001oogoo06eo
o`@005Moo`005Goo00<007ooOol00Woo00<007ooOol02Goo10002Woo0P002Woo00h005JIF[YFV@00
CWYBVTiiDYY>NU:JCWUBVTij0`0000Pn>SiK>SX002gj;Q/YnRhK100000D5>0UI0000]P0003]oo`03
001oogoo06ioo`03001oogoo008005Eoo`005Goo00<007ooOol00Woo00<007ooOol027oo00<007oo
Ool00Woo00<007ooOol01Goo0`002Woo00d005JiE[YF^EJjE[T004ijCYY>NTjJCWY>VP02000034Yj
000n>ciK?S/nFchk000]nbhK;O/0008I^P8000051CT9F@000;H0000jOol00`00Oomoo`1cOol2001C
Ool001Eoo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo00=oo`80009o
o`03001oogoo00Qoo`0O001J^UJIF[YFVEZjEYT004ijDYY>NE:J001:NdIjBY]:NP00>SXnFchj?U/0
02hK;OX^6bWj000EVQVk5IX00P0000@9F@000;H003Uoo`03001oogoo07Eoo`<0051oo`005Woo1000
37oo100017oo0P003Woo00/005JjE[UF^UJiE[YF^EJjE[T004ij0080000<BW]:NTYkBWY:NdYj000n
>ciK?S/nF`000Rgk00<^6bgk00000QVj00DIVP000000002f008003Qoo`03001oogoo07Eoo`03001o
ogoo008004ioo`00;7oo0P003goo02L005ZjEYUJ^UJIF[YFVEZjEYUJ^UJI001:NTYkAWY:VdYjBW]6
NTZK000nFcXj?U/n>SiK000^6bgj;Q/001Vk5IXI^`001CT1>00009D00P00=goo00<007ooOol0NWoo
0P00C7oo000ZOol200000goo001oo`0=Ool03@00G]T00000E[UF^UJiE[YF^EJjE[T005:J0080000>
BW]:NTYkBWY:NdYjBW/003iK?S/nFchk?U/0008]n`03;Q/001Vj008I^P050001>@4i0000]P02000f
Ool00`00Oomoo`1lOol3000MOol5000WOol002Qoo`80015oo`0:001NfEZiG]YN^@00EYUJ^UJIF[X2
00007e:JD[YBVUJk001:NdIjBY]:NTYkAWY:V`00?U/j>SiK?SX002Wj;Q/]nRhK000I^aFJ6K/000Di
0CP0002E008003Eoo`03001oogoo07eoo`04001oo`00000KOol01@00Oomoogoo00009goo000VOol2
000COol00`00G]UNf@03G]T2000045Jj001B^U:JD[YBVU:jDYYB^P00BW]:NTYkBWY:NdYj2@0000<]
n`006IX00aVj00<0004i00000P0000<0<@00Ool0<goo00<007ooOol0OGoo00@007ooOomoo`8001Yo
o`03001oogoo02Qoo`0017oo1@006goo0`004goo01<005ZiG]YN^EkIF[UNfUjiG]T005JkDYYB^U:J
E[]BVU:jDYYF^`0200003DIjBY/00000@U]6N`00>S`f>cYL=S/002Gk00@000076K/EVP000AP5>@00
0;H00P00=7oo00<007ooOol0Pgoo0`0067oo00<007ooOol09goo0006Ool00`00Oomoo`0IOol20002
Ool00`00Oomoo`0@Ool00`00G]UNf@06G]T03@00F]X00000DYYB^U:JD[YBVU:jDYYB^U:J00800006
AW]2NdIk@W]6N`0013Hk00@002Gk9O/Un`D000040CP1>@000;H2000cOol00`00Oomoo`24Ool01000
Ool000005goo00<007ooOol09Woo0006Ool00`00Oomoo`0GOol2000FOol0:`00F[UNfUjiG]UJ^EkJ
G[UNfEZi001J^E[JE[T005:JD[YBVUJkDYYB^U:J001>VP00@U]6Nd9kAW]2FdIk000j?3Hk>U`f>`00
9O/Yo2Gk000=VQ6k008000040AP5>@000;H2000bOol00`00Oomoo`28Ool2000FOol00`00Oomoo`0U
Ool000Ioo`03001oogoo01Aoo`<001Qoo`03001NfEkI00INf@0;001J^U[JF[YJfUZj001BVU:jDYYB
^P0200002TjJCY]>V`00@W]6Nd9kAW]2N`0013Hk00<002Gk9O/00RGk00@0016J4IXAVP<000040;D0
]P00000aOol00`00Oomoo`2:Ool3000?Ool01@00Oomoogoo00009goo0006Ool00`00Oomoo`0BOol2
0002Ool00`00Oomoo`0EOol200003ejiG]UJ^EkJG[UNfEZi001J^E[JE[UJfUZiF]YF^@02000055:j
001>^djJCY]:VTjkCYX0049KAW]2NdIk@U/003Hk>S`f>cYL00029O/01RWl9O/000fJ4K/AVP<00003
09D00000035oo`03001oogoo08]oo`04001oo`00000>Ool3000XOol000Ioo`03001oogoo011oo`80
00Aoo`03001oogoo01Aoo`03001RnF;I008000ANf@0>001J^U[JF[YJfUZjF]YJ^U[JF[YJfP00CY]>
VP=>V`0:CYY>VdjK0012NdIk@W]6Nd9k0004=S/00`009O/Un`029O/020004IXAVQ6J0001>0000;D2
000`Ool00`00Oomoo`2;Ool01000Oomoogoo0P00=goo0004Ool3000@Ool2000MOol01@00H]URnF;H
I_T00P0001]J^EkJ001JfUJiF]YJ^E[JE[UJfUZiF]X005KK001>VdZJC[]>VTjKBYY>^djJ0012FdIk
@W/02P0000XYo2Gk000=VQ6k0001>@4H0000U@8002moo`03001oogoo095oo`<003Aoo`001Woo00<0
07ooOol037oo0P0000=oo`00Ool06goo00<006;IH_T00V;i00=RfF;iH_T00P0000YJfUZjF]YJ^U[J
F[YJfUZjF]X000=F^P03001>VdjJ00=>V`03CYY>VdjK00<00004?U/nO3iK0002<S`0138k<S`0027l
1@0000@AVP000CT1>0@002ioo`03001oogoo099oo`04001oo`00000HOol5000EOol001=oo`80021o
o`0:001RnF;HI_URfF;iH]QVn@00H_X200001EZiF]YF^E[JF[T00P0000EFfeJjE]]B^UKK00800004
BYY>^djJCY/200004DJK000nFd9l?U/nO3iK000^>c8l;Q/b?0008O`Mfb7l7M/0100000<1>@000;H0
0`00;Goo00<007ooOol0TWoo00@007ooOomoo`8001Qoo`03001oogoo01Eoo`004Goo0P008Goo00D0
06;iH_URnF;I00=Rn@05H]T005kIG_YNf@0200000e[JF[X00009E[X01000CYX0000014ZK00L003iK
?W`nFcil?U/00002<S`02C8k<S`0027l7O/Qnagk0009VP0200000`4i0000]P03000/Ool00`00Oomo
o`2HOol3000EOol00`00Oomoo`0EOol000moo`800003Ool007oo021oo`0?001Rf6KiH]URnF;HI_UR
f@00G]URnUkIH_YNfF;j0080000ZD[YFfeJjE]]B^UKKE[YFfe:jE]]F^P00AW]:W4JKBYa6NdZLAY/0
03iK@W`nFcil?U/002hk<S`^6c8l000Qo1gK8O`Mf`002IX=^`000CT0002f0P00;7oo00<007ooOol0
VGoo00@007oo000000Qoo`H000Eoo`03001oogoo01Eoo`003Goo0P0097oo00@006;iH_URf@=Rn@04
H]T005kIG_X3G]T015kjG]T005[J0P0025Jj00<005:k00001dZK00L003iK?W`nFcil?U/00002<S`0
2S8k<S`0027l7O/Qn`003I/9VPfK0`0000<0]P000000:goo00<007ooOol0VGoo00@007ooOomoo`80
015oo`03001oogoo01Eoo`002goo0P009Woo01@006KiH]URnF;HI_URf@00G]URnUkIH_YNfF;jG]T0
05[JG_YJfUkJ0P0000AF^UKKD[YFf`80000?C[YB^djk0016NdZLAY]:W4IkBYa6V`00?U]2O3iK00D0
000:;Q/b?0008O`Mfb7l000=V`VJ3K/20000102e0;H00000:Woo00<007ooOol0Wgoo0P003goo00<0
07ooOol05Goo0009Ool3000VOol40002H_T016;IH_T005kj0ekI00ENnUkI001JfUkJ00=JfP06G]YJ
fP00001F^P001U:k0P001DZK100000DjG3Yl>U`002Xl00H000098O/000fK2IX0004i0000]@2f0080
02Uoo`03001oogoo09aoo`<00003Ool007oo00aoo`<001Moo`001goo0P00:7oo00D006/II_Q[6FKh
00D0000MG]URnUkIH_YNfF;j001NnU[JG]YJfUkjF]YNfU[JG_X005:kC[YB^djkD[]>^U:kC[]B^`00
BYa6V`0200003dJL@W/003IL>W`fG3Yl=U`002XL;S`Z72hl000Mo00400000`VJ0001>00300000`0b
001oo`0WOol00`00Oomoo`2IOol30004Ool00`00Oomoo`0=Ool00`00Oomoo`0EOol000Eoo`8002Yo
o`0:001Vn6LII_UW6FKhIaT006KiH_T30002G]T00`00G]YJfP02F]X01ekJF]YJfU[JG]X005KK0080
00QB^`800006@Ya6W49lAYa2W0000cYL00DjO3YL000002hl008Z?004000Io1Wk6O`400000`4i0000
0003000WOol00`00Oomoo`2FOol30005Ool3000WOol000Eoo`03001oo`00008002Ioo`0>001Vn6/I
I_Q[6FKhJaUVn000H_UW6F;iIaYRn@<0000CF]YNfU[JG_YJfUkJF]YNnP00F]]F^U[KE]X004jjD[]>
^e:kC[X00P0000Q>_000AYa2NdJL@W]6W49k0P0000ljO3IL>W`fG3Yl000^?2XL;S`001gl6M/Mo000
2K/00P0000<1>00000000`009Woo00<007ooOol0Tgoo0`002Woo00<007ooOol09Goo0005Ool00`00
Oomoo`02Ool4000ROol02000IaUVnFLII_QW6FKi0003H_T01VKiH_URn@00H_YNnP80000<G]YJfU[J
F]YNfP00E]]FfU[KE]YFfeKJ0P0000AB^`00001:^`9>^`0:C[`004JL@Ya6W49lAYa2W4JL0002>U`0
1CYl>U`jG000;S`00RXl00L001Wl6O/Io0002K/5VP0200000`4i00000002000UOol00`00Oomoo`2@
Ool3000=Ool00`00Oomoo`0UOol000Eoo`03001oogoo00Ioo`<001ioo`0D001[6FKhJaUVn6/II_Q[
6@00IaURnFLJH_UW6F;i001NnF;jG_URnP80000DF]YNnP00F]]F^U[KE]YJfeJjF]]FfU[K001>_4ZK
C[a:VdjlBY]>_080000:@W]6W49kAYa2NdJL000jO3IL>W`5000022hl000Mo1WK0005VPVk1IX7000T
Ool00`00Oomoo`2=Ool3000?Ool2000WOol000Eoo`03001oogoo00Uoo`<001]oo`08001VnFLII_QW
6FKiIaT0009Rn@06I_URnF;iH_T005kj0f;j00=NnV;jH_X00P0000]FfeKJF]]FfUKKE]YJfeKJE]/0
05KK00800003C[]>_4Zk009>^`07C[a:^`00@Ya6W49lAY`01@0000DfGC9L=U`002Hm00@000076O/0
00FK2K/5VP000ET00`0000=L`000Ool08Woo00<007ooOol0RWoo0`004goo00<007ooOol09Goo0005
Ool00`00Oomoo`0<Ool3000GOol06@00I_Q[6FKhJaUVn6/II_P006;iIaYRnFLIH_T005kiH_YNnF;j
G_URnUkiH_X005kk00800005E]YJfeJjF]]FfP0200002eKLD[]Ffe:k001:VdjlBY]>_4ZKC[`01@00
00e2WCil@Yd003Im<U`fOC9L=Wd002Hm9Q`Z?@0400001PFJ2K/5VP000CT1F@800003F<0007oo025o
o`03001oogoo03Eoo``004Ioo`<001Ioo`03001oogoo02Eoo`001Goo00<007ooOol03goo10004goo
00X006LII_QW6FKiIaUVn000H_UVn@=Rn@03I_T006;j009RnP05G_YRnV;jH_X00004G_X200001E[K
E]X005;KE]/00e;K00IFfe;K000004jlB[/200004DZlAY`00000?Y`nO3jL?W`nW000=U`bG3IM<U`f
G0009Sd00RHl00<001Gl00000P0000<9^`FJ00000P5I0P0000=L`000Ool087oo00<007ooOol0;goo
1P000Unm00D005^MGkeO_Enn00800003FieOWU^M00/003Qoo`<001Yoo`03001oogoo02Aoo`001Goo
00<007ooOol04goo0`003goo01h006/II_Q[6FKhJaUVn6/I001W6V;iIaURnFLJ001RnUkiH_YNnF;j
G_URnP00G_]JfUkkF]YNne[JG_/200002U:kE]aB^eKKD[]Fg5:kE]]B^eKL0P0000a6VdZlAYa:_4JK
B[`004:M?Wa2WCil@Yd200002c9L=WdbG3Im000V?BHL:Sd001Wl5M/01@0000H1>@5I000005S0000P
Ool00`00Oomoo`0YOol600004U^m001K_EoNFkeOgU^m001KWEnnFieO_P00GiiKWEnnFieOWP800009
FgeKWU]mFiiKO@00EgeKWUMm00D0031oo`<001]oo`<002Ioo`001Goo00<007ooOol05Woo0`0037oo
2P000V;i00=VnF;i00000V;j00INnV;jH_YRnUkj0007G_X01000F]/000000U;K01eFfe;KD]]BfeKK
001>g000B[a6W4ZlA[a:_4JLB[`003jL?W`nW3il?Y`nO000<U`fGC9L=U`002Hm008V?004000Eo1Gl
00021K/300000`5I00000003000NOol00`00Oomoo`0TOol500000e_M001Og@02Gmd00e_M001O_@03
Gkd200003E^MGkeO_Enn001KWU^MGiiKWE^N001KWU]m00=KWP05Fgd005]nFgiGOP03Fgh00`00EgiG
OP03000ZOol3000POol00`00Oomoo`0TOol000Aoo`03001oogoo01Yoo`@000Qoo`0:001[>F/HKcU[
66/i001[>FLIJaT700005V;jG_URnUki001JfUkkF]YNne[JG_]JfP00E]YJne[JF_/005KLD[]Ffe:k
0P0000]Bg4jkD]`004ZlAY]:_4JLB[a6VdZl00800003?Wa2WCil00X00004:Sd001Wl5M/200000`Fk
1IX00003000015cP000000007Goo00<007ooOol08Goo100000QKg5_MFmaOo@00GmeK_EoM0P0000UK
_EoNFkeOgP00GkiKWEnnFid00P0000AOWU^MGkiKW@800005FiiKOE^NFgeKWP0200003EMmFiiGOE^N
EgeKWP00FgiGGE]nEeeKOUMM00@002=oo`<002=oo`03001oogoo02Aoo`0017oo00<007ooOol07Woo
0`0017oo00P006/IJaQ[>F/HJaU[60000fLI00M[6FLI001W6FLJHaUW6P050006G_X01`00F]]Jne[K
F_]Jfe[k00800008D]/004jkC]a>_5;LC[]>g0800006AYa:_4JlB[a6W4Zl100000HjOCZM>W`002iM
<Ud2;Ud00`008Sd0000400001QGl0005^`Fk0001N@800004G<000000000LOol00`00Oomoo`0NOol3
0002Em`01000FmaKgE_M0P000eoM00<005nmGkd00enm00<005nnFid02`0000EKOE^NFiiKWP0000=K
OP03EgiKOU]n008000IGOP80009GGP03Egh00000008001aoo`<002Ioo`03001oogoo02Aoo`0017oo
00<007ooOol08Goo0`0001Qoo`00JaQ_>F/HJcU[6000IaU[6FLIJcUW6F/I001W6V;iIaYRnFLJH_T0
05kjHaX300006EkkF]X005KJF_]JfU[kE]YJne[JF_]FfP00C[]Bg4jkD]a>^e;LC[]Bg4jk0016VdZl
00<0000CA[e2W000>W`nWCYl>YdjO000;U`bOBiL<Wd002Hm8Q`V?@005Q`0100000H5VP00000005S0
G>04000JOol00`00Oomoo`0JOol500002UOLEo`00000FmaKgE_L001K_EoM300000]GW@00EieK_UNM
FkiGW@00EieKWUNN00H0000;FiiGOE^NEgd005MMFgiGGE]nEeeKOP0200001EMNEgiCGEMnEeh00P00
00=GGU=N00000P005Woo0`009goo0`009Woo0004Ool00`00Oomoo`0TOol02000JaQ[>F/HJaU[66/i
0002IaT04F/IIaUW6@00IaYS6FLJIaUW6V<I001RnV<JH_YS6V;jHaX00P0000]Jfe[kF]]Jne[KF_]J
fe[kF]/005KK00800007D]a>^dkLC[aBg4jkC]`00`0000a6_4:LA[e2W4Jl@Y`003Yl>YdjOCZM>W`2
00000c9M;Ud^G@0200001R8l8Sd001Gl4O`Eo0H0009L`0@001Uoo`03001oogoo01Qoo`80009?f`07
001Gg5OLEm`005_MFm`01P0000IGg@00EkiG_E_NEkd200002e^nFkeK_U^n001KWU^nFiiK_U^N0000
0U^N00=GWU^NFih00P000UNN00=KWP00000010000eMn0P0000iGOUMNEeiGGUMnEeh005=NEeiCGUMN
DeiGGU=N10003goo0`00;7oo00<007ooOol02goo10001Goo0P001Goo10001Goo0004Ool00`00Oomo
o`0TOol07@00KcU[66/iJaQ_>@00JaUW6F/iIaU[6@00IaYRnFLJH_UW6V;i001NnV<JG_YS6UkjHaYN
nP00F_X00P0000EJneKJF_]JfU[k00800004E]]Fo5;KE_`200000djkD]a>^`0200002TkLB[`00000
A[e2W4Jm@Ya6_D:L0P0000dnWCYl>YdjO3jM000bOBiL<Wd^G0008Q`V?@0200001A7l5Qd000GL1K/0
100000=Lh00000000`005goo00<007ooOol05Woo0P0000ICfdoJDm/005_lEm`700003UNmEmeC_EON
001KgUNmFmiG_@00EieK_UNmFkh2000015NMFkiGWE^n0P0000aGWE^NEiiKWUNM001GOU^NEgeKWUMn
Fih20002Egh00eMm00000003000015MNEgiCGEMn0P0000MCGEMNDeiGGU=MEeiCGP0200000e=NDciC
GP040008Ool3000_Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool000Aoo`03001oogoo02=oo`07001[>F/HJaU[66/i00000VLI01M[
6FLIIaUW6@00HaUW6VLIIaYS6FLJ001S6V;jHaYRnV<JH_YS6P00G_]NnUkk00800004F]]Jn`00E_/3
E]/015KkE]]FfeKK0`0000=:_4kLB[`00TZl00e>g0000012W4Jm@Ya6_4:LA[d003ZM>WdjW@0:0000
128m000Ao1Gl0P000PGK1`0000=88000Ool05Goo00<007ooOol057oo0`0000=CfdoK00001@0000IC
gDnlDmd005OMEkd2Emd200000eNnEkeKgP020002Fkh02E^mFkh005^nFiiK_U^NFkh00003Fih01ENN
Fih00000Egh00UNN00AKWUMn000000EGOP8000=GOPH00005EeiCGUMNDeiGGP020005Deh200000e=N
Dch000020002Ool3000bOol00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool000Aoo`03001oogoo02=oo`0R001[66/iJaQ_>F/H001W6F/iIaU[6FLI001RnFLJH_UW6V;i
IaX006<JG_YS6UkjHaYNnV<J001O6ekjGa]JnUlKG_X200002eKlE]]Fo5;KE_aFfeKlD]]Fo000D]`0
0P0000M:_4kLB[a>g4ZlC]a:_00200000dJm@Ya6_@0500002SJM=WdjW@00;WdZGBin:Ud001hl1000
00DF7A7l0005^`GL00D00003E6000000008001Aoo`03001oogoo015oo`D0000CDm/00000001;g4Nk
001?_5?MCkaCg@00EmiG_EOMDkd005NmFmh05`0000=KWUMmFih00P0000EGOE^NEgiGOUMm00800006
EgiCGUMnEeiGOU=N0P0000=GOU=NEgh01@0000iCGU<nDeiC?U=NDch004lnDei??U=NCciCGTln0`00
<goo0P0017oo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0004Ool00`00
Oomoo`0ROol02@00JaQ[6F/HJcU[6000IaU[6@03IaT06F/I001W6VLIIaYS6FLJ001S6V;jHaYRnV<J
H_YS6P00G_]NnUkkG_YNnekjG_/005[k00800003E]]FneKK009Ff`8000ABg003001:_4kL00=:_003
C]a:_00000<00003@YdnWD:m0080000;=WdfWCIm=Wd002im:Ud^GBYM000N?@028Sd500021M/30000
0eRP00000004000COol00`00Oomoo`0?Ool300000d>H00000003000014^kBka7^`000U?M00A?_000
001Gg@T0009C_P06EkiC_P00001G_UNN0UNn0P0015NN0P000eNN2`001EMn0P0000ICGUMNDeiGOU=N
Eeh20002Deh20002Deh200001TlnDeiC?U=NCciCGP8000=??P80039oo`03001oogoo00Yoo`03001o
ogoo009oo`03001oogoo00Uoo`@000Eoo`0017oo00<007ooOol08Woo00T006/iJaQ_>F/HJcT006/i
IaT02`00011NnV<JG_YS6UkjHaX005lKG_YO6e[jGa]NnUlK001O6`=Jn`80000:E_aBf`00D]]Bg4kK
D_aBfe;LC]/200000dkLB[`0000200003TJlB]d00000?Ya2_CjL@[dnW000=WdfWCIm>Yd200000bYM
;WhZG@0200001B9M7Sd0017l5Qd0100000@5^`00001HX0L0015oo`03001oogoo00eoo`<00009AkT0
0000000oVP00Bka7^d_L00800003Ck`0000000@00005Ckd00000CkeC_P02000015>nEkiCWENn0P00
00ACWUNnDiiG_P800004EiiG_U>NEkh200001E=nEimGOUNNDgh00P0000AGWU=nEimCOP800003EimC
OUMn00D00006EgiCGUMnDeiGOU=N0P0000IGOU=NDeiCGUMnDeh4000015=NCciCGTln0P0000MCGTln
Dei??U=NCciCGP03000_Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomo
o`06Ool000Aoo`03001oogoo025oo`04001[6F/HJcT60002JcT02@00IcUW>F/jIaUW>@00IaYS6P04
00002V<JH_X005kjG_]NnUkkG_YNn`001e[k0P002U;L0P0000e6_4JmA[a:_DJlA[e6_000?Ye2WCjM
@[dnW@0200002SJM=WdfOCIm000ZGBiM:Ud^O@000R8m0P0000<F7A8L00001P0000=HX00000001@00
3goo00<007ooOol02goo1P0000DkVS^I000004^l00P000=;_@800005Dki?_@00001G_P03Dkh20003
Ekh00eNN00000004Eih20006Eih01`00EgiGOUMnEiiGOP00009GOP04DgiGOUMnEgh200001U=nEgh0
0000DeiGOP8000MCGP8000=CGP@000Q??P80009??P8002eoo`03001oogoo00Yoo`03001oogoo009o
o`03001oogoo00Uoo`03001oogoo00Ioo`0017oo00<007ooOol08Goo100000=_F@00KcT00V/i011[
6FliJcT006LIJcYW6F/jIaT006<JIcYS6FLjHaYW>P@00006F_YO6ekjGa/005lK0e[k00IO6e[kF_]J
n`00E_/200001U;lD]]Bg4kKD_aBf`80000:C]d00000A[a:gDJlB]e6_4[MA[`200000d:m?Ya2_@0?
0000228m000F7A8L5Qd000Wl1M/<000=Ool00`00Oomoo`09Ool?00001d>m@i`00000Cke;_Dnn0080
0003Ckd0000001D00004DgiGWeMnEih2000015=nEiiCOUNO0P0000ECOUNODgiGOU=n00800006EgiC
GUMoDeiGOU=N100000EGOU=NDeiCGUMn00800005CciCGTmNDei??P0200000e=NCch0000200000dln
Dei??P0200001TloCci??T/nCcm??P<002Yoo`03001oogoo00]oo`@000aoo`D000Aoo`0017oo00<0
07ooOol087oo00L006lhKcU_>6liKcP00005JcT01000IcU[>VLI0VLi00<006<JIaX00VLJ00AS6VLJ
IaX000=S6PD000IJn`800004E_]Fo5KkE_`20002D]`20005C]`02000A[a6_DJlB[e6_4JmA[`40000
2Sjm>YdnW@00=YhbOC:M<Wd002YM0RYm00<ZOP007Ud01@0000@F7@000005o0800003D41<@00000P0
00]oo`03001oogoo00Moo`X00003=g/gNSMk01000004Bii?_T^NBkh2000014nNCki?WTnn0P0015>N
0P000e>N300000=GOU=nEgh00P000e=n00AGOU=nDgiCOP80009CGP03Dgh0000000@000ACGP800007
CciCGTlnDei??U=NCch00`001dln0P0000=??T/n00000P009Goo0`009Woo0004Ool00`00Oomoo`0P
Ool01P00KeU[>6mIJcP0009[>@0KJaU_>F/iJcT006/jIaU[>VLI001S6VLjHaUW>V<JIcYS6@00HaYS
6elJHa]S6V<K001S6ekj00<0009Jn`09001Jo5KkF_aFfe[lE_]Jo5KK0080009>g006C]e>g4kLC]a>
gDkL0P0000=:gDJl00000P0001I2_DJm000003ZM?[djWCjn000fWS9m=YhbO@009UdZORYM:Wh0029N
7SdRG@X00003C41@H4a000@00003?0000000008000Qoo`03001oogoo00Eoo`D000038aPNmb<H00/0
0004?idkO3nM>g`2000024NnAid00000Cki;WTnnBih200004U>oCiiC_TnNDkl005>oCiiC_e>NDkl0
05NODiiCWe=nEimCWP800004EimCOUNODgh200000e>ODgiGW`0500001EMnDeiGOe=NEgh00P0000EC
GU=nDeiGOe=N00800004DgmCGU=NCeh400001e=OCciCGTlnDem??U=N00800003Cci?GTln00800003
Cci;?Tlo00800007Bai??d/nCci;7TloBch00P009Goo00<007ooOol097oo0004Ool00`00Oomoo`0O
Ool01`00KcU_>6liKcQ_>@0000E[>@03001[>VLI009W>@03JcX006LJ009W6P04HaYW6VLJ0003HaX0
16<KHaYS6P001UlK0P0000]Fo5KkE_aFneKlE_]Fo5KkE_`005;l008000M>g0<0000<@[e6_D:mA[e2
_DJm@[d003ZM?[djWCjM0P0000<bOC:M<Wd00P000RYm00<ZOP0000000QiM00<N?@005Sd00QHm1@00
00A<@51PC41@@0h00003Ool007oo00=oo`l00003<e/_Fc=L0080008oW@03?gdoW@0000`00004Cki?
WTnnCih20004Dih20005Dih20002Dih015=nDiiCWP001E=n0P000e=n1P000e=N00=COP0000001U=N
0P0000M?GU=N000004lnDei??P0200001DmNCci??TlnCeh00Tln0`000dln00A;?TlnCci??P800004
Bci??P00000SOol00`00Oomoo`0TOol000Aoo`03001oogoo01moo`09001[>6mIJcQ_F@00JcU[6Fli
009[>@0NJaT006LIJcYW6F/j001W>V<IIcYS6VLjHaUW>P00Ha]O6V<KHaYS6`00Ha]NnUlKG_YS6ekj
Ga/005lL0P0000EFfe[lE_]Jo5KK00800004E_aBfeKlD]`200000dkMC]a>g00200002d[LB]d00000
@[e6_D:lA]e2_DJm@[`00P00018n_CZM?[hjW@00<WdfWS9m=Yh002Yn:UdZORIM000N?B9M7Sd20000
0aHm4Q`F?@0g000014>N@gi3WSmn0P0000=;WdMnBil04P0000ACOUNODgiGW`80000<DgiCWe=nEimC
OP00DeiGOe=nDgmCGUMo0P0000=?GU=oDeh0100000=CGTmNDgl00U=N00U?GU=o001CGTlnDem?GU=N
Cch00`0000Q??U=OCci?GTlnDem??TmN0P000Tln0P0000=;?TlnBah00P0000I??d/NCcm;7TloBah2
000POol3000UOol000Aoo`03001oogoo01ioo`07001_>6liKcQ_>Flh00001F/i00L006LIIcUW>F/j
IaT00002IaX01F<JIaYW6VLJ00000V<J00ES6f<JHaYS6P0000IO6`05001K6e[kFa]Jn`0200000eKl
E_/00003D_`01EKlD_aBo5;lE_`00`0000=:gD[LB]d00T[M00U:g000@[e6_D:mA[e2_DJm@[d06000
00<F?@0000000`0000=003`0@0000T0000@l0000000000<X010000057_XJnQ[j6_XNnP0300000bmL
:c`_?0030003>gd20002@ih014=n@ih000000dNN00=;WTNNAih00P000d^N00M?W`00001?WTnOCii?
W`0200000dmnCim?WP060003Dgh20005Dgh20003Dgh015=NDgh000000U=N0`000U=N0P0000ICGTmN
Dei?GU=NCeh20002Ceh300000dlnCei??P020006Cch30003Bch01TlnBci;?T/nCci;?P<0021oo`03
001oogoo02=oo`0017oo00<007ooOol07Woo00P006mIJcQ_FF/h001[6Fli0V/i00E[6Fli001[>VLI
00`0000CHa]S6V<KGaX005kjGa]NnV<KG_YO6`00GaaJnelLF_]O75[kGa`00`0000YFo5;KE_aBg5Kl
D]]Fo5;L001>g0800006B]e:_4kMB]a:gDZl0P0000=6_D:l00000P0000Ln_D;N000j_SJM>[hfW@02
00000c:N;WdbWP0200000bIm:WhVG@0200000b9n7UdROP0:00001C`0@00l0400?000;@0000E7WT^O
Agi;WdNN00800004Cim;WTnOBgh2000014nOCgi?Wdmn0P0000ECWdmnDim?OU>O00800004CgiCWdmn
Dil;000015=oCeiCOe=N0P0000MCOdmNDgm?GU=oCeiCO`04000014lnDem?GU=N0P0000M??U=OCciC
GdlnDem??P0300001d/nCem??TlnBci?Gdln00800007Ccm;?P00001??d/NCcl0100000=;7TloBah0
0P007Woo00<007ooOol08goo0003Ool00`00Oomoo`0NOol01`00KcU_>6liKcQ_>@0000A[>@D00004
JcT006LjJcX3IcX00f/j001W>P02IcX60004Ga/03000Fa]Jne/KF_]K6e[kFa]Jn`00E_]Jo0@0000;
D_aFo000001>g5;mC]aBo000B]e:g003B]d01D[L00000000?[d00d:m00Tn_D:m000003ZM>[hjWCZn
00000c:N00PbW@009WhZORIm:Wh0029N0aiM00@001Hm5UdFG@T00004900X02P0:00700000`Hi0ST2
>@0300022YX00`jJ2YX000060004:cd30005=eh20003?ghB000015>OCgi?WdnN0P0000ICOdmnDim?
OU=oCgh20002Dgh01e=oCgh00000Dgm?OU=n00@00003DeiCOU=N009CGP03DgiCGU=N00800003CeiC
GTmN00@00003Cei??TmN009?GP03Cci?GTmN0080009??P8000=??P800006Bci??T/nCci;?Tln0`00
00=;?T/NBch00T/n00A;7T/nBci;?P<001]oo`03001oogoo02=oo`000goo00<007ooOol07Woo00L0
06/hKeU[>6mI001_>@0500005V]JJcU_FV/iJeX006]JIcY[>VLiJeYW>P00HaYW>f<JIc]S6P00HaYS
>elJ1@0000mJnelLF_]O75[kGaaJn`00E_]K75KkFaaFne/LE_/00P0000MBoDkLD_e>g5;mC]aBo@02
00001TZlC]d00000A[e:g@80000<?[e2gSjm@[hn_D;N?[d003JM>[hfWCZn0P0000<^OC:N;Wd00P00
00<ZORIM:Wh00P0000<NGB9n7Ud00P0000HJGQHm6Ud0019M3S`900000`HJ1S/0000>00001Akl6]`N
o1[L7_`01P0000DgGCMn=edgOSMM00800004?gloOT=o?gh300001D=nAim3OTNO@gh00P0000A;WdMn
Bim7OP800003Cim;OTnO00D00005Dim?OU>OCgiCW`0200002dmnDgm?OU=oCgh004mNDgm?GU=oCeh0
0P0000=COdmN00000P0000=?GU=oCeh00P0000ECOdmNDem?GU=o00800003CciCG`0000800003Dem?
?U=O00800006Cci?GdlnCem??TmO100000A;?TloBci??`<00003Ccm;7Tlo00<00003Ccm;7T/o00<0
0003Bcm77T/o008001Uoo`03001oogoo01]oo`800003Ool0000000=oo`000goo00<007ooOol07Goo
00D006lhKcU_>6li00<000A_F@03001[>F]J009[>@03001[>VLj009W>P03JcYW>P00009W>P0;HcYW
>VLj001S6V<kHa]S>f<JHc/00002Ga/400003E/KF_/005KkF_aFo5/LE_]Jo5KlFa`005Kl00800006
C]aBo4kLD_e>g5;l0`001TKM0P000d:m00<n_@000000600000<FG@0000000Q8m00@000hl3S`>G0T0
00<6F`<000044Y/>Va:K3Y/700001B/M:cd[7B/m:ad0300000E7Wd=nAgm7OTNO00800004Bgm;WdMn
Bgl200001D]nBgm;Od^OBgh00P0000=?Od]nCgl01P0000A?OU=nDgiCO`800003DgiCOdmn009COP08
001?GU=nCeiCOdmNDgi?GP@00004Dei?GU=NCeh20007Ceh40003Cch014mN0000000014ln10002D/n
0`0000=;?T/NBch00T/n00=;7T/nBch00`0057oo0`0077oo00<007ooOol00P0017oo0003Ool00`00
Oomoo`0MOol00`00KeU[>00300009V/iKeU[>FmIJcT006/iKeY[>F]J001[FVLjJcYW>F]JIcX006<J
Ic]S6VLkHaX006<JHc]O6V<kHaYS>`00HcaO6elkGa]S?5lKGc/300001U/LE_]K75KkFaaFn`800004
EaaBo5LLD_`200001U;mC]`00000C_e:g0800007B]e6gD[MA[e:gDKMB]d0100000<j_CkN?[d00P00
00Tj_SJM=[hfW@00;YhbWRjM<Yh00P0000<VOBZN9Wh00P0000<ROQim8Wh02P0000<:?0iM2S`04P00
00DNoAkL8_dNg1km00L00004=ehc?SMN<ch3000013]N?glkGSmo300000A;OTnOBgi?W`800006Bgi?
Wd]nCim;OTnO0P0000=;OTmoCgh01P0000=COdmNDgl00P0000M?GU=oCeiCOdmNDgm?GP0200000e=o
CeiCO`05000015=OCciCGdmN100000A?GdlnCem??P@00007Cem;?TmOBci?Gd/nCel00P0000M;?Tlo
000004/NCcm;?P0400000d/oBai;?`0200000dLNBcm;7P0300000dLNBcm77P02000DOol00`00Oomo
o`0JOol01@00Oomoogoo000017oo0003Ool00`00Oomoo`0LOol01`00KcT00000KeQcF@0000E_F@03
001[FV/i009[>@07001W>VLjIcY[>VLj00000VLj00]S>VLjIcYW>P00Hc]S6f<kHaYS>`0000QO6`03
001K6e/L00<00004F_aFo000D_`3E_`015;lE_aFo5Kl0P0000I>gDkmB]e>oDkMC_d20003A]d20000
2TKM@]d00000?[hn_Cjn?[dn_P000cJn00@fWP00000bWP<^WP06000VORIn9WhZWP000b9n00DNO@00
6WdJOQYM00h000<>O0<000<F_0035Y`0000000D000D[7PH00005?glkGSmO>ehoO`0300000d=o@gi3
O`02@gl20003Agl50002Cgl00d]nCgm?O`0200001TmoCgi?OdmnCgm?OP800003Cgm?OTmo00D00005
Dgi?GU=oCeiCOP020003Ceh01E=OCeh00000Cel00TmN10000TmN00I??TmNCei?GTlnCeh20002Cch2
0003Cch200001TlnBci??T/nCci;?P<000U;?P<00008Bai;?dLNBci;7T/oAai;?P<0015oo`03001o
ogoo01Yoo`05001oogooOol00004Ool000=oo`03001oogoo01aoo`80000aLgU_F7=i001_FF/iKeU[
>FmI001_FV/iJeY[>@00IcY[>VLiJeYW>V/j001W>f<JIc]S6VLk001S>elJHc]S6V<kGaX005lKGc]O
6f<lGa]O>elK001K6elLFa]O75/KGa`00`0000UG75;lEaaBo5LLD_aG7000D_d00P0000M:g4kmB]a>
oD[LC_e:g003000034:mA]i2gDKN@[e6gP00?]hj_CkN?[dngP800009=Ydf_SJM>[h003:N;YdbWRjN
00800003:YhVORZN008000037WdROQiM008000036WhJGAin00D000045WdBOAIm4Wd>00001B;n7]dR
oQkM8_h01`0000DgGc<n=elc?SMO00H00005?ei3Od=N@gloGP0200000dMo@gi7O`03000014]oAgi;
OdMn1P0000E?Od]nCgm?OTmo00800003Cei?OdmN00<00004CeiCOdmNCgl6000014mNDgm?GU=o0P00
00E?GU=OCeiCGdmN00800003Cem??P0000800003Cci?Gdln00800006Cem;?TmOBci?Gd/n0`0000M;
?TloBci??d/nCcm;?P0200001dloBah00000Bcm;7T/o00@00003Bai;?dLN00800003Bcm77T/o00<0
0003Bcm77T/o008000moo`03001oogoo01Yoo`05001oogooOol00004Ool000=oo`03001oogoo01ao
o`06001_FFmHLeU_F0001FmI00H006/iJcU[>F]J0002IcX<00001F<kHaYS>f<K00001elK00/005/K
FaaK6elLFa]K75/K001G75/L00<0009Fo0800004D_eBo5;mD_`200000dkmB]e>o@020002B]d20000
1T;MA]e2gDKM@]e6g@800003?[dn_Sjm024000044WdFOAIm5Wd200025Yd300036[d80004:ah30002
<ch01SLn00000000>elkGP8kG`/0009;O`03Agm;Od]o00<000A;O`X00008Cei?OdmnCgm?GTmoCgi?
O`800003Cei?OdmN00D00004Cei?GdmNCeh20003Ceh014mOCei?GTmN0`0000=??TmNCch00Tln00I?
GTln000004lnBch200000dlnBci??P020006Bch30002Bch01d/oBai;?T/nBcm;7T/n00<00008Aci7
7T/oAai7?TLNBcm77P<000]oo`8001]oo`80009oo`8000Aoo`000goo00<007ooOol06goo00l007=i
KeQcNFmH001[>FmIJcU_FF/i001[>F]JJcT01@000V]J00X006]KIcY[FfLjJe/006MKHcYWF`L0000;
HcaO6elkGa/005/KGaaK6elLFa]O700200001UKlFaaFne/LE_aK70800008D_aBoDklD_eBo5;mC_aB
o@<00006B_e:gD[mA]e:oD[M0P0000A6gT;MA]i2_@D00003>[hngSZm00800003=[hbWSJn00800004
;Yhb_RjN;[h200000bJN:YhVOP07000011im8YhNOAjN4`0000<VoP000000100000D[7RlN:_h_7R/N
00D00005>ehoGc]N>elkGP03000013mN@gloGT=o0P0000=3GTMo@eh01P0000E;Od]NCgm;OT]o00<0
0004Cgm;GTmoBeh200000dmoBeh0000200000dmNCgm?GP0200001DmoCeiCOdmNCgl00P0000=?GTmO
Ceh0100000M?GdlnCem??TmOCci?G`0200000dlnCem;?P0200000dmOBci?G`0200001T/nCem;?TmO
Bci?G`<00007Ccm;?TloBai??d/nCcl00P0000M;?T/o000004/NBcm77P0400000d/oAai;?`020000
0dLNBcm77P0300000dLNBcm77P02000:Ool00`00Oomoo`03Ool4000LOol000=oo`03001oogoo01]o
o`06001_F7=IKeQ_F@001FmI1@001V]J00L006LjIeYW>VMJIcX00002Ic/016<jIc]W>`0016<k1P00
00MK6elLFa]K7000FaaG7003Fa`01ELLFaaK7000E_`00P0000EBoE;lD_eBo5;m00800003C_d00000
009:g@05B_e:gD[MB]e:o@0400000d;M@]i2gP020002>[h013jn>[hj_P0013Jn0P000RjN00D^_RjN
000002ZN00@000038WhRWR:N008000<NWP057Wh000007YhJW@0300000aZM7[hJWP0300000ajn7]h0
000200000bKn8]hVoP0800001C<n<clc?S<o<ch01P000SmO00Y3OcmO000004Mo@em3Od=OAgm3G`80
0003Agm7GdMo00H00004Bgi;Od]oCgl20002Cgl01D]NCgm?OdmoBeh0100000A?GdmNCgm?GP800005
Cem?GTmNCei?G`0200001dmNCel00000Cei?GdmN00800007Cem??TmNCei?GdlnCeh010000Tln00=;
?Tln00000P000T/n00=??`0000000d/n0P0000I;?d/nBci;?T/oBch300001DLNBci;?T/oAah00T/n
00=;?dLN00000P0000Q77TLnAai7?dLNAci77TLo0`001goo00<007ooOol00Woo00<007ooOol00Woo
00<007ooOol06Goo0003Ool00`00Oomoo`0JOol02P00KeQcNFmHLgT006mIJcU_FF/i0`0000E[FFmj
JeT006/i00=[FP0>JcT006LjJe]W>V]KIcX006<jIe]S>VMKHcX0009S>`09Ga]S>f<kHc]O6`00Ga]O
?5lK00D00006E_aK75KkFaaFo5/L0P0000AFo5LMD_aG7@800006C_`00000C_e>g5;m0Tkm0P0000=:
gD[mA]d00P0000U6oTKM000004;N?[e2gT;M@]h00P0000@j_SkN>[dngP800003<Yhf_S:N02`00005
;al00000000_7`0700001C]O=chkGc/n>el01P0000A3GTMo@ei7O`800006Aei;OdMNAgm7GT]o0P00
00=7GT]oAeh01@0000E;GTmoBei?Od]N00<00004Bei?Od]NCgl5000014moCei?GdmN0P0000I?Gd]N
Cem?GTmOBeh400001DmOCci?Gd/nCel00`0000A?Gd/nCem;?P@00008Cem;?TloBci?Gd/nCcm;?P@0
0004Bcm;?T/oBah300000dLNBcm;7P0200000d/oAai;?`0400001dLNBcl00000Aai;?dLN00@00003
Acm77T/o008000Eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo01Uoo`000goo00<007oo
Ool06Woo00H007=IKeQ_FFmH0002KeT300001FmJKeU_FV]I00001F]J00L006LjIeYW>VMJIcX00002
Ic/01F<jIc]W>fLk00001V<k00X005lKGc]O>ellGa]O>`00GcaK70<00005EaaK7000EaaFo003Ea`0
0eKlEaaG70020008C_d30003A]d00dKnA]e6g@02000014;M@]i2gT;N2P0000<b_SJn00000P000bjn
0P0000@ZWRZn:YhZ_P8000039YhV_RJN008000048[hRWR:n8[h200038[h200000b;N9]hRgP028]h2
00039_h00bKN000000060002<cl00cLo<ah000060005?el50002Agl00dMOAgm7O`020003Bgl01dMO
Bgl00000Bem;Od]O00H0009?G`03Cgm;GP0000800004Cei?GdmNCel50002Ceh00dmOCeh000020003
Ceh00dmO000000030002Cch01DmOBci??TlnCel00P0000M;?Tlo000004/nCcm;?P030003Bch00d/o
000000020003Bch01D/oBci;?T/nBcl00`0000Q;?dLNBci77T/oAai;?TLN0`0000U77TLoAai77dLN
Acm77TLOAah00P000Woo0P0017oo00<007ooOol00Woo00<007ooOol06Goo0003Ool00`00Oomoo`0I
Ool01`00LgU_F7=iKeP006/i00800008LgY_F@00JeU_NV]I001[>@=[FP0AJcU[FP00Je]W>V]KIcX0
06<jIe]S>VMKHcYWF`00Hc]O6`03Hc/03elK001O6ellGa]S?5lKGc`005llFa]O?5/KGcaK6`030000
2UKlEaeBo5LME_aG7E;l001Bo5<M0`0000=>oDkLD_d00P0000]:gDkn000004KMB_i6gDKnA]e:oTKM
00@00003@]hn_D;N00800003=[hjgSZn00@00003=[hb_SJo00800003;Yhb_bjN00800004:[lZWRZo
9Yh200000bJn8YhV_`02000012:N9[lRWR:n0P000b:n0P0000@VgR:n9]lR_PH00004;al^oRlO;_h9
00000cLn>clg?P0200000cmO?cm3G`03000014=o@em3Gd=O1P0000A;OdMNBgm7GP800006Bgm;GT]o
Bei;Od]N0P0000=?Od]NBgl01@0000A?Od]NCgm;GP<00004Bei?Gd]NCel4000024/nCem;?TmOBci?
Gd/nCel200001d/nCel00000Bci?Gd/n00800006Cem;?TmOBci?Gd/n0`0000M;?TloBci;?d/nCcm;
?P0200001d/oBch00000Bcm;7T/o00<00003Bcm77T/o00800003Aai;?dLN00<00003Aai;?dLN0080
0003Acm77T/o00@00006Aai7?`00001oo`0017oo00<007ooOol00Woo00<007ooOol06Goo0003Ool0
0`00Oomoo`0IOol01@00KeQ_FFmHLeT00P000fmi00H006mIKeY[FFmJ0005JeX02@00IeYW>VMJIcYW
FP00Ic]S>P060004Hc/02@00Ga]O>elkGcaO6elk001O?003Fa`015llFaaK70000U/L0`0000YFo5LL
000005;lDaeBoE<MD_aC7@<0009:o@04C_e:oD[mB_d20002A]d01DKn000004;NA_h00P001CkN00D0
03Zn000003[N00800004<[hf_S:n=[hP000012[n:_lZoR[n0`0000D_7blN;al^oRlO00P000<k?`D0
00E3G`<00097G`03@em7G`0000@00005Bgm;Gd]oBem;O`0200000d]OBgm;GP02Bel20003Bel40000
1d]NCem?GTmOBei?GdmN00800003Cem?GP0000800003Cei?GdmN00800006Cem;?TmNCei?Gd/n1000
00A??T/nCcm;?P<000=;?P80009;?P05Bcl00000Bci;?`03Bch01T/o00000000Bcm77P9;?P04Bcm7
7T/nBch3000024LNBcm77TLnAai;?dLNAch3000024LOAai7?dLNAam77TLoAah20004Ool00`00Oomo
o`02Ool00`00Oomoo`0IOol000=oo`03001oogoo01Qoo`04001_F7=iKeP200002W=iKeUcNVmILgT0
06mjJeU_NP000f]J00I[>F]JJeX006LjJe/600001VMJJe/006MKHc]WG0H0000;Ga]S?5lKGc`005ll
Fa]O?5/KGcaK6`0200001U/mEaaK75LLFceG70<00006D_aC7E;lEaeBo5<M0P0000Y>o@00001>oT[m
C_e:gDknB_e>o@<0000:A_i2gDKn@]e6oT;M000ngT;N?[d400000c[N>[hjgP0500000cKO<[hfg`02
00000bjn<[l^_P02000012jo:[h^gbZn0P0000<ZgbJn:]l00P0000@V_R[O9[hZg`<00003:]lVgR[O
00<00004:_lZgR[o:]h600001CLo<ahg?c<N=cl01P0000Dk?cmO>cloGc/o00H00004Agm3GdMo@el3
000014MOAgm7Gd]o1P0000A;GTmoBei;O`800005Bei?Od]NCgm;GP0200000dmoBeh0000200002d]N
Cel00000Bei?Gd/nCem;GTmOBch0100000A?Gd/nCem;?P<00004Bci?Gd/nCel4000024/nCem;?Tlo
Bci?Gd/nCcl4000014/NBcm;?T/o0`0000=;?dLNBcl00P0000=77T/oAah00`0000=77T/oAah00P00
00=;?dLNBcl00`0000=;?dLNBcl00P0000=77TLoAah00`0000=oo`00Ool00goo00<007ooOol00Woo
00<007ooOol06Goo0003Ool00`00Oomoo`0HOol01P00KeT00000LgP000A_N@06001_FV]IKeY_F@00
0V]J1`0000=[FP00Ie/016MK00P006MKHe]WFf<kIe]SF`000f<k1P000U/L00=O?5/L00001e/L0P00
00IG7ELL000005<MD_`200001E<MC_e>oDkmDad00P0000=:oDkmB_d00P0000Y:oT[m000004Kn@]e6
gT;NA_i2g@<0008ngPD00003>]hf_S[N008000<b_P05=]hb_P00;[h^_`02;[h20003:[h01RZo0000
02Zn:[lV_P800004:]lV_RKN9[h;000012lO<al^oS<O0`0000<g7c<O=cl00`000c/o100000@oG`00
00000093G`03?em3G`0000@000E7G`<00004Bem7Gd]OAel5000014]NBem;Gd]O0P0000=;GdmOBeh0
0T]O00=?Gd]N00000`0000A?GdmNCem;GP<00004Bei?Gd]NCel400001d/nCci;?TmOBci??T/n0080
009;?P80009;?P05Bcl00000001;?`03Bch400001D/oBci;?T/nBcl00d/n0`0000Q7?T/oAai;?TLn
Bcm77T/n0`0000Q7?dLNAcm77TLoAai7?dLN0`000Woo0P0000=oo`00Ool00goo100077oo0003Ool0
0`00Oomoo`0GOol3000037>ILgP006mILgY_FG=iKeT006]IKgY[F@@0000OKg][FP00IeY[NfMJJg/0
06]KIeYWFfMJJe/006MKHc]WG6<kIe]S>`00Gc]SG5lkHeaO>f=L001S?5lkGc`01P0000AG75/LEaaK
?@800006EaaG7ELLEaeG75LM0`0000QC7DkmDae>o5<MC_eC7Dkl0`0000I6gD[nA]e:oTKMB_h20000
0d;M0000000600000ckN>]hngP0200001CJn>]lf_S[O=[h00P0000@fgc:n=]lb_P800003<[l^_S;O
01000004:]h^ob[N;_l300000bko:_h^o`0200001Bkn<al^oS<O;_h01@0000Hg7c/o=clk?cLO>cl6
000013lo@eloGd=O0P0000A3GdMO@em7G`H00004Aei;OdMNBgl3000014]OAei;Od]N1@0000E;GTmo
Bei?Gd]N00<00004Bci?Gd]NCel5000014mOBci?Gd/n0`0000=;?TmOBch00P0000=?Gd/nCel00P00
00I;?TmOBci?Gd/nCel300001d/oBci??d/nBcm;?Tlo00800007Bci;?`0000177T/oBah00`0000=7
7T/oAah00P0000=;?dLNBcl00`0000=;?dLNBcl00P0000=77T/oAah00`0027oo00<007ooOol08Woo
0003Ool00`00Oomoo`0GOol01P00LgUcNG=hLgT000A_N@03001[FFmJ008000=[NP05KgY[NV]j001[
N`02JeX00`00Ie]WF`04Ie/01`00He]WFf<kIe]SF`0000=S>`04HcaS>`000006Gc`01000FcaO?5/l
1@0000YG75LMEaaG7ELLEaeG7000DaeG7@<00003Dae>oDkm0080009>o@8000=:o@03B_i:oD[m00D0
0003@_i2gT;N008000DngP800003>]hf_S[N00/00003<]l^gS;O00800004;]h^gbkN;]l300000bkO
:]h^g`0200001B[N;_lZgR[O:]h02`001CLO1P000clo00<k?clo00001@000d=O00A7G`00000000A7
G`D000E;G`800004Bem;GT]OBel6000014]OBei?Gd]N0`0000A;GT]OBei?G`@00008Bci;Gd/nCem;
?T]OBci?G`@000=;?P05Ccl00000001;?`02Bch20003Bch20002Bch014/oBci;?T/n0`0000=;?T/o
Ach00T/n00=;?dLnBch00`0000Q7?dLnBcm77TLoAci;?dLN0`002goo00<007ooOol08Woo0002Ool0
0`00Oomoo`0GOol02`00KgQcVG=hLiT007=jKeUcNFmILgX00`0002E_VP00KgY[FVmkJeY_NP00Jg]W
FV]kIeX006MJIe]WFV]KIeX006<kIeaS>fMKHc/005lkHeaO>f=LGc/005lkHcaO>ellGc]S?0020000
2E/LGcaK75llFaaO?000FceG700300002ULLEad00000D_aG7E<LEaeBo5LM0`0000I?7T[mCai:oDlN
B_d200000d[n0000000200002DKMA_h00000@]i2oT;M@_i2gP0200000ckN>]hngP0500000c[O=]hj
g`0200001C:n=]lb_SKO<[h00P0000@bgbjn<]l^_P800004;]lZ_RkO;[h;000012kn<_l^oS;o0P00
00@boS<O<_hc7`H00005=alk?cLO>clg7`0700000clo@elo?`0700001D=OAem7GdMO@el00P0000A;
GdMNBem7GPH00004Bem;GT]OBeh3000014]NCem;GT]O100000M;?TmOBci?Gd/nCem;?P0200001dmO
Bch00000Cem;?TmO00<00004Cem;?TmOBch4000024/oBci?Gd/nBcm;?TmOBch4000014/oBci;?d/n
0`0000=7?T/oAah00P0000=;?dLNBcl00`0000M;?dLN000004/oAai;?`04000>Ool00`00Oomoo`0R
Ool0009oo`03001oogoo01Moo`03001cNG=h009cN@04001_NFmiKgT30002KgX01000JgY[NVmj0V]j
00<006]kJeX00V]J00<006MKIe/04P0015ll00@005/lFcaO?0=K?0800006FcaK75/mFaaK?5/L0`00
00=C7ELMDad00U<M00AG7@00001C7@8000E>o@D00003A_i6oDKn0096oP04A_d00000@_h2@]h50000
0ckN>]hngP020003=]h01C[O=]h00000=]l00c;N2`0000<^gc;O;]h00P0000@bobkN;_l^o`<00004
;_lbobko<_l60004=al20003>cl300000c/o?clo?`0200000d=O?cm3G`0600000d=O000000040004
Ael3000014MOBem7Gd]O100000E;GT]OBem;Gd]N009;G`80009;G`800003Bem;GTmO00800006Bei;
Gd/nBem;GT]O100000A;?T/oBci;G`<00003Bcm;?T/o008000=;?P<00004Bci;?d/nBch400000d/n
Bcm;?P02Bch00d/oBci;?P0300001d/oAci;?dLnBcm7?T/o00<0015oo`8002Aoo`000Woo00<007oo
Ool05Woo00P007>ILgQcVFmh001_FG=i0`0000e_VVmiKiX006mjJeY_Nf]JKgX006]kIeY[N`050000
4V]kIe/006=KIgaWFfMlHe/006=KHeaSFfMLHe/005lkHeaO>`H0000<GcaK75llFa`005LLFceG75/m
EaaK?ELL0P0000IG?ELL000005LMD_`200001E<MC_eC7DkmDad01`0000=;7T[mCah00P0000A6gD[n
A]e6oPD00004@_lngT;n?]h300000c[N?_ljgP02000013[O=]hjgcJn1@0000<bgSKO<]h00P0000Db
gbkN<_lbgS;O00800004;]hbobkN<_l2000012kN<_l^gS;o1@0000@g7c;n=alboP<00004=alg?cLO
=al500001SmO>clo?c/o?elk?`D00005@cm7Gd<o@em3?`03000014<oAem3?dMO100000M7GT]OAei;
GdMNBem7GP0200001d]OAeh00000Cem;GT]O00800006Bei;Gd/nCem;GT]O100000A;?TmOBci?G`<0
0004Cem;?TmOBch4000024]OBci?Gd/nBem;?TmOBch4000014/oBci;Gd/n0`0000=;?T/oAch00P00
00=;?dLNBcl00`0000M;?dLN000004/oAai;?`03000EOol00`00Oomoo`0ROol0009oo`03001oogoo
01Ioo`03001cN7=i009cN@<00003LiY_V@0000=_NP03001[NVmj00=[NPD000=WN`05Jg]WN`00Ie]W
N`03Ie/03P00He]SG6=KHeaSF`00GeaSG5llHeaOG6=L0003Gc`6000015/LFceK75/l0P0000IG75LM
EaeG?ELLEad30003Dad00dlMDaeC7@0500001d[mB_i:oD[nB_e:oT[m00@00004A_i2oTKnA_h30000
13kN@_hngT;n2P0000<fgSKO=]h00P0000Dfgc;N=]lbgSKO00800004<]hbgc;O<]l;0004<_l20000
1CLO<alg7c;o=al01@0000<k?c/O>cl00S/o1P0000<o?d<o?cl00Slo1P000TMO1@000dMO0P0000=;
GdMOBel00P001T]O100000A;GT]OBem;G`<00004Bem;GT]OBel400001d]OBci;Gd/nBem;?T]O0080
0007Bci;?`00001;?T/oBch00`0000A;?T/oBci;?`@00003Bci;?d/n009;?P03Bcm;?T/n00<00007
Bcm;?T/oAci;?d/nBcl00`0067oo00<007ooOol08Woo0002Ool00`00Oomoo`0EOol01@00LgQcVFmh
LiT00P0000a_NG>JKiT006miKiY_N@00JeY_Nf]JKgX300009V^KJgY[V`00Jg]WFV]kIe/006=KIgaW
FfMlHe/006=KHeaSFfMLHe/005lkHeaO>f=LGc]SG000GeaK?5mLGcaOG5/l001K?5lmFc`500002ULL
EceG75LmEaaG?ELL001C7ELM200000=>oDlNC_d00`0000=:oD/NB_d00P0000Y:oP000012gTKn@]e6
oT;NA_i2g@@00003@_lngT;o00800004>]hnoc[N?_l300000c[o=]hjg`02000013;N=]lbgSKo1@00
00<foc;N=_l00P0000@bgSKo<]hbo`<00004<_lboSLO<_h6000013/o=alk7cLO0P0000<k?cLO>cl0
0`0000<o?c/o?cl00P0000<o?d=O?cl00`0000@o?d=O@cm3G`@00008Acl000000017?dMOAcm7G`@0
0004Aci;GdMNBel3000014]OAci;Gd/n1@0000A;?TmOBci;G`<00003Bem;?TmO00800003Bci?Gd/n
00800006Cem;?T]OBci?Gd/n100000A;?d/nBem;?P<00003Bci;?dLn00800003Bcm7?T/o00<00007
Bcm7?P00001;?dLNBcl00`006goo00<007ooOol08Woo0002Ool00`00Oomoo`0EOol00`00LgUcN@02
00001G>IKiUcVVnI000016mj1P0000E[NV]kJg][N`00009WN`05Jg]WNfMk001WN`03Ie/03VMk001S
G6=KHeaSF`00GeaSG5llHeaOG6=L0005Gc`20003Fc`01U/mFcaK?000FceG?0<00004EaaG7@000003
Dad60003Cad01DkmCae?7DlMC_d00`0000E6oT[nA_i:oTKn00800003A_i2oTKn00800092oP800005
?]hnoSkn?_hngP02000013[o>]hjgS[N2P0000@focKO=_lfgP800004=_lbgS;o<_l20004<_l50002
=al00cKo=al000020002=al00c/O=al000040002?cl013/o?clo?clo1@0000E3Gd<o@em3?d=O0080
0003@cm3Gd<o00800097G`@000A7G`D00004Bei;Gd]OBel3000014]OBei;Gd]O100000Q;Gd/nBem;
?T]OBci;Gd/n100000A;Gd/nBcm;?P<00004Bci;?d/nBcl4000024/nBcm;?T/oBci;?d/nBcl30000
1d/oBci;?d/nBcm;?T/o00<001eoo`8002Aoo`000Woo00<007ooOol057oo00h007>IKgP007>I001_
NG>JKiUcVP00KiY_NFnJ0P0001M[NVnKJgY_V`00Ji][NV^KJgX006MJJg]WFf]k001WO6MKIgaSFfMl
001SG6=K00D0000AGc]SG5lkHe`005mLFcaOG5llGe`005lmFcaO?E/lGceK?00200001U/mEaaK?ELL
FceG70<00006Dad00000001C7ELM0P0000=?7E<M00000P0000=?7TkmCah00P0000=:oDlNB_d00P00
00A;7TKmB_i6o@@00006A_m2oT;n@]i6od;n0P0000=2ockN@_l01P0000<jgS[o>]h00P0000@jocKN
>_lfgP800004=_lbgSKo<]h;000013;n=alboSLO0P0000DfocLO=_lg7cKo00D00005>alo?c/O>clk
7`0600001D<o?cm3Gclo@cl01P0000E3?dMO@cm7Gd<o00D00005Ach000000017?P02000014]OAci;
GdLn1@0000E7?T]OBci;GdLn00800003Bem7?T]O00800003Bci?Gd/n00<00004Bci;Gd/nBel50000
14]OBci;Gd/n0`0000=;?T/oBch00P0000=;?dLnBel00`0000M;?d/n000004/oAci;?`03000QOol0
0`00Oomoo`0ROol0009oo`03001oogoo01Aoo`0:001cN@00LiT006nILiY_VG>I0002KgX200001VnK
JiY_VVnJKi/000=[N`05JgX006MkJg]WN`0;00000f=L001SG002He`<0002Fc`00e/mFc`00002Fcd0
1ELlFceK?E/mEc`00P0000IG?@00000005LMDad20007Dad300001d/NB_e?7T[mBai:oDlN00@000A6
oP<000A2oP@00003?_lnoSkn00800006>]hjoc[N>_ljgS[o0P0000<fgSKo=]h01@000cKo0P001CKo
0P0013Ko1P000S/O00Lg7c/O000003/O>clk7`030003?cl200000d<o?clo?`030004@cl50002Ael0
0dLoAem7G`0700000dMOBem7G`02000014]OAcm;GdMO1@0000E;?T]OBem;Gd/n009;G`@00004Bem;
?T]OBch3000014/nBem;?T/o100000Q;?T/oBci;?d/nBcm;?T/o0`0000M;?d/nBcm;?T/oBci;?`03
000TOol00`00Oomoo`0ROol0009oo`03001oogoo01=oo`<00007LiUc^@00LiY_VG>JKgT00`0000a_
VP00JgY_Vf]jKi/006^KJgY[Vf]jJi/500006fNLIg]WO6MkIi`006MlHe]WO6=K001OFf=lHeaSO5mK
Hg`006=LGcaSGEmLHe`005mMFcaOG@06000015LLFceG75/m1@0000=G?ELLEcd0100000E?7E<MCaeC
7TlM00800003Dai?7DlN00800003B_e?7T[m00800007Bai6o@000016oTKmAah00TKn00=6oDLN0000
0`0000TnoT;o000003kN?_ljgSko?]h00P0000@noc[N>_ljgPD00004=]hjocKN>_l300000c[o=_hf
o`02000013Kn=_lboSKo1@0000@k7cKo>alfo`<00004=alk7cLO>al500001Slo>alo?c/O?clk7`D0
0004@cm3Gclo@el300000dMO@cm7G`0200000d<oAem3?`03000014LnAem7?TMO1@0000A;GdLnBem7
?P<00003Aci;GdLn00800003Bem;?T]O00800004Bci;GdLnBel400001d/nBem;?T]OBci;Gd/n0080
0007Bem7?P00001;?d/nBel00`0000M;Gd/n000004/oBci;?`03000WOol00`00Oomoo`0ROol0009o
o`03001oogoo01=oo`09001c^G>ILkT007>JKiUcVFnI0080009_VP06001[VVnJKiY_V`000f]k019[
NP00000006MkJi/006MlIg]WO6MkIg`006MlHgaWO6=L0006He`00`00GeaOG002Ge`200001emMFcaO
G5llGeeK?000009K?@03Fc`0000000@00003EceG7ELm009G?@800003DaeG?E<M00D00003Cae?7TlM
009?7@03Cai?7@0000800006B_i;7T[nBai:oT/N0P000dKn0P000TKn0P0014;n0P0000@nockn?_hn
oPD00004>_hjoc[n>_l200001CKo>_lfoS[o=_l02P000SKo00Hk7cKo000003/O=_l2=al00c/O0000
00030002>al00c/o>alk7`060003?cl00d<o?cl000030002@cl01T=O@cm3?d<o@em3?`@000=7G`07
Acl000000017?dMOAcl01@0000E7?T]OBem;GdLn00=;G`@00004Bci;Gd/oBel200000d/oBem;?P02
00000d]OBci;?`0200001T/nBcm;?T/oBci;?`@00005Bci;?d/nBcm;?P04000YOol2000TOol0009o
o`03001oogoo019oo`08001c^G>ILkUcV000KiUcVP800009KiY_^VnJ001[NVnKJgY_Vf]j00H0000Q
JiaWNf^L001WW6MkIgaWNfNL001WO6=KIgaSF`00Ge]SO6=LHgaOFf=l001SG5llHeeOG000FcaOGE/l
GeeK?5mM00800004FcaOGE/lFed300000e/mEcaK?@0500001ULmDaeG?U<MEceC7@800003Dci?7@00
00800003C_eC7TlM00800003Cai:o@0000800004B_e;7TKmBah400001T;nAai2oTLO@_i77P800003
?_i2ockN00D00004>_hnoc[N?_l2000013[N?_ljgS[o1P0000<foS[o=_h00P0000@k7cKn>alfoP80
0004>alfoS/O=_h60005>al6000013lO?clk7clo0P0000<o?d<o?cl00P0000=3Gclo@cl00`0000=7
Gd<oAel00P0000A3?dMO@cm7G`D00004Bem7?T]OAch300000dLn0000000200000d]OAci;G`030000
14]OAci;GdLn100000M;GdLnBem;?T]OAci;G`04000014/nBem7?T]O0`0000A;Gd/nBcm7?PD002io
o`03001oogoo029oo`000Woo00<007ooOol04Woo00H007>ILkUcV@00KiT200001W>j001_VVnJKkX0
009_VP04Ki/000000003Ji/03@00Ji]WNf^KIi/006MkIgaWNfMl001WO6=l01400005FcaOG5llGed0
0003Fcd00e/l0000000200001e/mEceK?ELmFceG?@00009G?@800004DaeC?@000007Dad30002Cah0
1D/MCai?7TlNBad0100000A77TKnBai6oP800004A_i2oTKnA_h5000013kn@_hnoT;o0P0000@noSko
?_hno`D00004>_ljoS[o>_l30004>_l200000cKo>_lfo`050004>al30003>al200000c/O?alk7`02
0003?cl00clO?cl000040006@cl5000014LoAem3?dLo0P000dLo00=7G`0000000P0000M7?dMOAcm;
GdLoAem7?`05000014/nBem;?d]O0`0000M;Gd/n000004]OBci;?`03000014/oBci;?d/n1@0000A;
?T/oBci;?`<0039oo`03001oogoo00Aoo`@000Eoo`8000Eoo`@000Yoo`000Woo00<007ooOol04Goo
00D007>ILkUcV7>i00800009KkUcfP00KkY_VW>k001_Vf]j00<0000<Ji][_6^KJi/006^LIg][W6Mk
001WNfMl1P0000ASO000HeaSO@9SO00;HeaSO@00HgeOG6=mGe`005]LGgeOG009000025/l001G?E/m
EcaK?ELmFcd20002Ecd00e<MEceG?@0300001e<MDci?7E<nDaeC?TlM00800007Dai?7@00001?7T[m
Cah00P0000Y:oDlN000004KnBai6oT/NA_i;7P@00004@_i77d;nAal2000013kn@_lnoT;o1@0000@o
7c[n?_ljoP<00004>_hnoc[n>_l:000013[n>alfoS/O0`0000@k7c[o>alfo`D00005>alo?c/O?clk
7`0600001D<o?cm3?clO@cl01P0000E3?dMO@cm3Gd<o00D00004Aci7Gd<nAel200000dLnAem7?P02
00000d]OAci;G`0300000d]OAch0000600001DLnBem7?T]OAch01@0000A;?T]OAci;G`<00004Bem7
?T]OAch4000eOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`07Ool0009oo`03001oogoo015oo`09001c^G>ILkT007>jKkYc^P00009_VP03
KkY_VP0000800003Jk/006^K00A[V`03001WNf^K00D00007Ii`006MlHgaWW6=l00001V=l00`006=l
GeaSOEmL001OG5mMGeaOGEmLGed:00001ELmFceG?E/m00001eLm00<005LmDad00`000U<M0P0000I?
7DlNCae?7TlMCah30006Bah200001dLNA_h00000Aai6oTLN00<000A2oP@00004@_lnoSko?_h30000
13kn?_lnoSko1@0000@joc[n>_ljo`80008jo`08>al00000>_lk7c[o>aljo`D000Dk7`D00004?alo
?clO?cl30002?cl00d<o00000003@cl20003@cl3000014Lo@cm7?d<o10000TLo00E7GdLoAcm7?dMO
00@00004Aci;GdLoBel<00001D/nBcm;?d]OBch01@0000A;?T/oBci;?`<003Moo`<000Aoo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo00Moo`000Woo00<007ooOol047oo00<007>iLiP00P00
00Qc^VniLmY_^@00KiYc^fnJ0P0000E_^f^k001[Vf^l00=[V`D0009WW00:Ig]WW000IiaSO6NLHgaW
W000Hgd2Hg`03F=LHgd006=mGeaSOEmL001KG5mmGeaOGE]L00<00004FcaOGE/lGed200000e/mFeeG
?006000015LmDaeG?ELm0P0000IG?U<MEciC7ELnDad4000015<NCaeC?TlM0P0000=?7T/MCah00P00
00A:oD/NB_e?7P@00008A_i77TKnAam6oTLNA_i77`@00003@_i37d;n00<00004?_i37ckn@_l50000
13lO>_ho7c[n0P0000@o7c[n?aljoP/00005>_lo7c[o?aljo`05000013/O?clk7clo0P0000Do7clo
?alo?clO00D00005?cm3?clo@clo?`05000014<oAem3?dMO0`0000=7Gd<nAel00P0000=7?TMOAch0
0P0000A;GdLnBem7?PD00004Aci;GdLnBel500001T]O000004LnBem7?P800004Bem7?T]OAch4000k
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool0009oo`03001o
ogoo011oo`0;001cV@00LmT006njLkY_^P00KiY_^P0200001F^kKk][^fnk00000f^K0`0000=W_6NL
00001FNL00H006=lIiaSO6Ml0005Hg`00`00HgaOG00500000emL000000020002Fed02UmMFed00000
FeeK?E]MFceKGE/m0P0000=K?ELmEcd01P0000AC7E<mDceG?@800004DaeC?U<MDcd40007Cah40004
Bah300000dKnAai6oP02000014LNA_h000000T;n00A37d;n@_i2oP@00004?alnoSko?_h20003?_l0
0ckn00000003000013[o?aljoclO0P0000@joc/O>alk7`H0008o7`04>alo7`000004?al600000clo
@clo?`02?cl50005@cl50006Acl50002Acl01DMOAcl00000Bel00dLo100000E;GdLnBcm;?d]O00H0
009;?`03Bci;?`00008003moo`03001oogoo009oo`03001oogoo009oo`03001oogoo00Uoo`@000Yo
o`000Woo00<007ooOol03goo00T007>H001_f@00KkUcfVniLkX00`0000E_f`00Kk][^fnk00H00004
Ii][_6NK0002Ii`01VMkIiaWW000HgaWW0`00004Gg`005mLGgd<000015/mFeeG?5]M0P0000IG?E]M
EceKGELmFed200000e<mEciC?@0400002U<nCaeC?U<MDci?7E<n001C?TlM0`0000=;7DlNBad00P00
00=?7T/N00000P0000A6oT/NA_i;7P@00006@_i77d;nAam2oTLO0P0000M2oT<O000003kn@alnoP02
000014<O?_i37ckn1@0000@joSlO>_ho7`800004>_ho7c[n?al6000013[n?alk7SlO0P0000@k7clO
>alo7`D00005?clo7d<o?alo?`0600001Clo@clo7d<o?cl01@0000E3?dMO@cm7?d<o00H00005Aem3
?TMOAci7G`05000014]OAci;GdLn0P0000=;GdLnBel00P0000=7?T]OAch02P00@Woo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol02goo00000goo001oo`0AOol200001W?I
001_^W>jKkYc^P800006KkY_f`00Kk][^fnk0P0000UW^f^lJk`006NLIkaWW6^l00000fNL1@0000]S
W@00HieSO6>MHgaSW@00HgeOOF=m00D0009OO@800005GeeKGEmMFed00003Fed6000015/mEceG?ELm
0P001ELm0P000U<m0`0000AC?E<M0000009?7P04Dci?7DlNCah30007Bah40004Aah2000014LN@_i7
7TKn100000E37d;n@_i2oT<O0092oP@00004?_lo7ckn?al2000013kn?alnoclO1@000clO00Dk7`00
000003/O00<o7`D000@o7`800003?clo7clo00800003?am3?clo00<000=3?`8000=3?`8000=3?`80
00=7?`800003Acm7GdLo00<000A7?`@00005Aci7?dLoBem7?P02Acl4000014/oAci;?d/o1000@goo
00<007ooOol00Woo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol02goo00000goo001oo`0@
Ool01`00LmY_fG?J001cfVni00800006Km][^VoK001_^f^k0P0000U[g6NkJkaW^`00Ii][_6NKJk`0
1P0000USW6NmHiaWW@00HieSO6>MGg`00P0000=SOEmlHid00`0000=OOEmLGgd00P0000QKGEmmFeaO
OE]M001KGEmM0e]M00EOG@00FeeG?E]N00H00003DceG?U<m00800007EciC?ELnDaeG?U<mEch01000
00A?7E<nCaeC?P800003Cae??T/M00800003Cai;7DlN00800003Aai;7T/N00800004Bam6oT/NA_h5
000014;nAam2oTLO0P0000<noT<O?_h00P0000Y37ckn000004<O?_i37ckn@alnoP@00004?aljoSlO
?_h3000013[n?aljoSlO1@0000@o7c/O?clo7`800004?clo7clo?al500001SlO@clo7d<o?am3?`D0
0005Acm3?d<o@cm7?`0500001DMO@ci7Gd<nAel01@0000A;GdLnAem7?P<00003Aci;GdLn00800003
Bem7?T]O00800004Aci;GdLnBel40004Ool3000nOol30005Ool4000<Ool50009Ool00003Ool007oo
00moo`06001cfG?ILmT007>j0P0000E_fP00KkY_ffnj00@00007JkaW^f^lJk`006NLIk`01000011S
_6NmHk`006>LHieSW6>M001SWF=lHieSO000GgaSO@/00005GeeKGEmMFed00005Fed20003Fed015MM
Fed000000eLm1@000e<m00QC?U<m000005<nDceC?U<m10001dlN0`001d/N100014LN0P0000A2oTLO
@_i37P@00006@_i37ckn@am2oT<O0P0000@noclO0000008o7`05?_h00000?alno`03?al50004?al2
0004?al500001ClO?clo7clo?al01P001D<o1@000T<o00=7?d<o@cl01@001DLo1@001TLo100000A;
?dLnBcm7?`<000Yoo`<003eoo`03001oogoo025oo`0000=oo`00Ool03goo00@006oILmY_^@800006
KoY[fP00JkY_ff^j0P0000E[g000JmaW^f^l00D0000>Imd006NmHiaW_F>L001SW6NmHiaWW@00HieS
O0H000]oo``00003EceKGULm0080000:FeiG?EMNEceKGULm001C?EMNDcd500001TlMDci?7E<nCaeC
?P800007CaeC?P00001;7DlnCad00P0000=??T/NCah00P000T/N00I77P00001;7TKnBal3000014LO
A_i77dKn100000A77d;n@am2oP800004@alnoT<O?_h400001d<O?_i37ckn@alnoT<O00D00004?aln
oT<O?ah2000013lO?aho7c[n1@0000@o7clo?am3?`800003?am3?clO00800003@clo7d<o00800003
?am3?clO00<00003@am7?d<o00800003Acm3?TLo00800003@ci7?d<n00800003Aem3?TMO00800004
Aci7GdLnAel6000014LnBem7?T]O100047oo0`00>Woo00<007ooOol08Goo00000goo001oo`0>Ool0
1P00LmUcfG?I001[fP9_fP03001_^VoK00800005Im][ff_K001W^`03000036>lIkaW_6OL001W_6>l
IkeS_000HiaSW@H00004Ool00000000IOol50003Ecd01UMM000005LmEciC?@9G?@800006DciC?@00
001C?U<m0P000Tln00AC?TlNCci??P<00003Bai?7T/N009;7P03Cai;7P0000800008Aai;7TLNBai7
7T/NAai;7P@000=77P<00004@ai37d;n@ah4000014<N@alnoT<O0`000clO0P000SlO0`0013lO1@00
13lO0P0013lO1@0000=3?clO@cl00T<o1@001T<o100000=7?d<oAcl00TLo00=3?`0000000`0014Lo
0P000dLo0P000dLo0P005Woo0`00=goo00<007ooOol08Goo00000goo001oo`0>Ool02@00LmY_^@00
JmY_nV_J001[^P0300000fOKJmaW^`0300002F?L001S_6OMHkaWg@00IkeSW0060004Ool3000QOol6
00000eMNDceGGP0200001U<mDciC?ELnDceC?P@00005CaeC?TlMDci?7@0200000dlnBad000020000
0d/MCci;7P0200000d/nBah0000200000dLNBai6oP0200000d/OA_i;7`02000014;nAam2oTLO1@00
00=37d;n@al00`0000A37ckn@alnoPD00005?_i37ckn@alnoP05000013lN@alo7T<O0P0000@o7T<o
?aho7`D00005@clo7d<o?am3?`0500001D<o?am3?d<O@cl01P0000A3?TLo@ci7?`H00005@ci7Gd<n
Acm3?P0500001DLnAem7?T]OAch010006goo0`00<goo0P008goo00000goo001oo`0=Ool00`00LmUc
f@020003KmX200000fOk001Wf`02Jm/20002Hm`01000HkaW_6Nl1@001goo0`00:Woo1@0000EC?U<m
DciC?E<n008000=C?PD00007Cai??TlNCci?7TlnCah010001D/N10001dLN100000A77d<NAai37P80
0004@am37T<O@ah50002@al00clN@am37`050003?al00d<O00000004?al500001D<O?alo7clO@al0
1@000d<o00=37`0000000d<o0P000d<o0P000T<o00I7?`000013?dLo@cl20003Acl30004Acl5000R
Ool3000aOol00`00Oomoo`0QOol00003Ool007oo00eoo`@00009KoY[fVoj001[nfOJJo/006_L0080
0003HmaWg6?L00D000Yoo`80039oo`H00004CceC?TlMDch200000dlMDci?7@0200000dlnCai??P02
000014/NCci;7Tln1@0000A;7TLNBcm77P800003Bam77T/O00800003Aai77dKn00800004Aam2oTLO
@_h5000013kn@am2oT<O0P0000<noT<O?_h00P0000=37ckn@al00P0000@noT<O?ai37`D00004@clo
7T<O?ah200000d<o?ai3?`0200000clN@clo7P02000014<o?ai3?clN1@0000E3?T<o@ai7?d<n00D0
0005@ci7?d<nAcm3?P05000014LnAcm3?TMO0`00:Goo0`00;Woo00<007ooOol08Goo00000goo001o
o`0<Ool2000016_i001_fVoJ0P000fOk10000f?L0P002goo0`00>Woo10001dln100000A;7TlNBai?
?P800003Bai;?T/N008000A;7PD000=77P03Aam77P0000@00004@ai77d<N@al2000014<N@am37T<O
1@000d<O00<o7T<O0000100000A37clO@alo7`80008o7`03@alo7`0000@00005@am3?clO@cm37`05
0005@cl500000d<oAcm3?`02@cl50005Acl4000_Ool3000[Ool00`00Oomoo`0QOol00003Ool007oo
00aoo`04001[nP00KoX300000f_kImX00002000015oKHo`006OL0P002Woo0`00@Goo0`0000=C?TlM
Dch00P0000=;7DlnCah0100000M;?T/NCcm;7T/nBai??`0400001DLNBam77T/oAah01@0000A37TLO
@ai77`800004@ai77d;nAal500001D<O?_i37d<N@al01@0000A37clN@alo7P800004@alo7T<O?ah5
00001ClN@clo7T<o?ah01@0000E37T<o?ai3?d<N00D00004@ai7?d<N@cl200000d<nAcm37P020000
14Lo@ci7?d<n1@00=Woo0`009goo0P008goo00000goo001oo`0;Ool00`00JoU[n@0200000f?j001W
n`0300000f?lGmaSo0030009Ool30017Ool40002Cch01TlNCch00000Bai??P<0009;7P03Bch00000
009;7P800003Aai;7TLN00800003Aam77TLN008000=77P03Aal0000000<00004@am37T<O@ah20000
0d<O@ai37`0200000d<N@am37`020003@al00clN000000030002@al00clO@am37`05000014<O@cm3
7d<o0P0000=37d<o@al00P0000=3?d<O@cl00P0014<o1@0000A7?d<oAcm3?`8003eoo`<002Eoo`03
001oogoo025oo`0000=oo`00Ool02Woo00H006_jJoT006?iHoX500000f?lGm/000020009Ool2001>
Ool400001dlnBai??T/NCci;7Tln00@00005Aai;?d/NBci77P0300001dLNBcm77TLOAai;?dLN00@0
0004Aam37TLO@ah2000014LO@ai77d;n1@0000E37T<O?ai37d<N00D00004?ai3?clN@al200000clN
@clo7P0200000d<o?ai3?`02000013lN@clo7T<o1@0000E3?d<N@cm37T<o00D00005Acm37TLo@ci7
?`040012Ool3000ROol00`00Oomoo`0QOol00003Ool007oo00Uoo`04001[n@000002HoX200000eOJ
000000030009Ool3001DOol200000d/NCci;7P02000014/nBai;?T/N1@0000=77T/NAah00`0000=7
7TLOAah00P0000Q77dLN000004LO@ai77dLN1@0000E37T<O@am37d<N00D000937`04@ai37`000004
@al50002@al00d<o@am37`0500001D<o@am3?d<O@cl01@001D<o1@00BGoo0`007goo00<007ooOol0
8Goo00000goo001oo`08Ool01@00JoX00000HoT00P0000AKn`00000000Yoo`<005Uoo`@00004Ccm;
7TlnBah200000d/oAai;?`02000014LNBcm77T/o1@0000E7?dLNAam37TLo00@00005@ai77d<NAam3
7P05000014<NAcm37T<O0P0000A37T<O?ai3?`D00005@clo7T<o@ai3?`05000014<o@ai3?clN0P00
00=3?clN@cl00P0000M37TLo000004<NAcm37P03001@Ool3000KOol3000ROol00003Ool007oo00Qo
o`P000Yoo`<0061oo`@000=;7P04Bci;7T/NBah400001DLOAai77TLNAal01@0000=77dLNAal00P00
00=37TLO@ah00P0000=77d<N@al00P0000A37T<O@am37`D000=37`03@ai37`0000@00004@cm37d<O
@al2000014<o@am3?d<O10000d<o00=37d<o00000`00EWoo100067oo00<007ooOol08Goo00000goo
001oo`07Ool7000:Ool2001WOol200000d/oBai;?`0200000dLNBcm77P0200000d/oAai;?`020000
0dLNBcm77P02000014Lo@ai77d<N100000E7?d<NAam37TLo00D00004@am37TLo@ah200000d<o@ai3
7`0200000d<N@cm37P02000014<o?ai3?d<N1@0000A37T<o@ai3?`D005ioo`<001Ioo`03001oogoo
00=oo`D001Qoo`0000=oo`00Ool01Woo00@005OG0017]`8000Uoo`<006]oo`@00005Aai;7T/NBci7
7P0500000dLNAam77P02Aah5000014<NAam77TLO1@000T<O00I77d<N000004<O@ah2@al500001D<N
@am37d<O@ah01@0000A37d<o@am3?`D006Ioo`<001=oo`03001oogoo00Eoo`03001oogoo01Qoo`00
00<007ooOol01Goo1@0027oo0`00LWoo1@0000E77T/oAai;?dLN00D00004Aai7?d<NAcl200000d<N
Acm37P02000024Lo@ah00000Acm37TLO@ah500001D<N@cm37TLo@ah01@0000A37TLo@ai3?`D006io
o`<000moo`8000Moo`03001oogoo01Qoo`0000<007ooOol017oo10001goo0`00NGoo0P000dLN0P00
0TLN00M7?`0000177TLOAai77`0500001DLO@ai77d<NAal0100000E37T<O@am37d<N00D00004@am3
?d<N@al20003@al2001dOol3000=Ool00`00Oomoo`05Ool00`00Oomoo`0HOol00003001oogoo00=o
o`@000Ioo`8007ioo`@00005Bcm77T/oAai;?`0500001DLo@ai7?d<NAcl01@0000=7?d<NAcl00P00
00=37TLo@ah00P0000=7?d<NAcl00P0000A37T<o@ai7?`@007Uoo`<000Yoo`03001oogoo00Eoo`03
001oogoo01Qoo`0000<007ooOol00Woo0`001Goo0`00Q7oo1@0000A7?dLNAam77P800003Aam77TLO
00800008Aai77`0000137dLO@ai77`D00005@cm37T<O@am3?`050020Ool30007Ool00`00Oomoo`05
Ool00`00Oomoo`0HOol00004001oogooOol20004Ool3002;Ool2000014LoAai7?dLN1@0000E37TLo
@ai7?d<N00@00005Acm37TLo@ai7?`050028Ool30004Ool00`00Oomoo`03Ool3000JOol00004001o
o`000003Ool3002@Ool400001DLNAcm77TLOAah01@0000A37TLOAai7?`D0091oo`D000Moo`03001o
ogoo01Qoo`000P000goo0P00Ugoo1@0000A77TLo@ai7?`800003@ai7?d<N008009Ioo`80029oo`00
00<007oo00000P00WGoo0P0000A77TLoAai77`@009Aoo`@002Aoo`000`00XGoo1000U7oo1000:7oo
0003Ool4002NOol00`00Oomoo`2@Ool4000/Ool000Moo`@009Yoo`03001oogoo08aoo`@0031oo`00
2goo1@00UGoo00<007ooOol0R7oo1000=7oo000@Ool4002AOol00`00Oomoo`24Ool4000hOol001Ao
o`@008eoo`03001oogoo081oo`@003aoo`0067oo1@00R7oo00<007ooOol0O7oo1000@7oo000MOol4
0024Ool00`00Oomoo`1hOol40014Ool0025oo`@0081oo`03001oogoo07Aoo`@004Qoo`009Goo1@00
Ngoo00<007ooOol0L7oo1000C7oo000ZOol4001gOol00`00Oomoo`1/Ool4001@Ool002ioo`@007=o
o`03001oogoo06Qoo`@005Aoo`00<Woo1@00KWoo00<007ooOol0I7oo1000F7oo000gOol4001ZOol0
0`00Oomoo`1POol4001LOol003]oo`@006Ioo`03001oogoo05aoo`@0061oo`00?goo1@00HGoo00<0
07ooOol0F7oo1000I7oo0014Ool4001MOol00`00Oomoo`1DOol4001XOol004Qoo`@005Uoo`03001o
ogoo051oo`@006aoo`00C7oo1@00E7oo00<007ooOol0C7oo1000L7oo001AOol4001@Ool00`00Oomo
o`18Ool4001dOol005Eoo`D004]oo`03001oogoo04Aoo`@007Qoo`00FWoo1000Agoo00<007ooOol0
@7oo1000O7oo001NOol40013Ool00`00Oomoo`0lOol40020Ool0069oo`D003ioo`03001oogoo03Qo
o`@008Aoo`00Igoo1000>Woo00<007ooOol0=7oo1000R7oo001[Ool4000fOol00`00Oomoo`0`Ool4
002<Ool006moo`D0035oo`03001oogoo02aoo`@0091oo`00M7oo1000;Goo00<007ooOol0:7oo1000
U7oo001hOol4000YOol00`00Oomoo`0TOol4002HOol007aoo`D002Aoo`03001oogoo021oo`@009ao
o`00PGoo100087oo00<007ooOol077oo1000X7oo0025Ool4000LOol00`00Oomoo`0HOol4002TOol0
08Uoo`D001Moo`03001oogoo01Aoo`@00:Qoo`00SWoo10004goo00<007ooOol047oo1000[7oo002B
Ool4000?Ool00`00Oomoo`0<Ool4002`Ool009Ioo`D000Yoo`03001oogoo00Qoo`@00;Aoo`00Vgoo
10001Woo00<007ooOol017oo1000^7oo002OOol40002Ool00`00Oomoo`04002lOol00:=oo`D00<1o
o`00ogooJGoo003oOomYOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {216, 0}} -> {0.00419387, 0.0989, 0.00382024, \
0.00382024}}]
}, Open  ]],

Cell["\<\
A contour plot of the temperature variation illustrates that the \
worm in a depth of about 1.5 meters cannot feel any changes in the \
temperature. Worms which are between the surface and the 1.5-meter limit are \
able to realize the temperature changes during the year. However, the contour \
plot shows also that a worm located at a certain depth will measure a certain \
value of the temperature some time later than an observer on the surface. \
This delay is larger for worms living in a deeper region.\
\>", "Text",
  CellTags->{"temperature variation", "contour plot"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[solution /. T\_2 \[Rule] 1, {x, 0, 2}, {t, 0, 1}, \n\t
      PlotRange \[Rule] All, \n\tPlotPoints \[Rule] 30, 
      AxesLabel \[Rule] {"\<x\>", "\<t\>"}, \n\tColorFunction \[Rule] Hue, 
      Axes \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.480769 0.0192308 0.961538 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -9 -9 ]
[.25962 -0.0125 9 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .21154 -18 -4.5 ]
[-0.0125 .21154 0 4.5 ]
[-0.0125 .40385 -18 -4.5 ]
[-0.0125 .40385 0 4.5 ]
[-0.0125 .59615 -18 -4.5 ]
[-0.0125 .59615 0 4.5 ]
[-0.0125 .78846 -18 -4.5 ]
[-0.0125 .78846 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .21154 m
.00625 .21154 L
s
[(0.2)] -0.0125 .21154 1 0 Mshowa
0 .40385 m
.00625 .40385 L
s
[(0.4)] -0.0125 .40385 1 0 Mshowa
0 .59615 m
.00625 .59615 L
s
[(0.6)] -0.0125 .59615 1 0 Mshowa
0 .78846 m
.00625 .78846 L
s
[(0.8)] -0.0125 .78846 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(1)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .25962 m
.00375 .25962 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .45192 m
.00375 .45192 L
s
0 .5 m
.00375 .5 L
s
0 .54808 m
.00375 .54808 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .74038 m
.00375 .74038 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .21154 m
1 .21154 L
s
.99375 .40385 m
1 .40385 L
s
.99375 .59615 m
1 .59615 L
s
.99375 .78846 m
1 .78846 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .25962 m
1 .25962 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .5 m
1 .5 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .74038 m
1 .74038 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 .4 r
.01923 .72625 m
.05239 .74312 L
.06327 .74867 L
.08554 .75974 L
.1187 .77608 L
.13034 .78183 L
.15186 .79211 L
.18501 .80779 L
.20032 .81499 L
.21817 .82305 L
.25133 .83787 L
.27492 .84814 L
.28448 .85212 L
.31764 .86579 L
.3508 .87871 L
.35733 .8813 L
.38395 .89082 L
.41711 .90194 L
.45027 .91183 L
.45827 .91446 L
.48342 .92028 L
.51658 .92692 L
.54973 .93112 L
.58289 .93187 L
.61605 .92697 L
.64215 .91446 L
.6492 .90823 L
.66392 .8813 L
.66425 .84814 L
.65459 .81499 L
.6492 .79952 L
.6384 .78183 L
.61728 .74867 L
.61605 .74686 L
.5921 .71552 L
.58289 .70423 L
.56345 .68236 L
.54973 .6675 L
.5317 .6492 L
.51658 .63426 L
.49713 .61605 L
.48342 .60347 L
.45996 .58289 L
.45027 .57453 L
.42039 .54973 L
.41711 .54705 L
.38395 .52073 L
.37855 .51658 L
.3508 .4954 L
.33461 .48342 L
.31764 .47093 L
.2888 .45027 L
.28448 .44718 L
.25133 .42403 L
.24119 .41711 L
.21817 .40142 L
.192 .38395 L
.18501 .37928 L
.15186 .35754 L
.14138 .3508 L
.1187 .33616 L
.08953 .31764 L
.08554 .3151 L
.05239 .29429 L
.03684 .28448 L
.01923 .27375 L
F
0 g
.01923 .72625 m
.05239 .74312 L
.06327 .74867 L
.08554 .75974 L
.1187 .77608 L
.13034 .78183 L
.15186 .79211 L
.18501 .80779 L
.20032 .81499 L
.21817 .82305 L
.25133 .83787 L
.27492 .84814 L
.28448 .85212 L
.31764 .86579 L
.3508 .87871 L
.35733 .8813 L
.38395 .89082 L
.41711 .90194 L
.45027 .91183 L
.45827 .91446 L
.48342 .92028 L
.51658 .92692 L
.54973 .93112 L
.58289 .93187 L
.61605 .92697 L
.64215 .91446 L
.6492 .90823 L
.66392 .8813 L
.66425 .84814 L
.65459 .81499 L
.6492 .79952 L
.6384 .78183 L
.61728 .74867 L
.61605 .74686 L
.5921 .71552 L
.58289 .70423 L
.56345 .68236 L
.54973 .6675 L
.5317 .6492 L
.51658 .63426 L
.49713 .61605 L
.48342 .60347 L
.45996 .58289 L
.45027 .57453 L
.42039 .54973 L
.41711 .54705 L
.38395 .52073 L
.37855 .51658 L
.3508 .4954 L
.33461 .48342 L
Mistroke
.31764 .47093 L
.2888 .45027 L
.28448 .44718 L
.25133 .42403 L
.24119 .41711 L
.21817 .40142 L
.192 .38395 L
.18501 .37928 L
.15186 .35754 L
.14138 .3508 L
.1187 .33616 L
.08953 .31764 L
.08554 .3151 L
.05239 .29429 L
.03684 .28448 L
.01923 .27375 L
Mfstroke
0 .4 1 r
.01923 .24458 m
.03321 .25133 L
.05239 .26133 L
.08554 .27782 L
.09895 .28448 L
.1187 .294 L
.15186 .30987 L
.16821 .31764 L
.18501 .32534 L
.21817 .34039 L
.24163 .3508 L
.25133 .35492 L
.28448 .3689 L
.31764 .38219 L
.32193 .38395 L
.3508 .39474 L
.38395 .40637 L
.41711 .41686 L
.41776 .41711 L
.45027 .42611 L
.48342 .43372 L
.51658 .43921 L
.54973 .44182 L
.58289 .4402 L
.61605 .43079 L
.63352 .41711 L
.64844 .38395 L
.64614 .3508 L
.63487 .31764 L
.61752 .28448 L
.61605 .2819 L
.59545 .25133 L
.58289 .23432 L
.56949 .21817 L
.54973 .19524 L
.54015 .18501 L
.51658 .16046 L
.50777 .15186 L
.48342 .12852 L
.47262 .1187 L
.45027 .0987 L
.4349 .08554 L
.41711 .07051 L
.39482 .05239 L
.38395 .04375 L
.35255 .01923 L
.01923 .01923 L
F
0 g
.01923 .24458 m
.03321 .25133 L
.05239 .26133 L
.08554 .27782 L
.09895 .28448 L
.1187 .294 L
.15186 .30987 L
.16821 .31764 L
.18501 .32534 L
.21817 .34039 L
.24163 .3508 L
.25133 .35492 L
.28448 .3689 L
.31764 .38219 L
.32193 .38395 L
.3508 .39474 L
.38395 .40637 L
.41711 .41686 L
.41776 .41711 L
.45027 .42611 L
.48342 .43372 L
.51658 .43921 L
.54973 .44182 L
.58289 .4402 L
.61605 .43079 L
.63352 .41711 L
.64844 .38395 L
.64614 .3508 L
.63487 .31764 L
.61752 .28448 L
.61605 .2819 L
.59545 .25133 L
.58289 .23432 L
.56949 .21817 L
.54973 .19524 L
.54015 .18501 L
.51658 .16046 L
.50777 .15186 L
.48342 .12852 L
.47262 .1187 L
.45027 .0987 L
.4349 .08554 L
.41711 .07051 L
.39482 .05239 L
.38395 .04375 L
.35255 .01923 L
s
.2 1 0 r
.01923 .69656 m
.05239 .70937 L
.06868 .71552 L
.08554 .72131 L
.1187 .73227 L
.15186 .74197 L
.17783 .74867 L
.18501 .75011 L
.21817 .75641 L
.25133 .76014 L
.28448 .76015 L
.31764 .75374 L
.32954 .74867 L
.3508 .73075 L
.35868 .71552 L
.36136 .68236 L
.35305 .6492 L
.3508 .64127 L
.3378 .61605 L
.31764 .58313 L
.31744 .58289 L
.29289 .54973 L
.28448 .53917 L
.26479 .51658 L
.25133 .50173 L
.23354 .48342 L
.21817 .46803 L
.19942 .45027 L
.18501 .4369 L
.16267 .41711 L
.15186 .40769 L
.12349 .38395 L
.1187 .38 L
.08554 .35351 L
.08203 .3508 L
.05239 .32803 L
.03859 .31764 L
.01923 .30344 L
F
0 g
.01923 .69656 m
.05239 .70937 L
.06868 .71552 L
.08554 .72131 L
.1187 .73227 L
.15186 .74197 L
.17783 .74867 L
.18501 .75011 L
.21817 .75641 L
.25133 .76014 L
.28448 .76015 L
.31764 .75374 L
.32954 .74867 L
.3508 .73075 L
.35868 .71552 L
.36136 .68236 L
.35305 .6492 L
.3508 .64127 L
.3378 .61605 L
.31764 .58313 L
.31744 .58289 L
.29289 .54973 L
.28448 .53917 L
.26479 .51658 L
.25133 .50173 L
.23354 .48342 L
.21817 .46803 L
.19942 .45027 L
.18501 .4369 L
.16267 .41711 L
.15186 .40769 L
.12349 .38395 L
.1187 .38 L
.08554 .35351 L
.08203 .3508 L
.05239 .32803 L
.03859 .31764 L
.01923 .30344 L
s
.2 0 1 r
.01923 .21485 m
.03057 .21817 L
.05239 .22753 L
.08554 .23934 L
.1187 .25005 L
.12226 .25133 L
.15186 .25954 L
.18501 .26747 L
.21817 .27337 L
.25133 .27656 L
.28448 .27584 L
.31764 .26842 L
.34166 .25133 L
.3508 .23739 L
.35599 .21817 L
.35343 .18501 L
.3508 .1752 L
.34201 .15186 L
.32453 .1187 L
.31764 .10705 L
.30238 .08554 L
.28448 .06192 L
.27634 .05239 L
.25133 .0252 L
.24693 .01923 L
.01923 .01923 L
F
0 g
.01923 .21485 m
.03057 .21817 L
.05239 .22753 L
.08554 .23934 L
.1187 .25005 L
.12226 .25133 L
.15186 .25954 L
.18501 .26747 L
.21817 .27337 L
.25133 .27656 L
.28448 .27584 L
.31764 .26842 L
.34166 .25133 L
.3508 .23739 L
.35599 .21817 L
.35343 .18501 L
.3508 .1752 L
.34201 .15186 L
.32453 .1187 L
.31764 .10705 L
.30238 .08554 L
.28448 .06192 L
.27634 .05239 L
.25133 .0252 L
.24693 .01923 L
s
0 .4 1 r
.01923 .75542 m
.05239 .77609 L
.06145 .78183 L
.08554 .79701 L
.11362 .81499 L
.1187 .81824 L
.15186 .83979 L
.16447 .84814 L
.18501 .86172 L
.21403 .8813 L
.21817 .8841 L
.25133 .90697 L
.26194 .91446 L
.28448 .9304 L
.30818 .94761 L
.31764 .95454 L
.3508 .97942 L
.35255 .98077 L
.01923 .98077 L
F
0 g
.01923 .75542 m
.05239 .77609 L
.06145 .78183 L
.08554 .79701 L
.11362 .81499 L
.1187 .81824 L
.15186 .83979 L
.16447 .84814 L
.18501 .86172 L
.21403 .8813 L
.21817 .8841 L
.25133 .90697 L
.26194 .91446 L
.28448 .9304 L
.30818 .94761 L
.31764 .95454 L
.3508 .97942 L
.35255 .98077 L
s
.2 0 1 r
.01923 .78515 m
.05239 .80989 L
.05903 .81499 L
.08554 .83549 L
.10136 .84814 L
.1187 .86215 L
.14151 .8813 L
.15186 .8901 L
.17928 .91446 L
.18501 .91962 L
.21449 .94761 L
.21817 .95125 L
.24693 .98077 L
.01923 .98077 L
F
0 g
.01923 .78515 m
.05239 .80989 L
.05903 .81499 L
.08554 .83549 L
.10136 .84814 L
.1187 .86215 L
.14151 .8813 L
.15186 .8901 L
.17928 .91446 L
.18501 .91962 L
.21449 .94761 L
.21817 .95125 L
.24693 .98077 L
s
.8 1 0 r
.01923 .66505 m
.05239 .67288 L
.08554 .67863 L
.1187 .68159 L
.15186 .68056 L
.18501 .67318 L
.21306 .6492 L
.21817 .63895 L
.22232 .61605 L
.21817 .5855 L
.21745 .58289 L
.20454 .54973 L
.18596 .51658 L
.18501 .51501 L
.1629 .48342 L
.15186 .46892 L
.13609 .45027 L
.1187 .43049 L
.10599 .41711 L
.08554 .39614 L
.07292 .38395 L
.05239 .36453 L
.03724 .3508 L
.01923 .33495 L
F
0 g
.01923 .66505 m
.05239 .67288 L
.08554 .67863 L
.1187 .68159 L
.15186 .68056 L
.18501 .67318 L
.21306 .6492 L
.21817 .63895 L
.22232 .61605 L
.21817 .5855 L
.21745 .58289 L
.20454 .54973 L
.18596 .51658 L
.18501 .51501 L
.1629 .48342 L
.15186 .46892 L
.13609 .45027 L
.1187 .43049 L
.10599 .41711 L
.08554 .39614 L
.07292 .38395 L
.05239 .36453 L
.03724 .3508 L
.01923 .33495 L
s
.8 0 1 r
.01923 .18322 m
.02644 .18501 L
.05239 .19087 L
.08554 .19645 L
.1187 .19918 L
.15186 .19763 L
.18501 .18794 L
.19023 .18501 L
.21633 .15186 L
.21806 .1187 L
.2092 .08554 L
.19358 .05239 L
.18501 .03773 L
.1729 .01923 L
.01923 .01923 L
F
0 g
.01923 .18322 m
.02644 .18501 L
.05239 .19087 L
.08554 .19645 L
.1187 .19918 L
.15186 .19763 L
.18501 .18794 L
.19023 .18501 L
.21633 .15186 L
.21806 .1187 L
.2092 .08554 L
.19358 .05239 L
.18501 .03773 L
.1729 .01923 L
s
.8 0 1 r
.01923 .81678 m
.05239 .84657 L
.05406 .84814 L
.08554 .87845 L
.08836 .8813 L
.1187 .91321 L
.11981 .91446 L
.14812 .94761 L
.15186 .9524 L
.1729 .98077 L
.01923 .98077 L
F
0 g
.01923 .81678 m
.05239 .84657 L
.05406 .84814 L
.08554 .87845 L
.08836 .8813 L
.1187 .91321 L
.11981 .91446 L
.14812 .94761 L
.15186 .9524 L
.1729 .98077 L
s
1 .6 0 r
.01923 .62954 m
.05239 .62966 L
.08554 .62349 L
.10185 .61605 L
.1187 .60107 L
.12789 .58289 L
.12967 .54973 L
.12085 .51658 L
.1187 .50943 L
.10525 .48342 L
.08554 .4514 L
.0846 .45027 L
.05982 .41711 L
.05239 .40783 L
.03158 .38395 L
.01923 .37046 L
F
0 g
.01923 .62954 m
.05239 .62966 L
.08554 .62349 L
.10185 .61605 L
.1187 .60107 L
.12789 .58289 L
.12967 .54973 L
.12085 .51658 L
.1187 .50943 L
.10525 .48342 L
.08554 .4514 L
.0846 .45027 L
.05982 .41711 L
.05239 .40783 L
.03158 .38395 L
.01923 .37046 L
s
1 0 .6 r
.01923 .14754 m
.05239 .14733 L
.08554 .14115 L
.11655 .1187 L
.1187 .11561 L
.12807 .08554 L
.12424 .05239 L
.1187 .03503 L
.11201 .01923 L
.01923 .01923 L
F
0 g
.01923 .14754 m
.05239 .14733 L
.08554 .14115 L
.11655 .1187 L
.1187 .11561 L
.12807 .08554 L
.12424 .05239 L
.1187 .03503 L
.11201 .01923 L
s
1 0 .6 r
.01923 .85246 m
.04488 .8813 L
.05239 .89 L
.07129 .91446 L
.08554 .93396 L
.09393 .94761 L
.11201 .98077 L
.01923 .98077 L
F
0 g
.01923 .85246 m
.04488 .8813 L
.05239 .89 L
.07129 .91446 L
.08554 .93396 L
.09393 .94761 L
.11201 .98077 L
s
1 0 0 r
.01923 .58388 m
.02165 .58289 L
.05239 .5595 L
.05756 .54973 L
.06183 .51658 L
.0544 .48342 L
.05239 .47544 L
.03978 .45027 L
.01987 .41711 L
.01923 .41612 L
F
0 g
.01923 .58388 m
.02165 .58289 L
.05239 .5595 L
.05756 .54973 L
.06183 .51658 L
.0544 .48342 L
.05239 .47544 L
.03978 .45027 L
.01987 .41711 L
.01923 .41612 L
s
1 0 0 r
.01923 .10214 m
.04413 .08554 L
.05239 .07469 L
.05968 .05239 L
.05758 .01923 L
.01923 .01923 L
F
0 g
.01923 .10214 m
.04413 .08554 L
.05239 .07469 L
.05968 .05239 L
.05758 .01923 L
s
1 0 0 r
.01923 .89786 m
.02919 .91446 L
.04644 .94761 L
.05239 .96471 L
.05758 .98077 L
.01923 .98077 L
F
0 g
.01923 .89786 m
.02919 .91446 L
.04644 .94761 L
.05239 .96471 L
.05758 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{198, 198},
  ImageMargins->{{60.625, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003g0000ma000`40O003h00Omgoo003gOol00?Mo
o`006Woo10009Goo10001Goo0P001Goo10009Goo1@0097oo1@0017oo0P001Goo100097oo1@005Goo
000IOol00`00Oomoo`02Ool00`00Oomoo`0QOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool0
0`00Oomoo`02Ool00`00Oomoo`0TOol00`00Oomoo`0VOol00`00Oomoo`04Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`0QOol01@00Oomoogoo00005Goo000IOol00`00Oomoo`02Ool00`00Oomoo`0Q
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0TOol00`00Oomoo`0VOol00`00Oomoo`0?
Ool00`00Oomoo`0ROol00`00Oomoo`0FOol001Uoo`03001oogoo009oo`03001oogoo025oo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo02Aoo`03001oogoo02Ioo`03001oogoo00moo`03001o
ogoo02=oo`03001oogoo01Eoo`006Goo00<007ooOol00Woo00<007ooOol08Goo00<007ooOol00Woo
00<007ooOol02Goo10009goo00<007ooOol09Woo00<007ooOol02goo10009goo00<007ooOol057oo
000IOol00`00Oomoo`02Ool00`00Oomoo`0QOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomo
o`0XOol00`00Oomoo`0VOol00`00Oomoo`0;Ool00`00Oomoo`0YOol00`00Oomoo`0COol001Uoo`03
001oogoo009oo`03001oogoo025oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo02Ioo`<0
02Ioo`<000eoo`03001oogoo02Eoo`05001oogooOol0000EOol001Yoo`@002Eoo`@000aoo`D002Io
o`03001oogoo02Ioo`03001oogoo00]oo`D002Aoo`<001Ioo`00mgoo003gOol00?Moo`00kGoo0P00
0Woo0P0017oo003^Ool01000Oomoo`001Goo000IOoo<000:Ool20006Ool0011oo`@000Eoo`04001o
ogoo0009Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool01@00
Oomoogoo00002Woo0P001Woo000?Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`00<7oo
00<007ooOol0;Woo00<007ooOol0;Woo00<007ooOol0;Woo00D007ooOomoo`0000Uoo`04001oogoo
0005Ool000moo`03001oogoo009oo`03001oogoo009oo`03001oogoo0<Qoo`03001oogoo00Ioo`80
009oo`8000Aoo`003goo00<007ooOol00Woo00<007ooOol00Woo0P002Goo00<007ooOol027oo00<0
07ooOol02Woo00<007ooOol037oo00<007ooOol04Woo00<007ooOol0P7oo0P004Woo000?Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`08O0000`00O19l4P09O1803P00I1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0O000351l01APO51lD7a@O61l00a@O00@H7a@O51l001@1W`8007d3o`Aoo`03001o
ogoo011oo`003goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol027`000D007`BO19l4W`C
00=l4P0hO1=l4W`BO180060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il007`3
o`Aoo`03001oogoo011oo`003goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol027`000<0
07`BO1802W`B00l0060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061l00a@O00DH7a@O51lD7aPO00<D
7`0461lD7a@O000E0Il00`000ol3o`1i0ol4Ool00`00Oomoo`0@Ool0011oo`@000Eoo`03001oogoo
00Ul0003001l4g`B009l4P05O1=l4W`BO19l4`02O180=000I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0P00N@?o17oo00<007ooOol047oo000IOol00`00Oomoo`09O0000`00
O19l4P0:O1804000I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO0a@O00DH7a@O51lD7aPO00<D
7`0361lD7`0001L1W`030003o`?o07H3o`Aoo`03001oogoo011oo`006Goo00<007ooOol02G`000@0
07`BO19l4`=l4P0mO1=l4W`BO19l4g`B001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0000M`?o17oo00<007ooOol047oo000IOol00`00Oomoo`09O0000`00O19l4P0:
O1803`00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0000251l01APO51lD7a@O61l00a@O00LH7a@O
51lD7aPO51l0000G0Il00`000ol3o`1d0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Ul0003
001l4g`B009l4P05O1=l4W`BO19l4`03O180>@00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0001e0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Ql0003
001l4W`B00]l4P0@001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000351l01APO51lD7a@O61l0
0a@O00LH7a@O51lD7aPO51l0000G0Il2001c0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Ql
0005001l4W`BO19l4`03O180@W`CO19l4W`BO1=l4P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00783o`Aoo`03001oogoo011oo`006Goo00<007oo
Ool01g`000<007`BO1803G`B0140060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO00<D7`05
61lD7a@O51lH7`0351l01QPO51lD7a@O61l001T1W`030003o`?o06l3o`Aoo`03001oogoo011oo`00
6Goo00<007ooOol01g`000@007`BO19l4`=l4P05O1=l4W`BO19l4`03O180?W`C001T7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0006O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O001`0ol4Ool00`00
Oomoo`0@Ool001Uoo`03001oogoo00Il0003001l4W`B00il4P0C001P7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l001@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51l0000J0Il00`000ol3
o`1]0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Il0003001l4W`C00=l4P05O1=l4W`BO19l
4`03O180@W`CO19l4P00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il006h3o`Aoo`03001oogoo011oo`006Goo00<007ooOol017`00P004G`B
0140060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0000<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00<0006O0Il0606O0P00K0?o17oo00<007ooOol047oo000IOol00`00Oomoo`02
O0020002O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P13001P7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`00
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000J`?o
17oo00<007ooOol047oo000IOol00`00Oomoo`02000DO1805000I1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7`0061l351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO008D7`030001W`6O
01X1W`030003o`?o06P3o`Aoo`03001oogoo011oo`006Goo00@007ooOoml4`=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B04Il4g`B001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`8006P3o`Aoo`03001oogoo
011oo`006Goo00<007ooOol05G`B01L0060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0O000D7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00Q@O00<0006O0Il06`6O00<0
00?o0ol0I@?o17oo00<007ooOol047oo000IOol00`00Oomoo`02O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P1<O1=l4P00001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O001V0ol4Ool00`00Oomo
o`0@Ool001Uoo`03001oogoo01=l4P0G001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1l0000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7`0001h1W`03
0003o`?o06<3o`Aoo`03001oogoo011oo`006Goo00@007ooOoml4`=l4P05O1=l4W`BO19l4`03O180
E7`CO19l4W`BO1=l4P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0
01PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il006@3o`Aoo`03001o
ogoo011oo`006Goo00<007ooOol047`B0P0001YP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0O000D7aPO0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO
0001W`0N0Il00`000ol3o`1Q0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo009l4P05O1=l4W`B
O19l4`03O180F7`CO19l4W`BO1<006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`00HP?o17oo00<007ooOol047oo000IOol00`00Oomoo`0;O18400006f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0000351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51l0000P0Il00`000ol3o`1O0ol4Ool00`00Oomoo`0@Ool0
01Uoo`03001oogoo00/0001IH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il0001P0ol4Ool00`00Oomoo`0@Ool001Uoo`0_001oogooH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7`0051lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0461lD7a@O
000Q0Il00`000ol3o`1M0ol4Ool00`00Oomoo`0@Ool001Uoo`1Y001oogooI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`0005h3o`Aoo`03001oogoo011oo`006Goo02d007ooOomP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0
01@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01aPO51lD7a@O61lD7`000281
W`030003o`?o05/3o`Aoo`03001oogoo011oo`006Goo06/007ooOomT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`000Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`0005`3o`Aoo`03001oogoo011oo`006Goo02/007ooOomP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO0001
W`0R0Il00`000ol3o`1I0ol4Ool00`00Oomoo`0@Ool001Uoo`1]001oogooI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0
01PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0000FP?o17oo00<007ooOol047oo000IOol0:@00Oomoof0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7`0061l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7`0002@1W`030003o`?o05L3o`Aoo`03001oogoo011oo`006Goo00<007ooOol01@0006MP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0
01PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0001H0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00<D
7`0361lD7`0000D0000FI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l2
00001APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00<H7a@O00009P6O00<000?o0ol0E@?o17oo00<007ooOol047oo00040005Ool20004Ool5
0005Ool03P00OomooaPO51lH7a@O61lD7aPO51lH7a@O61l7000036@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7`<0001=51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0001F0ol4Ool00`00Oomoo`0@
Ool000Aoo`03001oogoo009oo`8000Aoo`05001oogooOol00005Ool01@00Oomooa@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0<000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7`0002P1W`030003o`?o
05<3o`Aoo`03001oogoo011oo`0017oo00<007ooOol02Goo00<007ooOol01Woo07<007ooOolH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0001D0ol4Ool00`00Oomoo`0@Ool0
00Aoo`03001oogoo00Yoo`03001oogoo00Eoo`800005OolD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00LH7a@O51lD7aPO51l0000Y0Il0
0`000ol3o`1B0ol3Ool2000BOol000Aoo`03001oogoo00]oo`03001oogoo00Aoo`03001oogoo0080
001_61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0005<3o`Aoo`03001oogoo
011oo`0017oo00<007ooOol037oo00<007ooOol00goo00<007ooOol00P6O0P0000<D7aPO51l00Q@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51l0000[0Il00`000ol3o`1@0ol4Ool00`00Oomoo`0@Ool000Aoo`03001oogoo00Qoo`05001oogoo
Ool00005Ool01`00Oomoo`6O0Gl1W`5o0080001]61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0000D@?o17oo00<007ooOol047oo0004000<Ool30006Ool00`00Oomoo`060Il3000251l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7`000Il0
;06O00<000?o0ol0C`?o17oo00<007ooOol047oo000IOol03000Oomoo`6O0Gl1W`5o0Il1O`6O0Gl1
W`@0001W51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0000D0?o17oo00<007ooOol047oo000IOol00`00
Oomoo`0=0Il300000a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0251l0
0`000Il1W`0]0Il00`000ol3o`1=0ol4Ool00`00Oomoo`0@Ool001Uoo`0C001oogoo0001O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl01000068H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00CP?o17oo00<007ooOol0
47oo000IOol01000Oomoo`?o0P004@6O0P0000<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
0`000Il1W`0_0Il00`000ol3o`1<0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00<3o`0B0001
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O100005hD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl004d3o`Aoo`03001oogoo
011oo`006Goo00<007ooOol010?o0P004`6O1@000a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO008D7`8003D1W`030003o`?o04X3o`Aoo`03
001oogoo011oo`006Goo00<007ooOol01P?o0`0001D1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl00`0001dD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O0080000h0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il004`3o`Aoo`03001oogoo011oo`006Goo00<007ooOol02@?o0P005P6O1@00
00<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO0000000j0Il00`00
0ol3o`190ol4Ool00`00Oomoo`0@Ool001Uoo`04001oogoo000:0ol200006@5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00L0000<51lH7a@O61lD7aPO51lH7a@O
61lD7aPO0`0003h1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`00BP?o17oo00<007ooOol047oo000IOol01000Oomoo`?/0P002P?o0`007@6O
3000@06O00<000?o0ol0B0?o17oo00<007ooOol047oo000IOol01P00Oomoo`?/0n/3k08000/3o`80
001Y0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0004T3o`Aoo`03001oogoo011oo`006Goo00<0
07ooOol01@?/0P002`?o0P00I`6O00<000?o0ol0AP?o17oo00<007ooOol047oo000IOol02`00Oomo
o`?/0n/3k0?[0n`3j`?/000030?o0`0006D1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0004P3o`Aoo`03001o
ogoo011oo`006Goo00<007ooOol020?/0P003@?o0P00H`6O00<000?o0ol0A@?o17oo00<007ooOol0
47oo000IOol03P00Oomoo`000n/3k0?[0n`3j`?/0n/3k0?[000>0ol20000HP5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
00170ol4Ool00`00Oomoo`0@Ool001Uoo`05001oogoo5n0000090n`00`000ol3o`0=0ol2001P0Il0
0`000ol3o`140ol4Ool00`00Oomoo`0@Ool001Uoo`05001oogoo6n0Gh002000020?/0n/3k0?[0n`3
j`?/0n/2000?0ol20000G`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0000AP?o17oo00<007ooOol047oo000IOol01@00OomooaOP
6n000QOP00<000?/0n`01`?/0P003`?o00<0006O0Il0G06O00<000?o0ol0@`?o17oo00<007ooOol0
47oo000IOol02000Oomooa_P5n0Kh1OP6n0200002@?[0n`3j`?/0n/3k0?[0n`3j`02000>0ol20000
G@6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl000150ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00<Gh0056n0Gh1OP5n00000:0n`0
0`000ol3o`0=0ol2001K0Il00`000ol3o`120ol4Ool00`00Oomoo`0@Ool001Uoo`0F001oogoo6n0G
h1_P5n0Kh1OP6n0Gh0000n/3k0?[0n`3j`?/0n/3k0?[0n`2000?0ol20000FP6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il004@3o`Aoo`03001oogoo
011oo`006Goo00D007ooOol001_P00<Gh0056n0Gh1OP5n00000;0n`00`000ol3o`0>0ol2001G0Il0
0`000ol3o`120ol4Ool00`00Oomoo`0@Ool001Uoo`0=001oogooIn0001_P5n0Kh1OP6n0Gh1_P5n00
0P0000/3k0?[0n`3j`?/0n/3k0?[0n`3j`000143o`<0001E0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0000A0?o17oo00<007ooOol047oo000IOol01@00Oomoof?P
In000P000aOP00HKh1OP5n0Gh1_P000:0n`2000B0ol2001C0Il00`000ol3o`110ol4Ool00`00Oomo
o`0@Ool001Uoo`0@001oogooIn1Sh6OPHn0001OP6n0Gh1_P5n0Kh1OP6n0200002P?[0n`3j`?/0n/3
k0?[0n`3j`?/0P004P?o0P000581O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl004<3o`Aoo`03001oogoo011oo`006Goo00T007ooOomSh6OPHn1Wh6?P00000aOP00LKh1OP5n0G
h1_P5n00000;0n`2000B0ol3001>0Il00`000ol3o`110ol4Ool00`00Oomoo`0@Ool001Uoo`0Q001o
ogooIn1Sh6OPHn1Wh6?P000Gh1_P5n0Kh1OP6n0Gh1_P5n0000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k00001@3o`@0001;0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0004<3o`Aoo`03001oogoo011o
o`006Goo00/007ooOomSh6OPHn1Wh6?PIn1Sh00000<Gh0066n0Gh1OP5n0Kh1OP0P002`?/00<000?o
0ol05@?o0P00B06O00<000?o0ol0@@?o17oo00<007ooOol047oo000IOol08P00Oomoo`00Hn1Wh6?P
In1Sh6OPHn0001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0P005`?o
0P0004P1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00120ol4Ool00`00Oomoo`0@Ool001Uoo`0=001oogoo
OT0006?PIn1Sh6OPHn1Wh6?P00000aOP00DKh1OP5n0Gh1_P008Gh0030003k0?/00X3k0030003o`?o
01H3o`8004D1W`030003o`?o0403o`Aoo`03001oogoo011oo`006Goo02H007ooOomnH7i0001Sh6OP
Hn1Wh6?PIn1Sh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`00
6@?o0P0004@1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00@P?o17oo00<007ooOol047oo000IOol00`00Oomoo`03OT00
2@00Hn1Wh6?PIn1Sh6OPHn0000035n001A_P5n0Gh1OP6n000QOP00<000?/0n`02P?/0P006@?o0P00
@@6O00<000?o0ol0@0?o17oo00<007ooOol047oo00040005Ool20007Ool30004Ool00`00Oomoo`02
OT002WiPOT0006?PIn1Sh6OPHn1Wh6?P0P0000TKh1OP6n0Gh1_P5n0Kh1OP6n000P0000`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`2000I0ol30000?P5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00130ol4Ool00`00Oomoo`0@Ool000Aoo`03001o
ogoo009oo`8000Qoo`03001oogoo00=oo`03001oogoo00En@00:001Sh6OPHn1Wh6?PIn1Sh6OP0002
5n001A_P5n0Gh1OP6n000aOP00<000?/0n`02`?/0P006P?o0`00>P6O00<000?o0ol0@@?o17oo00<0
07ooOol047oo0004Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool01000OomoogiP0gi001InH7i0001S
h6OPHn1Wh6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh080000>0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`001`3o`@0000f0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`00A0?o17oo00<007ooOol047oo0004Ool00`00Oomoo`08Ool60004Ool200000gooOT1n@005
OT002P00Hn1Wh6?PIn1Sh6OPHn1Wh0000QOP00DKh1OP5n0Gh1_P00<Gh0036n0000?/00`3k08001h3
o`<00381W`030003o`?o0483o`=oo`80019oo`0017oo00<007ooOol02Goo00@007ooOol000Eoo`03
001oogoo009n@00ZOV1n@7i0OT1nH7i0001Sh6OPHn1Wh6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0P007`?o100002h1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl004D3o`Aoo`03001oogoo011oo`0017oo00<007ooOol02Goo00@007oo
Ool000Eoo`03001oogoo008000Mn@00:001Sh6OPHn1Wh6?PIn1Sh6OP00025n001A_P5n0Gh1OP6n00
0aOP00<Kh0000n`03P?/00<000?o0ol080?o0`00:P6O00<000?o0ol0@`?o17oo00<007ooOol047oo
0004Ool00`00Oomoo`0:Ool00`00Ool00005Ool00`00Oomoo`02O0000`00OT1nH003OT00:7iPOT00
06?PIn1Sh6OPHn1Wh6?PIn0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k00090?o0`0002L1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0000AP?o17oo00<007ooOol047oo
0004000>Ool20005Ool00`00Oomoo`02O0000`00OT1n@005OT002`00In1Sh6OPHn1Wh6?PIn1Sh6OP
00000QOP00DKh1OP5n0Gh1_P00<Gh0036n0000?/00h3k0030003o`?o02@3o`<00241W`8004L3o`Ao
o`03001oogoo011oo`006Goo00<007ooOol00g`000@007i0OT1nH0=n@00WOV0006OPHn1Wh6?PIn1S
h6OPHn1Wh0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/008002L3o`@0000K0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O008004T3o`Aoo`03001oogoo011oo`006Goo00<007ooOol00g`000<007i0OT001Wi0
00/006OPHn1Wh6?PIn1Sh6OPHn1Wh000008Gh0056n0Gh1OP5n0Kh0035n000a_P0003k00?0n`2000Y
0ol5000B0Il4001;0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Al0005001n@7i0OT1nH003
OT00:GiP001Wh6?PIn1Sh6OPHn1Wh6?PIn0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P00;0?o4P00C`?o17oo00<007ooOol047oo000IOol0
0`00Oomoo`04O0000`00OT1n@006OT002`00Hn1Wh6?PIn1Sh6OPHn1Wh6?P00000aOP00DKh1OP5n0G
h1_P00<Gh0036n0000?/0143k0030003o`?o08X3o`Aoo`03001oogoo011oo`006Goo00<007ooOol0
1G`000<007iPOT000Wi002inH7i0OT1n@000Hn1Wh6?PIn1Sh6OPHn1Wh6?P000Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`008`3o`Aoo`03001o
ogoo011oo`006Goo00<007ooOol01G`000<007i0OT001gi000/006?PIn1Sh6OPHn1Wh6?PIn1Sh000
00<Gh0056n0Gh1OP5n0Kh0035n000a_P0003k00@0n`2002:0ol4Ool00`00Oomoo`0@Ool001Uoo`03
001oogoo00Il0003001n@7iP00=n@00_OV1n@7i0001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0005n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/00029
0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Il0003001n@7i000Mn@00<001Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh0000aOP00DKh1OP5n0Gh1_P00<Gh0036n0000?/0143k08008L3o`Aoo`03001oogoo
011oo`006Goo00<007ooOol01g`000@007i0OT1nH0=n@00`OV1n@000Hn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k000QP?o17oo00<007ooOol047oo000IOol00`00Oomoo`07O0000`00OT1n@007OT00
3@00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00000<Gh0056n0Gh1OP5n0Kh0035n000a_P0003k00B0n`0
0`000ol3o`230ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Ql0005001n@7i0OT1nH003OT00
;giP001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P00P`?o17oo00<007ooOol047oo000I
Ool00`00Oomoo`08O0000`00OT1n@007OT003P00In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0006n035n00
1A_P5n0Gh1OP6n000aOP00<Kh0000n`04`?/00<000?o0ol0P0?o17oo00<007ooOol047oo000IOol0
0`00Oomoo`08O0000`00OT1nH003OT00=7iPOT1n@7i0OV0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00
01_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0P00P0?o17oo00<007ooOol047oo000IOol00`00Oomoo`08O0000`00OT1n@008OT00
3`00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0005n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh0000n`0
50?/00<000?o0ol0O@?o17oo00<007ooOol047oo000IOol00`00Oomoo`08O0001@00OT1n@7i0OV00
0gi003InH7i0OT1n@000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh0000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/001n0ol4Ool0
0`00Oomoo`0@Ool001Uoo`03001oogoo00Ul0003001n@7i000Qn@00@001Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn0001OP6n035n001A_P5n0Gh1OP6n000aOP00<Kh0000n`050?/00<000?o0ol0N`?o17oo
00<007ooOol047oo000IOol00`00Oomoo`09O0000`00OV1n@002OT001GiPOT1n@7i0OV000Wi00380
06OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0P00N`?o17oo00<007ooOol047oo
000IOol00`00Oomoo`09O0000`00OT1n@009OT003P00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP0002
5n001A_P5n0Gh1OP6n000aOP00HKh1OP5n0Gh1_P000F0n`00`000ol3o`1h0ol4Ool00`00Oomoo`0@
Ool001Uoo`03001oogoo00Ul0004001n@7i0OV03OT00>WiPOT1n@7i0OV0006OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0P00N0?o17oo00<007ooOol047oo000IOol00`00
Oomoo`09O0000`00OT1n@009OT003`00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0000035n001A_P
5n0Gh1OP6n000aOP00HKh1OP5n0Gh1_P000G0n`00`000ol3o`1e0ol4Ool00`00Oomoo`0@Ool001Uo
o`03001oogoo00Ul0003001nH7i0009n@005OV1n@7i0OT1nH003OT00>000Hn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/001f0ol4Ool00`00Oomoo`0@Ool001Uoo`03
001oogoo00Ql0003001n@7i000]n@00@001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0006n035n00
1A_P5n0Gh1OP6n000aOP00HKh1OP5n0Gh1_P000G0n`2001d0ol4Ool00`00Oomoo`0@Ool001Uoo`03
001oogoo00Ql0005001n@7i0OT1nH003OT00@GiPOT1n@7i0OV1n@000Hn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0000L`?o17oo00<007ooOol047oo000I
Ool00`00Oomoo`08O0000`00OT1n@00<OT004@00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0001OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0066n0Gh1OP5n0Kh00060?/00<000?o0ol0L0?o17oo00<007oo
Ool047oo000IOol00`00Oomoo`08O0000`00OT1nH003OT001GiPOT1n@7i0OV000gi003enH000In1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h0000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0001a0ol4
Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Ml0003001n@7i000en@00@001Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OP00025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0030003k0?/
01L3k0030003o`?o06h3o`Aoo`03001oogoo011oo`006Goo00<007ooOol01g`000<007iPOT000Wi0
00EnH7i0OT1n@7iP00=n@011OV1n@7i0001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0001_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0001_0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo
00Il0003001n@7i000in@00A001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0000035n001A_P
5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P008Gh0030003k0?/01P3k08006d3o`Aoo`03001oogoo011o
o`006Goo00<007ooOol01G`000<007iPOT000Wi000EnH7i0OT1n@7iP00=n@016OV1n@7i0OT1nH000
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh0000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/001/0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00=l0080019n@00C001Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0006n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0025n000`000n`3k00I0n`00`000ol3o`1Y0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo009l
0003001n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000Wi004<006OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h0000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0
001Z0ol4Ool00`00Oomoo`0@Ool000@000Eoo`8000Ioo`<000Eoo`03001oogoo008001En@00E001S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P000Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1a_P5n0Gh1OP6n0Gh00001`3k0030003o`?o06L3o`Aoo`03001oogoo011oo`0017oo00<007ooOol0
0Woo0P001Goo00D007ooOomoo`0000Aoo`03001oogoo009n@005OV1n@7i0OT1nH003OT001GiPOT1n
@7i0OV000gi004YnH7i0OT1n@000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP000K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP0003j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k000J0?o17oo00<007ooOol047oo0004
Ool00`00Oomoo`09Ool01@00Oomoogoo000017oo00<007ooOol05Wi001@006OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
0a_P0003k00L0n`2001V0ol4Ool00`00Oomoo`0@Ool000Aoo`03001oogoo00Uoo`05001oogooOol0
0004Ool200000gooOV1n@002OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@01;OV0006OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`0006D3o`=oo`80019oo`0017oo00<007ooOol02Goo10001Goo
00<007ooOol05Gi001L006?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0001_P
00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<000?/0n`07@?/00<000?o0ol0HP?o
17oo00<007ooOol047oo0004Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`02OT001GiP
OT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@01?OV1n@000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?P000Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0000H`?o17oo00<007ooOol047oo0004Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00
Oomoo`0BOT0200005f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP0000
0QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n0011_P5n0Gh00080?/00<000?o0ol0H0?o
17oo00<007ooOol047oo0004000>Ool30004Ool01000OomoogiP0gi000EnH7i0OT1n@7iP00=n@004
OV1n@7i0OT020000DFOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0001Q0ol4
Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00en@0<0000LHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0006n035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh0046n0Gh1OP000P0n`00`000ol3o`1N0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo
009n@005OV1n@7i0OT1nH002OT040000F6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`00G`?o17oo00<007ooOol047oo000IOol00`00Oomoo`0900008FOP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn0000035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0076n0Gh1OP5n0Kh1OP00008@?/
00<000?o0ol0G0?o17oo00<007ooOol047oo000IOol0JP00OomoofOPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`00G@?o17oo00<007ooOol047oo000IOol0;`00Oomoof?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn00
01OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001Q_P5n0Gh1OP6n000283k003
0003o`?o05X3o`Aoo`03001oogoo011oo`006Goo06`007ooOomWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh000
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[001K0ol4Ool00`00Oomoo`0@Ool001Uoo`0]001oogooHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00
01_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0030003
k0?/0243k0030003o`?o05P3o`Aoo`03001oogoo011oo`006Goo06h007ooOomWh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`00F@?o17oo00<007ooOol047oo000IOol0:`00Oomoof?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn0001_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P
00<Gh0036n0Gh00002D3k08005L3o`Aoo`03001oogoo011oo`006Goo00<007ooOol01000021Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
0P0004PKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/001F0ol4Ool00`00Oomoo`0@Ool001Uoo`05001oogoo
5n0Kh0025n0500007FOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn0001OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n00
0aOP00HKh1OP5n0Gh1_P000W0n`00`000ol3o`1C0ol4Ool00`00Oomoo`0@Ool001Uoo`0<001oogoo
6n0Gh1_P5n0Kh1OP6n0Gh1_P100001=Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h0030000C1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`00E@?o17oo00<007ooOol047oo000I
Ool00`00Oomoo`035n001A_P5n0Gh1OP6n000aOP00<Kh1OP00004P000aOP00DKh1OP5n0Gh1_P00<G
h0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0046n0Gh1OP000X
0n`00`000ol3o`1B0ol4Ool00`00Oomoo`0@Ool001Uoo`1d001oogoo6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/005<3o`Aoo`03001oogoo011oo`006Goo00D007ooOolG
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00<Kh0000n`0:@?/00<000?o0ol0D0?o17oo00<007ooOol047oo000IOol0
0`00Oomoo`020000L1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k000DP?o
17oo00<007ooOol047oo000IOol00`00Oomoo`020n`200035n001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P008Gh0030003k0?/02T3k003
0003o`?o04l3o`Aoo`03001oogoo011oo`006Goo00L007ooOol3k0?[0n`3j`020000KQ_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/001@0ol4Ool00`00Oomoo`0@Ool001Uoo`03001o
ogoo00H3k0<000056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n001Q_P5n0Gh1OP6n0002d3k0030003o`?o04d3o`Aoo`03001oogoo011oo`006Goo00`007ooOol3
k0?[0n`3j`?/0n/3k0?[0n`40000JAOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh0000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0001>0ol4Ool0
0`00Oomoo`0@Ool001Uoo`03001oogoo00d3k0<000<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0036n0Gh0000303k0030003o`?o04/3o`Aoo`03001oogoo011oo`006Goo01<007oo
Ool000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`020000IA_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0000C@?o17oo00<007ooOol047oo000IOol01000Oomoo`?o0P003`?/0P0000<Gh1_P5n000QOP00DK
h1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<G
h0056n0Gh1OP5n0Kh0035n0011_P5n0Gh000<P?/00<000?o0ol0BP?o17oo00<007ooOol047oo000I
Ool00`00Oomoo`030ol200003`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`030000HQOP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[001;0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00D3o`800103k0@000056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000QOP00<000?/0n`0=0?/00<000?o0ol0B0?o17oo00<007ooOol047oo000IOol0
0`00Oomoo`070ol050000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`40000FaOP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k000
04X3o`Aoo`03001oogoo011oo`006Goo00<007ooOol020?o0`0050?/1`000aOP00DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n001Q_P5n0Gh1OP6n0Gh08003T3k0030003o`?o04L3o`Aoo`03001o
ogoo011oo`006Goo00@007ooOol000X3o`80000I0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/01`0000hGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P100003d3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0
00180ol4Ool00`00Oomoo`0@Ool001Uoo`04001oogoo0Il2000:0ol2000N0n`>00100n`00`000ol3
o`160ol4Ool00`00Oomoo`0@Ool001Uoo`07001oogoo0Il1O`6O00002`?o0P0006`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00170ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00@1
W`030003o`?o00X3o`8006X3k0030003o`?o04@3o`Aoo`03001oogoo011oo`0010001Goo0P001Goo
10001Goo00P007ooOol1W`5o0Il1O`6O0P0030?o0P0006X3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/004D3o`Aoo`03001oogoo011oo`0017oo00<007ooOol00Woo0P0017oo00<007ooOol00Woo
00<007ooOol00Woo00<007ooOol01`6O00<000?o0ol02`?o00<000?/0n`0IP?/00<000?o0ol0@`?o
17oo00<007ooOol047oo0004Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`02Ool02`00
Oomoo`000Gl1W`5o0Il1O`6O0Gl00P0030?o0`0006L3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00014
0ol4Ool00`00Oomoo`0@Ool000Aoo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo009oo`80
0004OolD7`0000070Il2000=0ol2001U0n`00`000ol3o`110ol3Ool2000BOol000Aoo`03001oogoo
00Uoo`@000Eoo`0?001oogoo61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o008000d3o`80001T0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[00130ol4Ool00`00Oomoo`0@Ool000Aoo`03001oogoo00Qoo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00<D7`0361l0006O00P1W`030003o`?o00`3o`800683k0030003
o`?o0403o`Aoo`03001oogoo011oo`0017oo00<007ooOol027oo00<007ooOol00Woo00<007ooOol0
0Woo00P007ooOolH7a@O61lD7aPO0P0000P1O`6O0Gl1W`5o0Il1O`6O0P003P?o0P000643j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`000120ol4Ool00`00Oomoo`0@Ool000@000aoo`@000Eoo`05001oogoo51lH7`0351l00aPO
51l000090Il2000>0ol3001N0n`00`000ol3o`0o0ol4Ool00`00Oomoo`0@Ool001Uoo`0;001oogoo
61lD7aPO51lH7a@O61lD7`0200002@6O0Gl1W`5o0Il1O`6O0Gl1W`02000?0ol20000G@?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/00011
0ol4Ool00`00Oomoo`0@Ool001Uoo`04001oogoo000251l01APO51lD7a@O61l00Q@O00<0006O0Il0
206O00<000?o0ol03P?o0P00FP?/00<000?o0ol0?`?o17oo00<007ooOol047oo000IOol06@00Oomo
of@O000H7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o00800103o`<0001I0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000100ol4
Ool00`00Oomoo`0@Ool001Uoo`06001oogooH1mT7`000Q@O00DH7a@O51lD7aPO008D7`030001W`6O
00T1W`800143o`8005H3k0030003o`?o03h3o`Aoo`03001oogoo011oo`006Goo00H007ooOomT7f0O
I1l200005A@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`02000A0ol20000
E@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000403o`Aoo`03
001oogoo011oo`006Goo00/007ooOomP7f@OH1mT7f0O000D7aPO00<D7`0461lD7a@O000=0Il00`00
0ol3o`0@0ol3001A0n`00`000ol3o`0n0ol4Ool00`00Oomoo`0@Ool001Uoo`0B001oogooI1mP7f@O
H1mT7f0O000D7aPO51lH7a@O61lD7aPO0P0000d1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000D0ol2
0000D@?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0000o0ol4Ool00`00Oomo
o`0@Ool001Uoo`0:001oogooH1mT7f0OI1mP7f@OH1l200001APO51lD7a@O61l00a@O00<0006O0Il0
2P6O00<000?o0ol04`?o0P00CP?/00<000?o0ol0?@?o17oo00<007ooOol047oo000IOol08`00Oomo
o`00H1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O00005P?o0P0004d3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`0003l3o`Aoo`03001o
ogoo011oo`006Goo00l007ooOoml4P00H1mT7f0OI1mP7f@OH1mT7`0061l00a@O00@H7a@O51lD7`80
00/1W`8001H3o`8004X3k0030003o`?o03d3o`Aoo`03001oogoo011oo`006Goo00<007ooOol00W`B
0240060OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7`000Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o00005`?o0P0004T3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0000o0ol4Ool00`00Oomoo`0@
Ool001Uoo`03001oogoo00=l4P0;001P7f@OH1mT7f0OI1mP7f@O000H7`0351l01QPO51lD7a@O61l0
00`1W`8001L3o`<004D3k0030003o`?o03d3o`Aoo`03001oogoo011oo`006Goo00@007ooOoml4`=l
4P0R001P7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O000I0ol40000@P?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/003l3o`Aoo`03001oogoo011oo`006Goo00<007oo
Ool01G`B00/0060OI1mP7f@OH1mT7f0OI1l001PO00<D7`0661lD7a@O51lH7`003@6O0P006`?o0P00
?`?/00<000?o0ol0?@?o17oo00<007ooOol047oo000IOol00`00Oomoo`02O1809g`CO19l4W`B001P
7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl0000L0ol20000?P?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[000o0ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Ml4P0;001P
7f@OH1mT7f0OI1mP7f@O000H7`0351l01APO51lD7a@O61l00P003@6O00<000?o0ol06`?o0`00>@?/
00<000?o0ol0?P?o17oo00<007ooOol047oo000IOol01000Oomoog`C0g`B02Il4g`BO18006@OH1mT
7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0P007P?o0`0003L3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`000100ol4Ool00`00Oomoo`0@Ool001Uoo`04001oogoo0007O1803000I1mP7f@OH1mT7f0OI1mP
7f@O000H7`<D7`0761lD7a@O51lH7a@O00003P6O0P007`?o1000<@?/00<000?o0ol0?`?o17oo00<0
07ooOol047oo000IOol01P00Oomoog`0001l4`=l4P0XO1=l4W`B001T7f0OI1mP7f@OH1mT7f0OI1l0
01PO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl2000Q0ol3
0000;`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0000@@?o17oo00<007ooOol047oo000I
Ool00`00Oomoo`02O0000`00O19l4P04O1803@00H1mT7f0OI1mP7f@OH1mT7f0OI1l001PO00<D7`07
61lD7a@O51lH7a@O0000406O00<000?o0ol08@?o0`00:P?/00<000?o0ol0@0?o17oo00<007ooOol0
47oo000IOol00`00Oomoo`02O0000`00O19l4`03O180:W`CO180060OI1mP7f@OH1mT7f0OI1mP7f@O
000H7a@O61lD7aPO51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il002D3
o`80000X0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00130ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00=l
0003001l4W`B00El4P0=001P7f@OH1mT7f0OI1mP7f@OH1l001@O61l00a@O00LH7a@O51lD7aPO51l0
000@0Il00`000ol3o`0T0ol4000Q0n`200140ol4Ool00`00Oomoo`0@Ool001Uoo`03001oogoo00Al
0003001l4W`C00=l4P0YO1=l4P00H1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH
7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`02000X0ol600006@?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[008004H3o`Aoo`03001oogoo011o
o`006Goo00<007ooOol017`000<007`BO1801W`B00d0060OI1mP7f@OH1mT7f0OI1mP7`0051lH7`03
51l01aPO51lD7a@O61lD7`000141W`8002`3o`L000d3k0D004P3o`Aoo`03001oogoo011oo`006Goo
00<007ooOol01G`000@007`BO19l4`=l4P0/O1<006@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH
7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00383o`d0
04d3o`Aoo`03001oogoo011oo`006Goo00<007ooOol01G`000<007`BO1801W`B00h006@OH1mT7f0O
I1mP7f@OH1mT7f0O000D7aPO0a@O00HH7a@O51lD7aPO51l2000A0Il00`000ol3o`290ol4Ool00`00
Oomoo`0@Ool001Uoo`03001oogoo00Il0005001l4W`BO19l4`03O180:g`C001T7f0OI1mP7f@OH1mT
7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O008008T3o`Aoo`03001oogoo011oo`006Goo00<007ooOol01W`000<007`BO1801g`B
00h006@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO0a@O00DH7a@O51lD7aPO008D7`030001W`6O0101
W`030003o`?o08H3o`Aoo`03001oogoo011oo`006Goo00<007ooOol01W`000<007`BO1<00g`B035l
4g`BO19l4P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO0001
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000270ol4Ool00`00Oomoo`0@Ool001Uo
o`03001oogoo00Ml0003001l4W`B00Ml4P0?001P7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO00<D
7`0561lD7a@O51lH7`0251l00`000Il1W`0@0Il00`000ol3o`240ol4Ool00`00Oomoo`0@Ool001Uo
o`03001oogoo00Ml0004001l4W`BO1<3O180<7`CO19l4P00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7`00
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`8008@3o`Aoo`03001oogoo011oo`0047oo1@0017oo00<007ooOol01g`000<007`BO18027`B
00d006@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0000251l01APO51lD7a@O61l00a@O00@H7a@O51l001<1
W`030003o`?o0843o`Aoo`03001oogoo011oo`004Woo00<007ooOol017oo00<007ooOol01g`000<0
07`CO1800W`B03Il4g`BO19l4W`CO180060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH
7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0022
0ol4Ool00`00Oomoo`0@Ool0019oo`03001oogoo00Aoo`03001oogoo00Ql0003001l4W`B00Ql4P0=
001P7f@OH1mT7f0OI1mP7f@OH1mT7f0O00000a@O00DH7a@O51lD7aPO00<D7`0461lD7a@O000C0Il2
00200ol4Ool00`00Oomoo`0@Ool0019oo`03001oogoo00Aoo`800003Ooml07`000Il0003001l4W`C
00=l4P0gO1=l4W`BO19l4`00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000O`?o
0goo0P004Woo000BOol00`00Oomoo`04Ool00`00Oomoo`38Ool00`00Oomoo`0@Ool0019oo`03001o
ogoo00Aoo`03001oogoo0<Qoo`03001oogoo011oo`0047oo0`001Woo00@007ooOol000Uoo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`05001oogooOol0000BOol0
019oo`03001oogoo00Aool`0019oo`00mgoo003gOol00?Moo`00mgoo003gOol00?Moo`00mgoo003g
Ool00?Moo`00mgoo003gOol001Qoo`<00=aoo`005goo00D007ooOomoo`000=]oo`005goo00<007oo
Ool0gGoo000GOol00`00Oomoo`3MOol001Moo`03001oogoo0=eoo`005Woo1@00g7oo000GOol00`00
Oomoo`3MOol00?Moo`00mgoo003gOol00?Moo`00mgoo003gOol00?Moo`00mgoo0000\
\>"],
  ImageRangeCache->{{{0, 246.5}, {246.5, 0}} -> {-0.295588, -0.103154, \
0.0127543, 0.00637714}}]
}, Open  ]],

Cell[TextData[{
  "This example demonstrates that the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is not only helpful in finding the symmetries of a PDE but also can \
facilitate the solution of boundary value problems."
}], "Text",
  Evaluatable->False,
  CellTags->"symmetries of PDEs"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.6.3 Single Flux Line in Superconductors", "Subsection",
  CellTags->"Single Flux Line in Superconductors"],

Cell[TextData[{
  "In another example, let us examine an equation published by ",
  ButtonBox["Tang et al. [1994]",
    ButtonData:>{"Literat.nb", "Tang-94"},
    ButtonStyle->"Hyperlink"],
  ". These authors discuss the dynamics and noise spectra of a driven single \
flux line in superconductors. The authors examine the low-temperature \
dynamics of a single flux line in a bulk type-II superconductor, driven by \
the Lorentz force acting near the sample surface, both near and above the \
depinning threshold. The equation of motion they derive without considering \
the random fluctuations is given by"
}], "Text",
  CellTags->{
  "single flux line in superconductors", "low temperature dynamics", 
    "type-II superconductor", "Lorentz force", "depinning threshold"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(tang = {
        \[PartialD]\_t u[x, t] - 
          \(k\ \[PartialD]\_{x, 2}u[x, t]\)\/\(1 + 
              \((\[PartialD]\_x u[x, t])\)\^2\)}; tang // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(u\_t\), "-", 
                StyleBox[\(\(k\ u\_\(x, x\)\)\/\(1 + u\_x\%2\)\),
                  ScriptLevel->0]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is the shape function of the flux line and ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " is a constant. As Tang et al. note the equation of motion in its \
two-dimensional representation is a valid approximation when the driving \
force is very large ",
  Cell[BoxData[
      \(TraditionalForm\`\((j \[GreaterGreater] j\_c)\)\)]],
  " and the string moves with a high velocity. The authors discuss only the \
steady-state solution of the non-linear problem. We will demonstrate that the \
symmetries of the equation are the cornerstone for the solution of the \
non-steady equation. We will add this example to our database of equations. \
The input parameters needed to create the data file containing the \
information for ",
  StyleBox["Lie[]", "MmaText"],
  " is given by the independent variables"
}], "Text",
  CellTags->{"flux line", "Lie[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(independentVariables = {x, t}\)], "Input"],

Cell[BoxData[
    \({x, t}\)], "Output"]
}, Open  ]],

Cell["and the dependent variables", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dependentVariables = {u}\)], "Input"],

Cell[BoxData[
    \({u}\)], "Output"]
}, Open  ]],

Cell["The parameters of the equations are collected in the list", "Text",
  CellTags->"parameters of the equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(parameters = {k}\)], "Input"],

Cell[BoxData[
    \({k}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The parameter ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " combines the critical field ",
  Cell[BoxData[
      \(TraditionalForm\`H\_c\)]],
  ", the Ginzburg-Landau parameter and the damping coefficient of the \
Bardeen-Stephen model. The physical interpretation of these parameters is \
discussed, for example, in the book by ",
  ButtonBox["Tinkham [1975]",
    ButtonData:>{"Literat.nb", "Tink-75"},
    ButtonStyle->"Hyperlink"],
  ". We choose the title of the equation to be"
}], "Text",
  CellTags->{
  "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(title = {"\<Single Flux Line in Superconductors\>"}\)], "Input"],

Cell[BoxData[
    \({"Single Flux Line in Superconductors"}\)], "Output"]
}, Open  ]],

Cell["\<\
The source of the equation, contained in a nested list, is given by\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(source = {{"\<C. Tang, S. Feng and L. Golubovic\>"}, \n
        \t\t{"\<Dynamics and Noise Spectra of a Driven SingleFlux  Line in  \
Superconductors\>"}, \n\t\t{"\<Phys. Rev. Lett. 72, 1264-1267, (1994)\>"}, \n
        \t\t{"\<equation 7\>"}}\)], "Input"],

Cell[BoxData[
    \({{"C. Tang, S. Feng and L. Golubovic"}, {
        "Dynamics and Noise Spectra of a Driven SingleFlux  Line in  \
Superconductors"}, {"Phys. Rev. Lett. 72, 1264-1267, (1994)"}, {"equation 7"}}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "All the information available on the equation is now stored in the file ",
  StyleBox["ctang.dgl", "MmaText",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "The function ",
  StyleBox["LieEquation[]", "MmaText"],
  " is designed to do it for us. Be sure that you do not use",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox[".deq", "MmaText",
    FontSlant->"Italic"],
  " as an extension of your file names. The extension ",
  StyleBox[".deq", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "is reserved for a file containing the information on the determining \
equation for the infinitesimals. This file is automatically created by the \
functions ",
  StyleBox["Lie[]", "MmaText"],
  ", ",
  StyleBox["LieSolve[]", "MmaText"],
  ", and ",
  StyleBox["LieStructureForm[]", "MmaText"],
  "."
}], "Text",
  CellTags->{
  "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
    "LieSolve[]", "LieStructureForm[]"}],

Cell[BoxData[
    \(LieEquations["\<ctang.dgl\>", tang, \n\tdependentVariables, 
      independentVariables, \n\tparameters, title, source]\)], "Input"],

Cell["\<\
After the completion of this line, we added another example to our \
database of differential equations. The next step is the determination of the \
symmetries.\
\>", "Text",
  CellTags->{"data basis", "determination of the symmetries"}],

Cell[CellGroupData[{

Cell["5.6.3.1 Symmetries", "Subsubsection"],

Cell[TextData[{
  "Using the information collected in the file ",
  StyleBox["ctang.dgl", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ", "MmaText"],
  "in the calculation for the infinitesimals, we start the symmetry analysis \
with"
}], "Text",
  CellTags->"symmetry analysis"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieSolve["\<ctang.dgl\>"] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Xi]\_2 == k1 + 2\ k5\ t\)},
          {\(\[Phi]\_1 == k2 + k5\ u + k3\ x\)},
          {\(\[Xi]\_1 == k4 - k3\ u + k5\ x\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 2, k5, t]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k2, 
            Times[ k5, u], 
            Times[ k3, x]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k4, 
            Times[ -1, k3, u], 
            Times[ k5, x]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The application of ",
  StyleBox["LieSolve[]", "MmaText"],
  " results in a list of infinitesimals representing a finite \
five-dimensional point group. Curiously, the result is that the infinitesimal \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  " depends on the variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Such a dependence is quite unusual, although it is possible. All the \
examples discussed so far do not show this kind of symmetry (cf. the ",
  ButtonBox["Burgers",
    ButtonData:>{"symmet5.nb", "Burgers equation"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["heat equation",
    ButtonData:>{"symmet5.nb", "heat equation"},
    ButtonStyle->"Hyperlink"],
  "). The symmetry of the subgroup related to this special kind of \
transformation allows a rotation in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane. This rotation keeps the equation unchanged."
}], "Text",
  CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}],

Cell[TextData[{
  "The function ",
  StyleBox["LieSolve[]", "MmaText"],
  " produces, in addition to the infinitesimals, additional information not \
displayed on the screen. These results, like the determining equations of the \
equation, the original equations themselves, the substitutions, etc. are \
collected during the calculation in a separate global variable called ",
  StyleBox["FinalResult", "MmaText",
    FontSlant->"Italic"],
  ". The reason why we introduced a global variable ",
  StyleBox["FinalResult", "MmaText",
    FontSlant->"Italic"],
  " is the necessity of having all information on the calculation available. \
A printout of the information contained in",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["FinalResult", "MmaText",
    FontSlant->"Italic"],
  " for our calculation of Tang\[CloseCurlyQuote]s problem can be obtained by \
calling"
}], "Text",
  CellTags->{"LieSolve[]", "FinalResult"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(FinalResult // \ Flatten\) // LieTraditionalForm\) // TableForm\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(u\_t\), "-", 
              StyleBox[\(\(k\ u\_\(x, x\)\)\/\(1 + u\_x\%2\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(u\_t\), "\[Rule]", 
              StyleBox[\(\(k\ u\_\(x, x\)\)\/\(1 + u\_x\%2\)\),
                ScriptLevel->0]}]},
          {\(\((\[Xi]\_2)\)\_u\)},
          {\(\((\[Xi]\_2)\)\_x\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_t + k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              2\ k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              4\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-2\)\ \((\[Xi]\_1)\)\_t + k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              2\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-6\)\ \((\[Xi]\_1)\)\_t + k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              5\ k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              10\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_t + 2\ k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              2\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              2\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-6\)\ \((\[Xi]\_1)\)\_t + 5\ k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              2\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(6\ \((\[Phi]\_1)\)\_t + 10\ k\ \((\[Xi]\_1)\)\_\(x, u\) - 
              5\ k\ \((\[Phi]\_1)\)\_\(u, u\) - 
              k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {\(\((\[Phi]\_1)\)\_t - k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(\(-3\)\ \((\[Phi]\_1)\)\_t - 4\ k\ \((\[Xi]\_1)\)\_\(x, u\) + 
              2\ k\ \((\[Phi]\_1)\)\_\(u, u\) + 
              k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(6\ \((\[Phi]\_1)\)\_t + 2\ k\ \((\[Xi]\_1)\)\_\(x, u\) - 
              k\ \((\[Phi]\_1)\)\_\(u, u\) - 
              5\ k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(\(-2\)\ \((\[Phi]\_1)\)\_t - 2\ k\ \((\[Xi]\_1)\)\_\(x, u\) + 
              k\ \((\[Phi]\_1)\)\_\(u, u\) + k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(\(-3\)\ \((\[Phi]\_1)\)\_t - 2\ k\ \((\[Xi]\_1)\)\_\(x, u\) + 
              k\ \((\[Phi]\_1)\)\_\(u, u\) + 
              2\ k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(\((\[Phi]\_1)\)\_t + 2\ k\ \((\[Xi]\_1)\)\_\(x, u\) - 
              k\ \((\[Phi]\_1)\)\_\(u, u\)\)},
          {
            \(6\ \((\[Xi]\_1)\)\_x - 5\ \((\[Xi]\_2)\)\_t + 
              4\ \((\[Phi]\_1)\)\_u\)},
          {
            \(8\ \((\[Xi]\_1)\)\_x - 5\ \((\[Xi]\_2)\)\_t + 
              2\ \((\[Phi]\_1)\)\_u\)},
          {
            \(4\ \((\[Xi]\_1)\)\_x - 5\ \((\[Xi]\_2)\)\_t + 
              6\ \((\[Phi]\_1)\)\_u\)},
          {\(\(-2\)\ \((\[Xi]\_1)\)\_x + \((\[Xi]\_2)\)\_t\)},
          {
            \(2\ \((\[Xi]\_1)\)\_x - 5\ \((\[Xi]\_2)\)\_t + 
              8\ \((\[Phi]\_1)\)\_u\)},
          {\(\((\[Xi]\_1)\)\_u + \((\[Phi]\_1)\)\_x\)},
          {\(\((\[Xi]\_1)\)\_u + \((\[Phi]\_1)\)\_x\)},
          {\(\((\[Xi]\_1)\)\_u + \((\[Phi]\_1)\)\_x\)},
          {\(\(-\((\[Xi]\_2)\)\_t\) + 2\ \((\[Phi]\_1)\)\_u\)},
          {\(\(-\((\[Xi]\_1)\)\_t\) + k\ \((\[Xi]\_1)\)\_\(u, u\)\)},
          {"LieStructure"},
          {"Metric"},
          {"SymmGroup"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Plus[ 
          Subscript[ u, t], 
          Times[ -1, k, 
            Power[ 
              Plus[ 1, 
                Power[ 
                  Subscript[ u, x], 2]], -1], 
            Subscript[ u, x, x]]], Subscript[ u, t] -> Times[ k, 
          Power[ 
            Plus[ 1, 
              Power[ 
                Subscript[ u, x], 2]], -1], 
          Subscript[ u, x, x]], 
        Subscript[ 
          Subscript[ \[Xi], 2], u], 
        Subscript[ 
          Subscript[ \[Xi], 2], x], 
        Plus[ 
          Times[ -3, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -4, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -2, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -6, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ 5, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -10, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -3, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -1, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -6, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ 5, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ 6, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ 10, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ -5, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ -1, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Phi], 1], t], 
          Times[ -1, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Times[ -3, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ -4, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Times[ 6, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ -1, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ -5, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Times[ -2, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Times[ -3, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Phi], 1], t], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ -1, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]]], 
        Plus[ 
          Times[ 6, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Times[ -5, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 4, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Times[ 8, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Times[ -5, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 2, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Times[ 4, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Times[ -5, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 6, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Times[ -2, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Subscript[ 
            Subscript[ \[Xi], 2], t]], 
        Plus[ 
          Times[ 2, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Times[ -5, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 8, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Xi], 1], u], 
          Subscript[ 
            Subscript[ \[Phi], 1], x]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Xi], 1], u], 
          Subscript[ 
            Subscript[ \[Phi], 1], x]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Xi], 1], u], 
          Subscript[ 
            Subscript[ \[Phi], 1], x]], 
        Plus[ 
          Times[ -1, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 2, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Times[ -1, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]]], LieStructure, Metric, 
        SymmGroup}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The last four elements of the list ",
  StyleBox["FinalResult", "MmaText",
    FontSlant->"Italic"],
  " are empty or contain symbolic names which carry no information at this \
stage of the calculation. Another global variable of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is called ",
  StyleBox["Result2", "MmaText",
    FontSlant->"Italic"],
  StyleBox[",", "MmaText"],
  " containing the information on the infinitesimals:"
}], "Text",
  CellTags->{"symbolic names", "Result2", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Result2\)], "Input"],

Cell[BoxData[
    \({{xi[2] \[Rule] Function[{x, t, u}, k1 + 2\ k5\ t], 
        phi[1] \[Rule] Function[{x, t, u}, k2 + k5\ u + k3\ x], 
        xi[1] \[Rule] Function[{x, t, u}, k4 - k3\ u + k5\ x]}, {}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The global variable ",
  StyleBox["Result2", "MmaText",
    FontSlant->"Italic"],
  " contains the infinitesimals and the remaining equations of the \
determining equations not solved by the function ",
  StyleBox["PDESolve[]", "MmaText"],
  ". The function ",
  StyleBox["PDESolve[]", "MmaText"],
  " is the solver of the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". For the current equation, all determining equations are solved. Thus, \
the last element of ",
  StyleBox["Result2", "MmaText",
    FontSlant->"Italic"],
  " is empty. The results for the infinitesimals are given by substitution \
rules usable in other calculations. For example, an application of this kind \
of calculation is the reduction of the equation."
}], "Text",
  CellTags->{"remaining equations", "PDESolve[]"}],

Cell["\<\
We select the subgroup of interest by setting a subgroup of the \
group constants to a numeric value and others to a symbolic value. The \
infinitesimals are thus reduced  by\
\>", "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi1 = 
      \({{\(xi[1]\)[x, t, u[x, t]], \(xi[2]\)[x, t, u[x, t]]}, {
              \(phi[1]\)[x, t, u[x, t]]}} /. 
          Result2\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] v, k2 \[Rule] 1, k3 \[Rule] 0, k4 \[Rule] 1, 
          k5 \[Rule] 0, u[___] \[Rule] u}\)], "Input"],

Cell[BoxData[
    \({{1, v}, {1}}\)], "Output"]
}, Open  ]],

Cell[TextData[
"This special extraction of a subgroup is related to a moving wave solution. \
Tang\[CloseCurlyQuote]s equation is thus invariant with respect to \
translations:"], "Text",
  Evaluatable->False,
  CellTags->"moving wave solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rtang = 
      LieReduction[tang, {u}, {x, t}, 
        infi1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[rtang]] /. {zeta1 \[Rule] \[Zeta]\_1}\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(t - v\ x - \[Zeta]\_1 == 0\)},
          {\(u - x - F\_1 == 0\)},
          {
            \(2\ F1\_\(\[Zeta]\_1\) - 2\ v\ F1\_\[Zeta]\_1\%2 + 
                v\^2\ F1\_\[Zeta]\_1\%3 - 
                k\ v\^2\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The reduced equation is solved by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(mwtang = 
      DSolve[rtang\[LeftDoubleBracket]3, 1\[RightDoubleBracket] == 0, F1, 
        zeta1]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"Solve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{\(1\/\(2\ k\)\), 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(-k\), " ", \(v\^2\), " ", 
                    RowBox[{"ArcTan", "[", 
                      RowBox[{"1", "-", 
                        RowBox[{"v", " ", 
                          RowBox[{
                            SuperscriptBox["F1", "\[Prime]",
                              MultilineFunction->None], "[", "#1", "]"}]}]}], 
                      "]"}]}], "+", 
                  RowBox[{"2", " ", "k", " ", 
                    RowBox[{"Log", "[", 
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{
                            SuperscriptBox["F1", "\[Prime]",
                              MultilineFunction->None], "[", "#1", "]"}], 
                          \(v\^2\/2\)], " ", 
                        SuperscriptBox[
                          RowBox[{"(", 
                            RowBox[{"2", "-", 
                              RowBox[{"2", " ", "v", " ", 
                                RowBox[{
                                  SuperscriptBox["F1", "\[Prime]",
                                    MultilineFunction->None], "[", "#1", 
                                  "]"}]}], "+", 
                              RowBox[{\(v\^2\), " ", 
                                SuperscriptBox[
                                  RowBox[{
                                    SuperscriptBox["F1", "\[Prime]",
                                      MultilineFunction->None], "[", "#1", 
                                    "]"}], "2"]}]}], ")"}], 
                          \(-\(v\^2\/4\)\)]}], "]"}]}], "-", \(2\ #1\)}], 
                ")"}]}], "==", \(C[1]\)}], ",", 
          RowBox[{"{", 
            RowBox[{
              SuperscriptBox["F1", "\[Prime]",
                MultilineFunction->None], "[", "#1", "]"}], "}"}]}], "]"}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an implicit representation of the solution entangling the \
similarity function ",
  Cell[BoxData[
      FormBox[
        StyleBox["F1",
          FontSlant->"Italic"], TraditionalForm]]],
  " in trigonometric and logarithmic relations."
}], "Text",
  Evaluatable->False,
  CellTags->"solution of Tang's equation"],

Cell[TextData[{
  "Another reduction of the equation follows by the choice ",
  Cell[BoxData[
      \(TraditionalForm\`k3 = c\)]],
  ":"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi1 = 
      \({{\(xi[1]\)[x, t, u[x, t]], \(xi[2]\)[x, t, u[x, t]]}, {
              \(phi[1]\)[x, t, u[x, t]]}} /. \n\t\t
          Result2\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] c, k4 \[Rule] 0, 
          k5 \[Rule] 0, \n\t\t\tu[___] \[Rule] u}\)], "Input"],

Cell[BoxData[
    \({{\(-c\)\ u, 0}, {c\ x}}\)], "Output"]
}, Open  ]],

Cell["The related reduction is", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(r1tang = 
      LieReduction[tang, {u}, {x, t}, 
        infi1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[r1tang]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(t - \[Zeta]\_1 == 0\)},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(u\^2\/2\),
                    ScriptLevel->0]}], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(x\^2\/2\),
                  ScriptLevel->0], "-", \(F\_1\)}], "==", "0"}]},
          {\(\(-k\) + F1\_\(\[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
Solving the reduced equation, we get the explicit representation \
for the similarity solution by\
\>", "Text",
  Evaluatable->False,
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1tang = 
      DSolve[r1tang\[LeftDoubleBracket]3, 1\[RightDoubleBracket] == 0, F1, 
        zeta1]\)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((C[1] + k\ #1&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Inserting this solution into the similarity representation, we end up with \
an implicit representation of the solution for the field ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "similarity representation", "implicit representation of the solution"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      Flatten[r1tang\[LeftDoubleBracket]2\[RightDoubleBracket] /. s1tang]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({\(-\(u\^2\/2\)\) - x\^2\/2 == k\ t + C[1]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This result illustrates that the circles in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane are dependent on the time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". The radius of the circle depends on the actual time and on the signs of \
the constants ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1]", "MmaText"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`k\)], "MmaText"],
  ". If both constants are negative the radius of the circle increases to \
infinity if time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " increases. If ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] is negative and ",
  Cell[BoxData[
      \(TraditionalForm\`k > 0\)]],
  ", we get an upper limit for ",
  Cell[BoxData[
      \(TraditionalForm\`t = \( | C[1] | \(/ k\)\)\)]],
  " for which the radius is real. However, if we set ",
  Cell[BoxData[
      \(TraditionalForm\`C[1] > 0\)]],
  ", there exist no real radii in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane. We demonstrate this behavior for ",
  Cell[BoxData[
      \(TraditionalForm\`k = \(-3\)/2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`C[1] = 1/2\)]],
  " for which a lower limit in ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " exists. The following animation shows the increase of the radius ",
  Cell[BoxData[
      \(TraditionalForm\`\(-k\)\ t - C[1]\)]],
  " by increasing the time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " above the threshold of ",
  Cell[BoxData[
      \(TraditionalForm\`t \[GreaterEqual] 1/4\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->{"circle", "animation"}],

Cell[BoxData[
    \(<< Graphics`ImplicitPlot`\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[ImplicitPlot[
        u\^2\/2 + x\^2\/2 == \(-k\)\ t - C[1] /. {t \[Rule] ti, 
            k \[Rule] \(-1.5\), C[1] \[Rule] 1\/2}, {x, \(-2\), 2}, 
        PlotRange \[Rule] {{\(-2\), 2}, {\(-2\), 2}}, PlotPoints \[Rule] 35, 
        PlotStyle \[Rule] Hue[ti], 
        PlotLabel \[Rule] "\<             t=\>"<>ToString[ti], 
        AxesLabel \[Rule] {"\<x\>", "\<u\>"}], {ti, 1.5, 0.251, \(- .05\)}]
      \)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.5) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 1 r

.5 Mabswid

.03229 .4999 m

.03429 .45685 L

.04026 .41406 L

.05015 .37201 L

.06388 .33104 L

.08133 .29152 L

.10235 .25378 L

.12676 .21814 L

.15436 .18491 L

.18491 .15436 L

.21814 .12676 L

.25378 .10235 L

.29152 .08133 L

.33104 .06388 L

.37201 .05015 L

.41406 .04026 L

.45685 .03429 L

.5 .03229 L

.54315 .03429 L

.58594 .04026 L

.62799 .05015 L

.66896 .06388 L

.70848 .08133 L

.74622 .10235 L

.78186 .12676 L

.81509 .15436 L

.84564 .18491 L

.87324 .21814 L

.89765 .25378 L

.91867 .29152 L

.93612 .33104 L

.94985 .37201 L

.95974 .41406 L

.96571 .45685 L

.96771 .4999 L

s

.03229 .5001 m

.03429 .54315 L

.04026 .58594 L

.05015 .62799 L

.06388 .66896 L

.08133 .70848 L

.10235 .74622 L

.12676 .78186 L

.15436 .81509 L

.18491 .84564 L

.21814 .87324 L

.25378 .89765 L

.29152 .91867 L

.33104 .93612 L

.37201 .94985 L

.41406 .95974 L

.45685 .96571 L

.5 .96771 L

.54315 .96571 L

.58594 .95974 L

.62799 .94985 L

.66896 .93612 L

.70848 .91867 L

.74622 .89765 L

.78186 .87324 L

.81509 .84564 L

.84564 .81509 L

.87324 .78186 L

.89765 .74622 L

.91867 .70848 L

.93612 .66896 L

.94985 .62799 L

.95974 .58594 L

.96571 .54315 L

.96771 .5001 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->24,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001`Ool90omjOol006Ioo`X3
o`Aoo`03001oogoo009oo`T3og5oo`00Ggoo1`?o3Woo00<007ooOol02goo1`?oJWoo001KOol40olE
Ool00`00Oomoo`0BOol40omVOol005Moo`@3oaUoo`03001oogoo01Ioo`@3of9oo`00E7oo0`?o7Goo
00<007ooOol06Woo0`?oGgoo001AOol30olPOol00`00Oomoo`0MOol30omLOol004moo`83ob=oo`03
001oogoo021oo`<3oeUoo`00CGoo0P?o9Goo00<007ooOol08goo0P?oEgoo001;Ool20olWOol00`00
Oomoo`0UOol20omEOol004Uoo`83obUoo`03001oogoo02Moo`83oe=oo`00Agoo0P?o:goo00<007oo
Ool0:Goo0P?oDGoo0015Ool20ol]Ool00`00Oomoo`0[Ool20om?Ool004=oo`83obmoo`03001oogoo
02eoo`83odeoo`00@Goo0P?o<Goo00<007ooOol0;goo0P?oBgoo000oOol20olcOol00`00Oomoo`0a
Ool20om9Ool003ioo`030omoogoo03=oo`03001oogoo03=oo`030omoogoo04Ioo`00?7oo0P?o7Goo
1@0017oo0P001Goo10001Goo00<007ooOol0=7oo00<3ogooOol0AGoo000kOol00`?oOomoo`0OOol0
0`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0eOol20om5Ool0
03Yoo`030omoogoo021oo`03001oogoo00moo`03001oogoo009oo`03001oogoo03Moo`030omoogoo
049oo`00>7oo0P?o67oo1P001Goo00<007ooOol03goo00<007ooOol00Woo0P00>Goo00<3ogooOol0
@Goo000gOol00`?oOomoo`0SOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`0iOol00`?oOomoo`10
Ool003Ioo`030omoogoo02Aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo03Yoo`030omo
ogoo03moo`00=Goo00<3ogooOol08goo0`003Goo00<007ooOol01Woo00<007ooOol0>goo0P?o?goo
000cOol20olXOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`0mOol00`?oOomoo`0lOol0039oo`03
0omoogoo03moo`03001oogoo03ioo`030omoogoo03]oo`00<Goo00<3ogooOol0@7oo00<007ooOol0
?goo0P?o>goo000`Ool00`?oOomoo`11Ool00`00Oomoo`11Ool00`?oOomoo`0hOol002moo`030omo
ogoo049oo`03001oogoo049oo`030omoogoo03Moo`00;Woo00<3ogooOol0@goo00<007ooOol0@goo
00<3ogooOol0=Woo000/Ool20om6Ool00`00Oomoo`14Ool00`?oOomoo`0eOol002]oo`030omoogoo
04Ioo`03001oogoo04Eoo`030omoogoo03Aoo`00:Woo00<3ogooOol0Agoo00<007ooOol0AWoo00<3
ogooOol0<goo000YOol00`?oOomoo`18Ool00`00Oomoo`17Ool00`?oOomoo`0bOol002Qoo`030omo
ogoo04Uoo`03001oogoo04Qoo`030omoogoo035oo`009goo00<3ogooOol0BWoo00<007ooOol0BGoo
00<3ogooOol0<7oo000VOol00`?oOomoo`1;Ool00`00Oomoo`1:Ool00`?oOomoo`0_Ool002Ioo`03
0omoogoo04]oo`03001oogoo04Yoo`030omoogoo02moo`009Goo00<3ogooOol0C7oo00<007ooOol0
Bgoo00<3ogooOol0;Woo000TOol00`?oOomoo`1=Ool00`00Oomoo`1<Ool00`?oOomoo`0]Ool002=o
o`030omoogoo04ioo`03001oogoo04eoo`030omoogoo02aoo`008Woo00<3ogooOol0Cgoo00<007oo
Ool0CWoo00<3ogooOol0:goo000ROol00`?oOomoo`1?Ool00`00Oomoo`1>Ool00`?oOomoo`0[Ool0
025oo`030omoogoo051oo`03001oogoo04moo`030omoogoo02Yoo`0087oo00<3ogooOol0B7oo1@00
17oo00<007ooOol0D7oo00<3ogooOol0:Goo000POol00`?oOomoo`1:Ool00`00Oomoo`04Ool00`00
Oomoo`1@Ool00`?oOomoo`0YOol001moo`030omoogoo04]oo`03001oogoo00Aoo`03001oogoo055o
o`030omoogoo02Qoo`007goo00<3ogooOol0@7oo1P001Goo00<007ooOol017oo0P00DWoo00<3ogoo
Ool0:7oo000NOol00`?oOomoo`1<Ool00`00Oomoo`04Ool00`00Oomoo`1BOol00`?oOomoo`0WOol0
01eoo`030omoogoo04eoo`03001oogoo00Aoo`03001oogoo05=oo`030omoogoo02Ioo`007Goo00<3
ogooOol0Bgoo0`001Woo00<007ooOol0Dgoo00<3ogooOol09Woo000LOol00`?oOomoo`1>Ool00`00
Oomoo`04Ool00`00Oomoo`1DOol00`?oOomoo`0UOol001]oo`030omoogoo05Ioo`03001oogoo05Eo
o`030omoogoo02Aoo`006goo00<3ogooOol0EWoo00<007ooOol0EGoo00<3ogooOol097oo000JOol0
0`?oOomoo`1GOol00`00Oomoo`1FOol00`?oOomoo`0SOol001Yoo`030omoogoo05Moo`03001oogoo
05Ioo`030omoogoo02=oo`006Goo00<3ogooOol0F7oo00<007ooOol0Egoo00<3ogooOol08Woo000I
Ool00`?oOomoo`1HOol00`00Oomoo`1GOol00`?oOomoo`0ROol001Qoo`030omoogoo05Uoo`03001o
ogoo05Qoo`030omoogoo025oo`0067oo00<3ogooOol0FGoo00<007ooOol0F7oo00<3ogooOol08Goo
000HOol00`?oOomoo`1IOol00`00Oomoo`1IOol00`?oOomoo`0POol001Moo`030omoogoo05Yoo`03
001oogoo05Uoo`030omoogoo021oo`005goo00<3ogooOol0FWoo00<007ooOol0FWoo00<3ogooOol0
7goo000GOol00`?oOomoo`1JOol00`00Oomoo`1JOol00`?oOomoo`0OOol001Ioo`030omoogoo05]o
o`03001oogoo05]oo`030omoogoo01ioo`005Woo00<3ogooOol0Fgoo00<007ooOol0Fgoo00<3ogoo
Ool07Woo000FOol00`?oOomoo`1KOol00`00Oomoo`1KOol00`?oOomoo`0NOol001Eoo`030omoogoo
05aoo`03001oogoo05aoo`030omoogoo01eoo`005Goo00<3ogooOol0G7oo00<007ooOol0G7oo00<3
ogooOol07Goo000EOol00`?oOomoo`1LOol00`00Oomoo`1LOol00`?oOomoo`0MOol001Aoo`030omo
ogoo05eoo`03001oogoo05eoo`030omoogoo01aoo`0057oo00<3ogooOol0A7oo10001Goo0P001Goo
10001Goo00<007ooOol0GGoo00<3ogooOol077oo000DOol00`?oOomoo`13Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1MOol00`?oOomo
o`0LOol001=oo`030omoogoo04Aoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03
001oogoo05ioo`030omoogoo01]oo`004goo00<3ogooOol0?7oo1P000Woo00<007ooOol00Woo00<0
07ooOol03Goo00<007ooOol00Woo0P00Ggoo00<3ogooOol06goo000COol00`?oOomoo`14Ool00`00
Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`1NOol00`?oOomoo`0KOol001=oo`030omo
ogoo04Aoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo05ioo`030omo
ogoo01]oo`004Woo00<3ogooOol0AGoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo
00<007ooOol0Ggoo00<3ogooOol06Woo000BOol00`?oOomoo`16Ool4000<Ool50004Ool00`00Oomo
o`1OOol00`?oOomoo`0JOol0019oo`030omoogoo05moo`03001oogoo05moo`030omoogoo01Yoo`00
4Woo00<3ogooOol0Ggoo00<007ooOol0Ggoo00<3ogooOol06Woo000AOol00`?oOomoo`1POol00`00
Oomoo`1POol00`?oOomoo`0IOol0015oo`030omoogoo061oo`03001oogoo061oo`030omoogoo01Uo
o`004Goo00<3ogooOol0H7oo00<007ooOol0H7oo00<3ogooOol06Goo000AOol00`?oOomoo`1POol0
0`00Oomoo`1POol00`?oOomoo`0IOol0015oo`030omoogoo061oo`03001oogoo061oo`030omoogoo
01Uoo`0047oo00<3ogooOol0HGoo00<007ooOol0H7oo00<3ogooOol06Goo0009Ool50002Ool00`?o
Oomoo`0:Ool50004Ool20005Ool4000?Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>
Ool40005Ool20005Ool4000?Ool5000>Ool50004Ool20005Ool40008Ool00`?oOomoo`03Ool5000A
Ool000Uoo`05001oogooOol00002Ool00`?oOomoo`0<Ool00`00Oomoo`04Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool0
0`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2
0004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool20004Ool0
0`00Oomoo`02Ool00`00Oomoo`06Ool00`?oOomoo`02Ool01@00Oomoogoo00004Goo000:Ool00`00
Oomoo`03Ool00`?oOomoo`0<Ool00`00Oomoo`0?Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00
Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00
Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0?Ool00`00Oomoo`06Ool00`?o
Oomoo`03Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`05001oogooOol3o`04Ool60005Ool0
0`00Oomoo`0?Ool00`00Oomoo`03Ool60005Ool00`00Oomoo`05Ool60002Ool00`00Oomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool0
0`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0?Ool00`00Oomoo`06Ool00`?oOomoo`04Ool0
0`00Oomoo`0AOol000aoo`04001oogoo0ol?Ool00`00Oomoo`0;Ool4000AOol00`00Oomoo`0=Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool4000=Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomo
o`09Ool4000AOol00`00Oomoo`0@Ool00`00Oomoo`0;Ool40009Ool00`?oOomoo`05Ool00`00Oomo
o`0@Ool000eoo`03001oo`?o00moo`03001oogoo00]oo`03001oogoo019oo`03001oogoo00eoo`03
001oogoo009oo`03001oogoo00Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo019oo`03001oogoo011oo`03001oogoo00]oo`03001oogoo00Yoo`03
0omoogoo00Ioo`03001oogoo00moo`002Goo00L007ooOomoo`00Ool3o`0=Ool3000=Ool00`00Oomo
o`0@Ool3000?Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0@Ool3000@Ool3000=Ool00`00Oomoo`0:Ool0
0`?oOomoo`02Ool01@00Oomoogoo00004Goo000:Ool30002Ool00`?oOomoo`0=Ool00`00Oomoo`0;
Ool5000@Ool00`00Oomoo`0>Ool4000<Ool5000<Ool00`00Oomoo`0>Ool4000<Ool5000@Ool00`00
Oomoo`0@Ool00`00Oomoo`0;Ool50008Ool00`?oOomoo`03Ool3000BOol000moo`030omoogoo069o
o`03001oogoo065oo`030omoogoo01Qoo`003goo00<3ogooOol0HWoo00<007ooOol0HGoo00<3ogoo
Ool067oo000?Ool00`?oOomoo`1ROol00`00Oomoo`1ROol00`?oOomoo`0GOol000moo`030omoogoo
069oo`03001oogoo069oo`030omoogoo01Moo`003goo00<3ogooOol0HWoo00<007ooOol0HWoo00<3
ogooOol037oo0P000Woo0P001Goo000?Ool00`?oOomoo`1ROol00`00Oomoo`1ROol00`?oOomoo`0=
Ool01000Oomoo`001Woo0008Ool700000`?o0000003700000`?o000000050009Ool20007Ool000Qo
o`03001oogoo009oo`03001oo`?o00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`06001oogooOol3o`001Goo00<007oo
Ool01goo0P001goo0008Ool00`00Oomoo`04Ool00`?oOomoo`0AOol00`00Oomoo`0HOol00`00Oomo
o`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomo
o`0AOol00`?oOomoo`04Ool00`00Oomoo`06Ool01000Oomoo`001Woo000?Ool00`?oOomoo`1ROol0
0`00Oomoo`1ROol00`?oOomoo`0<Ool20002Ool20005Ool000moo`030omoogoo069oo`03001oogoo
069oo`030omoogoo01Moo`003goo00<3ogooOol0HWoo00<007ooOol0HGoo00<3ogooOol067oo000?
Ool00`?oOomoo`1ROol00`00Oomoo`1QOol00`?oOomoo`0HOol000moo`030omoogoo069oo`03001o
ogoo065oo`030omoogoo01Qoo`003goo00<3ogooOol0HWoo00<007ooOol0HGoo00<3ogooOol067oo
000?Ool00`?oOomoo`1ROol00`00Oomoo`1QOol00`?oOomoo`0HOol000moo`030omoogoo069oo`03
001oogoo065oo`030omoogoo01Qoo`003goo00<3ogooOol0HWoo00<007ooOol0HGoo00<3ogooOol0
67oo000@Ool00`?oOomoo`1QOol00`00Oomoo`1QOol00`?oOomoo`0HOol0011oo`030omoogoo065o
o`03001oogoo065oo`030omoogoo01Qoo`0047oo00<3ogooOol0HGoo00<007ooOol0H7oo00<3ogoo
Ool06Goo000@Ool00`?oOomoo`1QOol00`00Oomoo`1POol00`?oOomoo`0IOol0011oo`030omoogoo
065oo`03001oogoo061oo`030omoogoo01Uoo`004Goo00<3ogooOol0H7oo00<007ooOol0H7oo00<3
ogooOol06Goo000AOol00`?oOomoo`1POol00`00Oomoo`1POol00`?oOomoo`0IOol0015oo`030omo
ogoo061oo`03001oogoo061oo`030omoogoo01Uoo`004Goo00<3ogooOol0H7oo00<007ooOol0H7oo
00<3ogooOol06Goo000AOol00`?oOomoo`1POol00`00Oomoo`1POol00`?oOomoo`0IOol0019oo`03
0omoogoo05moo`03001oogoo05moo`030omoogoo01Yoo`004Woo00<3ogooOol0Ggoo00<007ooOol0
Ggoo00<3ogooOol06Woo000BOol00`?oOomoo`16Ool40005Ool20005Ool40005Ool00`00Oomoo`1O
Ool00`?oOomoo`0JOol0019oo`030omoogoo04Eoo`03001oogoo009oo`03001oogoo009oo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo05moo`030omoogoo01Yoo`004goo00<3ogoo
Ool0A7oo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0GWoo00<3ogoo
Ool06goo000COol00`?oOomoo`14Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool2
001OOol00`?oOomoo`0KOol001=oo`030omoogoo04Aoo`03001oogoo009oo`03001oogoo00Uoo`@0
00Eoo`03001oogoo05ioo`030omoogoo01]oo`004goo00<3ogooOol0A7oo00<007ooOol00Woo00<0
07ooOol02Goo00<007ooOol01Woo00<007ooOol0GWoo00<3ogooOol06goo000DOol00`?oOomoo`13
Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`1MOol00`?oOomoo`0L
Ool001Aoo`030omoogoo04Aoo`@000aoo`D000Aoo`03001oogoo05eoo`030omoogoo01aoo`0057oo
00<3ogooOol0GGoo00<007ooOol0GGoo00<3ogooOol077oo000EOol00`?oOomoo`1LOol00`00Oomo
o`1LOol00`?oOomoo`0MOol001Eoo`030omoogoo05aoo`03001oogoo05aoo`030omoogoo01eoo`00
5Goo00<3ogooOol0G7oo00<007ooOol0G7oo00<3ogooOol07Goo000FOol00`?oOomoo`1KOol00`00
Oomoo`1KOol00`?oOomoo`0NOol001Ioo`030omoogoo05]oo`03001oogoo05]oo`030omoogoo01io
o`005Woo00<3ogooOol0Fgoo00<007ooOol0FWoo00<3ogooOol07goo000GOol00`?oOomoo`1JOol0
0`00Oomoo`1JOol00`?oOomoo`0OOol001Moo`030omoogoo05Yoo`03001oogoo05Uoo`030omoogoo
021oo`0067oo00<3ogooOol0FGoo00<007ooOol0FGoo00<3ogooOol087oo000HOol00`?oOomoo`1I
Ool00`00Oomoo`1HOol00`?oOomoo`0QOol001Qoo`030omoogoo05Uoo`03001oogoo05Qoo`030omo
ogoo025oo`006Goo00<3ogooOol0F7oo00<007ooOol0Egoo00<3ogooOol08Woo000IOol00`?oOomo
o`1HOol00`00Oomoo`1GOol00`?oOomoo`0ROol001Yoo`030omoogoo05Moo`03001oogoo05Ioo`03
0omoogoo02=oo`006Woo00<3ogooOol0Egoo00<007ooOol0EWoo00<3ogooOol08goo000KOol00`?o
Oomoo`1FOol00`00Oomoo`1EOol00`?oOomoo`0TOol001aoo`030omoogoo05Eoo`03001oogoo05Ao
o`030omoogoo02Eoo`0077oo00<3ogooOol0EGoo00<007ooOol0E7oo00<3ogooOol09Goo000MOol0
0`?oOomoo`1;Ool50004Ool00`00Oomoo`1COol00`?oOomoo`0VOol001eoo`030omoogoo04eoo`03
001oogoo00Aoo`03001oogoo05=oo`030omoogoo02Ioo`007Woo00<3ogooOol0C7oo00<007ooOol0
17oo00<007ooOol0DWoo00<3ogooOol09goo000OOol00`?oOomoo`1;Ool00`00Oomoo`04Ool2001B
Ool00`?oOomoo`0XOol001moo`030omoogoo04]oo`03001oogoo00Aoo`03001oogoo055oo`030omo
ogoo02Qoo`0087oo00<3ogooOol0BWoo00<007ooOol017oo00<007ooOol0D7oo00<3ogooOol0:Goo
000QOol00`?oOomoo`17Ool30006Ool00`00Oomoo`1?Ool00`?oOomoo`0ZOol0025oo`030omoogoo
04Uoo`03001oogoo00Aoo`03001oogoo04moo`030omoogoo02Yoo`008Woo00<3ogooOol0Cgoo00<0
07ooOol0CWoo00<3ogooOol0:goo000ROol00`?oOomoo`1?Ool00`00Oomoo`1>Ool00`?oOomoo`0[
Ool002=oo`030omoogoo04ioo`03001oogoo04eoo`030omoogoo02aoo`0097oo00<3ogooOol0CGoo
00<007ooOol0C7oo00<3ogooOol0;Goo000UOol00`?oOomoo`1<Ool00`00Oomoo`1;Ool00`?oOomo
o`0^Ool002Ioo`030omoogoo04]oo`03001oogoo04Yoo`030omoogoo02moo`009Woo00<3ogooOol0
Bgoo00<007ooOol0BWoo00<3ogooOol0;goo000WOol00`?oOomoo`1:Ool00`00Oomoo`19Ool00`?o
Oomoo`0`Ool002Qoo`030omoogoo04Uoo`03001oogoo04Qoo`030omoogoo035oo`00:Goo00<3ogoo
Ool0B7oo00<007ooOol0Agoo00<3ogooOol0<Woo000ZOol00`?oOomoo`17Ool00`00Oomoo`16Ool0
0`?oOomoo`0cOol002]oo`030omoogoo04Ioo`03001oogoo04Eoo`030omoogoo03Aoo`00;7oo00<3
ogooOol0AGoo00<007ooOol0A7oo00<3ogooOol0=Goo000]Ool00`?oOomoo`14Ool00`00Oomoo`14
Ool00`?oOomoo`0eOol002ioo`030omoogoo04=oo`03001oogoo04=oo`030omoogoo03Ioo`00;goo
00<3ogooOol0@Woo00<007ooOol0@Woo00<3ogooOol0=goo000`Ool00`?oOomoo`11Ool00`00Oomo
o`11Ool00`?oOomoo`0hOol0035oo`030omoogoo041oo`03001oogoo041oo`030omoogoo03Uoo`00
<Woo00<3ogooOol0?goo00<007ooOol0?Woo0P?o?7oo000cOol20olVOol50004Ool20005Ool40005
Ool00`00Oomoo`0mOol00`?oOomoo`0lOol003Eoo`030omoogoo02Eoo`03001oogoo00Aoo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo03aoo`030omoogoo03eoo`00=Woo00<3ogoo
Ool097oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0>Woo0P?o@7oo000gOol00`?oOomo
o`0SOol00`00Oomoo`0?Ool00`00Oomoo`02Ool2000jOol00`?oOomoo`10Ool003Qoo`83ob=oo`03
001oogoo00]oo`@000Eoo`03001oogoo03Moo`83od=oo`00>Woo00<3ogooOol087oo00<007ooOol0
2goo00<007ooOol01Woo00<007ooOol0=Woo00<3ogooOol0@goo000kOol20olNOol3000=Ool00`00
Oomoo`06Ool00`00Oomoo`0eOol00`?oOomoo`14Ool003eoo`83oaioo`03001oogoo00]oo`D000Ao
o`03001oogoo03=oo`83odMoo`00?goo00<3ogooOol0<Woo00<007ooOol0<Woo00<3ogooOol0Agoo
0010Ool20olbOol00`00Oomoo`0`Ool20om:Ool0049oo`83oc1oo`03001oogoo02ioo`83odaoo`00
A7oo0P?o;Woo00<007ooOol0;7oo0P?oCWoo0016Ool20ol/Ool00`00Oomoo`0YOol30om@Ool004Qo
o`83obYoo`03001oogoo02Moo`83oe=oo`00BWoo0P?o:7oo00<007ooOol09Goo0P?oEGoo001<Ool2
0olVOol00`00Oomoo`0SOol20omGOol004ioo`<3ob=oo`03001oogoo021oo`<3oeUoo`00DGoo0`?o
87oo00<007ooOol07Goo0`?oG7oo001DOol30olMOol00`00Oomoo`0JOol30omOOol005Moo`@3oaUo
o`03001oogoo01Ioo`@3of9oo`00Fgoo10?o5Goo00<007ooOol04Woo10?oIWoo001OOol50ol@Ool0
0`00Oomoo`0=Ool50omZOol006Aoo`@3o`aoo`03001oogoo00Uoo`@3ofmoo`00J7oo60?oLgoo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001ZOol50005Ool0
0`00Oomoo`1lOol006Yoo`05001oogooOol00005Ool00`00Oomoo`1lOol006]oo`03001oogoo00Io
o`03001oogoo07aoo`00K7oo00<007ooOol01Goo0P00OGoo001]Ool00`00Oomoo`23Ool006ioo`03
001oogoo089oo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo0`00QGoo003cOol00?=oo`00lgoo003c
Ool009Eoo`<000]oo`D000Aoo`8000Eoo`@003aoo`00U7oo00H007ooOomoo`00Ool60005Ool00`00
Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0iOol007=oo`800003Ool0000001aoo`03
001oogoo00ioo`03001oogoo00moo`03001oogoo03Uoo`00LWoo00<007ooOol00P007Goo00<007oo
Ool00goo1P001Goo00<007ooOol03goo00<007ooOol0>Goo001bOol01@00Oomoogoo00007Goo00<0
07ooOol03Woo00<007ooOol02goo1000?7oo001bOol01@00Oomoogoo000077oo1@003Goo00<007oo
Ool02goo00<007ooOol0?Goo001bOol01@00Oomoogoo00007Goo00<007ooOol037oo0`003Goo00<0
07ooOol0?Goo001aOol20002Ool2000^Ool00`00Oomoo`0;Ool5000kOol00?=oo`00lgoo003cOol0
0?=oo`00lgoo0000\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.45) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .7 r

.5 Mabswid

.04242 .4999 m

.04438 .45778 L

.05022 .41592 L

.05989 .37478 L

.07332 .3347 L

.0904 .29604 L

.11096 .25912 L

.13485 .22425 L

.16185 .19173 L

.19173 .16185 L

.22425 .13485 L

.25912 .11096 L

.29604 .0904 L

.3347 .07332 L

.37478 .05989 L

.41592 .05022 L

.45778 .04438 L

.5 .04242 L

.54222 .04438 L

.58408 .05022 L

.62522 .05989 L

.6653 .07332 L

.70396 .0904 L

.74088 .11096 L

.77575 .13485 L

.80827 .16185 L

.83815 .19173 L

.86515 .22425 L

.88904 .25912 L

.9096 .29604 L

.92668 .3347 L

.94011 .37478 L

.94978 .41592 L

.95562 .45778 L

.95758 .4999 L

s

.04242 .5001 m

.04438 .54222 L

.05022 .58408 L

.05989 .62522 L

.07332 .6653 L

.0904 .70396 L

.11096 .74088 L

.13485 .77575 L

.16185 .80827 L

.19173 .83815 L

.22425 .86515 L

.25912 .88904 L

.29604 .9096 L

.3347 .92668 L

.37478 .94011 L

.41592 .94978 L

.45778 .95562 L

.5 .95758 L

.54222 .95562 L

.58408 .94978 L

.62522 .94011 L

.6653 .92668 L

.70396 .9096 L

.74088 .88904 L

.77575 .86515 L

.80827 .83815 L

.83815 .80827 L

.86515 .77575 L

.88904 .74088 L

.9096 .70396 L

.92668 .6653 L

.94011 .62522 L

.94978 .58408 L

.95562 .54222 L

.95758 .5001 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001WOolK0oEaOol0061oo`L3m@eoo`03001o
ogoo00]oo`L3mFYoo`00G7oo10?e57oo00<007ooOol04Woo10?eIWoo001HOol40oDHOol00`00Oomo
o`0FOol40oEROol005Eoo`<3mAaoo`03001oogoo01Yoo`83mF1oo`00DWoo0`?e7goo00<007ooOol0
77oo0`?eGGoo001@Ool20oDROol00`00Oomoo`0OOol30oEJOol004ioo`83mBAoo`03001oogoo029o
o`83mEQoo`00C7oo0P?e9Woo00<007ooOol097oo0P?eEWoo001:Ool20oDXOol00`00Oomoo`0VOol2
0oEDOol004Qoo`83mBYoo`03001oogoo02Qoo`83mE9oo`00AWoo0P?e;7oo00<007ooOol0:Woo0P?e
D7oo0014Ool20oD^Ool00`00Oomoo`0/Ool20oE>Ool0049oo`83mC1oo`03001oogoo02ioo`83mDao
o`00@7oo0P?e6Goo1@0017oo0P001Goo10001Goo00<007ooOol0<7oo0P?eBWoo000nOol20oDMOol0
0`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0bOol20oE8Ool0
03eoo`030oEoogoo01eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo03Aoo`030oEoogoo
04Eoo`00>goo0P?e5Goo1P001Goo00<007ooOol03goo00<007ooOol00Woo0P00=Woo00<3mGooOol0
A7oo000iOol20oDROol00`00Oomoo`0;Ool40005Ool00`00Oomoo`0fOol20oE4Ool003Qoo`030oEo
ogoo029oo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo03Qoo`030oEoogoo045oo`00=goo
00<3mGooOol08Goo0`003Goo00<007ooOol01Woo00<007ooOol0>Goo00<3mGooOol0@7oo000fOol0
0`?eOomoo`0TOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`0jOol00`?eOomoo`0oOol003Aoo`83
mCioo`03001oogoo03]oo`83mCmoo`00<goo00<3mGooOol0?Woo00<007ooOol0?Goo00<3mGooOol0
?7oo000bOol00`?eOomoo`0oOol00`00Oomoo`0nOol00`?eOomoo`0kOol0035oo`030oEoogoo041o
o`03001oogoo03moo`030oEoogoo03Yoo`00<7oo00<3mGooOol0@Goo00<007ooOol0@7oo00<3mGoo
Ool0>Goo000_Ool00`?eOomoo`12Ool00`00Oomoo`11Ool00`?eOomoo`0hOol002ioo`030oEoogoo
04=oo`03001oogoo049oo`030oEoogoo03Moo`00;Woo00<3mGooOol0@goo00<007ooOol0@goo00<3
mGooOol0=Woo000]Ool00`?eOomoo`14Ool00`00Oomoo`14Ool00`?eOomoo`0eOol002aoo`030oEo
ogoo04Eoo`03001oogoo04Eoo`030oEoogoo03Aoo`00:goo00<3mGooOol0AWoo00<007ooOol0AWoo
00<3mGooOol0<goo000ZOol00`?eOomoo`17Ool00`00Oomoo`17Ool00`?eOomoo`0bOol002Uoo`03
0oEoogoo04Qoo`03001oogoo04Moo`030oEoogoo039oo`00:7oo00<3mGooOol0BGoo00<007ooOol0
B7oo00<3mGooOol0<Goo000XOol00`?eOomoo`19Ool00`00Oomoo`19Ool00`?eOomoo`0`Ool002Mo
o`030oEoogoo04Yoo`03001oogoo04Yoo`030oEoogoo02moo`009Woo00<3mGooOol0Bgoo00<007oo
Ool0BWoo00<3mGooOol0;goo000UOol00`?eOomoo`1<Ool00`00Oomoo`1;Ool00`?eOomoo`0^Ool0
02Aoo`030oEoogoo04eoo`03001oogoo04aoo`030oEoogoo02eoo`0097oo00<3mGooOol0A7oo1@00
17oo00<007ooOol0CGoo00<3mGooOol0;7oo000SOol00`?eOomoo`17Ool00`00Oomoo`04Ool00`00
Oomoo`1>Ool00`?eOomoo`0[Ool0029oo`030oEoogoo04Qoo`03001oogoo00Aoo`03001oogoo04io
o`030oEoogoo02]oo`008Goo00<3mGooOol0?Woo1P001Goo00<007ooOol017oo0P00D7oo00<3mGoo
Ool0:Woo000QOol00`?eOomoo`19Ool00`00Oomoo`04Ool00`00Oomoo`1@Ool00`?eOomoo`0YOol0
021oo`030oEoogoo04Yoo`03001oogoo00Aoo`03001oogoo055oo`030oEoogoo02Qoo`007goo00<3
mGooOol0BGoo0`001Woo00<007ooOol0DWoo00<3mGooOol09goo000OOol00`?eOomoo`1;Ool00`00
Oomoo`04Ool00`00Oomoo`1BOol00`?eOomoo`0WOol001ioo`030oEoogoo05=oo`03001oogoo05=o
o`030oEoogoo02Ioo`007Goo00<3mGooOol0E7oo00<007ooOol0Dgoo00<3mGooOol09Woo000MOol0
0`?eOomoo`1DOol00`00Oomoo`1DOol00`?eOomoo`0UOol001aoo`030oEoogoo05Eoo`03001oogoo
05Aoo`030oEoogoo02Eoo`0077oo00<3mGooOol0EGoo00<007ooOol0EGoo00<3mGooOol097oo000K
Ool00`?eOomoo`1FOol00`00Oomoo`1EOol00`?eOomoo`0TOol001]oo`030oEoogoo05Ioo`03001o
ogoo05Eoo`030oEoogoo02Aoo`006Woo00<3mGooOol0Egoo00<007ooOol0EWoo00<3mGooOol08goo
000JOol00`?eOomoo`1GOol00`00Oomoo`1FOol00`?eOomoo`0SOol001Yoo`030oEoogoo05Moo`03
001oogoo05Moo`030oEoogoo029oo`006Goo00<3mGooOol0F7oo00<007ooOol0Egoo00<3mGooOol0
8Woo000IOol00`?eOomoo`1HOol00`00Oomoo`1HOol00`?eOomoo`0QOol001Uoo`030oEoogoo05Qo
o`03001oogoo05Qoo`030oEoogoo025oo`0067oo00<3mGooOol0FGoo00<007ooOol0FGoo00<3mGoo
Ool087oo000HOol00`?eOomoo`1IOol00`00Oomoo`1IOol00`?eOomoo`0POol001Qoo`030oEoogoo
05Uoo`03001oogoo05Uoo`030oEoogoo021oo`005goo00<3mGooOol0FWoo00<007ooOol0FWoo00<3
mGooOol07goo000GOol00`?eOomoo`1JOol00`00Oomoo`1JOol00`?eOomoo`0OOol001Ioo`030oEo
ogoo05]oo`03001oogoo05]oo`030oEoogoo01ioo`005Woo00<3mGooOol0@Woo10001Goo0P001Goo
10001Goo00<007ooOol0Fgoo00<3mGooOol07Woo000FOol00`?eOomoo`11Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1KOol00`?eOomo
o`0NOol001Eoo`030oEoogoo049oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03
001oogoo05aoo`030oEoogoo01eoo`005Goo00<3mGooOol0>Woo1P000Woo00<007ooOol00Woo00<0
07ooOol03Goo00<007ooOol00Woo0P00GGoo00<3mGooOol07Goo000EOol00`?eOomoo`12Ool00`00
Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`1LOol00`?eOomoo`0MOol001Eoo`030oEo
ogoo049oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo05aoo`030oEo
ogoo01eoo`0057oo00<3mGooOol0@goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo
00<007ooOol0GGoo00<3mGooOol077oo000DOol00`?eOomoo`14Ool4000<Ool50004Ool00`00Oomo
o`1MOol00`?eOomoo`0LOol001Aoo`030oEoogoo05eoo`03001oogoo05eoo`030oEoogoo01aoo`00
57oo00<3mGooOol0GGoo00<007ooOol0GGoo00<3mGooOol077oo000COol00`?eOomoo`1NOol00`00
Oomoo`1NOol00`?eOomoo`0KOol001=oo`030oEoogoo05ioo`03001oogoo05ioo`030oEoogoo01]o
o`004goo00<3mGooOol0GWoo00<007ooOol0GWoo00<3mGooOol06goo000COol00`?eOomoo`1NOol0
0`00Oomoo`1NOol00`?eOomoo`0KOol001=oo`030oEoogoo05ioo`03001oogoo05ioo`030oEoogoo
01]oo`004Woo00<3mGooOol0Ggoo00<007ooOol0GWoo00<3mGooOol06goo0009Ool50004Ool00`?e
Oomoo`08Ool50004Ool20005Ool4000?Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>
Ool40005Ool20005Ool4000?Ool5000>Ool50004Ool20005Ool40006Ool00`?eOomoo`05Ool5000A
Ool000Uoo`05001oogooOol00004Ool00`?eOomoo`0:Ool00`00Oomoo`04Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool0
0`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2
0004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool20004Ool0
0`00Oomoo`02Ool00`00Oomoo`04Ool00`?eOomoo`04Ool01@00Oomoogoo00004Goo000:Ool00`00
Oomoo`05Ool00`?eOomoo`0:Ool00`00Oomoo`0?Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00
Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00
Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool00`?e
Oomoo`05Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00=oo`030oEoogoo00H0
00Eoo`03001oogoo00moo`03001oogoo00=oo`H000Eoo`03001oogoo00Eoo`H0009oo`03001oogoo
009oo`03001oogoo00eoo`03001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo
00eoo`03001oogoo00ioo`03001oogoo011oo`03001oogoo00moo`03001oogoo00Aoo`030oEoogoo
00Ioo`03001oogoo015oo`0037oo00<007ooOol00Woo00<3mGooOol02goo00<007ooOol02goo1000
4Goo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo10003Goo00<007ooOol03Goo00<0
07ooOol00Woo00<007ooOol02Goo10004Goo00<007ooOol047oo00<007ooOol02goo10001goo00<3
mGooOol01goo00<007ooOol047oo000=Ool01@00Oomoogoo0oD03Goo00<007ooOol02goo00<007oo
Ool04Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007oo
Ool03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol04Woo00<007ooOol047oo00<007oo
Ool02goo00<007ooOol027oo00<3mGooOol027oo00<007ooOol03goo0009Ool01@00Oomoogoo0000
0goo00<3mGooOol02Goo0`003Goo00<007ooOol047oo0`003goo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
47oo0`0047oo0`003Goo00<007ooOol027oo00<3mGooOol017oo00D007ooOomoo`00015oo`002Woo
0`0017oo00<3mGooOol02goo00<007ooOol02goo1@0047oo00<007ooOol03Woo100037oo1@0037oo
00<007ooOol03Woo100037oo1@0047oo00<007ooOol047oo00<007ooOol02goo1@001Woo00<3mGoo
Ool01Goo0`004Woo000AOol00`?eOomoo`1POol00`00Oomoo`1OOol00`?eOomoo`0JOol0015oo`03
0oEoogoo061oo`03001oogoo05moo`030oEoogoo01Yoo`004Goo00<3mGooOol0H7oo00<007ooOol0
Ggoo00<3mGooOol06Woo000AOol00`?eOomoo`1POol00`00Oomoo`1OOol00`?eOomoo`0JOol0015o
o`030oEoogoo061oo`03001oogoo05moo`030oEoogoo00moo`80009oo`8000Eoo`004Goo00<3mGoo
Ool0H7oo00<007ooOol0Ggoo00<3mGooOol047oo00@007ooOol000Ioo`0027oo2@0000<3m@000000
`P0000<3m@00000020002Goo0P001goo0008Ool00`00Oomoo`02Ool01`00Oomoogoo0oEoo`0000Ao
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`030003mGoo009oo`03001oogoo00=oo`03001oogoo00Moo`8000Moo`0027oo00<007ooOol01Woo
00<3mGooOol03goo00<007ooOol067oo00<007ooOol067oo00<007ooOol067oo00<007ooOol067oo
00<007ooOol067oo00<007ooOol067oo00<007ooOol03Woo00<3mGooOol01goo00<007ooOol01Woo
00@007ooOol000Ioo`004Goo00<3mGooOol0H7oo00<007ooOol0Ggoo00<3mGooOol03goo0P000Woo
0P001Goo000AOol00`?eOomoo`1POol00`00Oomoo`1OOol00`?eOomoo`0JOol0015oo`030oEoogoo
061oo`03001oogoo05moo`030oEoogoo01Yoo`004Goo00<3mGooOol0H7oo00<007ooOol0Ggoo00<3
mGooOol06Woo000AOol00`?eOomoo`1POol00`00Oomoo`1OOol00`?eOomoo`0JOol0015oo`030oEo
ogoo061oo`03001oogoo05moo`030oEoogoo01Yoo`004Goo00<3mGooOol0H7oo00<007ooOol0Ggoo
00<3mGooOol06Woo000AOol00`?eOomoo`1POol00`00Oomoo`1OOol00`?eOomoo`0JOol0015oo`03
0oEoogoo061oo`03001oogoo05moo`030oEoogoo01Yoo`004Woo00<3mGooOol0Ggoo00<007ooOol0
Ggoo00<3mGooOol06Woo000BOol00`?eOomoo`1OOol00`00Oomoo`1OOol00`?eOomoo`0JOol0019o
o`030oEoogoo05moo`03001oogoo05ioo`030oEoogoo01]oo`004Woo00<3mGooOol0Ggoo00<007oo
Ool0GWoo00<3mGooOol06goo000COol00`?eOomoo`1NOol00`00Oomoo`1NOol00`?eOomoo`0KOol0
01=oo`030oEoogoo05ioo`03001oogoo05ioo`030oEoogoo01]oo`004goo00<3mGooOol0GWoo00<0
07ooOol0GWoo00<3mGooOol06goo000COol00`?eOomoo`1NOol00`00Oomoo`1NOol00`?eOomoo`0K
Ool001=oo`030oEoogoo05ioo`03001oogoo05ioo`030oEoogoo01]oo`0057oo00<3mGooOol0GGoo
00<007ooOol0GGoo00<3mGooOol077oo000DOol00`?eOomoo`1MOol00`00Oomoo`1MOol00`?eOomo
o`0LOol001Aoo`030oEoogoo05eoo`03001oogoo05eoo`030oEoogoo01aoo`0057oo00<3mGooOol0
A7oo10001Goo0P001Goo10001Goo00<007ooOol0GGoo00<3mGooOol077oo000EOol00`?eOomoo`12
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`1LOol00`?eOomoo`0MOol001Eoo`030oEoogoo049oo`03001oogoo009oo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo05aoo`030oEoogoo01eoo`005Goo00<3mGooOol0@Woo00<007oo
Ool00Woo00<007ooOol03Goo00<007ooOol00Woo0P00GGoo00<3mGooOol07Goo000EOol00`?eOomo
o`12Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`1LOol00`?eOomoo`0MOol0
01Ioo`030oEoogoo045oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo
05]oo`030oEoogoo01ioo`005Woo00<3mGooOol0@Goo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol01Woo00<007ooOol0Fgoo00<3mGooOol07Woo000FOol00`?eOomoo`12Ool4000<Ool50004
Ool00`00Oomoo`1KOol00`?eOomoo`0NOol001Moo`030oEoogoo05Yoo`03001oogoo05Yoo`030oEo
ogoo01moo`005goo00<3mGooOol0FWoo00<007ooOol0FWoo00<3mGooOol07goo000GOol00`?eOomo
o`1JOol00`00Oomoo`1JOol00`?eOomoo`0OOol001Qoo`030oEoogoo05Uoo`03001oogoo05Uoo`03
0oEoogoo021oo`0067oo00<3mGooOol0FGoo00<007ooOol0FGoo00<3mGooOol087oo000HOol00`?e
Oomoo`1IOol00`00Oomoo`1HOol00`?eOomoo`0QOol001Uoo`030oEoogoo05Qoo`03001oogoo05Qo
o`030oEoogoo025oo`006Goo00<3mGooOol0F7oo00<007ooOol0Egoo00<3mGooOol08Woo000JOol0
0`?eOomoo`1GOol00`00Oomoo`1GOol00`?eOomoo`0ROol001Yoo`030oEoogoo05Moo`03001oogoo
05Ioo`030oEoogoo02=oo`006Woo00<3mGooOol0Egoo00<007ooOol0EWoo00<3mGooOol08goo000K
Ool00`?eOomoo`1FOol00`00Oomoo`1EOol00`?eOomoo`0TOol001]oo`030oEoogoo05Ioo`03001o
ogoo05Eoo`030oEoogoo02Aoo`0077oo00<3mGooOol0EGoo00<007ooOol0E7oo00<3mGooOol09Goo
000LOol00`?eOomoo`1EOol00`00Oomoo`1DOol00`?eOomoo`0UOol001eoo`030oEoogoo05Aoo`03
001oogoo05=oo`030oEoogoo02Ioo`007Woo00<3mGooOol0Dgoo00<007ooOol0Dgoo00<3mGooOol0
9Woo000NOol00`?eOomoo`1COol00`00Oomoo`1BOol00`?eOomoo`0WOol001moo`030oEoogoo059o
o`03001oogoo059oo`030oEoogoo02Moo`007goo00<3mGooOol0BGoo1@0017oo00<007ooOol0DGoo
00<3mGooOol0:7oo000POol00`?eOomoo`1:Ool00`00Oomoo`04Ool00`00Oomoo`1AOol00`?eOomo
o`0XOol0025oo`030oEoogoo04Uoo`03001oogoo00Aoo`03001oogoo051oo`030oEoogoo02Uoo`00
8Goo00<3mGooOol0BGoo00<007ooOol017oo0P00D7oo00<3mGooOol0:Woo000ROol00`?eOomoo`18
Ool00`00Oomoo`04Ool00`00Oomoo`1?Ool00`?eOomoo`0ZOol002=oo`030oEoogoo04Moo`03001o
ogoo00Aoo`03001oogoo04ioo`030oEoogoo02]oo`008goo00<3mGooOol0AGoo0`001Woo00<007oo
Ool0CGoo00<3mGooOol0;7oo000TOol00`?eOomoo`16Ool00`00Oomoo`04Ool00`00Oomoo`1<Ool0
0`?eOomoo`0]Ool002Aoo`030oEoogoo04eoo`03001oogoo04aoo`030oEoogoo02eoo`009Goo00<3
mGooOol0C7oo00<007ooOol0Bgoo00<3mGooOol0;Woo000VOol00`?eOomoo`1;Ool00`00Oomoo`1:
Ool00`?eOomoo`0_Ool002Moo`030oEoogoo04Yoo`03001oogoo04Yoo`030oEoogoo02moo`00:7oo
00<3mGooOol0BGoo00<007ooOol0BGoo00<3mGooOol0<7oo000XOol00`?eOomoo`19Ool00`00Oomo
o`18Ool00`?eOomoo`0aOol002Uoo`030oEoogoo04Qoo`03001oogoo04Moo`030oEoogoo039oo`00
:Woo00<3mGooOol0Agoo00<007ooOol0Agoo00<3mGooOol0<Woo000[Ool00`?eOomoo`16Ool00`00
Oomoo`16Ool00`?eOomoo`0cOol002aoo`030oEoogoo04Eoo`03001oogoo04Eoo`030oEoogoo03Ao
o`00;Goo00<3mGooOol0A7oo00<007ooOol0A7oo00<3mGooOol0=Goo000^Ool00`?eOomoo`13Ool0
0`00Oomoo`12Ool20oDhOol002moo`030oEoogoo049oo`03001oogoo045oo`030oEoogoo03Qoo`00
<7oo00<3mGooOol0@Goo00<007ooOol0@7oo00<3mGooOol0>Goo000aOol00`?eOomoo`10Ool00`00
Oomoo`0oOol00`?eOomoo`0jOol0039oo`030oEoogoo03moo`03001oogoo03ioo`030oEoogoo03]o
o`00<goo00<3mGooOol0?Woo00<007ooOol0?Goo00<3mGooOol0?7oo000dOol20oDnOol00`00Oomo
o`0kOol20oDoOol003Ioo`030oEoogoo03]oo`03001oogoo03Yoo`030oEoogoo03moo`00=goo00<3
mGooOol08Goo1@0017oo0P001Goo10001Goo00<007ooOol0>Goo00<3mGooOol0@7oo000hOol00`?e
Oomoo`0ROol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0h
Ool00`?eOomoo`11Ool003Uoo`83mB9oo`03001oogoo00moo`03001oogoo009oo`03001oogoo03Io
o`83mDAoo`00>goo00<3mGooOol07goo00<007ooOol03goo00<007ooOol00Woo0P00=Woo00<3mGoo
Ool0A7oo000lOol20oDOOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`0dOol00`?eOomoo`15Ool0
03ioo`83mAeoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo039oo`83mDQoo`00@7oo00<3
mGooOol067oo0`003Goo00<007ooOol01Woo00<007ooOol0<Goo00<3mGooOol0B7oo0011Ool20oDJ
Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`0_Ool20oE;Ool004=oo`030oEoogoo02ioo`03001o
ogoo02ioo`030oEoogoo04]oo`00A7oo0P?e;Woo00<007ooOol0;7oo0P?eCWoo0016Ool20oD/Ool0
0`00Oomoo`0ZOol20oE@Ool004Qoo`83mBYoo`03001oogoo02Qoo`83mE9oo`00BWoo0P?e:7oo00<0
07ooOol09Goo0`?eE7oo001<Ool30oDUOol00`00Oomoo`0ROol30oEGOol004moo`<3mB9oo`03001o
ogoo01moo`<3mEYoo`00DWoo0`?e7goo00<007ooOol07Goo0P?eGGoo001EOol30oDLOol00`00Oomo
o`0JOol30oEOOol005Qoo`@3mAQoo`03001oogoo01Ioo`@3mF9oo`00G7oo10?e57oo00<007ooOol0
4Woo10?eIWoo001POol70oD=Ool00`00Oomoo`0;Ool70oEZOol006Moo`T3m@Aoo`03001oogoo009o
o`T3mG5oo`00L7oo2@?eNWoo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00JWoo1@001Goo00<007oo
Ool0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool00`00Oomoo`06Ool00`00
Oomoo`1lOol006aoo`03001oogoo00Eoo`8007eoo`00KGoo00<007ooOol0Pgoo001^Ool00`00Oomo
o`22Ool006Yoo`05001oogooOol00024Ool006]oo`<008Eoo`00lgoo003cOol00?=oo`00lgoo002A
Ool3000;Ool50004Ool20007Ool30003Ool4000hOol0091oo`06001oogooOol007oo1P001Goo00<0
07ooOol017oo0P0027oo00D007ooOomoo`0000Aoo`03001oogoo03Eoo`00Lgoo0P0000=oo`000000
67oo00<007ooOol03Woo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol0=Goo001bOol00`00
Oomoo`02000IOol00`00Oomoo`03Ool60005Ool00`00Oomoo`0:Ool60007Ool00`00Oomoo`0eOol0
079oo`05001oogooOol0000IOol00`00Oomoo`0>Ool00`00Oomoo`0;Ool01000Oomoo`0017oo1000
>7oo001bOol01@00Oomoogoo000067oo1@003Goo00<007ooOol02goo00@007ooOol000Aoo`03001o
ogoo03Uoo`00LWoo00D007ooOomoo`0001Uoo`03001oogoo00aoo`<000ioo`03001oo`0000Aoo`03
001oogoo03Uoo`00LGoo0P000Woo0P00:Woo00<007ooOol03Goo0P0017oo1@00=goo003cOol00?=o
o`00lgoo003cOol00?=oo`00\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.4) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .4 r

.5 Mabswid

.05279 .49991 m

.05469 .45874 L

.0604 .41782 L

.06986 .37761 L

.08299 .33845 L

.09967 .30066 L

.11977 .26457 L

.14312 .23049 L

.16951 .19871 L

.19871 .16951 L

.23049 .14312 L

.26457 .11977 L

.30066 .09967 L

.33845 .08299 L

.37761 .06986 L

.41782 .0604 L

.45874 .05469 L

.5 .05279 L

.54126 .05469 L

.58218 .0604 L

.62239 .06986 L

.66155 .08299 L

.69934 .09967 L

.73543 .11977 L

.76951 .14312 L

.80129 .16951 L

.83049 .19871 L

.85688 .23049 L

.88023 .26457 L

.90033 .30066 L

.91701 .33845 L

.93014 .37761 L

.9396 .41782 L

.94531 .45874 L

.94721 .49991 L

s

.05279 .50009 m

.05469 .54126 L

.0604 .58218 L

.06986 .62239 L

.08299 .66155 L

.09967 .69934 L

.11977 .73543 L

.14312 .76951 L

.16951 .80129 L

.19871 .83049 L

.23049 .85688 L

.26457 .88023 L

.30066 .90033 L

.33845 .91701 L

.37761 .93014 L

.41782 .9396 L

.45874 .94531 L

.5 .94721 L

.54126 .94531 L

.58218 .9396 L

.62239 .93014 L

.66155 .91701 L

.69934 .90033 L

.73543 .88023 L

.76951 .85688 L

.80129 .83049 L

.83049 .80129 L

.85688 .76951 L

.88023 .73543 L

.90033 .69934 L

.91701 .66155 L

.93014 .62239 L

.9396 .58218 L

.94531 .54126 L

.94721 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00Igoo6P?/LWoo001POol70n`=Ool00`00Oomoo`0:Ool70na[Ool005aoo`@3k1Aoo`03
001oogoo015oo`@3k6Moo`00F7oo10?/67oo00<007ooOol05Goo10?/Hgoo001FOol20n`LOol00`00
Oomoo`0IOol30naPOol005=oo`<3k1ioo`03001oogoo01aoo`<3k5eoo`00DGoo0P?/8Goo00<007oo
Ool07goo0P?/Fgoo001?Ool20n`SOol00`00Oomoo`0QOol20naIOol004eoo`83k2Eoo`03001oogoo
02=oo`83k5Moo`00Bgoo0P?/9goo00<007ooOol09Goo0P?/EGoo0019Ool20n`YOol00`00Oomoo`0W
Ool20naCOol004Moo`83k2]oo`03001oogoo02Uoo`83k55oo`00AGoo0P?/57oo1@0017oo0P001Goo
10001Goo00<007ooOol0:goo0P?/Cgoo0013Ool20n`HOol00`00Oomoo`04Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`0]Ool20na=Ool0045oo`83k1Yoo`03001oogoo00moo`03
001oogoo009oo`03001oogoo02moo`030naoogoo04Yoo`00?goo0P?/4Goo1P001Goo00<007ooOol0
3goo00<007ooOol00Woo0P00<Goo0P?/BWoo000nOol00`?/Oomoo`0LOol00`00Oomoo`0;Ool40005
Ool00`00Oomoo`0bOol00`?/Oomoo`17Ool003eoo`030naoogoo01eoo`03001oogoo00]oo`03001o
ogoo00Ioo`03001oogoo03=oo`83k4Moo`00>goo0P?/7Woo0`003Goo00<007ooOol01Woo00<007oo
Ool0=Goo0P?/AGoo000jOol00`?/Oomoo`0POol00`00Oomoo`0;Ool50004Ool00`00Oomoo`0gOol0
0`?/Oomoo`12Ool003Uoo`030naoogoo03Qoo`03001oogoo03Qoo`030naoogoo045oo`00>7oo00<3
k7ooOol0>Goo00<007ooOol0>Goo00<3k7ooOol0@7oo000fOol20n`lOol00`00Oomoo`0jOol20na0
Ool003Eoo`030naoogoo03aoo`03001oogoo03aoo`030naoogoo03eoo`00=7oo00<3k7ooOol0?Goo
00<007ooOol0?Goo00<3k7ooOol0?7oo000cOol00`?/Oomoo`0nOol00`00Oomoo`0nOol00`?/Oomo
o`0kOol0039oo`030naoogoo03moo`03001oogoo03moo`030naoogoo03Yoo`00<Goo00<3k7ooOol0
@7oo00<007ooOol0@7oo00<3k7ooOol0>Goo000_Ool20na3Ool00`00Oomoo`11Ool00`?/Oomoo`0h
Ool002ioo`030naoogoo04=oo`03001oogoo049oo`030naoogoo03Moo`00;Goo00<3k7ooOol0A7oo
00<007ooOol0@goo00<3k7ooOol0=Woo000/Ool00`?/Oomoo`15Ool00`00Oomoo`14Ool00`?/Oomo
o`0eOol002]oo`030naoogoo04Ioo`03001oogoo04Eoo`030naoogoo03Aoo`00:goo00<3k7ooOol0
AWoo00<007ooOol0AWoo00<3k7ooOol0<goo000ZOol00`?/Oomoo`17Ool00`00Oomoo`17Ool00`?/
Oomoo`0bOol002Uoo`030naoogoo04Qoo`03001oogoo04Moo`030naoogoo039oo`00:7oo00<3k7oo
Ool0BGoo00<007ooOol0B7oo00<3k7ooOol0<Goo000XOol00`?/Oomoo`19Ool00`00Oomoo`19Ool0
0`?/Oomoo`0`Ool002Moo`030naoogoo04Yoo`03001oogoo04Yoo`030naoogoo02moo`009Woo00<3
k7ooOol0@Woo1@0017oo00<007ooOol0Bgoo00<3k7ooOol0;Woo000VOol00`?/Oomoo`14Ool00`00
Oomoo`04Ool00`00Oomoo`1;Ool00`?/Oomoo`0^Ool002Eoo`030naoogoo04Eoo`03001oogoo00Ao
o`03001oogoo04aoo`030naoogoo02eoo`0097oo00<3k7ooOol0>goo1P001Goo00<007ooOol017oo
0P00CWoo00<3k7ooOol0;7oo000SOol00`?/Oomoo`17Ool00`00Oomoo`04Ool00`00Oomoo`1>Ool0
0`?/Oomoo`0[Ool002=oo`030naoogoo04Moo`03001oogoo00Aoo`03001oogoo04ioo`030naoogoo
02]oo`008Woo00<3k7ooOol0AWoo0`001Woo00<007ooOol0Cgoo00<3k7ooOol0:Woo000QOol00`?/
Oomoo`19Ool00`00Oomoo`04Ool00`00Oomoo`1@Ool00`?/Oomoo`0YOol0025oo`030naoogoo051o
o`03001oogoo051oo`030naoogoo02Uoo`0087oo00<3k7ooOol0DGoo00<007ooOol0DGoo00<3k7oo
Ool0:7oo000OOol00`?/Oomoo`1BOol00`00Oomoo`1AOol00`?/Oomoo`0XOol001moo`030naoogoo
059oo`03001oogoo059oo`030naoogoo02Moo`007Woo00<3k7ooOol0Dgoo00<007ooOol0DWoo00<3
k7ooOol09goo000NOol00`?/Oomoo`1COol00`00Oomoo`1COol00`?/Oomoo`0VOol001eoo`030nao
ogoo05Aoo`03001oogoo05=oo`030naoogoo02Ioo`007Goo00<3k7ooOol0E7oo00<007ooOol0E7oo
00<3k7ooOol09Goo000LOol00`?/Oomoo`1EOol00`00Oomoo`1DOol00`?/Oomoo`0UOol001aoo`03
0naoogoo05Eoo`03001oogoo05Eoo`030naoogoo02Aoo`006goo00<3k7ooOol0EWoo00<007ooOol0
EGoo00<3k7ooOol097oo000KOol00`?/Oomoo`1FOol00`00Oomoo`1FOol00`?/Oomoo`0SOol001]o
o`030naoogoo05Ioo`03001oogoo05Ioo`030naoogoo02=oo`006Woo00<3k7ooOol0Egoo00<007oo
Ool0Egoo00<3k7ooOol08Woo000JOol00`?/Oomoo`1GOol00`00Oomoo`1GOol00`?/Oomoo`0ROol0
01Yoo`030naoogoo05Moo`03001oogoo05Moo`030naoogoo029oo`006Goo00<3k7ooOol0F7oo00<0
07ooOol0Egoo00<3k7ooOol08Woo000IOol00`?/Oomoo`1HOol00`00Oomoo`1HOol00`?/Oomoo`0Q
Ool001Uoo`030naoogoo05Qoo`03001oogoo05Qoo`030naoogoo025oo`0067oo00<3k7ooOol0@7oo
10001Goo0P001Goo10001Goo00<007ooOol0F7oo00<3k7ooOol08Goo000HOol00`?/Oomoo`0oOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1HOol00`?/Oomoo`0QOol001Qoo`030naoogoo03moo`03001oogoo009oo`03001oogoo00eoo`03
001oogoo009oo`03001oogoo05Uoo`030naoogoo021oo`005goo00<3k7ooOol0>7oo1P000Woo00<0
07ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00FWoo00<3k7ooOol087oo000GOol00`?/
Oomoo`10Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`1IOol00`?/Oomoo`0P
Ool001Moo`030naoogoo041oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001o
ogoo05Uoo`030naoogoo021oo`005Woo00<3k7ooOol0@Goo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol01Woo00<007ooOol0FWoo00<3k7ooOol07goo000FOol00`?/Oomoo`12Ool4000<Ool5
0004Ool00`00Oomoo`1JOol00`?/Oomoo`0OOol001Ioo`030naoogoo05]oo`03001oogoo05Yoo`03
0naoogoo01moo`005Woo00<3k7ooOol0Fgoo00<007ooOol0FWoo00<3k7ooOol07goo000EOol00`?/
Oomoo`1LOol00`00Oomoo`1KOol00`?/Oomoo`0NOol001Eoo`030naoogoo05aoo`03001oogoo05]o
o`030naoogoo01ioo`005Goo00<3k7ooOol0G7oo00<007ooOol0Fgoo00<3k7ooOol07Woo000EOol0
0`?/Oomoo`1LOol00`00Oomoo`1KOol00`?/Oomoo`0NOol001Eoo`030naoogoo05aoo`03001oogoo
05]oo`030naoogoo01ioo`005Goo00<3k7ooOol0G7oo00<007ooOol0G7oo00<3k7ooOol07Goo0009
Ool50007Ool00`?/Oomoo`05Ool50004Ool20005Ool4000?Ool5000>Ool40005Ool20005Ool4000=
Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool5000>Ool50004Ool20005Ool40004Ool00`?/
Oomoo`07Ool5000AOol000Uoo`05001oogooOol00006Ool00`?/Oomoo`08Ool00`00Oomoo`04Ool2
0004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomo
o`04Ool20004Ool00`00Oomoo`02Ool01@00Oomoogoo0n`02Goo00D007ooOomoo`00015oo`002Woo
00<007ooOol01goo00<3k7ooOol027oo00<007ooOol03goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol02Woo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol047oo00<007ooOol03goo00D007ooOomoo`?/
00Yoo`03001oogoo019oo`0000=oo`000000100017oo00<007ooOol01Woo00<3k00000000`001Goo
00<007ooOol03goo00<007ooOol00goo1P001Goo00<007ooOol01Goo1P000Woo00<007ooOol00Woo
00<007ooOol03Goo00<007ooOol02Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol047oo00<007ooOol03goo00<007ooOol00Woo00<3k7ooOol027oo
00<007ooOol04Goo000<Ool00`00Oomoo`05Ool00`?/Oomoo`08Ool00`00Oomoo`0;Ool4000AOol0
0`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool4000=Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool4000AOol00`00Oomoo`0@Ool00`00Oomoo`0;Ool40005Ool00`?/Oomo
o`09Ool00`00Oomoo`0@Ool000eoo`03001oogoo00Aoo`030naoogoo00Qoo`03001oogoo00]oo`03
001oogoo019oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00ioo`03
001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo019oo`03001oogoo011oo`03
001oogoo00]oo`03001oogoo00Ioo`030naoogoo00Yoo`03001oogoo00moo`002Goo00D007ooOomo
o`0000Ioo`030naoogoo00Ioo`<000eoo`03001oogoo011oo`<000moo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001o
ogoo011oo`<0011oo`<000eoo`03001oogoo00Ioo`030naoogoo00Ioo`05001oogooOol0000AOol0
00Yoo`<000Moo`030naoogoo00Qoo`03001oogoo00]oo`D0011oo`03001oogoo00ioo`@000aoo`D0
00aoo`03001oogoo00ioo`@000aoo`D0011oo`03001oogoo011oo`03001oogoo00]oo`D000Aoo`03
0naoogoo00Moo`<0019oo`0057oo00<3k7ooOol0GGoo00<007ooOol0GGoo00<3k7ooOol077oo000D
Ool00`?/Oomoo`1MOol00`00Oomoo`1MOol00`?/Oomoo`0LOol001=oo`030naoogoo05ioo`03001o
ogoo05eoo`030naoogoo01aoo`004goo00<3k7ooOol0GWoo00<007ooOol0GGoo00<3k7ooOol077oo
000COol00`?/Oomoo`1NOol00`00Oomoo`1MOol00`?/Oomoo`0AOol20002Ool20005Ool001=oo`03
0naoogoo05ioo`03001oogoo05eoo`030naoogoo019oo`04001oogoo0006Ool000Qoo`/000030n`0
00000;h000030n`0000000X000Uoo`8000Moo`0027oo00<007ooOol00Woo00<007ooOol00goo00<3
k7ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol00Woo00<3k000Ool00goo00<007ooOol00goo00<007ooOol01goo0P001goo0008Ool00`00
Oomoo`08Ool00`?/Oomoo`0=Ool00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00
Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0<Ool00`?/Oomoo`09Ool00`00
Oomoo`06Ool01000Oomoo`001Woo000COol00`?/Oomoo`1NOol00`00Oomoo`1MOol00`?/Oomoo`0A
Ool20002Ool20005Ool001=oo`030naoogoo05ioo`03001oogoo05eoo`030naoogoo01aoo`0057oo
00<3k7ooOol0GGoo00<007ooOol0GGoo00<3k7ooOol077oo000DOol00`?/Oomoo`1MOol00`00Oomo
o`1MOol00`?/Oomoo`0LOol001Aoo`030naoogoo05eoo`03001oogoo05eoo`030naoogoo01aoo`00
57oo00<3k7ooOol0GGoo00<007ooOol0GGoo00<3k7ooOol077oo000DOol00`?/Oomoo`1MOol00`00
Oomoo`1MOol00`?/Oomoo`0LOol001Aoo`030naoogoo05eoo`03001oogoo05eoo`030naoogoo01ao
o`0057oo00<3k7ooOol0GGoo00<007ooOol0GGoo00<3k7ooOol077oo000DOol00`?/Oomoo`1MOol0
0`00Oomoo`1LOol00`?/Oomoo`0MOol001Aoo`030naoogoo05eoo`03001oogoo05aoo`030naoogoo
01eoo`005Goo00<3k7ooOol0G7oo00<007ooOol0G7oo00<3k7ooOol07Goo000EOol00`?/Oomoo`1L
Ool00`00Oomoo`1LOol00`?/Oomoo`0MOol001Eoo`030naoogoo05aoo`03001oogoo05]oo`030nao
ogoo01ioo`005Goo00<3k7ooOol0G7oo00<007ooOol0Fgoo00<3k7ooOol07Woo000EOol00`?/Oomo
o`1LOol00`00Oomoo`1KOol00`?/Oomoo`0NOol001Eoo`030naoogoo05aoo`03001oogoo05]oo`03
0naoogoo01ioo`005Goo00<3k7ooOol0G7oo00<007ooOol0Fgoo00<3k7ooOol07Woo000FOol00`?/
Oomoo`1KOol00`00Oomoo`1JOol00`?/Oomoo`0OOol001Ioo`030naoogoo05]oo`03001oogoo05Yo
o`030naoogoo01moo`005Woo00<3k7ooOol0Fgoo00<007ooOol0FWoo00<3k7ooOol07goo000FOol0
0`?/Oomoo`12Ool40005Ool20005Ool40005Ool00`00Oomoo`1JOol00`?/Oomoo`0OOol001Moo`03
0naoogoo041oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo
009oo`03001oogoo05Uoo`030naoogoo021oo`005goo00<3k7ooOol0@7oo00<007ooOol00Woo00<0
07ooOol03Goo00<007ooOol00Woo00<007ooOol0FGoo00<3k7ooOol087oo000GOol00`?/Oomoo`10
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool2001JOol00`?/Oomoo`0POol001Mo
o`030naoogoo041oo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo05Uoo`030nao
ogoo021oo`0067oo00<3k7ooOol0?goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo
00<007ooOol0F7oo00<3k7ooOol08Goo000HOol00`?/Oomoo`0oOol00`00Oomoo`02Ool00`00Oomo
o`09Ool00`00Oomoo`06Ool00`00Oomoo`1HOol00`?/Oomoo`0QOol001Uoo`030naoogoo03moo`@0
00aoo`D000Aoo`03001oogoo05Qoo`030naoogoo025oo`006Goo00<3k7ooOol0F7oo00<007ooOol0
F7oo00<3k7ooOol08Goo000IOol00`?/Oomoo`1HOol00`00Oomoo`1GOol00`?/Oomoo`0ROol001Yo
o`030naoogoo05Moo`03001oogoo05Moo`030naoogoo029oo`006Woo00<3k7ooOol0Egoo00<007oo
Ool0Egoo00<3k7ooOol08Woo000JOol00`?/Oomoo`1GOol00`00Oomoo`1FOol00`?/Oomoo`0SOol0
01]oo`030naoogoo05Ioo`03001oogoo05Ioo`030naoogoo02=oo`006goo00<3k7ooOol0EWoo00<0
07ooOol0EGoo00<3k7ooOol097oo000LOol00`?/Oomoo`1EOol00`00Oomoo`1EOol00`?/Oomoo`0T
Ool001aoo`030naoogoo05Eoo`03001oogoo05Aoo`030naoogoo02Eoo`0077oo00<3k7ooOol0EGoo
00<007ooOol0E7oo00<3k7ooOol09Goo000MOol00`?/Oomoo`1DOol00`00Oomoo`1COol00`?/Oomo
o`0VOol001eoo`030naoogoo05Aoo`03001oogoo05=oo`030naoogoo02Ioo`007Woo00<3k7ooOol0
Dgoo00<007ooOol0DWoo00<3k7ooOol09goo000NOol00`?/Oomoo`1COol00`00Oomoo`1BOol00`?/
Oomoo`0WOol001moo`030naoogoo059oo`03001oogoo055oo`030naoogoo02Qoo`0087oo00<3k7oo
Ool0DGoo00<007ooOol0DGoo00<3k7ooOol0:7oo000POol00`?/Oomoo`1AOol00`00Oomoo`1@Ool0
0`?/Oomoo`0YOol0025oo`030naoogoo051oo`03001oogoo051oo`030naoogoo02Uoo`008Goo00<3
k7ooOol0D7oo00<007ooOol0Cgoo00<3k7ooOol0:Woo000ROol00`?/Oomoo`16Ool50004Ool00`00
Oomoo`1?Ool00`?/Oomoo`0ZOol002=oo`030naoogoo04Moo`03001oogoo00Aoo`03001oogoo04io
o`030naoogoo02]oo`008goo00<3k7ooOol0Agoo00<007ooOol017oo00<007ooOol0CWoo00<3k7oo
Ool0:goo000TOol00`?/Oomoo`16Ool00`00Oomoo`04Ool2001>Ool00`?/Oomoo`0/Ool002Eoo`03
0naoogoo04Eoo`03001oogoo00Aoo`03001oogoo04aoo`030naoogoo02eoo`009Woo00<3k7ooOol0
A7oo00<007ooOol017oo00<007ooOol0Bgoo00<3k7ooOol0;Woo000VOol00`?/Oomoo`12Ool30006
Ool00`00Oomoo`1;Ool00`?/Oomoo`0^Ool002Moo`030naoogoo04=oo`03001oogoo00Aoo`03001o
ogoo04Yoo`030naoogoo02moo`00:7oo00<3k7ooOol0BGoo00<007ooOol0BGoo00<3k7ooOol0<7oo
000XOol00`?/Oomoo`19Ool00`00Oomoo`18Ool00`?/Oomoo`0aOol002Uoo`030naoogoo04Qoo`03
001oogoo04Moo`030naoogoo039oo`00:Woo00<3k7ooOol0Agoo00<007ooOol0Agoo00<3k7ooOol0
<Woo000[Ool00`?/Oomoo`16Ool00`00Oomoo`16Ool00`?/Oomoo`0cOol002]oo`030naoogoo04Io
o`03001oogoo04Eoo`030naoogoo03Aoo`00;7oo00<3k7ooOol0AGoo00<007ooOol0A7oo00<3k7oo
Ool0=Goo000]Ool00`?/Oomoo`14Ool00`00Oomoo`13Ool00`?/Oomoo`0fOol002ioo`030naoogoo
04=oo`03001oogoo049oo`030naoogoo03Moo`00;goo0P?/@goo00<007ooOol0@Goo00<3k7ooOol0
>7oo000aOol00`?/Oomoo`10Ool00`00Oomoo`10Ool00`?/Oomoo`0iOol0039oo`030naoogoo03mo
o`03001oogoo03moo`030naoogoo03Yoo`00<goo00<3k7ooOol0?Woo00<007ooOol0?Woo00<3k7oo
Ool0>goo000dOol00`?/Oomoo`0mOol00`00Oomoo`0mOol00`?/Oomoo`0lOol003Eoo`030naoogoo
03aoo`03001oogoo03aoo`030naoogoo03eoo`00=Woo0P?/?7oo00<007ooOol0>Woo0P?/@7oo000h
Ool00`?/Oomoo`0iOol00`00Oomoo`0iOol00`?/Oomoo`10Ool003Uoo`030naoogoo03Qoo`03001o
ogoo03Qoo`030naoogoo045oo`00>Woo00<3k7ooOol0=goo00<007ooOol0=goo00<3k7ooOol0@Woo
000kOol20n`NOol50004Ool20005Ool40005Ool00`00Oomoo`0eOol20na5Ool003eoo`030naoogoo
01eoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo03Aoo`03
0naoogoo04Eoo`00?Woo00<3k7ooOol077oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0
<Woo0P?/B7oo000oOol20n`LOol00`00Oomoo`0?Ool00`00Oomoo`02Ool2000aOol20na:Ool0045o
o`030naoogoo01Uoo`03001oogoo00]oo`@000Eoo`03001oogoo02moo`030naoogoo04Yoo`00@Woo
0P?/6Goo00<007ooOol02goo00<007ooOol01Woo00<007ooOol0;Goo0P?/CGoo0014Ool00`?/Oomo
o`0DOol3000=Ool00`00Oomoo`06Ool00`00Oomoo`0/Ool00`?/Oomoo`1=Ool004Eoo`83k1Ioo`03
001oogoo00]oo`D000Aoo`03001oogoo02]oo`030naoogoo04ioo`00Agoo0P?/:goo00<007ooOol0
:Goo0P?/DGoo0019Ool20n`YOol00`00Oomoo`0WOol20naCOol004]oo`83k2Moo`03001oogoo02Eo
o`83k5Eoo`00CGoo0`?/97oo00<007ooOol08Woo0`?/Egoo001@Ool30n`QOol00`00Oomoo`0OOol3
0naJOol005=oo`83k1moo`03001oogoo01aoo`<3k5eoo`00EGoo0`?/77oo00<007ooOol06Goo0`?/
H7oo001HOol40n`HOol00`00Oomoo`0EOol40naSOol005aoo`@3k1Aoo`03001oogoo015oo`@3k6Mo
o`00H7oo1`?/3Goo00<007ooOol02goo1P?/Jgoo001WOol90n`4Ool00`00Oomoo`02Ool90naaOol0
071oo`T3k7Yoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001ZOol50005Ool00`00Oomoo`1lOol006Yoo`05001oogooOol00005Ool00`00Oomo
o`1lOol006]oo`03001oogoo00Ioo`03001oogoo07aoo`00K7oo00<007ooOol01Goo0P00OGoo001]
Ool00`00Oomoo`23Ool006ioo`03001oogoo089oo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo0`00
QGoo003cOol00?=oo`00lgoo003cOol009Eoo`<000]oo`D000Aoo`8000Moo`<003]oo`00U7oo00H0
07ooOomoo`00Ool60005Ool00`00Oomoo`04Ool20008Ool00`00Oomoo`0jOol007=oo`800003Ool0
000001aoo`03001oogoo00ioo`03001oogoo00ioo`03001oogoo03Yoo`00LWoo00<007ooOol00P00
7Goo00<007ooOol00goo1P001Goo00<007ooOol02Woo1P00>goo001bOol01@00Oomoogoo00007Goo
00<007ooOol03Woo00<007ooOol02goo00@007ooOol003aoo`00LWoo00D007ooOomoo`0001aoo`D0
00eoo`03001oogoo00]oo`04001oogoo000lOol0079oo`05001oogooOol0000MOol00`00Oomoo`0<
Ool3000>Ool00`00Ool0000lOol0075oo`80009oo`8002ioo`03001oogoo00eoo`8003aoo`00lgoo
003cOol00?=oo`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.35) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .1 r

.5 Mabswid

.06339 .49991 m

.06526 .45971 L

.07083 .41977 L

.08006 .38052 L

.09288 .34228 L

.10917 .30539 L

.12879 .27016 L

.15158 .23689 L

.17734 .20586 L

.20586 .17734 L

.23689 .15158 L

.27016 .12879 L

.30539 .10917 L

.34228 .09288 L

.38052 .08006 L

.41977 .07083 L

.45972 .06526 L

.5 .06339 L

.54028 .06526 L

.58023 .07083 L

.61948 .08006 L

.65772 .09288 L

.69461 .10917 L

.72984 .12879 L

.76311 .15158 L

.79414 .17734 L

.82266 .20586 L

.84842 .23689 L

.87121 .27016 L

.89083 .30539 L

.90712 .34228 L

.91994 .38052 L

.92917 .41977 L

.93474 .45971 L

.93661 .49991 L

s

.06339 .50009 m

.06526 .54029 L

.07083 .58023 L

.08006 .61948 L

.09288 .65772 L

.10917 .69461 L

.12879 .72984 L

.15158 .76311 L

.17734 .79414 L

.20586 .82266 L

.23689 .84842 L

.27016 .87121 L

.30539 .89083 L

.34228 .90712 L

.38052 .91994 L

.41977 .92917 L

.45972 .93474 L

.5 .93661 L

.54028 .93474 L

.58023 .92917 L

.61948 .91994 L

.65772 .90712 L

.69461 .89083 L

.72984 .87121 L

.76311 .84842 L

.79414 .82266 L

.82266 .79414 L

.84842 .76311 L

.87121 .72984 L

.89083 .69461 L

.90712 .65772 L

.91994 .61948 L

.92917 .58023 L

.93474 .54029 L

.93661 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol006UooaH3hWAoo`00IGoo10?R
2goo00<007ooOol027oo10?RL7oo001QOol40n8?Ool00`00Oomoo`0<Ool40n9/Ool005eoo`@3hQ=o
o`03001oogoo011oo`@3hVQoo`00FGoo10?R5goo00<007ooOol057oo1@?RHgoo001EOol40n8KOol0
0`00Oomoo`0IOol40n9OOol0059oo`<3hQmoo`03001oogoo01eoo`<3hUaoo`00D7oo0P?R8Woo00<0
07ooOol087oo0P?RFWoo001>Ool20n8TOol00`00Oomoo`0ROol20n9HOol004aoo`83hRIoo`03001o
ogoo02Aoo`83hUIoo`00BWoo0P?R3goo1@0017oo0P001Goo10001Goo00<007ooOol09Woo0P?RE7oo
0018Ool20n8COol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`0XOol20n9BOol004Ioo`83hQEoo`03001oogoo00moo`03001oogoo009oo`03001oogoo02Yoo`83
hU1oo`00A7oo0P?R37oo1P001Goo00<007ooOol03goo00<007ooOol00Woo0P00;Goo0P?RCWoo0012
Ool20n8IOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`0^Ool00`?ROomoo`1;Ool0041oo`83hQ]o
o`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo02moo`83hT]oo`00?goo00<3hWooOol06Goo
0`003Goo00<007ooOol01Woo00<007ooOol0<Goo00<3hWooOol0B7oo000nOol00`?ROomoo`0LOol0
0`00Oomoo`0;Ool50004Ool00`00Oomoo`0bOol00`?ROomoo`17Ool003aoo`83hSIoo`03001oogoo
03=oo`83hTMoo`00>goo00<3hWooOol0=Woo00<007ooOol0=Goo00<3hWooOol0A7oo000jOol00`?R
Oomoo`0gOol00`00Oomoo`0fOol00`?ROomoo`13Ool003Uoo`030n9oogoo03Qoo`03001oogoo03Mo
o`030n9oogoo049oo`00=goo0P?R>goo00<007ooOol0>7oo0P?R@Woo000fOol00`?ROomoo`0kOol0
0`00Oomoo`0jOol00`?ROomoo`0oOol003Eoo`030n9oogoo03aoo`03001oogoo03]oo`030n9oogoo
03ioo`00=7oo00<3hWooOol0?Goo00<007ooOol0?7oo00<3hWooOol0?Goo000cOol00`?ROomoo`0n
Ool00`00Oomoo`0mOol00`?ROomoo`0lOol0039oo`030n9oogoo03moo`03001oogoo03ioo`030n9o
ogoo03]oo`00<Goo00<3hWooOol0@7oo00<007ooOol0?goo00<3hWooOol0>Woo000`Ool00`?ROomo
o`11Ool00`00Oomoo`10Ool00`?ROomoo`0iOol002moo`030n9oogoo049oo`03001oogoo045oo`03
0n9oogoo03Qoo`00;Woo00<3hWooOol0@goo00<007ooOol0@Woo00<3hWooOol0=goo000]Ool00`?R
Oomoo`14Ool00`00Oomoo`13Ool00`?ROomoo`0fOol002aoo`030n9oogoo04Eoo`03001oogoo04Ao
o`030n9oogoo03Eoo`00:goo00<3hWooOol0AWoo00<007ooOol0AGoo00<3hWooOol0=7oo000[Ool0
0`?ROomoo`16Ool00`00Oomoo`16Ool00`?ROomoo`0cOol002Yoo`030n9oogoo04Moo`03001oogoo
04Moo`030n9oogoo039oo`00:Goo00<3hWooOol0?goo1@0017oo00<007ooOol0B7oo00<3hWooOol0
<Goo000XOol00`?ROomoo`12Ool00`00Oomoo`04Ool00`00Oomoo`19Ool00`?ROomoo`0`Ool002Qo
o`030n9oogoo049oo`03001oogoo00Aoo`03001oogoo04Uoo`030n9oogoo031oo`009goo00<3hWoo
Ool0>7oo1P001Goo00<007ooOol017oo0P00Bgoo00<3hWooOol0;goo000VOol00`?ROomoo`14Ool0
0`00Oomoo`04Ool00`00Oomoo`1;Ool00`?ROomoo`0^Ool002Ioo`030n9oogoo04Aoo`03001oogoo
00Aoo`03001oogoo04]oo`030n9oogoo02ioo`009Goo00<3hWooOol0@goo0`001Woo00<007ooOol0
C7oo00<3hWooOol0;Goo000UOol00`?ROomoo`15Ool00`00Oomoo`04Ool00`00Oomoo`1<Ool00`?R
Oomoo`0]Ool002Aoo`030n9oogoo04eoo`03001oogoo04eoo`030n9oogoo02aoo`008goo00<3hWoo
Ool0CWoo00<007ooOol0CWoo00<3hWooOol0:goo000SOol00`?ROomoo`1>Ool00`00Oomoo`1>Ool0
0`?ROomoo`0[Ool0029oo`030n9oogoo04moo`03001oogoo04moo`030n9oogoo02Yoo`008Goo00<3
hWooOol0D7oo00<007ooOol0Cgoo00<3hWooOol0:Woo000POol00`?ROomoo`1AOol00`00Oomoo`1@
Ool00`?ROomoo`0YOol0021oo`030n9oogoo055oo`03001oogoo051oo`030n9oogoo02Uoo`007goo
00<3hWooOol0DWoo00<007ooOol0DGoo00<3hWooOol0:7oo000OOol00`?ROomoo`1BOol00`00Oomo
o`1AOol00`?ROomoo`0XOol001ioo`030n9oogoo05=oo`03001oogoo059oo`030n9oogoo02Moo`00
7Woo00<3hWooOol0Dgoo00<007ooOol0DWoo00<3hWooOol09goo000MOol00`?ROomoo`1DOol00`00
Oomoo`1COol00`?ROomoo`0VOol001eoo`030n9oogoo05Aoo`03001oogoo05=oo`030n9oogoo02Io
o`007Goo00<3hWooOol0E7oo00<007ooOol0Dgoo00<3hWooOol09Woo000LOol00`?ROomoo`1EOol0
0`00Oomoo`1DOol00`?ROomoo`0UOol001aoo`030n9oogoo05Eoo`03001oogoo05Aoo`030n9oogoo
02Eoo`0077oo00<3hWooOol0EGoo00<007ooOol0E7oo00<3hWooOol09Goo000KOol00`?ROomoo`1F
Ool00`00Oomoo`1EOol00`?ROomoo`0TOol001]oo`030n9oogoo05Ioo`03001oogoo05Eoo`030n9o
ogoo02Aoo`006Woo00<3hWooOol0?Woo10001Goo0P001Goo10001Goo00<007ooOol0EWoo00<3hWoo
Ool08goo000JOol00`?ROomoo`0mOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`1FOol00`?ROomoo`0SOol001Yoo`030n9oogoo03eoo`03
001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo05Ioo`030n9oogoo02=oo`00
6Goo00<3hWooOol0=Woo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00
F7oo00<3hWooOol08Woo000IOol00`?ROomoo`0nOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005
Ool00`00Oomoo`1GOol00`?ROomoo`0ROol001Uoo`030n9oogoo03ioo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo00Ioo`03001oogoo05Moo`030n9oogoo029oo`006Goo00<3hWooOol0?Woo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0Egoo00<3hWooOol08Woo
000HOol00`?ROomoo`10Ool4000<Ool50004Ool00`00Oomoo`1HOol00`?ROomoo`0QOol001Qoo`03
0n9oogoo05Uoo`03001oogoo05Qoo`030n9oogoo025oo`0067oo00<3hWooOol0FGoo00<007ooOol0
F7oo00<3hWooOol08Goo000HOol00`?ROomoo`1IOol00`00Oomoo`1HOol00`?ROomoo`0QOol001Mo
o`030n9oogoo05Yoo`03001oogoo05Uoo`030n9oogoo021oo`005goo00<3hWooOol0FWoo00<007oo
Ool0FGoo00<3hWooOol087oo000GOol00`?ROomoo`1JOol00`00Oomoo`1IOol00`?ROomoo`0POol0
01Moo`030n9oogoo05Yoo`03001oogoo05Uoo`030n9oogoo021oo`005goo00<3hWooOol0FWoo00<0
07ooOol0FGoo00<3hWooOol087oo0009Ool50009Ool00`?ROomoo`03Ool50004Ool20005Ool4000?
Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool5000>
Ool50004Ool20005Ool400000goo0n9oo`0;Ool5000AOol000Uoo`05001oogooOol00009Ool00`?R
Oomoo`05Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>
Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`000n9oo`0;Ool01@00
Oomoogoo00004Goo000:Ool00`00Oomoo`09Ool00`?ROomoo`06Ool00`00Oomoo`0?Ool00`00Oomo
o`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomo
o`0?Ool00`00Ool3hP0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Ioo`80
00040n8000000005Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool60005Ool00`00Oomoo`05Ool60002
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02
Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0?Ool00`00Ool3hP0=
Ool00`00Oomoo`0AOol000aoo`03001oogoo00Moo`030n9oogoo00Ioo`03001oogoo00]oo`@0015o
o`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@000eoo`03001oogoo00eoo`03001o
ogoo009oo`03001oogoo00Uoo`@0015oo`03001oogoo011oo`03001oogoo00]oo`@0009oo`030n9o
ogoo00aoo`03001oogoo011oo`003Goo00<007ooOol01Woo00<3hWooOol01Woo00<007ooOol02goo
00<007ooOol04Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol04Woo00<007ooOol047oo
00<007ooOol02goo00<007ooOol00goo00<3hWooOol03Goo00<007ooOol03goo0009Ool01@00Oomo
ogoo000027oo00<3hWooOol017oo0`003Goo00<007ooOol047oo0`003goo00<007ooOol00Woo00<0
07ooOol02Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol047oo0`0047oo0`003Goo00<007ooOol00goo00<3hWooOol02Goo00D007ooOomoo`00015o
o`002Woo0`002Goo00<3hWooOol01Woo00<007ooOol02goo1@0047oo00<007ooOol03Woo100037oo
1@0037oo00<007ooOol03Woo100037oo1@0047oo00<007ooOol047oo00<007ooOol02goo1@0000=o
o`?ROol02goo0`004Woo000FOol00`?ROomoo`1KOol00`00Oomoo`1JOol00`?ROomoo`0OOol001Io
o`030n9oogoo05]oo`03001oogoo05Yoo`030n9oogoo01moo`005Woo00<3hWooOol0Fgoo00<007oo
Ool0Fgoo00<3hWooOol07Woo000FOol00`?ROomoo`1KOol00`00Oomoo`1KOol00`?ROomoo`0NOol0
01Ioo`030n9oogoo05]oo`03001oogoo05]oo`030n9oogoo01=oo`80009oo`8000Eoo`005Woo00<3
hWooOol0Fgoo00<007ooOol0Fgoo00<3hWooOol057oo00@007ooOol000Ioo`0027oo3P0000<3hP00
0000^@0000<3hP00000030002Goo0P001goo0008Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01P00
Oomoo`?ROol000Aoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`04001oogoo0n82
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`07Ool20007Ool000Qoo`03001oogoo00]o
o`030n9oogoo00Yoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qo
o`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo00Yoo`030n9oogoo00]oo`03001oogoo00Io
o`04001oogoo0006Ool001Ioo`030n9oogoo05]oo`03001oogoo05]oo`030n9oogoo01=oo`80009o
o`8000Eoo`005Woo00<3hWooOol0Fgoo00<007ooOol0Fgoo00<3hWooOol07Woo000FOol00`?ROomo
o`1KOol00`00Oomoo`1JOol00`?ROomoo`0OOol001Ioo`030n9oogoo05]oo`03001oogoo05Yoo`03
0n9oogoo01moo`005Woo00<3hWooOol0Fgoo00<007ooOol0FWoo00<3hWooOol07goo000FOol00`?R
Oomoo`1KOol00`00Oomoo`1JOol00`?ROomoo`0OOol001Ioo`030n9oogoo05]oo`03001oogoo05Yo
o`030n9oogoo01moo`005Woo00<3hWooOol0Fgoo00<007ooOol0FWoo00<3hWooOol07goo000FOol0
0`?ROomoo`1KOol00`00Oomoo`1JOol00`?ROomoo`0OOol001Ioo`030n9oogoo05]oo`03001oogoo
05Yoo`030n9oogoo01moo`005goo00<3hWooOol0FWoo00<007ooOol0FGoo00<3hWooOol087oo000G
Ool00`?ROomoo`1JOol00`00Oomoo`1IOol00`?ROomoo`0POol001Moo`030n9oogoo05Yoo`03001o
ogoo05Uoo`030n9oogoo021oo`005goo00<3hWooOol0FWoo00<007ooOol0FGoo00<3hWooOol087oo
000GOol00`?ROomoo`1JOol00`00Oomoo`1IOol00`?ROomoo`0POol001Moo`030n9oogoo05Yoo`03
001oogoo05Uoo`030n9oogoo021oo`005goo00<3hWooOol0FWoo00<007ooOol0FGoo00<3hWooOol0
87oo000HOol00`?ROomoo`1IOol00`00Oomoo`1HOol00`?ROomoo`0QOol001Qoo`030n9oogoo05Uo
o`03001oogoo05Qoo`030n9oogoo025oo`0067oo00<3hWooOol0FGoo00<007ooOol0F7oo00<3hWoo
Ool08Goo000HOol00`?ROomoo`1IOol00`00Oomoo`1HOol00`?ROomoo`0QOol001Uoo`030n9oogoo
03moo`@000Eoo`8000Eoo`@000Eoo`03001oogoo05Moo`030n9oogoo029oo`006Goo00<3hWooOol0
?Woo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol0Egoo00<3hWooOol08Woo000IOol00`?ROomoo`0nOol00`00Oomoo`02Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`1GOol00`?ROomoo`0ROol001Uoo`030n9oogoo03ioo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo009oo`8005Qoo`030n9oogoo029oo`006Woo00<3hWoo
Ool0?Goo00<007ooOol00Woo00<007ooOol02Goo10001Goo00<007ooOol0EWoo00<3hWooOol08goo
000JOol00`?ROomoo`0mOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomo
o`1FOol00`?ROomoo`0SOol001]oo`030n9oogoo03aoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Ioo`03001oogoo05Eoo`030n9oogoo02Aoo`006goo00<3hWooOol0?Goo100037oo1@00
17oo00<007ooOol0EGoo00<3hWooOol097oo000KOol00`?ROomoo`1FOol00`00Oomoo`1EOol00`?R
Oomoo`0TOol001aoo`030n9oogoo05Eoo`03001oogoo05Aoo`030n9oogoo02Eoo`0077oo00<3hWoo
Ool0EGoo00<007ooOol0E7oo00<3hWooOol09Goo000LOol00`?ROomoo`1EOol00`00Oomoo`1DOol0
0`?ROomoo`0UOol001eoo`030n9oogoo05Aoo`03001oogoo05=oo`030n9oogoo02Ioo`007Goo00<3
hWooOol0E7oo00<007ooOol0Dgoo00<3hWooOol09Woo000NOol00`?ROomoo`1COol00`00Oomoo`1B
Ool00`?ROomoo`0WOol001ioo`030n9oogoo05=oo`03001oogoo059oo`030n9oogoo02Moo`007Woo
00<3hWooOol0Dgoo00<007ooOol0DWoo00<3hWooOol09goo000OOol00`?ROomoo`1BOol00`00Oomo
o`1AOol00`?ROomoo`0XOol001moo`030n9oogoo059oo`03001oogoo055oo`030n9oogoo02Qoo`00
87oo00<3hWooOol0DGoo00<007ooOol0D7oo00<3hWooOol0:Goo000POol00`?ROomoo`1AOol00`00
Oomoo`1@Ool00`?ROomoo`0YOol0025oo`030n9oogoo051oo`03001oogoo04moo`030n9oogoo02Yo
o`008Woo00<3hWooOol0Cgoo00<007ooOol0Cgoo00<3hWooOol0:Woo000ROol00`?ROomoo`1?Ool0
0`00Oomoo`1>Ool00`?ROomoo`0[Ool002=oo`030n9oogoo04ioo`03001oogoo04ioo`030n9oogoo
02]oo`008goo00<3hWooOol0CWoo00<007ooOol0CGoo00<3hWooOol0;7oo000TOol00`?ROomoo`1=
Ool00`00Oomoo`1=Ool00`?ROomoo`0/Ool002Eoo`030n9oogoo04=oo`D000Aoo`03001oogoo04ao
o`030n9oogoo02eoo`009Goo00<3hWooOol0AGoo00<007ooOol017oo00<007ooOol0C7oo00<3hWoo
Ool0;Goo000VOol00`?ROomoo`14Ool00`00Oomoo`04Ool00`00Oomoo`1;Ool00`?ROomoo`0^Ool0
02Moo`030n9oogoo04=oo`03001oogoo00Aoo`8004]oo`030n9oogoo02moo`00:7oo00<3hWooOol0
@Woo00<007ooOol017oo00<007ooOol0BGoo00<3hWooOol0<7oo000XOol00`?ROomoo`12Ool00`00
Oomoo`04Ool00`00Oomoo`19Ool00`?ROomoo`0`Ool002Uoo`030n9oogoo03moo`<000Ioo`03001o
ogoo04Qoo`030n9oogoo035oo`00:Woo00<3hWooOol0@7oo00<007ooOol017oo00<007ooOol0Agoo
00<3hWooOol0<Woo000ZOol00`?ROomoo`17Ool00`00Oomoo`16Ool00`?ROomoo`0cOol002]oo`03
0n9oogoo04Ioo`03001oogoo04Eoo`030n9oogoo03Aoo`00;7oo00<3hWooOol0AGoo00<007ooOol0
AGoo00<3hWooOol0=7oo000]Ool00`?ROomoo`14Ool00`00Oomoo`14Ool00`?ROomoo`0eOol002eo
o`030n9oogoo04Aoo`03001oogoo04=oo`030n9oogoo03Ioo`00;Woo00<3hWooOol0@goo00<007oo
Ool0@Woo00<3hWooOol0=goo000_Ool00`?ROomoo`12Ool00`00Oomoo`11Ool00`?ROomoo`0hOol0
031oo`030n9oogoo045oo`03001oogoo041oo`030n9oogoo03Uoo`00<Goo00<3hWooOol0@7oo00<0
07ooOol0?goo00<3hWooOol0>Woo000bOol00`?ROomoo`0oOol00`00Oomoo`0nOol00`?ROomoo`0k
Ool003=oo`030n9oogoo03ioo`03001oogoo03eoo`030n9oogoo03aoo`00=7oo00<3hWooOol0?Goo
00<007ooOol0?7oo00<3hWooOol0?Goo000eOol20n8mOol00`00Oomoo`0jOol20n90Ool003Moo`03
0n9oogoo03Yoo`03001oogoo03Uoo`030n9oogoo041oo`00>7oo00<3hWooOol0>Goo00<007ooOol0
>7oo00<3hWooOol0@Goo000iOol20n8iOol00`00Oomoo`0fOol20n94Ool003]oo`030n9oogoo03Io
o`03001oogoo03Eoo`030n9oogoo04Aoo`00?7oo0P?R=Woo00<007ooOol0<goo0P?RAgoo000nOol0
0`?ROomoo`0cOol00`00Oomoo`0bOol00`?ROomoo`17Ool003moo`030n9oogoo01Uoo`D000Aoo`80
00Eoo`@000Eoo`03001oogoo035oo`030n9oogoo04Qoo`00@7oo0P?R6goo00<007ooOol017oo0P00
17oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0;goo0P?RBgoo0012Ool00`?ROomoo`0H
Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool00`00Oomoo`0^Ool00`?ROomoo`1;Ool004=oo`83hQQo
o`03001oogoo00moo`03001oogoo009oo`8002eoo`83hTioo`00AGoo0P?R5Woo00<007ooOol02goo
10001Goo00<007ooOol0:Woo0P?RD7oo0017Ool20n8DOol00`00Oomoo`0;Ool00`00Oomoo`06Ool0
0`00Oomoo`0XOol20n9BOol004Uoo`83hQ1oo`<000eoo`03001oogoo00Ioo`03001oogoo02Moo`03
0n9oogoo059oo`00Bgoo0P?R47oo00<007ooOol02goo1@0017oo00<007ooOol09Goo0P?REGoo001=
Ool20n8UOol00`00Oomoo`0SOol20n9GOol004moo`83hR=oo`03001oogoo025oo`83hUUoo`00DGoo
0`?R87oo00<007ooOol07Woo0`?RFgoo001DOol20n8NOol00`00Oomoo`0KOol30n9NOol005Ioo`<3
hQ]oo`03001oogoo01Qoo`<3hV5oo`00FGoo0`?R67oo00<007ooOol05Goo0`?RI7oo001LOol40n8D
Ool00`00Oomoo`0AOol40n9WOol0061oo`L3hPeoo`03001oogoo00Yoo`L3hV]oo`00Igoo6P?RLWoo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol006Yoo`D000Eo
o`03001oogoo07aoo`00JWoo00D007ooOomoo`0000Eoo`03001oogoo07aoo`00Jgoo00<007ooOol0
1Woo00<007ooOol0O7oo001/Ool00`00Oomoo`05Ool2001mOol006eoo`03001oogoo08=oo`00KWoo
00<007ooOol0PWoo001ZOol01@00Oomoogoo0000Q7oo001[Ool30025Ool00?=oo`00lgoo003cOol0
0?=oo`00TGoo0`002goo1@0017oo0P001Goo0`001Goo1000>7oo002@Ool01P00Oomoogoo001oo`H0
00Eoo`03001oogoo00Aoo`8000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool00`00Oomoo`0e
Ool007=oo`800003Ool0000001Qoo`03001oogoo00ioo`03001oogoo00ioo`03001oogoo00Ioo`03
001oogoo03Eoo`00LWoo00<007ooOol00P006Goo00<007ooOol00goo1P001Goo00<007ooOol03Woo
00<007ooOol01Woo00<007ooOol0=Goo001bOol01@00Oomoogoo00006Goo00<007ooOol03Woo00<0
07ooOol037oo0P001Goo1000>7oo001bOol01@00Oomoogoo000067oo1@003Goo00<007ooOol03Woo
00<007ooOol00Woo00<007ooOol0>Goo001bOol01@00Oomoogoo00006Goo00<007ooOol037oo0`00
37oo00D007ooOomoo`0000Aoo`03001oogoo03Uoo`00LGoo0P000Woo0P00:Woo00<007ooOol02goo
0`001Goo1@00=goo003cOol00?=oo`00lgoo003cOol00?=oo`00\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.3) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.2 1 0 r

.5 Mabswid

.07427 .49991 m

.07608 .46072 L

.08151 .42177 L

.09052 .38349 L

.10301 .34621 L

.1189 .31023 L

.13803 .27588 L

.16026 .24344 L

.18538 .21318 L

.21318 .18538 L

.24344 .16026 L

.27588 .13803 L

.31023 .1189 L

.34621 .10301 L

.38349 .09052 L

.42177 .08151 L

.46072 .07608 L

.5 .07427 L

.53928 .07608 L

.57823 .08151 L

.61651 .09052 L

.65379 .10301 L

.68977 .1189 L

.72412 .13803 L

.75656 .16026 L

.78682 .18538 L

.81462 .21318 L

.83974 .24344 L

.86197 .27588 L

.8811 .31023 L

.89699 .34621 L

.90948 .38349 L

.91849 .42177 L

.92392 .46072 L

.92573 .49991 L

s

.07427 .50009 m

.07608 .53928 L

.08151 .57823 L

.09052 .61651 L

.10301 .65379 L

.1189 .68977 L

.13803 .72412 L

.16026 .75656 L

.18538 .78682 L

.21318 .81462 L

.24344 .83974 L

.27588 .86197 L

.31023 .8811 L

.34621 .89699 L

.38349 .90948 L

.42177 .91849 L

.46072 .92392 L

.5 .92573 L

.53928 .92392 L

.57823 .91849 L

.61651 .90948 L

.65379 .89699 L

.68977 .8811 L

.72412 .86197 L

.75656 .83974 L

.78682 .81462 L

.81462 .78682 L

.83974 .75656 L

.86197 .72412 L

.8811 .68977 L

.89699 .65379 L

.90948 .61651 L

.91849 .57823 L

.92392 .53928 L

.92573 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001`Ool85n1kOol006Qoo`PGh0Aoo`04001oogooOol95n1bOol0069oo`HG
h0aoo`03001oogoo00Yoo`HGh6aoo`00GWoo11OP4Woo00<007ooOol047oo11OPJ7oo001JOol45n0F
Ool00`00Oomoo`0DOol45n1TOol005Qoo`8Gh1Yoo`03001oogoo01Qoo`8Gh69oo`00EGoo0aOP77oo
00<007ooOol06Woo0aOPGgoo001BOol35n0OOol00`00Oomoo`0MOol35n1LOol0051oo`8Gh0Uoo`D0
00Aoo`8000Eoo`@000Eoo`03001oogoo021oo`8Gh5Yoo`00CGoo0aOP3Goo00<007ooOol017oo0P00
17oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol08Woo0aOPEgoo001;Ool25n0@Ool00`00
Oomoo`0?Ool00`00Oomoo`02Ool00`00Oomoo`0UOol25n1EOol004Uoo`8Gh0Moo`H000Eoo`03001o
ogoo00moo`03001oogoo009oo`8002Qoo`8Gh5=oo`00Agoo0QOP57oo00<007ooOol02goo10001Goo
00<007ooOol0:Goo0QOPDGoo0015Ool25n0FOol00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomo
o`0[Ool25n1?Ool004=oo`8Gh1Ioo`<000eoo`03001oogoo00Ioo`03001oogoo02eoo`035n1oogoo
04aoo`00@Goo0QOP6Woo00<007ooOol02goo1@0017oo00<007ooOol0;Woo0QOPC7oo0010Ool00aOP
Oomoo`0aOol00`00Oomoo`0`Ool00aOPOomoo`19Ool003moo`035n1oogoo039oo`03001oogoo035o
o`035n1oogoo04Qoo`00?Goo0QOP=Goo00<007ooOol0<Woo0QOPB7oo000lOol00aOPOomoo`0eOol0
0`00Oomoo`0dOol00aOPOomoo`15Ool003]oo`035n1oogoo03Ioo`03001oogoo03Eoo`8Gh4Eoo`00
>Woo00<Gh7ooOol0=goo00<007ooOol0=goo00<Gh7ooOol0@Woo000hOol25n0jOol00`00Oomoo`0h
Ool00aOPOomoo`11Ool003Moo`035n1oogoo03Yoo`03001oogoo03Uoo`8Gh45oo`00=Woo00<Gh7oo
Ool0>goo00<007ooOol0>goo00<Gh7ooOol0?Woo000eOol00aOPOomoo`0lOol00`00Oomoo`0lOol0
0aOPOomoo`0mOol003Aoo`035n1oogoo03eoo`03001oogoo03eoo`035n1oogoo03aoo`00<goo00<G
h7ooOol0?Woo00<007ooOol0?Woo00<Gh7ooOol0>goo000bOol00aOPOomoo`0oOol00`00Oomoo`0o
Ool00aOPOomoo`0jOol0035oo`035n1oogoo041oo`03001oogoo041oo`035n1oogoo03Uoo`00<7oo
00<Gh7ooOol0@Goo00<007ooOol0@Goo00<Gh7ooOol0>7oo000_Ool00aOPOomoo`12Ool00`00Oomo
o`12Ool00aOPOomoo`0gOol002ioo`035n1oogoo04=oo`03001oogoo049oo`035n1oogoo03Moo`00
;Goo00<Gh7ooOol0A7oo00<007ooOol0@goo00<Gh7ooOol0=Woo000]Ool00aOPOomoo`14Ool00`00
Oomoo`14Ool00aOPOomoo`0eOol002aoo`035n1oogoo03aoo`D000Aoo`03001oogoo04Eoo`035n1o
ogoo03Aoo`00:goo00<Gh7ooOol0?goo00<007ooOol017oo00<007ooOol0AGoo00<Gh7ooOol0=7oo
000ZOol00aOPOomoo`10Ool00`00Oomoo`04Ool00`00Oomoo`16Ool00aOPOomoo`0cOol002Uoo`03
5n1oogoo03Ioo`H000Eoo`03001oogoo00Aoo`8004Qoo`035n1oogoo039oo`00:Goo00<Gh7ooOol0
@Goo00<007ooOol017oo00<007ooOol0Agoo00<Gh7ooOol0<Woo000XOol00aOPOomoo`12Ool00`00
Oomoo`04Ool00`00Oomoo`18Ool00aOPOomoo`0aOol002Qoo`035n1oogoo041oo`<000Ioo`03001o
ogoo04Uoo`035n1oogoo031oo`009goo00<Gh7ooOol0@goo00<007ooOol017oo00<007ooOol0BWoo
00<Gh7ooOol0;goo000WOol00aOPOomoo`1:Ool00`00Oomoo`1:Ool00aOPOomoo`0_Ool002Ioo`03
5n1oogoo04]oo`03001oogoo04]oo`035n1oogoo02ioo`009Goo00<Gh7ooOol0C7oo00<007ooOol0
C7oo00<Gh7ooOol0;Goo000UOol00aOPOomoo`1<Ool00`00Oomoo`1<Ool00aOPOomoo`0]Ool002Ao
o`035n1oogoo04eoo`03001oogoo04eoo`035n1oogoo02aoo`0097oo00<Gh7ooOol0CGoo00<007oo
Ool0CGoo00<Gh7ooOol0;7oo000SOol00aOPOomoo`1>Ool00`00Oomoo`1>Ool00aOPOomoo`0[Ool0
02=oo`035n1oogoo04ioo`03001oogoo04ioo`035n1oogoo02]oo`008Woo00<Gh7ooOol0Cgoo00<0
07ooOol0Cgoo00<Gh7ooOol0:Woo000QOol00aOPOomoo`1@Ool00`00Oomoo`1?Ool00aOPOomoo`0Z
Ool0025oo`035n1oogoo051oo`03001oogoo051oo`035n1oogoo02Uoo`0087oo00<Gh7ooOol0DGoo
00<007ooOol0D7oo00<Gh7ooOol0:Goo000POol00aOPOomoo`1AOol00`00Oomoo`1AOol00aOPOomo
o`0XOol001moo`035n1oogoo059oo`03001oogoo055oo`035n1oogoo02Qoo`007goo00<Gh7ooOol0
DWoo00<007ooOol0DGoo00<Gh7ooOol0:7oo000NOol00aOPOomoo`1COol00`00Oomoo`1BOol00aOP
Oomoo`0WOol001ioo`035n1oogoo05=oo`03001oogoo059oo`035n1oogoo02Moo`007Woo00<Gh7oo
Ool0Dgoo00<007ooOol0DWoo00<Gh7ooOol09goo000MOol00aOPOomoo`1DOol00`00Oomoo`1COol0
0aOPOomoo`0VOol001eoo`035n1oogoo03]oo`@000Eoo`8000Eoo`@000Eoo`03001oogoo05=oo`03
5n1oogoo02Ioo`0077oo00<Gh7ooOol0>goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol0E7oo00<Gh7ooOol09Goo000LOol00aOPOomoo`0k
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`1DOol00aOPOomoo`0U
Ool001aoo`035n1oogoo03=oo`H0009oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009o
o`8005Eoo`035n1oogoo02Eoo`006goo00<Gh7ooOol0?7oo00<007ooOol00Woo00<007ooOol02Goo
10001Goo00<007ooOol0EGoo00<Gh7ooOol097oo000KOol00aOPOomoo`0lOol00`00Oomoo`02Ool0
0`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`1EOol00aOPOomoo`0TOol001]oo`035n1oogoo
03aoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo05Eoo`035n1oogoo
02Aoo`006Woo00<Gh7ooOol0?Woo100037oo1@0017oo00<007ooOol0EWoo00<Gh7ooOol08goo000J
Ool00aOPOomoo`1GOol00`00Oomoo`1FOol00aOPOomoo`0SOol001Yoo`035n1oogoo05Moo`03001o
ogoo05Ioo`035n1oogoo02=oo`006Woo00<Gh7ooOol0Egoo00<007ooOol0EWoo00<Gh7ooOol08goo
000IOol00aOPOomoo`1HOol00`00Oomoo`1GOol00aOPOomoo`0ROol001Uoo`035n1oogoo05Qoo`03
001oogoo05Moo`035n1oogoo029oo`006Goo00<Gh7ooOol0F7oo00<007ooOol0Egoo00<Gh7ooOol0
8Woo000IOol00aOPOomoo`1HOol00`00Oomoo`1GOol00aOPOomoo`0ROol001Uoo`035n1oogoo05Qo
o`03001oogoo05Moo`035n1oogoo029oo`002Goo1@002goo00@Gh7ooOomoo`D000Aoo`8000Eoo`@0
00moo`D000ioo`@000Eoo`8000Eoo`@000eoo`03001oogoo00ioo`@000Eoo`8000Eoo`@000moo`D0
00ioo`D000Aoo`8000Eoo`<000035n1oogoo00aoo`D0015oo`002Goo00D007ooOomoo`0000]oo`03
5n1oogoo00=oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00ioo`03001oogoo
00eoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00Yoo`03
001oogoo00eoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo
00ioo`03001oogoo011oo`03001oogoo00Aoo`8000Aoo`06001oogooOolGh0003Goo00D007ooOomo
o`00015oo`002Woo00<007ooOol02goo00<Gh7ooOol017oo00<007ooOol03goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol02Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol047oo00<007ooOol03goo
00<Gh7ooOol037oo00<007ooOol04Woo00000goo000000040004Ool00`00Oomoo`06Ool400000aOP
001oo`04Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool60005Ool00`00Oomoo`05Ool60002Ool00`00
Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00
Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0?Ool00aOPOomoo`0=Ool00`00
Oomoo`0AOol000aoo`03001oogoo00Uoo`035n1oogoo00Aoo`03001oogoo00]oo`@0015oo`03001o
ogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@000eoo`03001oogoo00eoo`03001oogoo009o
o`03001oogoo00Uoo`@0015oo`03001oogoo011oo`03001oogoo00]oo`@000035n1oogoo00ioo`03
001oogoo011oo`003Goo00<007ooOol027oo00<Gh7ooOol017oo00<007ooOol02goo00<007ooOol0
4Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol0
3Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol04Woo00<007ooOol047oo00<007ooOol0
2goo00D007ooOomooaOP015oo`03001oogoo00moo`002Goo00D007ooOomoo`0000Yoo`035n1oogoo
009oo`<000eoo`03001oogoo011oo`<000moo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00ioo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo011oo`<0011oo`<0
00eoo`05001oogooOolGh00=Ool01@00Oomoogoo00004Goo000:Ool3000;Ool00aOPOomoo`04Ool0
0`00Oomoo`0;Ool5000@Ool00`00Oomoo`0>Ool4000<Ool5000<Ool00`00Oomoo`0>Ool4000<Ool5
000@Ool00`00Oomoo`0@Ool00`00Oomoo`0;Ool400000aOPOomoo`0<Ool3000BOol001Qoo`035n1o
ogoo05Uoo`03001oogoo05Qoo`035n1oogoo025oo`0067oo00<Gh7ooOol0FGoo00<007ooOol0F7oo
00<Gh7ooOol08Goo000HOol00aOPOomoo`1IOol00`00Oomoo`1HOol00aOPOomoo`0QOol001Qoo`03
5n1oogoo05Uoo`03001oogoo05Qoo`035n1oogoo025oo`0067oo00<Gh7ooOol0FGoo00<007ooOol0
F7oo00<Gh7ooOol05Woo0P000Woo0P001Goo000HOol00aOPOomoo`1IOol00`00Oomoo`1HOol00aOP
Oomoo`0GOol01000Oomoo`001Woo0008Ool@00000aOP0000002d00000aOP0000000?0009Ool20007
Ool000Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`035n1oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`035n1oogoo00=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo00Moo`8000Moo`0027oo00<007ooOol03Goo00<Gh7ooOol027oo00<007oo
Ool067oo00<007ooOol067oo00<007ooOol067oo00<007ooOol067oo00<007ooOol067oo00<007oo
Ool067oo00<007ooOol01goo00<Gh7ooOol03Woo00<007ooOol01Woo00@007ooOol000Ioo`0067oo
00<Gh7ooOol0FGoo00<007ooOol0F7oo00<Gh7ooOol05Woo0P000Woo0P001Goo000HOol00aOPOomo
o`1IOol00`00Oomoo`1HOol00aOPOomoo`0QOol001Qoo`035n1oogoo05Uoo`03001oogoo05Qoo`03
5n1oogoo025oo`0067oo00<Gh7ooOol0FGoo00<007ooOol0F7oo00<Gh7ooOol08Goo000HOol00aOP
Oomoo`1IOol00`00Oomoo`1HOol00aOPOomoo`0QOol001Qoo`035n1oogoo05Uoo`03001oogoo05Qo
o`035n1oogoo025oo`0067oo00<Gh7ooOol0FGoo00<007ooOol0F7oo00<Gh7ooOol08Goo000HOol0
0aOPOomoo`1IOol00`00Oomoo`1HOol00aOPOomoo`0QOol001Qoo`035n1oogoo05Uoo`03001oogoo
05Qoo`035n1oogoo025oo`0067oo00<Gh7ooOol0FGoo00<007ooOol0F7oo00<Gh7ooOol08Goo000I
Ool00aOPOomoo`1HOol00`00Oomoo`1GOol00aOPOomoo`0ROol001Uoo`035n1oogoo05Qoo`03001o
ogoo05Moo`035n1oogoo029oo`006Goo00<Gh7ooOol0F7oo00<007ooOol0Egoo00<Gh7ooOol08Woo
000IOol00aOPOomoo`1HOol00`00Oomoo`1GOol00aOPOomoo`0ROol001Uoo`035n1oogoo05Qoo`03
001oogoo05Moo`035n1oogoo029oo`006Goo00<Gh7ooOol0F7oo00<007ooOol0Egoo00<Gh7ooOol0
8Woo000JOol00aOPOomoo`1GOol00`00Oomoo`1FOol00aOPOomoo`0SOol001Yoo`035n1oogoo05Mo
o`03001oogoo05Ioo`035n1oogoo02=oo`006Woo00<Gh7ooOol0Egoo00<007ooOol0EWoo00<Gh7oo
Ool08goo000JOol00aOPOomoo`1GOol00`00Oomoo`1FOol00aOPOomoo`0SOol001]oo`035n1oogoo
05Ioo`03001oogoo05Eoo`035n1oogoo02Aoo`006goo00<Gh7ooOol0?Goo10001Goo0P001Goo1000
1Goo00<007ooOol0EGoo00<Gh7ooOol097oo000KOol00aOPOomoo`0lOol00`00Oomoo`02Ool00`00
Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1EOol00aOPOomoo`0T
Ool001]oo`035n1oogoo03aoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001o
ogoo05Eoo`035n1oogoo02Aoo`0077oo00<Gh7ooOol0>goo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol00Woo0P00EGoo00<Gh7ooOol09Goo000LOol00aOPOomoo`0kOol00`00Oomoo`02Ool0
0`00Oomoo`09Ool40005Ool00`00Oomoo`1DOol00aOPOomoo`0UOol001eoo`035n1oogoo03Yoo`03
001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo05=oo`035n1oogoo02Ioo`00
7Goo00<Gh7ooOol0>Woo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0
Dgoo00<Gh7ooOol09Woo000MOol00aOPOomoo`0kOol4000<Ool50004Ool00`00Oomoo`1COol00aOP
Oomoo`0VOol001ioo`035n1oogoo05=oo`03001oogoo059oo`035n1oogoo02Moo`007Woo00<Gh7oo
Ool0Dgoo00<007ooOol0DWoo00<Gh7ooOol09goo000OOol00aOPOomoo`1BOol00`00Oomoo`1BOol0
0aOPOomoo`0WOol001moo`035n1oogoo059oo`03001oogoo055oo`035n1oogoo02Qoo`0087oo00<G
h7ooOol0DGoo00<007ooOol0DGoo00<Gh7ooOol0:7oo000POol00aOPOomoo`1AOol00`00Oomoo`1@
Ool00aOPOomoo`0YOol0025oo`035n1oogoo051oo`03001oogoo051oo`035n1oogoo02Uoo`008Goo
00<Gh7ooOol0D7oo00<007ooOol0D7oo00<Gh7ooOol0:Goo000ROol00aOPOomoo`1?Ool00`00Oomo
o`1?Ool00aOPOomoo`0ZOol0029oo`035n1oogoo04moo`03001oogoo04moo`035n1oogoo02Yoo`00
8goo00<Gh7ooOol0CWoo00<007ooOol0CWoo00<Gh7ooOol0:goo000SOol00aOPOomoo`1>Ool00`00
Oomoo`1>Ool00aOPOomoo`0[Ool002Aoo`035n1oogoo04eoo`03001oogoo04eoo`035n1oogoo02ao
o`0097oo00<Gh7ooOol0CGoo00<007ooOol0CGoo00<Gh7ooOol0;7oo000UOol00aOPOomoo`1<Ool0
0`00Oomoo`1<Ool00aOPOomoo`0]Ool002Eoo`035n1oogoo04aoo`03001oogoo04aoo`035n1oogoo
02eoo`009Woo00<Gh7ooOol0Bgoo00<007ooOol0Bgoo00<Gh7ooOol0;Woo000VOol00aOPOomoo`1;
Ool00`00Oomoo`1;Ool00aOPOomoo`0^Ool002Moo`035n1oogoo04Yoo`03001oogoo04Yoo`035n1o
ogoo02moo`009goo00<Gh7ooOol0@Goo1@0017oo00<007ooOol0BWoo00<Gh7ooOol0;goo000XOol0
0aOPOomoo`12Ool00`00Oomoo`04Ool00`00Oomoo`19Ool00aOPOomoo`0`Ool002Qoo`035n1oogoo
049oo`03001oogoo00Aoo`03001oogoo04Qoo`035n1oogoo035oo`00:Goo00<Gh7ooOol0@Goo00<0
07ooOol017oo0P00B7oo00<Gh7ooOol0<Woo000YOol00aOPOomoo`11Ool00`00Oomoo`04Ool00`00
Oomoo`17Ool00aOPOomoo`0bOol002Yoo`035n1oogoo041oo`03001oogoo00Aoo`03001oogoo04Io
o`035n1oogoo03=oo`00:goo00<Gh7ooOol0?Goo0`001Woo00<007ooOol0AGoo00<Gh7ooOol0=7oo
000/Ool00aOPOomoo`0nOol00`00Oomoo`04Ool00`00Oomoo`14Ool00aOPOomoo`0eOol002eoo`03
5n1oogoo04Aoo`03001oogoo04=oo`035n1oogoo03Ioo`00;Woo00<Gh7ooOol0@goo00<007ooOol0
@goo00<Gh7ooOol0=Woo000_Ool00aOPOomoo`12Ool00`00Oomoo`12Ool00aOPOomoo`0gOol0031o
o`035n1oogoo045oo`03001oogoo045oo`035n1oogoo03Qoo`00<Goo00<Gh7ooOol0@7oo00<007oo
Ool0@7oo00<Gh7ooOol0>Goo000bOol00aOPOomoo`0oOol00`00Oomoo`0oOol00aOPOomoo`0jOol0
03=oo`035n1oogoo03ioo`03001oogoo03ioo`035n1oogoo03]oo`00=7oo00<Gh7ooOol0?Goo00<0
07ooOol0?Goo00<Gh7ooOol0?7oo000eOol00aOPOomoo`0lOol00`00Oomoo`0lOol00aOPOomoo`0m
Ool003Ioo`035n1oogoo03]oo`03001oogoo03]oo`035n1oogoo03ioo`00=goo00<Gh7ooOol0>Woo
00<007ooOol0>Goo0QOP@Goo000hOol00aOPOomoo`0iOol00`00Oomoo`0hOol00aOPOomoo`11Ool0
03Uoo`8Gh3Uoo`03001oogoo03Moo`035n1oogoo049oo`00>goo00<Gh7ooOol0=Woo00<007ooOol0
=Goo0QOPAGoo000lOol00aOPOomoo`0eOol00`00Oomoo`0dOol00aOPOomoo`15Ool003eoo`8Gh3Eo
o`03001oogoo039oo`8Gh4Qoo`00?goo00<Gh7ooOol0<Woo00<007ooOol0<Goo00<Gh7ooOol0B7oo
0010Ool00aOPOomoo`0aOol00`00Oomoo`0`Ool00aOPOomoo`19Ool0045oo`8Gh35oo`03001oogoo
02ioo`8Gh4aoo`00@goo00<Gh7ooOol05Goo1@0017oo0P001Goo10001Goo00<007ooOol0;Goo00<G
h7ooOol0C7oo0014Ool25n0GOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`0[Ool25n1?Ool004Ioo`8Gh1Eoo`03001oogoo00moo`03001oogoo009oo`03001o
ogoo02Uoo`8Gh55oo`00B7oo0QOP4goo00<007ooOol03goo00<007ooOol00Woo0P00:7oo0QOPDgoo
001:Ool25n0AOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`0VOol00aOPOomoo`1COol004aoo`8G
h0moo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo02Aoo`8Gh5Ioo`00CWoo0QOP2goo0`00
3Goo00<007ooOol01Woo00<007ooOol08Woo0QOPF7oo001@Ool25n0;Ool00`00Oomoo`0;Ool50004
Ool00`00Oomoo`0POol25n1JOol0059oo`<Gh1moo`03001oogoo01eoo`<Gh5aoo`00EGoo11OP6goo
00<007ooOol06Goo11OPGgoo001IOol45n0GOol00`00Oomoo`0EOol45n1SOol005eoo`@Gh1=oo`03
001oogoo015oo`@Gh6Moo`00HGoo11OP3goo00<007ooOol037oo1AOPJgoo001UOol45n0;Ool00`00
Oomoo`08Ool45n1`Ool006UooaHGh7Aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00JWoo1@001Goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool00`00Oomoo`06
Ool00`00Oomoo`1lOol006aoo`03001oogoo00Eoo`8007eoo`00KGoo00<007ooOol0Pgoo001^Ool0
0`00Oomoo`22Ool006Yoo`05001oogooOol00024Ool006]oo`<008Eoo`00lgoo003cOol00?=oo`00
lgoo002EOol3000;Ool50004Ool20005Ool3000mOol009Aoo`06001oogooOol007oo1P001Goo00<0
07ooOol017oo0P0017oo00D007ooOomoo`0003aoo`00Lgoo0P0000=oo`00000077oo00<007ooOol0
3Woo00<007ooOol03Woo00<007ooOol0>Woo001bOol00`00Oomoo`02000MOol00`00Oomoo`03Ool6
0005Ool00`00Oomoo`0>Ool00`00Oomoo`0jOol0079oo`05001oogooOol0000MOol00`00Oomoo`0>
Ool00`00Oomoo`0<Ool2000mOol0079oo`05001oogooOol0000LOol5000=Ool00`00Oomoo`0>Ool0
0`00Oomoo`0jOol0079oo`05001oogooOol0000MOol00`00Oomoo`0<Ool3000<Ool01@00Oomoogoo
0000?7oo001aOol20002Ool2000^Ool00`00Oomoo`0;Ool3000mOol00?=oo`00lgoo003cOol00?=o
o`00lgoo0000\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.25) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.5 1 0 r

.5 Mabswid

.08542 .49991 m

.08719 .46175 L

.09248 .42382 L

.10125 .38655 L

.11342 .35024 L

.12888 .31521 L

.14752 .28175 L

.16916 .25016 L

.19362 .2207 L

.2207 .19362 L

.25016 .16916 L

.28175 .14752 L

.31521 .12888 L

.35024 .11342 L

.38655 .10125 L

.42382 .09248 L

.46175 .08719 L

.5 .08542 L

.53825 .08719 L

.57618 .09248 L

.61345 .10125 L

.64976 .11342 L

.68479 .12888 L

.71825 .14752 L

.74984 .16916 L

.7793 .19362 L

.80638 .2207 L

.83084 .25016 L

.85248 .28175 L

.87112 .31521 L

.88658 .35024 L

.89875 .38655 L

.90752 .42382 L

.91281 .46175 L

.91458 .49991 L

s

.08542 .50009 m

.08719 .53825 L

.09248 .57618 L

.10125 .61345 L

.11342 .64976 L

.12888 .68479 L

.14752 .71825 L

.16916 .74984 L

.19362 .7793 L

.2207 .80638 L

.25016 .83084 L

.28175 .85248 L

.31521 .87112 L

.35024 .88658 L

.38655 .89875 L

.42382 .90752 L

.46175 .91281 L

.5 .91458 L

.53825 .91281 L

.57618 .90752 L

.61345 .89875 L

.64976 .88658 L

.68479 .87112 L

.71825 .85248 L

.74984 .83084 L

.7793 .80638 L

.80638 .7793 L

.83084 .74984 L

.85248 .71825 L

.87112 .68479 L

.88658 .64976 L

.89875 .61345 L

.90752 .57618 L

.91281 .53825 L

.91458 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001XOolH?n1cOol0069oo`Hoh0aoo`03001oogoo00Uoo`Hoh6eoo`00GWoo13oP4Woo00<0
07ooOol03goo13oPJGoo001JOol4?n0FOol00`00Oomoo`0COol4?n1UOol005Qoo`8oh1Yoo`03001o
ogoo01Moo`8oh6=oo`00EGoo0coP0goo1@0017oo0P001Goo10001Goo00<007ooOol06Goo0coPH7oo
001BOol3?n08Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`0LOol3?n1MOol0051oo`8oh0]oo`03001oogoo00moo`03001oogoo009oo`03001oogoo01moo`8o
h5]oo`00CWoo0SoP0Woo1P001Goo00<007ooOol03goo00<007ooOol00Woo0P008Woo0coPF7oo001<
Ool2?n0?Ool00`00Oomoo`0;Ool40005Ool00`00Oomoo`0TOol2?n1FOol004Yoo`8oh15oo`03001o
ogoo00]oo`03001oogoo00Ioo`03001oogoo02Ioo`8oh5Aoo`00B7oo0SoP4Goo0`003Goo00<007oo
Ool01Woo00<007ooOol0:7oo0SoPDWoo0016Ool2?n0EOol00`00Oomoo`0;Ool50004Ool00`00Oomo
o`0ZOol2?n1@Ool004Eoo`03?n1oogoo02aoo`03001oogoo02aoo`03?n1oogoo04eoo`00@goo0SoP
;goo00<007ooOol0;Goo0SoPCGoo0012Ool00coPOomoo`0_Ool00`00Oomoo`0_Ool00coPOomoo`1:
Ool0045oo`03?n1oogoo031oo`03001oogoo031oo`03?n1oogoo04Uoo`00?goo0SoP<goo00<007oo
Ool0<Goo0SoPBGoo000nOol00coPOomoo`0cOol00`00Oomoo`0cOol00coPOomoo`16Ool003aoo`8o
h3Ioo`03001oogoo03Aoo`03?n1oogoo04Eoo`00>goo00<oh7ooOol0=Woo00<007ooOol0=Goo00<o
h7ooOol0A7oo000jOol00coPOomoo`0gOol00`00Oomoo`0fOol2?n14Ool003Qoo`8oh3Yoo`03001o
ogoo03Qoo`03?n1oogoo045oo`00=goo00<oh7ooOol0>Woo00<007ooOol0>Goo00<oh7ooOol0@7oo
000fOol00coPOomoo`0kOol00`00Oomoo`0jOol00coPOomoo`0oOol003Eoo`03?n1oogoo03aoo`03
001oogoo03]oo`03?n1oogoo03ioo`00=7oo00<oh7ooOol0?Goo00<007ooOol0?7oo00<oh7ooOol0
?Goo000dOol00coPOomoo`0mOol00`00Oomoo`0mOol00coPOomoo`0lOol003=oo`03?n1oogoo03io
o`03001oogoo03ioo`03?n1oogoo03]oo`00<Woo00<oh7ooOol0?goo00<007ooOol0?goo00<oh7oo
Ool0>Woo000aOol00coPOomoo`10Ool00`00Oomoo`10Ool00coPOomoo`0iOol0031oo`03?n1oogoo
045oo`03001oogoo045oo`03?n1oogoo03Qoo`00;goo00<oh7ooOol0>Goo1@0017oo00<007ooOol0
@Woo00<oh7ooOol0=goo000^Ool00coPOomoo`0lOol00`00Oomoo`04Ool00`00Oomoo`12Ool00coP
Oomoo`0gOol002eoo`03?n1oogoo03eoo`03001oogoo00Aoo`03001oogoo04=oo`03?n1oogoo03Io
o`00;7oo00<oh7ooOol0<goo1P001Goo00<007ooOol017oo0P00AGoo00<oh7ooOol0=Goo000[Ool0
0coPOomoo`0oOol00`00Oomoo`04Ool00`00Oomoo`15Ool00coPOomoo`0dOol002]oo`03?n1oogoo
03moo`03001oogoo00Aoo`03001oogoo04Eoo`03?n1oogoo03Aoo`00:Woo00<oh7ooOol0?Woo0`00
1Woo00<007ooOol0AWoo00<oh7ooOol0<goo000ZOol00coPOomoo`10Ool00`00Oomoo`04Ool00`00
Oomoo`17Ool00coPOomoo`0bOol002Uoo`03?n1oogoo04Qoo`03001oogoo04Qoo`03?n1oogoo035o
o`00:Goo00<oh7ooOol0B7oo00<007ooOol0B7oo00<oh7ooOol0<Goo000XOol00coPOomoo`19Ool0
0`00Oomoo`19Ool00coPOomoo`0`Ool002Moo`03?n1oogoo04Yoo`03001oogoo04Yoo`03?n1oogoo
02moo`009goo00<oh7ooOol0BWoo00<007ooOol0BWoo00<oh7ooOol0;goo000VOol00coPOomoo`1;
Ool00`00Oomoo`1;Ool00coPOomoo`0^Ool002Ioo`03?n1oogoo04]oo`03001oogoo04]oo`03?n1o
ogoo02ioo`009Goo00<oh7ooOol0C7oo00<007ooOol0C7oo00<oh7ooOol0;Goo000UOol00coPOomo
o`1<Ool00`00Oomoo`1<Ool00coPOomoo`0]Ool002Aoo`03?n1oogoo04eoo`03001oogoo04eoo`03
?n1oogoo02aoo`008goo00<oh7ooOol0CWoo00<007ooOol0CGoo00<oh7ooOol0;7oo000SOol00coP
Oomoo`1>Ool00`00Oomoo`1>Ool00coPOomoo`0[Ool0029oo`03?n1oogoo04moo`03001oogoo04io
o`03?n1oogoo02]oo`008Woo00<oh7ooOol0Cgoo00<007ooOol0Cgoo00<oh7ooOol0:Woo000QOol0
0coPOomoo`1@Ool00`00Oomoo`1?Ool00coPOomoo`0ZOol0025oo`03?n1oogoo051oo`03001oogoo
04moo`03?n1oogoo02Yoo`0087oo00<oh7ooOol0DGoo00<007ooOol0D7oo00<oh7ooOol0:Goo000P
Ool00coPOomoo`1AOol00`00Oomoo`1@Ool00coPOomoo`0YOol0021oo`03?n1oogoo055oo`03001o
ogoo051oo`03?n1oogoo02Uoo`007goo00<oh7ooOol0>Goo10001Goo0P001Goo10001Goo00<007oo
Ool0DGoo00<oh7ooOol0:7oo000OOol00coPOomoo`0hOol00`00Oomoo`02Ool00`00Oomoo`02Ool2
0004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1AOol00coPOomoo`0XOol001moo`03
?n1oogoo03Qoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo059oo`03
?n1oogoo02Moo`007goo00<oh7ooOol0<7oo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol00Woo0P00Dgoo00<oh7ooOol09goo000NOol00coPOomoo`0iOol00`00Oomoo`02Ool00`00
Oomoo`09Ool40005Ool00`00Oomoo`1BOol00coPOomoo`0WOol001ioo`03?n1oogoo03Uoo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo05=oo`03?n1oogoo02Ioo`007Woo
00<oh7ooOol0>Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0Dgoo
00<oh7ooOol09Woo000NOol00coPOomoo`0jOol4000<Ool50004Ool00`00Oomoo`1COol00coPOomo
o`0VOol001eoo`03?n1oogoo05Aoo`03001oogoo05Aoo`03?n1oogoo02Eoo`007Goo00<oh7ooOol0
E7oo00<007ooOol0E7oo00<oh7ooOol09Goo000MOol00coPOomoo`1DOol00`00Oomoo`1DOol00coP
Oomoo`0UOol001eoo`03?n1oogoo05Aoo`03001oogoo05Aoo`03?n1oogoo02Eoo`0077oo00<oh7oo
Ool0EGoo00<007ooOol0EGoo00<oh7ooOol097oo000LOol00coPOomoo`1EOol00`00Oomoo`1EOol0
0coPOomoo`0TOol001aoo`03?n1oogoo05Eoo`03001oogoo05Eoo`03?n1oogoo02Aoo`0077oo00<o
h7ooOol0EGoo00<007ooOol0EGoo00<oh7ooOol097oo0009Ool5000>Ool00coP000000030004Ool2
0005Ool4000?Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4
000?Ool5000>Ool50004Ool20005Ool01000?n0000003Woo1@004Goo0009Ool01@00Oomoogoo0000
3Woo00@oh7ooOol000Ioo`8000Aoo`03001oogoo009oo`03001oogoo00ioo`03001oogoo00eoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo
00eoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00ioo`03
001oogoo011oo`03001oogoo00Aoo`8000Aoo`03001oocoP009oo`03001oogoo00]oo`05001oogoo
Ool0000AOol000Yoo`03001oogoo00ioo`05?n1oogooOol0000AOol00`00Oomoo`0>Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0=Ool00coPOol0
000>Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Ioo`H00003Ooloh7oo009o
o`03001oogoo00moo`03001oogoo00=oo`H000Eoo`03001oogoo00Eoo`H0009oo`03001oogoo009o
o`03001oogoo00eoo`03001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00eo
o`03001oogoo00ioo`03001oogoo011oo`03001oogoo00eoo`03?n1oo`0000moo`03001oogoo015o
o`0037oo00<007ooOol037oo00Doh7ooOomoo`0000eoo`@0015oo`03001oogoo00eoo`03001oogoo
009oo`03001oogoo00Uoo`@000eoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@0
015oo`03001oogoo011oo`03001oogoo00]oo`800003?n0007oo011oo`03001oogoo011oo`003Goo
00<007ooOol02goo00Doh7ooOomoo`0000eoo`03001oogoo019oo`03001oogoo00eoo`03001oogoo
009oo`03001oogoo00Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03001oogoo
00Uoo`03001oogoo019oo`03001oogoo011oo`03001oogoo00]oo`03001oocoP01=oo`03001oogoo
00moo`002Goo00D007ooOomoo`0000eoo`03?n1oo`00008000eoo`03001oogoo011oo`<000moo`03
001oogoo009oo`03001oogoo00Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo011oo`<0011oo`<000eoo`03001oocoP00moo`05001oogooOol0000A
Ool000Yoo`<000ioo`05?n1oogooOol0000=Ool5000@Ool00`00Oomoo`0>Ool4000<Ool5000<Ool0
0`00Oomoo`0>Ool4000<Ool5000@Ool00`00Oomoo`0@Ool00`00Oomoo`0;Ool200000coP0000000>
Ool3000BOol001]oo`03?n1oogoo05Ioo`03001oogoo05Ioo`03?n1oogoo02=oo`006goo00<oh7oo
Ool0EWoo00<007ooOol0EWoo00<oh7ooOol08goo000JOol00coPOomoo`1GOol00`00Oomoo`1FOol0
0coPOomoo`0SOol001Yoo`03?n1oogoo05Moo`03001oogoo05Ioo`03?n1oogoo02=oo`006Woo00<o
h7ooOol0Egoo00<007ooOol0EWoo00<oh7ooOol067oo0P000Woo0P001Goo000JOol00coPOomoo`1G
Ool00`00Oomoo`1FOol00coPOomoo`0IOol01000Oomoo`001Woo0008OolB00000coP0000002`0000
0coP0000000A0009Ool20007Ool000Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oocoP009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`06001oogoo?n1oo`001Goo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol01goo0P001goo0008Ool00`00Oomoo`0?Ool00coPOomo
o`06Ool00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomo
o`0HOol00`00Oomoo`0HOol00`00Oomoo`05Ool00coPOomoo`0@Ool00`00Oomoo`06Ool01000Oomo
o`001Woo000JOol00coPOomoo`1GOol00`00Oomoo`1FOol00coPOomoo`0HOol20002Ool20005Ool0
01]oo`03?n1oogoo05Ioo`03001oogoo05Ioo`03?n1oogoo02=oo`006goo00<oh7ooOol0EWoo00<0
07ooOol0EWoo00<oh7ooOol08goo000KOol00coPOomoo`1FOol00`00Oomoo`1FOol00coPOomoo`0S
Ool001]oo`03?n1oogoo05Ioo`03001oogoo05Ioo`03?n1oogoo02=oo`006goo00<oh7ooOol0EWoo
00<007ooOol0EWoo00<oh7ooOol08goo000KOol00coPOomoo`1FOol00`00Oomoo`1FOol00coPOomo
o`0SOol001]oo`03?n1oogoo05Ioo`03001oogoo05Ioo`03?n1oogoo02=oo`006goo00<oh7ooOol0
EWoo00<007ooOol0EWoo00<oh7ooOol08goo000KOol00coPOomoo`1FOol00`00Oomoo`1FOol00coP
Oomoo`0SOol001aoo`03?n1oogoo05Eoo`03001oogoo05Eoo`03?n1oogoo02Aoo`0077oo00<oh7oo
Ool0EGoo00<007ooOol0EGoo00<oh7ooOol097oo000LOol00coPOomoo`1EOol00`00Oomoo`1EOol0
0coPOomoo`0TOol001aoo`03?n1oogoo05Eoo`03001oogoo05Eoo`03?n1oogoo02Aoo`0077oo00<o
h7ooOol0EGoo00<007ooOol0EGoo00<oh7ooOol097oo000LOol00coPOomoo`1EOol00`00Oomoo`1E
Ool00coPOomoo`0TOol001eoo`03?n1oogoo05Aoo`03001oogoo05Aoo`03?n1oogoo02Eoo`007Goo
00<oh7ooOol0E7oo00<007ooOol0E7oo00<oh7ooOol09Goo000MOol00coPOomoo`1DOol00`00Oomo
o`1DOol00coPOomoo`0UOol001eoo`03?n1oogoo05Aoo`03001oogoo05Aoo`03?n1oogoo02Eoo`00
7Woo00<oh7ooOol0Dgoo00<007ooOol0Dgoo00<oh7ooOol09Woo000NOol00coPOomoo`0jOol40005
Ool20005Ool40005Ool00`00Oomoo`1COol00coPOomoo`0VOol001ioo`03?n1oogoo03Uoo`03001o
ogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo05=o
o`03?n1oogoo02Ioo`007Woo00<oh7ooOol0>Goo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol0Dgoo00<oh7ooOol09Woo000OOol00coPOomoo`0hOol00`00Oomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`02Ool2001COol00coPOomoo`0WOol001moo`03?n1oogoo03Qoo`03
001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo059oo`03?n1oogoo02Moo`007goo00<o
h7ooOol0>7oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0DGoo00<o
h7ooOol0:7oo000OOol00coPOomoo`0hOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06
Ool00`00Oomoo`1AOol00coPOomoo`0XOol0021oo`03?n1oogoo03Qoo`@000aoo`D000Aoo`03001o
ogoo051oo`03?n1oogoo02Uoo`0087oo00<oh7ooOol0DGoo00<007ooOol0D7oo00<oh7ooOol0:Goo
000QOol00coPOomoo`1@Ool00`00Oomoo`1@Ool00coPOomoo`0YOol0025oo`03?n1oogoo051oo`03
001oogoo04moo`03?n1oogoo02Yoo`008Woo00<oh7ooOol0Cgoo00<007ooOol0Cgoo00<oh7ooOol0
:Woo000ROol00coPOomoo`1?Ool00`00Oomoo`1>Ool00coPOomoo`0[Ool002=oo`03?n1oogoo04io
o`03001oogoo04ioo`03?n1oogoo02]oo`008goo00<oh7ooOol0CWoo00<007ooOol0CWoo00<oh7oo
Ool0:goo000TOol00coPOomoo`1=Ool00`00Oomoo`1=Ool00coPOomoo`0/Ool002Aoo`03?n1oogoo
04eoo`03001oogoo04eoo`03?n1oogoo02aoo`009Goo00<oh7ooOol0C7oo00<007ooOol0C7oo00<o
h7ooOol0;Goo000UOol00coPOomoo`1<Ool00`00Oomoo`1<Ool00coPOomoo`0]Ool002Ioo`03?n1o
ogoo04]oo`03001oogoo04]oo`03?n1oogoo02ioo`009Woo00<oh7ooOol0Bgoo00<007ooOol0Bgoo
00<oh7ooOol0;Woo000WOol00coPOomoo`1:Ool00`00Oomoo`1:Ool00coPOomoo`0_Ool002Moo`03
?n1oogoo04Yoo`03001oogoo04Yoo`03?n1oogoo02moo`00:7oo00<oh7ooOol0BGoo00<007ooOol0
BGoo00<oh7ooOol0<7oo000YOol00coPOomoo`18Ool00`00Oomoo`18Ool00coPOomoo`0aOol002Uo
o`03?n1oogoo04Qoo`03001oogoo04Qoo`03?n1oogoo035oo`00:Woo00<oh7ooOol0Agoo00<007oo
Ool0Agoo00<oh7ooOol0<Woo000ZOol00coPOomoo`0nOol50004Ool00`00Oomoo`16Ool00coPOomo
o`0cOol002]oo`03?n1oogoo03moo`03001oogoo00Aoo`03001oogoo04Eoo`03?n1oogoo03Aoo`00
:goo00<oh7ooOol0?goo00<007ooOol017oo00<007ooOol0AGoo00<oh7ooOol0=7oo000/Ool00coP
Oomoo`0nOol00`00Oomoo`04Ool20015Ool00coPOomoo`0eOol002eoo`03?n1oogoo03eoo`03001o
ogoo00Aoo`03001oogoo04=oo`03?n1oogoo03Ioo`00;Woo00<oh7ooOol0?7oo00<007ooOol017oo
00<007ooOol0@Woo00<oh7ooOol0=goo000_Ool00coPOomoo`0iOol30006Ool00`00Oomoo`11Ool0
0coPOomoo`0hOol0031oo`03?n1oogoo03Yoo`03001oogoo00Aoo`03001oogoo045oo`03?n1oogoo
03Qoo`00<Goo00<oh7ooOol0@7oo00<007ooOol0@7oo00<oh7ooOol0>Goo000bOol00coPOomoo`0o
Ool00`00Oomoo`0oOol00coPOomoo`0jOol003=oo`03?n1oogoo03ioo`03001oogoo03ioo`03?n1o
ogoo03]oo`00=7oo00<oh7ooOol0?Goo00<007ooOol0?Goo00<oh7ooOol0?7oo000eOol00coPOomo
o`0lOol00`00Oomoo`0lOol00coPOomoo`0mOol003Eoo`03?n1oogoo03aoo`03001oogoo03]oo`03
?n1oogoo03ioo`00=Woo00<oh7ooOol0>goo00<007ooOol0>Woo00<oh7ooOol0?goo000gOol00coP
Oomoo`0jOol00`00Oomoo`0iOol00coPOomoo`10Ool003Qoo`03?n1oogoo03Uoo`03001oogoo03Qo
o`03?n1oogoo045oo`00>Goo00<oh7ooOol0>7oo00<007ooOol0=goo00<oh7ooOol0@Woo000jOol2
?n0hOol00`00Oomoo`0fOol00coPOomoo`13Ool003aoo`03?n1oogoo03Eoo`03001oogoo03Eoo`03
?n1oogoo04Aoo`00?Goo00<oh7ooOol0=7oo00<007ooOol0=7oo00<oh7ooOol0AGoo000nOol00coP
Oomoo`0cOol00`00Oomoo`0cOol00coPOomoo`16Ool003moo`8oh3=oo`03001oogoo035oo`8oh4Uo
o`00@Goo0SoP<Goo00<007ooOol0;goo0SoPBgoo0013Ool2?n0_Ool00`00Oomoo`0]Ool2?n1=Ool0
04Eoo`03?n1oogoo02aoo`03001oogoo02aoo`03?n1oogoo04eoo`00AWoo0SoP;7oo00<007ooOol0
:Woo0SoPD7oo0018Ool2?n0AOol50004Ool20005Ool40005Ool00`00Oomoo`0XOol2?n1BOol004Yo
o`8oh15oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo02Io
o`8oh5Aoo`00C7oo00<oh7ooOol03Woo00<007ooOol03goo00<007ooOol00Woo00<007ooOol09Goo
00<oh7ooOol0E7oo001=Ool2?n0>Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool2000TOol2?n1GOol0
04moo`8oh0aoo`03001oogoo00]oo`@000Eoo`03001oogoo025oo`8oh5Uoo`00DGoo0SoP2Woo00<0
07ooOol02goo00<007ooOol01Woo00<007ooOol07goo0SoPFgoo001COol2?n06Ool3000=Ool00`00
Oomoo`06Ool00`00Oomoo`0LOol3?n1MOol005Eoo`@oh0Aoo`03001oogoo00]oo`D000Aoo`03001o
ogoo01Qoo`@oh61oo`00FGoo13oP5goo00<007ooOol057oo13oPI7oo001MOol4?n0COol00`00Oomo
o`0@Ool4?n1XOol0065oo`Hoh0eoo`03001oogoo00Yoo`Hoh6aoo`00Igoo2CoP17oo00<007ooOol0
0Woo23oPLWoo001`Ool9?n1jOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001ZOol50005Ool00`00Oomoo`1lOol006Yoo`05001oogooOol00005
Ool00`00Oomoo`1lOol006]oo`03001oogoo00Ioo`03001oogoo07aoo`00K7oo00<007ooOol01Goo
0P00OGoo001]Ool00`00Oomoo`23Ool006ioo`03001oogoo089oo`00JWoo00D007ooOomoo`0008Ao
o`00Jgoo0`00QGoo003cOol00?=oo`00lgoo003cOol0095oo`<000]oo`D000Aoo`8000Aoo`D000Ao
o`@003Qoo`00T7oo00H007ooOomoo`00Ool60005Ool00`00Oomoo`04Ool20004Ool01@00Oomoogoo
00000goo00<007ooOol00Woo00<007ooOol0=Goo001cOol200000goo0000000HOol00`00Oomoo`0>
Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`0eOol0079oo`03001oogoo008001Uoo`03
001oogoo00=oo`H000Eoo`03001oogoo00aoo`03001oogoo00Qoo`03001oogoo03Eoo`00LWoo00D0
07ooOomoo`0001Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo00=oo`@003Qoo`00LWoo
00D007ooOomoo`0001Qoo`D000eoo`03001oogoo00ioo`03001oogoo009oo`03001oogoo03Uoo`00
LWoo00D007ooOomoo`0001Uoo`03001oogoo00aoo`<000aoo`05001oogooOol00004Ool00`00Oomo
o`0iOol0075oo`80009oo`8002Yoo`03001oogoo00]oo`<000Eoo`D003Moo`00lgoo003cOol00?=o
o`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.2) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.8 1 0 r

.5 Mabswid

.09689 .49991 m

.09861 .46281 L

.10375 .42593 L

.11228 .38968 L

.12411 .35438 L

.13915 .32032 L

.15727 .28779 L

.17831 .25707 L

.2021 .22842 L

.22842 .2021 L

.25707 .17831 L

.28779 .15727 L

.32032 .13915 L

.35438 .12411 L

.38968 .11228 L

.42593 .10375 L

.46281 .09861 L

.5 .09689 L

.53719 .09861 L

.57407 .10375 L

.61032 .11228 L

.64562 .12411 L

.67968 .13915 L

.71221 .15727 L

.74293 .17831 L

.77158 .2021 L

.7979 .22842 L

.82169 .25707 L

.84273 .28779 L

.86085 .32032 L

.87589 .35438 L

.88772 .38968 L

.89625 .42593 L

.90139 .46281 L

.90311 .49991 L

s

.09689 .50009 m

.09861 .53719 L

.10375 .57407 L

.11228 .61032 L

.12411 .64562 L

.13915 .67968 L

.15727 .71221 L

.17831 .74293 L

.2021 .77158 L

.22842 .7979 L

.25707 .82169 L

.28779 .84273 L

.32032 .86085 L

.35438 .87589 L

.38968 .88772 L

.42593 .89625 L

.46281 .90139 L

.5 .90311 L

.53719 .90139 L

.57407 .89625 L

.61032 .88772 L

.64562 .87589 L

.67968 .86085 L

.71221 .84273 L

.74293 .82169 L

.77158 .7979 L

.7979 .77158 L

.82169 .74293 L

.84273 .71221 L

.86085 .67968 L

.87589 .64562 L

.88772 .61032 L

.89625 .57407 L

.90139 .53719 L

.90311 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00LGoo1fOPNgoo001YOol8In03
Ool01000Oomoogoo26OPLgoo001SOol6In0;Ool00`00Oomoo`09Ool6In1]Ool005]oo`@000AWh003
Ool0000000Eoo`@000Eoo`03001oogoo00moo`AWh6Uoo`00Fgoo16OP1Goo0P0017oo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol04goo0fOPIWoo001GOol4In02Ool00`00Oomoo`0?Ool00`00
Oomoo`02Ool00`00Oomoo`0FOol4In1ROol0059oo`03001Wh6OP009Wh003001oogoo00=oo`03001o
ogoo00moo`03001oogoo009oo`8001]oo`AWh5ioo`00DGoo0VOP2Woo00<007ooOol02goo10001Goo
00<007ooOol07Woo0VOPG7oo001?Ool2In0<Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomo
o`0POol2In1JOol004eoo`9Wh0aoo`<000eoo`03001oogoo00Ioo`03001oogoo029oo`9Wh5Qoo`00
Bgoo0VOP47oo00<007ooOol02goo1@0017oo00<007ooOol097oo0VOPEWoo0019Ool2In0YOol00`00
Oomoo`0VOol2In1DOol004Moo`9Wh2]oo`03001oogoo02Qoo`9Wh59oo`00AWoo00=Wh7ooOol0:goo
00<007ooOol0:Woo00=Wh7ooOol0Cgoo0014Ool2In0^Ool00`00Oomoo`0[Ool2In1?Ool004=oo`03
In1oogoo02ioo`03001oogoo02eoo`03In1oogoo04aoo`00@Woo00=Wh7ooOol0;goo00<007ooOol0
;Woo00=Wh7ooOol0Bgoo0010Ool2In0bOol00`00Oomoo`0_Ool2In1;Ool003moo`03In1oogoo039o
o`03001oogoo035oo`03In1oogoo04Qoo`00?Woo00=Wh7ooOol0<goo00<007ooOol0<Woo00=Wh7oo
Ool0Agoo000mOol00fOPOomoo`0dOol00`00Oomoo`0cOol00fOPOomoo`16Ool003]oo`9Wh3Moo`03
001oogoo03Aoo`9Wh4Ioo`00>Woo00=Wh7ooOol0=goo00<007ooOol0=Woo00=Wh7ooOol0@goo000i
Ool00fOPOomoo`0hOol00`00Oomoo`0gOol00fOPOomoo`12Ool003Qoo`03In1oogoo03Uoo`03001o
ogoo03Qoo`03In1oogoo045oo`00=goo00=Wh7ooOol0>Woo00<007ooOol0>Goo00=Wh7ooOol0@7oo
000fOol00fOPOomoo`0kOol00`00Oomoo`0jOol00fOPOomoo`0oOol003Eoo`03In1oogoo03aoo`03
001oogoo03]oo`03In1oogoo03ioo`00=7oo00=Wh7ooOol0?Goo00<007ooOol0?7oo00=Wh7ooOol0
?Goo000cOol00fOPOomoo`0nOol00`00Oomoo`0mOol00fOPOomoo`0lOol0039oo`03In1oogoo03Io
o`D000Aoo`03001oogoo03ioo`03In1oogoo03]oo`00<Goo00=Wh7ooOol0>Goo00<007ooOol017oo
00<007ooOol0?goo00=Wh7ooOol0>Woo000`Ool00fOPOomoo`0jOol00`00Oomoo`04Ool00`00Oomo
o`10Ool00fOPOomoo`0iOol0031oo`03In1oogoo02moo`H000Eoo`03001oogoo00Aoo`80045oo`03
In1oogoo03Uoo`00;goo00=Wh7ooOol0>goo00<007ooOol017oo00<007ooOol0@Goo00=Wh7ooOol0
>7oo000^Ool00fOPOomoo`0lOol00`00Oomoo`04Ool00`00Oomoo`12Ool00fOPOomoo`0gOol002eo
o`03In1oogoo03]oo`<000Ioo`03001oogoo04=oo`03In1oogoo03Ioo`00;Goo00=Wh7ooOol0?Goo
00<007ooOol017oo00<007ooOol0A7oo00=Wh7ooOol0=Goo000/Ool00fOPOomoo`15Ool00`00Oomo
o`15Ool00fOPOomoo`0dOol002]oo`03In1oogoo04Ioo`03001oogoo04Eoo`03In1oogoo03Aoo`00
:goo00=Wh7ooOol0AWoo00<007ooOol0AWoo00=Wh7ooOol0<goo000ZOol00fOPOomoo`17Ool00`00
Oomoo`17Ool00fOPOomoo`0bOol002Uoo`03In1oogoo04Qoo`03001oogoo04Moo`03In1oogoo039o
o`00:Goo00=Wh7ooOol0B7oo00<007ooOol0B7oo00=Wh7ooOol0<Goo000XOol00fOPOomoo`19Ool0
0`00Oomoo`18Ool00fOPOomoo`0aOol002Qoo`03In1oogoo04Uoo`03001oogoo04Uoo`03In1oogoo
031oo`009goo00=Wh7ooOol0BWoo00<007ooOol0BGoo00=Wh7ooOol0<7oo000WOol00fOPOomoo`1:
Ool00`00Oomoo`1:Ool00fOPOomoo`0_Ool002Ioo`03In1oogoo04]oo`03001oogoo04Yoo`03In1o
ogoo02moo`009Woo00=Wh7ooOol0Bgoo00<007ooOol0Bgoo00=Wh7ooOol0;Woo000UOol00fOPOomo
o`1<Ool00`00Oomoo`1;Ool00fOPOomoo`0^Ool002Eoo`03In1oogoo04aoo`03001oogoo04aoo`03
In1oogoo02eoo`0097oo00=Wh7ooOol0CGoo00<007ooOol0C7oo00=Wh7ooOol0;Goo000TOol00fOP
Oomoo`1=Ool00`00Oomoo`1=Ool00fOPOomoo`0/Ool002Aoo`03In1oogoo04eoo`03001oogoo04eo
o`03In1oogoo02aoo`008goo00=Wh7ooOol0CWoo00<007ooOol0CWoo00=Wh7ooOol0:goo000SOol0
0fOPOomoo`1>Ool00`00Oomoo`1>Ool00fOPOomoo`0[Ool002=oo`03In1oogoo03Eoo`@000Eoo`80
00Eoo`@000Eoo`03001oogoo04ioo`03In1oogoo02]oo`008Woo00=Wh7ooOol0=Goo00<007ooOol0
0Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0Cgoo00=W
h7ooOol0:Woo000ROol00fOPOomoo`0eOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02
Ool00`00Oomoo`1?Ool00fOPOomoo`0ZOol0025oo`03In1oogoo02ioo`H0009oo`03001oogoo009o
o`03001oogoo00eoo`03001oogoo009oo`80051oo`03In1oogoo02Yoo`008Goo00=Wh7ooOol0=Woo
00<007ooOol00Woo00<007ooOol02Goo10001Goo00<007ooOol0Cgoo00=Wh7ooOol0:Woo000POol0
0fOPOomoo`0gOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`1@Ool0
0fOPOomoo`0YOol0021oo`03In1oogoo03Moo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00Ioo`03001oogoo051oo`03In1oogoo02Uoo`0087oo00=Wh7ooOol0>7oo100037oo1@0017oo00<0
07ooOol0D7oo00=Wh7ooOol0:Goo000OOol00fOPOomoo`1BOol00`00Oomoo`1AOol00fOPOomoo`0X
Ool001moo`03In1oogoo059oo`03001oogoo055oo`03In1oogoo02Qoo`007goo00=Wh7ooOol0DWoo
00<007ooOol0DGoo00=Wh7ooOol0:7oo000OOol00fOPOomoo`1BOol00`00Oomoo`1AOol00fOPOomo
o`0XOol001ioo`03In1oogoo05=oo`03001oogoo059oo`03In1oogoo02Moo`007Woo00=Wh7ooOol0
Dgoo00<007ooOol0DWoo00=Wh7ooOol09goo000NOol00fOPOomoo`1COol00`00Oomoo`1BOol00fOP
Oomoo`0WOol001ioo`03In1oogoo05=oo`03001oogoo059oo`03In1oogoo02Moo`002Goo1@003goo
00<006OP00000P0017oo0P001Goo10003goo1@003Woo10001Goo0P001Goo10003Goo00<007ooOol0
3Woo10001Goo0P001Goo10003goo1@003Woo1@0017oo0P000goo00=Wh7oo00000`003Woo1@004Goo
0009Ool01@00Oomoogoo000047oo00=Wh000Ool01Goo0P0017oo00<007ooOol00Woo00<007ooOol0
3Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<0
07ooOol02Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol0
0Woo00<007ooOol03Woo00<007ooOol047oo00<007ooOol017oo0P000goo00=Wh000Ool00goo00<0
07ooOol02goo00D007ooOomoo`00015oo`002Woo00<007ooOol047oo00=Wh7oo00004Goo00<007oo
Ool03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol02Woo00<007oo
Ool03Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol047oo00<007oo
Ool02Woo00=Wh7ooOol00Woo00<007ooOol037oo00<007ooOol04Woo00000goo000000040004Ool0
0`00Oomoo`06Ool60003Ool00fOPOol0000AOol00`00Oomoo`03Ool60005Ool00`00Oomoo`05Ool6
0002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0:Ool00fOPOomo
o`02Ool00`00Oomoo`0=Ool00`00Oomoo`0AOol000aoo`03001oogoo00ioo`03In1oo`0000eoo`@0
015oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@000eoo`03001oogoo00eoo`03
001oogoo009oo`03001oogoo00Uoo`@0015oo`03001oogoo011oo`03001oogoo00Yoo`03In000000
0080015oo`03001oogoo011oo`003Goo00<007ooOol03Goo00=Wh7oo00003Goo00<007ooOol04Woo
00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol04Woo00<007ooOol047oo00<007ooOol02Woo
00=Wh000Ool057oo00<007ooOol03goo0009Ool01@00Oomoogoo00003goo00=Wh00000003Goo00<0
07ooOol047oo0`003goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol0
3Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol047oo0`0047oo0`0037oo00=Wh000Ool0
47oo00D007ooOomoo`00015oo`002Woo0`0047oo00=Wh7oo00003Goo1@0047oo00<007ooOol03Woo
100037oo1@0037oo00<007ooOol03Woo100037oo1@0047oo00<007ooOol047oo00<007ooOol02Woo
00=Wh00000000`003Woo0`004Woo000MOol00fOPOomoo`1DOol00`00Oomoo`1COol00fOPOomoo`0V
Ool001eoo`03In1oogoo05Aoo`03001oogoo05=oo`03In1oogoo02Ioo`007Goo00=Wh7ooOol0E7oo
00<007ooOol0E7oo00=Wh7ooOol09Goo000MOol00fOPOomoo`1DOol00`00Oomoo`1DOol00fOPOomo
o`0UOol001eoo`03In1oogoo05Aoo`03001oogoo05Aoo`03In1oogoo01Yoo`80009oo`8000Eoo`00
7Goo00=Wh7ooOol0E7oo00<007ooOol0E7oo00=Wh7ooOol06goo00@007ooOol000Ioo`0027oo5@00
00=Wh0000000Z`0000=Wh00000004`002Goo0P001goo0008Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00fOPOomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00In1oo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`07Ool20007Ool000Qo
o`03001oogoo019oo`03In1oogoo00=oo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qo
o`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo00=oo`03In1oogoo019o
o`03001oogoo00Ioo`04001oogoo0006Ool001eoo`03In1oogoo05Aoo`03001oogoo05Aoo`03In1o
ogoo01Yoo`80009oo`8000Eoo`007Goo00=Wh7ooOol0E7oo00<007ooOol0Dgoo00=Wh7ooOol09Woo
000MOol00fOPOomoo`1DOol00`00Oomoo`1COol00fOPOomoo`0VOol001eoo`03In1oogoo05Aoo`03
001oogoo05=oo`03In1oogoo02Ioo`007Goo00=Wh7ooOol0E7oo00<007ooOol0Dgoo00=Wh7ooOol0
9Woo000MOol00fOPOomoo`1DOol00`00Oomoo`1COol00fOPOomoo`0VOol001eoo`03In1oogoo05Ao
o`03001oogoo05=oo`03In1oogoo02Ioo`007Goo00=Wh7ooOol0E7oo00<007ooOol0Dgoo00=Wh7oo
Ool09Woo000MOol00fOPOomoo`1DOol00`00Oomoo`1COol00fOPOomoo`0VOol001ioo`03In1oogoo
05=oo`03001oogoo059oo`03In1oogoo02Moo`007Woo00=Wh7ooOol0Dgoo00<007ooOol0DWoo00=W
h7ooOol09goo000NOol00fOPOomoo`1COol00`00Oomoo`1BOol00fOPOomoo`0WOol001ioo`03In1o
ogoo05=oo`03001oogoo059oo`03In1oogoo02Moo`007Woo00=Wh7ooOol0Dgoo00<007ooOol0DWoo
00=Wh7ooOol09goo000NOol00fOPOomoo`1COol00`00Oomoo`1BOol00fOPOomoo`0WOol001moo`03
In1oogoo059oo`03001oogoo055oo`03In1oogoo02Qoo`007goo00=Wh7ooOol0DWoo00<007ooOol0
DGoo00=Wh7ooOol0:7oo000OOol00fOPOomoo`1BOol00`00Oomoo`1AOol00fOPOomoo`0XOol001mo
o`03In1oogoo059oo`03001oogoo055oo`03In1oogoo02Qoo`0087oo00=Wh7ooOol0DGoo00<007oo
Ool0D7oo00=Wh7ooOol0:Goo000POol00fOPOomoo`1AOol00`00Oomoo`1@Ool00fOPOomoo`0YOol0
021oo`03In1oogoo03Qoo`@000Eoo`8000Eoo`@000Eoo`03001oogoo051oo`03In1oogoo02Uoo`00
87oo00=Wh7ooOol0=goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol0D7oo00=Wh7ooOol0:Goo000QOol00fOPOomoo`0fOol00`00Oomoo`02
Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`1?Ool00fOPOomoo`0ZOol0025oo`03In1o
ogoo03Ioo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`80051oo`03In1oogoo02Yo
o`008Woo00=Wh7ooOol0=Goo00<007ooOol00Woo00<007ooOol02Goo10001Goo00<007ooOol0Cgoo
00=Wh7ooOol0:Woo000ROol00fOPOomoo`0eOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomo
o`06Ool00`00Oomoo`1?Ool00fOPOomoo`0ZOol0029oo`03In1oogoo03Eoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo04ioo`03In1oogoo02]oo`008goo00=Wh7ooOol0
=Goo100037oo1@0017oo00<007ooOol0CWoo00=Wh7ooOol0:goo000SOol00fOPOomoo`1>Ool00`00
Oomoo`1>Ool00fOPOomoo`0[Ool002=oo`03In1oogoo04ioo`03001oogoo04eoo`03In1oogoo02ao
o`0097oo00=Wh7ooOol0CGoo00<007ooOol0CGoo00=Wh7ooOol0;7oo000TOol00fOPOomoo`1=Ool0
0`00Oomoo`1<Ool00fOPOomoo`0]Ool002Eoo`03In1oogoo04aoo`03001oogoo04aoo`03In1oogoo
02eoo`009Goo00=Wh7ooOol0C7oo00<007ooOol0Bgoo00=Wh7ooOol0;Woo000VOol00fOPOomoo`1;
Ool00`00Oomoo`1;Ool00fOPOomoo`0^Ool002Ioo`03In1oogoo04]oo`03001oogoo04Yoo`03In1o
ogoo02moo`009goo00=Wh7ooOol0BWoo00<007ooOol0BWoo00=Wh7ooOol0;goo000WOol00fOPOomo
o`1:Ool00`00Oomoo`19Ool00fOPOomoo`0`Ool002Qoo`03In1oogoo04Uoo`03001oogoo04Uoo`03
In1oogoo031oo`00:7oo00=Wh7ooOol0BGoo00<007ooOol0B7oo00=Wh7ooOol0<Goo000YOol00fOP
Oomoo`18Ool00`00Oomoo`18Ool00fOPOomoo`0aOol002Uoo`03In1oogoo04Qoo`03001oogoo04Mo
o`03In1oogoo039oo`00:Woo00=Wh7ooOol0Agoo00<007ooOol0Agoo00=Wh7ooOol0<Woo000[Ool0
0fOPOomoo`16Ool00`00Oomoo`16Ool00fOPOomoo`0cOol002]oo`03In1oogoo04Ioo`03001oogoo
04Ioo`03In1oogoo03=oo`00;7oo00=Wh7ooOol0AGoo00<007ooOol0AGoo00=Wh7ooOol0=7oo000/
Ool00fOPOomoo`15Ool00`00Oomoo`14Ool00fOPOomoo`0eOol002eoo`03In1oogoo03]oo`D000Ao
o`03001oogoo04=oo`03In1oogoo03Ioo`00;Goo00=Wh7ooOol0?Goo00<007ooOol017oo00<007oo
Ool0@goo00=Wh7ooOol0=Woo000^Ool00fOPOomoo`0lOol00`00Oomoo`04Ool00`00Oomoo`12Ool0
0fOPOomoo`0gOol002moo`03In1oogoo03]oo`03001oogoo00Aoo`80049oo`03In1oogoo03Qoo`00
<7oo00=Wh7ooOol0>Woo00<007ooOol017oo00<007ooOol0@7oo00=Wh7ooOol0>Goo000aOol00fOP
Oomoo`0iOol00`00Oomoo`04Ool00`00Oomoo`0oOol00fOPOomoo`0jOol0035oo`03In1oogoo03Mo
o`<000Ioo`03001oogoo03moo`03In1oogoo03Yoo`00<Woo00=Wh7ooOol0>7oo00<007ooOol017oo
00<007ooOol0?Woo00=Wh7ooOol0>goo000cOol00fOPOomoo`0nOol00`00Oomoo`0mOol00fOPOomo
o`0lOol003Aoo`03In1oogoo03eoo`03001oogoo03aoo`03In1oogoo03eoo`00=Goo00=Wh7ooOol0
?7oo00<007ooOol0>goo00=Wh7ooOol0?Woo000fOol2In0lOol00`00Oomoo`0iOol2In11Ool003Qo
o`03In1oogoo03Uoo`03001oogoo03Qoo`03In1oogoo045oo`00>Goo00=Wh7ooOol0>7oo00<007oo
Ool0=goo00=Wh7ooOol0@Woo000jOol00fOPOomoo`0gOol00`00Oomoo`0fOol00fOPOomoo`13Ool0
03]oo`03In1oogoo03Ioo`03001oogoo03Eoo`03In1oogoo04Aoo`00?7oo00=Wh7ooOol0=Goo00<0
07ooOol0=7oo00=Wh7ooOol0AGoo000mOol00fOPOomoo`0dOol00`00Oomoo`0cOol00fOPOomoo`16
Ool003ioo`03In1oogoo03=oo`03001oogoo039oo`03In1oogoo04Moo`00?goo00=Wh7ooOol0<Woo
00<007ooOol0<Goo00=Wh7ooOol0B7oo0010Ool2In0bOol00`00Oomoo`0_Ool2In1;Ool0049oo`9W
h31oo`03001oogoo02eoo`9Wh4eoo`00A7oo0VOP;Woo00<007ooOol0:goo0VOPCgoo0016Ool00fOP
Oomoo`0[Ool00`00Oomoo`0ZOol00fOPOomoo`1?Ool004Moo`9Wh2]oo`03001oogoo02Qoo`9Wh59o
o`00BGoo0VOP:Goo00<007ooOol09Woo0VOPE7oo001;Ool2In0WOol00`00Oomoo`0TOol2In1FOol0
04eoo`9Wh0aoo`D000Aoo`8000Eoo`@000Eoo`03001oogoo029oo`9Wh5Qoo`00Cgoo0VOP37oo00<0
07ooOol017oo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol087oo0VOPFWoo001A
Ool2In0:Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool00`00Oomoo`0NOol2In1LOol005=oo`=Wh0Mo
o`03001oogoo00moo`03001oogoo009oo`8001aoo`=Wh5ioo`00EWoo0VOP1Goo00<007ooOol02goo
10001Goo00<007ooOol06Goo0VOPHGoo001HOol3In02Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool0
0`00Oomoo`0FOol3In1SOol005]oo`=Wh0eoo`03001oogoo00Ioo`03001oogoo01=oo`=Wh6Ioo`00
GGoo00<006OPIn000VOP2Goo1@0017oo00<007ooOol03goo16OPJGoo001ROol6In0<Ool00`00Oomo
o`0:Ool5In1]Ool006QooaUWh79oo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol006Yoo`D000Eoo`03001oogoo07aoo`00JWoo00D007ooOomoo`0000Eoo`03001o
ogoo07aoo`00Jgoo00<007ooOol01Woo00<007ooOol0O7oo001/Ool00`00Oomoo`05Ool2001mOol0
06eoo`03001oogoo08=oo`00KWoo00<007ooOol0PWoo001ZOol01@00Oomoogoo0000Q7oo001[Ool3
0025Ool00?=oo`00lgoo003cOol00?=oo`00UGoo0`002goo1@0017oo0P0017oo1@00?7oo002DOol0
1P00Oomoogoo001oo`H000Eoo`03001oogoo00Aoo`8000Aoo`05001oogooOol0000lOol007=oo`80
0003Ool0000001aoo`03001oogoo00ioo`03001oogoo00]oo`03001oogoo03eoo`00LWoo00<007oo
Ool00P007Goo00<007ooOol00goo1P001Goo00<007ooOol037oo00<007ooOol0?7oo001bOol01@00
Oomoogoo00007Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol0>goo001bOol01@00Oomo
ogoo000077oo1@003Goo00<007ooOol03Woo00<007ooOol0>Woo001bOol01@00Oomoogoo00007Goo
00<007ooOol037oo0`0037oo00D007ooOomoo`0003aoo`00LGoo0P000Woo0P00;Woo00<007ooOol0
2goo0`00?Goo003cOol00?=oo`00lgoo003cOol00?=oo`00\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.15) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 .9 0 r

.5 Mabswid

.10869 .49991 m

.11036 .46389 L

.11535 .4281 L

.12363 .39291 L

.13511 .35864 L

.14971 .32558 L

.1673 .294 L

.18773 .26418 L

.21082 .23637 L

.23637 .21082 L

.26418 .18773 L

.294 .1673 L

.32558 .14971 L

.35864 .13511 L

.39291 .12363 L

.4281 .11535 L

.46389 .11036 L

.5 .10869 L

.53611 .11036 L

.5719 .11535 L

.60709 .12363 L

.64136 .13511 L

.67442 .14971 L

.706 .1673 L

.73582 .18773 L

.76363 .21082 L

.78918 .23637 L

.81227 .26418 L

.8327 .294 L

.85029 .32558 L

.86489 .35864 L

.87637 .39291 L

.88465 .4281 L

.88964 .46389 L

.89131 .49991 L

s

.10869 .50009 m

.11036 .53611 L

.11535 .5719 L

.12363 .60709 L

.13511 .64136 L

.14971 .67442 L

.1673 .706 L

.18773 .73582 L

.21082 .76363 L

.23637 .78918 L

.26418 .81227 L

.294 .8327 L

.32558 .85029 L

.35864 .86489 L

.39291 .87637 L

.4281 .88465 L

.46389 .88964 L

.5 .89131 L

.53611 .88964 L

.5719 .88465 L

.60709 .87637 L

.64136 .86489 L

.67442 .85029 L

.706 .8327 L

.73582 .81227 L

.76363 .78918 L

.78918 .76363 L

.81227 .73582 L

.8327 .706 L

.85029 .67442 L

.86489 .64136 L

.87637 .60709 L

.88465 .5719 L

.88964 .53611 L

.89131 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P000goo5Wn0M7oo001MOol0
0`00Oomoo`03Ool6Oh000goo001oo`03Ool00`00Oomoo`02Ool00`00Oomoo`08Ool6Oh1^Ool005eo
o`03001oogn000=oP0aoo`03001oogoo009oo`03001oogoo00ioo`AoP6Yoo`00DWoo1P0017oo0gn0
47oo00<007ooOol00Woo0P004goo17n0IWoo001JOol2Oh000goo001oo`0<Ool40005Ool00`00Oomo
o`0FOol2Oh1TOol005Moo`=oP0=oo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo01Qoo`9o
P69oo`00E7oo0gn017oo0`003Goo00<007ooOol01Woo00<007ooOol06Woo0gn0Ggoo001BOol2Oh09
Ool00`00Oomoo`0;Ool50004Ool00`00Oomoo`0MOol2Oh1MOol0051oo`9oP29oo`03001oogoo01mo
o`9oP5]oo`00CGoo0gn097oo00<007ooOol08Goo0gn0F7oo001;Ool2Oh0WOol00`00Oomoo`0TOol2
Oh1FOol004Uoo`9oP2Uoo`03001oogoo02Ioo`9oP5Aoo`00Agoo0Wn0:goo00<007ooOol0:7oo0Wn0
DWoo0016Ool00gn0Oomoo`0[Ool00`00Oomoo`0ZOol2Oh1@Ool004Eoo`03Oh1oogoo02aoo`03001o
ogoo02aoo`03Oh1oogoo04eoo`00@goo0Wn0;goo00<007ooOol0;Goo00=oP7ooOol0C7oo0012Ool0
0gn0Oomoo`0_Ool00`00Oomoo`0^Ool2Oh1<Ool0045oo`03Oh1oogoo031oo`03001oogoo031oo`03
Oh1oogoo04Uoo`00@7oo00=oP7ooOol0<Goo00<007ooOol0<Goo00=oP7ooOol0B7oo000oOol00gn0
Oomoo`0bOol00`00Oomoo`0bOol00gn0Oomoo`17Ool003eoo`9oP3Eoo`03001oogoo03=oo`9oP4Mo
o`00?7oo00=oP7ooOol0=Goo00<007ooOol0=Goo00=oP7ooOol0A7oo000kOol00gn0Oomoo`0fOol0
0`00Oomoo`0fOol00gn0Oomoo`13Ool003Yoo`03Oh1oogoo03Moo`03001oogoo03Moo`03Oh1oogoo
049oo`00>Goo00=oP7ooOol0>7oo00<007ooOol0>7oo00=oP7ooOol0@Goo000gOol2Oh0kOol00`00
Oomoo`0iOol00gn0Oomoo`10Ool003Ioo`03Oh1oogoo03]oo`03001oogoo03Yoo`03Oh1oogoo03mo
o`00=Goo00=oP7ooOol0<goo1@0017oo00<007ooOol0>goo00=oP7ooOol0?Woo000dOol00gn0Oomo
o`0fOol00`00Oomoo`04Ool00`00Oomoo`0lOol00gn0Oomoo`0mOol003=oo`03Oh1oogoo03Moo`03
001oogoo00Aoo`03001oogoo03eoo`03Oh1oogoo03aoo`00<Woo00=oP7ooOol0;Goo1P001Goo00<0
07ooOol017oo0P00?goo00=oP7ooOol0>goo000bOol00gn0Oomoo`0hOol00`00Oomoo`04Ool00`00
Oomoo`0nOol00gn0Oomoo`0kOol0035oo`03Oh1oogoo03Uoo`03001oogoo00Aoo`03001oogoo03mo
o`03Oh1oogoo03Yoo`00<7oo00=oP7ooOol0>7oo0`001Woo00<007ooOol0@7oo00=oP7ooOol0>Goo
000_Ool00gn0Oomoo`0kOol00`00Oomoo`04Ool00`00Oomoo`11Ool00gn0Oomoo`0hOol002moo`03
Oh1oogoo049oo`03001oogoo045oo`03Oh1oogoo03Qoo`00;Woo00=oP7ooOol0@goo00<007ooOol0
@Woo00=oP7ooOol0=goo000^Ool00gn0Oomoo`13Ool00`00Oomoo`12Ool00gn0Oomoo`0gOol002eo
o`03Oh1oogoo04Aoo`03001oogoo04=oo`03Oh1oogoo03Ioo`00;Goo00=oP7ooOol0A7oo00<007oo
Ool0@goo00=oP7ooOol0=Woo000/Ool00gn0Oomoo`15Ool00`00Oomoo`14Ool00gn0Oomoo`0eOol0
02]oo`03Oh1oogoo04Ioo`03001oogoo04Eoo`03Oh1oogoo03Aoo`00:goo00=oP7ooOol0AWoo00<0
07ooOol0AGoo00=oP7ooOol0=7oo000ZOol00gn0Oomoo`17Ool00`00Oomoo`16Ool00gn0Oomoo`0c
Ool002Yoo`03Oh1oogoo04Moo`03001oogoo04Ioo`03Oh1oogoo03=oo`00:Goo00=oP7ooOol0B7oo
00<007ooOol0Agoo00=oP7ooOol0<Woo000YOol00gn0Oomoo`18Ool00`00Oomoo`17Ool00gn0Oomo
o`0bOol002Qoo`03Oh1oogoo04Uoo`03001oogoo04Qoo`03Oh1oogoo035oo`00:7oo00=oP7ooOol0
BGoo00<007ooOol0B7oo00=oP7ooOol0<Goo000WOol00gn0Oomoo`1:Ool00`00Oomoo`19Ool00gn0
Oomoo`0`Ool002Moo`03Oh1oogoo04Yoo`03001oogoo04Uoo`03Oh1oogoo031oo`009Woo00=oP7oo
Ool0Bgoo00<007ooOol0BWoo00=oP7ooOol0;goo000VOol00gn0Oomoo`1;Ool00`00Oomoo`1:Ool0
0gn0Oomoo`0_Ool002Eoo`03Oh1oogoo04aoo`03001oogoo04]oo`03Oh1oogoo02ioo`009Goo00=o
P7ooOol0<goo10001Goo0P001Goo10001Goo00<007ooOol0Bgoo00=oP7ooOol0;Woo000UOol00gn0
Oomoo`0bOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`1;Ool00gn0Oomoo`0^Ool002Aoo`03Oh1oogoo03=oo`03001oogoo009oo`03001o
ogoo00eoo`03001oogoo009oo`03001oogoo04aoo`03Oh1oogoo02eoo`0097oo00=oP7ooOol0:goo
1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00CGoo00=oP7ooOol0;Goo
000TOol00gn0Oomoo`0cOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`1=Ool0
0gn0Oomoo`0/Ool002Aoo`03Oh1oogoo03=oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00Ioo`03001oogoo04eoo`03Oh1oogoo02aoo`008goo00=oP7ooOol0=7oo00<007ooOol00Woo00<0
07ooOol02Goo00<007ooOol01Woo00<007ooOol0CWoo00=oP7ooOol0:goo000SOol00gn0Oomoo`0e
Ool4000<Ool50004Ool00`00Oomoo`1>Ool00gn0Oomoo`0[Ool002=oo`03Oh1oogoo04ioo`03001o
ogoo04ioo`03Oh1oogoo02]oo`008Woo00=oP7ooOol0Cgoo00<007ooOol0Cgoo00=oP7ooOol0:Woo
000ROol00gn0Oomoo`1?Ool00`00Oomoo`1?Ool00gn0Oomoo`0ZOol0029oo`03Oh1oogoo04moo`03
001oogoo04moo`03Oh1oogoo02Yoo`008Woo00=oP7ooOol0Cgoo00<007ooOol0Cgoo00=oP7ooOol0
:Woo000QOol00gn0Oomoo`1@Ool00`00Oomoo`1@Ool00gn0Oomoo`0YOol0025oo`03Oh1oogoo051o
o`03001oogoo051oo`03Oh1oogoo02Uoo`008Goo00=oP7ooOol0D7oo00<007ooOol0D7oo00=oP7oo
Ool0:Goo0009Ool5000?Ool400000gn0Oomoo`02Ool20005Ool4000?Ool5000>Ool40005Ool20005
Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool5000>Ool50004Ool200000gooOh1o
o`02Ool4000>Ool5000AOol000Uoo`05001oogooOol0000AOol00`00OomoP004Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool20000
1GooOh1oogoo000017oo00<007ooOol02goo00D007ooOomoo`00015oo`002Woo00<007ooOol04Woo
00<007ooOh003goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol02Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol047oo00<007ooOol01goo00=oP7ooOol01Goo00<007ooOol037oo00<007ooOol04Woo
00000goo000000040004Ool00`00Oomoo`06Ool60005Ool00`00Oh1oo`0?Ool00`00Oomoo`03Ool6
0005Ool00`00Oomoo`05Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool0
0`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool0
0`00Oomoo`08Ool00gn0Oomoo`04Ool00`00Oomoo`0=Ool00`00Oomoo`0AOol000aoo`03001oogoo
011oo`03001oP7oo00]oo`@0015oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@0
00eoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@0015oo`03001oogoo011oo`03
001oogoo00Qoo`03Oh1oogoo00@0015oo`03001oogoo011oo`003Goo00<007ooOol03goo00<007n0
Ool02goo00<007ooOol04Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007oo
Ool03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol04Woo00<007oo
Ool047oo00<007ooOol027oo00AoP7ooOol001Eoo`03001oogoo00moo`002Goo00D007ooOomoo`00
00moo`<00003Oh1oogoo00Yoo`03001oogoo011oo`<000moo`03001oogoo009oo`03001oogoo00Uo
o`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo011o
o`<0011oo`<000Yoo`04Oh1oogoo000AOol01@00Oomoogoo00004Goo000:Ool3000BOol00`00Oh1o
o`0;Ool5000@Ool00`00Oomoo`0>Ool4000<Ool5000<Ool00`00Oomoo`0>Ool4000<Ool5000@Ool0
0`00Oomoo`0@Ool00`00Oomoo`08Ool00gn0Oomoo`05000>Ool3000BOol0021oo`03Oh1oogoo055o
o`03001oogoo055oo`03Oh1oogoo02Qoo`0087oo00=oP7ooOol0DGoo00<007ooOol0DGoo00=oP7oo
Ool0:7oo000OOol00gn0Oomoo`1BOol00`00Oomoo`1AOol00gn0Oomoo`0XOol001moo`03Oh1oogoo
059oo`03001oogoo055oo`03Oh1oogoo02Qoo`007goo00=oP7ooOol0DWoo00<007ooOol0DGoo00=o
P7ooOol07Goo0P000Woo0P001Goo000OOol00gn0Oomoo`1BOol00`00Oomoo`1AOol00gn0Oomoo`0N
Ool01000Oomoo`001Woo0008OolG00000gn00000002V00000gn00000000F0009Ool20007Ool000Qo
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogn000=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=o
o`06001oogooOh1oo`0017oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool01goo0P001goo0008Ool00`00Oomoo`0DOol01Gn0Oomoogoo00006Woo00<007ooOol067oo00<0
07ooOol067oo00<007ooOol067oo00<007ooOol067oo00<007ooOol067oo00@007ooOomoP1Moo`03
001oogoo00Ioo`04001oogoo0006Ool001moo`03Oh1oogoo059oo`03001oogoo055oo`03Oh1oogoo
01eoo`80009oo`8000Eoo`0087oo00=oP7ooOol0DGoo00<007ooOol0DGoo00=oP7ooOol0:7oo000P
Ool00gn0Oomoo`1AOol00`00Oomoo`1AOol00gn0Oomoo`0XOol0021oo`03Oh1oogoo055oo`03001o
ogoo055oo`03Oh1oogoo02Qoo`0087oo00=oP7ooOol0DGoo00<007ooOol0DGoo00=oP7ooOol0:7oo
000POol00gn0Oomoo`1AOol00`00Oomoo`1AOol00gn0Oomoo`0XOol0021oo`03Oh1oogoo055oo`03
001oogoo055oo`03Oh1oogoo02Qoo`0087oo00=oP7ooOol0DGoo00<007ooOol0DGoo00=oP7ooOol0
:7oo000POol00gn0Oomoo`1AOol00`00Oomoo`1AOol00gn0Oomoo`0XOol0025oo`03Oh1oogoo051o
o`03001oogoo051oo`03Oh1oogoo02Uoo`008Goo00=oP7ooOol0D7oo00<007ooOol0D7oo00=oP7oo
Ool0:Goo000QOol00gn0Oomoo`1@Ool00`00Oomoo`1@Ool00gn0Oomoo`0YOol0025oo`03Oh1oogoo
051oo`03001oogoo051oo`03Oh1oogoo02Uoo`008Goo00=oP7ooOol0D7oo00<007ooOol0D7oo00=o
P7ooOol0:Goo000QOol00gn0Oomoo`1@Ool00`00Oomoo`1@Ool00gn0Oomoo`0YOol0029oo`03Oh1o
ogoo04moo`03001oogoo04moo`03Oh1oogoo02Yoo`008Woo00=oP7ooOol0Cgoo00<007ooOol0Cgoo
00=oP7ooOol0:Woo000ROol00gn0Oomoo`1?Ool00`00Oomoo`1?Ool00gn0Oomoo`0ZOol0029oo`03
Oh1oogoo04moo`03001oogoo04moo`03Oh1oogoo02Yoo`008goo00=oP7ooOol0CWoo00<007ooOol0
CWoo00=oP7ooOol0:goo000SOol00gn0Oomoo`1>Ool00`00Oomoo`1>Ool00gn0Oomoo`0[Ool002=o
o`03Oh1oogoo03Eoo`@000Eoo`8000Eoo`@000Eoo`03001oogoo04ioo`03Oh1oogoo02]oo`0097oo
00=oP7ooOol0<goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol0CGoo00=oP7ooOol0;7oo000TOol00gn0Oomoo`0cOol00`00Oomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`1=Ool00gn0Oomoo`0/Ool002Aoo`03Oh1oogoo
03=oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`8004eoo`03Oh1oogoo02eoo`00
97oo00=oP7ooOol0<goo00<007ooOol00Woo00<007ooOol02Goo10001Goo00<007ooOol0C7oo00=o
P7ooOol0;Goo000UOol00gn0Oomoo`0bOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06
Ool00`00Oomoo`1<Ool00gn0Oomoo`0]Ool002Eoo`03Oh1oogoo039oo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo00Ioo`03001oogoo04]oo`03Oh1oogoo02ioo`009Goo00=oP7ooOol0<goo
100037oo1@0017oo00<007ooOol0Bgoo00=oP7ooOol0;Woo000UOol00gn0Oomoo`1<Ool00`00Oomo
o`1;Ool00gn0Oomoo`0^Ool002Ioo`03Oh1oogoo04]oo`03001oogoo04Yoo`03Oh1oogoo02moo`00
9Woo00=oP7ooOol0Bgoo00<007ooOol0BWoo00=oP7ooOol0;goo000WOol00gn0Oomoo`1:Ool00`00
Oomoo`19Ool00gn0Oomoo`0`Ool002Moo`03Oh1oogoo04Yoo`03001oogoo04Uoo`03Oh1oogoo031o
o`00:7oo00=oP7ooOol0BGoo00<007ooOol0B7oo00=oP7ooOol0<Goo000XOol00gn0Oomoo`19Ool0
0`00Oomoo`18Ool00gn0Oomoo`0aOol002Uoo`03Oh1oogoo04Qoo`03001oogoo04Moo`03Oh1oogoo
039oo`00:Goo00=oP7ooOol0B7oo00<007ooOol0Agoo00=oP7ooOol0<Woo000ZOol00gn0Oomoo`17
Ool00`00Oomoo`16Ool00gn0Oomoo`0cOol002Yoo`03Oh1oogoo04Moo`03001oogoo04Ioo`03Oh1o
ogoo03=oo`00:goo00=oP7ooOol0AWoo00<007ooOol0AGoo00=oP7ooOol0=7oo000[Ool00gn0Oomo
o`16Ool00`00Oomoo`15Ool00gn0Oomoo`0dOol002aoo`03Oh1oogoo04Eoo`03001oogoo04Aoo`03
Oh1oogoo03Eoo`00;Goo00=oP7ooOol0A7oo00<007ooOol0@goo00=oP7ooOol0=Woo000]Ool00gn0
Oomoo`14Ool00`00Oomoo`13Ool00gn0Oomoo`0fOol002ioo`03Oh1oogoo04=oo`03001oogoo049o
o`03Oh1oogoo03Moo`00;goo00=oP7ooOol0@Woo00<007ooOol0@Goo00=oP7ooOol0>7oo000_Ool0
0gn0Oomoo`12Ool00`00Oomoo`11Ool00gn0Oomoo`0hOol0031oo`03Oh1oogoo03Qoo`D000Aoo`03
001oogoo041oo`03Oh1oogoo03Uoo`00<Goo00=oP7ooOol0>Goo00<007ooOol017oo00<007ooOol0
?goo00=oP7ooOol0>Woo000bOol00gn0Oomoo`0hOol00`00Oomoo`04Ool00`00Oomoo`0nOol00gn0
Oomoo`0kOol003=oo`03Oh1oogoo03Moo`03001oogoo00Aoo`8003ioo`03Oh1oogoo03aoo`00<goo
00=oP7ooOol0=goo00<007ooOol017oo00<007ooOol0?Goo00=oP7ooOol0?7oo000dOol00gn0Oomo
o`0fOol00`00Oomoo`04Ool00`00Oomoo`0lOol00gn0Oomoo`0mOol003Eoo`03Oh1oogoo03=oo`<0
00Ioo`03001oogoo03]oo`03Oh1oogoo03ioo`00=Woo00=oP7ooOol0=7oo00<007ooOol017oo00<0
07ooOol0>Woo00=oP7ooOol0?goo000gOol00gn0Oomoo`0jOol00`00Oomoo`0iOol00gn0Oomoo`10
Ool003Qoo`03Oh1oogoo03Uoo`03001oogoo03Qoo`03Oh1oogoo045oo`00>Goo00=oP7ooOol0>7oo
00<007ooOol0>7oo00=oP7ooOol0@Goo000jOol00gn0Oomoo`0gOol00`00Oomoo`0gOol00gn0Oomo
o`12Ool003]oo`03Oh1oogoo03Ioo`03001oogoo03Ioo`03Oh1oogoo04=oo`00?7oo00=oP7ooOol0
=Goo00<007ooOol0=Goo00=oP7ooOol0A7oo000mOol00gn0Oomoo`0dOol00`00Oomoo`0dOol00gn0
Oomoo`15Ool003ioo`9oP3Aoo`03001oogoo039oo`9oP4Qoo`00@7oo00=oP7ooOol0<Goo00<007oo
Ool0<Goo00=oP7ooOol0B7oo0011Ool00gn0Oomoo`0`Ool00`00Oomoo`0`Ool00gn0Oomoo`19Ool0
049oo`9oP31oo`03001oogoo02ioo`9oP4aoo`00A7oo00=oP7ooOol0;Goo00<007ooOol0;7oo0Wn0
CWoo0015Ool2Oh0]Ool00`00Oomoo`0ZOol2Oh1@Ool004Moo`03Oh1oogoo02Yoo`03001oogoo02Uo
o`03Oh1oogoo051oo`00B7oo0Wn0:Woo00<007ooOol09goo0Wn0Dgoo001:Ool2Oh0XOol00`00Oomo
o`0UOol2Oh1EOol004aoo`9oP2Ioo`03001oogoo02=oo`9oP5Moo`00CWoo0Wn097oo00<007ooOol0
8Goo0Wn0FGoo001@Ool2Oh0ROol00`00Oomoo`0OOol2Oh1KOol0059oo`9oP0Moo`D000Aoo`8000Eo
o`@000Eoo`03001oogoo01eoo`9oP5eoo`00E7oo0gn01Woo00<007ooOol017oo0P0017oo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol06Woo0gn0Ggoo001GOol4Oh02Ool00`00Oomoo`0?Ool0
0`00Oomoo`02Ool00`00Oomoo`0FOol4Oh1ROol005]oo`AoP11oo`03001oogoo009oo`8001Aoo`=o
P6Ioo`00GGoo00<007ooOh000gn027oo10001Goo00<007ooOol03goo17n0JGoo001MOol00`00Oomo
o`03Ool5Oh03Ool00`00Oomoo`06Ool00`00Oomoo`09Ool6Oh1]Ool005]oo`<000Yoo`QoP0Aoo`04
001oogooOol8Oh1cOol005eoo`03001oogoo00]oo`D000QoP7]oo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001ZOol50005Ool00`00Oomoo`1lOol006Yoo`05001oogooOol00005Ool00`00Oomoo`1lOol0
06]oo`03001oogoo00Ioo`03001oogoo07aoo`00K7oo00<007ooOol01Goo0P00OGoo001]Ool00`00
Oomoo`23Ool006ioo`03001oogoo089oo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo0`00QGoo003c
Ool00?=oo`00lgoo003cOol0095oo`<000]oo`D000Aoo`8000Eoo`D000=oo`@003Qoo`00T7oo00H0
07ooOomoo`00Ool60005Ool00`00Oomoo`04Ool20007Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`0eOol007=oo`800003Ool0000001Qoo`03001oogoo00ioo`03001oogoo00eoo`03001o
ogoo00Moo`03001oogoo03Eoo`00LWoo00<007ooOol00P006Goo00<007ooOol00goo1P001Goo00<0
07ooOol03Goo00<007ooOol01goo00<007ooOol0=Goo001bOol01@00Oomoogoo00006Goo00<007oo
Ool03Woo00<007ooOol03Goo00<007ooOol00goo1000>7oo001bOol01@00Oomoogoo000067oo1@00
3Goo00<007ooOol03Goo00<007ooOol00goo00<007ooOol0>Goo001bOol01@00Oomoogoo00006Goo
00<007ooOol037oo0`003Goo0`001Goo00<007ooOol0>Goo001aOol20002Ool2000ZOol00`00Oomo
o`0=Ool00`00Oomoo`03Ool5000gOol00?=oo`00lgoo003cOol00?=oo`00lgoo0000\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.1) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 .6 0 r

.5 Mabswid

.12086 .49991 m

.12247 .46502 L

.12731 .43033 L

.13533 .39624 L

.14646 .36304 L

.1606 .331 L

.17765 .30041 L

.19744 .27151 L

.21981 .24457 L

.24457 .21981 L

.27151 .19744 L

.30041 .17765 L

.331 .1606 L

.36304 .14646 L

.39624 .13533 L

.43033 .12731 L

.46502 .12247 L

.5 .12086 L

.53498 .12247 L

.56967 .12731 L

.60376 .13533 L

.63696 .14646 L

.669 .1606 L

.69959 .17765 L

.72849 .19744 L

.75543 .21981 L

.78019 .24457 L

.80256 .27151 L

.82235 .30041 L

.8394 .331 L

.85354 .36304 L

.86467 .39624 L

.87269 .43033 L

.87753 .46502 L

.87914 .49991 L

s

.12086 .50009 m

.12247 .53498 L

.12731 .56967 L

.13533 .60376 L

.14646 .63696 L

.1606 .669 L

.17765 .69959 L

.19744 .72849 L

.21981 .75543 L

.24457 .78019 L

.27151 .80256 L

.30041 .82235 L

.331 .8394 L

.36304 .85354 L

.39624 .86467 L

.43033 .87269 L

.46502 .87753 L

.5 .87914 L

.53498 .87753 L

.56967 .87269 L

.60376 .86467 L

.63696 .85354 L

.669 .8394 L

.69959 .82235 L

.72849 .80256 L

.75543 .78019 L

.78019 .75543 L

.80256 .72849 L

.82235 .69959 L

.8394 .669 L

.85354 .63696 L

.86467 .60376 L

.87269 .56967 L

.87753 .53498 L

.87914 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogi000In@7]oo`00DWoo1P001Goo00<007ooOol02Goo
27i00goo0P000Woo1gi0M7oo001MOol00`00Oomoo`04Ool5OT02Ool40005Ool00`00Oomoo`08Ool6
OT1^Ool005eoo`03001oogoo00An@0Moo`03001oogoo00Ioo`03001oogoo00ioo`An@6Yoo`00Fgoo
00<007i0OT000Wi02goo00<007ooOol01Woo00<007ooOol04Woo0gi0Igoo001HOol4OT000goo001o
o`0<Ool50004Ool00`00Oomoo`0EOol4OT1SOol005Eoo`=n@1aoo`03001oogoo01Uoo`=n@61oo`00
Dgoo0Wi07goo00<007ooOol077oo0Wi0GWoo001AOol2OT0QOol00`00Oomoo`0NOol2OT1LOol004mo
o`9n@2=oo`03001oogoo021oo`9n@5Yoo`00CGoo0Wi09Goo00<007ooOol08Woo0Wi0F7oo001<Ool0
0gi0Oomoo`0UOol00`00Oomoo`0TOol2OT1FOol004Yoo`9n@2Qoo`03001oogoo02Ioo`9n@5Aoo`00
BGoo00=n@7ooOol0:7oo00<007ooOol0:7oo00=n@7ooOol0DGoo0017Ool2OT0[Ool00`00Oomoo`0Y
Ool2OT1AOol004Eoo`9n@2eoo`03001oogoo02]oo`03OT1oogoo04ioo`00@goo0Wi0;goo00<007oo
Ool0;7oo0Wi0CWoo0012Ool00gi0Oomoo`0_Ool00`00Oomoo`0^Ool00gi0Oomoo`1;Ool0045oo`03
OT1oogoo031oo`03001oogoo02moo`03OT1oogoo04Yoo`00@7oo00=n@7ooOol0<Goo00<007ooOol0
<7oo00=n@7ooOol0BGoo000oOol00gi0Oomoo`0bOol00`00Oomoo`0aOol2OT19Ool003ioo`03OT1o
ogoo03=oo`03001oogoo03=oo`03OT1oogoo04Ioo`00?Goo00=n@7ooOol0=7oo00<007ooOol0=7oo
00=n@7ooOol0AGoo000lOol00gi0Oomoo`0eOol00`00Oomoo`0eOol00gi0Oomoo`14Ool003]oo`03
OT1oogoo03Ioo`03001oogoo03Ioo`03OT1oogoo04=oo`00>Goo0Wi0<7oo1@0017oo00<007ooOol0
=goo00=n@7ooOol0@Woo000hOol00gi0Oomoo`0bOol00`00Oomoo`04Ool00`00Oomoo`0hOol00gi0
Oomoo`11Ool003Moo`03OT1oogoo03=oo`03001oogoo00Aoo`03001oogoo03Uoo`03OT1oogoo041o
o`00=Woo00=n@7ooOol0:Goo1P001Goo00<007ooOol017oo0P00>goo00=n@7ooOol0?goo000eOol0
0gi0Oomoo`0eOol00`00Oomoo`04Ool00`00Oomoo`0kOol00gi0Oomoo`0nOol003Aoo`03OT1oogoo
03Ioo`03001oogoo00Aoo`03001oogoo03aoo`03OT1oogoo03eoo`00=7oo00=n@7ooOol0=7oo0`00
1Woo00<007ooOol0?7oo00=n@7ooOol0?Goo000cOol00gi0Oomoo`0gOol00`00Oomoo`04Ool00`00
Oomoo`0mOol00gi0Oomoo`0lOol0039oo`03OT1oogoo03moo`03001oogoo03ioo`03OT1oogoo03]o
o`00<Goo00=n@7ooOol0@7oo00<007ooOol0?goo00=n@7ooOol0>Woo000aOol00gi0Oomoo`10Ool0
0`00Oomoo`0oOol00gi0Oomoo`0jOol0031oo`03OT1oogoo045oo`03001oogoo041oo`03OT1oogoo
03Uoo`00;goo00=n@7ooOol0@Woo00<007ooOol0@Goo00=n@7ooOol0>7oo000_Ool00gi0Oomoo`12
Ool00`00Oomoo`11Ool00gi0Oomoo`0hOol002ioo`03OT1oogoo04=oo`03001oogoo049oo`03OT1o
ogoo03Moo`00;Goo00=n@7ooOol0A7oo00<007ooOol0@goo00=n@7ooOol0=Woo000]Ool00gi0Oomo
o`14Ool00`00Oomoo`13Ool00gi0Oomoo`0fOol002aoo`03OT1oogoo04Eoo`03001oogoo04Aoo`03
OT1oogoo03Eoo`00;7oo00=n@7ooOol0AGoo00<007ooOol0A7oo00=n@7ooOol0=Goo000[Ool00gi0
Oomoo`16Ool00`00Oomoo`15Ool00gi0Oomoo`0dOol002]oo`03OT1oogoo04Ioo`03001oogoo04Eo
o`03OT1oogoo03Aoo`00:Woo00=n@7ooOol0Agoo00<007ooOol0AWoo00=n@7ooOol0<goo000ZOol0
0gi0Oomoo`17Ool00`00Oomoo`16Ool00gi0Oomoo`0cOol002Uoo`03OT1oogoo04Qoo`03001oogoo
04Moo`03OT1oogoo039oo`00:Goo00=n@7ooOol0B7oo00<007ooOol0Agoo00=n@7ooOol0<Woo000X
Ool00gi0Oomoo`19Ool00`00Oomoo`18Ool00gi0Oomoo`0aOol002Qoo`03OT1oogoo04Uoo`03001o
ogoo04Qoo`03OT1oogoo035oo`009goo00=n@7ooOol0<Goo10001Goo0P001Goo10001Goo00<007oo
Ool0BGoo00=n@7ooOol0<7oo000WOol00gi0Oomoo`0`Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2
0004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`19Ool00gi0Oomoo`0`Ool002Moo`03
OT1oogoo031oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo04Uoo`03
OT1oogoo031oo`009Woo00=n@7ooOol0:Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol00Woo0P00Bgoo00=n@7ooOol0;goo000VOol00gi0Oomoo`0aOol00`00Oomoo`02Ool00`00
Oomoo`09Ool40005Ool00`00Oomoo`1:Ool00gi0Oomoo`0_Ool002Ioo`03OT1oogoo035oo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo04Yoo`03OT1oogoo02moo`009Woo
00=n@7ooOol0<Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0BWoo
00=n@7ooOol0;goo000UOol00gi0Oomoo`0cOol4000<Ool50004Ool00`00Oomoo`1;Ool00gi0Oomo
o`0^Ool002Eoo`03OT1oogoo04aoo`03001oogoo04]oo`03OT1oogoo02ioo`009Goo00=n@7ooOol0
C7oo00<007ooOol0Bgoo00=n@7ooOol0;Woo000TOol00gi0Oomoo`1=Ool00`00Oomoo`1<Ool00gi0
Oomoo`0]Ool002Aoo`03OT1oogoo04eoo`03001oogoo04aoo`03OT1oogoo02eoo`0097oo00=n@7oo
Ool0CGoo00<007ooOol0C7oo00=n@7ooOol0;Goo000TOol00gi0Oomoo`1=Ool00`00Oomoo`1<Ool0
0gi0Oomoo`0]Ool002=oo`03OT1oogoo04ioo`03001oogoo04eoo`03OT1oogoo02aoo`008goo00=n
@7ooOol0CWoo00<007ooOol0CGoo00=n@7ooOol0;7oo0009Ool5000?Ool5000017ooOT1oogoo0P00
1Goo10003goo1@003Woo10001Goo0P001Goo10003Goo00<007ooOol03Woo10001Goo0P001Goo1000
3goo1@003Woo1@0017oo00=n@000Ool017oo10003Woo1@004Goo0009Ool01@00Oomoogoo00004Goo
00D007ooOomoogi0009oo`8000Aoo`03001oogoo009oo`03001oogoo00ioo`03001oogoo00eoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo
00eoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00ioo`03
001oogoo011oo`03001oogoo00Aoo`03OT0007oo00=oo`03001oogoo009oo`03001oogoo00]oo`05
001oogooOol0000AOol000Yoo`03001oogoo019oo`05001oogooOomn@00=Ool00`00Oomoo`0>Ool0
0`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool0
0gi0Oomoo`08Ool00`00Oomoo`0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo
00Ioo`H000Eoo`04001oogooOT0>Ool00`00Oomoo`03Ool60005Ool00`00Oomoo`05Ool60002Ool0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`05Ool00gi0Oomoo`07Ool0
0`00Oomoo`0=Ool00`00Oomoo`0AOol000aoo`03001oogoo011oo`04001oogooOT0:Ool4000AOol0
0`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool4000=Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool4000AOol00`00Oomoo`0@Ool00`00Oomoo`05Ool00gi0Oomoo`03Ool4
000AOol00`00Oomoo`0@Ool000eoo`03001oogoo00moo`04001oogooOT0:Ool00`00Oomoo`0BOol0
0`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0BOol00`00Oomoo`0@Ool00`00Oomoo`05Ool0
0gi0Oomoo`03Ool00`00Oomoo`0COol00`00Oomoo`0?Ool000Uoo`05001oogooOol0000?Ool30002
Ool00gi0Oomoo`08Ool00`00Oomoo`0@Ool3000?Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00
Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0@Ool3000@
Ool30007Ool00gi0Oomoo`03Ool00`00Oomoo`0?Ool01@00Oomoogoo00004Goo000:Ool3000BOol0
1000Oomoogi02Woo1@0047oo00<007ooOol03Woo100037oo1@0037oo00<007ooOol03Woo100037oo
1@0047oo00<007ooOol047oo00<007ooOol01Goo00=n@7ooOol00goo1@003Woo0`004Woo000ROol0
0gi0Oomoo`1?Ool00`00Oomoo`1>Ool00gi0Oomoo`0[Ool0029oo`03OT1oogoo04moo`03001oogoo
04ioo`03OT1oogoo02]oo`008Woo00=n@7ooOol0Cgoo00<007ooOol0CWoo00=n@7ooOol0:goo000R
Ool00gi0Oomoo`1?Ool00`00Oomoo`1>Ool00gi0Oomoo`0[Ool0029oo`03OT1oogoo04moo`03001o
ogoo04ioo`03OT1oogoo021oo`80009oo`8000Eoo`008Woo00=n@7ooOol0Cgoo00<007ooOol0CWoo
00=n@7ooOol08Goo00@007ooOol000Ioo`0027oo6P0000=n@0000000X00000=n@00000006@002Goo
0P001goo0008Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool00gi0001oo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00gi0Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`07Ool20007Ool000Qoo`03001oogoo01Moo`03OT0007oo01Uoo`03
001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03
OT1oogoo01Qoo`03001oogoo00Ioo`04001oogoo0006Ool0029oo`03OT1oogoo04moo`03001oogoo
04ioo`03OT1oogoo021oo`80009oo`8000Eoo`008Woo00=n@7ooOol0Cgoo00<007ooOol0CWoo00=n
@7ooOol0:goo000ROol00gi0Oomoo`1?Ool00`00Oomoo`1>Ool00gi0Oomoo`0[Ool0029oo`03OT1o
ogoo04moo`03001oogoo04ioo`03OT1oogoo02]oo`008Woo00=n@7ooOol0Cgoo00<007ooOol0CWoo
00=n@7ooOol0:goo000ROol00gi0Oomoo`1?Ool00`00Oomoo`1>Ool00gi0Oomoo`0[Ool0029oo`03
OT1oogoo04moo`03001oogoo04ioo`03OT1oogoo02]oo`008Woo00=n@7ooOol0Cgoo00<007ooOol0
CWoo00=n@7ooOol0:goo000ROol00gi0Oomoo`1?Ool00`00Oomoo`1>Ool00gi0Oomoo`0[Ool002=o
o`03OT1oogoo04ioo`03001oogoo04eoo`03OT1oogoo02aoo`008goo00=n@7ooOol0CWoo00<007oo
Ool0CGoo00=n@7ooOol0;7oo000SOol00gi0Oomoo`1>Ool00`00Oomoo`1=Ool00gi0Oomoo`0/Ool0
02=oo`03OT1oogoo04ioo`03001oogoo04eoo`03OT1oogoo02aoo`008goo00=n@7ooOol0CWoo00<0
07ooOol0CGoo00=n@7ooOol0;7oo000TOol00gi0Oomoo`1=Ool00`00Oomoo`1<Ool00gi0Oomoo`0]
Ool002Aoo`03OT1oogoo04eoo`03001oogoo04aoo`03OT1oogoo02eoo`0097oo00=n@7ooOol0CGoo
00<007ooOol0C7oo00=n@7ooOol0;Goo000TOol00gi0Oomoo`1=Ool00`00Oomoo`1<Ool00gi0Oomo
o`0]Ool002Eoo`03OT1oogoo04aoo`03001oogoo04]oo`03OT1oogoo02ioo`009Goo00=n@7ooOol0
C7oo00<007ooOol0Bgoo00=n@7ooOol0;Woo000UOol00gi0Oomoo`1<Ool00`00Oomoo`1;Ool00gi0
Oomoo`0^Ool002Eoo`03OT1oogoo03=oo`@000Eoo`8000Eoo`@000Eoo`03001oogoo04]oo`03OT1o
ogoo02ioo`009Woo00=n@7ooOol0<Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0BWoo00=n@7ooOol0;goo000VOol00gi0Oomoo`0aOol0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`1:Ool00gi0Oomoo`0_Ool0
02Ioo`03OT1oogoo035oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`8004]oo`03
OT1oogoo02moo`009Woo00=n@7ooOol0<Goo00<007ooOol00Woo00<007ooOol02Goo10001Goo00<0
07ooOol0BWoo00=n@7ooOol0;goo000WOol00gi0Oomoo`0`Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`06Ool00`00Oomoo`19Ool00gi0Oomoo`0`Ool002Moo`03OT1oogoo031oo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo04Uoo`03OT1oogoo031oo`009goo
00=n@7ooOol0<Goo100037oo1@0017oo00<007ooOol0BGoo00=n@7ooOol0<7oo000XOol00gi0Oomo
o`19Ool00`00Oomoo`18Ool00gi0Oomoo`0aOol002Qoo`03OT1oogoo04Uoo`03001oogoo04Qoo`03
OT1oogoo035oo`00:Goo00=n@7ooOol0B7oo00<007ooOol0Agoo00=n@7ooOol0<Woo000YOol00gi0
Oomoo`18Ool00`00Oomoo`17Ool00gi0Oomoo`0bOol002Yoo`03OT1oogoo04Moo`03001oogoo04Io
o`03OT1oogoo03=oo`00:Woo00=n@7ooOol0Agoo00<007ooOol0AWoo00=n@7ooOol0<goo000[Ool0
0gi0Oomoo`16Ool00`00Oomoo`15Ool00gi0Oomoo`0dOol002]oo`03OT1oogoo04Ioo`03001oogoo
04Eoo`03OT1oogoo03Aoo`00;7oo00=n@7ooOol0AGoo00<007ooOol0A7oo00=n@7ooOol0=Goo000]
Ool00gi0Oomoo`14Ool00`00Oomoo`13Ool00gi0Oomoo`0fOol002eoo`03OT1oogoo04Aoo`03001o
ogoo04=oo`03OT1oogoo03Ioo`00;Woo00=n@7ooOol0@goo00<007ooOol0@Woo00=n@7ooOol0=goo
000_Ool00gi0Oomoo`12Ool00`00Oomoo`11Ool00gi0Oomoo`0hOol002moo`03OT1oogoo049oo`03
001oogoo045oo`03OT1oogoo03Qoo`00<7oo00=n@7ooOol0@Goo00<007ooOol0@7oo00=n@7ooOol0
>Goo000aOol00gi0Oomoo`10Ool00`00Oomoo`0oOol00gi0Oomoo`0jOol0035oo`03OT1oogoo041o
o`03001oogoo03moo`03OT1oogoo03Yoo`00<Woo00=n@7ooOol0?goo00<007ooOol0?Woo00=n@7oo
Ool0>goo000cOol00gi0Oomoo`0nOol00`00Oomoo`0mOol00gi0Oomoo`0lOol003Aoo`03OT1oogoo
03Aoo`D000Aoo`03001oogoo03aoo`03OT1oogoo03eoo`00=Goo00=n@7ooOol0=Goo00<007ooOol0
17oo00<007ooOol0>goo00=n@7ooOol0?Woo000eOol00gi0Oomoo`0eOol00`00Oomoo`04Ool00`00
Oomoo`0kOol00gi0Oomoo`0nOol003Ioo`03OT1oogoo03Aoo`03001oogoo00Aoo`8003]oo`03OT1o
ogoo03moo`00=goo00=n@7ooOol0<goo00<007ooOol017oo00<007ooOol0>Goo00=n@7ooOol0@7oo
000hOol00gi0Oomoo`0bOol00`00Oomoo`04Ool00`00Oomoo`0hOol00gi0Oomoo`11Ool003Uoo`03
OT1oogoo02moo`<000Ioo`03001oogoo03Moo`03OT1oogoo049oo`00>Woo00=n@7ooOol0<7oo00<0
07ooOol017oo00<007ooOol0=Woo00=n@7ooOol0@goo000kOol00gi0Oomoo`0fOol00`00Oomoo`0f
Ool00gi0Oomoo`13Ool003aoo`03OT1oogoo03Eoo`03001oogoo03Eoo`03OT1oogoo04Aoo`00?Goo
00=n@7ooOol0=7oo00<007ooOol0=7oo00=n@7ooOol0AGoo000nOol00gi0Oomoo`0cOol00`00Oomo
o`0bOol2OT18Ool003moo`9n@3=oo`03001oogoo035oo`03OT1oogoo04Qoo`00@Goo00=n@7ooOol0
<7oo00<007ooOol0;goo0Wi0Bgoo0012Ool00gi0Oomoo`0_Ool00`00Oomoo`0^Ool00gi0Oomoo`1;
Ool004=oo`9n@2moo`03001oogoo02eoo`03OT1oogoo04aoo`00AGoo00=n@7ooOol0;7oo00<007oo
Ool0;7oo00=n@7ooOol0CGoo0016Ool00gi0Oomoo`0[Ool00`00Oomoo`0ZOol2OT1@Ool004Moo`9n
@2]oo`03001oogoo02Uoo`03OT1oogoo051oo`00BGoo00=n@7ooOol0:7oo00<007ooOol09goo0Wi0
Dgoo001:Ool2OT0XOol00`00Oomoo`0UOol2OT1EOol004aoo`9n@2Ioo`03001oogoo02=oo`9n@5Mo
o`00CWoo0gi08goo00<007ooOol087oo0gi0FGoo001AOol2OT0QOol00`00Oomoo`0NOol2OT1LOol0
05=oo`9n@1moo`03001oogoo01aoo`9n@5ioo`00EGoo0gi077oo00<007ooOol06Goo0gi0H7oo001H
Ool2OT0JOol00`00Oomoo`0GOol2OT1SOol005Yoo`9n@0@000Aoo`8000Eoo`@000Eoo`03001oogoo
01Eoo`9n@6Eoo`00G7oo0gi01Goo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
4Woo0gi0Igoo001MOol00`00Oomn@003OT0<Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool4OT1ZOol0
05eoo`03001oogoo00=oo`In@0Ioo`03001oogoo009oo`8000Yoo`En@6ioo`00GGoo00<007ooOol0
2Goo5gi0Lgoo001MOol00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`1lOol005]oo`<000eo
o`03001oogoo00Ioo`03001oogoo07aoo`00GGoo00<007ooOol02goo1@0017oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol006Yoo`D000Eoo`03001oogoo07aoo`00JWoo00D007ooOomo
o`0000Eoo`03001oogoo07aoo`00Jgoo00<007ooOol01Woo00<007ooOol0O7oo001/Ool00`00Oomo
o`05Ool2001mOol006eoo`03001oogoo08=oo`00KWoo00<007ooOol0PWoo001ZOol01@00Oomoogoo
0000Q7oo001[Ool30025Ool00?=oo`00lgoo003cOol00?=oo`00UGoo0`002goo1@0017oo0P001Goo
1@00>goo002DOol01P00Oomoogoo001oo`H000Eoo`03001oogoo00Aoo`8000Moo`03001oogoo03]o
o`00Lgoo0P0000=oo`00000077oo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol0>goo001b
Ool00`00Oomoo`02000MOol00`00Oomoo`03Ool60005Ool00`00Oomoo`0=Ool00`00Oomoo`0kOol0
079oo`05001oogooOol0000MOol00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`0kOol0079o
o`05001oogooOol0000LOol5000=Ool00`00Oomoo`0=Ool00`00Oomoo`0kOol0079oo`05001oogoo
Ool0000MOol00`00Oomoo`0<Ool3000=Ool3000mOol0075oo`80009oo`8002ioo`03001oogoo00eo
o`03001oogoo03]oo`00lgoo003cOol00?=oo`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.05) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 .3 0 r

.5 Mabswid

.13343 .49991 m

.13499 .46618 L

.13967 .43264 L

.14742 .39968 L

.15818 .36758 L

.17186 .3366 L

.18833 .30702 L

.20747 .27909 L

.2291 .25304 L

.25304 .2291 L

.27909 .20747 L

.30702 .18833 L

.3366 .17186 L

.36758 .15818 L

.39968 .14742 L

.43264 .13967 L

.46618 .13499 L

.5 .13343 L

.53382 .13499 L

.56736 .13967 L

.60032 .14742 L

.63242 .15818 L

.6634 .17186 L

.69298 .18833 L

.72091 .20747 L

.74696 .2291 L

.7709 .25304 L

.79253 .27909 L

.81167 .30702 L

.82814 .3366 L

.84182 .36758 L

.85258 .39968 L

.86033 .43264 L

.86501 .46618 L

.86657 .49991 L

s

.13343 .50009 m

.13499 .53382 L

.13967 .56736 L

.14742 .60032 L

.15818 .63242 L

.17186 .6634 L

.18833 .69298 L

.20747 .72091 L

.2291 .74696 L

.25304 .7709 L

.27909 .79253 L

.30702 .81167 L

.3366 .82814 L

.36758 .84182 L

.39968 .85258 L

.43264 .86033 L

.46618 .86501 L

.5 .86657 L

.53382 .86501 L

.56736 .86033 L

.60032 .85258 L

.63242 .84182 L

.6634 .82814 L

.69298 .81167 L

.72091 .79253 L

.74696 .7709 L

.7709 .74696 L

.79253 .72091 L

.81167 .69298 L

.82814 .6634 L

.84182 .63242 L

.85258 .60032 L

.86033 .56736 L

.86501 .53382 L

.86657 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00UooaIm87Aoo`00Fgoo0`001Woo1GdP0Woo00<007ooOol01Woo00<007oo
Ool027oo1GdPKgoo001MOol00`00Oomoo`04OB07Ool50004Ool00`00Oomoo`0=Ool4OB1[Ool005eo
o`=m81Aoo`03001oogoo015oo`=m86Qoo`00FGoo17dP5goo00<007ooOol057oo17dPI7oo001FOol3
OB0KOol00`00Oomoo`0HOol3OB1QOol005Aoo`9m81ioo`03001oogoo01]oo`9m85moo`00DWoo0WdP
87oo00<007ooOol07Goo0WdPGGoo001@Ool2OB0ROol00`00Oomoo`0OOol2OB1KOol004ioo`9m82Ao
o`03001oogoo025oo`9m85Uoo`00CGoo00=m87ooOol097oo00<007ooOol08goo00=m87ooOol0EWoo
001;Ool2OB0WOol00`00Oomoo`0TOol2OB1FOol004Yoo`03OB1oogoo02Moo`03001oogoo02Ioo`03
OB1oogoo05=oo`00B7oo0WdP:Woo00<007ooOol09goo0WdPDgoo0017Ool00gdPOomoo`0ZOol00`00
Oomoo`0YOol00gdPOomoo`1@Ool004Eoo`9m82eoo`03001oogoo02Yoo`9m851oo`00A7oo00=m87oo
Ool0;Goo00<007ooOol0;7oo00=m87ooOol0CGoo0013Ool00gdPOomoo`0^Ool00`00Oomoo`0]Ool0
0gdPOomoo`1<Ool0049oo`03OB1oogoo02moo`03001oogoo02ioo`03OB1oogoo04]oo`00@7oo0WdP
<Woo00<007ooOol0;goo0WdPBgoo000oOol00gdPOomoo`0bOol00`00Oomoo`0aOol00gdPOomoo`18
Ool003ioo`03OB1oogoo03=oo`03001oogoo039oo`03OB1oogoo04Moo`00?Goo00=m87ooOol0:goo
1@0017oo00<007ooOol0<goo00=m87ooOol0AWoo000lOol00gdPOomoo`0^Ool00`00Oomoo`04Ool0
0`00Oomoo`0dOol00gdPOomoo`15Ool003]oo`03OB1oogoo02moo`03001oogoo00Aoo`03001oogoo
03Eoo`03OB1oogoo04Aoo`00>Woo00=m87ooOol09Goo1P001Goo00<007ooOol017oo0P00=goo00=m
87ooOol0@goo000iOol00gdPOomoo`0aOol00`00Oomoo`04Ool00`00Oomoo`0gOol00gdPOomoo`12
Ool003Qoo`03OB1oogoo039oo`03001oogoo00Aoo`03001oogoo03Qoo`03OB1oogoo045oo`00>7oo
00=m87ooOol0<7oo0`001Woo00<007ooOol0>Goo00=m87ooOol0@7oo000gOol00gdPOomoo`0cOol0
0`00Oomoo`04Ool00`00Oomoo`0jOol00gdPOomoo`0oOol003Ioo`03OB1oogoo03]oo`03001oogoo
03Yoo`03OB1oogoo03moo`00=Woo00=m87ooOol0>goo00<007ooOol0>goo00=m87ooOol0?Woo000e
Ool00gdPOomoo`0lOol00`00Oomoo`0lOol00gdPOomoo`0mOol003Aoo`03OB1oogoo03eoo`03001o
ogoo03eoo`03OB1oogoo03aoo`00<goo00=m87ooOol0?Woo00<007ooOol0?Goo00=m87ooOol0?7oo
000bOol00gdPOomoo`0oOol00`00Oomoo`0nOol00gdPOomoo`0kOol0039oo`03OB1oogoo03moo`03
001oogoo03moo`03OB1oogoo03Yoo`00<Goo00=m87ooOol0@7oo00<007ooOol0?goo00=m87ooOol0
>Woo000`Ool00gdPOomoo`11Ool00`00Oomoo`10Ool00gdPOomoo`0iOol002moo`03OB1oogoo049o
o`03001oogoo045oo`03OB1oogoo03Qoo`00;goo00=m87ooOol0@Woo00<007ooOol0@Goo00=m87oo
Ool0>7oo000^Ool00gdPOomoo`13Ool00`00Oomoo`12Ool00gdPOomoo`0gOol002ioo`03OB1oogoo
04=oo`03001oogoo049oo`03OB1oogoo03Moo`00;Goo00=m87ooOol0A7oo00<007ooOol0@goo00=m
87ooOol0=Woo000]Ool00gdPOomoo`14Ool00`00Oomoo`13Ool00gdPOomoo`0fOol002eoo`03OB1o
ogoo04Aoo`03001oogoo04=oo`03OB1oogoo03Ioo`00;7oo00=m87ooOol0AGoo00<007ooOol0A7oo
00=m87ooOol0=Goo000/Ool00gdPOomoo`15Ool00`00Oomoo`14Ool00gdPOomoo`0eOol002]oo`03
OB1oogoo04Ioo`03001oogoo04Eoo`03OB1oogoo03Aoo`00:goo00=m87ooOol0;Goo10001Goo0P00
1Goo10001Goo00<007ooOol0AGoo00=m87ooOol0=7oo000ZOol00gdPOomoo`0]Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`16Ool00gdP
Oomoo`0cOol002Yoo`03OB1oogoo02eoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009o
o`03001oogoo04Ioo`03OB1oogoo03=oo`00:Woo00=m87ooOol09Goo1P000Woo00<007ooOol00Woo
00<007ooOol03Goo00<007ooOol00Woo0P00Agoo00=m87ooOol0<goo000YOol00gdPOomoo`0^Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`17Ool00gdPOomoo`0bOol002Uoo`03
OB1oogoo02ioo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo04Moo`03
OB1oogoo039oo`00:Goo00=m87ooOol0;Woo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
1Woo00<007ooOol0B7oo00=m87ooOol0<Goo000YOol00gdPOomoo`0_Ool4000<Ool50004Ool00`00
Oomoo`18Ool00gdPOomoo`0aOol002Qoo`03OB1oogoo04Uoo`03001oogoo04Uoo`03OB1oogoo031o
o`00:7oo00=m87ooOol0BGoo00<007ooOol0BGoo00=m87ooOol0<7oo000XOol00gdPOomoo`19Ool0
0`00Oomoo`19Ool00gdPOomoo`0`Ool002Moo`03OB1oogoo04Yoo`03001oogoo04Uoo`03OB1oogoo
031oo`009goo00=m87ooOol0BWoo00<007ooOol0BGoo00=m87ooOol0<7oo000WOol00gdPOomoo`1:
Ool00`00Oomoo`1:Ool00gdPOomoo`0_Ool002Moo`03OB1oogoo04Yoo`03001oogoo04Yoo`03OB1o
ogoo02moo`009Woo00=m87ooOol0Bgoo00<007ooOol0BWoo00=m87ooOol0;goo0009Ool5000?Ool5
0004Ool00gdP001oo`04Ool4000?Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool4
0005Ool20005Ool4000?Ool5000>Ool5000017ooOB1oogoo0P001Goo10003Woo1@004Goo0009Ool0
1@00Oomoogoo00004Goo00<007ooOol017oo00=m8000Ool00goo00<007ooOol00Woo00<007ooOol0
3Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<0
07ooOol02Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol0
0Woo00<007ooOol03Woo00<007ooOol047oo00D007ooOomoogdP009oo`8000Aoo`03001oogoo009o
o`03001oogoo00]oo`05001oogooOol0000AOol000Yoo`03001oogoo019oo`03001oogoo00Aoo`03
OB1oogoo00Qoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00eoo`03
001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00ioo`03
001oogoo011oo`05001oogooOomm800=Ool00`00Oomoo`0<Ool00`00Oomoo`0BOol00003Ool00000
00@000Aoo`03001oogoo00Ioo`H000Eoo`03001oogoo00Aoo`03OB1oogoo00Qoo`03001oogoo00=o
o`H000Eoo`03001oogoo00Eoo`H0009oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00Yo
o`03001oogoo00eoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00ioo`03001oogoo011o
o`05001oogooOomm800=Ool00`00Oomoo`0=Ool00`00Oomoo`0AOol000aoo`03001oogoo011oo`03
001oogoo00=oo`03OB1oogoo00Eoo`@0015oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo
00Uoo`@000eoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@0015oo`03001oogoo
011oo`03001oogoo009oo`03OB1oogoo00Ioo`@0015oo`03001oogoo011oo`003Goo00<007ooOol0
3goo00<007ooOol00goo00=m87ooOol01Goo00<007ooOol04Woo00<007ooOol03Goo00<007ooOol0
0Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0
2Goo00<007ooOol04Woo00<007ooOol047oo00<007ooOol00Woo00=m87ooOol01Woo00<007ooOol0
4goo00<007ooOol03goo0009Ool01@00Oomoogoo00003goo0`001Goo00=m87ooOol01Goo00<007oo
Ool047oo0`003goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol047oo0`0047oo0`0017oo00=m87ooOol01Woo
00<007ooOol03goo00D007ooOomoo`00015oo`002Woo0`004Woo00<007ooOol00goo00=m87ooOol0
1Goo1@0047oo00<007ooOol03Woo100037oo1@0037oo00<007ooOol03Woo100037oo1@0047oo00<0
07ooOol047oo00<007ooOol00Woo00=m87ooOol01Woo1@003Woo0`004Woo000UOol00gdPOomoo`1<
Ool00`00Oomoo`1;Ool00gdPOomoo`0^Ool002Eoo`03OB1oogoo04aoo`03001oogoo04]oo`03OB1o
ogoo02ioo`009Goo00=m87ooOol0C7oo00<007ooOol0Bgoo00=m87ooOol0;Woo000UOol00gdPOomo
o`1<Ool00`00Oomoo`1<Ool00gdPOomoo`0]Ool002Eoo`03OB1oogoo04aoo`03001oogoo04aoo`03
OB1oogoo029oo`80009oo`8000Eoo`009Goo00=m87ooOol0C7oo00<007ooOol0C7oo00=m87ooOol0
8goo00@007ooOol000Ioo`0027oo7@0000=m80000000V`0000=m800000006`002Goo0P001goo0008
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomm8002Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01`00Oomoogoo
OB1oo`0000Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03
001oogoo00Moo`8000Moo`0027oo00<007ooOol067oo00<007ooOB0067oo00<007ooOol067oo00<0
07ooOol067oo00<007ooOol067oo00<007ooOol067oo00<007ooOol05Woo00=m87oo00006Woo00<0
07ooOol01Woo00@007ooOol000Ioo`009Goo00=m87ooOol0C7oo00<007ooOol0C7oo00=m87ooOol0
8Woo0P000Woo0P001Goo000UOol00gdPOomoo`1<Ool00`00Oomoo`1;Ool00gdPOomoo`0^Ool002Eo
o`03OB1oogoo04aoo`03001oogoo04]oo`03OB1oogoo02ioo`009Goo00=m87ooOol0C7oo00<007oo
Ool0Bgoo00=m87ooOol0;Woo000UOol00gdPOomoo`1<Ool00`00Oomoo`1;Ool00gdPOomoo`0^Ool0
02Eoo`03OB1oogoo04aoo`03001oogoo04]oo`03OB1oogoo02ioo`009Goo00=m87ooOol0C7oo00<0
07ooOol0Bgoo00=m87ooOol0;Woo000UOol00gdPOomoo`1<Ool00`00Oomoo`1;Ool00gdPOomoo`0^
Ool002Ioo`03OB1oogoo04]oo`03001oogoo04Yoo`03OB1oogoo02moo`009Woo00=m87ooOol0Bgoo
00<007ooOol0BWoo00=m87ooOol0;goo000VOol00gdPOomoo`1;Ool00`00Oomoo`1:Ool00gdPOomo
o`0_Ool002Ioo`03OB1oogoo04]oo`03001oogoo04Yoo`03OB1oogoo02moo`009Woo00=m87ooOol0
Bgoo00<007ooOol0BWoo00=m87ooOol0;goo000VOol00gdPOomoo`1;Ool00`00Oomoo`1:Ool00gdP
Oomoo`0_Ool002Moo`03OB1oogoo04Yoo`03001oogoo04Yoo`03OB1oogoo02moo`009goo00=m87oo
Ool0BWoo00<007ooOol0BWoo00=m87ooOol0;goo000WOol00gdPOomoo`1:Ool00`00Oomoo`19Ool0
0gdPOomoo`0`Ool002Moo`03OB1oogoo04Yoo`03001oogoo04Uoo`03OB1oogoo031oo`00:7oo00=m
87ooOol0BGoo00<007ooOol0BGoo00=m87ooOol0<7oo000XOol00gdPOomoo`19Ool00`00Oomoo`19
Ool00gdPOomoo`0`Ool002Qoo`03OB1oogoo04Uoo`03001oogoo04Uoo`03OB1oogoo031oo`00:Goo
00=m87ooOol0;goo10001Goo0P001Goo10001Goo00<007ooOol0B7oo00=m87ooOol0<Goo000YOol0
0gdPOomoo`0^Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`18Ool00gdPOomoo`0aOol002Uoo`03OB1oogoo02ioo`03001oogoo009oo`03
001oogoo00eoo`03001oogoo009oo`03001oogoo04Moo`03OB1oogoo039oo`00:Goo00=m87ooOol0
;Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00B7oo00=m87ooOol0<Woo000Z
Ool00gdPOomoo`0]Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`16Ool00gdP
Oomoo`0cOol002Yoo`03OB1oogoo02eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Io
o`03001oogoo04Ioo`03OB1oogoo03=oo`00:goo00=m87ooOol0;7oo00<007ooOol00Woo00<007oo
Ool02Goo00<007ooOol01Woo00<007ooOol0AGoo00=m87ooOol0=7oo000[Ool00gdPOomoo`0]Ool4
000<Ool50004Ool00`00Oomoo`15Ool00gdPOomoo`0dOol002aoo`03OB1oogoo04Eoo`03001oogoo
04Aoo`03OB1oogoo03Eoo`00;7oo00=m87ooOol0AGoo00<007ooOol0A7oo00=m87ooOol0=Goo000]
Ool00gdPOomoo`14Ool00`00Oomoo`13Ool00gdPOomoo`0fOol002eoo`03OB1oogoo04Aoo`03001o
ogoo04=oo`03OB1oogoo03Ioo`00;Goo00=m87ooOol0A7oo00<007ooOol0@goo00=m87ooOol0=Woo
000^Ool00gdPOomoo`13Ool00`00Oomoo`12Ool00gdPOomoo`0gOol002ioo`03OB1oogoo04=oo`03
001oogoo049oo`03OB1oogoo03Moo`00;goo00=m87ooOol0@Woo00<007ooOol0@Goo00=m87ooOol0
>7oo000_Ool00gdPOomoo`12Ool00`00Oomoo`11Ool00gdPOomoo`0hOol0031oo`03OB1oogoo045o
o`03001oogoo041oo`03OB1oogoo03Uoo`00<7oo00=m87ooOol0@Goo00<007ooOol0@7oo00=m87oo
Ool0>Goo000aOol00gdPOomoo`10Ool00`00Oomoo`0oOol00gdPOomoo`0jOol0039oo`03OB1oogoo
03moo`03001oogoo03moo`03OB1oogoo03Yoo`00<goo00=m87ooOol0?Woo00<007ooOol0?Woo00=m
87ooOol0>goo000cOol00gdPOomoo`0nOol00`00Oomoo`0mOol00gdPOomoo`0lOol003Aoo`03OB1o
ogoo03eoo`03001oogoo03eoo`03OB1oogoo03aoo`00=Goo00=m87ooOol0?7oo00<007ooOol0?7oo
00=m87ooOol0?Goo000fOol00gdPOomoo`0kOol00`00Oomoo`0kOol00gdPOomoo`0nOol003Moo`03
OB1oogoo03Yoo`03001oogoo03Yoo`03OB1oogoo03moo`00=goo00=m87ooOol0<Goo1@0017oo00<0
07ooOol0>Goo00=m87ooOol0@7oo000hOol00gdPOomoo`0bOol00`00Oomoo`04Ool00`00Oomoo`0h
Ool00gdPOomoo`11Ool003Uoo`03OB1oogoo035oo`03001oogoo00Aoo`03001oogoo03Moo`03OB1o
ogoo049oo`00>Woo00=m87ooOol0<7oo00<007ooOol017oo0P00=goo00=m87ooOol0@goo000kOol0
0gdPOomoo`0_Ool00`00Oomoo`04Ool00`00Oomoo`0eOol00gdPOomoo`14Ool003aoo`03OB1oogoo
02ioo`03001oogoo00Aoo`03001oogoo03Aoo`03OB1oogoo04Eoo`00?7oo00=m87ooOol0;7oo0`00
1Woo00<007ooOol0=7oo00=m87ooOol0AGoo000mOol00gdPOomoo`0]Ool00`00Oomoo`04Ool00`00
Oomoo`0cOol00gdPOomoo`16Ool003ioo`03OB1oogoo03=oo`03001oogoo039oo`03OB1oogoo04Mo
o`00?goo0WdP<goo00<007ooOol0<7oo0WdPBWoo0011Ool00gdPOomoo`0`Ool00`00Oomoo`0_Ool0
0gdPOomoo`1:Ool0049oo`9m831oo`03001oogoo02eoo`9m84eoo`00A7oo00=m87ooOol0;Goo00<0
07ooOol0;7oo00=m87ooOol0CGoo0015Ool2OB0]Ool00`00Oomoo`0ZOol2OB1@Ool004Moo`03OB1o
ogoo02Yoo`03001oogoo02Uoo`03OB1oogoo051oo`00B7oo0WdP:Woo00<007ooOol09goo0WdPDgoo
001:Ool00gdPOomoo`0WOol00`00Oomoo`0VOol00gdPOomoo`1COol004]oo`9m82Moo`03001oogoo
02Aoo`9m85Ioo`00CGoo00=m87ooOol097oo00<007ooOol08goo00=m87ooOol0EWoo001>Ool2OB0T
Ool00`00Oomoo`0QOol2OB1IOol0051oo`9m829oo`03001oogoo01moo`9m85]oo`00DWoo0WdP87oo
00<007ooOol07Goo0WdPGGoo001DOol2OB0NOol00`00Oomoo`0KOol2OB1OOol005Ioo`=m81]oo`03
001oogoo01Qoo`=m865oo`00FGoo17dP5goo00<007ooOol057oo17dPI7oo001MOol3OB0DOol00`00
Oomoo`0AOol3OB1XOol0061oo`Am811oo`03001oogoo00eoo`Am86]oo`00Fgoo1@0017oo1GdP0Woo
10001Goo00<007ooOol027oo1GdPKgoo001MOol00`00Oomoo`04Ool20003OolFOB1dOol005eoo`03
001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00GGoo00<007ooOol03goo00<007ooOol0
0Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1lOol005eoo`03001oogoo00]o
o`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007ooOol01Woo00<007ooOol0O7oo
001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
JWoo1@001Goo00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool0
0`00Oomoo`06Ool00`00Oomoo`1lOol006aoo`03001oogoo00Eoo`8007eoo`00KGoo00<007ooOol0
Pgoo001^Ool00`00Oomoo`22Ool006Yoo`05001oogooOol00024Ool006]oo`<008Eoo`00lgoo003c
Ool00?=oo`00lgoo002AOol3000;Ool50004Ool20005Ool40004Ool4000hOol0091oo`06001oogoo
Ool007oo1P001Goo00<007ooOol017oo0P0017oo00<007ooOol00Woo00@007ooOol000Aoo`03001o
ogoo03Eoo`00Lgoo0P0000=oo`00000067oo00<007ooOol03Woo00<007ooOol02Woo00<007ooOol0
0Woo00<007ooOol01Goo00<007ooOol0=Goo001bOol00`00Oomoo`02000IOol00`00Oomoo`03Ool6
0005Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`00Oomoo`0eOol0079oo`05
001oogooOol0000IOol00`00Oomoo`0>Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool01000Oomoogoo
1000>7oo001bOol01@00Oomoogoo000067oo1@003Goo00<007ooOol02Woo00<007ooOol00Woo00D0
07ooOomoo`0003]oo`00LWoo00D007ooOomoo`0001Uoo`03001oogoo00aoo`<000aoo`03001oogoo
009oo`05001oogooOol0000kOol0075oo`80009oo`8002Yoo`03001oogoo00]oo`@000Aoo`D003Mo
o`00lgoo003cOol00?=oo`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -53 0 ]

[.5 1.0125 53 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -114 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.) show

165.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 0 0 r

.5 Mabswid

.14645 .49992 m

.14795 .46738 L

.15247 .43503 L

.15994 .40325 L

.17032 .37228 L

.18351 .34241 L

.1994 .31388 L

.21786 .28694 L

.23872 .26181 L

.26181 .23872 L

.28694 .21786 L

.31388 .1994 L

.34241 .18351 L

.37228 .17032 L

.40325 .15994 L

.43503 .15247 L

.46738 .14795 L

.5 .14645 L

.53262 .14795 L

.56497 .15247 L

.59675 .15994 L

.62772 .17032 L

.65759 .18351 L

.68612 .1994 L

.71306 .21786 L

.73819 .23872 L

.76128 .26181 L

.78214 .28694 L

.8006 .31388 L

.81649 .34241 L

.82968 .37228 L

.84006 .40325 L

.84753 .43503 L

.85205 .46738 L

.85355 .49992 L

s

.14645 .50008 m

.14795 .53262 L

.15247 .56497 L

.15994 .59675 L

.17032 .62772 L

.18351 .65759 L

.1994 .68612 L

.21786 .71306 L

.23872 .73819 L

.26181 .76128 L

.28694 .78214 L

.31388 .8006 L

.34241 .81649 L

.37228 .82968 L

.40325 .84006 L

.43503 .84753 L

.46738 .85205 L

.5 .85355 L

.53262 .85205 L

.56497 .84753 L

.59675 .84006 L

.62772 .82968 L

.65759 .81649 L

.68612 .8006 L

.71306 .78214 L

.73819 .76128 L

.76128 .73819 L

.78214 .71306 L

.8006 .68612 L

.81649 .65759 L

.82968 .62772 L

.84006 .59675 L

.84753 .56497 L

.85205 .53262 L

.85355 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol006YooaEl
07Aoo`00IGoo1G`02Woo00<007ooOol027oo1G`0Kgoo001QOol4O00?Ool00`00Oomoo`0=Ool4O01[
Ool005ioo`=l01=oo`03001oogoo015oo`=l06Qoo`00FWoo17`05Woo00<007ooOol057oo0g`0IGoo
001HOol2O00JOol00`00Oomoo`0GOol3O01ROol005Ioo`9l01aoo`03001oogoo01Yoo`9l061oo`00
E7oo0W`07Woo00<007ooOol077oo0W`0GWoo001BOol2O00POol00`00Oomoo`0NOol2O01LOol0051o
o`9l029oo`03001oogoo021oo`9l05Yoo`00CWoo0W`097oo00<007ooOol08Woo0W`0F7oo001<Ool2
O00VOol00`00Oomoo`0TOol2O01FOol004Yoo`9l02Qoo`03001oogoo02Ioo`9l05Aoo`00BGoo00=l
07ooOol0:7oo00<007ooOol0:7oo00=l07ooOol0DGoo0017Ool2O00[Ool00`00Oomoo`0YOol2O01A
Ool004Ioo`03O01oogoo02]oo`03001oogoo02]oo`03O01oogoo04ioo`00AGoo00=l07ooOol0;7oo
00<007ooOol0;7oo00=l07ooOol0CGoo0014Ool00g`0Oomoo`0]Ool00`00Oomoo`0]Ool00g`0Oomo
o`1<Ool0049oo`9l031oo`03001oogoo02ioo`03O01oogoo04]oo`00@Goo00=l07ooOol09goo1@00
17oo00<007ooOol0;goo00=l07ooOol0BWoo0010Ool00g`0Oomoo`0ZOol00`00Oomoo`04Ool00`00
Oomoo`0`Ool00g`0Oomoo`19Ool003moo`03O01oogoo02]oo`03001oogoo00Aoo`03001oogoo035o
o`03O01oogoo04Qoo`00?Woo00=l07ooOol08Goo1P001Goo00<007ooOol017oo0P00<goo00=l07oo
Ool0Agoo000mOol00g`0Oomoo`0]Ool00`00Oomoo`04Ool00`00Oomoo`0cOol00g`0Oomoo`16Ool0
03aoo`03O01oogoo02ioo`03001oogoo00Aoo`03001oogoo03Aoo`03O01oogoo04Eoo`00>goo00=l
07ooOol0;Goo0`001Woo00<007ooOol0=Goo00=l07ooOol0A7oo000jOol00g`0Oomoo`0`Ool00`00
Oomoo`04Ool00`00Oomoo`0fOol00g`0Oomoo`13Ool003Uoo`03O01oogoo03Qoo`03001oogoo03Mo
o`03O01oogoo049oo`00>Goo00=l07ooOol0>7oo00<007ooOol0>7oo00=l07ooOol0@Goo000hOol0
0g`0Oomoo`0iOol00`00Oomoo`0iOol00g`0Oomoo`10Ool003Moo`03O01oogoo03Yoo`03001oogoo
03Yoo`03O01oogoo03moo`00=Woo00=l07ooOol0>goo00<007ooOol0>goo00=l07ooOol0?Woo000f
Ool00g`0Oomoo`0kOol00`00Oomoo`0kOol00g`0Oomoo`0nOol003Eoo`03O01oogoo03aoo`03001o
ogoo03aoo`03O01oogoo03eoo`00=7oo00=l07ooOol0?Goo00<007ooOol0?Goo00=l07ooOol0?7oo
000dOol00g`0Oomoo`0mOol00`00Oomoo`0mOol00g`0Oomoo`0lOol003=oo`03O01oogoo03ioo`03
001oogoo03ioo`03O01oogoo03]oo`00<Woo00=l07ooOol0?goo00<007ooOol0?goo00=l07ooOol0
>Woo000bOol00g`0Oomoo`0oOol00`00Oomoo`0oOol00g`0Oomoo`0jOol0035oo`03O01oogoo041o
o`03001oogoo041oo`03O01oogoo03Uoo`00<7oo00=l07ooOol0@Goo00<007ooOol0@7oo00=l07oo
Ool0>Goo000`Ool00g`0Oomoo`11Ool00`00Oomoo`11Ool00g`0Oomoo`0hOol002moo`03O01oogoo
049oo`03001oogoo045oo`03O01oogoo03Qoo`00;goo00=l07ooOol0@Woo00<007ooOol0@Goo00=l
07ooOol0>7oo000^Ool00g`0Oomoo`13Ool00`00Oomoo`12Ool00g`0Oomoo`0gOol002ioo`03O01o
ogoo04=oo`03001oogoo049oo`03O01oogoo03Moo`00;Woo00=l07ooOol0:Woo10001Goo0P001Goo
10001Goo00<007ooOol0@goo00=l07ooOol0=Woo000^Ool00g`0Oomoo`0YOol00`00Oomoo`02Ool0
0`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`13Ool00g`0Oomo
o`0fOol002eoo`03O01oogoo02Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03
001oogoo04Aoo`03O01oogoo03Eoo`00;Goo00=l07ooOol08Woo1P000Woo00<007ooOol00Woo00<0
07ooOol03Goo00<007ooOol00Woo0P00AGoo00=l07ooOol0=Goo000/Ool00g`0Oomoo`0[Ool00`00
Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`14Ool00g`0Oomoo`0eOol002aoo`03O01o
ogoo02]oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo04Eoo`03O01o
ogoo03Aoo`00:goo00=l07ooOol0;7oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo
00<007ooOol0AGoo00=l07ooOol0=7oo000[Ool00g`0Oomoo`0]Ool4000<Ool50004Ool00`00Oomo
o`15Ool00g`0Oomoo`0dOol002Yoo`03O01oogoo04Moo`03001oogoo04Ioo`03O01oogoo03=oo`00
:Woo00=l07ooOol0Agoo00<007ooOol0AWoo00=l07ooOol0<goo000ZOol00g`0Oomoo`17Ool00`00
Oomoo`16Ool00g`0Oomoo`0cOol002Yoo`03O01oogoo04Moo`03001oogoo04Moo`03O01oogoo039o
o`00:Woo00=l07ooOol0Agoo00<007ooOol0Agoo00=l07ooOol0<Woo000YOol00g`0Oomoo`18Ool0
0`00Oomoo`17Ool00g`0Oomoo`0bOol002Uoo`03O01oogoo04Qoo`03001oogoo04Moo`03O01oogoo
039oo`00:Goo00=l07ooOol0B7oo00<007ooOol0B7oo00=l07ooOol0<Goo0009Ool5000?Ool50004
Ool200000gooO01oo`02Ool4000?Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool4
0005Ool20005Ool4000?Ool5000>Ool400000g`0Oomoo`02Ool20005Ool4000>Ool5000AOol000Uo
o`05001oogooOol0000AOol00`00Oomoo`04Ool200001GooO01oogoo000017oo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007oo
Ool02Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo
00<007ooOol03Woo00<007ooOol047oo00<007ooO00017oo0P0017oo00<007ooOol00Woo00<007oo
Ool02goo00D007ooOomoo`00015oo`002Woo00<007ooOol04Woo00<007ooOol01goo00=l07ooOol0
1Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol0
2Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol0
47oo00<007ooO0003goo00<007ooOol037oo00<007ooOol04Woo00000goo000000040004Ool00`00
Oomoo`06Ool60005Ool00`00Oomoo`07Ool00g`0Oomoo`05Ool00`00Oomoo`03Ool60005Ool00`00
Oomoo`05Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Ooml000?
Ool00`00Oomoo`0=Ool00`00Oomoo`0AOol000aoo`03001oogoo011oo`03001oogoo00Ioo`03O01o
ogoo009oo`@0015oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@000eoo`03001o
ogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@0015oo`03001oogoo011oo`04001oogooO00:
Ool4000AOol00`00Oomoo`0@Ool000eoo`03001oogoo00moo`03001oogoo00Ioo`03O01oogoo009o
o`03001oogoo019oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00io
o`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo019oo`03001oogoo011o
o`04001oogooO00:Ool00`00Oomoo`0COol00`00Oomoo`0?Ool000Uoo`05001oogooOol0000?Ool3
0008Ool00g`0Oomoo`02Ool00`00Oomoo`0@Ool3000?Ool00`00Oomoo`02Ool00`00Oomoo`09Ool0
0`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0@Ool3
000@Ool30002Ool00g`0Oomoo`08Ool00`00Oomoo`0?Ool01@00Oomoogoo00004Goo000:Ool3000B
Ool00`00Oomoo`06Ool00g`0Oomoo`02Ool5000@Ool00`00Oomoo`0>Ool4000<Ool5000<Ool00`00
Oomoo`0>Ool4000<Ool5000@Ool00`00Oomoo`0@Ool01000Oomoog`02Woo1@003Woo0`004Woo000X
Ool00g`0Oomoo`19Ool00`00Oomoo`19Ool00g`0Oomoo`0`Ool002Qoo`03O01oogoo04Uoo`03001o
ogoo04Uoo`03O01oogoo031oo`00:7oo00=l07ooOol0BGoo00<007ooOol0BGoo00=l07ooOol0<7oo
000WOol00g`0Oomoo`1:Ool00`00Oomoo`19Ool00g`0Oomoo`0`Ool002Moo`03O01oogoo04Yoo`03
001oogoo04Uoo`03O01oogoo02Eoo`80009oo`8000Eoo`009goo00=l07ooOol0BWoo00<007ooOol0
BGoo00=l07ooOol09Woo00@007ooOol000Ioo`0027oo7`0000=l00000000UP0000=l000000007P00
2Goo0P001goo0008Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool01P00OomoogooO00000Eoo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001l
07oo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo00Moo`8000Moo`0027oo00<007ooOol067oo00D007ooOomoog`001Ioo`03
001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01=oo`03
O01oogoo009oo`03001oogoo01Qoo`03001oogoo00Ioo`04001oogoo0006Ool002Moo`03O01oogoo
04Yoo`03001oogoo04Uoo`03O01oogoo02Eoo`80009oo`8000Eoo`00:7oo00=l07ooOol0BGoo00<0
07ooOol0BGoo00=l07ooOol0<7oo000XOol00g`0Oomoo`19Ool00`00Oomoo`19Ool00g`0Oomoo`0`
Ool002Qoo`03O01oogoo04Uoo`03001oogoo04Uoo`03O01oogoo031oo`00:7oo00=l07ooOol0BGoo
00<007ooOol0BGoo00=l07ooOol0<7oo000XOol00g`0Oomoo`19Ool00`00Oomoo`19Ool00g`0Oomo
o`0`Ool002Qoo`03O01oogoo04Uoo`03001oogoo04Uoo`03O01oogoo031oo`00:7oo00=l07ooOol0
BGoo00<007ooOol0BGoo00=l07ooOol0<7oo000YOol00g`0Oomoo`18Ool00`00Oomoo`18Ool00g`0
Oomoo`0aOol002Uoo`03O01oogoo04Qoo`03001oogoo04Qoo`03O01oogoo035oo`00:Goo00=l07oo
Ool0B7oo00<007ooOol0B7oo00=l07ooOol0<Goo000YOol00g`0Oomoo`18Ool00`00Oomoo`18Ool0
0g`0Oomoo`0aOol002Uoo`03O01oogoo04Qoo`03001oogoo04Qoo`03O01oogoo035oo`00:Goo00=l
07ooOol0B7oo00<007ooOol0Agoo00=l07ooOol0<Woo000YOol00g`0Oomoo`18Ool00`00Oomoo`17
Ool00g`0Oomoo`0bOol002Yoo`03O01oogoo04Moo`03001oogoo04Moo`03O01oogoo039oo`00:Woo
00=l07ooOol0Agoo00<007ooOol0Agoo00=l07ooOol0<Woo000ZOol00g`0Oomoo`17Ool00`00Oomo
o`16Ool00g`0Oomoo`0cOol002Yoo`03O01oogoo04Moo`03001oogoo04Ioo`03O01oogoo03=oo`00
:Woo00=l07ooOol0Agoo00<007ooOol0AWoo00=l07ooOol0<goo000[Ool00g`0Oomoo`16Ool00`00
Oomoo`15Ool00g`0Oomoo`0dOol002]oo`03O01oogoo02eoo`@000Eoo`8000Eoo`@000Eoo`03001o
ogoo04Eoo`03O01oogoo03Aoo`00;7oo00=l07ooOol0:goo00<007ooOol00Woo00<007ooOol00Woo
0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0AGoo00=l07ooOol0=7oo000/Ool0
0g`0Oomoo`0[Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`15Ool0
0g`0Oomoo`0dOol002eoo`03O01oogoo02Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo
009oo`8004Eoo`03O01oogoo03Eoo`00;Goo00=l07ooOol0:Woo00<007ooOol00Woo00<007ooOol0
2Goo10001Goo00<007ooOol0A7oo00=l07ooOol0=Goo000]Ool00g`0Oomoo`0ZOol00`00Oomoo`02
Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`13Ool00g`0Oomoo`0fOol002ioo`03O01o
ogoo02Uoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo04=oo`03O01o
ogoo03Ioo`00;Woo00=l07ooOol0:Woo100037oo1@0017oo00<007ooOol0@Woo00=l07ooOol0=goo
000^Ool00g`0Oomoo`13Ool00`00Oomoo`12Ool00g`0Oomoo`0gOol002moo`03O01oogoo049oo`03
001oogoo045oo`03O01oogoo03Qoo`00;goo00=l07ooOol0@Woo00<007ooOol0@Goo00=l07ooOol0
>7oo000`Ool00g`0Oomoo`11Ool00`00Oomoo`10Ool00g`0Oomoo`0iOol0031oo`03O01oogoo045o
o`03001oogoo041oo`03O01oogoo03Uoo`00<Goo00=l07ooOol0@7oo00<007ooOol0?goo00=l07oo
Ool0>Woo000bOol00g`0Oomoo`0oOol00`00Oomoo`0oOol00g`0Oomoo`0jOol0039oo`03O01oogoo
03moo`03001oogoo03ioo`03O01oogoo03]oo`00<goo00=l07ooOol0?Woo00<007ooOol0?Woo00=l
07ooOol0>goo000dOol00g`0Oomoo`0mOol00`00Oomoo`0mOol00g`0Oomoo`0lOol003Aoo`03O01o
ogoo03eoo`03001oogoo03eoo`03O01oogoo03aoo`00=Goo00=l07ooOol0?7oo00<007ooOol0?7oo
00=l07ooOol0?Goo000fOol00g`0Oomoo`0kOol00`00Oomoo`0kOol00g`0Oomoo`0nOol003Ioo`03
O01oogoo03]oo`03001oogoo03]oo`03O01oogoo03ioo`00=goo00=l07ooOol0>Woo00<007ooOol0
>Woo00=l07ooOol0?goo000hOol00g`0Oomoo`0iOol00`00Oomoo`0iOol00g`0Oomoo`10Ool003Qo
o`03O01oogoo03Uoo`03001oogoo03Qoo`03O01oogoo045oo`00>Goo00=l07ooOol0>7oo00<007oo
Ool0=goo00=l07ooOol0@Woo000jOol00g`0Oomoo`0gOol00`00Oomoo`0gOol00g`0Oomoo`12Ool0
03Yoo`03O01oogoo02ioo`D000Aoo`03001oogoo03Ioo`03O01oogoo04=oo`00>goo00=l07ooOol0
;goo00<007ooOol017oo00<007ooOol0=Goo00=l07ooOol0A7oo000lOol00g`0Oomoo`0^Ool00`00
Oomoo`04Ool00`00Oomoo`0dOol00g`0Oomoo`15Ool003eoo`03O01oogoo02eoo`03001oogoo00Ao
o`8003Aoo`03O01oogoo04Ioo`00?Woo00=l07ooOol0;7oo00<007ooOol017oo00<007ooOol0<Woo
00=l07ooOol0Agoo000oOol00g`0Oomoo`0[Ool00`00Oomoo`04Ool00`00Oomoo`0aOol00g`0Oomo
o`18Ool0041oo`03O01oogoo02Qoo`<000Ioo`03001oogoo031oo`03O01oogoo04Uoo`00@Goo0W`0
:Woo00<007ooOol017oo00<007ooOol0;goo00=l07ooOol0BWoo0013Ool00g`0Oomoo`0^Ool00`00
Oomoo`0]Ool2O01=Ool004Aoo`9l02ioo`03001oogoo02aoo`03O01oogoo04eoo`00AWoo00=l07oo
Ool0:goo00<007ooOol0:goo00=l07ooOol0CWoo0017Ool2O00[Ool00`00Oomoo`0YOol2O01AOol0
04Uoo`03O01oogoo02Qoo`03001oogoo02Qoo`03O01oogoo055oo`00BWoo0W`0:7oo00<007ooOol0
9Woo0W`0E7oo001<Ool00g`0Oomoo`0UOol00`00Oomoo`0UOol00g`0Oomoo`1DOol004eoo`9l02Eo
o`03001oogoo02=oo`9l05Moo`00Cgoo0W`08goo00<007ooOol08Goo0W`0FGoo001AOol2O00QOol0
0`00Oomoo`0NOol3O01KOol005=oo`9l01moo`03001oogoo01aoo`9l05ioo`00EGoo0W`07Goo00<0
07ooOol06Woo0W`0H7oo001GOol3O00JOol00`00Oomoo`0HOol2O01ROol005Yoo`9l01Qoo`03001o
ogoo01Ioo`9l06Aoo`00G7oo0W`05Woo00<007ooOol057oo0W`0IWoo001NOol5O00AOol00`00Oomo
o`0?Ool5O01XOol006=oo`Ml00Yoo`03001oogoo00Qoo`Ml06eoo`00JWoo5G`0M7oo001dOol00`00
Oomoo`1lOol005]oo`D000Aoo`8000Eoo`@000Eoo`03001oogoo07aoo`00GGoo00<007ooOol017oo
0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0O7oo001MOol00`00Oomoo`0?Ool0
0`00Oomoo`02Ool00`00Oomoo`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`8007eoo`00
GGoo00<007ooOol02goo10001Goo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool00`00Oomoo`06
Ool00`00Oomoo`1lOol005]oo`<000eoo`03001oogoo00Ioo`03001oogoo07aoo`00GGoo00<007oo
Ool02goo1@0017oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol006Yoo`D000Eoo`03
001oogoo07aoo`00JWoo00D007ooOomoo`0000Eoo`03001oogoo07aoo`00Jgoo00<007ooOol01Woo
00<007ooOol0O7oo001/Ool00`00Oomoo`05Ool2001mOol006eoo`03001oogoo08=oo`00KWoo00<0
07ooOol0PWoo001ZOol01@00Oomoogoo0000Q7oo001[Ool30025Ool00?=oo`00lgoo003cOol00?=o
o`00V7oo0`002goo1@0017oo0P00@Woo002GOol01@00Oomoogoo00000Woo1P0017oo00<007ooOol0
17oo0P00@Woo001cOol200000goo0000000OOol00`00Oomoo`0>Ool00`00Oomoo`18Ool0079oo`03
001oogoo0080021oo`03001oogoo00Aoo`H000Aoo`03001oogoo04Qoo`00LWoo00D007ooOomoo`00
021oo`03001oogoo00ioo`03001oogoo04Qoo`00LWoo00D007ooOomoo`0001moo`D000eoo`03001o
ogoo04Qoo`00LWoo00D007ooOomoo`00021oo`03001oogoo00aoo`<004Yoo`00LGoo0P000Woo0P00
<Goo00<007ooOol0B7oo003cOol00?=oo`00lgoo003cOol00?=oo`00\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.95) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 0 .3 r

.5 Mabswid

.15996 .49992 m

.16141 .46863 L

.16575 .43752 L

.17294 .40694 L

.18293 .37716 L

.19561 .34843 L

.21089 .32099 L

.22864 .29508 L

.24871 .27092 L

.27092 .24871 L

.29508 .22864 L

.32099 .21089 L

.34843 .19561 L

.37716 .18293 L

.40694 .17294 L

.43752 .16575 L

.46863 .16141 L

.5 .15996 L

.53137 .16141 L

.56248 .16575 L

.59306 .17294 L

.62284 .18293 L

.65157 .19561 L

.67901 .21089 L

.70492 .22864 L

.72908 .24871 L

.75129 .27092 L

.77136 .29508 L

.78911 .32099 L

.80439 .34843 L

.81707 .37716 L

.82706 .40694 L

.83425 .43752 L

.83859 .46863 L

.84004 .49992 L

s

.15996 .50008 m

.16141 .53137 L

.16575 .56248 L

.17294 .59306 L

.18293 .62284 L

.19561 .65157 L

.21089 .67901 L

.22864 .70492 L

.24871 .72908 L

.27092 .75129 L

.29508 .77136 L

.32099 .78911 L

.34843 .80439 L

.37716 .81707 L

.40694 .82706 L

.43752 .83425 L

.46863 .83859 L

.5 .84004 L

.53137 .83859 L

.56248 .83425 L

.59306 .82706 L

.62284 .81707 L

.65157 .80439 L

.67901 .78911 L

.70492 .77136 L

.72908 .75129 L

.75129 .72908 L

.77136 .70492 L

.78911 .67901 L

.80439 .65157 L

.81707 .62284 L

.82706 .59306 L

.83425 .56248 L

.83859 .53137 L

.84004 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol006YooaAl2GEoo`00IGoo
1G`92Woo00<007ooOol01goo1G`9L7oo001ROol3O0T?Ool00`00Oomoo`0<Ool4O0U/Ool005moo`=l
2A9oo`03001oogoo011oo`=l2FUoo`00Fgoo17`95Goo00<007ooOol04goo0g`9IWoo001IOol2O0TI
Ool00`00Oomoo`0FOol2O0UTOol005Moo`9l2A]oo`03001oogoo01Qoo`9l2F9oo`00EGoo0W`97Goo
00<007ooOol06Woo0W`9H7oo001COol2O0TOOol00`00Oomoo`0LOol2O0UNOol0055oo`9l2B5oo`03
001oogoo01ioo`9l2Eaoo`00Cgoo0W`98goo00<007ooOol087oo0W`9FWoo001=Ool2O0TUOol00`00
Oomoo`0ROol2O0UHOol004]oo`9l2BMoo`03001oogoo02Aoo`9l2EIoo`00BWoo00=l2GooOol09goo
00<007ooOol09Woo00=l2GooOol0Dgoo0018Ool2O0TZOol00`00Oomoo`0WOol2O0UCOol004Moo`03
O0Uoogoo02Yoo`03001oogoo02Uoo`03O0Uoogoo051oo`00AWoo00=l2GooOol08Woo1@0017oo00<0
07ooOol0:Woo00=l2GooOol0Cgoo0014Ool2O0TWOol00`00Oomoo`04Ool00`00Oomoo`0[Ool2O0U?
Ool004=oo`03O0Uoogoo02Moo`03001oogoo00Aoo`03001oogoo02eoo`03O0Uoogoo04aoo`00@Woo
00=l2GooOol07Goo1P001Goo00<007ooOol017oo0P00;goo00=l2GooOol0Bgoo0011Ool00g`9Oomo
o`0YOol00`00Oomoo`04Ool00`00Oomoo`0_Ool00g`9Oomoo`1:Ool0041oo`03O0Uoogoo02Yoo`03
001oogoo00Aoo`03001oogoo031oo`03O0Uoogoo04Uoo`00?goo00=l2GooOol0:Goo0`001Woo00<0
07ooOol0<Goo00=l2GooOol0B7oo000nOol00g`9Oomoo`0/Ool00`00Oomoo`04Ool00`00Oomoo`0b
Ool00g`9Oomoo`17Ool003eoo`03O0Uoogoo03Aoo`03001oogoo03=oo`03O0Uoogoo04Ioo`00?7oo
00=l2GooOol0=Goo00<007ooOol0=7oo00=l2GooOol0AGoo000kOol00g`9Oomoo`0fOol00`00Oomo
o`0eOol00g`9Oomoo`14Ool003]oo`03O0Uoogoo03Ioo`03001oogoo03Eoo`03O0Uoogoo04Aoo`00
>Woo00=l2GooOol0=goo00<007ooOol0=Woo00=l2GooOol0@goo000iOol00g`9Oomoo`0hOol00`00
Oomoo`0gOol00g`9Oomoo`12Ool003Qoo`03O0Uoogoo03Uoo`03001oogoo03Qoo`03O0Uoogoo045o
o`00>7oo00=l2GooOol0>Goo00<007ooOol0>7oo00=l2GooOol0@Goo000gOol00g`9Oomoo`0jOol0
0`00Oomoo`0iOol00g`9Oomoo`10Ool003Ioo`03O0Uoogoo03]oo`03001oogoo03Yoo`03O0Uoogoo
03moo`00=Woo00=l2GooOol0>goo00<007ooOol0>Woo00=l2GooOol0?goo000eOol00g`9Oomoo`0l
Ool00`00Oomoo`0kOol00g`9Oomoo`0nOol003Aoo`03O0Uoogoo03eoo`03001oogoo03aoo`03O0Uo
ogoo03eoo`00=7oo00=l2GooOol0?Goo00<007ooOol0?7oo00=l2GooOol0?Goo000cOol00g`9Oomo
o`0nOol00`00Oomoo`0mOol00g`9Oomoo`0lOol003=oo`03O0Uoogoo03ioo`03001oogoo03eoo`03
O0Uoogoo03aoo`00<Woo00=l2GooOol0?goo00<007ooOol0?Woo00=l2GooOol0>goo000bOol00g`9
Oomoo`0oOol00`00Oomoo`0nOol00g`9Oomoo`0kOol0035oo`03O0Uoogoo041oo`03001oogoo03mo
o`03O0Uoogoo03Yoo`00<Goo00=l2GooOol09goo10001Goo0P001Goo10001Goo00<007ooOol0?goo
00=l2GooOol0>Woo000`Ool00g`9Oomoo`0WOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`10Ool00g`9Oomoo`0iOol0031oo`03O0Uoogoo
02Moo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo041oo`03O0Uoogoo
03Uoo`00;goo00=l2GooOol087oo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol0
0Woo0P00@Woo00=l2GooOol0>7oo000_Ool00g`9Oomoo`0XOol00`00Oomoo`02Ool00`00Oomoo`09
Ool40005Ool00`00Oomoo`11Ool00g`9Oomoo`0hOol002moo`03O0Uoogoo02Qoo`03001oogoo009o
o`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo045oo`03O0Uoogoo03Qoo`00;Woo00=l2Goo
Ool0:Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0@Woo00=l2Goo
Ool0=goo000^Ool00g`9Oomoo`0ZOol4000<Ool50004Ool00`00Oomoo`12Ool00g`9Oomoo`0gOol0
02ioo`03O0Uoogoo04=oo`03001oogoo049oo`03O0Uoogoo03Moo`00;Goo00=l2GooOol0A7oo00<0
07ooOol0@goo00=l2GooOol0=Woo000]Ool00g`9Oomoo`14Ool00`00Oomoo`13Ool00g`9Oomoo`0f
Ool002eoo`03O0Uoogoo04Aoo`03001oogoo04=oo`03O0Uoogoo03Ioo`00;Goo00=l2GooOol0A7oo
00<007ooOol0A7oo00=l2GooOol0=Goo000]Ool00g`9Oomoo`14Ool00`00Oomoo`14Ool00g`9Oomo
o`0eOol002aoo`03O0Uoogoo04Eoo`03001oogoo04Aoo`03O0Uoogoo03Eoo`00;7oo00=l2GooOol0
AGoo00<007ooOol0A7oo00=l2GooOol0=Goo0009Ool5000?Ool50004Ool20004Ool00g`900000002
000?Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool5
000>Ool00`00O0T000020004Ool20005Ool4000>Ool5000AOol000Uoo`05001oogooOol0000AOol0
0`00Oomoo`04Ool20004Ool00g`9Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomo
o`0?Ool00g`9001oo`05Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool01@00Oomoogoo0000
4Goo000:Ool00`00Oomoo`0BOol00`00Oomoo`0:Ool00g`9Oomoo`02Ool00`00Oomoo`0>Ool00`00
Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00
Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0?Ool00g`9001oo`0@Ool00`00
Oomoo`0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Ioo`H000Eoo`03001o
ogoo00Yoo`03O0Uoogoo009oo`03001oogoo00=oo`H000Eoo`03001oogoo00Eoo`H0009oo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03001o
ogoo00eoo`03001oogoo00ioo`03001oogoo00moo`03O0T007oo011oo`03001oogoo00eoo`03001o
ogoo015oo`0037oo00<007ooOol047oo00<007ooOol02Goo00=l2Goo00000`004Goo00<007ooOol0
3Goo00<007ooOol00Woo00<007ooOol02Goo10003Goo00<007ooOol03Goo00<007ooOol00Woo00<0
07ooOol02Goo10004Goo00<007ooOol047oo00=l2GooOol02goo10004Goo00<007ooOol047oo000=
Ool00`00Oomoo`0?Ool00`00Oomoo`09Ool00g`9Ool0000DOol00`00Oomoo`0=Ool00`00Oomoo`02
Ool00`00Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0BOol00`00Oomoo`0@Ool00g`9Oomoo`0;Ool00`00Oomoo`0COol00`00Oomoo`0?
Ool000Uoo`05001oogooOol0000?Ool3000;Ool00g`9Ool0000BOol3000?Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool0
0`00Oomoo`0@Ool3000@Ool200000g`9Oomoo`0;Ool00`00Oomoo`0?Ool01@00Oomoogoo00004Goo
000:Ool3000BOol00`00Oomoo`09Ool00g`9Ool00004000@Ool00`00Oomoo`0>Ool4000<Ool5000<
Ool00`00Oomoo`0>Ool4000<Ool5000@Ool00`00Oomoo`0@Ool00g`9Oomoo`0;Ool5000>Ool3000B
Ool002]oo`03O0Uoogoo04Ioo`03001oogoo04Ioo`03O0Uoogoo03=oo`00:goo00=l2GooOol0AWoo
00<007ooOol0AWoo00=l2GooOol0<goo000[Ool00g`9Oomoo`16Ool00`00Oomoo`16Ool00g`9Oomo
o`0cOol002Yoo`03O0Uoogoo04Moo`03001oogoo04Ioo`03O0Uoogoo03=oo`00:Woo00=l2GooOol0
Agoo00<007ooOol0AWoo00=l2GooOol0:7oo0P000Woo0P001Goo000ZOol00g`9Oomoo`17Ool00`00
Oomoo`16Ool00g`9Oomoo`0YOol01000Oomoo`001Woo0008OolR00000g`90000002@00000g`90000
000Q0009Ool20007Ool000Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oog`900=oo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001o
ogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001o
ogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`06001o
ogooO0Uoo`001Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo
00<007ooOol00goo00<007ooOol01goo0P001goo0008Ool00`00Oomoo`0HOol00`00Oomoo`04Ool0
0g`9Oomoo`0AOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol0
0`00Oomoo`0@Ool00g`9Oomoo`05Ool00`00Oomoo`0HOol00`00Oomoo`06Ool01000Oomoo`001Woo
000ZOol00g`9Oomoo`17Ool00`00Oomoo`16Ool00g`9Oomoo`0XOol20002Ool20005Ool002]oo`03
O0Uoogoo04Ioo`03001oogoo04Ioo`03O0Uoogoo03=oo`00:goo00=l2GooOol0AWoo00<007ooOol0
AWoo00=l2GooOol0<goo000[Ool00g`9Oomoo`16Ool00`00Oomoo`16Ool00g`9Oomoo`0cOol002]o
o`03O0Uoogoo04Ioo`03001oogoo04Ioo`03O0Uoogoo03=oo`00:goo00=l2GooOol0AWoo00<007oo
Ool0AWoo00=l2GooOol0<goo000[Ool00g`9Oomoo`16Ool00`00Oomoo`16Ool00g`9Oomoo`0cOol0
02]oo`03O0Uoogoo04Ioo`03001oogoo04Ioo`03O0Uoogoo03=oo`00;7oo00=l2GooOol0AGoo00<0
07ooOol0AGoo00=l2GooOol0=7oo000/Ool00g`9Oomoo`15Ool00`00Oomoo`15Ool00g`9Oomoo`0d
Ool002aoo`03O0Uoogoo04Eoo`03001oogoo04Eoo`03O0Uoogoo03Aoo`00;7oo00=l2GooOol0AGoo
00<007ooOol0AGoo00=l2GooOol0=7oo000/Ool00g`9Oomoo`15Ool00`00Oomoo`15Ool00g`9Oomo
o`0dOol002aoo`03O0Uoogoo04Eoo`03001oogoo04Aoo`03O0Uoogoo03Eoo`00;Goo00=l2GooOol0
A7oo00<007ooOol0A7oo00=l2GooOol0=Goo000]Ool00g`9Oomoo`14Ool00`00Oomoo`14Ool00g`9
Oomoo`0eOol002eoo`03O0Uoogoo04Aoo`03001oogoo04=oo`03O0Uoogoo03Ioo`00;Goo00=l2Goo
Ool0A7oo00<007ooOol0@goo00=l2GooOol0=Woo000]Ool00g`9Oomoo`14Ool00`00Oomoo`13Ool0
0g`9Oomoo`0fOol002ioo`03O0Uoogoo04=oo`03001oogoo049oo`03O0Uoogoo03Moo`00;Woo00=l
2GooOol0@goo00<007ooOol0@Woo00=l2GooOol0=goo000^Ool00g`9Oomoo`0ZOol40005Ool20005
Ool40005Ool00`00Oomoo`12Ool00g`9Oomoo`0gOol002ioo`03O0Uoogoo02Uoo`03001oogoo009o
o`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo049oo`03O0Uo
ogoo03Moo`00;goo00=l2GooOol0:7oo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol0@Goo00=l2GooOol0>7oo000_Ool00g`9Oomoo`0XOol00`00Oomoo`02Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool20012Ool00g`9Oomoo`0hOol0031oo`03O0Uoogoo02Moo`03001oogoo
009oo`03001oogoo00Uoo`@000Eoo`03001oogoo041oo`03O0Uoogoo03Uoo`00<7oo00=l2GooOol0
9goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0@7oo00=l2GooOol0
>Goo000aOol00g`9Oomoo`0VOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00
Oomoo`0oOol00g`9Oomoo`0jOol0035oo`03O0Uoogoo02Moo`@000aoo`D000Aoo`03001oogoo03mo
o`03O0Uoogoo03Yoo`00<Woo00=l2GooOol0?goo00<007ooOol0?Woo00=l2GooOol0>goo000bOol0
0g`9Oomoo`0oOol00`00Oomoo`0nOol00g`9Oomoo`0kOol003=oo`03O0Uoogoo03ioo`03001oogoo
03eoo`03O0Uoogoo03aoo`00<goo00=l2GooOol0?Woo00<007ooOol0?Goo00=l2GooOol0?7oo000d
Ool00g`9Oomoo`0mOol00`00Oomoo`0lOol00g`9Oomoo`0mOol003Aoo`03O0Uoogoo03eoo`03001o
ogoo03aoo`03O0Uoogoo03eoo`00=Goo00=l2GooOol0?7oo00<007ooOol0>goo00=l2GooOol0?Woo
000eOol00g`9Oomoo`0lOol00`00Oomoo`0kOol00g`9Oomoo`0nOol003Ioo`03O0Uoogoo03]oo`03
001oogoo03Yoo`03O0Uoogoo03moo`00=goo00=l2GooOol0>Woo00<007ooOol0>Goo00=l2GooOol0
@7oo000gOol00g`9Oomoo`0jOol00`00Oomoo`0iOol00g`9Oomoo`10Ool003Qoo`03O0Uoogoo03Uo
o`03001oogoo03Qoo`03O0Uoogoo045oo`00>Goo00=l2GooOol0>7oo00<007ooOol0=goo00=l2Goo
Ool0@Woo000jOol00g`9Oomoo`0gOol00`00Oomoo`0fOol00g`9Oomoo`13Ool003Yoo`03O0Uoogoo
03Moo`03001oogoo03Ioo`03O0Uoogoo04=oo`00>goo00=l2GooOol0=Woo00<007ooOol0=Goo00=l
2GooOol0A7oo000lOol00g`9Oomoo`0eOol00`00Oomoo`0dOol00g`9Oomoo`15Ool003aoo`03O0Uo
ogoo03Eoo`03001oogoo03Aoo`03O0Uoogoo04Eoo`00?Goo00=l2GooOol0=7oo00<007ooOol0<goo
00=l2GooOol0AWoo000nOol00g`9Oomoo`0ZOol50004Ool00`00Oomoo`0bOol00g`9Oomoo`17Ool0
03moo`9l2Baoo`03001oogoo00Aoo`03001oogoo031oo`9l2DYoo`00@Goo00=l2GooOol0:Goo00<0
07ooOol017oo00<007ooOol0;goo00=l2GooOol0BWoo0012Ool00g`9Oomoo`0XOol00`00Oomoo`04
Ool2000_Ool00g`9Oomoo`1;Ool004=oo`03O0Uoogoo02Moo`03001oogoo00Aoo`03001oogoo02eo
o`03O0Uoogoo04aoo`00A7oo00=l2GooOol09Woo00<007ooOol017oo00<007ooOol0;7oo00=l2Goo
Ool0CGoo0015Ool00g`9Oomoo`0SOol30006Ool00`00Oomoo`0[Ool00g`9Oomoo`1>Ool004Ioo`03
O0Uoogoo02Aoo`03001oogoo00Aoo`03001oogoo02Yoo`03O0Uoogoo04moo`00Agoo00=l2GooOol0
:Woo00<007ooOol0:Goo00=l2GooOol0D7oo0018Ool2O0TZOol00`00Oomoo`0WOol2O0UCOol004Yo
o`03O0Uoogoo02Moo`03001oogoo02Ioo`03O0Uoogoo05=oo`00Bgoo0W`99goo00<007ooOol097oo
0W`9EWoo001=Ool00g`9Oomoo`0TOol00`00Oomoo`0SOol00g`9Oomoo`1FOol004ioo`9l2BAoo`03
001oogoo025oo`9l2EUoo`00D7oo0W`98Woo00<007ooOol07goo0W`9Fgoo001BOol2O0TPOol00`00
Oomoo`0MOol2O0UMOol005Aoo`9l2Aioo`03001oogoo01]oo`9l2Emoo`00EWoo0W`977oo00<007oo
Ool06Goo0W`9HGoo001HOol3O0TIOol00`00Oomoo`0FOol3O0USOol005]oo`Al2AEoo`03001oogoo
01=oo`=l2FIoo`00Ggoo17`94Goo00<007ooOol03Woo1G`9JGoo001SOol7O0T:Ool00`00Oomoo`07
Ool7O0U^Ool006Yoo`Ml2@=oo`04001oogooOol6O0UeOol0075oo`Ml2G]oo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo
00<007ooOol0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00GGoo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00JWoo1@001Goo00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo
00<007ooOol0O7oo001[Ool00`00Oomoo`06Ool00`00Oomoo`1lOol006aoo`03001oogoo00Eoo`80
07eoo`00KGoo00<007ooOol0Pgoo001^Ool00`00Oomoo`22Ool006Yoo`05001oogooOol00024Ool0
06]oo`<008Eoo`00lgoo003cOol00?=oo`00lgoo002AOol3000;Ool40005Ool20004Ool40005Ool4
000hOol0091oo`06001oogooOol007oo1P000Woo00<007ooOol00Woo00<007ooOol00Woo0P0027oo
00D007ooOomoo`0000Aoo`03001oogoo03Eoo`00Lgoo0P0000=oo`00000067oo00<007ooOol02goo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol01Goo00<007ooOol0=Goo001bOol00`00Oomo
o`02000IOol00`00Oomoo`03Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`09Ool50007Ool00`00
Oomoo`0eOol0079oo`05001oogooOol0000IOol00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomo
o`08Ool00`00Oomoo`02Ool01000Oomoogoo1000>7oo001bOol01@00Oomoogoo000067oo1@002Woo
00<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00D007ooOomoo`0003]oo`00LWoo00D0
07ooOomoo`0001Uoo`03001oogoo00]oo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009o
o`05001oogooOol0000kOol0075oo`80009oo`8002Qoo`@000aoo`@000Aoo`D003Moo`00lgoo003c
Ool00?=oo`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.9) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 0 .6 r

.5 Mabswid

.17404 .49992 m

.17543 .46992 L

.17959 .4401 L

.18648 .4108 L

.19605 .38225 L

.20821 .35471 L

.22286 .3284 L

.23988 .30357 L

.25911 .2804 L

.2804 .25911 L

.30357 .23988 L

.3284 .22286 L

.35471 .20821 L

.38225 .19605 L

.4108 .18648 L

.4401 .17959 L

.46992 .17543 L

.5 .17404 L

.53008 .17543 L

.5599 .17959 L

.5892 .18648 L

.61775 .19605 L

.64529 .20821 L

.6716 .22286 L

.69643 .23988 L

.7196 .25911 L

.74089 .2804 L

.76012 .30357 L

.77714 .3284 L

.79179 .35471 L

.80395 .38225 L

.81352 .4108 L

.82041 .4401 L

.82457 .46992 L

.82596 .49992 L

s

.17404 .50008 m

.17543 .53008 L

.17959 .5599 L

.18648 .5892 L

.19605 .61775 L

.20821 .64529 L

.22286 .6716 L

.23988 .69643 L

.25911 .7196 L

.2804 .74089 L

.30357 .76012 L

.3284 .77714 L

.35471 .79179 L

.38225 .80395 L

.4108 .81352 L

.4401 .82041 L

.46992 .82457 L

.5 .82596 L

.53008 .82457 L

.5599 .82041 L

.5892 .81352 L

.61775 .80395 L

.64529 .79179 L

.6716 .77714 L

.69643 .76012 L

.7196 .74089 L

.74089 .7196 L

.76012 .69643 L

.77714 .6716 L

.79179 .64529 L

.80395 .61775 L

.81352 .5892 L

.82041 .5599 L

.82457 .53008 L

.82596 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol006]ooa=l4WEoo`00IWoo1G`B2Goo00<0
07ooOol01goo1G`BL7oo001ROol4O18>Ool00`00Oomoo`0<Ool3O19]Ool005moo`=l4Q9oo`03001o
ogoo00moo`=l4VYoo`00G7oo0g`B5Goo00<007ooOol04Woo0g`BIgoo001IOol3O18HOol00`00Oomo
o`0EOol3O19TOol005Ioo`=l4Q]oo`03001oogoo01Qoo`=l4V5oo`00E7oo0W`B7Woo00<007ooOol0
6goo0W`BGgoo001BOol2O18POol00`00Oomoo`0MOol2O19MOol0051oo`9l4R9oo`03001oogoo01mo
o`9l4U]oo`00Cgoo00=l4WooOol08Woo00<007ooOol08Goo0W`BFGoo001=Ool2O18UOol00`00Oomo
o`0SOol00g`BOomoo`1FOol004aoo`03O19oogoo02Eoo`03001oogoo02Aoo`9l4UIoo`00BWoo0W`B
7goo1@0017oo00<007ooOol09Woo00=l4WooOol0Dgoo0019Ool00g`BOomoo`0QOol00`00Oomoo`04
Ool00`00Oomoo`0WOol00g`BOomoo`1BOol004Qoo`03O19oogoo029oo`03001oogoo00Aoo`03001o
ogoo02Qoo`03O19oogoo055oo`00AWoo0W`B6Woo1P001Goo00<007ooOol017oo0P00:Woo0W`BDGoo
0015Ool00g`BOomoo`0UOol00`00Oomoo`04Ool00`00Oomoo`0[Ool00g`BOomoo`1>Ool004Aoo`03
O19oogoo02Ioo`03001oogoo00Aoo`03001oogoo02aoo`03O19oogoo04eoo`00@goo00=l4WooOol0
9Goo0`001Woo00<007ooOol0;Goo00=l4WooOol0C7oo0012Ool00g`BOomoo`0XOol00`00Oomoo`04
Ool00`00Oomoo`0^Ool00g`BOomoo`1;Ool0049oo`03O19oogoo02moo`03001oogoo02moo`03O19o
ogoo04Yoo`00@Goo00=l4WooOol0<7oo00<007ooOol0<7oo00=l4WooOol0BGoo0010Ool00g`BOomo
o`0aOol00`00Oomoo`0aOol00g`BOomoo`18Ool003moo`03O19oogoo039oo`03001oogoo039oo`03
O19oogoo04Moo`00?Woo00=l4WooOol0<goo00<007ooOol0<goo00=l4WooOol0AWoo000nOol00g`B
Oomoo`0cOol00`00Oomoo`0cOol00g`BOomoo`16Ool003eoo`03O19oogoo03Aoo`03001oogoo03Ao
o`03O19oogoo04Eoo`00?7oo00=l4WooOol0=Goo00<007ooOol0=Goo00=l4WooOol0A7oo000kOol0
0g`BOomoo`0fOol00`00Oomoo`0fOol00g`BOomoo`13Ool003Yoo`03O19oogoo03Moo`03001oogoo
03Ioo`03O19oogoo04=oo`00>Woo00=l4WooOol0=goo00<007ooOol0=goo00=l4WooOol0@Woo000i
Ool00g`BOomoo`0hOol00`00Oomoo`0gOol00g`BOomoo`12Ool003Qoo`03O19oogoo03Uoo`03001o
ogoo03Qoo`03O19oogoo045oo`00=goo00=l4WooOol0>Woo00<007ooOol0>Goo00=l4WooOol0@7oo
000gOol00g`BOomoo`0jOol00`00Oomoo`0iOol00g`BOomoo`10Ool003Ioo`03O19oogoo03]oo`03
001oogoo03Yoo`03O19oogoo03moo`00=Woo00=l4WooOol0>goo00<007ooOol0>goo00=l4WooOol0
?Woo000eOol00g`BOomoo`0lOol00`00Oomoo`0kOol00g`BOomoo`0nOol003Eoo`03O19oogoo03ao
o`03001oogoo03aoo`03O19oogoo03eoo`00=7oo00=l4WooOol097oo10001Goo0P001Goo10001Goo
00<007ooOol0?7oo00=l4WooOol0?Goo000dOol00g`BOomoo`0SOol00`00Oomoo`02Ool00`00Oomo
o`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0mOol00g`BOomoo`0lOol0
03=oo`03O19oogoo02Aoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo
03eoo`03O19oogoo03aoo`00<goo00=l4WooOol077oo1P000Woo00<007ooOol00Woo00<007ooOol0
3Goo00<007ooOol00Woo0P00?Woo00=l4WooOol0?7oo000bOol00g`BOomoo`0UOol00`00Oomoo`02
Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0nOol00g`BOomoo`0kOol0039oo`03O19oogoo02Eo
o`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo03ioo`03O19oogoo03]o
o`00<Woo00=l4WooOol09Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007oo
Ool0?Woo00=l4WooOol0>goo000aOol00g`BOomoo`0WOol4000<Ool50004Ool00`00Oomoo`0oOol0
0g`BOomoo`0jOol0035oo`03O19oogoo041oo`03001oogoo03moo`03O19oogoo03Yoo`00<Goo00=l
4WooOol0@7oo00<007ooOol0?goo00=l4WooOol0>Woo000`Ool00g`BOomoo`11Ool00`00Oomoo`10
Ool00g`BOomoo`0iOol0031oo`03O19oogoo045oo`03001oogoo041oo`03O19oogoo03Uoo`00<7oo
00=l4WooOol0@Goo00<007ooOol0@7oo00=l4WooOol0>Goo000`Ool00g`BOomoo`11Ool00`00Oomo
o`11Ool00g`BOomoo`0hOol002moo`03O19oogoo049oo`03001oogoo045oo`03O19oogoo03Qoo`00
;goo00=l4WooOol0@Woo00<007ooOol0@Goo00=l4WooOol0>7oo0009Ool5000?Ool50004Ool20005
Ool200000g`B001oo`0>Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool2
0005Ool4000?Ool5000<Ool00g`BOol000040004Ool20005Ool4000>Ool5000AOol000Uoo`05001o
ogooOol0000AOol00`00Oomoo`04Ool20004Ool01P00Oomoog`BOol0011oo`03001oogoo00eoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo
00eoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00ioo`03
001oogoo00aoo`05O19oogooOol00006Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool01@00
Oomoogoo00004Goo000:Ool00`00Oomoo`0BOol00`00Oomoo`0=Ool00g`BOol0000@Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0<Ool01G`BOomoogoo00004Goo00<0
07ooOol037oo00<007ooOol04Woo00000goo000000040004Ool00`00Oomoo`06Ool60005Ool00`00
Oomoo`0=Ool00g`BOol00005Ool60005Ool00`00Oomoo`05Ool60002Ool00`00Oomoo`02Ool00`00
Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00
Oomoo`0>Ool00`00Oomoo`0<Ool01G`BOomoogoo00004Goo00<007ooOol03Goo00<007ooOol04Goo
000<Ool00`00Oomoo`0@Ool00`00Oomoo`0;Ool200000g`B001oo`0@Ool00`00Oomoo`0=Ool00`00
Oomoo`02Ool00`00Oomoo`09Ool4000=Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool4000AOol00`00Oomoo`0<Ool01G`BOomoogoo00003Goo10004Goo00<007ooOol047oo000=Ool0
0`00Oomoo`0?Ool00`00Oomoo`0;Ool00`00O19oo`0BOol00`00Oomoo`0=Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool0
0`00Oomoo`0BOol00`00Oomoo`0=Ool017`BOomoo`003Goo00<007ooOol04goo00<007ooOol03goo
0009Ool01@00Oomoogoo00003goo0`003Goo00<007`BOol047oo0`003goo00<007ooOol00Woo00<0
07ooOol02Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol047oo0`003goo00Al4P00000000eoo`03001oogoo00moo`05001oogooOol0000AOol000Yo
o`<0019oo`03001oogoo00]oo`03001l4P000080011oo`03001oogoo00ioo`@000aoo`D000aoo`03
001oogoo00ioo`@000aoo`D0011oo`03001oogoo00eoo`04O19oogoo000=Ool5000>Ool3000BOol0
02ioo`03O19oogoo04=oo`03001oogoo04=oo`03O19oogoo03Ioo`00;Woo00=l4WooOol0@goo00<0
07ooOol0@goo00=l4WooOol0=Woo000^Ool00g`BOomoo`13Ool00`00Oomoo`13Ool00g`BOomoo`0f
Ool002eoo`03O19oogoo04Aoo`03001oogoo04=oo`03O19oogoo03Ioo`00;Goo00=l4WooOol0A7oo
00<007ooOol0@goo00=l4WooOol0:goo0P000Woo0P001Goo000]Ool00g`BOomoo`14Ool00`00Oomo
o`13Ool00g`BOomoo`0/Ool01000Oomoo`001Woo0008OolU00000g`B0000002:00000g`B0000000T
0009Ool20007Ool000Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03O18007oo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03O19oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo00Moo`8000Moo`0027oo00<007ooOol067oo00<007ooOol0
1goo00=l4WooOol03Woo00<007ooOol067oo00<007ooOol067oo00<007ooOol067oo00<007ooOol0
67oo00<007ooOol03Goo00=l4WooOol027oo00<007ooOol067oo00<007ooOol01Woo00@007ooOol0
00Ioo`00;Goo00=l4WooOol0A7oo00<007ooOol0@goo00=l4WooOol0:goo0P000Woo0P001Goo000^
Ool00g`BOomoo`13Ool00`00Oomoo`13Ool00g`BOomoo`0fOol002ioo`03O19oogoo04=oo`03001o
ogoo04=oo`03O19oogoo03Ioo`00;Woo00=l4WooOol0@goo00<007ooOol0@goo00=l4WooOol0=Woo
000^Ool00g`BOomoo`13Ool00`00Oomoo`13Ool00g`BOomoo`0fOol002ioo`03O19oogoo04=oo`03
001oogoo04=oo`03O19oogoo03Ioo`00;Woo00=l4WooOol0@goo00<007ooOol0@goo00=l4WooOol0
=Woo000_Ool00g`BOomoo`12Ool00`00Oomoo`12Ool00g`BOomoo`0gOol002moo`03O19oogoo049o
o`03001oogoo049oo`03O19oogoo03Moo`00;goo00=l4WooOol0@Woo00<007ooOol0@Woo00=l4Woo
Ool0=goo000_Ool00g`BOomoo`12Ool00`00Oomoo`12Ool00g`BOomoo`0gOol002moo`03O19oogoo
049oo`03001oogoo049oo`03O19oogoo03Moo`00;goo00=l4WooOol0@Woo00<007ooOol0@Goo00=l
4WooOol0>7oo000`Ool00g`BOomoo`11Ool00`00Oomoo`11Ool00g`BOomoo`0hOol0031oo`03O19o
ogoo045oo`03001oogoo045oo`03O19oogoo03Qoo`00<7oo00=l4WooOol0@Goo00<007ooOol0@7oo
00=l4WooOol0>Goo000`Ool00g`BOomoo`11Ool00`00Oomoo`10Ool00g`BOomoo`0iOol0031oo`03
O19oogoo045oo`03001oogoo041oo`03O19oogoo03Uoo`00<Goo00=l4WooOol0@7oo00<007ooOol0
?goo00=l4WooOol0>Woo000aOol00g`BOomoo`10Ool00`00Oomoo`0oOol00g`BOomoo`0jOol0035o
o`03O19oogoo041oo`03001oogoo03moo`03O19oogoo03Yoo`00<Goo00=l4WooOol09goo10001Goo
0P001Goo10001Goo00<007ooOol0?goo00=l4WooOol0>Woo000bOol00g`BOomoo`0UOol00`00Oomo
o`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0nOol0
0g`BOomoo`0kOol0039oo`03O19oogoo02Eoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo
009oo`03001oogoo03ioo`03O19oogoo03]oo`00<goo00=l4WooOol097oo00<007ooOol00Woo00<0
07ooOol03Goo00<007ooOol00Woo0P00?goo00=l4WooOol0>goo000cOol00g`BOomoo`0TOol00`00
Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0mOol00g`BOomoo`0lOol003Aoo`03O19o
ogoo02=oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo03eoo`03O19o
ogoo03aoo`00=7oo00=l4WooOol08goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo
00<007ooOol0?Goo00=l4WooOol0?7oo000eOol00g`BOomoo`0SOol4000<Ool50004Ool00`00Oomo
o`0lOol00g`BOomoo`0mOol003Eoo`03O19oogoo03aoo`03001oogoo03aoo`03O19oogoo03eoo`00
=Woo00=l4WooOol0>goo00<007ooOol0>goo00=l4WooOol0?Woo000fOol00g`BOomoo`0kOol00`00
Oomoo`0jOol00g`BOomoo`0oOol003Moo`03O19oogoo03Yoo`03001oogoo03Yoo`03O19oogoo03mo
o`00=goo00=l4WooOol0>Woo00<007ooOol0>Goo00=l4WooOol0@7oo000hOol00g`BOomoo`0iOol0
0`00Oomoo`0hOol00g`BOomoo`11Ool003Uoo`03O19oogoo03Qoo`03001oogoo03Moo`03O19oogoo
049oo`00>Goo00=l4WooOol0>7oo00<007ooOol0=goo00=l4WooOol0@Woo000jOol00g`BOomoo`0g
Ool00`00Oomoo`0fOol00g`BOomoo`13Ool003]oo`03O19oogoo03Ioo`03001oogoo03Ioo`03O19o
ogoo04=oo`00>goo00=l4WooOol0=Woo00<007ooOol0=Goo00=l4WooOol0A7oo000lOol00g`BOomo
o`0eOol00`00Oomoo`0eOol00g`BOomoo`14Ool003eoo`03O19oogoo03Aoo`03001oogoo03Aoo`03
O19oogoo04Eoo`00?Woo00=l4WooOol0<goo00<007ooOol0<goo00=l4WooOol0AWoo000nOol00g`B
Oomoo`0cOol00`00Oomoo`0cOol00g`BOomoo`16Ool003moo`03O19oogoo039oo`03001oogoo039o
o`03O19oogoo04Moo`00@7oo00=l4WooOol0<Goo00<007ooOol0<Goo00=l4WooOol0B7oo0011Ool0
0g`BOomoo`0`Ool00`00Oomoo`0`Ool00g`BOomoo`19Ool0049oo`03O19oogoo02moo`03001oogoo
02ioo`9l4Taoo`00@goo00=l4WooOol09Goo1@0017oo00<007ooOol0;Goo00=l4WooOol0C7oo0014
Ool00g`BOomoo`0VOol00`00Oomoo`04Ool00`00Oomoo`0/Ool00g`BOomoo`1=Ool004Eoo`03O19o
ogoo02Eoo`03001oogoo00Aoo`03001oogoo02]oo`03O19oogoo04ioo`00AWoo0W`B9Goo00<007oo
Ool017oo0P00:Woo0W`BDGoo0018Ool00g`BOomoo`0ROol00`00Oomoo`04Ool00`00Oomoo`0XOol0
0g`BOomoo`1AOol004Uoo`03O19oogoo025oo`03001oogoo00Aoo`03001oogoo02Moo`03O19oogoo
059oo`00BWoo0W`B7goo0`001Woo00<007ooOol09Woo00=l4WooOol0Dgoo001<Ool00g`BOomoo`0N
Ool00`00Oomoo`04Ool00`00Oomoo`0TOol2O19FOol004eoo`9l4REoo`03001oogoo02=oo`03O19o
ogoo05Ioo`00Cgoo00=l4WooOol08Woo00<007ooOol08Woo00=l4WooOol0Egoo001@Ool2O18ROol0
0`00Oomoo`0POol2O19JOol0059oo`9l4R1oo`03001oogoo01ioo`9l4Uaoo`00E7oo00=l4WooOol0
7Goo00<007ooOol077oo0W`BGWoo001EOol2O18MOol00`00Oomoo`0JOol2O19POol005Moo`9l4Q]o
o`03001oogoo01Qoo`9l4V9oo`00FGoo0g`B67oo00<007ooOol05Goo0g`BI7oo001LOol3O18EOol0
0`00Oomoo`0BOol3O19WOol005moo`El4Q1oo`03001oogoo00ioo`Al4VYoo`00I7oo1W`B2Woo00<0
07ooOol01goo1g`BKWoo001ZOolDO19eOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007ooOol0O7oo
001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1lOol0
05eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00GGoo00<007ooOol03goo00<0
07ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1lOol005eoo`03001o
ogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007ooOol01Woo00<007oo
Ool0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00JWoo1@001Goo00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo
001[Ool00`00Oomoo`06Ool00`00Oomoo`1lOol006aoo`03001oogoo00Eoo`8007eoo`00KGoo00<0
07ooOol0Pgoo001^Ool00`00Oomoo`22Ool006Yoo`05001oogooOol00024Ool006]oo`<008Eoo`00
lgoo003cOol00?=oo`00lgoo002EOol3000;Ool40005Ool20004Ool4000mOol009Aoo`06001oogoo
Ool007oo1P000Woo00<007ooOol00Woo00<007ooOol00Woo0P0027oo00<007ooOol0>Woo001cOol2
00000goo0000000LOol00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0i
Ool0079oo`03001oogoo008001eoo`03001oogoo00=oo`H0009oo`03001oogoo009oo`03001oogoo
00Uoo`D003]oo`00LWoo00D007ooOomoo`0001eoo`03001oogoo00]oo`03001oogoo009oo`03001o
ogoo00Qoo`03001oogoo009oo`03001oogoo03Uoo`00LWoo00D007ooOomoo`0001aoo`D000Yoo`03
001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo03Uoo`00LWoo00D007ooOomo
o`0001eoo`03001oogoo00]oo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001o
ogoo03Uoo`00LGoo0P000Woo0P00;7oo100037oo1000?7oo003cOol00?=oo`00lgoo003cOol00?=o
o`00\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.85) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 0 .9 r

.5 Mabswid

.18875 .49992 m

.19008 .47128 L

.19405 .44281 L

.20063 .41482 L

.20977 .38756 L

.22138 .36127 L

.23537 .33615 L

.25162 .31243 L

.26999 .29031 L

.29031 .26999 L

.31243 .25162 L

.33615 .23537 L

.36127 .22138 L

.38756 .20977 L

.41482 .20063 L

.44281 .19405 L

.47128 .19008 L

.5 .18875 L

.52872 .19008 L

.55719 .19405 L

.58518 .20063 L

.61244 .20977 L

.63873 .22138 L

.66385 .23537 L

.68757 .25162 L

.70969 .26999 L

.73001 .29031 L

.74838 .31243 L

.76463 .33615 L

.77862 .36127 L

.79023 .38756 L

.79937 .41482 L

.80595 .44281 L

.80992 .47128 L

.81125 .49992 L

s

.18875 .50008 m

.19008 .52872 L

.19405 .55719 L

.20063 .58518 L

.20977 .61244 L

.22138 .63873 L

.23537 .66385 L

.25162 .68757 L

.26999 .70969 L

.29031 .73001 L

.31243 .74838 L

.33615 .76463 L

.36127 .77862 L

.38756 .79023 L

.41482 .79937 L

.44281 .80595 L

.47128 .80992 L

.5 .81125 L

.52872 .80992 L

.55719 .80595 L

.58518 .79937 L

.61244 .79023 L

.63873 .77862 L

.66385 .76463 L

.68757 .74838 L

.70969 .73001 L

.73001 .70969 L

.74838 .68757 L

.76463 .66385 L

.77862 .63873 L

.79023 .61244 L

.79937 .58518 L

.80595 .55719 L

.80992 .52872 L

.81125 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{194.313, 194.313},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003b0000lQ000`40O003h00OlWoo003bOol006Yo
o`D008=oo`00JWoo00D007ooOomoo`0008=oo`00Jgoo00<007ooOol0Q7oo001ROol60004Ool00`00
Oomoo`04Ool3001lOol006eoo`03001oogoo00=oo`03001oogoo07aoo`00KWoo00<007ooOol00Woo
00<007ooOol0O7oo001ZOol01@00Oomoogoo000017oo00<007ooOol0O7oo001[Ool30005Ool00`00
Oomoo`1lOol007=oo`03001oogoo07aoo`00Lgoo0P00OGoo001cOol00`00Oomoo`1lOol007=oo`03
001oogoo07aoo`00Lgoo00<007ooOol0O7oo001cOol00`00Oomoo`1lOol007=oo`8007eoo`00Lgoo
00<007ooOol0O7oo001cOol00`00Oomoo`1lOol007=oo`03001oogoo07aoo`00Lgoo00<007ooOol0
O7oo001cOol2001mOol007=oo`03001oogoo07aoo`00Lgoo00<007ooOol0O7oo001cOol00`00Oomo
o`1lOol007=oo`03001oogoo07aoo`00Lgoo00<007ooOol0O7oo001cOol2001mOol007=oo`03001o
ogoo07aoo`00Fgoo1@0017oo0P001Goo100017oo00<007ooOol0O7oo001MOol00`00Oomoo`04Ool2
0004Ool00`00Oomoo`02Ool01@00Oomoogoo0000OWoo001MOol00`00Oomoo`0?Ool01@00Oomoogoo
0000OWoo001BOol60005Ool00`00Oomoo`0?Ool01000Oomoogoo0`00O7oo001MOol00`00Oomoo`0;
Ool40004Ool00`00Oomoo`1lOol005eoo`03001oogoo00]oo`03001oogoo00Eoo`03001oogoo07ao
o`00Fgoo0`003Goo00<007ooOol01Goo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50003Ool0
0`00Oomoo`1lOol007=oo`8007eoo`00Lgoo00<007ooOol0O7oo001cOol00`00Oomoo`1lOol007=o
o`03001oogoo07aoo`00Lgoo00<007ooOol0O7oo001cOol00`00Oomoo`1lOol007=oo`8007eoo`00
Lgoo00<007ooOol0O7oo001cOol00`00Oomoo`1lOol006]ooa9l77Eoo`00IGoo1W`L27oo00<007oo
Ool01goo1W`LKgoo001POol5O1`>Ool2000>Ool5O1aZOol005eoo`=l71=oo`03001oogoo019oo`9l
76Qoo`00Fgoo0W`L5Woo00<007ooOol057oo0W`LIWoo001IOol2O1`HOol00`00Oomoo`0FOol2O1aT
Ool005Moo`9l71Yoo`03001oogoo01Qoo`9l769oo`00EGoo0W`L77oo00<007ooOol06Woo0W`LH7oo
001COol2O1`NOol2000MOol2O1aNOol0055oo`9l721oo`03001oogoo01ioo`9l75aoo`00D7oo00=l
77ooOol067oo1@000goo00<007ooOol087oo00=l77ooOol0FGoo001>Ool2O1`MOol00`00Oomoo`03
Ool00`00Oomoo`0QOol2O1aIOol004aoo`9l71moo`03001oogoo00=oo`03001oogoo02=oo`9l75Mo
o`00Bgoo00=l77ooOol057oo1P001Goo00<007ooOol00goo0`009Goo0W`LEGoo001:Ool00g`LOomo
o`0POol00`00Oomoo`03Ool00`00Oomoo`0WOol00g`LOomoo`1BOol004Qoo`9l72=oo`03001oogoo
00=oo`03001oogoo02Qoo`03O1aoogoo055oo`00Agoo00=l77ooOol08Goo0`001Goo00<007ooOol0
:Goo00=l77ooOol0D7oo0016Ool00g`LOomoo`0TOol00`00Oomoo`03Ool00`00Oomoo`0ZOol00g`L
Oomoo`1?Ool004Eoo`03O1aoogoo02]oo`8002aoo`03O1aoogoo04ioo`00A7oo00=l77ooOol0;7oo
00<007ooOol0;7oo00=l77ooOol0CGoo0014Ool00g`LOomoo`0/Ool00`00Oomoo`0]Ool00g`LOomo
o`1<Ool004=oo`03O1aoogoo02eoo`03001oogoo02ioo`03O1aoogoo04]oo`00@Woo00=l77ooOol0
;Woo00<007ooOol0;goo00=l77ooOol0BWoo0011Ool00g`LOomoo`0_Ool00`00Oomoo`0`Ool00g`L
Oomoo`19Ool0041oo`03O1aoogoo031oo`80039oo`03O1aoogoo04Qoo`00?goo00=l77ooOol0<Goo
00<007ooOol0<Woo00=l77ooOol0Agoo000nOol00g`LOomoo`0bOol00`00Oomoo`0cOol00g`LOomo
o`16Ool003eoo`03O1aoogoo03=oo`03001oogoo03Aoo`03O1aoogoo04Eoo`00?7oo00=l77ooOol0
=7oo00<007ooOol0=7oo00=l77ooOol0AGoo000lOol00g`LOomoo`0dOol2000fOol00g`LOomoo`14
Ool003]oo`03O1aoogoo03Eoo`03001oogoo03Eoo`03O1aoogoo04Aoo`00>Woo00=l77ooOol0=Woo
00<007ooOol0=Woo00=l77ooOol0@goo000iOol00g`LOomoo`0gOol00`00Oomoo`0gOol00g`LOomo
o`12Ool003Uoo`03O1aoogoo03Moo`03001oogoo03Moo`03O1aoogoo049oo`00>7oo00=l77ooOol0
>7oo0P00>Goo00=l77ooOol0@Goo000hOol00g`LOomoo`0hOol00`00Oomoo`0hOol00g`LOomoo`11
Ool003Moo`03O1aoogoo03Uoo`03001oogoo03Uoo`03O1aoogoo041oo`00=goo00=l77ooOol08Goo
10001Goo0P001Goo100017oo00<007ooOol0>Goo00=l77ooOol0@7oo000gOol00g`LOomoo`0POol0
0`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool01@00Oomoogoo0000?7oo00=l
77ooOol0?goo000fOol00g`LOomoo`0QOol00`00Oomoo`02Ool00`00Oomoo`0=Ool01@00Oomoogoo
0000?7oo00=l77ooOol0?goo000fOol00g`LOomoo`0IOol60002Ool00`00Oomoo`02Ool00`00Oomo
o`0=Ool01000Oomoogoo0`00>goo00=l77ooOol0?Woo000eOol00g`LOomoo`0ROol00`00Oomoo`02
Ool00`00Oomoo`09Ool40004Ool00`00Oomoo`0kOol00g`LOomoo`0nOol003Eoo`03O1aoogoo029o
o`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Eoo`03001oogoo03aoo`03O1aoogoo03eo
o`00=Goo00=l77ooOol08Woo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Goo00<007oo
Ool0?7oo00=l77ooOol0?Goo000dOol00g`LOomoo`0TOol4000<Ool50003Ool00`00Oomoo`0mOol0
0g`LOomoo`0lOol003Aoo`03O1aoogoo03aoo`8003ioo`03O1aoogoo03aoo`00=7oo00=l77ooOol0
?7oo00<007ooOol0?Goo00=l77ooOol0?7oo000cOol00g`LOomoo`0mOol00`00Oomoo`0nOol00g`L
Oomoo`0kOol003=oo`03O1aoogoo03eoo`03001oogoo03ioo`03O1aoogoo03]oo`00<goo00=l77oo
Ool0?Goo00<007ooOol0?Woo00=l77ooOol0>goo000cOol00g`LOomoo`0mOol00`00Oomoo`0nOol0
0g`LOomoo`0kOol0039oo`03O1aoogoo03ioo`80041oo`03O1aoogoo03Yoo`00<Woo00=l77ooOol0
?Woo00<007ooOol0?goo00=l77ooOol0>Woo0009Ool5000?Ool50004Ool20005Ool400000gooO1ao
o`0<Ool5000=Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool5
0009Ool00g`LOomoo`02Ool50004Ool20005Ool4000>Ool5000AOol000Uoo`05001oogooOol0000A
Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00O1aoo`0>Ool00`00Oomoo`0<Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00
Oomoo`09Ool00g`LOomoo`04Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0;
Ool01@00Oomoogoo00004Goo000:Ool00`00Oomoo`0BOol00`00Oomoo`0?Ool00`00O1aoo`0>Ool0
0`00Oomoo`0<Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`09Ool00g`LOomoo`04Ool0
0`00Oomoo`0?Ool00`00Oomoo`0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo
00Ioo`H000Eoo`03001oogoo00moo`03001l77oo00=oo`H000Eoo`03001oogoo00Aoo`H0009oo`03
001oogoo009oo`03001oogoo00eoo`03001oogoo00Yoo`8000ioo`03001oogoo009oo`03001oogoo
00eoo`03001oogoo00ioo`03001oogoo00Uoo`03O1aoogoo00Aoo`03001oogoo00moo`03001oogoo
00eoo`03001oogoo015oo`0037oo00<007ooOol047oo00<007ooOol02goo100000=l77ooOol03Woo
00<007ooOol037oo00<007ooOol00Woo00<007ooOol02Goo10003Goo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol02Goo10004Goo00<007ooOol02Woo00=l77ooOol00goo00<007ooOol02goo
10004Goo00<007ooOol047oo000=Ool00`00Oomoo`0?Ool00`00Oomoo`0;Ool01@00OomoogooO1`0
47oo00<007ooOol037oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol0
3Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol04Woo00<007ooOol02Woo00=l77ooOol0
0goo00<007ooOol02goo00<007ooOol04goo00<007ooOol03goo0009Ool01@00Oomoogoo00003goo
0`003Goo00D007ooOomoog`L00ioo`<000ioo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00ioo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo011oo`<000aoo`04
O1aoogooOol3000=Ool00`00Oomoo`0?Ool01@00Oomoogoo00004Goo000:Ool3000BOol00`00Oomo
o`0;Ool400000g`LOomoo`0>Ool00`00Oomoo`0=Ool4000<Ool5000<Ool00`00Oomoo`0>Ool4000<
Ool5000@Ool00`00Oomoo`0:Ool00g`LOomoo`03Ool00`00Oomoo`0;Ool5000>Ool3000BOol0035o
o`03O1aoogoo03moo`80045oo`03O1aoogoo03Uoo`00<Goo00=l77ooOol0?goo00<007ooOol0@7oo
00=l77ooOol0>Goo000aOol00g`LOomoo`0oOol00`00Oomoo`10Ool00g`LOomoo`0iOol0031oo`03
O1aoogoo041oo`03001oogoo041oo`03O1aoogoo02moo`80009oo`8000Aoo`00<7oo00=l77ooOol0
@7oo00<007ooOol0@7oo00=l77ooOol0<7oo00@007ooOol000Eoo`00<7oo00=l77ooOol0@7oo00<0
07ooOol0@7oo00=l77ooOol0<Goo0P001Woo0008OolX00000g`L0000002300000g`L0000000W000:
Ool20006Ool000Qoo`03001oogoo01Qoo`03001oogoo00Yoo`03O1aoogoo00]oo`03001oogoo01Mo
o`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo00Yoo`03O1aoogoo00]o
o`03001oogoo01Qoo`03001oogoo00Moo`04001oogoo0005Ool0031oo`03O1aoogoo041oo`03001o
ogoo041oo`03O1aoogoo02moo`80009oo`8000Aoo`00<Goo00=l77ooOol0?goo00<007ooOol0@7oo
00=l77ooOol0>Goo000aOol00g`LOomoo`0oOol00`00Oomoo`10Ool00g`LOomoo`0iOol0035oo`03
O1aoogoo03moo`80045oo`03O1aoogoo03Uoo`00<Goo00=l77ooOol0?goo00<007ooOol0@7oo00=l
77ooOol0>Goo000aOol00g`LOomoo`0oOol00`00Oomoo`10Ool00g`LOomoo`0iOol0035oo`03O1ao
ogoo03moo`03001oogoo041oo`03O1aoogoo03Uoo`00<Woo00=l77ooOol0?Woo00<007ooOol0?goo
00=l77ooOol0>Woo000bOol00g`LOomoo`0nOol20010Ool00g`LOomoo`0jOol0039oo`03O1aoogoo
03ioo`03001oogoo03moo`03O1aoogoo03Yoo`00<Woo00=l77ooOol0?Woo00<007ooOol0?goo00=l
77ooOol0>Woo000bOol00g`LOomoo`0nOol00`00Oomoo`0oOol00g`LOomoo`0jOol0039oo`03O1ao
ogoo03ioo`03001oogoo03moo`03O1aoogoo03Yoo`00<goo00=l77ooOol0?Goo00<007ooOol0?Woo
00=l77ooOol0>goo000cOol00g`LOomoo`0mOol2000oOol00g`LOomoo`0kOol003=oo`03O1aoogoo
03eoo`03001oogoo03ioo`03O1aoogoo03]oo`00<goo00=l77ooOol0?Goo00<007ooOol0?Woo00=l
77ooOol0>goo000cOol00g`LOomoo`0mOol00`00Oomoo`0nOol00g`LOomoo`0kOol003Aoo`03O1ao
ogoo03aoo`03001oogoo03eoo`03O1aoogoo03aoo`00=7oo00=l77ooOol0?7oo0P00?Woo00=l77oo
Ool0?7oo000dOol00g`LOomoo`0lOol00`00Oomoo`0mOol00g`LOomoo`0lOol003Eoo`03O1aoogoo
02=oo`@000Eoo`8000Eoo`@000Aoo`03001oogoo03aoo`03O1aoogoo03eoo`00=Goo00=l77ooOol0
8Woo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00D007ooOomoo`0003io
o`03O1aoogoo03eoo`00=Goo00=l77ooOol08Woo00<007ooOol00Woo00<007ooOol03Goo00D007oo
Oomoo`0003eoo`03O1aoogoo03ioo`00=Woo00=l77ooOol08Goo00<007ooOol00Woo00<007ooOol0
3Goo00@007ooOomoo`<003]oo`03O1aoogoo03ioo`00=Woo00=l77ooOol08Goo00<007ooOol00Woo
00<007ooOol02Goo100017oo00<007ooOol0>Woo00=l77ooOol0?goo000gOol00g`LOomoo`0POol0
0`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`05Ool00`00Oomoo`0jOol00g`LOomoo`0oOol0
03Moo`03O1aoogoo021oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Eoo`03001oogoo
03Uoo`03O1aoogoo041oo`00>7oo00=l77ooOol087oo100037oo1@000goo00<007ooOol0>7oo00=l
77ooOol0@Goo000hOol00g`LOomoo`0hOol00`00Oomoo`0hOol00g`LOomoo`11Ool003Uoo`03O1ao
ogoo03Moo`8003Qoo`03O1aoogoo049oo`00>Goo00=l77ooOol0=goo00<007ooOol0=goo00=l77oo
Ool0@Woo000jOol00g`LOomoo`0fOol00`00Oomoo`0fOol00g`LOomoo`13Ool003Yoo`03O1aoogoo
03Ioo`03001oogoo03Ioo`03O1aoogoo04=oo`00>goo00=l77ooOol0=Goo00<007ooOol0=Goo00=l
77ooOol0A7oo000lOol00g`LOomoo`0dOol2000fOol00g`LOomoo`14Ool003aoo`03O1aoogoo03Ao
o`03001oogoo03Aoo`03O1aoogoo04Eoo`00?Goo00=l77ooOol0<goo00<007ooOol0=7oo00=l77oo
Ool0AGoo000nOol00g`LOomoo`0bOol00`00Oomoo`0cOol00g`LOomoo`16Ool003moo`03O1aoogoo
035oo`03001oogoo039oo`03O1aoogoo04Moo`00@7oo00=l77ooOol0<7oo00<007ooOol0<Goo00=l
77ooOol0B7oo0010Ool00g`LOomoo`0`Ool2000bOol00g`LOomoo`18Ool0045oo`03O1aoogoo02mo
o`03001oogoo031oo`03O1aoogoo04Uoo`00@Woo00=l77ooOol0;Woo00<007ooOol0;goo00=l77oo
Ool0BWoo0013Ool00g`LOomoo`0]Ool00`00Oomoo`0^Ool00g`LOomoo`1;Ool004Aoo`03O1aoogoo
02aoo`03001oogoo02aoo`9l74ioo`00AGoo00=l77ooOol0:goo0P00;7oo00=l77ooOol0CWoo0016
Ool00g`LOomoo`0ZOol00`00Oomoo`0ZOol00g`LOomoo`1?Ool004Moo`03O1aoogoo025oo`D000=o
o`03001oogoo02Uoo`03O1aoogoo051oo`00B7oo0W`L8goo00<007ooOol00goo00<007ooOol0:7oo
00=l77ooOol0DGoo001:Ool00g`LOomoo`0POol00`00Oomoo`03Ool00`00Oomoo`0WOol00g`LOomo
o`1BOol004]oo`03O1aoogoo01moo`03001oogoo00=oo`<002Ioo`03O1aoogoo05=oo`00C7oo0W`L
7goo00<007ooOol00goo00<007ooOol097oo0W`LEWoo001>Ool2O1`MOol00`00Oomoo`03Ool00`00
Oomoo`0ROol2O1aHOol0051oo`03O1aoogoo01Qoo`<000Eoo`03001oogoo021oo`9l75Yoo`00DGoo
0W`L6Woo00<007ooOol00goo00<007ooOol07Woo0W`LG7oo001COol2O1`NOol00`00Oomoo`0LOol2
O1aNOol005Eoo`03O1aoogoo01]oo`8001aoo`03O1aoogoo05ioo`00EWoo0W`L6goo00<007ooOol0
6Goo0W`LHGoo001HOol2O1`IOol00`00Oomoo`0GOol2O1aSOol005Yoo`=l71Ioo`03001oogoo01Ao
o`=l76Eoo`00GGoo0g`L4goo00<007ooOol04Woo0W`LJ7oo001POol4O1`?Ool2000?Ool4O1aZOol0
06Aoo`Il70Uoo`03001oogoo00Moo`Ml76ioo`00JWoo4g`LMGoo001cOol00`00Oomoo`1lOol007=o
o`03001oogoo07aoo`00Lgoo0P00OGoo001cOol00`00Oomoo`1lOol007=oo`03001oogoo07aoo`00
Lgoo00<007ooOol0O7oo001cOol00`00Oomoo`1lOol007=oo`03001oogoo07aoo`00Lgoo0P00OGoo
001cOol00`00Oomoo`1lOol005]oo`D000Aoo`8000Eoo`@000Aoo`03001oogoo07aoo`00GGoo00<0
07ooOol017oo0P0017oo00<007ooOol00Woo00D007ooOomoo`0007ioo`00GGoo00<007ooOol03goo
00D007ooOomoo`0007ioo`00GGoo00<007ooOol03goo00@007ooOomoo`<007aoo`00GGoo00<007oo
Ool02goo100017oo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomo
o`1lOol005]oo`<000eoo`03001oogoo00Eoo`03001oogoo07aoo`00GGoo00<007ooOol02goo1@00
0goo00<007ooOol0O7oo001cOol00`00Oomoo`1lOol007=oo`8007eoo`00Lgoo00<007ooOol0O7oo
001cOol00`00Oomoo`1lOol007=oo`03001oogoo07aoo`00Lgoo00<007ooOol0O7oo001cOol2001m
Ool007=oo`03001oogoo07aoo`00Lgoo00<007ooOol0O7oo001cOol00`00Oomoo`1lOol007=oo`03
001oogoo07aoo`00Lgoo0P00OGoo001cOol00`00Oomoo`1lOol007=oo`03001oogoo07aoo`00Lgoo
00<007ooOol0O7oo001cOol00`00Oomoo`1lOol007=oo`03001oogoo07aoo`00Lgoo0P00OGoo001c
Ool00`00Oomoo`1lOol006Yoo`D000Aoo`03001oogoo07aoo`00JWoo00D007ooOomoo`0000Aoo`03
001oogoo07aoo`00Jgoo00<007ooOol01Goo00<007ooOol0O7oo001/Ool00`00Oomoo`04Ool3001l
Ool006eoo`03001oogoo089oo`00KWoo00<007ooOol0PGoo001ZOol01@00Oomoogoo0000Pgoo001[
Ool30024Ool00?9oo`00lWoo003bOol00?9oo`00TGoo0`002goo10001Goo0P001Goo100017oo1000
=goo002@Ool01P00Oomoogoo001oo`H0009oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03
001oogoo009oo`04001oogoo0004Ool00`00Oomoo`0dOol007=oo`800003Ool0000001Qoo`03001o
ogoo00]oo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo00Eoo`03001o
ogoo03Aoo`00LWoo00<007ooOol00P006Goo00<007ooOol00goo1P000Woo00<007ooOol00Woo00<0
07ooOol027oo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol0=7oo001bOol01@00Oomoogoo
00006Goo00<007ooOol02goo00<007ooOol00Woo00<007ooOol02Goo100017oo1000=goo001bOol0
1@00Oomoogoo000067oo1@002Woo00<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00D0
07ooOomoo`0003Yoo`00LWoo00D007ooOomoo`0001Uoo`03001oogoo00]oo`03001oogoo009oo`03
001oogoo00Qoo`03001oogoo009oo`05001oogooOol0000jOol0075oo`80009oo`8002Qoo`@000ao
o`@000Aoo`D003Ioo`00lWoo003bOol00?9oo`00lWoo003bOol00001\
\>"],
  ImageRangeCache->{{{0, 241.875}, {241.875, 0}} -> {-2.1557, -2.10478, \
0.0232792, 0.0232792}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.8) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.8 0 1 r

.5 Mabswid

.2042 .49992 m

.20546 .47271 L

.20923 .44565 L

.21549 .41905 L

.22417 .39314 L

.23521 .36815 L

.2485 .34428 L

.26394 .32174 L

.2814 .30072 L

.30072 .2814 L

.32174 .26394 L

.34428 .2485 L

.36815 .23521 L

.39314 .22417 L

.41905 .21549 L

.44565 .20923 L

.47271 .20546 L

.5 .2042 L

.52729 .20546 L

.55435 .20923 L

.58095 .21549 L

.60686 .22417 L

.63185 .23521 L

.65572 .2485 L

.67826 .26394 L

.69928 .2814 L

.7186 .30072 L

.73606 .32174 L

.7515 .34428 L

.76479 .36815 L

.77583 .39314 L

.78451 .41905 L

.79077 .44565 L

.79454 .47271 L

.7958 .49992 L

s

.2042 .50008 m

.20546 .52729 L

.20923 .55435 L

.21549 .58095 L

.22417 .60686 L

.23521 .63185 L

.2485 .65572 L

.26394 .67826 L

.2814 .69928 L

.30072 .7186 L

.32174 .73606 L

.34428 .7515 L

.36815 .76479 L

.39314 .77583 L

.41905 .78451 L

.44565 .79077 L

.47271 .79454 L

.5 .7958 L

.52729 .79454 L

.55435 .79077 L

.58095 .78451 L

.60686 .77583 L

.63185 .76479 L

.65572 .7515 L

.67826 .73606 L

.69928 .7186 L

.7186 .69928 L

.73606 .67826 L

.7515 .65572 L

.76479 .63185 L

.77583 .60686 L

.78451 .58095 L

.79077 .55435 L

.79454 .52729 L

.7958 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol0079oo`ET7gaoo`00Igoo2f@O0Woo00<007ooOol02V@OLWoo001TOol3
I1l=Ool00`00Oomoo`0:Ool3I1m_Ool0065oo`=T7a1oo`03001oogoo00eoo`=T7faoo`00Ggoo0V@O
4goo00<007ooOol047oo0f@OJGoo001LOol3I1lEOol00`00Oomoo`0COol3I1mVOol005Uoo`=T7aQo
o`03001oogoo01Ioo`9T7fAoo`00Egoo0V@O4Woo1@0017oo00<007ooOol067oo0V@OHWoo001EOol2
I1lFOol00`00Oomoo`04Ool00`00Oomoo`0JOol2I1mPOol005=oo`9T7aQoo`03001oogoo00Aoo`03
001oogoo01aoo`9T7eioo`00DWoo00=T7gooOol03Goo1P001Goo00<007ooOol017oo0P007goo00=T
7gooOol0Fgoo001@Ool2I1lKOol00`00Oomoo`04Ool00`00Oomoo`0OOol2I1mKOol004ioo`9T7aeo
o`03001oogoo00Aoo`03001oogoo025oo`9T7eUoo`00CGoo00=T7gooOol06goo0`001Woo00<007oo
Ool08goo00=T7gooOol0EWoo001<Ool00f@OOomoo`0NOol00`00Oomoo`04Ool00`00Oomoo`0TOol0
0f@OOomoo`1EOol004]oo`03I1moogoo02Ioo`03001oogoo02Eoo`9T7eEoo`00BWoo00=T7gooOol0
9goo00<007ooOol09goo00=T7gooOol0DWoo0019Ool00f@OOomoo`0XOol00`00Oomoo`0XOol00f@O
Oomoo`1AOol004Qoo`03I1moogoo02Uoo`03001oogoo02Uoo`03I1moogoo051oo`00Agoo00=T7goo
Ool0:Woo00<007ooOol0:Woo00=T7gooOol0Cgoo0016Ool00f@OOomoo`0[Ool00`00Oomoo`0[Ool0
0f@OOomoo`1>Ool004Eoo`03I1moogoo02aoo`03001oogoo02aoo`03I1moogoo04eoo`00A7oo00=T
7gooOol0;Goo00<007ooOol0;Goo00=T7gooOol0C7oo0013Ool00f@OOomoo`0^Ool00`00Oomoo`0^
Ool00f@OOomoo`1;Ool004=oo`03I1moogoo02ioo`03001oogoo02ioo`03I1moogoo04]oo`00@Woo
00=T7gooOol0;goo00<007ooOol0;goo00=T7gooOol0BWoo0011Ool00f@OOomoo`0`Ool00`00Oomo
o`0`Ool00f@OOomoo`19Ool0041oo`03I1moogoo035oo`03001oogoo035oo`03I1moogoo04Qoo`00
?goo00=T7gooOol0<Woo00<007ooOol0<Goo00=T7gooOol0B7oo000oOol00f@OOomoo`0bOol00`00
Oomoo`0bOol00f@OOomoo`17Ool003ioo`03I1moogoo03=oo`03001oogoo039oo`03I1moogoo04Mo
o`00?Goo00=T7gooOol0=7oo00<007ooOol0<goo00=T7gooOol0AWoo000mOol00f@OOomoo`0dOol0
0`00Oomoo`0dOol00f@OOomoo`15Ool003aoo`03I1moogoo03Eoo`03001oogoo03Aoo`03I1moogoo
04Eoo`00?7oo00=T7gooOol077oo10001Goo0P001Goo10001Goo00<007ooOol0=Goo00=T7gooOol0
A7oo000kOol00f@OOomoo`0LOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`0eOol00f@OOomoo`14Ool003]oo`03I1moogoo01aoo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo03Ioo`03I1moogoo04=oo`00>Woo
00=T7gooOol05Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00=goo
00=T7gooOol0@goo000jOol00f@OOomoo`0MOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`0gOol00f@OOomoo`12Ool003Uoo`03I1moogoo01ioo`03001oogoo009oo`03001oogoo
00Uoo`03001oogoo00Ioo`03001oogoo03Moo`03I1moogoo049oo`00>Goo00=T7gooOol07Woo00<0
07ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0>7oo00=T7gooOol0@Goo000h
Ool00f@OOomoo`0POol4000<Ool50004Ool00`00Oomoo`0hOol00f@OOomoo`11Ool003Qoo`03I1mo
ogoo03Uoo`03001oogoo03Qoo`03I1moogoo045oo`00=goo00=T7gooOol0>Woo00<007ooOol0>Goo
00=T7gooOol0@7oo000gOol00f@OOomoo`0jOol00`00Oomoo`0iOol00f@OOomoo`10Ool003Moo`03
I1moogoo03Yoo`03001oogoo03Uoo`03I1moogoo041oo`00=Woo00=T7gooOol0>goo00<007ooOol0
>Woo00=T7gooOol0?goo000fOol00f@OOomoo`0kOol00`00Oomoo`0jOol00f@OOomoo`0oOol003Io
o`03I1moogoo03]oo`03001oogoo03Yoo`03I1moogoo03moo`00=Woo00=T7gooOol0>goo00<007oo
Ool0>Woo00=T7gooOol0?goo0009Ool5000?Ool50004Ool20005Ool40004Ool00f@OOomoo`08Ool5
000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool50005Ool0
0f@OOomoo`06Ool50004Ool20005Ool4000>Ool5000AOol000Uoo`05001oogooOol0000AOol00`00
Oomoo`04Ool20004Ool00`00Oomoo`02Ool01@00OomoogooI1l037oo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol03Woo00<007oo
Ool01Goo00=T7gooOol027oo00<007ooOol017oo0P0017oo00<007ooOol00Woo00<007ooOol02goo
00D007ooOomoo`00015oo`002Woo00<007ooOol04Woo00<007ooOol03goo00D007ooOomoof@O00ao
o`03001oogoo00eoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00Yoo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo00eoo`03001oogoo00ioo`03001oogoo00Eoo`03I1moogoo00Qo
o`03001oogoo00moo`03001oogoo00aoo`03001oogoo019oo`0000=oo`000000100017oo00<007oo
Ool01Woo1P001Goo00<007ooOol03goo00H007ooOomoof@OOol60005Ool00`00Oomoo`05Ool60002
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02
Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`05Ool00f@OOomoo`08Ool00`00Oomoo`0?
Ool00`00Oomoo`0=Ool00`00Oomoo`0AOol000aoo`03001oogoo011oo`03001oogoo00]oo`@000Ao
o`03I1moogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@000eoo`03001o
ogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@0015oo`03001oogoo00Eoo`03I1moogoo00Qo
o`03001oogoo00]oo`@0015oo`03001oogoo011oo`003Goo00<007ooOol03goo00<007ooOol02goo
00<007ooOol017oo00=T7gooOol02goo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol04Woo
00<007ooOol01Woo00=T7gooOol01goo00<007ooOol02goo00<007ooOol04goo00<007ooOol03goo
0009Ool01@00Oomoogoo00003goo0`003Goo00<007ooOol017oo00=T7gooOol02Goo0`003goo00<0
07ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<0
07ooOol02Goo00<007ooOol047oo0`0027oo00=T7gooOol01Goo0`003Goo00<007ooOol03goo00D0
07ooOomoo`00015oo`002Woo0`004Woo00<007ooOol02goo1@000Woo00=T7gooOol02goo00<007oo
Ool03Woo100037oo1@0037oo00<007ooOol03Woo100037oo1@0047oo00<007ooOol01Woo00=T7goo
Ool01goo00<007ooOol02goo1@003Woo0`004Woo000dOol00f@OOomoo`0mOol00`00Oomoo`0lOol0
0f@OOomoo`0mOol003Aoo`03I1moogoo03eoo`03001oogoo03aoo`03I1moogoo03eoo`00=7oo00=T
7gooOol0?Goo00<007ooOol0?7oo00=T7gooOol0?Goo000dOol00f@OOomoo`0mOol00`00Oomoo`0l
Ool00f@OOomoo`0mOol003Aoo`03I1moogoo03eoo`03001oogoo03aoo`03I1moogoo039oo`80009o
o`8000Eoo`00=7oo00=T7gooOol0?Goo00<007ooOol0?7oo00=T7gooOol0<goo00@007ooOol000Io
o`0027oo;00000=T7`000000O00000=T7`000000:`002Goo0P001goo0008Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00I1moo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
1P00OomoogooI1l000Eoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Moo`8000Moo`00
27oo00<007ooOol067oo00<007ooOol03Woo00=T7gooOol01goo00<007ooOol067oo00<007ooOol0
67oo00<007ooOol067oo00<007ooOol067oo00<007ooOol01Woo00=T7gooOol03goo00<007ooOol0
67oo00<007ooOol01Woo00@007ooOol000Ioo`00=7oo00=T7gooOol0?Goo00<007ooOol0?7oo00=T
7gooOol0<Woo0P000Woo0P001Goo000dOol00f@OOomoo`0mOol00`00Oomoo`0lOol00f@OOomoo`0m
Ool003Aoo`03I1moogoo03eoo`03001oogoo03aoo`03I1moogoo03eoo`00=7oo00=T7gooOol0?Goo
00<007ooOol0?7oo00=T7gooOol0?Goo000dOol00f@OOomoo`0mOol00`00Oomoo`0lOol00f@OOomo
o`0mOol003Aoo`03I1moogoo03eoo`03001oogoo03aoo`03I1moogoo03eoo`00=Goo00=T7gooOol0
?7oo00<007ooOol0>goo00=T7gooOol0?Woo000eOol00f@OOomoo`0lOol00`00Oomoo`0kOol00f@O
Oomoo`0nOol003Eoo`03I1moogoo03aoo`03001oogoo03]oo`03I1moogoo03ioo`00=Goo00=T7goo
Ool0?7oo00<007ooOol0>goo00=T7gooOol0?Woo000eOol00f@OOomoo`0lOol00`00Oomoo`0kOol0
0f@OOomoo`0nOol003Eoo`03I1moogoo03aoo`03001oogoo03]oo`03I1moogoo03ioo`00=Woo00=T
7gooOol0>goo00<007ooOol0>Woo00=T7gooOol0?goo000fOol00f@OOomoo`0kOol00`00Oomoo`0j
Ool00f@OOomoo`0oOol003Ioo`03I1moogoo03]oo`03001oogoo03Yoo`03I1moogoo03moo`00=Woo
00=T7gooOol0>goo00<007ooOol0>Woo00=T7gooOol0?goo000fOol00f@OOomoo`0kOol00`00Oomo
o`0jOol00f@OOomoo`0oOol003Moo`03I1moogoo03Yoo`03001oogoo03Uoo`03I1moogoo041oo`00
=goo00=T7gooOol0>Woo00<007ooOol0>Goo00=T7gooOol0@7oo000hOol00f@OOomoo`0iOol00`00
Oomoo`0hOol00f@OOomoo`11Ool003Qoo`03I1moogoo03Uoo`03001oogoo03Qoo`03I1moogoo045o
o`00>Goo00=T7gooOol07goo10001Goo0P001Goo10001Goo00<007ooOol0>7oo00=T7gooOol0@Goo
000iOol00f@OOomoo`0NOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool00`00Oomoo`0gOol00f@OOomoo`12Ool003Yoo`03I1moogoo01eoo`03001oogoo
009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo03Moo`03I1moogoo049oo`00>Woo00=T
7gooOol07Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00>7oo00=T7gooOol0
@Woo000kOol00f@OOomoo`0LOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0f
Ool00f@OOomoo`13Ool003]oo`03I1moogoo01aoo`03001oogoo009oo`03001oogoo00Uoo`03001o
ogoo00Ioo`03001oogoo03Ioo`03I1moogoo04=oo`00>goo00=T7gooOol077oo00<007ooOol00Woo
00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0=Goo00=T7gooOol0A7oo000lOol00f@OOomo
o`0LOol4000<Ool50004Ool00`00Oomoo`0eOol00f@OOomoo`14Ool003aoo`03I1moogoo03Eoo`03
001oogoo03Aoo`03I1moogoo04Eoo`00?Goo00=T7gooOol0=7oo00<007ooOol0=7oo00=T7gooOol0
AGoo000mOol00f@OOomoo`0dOol00`00Oomoo`0cOol00f@OOomoo`16Ool003ioo`03I1moogoo03=o
o`03001oogoo039oo`03I1moogoo04Moo`00?goo00=T7gooOol0<Woo00<007ooOol0<Woo00=T7goo
Ool0Agoo000oOol00f@OOomoo`0bOol00`00Oomoo`0aOol00f@OOomoo`18Ool0041oo`03I1moogoo
035oo`03001oogoo035oo`03I1moogoo04Qoo`00@Goo00=T7gooOol0<7oo00<007ooOol0<7oo00=T
7gooOol0BGoo0012Ool00f@OOomoo`0_Ool00`00Oomoo`0_Ool00f@OOomoo`1:Ool004=oo`03I1mo
ogoo02ioo`03001oogoo02ioo`03I1moogoo04]oo`00A7oo00=T7gooOol0;Goo00<007ooOol0;Goo
00=T7gooOol0C7oo0015Ool00f@OOomoo`0/Ool00`00Oomoo`0/Ool00f@OOomoo`1=Ool004Ioo`03
I1moogoo02]oo`03001oogoo02]oo`03I1moogoo04ioo`00Agoo00=T7gooOol0:Woo00<007ooOol0
:Woo00=T7gooOol0Cgoo0018Ool00f@OOomoo`0YOol00`00Oomoo`0YOol00f@OOomoo`1@Ool004Uo
o`03I1moogoo02Qoo`03001oogoo02Qoo`03I1moogoo055oo`00BWoo00=T7gooOol09goo00<007oo
Ool09goo00=T7gooOol0DWoo001;Ool00f@OOomoo`0VOol00`00Oomoo`0UOol2I1mEOol004aoo`03
I1moogoo02Eoo`03001oogoo02Aoo`03I1moogoo05Eoo`00CGoo00=T7gooOol06goo1@0017oo00<0
07ooOol08goo00=T7gooOol0EWoo001>Ool2I1lMOol00`00Oomoo`04Ool00`00Oomoo`0QOol2I1mI
Ool0051oo`9T7a]oo`03001oogoo00Aoo`03001oogoo01moo`9T7e]oo`00DWoo00=T7gooOol067oo
00<007ooOol017oo0P007goo00=T7gooOol0Fgoo001COol2I1lHOol00`00Oomoo`04Ool00`00Oomo
o`0LOol2I1mNOol005Eoo`9T7aIoo`03001oogoo00Aoo`03001oogoo01Yoo`9T7f1oo`00Egoo00=T
7gooOol04Goo0`001Woo00<007ooOol06Goo00=T7gooOol0H7oo001HOol2I1lCOol00`00Oomoo`04
Ool00`00Oomoo`0GOol2I1mSOol005Yoo`9T7aQoo`03001oogoo01Eoo`9T7fEoo`00G7oo0f@O5Goo
00<007ooOol04goo0V@OIgoo001OOol2I1lCOol00`00Oomoo`0@Ool3I1mYOol0065oo`AT7`moo`03
001oogoo00aoo`AT7faoo`00IGoo1V@O2Goo00<007ooOol01Woo1V@OL7oo001[OolBI1mfOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo
00<007ooOol0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00GGoo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00JWoo1@001Goo00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo
00<007ooOol0O7oo001[Ool00`00Oomoo`06Ool00`00Oomoo`1lOol006aoo`03001oogoo00Eoo`80
07eoo`00KGoo00<007ooOol0Pgoo001^Ool00`00Oomoo`22Ool006Yoo`05001oogooOol00024Ool0
06]oo`<008Eoo`00lgoo003cOol00?=oo`00lgoo002EOol3000;Ool40005Ool20005Ool4000lOol0
09Aoo`06001oogooOol007oo1P000Woo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007oo
Ool00Woo00<007ooOol0>Goo001cOol200000goo0000000LOol00`00Oomoo`0;Ool00`00Oomoo`02
Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`0iOol0079oo`03001oogoo008001eoo`03
001oogoo00=oo`H0009oo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo
03Uoo`00LWoo00D007ooOomoo`0001eoo`03001oogoo00]oo`03001oogoo009oo`03001oogoo00Uo
o`@003aoo`00LWoo00D007ooOomoo`0001aoo`D000Yoo`03001oogoo009oo`03001oogoo00Qoo`03
001oogoo009oo`03001oogoo03Uoo`00LWoo00D007ooOomoo`0001eoo`03001oogoo00]oo`03001o
ogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo03Uoo`00LGoo0P000Woo0P00;7oo
100037oo1000?7oo003cOol00?=oo`00lgoo003cOol00?=oo`00\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.75) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.5 0 1 r

.5 Mabswid

.22049 .49993 m

.22168 .47421 L

.22525 .44864 L

.23116 .42351 L

.23937 .39903 L

.24979 .37541 L

.26236 .35286 L

.27695 .33156 L

.29344 .3117 L

.3117 .29344 L

.33156 .27695 L

.35286 .26236 L

.37541 .24979 L

.39903 .23937 L

.42351 .23116 L

.44864 .22525 L

.47421 .22168 L

.5 .22049 L

.52579 .22168 L

.55136 .22525 L

.57649 .23116 L

.60097 .23937 L

.62459 .24979 L

.64714 .26236 L

.66844 .27695 L

.6883 .29344 L

.70656 .3117 L

.72305 .33156 L

.73764 .35286 L

.75021 .37541 L

.76063 .39903 L

.76884 .42351 L

.77475 .44864 L

.77832 .47421 L

.77951 .49993 L

s

.22049 .50007 m

.22168 .52579 L

.22525 .55136 L

.23116 .57649 L

.23937 .60097 L

.24979 .62459 L

.26236 .64714 L

.27695 .66844 L

.29344 .6883 L

.3117 .70656 L

.33156 .72305 L

.35286 .73764 L

.37541 .75021 L

.39903 .76063 L

.42351 .76884 L

.44864 .77475 L

.47421 .77832 L

.5 .77951 L

.52579 .77832 L

.55136 .77475 L

.57649 .76884 L

.60097 .76063 L

.62459 .75021 L

.64714 .73764 L

.66844 .72305 L

.6883 .70656 L

.70656 .6883 L

.72305 .66844 L

.73764 .64714 L

.75021 .62459 L

.76063 .60097 L

.76884 .57649 L

.77475 .55136 L

.77832 .52579 L

.77951 .50007 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00K7oo43`OMgoo001WOol5?1l8Ool00`00Oomoo`05Ool6
?1maOol0069oo`Dl7`eoo`03001oogoo00]oo`@l7feoo`00H7oo0S`O2Goo1@0017oo00<007ooOol0
3goo0S`OJgoo001MOol3?1l=Ool00`00Oomoo`04Ool00`00Oomoo`0AOol3?1mXOol005]oo`8l7a1o
o`03001oogoo00Aoo`03001oogoo01Aoo`<l7fEoo`00FGoo0S`O1goo1P001Goo00<007ooOol017oo
0P0067oo0S`OHgoo001GOol2?1lDOol00`00Oomoo`04Ool00`00Oomoo`0IOol00c`OOomoo`1POol0
05Eoo`8l7aIoo`03001oogoo00Aoo`03001oogoo01Yoo`8l7f1oo`00E7oo00<l7gooOol057oo0`00
1Woo00<007ooOol077oo00<l7gooOol0GGoo001BOol2?1lIOol00`00Oomoo`04Ool00`00Oomoo`0M
Ool2?1mMOol0051oo`8l7b9oo`03001oogoo01moo`8l7e]oo`00Cgoo00<l7gooOol08Woo00<007oo
Ool08Goo00<l7gooOol0F7oo001>Ool00c`OOomoo`0SOol00`00Oomoo`0ROol00c`OOomoo`1GOol0
04eoo`03?1moogoo02Aoo`03001oogoo02=oo`03?1moogoo05Ioo`00C7oo00<l7gooOol09Goo00<0
07ooOol097oo00<l7gooOol0EGoo001;Ool00c`OOomoo`0VOol00`00Oomoo`0UOol00c`OOomoo`1D
Ool004Yoo`03?1moogoo02Moo`03001oogoo02Ioo`03?1moogoo05=oo`00BGoo00<l7gooOol0:7oo
00<007ooOol09goo00<l7gooOol0DWoo0018Ool00c`OOomoo`0YOol00`00Oomoo`0XOol00c`OOomo
o`1AOol004Moo`03?1moogoo02Yoo`03001oogoo02Uoo`03?1moogoo051oo`00AWoo00<l7gooOol0
:goo00<007ooOol0:Woo00<l7gooOol0Cgoo0015Ool00c`OOomoo`0/Ool00`00Oomoo`0[Ool00c`O
Oomoo`1>Ool004Eoo`03?1moogoo02aoo`03001oogoo02aoo`03?1moogoo04eoo`00A7oo00<l7goo
Ool0;Goo00<007ooOol0;Goo00<l7gooOol0C7oo0013Ool00c`OOomoo`0^Ool00`00Oomoo`0^Ool0
0c`OOomoo`1;Ool0049oo`03?1moogoo02moo`03001oogoo02moo`03?1moogoo04Yoo`00@Goo00<l
7gooOol0<7oo00<007ooOol0;goo00<l7gooOol0BWoo0010Ool00c`OOomoo`0aOol00`00Oomoo`0`
Ool00c`OOomoo`19Ool0041oo`03?1moogoo035oo`03001oogoo035oo`03?1moogoo04Qoo`00?goo
00<l7gooOol06Goo10001Goo0P001Goo10001Goo00<007ooOol0<Goo00<l7gooOol0B7oo000oOol0
0c`OOomoo`0HOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`0bOol00c`OOomoo`17Ool003ioo`03?1moogoo01Uoo`03001oogoo009oo`03
001oogoo00eoo`03001oogoo009oo`03001oogoo039oo`03?1moogoo04Moo`00?Woo00<l7gooOol0
4Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00=7oo00<l7gooOol0
AWoo000mOol00c`OOomoo`0JOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0c
Ool00c`OOomoo`16Ool003eoo`03?1moogoo01Yoo`03001oogoo009oo`03001oogoo00Uoo`03001o
ogoo00Ioo`03001oogoo03Aoo`03?1moogoo04Eoo`00?7oo00<l7gooOol06goo00<007ooOol00Woo
00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0=7oo00<l7gooOol0AGoo000lOol00c`OOomo
o`0LOol4000<Ool50004Ool00`00Oomoo`0eOol00c`OOomoo`14Ool003]oo`03?1moogoo03Ioo`03
001oogoo03Eoo`03?1moogoo04Aoo`00>goo00<l7gooOol0=Woo00<007ooOol0=Goo00<l7gooOol0
A7oo000kOol00c`OOomoo`0fOol00`00Oomoo`0fOol00c`OOomoo`13Ool003Yoo`03?1moogoo03Mo
o`03001oogoo03Ioo`03?1moogoo04=oo`00>Woo00<l7gooOol0=goo00<007ooOol0=Woo00<l7goo
Ool0@goo000jOol00c`OOomoo`0gOol00`00Oomoo`0gOol00c`OOomoo`12Ool003Yoo`03?1moogoo
03Moo`03001oogoo03Moo`03?1moogoo049oo`00>Woo00<l7gooOol0=goo00<007ooOol0=goo00<l
7gooOol0@Woo0009Ool5000?Ool50004Ool20005Ool40008Ool00c`OOomoo`04Ool5000>Ool40005
Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool500000goo?1moo`0;Ool5
0004Ool20005Ool4000>Ool5000AOol000Uoo`05001oogooOol0000AOol00`00Oomoo`04Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00c`OOomoo`06Ool00`00Oomoo`0=Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`02
Ool00c`OOomoo`0;Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool01@00
Oomoogoo00004Goo000:Ool00`00Oomoo`0BOol00`00Oomoo`0?Ool00`00Oomoo`04Ool00c`OOomo
o`07Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool00c`OOomo
o`0;Ool00`00Oomoo`0?Ool00`00Oomoo`0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03
001oogoo00Ioo`H000Eoo`03001oogoo00moo`03001oogoo00=oo`03000l7`0000<000Eoo`03001o
ogoo00Eoo`H0009oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00Yoo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo00eoo`03001oogoo00ioo`03001oogoo009oo`03?1moogoo00]o
o`03001oogoo00moo`03001oogoo00eoo`03001oogoo015oo`0037oo00<007ooOol047oo00<007oo
Ool02goo10001goo00<l7gooOol01goo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo
10003Goo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo10004Goo00<007ooOol00Woo
00<l7gooOol02goo00<007ooOol02goo10004Goo00<007ooOol047oo000=Ool00`00Oomoo`0?Ool0
0`00Oomoo`0;Ool00`00Oomoo`08Ool00c`OOomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool0
0`00Oomoo`0BOol00`00Oomoo`02Ool00c`OOomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0COol0
0`00Oomoo`0?Ool000Uoo`05001oogooOol0000?Ool3000=Ool00`00Oomoo`08Ool00c`OOomoo`05
Ool3000?Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0@Ool30005Ool00c`OOomoo`08Ool3000=Ool00`00
Oomoo`0?Ool01@00Oomoogoo00004Goo000:Ool3000BOol00`00Oomoo`0;Ool50006Ool00c`OOomo
o`07Ool00`00Oomoo`0>Ool4000<Ool5000<Ool00`00Oomoo`0>Ool4000<Ool5000@Ool00`00Oomo
o`03Ool00c`OOomoo`0:Ool00`00Oomoo`0;Ool5000>Ool3000BOol003Qoo`03?1moogoo03Uoo`03
001oogoo03Uoo`03?1moogoo041oo`00>7oo00<l7gooOol0>Goo00<007ooOol0>Goo00<l7gooOol0
@7oo000hOol00c`OOomoo`0iOol00`00Oomoo`0iOol00c`OOomoo`10Ool003Qoo`03?1moogoo03Uo
o`03001oogoo03Uoo`03?1moogoo041oo`00=goo00<l7gooOol0>Woo00<007ooOol0>Goo00<l7goo
Ool0=Goo0P000Woo0P001Goo000gOol00c`OOomoo`0jOol00`00Oomoo`0iOol00c`OOomoo`0fOol0
1000Oomoo`001Woo0008Ool_00000c`O0000001f00000c`O0000000^0009Ool20007Ool000Qoo`03
001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03
001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`06001oogooOoll7`001Goo00<007ooOol0
0Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<003`OOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
1goo0P001goo0008Ool00`00Oomoo`0HOol00`00Oomoo`0AOol00c`OOomoo`04Ool00`00Oomoo`0H
Ool00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`03Ool00c`OOomoo`0B
Ool00`00Oomoo`0HOol00`00Oomoo`06Ool01000Oomoo`001Woo000hOol00c`OOomoo`0iOol00`00
Oomoo`0iOol00c`OOomoo`0eOol20002Ool20005Ool003Qoo`03?1moogoo03Uoo`03001oogoo03Uo
o`03?1moogoo041oo`00>7oo00<l7gooOol0>Goo00<007ooOol0>Goo00<l7gooOol0@7oo000hOol0
0c`OOomoo`0iOol00`00Oomoo`0iOol00c`OOomoo`10Ool003Qoo`03?1moogoo03Uoo`03001oogoo
03Uoo`03?1moogoo041oo`00>7oo00<l7gooOol0>Goo00<007ooOol0>Goo00<l7gooOol0@7oo000h
Ool00c`OOomoo`0iOol00`00Oomoo`0hOol00c`OOomoo`11Ool003Qoo`03?1moogoo03Uoo`03001o
ogoo03Qoo`03?1moogoo045oo`00>7oo00<l7gooOol0>Goo00<007ooOol0>7oo00<l7gooOol0@Goo
000hOol00c`OOomoo`0iOol00`00Oomoo`0hOol00c`OOomoo`11Ool003Uoo`03?1moogoo03Qoo`03
001oogoo03Qoo`03?1moogoo045oo`00>Goo00<l7gooOol0>7oo00<007ooOol0=goo00<l7gooOol0
@Woo000iOol00c`OOomoo`0hOol00`00Oomoo`0gOol00c`OOomoo`12Ool003Yoo`03?1moogoo03Mo
o`03001oogoo03Moo`03?1moogoo049oo`00>Woo00<l7gooOol0=goo00<007ooOol0=goo00<l7goo
Ool0@Woo000jOol00c`OOomoo`0gOol00`00Oomoo`0gOol00c`OOomoo`12Ool003Yoo`03?1moogoo
03Moo`03001oogoo03Ioo`03?1moogoo04=oo`00>goo00<l7gooOol0=Woo00<007ooOol0=Woo00<l
7gooOol0@goo000kOol00c`OOomoo`0fOol00`00Oomoo`0eOol00c`OOomoo`14Ool003]oo`03?1mo
ogoo03Ioo`03001oogoo03Eoo`03?1moogoo04Aoo`00?7oo00<l7gooOol0=Goo00<007ooOol0=Goo
00<l7gooOol0A7oo000lOol00c`OOomoo`0LOol40005Ool20005Ool40005Ool00`00Oomoo`0dOol0
0c`OOomoo`15Ool003eoo`03?1moogoo01Yoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03
001oogoo009oo`03001oogoo009oo`03001oogoo03Aoo`03?1moogoo04Eoo`00?Goo00<l7gooOol0
6Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0<goo00<l7gooOol0
AWoo000nOol00c`OOomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool2000d
Ool00c`OOomoo`16Ool003ioo`03?1moogoo01Uoo`03001oogoo009oo`03001oogoo00Uoo`@000Eo
o`03001oogoo039oo`03?1moogoo04Moo`00?goo00<l7gooOol067oo00<007ooOol00Woo00<007oo
Ool02Goo00<007ooOol01Woo00<007ooOol0<Woo00<l7gooOol0Agoo000oOol00c`OOomoo`0HOol0
0`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`0aOol00c`OOomoo`18Ool0
041oo`03?1moogoo01Qoo`@000aoo`D000Aoo`03001oogoo035oo`03?1moogoo04Qoo`00@7oo00<l
7gooOol0<Goo00<007ooOol0<7oo00<l7gooOol0BGoo0011Ool00c`OOomoo`0`Ool00`00Oomoo`0_
Ool00c`OOomoo`1:Ool0049oo`03?1moogoo02moo`03001oogoo02moo`03?1moogoo04Yoo`00@Woo
00<l7gooOol0;goo00<007ooOol0;Woo00<l7gooOol0Bgoo0013Ool00c`OOomoo`0^Ool00`00Oomo
o`0^Ool00c`OOomoo`1;Ool004Aoo`03?1moogoo02eoo`03001oogoo02eoo`03?1moogoo04aoo`00
AGoo00<l7gooOol0;7oo00<007ooOol0;7oo00<l7gooOol0CGoo0016Ool00c`OOomoo`0[Ool00`00
Oomoo`0[Ool00c`OOomoo`1>Ool004Ioo`03?1moogoo02]oo`03001oogoo02Yoo`03?1moogoo04mo
o`00Agoo00<l7gooOol0:Woo00<007ooOol0:Goo00<l7gooOol0D7oo0018Ool00c`OOomoo`0YOol0
0`00Oomoo`0XOol00c`OOomoo`1AOol004Uoo`03?1moogoo02Qoo`03001oogoo02Moo`03?1moogoo
059oo`00BWoo00<l7gooOol09goo00<007ooOol09Woo00<l7gooOol0Dgoo001;Ool00c`OOomoo`0V
Ool00`00Oomoo`0UOol00c`OOomoo`1DOol004aoo`03?1moogoo02Eoo`03001oogoo02Aoo`03?1mo
ogoo05Eoo`00CGoo0S`O9Goo00<007ooOol08Woo0S`OF7oo001?Ool00c`OOomoo`0ROol00`00Oomo
o`0QOol00c`OOomoo`1HOol0051oo`8l7b9oo`03001oogoo01moo`8l7e]oo`00DWoo0S`O87oo00<0
07ooOol07Goo0S`OGGoo001DOol00c`OOomoo`0DOol50004Ool00`00Oomoo`0LOol00c`OOomoo`1M
Ool005Eoo`8l7aIoo`03001oogoo00Aoo`03001oogoo01]oo`03?1moogoo05ioo`00Egoo0S`O57oo
00<007ooOol017oo00<007ooOol06Goo0S`OHGoo001IOol2?1lBOol00`00Oomoo`04Ool2000HOol2
?1mSOol005]oo`8l7a1oo`03001oogoo00Aoo`03001oogoo01Aoo`<l7fEoo`00GGoo0c`O3Goo00<0
07ooOol017oo00<007ooOol04Goo0c`OJ7oo001POol2?1l9Ool30006Ool00`00Oomoo`0?Ool2?1m[
Ool0069oo`@l7`Moo`03001oogoo00Aoo`03001oogoo00]oo`@l7feoo`00IWoo1S`O27oo00<007oo
Ool01Woo1C`OLGoo001/OolA?1mfOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001KOol50004Ool20005Ool40005Ool00`00Oomoo`1lOol005eoo`03001oogoo
00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo07aoo`00GGoo00<007ooOol0
3goo00<007ooOol00Woo00<007ooOol0O7oo001MOol00`00Oomoo`0?Ool00`00Oomoo`02Ool2001m
Ool005eoo`03001oogoo00]oo`@000Eoo`03001oogoo07aoo`00GGoo00<007ooOol02goo00<007oo
Ool01Woo00<007ooOol0O7oo001KOol3000=Ool00`00Oomoo`06Ool00`00Oomoo`1lOol005eoo`03
001oogoo00]oo`D000Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001ZOol50005
Ool00`00Oomoo`1lOol006Yoo`05001oogooOol00005Ool00`00Oomoo`1lOol006]oo`03001oogoo
00Ioo`03001oogoo07aoo`00K7oo00<007ooOol01Goo0P00OGoo001]Ool00`00Oomoo`23Ool006io
o`03001oogoo089oo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo0`00QGoo003cOol00?=oo`00lgoo
003cOol0095oo`<000]oo`@000Eoo`8000Moo`03001oogoo00=oo`@003Qoo`00T7oo00H007ooOomo
o`00Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20007Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`0eOol007=oo`800003Ool0000001Qoo`03001oogoo00]oo`03001oogoo009o
o`03001oogoo00]oo`03001oogoo00Moo`03001oogoo03Eoo`00LWoo00<007ooOol00P006Goo00<0
07ooOol00goo1P000Woo00<007ooOol00Woo00<007ooOol037oo00<007ooOol01Woo00<007ooOol0
=Goo001bOol01@00Oomoogoo00006Goo00<007ooOol02goo00<007ooOol00Woo00<007ooOol037oo
00<007ooOol00Woo1000>7oo001bOol01@00Oomoogoo000067oo1@002Woo00<007ooOol00Woo00<0
07ooOol03Goo00D007ooOomoo`0003]oo`00LWoo00D007ooOomoo`0001Uoo`03001oogoo00]oo`03
001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`05001oogooOol0000kOol0075oo`80009o
o`8002Qoo`@000]oo`H000=oo`D003Moo`00lgoo003cOol00?=oo`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.7) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.2 0 1 r

.5 Mabswid

.2378 .49993 m

.23892 .47581 L

.24226 .45182 L

.24781 .42824 L

.2555 .40528 L

.26529 .38313 L

.27707 .36197 L

.29076 .34199 L

.30623 .32336 L

.32336 .30623 L

.34199 .29076 L

.36197 .27707 L

.38313 .26529 L

.40528 .2555 L

.42824 .24781 L

.45182 .24226 L

.47581 .23892 L

.5 .2378 L

.52419 .23892 L

.54818 .24226 L

.57176 .24781 L

.59472 .2555 L

.61687 .26529 L

.63803 .27707 L

.65801 .29076 L

.67664 .30623 L

.69377 .32336 L

.70924 .34199 L

.72293 .36197 L

.73471 .38313 L

.7445 .40528 L

.75219 .42824 L

.75774 .45182 L

.76108 .47581 L

.7622 .49993 L

s

.2378 .50007 m

.23892 .52419 L

.24226 .54818 L

.24781 .57176 L

.2555 .59472 L

.26529 .61687 L

.27707 .63803 L

.29076 .65801 L

.30623 .67664 L

.32336 .69377 L

.34199 .70924 L

.36197 .72293 L

.38313 .73471 L

.40528 .7445 L

.42824 .75219 L

.45182 .75774 L

.47581 .76108 L

.5 .7622 L

.52419 .76108 L

.54818 .75774 L

.57176 .75219 L

.59472 .7445 L

.61687 .73471 L

.63803 .72293 L

.65801 .70924 L

.67664 .69377 L

.69377 .67664 L

.70924 .65801 L

.72293 .63803 L

.73471 .61687 L

.7445 .59472 L

.75219 .57176 L

.75774 .54818 L

.76108 .52419 L

.7622 .50007 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001/Ool@51mgOol006Moo`DD7`03
Ool007oo00Eoo`03001oogoo00Eoo`DD7g9oo`00HWoo1A@O00<007ooOol00goo00<007ooOol017oo
0P002goo1A@OKGoo001OOol351l;Ool00`00Oomoo`04Ool00`00Oomoo`0?Ool351mZOol005eoo`8D
7`ioo`03001oogoo00Aoo`03001oogoo019oo`8D7fQoo`00Fgoo0Q@O3Woo0`001Woo00<007ooOol0
57oo0Q@OIWoo001JOol00a@OOomoo`0@Ool00`00Oomoo`04Ool00`00Oomoo`0FOol00a@OOomoo`1S
Ool005Qoo`8D7aYoo`03001oogoo01Moo`8D7f=oo`00EWoo0Q@O77oo00<007ooOol06Goo0Q@OHGoo
001EOol00a@OOomoo`0LOol00`00Oomoo`0KOol251mOOol005=oo`8D7amoo`03001oogoo01eoo`8D
7eeoo`00DWoo00<D7gooOol07goo00<007ooOol07goo00<D7gooOol0FWoo001AOol00a@OOomoo`0P
Ool00`00Oomoo`0POol00a@OOomoo`1IOol004moo`8D7b=oo`03001oogoo025oo`8D7eUoo`00CWoo
00<D7gooOol08goo00<007ooOol08goo00<D7gooOol0EWoo001=Ool00a@OOomoo`0TOol00`00Oomo
o`0TOol00a@OOomoo`1EOol004aoo`0351moogoo02Eoo`03001oogoo02Eoo`0351moogoo05Aoo`00
Bgoo00<D7gooOol09Woo00<007ooOol09Goo00<D7gooOol0E7oo001:Ool00a@OOomoo`0WOol00`00
Oomoo`0VOol00a@OOomoo`1COol004Uoo`0351moogoo02Qoo`03001oogoo02Moo`0351moogoo059o
o`00B7oo00<D7gooOol0:Goo00<007ooOol0:7oo00<D7gooOol0DGoo0018Ool00a@OOomoo`0YOol0
0`00Oomoo`0YOol00a@OOomoo`1@Ool004Moo`0351moogoo02Yoo`03001oogoo02Yoo`0351moogoo
04moo`00AWoo00<D7gooOol0:goo00<007ooOol0:goo00<D7gooOol0CWoo0015Ool00a@OOomoo`0/
Ool00`00Oomoo`0/Ool00a@OOomoo`1=Ool004Eoo`0351moogoo02aoo`03001oogoo02aoo`0351mo
ogoo04eoo`00A7oo00<D7gooOol057oo10001Goo0P001Goo10001Goo00<007ooOol0;Goo00<D7goo
Ool0C7oo0013Ool00a@OOomoo`0DOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`0]Ool00a@OOomoo`1<Ool004=oo`0351moogoo01Aoo`03
001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo02ioo`0351moogoo04]oo`00
@Woo00<D7gooOol03Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00
;goo00<D7gooOol0Bgoo0012Ool00a@OOomoo`0EOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005
Ool00`00Oomoo`0_Ool00a@OOomoo`1:Ool0045oo`0351moogoo01Ioo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo00Ioo`03001oogoo02moo`0351moogoo04Yoo`00@Goo00<D7gooOol05Woo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0;goo00<D7gooOol0BWoo
0010Ool00a@OOomoo`0HOol4000<Ool50004Ool00`00Oomoo`0`Ool00a@OOomoo`19Ool0041oo`03
51moogoo035oo`03001oogoo031oo`0351moogoo04Uoo`00?goo00<D7gooOol0<Woo00<007ooOol0
<Goo00<D7gooOol0B7oo000oOol00a@OOomoo`0bOol00`00Oomoo`0aOol00a@OOomoo`18Ool003mo
o`0351moogoo039oo`03001oogoo035oo`0351moogoo04Qoo`00?Woo00<D7gooOol0<goo00<007oo
Ool0<Woo00<D7gooOol0Agoo000nOol00a@OOomoo`0cOol00`00Oomoo`0bOol00a@OOomoo`17Ool0
03eoo`0351moogoo03Aoo`03001oogoo03=oo`0351moogoo04Ioo`00?Goo00<D7gooOol0=7oo00<0
07ooOol0<goo00<D7gooOol0AWoo0009Ool5000?Ool50004Ool20005Ool4000<Ool00a@OOomoo`05
000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool200000a@O
0000000>Ool50004Ool20005Ool4000>Ool5000AOol000Uoo`05001oogooOol0000AOol00`00Oomo
o`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00a@OOomoo`02Ool00`00Oomoo`0=Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool0
0a@OOomoo`0@Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool01@00Oomo
ogoo00004Goo000:Ool00`00Oomoo`0BOol00`00Oomoo`0?Ool00`00Oomoo`08Ool00a@OOomoo`03
Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`0051moo`0@Ool00`00Oomoo`0?
Ool00`00Oomoo`0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Ioo`H000Eo
o`03001oogoo00moo`03001oogoo00=oo`D0000351moogoo00=oo`03001oogoo00Eoo`H0009oo`03
001oogoo009oo`03001oogoo00eoo`03001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03
001oogoo00eoo`03001oogoo00ioo`03000D7goo011oo`03001oogoo00moo`03001oogoo00eoo`03
001oogoo015oo`0037oo00<007ooOol047oo00<007ooOol02goo10002goo00<D7gooOol00goo00<0
07ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo10003Goo00<007ooOol03Goo00<007ooOol0
0Woo00<007ooOol02Goo10004Goo00<001@OOol047oo00<007ooOol02goo10004Goo00<007ooOol0
47oo000=Ool00`00Oomoo`0?Ool00`00Oomoo`0;Ool00`00Oomoo`0<Ool00a@OOomoo`03Ool00`00
Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0BOol00`0051moo`0@Ool00`00Oomoo`0;Ool00`00
Oomoo`0COol00`00Oomoo`0?Ool000Uoo`05001oogooOol0000?Ool3000=Ool00`00Oomoo`0<Ool0
11@OOomoogoo0`003goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol0
3Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol047oo0`0000<D7gooOol03Goo0`003Goo
00<007ooOol03goo00D007ooOomoo`00015oo`002Woo0`004Woo00<007ooOol02goo1@002Goo00<D
7gooOol017oo00<007ooOol03Woo100037oo1@0037oo00<007ooOol03Woo100037oo1@0047oo00<0
07oo51l047oo00<007ooOol02goo1@003Woo0`004Woo000kOol00a@OOomoo`0fOol00`00Oomoo`0e
Ool00a@OOomoo`14Ool003]oo`0351moogoo03Ioo`03001oogoo03Eoo`0351moogoo04Aoo`00>goo
00<D7gooOol0=Woo00<007ooOol0=Goo00<D7gooOol0A7oo000kOol00a@OOomoo`0fOol00`00Oomo
o`0eOol00a@OOomoo`14Ool003]oo`0351moogoo03Ioo`03001oogoo03Eoo`0351moogoo03Uoo`80
009oo`8000Eoo`00>goo00<D7gooOol0=Woo00<007ooOol0=Goo00<D7gooOol0>Woo00@007ooOol0
00Ioo`0027oo<`0000<D7`000000KP0000<D7`000000<P002Goo0P001goo0008Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomooa@O0Woo00<007ooOol0
0Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007oo51l0
0Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
1goo0P001goo0008Ool00`00Oomoo`0HOol00`00Oomoo`0EOol011@OOomoo`006Woo00<007ooOol0
67oo00<007ooOol067oo00<007ooOol067oo00<007oo51l067oo00<007ooOol067oo00<007ooOol0
1Woo00@007ooOol000Ioo`00>goo00<D7gooOol0=Woo00<007ooOol0=Goo00<D7gooOol0>Goo0P00
0Woo0P001Goo000kOol00a@OOomoo`0fOol00`00Oomoo`0eOol00a@OOomoo`14Ool003]oo`0351mo
ogoo03Ioo`03001oogoo03Eoo`0351moogoo04Aoo`00>goo00<D7gooOol0=Woo00<007ooOol0=Goo
00<D7gooOol0A7oo000kOol00a@OOomoo`0fOol00`00Oomoo`0eOol00a@OOomoo`14Ool003aoo`03
51moogoo03Eoo`03001oogoo03Aoo`0351moogoo04Eoo`00?7oo00<D7gooOol0=Goo00<007ooOol0
=7oo00<D7gooOol0AGoo000lOol00a@OOomoo`0eOol00`00Oomoo`0dOol00a@OOomoo`15Ool003ao
o`0351moogoo03Eoo`03001oogoo03Aoo`0351moogoo04Eoo`00?7oo00<D7gooOol0=Goo00<007oo
Ool0=7oo00<D7gooOol0AGoo000lOol00a@OOomoo`0eOol00`00Oomoo`0dOol00a@OOomoo`15Ool0
03eoo`0351moogoo03Aoo`03001oogoo03=oo`0351moogoo04Ioo`00?Goo00<D7gooOol0=7oo00<0
07ooOol0<goo00<D7gooOol0AWoo000mOol00a@OOomoo`0dOol00`00Oomoo`0cOol00a@OOomoo`16
Ool003eoo`0351moogoo03Aoo`03001oogoo03=oo`0351moogoo04Ioo`00?Woo00<D7gooOol0<goo
00<007ooOol0<Woo00<D7gooOol0Agoo000nOol00a@OOomoo`0cOol00`00Oomoo`0bOol00a@OOomo
o`17Ool003moo`0351moogoo039oo`03001oogoo035oo`0351moogoo04Qoo`00?goo00<D7gooOol0
<Woo00<007ooOol0<Goo00<D7gooOol0B7oo0010Ool00a@OOomoo`0aOol00`00Oomoo`0`Ool00a@O
Oomoo`19Ool0041oo`0351moogoo035oo`03001oogoo031oo`0351moogoo04Uoo`00@Goo00<D7goo
Ool05goo10001Goo0P001Goo10001Goo00<007ooOol0;goo00<D7gooOol0BWoo0011Ool00a@OOomo
o`0FOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`0_Ool00a@OOomoo`1:Ool0049oo`0351moogoo01Eoo`03001oogoo009oo`03001oogoo
00eoo`03001oogoo009oo`03001oogoo02moo`0351moogoo04Yoo`00@Woo00<D7gooOol05Goo00<0
07ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00;goo00<D7gooOol0Bgoo0013Ool00a@O
Oomoo`0DOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0^Ool00a@OOomoo`1;
Ool004=oo`0351moogoo01Aoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001o
ogoo02eoo`0351moogoo04aoo`00A7oo00<D7gooOol04goo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol01Woo00<007ooOol0;Goo00<D7gooOol0C7oo0015Ool00a@OOomoo`0COol4000<Ool5
0004Ool00`00Oomoo`0/Ool00a@OOomoo`1=Ool004Ioo`0351moogoo02]oo`03001oogoo02]oo`03
51moogoo04ioo`00AWoo00<D7gooOol0:goo00<007ooOol0:goo00<D7gooOol0CWoo0017Ool00a@O
Oomoo`0ZOol00`00Oomoo`0ZOol00a@OOomoo`1?Ool004Qoo`0351moogoo02Uoo`03001oogoo02Uo
o`0351moogoo051oo`00BGoo00<D7gooOol0:7oo00<007ooOol0:7oo00<D7gooOol0DGoo0019Ool0
0a@OOomoo`0XOol00`00Oomoo`0WOol00a@OOomoo`1BOol004Yoo`0351moogoo02Moo`03001oogoo
02Ioo`0351moogoo05=oo`00Bgoo00<D7gooOol09Woo00<007ooOol09Goo00<D7gooOol0E7oo001<
Ool00a@OOomoo`0UOol00`00Oomoo`0TOol00a@OOomoo`1EOol004eoo`0351moogoo02Aoo`03001o
ogoo02Aoo`0351moogoo05Eoo`00CWoo00<D7gooOol08goo00<007ooOol08goo00<D7gooOol0EWoo
001?Ool00a@OOomoo`0ROol00`00Oomoo`0ROol00a@OOomoo`1GOol0051oo`8D7b9oo`03001oogoo
021oo`8D7eYoo`00DWoo00<D7gooOol07goo00<007ooOol07goo00<D7gooOol0FWoo001COol00a@O
Oomoo`0NOol00`00Oomoo`0MOol251mMOol005Aoo`8D7aioo`03001oogoo01]oo`8D7emoo`00EWoo
00<D7gooOol06goo00<007ooOol06Woo00<D7gooOol0Ggoo001GOol00a@OOomoo`0JOol00`00Oomo
o`0IOol00a@OOomoo`1POol005Qoo`8D7aYoo`03001oogoo01Moo`8D7f=oo`00FWoo0Q@O3goo1@00
17oo00<007ooOol05Goo0Q@OIGoo001LOol251l?Ool00`00Oomoo`04Ool00`00Oomoo`0COol251mW
Ool005ioo`<D7`aoo`03001oogoo00Aoo`03001oogoo011oo`<D7fUoo`00HGoo0Q@O2Woo00<007oo
Ool017oo0P003goo0Q@OK7oo001SOol451l6Ool00`00Oomoo`04Ool00`00Oomoo`0:Ool451m^Ool0
06Moo`XD7`=oo`03001oogoo00XD7g9oo`00Jgoo0`000goo1Q@OO7oo001]Ool00`00Oomoo`04Ool0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<0
07ooOol0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00GGoo00<007oo
Ool03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1lOol0
05eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007ooOol0
1Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00JWoo1@001Goo00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<0
07ooOol0O7oo001[Ool00`00Oomoo`06Ool00`00Oomoo`1lOol006aoo`03001oogoo00Eoo`8007eo
o`00KGoo00<007ooOol0Pgoo001^Ool00`00Oomoo`22Ool006Yoo`05001oogooOol00024Ool006]o
o`<008Eoo`00lgoo003cOol00?=oo`00lgoo002EOol3000;Ool40005Ool20007Ool00`00Oomoo`0k
Ool009Aoo`06001oogooOol007oo1P000Woo00<007ooOol00Woo00<007ooOol00Woo0P001goo00<0
07ooOol0>goo001cOol200000goo0000000LOol00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomo
o`0;Ool00`00Oomoo`0kOol0079oo`03001oogoo008001eoo`03001oogoo00=oo`H0009oo`03001o
ogoo009oo`03001oogoo00aoo`03001oogoo03Yoo`00LWoo00D007ooOomoo`0001eoo`03001oogoo
00]oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo03Yoo`00LWoo00D007ooOomoo`0001ao
o`D000Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo03Uoo`00LWoo00D007ooOomoo`00
01eoo`03001oogoo00]oo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo
03Uoo`00LGoo0P000Woo0P00;7oo10002goo1P00>goo003cOol00?=oo`00lgoo003cOol00?=oo`00
\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.65) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 .1 1 r

.5 Mabswid

.25633 .49993 m

.25737 .47752 L

.26048 .45523 L

.26563 .43332 L

.27278 .41198 L

.28188 .39139 L

.29283 .37172 L

.30555 .35316 L

.31993 .33584 L

.33584 .31993 L

.35316 .30555 L

.37172 .29283 L

.39139 .28188 L

.41198 .27278 L

.43332 .26563 L

.45523 .26048 L

.47752 .25737 L

.5 .25633 L

.52248 .25737 L

.54477 .26048 L

.56668 .26563 L

.58802 .27278 L

.60861 .28188 L

.62828 .29283 L

.64684 .30555 L

.66416 .31993 L

.68007 .33584 L

.69445 .35316 L

.70717 .37172 L

.71812 .39139 L

.72722 .41198 L

.73437 .43332 L

.73952 .45523 L

.74263 .47752 L

.74367 .49993 L

s

.25633 .50007 m

.25737 .52248 L

.26048 .54477 L

.26563 .56668 L

.27278 .58802 L

.28188 .60861 L

.29283 .62828 L

.30555 .64684 L

.31993 .66416 L

.33584 .68007 L

.35316 .69445 L

.37172 .70717 L

.39139 .71812 L

.41198 .72722 L

.43332 .73437 L

.45523 .73952 L

.47752 .74263 L

.5 .74367 L

.52248 .74263 L

.54477 .73952 L

.56668 .73437 L

.58802 .72722 L

.60861 .71812 L

.62828 .70717 L

.64684 .69445 L

.66416 .68007 L

.68007 .66416 L

.69445 .64684 L

.70717 .62828 L

.71812 .60861 L

.72722 .58802 L

.73437 .56668 L

.73952 .54477 L

.74263 .52248 L

.74367 .50007 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00
Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00HWoo1P001Goo00<007ooOol017oo
0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`h0GgQoo`00J7oo1@1O00<007oo
Ool017oo00<007ooOol017oo1@1OLgoo001TOol405l5Ool00`00Oomoo`04Ool00`00Oomoo`09Ool5
05m^Ool0061oo`@0Ga1oo`03001oogoo00ioo`<0Gf]oo`00GWoo0P1O57oo00<007ooOol04Goo0P1O
JGoo001LOol205lFOol00`00Oomoo`0COol205mWOol005]oo`0305moogoo01Ioo`03001oogoo01Eo
o`0305moogoo06Aoo`00FGoo0P1O6Goo00<007ooOol05Woo0P1OI7oo001HOol00`1OOomoo`0IOol0
0`00Oomoo`0HOol00`1OOomoo`1QOol005Ioo`80Gaaoo`03001oogoo01Uoo`80Gf5oo`00E7oo0P1O
7Woo00<007ooOol06goo0P1OGgoo001COol00`1OOomoo`0NOol00`00Oomoo`0MOol00`1OOomoo`1L
Ool0055oo`80Gb5oo`03001oogoo01ioo`80Geaoo`00D7oo00<0GgooOol08Goo00<007ooOol087oo
00<0GgooOol0FGoo001?Ool00`1OOomoo`0ROol00`00Oomoo`0QOol00`1OOomoo`1HOol004ioo`03
05moogoo02=oo`03001oogoo029oo`0305moogoo05Moo`00CWoo00<0GgooOol08goo00<007ooOol0
8goo00<0GgooOol0EWoo001=Ool00`1OOomoo`0TOol00`00Oomoo`0TOol00`1OOomoo`1EOol004ao
o`0305moogoo02Eoo`03001oogoo02Eoo`0305moogoo05Aoo`00Bgoo00<0GgooOol09Woo00<007oo
Ool09Woo00<0GgooOol0Dgoo001;Ool00`1OOomoo`0VOol00`00Oomoo`0VOol00`1OOomoo`1COol0
04Yoo`0305moogoo02Moo`03001oogoo02Moo`0305moogoo059oo`00BGoo00<0GgooOol03goo1000
1Goo0P001Goo10001Goo00<007ooOol0:7oo00<0GgooOol0DGoo0018Ool00`1OOomoo`0?Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0X
Ool00`1OOomoo`1AOol004Qoo`0305moogoo00moo`03001oogoo009oo`03001oogoo00eoo`03001o
ogoo009oo`03001oogoo02Uoo`0305moogoo051oo`00Agoo00<0GgooOol027oo1P000Woo00<007oo
Ool00Woo00<007ooOol03Goo00<007ooOol00Woo0P00:Woo00<0GgooOol0D7oo0016Ool00`1OOomo
o`0AOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0ZOol00`1OOomoo`1?Ool0
04Ioo`0305moogoo015oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo
02]oo`0305moogoo04ioo`00AGoo00<0GgooOol04Woo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol01Woo00<007ooOol0:goo00<0GgooOol0CWoo0015Ool00`1OOomoo`0COol4000<Ool50004
Ool00`00Oomoo`0/Ool00`1OOomoo`1=Ool004Aoo`0305moogoo02eoo`03001oogoo02eoo`0305mo
ogoo04aoo`00A7oo00<0GgooOol0;Goo00<007ooOol0;Goo00<0GgooOol0C7oo0013Ool00`1OOomo
o`0^Ool00`00Oomoo`0^Ool00`1OOomoo`1;Ool004=oo`0305moogoo02ioo`03001oogoo02ioo`03
05moogoo04]oo`00@goo00<0GgooOol0;Woo00<007ooOol0;Woo00<0GgooOol0Bgoo0012Ool00`1O
Oomoo`0_Ool00`00Oomoo`0^Ool00`1OOomoo`1;Ool0049oo`0305moogoo02moo`03001oogoo02mo
o`0305moogoo04Yoo`00@Goo00<0GgooOol0<7oo00<007ooOol0;goo00<0GgooOol0BWoo0009Ool5
000?Ool50004Ool20005Ool4000?Ool00`0005l00002000>Ool40005Ool20005Ool4000=Ool00`00
Oomoo`0>Ool40005Ool20005Ool4000=Ool00`1OOol00004000>Ool50004Ool20005Ool4000>Ool5
000AOol000Uoo`05001oogooOol0000AOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00
Oomoo`0=Ool00`1O001oo`0>Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02
Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`0:Ool01@1OOomoogoo00004Woo00<007ooOol017oo0P0017oo00<007oo
Ool00Woo00<007ooOol02goo00D007ooOomoo`00015oo`002Woo00<007ooOol04Woo00<007ooOol0
3goo00<007ooOol03Goo00<0G`00Ool03Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol0
2Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol02Woo00D0GgooOomo
o`00019oo`03001oogoo00moo`03001oogoo00aoo`03001oogoo019oo`0000=oo`000000100017oo
00<007ooOol01Woo1P001Goo00<007ooOol03goo00<007ooOol00goo1P000goo00<0Ggoo00001goo
1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol02Woo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol03Goo00<007ooOol02goo00@0GgooOol0019oo`03001oogoo00moo`03001o
ogoo00eoo`03001oogoo015oo`0037oo00<007ooOol047oo00<007ooOol02goo10003goo00<0Ggoo
00003goo00<007ooOol00Woo00<007ooOol02Goo10003Goo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol02Goo10003Woo00@0GgooOol0019oo`03001oogoo00]oo`@0015oo`03001oogoo011o
o`003Goo00<007ooOol03goo00<007ooOol02goo00<007ooOol047oo00<0Ggoo00003goo00<007oo
Ool00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<007oo
Ool02Goo00<007ooOol03goo00@0GgooOol0019oo`03001oogoo00]oo`03001oogoo01=oo`03001o
ogoo00moo`002Goo00D007ooOomoo`0000moo`<000eoo`03001oogoo011oo`0305l0000000moo`03
001oogoo009oo`03001oogoo00Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00moo`0405l00000000@Ool3000=Ool00`00Oomoo`0?Ool01@00Oomo
ogoo00004Goo000:Ool3000BOol00`00Oomoo`0;Ool5000=Ool0101OOomoo`0047oo100037oo1@00
37oo00<007ooOol03Woo100037oo1@003Woo00<0Ggoo00004Woo00<007ooOol02goo1@003Woo0`00
4Woo000oOol00`1OOomoo`0bOol00`00Oomoo`0aOol00`1OOomoo`18Ool003moo`0305moogoo039o
o`03001oogoo035oo`0305moogoo04Qoo`00?goo00<0GgooOol0<Woo00<007ooOol0<Goo00<0Ggoo
Ool0B7oo000oOol00`1OOomoo`0bOol00`00Oomoo`0aOol00`1OOomoo`18Ool003moo`0305moogoo
039oo`03001oogoo035oo`0305moogoo03eoo`80009oo`8000Eoo`00?goo00<0GgooOol0<Woo00<0
07ooOol0<Goo00<0GgooOol0?Woo00@007ooOol000Ioo`0027oo=`0000<0G`000000IP0000<0G`00
0000=P002Goo0P001goo0008Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool00`0005moo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool01`00Oomoogoo05moo`0000Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo00Moo`8000Moo`0027oo00<007ooOol067oo00<007ooOol0
67oo00<0001OOol067oo00<007ooOol067oo00<007ooOol067oo00<007ooOol05Woo00<0Ggoo0000
6Woo00<007ooOol067oo00<007ooOol01Woo00@007ooOol000Ioo`00?goo00<0GgooOol0<Woo00<0
07ooOol0<Goo00<0GgooOol0?Goo0P000Woo0P001Goo000oOol00`1OOomoo`0bOol00`00Oomoo`0a
Ool00`1OOomoo`18Ool003moo`0305moogoo039oo`03001oogoo035oo`0305moogoo04Qoo`00?goo
00<0GgooOol0<Woo00<007ooOol0<Goo00<0GgooOol0B7oo000oOol00`1OOomoo`0bOol00`00Oomo
o`0aOol00`1OOomoo`18Ool0041oo`0305moogoo035oo`03001oogoo031oo`0305moogoo04Uoo`00
@7oo00<0GgooOol0<Goo00<007ooOol0<7oo00<0GgooOol0BGoo0010Ool00`1OOomoo`0aOol00`00
Oomoo`0`Ool00`1OOomoo`19Ool0041oo`0305moogoo035oo`03001oogoo031oo`0305moogoo04Uo
o`00@7oo00<0GgooOol0<Goo00<007ooOol0<7oo00<0GgooOol0BGoo0011Ool00`1OOomoo`0`Ool0
0`00Oomoo`0_Ool00`1OOomoo`1:Ool0045oo`0305moogoo031oo`03001oogoo02moo`0305moogoo
04Yoo`00@Goo00<0GgooOol0<7oo00<007ooOol0;goo00<0GgooOol0BWoo0012Ool00`1OOomoo`0_
Ool00`00Oomoo`0_Ool00`1OOomoo`1:Ool0049oo`0305moogoo02moo`03001oogoo02ioo`0305mo
ogoo04]oo`00@goo00<0GgooOol0;Woo00<007ooOol0;Woo00<0GgooOol0Bgoo0013Ool00`1OOomo
o`0^Ool00`00Oomoo`0^Ool00`1OOomoo`1;Ool004=oo`0305moogoo02ioo`03001oogoo02ioo`03
05moogoo04]oo`00A7oo00<0GgooOol0;Goo00<007ooOol0;Goo00<0GgooOol0C7oo0014Ool00`1O
Oomoo`0]Ool00`00Oomoo`0]Ool00`1OOomoo`1<Ool004Eoo`0305moogoo02aoo`03001oogoo02ao
o`0305moogoo04eoo`00AGoo00<0GgooOol04goo10001Goo0P001Goo10001Goo00<007ooOol0;7oo
00<0GgooOol0CGoo0016Ool00`1OOomoo`0AOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0[Ool00`1OOomoo`1>Ool004Ioo`0305moogoo
015oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo02Yoo`0305moogoo
04moo`00Agoo00<0GgooOol047oo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00
:goo00<0GgooOol0Cgoo0017Ool00`1OOomoo`0@Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005
Ool00`00Oomoo`0YOol00`1OOomoo`1@Ool004Qoo`0305moogoo00moo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo00Ioo`03001oogoo02Qoo`0305moogoo055oo`00BGoo00<0GgooOol03Woo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0:7oo00<0GgooOol0DGoo
0019Ool00`1OOomoo`0?Ool4000<Ool50004Ool00`00Oomoo`0WOol00`1OOomoo`1BOol004Yoo`03
05moogoo02Moo`03001oogoo02Moo`0305moogoo059oo`00Bgoo00<0GgooOol09Woo00<007ooOol0
9Woo00<0GgooOol0Dgoo001<Ool00`1OOomoo`0UOol00`00Oomoo`0UOol00`1OOomoo`1DOol004ao
o`0305moogoo02Eoo`03001oogoo02Eoo`0305moogoo05Aoo`00CGoo00<0GgooOol097oo00<007oo
Ool097oo00<0GgooOol0EGoo001>Ool00`1OOomoo`0SOol00`00Oomoo`0SOol00`1OOomoo`1FOol0
04moo`0305moogoo029oo`03001oogoo025oo`80GeUoo`00D7oo00<0GgooOol08Goo00<007ooOol0
87oo00<0GgooOol0FGoo001AOol00`1OOomoo`0POol00`00Oomoo`0OOol00`1OOomoo`1JOol0059o
o`80Gb1oo`03001oogoo01eoo`80Geeoo`00E7oo00<0GgooOol07Goo00<007ooOol077oo00<0Ggoo
Ool0GGoo001EOol00`1OOomoo`0LOol00`00Oomoo`0KOol00`1OOomoo`1NOol005Ioo`80Gaaoo`03
001oogoo01Uoo`80Gf5oo`00F7oo00<0GgooOol06Goo00<007ooOol067oo00<0GgooOol0HGoo001I
Ool205lIOol00`00Oomoo`0FOol205mTOol005]oo`<0GaIoo`03001oogoo01Aoo`80GfIoo`00GWoo
0P1O57oo00<007ooOol04Woo0P1OJ7oo001POol205lBOol00`00Oomoo`0?Ool305mZOol0069oo`80
Ga1oo`03001oogoo00eoo`80Gfeoo`00I7oo101O0goo1@0017oo00<007ooOol02Goo101OKgoo001X
Ool505l00`00Oomoo`04Ool00`00Oomoo`05Ool405mcOol006eoo`l0GgMoo`00KGoo00<007ooOol0
17oo0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001o
ogoo07aoo`00Jgoo0`001Woo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007ooOol0O7oo001M
Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1lOol005eo
o`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00GGoo00<007ooOol03goo00<007oo
Ool00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1lOol005eoo`03001oogoo
00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007ooOol01Woo00<007ooOol0
O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00JWoo1@001Goo00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[
Ool00`00Oomoo`06Ool00`00Oomoo`1lOol006aoo`03001oogoo00Eoo`8007eoo`00KGoo00<007oo
Ool0Pgoo001^Ool00`00Oomoo`22Ool006Yoo`05001oogooOol00024Ool006]oo`<008Eoo`00lgoo
003cOol00?=oo`00lgoo002AOol3000;Ool40005Ool20006Ool30004Ool4000hOol0091oo`06001o
ogooOol007oo1P000Woo00<007ooOol00Woo00<007ooOol00Woo0P001Goo00D007ooOomoo`00009o
o`03001oogoo009oo`03001oogoo03Eoo`00Lgoo0P0000=oo`00000067oo00<007ooOol02goo00<0
07ooOol00Woo00<007ooOol02Goo00D007ooOomoo`0000Moo`03001oogoo03Eoo`00LWoo00<007oo
Ool00P006Goo00<007ooOol00goo1P000Woo00<007ooOol00Woo00<007ooOol02Goo00D007ooOomo
o`0000Moo`03001oogoo03Eoo`00LWoo00D007ooOomoo`0001Uoo`03001oogoo00]oo`03001oogoo
009oo`03001oogoo00Uoo`@000Aoo`@003Qoo`00LWoo00D007ooOomoo`0001Qoo`D000Yoo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo00Eoo`03001oogoo03Uoo`00LWoo00D007ooOomoo`00
01Uoo`03001oogoo00]oo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo00Aoo`03001oogoo
03Uoo`00LGoo0P000Woo0P00:7oo10003Woo0`000goo1@00=goo003cOol00?=oo`00lgoo003cOol0
0?=oo`00\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.6) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 .4 1 r

.5 Mabswid

.27639 .49993 m

.27735 .47937 L

.2802 .45891 L

.28493 .43881 L

.29149 .41922 L

.29984 .40033 L

.30989 .38229 L

.32156 .36525 L

.33475 .34936 L

.34936 .33475 L

.36525 .32156 L

.38229 .30989 L

.40033 .29984 L

.41922 .29149 L

.43881 .28493 L

.45891 .2802 L

.47937 .27735 L

.5 .27639 L

.52063 .27735 L

.54109 .2802 L

.56119 .28493 L

.58078 .29149 L

.59967 .29984 L

.61771 .30989 L

.63475 .32156 L

.65064 .33475 L

.66525 .34936 L

.67844 .36525 L

.69011 .38229 L

.70016 .40033 L

.70851 .41922 L

.71507 .43881 L

.7198 .45891 L

.72265 .47937 L

.72361 .49993 L

s

.27639 .50007 m

.27735 .52063 L

.2802 .54109 L

.28493 .56119 L

.29149 .58078 L

.29984 .59967 L

.30989 .61771 L

.32156 .63475 L

.33475 .65064 L

.34936 .66525 L

.36525 .67844 L

.38229 .69011 L

.40033 .70016 L

.41922 .70851 L

.43881 .71507 L

.45891 .7198 L

.47937 .72265 L

.5 .72361 L

.52063 .72265 L

.54109 .7198 L

.56119 .71507 L

.58078 .70851 L

.59967 .70016 L

.61771 .69011 L

.63475 .67844 L

.65064 .66525 L

.66525 .65064 L

.67844 .63475 L

.69011 .61771 L

.70016 .59967 L

.70851 .58078 L

.71507 .56119 L

.7198 .54109 L

.72265 .52063 L

.72361 .50007 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00
Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00HWoo1P001Goo00<007ooOol017oo
0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo
07aoo`00Jgoo0`001Woo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00KWoo3@6ON7oo001YOol50Il6Ool00`00Oomoo`04Ool40ImdOol006Eoo`@1
W`]oo`03001oogoo00Qoo`@1Wg1oo`00HWoo0`6O3goo00<007ooOol037oo0`6OKGoo001POol20IlB
Ool00`00Oomoo`0?Ool20Im[Ool005ioo`81WaAoo`03001oogoo015oo`81WfUoo`00G7oo0P6O5Woo
00<007ooOol04goo0P6OIgoo001JOol20IlHOol00`00Oomoo`0EOol20ImUOol005Uoo`030Imoogoo
01Qoo`03001oogoo01Moo`030Imoogoo069oo`00F7oo00<1WgooOol06Goo00<007ooOol067oo0P6O
HWoo001GOol00`6OOomoo`0JOol00`00Oomoo`0JOol00`6OOomoo`1OOol005Ioo`030Imoogoo01]o
o`03001oogoo01]oo`030Imoogoo05ioo`00E7oo0P6O7Woo00<007ooOol077oo00<1WgooOol0GGoo
001COol00`6OOomoo`0NOol00`00Oomoo`0MOol00`6OOomoo`1LOol0059oo`030Imoogoo01moo`03
001oogoo01ioo`030Imoogoo05]oo`00DGoo00<1WgooOol087oo00<007ooOol07goo00<1WgooOol0
FWoo001@Ool00`6OOomoo`0QOol00`00Oomoo`0POol00`6OOomoo`1IOol004moo`030Imoogoo029o
o`03001oogoo025oo`030Imoogoo05Qoo`00CWoo00<1WgooOol02Woo10001Goo0P001Goo10001Goo
00<007ooOol08Woo00<1WgooOol0Egoo001=Ool00`6OOomoo`0:Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0SOol00`6OOomoo`1FOol0
04aoo`030Imoogoo00]oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo
02Aoo`030Imoogoo05Eoo`00C7oo00<1WgooOol00goo1P000Woo00<007ooOol00Woo00<007ooOol0
3Goo00<007ooOol00Woo0P009Woo00<1WgooOol0E7oo001;Ool00`6OOomoo`0<Ool00`00Oomoo`02
Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0UOol00`6OOomoo`1DOol004]oo`030Imoogoo00ao
o`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo02Ioo`030Imoogoo05=o
o`00BWoo00<1WgooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007oo
Ool09goo00<1WgooOol0DWoo001:Ool00`6OOomoo`0>Ool4000<Ool50004Ool00`00Oomoo`0WOol0
0`6OOomoo`1BOol004Uoo`030Imoogoo02Qoo`03001oogoo02Qoo`030Imoogoo055oo`00BGoo00<1
WgooOol0:7oo00<007ooOol0:7oo00<1WgooOol0DGoo0018Ool00`6OOomoo`0YOol00`00Oomoo`0Y
Ool00`6OOomoo`1@Ool004Qoo`030Imoogoo02Uoo`03001oogoo02Uoo`030Imoogoo051oo`00Agoo
00<1WgooOol0:Woo00<007ooOol0:Woo00<1WgooOol0Cgoo0017Ool00`6OOomoo`0ZOol00`00Oomo
o`0ZOol00`6OOomoo`1?Ool004Ioo`030Imoogoo02]oo`03001oogoo02Yoo`030Imoogoo04moo`00
AWoo00<1WgooOol0:goo00<007ooOol0:goo00<1WgooOol0CWoo0009Ool5000?Ool50004Ool20005
Ool4000?Ool500000`6OOomoo`0;Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool2
0005Ool40009Ool00`6OOomoo`03Ool5000>Ool50004Ool20005Ool4000>Ool5000AOol000Uoo`05
001oogooOol0000AOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool01000
Oomoo`6O37oo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol0
2Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<0
07ooOol01Woo00<1WgooOol01Goo00<007ooOol047oo00<007ooOol017oo0P0017oo00<007ooOol0
0Woo00<007ooOol02goo00D007ooOomoo`00015oo`002Woo00<007ooOol04Woo00<007ooOol03goo
00<007ooOol03Woo00@007ooOol1W`aoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00Yo
o`03001oogoo00eoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00Ioo`030Imoogoo00Eo
o`03001oogoo011oo`03001oogoo00moo`03001oogoo00aoo`03001oogoo019oo`0000=oo`000000
100017oo00<007ooOol01Woo1P001Goo00<007ooOol03goo00<007ooOol00goo1P001Goo00<007oo
0Il01Goo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol02Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol01goo00<1WgooOol017oo00<007ooOol047oo
00<007ooOol03goo00<007ooOol03Goo00<007ooOol04Goo000<Ool00`00Oomoo`0@Ool00`00Oomo
o`0;Ool4000AOol00`00Ool1W`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool4000=Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool4000:Ool00`6OOomoo`04Ool00`00Oomoo`0@Ool0
0`00Oomoo`0;Ool4000AOol00`00Oomoo`0@Ool000eoo`03001oogoo00moo`03001oogoo00]oo`03
001oogoo019oo`03001oo`6O00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00ioo`03
001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00]oo`030Imoogoo00Aoo`03
001oogoo011oo`03001oogoo00]oo`03001oogoo01=oo`03001oogoo00moo`002Goo00D007ooOomo
o`0000moo`<000eoo`03001oogoo011oo`<00003Ool1Wgoo00aoo`03001oogoo009oo`03001oogoo
00Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00]oo`030Imoogoo009oo`<0011oo`<000eoo`03001oogoo00moo`05001oogooOol0000AOol000Yo
o`<0019oo`03001oogoo00]oo`D0011oo`03001oo`6O00ioo`@000aoo`D000aoo`03001oogoo00io
o`@000aoo`D000Uoo`030Imoogoo00Aoo`03001oogoo011oo`03001oogoo00]oo`D000ioo`<0019o
o`00A7oo00<1WgooOol0;Goo00<007ooOol0;Goo00<1WgooOol0C7oo0014Ool00`6OOomoo`0]Ool0
0`00Oomoo`0]Ool00`6OOomoo`1<Ool004Aoo`030Imoogoo02eoo`03001oogoo02eoo`030Imoogoo
04aoo`00A7oo00<1WgooOol0;Goo00<007ooOol0;Goo00<1WgooOol0C7oo0013Ool00`6OOomoo`0^
Ool00`00Oomoo`0]Ool00`6OOomoo`11Ool20002Ool20005Ool004=oo`030Imoogoo02ioo`03001o
ogoo02eoo`030Imoogoo049oo`04001oogoo0006Ool000Qooc/000030Il0000005h000030Il00000
03X000Uoo`8000Moo`0027oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol00Woo00<1WgooOol00goo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool00Woo00<1WgooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol01goo0P001goo0008Ool00`00Oomoo`0HOol00`00Oomo
o`0HOol00`00Oomoo`02Ool00`6OOomoo`0COol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomo
o`0BOol00`6OOomoo`03Ool00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`06Ool01000Oomo
o`001Woo0014Ool00`6OOomoo`0]Ool00`00Oomoo`0]Ool00`6OOomoo`11Ool20002Ool20005Ool0
04Aoo`030Imoogoo02eoo`03001oogoo02eoo`030Imoogoo04aoo`00A7oo00<1WgooOol0;Goo00<0
07ooOol0;Goo00<1WgooOol0C7oo0014Ool00`6OOomoo`0]Ool00`00Oomoo`0]Ool00`6OOomoo`1<
Ool004Aoo`030Imoogoo02eoo`03001oogoo02aoo`030Imoogoo04eoo`00A7oo00<1WgooOol0;Goo
00<007ooOol0;7oo00<1WgooOol0CGoo0014Ool00`6OOomoo`0]Ool00`00Oomoo`0/Ool00`6OOomo
o`1=Ool004Aoo`030Imoogoo02eoo`03001oogoo02aoo`030Imoogoo04eoo`00AGoo00<1WgooOol0
;7oo00<007ooOol0:goo00<1WgooOol0CWoo0015Ool00`6OOomoo`0/Ool00`00Oomoo`0[Ool00`6O
Oomoo`1>Ool004Eoo`030Imoogoo02aoo`03001oogoo02]oo`030Imoogoo04ioo`00AGoo00<1Wgoo
Ool0;7oo00<007ooOol0:goo00<1WgooOol0CWoo0016Ool00`6OOomoo`0[Ool00`00Oomoo`0[Ool0
0`6OOomoo`1>Ool004Ioo`030Imoogoo02]oo`03001oogoo02Yoo`030Imoogoo04moo`00Agoo00<1
WgooOol0:Woo00<007ooOol0:Woo00<1WgooOol0Cgoo0017Ool00`6OOomoo`0ZOol00`00Oomoo`0Z
Ool00`6OOomoo`1?Ool004Qoo`030Imoogoo02Uoo`03001oogoo02Uoo`030Imoogoo051oo`00B7oo
00<1WgooOol0:Goo00<007ooOol0:Goo00<1WgooOol0D7oo0019Ool00`6OOomoo`0XOol00`00Oomo
o`0XOol00`6OOomoo`1AOol004Uoo`030Imoogoo02Qoo`03001oogoo02Qoo`030Imoogoo055oo`00
BWoo00<1WgooOol09goo00<007ooOol09goo00<1WgooOol0DWoo001:Ool00`6OOomoo`0>Ool40005
Ool20005Ool40005Ool00`00Oomoo`0WOol00`6OOomoo`1BOol004]oo`030Imoogoo00aoo`03001o
ogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo02Io
o`030Imoogoo05=oo`00Bgoo00<1WgooOol037oo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol09Woo00<1WgooOol0Dgoo001<Ool00`6OOomoo`0;Ool00`00Oomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`02Ool2000VOol00`6OOomoo`1DOol004aoo`030Imoogoo00]oo`03
001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo02Aoo`030Imoogoo05Eoo`00CGoo00<1
WgooOol02Woo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol08goo00<1
WgooOol0EWoo001>Ool00`6OOomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06
Ool00`00Oomoo`0ROol00`6OOomoo`1GOol004moo`030Imoogoo00Uoo`@000aoo`D000Aoo`03001o
ogoo025oo`030Imoogoo05Qoo`00Cgoo00<1WgooOol08Woo00<007ooOol08Goo00<1WgooOol0F7oo
001@Ool00`6OOomoo`0QOol00`00Oomoo`0POol00`6OOomoo`1IOol0055oo`030Imoogoo021oo`03
001oogoo01moo`030Imoogoo05Yoo`00DWoo00<1WgooOol07goo00<007ooOol07Woo00<1WgooOol0
Fgoo001COol00`6OOomoo`0NOol00`00Oomoo`0MOol00`6OOomoo`1LOol005Aoo`030Imoogoo01eo
o`03001oogoo01aoo`030Imoogoo05eoo`00EGoo0P6O7Goo00<007ooOol06goo00<1WgooOol0GWoo
001GOol00`6OOomoo`0JOol00`00Oomoo`0JOol00`6OOomoo`1OOol005Qoo`81WaYoo`03001oogoo
01Qoo`81Wf9oo`00FWoo00<1WgooOol05goo00<007ooOol05Woo0P6OI7oo001KOol20IlGOol00`00
Oomoo`0DOol20ImVOol005eoo`81WaEoo`03001oogoo019oo`81WfQoo`00Ggoo0P6O4goo00<007oo
Ool047oo0P6OJWoo001QOol20IlAOol00`00Oomoo`0>Ool20Im/Ool006=oo`81W`moo`03001oogoo
00aoo`81Wfioo`00IGoo106O2goo00<007ooOol02Goo0`6OL7oo001YOolG0ImcOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001[Ool50004Ool00`00Oomoo`1lOol006eoo`03001oogoo
00Aoo`03001oogoo07aoo`00KGoo00<007ooOol017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04
Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KGoo00<007ooOol017oo00<007oo
Ool0O7oo001[Ool30006Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001KOol50004Ool20005Ool40005Ool00`00Oomoo`1lOol005eo
o`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo07aoo`00GGoo
00<007ooOol03goo00<007ooOol00Woo00<007ooOol0O7oo001MOol00`00Oomoo`0?Ool00`00Oomo
o`02Ool2001mOol005eoo`03001oogoo00]oo`@000Eoo`03001oogoo07aoo`00GGoo00<007ooOol0
2goo00<007ooOol01Woo00<007ooOol0O7oo001KOol3000=Ool00`00Oomoo`06Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`D000Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001ZOol50005Ool00`00Oomoo`1lOol006Yoo`05001oogooOol00005Ool00`00Oomoo`1lOol006]o
o`03001oogoo00Ioo`03001oogoo07aoo`00K7oo00<007ooOol01Goo0P00OGoo001]Ool00`00Oomo
o`23Ool006ioo`03001oogoo089oo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo0`00QGoo003cOol0
0?=oo`00lgoo003cOol009Eoo`<000]oo`@000Eoo`8000Ioo`<003aoo`00U7oo00H007ooOomoo`00
Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20005Ool01@00Oomoogoo0000>goo001cOol2
00000goo0000000LOol00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01@00Oomoogoo
0000>goo001bOol00`00Oomoo`02000MOol00`00Oomoo`03Ool60002Ool00`00Oomoo`02Ool00`00
Oomoo`09Ool01@00Oomoogoo0000>goo001bOol01@00Oomoogoo00007Goo00<007ooOol02goo00<0
07ooOol00Woo00<007ooOol02Goo1000?7oo001bOol01@00Oomoogoo000077oo1@002Woo00<007oo
Ool00Woo00<007ooOol02Goo00<007ooOol0?Goo001bOol01@00Oomoogoo00007Goo00<007ooOol0
2goo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol0?7oo001aOol20002Ool2000/Ool4000>
Ool3000kOol00?=oo`00lgoo003cOol00?=oo`00lgoo0000\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.55) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 .7 1 r

.5 Mabswid

.29844 .49994 m

.2993 .4814 L

.30188 .46296 L

.30614 .44484 L

.31205 .42719 L

.31957 .41016 L

.32863 .39389 L

.33915 .37854 L

.35105 .36421 L

.36421 .35105 L

.37854 .33915 L

.39389 .32863 L

.41016 .31957 L

.42719 .31205 L

.44484 .30614 L

.46296 .30188 L

.4814 .2993 L

.5 .29844 L

.5186 .2993 L

.53704 .30188 L

.55516 .30614 L

.57281 .31205 L

.58984 .31957 L

.60611 .32863 L

.62146 .33915 L

.63579 .35105 L

.64895 .36421 L

.66085 .37854 L

.67137 .39389 L

.68043 .41016 L

.68795 .42719 L

.69386 .44484 L

.69812 .46296 L

.7007 .4814 L

.70156 .49994 L

s

.29844 .50006 m

.2993 .5186 L

.30188 .53704 L

.30614 .55516 L

.31205 .57281 L

.31957 .58984 L

.32863 .60611 L

.33915 .62146 L

.35105 .63579 L

.36421 .64895 L

.37854 .66085 L

.39389 .67137 L

.41016 .68043 L

.42719 .68795 L

.44484 .69386 L

.46296 .69812 L

.4814 .7007 L

.5 .70156 L

.5186 .7007 L

.53704 .69812 L

.55516 .69386 L

.57281 .68795 L

.58984 .68043 L

.60611 .67137 L

.62146 .66085 L

.63579 .64895 L

.64895 .63579 L

.66085 .62146 L

.67137 .60611 L

.68043 .58984 L

.68795 .57281 L

.69386 .55516 L

.69812 .53704 L

.7007 .5186 L

.70156 .50006 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00
Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00HWoo1P001Goo00<007ooOol017oo
0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo
07aoo`00Jgoo0`001Woo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol006]ooa<2_gEoo`00J7oo0`:o2Goo
00<007ooOol01goo0`:oLWoo001VOol20[l<Ool00`00Oomoo`0:Ool20[m`Ool006=oo`<2_`ioo`03
001oogoo00aoo`82_fioo`00H7oo0`:o4Goo00<007ooOol03Woo0`:oJgoo001NOol20[lDOol00`00
Oomoo`0AOol20[mYOol005eoo`030[moogoo01Aoo`03001oogoo01=oo`82_fMoo`00G7oo00<2_goo
Ool05Goo00<007ooOol05Goo00<2_gooOol0I7oo001JOol20[lHOol00`00Oomoo`0FOol00`:oOomo
o`1SOol005Uoo`030[moogoo01Qoo`03001oogoo01Moo`030[moogoo069oo`00Egoo0P:o6goo00<0
07ooOol067oo0P:oHWoo001FOol00`:oOomoo`0KOol00`00Oomoo`0JOol00`:oOomoo`1OOol005Eo
o`030[moogoo01aoo`03001oogoo01]oo`030[moogoo05ioo`00EGoo00<2_gooOol00goo10001Goo
0P001Goo10001Goo00<007ooOol077oo00<2_gooOol0GGoo001DOol00`:oOomoo`03Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0MOol0
0`:oOomoo`1LOol005=oo`030[moogoo00Aoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo
009oo`03001oogoo01ioo`030[moogoo05]oo`00DWoo00<2_`0000000`000Woo00<007ooOol00Woo
00<007ooOol03Goo00<007ooOol00Woo0P007goo00<2_gooOol0Fgoo001AOol00`:oOomoo`06Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0OOol00`:oOomoo`1JOol0051oo`03
0[moogoo00Moo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo021oo`03
0[moogoo05Uoo`00D7oo00<2_gooOol01goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol0
1Woo00<007ooOol08Goo00<2_gooOol0F7oo001?Ool00`:oOomoo`09Ool4000<Ool50004Ool00`00
Oomoo`0ROol00`:oOomoo`1GOol004ioo`030[moogoo02=oo`03001oogoo02=oo`030[moogoo05Io
o`00CWoo00<2_gooOol08goo00<007ooOol08goo00<2_gooOol0EWoo001=Ool00`:oOomoo`0TOol0
0`00Oomoo`0TOol00`:oOomoo`1EOol004eoo`030[moogoo02Aoo`03001oogoo02Aoo`030[moogoo
05Eoo`00C7oo00<2_gooOol09Goo00<007ooOol097oo00<2_gooOol0EGoo001<Ool00`:oOomoo`0U
Ool00`00Oomoo`0UOol00`:oOomoo`1DOol004]oo`030[moogoo02Ioo`03001oogoo02Eoo`030[mo
ogoo05Aoo`00Bgoo00<2_gooOol09Woo00<007ooOol09Goo00<2_gooOol0E7oo0009Ool5000?Ool5
0004Ool20005Ool4000?Ool50005Ool00`:oOomoo`06Ool40005Ool20005Ool4000=Ool00`00Oomo
o`0>Ool40005Ool20005Ool40004Ool00`:oOomoo`08Ool5000>Ool50004Ool20005Ool4000>Ool5
000AOol000Uoo`05001oogooOol0000AOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00
Oomoo`0>Ool00`00Oomoo`05Ool00`:oOomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20004Ool00`00Oomoo`02Ool01@00Oomoogoo0[l037oo00<007ooOol047oo00<007ooOol017oo
0P0017oo00<007ooOol00Woo00<007ooOol02goo00D007ooOomoo`00015oo`002Woo00<007ooOol0
4Woo00<007ooOol03goo00<007ooOol03Woo00<007ooOol01Goo00<2_gooOol01Goo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol02Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0
3Goo00D007ooOomoo`:o00aoo`03001oogoo011oo`03001oogoo00moo`03001oogoo00aoo`03001o
ogoo019oo`0000=oo`000000100017oo00<007ooOol01Woo1P001Goo00<007ooOol03goo00<007oo
Ool00goo1P001Goo00<007ooOol01Goo00<2_`0000000`000Woo00<007ooOol00Woo00<007ooOol0
3Goo00<007ooOol02Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo00D007ooOomo
o`:o00aoo`03001oogoo011oo`03001oogoo00moo`03001oogoo00eoo`03001oogoo015oo`0037oo
00<007ooOol047oo00<007ooOol02goo10004Goo00<007ooOol017oo00<2_gooOol01Woo00<007oo
Ool00Woo00<007ooOol02Goo10003Goo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo
10001Goo00<2_gooOol02Goo00<007ooOol047oo00<007ooOol02goo10004Goo00<007ooOol047oo
000=Ool00`00Oomoo`0?Ool00`00Oomoo`0;Ool00`00Oomoo`0BOol00`00Oomoo`04Ool00`:oOomo
o`06Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`:oOomoo`09Ool00`00Oomoo`0@Ool00`00Oomo
o`0;Ool00`00Oomoo`0COol00`00Oomoo`0?Ool000Uoo`05001oogooOol0000?Ool3000=Ool00`00
Oomoo`0@Ool30006Ool00`:oOomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0>
Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`:oOomoo`07
Ool3000@Ool3000=Ool00`00Oomoo`0?Ool01@00Oomoogoo00004Goo000:Ool3000BOol00`00Oomo
o`0;Ool5000@Ool00`00Oomoo`04Ool00`:oOomoo`07Ool4000<Ool5000<Ool00`00Oomoo`0>Ool4
000<Ool50004Ool00`:oOomoo`09Ool00`00Oomoo`0@Ool00`00Oomoo`0;Ool5000>Ool3000BOol0
04Qoo`030[moogoo02Uoo`03001oogoo02Qoo`030[moogoo055oo`00B7oo00<2_gooOol0:Goo00<0
07ooOol0:7oo00<2_gooOol0DGoo0018Ool00`:oOomoo`0YOol00`00Oomoo`0XOol00`:oOomoo`1A
Ool004Qoo`030[moogoo02Uoo`03001oogoo02Qoo`030[moogoo055oo`00B7oo00<2_gooOol0:Goo
00<007ooOol0:7oo00<2_gooOol0AWoo0P000Woo0P001Goo0018Ool00`:oOomoo`0YOol00`00Oomo
o`0XOol00`:oOomoo`17Ool01000Oomoo`001Woo0008Oom000000`:o0000001D00000`:o0000000o
0009Ool20007Ool000Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`030[l007oo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`030[moogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo00Moo`8000Moo`0027oo00<007ooOol067oo00<007ooOol0
67oo00<007ooOol01goo00<2_gooOol03Woo00<007ooOol067oo00<007ooOol067oo00<007ooOol0
3Goo00<2_gooOol027oo00<007ooOol067oo00<007ooOol067oo00<007ooOol01Woo00@007ooOol0
00Ioo`00B7oo00<2_gooOol0:Goo00<007ooOol0:7oo00<2_gooOol0AWoo0P000Woo0P001Goo0018
Ool00`:oOomoo`0YOol00`00Oomoo`0XOol00`:oOomoo`1AOol004Qoo`030[moogoo02Uoo`03001o
ogoo02Qoo`030[moogoo055oo`00BGoo00<2_gooOol0:7oo00<007ooOol09goo00<2_gooOol0DWoo
0019Ool00`:oOomoo`0XOol00`00Oomoo`0WOol00`:oOomoo`1BOol004Uoo`030[moogoo02Qoo`03
001oogoo02Moo`030[moogoo059oo`00BGoo00<2_gooOol0:7oo00<007ooOol09goo00<2_gooOol0
DWoo001:Ool00`:oOomoo`0WOol00`00Oomoo`0VOol00`:oOomoo`1COol004Yoo`030[moogoo02Mo
o`03001oogoo02Ioo`030[moogoo05=oo`00BWoo00<2_gooOol09goo00<007ooOol09Woo00<2_goo
Ool0Dgoo001:Ool00`:oOomoo`0WOol00`00Oomoo`0VOol00`:oOomoo`1COol004]oo`030[moogoo
02Ioo`03001oogoo02Eoo`030[moogoo05Aoo`00Bgoo00<2_gooOol09Woo00<007ooOol09Goo00<2
_gooOol0E7oo001;Ool00`:oOomoo`0VOol00`00Oomoo`0UOol00`:oOomoo`1DOol004aoo`030[mo
ogoo02Eoo`03001oogoo02Eoo`030[moogoo05Aoo`00C7oo00<2_gooOol09Goo00<007ooOol097oo
00<2_gooOol0EGoo001=Ool00`:oOomoo`0TOol00`00Oomoo`0TOol00`:oOomoo`1EOol004eoo`03
0[moogoo02Aoo`03001oogoo02Aoo`030[moogoo05Eoo`00CWoo00<2_gooOol08goo00<007ooOol0
8goo00<2_gooOol0EWoo001>Ool00`:oOomoo`0SOol00`00Oomoo`0SOol00`:oOomoo`1FOol004mo
o`030[moogoo029oo`03001oogoo029oo`030[moogoo05Moo`00D7oo00<2_gooOol027oo10001Goo
0P001Goo10001Goo00<007ooOol08Goo00<2_gooOol0F7oo001@Ool00`:oOomoo`07Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0POol0
0`:oOomoo`1IOol0055oo`030[moogoo00Ioo`03001oogoo009oo`03001oogoo00eoo`03001oogoo
009oo`03001oogoo01moo`030[moogoo05Yoo`00DWoo00<2_gooOol01Goo00<007ooOol00Woo00<0
07ooOol03Goo00<007ooOol00Woo0P007goo00<2_gooOol0Fgoo001COol00`:oOomoo`04Ool00`00
Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0NOol00`:oOomoo`1KOol005Aoo`030[mo
ogoo00=oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo01eoo`030[mo
ogoo05aoo`00EGoo00<2_gooOol00Woo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo
00<007ooOol077oo00<2_gooOol0GGoo001EOol00`:oOomoo`03Ool4000<Ool50004Ool00`00Oomo
o`0KOol00`:oOomoo`1NOol005Ioo`030[moogoo01]oo`03001oogoo01Yoo`030[moogoo05moo`00
Egoo00<2_gooOol06Woo00<007ooOol06Goo00<2_gooOol0H7oo001HOol00`:oOomoo`0IOol00`00
Oomoo`0HOol00`:oOomoo`1QOol005Uoo`030[moogoo01Qoo`03001oogoo01Moo`030[moogoo069o
o`00FWoo0P:o67oo00<007ooOol05Goo0P:oIGoo001LOol20[lFOol00`00Oomoo`0DOol00`:oOomo
o`1UOol005ioo`82_aAoo`03001oogoo019oo`82_fQoo`00H7oo00<2_gooOol04Goo00<007ooOol0
47oo0P:oJWoo001QOol20[lAOol00`00Oomoo`0>Ool20[m/Ool006=oo`<2_`ioo`03001oogoo00]o
o`<2_fioo`00IWoo10:o2Woo00<007ooOol027oo0`:oLGoo001ZOol80[l2Ool00`00Oomoo`080[md
Ool0079oo`D2_gaoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Jgoo
1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo
00Aoo`03001oogoo07aoo`00KGoo00<007ooOol017oo0P00OGoo001]Ool00`00Oomoo`04Ool00`00
Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00Jgoo0`001Woo00<007ooOol0O7oo
001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@00
17oo0P001Goo10001Goo00<007ooOol0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001o
ogoo07aoo`00GGoo00<007ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool4
0005Ool00`00Oomoo`1lOol005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00
Fgoo0`003Goo00<007ooOol01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00JWoo1@001Goo00<007ooOol0O7oo001ZOol0
1@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool00`00Oomoo`06Ool00`00Oomoo`1lOol006ao
o`03001oogoo00Eoo`8007eoo`00KGoo00<007ooOol0Pgoo001^Ool00`00Oomoo`22Ool006Yoo`05
001oogooOol00024Ool006]oo`<008Eoo`00lgoo003cOol00?=oo`00lgoo002AOol3000;Ool40005
Ool20005Ool40004Ool4000hOol0091oo`06001oogooOol007oo1P000Woo00<007ooOol00Woo00<0
07ooOol00Woo0P0017oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo03Eoo`00Lgoo0P00
00=oo`00000067oo00<007ooOol02goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol01Goo
00<007ooOol0=Goo001bOol00`00Oomoo`02000IOol00`00Oomoo`03Ool60002Ool00`00Oomoo`02
Ool00`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`0eOol0079oo`05001oogooOol0000IOol0
0`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40004Ool4000hOol0079oo`05001oogoo
Ool0000HOol5000:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`05Ool00`00Oomoo`0i
Ool0079oo`05001oogooOol0000IOol00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`09Ool0
0`00Oomoo`05Ool00`00Oomoo`0iOol0075oo`80009oo`8002Qoo`@000aoo`D000=oo`D003Moo`00
lgoo003cOol00?=oo`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.5) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 1 r

.5 Mabswid

.32322 .49994 m

.32398 .48369 L

.32623 .46752 L

.32997 .45162 L

.33516 .43614 L

.34176 .4212 L

.3497 .40694 L

.35893 .39347 L

.36936 .38091 L

.38091 .36936 L

.39347 .35893 L

.40694 .3497 L

.4212 .34176 L

.43614 .33516 L

.45162 .32997 L

.46752 .32623 L

.48369 .32398 L

.5 .32322 L

.51631 .32398 L

.53248 .32623 L

.54838 .32997 L

.56386 .33516 L

.5788 .34176 L

.59306 .3497 L

.60653 .35893 L

.61909 .36936 L

.63064 .38091 L

.64107 .39347 L

.6503 .40694 L

.65824 .4212 L

.66484 .43614 L

.67003 .45162 L

.67377 .46752 L

.67602 .48369 L

.67678 .49994 L

s

.32322 .50006 m

.32398 .51631 L

.32623 .53248 L

.32997 .54838 L

.33516 .56386 L

.34176 .5788 L

.3497 .59306 L

.35893 .60653 L

.36936 .61909 L

.38091 .63064 L

.39347 .64107 L

.40694 .6503 L

.4212 .65824 L

.43614 .66484 L

.45162 .67003 L

.46752 .67377 L

.48369 .67602 L

.5 .67678 L

.51631 .67602 L

.53248 .67377 L

.54838 .67003 L

.56386 .66484 L

.5788 .65824 L

.59306 .6503 L

.60653 .64107 L

.61909 .63064 L

.63064 .61909 L

.64107 .60653 L

.6503 .59306 L

.65824 .5788 L

.66484 .56386 L

.67003 .54838 L

.67377 .53248 L

.67602 .51631 L

.67678 .50006 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00
Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00HWoo1P001Goo00<007ooOol017oo
0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo
07aoo`00Jgoo0`001Woo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001_Ool:0omjOol006aoo`<3o`Eoo`03001oogoo009oo`@3ogIoo`00J7oo10?o27oo00<007oo
Ool01Woo0`?oLgoo001UOol30ol<Ool00`00Oomoo`09Ool30om`Ool006=oo`83o`moo`03001oogoo
00aoo`<3ofeoo`00HGoo0P?o4Goo00<007ooOol03goo0P?oJgoo001POol00`?oOomoo`0AOol00`00
Oomoo`0AOol00`?oOomoo`1XOol005ioo`83oaAoo`03001oogoo019oo`83ofQoo`00Fgoo0P0000<3
o`00Ool017oo0P001Goo10001Goo00<007ooOol057oo00<3ogooOol0IGoo001JOol00`000ol3o`02
Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0EOol00`?o
Oomoo`1TOol005Yoo`030omoogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo01Io
o`030omoogoo06=oo`00DWoo1P0000=oo`?o000017oo00<007ooOol03Goo00<007ooOol00Woo0P00
67oo00<3ogooOol0HWoo001IOol00`?o001oo`03Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`0H
Ool00`?oOomoo`1QOol005Qoo`030omoo`0000Aoo`03001oogoo00Uoo`03001oogoo00Ioo`03001o
ogoo01Uoo`030omoogoo061oo`00EWoo0P?o0Woo00<007ooOol00Woo00<007ooOol02Goo00<007oo
Ool01Woo00<007ooOol06Woo00<3ogooOol0Ggoo001EOol00`?oOomoo`03Ool4000<Ool50004Ool0
0`00Oomoo`0KOol00`?oOomoo`1NOol005Aoo`030omoogoo01eoo`03001oogoo01aoo`030omoogoo
05eoo`00E7oo00<3ogooOol07Goo00<007ooOol077oo00<3ogooOol0GGoo001COol00`?oOomoo`0N
Ool00`00Oomoo`0MOol00`?oOomoo`1LOol005=oo`030omoogoo01ioo`03001oogoo01ioo`030omo
ogoo05]oo`00DWoo00<3ogooOol07goo00<007ooOol07Woo00<3ogooOol0Fgoo001BOol00`?oOomo
o`0OOol00`00Oomoo`0OOol00`?oOomoo`1JOol0055oo`030omoogoo021oo`03001oogoo01moo`03
0omoogoo05Yoo`00DGoo00<3ogooOol087oo00<007ooOol087oo00<3ogooOol0FGoo0009Ool5000?
Ool50004Ool20005Ool4000?Ool5000;Ool00`?oOomoo`040005Ool20005Ool4000=Ool00`00Oomo
o`0>Ool40005Ool20005Ool200000`?o001oo`0>Ool5000>Ool50004Ool20005Ool4000>Ool5000A
Ool000Uoo`05001oogooOol0000AOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomo
o`0>Ool00`00Oomoo`0;Ool00`?oOol00004Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool0
0`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool01P00Oomo
o`?oOol0011oo`03001oogoo011oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo
00]oo`05001oogooOol0000AOol000Yoo`03001oogoo019oo`03001oogoo00moo`03001oogoo00io
o`03001oogoo00Yoo`040omoogoo0004Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`?o001oo`0?Ool00`00Oomoo`0@Ool00`00Oomoo`0?
Ool00`00Oomoo`0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Ioo`H000Eo
o`03001oogoo00moo`03001oogoo00=oo`H000Eoo`03001oogoo00Eoo`D000040omoogoo0004Ool0
0`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool0
0`?o001oo`0?Ool00`00Oomoo`0@Ool00`00Oomoo`0?Ool00`00Oomoo`0=Ool00`00Oomoo`0AOol0
00aoo`03001oogoo011oo`03001oogoo00]oo`@0015oo`03001oogoo00Yoo`040omoogoo0004Ool0
0`00Oomoo`09Ool4000=Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool300000`?o
Oomoo`0?Ool00`00Oomoo`0@Ool00`00Oomoo`0;Ool4000AOol00`00Oomoo`0@Ool000eoo`03001o
ogoo00moo`03001oogoo00]oo`03001oogoo019oo`03001oogoo00Yoo`040omoogoo0004Ool00`00
Oomoo`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000
Oomoo`?o4Goo00<007ooOol047oo00<007ooOol02goo00<007ooOol04goo00<007ooOol03goo0009
Ool01@00Oomoogoo00003goo0`003Goo00<007ooOol047oo0`002goo00D3ogooOomoo`0000Aoo`03
001oogoo00Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`05
001oogooOol3o`0>Ool3000@Ool3000=Ool00`00Oomoo`0?Ool01@00Oomoogoo00004Goo000:Ool3
000BOol00`00Oomoo`0;Ool5000@Ool00`00Oomoo`09Ool00`?oOomoo`02Ool4000<Ool5000<Ool0
0`00Oomoo`0>Ool4000<Ool400000`?oOomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0;Ool5000>
Ool3000BOol004ioo`030omoogoo02=oo`03001oogoo029oo`030omoogoo05Moo`00CWoo00<3ogoo
Ool08goo00<007ooOol08goo00<3ogooOol0EWoo001>Ool00`?oOomoo`0SOol00`00Oomoo`0SOol0
0`?oOomoo`1FOol004ioo`030omoogoo02=oo`03001oogoo02=oo`030omoogoo05Ioo`00CWoo00<3
ogooOol08goo00<007ooOol08goo00<3ogooOol0Bgoo0P000Woo0P001Goo001>Ool00`?oOomoo`0S
Ool00`00Oomoo`0SOol00`?oOomoo`1<Ool01000Oomoo`001Woo0008Oom600000`?o000000190000
0`?o000000140009Ool20007Ool000Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`030omoogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`030003ogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Moo`8000Moo`0027oo00<007ooOol067oo
00<007ooOol067oo00<007ooOol03Goo00<3ogooOol027oo00<007ooOol067oo00<007ooOol067oo
00<007ooOol027oo00<3ogooOol03Goo00<007ooOol067oo00<007ooOol067oo00<007ooOol01Woo
00@007ooOol000Ioo`00CWoo00<3ogooOol08goo00<007ooOol08goo00<3ogooOol0Bgoo0P000Woo
0P001Goo001>Ool00`?oOomoo`0SOol00`00Oomoo`0SOol00`?oOomoo`1FOol004ioo`030omoogoo
02=oo`03001oogoo02=oo`030omoogoo05Ioo`00CWoo00<3ogooOol08goo00<007ooOol08Woo00<3
ogooOol0Egoo001>Ool00`?oOomoo`0SOol00`00Oomoo`0ROol00`?oOomoo`1GOol004ioo`030omo
ogoo02=oo`03001oogoo029oo`030omoogoo05Moo`00Cgoo00<3ogooOol08Woo00<007ooOol08Goo
00<3ogooOol0F7oo001?Ool00`?oOomoo`0ROol00`00Oomoo`0QOol00`?oOomoo`1HOol004moo`03
0omoogoo029oo`03001oogoo025oo`030omoogoo05Qoo`00Cgoo00<3ogooOol08Woo00<007ooOol0
8Goo00<3ogooOol0F7oo001@Ool00`?oOomoo`0QOol00`00Oomoo`0POol00`?oOomoo`1IOol0051o
o`030omoogoo025oo`03001oogoo021oo`030omoogoo05Uoo`00DGoo00<3ogooOol087oo00<007oo
Ool087oo00<3ogooOol0FGoo001AOol00`?oOomoo`0POol00`00Oomoo`0OOol00`?oOomoo`1JOol0
059oo`030omoogoo01moo`03001oogoo01moo`030omoogoo05Yoo`00DWoo00<3ogooOol07goo00<0
07ooOol07Woo00<3ogooOol0Fgoo001COol00`?oOomoo`0NOol00`00Oomoo`0NOol00`?oOomoo`1K
Ool005=oo`030omoogoo01ioo`03001oogoo01eoo`030omoogoo05aoo`00E7oo00<3ogooOol07Goo
00<007ooOol077oo00<3ogooOol0GGoo001DOol00`?oOomoo`0MOol00`00Oomoo`0LOol00`?oOomo
o`1MOol005Eoo`030omoogoo01aoo`03001oogoo01]oo`030omoogoo05ioo`00EWoo00<3ogooOol0
0Woo10001Goo0P001Goo10001Goo00<007ooOol06Woo00<3ogooOol0Ggoo001GOol010?oOomoo`00
17oo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol06Woo00<3
ogooOol0Ggoo001HOol00`?oOol00004Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0I
Ool00`?oOomoo`1POol005Uoo`030ol007oo00=oo`03001oogoo00eoo`03001oogoo009oo`8001Qo
o`83of=oo`00FWoo00<3ogooOol00Woo00<007ooOol02Goo10001Goo00<007ooOol05Woo00<3ogoo
Ool0Hgoo001JOol00`000omoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`0EOol0
0`?oOomoo`1TOol005Yoo`03001oo`?o009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo
01Eoo`030omoogoo06Aoo`00Fgoo0P0000<3o`00Ool02goo1@0017oo00<007ooOol057oo00<3ogoo
Ool0IGoo001NOol20olDOol00`00Oomoo`0BOol20omXOol0061oo`83oa9oo`03001oogoo011oo`83
ofYoo`00HWoo0P?o47oo00<007ooOol03Woo0P?oK7oo001TOol20ol>Ool00`00Oomoo`0<Ool20om^
Ool006Ioo`83o`aoo`03001oogoo00Uoo`<3og1oo`00J7oo0`?o2Goo00<007ooOol01Woo0`?oLgoo
001[OolB0omfOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol006]oo`D000Aoo`03001oogoo07aoo`00
KGoo00<007ooOol017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eo
o`03001oogoo00Aoo`8007eoo`00KGoo00<007ooOol017oo00<007ooOol0O7oo001]Ool00`00Oomo
o`04Ool00`00Oomoo`1lOol006]oo`<000Ioo`03001oogoo07aoo`00KGoo00<007ooOol017oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol005]oo`D000Aoo`8000Eoo`@000Eoo`03001o
ogoo07aoo`00GGoo00<007ooOol017oo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool0O7oo001MOol00`00Oomoo`0?Ool00`00Oomoo`02Ool00`00Oomoo`1lOol005eoo`03001oogoo
00moo`03001oogoo009oo`8007eoo`00GGoo00<007ooOol02goo10001Goo00<007ooOol0O7oo001M
Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`1lOol005]oo`<000eoo`03001oogoo00Io
o`03001oogoo07aoo`00GGoo00<007ooOol02goo1@0017oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol006Yoo`D000Eoo`03001oogoo07aoo`00JWoo00D007ooOomoo`0000Eoo`03001o
ogoo07aoo`00Jgoo00<007ooOol01Woo00<007ooOol0O7oo001/Ool00`00Oomoo`05Ool2001mOol0
06eoo`03001oogoo08=oo`00KWoo00<007ooOol0PWoo001ZOol01@00Oomoogoo0000Q7oo001[Ool3
0025Ool00?=oo`00lgoo003cOol00?=oo`00UGoo0`002goo10001Goo0P001Goo1000?7oo002DOol0
1P00Oomoogoo001oo`H0009oo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009o
o`03001oogoo03Uoo`00Lgoo0P0000=oo`00000077oo00<007ooOol02goo00<007ooOol00Woo00<0
07ooOol03Goo00<007ooOol0>Goo001bOol00`00Oomoo`02000MOol00`00Oomoo`03Ool60002Ool0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0iOol0079oo`05001oogooOol0000MOol00`00
Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`09Ool4000lOol0079oo`05001oogooOol0000LOol5
000:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0mOol0079oo`05001oogooOol0000M
Ool00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0mOol0075oo`80009o
o`8002aoo`@000aoo`D003]oo`00lgoo003cOol00?=oo`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.45) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .7 r

.5 Mabswid

.3521 .49995 m

.35273 .48635 L

.35462 .47282 L

.35774 .45952 L

.36209 .44657 L

.3676 .43407 L

.37425 .42214 L

.38197 .41087 L

.3907 .40036 L

.40036 .3907 L

.41087 .38197 L

.42214 .37425 L

.43407 .3676 L

.44657 .36209 L

.45952 .35774 L

.47282 .35462 L

.48635 .35273 L

.5 .3521 L

.51365 .35273 L

.52718 .35462 L

.54048 .35774 L

.55343 .36209 L

.56593 .3676 L

.57786 .37425 L

.58913 .38197 L

.59964 .3907 L

.6093 .40036 L

.61803 .41087 L

.62575 .42214 L

.6324 .43407 L

.63791 .44657 L

.64226 .45952 L

.64538 .47282 L

.64727 .48635 L

.6479 .49995 L

s

.3521 .50005 m

.35273 .51365 L

.35462 .52718 L

.35774 .54048 L

.36209 .55343 L

.3676 .56593 L

.37425 .57786 L

.38197 .58913 L

.3907 .59964 L

.40036 .6093 L

.41087 .61803 L

.42214 .62575 L

.43407 .6324 L

.44657 .63791 L

.45952 .64226 L

.47282 .64538 L

.48635 .64727 L

.5 .6479 L

.51365 .64727 L

.52718 .64538 L

.54048 .64226 L

.55343 .63791 L

.56593 .6324 L

.57786 .62575 L

.58913 .61803 L

.59964 .6093 L

.6093 .59964 L

.61803 .58913 L

.62575 .57786 L

.6324 .56593 L

.63791 .55343 L

.64226 .54048 L

.64538 .52718 L

.64727 .51365 L

.6479 .50005 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00
Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00HWoo1P001Goo00<007ooOol017oo
0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo
07aoo`00Jgoo0`001Woo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001`Ool90oEjOol006eo
o`<3m@Aoo`03001oogoo009oo`83mGQoo`00Fgoo10001Goo0P000Woo1@?e0P001Goo00<007ooOol0
17oo1@?eLgoo001JOol00`00Oomoo`02Ool00`00Oomoo`02Ool200020oD2Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool20oEaOol005Yoo`03001oogoo009oo`03001oogoo00=oo`03
0oEoogoo00Moo`03001oogoo009oo`03001oogoo00]oo`030oEoogoo06ioo`00DWoo1P000Woo00<0
07ooOol00Woo00@007ooOomoo`83m@Yoo`03001oogoo009oo`8000eoo`83mFioo`00FWoo00<007oo
Ool00Woo00@007oo0oD3m@Qoo`@000Eoo`03001oogoo00ioo`83mFaoo`00FWoo00<007ooOol00Woo
00<000?eOol02Goo00<007ooOol01Woo00<007ooOol047oo00<3mGooOol0JGoo001JOol00`00Oomo
o`02Ool00`?eOomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`0AOol00`?eOomoo`1XOol005]oo`<0
00030oEoogoo00Yoo`D000Aoo`03001oogoo019oo`030oEoogoo06Moo`00GGoo00<3mGooOol057oo
00<007ooOol04goo00<3mGooOol0IWoo001LOol00`?eOomoo`0EOol00`00Oomoo`0DOol00`?eOomo
o`1UOol005]oo`030oEoogoo01Ioo`03001oogoo01Eoo`030oEoogoo06Aoo`00FWoo00<3mGooOol0
5goo00<007ooOol05Woo00<3mGooOol0Hgoo001IOol00`?eOomoo`0HOol00`00Oomoo`0GOol00`?e
Oomoo`1ROol005Uoo`030oEoogoo01Qoo`03001oogoo01Qoo`030oEoogoo065oo`00F7oo00<3mGoo
Ool06Goo00<007ooOol067oo00<3mGooOol0HGoo001HOol00`?eOomoo`0IOol00`00Oomoo`0IOol0
0`?eOomoo`1POol000Uoo`D000moo`D000Aoo`8000Eoo`@000moo`D000ioo`@000030oEoogoo009o
o`8000Eoo`@000eoo`03001oogoo00ioo`@000Eoo`8000030oEoogoo009oo`@000moo`D000ioo`D0
00Aoo`8000Eoo`@000ioo`D0015oo`002Goo00D007ooOomoo`00015oo`03001oogoo00Aoo`8000Ao
o`03001oogoo009oo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`030oEoogoo009o
o`8000Aoo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03001o
ogoo009oo`8000050oEoogooOol00004Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`04
Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool01@00Oomoogoo00004Goo000:Ool00`00Oomo
o`0BOol00`00Oomoo`0?Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool01P00Oomoogoo0oD000moo`03
001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Eoo`030oEoogoo00Eoo`03
001oogoo00ioo`03001oogoo011oo`03001oogoo00moo`03001oogoo00aoo`03001oogoo019oo`00
00=oo`000000100017oo00<007ooOol01Woo1P001Goo00<007ooOol03goo00<007ooOol00goo1P00
1Goo00<007ooOol01Goo1P000Woo00H007ooOomoo`?e000?Ool00`00Oomoo`0:Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`?eOomoo`05Ool00`00Oomoo`0>Ool00`00Oomoo`0@
Ool00`00Oomoo`0?Ool00`00Oomoo`0=Ool00`00Oomoo`0AOol000aoo`03001oogoo011oo`03001o
ogoo00]oo`@0015oo`03001oogoo00eoo`06001oogoo0oEoo`002goo10003Goo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol01Woo00<3mGooOol010004Goo00<007ooOol047oo00<007ooOol0
2goo10004Goo00<007ooOol047oo000=Ool00`00Oomoo`0?Ool00`00Oomoo`0;Ool00`00Oomoo`0B
Ool00`00Oomoo`0=Ool01P00Oomoo`?eOol000]oo`03001oogoo00ioo`03001oogoo00eoo`03001o
ogoo009oo`03001oogoo00Ioo`040oEoogoo000DOol00`00Oomoo`0@Ool00`00Oomoo`0;Ool00`00
Oomoo`0COol00`00Oomoo`0?Ool000Uoo`05001oogooOol0000?Ool3000=Ool00`00Oomoo`0@Ool3
000?Ool01P00Oomoo`?eOol000]oo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03
001oogoo00Ioo`040oEoogoo000BOol3000@Ool3000=Ool00`00Oomoo`0?Ool01@00Oomoogoo0000
4Goo000:Ool3000BOol00`00Oomoo`0;Ool5000@Ool00`00Oomoo`0>Ool010000oD0000037oo1@00
37oo00<007ooOol03Woo10002Woo00<3mGoo0000100047oo00<007ooOol047oo00<007ooOol02goo
1@003Woo0`004Woo001DOol00`?eOomoo`0MOol00`00Oomoo`0LOol00`?eOomoo`1MOol005Aoo`03
0oEoogoo01eoo`03001oogoo01aoo`030oEoogoo05eoo`00E7oo00<3mGooOol07Goo00<007ooOol0
77oo00<3mGooOol0GGoo001DOol00`?eOomoo`0MOol00`00Oomoo`0LOol00`?eOomoo`1MOol005Ao
o`030oEoogoo01eoo`03001oogoo01aoo`030oEoogoo059oo`80009oo`8000Eoo`00E7oo00<3mGoo
Ool07Goo00<007ooOol07Goo00<3mGooOol0DWoo00@007ooOol000Ioo`0027ooC00000<3m@000000
?@0000<3m@000000BP002Goo0P001goo0008Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`000oEoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`?eOomoo`02Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`07Ool20007Ool000Qoo`03001oogoo
01Qoo`03001oogoo01Qoo`03001oogoo01=oo`030oEoogoo009oo`03001oogoo01Qoo`03001oogoo
01Qoo`05001oogooOol3m@0FOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`06Ool01000
Oomoo`001Woo001DOol00`?eOomoo`0MOol00`00Oomoo`0LOol00`?eOomoo`1BOol20002Ool20005
Ool005Aoo`030oEoogoo01eoo`03001oogoo01aoo`030oEoogoo05eoo`00E7oo00<3mGooOol07Goo
00<007ooOol077oo00<3mGooOol0GGoo001DOol00`?eOomoo`0MOol00`00Oomoo`0LOol00`?eOomo
o`1MOol005Aoo`030oEoogoo01eoo`03001oogoo01aoo`030oEoogoo05eoo`00EGoo00<3mGooOol0
77oo00<007ooOol06goo00<3mGooOol0GWoo001EOol00`?eOomoo`0LOol00`00Oomoo`0KOol00`?e
Oomoo`1NOol005Eoo`030oEoogoo01aoo`03001oogoo01]oo`030oEoogoo05ioo`00EWoo00<3mGoo
Ool06goo00<007ooOol06Woo00<3mGooOol0Ggoo001FOol00`?eOomoo`0KOol00`00Oomoo`0JOol0
0`?eOomoo`1OOol005Moo`030oEoogoo01Yoo`03001oogoo01Uoo`030oEoogoo061oo`00Egoo00<3
mGooOol06Woo00<007ooOol06Goo00<3mGooOol0H7oo001HOol00`?eOomoo`0IOol00`00Oomoo`0I
Ool00`?eOomoo`1POol005Qoo`030oEoogoo01Uoo`03001oogoo01Qoo`030oEoogoo065oo`00FGoo
00<3mGooOol067oo00<007ooOol067oo00<3mGooOol0HGoo001JOol00`?eOomoo`0GOol00`00Oomo
o`0GOol00`?eOomoo`1ROol005Yoo`030oEoogoo01Moo`03001oogoo01Ioo`030oEoogoo06=oo`00
Fgoo00<3mGooOol05Woo00<007ooOol05Goo00<3mGooOol0I7oo001KOol00`?eOomoo`0FOol00`00
Oomoo`0EOol00`?eOomoo`1TOol005aoo`030oEoogoo01Eoo`03001oogoo01Aoo`030oEoogoo06Eo
o`00GGoo00<3mGooOol057oo00<007ooOol04goo00<3mGooOol0IWoo001KOol300000`?eOomoo`03
Ool20005Ool40005Ool00`00Oomoo`0BOol00`?eOomoo`1WOol005Yoo`03001oogoo009oo`030oEo
ogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo015oo`030oEoogoo06Qo
o`00FWoo00<007ooOol00Woo00<000?e0oD03Goo00<007ooOol00Woo00<007ooOol03goo0P?eJgoo
001JOol00`00Oomoo`02Ool00`00Oomoo`020oD;Ool00`00Oomoo`02Ool2000>Ool20oE]Ool005Yo
o`03001oogoo009oo`03001oogoo009oo`030oEoogoo00Aoo`@000Eoo`03001oogoo00aoo`030oEo
ogoo06eoo`00FWoo00<007ooOol00Woo00<007ooOol00goo0P?e17oo00<007ooOol01Woo00<007oo
Ool02Woo0P?eL7oo001JOol00`00Oomoo`02Ool00`00Oomoo`05Ool30oD00goo001oo`07Ool00`00
Oomoo`07Ool30oEbOol005]oo`@000]oo`<3m@<000Aoo`03001oogoo00Eoo`83mGEoo`00KGoo3`?e
Mgoo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001[Ool50004Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07ao
o`00KGoo00<007ooOol017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool2001mOol006eoo`03
001oogoo00Aoo`03001oogoo07aoo`00KGoo00<007ooOol017oo00<007ooOol0O7oo001[Ool30006
Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001KOol50004Ool20005Ool40005Ool00`00Oomoo`1lOol005eoo`03001oogoo00Aoo`80
00Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo07aoo`00GGoo00<007ooOol03goo00<0
07ooOol00Woo00<007ooOol0O7oo001MOol00`00Oomoo`0?Ool00`00Oomoo`02Ool2001mOol005eo
o`03001oogoo00]oo`@000Eoo`03001oogoo07aoo`00GGoo00<007ooOol02goo00<007ooOol01Woo
00<007ooOol0O7oo001KOol3000=Ool00`00Oomoo`06Ool00`00Oomoo`1lOol005eoo`03001oogoo
00]oo`D000Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001ZOol50005Ool00`00
Oomoo`1lOol006Yoo`05001oogooOol00005Ool00`00Oomoo`1lOol006]oo`03001oogoo00Ioo`03
001oogoo07aoo`00K7oo00<007ooOol01Goo0P00OGoo001]Ool00`00Oomoo`23Ool006ioo`03001o
ogoo089oo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo0`00QGoo003cOol00?=oo`00lgoo003cOol0
095oo`<000]oo`@000Eoo`8000Moo`<000=oo`@003Qoo`00T7oo00H007ooOomoo`00Ool60002Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool01@00Oomoogoo000017oo00<007ooOol0=Goo001c
Ool200000goo0000000HOol00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomo
o`06Ool00`00Oomoo`0eOol0079oo`03001oogoo008001Uoo`03001oogoo00=oo`H0009oo`03001o
ogoo009oo`03001oogoo00Qoo`H000Moo`03001oogoo03Eoo`00LWoo00D007ooOomoo`0001Uoo`03
001oogoo00]oo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0004Ool4000hOol0079oo`05
001oogooOol0000HOol5000:Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`0017oo00<0
07ooOol0>Goo001bOol01@00Oomoogoo00006Goo00<007ooOol02goo00<007ooOol00Woo00<007oo
Ool02Woo00<007oo000017oo00<007ooOol0>Goo001aOol20002Ool2000XOol4000>Ool20004Ool5
000gOol00?=oo`00lgoo003cOol00?=oo`00lgoo0000\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.4) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .4 r

.5 Mabswid

.3882 .49995 m

.38867 .48968 L

.3901 .47946 L

.39246 .4694 L

.39575 .45961 L

.39992 .45016 L

.40494 .44114 L

.41078 .43262 L

.41738 .42468 L

.42468 .41738 L

.43262 .41078 L

.44114 .40494 L

.45016 .39992 L

.45961 .39575 L

.4694 .39246 L

.47946 .3901 L

.48968 .38867 L

.5 .3882 L

.51032 .38867 L

.52054 .3901 L

.5306 .39246 L

.54039 .39575 L

.54984 .39992 L

.55886 .40494 L

.56738 .41078 L

.57532 .41738 L

.58262 .42468 L

.58922 .43262 L

.59506 .44114 L

.60008 .45016 L

.60425 .45961 L

.60754 .4694 L

.6099 .47946 L

.61133 .48968 L

.6118 .49995 L

s

.3882 .50005 m

.38867 .51032 L

.3901 .52054 L

.39246 .5306 L

.39575 .54039 L

.39992 .54984 L

.40494 .55886 L

.41078 .56738 L

.41738 .57532 L

.42468 .58262 L

.43262 .58922 L

.44114 .59506 L

.45016 .60008 L

.45961 .60425 L

.4694 .60754 L

.47946 .6099 L

.48968 .61133 L

.5 .6118 L

.51032 .61133 L

.52054 .6099 L

.5306 .60754 L

.54039 .60425 L

.54984 .60008 L

.55886 .59506 L

.56738 .58922 L

.57532 .58262 L

.58262 .57532 L

.58922 .56738 L

.59506 .55886 L

.60008 .54984 L

.60425 .54039 L

.60754 .5306 L

.6099 .52054 L

.61133 .51032 L

.6118 .50005 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00
Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00HWoo1P001Goo00<007ooOol017oo
0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo
07aoo`00Jgoo0`001Woo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00Fgoo10001Goo0P001Goo10001Goo00<007ooOol0O7oo001JOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo07aoo`00
DWoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00OGoo001JOol00`00
Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`1lOol005Yoo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo00Ioo`03001oogoo07aoo`00FWoo00<007ooOol00Woo00<007ooOol02Goo
00@007ooOomoo`X3k7Yoo`00Fgoo100037oo0P000P?/00<007ooOol00Woo00<007ooOol00Woo0P?/
N7oo001[Ool20n`7Ool00`00Oomoo`04Ool20nafOol006Uoo`83k0Uoo`03001oogoo00Ioo`83k7Ao
o`00Igoo0P?/2goo00<007ooOol027oo0P?/LWoo001UOol20n`=Ool00`00Oomoo`0:Ool20na`Ool0
06=oo`83k0moo`03001oogoo00aoo`83k6ioo`00HWoo00<3k7ooOol03goo00<007ooOol03Woo00<3
k7ooOol0Jgoo001ROol00`?/Oomoo`0?Ool00`00Oomoo`0>Ool00`?/Oomoo`1[Ool0065oo`030nao
ogoo011oo`03001oogoo00moo`030naoogoo06Yoo`002Goo1@003goo1@0017oo0P001Goo10003goo
1@003Woo10001Goo0P000Woo00<3k7ooOol010003Goo00<007ooOol03Woo0P0000<3k000Ool017oo
0P001Goo10003goo1@003Woo1@0017oo0P001Goo10003Woo1@004Goo0009Ool01@00Oomoogoo0000
4Goo00<007ooOol017oo0P0017oo00<007ooOol00Woo00<007ooOol03Woo00<007ooOol03Goo00<0
07ooOol00Woo00<007ooOol00Woo0P0000Eoo`?/Oomoo`0000Aoo`03001oogoo00Yoo`03001oogoo
00eoo`06001oogooOol3k00017oo0P0017oo00<007ooOol00Woo00<007ooOol03Woo00<007ooOol0
47oo00<007ooOol017oo0P0017oo00<007ooOol00Woo00<007ooOol02goo00D007ooOomoo`00015o
o`002Woo00<007ooOol04Woo00<007ooOol03goo00<007ooOol03Woo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol01Goo00<3k7ooOol01Goo00<007ooOol02Woo00<007ooOol03Goo00H007oo
Oomoo`?/000?Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0?Ool00`00Oomoo`0<Ool0
0`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Ioo`H000Eoo`03001oogoo00moo`03
001oogoo00=oo`H000Eoo`03001oogoo00Eoo`H0009oo`03001oogoo009oo`03001oogoo00Aoo`03
0naoogoo00Ioo`03001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`030naoogoo00eoo`03
001oogoo00ioo`03001oogoo011oo`03001oogoo00moo`03001oogoo00eoo`03001oogoo015oo`00
37oo00<007ooOol047oo00<007ooOol02goo10004Goo00<007ooOol03Goo00<007ooOol00Woo00<0
07ooOol00goo00<3k7ooOol00goo10003Goo00<007ooOol03Goo00<007ooOol00Woo00<000?/Ool0
2Goo10004Goo00<007ooOol047oo00<007ooOol02goo10004Goo00<007ooOol047oo000=Ool00`00
Oomoo`0?Ool00`00Oomoo`0;Ool00`00Oomoo`0BOol00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00
Oomoo`03Ool00`?/Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00
0naoo`09Ool00`00Oomoo`0BOol00`00Oomoo`0@Ool00`00Oomoo`0;Ool00`00Oomoo`0COol00`00
Oomoo`0?Ool000Uoo`05001oogooOol0000?Ool3000=Ool00`00Oomoo`0@Ool3000?Ool00`00Oomo
o`02Ool00`00Oomoo`03Ool00`?/Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`000naoo`09Ool00`00Oomoo`0@Ool3000@Ool3000=Ool00`00Oomoo`0?Ool01@00Oomo
ogoo00004Goo000:Ool3000BOol00`00Oomoo`0;Ool5000@Ool00`00Oomoo`0>Ool40005Ool00`?/
Oomoo`04Ool5000<Ool00`00Oomoo`0>Ool40002Ool00`?/Oomoo`07Ool5000@Ool00`00Oomoo`0@
Ool00`00Oomoo`0;Ool5000>Ool3000BOol005aoo`030naoogoo01Eoo`03001oogoo01Aoo`030nao
ogoo06Eoo`00G7oo00<3k7ooOol05Goo00<007ooOol057oo00<3k7ooOol0IGoo001LOol00`?/Oomo
o`0EOol00`00Oomoo`0DOol00`?/Oomoo`1UOol005aoo`030naoogoo01Eoo`03001oogoo01Eoo`03
0naoogoo06Aoo`00G7oo00<3k7ooOol05Goo00<007ooOol05Goo00<3k7ooOol0FGoo0P000Woo0P00
1Goo001LOol00`?/Oomoo`0EOol00`00Oomoo`0EOol00`?/Oomoo`1JOol01000Oomoo`001Woo0008
OomD00000`?/0000000]00000`?/0000001B0009Ool20007Ool000Qoo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`06001oogoo0naoo`001Goo
00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo
00<007ooOol00goo00<007ooOol00Woo00@007ooOol3k09oo`03001oogoo009oo`03001oogoo009o
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009o
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009o
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Moo`8000Moo`0027oo
00<007ooOol067oo00<007ooOol067oo00<007ooOol067oo00@007ooOol3k1Moo`03001oogoo01Eo
o`040naoogoo000JOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`06Ool01000Oomoo`00
1Woo001LOol00`?/Oomoo`0EOol00`00Oomoo`0EOol00`?/Oomoo`1IOol20002Ool20005Ool005ao
o`030naoogoo01Eoo`03001oogoo01Aoo`030naoogoo06Eoo`00G7oo00<3k7ooOol05Goo00<007oo
Ool057oo00<3k7ooOol0IGoo001LOol00`?/Oomoo`0EOol00`00Oomoo`0DOol00`?/Oomoo`1UOol0
05aoo`030naoogoo01Eoo`03001oogoo01Aoo`030naoogoo06Eoo`00GGoo00<3k7ooOol057oo00<0
07ooOol04goo00<3k7ooOol0IWoo001MOol00`?/Oomoo`0DOol00`00Oomoo`0COol00`?/Oomoo`1V
Ool005ioo`030naoogoo01=oo`03001oogoo019oo`030naoogoo06Moo`00GWoo00<3k7ooOol04goo
00<007ooOol04Woo00<3k7ooOol0Igoo001OOol00`?/Oomoo`0BOol00`00Oomoo`0AOol00`?/Oomo
o`1XOol005moo`030naoogoo019oo`03001oogoo015oo`030naoogoo06Qoo`00H7oo00<3k7ooOol0
4Goo00<007ooOol047oo00<3k7ooOol0JGoo001POol00`?/Oomoo`0AOol00`00Oomoo`0@Ool00`?/
Oomoo`1YOol0065oo`83k15oo`03001oogoo00ioo`83k6aoo`00Hgoo00<3k7ooOol03Woo00<007oo
Ool03Goo00<3k7ooOol0K7oo001SOol00`?/Oomoo`0>Ool00`00Oomoo`0=Ool00`?/Oomoo`1/Ool0
06Aoo`83k0ioo`03001oogoo00]oo`83k6moo`00IWoo00<3k7ooOol02goo00<007ooOol02Woo00<3
k7ooOol0Kgoo001WOol00`?/Oomoo`0:Ool00`00Oomoo`09Ool00`?/Oomoo`1`Ool006Qoo`83k0Yo
o`03001oogoo00Moo`83k7=oo`00JWoo10?/1Woo00<007ooOol00goo10?/MGoo001KOol40005Ool2
0005Ool3000<0naiOol005Yoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009o
o`03001oogoo009oo`03001oogoo07aoo`00FWoo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol0O7oo001JOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool2
001mOol005Yoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo07aoo`00FWoo00<0
07ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0O7oo001JOol00`00Oomoo`02
Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`1lOol005]oo`@000aoo`D000Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001[Ool50004Ool00`00Oomoo`1lOol006eoo`03
001oogoo00Aoo`03001oogoo07aoo`00KGoo00<007ooOol017oo00<007ooOol0O7oo001]Ool00`00
Oomoo`04Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KGoo00<007ooOol017oo
00<007ooOol0O7oo001[Ool30006Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001KOol50004Ool20005Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo07ao
o`00GGoo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0O7oo001MOol00`00Oomoo`0?Ool0
0`00Oomoo`02Ool2001mOol005eoo`03001oogoo00]oo`@000Eoo`03001oogoo07aoo`00GGoo00<0
07ooOol02goo00<007ooOol01Woo00<007ooOol0O7oo001KOol3000=Ool00`00Oomoo`06Ool00`00
Oomoo`1lOol005eoo`03001oogoo00]oo`D000Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001ZOol50005Ool00`00Oomoo`1lOol006Yoo`05001oogooOol00005Ool00`00Oomoo`1l
Ool006]oo`03001oogoo00Ioo`03001oogoo07aoo`00K7oo00<007ooOol01Goo0P00OGoo001]Ool0
0`00Oomoo`23Ool006ioo`03001oogoo089oo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo0`00QGoo
003cOol00?=oo`00lgoo003cOol009Eoo`<000]oo`@000Eoo`8000Moo`<003]oo`00U7oo00H007oo
Oomoo`00Ool60002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`0jOol007=o
o`800003Ool0000001aoo`03001oogoo00]oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo
03Yoo`00LWoo00<007ooOol00P007Goo00<007ooOol00goo1P000Woo00<007ooOol00Woo00<007oo
Ool027oo1P00>goo001bOol01@00Oomoogoo00007Goo00<007ooOol02goo00<007ooOol00Woo00<0
07ooOol02Goo00@007ooOol003aoo`00LWoo00D007ooOomoo`0001aoo`D000Yoo`03001oogoo009o
o`03001oogoo00Uoo`04001oogoo000lOol0079oo`05001oogooOol0000MOol00`00Oomoo`0;Ool0
0`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Ool0000lOol0075oo`80009oo`8002aoo`@000ioo`80
03aoo`00lgoo003cOol00?=oo`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.35) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .1 r

.5 Mabswid

.4441 .49997 m

.44434 .49484 L

.44505 .48973 L

.44623 .4847 L

.44787 .47981 L

.44996 .47508 L

.45247 .47057 L

.45539 .46631 L

.45869 .46234 L

.46234 .45869 L

.46631 .45539 L

.47057 .45247 L

.47508 .44996 L

.47981 .44787 L

.4847 .44623 L

.48973 .44505 L

.49484 .44434 L

.5 .4441 L

.50516 .44434 L

.51027 .44505 L

.5153 .44623 L

.52019 .44787 L

.52492 .44996 L

.52943 .45247 L

.53369 .45539 L

.53766 .45869 L

.54131 .46234 L

.54461 .46631 L

.54753 .47057 L

.55004 .47508 L

.55213 .47981 L

.55377 .4847 L

.55495 .48973 L

.55566 .49484 L

.5559 .49997 L

s

.4441 .50003 m

.44434 .50516 L

.44505 .51027 L

.44623 .5153 L

.44787 .52019 L

.44996 .52492 L

.45247 .52943 L

.45539 .53369 L

.45869 .53766 L

.46234 .54131 L

.46631 .54461 L

.47057 .54753 L

.47508 .55004 L

.47981 .55213 L

.4847 .55377 L

.48973 .55495 L

.49484 .55566 L

.5 .5559 L

.50516 .55566 L

.51027 .55495 L

.5153 .55377 L

.52019 .55213 L

.52492 .55004 L

.52943 .54753 L

.53369 .54461 L

.53766 .54131 L

.54131 .53766 L

.54461 .53369 L

.54753 .52943 L

.55004 .52492 L

.55213 .52019 L

.55377 .5153 L

.55495 .51027 L

.55566 .50516 L

.5559 .50003 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00
Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00HWoo1P001Goo00<007ooOol017oo
0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo
07aoo`00Jgoo0`001Woo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00Fgoo10001Goo0P001Goo10001Goo00<007ooOol0O7oo001JOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo07aoo`00
DWoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00OGoo001JOol00`00
Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`1lOol005Yoo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo00Ioo`03001oogoo07aoo`00FWoo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol01Woo00<007ooOol0O7oo001KOol4000<Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo0009Ool5000?Ool50004Ool20005Ool4000?Ool5000>Ool40005Ool20005Ool4000=
Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool5000>Ool50004Ool20005Ool4000>Ool5000A
Ool000Uoo`05001oogooOol0000AOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomo
o`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool0
0`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool0
0`00Oomoo`0;Ool01@00Oomoogoo00004Goo000:Ool00`00Oomoo`0BOol00`00Oomoo`0?Ool00`00
Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool60n8=
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0?
Ool00`00Oomoo`0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Ioo`H000Eo
o`03001oogoo00moo`03001oogoo00=oo`H000Eoo`03001oogoo00Eoo`H0009oo`03001oogoo009o
o`03001oogoo00eoo`03001oogoo00Aoo`<3hP=oo`03001oogoo00<3hPYoo`03001oogoo009oo`03
001oogoo00eoo`03001oogoo00ioo`03001oogoo011oo`03001oogoo00moo`03001oogoo00eoo`03
001oogoo015oo`0037oo00<007ooOol047oo00<007ooOol02goo10004Goo00<007ooOol03Goo00<0
07ooOol00Woo00<007ooOol02Goo10001Woo00<3hWooOol017oo00<007ooOol00goo00<3hWooOol0
1goo00<007ooOol00Woo00<007ooOol02Goo10004Goo00<007ooOol047oo00<007ooOol02goo1000
4Goo00<007ooOol047oo000=Ool00`00Oomoo`0?Ool00`00Oomoo`0;Ool00`00Oomoo`0BOol00`00
Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`?ROomoo`05Ool00`00
Oomoo`04Ool20n87Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0BOol00`00Oomoo`0@
Ool00`00Oomoo`0;Ool00`00Oomoo`0COol00`00Oomoo`0?Ool000Uoo`05001oogooOol0000?Ool3
000=Ool00`00Oomoo`0@Ool3000?Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`05Ool0
0`?ROomoo`06Ool00`00Oomoo`06Ool00`?ROomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`09Ool0
0`00Oomoo`0@Ool3000@Ool3000=Ool00`00Oomoo`0?Ool01@00Oomoogoo00004Goo000:Ool3000B
Ool00`00Oomoo`0;Ool5000@Ool00`00Oomoo`0>Ool4000<Ool50002Ool00`?ROomoo`07Ool00`00
Oomoo`06Ool00`?ROomoo`05Ool4000<Ool5000@Ool00`00Oomoo`0@Ool00`00Oomoo`0;Ool5000>
Ool3000BOol006Uoo`030n9oogoo00Qoo`03001oogoo00Moo`030n9oogoo079oo`00JGoo00<3hWoo
Ool027oo00<007ooOol01goo00<3hWooOol0LWoo001XOol00`?ROomoo`09Ool00`00Oomoo`08Ool0
0`?ROomoo`1aOol006Qoo`030n9oogoo00Uoo`03001oogoo00Qoo`030n9oogoo075oo`00J7oo00<3
hWooOol02Goo00<007ooOol02Goo00<3hWooOol0IGoo0P000Woo0P001Goo001XOol00`?ROomoo`09
Ool00`00Oomoo`09Ool00`?ROomoo`1VOol01000Oomoo`001Woo0008OomP00000`?R0000000E0000
0`?R0000001N0009Ool20007Ool000Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`06001oogooOol3
hP0017oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007oo0n800goo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol01goo0P001goo0008Ool00`00Oomoo`0HOol00`00Oomo
o`0HOol00`00Oomoo`0HOol00`00Oomoo`0<Ool00`?ROomoo`09Ool00`00Oomoo`09Ool00`?ROomo
o`0<Ool00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`06Ool01000Oomo
o`001Woo001XOol00`?ROomoo`09Ool00`00Oomoo`08Ool00`?ROomoo`1VOol20002Ool20005Ool0
06Qoo`030n9oogoo00Uoo`03001oogoo00Qoo`030n9oogoo075oo`00J7oo00<3hWooOol02Goo00<0
07ooOol027oo00<3hWooOol0LGoo001YOol00`?ROomoo`08Ool00`00Oomoo`07Ool00`?ROomoo`1b
Ool006Uoo`83hPUoo`03001oogoo00Ioo`83hWAoo`00Jgoo00<3hWooOol01Woo00<007ooOol01Woo
00<3hWooOol0Lgoo001/Ool00`?ROomoo`05Ool00`00Oomoo`05Ool00`?ROomoo`1dOol006aoo`83
hPIoo`03001oogoo00=oo`83hWMoo`00KWoo0P?R17oo00@007ooOomoo`83hWUoo`00L7oo20?RNgoo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00Fgoo10001Goo0P001Goo10001Goo00<007ooOol0O7oo001JOol00`00Oomoo`02Ool0
0`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1lOol005Yoo`03
001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo07aoo`00FWoo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol00Woo0P00OGoo001JOol00`00Oomoo`02Ool00`00Oomoo`09
Ool40005Ool00`00Oomoo`1lOol005Yoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Io
o`03001oogoo07aoo`00FWoo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007oo
Ool0O7oo001KOol4000<Ool50004Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001o
ogoo00Aoo`03001oogoo07aoo`00KGoo00<007ooOol017oo0P00OGoo001]Ool00`00Oomoo`04Ool0
0`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00Jgoo0`001Woo00<007ooOol0
O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo
1@0017oo0P001Goo10001Goo00<007ooOol0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03
001oogoo07aoo`00GGoo00<007ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;
Ool40005Ool00`00Oomoo`1lOol005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07ao
o`00Fgoo0`003Goo00<007ooOol01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00JWoo1@001Goo00<007ooOol0O7oo001Z
Ool01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool00`00Oomoo`06Ool00`00Oomoo`1lOol0
06aoo`03001oogoo00Eoo`8007eoo`00KGoo00<007ooOol0Pgoo001^Ool00`00Oomoo`22Ool006Yo
o`05001oogooOol00024Ool006]oo`<008Eoo`00lgoo003cOol00?=oo`00lgoo002AOol3000;Ool4
0005Ool20005Ool30005Ool4000hOol0091oo`06001oogooOol007oo1P000Woo00<007ooOol00Woo
00<007ooOol00Woo0P0017oo00D007ooOomoo`0000=oo`03001oogoo009oo`03001oogoo03Eoo`00
Lgoo0P0000=oo`00000067oo00<007ooOol02goo00<007ooOol00Woo00<007ooOol037oo00<007oo
Ool01Woo00<007ooOol0=Goo001bOol00`00Oomoo`02000IOol00`00Oomoo`03Ool60002Ool00`00
Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`0eOol0079oo`05001oogooOol0
000IOol00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool20005Ool4000hOol0079oo`05
001oogooOol0000HOol5000:Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`02Ool00`00
Oomoo`0iOol0079oo`05001oogooOol0000IOol00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomo
o`08Ool01@00Oomoogoo000017oo00<007ooOol0>Goo001aOol20002Ool2000XOol4000<Ool30005
Ool5000gOol00?=oo`00lgoo003cOol00?=oo`00lgoo0000\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.3) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->-1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007oo
Ool0O7oo001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00DWoo1P001Goo00<0
07ooOol03goo00<007ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1l
Ool005eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007oo
Ool01Woo00<007ooOol0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00
Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00HWoo1P001Goo00<007ooOol017oo
0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo
07aoo`00Jgoo0`001Woo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00Fgoo10001Goo0P001Goo10001Goo00<007ooOol0O7oo001JOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`1lOol005Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo07aoo`00
DWoo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00OGoo001JOol00`00
Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`1lOol005Yoo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo00Ioo`03001oogoo07aoo`00FWoo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol01Woo00<007ooOol0O7oo001KOol4000<Ool50004Ool00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo0009Ool5000?Ool50004Ool20005Ool4000?Ool5000>Ool40005Ool20005Ool4000=
Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool5000>Ool50004Ool20005Ool4000>Ool5000A
Ool000Uoo`05001oogooOol0000AOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomo
o`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool0
0`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool0
0`00Oomoo`0;Ool01@00Oomoogoo00004Goo000:Ool00`00Oomoo`0BOol00`00Oomoo`0?Ool00`00
Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00
Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00
Oomoo`0?Ool00`00Oomoo`0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Io
o`H000Eoo`03001oogoo00moo`03001oogoo00=oo`H000Eoo`03001oogoo00Eoo`H0009oo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03001o
ogoo00eoo`03001oogoo00ioo`03001oogoo011oo`03001oogoo00moo`03001oogoo00eoo`03001o
ogoo015oo`0037oo00<007ooOol047oo00<007ooOol02goo10004Goo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol02Goo10003Goo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo
10004Goo00<007ooOol047oo00<007ooOol02goo10004Goo00<007ooOol047oo000=Ool00`00Oomo
o`0?Ool00`00Oomoo`0;Ool00`00Oomoo`0BOol00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomo
o`09Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomo
o`0BOol00`00Oomoo`0@Ool00`00Oomoo`0;Ool00`00Oomoo`0COol00`00Oomoo`0?Ool000Uoo`05
001oogooOol0000?Ool3000=Ool00`00Oomoo`0@Ool3000?Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0@
Ool3000@Ool3000=Ool00`00Oomoo`0?Ool01@00Oomoogoo00004Goo000:Ool3000BOol00`00Oomo
o`0;Ool5000@Ool00`00Oomoo`0>Ool4000<Ool5000<Ool00`00Oomoo`0>Ool4000<Ool5000@Ool0
0`00Oomoo`0@Ool00`00Oomoo`0;Ool5000>Ool3000BOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0LGoo
0P000Woo0P001Goo001dOol00`00Oomoo`1bOol01000Oomoo`001Woo0008OooI0009Ool20007Ool0
00Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo
00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo
00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo
00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo
00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
00=oo`03001oogoo00Moo`8000Moo`0027oo00<007ooOol067oo00<007ooOol067oo00<007ooOol0
67oo00<007ooOol067oo00<007ooOol067oo00<007ooOol067oo00<007ooOol067oo00<007ooOol0
67oo00<007ooOol01Woo00@007ooOol000Ioo`00M7oo00<007ooOol0LGoo0P000Woo0P001Goo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo10001Goo0P001Goo10001Goo
00<007ooOol0O7oo001JOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool00`00Oomoo`1lOol005Yoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo
009oo`03001oogoo07aoo`00FWoo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00
OGoo001JOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`1lOol005Yoo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo07aoo`00FWoo00<007ooOol00Woo
00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0O7oo001KOol4000<Ool50004Ool00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00Jgoo1@0017oo00<007ooOol0O7oo001]Ool00`00
Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KGoo00<007oo
Ool017oo0P00OGoo001]Ool00`00Oomoo`04Ool00`00Oomoo`1lOol006eoo`03001oogoo00Aoo`03
001oogoo07aoo`00Jgoo0`001Woo00<007ooOol0O7oo001]Ool00`00Oomoo`04Ool00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<0
07ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00Fgoo1@0017oo0P001Goo10001Goo00<007ooOol0O7oo
001MOol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1lOol0
05eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo07aoo`00GGoo00<007ooOol03goo00<0
07ooOol00Woo0P00OGoo001MOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`1lOol005eoo`03001o
ogoo00]oo`03001oogoo00Ioo`03001oogoo07aoo`00Fgoo0`003Goo00<007ooOol01Woo00<007oo
Ool0O7oo001MOol00`00Oomoo`0;Ool50004Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001d
Ool00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomo
o`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00JWoo1@001Goo00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo
001[Ool00`00Oomoo`06Ool00`00Oomoo`1lOol006aoo`03001oogoo00Eoo`8007eoo`00KGoo00<0
07ooOol0Pgoo001^Ool00`00Oomoo`22Ool006Yoo`05001oogooOol00024Ool006]oo`<008Eoo`00
lgoo003cOol00?=oo`00lgoo002EOol3000;Ool40005Ool20005Ool3000mOol009Aoo`06001oogoo
Ool007oo1P000Woo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00D007ooOomoo`0003aoo`00
Lgoo0P0000=oo`00000077oo00<007ooOol02goo00<007ooOol00Woo00<007ooOol037oo00<007oo
Ool0>Woo001bOol00`00Oomoo`02000MOol00`00Oomoo`03Ool60002Ool00`00Oomoo`02Ool00`00
Oomoo`0<Ool00`00Oomoo`0jOol0079oo`05001oogooOol0000MOol00`00Oomoo`0;Ool00`00Oomo
o`02Ool00`00Oomoo`0:Ool2000mOol0079oo`05001oogooOol0000LOol5000:Ool00`00Oomoo`02
Ool00`00Oomoo`0<Ool00`00Oomoo`0jOol0079oo`05001oogooOol0000MOol00`00Oomoo`0;Ool0
0`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo0000?7oo001aOol20002Ool2000/Ool4000<
Ool3000mOol00?=oo`00lgoo003cOol00?=oo`00lgoo0000\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  "The solution of this quadratic equation in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " yields the final representation of the solution of Tang's equation to be"
}], "Text",
  Evaluatable->False,
  CellTags->"solution of Tang's equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol11 = Solve[sol1\[LeftDoubleBracket]1\[RightDoubleBracket], u]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{u \[Rule] \(-\@\(\(-2\)\ k\ t - x\^2 - 2\ C[1]\)\)}, {
        u \[Rule] \@\(\(-2\)\ k\ t - x\^2 - 2\ C[1]\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "containing the parameter ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " of the original equation and one constant of integration ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1]", "MmaText"],
  ". The graphical representation of the second solution for parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k = \(-2\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`C[1] = 1/2\)]],
  " gives us the impression that the solution has a smooth behavior:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[
      \(u /. sol11\[LeftDoubleBracket]2\[RightDoubleBracket]\) /. {
          k \[Rule] \(-2\), C[1] \[Rule] 1\/2}, {x, 0, 2}, {t, 2, 4}, 
      ColorFunction \[Rule] Hue, Axes \[Rule] True, 
      AxesLabel \[Rule] {"\<x\>", "\<t\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.480769 -0.942308 0.480769 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -9 -9 ]
[.25962 -0.0125 9 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -18 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -18 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(2)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2.5)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(3)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(3.5)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(4)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .4 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 1 r
.01923 .0543 m
.08791 .05676 L
.15659 .06412 L
.22527 .07638 L
.274 .08791 L
.29396 .09355 L
.36264 .11563 L
.43132 .14261 L
.46285 .15659 L
.5 .1745 L
.56868 .21129 L
.59268 .22527 L
.63736 .25299 L
.69812 .29396 L
.70604 .2996 L
.77473 .35111 L
.78928 .36264 L
.84341 .40752 L
.87073 .43132 L
.91209 .46885 L
.945 .5 L
.98077 .53507 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .0543 m
.08791 .05676 L
.15659 .06412 L
.22527 .07638 L
.274 .08791 L
.29396 .09355 L
.36264 .11563 L
.43132 .14261 L
.46285 .15659 L
.5 .1745 L
.56868 .21129 L
.59268 .22527 L
.63736 .25299 L
.69812 .29396 L
.70604 .2996 L
.77473 .35111 L
.78928 .36264 L
.84341 .40752 L
.87073 .43132 L
.91209 .46885 L
.945 .5 L
.98077 .53507 L
s
0 .4 1 r
.01923 .19198 m
.08791 .19443 L
.15659 .20179 L
.22527 .21406 L
.27283 .22527 L
.29396 .23123 L
.36264 .2533 L
.43132 .28028 L
.46217 .29396 L
.5 .31217 L
.56868 .34897 L
.59215 .36264 L
.63736 .39066 L
.69768 .43132 L
.70604 .43727 L
.77473 .48878 L
.78889 .5 L
.84341 .5452 L
.87038 .56868 L
.91209 .60652 L
.94467 .63736 L
.98077 .67275 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .19198 m
.08791 .19443 L
.15659 .20179 L
.22527 .21406 L
.27283 .22527 L
.29396 .23123 L
.36264 .2533 L
.43132 .28028 L
.46217 .29396 L
.5 .31217 L
.56868 .34897 L
.59215 .36264 L
.63736 .39066 L
.69768 .43132 L
.70604 .43727 L
.77473 .48878 L
.78889 .5 L
.84341 .5452 L
.87038 .56868 L
.91209 .60652 L
.94467 .63736 L
.98077 .67275 L
s
.2 0 1 r
.01923 .33969 m
.08791 .34215 L
.15659 .34951 L
.22527 .36177 L
.2294 .36264 L
.29396 .37894 L
.36264 .40102 L
.43132 .428 L
.43903 .43132 L
.5 .45989 L
.56868 .49668 L
.57447 .5 L
.63736 .53838 L
.68286 .56868 L
.70604 .58498 L
.77473 .6365 L
.77583 .63736 L
.84341 .69291 L
.8586 .70604 L
.91209 .75423 L
.93387 .77473 L
.98077 .82046 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .33969 m
.08791 .34215 L
.15659 .34951 L
.22527 .36177 L
.2294 .36264 L
.29396 .37894 L
.36264 .40102 L
.43132 .428 L
.43903 .43132 L
.5 .45989 L
.56868 .49668 L
.57447 .5 L
.63736 .53838 L
.68286 .56868 L
.70604 .58498 L
.77473 .6365 L
.77583 .63736 L
.84341 .69291 L
.8586 .70604 L
.91209 .75423 L
.93387 .77473 L
.98077 .82046 L
s
.8 0 1 r
.01923 .49745 m
.08791 .4999 L
.0893 .5 L
.15659 .50726 L
.22527 .51952 L
.29396 .53669 L
.36264 .55877 L
.3895 .56868 L
.43132 .58575 L
.5 .61764 L
.53801 .63736 L
.56868 .65443 L
.63736 .69613 L
.65262 .70604 L
.70604 .74274 L
.74948 .77473 L
.77473 .79425 L
.8349 .84341 L
.84341 .85067 L
.91209 .91199 L
.9122 .91209 L
.98077 .97822 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .49745 m
.08791 .4999 L
.0893 .5 L
.15659 .50726 L
.22527 .51952 L
.29396 .53669 L
.36264 .55877 L
.3895 .56868 L
.43132 .58575 L
.5 .61764 L
.53801 .63736 L
.56868 .65443 L
.63736 .69613 L
.65262 .70604 L
.70604 .74274 L
.74948 .77473 L
.77473 .79425 L
.8349 .84341 L
.84341 .85067 L
.91209 .91199 L
.9122 .91209 L
.98077 .97822 L
s
1 0 .6 r
.01923 .66524 m
.08791 .66769 L
.15659 .67505 L
.22527 .68732 L
.29396 .70449 L
.29943 .70604 L
.36264 .72656 L
.43132 .75354 L
.47817 .77473 L
.5 .78543 L
.56868 .82223 L
.60462 .84341 L
.63736 .86393 L
.70604 .91053 L
.70822 .91209 L
.77473 .96204 L
.79821 .98077 L
.01923 .98077 L
F
0 g
.01923 .66524 m
.08791 .66769 L
.15659 .67505 L
.22527 .68732 L
.29396 .70449 L
.29943 .70604 L
.36264 .72656 L
.43132 .75354 L
.47817 .77473 L
.5 .78543 L
.56868 .82223 L
.60462 .84341 L
.63736 .86393 L
.70604 .91053 L
.70822 .91209 L
.77473 .96204 L
.79821 .98077 L
s
1 0 0 r
.01923 .84307 m
.04455 .84341 L
.08791 .84553 L
.15659 .85288 L
.22527 .86515 L
.29396 .88232 L
.36264 .9044 L
.38367 .91209 L
.43132 .93138 L
.5 .96326 L
.53388 .98077 L
.01923 .98077 L
F
0 g
.01923 .84307 m
.04455 .84341 L
.08791 .84553 L
.15659 .85288 L
.22527 .86515 L
.29396 .88232 L
.36264 .9044 L
.38367 .91209 L
.43132 .93138 L
.5 .96326 L
.53388 .98077 L
s
.2 1 0 r
.98077 .40744 m
.93485 .36264 L
.91209 .34121 L
.85967 .29396 L
.84341 .27989 L
.77702 .22527 L
.77473 .22347 L
.70604 .17196 L
.68422 .15659 L
.63736 .12535 L
.5761 .08791 L
.56868 .08366 L
.5 .04686 L
.44118 .01923 L
.98077 .01923 L
F
0 g
.98077 .40744 m
.93485 .36264 L
.91209 .34121 L
.85967 .29396 L
.84341 .27989 L
.77702 .22527 L
.77473 .22347 L
.70604 .17196 L
.68422 .15659 L
.63736 .12535 L
.5761 .08791 L
.56868 .08366 L
.5 .04686 L
.44118 .01923 L
s
.8 1 0 r
.98077 .28984 m
.91387 .22527 L
.91209 .22361 L
.84341 .16229 L
.83674 .15659 L
.77473 .10587 L
.75154 .08791 L
.70604 .05436 L
.65499 .01923 L
.98077 .01923 L
F
0 g
.98077 .28984 m
.91387 .22527 L
.91209 .22361 L
.84341 .16229 L
.83674 .15659 L
.77473 .10587 L
.75154 .08791 L
.70604 .05436 L
.65499 .01923 L
s
1 .6 0 r
.98077 .18229 m
.95468 .15659 L
.91209 .11606 L
.88127 .08791 L
.84341 .05473 L
.80092 .01923 L
.98077 .01923 L
F
0 g
.98077 .18229 m
.95468 .15659 L
.91209 .11606 L
.88127 .08791 L
.84341 .05473 L
.80092 .01923 L
s
1 0 0 r
.98077 .08477 m
.91283 .01923 L
.98077 .01923 L
F
0 g
.98077 .08477 m
.91283 .01923 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{213, 213},
  ImageMargins->{{71.3125, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004:00012Q000`40O003h00Oogoo2goo003oOol;
Ool00?moo`]oo`006goo1000:Goo10001Goo0P001Goo1000:Woo1@00:7oo1@0017oo0P001Goo1000
:7oo1@005Woo000JOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`02Ool00`00Oomoo`02
Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0YOol00`00Oomoo`0ZOol00`00Oomoo`04Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`0UOol01@00Oomoogoo00005Woo000JOol00`00Oomoo`02Ool0
0`00Oomoo`0UOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0YOol00`00Oomoo`0ZOol0
0`00Oomoo`0?Ool00`00Oomoo`0VOol00`00Oomoo`0GOol001Yoo`03001oogoo009oo`03001oogoo
02Eoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo02Uoo`03001oogoo02Yoo`03001oogoo
00moo`03001oogoo02Moo`03001oogoo01Ioo`006Woo00<007ooOol00Woo00<007ooOol09Goo00<0
07ooOol00Woo00<007ooOol02Goo1000;7oo00<007ooOol0:Woo00<007ooOol02goo1000:goo00<0
07ooOol05Goo000JOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`0]Ool00`00Oomoo`0ZOol00`00Oomoo`0;Ool00`00Oomoo`0]Ool00`00Oomoo`0D
Ool001Yoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo009oo`03001oogoo00Uoo`03001o
ogoo02]oo`<002Yoo`<000eoo`03001oogoo02Uoo`05001oogooOol0000FOol001]oo`@002Uoo`@0
00aoo`D002]oo`03001oogoo02Yoo`03001oogoo00]oo`D002Qoo`<001Moo`00ogoo2goo003oOol;
Ool00?moo`]oo`00ogoo0Goo0P000Woo0P0017oo003oOol2Ool01000Oomoo`001Goo003oOol3Ool2
0006Ool001Uooml000Yoo`8000Ioo`003goo1@001Goo00D007ooOomoo`0000Yoo`03001oogoo00Mo
o`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Qo
o`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Qo
o`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Mo
o`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Mo
o`04001oogoo0005Ool000moo`05001oogooOol00005Ool00`00Oomoo`3KOol00`00Oomoo`06Ool2
0002Ool20004Ool0011oo`03001oogoo00Ioo`03001oogoo0=]oo`03001oogoo011oo`004Goo00<0
07ooOol01Goo0P00H7oo0P00;Goo00<007ooOol07Woo00<007ooOol05Goo00<007ooOol03goo0`00
4Woo000BOol00`00Oomoo`04Ool01000OomoogooH0?/0P0000DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n0011_P
5n0Gh1OP0P00021Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh0005gi000<007`0O0002g`01Goo00<007ooOol047oo000COol00`00Oomoo`03
Ool0IP00Oomoogoo0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k080001>5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn0007iP0gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT0017iPOT1n@00037`01Goo
00<007ooOol047oo000?Ool01@00Oomoogoo00001Goo00@007ooOomoof@3k080008Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P
5n0Gh1OP6n000aOP028Kh000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn0001Mn@003001l07`000Ul00Eoo`03001oogoo011oo`0047oo0`00
1Woo06X007ooOomoo`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k080000Z5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P0P0001iSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn020003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@004OV1n@7i0000:
O005Ool00`00Oomoo`0@Ool001Uoo`04001oogooOomX0n`200001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh00S
6n0Gh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn00000FOT000`00O01l0007O005Ool00`00Oomoo`0@Ool001Uoo`1^001oogooOol3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k080001:5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh000Hn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn00
00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000AnH7i0OT0000Ql00Eoo`03001oogoo
011oo`006Goo00@007ooOomoof`3k080008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001Q_P5n0Gh1OP6n0Gh080000OIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00005Wi000<0
07`0O0001G`01Goo00<007ooOol047oo000IOol01000Oomoogoo4`0005/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0020000B1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn0000=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000AnH7i0OT00
00Il00Eoo`03001oogoo011oo`006Goo00@007ooOomooa<3o`P005D3k08000056n0Gh1OP5n0Kh003
5n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000QOP0P0001iSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?P000FOT000`00O01l0003O005Ool00`00Oomoo`0@Ool001Uoo`04001oogooOolK0ol7
0000D0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`20000AQOP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh0000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT0017iPOT1n@00017`01Goo
00<007ooOol047oo000IOol20002OolR0ol5001=0n`200025n001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP5n0Gh080000MIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn00000FOT00
1000O01l07`017oo0P004Woo000IOol01000Oomoogoo9`?o1@0004X3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0P0002HGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0P0001]Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000P000Wi000EnH7i0OT1n@7iP00=n@005OV1n@7i0
OT1nH003OT0017iPOT1n@0000W`01Goo00<007ooOol047oo000IOol01000Oomoogoo;0?o1@00A`?/
0P0000DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh00T6n0Gh1OP5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh0005Gi000<007`0Ool017oo00<007ooOol047oo000IOol01000Oomo
ogoo<@?o1P0006X3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh080000LIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP0002OT001GiPOT1n@7i0OV00
0gi000EnH7i0OT1n@7iP00=n@004OV1n@7i00005Ool00`00Oomoo`0@Ool001Uoo`04001oogooOolg
0ol300110n`200035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n001A_P5n0Gh1OP6n000aOP020Kh1OP5n0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0005Gi000<007ooOol00Woo00<007ooOol047oo000IOol01000
Oomoogoo>P?o0P000443j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[008000126n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0006OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0000Wi000EnH7i0OT1n@7iP00=n
@005OV1n@7i0OT1nH003OT000giPOT1oo`04Ool00`00Oomoo`0@Ool001Uoo`04001oogooOoll0ol3
00100n`010005n0Gh1_P0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P008Gh080000KHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh00001=n@0Eoo`03001oogoo011oo`006Goo00@007ooOomoocl3o`@0
000m0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`00P00044Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh000009n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi01Goo
00<007ooOol047oo000IOol01000Oomoogoo@`?o1000>`?/00<001OP6n000aOP00DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh00L001Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP000AOT05Ool00`00
Oomoo`0@Ool001Uoo`04001oogooOom70ol40000NP?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP0002OT001GiPOT1n@7i0OV000gi000InH7i0
OT1n@7iPOT05Ool00`00Oomoo`0@Ool001Uoo`80009ood/3o`<003H3k08000056n0Gh1OP5n0Kh003
5n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n0081_P5n0Gh1OP
001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP000?OT04
Ool2000BOol001Uoo`04001oogooOom>0ol20000M`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00000Wi000EnH7i0OT1n@7iP00=n@004OV1n@7i0OT05
Ool00`00Oomoo`0@Ool001Uoo`04001oogooOom@0ol3000d0n`200035n001A_P5n0Gh1OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP01`006?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0000en@0Eoo`03001oogoo
011oo`006Goo00@007ooOomooe<3o`80001d0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0006?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn00009n@005OV1n@7i0OT1nH003OT000giPOT1oo`04Ool00`00Oomoo`0@
Ool001Uoo`04001oogooOomE0ol3000b0n`200025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP0P0001YWh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0002gi01Goo00<007ooOol047oo000IOol01000
OomoogooF0?o0P000743j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/000Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh000
009n@005OV1n@7i0OT1nH003OT05Ool00`00Oomoo`0@Ool001Uoo`04001oogooOomJ0ol2000a0n`2
00000aOP6n0Gh0025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n007a_P5n0Gh1OP6n0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OP008000Qn@0Eoo`03001oogoo011oo`006Goo00@007ooOomooe`3o`80000a0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/00P0003lKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0006OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0007i0OV000gi000=nH7i0Ool017oo00<0
07ooOol047oo000IOol01000OomoogooGP?o0P00<@?/00<001_P5n000QOP00DKh1OP5n0Gh1_P00<G
h0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP024Kh1OP5n0Gh1_P001Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00001Wi01Goo00<007ooOol047oo
000IOol01000OomoogooH0?o0P000303j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`2
0000?QOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn0007i0OV03OT05Ool00`00Oomoo`0@Ool001Uoo`04001oogooOomR0ol2000`0n`01@005n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP01dKh000
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00000An@0Eo
o`03001oogoo011oo`006Goo0P000WooI0?o0`0004l3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh00200007F?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?P001n@7iPOT0017oo0P004Woo000IOol01000OomoogooI`?o0`00;0?/0P000QOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP024Kh1OP5n0Gh1_P5n0006?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00000Wi01Goo00<0
07ooOol047oo000IOol01000OomoogooJP?o0P0006T3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh000
OT001Goo00<007ooOol047oo000IOol01000OomoogooK0?o0P00:`?/0P0000<Gh1_P5n000QOP00DK
h1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP01dKh1OP000006OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00000Eoo`03001oogoo011o
o`006Goo00@007ooOomoofh3o`80001V0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/001OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0006OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00017oo00<007ooOol0
47oo000IOol01000OomoogooL0?o00<000?/0n`0:@?/0P0000DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P008Gh00H001Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP1Goo00<007ooOol047oo000IOol01000Oomoogoo
2000J@?o0P000683k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0006OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P1Goo00<007ooOol047oo000IOol01000Oomoogoo206O
2`00H0?o0P00:P?/00<001_P5n000QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P
5n0Gh1OP6n000aOP01TKh1OP5n0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh005Ool00`00Oomoo`0@Ool001Uoo`0G001oogooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`08001J0ol0:`000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0080000c5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P001Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00Eoo`03001oogoo011oo`006Goo00@0
07ooOomooa/1W`P005<3o`8002X3k005000Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0025n005000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn05Ool00`00Oomoo`0@Ool001Uoo`0W001oogooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00P004d3o`80000Y
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`0200007A_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n000P00015Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?P00Eoo`03001oogoo011oo`006Goo0P000Woo:`6O1@00BP?o00<000?/0n`0:0?/00@001OP
5n0Kh0<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh00A001S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh004Ool2000BOol001Uoo`0d001oogooOol1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il300180ol20000:@?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`00P0002dGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn001Goo00<007ooOol047oo000I
Ool01000Oomoogoo<`6O1000AP?o0P00:@?/00<001OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00l006?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00
1Goo00<007ooOol047oo000IOol0>`00Oomoogoo0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl01000A0?o05H000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/000Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0006?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P1Goo00<007ooOol047oo000IOol01000Oomoogoo>`6O1000@@?o
0P009`?/00@001OP5n0Kh0<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh00=001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn001Goo00<007ooOol047oo000IOol0@`00
Oomoogoo0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o00<00403o`80000V0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k080000Y5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh000Hn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh005Ool00`00Oomoo`0@Ool001Uoo`04001oogooOom20Il3000o0ol00`000n`3k00U0n`0
0`005n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
2`00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn001Goo00<007ooOol047oo00040005Ool20005Ool40005Ool0
B@00Oomoogoo0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00<003d3o`80001>0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`005n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh000Hn1W
h6?PIn1Sh6OPHn1Wh6?P1Goo00<007ooOol047oo0003Ool00`00Oomoo`03Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool01000OomoogooB06O0`00?0?o0P009@?/00<001OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00T006?PIn1Sh6OPHn1Wh6?P
In001Goo00<007ooOol047oo00000`00Oomoo`0AOol00`00Oomoo`02Ool0C`00Oomoogoo0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00<003/3o`0V0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`80000T6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0006?PIn1Sh6OP
Hn1Wh6?P1Goo00<007ooOol047oo00000goo001oo`0AOol00`00Oomoo`02Ool20002Oom>0Il2000j
0ol2000U0n`00`006n0Gh0025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001`00Hn1Wh6?PIn1Sh6OP00=oo`<0019oo`000Woo00<007ooOol02goo10001Goo05@0
07ooOomoo`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il3000i0ol0B@000n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP001Sh6OPHn1Wh6?P00Eoo`03001oogoo011oo`000goo00<007ooOol02Woo00<007oo
Ool01Woo00@007ooOomooe<1W`8003P3o`8002@3k003000Kh1OP008Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005001Sh6OPHn1Wh005Ool00`00Oomoo`0@Ool0
00=oo`03001oogoo00Yoo`03001oogoo00Ioo`1I001oogooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`03000g0ol09@000n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0080000O5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP001Sh6OPHn00
1Goo00<007ooOol047oo0003000=Ool50004Ool01000OomoogooF06O0P00=P?o0P0090?/00D001OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00LKh1OP5n0Gh000Hn1Wh005
Ool00`00Oomoo`0@Ool001Uoo`1N001oogooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il3000e0ol20000@@?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/001OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh000Hn001Goo00<007oo
Ool047oo000IOol01000OomoogooG@6O0P00=@?o00<000?/0n`08@?/00D001OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh00000Eoo`03001oogoo011oo`00
6Goo06<007ooOomoo`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl00P00=0?o0P000283k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`80000K6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh00000Aoo`03001oogoo011oo`00
6Goo00@007ooOomoof41W`<003<3o`030003k0?/0243k004000Gh1OP6n035n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh1OP00Eoo`03001oogoo011oo`006Goo06P007ooOomoo`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0P00<P?o03d000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh005Ool00`00Oomoo`0@Ool001Uoo`04001oogooOomV
0Il2000a0ol00`000n`3k00Q0n`010005n0Gh1_P0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n000a_POomoo`03Ool00`00Oomoo`0@Ool001Uoo`80009oo`1X0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`800303o`80000i0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP00Aoo`80019oo`006Goo00@007ooOomoofX1W`800303o`030003k0?/0203
k004000Gh1OP6n035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P008Gh0Eoo`03001oogoo011o
o`006Goo070007ooOomoo`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`8002l3o`0S
0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k00200004aOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP00Eoo`03
001oogoo011oo`006Goo00@007ooOomoofh1W`8002h3o`800283k003000Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n001Goo00<007ooOol047oo000IOol0M000Oomoogoo0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il2000^0ol0=@000n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/001OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n001Goo00<007ooOol047oo000IOol01000Oomoogoo
LP6O0P00;@?o00<000?/0n`080?/00<001OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh1OP00Eo
o`03001oogoo011oo`006Goo07P007ooOomoo`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il2000/0ol20000<@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP00Eoo`03001oogoo011oo`006Goo00@007ooOomoo`P006h1W`8002`3o`030003k0?/
01l3k003000Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n000a_POomoo`03Ool00`00Oomoo`0@Ool001Uo
o`0<001oogooOolD7aPO51lH7a@O61lD7aPO3`000641W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`02000[0ol0<0000n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[000Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0Eoo`03001oogoo011oo`006Goo00@007ooOomo
o`8D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00/005P1W`030003
o`?o02T3o`800203k003000Gh1_P00<Gh0056n0Gh1OP5n0Kh0025n05Ool00`00Oomoo`0@Ool001Uo
o`0V001oogooOolD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7`D0001D0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0P00:`?o02d000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n001Goo00<007oo
Ool047oo000IOol20002Ool01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO008D7`D00541W`8002X3o`8001l3k003000G
h1_P00<Gh0056n0Gh1OP5n0Kh004Ool2000BOol001Uoo`0`001oogooOolD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO1@0004l1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000[0ol0
:P000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/001OP6n0Gh1_P5n0Kh1OP6n0Gh0Eoo`03001oogoo011oo`006Goo00@007ooOomoo`8D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO008D7`@004/1W`8002X3o`030003k0?/01d3k003
000Gh1_P00<Gh0036n0Gh1OP00Eoo`03001oogoo011oo`006Goo03T007ooOomooa@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l00`0004X1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0P00:@?o02P000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[000Gh1_P5n0Kh1OP6n0Gh0Eoo`03001oogoo011oo`006Goo00D0
07ooOomooaPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0461lD7a@O51l4
00180Il00`000ol3o`0W0ol2000N0n`00`005n0Kh0035n000a_POomoo`03Ool00`00Oomoo`0@Ool0
01Uoo`10001oogooOolD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61l30000AP6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0P00:@?o02D000?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`005n0Kh1OP6n0G
h005Ool00`00Oomoo`0@Ool001Uoo`04001oogooOol251l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<004D1W`8002P3o`030003k0?/
01`3k003000Gh1_P008Gh0Eoo`03001oogoo011oo`006Goo04H007ooOomooa@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`<0
00150Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`0002P3o`0S0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/001OP6n0Gh005Ool00`00Oomoo`0@Ool001Uoo`05
001oogooOolH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0461l0000000120Il2000W0ol00`000n`3k00L0n`00`005n0K
h005Ool00`00Oomoo`0@Ool001Uoo`1<001oogooOolD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l30000
@P6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il002L3o`80000O0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`005n001Goo00<007ooOol047oo000IOol20002Ool251l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l011PO00000000?`6O0P009`?o00<000?/0n`06`?/00<007ooOol00Woo
0P004Woo000IOol0DP00Oomoogoo51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0P00
0401O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl002L3o`0O0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[000017oo00<007ooOol047oo000IOol01@00Oomoogoo61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00@H7a@O51lD7`<003d1W`8002H3o`030003k0?/01X3k0Eoo`03001o
ogoo011oo`006Goo05L007ooOomooa@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51l00P0003d1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`02000U0ol070000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[1Goo00<007ooOol047oo000IOol01000Oomoogoo0Q@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7a@O00<003`1W`030003o`?o02<3
o`8001T3k0Eoo`03001oogoo011oo`006Goo05`007ooOomooa@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0P0003/1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o008002D3o`0I0003k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/01Goo00<007ooOol047oo000IOol01@00
Oomoogoo61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0661lD7a@O
51lH7a@O1000>@6O00<000?o0ol08`?o00<000?/0n`05@?/1Goo00<007ooOol047oo000IOol0HP00
Oomoogoo51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61l20000>@5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il0000U0ol05`000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/01Goo00<007ooOol047oo000IOol01000Oomoogoo0Q@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7`8003H1W`030003
o`?o02@3o`030003k0?/01<3k0Eoo`03001oogoo011oo`006Goo06H007ooOomooa@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61l20000=@5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl00P00
9@?o01D000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/01Goo00<007ooOol0
47oo000IOol01@00Oomoogoo61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O0P00=@6O00<000?o0ol08`?o00<000?/
0n`04@?/1Goo00<007ooOol047oo000IOol20002Ool0IQ@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`80
000d0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il2000T0ol04`000n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00Aoo`80019oo`006Goo00@007ooOomoo`8D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O0P00=06O00<000?o0ol08P?o00<000?/0n`03`?/1Goo
00<007ooOol047oo000IOol0KP00Oomoogoo51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l2
0000=05o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0090?o014000?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00Eoo`03001oogoo011oo`006Goo00D007ooOomooaPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l2000b0Il2000S0ol00`000n`3k00=0n`5Ool0
0`00Oomoo`0@Ool001Uoo`1b001oogooOolD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO0P0003<1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00008`?o00l0
00?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/01Goo00<007ooOol047oo000IOol01000Oomoogoo
0Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O0P00<@6O0P008P?o00<0
00?/0n`02`?/1Goo00<007ooOol047oo000IOol0MP00Oomoogoo51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0P000381O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`008P?o00d000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`05Ool00`00Oomoo`0@Ool0
01Uoo`05001oogooOolH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`800301W`800243o`030003k0?/00T3k0Eoo`03001oogoo011oo`0047oo0`001Woo07X007oo
Oomooa@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
0P000341O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000Q0ol02`000n`3j`?/0n/3
k0?[0n`3j`?/0n/01Goo00<007ooOol047oo000?Ool01@00Oomoogoo00001Goo00@007ooOomoo`8D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO51l2
000_0Il00`000ol3o`0O0ol00`000n`3k0070n`5Ool00`00Oomoo`0@Ool001=oo`03001oogoo00=o
o`04001oogooOol80000Xa@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`000243o`090003k0?[0n`3j`?/
0n/3k0?[00Eoo`03001oogoo011oo`004goo00<007ooOol00goo0P000Woo00QT7f0OI1mP7f@OH1mT
7f0O400000DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00@H7a@O51l002l1W`030003o`?o01l3o`030003k0?/00D3k0=oo`<0
019oo`004Goo0P001Woo01`007ooOomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7`X0001J51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO0P0002l1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`000243
o`070003k0?[0n`3j`?/0n/01Goo00<007ooOol047oo000COol00`00Oomoo`03Ool09P00Oomoogoo
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1l5000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O
51lD7`8002d1W`030003o`?o01l3o`030003k0?/00<3k0Eoo`03001oogoo011oo`003goo00D007oo
Oomoo`0000Eoo`0[001oogooOomP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l01@0005@D7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l20000;05o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il2000P0ol01@000n`3j`?/0n/01Goo00<007ooOol047oo000@Ool30006Ool0<000Oomoogoo
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`@0000561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l00aPO51l0000]0Il00`000ol3o`0N0ol010000n`3k0?/1Goo00<007ooOol047oo
000IOol0=000OomoogooH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O100004lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`020000;@6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl0000P0ol00`000n`3j`05Ool00`00Oomoo`0@Ool001Uoo`0h001oogooOomT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`@0008D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0361lD7a@O008002/1W`030003o`?o01h3o`030003k7oo00Aoo`03001oogoo011oo`00
6Goo03`007ooOomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1l40000Ba@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`020000:`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`000203o`03001oogoo00=oo`03001oogoo011oo`006Goo040007ooOomoof@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`<00003
51lH7a@O008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO000Z0Il2000O0ol00`00Oomoo`02Ool00`00Oomo
o`0@Ool001Uoo`13001oogooOomP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00`0004PD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l20000
:`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0001h3o`Eoo`03001oogoo011oo`006Goo0P000Woo049T
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l300000a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7`0002X1W`030003o`?o01/3o`Ao
o`80019oo`006Goo04T007ooOomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`030000LA@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000070?o1Goo00<007ooOol047oo000IOol0C000
OomoogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0`0000<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O0P00:@6O00<0
00?o0ol06@?o1Goo00<007ooOol047oo000IOol0C`00OomoogooH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0O00<0001/51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0P006@?o1Goo
00<007ooOol047oo000IOol0DP00OomoogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0O0`0000<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0361lD7a@O008002T1W`030003o`?o01H3o`Eoo`03001oogoo011oo`006Goo05D0
07ooOomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`030000JQ@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`005`?o1Goo00<007ooOol047oo000IOol0F000Oomoogoo
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0P000Q@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51l0000Y
0Il00`000ol3o`0D0ol5Ool00`00Oomoo`0@Ool001Uoo`1J001oogooOomP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0P0003dD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`020000:@6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o00005@?o1Goo00<007ooOol047oo000IOol0G000OomoogooI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l200001APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO000X0Il00`000ol3
o`0B0ol5Ool00`00Oomoo`0@Ool001Uoo`1N001oogooOomP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l30000I1PO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0P004P?o1Goo00<007ooOol047oo000IOol0H@00OomoogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0080000351lH7a@O008D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`02000X0Il00`000ol3
o`0?0ol5Ool00`00Oomoo`0@Ool001Uoo`80009oo`1OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`020000I1PO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`0040?o17oo0P004Woo000IOol0I@00OomoogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l00P000a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO51l2000W0Il00`000ol3
o`0=0ol5Ool00`00Oomoo`0@Ool001Uoo`1W001oogooOomP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00`00064D
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il0000>0ol5Ool00`00Oomoo`0@Ool001Uoo`1Z001oogooOomT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l200001APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00Q@O00<0006O0Il09@6O00<000?o0ol02`?o1Goo00<007ooOol047oo000IOol0K000Oomoogoo
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`80000f51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO0P0002L1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000030?o1Goo00<007ooOol0
47oo000IOol0KP00OomoogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l2000251l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O00009P6O00<000?o0ol02@?o
1Goo00<007ooOol047oo000IOol0L000OomoogooH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@O0P0003DD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0080
000V0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il000X3o`Eoo`03001oogoo011oo`006Goo078007ooOomoof@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l200001APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01QPO51lD7a@O61l002D1W`030003o`?o00L3o`Eoo`03001oogoo011oo`006Goo
07@007ooOomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0P0003@D
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`80000U0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
000020?o1Goo00<007ooOol047oo000IOol0MP00OomoogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0P000Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00<H7a@O0000906O00<000?o0ol01@?o1Goo00<007ooOol047oo000IOol0N000Oomoogoo
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`80001I51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000060ol5
Ool00`00Oomoo`0@Ool001Uoo`80009oo`1fI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l200001APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l00aPO51l0000T0Il00`000ol3o`030ol4Ool2000BOol001Uoo`1l001oogooOomP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l20000<A@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0080000T0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0010?o1Goo00<0
07ooOol047oo000IOol0O`00OomoogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO008D7`030001W`6O0241W`040003o`?o0ol5Ool00`00Oomoo`0@Ool001Uoo`1o001oogoo
OomP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1l00P0005HH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`000Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`000P?o1Goo00<007ooOol047oo000IOol01000Oomoogoo200007ET7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l00P0000<D7aPO51l00Q@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l011PO51lD7`008`6O00<000?oOol017oo00<007ooOol047oo000IOol01000
Oomoogoo0g`B00El4g`BO19l4W`C00/00032I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000Eoo`03
001oogoo011oo`006Goo00@007ooOomooa=l4PP0001UH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`020000
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0251l00`000Il1W`0Q0Il00`00Oomoo`02Ool0
0`00Oomoo`0@Ool001Uoo`06001oogooOoml4W`C0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801W`CO19l4W`BO1=l4PP0001OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`020000DA@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`05Ool00`00Oomoo`0@Ool001Uoo`04001oogooOolSO1880000
FV0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O51l00P00806O1Goo00<007ooOol047oo000IOol0
1000Oomoogoo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1850000EF0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0080001>61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o1Goo00<007ooOol047oo000IOol20002Ool`O1840000Df@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l00P0000<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l00`000Il1W`0L0Il4Ool2000BOol001Uoo`06001oogooOoml4W`C0g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00W`B100009eP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`05Ool00`00Oomoo`0@Ool0
01Uoo`04001oogooOolhO1840000CV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`80
000561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00@H7a@O51lD7`8001/1W`Eoo`03001oogoo011oo`006Goo00@0
07ooOomoo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1800g`C000000020000C60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0P0004LD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o00Eoo`03001oogoo011oo`006Goo00@007ooOomood1l4P<0001<H1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361l0006O01P1
W`Eoo`03001oogoo011oo`006Goo00H007ooOomoog`BO1<3O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00Il4g`BO19l4W`CO1820000BV@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1l20000A1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl5Ool00`00Oomoo`0@Ool001Uoo`04
001oogooOom5O1830000BV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000251l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0361l0006O01H1W`Eoo`03001oogoo011oo`006Goo00@007ooOomoo`=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00<0002:I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o1Goo00<0
07ooOol047oo00030006Ool20005Ool40005Ool01000OomoogooBg`B0`0004IT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1l0008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7`000Il0506O1Goo00<007ooOol047oo0003
Ool00`00Oomoo`03Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01P00OomoogooO19l4`=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P1cO1<00000H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61l00P0001<1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`05Ool00`00Oomoo`0@Ool000=oo`03001oogoo00ioo`03001oogoo009oo`04001oogooOom@O183
0000@V0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7`80000351lH7a@O008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01aPO51lD7a@O61lD7`000181W`Eoo`03
001oogoo011oo`000goo00<007ooOol03Woo00<007ooOol00Woo0P000Woo0g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P800020I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`=oo`<0019oo`00
00=oo`0000003Goo10001Goo00@007ooOomooeEl4P<00013I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`07
61lD7a@O51lH7a@O0000406O1Goo00<007ooOol047oo0003Ool00`00Oomoo`0:Ool00`00Oomoo`06
Ool01P00OomoogooO19l4`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
0g`CO19l4P020000?f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7`020000>QPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`000Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o1Goo00<007ooOol047oo0003Ool00`00Oomoo`0:Ool00`00Oomo
o`06Ool01000OomoogooFW`B0`00041P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01aPO51lD7a@O61lD7`0000h1W`Eo
o`03001oogoo011oo`000`003Goo1@0017oo00@007ooOomoo`=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B07Yl4g`B000006@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o1Goo00<007ooOol047oo000I
Ool01000OomoogooGg`B0P0003aP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1l2000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00LH7a@O51lD7aPO51l0000<0Il5Ool00`00Oomo
o`0@Ool001Uoo`06001oogooOoml4W`C0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O18017`CO19l4W`B0P00079T7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl5Ool00`00Oomoo`0@Ool001Uoo`04001oogooOomSO182
0000>f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1l00P000Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0761lD7a@O51lH7a@O00002P6O1Goo00<007ooOol047oo000IOol01000Oomo
ogoo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00=l4g`B00000P0006eP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O
0Gl1W`5o0Il1O`05Ool00`00Oomoo`0@Ool001Uoo`04001oogooOomXO1820000>F@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0200000a@O61lD7`0251l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00<H7a@O0000206O1Goo00<007ooOol047oo000IOol01P00OomoogooO19l4`=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`020000JF0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`05Ool00`00
Oomoo`0@Ool001Uoo`80009oofal4P80000hI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7`80000561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01aPO51lD7a@O61lD7`0000H1W`Aoo`80019oo`006Goo
00@007ooOomoo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19l4P020000IF0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51l0005o0Il1O`6O0Gl01Goo00<007ooOol047oo000IOol01000OomoogooL7`B0P0003UT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`03
61lD7`0000@1W`Eoo`03001oogoo011oo`006Goo00H007ooOomoog`BO1<3O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C0080001QH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl01Goo00<007ooOol0
47oo000IOol01000OomoogooM7`B0P0003ET7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@O008000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l00aPO51l000020Il5Ool00`00Oomoo`0@Ool001Uoo`04001o
ogooOol3O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P03O1=l4W`B
0080001MH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51l0005o00Eoo`03001oogoo011oo`006Goo00@007ooOomoogQl4P80000eI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0000351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O00001Goo00<0
07ooOol047oo000IOol01P00OomoogooO19l4`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B065l4g`BO19l4W`C001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l00004Ool00`00Oomoo`0@Ool001Uoo`04001oogoo
OomkO1820000=60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`000a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0361moogoo00=oo`03001oogoo011oo`006Goo00@007ooOomoo`=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P0fO1=l4P00H1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0P00028H7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`Eoo`03001oogoo011o
o`006Goo0P000WooOW`B0P0003AT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1l0008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0251l4Ool2000BOol001Uoo`06001oogooOoml4W`C0g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4g`BO1800P0005=P7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O00Eoo`03001oogoo011oo`00
6Goo00@007ooOomooa<006ml4P0d001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@O000251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l01Goo00<007ooOol047oo000IOol01000Oomoogoo4g`0200000El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P80001@I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`Eo
o`03001oogoo011oo`006Goo00@007ooOomooa]l00L006=l4P0c001T7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7`00008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0361lD7a@O00Eoo`03001oogoo011oo`006Goo00@007ooOomoob9l00D0009l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B05Al
4g`BO19l4W`C001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l5Ool00`00Oomoo`0@
Ool001Uoo`04001oogooOolWO005001KO1820000<F0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7`00008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0361moogoo00=oo`03001oogoo011oo`006Goo00@007ooOomoobal00@000=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180=g`CO19l4W`BO1=l4P00H1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O0080000I51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51l01Goo00<007ooOol047oo000IOol01000Oomoogoo<7`01000EW`B0P00
03=T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l00aPO51lD7`05Ool00`00Oomoo`0@Ool001Uoo`04001oogooOold
O00400000g`BO1=l4P02O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00W`B04T0
06@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`05Ool00`00Oomoo`0@Ool001Uoo`04001oogooOolhO004
001AO1820000<V0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61l351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361moogoo00=oo`03001oogoo011oo`006Goo0P000Woo
?7`00`0000El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P16001P7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51l4Ool2000BOol001Uoo`04001oogooOoloO004001=O1820000<F@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0O000D7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00Q@O
1Goo00<007ooOol047oo000IOol01000Oomoogoo@g`010000W`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B04Al4`00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O1Goo00<007ooOol047oo000IOol01000OomoogooAg`01000B7`B
0P0002eP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00P0000DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l00aPOOomoo`03Ool00`00Oomoo`0@Ool001Uoo`04001oogooOom;O00300000g`B
O1=l4P02O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P12O1=l4P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O1Goo00<007ooOol047oo000IOol01000Oomoogoo
CW`00P00AW`B0P0002mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO00<D7`0561lD7a@O
51lH7`0351l00aPO51lD7`05Ool00`00Oomoo`0@Ool001Uoo`04001oogooOom@O0030002O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P03O1=l4W`B0080000kH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7`05Ool00`00Oomoo`0@Ool001Uoo`04001oogooOomCO0020015O1820000
;F@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7`0351l01APO51lD7a@O61l00a@O00<H7gooOol0
0goo00<007ooOol047oo000IOol01000OomoogooEG`00`000g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180>W`C001T7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O1Goo00<007ooOol047oo
000IOol01000OomoogooF7`00P00@g`B02h006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7`<D
7`0561lD7a@O51lH7`0251l5Ool00`00Oomoo`0@Ool001Uoo`04001oogooOomJO00200000g`BO1=l
4P02O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C0080000eH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD
7`05Ool00`00Oomoo`0@Ool001Uoo`80009ooeal0080049l4P0]001P7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1l001PO00<D7`0561lD7a@O51lH7`04Ool2000BOol001Uoo`04001oogooOomNO0020003O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B03Yl4g`BO19l
4W`CO180060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7`Eoo`03001oogoo
011oo`006Goo00@007ooOomoof1l0080041l4P80000[I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061l0
0a@O00<H7a@O51l01Goo00<007ooOol047oo000IOol01000OomoogooHW`00P0000=l4W`CO1800W`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P0dO1=l4W`B
001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51l5Ool00`00Oomoo`0@Ool001Uoo`04
001oogooOomTO002000oO180;000I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061l351l00aPOOomoo`03
Ool00`00Oomoo`0@Ool001Uoo`04001oogooOomVO0020003O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4g`BO1800P0002eP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7`0061lD7aPO51l01Goo00<007ooOol047oo000IOol01000OomoogooJ7`00P00?W`B02/0060O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@O000H7`0251l5Ool00`00Oomoo`0@Ool0019oo`<000Aoo`04001oogoo
OomZO00300001G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
031l4g`BO19l4P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51l5Ool00`00Oomoo`0@Ool001=oo`03
001oogoo00=oo`04001oogooOom]O002000kO1820000:F@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061l01Goo
00<007ooOol047oo000COol00`00Oomoo`03Ool01000OomoogooKg`00P000W`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P0ZO1<006@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7`001Goo00<007ooOol047oo000?Ool60004Ool20002OomaO002000jO180:@00I1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O00000Woo0`004Woo000@Ool01000Oomoo`001Goo00<007ooOol0fgoo00<007ooOol0
47oo000@Ool01000Oomoo`001Goo00<007ooOol0fgoo00<007ooOol047oo000AOol00`00Ool00005
Ool01@00Oomoogoo0000=7oo00<007ooOol0<goo00<007ooOol0<Woo00<007ooOol0<Woo00<007oo
Ool00Woo00<007ooOol047oo000BOol20005Ool01@00Oomoogoo00002Woo00<007ooOol01goo00<0
07ooOol027oo00<007ooOol027oo00<007ooOol01goo00<007ooOol027oo00<007ooOol027oo00<0
07ooOol01goo00<007ooOol027oo00<007ooOol027oo00<007ooOol01goo00<007ooOol027oo00<0
07ooOol027oo00<007ooOol01goo00<007ooOol027oo00<007ooOol027oo00<007ooOol01goo00<0
07ooOol027oo00<007ooOol027oo00<007ooOol01goo00<007ooOol00Woo00<007ooOol047oo000I
OooO000BOol00?moo`]oo`00ogoo2goo003oOol;Ool00?moo`]oo`00ogoo2goo003oOol;Ool00?mo
o`]oo`00ogoo2goo003oOol;Ool00?moo`]oo`00ogoo2goo000HOol3003_Ool001Moo`05001oogoo
Ool0003^Ool001Moo`03001oogoo0?1oo`005goo00<007ooOol0l7oo000GOol00`00Oomoo`3`Ool0
01Ioo`D00>moo`005goo00<007ooOol0l7oo003oOol;Ool00?moo`]oo`00ogoo2goo003oOol;Ool0
0?moo`]oo`00ogoo2goo003oOol;Ool00?moo`]oo`00\
\>"],
  ImageRangeCache->{{{0, 265.25}, {265.25, 0}} -> {-0.276893, 1.80512, \
0.0117156, 0.0117156}}]
}, Open  ]],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"KdVEquation.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{676, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->287,
PrintingPageRange->{2, 2},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageFooters->{{Inherited, None, Inherited}, {Inherited, None, Inherited}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Working examples"->{
    Cell[1739, 51, 349, 5, 52, "Section",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 47}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Working examples"]},
  "solve physical and mathematical problems"->{
    Cell[2091, 58, 1200, 22, 201, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "diffusion equation"->{
    Cell[2091, 58, 1200, 22, 201, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}],
    Cell[3407, 87, 1335, 23, 264, "Text",
      CellTags->{
      "diffusion equation", "derive the symmetries", "boundary value problem",
         "seasonal oscillations of the temperature"}]},
  "thermal oscillations"->{
    Cell[2091, 58, 1200, 22, 201, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "single flux line in a superconductor"->{
    Cell[2091, 58, 1200, 22, 201, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "hydrodynamics"->{
    Cell[2091, 58, 1200, 22, 201, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "first atomic explosion"->{
    Cell[2091, 58, 1200, 22, 201, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "symmetry analysis"->{
    Cell[2091, 58, 1200, 22, 201, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}],
    Cell[25278, 642, 1871, 38, 327, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}],
    Cell[248805, 6132, 284, 8, 54, "Text",
      CellTags->"symmetry analysis"]},
  "formation of droplets"->{
    Cell[2091, 58, 1200, 22, 201, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "industrial applications"->{
    Cell[2091, 58, 1200, 22, 201, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "The diffusion equation"->{
    Cell[3316, 84, 88, 1, 49, "Subsection",
      CellTags->"The diffusion equation"]},
  "derive the symmetries"->{
    Cell[3407, 87, 1335, 23, 264, "Text",
      CellTags->{
      "diffusion equation", "derive the symmetries", "boundary value problem",
         "seasonal oscillations of the temperature"}]},
  "boundary value problem"->{
    Cell[3407, 87, 1335, 23, 264, "Text",
      CellTags->{
      "diffusion equation", "derive the symmetries", "boundary value problem",
         "seasonal oscillations of the temperature"}],
    Cell[33808, 864, 395, 6, 96, "Text",
      CellTags->"boundary value problem"]},
  "seasonal oscillations of the temperature"->{
    Cell[3407, 87, 1335, 23, 264, "Text",
      CellTags->{
      "diffusion equation", "derive the symmetries", "boundary value problem",
         "seasonal oscillations of the temperature"}]},
  "The earthworm's New Year problem"->{
    Cell[4779, 115, 136, 2, 49, "Subsection",
      CellTags->"The earthworm's New Year problem"]},
  "damped temperature waves"->{
    Cell[4918, 119, 815, 14, 159, "Text",
      CellTags->{"damped temperature waves", "New Year problem"}]},
  "New Year problem"->{
    Cell[4918, 119, 815, 14, 159, "Text",
      CellTags->{"damped temperature waves", "New Year problem"}]},
  "temperature variation"->{
    Cell[5789, 138, 413, 12, 54, "Text",
      CellTags->"temperature variation"],
    Cell[42651, 1205, 951, 27, 119, "Text",
      CellTags->"temperature variation"],
    Cell[175189, 4170, 587, 9, 138, "Text",
      CellTags->{"temperature variation", "contour plot"}]},
  "temperature on the surface"->{
    Cell[25278, 642, 1871, 38, 327, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}]},
  "radiation changes"->{
    Cell[25278, 642, 1871, 38, 327, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}]},
  "LieEquations[]"->{
    Cell[25278, 642, 1871, 38, 327, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}],
    Cell[28809, 719, 344, 9, 75, "Text",
      CellTags->"LieEquations[]"]},
  "LieSolve[]"->{
    Cell[25278, 642, 1871, 38, 327, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}],
    Cell[29944, 755, 1408, 27, 264, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}],
    Cell[247315, 6085, 1014, 30, 117, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}],
    Cell[249909, 6174, 1037, 26, 138, "Text",
      CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}],
    Cell[250949, 6202, 931, 21, 159, "Text",
      CellTags->{"LieSolve[]", "FinalResult"}]},
  "boundary values"->{
    Cell[25278, 642, 1871, 38, 327, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}]},
  "automatic symmetry analysis"->{
    Cell[27227, 686, 1248, 24, 243, "Text",
      CellTags->{
      "automatic symmetry analysis", "pencil and paper", 
        "equation parameters"}]},
  "pencil and paper"->{
    Cell[27227, 686, 1248, 24, 243, "Text",
      CellTags->{
      "automatic symmetry analysis", "pencil and paper", 
        "equation parameters"}]},
  "equation parameters"->{
    Cell[27227, 686, 1248, 24, 243, "Text",
      CellTags->{
      "automatic symmetry analysis", "pencil and paper", 
        "equation parameters"}]},
  "prolongation formalism"->{
    Cell[29944, 755, 1408, 27, 264, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}]},
  "invariance condition"->{
    Cell[29944, 755, 1408, 27, 264, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}]},
  "system of determining equations"->{
    Cell[29944, 755, 1408, 27, 264, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}]},
  "general canonical form"->{
    Cell[29944, 755, 1408, 27, 264, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}]},
  "infinite-dimensional Lie group"->{
    Cell[33325, 848, 390, 9, 75, "Text",
      CellTags->{
      "infinite-dimensional Lie group", "discrete subgroup", 
        "similarity solution"}]},
  "discrete subgroup"->{
    Cell[33325, 848, 390, 9, 75, "Text",
      CellTags->{
      "infinite-dimensional Lie group", "discrete subgroup", 
        "similarity solution"}]},
  "similarity solution"->{
    Cell[33325, 848, 390, 9, 75, "Text",
      CellTags->{
      "infinite-dimensional Lie group", "discrete subgroup", 
        "similarity solution"}],
    Cell[38882, 1058, 134, 4, 33, "Text",
      CellTags->"similarity solution"],
    Cell[270399, 6795, 178, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"similarity solution"]},
  "invariance of the boundary conditions"->{
    Cell[34681, 894, 406, 10, 75, "Text",
      CellTags->{
      "invariance of the boundary conditions", "infinitesimals"}]},
  "infinitesimals"->{
    Cell[34681, 894, 406, 10, 75, "Text",
      CellTags->{"invariance of the boundary conditions", "infinitesimals"}],
    Cell[36987, 988, 147, 4, 33, "Text",
      CellTags->"infinitesimals"],
    Cell[247315, 6085, 1014, 30, 117, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}],
    Cell[249909, 6174, 1037, 26, 138, "Text",
      CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}],
    Cell[262826, 6566, 532, 14, 75, "Text",
      CellTags->{"symbolic names", "Result2", "infinitesimals"}],
    Cell[264494, 6616, 228, 5, 54, "Text",
      CellTags->"infinitesimals"]},
  "group constants"->{
    Cell[36587, 972, 149, 4, 33, "Text",
      CellTags->"group constants"]},
  "LieRedunction[]"->{
    Cell[37393, 1005, 247, 6, 54, "Text",
      Evaluatable->False,
      CellTags->"LieRedunction[]"]},
  "similarity form"->{
    Cell[38438, 1039, 187, 6, 33, "Text",
      CellTags->"similarity form"]},
  "LieReduction[]"->{
    Cell[39520, 1083, 240, 6, 54, "Text",
      CellTags->"LieReduction[]"]},
  "contour plot"->{
    Cell[175189, 4170, 587, 9, 138, "Text",
      CellTags->{"temperature variation", "contour plot"}]},
  "symmetries of PDEs"->{
    Cell[242487, 5927, 307, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"symmetries of PDEs"]},
  "Single Flux Line in Superconductors"->{
    Cell[242843, 5941, 114, 1, 49, "Subsection",
      CellTags->"Single Flux Line in Superconductors"]},
  "single flux line in superconductors"->{
    Cell[242960, 5944, 775, 14, 138, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "low temperature dynamics"->{
    Cell[242960, 5944, 775, 14, 138, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "type-II superconductor"->{
    Cell[242960, 5944, 775, 14, 138, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "Lorentz force"->{
    Cell[242960, 5944, 775, 14, 138, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "depinning threshold"->{
    Cell[242960, 5944, 775, 14, 138, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "flux line"->{
    Cell[244356, 5983, 939, 21, 180, "Text",
      CellTags->{"flux line", "Lie[]"}]},
  "Lie[]"->{
    Cell[244356, 5983, 939, 21, 180, "Text",
      CellTags->{"flux line", "Lie[]"}],
    Cell[247315, 6085, 1014, 30, 117, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}]},
  "parameters of the equation"->{
    Cell[245620, 6026, 115, 1, 33, "Text",
      CellTags->"parameters of the equation"]},
  "Ginzburg-Landau"->{
    Cell[245864, 6038, 607, 16, 96, "Text",
      CellTags->{
      "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}]},
  "damping coefficient"->{
    Cell[245864, 6038, 607, 16, 96, "Text",
      CellTags->{
      "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}]},
  "Bardeen-Stephen model"->{
    Cell[245864, 6038, 607, 16, 96, "Text",
      CellTags->{
      "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}]},
  "LieEquation[]"->{
    Cell[247315, 6085, 1014, 30, 117, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}]},
  "determining equation"->{
    Cell[247315, 6085, 1014, 30, 117, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}]},
  "LieStructureForm[]"->{
    Cell[247315, 6085, 1014, 30, 117, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}]},
  "data basis"->{
    Cell[248487, 6121, 247, 5, 54, "Text",
      CellTags->{"data basis", "determination of the symmetries"}]},
  "determination of the symmetries"->{
    Cell[248487, 6121, 247, 5, 54, "Text",
      CellTags->{"data basis", "determination of the symmetries"}]},
  "finite point group"->{
    Cell[249909, 6174, 1037, 26, 138, "Text",
      CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}]},
  "FinalResult"->{
    Cell[250949, 6202, 931, 21, 159, "Text",
      CellTags->{"LieSolve[]", "FinalResult"}]},
  "symbolic names"->{
    Cell[262826, 6566, 532, 14, 75, "Text",
      CellTags->{"symbolic names", "Result2", "infinitesimals"}]},
  "Result2"->{
    Cell[262826, 6566, 532, 14, 75, "Text",
      CellTags->{"symbolic names", "Result2", "infinitesimals"}]},
  "remaining equations"->{
    Cell[263663, 6594, 828, 20, 138, "Text",
      CellTags->{"remaining equations", "PDESolve[]"}]},
  "PDESolve[]"->{
    Cell[263663, 6594, 828, 20, 138, "Text",
      CellTags->{"remaining equations", "PDESolve[]"}]},
  "moving wave solution"->{
    Cell[265140, 6637, 245, 5, 54, "Text",
      Evaluatable->False,
      CellTags->"moving wave solution"]},
  "solution of Tang's equation"->{
    Cell[268456, 6727, 347, 10, 54, "Text",
      Evaluatable->False,
      CellTags->"solution of Tang's equation"],
    Cell[859392, 39977, 326, 10, 54, "Text",
      Evaluatable->False,
      CellTags->"solution of Tang's equation"]},
  "similarity representation"->{
    Cell[270821, 6813, 332, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "similarity representation", 
        "implicit representation of the solution"}]},
  "implicit representation of the solution"->{
    Cell[270821, 6813, 332, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "similarity representation", 
        "implicit representation of the solution"}]},
  "circle"->{
    Cell[271413, 6836, 1706, 55, 180, "Text",
      Evaluatable->False,
      CellTags->{"circle", "animation"}]},
  "animation"->{
    Cell[271413, 6836, 1706, 55, 180, "Text",
      Evaluatable->False,
      CellTags->{"circle", "animation"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Working examples", 963169, 41967},
  {"solve physical and mathematical problems", 963537, 41974},
  {"diffusion equation", 963905, 41981},
  {"thermal oscillations", 964469, 41992},
  {"single flux line in a superconductor", 964855, 41999},
  {"hydrodynamics", 965218, 42006},
  {"first atomic explosion", 965590, 42013},
  {"symmetry analysis", 965957, 42020},
  {"formation of droplets", 966611, 42033},
  {"industrial applications", 966984, 42040},
  {"The diffusion equation", 967356, 42047},
  {"derive the symmetries", 967473, 42050},
  {"boundary value problem", 967698, 42055},
  {"seasonal oscillations of the temperature", 968025, 42062},
  {"The earthworm's New Year problem", 968260, 42067},
  {"damped temperature waves", 968392, 42070},
  {"New Year problem", 968526, 42073},
  {"temperature variation", 968665, 42076},
  {"temperature on the surface", 968973, 42083},
  {"radiation changes", 969201, 42088},
  {"LieEquations[]", 969426, 42093},
  {"LieSolve[]", 969723, 42100},
  {"boundary values", 970550, 42117},
  {"automatic symmetry analysis", 970788, 42122},
  {"pencil and paper", 970966, 42127},
  {"equation parameters", 971147, 42132},
  {"prolongation formalism", 971331, 42137},
  {"invariance condition", 971564, 42142},
  {"system of determining equations", 971808, 42147},
  {"general canonical form", 972043, 42152},
  {"infinite-dimensional Lie group", 972286, 42157},
  {"discrete subgroup", 972466, 42162},
  {"similarity solution", 972648, 42167},
  {"invariance of the boundary conditions", 973039, 42177},
  {"infinitesimals", 973189, 42181},
  {"group constants", 973901, 42196},
  {"LieRedunction[]", 974002, 42199},
  {"similarity form", 974130, 42203},
  {"LieReduction[]", 974231, 42206},
  {"contour plot", 974329, 42209},
  {"symmetries of PDEs", 974460, 42212},
  {"Single Flux Line in Superconductors", 974612, 42216},
  {"single flux line in superconductors", 974761, 42219},
  {"low temperature dynamics", 975007, 42224},
  {"type-II superconductor", 975251, 42229},
  {"Lorentz force", 975486, 42234},
  {"depinning threshold", 975727, 42239},
  {"flux line", 975958, 42244},
  {"Lie[]", 976058, 42247},
  {"parameters of the equation", 976364, 42254},
  {"Ginzburg-Landau", 976478, 42257},
  {"damping coefficient", 976643, 42261},
  {"Bardeen-Stephen model", 976810, 42265},
  {"LieEquation[]", 976969, 42269},
  {"determining equation", 977183, 42274},
  {"LieStructureForm[]", 977395, 42279},
  {"data basis", 977599, 42284},
  {"determination of the symmetries", 977750, 42287},
  {"finite point group", 977888, 42290},
  {"FinalResult", 978027, 42293},
  {"symbolic names", 978143, 42296},
  {"Result2", 978269, 42299},
  {"remaining equations", 978407, 42302},
  {"PDESolve[]", 978527, 42305},
  {"moving wave solution", 978657, 42308},
  {"solution of Tang's equation", 978803, 42312},
  {"similarity representation", 979074, 42319},
  {"implicit representation of the solution", 979298, 42325},
  {"circle", 979489, 42331},
  {"animation", 979621, 42335}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 349, 5, 52, "Section",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 47}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Working examples"],
Cell[2091, 58, 1200, 22, 201, "Text",
  CellTags->{
  "solve physical and mathematical problems", "diffusion equation", 
    "thermal oscillations", "single flux line in a superconductor", 
    "hydrodynamics", "first atomic explosion", "symmetry analysis", 
    "formation of droplets", "industrial applications"}],

Cell[CellGroupData[{
Cell[3316, 84, 88, 1, 49, "Subsection",
  CellTags->"The diffusion equation"],
Cell[3407, 87, 1335, 23, 264, "Text",
  CellTags->{
  "diffusion equation", "derive the symmetries", "boundary value problem", 
    "seasonal oscillations of the temperature"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4779, 115, 136, 2, 49, "Subsection",
  CellTags->"The earthworm's New Year problem"],
Cell[4918, 119, 815, 14, 159, "Text",
  CellTags->{"damped temperature waves", "New Year problem"}],
Cell[5736, 135, 50, 1, 27, "Input"],
Cell[5789, 138, 413, 12, 54, "Text",
  CellTags->"temperature variation"],

Cell[CellGroupData[{
Cell[6227, 154, 109, 2, 28, "Input"],
Cell[6339, 158, 242, 8, 30, "Output"]
}, Open  ]],
Cell[6596, 169, 160, 4, 33, "Text"],
Cell[6759, 175, 18516, 465, 202, 7461, 323, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[25278, 642, 1871, 38, 327, "Text",
  CellTags->{
  "temperature on the surface", "radiation changes", "LieEquations[]", 
    "LieSolve[]", "symmetry analysis", "boundary values"}],

Cell[CellGroupData[{
Cell[27174, 684, 50, 0, 37, "Subsubsection"],
Cell[27227, 686, 1248, 24, 243, "Text",
  CellTags->{
  "automatic symmetry analysis", "pencil and paper", "equation parameters"}],
Cell[28478, 712, 328, 5, 99, "Input"],
Cell[28809, 719, 344, 9, 75, "Text",
  CellTags->"LieEquations[]"],

Cell[CellGroupData[{
Cell[29178, 732, 57, 1, 27, "Input"],
Cell[29238, 735, 691, 17, 250, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[29944, 755, 1408, 27, 264, "Text",
  CellTags->{
  "LieSolve[]", "prolongation formalism", "invariance condition", 
    "system of determining equations", "general canonical form"}],

Cell[CellGroupData[{
Cell[31377, 786, 89, 2, 27, "Input"],
Cell[31469, 790, 1841, 55, 97, "Output"]
}, Open  ]],
Cell[33325, 848, 390, 9, 75, "Text",
  CellTags->{
  "infinite-dimensional Lie group", "discrete subgroup", 
    "similarity solution"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[33752, 862, 53, 0, 37, "Subsubsection"],
Cell[33808, 864, 395, 6, 96, "Text",
  CellTags->"boundary value problem"],

Cell[CellGroupData[{
Cell[34228, 874, 74, 1, 27, "Input"],
Cell[34305, 877, 72, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34414, 883, 60, 1, 27, "Input"],
Cell[34477, 886, 189, 5, 30, "Output"]
}, Open  ]],
Cell[34681, 894, 406, 10, 75, "Text",
  CellTags->{"invariance of the boundary conditions", "infinitesimals"}],

Cell[CellGroupData[{
Cell[35112, 908, 116, 2, 27, "Input"],
Cell[35231, 912, 52, 1, 30, "Output"]
}, Open  ]],
Cell[35298, 916, 299, 11, 54, "Text"],

Cell[CellGroupData[{
Cell[35622, 931, 68, 1, 27, "Input"],
Cell[35693, 934, 62, 1, 30, "Output"]
}, Open  ]],
Cell[35770, 938, 168, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[35963, 947, 184, 5, 38, "Input"],
Cell[36150, 954, 104, 2, 42, "Output"]
}, Open  ]],
Cell[36269, 959, 47, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[36341, 963, 151, 3, 45, "Input"],
Cell[36495, 968, 77, 1, 30, "Output"]
}, Open  ]],
Cell[36587, 972, 149, 4, 33, "Text",
  CellTags->"group constants"],

Cell[CellGroupData[{
Cell[36761, 980, 83, 1, 27, "Input"],
Cell[36847, 983, 125, 2, 30, "Output"]
}, Open  ]],
Cell[36987, 988, 147, 4, 33, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[37159, 996, 151, 3, 45, "Input"],
Cell[37313, 1001, 65, 1, 30, "Output"]
}, Open  ]],
Cell[37393, 1005, 247, 6, 54, "Text",
  Evaluatable->False,
  CellTags->"LieRedunction[]"],

Cell[CellGroupData[{
Cell[37665, 1015, 296, 6, 45, "Input"],
Cell[37964, 1023, 459, 13, 65, "Output"]
}, Open  ]],
Cell[38438, 1039, 187, 6, 33, "Text",
  CellTags->"similarity form"],

Cell[CellGroupData[{
Cell[38650, 1049, 126, 3, 45, "Input"],
Cell[38779, 1054, 88, 1, 30, "Output"]
}, Open  ]],
Cell[38882, 1058, 134, 4, 33, "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[39041, 1066, 197, 4, 40, "Input"],
Cell[39241, 1072, 264, 8, 30, "Output"]
}, Open  ]],
Cell[39520, 1083, 240, 6, 54, "Text",
  CellTags->"LieReduction[]"],

Cell[CellGroupData[{
Cell[39785, 1093, 71, 1, 27, "Input"],
Cell[39859, 1096, 166, 3, 40, "Output"]
}, Open  ]],
Cell[40040, 1102, 333, 10, 54, "Text"],

Cell[CellGroupData[{
Cell[40398, 1116, 172, 4, 63, "Input"],
Cell[40573, 1122, 77, 1, 37, "Output"]
}, Open  ]],
Cell[40665, 1126, 245, 9, 54, "Text"],

Cell[CellGroupData[{
Cell[40935, 1139, 125, 3, 27, "Input"],
Cell[41063, 1144, 75, 1, 36, "Output"]
}, Open  ]],
Cell[41153, 1148, 54, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[41232, 1152, 80, 1, 27, "Input"],
Cell[41315, 1155, 155, 4, 40, "Output"]
}, Open  ]],
Cell[41485, 1162, 63, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[41573, 1166, 218, 4, 63, "Input"],
Cell[41794, 1172, 101, 2, 37, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41932, 1179, 40, 1, 27, "Input"],
Cell[41975, 1182, 109, 2, 38, "Output"]
}, Open  ]],
Cell[42099, 1187, 63, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[42187, 1191, 74, 1, 27, "Input"],
Cell[42264, 1194, 372, 8, 104, "Output"]
}, Open  ]],
Cell[42651, 1205, 951, 27, 119, "Text",
  CellTags->"temperature variation"],

Cell[CellGroupData[{
Cell[43627, 1236, 266, 4, 81, "Input"],
Cell[43896, 1242, 131278, 2925, 227, 76445, 2242, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[175189, 4170, 587, 9, 138, "Text",
  CellTags->{"temperature variation", "contour plot"}],

Cell[CellGroupData[{
Cell[175801, 4183, 257, 4, 81, "Input"],
Cell[176061, 4189, 66411, 1735, 258, 16040, 1109, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[242487, 5927, 307, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"symmetries of PDEs"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[242843, 5941, 114, 1, 49, "Subsection",
  CellTags->"Single Flux Line in Superconductors"],
Cell[242960, 5944, 775, 14, 138, "Text",
  CellTags->{
  "single flux line in superconductors", "low temperature dynamics", 
    "type-II superconductor", "Lorentz force", "depinning threshold"}],

Cell[CellGroupData[{
Cell[243760, 5962, 189, 4, 43, "Input"],
Cell[243952, 5968, 389, 12, 45, "Output"]
}, Open  ]],
Cell[244356, 5983, 939, 21, 180, "Text",
  CellTags->{"flux line", "Lie[]"}],

Cell[CellGroupData[{
Cell[245320, 6008, 62, 1, 27, "Input"],
Cell[245385, 6011, 40, 1, 30, "Output"]
}, Open  ]],
Cell[245440, 6015, 43, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[245508, 6019, 57, 1, 27, "Input"],
Cell[245568, 6022, 37, 1, 30, "Output"]
}, Open  ]],
Cell[245620, 6026, 115, 1, 33, "Text",
  CellTags->"parameters of the equation"],

Cell[CellGroupData[{
Cell[245760, 6031, 49, 1, 27, "Input"],
Cell[245812, 6034, 37, 1, 30, "Output"]
}, Open  ]],
Cell[245864, 6038, 607, 16, 96, "Text",
  CellTags->{
  "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}],

Cell[CellGroupData[{
Cell[246496, 6058, 84, 1, 27, "Input"],
Cell[246583, 6061, 73, 1, 30, "Output"]
}, Open  ]],
Cell[246671, 6065, 93, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[246789, 6072, 276, 4, 99, "Input"],
Cell[247068, 6078, 232, 4, 90, "Output"]
}, Open  ]],
Cell[247315, 6085, 1014, 30, 117, "Text",
  CellTags->{
  "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
    "LieSolve[]", "LieStructureForm[]"}],
Cell[248332, 6117, 152, 2, 63, "Input"],
Cell[248487, 6121, 247, 5, 54, "Text",
  CellTags->{"data basis", "determination of the symmetries"}],

Cell[CellGroupData[{
Cell[248759, 6130, 43, 0, 37, "Subsubsection"],
Cell[248805, 6132, 284, 8, 54, "Text",
  CellTags->"symmetry analysis"],

Cell[CellGroupData[{
Cell[249114, 6144, 65, 1, 27, "Input"],
Cell[249182, 6147, 712, 24, 57, "Output"]
}, Open  ]],
Cell[249909, 6174, 1037, 26, 138, "Text",
  CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}],
Cell[250949, 6202, 931, 21, 159, "Text",
  CellTags->{"LieSolve[]", "FinalResult"}],

Cell[CellGroupData[{
Cell[251905, 6227, 103, 2, 27, "Input"],
Cell[252011, 6231, 10800, 332, 569, "Output"]
}, Open  ]],
Cell[262826, 6566, 532, 14, 75, "Text",
  CellTags->{"symbolic names", "Result2", "infinitesimals"}],

Cell[CellGroupData[{
Cell[263383, 6584, 40, 1, 27, "Input"],
Cell[263426, 6587, 222, 4, 70, "Output"]
}, Open  ]],
Cell[263663, 6594, 828, 20, 138, "Text",
  CellTags->{"remaining equations", "PDESolve[]"}],
Cell[264494, 6616, 228, 5, 54, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[264747, 6625, 328, 6, 63, "Input"],
Cell[265078, 6633, 47, 1, 30, "Output"]
}, Open  ]],
Cell[265140, 6637, 245, 5, 54, "Text",
  Evaluatable->False,
  CellTags->"moving wave solution"],

Cell[CellGroupData[{
Cell[265410, 6646, 251, 5, 45, "Input"],
Cell[265664, 6653, 465, 13, 63, "Output"]
}, Open  ]],
Cell[266144, 6669, 71, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[266240, 6674, 155, 4, 27, "Input"],
Cell[266398, 6680, 2043, 44, 113, "Output"]
}, Open  ]],
Cell[268456, 6727, 347, 10, 54, "Text",
  Evaluatable->False,
  CellTags->"solution of Tang's equation"],
Cell[268806, 6739, 170, 6, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[269001, 6749, 342, 6, 81, "Input"],
Cell[269346, 6757, 58, 1, 30, "Output"]
}, Open  ]],
Cell[269419, 6761, 62, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[269506, 6766, 251, 5, 45, "Input"],
Cell[269760, 6773, 624, 19, 79, "Output"]
}, Open  ]],
Cell[270399, 6795, 178, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[270602, 6804, 133, 3, 27, "Input"],
Cell[270738, 6809, 68, 1, 30, "Output"]
}, Open  ]],
Cell[270821, 6813, 332, 9, 54, "Text",
  Evaluatable->False,
  CellTags->{
  "similarity representation", "implicit representation of the solution"}],

Cell[CellGroupData[{
Cell[271178, 6826, 140, 4, 27, "Input"],
Cell[271321, 6832, 77, 1, 45, "Output"]
}, Open  ]],
Cell[271413, 6836, 1706, 55, 180, "Text",
  Evaluatable->False,
  CellTags->{"circle", "animation"}],
Cell[273122, 6893, 58, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[273205, 6898, 444, 8, 97, "Input"],

Cell[CellGroupData[{
Cell[273674, 6910, 25609, 1353, 254, 9540, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[299286, 8265, 25595, 1353, 254, 9526, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[324884, 9620, 25371, 1350, 254, 9537, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[350258, 10972, 25319, 1349, 254, 9546, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[375580, 12323, 25027, 1346, 254, 9537, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[400610, 13671, 24955, 1345, 254, 9538, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[425568, 15018, 24658, 1341, 254, 9537, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[450229, 16361, 24493, 1339, 254, 9514, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[474725, 17702, 24326, 1337, 254, 9521, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[499054, 19041, 24400, 1338, 254, 9530, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[523457, 20381, 23935, 1332, 254, 9535, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[547395, 21715, 24080, 1334, 254, 9546, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[571478, 23051, 23780, 1331, 254, 9513, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[595261, 24384, 22823, 1318, 253, 9546, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[618087, 25704, 23595, 1328, 254, 9523, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[641685, 27034, 23468, 1326, 254, 9538, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[665156, 28362, 22984, 1321, 254, 9531, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[688143, 29685, 22764, 1318, 254, 9546, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[710910, 31005, 22552, 1315, 254, 9537, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[733465, 32322, 22452, 1314, 254, 9530, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[755920, 33638, 21668, 1304, 254, 9528, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[777591, 34944, 21482, 1302, 254, 9524, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[799076, 36248, 20995, 1296, 254, 9523, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[820074, 37546, 20603, 1291, 254, 9532, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[840680, 38839, 18685, 1134, 254, 8335, 1000, "GraphicsData", \
"PostScript", "Graphics"]
}, Closed]]
}, Open  ]],
Cell[859392, 39977, 326, 10, 54, "Text",
  Evaluatable->False,
  CellTags->"solution of Tang's equation"],

Cell[CellGroupData[{
Cell[859743, 39991, 123, 3, 27, "Input"],
Cell[859869, 39996, 146, 2, 37, "Output"]
}, Open  ]],
Cell[860030, 40001, 545, 16, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[860600, 40021, 281, 5, 59, "Input"],
Cell[860884, 40028, 100322, 1880, 277, 10852, 771, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[961221, 41911, 151, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

