(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    359743,      11814]*)
(*NotebookOutlinePosition[    365320,      11971]*)
(*  CellTagsIndexPosition[    364501,      11947]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.5 Stokes' Solution of the Creeping Flow", "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 60}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Stokes' Solution of the Creeping Flow"],

Cell[TextData[{
  "Let us consider the creeping motion of a fluid stream of speed ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  " around a solid sphere of radius ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ". The physical situation is shown in the following figure."
}], "Text",
  CellTags->"creeping motion of a fluid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.455556 0.126984 0.397778 0.126984 [
[.02381 .39778 -5 -7.5 ]
[.02381 .39778 5 7.5 ]
[.45556 .56286 -11 -7.5 ]
[.45556 .56286 11 7.5 ]
[.60794 .49937 -5 -7.5 ]
[.60794 .49937 5 7.5 ]
[.45556 .01683 -53.5 -7.5 ]
[.45556 .01683 53.5 7.5 ]
[.60794 .43587 -5 -7.5 ]
[.60794 .43587 5 7.5 ]
[.81111 .53746 -7.5 -7.5 ]
[.81111 .53746 7.5 7.5 ]
[.64603 .68984 -7.5 -7.5 ]
[.64603 .68984 7.5 7.5 ]
[ 0 0 0 0 ]
[ 1 .70667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
.0746 .14381 m
.20159 .14381 L
s
% Start of user PostScript
-3. -2. -2. -2. MAarrowhead1
% End of user PostScript
.0746 .2073 m
.20159 .2073 L
s
% Start of user PostScript
-3. -1.5 -2. -1.5 MAarrowhead1
% End of user PostScript
.0746 .27079 m
.20159 .27079 L
s
% Start of user PostScript
-3. -1. -2. -1. MAarrowhead1
% End of user PostScript
.0746 .33429 m
.20159 .33429 L
s
% Start of user PostScript
-3. -0.5 -2. -0.5 MAarrowhead1
% End of user PostScript
.0746 .39778 m
.20159 .39778 L
s
% Start of user PostScript
-3. 0 -2. 0 MAarrowhead1
% End of user PostScript
.0746 .46127 m
.20159 .46127 L
s
% Start of user PostScript
-3. 0.5 -2. 0.5 MAarrowhead1
% End of user PostScript
.0746 .52476 m
.20159 .52476 L
s
% Start of user PostScript
-3. 1. -2. 1. MAarrowhead1
% End of user PostScript
.0746 .58825 m
.20159 .58825 L
s
% Start of user PostScript
-3. 1.5 -2. 1.5 MAarrowhead1
% End of user PostScript
1 0 0 r
.45556 .39778 m
.45556 .39778 .12698 0 365.73 arc
F
0 g
.45556 .39778 m
.83651 .39778 L
s
.45556 .39778 m
.70952 .52476 L
s
% Start of user PostScript
0 0 2. 1. MAarrowhead1
% End of user PostScript
.72222 .52603 m
.97619 .66444 L
s
% Start of user PostScript
2.1 1.01 4.1 2.1 MAarrowhead1
% End of user PostScript
.72222 .52603 m
.64603 .65175 L
s
% Start of user PostScript
2.1 1.01 1.5 2. MAarrowhead1
% End of user PostScript
gsave
.02381 .39778 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(U) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.45556 .56286 -72 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(r) show
69.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
gsave
.60794 .49937 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(r) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.45556 .01683 -114.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Coordinate) show
129.000000 14.437500 moveto
(system) show
165.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.60794 .43587 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(q) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
gsave
.81111 .53746 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(r) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.64603 .68984 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 16.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(q) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
0 0 m
1 0 L
1 .70667 L
0 .70667 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{216, 159.5},
  ImageMargins->{{55.3125, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  FontSize->8,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>0000aa000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool009Ioo`<007Eoo`00V7oo00<007ooOol0Lgoo000mOol3
0004Ool40004Ool40003Ool50004Ool300000goo00000002Ool50002Ool3000017oo000000000Woo
0`0000=oo`0000000goo0`0017oo1@0017oo1@001Woo00<007ooOol00Woo1@001Goo0`0017oo1@00
00Eoo`00000007oo00800003Ool007oo055oo`00?7oo00D007ooOomoo`00009oo`03001oogoo009o
o`04001oogoo0004Ool01@00Oomoogoo00001Woo00@007ooOomoo`8000Eoo`03001oogoo00=oo`05
001oogooOol00002Ool01000Oomoogoo0P000goo00D007ooOomoo`00009oo`03001oogoo00Moo`03
001oogoo009oo`03001oogoo009oo`03001oo`0000=oo`03001oogoo009oo`05001oogooOol00003
Ool01000Oomoo`001goo00@007ooOol0009oo`03001oogoo051oo`00>goo00<007ooOol01Goo00<0
07ooOol00Woo00@007ooOol000Aoo`05001oogooOol00006Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00D007ooOomoo`0000Ioo`03
001oogoo00aoo`03001oogoo009oo`03001oo`0000Qoo`05001oogooOol00006Ool00`00Oomoo`05
Ool01000Oomoo`000Woo00<007ooOol0D7oo000kOol00`00Oomoo`05Ool00`00Oomoo`02Ool01000
Oomoo`0017oo00D007ooOomoo`0000Ioo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00=o
o`05001oogooOol00003Ool50003Ool00`00Oomoo`04Ool60005Ool40004Ool01@00Oomoogoo0000
0goo100017oo00<007ooOol017oo1P000Woo00@007ooOol0009oo`03001oogoo051oo`00>goo00<0
07ooOol01Goo00<007ooOol00Woo00@007ooOol000Aoo`04001oogooOol20005Ool01000Oomoogoo
0P001Goo00<007ooOol00goo0P000Woo00@007ooOol000Aoo`05001oogooOol00006Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00@007ooOol000Aoo`05
001oogooOol00006Ool00`00Oomoo`02Ool00`00Oomoo`0200001Goo000007oo0000DWoo000kOol0
0`00Oomoo`06Ool40004Ool40003Ool2000017oo000000000goo0`0000=oo`00Ool00Woo0`0017oo
0P0000=oo`00000017oo10000goo1@0017oo10001Woo1@000Woo0`0000Aoo`000000009oo`D0009o
o`D000Aoo`@0009oo`800005Ool007ooOol0001COol003aoo`05001oogooOol0000OOol00`00Oomo
o`0IOol00`00Oomoo`0WOol00`00Oomoo`1UOol003eoo`@001ioo`8000Eoo`03001oogoo0:Eoo`00
ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00
ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo000YOol3003ROol002Uoo`L00=ioo`00:Goo2`00fWoo000DOolS003G
Ool002Uoo``00=Uoo`00:Goo2@00g7oo000YOol5003POol002Uoo`800>=oo`00ogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00
:Goo0`00hWoo000YOol7003NOol002Uoo`/00=Yoo`0057oo8`00egoo000YOol<003IOol002Uoo`T0
0=aoo`00:Goo1@00h7oo000YOol2003SOol00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00
ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool002Uoo`<00>9oo`00:Goo1`00gWoo
000YOol;003JOol001Aoob<00=Moo`00:Goo3000@Goo27`0T7oo000YOol9000oOolBO02;Ool002Uo
o`D0041ooaUl08Moo`00:Goo0P00@7oo7g`0Q7oo001YOolRO023Ool006QoobEl085oo`00IWoo:7`0
P7oo001UOolZO01oOol006Aoobal07ioo`00Hgoo;g`0O7oo001QOolbO01kOol0061oocAl07Yoo`00
H7oo=G`0NGoo000YOol3000cOolfO01iOol002Uoo`L002ioocQl07Qoo`00:Goo2`00:Goo>W`0Mgoo
000DOolS000VOoljO01gOol002Uoo``002Moocal07Ioo`00:Goo2@00:Woo?G`0MGoo000YOol5000^
OolmO01eOol002Uoo`80031oocil07Eoo`00Fgoo?g`0M7oo001JOom0O01dOol005Yood5l07=oo`00
FWoo@G`0Lgoo001IOom2O01cOol005Uood9l07=oo`00FGoo@g`0LWoo001IOom3O01bOol005Uood=l
079oo`00:Goo0`00;7ooA7`0LWoo0006Ool3000POol7000XOom4O01bOol000Eoo`05001oogooOol0
000OOol;000TOom4O01bOol000Eoo`05001oogooOol0000:OolS000QOolRO01W000]Ool000Eoo`05
001oogooOol0000OOol<000SOolSO002000OO01bOol000Eoo`05001oogooOol0000OOol9000VOolU
O002000MO01bOol000Eoo`05001oogooOol0000OOol5000ZOolWO002000KO01bOol000Eoo`05001o
ogooOol0000OOol2000]OolYO002000IO01bOol000Aoo`<00004Ool00000001>OolZO002000GO01b
Ool005Uoobal008001El079oo`00FGoo;W`00P004W`0Lgoo001IOol`O002000@O006Ool4001YOol0
05Uooc9l008000il00Eoo`03001oogoo009oo`03001oogoo06Ioo`00FWoo<g`00P0037`01Goo00<0
07ooOol00goo00<007ooOol0IGoo001JOoleO002000:O005Ool00`00Oomoo`03Ool00`00Oomoo`1U
Ool005YoocMl008000Ml00Ioo`L006Moo`00Fgoo>7`00P0017`01goo00<007ooOol00goo00<007oo
Ool0IGoo000YOol3000`OoliO0020002O008Ool00`00Oomoo`02Ool00`00Oomoo`1UOol002Uoo`L0
02aooc]l008000Uoo`@006Qoo`00:Goo2`00:7oo?7`000=oo`000000Lgoo000DOolS000VOoljO004
Ool2001aOol002Uoo`/002UoocYl00Ioo`8006moo`00:Goo1`00;Woo>7`02Goo0P00KGoo000YOol3
000bOolgO00<Ool2001[Ool005moocIl00ioo`8006Uoo`00H7oo=7`04Goo0P00Igoo001QOolbO00D
Ool2001UOol0069ooc1l01Moo`8006=oo`00Hgoo;W`03goo1@001Woo0P001Woo00<007ooOol0F7oo
001TOol/O00AOol00`00Oomoo`09Ool20003Ool3001IOol006EoobYl019oo`03001oogoo00]oo`80
0003Ool0000000<005Moo`00IWoo:7`04goo00<007ooOol03Goo1`00EWoo001WOolVO00DOol2000>
Ool8001EOol006Uoob5l01Ioo`800004Ool00000000:Ool:001DOol002Uoo`<0041ooaal02Qoo`/0
05=oo`00:Goo1`00?Woo6G`0;7oo2P00DGoo000YOol;000mOolBO00dOol7000MOol3000`Ool001Ao
ob<003eoo`al03aoo`<0009oo`03001oogoo01Qoo`03001oogoo02moo`00:Goo2`00S7oo00@007oo
0000015oo`800003Ool00000009oo`03001oogoo02moo`00:Goo1`00T7oo00@007ooOomoo`8000io
o`03001oogoo0080009oo`@002moo`00:Goo0`00Tgoo00<007ooOol017oo0P0037oo00D007ooOomo
o`0003Eoo`00_goo00<007ooOol01Woo0P002Woo00D007ooOomoo`0003Eoo`00_Woo00<007ooOol0
2Goo0P0027oo00D007ooOomoo`0003Eoo`00_Goo00<007ooOol037oo00<007ooOol017oo0P000Woo
0P00=Goo002mOol00`00Oomoo`0=Ool2000oOol0071oo`D000]oo`<00003Ool0000003Ioo`03001o
ogoo011oo`8003eoo`00LGoo00<007ooOol00goo1P000Woo00@007ooOomoo`8003Moo`03001oogoo
019oo`8003]oo`00LGoo00<007ooOol02goo00<007ooOol00Woo00<007ooOol0=7oo00<007ooOol0
5Goo0P00>Goo001aOol00`00Oomoo`03Ool60003Ool5000fOol00`00Oomoo`0GOol2000gOol0075o
o`8000aoo`03001oogoo009oo`03001oogoo03=oo`03001oogoo01Yoo`03001oogoo03Aoo`00L7oo
0P0000Aoo`00000000Yoo`@003Eoo`03001oogoo01aoo`8003Aoo`00:Goo0`00SGoo00<007ooOol0
7Woo0P00<Woo000YOol70028Ool00`00Oomoo`0QOol2000`Ool002Uoo`/008Aoo`03001oogoo02=o
o`8002ioo`0057oo8`00P7oo00<007ooOol09Woo0P00;7oo000YOol;0022Ool00`00Oomoo`0YOol0
0`00Oomoo`0YOol002Uoo`L008Ioo`03001oogoo02Yoo`8002Uoo`00:Goo0`00RGoo00<007ooOol0
;Goo0P009goo002aOol20002Ool00`00Oomoo`0_Ool2000UOol00;5oo`@003Aoo`8002=oo`00/7oo
1`00=7oo0P008Goo002`Ool8000eOol2000OOol00;1oo`L003Qoo`03001oogoo01aoo`00[goo1`00
>Woo0P0077oo002_Ool6000mOol2000JOol00:moo`D0041oo`8000Eoo`03001oogoo011oo`00[goo
1000@goo0P000Woo0`004Goo002^Ool40016Ool6000@Ool00:ioo`<004Qoo`H000moo`00[Woo0P00
BGoo20003Goo002]Ool20019Ool:000<Ool00:eoo`03001oogoo04Qoo`/000]oo`00ngoo2@002Woo
003oOol60009Ool00?moo`Aoo`<000Qoo`00ogoo3goo002_Ool2001MOol00:ioo`04001oogoo001L
Ool00:Uoo`800004Ool000000003Ool00`00Oomoo`1IOol00:Qoo`03001oogoo00800003Ool00000
00<005]oo`00Z7oo00D007ooOomoo`00009oo`04001oogoo001KOol00:Qoo`05001oogooOol00003
Ool2001LOol00:Qoo`05001oogooOol0001QOol00:Moo`80009oo`80065oo`00ogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {198.375, 0}} -> {-3.61856, -3.27661, \
0.0368825, 0.0368825}}],

Cell[TextData[{
  "It is convenient to use spherical coordinates (",
  StyleBox["r",
    FontSlant->"Italic"],
  ", \[Theta]). We choose the origin of \[Theta] in such a way that \[Theta] \
= 0 defines the direction of ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  ". The velocity components ",
  Cell[BoxData[
      \(TraditionalForm\`u\_r\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\[Theta]\)]],
  " are related to the Stokes stream function \[CapitalPsi] in spherical \
coordinates by the relations "
}], "Text",
  CellTags->"Stokes stream function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StreamFunction = {
        ur \[Rule] 
          Function[{r, \[Theta]}, 
            \[PartialD]\_\[Theta] \[CapitalPsi][r, \[Theta]]\/\(r\^2\ 
                Sin[\[Theta]]\)], \n\t\t
        uth \[Rule] 
          Function[{r, \[Theta]}, 
            \(-\(\[PartialD]\_r \[CapitalPsi][r, \[Theta]]\/\(r\ 
                    Sin[\[Theta]]\)\)\)]}\)], "Input"],

Cell[BoxData[
    \({ur \[Rule] 
        Function[{r, \[Theta]}, 
          \[PartialD]\_\[Theta] \[CapitalPsi][r, \[Theta]]\/\(r\^2\ 
              Sin[\[Theta]]\)], 
      uth \[Rule] 
        Function[{r, \[Theta]}, 
          \(-\(\[PartialD]\_r \[CapitalPsi][r, \[Theta]]\/\(r\ 
                  Sin[\[Theta]]\)\)\)]}\)], "Output"]
}, Open  ]],

Cell["\<\
In the case of creep flows, the motion has a Reynolds number much \
less than unity. A consequence of this fact is that we can neglect \
acceleration terms in the momentum equation. The momentum equation for the \
stream function is derived by applying the Laplacian in spherical \
coordinates:\
\>", "Text",
  CellTags->{
  "Reynolds number", "momentum equation", "stream function", "Laplacian"}],

Cell[BoxData[
    \(Operator[expr_] := 
      \[PartialD]\_{r, 2}expr + \[PartialD]\_{\[Theta], 2}expr\/r\^2 - 
        \(Cot[\[Theta]]\ \[PartialD]\_\[Theta] expr\)\/r\^2\)], "Input"],

Cell[TextData[
"Applying this operator twice to the stream function \[CapitalPsi], we find \
the governing equation"], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Momentum = Operator[Operator[\[CapitalPsi][r, \[Theta]]]]; 
    Momentum // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  
                  StyleBox[
                    \(\(6\ Cot[\[Theta]]\ \[CapitalPsi]\_\[Theta]\)\/r\^4\),
                    ScriptLevel->0]}], "+", 
                
                StyleBox[
                  \(\(4\ Cot[\[Theta]]\ \[CapitalPsi]\_\(r, \[Theta]\)\)\/r\^3
                        \),
                  ScriptLevel->0], "+", 
                
                StyleBox[
                  \(\(6\ \[CapitalPsi]\_\(\[Theta], \[Theta]\)\)\/r\^4\),
                  ScriptLevel->0], "-", 
                
                StyleBox[
                  \(\(Cot[\[Theta]]\ \[CapitalPsi]\_\(r, r, \[Theta]\)\)\/r\^2
                        \),
                  ScriptLevel->0], "-", 
                
                StyleBox[
                  \(\(4\ \[CapitalPsi]\_\(r, \[Theta], \[Theta]\)\)\/r\^3\),
                  ScriptLevel->0], "-", 
                StyleBox[
                  FractionBox[
                    RowBox[{\(Cot[\[Theta]]\), " ", 
                      RowBox[{"(", 
                        RowBox[{
                          
                          StyleBox[
                            \(\(Csc[\[Theta]]\^2\ \[CapitalPsi]\_\[Theta]\)\/r
                                  \^2\),
                            ScriptLevel->0], "-", 
                          
                          StyleBox[
                            \(\(Cot[\[Theta]]\ 
                                  \[CapitalPsi]\_\(\[Theta], \[Theta]\)\)\/r
                                  \^2\),
                            ScriptLevel->0], "+", 
                          \(\[CapitalPsi]\_\(r, r, \[Theta]\)\), "+", 
                          
                          StyleBox[
                            \(\[CapitalPsi]\_\(\[Theta], \[Theta], 
                                  \[Theta]\)\/r\^2\),
                            ScriptLevel->0]}], ")"}]}], \(r\^2\)],
                  ScriptLevel->0], "+", \(\[CapitalPsi]\_\(r, r, r, r\)\), 
                "+", 
                
                StyleBox[
                  \(\[CapitalPsi]\_\(r, r, \[Theta], \[Theta]\)\/r\^2\),
                  ScriptLevel->0], "+", 
                StyleBox[
                  RowBox[{\(1\/r\^2\), 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"-", 
                          
                          StyleBox[
                            \(\(2\ Cot[\[Theta]]\ Csc[\[Theta]]\^2\ 
                                  \[CapitalPsi]\_\[Theta]\)\/r\^2\),
                            ScriptLevel->0]}], "+", 
                        \(\(2\ Csc[\[Theta]]\^2\ 
                              \[CapitalPsi]\_\(\[Theta], \[Theta]\)\)\/r\^2
                              \), "-", 
                        \(\(Cot[\[Theta]]\ 
                              \[CapitalPsi]\_\(\[Theta], \[Theta], 
                                \[Theta]\)\)\/r\^2\), "+", 
                        \(\[CapitalPsi]\_\(r, r, \[Theta], \[Theta]\)\), "+", 
                        \(\[CapitalPsi]\_\(\[Theta], \[Theta], \[Theta], 
                              \[Theta]\)\/r\^2\)}], ")"}]}],
                  ScriptLevel->0]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting equation is a fourth-order linear partial differential \
equation in spherical coordinates. The equation, although linear, contains a \
lot of analytic coefficients. This linear equation is an example to test the \
reliability of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". Extending our database by creating another file called ",
  StyleBox["stokes.dgl", "MmaText",
    FontSlant->"Italic"],
  " containing the information on this equation helps us to derive the \
symmetries of the equation:"
}], "Text",
  CellTags->"fourth-order linear PDE"],

Cell[BoxData[
    \(LieEquations[
      "\<stokes.dgl\>", {Momentum}, {\[CapitalPsi]}, {r, \[Theta]}, {}, \n
      \t{"\<Creeping flow for an immersed sphere\>"}, \n
      \t{{"\<G.G. Stokes\>"}, \n
        \t\t{"\<Trans. Camb. Phil. Soc. 9, 8-106, (1851)\>"}}, 
      SubstitutionRules 
        \[Rule] {\[PartialD]\_{r, 4}\[CapitalPsi][r, \[Theta]]}]\)], "Input",
  CellTags->"LieEquations[]"],

Cell["\<\
The Lie point symmetries of the momentum equation are derived by \
\
\>", "Text",
  Evaluatable->False,
  CellTags->"Lie point symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieSolve["\<stokes.dgl\>"] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-3\)\ Cot[\[Theta]]\ \((2 + Csc[\[Theta]]\^2)\)\ 
                  \((\[ScriptCapitalF]\_1)\)\_\[Theta] + 
                4\ r\ Cot[\[Theta]]\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(r, \[Theta]\) + 
                \((6 + Cot[\[Theta]]\^2 + 2\ Csc[\[Theta]]\^2)\)\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(\[Theta], \[Theta]\) - 
                2\ r\^2\ Cot[\[Theta]]\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(r, r, \[Theta]\) - 
                4\ r\ \((\[ScriptCapitalF]\_1)\)\_\(r, \[Theta], \[Theta]\) - 
                2\ Cot[\[Theta]]\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(\[Theta], \[Theta], 
                    \[Theta]\) + 
                r\^4\ \((\[ScriptCapitalF]\_1)\)\_\(r, r, r, r\) + 
                2\ r\^2\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(r, r, \[Theta], \[Theta]\) + 
                \((\[ScriptCapitalF]\_1)\)\_\(\[Theta], \[Theta], \[Theta], 
                  \[Theta]\) == 0\)},
          {\(\[Xi]\_2 == 0\)},
          {\(\[Xi]\_1 == k2\ r\)},
          {\(\[Phi]\_1 == k1\ \[CapitalPsi] + \[ScriptCapitalF]\_1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -3, 
              Cot[ \[Theta]], 
              Plus[ 2, 
                Power[ 
                  Csc[ \[Theta]], 2]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], \[Theta]]], 
            Times[ 4, r, 
              Cot[ \[Theta]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, \[Theta]]], 
            Times[ 
              Plus[ 6, 
                Power[ 
                  Cot[ \[Theta]], 2], 
                Times[ 2, 
                  Power[ 
                    Csc[ \[Theta]], 2]]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], \[Theta], \[Theta]]], 
            Times[ -2, 
              Power[ r, 2], 
              Cot[ \[Theta]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, r, \[Theta]]], 
            Times[ -4, r, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, \[Theta], \[Theta]]], 
            Times[ -2, 
              Cot[ \[Theta]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], \[Theta], \[Theta], 
                \[Theta]]], 
            Times[ 
              Power[ r, 4], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, r, r, r]], 
            Times[ 2, 
              Power[ r, 2], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, r, \[Theta], 
                \[Theta]]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], \[Theta], \[Theta], \[Theta], 
              \[Theta]]], 0], 
        Equal[ 
          Subscript[ \[Xi], 2], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ k2, r]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ k1, \[CapitalPsi]], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The analysis shows that Stokes",
  "'",
  " model of creeping flow owns an infinite symmetry as expected for linear \
equations. The continuous part of the symmetry group is determined by the \
arbitrary function ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            RowBox[{
              FormBox[
                RowBox[{\(\[ScriptCapitalF]\_1\), " ", "=", 
                  StyleBox["free",
                    FontSlant->"Italic"]}],
                "TraditionalForm"], "[", "1", "]"}], "[", \(r, \[Theta]\), 
            "]"}],
          "MmaText"], TraditionalForm]]],
  ". The function ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalF]\_1\)]],
  " has to satisfy the original linear fourth-order PDE. The two constants ",
  StyleBox["k1", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "and ",
  StyleBox["k2", "MmaText",
    FontSlant->"Italic"],
  " are the determining elements of the finite group representing a scaling \
symmetry of the momentum equation. Knowing that the momentum equation allows \
only a scaling symmetry, we can use this information to reduce the PDE to an \
ODE. The application of the function ",
  StyleBox["LieReduction[]", "MmaText"],
  " delivers for the scaling group ",
  StyleBox["k1=1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k2=\[Alpha]",
    FontSlant->"Italic"],
  " an ordinary differential equation of fourth order. Unfortunately, this \
ODE is not solvable by ",
  StyleBox["DSolve[]", "MmaText"],
  "."
}], "Text",
  CellTags->{
  "Stokes' model", "finite group", "scaling symmetry", "LieReduction[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rmoment = 
      LieReduction[{Momentum}, {\[CapitalPsi]}, {r, \[Theta]}, {r, 0}, {
          \[Alpha]\ \[CapitalPsi]}]; 
    LTF[Flatten[rmoment]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\[Theta] - \[Zeta]\_1 == 0\)},
          {\(r\^\(-\[Alpha]\)\ \[CapitalPsi] - F\_1 == 0\)},
          {
            \(r\^\[Alpha]\ 
                \((\(-6\)\ \[Alpha]\ F\_1 + 11\ \[Alpha]\^2\ F\_1 - 
                    6\ \[Alpha]\^3\ F\_1 + \[Alpha]\^4\ F\_1 - 
                    6\ Cot[\[Zeta]\_1]\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    6\ \[Alpha]\ Cot[\[Zeta]\_1]\ 
                      \((F\_1)\)\_\(\[Zeta]\_1\) - 
                    2\ \[Alpha]\^2\ Cot[\[Zeta]\_1]\ 
                      \((F\_1)\)\_\(\[Zeta]\_1\) - 
                    3\ Cot[\[Zeta]\_1]\ Csc[\[Zeta]\_1]\^2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    6\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                    6\ \[Alpha]\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                    2\ \[Alpha]\^2\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                    Cot[\[Zeta]\_1]\^2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                    2\ Csc[\[Zeta]\_1]\^2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                    2\ Cot[\[Zeta]\_1]\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                    \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                      \[Zeta]\_1\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"A closer look at the above result reveals that the stream function \
\[CapitalPsi] can be represented by a product of a radial component and a \
function containing the angular part:"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(stream = 
      \[CapitalPsi] \[Rule] 
        Function[{r, \[Theta]}, r\^\[Alpha]\ g[\[Theta]]]\)], "Input"],

Cell[BoxData[
    \(\[CapitalPsi] \[Rule] 
      Function[{r, \[Theta]}, r\^\[Alpha]\ g[\[Theta]]]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "We replaced ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " in the similarity solution by ",
  StyleBox["g",
    FontSlant->"Italic"],
  ". Inserting this result into the original equation, we get"
}], "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mom1 = Expand[\(Momentum /. stream\)\/r\^\(\(-4\) + \[Alpha]\)]; 
    mom1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-6\)\ g\ \[Alpha] + 11\ g\ \[Alpha]\^2 - 6\ g\ \[Alpha]\^3 + 
                g\ \[Alpha]\^4 - 6\ Cot[\[Theta]]\ g\_\[Theta] + 
                6\ \[Alpha]\ Cot[\[Theta]]\ g\_\[Theta] - 
                2\ \[Alpha]\^2\ Cot[\[Theta]]\ g\_\[Theta] - 
                3\ Cot[\[Theta]]\ Csc[\[Theta]]\^2\ g\_\[Theta] + 
                6\ g\_\(\[Theta], \[Theta]\) - 
                6\ \[Alpha]\ g\_\(\[Theta], \[Theta]\) + 
                2\ \[Alpha]\^2\ g\_\(\[Theta], \[Theta]\) + 
                Cot[\[Theta]]\^2\ g\_\(\[Theta], \[Theta]\) + 
                2\ Csc[\[Theta]]\^2\ g\_\(\[Theta], \[Theta]\) - 
                2\ Cot[\[Theta]]\ g\_\(\[Theta], \[Theta], \[Theta]\) + 
                g\_\(\[Theta], \[Theta], \[Theta], \[Theta]\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is an equation in ",
  StyleBox["r",
    FontSlant->"Italic"],
  " and \[Theta]. The remaining equation for ",
  StyleBox["g",
    FontSlant->"Italic"],
  " is a linear ODE of fourth order. This type of equation is equivalent with \
the equation gained by ",
  StyleBox["LieReduction[]", "MmaText"],
  ". Since we already noted that the equation is not solved by ",
  StyleBox["DSolve[]", "MmaText"],
  ", we try an ansatz for the angular part ",
  Cell[BoxData[
      \(TraditionalForm\`g(\[Theta])\)]],
  " by"
}], "Text",
  CellTags->{"DSolve[]", "LieReduction[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sub = g \[Rule] Function[\[Theta], Sin[\[Theta]]\^2]\)], "Input"],

Cell[BoxData[
    \(g \[Rule] Function[\[Theta], Sin[\[Theta]]\^2]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which reduces the determining equation for ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " to a polynomial in \[Alpha] of fourth order:"
}], "Text",
  CellTags->"determining equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pol = Simplify[mom1 /. sub]\)], "Input"],

Cell[BoxData[
    \(\((\(-8\) + 6\ \[Alpha] + 7\ \[Alpha]\^2 - 6\ \[Alpha]\^3 + \[Alpha]\^4)
        \)\ Sin[\[Theta]]\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pol1 = pol\/Sin[\[Theta]]\^2\)], "Input"],

Cell[BoxData[
    \(\(-8\) + 6\ \[Alpha] + 7\ \[Alpha]\^2 - 6\ \[Alpha]\^3 + 
      \[Alpha]\^4\)], "Output"]
}, Open  ]],

Cell[TextData[
"The solutions for the exponent \[Alpha] are found by solving this \
fourth-order polynomial"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(exponents = Solve[pol1 == 0, \[Alpha]]\)], "Input"],

Cell[BoxData[
    \({{\[Alpha] \[Rule] \(-1\)}, {\[Alpha] \[Rule] 1}, {
        \[Alpha] \[Rule] 2}, {\[Alpha] \[Rule] 4}}\)], "Output"]
}, Open  ]],

Cell["\<\
This list is the basis for a combination of the radial components\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(radialpart = r\^\[Alpha] /. exponents\)], "Input"],

Cell[BoxData[
    \({1\/r, r, r\^2, r\^4}\)], "Output"]
}, Open  ]],

Cell[TextData[
"Since the four solutions for \[Alpha] are independent of each other, a \
linear combination of the radial parts provides"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = Plus@@\((Table[c[i], {i, 1, 4}]\ radialpart)\)\)], "Input"],

Cell[BoxData[
    \(c[1]\/r + r\ c[2] + r\^2\ c[3] + r\^4\ c[4]\)], "Output"]
}, Open  ]],

Cell["The final representation for the stream function is thus", "Text",
  CellTags->"stream function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StreamF = f\ Sin[\[Theta]]\^2\)], "Input"],

Cell[BoxData[
    \(\((c[1]\/r + r\ c[2] + r\^2\ c[3] + r\^4\ c[4])\)\ Sin[\[Theta]]\^2\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Up to now, we did not consider any boundary conditions for the problem. As \
one boundary condition, we have to assume that the derivatives of the stream \
function with respect to ",
  StyleBox["r",
    FontSlant->"Italic"],
  " and \[Theta] vanish at the surface of the sphere. This results in"
}], "Text",
  CellTags->"boundary condition"],

Cell[CellGroupData[{

Cell[BoxData[
    \(surf1 = \((\[PartialD]\_r StreamF /. r \[Rule] a)\) == 0\)], "Input"],

Cell[BoxData[
    \(\((\(-\(c[1]\/a\^2\)\) + c[2] + 2\ a\ c[3] + 4\ a\^3\ c[4])\)\ 
        Sin[\[Theta]]\^2 == 0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(surf2 = \((\[PartialD]\_\[Theta] StreamF /. r \[Rule] a)\) == 0\)], 
  "Input"],

Cell[BoxData[
    \(2\ \((c[1]\/a + a\ c[2] + a\^2\ c[3] + a\^4\ c[4])\)\ Cos[\[Theta]]\ 
        Sin[\[Theta]] == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "These two non-slip conditions for the surface are sufficient to determine \
two of the four integration constants ",
  StyleBox["c[i]",
    FontSlant->"Italic"],
  ":"
}], "Text",
  CellTags->"non-slip condition"],

Cell[CellGroupData[{

Cell[BoxData[
    \(iconstants = Solve[{surf1, surf2}, {c[1], c[2], c[3], c[4]}]\)], "Input"],

Cell[BoxData[
    \(Solve::"svars" \( : \ \) 
      "Equations may not give solutions for all \"solve\" variables."\)], 
  "Message"],

Cell[BoxData[
    \({{c[1] \[Rule] 1\/2\ a\^3\ c[3] + 3\/2\ a\^5\ c[4], 
        c[2] \[Rule] \(-\(3\/2\)\)\ a\ c[3] - 5\/2\ a\^3\ c[4]}}\)], "Output"]
}, Open  ]],

Cell["The representation of the stream function reduces thus to", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StreamF = 
      \(Simplify[StreamF /. iconstants]\)\[LeftDoubleBracket]1
        \[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \(\(1\/\(2\ r\)\) 
      \((\((a - r)\)\^2\ 
          \((3\ a\^3\ c[4] + 6\ a\^2\ r\ c[4] + 
              2\ r\ \((c[3] + r\^2\ c[4])\) + a\ \((c[3] + 4\ r\^2\ c[4])\))
            \)\ Sin[\[Theta]]\^2)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "containing two arbitrary constants ",
  StyleBox["c", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[3]", "MmaText"],
  " and ",
  StyleBox["c", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[4]", "MmaText"],
  ". If we consider the stream function for large values of ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ", we observe that the dominant changes result from the ",
  Cell[BoxData[
      \(TraditionalForm\`r\^4\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`r\^2\)]],
  " terms in the solution:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[StreamF, {r, \[Infinity], 2}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(\(c[4]\ Sin[\[Theta]]\^2\)\/\((1\/r)\)\^4\), "+", 
        InterpretationBox[\(1\/O[1\/r]\^2\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, -4, -2, 1]]}],
      SeriesData[ r, 
        DirectedInfinity[ 1], {
        Times[ 
          c[ 4], 
          Power[ 
            Sin[ \[Theta]], 2]]}, -4, -2, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we assume that the radial and angular components of the velocity are \
finite for large ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ", we have to set ",
  StyleBox["c", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[4]", "MmaText"],
  StyleBox[" = 0", "MmaText",
    FontSlant->"Italic"],
  " and ",
  StyleBox["c",
    FontSlant->"Italic"],
  StyleBox["[3]", "MmaText"],
  StyleBox[" = U", "MmaText",
    FontSlant->"Italic"],
  StyleBox["/2", "MmaText"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StreamF = StreamF /. {c[4] \[Rule] 0, c[3] \[Rule] U\/2}\)], "Input"],

Cell[BoxData[
    \(\(\((a - r)\)\^2\ \((a + 2\ r)\)\ U\ Sin[\[Theta]]\^2\)\/\(4\ r\)\)], 
  "Output"]
}, Open  ]],

Cell[TextData["The stream function \[CapitalPsi] is thus defined by"], "Text"],

Cell[BoxData[
    \(\[CapitalPsi][r_, \[Theta]_, a_, U_] := 
      1\/4\ Sin[\[Theta]]\^2\ a\^2\ U\ 
        \((a\/r - \(3\ r\)\/a + \(2\ r\^2\)\/a\^2)\)\)], "Input"],

Cell["\<\
This representation in spherical coordinates can be used to display \
the stream function in a Cartesian coordinate system. To this end, we have to \
transform the coordinates by\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(coordTrafo = {r \[Rule] \@\(x\^2 + y\^2\), 
        \[Theta] \[Rule] ArcTan[x, y]}\)], "Input"],

Cell[BoxData[
    \({r \[Rule] \@\(x\^2 + y\^2\), \[Theta] \[Rule] ArcTan[x, y]}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "To suppress the singularities at ",
  StyleBox["x=0",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y=0",
    FontSlant->"Italic"],
  ", we introduce the condition"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ps = 
      If[x == 0 && y == 0, 0, 
        \[CapitalPsi][r, \[Theta], 1, 1]\  /. \ coordTrafo]\)], "Input"],

Cell[BoxData[
    \(If[x == 0 && y == 0, 0, \[CapitalPsi][r, \[Theta], 1, 1] /. coordTrafo]
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The representation of the stream function in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is thus given by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[{
        ContourPlot[ps, {x, \(-3\), 3}, {y, \(-3\), 3}, \n\t\t\t
          PlotPoints \[Rule] 25, ColorFunction \[Rule] Hue, 
          AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True, \n\t\t\t
          Contours \[Rule] 25, DisplayFunction \[Rule] Identity], 
        Graphics[Disk[{0, 0}, 1]]}, AspectRatio \[Rule] Automatic, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.18254 -0.0125 -6 -9 ]
[.18254 -0.0125 6 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -12 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .18254 -12 -4.5 ]
[-0.0125 .18254 0 4.5 ]
[-0.0125 .34127 -12 -4.5 ]
[-0.0125 .34127 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .65873 -6 -4.5 ]
[-0.0125 .65873 0 4.5 ]
[-0.0125 .81746 -6 -4.5 ]
[-0.0125 .81746 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 .5 0 -7.5 ]
[1.025 .5 10 7.5 ]
[.5 1.025 -5 0 ]
[.5 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(-3)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(-2)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(-1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(1)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(-3)] -0.0125 .02381 1 0 Mshowa
0 .18254 m
.00625 .18254 L
s
[(-2)] -0.0125 .18254 1 0 Mshowa
0 .34127 m
.00625 .34127 L
s
[(-1)] -0.0125 .34127 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .65873 m
.00625 .65873 L
s
[(1)] -0.0125 .65873 1 0 Mshowa
0 .81746 m
.00625 .81746 L
s
[(2)] -0.0125 .81746 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(3)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .05556 m
.00375 .05556 L
s
0 .0873 m
.00375 .0873 L
s
0 .11905 m
.00375 .11905 L
s
0 .15079 m
.00375 .15079 L
s
0 .21429 m
.00375 .21429 L
s
0 .24603 m
.00375 .24603 L
s
0 .27778 m
.00375 .27778 L
s
0 .30952 m
.00375 .30952 L
s
0 .37302 m
.00375 .37302 L
s
0 .40476 m
.00375 .40476 L
s
0 .43651 m
.00375 .43651 L
s
0 .46825 m
.00375 .46825 L
s
0 .53175 m
.00375 .53175 L
s
0 .56349 m
.00375 .56349 L
s
0 .59524 m
.00375 .59524 L
s
0 .62698 m
.00375 .62698 L
s
0 .69048 m
.00375 .69048 L
s
0 .72222 m
.00375 .72222 L
s
0 .75397 m
.00375 .75397 L
s
0 .78571 m
.00375 .78571 L
s
0 .84921 m
.00375 .84921 L
s
0 .88095 m
.00375 .88095 L
s
0 .9127 m
.00375 .9127 L
s
0 .94444 m
.00375 .94444 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.18254 .99375 m
.18254 1 L
s
.34127 .99375 m
.34127 1 L
s
.5 .99375 m
.5 1 L
s
.65873 .99375 m
.65873 1 L
s
.81746 .99375 m
.81746 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.05556 .99625 m
.05556 1 L
s
.0873 .99625 m
.0873 1 L
s
.11905 .99625 m
.11905 1 L
s
.15079 .99625 m
.15079 1 L
s
.21429 .99625 m
.21429 1 L
s
.24603 .99625 m
.24603 1 L
s
.27778 .99625 m
.27778 1 L
s
.30952 .99625 m
.30952 1 L
s
.37302 .99625 m
.37302 1 L
s
.40476 .99625 m
.40476 1 L
s
.43651 .99625 m
.43651 1 L
s
.46825 .99625 m
.46825 1 L
s
.53175 .99625 m
.53175 1 L
s
.56349 .99625 m
.56349 1 L
s
.59524 .99625 m
.59524 1 L
s
.62698 .99625 m
.62698 1 L
s
.69048 .99625 m
.69048 1 L
s
.72222 .99625 m
.72222 1 L
s
.75397 .99625 m
.75397 1 L
s
.78571 .99625 m
.78571 1 L
s
.84921 .99625 m
.84921 1 L
s
.88095 .99625 m
.88095 1 L
s
.9127 .99625 m
.9127 1 L
s
.94444 .99625 m
.94444 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .18254 m
1 .18254 L
s
.99375 .34127 m
1 .34127 L
s
.99375 .5 m
1 .5 L
s
.99375 .65873 m
1 .65873 L
s
.99375 .81746 m
1 .81746 L
s
.99375 .97619 m
1 .97619 L
s
.125 Mabswid
.99625 .05556 m
1 .05556 L
s
.99625 .0873 m
1 .0873 L
s
.99625 .11905 m
1 .11905 L
s
.99625 .15079 m
1 .15079 L
s
.99625 .21429 m
1 .21429 L
s
.99625 .24603 m
1 .24603 L
s
.99625 .27778 m
1 .27778 L
s
.99625 .30952 m
1 .30952 L
s
.99625 .37302 m
1 .37302 L
s
.99625 .40476 m
1 .40476 L
s
.99625 .43651 m
1 .43651 L
s
.99625 .46825 m
1 .46825 L
s
.99625 .53175 m
1 .53175 L
s
.99625 .56349 m
1 .56349 L
s
.99625 .59524 m
1 .59524 L
s
.99625 .62698 m
1 .62698 L
s
.99625 .69048 m
1 .69048 L
s
.99625 .72222 m
1 .72222 L
s
.99625 .75397 m
1 .75397 L
s
.99625 .78571 m
1 .78571 L
s
.99625 .84921 m
1 .84921 L
s
.99625 .88095 m
1 .88095 L
s
.99625 .9127 m
1 .9127 L
s
.99625 .94444 m
1 .94444 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.5 0 m
.5 1 L
s
gsave
.5 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 0 1 r
.02381 .97619 m
.97619 .97619 L
.97619 .02381 L
.02381 .02381 L
F
.56 0 1 r
.02381 .07291 m
.06349 .06797 L
.09823 .06349 L
.10317 .06285 L
.14286 .05761 L
.18254 .05235 L
.22222 .04721 L
.2619 .04232 L
.30159 .03783 L
.34127 .03389 L
.38095 .03064 L
.42063 .02823 L
.46032 .02674 L
.5 .02623 L
.53968 .02674 L
.57937 .02823 L
.61905 .03064 L
.65873 .03389 L
.69841 .03783 L
.7381 .04232 L
.77778 .04721 L
.81746 .05235 L
.85714 .05761 L
.89683 .06285 L
.90177 .06349 L
.93651 .06797 L
.97619 .07291 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.5 Mabswid
.02381 .07291 m
.06349 .06797 L
.09823 .06349 L
.10317 .06285 L
.14286 .05761 L
.18254 .05235 L
.22222 .04721 L
.2619 .04232 L
.30159 .03783 L
.34127 .03389 L
.38095 .03064 L
.42063 .02823 L
.46032 .02674 L
.5 .02623 L
.53968 .02674 L
.57937 .02823 L
.61905 .03064 L
.65873 .03389 L
.69841 .03783 L
.7381 .04232 L
.77778 .04721 L
.81746 .05235 L
.85714 .05761 L
.89683 .06285 L
.90177 .06349 L
.93651 .06797 L
.97619 .07291 L
s
.32 0 1 r
.02381 .08287 m
.06349 .07785 L
.10317 .07262 L
.14286 .06726 L
.17053 .06349 L
.18254 .06187 L
.22222 .05657 L
.2619 .05153 L
.30159 .04689 L
.34127 .04283 L
.38095 .03948 L
.42063 .03698 L
.46032 .03544 L
.5 .03492 L
.53968 .03544 L
.57937 .03698 L
.61905 .03948 L
.65873 .04283 L
.69841 .04689 L
.7381 .05153 L
.77778 .05657 L
.81746 .06187 L
.82947 .06349 L
.85714 .06726 L
.89683 .07262 L
.93651 .07785 L
.97619 .08287 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .08287 m
.06349 .07785 L
.10317 .07262 L
.14286 .06726 L
.17053 .06349 L
.18254 .06187 L
.22222 .05657 L
.2619 .05153 L
.30159 .04689 L
.34127 .04283 L
.38095 .03948 L
.42063 .03698 L
.46032 .03544 L
.5 .03492 L
.53968 .03544 L
.57937 .03698 L
.61905 .03948 L
.65873 .04283 L
.69841 .04689 L
.7381 .05153 L
.77778 .05657 L
.81746 .06187 L
.82947 .06349 L
.85714 .06726 L
.89683 .07262 L
.93651 .07785 L
.97619 .08287 L
s
.08 0 1 r
.02381 .09316 m
.06349 .08806 L
.10317 .08272 L
.14286 .07723 L
.18254 .07168 L
.22222 .06622 L
.24268 .06349 L
.2619 .06101 L
.30159 .05621 L
.34127 .05199 L
.38095 .04852 L
.42063 .04593 L
.46032 .04434 L
.5 .0438 L
.53968 .04434 L
.57937 .04593 L
.61905 .04852 L
.65873 .05199 L
.69841 .05621 L
.7381 .06101 L
.75732 .06349 L
.77778 .06622 L
.81746 .07168 L
.85714 .07723 L
.89683 .08272 L
.93651 .08806 L
.97619 .09316 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .09316 m
.06349 .08806 L
.10317 .08272 L
.14286 .07723 L
.18254 .07168 L
.22222 .06622 L
.24268 .06349 L
.2619 .06101 L
.30159 .05621 L
.34127 .05199 L
.38095 .04852 L
.42063 .04593 L
.46032 .04434 L
.5 .0438 L
.53968 .04434 L
.57937 .04593 L
.61905 .04852 L
.65873 .05199 L
.69841 .05621 L
.7381 .06101 L
.75732 .06349 L
.77778 .06622 L
.81746 .07168 L
.85714 .07723 L
.89683 .08272 L
.93651 .08806 L
.97619 .09316 L
s
0 .16 1 r
.02381 .10381 m
.02881 .10317 L
.06349 .09863 L
.10317 .09318 L
.14286 .08755 L
.18254 .08184 L
.22222 .0762 L
.2619 .0708 L
.30159 .06581 L
.32168 .06349 L
.34127 .06142 L
.38095 .05781 L
.42063 .05511 L
.46032 .05345 L
.5 .05289 L
.53968 .05345 L
.57937 .05511 L
.61905 .05781 L
.65873 .06142 L
.67832 .06349 L
.69841 .06581 L
.7381 .0708 L
.77778 .0762 L
.81746 .08184 L
.85714 .08755 L
.89683 .09318 L
.93651 .09863 L
.97119 .10317 L
.97619 .10381 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .10381 m
.02881 .10317 L
.06349 .09863 L
.10317 .09318 L
.14286 .08755 L
.18254 .08184 L
.22222 .0762 L
.2619 .0708 L
.30159 .06581 L
.32168 .06349 L
.34127 .06142 L
.38095 .05781 L
.42063 .05511 L
.46032 .05345 L
.5 .05289 L
.53968 .05345 L
.57937 .05511 L
.61905 .05781 L
.65873 .06142 L
.67832 .06349 L
.69841 .06581 L
.7381 .0708 L
.77778 .0762 L
.81746 .08184 L
.85714 .08755 L
.89683 .09318 L
.93651 .09863 L
.97119 .10317 L
.97619 .10381 L
s
0 .4 1 r
.02381 .1148 m
.06349 .10956 L
.10317 .10403 L
.1092 .10317 L
.14286 .09827 L
.18254 .09239 L
.22222 .08655 L
.2619 .08094 L
.30159 .07574 L
.34127 .07117 L
.38095 .06739 L
.42063 .06457 L
.43467 .06349 L
.46032 .06283 L
.5 .06224 L
.53968 .06283 L
.56533 .06349 L
.57937 .06457 L
.61905 .06739 L
.65873 .07117 L
.69841 .07574 L
.7381 .08094 L
.77778 .08655 L
.81746 .09239 L
.85714 .09827 L
.8908 .10317 L
.89683 .10403 L
.93651 .10956 L
.97619 .1148 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .1148 m
.06349 .10956 L
.10317 .10403 L
.1092 .10317 L
.14286 .09827 L
.18254 .09239 L
.22222 .08655 L
.2619 .08094 L
.30159 .07574 L
.34127 .07117 L
.38095 .06739 L
.42063 .06457 L
.43467 .06349 L
.46032 .06283 L
.5 .06224 L
.53968 .06283 L
.56533 .06349 L
.57937 .06457 L
.61905 .06739 L
.65873 .07117 L
.69841 .07574 L
.7381 .08094 L
.77778 .08655 L
.81746 .09239 L
.85714 .09827 L
.8908 .10317 L
.89683 .10403 L
.93651 .10956 L
.97619 .1148 L
s
0 .64 1 r
.02381 .12624 m
.06349 .12091 L
.10317 .11526 L
.14286 .10937 L
.18254 .10335 L
.18372 .10317 L
.22222 .09731 L
.2619 .09148 L
.30159 .08606 L
.34127 .08126 L
.38095 .0773 L
.42063 .07435 L
.46032 .07252 L
.5 .0719 L
.53968 .07252 L
.57937 .07435 L
.61905 .0773 L
.65873 .08126 L
.69841 .08606 L
.7381 .09148 L
.77778 .09731 L
.81628 .10317 L
.81746 .10335 L
.85714 .10937 L
.89683 .11526 L
.93651 .12091 L
.97619 .12624 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .12624 m
.06349 .12091 L
.10317 .11526 L
.14286 .10937 L
.18254 .10335 L
.18372 .10317 L
.22222 .09731 L
.2619 .09148 L
.30159 .08606 L
.34127 .08126 L
.38095 .0773 L
.42063 .07435 L
.46032 .07252 L
.5 .0719 L
.53968 .07252 L
.57937 .07435 L
.61905 .0773 L
.65873 .08126 L
.69841 .08606 L
.7381 .09148 L
.77778 .09731 L
.81628 .10317 L
.81746 .10335 L
.85714 .10937 L
.89683 .11526 L
.93651 .12091 L
.97619 .12624 L
s
0 .88 1 r
.02381 .13818 m
.06349 .13276 L
.10317 .12699 L
.14286 .12093 L
.18254 .11471 L
.22222 .10849 L
.25706 .10317 L
.2619 .10245 L
.30159 .09678 L
.34127 .09176 L
.38095 .0876 L
.42063 .08448 L
.46032 .08256 L
.5 .08191 L
.53968 .08256 L
.57937 .08448 L
.61905 .0876 L
.65873 .09176 L
.69841 .09678 L
.7381 .10245 L
.74294 .10317 L
.77778 .10849 L
.81746 .11471 L
.85714 .12093 L
.89683 .12699 L
.93651 .13276 L
.97619 .13818 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .13818 m
.06349 .13276 L
.10317 .12699 L
.14286 .12093 L
.18254 .11471 L
.22222 .10849 L
.25706 .10317 L
.2619 .10245 L
.30159 .09678 L
.34127 .09176 L
.38095 .0876 L
.42063 .08448 L
.46032 .08256 L
.5 .08191 L
.53968 .08256 L
.57937 .08448 L
.61905 .0876 L
.65873 .09176 L
.69841 .09678 L
.7381 .10245 L
.74294 .10317 L
.77778 .10849 L
.81746 .11471 L
.85714 .12093 L
.89683 .12699 L
.93651 .13276 L
.97619 .13818 L
s
0 1 .88 r
.02381 .15061 m
.06349 .14515 L
.07932 .14286 L
.10317 .13927 L
.14286 .13305 L
.18254 .12661 L
.22222 .12013 L
.2619 .11383 L
.30159 .10793 L
.33737 .10317 L
.34127 .1027 L
.38095 .09831 L
.42063 .09502 L
.46032 .09299 L
.5 .0923 L
.53968 .09299 L
.57937 .09502 L
.61905 .09831 L
.65873 .1027 L
.66263 .10317 L
.69841 .10793 L
.7381 .11383 L
.77778 .12013 L
.81746 .12661 L
.85714 .13305 L
.89683 .13927 L
.92068 .14286 L
.93651 .14515 L
.97619 .15061 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .15061 m
.06349 .14515 L
.07932 .14286 L
.10317 .13927 L
.14286 .13305 L
.18254 .12661 L
.22222 .12013 L
.2619 .11383 L
.30159 .10793 L
.33737 .10317 L
.34127 .1027 L
.38095 .09831 L
.42063 .09502 L
.46032 .09299 L
.5 .0923 L
.53968 .09299 L
.57937 .09502 L
.61905 .09831 L
.65873 .1027 L
.66263 .10317 L
.69841 .10793 L
.7381 .11383 L
.77778 .12013 L
.81746 .12661 L
.85714 .13305 L
.89683 .13927 L
.92068 .14286 L
.93651 .14515 L
.97619 .15061 L
s
0 1 .64 r
.02381 .16364 m
.06349 .15809 L
.10317 .15211 L
.14286 .14576 L
.16044 .14286 L
.18254 .13913 L
.22222 .13238 L
.2619 .12577 L
.30159 .11956 L
.34127 .11403 L
.38095 .10943 L
.42063 .10598 L
.46032 .10385 L
.48955 .10317 L
.5 .10312 L
.51045 .10317 L
.53968 .10385 L
.57937 .10598 L
.61905 .10943 L
.65873 .11403 L
.69841 .11956 L
.7381 .12577 L
.77778 .13238 L
.81746 .13913 L
.83956 .14286 L
.85714 .14576 L
.89683 .15211 L
.93651 .15809 L
.97619 .16364 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .16364 m
.06349 .15809 L
.10317 .15211 L
.14286 .14576 L
.16044 .14286 L
.18254 .13913 L
.22222 .13238 L
.2619 .12577 L
.30159 .11956 L
.34127 .11403 L
.38095 .10943 L
.42063 .10598 L
.46032 .10385 L
.48955 .10317 L
.5 .10312 L
.51045 .10317 L
.53968 .10385 L
.57937 .10598 L
.61905 .10943 L
.65873 .11403 L
.69841 .11956 L
.7381 .12577 L
.77778 .13238 L
.81746 .13913 L
.83956 .14286 L
.85714 .14576 L
.89683 .15211 L
.93651 .15809 L
.97619 .16364 L
s
0 1 .4 r
.02381 .1774 m
.06349 .17177 L
.10317 .16565 L
.14286 .1591 L
.18254 .15225 L
.22222 .14528 L
.23607 .14286 L
.2619 .13837 L
.30159 .13181 L
.34127 .12594 L
.38095 .12105 L
.42063 .11737 L
.46032 .11509 L
.5 .11432 L
.53968 .11509 L
.57937 .11737 L
.61905 .12105 L
.65873 .12594 L
.69841 .13181 L
.7381 .13837 L
.76393 .14286 L
.77778 .14528 L
.81746 .15225 L
.85714 .1591 L
.89683 .16565 L
.93651 .17177 L
.97619 .1774 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .1774 m
.06349 .17177 L
.10317 .16565 L
.14286 .1591 L
.18254 .15225 L
.22222 .14528 L
.23607 .14286 L
.2619 .13837 L
.30159 .13181 L
.34127 .12594 L
.38095 .12105 L
.42063 .11737 L
.46032 .11509 L
.5 .11432 L
.53968 .11509 L
.57937 .11737 L
.61905 .12105 L
.65873 .12594 L
.69841 .13181 L
.7381 .13837 L
.76393 .14286 L
.77778 .14528 L
.81746 .15225 L
.85714 .1591 L
.89683 .16565 L
.93651 .17177 L
.97619 .1774 L
s
0 1 .16 r
.02381 .19191 m
.06349 .18626 L
.08773 .18254 L
.10317 .18005 L
.14286 .1733 L
.18254 .16618 L
.22222 .15886 L
.2619 .15161 L
.30159 .14475 L
.31314 .14286 L
.34127 .13853 L
.38095 .1333 L
.42063 .12936 L
.46032 .12692 L
.5 .12609 L
.53968 .12692 L
.57937 .12936 L
.61905 .1333 L
.65873 .13853 L
.68686 .14286 L
.69841 .14475 L
.7381 .15161 L
.77778 .15886 L
.81746 .16618 L
.85714 .1733 L
.89683 .18005 L
.91227 .18254 L
.93651 .18626 L
.97619 .19191 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .19191 m
.06349 .18626 L
.08773 .18254 L
.10317 .18005 L
.14286 .1733 L
.18254 .16618 L
.22222 .15886 L
.2619 .15161 L
.30159 .14475 L
.31314 .14286 L
.34127 .13853 L
.38095 .1333 L
.42063 .12936 L
.46032 .12692 L
.5 .12609 L
.53968 .12692 L
.57937 .12936 L
.61905 .1333 L
.65873 .13853 L
.68686 .14286 L
.69841 .14475 L
.7381 .15161 L
.77778 .15886 L
.81746 .16618 L
.85714 .1733 L
.89683 .18005 L
.91227 .18254 L
.93651 .18626 L
.97619 .19191 L
s
.08 1 0 r
.02381 .20737 m
.06349 .20163 L
.10317 .19531 L
.14286 .18843 L
.17496 .18254 L
.18254 .1811 L
.22222 .17341 L
.2619 .16572 L
.30159 .15838 L
.34127 .15177 L
.38095 .14623 L
.41133 .14286 L
.42063 .14206 L
.46032 .13942 L
.5 .13853 L
.53968 .13942 L
.57937 .14206 L
.58867 .14286 L
.61905 .14623 L
.65873 .15177 L
.69841 .15838 L
.7381 .16572 L
.77778 .17341 L
.81746 .1811 L
.82504 .18254 L
.85714 .18843 L
.89683 .19531 L
.93651 .20163 L
.97619 .20737 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .20737 m
.06349 .20163 L
.10317 .19531 L
.14286 .18843 L
.17496 .18254 L
.18254 .1811 L
.22222 .17341 L
.2619 .16572 L
.30159 .15838 L
.34127 .15177 L
.38095 .14623 L
.41133 .14286 L
.42063 .14206 L
.46032 .13942 L
.5 .13853 L
.53968 .13942 L
.57937 .14206 L
.58867 .14286 L
.61905 .14623 L
.65873 .15177 L
.69841 .15838 L
.7381 .16572 L
.77778 .17341 L
.81746 .1811 L
.82504 .18254 L
.85714 .18843 L
.89683 .19531 L
.93651 .20163 L
.97619 .20737 L
s
.32 1 0 r
.02381 .22399 m
.03656 .22222 L
.06349 .21823 L
.10317 .21177 L
.14286 .20466 L
.18254 .19701 L
.22222 .18901 L
.2541 .18254 L
.2619 .18094 L
.30159 .17307 L
.34127 .16591 L
.38095 .1599 L
.42063 .15536 L
.46032 .15254 L
.5 .15159 L
.53968 .15254 L
.57937 .15536 L
.61905 .1599 L
.65873 .16591 L
.69841 .17307 L
.7381 .18094 L
.7459 .18254 L
.77778 .18901 L
.81746 .19701 L
.85714 .20466 L
.89683 .21177 L
.93651 .21823 L
.96344 .22222 L
.97619 .22399 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .22399 m
.03656 .22222 L
.06349 .21823 L
.10317 .21177 L
.14286 .20466 L
.18254 .19701 L
.22222 .18901 L
.2541 .18254 L
.2619 .18094 L
.30159 .17307 L
.34127 .16591 L
.38095 .1599 L
.42063 .15536 L
.46032 .15254 L
.5 .15159 L
.53968 .15254 L
.57937 .15536 L
.61905 .1599 L
.65873 .16591 L
.69841 .17307 L
.7381 .18094 L
.7459 .18254 L
.77778 .18901 L
.81746 .19701 L
.85714 .20466 L
.89683 .21177 L
.93651 .21823 L
.96344 .22222 L
.97619 .22399 L
s
.56 1 0 r
.02381 .24187 m
.06349 .23611 L
.10317 .22962 L
.14286 .22242 L
.1439 .22222 L
.18254 .21442 L
.22222 .20592 L
.2619 .19726 L
.30159 .18889 L
.33434 .18254 L
.34127 .18126 L
.38095 .17468 L
.42063 .1697 L
.46032 .1666 L
.5 .16554 L
.53968 .1666 L
.57937 .1697 L
.61905 .17468 L
.65873 .18126 L
.66566 .18254 L
.69841 .18889 L
.7381 .19726 L
.77778 .20592 L
.81746 .21442 L
.8561 .22222 L
.85714 .22242 L
.89683 .22962 L
.93651 .23611 L
.97619 .24187 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .24187 m
.06349 .23611 L
.10317 .22962 L
.14286 .22242 L
.1439 .22222 L
.18254 .21442 L
.22222 .20592 L
.2619 .19726 L
.30159 .18889 L
.33434 .18254 L
.34127 .18126 L
.38095 .17468 L
.42063 .1697 L
.46032 .1666 L
.5 .16554 L
.53968 .1666 L
.57937 .1697 L
.61905 .17468 L
.65873 .18126 L
.66566 .18254 L
.69841 .18889 L
.7381 .19726 L
.77778 .20592 L
.81746 .21442 L
.8561 .22222 L
.85714 .22242 L
.89683 .22962 L
.93651 .23611 L
.97619 .24187 L
s
.8 1 0 r
.02381 .2616 m
.06349 .25584 L
.10317 .24925 L
.14286 .24179 L
.18254 .23353 L
.22222 .22468 L
.23298 .22222 L
.2619 .21539 L
.30159 .20618 L
.34127 .19773 L
.38095 .1906 L
.42063 .18523 L
.44547 .18254 L
.46032 .18189 L
.5 .18072 L
.53968 .18189 L
.55453 .18254 L
.57937 .18523 L
.61905 .1906 L
.65873 .19773 L
.69841 .20618 L
.7381 .21539 L
.76702 .22222 L
.77778 .22468 L
.81746 .23353 L
.85714 .24179 L
.89683 .24925 L
.93651 .25584 L
.97619 .2616 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .2616 m
.06349 .25584 L
.10317 .24925 L
.14286 .24179 L
.18254 .23353 L
.22222 .22468 L
.23298 .22222 L
.2619 .21539 L
.30159 .20618 L
.34127 .19773 L
.38095 .1906 L
.42063 .18523 L
.44547 .18254 L
.46032 .18189 L
.5 .18072 L
.53968 .18189 L
.55453 .18254 L
.57937 .18523 L
.61905 .1906 L
.65873 .19773 L
.69841 .20618 L
.7381 .21539 L
.76702 .22222 L
.77778 .22468 L
.81746 .23353 L
.85714 .24179 L
.89683 .24925 L
.93651 .25584 L
.97619 .2616 L
s
1 .96 0 r
.02381 .28336 m
.06349 .27773 L
.10317 .27121 L
.14286 .26374 L
.15188 .2619 L
.18254 .25512 L
.22222 .24556 L
.2619 .23551 L
.30159 .22562 L
.31589 .22222 L
.34127 .2163 L
.38095 .2082 L
.42063 .20205 L
.46032 .19823 L
.5 .19694 L
.53968 .19823 L
.57937 .20205 L
.61905 .2082 L
.65873 .2163 L
.68411 .22222 L
.69841 .22562 L
.7381 .23551 L
.77778 .24556 L
.81746 .25512 L
.84812 .2619 L
.85714 .26374 L
.89683 .27121 L
.93651 .27773 L
.97619 .28336 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .28336 m
.06349 .27773 L
.10317 .27121 L
.14286 .26374 L
.15188 .2619 L
.18254 .25512 L
.22222 .24556 L
.2619 .23551 L
.30159 .22562 L
.31589 .22222 L
.34127 .2163 L
.38095 .2082 L
.42063 .20205 L
.46032 .19823 L
.5 .19694 L
.53968 .19823 L
.57937 .20205 L
.61905 .2082 L
.65873 .2163 L
.68411 .22222 L
.69841 .22562 L
.7381 .23551 L
.77778 .24556 L
.81746 .25512 L
.84812 .2619 L
.85714 .26374 L
.89683 .27121 L
.93651 .27773 L
.97619 .28336 L
s
1 .72 0 r
.02381 .30832 m
.06349 .30299 L
.07292 .30159 L
.10317 .29653 L
.14286 .28884 L
.18254 .2799 L
.22222 .26987 L
.25202 .2619 L
.2619 .25908 L
.30159 .24772 L
.34127 .23706 L
.38095 .22806 L
.4145 .22222 L
.42063 .22135 L
.46032 .21691 L
.5 .2154 L
.53968 .21691 L
.57937 .22135 L
.5855 .22222 L
.61905 .22806 L
.65873 .23706 L
.69841 .24772 L
.7381 .25908 L
.74798 .2619 L
.77778 .26987 L
.81746 .2799 L
.85714 .28884 L
.89683 .29653 L
.92708 .30159 L
.93651 .30299 L
.97619 .30832 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .30832 m
.06349 .30299 L
.07292 .30159 L
.10317 .29653 L
.14286 .28884 L
.18254 .2799 L
.22222 .26987 L
.25202 .2619 L
.2619 .25908 L
.30159 .24772 L
.34127 .23706 L
.38095 .22806 L
.4145 .22222 L
.42063 .22135 L
.46032 .21691 L
.5 .2154 L
.53968 .21691 L
.57937 .22135 L
.5855 .22222 L
.61905 .22806 L
.65873 .23706 L
.69841 .24772 L
.7381 .25908 L
.74798 .2619 L
.77778 .26987 L
.81746 .2799 L
.85714 .28884 L
.89683 .29653 L
.92708 .30159 L
.93651 .30299 L
.97619 .30832 L
s
1 .48 0 r
.02381 .33793 m
.06349 .33281 L
.10317 .3266 L
.14286 .31907 L
.18254 .31007 L
.21536 .30159 L
.22222 .29958 L
.2619 .2872 L
.30159 .27426 L
.34127 .26242 L
.34316 .2619 L
.38095 .2514 L
.42063 .2429 L
.46032 .23763 L
.5 .23586 L
.53968 .23763 L
.57937 .2429 L
.61905 .2514 L
.65684 .2619 L
.65873 .26242 L
.69841 .27426 L
.7381 .2872 L
.77778 .29958 L
.78464 .30159 L
.81746 .31007 L
.85714 .31907 L
.89683 .3266 L
.93651 .33281 L
.97619 .33793 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .33793 m
.06349 .33281 L
.10317 .3266 L
.14286 .31907 L
.18254 .31007 L
.21536 .30159 L
.22222 .29958 L
.2619 .2872 L
.30159 .27426 L
.34127 .26242 L
.34316 .2619 L
.38095 .2514 L
.42063 .2429 L
.46032 .23763 L
.5 .23586 L
.53968 .23763 L
.57937 .2429 L
.61905 .2514 L
.65684 .2619 L
.65873 .26242 L
.69841 .27426 L
.7381 .2872 L
.77778 .29958 L
.78464 .30159 L
.81746 .31007 L
.85714 .31907 L
.89683 .3266 L
.93651 .33281 L
.97619 .33793 L
s
1 .24 0 r
.02381 .37536 m
.06349 .37094 L
.10317 .36542 L
.14286 .35846 L
.18254 .34973 L
.215 .34127 L
.22222 .33898 L
.2619 .32485 L
.30159 .30938 L
.32373 .30159 L
.34127 .29456 L
.38095 .28006 L
.42063 .26918 L
.46032 .26335 L
.5 .26211 L
.53968 .26335 L
.57937 .26918 L
.61905 .28006 L
.65873 .29456 L
.67627 .30159 L
.69841 .30938 L
.7381 .32485 L
.77778 .33898 L
.785 .34127 L
.81746 .34973 L
.85714 .35846 L
.89683 .36542 L
.93651 .37094 L
.97619 .37536 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .37536 m
.06349 .37094 L
.10317 .36542 L
.14286 .35846 L
.18254 .34973 L
.215 .34127 L
.22222 .33898 L
.2619 .32485 L
.30159 .30938 L
.32373 .30159 L
.34127 .29456 L
.38095 .28006 L
.42063 .26918 L
.46032 .26335 L
.5 .26211 L
.53968 .26335 L
.57937 .26918 L
.61905 .28006 L
.65873 .29456 L
.67627 .30159 L
.69841 .30938 L
.7381 .32485 L
.77778 .33898 L
.785 .34127 L
.81746 .34973 L
.85714 .35846 L
.89683 .36542 L
.93651 .37094 L
.97619 .37536 L
s
1 0 0 r
.02381 .43397 m
.06349 .4314 L
.10317 .42804 L
.14286 .42348 L
.16224 .42063 L
.18254 .41665 L
.22222 .40608 L
.2619 .39077 L
.28748 .38095 L
.30159 .37203 L
.34127 .35023 L
.35633 .34127 L
.38095 .32926 L
.42063 .31357 L
.46032 .30404 L
.48159 .30159 L
.5 .30057 L
.51841 .30159 L
.53968 .30404 L
.57937 .31357 L
.61905 .32926 L
.64367 .34127 L
.65873 .35023 L
.69841 .37203 L
.71252 .38095 L
.7381 .39077 L
.77778 .40608 L
.81746 .41665 L
.83776 .42063 L
.85714 .42348 L
.89683 .42804 L
.93651 .4314 L
.97619 .43397 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .43397 m
.06349 .4314 L
.10317 .42804 L
.14286 .42348 L
.16224 .42063 L
.18254 .41665 L
.22222 .40608 L
.2619 .39077 L
.28748 .38095 L
.30159 .37203 L
.34127 .35023 L
.35633 .34127 L
.38095 .32926 L
.42063 .31357 L
.46032 .30404 L
.48159 .30159 L
.5 .30057 L
.51841 .30159 L
.53968 .30404 L
.57937 .31357 L
.61905 .32926 L
.64367 .34127 L
.65873 .35023 L
.69841 .37203 L
.71252 .38095 L
.7381 .39077 L
.77778 .40608 L
.81746 .41665 L
.83776 .42063 L
.85714 .42348 L
.89683 .42804 L
.93651 .4314 L
.97619 .43397 L
s
1 .24 0 r
.02381 .56603 m
.06349 .5686 L
.10317 .57196 L
.14286 .57652 L
.16224 .57937 L
.18254 .58335 L
.22222 .59392 L
.2619 .60923 L
.28748 .61905 L
.30159 .62797 L
.34127 .64977 L
.35633 .65873 L
.38095 .67074 L
.42063 .68643 L
.46032 .69596 L
.48159 .69841 L
.5 .69943 L
.51841 .69841 L
.53968 .69596 L
.57937 .68643 L
.61905 .67074 L
.64367 .65873 L
.65873 .64977 L
.69841 .62797 L
.71252 .61905 L
.7381 .60923 L
.77778 .59392 L
.81746 .58335 L
.83776 .57937 L
.85714 .57652 L
.89683 .57196 L
.93651 .5686 L
.97619 .56603 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .56603 m
.06349 .5686 L
.10317 .57196 L
.14286 .57652 L
.16224 .57937 L
.18254 .58335 L
.22222 .59392 L
.2619 .60923 L
.28748 .61905 L
.30159 .62797 L
.34127 .64977 L
.35633 .65873 L
.38095 .67074 L
.42063 .68643 L
.46032 .69596 L
.48159 .69841 L
.5 .69943 L
.51841 .69841 L
.53968 .69596 L
.57937 .68643 L
.61905 .67074 L
.64367 .65873 L
.65873 .64977 L
.69841 .62797 L
.71252 .61905 L
.7381 .60923 L
.77778 .59392 L
.81746 .58335 L
.83776 .57937 L
.85714 .57652 L
.89683 .57196 L
.93651 .5686 L
.97619 .56603 L
s
1 .48 0 r
.02381 .62464 m
.06349 .62906 L
.10317 .63458 L
.14286 .64154 L
.18254 .65027 L
.215 .65873 L
.22222 .66102 L
.2619 .67515 L
.30159 .69062 L
.32373 .69841 L
.34127 .70544 L
.38095 .71994 L
.42063 .73082 L
.46032 .73665 L
.5 .73789 L
.53968 .73665 L
.57937 .73082 L
.61905 .71994 L
.65873 .70544 L
.67627 .69841 L
.69841 .69062 L
.7381 .67515 L
.77778 .66102 L
.785 .65873 L
.81746 .65027 L
.85714 .64154 L
.89683 .63458 L
.93651 .62906 L
.97619 .62464 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .62464 m
.06349 .62906 L
.10317 .63458 L
.14286 .64154 L
.18254 .65027 L
.215 .65873 L
.22222 .66102 L
.2619 .67515 L
.30159 .69062 L
.32373 .69841 L
.34127 .70544 L
.38095 .71994 L
.42063 .73082 L
.46032 .73665 L
.5 .73789 L
.53968 .73665 L
.57937 .73082 L
.61905 .71994 L
.65873 .70544 L
.67627 .69841 L
.69841 .69062 L
.7381 .67515 L
.77778 .66102 L
.785 .65873 L
.81746 .65027 L
.85714 .64154 L
.89683 .63458 L
.93651 .62906 L
.97619 .62464 L
s
1 .72 0 r
.02381 .66207 m
.06349 .66719 L
.10317 .6734 L
.14286 .68093 L
.18254 .68993 L
.21536 .69841 L
.22222 .70042 L
.2619 .7128 L
.30159 .72574 L
.34127 .73758 L
.34316 .7381 L
.38095 .7486 L
.42063 .7571 L
.46032 .76237 L
.5 .76414 L
.53968 .76237 L
.57937 .7571 L
.61905 .7486 L
.65684 .7381 L
.65873 .73758 L
.69841 .72574 L
.7381 .7128 L
.77778 .70042 L
.78464 .69841 L
.81746 .68993 L
.85714 .68093 L
.89683 .6734 L
.93651 .66719 L
.97619 .66207 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .66207 m
.06349 .66719 L
.10317 .6734 L
.14286 .68093 L
.18254 .68993 L
.21536 .69841 L
.22222 .70042 L
.2619 .7128 L
.30159 .72574 L
.34127 .73758 L
.34316 .7381 L
.38095 .7486 L
.42063 .7571 L
.46032 .76237 L
.5 .76414 L
.53968 .76237 L
.57937 .7571 L
.61905 .7486 L
.65684 .7381 L
.65873 .73758 L
.69841 .72574 L
.7381 .7128 L
.77778 .70042 L
.78464 .69841 L
.81746 .68993 L
.85714 .68093 L
.89683 .6734 L
.93651 .66719 L
.97619 .66207 L
s
1 .96 0 r
.02381 .69168 m
.06349 .69701 L
.07292 .69841 L
.10317 .70347 L
.14286 .71116 L
.18254 .7201 L
.22222 .73013 L
.25202 .7381 L
.2619 .74092 L
.30159 .75228 L
.34127 .76294 L
.38095 .77194 L
.4145 .77778 L
.42063 .77865 L
.46032 .78309 L
.5 .7846 L
.53968 .78309 L
.57937 .77865 L
.5855 .77778 L
.61905 .77194 L
.65873 .76294 L
.69841 .75228 L
.7381 .74092 L
.74798 .7381 L
.77778 .73013 L
.81746 .7201 L
.85714 .71116 L
.89683 .70347 L
.92708 .69841 L
.93651 .69701 L
.97619 .69168 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .69168 m
.06349 .69701 L
.07292 .69841 L
.10317 .70347 L
.14286 .71116 L
.18254 .7201 L
.22222 .73013 L
.25202 .7381 L
.2619 .74092 L
.30159 .75228 L
.34127 .76294 L
.38095 .77194 L
.4145 .77778 L
.42063 .77865 L
.46032 .78309 L
.5 .7846 L
.53968 .78309 L
.57937 .77865 L
.5855 .77778 L
.61905 .77194 L
.65873 .76294 L
.69841 .75228 L
.7381 .74092 L
.74798 .7381 L
.77778 .73013 L
.81746 .7201 L
.85714 .71116 L
.89683 .70347 L
.92708 .69841 L
.93651 .69701 L
.97619 .69168 L
s
.8 1 0 r
.02381 .71664 m
.06349 .72227 L
.10317 .72879 L
.14286 .73626 L
.15188 .7381 L
.18254 .74488 L
.22222 .75444 L
.2619 .76449 L
.30159 .77438 L
.31589 .77778 L
.34127 .7837 L
.38095 .7918 L
.42063 .79795 L
.46032 .80177 L
.5 .80306 L
.53968 .80177 L
.57937 .79795 L
.61905 .7918 L
.65873 .7837 L
.68411 .77778 L
.69841 .77438 L
.7381 .76449 L
.77778 .75444 L
.81746 .74488 L
.84812 .7381 L
.85714 .73626 L
.89683 .72879 L
.93651 .72227 L
.97619 .71664 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .71664 m
.06349 .72227 L
.10317 .72879 L
.14286 .73626 L
.15188 .7381 L
.18254 .74488 L
.22222 .75444 L
.2619 .76449 L
.30159 .77438 L
.31589 .77778 L
.34127 .7837 L
.38095 .7918 L
.42063 .79795 L
.46032 .80177 L
.5 .80306 L
.53968 .80177 L
.57937 .79795 L
.61905 .7918 L
.65873 .7837 L
.68411 .77778 L
.69841 .77438 L
.7381 .76449 L
.77778 .75444 L
.81746 .74488 L
.84812 .7381 L
.85714 .73626 L
.89683 .72879 L
.93651 .72227 L
.97619 .71664 L
s
.56 1 0 r
.02381 .7384 m
.06349 .74416 L
.10317 .75075 L
.14286 .75821 L
.18254 .76647 L
.22222 .77532 L
.23298 .77778 L
.2619 .78461 L
.30159 .79382 L
.34127 .80227 L
.38095 .8094 L
.42063 .81477 L
.44547 .81746 L
.46032 .81811 L
.5 .81928 L
.53968 .81811 L
.55453 .81746 L
.57937 .81477 L
.61905 .8094 L
.65873 .80227 L
.69841 .79382 L
.7381 .78461 L
.76702 .77778 L
.77778 .77532 L
.81746 .76647 L
.85714 .75821 L
.89683 .75075 L
.93651 .74416 L
.97619 .7384 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .7384 m
.06349 .74416 L
.10317 .75075 L
.14286 .75821 L
.18254 .76647 L
.22222 .77532 L
.23298 .77778 L
.2619 .78461 L
.30159 .79382 L
.34127 .80227 L
.38095 .8094 L
.42063 .81477 L
.44547 .81746 L
.46032 .81811 L
.5 .81928 L
.53968 .81811 L
.55453 .81746 L
.57937 .81477 L
.61905 .8094 L
.65873 .80227 L
.69841 .79382 L
.7381 .78461 L
.76702 .77778 L
.77778 .77532 L
.81746 .76647 L
.85714 .75821 L
.89683 .75075 L
.93651 .74416 L
.97619 .7384 L
s
.32 1 0 r
.02381 .75813 m
.06349 .76389 L
.10317 .77038 L
.14286 .77758 L
.1439 .77778 L
.18254 .78558 L
.22222 .79408 L
.2619 .80274 L
.30159 .81111 L
.33434 .81746 L
.34127 .81874 L
.38095 .82532 L
.42063 .8303 L
.46032 .8334 L
.5 .83446 L
.53968 .8334 L
.57937 .8303 L
.61905 .82532 L
.65873 .81874 L
.66566 .81746 L
.69841 .81111 L
.7381 .80274 L
.77778 .79408 L
.81746 .78558 L
.8561 .77778 L
.85714 .77758 L
.89683 .77038 L
.93651 .76389 L
.97619 .75813 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .75813 m
.06349 .76389 L
.10317 .77038 L
.14286 .77758 L
.1439 .77778 L
.18254 .78558 L
.22222 .79408 L
.2619 .80274 L
.30159 .81111 L
.33434 .81746 L
.34127 .81874 L
.38095 .82532 L
.42063 .8303 L
.46032 .8334 L
.5 .83446 L
.53968 .8334 L
.57937 .8303 L
.61905 .82532 L
.65873 .81874 L
.66566 .81746 L
.69841 .81111 L
.7381 .80274 L
.77778 .79408 L
.81746 .78558 L
.8561 .77778 L
.85714 .77758 L
.89683 .77038 L
.93651 .76389 L
.97619 .75813 L
s
.08 1 0 r
.02381 .77601 m
.03656 .77778 L
.06349 .78177 L
.10317 .78823 L
.14286 .79534 L
.18254 .80299 L
.22222 .81099 L
.2541 .81746 L
.2619 .81906 L
.30159 .82693 L
.34127 .83409 L
.38095 .8401 L
.42063 .84464 L
.46032 .84746 L
.5 .84841 L
.53968 .84746 L
.57937 .84464 L
.61905 .8401 L
.65873 .83409 L
.69841 .82693 L
.7381 .81906 L
.7459 .81746 L
.77778 .81099 L
.81746 .80299 L
.85714 .79534 L
.89683 .78823 L
.93651 .78177 L
.96344 .77778 L
.97619 .77601 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .77601 m
.03656 .77778 L
.06349 .78177 L
.10317 .78823 L
.14286 .79534 L
.18254 .80299 L
.22222 .81099 L
.2541 .81746 L
.2619 .81906 L
.30159 .82693 L
.34127 .83409 L
.38095 .8401 L
.42063 .84464 L
.46032 .84746 L
.5 .84841 L
.53968 .84746 L
.57937 .84464 L
.61905 .8401 L
.65873 .83409 L
.69841 .82693 L
.7381 .81906 L
.7459 .81746 L
.77778 .81099 L
.81746 .80299 L
.85714 .79534 L
.89683 .78823 L
.93651 .78177 L
.96344 .77778 L
.97619 .77601 L
s
0 1 .16 r
.02381 .79263 m
.06349 .79837 L
.10317 .80469 L
.14286 .81157 L
.17496 .81746 L
.18254 .8189 L
.22222 .82659 L
.2619 .83428 L
.30159 .84162 L
.34127 .84823 L
.38095 .85377 L
.41133 .85714 L
.42063 .85794 L
.46032 .86058 L
.5 .86147 L
.53968 .86058 L
.57937 .85794 L
.58867 .85714 L
.61905 .85377 L
.65873 .84823 L
.69841 .84162 L
.7381 .83428 L
.77778 .82659 L
.81746 .8189 L
.82504 .81746 L
.85714 .81157 L
.89683 .80469 L
.93651 .79837 L
.97619 .79263 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .79263 m
.06349 .79837 L
.10317 .80469 L
.14286 .81157 L
.17496 .81746 L
.18254 .8189 L
.22222 .82659 L
.2619 .83428 L
.30159 .84162 L
.34127 .84823 L
.38095 .85377 L
.41133 .85714 L
.42063 .85794 L
.46032 .86058 L
.5 .86147 L
.53968 .86058 L
.57937 .85794 L
.58867 .85714 L
.61905 .85377 L
.65873 .84823 L
.69841 .84162 L
.7381 .83428 L
.77778 .82659 L
.81746 .8189 L
.82504 .81746 L
.85714 .81157 L
.89683 .80469 L
.93651 .79837 L
.97619 .79263 L
s
0 1 .4 r
.02381 .80809 m
.06349 .81374 L
.08773 .81746 L
.10317 .81995 L
.14286 .8267 L
.18254 .83382 L
.22222 .84114 L
.2619 .84839 L
.30159 .85525 L
.31314 .85714 L
.34127 .86147 L
.38095 .8667 L
.42063 .87064 L
.46032 .87308 L
.5 .87391 L
.53968 .87308 L
.57937 .87064 L
.61905 .8667 L
.65873 .86147 L
.68686 .85714 L
.69841 .85525 L
.7381 .84839 L
.77778 .84114 L
.81746 .83382 L
.85714 .8267 L
.89683 .81995 L
.91227 .81746 L
.93651 .81374 L
.97619 .80809 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .80809 m
.06349 .81374 L
.08773 .81746 L
.10317 .81995 L
.14286 .8267 L
.18254 .83382 L
.22222 .84114 L
.2619 .84839 L
.30159 .85525 L
.31314 .85714 L
.34127 .86147 L
.38095 .8667 L
.42063 .87064 L
.46032 .87308 L
.5 .87391 L
.53968 .87308 L
.57937 .87064 L
.61905 .8667 L
.65873 .86147 L
.68686 .85714 L
.69841 .85525 L
.7381 .84839 L
.77778 .84114 L
.81746 .83382 L
.85714 .8267 L
.89683 .81995 L
.91227 .81746 L
.93651 .81374 L
.97619 .80809 L
s
0 1 .64 r
.02381 .8226 m
.06349 .82823 L
.10317 .83435 L
.14286 .8409 L
.18254 .84775 L
.22222 .85472 L
.23607 .85714 L
.2619 .86163 L
.30159 .86819 L
.34127 .87406 L
.38095 .87895 L
.42063 .88263 L
.46032 .88491 L
.5 .88568 L
.53968 .88491 L
.57937 .88263 L
.61905 .87895 L
.65873 .87406 L
.69841 .86819 L
.7381 .86163 L
.76393 .85714 L
.77778 .85472 L
.81746 .84775 L
.85714 .8409 L
.89683 .83435 L
.93651 .82823 L
.97619 .8226 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .8226 m
.06349 .82823 L
.10317 .83435 L
.14286 .8409 L
.18254 .84775 L
.22222 .85472 L
.23607 .85714 L
.2619 .86163 L
.30159 .86819 L
.34127 .87406 L
.38095 .87895 L
.42063 .88263 L
.46032 .88491 L
.5 .88568 L
.53968 .88491 L
.57937 .88263 L
.61905 .87895 L
.65873 .87406 L
.69841 .86819 L
.7381 .86163 L
.76393 .85714 L
.77778 .85472 L
.81746 .84775 L
.85714 .8409 L
.89683 .83435 L
.93651 .82823 L
.97619 .8226 L
s
0 1 .88 r
.02381 .83636 m
.06349 .84191 L
.10317 .84789 L
.14286 .85424 L
.16044 .85714 L
.18254 .86087 L
.22222 .86762 L
.2619 .87423 L
.30159 .88044 L
.34127 .88597 L
.38095 .89057 L
.42063 .89402 L
.46032 .89615 L
.48955 .89683 L
.5 .89688 L
.51045 .89683 L
.53968 .89615 L
.57937 .89402 L
.61905 .89057 L
.65873 .88597 L
.69841 .88044 L
.7381 .87423 L
.77778 .86762 L
.81746 .86087 L
.83956 .85714 L
.85714 .85424 L
.89683 .84789 L
.93651 .84191 L
.97619 .83636 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .83636 m
.06349 .84191 L
.10317 .84789 L
.14286 .85424 L
.16044 .85714 L
.18254 .86087 L
.22222 .86762 L
.2619 .87423 L
.30159 .88044 L
.34127 .88597 L
.38095 .89057 L
.42063 .89402 L
.46032 .89615 L
.48955 .89683 L
.5 .89688 L
.51045 .89683 L
.53968 .89615 L
.57937 .89402 L
.61905 .89057 L
.65873 .88597 L
.69841 .88044 L
.7381 .87423 L
.77778 .86762 L
.81746 .86087 L
.83956 .85714 L
.85714 .85424 L
.89683 .84789 L
.93651 .84191 L
.97619 .83636 L
s
0 .88 1 r
.02381 .84939 m
.06349 .85485 L
.07932 .85714 L
.10317 .86073 L
.14286 .86695 L
.18254 .87339 L
.22222 .87987 L
.2619 .88617 L
.30159 .89207 L
.33737 .89683 L
.34127 .8973 L
.38095 .90169 L
.42063 .90498 L
.46032 .90701 L
.5 .9077 L
.53968 .90701 L
.57937 .90498 L
.61905 .90169 L
.65873 .8973 L
.66263 .89683 L
.69841 .89207 L
.7381 .88617 L
.77778 .87987 L
.81746 .87339 L
.85714 .86695 L
.89683 .86073 L
.92068 .85714 L
.93651 .85485 L
.97619 .84939 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .84939 m
.06349 .85485 L
.07932 .85714 L
.10317 .86073 L
.14286 .86695 L
.18254 .87339 L
.22222 .87987 L
.2619 .88617 L
.30159 .89207 L
.33737 .89683 L
.34127 .8973 L
.38095 .90169 L
.42063 .90498 L
.46032 .90701 L
.5 .9077 L
.53968 .90701 L
.57937 .90498 L
.61905 .90169 L
.65873 .8973 L
.66263 .89683 L
.69841 .89207 L
.7381 .88617 L
.77778 .87987 L
.81746 .87339 L
.85714 .86695 L
.89683 .86073 L
.92068 .85714 L
.93651 .85485 L
.97619 .84939 L
s
0 .64 1 r
.02381 .86182 m
.06349 .86724 L
.10317 .87301 L
.14286 .87907 L
.18254 .88529 L
.22222 .89151 L
.25706 .89683 L
.2619 .89755 L
.30159 .90322 L
.34127 .90824 L
.38095 .9124 L
.42063 .91552 L
.46032 .91744 L
.5 .91809 L
.53968 .91744 L
.57937 .91552 L
.61905 .9124 L
.65873 .90824 L
.69841 .90322 L
.7381 .89755 L
.74294 .89683 L
.77778 .89151 L
.81746 .88529 L
.85714 .87907 L
.89683 .87301 L
.93651 .86724 L
.97619 .86182 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .86182 m
.06349 .86724 L
.10317 .87301 L
.14286 .87907 L
.18254 .88529 L
.22222 .89151 L
.25706 .89683 L
.2619 .89755 L
.30159 .90322 L
.34127 .90824 L
.38095 .9124 L
.42063 .91552 L
.46032 .91744 L
.5 .91809 L
.53968 .91744 L
.57937 .91552 L
.61905 .9124 L
.65873 .90824 L
.69841 .90322 L
.7381 .89755 L
.74294 .89683 L
.77778 .89151 L
.81746 .88529 L
.85714 .87907 L
.89683 .87301 L
.93651 .86724 L
.97619 .86182 L
s
0 .4 1 r
.02381 .87376 m
.06349 .87909 L
.10317 .88474 L
.14286 .89063 L
.18254 .89665 L
.18372 .89683 L
.22222 .90269 L
.2619 .90852 L
.30159 .91394 L
.34127 .91874 L
.38095 .9227 L
.42063 .92565 L
.46032 .92748 L
.5 .9281 L
.53968 .92748 L
.57937 .92565 L
.61905 .9227 L
.65873 .91874 L
.69841 .91394 L
.7381 .90852 L
.77778 .90269 L
.81628 .89683 L
.81746 .89665 L
.85714 .89063 L
.89683 .88474 L
.93651 .87909 L
.97619 .87376 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .87376 m
.06349 .87909 L
.10317 .88474 L
.14286 .89063 L
.18254 .89665 L
.18372 .89683 L
.22222 .90269 L
.2619 .90852 L
.30159 .91394 L
.34127 .91874 L
.38095 .9227 L
.42063 .92565 L
.46032 .92748 L
.5 .9281 L
.53968 .92748 L
.57937 .92565 L
.61905 .9227 L
.65873 .91874 L
.69841 .91394 L
.7381 .90852 L
.77778 .90269 L
.81628 .89683 L
.81746 .89665 L
.85714 .89063 L
.89683 .88474 L
.93651 .87909 L
.97619 .87376 L
s
0 .16 1 r
.02381 .8852 m
.06349 .89044 L
.10317 .89597 L
.1092 .89683 L
.14286 .90173 L
.18254 .90761 L
.22222 .91345 L
.2619 .91906 L
.30159 .92426 L
.34127 .92883 L
.38095 .93261 L
.42063 .93543 L
.43467 .93651 L
.46032 .93717 L
.5 .93776 L
.53968 .93717 L
.56533 .93651 L
.57937 .93543 L
.61905 .93261 L
.65873 .92883 L
.69841 .92426 L
.7381 .91906 L
.77778 .91345 L
.81746 .90761 L
.85714 .90173 L
.8908 .89683 L
.89683 .89597 L
.93651 .89044 L
.97619 .8852 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .8852 m
.06349 .89044 L
.10317 .89597 L
.1092 .89683 L
.14286 .90173 L
.18254 .90761 L
.22222 .91345 L
.2619 .91906 L
.30159 .92426 L
.34127 .92883 L
.38095 .93261 L
.42063 .93543 L
.43467 .93651 L
.46032 .93717 L
.5 .93776 L
.53968 .93717 L
.56533 .93651 L
.57937 .93543 L
.61905 .93261 L
.65873 .92883 L
.69841 .92426 L
.7381 .91906 L
.77778 .91345 L
.81746 .90761 L
.85714 .90173 L
.8908 .89683 L
.89683 .89597 L
.93651 .89044 L
.97619 .8852 L
s
.08 0 1 r
.02381 .89619 m
.02881 .89683 L
.06349 .90137 L
.10317 .90682 L
.14286 .91245 L
.18254 .91816 L
.22222 .9238 L
.2619 .9292 L
.30159 .93419 L
.32168 .93651 L
.34127 .93858 L
.38095 .94219 L
.42063 .94489 L
.46032 .94655 L
.5 .94711 L
.53968 .94655 L
.57937 .94489 L
.61905 .94219 L
.65873 .93858 L
.67832 .93651 L
.69841 .93419 L
.7381 .9292 L
.77778 .9238 L
.81746 .91816 L
.85714 .91245 L
.89683 .90682 L
.93651 .90137 L
.97119 .89683 L
.97619 .89619 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .89619 m
.02881 .89683 L
.06349 .90137 L
.10317 .90682 L
.14286 .91245 L
.18254 .91816 L
.22222 .9238 L
.2619 .9292 L
.30159 .93419 L
.32168 .93651 L
.34127 .93858 L
.38095 .94219 L
.42063 .94489 L
.46032 .94655 L
.5 .94711 L
.53968 .94655 L
.57937 .94489 L
.61905 .94219 L
.65873 .93858 L
.67832 .93651 L
.69841 .93419 L
.7381 .9292 L
.77778 .9238 L
.81746 .91816 L
.85714 .91245 L
.89683 .90682 L
.93651 .90137 L
.97119 .89683 L
.97619 .89619 L
s
.32 0 1 r
.02381 .90684 m
.06349 .91194 L
.10317 .91728 L
.14286 .92277 L
.18254 .92832 L
.22222 .93378 L
.24268 .93651 L
.2619 .93899 L
.30159 .94379 L
.34127 .94801 L
.38095 .95148 L
.42063 .95407 L
.46032 .95566 L
.5 .9562 L
.53968 .95566 L
.57937 .95407 L
.61905 .95148 L
.65873 .94801 L
.69841 .94379 L
.7381 .93899 L
.75732 .93651 L
.77778 .93378 L
.81746 .92832 L
.85714 .92277 L
.89683 .91728 L
.93651 .91194 L
.97619 .90684 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .90684 m
.06349 .91194 L
.10317 .91728 L
.14286 .92277 L
.18254 .92832 L
.22222 .93378 L
.24268 .93651 L
.2619 .93899 L
.30159 .94379 L
.34127 .94801 L
.38095 .95148 L
.42063 .95407 L
.46032 .95566 L
.5 .9562 L
.53968 .95566 L
.57937 .95407 L
.61905 .95148 L
.65873 .94801 L
.69841 .94379 L
.7381 .93899 L
.75732 .93651 L
.77778 .93378 L
.81746 .92832 L
.85714 .92277 L
.89683 .91728 L
.93651 .91194 L
.97619 .90684 L
s
.56 0 1 r
.02381 .91713 m
.06349 .92215 L
.10317 .92738 L
.14286 .93274 L
.17053 .93651 L
.18254 .93813 L
.22222 .94343 L
.2619 .94847 L
.30159 .95311 L
.34127 .95717 L
.38095 .96052 L
.42063 .96302 L
.46032 .96456 L
.5 .96508 L
.53968 .96456 L
.57937 .96302 L
.61905 .96052 L
.65873 .95717 L
.69841 .95311 L
.7381 .94847 L
.77778 .94343 L
.81746 .93813 L
.82947 .93651 L
.85714 .93274 L
.89683 .92738 L
.93651 .92215 L
.97619 .91713 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .91713 m
.06349 .92215 L
.10317 .92738 L
.14286 .93274 L
.17053 .93651 L
.18254 .93813 L
.22222 .94343 L
.2619 .94847 L
.30159 .95311 L
.34127 .95717 L
.38095 .96052 L
.42063 .96302 L
.46032 .96456 L
.5 .96508 L
.53968 .96456 L
.57937 .96302 L
.61905 .96052 L
.65873 .95717 L
.69841 .95311 L
.7381 .94847 L
.77778 .94343 L
.81746 .93813 L
.82947 .93651 L
.85714 .93274 L
.89683 .92738 L
.93651 .92215 L
.97619 .91713 L
s
.8 0 1 r
.02381 .92709 m
.06349 .93203 L
.09823 .93651 L
.10317 .93715 L
.14286 .94239 L
.18254 .94765 L
.22222 .95279 L
.2619 .95768 L
.30159 .96217 L
.34127 .96611 L
.38095 .96936 L
.42063 .97177 L
.46032 .97326 L
.5 .97377 L
.53968 .97326 L
.57937 .97177 L
.61905 .96936 L
.65873 .96611 L
.69841 .96217 L
.7381 .95768 L
.77778 .95279 L
.81746 .94765 L
.85714 .94239 L
.89683 .93715 L
.90177 .93651 L
.93651 .93203 L
.97619 .92709 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .92709 m
.06349 .93203 L
.09823 .93651 L
.10317 .93715 L
.14286 .94239 L
.18254 .94765 L
.22222 .95279 L
.2619 .95768 L
.30159 .96217 L
.34127 .96611 L
.38095 .96936 L
.42063 .97177 L
.46032 .97326 L
.5 .97377 L
.53968 .97326 L
.57937 .97177 L
.61905 .96936 L
.65873 .96611 L
.69841 .96217 L
.7381 .95768 L
.77778 .95279 L
.81746 .94765 L
.85714 .94239 L
.89683 .93715 L
.90177 .93651 L
.93651 .93203 L
.97619 .92709 L
s
1 0 .96 r
.02381 .06325 m
.06349 .05839 L
.10317 .05336 L
.14286 .04824 L
.18254 .04311 L
.22222 .0381 L
.2619 .03334 L
.30159 .02896 L
.34127 .02513 L
.35646 .02381 L
.02381 .02381 L
F
0 g
.02381 .06325 m
.06349 .05839 L
.10317 .05336 L
.14286 .04824 L
.18254 .04311 L
.22222 .0381 L
.2619 .03334 L
.30159 .02896 L
.34127 .02513 L
.35646 .02381 L
s
1 0 .96 r
.02381 .93675 m
.06349 .94161 L
.10317 .94664 L
.14286 .95176 L
.18254 .95689 L
.22222 .9619 L
.2619 .96666 L
.30159 .97104 L
.34127 .97487 L
.35646 .97619 L
.02381 .97619 L
F
0 g
.02381 .93675 m
.06349 .94161 L
.10317 .94664 L
.14286 .95176 L
.18254 .95689 L
.22222 .9619 L
.2619 .96666 L
.30159 .97104 L
.34127 .97487 L
.35646 .97619 L
s
1 0 .72 r
.02381 .05387 m
.06349 .04909 L
.10317 .04414 L
.14286 .03912 L
.18254 .0341 L
.22222 .0292 L
.2619 .02454 L
.26835 .02381 L
.02381 .02381 L
F
0 g
.02381 .05387 m
.06349 .04909 L
.10317 .04414 L
.14286 .03912 L
.18254 .0341 L
.22222 .0292 L
.2619 .02454 L
.26835 .02381 L
s
1 0 .72 r
.02381 .94613 m
.06349 .95091 L
.10317 .95586 L
.14286 .96088 L
.18254 .9659 L
.22222 .9708 L
.2619 .97546 L
.26835 .97619 L
.02381 .97619 L
F
0 g
.02381 .94613 m
.06349 .95091 L
.10317 .95586 L
.14286 .96088 L
.18254 .9659 L
.22222 .9708 L
.2619 .97546 L
.26835 .97619 L
s
1 0 .48 r
.02381 .04474 m
.06349 .04001 L
.10317 .03515 L
.14286 .03021 L
.18254 .02528 L
.19448 .02381 L
.02381 .02381 L
F
0 g
.02381 .04474 m
.06349 .04001 L
.10317 .03515 L
.14286 .03021 L
.18254 .02528 L
.19448 .02381 L
s
1 0 .48 r
.02381 .95526 m
.06349 .95999 L
.10317 .96485 L
.14286 .96979 L
.18254 .97472 L
.19448 .97619 L
.02381 .97619 L
F
0 g
.02381 .95526 m
.06349 .95999 L
.10317 .96485 L
.14286 .96979 L
.18254 .97472 L
.19448 .97619 L
s
1 0 .24 r
.02381 .03582 m
.06349 .03115 L
.10317 .02635 L
.12389 .02381 L
.02381 .02381 L
F
0 g
.02381 .03582 m
.06349 .03115 L
.10317 .02635 L
.12389 .02381 L
s
1 0 .24 r
.02381 .96418 m
.06349 .96885 L
.10317 .97365 L
.12389 .97619 L
.02381 .97619 L
F
0 g
.02381 .96418 m
.06349 .96885 L
.10317 .97365 L
.12389 .97619 L
s
1 0 0 r
.02381 .02709 m
.05211 .02381 L
.02381 .02381 L
F
0 g
.02381 .02709 m
.05211 .02381 L
s
1 0 0 r
.02381 .97291 m
.05211 .97619 L
.02381 .97619 L
F
0 g
.02381 .97291 m
.05211 .97619 L
s
1 .24 0 r
.5 .37852 m
.5196 .38095 L
.53968 .39218 L
.57231 .42063 L
.57604 .46032 L
.53968 .49077 L
.5 .49692 L
.46032 .49077 L
.42396 .46032 L
.42769 .42063 L
.46032 .39218 L
.4804 .38095 L
F
0 g
.5 .37852 m
.5196 .38095 L
.53968 .39218 L
.57231 .42063 L
.57604 .46032 L
.53968 .49077 L
.5 .49692 L
.46032 .49077 L
.42396 .46032 L
.42769 .42063 L
.46032 .39218 L
.4804 .38095 L
.5 .37852 L
s
1 .24 0 r
.46032 .50923 m
.5 .50308 L
.53968 .50923 L
.57604 .53968 L
.57231 .57937 L
.53968 .60782 L
.5196 .61905 L
.5 .62148 L
.4804 .61905 L
.46032 .60782 L
.42769 .57937 L
.42396 .53968 L
F
0 g
.46032 .50923 m
.5 .50308 L
.53968 .50923 L
.57604 .53968 L
.57231 .57937 L
.53968 .60782 L
.5196 .61905 L
.5 .62148 L
.4804 .61905 L
.46032 .60782 L
.42769 .57937 L
.42396 .53968 L
.46032 .50923 L
s
1 .48 0 r
.5 .40928 m
.53495 .42063 L
.53968 .42457 L
.55057 .46032 L
.53968 .47374 L
.5 .4906 L
.46032 .47374 L
.44943 .46032 L
.46032 .42457 L
.46505 .42063 L
F
0 g
.5 .40928 m
.53495 .42063 L
.53968 .42457 L
.55057 .46032 L
.53968 .47374 L
.5 .4906 L
.46032 .47374 L
.44943 .46032 L
.46032 .42457 L
.46505 .42063 L
.5 .40928 L
s
1 .48 0 r
.46032 .52626 m
.5 .5094 L
.53968 .52626 L
.55057 .53968 L
.53968 .57543 L
.53495 .57937 L
.5 .59072 L
.46505 .57937 L
.46032 .57543 L
.44943 .53968 L
F
0 g
.46032 .52626 m
.5 .5094 L
.53968 .52626 L
.55057 .53968 L
.53968 .57543 L
.53495 .57937 L
.5 .59072 L
.46505 .57937 L
.46032 .57543 L
.44943 .53968 L
.46032 .52626 L
s
1 .72 0 r
.5 .42245 m
.53789 .46032 L
.5 .48529 L
.46211 .46032 L
F
0 g
.5 .42245 m
.53789 .46032 L
.5 .48529 L
.46211 .46032 L
.5 .42245 L
s
1 .72 0 r
.5 .51471 m
.53789 .53968 L
.5 .57755 L
.46211 .53968 L
F
0 g
.5 .51471 m
.53789 .53968 L
.5 .57755 L
.46211 .53968 L
.5 .51471 L
s
1 .96 0 r
.5 .42886 m
.53114 .46032 L
.5 .48036 L
.46886 .46032 L
F
0 g
.5 .42886 m
.53114 .46032 L
.5 .48036 L
.46886 .46032 L
.5 .42886 L
s
1 .96 0 r
.5 .51964 m
.53114 .53968 L
.5 .57114 L
.46886 .53968 L
F
0 g
.5 .51964 m
.53114 .53968 L
.5 .57114 L
.46886 .53968 L
.5 .51964 L
s
.8 1 0 r
.5 .43525 m
.52445 .46032 L
.5 .47553 L
.47555 .46032 L
F
0 g
.5 .43525 m
.52445 .46032 L
.5 .47553 L
.47555 .46032 L
.5 .43525 L
s
.8 1 0 r
.5 .52447 m
.52445 .53968 L
.5 .56475 L
.47555 .53968 L
F
0 g
.5 .52447 m
.52445 .53968 L
.5 .56475 L
.47555 .53968 L
.5 .52447 L
s
.56 1 0 r
.5 .44208 m
.51736 .46032 L
.5 .47054 L
.48264 .46032 L
F
0 g
.5 .44208 m
.51736 .46032 L
.5 .47054 L
.48264 .46032 L
.5 .44208 L
s
.56 1 0 r
.5 .52946 m
.51736 .53968 L
.5 .55792 L
.48264 .53968 L
F
0 g
.5 .52946 m
.51736 .53968 L
.5 .55792 L
.48264 .53968 L
.5 .52946 L
s
.32 1 0 r
.5 .45029 m
.50902 .46032 L
.5 .46506 L
.49098 .46032 L
F
0 g
.5 .45029 m
.50902 .46032 L
.5 .46506 L
.49098 .46032 L
.5 .45029 L
s
.32 1 0 r
.5 .53494 m
.50902 .53968 L
.5 .54971 L
.49098 .53968 L
F
0 g
.5 .53494 m
.50902 .53968 L
.5 .54971 L
.49098 .53968 L
.5 .53494 L
s
1 0 .96 r
.97619 .06325 m
.93651 .05839 L
.89683 .05336 L
.85714 .04824 L
.81746 .04311 L
.77778 .0381 L
.7381 .03334 L
.69841 .02896 L
.65873 .02513 L
.64354 .02381 L
.97619 .02381 L
F
0 g
.97619 .06325 m
.93651 .05839 L
.89683 .05336 L
.85714 .04824 L
.81746 .04311 L
.77778 .0381 L
.7381 .03334 L
.69841 .02896 L
.65873 .02513 L
.64354 .02381 L
s
1 0 .96 r
.97619 .93675 m
.93651 .94161 L
.89683 .94664 L
.85714 .95176 L
.81746 .95689 L
.77778 .9619 L
.7381 .96666 L
.69841 .97104 L
.65873 .97487 L
.64354 .97619 L
.97619 .97619 L
F
0 g
.97619 .93675 m
.93651 .94161 L
.89683 .94664 L
.85714 .95176 L
.81746 .95689 L
.77778 .9619 L
.7381 .96666 L
.69841 .97104 L
.65873 .97487 L
.64354 .97619 L
s
1 0 .72 r
.97619 .05387 m
.93651 .04909 L
.89683 .04414 L
.85714 .03912 L
.81746 .0341 L
.77778 .0292 L
.7381 .02454 L
.73165 .02381 L
.97619 .02381 L
F
0 g
.97619 .05387 m
.93651 .04909 L
.89683 .04414 L
.85714 .03912 L
.81746 .0341 L
.77778 .0292 L
.7381 .02454 L
.73165 .02381 L
s
1 0 .72 r
.97619 .94613 m
.93651 .95091 L
.89683 .95586 L
.85714 .96088 L
.81746 .9659 L
.77778 .9708 L
.7381 .97546 L
.73165 .97619 L
.97619 .97619 L
F
0 g
.97619 .94613 m
.93651 .95091 L
.89683 .95586 L
.85714 .96088 L
.81746 .9659 L
.77778 .9708 L
.7381 .97546 L
.73165 .97619 L
s
1 0 .48 r
.97619 .04474 m
.93651 .04001 L
.89683 .03515 L
.85714 .03021 L
.81746 .02528 L
.80552 .02381 L
.97619 .02381 L
F
0 g
.97619 .04474 m
.93651 .04001 L
.89683 .03515 L
.85714 .03021 L
.81746 .02528 L
.80552 .02381 L
s
1 0 .48 r
.97619 .95526 m
.93651 .95999 L
.89683 .96485 L
.85714 .96979 L
.81746 .97472 L
.80552 .97619 L
.97619 .97619 L
F
0 g
.97619 .95526 m
.93651 .95999 L
.89683 .96485 L
.85714 .96979 L
.81746 .97472 L
.80552 .97619 L
s
1 0 .24 r
.97619 .03582 m
.93651 .03115 L
.89683 .02635 L
.87611 .02381 L
.97619 .02381 L
F
0 g
.97619 .03582 m
.93651 .03115 L
.89683 .02635 L
.87611 .02381 L
s
1 0 .24 r
.97619 .96418 m
.93651 .96885 L
.89683 .97365 L
.87611 .97619 L
.97619 .97619 L
F
0 g
.97619 .96418 m
.93651 .96885 L
.89683 .97365 L
.87611 .97619 L
s
1 0 0 r
.97619 .02709 m
.94789 .02381 L
.97619 .02381 L
F
0 g
.97619 .02709 m
.94789 .02381 L
s
1 0 0 r
.97619 .97291 m
.94789 .97619 L
.97619 .97619 L
F
0 g
.97619 .97291 m
.94789 .97619 L
s
.5 .5 m
.5 .5 .15873 0 365.73 arc
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{205, 204.875},
  ImageMargins->{{55.9375, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400040000101000`40O003h00Oogoo0Goo000JOol3
000NOol5000OOol5000IOol4000NOol5000MOol5000NOol3000IOol001Uoo`05001oogooOol0000M
Ool01@00Oomoogoo00008Goo00<007ooOol067oo00<007ooOol00Woo00<007ooOol07Goo00<007oo
Ool07Goo00D007ooOomoo`0001eoo`05001oogooOol0000HOol001eoo`03001oogoo01aoo`03001o
ogoo029oo`03001oogoo01Qoo`03001oogoo009oo`03001oogoo01eoo`03001oogoo01ioo`03001o
ogoo029oo`03001oogoo01Ioo`004Goo1P001Woo00<007ooOol04goo1P0017oo00<007ooOol05Woo
1P001Goo00<007ooOol067oo00<007ooOol00Woo00<007ooOol07Goo00<007ooOol07goo00<007oo
Ool08Goo00<007ooOol05Woo000KOol2000QOol00`00Oomoo`0POol00`00Oomoo`0HOol00`00Oomo
o`02Ool00`00Oomoo`0MOol00`00Oomoo`0POol00`00Oomoo`0NOol2000IOol001eoo`03001oogoo
01moo`03001oogoo01moo`03001oogoo01Qoo`03001oogoo009oo`03001oogoo01eoo`03001oogoo
025oo`03001oogoo01moo`03001oogoo01Ioo`006Goo00D007ooOomoo`0001eoo`05001oogooOol0
000OOol3000JOol00`00Oomoo`02Ool00`00Oomoo`0KOol3000OOol01@00Oomoogoo00007Goo00D0
07ooOomoo`0001Qoo`006Woo0`007goo0`008Woo00<007ooOol06Goo100087oo00<007ooOol07Woo
0`007goo0`006Goo003oOol1Ool00?moo`5oo`00ogoo0Goo003oOol1Ool00?moo`5oo`004goof@00
57oo000COol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`0BOol001=oo`03001oogoo009o
o`03001oogoo01moo`03001oogoo021oo`03001oogoo01moo`03001oogoo01moo`03001oogoo021o
o`03001oogoo01moo`03001oogoo009oo`03001oogoo019oo`002Woo0`001Woo00<007ooOol0JGoo
00<007ooOol0JGoo00<007ooOol04Woo0009Ool01@00Oomoogoo00001Goo00<007ooOol0JGoo00<0
07ooOol0JGoo00<007ooOol04Woo000=Ool00`00Oomoo`03Ool00`00Oomoo`1YOol00`00Oomoo`1Y
Ool00`00Oomoo`0BOol00003Ool0000000@000Ioo`03001oogoo00=oo`8000=oo`L000Ioo`T000Qo
o`P000Uoo`L000]oo`P0015ooaX0019oo`P000]oo`L000Uoo`P000Qoo`T000Ioo`L000=oo`8001Ao
o`002goo0P001Woo00<007ooOol00Woo00Al1g`6O0Ml1PT00009O0il3g`>O0ml3W`?O0il3g`>00P0
00Ul5PP00009O1el7W`MO1il7G`NO1el7W`M00T00008H1mT7f0OI1mP7f@OH1mT7a4000=47`05@1m4
7d@OA1m07`03A1l01D0OA1m47d@O@1l00d@O00E07d@OA1m47d0O00947a400009H1mT7f0OI1mP7f@O
H1mT7f0O00T00009O1el7W`MO1il7G`NO1el7W`M00P000Ul5PP00009O0il3g`>O0ml3W`?O0il3g`>
00T00003O0Il1g`600Eoo`03001oogoo019oo`003Goo00<007ooOol00goo00<007ooOol00Woo1000
2G`>2@0027`F2@000g`N00El7G`NO1il7W`M00T00009H1mT7f0OI1mP7f@OH1mT7f0O00P000U47b/0
00Q47`T00009H1mT7f0OI1mP7f@OH1mT7f0O00T0009l7P06O1el7W`NO1il7G`N2@0027`F2@002G`>
100017oo00<007ooOol04Woo0009Ool01@00Oomoogoo00001Goo00<007ooOol00Woo00Al3g`>O0ml
3PT000Ul5PP00009O1il7G`NO1el7W`MO1il7G`N00P00009H1mT7f0OI1mP7f@OH1mT7f0O00T00094
7`06@1m47d@OA1m07d@O2@000R@O00DX7b@O91lT7bPO00<T7`05:1lT7b@O91lX7`0391l01BPO91lT
7b@O:1l00b@O00DX7b@O91lT7bPO00<T7`05:1lT7b@O91lX7`0391l00bPO000000060002A1l01D0O
A1m47d@O@1l00T@O2@0000UP7f@OH1mT7f0OI1mP7f@OH1l0200000Ul7W`MO1il7G`NO1el7W`MO1h0
20002G`F2@0000=l3W`?O0h01Goo00<007ooOol04Woo000:Ool30006Ool00`00Oomoo`02Ool40009
O1H90002O1h01W`MO1il7W`NO1el7PT00008I1mP7f@OH1mT7f0OI1mP7`T000U47`P000TT7b/000PT
7`T000U47`P00009I1mP7f@OH1mT7f0OI1mP7f@O00T000=l7P05O1el7W`NO1il7@090009O1H40004
Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`Al5PT00009O1el7W`MO1il7G`NO1el7W`M00P0
0009I1mP7f@OH1mT7f0OI1mP7f@O00P000947`05@1m47d@OA1m07`02A1l900000b@O:1lT7`0291l0
0bPO91lT7`090000:`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l4
7`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO00P0000391lX7b@O008T7`04:1lT
7b@O91l90002A1l01T0OA1m47d@O@1m47`T00009I1mP7f@OH1mT7f0OI1mP7f@O00P00009O1el7W`M
O1il7G`NO1el7W`M00T000=l5PEoo`03001oogoo019oo`004goo00<007ooOol00Woo10000W`N00El
7G`NO1il7W`M009l7PT00008H1mT7f0OI1mP7f@OH1mT7`T000Q47`T000TT7`P0000921l47`PO11l8
7`@O21l47`PO02/0000821l47`PO11l87`@O21l47`T000TT7`P000U47`P00009H1mT7f0OI1mP7f@O
H1mT7f0O00T00005O1el7W`NO1il7@03O1h00g`M000000020004Ool00`00Oomoo`0BOol001=oo`03
001oogoo009oo`04O1il7G`NO1d900002F0OI1mP7f@OH1mT7f0OI1mP7`0800000d@O@1m47`02A1l0
140OA1m47d@O200000<T7bPO91l00R@O00@X7b@O91lT7`T0000811l87`@O21l47`PO11l87`T002/0
W`P0000911l87`@O21l47`PO11l87`@O00T0000391lX7b@O008T7`03:1lT7b@O00T000=47`05@1m4
7d@OA1m07`0900002F0OI1mP7f@OH1mT7f0OI1mP7`0900000g`MO1il7@05Ool00`00Oomoo`0BOol0
01=oo`03001oogoo009oo`@00008H1mT7f0OI1mP7f@OH1mT7`X000M47`X000HT7`/0000611l87`@O
21l47`PO2`002@2O:`00202O2`0000L47`PO11l87`@O21l47`0:000791l90008A1l900002F0OI1mP
7f@OH1mT7f0OI1mP7`040004Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`04I1mP7f@OH1l8
00000d@O@1m47`02A1l01D0OA1m47d@O@1l01`0000<T7bPO91l00R@O00DX7b@O91lT7bPO00H0000;
11l87`@O21l47`PO11l87`@O21l47`06000;09l90000:`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
00P000/0W`L0000:11l87`@O21l47`PO11l87`@O21l7000291l01BPO91lT7b@O:1l00R@O200000E0
7d@OA1m47d0O00=47`03@1l0000000H00004I1mP7f@OH1l5Ool00`00Oomoo`0BOol001=oo`03001o
ogoo009oo`@000U47`T000PT7`T0000821l47`PO11l87`@O21l47`T000T0W`P00141WaX00141W`T0
00T0W`P0000921l47`PO11l87`@O21l47`PO00P000TT7`T000Q47`D000Aoo`03001oogoo019oo`00
4goo00<007ooOol00Woo0d@O00=07`0000001`000b@O00HX7b@O91lT7bPO91l800002@PO11l87`@O
21l47`PO11l87`08000909l90000205o0Il1O`6O0Gl1W`5o0IlA00006P:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0WlA00002@5o0Il1O`6O0Gl1W`5o0Il1O`09
000809l9000020PO11l87`@O21l47`PO11l9000391l01RPO91lT7b@O:1lT7`P00004A1m07d@OA1l5
Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`@000/T7`L0000811l87`@O21l47`PO11l87`T0
00P0W`T000T1W`P00082O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00P9o6P000`9o00D2W`9o
0Wl2O`:O00<2O`060Yl2O`9o0Wl2W`9o2@002@6O20002@2O200000T47`PO11l87`@O21l47`PO11l0
1`002R@O1@0017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool291l01BPO91lT7b@O:1l00b@O
00<X7`0000000P0000T47`PO11l87`@O21l47`PO11l01P002@2O200000T1O`6O0Gl1W`5o0Il1O`6O
0Gl02@0000P2O`:O0Wl2W`9o0Yl2O`:O4@0000D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0
1@>O0gl3O`=o0il00`=o00<3W`=o0000400000T2O`:O0Wl2W`9o0Yl2O`:O0Wl02@0000P1O`6O0Gl1
W`5o0Il1O`6O2@00202O1`0000T47`PO11l87`@O21l47`PO11l010000R@O00DX7b@O91lT7bPO00<T
7`Eoo`03001oogoo019oo`004goo00<007ooOol00Woo12@O1`0000T87`@O21l47`PO11l87`@O21l0
1000202O1`002P6O1`0000<2O`:O0Wl00P9o00@2W`9o0Wl2O`P001X3O`T001T3O`T000<2O`060Yl2
O`9o0Wl2W`9o1P002`6O1P002@2O100000T87`@O21l47`PO11l87`@O21l01P0012@O1Goo00<007oo
Ool04Woo000COol00`00Oomoo`02Ool400002@PO11l87`@O21l47`PO11l87`07000809l400003@6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00@000090Wl2W`9o0Yl2O`:O0Wl2W`9o00L000<3O`050il3
O`=o0gl3W`030gl01P>O0gl3O`=o0il3Oa4000030o/3o0?k0083n`040o`3n`?k0o/A00030gl01@>O
0gl3O`=o0il00`=o00H3W`=o0gl3O`>O0gl70000209o0Yl2O`:O0Wl2W`9o0Yl400003@5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o00@000T0W`L0000821l47`PO11l87`@O21l47`D000Aoo`03001oogoo
019oo`004goo00<007ooOol00Woo00D47`PO11l87`@O00P000T0W`H000/1W`H00082O`050Yl2O`9o
0Wl2W`020Wl4000?0gl9000[0o/8000@0gl400020Wl01P:O0Wl2O`9o0Yl2O`L000X1W`H000X0W`P0
000411l87`@O21l5Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`D000P0W`T000080Il1O`6O
0Gl1W`5o0Il1O`T000080Wl2W`9o0Yl2O`:O0Wl2W`L000050il3O`=o0gl3W`030gl00`>O0gl00008
00000`?k0o`3n`020o/010?l0o/3n`?k:`0000<3n`?l0o/00P?k00<3o0?k0o/02@0000D3W`=o0gl3
O`>O00<3O`030il3O`=o00L000080Yl2O`:O0Wl2W`9o0Yl2O`P000080Il1O`6O0Gl1W`5o0Il1O`X0
00P0W`D000Aoo`03001oogoo019oo`004goo00<007ooOol00Woo102O2@002@6O20000`9o00H2W`9o
0Wl2O`:O0Wl800090gl800090o/900030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`05
0o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`P000T3n`T000T3O`P0
00030Wl2W`9o0082O`030Yl2O`9o00T000T1W`P000@0W`Eoo`03001oogoo019oo`004goo00<007oo
Ool00Woo100000/1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00L0000:0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl7
00000`=o0il3O`020gl00`>O0gl3O`0900001@?l0o/3n`?k0o`00`?k00<3o00000001P000143l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c01X0000A0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m00900020o/01@?l0o/3n`?k0o`00P?k200000<3O`>O0gl00P=o00@3W`=o0gl3O`H0
000;0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`0700002P6O0Gl1W`5o0Il1O`6O0Gl1W`5o1@0017oo00<0
07ooOol04Woo000COol00`00Oomoo`02Ool;0Il400001@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O
00@000T3O`H000/3n`L00083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00P?c20006P?/2@00
0P?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<7000:0o/700080gl400000`9o0Yl2O`02
0Wl01@:O0Wl2O`9o0Yl00`9o00<2W`0000000P002P6O1Goo00<007ooOol04Woo000COol00`00Oomo
o`02Ool0106O0Gl1W`5o1`0000/2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o00H00083O`050il3O`=o0gl3
W`020gl400000`?k0o`3n`020o/01@?l0o/3n`?k0o`00`?k100000l3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@02@0002/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k008000040?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d100000<3n`?l0o/00P?k00D3o0?k0o/3n`?l00<3n`@000050il3
O`=o0gl3W`030gl700002`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl01P0000@1W`5o0Il1O`Eoo`03001o
ogoo019oo`004goo00<007ooOol00Woo100000<2O`:O0Wl00P9o00@2W`9o0Wl2O`T000P3O`L000X3
n`L000<3l`050o@3l`?c0o<3m0030o<800090n`[00080n`900030o<01@?d0o<3l`?c0o@00`?c1P00
2`?k1P002@=o2@000`9o00D2W`9o0Wl2O`:O00D000Aoo`03001oogoo019oo`004goo00<007ooOol0
0Woo00@2W`9o0Yl2O`T000<3O`050il3O`=o0gl3W`030gl600020o/01@?l0o/3n`?k0o`00`?k00<3
o0000000100000T3l`?d0o<3m0?c0o@3l`?d0o<02@0000P3j`?/0n/3k0?[0n`3j`?/2@00:`?T2000
00T3j`?/0n/3k0?[0n`3j`?/0n/02@0000P3l`?d0o<3m0?c0o@3l`?d1`000P?k00D3o0?k0o/3n`?l
00<3n`L000030gl3W`=o0083O`060il3O`=o0gl3W`=o200000@2W`9o0Yl2O`Eoo`03001oogoo019o
o`004goo00<007ooOol00Woo100040=o10003@?k10000P?c00H3m0?c0o<3l`?d0o<7000:0n`7000J
0n@9000I0n@8000:0n`700000`?c0o@3l`020o<00`?d0o<3l`04000=0o/4000?0gl50004Ool00`00
Oomoo`0BOol001=oo`03001oogoo009oo`83O`050il3O`=o0gl3W`030gl:00020o/01P?l0o/3n`?k
0o`3n`T000080o<3m0?c0o@3l`?d0o<3m0@0000<0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/1@003`?T
4P0000T7h0_P1n0;h0OP2n07h0_P1n004P003`?T100000d3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`04000020?d0o<3m0?c0o@3l`?d0o<900030o/01@?l0o/3n`?k0o`02@000P=o00D3W`=o0gl3O`>O
00<3O`Eoo`03001oogoo019oo`004goo00<007ooOol00Woo10=o1P0030?k1P0000<3l`?d0o<00P?c
00H3m0?c0o<3l`?d0o<6000;0n`5000<0n@80000;@_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h007000<0n@6000;0n`600000`?c0o@3l`020o<01P?d0o<3l`?c0o@3l`H000/3n`H000@3O`Eoo`03
001oogoo019oo`004goo00<007ooOol00Woo100000D3o0?k0o/3n`?l00<3n`030o`3n`?k00L0000:
0o@3l`?d0o<3m0?c0o@3l`?d0o<700002P?[0n`3j`?/0n/3k0?[0n`3j`?/1`002`?T1P000147h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP01X0000A2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h007000;0n@600002`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/01P0000/3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d00L000050o`3n`?k0o/3o0030o/00`?l0o/000040004Ool00`00Oomoo`0BOol0
01=oo`03001oogoo009oo`/3n`@000050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@010003@?/1000
3P?T100000l;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n0020006ROP2@0000l;h0OP2n07h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n0010003@?T10003@?/100000<3l`?d0o<00P?c00D3m0?c0o<3l`?d
00<3l`030o@00000008000X3n`Eoo`03001oogoo019oo`004goo00<007ooOol00Woo0P?k00<3o0?k
00001P0000/3l`?d0o<3m0?c0o@3l`?d0o<3m0?c00H0000;0n`3j`?/0n/3k0?[0n`3j`?/0n/3k006
000;0n@700002POP2n07h0_P1n0;h0OP2n07h0_P2@0000D[h2OP9n0Wh2_P00<Wh005:n0Wh2OP9n0[
h0039n001B_P9n0Wh2OP:n000bOP00D[h2OP9n0Wh2_P00<Wh005:n0Wh2OP9n0[h0039n000b_P9n0W
h00800002`OP2n07h0_P1n0;h0OP2n07h0_P1n001`002P?T1`0000X3k0?[0n`3j`?/0n/3k0?[0n`3
j`L0000;0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`06000010?l0o/3n`?k1Goo00<007ooOol04Woo000C
Ool00`00Oomoo`02Ool400000`?c0o@3l`020o<01P?d0o<3l`?c0o@3l`L000X3k0L000X3i0L0000;
1n0;h0OP2n07h0_P1n0;h0OP2n07h006000J9n09000I9n0700002`OP2n07h0_P1n0;h0OP2n07h0_P
1n001P002`?T1P002`?/1`0000<3l`?d0o<00P?c00D3m0?c0o<3l`?d00D000Aoo`03001oogoo019o
o`002Goo1@001Goo00<007ooOol00Woo00/3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00@0000=0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/010003@?T100000h7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P
100000<Wh2_P9n000ROP00D[h2OP9n0Wh2_P00<Wh003:n0Wh00001000005@n17h4OPAn13h003An00
0d?P0000000?00039n001B_P9n0Wh2OP:n000bOP00@[h2OP9n0Wh0@0000=2n07h0_P1n0;h0OP2n07
h0_P1n0;h0OP2n0010003@?T100000h3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[100000X3m0?c
0o@3l`?d0o<3m0?c0o@3l`Eoo`03001oogoo019oo`002Goo00D007ooOomoo`0000Eoo`03001oogoo
009oo`<3l`030o@0000000D000/3k0H000d3i0@0000=2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00
1@0032OP1`00:dOP1P003BOP1@0000`;h0OP2n07h0_P1n0;h0OP2n07h0_P1n05000<0n@7000;0n`6
000010?c0o@3l`?c1Goo00<007ooOol04Woo000:Ool00`00Oomoo`06Ool00`00Oomoo`02Ool40000
30?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`H000l3i0@0000=1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n00100000D[h2OP9n0Wh2_P00<Wh005:n0Wh2OP9n0[h0040002An001D?PAn17h4OP@n000dOP00E3
h4OPAn17h4?P00=7h005@n17h4OPAn13h003An001D?PAn17h4OP@n000dOP00E3h4OPAn17h4?P00=7
h005@n17h4OPAn13h003An001T?PAn17h4OP@n17h0@000<Wh005:n0Wh2OP9n0[h0039n000b_P9n0W
h00400003@OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00@000l3i0H0000;0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`050004Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Eoo`8000=o
o`/3k0D000h3i0L0000:2n07h0_P1n0;h0OP2n07h0_P1n07000:9n07000BAn0M000AAn08000:9n07
00002POP2n07h0_P1n0;h0OP2n07h0_P1`003P?T10002`?/17oo0P0057oo000<Ool00`00Oomoo`04
Ool00`00Oomoo`02Ool010?/0n/3k0?[1`003@?T1P0000/;h0OP2n07h0_P1n0;h0OP2n07h0_P00H0
00039n0[h2OP008Wh006:n0Wh2OP9n0[h2OP1P000dOP00E3h4OPAn17h4?P00=7h005@n17h4OPAn13
h002An0700007F?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn001`000TOP00E3h4OPAn17h4?P00=7h005@n17h4OPAn13h003An0600039n001B_P9n0W
h2OP:n000bOP1P0000/;h0OP2n07h0_P1n0;h0OP2n07h0_P00H000`3i0L000040n`3j`?/0n/5Ool0
0`00Oomoo`0BOol000eoo`03001oogoo00=oo`03001oogoo009oo`@00103i0@0000=1n0;h0OP2n07
h0_P1n0;h0OP2n07h0_P1n0010003BOP10003dOP2@0002]Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h008000@An04000=9n0400003@OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00@000l3i0D000Aoo`03
001oogoo019oo`002Goo00D007ooOomoo`0000Eoo`03001oogoo009oo`d3i0L0000<2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP1@0000<Wh2_P9n000ROP00D[h2OP9n0Wh2_P008Wh0D000=7h005@n17h4OP
An13h003An000d?PAn00000500004F?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn006P00
015Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00L00003An13h4OP0097h005@n17h4OP
An13h003An0400000bOP:n0Wh0029n001B_P9n0Wh2OP:n000bOP100000d;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h007000<0n@5Ool00`00Oomoo`0BOol000Yoo`<000Ioo`03001oogoo009oo`@3i0T0
000?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P00@000dWh0@000i7h0@0000AIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh00600001GnPOl1o`7o0Oj000go000EoX7o0Ol1o`7nP00=o
`005Oj1o`7o0Ol1oX003Ol000gnPOl00000600004FOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn0010003DOP10003BOP10000107h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0P000@3
i0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo1000018;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n07h0_P1n0600001B_P9n0Wh2OP:n000bOP00D[h2OP9n0Wh2_P00@00097h005@n17h4OP
An13h003An000d?PAn17h00500004F?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn001000
02Mo`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0
Oj1o`7nPOl1oX7o0Oj1o`7nPOl001000015Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
00D00097h005@n17h4OPAn13h003An000d?PAn00000400029n001B_P9n0Wh2OP:n000bOP00<[h2OP
00001P000147h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00D000Aoo`03001oogoo019o
o`004goo00<007ooOol00Woo00l7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n001`003bOP1000
3DOP100000mSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn001`0000EoX7o0Ol1o`7nP00=o`005
Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj000go000EoX7o0Ol1o`7nP00=o`005Oj1o`7o0Ol1oX003
Ol001GnPOl1o`7o0Oj000Wo01P00011Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0@000e7
h0@000lWh0L0000>1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0Eoo`03001oogoo019oo`004goo
00<007ooOol00Woo00/;h0OP2n07h0_P1n0;h0OP2n07h0_P00@000<Wh005:n0Wh2OP9n0[h0039n00
1R_P9n0Wh2OP:n0Wh0D00005@n17h4OPAn13h003An001D?PAn17h4OP@n00100000iWh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?P1@00015oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP01X0
000AOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`00600003V?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn0400001D?PAn17h4OP@n000dOP00E3h4OPAn17h4?P00@00005:n0Wh2OP9n0[h003
9n001B_P9n0Wh2OP:n000bOP00<[h2OP00000`0000X;h0OP2n07h0_P1n0;h0OP2n07h0Eoo`03001o
ogoo019oo`004goo00<007ooOol00Woo00D7h0_P1n0;h0OP00H0014Wh0@000m7h0<0000?Hn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00<0009o`005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj00
0Wo01@006Wk01@0000=o`7nPOl000Wo000EoX7o0Ol1o`7nP00=o`005Oj1o`7o0Ol1oX00300003f?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh003000>An04000B9n0500001@_P1n0;h0OP2n001Goo
00<007ooOol04Woo000COol00`00Oomoo`02Ool500039n001B_P9n0Wh2OP:n000bOP00H[h2OP9n0W
h2_P9n060003An001D?PAn17h4OP@n000dOP00=3h4OP00001@0000]Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?P00L0000@Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl04000TO/05000047o0Oj1o`7nP
Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP1`0000]Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00H00003An13
h4OP0097h005@n17h4OPAn13h002An0700039n001B_P9n0Wh2OP:n000bOP00D[h2OP9n0Wh2_P00H0
00Aoo`03001oogoo019oo`004goo00<007ooOol00Woo3bOP1`003dOP100000eWh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh0040002Ol001GnPOl1o`7o0Oj000go000EoX7o0Ol1o`7nP009o`0H002en`0D0
0003Ol1oX7o0009o`005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj00100000eWh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh004000?An07000>9n05Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`8W
h005:n0Wh2OP9n0[h0039n000b_P000000020002An001D?PAn17h4OP@n000dOP00E3h4OPAn17h4?P
0097h0D0000=Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn001000015o`7nPOl1oX7o0Oj1o`7nPOl1o
X7o0Oj1o`7nPOl1oX7o000@003Qn`0@0000BOj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1o
X7o0100000eSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0040003An001D?PAn17h4OP@n000dOP00E3
h4OPAn17h4?P0097h0@0008Wh005:n0Wh2OP9n0[h0039n05Ool00`00Oomoo`0BOol001=oo`03001o
ogoo009oo`@Wh0L00157h0@0000?Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00<00005Oj1o
`7o0Ol1oX003Ol001GnPOl1o`7o0Oj000go000=oX00000000P004gk06P004gk01@000Wo000EoX7o0
Ol1o`7nP00=o`005Oj1o`7o0Ol1oX002Ol0200003fOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h004000BAn0600049n05Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`@000=7h005@n17h4OP
An13h003An001D?PAn17h4OP@n000TOP1P00015Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OP0080000@Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl04000AO/0600006WgPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL07000AO/0400003go0Oj1o
`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`003000046OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?P1`000TOP00E3h4OPAn17h4?P00=7h005@n17h4OPAn13h002An050004Ool00`00Oomoo`0BOol0
01=oo`03001oogoo009oo`m7h0L0000CHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn0010000go000EoX7o0Ol1o`7nP00=o`003Oj1o`7o000@0015n`0@002Mm`0@0015n`0@00005Oj1o
`7o0Ol1oX003Ol001WnPOl1o`7o0Oj1o`0@0000CHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn001`003TOP1Goo00<007ooOol04Woo000COol00`00Oomoo`02Ool00dOP@n17h002An00
1T?PAn17h4OP@n17h0@0000FHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In0400003gnPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX003000@O/050000;ggPOL1mh7g0ON1m
`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m
`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON0010004Gk00`0000moX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1o
X7o0Oj00100001IWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0@00003
An13h4OP0097h005@n17h4OPAn13h005Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`A7h0L0
000DIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0H00003Ol1oX7o0009o`005
Oj1o`7o0Ol1oX003Ol000gnPOl1o`003000?O/04000hOL04000@O/0300001GnPOl1o`7o0Oj000go0
00EoX7o0Ol1o`7nP00=o`0H0000DHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h0H000A7h0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo100001MWh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00@0000AOj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0
Oj1o`7nPOl1oX005000?O/03000077g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gP2@0001]mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1m
h7g0ON1m`7gPOL1mh7g0ON0010003gk01@00015oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o
`7nP00@0000FIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn050004Ool0
0`00Oomoo`0BOol001=oo`03001oogoo009oo`0FHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn0500000go0Oj1o`002Ol001GnPOl1o`7o0Oj000go000EoX7o0Ol1o`7nP00<0
015n`0<001Im`0T00003O>1l`7cP009lh004O<1lh7cPO>08000GOL03000AO/030002Ol001GnPOl1o
`7o0Oj000go000EoX7o0Ol1o`7nP00=o`0D0000EIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OP00Eoo`03001oogoo019oo`004goo00<007ooOol00Woo00mWh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn001`0001=o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o
`004000AO/0300004gg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g000H0000JO>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`0L0000COL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL000`004Gk0100001=o`7nPOl1oX7o0Oj1o`7nP
Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`00700003VOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn05Ool0
0`00Oomoo`0BOol001=oo`03001oogoo009oo`0;Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0040003Ol00
1GnPOl1o`7o0Oj000go000EoX7o0Ol1o`7nP00=o`003Oj1o`7o000@0019n`0<0019m`0@0009lh005
O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003
O>001Gc0O>1lh7cPO<0010004Wg00`004Wk0100000EoX7o0Ol1o`7nP00=o`005Oj1o`7o0Ol1oX003
Ol001WnPOl1o`7o0Oj1o`0@0000:Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn05Ool00`00Oomoo`0BOol001=o
o`03001oogoo009oo`04In1Sh6OPHn0700005GnPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0
Oj1o`7nPOl1oX005000CO/0300004Gg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL001000
02mlh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP00@0000AOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`003000CO/0400005Wo0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP
Ol1oX7o0Oj1o`7nP1P0000AWh6?PIn1Sh0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo1000
00EoX7o0Ol1o`7nP00=o`005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj000go010005Gk00`004Gg0
0`0000El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1l
h7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c0009lh080019m
`0<001An`0@0009o`005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj000go000IoX7o0Ol1o`7nPOl05
0004Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`0HOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP
Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP10005Gk01000019m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m
`7gPOL1mh7g0ON020000?7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh0<0000BON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g00`00
5Gk01@0001MoX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP00Eoo`03
001oogoo019oo`004goo00<007ooOol00Woo0Wo000EoX7o0Ol1o`7nP00=o`005Oj1o`7o0Ol1oX003
Ol000gnPOl000003000EO/04000COL030003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=l
h005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l
`003O>001Gc0O>1lh7cPO<000gcP00Il`7cPO>1lh7c0O>02000COL04000FO/040003Ol001GnPOl1o
`7o0Oj000go000EoX7o0Ol1o`7nP00=o`0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo00io
`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP1P005Wk00`0001Em`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL000P0004Ilh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`080000EON1m`7gPOL1m
h7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP00<001Mn`0H0000=Oj1o`7nPOl1oX7o0Oj1o
`7nPOl1oX7o0Oj001Goo00<007ooOol04Woo000COol00`00Oomoo`02Ool017nPOl1o`7o02P006Wk0
0P005Wg00P000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP
5P000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP0`005Gg0
0`006Wk02@000Wo000=oX7o0Ool017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool4000PO/04
00005WgPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g00P0001Qlh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<04000FO00400006GcPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP0080000FOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON04000OO/050004Ool00`00Oomoo`0BOol001=o
o`03001oogoo009oob1n`0@001Mm`0<00005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El
`7cPO>1lh7c0009lh0<001il00@00005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cP
O>1lh7c0009lh0<001Mm`0<0021n`0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo77k01000
01Qmh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL03000067c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh08002El0080000HO>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c00`0001Mm`7gPOL1mh7g0ON1m
`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g000@001an`0Eoo`03001oogoo019oo`004goo
00<007ooOol00Woo5Wk01P006Gg00`0000El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0
O>1lh7cPO<000gcP00=l`0000000:G`00P000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003
O>001Gc0O>1lh7cPO<000WcP0`0067g01`005Gk01Goo00<007ooOol04Woo000:Ool50004Ool00`00
Oomoo`02Ool?O/07000077gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g00`0001Yl`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cP0P00;G`00P0001Ylh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c00`0001am`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1m
h7g0ON1m`7gPOL1mh0L000in`0Eoo`03001oogoo019oo`0037oo00<007ooOol017oo00<007ooOol0
0Woo2gk0100087g00`0000El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<00
0gcP00=l`7cP00000P00<G`00`000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0
O>1lh7cPO<000WcP0P008Gg010002Wk01Goo00<007ooOol04Woo000<Ool00`00Oomoo`04Ool00`00
Oomoo`02Ool4O/0700008Wg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP0P0001]l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<000P00=g`00P0001Yl`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP0`00029mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`0H000An`0Eoo`03001oogoo019o
o`0000=oo`00000010001Goo00<007ooOol017oo0P000goo100097g01@000gcP00El`7cPO>1lh7c0
00=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP0P00>g`00P0000=lh7c0O>000WcP00El
`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Wc0O>1lh7cPO<1lh0D002=m`0D000=oo`8001Ao
o`0037oo00<007ooOol017oo00<007ooOol00Woo02Amh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL0400007WcPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`08001al00H001el
0080000NO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cP100002=m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m
`7gPOL1mh7g0ON1m`7gPOL1mh7g000Eoo`03001oogoo019oo`0037oo00<007ooOol017oo00<007oo
Ool00Woo87g010000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<00
0gcP00El`7cPO>1lh7c0009lh003001l07`001Il018001Ul0003001l`7cP009lh005O<1lh7cPO>1l
`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003000POL05Ool0
0`00Oomoo`0BOol000Yoo`<000Ioo`03001oogoo009oo`0LON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL0400008gcPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>000P005G`06P005W`0
0P00029lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`0@0000LON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`7gPOL05Ool00`00Oomoo`0BOol000aoo`03001oogoo00Aoo`03001oogoo009ooaQm
`0@00005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cP
O>1l`003O>001Gc0O>1lh7cPO<000P0057`080005G`00P000WcP00El`7cPO>1lh7c000=lh005O<1l
h7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh003O<1lh00000@001Mm`0Eo
o`03001oogoo019oo`004goo00<007ooOol00Woo01Amh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0100002Mlh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>000P005G`08P005W`00P0002Mlh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>00100001=m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`005Ool0
0`00Oomoo`0BOol001=oo`03001oogoo009oo`em`0L0009lh005O<1lh7cPO>1l`003O>001Gc0O>1l
h7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000WcP0P00
5W`09@005W`00P0000El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP
00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>000gc000000005000<OL05Ool00`00Oomoo`0B
Ool001=oo`03001oogoo009oo`04ON1m`7gPOL090000<7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<0001Il02P001Ml000`001l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c02000
00Amh7g0ON1m`0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo100000El`7cPO>1lh7c000=l
h005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l
`003O>001Gc0O>1lh7cPO<000gcP00Il`7cPO>1lh7c0O>02000FO00Z000GO0020003O>001Gc0O>1l
h7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El
`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>000gc0O>0000040004Ool00`00Oomoo`0BOol001=o
o`03001oogoo009oo`0hO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`08001Il02d001Ql0080000gO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<001Goo00<007ooOol04Woo000COol00`00Oomoo`02Ool2O>001Gc0O>1lh7cP
O<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cP
O>1lh7c000=lh005O<1lh7cPO>1l`003O>000gc0O>1lh003000GO00`000HO00300001Gc0O>1lh7cP
O<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cP
O>1lh7c000=lh005O<1lh7cPO>1l`003O>0017c0O>1lh7cP1Goo00<007ooOol04Woo000COol00`00
Oomoo`02Ool0<WcPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<03000IO00b000J
O0030000<Gc0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c000Eoo`03001oogoo019o
o`004goo00<007ooOol00Woo00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cP
O<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000WcP0`006g`0
<`007G`00P0000=lh7c0O>000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1l
h7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>000gc0O>1oo`04Ool00`00Oomo
o`0BOol001=oo`03001oogoo009oo`0]O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP008001il
03@001il00<0000/O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`0Eoo`03001oogoo019oo`004goo
00<007ooOol00Woo0WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<00
0gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>03000OO00f000PO00300000gcPO<1lh002
O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cP
O<000gcP00Al`7cPO>1lh0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo02Mlh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>000`008G`0>0008W`00`0002Ilh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c01Goo00<007ooOol04Woo000C
Ool00`00Oomoo`02Ool01Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003
O>001Gc0O>1lh7cPO<000gcP00Al`7cPO>1lh0<002Al03T002Al00<00003O>1l`7cP009lh005O<1l
h7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh006O<1lh7cPO>1l`7cP1Goo
00<007ooOol04Woo000COol00`00Oomoo`02Ool087cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<04000VO00j000WO003000087cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<05Ool0
0`00Oomoo`0BOol001=oo`03001oogoo009oo`9lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<00
0gcP00Al`7cPO>1lh0X002Ul03`002Ul00/00003O>1l`7cP009lh005O<1lh7cPO>1l`003O>001Gc0
O>1lh7cPO<000gcP1Goo00<007ooOol04Woo000COol00`00Oomoo`02Ool03GcPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cP00T003=l03d003=l00T0000<O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c01Goo00<0
07ooOol04Woo000COol00`00Oomoo`02Ool017c0O>1lh7cP2@00>g`0?P00?7`020000WcP00=l`7cP
Ool017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool40013O0100013O0050004Ool00`00Oomo
o`0BOol001=oo`03001oogoo009oodMl040004Ml00Eoo`03001oogoo019oo`004goo00<007ooOol0
0WooAg`0@000Ag`01Goo00<007ooOol04Woo000COol00`00Oomoo`02Oom7O0110016O005Ool00`00
Oomoo`0BOol001=oo`03001oogoo009oodIl048004Il00Eoo`03001oogoo019oo`004goo00<007oo
Ool00WooAW`0@P00AW`01Goo00<007ooOol04Woo000COol00`00Oomoo`02Oom6O0130015O005Ool0
0`00Oomoo`0BOol001=oo`03001oogoo009oodEl04@004El00Eoo`03001oogoo019oo`004goo00<0
07ooOol00WooAG`0A000AG`01Goo00<007ooOol04Woo000COol00`00Oomoo`02Oom5O0140015O005
Ool00`00Oomoo`0BOol001=oo`03001oogoo009oodEl04@004El00Eoo`03001oogoo019oo`002Woo
10001Goo00<007ooOol00WooAG`0A000AG`01Goo00<007ooOol01Woo0P000Woo0P001Woo0009Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Oom5O0140015O005Ool00`00Oomoo`07Ool0
1000Oomoo`001goo0009Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Oom5O0140015
O005Ool00`00Oomoo`08Ool20008Ool000Uoo`03001oogoo009oo`03001oogoo009oo`D004El04@0
04El00H000Yoo`8000Qoo`002Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00WooAG`0
A000AG`01Goo00<007ooOol01goo00@007ooOol000Moo`002Goo00<007ooOol00Woo00<007ooOol0
0Woo00<007ooOol00WooAG`0A000AG`01Goo00<007ooOol01Woo0P000Woo0P001Woo0009Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Oom5O0140015O005Ool00`00Oomoo`0BOol000Yo
o`@000Eoo`03001oogoo009oodEl04@004El00Eoo`03001oogoo019oo`004goo00<007ooOol00Woo
AG`0A000AG`01Goo00<007ooOol04Woo000COol00`00Oomoo`02Oom5O0140015O005Ool00`00Oomo
o`0BOol001=oo`03001oogoo009oodEl04@004El00Eoo`03001oogoo019oo`004goo00<007ooOol0
0WooAW`0@P00AW`01Goo00<007ooOol04Woo000COol00`00Oomoo`02Oom6O0120016O005Ool00`00
Oomoo`0BOol001=oo`03001oogoo009oodIl048004Il00Eoo`03001oogoo019oo`004goo00<007oo
Ool00WooAg`0@@00AW`01Goo00<007ooOol04Woo000COol00`00Oomoo`02Oom7O0100017O005Ool0
0`00Oomoo`0BOol001=oo`03001oogoo009oodMl040004Ml00Eoo`03001oogoo019oo`004goo00<0
07ooOol00Woo1000A7`0?`00@g`01@0017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool2O>00
0gc0O>00000A000bO00n000cO00A000017c0O>1lh7cP1Goo00<007ooOol04Woo000COol00`00Oomo
o`02Ool05WcPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c01P00;G`0?000
;G`01`0001El`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<001Goo00<007oo
Ool04Woo000COol00`00Oomoo`02Ool01Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1l
h7cPO>1l`003O>0017c0O>1lh7cP1000:G`0>`00:W`010000WcP00El`7cPO>1lh7c000=lh005O<1l
h7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00=l`7cPOol017oo00<007ooOol04Woo000COol00`00
Oomoo`02Ool087cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<05000UO00j000VO004000087cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<05Ool00`00Oomoo`0BOol001=oo`03001o
ogoo009oo`9lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005
O<1lh7cPO>1l`003O>000gc0O>1lh004000RO00h000SO00400001Gc0O>1lh7cPO<000gcP00El`7cP
O>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00Al`7cPO>1lh0Eoo`03001o
ogoo019oo`004goo00<007ooOol00Woo02Ulh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP00<001ml03L0021l
00@0000XO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<05Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`05
O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003
O>001Gc0O>1lh7cPO<000gcP00Al`7cPO>1lh08001il03H001il0080009lh005O<1lh7cPO>1l`003
O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cP
O<000gcP00=l`7cPOol017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool0;WcPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c00P007G`0=0007G`00P0002ilh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo0WcP00El`7cPO>1lh7c000=l
h005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l
`003O>001Wc0O>1lh7cPO<1lh08001al038001al00800005O<1lh7cPO>1l`003O>001Gc0O>1lh7cP
O<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cP
O>1lh7c000=lh0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo039lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c00`006W`0<@006W`00P00039lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c01Goo00<007ooOol04Woo000COol00`00Oomoo`02Ool01Gc0O>1l
h7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El
`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000`005g`0<00067`00`000WcP
00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c0
00=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00=l`7cPOol017oo00<007ooOol04Woo
000COol00`00Oomoo`02Ool0>7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<02000FO00^000GO0020000=gc0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c000Eoo`03001oogoo019oo`004goo00<007ooOol00Woo10000WcP00El
`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=l
h005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00Al`7cPO>1lh08001El02/001Ml00800003
O>1l`7cP009lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005
O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh0D000Aoo`03001oogoo
019oo`004goo00<007ooOol00Woo00Amh7g0ON1m`0T0000_O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`002000EO00X000FO0020000;gc0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<00200000Amh7g0ON1m`0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo3Gg01`0000El`7cP
O>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005
O<1lh7cPO>1l`003O>0017c0O>00000057`09P005G`00P000gcP00El`7cPO>1lh7c000=lh005O<1l
h7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`002O>07
000<OL05Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`0DON1m`7gPOL1mh7g0ON1m`7gPOL1m
h7g0ON1m`7gPOL1mh7g0ON1m`0@0000XO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<02000DO00S000DO0020000
:7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cP100001=m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`005Ool00`00Oomoo`0BOol000Yoo`D000Aoo`03001oogoo009ooaQm`0H00005O<1lh7cPO>1l
`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>0017c0O>1l
h7cP0P004g`0800057`00P0000=lh7c0O>000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003
O>001Gc0O>1lh7cPO<000gcP00Il`7cPO>1lh7c0O>07000GOL05Ool00`00Oomoo`0BOol000aoo`03
001oogoo00Aoo`03001oogoo009oo`0NON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g01P00021lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c00P0057`06P005G`00P00021l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP1@0001im
h7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL05
Ool00`00Oomoo`0BOol000aoo`03001oogoo00Aoo`03001oogoo009oobAm`0@00005O<1lh7cPO>1l
`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh006O<1lh7cPO>1l`7cP0P005W`05000
5G`00P000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00=l
`7cPO>0010008gg01Goo00<007ooOol04Woo000<Ool00`00Oomoo`04Ool20003Ool0:7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g00P0001mlh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<00000HO00<000IO0007P00O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`0<0000WOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g000Aoo`80
01Aoo`0037oo00<007ooOol017oo00<007ooOol00Woo10009Wg00`0000=lh7c0O>000WcP00El`7cP
O>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000WcP0P00>G`00P0000El`7cPO>1l
h7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00Al`7cPO>1lh08002Im`0D000Ao
o`03001oogoo019oo`0037oo00<007ooOol017oo00<007ooOol00Woo17k02@00021m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP0P0001al
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh08003El
0080000KO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
00<0000PON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`0P000An`0Eoo`03001oogoo019oo`002Woo0`001Woo00<007ooOol00Woo3Gk01`00
6gg00`000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00=l
`0000000<G`00P000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<00
0gcP00=l`000000077g01`0037k01Goo00<007ooOol04Woo000<Ool00`00Oomoo`04Ool00`00Oomo
o`02OolDO/0400006WgPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m
`7gPOL0300006Wc0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>03000[O00300006WcPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<0300006Wg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON04000CO/05Ool00`00Oomoo`0BOol001=oo`03001oogoo009ooaQn`0@001Um`0<0009lh005O<1l
h7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh0<002El00<00003O>1l`7cP
009lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000<001Qm`0D001Mn
`0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo77k0100001Qmh7g0ON1m`7gPOL1mh7g0ON1m
`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL0300006Wc0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>03000NO00400006WcPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<0300005gg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL00100077k01Goo00<007ooOol04Woo000COol00`00Oomoo`02Ool2
000NO/04000GOL030002O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l
`003O>04000FO0040002O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l
`003O>0017c0000000005gg00`007Wk00`0017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool0
0go0Oj000003000NO/0400005WgPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1m
h7g00P0001alh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`0D000el00@0000MO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh00200005Wg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m
`7gP10007Gk0100000=o`7nPOol017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool2Ol0017nP
Ol1o`7o020006Wk01@004gg00`000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0
O>1lh7cPO<000gcP00=l`7cPO>003@0000El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0
O>1lh7cPO<000gcP00El`7cPO>1lh7c000@001=m`0D001Yn`0L0009o`004Oj1o`7o0Ol05Ool00`00
Oomoo`0BOol001=oo`03001oogoo009oo`0>Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX0H001Un
`080000DOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh0<00012O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c00`0001Am`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP0`006Gk01P0000eo
X7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX005Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`05
Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj000go000AoX7o0Ol1o`0@001Mn`0<001Am`0800005O<1l
h7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>00
1Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Wc0O>1lh7cPO<1l
h08001Em`08001Qn`0@00003Ol1oX7o0009o`005Oj1o`7o0Ol1oX003Ol001WnPOl1o`7o0Oj1o`0Eo
o`03001oogoo019oo`004goo00<007ooOol00Woo01Qo`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP
Ol1oX7o0Oj1o`7nPOl1oX7o0Oj04000FO/0300004gg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m
`7gPOL1mh7g00080000jO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<02000057gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL03000E
O/0500005gnPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj001Goo00<0
07ooOol04Woo000COol00`00Oomoo`02Ool40002Ol001GnPOl1o`7o0Oj000go000EoX7o0Ol1o`7nP
00=o`006Oj1o`7o0Ol1oX7o010005Gk00`004Wg00P000WcP00El`7cPO>1lh7c000=lh005O<1lh7cP
O>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0
O>1lh7cPO<000gcP00Al`7cPO>1lh08001=m`0<001An`0@00005Oj1o`7o0Ol1oX003Ol001GnPOl1o
`7o0Oj000go000EoX7o0Ol1o`7nP00=o`0D000Aoo`03001oogoo019oo`004goo00<007ooOol00Woo
00AWh6?PIn1Sh0T0000COj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj001@004gk0
0`00015m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g000@0000_O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh00300004WgPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m
`0<001=n`0@0000DOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX0P00004In1S
h6OPHn05Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`0=Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn001`0000EoX7o0Ol1o`7nP00=o`005Oj1o`7o0Ol1oX003Ol000gnP00000002000BO/04000A
OL0400001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1l
h7cPO<000gcP00El`7cPO>1lh7c0009lh0@0015m`0@0019n`0@0009o`005Oj1o`7o0Ol1oX003Ol00
1GnPOl1o`7o0Oj000Wo01`0000aSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn05Ool00`00Oomoo`0BOol0
01=oo`03001oogoo009oo`0DIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0@0
000AOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`004000BO/0400004Gg0ON1m`7gPOL1m
h7g0ON1m`7gPOL1mh7g0ON1m`7gPOL001P0001Ylh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c01`00015m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
00@0019n`0@0000AOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`00400004f?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00Eoo`03001oogoo019oo`004goo00<007ooOol0
0Woo01QSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn030003Ol00
1GnPOl1o`7o0Oj000go000EoX7o0Ol1o`7nP009o`0<001=n`0<001Am`1X001Em`0<001=n`0<00005
Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj000go000=oX7o000000P0001MWh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00Eoo`03001oogoo019oo`004goo00<007ooOol0
0Woo100001MWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00@0000A
Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX005000@O/020000@7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP0`0047k0
1@00015oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP00@0000FIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn050004Ool00`00Oomoo`0BOol001=oo`03001oogoo
009oo`A7h0T0000BIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P1P000go000EoX7o0
Ol1o`7nP00=o`005Oj1o`7o0Ol1oX003000?O/04000hOL04000@O/030002Ol001GnPOl1o`7o0Oj00
0go000IoX7o0Ol1o`7nPOl0600004V?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0P0
00A7h0Eoo`03001oogoo019oo`004goo00<007ooOol00Woo00=7h4?PAn000TOP00E3h4OPAn17h4?P
00=7h0L0000AIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh00400003gnPOl1oX7o0Oj1o
`7nPOl1oX7o0Oj1o`7nPOl1oX003000@O/050000;ggPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1m
h7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1m
h7g0ON0010004Gk00`0000moX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj001000015Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00L000=7h005@n17h4OPAn13h003An000d?POomoo`03
Ool00`00Oomoo`0BOol001=oo`03001oogoo009ooaA7h0@0000AHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh00400000go0Oj1o`002Ol001GnPOl1o`7o0Oj000go000=oX00000000P004Gk0
10009gg010004Gk010000Wo000EoX7o0Ol1o`7nP00=o`003Oj1o`7o000D0000AHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh004000CAn05Ool00`00Oomoo`0BOol001=oo`03001oogoo009o
o`@000=7h005@n17h4OPAn13h003An001D?PAn17h4OP@n000dOP00=3h00000000P00015Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00@0000>Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o
`0@0015n`0H0000JON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`0L0015n`0@0000=Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl001000015Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00D00005@n17h4OPAn13h003An001D?PAn17h4OP@n000dOP00=3
h4OPAn001@0017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool49n07000AAn0400004F?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn001@000Wo000EoX7o0Ol1o`7nP00=o`003Oj1o`7o0
00@001=n`1X001=n`0D00005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj001000015Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00@00197h0H000@Wh0Eoo`03001oogoo019oo`004goo00<0
07ooOol00Woo0ROP00D[h2OP9n0Wh2_P00<Wh003:n00000000800097h005@n17h4OPAn13h003An00
1D?PAn17h4OP@n000TOP1@00015Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00@0000=
Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl001000>7k0100000ioX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP
Ol1oX7o01000015Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00@000=7h005@n17h4OP
An13h003An001D?PAn17h4OP@n000TOP10000ROP00D[h2OP9n0Wh2_P00<Wh0Eoo`03001oogoo019o
o`004goo00<007ooOol00Woo3bOP1`003dOP1000015Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OP00@00005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj001P00;Gk01@000go000EoX7o0Ol1o
`7nP00=o`003Oj1o`7o000@0000AIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh004000?
An07000>9n05Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`D000<Wh005:n0Wh2OP9n0[h003
9n001R_P9n0Wh2OP:n0Wh0H000=7h005@n17h4OPAn13h003An000d?PAn00000500003f?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00400003go0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`009
000JO/0:00003Wo0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj0500003f?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh00600000dOP@n17h002An001D?PAn17h4OP@n000TOP1`000bOP00D[h2OP9n0W
h2_P00<Wh005:n0Wh2OP9n0[h0060004Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`051n0;
h0OP2n07h008000?9n04000?An03000046?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP1@00
00=o`7nPOl000Wo000EoX7o0Ol1o`7nP00=o`006Oj1o`7o0Ol1oX7o02@002Gk0200000EoX7o0Ol1o
`7nP00=o`005Oj1o`7o0Ol1oX003Ol000gnPOl1o`00500004F?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn000`003TOP100042OP1`0000D;h0OP2n07h0_P00Eoo`03001oogoo019oo`004goo
00<007ooOol00Woo00d;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h00700029n001B_P9n0Wh2OP:n00
0bOP00<[h2OP0000100000E3h4OPAn17h4?P00=7h005@n17h4OPAn13h00400004FOPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00100001QoX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o
`7nPOl1oX7o0Oj1o`7nPOl0900005go0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0
Oj1o`7nPOl001000019Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0400001D?PAn17
h4OP@n000dOP00E3h4OPAn17h4?P00@00005:n0Wh2OP9n0[h0039n001B_P9n0Wh2OP:n001`0000`;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n05Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`80000B
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P10003BOP10003DOP1000015Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00L00005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj00
0go000EoX7o0Ol1o`7nP00=o`005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj000go000=oX7o0Ol00
1P00019Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn04000=An04000=9n0400004@_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n000`0017oo00<007ooOol04Woo000COol00`00
Oomoo`02Ool20n@400004P_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0@00005:n0W
h2OP9n0[h0039n001B_P9n0Wh2OP:n0010000TOP00E3h4OPAn17h4?P00=7h003@n17h4OP00L0000A
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00800006Wo0Oj1o`7nPOl1oX7o0Oj1o`7nP
Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj0900004F?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn001`000TOP00E3h4OPAn17h4?P00=7h003@n17h00000@0008Wh005:n0Wh2OP9n0[
h0039n000b_P9n00000400004@OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0010000P?T
1Goo00<007ooOol04Woo000COol00`00Oomoo`02Ool60n@700003`_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h004000=9n04000@An0600004fOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OP00T00003Ol1oX7o0009o`004Oj1o`7o0Ol0800004f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?P00L000m7h0@000dWh0@0000@1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n0600060n@5Ool00`00Oomoo`0BOol000Uoo`D000Eoo`03001oogoo009oo`d3i0T0000:2n07
h0_P1n0;h0OP2n07h0_P1n0700039n001B_P9n0Wh2OP:n000ROP1`0000=7h4?PAn000TOP00E3h4OP
An17h4?P00=7h003@n17h00000<0000HHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OP2@0001MWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OP00@00097h005@n17h4OPAn13h003An001T?PAn17h4OP@n17h0H000039n0[h2OP008Wh006:n0W
h2OP9n0[h2OP1P0000/;h0OP2n07h0_P1n0;h0OP2n07h0_P00T000`3i0Eoo`03001oogoo019oo`00
2Goo00D007ooOomoo`0000Eoo`03001oogoo009oo`@00183i0H0000;1n0;h0OP2n07h0_P1n0;h0OP
2n07h006000;9n06000=An070000:f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00H000i7h0H000/W
h0H0000;1n0;h0OP2n07h0_P1n0;h0OP2n07h006000A0n@50004Ool00`00Oomoo`0BOol000Yoo`03
001oogoo00Ioo`03001oogoo009oo`040n`3j`?/0n/7000A0n@400003@_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P00@000<Wh005:n0Wh2OP9n0[h0039n000b_P9n00000300000dOP@n17h002An001D?P
An17h4OP@n000dOP00=3h4OPAn001`0001eSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00L00097h005@n17h4OPAn13h003An001T?PAn17h4OP@n17
h0@000<Wh005:n0Wh2OP9n0[h0039n000b_P9n00000300003P_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n03000@0n@7000010?/0n/3k0?[1Goo00<007ooOol04Woo000;Ool00`00Oomoo`05Ool20003
Ool;0n`9000<0n@5000030_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0D000`Wh0L00117h1d000m7h0P0
00`Wh0D0000<1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1P002`?T20002`?/17oo0P0057oo000<Ool0
0`00Oomoo`04Ool00`00Oomoo`02Ool4000040?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
10003@?T100000d7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00400001B_P9n0Wh2OP:n000bOP00D[
h2OP9n0Wh2_P008Wh0L00003An13h4OP0097h005@n17h4OPAn13h003An001D?PAn17h4OP@n000dOP
00E3h4OPAn17h4?P00=7h005@n17h4OPAn13h003An001D?PAn17h4OP@n000dOP00=3h4OP00001@00
00<Wh2_P9n000ROP00D[h2OP9n0Wh2_P00<Wh003:n0Wh2OP00@0000=1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0010003@?T100000l3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/01@0017oo00<0
07ooOol04Woo000=Ool00`00Oomoo`03Ool00`00Oomoo`02Ool010?c0o@3l`?c2@002`?/1P002`?T
1P0000/;h0OP2n07h0_P1n0;h0OP2n07h0_P00L000lWh0@002M7h0@000lWh0L0000:2n07h0_P1n0;
h0OP2n07h0_P1n07000:0n@7000;0n`800030o<00`?dOomoo`03Ool00`00Oomoo`0BOol000Uoo`05
001oogooOol00005Ool00`00Oomoo`02Ool03@?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00L0000:
0n`3j`?/0n/3k0?[0n`3j`?/0n/7000:0n@700002`_P1n0;h0OP2n07h0_P1n0;h0OP2n001P0000<W
h2_P9n000ROP00D[h2OP9n0Wh2_P00<Wh2L000039n0[h2OP008Wh005:n0Wh2OP9n0[h0029n070000
2`_P1n0;h0OP2n07h0_P1n0;h0OP2n001P002`?T1P0000/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00L0
000<0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c1Goo00<007ooOol04Woo000:Ool30006Ool00`00Oomo
o`02Ool400030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00@000d3k0@000d3i0@0000=1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n001000>2OP100000h;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP10003@?T10003@?/100000D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<50004Ool00`00
Oomoo`0BOol001=oo`03001oogoo009oo`83n`030o`3n`0000P0000;0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`0600002`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`01P002`?T1`0000X7h0_P1n0;h0OP2n07h0_P
1n0;h0L00005:n0Wh2OP9n0[h0039n001B_P9n0Wh2OP:n000bOP00D[h2OP9n0Wh2_P00<Wh005:n0W
h2OP9n0[h0039n001B_P9n0Wh2OP:n000bOP00<[h2OP9n001P0000/7h0_P1n0;h0OP2n07h0_P1n0;
h0OP00L000X3i0L0000:0n`3j`?/0n/3k0?[0n`3j`?/0n/700002`?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<0200000@3o0?k0o/3n`Eoo`03001oogoo019oo`004goo00<007ooOol00Woo3@?k1`0000<3l`?d
0o<00P?c00D3m0?c0o<3l`?d00L000X3k0L000/3i0H0000;2n07h0_P1n0;h0OP2n07h0_P1n0;h00[
00002P_P1n0;h0OP2n07h0_P1n0;h0OP1`002`?T1P002`?/1P0000<3l`?d0o<00P?c00H3m0?c0o<3
l`?d0o<7000<0o/5Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`@000050o`3n`?k0o/3o003
0o/01@?l0o/3n`?k0o`00`?k100000d3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m00400003@?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[00@000d3i0@0000h1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0@000h3i0@0000=0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/0100000d3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m00400000`?k0o`3n`020o/01@?l0o/3n`?k
0o`00`?k00<3o0?k0000100017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool40gl;00090o/8
00030o<01P?d0o<3l`?c0o@3l`P000T3k0P000T3i0X0000T2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2P002P?T20002@?/
200000<3l`?d0o<00P?c00@3m0?c0o<3l`P000T3n`X000@3O`Eoo`03001oogoo019oo`004goo00<0
07ooOol00Woo0P0000D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`0700001@?l0o/3n`?k0o`00`?k
00<3o0?k0000100000`3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@5000030?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`L000`3i2@000`3i0P0000<0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/1@0000`3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<500030o/01@?l0o/3n`?k0o`00P?k1`000P=o00D3W`=o0gl3O`>O00<3
O`030il3O`00008000Aoo`03001oogoo019oo`004goo00<007ooOol00Woo00<2O`:O00000`0040=o
1P002@?k100000D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m004000?0n`9000[0n@8000@0n`40000
1@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00@000P3n`L000l3O`@000030Wl2Wgoo00Aoo`03001o
ogoo019oo`004goo00<007ooOol00Woo00H2W`9o0Yl2O`:O0Wl700030gl01@>O0gl3O`=o0il00`=o
00@3W`=o0gl3O`@000050o`3n`?k0o/3o0030o/00`?l0000000400002`?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<01`000143j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00P001X3i0T0000A0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`0700002P?c0o@3l`?d0o<3m0?c0o@3l`?d1`00
0P?k00H3o0?k0o/3n`?l0o/400020gl01@>O0gl3O`=o0il00`=o00H3W`=o0gl3O`>O0gl600001P:O
0Wl2W`9o0Yl2O`Eoo`03001oogoo019oo`004goo00<007ooOol00Woo10000`9o00H2W`9o0Wl2O`:O
0Wl9000:0gl700080o/900030o<01P?d0o<3l`?c0o@3l`P00143k1X00143k0T000030o<3m0?c0083
l`040o@3l`?c0o<800090o/6000;0gl900000`9o0Yl2O`020Wl00`:O0Wl2O`050004Ool00`00Oomo
o`0BOol001=oo`03001oogoo009oo`040Il1O`6O0Gl900002@9o0Yl2O`:O0Wl2W`9o0Yl2O`080000
1@>O0gl3O`=o0il00`=o00<3W`000000100000<3n`?l0o/00P?k00H3o0?k0o/3n`?l0o/700002P?c
0o@3l`?d0o<3m0?c0o@3l`?d2@0002/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00800002`?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<01`000`?k00D3o0?k0o/3n`?l0083n`L00083O`060il3O`=o0gl3W`=o
2@0000T2O`:O0Wl2W`9o0Yl2O`:O0Wl0200000@1W`5o0Il1O`Eoo`03001oogoo019oo`004goo00<0
07ooOol00Woo0P002`6O1`0000<2O`:O0Wl00P9o00D2W`9o0Wl2O`:O00L000P3O`@000h3n`@00083
l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@04@002@?/4@0000D3m0?c0o<3l`?d00<3l`050o@3
l`?c0o<3m0020o<4000=0o/400090gl600000`9o0Yl2O`020Wl01P:O0Wl2O`9o0Yl2O`L000X1W`<0
00Aoo`03001oogoo019oo`004goo00<007ooOol00Woo0P2O100000h1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o100000d2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`0400030gl01@>O0gl3O`=o0il0
1`0000D3o0?k0o/3n`?l00<3n`030o`3n`?k00H0000J0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0T0000I0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@01`0000D3o0?k0o/3n`?l00<3n`030o`3n`?k00H000<3O`060il3
O`=o0gl3W`=o100000d2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`0400003@5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o00@00080W`Eoo`03001oogoo019oo`004goo00<007ooOol00Woo1P2O1`002`6O
1P0000<2O`:O0Wl00P9o00H2W`9o0Wl2O`:O0Wl600090gl800090o/A00000`?c0o@3l`020o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m00A00090o/900090gl600000`9o
0Yl2O`020Wl01@:O0Wl2O`9o0Yl01`002`6O1P001P2O1Goo00<007ooOol04Woo000COol00`00Oomo
o`02Ool5000809l90000206O0Gl1W`5o0Il1O`6O0Gl90000209o0Yl2O`:O0Wl2W`9o0Yl900020gl0
1P>O0gl3O`=o0il3O`T000030o/3o0?k0083n`050o`3n`?k0o/3o0030o/010?l0o/3n`?k6P000P?k
00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0020o/900001@>O0gl3O`=o0il00`=o00<3W`000000
1`0000P2W`9o0Yl2O`:O0Wl2W`9o200000P1W`5o0Il1O`6O0Gl1W`5o2P00202O1@0017oo00<007oo
Ool04Woo000COol00`00Oomoo`02Ool01@@O21l47`PO11l020002@2O20002@6O20000P9o00D2W`9o
0Wl2O`:O0082O`T000P3O`T002/3n`P000T3O`T00082O`060Yl2O`9o0Wl2W`9o2@00206O20002P2O
200000@47`PO11l87`Eoo`03001oogoo019oo`004goo00<007ooOol00Woo100000T87`@O21l47`PO
11l87`@O21l02@00202O1`0000X1O`6O0Gl1W`5o0Il1O`6O0Gl1W`L0000;0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`0800030gl01P>O0gl3O`=o0il3Ob/000<3O`050il3O`=o0gl3W`0900002`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl01P0000/1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00H000T0W`T0000821l47`PO
11l87`@O21l47`D000Aoo`03001oogoo019oo`004goo00<007ooOol00Woo12@O2@0000T87`@O21l4
7`PO11l87`@O21l01P002@2O10003@6O100000<2O`:O0Wl00P9o00D2W`9o0Wl2O`:O00<2O`030Yl2
O`0000P002/3O`P00082O`050Yl2O`9o0Wl2W`030Wl01P:O0Wl2O`9o0Yl2O`@000d1W`@000P0W`L0
000921l47`PO11l87`@O21l47`PO00P000@T7`Eoo`03001oogoo019oo`004goo00<007ooOol00Woo
10000R@O00DX7b@O91lT7bPO008T7`L0000821l47`PO11l87`@O21l47`@000T0W`H0000;0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`0700004@9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl04@00
0`=o00H3W`=o0gl3O`>O0glA00004@9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl01`00
00X1O`6O0Gl1W`5o0Il1O`6O0Gl1W`L000P0W`@0000921l47`PO11l87`@O21l47`PO00L00005:1lT
7b@O91lX7`0391l50004Ool00`00Oomoo`0BOol001=oo`03001oogoo009oo`A47`L000TT7`@00008
11l87`@O21l47`PO11l87`L000P0W`T000T1W`P000050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl0
0`9o00D2W`9o0Wl2O`:O00<2O`030Yl2O`0000P000030Wl2W`9o0082O`050Yl2O`9o0Wl2W`030Wl0
1@:O0Wl2O`9o0Yl00`9o00@2W`9o0Wl2O`T000T1W`P000T0W`H0000911l87`@O21l47`PO11l87`@O
00@000TT7`H000A47`Eoo`03001oogoo019oo`004goo00<007ooOol00Woo0d@O00E07d@OA1m47d0O
00=47`@0000391lX7b@O008T7`04:1lT7b@O91l600002@PO11l87`@O21l47`PO11l87`08000909l9
0000205o0Il1O`6O0Gl1W`5o0IlA00006P:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0WlA00002@5o0Il1O`6O0Gl1W`5o0Il1O`09000809l9000020PO11l87`@O
21l47`PO11l700000b@O:1lT7`0291l012PO91lT7b@O10000d@O00E07d@OA1m47d0O00947`Eoo`03
001oogoo019oo`004goo00<007ooOol00Woo10002d@O1`0022@O2@0000P87`@O21l47`PO11l87`@O
2@002@2O20004@6O6P004@6O2@002@2O200000T87`@O21l47`PO11l87`@O21l020002B@O1`002T@O
1@0017oo00<007ooOol04Woo000COol00`00Oomoo`02Ool016@OH1mT7f0O200000=47d0OA1l00T@O
00E07d@OA1m47d0O00L0000391lX7b@O008T7`05:1lT7b@O91lX7`0600002`@O21l47`PO11l87`@O
21l47`PO11l01P002`2O3`0001l1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0>000;09l700002P@O21l47`PO11l87`@O21l47`PO1`000R@O
00DX7b@O91lT7bPO008T7`P00005@1m47d@OA1m07`03A1l00d0O00000006000016@OH1mT7f0O1Goo
00<007ooOol04Woo000COol00`00Oomoo`02Ool40000260OI1mP7f@OH1mT7f0OI1l:0007A1l:0006
91l;00001P@O21l47`PO11l87`/000l0Wal000h0W`/0000711l87`@O21l47`PO11l02P001b@O2@00
24@O2@0000UP7f@OH1mT7f0OI1mP7f@OH1l0100017oo00<007ooOol04Woo000COol00`00Oomoo`02
Ool017`NO1el7W`M2@0000UP7f@OH1mT7f0OI1mP7f@OH1l0200000=47d0OA1l00T@O00A07d@OA1m4
7`P0000391lX7b@O008T7`04:1lT7b@O91l9000020@O21l47`PO11l87`@O21lA000J09lA00002@@O
21l47`PO11l87`@O21l47`0900000b@O:1lT7`0291l00bPO91lT7`090003A1l01D0OA1m47d@O@1l0
2@0000UP7f@OH1mT7f0OI1mP7f@OH1l02@0000=l7G`NO1d01Goo00<007ooOol04Woo000COol00`00
Oomoo`02Ool400001G`MO1il7W`NO1d00g`N00=l7@0000001`0000QP7f@OH1mT7f0OI1mP7f@O2@00
24@O2@002B@O200001487`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO01X0000A11l87`@O
21l47`PO11l87`@O21l47`PO11l87`@O21l47`09000991l80009A1l800002F0OI1mP7f@OH1mT7f0O
I1mP7`090002O1h01G`MO1il7W`NO1d00W`N100017oo00<007ooOol04Woo000COol00`00Oomoo`02
Ool4O1H900002G`MO1il7G`NO1el7W`MO1il7@0800002F@OH1mT7f0OI1mP7f@OH1mT7`080002A1l0
1D0OA1m47d@O@1l00T@O2@0000<T7bPO91l00R@O00<X7b@O91l04@0001X87`@O21l47`PO11l87`@O
21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O4@0000<T7bPO91l00R@O00@X7b@O91lT
7`T000947`06@1m47d@OA1m07d@O2@0000UT7f0OI1mP7f@OH1mT7f0OI1l0200000Ul7G`NO1el7W`M
O1il7G`NO1d02@000g`F1Goo00<007ooOol04Woo000COol00`00Oomoo`02Ool40009O1H900001G`M
O1il7W`NO1d00g`N2@0000QT7f0OI1mP7f@OH1mT7f0O2@002D@O20004B@O6P004B@O2@002D@O2000
00UT7f0OI1mP7f@OH1mT7f0OI1l02@0000=l7W`MO1h00W`N00=l7G`NO1h02@002G`F100017oo00<0
07ooOol04Woo000:Ool30006Ool00`00Oomoo`02Ool017`?O0il3g`>2@002G`F200000Ul7W`MO1il
7G`NO1el7W`MO1h0200000UP7f@OH1mT7f0OI1mP7f@OH1l02@000T@O00I07d@OA1m47d0OA1lA0002
91l01BPO91lT7b@O:1l00b@O00DX7b@O91lT7bPO00<T7`05:1lT7b@O91lX7`0391lA0002A1l01D0O
A1m47d@O@1l00T@O2@0000UP7f@OH1mT7f0OI1mP7f@OH1l0200000Ul7W`MO1il7G`NO1el7W`MO1h0
20002G`F2@0000=l3W`?O0h01Goo00<007ooOol04Woo0009Ool01@00Oomoogoo00001Goo00<007oo
Ool00Woo10002G`>2@0027`F2@0000=l7W`MO1h00W`N00=l7G`NO1h02@0000UP7f@OH1mT7f0OI1mP
7f@OH1l020004D@O6P004D@O2@0000UP7f@OH1mT7f0OI1mP7f@OH1l02@0000El7G`NO1il7W`M00=l
7PT000Ql5PT000Ul3P@000Aoo`03001oogoo019oo`003Goo00<007ooOol00goo00<007ooOol00Woo
0`0000=l1P0000001`0000Ul3W`?O0il3g`>O0ml3W`?O0h020002G`F200000Ul7G`NO1el7W`MO1il
7G`NO1d02@0000QP7f@OH1mT7f0OI1mP7f@O4@000d@O00E07d@OA1m47d0O00=47`05@1m47d@OA1m0
7`03A1l01D0OA1m47d@O@1l00T@O4@0000UP7f@OH1mT7f0OI1mP7f@OH1l02@0000Ul7G`NO1el7W`M
O1il7G`NO1d020002G`F200000Ul3W`?O0il3g`>O0ml3W`?O0h02@0000Al1P00000000Aoo`03001o
ogoo019oo`003Goo00<007ooOol00goo0P000goo0g`010000g`700=l1W`7O0L02@0027`>20002G`F
1`0000El7G`NO1il7W`M00=l7P03O1el7W`N00P0000AI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7`0J00004V0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`P00005O1el7W`N
O1il7@03O1h00g`MO1il7P070009O1H80008O0h900001W`6O0Ml1g`7O0Il1`@0009l00Aoo`8001Ao
o`002goo0P001Woo00<007ooOol0JGoo00<007ooOol0JGoo00<007ooOol04Woo000=Ool00`00Oomo
o`03Ool00`00Oomoo`1YOol00`00Oomoo`1YOol00`00Oomoo`0BOol000Uoo`05001oogooOol00005
Ool00`00Oomoo`1YOol00`00Oomoo`1YOol00`00Oomoo`0BOol000Yoo`<000Ioo`03001oogoo009o
o`03001oogoo01moo`03001oogoo021oo`03001oogoo01moo`03001oogoo01moo`03001oogoo021o
o`03001oogoo01moo`03001oogoo009oo`03001oogoo019oo`004goof@0057oo003oOol1Ool00?mo
o`5oo`00ogoo0Goo003oOol1Ool00?moo`5oo`00ogoo0Goo003oOol1Ool00?moo`5oo`00ogoo0Goo
001mOol30020Ool007moo`03001oogoo07ioo`00Ogoo00<007ooOol0OWoo001nOol00`00Ool0001o
Ool007ioo`03001oo`0007moo`00OGoo00D007ooOomoo`0007ioo`00OGoo00D007ooOomoo`0007io
o`00O7oo0`0000Aoo`00000007eoo`00ogoo0Goo003oOol1Ool00?moo`5oo`00ogoo0Goo003oOol1
Ool00?moo`5oo`00ogoo0Goo0000\
\>"],
  ImageRangeCache->{{{0, 255.25}, {255.063, 0}} -> {-3.70345, -3.55551, \
0.0363028, 0.0363028}}]
}, Open  ]],

Cell["\<\
The black disk in the center of the picture represents the sphere. \
The different shadings outline the different strengths of the stream function \
around the disk.\
\>", "Text"],

Cell["\<\
The velocity components follow immediately by using the definitions\
\
\>", "Text"],

Cell[BoxData[
    \(ur[r_, \[Theta]_, a_, U_] := 
      \[PartialD]\_\[Theta] \[CapitalPsi][r, \[Theta], a, U]\/\(r\^2\ 
          Sin[\[Theta]]\)\)], "Input"],

Cell[BoxData[
    \(uth[r_, \[Theta]_, a_, U_] := 
      \(-\(\[PartialD]\_r \[CapitalPsi][r, \[Theta], a, U]\/\(r\ 
              Sin[\[Theta]]\)\)\)\)], "Input"],

Cell["\<\
A representation of the radial component of the velocity in \
Cartesian coordinates follow by\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(u1 = ur[r, \[Theta], 1, 1] /. coordTrafo\)], "Input"],

Cell[BoxData[
    \(\(\((1\/\@\(x\^2 + y\^2\) - 3\ \@\(x\^2 + y\^2\) + 2\ \((x\^2 + y\^2)\))
          \)\ Cos[ArcTan[x, y]]\)\/\(2\ \((x\^2 + y\^2)\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The graphical representation in a contour plot shows the orthogonal \
orientation of the velocity field ",
  Cell[BoxData[
      \(TraditionalForm\`u\_r\)]],
  " to the stream function:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[{
        ContourPlot[
          If[x == 0 && y == 0, 0, u1], {x, \(-3\), 3}, {y, \(-3\), 3}, 
          PlotPoints \[Rule] 25, ColorFunction \[Rule] Hue, 
          AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True, 
          Contours \[Rule] 25, DisplayFunction \[Rule] Identity], 
        Graphics[Disk[{0, 0}, 1.1]]}, AspectRatio \[Rule] Automatic, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.18254 -0.0125 -6 -9 ]
[.18254 -0.0125 6 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -12 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .18254 -12 -4.5 ]
[-0.0125 .18254 0 4.5 ]
[-0.0125 .34127 -12 -4.5 ]
[-0.0125 .34127 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .65873 -6 -4.5 ]
[-0.0125 .65873 0 4.5 ]
[-0.0125 .81746 -6 -4.5 ]
[-0.0125 .81746 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 .5 0 -7.5 ]
[1.025 .5 10 7.5 ]
[.5 1.025 -5 0 ]
[.5 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(-3)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(-2)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(-1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(1)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(-3)] -0.0125 .02381 1 0 Mshowa
0 .18254 m
.00625 .18254 L
s
[(-2)] -0.0125 .18254 1 0 Mshowa
0 .34127 m
.00625 .34127 L
s
[(-1)] -0.0125 .34127 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .65873 m
.00625 .65873 L
s
[(1)] -0.0125 .65873 1 0 Mshowa
0 .81746 m
.00625 .81746 L
s
[(2)] -0.0125 .81746 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(3)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .05556 m
.00375 .05556 L
s
0 .0873 m
.00375 .0873 L
s
0 .11905 m
.00375 .11905 L
s
0 .15079 m
.00375 .15079 L
s
0 .21429 m
.00375 .21429 L
s
0 .24603 m
.00375 .24603 L
s
0 .27778 m
.00375 .27778 L
s
0 .30952 m
.00375 .30952 L
s
0 .37302 m
.00375 .37302 L
s
0 .40476 m
.00375 .40476 L
s
0 .43651 m
.00375 .43651 L
s
0 .46825 m
.00375 .46825 L
s
0 .53175 m
.00375 .53175 L
s
0 .56349 m
.00375 .56349 L
s
0 .59524 m
.00375 .59524 L
s
0 .62698 m
.00375 .62698 L
s
0 .69048 m
.00375 .69048 L
s
0 .72222 m
.00375 .72222 L
s
0 .75397 m
.00375 .75397 L
s
0 .78571 m
.00375 .78571 L
s
0 .84921 m
.00375 .84921 L
s
0 .88095 m
.00375 .88095 L
s
0 .9127 m
.00375 .9127 L
s
0 .94444 m
.00375 .94444 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.18254 .99375 m
.18254 1 L
s
.34127 .99375 m
.34127 1 L
s
.5 .99375 m
.5 1 L
s
.65873 .99375 m
.65873 1 L
s
.81746 .99375 m
.81746 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.05556 .99625 m
.05556 1 L
s
.0873 .99625 m
.0873 1 L
s
.11905 .99625 m
.11905 1 L
s
.15079 .99625 m
.15079 1 L
s
.21429 .99625 m
.21429 1 L
s
.24603 .99625 m
.24603 1 L
s
.27778 .99625 m
.27778 1 L
s
.30952 .99625 m
.30952 1 L
s
.37302 .99625 m
.37302 1 L
s
.40476 .99625 m
.40476 1 L
s
.43651 .99625 m
.43651 1 L
s
.46825 .99625 m
.46825 1 L
s
.53175 .99625 m
.53175 1 L
s
.56349 .99625 m
.56349 1 L
s
.59524 .99625 m
.59524 1 L
s
.62698 .99625 m
.62698 1 L
s
.69048 .99625 m
.69048 1 L
s
.72222 .99625 m
.72222 1 L
s
.75397 .99625 m
.75397 1 L
s
.78571 .99625 m
.78571 1 L
s
.84921 .99625 m
.84921 1 L
s
.88095 .99625 m
.88095 1 L
s
.9127 .99625 m
.9127 1 L
s
.94444 .99625 m
.94444 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .18254 m
1 .18254 L
s
.99375 .34127 m
1 .34127 L
s
.99375 .5 m
1 .5 L
s
.99375 .65873 m
1 .65873 L
s
.99375 .81746 m
1 .81746 L
s
.99375 .97619 m
1 .97619 L
s
.125 Mabswid
.99625 .05556 m
1 .05556 L
s
.99625 .0873 m
1 .0873 L
s
.99625 .11905 m
1 .11905 L
s
.99625 .15079 m
1 .15079 L
s
.99625 .21429 m
1 .21429 L
s
.99625 .24603 m
1 .24603 L
s
.99625 .27778 m
1 .27778 L
s
.99625 .30952 m
1 .30952 L
s
.99625 .37302 m
1 .37302 L
s
.99625 .40476 m
1 .40476 L
s
.99625 .43651 m
1 .43651 L
s
.99625 .46825 m
1 .46825 L
s
.99625 .53175 m
1 .53175 L
s
.99625 .56349 m
1 .56349 L
s
.99625 .59524 m
1 .59524 L
s
.99625 .62698 m
1 .62698 L
s
.99625 .69048 m
1 .69048 L
s
.99625 .72222 m
1 .72222 L
s
.99625 .75397 m
1 .75397 L
s
.99625 .78571 m
1 .78571 L
s
.99625 .84921 m
1 .84921 L
s
.99625 .88095 m
1 .88095 L
s
.99625 .9127 m
1 .9127 L
s
.99625 .94444 m
1 .94444 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.5 0 m
.5 1 L
s
gsave
.5 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.08 1 0 r
.02381 .97619 m
.97619 .97619 L
.97619 .02381 L
.02381 .02381 L
F
0 1 .16 r
.04024 .97619 m
.0519 .93651 L
.06223 .89683 L
.06349 .89159 L
.07105 .85714 L
.07817 .81746 L
.08352 .77778 L
.08712 .7381 L
.08916 .69841 L
.08996 .65873 L
.08994 .61905 L
.08955 .57937 L
.08915 .53968 L
.08899 .5 L
.08915 .46032 L
.08955 .42063 L
.08994 .38095 L
.08996 .34127 L
.08916 .30159 L
.08712 .2619 L
.08352 .22222 L
.07817 .18254 L
.07105 .14286 L
.06349 .10841 L
.06223 .10317 L
.0519 .06349 L
.04024 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.5 Mabswid
.04024 .97619 m
.0519 .93651 L
.06223 .89683 L
.06349 .89159 L
.07105 .85714 L
.07817 .81746 L
.08352 .77778 L
.08712 .7381 L
.08916 .69841 L
.08996 .65873 L
.08994 .61905 L
.08955 .57937 L
.08915 .53968 L
.08899 .5 L
.08915 .46032 L
.08955 .42063 L
.08994 .38095 L
.08996 .34127 L
.08916 .30159 L
.08712 .2619 L
.08352 .22222 L
.07817 .18254 L
.07105 .14286 L
.06349 .10841 L
.06223 .10317 L
.0519 .06349 L
.04024 .02381 L
s
0 1 .4 r
.17462 .97619 m
.18154 .93651 L
.18254 .93019 L
.187 .89683 L
.19072 .85714 L
.19242 .81746 L
.19198 .77778 L
.18951 .7381 L
.18548 .69841 L
.18254 .67356 L
.18062 .65873 L
.1758 .61905 L
.17178 .57937 L
.16914 .53968 L
.16822 .5 L
.16914 .46032 L
.17178 .42063 L
.1758 .38095 L
.18062 .34127 L
.18254 .32644 L
.18548 .30159 L
.18951 .2619 L
.19198 .22222 L
.19242 .18254 L
.19072 .14286 L
.187 .10317 L
.18254 .06981 L
.18154 .06349 L
.17462 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.17462 .97619 m
.18154 .93651 L
.18254 .93019 L
.187 .89683 L
.19072 .85714 L
.19242 .81746 L
.19198 .77778 L
.18951 .7381 L
.18548 .69841 L
.18254 .67356 L
.18062 .65873 L
.1758 .61905 L
.17178 .57937 L
.16914 .53968 L
.16822 .5 L
.16914 .46032 L
.17178 .42063 L
.1758 .38095 L
.18062 .34127 L
.18254 .32644 L
.18548 .30159 L
.18951 .2619 L
.19198 .22222 L
.19242 .18254 L
.19072 .14286 L
.187 .10317 L
.18254 .06981 L
.18154 .06349 L
.17462 .02381 L
s
0 1 .64 r
.28987 .97619 m
.29314 .93651 L
.29486 .89683 L
.29454 .85714 L
.29159 .81746 L
.28554 .77778 L
.27644 .7381 L
.26521 .69841 L
.2619 .68714 L
.25345 .65873 L
.24282 .61905 L
.23456 .57937 L
.22939 .53968 L
.22763 .5 L
.22939 .46032 L
.23456 .42063 L
.24282 .38095 L
.25345 .34127 L
.2619 .31286 L
.26521 .30159 L
.27644 .2619 L
.28554 .22222 L
.29159 .18254 L
.29454 .14286 L
.29486 .10317 L
.29314 .06349 L
.28987 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.28987 .97619 m
.29314 .93651 L
.29486 .89683 L
.29454 .85714 L
.29159 .81746 L
.28554 .77778 L
.27644 .7381 L
.26521 .69841 L
.2619 .68714 L
.25345 .65873 L
.24282 .61905 L
.23456 .57937 L
.22939 .53968 L
.22763 .5 L
.22939 .46032 L
.23456 .42063 L
.24282 .38095 L
.25345 .34127 L
.2619 .31286 L
.26521 .30159 L
.27644 .2619 L
.28554 .22222 L
.29159 .18254 L
.29454 .14286 L
.29486 .10317 L
.29314 .06349 L
.28987 .02381 L
s
0 1 .88 r
.39642 .97619 m
.39741 .93651 L
.39722 .89683 L
.3952 .85714 L
.39025 .81746 L
.38095 .77842 L
.3807 .77778 L
.36482 .7381 L
.34354 .69841 L
.34127 .69424 L
.32096 .65873 L
.30213 .61905 L
.30159 .61763 L
.28788 .57937 L
.27877 .53968 L
.27543 .5 L
.27877 .46032 L
.28788 .42063 L
.30159 .38237 L
.30213 .38095 L
.32096 .34127 L
.34127 .30576 L
.34354 .30159 L
.36482 .2619 L
.3807 .22222 L
.38095 .22158 L
.39025 .18254 L
.3952 .14286 L
.39722 .10317 L
.39741 .06349 L
.39642 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.39642 .97619 m
.39741 .93651 L
.39722 .89683 L
.3952 .85714 L
.39025 .81746 L
.38095 .77842 L
.3807 .77778 L
.36482 .7381 L
.34354 .69841 L
.34127 .69424 L
.32096 .65873 L
.30213 .61905 L
.30159 .61763 L
.28788 .57937 L
.27877 .53968 L
.27543 .5 L
.27877 .46032 L
.28788 .42063 L
.30159 .38237 L
.30213 .38095 L
.32096 .34127 L
.34127 .30576 L
.34354 .30159 L
.36482 .2619 L
.3807 .22222 L
.38095 .22158 L
.39025 .18254 L
.3952 .14286 L
.39722 .10317 L
.39741 .06349 L
.39642 .02381 L
s
0 1 .64 r
.42063 .41039 m
.46032 .41004 L
.49329 .42063 L
.4994 .46032 L
.49987 .5 L
.4994 .53968 L
.49329 .57937 L
.46032 .58996 L
.42063 .58961 L
.40492 .57937 L
.383 .53968 L
.38095 .53831 L
.37673 .5 L
.38095 .46169 L
.383 .46032 L
.40492 .42063 L
F
0 g
.42063 .41039 m
.46032 .41004 L
.49329 .42063 L
.4994 .46032 L
.49987 .5 L
.4994 .53968 L
.49329 .57937 L
.46032 .58996 L
.42063 .58961 L
.40492 .57937 L
.383 .53968 L
.38095 .53831 L
.37673 .5 L
.38095 .46169 L
.383 .46032 L
.40492 .42063 L
.42063 .41039 L
s
0 1 .4 r
.46032 .41376 m
.48631 .42063 L
.4988 .46032 L
.49975 .5 L
.4988 .53968 L
.48631 .57937 L
.46032 .58624 L
.4223 .57937 L
.42063 .57824 L
.39676 .53968 L
.4108 .5 L
.39676 .46032 L
.42063 .42176 L
.4223 .42063 L
F
0 g
.46032 .41376 m
.48631 .42063 L
.4988 .46032 L
.49975 .5 L
.4988 .53968 L
.48631 .57937 L
.46032 .58624 L
.4223 .57937 L
.42063 .57824 L
.39676 .53968 L
.4108 .5 L
.39676 .46032 L
.42063 .42176 L
.4223 .42063 L
.46032 .41376 L
s
0 1 .16 r
.46032 .41667 m
.47869 .42063 L
.4982 .46032 L
.49962 .5 L
.4982 .53968 L
.47869 .57937 L
.46032 .58333 L
.43284 .57937 L
.42063 .5717 L
.40259 .53968 L
.4117 .5 L
.40259 .46032 L
.42063 .4283 L
.43284 .42063 L
F
0 g
.46032 .41667 m
.47869 .42063 L
.4982 .46032 L
.49962 .5 L
.4982 .53968 L
.47869 .57937 L
.46032 .58333 L
.43284 .57937 L
.42063 .5717 L
.40259 .53968 L
.4117 .5 L
.40259 .46032 L
.42063 .4283 L
.43284 .42063 L
.46032 .41667 L
s
.08 1 0 r
.46032 .41912 m
.46951 .42063 L
.4976 .46032 L
.4995 .5 L
.4976 .53968 L
.46951 .57937 L
.46032 .58088 L
.44486 .57937 L
.42063 .56589 L
.40678 .53968 L
.41254 .5 L
.40678 .46032 L
.42063 .43411 L
.44486 .42063 L
F
0 g
.46032 .41912 m
.46951 .42063 L
.4976 .46032 L
.4995 .5 L
.4976 .53968 L
.46951 .57937 L
.46032 .58088 L
.44486 .57937 L
.42063 .56589 L
.40678 .53968 L
.41254 .5 L
.40678 .46032 L
.42063 .43411 L
.44486 .42063 L
.46032 .41912 L
s
.32 1 0 r
.42063 .43946 m
.46032 .42199 L
.497 .46032 L
.49937 .5 L
.497 .53968 L
.46032 .57801 L
.42063 .56054 L
.41016 .53968 L
.41332 .5 L
.41016 .46032 L
F
0 g
.42063 .43946 m
.46032 .42199 L
.497 .46032 L
.49937 .5 L
.497 .53968 L
.46032 .57801 L
.42063 .56054 L
.41016 .53968 L
.41332 .5 L
.41016 .46032 L
.42063 .43946 L
s
.56 1 0 r
.42063 .44451 m
.46032 .42535 L
.49639 .46032 L
.49925 .5 L
.49639 .53968 L
.46032 .57465 L
.42063 .55549 L
.41303 .53968 L
.41405 .5 L
.41303 .46032 L
F
0 g
.42063 .44451 m
.46032 .42535 L
.49639 .46032 L
.49925 .5 L
.49639 .53968 L
.46032 .57465 L
.42063 .55549 L
.41303 .53968 L
.41405 .5 L
.41303 .46032 L
.42063 .44451 L
s
.8 1 0 r
.42063 .44934 m
.46032 .42787 L
.49579 .46032 L
.49912 .5 L
.49579 .53968 L
.46032 .57213 L
.42063 .55066 L
.41556 .53968 L
.41474 .5 L
.41556 .46032 L
F
0 g
.42063 .44934 m
.46032 .42787 L
.49579 .46032 L
.49912 .5 L
.49579 .53968 L
.46032 .57213 L
.42063 .55066 L
.41556 .53968 L
.41474 .5 L
.41556 .46032 L
.42063 .44934 L
s
1 .96 0 r
.42063 .45402 m
.46032 .42994 L
.49518 .46032 L
.499 .5 L
.49518 .53968 L
.46032 .57006 L
.42063 .54598 L
.41782 .53968 L
.4154 .5 L
.41782 .46032 L
F
0 g
.42063 .45402 m
.46032 .42994 L
.49518 .46032 L
.499 .5 L
.49518 .53968 L
.46032 .57006 L
.42063 .54598 L
.41782 .53968 L
.4154 .5 L
.41782 .46032 L
.42063 .45402 L
s
1 .72 0 r
.42063 .45859 m
.46032 .43171 L
.49458 .46032 L
.49887 .5 L
.49458 .53968 L
.46032 .56829 L
.42063 .54141 L
.41989 .53968 L
.41603 .5 L
.41989 .46032 L
F
0 g
.42063 .45859 m
.46032 .43171 L
.49458 .46032 L
.49887 .5 L
.49458 .53968 L
.46032 .56829 L
.42063 .54141 L
.41989 .53968 L
.41603 .5 L
.41989 .46032 L
.42063 .45859 L
s
1 .48 0 r
.46032 .43328 m
.49397 .46032 L
.49875 .5 L
.49397 .53968 L
.46032 .56672 L
.42117 .53968 L
.42063 .53744 L
.41663 .5 L
.42063 .46256 L
.42117 .46032 L
F
0 g
.46032 .43328 m
.49397 .46032 L
.49875 .5 L
.49397 .53968 L
.46032 .56672 L
.42117 .53968 L
.42063 .53744 L
.41663 .5 L
.42063 .46256 L
.42117 .46032 L
.46032 .43328 L
s
1 .24 0 r
.46032 .43469 m
.49336 .46032 L
.49862 .5 L
.49336 .53968 L
.46032 .56531 L
.42202 .53968 L
.42063 .53381 L
.41721 .5 L
.42063 .46619 L
.42202 .46032 L
F
0 g
.46032 .43469 m
.49336 .46032 L
.49862 .5 L
.49336 .53968 L
.46032 .56531 L
.42202 .53968 L
.42063 .53381 L
.41721 .5 L
.42063 .46619 L
.42202 .46032 L
.46032 .43469 L
s
1 0 0 r
.46032 .43599 m
.49274 .46032 L
.4985 .5 L
.49274 .53968 L
.46032 .56401 L
.42286 .53968 L
.42063 .53012 L
.41776 .5 L
.42063 .46988 L
.42286 .46032 L
F
0 g
.46032 .43599 m
.49274 .46032 L
.4985 .5 L
.49274 .53968 L
.46032 .56401 L
.42286 .53968 L
.42063 .53012 L
.41776 .5 L
.42063 .46988 L
.42286 .46032 L
.46032 .43599 L
s
0 .88 1 r
.5 .97619 m
.5 .93651 L
.5 .89683 L
.5 .85714 L
.5 .81746 L
.5 .77778 L
.5 .7381 L
.5 .69841 L
.5 .65873 L
.5 .61905 L
.5 .57937 L
.5 .5776 L
.5 .53968 L
.5 .50591 L
.5 .5 L
.5 .49409 L
.5 .46032 L
.5 .4224 L
.5 .42063 L
.5 .38095 L
.5 .34127 L
.5 .30159 L
.5 .2619 L
.5 .22222 L
.5 .18254 L
.5 .14286 L
.5 .10317 L
.5 .06349 L
.5 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.5 .97619 m
.5 .93651 L
.5 .89683 L
.5 .85714 L
.5 .81746 L
.5 .77778 L
.5 .7381 L
.5 .69841 L
.5 .65873 L
.5 .61905 L
.5 .57937 L
.5 .5776 L
.5 .53968 L
.5 .50591 L
.5 .5 L
.5 .49409 L
.5 .46032 L
.5 .4224 L
.5 .42063 L
.5 .38095 L
.5 .34127 L
.5 .30159 L
.5 .2619 L
.5 .22222 L
.5 .18254 L
.5 .14286 L
.5 .10317 L
.5 .06349 L
.5 .02381 L
s
0 .64 1 r
.53968 .41004 m
.57937 .41039 L
.59508 .42063 L
.617 .46032 L
.61905 .46169 L
.62327 .5 L
.61905 .53831 L
.617 .53968 L
.59508 .57937 L
.57937 .58961 L
.53968 .58996 L
.50671 .57937 L
.5006 .53968 L
.50013 .5 L
.5006 .46032 L
.50671 .42063 L
F
0 g
.53968 .41004 m
.57937 .41039 L
.59508 .42063 L
.617 .46032 L
.61905 .46169 L
.62327 .5 L
.61905 .53831 L
.617 .53968 L
.59508 .57937 L
.57937 .58961 L
.53968 .58996 L
.50671 .57937 L
.5006 .53968 L
.50013 .5 L
.5006 .46032 L
.50671 .42063 L
.53968 .41004 L
s
0 .4 1 r
.53968 .41376 m
.5777 .42063 L
.57937 .42176 L
.60324 .46032 L
.5892 .5 L
.60324 .53968 L
.57937 .57824 L
.5777 .57937 L
.53968 .58624 L
.51369 .57937 L
.5012 .53968 L
.50025 .5 L
.5012 .46032 L
.51369 .42063 L
F
0 g
.53968 .41376 m
.5777 .42063 L
.57937 .42176 L
.60324 .46032 L
.5892 .5 L
.60324 .53968 L
.57937 .57824 L
.5777 .57937 L
.53968 .58624 L
.51369 .57937 L
.5012 .53968 L
.50025 .5 L
.5012 .46032 L
.51369 .42063 L
.53968 .41376 L
s
0 .16 1 r
.53968 .41667 m
.56716 .42063 L
.57937 .4283 L
.59741 .46032 L
.5883 .5 L
.59741 .53968 L
.57937 .5717 L
.56716 .57937 L
.53968 .58333 L
.52131 .57937 L
.5018 .53968 L
.50038 .5 L
.5018 .46032 L
.52131 .42063 L
F
0 g
.53968 .41667 m
.56716 .42063 L
.57937 .4283 L
.59741 .46032 L
.5883 .5 L
.59741 .53968 L
.57937 .5717 L
.56716 .57937 L
.53968 .58333 L
.52131 .57937 L
.5018 .53968 L
.50038 .5 L
.5018 .46032 L
.52131 .42063 L
.53968 .41667 L
s
.08 0 1 r
.53968 .41912 m
.55514 .42063 L
.57937 .43411 L
.59322 .46032 L
.58746 .5 L
.59322 .53968 L
.57937 .56589 L
.55514 .57937 L
.53968 .58088 L
.53049 .57937 L
.5024 .53968 L
.5005 .5 L
.5024 .46032 L
.53049 .42063 L
F
0 g
.53968 .41912 m
.55514 .42063 L
.57937 .43411 L
.59322 .46032 L
.58746 .5 L
.59322 .53968 L
.57937 .56589 L
.55514 .57937 L
.53968 .58088 L
.53049 .57937 L
.5024 .53968 L
.5005 .5 L
.5024 .46032 L
.53049 .42063 L
.53968 .41912 L
s
.32 0 1 r
.53968 .42199 m
.57937 .43946 L
.58984 .46032 L
.58668 .5 L
.58984 .53968 L
.57937 .56054 L
.53968 .57801 L
.503 .53968 L
.50063 .5 L
.503 .46032 L
F
0 g
.53968 .42199 m
.57937 .43946 L
.58984 .46032 L
.58668 .5 L
.58984 .53968 L
.57937 .56054 L
.53968 .57801 L
.503 .53968 L
.50063 .5 L
.503 .46032 L
.53968 .42199 L
s
.56 0 1 r
.53968 .42535 m
.57937 .44451 L
.58697 .46032 L
.58595 .5 L
.58697 .53968 L
.57937 .55549 L
.53968 .57465 L
.50361 .53968 L
.50075 .5 L
.50361 .46032 L
F
0 g
.53968 .42535 m
.57937 .44451 L
.58697 .46032 L
.58595 .5 L
.58697 .53968 L
.57937 .55549 L
.53968 .57465 L
.50361 .53968 L
.50075 .5 L
.50361 .46032 L
.53968 .42535 L
s
.8 0 1 r
.53968 .42787 m
.57937 .44934 L
.58444 .46032 L
.58526 .5 L
.58444 .53968 L
.57937 .55066 L
.53968 .57213 L
.50421 .53968 L
.50088 .5 L
.50421 .46032 L
F
0 g
.53968 .42787 m
.57937 .44934 L
.58444 .46032 L
.58526 .5 L
.58444 .53968 L
.57937 .55066 L
.53968 .57213 L
.50421 .53968 L
.50088 .5 L
.50421 .46032 L
.53968 .42787 L
s
1 0 .96 r
.53968 .42994 m
.57937 .45402 L
.58218 .46032 L
.5846 .5 L
.58218 .53968 L
.57937 .54598 L
.53968 .57006 L
.50482 .53968 L
.501 .5 L
.50482 .46032 L
F
0 g
.53968 .42994 m
.57937 .45402 L
.58218 .46032 L
.5846 .5 L
.58218 .53968 L
.57937 .54598 L
.53968 .57006 L
.50482 .53968 L
.501 .5 L
.50482 .46032 L
.53968 .42994 L
s
1 0 .72 r
.53968 .43171 m
.57937 .45859 L
.58011 .46032 L
.58397 .5 L
.58011 .53968 L
.57937 .54141 L
.53968 .56829 L
.50542 .53968 L
.50113 .5 L
.50542 .46032 L
F
0 g
.53968 .43171 m
.57937 .45859 L
.58011 .46032 L
.58397 .5 L
.58011 .53968 L
.57937 .54141 L
.53968 .56829 L
.50542 .53968 L
.50113 .5 L
.50542 .46032 L
.53968 .43171 L
s
1 0 .48 r
.53968 .43328 m
.57883 .46032 L
.57937 .46256 L
.58337 .5 L
.57937 .53744 L
.57883 .53968 L
.53968 .56672 L
.50603 .53968 L
.50125 .5 L
.50603 .46032 L
F
0 g
.53968 .43328 m
.57883 .46032 L
.57937 .46256 L
.58337 .5 L
.57937 .53744 L
.57883 .53968 L
.53968 .56672 L
.50603 .53968 L
.50125 .5 L
.50603 .46032 L
.53968 .43328 L
s
1 0 .24 r
.53968 .43469 m
.57798 .46032 L
.57937 .46619 L
.58279 .5 L
.57937 .53381 L
.57798 .53968 L
.53968 .56531 L
.50664 .53968 L
.50138 .5 L
.50664 .46032 L
F
0 g
.53968 .43469 m
.57798 .46032 L
.57937 .46619 L
.58279 .5 L
.57937 .53381 L
.57798 .53968 L
.53968 .56531 L
.50664 .53968 L
.50138 .5 L
.50664 .46032 L
.53968 .43469 L
s
1 0 0 r
.53968 .43599 m
.57714 .46032 L
.57937 .46988 L
.58224 .5 L
.57937 .53012 L
.57714 .53968 L
.53968 .56401 L
.50726 .53968 L
.5015 .5 L
.50726 .46032 L
F
0 g
.53968 .43599 m
.57714 .46032 L
.57937 .46988 L
.58224 .5 L
.57937 .53012 L
.57714 .53968 L
.53968 .56401 L
.50726 .53968 L
.5015 .5 L
.50726 .46032 L
.53968 .43599 L
s
0 .64 1 r
.60358 .97619 m
.60259 .93651 L
.60278 .89683 L
.6048 .85714 L
.60975 .81746 L
.61905 .77842 L
.6193 .77778 L
.63518 .7381 L
.65646 .69841 L
.65873 .69424 L
.67904 .65873 L
.69787 .61905 L
.69841 .61763 L
.71212 .57937 L
.72123 .53968 L
.72457 .5 L
.72123 .46032 L
.71212 .42063 L
.69841 .38237 L
.69787 .38095 L
.67904 .34127 L
.65873 .30576 L
.65646 .30159 L
.63518 .2619 L
.6193 .22222 L
.61905 .22158 L
.60975 .18254 L
.6048 .14286 L
.60278 .10317 L
.60259 .06349 L
.60358 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.60358 .97619 m
.60259 .93651 L
.60278 .89683 L
.6048 .85714 L
.60975 .81746 L
.61905 .77842 L
.6193 .77778 L
.63518 .7381 L
.65646 .69841 L
.65873 .69424 L
.67904 .65873 L
.69787 .61905 L
.69841 .61763 L
.71212 .57937 L
.72123 .53968 L
.72457 .5 L
.72123 .46032 L
.71212 .42063 L
.69841 .38237 L
.69787 .38095 L
.67904 .34127 L
.65873 .30576 L
.65646 .30159 L
.63518 .2619 L
.6193 .22222 L
.61905 .22158 L
.60975 .18254 L
.6048 .14286 L
.60278 .10317 L
.60259 .06349 L
.60358 .02381 L
s
0 1 .88 r
.65873 .5 m
.65873 .5 L
.65873 .5 L
.65873 .5 L
F
0 g
.65873 .5 m
.65873 .5 L
.65873 .5 L
.65873 .5 L
.65873 .5 L
s
0 .4 1 r
.71013 .97619 m
.70686 .93651 L
.70514 .89683 L
.70546 .85714 L
.70841 .81746 L
.71446 .77778 L
.72356 .7381 L
.73479 .69841 L
.7381 .68714 L
.74655 .65873 L
.75718 .61905 L
.76544 .57937 L
.77061 .53968 L
.77237 .5 L
.77061 .46032 L
.76544 .42063 L
.75718 .38095 L
.74655 .34127 L
.7381 .31286 L
.73479 .30159 L
.72356 .2619 L
.71446 .22222 L
.70841 .18254 L
.70546 .14286 L
.70514 .10317 L
.70686 .06349 L
.71013 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.71013 .97619 m
.70686 .93651 L
.70514 .89683 L
.70546 .85714 L
.70841 .81746 L
.71446 .77778 L
.72356 .7381 L
.73479 .69841 L
.7381 .68714 L
.74655 .65873 L
.75718 .61905 L
.76544 .57937 L
.77061 .53968 L
.77237 .5 L
.77061 .46032 L
.76544 .42063 L
.75718 .38095 L
.74655 .34127 L
.7381 .31286 L
.73479 .30159 L
.72356 .2619 L
.71446 .22222 L
.70841 .18254 L
.70546 .14286 L
.70514 .10317 L
.70686 .06349 L
.71013 .02381 L
s
0 .16 1 r
.82538 .97619 m
.81846 .93651 L
.81746 .93019 L
.813 .89683 L
.80928 .85714 L
.80758 .81746 L
.80802 .77778 L
.81049 .7381 L
.81452 .69841 L
.81746 .67356 L
.81938 .65873 L
.8242 .61905 L
.82822 .57937 L
.83086 .53968 L
.83178 .5 L
.83086 .46032 L
.82822 .42063 L
.8242 .38095 L
.81938 .34127 L
.81746 .32644 L
.81452 .30159 L
.81049 .2619 L
.80802 .22222 L
.80758 .18254 L
.80928 .14286 L
.813 .10317 L
.81746 .06981 L
.81846 .06349 L
.82538 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.82538 .97619 m
.81846 .93651 L
.81746 .93019 L
.813 .89683 L
.80928 .85714 L
.80758 .81746 L
.80802 .77778 L
.81049 .7381 L
.81452 .69841 L
.81746 .67356 L
.81938 .65873 L
.8242 .61905 L
.82822 .57937 L
.83086 .53968 L
.83178 .5 L
.83086 .46032 L
.82822 .42063 L
.8242 .38095 L
.81938 .34127 L
.81746 .32644 L
.81452 .30159 L
.81049 .2619 L
.80802 .22222 L
.80758 .18254 L
.80928 .14286 L
.813 .10317 L
.81746 .06981 L
.81846 .06349 L
.82538 .02381 L
s
.08 0 1 r
.95976 .97619 m
.9481 .93651 L
.93777 .89683 L
.93651 .89159 L
.92895 .85714 L
.92183 .81746 L
.91648 .77778 L
.91288 .7381 L
.91084 .69841 L
.91004 .65873 L
.91006 .61905 L
.91045 .57937 L
.91085 .53968 L
.91101 .5 L
.91085 .46032 L
.91045 .42063 L
.91006 .38095 L
.91004 .34127 L
.91084 .30159 L
.91288 .2619 L
.91648 .22222 L
.92183 .18254 L
.92895 .14286 L
.93651 .10841 L
.93777 .10317 L
.9481 .06349 L
.95976 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.95976 .97619 m
.9481 .93651 L
.93777 .89683 L
.93651 .89159 L
.92895 .85714 L
.92183 .81746 L
.91648 .77778 L
.91288 .7381 L
.91084 .69841 L
.91004 .65873 L
.91006 .61905 L
.91045 .57937 L
.91085 .53968 L
.91101 .5 L
.91085 .46032 L
.91045 .42063 L
.91006 .38095 L
.91004 .34127 L
.91084 .30159 L
.91288 .2619 L
.91648 .22222 L
.92183 .18254 L
.92895 .14286 L
.93651 .10841 L
.93777 .10317 L
.9481 .06349 L
.95976 .02381 L
s
.5 .5 m
.5 .5 .1746 0 365.73 arc
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  ImageSize->{204.5, 205.125},
  ImageMargins->{{53.25, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003o000101000`40O003h00O6Goo0`007goo1@00
7Woo1@006Woo10007Woo1@007Goo1@007Woo0`0067oo000HOol01@00Oomoogoo00007Woo00D007oo
Oomoo`00021oo`03001oogoo01Uoo`03001oogoo009oo`03001oogoo01eoo`03001oogoo01eoo`05
001oogooOol0000MOol01@00Oomoogoo00005goo000LOol00`00Oomoo`0MOol00`00Oomoo`0QOol0
0`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0MOol00`00Oomoo`0NOol00`00Oomoo`0ROol0
0`00Oomoo`0EOol0011oo`H000Ioo`03001oogoo01Aoo`H000Aoo`03001oogoo01Eoo`H000Eoo`03
001oogoo01Uoo`03001oogoo009oo`03001oogoo01eoo`03001oogoo01moo`03001oogoo025oo`03
001oogoo01Eoo`006Woo0P008Woo00<007ooOol07goo00<007ooOol06Goo00<007ooOol00Woo00<0
07ooOol07Goo00<007ooOol087oo00<007ooOol07Woo0P0067oo000LOol00`00Oomoo`0POol00`00
Oomoo`0NOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`0MOol00`00Oomoo`0QOol00`00
Oomoo`0OOol00`00Oomoo`0EOol001Qoo`05001oogooOol0000NOol01@00Oomoogoo00007Woo0`00
6goo00<007ooOol00Woo00<007ooOol06goo0`007goo00D007ooOomoo`0001eoo`05001oogooOol0
000GOol001Uoo`<0021oo`<0025oo`03001oogoo01Yoo`@0021oo`03001oogoo01ioo`<001moo`<0
01Qoo`00ogoo003oOol00?moo`00ogoo003oOol00?moo`004WoofP004goo000BOol00`00Oomoo`02
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`02Ool00`00Oomoo`0AOol000Uoo`<000Ioo`03001oogoo06Yoo`03001oogoo06Uo
o`03001oogoo015oo`0027oo00D007ooOomoo`0000Eoo`03001oogoo06Yoo`03001oogoo06Uoo`03
001oogoo015oo`0037oo00<007ooOol00goo00<007ooOol0JWoo00<007ooOol0JGoo00<007ooOol0
4Goo00060006Ool00`00Oomoo`03Ool20007Ool00`00Oomoo`0JOol00`00Oomoo`0FOol00`00Oomo
o`0DOol00`00Oomoo`0DOol00`00Oomoo`0COol00`00Oomoo`0DOol00`00Oomoo`0FOol00`00Oomo
o`0KOol00`00Oomoo`04Ool2000COol000Yoo`8000Ioo`03001oogoo009oo`052n07h0_P1n00000L
0n@00`000n`3k00F0n`00`000o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`03
0o@000?k01D3n`030003O`=o01<3O`030002O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o
0Yl00`9o00<2W`000Il05`6O00<0002O09l06`2O00<000@O21l01Goo00<007ooOol04Goo000<Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool01@OP2n07h0_P000070?T03<000?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<000?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/0
1@?l0003O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl0<@000Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0001`0W`0400047`PO11l5Ool00`00Oomoo`0AOol000Qo
o`05001oogooOol00005Ool00`00Oomoo`02Ool01P_P1n0;h0OP2n0001`3i0030003k0?/01D3k005
0003l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d0083l`030003n`?k01@3n`03
0003O`=o01<3O`050002O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O0082O`03
0001W`6O01H1W`030000W`2O01X0W`0400087`@O21l5Ool00`00Oomoo`0AOol000Uoo`<000Ioo`03
001oogoo009oo`061n0;h0OP2n07h00070?T030000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c00030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0003W`030gl01@>O
0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0b0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il001`0W`0400047`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`062n07
h0_P1n0;h00070?T00<000?/0n`05P?/00<000?d0o<00P?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c
0o<3m0030o<00`?d0003n`0E0o/00`000gl3O`0C0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o
00D2W`9o0Wl2O`:O00<2O`030Yl0006O01H1W`030000W`2O01X0W`0500047`PO11l87`05Ool00`00
Oomoo`0AOol0019oo`03001oogoo009oo`061n0;h0OP2n07h00070?T038000?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0003n`?l0`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/0
1@?l0003O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl0<0000Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl001`0W`0500087`@O21l47`05Ool00`00Oomoo`0AOol0019o
o`8000=oo`072n07h0_P1n0;h0OP000070?T00<000?/0n`05@?/00@000?c0o<3m0<3l`050o@3l`?c
0o<3m0030o<01@?d0o<3l`?c0o@00P?c00<000?k0o/050?k00<000=o0gl04`=o00D0009o0Wl2O`:O
00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00P9o00<0006O0Il05@6O00<0002O09l06P2O
00D000@O21l47`PO00Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00L7h0_P1n0;h0OP2n00
000L0n@0;`000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c00000`?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0030o/01@?l0o/3n`000il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3
W`030gl0<@>O0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0001/0W`0600047`PO11l8
7`@O1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool01`_P1n0;h0OP2n07h00001`3i0030003
k0?/01D3k0030003m0?c0083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0000o/0
5@?k00<000=o0gl04`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl0
0`:O0001W`0F0Il00`0009l0W`0I09l01P0021l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<0
07ooOol00Woo00L7h0_P1n0;h0OP2n00000L0n@0<@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0003n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0000gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00P=o030000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o000K09l01P0011l87`@O21l47`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo
00P;h0OP2n07h0_P1n0;h0006`?T00<000?/0n`05@?/00@000?c0o<3m0<3l`050o@3l`?c0o<3m003
0o<01@?d0o<3l`?c0o@00P?c00<000?k0o/050?k00<000=o0gl04`=o00D0009o0Wl2O`:O00<2O`05
0Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00P9o00<0006O0Il05@6O00<0002O09l06@2O00H000PO
11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`081n0;h0OP2n07h0_P1n0001/3
i00_0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000030o/01@?l0o/3n`?k0o`00`?k00D3
o0?k0o/3n`?l00<3n`050o`3n`?k0003W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`0a0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00006P2O00L000PO11l87`@O21l4
7`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`082n07h0_P1n0;h0OP2n0001/3i0030003
k0?/01D3k0030003m0?c0083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0000o/0
5@?k00<000=o0gl04`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl0
0`:O0001W`0F0Il00`0009l0W`0H09l01`0011l87`@O21l47`PO00Eoo`03001oogoo015oo`004Woo
0P000goo00T7h0_P1n0;h0OP2n07h0_P00006P?T034000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`000o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`000=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0`0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`006P2O00L000PO11l87`@O21l47`05Ool00`00Oomoo`0AOol0019oo`03001oogoo
009oo`092n07h0_P1n0;h0OP2n07h00001/3i0030003k0?/01@3k0040003l`?c0o@30o<01@?d0o<3
l`?c0o@00`?c00D3m0?c0o<3l`?d0083l`030003n`?k01@3n`030003O`=o01<3O`050002O`9o0Wl2
W`030Wl01@:O0Wl2O`9o0Yl00`9o00L2W`9o0Wl2O`:O0Wl0000G0Il00`0009l0W`0I09l01`0011l8
7`@O21l47`PO00Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00T7h0_P1n0;h0OP2n07h0_P
00006`?T02h000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000<3n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il0
0`=o0303W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000J09l0200011l87`@O21l47`PO
11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0:2n07h0_P1n0;h0OP2n07h0_P000J0n@0
0`000n`3k00D0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030o@0
00?k01D3n`030003O`=o01<3O`030002O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl0
0`9o00<0006O0Il05@6O00<0002O09l0602O00P000PO11l87`@O21l47`PO1Goo00<007ooOol04Goo
000BOol00`00Oomoo`02Ool02POP2n07h0_P1n0;h0OP2n07h0006P?T030000?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<000?k0o`30o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`0
00=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0_0002W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il0000J09l0200011l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019o
o`03001oogoo009oo`0:2n07h0_P1n0;h0OP2n07h0_P000J0n@00`000n`3k00D0n`010000o<3l`?d
0`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<00`000o/3n`0D0o/00`000gl3O`0C0gl0
1@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`070Yl2O`9o0Wl2W`9o00005`6O00<0002O09l0
602O00P000PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool02POP2n07
h0_P1n0;h0OP2n07h0006P?T02h000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000<3n`050o`3
n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`030gl0
1@>O0gl3O`=o0il00`=o0303W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000J09l02000
11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`8000=oo`0;2n07h0_P1n0;h0OP2n07h0_P
1n00000I0n@00`000n`3k00D0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d
00<3l`030o@000?k01D3n`030003O`=o01<3O`030002O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O
0Wl2O`9o0Yl00`9o00<0006O0Il05@6O00<0002O09l05`2O00T000@O21l47`PO11l87`@O21l01Goo
00<007ooOol04Goo000BOol00`00Oomoo`02Ool02`OP2n07h0_P1n0;h0OP2n07h0_P00006@?T0300
00?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000?k0o`30o/01@?l0o/3n`?k0o`00`?k00D3o0?k
0o/3n`?l00<3n`050o`000=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0_
0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000I09l02@0021l47`PO11l87`@O21l47`05
Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0;2n07h0_P1n0;h0OP2n07h0_P1n00000J0n@0
0`000n`3k00C0n`010000o<3l`?d0`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<00`00
0o/3n`0D0o/00`000gl3O`0C0gl01@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`070Yl2O`9o
0Wl2W`9o00005P6O00<0002O09l0602O00T000@O21l47`PO11l87`@O21l01Goo00<007ooOol04Goo
000BOol00`00Oomoo`02Ool02`OP2n07h0_P1n0;h0OP2n07h0_P00006P?T02d000?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c00000`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3
n`000il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0;`>O0002W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o00006P2O00T000PO11l87`@O21l47`PO11l01Goo00<007ooOol04Goo000B
Ool00`00Oomoo`02Ool030_P1n0;h0OP2n07h0_P1n0;h0OP2n0001T3i0030003k0?/01<3k0030003
m0?c0083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0000o/05@?k00<000=o0gl0
4`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`000Il1W`0D0Il0
0`0009l0W`0G09l02P0021l47`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomo
o`02Ool030OP2n07h0_P1n0;h0OP2n07h0_P1n0001T3i00_0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`000o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`000=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0^0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o000I09l02P0011l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol00`00Oomo
o`02Ool030_P1n0;h0OP2n07h0_P1n0;h0OP2n0001T3i0030003k0?/01<3k0040003l`?c0o@30o<0
1@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d0083l`030003n`?k01@3n`030003O`=o01<3O`050002
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00L2W`9o0Wl2O`:O0Wl0000F0Il00`0009l0W`0G09l0
2P0021l47`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol20003Ool030OP2n07h0_P1n0;
h0OP2n07h0_P1n0001T3i00]0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`0000<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`030gl01@>O
0gl3O`=o0il00`=o02l3W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0001T0W`0:00047`PO
11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0<2n07h0_P1n0;h0OP
2n07h0_P1n0;h0006@?T00<000?/0n`04`?/00<000?d0o<00P?c00D3m0?c0o<3l`?d00<3l`050o@3
l`?c0o<3m0030o<00`?d0003n`0E0o/00`000gl3O`0D0gl00`000Yl2O`020Wl01@:O0Wl2O`9o0Yl0
0`9o00D2W`9o0Wl2O`:O00<2O`030001W`6O01@1W`030000W`2O01H0W`0;00047`PO11l87`@O21l4
7`PO11l87`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0<1n0;h0OP2n07h0_P1n0;h0OP
2n07h0006@?T02l000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0003n`?l00<3n`050o`3n`?k0o/3
o0030o/01@?l0o/3n`?k0o`00`?k00D3o0000gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3
O`=o0il00`=o02d0009o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000602O00/000PO11l87`@O21l4
7`PO11l87`@O00Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00d;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n00000H0n@00`000n`3k00B0n`01@000o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`07
0o@3l`?c0o<3m0?c00005`?k00<000=o0gl050=o00@0009o0Wl2W`<2O`050Yl2O`9o0Wl2W`030Wl0
1@:O0Wl2O`9o0Yl00P9o00<0006O0Il04`6O00<0002O09l05P2O00/000@O21l47`PO11l87`@O21l4
7`PO00Eoo`03001oogoo015oo`0027oo1@001Goo00<007ooOol00Woo00d7h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n00000H0n@0;@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k000
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0030o/01@?l0o/3n`?k
0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0003W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`0_0il3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000H09l02`0021l47`PO
11l87`@O21l47`PO11l01Goo00<007ooOol04Goo0008Ool01@00Oomoogoo00001Goo00<007ooOol0
0Woo00d;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000H0n@00`000n`3k00B0n`00`000o<3m0030o<0
1@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030003n`?k01D3n`030003O`=o01D3O`050002
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00H2W`9o0Wl2O`:O000E0Il00`0009l0W`0E09l03000
21l47`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`002Goo00<007ooOol01Woo00<007oo
Ool00Woo00d7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000H0n@0;0000n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d00020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o
00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0<@>O0gl3O`=o0il000:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`0001L0W`0<00047`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo0006
0004Ool00`00Oomoo`05Ool20003Ool03@_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001P3i0030003
k0?/0183k0050003l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00L3m0?c0o<3l`?d0o<0000G0o/0
0`000gl3O`0E0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O0082O`030001
W`6O01<1W`030000W`2O01D0W`0<00087`@O21l47`PO11l87`@O21l47`PO17oo0P004goo000;Ool0
0`00Oomoo`04Ool00`00Oomoo`02Ool03@OP2n07h0_P1n0;h0OP2n07h0_P1n0;h00001P3i00]0003
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`0
0`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02l3W`=o0gl0
00:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0001L0W`0<00047`PO11l87`@O21l47`PO11l87`@O1Goo
00<007ooOol04Goo000<Ool00`00Oomoo`03Ool00`00Oomoo`02Ool03@_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h00001P3i0030003k0?/0183k0030003l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3
l`?c0o@00`?c00<000?k0o/05@?k00<000=o0gl05@=o00D0009o0Wl2O`:O00<2O`050Yl2O`9o0Wl2
W`030Wl01P:O0Wl2O`9o0Yl001D1W`030000W`2O01D0W`0<00087`@O21l47`PO11l87`@O21l47`PO
1Goo00<007ooOol04Goo0008Ool01@00Oomoogoo00001Goo00<007ooOol00Woo00d7h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n00000H0n@0:`000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`0000<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00H3o0?k0o/3n`?l00020gl01@>O0gl3O`=o0il00`=o00D3
W`=o0gl3O`>O00<3O`0a0il3O`=o0gl3W`=o0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00005`2O00`0
00@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol000Uoo`<000Ioo`03001oogoo009o
o`0=2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP000060?T00<000?/0n`04P?/00D000?c0o<3l`?d00<3
l`050o@3l`?c0o<3m0030o<01P?d0o<3l`?c0o@001P3n`030003O`=o01H3O`030002W`9o0082O`05
0Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00P9o00<0006O0Il04`6O00<0002O09l05@2O00`000PO
11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0>1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0001L3i00]0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0003n`?l00<3
n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3
W`030gl01@>O0gl3O`=o0il00`=o02l3W`=o0gl3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0001H0
W`0=00087`@O21l47`PO11l87`@O21l47`PO11l01Goo00<007ooOol04Goo000BOol00`00Oomoo`02
Ool03P_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000G0n@00`000n`3k00A0n`010000o<3l`?d0`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<00`000o/3n`0F0o/00`000gl3O`0F0gl01000
0Wl2O`:O0`9o00D2W`9o0Wl2O`:O00<2O`070Yl2O`9o0Wl2W`9o0000506O00<0002O09l0502O00d0
00@O21l47`PO11l87`@O21l47`PO11l87`05Ool00`00Oomoo`0AOol0019oo`8000=oo`0>1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0001L3i00[0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000o`00`?k00D3
o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01P?l0o/3n`?k0o`00083O`050il3O`=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0Z0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`00
5P2O00d000PO11l87`@O21l47`PO11l87`@O21l47`05Ool00`00Oomoo`0AOol0019oo`03001oogoo
009oo`0>2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n0001L3i0030003k0?/0143k0030003m0?c0083
l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<000?k0o/05`?k00<000=o0gl05`=o00D0
009o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0000506O00<0002O09l0502O00d0
00@O21l47`PO11l87`@O21l47`PO11l87`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0>
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0001L3i00Z0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000P?k
00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00P?k00<000>O0gl00P=o
00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0;`>O0gl3O`=o0il000:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o00005P2O00d000PO11l87`@O21l47`PO11l87`@O21l47`05Ool00`00Oomoo`0AOol0019o
o`03001oogoo009oo`0>2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n0001L3i0030003k0?/0143k004
0003l`?c0o@30o<01@?d0o<3l`?c0o@00`?c00H3m0?c0o<3l`?d000J0o/00`000gl3O`0H0gl00`00
0Yl2O`020Wl01@:O0Wl2O`9o0Yl00`9o00L2W`9o0Wl2O`:O0Wl0000D0Il00`0009l0W`0D09l03@00
11l87`@O21l47`PO11l87`@O21l47`PO00Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00h7
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0005`?T02/000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o003
0o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3
O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02T0009o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`0001H0W`0=00087`@O21l47`PO11l87`@O21l47`PO11l01Goo00<007ooOol04Goo000BOol00`00
Oomoo`02Ool03P_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000G0n@00`000n`3k00@0n`00`000o<3
m0030o<01@?d0o<3l`?c0o@00`?c00L3m0?c0o<3l`?d0o<0000K0o/00`000gl3O`0H0gl010000Wl2
O`:O0`9o00D2W`9o0Wl2O`:O00<2O`060Yl2O`9o0Wl2W`004`6O00<0002O09l0502O00d000@O21l4
7`PO11l87`@O21l47`PO11l87`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0?1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h00001D3i00Z0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l0`?k00D3
o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00P?k00<000>O0gl00P=o00D3
W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00P=o02P000:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl001D0W`0>00047`PO11l87`@O21l47`PO11l87`@O21l47`Eoo`03001oogoo015oo`004Woo
0P000goo00l;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00005@?T00<000?/0n`04@?/00D000?c
0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<010?d0o<3l`0070?k00<000=o0gl06@=o00D0009o0Wl2
O`:O00<2O`050Yl2O`9o0Wl2W`030Wl010:O0Wl2O`004`6O00<0002O09l04`2O00h000PO11l87`@O
21l47`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`OP2n07h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n00000E0n@0:0000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000`?k00D3o0?k0o/3
n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0000gl3O`>O00<3O`050il3
O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02d3W`=o0gl3O`>O0002W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000
5@2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol00`00Oomo
o`02Ool03`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000E0n@00`000n`3k00@0n`010000o<3
l`?d0`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<0000M0o/00`000gl3O`0J0gl00`000Yl2O`02
0Wl01@:O0Wl2O`9o0Yl00`9o00L2W`9o0Wl2O`:O0Wl0000B0Il00`0009l0W`0C09l03P0021l47`PO
11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0?1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h00001D3i00W0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000083n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0003W`030gl01@>O
0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl09`000Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl0000E09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03
001oogoo009oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001D3i0030003k0?/0103k003
0003m0?c0083l`050o@3l`?c0o<3m0030o<01`?d0o<3l`?c0o@3l`0001d3n`030003O`=o01/3O`03
0002O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o00004P6O00<0002O09l04`2O00h000PO
11l87`@O21l47`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000E0n@0:0000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0003n`?l0`?k00D3
o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0000gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0V0002W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl001D0W`0>00047`PO11l87`@O21l47`PO11l87`@O21l47`Eoo`03001oogoo015oo`004Woo
0P000goo00l;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00005@?T00<000?/0n`03`?/00D000?c
0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<010?d0o<3l`007P?k00<000=o0gl070=o00@0009o0Wl2
W`<2O`050Yl2O`9o0Wl2W`030Wl010:O0Wl2O`004@6O00<0002O09l04`2O00h000PO11l87`@O21l4
7`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n00000E0n@09P000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000o`30o/01@?l0o/3n`?k0o`00`?k
00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`000il00`=o00D3W`=o0gl3O`>O
00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02L3W`=o0002O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00005@2O
00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol00`00Oomoo`02
Ool03`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000D0n@00`000n`3k00@0n`00`000o<3m003
0o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`0001l3n`030003O`=o01d3O`050002O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00<2W`9o00004@6O00<0002O09l04P2O00h000PO11l87`@O21l47`PO
11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n00000D0n@09@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`0000<3n`050o`3n`?k0o/3o0030o/01@?l
0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02X3W`=o0gl3O`>O0002W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000D
09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo
009oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001@3i0030003k0?/00l3k0030003m0?c
0083l`050o@3l`?c0o<3m0030o<01P?d0o<3l`?c0o@00203n`030003O`=o01h3O`030002W`9o0082
O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o00004@6O00<0002O09l04P2O00h000PO11l87`@O21l4
7`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n00000D0n@090000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@00083n`050o`3n`?k0o/3o0030o/01@?l
0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0020o/00`000il3O`020gl01@>O
0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0:0>O0gl3O`=o0002O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`00502O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol0
0`00Oomoo`02Ool03`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000D0n@00`000n`3k00?0n`0
10000o<3l`?d0`?c00D3m0?c0o<3l`?d00<3l`030o@3l`000243n`030003O`=o01l3O`030002O`:O
00<2O`050Yl2O`9o0Wl2W`030Wl010:O0Wl2O`00406O00<0002O09l04P2O00h000PO11l87`@O21l4
7`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol20003Ool03`OP2n07h0_P1n0;h0OP2n07
h0_P1n0;h0OP2n00000D0n@09@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0003n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3
n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3O`05
0il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0S0002W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000D
09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo
009oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001@3i0030003k0?/00h3k0030003l`?d
00<3l`050o@3l`?c0o<3m0030o<00`?d0o<0000S0o/00`000gl3O`0P0gl010000Wl2O`:O0`9o00D2
W`9o0Wl2O`:O00<2O`030Yl0006O00l1W`030000W`2O0180W`0>00087`@O21l47`PO11l87`@O21l4
7`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00l7h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P000050?T02<000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`0
0`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0020o/00`000il3O`020gl01@>O0gl3O`=o0il0
0`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0:@>O0gl3O`=o0il3O`000Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000
4`2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol00`00Oomo
o`02Ool03`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000D0n@00`000n`3k00=0n`00`000o@3
l`020o<01@?d0o<3l`?c0o@00`?c00@3m0?c0o<002@3n`030003O`=o0243O`050002O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00<0006O0Il03P6O00<0002O09l04@2O00h000PO11l87`@O21l47`PO
11l87`@O21l47`PO1Goo00<007ooOol04Goo0009Ool50004Ool00`00Oomoo`02Ool040OP2n07h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0004`?T024000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c00000`?k00D3o0?k0o/3n`?l00<3n`050o`3
n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`000=o0gl3W`030gl0
1@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl09`>O0gl3O`=o0il3
O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl0000C09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol000]o
o`03001oogoo00Aoo`03001oogoo009oo`0@2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000C
0n@00`000n`3k00=0n`010000o<3l`?d0`?c00D3m0?c0o<3l`?d00<3l`030003n`?k01X3na4001h3
O`050002O`9o0Wl2W`030Wl01`:O0Wl2O`9o0Yl2O`000101W`030000W`2O0140W`0>00087`@O21l4
7`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`002goo00<007ooOol017oo00<007ooOol0
0Woo0107h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n000183i00Q0003k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000083n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083naP000030gl3W`=o0083O`050il3
O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02D3W`=o0gl3O`>O0002W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000C09l03P0011l87`@O21l4
7`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol000H000Eoo`03001oogoo00Aoo`8000=oo`0@
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000B0n@00`000n`3k00=0n`00`000o<3m0030o<0
1@?d0o<3l`?c0o@00`?c00<3m0000o/05@?k7`0060=o00<000:O0Wl00P9o00D2W`9o0Wl2O`:O00<2
O`030Yl0006O00h1W`030000W`2O0140W`0>00087`@O21l47`PO11l87`@O21l47`PO11l87`Aoo`80
01=oo`002goo00<007ooOol017oo00<007ooOol00Woo0107h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n000183i00R0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<000?k0o`30o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083nb<00083
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02<3W`=o0gl3O`000Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0001<0W`0>00047`PO11l8
7`@O21l47`PO11l87`@O21l47`Eoo`03001oogoo015oo`002goo00<007ooOol017oo00<007ooOol0
0Woo010;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n000183i0030003k0?/00d3k0050003l`?c
0o<3m0030o<01`?d0o<3l`?c0o@3l`0001@3nbH001D3O`030002O`:O00<2O`050Yl2O`9o0Wl2W`03
0Wl00`000Il1W`0<0Il00`0009l0W`0A09l03P0021l47`PO11l87`@O21l47`PO11l87`@O21l5Ool0
0`00Oomoo`0AOol000Uoo`<000Ioo`03001oogoo009oo`0@1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP000B0n@080000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0000o`30o/01@?l0o/3n`?k0o`00`?k00H3o0?k0o/3n`?l0o/Y00000`=o0il3
O`020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0N0002W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`004`2O00h000@O21l47`PO11l87`@O
21l47`PO11l87`@O1Goo00<007ooOol04Goo000;Ool00`00Oomoo`04Ool00`00Oomoo`02Ool040_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0004P?T00<000?/0n`030?/00@000?c0o<3m0<3l`05
0o@3l`?c0o<3m0020o<00`000o/3n`0@0o//000C0gl010000Wl2O`:O0`9o00L2W`9o0Wl2O`:O0Wl0
000>0Il00`0009l0W`0A09l03P0021l47`PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0A
Ool0019oo`03001oogoo009oo`0@1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP000A0n@07`00
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`00
00<3n`050o`3n`?k0o/3o0030o/01P?l0o/3n`?k0o`3nbh000050il3O`=o0gl3W`030gl01@>O0gl3
O`=o0il00`=o0203W`=o0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`004P2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol0
4Goo000BOol00`00Oomoo`02Ool040_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0004@?T00<0
00?/0n`03@?/00<000?d0o<00P?c00D3m0?c0o<3l`?d00<3l`030003n`?k00h3nc400183O`050002
O`9o0Wl2W`030Wl01P:O0Wl2O`9o0Yl000h1W`030000W`2O0100W`0>00087`@O21l47`PO11l87`@O
21l47`PO11l87`Eoo`03001oogoo015oo`004Woo0P000goo0107h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n000143i00N0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0000P?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o00c00001@>O0gl3O`=o
0il00`=o00D3W`=o0gl3O`>O00<3O`0N0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`004P2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo
00<007ooOol04Goo000BOol00`00Oomoo`02Ool040_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0004@?T00<000?/0n`030?/00D000?c0o<3l`?d00<3l`060o@3l`?c0o<3m0003`?k=@004@=o00<0
00:O0Wl00P9o00D2W`9o0Wl2O`:O00<2O`030001W`6O00/1W`030000W`2O0100W`0>00087`@O21l4
7`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0107h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n000143i00O0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000?k0o`00`?k00D3o0?k0o/3n`?l00<3n`030o`00000
03D000050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o01`0009o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00180W`0>00047`PO11l87`@O21l47`PO11l8
7`@O21l47`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo010;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n0;h0OP2n000143i0030003k0?/00`3k0030003l`?d00<3l`050o@3l`?c0o<3m0020o<00`00
0o/3n`0;0o/j000>0gl010000Wl2O`:O0`9o00L2W`9o0Wl2O`:O0Wl0000=0Il00`0009l0W`0@09l0
3P0021l47`PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009o
o`0@1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP000A0n@07@000n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000o`00`?k00D3o0?k0o/3n`?l00<3n`03
0o`0000003X000<3O`050il3O`=o0gl3W`030gl07P>O0gl3O`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00180W`0>00047`PO11l87`@O21l47`PO11l87`@O
21l47`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo010;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n000143i0030003k0?/00/3k0030003m0?c0083l`050o@3l`?c0o<3m0030o<00`000o/3
n`0:0o/m000>0gl01@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`0000d1W`030000W`2O0100W`0>0008
7`@O21l47`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0107
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n000143i00L0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00020o/01@?l0o/3n`?k0o`00`?k00<3o0000000
?@0000D3W`=o0gl3O`>O00<3O`0P0il3O`=o0gl3W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00180W`0>00047`PO11l87`@O21l47`PO11l87`@O21l47`Eo
o`03001oogoo015oo`004Woo0P000goo010;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n000103
i0030003k0?/00`3k0040003l`?c0o@30o<01P?d0o<3l`?c0o@000`3nd0000d3O`030002W`9o0082
O`050Yl2O`9o0Wl2W`020Wl00`000Il1W`0;0Il00`0009l0W`0?09l03P0021l47`PO11l87`@O21l4
7`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0@1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP000@0n@07P000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`000o/3o0<3n`060o`3n`?k0o/3o0?k@@0000<3O`>O0gl00P=o00D3W`=o
0gl3O`>O00<3O`0K0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`000140W`0>00047`PO11l87`@O21l47`PO11l87`@O21l47`Eoo`03001oogoo015oo`004Woo
00<007ooOol00Woo010;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n000103i0030003k0?/00/3
k0030003l`?d00<3l`070o@3l`?c0o<3m0?c000030?k@P003@=o00<0009o0Yl00`9o00H2W`9o0Wl2
O`:O000=0Il00`0009l0W`0?09l03P0021l47`PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomo
o`0AOol0019oo`03001oogoo009oo`0@1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP000@0n@0
70000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l0`?k
00D3o0?k0o/3n`?l0083nd<00083O`050il3O`=o0gl3W`030gl07@>O0gl3O`000Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00004@2O00h000@O21l47`PO11l87`@O
21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool040_P1n0;h0OP2n07h0_P
1n0;h0OP2n07h0_P1n0;h00040?T00<000?/0n`02`?/00D000?c0o<3l`?d00<3l`050o@3l`?c0o<0
000;0o]4000<0gl01@000Wl2O`9o0Yl00`9o00@2W`9o0Wl000d1W`030000W`2O00l0W`0>00087`@O
21l47`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0107h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n000103i00K0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000083n`050o`3n`?k0o/3o0030o/00`?l000000130002
0gl01@>O0gl3O`=o0il00`=o01/3W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o00004@2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol0
4Goo000BOol00`00Oomoo`02Ool040_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h00040?T00<0
00?/0n`02`?/00<000?c0o@00`?c00H3m0?c0o<3l`?d000;0o]6000<0gl00`000Yl2O`020Wl01P:O
0Wl2O`9o0Yl000d1W`030000W`2O00l0W`0>00087`@O21l47`PO11l87`@O21l47`PO11l87`Eoo`03
001oogoo015oo`004Woo0P000goo0107h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n000103i00L
0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<000?k0o`30o/0
1P?l0o/3n`?k0o`3ndH000050il3O`=o0gl3W`030gl07@>O0gl3O`=o0002O`:O0Wl2W`9o0Yl2O`:O
0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00004@2O00h000@O21l47`PO11l87`@O21l47`PO
11l87`@O1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n00000A0n@00`000n`3k00:0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00P?c00<000?k
0o/020?kA`0030=o00@0009o0Wl2W`<2O`050Yl2O`9o0Wl0000=0Il00`0009l0W`0>09l03P0021l4
7`PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0?1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0000143i00J0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0
00?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000<3n`050o`3n`?k0o/3o0020o]800000`=o0il3O`020gl0
80>O0gl3O`=o0il3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O000@09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03
001oogoo009oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0000143i0030003k0?/00X3k004
0003l`?c0o@30o<01@?d0o<3l`?c00002P?kB@0030=o00D0009o0Wl2O`:O00<2O`030Yl2O`0000d1
W`030000W`2O00h0W`0>00087`@O21l47`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`00
4Woo00<007ooOol00Woo00l7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P00004@?T01T000?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@000020o/01@?l0o/3n`?k0o`0
0`?kB@000`=o00D3W`=o0gl3O`>O00<3O`0J0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il00100W`0>00047`PO11l87`@O21l47`PO11l87`@O21l47`Eoo`03001o
ogoo015oo`004Woo00<007ooOol00Woo00l;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00004@?T
00<000?/0n`02P?/00<000?d0o<00P?c00L3m0?c0o<3l`?d0o<0000:0o]:000;0gl00`000Wl2W`03
0Wl01@:O0Wl2O`9o00003@6O00<0002O09l03P2O00h000PO11l87`@O21l47`PO11l87`@O21l47`PO
1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n00000A0n@06P000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m000
0o`30o/01P?l0o/3n`?k0o`3ndX000050il3O`=o0gl3W`030gl070>O0gl3O`000Yl2O`:O0Wl2W`9o
0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00402O00h000@O21l47`PO11l87`@O21l4
7`PO11l87`@O1Goo00<007ooOol04Goo000BOol20003Ool03`_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n00000A0n@00`000n`3k00:0n`010000o<3l`?d0`?c00D3m0?c0o<3l`0000X3ndX000/3O`05
0002O`9o0Wl2W`030Wl00`:O0Wl0000=0Il00`0009l0W`0>09l03P0021l47`PO11l87`@O21l47`PO
11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0?1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0000143i00I0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c
0o@3l`?d00000P?k00D3o0?k0o/3n`?l0083nd/00083O`050il3O`=o0gl3W`030gl06P>O0002W`9o
0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000@09l03P0011l87`@O21l4
7`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0?2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0000143i0030003k0?/00X3k0030003m0?c0083l`070o@3l`?c0o<3
m0?c00002@?kB`002`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`0000d1W`030000W`2O00h0W`0>0008
7`@O21l47`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00l7
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P00004@?T01X000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`000o<3m0?c0o@3l`?d0o<3m0?c0003n`?l0`?k00D3o0?k0o/3n`?l04/000050il3O`=o0gl3W`03
0gl070>O0gl3O`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00
402O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo0009Ool40005Ool0
0`00Oomoo`02Ool03`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000A0n@00`000n`3k00:0n`0
10000o<3l`?d0`?c00@3m0?c0o<000X3nd`000X3O`050002O`9o0Wl2W`030Wl010:O0Wl2O`00306O
00<0002O09l03P2O00h000PO11l87`@O21l47`PO11l87`@O21l47`PO1Goo00<007ooOol01Woo0P00
0Woo0P001Goo0008Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool03`OP2n07h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n00000A0n@060000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d
0o<3m0?c0o@3l`?d0o<000<3n`050o`3n`?k0o/3o0020o]<00000`=o0il3O`020gl07P>O0gl3O`=o
0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00100W`0>0004
7`PO11l87`@O21l47`PO11l87`@O21l47`Eoo`03001oogoo00Moo`04001oogoo0006Ool000Qoo`03
001oogoo009oo`03001oogoo009oo`03001oogoo009oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0000143i0030003k0?/00X3k0030003m0?c0083l`060o@3l`?c0o<3m0002P?kC0002P=o00<0
009o0Yl00`9o00H2W`9o0Wl2O`:O000<0Il00`0009l0W`0>09l03P0021l47`PO11l87`@O21l47`PO
11l87`@O21l5Ool00`00Oomoo`08Ool20007Ool000Qoo`03001oogoo009oo`03001oogoo009oo`D0
000?1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0000143i00J0003k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0<3n`050o`3n`?k0o/3o01<00030gl01@>O0gl3
O`=o0il00P=o01T000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0
000@09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l6000:Ool20007Ool000Qoo`03001oogoo
009oo`03001oogoo009oo`03001oogoo009oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h000
0143i0030003k0?/00X3k0040003l`?c0o@30o<010?d0o<3l`002P?kC0002P=o00D0009o0Wl2O`:O
00<2O`040Yl2O`9o000<0Il00`0009l0W`0>09l03P0021l47`PO11l87`@O21l47`PO11l87`@O21l5
Ool00`00Oomoo`07Ool01000Oomoo`001Woo0008Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool03`OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000A0n@060000n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<000<3n`050o`3n`?k0o/3o0020o]<00000`=o
0il3O`020gl07P>O0gl3O`=o0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il00100W`0>00047`PO11l87`@O21l47`PO11l87`@O21l47`Eoo`03001oogoo00Ioo`80
009oo`8000Eoo`0027oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00l;h0OP2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP00004@?T00<000?/0n`02P?/00<000?d0o<00P?c00H3m0?c0o<3
l`?d000:0o];000;0gl00`000Wl2W`030Wl01P:O0Wl2O`9o0Yl000`1W`030000W`2O00h0W`0>0008
7`@O21l47`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`002Goo10001Goo00<007ooOol0
0Woo00l7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P00004@?T01X000?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0003n`?l0`?k00D3o0?k0o/3n`?l04/000050il3O`=o
0gl3W`030gl070>O0gl3O`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`00402O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol0
0`00Oomoo`02Ool03`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000A0n@00`000n`3k00:0n`0
10000o<3l`?d0`?c00D3m0?c0o<3l`0000T3nd/000/3O`050002O`9o0Wl2W`030Wl00`:O0Wl0000=
0Il00`0009l0W`0>09l03P0021l47`PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0
019oo`03001oogoo009oo`0?1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0000143i00I0003k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d00000P?k00D3o0?k0o/3n`?l
00<3ndX00083O`050il3O`=o0gl3W`030gl06P>O0002W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O000@09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00
Oomoo`0AOol0019oo`8000=oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0000143i0030003
k0?/00X3k0030003m0?c0083l`070o@3l`?c0o<3m0?c00002P?kBP002`=o00<0009o0Yl00`9o00D2
W`9o0Wl2O`0000d1W`030000W`2O00h0W`0>00087`@O21l47`PO11l87`@O21l47`PO11l87`Eoo`03
001oogoo015oo`004Woo00<007ooOol00Woo00l7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P0000
4@?T01X000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@000?l0`?k
00H3o0?k0o/3n`?l0o]:00001@>O0gl3O`=o0il00`=o01`3W`=o0gl000:O0Wl2W`9o0Yl2O`:O0Wl2
W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00100W`0>00047`PO11l87`@O21l47`PO11l87`@O
21l47`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00l;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP00004@?T00<000?/0n`02P?/00@000?c0o<3m0<3l`050o@3l`?c0o<0000:0o]9000<0gl0
1@000Wl2O`9o0Yl00`9o00<2W`9o00003@6O00<0002O09l03P2O00h000PO11l87`@O21l47`PO11l8
7`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`OP2n07h0_P1n0;h0OP2n07
h0_P1n0;h0OP2n00000A0n@06@000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3
l`?d0o<3m0000083n`050o`3n`?k0o/3o0030o]900030gl01@>O0gl3O`=o0il00`=o01X3W`000Yl2
O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00402O00h000@O21l47`PO
11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n00000A0n@00`000n`3k00:0n`00`000o@3l`020o<01@?d0o<3l`?c
0o@00P?c00<000?k0o/01`?kB@002`=o00@0009o0Wl2W`<2O`050Yl2O`9o0Wl0000=0Il00`0009l0
W`0>09l03P0021l47`PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001o
ogoo009oo`0?1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0000143i00J0003k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000<3n`050o`3n`?k0o/3o0020o]80000
0`=o0il3O`020gl080>O0gl3O`=o0il3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O000@09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomo
o`0AOol0019oo`8000=oo`0@2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000@0n@00`000n`3
k00;0n`00`000o<3m0030o<01P?d0o<3l`?c0o@000X3ndL000`3O`030002W`9o0082O`060Yl2O`9o
0Wl2W`003@6O00<0002O09l03`2O00h000PO11l87`@O21l47`PO11l87`@O21l47`PO1Goo00<007oo
Ool04Goo000BOol00`00Oomoo`02Ool040OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00040?T
01`000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0<3
n`060o`3n`?k0o/3o0?kAP0000D3W`=o0gl3O`>O00<3O`0M0il3O`=o0gl0009o0Yl2O`:O0Wl2W`9o
0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000A09l03P0011l87`@O21l47`PO11l87`@O
21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0@2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n07h0_P000@0n@00`000n`3k00;0n`01@000o<3l`?c0o@00`?c00D3m0?c0o<3l`0000/3
ndD000/3O`050002O`9o0Wl2W`030Wl010:O0Wl2O`003@6O00<0002O09l03`2O00h000PO11l87`@O
21l47`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool040OP2n07h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h00040?T01/000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003
m0?c0o@3l`?d0o<3m0?c0o@3l`?d00000P?k00D3o0?k0o/3n`?l00<3n`030o`00000048000<3O`05
0il3O`=o0gl3W`030gl06`>O0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl0000A09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0
019oo`03001oogoo009oo`0@2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000@0n@00`000n`3
k00;0n`00`000o<3m0030o<01`?d0o<3l`?c0o@3l`0000/3nd@000`3O`030002O`:O00<2O`060Yl2
O`9o0Wl2W`003@6O00<0002O09l03`2O00h000PO11l87`@O21l47`PO11l87`@O21l47`PO1Goo00<0
07ooOol04Goo000BOol00`00Oomoo`02Ool040OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h000
40?T01`000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003
o0<3n`050o`3n`?k0o/3o0020o]300020gl01@>O0gl3O`=o0il00`=o01d3W`=o0gl000:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`000140W`0>00047`PO11l87`@O
21l47`PO11l87`@O21l47`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo010;h0OP2n07h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n000103i0030003k0?/00/3k0050003l`?c0o<3m0030o<01P?d0o<3
l`?c0o@000/3nd4000d3O`030002W`9o0082O`050Yl2O`9o0Wl2W`020Wl00`000Il1W`0;0Il00`00
09l0W`0?09l03P0021l47`PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`80
00=oo`0@1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP000@0n@07P000n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0<3n`050o`3n`?k0o/3o002
0o]000000`=o0il3O`020gl01@>O0gl3O`=o0il00`=o01/0009o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0
005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00004@2O00h000@O21l47`PO11l87`@O21l47`PO11l8
7`@O1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool040_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n0;h00040?T00<000?/0n`030?/00<000?d0o<00P?c00D3m0?c0o<3l`?d0083l`030003n`?k
00X3ncl000h3O`040002O`9o0Yl30Wl01P:O0Wl2O`9o0Yl000d1W`030000W`2O00l0W`0>00087`@O
21l47`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0107h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n000143i00L0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00020o/01@?l0o/3n`?k0o`00`?k00<3o0?k0000?000
00<3O`>O0gl00P=o00D3W`=o0gl3O`>O00<3O`0L0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000B09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5
Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0@2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P000A0n@00`000n`3k00;0n`010000o<3l`?d0`?c00L3m0?c0o<3l`?d0o<0000<0o/m000>0gl0
0`000Wl2W`030Wl01`:O0Wl2O`9o0Yl2O`0000d1W`030000W`2O0100W`0>00087`@O21l47`PO11l8
7`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0107h0_P1n0;h0OP2n07
h0_P1n0;h0OP2n07h0_P1n000143i00M0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<000030o/01@?l0o/3n`?k0o`00`?k00<3o0000000>@0000D3W`=o
0gl3O`>O00<3O`0R0il3O`=o0gl3W`=o0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O000B09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00
Oomoo`0AOol0019oo`03001oogoo009oo`0@2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000A
0n@00`000n`3k00<0n`01@000o<3l`?c0o@00`?c00H3m0?c0o<3l`?d000>0o/h000?0gl00`000Yl2
O`020Wl01@:O0Wl2O`9o0Yl00`9o00<0006O0Il02`6O00<0002O09l0402O00h000PO11l87`@O21l4
7`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool040OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0004@?T01l000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0030o/01@?l0o/3n`?k0o`00`?k00<3o0?k0000=@00
00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl070000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`004P2O00h000@O21l47`PO11l87`@O21l47`PO11l8
7`@O1Goo00<007ooOol04Goo000BOol20003Ool040_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0004@?T00<000?/0n`030?/00<000?c0o@00`?c00D3m0?c0o<3l`?d0083l`030003n`?k00h3nc@0
0143O`040002O`9o0Yl30Wl01`:O0Wl2O`9o0Yl2O`0000d1W`030000W`2O0100W`0>00087`@O21l4
7`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0107h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n000143i00N0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000P?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3
o0?k<P0000D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl07P>O0002W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00180W`0>00047`PO11l87`@O21l4
7`PO11l87`@O21l47`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo010;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n000143i0030003k0?/00d3k0040003l`?c0o@30o<01`?d0o<3l`?c0o@3
l`000143nbl001<3O`030002O`:O00<2O`050Yl2O`9o0Wl2W`020Wl00`000Il1W`0<0Il00`0009l0
W`0@09l03P0021l47`PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001o
ogoo009oo`0@1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP000A0n@07`000n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`0000<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00P?k;00000<3O`>O0gl00P=o00D3W`=o0gl3O`>O00<3O`0T0il3
O`=o0gl3W`=o0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`004P2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo0009
Ool50004Ool00`00Oomoo`02Ool040_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0004P?T00<0
00?/0n`030?/00<000?d0o<00P?c00D3m0?c0o<3l`?d00<3l`030o@000?k0183nbX001@3O`030002
W`9o0082O`050Yl2O`9o0Wl2W`030Wl00`000Il1W`0<0Il00`0009l0W`0A09l03P0021l47`PO11l8
7`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol000]oo`03001oogoo00Aoo`03001oogoo009o
o`0@1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP000B0n@080000n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000o`30o/01@?l0o/3n`?k0o`0
0`?k00H3o0?k0o/3n`?l0o/Y00000`=o0il3O`020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O
0083O`0N0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`004`2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000;Ool0
0`00Oomoo`04Ool00`00Oomoo`02Ool040_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0004P?T
00<000?/0n`03@?/00<000?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030003n`?k0183nbH001D3O`05
0002O`9o0Wl2W`030Wl01P:O0Wl2O`9o0Yl000l1W`030000W`2O0140W`0>00087`@O21l47`PO11l8
7`@O21l47`PO11l87`Eoo`03001oogoo015oo`002goo00<007ooOol017oo0P000goo0107h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n000183i00R0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000?k0o`30o/01@?l0o/3n`?k0o`00`?k00D3
o0?k0o/3n`?l00<3n`030o`0000001d000050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3
W`=o0gl3O`>O00<3O`0O0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o00004`2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O17oo0P004goo
000;Ool00`00Oomoo`04Ool00`00Oomoo`02Ool040_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0004P?T00<000?/0n`03@?/00D000?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<00`000o/3n`0F
0o/L000H0gl01@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O0082O`030001W`6O00d1W`030000W`2O
0140W`0>00087`@O21l47`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`002goo00<007oo
Ool017oo00<007ooOol00Woo0107h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0001<3i00P0003
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@0
0083n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083naP000030gl3
W`=o0083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02D3W`=o0gl3O`>O0002W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000C09l0
3P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol000Uoo`<000Ioo`03001o
ogoo009oo`0@2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000C0n@00`000n`3k00=0n`00`00
0o@3l`020o<01@?d0o<3l`?c0o@00`?c00<3m0?c000070?k4@007@=o00@0009o0Wl2W`<2O`050Yl2
O`9o0Wl2W`030Wl00`000Il1W`0>0Il00`0009l0W`0A09l03P0021l47`PO11l87`@O21l47`PO11l8
7`@O21l5Ool00`00Oomoo`0AOol000]oo`03001oogoo00Aoo`03001oogoo009oo`0@1n0;h0OP2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP000C0n@08@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000030o/01@?l0o/3n`?k0o`00`?k00D3o0?k
0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01P?l0o/3n`?k0o`3n`H000050il3O`=o0gl3W`030gl0
1@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl08`>O0gl0009o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000
4`2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol00`00Oomo
o`02Ool03`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000D0n@00`000n`3k00>0n`00`000o<3
m0030o<01@?d0o<3l`?c0o@00`?c00<3m0000o/08`?k00<000=o0gl08@=o00<0009o0Yl00`9o00D2
W`9o0Wl2O`:O00<2O`030Yl0006O0101W`030000W`2O0140W`0>00087`@O21l47`PO11l87`@O21l4
7`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00l7h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P000050?T02<000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`0
0`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0020o/00`000il3O`020gl01@>O0gl3O`=o0il0
0`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0:@>O0gl3O`=o0il3O`000Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000
4`2O00h000@O21l47`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000BOol20003Ool0
3`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000D0n@00`000n`3k00>0n`01@000o<3l`?c0o@0
0`?c00D3m0?c0o<3l`?d00<3l`030003n`?k0243n`030003O`=o0203O`030002W`9o0082O`050Yl2
O`9o0Wl2W`030Wl010:O0Wl2O`00406O00<0002O09l04P2O00h000PO11l87`@O21l47`PO11l87`@O
21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n00000D0n@09@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0003n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k
0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3O`050il3
O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0S0002W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000D09l0
3P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009o
o`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001@3i0030003k0?/00l3k0030003m0?c0083
l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c00008@?k00<000=o0gl07`=o00D0009o0Wl2O`:O00<2
O`050Yl2O`9o0Wl2W`030Wl00`:O0001W`0?0Il00`0009l0W`0B09l03P0021l47`PO11l87`@O21l4
7`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0?1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h00001@3i00T0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000P?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083n`030003W`=o0083O`050il3O`=o
0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0X0il3O`=o0gl0009o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
000D09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001o
ogoo009oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001@3i0030003k0?/00l3k0040003
l`?c0o@30o<01@?d0o<3l`?c0o@00`?c00@3m0?c0o<00203n`030003O`=o01h3O`040002O`9o0Yl3
0Wl01@:O0Wl2O`9o0Yl00`9o00<2W`9o00004@6O00<0002O09l04P2O00h000PO11l87`@O21l47`PO
11l87`@O21l47`PO1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool03`OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n00000D0n@09@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`0000<3n`050o`3n`?k0o/3o0030o/01@?l
0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02X3W`=o0gl3O`>O0002W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000D
09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo
009oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001@3i0030003k0?/0103k0050003l`?c
0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0?c00007`?k00<000=o0gl07@=o00<0009o0Yl00`9o
00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl0000A0Il00`0009l0W`0B09l03P0021l47`PO11l87`@O
21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`8000=oo`0?1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h00001D3i00V0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0<3n`050o`3n`?k0o/3o0030o/01@?l0o/3
n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0003W`030gl01@>O0gl3O`=o0il00`=o00D3
W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl09`>O0gl0009o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000E09l03P0011l8
7`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0?2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001D3i0030003k0?/00l3k0030003l`?d00<3l`050o@3
l`?c0o<3m0030o<01P?d0o<3l`?c0o@001h3n`030003O`=o01/3O`030002O`:O00<2O`050Yl2O`9o
0Wl2W`030Wl01P:O0Wl2O`9o0Yl00141W`030000W`2O01<0W`0>00087`@O21l47`PO11l87`@O21l4
7`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00l7h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P00005@?T02P000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0<3n`050o`3n`?k0o/3o0030o/01@?l
0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`000=o0gl3W`030gl01@>O0gl3O`=o0il00`=o
00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl09P000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o000E09l03P0011l8
7`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0?2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001D3i0030003k0?/0103k0040003l`?c0o@30o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`0001d3n`030003O`=o01X3O`030002W`9o0082O`050Yl2O`9o
0Wl2W`030Wl01`:O0Wl2O`9o0Yl2O`000181W`030000W`2O01<0W`0>00087`@O21l47`PO11l87`@O
21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00l7h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n07h0_P00005@?T02L000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`00
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00000P?k00D3o0?k0o/3n`?l00<3n`05
0o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0W0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0001D0W`0>
00047`PO11l87`@O21l47`PO11l87`@O21l47`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo
00l;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00005@?T00<000?/0n`040?/00<000?d0o<00P?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<00`000o/3n`0J0o/00`000gl3O`0I0gl01@00
0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl0000B0Il00`0009l0W`0C09l03P00
21l47`PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0?
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h00001D3i00X0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c00030o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0003O`=o0il0
0`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0;@>O0gl3O`=o0il000:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl0000E09l03P0011l87`@O21l47`PO11l87`@O21l47`PO11l5Ool00`00Oomoo`0AOol0019o
o`8000=oo`0?2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001D3i0030003k0?/0143k0030003
l`?d00<3l`050o@3l`?c0o<3m0030o<01`?d0o<3l`?c0o@3l`0001/3n`030003O`=o01T3O`030002
O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01P:O0Wl2O`9o0Yl001<1W`030000W`2O01<0W`0>00087`@O
21l47`PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00h7h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0005`?T02T000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l00<3n`050o`3
n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083n`030003W`=o0083O`050il3
O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02l3W`=o0gl3O`>O0gl0009o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`0001H0W`0=00087`@O21l47`PO11l87`@O21l47`PO11l01Goo00<007ooOol04Goo000BOol00`00
Oomoo`02Ool03P_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000G0n@00`000n`3k00@0n`01@000o<3
l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`060o@3l`?c0o<3m0006P?k00<000=o0gl060=o00<000:O
0Wl00P9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`020Wl00`000Il1W`0A0Il00`0009l0W`0D
09l03@0011l87`@O21l47`PO11l87`@O21l47`PO00Eoo`03001oogoo015oo`004Woo00<007ooOol0
0Woo00h7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0005`?T02/000?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`00
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3
W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02T0009o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`0001H0W`0=00087`@O21l47`PO11l87`@O21l47`PO11l01Goo00<007ooOol04Goo000B
Ool00`00Oomoo`02Ool03P_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000G0n@00`000n`3k00A0n`0
0`000o@3l`020o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030003n`?k01L3n`030003
O`=o01L3O`050002O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`0001@1W`030000
W`2O01@0W`0=00047`PO11l87`@O21l47`PO11l87`@O21l01Goo00<007ooOol04Goo000BOol00`00
Oomoo`02Ool03POP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP000G0n@0:P000n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@00083n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083n`03
0003W`=o0083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02l3W`=o0gl3O`>O0002W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`0001H0W`0=00087`@O21l47`PO11l87`@O21l47`PO11l01Goo00<007oo
Ool04Goo000BOol00`00Oomoo`02Ool03P_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000G0n@00`00
0n`3k00A0n`010000o<3l`?d0`?c00D3m0?c0o<3l`?d00<3l`070o@3l`?c0o<3m0?c00006@?k00<0
00=o0gl05`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`070Yl2O`9o0Wl2W`9o0000506O00<0
002O09l0502O00d000@O21l47`PO11l87`@O21l47`PO11l87`05Ool00`00Oomoo`0AOol0019oo`80
00=oo`0>1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0001L3i00[0003j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0000o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01P?l0o/3n`?k0o`00083O`05
0il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0Z0002W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`005P2O00d000PO11l87`@O21l47`PO11l87`@O21l47`05Ool00`00Oomoo`0AOol0
019oo`03001oogoo009oo`0>2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n0001L3i0030003k0?/0143
k0030003m0?c0083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0000o/05`?k00<0
00=o0gl05P=o00<000:O0Wl00P9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`000Il1
W`0B0Il00`0009l0W`0D09l03@0011l87`@O21l47`PO11l87`@O21l47`PO00Eoo`03001oogoo015o
o`004Woo00<007ooOol00Woo00h7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0005`?T02d000?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<000?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`000il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0;`>O0gl3O`=o0002
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00005P2O00d000PO11l87`@O21l47`PO11l87`@O21l47`05Ool0
0`00Oomoo`0AOol0019oo`03001oogoo009oo`0=2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP000060?T
00<000?/0n`04P?/00<000?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<00`00
0o/3n`0F0o/00`000gl3O`0F0gl010000Wl2O`:O0`9o00D2W`9o0Wl2O`:O00<2O`060Yl2O`9o0Wl2
W`005@6O00<0002O09l05@2O00`000PO11l87`@O21l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0
00Qoo`D000Eoo`03001oogoo009oo`0=1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P000060?T02/000?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<000030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`06
0o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0<@>O0gl3O`=o0il3
O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0001L0W`0<00047`PO11l87`@O21l47`PO11l87`@O1Goo
00<007ooOol04Goo0008Ool01@00Oomoogoo00001Goo00<007ooOol00Woo00d;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n00000H0n@00`000n`3k00B0n`01@000o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3
l`070o@3l`?c0o<3m0?c00005`?k00<000=o0gl05@=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2
O`050Yl2O`9o0Wl2W`020Wl00`000Il1W`0C0Il00`0009l0W`0E09l0300021l47`PO11l87`@O21l4
7`PO11l87`Eoo`03001oogoo015oo`002Goo00<007ooOol01Woo00<007ooOol00Woo00d7h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n00000H0n@0;@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0030o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0003W`030gl01@>O0gl3O`=o0il0
0`=o00D3W`=o0gl3O`>O00<3O`0_0il3O`=o0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000G09l0
300011l87`@O21l47`PO11l87`@O21l47`Eoo`03001oogoo015oo`002Woo00<007ooOol01Goo0P00
0goo00d;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000H0n@00`000n`3k00B0n`00`000o<3m0030o<0
1@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030003n`?k01D3n`030003O`=o01D3O`050002
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00H2W`9o0Wl2O`:O000E0Il00`0009l0W`0E09l03000
21l47`PO11l87`@O21l47`PO11l87`Aoo`8001=oo`002goo00<007ooOol017oo00<007ooOol00Woo
00d7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000H0n@0;0000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
00020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0<@>O0gl3O`=o0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`0001L0W`0<00047`PO11l87`@O21l47`PO11l87`@O1Goo00<007ooOol04Goo000<Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool03@_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00001P3i0030003k0?/
0183k0050003l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00L3m0?c0o<3l`?d0o<0000G0o/00`00
0gl3O`0E0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O0082O`030001W`6O
01<1W`030000W`2O01D0W`0<00087`@O21l47`PO11l87`@O21l47`PO1Goo00<007ooOol04Goo0008
Ool01@00Oomoogoo00001Goo00<007ooOol00Woo00d7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000H
0n@0;@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k
0o/3n`?l00<3n`050o`3n`?k0003W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0_
0il3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000H09l02`0021l47`PO11l87`@O21l47`PO
11l01Goo00<007ooOol04Goo0009Ool30006Ool00`00Oomoo`02Ool03@_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h00001P3i0030003k0?/0183k0030003l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3
l`?c0o@00`?c00<000?k0o/05@?k00<000=o0gl050=o00<000:O0Wl00P9o00D2W`9o0Wl2O`:O00<2
O`050Yl2O`9o0Wl2W`030Wl00`:O0001W`0D0Il00`0009l0W`0F09l02`0011l87`@O21l47`PO11l8
7`@O21l01Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool030OP2n07h0_P1n0;h0OP2n07h0_P
1n0001T3i00_0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0030o/01@?l0o/3n`?k0o`0
0`?k00D3o0?k0o/3n`?l00<3n`050o`000=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3
O`>O00<3O`0]0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0001P0W`0;00087`@O21l47`PO11l8
7`@O21l47`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`0<2n07h0_P1n0;h0OP2n07h0_P
1n0;h0006@?T00<000?/0n`04`?/00@000?c0o<3m0<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c
0o@00P?c00<000?k0o/050?k00<000=o0gl050=o00@0009o0Wl2W`<2O`050Yl2O`9o0Wl2W`030Wl0
1`:O0Wl2O`9o0Yl2O`0001H1W`030000W`2O01H0W`0;00047`PO11l87`@O21l47`PO11l87`05Ool0
0`00Oomoo`0AOol0019oo`8000=oo`0<1n0;h0OP2n07h0_P1n0;h0OP2n07h0006@?T02d000?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c00000`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`000il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0;`>O0002W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00006@2O00X000@O21l47`PO11l87`@O21l47`Eoo`03001oogoo
015oo`004Woo00<007ooOol00Woo00`;h0OP2n07h0_P1n0;h0OP2n07h0_P000I0n@00`000n`3k00C
0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030o@000?k01D3n`03
0003O`=o01<3O`030002O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<0006O
0Il0506O00<0002O09l05`2O00X000PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo
00<007ooOol00Woo00`7h0_P1n0;h0OP2n07h0_P1n0;h0OP000I0n@0;`000n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<000?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0003
O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl0;P000Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`006@2O00X000@O21l47`PO11l87`@O21l47`Eoo`03001oogoo015oo`004Woo
00<007ooOol00Woo00`;h0OP2n07h0_P1n0;h0OP2n07h0_P000I0n@00`000n`3k00C0n`010000o<3
l`?d0`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<00`000o/3n`0D0o/00`000gl3O`0C
0gl01@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`070Yl2O`9o0Wl2W`9o00005P6O00<0002O
09l05`2O00X000PO11l87`@O21l47`PO11l87`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo
00/7h0_P1n0;h0OP2n07h0_P1n0;h00001X3i00]0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`00
00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o
0gl3W`030gl01@>O0gl3O`=o0il00`=o02l3W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`00
01X0W`0900087`@O21l47`PO11l87`@O00Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00/;
h0OP2n07h0_P1n0;h0OP2n07h00001X3i0030003k0?/01<3k0030003m0?c0083l`050o@3l`?c0o<3
m0030o<01@?d0o<3l`?c0o@00`?c00<3m0000o/05@?k00<000=o0gl04`=o00<0009o0Yl00`9o00D2
W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`000Il1W`0D0Il00`0009l0W`0H09l02@0011l8
7`@O21l47`PO11l87`05Ool00`00Oomoo`0AOol0019oo`8000=oo`0;1n0;h0OP2n07h0_P1n0;h0OP
2n00000I0n@0<0000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0<3n`050o`3n`?k0o/3
o0030o/01@?l0o/3n`?k0o`00`?k00D3o0000gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3
O`=o0il00P=o02l000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0001T0W`0900087`@O21l4
7`PO11l87`@O00Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00/;h0OP2n07h0_P1n0;h0OP
2n07h00001T3i0030003k0?/01@3k0040003l`?c0o@30o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3
l`?d0083l`030003n`?k01@3n`030003O`=o01<3O`050002O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl0
0`9o00L2W`9o0Wl2O`:O0Wl0000G0Il00`0009l0W`0G09l02@0011l87`@O21l47`PO11l87`05Ool0
0`00Oomoo`0AOol0019oo`03001oogoo009oo`0:1n0;h0OP2n07h0_P1n0;h0OP000J0n@0;P000n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o003
0o/01@?l0o/3n`000il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl0<0>O0002W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il001X0W`0800047`PO11l87`@O21l47`Eoo`03001oogoo
015oo`004Woo00<007ooOol00Woo00X;h0OP2n07h0_P1n0;h0OP2n0001X3i0030003k0?/01@3k003
0003m0?c0083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0000o/05@?k00<000=o
0gl04`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`000Il1W`0E
0Il00`0009l0W`0H09l0200021l47`PO11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo
009oo`0:1n0;h0OP2n07h0_P1n0;h0OP000J0n@0<0000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`000o/3o0<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0000gl3O`>O00<3O`05
0il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00P=o02l000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`0001X0W`0800047`PO11l87`@O21l47`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo
00X;h0OP2n07h0_P1n0;h0OP2n0001X3i0030003k0?/01@3k0040003l`?c0o@30o<01@?d0o<3l`?c
0o@00`?c00D3m0?c0o<3l`?d0083l`030003n`?k01@3n`030003O`=o01<3O`050002O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00L2W`9o0Wl2O`:O0Wl0000G0Il00`0009l0W`0H09l0200021l47`PO
11l87`@O21l5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`091n0;h0OP2n07h0_P1n0;h000
01/3i00^0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c00030o/01@?l0o/3n`?k0o`00`?k00D3
o0?k0o/3n`?l00<3n`050o`3n`?k0003W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`0`0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`006P2O00P000@O21l47`PO11l87`@O
1Goo00<007ooOol04Goo000BOol20003Ool02@_P1n0;h0OP2n07h0_P1n00000K0n@00`000n`3k00D
0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030o@000?k01D3n`03
0003O`=o01<3O`030002O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<0006O
0Il05@6O00<0002O09l06@2O00L000@O21l47`PO11l87`05Ool00`00Oomoo`0AOol0019oo`03001o
ogoo009oo`091n0;h0OP2n07h0_P1n0;h00001X3i00a0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<000?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0003O`=o0il0
0`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl0<0000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl001X0W`0700087`@O21l47`PO11l01Goo00<007ooOol04Goo000BOol00`00Oomo
o`02Ool020_P1n0;h0OP2n07h0_P000K0n@00`000n`3k00E0n`010000o<3l`?d0`?c00D3m0?c0o<3
l`?d00<3l`050o@3l`?c0o<3m0020o<00`000o/3n`0D0o/00`000gl3O`0C0gl01@000Wl2O`9o0Yl0
0`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`020Wl00`000Il1W`0E0Il00`0009l0W`0H09l0
1`0011l87`@O21l47`PO00Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00P7h0_P1n0;h0OP
2n07h0006`?T02l000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0
00?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`0000<3n`050o`3n`?k0o/3
o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3
O`=o0il00`=o0343W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0
005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000J09l01`0021l4
7`PO11l87`@O00Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00P;h0OP2n07h0_P1n0;h000
6`?T00<000?/0n`05@?/00<000?d0o<00P?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<0
0`?d0003n`0E0o/00`000gl3O`0C0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`:O00<2O`030Yl0006O01H1W`030000W`2O01T0W`0600087`@O21l47`PO1Goo00<007ooOol04Goo
000BOol00`00Oomoo`02Ool01`OP2n07h0_P1n0;h00001`3i00a0003j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<000?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0003
O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl0<0000Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl001/0W`0600047`PO11l87`@O1Goo00<007ooOol04Goo000BOol00`00
Oomoo`02Ool01`_P1n0;h0OP2n07h00001`3i0030003k0?/01D3k0040003l`?c0o@30o<01@?d0o<3
l`?c0o@00`?c00D3m0?c0o<3l`?d0083l`030003n`?k01@3n`030003O`=o01<3O`050002O`9o0Wl2
W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O0082O`030001W`6O01D1W`030000W`2O01T0
W`0600087`@O21l47`PO1Goo00<007ooOol04Goo000BOol20003Ool01`OP2n07h0_P1n0;h00001`3
i00_0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000030o/01@?l0o/3n`?k0o`00`?k00D3
o0?k0o/3n`?l00<3n`050o`3n`?k0003W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`0a0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00006`2O00H000@O21l47`PO11l5
Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`072n07h0_P1n0;h0OP000070?T00<000?/0n`0
5@?/00<000?d0o<00P?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<00`?d0003n`0E0o/0
0`000gl3O`0C0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl0
006O01H1W`030000W`2O01X0W`0500047`PO11l87`05Ool00`00Oomoo`0AOol0019oo`03001oogoo
009oo`061n0;h0OP2n07h00070?T038000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0003
n`?l0`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0003O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`020gl0<0000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl001`0W`0500087`@O21l47`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`062n07h0_P
1n0;h00070?T00<000?/0n`05P?/00@000?c0o<3m0<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c
0o@00P?c00<000?k0o/050?k00<000=o0gl04`=o00D0009o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00P9o00<0006O0Il05@6O00<0002O09l06P2O00D000@O21l47`PO00Eoo`03
001oogoo015oo`002Goo0`001Woo00<007ooOol00Woo00H7h0_P1n0;h0OP000L0n@0<0000n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`0
0`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o0383W`000Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00702O00@000@O21l47`Eoo`03001oogoo015o
o`0027oo00D007ooOomoo`0000Eoo`03001oogoo009oo`062n07h0_P1n0;h00070?T00<000?/0n`0
5@?/00<000?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<00`?d0003n`0E0o/0
0`000gl3O`0C0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl0
006O01L1W`030000W`2O01X0W`0400087`@O21l5Ool00`00Oomoo`0AOol000aoo`03001oogoo00=o
o`03001oogoo009oo`051n0;h0OP2n00000L0n@0<`000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`000o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`000=o0gl3
W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0a0002W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O00007@2O00<000PO11l01Goo00<007ooOol04Goo000<Ool00`00Oomoo`03
Ool20003Ool01@_P1n0;h0OP000070?T00<000?/0n`05P?/00D000?c0o<3l`?d00<3l`050o@3l`?c
0o<3m0030o<01@?d0o<3l`?c0o@00P?c00<000?k0o/050?k00<000=o0gl04`=o00D0009o0Wl2O`:O
00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00P9o00<0006O0Il05P6O00<0002O09l06`2O
00<000@O21l017oo0P004goo000:Ool20006Ool00`00Oomoo`1ZOol00`00Oomoo`1YOol00`00Oomo
o`0AOol000aoo`03001oogoo00=oo`03001oogoo06Yoo`03001oogoo06Uoo`03001oogoo015oo`00
27oo00D007ooOomoo`0000Eoo`03001oogoo06Yoo`03001oogoo06Uoo`03001oogoo015oo`002Goo
0`001Woo00<007ooOol00Woo00<007ooOol087oo00<007ooOol07goo00<007ooOol087oo00<007oo
Ool07goo00<007ooOol087oo00<007ooOol07goo00<007ooOol00Woo00<007ooOol04Goo000BOooJ
000COol00?moo`00ogoo003oOol00?moo`00ogoo003oOol00?moo`00ogoo003oOol007eoo`<007mo
o`00Ogoo00<007ooOol0OGoo001oOol00`00Oomoo`1mOol007ioo`03001oo`0007ioo`00OWoo00<0
07oo0000OWoo001mOol01@00Oomoogoo0000OGoo001mOol01@00Oomoogoo0000OGoo001lOol30000
17oo00000000O7oo003oOol00?moo`00ogoo003oOol00?moo`00ogoo003oOol00001\
\>"],
  ImageRangeCache->{{{0, 254.625}, {255.375, 0}} -> {-3.68919, -3.55506, \
0.0362525, 0.0362525}}]
}, Open  ]],

Cell["\<\
The related representation of the angular part of the velocity \
field is given by\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(u2 = uth[r, \[Theta], 1, 1] /. coordTrafo\)], "Input"],

Cell[BoxData[
    \(\(-\(\(\((\(-3\) - 1\/\(x\^2 + y\^2\) + 4\ \@\(x\^2 + y\^2\))\)\ 
            Sin[ArcTan[x, y]]\)\/\(4\ \@\(x\^2 + y\^2\)\)\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The graphical illustration of the angular component ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\[Theta]\)]],
  " is "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[{
        ContourPlot[
          If[x == 0 && y == 0, 0, u2], {x, \(-3\), 3}, {y, \(-3\), 3}, 
          PlotPoints \[Rule] 35, ColorFunction \[Rule] Hue, 
          AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True, 
          Contours \[Rule] 25, DisplayFunction \[Rule] Identity], 
        Graphics[Disk[{0, 0}, 1.1]]}, AspectRatio \[Rule] Automatic, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input",
  PageBreakWithin->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.18254 -0.0125 -6 -9 ]
[.18254 -0.0125 6 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -12 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .18254 -12 -4.5 ]
[-0.0125 .18254 0 4.5 ]
[-0.0125 .34127 -12 -4.5 ]
[-0.0125 .34127 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .65873 -6 -4.5 ]
[-0.0125 .65873 0 4.5 ]
[-0.0125 .81746 -6 -4.5 ]
[-0.0125 .81746 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 .5 0 -7.5 ]
[1.025 .5 10 7.5 ]
[.5 1.025 -5 0 ]
[.5 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(-3)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(-2)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(-1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(1)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(-3)] -0.0125 .02381 1 0 Mshowa
0 .18254 m
.00625 .18254 L
s
[(-2)] -0.0125 .18254 1 0 Mshowa
0 .34127 m
.00625 .34127 L
s
[(-1)] -0.0125 .34127 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .65873 m
.00625 .65873 L
s
[(1)] -0.0125 .65873 1 0 Mshowa
0 .81746 m
.00625 .81746 L
s
[(2)] -0.0125 .81746 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(3)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .05556 m
.00375 .05556 L
s
0 .0873 m
.00375 .0873 L
s
0 .11905 m
.00375 .11905 L
s
0 .15079 m
.00375 .15079 L
s
0 .21429 m
.00375 .21429 L
s
0 .24603 m
.00375 .24603 L
s
0 .27778 m
.00375 .27778 L
s
0 .30952 m
.00375 .30952 L
s
0 .37302 m
.00375 .37302 L
s
0 .40476 m
.00375 .40476 L
s
0 .43651 m
.00375 .43651 L
s
0 .46825 m
.00375 .46825 L
s
0 .53175 m
.00375 .53175 L
s
0 .56349 m
.00375 .56349 L
s
0 .59524 m
.00375 .59524 L
s
0 .62698 m
.00375 .62698 L
s
0 .69048 m
.00375 .69048 L
s
0 .72222 m
.00375 .72222 L
s
0 .75397 m
.00375 .75397 L
s
0 .78571 m
.00375 .78571 L
s
0 .84921 m
.00375 .84921 L
s
0 .88095 m
.00375 .88095 L
s
0 .9127 m
.00375 .9127 L
s
0 .94444 m
.00375 .94444 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.18254 .99375 m
.18254 1 L
s
.34127 .99375 m
.34127 1 L
s
.5 .99375 m
.5 1 L
s
.65873 .99375 m
.65873 1 L
s
.81746 .99375 m
.81746 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.05556 .99625 m
.05556 1 L
s
.0873 .99625 m
.0873 1 L
s
.11905 .99625 m
.11905 1 L
s
.15079 .99625 m
.15079 1 L
s
.21429 .99625 m
.21429 1 L
s
.24603 .99625 m
.24603 1 L
s
.27778 .99625 m
.27778 1 L
s
.30952 .99625 m
.30952 1 L
s
.37302 .99625 m
.37302 1 L
s
.40476 .99625 m
.40476 1 L
s
.43651 .99625 m
.43651 1 L
s
.46825 .99625 m
.46825 1 L
s
.53175 .99625 m
.53175 1 L
s
.56349 .99625 m
.56349 1 L
s
.59524 .99625 m
.59524 1 L
s
.62698 .99625 m
.62698 1 L
s
.69048 .99625 m
.69048 1 L
s
.72222 .99625 m
.72222 1 L
s
.75397 .99625 m
.75397 1 L
s
.78571 .99625 m
.78571 1 L
s
.84921 .99625 m
.84921 1 L
s
.88095 .99625 m
.88095 1 L
s
.9127 .99625 m
.9127 1 L
s
.94444 .99625 m
.94444 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .18254 m
1 .18254 L
s
.99375 .34127 m
1 .34127 L
s
.99375 .5 m
1 .5 L
s
.99375 .65873 m
1 .65873 L
s
.99375 .81746 m
1 .81746 L
s
.99375 .97619 m
1 .97619 L
s
.125 Mabswid
.99625 .05556 m
1 .05556 L
s
.99625 .0873 m
1 .0873 L
s
.99625 .11905 m
1 .11905 L
s
.99625 .15079 m
1 .15079 L
s
.99625 .21429 m
1 .21429 L
s
.99625 .24603 m
1 .24603 L
s
.99625 .27778 m
1 .27778 L
s
.99625 .30952 m
1 .30952 L
s
.99625 .37302 m
1 .37302 L
s
.99625 .40476 m
1 .40476 L
s
.99625 .43651 m
1 .43651 L
s
.99625 .46825 m
1 .46825 L
s
.99625 .53175 m
1 .53175 L
s
.99625 .56349 m
1 .56349 L
s
.99625 .59524 m
1 .59524 L
s
.99625 .62698 m
1 .62698 L
s
.99625 .69048 m
1 .69048 L
s
.99625 .72222 m
1 .72222 L
s
.99625 .75397 m
1 .75397 L
s
.99625 .78571 m
1 .78571 L
s
.99625 .84921 m
1 .84921 L
s
.99625 .88095 m
1 .88095 L
s
.99625 .9127 m
1 .9127 L
s
.99625 .94444 m
1 .94444 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.5 0 m
.5 1 L
s
gsave
.5 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .16 1 r
.02381 .97619 m
.97619 .97619 L
.97619 .02381 L
.02381 .02381 L
F
0 .4 1 r
.02381 .08384 m
.05182 .09917 L
.06794 .10784 L
.07983 .11416 L
.10784 .12873 L
.1219 .13585 L
.13585 .14278 L
.16387 .15619 L
.18069 .16387 L
.19188 .16879 L
.21989 .1804 L
.2479 .19078 L
.25108 .19188 L
.27591 .19971 L
.30392 .20693 L
.33193 .21233 L
.35994 .21592 L
.38796 .21794 L
.41597 .21881 L
.44398 .21899 L
.47199 .21891 L
.5 .21885 L
.52801 .21891 L
.55602 .21899 L
.58403 .21881 L
.61204 .21794 L
.64006 .21592 L
.66807 .21233 L
.69608 .20693 L
.72409 .19971 L
.74892 .19188 L
.7521 .19078 L
.78011 .1804 L
.80812 .16879 L
.81931 .16387 L
.83613 .15619 L
.86415 .14278 L
.8781 .13585 L
.89216 .12873 L
.92017 .11416 L
.93206 .10784 L
.94818 .09917 L
.97619 .08384 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.5 Mabswid
.02381 .08384 m
.05182 .09917 L
.06794 .10784 L
.07983 .11416 L
.10784 .12873 L
.1219 .13585 L
.13585 .14278 L
.16387 .15619 L
.18069 .16387 L
.19188 .16879 L
.21989 .1804 L
.2479 .19078 L
.25108 .19188 L
.27591 .19971 L
.30392 .20693 L
.33193 .21233 L
.35994 .21592 L
.38796 .21794 L
.41597 .21881 L
.44398 .21899 L
.47199 .21891 L
.5 .21885 L
.52801 .21891 L
.55602 .21899 L
.58403 .21881 L
.61204 .21794 L
.64006 .21592 L
.66807 .21233 L
.69608 .20693 L
.72409 .19971 L
.74892 .19188 L
.7521 .19078 L
.78011 .1804 L
.80812 .16879 L
.81931 .16387 L
.83613 .15619 L
.86415 .14278 L
.8781 .13585 L
.89216 .12873 L
.92017 .11416 L
.93206 .10784 L
.94818 .09917 L
.97619 .08384 L
s
0 .64 1 r
.02381 .25373 m
.05182 .26279 L
.07983 .27156 L
.09414 .27591 L
.10784 .27997 L
.13585 .28791 L
.16387 .29522 L
.19188 .30168 L
.20268 .30392 L
.21989 .30701 L
.2479 .3108 L
.27591 .31258 L
.30392 .31194 L
.33193 .30877 L
.35893 .30392 L
.35994 .3036 L
.38796 .2975 L
.41597 .29163 L
.44398 .28691 L
.47199 .28388 L
.5 .28284 L
.52801 .28388 L
.55602 .28691 L
.58403 .29163 L
.61204 .2975 L
.64006 .3036 L
.64107 .30392 L
.66807 .30877 L
.69608 .31194 L
.72409 .31258 L
.7521 .3108 L
.78011 .30701 L
.79732 .30392 L
.80812 .30168 L
.83613 .29522 L
.86415 .28791 L
.89216 .27997 L
.90586 .27591 L
.92017 .27156 L
.94818 .26279 L
.97619 .25373 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .25373 m
.05182 .26279 L
.07983 .27156 L
.09414 .27591 L
.10784 .27997 L
.13585 .28791 L
.16387 .29522 L
.19188 .30168 L
.20268 .30392 L
.21989 .30701 L
.2479 .3108 L
.27591 .31258 L
.30392 .31194 L
.33193 .30877 L
.35893 .30392 L
.35994 .3036 L
.38796 .2975 L
.41597 .29163 L
.44398 .28691 L
.47199 .28388 L
.5 .28284 L
.52801 .28388 L
.55602 .28691 L
.58403 .29163 L
.61204 .2975 L
.64006 .3036 L
.64107 .30392 L
.66807 .30877 L
.69608 .31194 L
.72409 .31258 L
.7521 .3108 L
.78011 .30701 L
.79732 .30392 L
.80812 .30168 L
.83613 .29522 L
.86415 .28791 L
.89216 .27997 L
.90586 .27591 L
.92017 .27156 L
.94818 .26279 L
.97619 .25373 L
s
0 .88 1 r
.02381 .38399 m
.05013 .38796 L
.05182 .38821 L
.07983 .39225 L
.10784 .39606 L
.13585 .39954 L
.16387 .40258 L
.19188 .40493 L
.21989 .40623 L
.2479 .40583 L
.27591 .40255 L
.30392 .39466 L
.32094 .38796 L
.33193 .38114 L
.35994 .36428 L
.36753 .35994 L
.38796 .3482 L
.41597 .33516 L
.42425 .33193 L
.44398 .3259 L
.47199 .32044 L
.5 .31862 L
.52801 .32044 L
.55602 .3259 L
.57575 .33193 L
.58403 .33516 L
.61204 .3482 L
.63247 .35994 L
.64006 .36428 L
.66807 .38114 L
.67906 .38796 L
.69608 .39466 L
.72409 .40255 L
.7521 .40583 L
.78011 .40623 L
.80812 .40493 L
.83613 .40258 L
.86415 .39954 L
.89216 .39606 L
.92017 .39225 L
.94818 .38821 L
.94987 .38796 L
.97619 .38399 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .38399 m
.05013 .38796 L
.05182 .38821 L
.07983 .39225 L
.10784 .39606 L
.13585 .39954 L
.16387 .40258 L
.19188 .40493 L
.21989 .40623 L
.2479 .40583 L
.27591 .40255 L
.30392 .39466 L
.32094 .38796 L
.33193 .38114 L
.35994 .36428 L
.36753 .35994 L
.38796 .3482 L
.41597 .33516 L
.42425 .33193 L
.44398 .3259 L
.47199 .32044 L
.5 .31862 L
.52801 .32044 L
.55602 .3259 L
.57575 .33193 L
.58403 .33516 L
.61204 .3482 L
.63247 .35994 L
.64006 .36428 L
.66807 .38114 L
.67906 .38796 L
.69608 .39466 L
.72409 .40255 L
.7521 .40583 L
.78011 .40623 L
.80812 .40493 L
.83613 .40258 L
.86415 .39954 L
.89216 .39606 L
.92017 .39225 L
.94818 .38821 L
.94987 .38796 L
.97619 .38399 L
s
0 1 .88 r
.02381 .5 m
.05182 .5 L
.07983 .5 L
.10784 .5 L
.13585 .5 L
.16387 .5 L
.19188 .5 L
.21989 .5 L
.2479 .5 L
.27591 .5 L
.30392 .5 L
.32983 .5 L
.33193 .5 L
.34452 .47199 L
.35324 .44398 L
.35994 .42542 L
.36591 .41597 L
.38762 .38796 L
.38796 .38756 L
.41597 .36538 L
.42526 .35994 L
.44398 .35164 L
.47199 .34403 L
.5 .34154 L
.52801 .34403 L
.55602 .35164 L
.57474 .35994 L
.58403 .36538 L
.61204 .38756 L
.61238 .38796 L
.63409 .41597 L
.64006 .42542 L
.64676 .44398 L
.65548 .47199 L
.66807 .5 L
.67166 .5 L
.69608 .5 L
.72409 .5 L
.7521 .5 L
.78011 .5 L
.80812 .5 L
.83613 .5 L
.86415 .5 L
.89216 .5 L
.92017 .5 L
.94818 .5 L
.97619 .5 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .5 m
.05182 .5 L
.07983 .5 L
.10784 .5 L
.13585 .5 L
.16387 .5 L
.19188 .5 L
.21989 .5 L
.2479 .5 L
.27591 .5 L
.30392 .5 L
.32983 .5 L
.33193 .5 L
.34452 .47199 L
.35324 .44398 L
.35994 .42542 L
.36591 .41597 L
.38762 .38796 L
.38796 .38756 L
.41597 .36538 L
.42526 .35994 L
.44398 .35164 L
.47199 .34403 L
.5 .34154 L
.52801 .34403 L
.55602 .35164 L
.57474 .35994 L
.58403 .36538 L
.61204 .38756 L
.61238 .38796 L
.63409 .41597 L
.64006 .42542 L
.64676 .44398 L
.65548 .47199 L
.66807 .5 L
.67166 .5 L
.69608 .5 L
.72409 .5 L
.7521 .5 L
.78011 .5 L
.80812 .5 L
.83613 .5 L
.86415 .5 L
.89216 .5 L
.92017 .5 L
.94818 .5 L
.97619 .5 L
s
0 1 .64 r
.02381 .61601 m
.05013 .61204 L
.05182 .61179 L
.07983 .60775 L
.10784 .60394 L
.13585 .60046 L
.16387 .59742 L
.19188 .59507 L
.21989 .59377 L
.2479 .59417 L
.27591 .59745 L
.30392 .60534 L
.32094 .61204 L
.33193 .61886 L
.35994 .63572 L
.36753 .64006 L
.38796 .6518 L
.41597 .66484 L
.42425 .66807 L
.44398 .6741 L
.47199 .67956 L
.5 .68138 L
.52801 .67956 L
.55602 .6741 L
.57575 .66807 L
.58403 .66484 L
.61204 .6518 L
.63247 .64006 L
.64006 .63572 L
.66807 .61886 L
.67906 .61204 L
.69608 .60534 L
.72409 .59745 L
.7521 .59417 L
.78011 .59377 L
.80812 .59507 L
.83613 .59742 L
.86415 .60046 L
.89216 .60394 L
.92017 .60775 L
.94818 .61179 L
.94987 .61204 L
.97619 .61601 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .61601 m
.05013 .61204 L
.05182 .61179 L
.07983 .60775 L
.10784 .60394 L
.13585 .60046 L
.16387 .59742 L
.19188 .59507 L
.21989 .59377 L
.2479 .59417 L
.27591 .59745 L
.30392 .60534 L
.32094 .61204 L
.33193 .61886 L
.35994 .63572 L
.36753 .64006 L
.38796 .6518 L
.41597 .66484 L
.42425 .66807 L
.44398 .6741 L
.47199 .67956 L
.5 .68138 L
.52801 .67956 L
.55602 .6741 L
.57575 .66807 L
.58403 .66484 L
.61204 .6518 L
.63247 .64006 L
.64006 .63572 L
.66807 .61886 L
.67906 .61204 L
.69608 .60534 L
.72409 .59745 L
.7521 .59417 L
.78011 .59377 L
.80812 .59507 L
.83613 .59742 L
.86415 .60046 L
.89216 .60394 L
.92017 .60775 L
.94818 .61179 L
.94987 .61204 L
.97619 .61601 L
s
0 1 .4 r
.02381 .74627 m
.05182 .73721 L
.07983 .72844 L
.09414 .72409 L
.10784 .72003 L
.13585 .71209 L
.16387 .70478 L
.19188 .69832 L
.20268 .69608 L
.21989 .69299 L
.2479 .6892 L
.27591 .68742 L
.30392 .68806 L
.33193 .69123 L
.35893 .69608 L
.35994 .6964 L
.38796 .7025 L
.41597 .70837 L
.44398 .71309 L
.47199 .71612 L
.5 .71716 L
.52801 .71612 L
.55602 .71309 L
.58403 .70837 L
.61204 .7025 L
.64006 .6964 L
.64107 .69608 L
.66807 .69123 L
.69608 .68806 L
.72409 .68742 L
.7521 .6892 L
.78011 .69299 L
.79732 .69608 L
.80812 .69832 L
.83613 .70478 L
.86415 .71209 L
.89216 .72003 L
.90586 .72409 L
.92017 .72844 L
.94818 .73721 L
.97619 .74627 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .74627 m
.05182 .73721 L
.07983 .72844 L
.09414 .72409 L
.10784 .72003 L
.13585 .71209 L
.16387 .70478 L
.19188 .69832 L
.20268 .69608 L
.21989 .69299 L
.2479 .6892 L
.27591 .68742 L
.30392 .68806 L
.33193 .69123 L
.35893 .69608 L
.35994 .6964 L
.38796 .7025 L
.41597 .70837 L
.44398 .71309 L
.47199 .71612 L
.5 .71716 L
.52801 .71612 L
.55602 .71309 L
.58403 .70837 L
.61204 .7025 L
.64006 .6964 L
.64107 .69608 L
.66807 .69123 L
.69608 .68806 L
.72409 .68742 L
.7521 .6892 L
.78011 .69299 L
.79732 .69608 L
.80812 .69832 L
.83613 .70478 L
.86415 .71209 L
.89216 .72003 L
.90586 .72409 L
.92017 .72844 L
.94818 .73721 L
.97619 .74627 L
s
0 1 .16 r
.02381 .91616 m
.05182 .90083 L
.06794 .89216 L
.07983 .88584 L
.10784 .87127 L
.1219 .86415 L
.13585 .85722 L
.16387 .84381 L
.18069 .83613 L
.19188 .83121 L
.21989 .8196 L
.2479 .80922 L
.25108 .80812 L
.27591 .80029 L
.30392 .79307 L
.33193 .78767 L
.35994 .78408 L
.38796 .78206 L
.41597 .78119 L
.44398 .78101 L
.47199 .78109 L
.5 .78115 L
.52801 .78109 L
.55602 .78101 L
.58403 .78119 L
.61204 .78206 L
.64006 .78408 L
.66807 .78767 L
.69608 .79307 L
.72409 .80029 L
.74892 .80812 L
.7521 .80922 L
.78011 .8196 L
.80812 .83121 L
.81931 .83613 L
.83613 .84381 L
.86415 .85722 L
.8781 .86415 L
.89216 .87127 L
.92017 .88584 L
.93206 .89216 L
.94818 .90083 L
.97619 .91616 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .91616 m
.05182 .90083 L
.06794 .89216 L
.07983 .88584 L
.10784 .87127 L
.1219 .86415 L
.13585 .85722 L
.16387 .84381 L
.18069 .83613 L
.19188 .83121 L
.21989 .8196 L
.2479 .80922 L
.25108 .80812 L
.27591 .80029 L
.30392 .79307 L
.33193 .78767 L
.35994 .78408 L
.38796 .78206 L
.41597 .78119 L
.44398 .78101 L
.47199 .78109 L
.5 .78115 L
.52801 .78109 L
.55602 .78101 L
.58403 .78119 L
.61204 .78206 L
.64006 .78408 L
.66807 .78767 L
.69608 .79307 L
.72409 .80029 L
.74892 .80812 L
.7521 .80922 L
.78011 .8196 L
.80812 .83121 L
.81931 .83613 L
.83613 .84381 L
.86415 .85722 L
.8781 .86415 L
.89216 .87127 L
.92017 .88584 L
.93206 .89216 L
.94818 .90083 L
.97619 .91616 L
s
.08 0 1 r
.68246 .02381 m
.66807 .03107 L
.64006 .04367 L
.61871 .05182 L
.61204 .05406 L
.58403 .06214 L
.55602 .06789 L
.52801 .07131 L
.5 .07244 L
.47199 .07131 L
.44398 .06789 L
.41597 .06214 L
.38796 .05406 L
.38129 .05182 L
.35994 .04367 L
.33193 .03107 L
.31754 .02381 L
F
0 g
.68246 .02381 m
.66807 .03107 L
.64006 .04367 L
.61871 .05182 L
.61204 .05406 L
.58403 .06214 L
.55602 .06789 L
.52801 .07131 L
.5 .07244 L
.47199 .07131 L
.44398 .06789 L
.41597 .06214 L
.38796 .05406 L
.38129 .05182 L
.35994 .04367 L
.33193 .03107 L
.31754 .02381 L
s
.08 1 0 r
.68246 .97619 m
.66807 .96893 L
.64006 .95633 L
.61871 .94818 L
.61204 .94594 L
.58403 .93786 L
.55602 .93211 L
.52801 .92869 L
.5 .92756 L
.47199 .92869 L
.44398 .93211 L
.41597 .93786 L
.38796 .94594 L
.38129 .94818 L
.35994 .95633 L
.33193 .96893 L
.31754 .97619 L
F
0 g
.68246 .97619 m
.66807 .96893 L
.64006 .95633 L
.61871 .94818 L
.61204 .94594 L
.58403 .93786 L
.55602 .93211 L
.52801 .92869 L
.5 .92756 L
.47199 .92869 L
.44398 .93211 L
.41597 .93786 L
.38796 .94594 L
.38129 .94818 L
.35994 .95633 L
.33193 .96893 L
.31754 .97619 L
s
0 .88 1 r
.35994 .5 m
.38796 .5 L
.41597 .5 L
.44398 .5 L
.47199 .5 L
.5 .52801 L
.52801 .5 L
.55602 .5 L
.58403 .5 L
.61204 .5 L
.64006 .5 L
.65548 .52801 L
.64676 .55602 L
.64006 .57458 L
.63409 .58403 L
.61238 .61204 L
.61204 .61244 L
.58403 .63462 L
.57474 .64006 L
.55602 .64836 L
.52801 .65597 L
.5 .65846 L
.47199 .65597 L
.44398 .64836 L
.42526 .64006 L
.41597 .63462 L
.38796 .61244 L
.38762 .61204 L
.36591 .58403 L
.35994 .57458 L
.35324 .55602 L
.34452 .52801 L
F
0 g
.35994 .5 m
.38796 .5 L
.41597 .5 L
.44398 .5 L
.47199 .5 L
.5 .52801 L
.52801 .5 L
.55602 .5 L
.58403 .5 L
.61204 .5 L
.64006 .5 L
.65548 .52801 L
.64676 .55602 L
.64006 .57458 L
.63409 .58403 L
.61238 .61204 L
.61204 .61244 L
.58403 .63462 L
.57474 .64006 L
.55602 .64836 L
.52801 .65597 L
.5 .65846 L
.47199 .65597 L
.44398 .64836 L
.42526 .64006 L
.41597 .63462 L
.38796 .61244 L
.38762 .61204 L
.36591 .58403 L
.35994 .57458 L
.35324 .55602 L
.34452 .52801 L
.35994 .5 L
s
0 1 .64 r
.5 .35738 m
.52646 .35994 L
.52801 .36028 L
.55602 .37018 L
.5832 .38796 L
.58403 .38866 L
.60529 .41597 L
.61204 .42996 L
.61405 .44398 L
.61204 .46829 L
.60906 .47199 L
.58403 .49223 L
.55602 .49814 L
.52801 .4997 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .4997 L
.44398 .49814 L
.41597 .49223 L
.39094 .47199 L
.38796 .46829 L
.38595 .44398 L
.38796 .42996 L
.39471 .41597 L
.41597 .38866 L
.4168 .38796 L
.44398 .37018 L
.47199 .36028 L
.47354 .35994 L
F
0 g
.5 .35738 m
.52646 .35994 L
.52801 .36028 L
.55602 .37018 L
.5832 .38796 L
.58403 .38866 L
.60529 .41597 L
.61204 .42996 L
.61405 .44398 L
.61204 .46829 L
.60906 .47199 L
.58403 .49223 L
.55602 .49814 L
.52801 .4997 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .4997 L
.44398 .49814 L
.41597 .49223 L
.39094 .47199 L
.38796 .46829 L
.38595 .44398 L
.38796 .42996 L
.39471 .41597 L
.41597 .38866 L
.4168 .38796 L
.44398 .37018 L
.47199 .36028 L
.47354 .35994 L
.5 .35738 L
s
0 .64 1 r
.41597 .50777 m
.44398 .50186 L
.47199 .5003 L
.5 .52801 L
.52801 .5003 L
.55602 .50186 L
.58403 .50777 L
.60906 .52801 L
.61204 .53171 L
.61405 .55602 L
.61204 .57004 L
.60529 .58403 L
.58403 .61134 L
.5832 .61204 L
.55602 .62982 L
.52801 .63972 L
.52646 .64006 L
.5 .64262 L
.47354 .64006 L
.47199 .63972 L
.44398 .62982 L
.4168 .61204 L
.41597 .61134 L
.39471 .58403 L
.38796 .57004 L
.38595 .55602 L
.38796 .53171 L
.39094 .52801 L
F
0 g
.41597 .50777 m
.44398 .50186 L
.47199 .5003 L
.5 .52801 L
.52801 .5003 L
.55602 .50186 L
.58403 .50777 L
.60906 .52801 L
.61204 .53171 L
.61405 .55602 L
.61204 .57004 L
.60529 .58403 L
.58403 .61134 L
.5832 .61204 L
.55602 .62982 L
.52801 .63972 L
.52646 .64006 L
.5 .64262 L
.47354 .64006 L
.47199 .63972 L
.44398 .62982 L
.4168 .61204 L
.41597 .61134 L
.39471 .58403 L
.38796 .57004 L
.38595 .55602 L
.38796 .53171 L
.39094 .52801 L
.41597 .50777 L
s
0 1 .4 r
.44398 .38426 m
.47199 .37316 L
.5 .36963 L
.52801 .37316 L
.55602 .38426 L
.56197 .38796 L
.58403 .40836 L
.58825 .41597 L
.5985 .44398 L
.59257 .47199 L
.58403 .48395 L
.55602 .49627 L
.52801 .49939 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49939 L
.44398 .49627 L
.41597 .48395 L
.40743 .47199 L
.4015 .44398 L
.41175 .41597 L
.41597 .40836 L
.43803 .38796 L
F
0 g
.44398 .38426 m
.47199 .37316 L
.5 .36963 L
.52801 .37316 L
.55602 .38426 L
.56197 .38796 L
.58403 .40836 L
.58825 .41597 L
.5985 .44398 L
.59257 .47199 L
.58403 .48395 L
.55602 .49627 L
.52801 .49939 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49939 L
.44398 .49627 L
.41597 .48395 L
.40743 .47199 L
.4015 .44398 L
.41175 .41597 L
.41597 .40836 L
.43803 .38796 L
.44398 .38426 L
s
0 .4 1 r
.41597 .51605 m
.44398 .50373 L
.47199 .50061 L
.5 .52801 L
.52801 .50061 L
.55602 .50373 L
.58403 .51605 L
.59257 .52801 L
.5985 .55602 L
.58825 .58403 L
.58403 .59164 L
.56197 .61204 L
.55602 .61574 L
.52801 .62684 L
.5 .63037 L
.47199 .62684 L
.44398 .61574 L
.43803 .61204 L
.41597 .59164 L
.41175 .58403 L
.4015 .55602 L
.40743 .52801 L
F
0 g
.41597 .51605 m
.44398 .50373 L
.47199 .50061 L
.5 .52801 L
.52801 .50061 L
.55602 .50373 L
.58403 .51605 L
.59257 .52801 L
.5985 .55602 L
.58825 .58403 L
.58403 .59164 L
.56197 .61204 L
.55602 .61574 L
.52801 .62684 L
.5 .63037 L
.47199 .62684 L
.44398 .61574 L
.43803 .61204 L
.41597 .59164 L
.41175 .58403 L
.4015 .55602 L
.40743 .52801 L
.41597 .51605 L
s
0 .16 1 r
.41597 .52586 m
.44398 .50562 L
.47199 .50091 L
.5 .52801 L
.52801 .50091 L
.55602 .50562 L
.58403 .52586 L
.5851 .52801 L
.58856 .55602 L
.58403 .57229 L
.57639 .58403 L
.55602 .60429 L
.54576 .61204 L
.52801 .61729 L
.5 .62092 L
.47199 .61729 L
.45424 .61204 L
.44398 .60429 L
.42361 .58403 L
.41597 .57229 L
.41144 .55602 L
.4149 .52801 L
F
0 g
.41597 .52586 m
.44398 .50562 L
.47199 .50091 L
.5 .52801 L
.52801 .50091 L
.55602 .50562 L
.58403 .52586 L
.5851 .52801 L
.58856 .55602 L
.58403 .57229 L
.57639 .58403 L
.55602 .60429 L
.54576 .61204 L
.52801 .61729 L
.5 .62092 L
.47199 .61729 L
.45424 .61204 L
.44398 .60429 L
.42361 .58403 L
.41597 .57229 L
.41144 .55602 L
.4149 .52801 L
.41597 .52586 L
s
0 1 .16 r
.47199 .38271 m
.5 .37908 L
.52801 .38271 L
.54576 .38796 L
.55602 .39571 L
.57639 .41597 L
.58403 .42771 L
.58856 .44398 L
.5851 .47199 L
.58403 .47414 L
.55602 .49438 L
.52801 .49909 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49909 L
.44398 .49438 L
.41597 .47414 L
.4149 .47199 L
.41144 .44398 L
.41597 .42771 L
.42361 .41597 L
.44398 .39571 L
.45424 .38796 L
F
0 g
.47199 .38271 m
.5 .37908 L
.52801 .38271 L
.54576 .38796 L
.55602 .39571 L
.57639 .41597 L
.58403 .42771 L
.58856 .44398 L
.5851 .47199 L
.58403 .47414 L
.55602 .49438 L
.52801 .49909 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49909 L
.44398 .49438 L
.41597 .47414 L
.4149 .47199 L
.41144 .44398 L
.41597 .42771 L
.42361 .41597 L
.44398 .39571 L
.45424 .38796 L
.47199 .38271 L
s
.08 0 1 r
.44398 .50753 m
.47199 .50122 L
.5 .52801 L
.52801 .50122 L
.55602 .50753 L
.57113 .52801 L
.58113 .55602 L
.56641 .58403 L
.55602 .5947 L
.52801 .60983 L
.5202 .61204 L
.5 .61403 L
.4798 .61204 L
.47199 .60983 L
.44398 .5947 L
.43359 .58403 L
.41887 .55602 L
.42887 .52801 L
F
0 g
.44398 .50753 m
.47199 .50122 L
.5 .52801 L
.52801 .50122 L
.55602 .50753 L
.57113 .52801 L
.58113 .55602 L
.56641 .58403 L
.55602 .5947 L
.52801 .60983 L
.5202 .61204 L
.5 .61403 L
.4798 .61204 L
.47199 .60983 L
.44398 .5947 L
.43359 .58403 L
.41887 .55602 L
.42887 .52801 L
.44398 .50753 L
s
.08 1 0 r
.5 .38597 m
.5202 .38796 L
.52801 .39017 L
.55602 .4053 L
.56641 .41597 L
.58113 .44398 L
.57113 .47199 L
.55602 .49247 L
.52801 .49878 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49878 L
.44398 .49247 L
.42887 .47199 L
.41887 .44398 L
.43359 .41597 L
.44398 .4053 L
.47199 .39017 L
.4798 .38796 L
F
0 g
.5 .38597 m
.5202 .38796 L
.52801 .39017 L
.55602 .4053 L
.56641 .41597 L
.58113 .44398 L
.57113 .47199 L
.55602 .49247 L
.52801 .49878 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49878 L
.44398 .49247 L
.42887 .47199 L
.41887 .44398 L
.43359 .41597 L
.44398 .4053 L
.47199 .39017 L
.4798 .38796 L
.5 .38597 L
s
.32 0 1 r
.44398 .50949 m
.47199 .50152 L
.5 .52801 L
.52801 .50152 L
.55602 .50949 L
.56772 .52801 L
.57507 .55602 L
.55866 .58403 L
.55602 .5868 L
.52801 .60271 L
.5 .60675 L
.47199 .60271 L
.44398 .5868 L
.44134 .58403 L
.42493 .55602 L
.43228 .52801 L
F
0 g
.44398 .50949 m
.47199 .50152 L
.5 .52801 L
.52801 .50152 L
.55602 .50949 L
.56772 .52801 L
.57507 .55602 L
.55866 .58403 L
.55602 .5868 L
.52801 .60271 L
.5 .60675 L
.47199 .60271 L
.44398 .5868 L
.44134 .58403 L
.42493 .55602 L
.43228 .52801 L
.44398 .50949 L
s
.32 1 0 r
.44398 .4132 m
.47199 .39729 L
.5 .39325 L
.52801 .39729 L
.55602 .4132 L
.55866 .41597 L
.57507 .44398 L
.56772 .47199 L
.55602 .49051 L
.52801 .49848 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49848 L
.44398 .49051 L
.43228 .47199 L
.42493 .44398 L
.44134 .41597 L
F
0 g
.44398 .4132 m
.47199 .39729 L
.5 .39325 L
.52801 .39729 L
.55602 .4132 L
.55866 .41597 L
.57507 .44398 L
.56772 .47199 L
.55602 .49051 L
.52801 .49848 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49848 L
.44398 .49051 L
.43228 .47199 L
.42493 .44398 L
.44134 .41597 L
.44398 .4132 L
s
.56 0 1 r
.44398 .51149 m
.47199 .50183 L
.5 .52801 L
.52801 .50183 L
.55602 .51149 L
.56529 .52801 L
.57014 .55602 L
.55602 .58039 L
.55215 .58403 L
.52801 .59682 L
.5 .60092 L
.47199 .59682 L
.44785 .58403 L
.44398 .58039 L
.42986 .55602 L
.43471 .52801 L
F
0 g
.44398 .51149 m
.47199 .50183 L
.5 .52801 L
.52801 .50183 L
.55602 .51149 L
.56529 .52801 L
.57014 .55602 L
.55602 .58039 L
.55215 .58403 L
.52801 .59682 L
.5 .60092 L
.47199 .59682 L
.44785 .58403 L
.44398 .58039 L
.42986 .55602 L
.43471 .52801 L
.44398 .51149 L
s
.56 1 0 r
.47199 .40318 m
.5 .39908 L
.52801 .40318 L
.55215 .41597 L
.55602 .41961 L
.57014 .44398 L
.56529 .47199 L
.55602 .48851 L
.52801 .49817 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49817 L
.44398 .48851 L
.43471 .47199 L
.42986 .44398 L
.44398 .41961 L
.44785 .41597 L
F
0 g
.47199 .40318 m
.5 .39908 L
.52801 .40318 L
.55215 .41597 L
.55602 .41961 L
.57014 .44398 L
.56529 .47199 L
.55602 .48851 L
.52801 .49817 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49817 L
.44398 .48851 L
.43471 .47199 L
.42986 .44398 L
.44398 .41961 L
.44785 .41597 L
.47199 .40318 L
s
.8 0 1 r
.44398 .51356 m
.47199 .50213 L
.5 .52801 L
.52801 .50213 L
.55602 .51356 L
.56333 .52801 L
.56596 .55602 L
.55602 .57488 L
.54609 .58403 L
.52801 .59204 L
.5 .59667 L
.47199 .59204 L
.45391 .58403 L
.44398 .57488 L
.43404 .55602 L
.43667 .52801 L
F
0 g
.44398 .51356 m
.47199 .50213 L
.5 .52801 L
.52801 .50213 L
.55602 .51356 L
.56333 .52801 L
.56596 .55602 L
.55602 .57488 L
.54609 .58403 L
.52801 .59204 L
.5 .59667 L
.47199 .59204 L
.45391 .58403 L
.44398 .57488 L
.43404 .55602 L
.43667 .52801 L
.44398 .51356 L
s
.8 1 0 r
.47199 .40796 m
.5 .40333 L
.52801 .40796 L
.54609 .41597 L
.55602 .42512 L
.56596 .44398 L
.56333 .47199 L
.55602 .48644 L
.52801 .49787 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49787 L
.44398 .48644 L
.43667 .47199 L
.43404 .44398 L
.44398 .42512 L
.45391 .41597 L
F
0 g
.47199 .40796 m
.5 .40333 L
.52801 .40796 L
.54609 .41597 L
.55602 .42512 L
.56596 .44398 L
.56333 .47199 L
.55602 .48644 L
.52801 .49787 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49787 L
.44398 .48644 L
.43667 .47199 L
.43404 .44398 L
.44398 .42512 L
.45391 .41597 L
.47199 .40796 L
s
1 0 .96 r
.44398 .51571 m
.47199 .50244 L
.5 .52801 L
.52801 .50244 L
.55602 .51571 L
.56167 .52801 L
.56231 .55602 L
.55602 .56946 L
.53982 .58403 L
.52801 .58824 L
.5 .59327 L
.47199 .58824 L
.46018 .58403 L
.44398 .56946 L
.43769 .55602 L
.43833 .52801 L
F
0 g
.44398 .51571 m
.47199 .50244 L
.5 .52801 L
.52801 .50244 L
.55602 .51571 L
.56167 .52801 L
.56231 .55602 L
.55602 .56946 L
.53982 .58403 L
.52801 .58824 L
.5 .59327 L
.47199 .58824 L
.46018 .58403 L
.44398 .56946 L
.43769 .55602 L
.43833 .52801 L
.44398 .51571 L
s
1 .96 0 r
.47199 .41176 m
.5 .40673 L
.52801 .41176 L
.53982 .41597 L
.55602 .43054 L
.56231 .44398 L
.56167 .47199 L
.55602 .48429 L
.52801 .49756 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49756 L
.44398 .48429 L
.43833 .47199 L
.43769 .44398 L
.44398 .43054 L
.46018 .41597 L
F
0 g
.47199 .41176 m
.5 .40673 L
.52801 .41176 L
.53982 .41597 L
.55602 .43054 L
.56231 .44398 L
.56167 .47199 L
.55602 .48429 L
.52801 .49756 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49756 L
.44398 .48429 L
.43833 .47199 L
.43769 .44398 L
.44398 .43054 L
.46018 .41597 L
.47199 .41176 L
s
1 .72 0 r
.47199 .41469 m
.5 .40957 L
.52801 .41469 L
.5326 .41597 L
.55602 .43654 L
.55905 .44398 L
.56021 .47199 L
.55602 .48201 L
.52801 .49726 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49726 L
.44398 .48201 L
.43979 .47199 L
.44095 .44398 L
.44398 .43654 L
.4674 .41597 L
F
0 g
.47199 .41469 m
.5 .40957 L
.52801 .41469 L
.5326 .41597 L
.55602 .43654 L
.55905 .44398 L
.56021 .47199 L
.55602 .48201 L
.52801 .49726 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49726 L
.44398 .48201 L
.43979 .47199 L
.44095 .44398 L
.44398 .43654 L
.4674 .41597 L
.47199 .41469 L
s
1 0 .72 r
.44398 .51799 m
.47199 .50274 L
.5 .52801 L
.52801 .50274 L
.55602 .51799 L
.56021 .52801 L
.55905 .55602 L
.55602 .56346 L
.5326 .58403 L
.52801 .58531 L
.5 .59043 L
.47199 .58531 L
.4674 .58403 L
.44398 .56346 L
.44095 .55602 L
.43979 .52801 L
F
0 g
.44398 .51799 m
.47199 .50274 L
.5 .52801 L
.52801 .50274 L
.55602 .51799 L
.56021 .52801 L
.55905 .55602 L
.55602 .56346 L
.5326 .58403 L
.52801 .58531 L
.5 .59043 L
.47199 .58531 L
.4674 .58403 L
.44398 .56346 L
.44095 .55602 L
.43979 .52801 L
.44398 .51799 L
s
1 .48 0 r
.5 .41205 m
.52443 .41597 L
.52801 .4177 L
.55602 .44375 L
.5561 .44398 L
.55889 .47199 L
.55602 .47958 L
.52801 .49695 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49695 L
.44398 .47958 L
.44111 .47199 L
.4439 .44398 L
.44398 .44375 L
.47199 .4177 L
.47557 .41597 L
F
0 g
.5 .41205 m
.52443 .41597 L
.52801 .4177 L
.55602 .44375 L
.5561 .44398 L
.55889 .47199 L
.55602 .47958 L
.52801 .49695 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49695 L
.44398 .47958 L
.44111 .47199 L
.4439 .44398 L
.44398 .44375 L
.47199 .4177 L
.47557 .41597 L
.5 .41205 L
s
1 0 .48 r
.44398 .52042 m
.47199 .50305 L
.5 .52801 L
.52801 .50305 L
.55602 .52042 L
.55889 .52801 L
.5561 .55602 L
.55602 .55625 L
.52801 .5823 L
.52443 .58403 L
.5 .58795 L
.47557 .58403 L
.47199 .5823 L
.44398 .55625 L
.4439 .55602 L
.44111 .52801 L
F
0 g
.44398 .52042 m
.47199 .50305 L
.5 .52801 L
.52801 .50305 L
.55602 .52042 L
.55889 .52801 L
.5561 .55602 L
.55602 .55625 L
.52801 .5823 L
.52443 .58403 L
.5 .58795 L
.47557 .58403 L
.47199 .5823 L
.44398 .55625 L
.4439 .55602 L
.44111 .52801 L
.44398 .52042 L
s
1 .24 0 r
.5 .41425 m
.51519 .41597 L
.52801 .42104 L
.55299 .44398 L
.55602 .44895 L
.55769 .47199 L
.55602 .47691 L
.52801 .49664 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49664 L
.44398 .47691 L
.44231 .47199 L
.44398 .44895 L
.44701 .44398 L
.47199 .42104 L
.48481 .41597 L
F
0 g
.5 .41425 m
.51519 .41597 L
.52801 .42104 L
.55299 .44398 L
.55602 .44895 L
.55769 .47199 L
.55602 .47691 L
.52801 .49664 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49664 L
.44398 .47691 L
.44231 .47199 L
.44398 .44895 L
.44701 .44398 L
.47199 .42104 L
.48481 .41597 L
.5 .41425 L
s
1 0 .24 r
.44398 .52309 m
.47199 .50336 L
.5 .52801 L
.52801 .50336 L
.55602 .52309 L
.55769 .52801 L
.55602 .55105 L
.55299 .55602 L
.52801 .57896 L
.51519 .58403 L
.5 .58575 L
.48481 .58403 L
.47199 .57896 L
.44701 .55602 L
.44398 .55105 L
.44231 .52801 L
F
0 g
.44398 .52309 m
.47199 .50336 L
.5 .52801 L
.52801 .50336 L
.55602 .52309 L
.55769 .52801 L
.55602 .55105 L
.55299 .55602 L
.52801 .57896 L
.51519 .58403 L
.5 .58575 L
.48481 .58403 L
.47199 .57896 L
.44701 .55602 L
.44398 .55105 L
.44231 .52801 L
.44398 .52309 L
s
1 0 0 r
.47199 .42387 m
.5 .43148 L
.52801 .42387 L
.55013 .44398 L
.55602 .45509 L
.55659 .47199 L
.55602 .47388 L
.52801 .49634 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49634 L
.44398 .47388 L
.44341 .47199 L
.44398 .45509 L
.44987 .44398 L
F
0 g
.47199 .42387 m
.5 .43148 L
.52801 .42387 L
.55013 .44398 L
.55602 .45509 L
.55659 .47199 L
.55602 .47388 L
.52801 .49634 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49634 L
.44398 .47388 L
.44341 .47199 L
.44398 .45509 L
.44987 .44398 L
.47199 .42387 L
s
1 0 0 r
.44398 .52612 m
.47199 .50366 L
.5 .52801 L
.52801 .50366 L
.55602 .52612 L
.55659 .52801 L
.55602 .54491 L
.55013 .55602 L
.52801 .57613 L
.5 .56852 L
.47199 .57613 L
.44987 .55602 L
.44398 .54491 L
.44341 .52801 L
F
0 g
.44398 .52612 m
.47199 .50366 L
.5 .52801 L
.52801 .50366 L
.55602 .52612 L
.55659 .52801 L
.55602 .54491 L
.55013 .55602 L
.52801 .57613 L
.5 .56852 L
.47199 .57613 L
.44987 .55602 L
.44398 .54491 L
.44341 .52801 L
.44398 .52612 L
s
.5 .5 m
.5 .5 .1746 0 365.73 arc
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{196.25, 196.25},
  ImageMargins->{{64, 0}, {0, 3.25}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000mA000`40O003h00O6Goo0`007Goo1@00
7Goo1@0067oo100077oo1@006goo1@007Goo0`0067oo000HOol01@00Oomoogoo000077oo00D007oo
Oomoo`0001moo`03001oogoo01Moo`03001oogoo009oo`03001oogoo01]oo`03001oogoo01]oo`05
001oogooOol0000LOol01@00Oomoogoo00005goo000LOol00`00Oomoo`0KOol00`00Oomoo`0POol0
0`00Oomoo`0GOol00`00Oomoo`02Ool00`00Oomoo`0KOol00`00Oomoo`0LOol00`00Oomoo`0QOol0
0`00Oomoo`0EOol0011oo`H000Ioo`03001oogoo019oo`H000Aoo`03001oogoo01Aoo`H000Eoo`03
001oogoo01Moo`03001oogoo009oo`03001oogoo01]oo`03001oogoo01eoo`03001oogoo021oo`03
001oogoo01Eoo`006Woo0P0087oo00<007ooOol07Woo00<007ooOol05goo00<007ooOol00Woo00<0
07ooOol06goo00<007ooOol07Woo00<007ooOol07Goo0P0067oo000LOol00`00Oomoo`0NOol00`00
Oomoo`0MOol00`00Oomoo`0GOol00`00Oomoo`02Ool00`00Oomoo`0KOol00`00Oomoo`0OOol00`00
Oomoo`0NOol00`00Oomoo`0EOol001Qoo`05001oogooOol0000LOol01@00Oomoogoo00007Goo0`00
6Goo00<007ooOol00Woo00<007ooOol06Goo0`007Goo00D007ooOomoo`0001aoo`05001oogooOol0
000GOol001Uoo`<001ioo`<0021oo`03001oogoo01Qoo`@001ioo`03001oogoo01aoo`<001ioo`<0
01Qoo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`004Wood0004goo000BOol00`00Oomoo`02
Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04
Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04
Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03
Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04
Ool00`00Oomoo`02Ool00`00Oomoo`0AOol000Yoo`<000Eoo`03001oogoo06Eoo`03001oogoo06Ao
o`03001oogoo015oo`002Goo00D007ooOomoo`0000Aoo`03001oogoo06Eoo`03001oogoo06Aoo`03
001oogoo015oo`003Goo00<007ooOol00Woo00<007ooOol0IGoo00<007ooOol0I7oo00<007ooOol0
4Goo00000goo000000040006Ool00`00Oomoo`02Ool3000oOol2000TOol00`00Oomoo`0QOol20010
Ool2000COol000]oo`8000Eoo`03001oogoo009oocl0W`<0001311l87`@O21l47`PO11l87`@O21l4
7`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l4
7`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l00P00?P2O
1Goo00<007ooOol04Goo000=Ool00`00Oomoo`02Ool00`00Oomoo`02Oom209l20000?`PO11l87`@O
21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O
21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`02
001009l5Ool00`00Oomoo`0AOol000Uoo`05001oogooOol00004Ool00`00Oomoo`02Oom409l20000
>`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l8
7`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l0
0P00@P2O1Goo00<007ooOol04Goo000:Ool30005Ool00`00Oomoo`02Oom609l20000=`PO11l87`@O
21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O
21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO008004@0W`Eoo`03001oogoo
015oo`004Woo00<007ooOol00WooB02O0P0003<47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l8
7`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l8
7`@O21l47`PO11l00P00AP2O1Goo00<007ooOol04Goo000BOol20003Oom:09l30000;0@O21l47`PO
11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO
11l87`@O21l47`PO11l87`@O21l4001809l4Ool2000COol0019oo`03001oogoo009oodd0W`<0000V
11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO
11l87`@O21l47`PO11l87`<004`0W`Eoo`03001oogoo015oo`004Woo00<007ooOol00WooD02O1@00
01d47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O
00@004l0W`Eoo`03001oogoo015oo`004Woo00<007ooOol00WooE@2O1P0001487`@O21l47`PO11l8
7`@O21l47`PO11l87`@O21l47`PO00H005<0W`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo
F`2O4@00F@2O1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ooo509l5Ool00`00Oomoo`0AOol0
019oo`03001oogoo009oo`030000W`2O0<80W`03001oogoo009oo`03001oogoo015oo`004Woo0P00
0goo00<1O`000000`02O0P0017oo0P004goo000BOol00`00Oomoo`02Ool30Il00`0009l0W`2l09l0
0`000Il1W`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`040Gl1W`5o0Il2002j09l20000
0`5o0Il1O`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`H1W`800;H0W`8000D1W`Eoo`03
001oogoo015oo`004Woo00<007ooOol00Woo00P1O`6O0Gl1W`5o0Il1O`6O0P00/P2O0P0000L1O`6O
0Gl1W`5o0Il1O`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`X1W`800:h0W`8000T1W`Eo
o`03001oogoo015oo`004Woo00<007ooOol00Woo00d1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0002/
09l030000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`Eoo`03001oogoo015oo`004Woo0P000goo3@6O0P00
Z02O0P00306O17oo0P004goo000BOol00`00Oomoo`02Ool03`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`02002T09l200003P6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl5Ool00`00Oomoo`0A
Ool0019oo`03001oogoo009ooa41W`<009l0W`800101W`Eoo`03001oogoo015oo`004Woo00<007oo
Ool00Woo01@1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0P00V`2O0P000181
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl5Ool00`00Oomoo`0AOol0019oo`03001o
ogoo009ooaH1W`030000W`2O09H0W`8001@1W`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo
01L1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o008009@0W`80000F
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl5Ool00`00Oomoo`0AOol0
019oo`8000=ooaT1W`<008h0W`<001P1W`Aoo`8001=oo`004Woo00<007ooOol00Woo01`1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`8008X0W`80000K
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00Eoo`03
001oogoo015oo`004Woo00<007ooOol00Woo7P6O0P00QP2O0P007@6O1Goo00<007ooOol04Goo000B
Ool00`00Oomoo`02Ool0805o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il2002209l200007`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00Eoo`03001oogoo015oo`002Goo1@0017oo
00<007ooOol00Woo8P6O0`00O02O0`008@6O1Goo00<007ooOol04Goo0009Ool01@00Oomoogoo0000
17oo00<007ooOol00Woo02D1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`03001f09l30000906O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`Eoo`03
001oogoo015oo`002Woo00<007ooOol01Goo00<007ooOol00Woo:06O0`00L02O0`009`6O1Goo00<0
07ooOol04Goo00000goo000000040004Ool00`00Oomoo`04Ool30002Ool0:`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o00<006/0W`80000Z0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o17oo0P004goo000<
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool^0Il2001W09l2000/0Il5Ool00`00Oomoo`0AOol000eo
o`03001oogoo009oo`03001oogoo009oo`0_0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`03001R09l30000;P6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o1Goo00<007ooOol04Goo
0009Ool01@00Oomoogoo000017oo00<007ooOol00Woo<P6O1000FP2O1000<@6O1Goo00<007ooOol0
4Goo000:Ool30005Ool00`00Oomoo`02Ool0=P5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`<005@0W`<0000e0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oocT1W`@004/0W`D003P1
W`Eoo`03001oogoo015oo`004Woo0P000goo03d1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`06001009l50000?@5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00Aoo`8001=oo`004Woo
00<007ooOol00Woo@`6O@000@P6O1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool0a@5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl01Goo00<007ooOol04Goo000BOol00`00Oomoo`02
Ooo50Il5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`350Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009oolD1W`Eoo`03001oogoo
015oo`004Woo00<007ooOol00Woo0<D1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00Eo
o`03001oogoo015oo`004Woo0P000gooa@6O17oo0P004goo000BOol00`00Oomoo`02Ool20000`P5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il20004Ool00`00Oomoo`0AOol0019oo`03001oogoo009o
o`82O`<00;`1W`<000030Wmoogoo00=oo`03001oogoo015oo`004Woo00<007ooOol00Woo00D2O`:O
0Wl2W`9o00<0002f0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`<000040Yl2O`:O0Wl5Ool00`00Oomoo`0AOol0019oo`03001oogoo009o
o`050Yl2O`9o0Wl2W`030Wl3002`0Il300020Wl01@:O0Wl2O`9o0Yl01Goo00<007ooOol04Goo000B
Ool00`00Oomoo`02Ool02`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl00`000:X1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0`0000X2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`Eoo`03001oogoo
015oo`004Woo0P000goo0P9o00D2W`9o0Wl2O`:O00<2O`040Yl2O`9o0Wl3002T0Il300020Wl01@:O
0Wl2O`9o0Yl00`9o00<2W`9o0Wl017oo0P004goo000BOol00`00Oomoo`02Ool04@9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0100004/1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0
1P0004/1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl010000102W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo00D2W`9o0Wl2O`:O00<2
O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl01000>`6O300000H2W`9o0Wl2O`:O0Wl;000l0Il4
00030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Ymoogoo00=oo`03001oogoo015o
o`004Woo00<007ooOol00Woo01T2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`030000<P5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il60000
7@9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0
1P0003<1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00`0001P2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl5Ool00`00Oomoo`0AOol0019o
o`03001oogoo009oo`82O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O
00<2O`030Yl2O`0000<002X1W`@000050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o
0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<2W`0000000`00:@6O1@00
00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<2W`9o0Wl01Goo
00<007ooOol04Goo000BOol00`00Oomoo`02Ool0809o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl40000905o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`80000b0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`<0000R0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl4000080:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl5
Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl0
0`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl010:O0Wl2O`9o20005`6O1@0000D2W`9o
0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`05
0Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O0082O`@001L1W`L000<2O`05
0Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`03
0Wl00`:OOomoo`03Ool00`00Oomoo`0AOol0019oo`8000=oo`0/0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`H000050Gl1W`5o0Il1O`0<0000@0:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o2`0000H1O`6O0Gl1W`5o0Il60000:`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o00Aoo`8001=oo`004Woo00<007ooOol00Woo0P9o00D2W`9o
0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`05
0Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o1@000`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o
0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O
0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o
00D2W`9o0Wl2O`:O00<2O`040Yl2O`9o0Wl600020Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O
00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o
0Wl2W`020Wl5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`1J0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O4@0005X2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl5Ool00`00Oomoo`0A
Ool0019oo`03001oogoo009oo`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl0
1P:O0Wl2O`9o0Yl2O`@00143O`@000030Wl2W`9o0082O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o
0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o
0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`05
0Yl2O`9o0Wl2W`030Wl00`:OOomoo`03Ool00`00Oomoo`0AOol000Yoo`D000=oo`03001oogoo009o
o`1D0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0P0000<3O`>O
0gl00P=o00<3W`=o0gl02@0000D3W`=o0gl3O`>O00<3O`80001D0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o1Goo00<007ooOol04Goo000<Ool00`00Oomoo`03Ool0
0`00Oomoo`02Ool20Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o
0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01P:O0Wl2O`9o0Yl2O`@000D3Oa<0
00D3O`@000030Wl2W`9o0082O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl2O`9o00Eoo`03001o
ogoo015oo`0037oo00<007ooOol00goo00<007ooOol00Woo04h2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl200000`=o0il3O`020glK00000`=o0il3O`020gl20000CP:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`Eoo`03001oogoo015oo`0000=oo`00000010001Goo00<0
07ooOol00goo0`000Woo00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl0
0`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00@2W`9o0Wl2O`8000@3Ob4000@3
O`8000<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl0
1@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Ymoogoo009oo`8001=oo`0037oo00<007oo
Ool00goo00<007ooOol00Woo04X2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0P000`=o00<3W`=o
00008`000P=o04h3W`=o000000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl5Ool00`00Oomoo`0A
Ool000aoo`03001oogoo00=oo`03001oogoo009oo`82O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o
0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o
0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00H2W`9o0Wl2O`:O0Wl20006
0glV00050gl200000`9o0Yl2O`020Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl0
1@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl2O`9o00Eoo`03001oogoo015oo`002Woo
0`001Goo00<007ooOol00Woo04X2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0003O`>O0`=o00<3W`000000
9`000P=o00@3W`=o0gl3O`8000160Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl5Ool00`00Oomoo`0AOol000ao
o`03001oogoo00=oo`03001oogoo009oo`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2
W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2
O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00L2W`9o0Wl2O`:O0Wl000060gl/00060gl2
00030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2
O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2
W`9o0Wl2O`:O00<2O`030Ymoogoo00=oo`03001oogoo015oo`004Woo00<007ooOol00Woo04@2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0P0000<3O`>O0gl00P=o;`0000<3O`>O0gl00P=o04H3W`=o0002O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`Eoo`03001oogoo015oo`004Woo0P000goo0P9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2
W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2
O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`:O0003O`050glb00060gl2
00020Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2
O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2
W`9o0Wl2O`:O0082O`Aoo`8001=oo`004Woo00<007ooOol00Woo0442O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o00800083O`04
0il3O`=o0gld00001@>O0gl3O`=o0il00P=o044000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o00Eoo`03001oogoo015oo`004Woo
00<007ooOol00Woo0`0000<2O`:O0Wl00P9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl0
1@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl0
0`9o00D2W`9o0Wl2O`:O0082O`8000L3OcD000P3O`8000030Wl2W`9o0082O`050Yl2O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o
0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`020Wl30004Ool00`00Oomoo`0AOol0019o
o`03001oogoo009oo`<3O`H0000d0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl200001@>O0gl3O`=o0il00`=o=`0000<3O`>O0gl00P=o00@3W`=o0gl3O`80000c0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O00L000030il3Ogoo00Aoo`03001oogoo
015oo`004Woo00<007ooOol00Woo2@=o1P000`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`:O0000000:
0glh000:0gl200030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl0000000<000T3O`Eoo`03001oogoo
015oo`004Woo00<007ooOol00Woo00<3O`>O0gl00P=o00D3W`=o0gl3O`>O00<3O`030il3O`0000D0
000R0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl400020gl01@>O0gl3O`=o0il00`=o00<3W`000000=`000P=o00D3W`=o0gl3O`>O
00<3O`030il3O`000080000S0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`0600020gl01@>O0gl3O`=o0il00`=o00@3W`=o0gl3
O`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo5@=o2`0000D2W`9o0Wl2O`:O00<2O`050Yl2
O`9o0Wl2W`030Wl00`:O0Wl00004000>0glk000>0gl600001@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`:O00<2O`030Yl0000000X001@3O`Eoo`03001oogoo015oo`004Woo0P000goo0`=o00D3W`=o0gl3
O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O018000030gl3
W`=o0083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il0?@000P=o00D3W`=o0gl3O`>O00<3O`05
0il3O`=o0gl3W`030gl00`>O0000000?00020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01P>O0gl3O`=o0il3O`Aoo`8001=oo`004Woo00<007ooOol00WooA0=o
?@00A0=o1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool00`=o0il3O`020gl01@>O0gl3O`=o
0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00H3W`=o0gl3O`>O0glo0003
0gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o
0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo@`=o@000@P=o1Goo00<007oo
Ool04Goo000BOol00`00Oomoo`02Ool30gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`05
0il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083Od4000050il3O`=o0gl3W`030gl01@>O0gl3
O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3
W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00<3W`=oOol017oo00<0
07ooOol04Goo000BOol00`00Oomoo`02Oom10gm300110gl5Ool00`00Oomoo`0AOol0019oo`8000=o
o`030gl3W`=o0083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3
W`030gl010>O0gl3O`=oA00000D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o
0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`030gl4Ool2000COol0019oo`03001oogoo009ood43Od@00403
O`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o
0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O
0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`060il3O`=o0gl3W`=oA0000P=o00D3W`=o0gl3O`>O
00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o
0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`060il3O`=o0gl3W`=o1Goo00<0
07ooOol04Goo000BOol00`00Oomoo`02Oom00gm500100gl5Ool00`00Oomoo`0AOol0019oo`03001o
ogoo009oo`030gl3W`=o0083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3
O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3
O`=o0gl3W`030gl00`>O0gl3O`1600030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`05
0il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o00@3W`=o0gl3O`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo
@0=oAP00?`=o1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool30gl01@>O0gl3O`=o0il00`=o
00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O
00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00@3W`=o0gl3OdL000030gl3W`=o0083
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3
W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl00`>O0gmo
o`04Ool00`00Oomoo`0AOol0019oo`8000=oocl3OdL003l3O`Aoo`8001=oo`004Woo00<007ooOol0
0Woo00<3O`>O0gl00P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il0
0`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3
O`>O00<3O`030il3O`0004H000<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`05
0il3O`=o0gl3W`030gl010>O0gl3O`=o1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Oolo0gm8
000n0gl5Ool00`00Oomoo`0AOol000Yoo`@000Aoo`03001oogoo009oo`<3O`050il3O`=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o
0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl010>O0gl3O`=oB00000D3W`=o0gl3
O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3
O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`060il3O`=o0gl3W`=o1Goo
00<007ooOol04Goo0009Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo?`=oB000?P=o1Goo00<0
07ooOol01Woo0P000Woo0P001Goo0009Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00<3O`>O
0gl00P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`03
0il3O`0004L00083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3
W`030gl010>O0gl3O`=o1Goo00<007ooOol01goo00@007ooOol000Ioo`002Goo00<007ooOol00Woo
00@007ooOomoom0000Yoo`8000Moo`002Goo00<007ooOol00Woo00D007ooOomoo`0000Aoo`<3n`05
0o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o003
0o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/010?l0o/3n`?k
B00000D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3
n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3
n`?k0o/3o0?k1Goo00<007ooOol027oo0P001goo0009Ool00`00Oomoo`02Ool01@00Oomoogoo0000
17oo?`?kB000?P?k1Goo00<007ooOol01goo00@007ooOol000Ioo`002Goo00<007ooOol00Woo00D0
07ooOomoo`0000Aoo`030o/3o0?k0083n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3
o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0030o/00`?l0o/0001700020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l
00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00@3o0?k0o/3n`Eoo`03001oogoo00Ioo`80009oo`8000Eo
o`002Woo100017oo00<007ooOol00Woo?`?kB000?P?k1Goo00<007ooOol04Goo000BOol00`00Oomo
o`02Ool30o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l
0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k
00@3o0?k0o/3ndP000050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3
o0030o/01P?l0o/3n`?k0o`3n`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo?`?kA`00?`?k
1Goo00<007ooOol04Goo000BOol20003Ool00`?k0o`3n`020o/01@?l0o/3n`?k0o`00`?k00D3o0?k
0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`05
0o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00<3o0?k0000AP000`?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3
o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`040o`3n`?k0o/4Ool2000COol0019o
o`03001oogoo009ood03ndH003l3n`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0`?k00D3
o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3
o01600000`?k0o`3n`020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3
o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3
n`?k0o`00`?k00<3o0?kOol017oo00<007ooOol04Goo000BOol00`00Oomoo`02Oom00o]6000o0o/5
Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`030o/3o0?k0083n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`0
0`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/00`?l0o/3n`1500001@?l0o/3n`?k0o`0
0`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3
n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`Eoo`03
001oogoo015oo`004Woo00<007ooOol00Woo@@?kA000@0?k1Goo00<007ooOol04Goo000BOol20003
Ool30o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3
n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00H3
o0?k0o/3n`?l0o]400020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3
o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3
n`?k0o`00`?k00H3o0?k0o/3n`?l0o/4Ool2000COol0019oo`03001oogoo009ood43nd<00443n`Eo
o`03001oogoo015oo`004Woo00<007ooOol00Woo00<3n`?l0o/00P?k00D3o0?k0o/3n`?l00<3n`05
0o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o003
0o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o01200000`?k0o`3n`02
0o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k
0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00@3o0?k
0o/3n`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo@P?k@@00@P?k1Goo00<007ooOol04Goo
000BOol00`00Oomoo`02Ool30o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l
0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3nd0000050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`0
0`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3
n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00<3o0?kOol017oo00<007ooOol0
4Goo000BOol00`00Oomoo`02Oom30o/o00130o/5Ool00`00Oomoo`0AOol0019oo`03001oogoo009o
o`030o/3o0?k0083n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3
o0030o/01@?l0o/3n`?k0o`00P?k?@0000D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l
0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k
00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/010?l0o/3n`?k1Goo00<007ooOol04Goo000B
Ool20003OolJ0o/L000?0o/l000?0o/K000J0o/4Ool2000COol0019oo`03001oogoo009oo`<3n`05
0o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00<3o0?k0000100001`3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0<00083n`050o`3n`?k0o/3o003
0o/00`?l0o/0000j00030o/01@?l0o/3n`?k0o`00`?k00<3o0?k00000P0001/3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<01P000P?k00D3o0?k0o/3n`?l
00<3n`050o`3n`?k0o/3o0030o/00`?l0o]oo`04Ool00`00Oomoo`0AOol0019oo`03001oogoo009o
o`l3n`H000030o<3m0?c0083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3
l`?d00<3l`050o@3l`?c0o<3m0020o<3000:0o/i000;0o/300000`?c0o@3l`020o<01@?d0o<3l`?c
0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00P?c1P003P?k
1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool00`?k0o`3n`0<0000;@?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m00300020o/01P?l0o/3n`?k0o`3ncL000<3n`050o`3n`?k0o/3o0020o/2
0000;@?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`0<00020o/5Ool00`00Oomoo`0AOol0019o
o`03001oogoo009oo`<000030o<3m0?c0083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d
00<3l`050o@3l`?c0o<3m0020o<00`000o/3n`050o/f00090o/200001@?d0o<3l`?c0o@00`?c00D3
m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3
l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0?c0o<00`0017oo00<007ooOol04Goo
000BOol00`00Oomoo`02Ool0@@?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00000P?k00D3o0?k0o/3n`?l03D00083n`160o`3n`?k
0o/3o0?k0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`83l`050o@3l`?c0o<3
m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3
l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00P?c0P00
1P?k<`001`?k0P0000<3l`?d0o<00P?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`030o@3l`?c00Eoo`03001oogoo015oo`004Woo0P000goo04<3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`0200001P?l0o/3n`?k0o`3nc000083n`040o`3n`?k0o/20000@P?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`Ao
o`8001=oo`004Woo00<007ooOol00Woo00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00P001@?k;@001P?k0P00
0`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3
l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3
l`?c0o<3m0030o<00`?dOomoo`03Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`180o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`000`?k00<3o0?k0000:P000`?k04X3o0?k0o/000?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c1Goo00<007ooOol04Goo000:Ool50003Ool00`00Oomoo`02Ool20o<01@?d0o<3l`?c0o@0
0`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3
l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`070o@3
l`?c0o<3m0?c00001@?k:@001@?k0P0000D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00P?c1Goo00<007ooOol0
4Goo000<Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0B@?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
00800083n`030o`3n`0002H000<3n`1<0o`3n`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<5Ool0
0`00Oomoo`0AOol000aoo`03001oogoo00=oo`03001oogoo009oo`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d
00<3l`030o@3l`?c008000@3nb@000@3n`8000030o<3m0?c0083l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d
00Eoo`03001oogoo015oo`0037oo00<007ooOol00goo0`000Woo04d3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c00<000<3n`030o`0000001/00083n`030o`3n`?k00<0001<0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<4Ool2000COol000aoo`03001oogoo00=oo`03001oogoo009o
o`83l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c
0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`060o@3l`?c0o<3m0?c0P000`?k6`000`?k0`0000D3
m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3
l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3
m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d0083l`Eoo`03001oogoo015oo`0037oo00<0
07ooOol00goo00<007ooOol00Woo0583l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0<000040o`3n`?k0o/C000010?k0o`3n`?k0`000583m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`Eoo`03001oogoo015oo`002Woo0`001Goo00<007ooOol00Woo
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d
00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c
0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m00500020o/=
00020o/500001@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d
00Eoo`03001oogoo015oo`0037oo00<007ooOol00goo00<007ooOol00Woo05X3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@600030o/00`?l0o/3
n`050000FP?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0P?c00D3m0?c0o<3l`?d00<3l`05
0o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m003
0o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c
0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01P?d0o<3l`?c0o@3l`H000050o@3
l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<0
1@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@0
0`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3
l`?d0083l`Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo02`3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d4@0004/3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@04P0002/3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`05Ool00`00Oomoo`0AOol0019oo`8000=oo`050o@3l`?c0o<3m0030o<0
1@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@0
0P?c1@004@?/1P0000<3l`?d0o<00P?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`030o@3l`?c00D00183k0@00083l`050o@3l`?c0o<3m0030o<01@?d0o<3
l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@017oo0P00
4goo000BOol00`00Oomoo`02Ool08P?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d1@0001`3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`H0000d0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<600006`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k00600008@?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`05Ool00`00Oomoo`0AOol0019oo`03001oogoo
009oo`83l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3
l`?c0o<3m003000W0n`500001@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3
m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030o@0000000@002L3k0<000<3l`05
0o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030o@3l`?c00Eoo`03
001oogoo015oo`004Woo00<007ooOol00Woo01X3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d1@0002l3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
00H0000M0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`060000<0?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`@0000J0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`Eoo`03001oogoo015oo`00
4Woo00<007ooOol00Woo00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01P?d0o<3l`?c0o@3
l`@003X3k0H00083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00P?c1P00>P?/1@0000D3m0?c
0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@01Goo00<007ooOol04Goo000BOol0
0`00Oomoo`02Ool050?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@20000A0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`A0000A@?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00300004P?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`Eoo`03001oogoo015oo`004Woo0P000goo0P?c00D3m0?c0o<3l`?d
00<3l`050o@3l`?c0o<3m0020o<3002O0n`200000`?c0o@3l`020o<01@?d0o<3l`?c0o@00`?c00<3
m0?c0o<017oo0P004goo000BOol00`00Oomoo`02Ool02`?c0o@3l`?d0o<3m0?c0o@3l`?d0o<01P00
0:@3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[1P0000X3m0?c0o@3l`?d0o<3m0?c0o@3l`Eoo`03
001oogoo015oo`004Woo00<007ooOol00Woo00D3m0?c0o<3l`?d00<3l`<00;03k0<00083l`050o@3
l`?c0o<3m005Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`050o<3m0?c0o@3l`030000]P?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3000010?d0o<3m0?c1Goo00<007ooOol04Goo000BOol00`00Oomoo`02Ool20o<3002l0n`30000
0`?cOomoo`03Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`8000320n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k08000Aoo`03001oogoo015oo`004Woo00<007ooOol00Wooa@?/1Goo00<007oo
Ool04Goo000BOol20003Ool0a@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/017oo0P00
4goo000BOol00`00Oomoo`02Ooo50n`5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oo`350n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`05Ool00`00Oomoo`0AOol0019oo`03001oogoo
009oolD3k0Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo0<D3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[00Eoo`03001oogoo015oo`004Woo00<007ooOol00WooCP?/:@00CP?/1Goo
00<007ooOol04Goo000BOol20003Ool0@`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00/002T3i0`000120n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[17oo0P004goo000BOol00`00Oomoo`02Oolm0n`600100n@5000m0n`5Ool00`00Oomoo`0AOol0
019oo`03001oogoo009oo`0g0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/01P00B`?T1P0003L3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`05Ool00`00Oomoo`0AOol0019oo`03001oogoo009ooc<3k0@005L3i0D00383k0Eo
o`03001oogoo015oo`002Goo1@0017oo00<007ooOol00Woo0343j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`02001P0n@20000<0?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`Eoo`03001oogoo015oo`002Goo00D007ooOomoo`0000Aoo`03001oogoo009oobh3k0<006@3
i0@002`3k0Eoo`03001oogoo015oo`002Woo00<007ooOol01Goo00<007ooOol00Woo02/3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`03001[0n@20000:P?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`Eoo`03
001oogoo015oo`002goo00<007ooOol017oo0`000Woo:0?/0`00L0?T0P00:0?/17oo0P004goo000<
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool09P?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`2001e0n@200009P?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/5Ool00`00Oomoo`0AOol000eoo`03001oogoo009oo`03001oogoo009oob@3k080
07T3i08002@3k0Eoo`03001oogoo015oo`002Goo00D007ooOomoo`0000Aoo`03001oogoo009oo`0R
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`2001m0n@300008@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`05Ool00`00Oomoo`0AOol000Yoo`<000Eoo`03001oogoo
009ooal3k0<00883i0<001h3k0Eoo`03001oogoo015oo`004Woo00<007ooOol00Woo01`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0<008P3i080000L
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/5Ool0
0`00Oomoo`0AOol0019oo`8000=ooaX3k08008d3i08001X3k0Aoo`8001=oo`004Woo00<007ooOol0
0Woo01P3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`2002A0n@2
000060?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`Eoo`03001o
ogoo015oo`004Woo00<007ooOol00Woo5`?/00<000?T0n@0T`?T0P005P?/1Goo00<007ooOol04Goo
000BOol00`00Oomoo`02Ool05`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0000V0?T0P0001@3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[1Goo00<0
07ooOol04Goo000BOol00`00Oomoo`02OolD0n`2002K0n@2000B0n`5Ool00`00Oomoo`0AOol0019o
o`03001oogoo009oo`0A0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`03002O0n@20000
40?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[1Goo00<007ooOol04Goo000BOol00`00Oomo
o`02Ool?0n`2002T0n@2000>0n`5Ool00`00Oomoo`0AOol0019oo`8000=oo`0=0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/00P00Z0?T0P0000`3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/4Ool2000COol0
019oo`03001oogoo009oo`/3k0800:`3i08000X3k0Eoo`03001oogoo015oo`004Woo00<007ooOol0
0Woo00T3j`?/0n/3k0?[0n`3j`?/0n/00P00/0?T0P0000P3k0?[0n`3j`?/0n/3k0?[1Goo00<007oo
Ool04Goo000BOol00`00Oomoo`02Ool70n`2002d0n@200060n`5Ool00`00Oomoo`0AOol0019oo`03
001oogoo009oo`050n/3k0?[0n`3j`02002h0n@01P000n/3k0?[0n`3j`Eoo`03001oogoo015oo`00
4Woo00<007ooOol00Woo0`?/0P00^`?T0P000`?/1Goo00<007ooOol04Goo000BOol00`00Oomoo`02
Ool00`?[0000002o0n@200000`?[Oomoo`03Ool00`00Oomoo`0AOol0019oo`8000=oo`030003i0?T
0<43i08000=oo`8001=oo`004Woo00<007ooOol00Wooa@?T1Goo00<007ooOol04Goo000BOol00`00
Oomoo`02Ooo50n@5Ool00`00Oomoo`0AOol0019oo`03001oogoo009ooe/3i14005T3i0Eoo`03001o
ogoo015oo`004Woo00<007ooOol00WooE@?T1P000147h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP00H005<3i0Eoo`03001oogoo015oo`004Woo00<007ooOol00WooC`?T1P0001d;h0OP2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P00H004d3i0Eo
o`03001oogoo015oo`004Woo0P000gooB`?T100002T7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00<004X3
i0Aoo`8001=oo`004Woo00<007ooOol00WooBP?T034000_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n07h00200180n@5Ool00`00Oomoo`0AOol0019oo`03001oogoo009oodP3i080000c2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P008004H3i0Eoo`03001oogoo015o
o`004Woo00<007ooOol00WooA@?T0`0003L7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h00300130n@5Ool00`00Oomoo`0AOol000Yoo`<000Eoo`03001oogoo009o
od83i0<0000m1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n000P00@@?T1Goo00<007ooOol04Goo0009Ool01@00Oomoogoo000017oo00<007oo
Ool00Woo@0?T0P000487h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n02000o0n@5Ool00`00Oomoo`0AOol000eoo`03001oogoo
009oo`03001oogoo009ooch3i08000162n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n02000m0n@5Ool00`00Oomo
o`0AOol000eoo`03001oogoo009oo`<0009oocd3i01<0007h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P000l0n@4Ool2000COol000]oo`8000Eoo`03001oogoo06Eoo`03001oogoo06Aoo`03001oogoo
015oo`003Goo00<007ooOol00Woo00<007ooOol0IGoo00<007ooOol0I7oo00<007ooOol04Goo0009
Ool01@00Oomoogoo000017oo00<007ooOol00Woo00<007ooOol07Woo00<007ooOol07Woo00<007oo
Ool07Woo00<007ooOol07Goo00<007ooOol07Woo00<007ooOol07Woo00<007ooOol00Woo00<007oo
Ool04Goo000:Ool30005Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomo
o`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomo
o`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomo
o`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomo
o`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomo
o`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomo
o`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`0AOol0019oom00
01=oo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol007Qoo`<007Yoo`00NWoo
00<007ooOol0N7oo001jOol00`00Oomoo`1hOol007Uoo`03001oo`0007Uoo`00NGoo00<007oo0000
NGoo001hOol01@00Oomoogoo0000N7oo001hOol01@00Oomoogoo0000N7oo001gOol3000017oo0000
0000Mgoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol00001\
\>"],
  ImageRangeCache->{{{0, 244.313}, {244.313, 0}} -> {-3.7244, -3.5719, \
0.0381238, 0.0381238}}]
}, Open  ]],

Cell["\<\
In this section, we presented the derivation of Stokes' classical \
solution of the creeping flow around a sphere. Contrary to Stokes, we did not \
guess the solution by an ingenious ansatz. The solution in our calculation \
followed directly from the symmetry analysis of the problem. This example \
illustrates the strength of this method by a straightforward \
calculation.\
\>", "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"Layer.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{645, 668},
WindowMargins->{{94, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->311,
PrintingPageRange->{299, 300},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Stokes' Solution of the Creeping Flow"->{
    Cell[1739, 51, 396, 5, 49, "Subsection",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 60}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Stokes' Solution of the Creeping Flow"]},
  "creeping motion of a fluid"->{
    Cell[2138, 58, 336, 9, 54, "Text",
      CellTags->"creeping motion of a fluid"]},
  "Stokes stream function"->{
    Cell[19852, 596, 577, 17, 75, "Text",
      CellTags->"Stokes stream function"]},
  "Reynolds number"->{
    Cell[21191, 639, 407, 8, 96, "Text",
      CellTags->{
      "Reynolds number", "momentum equation", "stream function", 
        "Laplacian"}]},
  "momentum equation"->{
    Cell[21191, 639, 407, 8, 96, "Text",
      CellTags->{
      "Reynolds number", "momentum equation", "stream function", 
        "Laplacian"}]},
  "stream function"->{
    Cell[21191, 639, 407, 8, 96, "Text",
      CellTags->{
      "Reynolds number", "momentum equation", "stream function", 
        "Laplacian"}],
    Cell[37969, 1122, 103, 1, 33, "Text",
      CellTags->"stream function"]},
  "Laplacian"->{
    Cell[21191, 639, 407, 8, 96, "Text",
      CellTags->{
      "Reynolds number", "momentum equation", "stream function", 
        "Laplacian"}]},
  "fourth-order linear PDE"->{
    Cell[25575, 750, 591, 13, 117, "Text",
      CellTags->"fourth-order linear PDE"]},
  "LieEquations[]"->{
    Cell[26169, 765, 395, 8, 100, "Input",
      CellTags->"LieEquations[]"]},
  "Lie point symmetries"->{
    Cell[26567, 775, 149, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"Lie point symmetries"]},
  "Stokes' model"->{
    Cell[30127, 876, 1656, 46, 201, "Text",
      CellTags->{
      "Stokes' model", "finite group", "scaling symmetry", 
        "LieReduction[]"}]},
  "finite group"->{
    Cell[30127, 876, 1656, 46, 201, "Text",
      CellTags->{
      "Stokes' model", "finite group", "scaling symmetry", 
        "LieReduction[]"}]},
  "scaling symmetry"->{
    Cell[30127, 876, 1656, 46, 201, "Text",
      CellTags->{
      "Stokes' model", "finite group", "scaling symmetry", 
        "LieReduction[]"}]},
  "LieReduction[]"->{
    Cell[30127, 876, 1656, 46, 201, "Text",
      CellTags->{
      "Stokes' model", "finite group", "scaling symmetry", "LieReduction[]"}],
    
    Cell[35533, 1025, 593, 17, 96, "Text",
      CellTags->{"DSolve[]", "LieReduction[]"}]},
  "similarity solution"->{
    Cell[34092, 984, 271, 9, 54, "Text",
      CellTags->"similarity solution"]},
  "DSolve[]"->{
    Cell[35533, 1025, 593, 17, 96, "Text",
      CellTags->{"DSolve[]", "LieReduction[]"}]},
  "determining equation"->{
    Cell[36334, 1053, 210, 6, 33, "Text",
      CellTags->"determining equation"]},
  "boundary condition"->{
    Cell[38281, 1135, 361, 8, 75, "Text",
      CellTags->"boundary condition"]},
  "non-slip condition"->{
    Cell[39170, 1166, 232, 7, 54, "Text",
      CellTags->"non-slip condition"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Stokes' Solution of the Creeping Flow", 361451, 11861},
  {"creeping motion of a fluid", 361829, 11868},
  {"Stokes stream function", 361946, 11871},
  {"Reynolds number", 362055, 11874},
  {"momentum equation", 362229, 11879},
  {"stream function", 362401, 11884},
  {"Laplacian", 362645, 11891},
  {"fourth-order linear PDE", 362825, 11896},
  {"LieEquations[]", 362935, 11899},
  {"Lie point symmetries", 363042, 11902},
  {"Stokes' model", 363172, 11906},
  {"finite group", 363343, 11911},
  {"scaling symmetry", 363518, 11916},
  {"LieReduction[]", 363691, 11921},
  {"similarity solution", 363957, 11928},
  {"DSolve[]", 364055, 11931},
  {"determining equation", 364176, 11934},
  {"boundary condition", 364286, 11937},
  {"non-slip condition", 364394, 11940}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 396, 5, 49, "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 60}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Stokes' Solution of the Creeping Flow"],
Cell[2138, 58, 336, 9, 54, "Text",
  CellTags->"creeping motion of a fluid"],
Cell[2477, 69, 17372, 525, 230, 10187, 423, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[19852, 596, 577, 17, 75, "Text",
  CellTags->"Stokes stream function"],

Cell[CellGroupData[{
Cell[20454, 617, 382, 9, 73, "Input"],
Cell[20839, 628, 337, 8, 81, "Output"]
}, Open  ]],
Cell[21191, 639, 407, 8, 96, "Text",
  CellTags->{
  "Reynolds number", "momentum equation", "stream function", "Laplacian"}],
Cell[21601, 649, 184, 3, 39, "Input"],
Cell[21788, 654, 148, 3, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21961, 661, 114, 2, 27, "Input"],
Cell[22078, 665, 3482, 82, 181, "Output"]
}, Open  ]],
Cell[25575, 750, 591, 13, 117, "Text",
  CellTags->"fourth-order linear PDE"],
Cell[26169, 765, 395, 8, 100, "Input",
  CellTags->"LieEquations[]"],
Cell[26567, 775, 149, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"Lie point symmetries"],

Cell[CellGroupData[{
Cell[26741, 784, 66, 1, 27, "Input"],
Cell[26810, 787, 3302, 86, 139, "Output"]
}, Open  ]],
Cell[30127, 876, 1656, 46, 201, "Text",
  CellTags->{
  "Stokes' model", "finite group", "scaling symmetry", "LieReduction[]"}],

Cell[CellGroupData[{
Cell[31808, 926, 208, 4, 45, "Input"],
Cell[32019, 932, 1565, 32, 145, "Output"]
}, Open  ]],
Cell[33599, 967, 209, 3, 54, "Text"],

Cell[CellGroupData[{
Cell[33833, 974, 129, 3, 27, "Input"],
Cell[33965, 979, 112, 2, 30, "Output"]
}, Open  ]],
Cell[34092, 984, 271, 9, 54, "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[34388, 997, 114, 2, 38, "Input"],
Cell[34505, 1001, 1013, 21, 71, "Output"]
}, Open  ]],
Cell[35533, 1025, 593, 17, 96, "Text",
  CellTags->{"DSolve[]", "LieReduction[]"}],

Cell[CellGroupData[{
Cell[36151, 1046, 85, 1, 27, "Input"],
Cell[36239, 1049, 80, 1, 30, "Output"]
}, Open  ]],
Cell[36334, 1053, 210, 6, 33, "Text",
  CellTags->"determining equation"],

Cell[CellGroupData[{
Cell[36569, 1063, 60, 1, 27, "Input"],
Cell[36632, 1066, 135, 2, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36804, 1073, 61, 1, 42, "Input"],
Cell[36868, 1076, 109, 2, 30, "Output"]
}, Open  ]],
Cell[36992, 1081, 118, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[37135, 1087, 71, 1, 27, "Input"],
Cell[37209, 1090, 136, 2, 30, "Output"]
}, Open  ]],
Cell[37360, 1095, 91, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[37476, 1102, 70, 1, 27, "Input"],
Cell[37549, 1105, 55, 1, 42, "Output"]
}, Open  ]],
Cell[37619, 1109, 147, 2, 54, "Text"],

Cell[CellGroupData[{
Cell[37791, 1115, 83, 1, 27, "Input"],
Cell[37877, 1118, 77, 1, 42, "Output"]
}, Open  ]],
Cell[37969, 1122, 103, 1, 33, "Text",
  CellTags->"stream function"],

Cell[CellGroupData[{
Cell[38097, 1127, 62, 1, 27, "Input"],
Cell[38162, 1130, 104, 2, 42, "Output"]
}, Open  ]],
Cell[38281, 1135, 361, 8, 75, "Text",
  CellTags->"boundary condition"],

Cell[CellGroupData[{
Cell[38667, 1147, 89, 1, 27, "Input"],
Cell[38759, 1150, 127, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38923, 1157, 99, 2, 27, "Input"],
Cell[39025, 1161, 130, 2, 42, "Output"]
}, Open  ]],
Cell[39170, 1166, 232, 7, 54, "Text",
  CellTags->"non-slip condition"],

Cell[CellGroupData[{
Cell[39427, 1177, 93, 1, 27, "Input"],
Cell[39523, 1180, 133, 3, 49, "Message"],
Cell[39659, 1185, 151, 2, 42, "Output"]
}, Open  ]],
Cell[39825, 1190, 73, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[39923, 1194, 136, 3, 27, "Input"],
Cell[40062, 1199, 238, 5, 83, "Output"]
}, Open  ]],
Cell[40315, 1207, 558, 19, 75, "Text"],

Cell[CellGroupData[{
Cell[40898, 1230, 69, 1, 27, "Input"],
Cell[40970, 1233, 391, 11, 55, "Output"]
}, Open  ]],
Cell[41376, 1247, 508, 19, 54, "Text"],

Cell[CellGroupData[{
Cell[41909, 1270, 89, 1, 38, "Input"],
Cell[42001, 1273, 102, 2, 45, "Output"]
}, Open  ]],
Cell[42118, 1278, 78, 0, 33, "Text"],
Cell[42199, 1280, 166, 3, 41, "Input"],
Cell[42368, 1285, 202, 4, 54, "Text"],

Cell[CellGroupData[{
Cell[42595, 1293, 115, 2, 34, "Input"],
Cell[42713, 1297, 97, 2, 37, "Output"]
}, Open  ]],
Cell[42825, 1302, 198, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[43048, 1314, 129, 3, 27, "Input"],
Cell[43180, 1319, 112, 2, 30, "Output"]
}, Open  ]],
Cell[43307, 1324, 207, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[43539, 1336, 424, 7, 117, "Input"],
Cell[43966, 1345, 117928, 4481, 267, 52688, 3671, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[161909, 5829, 189, 4, 54, "Text"],
Cell[162101, 5835, 93, 3, 33, "Text"],
Cell[162197, 5840, 159, 3, 40, "Input"],
Cell[162359, 5845, 163, 3, 40, "Input"],
Cell[162525, 5850, 117, 3, 54, "Text"],

Cell[CellGroupData[{
Cell[162667, 5857, 73, 1, 27, "Input"],
Cell[162743, 5860, 166, 2, 67, "Output"]
}, Open  ]],
Cell[162924, 5865, 217, 6, 54, "Text"],

Cell[CellGroupData[{
Cell[163166, 5875, 446, 8, 99, "Input"],
Cell[163615, 5885, 104908, 2802, 257, 24917, 1810, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[268538, 8690, 106, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[268669, 8697, 74, 1, 27, "Input"],
Cell[268746, 8700, 161, 2, 59, "Output"]
}, Open  ]],
Cell[268922, 8705, 152, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[269099, 8714, 472, 9, 99, "Input",
  PageBreakWithin->False],
Cell[269574, 8725, 89590, 3071, 260, 33796, 2378, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[359179, 11799, 400, 7, 117, "Text"],
Cell[359582, 11808, 145, 3, 44, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

