(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    356296,       9459]*)
(*NotebookOutlinePosition[    388994,      10254]*)
(*  CellTagsIndexPosition[    384142,      10140]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["6", "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  AspectRatioFixed->True,
  CellTags->"Non-classical method"],

Cell["\<\
Non-classical Symmetries of Partial
Differential Equations\
\>", "Title",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  "6.",
  CounterBox["Section"],
  ".",
  " Introduction"
}], "Section",
  CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],

Cell[TextData[{
  "The non-classical method of symmetry analysis is an extension of Lie's \
classical method. This non-classical method was compiled by ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  " in connection with the analysis of the heat equation. This method allows \
us to derive another type of solutions which are different from solutions \
derived from Lie's procedure. The method extends the classical approach to \
find solutions for linear and non-linear PDEs. This chapter contains the \
theoretical background of the method and demonstrates the application to \
different problems."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "non-classical method", "symmetry analysis", "Lie's classical method"}],

Cell[TextData[{
  "Based on a side condition, ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  " introduced the non-classical method. They discussed the diffusion \
equation as an example. The result of their considerations was that \
completely different solutions for the heat equation occur. A \
group-theoretical explanation of this result was given by ",
  ButtonBox["Olver [1986] ",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  "and ",
  ButtonBox["Levi and Winternitz [1989]",
    ButtonData:>{"Literat.nb", "Levi-89"},
    ButtonStyle->"Hyperlink"],
  ". The non-classical method was extended to ",
  StyleBox["weak symmetries",
    FontSlant->"Italic"],
  " and ",
  StyleBox["side conditions ",
    FontSlant->"Italic"],
  "by",
  StyleBox[" ",
    FontSlant->"Italic"],
  ButtonBox["Olver and Rosenau [1986]",
    ButtonData:>{"Literat.nb", "Olve-86R"},
    ButtonStyle->"Hyperlink"],
  StyleBox[".",
    FontSlant->"Italic"],
  " The difference between weak symmetries and symmetries is defined as \
follows."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "non-classical method", "diffusion equation", "heat equation", 
    "weak symmetries"}],

Cell["Definition: Symmetry of a PDE", "Definition",
  CellTags->"Definition: Symmetry of a PDE"],

Cell[TextData[{
  "A symmetry group \[GothicCapitalG] of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " is a local transformation with the following properties:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"local transformation"],

Cell[TextData[{
  "The elements of \[GothicCapitalG] transform solutions of ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalDelta] = 0\ \)\)]],
  " into new solutions of this equation."
}], "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The solutions of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " invariant under \[GothicCapitalG] follow from a system of PDEs containing \
a reduced set of independent variables. \[EmptyCircle]"
}], "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The above definition rephrases the invariance conditions of C",
  ButtonBox["hapter 5",
    ButtonData:>{"symmet5.nb", 
      "Point Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " in different words. A weak symmetry, on the other hand, is a symmetry \
which satisfies the second condition of the definition but does not satisfy \
the first one. Thus, a weak symmetry transformation does not allow that new \
solutions of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " follow from known solutions. The second condition expand the class of \
solutions for a PDE. In the following, we will show that this freedom of a \
symmetry definition is capable to deliver a new kind of solution."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"weak symmetry"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.",
  CounterBox["Section"],
  ".",
  " Mathematical Background of the Non-classical Method"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Mathematical background of the non-classical method"],

Cell["\<\
In this section, we are looking for solutions of the general \
equation\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalDelta](x, u\_\((k)\))\  = \ 0\)], 
  "NumberedEquation"],

Cell[TextData[{
  "under a side condition. Contrary to the classical method of Lie, we are \
seeking solutions under the condition that the invariant surface condition \
vanishes. As we know, the solution for the function ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " invariant under a point transformation is based on the characteristic \
equations"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "invariant surface condition", "point transformation", 
    "characteristic equations"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          SubscriptBox[
            StyleBox["dx",
              FontSlant->"Italic"], "1"], \(\[Xi]\_1\)], "=", " ", 
        RowBox[{
          FractionBox[
            SubscriptBox[
              StyleBox["dx",
                FontSlant->"Italic"], "2"], \(\[Xi]\_2\)], "=", " ", 
          RowBox[{"\[CenterEllipsis]", "=", " ", 
            RowBox[{
              FractionBox[
                SubscriptBox[
                  StyleBox["dx",
                    FontSlant->"Italic"], "n"], \(\[Xi]\_n\)], "=", 
              RowBox[{
                FractionBox[
                  SuperscriptBox[
                    StyleBox["du",
                      FontSlant->"Italic"], "1"], \(\[Phi]\_1\)], "=", 
                RowBox[{
                  FractionBox[
                    SuperscriptBox[
                      StyleBox["du",
                        FontSlant->"Italic"], "2"], \(\[Phi]\_2\)], "=", 
                  RowBox[{"\[CenterEllipsis]", "=", 
                    FractionBox[
                      SuperscriptBox[
                        StyleBox["du",
                          FontSlant->"Italic"], "m"], 
                      \(\[Phi]\_m\)]}]}]}]}]}]}], "."}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "Equivalently, relation (6.2) can be formulated in connection with the \
vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " by using the infinitesimals as"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(\[Sum]\+\(i = 1\)\%n\( \[Xi]\_i\) u\_i\%\[Alpha] - 
            \[Phi]\_\[Alpha]\  = \ 0\), " ", ",", "     ", 
        FormBox[\(\[Alpha] = 1, \[Ellipsis], \ \(m . \)\),
          "TraditionalForm"]}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "This equation (6.3) is abbreviated with ",
  Cell[BoxData[
      \(TraditionalForm\`\(Q\_\[Alpha]\)(x, u\_\((1)\))\  = \ 0\)]],
  " by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ". A solution of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\  = \ 0\)]],
  " invariant under the transformation given by ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " satisfies the system of PDEs"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(\[CapitalDelta](x, u\_\((k)\)\),
              "TraditionalForm"], ")"}], " ", "=", " ", "0"}], ","}], 
      TraditionalForm]], "NumberedEquation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{\(Q\_\[Alpha]\), "(", 
            RowBox[{"x", ",", " ", 
              RowBox[{
                FormBox[\(\(u\_\((1)\))\)\ \),
                  "TraditionalForm"], "=", " ", "0."}]}]}],
          "TraditionalForm"], "   "}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "So far, we recalled the properties of the classical method by Lie. The \
non-classical method of Bluman and Cole now considers condition (6.5) as an \
additional side condition for the solution of the original equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\  = 0\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"classical method", "non-classical method"}],

Cell[TextData[{
  "In a non-classical symmetry analysis of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  ", we are not only interested in the symmetries of the PDE but also in the \
symmetries of the PDE extended by the characteristic equation (6.5). The \
solutions of the non-classical method will generate a weak symmetry in the  \
sense discussed in ",
  ButtonBox["Section 6.1",
    ButtonData:>"Introduction",
    ButtonStyle->"Hyperlink"],
  ". At the other hand, it is certain that the vector fields of the \
non-classical method do not need to form a Lie algebra. Hence, there can be a \
wider class of similarity solutions than in the classical case."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}],

Cell[TextData[{
  "An essential observation by ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  " is that an invariant solution ",
  Cell[BoxData[
      \(TraditionalForm\`u(x)\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " does not only solve the PDE itself but also the invariant surface \
condition or characteristic equation:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "invariant solution", "invariant surface condition", 
    "characteristic equation"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(Q\_\[Alpha]\  = \ 0\), ",", "       ", 
        FormBox[\(\[Alpha]\  = \ 1, \[Ellipsis], \ \ \(q . \)\),
          "TraditionalForm"]}], TraditionalForm]], "NumberedEquation"],

Cell["\<\
Thus, the invariance condition of the classical method is extended \
by this  additional condition:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(pr\^\((k)\)\) v\&\[RightVector]\ \[CapitalDelta]\ 
      \[VerticalSeparator]\_\(\[CapitalDelta] = \(0\nQ\_\[Alpha] = 0\)\)\ 
      \( = \ 0\), \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(pr\^\((1)\)\) v\&\[RightVector]\ Q\_\[Alpha]\ 
      \( \[VerticalSeparator] 
          \_\(\[CapitalDelta] = \(0\nQ\_\[Alpha] = 0\)\)\)\ \( = \ 0. \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "Equation (6.8) does not establish any additional restriction in the \
derivation of the determining equation since it is satisfied identically. The \
main difference compared with Lie's method is that not only one side \
condition occurs but also the characteristics must vanish. This second side \
condition has the consequence that the derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " are strongly coupled. The tight coupling of the derivatives results into \
a non-linear system of determining equations for the infinitesimals. This \
fact is the main difference between the classical and non-classical method. \
However, the non-linearity in the determining equations is a real problem in \
connection with symbolic calculations."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "characteristics", "Lie's method", 
    "nonlinear system of determining equations", "determining equations", 
    "infinitesimals", "nonlinear determining equations"}],

Cell["\<\
The above theoretical considerations can be cast into a more \
suitable formulation for computer calculation. The following discussion shows \
how the prolongation formulation can be rewritten in terms of the \
Fr\[EAcute]chet formalism. We know from above that the non-classical method \
applies the classical Lie method to the extended system of equations\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "prolongation formulation", "Fr\[EAcute]chet formalism", 
    "non-classical method"}],

Cell[BoxData[
    \(TraditionalForm\`\(\(\[CapitalDelta]\^i\)(x, u\_\((k)\))\  = \ 0, 
    \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`\(Q\_\[Alpha] = 0, \)\)], "NumberedEquation"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`i = 1, 2, \ \[Ellipsis], m\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 1, 2, \[Ellipsis], m\)]],
  ". The invariance condition expressed by the Fr\[EAcute]chet derivative \
reads"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"invariance condition", "Fr\[EAcute]chet derivative"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \((\(\[GothicCapitalD]\_\[CapitalDelta]\)(Q)\  + \ \ 
              \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ D\_i\ \[CapitalDelta])\), 
          SubscriptBox["\[VerticalSeparator]", 
            RowBox[{"  ", 
              RowBox[{
              \(Q\_\[Alpha] = \ 
                  \(\[Phi]\_\[Alpha] - 
                      \[Sum]\+\(i = 1\)\%p\( \[Xi]\_i\) u\_i\%\[Alpha] = 0
                    \)\), "\n", " ", 
                RowBox[{
                  StyleBox[\(\[CapitalDelta]\ \),
                    FontSize->11], "=", " ", "0"}]}]}]]}], "=", "0."}], 
      TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "Equation (6.11) is quite similar to the ",
  ButtonBox["invariance condition for point symmetries",
    ButtonData:>{"symmet5.nb", "Invariance condition for point symmetry"},
    ButtonStyle->"Hyperlink"],
  ". The difference is that in the present case the characteristics have to \
vanish. The added surface condition can be annotated as a side condition or \
as a conditional equation that introduces new dependencies for the \
derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". These relations have to be taken into consideration during the \
calculations. The side condition ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha] = 0\)]],
  " introduces a relation representing a strong connection between the \
derivatives of the dependent variables. This relationship has to be \
considered in the elimination of derivatives in the prolongation formula. \
Equation (6.11) contains all the necessary steps to calculate the determining \
equations in a nutshell. Let us summarize the algorithm in the following \
steps:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"algorithm for the non-classical method"],

Cell[TextData[{
  "Calculate the prolongation of the equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " as discussed for classical point symmetries."
}], "ListItem",
  CellDingbat->"1.",
  CellTags->{"non-classical algorithm", "prolongation"}],

Cell["Apply the side conditions to the prolongation formula.", "ListItem",
  CellDingbat->"2.",
  CellTags->{"side conditions", "prolongation formula"}],

Cell["\<\
Extract the determining equations as discussed for the classical \
method.\
\>", "ListItem",
  CellDingbat->"3.",
  CellTags->"determining equations"],

Cell[TextData[{
  "These three steps are the essentials of the non-classical method. Contrary \
to the classical method, we have as side conditions not only the equations ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " but also the condition of the vanishing characteristics and the \
differential consequences of this relation. The main difficulty of this \
algorithm is contained in the second step. Since the characteristic equation \
is satisfied identically, we can apply this side condition either to the \
original equation itself or to the prolongation. Both procedures are \
discussed in the literature. The method by ",
  ButtonBox["Levi and Winternitz [1989]",
    ButtonData:>{"Literat.nb", "Levi-89"},
    ButtonStyle->"Hyperlink"],
  " prefers the elimination of the side conditions after the calculation of \
the prolongation. ",
  ButtonBox["Clarkson and Mansfield [1994]",
    ButtonData:>{"Literat.nb", "Clar-94"},
    ButtonStyle->"Hyperlink"],
  " eliminate the terms of the characteristics before the prolongation is \
calculated. The algorithm implemented in ",
  StyleBox["MathLie ",
    FontSlant->"Italic"],
  "follow the considerations of Clarkson and Mansfield."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"non-classical method", "side condition"}],

Cell["\<\
The kind of problems occurring during a non-classical calculation \
are demonstrated by the following example. Let us consider the characteristic \
equation in 2+1 dimensions. The characteristic equation for this case reads\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"characteristic equation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_x\ \(\(\[Xi]\_1\)(x, t, u)\)\  + \ 
        u\_t\ \(\(\[Xi]\_2\)(x, t, u)\)\  - \ \[Phi](x, t, u)\  = 0. \)], 
  "NumberedEquation"],

Cell[TextData[{
  "Let us assume that we are looking for a substitution replacing the ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t\)]],
  " term. The resulting expression from (6.12) is given by"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`u\_t\  \[Rule] \[Phi]\  - \ \(u\_x\) \(\[Xi]\_1 . \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "We replaced the ratios of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]/\[Xi]\_2\)]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\[Xi]\_1\),
            "TraditionalForm"], "/", \(\[Xi]\_2\)}], TraditionalForm]]],
  " simply by \[Phi] and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", respectively. This substitution corresponds to a formal coordinate \
transformation assuming that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2 = 1\)]],
  ". The derived substitution rules from (6.13) are up to second order given \
by"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"formal coordinate transformation"],

Cell[BoxData[
    \(TraditionalForm\`\(u\_t \[Rule] \ \[Phi]\  - \(u\_x\) \[Xi]\_1, \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_xt \[Rule] \ 
      \[Phi]\_x + \(u\_x\)(\[Phi]\_u - \[Xi]\_\(1  x\))\  - \ 
        u\_x\%2\ \[Xi]\_\(1  u\) - \(u\_xx\) \[Xi]\_1, \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_tt \[Rule] \ 
      \[Phi]\_t\  + \ \(u\_t\) \[Phi]\_u\  - 
        \(u\_x\)(\[Xi]\_\(1  t\) + \ \(u\_t\) \[Xi]\_\(1  u\))\  - 
        \(u\_xt\) \(\[Xi]\_1 . \)\)], "NumberedEquation"],

Cell[TextData[{
  "The last of these relations (6.16) contains terms of ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(x, t\)\)]],
  " which have to be replaced by the first two rules (6.14) and (6.15), \
respectively. Thus, relation (6.16) is only expressible if the preceding \
substitutions were calculated first. If not, relation (6.16) contains \
redundant information which affects the invariant condition (6.11). Thus, one \
has to keep the following suggestions in mind if one solves the side \
conditions ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha] = 0\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"redundant information"],

Cell[TextData[{
  "The derivatives for which the side condition ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha] = 0\)]],
  " is solved should occur in the original equation in a simple form. This \
guarantees that the original equation stays simple after the substitution of \
the side conditions and thus saves a lot of computing time."
}], "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "If we have more than one dependent variable, we should solve the \
characteristic equation with respect to a derivative occurring in all side \
conditions. This allows the introduction of the relation ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i = 1\)]],
  " for a specific independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  "."
}], "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The substitutions derived in the above example indicate that the \
determining equations are non-linear functions in the infinitesimals. This \
change from a linear system of determining equations in the case of the \
classical method to a system of non-linear determining equations for the \
non-classical method bears very complicated problems. The problem of solving \
the non-linear determining equations is currently not disclosed. Thus, we \
cannot automatically find solutions for the infinitesimals in all cases with \
",
  StyleBox["MathLie.",
    FontSlant->"Italic"],
  " At the moment, we use an interactive and a pseudo-automatic method to \
derive the solutions from the determining equations. The following examples \
will demonstrate how we can find non-classical symmetries by applying the \
functions of ",
  StyleBox["MathLie.",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "nonlinear determining equations", "classical method", 
    "non-classical method", "non-classical symmetries"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.",
  CounterBox["Section"],
  ".",
  " Applications of the Non-classical Method"
}], "Section",
  CellTags->"Applications of the non-classical method"],

Cell[TextData[{
  "The non-classical method has been applied to various PDEs. New classes of \
solutions which cannot be obtained by the classical method have been found \
for the heat equation by ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  ", the Boussinesq equation by ",
  ButtonBox["Levi and Winternitz [1989]",
    ButtonData:>{"Literat.nb", "Levi-89"},
    ButtonStyle->"Hyperlink"],
  ", the Burgers equation by ",
  ButtonBox["Pucci [1992],",
    ButtonData:>{"Literat.nb", "Puci-92"},
    ButtonStyle->"Hyperlink"],
  " and the Fitzhugh Nagumo equation by ",
  ButtonBox["Nucci and Clarkson [1992]",
    ButtonData:>{"Literat.nb", "Nuci-92"},
    ButtonStyle->"Hyperlink"],
  ". We will demonstrate in this section how the functions of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " can be exerted to derive the determining equations. In addition, we will \
solve the determining equations interactively and automatically."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "heat equation", "Boussinesq equation", "Burgers equation", 
    "Fitzhugh Nagumo equation"}],

Cell[CellGroupData[{

Cell["6.3.1 The Heat Equation", "Subsection",
  CellTags->"The heat equation"],

Cell[TextData[{
  "Let us start with the well-studied heat equation by ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  ". The scaled heat equation in (1+1) dimensions reads"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"heat equation"],

Cell[BoxData[
    \(TraditionalForm\`\(\(u\_t - u\_\(x, x\) = 0, \)\ \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is the field describing the variation of a scaled temperature in a pipe, \
for example. The heat equation is one of the rare examples which allows the \
study of different solution procedures. In S",
  ButtonBox["ection 5.6.1",
    ButtonData:>{"symmet51.nb", "The diffusion equation"},
    ButtonStyle->"Hyperlink"],
  ", we examined the heat equation with the classical method of Lie. The \
result was a six-dimensional discrete symmetry group in connection with an \
infinite dimensional group. Here, we will examine the heat equation again by \
using the non-classical method. The determining equations are derived with \
the help of ",
  StyleBox["Lie[]", "MmaText"],
  " in connection with two options of the function. The equation of motion in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is created by"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "temperature", "non-classical method and heat equation", "Lie[]"}],

Cell[BoxData[
    \(\(U\  = \ u[x, t]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(diffus\  = \ {\[PartialD]\_t U - \[PartialD]\_\(x, x\)U\ }; 
    diffus // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We first extend our database by a file containing the information on the \
equation. The left-hand side of the heat equation (6.17) is stored to the \
file ",
  StyleBox["ncdiffu.dgl", "MmaText",
    FontSlant->"Italic"],
  " by applying ",
  StyleBox["LieEquations[]:", "MmaText"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"LieEquations[]"],

Cell[BoxData[
    \(LieEquations["\<ncdiffu.dgl\>", diffus, {u}, {x, t}, {}, 
      \n{"\<Heat equation\>"}, {{"\<G. Baumann\>"}, {"\<Ulm 1997\>"}}]\)], 
  "Input"],

Cell[TextData[{
  "The file ",
  StyleBox["ncdiffu.dgl",
    FontSlant->"Italic"],
  " contains all the necessary information to start the analysis. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The information in the file is contained in global variables. The variable \
",
  StyleBox["Title", "MmaText",
    FontSlant->"Italic"],
  StyleBox[",", "MmaText"],
  " for example, contains a headline describing the purpose of the equation. \
The variable ",
  StyleBox["Source", "MmaText",
    FontSlant->"Italic"],
  " carries, in sublists, information on the origin of the equation. The \
remaining variables such as ",
  StyleBox["IndepVar", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["DependVar", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["EqList", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["SubsList", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["ParameterS", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["ListXi", "MmaText",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["ListPhi", "MmaText",
    FontSlant->"Italic"],
  " contain information on the independent and dependent variables, the \
equation of motion, the terms for which the side condition in the classical \
method is solved, a list of parameters, and two lists for the infinitesimals, \
respectively. All information contained in the file is necessary for the \
function ",
  StyleBox["Lie[]", "MmaText"],
  " to carry out a symmetry analysis. The non-classical symmetry method is \
initiated by using ",
  StyleBox["Lie[]", "MmaText"],
  " in connection with the option ",
  StyleBox["NonclassicalSymmetries\[Rule]True", "MmaText",
    FontSlant->"Italic"],
  ". The option ",
  StyleBox["NonclassicalCases\[Rule]{t}", "MmaText",
    FontSlant->"Italic"],
  " of ",
  StyleBox["Lie[] ", "MmaText"],
  "selects those terms of the characteristic equations which contain a \
derivative with respect to the specified variable, here ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", meaning that all higher derivatives containing a partial derivative with \
respect to ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " are used to match and eliminate the terms in the original equation. We \
start the non-classical symmetry analysis for the heat equation by"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "non-classical symmetry method", "NonclassicalSymmetries", 
    "NonclassicalCases", "characteristic equations", 
    "non-classical symmetry analysis"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lie["\<ncdiffu.dgl\>", NonclassicalSymmetries \[Rule] True, \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ NonclassicalCases \[Rule] {t}] // 
      LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u\) == 0\)},
          {
            \(\[Phi]\_1\ \((\[Xi]\_2)\)\_u + \[Xi]\_1\ \((\[Xi]\_2)\)\_x + 
                \[Xi]\_2\ \((\[Xi]\_2)\)\_\(x, x\) == 0\)},
          {
            \(\(-\[Xi]\_2\%2\)\ \((\[Xi]\_1)\)\_t + 
                2\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_2)\)\_t + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\%2\ \((\[Xi]\_2)\)\_x + 
                \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-2\)\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_2)\)\_t + 
                \[Phi]\_1\%2\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_x - 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_t + 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {
            \(2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_2\ \((\[Xi]\_1)\)\_\(x, u\) + 
                \[Xi]\_2\ \((\[Phi]\_1)\)\_\(u, u\) == 0\)}
          },
        RowSpacings->2,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a non-linear coupled system of nine partial differential \
equations determining the non-classical symmetries of the heat equation. Our \
task is to solve the determining equations. If we have information on the \
structure of the infinitesimals, we can incorporate this information into the \
database file ",
  StyleBox["ncdiffu.dgl", "MmaText",
    FontSlant->"Italic"],
  ". The extension of the file will simplify the determining equations in the \
solution procedure. Let us first store the following relations into ",
  StyleBox["ncdiffu.dgl", "MmaText",
    FontSlant->"Italic"],
  StyleBox[":", "MmaText"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "nonlinear coupled system of partial differential equations", 
    "non-classical symmetries", "infinitesimals"}],

Cell[BoxData[
    \(ListXi\  = \ {\(xi[1]\)[x, t, u[x, t]], 1}; \n
    ListPhi\  = \ {\(phi[1]\)[x, t, u[x, t]]}; \)], "Input"],

Cell[BoxData[
    \(\(Save["\<ncdiffu.dgl\>", ListXi, ListPhi]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Save[] ", "MmaText"],
  "appends the two relations on the infinitesimals to the file ",
  StyleBox["ncdiffu.dgl", "MmaText",
    FontSlant->"Italic"],
  ". The gathered information can now be used to simplify the determining \
equations by starting the analysis a second time. Since we provided the \
database file with new information, we can activate this information by \
setting the option ",
  StyleBox["NonclassicalInfo\[Rule]True", "MmaText",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Save[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lie["\<ncdiffu.dgl\>", NonclassicalSymmetries \[Rule] True, 
        NonclassicalCases \[Rule] {t}, NonclassicalInfo \[Rule] True] // LTF
      \)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {
            \(2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u - 2\ \((\[Xi]\_1)\)\_\(x, u\) + 
                \((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {
            \(\(-2\)\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x - \((\[Phi]\_1)\)\_t + 
                \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + 2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_x + \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We end up with four non-linear determining equations. We realize that the \
number of equations is reduced by five. Although the equations are still \
non-linear, we have a good chance to solve them. First, we observe that not \
all equations are coupled. Thus, the strategy is to extract those equations \
which are simple and linear. Solving this subset of equations will provide us \
with more information on the infinitesimals. This information is essential to \
solve the remaining non-linear determining equations. The first equation of \
the determining equations states that ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[1] allows a solution which is independent of the dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Thus, we can use this information to extend our file ",
  StyleBox["ncdiffu.dgl ",
    FontSlant->"Italic"],
  "with"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"nonlinear determining equations"],

Cell[BoxData[{
    \(Clear[A]\), 
    \(ListXi\  = \ {A[x, t], 1}; \nListPhi\  = \ {\(phi[1]\)[x, t, u[x, t]]}; 
    \nSave["\<ncdiffu.dgl\>", ListXi, ListPhi]; \)}], "Input"],

Cell[TextData[{
  "Running the function ",
  StyleBox["Lie[]", "MmaText"],
  " again and using the new information in the file, we get"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Lie[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lie["\<ncdiffu.dgl\>", NonclassicalSymmetries \[Rule] True, 
        NonclassicalCases \[Rule] {t}, NonclassicalInfo \[Rule] True] // LTF
      \)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {
            \(\(-A\_t\) - 2\ A\ A\_x + A\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-2\)\ A\_x\ \[Phi]\_1 - \((\[Phi]\_1)\)\_t + 
                \((\[Phi]\_1)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting three equations are again simplified and determine the \
infinitesimals. A glance at these equations shows that we get a mixed system \
of linear and non-linear determining equations. The linear equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\(u, u\) = 0\)]],
  " serves to gain additional information on the structure of the  \
infinitesimals. This equation allows us to represent \[Phi] as a linear \
function in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Thus, we set the infinitesimals to"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"infinitesimals"],

Cell[BoxData[
    \(\(ListXi\  = \ {A[x, t], 1}; \)\)], "Input"],

Cell[TextData["as before, and \[Phi] as"], "Text"],

Cell[BoxData[
    \(\(ListPhi\  = \ {B[x, t]\  + \ C[x, t]\ u[x, t]}; \)\)], "Input"],

Cell[TextData[{
  "where ",
  StyleBox["B[x,t]",
    FontSlant->"Italic"],
  " and ",
  StyleBox["C[x,t] ",
    FontSlant->"Italic"],
  "are arbitrary functions. Saving this result,"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Save["\<ncdiffu.dgl\>", ListXi, ListPhi]; \)\)], "Input"],

Cell["and starting the calculation again by", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdiffu\  = \ 
      Lie["\<ncdiffu.dgl\>", NonclassicalSymmetries -> True, \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ NonclassicalCases -> {t}, \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ NonclassicalInfo -> True]; 
    ncdiffu // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-A\_t\) - 2\ A\ A\_x - 2\ C\_x + A\_\(x, x\) == 0\)},
          {\(\(-2\)\ B\ A\_x - B\_t + B\_\(x, x\) == 0\)},
          {\(\(-2\)\ C[x, t]\ A\_x - C\_t + C\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "reveals a system of three coupled non-linear equations for the unknown \
functions ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", ",
  StyleBox["B",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["C",
    FontSlant->"Italic"],
  ". This system of equations determines the infinitesimals of the  \
non-classical group. At this stage, we clearly face the problem that starting \
 with a linear PDE, we end up with a non-linear one. This system of \
non-linear PDEs is difficult to solve. However, in our analysis, we only need \
special solutions of this equation to find new solutions of the heat \
equation. We already know a method to analyze such non-linear equations. \
Applying Lie's point symmetry procedure in the usual way, we get the \
symmetries of these equations. The symmetries of the three coupled PDEs read"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"non-classical group", "Lie's point symmetry procedure"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(incdiffu\  = \ Infinitesimals[ncdiffu, {A, B, C}, {x, t}]; 
    incdiffu // LTF\)], "Input"],

Cell[BoxData[
    \(PDESolve::"nsf" \( : \ \) 
      "Use option Standard->True. \n This may lead to further solutions in \
case of\n\:f39flinear Systems"\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k1", "-", \(2\ k5\ t\), "+", 
                StyleBox[\(\(k3\ x\)\/2\),
                  ScriptLevel->0], "-", 
                StyleBox[\(\(2\ k7\ t\ x\)\/5\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{"k2", "+", \(k3\ t\), "-", 
                StyleBox[\(\(2\ k7\ t\^2\)\/5\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(1\/10\),
                  ScriptLevel->0], " ", 
                \((\(-5\)\ A\ k3 - 20\ k5 + 4\ A\ k7\ t - 4\ k7\ x)\)}]}]},
          {
            RowBox[{\(\[Phi]\_2\), "==", 
              RowBox[{
                RowBox[{"B", " ", 
                  RowBox[{"(", 
                    RowBox[{
                    "k4", "+", "k6", "+", \(k7\ t\), "+", \(k5\ x\), "+", 
                      StyleBox[\(\(k7\ x\^2\)\/10\),
                        ScriptLevel->0]}], ")"}]}], "+", 
                \(C\ \[ScriptCapitalF]\_1\), "-", 
                \(A\ \((\[ScriptCapitalF]\_1)\)\_x\), "-", 
                \(\((\[ScriptCapitalF]\_1)\)\_\(x, x\)\)}]}]},
          {
            RowBox[{\(\[Phi]\_3\), "==", 
              RowBox[{
                StyleBox[\(1\/5\),
                  ScriptLevel->0], " ", 
                \((\(-5\)\ C\ k3 + 5\ A\ k5 + k7 + 4\ C\ k7\ t + A\ k7\ x)
                  \)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k1, 
            Times[ -2, k5, t], 
            Times[ 
              Rational[ 1, 2], k3, x], 
            Times[ 
              Rational[ -2, 5], k7, t, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k2, 
            Times[ k3, t], 
            Times[ 
              Rational[ -2, 5], k7, 
              Power[ t, 2]]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 10], 
            Plus[ 
              Times[ -5, A, k3], 
              Times[ -20, k5], 
              Times[ 4, A, k7, t], 
              Times[ -4, k7, x]]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Plus[ 
            Times[ B, 
              Plus[ k4, k6, 
                Times[ k7, t], 
                Times[ k5, x], 
                Times[ 
                  Rational[ 1, 10], k7, 
                  Power[ x, 2]]]], 
            Times[ C, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, A, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x, x]]]], 
        Equal[ 
          Subscript[ \[Phi], 3], 
          Times[ 
            Rational[ 1, 5], 
            Plus[ 
              Times[ -5, C, k3], 
              Times[ 5, A, k5], k7, 
              Times[ 4, C, k7, t], 
              Times[ A, k7, x]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is that the three coupled PDEs for the non-classical symmetries \
posses a seven-dimensional discrete symmetry group. In addition, there exist \
an infinite dimensional group given by the function ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[1]. This arbitrary function has to satisfy the heat equation. The \
symmetries of the non-classical determining equations exhibit a similar \
structure as the point symmetries of the heat equation. The symmetries can \
now be used to find special solutions for the functions ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", ",
  StyleBox["B",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["C",
    FontSlant->"Italic"],
  ". First, we select the subgroup with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"heat equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      \({{\(xi[1]\)[x, t, A, B, C], \(xi[2]\)[x, t, A, B, C]}, {
              \(phi[1]\)[x, t, A, B, C], \n\(phi[2]\)[x, t, A, B, C], 
              \(phi[3]\)[x, t, A, B, C]}}\  /. \ 
          incdiffu\[LeftDoubleBracket]1\[RightDoubleBracket]\)\  /. 
        \n{k1 -> 0, k2 -> 1, k3 -> 0, k4 -> 0, k5 -> 0, k6 -> 0, k7 -> 0, 
          free[_] \[Rule] Function[{x, t}, 0]}\)], "Input"],

Cell[BoxData[
    \({{0, 1}, {0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell["\<\
The corresponding reduction of the non-classical determining \
equations follow with this representation of the infinitesimals by\
\>", 
  "Text",
  CellTags->"reduction of the non-classical determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red\  = \ 
      LieReduction[ncdiffu, {A, B, C}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \(red // Flatten\) // LTF /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(x - zeta1 == 0\)},
          {\(A - F\_1 == 0\)},
          {\(B - F\_2 == 0\)},
          {\(C - F\_3 == 0\)},
          {
            \(\(-2\)\ F3\_zeta1 - 2\ F\_1\ \((F\_1)\)\_zeta1 + 
                \((F\_1)\)\_\(zeta1, zeta1\) == 0\)},
          {\(\(-2\)\ F\_2\ F1\_zeta1 + \((F\_2)\)\_\(zeta1, zeta1\) == 0\)},
          {\(\(-2\)\ F\_3\ F1\_zeta1 + \((F\_3)\)\_\(zeta1, zeta1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The similarity representation of the non-linear determining equations is \
given by three coupled non-linear ODEs. To simplify things, let us assume \
that the functions ",
  Cell[BoxData[
      \(TraditionalForm\`F2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`F3\)]],
  " are given by the trivial solutions"
}], "Text",
  CellTags->
  "similarity representation of the nonlinear determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(redh\  = \ 
      red\[LeftDoubleBracket]3\[RightDoubleBracket]\  /. 
        \ {F3 \[Rule] Function[zeta1, 0], F2 \[Rule] Function[zeta1, 0]}\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(-2\), " ", \(F1[zeta1]\), " ", 
              RowBox[{
                SuperscriptBox["F1", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["F1", "\[DoublePrime]",
                MultilineFunction->None], "[", "zeta1", "]"}]}], "==", "0"}], 
        ",", "True", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The substitution of ",
  Cell[BoxData[
      \(TraditionalForm\`F2 = 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`F3 = 0\)]],
  " into the reduced equations simplifies the system to a single equation. \
This equation is solved by ",
  StyleBox["DSolve[]", "MmaText"]
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ 
      DSolve[redh\[LeftDoubleBracket]1\[RightDoubleBracket], F1, zeta1]\)], 
  "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((\@C[2]\ Tan[#1\ \@C[2] + C[1]\ \@C[2]]&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
The solution simplifies further if we specify the constants of \
integration in a certain way:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ 
      \((\ F1[zeta1]\  /. sol1\ )\) /. {C[1] \[Rule] 0, 
            C[2] \[Rule] \[Alpha]\^2} // Simplify\)], "Input"],

Cell[BoxData[
    \({\@\[Alpha]\^2\ Tan[zeta1\ \@\[Alpha]\^2]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The final solution for the unknown functions ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", ",
  StyleBox["B",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["C",
    FontSlant->"Italic"],
  " of the non-classical determining equations is thus given by"
}], "Text",
  CellTags->"solution of the non-classical determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rsol\  = \ 
      Solve[\(\(red\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. \ sol1
                \)\  /. 
              \ {F3 \[Rule] Function[zeta1, 0], F2 \[Rule] Function[zeta1, 0]}
                \) /. {C[1] \[Rule] 0, C[2] \[Rule] \[Alpha]\^2} // 
          Simplify, {A, B, C}]\)], "Input"],

Cell[BoxData[
    \({{A \[Rule] \@\[Alpha]\^2\ Tan[x\ \@\[Alpha]\^2], B \[Rule] 0, 
        C \[Rule] 0}}\)], "Output"]
}, Open  ]],

Cell["\<\
We can check that this special solution satisfies the determining \
equations by rewriting the above results in a pure function form:\
\>", "Text",\

  CellTags->"pure function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infired\  = 
      \ {A \[Rule] Function[{x, t}, \@\[Alpha]\^2\ Tan[x\ \@\[Alpha]\^2]], 
        B \[Rule] Function[{x, t}, 0], C \[Rule] Function[{x, t}, 0]}; 
    infired // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(A == \@\[Alpha]\^2\ Tan[x\ \@\[Alpha]\^2]\)},
          {\(B == 0\)},
          {\(C == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ A, 
          Times[ 
            Power[ 
              Power[ \[Alpha], 2], 
              Rational[ 1, 2]], 
            Tan[ 
              Times[ x, 
                Power[ 
                  Power[ \[Alpha], 2], 
                  Rational[ 1, 2]]]]]], 
        Equal[ B, 0], 
        Equal[ C, 0]}]]], "Output"]
}, Open  ]],

Cell["\<\
Inserting this representation of the solution into the non-linear \
determining equations, we find that the equations are identically \
satisfied:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdiffu\  /. infired // Simplify\)], "Input"],

Cell[BoxData[
    \({0, 0, 0}\)], "Output"]
}, Open  ]],

Cell["\<\
The non-classical infinitesimals for the heat equation are thus \
given by\
\>", "Text",
  CellTags->"non-classical infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(infdifus\  = \ {ListXi, ListPhi}\  /. \ infired\ \)\)], "Input"],

Cell[BoxData[
    \({{\@\[Alpha]\^2\ Tan[x\ \@\[Alpha]\^2], 1}, {0}}\)], "Output"]
}, Open  ]],

Cell["\<\
representing a special transformation under which the heat equation \
is invariant. The reduction of the heat equation with these infinitesimals \
follows:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rdiffus\  = \ 
      LieReduction[diffus, {u}, {x, t}, 
        infdifus\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infdifus\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \(rdiffus\  // Flatten\) // LTF /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Message"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(-zeta1\), "-", 
                
                StyleBox[
                  \(\(\(-t\)\ \[Alpha]\^2 + 
                        Log[Sin[x\ \[Alpha]]]\)\/\[Alpha]\^2\),
                  ScriptLevel->0]}], "==", "0"}]},
          {\(u - F\_1 == 0\)},
          {
            \(\((E\^\(2\ t\ \[Alpha]\^2\) - E\^\(2\ zeta1\ \[Alpha]\^2\))\)\ 
                \((\[Alpha]\^2\ F1\_zeta1 + F1\_\(zeta1, zeta1\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The similarity representation of the heat equation is an expression \
combining trigonometric and logarithmic functions. The unknown function ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " of this reduction is determined by a second-order ODE. This ODE is solved \
 by ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"similarity representation"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"srdiffus", " ", "=", " ", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(\[Alpha]\^2\), " ", 
                  RowBox[{
                    SuperscriptBox["F1", "\[Prime]",
                      MultilineFunction->None], "[", "zeta1", "]"}]}], "+", 
                RowBox[{
                  SuperscriptBox["F1", "\[DoublePrime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}], ")"}], 
            "==", "0"}], ",", "F1", ",", "zeta1"}], "]"}]}]], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((\(-\(\(E\^\(\(-\[Alpha]\^2\)\ #1\)\ C[1]\)\/\[Alpha]\^2\)\) + 
                C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an exponential solution containing two constants of \
integration ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2]. In original variables, the solution reads"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = \ 
      Solve[\((rdiffus\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. \ 
                srdiffus)\) // Simplify, u] // Flatten\)], "Input"],

Cell[BoxData[
    \({u \[Rule] 
        C[2] - \(E\^\(\(-t\)\ \[Alpha]\^2\)\ C[1]\ 
              Sin[x\ \[Alpha]]\)\/\[Alpha]\^2}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we specify the parameters \[Alpha], ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1], and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2] in an appropriate way, we can graphically represent the solution by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Plot3D[
      Evaluate[\(u /. sol\)\  /. {\[Alpha] \[Rule] 1/2, C[1] \[Rule] 1, 
            C[2] \[Rule] 2}], {x, \(-3\) \[Pi], 3  \[Pi]}, {t, 0, 6}, 
      AxesLabel \[Rule] {"\<x\>", "\<t\>", "\<u\>"}, PlotPoints \[Rule] 25]
      \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.55112e-17 1.04977 -0.0679587 1.04977 [
[.16712 .19126 -11.837 -9 ]
[.16712 .19126 .16295 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.51313 .05518 -5.25488 -9 ]
[.51313 .05518 .74512 0 ]
[.29165 .07573 -9.31117 -15 ]
[.29165 .07573 .68883 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.80849 .15988 0 -6.10118 ]
[.80849 .15988 6 2.89882 ]
[.90119 .30183 0 -5.96721 ]
[.90119 .30183 6 3.03279 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02411 .26511 -12 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -6 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -6 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.17627 .20066 m
.18085 .20537 L
s
[(-5)] .16712 .19126 .97284 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.52102 .06567 m
.52496 .07092 L
s
[(5)] .51313 .05518 .75163 1 Mshowa
.125 Mabswid
.20879 .18793 m
.2115 .19079 L
s
.24172 .17504 m
.2444 .17792 L
s
.27507 .16198 m
.27771 .1649 L
s
.30885 .14875 m
.31146 .1517 L
s
.37773 .12178 m
.38026 .1248 L
s
.41285 .10803 m
.41534 .11108 L
s
.44843 .0941 m
.45088 .09718 L
s
.48448 .07998 m
.48689 .08309 L
s
.14416 .21324 m
.14694 .21603 L
s
.11245 .22566 m
.11526 .22842 L
s
.08113 .23792 m
.08396 .24065 L
s
.05019 .25004 m
.05305 .25274 L
s
.55805 .05117 m
.56037 .05435 L
s
.59558 .03648 m
.59785 .03969 L
s
.63363 .02158 m
.63585 .02483 L
s
.67219 .00648 m
.67437 .00976 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.79613 .16428 m
.78995 .16648 L
s
[(2)] .80849 .15988 -1 .35582 Mshowa
.88871 .30589 m
.88247 .30793 L
s
[(4)] .90119 .30183 -1 .32605 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(6)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.71716 .04348 m
.71349 .04489 L
s
.7445 .0853 m
.74081 .08667 L
s
.7708 .12553 m
.7671 .12688 L
s
.82054 .20161 m
.81682 .20291 L
s
.84407 .23761 m
.84035 .23888 L
s
.86679 .27235 m
.86305 .2736 L
s
.9099 .3383 m
.90615 .3395 L
s
.93037 .36962 m
.92662 .3708 L
s
.95018 .39992 m
.94642 .40107 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(-2)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(0)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(2)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(4)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(6)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03427 .2734 m
.03794 .27198 L
s
.03218 .28658 m
.03585 .28517 L
s
.03007 .29987 m
.03375 .29847 L
s
.0258 .3268 m
.02949 .32541 L
s
.02364 .34044 m
.02733 .33906 L
s
.02146 .3542 m
.02515 .35283 L
s
.01704 .38208 m
.02074 .38072 L
s
.01481 .3962 m
.0185 .39485 L
s
.01255 .41045 m
.01625 .40911 L
s
.00797 .43933 m
.01168 .43801 L
s
.00565 .45397 m
.00936 .45265 L
s
.00331 .46873 m
.00703 .46743 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.627 .718 .912 r
.38946 .66645 .40247 .67947 .42427 .67492 .41136 .66192 Metetra
.553 .694 .933 r
.41136 .66192 .42427 .67492 .4462 .67347 .43336 .66071 Metetra
.477 .668 .947 r
.43336 .66071 .4462 .67347 .46834 .67444 .45557 .66208 Metetra
.421 .652 .955 r
.45557 .66208 .46834 .67444 .49073 .67675 .47804 .66488 Metetra
.409 .656 .96 r
.47804 .66488 .49073 .67675 .51343 .67908 .50082 .66772 Metetra
.448 .686 .966 r
.50082 .66772 .51343 .67908 .53642 .68011 .52392 .66917 Metetra
.525 .727 .966 r
.52392 .66917 .53642 .68011 .55968 .67865 .5473 .66796 Metetra
.611 .765 .953 r
.5473 .66796 .55968 .67865 .58316 .6739 .57091 .66323 Metetra
.684 .787 .929 r
.57091 .66323 .58316 .6739 .60677 .66555 .59467 .65466 Metetra
.734 .796 .901 r
.59467 .65466 .60677 .66555 .63046 .65387 .61852 .64252 Metetra
.764 .795 .879 r
.61852 .64252 .63046 .65387 .65419 .63962 .6424 .62764 Metetra
.776 .79 .864 r
.6424 .62764 .65419 .63962 .67796 .62396 .66632 .61126 Metetra
.773 .781 .859 r
.66632 .61126 .67796 .62396 .70182 .60825 .69032 .59483 Metetra
.757 .77 .863 r
.69032 .59483 .70182 .60825 .72583 .59382 .71447 .57978 Metetra
.728 .756 .875 r
.71447 .57978 .72583 .59382 .75011 .58181 .73888 .56731 Metetra
.685 .738 .891 r
.73888 .56731 .75011 .58181 .77476 .57297 .76368 .55824 Metetra
.63 .715 .908 r
.76368 .55824 .77476 .57297 .79989 .56759 .78895 .55285 Metetra
.568 .69 .923 r
.78895 .55285 .79989 .56759 .82556 .56541 .81478 .5509 Metetra
.51 .668 .934 r
.81478 .5509 .82556 .56541 .85177 .56573 .84117 .55161 Metetra
.471 .656 .941 r
.84117 .55161 .85177 .56573 .87848 .56743 .86808 .55381 Metetra
.463 .662 .948 r
.86808 .55381 .87848 .56743 .90556 .56915 .89538 .55604 Metetra
.49 .686 .954 r
.89538 .55604 .90556 .56915 .93287 .5695 .92291 .5568 Metetra
.546 .723 .956 r
.92291 .5568 .93287 .5695 .96022 .56727 .95048 .55481 Metetra
.616 .762 .949 r
.95048 .55481 .96022 .56727 .98744 .5616 .97791 .54915 Metetra
.625 .716 .911 r
.37627 .65315 .38946 .66645 .41136 .66192 .39825 .64864 Metetra
.545 .69 .934 r
.39825 .64864 .41136 .66192 .43336 .66071 .42034 .64768 Metetra
.461 .661 .948 r
.42034 .64768 .43336 .66071 .45557 .66208 .44261 .64949 Metetra
.4 .641 .954 r
.44261 .64949 .45557 .66208 .47804 .66488 .46515 .65283 Metetra
.386 .645 .959 r
.46515 .65283 .47804 .66488 .50082 .66772 .48801 .65621 Metetra
.429 .678 .967 r
.48801 .65621 .50082 .66772 .52392 .66917 .51121 .65811 Metetra
.514 .724 .968 r
.51121 .65811 .52392 .66917 .5473 .66796 .53471 .65718 Metetra
.608 .765 .955 r
.53471 .65718 .5473 .66796 .57091 .66323 .55846 .65248 Metetra
.686 .79 .929 r
.55846 .65248 .57091 .66323 .59467 .65466 .58237 .64368 Metetra
.739 .798 .9 r
.58237 .64368 .59467 .65466 .61852 .64252 .60638 .63106 Metetra
.769 .797 .876 r
.60638 .63106 .61852 .64252 .6424 .62764 .63042 .61551 Metetra
.781 .791 .861 r
.63042 .61551 .6424 .62764 .66632 .61126 .6545 .59836 Metetra
.779 .782 .856 r
.6545 .59836 .66632 .61126 .69032 .59483 .67864 .58116 Metetra
.762 .77 .86 r
.67864 .58116 .69032 .59483 .71447 .57978 .70293 .56545 Metetra
.732 .756 .872 r
.70293 .56545 .71447 .57978 .73888 .56731 .72748 .5525 Metetra
.687 .737 .889 r
.72748 .5525 .73888 .56731 .76368 .55824 .75241 .54318 Metetra
.628 .713 .908 r
.75241 .54318 .76368 .55824 .78895 .55285 .77784 .53779 Metetra
.562 .686 .923 r
.77784 .53779 .78895 .55285 .81478 .5509 .80383 .53609 Metetra
.499 .661 .934 r
.80383 .53609 .81478 .5509 .84117 .55161 .8304 .53723 Metetra
.457 .648 .941 r
.8304 .53723 .84117 .55161 .86808 .55381 .8575 .53996 Metetra
.448 .653 .948 r
.8575 .53996 .86808 .55381 .89538 .55604 .88502 .54273 Metetra
.477 .68 .955 r
.88502 .54273 .89538 .55604 .92291 .5568 .91278 .54395 Metetra
.538 .72 .958 r
.91278 .54395 .92291 .5568 .95048 .55481 .94058 .54222 Metetra
.613 .762 .951 r
.94058 .54222 .95048 .55481 .97791 .54915 .96822 .53657 Metetra
.623 .713 .911 r
.36289 .63956 .37627 .65315 .39825 .64864 .38496 .63508 Metetra
.537 .685 .934 r
.38496 .63508 .39825 .64864 .42034 .64768 .40712 .6344 Metetra
.445 .652 .948 r
.40712 .6344 .42034 .64768 .44261 .64949 .42945 .63667 Metetra
.376 .629 .952 r
.42945 .63667 .44261 .64949 .46515 .65283 .45206 .64058 Metetra
.36 .633 .957 r
.45206 .64058 .46515 .65283 .48801 .65621 .475 .64456 Metetra
.408 .668 .967 r
.475 .64456 .48801 .65621 .51121 .65811 .49829 .64695 Metetra
.501 .721 .97 r
.49829 .64695 .51121 .65811 .53471 .65718 .52191 .64631 Metetra
.604 .766 .957 r
.52191 .64631 .53471 .65718 .55846 .65248 .5458 .64166 Metetra
.688 .792 .929 r
.5458 .64166 .55846 .65248 .58237 .64368 .56987 .6326 Metetra
.744 .801 .898 r
.56987 .6326 .58237 .64368 .60638 .63106 .59404 .61947 Metetra
.775 .799 .872 r
.59404 .61947 .60638 .63106 .63042 .61551 .61825 .60321 Metetra
.787 .792 .857 r
.61825 .60321 .63042 .61551 .6545 .59836 .64248 .58525 Metetra
.784 .783 .851 r
.64248 .58525 .6545 .59836 .67864 .58116 .66678 .56724 Metetra
.767 .771 .856 r
.66678 .56724 .67864 .58116 .70293 .56545 .69121 .55082 Metetra
.735 .756 .869 r
.69121 .55082 .70293 .56545 .72748 .5525 .7159 .53736 Metetra
.688 .736 .888 r
.7159 .53736 .72748 .5525 .75241 .54318 .74097 .52778 Metetra
.626 .711 .907 r
.74097 .52778 .75241 .54318 .77784 .53779 .76654 .52241 Metetra
.555 .682 .923 r
.76654 .52241 .77784 .53779 .80383 .53609 .79269 .52097 Metetra
.488 .654 .933 r
.79269 .52097 .80383 .53609 .8304 .53723 .81945 .52257 Metetra
.441 .639 .94 r
.81945 .52257 .8304 .53723 .8575 .53996 .84675 .52588 Metetra
.431 .644 .947 r
.84675 .52588 .8575 .53996 .88502 .54273 .87449 .52924 Metetra
.463 .673 .955 r
.87449 .52924 .88502 .54273 .91278 .54395 .90248 .53095 Metetra
.528 .717 .959 r
.90248 .53095 .91278 .54395 .94058 .54222 .93051 .52951 Metetra
.61 .763 .952 r
.93051 .52951 .94058 .54222 .96822 .53657 .95836 .52388 Metetra
.621 .711 .91 r
.34932 .62567 .36289 .63956 .38496 .63508 .37148 .62122 Metetra
.527 .68 .935 r
.37148 .62122 .38496 .63508 .40712 .6344 .39371 .62084 Metetra
.426 .642 .947 r
.39371 .62084 .40712 .6344 .42945 .63667 .4161 .62361 Metetra
.35 .615 .95 r
.4161 .62361 .42945 .63667 .45206 .64058 .43876 .62815 Metetra
.332 .618 .954 r
.43876 .62815 .45206 .64058 .475 .64456 .46177 .63276 Metetra
.385 .658 .966 r
.46177 .63276 .475 .64456 .49829 .64695 .48516 .63568 Metetra
.487 .716 .972 r
.48516 .63568 .49829 .64695 .52191 .64631 .5089 .63537 Metetra
.6 .766 .959 r
.5089 .63537 .52191 .64631 .5458 .64166 .53292 .63076 Metetra
.69 .794 .929 r
.53292 .63076 .5458 .64166 .56987 .6326 .55715 .62144 Metetra
.749 .803 .896 r
.55715 .62144 .56987 .6326 .59404 .61947 .58149 .60777 Metetra
.781 .801 .869 r
.58149 .60777 .59404 .61947 .61825 .60321 .60587 .59075 Metetra
.793 .793 .852 r
.60587 .59075 .61825 .60321 .64248 .58525 .63027 .57192 Metetra
.79 .783 .847 r
.63027 .57192 .64248 .58525 .66678 .56724 .65472 .55305 Metetra
.772 .771 .852 r
.65472 .55305 .66678 .56724 .69121 .55082 .6793 .53589 Metetra
.739 .756 .866 r
.6793 .53589 .69121 .55082 .7159 .53736 .70413 .52189 Metetra
.69 .735 .886 r
.70413 .52189 .7159 .53736 .74097 .52778 .72934 .51204 Metetra
.624 .709 .906 r
.72934 .51204 .74097 .52778 .76654 .52241 .75506 .50669 Metetra
.548 .677 .923 r
.75506 .50669 .76654 .52241 .79269 .52097 .78137 .50553 Metetra
.475 .646 .933 r
.78137 .50553 .79269 .52097 .81945 .52257 .80831 .50763 Metetra
.424 .629 .939 r
.80831 .50763 .81945 .52257 .84675 .52588 .83582 .51157 Metetra
.413 .634 .946 r
.83582 .51157 .84675 .52588 .87449 .52924 .86378 .51556 Metetra
.447 .665 .955 r
.86378 .51556 .87449 .52924 .90248 .53095 .89201 .5178 Metetra
.518 .714 .961 r
.89201 .5178 .90248 .53095 .93051 .52951 .92027 .51667 Metetra
.606 .763 .954 r
.92027 .51667 .93051 .52951 .95836 .52388 .94834 .51106 Metetra
.618 .709 .91 r
.33556 .61147 .34932 .62567 .37148 .62122 .35781 .60706 Metetra
.517 .674 .935 r
.35781 .60706 .37148 .62122 .39371 .62084 .3801 .60699 Metetra
.406 .631 .946 r
.3801 .60699 .39371 .62084 .4161 .62361 .40254 .61031 Metetra
.321 .599 .946 r
.40254 .61031 .4161 .62361 .43876 .62815 .42526 .61552 Metetra
.3 .601 .95 r
.42526 .61552 .43876 .62815 .46177 .63276 .44833 .62081 Metetra
.358 .645 .964 r
.44833 .62081 .46177 .63276 .48516 .63568 .4718 .6243 Metetra
.472 .711 .974 r
.4718 .6243 .48516 .63568 .5089 .63537 .49565 .62434 Metetra
.596 .767 .961 r
.49565 .62434 .5089 .63537 .53292 .63076 .51982 .61979 Metetra
.692 .797 .93 r
.51982 .61979 .53292 .63076 .55715 .62144 .54421 .6102 Metetra
.754 .805 .894 r
.54421 .6102 .55715 .62144 .58149 .60777 .56872 .59595 Metetra
.787 .802 .865 r
.56872 .59595 .58149 .60777 .60587 .59075 .59328 .57813 Metetra
.799 .795 .848 r
.59328 .57813 .60587 .59075 .63027 .57192 .61786 .55837 Metetra
.795 .784 .842 r
.61786 .55837 .63027 .57192 .65472 .55305 .64247 .53859 Metetra
.777 .772 .848 r
.64247 .53859 .65472 .55305 .6793 .53589 .6672 .52064 Metetra
.743 .756 .863 r
.6672 .52064 .6793 .53589 .70413 .52189 .69217 .50607 Metetra
.691 .735 .884 r
.69217 .50607 .70413 .52189 .72934 .51204 .71753 .49594 Metetra
.622 .706 .906 r
.71753 .49594 .72934 .51204 .75506 .50669 .74339 .4906 Metetra
.54 .671 .923 r
.74339 .4906 .75506 .50669 .78137 .50553 .76987 .48976 Metetra
.461 .638 .932 r
.76987 .48976 .78137 .50553 .80831 .50763 .79699 .4924 Metetra
.406 .618 .938 r
.79699 .4924 .80831 .50763 .83582 .51157 .8247 .497 Metetra
.393 .623 .945 r
.8247 .497 .83582 .51157 .86378 .51556 .85289 .50168 Metetra
.43 .657 .955 r
.85289 .50168 .86378 .51556 .89201 .5178 .88135 .50449 Metetra
.507 .71 .962 r
.88135 .50449 .89201 .5178 .92027 .51667 .90985 .5037 Metetra
.603 .763 .956 r
.90985 .5037 .92027 .51667 .94834 .51106 .93815 .49813 Metetra
.615 .706 .909 r
.32161 .59694 .33556 .61147 .35781 .60706 .34395 .59258 Metetra
.506 .668 .935 r
.34395 .59258 .35781 .60706 .3801 .60699 .36629 .59286 Metetra
.384 .619 .944 r
.36629 .59286 .3801 .60699 .40254 .61031 .38877 .59675 Metetra
.289 .581 .941 r
.38877 .59675 .40254 .61031 .42526 .61552 .41153 .60268 Metetra
.265 .582 .944 r
.41153 .60268 .42526 .61552 .44833 .62081 .43466 .60871 Metetra
.329 .631 .961 r
.43466 .60871 .44833 .62081 .4718 .6243 .45821 .61282 Metetra
.455 .705 .975 r
.45821 .61282 .4718 .6243 .49565 .62434 .48218 .61324 Metetra
.591 .767 .964 r
.48218 .61324 .49565 .62434 .51982 .61979 .50649 .60875 Metetra
.695 .799 .93 r
.50649 .60875 .51982 .61979 .54421 .6102 .53104 .59888 Metetra
.759 .808 .892 r
.53104 .59888 .54421 .6102 .56872 .59595 .55574 .58401 Metetra
.793 .804 .861 r
.55574 .58401 .56872 .59595 .59328 .57813 .58048 .56534 Metetra
.805 .796 .843 r
.58048 .56534 .59328 .57813 .61786 .55837 .60524 .5446 Metetra
.801 .785 .838 r
.60524 .5446 .61786 .55837 .64247 .53859 .63002 .52384 Metetra
.782 .772 .844 r
.63002 .52384 .64247 .53859 .6672 .52064 .65491 .50506 Metetra
.747 .756 .86 r
.65491 .50506 .6672 .52064 .69217 .50607 .68002 .48989 Metetra
.693 .734 .882 r
.68002 .48989 .69217 .50607 .71753 .49594 .70552 .47946 Metetra
.62 .703 .905 r
.70552 .47946 .71753 .49594 .74339 .4906 .73153 .47415 Metetra
.532 .666 .922 r
.73153 .47415 .74339 .4906 .76987 .48976 .75817 .47364 Metetra
.446 .628 .931 r
.75817 .47364 .76987 .48976 .79699 .4924 .78547 .47687 Metetra
.386 .606 .936 r
.78547 .47687 .79699 .4924 .8247 .497 .81339 .48219 Metetra
.371 .611 .943 r
.81339 .48219 .8247 .497 .85289 .50168 .84181 .48761 Metetra
.411 .647 .955 r
.84181 .48761 .85289 .50168 .88135 .50449 .87051 .49103 Metetra
.495 .705 .964 r
.87051 .49103 .88135 .50449 .90985 .5037 .89925 .49062 Metetra
.599 .764 .958 r
.89925 .49062 .90985 .5037 .93815 .49813 .92778 .48509 Metetra
.613 .703 .909 r
.30747 .58206 .32161 .59694 .34395 .59258 .32989 .57776 Metetra
.494 .661 .935 r
.32989 .57776 .34395 .59258 .36629 .59286 .35228 .57841 Metetra
.359 .605 .942 r
.35228 .57841 .36629 .59286 .38877 .59675 .37479 .58294 Metetra
.253 .56 .934 r
.37479 .58294 .38877 .59675 .41153 .60268 .39758 .58964 Metetra
.226 .56 .935 r
.39758 .58964 .41153 .60268 .43466 .60871 .42076 .59646 Metetra
.296 .615 .957 r
.42076 .59646 .43466 .60871 .45821 .61282 .44439 .60124 Metetra
.437 .699 .976 r
.44439 .60124 .45821 .61282 .48218 .61324 .46846 .60208 Metetra
.586 .768 .966 r
.46846 .60208 .48218 .61324 .50649 .60875 .49291 .59766 Metetra
.697 .802 .93 r
.49291 .59766 .50649 .60875 .53104 .59888 .51764 .58748 Metetra
.765 .81 .889 r
.51764 .58748 .53104 .59888 .55574 .58401 .54252 .57197 Metetra
.799 .806 .857 r
.54252 .57197 .55574 .58401 .58048 .56534 .56746 .55238 Metetra
.811 .797 .838 r
.56746 .55238 .58048 .56534 .60524 .5446 .5924 .5306 Metetra
.807 .785 .833 r
.5924 .5306 .60524 .5446 .63002 .52384 .61736 .50881 Metetra
.787 .772 .839 r
.61736 .50881 .63002 .52384 .65491 .50506 .64241 .48913 Metetra
.751 .756 .856 r
.64241 .48913 .65491 .50506 .68002 .48989 .66768 .47333 Metetra
.695 .733 .88 r
.66768 .47333 .68002 .48989 .70552 .47946 .69332 .46259 Metetra
.617 .7 .904 r
.69332 .46259 .70552 .47946 .73153 .47415 .71948 .45732 Metetra
.523 .66 .922 r
.71948 .45732 .73153 .47415 .75817 .47364 .74628 .45717 Metetra
.43 .618 .93 r
.74628 .45717 .75817 .47364 .78547 .47687 .77376 .46102 Metetra
.364 .592 .933 r
.77376 .46102 .78547 .47687 .81339 .48219 .80189 .46712 Metetra
.347 .597 .94 r
.80189 .46712 .81339 .48219 .84181 .48761 .83053 .47333 Metetra
.39 .636 .953 r
.83053 .47333 .84181 .48761 .87051 .49103 .85947 .47743 Metetra
.482 .7 .965 r
.85947 .47743 .87051 .49103 .89925 .49062 .88846 .47742 Metetra
.594 .764 .96 r
.88846 .47742 .89925 .49062 .92778 .48509 .91722 .47194 Metetra
.61 .7 .908 r
.29313 .56684 .30747 .58206 .32989 .57776 .31563 .5626 Metetra
.481 .653 .935 r
.31563 .5626 .32989 .57776 .35228 .57841 .33806 .56366 Metetra
.331 .589 .938 r
.33806 .56366 .35228 .57841 .37479 .58294 .3606 .56885 Metetra
.213 .536 .925 r
.3606 .56885 .37479 .58294 .39758 .58964 .38341 .57639 Metetra
.183 .534 .924 r
.38341 .57639 .39758 .58964 .42076 .59646 .40663 .58406 Metetra
.26 .595 .95 r
.40663 .58406 .42076 .59646 .44439 .60124 .43032 .58955 Metetra
.416 .691 .976 r
.43032 .58955 .44439 .60124 .46846 .60208 .4545 .59084 Metetra
.58 .768 .968 r
.4545 .59084 .46846 .60208 .49291 .59766 .47909 .58651 Metetra
.7 .805 .93 r
.47909 .58651 .49291 .59766 .51764 .58748 .504 .57601 Metetra
.771 .813 .886 r
.504 .57601 .51764 .58748 .54252 .57197 .52907 .55981 Metetra
.806 .807 .852 r
.52907 .55981 .54252 .57197 .56746 .55238 .55422 .53925 Metetra
.818 .797 .833 r
.55422 .53925 .56746 .55238 .5924 .5306 .57936 .51636 Metetra
.813 .786 .827 r
.57936 .51636 .5924 .5306 .61736 .50881 .6045 .49348 Metetra
.793 .772 .834 r
.6045 .49348 .61736 .50881 .64241 .48913 .62972 .47285 Metetra
.755 .756 .852 r
.62972 .47285 .64241 .48913 .66768 .47333 .65514 .45638 Metetra
.697 .732 .877 r
.65514 .45638 .66768 .47333 .69332 .46259 .68092 .44531 Metetra
.615 .697 .903 r
.68092 .44531 .69332 .46259 .71948 .45732 .70723 .44009 Metetra
.513 .653 .921 r
.70723 .44009 .71948 .45732 .74628 .45717 .73419 .44033 Metetra
.412 .607 .928 r
.73419 .44033 .74628 .45717 .77376 .46102 .76185 .44485 Metetra
.34 .577 .929 r
.76185 .44485 .77376 .46102 .80189 .46712 .79018 .45179 Metetra
.321 .581 .936 r
.79018 .45179 .80189 .46712 .83053 .47333 .81905 .45886 Metetra
.368 .624 .952 r
.81905 .45886 .83053 .47333 .85947 .47743 .84824 .46367 Metetra
.468 .694 .966 r
.84824 .46367 .85947 .47743 .88846 .47742 .87748 .4641 Metetra
.59 .764 .962 r
.87748 .4641 .88846 .47742 .91722 .47194 .90648 .45868 Metetra
.606 .697 .908 r
.27859 .55124 .29313 .56684 .31563 .5626 .30116 .54708 Metetra
.467 .645 .935 r
.30116 .54708 .31563 .5626 .33806 .56366 .32363 .54857 Metetra
.301 .571 .934 r
.32363 .54857 .33806 .56366 .3606 .56885 .34618 .55448 Metetra
.169 .509 .913 r
.34618 .55448 .3606 .56885 .38341 .57639 .369 .56291 Metetra
.135 .505 .909 r
.369 .56291 .38341 .57639 .40663 .58406 .39225 .5715 Metetra
.22 .573 .941 r
.39225 .5715 .40663 .58406 .43032 .58955 .416 .57777 Metetra
.392 .681 .976 r
.416 .57777 .43032 .58955 .4545 .59084 .44028 .57955 Metetra
.574 .769 .971 r
.44028 .57955 .4545 .59084 .47909 .58651 .46502 .57531 Metetra
.703 .808 .93 r
.46502 .57531 .47909 .58651 .504 .57601 .4901 .56448 Metetra
.777 .815 .883 r
.4901 .56448 .504 .57601 .52907 .55981 .51538 .54754 Metetra
.812 .809 .848 r
.51538 .54754 .52907 .55981 .55422 .53925 .54074 .52595 Metetra
.824 .798 .827 r
.54074 .52595 .55422 .53925 .57936 .51636 .56609 .50188 Metetra
.819 .786 .822 r
.56609 .50188 .57936 .51636 .6045 .49348 .59142 .47783 Metetra
.798 .773 .829 r
.59142 .47783 .6045 .49348 .62972 .47285 .61682 .45621 Metetra
.76 .755 .849 r
.61682 .45621 .62972 .47285 .65514 .45638 .6424 .43903 Metetra
.699 .731 .875 r
.6424 .43903 .65514 .45638 .68092 .44531 .66833 .42761 Metetra
.612 .694 .902 r
.66833 .42761 .68092 .44531 .70723 .44009 .69478 .42244 Metetra
.503 .646 .921 r
.69478 .42244 .70723 .44009 .73419 .44033 .72189 .42311 Metetra
.393 .595 .926 r
.72189 .42311 .73419 .44033 .76185 .44485 .74973 .42835 Metetra
.313 .561 .925 r
.74973 .42835 .76185 .44485 .79018 .45179 .77826 .43618 Metetra
.293 .564 .931 r
.77826 .43618 .79018 .45179 .81905 .45886 .80736 .44417 Metetra
.343 .611 .949 r
.80736 .44417 .81905 .45886 .84824 .46367 .83681 .44976 Metetra
.452 .688 .967 r
.83681 .44976 .84824 .46367 .87748 .4641 .8663 .45067 Metetra
.585 .764 .964 r
.8663 .45067 .87748 .4641 .90648 .45868 .89554 .44533 Metetra
.603 .694 .907 r
.26385 .53526 .27859 .55124 .30116 .54708 .2865 .53118 Metetra
.451 .635 .934 r
.2865 .53118 .30116 .54708 .32363 .54857 .30899 .53314 Metetra
.267 .551 .927 r
.30899 .53314 .32363 .54857 .34618 .55448 .33154 .53983 Metetra
.121 .478 .897 r
.33154 .53983 .34618 .55448 .369 .56291 .35436 .54922 Metetra
.082 .471 .891 r
.35436 .54922 .369 .56291 .39225 .5715 .37761 .55879 Metetra
.175 .548 .929 r
.37761 .55879 .39225 .5715 .416 .57777 .40141 .5659 Metetra
.366 .671 .974 r
.40141 .5659 .416 .57777 .44028 .57955 .42579 .56821 Metetra
.567 .769 .974 r
.42579 .56821 .44028 .57955 .46502 .57531 .45067 .56408 Metetra
.706 .812 .93 r
.45067 .56408 .46502 .57531 .4901 .56448 .47594 .55289 Metetra
.783 .818 .88 r
.47594 .55289 .4901 .56448 .51538 .54754 .50144 .53517 Metetra
.819 .811 .843 r
.50144 .53517 .51538 .54754 .54074 .52595 .52702 .51248 Metetra
.83 .799 .821 r
.52702 .51248 .54074 .52595 .56609 .50188 .55259 .48716 Metetra
.825 .786 .816 r
.55259 .48716 .56609 .50188 .59142 .47783 .57813 .46186 Metetra
.804 .773 .824 r
.57813 .46186 .59142 .47783 .61682 .45621 .60371 .43918 Metetra
.764 .755 .844 r
.60371 .43918 .61682 .45621 .6424 .43903 .62945 .42125 Metetra
.701 .729 .873 r
.62945 .42125 .6424 .43903 .66833 .42761 .65552 .40947 Metetra
.609 .691 .901 r
.65552 .40947 .66833 .42761 .69478 .42244 .68212 .40436 Metetra
.492 .638 .92 r
.68212 .40436 .69478 .42244 .72189 .42311 .70939 .40549 Metetra
.372 .581 .923 r
.70939 .40549 .72189 .42311 .74973 .42835 .7374 .4115 Metetra
.285 .543 .919 r
.7374 .4115 .74973 .42835 .77826 .43618 .76614 .4203 Metetra
.262 .545 .925 r
.76614 .4203 .77826 .43618 .80736 .44417 .79547 .42928 Metetra
.316 .596 .945 r
.79547 .42928 .80736 .44417 .83681 .44976 .82516 .43571 Metetra
.434 .68 .967 r
.82516 .43571 .83681 .44976 .8663 .45067 .85491 .43714 Metetra
.579 .765 .967 r
.85491 .43714 .8663 .45067 .89554 .44533 .88441 .43188 Metetra
.599 .69 .906 r
.24891 .51887 .26385 .53526 .2865 .53118 .27163 .51489 Metetra
.434 .625 .933 r
.27163 .51489 .2865 .53118 .30899 .53314 .29414 .51735 Metetra
.23 .527 .919 r
.29414 .51735 .30899 .53314 .33154 .53983 .31668 .52488 Metetra
.067 .443 .878 r
.31668 .52488 .33154 .53983 .35436 .54922 .33947 .53529 Metetra
.024 .433 .867 r
.33947 .53529 .35436 .54922 .37761 .55879 .36272 .54592 Metetra
.125 .518 .913 r
.36272 .54592 .37761 .55879 .40141 .5659 .38656 .55393 Metetra
.337 .658 .971 r
.38656 .55393 .40141 .5659 .42579 .56821 .41102 .55682 Metetra
.559 .769 .976 r
.41102 .55682 .42579 .56821 .45067 .56408 .43605 .55281 Metetra
.71 .815 .93 r
.43605 .55281 .45067 .56408 .47594 .55289 .46151 .54125 Metetra
.789 .821 .877 r
.46151 .54125 .47594 .55289 .50144 .53517 .48724 .52269 Metetra
.826 .812 .837 r
.48724 .52269 .50144 .53517 .52702 .51248 .51305 .49884 Metetra
.837 .8 .815 r
.51305 .49884 .52702 .51248 .55259 .48716 .53886 .47217 Metetra
.831 .787 .81 r
.53886 .47217 .55259 .48716 .57813 .46186 .56461 .44556 Metetra
.809 .773 .819 r
.56461 .44556 .57813 .46186 .60371 .43918 .59038 .42175 Metetra
.769 .755 .84 r
.59038 .42175 .60371 .43918 .62945 .42125 .61629 .40303 Metetra
.703 .728 .87 r
.61629 .40303 .62945 .42125 .65552 .40947 .64251 .39087 Metetra
.606 .687 .9 r
.64251 .39087 .65552 .40947 .68212 .40436 .66926 .38583 Metetra
.48 .63 .919 r
.66926 .38583 .68212 .40436 .70939 .40549 .69667 .38745 Metetra
.349 .566 .919 r
.69667 .38745 .70939 .40549 .7374 .4115 .72485 .3943 Metetra
.254 .523 .912 r
.72485 .3943 .7374 .4115 .76614 .4203 .75379 .40413 Metetra
.229 .524 .917 r
.75379 .40413 .76614 .4203 .79547 .42928 .78335 .41418 Metetra
.286 .579 .94 r
.78335 .41418 .79547 .42928 .82516 .43571 .8133 .42151 Metetra
.415 .672 .967 r
.8133 .42151 .82516 .43571 .85491 .43714 .84331 .42351 Metetra
.573 .765 .969 r
.84331 .42351 .85491 .43714 .88441 .43188 .87306 .41834 Metetra
.595 .687 .906 r
.23377 .50207 .24891 .51887 .27163 .51489 .25655 .49819 Metetra
.415 .614 .932 r
.25655 .49819 .27163 .51489 .29414 .51735 .27907 .5012 Metetra
.188 .501 .908 r
.27907 .5012 .29414 .51735 .31668 .52488 .30157 .50961 Metetra
.01 .404 .854 r
.30157 .50961 .31668 .52488 .33947 .53529 .32433 .52114 Metetra
0 .39 .838 r
.32433 .52114 .33947 .53529 .36272 .54592 .34756 .5329 Metetra
.07 .484 .893 r
.34756 .5329 .36272 .54592 .38656 .55393 .37143 .54188 Metetra
.304 .643 .967 r
.37143 .54188 .38656 .55393 .41102 .55682 .39597 .54539 Metetra
.551 .769 .979 r
.39597 .54539 .41102 .55682 .43605 .55281 .42115 .54152 Metetra
.713 .819 .93 r
.42115 .54152 .43605 .55281 .46151 .54125 .44681 .52956 Metetra
.796 .823 .873 r
.44681 .52956 .46151 .54125 .48724 .52269 .47276 .51012 Metetra
.832 .813 .832 r
.47276 .51012 .48724 .52269 .51305 .49884 .49884 .48502 Metetra
.843 .8 .809 r
.49884 .48502 .51305 .49884 .53886 .47217 .52489 .45693 Metetra
.837 .787 .803 r
.52489 .45693 .53886 .47217 .56461 .44556 .55087 .42891 Metetra
.815 .772 .813 r
.55087 .42891 .56461 .44556 .59038 .42175 .57684 .40391 Metetra
.773 .754 .836 r
.57684 .40391 .59038 .42175 .61629 .40303 .60292 .38434 Metetra
.705 .727 .867 r
.60292 .38434 .61629 .40303 .64251 .39087 .62929 .37179 Metetra
.602 .683 .899 r
.62929 .37179 .64251 .39087 .66926 .38583 .65618 .36684 Metetra
.467 .621 .917 r
.65618 .36684 .66926 .38583 .69667 .38745 .68374 .36899 Metetra
.325 .55 .915 r
.68374 .36899 .69667 .38745 .72485 .3943 .71209 .37672 Metetra
.221 .501 .904 r
.71209 .37672 .72485 .3943 .75379 .40413 .74122 .38767 Metetra
.192 .5 .907 r
.74122 .38767 .75379 .40413 .78335 .41418 .77101 .39886 Metetra
.254 .56 .934 r
.77101 .39886 .78335 .41418 .8133 .42151 .80121 .40717 Metetra
.394 .662 .966 r
.80121 .40717 .8133 .42151 .84331 .42351 .83149 .40978 Metetra
.566 .765 .972 r
.83149 .40978 .84331 .42351 .87306 .41834 .86151 .40473 Metetra
.591 .683 .905 r
.21842 .48484 .23377 .50207 .25655 .49819 .24126 .48107 Metetra
.394 .601 .93 r
.24126 .48107 .25655 .49819 .27907 .5012 .26377 .48466 Metetra
.143 .472 .894 r
.26377 .48466 .27907 .5012 .30157 .50961 .28623 .49403 Metetra
0 .36 .824 r
.28623 .49403 .30157 .50961 .32433 .52114 .30893 .50674 Metetra
0 .342 .803 r
.30893 .50674 .32433 .52114 .34756 .5329 .33213 .51973 Metetra
.01 .445 .867 r
.33213 .51973 .34756 .5329 .37143 .54188 .35601 .52975 Metetra
.268 .625 .961 r
.35601 .52975 .37143 .54188 .39597 .54539 .38063 .53393 Metetra
.542 .769 .982 r
.38063 .53393 .39597 .54539 .42115 .54152 .40594 .53021 Metetra
.717 .822 .93 r
.40594 .53021 .42115 .54152 .44681 .52956 .43181 .51784 Metetra
.803 .826 .869 r
.43181 .51784 .44681 .52956 .47276 .51012 .45801 .49745 Metetra
.839 .814 .826 r
.45801 .49745 .47276 .51012 .49884 .48502 .48435 .47102 Metetra
.85 .8 .802 r
.48435 .47102 .49884 .48502 .52489 .45693 .51067 .44141 Metetra
.843 .787 .797 r
.51067 .44141 .52489 .45693 .55087 .42891 .5369 .41191 Metetra
.821 .772 .807 r
.5369 .41191 .55087 .42891 .57684 .40391 .56307 .38564 Metetra
.778 .754 .831 r
.56307 .38564 .57684 .40391 .60292 .38434 .58933 .36519 Metetra
.707 .726 .865 r
.58933 .36519 .60292 .38434 .62929 .37179 .61586 .35222 Metetra
.598 .679 .898 r
.61586 .35222 .62929 .37179 .65618 .36684 .64288 .34736 Metetra
.453 .611 .916 r
.64288 .34736 .65618 .36684 .68374 .36899 .67059 .35007 Metetra
.298 .532 .909 r
.67059 .35007 .68374 .36899 .71209 .37672 .6991 .35877 Metetra
.185 .476 .894 r
.6991 .35877 .71209 .37672 .74122 .38767 .72842 .3709 Metetra
.153 .474 .895 r
.72842 .3709 .74122 .38767 .77101 .39886 .75844 .38333 Metetra
.218 .538 .925 r
.75844 .38333 .77101 .39886 .80121 .40717 .78889 .39269 Metetra
.371 .652 .965 r
.78889 .39269 .80121 .40717 .83149 .40978 .81945 .39596 Metetra
.559 .764 .974 r
.81945 .39596 .83149 .40978 .86151 .40473 .84972 .39104 Metetra
.586 .678 .904 r
.20287 .46714 .21842 .48484 .24126 .48107 .22576 .46351 Metetra
.371 .586 .927 r
.22576 .46351 .24126 .48107 .26377 .48466 .24826 .46772 Metetra
.093 .438 .877 r
.24826 .46772 .26377 .48466 .28623 .49403 .27065 .47811 Metetra
0 .311 .789 r
.27065 .47811 .28623 .49403 .30893 .50674 .29327 .49209 Metetra
0 .29 .762 r
.29327 .49209 .30893 .50674 .33213 .51973 .31641 .50639 Metetra
0 .401 .835 r
.31641 .50639 .33213 .51973 .35601 .52975 .34028 .51755 Metetra
.227 .604 .951 r
.34028 .51755 .35601 .52975 .38063 .53393 .36497 .52245 Metetra
.532 .768 .984 r
.36497 .52245 .38063 .53393 .40594 .53021 .39043 .51891 Metetra
.721 .826 .93 r
.39043 .51891 .40594 .53021 .43181 .51784 .41651 .50609 Metetra
.81 .828 .865 r
.41651 .50609 .43181 .51784 .45801 .49745 .44298 .4847 Metetra
.846 .815 .82 r
.44298 .4847 .45801 .49745 .48435 .47102 .4696 .45685 Metetra
.856 .801 .796 r
.4696 .45685 .48435 .47102 .51067 .44141 .4962 .42562 Metetra
.849 .786 .79 r
.4962 .42562 .51067 .44141 .5369 .41191 .52268 .39453 Metetra
.826 .772 .801 r
.52268 .39453 .5369 .41191 .56307 .38564 .54908 .36692 Metetra
.783 .753 .826 r
.54908 .36692 .56307 .38564 .58933 .36519 .57553 .34553 Metetra
.71 .724 .862 r
.57553 .34553 .58933 .36519 .61586 .35222 .60221 .33213 Metetra
.594 .675 .897 r
.60221 .33213 .61586 .35222 .64288 .34736 .62937 .32737 Metetra
.437 .6 .914 r
.62937 .32737 .64288 .34736 .67059 .35007 .65721 .3307 Metetra
.269 .513 .903 r
.65721 .3307 .67059 .35007 .6991 .35877 .68587 .34041 Metetra
.146 .45 .881 r
.68587 .34041 .6991 .35877 .72842 .3709 .71538 .35383 Metetra
.11 .446 .881 r
.71538 .35383 .72842 .3709 .75844 .38333 .74562 .36758 Metetra
.18 .515 .915 r
.74562 .36758 .75844 .38333 .78889 .39269 .77634 .37807 Metetra
.346 .639 .963 r
.77634 .37807 .78889 .39269 .81945 .39596 .80717 .38207 Metetra
.551 .764 .977 r
.80717 .38207 .81945 .39596 .84972 .39104 .83771 .37729 Metetra
.581 .674 .903 r
.18712 .44898 .20287 .46714 .22576 .46351 .21006 .44548 Metetra
.346 .571 .923 r
.21006 .44548 .22576 .46351 .24826 .46772 .23251 .45036 Metetra
.038 .4 .855 r
.23251 .45036 .24826 .46772 .27065 .47811 .25482 .46185 Metetra
0 .257 .747 r
.25482 .46185 .27065 .47811 .29327 .49209 .27734 .4772 Metetra
0 .233 .714 r
.27734 .4772 .29327 .49209 .31641 .50639 .3004 .49291 Metetra
0 .351 .797 r
.3004 .49291 .31641 .50639 .34028 .51755 .32425 .50528 Metetra
.181 .58 .939 r
.32425 .50528 .34028 .51755 .36497 .52245 .34899 .51096 Metetra
.52 .767 .987 r
.34899 .51096 .36497 .52245 .39043 .51891 .37459 .50761 Metetra
.726 .83 .93 r
.37459 .50761 .39043 .51891 .41651 .50609 .40089 .49432 Metetra
.817 .831 .86 r
.40089 .49432 .41651 .50609 .44298 .4847 .42764 .47186 Metetra
.853 .816 .813 r
.42764 .47186 .44298 .4847 .4696 .45685 .45457 .4425 Metetra
.862 .801 .788 r
.45457 .4425 .4696 .45685 .4962 .42562 .48147 .40955 Metetra
.855 .786 .783 r
.48147 .40955 .4962 .42562 .52268 .39453 .50823 .37677 Metetra
.832 .771 .795 r
.50823 .37677 .52268 .39453 .54908 .36692 .53487 .34774 Metetra
.788 .753 .821 r
.53487 .34774 .54908 .36692 .57553 .34553 .5615 .32536 Metetra
.712 .723 .858 r
.5615 .32536 .57553 .34553 .60221 .33213 .58834 .3115 Metetra
.59 .671 .895 r
.58834 .3115 .60221 .33213 .62937 .32737 .61563 .30685 Metetra
.421 .588 .911 r
.61563 .30685 .62937 .32737 .65721 .3307 .64361 .31084 Metetra
.238 .491 .894 r
.64361 .31084 .65721 .3307 .68587 .34041 .67242 .32165 Metetra
.104 .42 .866 r
.67242 .32165 .68587 .34041 .71538 .35383 .7021 .33644 Metetra
.065 .414 .863 r
.7021 .33644 .71538 .35383 .74562 .36758 .73256 .35161 Metetra
.139 .488 .902 r
.73256 .35161 .74562 .36758 .77634 .37807 .76353 .36332 Metetra
.318 .625 .96 r
.76353 .36332 .77634 .37807 .80717 .38207 .79464 .3681 Metetra
.543 .764 .979 r
.79464 .3681 .80717 .38207 .83771 .37729 .82546 .36348 Metetra
.576 .669 .902 r
.17116 .43031 .18712 .44898 .21006 .44548 .19414 .42697 Metetra
.318 .553 .918 r
.19414 .42697 .21006 .44548 .23251 .45036 .21655 .43257 Metetra
0 .358 .829 r
.21655 .43257 .23251 .45036 .25482 .46185 .23875 .44524 Metetra
0 .2 .699 r
.23875 .44524 .25482 .46185 .27734 .4772 .26114 .46204 Metetra
0 .172 .66 r
.26114 .46204 .27734 .4772 .3004 .49291 .28409 .47926 Metetra
0 .297 .752 r
.28409 .47926 .3004 .49291 .32425 .50528 .30789 .49294 Metetra
.131 .551 .922 r
.30789 .49294 .32425 .50528 .34899 .51096 .33267 .49948 Metetra
.508 .766 .989 r
.33267 .49948 .34899 .51096 .37459 .50761 .35842 .49634 Metetra
.73 .835 .929 r
.35842 .49634 .37459 .50761 .40089 .49432 .38495 .48256 Metetra
.824 .833 .856 r
.38495 .48256 .40089 .49432 .42764 .47186 .41199 .45895 Metetra
.86 .817 .806 r
.41199 .45895 .42764 .47186 .45457 .4425 .43925 .42797 Metetra
.868 .8 .781 r
.43925 .42797 .45457 .4425 .48147 .40955 .46647 .39319 Metetra
.861 .786 .776 r
.46647 .39319 .48147 .40955 .50823 .37677 .49353 .35862 Metetra
.837 .771 .788 r
.49353 .35862 .50823 .37677 .53487 .34774 .52042 .32808 Metetra
.793 .752 .816 r
.52042 .32808 .53487 .34774 .5615 .32536 .54725 .30464 Metetra
.714 .721 .855 r
.54725 .30464 .5615 .32536 .58834 .3115 .57425 .2903 Metetra
.586 .666 .894 r
.57425 .2903 .58834 .3115 .61563 .30685 .60167 .28579 Metetra
.403 .576 .908 r
.60167 .28579 .61563 .30685 .64361 .31084 .62977 .29048 Metetra
.205 .467 .885 r
.62977 .29048 .64361 .31084 .67242 .32165 .65872 .30246 Metetra
.06 .388 .849 r
.65872 .30246 .67242 .32165 .7021 .33644 .68857 .31872 Metetra
.017 .38 .843 r
.68857 .31872 .7021 .33644 .73256 .35161 .71924 .33542 Metetra
.094 .458 .887 r
.71924 .33542 .73256 .35161 .76353 .36332 .75047 .34844 Metetra
.287 .609 .955 r
.75047 .34844 .76353 .36332 .79464 .3681 .78185 .35407 Metetra
.533 .763 .982 r
.78185 .35407 .79464 .3681 .82546 .36348 .81296 .34963 Metetra
.57 .663 .901 r
.15499 .41113 .17116 .43031 .19414 .42697 .17801 .40796 Metetra
.287 .533 .912 r
.17801 .40796 .19414 .42697 .21655 .43257 .20035 .41432 Metetra
0 .312 .798 r
.20035 .41432 .21655 .43257 .23875 .44524 .22241 .42825 Metetra
0 .139 .646 r
.22241 .42825 .23875 .44524 .26114 .46204 .24464 .44662 Metetra
0 .11 .6 r
.24464 .44662 .26114 .46204 .28409 .47926 .26746 .46547 Metetra
0 .239 .701 r
.26746 .46547 .28409 .47926 .30789 .49294 .29119 .48055 Metetra
.075 .518 .9 r
.29119 .48055 .30789 .49294 .33267 .49948 .316 .48801 Metetra
.494 .764 .991 r
.316 .48801 .33267 .49948 .35842 .49634 .34189 .48511 Metetra
.735 .839 .929 r
.34189 .48511 .35842 .49634 .38495 .48256 .36866 .4708 Metetra
.831 .836 .85 r
.36866 .4708 .38495 .48256 .41199 .45895 .39602 .44597 Metetra
.866 .818 .799 r
.39602 .44597 .41199 .45895 .43925 .42797 .42363 .41327 Metetra
.874 .8 .774 r
.42363 .41327 .43925 .42797 .46647 .39319 .4512 .37653 Metetra
.867 .785 .769 r
.4512 .37653 .46647 .39319 .49353 .35862 .47858 .34005 Metetra
.843 .77 .781 r
.47858 .34005 .49353 .35862 .52042 .32808 .50573 .30791 Metetra
.798 .751 .81 r
.50573 .30791 .52042 .32808 .54725 .30464 .53278 .28336 Metetra
.717 .72 .852 r
.53278 .28336 .54725 .30464 .57425 .2903 .55993 .26852 Metetra
.581 .661 .892 r
.55993 .26852 .57425 .2903 .60167 .28579 .58748 .26415 Metetra
.384 .562 .905 r
.58748 .26415 .60167 .28579 .62977 .29048 .61569 .26959 Metetra
.168 .441 .873 r
.61569 .26959 .62977 .29048 .65872 .30246 .64477 .28283 Metetra
.012 .353 .829 r
.64477 .28283 .65872 .30246 .68857 .31872 .67479 .30066 Metetra
0 .342 .82 r
.67479 .30066 .68857 .31872 .71924 .33542 .70566 .319 Metetra
.046 .426 .868 r
.70566 .319 .71924 .33542 .75047 .34844 .73714 .33344 Metetra
.254 .591 .948 r
.73714 .33344 .75047 .34844 .78185 .35407 .76881 .33998 Metetra
.522 .762 .984 r
.76881 .33998 .78185 .35407 .81296 .34963 .80021 .33575 Metetra
.564 .658 .9 r
.13863 .39141 .15499 .41113 .17801 .40796 .16167 .38843 Metetra
.253 .51 .904 r
.16167 .38843 .17801 .40796 .20035 .41432 .18392 .39561 Metetra
0 .261 .761 r
.18392 .39561 .20035 .41432 .22241 .42825 .20582 .41088 Metetra
0 .077 .587 r
.20582 .41088 .22241 .42825 .24464 .44662 .22786 .43092 Metetra
0 .046 .536 r
.22786 .43092 .24464 .44662 .26746 .46547 .25051 .45151 Metetra
0 .178 .643 r
.25051 .45151 .26746 .46547 .29119 .48055 .27414 .46811 Metetra
.015 .479 .873 r
.27414 .46811 .29119 .48055 .316 .48801 .29897 .47657 Metetra
.478 .762 .993 r
.29897 .47657 .316 .48801 .34189 .48511 .32499 .47393 Metetra
.74 .844 .928 r
.32499 .47393 .34189 .48511 .36866 .4708 .35202 .45906 Metetra
.839 .838 .845 r
.35202 .45906 .36866 .4708 .39602 .44597 .37971 .43293 Metetra
.873 .818 .792 r
.37971 .43293 .39602 .44597 .42363 .41327 .4077 .39838 Metetra
.88 .8 .766 r
.4077 .39838 .42363 .41327 .4512 .37653 .43565 .35956 Metetra
.872 .784 .761 r
.43565 .35956 .4512 .37653 .47858 .34005 .46337 .32106 Metetra
.848 .769 .774 r
.46337 .32106 .47858 .34005 .50573 .30791 .49081 .28722 Metetra
.803 .751 .805 r
.49081 .28722 .50573 .30791 .53278 .28336 .51807 .2615 Metetra
.719 .718 .848 r
.51807 .2615 .53278 .28336 .55993 .26852 .54539 .24613 Metetra
.576 .655 .891 r
.54539 .24613 .55993 .26852 .58748 .26415 .57307 .24192 Metetra
.363 .547 .901 r
.57307 .24192 .58748 .26415 .61569 .26959 .60138 .24816 Metetra
.129 .413 .86 r
.60138 .24816 .61569 .26959 .64477 .28283 .63057 .26275 Metetra
0 .316 .805 r
.63057 .26275 .64477 .28283 .67479 .30066 .66073 .28226 Metetra
0 .302 .792 r
.66073 .28226 .67479 .30066 .70566 .319 .69181 .30235 Metetra
0 .39 .846 r
.69181 .30235 .70566 .319 .73714 .33344 .72353 .31833 Metetra
.217 .571 .94 r
.72353 .31833 .73714 .33344 .76881 .33998 .75548 .32586 Metetra
.511 .76 .986 r
.75548 .32586 .76881 .33998 .80021 .33575 .78718 .32186 Metetra
.557 .652 .898 r
.12206 .37112 .13863 .39141 .16167 .38843 .14512 .36834 Metetra
.216 .485 .894 r
.14512 .36834 .16167 .38843 .18392 .39561 .16726 .3764 Metetra
0 .206 .717 r
.16726 .3764 .18392 .39561 .20582 .41088 .18897 .39311 Metetra
0 .013 .523 r
.18897 .39311 .20582 .41088 .22786 .43092 .21077 .41494 Metetra
.53 .017 0 r
.21077 .41494 .22786 .43092 .25051 .45151 .23322 .43741 Metetra
0 .114 .58 r
.23322 .43741 .25051 .45151 .27414 .46811 .25673 .45564 Metetra
0 .436 .84 r
.25673 .45564 .27414 .46811 .29897 .47657 .28155 .46518 Metetra
.46 .759 .994 r
.28155 .46518 .29897 .47657 .32499 .47393 .30771 .46282 Metetra
.745 .849 .927 r
.30771 .46282 .32499 .47393 .35202 .45906 .335 .44736 Metetra
.846 .84 .839 r
.335 .44736 .35202 .45906 .37971 .43293 .36305 .41983 Metetra
.879 .818 .784 r
.36305 .41983 .37971 .43293 .4077 .39838 .39145 .38332 Metetra
.886 .799 .758 r
.39145 .38332 .4077 .39838 .43565 .35956 .41981 .34227 Metetra
.878 .783 .753 r
.41981 .34227 .43565 .35956 .46337 .32106 .4479 .30162 Metetra
.854 .769 .767 r
.4479 .30162 .46337 .32106 .49081 .28722 .47564 .26598 Metetra
.807 .75 .799 r
.47564 .26598 .49081 .28722 .51807 .2615 .50314 .23903 Metetra
.722 .716 .845 r
.50314 .23903 .51807 .2615 .54539 .24613 .53063 .22311 Metetra
.57 .65 .889 r
.53063 .22311 .54539 .24613 .57307 .24192 .55841 .21906 Metetra
.34 .53 .896 r
.55841 .21906 .57307 .24192 .60138 .24816 .58682 .22617 Metetra
.088 .383 .844 r
.58682 .22617 .60138 .24816 .63057 .26275 .61611 .24218 Metetra
0 .276 .778 r
.61611 .24218 .63057 .26275 .66073 .28226 .64641 .2635 Metetra
0 .259 .762 r
.64641 .2635 .66073 .28226 .69181 .30235 .67767 .28548 Metetra
0 .352 .82 r
.67767 .28548 .69181 .30235 .72353 .31833 .70963 .3031 Metetra
.177 .547 .929 r
.70963 .3031 .72353 .31833 .75548 .32586 .74187 .3117 Metetra
.498 .758 .988 r
.74187 .3117 .75548 .32586 .78718 .32186 .77387 .30796 Metetra
.55 .645 .897 r
.1053 .35025 .12206 .37112 .14512 .36834 .12836 .34769 Metetra
.175 .457 .882 r
.12836 .34769 .14512 .36834 .16726 .3764 .15037 .35669 Metetra
0 .147 .669 r
.15037 .35669 .16726 .3764 .18897 .39311 .17184 .37493 Metetra
.541 .05 0 r
.17184 .37493 .18897 .39311 .21077 .41494 .19338 .39868 Metetra
.591 .079 0 r
.19338 .39868 .21077 .41494 .23322 .43741 .21558 .42315 Metetra
.482 0 0 r
.21558 .42315 .23322 .43741 .25673 .45564 .23893 .44314 Metetra
0 .387 .799 r
.23893 .44314 .25673 .45564 .28155 .46518 .26373 .45384 Metetra
.441 .755 .995 r
.26373 .45384 .28155 .46518 .30771 .46282 .29002 .4518 Metetra
.751 .854 .926 r
.29002 .4518 .30771 .46282 .335 .44736 .31758 .43571 Metetra
.854 .842 .833 r
.31758 .43571 .335 .44736 .36305 .41983 .34602 .40669 Metetra
.886 .818 .776 r
.34602 .40669 .36305 .41983 .39145 .38332 .37486 .36808 Metetra
.892 .798 .75 r
.37486 .36808 .39145 .38332 .41981 .34227 .40367 .32466 Metetra
.883 .782 .745 r
.40367 .32466 .41981 .34227 .4479 .30162 .43216 .28172 Metetra
.859 .767 .76 r
.43216 .28172 .4479 .30162 .47564 .26598 .46023 .24418 Metetra
.812 .749 .793 r
.46023 .24418 .47564 .26598 .50314 .23903 .48798 .21591 Metetra
.724 .715 .841 r
.48798 .21591 .50314 .23903 .53063 .22311 .51563 .19941 Metetra
.565 .644 .887 r
.51563 .19941 .53063 .22311 .55841 .21906 .54353 .19556 Metetra
.316 .513 .89 r
.54353 .19556 .55841 .21906 .58682 .22617 .57202 .20359 Metetra
.043 .349 .825 r
.57202 .20359 .58682 .22617 .61611 .24218 .60139 .22113 Metetra
0 .233 .748 r
.60139 .22113 .61611 .24218 .64641 .2635 .6318 .24437 Metetra
0 .214 .727 r
.6318 .24437 .64641 .2635 .67767 .28548 .66323 .26838 Metetra
0 .31 .79 r
.66323 .26838 .67767 .28548 .70963 .3031 .69543 .28777 Metetra
.134 .521 .915 r
.69543 .28777 .70963 .3031 .74187 .3117 .72796 .29754 Metetra
.484 .756 .99 r
.72796 .29754 .74187 .3117 .77387 .30796 .76027 .29408 Metetra
.542 .638 .895 r
.08834 .32876 .1053 .35025 .12836 .34769 .1114 .32644 Metetra
.13 .425 .867 r
.1114 .32644 .12836 .34769 .15037 .35669 .13325 .33644 Metetra
0 .086 .614 r
.13325 .33644 .15037 .35669 .17184 .37493 .15445 .35631 Metetra
.602 .11 0 r
.15445 .35631 .17184 .37493 .19338 .39868 .17567 .38211 Metetra
.646 .138 0 r
.17567 .38211 .19338 .39868 .21558 .42315 .19758 .40875 Metetra
.546 .013 0 r
.19758 .40875 .21558 .42315 .23893 .44314 .22073 .43063 Metetra
0 .332 .751 r
.22073 .43063 .23893 .44314 .26373 .45384 .24548 .44259 Metetra
.419 .749 .994 r
.24548 .44259 .26373 .45384 .29002 .4518 .2719 .4409 Metetra
.757 .859 .925 r
.2719 .4409 .29002 .4518 .31758 .43571 .29976 .42414 Metetra
.861 .844 .826 r
.29976 .42414 .31758 .43571 .34602 .40669 .32861 .39353 Metetra
.892 .818 .768 r
.32861 .39353 .34602 .40669 .37486 .36808 .35793 .35267 Metetra
.897 .797 .741 r
.35793 .35267 .37486 .36808 .40367 .32466 .38723 .30672 Metetra
.888 .781 .737 r
.38723 .30672 .40367 .32466 .43216 .28172 .41615 .26134 Metetra
.864 .766 .752 r
.41615 .26134 .43216 .28172 .46023 .24418 .44458 .22178 Metetra
.817 .748 .786 r
.44458 .22178 .46023 .24418 .48798 .21591 .47258 .19214 Metetra
.727 .713 .837 r
.47258 .19214 .48798 .21591 .51563 .19941 .50041 .17503 Metetra
.558 .637 .885 r
.50041 .17503 .51563 .19941 .54353 .19556 .52841 .17138 Metetra
.29 .493 .883 r
.52841 .17138 .54353 .19556 .57202 .20359 .55696 .18039 Metetra
0 .314 .804 r
.55696 .18039 .57202 .20359 .60139 .22113 .5864 .19956 Metetra
0 .188 .715 r
.5864 .19956 .60139 .22113 .6318 .24437 .61691 .22486 Metetra
0 .167 .689 r
.61691 .22486 .6318 .24437 .66323 .26838 .6485 .25105 Metetra
0 .265 .756 r
.6485 .25105 .66323 .26838 .69543 .28777 .68092 .27235 Metetra
.087 .492 .898 r
.68092 .27235 .69543 .28777 .72796 .29754 .71373 .28337 Metetra
.468 .753 .992 r
.71373 .28337 .72796 .29754 .76027 .29408 .74636 .28023 Metetra
.534 .631 .893 r
.07119 .30663 .08834 .32876 .1114 .32644 .09423 .30457 Metetra
.08 .389 .849 r
.09423 .30457 .1114 .32644 .13325 .33644 .11589 .31563 Metetra
0 .023 .555 r
.11589 .31563 .13325 .33644 .15445 .35631 .13678 .33725 Metetra
.657 .168 0 r
.13678 .33725 .15445 .35631 .17567 .38211 .15763 .36525 Metetra
.695 .193 0 r
.15763 .36525 .17567 .38211 .19758 .40875 .1792 .3942 Metetra
.605 .074 0 r
.1792 .3942 .19758 .40875 .22073 .43063 .20212 .41812 Metetra
0 .274 .697 r
.20212 .41812 .22073 .43063 .24548 .44259 .22679 .43144 Metetra
.394 .743 .992 r
.22679 .43144 .24548 .44259 .2719 .4409 .25333 .43014 Metetra
.763 .864 .924 r
.25333 .43014 .2719 .4409 .29976 .42414 .2815 .41266 Metetra
.868 .846 .819 r
.2815 .41266 .29976 .42414 .32861 .39353 .3108 .38034 Metetra
.898 .818 .76 r
.3108 .38034 .32861 .39353 .35793 .35267 .34065 .33708 Metetra
.903 .796 .733 r
.34065 .33708 .35793 .35267 .38723 .30672 .37047 .28843 Metetra
.893 .78 .729 r
.37047 .28843 .38723 .30672 .41615 .26134 .39987 .24047 Metetra
.869 .765 .745 r
.39987 .24047 .41615 .26134 .44458 .22178 .42868 .19877 Metetra
.822 .746 .78 r
.42868 .19877 .44458 .22178 .47258 .19214 .45696 .16767 Metetra
.73 .711 .833 r
.45696 .16767 .47258 .19214 .50041 .17503 .48496 .14993 Metetra
.552 .63 .883 r
.48496 .14993 .50041 .17503 .52841 .17138 .51305 .1465 Metetra
.261 .472 .875 r
.51305 .1465 .52841 .17138 .55696 .18039 .54166 .15656 Metetra
0 .275 .78 r
.54166 .15656 .55696 .18039 .5864 .19956 .57113 .17747 Metetra
0 .142 .678 r
.57113 .17747 .5864 .19956 .61691 .22486 .60172 .20497 Metetra
0 .118 .648 r
.60172 .20497 .61691 .22486 .6485 .25105 .63344 .23349 Metetra
0 .219 .718 r
.63344 .23349 .6485 .25105 .68092 .27235 .66608 .25684 Metetra
.036 .459 .878 r
.66608 .25684 .68092 .27235 .71373 .28337 .69917 .26923 Metetra
.451 .749 .993 r
.69917 .26923 .71373 .28337 .74636 .28023 .73212 .26643 Metetra
.525 .623 .891 r
.05385 .28383 .07119 .30663 .09423 .30457 .07687 .28205 Metetra
.026 .35 .827 r
.07687 .28205 .09423 .30457 .11589 .31563 .09831 .29425 Metetra
0 0 .492 r
.09831 .29425 .11589 .31563 .13678 .33725 .11883 .31773 Metetra
.706 .222 0 r
.11883 .31773 .13678 .33725 .15763 .36525 .13926 .34807 Metetra
.738 .243 0 r
.13926 .34807 .15763 .36525 .1792 .3942 .16043 .3795 Metetra
.657 .132 0 r
.16043 .3795 .1792 .3942 .20212 .41812 .18306 .40562 Metetra
0 .212 .636 r
.18306 .40562 .20212 .41812 .22679 .43144 .20764 .42042 Metetra
.366 .734 .989 r
.20764 .42042 .22679 .43144 .25333 .43014 .23429 .41954 Metetra
.769 .87 .922 r
.23429 .41954 .25333 .43014 .2815 .41266 .26278 .40129 Metetra
.876 .847 .812 r
.26278 .40129 .2815 .41266 .3108 .38034 .29257 .36715 Metetra
.904 .817 .751 r
.29257 .36715 .3108 .38034 .34065 .33708 .32299 .32131 Metetra
.908 .795 .725 r
.32299 .32131 .34065 .33708 .37047 .28843 .35339 .26979 Metetra
.898 .778 .721 r
.35339 .26979 .37047 .28843 .39987 .24047 .3833 .21908 Metetra
.874 .764 .737 r
.3833 .21908 .39987 .24047 .42868 .19877 .41252 .17512 Metetra
.827 .745 .773 r
.41252 .17512 .42868 .19877 .45696 .16767 .4411 .14249 Metetra
.733 .709 .828 r
.4411 .14249 .45696 .16767 .48496 .14993 .46928 .12408 Metetra
.544 .623 .881 r
.46928 .12408 .48496 .14993 .51305 .1465 .49746 .12089 Metetra
.231 .449 .866 r
.49746 .12089 .51305 .1465 .54166 .15656 .52609 .13206 Metetra
0 .235 .753 r
.52609 .13206 .54166 .15656 .57113 .17747 .55559 .15482 Metetra
0 .094 .638 r
.55559 .15482 .57113 .17747 .60172 .20497 .58622 .18467 Metetra
0 .069 .604 r
.58622 .18467 .60172 .20497 .63344 .23349 .61806 .21569 Metetra
0 .17 .677 r
.61806 .21569 .63344 .23349 .66608 .25684 .6509 .24126 Metetra
0 .423 .853 r
.6509 .24126 .66608 .25684 .69917 .26923 .68427 .25512 Metetra
.432 .744 .993 r
.68427 .25512 .69917 .26923 .73212 .26643 .71755 .25272 Metetra
.515 .615 .889 r
.03634 .26033 .05385 .28383 .07687 .28205 .05931 .25885 Metetra
0 .307 .8 r
.05931 .25885 .07687 .28205 .09831 .29425 .08049 .27226 Metetra
.567 .101 0 r
.08049 .27226 .09831 .29425 .11883 .31773 .1006 .29772 Metetra
.748 .272 0 r
.1006 .29772 .11883 .31773 .13926 .34807 .12055 .33057 Metetra
.774 .289 0 r
.12055 .33057 .13926 .34807 .16043 .3795 .14125 .36467 Metetra
.703 .185 0 r
.14125 .36467 .16043 .3795 .18306 .40562 .16354 .39315 Metetra
.409 0 0 r
.16354 .39315 .18306 .40562 .20764 .42042 .18798 .40954 Metetra
.334 .723 .983 r
.18798 .40954 .20764 .42042 .23429 .41954 .21474 .40913 Metetra
.776 .876 .92 r
.21474 .40913 .23429 .41954 .26278 .40129 .24358 .39007 Metetra
.883 .848 .805 r
.24358 .39007 .26278 .40129 .29257 .36715 .2739 .35396 Metetra
.91 .816 .743 r
.2739 .35396 .29257 .36715 .32299 .32131 .30494 .30538 Metetra
.912 .794 .716 r
.30494 .30538 .32299 .32131 .35339 .26979 .33597 .25079 Metetra
.903 .777 .713 r
.33597 .25079 .35339 .26979 .3833 .21908 .36645 .19716 Metetra
.879 .762 .729 r
.36645 .19716 .3833 .21908 .41252 .17512 .39612 .1508 Metetra
.832 .744 .767 r
.39612 .1508 .41252 .17512 .4411 .14249 .42501 .11655 Metetra
.735 .707 .824 r
.42501 .11655 .4411 .14249 .46928 .12408 .45337 .09744 Metetra
.537 .615 .878 r
.45337 .09744 .46928 .12408 .49746 .12089 .48163 .09452 Metetra
.198 .424 .855 r
.48163 .09452 .49746 .12089 .52609 .13206 .51028 .10687 Metetra
0 .192 .722 r
.51028 .10687 .52609 .13206 .55559 .15482 .53976 .1316 Metetra
0 .046 .596 r
.53976 .1316 .55559 .15482 .58622 .18467 .57041 .16396 Metetra
0 .02 .558 r
.57041 .16396 .58622 .18467 .61806 .21569 .60233 .19767 Metetra
0 .12 .633 r
.60233 .19767 .61806 .21569 .6509 .24126 .63535 .22562 Metetra
0 .383 .824 r
.63535 .22562 .6509 .24126 .68427 .25512 .669 .24108 Metetra
.41 .739 .992 r
.669 .24108 .68427 .25512 .71755 .25272 .70262 .2391 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.17627 .20066 m
.18085 .20537 L
s
[(-5)] .16712 .19126 .97284 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.52102 .06567 m
.52496 .07092 L
s
[(5)] .51313 .05518 .75163 1 Mshowa
.125 Mabswid
.20879 .18793 m
.2115 .19079 L
s
.24172 .17504 m
.2444 .17792 L
s
.27507 .16198 m
.27771 .1649 L
s
.30885 .14875 m
.31146 .1517 L
s
.37773 .12178 m
.38026 .1248 L
s
.41285 .10803 m
.41534 .11108 L
s
.44843 .0941 m
.45088 .09718 L
s
.48448 .07998 m
.48689 .08309 L
s
.14416 .21324 m
.14694 .21603 L
s
.11245 .22566 m
.11526 .22842 L
s
.08113 .23792 m
.08396 .24065 L
s
.05019 .25004 m
.05305 .25274 L
s
.55805 .05117 m
.56037 .05435 L
s
.59558 .03648 m
.59785 .03969 L
s
.63363 .02158 m
.63585 .02483 L
s
.67219 .00648 m
.67437 .00976 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 197.5},
  ImageMargins->{{60.3125, 0}, {0, 0.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>0000mQ000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00
ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo0034Ool40016Ool00<=oo`03
001oogoo009oo`03001oogoo04=oo`00`goo00<007ooOol00Woo00<007ooOol0@goo0033Ool00`00
Oomoo`02Ool00`00Oomoo`13Ool00<=oo`03001oogoo009oo`03001oogoo04=oo`00`goo00<007oo
Ool00Woo00<007ooOol0@goo0033Ool00`00Oomoo`02Ool00`00Oomoo`13Ool00<Aoo`@004Ioo`00
_Goo0`00CWoo002kOol300000goo0000001=Ool008moo`@002Ioo`<000=oo`8004eoo`00SWoo00<0
07ooOol00Woo00<007ooOol087oo0`001Woo00<007oo0000C7oo002COol00`00Oomoo`0NOol20009
Ool01000Oomoo`00Bgoo002COol00`00Oomoo`0KOol3000;Ool01000Oomoo`00Bgoo001GOol20002
Ool2000bOol4000LOol200000goo001oo`0;Ool01@00Oomoogoo0000BWoo001HOol01000Oomoo`00
<goo00<007ooOol06Woo0`0047oo00<007ooOol00Woo00<007ooOol0Agoo001IOol2000dOol00`00
Oomoo`0FOol01000Ool000004goo00<007ooOol00Woo00<007ooOol0Agoo001IOol2000dOol5000C
Ool3000EOol00`00Oomoo`03Ool00`00Oomoo`16Ool005Qoo`04001oogoo0018Ool3000IOol00`00
Oomoo`02Ool20017Ool005Moo`80009oo`8004Eoo`8001aoo`03001oogoo00=oo`03001oogoo04Eo
o`00Wgoo0`007Woo00<007ooOol017oo00<007ooOol0A7oo002MOol200000goo001oo`0NOol00`00
Oomoo`04Ool00`00Oomoo`14Ool009Yoo`<002=oo`03001oogoo00Eoo`03001oogoo04=oo`00UWoo
00@007oo000002Ioo`03001oogoo00Ioo`03001oogoo049oo`00UGoo0`00:7oo00<007ooOol01Woo
00<007ooOol0@Woo002BOol30002Ool00`00Oomoo`0VOol00`00Oomoo`07Ool00`00Oomoo`11Ool0
091oo`8002ioo`03001oogoo00Qoo`03001oogoo041oo`00I7oo10009Goo0`00<7oo00<007ooOol0
27oo00<007ooOol0@7oo001SOol00`00Oomoo`02Ool00`00Oomoo`0POol200000goo001oo`0`Ool0
0`00Oomoo`08Ool20011Ool006=oo`03001oogoo009oo`03001oogoo01eoo`<003Eoo`03001oogoo
00Yoo`03001oogoo03ioo`00Hgoo00<007ooOol00Woo00<007ooOol06Woo0`000Woo1@00<Goo00<0
07ooOol02Woo00<007ooOol0?Woo001SOol00`00Oomoo`02Ool00`00Oomoo`0HOol70000149k@U]6
Nd9K0`00;goo00<007ooOol02goo00<007ooOol0?Goo001SOol00`00Oomoo`02Ool00`00Oomoo`0E
Ool300001Woo000005Zi0012F`=2N`05@U]2N`005KXEVP02000]Ool00`00Oomoo`0<Ool00`00Oomo
o`0lOol006=oo`03001oogoo009oo`03001oogoo01=oo`8000=oo`0@001NfUZiG]X0049k@U]6Nd9K
@W]2FdIk000I^aFJ6K/2000[Ool00`00Oomoo`0<Ool00`00Oomoo`0lOol006Aoo`@001=oo`<000Ao
o`09001NfEZiG]UJ^EkI0012Nd9K00=2N`06@U/001FJ5KXEVQFj0P00:Woo00<007ooOol03Goo00<0
07ooOol0>goo001iOol20005Ool200004ekJF[UNfUZiG]YJ^EkJ0012Nd9KAW]2Fd9k@U/001FJ6K/E
VQVk008002Uoo`03001oogoo00ioo`03001oogoo03Yoo`00MWoo0`001Woo00/005ZiG]UJ^EkIF[UN
fEZiG]UJ^@000092N`0;@U]2Nd9k@W/001Fj5IXE^QFJ0000]P02000WOol00`00Oomoo`0>Ool00`00
Oomoo`0jOol007Aoo`8000Qoo`0<001Ve`00F[UNfUZiG]YJ^EkJF[UNfUZi2@0000@EVQVk5IX00080
]P03001oogoo02Aoo`03001oogoo00moo`03001oogoo03Uoo`00LGoo100027oo00/006KgJ_P005kI
F[UNfEZiG]UJ^EkI00800004F[T0049kAW/3@W/00`006KX0000300030;H00`00Oomoo`0TOol00`00
Oomoo`0=Ool3000jOol006ioo`<000]oo`0J001Vef[hI]MZn000G]YJ^EkJF[UNfP00G]YJ^EkJ0016
O49kAW]2FdIl@W/001Vj7M/I^P8000040=H0]P2f000UOol00`00Oomoo`0?Ool00`00Oomoo`0hOol0
06aoo`8000ioo`0=001Zn6KgJ_QVmf[h001NfEZiG]T005kJF[T00U[I00ENfP00@W]2NdIk0092N`03
000M^aVj008I^`037K/000000080]P03001oogoo029oo`03001oogoo011oo`03001oogoo00Eoo`D0
02eoo`00JGoo0`0000=oo`00Ool037oo00T006[hI]MZn6KGJ_QVe`00F[T00P00019NfUZiG]YJ^EkJ
F[T0049KAWa2NdIk@U]6O0007M/I^QgK6KX300000`2f0000000SOol00`00Oomoo`0@Ool00`00Oomo
o`05Ool01@00Oomoogoo0000;Goo001WOol2000AOol03@00J_QVmf[hI_MZn6KgJ_QVm`00F]UNfUZi
009Jf@05G]YJ^E[IF]T00003@W/01TIk@W/001Vk7K/I^P8I^`040000e`000;H2000ROol00`00Oomo
o`0AOol00`00Oomoo`05Ool00`00Oomoo`0^Ool003]oo`@002Aoo`@0019oo`0I001Zn6KGJ_QVef[h
I]MZn6KG001Ve`00F[UNfUZiG]YJ^EkJF[UNfP00AW]2FdIl@W/0100000HMfaVj7M/I^P000=L4000Q
Ool00`00Oomoo`0BOol00`00Oomoo`05Ool00`00Oomoo`0]Ool003Yoo`03001oogoo009oo`03001o
ogoo021oo`<001=oo`0=001Zn6KgJ_QVmf[hI_MZn6Kg001Vn6[h00000U[I00MNfUZiF]UJfEkJF[UJ
f@040002AW/00d9k0000000400000`3g0=L00002000QOol00`00Oomoo`0BOol00`00Oomoo`06Ool0
0`00Oomoo`0/Ool003moo`03001oogoo01eoo`<001Eoo`0E001_5`00J_QVef[hI]MZn6KG001Vef[h
I]MZn000G]YJ^EkJF[UNfUZi00<0000;@W]6O49kAYa2NdIl000QfagK8M/MfP0200000`3g0=L0m`02
000POol00`00Oomoo`0COol00`00Oomoo`06Ool00`00Oomoo`0[Ool0039oo`H000Moo`03001oogoo
01Yoo`<001Qoo`08001^mP00I_MZn6KgJ_QVm`800006J_QVmfKhI_QZn0000U[I00=NfP0000000U[J
00EJf@00AW]6Nd9k00=6N`03000MfagK00<Mf`8000040=L0m`00000OOol00`00Oomoo`0DOol01@00
Oomoogoo00000goo00<007ooOol0:goo000kOol4000KOol3000IOol04P00K_Ic5fkf001Vef[hI]MZ
n000J_QVef[hI]MZn6KG001J^@80000FG]YJ^EkJF[UNfP00AYa2NdIl@W]6W49kAW`0027K7M/QfagJ
0000n0000=L3000NOol00`00Oomoo`0DOol00`00Oomoo`02Ool3000^Ool003]oo`03001oogoo01Uo
o`<001]oo`03001^mVlF00=^mP06001Vmf[h001Zn6Kg0VKh00IZn6KgI_QVn000F]T3F]X01E[IF]YJ
fU[J00000dIk00A2NdIkAW/000DMf`04000160000=L3000MOol00`00Oomoo`0COol00`00Ool0000d
Ool003]oo`03001oogoo01Moo`8001ioo`0P001c5fkfKaM^mW<G001Zn000J_QVef[hI]MZn6KGJ_QV
e`00I]P005ZiG]YJ^EkJF[UNfUZi0012NdJL@W]6O0D000068M/Mfb7K7MX0003h0P0000<0E0000000
77oo00<007ooOol05Woo00<007ooOol0<Goo000kOol5000BOol3000OOol00`00KaI^mP02K_H01VlF
K_I^mP00J_QVm`9Vn005J_QVmfKhI_P00002I_P00`00F]YJf@03F]X00e[IF]YJfP04000014JKAW]6
NdIk1P000`4H00@0001C000001]oo`03001oogoo01Ioo`03001oogoo035oo`00D7oo0P008Woo01/0
06kfKaM^mW<GK_I_5`00KaL006[hI]MZn6KGJ_QVe`00I]QZn6KGJ_P005kJF[UNfUZiG]X00P0000eJ
^@00@W]6W49kAYa2NdJL000Uo27K9O`Qf`0200001@4H0?P1600005@00P006Woo00<007ooOol05goo
00<007ooOol0<7oo001=Ool3000SOol01@00K_I^mVkfKaH00fkf00H006kfK_L006[hI_L2I_P00`00
I_QVn004I_P01@00F]YJfE[J00000e[J00<004JKAW/00TIk00A6VdIkAW/000DQn`8000040AP00000
05<2000IOol00`00Oomoo`0HOol00`00Oomoo`0_Ool004Yoo`<002Eoo`0J001^mVlGK_Ic5fkfKaM^
mP00K_I_5f[f001Vef[hI]L006KHJ_QVef[hI]QZn6KG001J^@80000FG]YJ^EkJF[UNfP00AYa2NdJL
@W]6W49kAY`002Gl8M/Uo27K0001>0000?P5000HOol00`00Oomoo`0HOol00`00Oomoo`0LOol3000@
Ool004Qoo`8002Qoo`04001^mVkfKaH3K_H02@00K_I^mfkfKaM^mP00I_P00009I_P00`00F]YJfP06
F]X00`00AY]6N`02AW/00dJKAW/000058O/010000CP0004H1@005goo00<007ooOol06Goo00<007oo
Ool06Woo00D007ooOomoo`0000moo`00AGoo0`00:Goo00L006lGK_Ic5fkfKaM^mP0200007flGJ_I_
5fkfKaMZmP00I]QZn6KGJ_QVf6[hI]MZn6KH001Vf000F[UNfUZiG]YJ^EkJF[T0049kAYa2NdJL00D0
00069O`QfbGl8M/0004h0P0000<0U@1d00000P005Woo00<007ooOol06Woo00<007ooOol06Goo00<0
07ooOol04Goo0013Ool2000[Ool01000LaH006lF0fkf00]_5P00K_M^mVlGK_I^mfkf001^m`0000MV
n004001Vn6Kh0007F]X5000014JKAW]6W4Ik1P0000H1>@4h0CT0002E07@3000EOol00`00Oomoo`0I
Ool2000KOol00`00Oomoo`0AOol0041oo`<00003Ool0000002Yoo`0K001^mG<F001_5fkfLaL006lG
J_I_5fkfKaMZmVlG001_5`00J_QVf6[hI]MZn6KH001Vf6[i009Vn005001NfUZiG]YJ^@0200003U[J
F[T004IkAYa6NdJLAW]6W0009Q`UnbHL9O/200002@4i0CP1>@0009D0M0000380000DOol00`00Oomo
o`0KOol00`00Oomoo`0HOol00`00Oomoo`0AOol003ioo`8002moo`0@001c5W<FLaH006kfKaH006kg
K_I_5fkfK_M^mVlG0002K_L00flG001Vn003I_P00`00I_QVn003I_P00`00F]YJfP020005F]X02000
AW]6W4IkAY]6NdJL00029O/00bHL9O/Un`020000204h0CT0002E07@0000b000DOol00`00Oomoo`0K
Ool00`00Oomoo`0FOol5000@Ool003]oo`<0035oo`0J001c5W;eLaI^m@00K_H006[fKaM^mVlGJ_I_
5`00KaMZmVlGJ_I_5`00J_QVf000I]QZn@9Vn003I]QZnFKh00800005G]YJfU[JF[UNfP02F]X03`00
AYa6NdJLAW]6W4Ik000UnbHL9O/V72Gk0005F@0700000`0b0000000BOol00`00Oomoo`0KOol00`00
Oomoo`0GOol00`00Oomoo`0AOol003Qoo`<00003Ool007oo031oo`03001c5W<F00Ac5P07001^mVlG
K_I^mfkfKaL00P0000=^mflGK_L00Vkg00<006Kh00001fKh00<006Kh000025[J00D004JKAW]6W4Ik
00@0008Un`059Q`Un`001ET5FP0200001@2f0000000003800P004Goo00<007ooOol077oo00<007oo
Ool0:Woo000fOol2000fOol06@00L_Ec5VkeLaIbm@00K_H006kfKaMZmVlGK_H006[fKaMZmVlGJ_I_
5f[f001Vf6[i009Vn00:I]QZnFKh001Rf6Ki001JfUZiG]X2F]X015ZiG]YJfU[J100000=6NdZLAW/0
1P0000P5NPEI1EX5F@000;H0001C100047oo00<007ooOol077oo00<007ooOol0:Woo000cOol3000g
Ool00`00LaIc5P04LaH02P00LaI_5P00K_I_5fkf001^mflG0fkg00E_5fkg001^m`0000EVn003001V
n6Ki009Vn003001JfU[J00AJfP<000=6V`06AYa6VdJK000Z72XK0RXL0P000PEI00<5FPEI00000P00
00<0L`0000000P003goo00<007ooOol07Goo00<007ooOol0:Goo000aOol2000jOol07000LaI^mG<F
L_Ec5P00LaI_5W<F001_5fkf001ZmVlGJ_I_5f[fKaMZmP00J_M_5f[g001Vf6[i0VKh00X006KiI_QV
nF;HI_T005[JF[UNfP80000@F[YJfU[J0016NdZLAW]6W4IkBY`002XL9O/Z72XK:Q`2000010EI1EX0
003g100000@0U000000000eoo`03001oogoo01ioo`03001oogoo02Qoo`00;Woo0`00>goo00<007<F
LaH017<F00<006lFLaH00W<F00@006kg001_5`=^m`08KaM^mfkg001_5f[gKaL000=Vn003001VnFKh
009Vn004I_UVn000F]X20005F]X00`00AYa6V`02AY/01TJLAY]6V`00:Q`Z6`<Z70<000031EX0003G
00@0000309D0005i008000]oo`03001oogoo01ioo`03001oogoo02Qoo`00;7oo0P00?Woo02L006ke
LaIbmG<FK_D006lFLaI^mW<FKaIc5P00KaMZmVlGJ_I_5f[fKaL006lGJ_M_5f[gKaL006Kh001VnFKh
I_URf6KiI_QVnF;H00000U[J01IJ^U[JF]YJfUZjF]X004JLAW]:W4IkAYa6N`00:Q/Z72Gk:Q`Z6`00
1GX9VP8000030=H0m`0000D000040GT1VP000005Ool5000POol2000YOol002Uoo`<003moo`03001c
5W<F00=c5P8000=c5P05KaIc5P00LaH00002K_L03FlGK_M^m`00KaMZmflGK_M_5f[gKaL006Ki00=V
n007I_UVn6KhI_P006Kh00001e[J00<004JKAY`00TJK1`000RXL00D000Uj2GX9NP0000<0e`H00081
N@D00004<]hboc;o<_l2000QOol00`00Oomoo`0VOol002Ioo`<0049oo`0L001c5W;eLaI^mG<F001c
5VkfLaI_5W<FK_H006lFLaL006lGJ_I_5`00KaMZmflGJ_M_5f[gKaL2000036KhI_URf6KiI_QVnF;H
001Rn6KiH]P0009JfP05F[YJfU[JF]YJ^P0400001dZLAY]:W4Ik000Z6bhl00@000031GX9VPEj0080
00030?L0e`0000L000070IX003;o<]hboc;N<_l00P0000<bgP00Ool07goo00<007ooOol09Woo000T
Ool30013Ool00`00LaIc5P03LaH01@00LaIc5W<FKaH00W<F00D006lFLaI_5P0000=^m`0=001ZmflG
K_M_5f[gKaL006lGJ_L006KhI_T00fKh00H006KhI_UVn6Ki0005F]X200003e[J0016VdZLAY]6W4JK
BY`002hl:Q`^?2XL;S`Z700200022GX200001P3G0000002E0000ePH00005<_l00000000bo`04000P
Ool00`00Oomoo`0UOol0029oo`8004Eoo`0]001g=P00LaI^mG<FL_D006kfLaI_5W<FK_Ic5P00LaM^
mW<GKaH006[f001ZmflGJ_M_5f[gKaMZm`00J_M_6000I_UVn6KiH]P006;hI_URf6KiH_QVn@00009J
fP80000CF]]JfU[JF[X004JKBYa6NdZLAY]:W000;S`Z6bhl:Q/^?0003I/00`0000<160000?L01@00
00<0eP0000001`0000Dfo`00=_lbgP00021oo`03001oogoo02Aoo`008Woo1P00@Goo00@007<FLaH0
009c5P04001c5W<FKaH3LaH05@00LaI_5W<FKaIc5VlF001ZmflGK_M_5f[gKaM^m`00J_M[5f[gKaL0
0002I_P02@00I_QVnFKhI_UVn6KiI_QVn@020006F]X04@00AYa6VdZLAY]6W4JK000Z72hl:Q`^?2XL
;S`000fK3IX00P0000<1600000000P3F00<0003g00001`0013Ko00@003Ko=_l001moo`03001oogoo
02Aoo`0067oo1@001Goo0P0000A2O3iK@W`nF`8003ioo`0=001c5W<fLaEg=P00LaH007<FKaIc5Vkf
LaH00P0001i^mW<GKaIc5fkf001_5P00J_M_5f[gKaMZm`00J_M_66[gKaQZm`00H]P006;hI_URf6Ki
H_QVnF;HI_T200001UZjF]]JfU[JF[YJf`9JfP05001:W4JKBYa6N`0600002Rhl:Q/000fJ3I/=VQ6k
0001603g100000D16000000000GK00@00008<]hfoc;N=_l003Ko<]h001moo`03001oogoo02=oo`00
67oo00D007ooOomoo`0000Eoo`800005?U/nNcik@W`nF`03000lOol01000LaIc5W<f0W<F00<007<F
KaH00g<F025_5P00KaIc5VlFLaI_5W<F001_5flF001ZmflGK_L006[gJaMZmflGJ_M[5f[g001Vn6Ki
I_QVnFKhI_UVn6Ki00000VKi00<005[JF]X01U[J100000A6VdZLAY/0008^?0@000043IX=V`fJ3I/5
0000103F0000m`3g0P000`GK2P007goo00<007ooOol08Woo000IOol00`00Oomoo`05Ool200002Woo
000nFd9l?U]2O3iK00016000>Woo03@007<fLaEg=W<FLcH007<g001c5VkfLaI_5P00K_Ic5flFLaM^
mW<G001c5fkfLaL006lGJ_M_5`00KaQZmflHJ_M_66[g001Zm`00H]QVnF;hI_URf6Ki001VnF;hI_T0
05[JF[YJf`9JfP0AF[X00000F]/004ZlAY]:W4JKB[a6V`00;Q/b?2hl<S`^6`0500000`4h00000005
0000403g0AL000001K/5f`Fk000foS[o=]h003Kn>_lfgP007Goo0P0097oo000@Ool60004Ool00`00
Oomoo`04Ool01P00Oomoogoo000nF`8nN`05@W`nF`000CP0000hOol01000LaIc5W<f0g<F01`007<F
LaH007<FKaIc5P00LaI_5W<FKaIc5P00KaM_5W<GKaI_5`00KaL006/GJ_M_5f[gJaMZm`800008JaQZ
m`00I_QVnFKhI_T000=Vn@03H_UVn@0000=JfP8000=JfP080016VdZLAY]:W4JKBY`000@^?0D00004
3IX0004i0CT700000`4G0000000200002PFk000foc[o=_l003Ko>_lfo`007Woo00<007ooOol08Goo
000KOol00`00Oomoo`03Ool02@00Oomoogoo0012O3iK@W`nF`0300000`4H001oo`0fOol0=000LaEg
=W<FLcIc5@00LaIc=W<F001_5W<F001c5flFLaM^mW<GKaH006kfLaM_5W<GK_Ic5`00KaQZmflHJ_M_
66[gKaP006lHJ_M_6000I_URf6Ki001VnF;hI_URn6KiH_P005[J0P0000eJfe[JF]]FfU[KF]X004JK
B[a6VdZLAY]:_00400001Bhl<S`001Fk4K/00P0000H1>@4h0CT1>0000?L500000`GK2O`000030000
0cKn>_lfgP05000NOol00`00Oomoo`08Ool3000EOol001aoo`03001oogoo009oo`8000=oo`@00003
@W]2O49k00<003Eoo`03001c5W<f00=c5P0VLcH007<FLaIc=W<F001c5P00KaIc5VlFLaI_5P00KaIc
5flFKaM_5W<G001_5`00KaMZmf/GJ_M_5`00JaQZmf/HJ_M[6000I_T000=Vn@06H_UVnFKiI_URn@00
25[J00D004ZLAY]:W4JK00L00003;S`0016k008A^`035K/0004i00<1>@8000030?P0000000800004
2M/9o0Wl2O`60002>_l00c[n001oo`0LOol00`00Oomoo`09Ool00`00Oomoo`0DOol001Qoo`05001o
ogooOol00004Ool00`00Oomoo`03Ool02000@W`nFd9l?W]2O0001GX2000cOol0?`00LaEg=W<FLcIc
5GLf001c=W<FLcMc5W<fLaH006lFLaM^mW<GKaIc5`00LaM_5W<GK_Ic5flF001_5W<G001_66[gKaP0
06lHJ_M_66[gKaQZmflH001VnF;hI_URn6KiH_QVnF;h001Rn000F]YJfeKJF]]JfU[KE]YJf`040000
1TJKB[a6VdZl000bG0D000035K/A^aFk008000060CP1>@000CT0004H1P0000/5f`Wl1M/003[n>_l0
03[o>_hjocKn008001aoo`03001oogoo00Qoo`03001oogoo01Aoo`006Goo0`001Goo00<007ooOol0
17oo00P0049l@W]2O49k@W`000EI0P00<Woo00<007<fLaH00W<F00Ec=W<F001c5W<f00=c5P0?001c
5P00KaIc5VlFLaH007<GKaI_5flFLaM_5P0000=_5`03001ZmflG0080000;J_M[66[gJaQZmf/H001[
6000I_URn@03I_T01V;i001RnFKiH_T000EJfP@00009BYa:VdZLBY]:W4ZK000b?39L00<b?0<00003
4K/0005I008000030CT0004h008000030ET0000000L0008jo`03000joc[o00@001aoo`03001oogoo
00=oo`H001Eoo`0087oo0P001Woo00T003ik@W`nFd9l?W]2O0001GX00P00<7oo03/007LfLaIc=W<E
McIc5P00LaIc=g<FLcIc5W<g001c=flF001_5W<G001c5flFLaM^mW<GKaH006lFLaM_5W<GKaH006[g
001ZmflHJ_M_66[gKaP006/HJ_M_6000I_URn6KiH_P006;hI_URnFKi001Jfe[J00<0000CE]YJfeKJ
0016VdZlAY]:_4JKB[a6V`00<S`bG2hl<U`b?0005K/00`0000H1F@Ej0000004H0CT200000`5I0GX0
000200000a8M3O`0000600001C[n?_ljoSlO00006goo00<007ooOol017oo00@007ooOol001Ioo`00
87oo00<007ooOol01Woo00L0049k@Wa2Nd9l@W/000021ET2000_Ool01@00LaIc5W<FLcH00W<F00<0
07<fLaH00W<F011c=P00LaIc5W<gLaH006lF001_5VlGKaIc5flFKaL000I_5`0=001Zmf/HJ_M[66[g
JaP006/HJ_Q[66[h00000VKi00MRn@00H_UVnF;iI_URn@050005F]X02000BY]:W4ZKBYa:VdZL0002
<S`01c9L<S`b?0006M/EfaWK00<000040EX1F@0000020CP200020ET300023Q`01@gl000jo`00>_h0
0S[o00@noc[n>_l001]oo`03001oogoo00=oo`04001oogoo000FOol0021oo`03001oogoo00Moo`/0
02eoo`0Y001c5W<fLaEg=W<FLcH007<gLaIc=W<FLcMc5P00KaIc=g<FLcM_5P00KaIc5fkfLaM_5W<G
001c5flFLaM_5W<GKaH006lG001ZmflHJ_M_600200002f[gKaQZmf/HJ_L006;h001Rn6KiH_T00`00
00mRnFKi001JfeKJF]]FfU[KE]YJf`00B[a6VdZlAY/01`0000L^?39L000Ig1Fk6M`Ef`0300001@5I
000000000AP00`0000<1F@5i00001@0000PjoP00>_ho7c[n?_ljoP006goo0P001Goo00<007oo0000
5Woo000POol20009Ool01P00@W]2O49k@Wa2N`@002aoo`05001c=`00LaIc=P03LaH02@00LaIc5W<F
LcIc5P00LaIc=`03LaH02@00KaH006lFLaM_5VlGKaH00006KaL04@00KaL006/HJ_M[66[g001Zn6/H
J_Q[66[hJaQZn000H_T00`0000=RnFKiH_T00P0000=Vn@00F]X01U[J100000E:VdZLBYa:_000008b
G0D000035M/IfaGK00d000044Q`F?AHM5Sd:000IOol30006Ool2000FOol0021oo`03001oogoo00Qo
o`090012W49k@Wa2Nd:L@W/000Ej008002]oo`03001c=g<f00800008LcIc5@00LaIc=W<FLcMc5P80
000DLcMc5W<gKaIc=`00LcM_5P00KaIc5fkf001_5W<GKaIc5flFLaL000=_5`0;001_66[g001ZmflH
J_M[66[gKaQZm`0300003f;iI_URn6KiH_T006;iI_URn@00E]YJfeKJF]]FfP0200003e[K001:_4ZK
B[a6VdZlBY/0038l=Udb?3IL<S`fG@03000011WL0005VPEj0`0000D1>@000000005j00<0000>4Q`F
?A8L5SdB7000?_h003[n?alnoSlO>_h001]oo`03001oogoo01]oo`005goo10001Goo00<007ooOol0
2Goo00/0049l@W]2O49k@W`000VJ001M000002Uoo`03001c=g<g00=c=`03001c=P00009c5P05LcIc
5W<F001c=`03LaH02G<g001c=g<GLcL006lGKaH00006KaL00`00KaM_5`02KaL02@00J_L006[hJaQZ
n6/HJ_Q[60020002JaP02000I_URnFKiH_T006;iI_T3H_T01@00F]YJfU[J00000e[J00IJf`00BYa:
W4ZlBY/2BY`02@00<U`bG39L=U`bG0006O/Mo00300000`FJ1GX5NP0200020ET200020GX400000aHM
5SdB700200001cko?_hnockn?_lnoP0001Yoo`03001oogoo01]oo`005Woo00<007ooOol00Woo00D0
07ooOomoo`0000eoo`0;0012W49k@Wa2Nd:L0009VP00G@00000XOol08@00LcIc=g<fLcMc=W<g001c
=W<FLcMc5W<f001c=g<FLcM_5W<g001c=flFLcM_5W<g001c5`00LaM_5W<GKaIc5`020005KaL01@00
J_M_66[gJaP0100000IVmf/HJ_Q[6000I_T2000026;iI_URnFKiH_UVn@00F]/200005eKJF]]FfU[k
E]X004JKB[a:VdZlAY]:_000=U`b?3IM<S`fG38l000Ifagl6M/00`0000<5NPFK1GX00P0000H1FP5I
0000006J0GX800000clO>_ho7`04000JOol00`00Oomoo`0JOol001Ioo`03001oogoo009oo`04001o
ogooOol2000<Ool01@00@W]2O49k@W`0100000=Lh00000009Woo00<007<gLcL017<g00@007<g001c
=P=c5P0>001c5W<FLaIc=g<F001c5g<gKaIc=g<GLcL000I_5`03001_5flG00=_5`03001_5`0000<0
0003JaQZn000009[6005J_Q[66/HJaP00002H_T01FKiH_URnF;iI_T00V;i00<005[KF]X00U[J00IJ
fe[JF]YJfP00BY/2BY`00dZl000000040000239L=U`001gl6O/Mo1WK7O`300000`Ej0005NP030000
10Fk0000000011Xm1P0000Dnockn?_lnoP0001Yoo`03001oogoo01Uoo`005Woo00<007ooOol00Woo
00D007ooOomoo`0000ioo`@00003AYa2NdJL00800003F>0007oo02Eoo`0R001c=g<fLcMc=W<gLcH0
06lgLeL007<fLaH007<FLcM_5W<gLaH006lFLcM_5W<gKaIc=`00LcL007<GKaIc5flF0006KaL40000
7f[gKaQZm`00I_M[66[hJaQVmf/H001[6000I_URnFKiH_UVnF;iI_T006Kj001JfeKJF_]FfU[KE]YJ
neKJ00@00006B[a:VdZl000fG39L1@0000HIfagl6M/000VJ3K/300001PEj0GT000001K/5VP80000?
6UdF?AYM6SdJGAHm000noT<O?_i37ckn@alnoP0001Uoo`03001oogoo01Uoo`005Woo00<007ooOol0
0Woo00D007ooOomoo`0000moo`070012Nd9l@Wa2W49k@W`00P0000=Lh000Ool08goo00<007<gLcL0
17<g00<007<gLcL00W<g00<007<f00000W<F00ic=g<FLaH007<gKaIc=g<GLcM_5P00KaMc=`000VlG
00<006lGKaL00VlG0`0016lG00<006[h00000V/H00AZn6/HJaQ[6080009[6004001RnF;iI_T2H_T0
1P00H_URn@00F]YJf`=JfP0<F]/00000F]X004ZKB[a:W4ZlBY]:_0001CIL1P0000<9V`Vk2IX00P00
00<5NP5j1GX00P0000<5V`Fk000010000QXm00D003kn?_lnoSko00@001Uoo`03001oogoo01Qoo`00
5Woo00<007ooOol00Woo00@007ooOomoo`8000moo`060012NdJL@W]6W49k1@008Woo00X007<gLcIc
=g<fLcMc=P00KcMcE`9c=`0HKcMcE`00LcM_5W<gLaIc=`00LcM_5W<gKaIc=flF001_5W<gKaMc=`00
LaL006lG0`0001Q_5`00KaQ_5flHJaM_66lG001Vmf/HJ_Q[66KgJaQZn000I_Q[6FKh001RnFKiH_T2
000026KjH_URnV;i001FfU[KE]X200002e[KE]YJn`00B[a:VdZlBY]:_4ZK00000SIL00PbG3Im=U`0
01gk8Q`Mo28L0P0000@9VPfk2IX=^`8000030GT5VP00008000041K/001iN7Sd800001D<O?_i37ckn
000067oo0P006Goo000FOol00`00Oomoo`02Ool01@00Oomoogoo000047oo00<004:L@W/00T9l00E2
W49k000006400080025oo`03001c=g<g00=c=`03001c=g<g00Ac=`04001c=`000002LaH03P00LcM_
5W<gLaMc=flF001_5g<gKaMc=flGLcL30004KaL00`00KaM_5`03KaL01000KaL006[h0f/H00EZn000
JaQ[66[h009[6003001Rn@0000IRn@0B001JfP00001FfU[KF]YJfeKJF]/004ZlBY]:_4ZLB[a:V`00
1CIL00H001gl8O`Mo28L7O`2000010Vk2IX000FJ0`0000<9f`WL00000P001QiM00@004;n@alnoP92
oP03@alnoP0001Qoo`03001oogoo01Moo`005goo10000goo00<007ooOol047oo00D004JL@W]6W49k
00@00003H@00000001moo`09001c=W<gLcIc=g<fLcL007=G009c=`06KcMcEg<g001_=g=H0P0000M_
5P00KaIc=flFLcM_5P0200000g<gKaMc=`0300000g<h001_5`03KaL0;@00KaM_66/GKaQ_5flH001_
66/G001Vmf/HJ_P006KhJaUVn6/HI_Q[6FKh001RnFKjH_URnV;iI_YRnF;j001JneKJF]]FfU[kE]YJ
feKJ001:VdZlBY]:_00700002CIm000R71gk8Q`Mo28L000Ag002000010VJ0005VPFK0P0000<9^`WL
2K/0100000`RGQiM7Uh004<O?_i37ckn@alnoT<O000IOol00`00Oomoo`0FOol001ioo`80019oo`@0
0004@Ya6W49k0002H@02000NOol00`00LcMc=`03LcL00`00LcMc=`04LcL01000LcMc=flg0W<g00T0
06lFLcMc5g<gKaIc=`00LcL00`0000Ic=flG001_5flg0002KaL00`00KaM_5`04KaL01`00KaQ[5flH
001[66[h00800003JaQZn6/H009[6004J_P006LH0006H_T02`00H_X005[KF]YJfeKJF]]JfU[KE]X0
10000dZl00=:V`00=U`01@0000DMo27l7O`R7000008A^`8000041I/5VPFK1IX200000`WL2K/9f`07
0002@_h00d<O?_h00003000IOol00`00Oomoo`0EOol001ioo`03001oogoo019oo`090016W49kAYa2
NdJL@W/005d000<001aoo`08001c=g<fLcMc=W<g001cE`9c=`0@KcMcEg<g001_=g=HKcMc>6lg001_
=`00KaIc=flFLcL30000<g<gKaIc=flG001_5g<hKaMc>000KaL006lHJaM_66lGKaP006lHJaM_66/G
KaP006/H001[6FKhJaQVn6/II_P006KhJaT006;jH_UVnV;iH_X006;jH_URnP00F_]FfU[KE]YJn`02
00003UKJ001:VdZlBY]>_4ZKB[`003Ym=U`jOCIL>Wd6000010fk4M`=^a7K0P0000<5VPFK1IX01000
00D9g0008WhRGBIn00H00005@_i37d;n@al0000HOol00`00Oomoo`0EOol001ioo`03001oogoo01=o
o`070016W49kAYa2W4JL00000V400`006Woo00@006mI0000009c=`03001c=g<g00Ac=`800003LcM_
=g<g009c=`03001c>6lg00@0000>LcM_5g<gKaMc=flG001_5flgKaM_=flGKcL000I_5`0:001[5flH
KaM_66/GKaP006/HJ_P3JaP01f[h001W66/II_Q[6000009Rn@800008H_YRnF;iH_URnP00F]]JfP80
0004F]]Ffe[K0003B[`03TZKB[a:_4Zl000fO3IL>W`fG0008Q`V728L9Q`300024K/0217K00000000
1I/000gl3M`400001R9n8UdRGR9M8Wh00092oP06@am2oT;n@_i37`0067oo00<007ooOol057oo000N
Ool2000DOol02@00@W]6W49kAYa2NdJL001Q8004000HOol01000LeU_F7=i0P0000Ic=P00LcMc=flg
LeL2LcL02000LeQ_=g<hKcMcF000LcP400001flF001_5g<gKaIc=flG0080000[LcQ_5g<hKaMc>000
KcP006lHKaM_66/G001[5flHJaM_66/GKaP006lh001[66KhJaUVn000I_Q[6FKhJaUVn000H_T006;i
H_YRnF;jH_URnV;iH_X00P0001UFfU[KE]YJneKJF]/004jlBY]:_4ZKC[a:V`00=U`jOCIL>WdfG000
8Q`V728L9Q`R7003000010fk0009^`gL0`0000@Ao0gK4O`=f`D000078Ud00000@am2oT<O@_h01000
67oo00<007ooOol04goo000NOol00`00Oomoo`0DOol01@00@Ya6W49kAY`00`0000=Q0000G>000P00
5Woo00<006mIKeT016mI00<007<gLcL017<g00<007<gKcL00g<g0`0001Ic>6lgLcQ_=`00KaMc=flG
LcM_5g<g001_=flGKcM_5flg001_>6lGKcP0009_5`0;001[5flHKaM_66/GKaP006lHJaP00002JaP0
36[h001W66/II_Q[66LHJaUVn000H_URnP=Rn@0>H_YRn@00001RnP00F]]Ffe[KE]YJfeKK001:V`=:
_0/000069Q`R72HL000Eg1GK0`0000<9^`fk2K/0100000HAo0gL3O`002In9Wd70003@_h00dLN001o
o`0FOol2000DOol001Aoo`D000Aoo`03001oogoo01Ioo`@00003AYa2N`0000D001Ioo`08001_F7=i
KeQcFFmH001_F@800008LeMc=g<g001cF6lgLcQ_=`<00013KcMcF6lgLcQ_=`00KcL006lFLcM_5g<g
001c>6lGLcQ_5g<hKaL006lGLcQ_5flh001_6000KaQ[5flHJaM_6000KcQ[5flHJaL006Kh001Vn6/I
I_Q[6FKhJaUVn000I_P006;iH_YRnF;jH_T005kiHaYRn@00E]YJneKJF]]FfU[kE]X0100000Y>_4ZK
C[a:V`00=U`jOCYL>WdfG0H000035M`AfaGl00<000033M`9^`gK00L000049WhVGBYn9Wd2000024LO
@_i77d;nAam2oTLO000FOol2000DOol001Aoo`05001oogooOol00004Ool00`00Oomoo`0GOol01000
AYa6W4JK0TJL00@005BP001Hh08001Aoo`03001_FFmI00=_F@03001_FFmI009_F@800003LcL006lg
00<00008KcL006lgLcQ_=g<hKcL000=_>00G001_5g<g001_=flGKcM_5flgKaL006lGKcQ_5flhKaM_
>000KaQ_5flHJaM_600200004F/HKaQ[66lHJaP006LHJaUVn6/HIaQ[6FKh001W6F/I00000V;i00eR
nV;i001RnF;jH_URnV;i001FfU[KE]]Jf`0200000eKK001:_005B[`00`00>W`jO003>W`01@009S`V
72Xl9Q`00`0000<EfaGL5M/00`0000<9^`005O`00QGl00<F700000001@0000HVOP00@_i2oTLN@_h4
000GOol00`00Oomoo`0AOol001Eoo`03001oogoo00Eoo`8001Uoo`0:0012NdJL@W]6W49k001DP000
F<02000BOol01`00KeQcNFmHLeU_F000009_F@05KeQ_FFmIKeU_F0030000>VlgLeQ_=`00KcMcF6lg
LcQ_=g=H001c>6lgLeQ_=`00KaH006lGLcQ_5g<hKaL006lGLcQ_5flhKaMc>000KcP006lHJaM_66/G
001[5flHJaM_>6/G001[6000I_Q[6FKhJaUVn000I_Q[6FKhJaT006;j0P0000UNnF<JH_URnUkiHaX0
05[KE]X00P0001MJneKJF_/004jlBY]>_4ZKC[a:Vdjl000jOCIL>WdjG3Ym000Z?BHL:SdV72Xm00<0
00045O`0017L3M/300002A7l5QdAo1HM4O`F7@00:YhZO@0700001D;nAam2oTLO00005Woo00<007oo
Ool04Goo000FOol00`00Oomoo`04Ool00`00Oomoo`0HOol01@00AYa6W4JLAY/00TJL00<005BP0000
10003goo00<006mIKeT00fmI0P0016mI0`0000e_F@00001c=flg001_=g<hKcMc>6lgLcP00006KcP0
6P00KaM_=flGKcM_5`00KaM_>6lGKcQ_5flh001_>6lH001[5flHKaL006/HKaQ[66lHJaP20002JaP0
2000IaQ[6FKh001W6F/II_P2IaT02f/I001RnV;iH_YRnF;jH_URnV;iH_X00P0000MFfU[KE]]JfeKJ
F]/00006B[`5000023Yl000V72Hl9Q`Z?2HL00026O`300000a7L4M/Ag00400001QGl5Q`Eo000:WhZ
WP8ZOP03000ZWP000096oP06Aai2oTKnA_i77P005Woo00<007ooOol047oo000GOol00`00Oomoo`03
Ool00`00Oomoo`0IOol01@00AYa2NdJL@W/00P0000EHX5B0000005BP008000eoo`0:001_F7=iKeQc
FFmHLgT006mIKeP300001FmH001[FFmIJeT00P00011c>000LeQ_=g<hKcMcF000LcQ_=g=HKcMc>6lg
001_>080000kLcQ_5g<h001c>6lGKcQ_5g<hKaL006/GKcQ_5`00JaL006/GKaQ[5flhJaM_6000KcQ[
66lHJaP006Kh001Vn6/II_Q[6FKhJaT006/I001S6V;iH_YNnF<JH_URnP00HaX005[kE]YJneKJF_]F
fP00BY]>_004000014ZKC[`003im1`0000<Z?BHL00000QWl00LIn`00000000gK4O`Af`07000012Ym
:YhZOBZN0P0000Q2oTLO@_i77d;nAam2oP005Woo00<007ooOol047oo000HOol00`00Oomoo`02Ool2
000KOol40002AY`00`00F:00000200000eBP0000000:Ool200000f=l00000003KeT40003KeT00`00
KeU_F@04KeT01`00LcQ_=g<hKcMc>00000I_>004001_>6lhKcP200005Vlg001_>6lGKcQ_5flhKaL0
06lHKcQ_66lhKaP006/HKaQ[66lHJaQ_60001V/H00@006LIJaUVn09W6@03JaT006LI009W6@0@001R
nV;iH_YRnF;j001RnUkj001Ffe[KE]YJfeKKF]/300002DjlB[a:_4ZlC[a:_000>W`jO@03>W`00`00
:S`Z?00500036O`600000aXL6QdJ700700000bYn0012oP02A_h00dLN00000002000FOol00`00Oomo
o`0?Ool000Eoo`800003Ool0000000Yoo`05001oogooOol00004Ool00`00Oomoo`0KOol01P00AYa6
VdJLAY]6W0<00005D8000000C6000008Ool01@00HgeOO6=mGg`01@0000E_F6mIKeU_FFmH00800007
KeU[FFmJJeU_F@00KeX00P0000Y_=g=HKcL006lgLeQ_=g<hKcL000=_>00^LeQ_>6lh001c>6lGKcQ_
5g<hKaL006/GKcQ_5flhJaL006/H001[5flhJaM_6000KcQ[66lHJaQ_>6/H001[6000I_Q[6FKhJaT0
06/II_Q[6FKh001NnF<JH_T200001f<JG_URnUki001FfU[k00<0000FF_]FfP00B[]>_4ZKC[a:^djl
BY/003Yl?WdjO3jM>W`002Xl;SdZ?2Xm:S`300001QWk000Eo1Gl5M`Io0@000066Q`J7AHL000ZORjN
1`0000E77T;nAam6oP0001Ioo`03001oogoo00ioo`0017oo00<007ooOol00P0037oo0`0017oo00<0
07ooOol07Goo00<004JLAY`00dJL0`0000E@H000001<H00000Ioo`05001SO6=lHgeSO0040007KeT0
0`00KeU_F@03KeT01000KeY[FFmI0P0000=_=`00KcP016lh0P001Flh00d006lh001_>6lGKcQ_5`00
KaQ_>6lHKcQ_600200001FlhKaP006/HKaP00P001F/H00@006/HJaP0009W6@03JaUVn000009W6@06
I_UW6FLI001Rn@000V;j00ENnV;jH_YRnUkj00800009F]]FfeKKE]]JfeKK001:_4jl00=:_005C[`0
03Yl>W`jO@03>W`01P00:S`Z?2Xl:Sd0008N70<000DEo0L000<^WP03000^WP0000=6oP05Aai6oTKn
A_h0000DOol2000:Ool30003Ool000Aoo`05001oogooOol0000COol00`00Oomoo`0NOol01P00AYa6
VdJLAY]6W0<00005D8000000C6000003Ool200000f=mGg`00002000015ml000006=m0P000VmI01M_
F6mI001_FF]IKeY[FFmI001_FV]IKeY[FFmJJeT006lgLeQ_=g<hKcMcF000009_>015LeQ_>6lh001_
FFlhKcT007<hKaM_>000KcQ_5flhJaM_>000KcQ[5flhJaP006/G001[66lHJaQ_>6/H001[66liJaQ[
6@00JaUVn000I_Q[6FKhJaUVn6/II_P005kiHaYNnF;jG_US6Uki001Nn@00E]YJneKJF_]FfU[kE]X0
04ZkC[a:Vdjl00d00005:Sd0028M7O`N7003000021Gl5M`Io0007SdN728m7Sd700001RYn0012oTLO
A_i77P@001Eoo`03001oogoo00Ioo`05001oogooOol00002Ool000Aoo`05001oogooOol0000COol2
000POolD0002Hg`200001EmlHgeOO6=mGg`00P0000=_F@00KeT016mI0P0000M[FFmIJeU_FV]I001[
FP020003KcP00`00KcQ_>004KcP00`00KcQ_>002KcP04000KcP006lhKaQ_>6lHKcP006lhKaQ_>6lH
KcQ_60001F/H0P0016/H00<006Kh00000VLI00UVnFLIIaUW6FKi001W6@00G_X00f;j00ENnP00G_YR
nP00009Ff`05F]]FfeKKE]]Jf`050002B[`01Tjl000nO3il?YdjO08nO003000^?00000@0008N7003
7O`0000000@000DN?@04000bWRjN<Yh700001DLNA_i6oTKn00005Goo00<007ooOol01Goo00D007oo
Oomoo`00009oo`0017oo00D007ooOomoo`0001=oo`03001oogoo021oo`08001:_4JKAYa6VdZl000R
708000039]hZgbKN00D0000MGg`00000HgeOG6=mGeaSOEmLHgeOG6=m001_FF]IKeY[FFmIJeT006]I
KeY[FFmJJeT006/iKeY[F@0200001G=H001_>6lhLeP00flh034006lhKcU[>6mIKcQ_>@00KcQ_5flh
JaM_>000KcQ[5flhJaQ_>6/G001[6000JaQ_>6/HKaP006liJaQ[6F/HKcU[6000I_Q[6FKhJaUVn6/I
I_P006KiIaT006;jG_US6P0200002EkiHaYNnV;j001JneKJF_]FfP0200005E[kE]X004ZkC[a:^djl
B[/003Yl?YdjO3jM>W`nW@00;UdZ?2iM;S`^G@0300001QhL000N7AWl7QdIo0<0000D7Q`R?Ahm7Sd0
03:n;YhbWP00<[h^WP00A_i77TKnAai6oTLNA_h001Aoo`03001oogoo00Eoo`05001oogooOol00002
Ool000=oo`80009oo`8001=oo`03001oogoo025oo`030016W4JL00=6W003000R728L00<000039]hZ
gR[N00<00009GgaSOEmlHgeOO6=mGgaSOEml00800003Ggd0000000=_F@07001[FFmIJeU_FV]I0000
0V]J00E[FF]JJeY[FP0000I_>003001_>6lh00A_>006001_>@00001_66lh0P0000U_66lhKaQ_>6lH
001[66lh00000f/H00<006/HJaP016/H00@006/H001Vn@=W6@80009W6@0<I_UW6@00H_X006;jG_YR
nUkjH_YNnP000UKK0P000eKK00EJf`00B[a:_4jl00=:_00=000jO3il?W`nWCYl?W`002iM;S`^GBhl
00000R8L0`001AXL1P0000P^WS:N;YhbWP00<Yh^WP000dKn00=77P0000000P0057oo00<007ooOol0
17oo10000goo000LOol2000ROol01`00AY]:_4JKAYa6VdZl00<000039Qd0000000800003:]h^ob[N
00800005HgeOG6=mGeaSO@02000015mLHgeOG6=m0P00019[F@00JeU_FV]IKeY[F@00JcU_FV]IKeY[
>FmJ001[FP00LeP3KcP02`00KcQ_>F/hKeU_>6li001_FF/hKcT00P0002e_5`00JaM_>6/HKcQ[5`00
JaQ_>6/HKcT006lH001_>F/HJaU[66liJaP006LHJcT006/II_Q[6@00IaUVnFLII_UW6FKiIaT006;j
G_US6UkjH_YNnF<JG_X00P0000aJneKKF_]FfU[kE]]Jn`00C[a:^djlB[/;00001bXl;Ud^?0008Q`R
?B8L00<000086O`N7AWl000R?B9M8SdVG@d00005Bai6oT/NA_h0000DOol00`00Oomoo`03Ool00`00
Oomoo`04Ool001]oo`8002Aoo`030016W4JL00H000038Q`000000080008^g`03;_lZgRkO0080000;
Gg`00000HgeOG5mmGgaSOEmLGgeOO00200001FmIJeU_FV]I00000V]J00E[FF]JJeY[FP0000=[FP05
001_>6lhKcP00005KcP03@00KcU[>6liKcQ_>F/h001_66lhKaQ_>6lH00800006KcQ[>6lhJaQ_>000
1V/H00P006/HJaU[66/I001W6@000fLI00aVnFLIIaUW6@00IaT006;jG_YRnUkjH_X200000ekj001F
f`02E]/015[KE]]FfeKK1@0000E:_4jlB[`003il008nW004?YdnO000;Ud400001B8m8Q`R728L8Sd0
1P0000hR?B9M8SdRGB8m000bWS:n<Yh003:N<[h004LN0dKn00E77TKnA_i6oP0001=oo`03001oogoo
00Aoo`03001oogoo00=oo`005Goo0`000goo00<007ooOol08goo1@0000=:_4JKB[`0100000<1>000
00001`0000QOG6=mGeaSOEmLHgeOG6=m0P0001YOG000000006]I001[>FmJJeU_FV/iKeX006]JJcU[
FV]IJeX007=H001_>F/hKeU_>6li0P0003Y[>6liJcQ_FF/h001[>000JaQ_>6/GKcP006lhJaQ_>F/H
KcP006li001[6F/HKcU[66/I001[>F/HJaUW66/i001W6FKiIaUVnFLII_UW6@00IaURn@00G_YRnUki
HaX006;jG_YS6P00F_]FfU[kE]]Jn`80000CE]]Jn`00C]a:^djlB[]>g000?YdnO3jM?W`nWCil000^
G39M;U`01@0000HR728m000R?AhL8Sd500004BIM8Sd003:M=[hbWP00<Ydf_P00Bai6oT/NA_i;7TKn
Bah00P004Goo0`001Woo0`000Woo000FOol00`00Oomoo`02Ool00`00Oomoo`0POol30002Ool01@00
AYa6W4JLB[`00TJL00D002Hm0000004h00@00004<_l^oS;o;_l2000015mmGgaSOEmL0P0000EOOEmL
GeeOG5mm0080009[FP06JeU[FV]JJeY[F@001V]J00<006lhKcP016lh01P006/hKcU_>6liJcP006/i
KcT006lhKaQ_>000KcQ[>6lhJaQ_>000KcU[66/h0003JaP02`00JaU[66/IJaQ[6@00JaT006LII_T0
0fLI00L006LIIaUW6FKi001NnP020002G_X01V;jG_YNnP00F]]Ff`80000>E_]FfeKKE]/004ZlC[a:
_4jlB[a>_000?YdnO08nW00:?Yd0039M;UdbGBiL<Ud002Hm9S`5000011hL8SdN70000RIM200000Db
WP00A_i77TKn00@00003B_i6oP0000ioo`<00003Ool007oo00Yoo`005Woo00<007ooOol00Woo0P00
7Woo0`001Woo00X004JKB[a6VdZlAY/002HL9SdV708000080CT00000000bobkN<_l^gP800009Hgd0
0000GeaSOEmLGgeOG6=m0080000@Ge`00000KeY[>FmJJeT006/iJeY[FF]JJcU[FP00JeX20000?6lh
KcU[>000JcQ_>F/hKeU[>000JcQ_FF/hKcT006lh001_>6/HKcU[66lh001_>F/HKcU[66li001[6@00
JcU[66/IIaQ[>@00JaUW66/i001W6FKiIaT006LIH_UW6VKiIaURn@00G_YRnUkjHaYNnV;jG_YS6P80
000=E]YJneKKF_]FfU[kE]/004ZkC]a:^djlB[/02`0000P^G39M000V?BHL9SdV?2Hm1P000bIM00DV
GRIM000bWCJn00H00007A_e;7TKnBai6oD/N00002Woo100017oo00<007ooOol02Goo000BOol60003
Ool00`00Oomoo`0JOol3000:Ool02P00AYa6W4JLB[a6W0009S`V?BHL3@0000MOG5mmGeaOGEmLGgd0
0003Ged01UmLGed00000JeT000I[FP04001[FV]JJeX200001flh001[>6liKcQ_>F/h0080000>KcU[
>FliJcU_>@00KcQ[>6lhJaQ_>6/h001[609[>00:KcU[66/h001[6F/HJaU[66/I0003JaT01F/HJaT0
06LI00000fLI00QVnFLIIaT006;i001NnV;j0ekj0P0000=NnP00E_/00eKK00IFneKKE]/004jlB[`3
000014ZlC[`004:M0cjL00A2W@00<UdbG@D000049S`V?BHl00038Sd012Hm000000000bIM00D003Jn
=[hf_P00008f_P0:0016oT/NA_i:oTKnBai6oT[n0006Ool30008Ool00`00Oomoo`09Ool001=oo`04
001oogoo0004Ool00`00Oomoo`0GOol3000>Ool900000bHL0001F@0500001C;N=_lboSKo<]h00P00
02UOOEmL000005mmGeaOOEmLGgeOG5mmGe`006/iJeY[FF]JJcU[FP00JeYW>V]JIcY[FVLj001[>6li
JcQ_FF/hKcT006mIJcQ_>F/hKeT006li0080000cJaQ_>6/H001[66liJaQ_>F/HKcT006li001[6FLH
JcT006/IIaQ[>FLHJaUW66/i001W6F;iIaYVnFLIH_T006;iIaX006<JG_YRnUkj001NnV;jG_X005KK
F_]FfU[kE]]JneKJ00<0000BB[]>g4ZlC]a:^`00?Ya2WCil@YdnW000<U`fOC9L<WdbG3Im1P0000DR
?2Hm8S`V?B8l00H0000;=[hbWCJn000f_S:M0016oT/NA_e;7P040003Ool3000<Ool00`00Oomoo`08
Ool001=oo`04001oogoo0003Ool2000FOol3000BOol02000AYa:_4JLB[a6W000:S`300000`5I0000
00030003<_l00cKo0000000200001EmLGeeOGEmMGe`00emM0P0000=OG@0000000f]J00<006]JJeX0
16]J00h006MJ000006liJcQ_>@00KcU[>FliJcU_>@000f/i0P0000=[>000JaP00V/h00Y_>F/HJcP0
06/iJaQ[>@00JaT000=[6@09JaQ[6F/IJaT006/I001W6FKi009W6@03001RnFLI009W6@04001NnP00
0005G_X00`00E]]Fn`040002E]/00`00C[a:_003C[`014Zl000nW4:M0cjL00/0039L<UdbGC9m<U`0
02Xm:UdZ?2Xm00<0008R?@069Sd002Ym:UdZOBYM30000T[n00=;7TKn00000P003goo00<007ooOol0
27oo000DOol00`00Ool00003Ool00`00Oomoo`0BOol3000FOol02P00AY]:_4JLB[`002YM:S`ZGBXl
2P0000@focKn=alfoP800004GgeOG5mmGe`2000015mMFeaOOE]L0P0000a[FP00JeYW>V]JIcY[FVLj
001W>V]JIcX20000>Vli001_FF/hKcU[>6mI001_>F/iKcU[>FliJcT006/HKcU[66liJaQ_>@00KcU[
66/iJaQ_>@00JaUW66/iIaQ[6FLHJcT006/IIaP006KiIaURn@00H_UW6V;iIaYRnFLJ001S6ekjH_YN
nV<KG_YRnUkj0P0000eJneKKF_]Ffe[kE]/004ZlC]a:^dkLB[a>g00;0000239m<U`002Xl:UdV?2YM
:S`600005BYn:UdZORIM:Wh003Zn=[d003Jn>[hf_@00A_e;7TKmBai6oD/NA_d0000@Ool00`00Oomo
o`08Ool001Eoo`8000=oo`03001oogoo00moo`<001Uoo`0;001:_4JLB[a6W4Zl000Z?BXl:SdZ?009
0005=_l2000015mM000005mL0emM00=OG5mMGed00P001V]J00l006MJJeYWFV]JIeY[FP00KcU[>Fli
JcU_>F/i00001F/i018006/i001[>6liJaQ[>000JcU[66/iJaU[>@00JcT006/IJaP3JaT02@00JaUW
6F/IIaT006LI001Rn@03IaT01F;iIaT006LJ00001Ekj0P0000ANnP00E]]Fn`=Ff`03E_]Ff`00009>
_0<00009C]a:_000@Ya2WCjL@Ye2W000008fO@D00008:UdZ?2Xm000VGBHm9UdV?@D0000>:UdZO@00
>[hf_P00=[hj_SJn001:oT/NA_i:oP@000moo`03001oogoo00Qoo`006Woo00<007ooOol03Goo0P00
7Goo00@004ZlAY]:_0H00003:S`000Ej00D000030IT0000000L00006FeaOGE]LGgeKG5mM0P00011K
G5mM000006LjJeYW>P00IcY[FVLjJe]W>V]J001[F`80000:JcQ_FF/h001[>FliJcU_>F/i0002JcT0
=000KcU[66li001_>F/HJcU[66li001[>FLHJcT006/IIaQ[>@00JaUW66/iIaU[6FLH001RnFLJH_UW
6V;iIaX006LJH_T005kjHa]NnV;j001S6ekjG_]NnP00E]]JneKKF_]Ffe[k0`00019>g4ZkC]a:_4kL
0012WCjL@YdnW4:M000fOC9L=WdbG3Im<U`6000022YM9S`ZGBHm:Ud002in:Wd>00001D/NB_e;7TKm
00003Woo00<007ooOol027oo000JOol2000;Ool3000POol30003B[`00`00;Ud0000:0000106j0000
03Ko0c[o0`0000IOGEmL000005mMFe`3Ged2000036]J001WFV]JIeY[FVMJJeX006MKIcYWFP800003
JcT006/i00A[>@03001[>F/i009[>@0J001[>000JcU[66/iJaU[>@00JcU[6F/iJaU[>@00JaT006/I
IaU[6FLIJaUW6@00IaT0009W6@09H_T00000IaYRnFLJHaT005kj008000INnP03001FfeKk00<00006
E_]Ff`00C[a>g4Zl0Tjl00Q>g000@Ye2W4:M?Ya2W@001CIm00D002iM;Ud^GBYM00D000039SdVG@00
008^O@06;Wh^OBim000j_P0013Zn00<004[nBah00d[n00=;7P00Ool03Goo00<007ooOol027oo000J
Ool00`00Oomoo`07Ool3000TOol02`00B[a6VdZlAYa:_000;UdZ?2iM:S`02`0000@foS/O=_hk7`@0
0008FeaOGE]LGeeKG5mMFeaOG@80000EIcY[FVLjJe]W>V]J001[FfLjJe]W>V]KIcX006/iKcU[>Fli
JcU_>@00009[>@0`JcY[>F/i001_>F/HJcU[66liJaP006LHJcU[6F/iIaQ[>@00JaUW66/iIaU[6FLH
001W6F/IIaT006;i001RnFLJH_UW6V;iIaYRn@00G_YS6ekjG_]NnV<KG_YNnekj0P00015FneKKF_aF
feKk001>g4ZlC]a:^dkLB[`003jL@YdnW4:M00H00009<U`fO@00;UdZG2iM:S`^G@00008ZG@L00006
:Ud^OP00>[h003[N0SZn00Hf_@00B_e;7TKmBah3000=Ool00`00Oomoo`08Ool001Uoo`03001oogoo
00Eoo`<002Qoo`03001:_4ZL00=:_005000^GBiM;Ud000022K/600000`7K0000000300000c/O>_lj
o`0200001E]LGeeOGEmMFe`00P0000YOGE]L000006]JIeY[FP00Ie]W>P9WFP04Ie/00000IcX20003
JcT00`00JcU[>@03JcT05P00JcX00000JaU[>F/H001[6F/iJaU[>F/IJcT006/i001[6FLIJaUW6@00
0fLI00e[6FLI001S6FLJH_UW6V<IIaYRn@00HaX00006G_X30002E]/01UKkE]]FfeKKE_/0009>_003
C]a:_00000D00004@Ye2W4:M0002=Wd700000bYM;Ud00004:Ud01000;Wd^OBim3P000T[n00=;7P00
Ool02goo00<007ooOol027oo000IOol30002Ool3000/Ool01000B[a6VdZl1@0000<^G@002K/00PVk
1P0000P1f`00000o7c[n?aljoSlO0P0000UKG5mM000005/lGeeK?5mMFc`00P0000a[FP00Je]W>V]K
IcY[F`00Ie]W>V]KIcX200001Fli001[>F/iJcX00V/i00@006/jIcU[>P80000UJaP006LHJcU[6F/i
IaQ[>@00JcUW6@00IaU[6FLH001W6F/IIaU[>FLI001W6@00H_UW6V;iIaYRn@00H_UW6P00G_]NnV<K
G_X00P0000YO6ekjG_/005[lE]]FneKKF_aFf`D0000CB[]>g4Zl0012W4:m@Ya2_D:L000fO3Ym=W`j
OCIl>Wd0039m;Ud01@000bYM01H002im<Yh^OC:N;Wd003Zn?]h003kN>[hngSZm001:oD/NB_e;7T[m
Bah000aoo`03001oogoo00Moo`006Goo00<007oo00000P00<7oo0`000dZl00<0039M00000`000PVk
2@000S[o00<k7c[o00000`0000QOGE]MGeeKG5mMFeeOGE]L0P0000iWFfLjIeYWFVMK001WFfLjIe]W
>VMKIcYWF`001F/i00<006/jJcT00V/i00Q[>V/i001[6F/iJaU[>F/I0P0000M[>F/IJcU[6@00IaT0
0003IaT00f/IIaT00002IaT01000IaYS6FLJ0P0000IS6VLJH_US6P00G_X200000ekjG_]NnP02G_X0
0`00E]]Ff`0400000eKK001>_002C[`02dkLC[a>_4jl0012W4:M@Ya2WD:L00001CIm00P002iM;Ud^
GBim;Ud002iM100000TbORim;Wd^OC9n;Wd003Zn00000cZn00HngP00B_i:oT/NB_d4000;Ool00`00
Oomoo`07Ool0015oo`<000Eoo`8003Aoo`0:001:_4JKB[a:W4Zl000bOBiL<Ud:00000`Gk00000003
00000c[n?aljoP0200001EmMFcaOGE/lGed00P0000EK?5mM000006Lj00800006Ie]W>V]KIcYWFfLj
0P0000=WF`00JcX00V/i03<006/jIcU[>VLiJcYW>@00IcT006/IJcUW6000IaU[>FLIJcUW6F/iIaT0
06LIJaUW6F/iIaT006LIJcYW6FLJ001W6P00IaYRnFLJH_UW6V;iIaX005kkG_YO6ekjG_]NnUlKG_X0
0P0000eJo5KKE_]Ffe[lE]/004ZkC]a:_4kLB[]>g00;000033Ym=W`002iL<Wd^GC9m;U`002YM;WdZ
G@D00007;WdbWP00?]hj_P00>[d01`0000E:oDlNB_e;7P0000Yoo`03001oogoo00Moo`0047oo00D0
07ooOomoo`0000Eoo`03001oogoo039oo`03001:_4Zl00A:_007000bGBiM<Ud0017L3M/00P0000<1
>00000000`0000H:7000000noclO?_h2?_l2000015mMFed000000e]M00eK?5]MFed006LjIe]W>VMK
IcYWFfLj001W>P02Ic/01FMK001[>@00JcX00f/i01M[>V/i001W>F/jIcT006/I001[6F/iJaU[>F/I
JcU[6@00IaT006LIJaUW6@0000IW6@05001S6V<JIaYRn@02HaX01FLJ001S6P00G_/00ekj00ENn`00
001NnP0000=Ff`06E_]FfeKK001>g4jl100000]>g4jl0012W4:M@Ya2_D:L000jOCZM00L0000:;Wd0
02im;Ud^OBiM;Wd003:N<Wd700001Cjn?]hn_SkN00000T[n00E;7T[mB_i:oP0000Yoo`03001oogoo
00Moo`0047oo00D007ooOomoo`0000Ioo`8003=oo`05001:W4ZlAY]:_00500001C9M000Ag0gK4M`0
2P0000@joSlO>_ho7`@00006FcaOGE/lGeeK?5mM0P0004]K?000001[FfLjIe]W>P00IcYWFf<jIe]W
>VMK001[>VLiJcYW>F/jIcT006LiJcYW>F/jIcT006LIJcUW6F/iIaU[>FLI001W6F/jIaT006LI001W
6F/jIaUW6VLIJcX006LJ001W6V;iIaYRnFLJ001S6V;i001NnUkkG_YO6`00G_]JnUlK001FneKKF_aF
feKkE]/00`0001E:^dkLC[a>g4ZkC]`004Jm@Ya6_D:LA[d003ZM=W`jWCIl>Yd0039m;Ud01`0001HZ
GBin000bWS9m=YhbOC:N000ngP00?]hj_CkN>[d004[mCai:oD/NB_e?7P8000Uoo`03001oogoo00Mo
o`0047oo00D007ooOomoo`0000Qoo`03001oogoo035oo`@000=:_003000bO@0000<000033M/Ag000
00H000033Sd0000000<00003?alnoclO0080009KG@07FcaKG@00FeeK?E]MFcd00P0000AWF`00001W
>P9W>`05Ie]W>VLk001WF`02000066/iJcY[>@00IcU[>VLiJcYW>@00IcX006/IJcU[6F/iJaT006LI
JcUW6F/iIaT000IW6@05001W6FLI001Rn@02HaX20003HaX00f;j001NnP02000025kkG_YNnekjG_/0
05KkE]/300004EKKE_/004kLC[a>g4jlC]a>_4kL0012_D:L@Ye2W4:m00000SYm00@jWCYm>Wd000Db
O@03000bOBim00L0000<<YdbWP00?]h003kN?[hngSjn001:oD[n0`0000=:oT[m000027oo00<007oo
Ool01goo000@Ool4000:Ool00`00Oomoo`0aOol01000B[a:_4ZK0TZl00D0039L=WdbG3Im00D00003
0GX0000000P00004?_i37ckn@al200005U/l000005mMFcaKGE/lGeeK?5]M001WFfLjIe]S>VMKIcYW
F`00Ie]S>VMK0P0003AW>@00IcU[>VLiJcYW>@00IcU[>VLI001W6F/iIaT006LIJcYW6F/jIaT006LI
001W6FLJIaU[>P00IaYW6FLjIaT006;i001RnF<JH_UW6V;iHaYRn@00G_YNne[jGa]NnUkkF_YO6`80
000=E]]Fo5KKE_aFf`00C[a>g4ZkC]a>_4kLB[/02`00014fO000<UdbOBiM<WdbG@00;UdbORim<Wd^
GC9n000fWS:M00`00007Cai:oDlNB_e?7T[m00001goo00<007ooOol01goo000@Ool00`00Oomoo`0<
Ool00`00Oomoo`0aOol00`00B[a:_003B[`00`00<UdbO@02<Wd00`005O`Eo00200000`5i0000000?
00001U]MFceKGE/mFeeK?@800006Fed00000Ic]WFfLj0P0000eWFf<kIc]W>fMKHc/006LiJcYW>F/j
IcT00003IcX03V/jIcX006/I001W6F/iIaU[>FLI001W6FLj0003IaT01000IaUW6FLJ0fLI00<006;j
HaX00V<J00]RnV<J000006;j001NnUkkG_YNnekj0080000;G_/005KkE]]FneKKE_]Ff`00C[a>g004
00002Tjl0012_4Jm@Ya6_D:lA[d003ZM1`000S9m018002im<Wd^OC9m;WdbO@00=YhfWCJN=YdfWP00
?]h003kN?[h2?]h01`00B_e:oT[mBai:oD[n008000Ioo`03001oogoo00Moo`004Goo00<007ooOol0
37oo0P00<Woo00@004ZlB[a:V`H00003=Wd001Gl008Eo0P000034SdFGA8m00800004@alnoT<O?_h3
000025/lGed00000FcaKGE/lFed2000026Lj001S>VMKHcYWFf<jIe/20000?6<j001W>F/jIcT006Li
JcYW6F/jIcU[>VLI001W6F/jIaU[>VLI001W6F/jIaU[>P00JcX006LJIaUW>VLIIaYW6@00HaT006;i
IaYRnF<J001S6V;jHaX005lKG_YNne[j001JnUkkF_X005KKE_aFfeKlE]]Fo0<0000EC]a:^dkLC[a>
g4Zk0012W4Jm@Ya6_D:L000jO3jM>W`jWCYl000bOCIm00h0000;<Yd003jm000n_CkN?[e2gP00Cai:
o@0400000dlNB_d00006Ool00`00Oomoo`06Ool0019oo`<000eoo`03001oogoo031oo`<000=:_003
000fO@0000@000035O`0006J008000030ET0000000L00004@am2oT<O?_h40002Fcd02U]MFceK?E/m
FeeK?@00Ic]WFf<k0VLk00UWF`00Hc]S>fLkHc/006Li00000fLj019[>VLjIcYW>P00IcX006LIJcUW
6@00IaUW>VLIIcUW6FLj0002IaT01VLJIaUW6FLI001W6@9W6P06001RnP00001S6V;j0f<J00`005kk
000005kjG_]NnUkkG_X005KKE_/300000eKkE]/00002C]`03DjlC]a>g4kL0016_D:lA[e2W4Jm@[`0
03Ym00<jW@08>Wd0039m=WdbOCIm<Wd000DbO@03000fWCJN00`00007B_e:oT[mCai:oD[n00001Woo
00<007ooOol01Woo000SOol00`00Oomoo`0`Ool02`00B[a:_4ZkC[a:_000<U`fOCIl=Wd0100000D1
NPFK0000004h00/00003@_i37d;n00800005FeeK?5]MFcaKG@0200005ULl001S>VMKHcYWF`00Ie]S
>VMKHc]WFf<j001W>F/jIaU[>VLiJcYW6@000VLj011W6@00IaT006LIJcYW6F/jIaU[>P00IcX006Lj
IaUW6P80000GHaUW6V<IIaYS6@00H_YS6V;jHaYRnV<JH_YS6P00Ga]JnUkkF_YO6e[jG_]JnP020000
2eKlE]]Fo5KKE_aFf`00C[a>g4ZkC]`04`0001`fWC9m000bOCJN<WdbWS9m000fWCZn=Ydj_SJM000n
_@00?[e2gSjm@]h004lNB_e?7T[mCai:o@8000Eoo`03001oogoo00Ioo`0097oo00<007ooOol0;goo
00<004ZlB[`014Zl00D003Im=WdfO@00008J70<000030IX0000000D0008JG@086Uh00000@_i37d;n
@ai2oP80009K?@8000AK?@04001W>`000002Hc/01VLkHc]S>f<k001S>`800003JcYW>VLj008000EW
>P0@001W6FLjIaUW>FLIIcX006LjIaYW>P00IaT006LJIaT3IaX01FLI001W6P00H_X00f<J00YRnP00
001S6P00G_]NnUkkG_YNn`800009F_X005KKE_]FfeKkE]]FneKK00@000=>g00@0016_DJlA[e6_4Jm
A[`003ZM?YdjWCjM>Yd003Im=Yd700004S9m000fWSJM=YhfWCJN=Yd003kN000ngT;N?]i2gP00Cai:
o@<00003B_e>o@0000Aoo`03001oogoo00Ioo`009Goo0P00<7oo00D004jlB[a:_4Zk00D00005=W`0
01Wl7QdIo00700000`6j00000005000014;n@am2oT<O100001=K?5]MEcaKGE/lFeeG?000Hc]WFf<j
Ie]S>fMKHcX006<kHe]S>`0200000f/j001[>P02IcX02FLIJcYW>P00HaX006LIJcYW6@02000076Lj
IaU[>VLIIcX006LJHaUW6V<IIaYS6@00HaUW6P00HaYRnV<JH_X005kjHa]NnV<J001O6e[j0P0000UO
6e[jG_/005KlE]]Fo5KKE_`00P0001eFf`00C[a>g4jlC]a>_000@Ya6_D:LA[e2W4Jm000nWCYl?Ydj
W3jM000fWCIm=YdfOCJM=Wd0039m01<00007B_e?7T[mCai:oDlN00000goo00<007ooOol01Woo000W
Ool00`00Oomoo`0^Ool40003B[`00`00=Wd0000700000`Fk0000000300000`6k000ROP07000014<N
@_i37`001E/m0P0000AK?@00001W>`9S>`8000IS>`03001W>VLj00AW>P0?001W>VLjIcX006LI001W
6FLjIaYW>VLIIcX006Lj0080009W6P08IaT006LJIaYS6VLJ001S6P80009S6P04H_YS6V<JHaX20002
G_/01e[jG_]Nnekk001FneKK00800004E_]FfeKl0006C]`01@00A[a6_DJlA[d01P0000<jWCjM0000
0SIm010fWCIm=Wd003JM=WdfWCIm=Yd003Zn>Ydj_SZM>[hjW@8000=2gP0:@]e2gP00Cai:oDkmB_e?
7T[m0003Ool00`00Oomoo`06Ool002Qoo`03001oogoo02ioo`0;001>g4ZlC[a:_4kL000jWCIl>Ydf
O@0600000`WK1K/0000500003R9n7WdROQiM0012oTLO@_i77d;nAal005]MFc`2000015]MEcaK?ELl
0P0000QWF`00Ie]S>f=KHc]WFf<k0P0000ESG000IcYW6F/j0080000@HaYW>fLjIcYS6P00IaUW>VLI
JcYW6FLj001W>VLIIcX200003f<I001S6FLJHaUW6V<IIaX006<JG_YS6ekjHaYNnP0200002F<K001O
6e[jG_]JnUlKF_YNn`0200002eKKE_aFfeKlE]]Fo000C]a>_4kLC[`01P0000I6_D:LA[d003jM>Y`=
0000539m=Yh003Zn=Ydj_SJM>[h004;N0012gT;M@]hn_@00B_e?7T[mCah40002Ool00`00Oomoo`06
Ool002Uoo`03001oogoo02ioo`03001:_4Zl00=:_003000jOCIm008fO@8000038SdN?B8m00<00004
1K/000001M/500001Qin0012oT<O@_i37P@000MK?@8000ES>`8000AS>`03001W>P0000IW>P06001W
>P00IaYW>VLI0P0000MW>VLJIcYW6VLjIaX00002IaX02F<JIaYW6VLJ001S6P00HaYRnP02HaX01P00
G_YS6V<J001JnP=Nn`0;F_X00000G_/005KkE]]Fo5KKE_]Ff`050003C]`01`00A[a6_DJlA[e6_000
00HnW@07000jWCJM>YdfOCZM00000SJM500000E>oD[mCai:o@00009oo`03001oogoo00Eoo`00:Woo
0P00;goo00@004kLB[a>_0X000037Q`000WK008000051K/1VP000005o00900000dLO@_i77`030000
0e/mEc`0000200001ELlFcd00000Hc/00P000V<k00USG6<kHc]S>f=L001W>V<JIc/00VLj01aS6P00
HaYW>f<J001W6@00HaUW>VLIIcYS6FLjIaT006<I001S6FLJHaUW6P00IaYS6FLJ001S6P800008G_YS
6ekjHa]NnP00F_YO6`800007F_YO6e[jG_/005KlE]/00`00011FfeKl001>g4jlC]a>_4kLC[`004:L
A[e6_4Jm@Y`0008nW@0F>Y`n_CjM000fOCZM=WdjWCIm000fWCZN=WdjWSJM>Yh003jn>Ydn_SZM?[h2
00003D;MA]i2gD;N@]d004[mCai:oDlNB_e?7P00009oo`03001oogoo00Eoo`00;7oo00<007ooOol0
;Goo0`0000I>_4ZlB[`003ZM>Wd3>Yd400001@gK3M`000001KX01@0000<VORJN8Wh00`0000A2oTLN
A_i77P@00005EceK?E/mFceG?@02Fcd00`00Hc]S>`05Hc/200000f<k001W>P02IcX20005IcX03000
IaYW>VLJIcYW6VLjIaX006LJIcX000=W6P04001S6V<JIaX2HaX00`00HaYNnP03HaX00ekjHaYS6P02
00001ekkF_]Nne[kG_]Jnekk00800006E]]Fo5KKE_]Ff`001TkL4@0000<jWCIm00001CJM00L003Zm
>[hj_CZn>[dj_P0200002D;M@]i2gT;N001>oD[mCai:o@0400000goo001oo`06Ool002eoo`03001o
ogoo02eoo`0>001>g4ZlC]a:_4kL000jWCIl>YdjO@008S`VG@<000033O`0000000<000033Q`00000
00T00009Aai2oTLO001K?ELlFceG?5/m00800004Ec`00000He`3Hc/04000Gc]S?5lkHc`006Lj001W
>f<JIc]S6VLkHaX006<J0P0000=W>V<IIcX00P0001AS6FLjHaYW>P00IaX006LJHaUW6V<JIaX006LJ
001S6ekjHa]NnV<K0P0000MNnP00F_YO6e[jG_]JnP0200002ekk001Fo5KKE_aBfeKlE]/004jlC]`0
0`00015Bg000A[e6_4ZmA[a6_DJl000nWD:m?Ya2_CjM000jOCZM01X00004B_e?7T[mCah20007Ool0
02ioo`03001oogoo02eoo`04001:_4ZlC[`2B[`00`00>YdjO@02>Yd010008SdV?BHm1@0000D5f`00
000000gl008000@ZWP0:0016oTLNA_i77TKnAah005/mEcd2000015/mEceK?ELm0P0000=S>`000000
1V<k00<006LjIcX016Lj00@006<jIc]S>P800005IcX006LJIaYW>P03IaX01FLj001S6V<JIaX00V<J
00@006<JHaX0009S6P0:G_YS6P00Ha]NnV<JGaX005[kG_/20003F_/01`00E]]FneKKE_aFfeKk00<0
00E>g0070016_DJlA[e6_4Jm00000SjM00@n_CjM?Yd000HjW@03000jWCZM00<jW@0>000j_Cjn?[dn
_SZm?[h004KN@]e2gT;MA]h0009>o@04Cae:oDkmC_d20007Ool002moo`8002ioo`04001>g4ZlC]`=
00001AHM000000002M`01@0000TZWRJN:YhVWP00@_i77dKnAah0100000mG75/mEcaK?ELLFceG?5/m
001S?5lkHcaO>f<lGc/00P0000ES?000Ic]S6VLk0080000KHaYW>f<JIc]S6VLk001W>V<IIcYS6VLj
HaUW>P00IcX006LJHaYW6P00IaYS6VLJHaX005kj00800006Ha]NnV<KG_YS6ekj0P0000UO6e[kG_]J
nUlKF_/005;KE_`00`0000EFo5KK001>_5;L009>g006C[`004JlA[e6_4Zm1P0000DnW4:m000jWCYm
00<jW@0=000j_SJM>YhfWCZn=Yd003ZM?[hj_Cjn>Yd00P0000Y6gT;MA_i2gDKN001?7T[mCai:o@<0
00Moo`00<Goo00<007ooOol0;7oo0`0000E>g4ZlC[`003jM00<jW@03000VG@0000@000034O`00000
008000035SdB700000T00003Aai6oTLN00800005EceK?ELmFceG?@0200000e/m001S>`03Hc/04`00
Hc]S>elkHc/006Lj001W>V<jIc]S>VLjHcYW>`00Hc/006Lj00=W6P08IcX006LJHaYW>P00HaX000IS
6P07001O6V<KG_YS6UlJHa/00P0000=O6P00F_/00U[k00ANne[kF_]Jn`800006E_aFfeKlE]]Fo000
14kL1P001Woo8@000Woo00<007ooOol01Goo000bOol00`00Oomoo`0/Ool04000C]a:_4kLB[a>g000
?YdjO3jM>Yd002Hm:UdV?BYM100000<=o00000001@0000<ZWRjo:Yh00P0000E;7dKnAai6oT/O0080
000:EaaK?@00001G75/mEaaK?@00Hc`200005ElkHcaO>f<lGc]S?000Ic]S6VLkHaYW>f<JIc/006Lk
HaX006<JIcYS6@0200002fLjHaYW>f<JIcX006LJHaYW6V<JIaX00P00011S6P00G_YS6ekjHa/006<K
G_YS6`00G_]JnUlKF_]Nn`800007F_/005;KE_aFfeKlD]/01@0097oo00<007ooOol027oo00<007oo
Ool01Goo000cOol00`00Oomoo`0/Ool01000C[a:_4kL1P0000PjW@009UdZGBIM000J71XM0`0000<=
o00000002@0000A77TKnAai6oP@0009G?@06FceG?ELmEceK?@000f<k00=O>f<kHc/00P0000IO>`00
001S>VLjHcX2000046<kHcYW>f<J001W6P00HaYW6V<JIcYS6VLJ001W>P000f<J00<006<JHaX00V<J
00`005lJ000005lKGaYS6ekjGa/005kkF_/20003F_/00`00E_aFf`03000YOol00`00Oomoo`09Ool0
0`00Oomoo`04Ool003Aoo`8002eoo`<00005C]a:_4kL000nW@0600001BHm000F71Xm5Q`01@0000DJ
?AYM6Sd002jN00L00009A_i;7TKn001G75/mEaaK?ELL0080000;Fcd006<lGc]S?5lk001O>f<lGa]S
?00200005F<J001S6VLkHaYW>f<JIc]S6P00HaYW>V<JIc]S6VLj001W>f<J001S6P020002HaX03F<K
HaYS6V<J001NnV<KG_YS6ekjHa]NnV<K00800006F_YO6e[kG_]JnUlK0P00;Goo00<007ooOol027oo
00<007ooOol017oo000fOol00`00Oomoo`0[Ool01`00C[a:_4kLB[a>_00000@nW@03000ZG@0000L0
00035Qd000000080000>6Sd002jn<[h^_S:n00177TKnAai6oTLNA_h0009G?@8000=G?@03Fcd006<k
008000=O>`0;HcaO>elkGc/006<JHc]S>VLkHaYS>`0200001F<J001S6VLjHaX00P0000EW>V<JHaYS
6P0000IS6P800007HaX005lJHa]NnUlKGaX00P0000=O6`00F_/00e[k0P00<7oo00<007ooOol01goo
00<007ooOol017oo000gOol00`00Oomoo`0ZOol04000B[a>g4ZlC]a:_4kL000nWCZL?[djW@00:Ud^
ORYM1`0000<B70007Ud01P0000Hb_P00Bai6oT/NA_h400001U/mEaaK?ELLFceG70<00006Gc]S?5lK
HcaO>f<l0P0001QO6`00HaYW>f<JIc/006LkHaYS>f<J001S6P00HaYW>f<JIc]S6P00HaX006<JHa/2
HaX04000Ha]S6V<K001S6ekjHa]NnP00G_YO6ekj001Jnekk0P00<Woo00<007ooOol01goo00<007oo
Ool017oo000hOol00`00Oomoo`0ZOol01@00B[a>_4ZlC]`03@000ahm10000aiM2@0000=6oT/NA_h0
0`0000AG?E/m0000009G?@<0000:HcaO>`00001O?5lkGcaO>`00HaX200000f<kHaYS>`02Hc/016<J
001S6VLj0f<J00H006<JHaYS6P00HaX200001f<KHaYS6V<JHa/005lK00800005G_YO6elJGa]NnP02
000eOol00`00Oomoo`06Ool00`00Oomoo`04Ool003Uoo`8002]oo`@0000:C]a:_4kL000n_CjL@[dn
W@00;Ud600000ahm000N?@0700000cJo<[hf_P03000014/NA_e;7TKn100000IK?ELLFceG75/mEa`3
00003UlKHcaO6f<lGa]S?5lK001S6VLkHaYS>f<JIc/2000075lJ001S6VLkHaX006<JHc]S6VLkHaX0
05lJHa]S6V<KGaYS6f<JHa/006<KG_YO6ekjHa]NnP00>7oo00<007ooOol01Goo00<007ooOol017oo
000kOol00`00Oomoo`0YOol02@00B[a>g4jlC]a:_4kL000n_@03?Yd00`00;Wd^O@02;Wd00`008Ud0
000300000aXm0000000=000014[nBai:oP000ULm00=G7ELmEcd00P0000MG?@00GcaO>ellGc]O?002
00000elk001S6P03Hc/02000Hc]S>f<kHa/006<J0003HaX01F<KHaX006<J00000f<J00US6f<J0000
06<K001O6elJGa/00P00>Woo00<007ooOol017oo00<007ooOol017oo000lOol00`00Oomoo`0YOol0
1P00B[a>g4ZlC]a:_0X00005<Wd002IM8SdRG@0500004bIn8UdVOP00=]lf_SKN<[hfg`00Bai6oD/N
A_i;7TKm001G75/m00800007EaaG?ELLFcd006<lGa/00P0000IO?5lKHcaO6`00HaX200002f<kGaYS
>f<JHc]O6P00HaYS>f<JIc/00P0000IO6V<kHaX005lJHa/200001ekjHa]O6V<K001S6`0003aoo`03
001oogoo00Aoo`03001oogoo00Aoo`00?Goo00<007ooOol0:Goo00<004ZlC]`00P0000U>_4kL0012
_CjM@[dnW@00<Wd01P0000@RG@007UdN?@@000039Wh003Jn00@f_P05001;7T[nBai:oP0400001eLm
EaeG?ELMEceG7ELm00800009Gc]O?5lkGcaO>ellGc/006<K00=S>`05Ha]S>`00001S6`02000026<K
001S6f<JHa]S6V<KHaX20002HaX01V<KGaYS6V<JHa/003ioo`03001oogoo00Aoo`03001oogoo00=o
o`00?Woo0P00:Woo0P00015>g4ZlC]a:_000?Ye2_CjL@[dnW@00;WdbWS9m<Wh002Yn00@000047SdR
G@00:Yh<00002D[mBai6o@00EaaG?ELLFceG700200001e/m001O?5lKHcaO6ell00800005Ga/00000
Hc]S6P0200002f<kGa]S>elJHc/006<kGaYS>f<JHc/00P0000MO6P00G_YS6elJHa]NnP020010Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool0041oo`03001oogoo02Qoo`03001>_4kL009>g008C[`003jM
@[dnWD:m?Yd000@bO@04000VGBIM9Ud500004bYn9WhZOP00>]hf_S[N=[hjgP00Bai:oT/NB_i;7T[n
001G7ELm00800007EaeG?ELMEcd005llGc/00P0000=O?5lKGc`00Ull0P0000ES6f<kHa]S>f<K0080
000<Hc/006<KHaYS6`00Ha]S6V<K001S6elJ0V<J00<007ooOol0@7oo00<007ooOol00goo00<007oo
Ool00goo0011Ool00`00Oomoo`0XOol01000B[a>g4Zl3`0000DVGBYN000VOR9M00@0000<:Wh003[O
=[hjgSJn>]l004/NA_e;7T[m100000IG?ELLFceG75LmEa`300001E/KGcaO6ellFa/00P0000aO?000
Hc]O6f<kGaX005lKHc]O6`00HaX200001f<kGaYS>elJHc/006<K008004Aoo`03001oogoo009oo`03
001oogoo00=oo`00@Woo00<007ooOol0:7oo0`000dkL0P0014:m00D0039m=YdfOCJM00D000059UdR
GBIN000ZWP0<00000d[nBai:oP0200000eLmEad0000200001ELLEad005llGa/00Ull00<005lKGc`0
0Ull00X006<k000005lKHc]O6f<kGa/0009S6`07HaYS6f<KHa]S6V<K0000Agoo00D007ooOomoo`00
00Eoo`00@goo0P00:Goo00H004ZlC]a:_4kLB[`2000034:m?Ya2_CjM000bOCJN<Wd002YM;WhZG@@0
00059Uh002jN:Wd^WP0300000c[N>[hjg`02000014[mBai:oD/N100000QG75LmEaaG?ELLEcd005ll
0P0001EK6ellFa]O?5/KGc`006<kGa]S>elKHc]O6`00Ga/005lJHc]O6V<kGaX00P00BGoo00@007oo
Ool000Eoo`00AGoo00<007ooOol09goo00<004kLC]`00TkL2P0000<fO@00:Ud00RYm00<ZOP00:Wh0
4@0000I;7T[mBah005LmEa`2Ead01ULmEa`00000GcaO6`=O?008Ga/00000Gc`006<kGa]S>`800004
Ga]S>elK0002Ha/2001;Ool01000Oomoo`001Goo0016Ool00`00Oomoo`0WOol400002TkLB[a>g@00
@[e2W4Jm@[d003Im1P0000DZOP00:WhVGBYn0080000C;YhbWRjM<Yh003kN>[hngS[N001:oDlNB_e;
7T[mCah005LmEa`00`0000IG75Lm000005/KGc`200003E/KGcaK6ell001S>`00Hc]O6f<lGa]S>elK
008004ioo`03001oo`0000Eoo`00Agoo00<007ooOol09goo00<004kLC]`014kL00<004:m@[d00T:m
00H003JM=YdfW@00;Wd<00002bjN000ngS[N?]hjgP00B_e;7T[nBah0100000IG75LMEaeG7ELLEad3
000025llGaaO?5/LGcaO75ll0002Ga/01F<kGa]O6elK0000DGoo00<007oo000017oo0018Ool00`00
Oomoo`0WOol01P00B[a>gDjlC]a:_0T00006=Wd002im;Yh^OBin0P0000DZOBjN:Wd003:N00`00003
Cai:oDlN00800003EaaG?@0000800008EceG7000Fa]O?5/KGcaK6`800005Gc`006<lGa]S>`02001C
Ool20004Ool004Uoo`8002Qoo`03001>g4kL0080009>g0030016_D:m0092_@03000jW@0000X00004
:Wd003:N<[h2<Yh00`00?]hngP02?]h300000d[mBai:o@040003Ead01ULLEaeG7@00FaaO?08000=K
7004Gc`005lK001EOol20004Ool004]oo`03001oogoo02Ioo`80000>C]e>g4kLB[`004:mA[e2_4Jm
@[d003JM>[hfW@800006<Yh^OC:N;Wd002im1P0000<b_P00?]h00ckN1@0000Y:oDlNB_d005<LEceG
75LmDaaG?@<00008GcaK6ellFa]O?5/KGc`005Ioo`8000Aoo`00C7oo00<007ooOol09Woo00<004kL
C]`00dkL00@004:mA[e2_@P00005<YhbOC:N<Wd00002;Yh00bim000f_P07000033kN@]hngP00B_e?
7T[mB_i:o@00EaaG7@<0009G7@06001K75/LFaaO?5/L0P00Dgoo10001Woo001=Ool00`00Oomoo`0V
Ool01000B[a>gDkL1@0000E2_4KM@[`003ZM00/00006;Wd003:N=[hbWCJn0P0000TngD;n?]i2gSkM
001:oDlNB_d0100000UG?ELLEaeC75LmEa`005/KGc`00P00DGoo10002Woo001>Ool2000WOol30003
C]`01000A[e6_D:m0TJm00`003ZM>YdjWCZm000bWS:M=YhbW@00<YhA00001D[mC_e:o@00Ea`00eLM
00=G75LM00000P00Cgoo10003Woo001@Ool00`00Oomoo`0UOol00`00C[a>g@02C]`01Djl0012_4Jm
@[`01P0001ln_P00=YhbOCJN<Wd003:M<YhbO@00=[hj_SJM>[hf_P00?]e2oSkN@_hng@00B_e?7T[m
Cai:o@00DaaG?@03001>Ool4000BOol0055oo`03001oogoo02Eoo`04001>g4kLC]`50006Ool:0000
0c:M000f_P04=[h00`00@]i2gP03@]h01000B_e?7T[m1000CGoo10005Woo001BOol00`00Oomoo`0U
Ool3000EOolA001=Ool4000JOol005=oo`8002Eoo`03001oogoo06moo`@001ioo`00EGoo00<007oo
Ool08Woo00<007ooOol0Jgoo10008Woo001FOol00`00Oomoo`0QOol00`00Oomoo`1XOol3000VOol0
05Moo`03001oogoo021oo`03001oogoo06Aoo`@002Uoo`00F7oo0P0087oo00<007ooOol0H7oo1000
;Goo001JOol00`00Oomoo`0MOol00`00Oomoo`1LOol4000aOol005]oo`03001oogoo01]oo`03001o
ogoo05Uoo`@003Eoo`00G7oo00<007ooOol06Woo00<007ooOol0EGoo1000>Goo001MOol2000JOol0
0`00Oomoo`1AOol4000mOol005moo`03001oogoo01Moo`03001oogoo04eoo`@0045oo`00H7oo00<0
07ooOol05Woo00<007ooOol0BGoo1000AGoo001QOol00`00Oomoo`0EOol00`00Oomoo`16Ool30019
Ool0069oo`8001Eoo`03001oogoo049oo`@004aoo`00I7oo00<007ooOol04Woo00<007ooOol0?Woo
1000D7oo001UOol00`00Oomoo`0AOol00`00Oomoo`0jOol4001DOol006Ioo`03001oogoo011oo`03
001oogoo03Ioo`@005Qoo`00Igoo0P0047oo00<007ooOol0<Woo1000G7oo001YOol00`00Oomoo`0=
Ool00`00Oomoo`0^Ool4001POol006Yoo`03001oogoo00aoo`03001oogoo02Yoo`@006Aoo`00Jgoo
00<007ooOol02goo00<007ooOol09Woo1000J7oo001/Ool2000;Ool00`00Oomoo`0ROol4001/Ool0
06ioo`03001oogoo00Qoo`03001oogoo01moo`<0071oo`00Kgoo00<007ooOol01goo00<007ooOol0
6goo1000Lgoo001`Ool00`00Oomoo`06Ool00`00Oomoo`0GOol4001gOol0075oo`8000Ioo`03001o
ogoo01=oo`@007]oo`00Lgoo00<007ooOol00goo00<007ooOol03goo1000Ogoo001dOol00`00Oomo
o`02Ool00`00Oomoo`0;Ool40023Ool007Eoo`05001oogooOol00009Ool40027Ool007Ioo`800003
Ool007oo00Aoo`@008]oo`00N7oo0P0000=oo`0000000P00Sgoo001iOol2002COol00?moo`moo`00
ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00
ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00001\
\>"],
  ImageRangeCache->{{{0, 269}, {245.875, 0}} -> {-0.101554, -0.0541966, \
0.00495658, 0.00495658}}]
}, Open  ]],

Cell[TextData[{
  "The example of the heat equation demonstrates how the basic functions of ",
  
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " can be used to find non-classical solutions. The above discussion is \
based on the combination of batch mode calculations and interactive \
calculations in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The following calculation will show how non-classical symmetries can be \
derived by pseudo-automatic calculations in ",
  StyleBox["MathLie.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"find non-classical solutions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3.2 The Boussinesq Equation", "Subsection",
  CellTags->"The Boussinesq equation"],

Cell[TextData[{
  "The ",
  ButtonBox["Boussinesq [1872]",
    ButtonData:>{"Literat.nb", "Boussinesq-1872"},
    ButtonStyle->"Hyperlink"],
  " equation"
}], "Text",
  CellTags->"Boussinesq equation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_\(t, t\) + \ u\ u\_\(x, x\)\  + \ u\_x\%2\  + \ u\_\(x, x, x, x\) = 0
      \)], "NumberedEquation"],

Cell[TextData[{
  "is one of the equations frequently examined in connection with solution \
procedures for non-linear models. The equation arises in several physical \
applications ranging from surface waves of rectangular canals to applications \
in plasma physics. The point symmetries of the Boussinesq equation were \
examined by ",
  ButtonBox["Nishitani and Tajiri [1982]",
    ButtonData:>{"Literat.nb", "Nishitani and Tajiri-1982"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Rosenau and Schwarzmeier [1986]",
    ButtonData:>{"Literat.nb", "Rosenau and Schwarzmeier-1986"},
    ButtonStyle->"Hyperlink"],
  ". The discussion of the non-classical symmetries by ",
  ButtonBox["Levi and Winternitz [1989]",
    ButtonData:>{"Literat.nb", "Levi-89"},
    ButtonStyle->"Hyperlink"],
  " revealed that the symmetries of the direct method by ",
  ButtonBox["Clarkson and Kruskal [1989]",
    ButtonData:>{"Literat.nb", "Clarkson-89"},
    ButtonStyle->"Hyperlink"],
  ", Clarkson [1989] follow from a non-classical analysis. We use this \
equation here to demonstrate the pseudo-automatic calculation of \
non-classical symmetries."
}], "Text",
  CellTags->{
  "surface wave", "plasma physics", 
    "point symmetries of the Boussinesq equation", "direct method", 
    "pseudo automatic calculation of non-classical symmetries"}],

Cell[TextData[{
  "The Boussinesq equation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notation reads:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(boussinesq\  = \ 
      \[PartialD]\_t u[x, t]\  + \ u[x, t]\ \[PartialD]\_\(x, x\)u[x, t]\  + 
          \ \((\[PartialD]\_x u[x, t])\)\^2 + \ \[PartialD]\_{x, 4}u[x, t] == 
        0; boussinesq // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t + u\_x\%2 + u\ u\_\(x, x\) + u\_\(x, x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The point symmetries of the Boussinesq equation are", "Text",
  CellTags->"point symmetries of the Boussinesq equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(liePointSymmetries\  = \ Infinitesimals[boussinesq, u, {x, t}]; 
    liePointSymmetries\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == \(-2\)\ k3\ u\)},
          {\(\[Xi]\_1 == k2 + k3\ x\)},
          {\(\[Xi]\_2 == k1 + 4\ k3\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ -2, k3, u]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ k3, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 4, k3, t]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This finite dimensional group of order three contains translations and \
scaling transformations as symmetries. The non-classical symmetries follow by \
applying the function ",
  StyleBox["NonClassicalPointSymmetries[]", "MmaText"],
  ". This function assumes by default that the option ",
  StyleBox["NonclassicalCases", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "is set to the last variable of the independent variables. Typically, this \
variable is the time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". If you prefer to use another variable, for example, ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", you have to specify this change in the option ",
  StyleBox["NonclassicalCases", "MmaText",
    FontSlant->"Italic"],
  StyleBox["\[Rule]{x}", "MmaText"],
  ". The nonlinear determining equations follow from"
}], "Text",
  CellTags->"NonClassicalPointSymmetries[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdeter\  = \ NonClassicalPointSymmetries[boussinesq, {u}, {x, t}]; 
    ncdeter // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u, u\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x, x\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x, x, u\) == 0\)},
          {
            \(\[Phi]\_1 + 2\ u\ \((\[Xi]\_1)\)\_x - 
                4\ \((\[Xi]\_1)\)\_\(x, x, x\) + 
                6\ \((\[Phi]\_1)\)\_\(x, x, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x, u, u\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u, u, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x, u\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u, u, u\) + 
                \((\[Phi]\_1)\)\_\(u, u, u, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u, u\) + 
                \((\[Phi]\_1)\)\_\(u, u, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 
              0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 
              0\)},
          {
            \(\[Phi]\_1\ \((\[Xi]\_2)\)\_u + \[Xi]\_1\ \((\[Xi]\_2)\)\_x - 
                \[Xi]\_2\ \((\[Xi]\_2)\)\_\(x, x, x, x\) == 0\)},
          {
            \(\(-\[Xi]\_2\%2\)\ \((\[Xi]\_1)\)\_t + 
                4\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                4\ \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_2)\)\_t + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\%2\ \((\[Xi]\_2)\)\_x + 
                2\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_x - 
                u\ \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_\(x, x\) + 
                2\ u\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, u\) - 
                \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_\(x, x, x, x\) + 
                4\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x, x, u\) == 0\)},
          {
            \(\(-4\)\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_2)\)\_t + 
                \[Phi]\_1\%2\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_x - 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_t - 
                u\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x\) - 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x, x, x\) == 0\)},
          {
            \(\(-4\)\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u + 
                2\ \[Xi]\_2\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_2\ \((\[Phi]\_1)\)\_u - 
                2\ u\ \[Xi]\_2\ \((\[Xi]\_1)\)\_\(x, u\) + 
                u\ \[Xi]\_2\ \((\[Phi]\_1)\)\_\(u, u\) - 
                4\ \[Xi]\_2\ \((\[Xi]\_1)\)\_\(x, x, x, u\) + 
                6\ \[Xi]\_2\ \((\[Phi]\_1)\)\_\(x, x, u, u\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a system of 29 coupled non-linear determining equations for \
the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  ". Only the last four equations are non-linear. The first 25 equations are \
linear. We can use these linear equations to find a partial solution of the \
determining equations. Before we apply a function to the total set of \
equations, let us rewrite the infinitesimals in such a way that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2 = 1\)]],
  ". Defining a general substitution for ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[2], we find"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdeterh\  = 
      DeleteCases[
        \((\((ncdeter\  /. \ u[x, t] \[Rule] u)\)\ \  /. \ 
              xi[2] \[Rule] Function[{x, t, u}, 1])\) /. u \[Rule] u[x, t], 
        0]; ncdeterh\  // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u, u\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u, u, u\) == 0\)},
          {
            \(\[Phi]\_1 + 2\ u\ \((\[Xi]\_1)\)\_x - 
                4\ \((\[Xi]\_1)\)\_\(x, x, x\) + 
                6\ \((\[Phi]\_1)\)\_\(x, x, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x, u, u\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u, u, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x, u\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u, u, u\) + 
                \((\[Phi]\_1)\)\_\(u, u, u, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u, u\) + 
                \((\[Phi]\_1)\)\_\(u, u, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 
              0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 
              0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + 4\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                4\ \[Xi]\_1\ \((\[Xi]\_1)\)\_x + 2\ \((\[Phi]\_1)\)\_x - 
                u\ \((\[Xi]\_1)\)\_\(x, x\) + 
                2\ u\ \((\[Phi]\_1)\)\_\(x, u\) - 
                \((\[Xi]\_1)\)\_\(x, x, x, x\) + 
                4\ \((\[Phi]\_1)\)\_\(x, x, x, u\) == 0\)},
          {
            \(\(-4\)\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x - \((\[Phi]\_1)\)\_t - 
                u\ \((\[Phi]\_1)\)\_\(x, x\) - 
                \((\[Phi]\_1)\)\_\(x, x, x, x\) == 0\)},
          {
            \(\(-4\)\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u + 2\ \((\[Xi]\_1)\)\_x + 
                \((\[Phi]\_1)\)\_u - 2\ u\ \((\[Xi]\_1)\)\_\(x, u\) + 
                u\ \((\[Phi]\_1)\)\_\(u, u\) - 
                4\ \((\[Xi]\_1)\)\_\(x, x, x, u\) + 
                6\ \((\[Phi]\_1)\)\_\(x, x, u, u\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Applying now the general-purpose solver ",
  StyleBox["PDESolve[]", "MmaText"],
  " of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " to the system of coupled non-linear equations, we can automatically \
derive solutions. The function ",
  StyleBox["PDESolve[]", "MmaText"],
  " responds with a question concerning the solution branches of the \
non-linear determining equations. This interruption of the calculation is \
terminated by providing the number of the condition printed by the function:"
}], "Text",
  CellTags->{"PDESolve[]", "solution branches"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(partsol\  = \ PDESolve[ncdeter, {u}, {x, t}]; partsol // LTF\)], "Input"],

Cell[BoxData[
    \("There exists no unique solution of the equations."\)], "Output"],

Cell[BoxData[
    \("Please choose one of the following results"\)], "Output"],

Cell[BoxData[
    InterpretationBox[
      \(1\[InvisibleSpace]","\[InvisibleSpace]{\(free[3]\)[t] \[Rule] 0}\),
      SequenceForm[ 1, ",", {free[ 3][ t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"2", "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((2, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "\[Rule]", 
            "0"}], "}"}]}],
      SequenceForm[ 2, ",", {Derivative[ 2, 0][ 
          free[ 1]][ x, t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    \("There exists no unique solution of the equations."\)], "Output"],

Cell[BoxData[
    \("Please choose one of the following results"\)], "Output"],

Cell[BoxData[
    InterpretationBox[
      \(1\[InvisibleSpace]","\[InvisibleSpace]{\(free[3]\)[t] \[Rule] 0}\),
      SequenceForm[ 1, ",", {free[ 3][ t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"2", "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((3, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "\[Rule]", 
            "0"}], "}"}]}],
      SequenceForm[ 2, ",", {Derivative[ 3, 0][ 
          free[ 1]][ x, t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-2\)\ \[ScriptCapitalF]\_1\ 
                  \((\[ScriptCapitalF]\_2)\)\_t\%2 - 
                \[ScriptCapitalF]\_2\%2\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(t, t\) + 
                \[ScriptCapitalF]\_2\ 
                  \((2\ \((\[ScriptCapitalF]\_1)\)\_t\ 
                        \((\[ScriptCapitalF]\_2)\)\_t + 
                      \[ScriptCapitalF]\_1\ 
                        \((\[ScriptCapitalF]\_2)\)\_\(t, t\))\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(\[ScriptCapitalF]\_2\), "+", 
                RowBox[{
                  StyleBox[\(1\/4\),
                    ScriptLevel->0], " ", "x", " ", 
                  \(\((\[ScriptCapitalF]\_1)\)\_t\)}], "-", 
                
                StyleBox[
                  \(\(x\ \[ScriptCapitalF]\_1\ 
                        \((\[ScriptCapitalF]\_2)\)\_t\)\/\(4\ 
                        \[ScriptCapitalF]\_2\)\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == \[ScriptCapitalF]\_1\)},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(1\/2\),
                  ScriptLevel->0], " ", "u", " ", 
                RowBox[{"(", 
                  RowBox[{\(-\((\[ScriptCapitalF]\_1)\)\_t\), "+", 
                    
                    StyleBox[
                      \(\(\[ScriptCapitalF]\_1\ 
                            \((\[ScriptCapitalF]\_2)\)\_t
                              \)\/\[ScriptCapitalF]\_2\),
                      ScriptLevel->0]}], ")"}]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 1], 
              Power[ 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t], 2]], 
            Times[ -1, 
              Power[ 
                Subscript[ \[ScriptCapitalF], 2], 2], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t, t]], 
            Times[ 
              Subscript[ \[ScriptCapitalF], 2], 
              Plus[ 
                Times[ 2, 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 1], t], 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 2], t]], 
                Times[ 
                  Subscript[ \[ScriptCapitalF], 1], 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 2], t, t]]]]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ 
              Rational[ 1, 4], x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Times[ 
              Rational[ -1, 4], x, 
              Subscript[ \[ScriptCapitalF], 1], 
              Power[ 
                Subscript[ \[ScriptCapitalF], 2], -1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], t]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 2], u, 
            Plus[ 
              Times[ -1, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t]], 
              Times[ 
                Subscript[ \[ScriptCapitalF], 1], 
                Power[ 
                  Subscript[ \[ScriptCapitalF], 2], -1], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t]]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We select the second case for each inquiry of ",
  StyleBox["PDESolve[]", "MmaText"],
  ". The result for these choices is a representation of the non-classical \
infinitesimals depending on two arbitrary functions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FormBox[\(\[ScriptCapitalF]\_i = \),
              "TraditionalForm"],
            "MmaText"], 
          RowBox[{
            StyleBox["free",
              FontSlant->"Italic"], 
            StyleBox["[",
              "MmaText"], 
            StyleBox["i",
              "MmaText"], 
            StyleBox["]",
              "MmaText"]}]}], TraditionalForm]]],
  StyleBox[", i = ",
    FontSlant->"Italic"],
  "1, 2. We know that for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  " the relation ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2 = 1\)]],
  " was assumed in the above calculation. Thus, we can set ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[1] = 1",
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ppsol\  = \ partsol\  /. \ free[1] \[Rule] Function[t, 1]; 
    \(ppsol // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              
              StyleBox[
                \(\(u\ \((\[ScriptCapitalF]\_2)\)\_t\)\/\(2\ 
                      \[ScriptCapitalF]\_2\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(\[ScriptCapitalF]\_2\), "-", 
                
                StyleBox[
                  \(\(x\ \((\[ScriptCapitalF]\_2)\)\_t\)\/\(4\ 
                        \[ScriptCapitalF]\_2\)\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == 1\)},
          {
            \(\(-2\)\ \((\[ScriptCapitalF]\_2)\)\_t\%2 + 
                \[ScriptCapitalF]\_2\ \((\[ScriptCapitalF]\_2)\)\_\(t, t\) == 
              0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 2], u, 
            Power[ 
              Subscript[ \[ScriptCapitalF], 2], -1], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 2], t]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ 
              Rational[ -1, 4], x, 
              Power[ 
                Subscript[ \[ScriptCapitalF], 2], -1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], t]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1], 
        Equal[ 
          Plus[ 
            Times[ -2, 
              Power[ 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t], 2]], 
            Times[ 
              Subscript[ \[ScriptCapitalF], 2], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], t, t]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The infinitesimals reduce to a simpler form containing only one \
undetermined function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FormBox[\(\[ScriptCapitalF]\_2 = \),
              "TraditionalForm"],
            "MmaText"], 
          RowBox[{
            StyleBox["free",
              FontSlant->"Italic"], 
            StyleBox["[",
              "MmaText"], 
            StyleBox["2",
              "MmaText"], 
            StyleBox["]",
              "MmaText"]}]}], TraditionalForm]]],
  ". This function has to satisfy the last determining equation, which is a \
second-order non-linear ODE. The partial results so far derived can be used \
in another calculation with ",
  StyleBox["PDESolve[]:", "MmaText"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(isol\  = \ PDESolve[ppsol, {u}, {x, t}]; isol\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              StyleBox[\(\(4 - k1\ x\)\/\(4\ k1\ k2 - 4\ k1\ t\)\),
                ScriptLevel->0]}]},
          {\(\[Xi]\_2 == 1\)},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              StyleBox[\(u\/\(2\ k2 - 2\ t\)\),
                ScriptLevel->0]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Power[ 
              Plus[ 
                Times[ 4, k1, k2], 
                Times[ -4, k1, t]], -1], 
            Plus[ 4, 
              Times[ -1, k1, x]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Power[ 
              Plus[ 
                Times[ 2, k2], 
                Times[ -2, t]], -1], u]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The final result of the calculation is a system of infinitesimals \
containing two parameters ",
  StyleBox["k1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k2",
    FontSlant->"Italic"],
  ". These two parameters determine the transformation properties of the \
non-classical infinitesimal transformation. The above representation of the \
infinitesimals is represented in a more convenient way by the following  \
transformations:"
}], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncinfi\  = 
      \(isol\  /. u[x, t] \[Rule] u\) /. \ 
          Rule[\(a_[n_]\)[h___], b_] \[Rule] 
            Rule[a[n], Function[$v, $w] /. {$v \[Rule] {h}, $w \[Rule] b}] // 
        Flatten; ncinfi // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              StyleBox[\(u\/\(2\ k2 - 2\ t\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              StyleBox[\(\(4 - k1\ x\)\/\(4\ k1\ k2 - 4\ k1\ t\)\),
                ScriptLevel->0]}]},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Power[ 
              Plus[ 
                Times[ 2, k2], 
                Times[ -2, t]], -1], u]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Power[ 
              Plus[ 
                Times[ 4, k1, k2], 
                Times[ -4, k1, t]], -1], 
            Plus[ 4, 
              Times[ -1, k1, x]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "After the rearrangements of the representation, we know the infinitesimals \
in a standard form which is helpful in the following calculations. Our aim is \
to derive solutions for the Boussinesq equation. To uncover the reduction of \
the Boussinesq equation, we first select a sub-class of the infinitesimal \
transformations with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k2",
            FontSlant->"Italic"], "=", "c"}], TraditionalForm]]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " a real constant:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      \({{\(xi[1]\)[x, t, u], \(xi[2]\)[x, t, u]}, {\(phi[1]\)[x, t, u]}}
            \  /. \ ncinfi\)\  /. \ {k1 \[Rule] 1, k2 \[Rule] c}\)], "Input"],

Cell[BoxData[
    \({{\(4 - x\)\/\(4\ c - 4\ t\), 1}, {u\/\(2\ c - 2\ t\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Inserting the equation and the infinitesimals into ",
  StyleBox["LieReduction[]", "MmaText"],
  " provides us with a reduction of the Boussinesq equation:"
}], "Text",
  CellTags->{"LieReduction[]", "reduction of the Boussinesq equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(red\  = \ 
      LieReduction[boussinesq, {u}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \((\(red // Flatten\) // LTF)\) /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[
                    FractionBox[
                      RowBox[{"c", 
                        StyleBox["+",
                          ScriptLevel->0], "t"}], \(\((\(-4\) + x)\)\^4\)],
                    ScriptLevel->0]}], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(u\ \((\(-4\) + x)\)\^2 - F\_1 == 0\)},
          {
            \(\((1 + 2904  \[Zeta]\_1)\) \((F\_1)\)\_\(\[Zeta]\_1\) + 
                2 \((5  F\_1\%2 + 
                      2 \( F\_1\) 
                        \((30 + 
                            13 \( \[Zeta]\_1\) \((F\_1)\)\_\(\[Zeta]\_1\) + 
                            4 \( \[Zeta]\_1\%2\) 
                              \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\))\) + 
                      8 \( \[Zeta]\_1\%2\) 
                        \((\((F\_1)\)\_\[Zeta]\_1\%2 + 
                            351 \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                            8 \( \[Zeta]\_1\) 
                              \((19 \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, 
                                      \[Zeta]\_1\) + 
                                  2 \( \[Zeta]\_1\) 
                                    \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, 
                                      \[Zeta]\_1, \[Zeta]\_1\))\))\))\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting reduction consists of a similarity representation of the \
original variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " containing an unknown function ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  ". This function has to satisfy a fourth-order ODE, which is easier to read \
if we rename the variables"
}], "Text",
  CellTags->"similarity representation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqr\  = \ 
      red\[LeftDoubleBracket]3, 1\[RightDoubleBracket]\  /. {F1 \[Rule] H, 
          zeta1 \[Rule] \[Zeta]}; eqr // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(120\ H + 10\ H\^2 + H\_\[Zeta] + 2904\ \[Zeta]\ H\_\[Zeta] + 
                52\ H\ \[Zeta]\ H\_\[Zeta] + 16\ \[Zeta]\^2\ H\_\[Zeta]\%2 + 
                5616\ \[Zeta]\^2\ H\_\(\[Zeta], \[Zeta]\) + 
                16\ H\ \[Zeta]\^2\ H\_\(\[Zeta], \[Zeta]\) + 
                2432\ \[Zeta]\^3\ H\_\(\[Zeta], \[Zeta], \[Zeta]\) + 
                256\ \[Zeta]\^4\ H\_\(\[Zeta], \[Zeta], \[Zeta], \[Zeta]\) == 
              0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"Surprisingly we can find a first integral of this complicated equation by \
integrating the left-hand side with respect to \[Zeta]."], "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqhh\  = \ 
      \[Integral]\((eqr\[LeftDoubleBracket]1\[RightDoubleBracket])\) 
            \[DifferentialD]\[Zeta] == K\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\((1 + 120\ \[Zeta])\)\ H[\[Zeta]]\), "+", 
        \(10\ \[Zeta]\ H[\[Zeta]]\^2\), "+", 
        RowBox[{"16", " ", \(\[Zeta]\^2\), " ", \((87 + H[\[Zeta]])\), " ", 
          RowBox[{
            SuperscriptBox["H", "\[Prime]",
              MultilineFunction->None], "[", "\[Zeta]", "]"}]}], "+", 
        RowBox[{"1408", " ", \(\[Zeta]\^3\), " ", 
          RowBox[{
            SuperscriptBox["H", "\[DoublePrime]",
              MultilineFunction->None], "[", "\[Zeta]", "]"}]}], "+", 
        RowBox[{"256", " ", \(\[Zeta]\^4\), " ", 
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "\[Zeta]", "]"}]}]}], "==", 
      "K"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  StyleBox["K ",
    FontSlant->"Italic"],
  "is the constant of integration. Now, the question is: Can we solve this \
third-order equation by Lie's methods? We know from S",
  ButtonBox["ection 4.4.3",
    ButtonData:>{"symmet4.nb", 
      "Higher order ordinary differential equations"},
    ButtonStyle->"Hyperlink"],
  " that a solution follows by quadratures if the equation possesses at least \
",
  StyleBox["n ",
    FontSlant->"Italic"],
  "symmetries, where ",
  StyleBox["n ",
    FontSlant->"Italic"],
  "is the largest order of derivatives. The first step in integrating the \
third-order ODE is the examination of the symmetries:"
}], "Text",
  CellTags->"quadratures"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ihh\  = \ Infinitesimals[eqhh, H, \[Zeta], {K}]; ihh\  // LTF\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_1 == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[
"The result is that the third-order ODE resulting from the Boussinesq \
equation does not allow any symmetry. Thus, the integration procedure by Lie \
fails. However, we are able to represent a solution by a numerical \
integration. The validity of the solution will be restricted by initial \
conditions and the finite interval for the similarity variable \[Zeta]. An \
example for a numerical integration is given below."], "Text",
  CellTags->{"numerical integration", "similarity variable"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"nboussinesq", " ", "=", " ", 
      RowBox[{"Map", "[", 
        RowBox[{
          RowBox[{
            RowBox[{"NDSolve", "[", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                  \(eqhh /. K \[Rule] #\), ",", \(H[0.1] == 0\), ",", 
                    RowBox[{
                      RowBox[{
                        SuperscriptBox["H", "\[Prime]",
                          MultilineFunction->None], "[", "0.1", "]"}], "==", 
                      "2"}], ",", 
                    RowBox[{
                      RowBox[{
                        SuperscriptBox["H", "\[DoublePrime]",
                          MultilineFunction->None], "[", "0.1", "]"}], "==", 
                      "1"}]}], "}"}], ",", "H", ",", 
                \({\[Zeta], 0.1, 15}\)}], "]"}], "&"}], ",", 
          \({1, 2, 3, 4, 5}\)}], "]"}]}]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The calculation is carried out by changing the constant ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " in steps of 1 from 1 to 5. The initial conditions are fixed for each \
integration. The result of the numerical solution is used to graphically \
represent the different solutions:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[H[\[Zeta]]\  /. nboussinesq], {\[Zeta],  .1, 6}, 
      AxesLabel \[Rule] {"\<\[Zeta]\>", "\<H\>"}, 
      PlotStyle 
        \[Rule] {RGBColor[1, 0, 0], RGBColor[0.996109, \ 0.996109, \ 0], 
          RGBColor[0.996109, \ 0.500008, \ 0], RGBColor[0, \ 0.500008, \ 0], 
          RGBColor[0, 0, 1]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 -0.313407 2.58011 [
[.18254 .19012 -3 -9 ]
[.18254 .19012 3 0 ]
[.34127 .19012 -3 -9 ]
[.34127 .19012 3 0 ]
[.5 .19012 -3 -9 ]
[.5 .19012 3 0 ]
[.65873 .19012 -3 -9 ]
[.65873 .19012 3 0 ]
[.81746 .19012 -3 -9 ]
[.81746 .19012 3 0 ]
[.97619 .19012 -3 -9 ]
[.97619 .19012 3 0 ]
[1.025 .20262 0 -7.5 ]
[1.025 .20262 10 7.5 ]
[.01131 .07361 -24 -4.5 ]
[.01131 .07361 0 4.5 ]
[.01131 .33162 -24 -4.5 ]
[.01131 .33162 0 4.5 ]
[.01131 .46063 -18 -4.5 ]
[.01131 .46063 0 4.5 ]
[.01131 .58963 -24 -4.5 ]
[.01131 .58963 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .20262 m
.18254 .20887 L
s
[(1)] .18254 .19012 0 1 Mshowa
.34127 .20262 m
.34127 .20887 L
s
[(2)] .34127 .19012 0 1 Mshowa
.5 .20262 m
.5 .20887 L
s
[(3)] .5 .19012 0 1 Mshowa
.65873 .20262 m
.65873 .20887 L
s
[(4)] .65873 .19012 0 1 Mshowa
.81746 .20262 m
.81746 .20887 L
s
[(5)] .81746 .19012 0 1 Mshowa
.97619 .20262 m
.97619 .20887 L
s
[(6)] .97619 .19012 0 1 Mshowa
.125 Mabswid
.05556 .20262 m
.05556 .20637 L
s
.0873 .20262 m
.0873 .20637 L
s
.11905 .20262 m
.11905 .20637 L
s
.15079 .20262 m
.15079 .20637 L
s
.21429 .20262 m
.21429 .20637 L
s
.24603 .20262 m
.24603 .20637 L
s
.27778 .20262 m
.27778 .20637 L
s
.30952 .20262 m
.30952 .20637 L
s
.37302 .20262 m
.37302 .20637 L
s
.40476 .20262 m
.40476 .20637 L
s
.43651 .20262 m
.43651 .20637 L
s
.46825 .20262 m
.46825 .20637 L
s
.53175 .20262 m
.53175 .20637 L
s
.56349 .20262 m
.56349 .20637 L
s
.59524 .20262 m
.59524 .20637 L
s
.62698 .20262 m
.62698 .20637 L
s
.69048 .20262 m
.69048 .20637 L
s
.72222 .20262 m
.72222 .20637 L
s
.75397 .20262 m
.75397 .20637 L
s
.78571 .20262 m
.78571 .20637 L
s
.84921 .20262 m
.84921 .20637 L
s
.88095 .20262 m
.88095 .20637 L
s
.9127 .20262 m
.9127 .20637 L
s
.94444 .20262 m
.94444 .20637 L
s
.25 Mabswid
0 .20262 m
1 .20262 L
s
gsave
1.025 .20262 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .07361 m
.03006 .07361 L
s
[(0.15)] .01131 .07361 1 0 Mshowa
.02381 .33162 m
.03006 .33162 L
s
[(0.25)] .01131 .33162 1 0 Mshowa
.02381 .46063 m
.03006 .46063 L
s
[(0.3)] .01131 .46063 1 0 Mshowa
.02381 .58963 m
.03006 .58963 L
s
[(0.35)] .01131 .58963 1 0 Mshowa
.125 Mabswid
.02381 .09941 m
.02756 .09941 L
s
.02381 .12521 m
.02756 .12521 L
s
.02381 .15101 m
.02756 .15101 L
s
.02381 .17681 m
.02756 .17681 L
s
.02381 .22842 m
.02756 .22842 L
s
.02381 .25422 m
.02756 .25422 L
s
.02381 .28002 m
.02756 .28002 L
s
.02381 .30582 m
.02756 .30582 L
s
.02381 .35742 m
.02756 .35742 L
s
.02381 .38322 m
.02756 .38322 L
s
.02381 .40902 m
.02756 .40902 L
s
.02381 .43483 m
.02756 .43483 L
s
.02381 .48643 m
.02756 .48643 L
s
.02381 .51223 m
.02756 .51223 L
s
.02381 .53803 m
.02756 .53803 L
s
.02381 .56383 m
.02756 .56383 L
s
.02381 .04781 m
.02756 .04781 L
s
.02381 .02201 m
.02756 .02201 L
s
.02381 .61543 m
.02756 .61543 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.05131 0 m
.05357 .04763 L
.05818 .124 L
.0676 .23722 L
.07278 .28219 L
.07767 .31672 L
.08269 .34581 L
.088 .37115 L
.09754 .40593 L
.1078 .43232 L
.11364 .44363 L
.11911 .45235 L
.12399 .45885 L
.12931 .46476 L
.13401 .4691 L
.13902 .47296 L
.14397 .47609 L
.14846 .47842 L
.15264 .4802 L
.15723 .48178 L
.16203 .48305 L
.16447 .48356 L
.16709 .48402 L
.16954 .48437 L
.17178 .48462 L
.17403 .48482 L
.17616 .48495 L
.17733 .48501 L
.17863 .48505 L
.17928 .48506 L
.17998 .48508 L
.18125 .48509 L
.18245 .48508 L
.18371 .48507 L
.18479 .48504 L
.18596 .485 L
.18736 .48494 L
.18864 .48487 L
.19149 .48467 L
.19663 .48417 L
.2014 .48355 L
.20645 .48275 L
.2155 .48102 L
.23595 .47596 L
.2732 .46428 L
.31287 .45029 L
.35105 .43644 L
.39164 .4219 L
.43073 .40834 L
.46834 .39583 L
Mistroke
.50836 .38313 L
.54689 .3715 L
.58783 .35975 L
.62728 .34901 L
.66524 .33917 L
.70561 .32922 L
.74449 .32009 L
.78188 .3117 L
.82168 .30317 L
.86 .29532 L
.90072 .28733 L
.93995 .27996 L
.97619 .27343 L
Mfstroke
.996 .996 0 r
.05122 0 m
.05357 .05004 L
.05818 .12796 L
.0676 .2445 L
.07278 .29123 L
.07767 .32735 L
.08269 .35797 L
.088 .38483 L
.09754 .42206 L
.1078 .45074 L
.11364 .46322 L
.11911 .47295 L
.12931 .48705 L
.13902 .49666 L
.14773 .5029 L
.15723 .50771 L
.16246 .50962 L
.16738 .51103 L
.1718 .51201 L
.17658 .51279 L
.17907 .51309 L
.1818 .51334 L
.18318 .51344 L
.18465 .51353 L
.18605 .51359 L
.18732 .51364 L
.18858 .51367 L
.18975 .51368 L
.19103 .51368 L
.19168 .51368 L
.19239 .51367 L
.19359 .51365 L
.19487 .51361 L
.19609 .51357 L
.1972 .51352 L
.19964 .51338 L
.20186 .51322 L
.20684 .51274 L
.21581 .51154 L
.22628 .50968 L
.23616 .50755 L
.27399 .49715 L
.31423 .48404 L
.35297 .47073 L
.39023 .4579 L
.4299 .44451 L
.46807 .43206 L
.50866 .41935 L
.54776 .40766 L
.58537 .3969 L
Mistroke
.62539 .38599 L
.66392 .37596 L
.70486 .36579 L
.74431 .35645 L
.78227 .34785 L
.82264 .3391 L
.86152 .33104 L
.89891 .32359 L
.93871 .31597 L
.97619 .30908 L
Mfstroke
.996 .5 0 r
.05114 0 m
.05357 .05246 L
.05818 .13192 L
.0676 .25177 L
.07278 .30027 L
.07767 .33798 L
.088 .39851 L
.09754 .43819 L
.10801 .46969 L
.11911 .49355 L
.12836 .50807 L
.13832 .51968 L
.14771 .52772 L
.15631 .53314 L
.161 .53546 L
.16599 .5375 L
.17031 .53895 L
.17498 .54023 L
.18048 .54137 L
.183 .54178 L
.18567 .54214 L
.18807 .54241 L
.19071 .54263 L
.19187 .54271 L
.19312 .54278 L
.19427 .54284 L
.19536 .54288 L
.19656 .54292 L
.19719 .54293 L
.19788 .54295 L
.19856 .54295 L
.19927 .54296 L
.20055 .54296 L
.20174 .54295 L
.20285 .54293 L
.20406 .5429 L
.20536 .54286 L
.20829 .54272 L
.21106 .54254 L
.21624 .54209 L
.22118 .54153 L
.22574 .54092 L
.23603 .53921 L
.25448 .5353 L
.27478 .53006 L
.31444 .5182 L
.35262 .50582 L
.39321 .4924 L
.43231 .4796 L
.46991 .4676 L
Mistroke
.50993 .45527 L
.54846 .44385 L
.5894 .43223 L
.62885 .42151 L
.66681 .41165 L
.70718 .4016 L
.74607 .39234 L
.78346 .3838 L
.82326 .37508 L
.86157 .36702 L
.90229 .3588 L
.94152 .35119 L
.97619 .34471 L
Mfstroke
0 .5 0 r
.05106 0 m
.05357 .05487 L
.05818 .13587 L
.0676 .25905 L
.07278 .30931 L
.07767 .34861 L
.088 .41218 L
.09754 .45432 L
.10801 .48816 L
.11911 .51414 L
.12836 .53021 L
.13832 .54328 L
.14771 .55254 L
.15631 .55896 L
.16599 .56433 L
.17498 .56789 L
.18015 .56943 L
.18484 .57053 L
.19026 .57151 L
.1929 .57188 L
.19536 .57217 L
.19775 .57239 L
.19993 .57256 L
.20236 .5727 L
.20369 .57276 L
.20496 .5728 L
.20618 .57283 L
.20748 .57285 L
.20859 .57286 L
.20982 .57286 L
.2105 .57285 L
.21113 .57285 L
.21182 .57284 L
.21254 .57282 L
.21376 .57279 L
.2151 .57275 L
.21749 .57264 L
.21965 .57252 L
.22451 .57215 L
.22901 .57171 L
.23327 .57121 L
.25295 .56802 L
.27109 .56409 L
.30984 .55377 L
.34709 .54251 L
.38676 .52996 L
.42494 .51781 L
.46553 .50508 L
.50462 .49315 L
.54223 .48204 L
Mistroke
.58225 .47064 L
.62078 .4601 L
.66172 .44935 L
.70117 .43942 L
.73913 .43025 L
.7795 .42088 L
.81838 .41222 L
.85577 .40421 L
.89557 .396 L
.93389 .38839 L
.97461 .38061 L
.97619 .38031 L
Mfstroke
0 0 1 r
.05099 0 m
.05357 .05729 L
.05818 .13983 L
.0676 .26632 L
.07278 .31836 L
.07767 .35924 L
.088 .42586 L
.09754 .47045 L
.10801 .50663 L
.11911 .53474 L
.12836 .55235 L
.13832 .56688 L
.14771 .57736 L
.15631 .58478 L
.16599 .59116 L
.17498 .59556 L
.18484 .59902 L
.19036 .60044 L
.19536 .60144 L
.20015 .60218 L
.20277 .6025 L
.20522 .60275 L
.20748 .60293 L
.20954 .60307 L
.21183 .60318 L
.21309 .60323 L
.21428 .60327 L
.21546 .60329 L
.21675 .60331 L
.2174 .60332 L
.21811 .60332 L
.21938 .60332 L
.22057 .6033 L
.22184 .60328 L
.22291 .60326 L
.22409 .60322 L
.22676 .60312 L
.22962 .60296 L
.23476 .60258 L
.24 .60208 L
.24483 .60151 L
.25575 .59993 L
.27556 .59618 L
.31431 .58668 L
.35156 .57604 L
.39123 .56401 L
.42941 .55223 L
.47 .5398 L
.5091 .52807 L
.5467 .5171 L
Mistroke
.58672 .5058 L
.62525 .49531 L
.66619 .48459 L
.70564 .47465 L
.7436 .46545 L
.78397 .45603 L
.82285 .4473 L
.86024 .43922 L
.90005 .43092 L
.93836 .42322 L
.97619 .41588 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 143.875},
  ImageMargins->{{60, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>0000/a000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool0021oo`03001o
ogoo00=oo`0301moogoo0>Eoo`0087oo00<007ooOol00goo00<07gooOol0iGoo000POol00`00Oomo
o`03Ool00`0OOomoo`3UOol0021oo`03001oogoo00=oo`0301moogoo0>Eoo`0087oo00<007ooOol0
0goo00<07gooOol0iGoo000POol20004Ool00`0OOomoo`3UOol0021oo`03001oogoo00=oo`0301l1
h7oo0>Eoo`0087oo00<007ooOol017oo00<07gooOol0i7oo000POol00`00Oomoo`04Ool00`0OOomo
o`3TOol0021oo`03001oogoo00Aoo`0301moogoo0>Aoo`0087oo00<007ooOol017oo00<07gooOol0
i7oo000POol20005Ool00`0OOomoo`3TOol0021oo`03001oogoo00Aoo`0301moogoo0>Aoo`001000
1Goo0P001Goo1@000goo100017oo00<007ooOol017oo00<07gooOol0i7oo0004Ool00`00Oomoo`02
Ool20007Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00001Woo00<07gooOol0i7oo
0004Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool01@00Oomoogoo00001Woo00<07gooOol0i7oo0004
Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool01000Oomoogoo0`0017oo00<07gooOol0i7oo0004Ool0
0`00Oomoo`0;Ool00`00Oomoo`03Ool40004Ool00`00Oomoo`04Ool00`0OOomoo`3TOol000Aoo`03
001oogoo00]oo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo00Aoo`0301moogoo0>Aoo`00
17oo00<007ooOol02Goo0`001Goo00<007ooOol01Goo00<007ooOol017oo00<07gooOol0i7oo0004
000>Ool00`00Oomoo`03Ool50003Ool00`00Oomoo`04Ool00`0OOn1oo`3TOol0021oo`03001oogoo
00Aoo`0301l1h7oo0>Aoo`0087oo0P001Woo00<07gooOol0hgoo000POol00`00Oomoo`05Ool00`0O
Oomoo`3SOol0021oo`03001oogoo00Eoo`0301moogoo0>=oo`0087oo00<007ooOol01Goo00<07goo
Ool0hgoo000POol00`00Oomoo`05Ool00`0OOomoo`3SOol0021oo`03001oogoo00Eoo`0301moogoo
0>=oo`0087oo0P001Woo00<07gooOol0hgoo000POol00`00Oomoo`05Ool00`0OOomoo`3SOol0021o
o`03001oogoo00Eoo`0301moogoo0>=oo`0087oo00<007ooOol01Goo00<07gooOol05goo1@007Goo
1@0087oo0`008Woo0`007goo100087oo0`005goo000POol00`00Oomoo`05Ool00`0OOomoo`0IOol0
0`00Oomoo`0MOol01@00Oomoogoo00007goo00D007ooOomoo`00029oo`03001oogoo01eoo`03001o
ogoo009oo`03001oogoo01aoo`05001oogooOol0000FOol0021oo`03001oogoo00Eoo`0301moogoo
01Uoo`03001oogoo01ioo`03001oogoo02Aoo`03001oogoo021oo`03001oogoo029oo`03001oogoo
01aoo`05001oogooOol0000FOol0021oo`8000Ioo`0301moogoo01Uoo`03001oogoo01moo`03001o
ogoo02=oo`03001oogoo01aoo`H002=oo`03001oogoo01aoo`05001oogooOol0000FOol0021oo`03
001oogoo00Eoo`0301moh7oo01Uoo`03001oogoo021oo`03001oogoo021oo`80021oo`04001oogoo
000POol4000OOol4000GOol0021oo`03001oogoo00Eoo`0301mmh7oo01Uoo`03001oogoo025oo`03
001oogoo025oo`03001oogoo01eoo`04001oogoo000POol00`00Oomoo`0POol00`00Oomoo`0HOol0
021oo`03001oogoo00Eoo`0301l1h7oo01Moo`<001moo`05001oogooOol0000OOol01@00Oomoogoo
000087oo00<007oo000087oo00<007ooOol08Goo00<007ooOol05goo000POol00`00Oomoo`06Ool0
0`0OOomoo`0HOol00`00Oomoo`0NOol3000QOol3000ROol2000POol5000POol3000FOol0021oo`80
00Moo`0301moogoo0>9oo`0087oo00<007ooOol01Woo00<07gooOol0hWoo000POol00`00Oomoo`06
Ool00`0OOomoo`3HOol40006Ool0021oo`03001oogoo00Ioo`0301moogoo0=Moo`03001oogoo009o
o`03001oogoo00=oo`0087oo00<007ooOol01Woo00<07gooOol0fGoo0`001Woo000POol00`00Oomo
o`06Ool00`0OOomoo`3HOol00`00Oomoo`07Ool001]oo`h0000301l000000<l000Uoo`03001oogoo
00Moo`0087oo00<007ooOol017oo00<007oo01l017oo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<0
07ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<0
07ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol01Goo00<0
07ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<0
07ooOol017oo00<007ooOol037oo00<007ooOol01goo000POol00`00Oomoo`06Ool00`0OO01oo`0H
Ool00`00Oomoo`0POol00`00Oomoo`0QOol00`00Oomoo`0POol00`00Oomoo`0QOol00`00Oomoo`0P
Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool0021oo`03001oogoo00Ioo`0301ml07oo0=Yoo`<000Eo
o`0087oo00<007ooOol01Woo00<07goPOol0fGoo0P000Woo00<007ooOol00Woo000POol00`00Oomo
o`06Ool00`0OON1oo`3KOol30004Ool0021oo`8000Moo`0301l1h7oo0>9oo`0087oo00<007ooOol0
1goo00<07gooOol0hGoo000POol00`00Oomoo`07Ool00`0OOomoo`3QOol0021oo`03001oogoo00Mo
o`0301moogoo0>5oo`0087oo00<007ooOol01goo00<07gooOol0hGoo000POol00`00Oomoo`07Ool0
0`0OOomoo`3QOol0021oo`8000Qoo`0301moogoo0>5oo`0087oo00<007ooOol01goo00<07g`0Ool0
hGoo000POol00`00Oomoo`07Ool00`0OO01oo`3QOol0021oo`03001oogoo00Moo`0301moh7oo0>5o
o`0087oo00<007ooOol01goo00<07goPOol0a7oo1G`067oo000POol20008Ool00`0OON1oo`2nOol6
O00MOol0021oo`03001oogoo00Moo`0301mmh7oo0;Yoo`Al02=oo`0087oo00<007ooOol01goo00<0
7`7POol0]Goo1G`09goo000POol00`00Oomoo`08Ool00`0OOomoo`2`Ool4O00/Ool0021oo`03001o
ogoo00Qoo`0301moogoo0:]oo`El031oo`0087oo00<007ooOol027oo00<07g`0Ool0Ygoo17`0=Goo
000POol20009Ool00`0OO01oo`2SOol4O00iOol0021oo`03001oogoo00Qoo`0301moh7oo09moo`Al
021oo`Eoh1Qoo`0087oo00<007ooOol027oo00<07goPOol0V7oo1g`07Woo1WoP7Goo00040005Ool2
0004Ool50004Ool40004Ool00`00Oomoo`08Ool00`0OON1oo`2AOol7O00QOol4On0SOol000Aoo`03
001oogoo009oo`8000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00002Woo
00<07ggPOol0SGoo17`08goo1GoP9goo0004Ool00`00Oomoo`09Ool00`00Oomoo`09Ool01@00Oomo
ogoo00002Woo00<07ggPOol0RWoo0g`08goo17oP;7oo0004Ool00`00Oomoo`0:Ool00`00Oomoo`08
Ool01000Oomoogoo0`0027oo00<07`7PO000Qgoo0g`08Goo1GoP<7oo0004Ool00`00Oomoo`0;Ool0
0`00Oomoo`03Ool40004Ool00`00Oomoo`08Ool00`0O0N1l0024Ool3O00POol4On0eOol000Aoo`03
001oogoo00aoo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo00Uoo`0301ml07oo07moo`Al
01moo`Aoh3Uoo`0017oo00<007ooOol027oo00D007ooOomoo`0000Aoo`03001oogoo00Eoo`03001o
ogoo00Uoo`0301moh7oo07]oo`Al01moo`Aoh21oo`Emh1Qoo`00100037oo0`001Goo1@000goo00<0
07ooOol02Goo00<07ggPOol0MWoo1G`07Woo1GoP7Woo1WgP7Goo000POol00`00Oomoo`09Ool00`0O
ON1l001bOol4O00OOol4On0OOol4ON0SOol0021oo`8000Yoo`0301mmh7`006ioo`Al01ioo`Eoh1mo
o`Amh2Moo`0087oo00<007ooOol02Goo00<07`7PO000Jgoo0g`07Woo17oP7goo1GgP:goo000POol0
0`00Oomoo`09Ool0100O0N1mh7`0Igoo0g`077oo1GoP7Woo1GgP<7oo000POol00`00Oomoo`0:Ool0
0`0OON1l001SOol4O00KOol4On0OOol4ON0eOol0021oo`03001oogoo00Yoo`0301mmh7`005moo`Al
01Yoo`Eoh1moo`Amh3Uoo`0087oo00<007ooOol02Woo00@07`7POn1l05]oo`=l01Yoo`Aoh21oo`Am
h29oo`<1h1Qoo`0087oo0P002goo00@07`7POn1l05Qoo`=l01Yoo`=oh1moo`Emh29oo`@1h1]oo`00
87oo00<007ooOol02Woo00@07`7PON1l05Eoo`=l01Yoo`=oh1ioo`Amh21oo`L1h1moo`0087oo00<0
07ooOol02goo00<07ggPOn00DWoo0g`06Woo0goP7Goo17gP7Goo1`7P9Woo000POol00`00Oomoo`0;
Ool0100OON1oh7`0CWoo0g`06Goo17oP77oo17gP7Goo107P;Goo000POol00`00Oomoo`0;Ool0100O
0N1oh7`0Bgoo0g`067oo17oP6goo1GgP77oo1@7P<Goo000POol2000<Ool0100O0N1oh7`0B7oo0g`0
5goo17oP6goo17gP7Goo107P=Woo000POol00`00Oomoo`0;Ool0100O0N1mh7oPAGoo0g`05goo0goP
6Woo1GgP7Goo107P>Woo000POol00`00Oomoo`0<Ool0100OON1oh7`0@Goo0g`067oo0WoP6Goo17gP
7Woo107P8Goo1@0O67oo000POol00`00Oomoo`0<Ool0100OON1oh7`0?Woo0g`05goo17oP5Woo1GgP
7Goo1@7P7goo1P0O7Goo000POol00`00Oomoo`0<Ool01@0O0N1oh7ooO000>Woo0g`05Woo17oP5Woo
17gP7Woo107P87oo100O8goo000POol00`00Oomoo`0<Ool01@0O0N1mh7oPO000=goo0g`05Goo17oP
5goo0ggP7Goo1@7P7goo1@0O9goo000POol2000=Ool01@0O0N1mh7oPO000=7oo0g`05Goo0goP67oo
0ggP77oo107P87oo100O;7oo000POol00`00Oomoo`0=Ool01@0OON1oh7ooO000<7oo0g`05Goo0goP
67oo0ggP6goo107P7goo1@0O<7oo000POol00`00Oomoo`0=Ool01@0O0N1oh7ooO000;Woo0W`05Goo
0goP67oo0ggP6Woo107P7goo100O=Goo0008Ool40005Ool20005Ool30005Ool00`00Oomoo`0=Ool0
1P0O0N1mh7oPOoml02Yoo`=l01Aoo`=oh1Qoo`=mh1Uoo`@1h1moo`@07cUoo`001goo00<007ooOol0
0Woo00<007ooOol00Woo0P0017oo00D007ooOomoo`0000Aoo`03001oogoo00eoo`0401l1h7gPOn02
Ool00g`0Oomoo`0UOol2O00DOol3On0HOol3ON0IOol30N0OOol401lmOol000Moo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo009oo`03001oogoo00eoo`0501l1h7gPOomoh002Ool00g`0Oomo
o`0ROol2O00COol3On0GOol4ON0IOol30N0MOol501m1Ool000Moo`03001oogoo009oo`03001oogoo
00aoo`03001oogoo009oo`<000ioo`0401l1h7ooOn03Ool00g`0Oomoo`0OOol2O00BOol3On0FOol4
ON0IOol40N0LOol401m6Ool000Moo`03001oogoo009oo`03001oogoo00Yoo`8000Eoo`03001oogoo
00ioo`0501l1h7gPOomoh002Ool00g`0Oomoo`0KOol4O00BOol2On0EOol4ON0IOol40N0KOol501m:
Ool000Moo`03001oogoo009oo`03001oogoo00aoo`03001oogoo009oo`03001oogoo00ioo`0501l1
h7gPOomoh003Ool00g`0Oomoo`0FOol4O00COol3On0DOol3ON0IOol40N0KOol401m?Ool000Moo`03
001oogoo009oo`03001oogoo00Qoo`05001oogooOol00004Ool00`00Oomoo`0>Ool01P0O0N1ooggP
Oomoh0=oo`9l019oo`Al01Aoo`=oh1Eoo`9mh1Uoo`<1h1]oo`@07e=oo`0027oo100037oo0`001Goo
00<007ooOol03goo00<07`7PON000Woo00=oh7ooOol00Woo0W`037oo17`05Goo0goP5Goo0ggP67oo
0`7P6Woo100OEgoo000POol00`00Oomoo`0?Ool01P0O0N1ooggPOomoh0Ioo`al01Ioo`=oh1Eoo`=m
h1Moo`@1h1Uoo`@07e]oo`0087oo0P0047oo00@07`7POommh09oo`03On1oogoo029oo`=oh1Eoo`=m
h1Ioo`@1h1Yoo`<07emoo`0087oo00<007ooOol03goo00D07goo0N1ooggP009oo`03On1oogoo01io
o`=oh1Eoo`=mh1Ioo`<1h1]oo`<07f9oo`0087oo00<007ooOol047oo00D07`7POomooggP009oo`03
On1oogoo01Uoo`Aoh1Eoo`=mh1Ioo`<1h1Yoo`@07fEoo`0087oo00<007ooOol047oo00D07goo0N1o
oggP00=oo`9oh1Eoo`Aoh1Ioo`=mh1Ioo`<1h1Uoo`@07fUoo`0087oo00<007ooOol047oo00<07goo
0N000Woo00=mh7ooOol00Woo0WoP47oo0goP5goo0ggP5Woo0`7P5goo1@0OKGoo000POol2000BOol0
0`0OOol1h002Ool00ggPOomoo`03Ool4On06Ool6On0GOol3ON0FOol30N0FOol401mbOol0021oo`03
001oogoo015oo`0301moo`7P009oo`03ON1oogoo00Moo`Ioh1Yoo`=mh1Ioo`<1h1Eoo`@07gIoo`00
87oo00<007ooOol04Woo00<07goo0N000Woo00=mh7ooOol08Woo17gP5Goo107P5Goo0`0ONWoo000P
Ool00`00Oomoo`0BOol00`0OOol1h003Ool00ggPOomoo`0MOol4ON0EOol40N0GOol201mmOol0021o
o`03001oogoo01=oo`0301moo`7P00=oo`03ON1oogoo01Moo`Emh1Eoo`@1h1Moo`@07gmoo`0087oo
00<007ooOol04goo00@07gooOol1h0=oo`9mh1=oo`Amh1Moo`<1h1Moo`@07h=oo`0087oo0P005Goo
00<07goo0N001Goo0ggP3Goo0ggP6Goo0P7P5Woo100OQgoo000POol00`00Oomoo`0DOol0100OOomo
o`7P1goo3GgP6Goo0`7P5Goo0`0ORgoo000POol00`00Oomoo`0EOol0100OOomoo`7P:Goo0`7P5Goo
0`0OSWoo000POol00`00Oomoo`0EOol01@0OOomoogoo0N009Goo0`7P5Goo0`0OTGoo000POol00`00
Oomoo`0FOol01@0OOomoogoo0N0087oo107P5Goo0`0OU7oo000POol00`00Oomoo`0FOol00`0OOomo
o`02Ool00`7POomoo`0IOol40N0FOol301nGOol0021oo`8001Qoo`0301moogoo009oo`81h1Eoo`@1
h1Moo`<07iYoo`0087oo00<007ooOol05goo00<07gooOol017oo107P37oo1@7P67oo0`0OWGoo000P
Ool00`00Oomoo`0HOol00`0OOomoo`07Ool<0N0KOol201nPOol000@000Eoo`8000Eoo`<000Eoo`@0
00Aoo`03001oogoo01Uoo`0301moogoo02Uoo`@07j9oo`0017oo00<007ooOol00Woo0P0017oo00D0
07ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol0000LOol00`0OOomoo`0TOol401nVOol0
00Aoo`03001oogoo00aoo`03001oogoo00Ioo`05001oogooOol0000MOol00`0OOomoo`0NOol501nZ
Ool000Aoo`03001oogoo00aoo`03001oogoo00Ioo`04001oogooOol3000LOol201lJOol401n_Ool0
00Aoo`03001oogoo00Yoo`8000Eoo`@000Aoo`03001oogoo01ioo`807aAoo`@07k=oo`0017oo00<0
07ooOol037oo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol087oo1P0O1goo1`0O]goo0004
Ool00`00Oomoo`08Ool01@00Oomoogoo000017oo00<007ooOol01Goo00<007ooOol09Woo1`0O_Woo
0004000<Ool30005Ool50003Ool00`00Oomoo`3[Ool0021oo`800>aoo`0087oo00<007ooOol0jgoo
003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?mo
o`moo`00ogoo3goo003oOol?Ool00?moo`moo`007Woo0`0000Aoo`0000000>Uoo`007goo00D007oo
Oomoo`000>Yoo`007goo00D007ooOomoo`000>Yoo`007goo00D007ooOomoo`000>Yoo`007goo1@00
jWoo000OOol01@00Oomoogoo0000jWoo000OOol01@00Oomoogoo0000jWoo000NOol3000017oo0000
0000jGoo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo003oOol?Ool00001\
\>"],
  ImageRangeCache->{{{0, 269}, {178.813, 0}} -> {-0.924649, 0.10726, \
0.0352446, 0.00216827}}]
}, Open  ]],

Cell[TextData[{
  "The numerical solution is connected with the similarity solution via the \
similarity transformation. We can now at least numerically represent the \
non-classical similarity solution for the Boussinesq equation. The example \
demonstrates that the\[NonBreakingSpace]\[NoBreak]functions of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " support a pseudo-automatic procedure for the non-classical\
\[NonBreakingSpace]\[NoBreak]method. The interactions are reduced to a \
minimal number of steps. We\[NonBreakingSpace]\[NoBreak]also\
\[NonBreakingSpace]\[NoBreak]demonstrated that ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is capable of solving non-linear determining equations with a decision \
support provided by the user. The functions ",
  StyleBox["NonClassicalPointSymmetries[]", "MmaText"],
  " and ",
  StyleBox["PDESolve[]", "MmaText"],
  " reduce the solution steps and the interaction to a convenient number."
}], "Text",
  CellTags->{
  "numerical solution", "similarity transformation", 
    "NonClassicalPointSymmetries[]", "PDESolve[]"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3.3 The Fokker-Planck Equation", "Subsection",
  CellTags->"The Fokker-Planck equation"],

Cell[TextData[{
  "The Fokker-Planck (FP) equation is a general equation to describe \
statistical phenomena in condensed matter physics, quantum optics, chemical \
physics, and fluctuations in many other physical problems. For a detailed \
discussion of the Fokker-Planck equation, we refer to the book by ",
  ButtonBox["Risken [1984]",
    ButtonData:>{"Literat.nb", "Risken-1984"},
    ButtonStyle->"Hyperlink"],
  ". In this section, we restrict our considerations to the (1+1)-dimensional \
version of the FP equation"
}], "Text",
  CellTags->{
  "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
    "condensed matter physics", "quantum optics", "chemical physics", 
    "fluctuations", "FP-equation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_t\  = \ \((\(a(x)\)\ u)\)\_x\  + \ \((\(b(x)\)\ u)\)\_\(x, x\), 
    \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`a(x)\)]],
  " denotes the drift and ",
  Cell[BoxData[
      \(TraditionalForm\`b(x)\)]],
  " the diffusion coefficient. Both coefficients are functions of the spatial \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Subscripts in equation (6.19) denote partial derivatives with respect to \
time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Let us assume that we have a system with constant diffusion ",
  Cell[BoxData[
      \(TraditionalForm\`b(x) = 1\)]],
  " and a linear drift term ",
  Cell[BoxData[
      \(TraditionalForm\`a(x) = x\)]],
  ". Such a situation is possible for a Brownian particle in a liquid (",
  ButtonBox["Cicogna and Vitali [1990]",
    ButtonData:>{"Literat.nb", "Cicogna-1990"},
    ButtonStyle->"Hyperlink"],
  "). Under these conditions, equation (6.19) reduces to"
}], "Text",
  CellTags->{
  "Brownian particle in a liquid", "diffusion coefficient", 
    "drift coefficient"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(fokkerPlanck\  = \ 
      \[PartialD]\_t u[x, t] - \ x\ \[PartialD]\_x u[x, t]\  - 
          \[PartialD]\_\(x, x\)u[x, t] == 0; fokkerPlanck // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - x\ u\_x - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The point symmetries of this equation are", "Text",
  CellTags->"point symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ifokkerPlanck = Infinitesimals[fokkerPlanck, u, {x, t}]; 
    ifokkerPlanck // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                x\ \((\[ScriptCapitalF]\_1)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(E\^\(-t\)\ k1\), "+", \(E\^t\ k2\), "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(\(-2\)\ t\)\), " ", 
                  \((\(-E\^\(4\ t\)\)\ k3 + k5)\), " ", "x"}]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{
                RowBox[{
                  RowBox[{"-", 
                    StyleBox[\(1\/2\),
                      ScriptLevel->0]}], " ", \(E\^\(2\ t\)\), " ", "k3"}], 
                "-", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(\(-2\)\ t\)\), " ", "k5"}], 
                "+", "k6"}]}]},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", "u", " ", 
                  \((E\^\(2\ t\)\ k3 + 2\ k4 - 2\ E\^t\ k2\ x + 
                      E\^\(2\ t\)\ k3\ x\^2)\)}], "+", 
                \(\[ScriptCapitalF]\_1\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Times[ x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Times[ 
              Power[ E, 
                Times[ -1, t]], k1], 
            Times[ 
              Power[ E, t], k2], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ -2, t]], 
              Plus[ 
                Times[ -1, 
                  Power[ E, 
                    Times[ 4, t]], k3], k5], x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ 2, t]], k3], 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ -2, t]], k5], k6]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ 
              Rational[ 1, 2], u, 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, t]], k3], 
                Times[ 2, k4], 
                Times[ -2, 
                  Power[ E, t], k2, x], 
                Times[ 
                  Power[ E, 
                    Times[ 2, t]], k3, 
                  Power[ x, 2]]]], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a six-dimensional finite group extended by an infinite group \
given by ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "]. The arbitrary function ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] satisfies the FP equation. The structure of the group has some \
resemblance to the group of the heat equation. However, the detailed \
structure is completely different."
}], "Text",
  CellTags->"heat equation"],

Cell[TextData[{
  "The next step of our examination is the determination of the non-classical \
symmetries. To derive the non-classical determining equations for the FP \
equation, we apply the operator ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              StyleBox[
                TagBox[
                  StyleBox["\[ScriptN]\[ScriptCapitalP]\[ScriptCapitalS]",
                    FontSize->10],
                  NotationBoxTag,
                  Editable->True],
                FontSize->10], \(u, x\), "\[Gamma]"], "[", "\[CapitalDelta]", 
            "]"}], " "}], TraditionalForm]]],
  " to the equation"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"ncfokkerPlanck", " ", "=", " ", 
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptN]\[ScriptCapitalP]\[ScriptCapitalS]",
                  FontSize->10],
                NotationBoxTag,
                Editable->True],
              "Null",
              ScriptLevel->0], \({u}, {x, t}\), \({}\)], "[", "fokkerPlanck", 
          "]"}]}], ";", \(ncfokkerPlanck // LTF\)}]], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u\) == 0\)},
          {
            \(\[Phi]\_1\ \((\[Xi]\_2)\)\_u + \[Xi]\_1\ \((\[Xi]\_2)\)\_x + 
                \[Xi]\_2\ \((\[Xi]\_2)\)\_\(x, x\) == 0\)},
          {
            \(\(-\[Xi]\_1\)\ \[Xi]\_2\%2 - \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_t + 
                2\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_1)\)\_x - 
                x\ \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_2)\)\_t + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\%2\ \((\[Xi]\_2)\)\_x + 
                \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-2\)\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_2)\)\_t + 
                \[Phi]\_1\%2\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_x - 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_t + 
                x\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_x + 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {
            \(2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u + 
                2\ x\ \[Xi]\_2\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_2\ \((\[Xi]\_1)\)\_\(x, u\) + 
                \[Xi]\_2\ \((\[Phi]\_1)\)\_\(u, u\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Again, we assume that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2 = 1\)]],
  " thus we can simplify the non-classical determining equations by"
}], "Text",
  CellTags->"non-classical determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(deteqFP\  = \ 
      DeleteCases[
          \((ncfokkerPlanck\  /. u[x, t] \[Rule] u)\) /. \ 
            xi[2] \[Rule] Function[{x, t, u}, 1], 0]\  /. u \[Rule] u[x, t]; 
    deteqFP // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {
            \(\(-\[Xi]\_1\) - \((\[Xi]\_1)\)\_t + 
                2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - x\ \((\[Xi]\_1)\)\_x - 
                2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_x + \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-2\)\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x - \((\[Phi]\_1)\)\_t + 
                x\ \((\[Phi]\_1)\)\_x + \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {
            \(2\ x\ \((\[Xi]\_1)\)\_u + 2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we apply ",
  StyleBox["PDESolve[]", "MmaText"],
  " to the derived equations, the solution of the non-classical determining \
equations follow. This function originally designed for linear PDEs is \
capable of solving some kind of non-linear equations if some hints are \
supplied to the function. In the present case, ",
  StyleBox["PDESolve[]", "MmaText"],
  " detects a situation in which either a function ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["2",
    FontSlant->"Italic"],
  "]",
  StyleBox[" ",
    FontSlant->"Italic"],
  "or ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["6",
    FontSlant->"Italic"],
  "] can be set equal to zero. The function asks the user to decide which of \
these possibilities it should take. The following calculation is carried out \
under the second possibility:"
}], "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1\  = \ PDESolve[deteqFP, {u}, {x, t}]; inf1 // LTF\)], "Input"],

Cell[BoxData[
    \("There exists no unique solution of the equations."\)], "Output"],

Cell[BoxData[
    \("Please choose one of the following results"\)], "Output"],

Cell[BoxData[
    InterpretationBox[
      \(1\[InvisibleSpace]","\[InvisibleSpace]{\(free[2]\)[x, t] \[Rule] 0}
          \),
      SequenceForm[ 1, ",", {free[ 2][ x, t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[
      \(2\[InvisibleSpace]","\[InvisibleSpace]{\(free[6]\)[x, t] \[Rule] 0}
          \),
      SequenceForm[ 2, ",", {free[ 6][ x, t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Xi]\_1 == \[ScriptCapitalF]\_1\)},
          {\(\[Phi]\_1 == \[ScriptCapitalF]\_2 + u\ \[ScriptCapitalF]\_3\)},
          {
            \(\(-\[ScriptCapitalF]\_1\) - \((\[ScriptCapitalF]\_1)\)\_t - 
                x\ \((\[ScriptCapitalF]\_1)\)\_x - 
                2\ \[ScriptCapitalF]\_1\ \((\[ScriptCapitalF]\_1)\)\_x - 
                2\ \((\[ScriptCapitalF]\_3)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {
            \(\(-2\)\ \[ScriptCapitalF]\_2\ \((\[ScriptCapitalF]\_1)\)\_x - 
                \((\[ScriptCapitalF]\_2)\)\_t + 
                x\ \((\[ScriptCapitalF]\_2)\)\_x + 
                \((\[ScriptCapitalF]\_2)\)\_\(x, x\) == 0\)},
          {
            \(\(-2\)\ \[ScriptCapitalF]\_3\ \((\[ScriptCapitalF]\_1)\)\_x - 
                \((\[ScriptCapitalF]\_3)\)\_t + 
                x\ \((\[ScriptCapitalF]\_3)\)\_x + 
                \((\[ScriptCapitalF]\_3)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ u, 
              Subscript[ \[ScriptCapitalF], 3]]]], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Times[ -1, x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -2, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 3], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Plus[ 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 2], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], t]], 
            Times[ x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 2], x, x]], 0], 
        Equal[ 
          Plus[ 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 3], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 3], t]], 
            Times[ x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 3], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 3], x, x]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of the calculation is a general representation of the \
infinitesimals depending on three arbitrary functions",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox[
              FormBox[\(\[ScriptCapitalF]\_i = \),
                "TraditionalForm"],
              "MmaText"], 
            RowBox[{
              StyleBox["free",
                FontSlant->"Italic"], 
              StyleBox["[",
                "MmaText"], 
              StyleBox["i",
                "MmaText"], 
              StyleBox["]",
                "MmaText"]}]}]}], TraditionalForm]]],
  StyleBox[", i=",
    FontSlant->"Italic"],
  "1, 2, 3",
  StyleBox[" ",
    FontSlant->"Italic"],
  "which have to satisfy three nonlinear coupled PDEs. These PDEs again allow \
some symmetries. In the following, we determine the point symmetries of the \
non-classical non-linear determining equations. We gain a simpler \
representation by renaming the arbitrary functions ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["i",
    FontSlant->"Italic"],
  "] by"
}], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1h\  = \ 
      inf1\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. 
        \ {free[1] \[Rule] g, free[2] \[Rule] h, free[3] \[Rule] f}; 
    inf1h // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-g\) - 2\ f\_x - g\_t - 2\ g\ g\_x - x\ g\_x + g\_\(x, x\) == 
              0\)},
          {\(\(-2\)\ h\ g\_x - h\_t + x\ h\_x + h\_\(x, x\) == 0\)},
          {\(\(-f\_t\) + x\ f\_x - 2\ f\ g\_x + f\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
For this set of equations, we determine the infinitesimals by\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1hh\  = \ Infinitesimals[inf1h, {g, h, f}, {x, t}]; 
    inf1hh // LTF\)], "Input"],

Cell[BoxData[
    \(PDESolve::"nsf" \( : \ \) 
      "Use option Standard->True. \n This may lead to further\:f39fsolutions \
in case of linear Systems"\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                x\ \((\[ScriptCapitalF]\_1)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(E\^\(-t\)\ k1\), "+", \(E\^t\ k2\), "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(\(-2\)\ t\)\), " ", 
                  \((k3 + E\^\(4\ t\)\ k4)\), " ", "x"}]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{
                RowBox[{
                  RowBox[{"-", 
                    StyleBox[\(1\/2\),
                      ScriptLevel->0]}], " ", \(E\^\(\(-2\)\ t\)\), " ", 
                  "k3"}], "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(2\ t\)\), " ", "k4"}], "+", 
                "k5"}]}]},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(1\/2\),
                    ScriptLevel->0]}], " ", \(E\^\(\(-2\)\ t\)\), " ", 
                \((2\ E\^t\ k1 - 2\ E\^\(3\ t\)\ k2 + g\ k3 + 
                    E\^\(4\ t\)\ g\ k4 + 2\ k3\ x - 2\ E\^\(4\ t\)\ k4\ x)
                  \)}]}]},
          {
            RowBox[{\(\[Phi]\_2\), "==", 
              RowBox[{\(\(-E\^\(\(-2\)\ t\)\)\ h\ k3\), "-", 
                RowBox[{
                  StyleBox[\(3\/2\),
                    ScriptLevel->0], " ", \(E\^\(2\ t\)\), " ", "h", " ", 
                  "k4"}], "+", \(h\ k6\), "-", \(E\^t\ h\ k2\ x\), "-", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(2\ t\)\), " ", "h", " ", 
                  "k4", " ", \(x\^2\)}], "+", \(f\ \[ScriptCapitalF]\_1\), 
                "-", \(\((g + x)\)\ \((\[ScriptCapitalF]\_1)\)\_x\), "-", 
                \(\((\[ScriptCapitalF]\_1)\)\_\(x, x\)\)}]}]},
          {
            \(\[Phi]\_3 == 
              \(-E\^\(\(-2\)\ t\)\)\ 
                \((f\ \((k3 + E\^\(4\ t\)\ k4)\) + 
                    E\^\(3\ t\)\ g\ \((k2 + E\^t\ k4\ x)\) + 
                    E\^\(3\ t\)\ \((E\^t\ k4 + k2\ x + E\^t\ k4\ x\^2)\))
                  \)\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Times[ x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Times[ 
              Power[ E, 
                Times[ -1, t]], k1], 
            Times[ 
              Power[ E, t], k2], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ -2, t]], 
              Plus[ k3, 
                Times[ 
                  Power[ E, 
                    Times[ 4, t]], k4]], x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ -2, t]], k3], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ 2, t]], k4], k5]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ -1, 2], 
            Power[ E, 
              Times[ -2, t]], 
            Plus[ 
              Times[ 2, 
                Power[ E, t], k1], 
              Times[ -2, 
                Power[ E, 
                  Times[ 3, t]], k2], 
              Times[ g, k3], 
              Times[ 
                Power[ E, 
                  Times[ 4, t]], g, k4], 
              Times[ 2, k3, x], 
              Times[ -2, 
                Power[ E, 
                  Times[ 4, t]], k4, x]]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Plus[ 
            Times[ -1, 
              Power[ E, 
                Times[ -2, t]], h, k3], 
            Times[ 
              Rational[ -3, 2], 
              Power[ E, 
                Times[ 2, t]], h, k4], 
            Times[ h, k6], 
            Times[ -1, 
              Power[ E, t], h, k2, x], 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ 2, t]], h, k4, 
              Power[ x, 2]], 
            Times[ f, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, 
              Plus[ g, x], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x, x]]]], 
        Equal[ 
          Subscript[ \[Phi], 3], 
          Times[ -1, 
            Power[ E, 
              Times[ -2, t]], 
            Plus[ 
              Times[ f, 
                Plus[ k3, 
                  Times[ 
                    Power[ E, 
                      Times[ 4, t]], k4]]], 
              Times[ 
                Power[ E, 
                  Times[ 3, t]], g, 
                Plus[ k2, 
                  Times[ 
                    Power[ E, t], k4, x]]], 
              Times[ 
                Power[ E, 
                  Times[ 3, t]], 
                Plus[ 
                  Times[ 
                    Power[ E, t], k4], 
                  Times[ k2, x], 
                  Times[ 
                    Power[ E, t], k4, 
                    Power[ x, 2]]]]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The infinitesimals represent a six-dimensional finite group and an \
infinite one given by the arbitrary function ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ". Surprisingly, this function must satisfy the original equation with \
which we started. Now you see another reason why we changed the names of the \
three arbitrary functions in the non-classical analysis preventing mismatches \
of the two calculations. Knowing the point symmetries of the non-classical \
determining equations, we can reduce the equations by applying ",
  StyleBox["LieReduction[]:", "MmaText"]
}], "Text",
  CellTags->{
  "point symmetries of the non-classical determining equations", 
    "LieReduction[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      \({{\(xi[1]\)[x, t, g, h, f], \(xi[2]\)[x, t, g, h, f]}, {
                \(phi[1]\)[x, t, g, h, f], \(phi[2]\)[x, t, g, h, f], 
                \(phi[3]\)[x, t, g, h, f]}} /. 
            inf1hh\[LeftDoubleBracket]1\[RightDoubleBracket]\)\  /. {
            k1 \[Rule] 1, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 0, 
            k5 \[Rule] 1, k6 \[Rule] 0, 
            free[___] \[Rule] Function[{x, t}, 0]} // Expand\)], "Input"],

Cell[BoxData[
    \({{E\^\(-t\), 1}, {\(-E\^\(-t\)\), 0, 0}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "For the sub-group ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", " ", 
          RowBox[{
            StyleBox["k5",
              FontSlant->"Italic"], " ", "=", "1"}]}], TraditionalForm]]],
  ", the reduction is gained by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1\  = \ 
      LieReduction[inf1h, {g, h, f}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \(\((red1 /. zeta1 \[Rule] \[Zeta]\_1)\) // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Output"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(E\^\(-t\) + x - \[Zeta]\_1 == 0\)},
          {\(g + x - F\_1 == 0\)},
          {\(h - F\_2 == 0\)},
          {\(f - F\_3 == 0\)},
          {
            \(F\_1 - 2\ F3\_\(\[Zeta]\_1\) - 
                2\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                \[Zeta]\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)},
          {
            \(2\ F\_2 - 2\ F\_2\ F1\_\(\[Zeta]\_1\) + 
                \[Zeta]\_1\ \((F\_2)\)\_\(\[Zeta]\_1\) + 
                \((F\_2)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)},
          {
            \(2\ F\_3 - 2\ F\_3\ F1\_\(\[Zeta]\_1\) + 
                \[Zeta]\_1\ \((F\_3)\)\_\(\[Zeta]\_1\) + 
                \((F\_3)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We find a coupled non-linear system of ODEs for the similarity functions ",
  
  Cell[BoxData[
      \(TraditionalForm\`F1, \ F2, \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`F3\)]],
  ". A special solution follows by choosing ",
  Cell[BoxData[
      \(TraditionalForm\`F2 = \(F3 = 0\)\)]],
  ":"
}], "Text",
  CellTags->"similarity function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\  /. {
            F2 \[Rule] Function[zeta1, 0], F3 \[Rule] Function[zeta1, 0]}
            \) /. zeta1 \[Rule] \[Zeta]\_1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(F\_1 - 2\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                \[Zeta]\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)},
          {"True"},
          {"True"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The remaining ODE for ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " is solved by means of ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"psol", " ", "=", " ", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{\(F1[zeta1]\), "+", 
              RowBox[{"zeta1", " ", 
                RowBox[{
                  SuperscriptBox["F1", "\[Prime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
              RowBox[{"2", " ", \(F1[zeta1]\), " ", 
                RowBox[{
                  SuperscriptBox["F1", "\[Prime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}], "+", 
              RowBox[{
                SuperscriptBox["F1", "\[DoublePrime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}], "==", 
            "0"}], ",", "F1", ",", "zeta1"}], "]"}]}]], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((\(\(-2\)\ E\^\(#1\^2\/2\)\ \@#1\^2 + 2\ #1\^2\ C[1] + 
                  \@\(2\ \[Pi]\)\ #1\^2\ Erfi[\@#1\^2\/\@2]\)\/\(#1\ 
                  \((2\ C[1] + \@\(2\ \[Pi]\)\ Erfi[\@#1\^2\/\@2])\)\)&)\)}}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution for ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " contains the special function ",
  StyleBox["Erfi[]", "MmaText"],
  ". The inversion of the used transformations provides the solution for the \
unknown functions ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ", ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["2", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ", and ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["3", "MmaText",
    FontSlant->"Italic"],
  StyleBox["] ", "MmaText"],
  "of the non-classical symmetries:"
}], "Text",
  CellTags->{"special function", "Erfi[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solg
      \  = {free[1] \[Rule] Function[{x, t}, g], 
          free[2] \[Rule] Function[{x, t}, h], 
          free[3] \[Rule] Function[{x, t}, f]} /. 
        Solve[\((
              \(red1\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. \ psol
                  \)\  /. {F2 \[Rule] Function[zeta1, 0], 
                  F3 \[Rule] Function[zeta1, 0]})\) // Flatten, {g, h, f}]
          \)], "Input"],

Cell[BoxData[
    \({{free[1] \[Rule] 
          Function[{x, t}, 
            \(-x\) + 
              \((\(-2\)\ E\^\(1\/2\ \((E\^\(-t\) + x)\)\^2\)\ 
                      \@\((E\^\(-t\) + x)\)\^2 + 
                    2\ \((E\^\(-t\) + x)\)\^2\ C[1] + 
                    \@\(2\ \[Pi]\)\ \((E\^\(-t\) + x)\)\^2\ 
                      Erfi[\@\((E\^\(-t\) + x)\)\^2\/\@2])\)/
                \((\((E\^\(-t\) + x)\)\ 
                    \((2\ C[1] + 
                        \@\(2\ \[Pi]\)\ Erfi[\@\((E\^\(-t\) + x)\)\^2\/\@2])
                      \))\)], free[2] \[Rule] Function[{x, t}, 0], 
        free[3] \[Rule] Function[{x, t}, 0]}}\)], "Output"]
}, Open  ]],

Cell["\<\
The check of the initial determining equations reveals that, in \
fact, the given functions satisfy the determining equations:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1\[LeftDoubleBracket]2\[RightDoubleBracket] /. solg // Simplify\)], 
  "Input"],

Cell[BoxData[
    \({{0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell["\<\
Finally, the non-classical symmetry transformations for the FP \
equation under the condition that the non-linear determining equations allow \
point symmetries are given by\
\>", "Text",
  CellTags->"non-classical symmetry transformations of the FP-equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncinfi\  = \ 
      Append[\(\(\(inf1\[LeftDoubleBracket]1\[RightDoubleBracket] /. solg
                  \)\  /. C[1] \[Rule] k1\)\  /. u[x, t] \[Rule] u\) /. \ 
            Rule[\(a_[n_]\)[h___], b_] \[Rule] 
              Rule[a[n], 
                Function[$v, $w] /. {$v \[Rule] {h}, $w \[Rule] b}] // 
          Flatten, xi[2] \[Rule] Function[{x, t, u}, 1]]; ncinfi // LTF\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 0\)},
          {
            \(\[Xi]\_1 == 
              \(-x\) + 
                \(2\ k1\ \((E\^\(-t\) + x)\)\^2 - 
                    2\ E\^\(1\/2\ \((E\^\(-t\) + x)\)\^2\)\ 
                      \@\((E\^\(-t\) + x)\)\^2 + 
                    \@\(2\ \[Pi]\)\ \((E\^\(-t\) + x)\)\^2\ 
                      Erfi[\@\((E\^\(-t\) + x)\)\^2\/\@2]\)\/\(\((
                      E\^\(-t\) + x)\)\ 
                    \((2\ k1 + 
                        \@\(2\ \[Pi]\)\ Erfi[\@\((E\^\(-t\) + x)\)\^2\/\@2])
                      \)\)\)},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Times[ -1, x], 
            Times[ 
              Power[ 
                Plus[ 
                  Power[ E, 
                    Times[ -1, t]], x], -1], 
              Power[ 
                Plus[ 
                  Times[ 2, k1], 
                  Times[ 
                    Power[ 
                      Times[ 2, Pi], 
                      Rational[ 1, 2]], 
                    Erfi[ 
                      Times[ 
                        Power[ 2, 
                          Rational[ -1, 2]], 
                        Power[ 
                          Power[ 
                            Plus[ 
                              Power[ E, 
                                Times[ -1, t]], x], 2], 
                          Rational[ 1, 2]]]]]], -1], 
              Plus[ 
                Times[ 2, k1, 
                  Power[ 
                    Plus[ 
                      Power[ E, 
                        Times[ -1, t]], x], 2]], 
                Times[ -2, 
                  Power[ E, 
                    Times[ 
                      Rational[ 1, 2], 
                      Power[ 
                        Plus[ 
                          Power[ E, 
                            Times[ -1, t]], x], 2]]], 
                  Power[ 
                    Power[ 
                      Plus[ 
                        Power[ E, 
                          Times[ -1, t]], x], 2], 
                    Rational[ 1, 2]]], 
                Times[ 
                  Power[ 
                    Times[ 2, Pi], 
                    Rational[ 1, 2]], 
                  Power[ 
                    Plus[ 
                      Power[ E, 
                        Times[ -1, t]], x], 2], 
                  Erfi[ 
                    Times[ 
                      Power[ 2, 
                        Rational[ -1, 2]], 
                      Power[ 
                        Power[ 
                          Plus[ 
                            Power[ E, 
                              Times[ -1, t]], x], 2], 
                        Rational[ 1, 2]]]]]]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "At this stage of the calculation, we find a very special representation of \
the non-classical symmetries. The next step in the calculation should be the \
reduction of the FP equation. A glance at the above result reveals that this \
last step is very difficult because the infinitesimals contain special \
functions with very complicated arguments. Since the infinitesimals are part \
of a first-order PDE, we face the problem of solving these equations to find \
the invariants. Currently, neither ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nor ",
  StyleBox["MathLie ",
    FontSlant->"Italic"],
  "can solve this kind of equations. However, the result derived via a mixed \
application of Lie's classical and non-classical method demonstrates that a \
simple equation allows a very complicated structure of symmetries."
}], "Text",
  CellTags->{"reduction of the FP-equation", "infinitesimals", "invariants"}],

Cell["\<\
However, solutions of the FP equation are derivable if we make an \
ansatz for the non-classical infinitesimals of the form\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf2\  = \ 
      inf1 /. {free[1] \[Rule] Function[{x, t}, \(free[1]\)[x]], 
          free[2] \[Rule] Function[{x, t}, 0], 
          free[3] \[Rule] Function[{x, t}, 0]}; inf2 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Xi]\_1 == \[ScriptCapitalF]\_1\)},
          {\(\[Phi]\_1 == 0\)},
          {
            \(\(-\[ScriptCapitalF]\_1\) - x\ \((\[ScriptCapitalF]\_1)\)\_x - 
                2\ \[ScriptCapitalF]\_1\ \((\[ScriptCapitalF]\_1)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {"True"},
          {"True"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], True, True}]]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "assuming that the arbitrary functions",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["2", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " and ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["3", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " are vanishing constants. The substitution into the non-linear determining \
equations of the FP equation reveals that only one equation for the function \
",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] remains. So that the non-classical infinitesimals are determined by"
}], "Text",
  CellTags->"non-classical infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf3\  = 
      \ {Append[inf2\[LeftDoubleBracket]1\[RightDoubleBracket], 
          \(xi[2]\)[x, t, u[x, t]] \[Rule] 1], 
        DeleteCases[inf2\[LeftDoubleBracket]2\[RightDoubleBracket], 0]}; 
    inf3\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\[ScriptCapitalF]\_1\) - x\ \((\[ScriptCapitalF]\_1)\)\_x - 
                2\ \[ScriptCapitalF]\_1\ \((\[ScriptCapitalF]\_1)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {\(\[Xi]\_1 == \[ScriptCapitalF]\_1\)},
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Since the unknown function ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " is a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " only, we can again apply ",
  StyleBox["PDESolve[]", "MmaText"],
  " to solve the determining equation for ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]:", "MmaText"]
}], "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf4\  = \ PDESolve[inf3, {u}, {x, t}]; inf4 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              
              StyleBox[
                \(\(\(-2\)\ \@x\^2 + 
                      k1\ \@\(2\ \[Pi]\)\ x\ Erfi[\@x\^2\/\@2]\)\/\(2\ 
                        \@x\^2\ \((E\^\(x\^2\/2\)\ k1 + x)\) - 
                      k1\ \@\(2\ \[Pi]\)\ x\^2\ Erfi[\@x\^2\/\@2]\)\),
                ScriptLevel->0]}]},
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Plus[ 
              Times[ -2, 
                Power[ 
                  Power[ x, 2], 
                  Rational[ 1, 2]]], 
              Times[ k1, 
                Power[ 
                  Times[ 2, Pi], 
                  Rational[ 1, 2]], x, 
                Erfi[ 
                  Times[ 
                    Power[ 2, 
                      Rational[ -1, 2]], 
                    Power[ 
                      Power[ x, 2], 
                      Rational[ 1, 2]]]]]], 
            Power[ 
              Plus[ 
                Times[ 2, 
                  Power[ 
                    Power[ x, 2], 
                    Rational[ 1, 2]], 
                  Plus[ 
                    Times[ 
                      Power[ E, 
                        Times[ 
                          Rational[ 1, 2], 
                          Power[ x, 2]]], k1], x]], 
                Times[ -1, k1, 
                  Power[ 
                    Times[ 2, Pi], 
                    Rational[ 1, 2]], 
                  Power[ x, 2], 
                  Erfi[ 
                    Times[ 
                      Power[ 2, 
                        Rational[ -1, 2]], 
                      Power[ 
                        Power[ x, 2], 
                        Rational[ 1, 2]]]]]], -1]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an explicit representation of the non-classical symmetries \
for the FP equation depending on a single parameter ",
  Cell[BoxData[
      FormBox[
        StyleBox["k1",
          FontSlant->"Italic"], TraditionalForm]]],
  ". This parameter is responsible for the transformation properties. Because \
",
  StyleBox["PDESolve[]", "MmaText"],
  " returns the infinitesimals in a special representation, we need to \
transform the infinitesimals into a pure function."
}], "Text",
  CellTags->{"non-classical symmetries", "PDESolve[]", "pure function"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncifokkerPlanck\  = 
      \(inf4\  /. u[x, t] \[Rule] u\) /. \ 
          Rule[\(a_[n_]\)[h___], b_] \[Rule] 
            Rule[a[n], Function[$v, $w] /. {$v \[Rule] {h}, $w \[Rule] b}] // 
        Flatten; ncifokkerPlanck // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              
              StyleBox[
                \(\(\(-2\)\ \@x\^2 + 
                      k1\ \@\(2\ \[Pi]\)\ x\ Erfi[\@x\^2\/\@2]\)\/\(2\ 
                        \@x\^2\ \((E\^\(x\^2\/2\)\ k1 + x)\) - 
                      k1\ \@\(2\ \[Pi]\)\ x\^2\ Erfi[\@x\^2\/\@2]\)\),
                ScriptLevel->0]}]},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Plus[ 
              Times[ -2, 
                Power[ 
                  Power[ x, 2], 
                  Rational[ 1, 2]]], 
              Times[ k1, 
                Power[ 
                  Times[ 2, Pi], 
                  Rational[ 1, 2]], x, 
                Erfi[ 
                  Times[ 
                    Power[ 2, 
                      Rational[ -1, 2]], 
                    Power[ 
                      Power[ x, 2], 
                      Rational[ 1, 2]]]]]], 
            Power[ 
              Plus[ 
                Times[ 2, 
                  Power[ 
                    Power[ x, 2], 
                    Rational[ 1, 2]], 
                  Plus[ 
                    Times[ 
                      Power[ E, 
                        Times[ 
                          Rational[ 1, 2], 
                          Power[ x, 2]]], k1], x]], 
                Times[ -1, k1, 
                  Power[ 
                    Times[ 2, Pi], 
                    Rational[ 1, 2]], 
                  Power[ x, 2], 
                  Erfi[ 
                    Times[ 
                      Power[ 2, 
                        Rational[ -1, 2]], 
                      Power[ 
                        Power[ x, 2], 
                        Rational[ 1, 2]]]]]], -1]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "In the following, we will restrict our considerations to a sub-class of \
transformations for which ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", "0."}], TraditionalForm]]],
  " The non-classical infinitesimals reduce to the simple form"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      \({{\(xi[1]\)[x, t, u], \(xi[2]\)[x, t, u]}, {\(phi[1]\)[x, t, u]}} /. 
          ncifokkerPlanck\)\  /. k1 \[Rule] 0\)], "Input"],

Cell[BoxData[
    \({{\(-\(1\/x\)\), 1}, {0}}\)], "Output"]
}, Open  ]],

Cell["\<\
For this sub-class of infinitesimal transformation, we reduce the \
original FP equation by\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red\  = \ 
      LieReduction[fokkerPlanck, {u}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \(red /. zeta1 \[Rule] \[Zeta]\_1 // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \((2\ t + x\^2)\)}], "-", 
                \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(u - F\_1 == 0\)},
          {
            \(\(-x\^2\)\ 
                \((F1\_\(\[Zeta]\_1\) + F1\_\(\[Zeta]\_1, \[Zeta]\_1\))\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting second-order ODE is solved by ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rsol\  = \ 
      DSolve[red\[LeftDoubleBracket]3, 1\[RightDoubleBracket], F1, zeta1]\)], 
  "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((\(-E\^\(-#1\)\)\ C[1] + C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution is a decaying exponential function in the similarity variable \
",
  Cell[BoxData[
      \(\[Zeta]\_1 = \((2\ t + x\^2)\)/2\)]],
  ". The solution for the original variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " follows by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = 
      Solve[\ red\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. \ rsol, 
          u] // Flatten\)], "Input"],

Cell[BoxData[
    \({u \[Rule] \(-E\^\(1\/2\ \((\(-2\)\ t - x\^2)\)\)\)\ C[1] + C[2]}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "representing a Gaussian in the spatial variable multiplied by an \
exponential decrease in time. The constants ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2] are constants of integration and can be used to implement initial \
conditions. For a fixed value of ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2], we plot the non-classical solution for the FP equation:"
}], "Text",
  CellTags->{
  "initial conditions", "non-classical solution of the FP-equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      Evaluate[\(u /. sol\)\  /. {C[1] \[Rule] \(-1\), C[2] \[Rule] 1}], {x, 
        \(-3\), 3}, {t, 0, 3}, AxesLabel \[Rule] {"\<x\>", "\<t\>", "\<u\>"}, 
      PlotPoints \[Rule] 25, PlotRange \[Rule] All, 
      ViewPoint -> {\(-1.253\), \ \(-2.896\), \ 1.221}, Mesh \[Rule] False]
      \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .64391 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0733255 1.07333 -0.163234 1.07333 [
[.37093 .01512 -5.90933 -9 ]
[.37093 .01512 6.09067 0 ]
[.62724 .0687 -3.07971 -9 ]
[.62724 .0687 2.92029 0 ]
[.86348 .11811 -3.19306 -9 ]
[.86348 .11811 2.80694 0 ]
[.62546 .00164 -5.13286 -15 ]
[.62546 .00164 4.86714 0 ]
[1.0011 .46237 -2.75415 0 ]
[1.0011 .46237 3.24585 9 ]
[.85628 .53841 -2.82241 0 ]
[.85628 .53841 3.17759 9 ]
[.73418 .60253 -2.87877 0 ]
[.73418 .60253 3.12123 9 ]
[.62983 .65732 -2.92608 0 ]
[.62983 .65732 3.07392 9 ]
[.79605 .63878 -4.75313 0 ]
[.79605 .63878 5.24687 15 ]
[.98956 .16404 0 -3.56644 ]
[.98956 .16404 6 5.43356 ]
[.99515 .2317 0 -3.61917 ]
[.99515 .2317 24 5.38083 ]
[1.00086 .30085 0 -3.67316 ]
[1.00086 .30085 18 5.32684 ]
[1.00669 .37152 0 -3.72846 ]
[1.00669 .37152 24 5.27154 ]
[1.01265 .44377 0 -3.78511 ]
[1.01265 .44377 6 5.21489 ]
[1.06684 .31304 0 -6.12204 ]
[1.06684 .31304 10 8.87796 ]
[ 0 0 0 0 ]
[ 1 .64391 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23392 0 m
.97589 .15476 L
s
.37073 .02854 m
.37062 .03524 L
s
[(-2)] .37093 .01512 -0.01511 1 Mshowa
.62759 .08211 m
.62777 .08882 L
s
[(0)] .62724 .0687 .02657 1 Mshowa
.86434 .1315 m
.86477 .13819 L
s
[(2)] .86348 .11811 .06435 1 Mshowa
.125 Mabswid
.43697 .04235 m
.43695 .04638 L
s
.50183 .05588 m
.50186 .05991 L
s
.56536 .06913 m
.56543 .07316 L
s
.68857 .09483 m
.68872 .09886 L
s
.74833 .1073 m
.74852 .11132 L
s
.80691 .11952 m
.80713 .12354 L
s
.30306 .01442 m
.30295 .01844 L
s
.92065 .14324 m
.92095 .14726 L
s
gsave
.62546 .00164 -66.1329 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
1 .44899 m
.6295 .64391 L
s
1 .44899 m
.99945 .44231 L
s
[(0)] 1.0011 .46237 -0.08195 -1 Mshowa
.85549 .52502 m
.85509 .51832 L
s
[(1)] .85628 .53841 -0.0592 -1 Mshowa
.73364 .58912 m
.73337 .58242 L
s
[(2)] .73418 .60253 -0.04041 -1 Mshowa
.6295 .64391 m
.62934 .6372 L
s
[(3)] .62983 .65732 -0.02464 -1 Mshowa
.125 Mabswid
.96899 .46531 m
.96868 .4613 L
s
.93909 .48104 m
.9388 .47703 L
s
.91024 .49622 m
.90997 .4922 L
s
.88239 .51087 m
.88214 .50685 L
s
.82949 .5387 m
.82927 .53468 L
s
.80434 .55193 m
.80414 .54791 L
s
.78001 .56473 m
.77982 .56071 L
s
.75645 .57712 m
.75628 .5731 L
s
.71152 .60076 m
.71138 .59673 L
s
.69008 .61204 m
.68995 .60801 L
s
.66929 .62298 m
.66916 .61895 L
s
.6491 .6336 m
.64899 .62957 L
s
gsave
.79605 .63878 -65.7531 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.97589 .15476 m
1 .44899 L
s
.97642 .16131 m
.96986 .15995 L
s
[(1)] .98956 .16404 -1 -0.20746 Mshowa
.98198 .22912 m
.9754 .22784 L
s
[(1.25)] .99515 .2317 -1 -0.19574 Mshowa
.98766 .29842 m
.98106 .29721 L
s
[(1.5)] 1.00086 .30085 -1 -0.18374 Mshowa
.99347 .36925 m
.98685 .36812 L
s
[(1.75)] 1.00669 .37152 -1 -0.17145 Mshowa
.9994 .44167 m
.99277 .44061 L
s
[(2)] 1.01265 .44377 -1 -0.15886 Mshowa
.125 Mabswid
.97753 .17476 m
.97358 .17395 L
s
.97863 .18826 m
.97469 .18746 L
s
.97974 .20182 m
.9758 .20103 L
s
.98086 .21545 m
.97691 .21466 L
s
.98311 .24286 m
.97916 .2421 L
s
.98424 .25666 m
.98028 .25591 L
s
.98537 .27052 m
.98142 .26978 L
s
.98651 .28444 m
.98256 .2837 L
s
.98881 .31246 m
.98485 .31174 L
s
.98997 .32657 m
.986 .32586 L
s
.99113 .34073 m
.98716 .34003 L
s
.99229 .35496 m
.98833 .35427 L
s
.99464 .38361 m
.99067 .38294 L
s
.99582 .39802 m
.99185 .39736 L
s
.99701 .41251 m
.99304 .41186 L
s
.9982 .42705 m
.99423 .42641 L
s
gsave
1.06684 .31304 -61 -10.122 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.23392 0 m
.22165 .32633 L
s
.22165 .32633 m
0 .5711 L
s
0 .5711 m
.01808 .31073 L
s
.01808 .31073 m
.23392 0 L
s
.97589 .15476 m
.62361 .40466 L
s
.62361 .40466 m
.6295 .64391 L
s
.6295 .64391 m
1 .44899 L
s
1 .44899 m
.97589 .15476 L
s
.23392 0 m
.22165 .32633 L
s
.22165 .32633 m
1 .44899 L
s
1 .44899 m
.97589 .15476 L
s
.97589 .15476 m
.23392 0 L
s
.01808 .31073 m
.62361 .40466 L
s
.62361 .40466 m
.6295 .64391 L
s
.6295 .64391 m
0 .5711 L
s
0 .5711 m
.01808 .31073 L
s
0 0 m
1 0 L
1 .64391 L
0 .64391 L
closepath
clip
newpath
.59 .803 .981 r
.61225 .39845 .60071 .40673 .62374 .41016 .63545 .40192 Mtetra
.59 .805 .982 r
.58888 .39507 .57749 .40339 .60071 .40673 .61225 .39845 Mtetra
.589 .808 .983 r
.56532 .39185 .5541 .40017 .57749 .40339 .58888 .39507 Mtetra
.588 .813 .985 r
.54159 .38886 .53053 .39716 .5541 .40017 .56532 .39185 Mtetra
.587 .818 .987 r
.51766 .38617 .50678 .39441 .53053 .39716 .54159 .38886 Mtetra
.584 .824 .99 r
.49354 .38381 .48283 .39193 .50678 .39441 .51766 .38617 Mtetra
.579 .83 .992 r
.46922 .38174 .45869 .38972 .48283 .39193 .49354 .38381 Mtetra
.573 .833 .994 r
.4447 .37986 .43434 .38767 .45869 .38972 .46922 .38174 Mtetra
.565 .833 .996 r
.41996 .37795 .40979 .38559 .43434 .38767 .4447 .37986 Mtetra
.557 .829 .997 r
.39502 .37576 .38504 .38326 .40979 .38559 .41996 .37795 Mtetra
.549 .82 .996 r
.36987 .37302 .36009 .38044 .38504 .38326 .39502 .37576 Mtetra
.543 .809 .995 r
.34452 .36952 .33494 .37696 .36009 .38044 .36987 .37302 Mtetra
.539 .796 .992 r
.31899 .36519 .30961 .37274 .33494 .37696 .34452 .36952 Mtetra
.538 .785 .989 r
.29326 .36009 .2841 .36785 .30961 .37274 .31899 .36519 Mtetra
.541 .776 .985 r
.26736 .3544 .2584 .36245 .2841 .36785 .29326 .36009 Mtetra
.546 .772 .982 r
.24127 .3484 .23251 .35676 .2584 .36245 .26736 .3544 Mtetra
.552 .772 .98 r
.21498 .34234 .20643 .35103 .23251 .35676 .24127 .3484 Mtetra
.56 .775 .979 r
.18848 .33645 .18014 .34543 .20643 .35103 .21498 .34234 Mtetra
.567 .78 .979 r
.16176 .33085 .15363 .34008 .18014 .34543 .18848 .33645 Mtetra
.574 .785 .979 r
.13481 .32556 .1269 .33501 .15363 .34008 .16176 .33085 Mtetra
.58 .79 .979 r
.10763 .32058 .09995 .3302 .1269 .33501 .13481 .32556 Mtetra
.584 .793 .979 r
.08021 .31582 .07275 .32558 .09995 .3302 .10763 .32058 Mtetra
.586 .796 .979 r
.05255 .31122 .04533 .3211 .07275 .32558 .08021 .31582 Mtetra
.588 .798 .98 r
.02465 .30672 .01767 .3167 .04533 .3211 .05255 .31122 Mtetra
.59 .803 .981 r
.624 .39003 .61225 .39845 .63545 .40192 .64736 .39354 Mtetra
.59 .805 .982 r
.60047 .38662 .58888 .39507 .61225 .39845 .624 .39003 Mtetra
.589 .809 .984 r
.57675 .3834 .56532 .39185 .58888 .39507 .60047 .38662 Mtetra
.588 .814 .986 r
.55284 .38044 .54159 .38886 .56532 .39185 .57675 .3834 Mtetra
.586 .821 .988 r
.52874 .37783 .51766 .38617 .54159 .38886 .55284 .38044 Mtetra
.583 .827 .991 r
.50445 .37559 .49354 .38381 .51766 .38617 .52874 .37783 Mtetra
.577 .834 .994 r
.47995 .3737 .46922 .38174 .49354 .38381 .50445 .37559 Mtetra
.57 .837 .996 r
.45524 .37202 .4447 .37986 .46922 .38174 .47995 .3737 Mtetra
.561 .837 .997 r
.43032 .37032 .41996 .37795 .4447 .37986 .45524 .37202 Mtetra
.551 .832 .998 r
.40518 .3683 .39502 .37576 .41996 .37795 .43032 .37032 Mtetra
.542 .822 .998 r
.37983 .36566 .36987 .37302 .39502 .37576 .40518 .3683 Mtetra
.536 .809 .996 r
.35428 .36215 .34452 .36952 .36987 .37302 .37983 .36566 Mtetra
.532 .795 .994 r
.32854 .35769 .31899 .36519 .34452 .36952 .35428 .36215 Mtetra
.531 .782 .99 r
.30261 .35235 .29326 .36009 .31899 .36519 .32854 .35769 Mtetra
.534 .773 .985 r
.27649 .34636 .26736 .3544 .29326 .36009 .30261 .35235 Mtetra
.54 .768 .982 r
.25019 .34 .24127 .3484 .26736 .3544 .27649 .34636 Mtetra
.547 .768 .98 r
.22369 .33359 .21498 .34234 .24127 .3484 .25019 .34 Mtetra
.556 .771 .979 r
.19697 .32737 .18848 .33645 .21498 .34234 .22369 .33359 Mtetra
.564 .777 .978 r
.17003 .32148 .16176 .33085 .18848 .33645 .19697 .32737 Mtetra
.572 .783 .978 r
.14286 .31596 .13481 .32556 .16176 .33085 .17003 .32148 Mtetra
.578 .788 .979 r
.11545 .31079 .10763 .32058 .13481 .32556 .14286 .31596 Mtetra
.583 .792 .979 r
.0878 .30588 .08021 .31582 .10763 .32058 .11545 .31079 Mtetra
.586 .796 .979 r
.05991 .30116 .05255 .31122 .08021 .31582 .0878 .30588 Mtetra
.588 .798 .98 r
.03177 .29654 .02465 .30672 .05255 .31122 .05991 .30116 Mtetra
.59 .803 .981 r
.63597 .38145 .624 .39003 .64736 .39354 .65949 .38501 Mtetra
.59 .806 .982 r
.61227 .37802 .60047 .38662 .624 .39003 .63597 .38145 Mtetra
.589 .81 .984 r
.58838 .37481 .57675 .3834 .60047 .38662 .61227 .37802 Mtetra
.588 .816 .986 r
.5643 .3719 .55284 .38044 .57675 .3834 .58838 .37481 Mtetra
.586 .823 .989 r
.54003 .36938 .52874 .37783 .55284 .38044 .5643 .3719 Mtetra
.582 .831 .992 r
.51556 .3673 .50445 .37559 .52874 .37783 .54003 .36938 Mtetra
.575 .838 .995 r
.49088 .36562 .47995 .3737 .50445 .37559 .51556 .3673 Mtetra
.566 .842 .997 r
.46599 .36418 .45524 .37202 .47995 .3737 .49088 .36562 Mtetra
.556 .842 .998 r
.44087 .36273 .43032 .37032 .45524 .37202 .46599 .36418 Mtetra
.545 .836 .999 r
.41554 .36091 .40518 .3683 .43032 .37032 .44087 .36273 Mtetra
.535 .825 .999 r
.38998 .35838 .37983 .36566 .40518 .3683 .41554 .36091 Mtetra
.527 .81 .998 r
.36423 .35487 .35428 .36215 .37983 .36566 .38998 .35838 Mtetra
.523 .793 .995 r
.33827 .35027 .32854 .35769 .35428 .36215 .36423 .35487 Mtetra
.523 .779 .99 r
.31213 .34468 .30261 .35235 .32854 .35769 .33827 .35027 Mtetra
.526 .768 .986 r
.2858 .33834 .27649 .34636 .30261 .35235 .31213 .34468 Mtetra
.533 .763 .982 r
.25928 .33159 .25019 .34 .27649 .34636 .2858 .33834 Mtetra
.542 .763 .979 r
.23256 .32478 .22369 .33359 .25019 .34 .25928 .33159 Mtetra
.551 .768 .978 r
.20563 .31819 .19697 .32737 .22369 .33359 .23256 .32478 Mtetra
.561 .774 .978 r
.17847 .31198 .17003 .32148 .19697 .32737 .20563 .31819 Mtetra
.57 .78 .978 r
.15108 .3062 .14286 .31596 .17003 .32148 .17847 .31198 Mtetra
.577 .787 .979 r
.12344 .30082 .11545 .31079 .14286 .31596 .15108 .3062 Mtetra
.582 .791 .979 r
.09555 .29575 .0878 .30588 .11545 .31079 .12344 .30082 Mtetra
.585 .795 .979 r
.06741 .2909 .05991 .30116 .0878 .30588 .09555 .29575 Mtetra
.587 .797 .979 r
.03903 .28616 .03177 .29654 .05991 .30116 .06741 .2909 Mtetra
.59 .804 .981 r
.64815 .37273 .63597 .38145 .65949 .38501 .67184 .37633 Mtetra
.59 .807 .983 r
.62428 .36928 .61227 .37802 .63597 .38145 .64815 .37273 Mtetra
.589 .812 .985 r
.60023 .36608 .58838 .37481 .61227 .37802 .62428 .36928 Mtetra
.588 .818 .987 r
.57598 .36323 .5643 .3719 .58838 .37481 .60023 .36608 Mtetra
.585 .826 .99 r
.55153 .36083 .54003 .36938 .5643 .3719 .57598 .36323 Mtetra
.58 .835 .993 r
.52689 .35894 .51556 .3673 .54003 .36938 .55153 .36083 Mtetra
.572 .843 .996 r
.50202 .3575 .49088 .36562 .51556 .3673 .52689 .35894 Mtetra
.562 .847 .997 r
.47694 .35635 .46599 .36418 .49088 .36562 .50202 .3575 Mtetra
.549 .846 .998 r
.45163 .35518 .44087 .36273 .46599 .36418 .47694 .35635 Mtetra
.537 .839 .999 r
.4261 .35361 .41554 .36091 .44087 .36273 .45163 .35518 Mtetra
.525 .827 1 r
.40034 .35122 .38998 .35838 .41554 .36091 .4261 .35361 Mtetra
.517 .81 .999 r
.37436 .34771 .36423 .35487 .38998 .35838 .40034 .35122 Mtetra
.513 .792 .996 r
.34819 .34297 .33827 .35027 .36423 .35487 .37436 .34771 Mtetra
.514 .775 .991 r
.32183 .33709 .31213 .34468 .33827 .35027 .34819 .34297 Mtetra
.518 .764 .986 r
.29528 .33036 .2858 .33834 .31213 .34468 .32183 .33709 Mtetra
.525 .758 .982 r
.26855 .32317 .25928 .33159 .2858 .33834 .29528 .33036 Mtetra
.535 .758 .979 r
.24161 .31591 .23256 .32478 .25928 .33159 .26855 .32317 Mtetra
.546 .763 .978 r
.21446 .30891 .20563 .31819 .23256 .32478 .24161 .31591 Mtetra
.557 .77 .977 r
.18707 .30235 .17847 .31198 .20563 .31819 .21446 .30891 Mtetra
.567 .778 .978 r
.15945 .29629 .15108 .3062 .17847 .31198 .18707 .30235 Mtetra
.575 .785 .978 r
.13158 .29068 .12344 .30082 .15108 .3062 .15945 .29629 Mtetra
.581 .79 .979 r
.10345 .28544 .09555 .29575 .12344 .30082 .13158 .29068 Mtetra
.585 .794 .979 r
.07507 .28044 .06741 .2909 .09555 .29575 .10345 .28544 Mtetra
.587 .797 .979 r
.04643 .27558 .03903 .28616 .06741 .2909 .07507 .28044 Mtetra
.59 .804 .982 r
.66056 .36385 .64815 .37273 .67184 .37633 .68442 .36749 Mtetra
.589 .808 .983 r
.63652 .36039 .62428 .36928 .64815 .37273 .66056 .36385 Mtetra
.589 .813 .985 r
.6123 .35721 .60023 .36608 .62428 .36928 .63652 .36039 Mtetra
.587 .821 .988 r
.58787 .35443 .57598 .36323 .60023 .36608 .6123 .35721 Mtetra
.584 .83 .991 r
.56325 .35218 .55153 .36083 .57598 .36323 .58787 .35443 Mtetra
.578 .839 .994 r
.53843 .35051 .52689 .35894 .55153 .36083 .56325 .35218 Mtetra
.569 .848 .997 r
.51338 .34937 .50202 .3575 .52689 .35894 .53843 .35051 Mtetra
.557 .852 .998 r
.48811 .34855 .47694 .35635 .50202 .3575 .51338 .34937 Mtetra
.542 .851 .998 r
.4626 .34772 .45163 .35518 .47694 .35635 .48811 .34855 Mtetra
.527 .843 .999 r
.43686 .34643 .4261 .35361 .45163 .35518 .4626 .34772 Mtetra
.514 .829 1 r
.41089 .34421 .40034 .35122 .4261 .35361 .43686 .34643 Mtetra
.506 .81 1 r
.3847 .34072 .37436 .34771 .40034 .35122 .41089 .34421 Mtetra
.502 .789 .997 r
.35831 .33582 .34819 .34297 .37436 .34771 .3847 .34072 Mtetra
.503 .771 .992 r
.33172 .32963 .32183 .33709 .34819 .34297 .35831 .33582 Mtetra
.508 .758 .986 r
.30496 .32246 .29528 .33036 .32183 .33709 .33172 .32963 Mtetra
.516 .752 .981 r
.278 .31477 .26855 .32317 .29528 .33036 .30496 .32246 Mtetra
.528 .752 .978 r
.25083 .30702 .24161 .31591 .26855 .32317 .278 .31477 Mtetra
.541 .758 .977 r
.22346 .29955 .21446 .30891 .24161 .31591 .25083 .30702 Mtetra
.553 .766 .977 r
.19585 .2926 .18707 .30235 .21446 .30891 .22346 .29955 Mtetra
.564 .775 .977 r
.16799 .28622 .15945 .29629 .18707 .30235 .19585 .2926 Mtetra
.573 .783 .978 r
.13988 .28037 .13158 .29068 .15945 .29629 .16799 .28622 Mtetra
.579 .789 .979 r
.11151 .27492 .10345 .28544 .13158 .29068 .13988 .28037 Mtetra
.584 .794 .979 r
.08288 .26977 .07507 .28044 .10345 .28544 .11151 .27492 Mtetra
.587 .796 .979 r
.05399 .26479 .04643 .27558 .07507 .28044 .08288 .26977 Mtetra
.59 .805 .982 r
.6732 .35482 .66056 .36385 .68442 .36749 .69723 .35849 Mtetra
.589 .809 .983 r
.64899 .35134 .63652 .36039 .66056 .36385 .6732 .35482 Mtetra
.589 .815 .986 r
.62459 .3482 .6123 .35721 .63652 .36039 .64899 .35134 Mtetra
.587 .823 .989 r
.6 .34552 .58787 .35443 .6123 .35721 .62459 .3482 Mtetra
.583 .834 .992 r
.5752 .34345 .56325 .35218 .58787 .35443 .6 .34552 Mtetra
.576 .844 .995 r
.55019 .34204 .53843 .35051 .56325 .35218 .5752 .34345 Mtetra
.565 .853 .997 r
.52496 .34123 .51338 .34937 .53843 .35051 .55019 .34204 Mtetra
.55 .858 .997 r
.4995 .34081 .48811 .34855 .51338 .34937 .52496 .34123 Mtetra
.532 .856 .997 r
.47379 .34038 .4626 .34772 .48811 .34855 .4995 .34081 Mtetra
.515 .846 .997 r
.44784 .33942 .43686 .34643 .4626 .34772 .47379 .34038 Mtetra
.501 .83 .999 r
.42166 .3374 .41089 .34421 .43686 .34643 .44784 .33942 Mtetra
.492 .809 1 r
.39524 .33394 .3847 .34072 .41089 .34421 .42166 .3374 Mtetra
.488 .786 .998 r
.36863 .32887 .35831 .33582 .3847 .34072 .39524 .33394 Mtetra
.49 .766 .992 r
.34181 .32232 .33172 .32963 .35831 .33582 .36863 .32887 Mtetra
.496 .751 .986 r
.31482 .31467 .30496 .32246 .33172 .32963 .34181 .32232 Mtetra
.506 .745 .981 r
.28763 .30642 .278 .31477 .30496 .32246 .31482 .31467 Mtetra
.52 .745 .977 r
.26024 .2981 .25083 .30702 .278 .31477 .28763 .30642 Mtetra
.534 .752 .976 r
.23263 .29012 .22346 .29955 .25083 .30702 .26024 .2981 Mtetra
.548 .761 .976 r
.20479 .28273 .19585 .2926 .22346 .29955 .23263 .29012 Mtetra
.561 .771 .977 r
.1767 .276 .16799 .28622 .19585 .2926 .20479 .28273 Mtetra
.571 .78 .978 r
.14835 .26987 .13988 .28037 .16799 .28622 .1767 .276 Mtetra
.578 .788 .978 r
.11973 .26422 .11151 .27492 .13988 .28037 .14835 .26987 Mtetra
.583 .793 .979 r
.09085 .2589 .08288 .26977 .11151 .27492 .11973 .26422 Mtetra
.586 .796 .979 r
.0617 .25378 .05399 .26479 .08288 .26977 .09085 .2589 Mtetra
.59 .806 .982 r
.68608 .34562 .6732 .35482 .69723 .35849 .71027 .34933 Mtetra
.589 .81 .984 r
.6617 .34214 .64899 .35134 .6732 .35482 .68608 .34562 Mtetra
.588 .817 .987 r
.63712 .33905 .62459 .3482 .64899 .35134 .6617 .34214 Mtetra
.586 .826 .99 r
.61235 .33649 .6 .34552 .62459 .3482 .63712 .33905 Mtetra
.582 .838 .993 r
.58737 .33463 .5752 .34345 .6 .34552 .61235 .33649 Mtetra
.573 .85 .996 r
.56218 .33353 .55019 .34204 .5752 .34345 .58737 .33463 Mtetra
.56 .859 .997 r
.53677 .33312 .52496 .34123 .55019 .34204 .56218 .33353 Mtetra
.541 .864 .995 r
.51111 .33316 .4995 .34081 .52496 .34123 .53677 .33312 Mtetra
.52 .86 .994 r
.48521 .33318 .47379 .34038 .4995 .34081 .51111 .33316 Mtetra
.5 .849 .994 r
.45905 .33261 .44784 .33942 .47379 .34038 .48521 .33318 Mtetra
.484 .831 .997 r
.43264 .33084 .42166 .3374 .44784 .33942 .45905 .33261 Mtetra
.475 .807 .999 r
.406 .32742 .39524 .33394 .42166 .3374 .43264 .33084 Mtetra
.472 .782 .998 r
.37915 .32217 .36863 .32887 .39524 .33394 .406 .32742 Mtetra
.475 .759 .993 r
.35211 .31522 .34181 .32232 .36863 .32887 .37915 .32217 Mtetra
.483 .743 .986 r
.32488 .30702 .31482 .31467 .34181 .32232 .35211 .31522 Mtetra
.495 .736 .98 r
.29746 .29814 .28763 .30642 .31482 .31467 .32488 .30702 Mtetra
.51 .738 .976 r
.26984 .28919 .26024 .2981 .28763 .30642 .29746 .29814 Mtetra
.527 .745 .975 r
.242 .28063 .23263 .29012 .26024 .2981 .26984 .28919 Mtetra
.543 .756 .975 r
.21392 .27275 .20479 .28273 .23263 .29012 .242 .28063 Mtetra
.557 .767 .976 r
.18559 .26562 .1767 .276 .20479 .28273 .21392 .27275 Mtetra
.568 .778 .977 r
.15699 .25919 .14835 .26987 .1767 .276 .18559 .26562 Mtetra
.576 .786 .978 r
.12812 .2533 .11973 .26422 .14835 .26987 .15699 .25919 Mtetra
.582 .792 .979 r
.09898 .24781 .09085 .2589 .11973 .26422 .12812 .2533 Mtetra
.586 .795 .979 r
.06957 .24255 .0617 .25378 .09085 .2589 .09898 .24781 Mtetra
.59 .806 .982 r
.69921 .33626 .68608 .34562 .71027 .34933 .72357 .34 Mtetra
.589 .811 .984 r
.67465 .33279 .6617 .34214 .68608 .34562 .69921 .33626 Mtetra
.588 .819 .987 r
.6499 .32976 .63712 .33905 .6617 .34214 .67465 .33279 Mtetra
.586 .83 .991 r
.62494 .32735 .61235 .33649 .63712 .33905 .6499 .32976 Mtetra
.58 .843 .994 r
.59979 .32573 .58737 .33463 .61235 .33649 .62494 .32735 Mtetra
.57 .856 .997 r
.57442 .32499 .56218 .33353 .58737 .33463 .59979 .32573 Mtetra
.553 .866 .996 r
.54882 .32505 .53677 .33312 .56218 .33353 .57442 .32499 Mtetra
.531 .869 .992 r
.52297 .32562 .51111 .33316 .53677 .33312 .54882 .32505 Mtetra
.505 .864 .988 r
.49686 .32619 .48521 .33318 .51111 .33316 .52297 .32562 Mtetra
.481 .85 .988 r
.47048 .32607 .45905 .33261 .48521 .33318 .49686 .32619 Mtetra
.463 .83 .993 r
.44385 .32459 .43264 .33084 .45905 .33261 .47048 .32607 Mtetra
.454 .805 .998 r
.41698 .32123 .406 .32742 .43264 .33084 .44385 .32459 Mtetra
.453 .777 .998 r
.3899 .31577 .37915 .32217 .406 .32742 .41698 .32123 Mtetra
.458 .752 .993 r
.36261 .30839 .35211 .31522 .37915 .32217 .3899 .31577 Mtetra
.468 .734 .985 r
.33514 .29956 .32488 .30702 .35211 .31522 .36261 .30839 Mtetra
.482 .727 .979 r
.30748 .28998 .29746 .29814 .32488 .30702 .33514 .29956 Mtetra
.5 .729 .975 r
.27962 .28031 .26984 .28919 .29746 .29814 .30748 .28998 Mtetra
.518 .737 .974 r
.25155 .27109 .242 .28063 .26984 .28919 .27962 .28031 Mtetra
.536 .75 .974 r
.22323 .26266 .21392 .27275 .242 .28063 .25155 .27109 Mtetra
.552 .763 .976 r
.19465 .25509 .18559 .26562 .21392 .27275 .22323 .26266 Mtetra
.565 .775 .977 r
.16581 .24832 .15699 .25919 .18559 .26562 .19465 .25509 Mtetra
.575 .784 .978 r
.13668 .24219 .12812 .2533 .15699 .25919 .16581 .24832 Mtetra
.581 .791 .979 r
.10728 .2365 .09898 .24781 .12812 .2533 .13668 .24219 Mtetra
.585 .795 .979 r
.0776 .23109 .06957 .24255 .09898 .24781 .10728 .2365 Mtetra
.59 .807 .983 r
.71258 .32673 .69921 .33626 .72357 .34 .73712 .33049 Mtetra
.589 .813 .985 r
.68785 .32328 .67465 .33279 .69921 .33626 .71258 .32673 Mtetra
.588 .822 .988 r
.66292 .32033 .6499 .32976 .67465 .33279 .68785 .32328 Mtetra
.585 .834 .992 r
.63779 .31809 .62494 .32735 .6499 .32976 .66292 .32033 Mtetra
.578 .848 .995 r
.61245 .31677 .59979 .32573 .62494 .32735 .63779 .31809 Mtetra
.566 .862 .996 r
.5869 .31645 .57442 .32499 .59979 .32573 .61245 .31677 Mtetra
.545 .872 .993 r
.56111 .31706 .54882 .32505 .57442 .32499 .5869 .31645 Mtetra
.517 .873 .985 r
.53507 .31825 .52297 .32562 .54882 .32505 .56111 .31706 Mtetra
.485 .865 .979 r
.50875 .31944 .49686 .32619 .52297 .32562 .53507 .31825 Mtetra
.457 .849 .978 r
.48216 .31986 .47048 .32607 .49686 .32619 .50875 .31944 Mtetra
.438 .827 .985 r
.45531 .31872 .44385 .32459 .47048 .32607 .48216 .31986 Mtetra
.429 .8 .994 r
.4282 .31543 .41698 .32123 .44385 .32459 .45531 .31872 Mtetra
.43 .77 .997 r
.40086 .30975 .3899 .31577 .41698 .32123 .4282 .31543 Mtetra
.437 .742 .992 r
.37333 .30187 .36261 .30839 .3899 .31577 .40086 .30975 Mtetra
.45 .723 .984 r
.34561 .29235 .33514 .29956 .36261 .30839 .37333 .30187 Mtetra
.467 .715 .977 r
.31771 .28196 .30748 .28998 .33514 .29956 .34561 .29235 Mtetra
.487 .718 .973 r
.28961 .27148 .27962 .28031 .30748 .28998 .31771 .28196 Mtetra
.509 .728 .972 r
.26129 .26153 .25155 .27109 .27962 .28031 .28961 .27148 Mtetra
.529 .743 .973 r
.23273 .25247 .22323 .26266 .25155 .27109 .26129 .26153 Mtetra
.547 .758 .975 r
.20391 .24441 .19465 .25509 .22323 .26266 .23273 .25247 Mtetra
.562 .771 .976 r
.17481 .23727 .16581 .24832 .19465 .25509 .20391 .24441 Mtetra
.573 .782 .978 r
.14543 .23086 .13668 .24219 .16581 .24832 .17481 .23727 Mtetra
.58 .789 .979 r
.11576 .22497 .10728 .2365 .13668 .24219 .14543 .23086 Mtetra
.584 .794 .979 r
.0858 .21939 .0776 .23109 .10728 .2365 .11576 .22497 Mtetra
.59 .808 .983 r
.72621 .31703 .71258 .32673 .73712 .33049 .75093 .32081 Mtetra
.589 .814 .986 r
.7013 .31361 .68785 .32328 .71258 .32673 .72621 .31703 Mtetra
.587 .824 .989 r
.67619 .31076 .66292 .32033 .68785 .32328 .7013 .31361 Mtetra
.584 .838 .993 r
.65089 .30874 .63779 .31809 .66292 .32033 .67619 .31076 Mtetra
.575 .854 .996 r
.62537 .30776 .61245 .31677 .63779 .31809 .65089 .30874 Mtetra
.56 .869 .995 r
.59964 .30793 .5869 .31645 .61245 .31677 .62537 .30776 Mtetra
.534 .878 .988 r
.57366 .30916 .56111 .31706 .5869 .31645 .59964 .30793 Mtetra
.498 .876 .975 r
.54742 .31108 .53507 .31825 .56111 .31706 .57366 .30916 Mtetra
.459 .864 .963 r
.5209 .31299 .50875 .31944 .53507 .31825 .54742 .31108 Mtetra
.426 .844 .962 r
.4941 .31404 .48216 .31986 .50875 .31944 .5209 .31299 Mtetra
.405 .821 .973 r
.46701 .3133 .45531 .31872 .48216 .31986 .4941 .31404 Mtetra
.399 .793 .987 r
.43965 .31011 .4282 .31543 .45531 .31872 .46701 .3133 Mtetra
.403 .76 .994 r
.41207 .30419 .40086 .30975 .4282 .31543 .43965 .31011 Mtetra
.414 .731 .99 r
.38428 .29575 .37333 .30187 .40086 .30975 .41207 .30419 Mtetra
.43 .71 .982 r
.35631 .28544 .34561 .29235 .37333 .30187 .38428 .29575 Mtetra
.45 .702 .975 r
.32815 .27414 .31771 .28196 .34561 .29235 .35631 .28544 Mtetra
.474 .706 .971 r
.29981 .26275 .28961 .27148 .31771 .28196 .32815 .27414 Mtetra
.498 .718 .97 r
.27124 .25196 .26129 .26153 .28961 .27148 .29981 .26275 Mtetra
.521 .735 .972 r
.24243 .2422 .23273 .25247 .26129 .26153 .27124 .25196 Mtetra
.542 .752 .974 r
.21336 .23359 .20391 .24441 .23273 .25247 .24243 .2422 Mtetra
.558 .767 .976 r
.184 .22604 .17481 .23727 .20391 .24441 .21336 .23359 Mtetra
.57 .779 .977 r
.15435 .21932 .14543 .23086 .17481 .23727 .184 .22604 Mtetra
.579 .788 .978 r
.12441 .2132 .11576 .22497 .14543 .23086 .15435 .21932 Mtetra
.584 .793 .979 r
.09418 .20745 .0858 .21939 .11576 .22497 .12441 .2132 Mtetra
.59 .809 .983 r
.74012 .30715 .72621 .31703 .75093 .32081 .76501 .31095 Mtetra
.589 .816 .986 r
.71503 .30377 .7013 .31361 .72621 .31703 .74012 .30715 Mtetra
.587 .828 .99 r
.68974 .30106 .67619 .31076 .7013 .31361 .71503 .30377 Mtetra
.582 .843 .994 r
.66425 .29928 .65089 .30874 .67619 .31076 .68974 .30106 Mtetra
.572 .86 .996 r
.63856 .2987 .62537 .30776 .65089 .30874 .66425 .29928 Mtetra
.552 .876 .992 r
.61264 .29945 .59964 .30793 .62537 .30776 .63856 .2987 Mtetra
.519 .883 .979 r
.58648 .30142 .57366 .30916 .59964 .30793 .61264 .29945 Mtetra
.474 .876 .957 r
.56005 .30417 .54742 .31108 .57366 .30916 .58648 .30142 Mtetra
.426 .857 .938 r
.53332 .30693 .5209 .31299 .54742 .31108 .56005 .30417 Mtetra
.386 .833 .936 r
.50629 .30869 .4941 .31404 .5209 .31299 .53332 .30693 Mtetra
.365 .809 .953 r
.47897 .30844 .46701 .3133 .4941 .31404 .50629 .30869 Mtetra
.361 .781 .976 r
.45136 .30537 .43965 .31011 .46701 .3133 .47897 .30844 Mtetra
.37 .748 .989 r
.42352 .29917 .41207 .30419 .43965 .31011 .45136 .30537 Mtetra
.386 .717 .988 r
.39547 .29011 .38428 .29575 .41207 .30419 .42352 .29917 Mtetra
.406 .695 .979 r
.36723 .2789 .35631 .28544 .38428 .29575 .39547 .29011 Mtetra
.431 .687 .971 r
.33882 .26657 .32815 .27414 .35631 .28544 .36723 .2789 Mtetra
.458 .692 .968 r
.31021 .25414 .29981 .26275 .32815 .27414 .33882 .26657 Mtetra
.486 .707 .967 r
.2814 .24241 .27124 .25196 .29981 .26275 .31021 .25414 Mtetra
.512 .726 .97 r
.25233 .23186 .24243 .2422 .27124 .25196 .2814 .24241 Mtetra
.535 .745 .972 r
.223 .22263 .21336 .23359 .24243 .2422 .25233 .23186 Mtetra
.554 .763 .975 r
.19338 .21462 .184 .22604 .21336 .23359 .223 .22263 Mtetra
.568 .777 .977 r
.16347 .20756 .15435 .21932 .184 .22604 .19338 .21462 Mtetra
.577 .786 .978 r
.13325 .2012 .12441 .2132 .15435 .21932 .16347 .20756 Mtetra
.583 .792 .979 r
.10274 .19526 .09418 .20745 .12441 .2132 .13325 .2012 Mtetra
.59 .81 .984 r
.75429 .2971 .74012 .30715 .76501 .31095 .77936 .30091 Mtetra
.589 .819 .987 r
.72902 .29378 .71503 .30377 .74012 .30715 .75429 .2971 Mtetra
.586 .831 .991 r
.70355 .29122 .68974 .30106 .71503 .30377 .72902 .29378 Mtetra
.581 .848 .995 r
.67789 .28974 .66425 .29928 .68974 .30106 .70355 .29122 Mtetra
.568 .867 .996 r
.65202 .28963 .63856 .2987 .66425 .29928 .67789 .28974 Mtetra
.543 .882 .987 r
.62592 .29105 .61264 .29945 .63856 .2987 .65202 .28963 Mtetra
.5 .885 .965 r
.59957 .29386 .58648 .30142 .61264 .29945 .62592 .29105 Mtetra
.443 .869 .93 r
.57295 .29758 .56005 .30417 .58648 .30142 .59957 .29386 Mtetra
.382 .841 .901 r
.54602 .30132 .53332 .30693 .56005 .30417 .57295 .29758 Mtetra
.336 .812 .896 r
.51877 .30393 .50629 .30869 .53332 .30693 .54602 .30132 Mtetra
.313 .789 .921 r
.4912 .30422 .47897 .30844 .50629 .30869 .51877 .30393 Mtetra
.314 .764 .958 r
.46334 .30131 .45136 .30537 .47897 .30844 .4912 .30422 Mtetra
.33 .732 .981 r
.43522 .29482 .42352 .29917 .45136 .30537 .46334 .30131 Mtetra
.353 .699 .983 r
.4069 .28504 .39547 .29011 .42352 .29917 .43522 .29482 Mtetra
.379 .677 .975 r
.37839 .27282 .36723 .2789 .39547 .29011 .4069 .28504 Mtetra
.409 .67 .967 r
.34971 .25932 .33882 .26657 .36723 .2789 .37839 .27282 Mtetra
.44 .676 .964 r
.32084 .24571 .31021 .25414 .33882 .26657 .34971 .25932 Mtetra
.472 .693 .964 r
.29177 .23292 .2814 .24241 .31021 .25414 .32084 .24571 Mtetra
.502 .715 .967 r
.26245 .22147 .25233 .23186 .2814 .24241 .29177 .23292 Mtetra
.528 .738 .971 r
.23285 .21155 .223 .22263 .25233 .23186 .26245 .22147 Mtetra
.549 .758 .974 r
.20297 .20301 .19338 .21462 .223 .22263 .23285 .21155 Mtetra
.565 .773 .976 r
.17278 .19559 .16347 .20756 .19338 .21462 .20297 .20301 Mtetra
.575 .784 .978 r
.14229 .18895 .13325 .2012 .16347 .20756 .17278 .19559 Mtetra
.582 .791 .979 r
.11148 .18281 .10274 .19526 .13325 .2012 .14229 .18895 Mtetra
.59 .812 .984 r
.76875 .28687 .75429 .2971 .77936 .30091 .79401 .29067 Mtetra
.589 .821 .988 r
.7433 .28362 .72902 .29378 .75429 .2971 .76875 .28687 Mtetra
.586 .835 .992 r
.71765 .28125 .70355 .29122 .72902 .29378 .7433 .28362 Mtetra
.579 .854 .996 r
.69181 .28011 .67789 .28974 .70355 .29122 .71765 .28125 Mtetra
.562 .874 .994 r
.66576 .28056 .65202 .28963 .67789 .28974 .69181 .28011 Mtetra
.529 .888 .978 r
.63949 .28275 .62592 .29105 .65202 .28963 .66576 .28056 Mtetra
.474 .883 .942 r
.61296 .28655 .59957 .29386 .62592 .29105 .63949 .28275 Mtetra
.401 .854 .89 r
.58615 .29139 .57295 .29758 .59957 .29386 .61296 .28655 Mtetra
.327 .812 .846 r
.55901 .29626 .54602 .30132 .57295 .29758 .58615 .29139 Mtetra
.273 .778 .839 r
.53153 .29984 .51877 .30393 .54602 .30132 .55901 .29626 Mtetra
.249 .756 .875 r
.50372 .30079 .4912 .30422 .51877 .30393 .53153 .29984 Mtetra
.256 .738 .93 r
.47559 .29806 .46334 .30131 .4912 .30422 .50372 .30079 Mtetra
.281 .71 .968 r
.4472 .29124 .43522 .29482 .46334 .30131 .47559 .29806 Mtetra
.314 .678 .977 r
.41859 .28066 .4069 .28504 .43522 .29482 .4472 .29124 Mtetra
.348 .655 .97 r
.3898 .26729 .37839 .27282 .4069 .28504 .41859 .28066 Mtetra
.384 .649 .962 r
.36084 .25246 .34971 .25932 .37839 .27282 .3898 .26729 Mtetra
.42 .658 .958 r
.33171 .23751 .32084 .24571 .34971 .25932 .36084 .25246 Mtetra
.456 .678 .96 r
.30236 .2235 .29177 .23292 .32084 .24571 .33171 .23751 Mtetra
.49 .703 .964 r
.27278 .21105 .26245 .22147 .29177 .23292 .30236 .2235 Mtetra
.52 .729 .969 r
.24292 .20034 .23285 .21155 .26245 .22147 .27278 .21105 Mtetra
.544 .752 .973 r
.21276 .19123 .20297 .20301 .23285 .21155 .24292 .20034 Mtetra
.561 .77 .976 r
.1823 .18339 .17278 .19559 .20297 .20301 .21276 .19123 Mtetra
.573 .782 .978 r
.15152 .17645 .14229 .18895 .17278 .19559 .1823 .18339 Mtetra
.581 .79 .979 r
.12042 .1701 .11148 .18281 .14229 .18895 .15152 .17645 Mtetra
.589 .813 .985 r
.7835 .27645 .76875 .28687 .79401 .29067 .80894 .28024 Mtetra
.588 .824 .989 r
.75787 .2733 .7433 .28362 .76875 .28687 .7835 .27645 Mtetra
.585 .84 .993 r
.73204 .27115 .71765 .28125 .7433 .28362 .75787 .2733 Mtetra
.576 .861 .996 r
.70602 .27043 .69181 .28011 .71765 .28125 .73204 .27115 Mtetra
.555 .882 .99 r
.6798 .27151 .66576 .28056 .69181 .28011 .70602 .27043 Mtetra
.512 .891 .964 r
.65335 .2746 .63949 .28275 .66576 .28056 .6798 .27151 Mtetra
.44 .873 .908 r
.62665 .27953 .61296 .28655 .63949 .28275 .65335 .2746 Mtetra
.347 .825 .831 r
.59965 .28567 .58615 .29139 .61296 .28655 .62665 .27953 Mtetra
.258 .767 .77 r
.57231 .29185 .55901 .29626 .58615 .29139 .59965 .28567 Mtetra
.196 .725 .759 r
.54461 .29657 .53153 .29984 .55901 .29626 .57231 .29185 Mtetra
.171 .708 .808 r
.51654 .29828 .50372 .30079 .53153 .29984 .54461 .29657 Mtetra
.185 .7 .888 r
.48814 .29578 .47559 .29806 .50372 .30079 .51654 .29828 Mtetra
.222 .68 .948 r
.45946 .28859 .4472 .29124 .47559 .29806 .48814 .29578 Mtetra
.268 .651 .966 r
.43055 .2771 .41859 .28066 .4472 .29124 .45946 .28859 Mtetra
.312 .63 .962 r
.40147 .26242 .3898 .26729 .41859 .28066 .43055 .2771 Mtetra
.355 .625 .955 r
.37222 .24607 .36084 .25246 .3898 .26729 .40147 .26242 Mtetra
.398 .637 .952 r
.3428 .22961 .33171 .23751 .36084 .25246 .37222 .24607 Mtetra
.439 .661 .955 r
.31319 .21422 .30236 .2235 .33171 .23751 .3428 .22961 Mtetra
.477 .69 .961 r
.28333 .20063 .27278 .21105 .30236 .2235 .31319 .21422 Mtetra
.511 .72 .967 r
.2532 .18903 .24292 .20034 .27278 .21105 .28333 .20063 Mtetra
.538 .745 .972 r
.22277 .17926 .21276 .19123 .24292 .20034 .2532 .18903 Mtetra
.558 .766 .975 r
.19202 .17096 .1823 .18339 .21276 .19123 .22277 .17926 Mtetra
.571 .78 .977 r
.16095 .1637 .15152 .17645 .1823 .18339 .19202 .17096 Mtetra
.58 .789 .978 r
.12956 .15711 .12042 .1701 .15152 .17645 .16095 .1637 Mtetra
.589 .815 .986 r
.79856 .26585 .7835 .27645 .80894 .28024 .82418 .26961 Mtetra
.588 .827 .99 r
.77274 .26281 .75787 .2733 .7835 .27645 .79856 .26585 Mtetra
.584 .845 .994 r
.74674 .26093 .73204 .27115 .75787 .2733 .77274 .26281 Mtetra
.572 .868 .995 r
.72054 .26069 .70602 .27043 .73204 .27115 .74674 .26093 Mtetra
.545 .888 .984 r
.69415 .26252 .6798 .27151 .70602 .27043 .72054 .26069 Mtetra
.488 .89 .942 r
.66753 .26664 .65335 .2746 .6798 .27151 .69415 .26252 Mtetra
.395 .853 .858 r
.64066 .27289 .62665 .27953 .65335 .2746 .66753 .26664 Mtetra
.281 .779 .751 r
.61348 .28053 .59965 .28567 .62665 .27953 .64066 .27289 Mtetra
0 0 0 r
.58594 .28823 .57231 .29185 .59965 .28567 .61348 .28053 Mtetra
.55801 .29427 .54461 .29657 .57231 .29185 .58594 .28823 Mtetra
.08 .64 .718 r
.52969 .29686 .51654 .29828 .54461 .29657 .55801 .29427 Mtetra
.099 .647 .828 r
.50101 .29463 .48814 .29578 .51654 .29828 .52969 .29686 Mtetra
.152 .641 .918 r
.47202 .28704 .45946 .28859 .48814 .29578 .50101 .29463 Mtetra
.213 .618 .952 r
.44281 .27451 .43055 .2771 .45946 .28859 .47202 .28704 Mtetra
.271 .599 .951 r
.41341 .25834 .40147 .26242 .43055 .2771 .44281 .27451 Mtetra
.323 .598 .945 r
.38386 .24027 .37222 .24607 .40147 .26242 .41341 .25834 Mtetra
.372 .613 .944 r
.35415 .22207 .3428 .22961 .37222 .24607 .38386 .24027 Mtetra
.419 .641 .948 r
.32425 .20511 .31319 .21422 .3428 .22961 .35415 .22207 Mtetra
.463 .675 .956 r
.29412 .19022 .28333 .20063 .31319 .21422 .32425 .20511 Mtetra
.5 .708 .964 r
.26371 .17762 .2532 .18903 .28333 .20063 .29412 .19022 Mtetra
.531 .738 .97 r
.233 .16713 .22277 .17926 .2532 .18903 .26371 .17762 Mtetra
.553 .761 .974 r
.20196 .15831 .19202 .17096 .22277 .17926 .233 .16713 Mtetra
.569 .777 .977 r
.1706 .1507 .16095 .1637 .19202 .17096 .20196 .15831 Mtetra
.578 .787 .978 r
.1389 .14384 .12956 .15711 .16095 .1637 .1706 .1507 Mtetra
.589 .817 .986 r
.81392 .25505 .79856 .26585 .82418 .26961 .83973 .25878 Mtetra
.588 .83 .991 r
.78792 .25217 .77274 .26281 .79856 .26585 .81392 .25505 Mtetra
.582 .85 .995 r
.76174 .25061 .74674 .26093 .77274 .26281 .78792 .25217 Mtetra
.568 .875 .994 r
.73537 .25092 .72054 .26069 .74674 .26093 .76174 .25061 Mtetra
.531 .894 .973 r
.70882 .25361 .69415 .26252 .72054 .26069 .73537 .25092 Mtetra
.456 .882 .908 r
.68204 .25894 .66753 .26664 .69415 .26252 .70882 .25361 Mtetra
.337 .817 .787 r
.65501 .26671 .64066 .27289 .66753 .26664 .68204 .25894 Mtetra
0 0 0 r
.62765 .27608 .61348 .28053 .64066 .27289 .65501 .26671 Mtetra
.59992 .28554 .58594 .28823 .61348 .28053 .62765 .27608 Mtetra
.57176 .29311 .55801 .29427 .58594 .28823 .59992 .28554 Mtetra
.021 0 0 r
.54318 .29673 .52969 .29686 .55801 .29427 .57176 .29311 Mtetra
0 .576 .746 r
.5142 .29483 .50101 .29463 .52969 .29686 .54318 .29673 Mtetra
.067 .589 .875 r
.4849 .28678 .47202 .28704 .50101 .29463 .5142 .29483 Mtetra
.149 .576 .931 r
.45536 .27307 .44281 .27451 .47202 .28704 .4849 .28678 Mtetra
.223 .563 .937 r
.42564 .25519 .41341 .25834 .44281 .27451 .45536 .27307 Mtetra
.286 .566 .933 r
.39577 .23515 .38386 .24027 .41341 .25834 .42564 .25519 Mtetra
.344 .586 .934 r
.36576 .21498 .35415 .22207 .38386 .24027 .39577 .23515 Mtetra
.397 .619 .941 r
.33557 .19624 .32425 .20511 .35415 .22207 .36576 .21498 Mtetra
.446 .657 .95 r
.30515 .17987 .29412 .19022 .32425 .20511 .33557 .19624 Mtetra
.489 .696 .96 r
.27446 .16614 .26371 .17762 .29412 .19022 .30515 .17987 Mtetra
.523 .729 .968 r
.24346 .15483 .233 .16713 .26371 .17762 .27446 .16614 Mtetra
.549 .756 .973 r
.21213 .14544 .20196 .15831 .233 .16713 .24346 .15483 Mtetra
.566 .774 .976 r
.18046 .13742 .1706 .1507 .20196 .15831 .21213 .14544 Mtetra
.577 .786 .978 r
.14846 .13029 .1389 .14384 .1706 .1507 .18046 .13742 Mtetra
.589 .819 .987 r
.82961 .24407 .81392 .25505 .83973 .25878 .8556 .24774 Mtetra
.587 .834 .992 r
.80343 .24137 .78792 .25217 .81392 .25505 .82961 .24407 Mtetra
.58 .857 .995 r
.77707 .24018 .76174 .25061 .78792 .25217 .80343 .24137 Mtetra
.561 .883 .991 r
.75054 .24114 .73537 .25092 .76174 .25061 .77707 .24018 Mtetra
.513 .896 .956 r
.72382 .24483 .70882 .25361 .73537 .25092 .75054 .24114 Mtetra
.414 .864 .859 r
.69689 .25155 .68204 .25894 .70882 .25361 .72382 .24483 Mtetra
.266 .761 .693 r
.6697 .26107 .65501 .26671 .68204 .25894 .69689 .25155 Mtetra
0 0 0 r
.64218 .27245 .62765 .27608 .65501 .26671 .6697 .26107 Mtetra
.007 0 0 r
.61426 .28394 .59992 .28554 .62765 .27608 .64218 .27245 Mtetra
.086 0 0 r
.58588 .29328 .57176 .29311 .59992 .28554 .61426 .28394 Mtetra
.124 0 0 r
.55703 .29811 .54318 .29673 .57176 .29311 .58588 .29328 Mtetra
.108 0 0 r
.52776 .29661 .5142 .29483 .54318 .29673 .55703 .29811 Mtetra
0 .521 .815 r
.49813 .28804 .4849 .28678 .5142 .29483 .52776 .29661 Mtetra
.075 .526 .901 r
.46824 .273 .45536 .27307 .4849 .28678 .49813 .28804 Mtetra
.169 .521 .918 r
.43817 .25316 .42564 .25519 .45536 .27307 .46824 .273 Mtetra
.245 .53 .918 r
.40797 .23087 .39577 .23515 .42564 .25519 .43817 .25316 Mtetra
.312 .556 .922 r
.37764 .20843 .36576 .21498 .39577 .23515 .40797 .23087 Mtetra
.372 .593 .931 r
.34714 .18767 .33557 .19624 .36576 .21498 .37764 .20843 Mtetra
.428 .637 .944 r
.31643 .16963 .30515 .17987 .33557 .19624 .34714 .18767 Mtetra
.476 .681 .956 r
.28545 .15461 .27446 .16614 .30515 .17987 .31643 .16963 Mtetra
.514 .72 .966 r
.25415 .14236 .24346 .15483 .27446 .16614 .28545 .15461 Mtetra
.543 .75 .972 r
.22253 .13233 .21213 .14544 .24346 .15483 .25415 .14236 Mtetra
.563 .77 .976 r
.19055 .12388 .18046 .13742 .21213 .14544 .22253 .13233 Mtetra
.575 .784 .978 r
.15823 .11644 .14846 .13029 .18046 .13742 .19055 .12388 Mtetra
.589 .822 .988 r
.84563 .23289 .82961 .24407 .8556 .24774 .87181 .23649 Mtetra
.586 .839 .993 r
.81927 .23041 .80343 .24137 .82961 .24407 .84563 .23289 Mtetra
.578 .864 .996 r
.79273 .22966 .77707 .24018 .80343 .24137 .81927 .23041 Mtetra
.552 .89 .985 r
.76604 .23138 .75054 .24114 .77707 .24018 .79273 .22966 Mtetra
.488 .894 .93 r
.73917 .23623 .72382 .24483 .75054 .24114 .76604 .23138 Mtetra
.36 .83 .789 r
.71211 .24455 .69689 .25155 .72382 .24483 .73917 .23623 Mtetra
0 0 0 r
.68478 .2561 .6697 .26107 .69689 .25155 .71211 .24455 Mtetra
.6571 .26979 .64218 .27245 .6697 .26107 .68478 .2561 Mtetra
.095 0 0 r
.629 .28365 .61426 .28394 .64218 .27245 .6571 .26979 Mtetra
.175 0 0 r
.6004 .29504 .58588 .29328 .61426 .28394 .629 .28365 Mtetra
.221 0 0 r
.57129 .30127 .55703 .29811 .58588 .29328 .6004 .29504 Mtetra
.219 0 0 r
.5417 .30024 .52776 .29661 .55703 .29811 .57129 .30127 Mtetra
0 .438 .736 r
.51172 .2911 .49813 .28804 .52776 .29661 .5417 .30024 Mtetra
0 .464 .861 r
.48146 .27452 .46824 .273 .49813 .28804 .51172 .2911 Mtetra
.108 .472 .894 r
.45102 .25245 .43817 .25316 .46824 .273 .48146 .27452 Mtetra
.2 .489 .899 r
.42047 .22758 .40797 .23087 .43817 .25316 .45102 .25245 Mtetra
.277 .521 .907 r
.3898 .20256 .37764 .20843 .40797 .23087 .42047 .22758 Mtetra
.345 .565 .919 r
.35899 .17947 .34714 .18767 .37764 .20843 .3898 .20256 Mtetra
.407 .615 .935 r
.32797 .15952 .31643 .16963 .34714 .18767 .35899 .17947 Mtetra
.461 .665 .951 r
.29669 .14305 .28545 .15461 .31643 .16963 .32797 .15952 Mtetra
.504 .709 .963 r
.2651 .12975 .25415 .14236 .28545 .15461 .29669 .14305 Mtetra
.537 .743 .97 r
.23316 .119 .22253 .13233 .25415 .14236 .2651 .12975 Mtetra
.559 .766 .975 r
.20088 .11006 .19055 .12388 .22253 .13233 .23316 .119 Mtetra
.573 .782 .977 r
.16824 .10228 .15823 .11644 .19055 .12388 .20088 .11006 Mtetra
.589 .824 .989 r
.86199 .22152 .84563 .23289 .87181 .23649 .88836 .22502 Mtetra
.585 .844 .994 r
.83545 .2193 .81927 .23041 .84563 .23289 .86199 .22152 Mtetra
.574 .871 .995 r
.80875 .21907 .79273 .22966 .81927 .23041 .83545 .2193 Mtetra
.541 .896 .975 r
.7819 .22166 .76604 .23138 .79273 .22966 .80875 .21907 Mtetra
.454 .884 .891 r
.75489 .22785 .73917 .23623 .76604 .23138 .7819 .22166 Mtetra
.292 .776 .697 r
.7277 .23802 .71211 .24455 .73917 .23623 .75489 .22785 Mtetra
0 0 0 r
.70025 .25192 .68478 .2561 .71211 .24455 .7277 .23802 Mtetra
.062 0 0 r
.67244 .26829 .6571 .26979 .68478 .2561 .70025 .25192 Mtetra
.173 0 0 r
.64417 .28487 .629 .28365 .6571 .26979 .67244 .26829 Mtetra
.252 0 0 r
.61536 .29866 .6004 .29504 .629 .28365 .64417 .28487 Mtetra
.307 0 0 r
.58597 .30653 .57129 .30127 .6004 .29504 .61536 .29866 Mtetra
.324 0 0 r
.55605 .30605 .5417 .30024 .57129 .30127 .58597 .30653 Mtetra
.255 0 0 r
.5257 .29626 .51172 .2911 .5417 .30024 .55605 .30605 Mtetra
0 .391 .809 r
.49505 .27792 .48146 .27452 .51172 .2911 .5257 .29626 Mtetra
.041 .415 .863 r
.46422 .25329 .45102 .25245 .48146 .27452 .49505 .27792 Mtetra
.151 .443 .876 r
.43329 .22545 .42047 .22758 .45102 .25245 .46422 .25329 Mtetra
.239 .483 .888 r
.40226 .19748 .3898 .20256 .42047 .22758 .43329 .22545 Mtetra
.315 .533 .906 r
.37111 .17175 .35899 .17947 .3898 .20256 .40226 .19748 Mtetra
.384 .59 .926 r
.33978 .14962 .32797 .15952 .35899 .17947 .37111 .17175 Mtetra
.444 .647 .944 r
.30819 .13149 .29669 .14305 .32797 .15952 .33978 .14962 Mtetra
.493 .696 .959 r
.27629 .11701 .2651 .12975 .29669 .14305 .30819 .13149 Mtetra
.53 .735 .969 r
.24405 .10545 .23316 .119 .2651 .12975 .27629 .11701 Mtetra
.555 .762 .974 r
.21145 .09596 .20088 .11006 .23316 .119 .24405 .10545 Mtetra
.571 .779 .977 r
.17848 .08782 .16824 .10228 .20088 .11006 .21145 .09596 Mtetra
.589 .828 .99 r
.87871 .20995 .86199 .22152 .88836 .22502 .90526 .21333 Mtetra
.584 .849 .994 r
.85199 .20804 .83545 .2193 .86199 .22152 .87871 .20995 Mtetra
.569 .879 .993 r
.82513 .20842 .80875 .21907 .83545 .2193 .85199 .20804 Mtetra
.524 .9 .959 r
.79813 .21203 .7819 .22166 .80875 .21907 .82513 .20842 Mtetra
.41 .861 .834 r
.771 .21976 .75489 .22785 .7819 .22166 .79813 .21203 Mtetra
0 0 0 r
.7437 .23208 .7277 .23802 .75489 .22785 .771 .21976 Mtetra
.71614 .24868 .70025 .25192 .7277 .23802 .7437 .23208 Mtetra
.138 0 0 r
.68822 .26815 .67244 .26829 .70025 .25192 .71614 .24868 Mtetra
.239 0 0 r
.6598 .28789 .64417 .28487 .67244 .26829 .68822 .26815 Mtetra
.315 0 0 r
.63078 .30446 .61536 .29866 .64417 .28487 .6598 .28789 Mtetra
.378 0 0 r
.60112 .31424 .58597 .30653 .61536 .29866 .63078 .30446 Mtetra
.416 0 0 r
.57086 .31443 .55605 .30605 .58597 .30653 .60112 .31424 Mtetra
.369 0 0 r
.54011 .3039 .5257 .29626 .55605 .30605 .57086 .31443 Mtetra
0 .306 .744 r
.50904 .28354 .49505 .27792 .5257 .29626 .54011 .3039 Mtetra
0 .351 .824 r
.47779 .25596 .46422 .25329 .49505 .27792 .50904 .28354 Mtetra
.097 .392 .849 r
.44645 .22472 .43329 .22545 .46422 .25329 .47779 .25596 Mtetra
.197 .44 .867 r
.41504 .19336 .40226 .19748 .43329 .22545 .44645 .22472 Mtetra
.283 .498 .889 r
.38354 .16459 .37111 .17175 .40226 .19748 .41504 .19336 Mtetra
.359 .563 .914 r
.35187 .13999 .33978 .14962 .37111 .17175 .38354 .16459 Mtetra
.426 .626 .937 r
.31996 .11997 .30819 .13149 .33978 .14962 .35187 .13999 Mtetra
.481 .682 .955 r
.28775 .10415 .27629 .11701 .30819 .13149 .31996 .11997 Mtetra
.522 .726 .966 r
.25519 .09167 .24405 .10545 .27629 .11701 .28775 .10415 Mtetra
.551 .757 .973 r
.22226 .08158 .21145 .09596 .24405 .10545 .25519 .09167 Mtetra
.569 .776 .977 r
.18896 .07303 .17848 .08782 .21145 .09596 .22226 .08158 Mtetra
.588 .831 .991 r
.89579 .19819 .87871 .20995 .90526 .21333 .92253 .20142 Mtetra
.583 .856 .995 r
.8689 .19665 .85199 .20804 .87871 .20995 .89579 .19819 Mtetra
.563 .887 .989 r
.84188 .19773 .82513 .20842 .85199 .20804 .8689 .19665 Mtetra
.502 .9 .935 r
.81475 .20252 .79813 .21203 .82513 .20842 .84188 .19773 Mtetra
.352 .821 .756 r
.78751 .21203 .771 .21976 .79813 .21203 .81475 .20252 Mtetra
0 0 0 r
.76012 .22682 .7437 .23208 .771 .21976 .78751 .21203 Mtetra
.069 0 0 r
.73249 .24655 .71614 .24868 .7437 .23208 .76012 .22682 Mtetra
.201 0 0 r
.70447 .26961 .68822 .26815 .71614 .24868 .73249 .24655 Mtetra
.292 0 .078 r
.67592 .29303 .6598 .28789 .68822 .26815 .70447 .26961 Mtetra
.366 0 .094 r
.64671 .31283 .63078 .30446 .6598 .28789 .67592 .29303 Mtetra
.434 0 .04 r
.61678 .32484 .60112 .31424 .63078 .30446 .64671 .31283 Mtetra
.491 0 0 r
.58616 .32582 .57086 .31443 .60112 .31424 .61678 .32484 Mtetra
.476 0 0 r
.555 .31445 .54011 .3039 .57086 .31443 .58616 .32582 Mtetra
0 .212 .665 r
.52347 .29176 .50904 .28354 .54011 .3039 .555 .31445 Mtetra
0 .281 .778 r
.49175 .26078 .47779 .25596 .50904 .28354 .52347 .29176 Mtetra
.04 .336 .816 r
.45997 .22563 .44645 .22472 .47779 .25596 .49175 .26078 Mtetra
.153 .394 .842 r
.42815 .19038 .41504 .19336 .44645 .22472 .45997 .22563 Mtetra
.247 .46 .87 r
.39627 .15814 .38354 .16459 .41504 .19336 .42815 .19038 Mtetra
.331 .532 .9 r
.36426 .13069 .35187 .13999 .38354 .16459 .39627 .15814 Mtetra
.405 .603 .928 r
.33202 .10853 .31996 .11997 .35187 .13999 .36426 .13069 Mtetra
.467 .666 .949 r
.29949 .09119 .28775 .10415 .31996 .11997 .33202 .10853 Mtetra
.513 .716 .964 r
.2666 .07768 .25519 .09167 .28775 .10415 .29949 .09119 Mtetra
.545 .751 .972 r
.23334 .06691 .22226 .08158 .25519 .09167 .2666 .07768 Mtetra
.566 .773 .976 r
.1997 .05791 .18896 .07303 .22226 .08158 .23334 .06691 Mtetra
.588 .835 .992 r
.91326 .18624 .89579 .19819 .92253 .20142 .94018 .18928 Mtetra
.581 .862 .995 r
.8862 .18513 .8689 .19665 .89579 .19819 .91326 .18624 Mtetra
.554 .894 .982 r
.85903 .18702 .84188 .19773 .8689 .19665 .8862 .18513 Mtetra
.471 .892 .899 r
.83178 .19318 .81475 .20252 .84188 .19773 .85903 .18702 Mtetra
.282 .761 .656 r
.80446 .20476 .78751 .21203 .81475 .20252 .83178 .19318 Mtetra
0 0 0 r
.77701 .2224 .76012 .22682 .78751 .21203 .80446 .20476 Mtetra
.138 0 0 r
.74933 .24574 .73249 .24655 .76012 .22682 .77701 .2224 Mtetra
.253 0 .093 r
.72125 .27296 .70447 .26961 .73249 .24655 .74933 .24574 Mtetra
.335 0 .163 r
.6926 .30064 .67592 .29303 .70447 .26961 .72125 .27296 Mtetra
.405 .012 .176 r
.66321 .32421 .64671 .31283 .67592 .29303 .6926 .30064 Mtetra
.477 .041 .132 r
.633 .33883 .61678 .32484 .64671 .31283 .66321 .32421 Mtetra
.55 .041 0 r
.60201 .34075 .58616 .32582 .61678 .32484 .633 .33883 Mtetra
.569 0 0 r
.5704 .32842 .555 .31445 .58616 .32582 .60201 .34075 Mtetra
0 .112 .575 r
.53837 .30304 .52347 .29176 .555 .31445 .5704 .32842 Mtetra
0 .204 .724 r
.50615 .26814 .49175 .26078 .52347 .29176 .53837 .30304 Mtetra
0 .276 .779 r
.47388 .22848 .45997 .22563 .49175 .26078 .50615 .26814 Mtetra
.107 .345 .813 r
.44162 .18874 .42815 .19038 .45997 .22563 .47388 .22848 Mtetra
.21 .419 .847 r
.40934 .15252 .39627 .15814 .42815 .19038 .44162 .18874 Mtetra
.301 .498 .883 r
.37696 .12184 .36426 .13069 .39627 .15814 .40934 .15252 Mtetra
.382 .577 .917 r
.34438 .09723 .33202 .10853 .36426 .13069 .37696 .12184 Mtetra
.451 .648 .943 r
.3115 .07815 .29949 .09119 .33202 .10853 .34438 .09723 Mtetra
.503 .704 .96 r
.27829 .06348 .2666 .07768 .29949 .09119 .3115 .07815 Mtetra
.54 .744 .97 r
.24469 .05195 .23334 .06691 .2666 .07768 .27829 .06348 Mtetra
.563 .769 .975 r
.2107 .04246 .1997 .05791 .23334 .06691 .24469 .05195 Mtetra
.587 .84 .993 r
.93112 .17409 .91326 .18624 .94018 .18928 .95822 .17691 Mtetra
.578 .87 .995 r
.9039 .17349 .8862 .18513 .91326 .18624 .93112 .17409 Mtetra
.542 .9 .971 r
.87659 .17634 .85903 .18702 .8862 .18513 .9039 .17349 Mtetra
.43 .873 .846 r
.84924 .18407 .83178 .19318 .85903 .18702 .87659 .17634 Mtetra
0 0 0 r
.82186 .19803 .80446 .20476 .83178 .19318 .84924 .18407 Mtetra
.038 0 0 r
.79438 .21897 .77701 .2224 .80446 .20476 .82186 .19803 Mtetra
.196 0 .05 r
.76669 .2465 .74933 .24574 .77701 .2224 .79438 .21897 Mtetra
.295 0 .174 r
.7386 .27853 .72125 .27296 .74933 .24574 .76669 .2465 Mtetra
.368 .017 .232 r
.70988 .31117 .6926 .30064 .72125 .27296 .7386 .27853 Mtetra
.436 .07 .244 r
.68033 .33913 .66321 .32421 .6926 .30064 .70988 .31117 Mtetra
.51 .104 .207 r
.64985 .35682 .633 .33883 .66321 .32421 .68033 .33913 Mtetra
.595 .119 .093 r
.61847 .35985 .60201 .34075 .633 .33883 .64985 .35682 Mtetra
.644 .089 0 r
.58637 .34643 .5704 .32842 .60201 .34075 .61847 .35985 Mtetra
.517 0 0 r
.55379 .31794 .53837 .30304 .5704 .32842 .58637 .34643 Mtetra
0 .125 .664 r
.52101 .27849 .50615 .26814 .53837 .30304 .55379 .31794 Mtetra
0 .214 .738 r
.48821 .23361 .47388 .22848 .50615 .26814 .52101 .27849 Mtetra
.059 .293 .781 r
.45546 .18871 .44162 .18874 .47388 .22848 .48821 .23361 Mtetra
.171 .375 .822 r
.42275 .14791 .40934 .15252 .44162 .18874 .45546 .18871 Mtetra
.269 .461 .864 r
.38998 .11351 .37696 .12184 .40934 .15252 .42275 .14791 Mtetra
.358 .549 .904 r
.35704 .08612 .34438 .09723 .37696 .12184 .38998 .11351 Mtetra
.433 .628 .935 r
.32382 .06507 .3115 .07815 .34438 .09723 .35704 .08612 Mtetra
.492 .691 .956 r
.29026 .04908 .27829 .06348 .3115 .07815 .32382 .06507 Mtetra
.533 .736 .969 r
.25632 .0367 .24469 .05195 .27829 .06348 .29026 .04908 Mtetra
.559 .765 .975 r
.22197 .02666 .2107 .04246 .24469 .05195 .25632 .0367 Mtetra
.586 .845 .994 r
.94939 .16175 .93112 .17409 .95822 .17691 .97667 .1643 Mtetra
.574 .878 .993 r
.92201 .16175 .9039 .17349 .93112 .17409 .94939 .16175 Mtetra
.525 .904 .954 r
.89458 .1657 .87659 .17634 .9039 .17349 .92201 .16175 Mtetra
.377 .837 .773 r
.86715 .17526 .84924 .18407 .87659 .17634 .89458 .1657 Mtetra
0 0 0 r
.83974 .19197 .82186 .19803 .84924 .18407 .86715 .17526 Mtetra
.107 0 0 r
.81228 .21672 .79438 .21897 .82186 .19803 .83974 .19197 Mtetra
.243 0 .137 r
.78463 .24909 .76669 .2465 .79438 .21897 .81228 .21672 Mtetra
.328 0 .24 r
.75657 .28671 .7386 .27853 .76669 .2465 .78463 .24909 Mtetra
.394 .068 .289 r
.72782 .32514 .70988 .31117 .7386 .27853 .75657 .28671 Mtetra
.459 .118 .299 r
.69815 .35824 .68033 .33913 .70988 .31117 .72782 .32514 Mtetra
.535 .156 .269 r
.6674 .37952 .64985 .35682 .68033 .33913 .69815 .35824 Mtetra
.629 .183 .173 r
.63561 .38387 .61847 .35985 .64985 .35682 .6674 .37952 Mtetra
.703 .176 0 r
.60297 .36919 .58637 .34643 .61847 .35985 .63561 .38387 Mtetra
.605 .087 0 r
.56979 .33708 .55379 .31794 .58637 .34643 .60297 .36919 Mtetra
0 .044 .6 r
.53639 .29236 .52101 .27849 .55379 .31794 .56979 .33708 Mtetra
0 .15 .693 r
.50299 .24144 .48821 .23361 .52101 .27849 .53639 .29236 Mtetra
.011 .24 .746 r
.46971 .19058 .45546 .18871 .48821 .23361 .50299 .24144 Mtetra
.13 .329 .794 r
.43653 .14451 .42275 .14791 .45546 .18871 .46971 .19058 Mtetra
.235 .422 .843 r
.40334 .10585 .38998 .11351 .42275 .14791 .43653 .14451 Mtetra
.331 .517 .889 r
.37002 .07526 .35704 .08612 .38998 .11351 .40334 .10585 Mtetra
.414 .605 .926 r
.33644 .05198 .32382 .06507 .35704 .08612 .37002 .07526 Mtetra
.479 .676 .952 r
.30253 .0345 .29026 .04908 .32382 .06507 .33644 .05198 Mtetra
.525 .728 .966 r
.26823 .02116 .25632 .0367 .29026 .04908 .30253 .0345 Mtetra
.555 .761 .974 r
.23353 .01051 .22197 .02666 .25632 .0367 .26823 .02116 Mtetra
0 g
.23392 0 m
.22165 .32633 L
s
.22165 .32633 m
0 .5711 L
s
0 .5711 m
.01808 .31073 L
s
.01808 .31073 m
.23392 0 L
s
.23392 0 m
.22165 .32633 L
s
.22165 .32633 m
1 .44899 L
s
1 .44899 m
.97589 .15476 L
s
.97589 .15476 m
.23392 0 L
s
.23392 0 m
.97589 .15476 L
s
.37073 .02854 m
.37062 .03524 L
s
[(-2)] .37093 .01512 -0.01511 1 Mshowa
.62759 .08211 m
.62777 .08882 L
s
[(0)] .62724 .0687 .02657 1 Mshowa
.86434 .1315 m
.86477 .13819 L
s
[(2)] .86348 .11811 .06435 1 Mshowa
.125 Mabswid
.43697 .04235 m
.43695 .04638 L
s
.50183 .05588 m
.50186 .05991 L
s
.56536 .06913 m
.56543 .07316 L
s
.68857 .09483 m
.68872 .09886 L
s
.74833 .1073 m
.74852 .11132 L
s
.80691 .11952 m
.80713 .12354 L
s
.30306 .01442 m
.30295 .01844 L
s
.92065 .14324 m
.92095 .14726 L
s
gsave
.62546 .00164 -66.1329 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
1 .44899 m
.6295 .64391 L
s
1 .44899 m
.99945 .44231 L
s
[(0)] 1.0011 .46237 -0.08195 -1 Mshowa
.85549 .52502 m
.85509 .51832 L
s
[(1)] .85628 .53841 -0.0592 -1 Mshowa
.73364 .58912 m
.73337 .58242 L
s
[(2)] .73418 .60253 -0.04041 -1 Mshowa
.6295 .64391 m
.62934 .6372 L
s
[(3)] .62983 .65732 -0.02464 -1 Mshowa
.125 Mabswid
.96899 .46531 m
.96868 .4613 L
s
.93909 .48104 m
.9388 .47703 L
s
.91024 .49622 m
.90997 .4922 L
s
.88239 .51087 m
.88214 .50685 L
s
.82949 .5387 m
.82927 .53468 L
s
.80434 .55193 m
.80414 .54791 L
s
.78001 .56473 m
.77982 .56071 L
s
.75645 .57712 m
.75628 .5731 L
s
.71152 .60076 m
.71138 .59673 L
s
.69008 .61204 m
.68995 .60801 L
s
.66929 .62298 m
.66916 .61895 L
s
.6491 .6336 m
.64899 .62957 L
s
gsave
.79605 .63878 -65.7531 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{215.625, 173.438},
  ImageMargins->{{60, 0}, {0, 0.25}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004=0000f1000`40O003h00Oogoo3Woo003oOol>
Ool00?moo`ioo`00ogoo3Woo003oOol>Ool00?moo`ioo`00ogoo3Woo003oOol>Ool00?moo`ioo`00
ogoo3Woo003oOol>Ool00?moo`ioo`00ogoo3Woo003oOol>Ool00?moo`ioo`00ogoo3Woo003oOol>
Ool00?moo`ioo`00ogoo3Woo003oOol>Ool0095oo`80009oo`8007Ioo`00TWoo00@007ooOol007Mo
o`00Tgoo0P00N7oo002COol2001hOol005Qoo`D003Eoo`04001oogoo001gOol005Qoo`05001oogoo
Ool0000dOol20002Ool2001fOol005Uoo`03001oogoo0;5oo`00D7oo1P0017oo00<007ooOol0/7oo
001KOol00`00Oomoo`2_Ool005aoo`03001oogoo0:ioo`00F7oo00D007ooOomoo`000;1oo`00FGoo
0`00/Goo000gOol3003COol003Ioo`80009oo`D00<ioo`00=Woo0P001goo1@00bGoo000eOol01000
Aah004LO2goo1@00a7oo000dOol01000Oom6oP0014Kn2goo00<007oo00001000_goo000dOol02`00
@_i77`00Aai2oTLO@_i77T;nAal03Woo1@00@7oo1000Mgoo000cOol01@00A_i6oTKn00001TKn0d;N
4Goo1@00>Woo00<007ooOol00Woo00<007ooOol0M7oo000bOol04P00@_i77dKnAah004LO@_i77T;n
AalngT;n?]e2oSkN@_hngA=oo`D003Eoo`03001oogoo009oo`03001oogoo07Aoo`00<Goo00<007oo
Aah00dKn00D004KnA_i6oTLN00]2gQ1oo`03001oogoo009oo`D0031oo`03001oogoo009oo`03001o
ogoo07Aoo`00<Goo01P004LOA_i77T;nAal004LN@_i77d;N@_i2gT;n?]i2oSkM@_hngT;n?]dn_SZM
?[hHOol5000[Ool00`00Oomoo`02Ool00`00Oomoo`1dOol0031oo`0300177TKn0096oP0;Aai6oP00
A_i77TKn@_i2gT;n@]i2oP05@]h01SZn>Ydj_CZm>[hjWA]oo`D002Ioo`03001oogoo009oo`03001o
ogoo07Aoo`00;goo01h004LOA_i77TKnAam6oTLN00177dKn@_i2gT;n@]i2oT;N@_i2gT;n@]hn_SZM
?[hjWCjn>Ydn_SZM?[hJOol01000Oomoogoo1@008Goo00<007ooOol00Woo00<007ooOol0M7oo000_
Ool06P00A_i77TKnAai6oTLNA_h004Kn@_i2gT;n@]i2oT;N@_i2gT;n@]hn_SZm?[hj_CZn>Yd2>[d0
13Zn>Ydj_CZm8Goo1@007Goo1000Mgoo000^Ool08P00A_i77TKnAam6oTLNA_h004KnAai2gTKn@]i2
oT;N@_i2gT;n@]i2oSZm?[hj_Cjn>[dn_SZM?[hjWCjn>YdfOC9L9Goo1@00Tgoo000]Ool00`00A_i7
7P02Aah01TKnAai6oTLN00177PI2oP0=@]i2oT;N@_hj_Cjn?[dn_SZm?[hn_Cjn>Yd00SZm00<bGC9L
<Ud00S9M97oo00<007ooOol01@00Sgoo000]Ool02P00Aai6oTLOA_i77TKnAam6oP000TKn01Y2gTKn
@]i6oT;NA_i2gTKn>[dn_SZm?[hj_Cjn>[dn_SZm?[hj_CIm<U`bOC9L=WdbG39m:goo1@00RWoo000/
Ool01@00Aai77TLNA_h00dLN00=6oTLN00002D;n00/n_CkN?[hn_SZm?[hn_Cjn>[dn_Sjm008fO@<b
G@04<U`bGC9M<Ud_Ool50025Ool002]oo`0[00177TKnAam6oTLNA_i77dKnAai6oP00@_i6oT;nA_i2
gTKn@]i6oT;N?]hn_CkN?[dngSjm?[hj_Cjn>[dfOC9m=WdbO3Im<U`bOC9L=WdbG39m<U`0;goo00<0
07ooOol01@00?7oo1@00?goo000ZOol00`00Oom77P05Aah01DKnAai77TKn00000T;n0116oT;n@_i2
oTKn@_hngSjn?]hn_CkN?[hngSjm?]hn_PPfO@03<UdbG39M008bG@03<Uaoogoo03Aoo`D003Moo`05
001oogooOol0000oOol002Yoo`090016oT/OA_i77dKnBam6oTLO0096oP0D@_h004;nA_i2oTKn@_i6
oT;n@]hn_D;N?[dngSjm?]hn_CkN?[djWP8fO@06<W`fOC9m=WdbO3Im0S9m00DbG3Im<U`Z72Gk03Yo
o`D003=oo`03001oogoo041oo`00:Goo00<007ooAah01dLN00E6oT;nA_h004Kn00=2oP05A_i2oSkN
?]i2gP04?]h01Cjm?]hn_SZM=Wd00SJM00<jWCIm=Wd01SIm00DUnbXK9O/Z72Gk03]oo`03001oogoo
00D002moo`03001oogoo03moo`00:7oo02D007ooBam6oTLOA_i;7dKnAam6oT/O@_i6oT;n0012oTKn
@_i77d;n@]hn_D;N?]e2gSjm@]hngD;N?[djWSIm>YdfOCZN=WdjW@02=Wd02c9m=WdbO3Im:Q`^?2Gk
:Q`UnbXL9O/0>Woo00<007ooOol01Goo1@00:goo00<007ooOol0?Woo000XOol00`00Aai77P07Aah0
1D;nA_i6oTKn00000dKn00A2oT;N@]i2gP<ngP04@]hngSkN?]h3>Yd00cJM>YdfO@02=Yd00cZM=Wdf
O@02=Wd02RXL:S`Z72hl9O/Z6bGk:Q`UnbXKAGoo1@009goo00<007ooOol0?Goo000WOol08P00Bam7
7T/OA_i;7dLNBam6oT/O@_i77T;nAam2oP00@_i77d;nA_hngD;n?]i2gSkM@_hngD;N?[e2gSZM>[hf
WCZn0SZM018fOCZN=WdjWCIm>YhZ72hl:Q/^?2XL;S`UnbXL9O/Z72Gk:Qa6Ool00`00Ool00004000O
Ool01@00Oomoogoo0000?goo000VOol00`00Aai77P08Aah2A_h01dLNA_i6oP00A_i2oTKn0092gP05
?]i2gT;N@]hngP03@]h8>Yd013Im=YdfWCZM0Rhl00`Z72hl:Q`Z?2XL;S`Z72XK9O/Z72Gk:Q]<Ool5
000KOol30010Ool002Ioo`0900177T/OAai;7dLNBam6oT/O00977P0R@_i77d;nAai2oP00@_i77SkM
@_hngT;N?]e2oSkN@]hngD;n>Ydn_SJM>[hjWCZn=Ydj_SZM>[hfWC9M;S`^GBhl<Ud2;S`02RXK;S`Z
72hl:Q/Z72Gk:Q`UnbXLD7oo1@00FGoo000UOol00`00Aai77P07Aah2A_h02dLNA_i6oTKnAah004Kn
@]i2oT;N@_h00T;N00TngT;N@]i2gSZm>[hj_Cjn>[d01SZM00DbGC9L;S`^?2iL00@^?00::Q`Z?2XL
;S`Z72XK9O/Z71VJ7KYAOol00`00Oomoo`05001DOol002Aoo`0900177T/OAai;7dLNBam77T/O0097
7P08@_i77dKnAai2oTLO@_h00092oP0L@]i2oSkN@_i2gT;n?]i2oSZM?[hjWCjn>Ydn_SZM?[hjWCZn
=YdbOC9L<Wd^G39m;S`^GBhl<Ud2;S`02RXK;S`Z72hl:Q/M^QVJ7KXIVAfjF7oo1@00Cgoo000SOol0
1@00Oom77TLNBah01TLN01=6oTLNA_i77TKnAai6oTLN0012oT;N@_i2gT;n@]i2oT;N@_hn_@03?[h0
2CZm>[hj_Cjn>[dj_SZm<UdbG003<Ud0139L<Ud^?2iL0bhl00/^G2XL:S`Z727K7MXM^QVJ7KXIVQfj
05aoo`D004Yoo`008goo02P004/OAai;7dLNBam77T/OAai;7d;nAam6oTLN@_i77dKnAai2oP00@]i2
oSkN@_i2gT;n?]i2oT;N?]hj_CkN>[dngSZM?[hjWCjn>YdfO@8bO@0@;U`bOC9L<Wd^G39m;S`^GBhl
<Ud^?2iM7KXQfafj8M/27KX011VJ7KXIVAfjG7oo00@007ooOomoo`D004Eoo`008Woo00@007ooAai;
7P=77P03Bai77TLN00977P09A_i77TKnAai6oTLNA_i2oP0000E2oP03@]i2oT;N00<n_P09?[dn_Sjn
?[hn_CZn>[dn_S9m00<fO@05<U`bGC9M<UdbG002<Ud00biL;S`^?0029O/02AgJ8M/Mfb7K7MXM^QVJ
7KXIVP1UOol50010Ool0025oo`0B001oodLNBam77T/OAai;7dLNBam6oTLOA_i77TKnAam6oTLN0TKn
02Y2gP00@]i6oT;N@_i2gTKn@]hngSZm?]hj_CkN>[dngSZm?]hj_CkN<WdfOC9l=WdbOCIm<W`bOC9L
<Wd^G39m<U`Uo27K9O`QnbGl7KXQfafj8M/27KX00aVJ7KXIV@1XOol6000kOol0025oo`0300177T/N
00=77P03Bai77TLN00977P05A_i77TLNAai6oP02Aah014Kn@_i2oP001T;n0ckN00Dn_Cjn?[hn_Sjm
00<n_P05=WdfWCIm=WdbO@03=Wd02C9m<UdbGC9M<U`Z72HL9O/Qn`039O/02AgJ8M/Mfb7K7MXM^QVJ
7KXIVP1WOol00`00Oomoo`02Ool5000gOol0021oo`0[00177T/oAai;7dLNBcm77T/OA_i77dKnAai6
oTLOA_i77TKnAam2oTKn@]h004;nA_i2gTKn@_hngSjm@]hn_CkN?[e2gSZm?]hj_CkN=WdfWCIm>Yh0
0SIm01@bO3Im<WdfOC9l=WdV6bXL9Q/Z72HK9O`QfbGl8O/Uo1fj8M/M^R7K0Qfj00<IVQfj6IT0IWoo
00<007ooOol01goo1@00<Woo000OOol00`00Aai;7P03Aah00d/NAai77P0:Aah3@_h01TKn0012oT;n
A_i2oP8ngP03@]hn_SkN008ngP05?[hngSkN?]hfO@03=Yd01CIm=YdfWCJM<Wd00cIm0RXl00LV72XL
9Q`Z72HL9O/Qn`039O/02AgJ8M/Mfb7K7MXM^QVJ7KXIVP1cOol6000]Ool001moo`19001;?dLNBam7
7T/oAai;7dLNAam6oTLNA_i77dKnAai6oTLO@_i6oT;nA_i2oP00@]i6oT;n@]hngD;N?]i2gSkM@]hn
_CkN?[e2gSJM>[hfOCZN=WdfWCIm>YhfOCJM=Wd^?BXl;S`Z?2hm9Q/Z72HK:Q`V6bXL8M/Uo27k9O`M
^R7K7KXQfafj4ET=>0eI3CP0LWoo00<007ooOol00goo1@00:7oo000NOol00`00Bai77P02Aah01D/N
Aai77TLNBah024LN00U2oTKn@_i6oT;nA_h004Kn@_h00SkN00E2gSkN?]hngT;N00<ngP06>YhjWCZM
>YdjWSZM0cJM00DfOCJM=Yd^GBiL008Z?00:;S`Z?2Xl9Q`Z72HL:Q`V72XL8O/39O/34GT01AEi4GT=
F0dh3ET0OGoo0`009Goo000MOol06P00Bcm77T/OAai;?dLNBam77T/oA_i77dKnBam6oTLOA_i;7d;n
A_i2oTLO@_i6oT;n0002@_h0;3kM@_hngT;N?]e2gSkN@]hngCjn>Ydj_SJM>[hfWCZn=Ydj_SIm=Ydf
OC9M;U`bGBhl<UdZ?2hl:S`^?BXl:Q`V6bXL9Q/Z71FJ6KXEVQVj4ETENQ5i5GX24ET00`dh3EUoo`1k
Ool30004Ool5000LOol001aoo`06001;7TLNBai77T/N0dLN00=;7TLNAah01TLN00Y2oTKnA_i6oT;n
A_i2oTKn0016oP92gP04?]i2gT;N@]h3?]h01D;N>[dj_SZm>[h00cZM00HjWSZM>YdjWBiM;U`3;Ud0
12iL;UdZ?2hl0bXl00<Z72HL:Q`00QgK00@EVQVJ6IXI^P<AN@055GT=>0eH3CP=F@1jOol40006Ool0
0`00Oomoo`0LOol001aoo`1?00177T/OAai;?dLNBam77T/oAai77dKnBam6oTLOA_i;7dKnAai2oTLO
@_i77T;nAal004LN?]e2oSkN@_hngD;n?]i2oSkM@_hjWCZn>Ydn_SZM>[hjWCZn=Ydj_SJM<WdbGC9m
;S`bGBiL<Ud^?39M:S`^?2Xl;SdZ?1gK6KXMfafj7M/EVQVj5IXI^Q5I5GXANAEj3CPAF@dh3ET0J7oo
01DoOD>N?ie3WSmm@ii7OT]oAgi;OdMnBgm7GT]OAei;GdMNBem7GT]O00001Woo00<007ooOol077oo
000KOol02@00Aai;7TLNBai77T/NAai;7P09Aah3A_h024;nA_i6oTKn@_h004;N@_h4@]h01CkN@]i2
gT;N>[d00Sjn00Lj_SZm>[hj_CZn>[dj_P02<Wd01C9M<WdbOC9m<Ud00biM00@^G2iM;UdQo0<Qn`03
7M/M^agK008Mf`045IXIVQVJ6KX34GT011Ei3CP=F0dhIWoo00H_F4>M@ii3WD>N@id6Agl9Bel00goo
001oo`05Ool00`00Oomoo`0LOol001Yoo`0A00177T/oAai;?dLNBam77T/oAai;7dKnBam77T/OA_i;
7`02Aah07T;nAam2oTLN@_i77d;nAah004;n@]i2oSkN@_hngT;n?]e2oSZm?]hj_CkN>[dngSZM?[hj
WCZn<WdfWP8bO@09<U`bOC9M<WdbG39m;U`bGBhl008V700D8O`Qfb7l8O/MfaVj7M/M^QgK5IXI^QFJ
6KXAFAEj4GTENPdh4ET=>65oo`0G;cL_F2lg@ihoOD>N?ie3WSmmBgm7OT]oAgi;OdMnBem7GT]OAei;
GdMNBem7GP02Ool20006Ool00`00Oomoo`0LOol001Yoo`08001;7TLNBai77T/NAai;7PY77P0CA_i7
7TKnAai6oTLNA_i77T;N0012gT;n@]i2oT;N@_i2gT;n>[d00cjn00Tj_Cjn?[hn_SZm?[hfOCJM<Wd0
0SIm00<fWC9M<Wd00S9m00<bGC9m<Wd012HL00HQo27k8O/QnagK7K/37M/011FJ6IXIVQVj0a5i00@=
F@dh3EP=>5ioo`04000_F2mH;eL6@ih01T]oAgm7OdMoBgm7O`Q;G`Aoo`03001oogoo00Aoo`03001o
ogoo01aoo`006Goo03H004/oAai;?dLNBcm77T/oAai;7dLNBam77T/OAai;7dLNBam2oTLO@_i77T;n
Aam2oTLN@]i6oP00@_hngT;n@]i2oSkN@_hn_CkN>[dngSZm?]hj_CkN>[dngSJM>YhbOCJM<WdfWS9m
=Yd2<Wd01c9M<WdbG2Xm:S`V72HK008V700D8O`Qfb7l8O/Qo1Vj7M/M^QgK5IXI^QFJ6KXAFAEj4GT=
F@dh4ET=>5]oo`0I000gNS=J=gY3OTNN@gi7WT=nAii7GT]oAei;OdMNBgm7GT]OAci;GdMNBem7?T]O
Aeh01Goo0P000goo0`007Woo000HOol02P00Bai77T/NAai;7TLNBai77T/N2TLN00M6oTLNA_i77TKn
Aai6oP02@_h02000@_i2oT;N@_i2gT;n?[h3?]h023jn?]hn_Sjn>[dn_SJM=Yh4=Yd0239m=WdfOCJM
<WdfOBXl:Sd3:S`59Q`38O/00b7l7K/Mf`027M/011FJ6IXIVQVj0a5i00<=F@dh3EP0FWoo0cMj1T>N
0TMo00E;OdMoAgm7Od]o00Q;G`Ioo`<000Eoo`03001oogoo01aoo`0067oo048004LNBcm77T/oAai;
?dLNBcm77T/OAai;7dLNBam77T/O@_i77dKnAai2oTLOA_i77T;nA_i2gT;n0016oT;N@_i2gTKn?[dn
gSZm?]hn_CkN>[dngSjm?]hfWCZN=YdjWSJM>YhfWCZN<WdfWS9m=YdZ?2iM:S`Z?BXl:SdZ?2HL9Q/3
9Q`04R7K8O`Qnb7l6KXMfafj7M/9F@eI2ET=F@DG1CP560Cg0=H4meMoo`0H=gXcNSMj>g]7Wd=nAim3
OTNOAei;OdMNBgm7GT]oAei;OdLnBem7?T]OAci;GdLn2Woo00<007ooOol08Woo000GOol02`00Aai;
7TLNBai77T/NAai;7TLNBah00dLN00=;7TLNAah00TLN00E6oTLNAai77TKn00977P05A_i2oT;n@_h0
0004@_h4?]h02Cjn?]hngSkN?[hngSZM>[hjW@02=Yd01SJN=YdfWCJM=YhfW@H^G@05:SdZ?2Xl:S`Z
?@049Q`38O/01B7l4GXAVQ5j4IX00`UI00<=F@DH1AP00P3g00<0e`3gOol0Dgoo01<803^L>g`kW4Mn
Aim3OTNNAgi;OdMOBgm7Gd]oAem;OdMOBem;?P03Bel00d/nBemoo`0;Ool00`00Oomoo`0ROol001Io
o`0i00177T/oAai;?dLNBcm77T/oAai;7dLNBam77T/OAai;7dKnAam6oTLN@_i77dKnAai2oTLO@_i6
oT;nA_l004Kn@_i6ockN@]hngD;N?]i2gSkM@]hngT;N=Ydj_SJM>[hfWCZn=YdjWSJM>YhfWC9m008^
G@0;;U`^GBXl;Ud^G2Xm:S`Z?BXl:SdV6`039Q`04AFj6K/E^QVk3GTAVQ5j4IX9F@eI2ET5>0DG1CP0
ePCg0=H0DWoo01P<00P0>i`kNc^LAgi7WdMnAim7OT]oAei;OdMNBgm7GT]oAei;GdLnBem7?T]OAch=
Ool2000TOol001Eoo`04001ood/NAah3Bah014LNBai77T/N0dLN00=;7TLNAah00TLN00E6oTLNAai7
7TKn00=77P=2oP06A_i2oP00@_i6oSkN0T;N1ckN0SZn00TjWCZn>Ydj_SZM>[hjWCZn;Wd00c9m00<^
OC9m;Ud012iM00HZ?BXl:S`Z?2Xm6M/27M/00agl5KXE^`025K/0115j4IXANQ6J0`UI00<5>0DH1AP0
0P3g00<0egooOol0Bgoo0`000PP00SnM0TMo00I7WdMnAgm;Gd]oAel2Bel00d]oAem;G`02Bel01D/n
Bem;?d]OBch03goo00<007ooOol08Woo000EOol08P00Bcm77T/oAai;?dLNBcm77T/oAai;7dLNBcm7
7T/OAai77dKnAai6oTLOA_i77TKnAam2oTLN@_i6od;nA_h004Ko0T;n03TngT;n?]i2oSkM@]hngT;N
>[dn_SZm?[hj_CZn=Ydj_SJM>[hbOCJN;UdbOBiM<Wd^GC9m;U`^GBXl;Ud^G2iM7O`R71gl8Q`Ifagl
6M/Mo1Fj6K/E^QVk3GTAVQ5j4IX9F@eI2ET5>0DG1CP0ePCg0=H0BWoo100001L<00P0?ie7OTNOAgi7
WdMnAim7GT]oAei;OdMNBgm7GT]oAci;GdLnBem7?T]O015oo`03001oogoo029oo`0057oo00<004/n
Aah00T/N00=;?TLNBah00T/N0dLN00=;7TLNAah01TLN00e6oTLNAai77T;nA_i2oTKn@_i6oT;n0012
oP03@]h01SkN@]i2gT;N?]i2gPPj_P06>Ydj_SZM<YdbOCJM139m00<^OC9m;Ud00biM00<V?2Hm8O`0
0b8L00DIfagK7M/Mo1Fj00<E^`044GXAVQ5j3ET32ET00`Dh1AP0m`020?M8Ool4000320000d>NAgm7
O`04Agl2Bel034MOBem;Gd]OAem;Gd/oBem;?T]OBcm;Ga9oo`03001oogoo029oo`004goo04P007oo
Aai;?dLNBcm77T/oAai;?dLNBam77T/oAai;7dLNBcm6oTLOA_i;7dKnAam6oT/O@_i77T;nAam2oTLN
@_i77`00@_hngT;n?]i2oSkN@_hngT;n>[dngSZm?[hj_Cjn>[dn_SZm?[hj_CJN<WdfWS9m=YhbOCJN
;UdbOBiM<Wd^GBHm8Q`V?BHL9Sd28Q`05Qgl8Q`Ifagl6M/Mo1WK6K/E^QVk3GTAVQ5j3ET9F@eI2ET5
>0DG1?L0ePCgAGoo1@0001P800`0201;WdMnAgm7OT^OAgi;GdMNBgm7GT]OAei;OdMNBem7?T]OAci;
GdLnBelBOol2000TOol001=oo`0600177T/NBai;?TLN0T/N00U;?TLNBai77T/NAai;7TLNBah024LN
01E2oTKnA_i6oT;nA_i2oTKn@_h004;N@_i2gT;n@]i2oT;N@_hn_SkN>[h00Sjn00<ngSZn>[h00cZn
00XfWSJM=YhbOC:M<WdfWC9m<YdbO@@ZG@069SdV?2Hm9S`V?BHl0b8L00DQo1gK7M/Mo1WK00<E^`04
4GXAVQ5j3ET22ET00`DH1CP560030?M2Ool6000370<6Agl3Bel01DMOBem;Gd]OBch00T/o00A;Gd/n
Bcm;?aEoo`03001oogoo029oo`004Woo024004LNBcm77T/oAai;?dLNBcm77T/OAai;?dLNBam77T/o
Aai77dKnBam77TLOA_i;7d;nAai2oTLO@_i77T;nAal00T;n00T004;n@]i2oSkN@_i2gT;n?[d00ckN
01`j_CkN>[dngSZm?]hfWCJN=Ydf_SJM=YhfWCJN<WdfWS9m;Wh^GBYM:S`ZGBXm:UdR72Hm9Q`V?@8R
700E7O`R71gl7O`Ifagl6M/I^aFj6K/=NA6J4GX=F@UI3ET560Dh1AL4m`3F041oo`0N400<0100504H
0A@1604H0a`460=;OdMNBgm7GT]oAei;GdMNBem7GT]OAei;GdLnBem7?T]OAci;GdLn5Woo00<007oo
Ool00Woo1@0017oo0P0017oo1@0017oo100017oo000AOol01P00Oom;7T/NBci77P9;7P09Bci77T/N
Aai;7TLNBai77T/N00Q77P05A_i77TKnAai2oP02A_h02dLN@_i2oT;n0012gT;n@]i2oT;N@_h01SkN
01@j_Sjn?[hngSJM>[hf_SJN=YdfWSJM=YhfWCJN=Yd^OBiM;Wd^GBim1BYM00DV?BHl9SdV?2Hm008R
70038O`A^a6k008A^`032IX9NPVJ00<5F@<160031AP5>03G0080mceoo`04100<00`04004504370<5
Agl01DMOBem;Gd]OAel00T]O00=;?d/nBcl00T/o00=;?T/oBcl05Woo0P001Woo00<007ooOol017oo
0P0017oo00D007ooOomoo`0000=oo`03001oogoo009oo`03001oogoo005oo`004Goo01P004/oAai;
?dLNBcm77T/oAai;7dLNBcm77T/OAai;?dLNBam77T/OAai77dKnBal2Aah01T;nAam2oTLN@_i77`92
oP09@]i2oP00@_i2gT;n@]i2oSjm00<ngP0B?[dngSkN?]hn_CkN=Ydj_SJM>[hfWCZn=Ydf_SJM=Yhf
WC:N0Rim02<ZGBin;Ud^OBXl:UdZ?BYM:S`ZGAXL7QdIo1hM5M/Io1GK4M/=^a6k3K/9V`Uj2IX5>@EI
1CT1603g0AP0]P3G0=H4m`3F03Yoo`0O200<0100300@01@1604D0AP160<L11P370A7GT]oAei;OdLn
Bem7?T]OAci;GdLnBem7?T]OAci;GdLnBel06Goo00<007ooOol017oo00<007ooOol02goo00<007oo
Ool02Goo00<007ooOol00Goo000@Ool01@00Bai;7T/nAah00T/N00U;?TLNBai77T/NAai;7TLNBah0
2TLN00M6oTLNA_i77TKnAai6oP04@_h00`00@_i2oP02@_h00ckN@]hngP07?]h4>[h02CJM>[hf_SZn
=Ydj_S9m<Yh^O@02<Wd01C:N;Ud^OBiM;Wd012YM0R8m00LN71hM7Q`N71Gl6O`Eg0044K/00`VJ2GX9
VP031ET30AP0103F0=L0U@3g=Woo0`0000@400`0300<00@D0@0670@L0a`370<L14MO0TMo24]O00M;
?d/nBcm;?T/oBci;?`0JOol00`00Oomoo`04Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomo
o`01Ool000moo`0H001;?dLNBcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/OAai;7dLNBam77T/O
0TLN04i2oTLO@_i77T;nAam2oTLN@_i6od;nA_h004Ko@_i6oSkN@_hngT;N?]i2oSkN@]hngS[N>[dj
_SZm>]hj_CZn=Ydj_SJM>[hbWCJN;WdbWRim<Yh^OC:N;Wd^ORiM;WdZGBHm8S`R?B8l9SdR?1hM6O`N
7AGK6O`Efa7K3K/A^`fk2I/9NPVJ2GX5F@Di0AP0m`3G0;H0U@1e09HcOol300007`@0200<0100300H
0A@1604D0A`460<L11P370A7GT]oAei;GdLnBem7?T]OAci;GdLnBem7?T]OAci;GdLn01]oo`<000Eo
o`03001oogoo00eoo`03001oogoo00=oo`@000Aoo`003Woo00@004/NBai;?P=;7P09Bci;7T/NAai;
7TLNBai77T/N00=77P03Bai77TLN00I77P06A_i77TLNAai6oTLN1D;n00D004;n@_i2gT;n00<ngP03
@]hngSkN008ngP03>[hngSZn00Lj_P03<YhfWS:M00<bWP06;WdbOC9m<Yh^OC9m0bIM1R8m00LN7AhL
7Q`N71Wl5M`Eo0034K/01@VJ2GX9VPUj1ET00`4H00<0e`3F09D00P2E<7oo0`000P@000@@00`0300<
00@D0@0:70@L0a`370<L14MOBem7Gd]OBch3Bel024/nBem;?T/oBci;?d/nBclOOol00`00Oomoo`03
Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool00`00Oomoo`05Ool000ioo`0Y00177T/oAai;?dLNBcm7
7T/oAai;?dLNBcm77T/oAai;?dLNBam77T/OAai;7dLNBam2oTLOA_i77T;nAam6oTLN@_i77d;nA_i2
oTKo0016oP02@_h01SkN@_hngT;n?]i2oP8ngP04>[hngSZm?]h2>[h0<CZm>]hj_CZn=Ydf_SJM=Yhb
WCJN<YdfWRim<Yh^OC:N:Ud^ORIM:UdVGBYn8S`R?B8l9SdR?1hM6O`N7AXL6O`EfaWl3K/A^`fk2I/9
NPVJ2GX5F@3h0AP0m`3G0;H0U@1e02eoo`@00003500H01@000<L0P0J704T1B0490DP12P790HX1b@6
:0M7GT]oAci;GdLnBem7?T]OAci;?dLnBem7?T/oAci;Gb1oo`04001oogooOol3000<Ool01@00Oomo
ogoo000017oo00<007ooOol01Goo000=Ool00`00Bai;?P03Bah03D/nBai;7TLNBai77T/NAai;7TLN
Bai77T/N00=77P03Bai77TLN00Q77P08@_i6oT;nA_i2oTKn@_h00092oP07?]i2oT;N@_hngT;n@]h0
0ckN00Lj_SkN>[hngSZn?]hj_P03=[h01CJN=[hf_SJn<Yd00S:N00PfWS:M:WhZOBYn:WdZORYm12IM
1B8m0ahL00<Io1GL5O`00a6k00D9VPUj2IX9NPEI00<160040=L0eP2E09DYOol2100330001100500D
01@011`200HT1B0480DP12P790H290L00bP7Aem;G`02Bel02d/nBem;Gd]OBci;?d/nBcm;?T/oBch0
8Goo0P001Goo00<007ooOol02goo0`001Goo1@000goo000<Ool0<@00Aai;?dLNBcm77T/oAai;?dLN
Bcm77T/oAai;?dLNBcm77T/oAai;7dLNBcm77T/OA_i77dKnAam6oTLOA_i77d;nAam2oTLN@_i77d;n
Aah004;o@]i2oSkN@_hngT;n00@ngP06>[hngSkN?]hj_CkN0SZn01Xf_C[N=Ydf_SJM=[hfWCJn=Ydb
WRim<Yh^OC:N:Wd^ORYM;WhZOBin9UdZORIM:UdJ?1hm0QXm01DAo1HM4O`=g0WK3M`5VPFk1IX1NP5I
0EX1F@EI0?P1602f0=L0M@2E07D09Woo00X000@0400<0100300H01@0600D00<L0P0I704T1B0490DP
12P790HX1b@6:0LT1T]OAci;GdLnBem7?T]OAci;?dLnBem7?T/oAch08goo00<007ooOol08Goo000<
Ool00`00Bci;7P02Bah01T/nBai;7T/NBci77P9;7P05Bci77T/NAai;7P03Aah00d/NAai77P08Aah0
0dKnAai2oP02A_h01DLN@_i6oT;n00001d;n2SkN0cZn00Df_SZn>[hf_SJN008f_P03<[hbWS:N00D^
WP06:WhZOBYn:WdZORYm0R9M00<RGQXm6Sd00aXm0Q8L00LF7@WK2M`9f`FK1IX5V`030ET30AP0103F
0=L0U@2E97oo00@000@0100@00<<0003600D01@000@L0P0780@T1B0480DP12@590H00R@7010X1b@6
Bem;?d]OBci;Gd/oBem;?T/oBci;?d/nBcm;?RAoo`03001oogoo025oo`002goo03D004/oAai;?dLN
Bcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/OAai;?dLNBam77T/OAai77dKnBam77TLO@_i77d;n
Aai2oTLO@_i77T;NA_l004;n?]i2od;N@_hngT;n?]i2oSZn00<ngP0B>[hngSkN>]hj_SkN=[hj_SJm
>]hf_SZn=[db_S:N<[hbWC:n0S:N00h^OC:N;WdbWRim9YhVOBIn8WdVWQiM8UhNGAhm0QXm01@J?1hm
4O`F7A7l3M`9f`gL1IX5^`5I0EX1F@4H0;H0eP2f0=L0M@2E87oo0P000P@000T<0100300@01@0600D
01P070400a`201TP12@580@T1B0490DT1RP790HX1b@6Bem7?T]OAci;GdLnBem7?T/oAci;GdLnBcm7
?P0UOol00`00Oomoo`0QOol000Yoo`03001;?T/N009;7P06Bci;7T/NBai;?TLN0T/N00=;?TLNBah0
0T/N0dLN00=;7TLNAah024LN00Q6oTLNA_i77TKnAai6oTLN0d;n00<004;n@_h00d;n2CkN00Hj_S[N
>[hjgSZn>]h2>[h00cJn>[hj_P03=[h00c:N<[hbWP02<Yh00c:n<YhZWP04:Yh59Wh00b9N7UdRG@05
6Sd01aHM4O`B70WK3M`5VPFK00<1F@050AP0]P3F0=H0e`0209DKOol400000a@0400D0002700011P0
700P0B020R0111`200LP12@580@P1B0490DT1P0290L01RP790HT1d/oBem;?P=;?`07Bci;?d/nBcm;
?T/oBch09Goo0P008goo000:Ool0;@00Aai;?dLNBcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/O
Aai;?dLNBam77T/OAai;7dKnBam77T/O@_i77d;nAai2oTLO@_i77T;nAam2oP00@]i6o`02@_h06T;N
@_lngT;n?]i2oSkN@_hngT;n>]hngSZn?]hj_S[N>[hngSZn>]hbWSJn<[hf_S:N=[h2<[h01S:M<[hb
WRjn;Yhb_`8ZWP0O:Wh^WRZN9WhROBJN9WdVOR9m8WhNGA9M3S`BG@hl2Q`5n`XL1O/1f`6j1K/5VP5J
0ET1602f0=H0E02F07D067oo0P000`P002P@01@0400L01P0700H02@2804T0R01908T12P590@X12P6
;2LX1R@580@T1B@6:0LT1RP790HX1dLnBem7?T]OAci;?dLnBcm7?T/oAci;?bQoo`03001oogoo025o
o`002Goo00X004/NBci;7T/nBai;?T/NBci77P9;7P03Bci77T/N009;7P06Aai;7TLNBai77T/N2TLN
00I6oTLNA_i77TKnAah2A_h2@_h00`00A_i2oP03@_h053kN@_hngT;n?]i2oSkN@_hjgSkN>]hngS[N
?]hj_S[N>[hjgSJn>]h9=[h3;[h00bjN;[h^_P06:Yh01b:N7YhRWQjN8YhJOAYn00<B?@084Ud670HL
1Q`:707J0IT1N@81F@8160040=H0M02E09DDOol30003200011@0400D01P00a`000@H0201804P0P8P
0@8X100990@X12`6;2L/1R`V;0H/9b@6008T1`03:0LT1R@7009;?`09Bci;?d/nBcm;?T/oBci;?d/n
02Yoo`03001oogoo025oo`0027oo070007ooBcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/oAai;
7dLNBcm77T/OAai;7dLNBam6oT/OAai;7dKnAam6oTLO@_i77dKnAam2oTLO@_i6oT;n0012oTKn@_i2
ockN@_hngT;o?]i2oSkN@_lngSkn>]hngc[N?]hj_SkO>]hngSJn>]lf_S[N=[hjgcJn>]hf_S;O<[hb
_bjn<]l^WRjn;Yhb_bjN;[h^WRJo9YhV_bJN9[lNOR:N7WdRWQin6WhFGA9M3S`BG@hl2Q`5n`XL1O/1
f`5i0CL15P8160040=H0E02F07D@Ool300042000:A00500@01`0600L01P0700H02@2804T0R01:0@T
12P590@X12P6;2LX1R`W:0H/9b`X<2P/:2P790HX1b@6Bem7?T]OAci;?dLnBcm7?T/oAch0:Woo0P00
8goo0007Ool02P00Oom;?T/NBci;7T/nBai;?TLN0T/N00=;?TLNBah00T/N00Q77T/NAai;7TLNBai7
7T/N24LN00E6oTLNAai77TKn00977P07A_i2oTKn@_i6oP00A_h02D;n2CkN1C[N0SJn00LjgSJn=[hf
_SKO=[hfgP07<[h2:[h00bZo:[hZ_P029[h022JN9[hV_R:N7YhRWQjN8Yh36Wd01A9M4SdB?@HL2Q`0
0PHL00D1fP6I0CL0e04H0080M003039oogoo00Yoo`8000<80004500@01@040047005900380400b02
804X1002:0@06B@4:0@X12`W;0H/9R`6;2L/:30X;2P`:2`X<2P/:4/oBci;?d/nBcm;?T/oBci;?d/n
02aoo`03001oogoo025oo`001goo030004/oAai;?dLNBcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm7
7T/oAai;?dLNBcm77T/OAai;7dLNBam77TLOA_i77dKnAam6oTLOA_i77d;nAai2oTLO@_h004;n@_l2
@_h0ASkN@_lngT;n?]i2ockN@_hjgSko?]hnoS[N?_ljgSko>]hjgc[N>]lf_S[O>]hjgc:n=]lb_SKO
<[hfgc:n<[l^_S;O<[hbgbjn<]lZ_RkO:[h^gbZn9[lVWRJo9YhV_aZM6[hJWAZn6YdBW@il4Yd6>PYK
1S/26@7i0QT1n@6g0GP1=`2d07@0E00c1Goo0`0000X400P0100D0100500@01@0400D00@L00HT000Q
:08/0RP2;08X0RP490@X1B@4:0@T12`W:0H/9bP6;2L/:30X;2P`BB`X<2P/:4]OAci;?dLNBcm;?T/o
Aai;?d/n02eoo`03001oogoo025oo`001Woo00P004/nBai;?T/NBci;7T/n0d/N00e;?TLNBai;7T/n
Aai;7TLNBai77T/NAai;7P03Aah00d/NAai77P0:Aah01d;nAai2oTKn@_i6oP0000Q2oP09?_hngSkn
?]hnoSkN?_hngSkn00<jgP03?]hjgS[N00@jgP03=]hjgcKN008fgP0==]lf_SKN=]hfgcJn;]l^gRkO
;]h^gbkN:[l00bZn00<Z_bZn8]h00R;N00HR_R;N8]hRgR:n8]h36[d00a:L4W`BW@031U/0108I0OTL
003D0P1d00@0<PP0200800/H00DL00HT0003;08X0R`2008/0P05:08`1C05<2DT1002:0@03B`W;0H/
9R`6;2L/1S0X;2P`:2`X<2P/:4/o00=;?P05Bcm;?T/nBci;?`0^Ool20005Ool50004Ool20005Ool4
000:Ool000Eoo`0`001;?dLNBcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/o
Aai;7dLNBam77T/OAai;7dLNAam6oT/OAai77dKnAam2oTLO@_i77d;nAam2oP000d;n04Q2od;n@_i2
oT;o?]i2ockN@_lngT;n?]i2oc[N?_ljgSko>]hnoc[N?_ljgSko=]hjocKN>]lfgS[o=]hjgcKN=_lb
gS;o<]hfobkN<]l^_S;O;]hbgbjn:_lVgR[o9]hZobKN:_lVgR[o7]`NoAkL8_dNg1km7]`RoAkL7_dB
^1KI4[PFfA:h5]T0]01d038760002B00900P02@0800T0200900P000790008BP2;08X0R`2:08/0S04
<2D/130U<0@`9B`4;2LX1R`W:0H/9bP6<2P/:319;2P`:2`X<4U;?T/oAai;?d/nBcm77P0aOol20006
Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`07Ool000Eoo`07001;7T/nBai;
?T/NBch00d/N00e;?T/NBai;7T/nAai;7TLNBai77T/NAai;7P03Aah00d/NAai77P0:Aah02DKnAai6
oTLN@_i77TKn@_h00007@_h01Ckn@_i2oT;n?_h00d;n00dngSkn?]hnoSkN?_hngSkn>]hjgc[N>_lj
gP02=]h02S[O=]hfgSKN=_lfgSKo<]lboc;N0S;O00<boc;N;_l00Rko00T^oRko;_l^obkn;_lVoRLN
9_d00RKn00DW7RKm9_hVoRLN00HNn`8[?005:c/[?2mL07@0<P02;007900;;003;0801BP2;08/0R`2
<0@00S0500@`9C04<0D`1@<d9`0:;0H/9b`6<2P/:30X;2P`:2`X<2P3Bch014/oBci;?T/n<goo00<0
07ooOol017oo00<007ooOol03goo00<007ooOol01goo0004Ool0N000Aai;?dLNBcm77T/oAai;?dLN
Bcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/OAai;?dLNBam77T/OAai77dKnBam77TLOA_i;7d;n
Aam2oTLO@_i77d;nAam2oP00@_i77d;nAam2oT;o@_i2ockN@_lngT;o?]i2ockN?_lngSko>]hnoc[N
?_ljgSko>]hjoc[N>_lfgS[o>]hjoc;N=_lfgSKo<]hfocKN=_lbgS<O<_hc7bkn<alboS<O;_hc7c;n
;ahZoRlO:ah_7R[n;al[7RlN9a`W?BLL9adW72Lm;cdcGBll<ed_?@8cG@0>=gdcG@1d038/02P0;00`
03@0<00d0300=00`00L/008d0@0P<04d0BP2;08X0R`2<0@`9B`4<2D`130U;0@dAc@V=2L`9SA7=2H`
:2`X<4T/:30X;2P`BD/nBcm77T/oBci;?cEoo`03001oogoo00Aoo`03001oogoo00ioo`800003Ool0
000000Ioo`0017oo00H004/nBai;?T/NBch3Bah01D/nBai;7T/NBch014/N00A77T/NBai;7P=77P05
Bai77TLNAai;7P08Aah01DKnAai77TLNA_h00dLN0T;n00<004;n@_h02T;n00Dnockn?_hnoSko00<n
oP0:?_ljoS[o>_hnoc[n>_ljoSko>_h3>_l4=_l01CKN=_lfocLO=_l00cLO00dfocLO=alc?c<N<alc
7S<o<ahc7c<N<cl[?@02;cd01Rln:cd_?Blm;ed_?@<_G@06;cdkOS]n>ghgGS]n0Smn00<0DCP0>000
0SP01c002c@100H`9C04<0D`1C0U<0@2<0D6=2L01cQY>6P`:2`X<2P/:30X00=;?P03Bcm;?T/n03Eo
o`8000Ioo`03001oogoo00]oo`@00003Ool0000000Moo`0017oo07d004LNBcm77T/oAai;?dLNBcm7
7T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/OAai;?dLNBam77T/oAai77dKnBam77TLOA_i;7dKnAam2
oTLOA_i77d;nAam2oTLO@_h004;nAam2oTLO@_i2ockn@_m2oT;o?_i2ockn@_lngT;o?]hnockN@_lj
oSko>_hnoc[N?_ljgSko>]hk7c[n?alfoS[o=_hjocKn>_lfoSLO<_lg7c;o=albocLO<_lg?c<N=clc
7SLo<ahg?bln<elc?S=N;chcGc<n<eh_?SMN<edgGS=M>ghgGC]n=edkOSMM?ghkOSmo008oOP030558
03P0008h0008?00h03`0>00l03P0?00`0@<d0@0O<04d0C@1=04h8c`T>2<`9B`4<2D`130U<2HdAc@V
=2L`9SA7=2HhJCA8>6TdB30X;2P`BB`XBcm77T/oBch0>7oo00<007ooOol017oo00<007ooOol02goo
00<007oo00000goo00<007ooOol01Goo0004Ool00`00Oomoo`03Ool00d/NBci;7P02Bah01T/nBai;
7T/NBci77P9;7P05Bci77TLNAai;7P03Aah00d/NAai77P0>Aah01D;nAai2oTLN00000T;n00=77T;n
@_h01D;n0152ockn@_hnoT;o?_i2oSkn@_lnoSko?_hnockn?_lnoSko00Tjo`8g7`05>alg7cLO=alk
7`03=al08SLo<alg?cLO=clc7cLo=chgGcLn=clg?SMO=chg?cMN>ehgGS]N=ehoOS]N?ghkOSmn>ei3
Ocmn@gloOT=o?gh0<P1A0T@00SP00c`000Dh03`0?00l03P000@d0@Lh8`03<0@`1C@W00Hd9`08>6Th
J3QY=6PhJCQX<2P/:09;?P03Bcm;?Woo03Qoo`03001oogoo009oo`<000eoo`03001oo`0000=oo`03
001oogoo00Eoo`0017oo00<007ooOol02Woo02=77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/oAai;
7dLNBam77T/OAai;7dKnAam6oTLOA_i77dKnAam2oTLO@_i77d;n00@0000P@am2oT<O@_i37d;n@aln
oT<O?_i2ockn@_lnoT;o?_i37ckn?_ljoSko>_hnoc[n?aljoSlO>_hk7c[n?aljoPPk7`0W>clg7c/o
=alk?cLO>clg7c/o=chgGcLn=elg?SMO=ehkGcMN>glgGS]O>ehoOc]N?glkGSmo?gi3OcmN@gloOT=o
?ei7Od=nC40l04P000=4000V?00h03`0>00l03P0?00h03`T>2<l8cPS?2@h8c`S>2<l93PS?2<`9SA7
=2Hd9c0V=4Ld9SQY=4PhJCA8>6TdB3QY=4Q;?dLNBcm;7SUoo`8000Ioo`03001oogoo00]oo`D00003
Ool007oo00Ioo`0017oo00<007ooOol047oo00M;7TLNBai77T/NAai;7P0@Aah024KnAai6oTLN@_h0
04KnAah2@_h60003@_h05T;o@_i2oT;n?_lnoSko?_hnockn?_lnoSko>_ho7cko?aljoSlO?_lo7c[n
23/O23/o01@kGc/o>elk?c]O>clkGc]N>elkGSmO>ehkGcmn?gloGSmo?ghoOd=n0d=o00E3OT=o@gm7
Od=O0097O`03B40l04@000=40008A21084@P@214840PA21080Ph8`03?4HlACa600Dd9`08>6ThJ3QY
=6PhJCQX>6TdJ09;?P03Bcmoogoo03Yoo`03001oogoo01=oo`80009oo`8000Moo`0017oo00<007oo
Ool05goo021;7dLNBam77T/OAai;7dLNAam6oT/OAai77dKnAam2oTLO@_i77d;n0012oTLO@_i77d;n
Aam2oTLO@_i37d;n1P0004E37ckn@alnoT<O?_i37ckn@alnoSlO?_ho7ckn?alnoSlo>alo7c/O?clk
7clO>alo?c/O>clk7clo>alk?c/O?clk?cmO>cloGc/o?elk?cmo>ehoGc]N?glkGSmo?ei3OcmN?glo
GT=o@ei3OcmN@gm3GT=o@ei7Od=NAgm3GTMoB21<@3`0D4000d@00258040PA21084@P@214840P?2@h
8c`S>2=0ISa5@6HlAD1V?4E0ISa5=4Ld9SQY=4PhJCA8>6TdB3QY=4Q;?dLNBcl0?Goo00<007ooOol0
87oo0004Ool00`00Oomoo`0MOol<Aah034Kn00177TLN@_i77T;nAai2oTLN@_i37`=2oP05@am2oT;n
@_i37`0700000d<O?_ho7`02?al00ckn?alo7`08?al00clo>clo?`02?cl02S/o?clo?cmO>clkGc/o
?elk?c]O1cmO00Q3Od=O@gloGd=o@em3Od=O0d=o00A3Gd=oAem7O`=7G`03Agm7GdMO0098@00Q?01@
@4a0D41<@510@214840PA21084@P@20lASa5?4HlACa6?4DlASa5?4HlACa6?4DhJCQX>6TdJ3QY>6Ph
JCAX009;?Sioo`80029oo`000goo00<007ooOol087oo02E;7dLNAam6oT/OA_i77d;nAam6oP00@_i7
7d;nAam2oTLO@_i77d;nAam2oTLO@_i37d;n@am2oT<O?_i37ckn@alnoT<O?_i37`0600000ckn?clo
7`02?al01Clo?alo7clO@cl00Slo00<o7d<o?cl00Slo00HoGclo?elo?cmO?cl2?el014=O?em3GcmO
0T=O03Y3Od=O@gm3Gd=o@em7Od=NAgm3GTMo@ei7Od=OAgm7GdMo@em;OdMNBem7GT]oB21<@4`PD41<
8510C21@@4Q2B698@DQRB498HTQ1@6HlAD1V?4E0ISa5@6HlAD1V@8M0R41W>6TdB3QY=4PhJCA8>6U7
7T1oo`03001oogoo021oo`000goo00<007ooOol097oo1TLN00<004LN@_h00dLN0152oTLNAai37d;n
@ai2oT<O@_i37T;n@am2oT<O@_i37d;n00=37`05?aho7clO@alo7P02?al600000clO?clo?`07?cl0
1T=O?cloGclo@elo?`8oG`05@eloGcmO?em3O`03@el02T=o@em7Gd=OAgm3GdMO@em7Od=O1TMO00M;
GdMOAem7Gd]OAem;G`02B4001Ta0D41<@510C41@@0M8HP0B?4HlACa6?4DlASa5@8Q0Qd28@8M0R427
>6ThJ3QY=6PhJD/n@Goo00<007ooOol087oo0003Ool00`00Oomoo`0YOol0:000Aam2oTLO@_i77d;n
Aam2oTLO@_i77d;nAam2oTLO@_i37d;n@am2oT<O@_i37ckn@alo7T<O?_i37clN@alnoT<o?ai3?clN
@clo7T<o1`0004Y3Gclo@elo?d=O?cm3Gclo@elo?d=O?em3GcloAgm3GdMO@em7Od=OAgm3GdMo@em7
Od=OAgm7GdMoAem7OdMOAgm7GT]OAei;GdMNBem7?T]OAci;GdPPC41DP510C21@@4`PB698@TQRB458
HTQ2B698@D1V?4E0IT1W@8Q0Qd28@6M0R427@8PdB3QY=4PhJDLN@Woo00<007ooOol087oo0003Ool0
0`00Oomoo`0XOol00`00Oomoo`06Ool01TLO@_i37T<NAam2oP937P06@am2oT<O@ai37d;n0d<O00E3
7T<O@am37clN00937`0?@clo7d<O@am3?clO@alo?d<o?cm3?clo@clo?d<o00H000a3G`m7G`0>Bem7
GdMOAem;GdLnBem;?d]OAci;Gd/oB41DP09DX003D41<@4QR00M8HP0>@8Q0Qd28@8M0R427@8Q0Qd28
@8M0R3AX>6U;?T=oo`80025oo`000goo00<007ooOol09goo00<007ooOol02Goo02]2oTLO@_i77d;n
Aam2oTLO@_i77d;nAalo7T<O@ai37clN@am37T<O?ai3?clN@clo7T<o?ai3?clO@clo?d<o?am3?clo
@elo?d=O?cm3GcloAem3?`06000014MO@em7Gd=O0dMO03A3GdMOAem7GdLnBem7GT]OAci;GdMNBem7
?T]OAci;GdLnBem7?T]OAci;GdLnBem7?T]OAciHX5B0F:1DP5RPE81@YDb4C:E<Q52UC8A<YDb4@8Q0
Qd28@6M0R427@8Q0Id28@8M0R4Eoo`80025oo`000goo00<007ooOol09Woo00<007ooOol03Woo00I3
7d<N@am37T<O@ah3@al01D<N@am37d<O@ah00T<O00I3?d<O@am37d<o@al6@cl01D=O@cm3?d<o@el0
0d<o00E7Gd=O@em3GdMO00=3G`03Ael0000000D000Y7G`08Bem7Gd]OAcm;GdMOBem7?P9;?`0:Bem7
?T/oBci;?d/nBcm;?URPE802E:004eRPE81<YDbTC:E<Y4bUC:A<YDbT@8Q0Qd28@8M0R427@8Q0Qd28
04Moo`03001oogoo009oo`D000Aoo`8000Moo`03001oogoo00=oo`@0005oo`000goo00<007ooOol0
9Goo00<007ooOol05Goo02U37TLO@ai37d<NAam37T<o@ai7?d<N@cm37TLo@ci3?d<NAcm3?T<o@ai7
Gd<oAem3?dMO@cm7Gd<oAem3?dMO@cm7Gd=OAem3?dMO@em7Gd<o00=7G`03Acm7G`0000D0000[Aci;
GdLnBem7?T]OAci;GdLnBem7?T]OAci;GdLnBem7?T]OAci;?dLnBem7?URPE81HX5B0F:1<Q52UC8A<
YDb4D:E<Q4bUC8A0R427@8Q0Id28@8L0Agoo0`001Woo00<007ooOol017oo0P001goo00<007ooOol0
0Woo00<007ooOol00Woo0@000003Ool00`00Oomoo`0TOol00`00Oomoo`0LOol2@al014<o@ai37d<O
14<o00=7?d<o@cl024<o00E7?dMO@cm7GdLo0117G`04Bem7GdMOAel6000014]OBcm;?d/n0d/o00e;
?T/oBci;?d/nBcm;?T/oBci;?d/nBcmDP002E:003URPC:A<YDbTC:E<Y4bUC:A<YD27@8Q0Qd28@8M:
Ool00`00Oomoo`04Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool1000000=oo`03001oogoo02=oo`03
001oogoo02=oo`0^@ci7?d<NAcm3?TLo@ai7Gd<nAcm3?TMO@ci7?d<oAem3?dMO@cm7GdLoAem3?dMO
Acm7Gd<oBem7?TMOAci;GdLnBem7?T]OAci;GdLnBem7?T]OAci;GdLnBel7000074/oAci;?dLnBcm7
?T/oAci;?dLNBcm7?T/oAaiHX5B0F:1<Q52UC8A<YDb4D:E<Q4bU@6M0R427Bgoo00<007ooOol017oo
00<007ooOol03Woo00<007ooOol01Woo0@000003Ool00`00Oomoo`0ROol00`00Oomoo`0ZOol01TLo
@cm7?d<oAcm3?`97?`06Aem7?dMOAcm7GdLo0dMO00=7?dMOAel024MO00I;GdLoAem7Gd]OAch2Bcl0
2d]OAci;?d/nBcm;?T/oBci;?d/nBcl01P000d/n00E;?d/nBci;?T/o009;?P0:E:1<YDbTC:E<Y4bU
C:A<YDbTC:E<Ool20006Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool40001Ool000=oo`03001oogoo
025oo`03001oogoo035oo`0_@cm7Gd<oAem3?dMOAci7GdLnAem7?TMOAci;GdLnBem7?T]OAci;GdLn
Bem7?T]OAci;GdLnBem7?T]OAci;GdLnBem7?T]OAci;GdLnBcm7?T/oAci;?dLnBcm7?P06000034/o
Bai;?dLNBcm;7T/oAai;?d/NBcm77Tmoo`03001oogoo00Aoo`03001oogoo00moo`05001oogooOol0
0004Ool000=oo`03001oogoo025oo`03001oogoo03aoo`97G`0=Acm7GdMOAem7?T]OAcm;GdLnBem7
?d/oAch00d/o0117?T/oBci;?d/nBcm;?T/oBci;?d/nBcm;?T/oBci;?`=;?P05Bcm;?T/nBci;?`07
000014/oBai;?T/nD7oo00<007ooOol00Woo0`0037oo00<007ooOol00Woo00D007ooOomoo`0000Ao
o`000goo00<007ooOol087oo00<007ooOol0BGoo02E;GdLnBem7?T]OAci;?dLnBem7?T/oAci;GdLn
Bcm7?T/oAci;?dLNBcm7?T/oAai;?d/NBcm77T/oBai;?dLNBcm;7T/oAai;?`06001>Ool00`00Oomo
o`04Ool00`00Oomoo`0:Ool60003Ool5000000=oo`03001oogoo01moo`03001oogoo05Eoo`09Bcm;
?T/oBci;?d/nBcm;?T/o00=;?P05Bcm;?T/nBci;?`03Bch01d/oBai;?T/nBcm;7T/n00Eoo`L004Io
o`80025oo`000goo00<007ooOol07Woo00<007ooOol0G7oo01=77T/oAai;?dLNBcm;7T/oAai;?d/N
Bcm77T/oBai;?dLNBcm;7P0>Ool60011Ool00`00Oomoo`0OOol000=oo`03001oogoo01eoo`03001o
ogoo06Qoo`03Bci;?d/N009;?P03Bcm;7Woo01Aoo`H003]oo`03001oogoo01moo`000Woo00<007oo
Ool07Goo00<007ooOol0KWoo00<007ooOol06Woo1`00=7oo0P0087oo0002Ool00`00Oomoo`0LOol0
0`00Oomoo`1_Ool00`00Oomoo`0QOol6000^Ool00`00Oomoo`0OOol0009oo`03001oogoo01]oo`03
001oogoo071oo`03001oogoo02Moo`H002Qoo`80021oo`000Woo00<007ooOol06Woo00<007ooOol0
LGoo00<007ooOol0;Goo1`008Woo00<007ooOol07Woo0002Ool00`00Oomoo`0IOol00`00Oomoo`1b
Ool00`00Oomoo`0dOol6000KOol2000POol0009oo`03001oogoo01Uoo`03001oogoo079oo`03001o
ogoo03Yoo`H001Ioo`03001oogoo01ioo`000Woo00<007ooOol067oo00<007ooOol0Lgoo00<007oo
Ool0@7oo1`003goo00@007ooOomoo`D001Qoo`000Woo00<007ooOol05goo00<007ooOol0M7oo00<0
07ooOol0Agoo1P0027oo0P000goo00D007ooOomoo`0001Qoo`000Woo00<007ooOol05Woo00<007oo
Ool0MGoo00<007ooOol0CGoo1P000goo00<007ooOol00Woo00<007ooOol06Goo0002Ool00`00Oomo
o`0EOol00`00Oomoo`1fOol00`00Oomoo`1COol40005Ool00`00Oomoo`0HOol0009oo`03001oogoo
01Aoo`03001oogoo07Moo`03001oogoo05Aoo`8000Moo`03001oogoo01Moo`000Woo00<007ooOol0
4goo00<007ooOol0N7oo00<007ooOol0DWoo0P002Woo00<007ooOol05Woo0002Ool00`00Oomoo`0B
Ool00`00Oomoo`1iOol00`00Oomoo`1?Ool30008Ool01@00Oomoogoo000067oo0002Ool00`00Oomo
o`0AOol00`00Oomoo`1kOol00`00Oomoo`1=Ool2000;Ool3000IOol0009oo`03001oogoo015oo`03
001oogoo07]oo`03001oogoo04]oo`8002Uoo`0000=oo`00Ool04Woo00<007ooOol0O7oo00<007oo
Ool0BGoo0P00:goo00000goo001oo`0AOol00`00Oomoo`1mOol00`00Oomoo`17Ool2000]Ool00003
Ool007oo011oo`03001oogoo07ioo`03001oogoo04Eoo`<000aoo`@001ioo`0000=oo`00Ool03goo
00<007ooOol0Ogoo00<007ooOol0A7oo00<007ooOol037oo00<007ooOol00Woo00<007ooOol06goo
00000goo001oo`0>Ool00`00Oomoo`20Ool00`00Oomoo`10Ool01000Ool000003goo00<007ooOol0
0Woo00<007ooOol06goo00000goo001oo`0=Ool00`00Oomoo`21Ool00`00Oomoo`10Ool2000AOol0
0`00Oomoo`02Ool00`00Oomoo`0KOol00003Ool007oo00aoo`03001oogoo089oo`03001oogoo03io
o`8001=oo`03001oogoo009oo`03001oogoo01]oo`0000=oo`00Ool02goo00<007ooOol0Pgoo00<0
07ooOol0?7oo0P005Goo00<007ooOol00Woo00<007ooOol06goo00000goo001oo`0:Ool00`00Oomo
o`24Ool00`00Oomoo`0iOol3000GOol00`00Oomoo`02Ool00`00Oomoo`0KOol00003Ool007oo00Yo
o`03001oogoo08Aoo`03001oogoo03Qoo`<001Uoo`@001ioo`0000=oo`00Ool02Goo00<007ooOol0
QGoo00<007ooOol0=Woo0P00?Woo00000goo001oo`08Ool00`00Oomoo`26Ool00`00Oomoo`0cOol3
0010Ool00003Ool007oo00Moo`03001oogoo08Moo`03001oogoo03=oo`03001oogoo041oo`0000=o
o`00Ool01Woo00<007ooOol0R7oo00<007ooOol0<Goo0P00@goo00000goo001oo`05Ool00`00Oomo
o`29Ool00`00Oomoo`0]Ool01000Ool00000AGoo00000goo001oo`04Ool00`00Oomoo`2:Ool00`00
Oomoo`0]Ool20017Ool00003001oogoo00=oo`03001oogoo08]oo`03001oogoo02]oo`8004Uoo`00
00<007ooOol00Woo00<007ooOol0S7oo00<007ooOol0:Goo0P00Bgoo00001@00Oomoogoo0000Sgoo
00<007ooOol09goo0P00CGoo00001@00Oomoogoo0000Sgoo00<007ooOol09Goo0`00CWoo00001000
Oomoo`00T7oo00<007ooOol08goo0P003Goo1@00?goo00000`00Ool0002AOol00`00Oomoo`0QOol2
000AOol00`00Oomoo`0oOol00080099oo`03001oogoo021oo`80019oo`03001oogoo03moo`001@00
Sgoo00<007ooOol07Woo0P0057oo00<007ooOol0?goo0005Ool90026Ool00`00Oomoo`0LOol2000F
Ool00`00Oomoo`0oOol000ioo`P007ioo`03001oogoo01Yoo`8001Qoo`03001oogoo03moo`005Woo
2@00MWoo00<007ooOol05Goo00@007oo000001Qoo`<0045oo`007goo2@00KGoo00<007ooOol05Goo
0P0077oo00<007ooOol0?goo000XOol9001TOol00`00Oomoo`0COol2001POol0035oo`P005aoo`03
001oogoo011oo`<0069oo`00>Goo2@00Dgoo00<007ooOol03goo0P00I7oo0012Ool9001:Ool00`00
Oomoo`0>Ool00`00Oomoo`1TOol004]oo`T0045oo`03001oogoo00]oo`<006Moo`00E7oo2@00>7oo
00<007ooOol02Woo0P00JGoo001MOol8000`Ool00`00Oomoo`06Ool01000Ool00000Jgoo001UOol9
000WOol00`00Oomoo`06Ool2001]Ool006ioo`T001ioo`03001oogoo00Aoo`8000eoo`D005eoo`00
Mgoo2@005Goo00@007ooOomoo`<000moo`05001oogooOol0001MOol0081oo`P000eoo`03001oogoo
0080019oo`03001oogoo05ioo`00R7oo2@0017oo0`005Goo00<007ooOol0GGoo002AOol5000HOol0
0`00Oomoo`1LOol00:moo`03001oogoo05]oo`00Zgoo00D007ooOomoo`0005eoo`00[7oo0`00GWoo
003oOol>Ool00?moo`ioo`00_7oo0`00CWoo002kOol01@00Oomoogoo0000CGoo002COol3000UOol0
0`00Oomoo`1?Ool0099oo`05001oogooOol0000TOol00`00Oomoo`1?Ool009Ioo`03001oogoo029o
o`03001oogoo04moo`00UWoo00<007ooOol08Goo1@00CWoo002DOol2000UOol00`00Oomoo`1?Ool0
09Ioo`03001oogoo07Aoo`00TWoo00D007ooOomoo`0007Ioo`00Tgoo0`00Mgoo003oOol>Ool00?mo
o`ioo`00ogoo3Woo003oOol>Ool00?moo`ioo`00ogoo3Woo003oOol>Ool00?moo`ioo`00ogoo3Woo
003oOol>Ool00?moo`ioo`00ogoo3Woo003oOol>Ool00?moo`ioo`00ogoo3Woo003oOol>Ool00001
\
\>"],
  ImageRangeCache->{{{0, 268.5}, {215.75, 0}} -> {0.0683112, 0.0261871, \
0.00491573, 0.00491573}}]
}, Open  ]],

Cell[TextData[{
  "We clearly observe that the solution represents a decaying solution in  \
time. The initial shape of a Gaussian in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " decreases in time but does not change its shape. The examination of the \
FP equation demonstrated that the non-classical method can be combined with \
the classical method. The results for the non-classical symmetries of the FP \
equation are, however, too complicated for ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " to carry out the final stage of the solution procedure."
}], "Text",
  CellTags->"combination of non-classical and classical method"],

Cell["\<\
Up to now, we discussed local symmetries of a given equation. In \
the following chapter, we will describe the derivation of non-local \
symmetries. We will show that the Fr\[EAcute]chet derivative is a useful tool \
for determining this type of symmetry.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet65.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{666, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->364,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Non-classical Symmetries of Partial Differential Equations", 
            FontSlant -> "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Introduction", 
                "Mathematical Background of the Non-classical Method", 
                "Applications of the Non-classical Method"}, #]&)], FontSlant -> 
            "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Non-classical method"->{
    Cell[1739, 51, 385, 7, 117, "ChapterLine",
      Evaluatable->False,
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Non-classical method"]},
  "Introduction"->{
    Cell[2560, 73, 332, 9, 52, "Section",
      CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Introduction"]},
  "non-classical method"->{
    Cell[2895, 84, 817, 16, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "symmetry analysis", "Lie's classical method"}],
    
    Cell[3715, 102, 1284, 37, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "diffusion equation", "heat equation", 
        "weak symmetries"}],
    Cell[10922, 327, 432, 10, 75, "Text",
      Evaluatable->False,
      CellTags->{"classical method", "non-classical method"}],
    Cell[14637, 425, 535, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation formulation", "Fr\[EAcute]chet formalism", 
        "non-classical method"}],
    Cell[18220, 523, 1330, 27, 222, "Text",
      Evaluatable->False,
      CellTags->{"non-classical method", "side condition"}],
    Cell[23431, 674, 1080, 22, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear determining equations", "classical method", 
        "non-classical method", "non-classical symmetries"}]},
  "symmetry analysis"->{
    Cell[2895, 84, 817, 16, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "symmetry analysis", 
        "Lie's classical method"}]},
  "Lie's classical method"->{
    Cell[2895, 84, 817, 16, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "symmetry analysis", 
        "Lie's classical method"}]},
  "diffusion equation"->{
    Cell[3715, 102, 1284, 37, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "diffusion equation", "heat equation", 
        "weak symmetries"}]},
  "heat equation"->{
    Cell[3715, 102, 1284, 37, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "diffusion equation", "heat equation", 
        "weak symmetries"}],
    Cell[24723, 709, 1183, 29, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "heat equation", "Boussinesq equation", "Burgers equation", 
        "Fitzhugh Nagumo equation"}],
    Cell[26012, 745, 331, 9, 54, "Text",
      Evaluatable->False,
      CellTags->"heat equation"],
    Cell[44570, 1292, 979, 28, 159, "Text",
      Evaluatable->False,
      CellTags->"heat equation"],
    Cell[224446, 5970, 545, 18, 96, "Text",
      CellTags->"heat equation"]},
  "weak symmetries"->{
    Cell[3715, 102, 1284, 37, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "diffusion equation", "heat equation", 
        "weak symmetries"}]},
  "Definition: Symmetry of a PDE"->{
    Cell[5002, 141, 96, 1, 38, "Definition",
      CellTags->"Definition: Symmetry of a PDE"]},
  "local transformation"->{
    Cell[5101, 144, 283, 8, 33, "Text",
      Evaluatable->False,
      CellTags->"local transformation"]},
  "weak symmetry"->{
    Cell[5995, 175, 853, 18, 138, "Text",
      Evaluatable->False,
      CellTags->"weak symmetry"],
    Cell[11357, 339, 816, 17, 138, "Text",
      Evaluatable->False,
      CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}]},
  "Mathematical background of the non-classical method"->{
    Cell[6885, 198, 242, 8, 52, "Section",
      Evaluatable->False,
      CellTags->"Mathematical background of the non-classical method"]},
  "invariant surface condition"->{
    Cell[7381, 219, 524, 13, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant surface condition", "point transformation", 
        "characteristic equations"}],
    Cell[12176, 358, 598, 18, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant solution", "invariant surface condition", 
        "characteristic equation"}]},
  "point transformation"->{
    Cell[7381, 219, 524, 13, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant surface condition", "point transformation", 
        "characteristic equations"}]},
  "characteristic equations"->{
    Cell[7381, 219, 524, 13, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant surface condition", "point transformation", 
        "characteristic equations"}],
    Cell[28770, 836, 2354, 65, 306, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "classical method"->{
    Cell[10922, 327, 432, 10, 75, "Text",
      Evaluatable->False,
      CellTags->{"classical method", "non-classical method"}],
    Cell[23431, 674, 1080, 22, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear determining equations", "classical method", 
        "non-classical method", "non-classical symmetries"}]},
  "Lie algebra"->{
    Cell[11357, 339, 816, 17, 138, "Text",
      Evaluatable->False,
      CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}]},
  "similarity solutions"->{
    Cell[11357, 339, 816, 17, 138, "Text",
      Evaluatable->False,
      CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}]},
  "invariant solution"->{
    Cell[12176, 358, 598, 18, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant solution", "invariant surface condition", 
        "characteristic equation"}]},
  "characteristic equation"->{
    Cell[12176, 358, 598, 18, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant solution", "invariant surface condition", 
        "characteristic equation"}],
    Cell[19553, 552, 336, 8, 75, "Text",
      Evaluatable->False,
      CellTags->"characteristic equation"]},
  "characteristics"->{
    Cell[13615, 404, 1019, 19, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}]},
  "Lie's method"->{
    Cell[13615, 404, 1019, 19, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}]},
  "nonlinear system of determining equations"->{
    Cell[13615, 404, 1019, 19, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}]},
  "determining equations"->{
    Cell[13615, 404, 1019, 19, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}],
    Cell[18057, 516, 160, 5, 26, "ListItem",
      CellTags->"determining equations"]},
  "infinitesimals"->{
    Cell[13615, 404, 1019, 19, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}],
    Cell[32958, 949, 837, 18, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear coupled system of partial differential equations", 
        "non-classical symmetries", "infinitesimals"}],
    Cell[37669, 1081, 643, 15, 117, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals"],
    Cell[184046, 4632, 500, 13, 96, "Text",
      CellTags->"infinitesimals"],
    Cell[234104, 6247, 1161, 36, 117, "Text",
      CellTags->"infinitesimals"],
    Cell[253850, 6853, 949, 17, 201, "Text",
      CellTags->{
      "reduction of the FP-equation", "infinitesimals", "invariants"}]},
  "nonlinear determining equations"->{
    Cell[13615, 404, 1019, 19, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}],
    Cell[23431, 674, 1080, 22, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear determining equations", "classical method", 
        "non-classical method", "non-classical symmetries"}],
    Cell[35558, 1020, 1000, 21, 201, "Text",
      Evaluatable->False,
      CellTags->"nonlinear determining equations"]},
  "prolongation formulation"->{
    Cell[14637, 425, 535, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation formulation", "Fr\[EAcute]chet formalism", 
        "non-classical method"}]},
  "Fr\[EAcute]chet formalism"->{
    Cell[14637, 425, 535, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation formulation", "Fr\[EAcute]chet formalism", 
        "non-classical method"}]},
  "invariance condition"->{
    Cell[15380, 446, 388, 11, 54, "Text",
      Evaluatable->False,
      CellTags->{"invariance condition", "Fr\[EAcute]chet derivative"}]},
  "Fr\[EAcute]chet derivative"->{
    Cell[15380, 446, 388, 11, 54, "Text",
      Evaluatable->False,
      CellTags->{"invariance condition", "Fr\[EAcute]chet derivative"}]},
  "algorithm for the non-classical method"->{
    Cell[16443, 477, 1179, 24, 201, "Text",
      Evaluatable->False,
      CellTags->"algorithm for the non-classical method"]},
  "non-classical algorithm"->{
    Cell[17625, 503, 274, 7, 26, "ListItem",
      CellTags->{"non-classical algorithm", "prolongation"}]},
  "prolongation"->{
    Cell[17625, 503, 274, 7, 26, "ListItem",
      CellTags->{"non-classical algorithm", "prolongation"}]},
  "side conditions"->{
    Cell[17902, 512, 152, 2, 26, "ListItem",
      CellTags->{"side conditions", "prolongation formula"}]},
  "prolongation formula"->{
    Cell[17902, 512, 152, 2, 26, "ListItem",
      CellTags->{"side conditions", "prolongation formula"}]},
  "side condition"->{
    Cell[18220, 523, 1330, 27, 222, "Text",
      Evaluatable->False,
      CellTags->{"non-classical method", "side condition"}]},
  "formal coordinate transformation"->{
    Cell[20506, 584, 712, 22, 75, "Text",
      Evaluatable->False,
      CellTags->"formal coordinate transformation"]},
  "redundant information"->{
    Cell[21781, 626, 745, 19, 117, "Text",
      Evaluatable->False,
      CellTags->"redundant information"]},
  "non-classical symmetries"->{
    Cell[23431, 674, 1080, 22, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear determining equations", "classical method", 
        "non-classical method", "non-classical symmetries"}],
    Cell[32958, 949, 837, 18, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear coupled system of partial differential equations", 
        "non-classical symmetries", "infinitesimals"}],
    Cell[261553, 7093, 584, 13, 96, "Text",
      CellTags->{
      "non-classical symmetries", "PDESolve[]", "pure function"}]},
  "Applications of the non-classical method"->{
    Cell[24548, 701, 172, 6, 52, "Section",
      CellTags->"Applications of the non-classical method"]},
  "Boussinesq equation"->{
    Cell[24723, 709, 1183, 29, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "heat equation", "Boussinesq equation", "Burgers equation", 
        "Fitzhugh Nagumo equation"}],
    Cell[161220, 3977, 201, 7, 33, "Text",
      CellTags->"Boussinesq equation"]},
  "Burgers equation"->{
    Cell[24723, 709, 1183, 29, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "heat equation", "Boussinesq equation", "Burgers equation", 
        "Fitzhugh Nagumo equation"}]},
  "Fitzhugh Nagumo equation"->{
    Cell[24723, 709, 1183, 29, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "heat equation", "Boussinesq equation", "Burgers equation", 
        "Fitzhugh Nagumo equation"}]},
  "The heat equation"->{
    Cell[25931, 742, 78, 1, 49, "Subsection",
      CellTags->"The heat equation"]},
  "temperature"->{
    Cell[26495, 762, 1049, 25, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "temperature", "non-classical method and heat equation", "Lie[]"}]},
  "non-classical method and heat equation"->{
    Cell[26495, 762, 1049, 25, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "temperature", "non-classical method and heat equation", "Lie[]"}]},
  "Lie[]"->{
    Cell[26495, 762, 1049, 25, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "temperature", "non-classical method and heat equation", "Lie[]"}],
    Cell[36739, 1048, 216, 7, 33, "Text",
      Evaluatable->False,
      CellTags->"Lie[]"]},
  "LieEquations[]"->{
    Cell[27997, 809, 390, 11, 75, "Text",
      Evaluatable->False,
      CellTags->"LieEquations[]"]},
  "non-classical symmetry method"->{
    Cell[28770, 836, 2354, 65, 306, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "NonclassicalSymmetries"->{
    Cell[28770, 836, 2354, 65, 306, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "NonclassicalCases"->{
    Cell[28770, 836, 2354, 65, 306, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "non-classical symmetry analysis"->{
    Cell[28770, 836, 2354, 65, 306, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "nonlinear coupled system of partial differential equations"->{
    Cell[32958, 949, 837, 18, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear coupled system of partial differential equations", 
        "non-classical symmetries", "infinitesimals"}]},
  "Save[]"->{
    Cell[34010, 976, 584, 14, 96, "Text",
      Evaluatable->False,
      CellTags->"Save[]"]},
  "non-classical group"->{
    Cell[39659, 1147, 976, 22, 180, "Text",
      Evaluatable->False,
      CellTags->{"non-classical group", "Lie's point symmetry procedure"}]},
  "Lie's point symmetry procedure"->{
    Cell[39659, 1147, 976, 22, 180, "Text",
      Evaluatable->False,
      CellTags->{"non-classical group", "Lie's point symmetry procedure"}]},
  "reduction of the non-classical determining equations"->{
    Cell[46066, 1337, 224, 5, 54, "Text",
      CellTags->"reduction of the non-classical determining equations"]},
  "similarity representation of the nonlinear determining equations"->{
    Cell[47207, 1372, 435, 12, 75, "Text",
      CellTags->
      "similarity representation of the nonlinear determining equations"]},
  "DSolve[]"->{
    Cell[48351, 1409, 335, 11, 54, "Text",
      CellTags->"DSolve[]"],
    Cell[246467, 6628, 192, 7, 33, "Text",
      CellTags->"DSolve[]"],
    Cell[266189, 7243, 136, 4, 33, "Text",
      CellTags->"DSolve[]"]},
  "solution of the non-classical determining equations"->{
    Cell[49333, 1450, 356, 12, 54, "Text",
      CellTags->"solution of the non-classical determining equations"]},
  "pure function"->{
    Cell[50173, 1479, 188, 5, 54, "Text",
      CellTags->"pure function"],
    Cell[261553, 7093, 584, 13, 96, "Text",
      CellTags->{
      "non-classical symmetries", "PDESolve[]", "pure function"}]},
  "non-classical infinitesimals"->{
    Cell[51572, 1534, 142, 4, 33, "Text",
      CellTags->"non-classical infinitesimals"],
    Cell[256386, 6922, 827, 27, 96, "Text",
      CellTags->"non-classical infinitesimals"]},
  "similarity representation"->{
    Cell[53280, 1591, 387, 9, 75, "Text",
      CellTags->"similarity representation"],
    Cell[189086, 4783, 408, 11, 75, "Text",
      CellTags->"similarity representation"]},
  "find non-classical solutions"->{
    Cell[160503, 3954, 587, 15, 117, "Text",
      CellTags->"find non-classical solutions"]},
  "The Boussinesq equation"->{
    Cell[161127, 3974, 90, 1, 49, "Subsection",
      CellTags->"The Boussinesq equation"]},
  "surface wave"->{
    Cell[161572, 3991, 1345, 28, 201, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}]},
  "plasma physics"->{
    Cell[161572, 3991, 1345, 28, 201, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}]},
  "point symmetries of the Boussinesq equation"->{
    Cell[161572, 3991, 1345, 28, 201, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}],
    Cell[163607, 4047, 126, 1, 33, "Text",
      CellTags->"point symmetries of the Boussinesq equation"]},
  "direct method"->{
    Cell[161572, 3991, 1345, 28, 201, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}]},
  "pseudo automatic calculation of non-classical symmetries"->{
    Cell[161572, 3991, 1345, 28, 201, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}]},
  "NonClassicalPointSymmetries[]"->{
    Cell[164524, 4080, 950, 23, 159, "Text",
      CellTags->"NonClassicalPointSymmetries[]"],
    Cell[217454, 5762, 1091, 22, 180, "Text",
      CellTags->{
      "numerical solution", "similarity transformation", 
        "NonClassicalPointSymmetries[]", "PDESolve[]"}]},
  "PDESolve[]"->{
    Cell[172702, 4284, 587, 13, 117, "Text",
      CellTags->{"PDESolve[]", "solution branches"}],
    Cell[178940, 4461, 1088, 36, 96, "Text",
      CellTags->"PDESolve[]"],
    Cell[217454, 5762, 1091, 22, 180, "Text",
      CellTags->{
      "numerical solution", "similarity transformation", 
        "NonClassicalPointSymmetries[]", "PDESolve[]"}],
    Cell[229377, 6109, 908, 27, 159, "Text",
      CellTags->"PDESolve[]"],
    Cell[258708, 6997, 602, 21, 54, "Text",
      CellTags->"PDESolve[]"],
    Cell[261553, 7093, 584, 13, 96, "Text",
      CellTags->{
      "non-classical symmetries", "PDESolve[]", "pure function"}]},
  "solution branches"->{
    Cell[172702, 4284, 587, 13, 117, "Text",
      CellTags->{"PDESolve[]", "solution branches"}]},
  "LieReduction[]"->{
    Cell[186901, 4727, 259, 5, 54, "Text",
      CellTags->{"LieReduction[]", "reduction of the Boussinesq equation"}],
    Cell[242204, 6500, 833, 18, 138, "Text",
      CellTags->{
      "point symmetries of the non-classical determining equations", 
        "LieReduction[]"}]},
  "reduction of the Boussinesq equation"->{
    Cell[186901, 4727, 259, 5, 54, "Text",
      CellTags->{"LieReduction[]", "reduction of the Boussinesq equation"}]},
  "first integral"->{
    Cell[190388, 4822, 188, 3, 54, "Text",
      CellTags->"first integral"]},
  "quadratures"->{
    Cell[191574, 4856, 712, 20, 117, "Text",
      CellTags->"quadratures"]},
  "numerical integration"->{
    Cell[192804, 4900, 510, 7, 117, "Text",
      CellTags->{"numerical integration", "similarity variable"}]},
  "similarity variable"->{
    Cell[192804, 4900, 510, 7, 117, "Text",
      CellTags->{"numerical integration", "similarity variable"}]},
  "numerical solution"->{
    Cell[217454, 5762, 1091, 22, 180, "Text",
      CellTags->{
      "numerical solution", "similarity transformation", 
        "NonClassicalPointSymmetries[]", "PDESolve[]"}]},
  "similarity transformation"->{
    Cell[217454, 5762, 1091, 22, 180, "Text",
      CellTags->{
      "numerical solution", "similarity transformation", 
        "NonClassicalPointSymmetries[]", "PDESolve[]"}]},
  "The Fokker-Planck equation"->{
    Cell[218582, 5789, 96, 1, 49, "Subsection",
      CellTags->"The Fokker-Planck equation"]},
  "Fokker-Planck"->{
    Cell[218681, 5792, 728, 14, 117, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "Fokker-Planck equation"->{
    Cell[218681, 5792, 728, 14, 117, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "statistical phenomena"->{
    Cell[218681, 5792, 728, 14, 117, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "condensed matter physics"->{
    Cell[218681, 5792, 728, 14, 117, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "quantum optics"->{
    Cell[218681, 5792, 728, 14, 117, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "chemical physics"->{
    Cell[218681, 5792, 728, 14, 117, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "fluctuations"->{
    Cell[218681, 5792, 728, 14, 117, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "FP-equation"->{
    Cell[218681, 5792, 728, 14, 117, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "Brownian particle in a liquid"->{
    Cell[219557, 5813, 1067, 32, 138, "Text",
      CellTags->{
      "Brownian particle in a liquid", "diffusion coefficient", 
        "drift coefficient"}]},
  "diffusion coefficient"->{
    Cell[219557, 5813, 1067, 32, 138, "Text",
      CellTags->{
      "Brownian particle in a liquid", "diffusion coefficient", 
        "drift coefficient"}]},
  "drift coefficient"->{
    Cell[219557, 5813, 1067, 32, 138, "Text",
      CellTags->{
      "Brownian particle in a liquid", "diffusion coefficient", 
        "drift coefficient"}]},
  "point symmetries"->{
    Cell[221100, 5865, 89, 1, 33, "Text",
      CellTags->"point symmetries"]},
  "non-classical determining equations"->{
    Cell[228017, 6069, 234, 6, 54, "Text",
      CellTags->"non-classical determining equations"]},
  "point symmetries of the non-classical determining equations"->{
    Cell[242204, 6500, 833, 18, 138, "Text",
      CellTags->{
      "point symmetries of the non-classical determining equations", 
        "LieReduction[]"}]},
  "similarity function"->{
    Cell[245401, 6590, 376, 13, 54, "Text",
      CellTags->"similarity function"]},
  "special function"->{
    Cell[247736, 6666, 866, 30, 75, "Text",
      CellTags->{"special function", "Erfi[]"}]},
  "Erfi[]"->{
    Cell[247736, 6666, 866, 30, 75, "Text",
      CellTags->{"special function", "Erfi[]"}]},
  "non-classical symmetry transformations of the FP-equation"->{
    Cell[250068, 6742, 270, 5, 54, "Text",
      CellTags->
      "non-classical symmetry transformations of the FP-equation"]},
  "reduction of the FP-equation"->{
    Cell[253850, 6853, 949, 17, 201, "Text",
      CellTags->{
      "reduction of the FP-equation", "infinitesimals", "invariants"}]},
  "invariants"->{
    Cell[253850, 6853, 949, 17, 201, "Text",
      CellTags->{
      "reduction of the FP-equation", "infinitesimals", "invariants"}]},
  "initial conditions"->{
    Cell[267140, 7283, 600, 18, 96, "Text",
      CellTags->{
      "initial conditions", "non-classical solution of the FP-equation"}]},
  "non-classical solution of the FP-equation"->{
    Cell[267140, 7283, 600, 18, 96, "Text",
      CellTags->{
      "initial conditions", "non-classical solution of the FP-equation"}]},
  "combination of non-classical and classical method"->{
    Cell[355124, 9427, 651, 13, 138, "Text",
      CellTags->"combination of non-classical and classical method"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Non-classical method", 358214, 9511},
  {"Introduction", 358588, 9519},
  {"non-classical method", 358931, 9526},
  {"symmetry analysis", 359970, 9553},
  {"Lie's classical method", 360174, 9559},
  {"diffusion equation", 360374, 9565},
  {"heat equation", 360582, 9571},
  {"weak symmetries", 361268, 9590},
  {"Definition: Symmetry of a PDE", 361492, 9596},
  {"local transformation", 361616, 9599},
  {"weak symmetry", 361745, 9603},
  {"Mathematical background of the non-classical method", 362051, 9610},
  {"invariant surface condition", 362228, 9614},
  {"point transformation", 362625, 9625},
  {"characteristic equations", 362843, 9631},
  {"classical method", 363310, 9643},
  {"Lie algebra", 363673, 9652},
  {"similarity solutions", 363846, 9656},
  {"invariant solution", 364017, 9660},
  {"characteristic equation", 364232, 9666},
  {"characteristics", 364550, 9675},
  {"Lie's method", 364843, 9682},
  {"nonlinear system of determining equations", 365165, 9689},
  {"determining equations", 365467, 9696},
  {"infinitesimals", 365849, 9705},
  {"nonlinear determining equations", 366773, 9727},
  {"prolongation formulation", 367413, 9742},
  {"Fr\[EAcute]chet formalism", 367631, 9748},
  {"invariance condition", 367844, 9754},
  {"Fr\[EAcute]chet derivative", 368020, 9758},
  {"algorithm for the non-classical method", 368208, 9762},
  {"non-classical algorithm", 368369, 9766},
  {"prolongation", 368497, 9769},
  {"side conditions", 368628, 9772},
  {"prolongation formula", 368764, 9775},
  {"side condition", 368894, 9778},
  {"formal coordinate transformation", 369066, 9782},
  {"redundant information", 369217, 9786},
  {"non-classical symmetries", 369361, 9790},
  {"Applications of the non-classical method", 369963, 9804},
  {"Boussinesq equation", 370096, 9807},
  {"Burgers equation", 370397, 9815},
  {"Fitzhugh Nagumo equation", 370623, 9821},
  {"The heat equation", 370842, 9827},
  {"temperature", 370946, 9830},
  {"non-classical method and heat equation", 371155, 9835},
  {"Lie[]", 371331, 9840},
  {"LieEquations[]", 371610, 9848},
  {"non-classical symmetry method", 371751, 9852},
  {"NonclassicalSymmetries", 372039, 9859},
  {"NonclassicalCases", 372322, 9866},
  {"non-classical symmetry analysis", 372619, 9873},
  {"nonlinear coupled system of partial differential equations", 372943, \
9880},
  {"Save[]", 373170, 9886},
  {"non-classical group", 373293, 9890},
  {"Lie's point symmetry procedure", 373478, 9894},
  {"reduction of the non-classical determining equations", 373685, 9898},
  {"similarity representation of the nonlinear determining equations", \
373873, 9901},
  {"DSolve[]", 374025, 9905},
  {"solution of the non-classical determining equations", 374301, 9912},
  {"pure function", 374438, 9915},
  {"non-classical infinitesimals", 374680, 9921},
  {"similarity representation", 374898, 9926},
  {"find non-classical solutions", 375113, 9931},
  {"The Boussinesq equation", 375239, 9934},
  {"surface wave", 375352, 9937},
  {"plasma physics", 375623, 9943},
  {"point symmetries of the Boussinesq equation", 375923, 9949},
  {"direct method", 376300, 9957},
  {"pseudo automatic calculation of non-classical symmetries", 376613, 9963},
  {"NonClassicalPointSymmetries[]", 376899, 9969},
  {"PDESolve[]", 377192, 9976},
  {"solution branches", 377852, 9992},
  {"LieReduction[]", 377974, 9995},
  {"reduction of the Boussinesq equation", 378300, 10002},
  {"first integral", 378443, 10005},
  {"quadratures", 378541, 10008},
  {"numerical integration", 378648, 10011},
  {"similarity variable", 378787, 10014},
  {"numerical solution", 378925, 10017},
  {"similarity transformation", 379138, 10022},
  {"The Fokker-Planck equation", 379352, 10027},
  {"Fokker-Planck", 379469, 10030},
  {"Fokker-Planck equation", 379754, 10036},
  {"statistical phenomena", 380038, 10042},
  {"condensed matter physics", 380325, 10048},
  {"quantum optics", 380602, 10054},
  {"chemical physics", 380881, 10060},
  {"fluctuations", 381156, 10066},
  {"FP-equation", 381430, 10072},
  {"Brownian particle in a liquid", 381722, 10078},
  {"diffusion coefficient", 381912, 10083},
  {"drift coefficient", 382098, 10088},
  {"point symmetries", 382283, 10093},
  {"non-classical determining equations", 382406, 10096},
  {"point symmetries of the non-classical determining equations", 382573, \
10099},
  {"similarity function", 382762, 10104},
  {"special function", 382871, 10107},
  {"Erfi[]", 382979, 10110},
  {"non-classical symmetry transformations of the FP-equation", 383138, \
10113},
  {"reduction of the FP-equation", 383303, 10117},
  {"invariants", 383457, 10121},
  {"initial conditions", 383619, 10125},
  {"non-classical solution of the FP-equation", 383806, 10129},
  {"combination of non-classical and classical method", 384001, 10133}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 385, 7, 117, "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Non-classical method"],
Cell[2127, 60, 408, 9, 229, "Title",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],

Cell[CellGroupData[{
Cell[2560, 73, 332, 9, 52, "Section",
  CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],
Cell[2895, 84, 817, 16, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "non-classical method", "symmetry analysis", "Lie's classical method"}],
Cell[3715, 102, 1284, 37, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "non-classical method", "diffusion equation", "heat equation", 
    "weak symmetries"}],
Cell[5002, 141, 96, 1, 38, "Definition",
  CellTags->"Definition: Symmetry of a PDE"],
Cell[5101, 144, 283, 8, 33, "Text",
  Evaluatable->False,
  CellTags->"local transformation"],
Cell[5387, 154, 277, 8, 26, "ListItem",
  Evaluatable->False],
Cell[5667, 164, 325, 9, 45, "ListItem",
  Evaluatable->False],
Cell[5995, 175, 853, 18, 138, "Text",
  Evaluatable->False,
  CellTags->"weak symmetry"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6885, 198, 242, 8, 52, "Section",
  Evaluatable->False,
  CellTags->"Mathematical background of the non-classical method"],
Cell[7130, 208, 143, 5, 33, "Text",
  Evaluatable->False],
Cell[7276, 215, 102, 2, 30, "NumberedEquation"],
Cell[7381, 219, 524, 13, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "invariant surface condition", "point transformation", 
    "characteristic equations"}],
Cell[7908, 234, 1289, 34, 50, "NumberedEquation"],
Cell[9200, 270, 266, 8, 54, "Text",
  Evaluatable->False],
Cell[9469, 280, 291, 6, 54, "NumberedEquation"],
Cell[9763, 288, 559, 17, 54, "Text",
  Evaluatable->False],
Cell[10325, 307, 248, 7, 30, "NumberedEquation"],
Cell[10576, 316, 343, 9, 30, "NumberedEquation"],
Cell[10922, 327, 432, 10, 75, "Text",
  Evaluatable->False,
  CellTags->{"classical method", "non-classical method"}],
Cell[11357, 339, 816, 17, 138, "Text",
  Evaluatable->False,
  CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}],
Cell[12176, 358, 598, 18, 75, "Text",
  Evaluatable->False,
  CellTags->{
  "invariant solution", "invariant surface condition", 
    "characteristic equation"}],
Cell[12777, 378, 218, 4, 28, "NumberedEquation"],
Cell[12998, 384, 171, 5, 54, "Text",
  Evaluatable->False],
Cell[13172, 391, 216, 4, 49, "NumberedEquation"],
Cell[13391, 397, 221, 5, 49, "NumberedEquation"],
Cell[13615, 404, 1019, 19, 180, "Text",
  Evaluatable->False,
  CellTags->{
  "characteristics", "Lie's method", 
    "nonlinear system of determining equations", "determining equations", 
    "infinitesimals", "nonlinear determining equations"}],
Cell[14637, 425, 535, 12, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "prolongation formulation", "Fr\[EAcute]chet formalism", 
    "non-classical method"}],
Cell[15175, 439, 117, 2, 31, "NumberedEquation"],
Cell[15295, 443, 82, 1, 28, "NumberedEquation"],
Cell[15380, 446, 388, 11, 54, "Text",
  Evaluatable->False,
  CellTags->{"invariance condition", "Fr\[EAcute]chet derivative"}],
Cell[15771, 459, 669, 16, 60, "NumberedEquation"],
Cell[16443, 477, 1179, 24, 201, "Text",
  Evaluatable->False,
  CellTags->"algorithm for the non-classical method"],
Cell[17625, 503, 274, 7, 26, "ListItem",
  CellTags->{"non-classical algorithm", "prolongation"}],
Cell[17902, 512, 152, 2, 26, "ListItem",
  CellTags->{"side conditions", "prolongation formula"}],
Cell[18057, 516, 160, 5, 26, "ListItem",
  CellTags->"determining equations"],
Cell[18220, 523, 1330, 27, 222, "Text",
  Evaluatable->False,
  CellTags->{"non-classical method", "side condition"}],
Cell[19553, 552, 336, 8, 75, "Text",
  Evaluatable->False,
  CellTags->"characteristic equation"],
Cell[19892, 562, 177, 4, 28, "NumberedEquation"],
Cell[20072, 568, 259, 7, 54, "Text",
  Evaluatable->False],
Cell[20334, 577, 169, 5, 28, "NumberedEquation",
  Evaluatable->False],
Cell[20506, 584, 712, 22, 75, "Text",
  Evaluatable->False,
  CellTags->"formal coordinate transformation"],
Cell[21221, 608, 113, 2, 28, "NumberedEquation"],
Cell[21337, 612, 208, 5, 30, "NumberedEquation"],
Cell[21548, 619, 230, 5, 29, "NumberedEquation"],
Cell[21781, 626, 745, 19, 117, "Text",
  Evaluatable->False,
  CellTags->"redundant information"],
Cell[22529, 647, 430, 10, 64, "ListItem",
  Evaluatable->False],
Cell[22962, 659, 466, 13, 64, "ListItem",
  Evaluatable->False],
Cell[23431, 674, 1080, 22, 201, "Text",
  Evaluatable->False,
  CellTags->{
  "nonlinear determining equations", "classical method", 
    "non-classical method", "non-classical symmetries"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24548, 701, 172, 6, 52, "Section",
  CellTags->"Applications of the non-classical method"],
Cell[24723, 709, 1183, 29, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "heat equation", "Boussinesq equation", "Burgers equation", 
    "Fitzhugh Nagumo equation"}],

Cell[CellGroupData[{
Cell[25931, 742, 78, 1, 49, "Subsection",
  CellTags->"The heat equation"],
Cell[26012, 745, 331, 9, 54, "Text",
  Evaluatable->False,
  CellTags->"heat equation"],
Cell[26346, 756, 146, 4, 29, "NumberedEquation",
  Evaluatable->False],
Cell[26495, 762, 1049, 25, 180, "Text",
  Evaluatable->False,
  CellTags->{
  "temperature", "non-classical method and heat equation", "Lie[]"}],
Cell[27547, 789, 54, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[27626, 794, 111, 2, 27, "Input"],
Cell[27740, 798, 242, 8, 30, "Output"]
}, Open  ]],
Cell[27997, 809, 390, 11, 75, "Text",
  Evaluatable->False,
  CellTags->"LieEquations[]"],
Cell[28390, 822, 164, 3, 45, "Input"],
Cell[28557, 827, 210, 7, 33, "Text",
  Evaluatable->False],
Cell[28770, 836, 2354, 65, 306, "Text",
  Evaluatable->False,
  CellTags->{
  "non-classical symmetry method", "NonclassicalSymmetries", 
    "NonclassicalCases", "characteristic equations", 
    "non-classical symmetry analysis"}],

Cell[CellGroupData[{
Cell[31149, 905, 182, 3, 45, "Input"],
Cell[31334, 910, 1609, 36, 265, "Output"]
}, Open  ]],
Cell[32958, 949, 837, 18, 138, "Text",
  Evaluatable->False,
  CellTags->{
  "nonlinear coupled system of partial differential equations", 
    "non-classical symmetries", "infinitesimals"}],
Cell[33798, 969, 127, 2, 45, "Input"],
Cell[33928, 973, 79, 1, 27, "Input"],
Cell[34010, 976, 584, 14, 96, "Text",
  Evaluatable->False,
  CellTags->"Save[]"],

Cell[CellGroupData[{
Cell[34619, 994, 177, 3, 45, "Input"],
Cell[34799, 999, 744, 18, 81, "Output"]
}, Open  ]],
Cell[35558, 1020, 1000, 21, 201, "Text",
  Evaluatable->False,
  CellTags->"nonlinear determining equations"],
Cell[36561, 1043, 175, 3, 81, "Input"],
Cell[36739, 1048, 216, 7, 33, "Text",
  Evaluatable->False,
  CellTags->"Lie[]"],

Cell[CellGroupData[{
Cell[36980, 1059, 177, 3, 45, "Input"],
Cell[37160, 1064, 494, 14, 63, "Output"]
}, Open  ]],
Cell[37669, 1081, 643, 15, 117, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],
Cell[38315, 1098, 64, 1, 27, "Input"],
Cell[38382, 1101, 50, 0, 33, "Text"],
Cell[38435, 1103, 85, 1, 27, "Input"],
Cell[38523, 1106, 242, 10, 33, "Text",
  Evaluatable->False],
Cell[38768, 1118, 79, 1, 27, "Input"],
Cell[38850, 1121, 101, 2, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[38976, 1127, 271, 5, 63, "Input"],
Cell[39250, 1134, 394, 10, 59, "Output"]
}, Open  ]],
Cell[39659, 1147, 976, 22, 180, "Text",
  Evaluatable->False,
  CellTags->{"non-classical group", "Lie's point symmetry procedure"}],

Cell[CellGroupData[{
Cell[40660, 1173, 112, 2, 27, "Input"],
Cell[40775, 1177, 221, 5, 69, "Message"],
Cell[40999, 1184, 3556, 105, 203, "Output"]
}, Open  ]],
Cell[44570, 1292, 979, 28, 159, "Text",
  Evaluatable->False,
  CellTags->"heat equation"],

Cell[CellGroupData[{
Cell[45574, 1324, 421, 7, 99, "Input"],
Cell[45998, 1333, 53, 1, 30, "Output"]
}, Open  ]],
Cell[46066, 1337, 224, 5, 54, "Text",
  CellTags->"reduction of the non-classical determining equations"],

Cell[CellGroupData[{
Cell[46315, 1346, 264, 5, 45, "Input"],
Cell[46582, 1353, 610, 16, 127, "Output"]
}, Open  ]],
Cell[47207, 1372, 435, 12, 75, "Text",
  CellTags->
  "similarity representation of the nonlinear determining equations"],

Cell[CellGroupData[{
Cell[47667, 1388, 178, 4, 27, "Input"],
Cell[47848, 1394, 488, 12, 30, "Output"]
}, Open  ]],
Cell[48351, 1409, 335, 11, 54, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[48711, 1424, 119, 3, 27, "Input"],
Cell[48833, 1429, 97, 2, 33, "Output"]
}, Open  ]],
Cell[48945, 1434, 118, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[49088, 1441, 151, 3, 27, "Input"],
Cell[49242, 1446, 76, 1, 37, "Output"]
}, Open  ]],
Cell[49333, 1450, 356, 12, 54, "Text",
  CellTags->"solution of the non-classical determining equations"],

Cell[CellGroupData[{
Cell[49714, 1466, 322, 6, 63, "Input"],
Cell[50039, 1474, 119, 2, 37, "Output"]
}, Open  ]],
Cell[50173, 1479, 188, 5, 54, "Text",
  CellTags->"pure function"],

Cell[CellGroupData[{
Cell[50386, 1488, 212, 4, 55, "Input"],
Cell[50601, 1494, 635, 22, 65, "Output"]
}, Open  ]],
Cell[51251, 1519, 170, 4, 54, "Text"],

Cell[CellGroupData[{
Cell[51446, 1527, 65, 1, 27, "Input"],
Cell[51514, 1530, 43, 1, 30, "Output"]
}, Open  ]],
Cell[51572, 1534, 142, 4, 33, "Text",
  CellTags->"non-classical infinitesimals"],

Cell[CellGroupData[{
Cell[51739, 1542, 86, 1, 27, "Input"],
Cell[51828, 1545, 82, 1, 37, "Output"]
}, Open  ]],
Cell[51925, 1549, 179, 4, 54, "Text"],

Cell[CellGroupData[{
Cell[52129, 1557, 275, 5, 45, "Input"],
Cell[52407, 1564, 180, 3, 69, "Message"],
Cell[52590, 1569, 675, 19, 81, "Output"]
}, Open  ]],
Cell[53280, 1591, 387, 9, 75, "Text",
  CellTags->"similarity representation"],

Cell[CellGroupData[{
Cell[53692, 1604, 602, 14, 27, "Input"],
Cell[54297, 1620, 150, 3, 47, "Output"]
}, Open  ]],
Cell[54462, 1626, 262, 9, 54, "Text"],

Cell[CellGroupData[{
Cell[54749, 1639, 171, 3, 27, "Input"],
Cell[54923, 1644, 144, 3, 46, "Output"]
}, Open  ]],
Cell[55082, 1650, 247, 8, 54, "Text"],

Cell[CellGroupData[{
Cell[55354, 1662, 273, 5, 45, "Input"],
Cell[55630, 1669, 104858, 2282, 258, 54490, 1656, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[160503, 3954, 587, 15, 117, "Text",
  CellTags->"find non-classical solutions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[161127, 3974, 90, 1, 49, "Subsection",
  CellTags->"The Boussinesq equation"],
Cell[161220, 3977, 201, 7, 33, "Text",
  CellTags->"Boussinesq equation"],
Cell[161424, 3986, 145, 3, 30, "NumberedEquation"],
Cell[161572, 3991, 1345, 28, 201, "Text",
  CellTags->{
  "surface wave", "plasma physics", 
    "point symmetries of the Boussinesq equation", "direct method", 
    "pseudo automatic calculation of non-classical symmetries"}],
Cell[162920, 4021, 133, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[163078, 4030, 236, 4, 64, "Input"],
Cell[163317, 4036, 275, 8, 31, "Output"]
}, Open  ]],
Cell[163607, 4047, 126, 1, 33, "Text",
  CellTags->"point symmetries of the Boussinesq equation"],

Cell[CellGroupData[{
Cell[163758, 4052, 129, 2, 45, "Input"],
Cell[163890, 4056, 619, 21, 57, "Output"]
}, Open  ]],
Cell[164524, 4080, 950, 23, 159, "Text",
  CellTags->"NonClassicalPointSymmetries[]"],

Cell[CellGroupData[{
Cell[165499, 4107, 120, 2, 45, "Input"],
Cell[165622, 4111, 3714, 81, 619, "Output"]
}, Open  ]],
Cell[169351, 4195, 773, 21, 138, "Text"],

Cell[CellGroupData[{
Cell[170149, 4220, 232, 5, 63, "Input"],
Cell[170384, 4227, 2303, 54, 325, "Output"]
}, Open  ]],
Cell[172702, 4284, 587, 13, 117, "Text",
  CellTags->{"PDESolve[]", "solution branches"}],

Cell[CellGroupData[{
Cell[173314, 4301, 93, 1, 27, "Input"],
Cell[173410, 4304, 85, 1, 30, "Output"],
Cell[173498, 4307, 78, 1, 30, "Output"],
Cell[173579, 4310, 197, 4, 30, "Output"],
Cell[173779, 4316, 505, 13, 30, "Output"],
Cell[174287, 4331, 85, 1, 30, "Output"],
Cell[174375, 4334, 78, 1, 30, "Output"],
Cell[174456, 4337, 197, 4, 30, "Output"],
Cell[174656, 4343, 505, 13, 30, "Output"],
Cell[175164, 4358, 3761, 100, 117, "Output"]
}, Open  ]],
Cell[178940, 4461, 1088, 36, 96, "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{
Cell[180053, 4501, 124, 2, 27, "Input"],
Cell[180180, 4505, 1917, 57, 117, "Output"]
}, Open  ]],
Cell[182112, 4565, 788, 23, 96, "Text"],

Cell[CellGroupData[{
Cell[182925, 4592, 87, 1, 27, "Input"],
Cell[183015, 4595, 1016, 34, 91, "Output"]
}, Open  ]],
Cell[184046, 4632, 500, 13, 96, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[184571, 4649, 244, 5, 45, "Input"],
Cell[184818, 4656, 1016, 34, 91, "Output"]
}, Open  ]],
Cell[185849, 4693, 737, 21, 117, "Text"],

Cell[CellGroupData[{
Cell[186611, 4718, 183, 3, 45, "Input"],
Cell[186797, 4723, 89, 1, 42, "Output"]
}, Open  ]],
Cell[186901, 4727, 259, 5, 54, "Text",
  CellTags->{"LieReduction[]", "reduction of the Boussinesq equation"}],

Cell[CellGroupData[{
Cell[187185, 4736, 267, 5, 45, "Input"],
Cell[187455, 4743, 1616, 37, 127, "Output"]
}, Open  ]],
Cell[189086, 4783, 408, 11, 75, "Text",
  CellTags->"similarity representation"],

Cell[CellGroupData[{
Cell[189519, 4798, 164, 3, 27, "Input"],
Cell[189686, 4803, 687, 16, 51, "Output"]
}, Open  ]],
Cell[190388, 4822, 188, 3, 54, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[190601, 4829, 155, 3, 38, "Input"],
Cell[190759, 4834, 800, 19, 50, "Output"]
}, Open  ]],
Cell[191574, 4856, 712, 20, 117, "Text",
  CellTags->"quadratures"],

Cell[CellGroupData[{
Cell[192311, 4880, 97, 2, 27, "Input"],
Cell[192411, 4884, 378, 13, 41, "Output"]
}, Open  ]],
Cell[192804, 4900, 510, 7, 117, "Text",
  CellTags->{"numerical integration", "similarity variable"}],

Cell[CellGroupData[{
Cell[193339, 4911, 904, 21, 63, "Input"],
Cell[194246, 4934, 1220, 32, 110, "Output"]
}, Open  ]],
Cell[195481, 4969, 323, 7, 75, "Text"],

Cell[CellGroupData[{
Cell[195829, 4980, 346, 6, 81, "Input"],
Cell[196178, 4988, 21261, 771, 190, 10173, 630, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[217454, 5762, 1091, 22, 180, "Text",
  CellTags->{
  "numerical solution", "similarity transformation", 
    "NonClassicalPointSymmetries[]", "PDESolve[]"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[218582, 5789, 96, 1, 49, "Subsection",
  CellTags->"The Fokker-Planck equation"],
Cell[218681, 5792, 728, 14, 117, "Text",
  CellTags->{
  "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
    "condensed matter physics", "quantum optics", "chemical physics", 
    "fluctuations", "FP-equation"}],
Cell[219412, 5808, 142, 3, 30, "NumberedEquation"],
Cell[219557, 5813, 1067, 32, 138, "Text",
  CellTags->{
  "Brownian particle in a liquid", "diffusion coefficient", 
    "drift coefficient"}],

Cell[CellGroupData[{
Cell[220649, 5849, 181, 3, 27, "Input"],
Cell[220833, 5854, 252, 8, 30, "Output"]
}, Open  ]],
Cell[221100, 5865, 89, 1, 33, "Text",
  CellTags->"point symmetries"],

Cell[CellGroupData[{
Cell[221214, 5870, 115, 2, 45, "Input"],
Cell[221332, 5874, 3099, 93, 129, "Output"]
}, Open  ]],
Cell[224446, 5970, 545, 18, 96, "Text",
  CellTags->"heat equation"],
Cell[224994, 5990, 688, 18, 75, "Text"],

Cell[CellGroupData[{
Cell[225707, 6012, 499, 13, 29, "Input"],
Cell[226209, 6027, 1793, 39, 217, "Output"]
}, Open  ]],
Cell[228017, 6069, 234, 6, 54, "Text",
  CellTags->"non-classical determining equations"],

Cell[CellGroupData[{
Cell[228276, 6079, 223, 5, 45, "Input"],
Cell[228502, 6086, 860, 20, 81, "Output"]
}, Open  ]],
Cell[229377, 6109, 908, 27, 159, "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{
Cell[230310, 6140, 87, 1, 27, "Input"],
Cell[230400, 6143, 85, 1, 30, "Output"],
Cell[230488, 6146, 78, 1, 30, "Output"],
Cell[230569, 6149, 214, 5, 30, "Output"],
Cell[230786, 6156, 214, 5, 30, "Output"],
Cell[231003, 6163, 3086, 81, 95, "Output"]
}, Open  ]],
Cell[234104, 6247, 1161, 36, 117, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[235290, 6287, 191, 4, 27, "Input"],
Cell[235484, 6293, 450, 12, 59, "Output"]
}, Open  ]],
Cell[235949, 6308, 88, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[236062, 6315, 106, 2, 27, "Input"],
Cell[236171, 6319, 219, 5, 49, "Message"],
Cell[236393, 6326, 5796, 171, 239, "Output"]
}, Open  ]],
Cell[242204, 6500, 833, 18, 138, "Text",
  CellTags->{
  "point symmetries of the non-classical determining equations", 
    "LieReduction[]"}],

Cell[CellGroupData[{
Cell[243062, 6522, 469, 8, 81, "Input"],
Cell[243534, 6532, 74, 1, 30, "Output"]
}, Open  ]],
Cell[243623, 6536, 323, 11, 33, "Text"],

Cell[CellGroupData[{
Cell[243971, 6551, 270, 5, 45, "Input"],
Cell[244244, 6558, 179, 3, 70, "Output"],
Cell[244426, 6563, 960, 24, 131, "Output"]
}, Open  ]],
Cell[245401, 6590, 376, 13, 54, "Text",
  CellTags->"similarity function"],

Cell[CellGroupData[{
Cell[245802, 6607, 212, 3, 45, "Input"],
Cell[246017, 6612, 435, 13, 59, "Output"]
}, Open  ]],
Cell[246467, 6628, 192, 7, 33, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[246684, 6639, 765, 17, 63, "Input"],
Cell[247452, 6658, 269, 5, 91, "Output"]
}, Open  ]],
Cell[247736, 6666, 866, 30, 75, "Text",
  CellTags->{"special function", "Erfi[]"}],

Cell[CellGroupData[{
Cell[248627, 6700, 424, 9, 81, "Input"],
Cell[249054, 6711, 659, 13, 253, "Output"]
}, Open  ]],
Cell[249728, 6727, 150, 3, 54, "Text"],

Cell[CellGroupData[{
Cell[249903, 6734, 102, 2, 27, "Input"],
Cell[250008, 6738, 45, 1, 30, "Output"]
}, Open  ]],
Cell[250068, 6742, 270, 5, 54, "Text",
  CellTags->"non-classical symmetry transformations of the FP-equation"],

Cell[CellGroupData[{
Cell[250363, 6751, 416, 8, 81, "Input"],
Cell[250782, 6761, 3053, 89, 119, "Output"]
}, Open  ]],
Cell[253850, 6853, 949, 17, 201, "Text",
  CellTags->{
  "reduction of the FP-equation", "infinitesimals", "invariants"}],
Cell[254802, 6872, 147, 3, 54, "Text"],

Cell[CellGroupData[{
Cell[254974, 6879, 218, 4, 45, "Input"],
Cell[255195, 6885, 1176, 34, 91, "Output"]
}, Open  ]],
Cell[256386, 6922, 827, 27, 96, "Text",
  CellTags->"non-classical infinitesimals"],

Cell[CellGroupData[{
Cell[257238, 6953, 247, 5, 45, "Input"],
Cell[257488, 6960, 1205, 34, 75, "Output"]
}, Open  ]],
Cell[258708, 6997, 602, 21, 54, "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{
Cell[259335, 7022, 84, 1, 27, "Input"],
Cell[259422, 7025, 2116, 65, 123, "Output"]
}, Open  ]],
Cell[261553, 7093, 584, 13, 96, "Text",
  CellTags->{"non-classical symmetries", "PDESolve[]", "pure function"}],

Cell[CellGroupData[{
Cell[262162, 7110, 262, 5, 63, "Input"],
Cell[262427, 7117, 2116, 65, 123, "Output"]
}, Open  ]],
Cell[264558, 7185, 337, 9, 54, "Text"],

Cell[CellGroupData[{
Cell[264920, 7198, 168, 3, 63, "Input"],
Cell[265091, 7203, 59, 1, 42, "Output"]
}, Open  ]],
Cell[265165, 7207, 115, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[265305, 7214, 263, 5, 45, "Input"],
Cell[265571, 7221, 603, 19, 79, "Output"]
}, Open  ]],
Cell[266189, 7243, 136, 4, 33, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[266350, 7251, 121, 3, 27, "Input"],
Cell[266474, 7256, 84, 1, 30, "Output"]
}, Open  ]],
Cell[266573, 7260, 283, 9, 54, "Text"],

Cell[CellGroupData[{
Cell[266881, 7273, 139, 3, 27, "Input"],
Cell[267023, 7278, 102, 2, 33, "Output"]
}, Open  ]],
Cell[267140, 7283, 600, 18, 96, "Text",
  CellTags->{
  "initial conditions", "non-classical solution of the FP-equation"}],

Cell[CellGroupData[{
Cell[267765, 7305, 333, 6, 63, "Input"],
Cell[268101, 7313, 87008, 2111, 228, 54921, 1710, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[355124, 9427, 651, 13, 138, "Text",
  CellTags->"combination of non-classical and classical method"],
Cell[355778, 9442, 327, 7, 75, "Text",
  Evaluatable->False],
Cell[356108, 9451, 148, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

