(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    128092,       4022]*)
(*NotebookOutlinePosition[    152087,       4615]*)
(*  CellTagsIndexPosition[    148131,       4524]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["10", "ChapterLine",
  CounterAssignments->{{"Title", 9}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Solution of Coupled Linear Partial Differential Equations"],

Cell["\<\
Solution of Coupled Linear Partial
Differential Equations\
\>", "Title",
  CounterAssignments->{{"Title", 9}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[CellGroupData[{

Cell[TextData[{
  "10.",
  CounterBox["Section"],
  ".",
  " Introduction"
}], "Section",
  Evaluatable->False,
  TextJustification->1,
  CounterAssignments->{{"Title", 10}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  AspectRatioFixed->True,
  CellTags->"Introduction"],

Cell[TextData[{
  "In this chapter, we discuss the main steps for solving systems of coupled \
linear partial differential equations (PDEs). Such linear PDEs are the result \
of the invariance conditions discussed in C",
  ButtonBox["hapter 5",
    ButtonData:>{"symmet5.nb", 
      "Point Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " on point symmetries, in C",
  ButtonBox["hapter 7 ",
    ButtonData:>{"symmet65.nb", 
      "Potential Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " on potential symmetries, in C",
  ButtonBox["hapter 8",
    ButtonData:>{"symmet7.nb", 
      "Approximate Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " on approximate symmetries, and in C",
  ButtonBox["hapter 9",
    ButtonData:>{"Symmet75.nb", 
      "Generalized Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " on generalized symmetries. Especially for these types of symmetries, the \
following procedures are very successful. The main topic here is the \
automatic derivation of solutions. This self-governed method is the basis for \
an efficient calculation of symmetries by computer algebra programs."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "coupled linear partial differential equations", "invariance conditions", 
    "point symmetries", "potential symmetries", "approximate symmetries", 
    "generalized symmetries", "automatic derivation of solutions", 
    "computer algebra"}],

Cell[TextData[{
  "The ideas behind this automatic procedure goes back to works of ",
  ButtonBox["Riquier [1910] ",
    ButtonData:>{"Literat.nb", "Riquier-1910"},
    ButtonStyle->"Hyperlink"],
  "and ",
  ButtonBox["Janet [1920]",
    ButtonData:>{"Literat.nb", "Janet-1920"},
    ButtonStyle->"Hyperlink"],
  ". Their basic ideas for solving differential equations are extended by a \
few heuristics. The incorporation of heuristics into solution procedures \
simplifies the task, as ",
  ButtonBox["Kamke [1977]",
    ButtonData:>{"Literat.nb", "Kamke-1977"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Schwarz [1992]",
    ButtonData:>{"Literat.nb", "Schwarz-1992"},
    ButtonStyle->"Hyperlink"],
  " remark. However, the use of heuristic solution steps by itself are not \
sufficient to succeed. The combination of a regular procedure and heuristics \
establish a method which is successful for a very large number of linear \
PDEs. Our experience is that the combination of a differential Groebner \
technique with heuristic steps is very successful in solving linear PDEs. The \
central steps for finding solutions of a linear overdetermined system of PDEs \
consists of the following:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"automatic procedure", "differential Groebner technique"}],

Cell["The decoupling of the equations by a completion algorithm.", "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"decoupling of the equations"],

Cell["The integration of simple equations.", "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"integration of simple equations"],

Cell["The simplification of the equations.", "ListItem",
  CellDingbat->"3.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"simplification of the equations"],

Cell[TextData[{
  "These three steps are essential in the solution procedure. Since the PDEs \
are, in general, coupled in a non-trivial form, it is recommended to \
disconnect the equations. This disjoining of differential equations results \
into a ",
  StyleBox["general canonical form",
    FontSlant->"Italic"],
  ". The term general canonical form was introduced by Janet and Riquier at \
the beginning of the 20th century. These authors developed a procedure to \
create an equivalent and simplified representation of a given system of PDEs. \
Thus, our discussion is not only restricted to heuristic solution steps for \
PDEs but also includes a step of standardization. "
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "solution procedure", "general canonical form", "Janet", "Riquier"}],

Cell["\<\
To keep the integration procedure for PDEs as simple as possible, we first \
calculate the general canonical form to find a simpler representation of the \
equations. The first section of this chapter discusses the theory of the \
general canonical algorithm due to Janet and Riquier. The second section \
describes the heuristic integration steps to solve the simplified \
equations.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "integration procedure for PDEs", "general canonical form", 
    "general canonical algorithm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "10.",
  CounterBox["Section"],
  ".",
  " General Canonical Form of PDEs"
}], "Section",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"General Canonical Form of PDEs"],

Cell[TextData[{
  "In this section, we will describe a method originally given by Riquier and \
Janet which they called ",
  StyleBox["forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]",
    FontSlant->"Italic"],
  " (general canonical form) and later discussed by Thomas [",
  ButtonBox["1929",
    ButtonData:>{"Literat.nb", "Thomas-1929"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["1934",
    ButtonData:>{"Literat.nb", "Thomas-1934"},
    ButtonStyle->"Hyperlink"],
  "] in the investigation of coupled differential equations. The present \
implementation in ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "uses a Groebner basis algorithm originally designed to solve polynomial \
equations of higher order (",
  ButtonBox["Buchberger [1985]",
    ButtonData:>{"Literat.nb", "Buchberger-1985"},
    ButtonStyle->"Hyperlink"],
  ") adapted and generalized for differential equations. The aim of our \
Groebner algorithm for differential equations is to transform a given system \
of equations to an equivalent decoupled representation. Before we describe \
our procedure to derive a general canonical form, let us define what we \
understand by a canonical form."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "general canonical form", 
    "forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]", 
    "coupled differential equations", "Groebner basis algorithm", 
    "Groebner algorithm for differential equations"}],

Cell["Definition: Canonical form", "Definition",
  CellTags->"Definition: Canonical form"],

Cell[TextData[
"A general canonical form of a system of partial differential equations is a \
simplified form of a system in such a representation that all Schwarzian \
integrability conditions are satisfied. It is essential that the solution \
manifold under such a transformation is conserved. \[EmptyCircle]"], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Schwarzian integrability conditions"],

Cell["\<\
This verbal definition states the essential property of a general canonical \
form simplifying the original equations but does not clarify how such a \
representation of equations can be calculated.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"simplifying the original equations"],

Cell[TextData[{
  "In practical applications, it is necessary to have a constructive \
definition available. However, the above definition does not explain how a \
general canonical form may be calculated and thus gives room for several \
algorithms. In fact, there exist several more or less different procedures in \
the literature approaching the definition of a general canonical form (cf. ",
  ButtonBox["Schwarz [1985]",
    ButtonData:>{"Literat.nb", "Schwarz-1985"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Reid [1993]",
    ButtonData:>{"Literat.nb", "Reid-1993"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Mansfield [1992]",
    ButtonData:>{"Literat.nb", "Mansfield-1992"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Carr\[AGrave]-Ferro [1993]",
    ButtonData:>{"Literat.nb", "Carra-Ferro-1993"},
    ButtonStyle->"Hyperlink"],
  "). "
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"several algorithms"],

Cell["\<\
In the following, we will discuss five steps which are sufficient to \
calculate a general canonical form. One of these basic steps uses the \
knowledge that all equations involved can be solved for a certain derivative \
which is called the leading derivative, meaning that a leading derivative can \
be identified which may depend on other independent derivatives. We further \
assume that the derivatives are unique. Uniqueness of the derivatives \
suggests that independent derivatives cannot be represented by other \
derivatives in the system. Again, we realize that derivatives are the basic \
tools of our calculations.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
After these preliminaries, let us state the five sufficient properties of a \
general canonical form:\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"properties of a general canonical form"],

Cell["\<\
All equations are solved in such a way that the leading derivatives \
occur only on the left-hand side of the equations.\
\>", "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"leading derivatives"],

Cell["\<\
In a canonical representation of equations, it is impossible that \
the same derivatives occur on the left-hand side and on the right-hand side \
of the equation.\
\>", "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
All derivatives of the left-hand side of the equations are \
disjunct.\
\>", "ListItem",
  CellDingbat->"3.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"disjunct"],

Cell["\<\
There exists no derivative which is a non-trivial derivative of any \
derivative occurring on the left-hand side of the equations.\
\>", "ListItem",\

  CellDingbat->"4.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"nontrivial derivative"],

Cell["All the Schwarzian integrability conditions are satisfied.", "ListItem",
  CellDingbat->"5.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Schwarzian integrability conditions"],

Cell[TextData[{
  "The condition that a leading derivative exists will require that we have \
an appropriate measure for detecting it as a leading derivative. An \
appropriate tool for this decision is the order of a differential expression. \
All of the remaining four steps are based on the ordering idea of \
derivatives. There are many ordering schemes suited; all have various \
advantages for different purposes. For example, a lexicographic ordering \
yields elimination ideals, while a total degree ordering is used to obtain \
the integrability conditions. The total degree ordering is useful in getting \
the initial data for convergent formal power series solutions. In general, \
the ordering scheme used, denoted here by ",
  Cell[BoxData[
      \(TraditionalForm\`ord()\)]],
  ", can be chosen arbitrarily. However, the essential point is that we are \
consistent in its application. Following Janet, this means that an arbitrary \
differential operator ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\)]],
  " has to satisfy the following:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "elimination ideals", "total degree ordering", "lexicographic ordering"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`ord(\[PartialD]\ u)\  > \ \ ord(u)\)]],
  ","
}], "ListItem",
  CellDingbat->"(i)",
  CellMargins->{{92, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  FormBox[\(ord(u\^1\),
                    "TraditionalForm"], ")"}], " ", ">", " ", 
                FormBox[\(ord(u\^2\),
                  "TraditionalForm"]}], ")"}], "  ", "\[LongRightArrow]", 
            " ", 
            RowBox[{"ord", "(", 
              RowBox[{"\[PartialD]", " ", 
                FormBox[\(u\^1\),
                  "TraditionalForm"]}], ")"}]}], " ", ">", " ", 
          RowBox[{"ord", "(", 
            RowBox[{"\[PartialD]", " ", 
              FormBox[\(u\^2\),
                "TraditionalForm"]}], ")"}]}], TraditionalForm]]],
  "."
}], "ListItem",
  CellDingbat->"(ii)",
  CellMargins->{{92, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
These two rules summarize the idea that the order of a differential \
equation is always greater than the order of an ordinary function and that \
the lexicographic ordering has a direct consequence on the ordering of \
derivatives. In our algorithm, we realized these concept by an ordering \
scheme which satisfies the following properties:\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["Total ordering of the derivatives", "ListItem",
  CellDingbat->"(a)",
  CellMargins->{{92, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"total ordering of derivatives"],

Cell[BoxData[
    \(\(\tord \((u\_J\%\[Alpha])\)\  > \ 
      ord \((u\_K\%\[Alpha])\)\ \ \ \ \ if\ \ #  J\  > \ #  K\)\)], 
  "DisplayFormula",
  FontFamily->"Times"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`#  J\)]],
  " denotes the number of ",
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  "."
}], "ListItem",
  CellMargins->{{92, Inherited}, {Inherited, Inherited}}],

Cell["Lexicographic ordering of the derivatives", "ListItem",
  CellDingbat->"(b)",
  CellMargins->{{92, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"lexicographic ordering of the derivatives"],

Cell[BoxData[
    \(\(\tord \((\[PartialD]\_\(x\_i\)\ u\^\[Alpha])\)\  > \ 
      ord \((\[PartialD]\_\(x\_j\)\ u\^\[Alpha])\)\ \ if\ \ i\  > 
      \(j . \)\)\)], "DisplayFormula",
  FontFamily->"Times"],

Cell["Lexicographic ordering of function names", "ListItem",
  CellDingbat->"(c)",
  CellMargins->{{92, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"lexicographic ordering of function names"],

Cell[BoxData[
    \(\(\tord \((u\^\[Alpha])\)\  > \ 
      ord \((u\^\[Beta])\)\ \ \ if\ \ \[Alpha]\ \  > \(\[Beta] . \)\)\)], 
  "DisplayFormula",
  FontFamily->"Times"],

Cell["\<\
We note that the ordering scheme used has an influence on the representation \
of the equations. However, it does not change the solution manifold of the \
equations. Calculating the general canonical form of a given system of \
equations, we only operate on equivalence relations. This guarantees that the \
solution manifold is not changed.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"solution manifold of an equations"],

Cell["\<\
The first step in calculating a general canonical form is thus the solution \
of the equations with respect to the highest derivative. The solution is used \
to eliminate all occurrences of the highest derivatives in the remaining \
equations. Thus, the procedure is based on identifying an equation containing \
the highest derivative. The remaining equations can then be treated by the \
above ordering scheme. It is also crucial to insert the solution for the \
highest derivatives into the remaining equations. If we carry out the steps \
accurately, we can satisfy conditions 1, 2, and 3 of  the canonical \
algorithm.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"general canonical form", "canonical algorithm"}],

Cell["\<\
If we have solved all equations for the highest derivatives, we \
next implicitly substitute the derivatives; i.e., we replace all non-trivial \
derivatives by the derivatives of the corresponding terms. At this point, it \
may happen that not all derivatives of the left-hand side are different from \
each other. If this happens, we have to go back to the first step of our \
algorithm and repeat the calculation again. The whole procedure is repeated \
as long a conditions 1 to 4 are satisfied.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
If we can satisfy the first four steps of the general canonical form \
algorithm, we can proceed to calculate the integrability conditions for the \
complete system. The integrability conditions serve to terminate the \
algorithm. If we cannot find new integrability conditions, we say that the \
original system of PDEs is, in general, a canonical form.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"integrability conditions"],

Cell["\<\
The explicit calculation of the integrability conditions works in \
the following way. We differentiate two of the equations containing different \
derivatives of the same function on the left-hand side. If we do the \
differentiation on both sides in an appropriate way, we create two identical \
expressions on the left-hand side. Subtraction of the two equations results \
in a new integrability condition. If we find such a relation, we start again \
with step 1 of the general canonical algorithm. The last step to find the \
integrability condition can be mathematically formulated as\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(u\_J\%\[Alpha]\),
              "TraditionalForm"], " ", "=", " ", 
            FormBox[
              RowBox[{
                FormBox[
                  RowBox[{
                    FormBox[\(G(x\_i\),
                      "TraditionalForm"], ",", \(u\^\[Beta]\)}],
                  "TraditionalForm"], ",", \(u\_L\%\[Beta]\)}],
              "TraditionalForm"]}], ")"}], ","}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(u\_K\%\[Alpha]\), " ", "=", " ", 
            FormBox[
              RowBox[{
                FormBox[
                  RowBox[{
                    FormBox[\(H(x\_i\),
                      "TraditionalForm"], ",", \(u\^\[Beta]\)}],
                  "TraditionalForm"], ",", \(u\_L\%\[Beta]\)}],
              "TraditionalForm"]}], ")"}], ","}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`L = max(J, K)\)]],
  " and"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`0 = \(u\_L\%\[Alpha]\  - u\_K\%\[Alpha] = 
        G\_\(L - J\) - \(H\_\(L - K\) . \)\)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Using  this procedure, we are able to simplify all types of partial \
differential equations, both linear and non-linear. In practical situations, \
especially for non-linear PDEs, there is a little restriction for the \
termination of the algorithm. This restriction is connected with the unique \
solution of the non-linear equation. For example, we all know, as does ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", that the general solution of a quadratic polynomial consists of two \
solutions. Thus, the program has to know what branch of solution it should \
take next. In a general case, we have to deal with more complicated solution \
branches than just a bifurcation. So, if we are unable to uniquely handle the \
set of solutions for non-linear equations in the highest derivative, we \
cannot derive a general canonical form of the original equations.Thus, the \
algorithm for calculating the general canonical form bifurcates to an \
interactive version if a set of solutions for the highest derivatives exists. \
So, the occurrence of more than one solution will force us to examine \
different representations of the canonical form."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"nonlinear PDEs"],

Cell[CellGroupData[{

Cell["10.2.1 Application of the General Canonical Form Algorithm", 
  "Subsection",
  CellTags->"Application of the General Form Algorithm"],

Cell[TextData[{
  "The following examples demonstrate the application of the general \
canonical form algorithm. As a first step, we recall how the original \
Groebner basis algorithm for polynomials works and how this algorithm can be \
used to solve PDEs. Groebner bases appear in many modern algebraic algorithms \
and applications. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the function ",
  StyleBox["GroebnerBasis[]", "MmaText"],
  " takes a set of polynomials and reduces this set to a canonical form from \
which many properties can be deduced. An important feature is that the set of \
polynomials obtained always has exactly the same collection of common roots \
as the original set. Thus, a Groebner basis is useful if one is interested in \
the solution of a system of polynomials. The solutions, if they exist, are \
the invariants of the representations. Groebner bases were first introduced \
in the mid-1960s by Hironaka (who called them \"standard bases\") and, \
independently, later by Buchberger in his Ph.D. thesis. The name ",
  StyleBox["Groebner bases",
    FontSlant->"Italic"],
  " was coined by Buchberger to honor his thesis adviser W. Groebner. The \
Groebner basis representation has the merit that it is much easier to solve \
than the original set of polynomials. We can demonstrate this behavior by the \
following example:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{
  "GroebnerBasis[]", "Groebner basis", "polynomials", "standard bases"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(poly1\  = \ x\^2\ y\  + \ y\  + 4\)], "Input"],

Cell[BoxData[
    \(4 + y + x\^2\ y\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(poly2\  = \ x\ y\^2\  + \ 1\)], "Input"],

Cell[BoxData[
    \(1 + x\ y\^2\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The Groebner basis of this set of polynomials is determined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  by"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(gpoly\  = \ GroebnerBasis[{poly1, poly2}, {x, y}]\)], "Input"],

Cell[BoxData[
    \({1 + 4\ y\^3 + y\^4, x - 4\ y - y\^2}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result shows that the second-order set of polynomials can be \
represented by a fourth-order polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " and a linear relation in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The solution of these two polynomials are"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Thread[gpoly == {0, 0}], {x, y}] // N\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-2.23011977845154563`\), 
        y \[Rule] \(-0.669631546695256751`\)}, {
        x \[Rule] \(-0.0629970631217302567`\), 
        y \[Rule] \(-3.98418823121151177`\)}, {
        x \[Rule] 
          \(1.14655842078663861`\[InvisibleSpace]\) - 
            2.40900345379124036`\ I, 
        y \[Rule] 
          \(0.326909888953384575`\[InvisibleSpace]\) - 
            0.517640039527869433`\ I}, {
        x \[Rule] 
          \(1.14655842078663861`\[InvisibleSpace]\) + 
            2.40900345379124036`\ I, 
        y \[Rule] 
          \(0.326909888953384575`\[InvisibleSpace]\) + 
            0.517640039527869433`\ I}}\)], "Output"]
}, Open  ]],

Cell["\<\
According to the fourth order of the first polynomial, we find two real \
distinct solutions and two solutions which are complex conjugate to each \
other. The direct solution of the coupled system delivers the same result:\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{poly1\  == \ 0, poly2\  == \ 0}, {x, y}]\  // \ N\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-2.23011977845154563`\), 
        y \[Rule] \(-0.669631546695256751`\)}, {
        x \[Rule] \(-0.0629970631217302567`\), 
        y \[Rule] \(-3.98418823121151177`\)}, {
        x \[Rule] 
          \(1.14655842078663861`\[InvisibleSpace]\) - 
            2.40900345379124036`\ I, 
        y \[Rule] 
          \(0.326909888953384575`\[InvisibleSpace]\) - 
            0.517640039527869433`\ I}, {
        x \[Rule] 
          \(1.14655842078663861`\[InvisibleSpace]\) + 
            2.40900345379124036`\ I, 
        y \[Rule] 
          \(0.326909888953384575`\[InvisibleSpace]\) + 
            0.517640039527869433`\ I}}\)], "Output"]
}, Open  ]],

Cell["\<\
Another example, which at first glance, is very similar to the example \
examined above starts from the two polynomials\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(poly1\  = \ x^2\ y\  + \ y\  + 4\)], "Input"],

Cell[BoxData[
    \(4 + y + x\^2\ y\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(poly2\  = \ x\ y^2\)], "Input"],

Cell[BoxData[
    \(x\ y\^2\)], "Output"]
}, Open  ]],

Cell["The Groebner basis of the polynomials is given by", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Groebner basis"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gbasis\  = \ GroebnerBasis[{poly1, poly2}, {x, y}]\)], "Input"],

Cell[BoxData[
    \({4 + y, x}\)], "Output"]
}, Open  ]],

Cell["\<\
The solution of these polynomials follow by solving the basis\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Thread[gbasis == {0, 0}], {x, y}]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0, y \[Rule] \(-4\)}}\)], "Output"]
}, Open  ]],

Cell["The direct solution of the set of equations yields", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{poly1 == 0, poly2 == 0}, {x, y}]\)], "Input"],

Cell[BoxData[
    \({{y \[Rule] \(-4\), x \[Rule] 0}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "the same result. To understand what goes on behind the function ",
  StyleBox["GroebnerBasis[]", "MmaText"],
  ", we repeat the calculation for the last example a second time by hand."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"GroebnerBasis[]"],

Cell[TextData[{
  "The Groebner basis technique to solve sets of polynomials works manually \
as follows. The present equation ",
  StyleBox["poly",
    FontSlant->"Italic"],
  "1 and ",
  StyleBox["poly",
    FontSlant->"Italic"],
  "2 are decoupled by multiplying the polynomials with appropriate variables \
and adding the result to another polynomial. The starting equations are"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"2", " ", 
              FormBox[\(x\^2\),
                "TraditionalForm"], " ", "y"}], " ", "+", " ", "y", " ", "+", 
            " ", "4"}], " ", "=", " ", "0"}], ","}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"                       ", 
        RowBox[{
          RowBox[{"x", " ", 
            FormBox[\(y\^2\),
              "TraditionalForm"]}], " ", "=", "0."}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  "Our aim is to separate both equations. We first multiply the first \
equation by the factor ",
  Cell[BoxData[
      \(TraditionalForm\`\(-y\)\)]],
  " and the second by the factor ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  ". After the multiplication, we add the results and find"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"     ", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"2", " ", 
                FormBox[\(x\^2\),
                  "TraditionalForm"], " ", "y"}], " ", "+", " ", "y", " ", 
              "+", " ", "4"}], "=", "0"}], ","}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"                             ", 
        RowBox[{
          RowBox[{
            RowBox[{"x", " ", 
              FormBox[\(y\^2\),
                "TraditionalForm"]}], " ", "=", " ", "0"}], ","}]}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(y\^2\),
              "TraditionalForm"], " ", "+", " ", \(4\ y\)}], " ", "=", " ", 
          RowBox[{
            RowBox[{"0", " ", "\[LongRightArrow]", " ", 
              FormBox[\(y\^2\),
                "TraditionalForm"]}], "=", \(\(-4\) y\)}]}], ";"}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
substituting the result of (10.8) into equation (10.7) and \
eliminating the factor 4 by division, we get\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"2", " ", 
              FormBox[\(x\^2\),
                "TraditionalForm"], " ", "y"}], " ", "+", " ", "y", " ", "+", 
            " ", "4"}], " ", "=", " ", "0"}], ","}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
    \(x\ y\  = \ 0, \)\)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"                 ", 
        RowBox[{
          RowBox[{
            FormBox[\(y\^2\),
              "TraditionalForm"], " ", "+", " ", \(4  y\)}], " ", "=", " ", 
          "0."}]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "If we use equation (10.10) in equation (10.9), we obtain a relation which \
allows us to determine the solution for ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ":"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ 
    \(y\  + \ 4\  = \ \(0\ \ \ \[LongRightArrow]\ y\  = \ \(-4\)\), \)\)\)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(\(x\ y\ \  = \ 0, \)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
    \)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(y\^2\),
              "TraditionalForm"], " ", "+", " ", \(4\ y\)}], " ", "=", " ", 
          "0."}], "                           "}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "The result from equation (10.12) can be used in the remaining two \
equations, (10.13) and (10.14), satisfying the third equation identically and \
delivering the second solution for ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  ". Thus, we get the complete solution of the original set of polynomials to \
 be"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(y\ \  = \ \(-4\), \)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(x\  = \ 0. \ \ \)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "We easily can check that this is the complete solution. Using equation \
(10.13), we observe that either ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " has to vanish. Setting, in a first attempt, ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0\)]],
  ", we observe a contradiction in the first equation, i.e., ",
  Cell[BoxData[
      \(TraditionalForm\`4 = 0\)]],
  ". The other choice, ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  ", will result in the same result derived by the manipulations of the \
equations. The method of manipulating the set of polynomials is identical to \
the algorithm used in the calculation of the Groebner basis. A detailed \
description of the Groebner algorithmic procedure is given by ",
  ButtonBox["Buchberger [1985]",
    ButtonData:>{"Literat.nb", "Buchberger-1985"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"method of manipulating a set of polynomials"],

Cell[TextData[{
  "Our aim is to use the Groebner basis technique to solve partial \
differential equations transformed to a canonical form. The first step for \
handling this problem is to decouple the system of partial differential \
equations. Using the Buchberger algorithm to solve this problem, we need a \
scheme to translate the operations from a differential representation to a \
polynomial representation. The rule to convert differential terms to \
polynomials goes as follows: Use the differentiation order and the variable \
to represent the related polynomial. Reading this transformation in reverse, \
we are able to transform a polynomial into a differential equation. To \
demonstrate this transformation, let us consider the example of polynomials \
examined in the previous example. We also have to introduce a function ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " depending on the two independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". The differential analogue of equations (10.4) and (10.5) read "
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"canonical form", "Buchberger algorithm"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"2", " ", 
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    StyleBox["xxy",
                      FontSlant->"Italic"]],
                  "TraditionalForm"], \(F(x, y)\)}]}], " ", "+", " ", 
            RowBox[{
              FormBox[\(\[PartialD]\_y\),
                "TraditionalForm"], " ", \(F(x, y)\)}], "+", 
            \(4\ \(F(x, y)\)\)}], "  ", "=", " ", "0"}], ","}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"                                                         ", 
        RowBox[{
          RowBox[{
            FormBox[
              SubscriptBox["\[PartialD]", 
                StyleBox["xyy",
                  FontSlant->"Italic"]],
              "TraditionalForm"], \(F(x, y)\)}], "  ", "=", " ", "0."}]}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
The question now is: How can we benefit from the Buchberger method \
of solving polynomials in simplifying this formally equivalent system of \
PDEs?\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"equivalent system of PDEs"],

Cell[TextData[{
  "The answer of this question is that we have to use the same algorithm as \
for polynomials but now with the interpretation of our transformation rule \
that the variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " are replaced by partial derivatives. Using this interpretation, we are \
able to decouple the above system of PDEs. The following calculation will \
demonstrate this. First we apply to equation (10.17) the partial derivative \
with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[PartialD]\_y)\)\)]],
  ". In a second step, we apply the operator ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\) \[PartialD]\_x\)]],
  " to equation (10.18).  Adding the results, we find three relations"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"2", " ", 
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    StyleBox["xxy",
                      FontSlant->"Italic"]],
                  "TraditionalForm"], \(F(x, y)\)}]}], " ", "+", " ", 
            RowBox[{
              FormBox[\(\[PartialD]\_y\),
                "TraditionalForm"], \(F(x, y)\)}], " ", "+", " ", 
            \(4 \( F(x, y)\)\)}], " ", "=", " ", "0"}], ","}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"                                                          ", 
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[
                SubscriptBox["\[PartialD]", 
                  StyleBox["xyy",
                    FontSlant->"Italic"]],
                "TraditionalForm"], \(F(x, y)\)}], "  ", "=", " ", "0"}], 
          ","}]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"                             ", 
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[
                SubscriptBox["\[PartialD]", 
                  StyleBox["yy",
                    FontSlant->"Italic"]],
                "TraditionalForm"], \(F(x, y)\)}], " ", "+", " ", 
            RowBox[{
              FormBox[\(4 \[PartialD]\_y\),
                "TraditionalForm"], \(F(x, y)\)}]}], " ", "=", " ", "0."}]}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["The last equation provides", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[LongRightArrow]", " ", 
          RowBox[{
            FormBox[
              SubscriptBox["\[PartialD]", 
                StyleBox["yy",
                  FontSlant->"Italic"]],
              "TraditionalForm"], \(F(x, y)\)}]}], " ", 
        FormBox[\( = \(-4\) \[PartialD]\_y\),
          "TraditionalForm"], \(F(x, y) . \)}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
Substituting the result (10.22) into equation (10.20) the PDEs become\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"2", " ", 
              RowBox[{
                FormBox[
                  SubscriptBox["\[PartialD]", 
                    StyleBox["xxy",
                      FontSlant->"Italic"]],
                  "TraditionalForm"], \(F(x, y)\)}]}], " ", "+", " ", 
            RowBox[{
              FormBox[\(\[PartialD]\_y\),
                "TraditionalForm"], \(F(x, y)\)}], " ", "+", " ", 
            \(4 \( F(x, y)\)\)}], "  ", "=", " ", "0"}], ","}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
      "                                                              ", 
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[
                SubscriptBox["\[PartialD]", 
                  StyleBox["xy",
                    FontSlant->"Italic"]],
                "TraditionalForm"], \(F(x, y)\)}], " ", "=", " ", "0"}], 
          ","}]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"                               ", 
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[
                SubscriptBox["\[PartialD]", 
                  StyleBox["yy",
                    FontSlant->"Italic"]],
                "TraditionalForm"], \(F(x, y)\)}], " ", "+", " ", 
            RowBox[{
              FormBox[\(4 \[PartialD]\_y\),
                "TraditionalForm"], \(F(x, y)\)}]}], " ", "=", " ", "0."}]}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
Using relation (10.24) of this system, we are able to write (10.23) as\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"           ", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                FormBox[\(\[PartialD]\_y\),
                  "TraditionalForm"], \(F(x, y)\)}], " ", "+", " ", 
              \(4 \( F(x, y)\)\)}], " ", "=", "  ", 
            RowBox[{
              RowBox[{"0", "  ", "\[LongRightArrow]", "  ", 
                RowBox[{
                  FormBox[\(\[PartialD]\_y\),
                    "TraditionalForm"], \(F(x, y)\)}]}], " ", "=", " ", 
              \(\(-4\) \(F(x, y)\)\)}]}], ","}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[
                SubscriptBox["\[PartialD]", 
                  StyleBox["xy",
                    FontSlant->"Italic"]],
                "TraditionalForm"], \(F(x, y)\)}], " ", "=", " ", "0"}], 
          ","}], "                               "}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[
                SubscriptBox["\[PartialD]", 
                  StyleBox["yy",
                    FontSlant->"Italic"]],
                "TraditionalForm"], \(F(x, y)\)}], " ", "+", " ", 
            RowBox[{"4", " ", 
              RowBox[{
                FormBox[\(\[PartialD]\_y\),
                  "TraditionalForm"], \(F(x, y)\)}]}]}], "  ", "=", "  ", 
          "0."}], "                                                           \
    "}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
The result from relation (10.26) can be used to satisfy equation (10.28). \
Substituting expression (10.26) into equation (10.27), we automatically \
decouple the differentiations. At the end, we get a decoupled system of PDEs \
which is equivalent to the original system (10.17) and (10.18):\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(\[PartialD]\_y\),
              "TraditionalForm"], \(F(x, y)\)}], "  ", "=", " ", 
          \(\(-4\) \(F(x, y)\)\)}], ","}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(\[PartialD]\_x\),
              "TraditionalForm"], \(F(x, y)\)}], "  ", "=", " ", "0."}], 
        "                   "}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["The solution of this simplified system of equations is", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{\(F(y)\), " ", "=", " ", 
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\(F\_0\),
                "TraditionalForm"], \(e\^\(\(-4\) y\)\)}],
            "TraditionalForm"], "."}]}], TraditionalForm]], "NumberedEquation",\

  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "It is a simple task to verify that the original equations are also \
satisfied by this solution. Thus, we conclude that the canonical \
representation of the PDEs allows us to derive the solution by a simple \
integration. In fact, the solution also satisfies the original equation. All \
these steps carried out so far by hand can be handled by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". To show how this calculation works, we will first define the \
transformation of polynomials in two variables to a differential \
representation. The transformation rule given is a very simple version of \
transformations for the products of two variables and for the variables \
itself. If the polynomial contains numeric factors, they will be transformed \
to the dependent function. We note that the given rules are only usable for \
handling our special problem but are not designed to allow general \
transformations. The simple transformation to a differential representation \
has the form"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"differential representation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(toDifferentials\  = 
      \ {x^n_.\ y^m_. -> \(\(Derivative[n, m]\)[F]\)[x, y], \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
        y -> \(\(Derivative[0, 1]\)[F]\)[x, y], \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
        x -> \(\(Derivative[1, 0]\)[F]\)[x, y], \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
        a_ /; NumberQ[a] -> \ a\ F[x, y]}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(x\^n_.\ y\^m_.\), "\[Rule]", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((n, m)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}]}], ",", 
        RowBox[{"y", "\[Rule]", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}]}], ",", 
        RowBox[{"x", "\[Rule]", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}]}], ",", 
        \(a_ /; NumberQ[a] \[Rule] a\ F[x, y]\)}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The application of this transformation rule to the two polynomials poly1 and \
poly2 gives us the representation of the linear second-order PDEs:\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(pde1\  = \ poly1\  /. toDifferentials\)], "Input"],

Cell[BoxData[
    RowBox[{\(4\ F[x, y]\), "+", 
      RowBox[{
        SuperscriptBox["F", 
          TagBox[\((0, 1)\),
            Derivative],
          MultilineFunction->None], "[", \(x, y\), "]"}], "+", 
      RowBox[{
        SuperscriptBox["F", 
          TagBox[\((2, 1)\),
            Derivative],
          MultilineFunction->None], "[", \(x, y\), "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pde2\  = \ poly2\  /. toDifferentials\)], "Input"],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["F", 
        TagBox[\((1, 2)\),
          Derivative],
        MultilineFunction->None], "[", \(x, y\), "]"}]], "Output"]
}, Open  ]],

Cell["\<\
The more interesting case in connection with our aim to solve PDEs is the \
case considering the inverse transformation from a differential \
representation to a polynomial one. A simple version for this reduction to a \
polynomial can be defined as follows:\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(backToPolynomials\  = 
      \ {b_.\ \(\(Derivative[m___]\)[F]\)[x___] :> \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
          b\ Apply[Times, {x}^{m}], \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ F[___] -> 1}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"b_.", " ", 
            RowBox[{
              SuperscriptBox["F", 
                TagBox[\((m___)\),
                  Derivative],
                MultilineFunction->None], "[", "x___", "]"}]}], 
          "\[RuleDelayed]", \(b\ Times@@\({x}\^{m}\)\)}], ",", 
        \(F[___] \[Rule] 1\)}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
We note that the given transformation rule is sufficient to handle one \
dependent variable only. The application of our transformation gives us\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(pol1\  = \ pde1\  /. \ backToPolynomials\)], "Input"],

Cell[BoxData[
    \(4 + y + x\^2\ y\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pol2\  = \ pde2\  /. backToPolynomials\)], "Input"],

Cell[BoxData[
    \(x\ y\^2\)], "Output"]
}, Open  ]],

Cell["\<\
These two polynomials are just the polynomials from which we started. We know \
that the Groebner basis algorithm allows us a simplified representation of \
this set by\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Groebner basis"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gbas\  = \ GroebnerBasis[{pol1, pol2}, {x, y}]\)], "Input"],

Cell[BoxData[
    \({4 + y, x}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Applying the transformation rule to a differential representation, we find \
a linear first-order system for the function ",
  StyleBox["F",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(pdegbasis\  = \ gbas\  /. toDifferentials\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(4\ F[x, y]\), "+", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}]}], ",", 
        RowBox[{
          SuperscriptBox["F", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(x, y\), "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Now, using the capabilities of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to solve this system of first-order partial differential equations, we \
end up with the solution. Rewriting the PDEs in a standard form, we can use \
them in the function ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pdes\  = \ Thread[pdegbasis == {0, 0}]; 
    \(pdes // LieTraditionalForm\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(4\ F + F\_y == 0\)},
          {\(F\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ 4, F], 
            Subscript[ F, y]], 0], 
        Equal[ 
          Subscript[ F, x], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution of the first equation shows that the ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " coordinate decays exponentially, while the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " coordinate is included in an arbitrary function denoted by ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "][",
  StyleBox["x",
    FontSlant->"Italic"],
  "]:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1\  = \ DSolve[pdes[\([1]\)], F[x, y], {x, y}]\)], "Input"],

Cell[BoxData[
    \({{F[x, y] \[Rule] E\^\(\(-4\)\ y\)\ \(C[1]\)[x]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution of the second equation shows us that ",
  StyleBox["F ",
    FontSlant->"Italic"],
  "is just a function of ",
  StyleBox["y",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(s2\  = \ DSolve[pdes[\([2]\)], F[x, y], {x, y}]\)], "Input"],

Cell[BoxData[
    \({{F[x, y] \[Rule] \(C[1]\)[y]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, the complete solution of this problem is given by ",
  StyleBox["s1",
    FontSlant->"Italic"],
  " if we set the arbitrary function ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "][",
  StyleBox["x",
    FontSlant->"Italic"],
  "] equal to a constant ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "]:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = \ s1\  /. \ \(C[1]\)[x] -> C[1]\)], "Input"],

Cell[BoxData[
    \({{F[x, y] \[Rule] E\^\(\(-4\)\ y\)\ C[1]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Knowing the solution, we are able to check whether the original equations \
",
  StyleBox["pde1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["pde2",
    FontSlant->"Italic"],
  " are satisfied. To make this check as simple as possible, we convert the \
solution of ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " to a pure function:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution\  = \ F -> Function[{x, y}, F[x, y]]\  /. \ sol[\([1, 1]\)]\)],
   "Input"],

Cell[BoxData[
    \(F \[Rule] Function[{x, y}, E\^\(\(-4\)\ y\)\ C[1]]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Having this representation of the solution available, it is easy to verify \
that the original PDEs are satisfied. The only thing that remains is to \
replace the dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " by the solution:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \({pde1, pde2}\  /. \ solution\)], "Input"],

Cell[BoxData[
    \({0, 0}\)], "Output"]
}, Open  ]],

Cell["\<\
Both checks show that the derived solution, in fact, solves the original \
equations.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "As discussed above in the interactive calculation, a general canonical \
form follows from the application of a differential Groebner basis algorithm. \
The package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " contains a function ",
  StyleBox["GeneralCanonicalForm[]", "MmaText"],
  " supporting this kind of calculation. The function contains a \
generalization of the simple steps presented in the above discussion. To \
demonstrate the automatic calculation of the general canonical form as an \
example, let us recall the manipulations done by hand. All the following \
steps are implemented in the function ",
  StyleBox["GeneralCanonicalForm[],", "MmaText"],
  " allowing the derivation of a canonical representation."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"GeneralCanonicalForm[]", "Groebner basis algorithm"}],

Cell[TextData[{
  "First, let us repeat the ordering for two functions ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\^1 = \(\[Xi]\^1\)(x, y)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\^2 = \(\[Xi]\^2\)(x, y)\)]],
  ". The ordering is defined by"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              FormBox[
                                RowBox[{
                                  FormBox[\(ord(\[PartialD]\_x\),
                                    "TraditionalForm"], \(\[Xi]\^1\)}],
                                "TraditionalForm"], ")"}], " ", ">", " ", 
                            FormBox[
                              RowBox[{
                                FormBox[\(ord(\[PartialD]\_x\),
                                  "TraditionalForm"], \(\[Xi]\^2\)}],
                              "TraditionalForm"]}], ")"}], " ", 
                        FormBox[
                          RowBox[{
                            FormBox[\( > \(ord(\[PartialD]\_y\)\),
                              "TraditionalForm"], \(\[Xi]\^1\)}],
                          "TraditionalForm"]}], ")"}], " ", ">", " ", 
                    FormBox[
                      RowBox[{
                        FormBox[\(ord(\[PartialD]\_y\),
                          "TraditionalForm"], \(\[Xi]\^2\)}],
                      "TraditionalForm"]}], ")"}], " ", 
                FormBox[\( > \(ord(\[Xi]\^1\)\),
                  "TraditionalForm"]}], ")"}], " ", ">", 
            FormBox[\(ord(\[Xi]\^2\),
              "TraditionalForm"]}], ")"}], "."}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
The ordering used gives the highest derivative the highest priority \
in the calculation. To see the consequences of the ordering, let us consider \
the simple system\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"0", "  ", "=", "  ", 
            RowBox[{
              FormBox[\(\[Xi]\_x\%1\),
                "TraditionalForm"], " ", "+", " ", 
              FormBox[\(\[Xi]\_y\%1\),
                "TraditionalForm"], "  ", "-", " ", 
              FormBox[\(\[Xi]\^2\),
                "TraditionalForm"]}]}], ","}], "                     "}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"0", "  ", "=", "  ", 
          RowBox[{
            FormBox[\(\((\[Xi]\^1)\)\_y\%2\),
              "TraditionalForm"], "  ", "+", " ", 
            RowBox[{"2", " ", 
              FormBox[\(\[Xi]\^2\),
                "TraditionalForm"], " ", 
              FormBox[\(\[Xi]\_x\%1\),
                "TraditionalForm"]}], " ", "-", " ", 
            FormBox[
              SuperscriptBox[
                RowBox[{
                  FormBox[\((\[Xi]\^2\),
                    "TraditionalForm"], ")"}], "2"],
              "TraditionalForm"]}]}], ","}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\(\[Xi]\^1\),
                "TraditionalForm"], "=", \(\[Xi]\^1\)}],
            "TraditionalForm"], \((x, y)\)}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\(\[Xi]\^2\),
                "TraditionalForm"], "=", \(\[Xi]\^2\)}],
            "TraditionalForm"], \((x, y)\)}], TraditionalForm]]],
  " are functions of the independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", respectively. Applying the general canonical form algorithm, we first \
have to solve the equations with respect to the leading derivative which \
results to"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(\[Xi]\_x\%1\),
          "TraditionalForm"], " ", "=", " ", 
        RowBox[{
          RowBox[{"-", " ", 
            FormBox[\(\[Xi]\_y\%1\),
              "TraditionalForm"]}], " ", "+", " ", 
          RowBox[{
            FormBox[\(\[Xi]\^2\),
              "TraditionalForm"], "."}]}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["Substituting this result into the second equation gives us", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"0", " ", "=", " ", 
              RowBox[{
                FormBox[
                  SuperscriptBox[
                    RowBox[{
                      FormBox[\((\[Xi]\_y\%1\),
                        "TraditionalForm"], ")"}], "2"],
                  "TraditionalForm"], " ", "+", " ", 
                RowBox[{"2", " ", 
                  FormBox[
                    RowBox[{
                      FormBox[\(\[Xi]\^2\),
                        "TraditionalForm"], "(", \(-\[Xi]\_y\%1\)}],
                    "TraditionalForm"]}], " ", "+", " ", 
                FormBox[\(\[Xi]\^2\),
                  "TraditionalForm"]}]}], ")"}], " ", "-", " ", 
          FormBox[
            SuperscriptBox[
              RowBox[{
                FormBox[\((\[Xi]\^2\),
                  "TraditionalForm"], ")"}], "2"],
            "TraditionalForm"]}], ","}], TraditionalForm]], "NumberedEquation",\

  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"0", " ", "=", " ", 
          RowBox[{
            FormBox[
              SuperscriptBox[
                RowBox[{
                  FormBox[\((\[Xi]\_y\%1 - \[Xi]\^2\),
                    "TraditionalForm"], ")"}], "2"],
              "TraditionalForm"], "."}]}], 
        "                                               "}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "The result of these manipulations is that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_y\%1 = \[Xi]\^2\)]],
  ". Going back to our second equation of the original system and solving \
this equation with respect to the leading derivative  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_x\%1\)]],
  ", we find"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Xi]\_x\%1\), "  ", "=", " ", 
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\(1\/2\),
                  "TraditionalForm"], \(\[Xi]\^2\)}],
              "TraditionalForm"], "-", 
            FormBox[\(\((\[Xi]\^1)\)\_y\%2\/\(2  \[Xi]\^2\)\),
              "TraditionalForm"]}], " ", "=", " ", 
          RowBox[{
            FormBox[\(\[Xi]\^2\/2 - \[Xi]\^2\/2 = 0\),
              "TraditionalForm"], "."}]}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "To derive this result, we used the relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\[Xi]\_y\%1\),
            "TraditionalForm"], "=", 
          FormBox[\(\[Xi]\^2\),
            "TraditionalForm"]}], TraditionalForm]]],
  ". At this stage of our calculation, we know two relations connecting ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\^1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\^2\)]],
  " by"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(\(\[Xi]\_x\%1\  = \ \ 0, \)\ \ \ \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Xi]\_y\%1\), "=", "  ", 
        FormBox[\(\[Xi]\^2 . \),
          "TraditionalForm"]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
Since these two equations are represented by two differential equations with \
unique derivatives on the left-hand side, we do not need to use an implicit \
substitution step. Thus, we can skip step 3 and go to step 4 of the algorithm \
and calculate the integrability condition by\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"integrability condition"],

Cell[BoxData[
    FormBox[
      RowBox[{"0", " ", "=", " ", 
        RowBox[{
          FormBox[
            FormBox[
              RowBox[{
                RowBox[{
                  SubsuperscriptBox["\[Xi]", 
                    StyleBox["xy",
                      FontSlant->"Italic"], "1"], "-", 
                  SubsuperscriptBox["\[Xi]", 
                    StyleBox["xy",
                      FontSlant->"Italic"], "1"]}], "=", \(\[Xi]\_x\%2\)}],
              "TraditionalForm"],
            "TraditionalForm"], "."}]}], TraditionalForm]], "NumberedEquation",\

  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Since the Schwarzian integrability conditions are necessary conditions for \
deriving the general canonical form, we have to assume that the resulting \
relation for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\^2\)]],
  " is an additional equation determining the solutions for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\^1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\^2\)]],
  ". Thus, we have to add relation (10.41) to equations (10.39) and (10.40). \
The complete general canonical form thus reads"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Schwarzian integrability conditions"],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ \ \(\[Xi]\_x\%1\  = \ \ 0, 
    \)\)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[Xi]\_y\%1\), " ", "-", " ", 
            FormBox[\(\[Xi]\^2\),
              "TraditionalForm"]}], "  ", "=", "  ", "0"}], " ", ","}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["and", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ \ \ 
    \[Xi]\_x\%2\  = \ 0. \)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "To check the function ",
  StyleBox["GeneralCanonicalForm[]", "MmaText"],
  ", we examine the same equations as above. The function ",
  StyleBox["GeneralCanonicalForm[]", "MmaText"],
  " calculates the related general canonical form for equations expressed in \
the dependent variables ",
  StyleBox["xi", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["i", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " and ",
  StyleBox["phi", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["i", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ". The field functions ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[",
  StyleBox["i",
    FontSlant->"Italic"],
  "] and ",
  StyleBox["phi",
    FontSlant->"Italic"],
  "[",
  StyleBox["i",
    FontSlant->"Italic"],
  "] can depend on any number of independent variables. The function ",
  StyleBox["GeneralCanonicalForm[]", "MmaText"],
  " possesses two options allowing us to control the printing on the screen. \
With the option ",
  StyleBox["TraceStep\[Rule]True", "MmaText",
    FontSlant->"Italic"],
  StyleBox[",", "MmaText"],
  " gives information on the steps carried out by the function. The option ",
  StyleBox["WarningSS\[Rule]True ", "MmaText",
    FontSlant->"Italic"],
  "we get information on factors eliminated during the calculation. The \
on-line help text informs us about the capabilities of the function:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"GeneralCanonicalForm[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?GeneralCanonicalForm\)\)], "Input"],

Cell[BoxData[
    \("GeneralCanonicalForm[equations_List] calculates the general canonical \
form for a given list of coupled partial differential equations."\)], "Output",\

  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell["Our example above needs the following input:", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(GeneralCanonicalForm[{
          \[PartialD]\_x\( xi[1]\)[x, y]\  + \[PartialD]\_y\( xi[1]\)[x, y] - 
            \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \(xi[2]\)[x, y], \n
          \((\[PartialD]\_y\( xi[1]\)[x, y])\)\^2 + \ 
            2\ \(xi[2]\)[x, y]\ \[PartialD]\_x\( xi[1]\)[x, y] - \n
            \(xi[2]\)[x, y]\^2}, TraceStep -> True] // 
      TableForm[LieTraditionalForm[Map[# == 0&, #]]]&\)], "Input"],

Cell[BoxData[
    \("C-1 : explicit substitutions of leading derivatives"\)], "Output"],

Cell[BoxData[
    \("C-2 : implicit substitutions of leading derivatives"\)], "Output"],

Cell[BoxData[
    \("C-3 : determining minimal integrability conditions"\)], "Output"],

Cell[BoxData[
    \("C-1 : explicit substitutions of leading derivatives"\)], "Output"],

Cell[BoxData[
    \("C-2 : implicit substitutions of leading derivatives"\)], "Output"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-\[Xi]\_2\) + \((\[Xi]\_1)\)\_y == 0\)},
          {\(\((\[Xi]\_1)\)\_x == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ \[Xi], 2]], 
            Subscript[ 
              Subscript[ \[Xi], 1], y]], 0], 
        Equal[ 
          Subscript[ 
            Subscript[ \[Xi], 1], x], 0], 
        Equal[ 
          Subscript[ 
            Subscript[ \[Xi], 2], x], 0]}]]], "Output"]
}, Open  ]],

Cell["\<\
The derived canonical system is the same as above and contains all \
the solutions of the original equations. We can show the equivalence of the \
solution manifold by solving the general canonical form representation. The \
use of the solution in the original equations shows us the equivalence of \
both representations. The first and last equations of the canonical form \
imply that\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Xi]\^1\), "=", "  ", 
        RowBox[{
          FormBox[\(\[Xi]\^1\),
            "TraditionalForm"], "(", 
          StyleBox["y",
            FontSlant->"Italic"], ")"}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["and", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Xi]\^2\), " ", "=", "  ", 
        RowBox[{
          RowBox[{
            FormBox[\(\[Xi]\^2\),
              "TraditionalForm"], "(", 
            StyleBox["y",
              FontSlant->"Italic"], ")"}], "."}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "This result shows that the dependent functions are only functions of ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". Knowing this fact, we are able to satisfy both original equations if we \
take into account the second relation of our canonical representation of the \
equations."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "10.",
  CounterBox["Section"],
  ".",
  " Solution of Linear PDEs"
}], "Section",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Solution of Linear PDEs"],

Cell[TextData[{
  "In this section, we discuss heuristic procedures to integrate simple \
differential equations. The term ",
  StyleBox["simple equations",
    FontSlant->"Italic"],
  " means that we are interested in equations containing, for example, only \
one element so-called monomials, or ordinary differential equations, and \
exact PDEs. Applying one of the integration steps successfully to such \
equations, we will find an explicit solution or at least some functional \
dependencies of the solution. Consequently, we can use this information to \
transform or simplify some or all of the equations. We will discuss heuristic \
procedures like the integration of monomials, the solution of ODEs and \
pseudo-ODEs, the determination of integrating factors for exact PDEs, and the \
derivation of a potential representation for some types of PDE. Solving \
equations is intriguingly connected with the simplification of the \
intermediate results. Thus, we will also discuss different steps of \
simplification."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["10.3.1 Integration of Monomials", "Subsection",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Integration of Monomials"],

Cell["\<\
The simplest type of equation which may appear in a system of PDEs is a \
monomial with the general representation\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"monomial"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{
              SuperscriptBox["\[PartialD]", 
                RowBox[{\(i\_1\), 
                  SubscriptBox[
                    StyleBox[
                      RowBox[{"\[Ellipsis]", 
                        StyleBox["i",
                          FontSlant->"Italic"]}]], "n"]}]], 
              \(f(x\_1, \[Ellipsis]x\_n)\)}], 
            \(\[PartialD]x\_1\%i\_1  \[Ellipsis] \[PartialD]x\_n\%i\_n\)], 
          "=", " ", "0"}], ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(i\_1\),
            "TraditionalForm"], ",", 
          SubscriptBox[
            StyleBox[
              RowBox[{"\[Ellipsis]", 
                StyleBox["i",
                  FontSlant->"Italic"]}]], "n"]}], TraditionalForm]]],
  " are integers denoting the order of differentiation with respect to the \
independent variables ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(x\_1\),
            "TraditionalForm"], ",", "\[Ellipsis]", ",", \(x\_n\)}], 
        TraditionalForm]]],
  ". Using the terminology of Riquier and Janet, we call this type of \
equation a monomial. Integrating the monomial with respect to the independent \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_k\)]],
  ", we obtain the general solution"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{\(f(x\_1, \[Ellipsis], x\_n)\), " ", "=", " ", 
        FormBox[
          RowBox[{
          \(\[Sum]\+\(k = 1\)\%n\), \(\[Sum]\+\(j = 0\)\%\(i\_k - 1\)\), 
            RowBox[{
              RowBox[{
                SubscriptBox["c", 
                  StyleBox["jk",
                    FontSlant->"Italic"]], "(", \(x\_1, \[Ellipsis], 
                x\_\(k - 1\), x\_\(k + 1\), \[Ellipsis], x\_n\), ")"}], " ", 
              \(x\_k\%j\)}]}],
          "TraditionalForm"], " "}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "with ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["c", 
          StyleBox["jk",
            FontSlant->"Italic"]], TraditionalForm]]],
  " arbitrary functions of the independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". Note that the functions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["c", 
          StyleBox["jk",
            FontSlant->"Italic"]], TraditionalForm]]],
  " do not depend on ",
  Cell[BoxData[
      \(TraditionalForm\`x\_k\)]],
  ". This result is useful if we try to simplify the remaining equations of \
our system."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "The simple integration of a monomial with respect to a variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_k\)]],
  " is a common method used in pencil calculations and is widely discussed in \
the standard texts like ",
  ButtonBox["Kamke [1977]",
    ButtonData:>{"Literat.nb", "Kamke-1977"},
    ButtonStyle->"Hyperlink"],
  " or ",
  ButtonBox["Ince [1956]",
    ButtonData:>{"Literat.nb", "Ince-1956"},
    ButtonStyle->"Hyperlink"],
  ". In the following sections, we will describe other procedures which are \
also effective in pencil as well as in computer-based calculations."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"integration of a monomial"],

Cell[TextData[{
  "Let us consider a simple example to illustrate the integration step \
discussed. Assume ",
  Cell[BoxData[
      \(TraditionalForm\`f = f(x, y)\)]],
  " is a sufficiently smooth function which satisfies the PDE "
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\[PartialD]\_x f \((x, y)\)\  = \ 0. \)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "The solution of this equation follows by a partial integration with \
respect to the independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". In the integration step, we have to assume that ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is independent of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", which is trivial if we consider ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  " as independent variables. Assuming this, we can write down the solution \
for ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " as"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{\(f(x, y)\), " ", "=", " ", 
        FormBox[
          FormBox[\(\(g(y)\) x + h(y), \),
            "TraditionalForm"],
          "TraditionalForm"]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`g(y)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`h(y)\)]],
  " are arbitrary functions in ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". These two functions are especially independent of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Integrating the PDE (10.49), we introduced two arbitrary functions \
depending only on the variables of the intersection of the independent \
variables and the variable with respect the differentiation is carried out. \
This set-theoretic interpretation is crucial when implementing this step in ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["10.3.2 Integrating ODEs and Pseudo-ODEs", "Subsection",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Integrating ODEs and Pseudo-ODEs"],

Cell[TextData[{
  "Ordinary differential equations (ODEs) have a distinguished role in \
mathematics. We know that for certain types of ODEs, there exists at least \
particular solutions. Since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has implemented a large number of procedures solving ordinary \
differential equations, we will use them for our purposes. Knowing a solution \
of an ODE will help us to solve partial differential equations. Commonly, \
differential equations with one independent variable are called ODEs. \
However, dealing with PDEs, we can generalize the term ODE to pseudo-ODE. A \
pseudo-ODE is defined by the following type of relation:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"pseudo ODE"],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_\(x\_i\)\(F(x\_1, x\_2, \[Ellipsis])\)\  + \ \ 
        \(\(a\_1\)(x\_1, x\_2, \[Ellipsis])\)\ 
          \[PartialD]\_\(x\_i\)\(F(x\_1, x\_2, \[Ellipsis])\)\  + \ 
        \[CenterEllipsis]\  = \ 0. \)], "NumberedEquation"],

Cell[TextData[{
  "This kind of equation is called a pseudo-ODE because there only occur \
derivatives of the field ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " with respect to one independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". So the changes of the function ",
  StyleBox["F",
    FontSlant->"Italic"],
  " are restricted on the single coordinate ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". The other independent variables, ",
  Cell[BoxData[
      \(TraditionalForm\`x\_k\)]],
  ", act as parameters or pseudo-constants. Under this condition, it is \
obvious that (10.51) behaves like an ODE. So we can treat equation (10.51) as \
an pseudo-ODE. With this interpretation, we are able to solve (10.51) by \
taking into account that the integration constants are functions of the \
independent variables except ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". The notion of a pseudo-ODE allows us to solve special types of PDEs \
occurring frequently in the determining systems in symmetry analysis."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"ODE"],

Cell[TextData[{
  "This procedure allows us to determine the explicit dependence of the \
function ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " on the single variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". Knowing this kind of solution, we are able to simplify some of the \
remaining equations in the system of determining equations."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["10.3.3 Integrating Exact PDEs", "Subsection",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Integrating Exact PDEs"],

Cell[TextData[{
  "From the theory of ordinary differential equations, we know that a \
distinguished type of equation is an exact ODE. This type of ODE allows us to \
write down the solution if we know an integrating factor of the equation. In \
",
  ButtonBox["Chapter 4,",
    ButtonData:>{"symmet1.nb", 
      "Symmetries of Ordinary Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " we discussed the generalization of the term-integrating factor. However, \
this factor follows from a complete algorithmic procedure using only the ODE \
itself. The idea is to use the results for ordinary differential equations \
again to solve some types of partial differential equation."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"exact ODE", "integrating factor"}],

Cell[TextData[{
  "In case of PDEs, we call a differential equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " ",
  StyleBox["exact",
    FontSlant->"Italic"],
  " if we are able to write the differential expression ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\)]],
  " as a total derivative of an integral ",
  StyleBox["I",
    FontSlant->"Italic"],
  " with respect to a single variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". Consequently, we have"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"\[CapitalDelta]", " ", "=", 
        RowBox[{
          FractionBox[
            StyleBox["dI",
              FontFamily->"Times",
              FontSize->10,
              FontWeight->"Roman",
              FontSlant->"Italic",
              FontTracking->"Plain",
              PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
            StyleBox[\(dx\_i\),
              FontFamily->"Times",
              FontSize->10,
              FontWeight->"Roman",
              FontSlant->"Italic",
              FontTracking->"Plain",
              PrivateFontOptions->{"FontPostScriptName"->Automatic}]], 
          "."}]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Integrating this relation automatically, we need a function calculating \
the integral ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " of the right-hand side. If we know the integral ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  ", we can replace the equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " by the relation ",
  Cell[BoxData[
      \(TraditionalForm\`I = const\)]],
  ". It is important to note that we do not lose any information by this \
replacement. However, using a procedure originally designed for ODEs, we have \
to take into account that the integration constants are again not constants \
in the original sense but depend on all independent variables occurring in \
\[CapitalDelta] except ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  "."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["10.3.4 Potential Representation", "Subsection",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Potential Representation"],

Cell[TextData[{
  "Closely related to the integration of exact PDEs is the procedure to find \
a potential representation of the original equations, as ",
  ButtonBox["Wolf [1991]",
    ButtonData:>{"Literat.nb", "Wolf-1991"},
    ButtonStyle->"Hyperlink"],
  " remarks. Let us discuss the procedure by considering an equation of the \
form"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"potential representation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[PartialD]\_\(x\_1\)I\_1 + \ \[PartialD]\_\(x\_2\)I\_2 = 0, \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`I\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`I\_2\)]],
  " are functions of ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  ". Relation (10.53) can be integrated by introducing a potential ",
  Cell[BoxData[
      \(TraditionalForm\`V = V(x\_1, x\_2)\)]],
  " satisfying the properties"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{\(I\_1\), "=", " ", 
        RowBox[{\(\[PartialD]\_\(x\_2\)V\), "   ", "and", "   ", 
          RowBox[{
            FormBox[\(I\_2 = \ \(-\[PartialD]\_\(x\_1\)V\)\),
              "TraditionalForm"], "."}]}]}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "The connection between the potential representation with ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " and the concept of an exact PDE can be shown if we take into account that \
the left-hand side of our first equation is exact with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " and the right-hand side is exact with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  ". This observation is the basis of the algorithmic calculation. Thus, we \
can use the following six steps to check the existence of a potential \
representation. As the input quantity, we use the differential expression \
\[CapitalDelta]."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Integrate \[CapitalDelta] with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " and call the exact part of this result ",
  Cell[BoxData[
      \(TraditionalForm\`I\_1\)]],
  "."
}], "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Calculate the residue ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`R = \[CapitalDelta] - \[PartialD]\_\(x\_1\)I\_1\)]],
  "."
}], "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`R = 0\)]],
  ", then \[CapitalDelta] is exact and the procedure terminates."
}], "ListItem",
  CellDingbat->"3.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["Otherwise:", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Determine ",
  Cell[BoxData[
      \(TraditionalForm\`I\_2\)]],
  " as the exact part of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  "."
}], "ListItem",
  CellDingbat->"4.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Again, calculate the residue ",
  Cell[BoxData[
      \(TraditionalForm\`R = R - \[PartialD]\_\(x\_2\)I\_2\)]],
  "."
}], "ListItem",
  CellDingbat->"5.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`R \[NotEqual] 0\)]],
  ", then no potential exists. This also terminates the procedure."
}], "ListItem",
  CellDingbat->"6.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "The result of these steps are that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(I\_1\),
            "TraditionalForm"], "=", \(\[PartialD]\_\(x\_2\)V\)}], 
        TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(I\_2\),
            "TraditionalForm"], "=", \(-\[PartialD]\_\(x\_1\)V\)}], 
        TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
This algorithm performs two steps. First, it checks whether a \
potential can be introduced, and second, if it is possible to introduce a \
potential the necessary conditions to represent the potential are calculated.\
\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "10.",
  CounterBox["Section"],
  ".",
  " Simplification of Equations"
}], "Section",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Simplification of Equations"],

Cell["\<\
This section discusses three procedures allowing the simplification \
of the determining equations in connection with the integration steps \
discussed so far.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"simplification of the determining equations"],

Cell[CellGroupData[{

Cell["10.4.1 Direct Separation", "Subsection",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Direct Separation"],

Cell[TextData[{
  "We already know that the integration of monomials results into a \
pseudo-polynomial representation of the solution. This pseudo-polynomial has \
the special property that the expansion coefficients possess a dependence on \
a reduced set of independent variables. The explicit occurrence of some of \
the independent variables in the representation of the solution can be used \
to simplify the determining equations by a direct separation of variables. \
Inserting the solution into the determining equations allows us to separate \
some parts of the determining equations from each other. Comparing the \
coefficients of the resulting polynomials allows us to derive a new, \
simplified set of determining equations. These equations are actually simpler \
than those from which we originally started. Suppose some parts of the \
determining equations are of a polynomial type in the variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". We can perform a separation by setting the coefficients of the various \
powers of ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " equal to zero. Let us demonstrate this procedure by the following example \
where ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i = z\)]],
  ". Consider the equation:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"pseudo polynomial representation", "pseudo polynomial"}],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_y\( f(x, y)\)\  + \ 
        z\ {\[PartialD]\_x\( f(x, y)\) + \[PartialD]\_x\( g(x)\)}\  + \ 
        \(z\^2\) {
            \[PartialD]\_x\( g(x)\)\  + \ y\ \[PartialD]\_x\%2\( g(x)\)} = 0. 
      \)], "NumberedEquation"],

Cell[TextData[{
  "This PDE can be considered as a polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " with variable coefficients. The extraction of the different coefficients \
of powers of ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " results in a new system of determining equations given by"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
    \(\[PartialD]\_y\( f(x, y)\)\  = \ 0, \)\)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[PartialD]\_x\( f(x, y)\) + \[PartialD]\_x g \((x)\)\  = \ 0, \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_x\( g(x)\)\  + \ y\ \[PartialD]\_x\%2 g \((x)\)\  = \ \ 0. 
      \)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "The last equation (10.58) of this system can again be considered as a \
polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". The application of the same rules result into an additional separation \
of the equation. Thus, we can maintain, in a second step, the last equation \
in two equations. The resulting equations are"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
    \(\[PartialD]\_y\( f(x, y)\)\  = \ 0, \)\)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[PartialD]\_x\( f(x, y)\) + \[PartialD]\_x g \((x)\)\  = \ 0, \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
    \(\[PartialD]\_x\( g(x)\)\  = \ 0, \)\)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
    \[PartialD]\_x\%2\( g(x)\)\  = 0. \)\)], "NumberedEquation"],

Cell["\<\
From this set of four equations it follows by applying the integration of \
monomials that the solution can be represented by\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(g(x)\), " ", "=", " ", 
          RowBox[{
            RowBox[{
              FormBox[\(k\_1\),
                "TraditionalForm"], "  ", "and", "  ", \(f(x, y)\)}], " ", 
            "=", " ", 
            FormBox[\(k\_2\),
              "TraditionalForm"]}]}], ","}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`k\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`k\_2\)]],
  " are constants of integration. This solution satisfies not only the final \
four equations but also the original equation from which we started. At this \
point, it is obvious that we can reduce the integration process of a partial \
differential equation to a simple chain of steps involving the integration of \
monomials."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["10.4.2 Indirect Separation", "Subsection",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Indirect Separation"],

Cell["\<\
An essential requirement of a direct separation was the existence of terms \
containing one independent variable in polynomial form. Generally, we cannot \
assume that such case will occur. In the following we will discuss a more \
general situation in which the independent variable only occurs in the \
argument of a function. If the other involved functions do not depend on the \
same variable, it is possible to separate parts of the equation. The \
separation is possible if we cross-differentiate the expressions. This \
procedure allows an indirect separation of terms. Cross-differentiating \
splits up the equation into independent parts. The separated parts depend \
only on a reduced set of independent variables.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
To demonstrate the method, let us examine the solutions of the first-order \
partial differential equation\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`f(x, y) + \[PartialD]\_x\( g(x)\)\  = 0. \)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Differentiating this PDE with respect to the independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ", we find that ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " has to satisfy the equation"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(\[PartialD]\_y\( f(x, y)\)\  = 0. \ \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "Since the term containing ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " does not depend on ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ", it simply vanishes. The differentiation of the equation with respect to \
the conjugate variable to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " allows a separation. The original equation reduces to a single \
determining equation containing only ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". However, the equation for ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " can be integrated with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". The result reads"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`f(x, y) = \(h(x) . \)\)], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "This results shows that ",
  StyleBox["f",
    FontSlant->"Italic"],
  " does not depend on ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " but only on ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Inserting the result into the original equation (10.64), we get"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`h(x) + \[PartialD]\_x\( g(x)\) = 0. \)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "This equation is an inhomogeneous ordinary differential equation of first \
order in ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ". An integration with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " yields the solution"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`g(x) = \(-\(\[Integral]\^x\( h(z)\) \(\[DifferentialD]z . \)\)\)\)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "The result of the indirect separation is a relation connecting ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " by an arbitrary function ",
  Cell[BoxData[
      \(TraditionalForm\`h = h(x)\)]],
  ". If we know the function ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  ", we also know ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
Although we derived simpler equations from an indirect separation, this \
method will not contain as much information as the direct separation, meaning \
that we cannot replace the original equations by the separated ones. However, \
we are able to use parts of the equation or the separated equation itself in \
other equations. This again will simplify the original equations but does not \
replace them.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["10.4.3 Reducing the Number of Dependent Variables", "Subsection",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Reducing the Number of Dependent Variables"],

Cell["\<\
The fact is that if we can uniquely solve an equation of the \
determining equations with respect to an unknown function, this allows us to \
use this function as a substitute. The substitution of this function permits \
an elimination of all occurrences of this function in the rest of the system. \
If such a situation occurs, we can reduce the number of unknown functions in \
the system by one. The elimination of unknown functions by using information \
from the equations involved is an important method of simplifying systems of \
PDEs. Because the number of unknown functions increases by each integration \
of monomials, one can imagine that after a few steps, we have a huge number \
of unknown functions in the determining equations. Thus, it is necessary to \
counterbalance the increase of unknown functions by an elimination procedure. \
Since not all unknown functions are useful in the elimination of \
dependencies, the unknown function has to satisfy several conditions. The \
following list contains the main properties an unknown function has to \
satisfy for an elimination.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
The function with respect to which the equation under consideration \
is solved must depend on all variables which occur in the remaining set of \
equations.\
\>", "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
The equation must be uniquely solvable with respect to the unknown \
function.\
\>", "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
The equation solved does not contain derivatives of the unknown \
function.\
\>", "ListItem",
  CellDingbat->"3.",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
The last condition is very important, because if the unknown function occurs \
in a derivative, we cannot replace the unknown function itself in any \
expression of the whole system of determining equations.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell["\<\
To demonstrate the elimination of unknown functions, let us consider the \
example\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"elimination of unknown functions"],

Cell[BoxData[
    \(TraditionalForm\`f(x, y) + \[PartialD]\_x g \((x, y)\) + h(x) = 0. \)], 
  "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "This equation is only solvable with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y)\)]],
  ". Neither ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " nor ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " satisfy the three conditions from above. If we accidentally solve this \
equation [e.g., with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  "], we lose the information that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(f(x, y) + \[PartialD]\_x\),
            "TraditionalForm"], \(g(x, y)\)}], TraditionalForm]]],
  " depends on ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". On the other hand, if we solve the equation with respect to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\[PartialD]\_x\),
            "TraditionalForm"], \(g(x, y)\)}], TraditionalForm]]],
  ", we cannot replace all expressions containing ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y)\)]],
  " which occasionally may occur in other equations (not shown here)."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "All methods so far discussed for simplifying and integrating partial \
differential equations are implemented in our ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " function ",
  StyleBox["PDESolve[]", "MmaText"],
  ". To solve a given system of the determining equations completely, it is \
necessary to repeat the discussed methods several times in different orders \
as long as no further simplifications are possible. To show how the function \
",
  StyleBox["PDESolve[]", "MmaText"],
  " can be used, let us examine the determining equations of the Korteweg-de \
Vries equation. These equations follow by"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(detEquationsKdV\  = \ 
      DeterminingEquations[{
          \[PartialD]\_t u[x, t] + u[x, t] \[PartialD]\_x u[x, t] + 
            \[PartialD]\_\(x, x, x\)u[x, t]}, {u}, {x, t}, {
          \[PartialD]\_t u[x, t]}]; detEquationsKdV // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {
            \(\[Phi]\_1 - \((\[Xi]\_1)\)\_t - u\ \((\[Xi]\_1)\)\_x + 
                u\ \((\[Xi]\_2)\)\_t - \((\[Xi]\_1)\)\_\(x, x, x\) + 
                3\ \((\[Phi]\_1)\)\_\(x, x, u\) == 0\)},
          {
            \(\((\[Phi]\_1)\)\_t + u\ \((\[Phi]\_1)\)\_x + 
                \((\[Phi]\_1)\)\_\(x, x, x\) == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_\(x, x\)\) + \((\[Phi]\_1)\)\_\(x, u\) == 0
              \)},
          {\(\(-3\)\ \((\[Xi]\_1)\)\_x + \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "These eight equations are linear but coupled. Before we use the function ",
  
  StyleBox["PDESolve[],", "MmaText"],
  " let us look at the shorthand description of the function:"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?PDESolve\)\)], "Input"],

Cell[BoxData[
    \("PDESolve[list of equations,dependent vars., indep. vars., Options]"\)],
   "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell[TextData[{
  "The related option of the function ",
  StyleBox["PDESolve[]", "MmaText"],
  " are"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[PDESolve]\)], "Input"],

Cell[BoxData[
    \({Standard \[Rule] False, WarningSS \[Rule] False, 
      TraceStep \[Rule] True}\)], "Output"]
}, Open  ]],

Cell["\<\
The application of this function to the determining equations of the \
Korteweg-de Vries equation gives us the result\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Korteweg de Vries equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infinitesimalsKdV\  = PDESolve[detEquationsKdV, {u}, {x, t}]; 
    infinitesimalsKdV // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k1", "+", \(k2\ t\), "+", 
                StyleBox[\(\(k4\ x\)\/3\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == k3 + k4\ t\)},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{"k2", "-", 
                StyleBox[\(\(2\ k4\ u\)\/3\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k1, 
            Times[ k2, t], 
            Times[ 
              Rational[ 1, 3], k4, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k3, 
            Times[ k4, t]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k2, 
            Times[ 
              Rational[ -2, 3], k4, u]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
remembering that the KdV equation allows a four-dimensional symmetry group.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "10.",
  CounterBox["Section"],
  ".",
  " Example"
}], "Section",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Examples"],

Cell[TextData[{
  "The algorithm to solve partial differential equations is designed to treat \
coupled systems of determining equations. Such determining equations occur \
frequently in symmetry analysis. The following example demonstrates the \
capabilities of the function ",
  StyleBox["PDESolve[]", "MmaText"],
  " in connection with a non-standard equation. The example originates from \
quantum gravity theory and demonstrates the flexibility of the algorithm in \
connection with special functions."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["10.5.1 Liouville-Type Equation of Quantum Gravity Theory", "Subsection",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Liouville Type Equation of Quantum Gravity Theory"],

Cell[TextData[{
  "The first example is related to an equation occurring in quantum gravity \
theory describing the evolution of the Killing vector. ",
  ButtonBox["Boyer and Finley [1989]",
    ButtonData:>{"Literat.nb", "Boyer-1989"},
    ButtonStyle->"Hyperlink"],
  " showed that the Killing vector of a rotational symmetric space can be \
described by an equation of the form"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"quantum gravity theory"],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_\(x, x\)\ \(u(x, y, z)\) + \ 
        \[PartialD]\_\(y, y\)\(u(x, y, z)\)\  + \ 
        \[PartialD]\_\(z, z\)e\^\(u(x, y, z)\) = 0. \)], "NumberedEquation"],

Cell[TextData[{
  "This equation is of some importance in quantum gravity theory, dealing \
with a special form of general relativity theory including quantum effects. \
The solution of the Killing equation determines a Riemann metric which admits \
only vectors which are invariant under rotations. A first solution of \
equation (10.70) was given by ",
  ButtonBox["Drew et al. [1989]",
    ButtonData:>{"Literat.nb", "Drew-1989"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"Riemann metric", "Killing equation"}],

Cell["\<\
Applying Lie's symmetry method to this equation will give us a \
system of 16 determining equations:\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"detEqsLiouville", " ", "=", " ", 
          RowBox[{"DeterminingEquations", "[", 
            RowBox[{
              RowBox[{"{", 
                FormBox[
                  RowBox[{
                    StyleBox[\(\[PartialD]\_\(x, x\)\ u[x, y, z]\),
                      FontSlant->"Plain",
                      FontTracking->"Plain",
                      FontVariations->{"Underline"->False,
                      "Outline"->False,
                      "Shadow"->False}], 
                    StyleBox["+",
                      FontSlant->"Plain",
                      FontTracking->"Plain",
                      FontVariations->{"Underline"->False,
                      "Outline"->False,
                      "Shadow"->False}], 
                    StyleBox[" ",
                      FontSlant->"Plain",
                      FontTracking->"Plain",
                      FontVariations->{"Underline"->False,
                      "Outline"->False,
                      "Shadow"->False}], 
                    StyleBox[\(\[PartialD]\_\(y, y\)u[x, y, z]\),
                      FontSlant->"Plain",
                      FontTracking->"Plain",
                      FontVariations->{"Underline"->False,
                      "Outline"->False,
                      "Shadow"->False}], 
                    StyleBox[" ",
                      FontSlant->"Plain",
                      FontTracking->"Plain",
                      FontVariations->{"Underline"->False,
                      "Outline"->False,
                      "Shadow"->False}], 
                    StyleBox["+",
                      FontSlant->"Plain",
                      FontTracking->"Plain",
                      FontVariations->{"Underline"->False,
                      "Outline"->False,
                      "Shadow"->False}], 
                    StyleBox[" ",
                      FontSlant->"Plain",
                      FontTracking->"Plain",
                      FontVariations->{"Underline"->False,
                      "Outline"->False,
                      "Shadow"->False}], 
                    RowBox[{
                      StyleBox[\(\[PartialD]\_\(z, z\)\),
                        FontSlant->"Plain",
                        FontTracking->"Plain",
                        FontVariations->{"Underline"->False,
                        "Outline"->False,
                        "Shadow"->False}], \(Exp[u[x, y, z]]\)}]}],
                  "TraditionalForm"], "}"}], ",", \({u}\), ",", 
              \({x, y, z}\), ",", \({\[PartialD]\_\(x, x\)\ u[x, y, z]}\)}], 
            "]"}]}], ";", \(detEqsLiouville // LTF\)}], " "}]], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Xi]\_3)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_1)\)\_z == 0\)},
          {\(\((\[Xi]\_2)\)\_z == 0\)},
          {\(\((\[Xi]\_3)\)\_y == 0\)},
          {\(\((\[Xi]\_3)\)\_x == 0\)},
          {
            \(\(-\((\[Xi]\_2)\)\_\(x, x\)\) - \((\[Xi]\_2)\)\_\(y, y\) + 
                2\ \((\[Phi]\_1)\)\_\(y, u\) == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_\(x, x\)\) - \((\[Xi]\_1)\)\_\(y, y\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\((\[Phi]\_1)\)\_\(x, x\) + \((\[Phi]\_1)\)\_\(y, y\) + 
                E\^u\ \((\[Phi]\_1)\)\_\(z, z\) == 0\)},
          {\(\((\[Xi]\_1)\)\_y + \((\[Xi]\_2)\)\_x == 0\)},
          {
            \(\[Phi]\_1 + 2\ \((\[Xi]\_1)\)\_x - 2\ \((\[Xi]\_3)\)\_z + 
                \((\[Phi]\_1)\)\_u == 0\)},
          {\(\[Phi]\_1 + 2\ \((\[Xi]\_1)\)\_x - 2\ \((\[Xi]\_3)\)\_z == 0\)},
          {\(\(-\((\[Xi]\_1)\)\_x\) + \((\[Xi]\_2)\)\_y == 0\)},
          {
            \(2\ \((\[Phi]\_1)\)\_z - \((\[Xi]\_3)\)\_\(z, z\) + 
                2\ \((\[Phi]\_1)\)\_\(z, u\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Using the notation of ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " we denote the derivative with respect to the k",
  StyleBox["th ",
    FontSlant->"Italic"],
  "argument by a superscript at the k",
  StyleBox["th",
    FontSlant->"Italic"],
  " position. The solution of these equations follow within a few seconds by \
applying the function ",
  StyleBox["PDESolve[]", "MmaText"],
  " to these equations. The result of this calculation is"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(infiniLiouville\  = \ PDESolve[detEqsLiouville, {u}, {x, y, z}]; 
    infiniLiouville // 
      TableForm[LieTraditionalForm[#], 
          TableHeadings 
            \[Rule] {{"\<infinitesimals\>", "\<det-equations\>"}, Automatic}, 
          TableDirections -> {Row, Column}]&\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"\"\>", "\<\"infinitesimals\"\>", "\<\"det-equations\"\>"},
          {"1", \(\[Xi]\_1 \[Rule] \(-\((\[ScriptCapitalF]\_2)\)\_y\)\), 
            \(\((\[ScriptCapitalF]\_2)\)\_\(x, x\) + 
              \((\[ScriptCapitalF]\_2)\)\_\(y, y\)\)},
          {"2", \(\[Xi]\_2 \[Rule] \(-\((\[ScriptCapitalF]\_2)\)\_x\)\), 
            \(\[ScriptCapitalF]\_3 + \((\[ScriptCapitalF]\_2)\)\_\(x, x\) + 
              \((\[ScriptCapitalF]\_2)\)\_\(y, y\)\)},
          {"3", \(\[Xi]\_3 \[Rule] k1 + k2\ z\), 
            \(\[ScriptCapitalF]\_4 + \((\[ScriptCapitalF]\_2)\)\_\(x, x\) + 
              \((\[ScriptCapitalF]\_2)\)\_\(y, y\)\)},
          {"4", 
            \(\[Phi]\_1 \[Rule] 
              2\ \((k2 + \((\[ScriptCapitalF]\_2)\)\_\(x, y\))\)\), 
            \(\(-\[ScriptCapitalF]\_1\) + 
              \((\[ScriptCapitalF]\_2)\)\_\(x, x, y\) + 
              \((\[ScriptCapitalF]\_2)\)\_\(y, y, y\)\)}
          },
        RowSpacings->3,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableHeadings -> {{"infinitesimals", "det-equations"}, 
        Automatic}, TableDirections -> {Row, Column}]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of the calculation is a combination of a discrete and a \
continuous group. The unknown function",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[
            RowBox[{
              FormBox[\(\[ScriptCapitalF]\_2 = \),
                "TraditionalForm"], \(free[2]\)}],
            "MmaText"]}], TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "of the continuous part has to satisfy the two-dimensional Laplace \
equation"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Laplace equation"],

Cell[BoxData[
    \(TraditionalForm
    \`\((\[ScriptCapitalF]\_2)\)\_\(x, x\) + 
        \((\[ScriptCapitalF]\_2)\)\_\(y, y\) = 0. \)], "NumberedEquation"],

Cell[TextData[{
  "The point here is that this result is different from the result given by \
Drew et al. The difference is not a marginal one. However, since a different \
result was derived by our program, we had to check the results of Drew et al. \
with another program. We substituted the result of Drew et al. into our \
determining equations and discovered that their result do not solve our \
determining equations. On the other hand, our result is a solution of the \
determining equations derived by the function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  ". We also examined the validity of our determining equations by using a \
different computer algebra program. Using the ",
  StyleBox["Maple",
    FontSlant->"Italic"],
  " program by ",
  ButtonBox["Reid [1991]",
    ButtonData:>{"Literat.nb", "Reid-1991"},
    ButtonStyle->"Hyperlink"],
  ", we could check that our derived determining equations are correct and \
that our solution solves the equations obtained from ",
  "Reid\[CloseCurlyQuote]s",
  " program."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "The solution given by Drew et al. did not satisfy the determining \
equations derived by ",
  "Reid\[CloseCurlyQuote]s",
  " program in general. Only for the special case with"
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["free",
              FontSlant->"Italic"], "[", "2", "]"}], "[", \(x, y\), "]"}], 
        "=", \(const . \)}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[{
  "could the equations be satisfied. This choice of the unknown function was \
the main case discussed by Drew et al. All these various checks proved that \
our result is correct. Furthermore, we could show that there is no \
transformation which maps both solutions into each other. The result given by \
Drew et al. has a completely different structure of the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  ", but the expression for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_3\)]],
  " is identical in both results."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"MSLie.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{671, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingStartingPageNumber->457,
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Solution of Coupled Linear Partial Differential Equations", 
            FontSlant -> "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Introduction", "General Canonical Form of PDEs", 
                "Solution of Linear PDEs", "Simplification of Equations", 
                "Example"}, #]&)], FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"Text"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Solution of Coupled Linear Partial Differential Equations"->{
    Cell[1739, 51, 375, 5, 117, "ChapterLine",
      CounterAssignments->{{"Title", 9}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->
      "Solution of Coupled Linear Partial Differential Equations"]},
  "Introduction"->{
    Cell[2501, 69, 406, 12, 52, "Section",
      Evaluatable->False,
      CounterAssignments->{{"Title", 10}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Introduction"]},
  "coupled linear partial differential equations"->{
    Cell[2910, 83, 1584, 35, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "coupled linear partial differential equations", 
        "invariance conditions", "point symmetries", "potential symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "automatic derivation of solutions", "computer algebra"}]},
  "invariance conditions"->{
    Cell[2910, 83, 1584, 35, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "coupled linear partial differential equations", 
        "invariance conditions", "point symmetries", "potential symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "automatic derivation of solutions", "computer algebra"}]},
  "point symmetries"->{
    Cell[2910, 83, 1584, 35, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "coupled linear partial differential equations", 
        "invariance conditions", "point symmetries", "potential symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "automatic derivation of solutions", "computer algebra"}]},
  "potential symmetries"->{
    Cell[2910, 83, 1584, 35, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "coupled linear partial differential equations", 
        "invariance conditions", "point symmetries", "potential symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "automatic derivation of solutions", "computer algebra"}]},
  "approximate symmetries"->{
    Cell[2910, 83, 1584, 35, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "coupled linear partial differential equations", 
        "invariance conditions", "point symmetries", "potential symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "automatic derivation of solutions", "computer algebra"}]},
  "generalized symmetries"->{
    Cell[2910, 83, 1584, 35, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "coupled linear partial differential equations", 
        "invariance conditions", "point symmetries", "potential symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "automatic derivation of solutions", "computer algebra"}]},
  "automatic derivation of solutions"->{
    Cell[2910, 83, 1584, 35, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "coupled linear partial differential equations", 
        "invariance conditions", "point symmetries", "potential symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "automatic derivation of solutions", "computer algebra"}]},
  "computer algebra"->{
    Cell[2910, 83, 1584, 35, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "coupled linear partial differential equations", 
        "invariance conditions", "point symmetries", "potential symmetries", 
        "approximate symmetries", "generalized symmetries", 
        "automatic derivation of solutions", "computer algebra"}]},
  "automatic procedure"->{
    Cell[4497, 120, 1364, 30, 201, "Text",
      Evaluatable->False,
      CellTags->{"automatic procedure", "differential Groebner technique"}]},
  "differential Groebner technique"->{
    Cell[4497, 120, 1364, 30, 201, "Text",
      Evaluatable->False,
      CellTags->{"automatic procedure", "differential Groebner technique"}]},
  "decoupling of the equations"->{
    Cell[5864, 152, 214, 5, 26, "ListItem",
      Evaluatable->False,
      CellTags->"decoupling of the equations"]},
  "integration of simple equations"->{
    Cell[6081, 159, 196, 5, 26, "ListItem",
      Evaluatable->False,
      CellTags->"integration of simple equations"]},
  "simplification of the equations"->{
    Cell[6280, 166, 196, 5, 26, "ListItem",
      Evaluatable->False,
      CellTags->"simplification of the equations"]},
  "solution procedure"->{
    Cell[6479, 173, 849, 17, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "solution procedure", "general canonical form", "Janet", "Riquier"}]},
  "general canonical form"->{
    Cell[6479, 173, 849, 17, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "solution procedure", "general canonical form", "Janet", "Riquier"}],
    Cell[7331, 192, 593, 13, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "integration procedure for PDEs", "general canonical form", 
        "general canonical algorithm"}],
    Cell[8189, 221, 1491, 35, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "general canonical form", 
        "forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]", 
        "coupled differential equations", "Groebner basis algorithm", 
        "Groebner algorithm for differential equations"}],
    Cell[18788, 523, 782, 14, 159, "Text",
      Evaluatable->False,
      CellTags->{"general canonical form", "canonical algorithm"}]},
  "Janet"->{
    Cell[6479, 173, 849, 17, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "solution procedure", "general canonical form", "Janet", "Riquier"}]},
  "Riquier"->{
    Cell[6479, 173, 849, 17, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "solution procedure", "general canonical form", "Janet", "Riquier"}]},
  "integration procedure for PDEs"->{
    Cell[7331, 192, 593, 13, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "integration procedure for PDEs", "general canonical form", 
        "general canonical algorithm"}]},
  "general canonical algorithm"->{
    Cell[7331, 192, 593, 13, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "integration procedure for PDEs", "general canonical form", 
        "general canonical algorithm"}]},
  "General Canonical Form of PDEs"->{
    Cell[7961, 210, 225, 9, 52, "Section",
      Evaluatable->False,
      CellTags->"General Canonical Form of PDEs"]},
  "forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]"->{
    Cell[8189, 221, 1491, 35, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "general canonical form", 
        "forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]", 
        "coupled differential equations", "Groebner basis algorithm", 
        "Groebner algorithm for differential equations"}]},
  "coupled differential equations"->{
    Cell[8189, 221, 1491, 35, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "general canonical form", 
        "forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]", 
        "coupled differential equations", "Groebner basis algorithm", 
        "Groebner algorithm for differential equations"}]},
  "Groebner basis algorithm"->{
    Cell[8189, 221, 1491, 35, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "general canonical form", 
        "forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]", 
        "coupled differential equations", "Groebner basis algorithm", 
        "Groebner algorithm for differential equations"}],
    Cell[59830, 1872, 906, 19, 159, "Text",
      Evaluatable->False,
      CellTags->{"GeneralCanonicalForm[]", "Groebner basis algorithm"}]},
  "Groebner algorithm for differential equations"->{
    Cell[8189, 221, 1491, 35, 201, "Text",
      Evaluatable->False,
      CellTags->{
      "general canonical form", 
        "forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]", 
        "coupled differential equations", "Groebner basis algorithm", 
        "Groebner algorithm for differential equations"}]},
  "Definition: Canonical form"->{
    Cell[9683, 258, 90, 1, 38, "Definition",
      CellTags->"Definition: Canonical form"]},
  "Schwarzian integrability conditions"->{
    Cell[9776, 261, 444, 8, 75, "Text",
      Evaluatable->False,
      CellTags->"Schwarzian integrability conditions"],
    Cell[13625, 374, 222, 5, 26, "ListItem",
      Evaluatable->False,
      CellTags->"Schwarzian integrability conditions"],
    Cell[70587, 2205, 688, 18, 96, "Text",
      Evaluatable->False,
      CellTags->"Schwarzian integrability conditions"]},
  "simplifying the original equations"->{
    Cell[10223, 271, 344, 8, 75, "Text",
      Evaluatable->False,
      CellTags->"simplifying the original equations"]},
  "several algorithms"->{
    Cell[10570, 281, 996, 26, 117, "Text",
      Evaluatable->False,
      CellTags->"several algorithms"]},
  "properties of a general canonical form"->{
    Cell[12295, 324, 251, 7, 54, "Text",
      Evaluatable->False,
      CellTags->"properties of a general canonical form"]},
  "leading derivatives"->{
    Cell[12549, 333, 276, 8, 45, "ListItem",
      Evaluatable->False,
      CellTags->"leading derivatives"]},
  "disjunct"->{
    Cell[13114, 353, 215, 8, 26, "ListItem",
      Evaluatable->False,
      CellTags->"disjunct"]},
  "nontrivial derivative"->{
    Cell[13332, 363, 290, 9, 45, "ListItem",
      Evaluatable->False,
      CellTags->"nontrivial derivative"]},
  "elimination ideals"->{
    Cell[13850, 381, 1237, 24, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "elimination ideals", "total degree ordering", 
        "lexicographic ordering"}]},
  "total degree ordering"->{
    Cell[13850, 381, 1237, 24, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "elimination ideals", "total degree ordering", 
        "lexicographic ordering"}]},
  "lexicographic ordering"->{
    Cell[13850, 381, 1237, 24, 222, "Text",
      Evaluatable->False,
      CellTags->{
      "elimination ideals", "total degree ordering", 
        "lexicographic ordering"}]},
  "total ordering of derivatives"->{
    Cell[16713, 458, 250, 6, 26, "ListItem",
      Evaluatable->False,
      CellTags->"total ordering of derivatives"]},
  "lexicographic ordering of the derivatives"->{
    Cell[17374, 483, 270, 6, 26, "ListItem",
      Evaluatable->False,
      CellTags->"lexicographic ordering of the derivatives"]},
  "lexicographic ordering of function names"->{
    Cell[17854, 497, 268, 6, 26, "ListItem",
      Evaluatable->False,
      CellTags->"lexicographic ordering of function names"]},
  "solution manifold of an equations"->{
    Cell[18298, 511, 487, 10, 96, "Text",
      Evaluatable->False,
      CellTags->"solution manifold of an equations"]},
  "canonical algorithm"->{
    Cell[18788, 523, 782, 14, 159, "Text",
      Evaluatable->False,
      CellTags->{"general canonical form", "canonical algorithm"}]},
  "integrability conditions"->{
    Cell[20170, 552, 490, 10, 96, "Text",
      Evaluatable->False,
      CellTags->"integrability conditions"]},
  "nonlinear PDEs"->{
    Cell[22906, 634, 1293, 22, 264, "Text",
      Evaluatable->False,
      CellTags->"nonlinear PDEs"]},
  "Application of the General Form Algorithm"->{
    Cell[24224, 660, 140, 2, 49, "Subsection",
      CellTags->"Application of the General Form Algorithm"]},
  "GroebnerBasis[]"->{
    Cell[24367, 664, 1549, 29, 306, "Text",
      Evaluatable->False,
      CellTags->{
      "GroebnerBasis[]", "Groebner basis", "polynomials", "standard bases"}],
    Cell[30450, 874, 318, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"GroebnerBasis[]"]},
  "Groebner basis"->{
    Cell[24367, 664, 1549, 29, 306, "Text",
      Evaluatable->False,
      CellTags->{
      "GroebnerBasis[]", "Groebner basis", "polynomials", "standard bases"}],
    Cell[29454, 829, 167, 4, 33, "Text",
      Evaluatable->False,
      CellTags->"Groebner basis"],
    Cell[54271, 1639, 294, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"Groebner basis"]},
  "polynomials"->{
    Cell[24367, 664, 1549, 29, 306, "Text",
      Evaluatable->False,
      CellTags->{
      "GroebnerBasis[]", "Groebner basis", "polynomials", 
        "standard bases"}]},
  "standard bases"->{
    Cell[24367, 664, 1549, 29, 306, "Text",
      Evaluatable->False,
      CellTags->{
      "GroebnerBasis[]", "Groebner basis", "polynomials", 
        "standard bases"}]},
  "method of manipulating a set of polynomials"->{
    Cell[36614, 1091, 1085, 29, 159, "Text",
      Evaluatable->False,
      CellTags->"method of manipulating a set of polynomials"]},
  "canonical form"->{
    Cell[37702, 1122, 1256, 25, 243, "Text",
      Evaluatable->False,
      CellTags->{"canonical form", "Buchberger algorithm"}]},
  "Buchberger algorithm"->{
    Cell[37702, 1122, 1256, 25, 243, "Text",
      Evaluatable->False,
      CellTags->{"canonical form", "Buchberger algorithm"}]},
  "equivalent system of PDEs"->{
    Cell[40097, 1185, 286, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"equivalent system of PDEs"]},
  "differential representation"->{
    Cell[49264, 1481, 1149, 21, 243, "Text",
      Evaluatable->False,
      CellTags->"differential representation"]},
  "DSolve[]"->{
    Cell[55577, 1690, 426, 12, 75, "Text",
      Evaluatable->False,
      CellTags->"DSolve[]"]},
  "GeneralCanonicalForm[]"->{
    Cell[59830, 1872, 906, 19, 159, "Text",
      Evaluatable->False,
      CellTags->{"GeneralCanonicalForm[]", "Groebner basis algorithm"}],
    Cell[72024, 2253, 1607, 48, 201, "Text",
      Evaluatable->False,
      CellTags->"GeneralCanonicalForm[]"]},
  "integrability condition"->{
    Cell[69517, 2173, 416, 9, 96, "Text",
      Evaluatable->False,
      CellTags->"integrability condition"]},
  "Solution of Linear PDEs"->{
    Cell[77345, 2429, 211, 9, 52, "Section",
      Evaluatable->False,
      CellTags->"Solution of Linear PDEs"]},
  "Integration of Monomials"->{
    Cell[78691, 2464, 165, 4, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Integration of Monomials"]},
  "monomial"->{
    Cell[78859, 2470, 234, 7, 54, "Text",
      Evaluatable->False,
      CellTags->"monomial"]},
  "integration of a monomial"->{
    Cell[81887, 2568, 733, 19, 96, "Text",
      Evaluatable->False,
      CellTags->"integration of a monomial"]},
  "Integrating ODEs and Pseudo-ODEs"->{
    Cell[84953, 2674, 181, 4, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Integrating ODEs and Pseudo-ODEs"]},
  "pseudo ODE"->{
    Cell[85137, 2680, 790, 16, 159, "Text",
      Evaluatable->False,
      CellTags->"pseudo ODE"]},
  "ODE"->{
    Cell[86212, 2705, 1171, 30, 201, "Text",
      Evaluatable->False,
      CellTags->"ODE"]},
  "Integrating Exact PDEs"->{
    Cell[87872, 2755, 161, 4, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Integrating Exact PDEs"]},
  "exact ODE"->{
    Cell[88036, 2761, 823, 17, 138, "Text",
      Evaluatable->False,
      CellTags->{"exact ODE", "integrating factor"}]},
  "integrating factor"->{
    Cell[88036, 2761, 823, 17, 138, "Text",
      Evaluatable->False,
      CellTags->{"exact ODE", "integrating factor"}]},
  "Potential Representation"->{
    Cell[91204, 2856, 165, 4, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Potential Representation"]},
  "potential representation"->{
    Cell[91372, 2862, 465, 12, 75, "Text",
      Evaluatable->False,
      CellTags->"potential representation"]},
  "Simplification of Equations"->{
    Cell[96298, 3050, 219, 9, 52, "Section",
      Evaluatable->False,
      CellTags->"Simplification of Equations"]},
  "simplification of the determining equations"->{
    Cell[96520, 3061, 314, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"simplification of the determining equations"]},
  "Direct Separation"->{
    Cell[96859, 3073, 151, 4, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Direct Separation"]},
  "pseudo polynomial representation"->{
    Cell[97013, 3079, 1437, 28, 285, "Text",
      Evaluatable->False,
      CellTags->{"pseudo polynomial representation", "pseudo polynomial"}]},
  "pseudo polynomial"->{
    Cell[97013, 3079, 1437, 28, 285, "Text",
      Evaluatable->False,
      CellTags->{"pseudo polynomial representation", "pseudo polynomial"}]},
  "Indirect Separation"->{
    Cell[102261, 3234, 155, 4, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Indirect Separation"]},
  "Reducing the Number of Dependent Variables"->{
    Cell[107291, 3409, 201, 4, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Reducing the Number of Dependent Variables"]},
  "elimination of unknown functions"->{
    Cell[109677, 3473, 226, 7, 33, "Text",
      Evaluatable->False,
      CellTags->"elimination of unknown functions"]},
  "PDESolve[]"->{
    Cell[111256, 3527, 746, 18, 138, "Text",
      Evaluatable->False,
      CellTags->"PDESolve[]"]},
  "Korteweg de Vries equation"->{
    Cell[114119, 3622, 255, 7, 54, "Text",
      Evaluatable->False,
      CellTags->"Korteweg de Vries equation"]},
  "Examples"->{
    Cell[115763, 3684, 180, 9, 52, "Section",
      Evaluatable->False,
      CellTags->"Examples"]},
  "Liouville Type Equation of Quantum Gravity Theory"->{
    Cell[116562, 3711, 215, 4, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Liouville Type Equation of Quantum Gravity Theory"]},
  "quantum gravity theory"->{
    Cell[116780, 3717, 503, 12, 75, "Text",
      Evaluatable->False,
      CellTags->"quantum gravity theory"]},
  "Riemann metric"->{
    Cell[117501, 3737, 606, 14, 96, "Text",
      Evaluatable->False,
      CellTags->{"Riemann metric", "Killing equation"}]},
  "Killing equation"->{
    Cell[117501, 3737, 606, 14, 96, "Text",
      Evaluatable->False,
      CellTags->{"Riemann metric", "Killing equation"}]},
  "Laplace equation"->{
    Cell[124616, 3917, 609, 19, 75, "Text",
      Evaluatable->False,
      CellTags->"Laplace equation"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Solution of Coupled Linear Partial Differential Equations", 129954, \
4070},
  {"Introduction", 130346, 4078},
  {"coupled linear partial differential equations", 130742, 4086},
  {"invariance conditions", 131120, 4094},
  {"point symmetries", 131493, 4102},
  {"potential symmetries", 131870, 4110},
  {"approximate symmetries", 132249, 4118},
  {"generalized symmetries", 132628, 4126},
  {"automatic derivation of solutions", 133018, 4134},
  {"computer algebra", 133391, 4142},
  {"automatic procedure", 133767, 4150},
  {"differential Groebner technique", 133953, 4154},
  {"decoupling of the equations", 134135, 4158},
  {"integration of simple equations", 134293, 4162},
  {"simplification of the equations", 134455, 4166},
  {"solution procedure", 134604, 4170},
  {"general canonical form", 134797, 4175},
  {"Janet", 135615, 4195},
  {"Riquier", 135793, 4200},
  {"integration procedure for PDEs", 135994, 4205},
  {"general canonical algorithm", 136224, 4211},
  {"General Canonical Form of PDEs", 136457, 4217},
  {"forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]", 136634, 4221},
  {"coupled differential equations", 136984, 4229},
  {"Groebner basis algorithm", 137328, 4237},
  {"Groebner algorithm for differential equations", 137836, 4248},
  {"Definition: Canonical form", 138182, 4256},
  {"Schwarzian integrability conditions", 138318, 4259},
  {"simplifying the original equations", 138735, 4269},
  {"several algorithms", 138884, 4273},
  {"properties of a general canonical form", 139039, 4277},
  {"leading derivatives", 139193, 4281},
  {"disjunct", 139321, 4285},
  {"nontrivial derivative", 139451, 4289},
  {"elimination ideals", 139591, 4293},
  {"total degree ordering", 139799, 4299},
  {"lexicographic ordering", 140008, 4305},
  {"total ordering of derivatives", 140224, 4311},
  {"lexicographic ordering of the derivatives", 140395, 4315},
  {"lexicographic ordering of function names", 140577, 4319},
  {"solution manifold of an equations", 140751, 4323},
  {"canonical algorithm", 140901, 4327},
  {"integrability conditions", 141071, 4331},
  {"nonlinear PDEs", 141207, 4335},
  {"Application of the General Form Algorithm", 141362, 4339},
  {"GroebnerBasis[]", 141495, 4342},
  {"Groebner basis", 141787, 4350},
  {"polynomials", 142178, 4361},
  {"standard bases", 142376, 4367},
  {"method of manipulating a set of polynomials", 142603, 4373},
  {"canonical form", 142761, 4377},
  {"Buchberger algorithm", 142922, 4381},
  {"equivalent system of PDEs", 143088, 4385},
  {"differential representation", 143238, 4389},
  {"DSolve[]", 143374, 4393},
  {"GeneralCanonicalForm[]", 143503, 4397},
  {"integrability condition", 143792, 4404},
  {"Solution of Linear PDEs", 143936, 4408},
  {"Integration of Monomials", 144084, 4412},
  {"monomial", 144220, 4416},
  {"integration of a monomial", 144351, 4420},
  {"Integrating ODEs and Pseudo-ODEs", 144507, 4424},
  {"pseudo ODE", 144653, 4428},
  {"ODE", 144766, 4432},
  {"Integrating Exact PDEs", 144892, 4436},
  {"exact ODE", 145027, 4440},
  {"integrating factor", 145178, 4444},
  {"Potential Representation", 145335, 4448},
  {"potential representation", 145487, 4452},
  {"Simplification of Equations", 145637, 4456},
  {"simplification of the determining equations", 145808, 4460},
  {"Direct Separation", 145966, 4464},
  {"pseudo polynomial representation", 146119, 4468},
  {"pseudo polynomial", 146292, 4472},
  {"Indirect Separation", 146467, 4476},
  {"Reducing the Number of Dependent Variables", 146633, 4480},
  {"elimination of unknown functions", 146812, 4484},
  {"PDESolve[]", 146953, 4488},
  {"Korteweg de Vries equation", 147090, 4492},
  {"Examples", 147223, 4496},
  {"Liouville Type Equation of Quantum Gravity Theory", 147382, 4500},
  {"quantum gravity theory", 147558, 4504},
  {"Riemann metric", 147694, 4508},
  {"Killing equation", 147846, 4512},
  {"Laplace equation", 147998, 4516}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 375, 5, 117, "ChapterLine",
  CounterAssignments->{{"Title", 9}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Solution of Coupled Linear Partial Differential Equations"],
Cell[2117, 58, 359, 7, 229, "Title",
  CounterAssignments->{{"Title", 9}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],

Cell[CellGroupData[{
Cell[2501, 69, 406, 12, 52, "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 10}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],
Cell[2910, 83, 1584, 35, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "coupled linear partial differential equations", "invariance conditions", 
    "point symmetries", "potential symmetries", "approximate symmetries", 
    "generalized symmetries", "automatic derivation of solutions", 
    "computer algebra"}],
Cell[4497, 120, 1364, 30, 201, "Text",
  Evaluatable->False,
  CellTags->{"automatic procedure", "differential Groebner technique"}],
Cell[5864, 152, 214, 5, 26, "ListItem",
  Evaluatable->False,
  CellTags->"decoupling of the equations"],
Cell[6081, 159, 196, 5, 26, "ListItem",
  Evaluatable->False,
  CellTags->"integration of simple equations"],
Cell[6280, 166, 196, 5, 26, "ListItem",
  Evaluatable->False,
  CellTags->"simplification of the equations"],
Cell[6479, 173, 849, 17, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "solution procedure", "general canonical form", "Janet", "Riquier"}],
Cell[7331, 192, 593, 13, 117, "Text",
  Evaluatable->False,
  CellTags->{
  "integration procedure for PDEs", "general canonical form", 
    "general canonical algorithm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7961, 210, 225, 9, 52, "Section",
  Evaluatable->False,
  CellTags->"General Canonical Form of PDEs"],
Cell[8189, 221, 1491, 35, 201, "Text",
  Evaluatable->False,
  CellTags->{
  "general canonical form", 
    "forme canonique g\[EAcute]n\[EAcute]ral\[EAcute]", 
    "coupled differential equations", "Groebner basis algorithm", 
    "Groebner algorithm for differential equations"}],
Cell[9683, 258, 90, 1, 38, "Definition",
  CellTags->"Definition: Canonical form"],
Cell[9776, 261, 444, 8, 75, "Text",
  Evaluatable->False,
  CellTags->"Schwarzian integrability conditions"],
Cell[10223, 271, 344, 8, 75, "Text",
  Evaluatable->False,
  CellTags->"simplifying the original equations"],
Cell[10570, 281, 996, 26, 117, "Text",
  Evaluatable->False,
  CellTags->"several algorithms"],
Cell[11569, 309, 723, 13, 159, "Text",
  Evaluatable->False],
Cell[12295, 324, 251, 7, 54, "Text",
  Evaluatable->False,
  CellTags->"properties of a general canonical form"],
Cell[12549, 333, 276, 8, 45, "ListItem",
  Evaluatable->False,
  CellTags->"leading derivatives"],
Cell[12828, 343, 283, 8, 45, "ListItem",
  Evaluatable->False],
Cell[13114, 353, 215, 8, 26, "ListItem",
  Evaluatable->False,
  CellTags->"disjunct"],
Cell[13332, 363, 290, 9, 45, "ListItem",
  Evaluatable->False,
  CellTags->"nontrivial derivative"],
Cell[13625, 374, 222, 5, 26, "ListItem",
  Evaluatable->False,
  CellTags->"Schwarzian integrability conditions"],
Cell[13850, 381, 1237, 24, 222, "Text",
  Evaluatable->False,
  CellTags->{
  "elimination ideals", "total degree ordering", "lexicographic ordering"}],
Cell[15090, 407, 270, 9, 26, "ListItem",
  Evaluatable->False],
Cell[15363, 418, 906, 27, 26, "ListItem",
  Evaluatable->False],
Cell[16272, 447, 438, 9, 96, "Text",
  Evaluatable->False],
Cell[16713, 458, 250, 6, 26, "ListItem",
  Evaluatable->False,
  CellTags->"total ordering of derivatives"],
Cell[16966, 466, 167, 4, 29, "DisplayFormula"],
Cell[17136, 472, 235, 9, 26, "ListItem"],
Cell[17374, 483, 270, 6, 26, "ListItem",
  Evaluatable->False,
  CellTags->"lexicographic ordering of the derivatives"],
Cell[17647, 491, 204, 4, 30, "DisplayFormula"],
Cell[17854, 497, 268, 6, 26, "ListItem",
  Evaluatable->False,
  CellTags->"lexicographic ordering of function names"],
Cell[18125, 505, 170, 4, 28, "DisplayFormula"],
Cell[18298, 511, 487, 10, 96, "Text",
  Evaluatable->False,
  CellTags->"solution manifold of an equations"],
Cell[18788, 523, 782, 14, 159, "Text",
  Evaluatable->False,
  CellTags->{"general canonical form", "canonical algorithm"}],
Cell[19573, 539, 594, 11, 138, "Text",
  Evaluatable->False],
Cell[20170, 552, 490, 10, 96, "Text",
  Evaluatable->False,
  CellTags->"integrability conditions"],
Cell[20663, 564, 686, 12, 159, "Text",
  Evaluatable->False],
Cell[21352, 578, 596, 18, 30, "NumberedEquation",
  Evaluatable->False],
Cell[21951, 598, 541, 16, 30, "NumberedEquation",
  Evaluatable->False],
Cell[22495, 616, 180, 8, 33, "Text",
  Evaluatable->False],
Cell[22678, 626, 225, 6, 29, "NumberedEquation",
  Evaluatable->False],
Cell[22906, 634, 1293, 22, 264, "Text",
  Evaluatable->False,
  CellTags->"nonlinear PDEs"],

Cell[CellGroupData[{
Cell[24224, 660, 140, 2, 49, "Subsection",
  CellTags->"Application of the General Form Algorithm"],
Cell[24367, 664, 1549, 29, 306, "Text",
  Evaluatable->False,
  CellTags->{
  "GroebnerBasis[]", "Groebner basis", "polynomials", "standard bases"}],

Cell[CellGroupData[{
Cell[25941, 697, 66, 1, 27, "Input"],
Cell[26010, 700, 49, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26096, 706, 60, 1, 27, "Input"],
Cell[26159, 709, 45, 1, 30, "Output"]
}, Open  ]],
Cell[26219, 713, 229, 8, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[26473, 725, 82, 1, 27, "Input"],
Cell[26558, 728, 71, 1, 30, "Output"]
}, Open  ]],
Cell[26644, 732, 392, 12, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[27061, 748, 76, 1, 27, "Input"],
Cell[27140, 751, 672, 16, 70, "Output"]
}, Open  ]],
Cell[27827, 770, 319, 7, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28171, 781, 89, 1, 27, "Input"],
Cell[28263, 784, 672, 16, 70, "Output"]
}, Open  ]],
Cell[28950, 803, 215, 6, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29190, 813, 65, 1, 27, "Input"],
Cell[29258, 816, 49, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29344, 822, 51, 1, 27, "Input"],
Cell[29398, 825, 41, 1, 30, "Output"]
}, Open  ]],
Cell[29454, 829, 167, 4, 33, "Text",
  Evaluatable->False,
  CellTags->"Groebner basis"],

Cell[CellGroupData[{
Cell[29646, 837, 83, 1, 27, "Input"],
Cell[29732, 840, 44, 1, 30, "Output"]
}, Open  ]],
Cell[29791, 844, 157, 5, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29973, 853, 72, 1, 27, "Input"],
Cell[30048, 856, 67, 1, 30, "Output"]
}, Open  ]],
Cell[30130, 860, 138, 3, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[30293, 867, 72, 1, 27, "Input"],
Cell[30368, 870, 67, 1, 30, "Output"]
}, Open  ]],
Cell[30450, 874, 318, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"GroebnerBasis[]"],
Cell[30771, 884, 467, 13, 96, "Text",
  Evaluatable->False],
Cell[31241, 899, 411, 13, 29, "NumberedEquation",
  Evaluatable->False],
Cell[31655, 914, 339, 11, 29, "NumberedEquation",
  Evaluatable->False],
Cell[31997, 927, 397, 12, 54, "Text",
  Evaluatable->False],
Cell[32397, 941, 416, 13, 29, "NumberedEquation",
  Evaluatable->False],
Cell[32816, 956, 360, 11, 29, "NumberedEquation",
  Evaluatable->False],
Cell[33179, 969, 478, 14, 29, "NumberedEquation",
  Evaluatable->False],
Cell[33660, 985, 201, 6, 54, "Text",
  Evaluatable->False],
Cell[33864, 993, 386, 12, 29, "NumberedEquation",
  Evaluatable->False],
Cell[34253, 1007, 223, 6, 28, "NumberedEquation",
  Evaluatable->False],
Cell[34479, 1015, 336, 10, 29, "NumberedEquation",
  Evaluatable->False],
Cell[34818, 1027, 275, 9, 54, "Text",
  Evaluatable->False],
Cell[35096, 1038, 225, 6, 28, "NumberedEquation",
  Evaluatable->False],
Cell[35324, 1046, 194, 5, 28, "NumberedEquation",
  Evaluatable->False],
Cell[35521, 1053, 349, 11, 29, "NumberedEquation",
  Evaluatable->False],
Cell[35873, 1066, 425, 11, 75, "Text",
  Evaluatable->False],
Cell[36301, 1079, 155, 4, 28, "NumberedEquation",
  Evaluatable->False],
Cell[36459, 1085, 152, 4, 28, "NumberedEquation",
  Evaluatable->False],
Cell[36614, 1091, 1085, 29, 159, "Text",
  Evaluatable->False,
  CellTags->"method of manipulating a set of polynomials"],
Cell[37702, 1122, 1256, 25, 243, "Text",
  Evaluatable->False,
  CellTags->{"canonical form", "Buchberger algorithm"}],
Cell[38961, 1149, 662, 19, 30, "NumberedEquation",
  Evaluatable->False],
Cell[39626, 1170, 468, 13, 30, "NumberedEquation",
  Evaluatable->False],
Cell[40097, 1185, 286, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"equivalent system of PDEs"],
Cell[40386, 1195, 942, 25, 138, "Text",
  Evaluatable->False],
Cell[41331, 1222, 666, 19, 30, "NumberedEquation",
  Evaluatable->False],
Cell[42000, 1243, 510, 14, 30, "NumberedEquation",
  Evaluatable->False],
Cell[42513, 1259, 603, 17, 30, "NumberedEquation",
  Evaluatable->False],
Cell[43119, 1278, 42, 0, 33, "Text"],
Cell[43164, 1280, 504, 15, 30, "NumberedEquation",
  Evaluatable->False],
Cell[43671, 1297, 165, 5, 33, "Text",
  Evaluatable->False],
Cell[43839, 1304, 667, 19, 30, "NumberedEquation",
  Evaluatable->False],
Cell[44509, 1325, 519, 15, 30, "NumberedEquation",
  Evaluatable->False],
Cell[45031, 1342, 605, 17, 30, "NumberedEquation",
  Evaluatable->False],
Cell[45639, 1361, 166, 5, 33, "Text",
  Evaluatable->False],
Cell[45808, 1368, 693, 19, 30, "NumberedEquation",
  Evaluatable->False],
Cell[46504, 1389, 484, 15, 30, "NumberedEquation",
  Evaluatable->False],
Cell[46991, 1406, 682, 19, 30, "NumberedEquation",
  Evaluatable->False],
Cell[47676, 1427, 388, 8, 96, "Text",
  Evaluatable->False],
Cell[48067, 1437, 340, 11, 30, "NumberedEquation",
  Evaluatable->False],
Cell[48410, 1450, 335, 10, 28, "NumberedEquation",
  Evaluatable->False],
Cell[48748, 1462, 142, 3, 33, "Text",
  Evaluatable->False],
Cell[48893, 1467, 368, 12, 29, "NumberedEquation",
  Evaluatable->False],
Cell[49264, 1481, 1149, 21, 243, "Text",
  Evaluatable->False,
  CellTags->"differential representation"],

Cell[CellGroupData[{
Cell[50438, 1506, 401, 8, 81, "Input"],
Cell[50842, 1516, 781, 21, 50, "Output"]
}, Open  ]],
Cell[51638, 1540, 241, 6, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[51904, 1550, 70, 1, 27, "Input"],
Cell[51977, 1553, 378, 11, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52392, 1569, 70, 1, 27, "Input"],
Cell[52465, 1572, 170, 5, 30, "Output"]
}, Open  ]],
Cell[52650, 1580, 354, 8, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[53029, 1592, 272, 5, 63, "Input"],
Cell[53304, 1599, 395, 11, 30, "Output"]
}, Open  ]],
Cell[53714, 1613, 240, 6, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[53979, 1623, 73, 1, 27, "Input"],
Cell[54055, 1626, 49, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54141, 1632, 71, 1, 27, "Input"],
Cell[54215, 1635, 41, 1, 30, "Output"]
}, Open  ]],
Cell[54271, 1639, 294, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"Groebner basis"],

Cell[CellGroupData[{
Cell[54590, 1651, 79, 1, 27, "Input"],
Cell[54672, 1654, 44, 1, 30, "Output"]
}, Open  ]],
Cell[54731, 1658, 275, 9, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[55031, 1671, 74, 1, 27, "Input"],
Cell[55108, 1674, 454, 13, 30, "Output"]
}, Open  ]],
Cell[55577, 1690, 426, 12, 75, "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[56028, 1706, 121, 2, 27, "Input"],
Cell[56152, 1710, 414, 15, 43, "Output"]
}, Open  ]],
Cell[56581, 1728, 515, 20, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[57121, 1752, 80, 1, 27, "Input"],
Cell[57204, 1755, 83, 1, 30, "Output"]
}, Open  ]],
Cell[57302, 1759, 274, 11, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[57601, 1774, 80, 1, 27, "Input"],
Cell[57684, 1777, 65, 1, 30, "Output"]
}, Open  ]],
Cell[57764, 1781, 511, 23, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[58300, 1808, 72, 1, 27, "Input"],
Cell[58375, 1811, 76, 1, 30, "Output"]
}, Open  ]],
Cell[58466, 1815, 448, 16, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[58939, 1835, 104, 2, 27, "Input"],
Cell[59046, 1839, 84, 1, 30, "Output"]
}, Open  ]],
Cell[59145, 1843, 357, 10, 75, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[59527, 1857, 61, 1, 27, "Input"],
Cell[59591, 1860, 40, 1, 30, "Output"]
}, Open  ]],
Cell[59646, 1864, 181, 6, 33, "Text",
  Evaluatable->False],
Cell[59830, 1872, 906, 19, 159, "Text",
  Evaluatable->False,
  CellTags->{"GeneralCanonicalForm[]", "Groebner basis algorithm"}],
Cell[60739, 1893, 353, 11, 54, "Text",
  Evaluatable->False],
Cell[61095, 1906, 1722, 41, 31, "NumberedEquation",
  Evaluatable->False],
Cell[62820, 1949, 262, 7, 54, "Text",
  Evaluatable->False],
Cell[63085, 1958, 531, 15, 32, "NumberedEquation",
  Evaluatable->False],
Cell[63619, 1975, 727, 21, 35, "NumberedEquation",
  Evaluatable->False],
Cell[64349, 1998, 925, 31, 75, "Text",
  Evaluatable->False],
Cell[65277, 2031, 467, 15, 32, "NumberedEquation",
  Evaluatable->False],
Cell[65747, 2048, 146, 3, 33, "Text",
  Evaluatable->False],
Cell[65896, 2053, 1067, 30, 35, "NumberedEquation",
  Evaluatable->False],
Cell[66966, 2085, 504, 15, 35, "NumberedEquation",
  Evaluatable->False],
Cell[67473, 2102, 421, 12, 75, "Text",
  Evaluatable->False],
Cell[67897, 2116, 630, 18, 55, "NumberedEquation",
  Evaluatable->False],
Cell[68530, 2136, 560, 19, 54, "Text",
  Evaluatable->False],
Cell[69093, 2157, 173, 5, 30, "NumberedEquation",
  Evaluatable->False],
Cell[69269, 2164, 245, 7, 32, "NumberedEquation",
  Evaluatable->False],
Cell[69517, 2173, 416, 9, 96, "Text",
  Evaluatable->False,
  CellTags->"integrability condition"],
Cell[69936, 2184, 648, 19, 32, "NumberedEquation",
  Evaluatable->False],
Cell[70587, 2205, 688, 18, 96, "Text",
  Evaluatable->False,
  CellTags->"Schwarzian integrability conditions"],
Cell[71278, 2225, 193, 5, 30, "NumberedEquation",
  Evaluatable->False],
Cell[71474, 2232, 333, 10, 32, "NumberedEquation",
  Evaluatable->False],
Cell[71810, 2244, 19, 0, 33, "Text"],
Cell[71832, 2246, 189, 5, 30, "NumberedEquation",
  Evaluatable->False],
Cell[72024, 2253, 1607, 48, 201, "Text",
  Evaluatable->False,
  CellTags->"GeneralCanonicalForm[]"],

Cell[CellGroupData[{
Cell[73656, 2305, 58, 1, 27, "Input"],
Cell[73717, 2308, 226, 5, 70, "Output"]
}, Open  ]],
Cell[73958, 2316, 132, 3, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[74115, 2323, 431, 7, 101, "Input"],
Cell[74549, 2332, 87, 1, 30, "Output"],
Cell[74639, 2335, 87, 1, 30, "Output"],
Cell[74729, 2338, 86, 1, 30, "Output"],
Cell[74818, 2341, 87, 1, 30, "Output"],
Cell[74908, 2344, 87, 1, 30, "Output"],
Cell[74998, 2347, 671, 22, 61, "Output"]
}, Open  ]],
Cell[75684, 2372, 482, 10, 117, "Text",
  Evaluatable->False],
Cell[76169, 2384, 334, 11, 29, "NumberedEquation",
  Evaluatable->False],
Cell[76506, 2397, 19, 0, 33, "Text"],
Cell[76528, 2399, 373, 12, 29, "NumberedEquation",
  Evaluatable->False],
Cell[76904, 2413, 392, 10, 75, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[77345, 2429, 211, 9, 52, "Section",
  Evaluatable->False,
  CellTags->"Solution of Linear PDEs"],
Cell[77559, 2440, 1107, 20, 243, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[78691, 2464, 165, 4, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Integration of Monomials"],
Cell[78859, 2470, 234, 7, 54, "Text",
  Evaluatable->False,
  CellTags->"monomial"],
Cell[79096, 2479, 585, 15, 53, "NumberedEquation"],
Cell[79684, 2496, 938, 29, 96, "Text",
  Evaluatable->False],
Cell[80625, 2527, 565, 13, 58, "NumberedEquation"],
Cell[81193, 2542, 691, 24, 75, "Text",
  Evaluatable->False],
Cell[81887, 2568, 733, 19, 96, "Text",
  Evaluatable->False,
  CellTags->"integration of a monomial"],
Cell[82623, 2589, 315, 9, 54, "Text",
  Evaluatable->False],
Cell[82941, 2600, 173, 5, 28, "NumberedEquation",
  Evaluatable->False],
Cell[83117, 2607, 712, 25, 96, "Text",
  Evaluatable->False],
Cell[83832, 2634, 304, 9, 28, "NumberedEquation",
  Evaluatable->False],
Cell[84139, 2645, 777, 24, 117, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[84953, 2674, 181, 4, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Integrating ODEs and Pseudo-ODEs"],
Cell[85137, 2680, 790, 16, 159, "Text",
  Evaluatable->False,
  CellTags->"pseudo ODE"],
Cell[85930, 2698, 279, 5, 29, "NumberedEquation"],
Cell[86212, 2705, 1171, 30, 201, "Text",
  Evaluatable->False,
  CellTags->"ODE"],
Cell[87386, 2737, 449, 13, 75, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[87872, 2755, 161, 4, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Integrating Exact PDEs"],
Cell[88036, 2761, 823, 17, 138, "Text",
  Evaluatable->False,
  CellTags->{"exact ODE", "integrating factor"}],
Cell[88862, 2780, 600, 20, 75, "Text",
  Evaluatable->False],
Cell[89465, 2802, 782, 22, 47, "NumberedEquation",
  Evaluatable->False],
Cell[90250, 2826, 917, 25, 138, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[91204, 2856, 165, 4, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Potential Representation"],
Cell[91372, 2862, 465, 12, 75, "Text",
  Evaluatable->False,
  CellTags->"potential representation"],
Cell[91840, 2876, 134, 3, 29, "NumberedEquation"],
Cell[91977, 2881, 526, 20, 54, "Text",
  Evaluatable->False],
Cell[92506, 2903, 295, 7, 29, "NumberedEquation"],
Cell[92804, 2912, 761, 18, 138, "Text",
  Evaluatable->False],
Cell[93568, 2932, 326, 12, 26, "ListItem",
  Evaluatable->False],
Cell[93897, 2946, 310, 12, 26, "ListItem",
  Evaluatable->False],
Cell[94210, 2960, 251, 9, 26, "ListItem",
  Evaluatable->False],
Cell[94464, 2971, 98, 3, 33, "Text",
  Evaluatable->False],
Cell[94565, 2976, 347, 15, 26, "ListItem",
  Evaluatable->False],
Cell[94915, 2993, 245, 9, 26, "ListItem",
  Evaluatable->False],
Cell[95163, 3004, 263, 9, 26, "ListItem",
  Evaluatable->False],
Cell[95429, 3015, 502, 19, 33, "Text",
  Evaluatable->False],
Cell[95934, 3036, 315, 8, 75, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[96298, 3050, 219, 9, 52, "Section",
  Evaluatable->False,
  CellTags->"Simplification of Equations"],
Cell[96520, 3061, 314, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"simplification of the determining equations"],

Cell[CellGroupData[{
Cell[96859, 3073, 151, 4, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Direct Separation"],
Cell[97013, 3079, 1437, 28, 285, "Text",
  Evaluatable->False,
  CellTags->{"pseudo polynomial representation", "pseudo polynomial"}],
Cell[98453, 3109, 277, 6, 31, "NumberedEquation"],
Cell[98733, 3117, 405, 12, 75, "Text",
  Evaluatable->False],
Cell[99141, 3131, 224, 5, 30, "NumberedEquation",
  Evaluatable->False],
Cell[99368, 3138, 208, 6, 28, "NumberedEquation",
  Evaluatable->False],
Cell[99579, 3146, 217, 6, 30, "NumberedEquation",
  Evaluatable->False],
Cell[99799, 3154, 442, 11, 96, "Text",
  Evaluatable->False],
Cell[100244, 3167, 222, 5, 30, "NumberedEquation",
  Evaluatable->False],
Cell[100469, 3174, 208, 6, 28, "NumberedEquation",
  Evaluatable->False],
Cell[100680, 3182, 159, 2, 28, "NumberedEquation"],
Cell[100842, 3186, 156, 2, 30, "NumberedEquation"],
Cell[101001, 3190, 221, 6, 54, "Text",
  Evaluatable->False],
Cell[101225, 3198, 443, 14, 28, "NumberedEquation",
  Evaluatable->False],
Cell[101671, 3214, 553, 15, 96, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[102261, 3234, 155, 4, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Indirect Separation"],
Cell[102419, 3240, 821, 14, 180, "Text",
  Evaluatable->False],
Cell[103243, 3256, 202, 6, 54, "Text",
  Evaluatable->False],
Cell[103448, 3264, 177, 5, 28, "NumberedEquation",
  Evaluatable->False],
Cell[103628, 3271, 321, 11, 54, "Text",
  Evaluatable->False],
Cell[103952, 3284, 176, 5, 30, "NumberedEquation",
  Evaluatable->False],
Cell[104131, 3291, 760, 25, 96, "Text",
  Evaluatable->False],
Cell[104894, 3318, 154, 4, 28, "NumberedEquation",
  Evaluatable->False],
Cell[105051, 3324, 382, 14, 54, "Text",
  Evaluatable->False],
Cell[105436, 3340, 172, 5, 28, "NumberedEquation",
  Evaluatable->False],
Cell[105611, 3347, 350, 12, 54, "Text",
  Evaluatable->False],
Cell[105964, 3361, 205, 6, 43, "NumberedEquation",
  Evaluatable->False],
Cell[106172, 3369, 577, 23, 54, "Text",
  Evaluatable->False],
Cell[106752, 3394, 502, 10, 117, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[107291, 3409, 201, 4, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Reducing the Number of Dependent Variables"],
Cell[107495, 3415, 1191, 19, 285, "Text",
  Evaluatable->False],
Cell[108689, 3436, 278, 8, 45, "ListItem",
  Evaluatable->False],
Cell[108970, 3446, 199, 7, 26, "ListItem",
  Evaluatable->False],
Cell[109172, 3455, 196, 7, 26, "ListItem",
  Evaluatable->False],
Cell[109371, 3464, 303, 7, 75, "Text",
  Evaluatable->False],
Cell[109677, 3473, 226, 7, 33, "Text",
  Evaluatable->False,
  CellTags->"elimination of unknown functions"],
Cell[109906, 3482, 186, 5, 28, "NumberedEquation",
  Evaluatable->False],
Cell[110095, 3489, 1158, 36, 117, "Text",
  Evaluatable->False],
Cell[111256, 3527, 746, 18, 138, "Text",
  Evaluatable->False,
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{
Cell[112027, 3549, 273, 5, 63, "Input"],
Cell[112303, 3556, 880, 22, 149, "Output"]
}, Open  ]],
Cell[113198, 3581, 282, 8, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[113505, 3593, 46, 1, 27, "Input"],
Cell[113554, 3596, 157, 4, 50, "Output"]
}, Open  ]],
Cell[113726, 3603, 186, 7, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[113937, 3614, 50, 1, 27, "Input"],
Cell[113990, 3617, 114, 2, 30, "Output"]
}, Open  ]],
Cell[114119, 3622, 255, 7, 54, "Text",
  Evaluatable->False,
  CellTags->"Korteweg de Vries equation"],

Cell[CellGroupData[{
Cell[114399, 3633, 124, 2, 45, "Input"],
Cell[114526, 3637, 1002, 33, 93, "Output"]
}, Open  ]],
Cell[115543, 3673, 171, 5, 33, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[115763, 3684, 180, 9, 52, "Section",
  Evaluatable->False,
  CellTags->"Examples"],
Cell[115946, 3695, 591, 12, 117, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[116562, 3711, 215, 4, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Liouville Type Equation of Quantum Gravity Theory"],
Cell[116780, 3717, 503, 12, 75, "Text",
  Evaluatable->False,
  CellTags->"quantum gravity theory"],
Cell[117286, 3731, 212, 4, 31, "NumberedEquation"],
Cell[117501, 3737, 606, 14, 96, "Text",
  Evaluatable->False,
  CellTags->{"Riemann metric", "Killing equation"}],
Cell[118110, 3753, 196, 6, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[118331, 3763, 2706, 60, 64, "Input"],
Cell[121040, 3825, 1413, 33, 295, "Output"]
}, Open  ]],
Cell[122468, 3861, 560, 17, 96, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[123053, 3882, 311, 6, 81, "Input"],
Cell[123367, 3890, 1234, 24, 149, "Output"]
}, Open  ]],
Cell[124616, 3917, 609, 19, 75, "Text",
  Evaluatable->False,
  CellTags->"Laplace equation"],
Cell[125228, 3938, 156, 3, 31, "NumberedEquation"],
Cell[125387, 3943, 1121, 24, 222, "Text",
  Evaluatable->False],
Cell[126511, 3969, 279, 8, 54, "Text",
  Evaluatable->False],
Cell[126793, 3979, 322, 10, 28, "NumberedEquation",
  Evaluatable->False],
Cell[127118, 3991, 786, 21, 117, "Text",
  Evaluatable->False],
Cell[127907, 4014, 145, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

