(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     39497,       1544]*)
(*NotebookOutlinePosition[     59380,       2209]*)
(*  CellTagsIndexPosition[     55056,       2062]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[" ", "ChapterLine"],

Cell["References", "Title",
  CounterAssignments->{{"Title", 11}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[TextData[StyleBox["A",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"A"],

Cell[TextData[{
  "B. Abraham-Schrauner and A. Guo, Hidden and nonlocal symmetries of \
nonlinear differential equations, pp. 1-5, In: ",
  StyleBox[
  "Modern Group Analysis: Advanced Analytical and Computational Methods in \
Mathematical Physics",
    FontSlant->"Italic"],
  ", Eds: N.H. Ibragimov, M. Torrisi, and A. Valenti, Kluwer, Dordrecht, \
1993."
}], "Text",
  CellTags->"Abraham-Schrauner-93"],

Cell[TextData[{
  "A.A. Alexeyev, Approximating pseudopotentials, scattering problems, and B\
\[ADoubleDot]cklund transformations for the Korteweg-de Vries and modified \
Korteweg-de Vries equations with perturbations, ",
  StyleBox["J. Phys. A: Math. Gen",
    FontSlant->"Italic"],
  ". ",
  StyleBox["27",
    FontWeight->"Bold"],
  ", 865\[Dash]881 (1994)."
}], "Text",
  CellTags->"Alexeyev-1994"],

Cell[TextData[{
  "W.F. Ames, ",
  StyleBox[
  "Nonlinear Ordinary Differential Equations in Transport Processes",
    FontSlant->"Italic"],
  ", Academic Press, New York, 1968."
}], "Text",
  CellTags->"Ames-68"],

Cell[TextData[StyleBox["B",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"B"],

Cell[TextData[{
  "V.A. Baikov, R.K. Gazizov, and N.H. Ibragimov, Approximate symmetries, ",
  StyleBox["Math. USSR Sbornik",
    FontSlant->"Italic"],
  ", ",
  StyleBox["46",
    FontWeight->"Bold"],
  ", 427\[Dash]441 (1989)."
}], "Text",
  CellTags->"Baik-89"],

Cell[TextData[{
  "V.A. Baikov, R.K. Gazizov, and N.H. Ibragimov, Perturbation methods in \
group analysis, ",
  StyleBox["J. Sov. Math.",
    FontSlant->"Italic"],
  " ",
  StyleBox["55",
    FontWeight->"Bold"],
  ", 1450 (1991)."
}], "Text",
  Evaluatable->False,
  CellTags->"Baik-91"],

Cell[TextData[{
  "G. Baumann, Integrability and chaos for two copropagating pulses in \
optical fibers, ",
  StyleBox["Phys. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["A156",
    FontWeight->"Bold"],
  ", 298\[Dash]302 (1991)."
}], "Text",
  CellTags->"Baumann-1991"],

Cell[TextData[{
  "G. Baumann, Lie Symmetries of Differential Equations, A ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " program to determine Lie symmetries, Wolfram Research, Inc., Champaign, \
IL, Math-Source 0202\[Dash]622 (1992)."
}], "Text",
  CellTags->"Baum-92"],

Cell[TextData[{
  "G. Baumann, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["in Theoretical Physics",
    FontSlant->"Italic"],
  ", Springer-Verlag/TELOS, New York, 1996."
}], "Text",
  CellTags->"Baum-96"],

Cell[TextData[{
  "G. Baumann, Symmetry analysis of differential equations with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Math. Comput. Modelling",
    FontSlant->"Italic"],
  " ",
  StyleBox["25",
    FontWeight->"Bold"],
  ", 25\[Dash]37 (1997)."
}], "Text",
  CellTags->"Baum-95"],

Cell[TextData[{
  "G. Baumann and T.F. Nonnenmacher, Regular and chaotic motions in ion \
traps: A nonlinear analysis of trap equations, ",
  StyleBox["Phys. Rev",
    FontSlant->"Italic"],
  ". ",
  StyleBox["A 46",
    FontWeight->"Bold"],
  ", 2682\[Dash]2692 (1992)."
}], "Text",
  CellTags->"Baumann and Nonnenmacher-1992"],

Cell[TextData[{
  "G. Baumann and T.F. Nonnenmacher, Lie transformations, similarity \
reduction, and solutions for the nonlinear Madelung fluid equations with \
external potential, ",
  StyleBox["J. Math. Phys.",
    FontSlant->"Italic"],
  " ",
  StyleBox["28",
    FontWeight->"Bold"],
  ", 1250\[Dash]1260 (1987)."
}], "Text",
  Evaluatable->False,
  CellTags->"Baum-87"],

Cell[TextData[{
  "G. Birkhoff, ",
  StyleBox["Hydrodynamics",
    FontSlant->"Italic"],
  ", Princeton University Press, Princeton 1950."
}], "Text",
  CellTags->"Birk-50"],

Cell[TextData[{
  "Ph. Blanchard and E. Br\[UDoubleDot]ning, ",
  StyleBox["Variational Methods in Mathematical Physics",
    FontSlant->"Italic"],
  ", Springer-Verlag, Berlin, 1992."
}], "Text",
  CellTags->"Blan-92"],

Cell[TextData[{
  "H. Blasius, Grenzschichten in Fl\[UDoubleDot]ssigkeiten mit kleiner \
Reibung, ",
  StyleBox["Z. Angew. Math. Phys.",
    FontSlant->"Italic"],
  " ",
  StyleBox["56",
    FontWeight->"Bold"],
  ", 1\[Dash]37 (1908)."
}], "Text",
  Evaluatable->False,
  CellTags->"Blas-08"],

Cell[TextData[{
  "G.W. Bluman, Potential symmetries and equivalent conservation laws, p. 71; \
In: ",
  StyleBox[
  "Modern Group Analysis: Advanced Analytical and Computational Methods in \
Mathematical Physics",
    FontSlant->"Italic"],
  ", Eds: N.H. Ibragimov, Kluwer Academic Publishers, Dordrecht, 1993."
}], "Text",
  CellTags->"Blu-93"],

Cell["\<\
G.W. Bluman, The Use of Factors to Discover Potential Systems or \
Linearizations, preprint (1993).\
\>", "Text",
  CellTags->"Blu-93a"],

Cell[TextData[{
  "G.W. Bluman and J.D. Cole, The general simlarity solution of the heat \
equation, ",
  StyleBox["J. Math. Mech.",
    FontSlant->"Italic"],
  " ",
  StyleBox["18",
    FontWeight->"Bold"],
  ", 1025\[Dash]1042 (1969)."
}], "Text",
  CellTags->"Blum-69"],

Cell[TextData[{
  "G.W. Bluman and J.D. Cole, ",
  StyleBox["Similarity Methods for Differential Equations",
    FontSlant->"Italic"],
  ", Springer-Verlag, New York, 1974."
}], "Text",
  CellTags->"Bum-74"],

Cell[TextData[{
  "G.W. Bluman and S. Kumei, ",
  StyleBox["Symmetries and Differential Equations",
    FontSlant->"Italic"],
  ", Springer-Verlag, New York, 1989."
}], "Text",
  CellTags->"Blum-89"],

Cell[TextData[{
  "G.W. Bluman and S. Kumei, Symmetry-based algorithms to relate partial \
differential equations: I. Local symmetries, ",
  StyleBox["Eur. J. Appl. Math",
    FontSlant->"Italic"],
  ". ",
  StyleBox[" 1",
    FontWeight->"Bold"],
  ", 189\[Dash]216 (1990)."
}], "Text",
  CellTags->"Blum-90"],

Cell[TextData[{
  "T. Bountis, H. Segur, and F. Vivaldi, Integrable Hamiltonian systems and \
the Painlev\[EAcute] property, ",
  StyleBox["Phys. Rev",
    FontSlant->"Italic"],
  ". ",
  StyleBox["A25",
    FontWeight->"Bold"],
  ", 1257\[Dash]1264 (1982)."
}], "Text",
  CellTags->"Bountis-1982"],

Cell[TextData[{
  "J. Boussinesq, Th\[EAcute]orie des ondes te des remous qui se propagent le \
long d\.b4un canal rectangulaire horizontal, en communiquant au liquide \
contenu dans ce canal des vitesses sensiblement parielles de la surface au \
fond, ",
  StyleBox["J. Math. Pures Appl.",
    FontSlant->"Italic"],
  " ",
  StyleBox["7",
    FontWeight->"Bold"],
  ", 55 (1872)."
}], "Text",
  CellTags->"Boussinesq-1872"],

Cell[TextData[{
  "C.P. Boyer and J.D. Finley, Killing vectors in self-dual, Euclidian \
Einstein spaces, ",
  StyleBox["J. Math. Phys.",
    FontSlant->"Italic"],
  " ",
  StyleBox["23",
    FontWeight->"Bold"],
  ", 1126\[Dash]1130 (1989)."
}], "Text",
  CellTags->"Boyer-1989"],

Cell[TextData[{
  "B. Buchberger, Groebner bases: An algorithmic method in polynomial ideal \
theory, In: ",
  StyleBox["Multidimensional Systems Theory",
    FontSlant->"Italic"],
  ", Ed: N.K. Bose, Reidel Publ., Dordrecht, pp. 184\[Dash]232, 1985."
}], "Text",
  CellTags->"Buchberger-1985"],

Cell[TextData[{
  "J.M. Burgers, A mathematical model illustrating the theory of turbulence, \
",
  StyleBox["Adv. Appl. Mech.",
    FontSlant->"Italic"],
  " ",
  StyleBox["1",
    FontWeight->"Bold"],
  ", 171-199, 1948."
}], "Text",
  Evaluatable->False,
  CellTags->"Burg-48"],

Cell[TextData[StyleBox["C",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"C"],

Cell[TextData[{
  "F. Calogero and A. Degasperis, Solution by the spectral transform method \
of a nonlinear evolution equation including as a special case the cylindrical \
KdV equation, ",
  StyleBox["Lett. Nuovo Cim.",
    FontSlant->"Italic"],
  " ",
  StyleBox["23",
    FontWeight->"Bold"],
  ", 150\[Dash]154 (1978)."
}], "Text",
  CellTags->"Calogero-1978"],

Cell[TextData[{
  "F. Calogero and A. Degasperis, Reduction techniques for matrix nonlinear \
evolution equations solvable by the spectral transform, ",
  StyleBox["J. Math. Phys.",
    FontSlant->"Italic"],
  " ",
  StyleBox["22",
    FontWeight->"Bold"],
  ", 23\[Dash]31 (1981)."
}], "Text",
  CellTags->"Calogero-1981"],

Cell[TextData[{
  "G. Carr\[AGrave]-Ferro, Differential-algebraic and differential-geometric \
approach to the study of involutive symbols, pp. 93\[Dash]99, In: ",
  StyleBox[
  "Modern Group Analysis: Advanced Analytical and Computational Methods in \
Mathematical Physics",
    FontSlant->"Italic"],
  ", Eds.: N.H. Ibragimov, M. Torrisi, and A. Valenti, Kluwer, Dordrecht, \
1993."
}], "Text",
  CellTags->"Carra-Ferro-1993"],

Cell[TextData[{
  "B. Champagne, W. Hereman, and P. Winternitz, The computer calculation of \
Lie point symmetries of large systems of differential equations, ",
  StyleBox["Comp. Phys. Comm",
    FontSlant->"Italic"],
  ". ",
  StyleBox["66",
    FontWeight->"Bold"],
  ", 319-340 (1991)."
}], "Text",
  CellTags->"Champagne-1990"],

Cell[TextData[{
  "W.L. Chan and K.S. Li, Non-propagating solitons of the non-isospectral and \
variable coefficient modified KdV equation, ",
  StyleBox["J. Phys. A: Math. Gen",
    FontSlant->"Italic"],
  ". ",
  StyleBox["27",
    FontWeight->"Bold"],
  ", 883\[Dash]902 (1994)."
}], "Text",
  CellTags->"Chan-1994"],

Cell[TextData[{
  "G. Cicogna and D. Vitali, Classification of the extended symmetries of \
Fokker-Planck equations, ",
  StyleBox["J. Phys. A: Math. Gen.",
    FontSlant->"Italic"],
  " ",
  StyleBox["23",
    FontWeight->"Bold"],
  ", L85\[Dash]L88 (1990)."
}], "Text",
  CellTags->"Cicogna-1990"],

Cell[TextData[{
  "P.A. Clarkson, New similarity solutions for the modified Boussinesq \
equation, ",
  StyleBox["J. Phys. A: Math. Gen.",
    FontSlant->"Italic"],
  " ",
  StyleBox["22",
    FontWeight->"Bold"],
  ", 2355\[Dash]2367 (1989)."
}], "Text",
  Evaluatable->False,
  CellTags->"Clar-89"],

Cell[TextData[{
  "P.A. Clarkson and M.D. Kruskal, New similarity solutions of the Boussinesq \
 equation, ",
  StyleBox["J. Math. Phys.",
    FontSlant->"Italic"],
  " ",
  StyleBox["30",
    FontWeight->"Bold"],
  ", 2201\[Dash]2213 (1989)."
}], "Text",
  CellTags->"Clarkson-89"],

Cell[TextData[{
  "P.A. Clarkson and E.L. Mansfield, Algorithms for the Non-classical Method \
of Symmetry Reduction, ",
  StyleBox["SIAM J. Appl. Math. ",
    FontSlant->"Italic"],
  StyleBox["54",
    FontWeight->"Bold"],
  StyleBox[", 1693\[Dash]1719.",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " (1994)."
}], "Text",
  Evaluatable->False,
  CellTags->"Clar-94"],

Cell[TextData[{
  "R. Courant and K.O. Friederichs, ",
  StyleBox["Supersonic Flow and Shock Waves",
    FontSlant->"Italic"],
  ", Interscience Publisher, Inc., New York, 1948."
}], "Text",
  Evaluatable->False,
  CellTags->"Cour-48"],

Cell[TextData[{
  "D.G. Crighton, Model equations of nonlinear acoustics. ",
  StyleBox["Rev Fluid Mech.",
    FontSlant->"Italic"],
  StyleBox[" 11",
    FontWeight->"Bold"],
  ", 11\[Dash]23 (1979)."
}], "Text",
  Evaluatable->False,
  CellTags->"Crig-79"],

Cell[TextData[StyleBox["D",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"D"],

Cell[TextData[{
  "S. Das Sarma and P. Tamborenea, A new universality class for kinetic \
growth: One-dimensional molecular-beam epitaxy, ",
  StyleBox["Phys. Rev. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["66",
    FontWeight->"Bold"],
  ", 325\[Dash]328 (1991)."
}], "Text",
  CellTags->"Das Sarma-1991"],

Cell[TextData[{
  "P.G. Drazin, ",
  StyleBox["Solitons",
    FontSlant->"Italic"],
  ", Cambridge University Press, Cambridge, 1983."
}], "Text",
  CellTags->"Drazin-1983"],

Cell[TextData[{
  "M.S. Drew, S.C. Kloster, and J.D. Gegenberg, Lie group analysis and \
similarity solution for the equation ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[PartialD]\_\(x, x\)\ \(u(x, y, z)\) + \)\ 
      \)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]\_\(y, y\)\(u(x, y, z)\)\  + \)\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ 
      \[PartialD]\_\(z, z\)e\^\(u(x, y, z)\) = 0\)\)]],
  ", ",
  StyleBox["Nonlinear Anal. Theory Methods and Applic",
    FontSlant->"Italic"],
  "., ",
  StyleBox["13",
    FontWeight->"Bold"],
  ", 489\[Dash]505 (1989)."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Drew-1989"],

Cell[TextData[StyleBox["E",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"E"],

Cell[TextData[{
  "J. Eggers, Universal pinching of 3D axisymmetric free-surface flow, ",
  StyleBox["Phys. Rev. Lett",
    FontSlant->"Italic"],
  ". ",
  StyleBox["71",
    FontWeight->"Bold"],
  ", 3458\[Dash]3460 (1993)."
}], "Text",
  CellTags->"Eggers-1993"],

Cell[TextData[{
  "J. Eggers, Tropfenbildung, ",
  StyleBox["Phys. Bl.",
    FontSlant->"Italic"],
  " ",
  StyleBox["53",
    FontWeight->"Bold"],
  ", 431\[Dash]434 (1997)."
}], "Text",
  CellTags->"Eggers-1997"],

Cell[TextData[{
  "F. Engel,  Sophus Lie, ",
  StyleBox["Bibliotheca Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["3",
    FontWeight->"Bold"],
  ", 166\[Dash]204 (1900)."
}], "Text"],

Cell[TextData[{
  "F. Engel and P. Heegaard, ",
  StyleBox["Sophus Lie Gesammelte Abhandlungen",
    FontSlant->"Italic"],
  ", B.G. Teubner, Leipzig; H. Aschehoug & Co., Kristiania, 1912\[Dash]1934."
}], "Text",
  CellTags->"Enge-12"],

Cell[TextData[StyleBox["F",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"F"],

Cell[TextData[{
  "V.M. Falkner and  S.W. Skan, Solution of the boundary-layer equations, ",
  StyleBox["Phil. Mag",
    FontSlant->"Italic"],
  ". ",
  StyleBox["12",
    FontWeight->"Bold"],
  ", 865\[Dash]896 (1931)."
}], "Text",
  Evaluatable->False,
  CellTags->"Falk-31"],

Cell[TextData[{
  "A.S. Fokas, A symmetry approach to exactly solvable evolution equations, ",
  
  StyleBox["J. Math. Phys",
    FontSlant->"Italic"],
  ". ",
  StyleBox["21",
    FontWeight->"Bold"],
  ", 1318\[Dash]1325 (1980)."
}], "Text",
  CellTags->"Fokas-1980"],

Cell[TextData[{
  "A.S. Fokas and B. Fuchssteiner, B\[ADoubleDot]cklund transformations for \
hereditary symmetries, ",
  StyleBox["Nonlinear Theory Methods Applic",
    FontSlant->"Italic"],
  "., ",
  StyleBox["5",
    FontWeight->"Bold"],
  ", 423\[Dash]432 (1981)."
}], "Text",
  CellTags->"Fokas-1981"],

Cell[TextData[{
  "A.S. Fokas, Symmetries and integrability, ",
  StyleBox["Studies Appl. Math",
    FontSlant->"Italic"],
  "., ",
  StyleBox["77",
    FontWeight->"Bold"],
  ", 253\[Dash]299 (1987)."
}], "Text",
  CellTags->"Fokas-1987"],

Cell[TextData[{
  "P.C.W. Fung and C. Au, Bridge between the solutions and vacuum states of \
the Korteweg-de Vries equation and that of the nonlinear equation ",
  Cell[BoxData[
      \(TraditionalForm
      \`y\_t + y\_xxx - 6 \( y\^2\) y\_x + 6  \[Lambda]y\_x = 0\)]],
  ", ",
  StyleBox["Phys. Rev. B",
    FontSlant->"Italic"],
  " ",
  StyleBox["26",
    FontWeight->"Bold"],
  ", 4035\[Dash]4038 (1982)."
}], "Text",
  CellTags->"Fung-1982"],

Cell[TextData[StyleBox["G",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"G"],

Cell[TextData[{
  "F.J. Garcia and A. Castellanos, One-dimensional model for slender \
axisymmetric viscous liquid jets, ",
  StyleBox["Phys. Fluids",
    FontSlant->"Italic"],
  " ",
  StyleBox["6",
    FontWeight->"Bold"],
  ", 2676\[Dash]2689 (1994)."
}], "Text",
  CellTags->"Garcia and Castellanos-1994"],

Cell[TextData[{
  "A. Gray, Modern ",
  StyleBox["Differential Geometry of Curves and Surfaces",
    FontSlant->"Italic"],
  ", CRC Press, Boca Raton, FL, 1993."
}], "Text",
  CellTags->"Gray-1993"],

Cell[TextData[StyleBox["H",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"H"],

Cell[TextData[{
  "M. H\[EAcute]non and C. Heiles, The applicability of the third integral of \
motion: Some numerical experiments, ",
  StyleBox["Astro",
    FontSlant->"Italic"],
  "n. J. ",
  StyleBox["69",
    FontWeight->"Bold"],
  ", 73\[Dash]79 (1964)."
}], "Text",
  CellTags->"Henon-1964"],

Cell[TextData[{
  "W. Hereman, Review of symbolic software for the computation of Lie \
symmetries of differential equations, ",
  StyleBox["Euromath. Bull.",
    FontSlant->"Italic"],
  ", ",
  StyleBox["2",
    FontWeight->"Bold"],
  ", 45\[Dash]82 (1994)."
}], "Text",
  CellTags->"Here-94"],

Cell[TextData[{
  "W. Hereman, Symbolic software for Lie symmetry analysis pp. 367\[Dash]413, \
Ed.: N.H. Ibragimov, In: ",
  StyleBox[
  "CRC Handbookof Lie Group Analysis of Differential Equations, Vol. 3: New \
Trends in Theoretical Developments and Computational Methods",
    FontSlant->"Italic"],
  ", CRC Press, Boca Raton, FL, 1996."
}], "Text",
  CellTags->"Hereman-1996"],

Cell[TextData[{
  "R. Hirota and J. Satsuma, Soliton solutions of a coupled Korteweg de Vries \
equation,",
  StyleBox[" Phys. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["85",
    FontWeight->"Bold"],
  ", 407\[Dash]408 (1981)."
}], "Text",
  CellTags->"Hirota-1981"],

Cell[TextData[{
  "P.E. Hydon, Conformal symmetries of first-order ordinary differential \
equations, ",
  StyleBox["J. Phys. A: Math. Gen.",
    FontSlant->"Italic"],
  " ",
  StyleBox["27",
    FontWeight->"Bold"],
  ", 385\[Dash]392 (1994)."
}], "Text",
  CellTags->"Hydon-1994"],

Cell[TextData[StyleBox["I",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"I"],

Cell[TextData[{
  "N.H. Ibragimov, ",
  StyleBox["Transformation Groups Applied to Mathematical Physics",
    FontSlant->"Italic"],
  ", Reidel Publ., Dortrecht, 1985."
}], "Text",
  Evaluatable->False,
  CellTags->"Ibra-85"],

Cell[TextData[{
  "N.H. Ibragimov, Sophus Lie and harmony in mathematical physics, on the \
150th anniversary of his birth, ",
  StyleBox["Math. Intel.",
    FontSlant->"Italic"],
  " ",
  StyleBox["16",
    FontWeight->"Bold"],
  ", 20\[Dash]28 (1994)."
}], "Text",
  CellTags->"Ibragimov-1994"],

Cell[TextData[{
  "N.H. Ibragimov, ",
  StyleBox["CRC Handbook of Lie Group Analysis of Differential Equations",
    FontSlant->"Italic"],
  ", Vols. 1\[Dash]3, CRC Press, Boca Raton, FL 1994, 1995, 1996."
}], "Text",
  CellTags->"Ibra-949596"],

Cell[TextData[{
  "E.L. Ince, ",
  StyleBox["Ordinary Differential Equations",
    FontSlant->"Italic"],
  ", Dover Publications, New York, 1956."
}], "Text",
  CellTags->"Ince-1956"],

Cell[TextData[StyleBox["J",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"J"],

Cell[TextData[{
  "M. Janet, Sur les syst\[EGrave]mes d'\[EAcute]quation aux d\[EAcute]rive\
\[EAcute]s partielles, ",
  StyleBox["J. Math. Pure Appl.",
    FontSlant->"Italic"],
  " ",
  StyleBox["3",
    FontWeight->"Bold"],
  ", 65\[Dash]151 (1920)."
}], "Text",
  CellTags->"Janet-1920"],

Cell[TextData[StyleBox["K",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"K"],

Cell[TextData[{
  "L.P. Kadanoff, Exact solutions of the Saffman-Taylor problem with surface \
tension, ",
  StyleBox["Phys. Rev. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["65,",
    FontWeight->"Bold"],
  " 2986\[Dash]2988 (1990)."
}], "Text",
  Evaluatable->False,
  CellTags->"Kada-90"],

Cell[TextData[{
  "E. Kamke, ",
  StyleBox["Differentialgleichungen",
    FontSlant->"Italic"],
  ", G.B. Teubner, Stuttgart, 1977."
}], "Text",
  CellTags->"Kamke-1977"],

Cell[TextData[{
  "V.I. Karpman and V.Yu. Belashov, Dynamics of two-dimensional solutions in \
weakly dispersive media, ",
  StyleBox["Phys. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["154",
    FontWeight->"Bold"],
  ", 131\[Dash]139 (1991)."
}], "Text",
  Evaluatable->False,
  CellTags->"Karp-91"],

Cell[TextData[{
  "F. Klein, \[CapitalUDoubleDot]ber die Differentialgesetze f\[UDoubleDot]r \
die Erhaltung von Impuls und Energie in der Einsteinschen \
Gravitationstheorie, ",
  StyleBox["Nachr. Ges. Wiss. G\[ODoubleDot]ttingen Math. Phys",
    FontSlant->"Italic"],
  ". ",
  StyleBox["2",
    FontWeight->"Bold"],
  ", 171\[Dash]189 (1918)."
}], "Text",
  CellTags->"Klein-1918"],

Cell[TextData[{
  "K. Ko, and H.H. Kuehl, Korteweg-de Vries soliton in a slowly varying \
medium, ",
  StyleBox["Phys. Rev. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["40",
    FontWeight->"Bold"],
  ", 233\[Dash]236 (1978)."
}], "Text",
  CellTags->"Ko and Kuehl-1978"],

Cell[TextData[{
  "D.J. Korteweg, and G. de Vries, On the change of form of long waves \
advancing in a rectangular channel, and on a new type of long stationary \
waves, ",
  StyleBox["Phil. Mag.",
    FontSlant->"Italic"],
  " ",
  StyleBox["39",
    FontWeight->"Bold"],
  ", 442\[Dash]443 (1895)."
}], "Text",
  CellTags->"KortewegDeVries-1895"],

Cell[TextData[{
  "G. Kowalewski, ",
  StyleBox[
  "Einf\[UDoubleDot]hrung in die Theorie der Kontinuierlichen Gruppen",
    FontSlant->"Italic"],
  ", Akademische Verlagsgesellschaft M.B.H, Leipzig, 1931."
}], "Text",
  CellTags->"Kowa-31"],

Cell[TextData[StyleBox["L",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"L"],

Cell[TextData[{
  "H. Lamb, ",
  StyleBox["Hydrodynamics",
    FontSlant->"Italic"],
  ", Dover Publications, New York, 1945."
}], "Text",
  CellTags->"Lamb-1945"],

Cell[TextData[{
  "L.D. Landau and E.M. Lifshitz, ",
  StyleBox["Mechanics",
    FontSlant->"Italic"],
  ", Butterworth-Heinemann, New York, 1981."
}], "Text",
  CellTags->"Landau and Lifshitz-1981"],

Cell[TextData[{
  "L.D. Landau and E.M. Lifshitz,",
  StyleBox[" Fluid Mechanics",
    FontSlant->"Italic"],
  ", Pergamon, Oxford, 1987."
}], "Text",
  CellTags->"Landau and Lifshitz-1984"],

Cell[TextData[{
  "D. Levi and P. Winternitz, Non-classical symmetry reduction: Example of \
the Boussinesq equation, ",
  StyleBox["J. Phys. A: Math. Gen",
    FontSlant->"Italic"],
  ". ",
  StyleBox["22",
    FontWeight->"Bold"],
  ", 2915\[Dash]2924 (1989)."
}], "Text",
  CellTags->"Levi-89"],

Cell[TextData[{
  "S. Lie, ",
  StyleBox["Gesammelte Werke",
    FontSlant->"Italic"],
  ", Vols. 1\[Dash]7, Eds.: F. Engel and P. Hergard, Teubner, Leipzig, 1899."
}], "Text",
  CellTags->"Lie-Engel-1899"],

Cell[TextData[{
  "S. Lie, Zur Theorie des Integrabilit\[ADoubleDot]tsfaktors, ",
  StyleBox["Christ. Forh., Aar",
    FontSlant->"Italic"],
  " 1874, 242\[Dash]254, 1875."
}], "Text",
  CellTags->"Lie-1874"],

Cell[TextData[{
  "S. Lie and F. Engel, ",
  StyleBox["Transformationsgruppen",
    FontSlant->"Italic"],
  ", Vols. I\[Dash]II, Leipzig, (1888, 1890, 1893); reprinted by Chelsea, New \
York, 1970."
}], "Text",
  Evaluatable->False,
  CellTags->"Lie-88"],

Cell[TextData[{
  "M.J. Lighthill, Viscosity effects in sound waves of finite amplitude, pp. \
250\[Dash]351. In: ",
  StyleBox["Surveys in Mechanics",
    FontSlant->"Italic"],
  ", Eds.: G.K. Batchelor and R.M. Davis, Cambridge University Press, \
Cambridge, 1956."
}], "Text",
  Evaluatable->False,
  CellTags->"Ligh-56"],

Cell[TextData[StyleBox["M",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"M"],

Cell[TextData[{
  "W. Ma, An exact solution in two-dimensional Korteweg-de Vries-Burgers \
equation, ",
  StyleBox["J. Phys. A: Math. Gen.",
    FontSlant->"Italic"],
  " ",
  StyleBox["26",
    FontWeight->"Bold"],
  ", L17\[Dash]L20 (1993)."
}], "Text",
  CellTags->"Ma-1993"],

Cell["\<\
J.E. Mack, Semi-popular motion picture record of the Trinity explosion. \
MDDDC221. U.S. Atomic Energy Commission, Washington, DC, 1947.\
\>", "Text",
  CellTags->"Mack-1947"],

Cell[TextData[{
  "E.L. Mansfield, ",
  StyleBox["Differential Gr\[ODoubleDot]bner Bases",
    FontSlant->"Italic"],
  ", Ph.D. Thesis, University of Sydney, Australia, 1992."
}], "Text",
  CellTags->"Mansfield-1992"],

Cell[TextData[{
  "A.A. Mohammad, and M. Can, Exact solutions of the complex modified \
Korteweg-de Vries equation, ",
  StyleBox["J. Phys. A: Math. Gen.",
    FontSlant->"Italic"],
  " ",
  StyleBox["28",
    FontWeight->"Bold"],
  ", 3223\[Dash]3233 (1995)."
}], "Text",
  CellTags->"Mohammad-1995"],

Cell[TextData[StyleBox["N",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"N"],

Cell[TextData[{
  "T. Nishitani and M. Tajiri, On similarity solutions of the Boussinesq \
equation, ",
  StyleBox["Phys. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["89A",
    FontWeight->"Bold"],
  ", 379\[Dash]380 (1982)."
}], "Text",
  CellTags->"Nishitani and Tajiri-1982"],

Cell[TextData[{
  "E. Noether, Invariante Variationsprobleme, ",
  StyleBox[
  "Nachr. K\[ODoubleDot]nig. Gesell. Wissen. G\[ODoubleDot]ttingen, \
Math.-Phys. Kl.",
    FontSlant->"Italic"],
  " ",
  StyleBox["2",
    FontWeight->"Bold"],
  " 235\[Dash]257, (1918); see ",
  StyleBox["Transport Theory Stat. Phys.",
    FontSlant->"Italic"],
  " ",
  StyleBox["1",
    FontWeight->"Bold"],
  ", 186\[Dash]207 (1971) for an English translation."
}], "Text",
  CellTags->"Noether-18"],

Cell[TextData[{
  "M.C. Nucci and P.A. Clarkson, The nonclassical method is more general than \
the direct method for symmetry reductions. An example of the Fitzhugh-Nagumo \
equation, ",
  StyleBox["Phys. Lett. A",
    FontSlant->"Italic"],
  " ",
  StyleBox["164",
    FontWeight->"Bold"],
  ", 49\[Dash]56 (1992)."
}], "Text",
  CellTags->"Nuci-92"],

Cell[TextData[StyleBox["O",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"O"],

Cell[TextData[{
  "P.J. Olver, ",
  StyleBox["Applications of Lie Groups to Differential Equations",
    FontSlant->"Italic"],
  ", Springer-Verlag, Berlin, 1986."
}], "Text",
  CellTags->"Olve-86"],

Cell[TextData[{
  "P.J. Olver and P. Rosenau, The construction of special solutions to \
partial differential equations,",
  StyleBox[" ",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["Phys. Lett. A",
    FontSlant->"Italic"],
  " ",
  StyleBox["114",
    FontWeight->"Bold"],
  ", 107\[Dash]112 (1986)."
}], "Text",
  Evaluatable->False,
  CellTags->"Olve-86R"],

Cell[TextData[{
  "P.J. Olver and P. Rosenau, Group-invariant solutions of differential \
equations, ",
  StyleBox["SIAM J. Appl. Math.",
    FontSlant->"Italic"],
  " ",
  StyleBox["47",
    FontWeight->"Bold"],
  ", 263\[Dash]278 (1987)."
}], "Text",
  CellTags->"Olve-87"],

Cell[TextData[{
  "L.V. Ovsiannikov, ",
  StyleBox["Group Analysis of Differential Equations",
    FontSlant->"Italic"],
  ", Academic Press, New York, 1982."
}], "Text",
  CellTags->"Ovsi-82"],

Cell[TextData[StyleBox["P",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"P"],

Cell[TextData[{
  "E.J. Parkes, Exact solutions to the two-dimensional Korteweg-de \
Vries-Burgers equation, ",
  StyleBox["J. Phys. A: Math. Gen.",
    FontSlant->"Italic"],
  " ",
  StyleBox["27",
    FontWeight->"Bold"],
  ", L497\[Dash]L501 (1994)."
}], "Text",
  CellTags->"Parkes-1994"],

Cell[TextData[{
  "W. Paul and H. Steinwedel, Ein neues Massenspektrometer ohne Magnetfeld, ",
  
  StyleBox["Z. Naturforschg",
    FontSlant->"Italic"],
  ". ",
  StyleBox["8a",
    FontWeight->"Bold"],
  ", 448\[Dash]450 (1953)."
}], "Text",
  CellTags->"Paul-1953"],

Cell[TextData[{
  "M.D.K. Porsezian and M. Lakshmanan, On the integrable models of the \
higher-order water wave equation, ",
  StyleBox["Phys. Lett. A",
    FontSlant->"Italic"],
  " ",
  StyleBox["174",
    FontWeight->"Bold"],
  ", 237\[Dash]240 (1993)."
}], "Text",
  CellTags->"Porsezian and Lakshmanan-1993"],

Cell[TextData[{
  "E. Pucci, Similarity reductions of partial differential equations, ",
  StyleBox["J. Phys. A: Math. Gen.",
    FontSlant->"Italic"],
  " ",
  StyleBox["25",
    FontWeight->"Bold"],
  ", 2631\[Dash]2640 (1992)."
}], "Text",
  CellTags->"Puci-92"],

Cell[TextData[StyleBox["R",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"R"],

Cell[TextData[{
  "G. Reid, Findng abstract Lie symmetry algebras of differential equations \
without integrating determining equations, ",
  StyleBox["Eur. J. Appl. Math",
    FontSlant->"Italic"],
  ". ",
  StyleBox["2",
    FontWeight->"Bold"],
  ", 318\[Dash]340 (1991)."
}], "Text",
  Evaluatable->False,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->"Reid-1991"],

Cell[TextData[{
  "G.J. Reid, D.T. Weih, and A.D. Wittkopf, A point symmetry group of a \
differential equation which cannot be found using infinitesimal methods, pp. \
311\[Dash]316, In: ",
  StyleBox[
  "Modern Group Analysis: Advanced Analytical and Computational Methods in \
Mathematical Physics",
    FontSlant->"Italic"],
  ", Eds.: N.H. Ibragimov, M. Torrisi, and A. Valenti, Kluwer, Dordrecht, \
1993."
}], "Text",
  CellTags->"Reid-1993"],

Cell[TextData[{
  "Ch. Riquier, ",
  StyleBox[
  "Les syst\[EGrave]mes d'\[EAcute]quations aux d\[EAcute]riv\[EAcute]es \
partielle",
    FontSlant->"Italic"],
  "s, Gauthier-Villars, Paris, 1910."
}], "Text",
  CellTags->"Riquier-1910"],

Cell[TextData[{
  "H. Risken, ",
  StyleBox["The Fokker-Planck Equation",
    FontSlant->"Italic"],
  ", Springer-Verlag, New York, 1984."
}], "Text",
  CellTags->"Risken-1984"],

Cell[TextData[{
  "P. Rosenau and J.L. Schwarzmeier, On similarity solutions of \
Boussinesq-type equations, ",
  StyleBox["Phys. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["115A",
    FontWeight->"Bold"],
  ", 75\[Dash]77 (1986)."
}], "Text",
  CellTags->"Rosenau and Schwarzmeier-1986"],

Cell["\<\
J.S. Russell, Report on waves, Report of the 14th Meeting of the British \
Association for the Advancement of Science, pp. 319\[Dash]320, John Murray, \
London, 1844.\
\>", "Text",
  CellTags->"Russel-1844"],

Cell[TextData[StyleBox["S",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"S"],

Cell[TextData[{
  "P.G. Saffman and G. Taylor, The penetration of a fluid into a porous \
medium or Hele-Shaw cell containing a more viscous liquid, ",
  StyleBox["Proc. Roy. Soc.",
    FontSlant->"Italic"],
  " ",
  StyleBox["245",
    FontWeight->"Bold"],
  ", 312\[Dash]329 (1958) ."
}], "Text",
  CellTags->"Saffman and Taylor-1958"],

Cell[TextData[{
  "G. Scheffers and S. Lie, ",
  StyleBox[
  "Vorlesungen \[UDoubleDot]ber Differentialgleichungen mit bekannten \
infinitesimalen Transformationen",
    FontSlant->"Italic"],
  ", B.G. Teubner, Leipzig, 1891."
}], "Text",
  CellTags->"Sche-1891"],

Cell[TextData[{
  "H. Schlichting, Laminare Strahlausbreitung, ",
  StyleBox["Z. Ang. Math. Mech.",
    FontSlant->"Italic"],
  " ",
  StyleBox["8",
    FontWeight->"Bold"],
  ", 260\[Dash]263 (1933)."
}], "Text",
  Evaluatable->False,
  CellTags->"Schl-33"],

Cell[TextData[{
  "F. Schwarz, Automatically determining symmetries of partial differential \
equations, ",
  StyleBox["Computing",
    FontSlant->"Italic"],
  " ",
  StyleBox["34",
    FontWeight->"Bold"],
  ", 91\[Dash]106 (1985)."
}], "Text",
  CellTags->"Schwarz-1985"],

Cell[TextData[{
  "F. Schwarz, Reduction and completition algorithms for partial differential \
equations, pp. 27.6\[Dash]29.6, In: ",
  StyleBox["International Symposium on Symbolic and Algebraic Computation",
    FontSlant->"Italic"],
  ", Berkeley, Ed.: P.S. Wang, ACM Press, New York, 1992."
}], "Text",
  CellTags->"Schwarz-1992"],

Cell[TextData[{
  "H. Stephani, ",
  StyleBox["Differential Equations: Their Solution Using Symmetries",
    FontSlant->"Italic"],
  ", Cambridge University Press, Cambridge, 1989."
}], "Text",
  CellTags->"Step-89"],

Cell[TextData[{
  "G.G. Stokes, On the dynamical theory of diffraction, ",
  StyleBox["Trans. Camb. Phil. Soc.",
    FontSlant->"Italic"],
  " ",
  StyleBox["9",
    FontWeight->"Bold"],
  ", 1\[Dash]62 (1851)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Stok-51"],

Cell[TextData[StyleBox["T",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"T"],

Cell[TextData[{
  "M. Tabor, ",
  StyleBox["Chaos and Integrability in Nonlinear Dynamics",
    FontSlant->"Italic"],
  StyleBox[",",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " John Wiley & Sons,  New York, 1989."
}], "Text",
  CellTags->"Tabor-1989"],

Cell[TextData[{
  "C. Tang, S. Feng, and L. Golubovic, Dynamics and noise spectra of a driven \
single flux line in superconductors, ",
  StyleBox["Phys. Rev. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["72",
    FontWeight->"Bold"],
  ", 1264\[Dash]1267 (1994)."
}], "Text",
  Evaluatable->False,
  CellTags->"Tang-94"],

Cell[TextData[{
  "G. Taylor, The formation of a blast wave by a very intense explosion, I. \
Theoretical discussion, ",
  StyleBox["Proc. Roy. Soc.",
    FontSlant->"Italic"],
  " ",
  StyleBox["201",
    FontWeight->"Bold"],
  ", 159\[Dash]174 (1950); II. The atomic explosion of 1945, ",
  StyleBox["Proc. Roy. Soc.",
    FontSlant->"Italic"],
  " ",
  StyleBox["201",
    FontWeight->"Bold"],
  ", 175\[Dash]186 (1950)."
}], "Text",
  Evaluatable->False,
  CellTags->"Tayl-50"],

Cell[TextData[{
  "J.M. Thomas, Riquier\[CloseCurlyQuote]s existence theorems, ",
  StyleBox["Ann. Math.",
    FontSlant->"Italic"],
  " ",
  StyleBox["30",
    FontWeight->"Bold"],
  ", 285\[Dash]321 (1929)."
}], "Text",
  CellTags->"Thomas-1929"],

Cell[TextData[{
  "J.M. Thomas, Riquier\[CloseCurlyQuote]s existence theorems, ",
  StyleBox["Ann. Math",
    FontSlant->"Italic"],
  ". ",
  StyleBox["35",
    FontWeight->"Bold"],
  ", 306\[Dash]311 (1934)."
}], "Text",
  CellTags->"Thomas-1934"],

Cell[TextData[{
  "M. Tinkham, ",
  StyleBox["Introduction to Superconductivity",
    FontSlant->"Italic"],
  ", McGraw-Hill, New York, 1975."
}], "Text",
  Evaluatable->False,
  CellTags->"Tink-75"],

Cell[TextData[StyleBox["V",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"V"],

Cell[TextData[{
  "N.G. Van Kampen, ",
  StyleBox["Stochastic Processes in Physics and Chemistry",
    FontSlant->"Italic"],
  ", North-Holland, Amsterdam, 1981."
}], "Text",
  CellTags->"Van Kampen-1981"],

Cell[TextData[{
  "A.M. Vinogradov and I.S. Krasil\[CloseCurlyQuote]shchik, On the theory of \
nonlocal symmetries of nonlinear partial differential equations, ",
  StyleBox["Sov. Math. Dokl",
    FontSlant->"Italic"],
  ". ",
  StyleBox["29",
    FontWeight->"Bold"],
  ", 337\[Dash]341 (1984)."
}], "Text",
  CellTags->"Vinogradov-1984"],

Cell[TextData[StyleBox["W",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"W"],

Cell[TextData[{
  "H. Weyl, ",
  StyleBox["Gruppentheorie und Quantenmechanik",
    FontSlant->"Italic"],
  ", S. Hirzel, Leipzig, 1928."
}], "Text",
  CellTags->"Weyl-28"],

Cell[TextData[{
  "D.J. Wineland, W.M. Itano, and R.S. van Dyck Jr., High-resolution \
spectroscopy of stored ions, ",
  StyleBox["Adv. Atom. Mol. Phys.",
    FontSlant->"Italic"],
  " ",
  StyleBox["19",
    FontWeight->"Bold"],
  ", 135\[Dash]186 (1983)."
}], "Text",
  CellTags->"Wineland-1983"],

Cell[TextData[{
  "T. Wolf, ",
  StyleBox["The Symbolic Integration of Exact PDEs",
    FontSlant->"Italic"],
  ", preprint, 1991."
}], "Text",
  CellTags->"Wolf-1991"],

Cell[TextData[{
  "D.E. Wolf and J. Villain, Growth with surface diffusion, ",
  StyleBox["Europhys. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["13",
    FontWeight->"Bold"],
  ", 389\[Dash]394 (1990)."
}], "Text",
  CellTags->"Wolf-1990"],

Cell[TextData[{
  "S. Wolfram, ",
  StyleBox["Mathematica: A System for Doing Mathematics by Computer",
    FontSlant->"Italic"],
  ", Addison-Wesley Publishing Company, Reading, MA, 1991."
}], "Text",
  Evaluatable->False,
  CellTags->"Wolf-91"],

Cell[TextData[StyleBox["Y",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"Y"],

Cell[TextData[{
  "Z.J. Yang, Traveling wave solutions to nonlinear evolution and wave \
equations, ",
  StyleBox["J. Phys. A: Math. Gen.",
    FontSlant->"Italic"],
  " ",
  StyleBox["27",
    FontWeight->"Bold"],
  ", 2837\[Dash]2855 (1994)."
}], "Text",
  CellTags->"Yang-1994"],

Cell[TextData[StyleBox["Z",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  PageBreakBelow->False,
  CellTags->"Z"],

Cell[TextData[{
  "N.J. Zabusky and M.D. Kruskal, Interaction of solitons in a collisionless \
plasma and the recurrence of initial states, ",
  StyleBox["Phys. Rev. Lett.",
    FontSlant->"Italic"],
  " ",
  StyleBox["15",
    FontWeight->"Bold"],
  ", 240\[Dash]243 (1965)."
}], "Text",
  CellTags->"Zabusky-1965"],

Cell[TextData[{
  "N.S. Zakharov and V.P. Korobeinikov, Group analysis of the generalized \
Korteweg-de Vries-Burgers equation, ",
  StyleBox["J. Appl. Math.",
    FontSlant->"Italic"],
  " ",
  StyleBox["44",
    FontWeight->"Bold"],
  ", 668\[Dash]671 (1980)."
}], "Text",
  Evaluatable->False,
  CellTags->"Zakh-80"],

Cell[TextData[{
  "V.E. Zakharov and E.A. Kuznetsov, Three-dimensional solitons, ",
  StyleBox["Sov. Phys.-JETP",
    FontSlant->"Italic"],
  " ",
  StyleBox["39",
    FontWeight->"Bold"],
  ", 285\[Dash]286 (1974)."
}], "Text",
  Evaluatable->False,
  CellTags->"Zakh-74"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"HyperlinkIndex.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
WindowSize->{671, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->495,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "References", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "References", FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "A"->{
    Cell[2074, 59, 92, 3, 29, "Text",
      CellTags->"A"]},
  "Abraham-Schrauner-93"->{
    Cell[2169, 64, 405, 10, 61, "Text",
      CellTags->"Abraham-Schrauner-93"]},
  "Alexeyev-1994"->{
    Cell[2577, 76, 402, 11, 61, "Text",
      CellTags->"Alexeyev-1994"]},
  "Ames-68"->{
    Cell[2982, 89, 213, 7, 27, "Text",
      CellTags->"Ames-68"]},
  "B"->{
    Cell[3198, 98, 117, 4, 29, "Text",
      PageBreakBelow->False,
      CellTags->"B"]},
  "Baik-89"->{
    Cell[3318, 104, 264, 9, 44, "Text",
      CellTags->"Baik-89"]},
  "Baik-91"->{
    Cell[3585, 115, 289, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Baik-91"]},
  "Baumann-1991"->{
    Cell[3877, 128, 278, 10, 44, "Text",
      CellTags->"Baumann-1991"]},
  "Baum-92"->{
    Cell[4158, 140, 282, 7, 44, "Text",
      CellTags->"Baum-92"]},
  "Baum-96"->{
    Cell[4443, 149, 270, 10, 43, "Text",
      CellTags->"Baum-96"]},
  "Baum-95"->{
    Cell[4716, 161, 316, 12, 44, "Text",
      CellTags->"Baum-95"]},
  "Baumann and Nonnenmacher-1992"->{
    Cell[5035, 175, 328, 10, 44, "Text",
      CellTags->"Baumann and Nonnenmacher-1992"]},
  "Baum-87"->{
    Cell[5366, 187, 375, 12, 60, "Text",
      Evaluatable->False,
      CellTags->"Baum-87"]},
  "Birk-50"->{
    Cell[5744, 201, 173, 6, 26, "Text",
      CellTags->"Birk-50"]},
  "Blan-92"->{
    Cell[5920, 209, 219, 6, 43, "Text",
      CellTags->"Blan-92"]},
  "Blas-08"->{
    Cell[6142, 217, 293, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Blas-08"]},
  "Blu-93"->{
    Cell[6438, 230, 346, 9, 60, "Text",
      CellTags->"Blu-93"]},
  "Blu-93a"->{
    Cell[6787, 241, 146, 4, 43, "Text",
      CellTags->"Blu-93a"]},
  "Blum-69"->{
    Cell[6936, 247, 272, 10, 44, "Text",
      CellTags->"Blum-69"]},
  "Bum-74"->{
    Cell[7211, 259, 207, 6, 43, "Text",
      CellTags->"Bum-74"]},
  "Blum-89"->{
    Cell[7421, 267, 199, 6, 43, "Text",
      CellTags->"Blum-89"]},
  "Blum-90"->{
    Cell[7623, 275, 310, 10, 44, "Text",
      CellTags->"Blum-90"]},
  "Bountis-1982"->{
    Cell[7936, 287, 298, 10, 44, "Text",
      CellTags->"Bountis-1982"]},
  "Boussinesq-1872"->{
    Cell[8237, 299, 424, 12, 60, "Text",
      CellTags->"Boussinesq-1872"]},
  "Boyer-1989"->{
    Cell[8664, 313, 280, 10, 44, "Text",
      CellTags->"Boyer-1989"]},
  "Buchberger-1985"->{
    Cell[8947, 325, 294, 7, 60, "Text",
      CellTags->"Buchberger-1985"]},
  "Burg-48"->{
    Cell[9244, 334, 280, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Burg-48"]},
  "C"->{
    Cell[9527, 347, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"C"]},
  "Calogero-1978"->{
    Cell[9647, 353, 365, 11, 60, "Text",
      CellTags->"Calogero-1978"]},
  "Calogero-1981"->{
    Cell[10015, 366, 323, 10, 44, "Text",
      CellTags->"Calogero-1981"]},
  "Carra-Ferro-1993"->{
    Cell[10341, 378, 428, 10, 76, "Text",
      CellTags->"Carra-Ferro-1993"]},
  "Champagne-1990"->{
    Cell[10772, 390, 332, 10, 60, "Text",
      CellTags->"Champagne-1990"]},
  "Chan-1994"->{
    Cell[11107, 402, 319, 10, 44, "Text",
      CellTags->"Chan-1994"]},
  "Cicogna-1990"->{
    Cell[11429, 414, 299, 10, 44, "Text",
      CellTags->"Cicogna-1990"]},
  "Clar-89"->{
    Cell[11731, 426, 300, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Clar-89"]},
  "Clarkson-89"->{
    Cell[12034, 439, 282, 10, 44, "Text",
      CellTags->"Clarkson-89"]},
  "Clar-94"->{
    Cell[12319, 451, 386, 12, 44, "Text",
      Evaluatable->False,
      CellTags->"Clar-94"]},
  "Cour-48"->{
    Cell[12708, 465, 235, 7, 43, "Text",
      Evaluatable->False,
      CellTags->"Cour-48"]},
  "Crig-79"->{
    Cell[12946, 474, 258, 9, 27, "Text",
      Evaluatable->False,
      CellTags->"Crig-79"]},
  "D"->{
    Cell[13207, 485, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"D"]},
  "Das Sarma-1991"->{
    Cell[13327, 491, 316, 10, 44, "Text",
      CellTags->"Das Sarma-1991"]},
  "Drazin-1983"->{
    Cell[13646, 503, 173, 6, 26, "Text",
      CellTags->"Drazin-1983"]},
  "Drew-1989"->{
    Cell[13822, 511, 710, 23, 60, "Text",
      Evaluatable->False,
      CellTags->"Drew-1989"]},
  "E"->{
    Cell[14535, 536, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"E"]},
  "Eggers-1993"->{
    Cell[14655, 542, 264, 9, 44, "Text",
      CellTags->"Eggers-1993"]},
  "Eggers-1997"->{
    Cell[14922, 553, 214, 9, 27, "Text",
      CellTags->"Eggers-1997"]},
  "Enge-12"->{
    Cell[15338, 574, 235, 6, 43, "Text",
      CellTags->"Enge-12"]},
  "F"->{
    Cell[15576, 582, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"F"]},
  "Falk-31"->{
    Cell[15696, 588, 277, 10, 44, "Text",
      Evaluatable->False,
      CellTags->"Falk-31"]},
  "Fokas-1980"->{
    Cell[15976, 600, 269, 10, 44, "Text",
      CellTags->"Fokas-1980"]},
  "Fokas-1981"->{
    Cell[16248, 612, 307, 10, 44, "Text",
      CellTags->"Fokas-1981"]},
  "Fokas-1987"->{
    Cell[16558, 624, 239, 9, 27, "Text",
      CellTags->"Fokas-1987"]},
  "Fung-1982"->{
    Cell[16800, 635, 448, 14, 60, "Text",
      CellTags->"Fung-1982"]},
  "G"->{
    Cell[17251, 651, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"G"]},
  "Garcia and Castellanos-1994"->{
    Cell[17371, 657, 309, 10, 44, "Text",
      CellTags->"Garcia and Castellanos-1994"]},
  "Gray-1993"->{
    Cell[17683, 669, 198, 6, 43, "Text",
      CellTags->"Gray-1993"]},
  "H"->{
    Cell[17884, 677, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"H"]},
  "Henon-1964"->{
    Cell[18004, 683, 298, 10, 44, "Text",
      CellTags->"Henon-1964"]},
  "Here-94"->{
    Cell[18305, 695, 294, 10, 44, "Text",
      CellTags->"Here-94"]},
  "Hereman-1996"->{
    Cell[18602, 707, 381, 9, 76, "Text",
      CellTags->"Hereman-1996"]},
  "Hirota-1981"->{
    Cell[18986, 718, 276, 10, 44, "Text",
      CellTags->"Hirota-1981"]},
  "Hydon-1994"->{
    Cell[19265, 730, 282, 10, 44, "Text",
      CellTags->"Hydon-1994"]},
  "I"->{
    Cell[19550, 742, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"I"]},
  "Ibra-85"->{
    Cell[19670, 748, 225, 7, 43, "Text",
      Evaluatable->False,
      CellTags->"Ibra-85"]},
  "Ibragimov-1994"->{
    Cell[19898, 757, 296, 10, 44, "Text",
      CellTags->"Ibragimov-1994"]},
  "Ibra-949596"->{
    Cell[20197, 769, 244, 6, 43, "Text",
      CellTags->"Ibra-949596"]},
  "Ince-1956"->{
    Cell[20444, 777, 183, 6, 26, "Text",
      CellTags->"Ince-1956"]},
  "J"->{
    Cell[20630, 785, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"J"]},
  "Janet-1920"->{
    Cell[20750, 791, 291, 10, 44, "Text",
      CellTags->"Janet-1920"]},
  "K"->{
    Cell[21044, 803, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"K"]},
  "Kada-90"->{
    Cell[21164, 809, 299, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Kada-90"]},
  "Kamke-1977"->{
    Cell[21466, 822, 170, 6, 26, "Text",
      CellTags->"Kamke-1977"]},
  "Karp-91"->{
    Cell[21639, 830, 309, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Karp-91"]},
  "Klein-1918"->{
    Cell[21951, 843, 384, 11, 60, "Text",
      CellTags->"Klein-1918"]},
  "Ko and Kuehl-1978"->{
    Cell[22338, 856, 279, 10, 44, "Text",
      CellTags->"Ko and Kuehl-1978"]},
  "KortewegDeVries-1895"->{
    Cell[22620, 868, 349, 11, 60, "Text",
      CellTags->"KortewegDeVries-1895"]},
  "Kowa-31"->{
    Cell[22972, 881, 241, 7, 43, "Text",
      CellTags->"Kowa-31"]},
  "L"->{
    Cell[23216, 890, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"L"]},
  "Lamb-1945"->{
    Cell[23336, 896, 163, 6, 26, "Text",
      CellTags->"Lamb-1945"]},
  "Landau and Lifshitz-1981"->{
    Cell[23502, 904, 199, 6, 26, "Text",
      CellTags->"Landau and Lifshitz-1981"]},
  "Landau and Lifshitz-1984"->{
    Cell[23704, 912, 190, 6, 26, "Text",
      CellTags->"Landau and Lifshitz-1984"]},
  "Levi-89"->{
    Cell[23897, 920, 297, 10, 44, "Text",
      CellTags->"Levi-89"]},
  "Lie-Engel-1899"->{
    Cell[24197, 932, 206, 6, 43, "Text",
      CellTags->"Lie-Engel-1899"]},
  "Lie-1874"->{
    Cell[24406, 940, 208, 6, 26, "Text",
      CellTags->"Lie-1874"]},
  "Lie-88"->{
    Cell[24617, 948, 254, 8, 43, "Text",
      Evaluatable->False,
      CellTags->"Lie-88"]},
  "Ligh-56"->{
    Cell[24874, 958, 324, 9, 60, "Text",
      Evaluatable->False,
      CellTags->"Ligh-56"]},
  "M"->{
    Cell[25201, 969, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"M"]},
  "Ma-1993"->{
    Cell[25321, 975, 278, 10, 44, "Text",
      CellTags->"Ma-1993"]},
  "Mack-1947"->{
    Cell[25602, 987, 185, 4, 43, "Text",
      CellTags->"Mack-1947"]},
  "Mansfield-1992"->{
    Cell[25790, 993, 217, 6, 43, "Text",
      CellTags->"Mansfield-1992"]},
  "Mohammad-1995"->{
    Cell[26010, 1001, 301, 10, 44, "Text",
      CellTags->"Mohammad-1995"]},
  "N"->{
    Cell[26314, 1013, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"N"]},
  "Nishitani and Tajiri-1982"->{
    Cell[26434, 1019, 286, 10, 44, "Text",
      CellTags->"Nishitani and Tajiri-1982"]},
  "Noether-18"->{
    Cell[26723, 1031, 482, 17, 60, "Text",
      CellTags->"Noether-18"]},
  "Nuci-92"->{
    Cell[27208, 1050, 352, 11, 60, "Text",
      CellTags->"Nuci-92"]},
  "O"->{
    Cell[27563, 1063, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"O"]},
  "Olve-86"->{
    Cell[27683, 1069, 198, 6, 43, "Text",
      CellTags->"Olve-86"]},
  "Olve-86R"->{
    Cell[27884, 1077, 388, 13, 44, "Text",
      Evaluatable->False,
      CellTags->"Olve-86R"]},
  "Olve-87"->{
    Cell[28275, 1092, 275, 10, 44, "Text",
      CellTags->"Olve-87"]},
  "Ovsi-82"->{
    Cell[28553, 1104, 193, 6, 43, "Text",
      CellTags->"Ovsi-82"]},
  "P"->{
    Cell[28749, 1112, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"P"]},
  "Parkes-1994"->{
    Cell[28869, 1118, 292, 10, 44, "Text",
      CellTags->"Parkes-1994"]},
  "Paul-1953"->{
    Cell[29164, 1130, 268, 10, 44, "Text",
      CellTags->"Paul-1953"]},
  "Porsezian and Lakshmanan-1993"->{
    Cell[29435, 1142, 314, 10, 44, "Text",
      CellTags->"Porsezian and Lakshmanan-1993"]},
  "Puci-92"->{
    Cell[29752, 1154, 265, 9, 44, "Text",
      CellTags->"Puci-92"]},
  "R"->{
    Cell[30020, 1165, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"R"]},
  "Reid-1991"->{
    Cell[30140, 1171, 384, 13, 44, "Text",
      Evaluatable->False,
      CellTags->"Reid-1991"]},
  "Reid-1993"->{
    Cell[30527, 1186, 448, 11, 76, "Text",
      CellTags->"Reid-1993"]},
  "Riquier-1910"->{
    Cell[30978, 1199, 237, 8, 43, "Text",
      CellTags->"Riquier-1910"]},
  "Risken-1984"->{
    Cell[31218, 1209, 177, 6, 26, "Text",
      CellTags->"Risken-1984"]},
  "Rosenau and Schwarzmeier-1986"->{
    Cell[31398, 1217, 297, 10, 44, "Text",
      CellTags->"Rosenau and Schwarzmeier-1986"]},
  "Russel-1844"->{
    Cell[31698, 1229, 217, 5, 43, "Text",
      CellTags->"Russel-1844"]},
  "S"->{
    Cell[31918, 1236, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"S"]},
  "Saffman and Taylor-1958"->{
    Cell[32038, 1242, 337, 10, 44, "Text",
      CellTags->"Saffman and Taylor-1958"]},
  "Sche-1891"->{
    Cell[32378, 1254, 263, 8, 43, "Text",
      CellTags->"Sche-1891"]},
  "Schl-33"->{
    Cell[32644, 1264, 258, 10, 27, "Text",
      Evaluatable->False,
      CellTags->"Schl-33"]},
  "Schwarz-1985"->{
    Cell[32905, 1276, 273, 10, 44, "Text",
      CellTags->"Schwarz-1985"]},
  "Schwarz-1992"->{
    Cell[33181, 1288, 335, 7, 60, "Text",
      CellTags->"Schwarz-1992"]},
  "Step-89"->{
    Cell[33519, 1297, 216, 6, 43, "Text",
      CellTags->"Step-89"]},
  "Stok-51"->{
    Cell[33738, 1305, 294, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Stok-51"]},
  "T"->{
    Cell[34035, 1318, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"T"]},
  "Tabor-1989"->{
    Cell[34155, 1324, 272, 8, 43, "Text",
      CellTags->"Tabor-1989"]},
  "Tang-94"->{
    Cell[34430, 1334, 328, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Tang-94"]},
  "Tayl-50"->{
    Cell[34761, 1347, 481, 17, 61, "Text",
      Evaluatable->False,
      CellTags->"Tayl-50"]},
  "Thomas-1929"->{
    Cell[35245, 1366, 248, 9, 27, "Text",
      CellTags->"Thomas-1929"]},
  "Thomas-1934"->{
    Cell[35496, 1377, 248, 9, 27, "Text",
      CellTags->"Thomas-1934"]},
  "Tink-75"->{
    Cell[35747, 1388, 199, 7, 26, "Text",
      Evaluatable->False,
      CellTags->"Tink-75"]},
  "V"->{
    Cell[35949, 1397, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"V"]},
  "Van Kampen-1981"->{
    Cell[36069, 1403, 205, 6, 43, "Text",
      CellTags->"Van Kampen-1981"]},
  "Vinogradov-1984"->{
    Cell[36277, 1411, 339, 10, 44, "Text",
      CellTags->"Vinogradov-1984"]},
  "W"->{
    Cell[36619, 1423, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"W"]},
  "Weyl-28"->{
    Cell[36739, 1429, 172, 6, 26, "Text",
      CellTags->"Weyl-28"]},
  "Wineland-1983"->{
    Cell[36914, 1437, 298, 10, 44, "Text",
      CellTags->"Wineland-1983"]},
  "Wolf-1991"->{
    Cell[37215, 1449, 168, 6, 26, "Text",
      CellTags->"Wolf-1991"]},
  "Wolf-1990"->{
    Cell[37386, 1457, 248, 9, 44, "Text",
      CellTags->"Wolf-1990"]},
  "Wolf-91"->{
    Cell[37637, 1468, 246, 7, 43, "Text",
      Evaluatable->False,
      CellTags->"Wolf-91"]},
  "Y"->{
    Cell[37886, 1477, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"Y"]},
  "Yang-1994"->{
    Cell[38006, 1483, 281, 10, 44, "Text",
      CellTags->"Yang-1994"]},
  "Z"->{
    Cell[38290, 1495, 117, 4, 28, "Text",
      PageBreakBelow->False,
      CellTags->"Z"]},
  "Zabusky-1965"->{
    Cell[38410, 1501, 316, 10, 44, "Text",
      CellTags->"Zabusky-1965"]},
  "Zakh-80"->{
    Cell[38729, 1513, 319, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Zakh-80"]},
  "Zakh-74"->{
    Cell[39051, 1526, 273, 10, 44, "Text",
      Evaluatable->False,
      CellTags->"Zakh-74"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"A", 40993, 1585},
  {"Abraham-Schrauner-93", 41082, 1588},
  {"Alexeyev-1994", 41185, 1591},
  {"Ames-68", 41275, 1594},
  {"B", 41352, 1597},
  {"Baik-89", 41458, 1601},
  {"Baik-91", 41542, 1604},
  {"Baumann-1991", 41658, 1608},
  {"Baum-92", 41748, 1611},
  {"Baum-96", 41832, 1614},
  {"Baum-95", 41917, 1617},
  {"Baumann and Nonnenmacher-1992", 42024, 1620},
  {"Baum-87", 42131, 1623},
  {"Birk-50", 42242, 1627},
  {"Blan-92", 42326, 1630},
  {"Blas-08", 42410, 1633},
  {"Blu-93", 42520, 1637},
  {"Blu-93a", 42603, 1640},
  {"Blum-69", 42687, 1643},
  {"Bum-74", 42771, 1646},
  {"Blum-89", 42854, 1649},
  {"Blum-90", 42938, 1652},
  {"Bountis-1982", 43028, 1655},
  {"Boussinesq-1872", 43126, 1658},
  {"Boyer-1989", 43222, 1661},
  {"Buchberger-1985", 43318, 1664},
  {"Burg-48", 43410, 1667},
  {"C", 43515, 1671},
  {"Calogero-1978", 43628, 1675},
  {"Calogero-1981", 43725, 1678},
  {"Carra-Ferro-1993", 43826, 1681},
  {"Champagne-1990", 43928, 1684},
  {"Chan-1994", 44023, 1687},
  {"Cicogna-1990", 44116, 1690},
  {"Clar-89", 44207, 1693},
  {"Clarkson-89", 44323, 1697},
  {"Clar-94", 44413, 1700},
  {"Cour-48", 44525, 1704},
  {"Crig-79", 44636, 1708},
  {"D", 44741, 1712},
  {"Das Sarma-1991", 44856, 1716},
  {"Drazin-1983", 44953, 1719},
  {"Drew-1989", 45044, 1722},
  {"E", 45152, 1726},
  {"Eggers-1993", 45264, 1730},
  {"Eggers-1997", 45357, 1733},
  {"Enge-12", 45446, 1736},
  {"F", 45525, 1739},
  {"Falk-31", 45633, 1743},
  {"Fokas-1980", 45748, 1747},
  {"Fokas-1981", 45840, 1750},
  {"Fokas-1987", 45932, 1753},
  {"Fung-1982", 46022, 1756},
  {"G", 46104, 1759},
  {"Garcia and Castellanos-1994", 46232, 1763},
  {"Gray-1993", 46340, 1766},
  {"H", 46421, 1769},
  {"Henon-1964", 46532, 1773},
  {"Here-94", 46621, 1776},
  {"Hereman-1996", 46712, 1779},
  {"Hirota-1981", 46806, 1782},
  {"Hydon-1994", 46899, 1785},
  {"I", 46982, 1788},
  {"Ibra-85", 47090, 1792},
  {"Ibragimov-1994", 47208, 1796},
  {"Ibra-949596", 47305, 1799},
  {"Ince-1956", 47396, 1802},
  {"J", 47477, 1805},
  {"Janet-1920", 47588, 1809},
  {"K", 47671, 1812},
  {"Kada-90", 47779, 1816},
  {"Kamke-1977", 47894, 1820},
  {"Karp-91", 47982, 1823},
  {"Klein-1918", 48097, 1827},
  {"Ko and Kuehl-1978", 48196, 1830},
  {"KortewegDeVries-1895", 48305, 1833},
  {"Kowa-31", 48404, 1836},
  {"L", 48483, 1839},
  {"Lamb-1945", 48593, 1843},
  {"Landau and Lifshitz-1981", 48697, 1846},
  {"Landau and Lifshitz-1984", 48816, 1849},
  {"Levi-89", 48918, 1852},
  {"Lie-Engel-1899", 49011, 1855},
  {"Lie-1874", 49104, 1858},
  {"Lie-88", 49189, 1861},
  {"Ligh-56", 49299, 1865},
  {"M", 49404, 1869},
  {"Ma-1993", 49512, 1873},
  {"Mack-1947", 49600, 1876},
  {"Mansfield-1992", 49694, 1879},
  {"Mohammad-1995", 49792, 1882},
  {"N", 49879, 1885},
  {"Nishitani and Tajiri-1982", 50006, 1889},
  {"Noether-18", 50114, 1892},
  {"Nuci-92", 50204, 1895},
  {"O", 50285, 1898},
  {"Olve-86", 50394, 1902},
  {"Olve-86R", 50481, 1905},
  {"Olve-87", 50595, 1909},
  {"Ovsi-82", 50682, 1912},
  {"P", 50762, 1915},
  {"Parkes-1994", 50875, 1919},
  {"Paul-1953", 50968, 1922},
  {"Porsezian and Lakshmanan-1993", 51079, 1925},
  {"Puci-92", 51188, 1928},
  {"R", 51268, 1931},
  {"Reid-1991", 51379, 1935},
  {"Reid-1993", 51496, 1939},
  {"Riquier-1910", 51590, 1942},
  {"Risken-1984", 51685, 1945},
  {"Rosenau and Schwarzmeier-1986", 51797, 1948},
  {"Russel-1844", 51910, 1951},
  {"S", 51994, 1954},
  {"Saffman and Taylor-1958", 52119, 1958},
  {"Sche-1891", 52224, 1961},
  {"Schl-33", 52312, 1964},
  {"Schwarz-1985", 52430, 1968},
  {"Schwarz-1992", 52527, 1971},
  {"Step-89", 52618, 1974},
  {"Stok-51", 52704, 1977},
  {"T", 52811, 1981},
  {"Tabor-1989", 52923, 1985},
  {"Tang-94", 53012, 1988},
  {"Tayl-50", 53125, 1992},
  {"Thomas-1929", 53242, 1996},
  {"Thomas-1934", 53336, 1999},
  {"Tink-75", 53426, 2002},
  {"V", 53532, 2006},
  {"Van Kampen-1981", 53649, 2010},
  {"Vinogradov-1984", 53751, 2013},
  {"W", 53840, 2016},
  {"Weyl-28", 53949, 2020},
  {"Wineland-1983", 54041, 2023},
  {"Wolf-1991", 54136, 2026},
  {"Wolf-1990", 54226, 2029},
  {"Wolf-91", 54314, 2032},
  {"Y", 54420, 2036},
  {"Yang-1994", 54531, 2040},
  {"Z", 54614, 2043},
  {"Zabusky-1965", 54728, 2047},
  {"Zakh-80", 54820, 2050},
  {"Zakh-74", 54933, 2054}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 24, 0, 94, "ChapterLine"],
Cell[1766, 53, 305, 4, 155, "Title",
  CounterAssignments->{{"Title", 11}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2074, 59, 92, 3, 29, "Text",
  CellTags->"A"],
Cell[2169, 64, 405, 10, 61, "Text",
  CellTags->"Abraham-Schrauner-93"],
Cell[2577, 76, 402, 11, 61, "Text",
  CellTags->"Alexeyev-1994"],
Cell[2982, 89, 213, 7, 27, "Text",
  CellTags->"Ames-68"],
Cell[3198, 98, 117, 4, 29, "Text",
  PageBreakBelow->False,
  CellTags->"B"],
Cell[3318, 104, 264, 9, 44, "Text",
  CellTags->"Baik-89"],
Cell[3585, 115, 289, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Baik-91"],
Cell[3877, 128, 278, 10, 44, "Text",
  CellTags->"Baumann-1991"],
Cell[4158, 140, 282, 7, 44, "Text",
  CellTags->"Baum-92"],
Cell[4443, 149, 270, 10, 43, "Text",
  CellTags->"Baum-96"],
Cell[4716, 161, 316, 12, 44, "Text",
  CellTags->"Baum-95"],
Cell[5035, 175, 328, 10, 44, "Text",
  CellTags->"Baumann and Nonnenmacher-1992"],
Cell[5366, 187, 375, 12, 60, "Text",
  Evaluatable->False,
  CellTags->"Baum-87"],
Cell[5744, 201, 173, 6, 26, "Text",
  CellTags->"Birk-50"],
Cell[5920, 209, 219, 6, 43, "Text",
  CellTags->"Blan-92"],
Cell[6142, 217, 293, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Blas-08"],
Cell[6438, 230, 346, 9, 60, "Text",
  CellTags->"Blu-93"],
Cell[6787, 241, 146, 4, 43, "Text",
  CellTags->"Blu-93a"],
Cell[6936, 247, 272, 10, 44, "Text",
  CellTags->"Blum-69"],
Cell[7211, 259, 207, 6, 43, "Text",
  CellTags->"Bum-74"],
Cell[7421, 267, 199, 6, 43, "Text",
  CellTags->"Blum-89"],
Cell[7623, 275, 310, 10, 44, "Text",
  CellTags->"Blum-90"],
Cell[7936, 287, 298, 10, 44, "Text",
  CellTags->"Bountis-1982"],
Cell[8237, 299, 424, 12, 60, "Text",
  CellTags->"Boussinesq-1872"],
Cell[8664, 313, 280, 10, 44, "Text",
  CellTags->"Boyer-1989"],
Cell[8947, 325, 294, 7, 60, "Text",
  CellTags->"Buchberger-1985"],
Cell[9244, 334, 280, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Burg-48"],
Cell[9527, 347, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"C"],
Cell[9647, 353, 365, 11, 60, "Text",
  CellTags->"Calogero-1978"],
Cell[10015, 366, 323, 10, 44, "Text",
  CellTags->"Calogero-1981"],
Cell[10341, 378, 428, 10, 76, "Text",
  CellTags->"Carra-Ferro-1993"],
Cell[10772, 390, 332, 10, 60, "Text",
  CellTags->"Champagne-1990"],
Cell[11107, 402, 319, 10, 44, "Text",
  CellTags->"Chan-1994"],
Cell[11429, 414, 299, 10, 44, "Text",
  CellTags->"Cicogna-1990"],
Cell[11731, 426, 300, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Clar-89"],
Cell[12034, 439, 282, 10, 44, "Text",
  CellTags->"Clarkson-89"],
Cell[12319, 451, 386, 12, 44, "Text",
  Evaluatable->False,
  CellTags->"Clar-94"],
Cell[12708, 465, 235, 7, 43, "Text",
  Evaluatable->False,
  CellTags->"Cour-48"],
Cell[12946, 474, 258, 9, 27, "Text",
  Evaluatable->False,
  CellTags->"Crig-79"],
Cell[13207, 485, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"D"],
Cell[13327, 491, 316, 10, 44, "Text",
  CellTags->"Das Sarma-1991"],
Cell[13646, 503, 173, 6, 26, "Text",
  CellTags->"Drazin-1983"],
Cell[13822, 511, 710, 23, 60, "Text",
  Evaluatable->False,
  CellTags->"Drew-1989"],
Cell[14535, 536, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"E"],
Cell[14655, 542, 264, 9, 44, "Text",
  CellTags->"Eggers-1993"],
Cell[14922, 553, 214, 9, 27, "Text",
  CellTags->"Eggers-1997"],
Cell[15139, 564, 196, 8, 27, "Text"],
Cell[15338, 574, 235, 6, 43, "Text",
  CellTags->"Enge-12"],
Cell[15576, 582, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"F"],
Cell[15696, 588, 277, 10, 44, "Text",
  Evaluatable->False,
  CellTags->"Falk-31"],
Cell[15976, 600, 269, 10, 44, "Text",
  CellTags->"Fokas-1980"],
Cell[16248, 612, 307, 10, 44, "Text",
  CellTags->"Fokas-1981"],
Cell[16558, 624, 239, 9, 27, "Text",
  CellTags->"Fokas-1987"],
Cell[16800, 635, 448, 14, 60, "Text",
  CellTags->"Fung-1982"],
Cell[17251, 651, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"G"],
Cell[17371, 657, 309, 10, 44, "Text",
  CellTags->"Garcia and Castellanos-1994"],
Cell[17683, 669, 198, 6, 43, "Text",
  CellTags->"Gray-1993"],
Cell[17884, 677, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"H"],
Cell[18004, 683, 298, 10, 44, "Text",
  CellTags->"Henon-1964"],
Cell[18305, 695, 294, 10, 44, "Text",
  CellTags->"Here-94"],
Cell[18602, 707, 381, 9, 76, "Text",
  CellTags->"Hereman-1996"],
Cell[18986, 718, 276, 10, 44, "Text",
  CellTags->"Hirota-1981"],
Cell[19265, 730, 282, 10, 44, "Text",
  CellTags->"Hydon-1994"],
Cell[19550, 742, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"I"],
Cell[19670, 748, 225, 7, 43, "Text",
  Evaluatable->False,
  CellTags->"Ibra-85"],
Cell[19898, 757, 296, 10, 44, "Text",
  CellTags->"Ibragimov-1994"],
Cell[20197, 769, 244, 6, 43, "Text",
  CellTags->"Ibra-949596"],
Cell[20444, 777, 183, 6, 26, "Text",
  CellTags->"Ince-1956"],
Cell[20630, 785, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"J"],
Cell[20750, 791, 291, 10, 44, "Text",
  CellTags->"Janet-1920"],
Cell[21044, 803, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"K"],
Cell[21164, 809, 299, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Kada-90"],
Cell[21466, 822, 170, 6, 26, "Text",
  CellTags->"Kamke-1977"],
Cell[21639, 830, 309, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Karp-91"],
Cell[21951, 843, 384, 11, 60, "Text",
  CellTags->"Klein-1918"],
Cell[22338, 856, 279, 10, 44, "Text",
  CellTags->"Ko and Kuehl-1978"],
Cell[22620, 868, 349, 11, 60, "Text",
  CellTags->"KortewegDeVries-1895"],
Cell[22972, 881, 241, 7, 43, "Text",
  CellTags->"Kowa-31"],
Cell[23216, 890, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"L"],
Cell[23336, 896, 163, 6, 26, "Text",
  CellTags->"Lamb-1945"],
Cell[23502, 904, 199, 6, 26, "Text",
  CellTags->"Landau and Lifshitz-1981"],
Cell[23704, 912, 190, 6, 26, "Text",
  CellTags->"Landau and Lifshitz-1984"],
Cell[23897, 920, 297, 10, 44, "Text",
  CellTags->"Levi-89"],
Cell[24197, 932, 206, 6, 43, "Text",
  CellTags->"Lie-Engel-1899"],
Cell[24406, 940, 208, 6, 26, "Text",
  CellTags->"Lie-1874"],
Cell[24617, 948, 254, 8, 43, "Text",
  Evaluatable->False,
  CellTags->"Lie-88"],
Cell[24874, 958, 324, 9, 60, "Text",
  Evaluatable->False,
  CellTags->"Ligh-56"],
Cell[25201, 969, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"M"],
Cell[25321, 975, 278, 10, 44, "Text",
  CellTags->"Ma-1993"],
Cell[25602, 987, 185, 4, 43, "Text",
  CellTags->"Mack-1947"],
Cell[25790, 993, 217, 6, 43, "Text",
  CellTags->"Mansfield-1992"],
Cell[26010, 1001, 301, 10, 44, "Text",
  CellTags->"Mohammad-1995"],
Cell[26314, 1013, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"N"],
Cell[26434, 1019, 286, 10, 44, "Text",
  CellTags->"Nishitani and Tajiri-1982"],
Cell[26723, 1031, 482, 17, 60, "Text",
  CellTags->"Noether-18"],
Cell[27208, 1050, 352, 11, 60, "Text",
  CellTags->"Nuci-92"],
Cell[27563, 1063, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"O"],
Cell[27683, 1069, 198, 6, 43, "Text",
  CellTags->"Olve-86"],
Cell[27884, 1077, 388, 13, 44, "Text",
  Evaluatable->False,
  CellTags->"Olve-86R"],
Cell[28275, 1092, 275, 10, 44, "Text",
  CellTags->"Olve-87"],
Cell[28553, 1104, 193, 6, 43, "Text",
  CellTags->"Ovsi-82"],
Cell[28749, 1112, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"P"],
Cell[28869, 1118, 292, 10, 44, "Text",
  CellTags->"Parkes-1994"],
Cell[29164, 1130, 268, 10, 44, "Text",
  CellTags->"Paul-1953"],
Cell[29435, 1142, 314, 10, 44, "Text",
  CellTags->"Porsezian and Lakshmanan-1993"],
Cell[29752, 1154, 265, 9, 44, "Text",
  CellTags->"Puci-92"],
Cell[30020, 1165, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"R"],
Cell[30140, 1171, 384, 13, 44, "Text",
  Evaluatable->False,
  CellTags->"Reid-1991"],
Cell[30527, 1186, 448, 11, 76, "Text",
  CellTags->"Reid-1993"],
Cell[30978, 1199, 237, 8, 43, "Text",
  CellTags->"Riquier-1910"],
Cell[31218, 1209, 177, 6, 26, "Text",
  CellTags->"Risken-1984"],
Cell[31398, 1217, 297, 10, 44, "Text",
  CellTags->"Rosenau and Schwarzmeier-1986"],
Cell[31698, 1229, 217, 5, 43, "Text",
  CellTags->"Russel-1844"],
Cell[31918, 1236, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"S"],
Cell[32038, 1242, 337, 10, 44, "Text",
  CellTags->"Saffman and Taylor-1958"],
Cell[32378, 1254, 263, 8, 43, "Text",
  CellTags->"Sche-1891"],
Cell[32644, 1264, 258, 10, 27, "Text",
  Evaluatable->False,
  CellTags->"Schl-33"],
Cell[32905, 1276, 273, 10, 44, "Text",
  CellTags->"Schwarz-1985"],
Cell[33181, 1288, 335, 7, 60, "Text",
  CellTags->"Schwarz-1992"],
Cell[33519, 1297, 216, 6, 43, "Text",
  CellTags->"Step-89"],
Cell[33738, 1305, 294, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Stok-51"],
Cell[34035, 1318, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"T"],
Cell[34155, 1324, 272, 8, 43, "Text",
  CellTags->"Tabor-1989"],
Cell[34430, 1334, 328, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Tang-94"],
Cell[34761, 1347, 481, 17, 61, "Text",
  Evaluatable->False,
  CellTags->"Tayl-50"],
Cell[35245, 1366, 248, 9, 27, "Text",
  CellTags->"Thomas-1929"],
Cell[35496, 1377, 248, 9, 27, "Text",
  CellTags->"Thomas-1934"],
Cell[35747, 1388, 199, 7, 26, "Text",
  Evaluatable->False,
  CellTags->"Tink-75"],
Cell[35949, 1397, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"V"],
Cell[36069, 1403, 205, 6, 43, "Text",
  CellTags->"Van Kampen-1981"],
Cell[36277, 1411, 339, 10, 44, "Text",
  CellTags->"Vinogradov-1984"],
Cell[36619, 1423, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"W"],
Cell[36739, 1429, 172, 6, 26, "Text",
  CellTags->"Weyl-28"],
Cell[36914, 1437, 298, 10, 44, "Text",
  CellTags->"Wineland-1983"],
Cell[37215, 1449, 168, 6, 26, "Text",
  CellTags->"Wolf-1991"],
Cell[37386, 1457, 248, 9, 44, "Text",
  CellTags->"Wolf-1990"],
Cell[37637, 1468, 246, 7, 43, "Text",
  Evaluatable->False,
  CellTags->"Wolf-91"],
Cell[37886, 1477, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"Y"],
Cell[38006, 1483, 281, 10, 44, "Text",
  CellTags->"Yang-1994"],
Cell[38290, 1495, 117, 4, 28, "Text",
  PageBreakBelow->False,
  CellTags->"Z"],
Cell[38410, 1501, 316, 10, 44, "Text",
  CellTags->"Zabusky-1965"],
Cell[38729, 1513, 319, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Zakh-80"],
Cell[39051, 1526, 273, 10, 44, "Text",
  Evaluatable->False,
  CellTags->"Zakh-74"],
Cell[39327, 1538, 154, 3, 35, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

