(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    120650,       4099]*)
(*NotebookOutlinePosition[    132196,       4387]*)
(*  CellTagsIndexPosition[    130710,       4344]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.10 Molecular Beam Epitaxy", "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 76}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Molecular Beam Epitaxy"],

Cell["\<\
Before discussing a detailed analysis of the growth equations of \
molecular beam epitaxy (MBE), let us describe the main relevant microscopic \
processes taking place on a crystal interface. The morphology of the \
interface is determined by the interplay among deposition, desorption, and \
surface diffusion. The term deposition means the sticking of an atom on the \
surface if it arrives from vapor. Crystals grow by atomic deposition. \
Desorption is the reverse effect, competing with deposition. Under \
desorption, we understand that atoms deposited on the surface leave the \
interface. When an atom is deposited on a surface, it forms bonds that must \
be broken before desorption can occur. If only some of the bonds are broken, \
the atom gains the ability to move on the surface. From a microscopic point \
of view, surface diffusion is an activated process. The discrete positions of \
the atom are determined by the crystal lattice. For an atom on the surface to \
diffuse to the next lattice position, it must overcome the lattice potential \
existing between two neighboring positions. This excess energy required for \
diffusion is the microscopic origin of the lattice potential.\
\>", "Text",
  CellTags->{
  "growth equations of molecular beam epitaxy", "microscopic processes", 
    "crystal interface", "deposition", "desorption", "surface diffusion", 
    "atomic deposition", "bonds", "activated process", "excess energy", 
    "lattice potential"}],

Cell["\<\
The physical mechanism that governs MBE is the surface diffusion of \
the deposited particles. For the moment, we assume that desorption is \
negligible. So we consider the scenario of atoms deposited on a surface, \
whereupon they diffuse. The goal is to find an equation for the form\
\>", 
  "Text",
  CellTags->"surface diffusion"],

Cell[BoxData[
    \(TraditionalForm\`\[PartialD]\_t\ \(a(x, t)\)\  = \ F(a, x, t)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "that describes the variation in the interface amplitude ",
  Cell[BoxData[
      \(TraditionalForm\`a(x, t)\)]],
  ". Diffusion processes are directly connected with a macroscopic current. \
The local changes in the surface height are the result of the currents along \
the surface. Since we neglect desorption, the total number of atoms remains \
unchanged during the diffusion process and the current must obey a continuity \
equation:"
}], "Text",
  CellTags->{
  "interface amplitude", "macroscopic current", "surface", 
    "continuity equation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  = \ 
      \(-\ \(div(\(j\&\[RightVector]\)(x, t)) . \)\)\)], "NumberedEquation"],

Cell[TextData[{
  "On the other hand, the surface current is driven by the difference in the \
local chemical potential ",
  Cell[BoxData[
      \(TraditionalForm\`j\&\[RightVector] \[Tilde] \ grad(\[Mu](x, t))\)]],
  ". As we already mentioned, the diffusion is an activated process. The \
motion of an atom depends on the number of bonds that must be broken. The \
more neighbors an atom has, the lower the mobility. A measure of mobility is \
the local radius of curvature ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ". A simple assumption is that the chemical potential is proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)/r\)]],
  ", which, in turn, is proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`div(grad(a(x, t)))\)]],
  ". Hence, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Mu]", "\[Tilde]", 
          RowBox[{"-", 
            RowBox[{
              StyleBox[
                RowBox[{"\[CapitalDelta]", 
                  StyleBox["a",
                    FontSlant->"Italic"]}]], "(", \(x, t\), ")"}]}]}], 
        TraditionalForm]]],
  ", where \[CapitalDelta] denotes the Laplacian. Combining the arguments \
given, we end up with the equation"
}], "Text",
  CellTags->{
  "surface current", "chemical potential", "activated process", "mobility", 
    "Laplacian"}],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  + \ \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = 
      \ 0. \)], "NumberedEquation"],

Cell[TextData[{
  "In MBE experiments, we have, on the other side, a flux ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi] = \[Phi](x, t)\)]],
  " of atoms bombarding the surface. The flux is defined as the number of \
particles arriving on the unit surface in a unit time. At large length \
scales, the beam is homogeneous with an average intensity \[Phi]. Thus, the \
growth equation incorporating surface diffusion and deposition has the form"
}], "Text",
  CellTags->"intensity"],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  + \ \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = 
      \ \(\[Phi] . \)\)], "NumberedEquation"],

Cell[TextData[{
  "The growth equation incorporating statistical fluctuations in the flux was \
originally introduced independently by ",
  ButtonBox["Wolf and Villain [1990]",
    ButtonData:>{"Literat.nb", "Wolf-1990"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Das Sarma and Tamborenea [1991].",
    ButtonData:>{"Literat.nb", "Das Sarma-1991"},
    ButtonStyle->"Hyperlink"],
  " Since we are only interested in the deterministic behavior of the model, \
we suppress the noise in the equations. If we now include the process of \
desorption, we can write down a linear model for MBE. Let us assume with \
Villain that the desorption-dominated growth of the surface is governed by \
the difference between the average chemical potential in the vapor ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&_\)]],
  " and the local chemical potential on the surface ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu](x, t)\)]],
  ". Thus, the temporal change in the amplitude ",
  StyleBox["a",
    FontSlant->"Italic"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          RowBox[{"\[Beta]", "(", 
            RowBox[{\(\[Mu](x, t)\), "-", 
              FormBox[\(\[Mu]\&_)\),
                "TraditionalForm"]}]}]}], TraditionalForm]]],
  ". The complete deterministic model including deposition, desorption, and \
surface diffusion now reads"
}], "Text",
  CellTags->{"desorption", "chemical potential"}],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  + \ \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = 
      \ \[Phi] + \ \ \[Alpha]\ \ \[Del]\^2\( a(x, t)\)\  + \ 
        \[Beta] \( \[Mu]\&_ . \)\)], "NumberedEquation"],

Cell[TextData[{
  "Apart from the beam flux \[Phi], we incorporated an additional flux \
\[Beta]",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&_\)]],
  ". Both terms can be abbreviated by ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi] = \[Phi] + \[Beta]  \[Mu]\&_\)]],
  ":"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  + \ \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = 
      \ \ \[Alpha]\ \ \[Del]\^2\( a(x, t)\)\  + \ \(\[CapitalPhi] . \)\)], 
  "NumberedEquation"],

Cell[TextData[
"This equation contains all physically relevant linear terms describing the \
growth of interfaces by MBE. The competition between the diffusion and \
desorption processes will determine the growth of the surface. The parameters \
\[Kappa], \[Alpha], and \[CapitalPhi] are assumed to be real and positive."], 
  "Text",
  CellTags->"growth of interfaces"],

Cell[TextData[{
  "Another aspect to be considered in MBE is the influence of non-linearity. \
Non-linearity comes into play if we consider large domains in space. For such \
cases, the small gradients in ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " are not negligible. The corresponding terms of second- and third-order \
non-linearity are incorporated in the growth equation, which now reads"
}], "Text",
  CellTags->{"nonlinearity", "growth equation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[PartialD]\_t\( a(x, t)\)\  + \ 
        \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = \ 
      \[Alpha]\ \ \[Del]\^2\( a(x, t)\)\  + \ \[CapitalPhi]\  + 
        \[Gamma]\ \[Del]\^2\((\[Del]\(a(x, t)\))\)\^2 + \t
        \[Lambda] \[Del]\(\[CenterDot]\((\[Del]\(a(x, t)\))\)\^3\), \)\)], 
  "NumberedEquation",
  TextAlignment->Center,
  TextJustification->0,
  CellTags->"eq-7"],

Cell[TextData[{
  "where we kept terms up to the fourth order in ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_x\)]],
  ". To gain some insight into the dynamic of this model, let us first \
examine the symmetries of the one-dimensional version. For this case, \
equation (5.83) reduces to a (1+1)-dimensional expression. The related \
equation for the amplitude"
}], "Text"],

Cell[BoxData[
    \(\(A = a[x, t]; \)\)], "Input"],

Cell[TextData[{
  "reads in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nMBE\  = \ 
      \[PartialD]\_t A + \ \[Kappa]\ \[PartialD]\_{x, 4}A\  - 
          \[Alpha] \[PartialD]\_{x, 2}A\  - \ 
          \[Gamma] \[PartialD]\_{x, 2}\((\[PartialD]\_x A)\)\^2 - 
          \[Lambda]\ \[PartialD]\_x\((\[PartialD]\_x A)\)\^3 - 
          \[CapitalPhi]\  == 0; nMBE // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[CapitalPhi]\) + a\_t - \[Alpha]\ a\_\(x, x\) - 
                3\ \[Lambda]\ a\_x\%2\ a\_\(x, x\) - 
                \[Gamma]\ \((2\ a\_\(x, x\)\%2 + 2\ a\_x\ a\_\(x, x, x\))\) + 
                \[Kappa]\ a\_\(x, x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"where \[Kappa], \[Alpha], \[Gamma], \[CapitalPhi], and \[Lambda] are real \
constants. The symmetries for this general non-linear model follow by"], 
  "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inMBE\  = \ 
      Infinitesimals[nMBE, 
        a, {x, t}, {\[Kappa], \[Alpha], \[Lambda], \[Gamma], \[CapitalPhi]}]; 
    inMBE // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k1\)},
          {\(\[Xi]\_1 == k2\)},
          {\(\[Xi]\_2 == k3\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], k1], 
        Equal[ 
          Subscript[ \[Xi], 1], k2], 
        Equal[ 
          Subscript[ \[Xi], 2], k3]}]]], "Output"]
}, Open  ]],

Cell["\<\
representing a three-dimensional group containing only \
translations. The reduction of this (1+1)-dimensional model to an ODE follows \
by\
\>", "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1\  = \ LieReduction[nMBE, {a}, {x, t}, {1, c}, {1}]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(t - c\ x - \[Zeta]\_1 == 0\)},
          {\(a - x - F\_1 == 0\)},
          {
            \(\(-\[CapitalPhi]\) + F1\_\(\[Zeta]\_1\) - 
                c\^2\ \[Alpha]\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                3\ c\^2\ \[Lambda]\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                6\ c\^3\ \[Lambda]\ F1\_\(\[Zeta]\_1\)\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                3\ c\^4\ \[Lambda]\ F1\_\[Zeta]\_1\%2\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                2\ c\^4\ \[Gamma]\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\)\%2 + 
                2\ c\^3\ \[Gamma]\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) - 
                2\ c\^4\ \[Gamma]\ F1\_\(\[Zeta]\_1\)\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                c\^4\ \[Kappa]\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
describing a moving wave solution governed by a non-linear \
fourth-order ODE. This reduced equation can be integrated once:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[H]; \n
    intMBE = \[Integral]\((
                red1\[LeftDoubleBracket]3, 1, 1\[RightDoubleBracket])\) 
              \[DifferentialD]zeta1 == C[1] /. {F1 \[Rule] H, 
          zeta1 \[Rule] \[Zeta]}; intMBE // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(H - \[Zeta]\ \[CapitalPhi] - C[1] - 
                c\^2\ \((\[Alpha] + 3\ \[Lambda])\)\ H\_\[Zeta] + 
                3\ c\^3\ \[Lambda]\ H\_\[Zeta]\%2 - 
                c\^4\ \[Lambda]\ H\_\[Zeta]\%3 - 
                2\ c\^3\ \[Gamma]\ \((\(-1\) + c\ H\_\[Zeta])\)\n\t\ 
                  H\_\(\[Zeta], \[Zeta]\) + 
                c\^4\ \[Kappa]\ H\_\(\[Zeta], \[Zeta], \[Zeta]\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The symmetries of the resulting third-order ODE are", "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infinirMBE = 
      Infinitesimals[intMBE, H, 
        \[Zeta], {\[Alpha], \[Kappa], \[Gamma], \[Lambda], \[CapitalPhi], c, 
          C[1]}, SubstitutionRules 
          \[Rule] {\[PartialD]\_{\[Zeta], 3}H[\[Zeta]]}]; 
    infinirMBE // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k1\ \[CapitalPhi]\)},
          {\(\[Xi]\_1 == k1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ k1, \[CapitalPhi]]], 
        Equal[ 
          Subscript[ \[Xi], 1], k1]}]]], "Output"]
}, Open  ]],

Cell["\<\
The result shows that the reduced equation following from the \
general model is not solvable by Lie's method.\
\>", "Text"],

Cell["\<\
In the following, we will discuss two limiting models, including \
surface diffusion in connection with non-linearity and desorption with \
non-linearity. Both models include a term describing deposition.\
\>", "Text"],

Cell[CellGroupData[{

Cell["5.6.10.1 Surface Diffusion with Nonlinearity", "Subsubsection",
  CellTags->"Surface Diffusion with Nonlinearity"],

Cell[TextData[{
  "If we choose in the general model (5.83) ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = 0\)]],
  ", we get a model including only surface diffusion and quadratic \
non-linearity in the gradient of ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ". The equation of motion reduces to"
}], "Text",
  CellTags->"surface diffusion"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m8MBE\  = \ nMBE\  /. {\[Alpha] \[Rule] 0, \[Lambda] \[Rule] 0}; 
    m8MBE // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[CapitalPhi]\) + a\_t - 
                \[Gamma]\ \((2\ a\_\(x, x\)\%2 + 2\ a\_x\ a\_\(x, x, x\))\) + 
                \[Kappa]\ a\_\(x, x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The symmetry group of this special model", "Text",
  CellTags->"symmetry group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m8infi\  = \ 
      Infinitesimals[m8MBE, a, {x, t}, {\[Kappa], \[Gamma], \[CapitalPhi]}]; 
    m8infi // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k1 + k4\ t\ \[CapitalPhi]\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k2", "+", 
                StyleBox[\(\(k4\ x\)\/4\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == k3 + k4\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k1, 
            Times[ k4, t, \[CapitalPhi]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ 
              Rational[ 1, 4], k4, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k3, 
            Times[ k4, t]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
contains translations and a scaling. Let us examine the scaling \
group\
\>", "Text",
  CellTags->"scaling group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = 
      \({{\(xi[1]\)[x, t, a], \(xi[2]\)[x, t, a]}, {\(phi[1]\)[x, t, a]}} /. 
          m8infi\) /. {k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 1}
          \)], "Input"],

Cell[BoxData[
    \({{x\/4, t}, {t\ \[CapitalPhi]}}\)], "Output"]
}, Open  ]],

Cell["\<\
This kind of infinitesimals reduce the original equation to a \
fourth-order ODE:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1\  = \ 
      LieReduction[m8MBE, {a}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(t\/x\^4\),
                  ScriptLevel->0], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(a - t\ \[CapitalPhi] - F\_1 == 0\)},
          {
            \(F1\_\(\[Zeta]\_1\) + 
                840\ \[Kappa]\ F1\_\(\[Zeta]\_1\)\ \[Zeta]\_1 - 
                1760\ \[Gamma]\ F1\_\[Zeta]\_1\%2\ \[Zeta]\_1\%2 + 
                3120\ \[Kappa]\ \[Zeta]\_1\%2\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                3200\ \[Gamma]\ F1\_\(\[Zeta]\_1\)\ \[Zeta]\_1\%3\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                512\ \[Gamma]\ \[Zeta]\_1\%4\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\)\%2 + 
                1920\ \[Kappa]\ \[Zeta]\_1\%3\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) - 
                512\ \[Gamma]\ F1\_\(\[Zeta]\_1\)\ \[Zeta]\_1\%4\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                256\ \[Kappa]\ \[Zeta]\_1\%4\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Interestingly, the resulting ODE does not contain the flux term \
\[CapitalPhi]. This term is completely separated in the similarity \
representation of the solution by ",
  Cell[BoxData[
      \(TraditionalForm\`a = \[CapitalPhi]\ t\  + \(F\_1\)(t/x\^4)\)]],
  ". The unknown function ",
  Cell[BoxData[
      \(TraditionalForm\`F\_1\)]],
  " has to satisfy the fourth-order ODE, which cannot be solved symbolically. \
However, we can derive a numerical solution if we add four initial conditions \
to the ODE:"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"neq", " ", "=", " ", 
        RowBox[{
          RowBox[{"Join", "[", 
            RowBox[{\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\), ",", 
              RowBox[{"{", 
                RowBox[{\(F1[1] == 1\), ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[Prime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    "0"}], ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[DoublePrime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(3/2\)}], ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", 
                        TagBox[\((3)\),
                          Derivative],
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(-10\)}]}], "}"}]}], "]"}], "/.", 
          \({\[Gamma] \[Rule] 1}\)}]}], ";"}]], "Input"],

Cell[TextData[{
  "The numerical solution for a fixed value of \[Gamma] and nine different \
values of \[Kappa] follows by applying ",
  StyleBox["NDSolve[]", "MmaText"],
  " to the equations"
}], "Text",
  CellTags->"numerical solution"],

Cell[BoxData[
    \(\(nsol\  = \ 
      Table[NDSolve[neq /. \[Kappa] \[Rule] i, F1, {zeta1, 1, 15}], {i,  .2, 
          1,  .1}]; \)\)], "Input"],

Cell["These solutions are plotted below.", "Text"],

Cell[BoxData[
    \(\(color\  = \ Table[RGBColor[i, 0.1, 0.3], {i,  .2, 1,  .1}]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[F1[\[Zeta]] /. nsol], {\[Zeta], 1, 6}, 
      PlotStyle \[Rule] color, 
      AxesLabel \[Rule] {"\<\[Zeta]\>", \*"\"\<\!\(F\_1\)\>\""}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.190476 -0.764702 1.11405 [
[.21429 .33685 -3 -9 ]
[.21429 .33685 3 0 ]
[.40476 .33685 -3 -9 ]
[.40476 .33685 3 0 ]
[.59524 .33685 -3 -9 ]
[.59524 .33685 3 0 ]
[.78571 .33685 -3 -9 ]
[.78571 .33685 3 0 ]
[.97619 .33685 -3 -9 ]
[.97619 .33685 3 0 ]
[1.025 .34935 0 -7.5 ]
[1.025 .34935 10 7.5 ]
[.01131 .01513 -18 -4.5 ]
[.01131 .01513 0 4.5 ]
[.01131 .12654 -18 -4.5 ]
[.01131 .12654 0 4.5 ]
[.01131 .23794 -18 -4.5 ]
[.01131 .23794 0 4.5 ]
[.01131 .46075 -18 -4.5 ]
[.01131 .46075 0 4.5 ]
[.01131 .57216 -18 -4.5 ]
[.01131 .57216 0 4.5 ]
[.02381 .64303 -7.5 0 ]
[.02381 .64303 7.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.21429 .34935 m
.21429 .3556 L
s
[(2)] .21429 .33685 0 1 Mshowa
.40476 .34935 m
.40476 .3556 L
s
[(3)] .40476 .33685 0 1 Mshowa
.59524 .34935 m
.59524 .3556 L
s
[(4)] .59524 .33685 0 1 Mshowa
.78571 .34935 m
.78571 .3556 L
s
[(5)] .78571 .33685 0 1 Mshowa
.97619 .34935 m
.97619 .3556 L
s
[(6)] .97619 .33685 0 1 Mshowa
.125 Mabswid
.0619 .34935 m
.0619 .3531 L
s
.1 .34935 m
.1 .3531 L
s
.1381 .34935 m
.1381 .3531 L
s
.17619 .34935 m
.17619 .3531 L
s
.25238 .34935 m
.25238 .3531 L
s
.29048 .34935 m
.29048 .3531 L
s
.32857 .34935 m
.32857 .3531 L
s
.36667 .34935 m
.36667 .3531 L
s
.44286 .34935 m
.44286 .3531 L
s
.48095 .34935 m
.48095 .3531 L
s
.51905 .34935 m
.51905 .3531 L
s
.55714 .34935 m
.55714 .3531 L
s
.63333 .34935 m
.63333 .3531 L
s
.67143 .34935 m
.67143 .3531 L
s
.70952 .34935 m
.70952 .3531 L
s
.74762 .34935 m
.74762 .3531 L
s
.82381 .34935 m
.82381 .3531 L
s
.8619 .34935 m
.8619 .3531 L
s
.9 .34935 m
.9 .3531 L
s
.9381 .34935 m
.9381 .3531 L
s
.25 Mabswid
0 .34935 m
1 .34935 L
s
gsave
1.025 .34935 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .01513 m
.03006 .01513 L
s
[(0.7)] .01131 .01513 1 0 Mshowa
.02381 .12654 m
.03006 .12654 L
s
[(0.8)] .01131 .12654 1 0 Mshowa
.02381 .23794 m
.03006 .23794 L
s
[(0.9)] .01131 .23794 1 0 Mshowa
.02381 .46075 m
.03006 .46075 L
s
[(1.1)] .01131 .46075 1 0 Mshowa
.02381 .57216 m
.03006 .57216 L
s
[(1.2)] .01131 .57216 1 0 Mshowa
.125 Mabswid
.02381 .03741 m
.02756 .03741 L
s
.02381 .0597 m
.02756 .0597 L
s
.02381 .08198 m
.02756 .08198 L
s
.02381 .10426 m
.02756 .10426 L
s
.02381 .14882 m
.02756 .14882 L
s
.02381 .1711 m
.02756 .1711 L
s
.02381 .19338 m
.02756 .19338 L
s
.02381 .21566 m
.02756 .21566 L
s
.02381 .26022 m
.02756 .26022 L
s
.02381 .28251 m
.02756 .28251 L
s
.02381 .30479 m
.02756 .30479 L
s
.02381 .32707 m
.02756 .32707 L
s
.02381 .37163 m
.02756 .37163 L
s
.02381 .39391 m
.02756 .39391 L
s
.02381 .41619 m
.02756 .41619 L
s
.02381 .43847 m
.02756 .43847 L
s
.02381 .48303 m
.02756 .48303 L
s
.02381 .50532 m
.02756 .50532 L
s
.02381 .5276 m
.02756 .5276 L
s
.02381 .54988 m
.02756 .54988 L
s
.02381 .59444 m
.02756 .59444 L
s
.02381 .61672 m
.02756 .61672 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -68.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 .1 .3 r
.5 Mabswid
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35103 L
.0379 .35326 L
.04262 .356 L
.05224 .36319 L
.06244 .37263 L
.10458 .42185 L
.14241 .46949 L
.1827 .5161 L
.22147 .55315 L
.24118 .56832 L
.2627 .5818 L
.27267 .58692 L
.28329 .5916 L
.29325 .59525 L
.30241 .59799 L
.31269 .60038 L
.3181 .60134 L
.32382 .60215 L
.32879 .60268 L
.33118 .60287 L
.33343 .60303 L
.33471 .6031 L
.3361 .60317 L
.33725 .60321 L
.33853 .60325 L
.3399 .60329 L
.34066 .6033 L
.34137 .60331 L
.34263 .60332 L
.34334 .60332 L
.34399 .60332 L
.34527 .60331 L
.34647 .60329 L
.34756 .60326 L
.34873 .60323 L
.35136 .60312 L
.35379 .60298 L
.35822 .60265 L
.36291 .60217 L
.37277 .60078 L
.38361 .59867 L
.40306 .59348 L
.42395 .58612 L
.46523 .56723 L
Mistroke
.50499 .54506 L
.54324 .52136 L
.58393 .49465 L
.62312 .4682 L
.66475 .43987 L
.70487 .4127 L
.74347 .38691 L
.78453 .35999 L
.82407 .33466 L
.86209 .31088 L
.90257 .28622 L
.94153 .26313 L
.97619 .24312 L
Mfstroke
.3 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35326 L
.04262 .35598 L
.05224 .36309 L
.06244 .37234 L
.10458 .41872 L
.14241 .45991 L
.16345 .47973 L
.1827 .49524 L
.20281 .50849 L
.22147 .51797 L
.23143 .52191 L
.24046 .52481 L
.25049 .52731 L
.256 .52836 L
.26118 .52914 L
.26584 .52968 L
.26848 .52991 L
.27095 .53009 L
.27228 .53016 L
.27355 .53023 L
.2747 .53027 L
.27592 .53031 L
.27656 .53033 L
.27725 .53034 L
.27848 .53036 L
.27917 .53036 L
.27991 .53037 L
.28062 .53037 L
.28126 .53036 L
.28234 .53035 L
.28349 .53033 L
.28457 .5303 L
.28556 .53026 L
.28798 .53015 L
.29026 .53001 L
.29481 .52964 L
.29973 .52908 L
.3092 .5276 L
.31961 .52535 L
.34065 .51902 L
.3601 .51125 L
.38099 .50113 L
.42227 .47675 L
Mistroke
.46203 .44922 L
.50027 .42026 L
.54097 .38782 L
.58015 .35575 L
.62179 .32135 L
.66191 .2883 L
.70051 .25683 L
.74157 .22392 L
.78111 .19285 L
.81913 .16364 L
.85961 .1333 L
.89857 .10483 L
.93998 .07538 L
.97619 .0503 L
Mfstroke
.4 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35596 L
.05224 .36304 L
.06244 .3722 L
.10458 .4173 L
.14241 .4559 L
.16345 .47377 L
.1827 .48729 L
.20258 .4982 L
.22147 .50566 L
.23106 .50838 L
.23632 .50957 L
.24128 .5105 L
.24591 .5112 L
.24835 .51151 L
.25092 .51178 L
.25309 .51198 L
.25548 .51216 L
.25764 .51228 L
.25967 .51237 L
.26093 .51241 L
.26162 .51242 L
.26227 .51243 L
.26341 .51245 L
.26467 .51246 L
.26534 .51246 L
.26604 .51245 L
.26729 .51243 L
.26799 .51242 L
.26864 .5124 L
.27012 .51236 L
.27141 .5123 L
.27263 .51224 L
.27491 .51211 L
.28002 .51167 L
.28465 .51113 L
.28892 .51051 L
.29858 .50869 L
.30827 .50632 L
.31734 .50362 L
.33798 .49588 L
.3768 .47613 L
.41808 .44928 L
Mistroke
.45784 .4193 L
.49609 .38785 L
.53678 .35258 L
.57596 .3176 L
.6176 .27994 L
.65772 .24358 L
.69632 .20884 L
.73738 .17234 L
.77692 .13777 L
.81494 .10516 L
.85542 .07119 L
.89438 .03924 L
.93579 .0061 L
Mfstroke
.93579 .0061 m
.94361 0 L
s
.5 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35596 L
.06244 .37211 L
.10458 .41649 L
.14393 .45501 L
.16369 .47073 L
.18177 .48252 L
.20117 .4923 L
.21188 .49641 L
.22205 .49949 L
.23164 .50165 L
.237 .50255 L
.24186 .50319 L
.24641 .50362 L
.24897 .50381 L
.25019 .50387 L
.25133 .50393 L
.25241 .50397 L
.25339 .50401 L
.25449 .50403 L
.25566 .50406 L
.25679 .50407 L
.25802 .50407 L
.25917 .50406 L
.26025 .50405 L
.26142 .50402 L
.26266 .50398 L
.26488 .50389 L
.26726 .50375 L
.26987 .50356 L
.27455 .5031 L
.27891 .50254 L
.28887 .50082 L
.29951 .49832 L
.32086 .49138 L
.34101 .48268 L
.37948 .4612 L
.4204 .43272 L
.4598 .40127 L
.49769 .36841 L
.53803 .33152 L
.57685 .29487 L
.61813 .25526 L
Mistroke
.65789 .21692 L
.69613 .18015 L
.73683 .14138 L
.77601 .10454 L
.81765 .06607 L
.85776 .02972 L
Mfstroke
.85776 .02972 m
.89125 0 L
s
.6 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35595 L
.06244 .37206 L
.10458 .41597 L
.14393 .45357 L
.16369 .46871 L
.18177 .47993 L
.20117 .48909 L
.21188 .49285 L
.22205 .4956 L
.23164 .49747 L
.237 .49821 L
.23953 .49848 L
.24186 .4987 L
.24403 .49886 L
.24641 .499 L
.24756 .49905 L
.2488 .4991 L
.25011 .49913 L
.25133 .49916 L
.25247 .49917 L
.25372 .49917 L
.2549 .49917 L
.25599 .49915 L
.25697 .49913 L
.25805 .4991 L
.26025 .49902 L
.26259 .49889 L
.26516 .4987 L
.27034 .4982 L
.27513 .49758 L
.27959 .49688 L
.28968 .49482 L
.30045 .49196 L
.3218 .48438 L
.34195 .47512 L
.38041 .4526 L
.42133 .42302 L
.46074 .39045 L
.49862 .35641 L
.53896 .31814 L
.57779 .28003 L
.61906 .23873 L
Mistroke
.65882 .19863 L
.69707 .16006 L
.73777 .11928 L
.77695 .08044 L
.81858 .03977 L
.8587 .00125 L
Mfstroke
.8587 .00125 m
.86003 0 L
s
.7 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35595 L
.06244 .37202 L
.10458 .4156 L
.14393 .45258 L
.16369 .46732 L
.18177 .47816 L
.20117 .48691 L
.21188 .49045 L
.21721 .49188 L
.22205 .49298 L
.22666 .49387 L
.23164 .49465 L
.23438 .495 L
.2369 .49528 L
.23947 .49551 L
.24186 .49568 L
.24392 .49579 L
.24497 .49584 L
.24612 .49588 L
.24738 .49592 L
.24857 .49594 L
.24973 .49595 L
.2508 .49596 L
.25192 .49595 L
.25298 .49594 L
.25413 .49592 L
.25538 .49588 L
.25662 .49584 L
.25792 .49578 L
.26025 .49565 L
.26282 .49546 L
.26525 .49524 L
.26979 .49472 L
.27999 .49308 L
.2888 .49115 L
.29835 .48853 L
.31823 .48145 L
.33927 .47176 L
.37716 .44943 L
.4175 .42003 L
.45632 .38756 L
.4976 .34976 L
Mistroke
.53736 .3111 L
.57561 .27252 L
.6163 .23055 L
.65549 .18968 L
.69712 .14614 L
.73724 .10434 L
.77584 .06445 L
.8169 .02254 L
Mfstroke
.8169 .02254 m
.83931 0 L
s
.8 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35595 L
.06244 .37199 L
.10458 .41533 L
.14393 .45185 L
.16369 .46631 L
.18177 .47688 L
.20117 .48533 L
.21188 .48871 L
.21721 .49006 L
.22205 .4911 L
.22666 .49192 L
.23164 .49263 L
.23438 .49294 L
.2369 .49318 L
.23947 .49337 L
.24186 .49351 L
.24392 .4936 L
.24507 .49363 L
.24612 .49366 L
.24727 .49367 L
.24852 .49368 L
.24971 .49368 L
.2508 .49367 L
.25192 .49365 L
.25298 .49362 L
.25413 .49358 L
.25538 .49353 L
.25792 .49339 L
.26025 .49323 L
.26499 .49279 L
.27005 .49215 L
.27917 .49058 L
.29002 .48806 L
.29987 .48516 L
.31906 .47799 L
.33985 .46811 L
.38077 .44318 L
.42017 .41358 L
.45806 .38116 L
.4984 .34345 L
.53723 .30492 L
.5785 .26231 L
Mistroke
.61826 .22025 L
.65651 .17928 L
.69721 .13548 L
.73639 .09337 L
.77802 .04893 L
.81814 .00655 L
Mfstroke
.81814 .00655 m
.82442 0 L
s
.9 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35595 L
.06244 .37197 L
.10458 .41513 L
.14393 .45129 L
.16369 .46554 L
.18177 .47591 L
.20117 .48414 L
.21188 .4874 L
.21721 .48869 L
.22205 .48967 L
.22666 .49044 L
.23164 .4911 L
.23438 .49138 L
.2369 .49159 L
.23931 .49175 L
.24064 .49182 L
.24186 .49188 L
.24291 .49191 L
.24405 .49194 L
.24525 .49197 L
.24639 .49198 L
.24746 .49198 L
.24859 .49198 L
.24956 .49197 L
.25062 .49195 L
.25187 .49191 L
.25301 .49187 L
.25559 .49175 L
.25786 .49161 L
.26025 .49141 L
.26525 .49089 L
.26979 .49028 L
.27999 .48841 L
.28944 .48612 L
.29835 .48347 L
.31837 .47593 L
.33682 .46717 L
.37622 .44343 L
.41411 .41524 L
.45445 .38074 L
.49328 .34423 L
.53455 .30282 L
Mistroke
.57431 .26117 L
.61256 .22002 L
.65326 .17553 L
.69244 .13238 L
.73407 .08649 L
.77419 .04248 L
.81279 .00047 L
Mfstroke
.81279 .00047 m
.81323 0 L
s
1 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35594 L
.06244 .37195 L
.10458 .41496 L
.1249 .43463 L
.14393 .45086 L
.16333 .46471 L
.18177 .47515 L
.19145 .47954 L
.20201 .48348 L
.21162 .4863 L
.22054 .48828 L
.22561 .48914 L
.22828 .48951 L
.2311 .48985 L
.23358 .4901 L
.23629 .49032 L
.23876 .49047 L
.24106 .49057 L
.24222 .49061 L
.24347 .49064 L
.24466 .49066 L
.24576 .49067 L
.24674 .49067 L
.24783 .49066 L
.24897 .49064 L
.25004 .49062 L
.25122 .49058 L
.25246 .49054 L
.25467 .49043 L
.25706 .49027 L
.25967 .49005 L
.26495 .48948 L
.26994 .48876 L
.27928 .48701 L
.28933 .48452 L
.30023 .48116 L
.3201 .47335 L
.34115 .46292 L
.37903 .43927 L
.41937 .40842 L
.4582 .37444 L
.49947 .3348 L
Mistroke
.53924 .29411 L
.57748 .25333 L
.61818 .20873 L
.65736 .16508 L
.69899 .11832 L
.73911 .07319 L
.77772 .02991 L
Mfstroke
.77772 .02991 m
.80459 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{240, 157.125},
  ImageMargins->{{47.1875, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003`0000WA000`40O003h00Ol7oo003`Ool00?1o
o`00l7oo003`Ool001Aoo`03001oogoo0:1oo`05O4U`BGooOomTB@02Ool01EA9OomoogooB4T01Woo
00<lBGooOol027oo00<`BGooOol06Goo0002Ool20004Ool20005Ool00`00Oomoo`02Ool00`00Oomo
o`2OOol00ga9L4Uoo`02I4T2Ool01EA9OomoogooB4T01Woo00<lBGooOol01goo0S1977oo00001Goo
001oogoo00002Woo00<007ooOol00Woo00<007ooOol0WWoo00AlBG19OomTB@9oo`9DB@=oo`03B4Uo
ogoo00Aoo`03?4Uoogoo00Moo`03<4Uoogoo01aoo`0000Eoo`00Oomoo`0000Yoo`03001oogoo009o
o`8009ioo`04O4U`BGooI4T2Ool00eA9Oomoo`02Ool00dQ9Oomoo`03Ool2?4T8Ool2<4TOOol00005
Ool007ooOol0000;Ool01@00Oomoogoo0000WWoo00AlBG19OomTB@9oo`03E4Uoogoo009oo`03B4Uo
ogoo00=oo`03?4Uoogoo00Moo`03<4Uoogoo01moo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0003
Ool00`00Oomoo`2KOol017a9Oom`BFA90Woo00=DBGooOol00Woo00=8BGooOol00goo00<lBGooOol0
1goo00<`BGooOol087oo0002Ool20009Ool40003Ool00`00Oomoo`2JOol01ga9Oom`BGooI4UooeA9
00Aoo`03B4Uoogoo00=oo`03?4Uoogoo00Ioo`8`BB=oo`0057oo0P00VWoo00MlBGooL4UoofA9OomD
B@04Ool00dQ9Oomoo`03Ool00ca9Oomoo`06Ool00c19Oomoo`0SOol001Aoo`03001oogoo09Qoo`07
O4Uoog19OomTBGooE4T017oo00=8BGooOol00Woo0Sa927oo00<`BGooOol097oo000DOol00`00Oomo
o`2GOol01Ga9Oom`BGooI4T00Woo00EDBGooOomoodQ900Aoo`03?4Uoogoo00Moo`03<4Uoogoo02Eo
o`0057oo00<007ooOol0UWoo00ElBGooL4UoofA9009oo`05E4UoogooOom8B@04Ool00ca9Oomoo`07
Ool00c19Oomoo`0@Ool00bA9Oomoo`0COol001Aoo`03001oogoo09Ioo`04O4U`BGooI4T2Ool01EA9
OomoogooB4T00goo0Sa92Goo00<`BGooOol03goo0RA95Woo000DOol2002FOol017a9L4UoofA90Woo
00=DBGooOol00TQ90goo00<lBGooOol01goo0S194Goo00<TBGooOol05Woo000DOol00`00Oomoo`2D
Ool017a9L4UoofA90Woo00ADBGooOom8B@Aoo`03?4Uoogoo00Moo`03<4Uoogoo011oo`0394Uoogoo
01Moo`0057oo00<007ooOol0Tgoo00AlBGooL4UTB@9oo`04E4UoogooB4T4Ool00ca9Oomoo`07Ool0
0c19Oomoo`0?Ool294TJOol001Aoo`03001oogoo099oo`04O4Uoog19I4T2Ool015A9OomoodQ917oo
00<lBGooOol01goo00<`BGooOol03goo00<TBGooOol06Woo000DOol00`00Oomoo`2AOol017a9Oom`
BFA90Woo00ADBGooOom8B@Aoo`03?4Uoogoo00Moo`03<4Uoogoo00moo`0394Uoogoo01]oo`0057oo
0P00TGoo00AlBGooL4UTB@9oo`04E4UoogooB4T4Ool00ca9Oomoo`07Ool00c19Oomoo`0>Ool294TN
Ool001Aoo`03001oogoo08moo`04O4Uoog19I4T2Ool015A9OomoodQ917oo00<lBGooOol01goo00<`
BGooOol03Woo00<TBGooOol07Woo000DOol00`00Oomoo`2>Ool017a9Oom`BFA90Woo00ADBGooOom8
B@Aoo`03?4Uoogoo00Ioo`8`BA1oo`0394Uoogoo01moo`0057oo00<007ooOol0SWoo00=lBG19I4T0
0Woo00ADBGooOom8B@Aoo`03?4Uoogoo00Ioo`03<4Uoogoo00ioo`8TBB9oo`0057oo0P00SWoo00=l
BG19I4T00Woo00EDBGooOomoodQ900=oo`03?4Uoogoo00Ioo`03<4Uoogoo00ioo`0394Uoogoo029o
o`0057oo00<007ooOol0S7oo00=lBG19I4T00Woo00EDBGooOomoodQ900=oo`03?4Uoogoo00Ioo`03
<4Uoogoo00ioo`0394Uoogoo02=oo`0057oo00<007ooOol0Rgoo00=lBG19I4T00Woo00EDBGooOomo
odQ900=oo`03?4Uoogoo00Ioo`03<4Uoogoo00eoo`8TBBIoo`000Woo0P0017oo0P0017oo0P0017oo
00<007ooOol0RWoo00IlBG19OomTBGooE4T3Ool01DQ9Oomoogoo?4T01goo0S193goo00<TBGooOol0
9Woo00001Goo001oogoo000027oo00@007ooOol000=oo`03001oogoo08Uoo`06O4U`BGooI4UooeA9
0goo00E8BGooOomooca900Moo`03<4Uoogoo00eoo`8TBBUoo`0000Eoo`00Oomoo`0000Qoo`04001o
ogoo0003Ool20029Ool01Wa9L4UoofA9OomDB@=oo`05B4UoogooOollB@07Ool00c19Oomoo`0<Ool2
94T[Ool00005Ool007ooOol00009Ool20004Ool00`00Oomoo`27Ool01Wa9L4UoofA9OomDB@=oo`05
B4UoogooOollB@06Ool2<4T>Ool00bA9Oomoo`0[Ool00005Ool007ooOol00008Ool01000Oomoo`00
0goo00<007ooOol0QWoo00IlBG19OomTBGooE4T3Ool01DQ9Oomoogoo?4T01Woo00<`BGooOol03Goo
00<TBGooOol0;7oo0002Ool2000:Ool20004Ool00`00Oomoo`25Ool01Wa9L4UoofA9OomDB@9oo`98
B@=oo`03?4Uoogoo00Aoo`03<4Uoogoo00eoo`0394Uoogoo02eoo`0057oo00<007ooOol0QGoo00El
BGooI4UooeA9009oo`03B4Uoogoo009oo`03?4Uoogoo00Aoo`03<4Uoogoo00eoo`0394Uoogoo02io
o`0057oo0P00QGoo00ElBGooI4UooeA9009oo`03B4Uoogoo009oo`03?4Uoogoo00Aoo`03<4Uoogoo
00aoo`8TBC5oo`0057oo00<007ooOol0Pgoo00ElBG19I4UooeA9009oo`03B4Uoogoo009oo`03?4Uo
ogoo00Aoo`03<4Uoogoo00aoo`0394Uoogoo035oo`0057oo00<007ooOol0PWoo00ElBG19OomTBEA9
009oo`04B4UoogooOol2?4T6Ool00c19Oomoo`0<Ool00bA9Oomoo`0bOol001Aoo`03001oogoo085o
o`05O4U`BGooI4UDB@02Ool01DQ9Oomoogoo?4T01goo00<`BGooOol037oo00<TBGooOol0<goo000D
Ool20021Ool027a9L4UoofA9OomDBGooB4T3Ool00ca9Oomoo`05Ool00c19Oomoo`0<Ool00bA9Oomo
o`0dOol001Aoo`03001oogoo07moo`08O4U`BGooI4UooeA9Oom8B@=oo`03?4Uoogoo00Eoo`03<4Uo
ogoo00]oo`8TBCMoo`0057oo00<007ooOol0OWoo00QlBG19OomTBGooE4UoodQ90goo00<lBGooOol0
1Goo00<`BGooOol02goo00<TBGooOol0=goo000DOol00`00Oomoo`1mOol027a9L4UoofA9OomDBGoo
B4T3Ool00ca9Oomoo`04Ool2<4T=Ool00bA9Oomoo`0hOol001Aoo`03001oogoo07eoo`07O4UoofA9
OomDBGooB4T00goo00<lBGooOol017oo00<`BGooOol02goo0RA9>goo000DOol2001mOol01ga9OomT
BGooE4UoodQ900=oo`03?4Uoogoo00Aoo`03<4Uoogoo00]oo`0394Uoogoo03]oo`0057oo00<007oo
Ool0Ngoo00MlBG19I4UooeA9Oom8B@03Ool00ca9Oomoo`03Ool2<4T=Ool00bA9Oomoo`0lOol001Ao
o`03001oogoo07Yoo`07O4U`BGooI4UDBGooB4T00goo00<lBGooOol00goo00<`BGooOol02goo0RA9
?goo000DOol00`00Oomoo`1iOol01ga9L4UoofA9E4UoodQ900=oo`03?4Uoogoo00=oo`03<4Uoogoo
00]oo`0394Uoogoo03moo`0057oo00<007ooOol0N7oo00MlBG19OomTBEA9Oom8B@03Ool00ca9Oomo
o`03Ool00c19Oomoo`0;Ool00bA9Oomoo`10Ool001Aoo`8007Qoo`07O4U`BGooI4UDBGooB4T00goo
00<lBGooOol00goo00<`BGooOol02Woo0RA9@goo000DOol00`00Oomoo`1fOol01ga9L4UoofA9E4Uo
odQ900=oo`03?4Uoogoo00=oo`03<4Uoogoo00Yoo`0394Uoogoo04=oo`000Woo0P0017oo0P000goo
0`0017oo00<007ooOol0MGoo00MlBG19OomTBEA9Oom8B@03Ool00ca9Oomoo`02Ool2<4T<Ool00bA9
Oomoo`14Ool00005Ool007ooOol0000:Ool00`00Oomoo`02Ool00`00Oomoo`1dOol01ga9L4UoofA9
E4UoodQ900=oo`03?4Uoogoo009oo`03<4Uoogoo00Yoo`8TBDMoo`0000Eoo`00Oomoo`0000Uoo`<0
00=oo`8007Aoo`07O4U`BGooI4UDBGooB4T00goo00<lBGooOol00Woo00<`BGooOol02Woo00<TBGoo
Ool0Agoo00001Goo001oogoo000027oo00@007ooOol000=oo`03001oogoo079oo`07O4Uoog19I4UD
BGooB4T00goo00<lBGooOol00Woo00<`BGooOol02Woo00<TBGooOol0<Woo00<DBGooOol04goo0000
1Goo001oogoo000027oo00@007ooOol000=oo`03001oogoo075oo`07O4Uoog19I4UDBGooB4T00goo
00<lBGooOol00Woo00<`BGooOol02Goo0RA9<goo0QA95Woo0002Ool2000:Ool30003Ool00`00Oomo
o`1`Ool01ga9Oom`BFA9E4UoodQ900=oo`03?4Uoogoo009oo`03<4Uoogoo00Uoo`0394Uoogoo035o
o`8DBAQoo`0057oo00<007ooOol0Kgoo00MlBGooL4UTBEA9Oom8B@03Ool00ca9Oomoo`02Ool00c19
Oomoo`09Ool00bA9Oomoo`0`Ool254TJOol001Aoo`8006moo`07O4Uoog19I4UDBGooB4T00goo00<l
BGooOol00Woo00<`BGooOol02Goo00<TBGooOol0<7oo00<DBGooOol06Woo000DOol00`00Oomoo`1]
Ool01ga9Oom`BFA9E4UoodQ900=oo`03?4Uoogoo009oo`03<4Uoogoo00Uoo`0394Uoogoo02moo`8D
BAeoo`0057oo00<007ooOol0K7oo00MlBGooL4UTBEA9Oom8B@03Ool00ca9Oomoo`02Ool00c19Oomo
o`09Ool00bA9Oomoo`0_Ool00aA9Oomoo`0MOol001Aoo`03001oogoo06aoo`06O4U`BFA9E4UoodQ9
0Woo0Sa917oo00<`BGooOol027oo0RA9<7oo0QA987oo000DOol2001/Ool01Wa9L4UTBEA9Oom8B@9o
o`03?4Uoogoo00=oo`03<4Uoogoo00Qoo`0394Uoogoo02ioo`8DBB9oo`0057oo00<007ooOol0JWoo
00IlBG19I4UDBGooB4T2Ool00ca9Oomoo`03Ool00c19Oomoo`08Ool00bA9Oomoo`0^Ool00aA9Oomo
o`0ROol001Aoo`03001oogoo06Uoo`06O4U`BFA9E4UoodQ90Woo00<lBGooOol00goo00<`BGooOol0
27oo00<TBGooOol0;Goo0QA99Goo000DOol00`00Oomoo`1XOol01Wa9L4UTBEA9Oom8B@9oo`03?4Uo
ogoo00=oo`03<4Uoogoo00Qoo`0394Uoogoo02eoo`0354Uoogoo02Eoo`0057oo00<007ooOol08goo
100097oo0P006Woo00IlBG19I4UDBGooB4T2Ool00ca9Oomoo`02Ool2<4T00`00Oomoo`07Ool00bA9
Oomoo`0HOol2000BOol254T@Ool3000EOol001Aoo`8002Aoo`03001oogoo02Aoo`04001oogoo000H
Ool01Wa9L4UTBEA9Oom8B@9oo`03?4Uoogoo009oo`03<4Uoo`0000Uoo`0394Uoogoo01Qoo`04001o
ogoo000?Ool254TBOol01000Oomoo`0057oo000DOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00
Oomoo`0FOol01Wa9L4UTBEA9Oom8B@9oo`03?4Uoogoo009oo`03<4T00000008000Ioo`8TBAioo`03
001oogoo00aoo`0354Uoogoo019oo`04001oogoo000DOol001Aoo`03001oogoo02Eoo`03001oogoo
02Eoo`03001oogoo01Aoo`06O4U`BFA9E4UoodQ90Woo00<lBGooOol00Woo00D`B@00Oomoo`0000Io
o`0394Uoogoo01aoo`8000eoo`8DBAEoo`<001Eoo`0057oo00<007ooOol08goo00@007ooOol002=o
o`04001oogoo000EOol01Wa9L4UTBEA9Oom8B@9oo`03?4Uoogoo009oo`06<4Uoogoo001oo`001Goo
00<TBGooOol07Goo00<007ooOol02goo00<DBGooOol05Woo00<007ooOol057oo000DOol00`00Oomo
o`0TOol2000UOol2000EOol01Wa9L4UTBEA9Oom8B@9oo`03?4Uoogoo009oo`03<4Uoogoo009oo`80
00Aoo`0394Uoogoo01ioo`<000Uoo`8DBAUoo`<001Aoo`0057oo0P00HWoo00IlBG19I4UDBGooB4T2
Ool00ca9Oomoo`02Ool00c19Oomoo`08Ool00bA9Oomoo`0YOol254TbOol001Aoo`03001oogoo061o
o`06O4U`BFA9E4UoodQ90Woo00<lBGooOol00Woo00<`BGooOol01goo0RA9:goo00<DBGooOol0:Woo
0`001Goo000DOol00`00Oomoo`1OOol01Wa9L4UTBEA9Oom8B@9oo`04?4UoogooOol2<4T9Ool00bA9
Oomoo`0YOol254T/Ool01@00Oomoogoo000017oo000DOol00`00Oomoo`1NOol01Wa9L4UTBEA9Oom8
B@9oo`05?4UoogooOol`B@0:Ool00bA9Oomoo`0YOol00aA9Oomoo`0]Ool30005Ool000moo`D0009l
BEh00006O4U`BFA9E4T004Q90P0000DlB@000000031900T0008TBBX0008DBBP000Qoo`03001oogoo
00Eoo`0057oo00@007a9O4UlB@Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`07O4U`BFA9E4UoodQ9Ool00Sa90goo00D`
BGooOomoo`0000Eoo`0394Uoo`0000Moo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001ooaA900Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00]oo`03001oogoo00Eoo`0057oo00D007ooOomooga902=oo`03
001oogoo02Aoo`03001oogoo00eoo`07O4UTBEA9Oom8BGoo?4T017oo00<`BGooOol01goo00@TBGoo
Ool002Moo`8DBBEoo`03001oogoo00]oo`03001oogoo00Eoo`0057oo00<007ooOol00Woo00=lBC19
Ool0EWoo00MlBFA9E4UoodQ9OollB@03Ool2<4T9Ool00bA9Oomoo`0XOol00aA9Oomoo`0dOol40003
Ool001Aoo`03001oogoo00=oo`9lBEEoo`07O4UDBEA9Oom8BGoo?4T00goo00<`BGooOol01goo0RA9
:Goo0QA9?Woo000DOol20006Ool00ga9Oomoo`1AOol01ga9E4UoogooB4Uooca900=oo`03<4Uoogoo
00Moo`0394Uoogoo02Qoo`0354Uoogoo03ioo`0057oo00<007ooOol01Woo00=lBGooOol0Cgoo00=l
BEA9Ool00TQ900Aooca9Oomoo`8`B@Uoo`0394Uoogoo02Moo`8DBD5oo`0057oo00<007ooOol01goo
00=lBGooOol0CGoo00AlBEA9Oom8B@9oo`04?4Uoogoo<4T9Ool294TXOol254U3Ool001Aoo`03001o
ogoo00Qoo`03O4Uoogoo04Yoo`9lB@04E4UoodQ9Ool2?4T2Ool00c19Oomoo`07Ool00bA9Oomoo`0W
Ool00aA9Oomoo`13Ool001Aoo`03001oogoo00Uoo`03O4Uoogoo04Qoo`07O4U`BEA9Oom8BGoo?4T0
0goo00<`BGooOol01goo00<TBGooOol09goo00<DBGooOol0A7oo000DOol2000;Ool00ga9Oomoo`16
Ool01ga9I4UDBGooB4Uooca900=oo`03<4Uoogoo00Ioo`8TBBQoo`8DBDMoo`0057oo00<007ooOol0
2Woo00<`BGa9Ool0A7oo0Wa900ITBEA9Oom8BGoo?4T3Ool00c19Oomoo`06Ool00bA9Oomoo`0WOol0
0aA9Oomoo`17Ool001Aoo`03001oogoo00]oo`03<4UlBGoo049oo`08O4U`BFA9E4UoodQ9OollB@9o
o`8`B@Qoo`0394Uoogoo02Moo`0354Uoogoo04Qoo`0057oo00<007ooOol037oo00<`BGa9Ool0@7oo
00AlBGooI4Uoo`98B@05OollBGooOol`B@08Ool294TXOol254U;Ool001Aoo`8000ioo`03<4UlBGoo
03ioo`05O4UoofA9Oom8B@02Ool013a9Oomooc1927oo00<TBGooOol09goo00<DBGooOol0Bgoo000D
Ool00`00Oomoo`0>Ool00c19O4Uoo`0kOol2O4T2I4T00gooB4Uoo`02?4T2Ool00c19Oomoo`06Ool0
0bA9Oomoo`0VOol254U>Ool001Aoo`03001oogoo00moo`03<4UlBGoo03Uoo`08O4U`BFA9E4UoodQ9
OollB@=oo`03<4Uoogoo00Ioo`0394Uoogoo02Ioo`0354Uoogoo04ioo`0057oo00<007ooOol047oo
00<`BGa9Ool0=goo00AlBFA9I4UDB@98B@04OollBGooOol2<4T7Ool294TWOol254UAOol001Aoo`03
001oogoo011oo`0354T`BGa903Eoo`9lB@04I4UDBGooB4T2Ool013a9Oomooc1927oo00<TBGooOol0
9Goo0QA9Dgoo000DOol2000BOol00aA9<4UlB@0cOol017a9L4UTBEA90TQ900=ooca9?4T00Woo00<`
BGooOol01Woo00<TBGooOol09Goo00<DBGooOol0Dgoo000DOol00`00Oomoo`0BOol00aA9<4UlB@0`
Ool2O4T016A9E4UDBDQ90Woo00<lBGooOol00S191goo0RA99Woo0QA9EWoo000DOol00`00Oomoo`0C
Ool00aA9<4UlB@0^Ool017a9L4UTBEA90TQ900=ooca9?4T00Woo00<`BGooOol01Woo00<TBGooOol0
9Goo00<DBGooOol0EWoo00000goo000000030002Ool20003Ool50002Ool00`00Oomoo`0DOol00aA9
<4UlB@0[Ool2O4T016A9E4UDBDQ90Woo00DlBGooOomooc1900Qoo`0394Uoogoo02Aoo`8DBEUoo`00
0goo00<007ooOol02Goo00<007ooOol00Woo00<007ooOol057oo00<DBGoo<4T00Wa99goo0Wa900=`
BFA9E4T00TQ900=ooca9?4T00Woo0S191goo0RA99Woo00<DBGooOol0FGoo0003Ool00`00Oomoo`09
Ool00`00Oomoo`02Ool2000FOol011A9Ool`BG190Wa997oo00=lBG19I4T00UA900A8BGooOollB@=o
o`03<4Uoogoo00Ioo`0394Uoogoo02Aoo`8DBEaoo`000goo00<007ooOol02Goo00<007ooOol00Woo
00<007ooOol05Woo00HDBGoo<4TlBG19O4TQOol2O4T00fA9E4UDB@02B4T00goo?4TlB@03Ool00c19
Oomoo`06Ool00bA9Oomoo`0TOol00aA9Oomoo`1LOol000=oo`03001oogoo00Uoo`03001oogoo009o
o`03001oogoo01Moo`0554TTBGoo?4U`B@02O4TMOol2O4T00g19I4UDB@02B4T00goo?4TlB@03Ool2
<4T7Ool294TVOol00aA9Oomoo`1MOol0009oo`8000Yoo`8000Aoo`03001oogoo01Qoo`0854TTBGoo
?4U8BG19O4U`BAUoo`9lB@06L4UTBEA9Oom8BGoo0Sa90goo0S1927oo00<TBGooOol097oo0QA9H7oo
000DOol2000IOol01aA9OolTBGoo<4TlBDQ900AlBA=oo`=lB@9TB@04E4UoodQ9B4T2?4T3Ool2<4T8
Ool294TVOol00aA9Oomoo`1POol001Aoo`03001oogoo01Uoo`0354UoobA9009oo`03<4TlBDQ9009T
B@AlB@Uoo`IlB@=TB@04Oom8BDQ9B4T2?4T3Ool2<4T8Ool294TWOol00aA9Oomoo`1QOol001Aoo`03
001oogoo01Yoo`0554UoobA994Uoo`02<4T2?4T2E4T00fA9L4UlB@08O4T2L4T2I4T2E4T4B4T3?4T3
Ool2<4T8Ool294TWOol254UTOol001Aoo`03001oogoo01]oo`0454Uoogoo94T2Ool2<4T2?4T3B4T:
E4T4B4T3?4T5Ool2<4T8Ool294TXOol00aA9Oomoo`1TOol001Aoo`03001oogoo01aoo`0454Uoogoo
94T3Ool2<4T6?4T5B4T00goo?4TlB@03?4T6Ool2<4T9Ool00bA9Oomoo`0VOol254UWOol001Aoo`80
01eoo`0454UoogooOol294T3Ool2<4T4Ool6?4T7Ool4<4T9Ool294TWOol254UYOol001Aoo`03001o
ogoo01eoo`0354Uoogoo009oo`0394Uoogoo009ooa4`B@]oo`8TBBMoo`8DBF]oo`0057oo00<007oo
Ool07Woo00<DBGooOol00Woo0RA977oo0RA99goo0QA9KGoo000DOol00`00Oomoo`0OOol00aA9Oomo
o`03Ool494TEOol394TXOol00aA9Oomoo`1]Ool001Aoo`03001oogoo021oo`0354Uoogoo00Ioo`@T
B@ioo`<TBBUoo`8DBG1oo`0057oo0P008Woo00<DBGooOol02Goo3RA9:goo00<DBGooOol0L7oo000D
Ool00`00Oomoo`0ROol00aA9Oomoo`0oOol254UcOol001Aoo`03001oogoo02=oo`0354Uoogoo03ao
o`8DBGEoo`0057oo00<007ooOol097oo00<DBGooOol0>Woo00<DBGooOol0MGoo000DOol2000VOol0
0aA9Oomoo`0gOol254UhOol001Aoo`03001oogoo02Ioo`0354Uoogoo03Eoo`0354Uoogoo07Qoo`00
57oo00<007ooOol09goo00<DBGooOol0<Woo0QA9Ngoo00000goo000000030002Ool20003Ool40003
Ool00`00Oomoo`0XOol254T`Ool254UmOol000=oo`03001oogoo00Moo`03001oogoo00Aoo`03001o
ogoo02Yoo`0354Uoogoo02]oo`8DBGmoo`000goo00<007ooOol027oo00<007ooOol00goo0P00;7oo
0QA9:Goo0QA9PGoo0003Ool00`00Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`0]Ool254TUOol2
54V3Ool000=oo`03001oogoo00Moo`04001oogoo0003Ool00`00Oomoo`0_Ool00aA9Oomoo`0POol2
54V5Ool0009oo`8000Yoo`8000Aoo`03001oogoo031oo`8DBAeoo`<DBHMoo`0057oo0P00<goo0QA9
5goo11A9RWoo000DOol00`00Oomoo`0dOol454T@Ool354V>Ool001Aoo`03001oogoo03Qooa0DBI5o
o`0057oo00<007ooOol0fGoo000DOol00`00Oomoo`3IOol001Aoo`800=Yoo`00l7oo003`Ool00?1o
o`00l7oo003`Ool00?1oo`00l7oo003`Ool00?1oo`005Woo0P00f7oo000@Ool30004Ool00`00Oomo
o`3FOol0015oo`03001oogoo00=oo`03001oogoo0=Ioo`004Goo00<007ooOol00Woo0P00f7oo000A
Ool2003MOol0015oo`04001oogoo003KOol0011oo`D00=]oo`00l7oo003`Ool00?1oo`00l7oo003`
Ool00?1oo`00l7oo0000\
\>"],
  ImageRangeCache->{{{0, 239}, {156.125, 0}} -> {0.48035, 0.667808, \
0.0252224, 0.00431243}}]
}, Open  ]],

Cell[TextData[
"If we, on the other hand, fix the value of \[Kappa] and vary \[Gamma], we \
can examine the influence of \[Gamma] on the solution"], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"neq", " ", "=", " ", 
        RowBox[{
          RowBox[{"Join", "[", 
            RowBox[{\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\), ",", 
              RowBox[{"{", 
                RowBox[{\(F1[1] == 1\), ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[Prime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    "0"}], ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[DoublePrime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(3/2\)}], ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", 
                        TagBox[\((3)\),
                          Derivative],
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(-10\)}]}], "}"}]}], "]"}], "/.", 
          \({\[Kappa] \[Rule] 1}\)}]}], ";"}]], "Input"],

Cell[BoxData[
    \(\(nsol\  = \ 
      Table[NDSolve[neq /. \[Gamma] \[Rule] i, F1, {zeta1, 1, 15}], {i, 1, 5, 
          1}]; \)\)], "Input"],

Cell["The resulting solutions are shown in the following plot:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[F1[\[Zeta]] /. nsol], {\[Zeta], 1, 6}, 
      PlotStyle \[Rule] color, 
      AxesLabel \[Rule] {"\<\[Zeta]\>", \*"\"\<\!\(F\_1\)\>\""}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.190476 -0.849122 1.18268 [
[.21429 .32106 -3 -9 ]
[.21429 .32106 3 0 ]
[.40476 .32106 -3 -9 ]
[.40476 .32106 3 0 ]
[.59524 .32106 -3 -9 ]
[.59524 .32106 3 0 ]
[.78571 .32106 -3 -9 ]
[.78571 .32106 3 0 ]
[.97619 .32106 -3 -9 ]
[.97619 .32106 3 0 ]
[1.025 .33356 0 -7.5 ]
[1.025 .33356 10 7.5 ]
[.01131 .09703 -18 -4.5 ]
[.01131 .09703 0 4.5 ]
[.01131 .21529 -18 -4.5 ]
[.01131 .21529 0 4.5 ]
[.01131 .45183 -18 -4.5 ]
[.01131 .45183 0 4.5 ]
[.01131 .5701 -18 -4.5 ]
[.01131 .5701 0 4.5 ]
[.02381 .64303 -7.5 0 ]
[.02381 .64303 7.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.21429 .33356 m
.21429 .33981 L
s
[(2)] .21429 .32106 0 1 Mshowa
.40476 .33356 m
.40476 .33981 L
s
[(3)] .40476 .32106 0 1 Mshowa
.59524 .33356 m
.59524 .33981 L
s
[(4)] .59524 .32106 0 1 Mshowa
.78571 .33356 m
.78571 .33981 L
s
[(5)] .78571 .32106 0 1 Mshowa
.97619 .33356 m
.97619 .33981 L
s
[(6)] .97619 .32106 0 1 Mshowa
.125 Mabswid
.0619 .33356 m
.0619 .33731 L
s
.1 .33356 m
.1 .33731 L
s
.1381 .33356 m
.1381 .33731 L
s
.17619 .33356 m
.17619 .33731 L
s
.25238 .33356 m
.25238 .33731 L
s
.29048 .33356 m
.29048 .33731 L
s
.32857 .33356 m
.32857 .33731 L
s
.36667 .33356 m
.36667 .33731 L
s
.44286 .33356 m
.44286 .33731 L
s
.48095 .33356 m
.48095 .33731 L
s
.51905 .33356 m
.51905 .33731 L
s
.55714 .33356 m
.55714 .33731 L
s
.63333 .33356 m
.63333 .33731 L
s
.67143 .33356 m
.67143 .33731 L
s
.70952 .33356 m
.70952 .33731 L
s
.74762 .33356 m
.74762 .33731 L
s
.82381 .33356 m
.82381 .33731 L
s
.8619 .33356 m
.8619 .33731 L
s
.9 .33356 m
.9 .33731 L
s
.9381 .33356 m
.9381 .33731 L
s
.25 Mabswid
0 .33356 m
1 .33356 L
s
gsave
1.025 .33356 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .09703 m
.03006 .09703 L
s
[(0.8)] .01131 .09703 1 0 Mshowa
.02381 .21529 m
.03006 .21529 L
s
[(0.9)] .01131 .21529 1 0 Mshowa
.02381 .45183 m
.03006 .45183 L
s
[(1.1)] .01131 .45183 1 0 Mshowa
.02381 .5701 m
.03006 .5701 L
s
[(1.2)] .01131 .5701 1 0 Mshowa
.125 Mabswid
.02381 .12068 m
.02756 .12068 L
s
.02381 .14433 m
.02756 .14433 L
s
.02381 .16799 m
.02756 .16799 L
s
.02381 .19164 m
.02756 .19164 L
s
.02381 .23895 m
.02756 .23895 L
s
.02381 .2626 m
.02756 .2626 L
s
.02381 .28625 m
.02756 .28625 L
s
.02381 .30991 m
.02756 .30991 L
s
.02381 .35722 m
.02756 .35722 L
s
.02381 .38087 m
.02756 .38087 L
s
.02381 .40452 m
.02756 .40452 L
s
.02381 .42818 m
.02756 .42818 L
s
.02381 .47548 m
.02756 .47548 L
s
.02381 .49914 m
.02756 .49914 L
s
.02381 .52279 m
.02756 .52279 L
s
.02381 .54645 m
.02756 .54645 L
s
.02381 .07337 m
.02756 .07337 L
s
.02381 .04972 m
.02756 .04972 L
s
.02381 .02606 m
.02756 .02606 L
s
.02381 .00241 m
.02756 .00241 L
s
.02381 .59375 m
.02756 .59375 L
s
.02381 .61741 m
.02756 .61741 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -68.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 .1 .3 r
.5 Mabswid
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .3377 L
.04262 .34056 L
.06244 .35756 L
.10458 .40322 L
.1249 .4241 L
.14393 .44132 L
.16333 .45603 L
.18177 .46711 L
.19145 .47177 L
.20201 .47596 L
.21162 .47896 L
.22054 .48106 L
.22561 .48197 L
.22828 .48236 L
.2311 .48272 L
.23358 .48298 L
.23629 .48322 L
.23876 .48338 L
.24106 .48349 L
.24222 .48353 L
.24347 .48356 L
.24466 .48358 L
.24576 .48359 L
.24674 .48359 L
.24783 .48358 L
.24897 .48356 L
.25004 .48354 L
.25122 .4835 L
.25246 .48345 L
.25467 .48333 L
.25706 .48316 L
.25967 .48293 L
.26495 .48232 L
.26994 .48157 L
.27928 .4797 L
.28933 .47706 L
.30023 .47349 L
.3201 .4652 L
.34115 .45413 L
.37903 .42902 L
.41937 .39628 L
.4582 .36019 L
.49947 .31812 L
Mistroke
.53924 .27493 L
.57748 .23163 L
.61818 .18429 L
.65736 .13794 L
.69899 .0883 L
.73911 .04039 L
Mfstroke
.73911 .04039 m
.77305 0 L
s
.3 .1 .3 r
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .3377 L
.04262 .34058 L
.06244 .35773 L
.10458 .40484 L
.14393 .44573 L
.16369 .46242 L
.18177 .47494 L
.20117 .48533 L
.21188 .48969 L
.22205 .49295 L
.23164 .49525 L
.237 .49621 L
.24186 .49689 L
.24641 .49735 L
.24897 .49754 L
.25019 .49762 L
.25133 .49767 L
.25241 .49772 L
.25339 .49776 L
.25449 .49779 L
.25566 .49781 L
.25679 .49782 L
.25802 .49782 L
.25917 .49781 L
.26025 .4978 L
.26142 .49777 L
.26266 .49773 L
.26488 .49763 L
.26726 .49749 L
.26987 .49728 L
.27455 .49679 L
.27891 .4962 L
.28887 .49438 L
.29951 .49172 L
.32086 .48435 L
.34101 .47513 L
.37948 .45232 L
.4204 .4221 L
.4598 .38872 L
.49769 .35383 L
.53803 .31468 L
.57685 .27577 L
.61813 .23373 L
Mistroke
.65789 .19303 L
.69613 .154 L
.73683 .11284 L
.77601 .07374 L
.81765 .0329 L
Mfstroke
.81765 .0329 m
.85185 0 L
s
.4 .1 .3 r
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .33771 L
.04262 .34059 L
.05224 .34813 L
.06244 .35791 L
.10458 .40659 L
.14241 .44917 L
.16345 .46935 L
.1827 .48491 L
.20281 .49795 L
.22147 .50704 L
.23066 .51044 L
.24046 .5133 L
.24606 .51459 L
.25133 .51558 L
.25606 .51627 L
.25853 .51657 L
.26118 .51684 L
.26375 .51704 L
.2661 .51719 L
.26723 .51724 L
.26846 .51729 L
.26962 .51733 L
.27069 .51735 L
.27193 .51737 L
.27309 .51738 L
.27437 .51737 L
.27509 .51737 L
.27575 .51736 L
.277 .51733 L
.27771 .51731 L
.27837 .51728 L
.28112 .51716 L
.28387 .51698 L
.28646 .51676 L
.29131 .51623 L
.29653 .51548 L
.30219 .51447 L
.31165 .51233 L
.32206 .50936 L
.3431 .50151 L
.38344 .48062 L
.42227 .45486 L
.46355 .42319 L
Mistroke
.50331 .38991 L
.54155 .35633 L
.58225 .31968 L
.62143 .28406 L
.66307 .24629 L
.70318 .21027 L
.74179 .17613 L
.78284 .14052 L
.82238 .10699 L
.86041 .07547 L
.90088 .04275 L
.93984 .01206 L
Mfstroke
.93984 .01206 m
.95554 0 L
s
.5 .1 .3 r
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .33771 L
.04262 .34061 L
.05224 .34819 L
.06244 .35809 L
.10458 .40848 L
.14241 .4547 L
.1827 .49631 L
.20124 .51164 L
.22147 .52528 L
.23243 .53127 L
.24261 .53596 L
.25226 .53963 L
.2627 .54276 L
.2682 .54406 L
.27327 .54505 L
.27801 .5458 L
.28053 .54613 L
.28322 .54643 L
.28567 .54665 L
.2879 .54682 L
.29014 .54695 L
.29227 .54704 L
.29342 .54708 L
.29465 .54711 L
.29569 .54712 L
.29685 .54713 L
.29808 .54713 L
.29878 .54712 L
.29942 .54711 L
.30059 .54709 L
.30183 .54706 L
.30306 .54701 L
.3044 .54695 L
.30683 .54681 L
.31137 .54644 L
.31668 .54584 L
.32157 .54513 L
.33049 .54345 L
.33994 .54115 L
.35951 .53485 L
.37782 .52725 L
.41665 .50668 L
.45792 .47981 L
Mistroke
.49769 .45071 L
.53593 .42089 L
.57663 .38811 L
.61581 .35614 L
.65744 .32222 L
.69756 .28988 L
.73617 .25927 L
.77722 .22739 L
.81676 .19742 L
.85479 .16931 L
.89526 .14016 L
.93422 .11287 L
.97564 .08467 L
.97619 .0843 L
Mfstroke
.6 .1 .3 r
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .33772 L
.04262 .34062 L
.05224 .34825 L
.06244 .35827 L
.10458 .41053 L
.14241 .46111 L
.1827 .5106 L
.22147 .54995 L
.24118 .56607 L
.2627 .58039 L
.27267 .58584 L
.28329 .59082 L
.29325 .5947 L
.30241 .59762 L
.31269 .60016 L
.3181 .60119 L
.32382 .60206 L
.32879 .60262 L
.33118 .60283 L
.33343 .603 L
.33471 .60308 L
.3361 .60315 L
.33725 .6032 L
.33853 .60324 L
.3399 .60328 L
.34066 .6033 L
.34137 .60331 L
.34263 .60332 L
.34334 .60332 L
.34399 .60332 L
.34527 .60331 L
.34647 .60329 L
.34756 .60326 L
.34873 .60323 L
.35136 .60311 L
.35379 .60297 L
.35822 .60262 L
.36291 .60212 L
.37277 .60066 L
.38361 .59843 L
.40306 .59294 L
.42395 .58515 L
.46523 .56514 L
Mistroke
.50499 .54163 L
.54324 .5165 L
.58393 .48817 L
.62312 .46011 L
.66475 .43005 L
.70487 .40123 L
.74347 .37386 L
.78453 .3453 L
.82407 .31841 L
.86209 .29318 L
.90257 .26702 L
.94153 .24251 L
.97619 .22127 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{240, 148.5},
  ImageMargins->{{47.25, 0}, {0, 2.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003`0000U1000`40O003h00O5Goo0P00VGoo00<D
BGooOol03Goo00<TBGooOol04Woo00<`BGooOol067oo000EOol00`00Oomoo`2GOol00aA9Oomoo`0=
Ool00bA9Oomoo`0AOol2<4TKOol001Eoo`03001oogoo09Ioo`0354Uoogoo00eoo`0394Uoogoo015o
o`03<4Uoogoo01]oo`005Goo00<007ooOol0UGoo00<DBGooOol03Goo00<TBGooOol04Goo00<`BGoo
Ool077oo000EOol00`00Oomoo`2DOol00aA9Oomoo`0=Ool00bA9Oomoo`0AOol00c19Oomoo`0MOol0
01Eoo`8009Eoo`0354Uoogoo00aoo`0394Uoogoo015oo`03<4Uoogoo01ioo`005Goo00<007ooOol0
Tgoo00<DBGooOol037oo00<TBGooOol047oo0S198Goo000EOol00`00Oomoo`2BOol00aA9Oomoo`0<
Ool00bA9Oomoo`0@Ool00c19Oomoo`0QOol001Eoo`03001oogoo095oo`0354Uoogoo00aoo`0394Uo
ogoo011oo`03<4Uoogoo029oo`005Goo00<007ooOol0T7oo00<DBGooOol037oo00<TBGooOol047oo
00<`BGooOol08goo000EOol2002@Ool00aA9Oomoo`0<Ool00bA9Oomoo`0@Ool00c19Oomoo`0TOol0
01Eoo`03001oogoo08ioo`0354Uoogoo00]oo`8TBA9oo`03<4Uoogoo02Eoo`005Goo00<007ooOol0
SGoo00<DBGooOol02goo00<TBGooOol04Goo00<`BGooOol09Woo000EOol00`00Oomoo`2<Ool00aA9
Oomoo`0;Ool00bA9Oomoo`0@Ool2<4TYOol001Eoo`03001oogoo08aoo`0354Uoogoo00Yoo`0394Uo
ogoo011oo`03<4Uoogoo02Uoo`005Goo0P00S7oo00<DBGooOol02Woo00<TBGooOol047oo00<`BGoo
Ool0:Woo000EOol00`00Oomoo`2:Ool00aA9Oomoo`0:Ool00bA9Oomoo`0@Ool00c19Oomoo`0[Ool0
01Eoo`03001oogoo08Uoo`0354Uoogoo00Yoo`0394Uoogoo011oo`03<4Uoogoo01Eoo`03?4Uoogoo
01Aoo`000goo0P0017oo0P0017oo0P0017oo00<007ooOol0R7oo00<DBGooOol02Woo00<TBGooOol0
3goo0S195goo00<lBGooOol05Goo0002Ool01000Oomoo`0027oo00@007ooOol000=oo`03001oogoo
08Moo`0354Uoogoo00Yoo`0394Uoogoo00moo`03<4Uoogoo01Eoo`8lBAQoo`000Woo00@007ooOol0
00Qoo`04001oogoo0003Ool20027Ool00aA9Oomoo`0:Ool00bA9Oomoo`0?Ool00c19Oomoo`0EOol0
0ca9Oomoo`0HOol0009oo`04001oogoo0009Ool20004Ool00`00Oomoo`26Ool00aA9Oomoo`09Ool0
0bA9Oomoo`0>Ool2<4TGOol00ca9Oomoo`0IOol0009oo`04001oogoo0008Ool01000Oomoo`000goo
00<007ooOol0QGoo00<DBGooOol02Goo00<TBGooOol03Woo00<`BGooOol05Goo0Sa977oo0003Ool2
000:Ool20004Ool00`00Oomoo`24Ool00aA9Oomoo`09Ool00bA9Oomoo`0>Ool00c19Oomoo`0EOol0
0ca9Oomoo`0LOol001Eoo`03001oogoo08=oo`0354Uoogoo00Uoo`0394Uoogoo00ioo`03<4Uoogoo
01Eoo`03?4Uoogoo01eoo`005Goo0P00Pgoo00<DBGooOol02Goo00<TBGooOol03Woo00<`BGooOol0
57oo0Sa987oo000EOol00`00Oomoo`22Ool00aA9Oomoo`08Ool00bA9Oomoo`0=Ool2<4TFOol00ca9
Oomoo`0POol001Eoo`03001oogoo085oo`0354Uoogoo00Qoo`0394Uoogoo00eoo`03<4Uoogoo01Eo
o`03?4Uoogoo025oo`005Goo00<007ooOol0P7oo00<DBGooOol02Goo00<TBGooOol037oo00<`BGoo
Ool057oo0Sa997oo000EOol00`00Oomoo`1oOol00aA9Oomoo`09Ool00bA9Oomoo`0<Ool00c19Oomo
o`0DOol00ca9Oomoo`0TOol001Eoo`8007moo`0354Uoogoo00Uoo`0394Uoogoo00aoo`03<4Uoogoo
01=oo`8lBBMoo`005Goo00<007ooOol0OWoo00<DBGooOol027oo00<TBGooOol02goo0S195Goo00<l
BGooOol09goo000EOol00`00Oomoo`1mOol00aA9Oomoo`08Ool00bA9Oomoo`0;Ool00c19Oomoo`0C
Ool2?4TZOol001Eoo`03001oogoo07aoo`0354Uoogoo00Qoo`0394Uoogoo00]oo`03<4Uoogoo01=o
o`03?4Uoogoo02Yoo`005Goo00<007ooOol0Ngoo00<DBGooOol027oo00<TBGooOol02Woo0S1957oo
0Sa9;Goo000EOol2001kOol00aA9Oomoo`08Ool00bA9Oomoo`0:Ool00c19Oomoo`0COol00ca9Oomo
o`0]Ool001Eoo`03001oogoo07Yoo`0354Uoogoo00Moo`0394Uoogoo00Yoo`03<4Uoogoo01=oo`03
?4Uoogoo02ioo`005Goo00<007ooOol0NGoo00<DBGooOol01goo00<TBGooOol02Woo00<`BGooOol0
4goo00<lBGooOol0;goo000EOol00`00Oomoo`1hOol00aA9Oomoo`07Ool00bA9Oomoo`0:Ool00c19
Oomoo`0BOol2?4TbOol001Eoo`8007Qoo`0354Uoogoo00Moo`0394Uoogoo00Yoo`03<4Uoogoo019o
o`03?4Uoogoo039oo`005Goo00<007ooOol0MWoo00<DBGooOol01goo00<TBGooOol02Goo0S1957oo
00<lBGooOol0<goo000EOol00`00Oomoo`1eOol00aA9Oomoo`07Ool00bA9Oomoo`09Ool00c19Oomo
o`0COol00ca9Oomoo`0dOol000=oo`8000Aoo`8000=oo`<000Aoo`03001oogoo07Aoo`0354Uoogoo
00Moo`0394Uoogoo00Uoo`03<4Uoogoo019oo`8lBCMoo`000Woo00@007ooOol000Yoo`03001oogoo
009oo`03001oogoo07=oo`0354Uoogoo00Moo`0394Uoogoo00Uoo`03<4Uoogoo019oo`03?4Uoogoo
03Moo`000Woo00@007ooOol000Uoo`<000=oo`8007Aoo`0354Uoogoo00Ioo`0394Uoogoo00Uoo`03
<4Uoogoo015oo`8lBCYoo`000Woo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`1bOol0
0aA9Oomoo`06Ool00bA9Oomoo`09Ool00c19Oomoo`0AOol00ca9Oomoo`0jOol0009oo`04001oogoo
0008Ool01000Oomoo`000goo00<007ooOol0LGoo00<DBGooOol01Woo00<TBGooOol02Goo00<`BGoo
Ool047oo0Sa99Woo00=8BGooOol057oo0003Ool2000:Ool30003Ool00`00Oomoo`1`Ool00aA9Oomo
o`06Ool00bA9Oomoo`09Ool00c19Oomoo`0@Ool00ca9Oomoo`0TOol2B4TGOol001Eoo`03001oogoo
06moo`0354Uoogoo00Ioo`0394Uoogoo00Uoo`03<4Uoogoo011oo`03?4Uoogoo02=oo`98BAUoo`00
5Goo0P00Kgoo00<DBGooOol01Woo00<TBGooOol02Goo00<`BGooOol03goo0Sa997oo0TQ96goo000E
Ool00`00Oomoo`1]Ool00aA9Oomoo`06Ool00bA9Oomoo`09Ool00c19Oomoo`0?Ool00ca9Oomoo`0S
Ool00dQ9Oomoo`0KOol001Eoo`03001oogoo06aoo`0354Uoogoo00Ioo`0394Uoogoo00Uoo`03<4Uo
ogoo00moo`03?4Uoogoo029oo`98BAioo`005Goo00<007ooOol0Jgoo00<DBGooOol01Woo00<TBGoo
Ool02Goo00<`BGooOol03Woo0Sa997oo00=8BGooOol07Woo000EOol00`00Oomoo`1[Ool00aA9Oomo
o`05Ool00bA9Oomoo`09Ool00c19Oomoo`0>Ool00ca9Oomoo`0ROol2B4TQOol001Eoo`8006]oo`03
54Uoogoo00Eoo`0394Uoogoo00Uoo`03<4Uoogoo00ioo`03?4Uoogoo025oo`98BB=oo`005Goo00<0
07ooOol0JGoo00<DBGooOol01Goo00<TBGooOol027oo0S1947oo00<lBGooOol08Goo00=8BGooOol0
8goo000EOol00`00Oomoo`1XOol00aA9Oomoo`05Ool00bA9Oomoo`08Ool00c19Oomoo`0?Ool00ca9
Oomoo`0POol2B4TVOol001Eoo`03001oogoo06Moo`0354Uoogoo00Eoo`0394Uoogoo00Qoo`03<4Uo
ogoo00ioo`8lBB9oo`03B4Uoogoo02Ioo`005Goo00<007ooOol08Woo10009Goo0P006Goo00<DBGoo
Ool01Goo00<TBGooOol00Woo0`000goo00<`BGooOol03Woo00<lBGooOol037oo0P004Woo0TQ947oo
0`005Woo000EOol2000SOol00`00Oomoo`0UOol01000Oomoo`005goo00<DBGooOol01Goo00<TBGoo
Ool017oo00D007ooOomooc19011oo`03?4Uoogoo00aoo`04001oogoo000?Ool2B4TBOol01000Oomo
o`005Goo000EOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0EOol00aA9Oomoo`05Ool0
0bA9Oomoo`02Ool500000goo<4Uoo`0?Ool00ca9Oomoo`0@Ool00`00Oomoo`0<Ool00dQ9Oomoo`0B
Ool01000Oomoo`005Goo000EOol00`00Oomoo`0TOol00`00Oomoo`0VOol00`00Oomoo`0COol00aA9
Oomoo`05Ool00bA9Oomoo`03Ool01P00Oomoo`00Ool`BA1oo`03?4Uoogoo00moo`8000ioo`03B4Uo
ogoo01=oo`<001Ioo`005Goo00<007ooOol08Woo00@007ooOol002Aoo`04001oogoo000EOol00aA9
Oomoo`04Ool00bA9Oomoo`05Ool01000Ool003193goo0Sa94Woo00<007ooOol02goo0TQ95goo00<0
07ooOol05Goo000EOol00`00Oomoo`0SOol2000VOol2000EOol00aA9Oomoo`04Ool00bA9Oomoo`07
Ool2<4T?Ool00ca9Oomoo`0BOol3000:Ool00dQ9Oomoo`0GOol3000EOol001Eoo`80069oo`0354Uo
ogoo00Aoo`0394Uoogoo00Moo`03<4Uoogoo00ioo`03?4Uoogoo01moo`03B4Uoogoo031oo`005Goo
00<007ooOol0H7oo00<DBGooOol017oo00<TBGooOol01goo00<`BGooOol03Goo0Sa987oo0TQ9<goo
000EOol00`00Oomoo`1OOol00aA9Oomoo`04Ool00bA9Oomoo`07Ool00c19Oomoo`0=Ool00ca9Oomo
o`0OOol00dQ9Oomoo`0YOol30007Ool001Eoo`03001oogoo05ioo`0354Uoogoo00Aoo`0394Uoogoo
00Moo`03<4Uoogoo00eoo`03?4Uoogoo01ioo`98BB]oo`05001oogooOol00006Ool001Eoo`03001o
ogoo05eoo`0354Uoogoo00Aoo`0394Uoogoo00Moo`03<4Uoogoo00aoo`8lBB1oo`03B4Uoogoo02ao
o`<000Moo`0047oo1@000dQ9G00000<DB@000000100000<TB@0000001`0000<`B@000000300000<l
B@0000007P000TQ9:0001goo00<007ooOol01goo000EOol00`00Oomoo`02B4T3Ool00`00Oomoo`05
Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05
Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00aA9Oomoo`04Ool00bA9001oo`06Ool2<4T6Ool00`00Oomoo`05Ool00ca9Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00B4U8B@05Ool00`00Oomoo`05Ool00`00
Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool001Eo
o`03001oogoo009oo`03B4Uoogoo05Eoo`0354Uoogoo00Aoo`0394Uoogoo00Ioo`03<4Uoogoo00ao
o`8lBAmoo`03B4Uoogoo035oo`03001oogoo00Moo`005Goo00<007ooOol00goo00=8BGooOol0Dgoo
00<DBGooOol017oo00<TBGooOol01Woo00<`BGooOol037oo00<lBGooOol07Goo0TQ9=Goo10001Goo
000EOol00`00Oomoo`04Ool00dQ9Oomoo`1AOol00aA9Oomoo`04Ool00bA9Oomoo`06Ool00c19Oomo
o`0<Ool00ca9Oomoo`0MOol00dQ9Oomoo`0nOol001Eoo`8000Ioo`03B4Uoogoo04moo`0354Uoogoo
00Aoo`0394Uoogoo00Ioo`03<4Uoogoo00aoo`03?4Uoogoo01aoo`98BD5oo`005Goo00<007ooOol0
1Woo00=8BGooOol0CGoo00<DBGooOol017oo00<TBGooOol01Woo00<`BGooOol037oo00<lBGooOol0
77oo00=8BGooOol0@Goo000EOol00`00Oomoo`07Ool00dQ9Oomoo`1;Ool00aA9Oomoo`04Ool00bA9
Oomoo`06Ool00c19Oomoo`0<Ool00ca9Oomoo`0KOol2B4U4Ool001Eoo`03001oogoo00Moo`03B4Tl
BGoo04Yoo`0354Uoogoo00=oo`8TB@Moo`8`B@eoo`8lBAeoo`03B4Uoogoo04Aoo`005Goo0P002Goo
00=8BCa9Ool0B7oo00<DBGooOol00goo00<TBGooOol01Woo00<`BGooOol037oo00<lBGooOol077oo
00=8BGooOol0AGoo000EOol00`00Oomoo`09Ool00dQ9?4Uoo`16Ool00aA9Oomoo`03Ool00bA9Oomo
o`06Ool00c19Oomoo`0<Ool00ca9Oomoo`0KOol2B4U8Ool001Eoo`03001oogoo00Yoo`03B4TTBGoo
04Aoo`0354Uoogoo00=oo`0394Uoogoo00Ioo`03<4Uoogoo00aoo`03?4Uoogoo01]oo`03B4Uoogoo
04Qoo`005Goo00<007ooOol02goo00=8BBA9Ool0@Woo00<DBGooOol00goo00<TBGooOol01Woo00<`
BGooOol037oo00<lBGooOol06goo00=8BGooOol0BGoo000EOol00`00Oomoo`0<Ool00dQ994Uoo`10
Ool00aA9Oomoo`03Ool00bA9Oomoo`06Ool00c19Oomoo`0<Ool00ca9Oomoo`0JOol2B4U<Ool001Eo
o`8000eoo`03B4TlBBA903ioo`8DB@Eoo`0394Uoogoo00Ioo`03<4Uoogoo00aoo`03?4Uoogoo01Yo
o`03B4Uoogoo04aoo`005Goo00<007ooOol03Goo00=8BCa994T0?7oo00<DBGooOol00goo0RA91goo
0S193Goo0Sa977oo00=8BGooOol0CGoo000EOol00`00Oomoo`0>Ool00dQ9?4TTB@0iOol254T5Ool0
0bA9Oomoo`06Ool00c19Oomoo`0<Ool00ca9Oomoo`0JOol2B4U@Ool001Eoo`03001oogoo00moo`03
B4TlBBA903Moo`0354Uoogoo00Aoo`0394Uoogoo00Ioo`03<4Uoogoo00aoo`03?4Uoogoo01Yoo`03
B4Uoogoo051oo`005Goo00<007ooOol047oo00=8BC1994T0=7oo0QA91Woo00<TBGooOol01Woo00<`
BGooOol037oo00<lBGooOol06Woo00=8BGooOol0DGoo000EOol2000AOol014Q9?4T`BAA9<Woo00<D
BGooOol017oo0RA927oo00<`BGooOol037oo00<lBGooOol06Goo0TQ9E7oo000EOol00`00Oomoo`0A
Ool014Q9?4TTBAA9<7oo00<DBGooOol017oo00<TBGooOol01Woo0S193Goo0Sa96goo00=8BGooOol0
E7oo000EOol00`00Oomoo`0BOol014Q9?4TTBAA9;Woo00<DBGooOol00goo0RA927oo00<`BGooOol0
37oo00<lBGooOol06Woo00=8BGooOol0EGoo0002Ool50002Ool20003Ool50002Ool00`00Oomoo`0C
Ool014Q9?4TTBAA9:goo0QA91Goo00<TBGooOol01goo00<`BGooOol037oo00<lBGooOol06Goo0TQ9
F7oo0004Ool00`00Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`0DOol014Q9<4TTBAA9:Goo00<D
BGooOol00goo0RA927oo0S193Goo0Sa96goo00=8BGooOol0F7oo0004Ool00`00Oomoo`09Ool00`00
Oomoo`02Ool2000EOol014Q9?4T`BBA90QA99Woo00<DBGooOol00goo00<TBGooOol01goo00<`BGoo
Ool037oo00<lBGooOol06Woo00=8BGooOol0FGoo0004Ool00`00Oomoo`09Ool00`00Oomoo`02Ool0
0`00Oomoo`0EOol00dQ9?4T`B@0294T00aA9Oomoo`0QOol254T4Ool294T9Ool00c19Oomoo`0<Ool0
0ca9Oomoo`0IOol2B4ULOol000Aoo`03001oogoo00Uoo`03001oogoo009oo`03001oogoo01Ioo`05
B4TlBC19OolTB@0254TOOol254T5Ool00bA9Oomoo`07Ool2<4T=Ool2?4TKOol00dQ9Oomoo`1LOol0
00=oo`8000Yoo`8000Aoo`03001oogoo01Moo`06B4TlBC19OolTBGoo0QA96goo0QA91Woo00<TBGoo
Ool01goo00<`BGooOol037oo00<lBGooOol06Woo00=8BGooOol0GGoo000EOol00`00Oomoo`0HOol0
14Q9?4T`BGoo0RA900=ooaA954T05goo0QA91Woo0RA927oo0S193Woo00<lBGooOol06Goo0TQ9H7oo
000EOol2000IOol014Q9OollBC190Woo00<TBGooOol00QA94Goo11A91Woo0RA927oo0S193Woo0Sa9
6goo00=8BGooOol0H7oo000EOol00`00Oomoo`0IOol00dQ9OollB@02<4T00goo94TTB@02Ool654T6
Ool554T8Ool294T9Ool00c19Oomoo`0=Ool00ca9Oomoo`0JOol00dQ9Oomoo`1QOol001Eoo`03001o
ogoo01Yoo`05B4Uooca9Ool`B@02Ool294T5Ool754T:Ool394T9Ool2<4T>Ool2?4TKOol2B4UTOol0
01Eoo`03001oogoo01]oo`05B4Uooca9Ool`B@03Ool294TAOol394T:Ool2<4T>Ool2?4TLOol00dQ9
Oomoo`1TOol001Eoo`03001oogoo01aoo`04B4Uooca9Ool2<4T3Ool794T4Ool694T;Ool2<4T>Ool2
?4TLOol2B4UWOol001Eoo`8001eoo`04B4Uoogoo?4T2Ool2<4T8Ool494T?Ool2<4T>Ool2?4TLOol2
B4UYOol001Eoo`03001oogoo01eoo`03B4Uoogoo008lB@9oo`<`BAIoo`8`B@moo`03?4Uoogoo01Yo
o`98BF]oo`005Goo00<007ooOol07Woo00E8BGooOomooca900Aoo`8`BA5oo`<`B@moo`8lBA]oo`98
BFeoo`005Goo00<007ooOol07goo00E8BGooOomooca900Eoo`H`B@Aoo`L`BA5oo`03?4Uoogoo01Yo
o`03B4Uoogoo06eoo`005Goo00<007ooOol087oo00A8BGooOomoo`8lB@Uoo`D`BAEoo`8lBAaoo`03
B4Uoogoo06ioo`005Goo0P008Woo00=8BGooOol00Woo00<lBGooOol07Woo0Sa977oo0TQ9LGoo000E
Ool00`00Oomoo`0ROol00dQ9Oomoo`02Ool2?4TLOol2?4TMOol00dQ9Oomoo`1aOol001Eoo`03001o
ogoo02=oo`03B4Uoogoo00=oo`8lBAMoo`<lBAioo`03B4Uoogoo079oo`005Goo00<007ooOol097oo
00=8BGooOol017oo0Sa94goo0Sa97goo0TQ9MGoo000EOol00`00Oomoo`0UOol00dQ9Oomoo`05Ool6
?4T6Ool7?4TPOol00dQ9Oomoo`1eOol001Eoo`8002Moo`03B4Uoogoo00Uoo`LlBBEoo`98BGQoo`00
5Goo00<007ooOol09goo00=8BGooOol0<Woo0TQ9NWoo0002Ool50002Ool20003Ool40003Ool00`00
Oomoo`0XOol00dQ9Oomoo`0_Ool2B4UlOol000Aoo`03001oogoo00Moo`03001oogoo00Aoo`03001o
ogoo02Uoo`03B4Uoogoo02aoo`98BGioo`0017oo00<007ooOol027oo00<007ooOol00goo0P00:goo
00=8BGooOol0:Goo0TQ9P7oo0004Ool00`00Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`0[Ool0
0dQ9Oomoo`0WOol00dQ9Oomoo`20Ool000Aoo`03001oogoo00Moo`04001oogoo0003Ool00`00Oomo
o`0/Ool2B4TUOol2B4V3Ool000=oo`8000Yoo`8000Aoo`03001oogoo02ioo`03B4Uoogoo021oo`98
BHEoo`005Goo00<007ooOol0;goo0dQ977oo0dQ9Qgoo000EOol2000cOol2B4TFOol4B4V:Ool001Eo
o`03001oogoo03Aoo`A8B@moo`=8BHioo`005Goo00<007ooOol0>7oo3dQ9TGoo000EOol00`00Oomo
o`3HOol001Eoo`03001oogoo0=Qoo`005Goo0P00fGoo003`Ool00?1oo`00l7oo003`Ool00?1oo`00
l7oo003`Ool00?1oo`005goo0P00egoo000HOol00`00Oomoo`3EOol0015oo`<000Aoo`03001oogoo
0=Eoo`004Woo00<007ooOol00Woo0P00egoo000BOol00`00Oomoo`3KOol0019oo`800=aoo`004Woo
00@007ooOol00=Yoo`004Goo1@00fWoo003`Ool00?1oo`00l7oo003`Ool00001\
\>"],
  ImageRangeCache->{{{0, 239}, {147.5, 0}} -> {0.448684, 0.717962, 0.0254788, \
0.00410348}}]
}, Open  ]],

Cell[TextData[
"We realize that the influence of the non-linear terms represented by \
\[Gamma] increases if \[Gamma] increases. The given solutions are by no means \
complete. We only get a caricature of the solution manifold by a numerical \
solution. However, for some practical applications, this solution may be \
sufficient to solve a specific problem."], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.6.10.2 Desorption with Non-linearity", "Subsubsection",
  CellTags->"Desorption with Nonlinearity"],

Cell[TextData[
"The general model of MBE reduces to a model containing only effects of \
desorption and deposition if we set the constants \[Kappa] and \[Gamma] equal \
to zero:"], "Text",
  CellTags->"desorption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m3MBE\  = \ nMBE\  /. {\[Kappa] \[Rule] 0, \[Gamma] \[Rule] 0}; 
    m3MBE // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[CapitalPhi]\) + a\_t - \[Alpha]\ a\_\(x, x\) - 
                3\ \[Lambda]\ a\_x\%2\ a\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"The equation of motion is a non-linear second-order PDE with a constant flux \
\[CapitalPhi] responsible for deposition. The equation of motion is connected \
with a non-linear diffusion equation including convective effects of the \
material in addition to the diffusive effects. The symmetries of this \
equation follow by"], "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m3infi\  = \ 
      Infinitesimals[m3MBE, a, {x, t}, {\[Alpha], \[Lambda], \[CapitalPhi]}]; 
    m3infi\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{"k3", "+", 
                
                StyleBox[
                  \(\(k4\ \((a + t\ \[CapitalPhi])\)\)\/\[CapitalPhi]\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k1", "+", 
                StyleBox[\(\(k4\ x\)\/\[CapitalPhi]\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{"k2", "+", 
                StyleBox[\(\(2\ k4\ t\)\/\[CapitalPhi]\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k3, 
            Times[ k4, 
              Power[ \[CapitalPhi], -1], 
              Plus[ a, 
                Times[ t, \[CapitalPhi]]]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k1, 
            Times[ k4, x, 
              Power[ \[CapitalPhi], -1]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k2, 
            Times[ 2, k4, t, 
              Power[ \[CapitalPhi], -1]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[
"describing a four-dimensional finite group with scaling and translation \
symmetries. We observe that the constant flux \[CapitalPhi] is connected with \
the scaling symmetry. We will examine the solutions for the non-linear \
deposition model for this symmetry. The infinitesimals for the scaling \
subgroup read"], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = 
      \({{\(xi[1]\)[x, t, a], \(xi[2]\)[x, t, a]}, {\(phi[1]\)[x, t, a]}} /. 
          m3infi\) /. {k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 1}
          \)], "Input"],

Cell[BoxData[
    \({{x\/\[CapitalPhi], \(2\ t\)\/\[CapitalPhi]}, {
        \(a + t\ \[CapitalPhi]\)\/\[CapitalPhi]}}\)], "Output"]
}, Open  ]],

Cell["The corresponding reduction follows from", "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1\  = \ 
      LieReduction[m3MBE, {a}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(t\/x\^2\),
                  ScriptLevel->0], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(\(-a\) + t\ \[CapitalPhi]\)\/x\),
                    ScriptLevel->0]}], "-", \(F\_1\)}], "==", "0"}]},
          {
            \(\((F\_1)\)\_\(\[Zeta]\_1\) - 
                2\ \[Alpha]\ \[Zeta]\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) - 
                6\ \[Lambda]\ F\_1\%2\ \[Zeta]\_1\ 
                  \((F\_1)\)\_\(\[Zeta]\_1\) + 
                24\ \[Lambda]\ F\_1\ \[Zeta]\_1\%2\ 
                  \((F\_1)\)\_\[Zeta]\_1\%2 - 
                24\ \[Lambda]\ \[Zeta]\_1\%3\ \((F\_1)\)\_\[Zeta]\_1\%3 - 
                4\ \[Alpha]\ \[Zeta]\_1\%2\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                12\ \[Lambda]\ F\_1\%2\ \[Zeta]\_1\%2\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                48\ \[Lambda]\ F\_1\ \[Zeta]\_1\%3\ 
                  \((F\_1)\)\_\(\[Zeta]\_1\)\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                48\ \[Lambda]\ \[Zeta]\_1\%4\ \((F\_1)\)\_\[Zeta]\_1\%2\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "In the similarity reduction, the flux \[CapitalPhi] is separated from the \
similarity function ",
  Cell[BoxData[
      \(TraditionalForm\`F\_1\)]],
  ". This function has to satisfy a non-linear second-order ODE which is not \
symbolically solvable by ",
  StyleBox["DSolve[]", "MmaText"],
  ". The examination of the symmetry reveals that this equation does not \
allow any point symmetry and thus Lie's integration strategy terminates:"
}], "Text",
  CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Infinitesimals[red1\[LeftDoubleBracket]3\[RightDoubleBracket], F1, 
        zeta1, {\[Lambda], \[Alpha]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{zeta1, 2}F1[zeta1]}] // LTF
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_1 == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 0]}]]], "Output"]
}, Open  ]],

Cell["\<\
The only way to study the equation is a numerical integration. \
Adding initial conditions to the second-order ODE and fixing the \
parameters,\
\>", "Text",
  CellTags->"numerical integration"],

Cell[BoxData[
    RowBox[{
      RowBox[{"neq", " ", "=", " ", 
        RowBox[{
          RowBox[{"Join", "[", 
            RowBox[{\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\), ",", 
              RowBox[{"{", 
                RowBox[{\(F1[1] == 1\), ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[Prime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(1/2\)}]}], "}"}]}], "]"}], "/.", 
          \({\[Lambda] \[Rule] 1}\)}]}], ";"}]], "Input"],

Cell[TextData[
"allows us the numerical integration. We first fixed \[Lambda] describing the \
non-linear influence in the equation and changed \[Alpha] over a large \
range:"], "Text"],

Cell[BoxData[
    \(\(nsol\  = \ 
      Table[NDSolve[neq\  /. \ \[Alpha] \[Rule] i, F1, {zeta1, 1, 15}], {i, 
          1, 50, 10}]; \)\)], "Input"],

Cell[TextData[
"The resulting solutions for different \[Alpha] and identical initial \
conditions are plotted below."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[F1[\[Zeta]] /. nsol], {\[Zeta], 1, 15}, 
      PlotStyle \[Rule] \ Table[Hue[i], {i, 0,  .5,  .1}], 
      AxesLabel \[Rule] {"\<\[Zeta]\>", \*"\"\<\!\(F\_1\)\>\""}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 -0.157294 0.172009 [
[.15079 .00222 -3 -9 ]
[.15079 .00222 3 0 ]
[.27778 .00222 -3 -9 ]
[.27778 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.53175 .00222 -3 -9 ]
[.53175 .00222 3 0 ]
[.65873 .00222 -6 -9 ]
[.65873 .00222 6 0 ]
[.78571 .00222 -6 -9 ]
[.78571 .00222 6 0 ]
[.9127 .00222 -6 -9 ]
[.9127 .00222 6 0 ]
[1.025 .01472 0 -7.5 ]
[1.025 .01472 10 7.5 ]
[.01131 .10072 -18 -4.5 ]
[.01131 .10072 0 4.5 ]
[.01131 .18672 -6 -4.5 ]
[.01131 .18672 0 4.5 ]
[.01131 .27273 -18 -4.5 ]
[.01131 .27273 0 4.5 ]
[.01131 .35873 -6 -4.5 ]
[.01131 .35873 0 4.5 ]
[.01131 .44474 -18 -4.5 ]
[.01131 .44474 0 4.5 ]
[.01131 .53074 -6 -4.5 ]
[.01131 .53074 0 4.5 ]
[.01131 .61675 -18 -4.5 ]
[.01131 .61675 0 4.5 ]
[.02381 .64303 -7.5 0 ]
[.02381 .64303 7.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 .01472 m
.15079 .02097 L
s
[(2)] .15079 .00222 0 1 Mshowa
.27778 .01472 m
.27778 .02097 L
s
[(4)] .27778 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(6)] .40476 .00222 0 1 Mshowa
.53175 .01472 m
.53175 .02097 L
s
[(8)] .53175 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(10)] .65873 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(12)] .78571 .00222 0 1 Mshowa
.9127 .01472 m
.9127 .02097 L
s
[(14)] .9127 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.18254 .01472 m
.18254 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.34127 .01472 m
.34127 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.81746 .01472 m
.81746 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .10072 m
.03006 .10072 L
s
[(1.5)] .01131 .10072 1 0 Mshowa
.02381 .18672 m
.03006 .18672 L
s
[(2)] .01131 .18672 1 0 Mshowa
.02381 .27273 m
.03006 .27273 L
s
[(2.5)] .01131 .27273 1 0 Mshowa
.02381 .35873 m
.03006 .35873 L
s
[(3)] .01131 .35873 1 0 Mshowa
.02381 .44474 m
.03006 .44474 L
s
[(3.5)] .01131 .44474 1 0 Mshowa
.02381 .53074 m
.03006 .53074 L
s
[(4)] .01131 .53074 1 0 Mshowa
.02381 .61675 m
.03006 .61675 L
s
[(4.5)] .01131 .61675 1 0 Mshowa
.125 Mabswid
.02381 .03192 m
.02756 .03192 L
s
.02381 .04912 m
.02756 .04912 L
s
.02381 .06632 m
.02756 .06632 L
s
.02381 .08352 m
.02756 .08352 L
s
.02381 .11792 m
.02756 .11792 L
s
.02381 .13512 m
.02756 .13512 L
s
.02381 .15232 m
.02756 .15232 L
s
.02381 .16952 m
.02756 .16952 L
s
.02381 .20392 m
.02756 .20392 L
s
.02381 .22113 m
.02756 .22113 L
s
.02381 .23833 m
.02756 .23833 L
s
.02381 .25553 m
.02756 .25553 L
s
.02381 .28993 m
.02756 .28993 L
s
.02381 .30713 m
.02756 .30713 L
s
.02381 .32433 m
.02756 .32433 L
s
.02381 .34153 m
.02756 .34153 L
s
.02381 .37593 m
.02756 .37593 L
s
.02381 .39313 m
.02756 .39313 L
s
.02381 .41033 m
.02756 .41033 L
s
.02381 .42754 m
.02756 .42754 L
s
.02381 .46194 m
.02756 .46194 L
s
.02381 .47914 m
.02756 .47914 L
s
.02381 .49634 m
.02756 .49634 L
s
.02381 .51354 m
.02756 .51354 L
s
.02381 .54794 m
.02756 .54794 L
s
.02381 .56514 m
.02756 .56514 L
s
.02381 .58234 m
.02756 .58234 L
s
.02381 .59954 m
.02756 .59954 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -68.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.0873 .01472 m
.12336 .06033 L
.16269 .10401 L
.19962 .14078 L
.23514 .17318 L
.27295 .20516 L
.30934 .23395 L
.34802 .26278 L
.38529 .28909 L
.42115 .31323 L
.45929 .33782 L
.49601 .36055 L
.53133 .38163 L
.56893 .40332 L
.60512 .42353 L
.64359 .44436 L
.68065 .46385 L
.7163 .4821 L
.75424 .50102 L
.79076 .5188 L
.82957 .53725 L
.86696 .55462 L
.90294 .57099 L
.94121 .58804 L
.97619 .60332 L
s
1 .6 0 r
.0873 .01472 m
.12336 .05829 L
.16269 .09771 L
.19962 .12998 L
.23514 .15799 L
.27295 .18535 L
.30934 .20981 L
.34802 .23417 L
.38529 .2563 L
.42115 .27656 L
.45929 .29713 L
.49601 .31611 L
.53133 .33368 L
.56893 .35173 L
.60512 .36852 L
.64359 .38582 L
.68065 .40198 L
.7163 .4171 L
.75424 .43278 L
.79076 .44749 L
.82957 .46274 L
.86696 .4771 L
.90294 .49062 L
.94121 .50469 L
.97619 .51731 L
s
.8 1 0 r
.0873 .01472 m
.12336 .0582 L
.16269 .09742 L
.19962 .12948 L
.23514 .15729 L
.27295 .18444 L
.30934 .20869 L
.34802 .23284 L
.38529 .25479 L
.42115 .27486 L
.45929 .29524 L
.49601 .31405 L
.53133 .33145 L
.56893 .34933 L
.60512 .36597 L
.64359 .3831 L
.68065 .3991 L
.7163 .41408 L
.75424 .4296 L
.79076 .44416 L
.82957 .45927 L
.86696 .47348 L
.90294 .48686 L
.94121 .5008 L
.97619 .51328 L
s
.2 1 0 r
.0873 .01472 m
.12336 .05816 L
.16269 .09732 L
.19962 .1293 L
.23514 .15704 L
.27295 .18411 L
.30934 .2083 L
.34802 .23238 L
.38529 .25425 L
.42115 .27426 L
.45929 .29458 L
.49601 .31332 L
.53133 .33067 L
.56893 .34848 L
.60512 .36506 L
.64359 .38214 L
.68065 .39809 L
.7163 .41301 L
.75424 .42847 L
.79076 .44299 L
.82957 .45804 L
.86696 .4722 L
.90294 .48554 L
.94121 .49942 L
.97619 .51186 L
s
0 1 .4 r
.0873 .01472 m
.12336 .05814 L
.16269 .09726 L
.19962 .12921 L
.23514 .15691 L
.27295 .18395 L
.30934 .2081 L
.34802 .23214 L
.38529 .25398 L
.42115 .27395 L
.45929 .29424 L
.49601 .31295 L
.53133 .33026 L
.56893 .34805 L
.60512 .3646 L
.64359 .38164 L
.68065 .39757 L
.7163 .41246 L
.75424 .4279 L
.79076 .44239 L
.82957 .45741 L
.86696 .47155 L
.90294 .48486 L
.94121 .49872 L
.97619 .51114 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000iOol4
000MOol3000IOol3000LOol2000IOol50002Ool2000EOol500000goo00000002000DOol50003Ool3
000YOol003Uoo`03001oogoo01moo`03001oogoo01Qoo`04001oogoo000JOol01000Oomoo`006Woo
00D007ooOomoo`00009oo`03001oogoo01Aoo`05001oogooOol0000IOol00`00Oomoo`04Ool00`00
Oomoo`0XOol003Yoo`03001oogoo01]oo`D001Uoo`04001oogoo000JOol01000Oomoo`006Woo00D0
07ooOomoo`00009oo`03001oogoo01Aoo`03001oogoo009oo`03001oogoo01Ioo`04001oogooOol5
000YOol003]oo`03001oogoo01Yoo`04001oogoo000JOol3000LOol2000KOol01@00Oomoogoo0000
0Woo00<007ooOol057oo00<007ooOol00goo00<007ooOol05Goo00D007ooOomoo`00009oo`03001o
ogoo02Qoo`00>Goo00@007ooOol001aoo`03001oo`0001]oo`03001oogoo01Yoo`04001oogoo000J
Ool01@00Oomoogoo00000Woo00<007ooOol057oo00D007ooOomoo`00009oo`03001oogoo01Aoo`03
001oogoo009oo`03001oo`0002Yoo`00>Woo0P007Woo0P006goo0`006goo0P006Woo0P0017oo0P00
5Woo0P0017oo0P005Woo0P001Goo0P00:Woo003oOolQOol001eoo`03001oogoo0?moo`5oo`007Goo
00<007ooOol0kgoo0`003Woo000MOol00`00Oomoo`3^Ool01@00Oomoogoo00003Goo000MOol00`00
Oomoo`3_Ool3000>Ool001MooaD000030n`000000=P000Qoo`03001oogoo00ioo`007Goo00<007oo
Ool03Goo00<3k7ooOol02goo00<007ooOol077oo00<007ooOol06goo00<007ooOol06goo00<007oo
Ool077oo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol03Woo000MOol0
0`00Oomoo`0>Ool00`?/Oomoo`3NOol00`00Oomoo`0>Ool001eoo`03001oogoo00moo`030naoogoo
0=ioo`@000aoo`007Goo0P004Goo00<3k7ooOol0kGoo000MOol00`00Oomoo`0AOol00`?/Oomoo`3/
Ool001eoo`03001oogoo015oo`030naoogoo0>aoo`007Goo00<007ooOol04Woo00<3k7ooOol0jgoo
000MOol2000DOol00`?/Oomoo`3ZOol001eoo`03001oogoo01Aoo`030naoogoo0>Uoo`007Goo00<0
07ooOol05Goo00<3k7ooOol0j7oo000MOol00`00Oomoo`0FOol00`?/Oomoo`3WOol001eoo`8001Qo
o`030naoogoo0>Ioo`007Goo00<007ooOol05goo00=l00?/Ool0iWoo000MOol00`00Oomoo`0HOol0
0g`00naoo`3UOol001eoo`03001oogoo01Uoo`03O003k7oo0>Aoo`007Goo0P006goo00=l00?/Ool0
hgoo000MOol00`00Oomoo`0KOol00g`00naoo`3ROol000Uoo`D0009oo`8000Aoo`8000Eoo`03001o
ogoo01aoo`03O003k7oo0>5oo`002goo00<007ooOol01goo00@007ooOol000Aoo`03001oogoo01ao
o`03O01oo`?/0>5oo`002goo00<007ooOol02Woo00<007ooOol00Woo0`007Goo00=l07oo0n`0h7oo
000;Ool00`00Oomoo`08Ool20005Ool00`00Oomoo`0NOol00g`0Ool3k03OOol000]oo`03001oogoo
00Qoo`03001oogoo00Aoo`03001oogoo01moo`03O01oo`?/0=ioo`002Woo0P002Woo0`0017oo00<0
07ooOol087oo00Al07oo0n`3k=aoo`007Goo0P008Woo00Al07ooOol3k=]oo`007Goo00<007ooOol0
8Woo00Al07ooOol3k=Yoo`007Goo00<007ooOol08goo00Al07ooOol3k=Uoo`007Goo00<007ooOol0
97oo00Al07ooOol3k=Qoo`007Goo0P009Woo00Al07ooOol3k=Moo`007Goo00<007ooOol09Woo00=l
07ooOol00P?/eGoo000MOol00`00Oomoo`0WOol01G`0OomooaOP0n`0e7oo000MOol00`00Oomoo`0X
Ool01G`0OomooaOP0n`0dgoo000MOol2000ZOol017`0Oomoogoo0P?/dGoo000MOol00`00Oomoo`0Z
Ool01W`0Oomoogoo5n03k=1oo`007Goo00<007ooOol0:goo0W`00Woo00<Gh0?/Ool0cWoo000MOol0
0`00Oomoo`0]Ool017`0OomooaOP0P?/cGoo000MOol2000_Ool01W`0Oomoogoo5n03k<aoo`007Goo
00<007ooOol0;goo00Il07ooOomooaOP0nc;Ool001eoo`03001oogoo031oo`03O01oogoo009oo`83
k<Uoo`005Goo100017oo00<007ooOol0<Goo00=l07ooOol00Woo00<Gh0?/Ool0agoo000EOol00`00
Oomoo`05Ool00`00Oomoo`0bOol00g`0Oomoo`03Ool00`?/Oomoo`35Ool001Ioo`03001oogoo00Ao
o`<003=oo`9l00Aoo`83k<Eoo`005goo00<007ooOol00goo00<007ooOol0=Goo00=l07ooOol00goo
00<3k7ooOol0`Woo000EOol01000Oomoo`0017oo00<007ooOol0=Woo00=l07ooOol00goo0P?/`Woo
000FOol20005Ool00`00Oomoo`0gOol00g`0Oomoo`04Ool00`?/Oomoo`2oOol001eoo`8003Uoo`03
O01oogoo00Aoo`83k;moo`007Goo00<007ooOol0>Goo00=l07ooOol01Goo00<3k7ooOol0_7oo000M
Ool00`00Oomoo`0jOol2O006Ool20nblOol001eoo`03001oogoo03aoo`03O01oogoo00Eoo`83k;Yo
o`007Goo0P00?Woo00=l07ooOol01Goo00=Wh0?/0n`0^7oo000MOol00`00Oomoo`0nOol2O007Ool0
0fOP0n`3k02fOol001eoo`03001oogoo041oo`03O01oogoo00Eoo`9Wh0030naoogoo0;=oo`007Goo
00<007ooOol0@Goo00=l07ooOol01Woo00=Wh0?/0n`0/goo000MOol20013Ool00g`0Oomoo`06Ool2
In000`?/Oomoo`2`Ool001eoo`03001oogoo04=oo`9l00Qoo`03In03k0?/0;1oo`007Goo00<007oo
Ool0AGoo00=l07ooOol01goo00=Wh0?/Ool0[Woo000MOol00`00Oomoo`16Ool00g`0Oomoo`08Ool2
0nb]Ool001eoo`8004Qoo`9l00Yoo`83k:]oo`007Goo00<007ooOol0BGoo00=l07ooOol027oo00=W
h0?/0n`0ZGoo0009Ool40003Ool20004Ool20005Ool00`00Oomoo`1:Ool00g`0Oomoo`09Ool00fOP
0n`3k02WOol000Uoo`03001oogoo00Uoo`04001oogoo0004Ool00`00Oomoo`1;Ool2O00;Ool00fOP
0n`3k02UOol000Yoo`03001oogoo00]oo`03001oogoo009oo`<004eoo`03O01oogoo00Yoo`03In03
k0?/0:=oo`002goo00<007ooOol027oo0P001Goo00<007ooOol0CWoo0W`037oo00=Wh0?/0n`0XGoo
0009Ool01000Oomoo`002Goo00<007ooOol017oo00<007ooOol0D7oo00=l07ooOol02Woo00An@6OP
0n`3k9moo`002Woo0P002Woo0`0017oo00<007ooOol0DGoo0W`037oo00An@6OP0n`3k9eoo`007Goo
0P00E7oo00=l07ooOol02goo00An@6OP0n`3k9]oo`007Goo00<007ooOol0E7oo0W`03Goo00=n@6OP
0n`0VWoo000MOol00`00Oomoo`1FOol00g`0Oomoo`0<Ool00gi00n`3k02HOol001eoo`03001oogoo
05Moo`9l00ioo`03OT03k0?/09Ioo`007Goo0P00FWoo00=l07ooOol03Goo00=n@0?/0n`0U7oo000M
Ool00`00Oomoo`1JOol2O00?Ool00gi00n`3k02BOol001eoo`03001oogoo05aoo`03O01oogoo00io
o`03OT03k7oo091oo`007Goo00<007ooOol0GGoo0W`047oo0P?/Sgoo000MOol2001POol00g`0Oomo
o`0?Ool20nb=Ool001eoo`03001oogoo061oo`9l011oo`03OT03k0?/08]oo`007Goo00<007ooOol0
HWoo00=l07ooOol03goo00An@0?/0n`3k8Qoo`007Goo00<007ooOol0Hgoo0W`04Goo0Wi00P?/QWoo
000MOol00`00Oomoo`1UOol00g`0Oomoo`0@Ool2OT020nb4Ool001eoo`8006Moo`9l019oo`9n@083
k89oo`007Goo00<007ooOol0J7oo0W`04Woo0Wi00`?/Ogoo000FOol20005Ool00`00Oomoo`1ZOol2
O00BOol3OT020namOol001Eoo`04001oogoo0004Ool00`00Oomoo`1/Ool2O00COol2OT020nakOol0
01Moo`03001oogoo00=oo`<006ioo`03O01oogoo019oo`9n@083k7Uoo`0067oo00<007ooOol00Woo
00<007ooOol0Kgoo0W`057oo0Wi00`?/MWoo000EOol01000Oomoo`0017oo00<007ooOol0LGoo00=l
07ooOol04goo0gi00P?/M7oo000FOol20005Ool00`00Oomoo`1bOol2O00FOol2OT020nabOol001eo
o`8007Eoo`9l01Ioo`9n@083k71oo`007Goo00<007ooOol0MWoo00=l07ooOol05Goo0Wi00`?/KGoo
000MOol00`00Oomoo`1gOol2O00GOol3OT020na[Ool001eoo`03001oogoo07Uoo`9l01Qoo`9n@083
k6Uoo`007Goo0P00O7oo0W`067oo0Wi00P?/Igoo000MOol00`00Oomoo`1mOol2O00HOol2OT030naT
Ool001eoo`03001oogoo07moo`03O01oogoo01Moo`9n@0035n03k0?/069oo`007Goo00<007ooOol0
P7oo0W`06Goo0Wi000@Gh0?/0n`3k5moo`007Goo0P00Pgoo0W`06Goo0Wi00QOP0`?/G7oo000MOol0
0`00Oomoo`24Ool2O00IOol2OT035n020naJOol001eoo`03001oogoo08Ioo`9l01Uoo`=n@08Gh083
k5Qoo`007Goo00<007ooOol0R7oo00=l07ooOol06Goo0Wi000AWh1OP0n`3k5Ioo`007Goo0P00RWoo
0W`077oo00=n@6OPIn000`?/Dgoo000MOol00`00Oomoo`2;Ool2O00MOol3In020naAOol000Yoo`80
00Aoo`8000Aoo`8000Eoo`03001oogoo08eoo`9l01ioo`9Wh083k4moo`002Goo00@007ooOol000Qo
o`04001oogoo0004Ool00`00Oomoo`2?Ool2O00NOol017i0In03k0?/CGoo000;Ool00`00Oomoo`0:
Ool00`00Oomoo`02Ool3002AOol00g`0Oomoo`0MOol2OT030na:Ool000aoo`03001oogoo00Moo`80
00Eoo`03001oogoo099oo`9l01moo`=n@0<3k4Moo`002Goo00@007ooOol000Uoo`03001oogoo00Ao
o`03001oogoo09Aoo`9l021oo`9n@004In03k0?/0na4Ool000Yoo`8000Yoo`<000Aoo`03001oogoo
09Ioo`9l025oo`03OT1Wh6OP00<3k45oo`007Goo0P00VGoo0W`08Woo0fOP0P?/?goo000MOol00`00
Oomoo`2JOol00g`0Oomoo`0ROol2In020n`mOol001eoo`03001oogoo09]oo`9l02Aoo`04OT1Wh0?/
0n`kOol001eoo`03001oogoo09eoo`9l02Aoo`9n@0<3k3Qoo`007Goo0P00X7oo0W`097oo0gi00`?/
=Goo000MOol00`00Oomoo`2QOol2O00UOol3OT030n`bOol001eoo`03001oogoo0:=oo`9l02Ioo`=n
@0<3k2moo`007Goo00<007ooOol0YGoo0W`09goo0gi00`?/;7oo000MOol2002XOol2O00XOol2OT00
16OP0n`3k0?/:Goo000MOol00`00Oomoo`2YOol2O00YOol00gi0In1Wh0030n`VOol001eoo`03001o
ogoo0:]oo`9l02Yoo`=Wh083k2Aoo`007Goo00<007ooOol0[Goo0W`0:goo0VOP0`?/8Goo000MOol0
0`00Oomoo`2_Ool2O00[Ool3In020n`OOol001eoo`800;9oo`9l02aoo`9Wh1moo`007Goo00<007oo
Ool0/goo0g`0BWoo000GOol30003Ool00`00Oomoo`2fOol2O018Ool001Qoo`03001oogoo009oo`03
001oogoo0;Qoo`9l04Ioo`005Goo1@000goo0`00^Woo0W`0A7oo000EOol01000Oomoo`0017oo00<0
07ooOol0_7oo0g`0@Goo000FOol00`00Ool00004Ool00`00Oomoo`2oOol2O00oOol001Moo`8000Ao
o`03001oogoo0<5oo`9l03eoo`007Goo0P00a7oo0W`0>goo000MOol00`00Oomoo`35Ool3O00hOol0
01eoo`03001oogoo0<Qoo`9l03Ioo`007Goo00<007ooOol0bWoo0W`0=7oo000MOol2003=Ool2O00b
Ool001eoo`03001oogoo0<ioo`=l02moo`007Goo00<007ooOol0dGoo0W`0;Goo000MOol00`00Oomo
o`3COol2O00[Ool001eoo`800=Ioo`9l02Uoo`007Goo00<007ooOol0egoo0W`09goo000MOol00`00
Oomoo`3IOol2O00UOol001eoo`03001oogoo0=]oo`9l02=oo`007Goo0P00gWoo0W`08Goo000MOol0
0`00Oomoo`3OOol2O00OOol000]oo`<0009oo`8000Aoo`8000Eoo`03001oogoo0?moo`5oo`0037oo
00<007ooOol01Woo00@007ooOol000Aoo`03001oogoo0?moo`5oo`002Goo1@002Woo00<007ooOol0
0Woo0`00ogoo0Goo0009Ool01000Oomoo`002Goo0P001Goo00<007ooOol0ogoo0Goo000:Ool00`00
Ool00009Ool00`00Oomoo`3oOol8Ool000]oo`8000Uoo`<00?moo`Qoo`00ogoo8Goo003oOolQOol0
0?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`007goo0P00ogoo000POol00`00Oomoo`3mOol0
01Uoo`<000Aoo`03001oogoo0?eoo`006Woo00<007ooOol00Woo0P00ogoo000JOol00`00Oomoo`3o
Ool4Ool001Yoo`800?moo`Eoo`006Woo00@007ooOol00?moo`=oo`006Goo1@00ogoo0goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.94808, 0.708104, \
0.0659933, 0.0243595}}]
}, Open  ]],

Cell[TextData[
"We observe that the solution shows an increasing behavior in \[Zeta]. By \
increasing the dispersive strength \[Alpha] in the ODE, the solutions \
decrease in their values and tend to a limiting curve. The other behavior \
studied under identical initial conditions is the variation of the non-linear \
strength \[Lambda] at a fixed value of \[Alpha]. The equations plus initial \
conditions are created by"], "Text",
  CellTags->"nonlinear strength"],

Cell[BoxData[
    RowBox[{
      RowBox[{"neq", " ", "=", " ", 
        RowBox[{
          RowBox[{"Join", "[", 
            RowBox[{\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\), ",", 
              RowBox[{"{", 
                RowBox[{\(F1[1] == 1\), ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[Prime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(1/2\)}]}], "}"}]}], "]"}], "/.", 
          \({\[Alpha] \[Rule] 1}\)}]}], ";"}]], "Input"],

Cell[TextData[
"The variation of \[Lambda] in the integration process delivers the \
solutions"], "Text"],

Cell[BoxData[
    \(\(nsol\  = \ 
      Table[NDSolve[neq\  /. \ \[Lambda] \[Rule] i, F1, {zeta1, 1, 15}], {i, 
          1, 50, 10}]; \)\)], "Input"],

Cell[TextData["which are plotted over \[Zeta] by"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[F1[\[Zeta]] /. nsol], {\[Zeta], 1, 15}, 
      PlotStyle \[Rule] \ Table[Hue[i], {i, 0,  .5,  .1}], 
      AxesLabel \[Rule] {"\<\[Zeta]\>", \*"\"\<\!\(F\_1\)\>\""}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 -0.157294 0.172009 [
[.15079 .00222 -3 -9 ]
[.15079 .00222 3 0 ]
[.27778 .00222 -3 -9 ]
[.27778 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.53175 .00222 -3 -9 ]
[.53175 .00222 3 0 ]
[.65873 .00222 -6 -9 ]
[.65873 .00222 6 0 ]
[.78571 .00222 -6 -9 ]
[.78571 .00222 6 0 ]
[.9127 .00222 -6 -9 ]
[.9127 .00222 6 0 ]
[1.025 .01472 0 -7.5 ]
[1.025 .01472 10 7.5 ]
[.01131 .10072 -18 -4.5 ]
[.01131 .10072 0 4.5 ]
[.01131 .18672 -6 -4.5 ]
[.01131 .18672 0 4.5 ]
[.01131 .27273 -18 -4.5 ]
[.01131 .27273 0 4.5 ]
[.01131 .35873 -6 -4.5 ]
[.01131 .35873 0 4.5 ]
[.01131 .44474 -18 -4.5 ]
[.01131 .44474 0 4.5 ]
[.01131 .53074 -6 -4.5 ]
[.01131 .53074 0 4.5 ]
[.01131 .61675 -18 -4.5 ]
[.01131 .61675 0 4.5 ]
[.02381 .64303 -7.5 0 ]
[.02381 .64303 7.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 .01472 m
.15079 .02097 L
s
[(2)] .15079 .00222 0 1 Mshowa
.27778 .01472 m
.27778 .02097 L
s
[(4)] .27778 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(6)] .40476 .00222 0 1 Mshowa
.53175 .01472 m
.53175 .02097 L
s
[(8)] .53175 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(10)] .65873 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(12)] .78571 .00222 0 1 Mshowa
.9127 .01472 m
.9127 .02097 L
s
[(14)] .9127 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.18254 .01472 m
.18254 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.34127 .01472 m
.34127 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.81746 .01472 m
.81746 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .10072 m
.03006 .10072 L
s
[(1.5)] .01131 .10072 1 0 Mshowa
.02381 .18672 m
.03006 .18672 L
s
[(2)] .01131 .18672 1 0 Mshowa
.02381 .27273 m
.03006 .27273 L
s
[(2.5)] .01131 .27273 1 0 Mshowa
.02381 .35873 m
.03006 .35873 L
s
[(3)] .01131 .35873 1 0 Mshowa
.02381 .44474 m
.03006 .44474 L
s
[(3.5)] .01131 .44474 1 0 Mshowa
.02381 .53074 m
.03006 .53074 L
s
[(4)] .01131 .53074 1 0 Mshowa
.02381 .61675 m
.03006 .61675 L
s
[(4.5)] .01131 .61675 1 0 Mshowa
.125 Mabswid
.02381 .03192 m
.02756 .03192 L
s
.02381 .04912 m
.02756 .04912 L
s
.02381 .06632 m
.02756 .06632 L
s
.02381 .08352 m
.02756 .08352 L
s
.02381 .11792 m
.02756 .11792 L
s
.02381 .13512 m
.02756 .13512 L
s
.02381 .15232 m
.02756 .15232 L
s
.02381 .16952 m
.02756 .16952 L
s
.02381 .20392 m
.02756 .20392 L
s
.02381 .22113 m
.02756 .22113 L
s
.02381 .23833 m
.02756 .23833 L
s
.02381 .25553 m
.02756 .25553 L
s
.02381 .28993 m
.02756 .28993 L
s
.02381 .30713 m
.02756 .30713 L
s
.02381 .32433 m
.02756 .32433 L
s
.02381 .34153 m
.02756 .34153 L
s
.02381 .37593 m
.02756 .37593 L
s
.02381 .39313 m
.02756 .39313 L
s
.02381 .41033 m
.02756 .41033 L
s
.02381 .42754 m
.02756 .42754 L
s
.02381 .46194 m
.02756 .46194 L
s
.02381 .47914 m
.02756 .47914 L
s
.02381 .49634 m
.02756 .49634 L
s
.02381 .51354 m
.02756 .51354 L
s
.02381 .54794 m
.02756 .54794 L
s
.02381 .56514 m
.02756 .56514 L
s
.02381 .58234 m
.02756 .58234 L
s
.02381 .59954 m
.02756 .59954 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -68.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.0873 .01472 m
.12336 .06033 L
.16269 .10401 L
.19962 .14078 L
.23514 .17318 L
.27295 .20516 L
.30934 .23395 L
.34802 .26278 L
.38529 .28909 L
.42115 .31323 L
.45929 .33782 L
.49601 .36055 L
.53133 .38163 L
.56893 .40332 L
.60512 .42353 L
.64359 .44436 L
.68065 .46385 L
.7163 .4821 L
.75424 .50102 L
.79076 .5188 L
.82957 .53725 L
.86696 .55462 L
.90294 .57099 L
.94121 .58804 L
.97619 .60332 L
s
1 .6 0 r
.0873 .01472 m
.12336 .06023 L
.16269 .10335 L
.19962 .13928 L
.23514 .17074 L
.27295 .20162 L
.30934 .22933 L
.34802 .25699 L
.38529 .28218 L
.42115 .30525 L
.45929 .32872 L
.49601 .35038 L
.53133 .37045 L
.56893 .39109 L
.60512 .4103 L
.64359 .43009 L
.68065 .44859 L
.7163 .46591 L
.75424 .48387 L
.79076 .50072 L
.82957 .51821 L
.86696 .53467 L
.90294 .55017 L
.94121 .56631 L
.97619 .58078 L
s
.8 1 0 r
.0873 .01472 m
.12336 .06016 L
.16269 .10296 L
.19962 .1385 L
.23514 .16955 L
.27295 .2 L
.30934 .22729 L
.34802 .25452 L
.38529 .2793 L
.42115 .302 L
.45929 .32507 L
.49601 .34636 L
.53133 .36609 L
.56893 .38637 L
.60512 .40524 L
.64359 .42468 L
.68065 .44286 L
.7163 .45987 L
.75424 .4775 L
.79076 .49405 L
.82957 .51122 L
.86696 .52738 L
.90294 .54259 L
.94121 .55844 L
.97619 .57264 L
s
.2 1 0 r
.0873 .01472 m
.12336 .0601 L
.16269 .10269 L
.19962 .13797 L
.23514 .16876 L
.27295 .19895 L
.30934 .22598 L
.34802 .25295 L
.38529 .27749 L
.42115 .29995 L
.45929 .32279 L
.49601 .34387 L
.53133 .36338 L
.56893 .38345 L
.60512 .40212 L
.64359 .42136 L
.68065 .43934 L
.7163 .45616 L
.75424 .4736 L
.79076 .48998 L
.82957 .50696 L
.86696 .52294 L
.90294 .53799 L
.94121 .55367 L
.97619 .56771 L
s
0 1 .4 r
.0873 .01472 m
.12336 .06005 L
.16269 .10247 L
.19962 .13757 L
.23514 .16818 L
.27295 .19817 L
.30934 .22503 L
.34802 .25181 L
.38529 .27617 L
.42115 .29847 L
.45929 .32114 L
.49601 .34207 L
.53133 .36144 L
.56893 .38136 L
.60512 .39989 L
.64359 .41898 L
.68065 .43682 L
.7163 .45352 L
.75424 .47083 L
.79076 .48708 L
.82957 .50393 L
.86696 .51979 L
.90294 .53472 L
.94121 .55027 L
.97619 .56421 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000iOol4
000MOol3000IOol3000LOol2000IOol50002Ool2000EOol500000goo00000002000DOol50003Ool3
000YOol003Uoo`03001oogoo01moo`03001oogoo01Qoo`04001oogoo000JOol01000Oomoo`006Woo
00D007ooOomoo`00009oo`03001oogoo01Aoo`05001oogooOol0000IOol00`00Oomoo`04Ool00`00
Oomoo`0XOol003Yoo`03001oogoo01]oo`D001Uoo`04001oogoo000JOol01000Oomoo`006Woo00D0
07ooOomoo`00009oo`03001oogoo01Aoo`03001oogoo009oo`03001oogoo01Ioo`04001oogooOol5
000YOol003]oo`03001oogoo01Yoo`04001oogoo000JOol3000LOol2000KOol01@00Oomoogoo0000
0Woo00<007ooOol057oo00<007ooOol00goo00<007ooOol05Goo00D007ooOomoo`00009oo`03001o
ogoo02Qoo`00>Goo00@007ooOol001aoo`03001oo`0001]oo`03001oogoo01Yoo`04001oogoo000J
Ool01@00Oomoogoo00000Woo00<007ooOol057oo00D007ooOomoo`00009oo`03001oogoo01Aoo`03
001oogoo009oo`03001oo`0002Yoo`00>Woo0P007Woo0P006goo0`006goo0P006Woo0P0017oo0P00
5Woo0P0017oo0P005Woo0P001Goo0P00:Woo003oOolQOol001eoo`03001oogoo0?moo`5oo`007Goo
00<007ooOol0kgoo0`003Woo000MOol00`00Oomoo`3^Ool01@00Oomoogoo00003Goo000MOol00`00
Oomoo`3_Ool3000>Ool001MooaD000030n`000000=P000Qoo`03001oogoo00ioo`007Goo00<007oo
Ool03Goo00<3k7ooOol02goo00<007ooOol077oo00<007ooOol06goo00<007ooOol06goo00<007oo
Ool077oo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol03Woo000MOol0
0`00Oomoo`0>Ool00`?/Oomoo`3NOol00`00Oomoo`0>Ool001eoo`03001oogoo00moo`030naoogoo
0=ioo`@000aoo`007Goo0P004Goo00<3k7ooOol0kGoo000MOol00`00Oomoo`0AOol00`?/Oomoo`3/
Ool001eoo`03001oogoo015oo`030naoogoo0>aoo`007Goo00<007ooOol04Woo00<3k7ooOol0jgoo
000MOol2000DOol00`?/Oomoo`3ZOol001eoo`03001oogoo01Aoo`030naoogoo0>Uoo`007Goo00<0
07ooOol05Goo00<3k7ooOol0j7oo000MOol00`00Oomoo`0FOol00`?/Oomoo`3WOol001eoo`8001Qo
o`030naoogoo0>Ioo`007Goo00<007ooOol05goo00<Gh0?/Ool0iWoo000MOol00`00Oomoo`0HOol0
0aOP0naoo`3UOol001eoo`03001oogoo01Uoo`035n03k7oo0>Aoo`007Goo0P006goo00<3k7ooOol0
hgoo000MOol00`00Oomoo`0KOol00`?/Oomoo`3ROol000Uoo`D0009oo`8000Aoo`8000Eoo`03001o
ogoo01aoo`030naoogoo0>5oo`002goo00<007ooOol01goo00@007ooOol000Aoo`03001oogoo01ao
o`035n03k7oo0>5oo`002goo00<007ooOol02Woo00<007ooOol00Woo0`007Goo00<Gh0?/Ool0h7oo
000;Ool00`00Oomoo`08Ool20005Ool00`00Oomoo`0NOol00aOP0naoo`3OOol000]oo`03001oogoo
00Qoo`03001oogoo00Aoo`03001oogoo01moo`035n03k7oo0=ioo`002Woo0P002Woo0`0017oo00<0
07ooOol087oo00<Gh0?/Ool0gGoo000MOol2000ROol00aOP0naoo`3LOol001eoo`03001oogoo029o
o`035n03k7oo0=]oo`007Goo00<007ooOol08goo00=l00?/Ool0fWoo000MOol00`00Oomoo`0TOol0
0g`00naoo`3IOol001eoo`8002Ioo`03O003k7oo0=Qoo`007Goo00<007ooOol09Woo00=l00?/Ool0
egoo000MOol00`00Oomoo`0WOol00g`00naoo`3FOol001eoo`03001oogoo02Qoo`03O003k7oo0=Eo
o`007Goo0P00:Woo00=l00?/Ool0e7oo000MOol00`00Oomoo`0ZOol00g`00n`3k03COol001eoo`03
001oogoo02]oo`03O01n@0?/0=9oo`007Goo00<007ooOol0;Goo00=n@0?/Ool0d7oo000MOol2000_
Ool00gi00naoo`3?Ool001eoo`03001oogoo02moo`03OT03k7oo0<ioo`007Goo00<007ooOol0<7oo
00=n@0?/0n`0cGoo000EOol40004Ool00`00Oomoo`0aOol00gi05n03k03<Ool001Eoo`03001oogoo
00Eoo`03001oogoo039oo`03O00Gh0?/0<]oo`005Woo00<007ooOol017oo0`00<goo00Al07i00n`3
k<Uoo`005goo00<007ooOol00goo00<007ooOol0=Goo00=n@1OP0n`0b7oo000EOol01000Oomoo`00
17oo00<007ooOol0=Woo00=l01OP0n`0agoo000FOol20005Ool00`00Oomoo`0gOol00g`05n03k036
Ool001eoo`8003Uoo`04O00Gh0?/0nc4Ool001eoo`03001oogoo03Uoo`04O01n@1OP0nc3Ool001eo
o`03001oogoo03Yoo`9l00035n03k7oo0<5oo`007Goo00<007ooOol0?7oo00Al07i00n`3k<1oo`00
7Goo0P00?Woo00Al07i05n03k;moo`007Goo00<007ooOol0?Woo0W`000=n@0?/Ool0_Goo000MOol0
0`00Oomoo`10Ool017`0OT03k0?/_7oo000MOol00`00Oomoo`11Ool017`0OT1Wh0?/^goo000MOol2
0013Ool00g`0Oomn@0020nbiOol001eoo`03001oogoo04=oo`9l0003OT1Wh0?/0;Qoo`007Goo00<0
07ooOol0AGoo00=l07ooIn000P?/]Woo000MOol00`00Oomoo`16Ool01G`0Oomn@6OP0n`0]Goo000M
Ool20018Ool2O00017ooIn03k0?//goo000MOol00`00Oomoo`19Ool01G`0OomWh6OP0n`0/Woo0009
Ool40003Ool20004Ool20005Ool00`00Oomoo`1:Ool017`0OomoofOP0P?//7oo0009Ool00`00Oomo
o`09Ool01000Oomoo`0017oo00<007ooOol0Bgoo0W`000AoofOPIn03k:moo`002Woo00<007ooOol0
2goo00<007ooOol00Woo0`00CGoo00Al07ooOomWh083k:eoo`002goo00<007ooOol027oo0P001Goo
00<007ooOol0CWoo0W`000AoofOPIn03k:aoo`002Goo00@007ooOol000Uoo`03001oogoo00Aoo`03
001oogoo051oo`04O01oogooIn020nbZOol000Yoo`8000Yoo`<000Aoo`03001oogoo055oo`9l0003
OomWh6OP0083k:Qoo`007Goo0P00E7oo00El07ooOomWh1OP0083k:Ioo`007Goo00<007ooOol0E7oo
0W`000Aoogi0In0Gh083k:Aoo`007Goo00<007ooOol0EWoo00Al07ooOomn@08Gh0030naoogoo0:5o
o`007Goo00<007ooOol0Egoo0W`000Aoogi0OT0Gh083k:5oo`007Goo0P00FWoo00Al07ooOomn@08G
h0030naoogoo09ioo`007Goo00<007ooOol0FWoo0W`000Aoogi0OT0Gh083k9ioo`007Goo00<007oo
Ool0G7oo00Ml07ooOomn@6OP5n03k02MOol001eoo`03001oogoo05eoo`9l009oo`04OT1Wh0?/0nbK
Ool001eoo`80061oo`04O01oogooOol2In000`?/Oomoo`2HOol001eoo`03001oogoo061oo`9l00=o
o`03In03k0?/09Qoo`007Goo00<007ooOol0HWoo00Al07ooOomoo`9Wh083k9Ioo`007Goo00<007oo
Ool0Hgoo0W`00goo0VOP0P?/U7oo000MOol00`00Oomoo`1UOol01G`0OomoogooOT000VOP0P?/TWoo
000MOol2001WOol2O003Ool017i0In1Wh0?/TGoo000MOol00`00Oomoo`1XOol2O002Ool2OT000fOP
0n`3k02?Ool001Ioo`8000Eoo`03001oogoo06Yoo`9l009oo`03OT1Wh6OP0083k8eoo`005Goo00@0
07ooOol000Aoo`03001oogoo06aoo`9l0005Oomn@7i0In0Gh0020nb;Ool001Moo`03001oogoo00=o
o`<006ioo`03O01oogoo009n@004In0Gh0?/0nb9Ool001Qoo`03001oogoo009oo`03001oogoo06mo
o`9l009oo`9n@004In0Gh0?/0nb7Ool001Eoo`04001oogoo0004Ool00`00Oomoo`1aOol017`0Oomo
ogoo0Wi00QOP0P?/QGoo000FOol20005Ool00`00Oomoo`1bOol2O003Ool2OT025n020nb3Ool001eo
o`8007Eoo`9l00=oo`9n@08Gh083k85oo`007Goo00<007ooOol0MWoo00=l07ooOol00Woo0Wi00QOP
0P?/Ogoo000MOol00`00Oomoo`1gOol2O004Ool2OT025n020namOol001eoo`03001oogoo07Uoo`9l
00Aoo`04OT1Wh1OP5n020nakOol001eoo`8007aoo`9l00=oo`9n@003In0Gh1OP0083k7Uoo`007Goo
00<007ooOol0OGoo0W`00goo0Wi000=Wh1OP5n000P?/Mgoo000MOol00`00Oomoo`1oOol00g`0Oomo
o`02Ool2OT000fOP5n0Gh0020naeOol001eoo`03001oogoo081oo`9l00Aoo`9n@003In0Gh1OP0083
k7=oo`007Goo0P00Pgoo0W`017oo00=n@7ooIn000QOP0P?/LGoo000MOol00`00Oomoo`24Ool2O003
Ool2OT0017ooIn0Gh1OP0P?/Kgoo000MOol00`00Oomoo`26Ool2O003Ool2OT0017ooIn0Gh1OP0P?/
KGoo000MOol00`00Oomoo`28Ool00g`0Oomoo`02Ool2OT0017ooIn0Gh1OP0P?/Jgoo000MOol2002:
Ool2O004Ool2OT0017ooIn0Gh1OP0P?/JGoo000MOol00`00Oomoo`2;Ool2O004Ool2OT0017ooIn0G
h1OP0P?/Igoo000:Ool20004Ool20004Ool20005Ool00`00Oomoo`2=Ool2O004Ool2OT0017ooIn0G
h1OP0P?/IGoo0009Ool01000Oomoo`0027oo00@007ooOol000Aoo`03001oogoo08moo`9l00Aoo`9n
@004OomWh1OP5n020naSOol000]oo`03001oogoo00Yoo`03001oogoo009oo`<0095oo`03O01oogoo
00=oo`9n@004OomWh1OP5n020naQOol000aoo`03001oogoo00Moo`8000Eoo`03001oogoo099oo`9l
00Eoo`9n@09Wh08Gh083k5moo`002Goo00@007ooOol000Uoo`03001oogoo00Aoo`03001oogoo09Ao
o`9l00Eoo`9n@09Wh08Gh0<3k5aoo`002Woo0P002Woo0`0017oo00<007ooOol0UWoo0W`01Goo0Wi0
0VOP0aOP0P?/FWoo000MOol2002IOol2O005Ool2OT03In025n020naHOol001eoo`03001oogoo09Yo
o`03O01oogoo00Aoo`9n@003OomWh6OP008Gh083k5Ioo`007Goo00<007ooOol0Vgoo0W`01Woo0Wi0
00=oofOPIn000QOP0`?/Dgoo000MOol00`00Oomoo`2MOol2O006Ool2OT000gooIn1Wh0035n020naA
Ool001eoo`800:1oo`9l00Ioo`9n@004OomWh6OPIn025n020na?Ool001eoo`03001oogoo0:5oo`9l
00Ioo`9n@09oo`9Wh08Gh083k4eoo`007Goo00<007ooOol0Xgoo0W`01Woo0Wi00Woo0VOP0QOP0`?/
BWoo000MOol00`00Oomoo`2UOol2O006Ool2OT02Ool2In035n020na8Ool001eoo`800:Qoo`9l00Io
o`9n@09oo`=Wh08Gh083k4Ioo`007Goo00<007ooOol0ZGoo0W`01Woo0Wi00goo0VOP0QOP0P?/A7oo
000MOol00`00Oomoo`2[Ool2O006Ool3OT02Ool2In025n030na1Ool001eoo`03001oogoo0:eoo`9l
00Moo`9n@09oo`9Wh0<Gh083k3moo`007Goo00<007ooOol0[goo0W`01goo0Wi00Woo0fOP0QOP0P?/
?Goo000MOol2002bOol2O007Ool2OT03Ool2In025n020n`kOol001eoo`03001oogoo0;=oo`=l00Io
o`=n@09oo`9Wh08Gh0<3k3Qoo`005goo0`000goo00<007ooOol0]Woo0W`01goo0Wi00Woo0VOP0aOP
0P?/=Woo000HOol00`00Oomoo`02Ool00`00Oomoo`2hOol2O007Ool2OT02Ool3In025n020n`dOol0
01Eoo`D000=oo`<00;Yoo`9l00Moo`9n@0=oo`9Wh004OolGh0?/0n`bOol001Eoo`04001oogoo0004
Ool00`00Oomoo`2lOol3O006Ool3OT02Ool2In02Ool30n`_Ool001Ioo`03001oo`0000Aoo`03001o
ogoo0;moo`9l00Moo`=n@003OomWh6OP00=oo`<3k2aoo`005goo0P0017oo00<007ooOol0`Goo0W`0
27oo0gi00fOP0Woo00@Gh0?/0n`3k2Uoo`007Goo0P00a7oo0W`02Goo0gi00fOP00=ooaOP5n000P?/
9goo000MOol00`00Oomoo`35Ool3O009Ool2OT0017ooIn1Wh6OP0QOP0P?/9Goo000MOol00`00Oomo
o`38Ool2O009Ool2OT02Ool2In025n020n`SOol001eoo`03001oogoo0<Yoo`9l00Uoo`9n@09oo`9W
h08Gh083k25oo`007Goo0P00cGoo0W`02Goo0Wi00Woo0VOP0QOP0P?/7goo000MOol00`00Oomoo`3>
Ool3O008Ool2OT02Ool2In025n0OOol001eoo`03001oogoo0=5oo`9l00Qoo`9n@09oo`9Wh1moo`00
7Goo00<007ooOol0dgoo0W`027oo0Wi08Goo000MOol2003FOol2O008Ool2OT0OOol001eoo`03001o
ogoo0=Moo`9l02Moo`007Goo00<007ooOol0fGoo0W`09Goo000MOol00`00Oomoo`3KOol2O00SOol0
01eoo`800=ioo`9l025oo`007Goo00<007ooOol0ggoo0W`07goo000;Ool30002Ool20004Ool20005
Ool00`00Oomoo`3oOol1Ool000aoo`03001oogoo00Ioo`04001oogoo0004Ool00`00Oomoo`3oOol1
Ool000Uoo`D000Yoo`03001oogoo009oo`<00?moo`5oo`002Goo00@007ooOol000Uoo`8000Eoo`03
001oogoo0?moo`5oo`002Woo00<007oo00002Goo00<007ooOol0ogoo27oo000;Ool20009Ool3003o
Ool8Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001moo`80
0?moo`0087oo00<007ooOol0oGoo000IOol30004Ool00`00Oomoo`3mOol001Yoo`03001oogoo009o
o`800?moo`006Woo00<007ooOol0ogoo17oo000JOol2003oOol5Ool001Yoo`04001oogoo003oOol3
Ool001Uoo`D00?moo`=oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.94808, 0.708104, \
0.0659933, 0.0243595}}]
}, Open  ]],

Cell[TextData[
"We observe again the same behavior as in the case of the \[Alpha] variation. \
However, the decrease in the solution is much smaller by changing the \
strength of the non-linearity."], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"Atomic.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{676, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->355,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Molecular Beam Epitaxy"->{
    Cell[1739, 51, 367, 5, 41, "Subsection",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 76}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Molecular Beam Epitaxy"]},
  "growth equations of molecular beam epitaxy"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "microscopic processes"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "crystal interface"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "deposition"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "desorption"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}],
    Cell[6919, 170, 1447, 34, 129, "Text",
      CellTags->{"desorption", "chemical potential"}],
    Cell[76539, 2582, 214, 4, 44, "Text",
      CellTags->"desorption"]},
  "surface diffusion"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}],
    Cell[3597, 82, 345, 7, 61, "Text",
      CellTags->"surface diffusion"],
    Cell[16586, 457, 430, 13, 44, "Text",
      CellTags->"surface diffusion"]},
  "atomic deposition"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "bonds"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "activated process"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}],
    Cell[4785, 114, 1329, 33, 112, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}]},
  "excess energy"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "lattice potential"->{
    Cell[2109, 58, 1485, 22, 180, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "interface amplitude"->{
    Cell[4056, 95, 571, 12, 78, "Text",
      CellTags->{
      "interface amplitude", "macroscopic current", "surface", 
        "continuity equation"}]},
  "macroscopic current"->{
    Cell[4056, 95, 571, 12, 78, "Text",
      CellTags->{
      "interface amplitude", "macroscopic current", "surface", 
        "continuity equation"}]},
  "surface"->{
    Cell[4056, 95, 571, 12, 78, "Text",
      CellTags->{
      "interface amplitude", "macroscopic current", "surface", 
        "continuity equation"}]},
  "continuity equation"->{
    Cell[4056, 95, 571, 12, 78, "Text",
      CellTags->{
      "interface amplitude", "macroscopic current", "surface", 
        "continuity equation"}]},
  "surface current"->{
    Cell[4785, 114, 1329, 33, 112, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}]},
  "chemical potential"->{
    Cell[4785, 114, 1329, 33, 112, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}],
    Cell[6919, 170, 1447, 34, 129, "Text",
      CellTags->{"desorption", "chemical potential"}]},
  "mobility"->{
    Cell[4785, 114, 1329, 33, 112, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}]},
  "Laplacian"->{
    Cell[4785, 114, 1329, 33, 112, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}]},
  "intensity"->{
    Cell[6269, 154, 485, 9, 78, "Text",
      CellTags->"intensity"]},
  "growth of interfaces"->{
    Cell[9122, 229, 370, 6, 61, "Text",
      CellTags->"growth of interfaces"]},
  "nonlinearity"->{
    Cell[9495, 237, 465, 9, 61, "Text",
      CellTags->{"nonlinearity", "growth equation"}]},
  "growth equation"->{
    Cell[9495, 237, 465, 9, 61, "Text",
      CellTags->{"nonlinearity", "growth equation"}]},
  "eq-7"->{
    Cell[9963, 248, 417, 10, 22, "NumberedEquation",
      CellTags->"eq-7"]},
  "symmetries"->{
    Cell[11756, 304, 201, 4, 27, "Text",
      CellTags->"symmetries"],
    Cell[15232, 411, 93, 1, 27, "Text",
      CellTags->"symmetries"],
    Cell[77250, 2607, 377, 6, 61, "Text",
      CellTags->"symmetries"]},
  "reduction"->{
    Cell[12637, 337, 188, 5, 44, "Text",
      CellTags->"reduction"],
    Cell[79883, 2687, 81, 1, 27, "Text",
      CellTags->"reduction"]},
  "Surface Diffusion with Nonlinearity"->{
    Cell[16463, 454, 120, 1, 31, "Subsubsection",
      CellTags->"Surface Diffusion with Nonlinearity"]},
  "symmetry group"->{
    Cell[17562, 492, 86, 1, 27, "Text",
      CellTags->"symmetry group"]},
  "scaling group"->{
    Cell[18655, 532, 124, 4, 27, "Text",
      CellTags->"scaling group"]},
  "numerical solution"->{
    Cell[22455, 639, 238, 6, 46, "Text",
      CellTags->"numerical solution"]},
  "Desorption with Nonlinearity"->{
    Cell[76429, 2579, 107, 1, 31, "Subsubsection",
      CellTags->"Desorption with Nonlinearity"]},
  "infinitesimals"->{
    Cell[79129, 2666, 370, 6, 61, "Text",
      CellTags->"infinitesimals"]},
  "similarity reduction"->{
    Cell[81796, 2738, 539, 11, 63, "Text",
      CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}]},
  "DSolve[]"->{
    Cell[81796, 2738, 539, 11, 63, "Text",
      CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}]},
  "point symmetry"->{
    Cell[81796, 2738, 539, 11, 63, "Text",
      CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}]},
  "numerical integration"->{
    Cell[82979, 2775, 204, 5, 44, "Text",
      CellTags->"numerical integration"]},
  "nonlinear strength"->{
    Cell[101347, 3429, 467, 7, 78, "Text",
      CellTags->"nonlinear strength"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Molecular Beam Epitaxy", 122193, 4142},
  {"growth equations of molecular beam epitaxy", 122572, 4149},
  {"microscopic processes", 122927, 4156},
  {"crystal interface", 123278, 4163},
  {"deposition", 123622, 4170},
  {"desorption", 123966, 4177},
  {"surface diffusion", 124488, 4188},
  {"atomic deposition", 124996, 4199},
  {"bonds", 125335, 4206},
  {"activated process", 125686, 4213},
  {"excess energy", 126198, 4224},
  {"lattice potential", 126549, 4231},
  {"interface amplitude", 126902, 4238},
  {"macroscopic current", 127085, 4243},
  {"surface", 127256, 4248},
  {"continuity equation", 127439, 4253},
  {"surface current", 127618, 4258},
  {"chemical potential", 127810, 4263},
  {"mobility", 128090, 4270},
  {"Laplacian", 128273, 4275},
  {"intensity", 128456, 4280},
  {"growth of interfaces", 128555, 4283},
  {"nonlinearity", 128657, 4286},
  {"growth equation", 128775, 4289},
  {"eq-7", 128882, 4292},
  {"symmetries", 128979, 4295},
  {"reduction", 129213, 4302},
  {"Surface Diffusion with Nonlinearity", 129399, 4307},
  {"symmetry group", 129528, 4310},
  {"scaling group", 129625, 4313},
  {"numerical solution", 129727, 4316},
  {"Desorption with Nonlinearity", 129844, 4319},
  {"infinitesimals", 129967, 4322},
  {"similarity reduction", 130073, 4325},
  {"DSolve[]", 130206, 4328},
  {"point symmetry", 130345, 4331},
  {"numerical integration", 130491, 4334},
  {"nonlinear strength", 130602, 4337}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 367, 5, 41, "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 76}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Molecular Beam Epitaxy"],
Cell[2109, 58, 1485, 22, 180, "Text",
  CellTags->{
  "growth equations of molecular beam epitaxy", "microscopic processes", 
    "crystal interface", "deposition", "desorption", "surface diffusion", 
    "atomic deposition", "bonds", "activated process", "excess energy", 
    "lattice potential"}],
Cell[3597, 82, 345, 7, 61, "Text",
  CellTags->"surface diffusion"],
Cell[3945, 91, 108, 2, 22, "NumberedEquation"],
Cell[4056, 95, 571, 12, 78, "Text",
  CellTags->{
  "interface amplitude", "macroscopic current", "surface", 
    "continuity equation"}],
Cell[4630, 109, 152, 3, 25, "NumberedEquation"],
Cell[4785, 114, 1329, 33, 112, "Text",
  CellTags->{
  "surface current", "chemical potential", "activated process", "mobility", 
    "Laplacian"}],
Cell[6117, 149, 149, 3, 22, "NumberedEquation"],
Cell[6269, 154, 485, 9, 78, "Text",
  CellTags->"intensity"],
Cell[6757, 165, 159, 3, 22, "NumberedEquation"],
Cell[6919, 170, 1447, 34, 129, "Text",
  CellTags->{"desorption", "chemical potential"}],
Cell[8369, 206, 232, 4, 22, "NumberedEquation"],
Cell[8604, 212, 301, 9, 27, "Text"],
Cell[8908, 223, 211, 4, 22, "NumberedEquation"],
Cell[9122, 229, 370, 6, 61, "Text",
  CellTags->"growth of interfaces"],
Cell[9495, 237, 465, 9, 61, "Text",
  CellTags->{"nonlinearity", "growth equation"}],
Cell[9963, 248, 417, 10, 22, "NumberedEquation",
  CellTags->"eq-7"],
Cell[10383, 260, 386, 8, 61, "Text"],
Cell[10772, 270, 50, 1, 23, "Input"],
Cell[10825, 273, 93, 4, 27, "Text"],

Cell[CellGroupData[{
Cell[10943, 281, 329, 6, 23, "Input"],
Cell[11275, 289, 466, 12, 24, "Output"]
}, Open  ]],
Cell[11756, 304, 201, 4, 27, "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{
Cell[11982, 312, 169, 4, 23, "Input"],
Cell[12154, 318, 468, 16, 44, "Output"]
}, Open  ]],
Cell[12637, 337, 188, 5, 44, "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{
Cell[12850, 346, 141, 2, 23, "Input"],
Cell[12994, 350, 1152, 26, 64, "Output"]
}, Open  ]],
Cell[14161, 379, 148, 3, 44, "Text"],

Cell[CellGroupData[{
Cell[14334, 386, 257, 5, 50, "Input"],
Cell[14594, 393, 623, 15, 38, "Output"]
}, Open  ]],
Cell[15232, 411, 93, 1, 27, "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{
Cell[15350, 416, 274, 6, 39, "Input"],
Cell[15627, 424, 431, 14, 32, "Output"]
}, Open  ]],
Cell[16073, 441, 134, 3, 27, "Text"],
Cell[16210, 446, 228, 4, 44, "Text"],

Cell[CellGroupData[{
Cell[16463, 454, 120, 1, 31, "Subsubsection",
  CellTags->"Surface Diffusion with Nonlinearity"],
Cell[16586, 457, 430, 13, 44, "Text",
  CellTags->"surface diffusion"],

Cell[CellGroupData[{
Cell[17041, 474, 115, 2, 23, "Input"],
Cell[17159, 478, 388, 11, 24, "Output"]
}, Open  ]],
Cell[17562, 492, 86, 1, 27, "Text",
  CellTags->"symmetry group"],

Cell[CellGroupData[{
Cell[17673, 497, 142, 3, 23, "Input"],
Cell[17818, 502, 822, 27, 58, "Output"]
}, Open  ]],
Cell[18655, 532, 124, 4, 27, "Text",
  CellTags->"scaling group"],

Cell[CellGroupData[{
Cell[18804, 540, 210, 4, 39, "Input"],
Cell[19017, 546, 65, 1, 32, "Output"]
}, Open  ]],
Cell[19097, 550, 105, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[19227, 557, 250, 5, 23, "Input"],
Cell[19480, 564, 1335, 31, 76, "Output"]
}, Open  ]],
Cell[20830, 598, 543, 12, 78, "Text"],
Cell[21376, 612, 1076, 25, 23, "Input"],
Cell[22455, 639, 238, 6, 46, "Text",
  CellTags->"numerical solution"],
Cell[22696, 647, 147, 3, 23, "Input"],
Cell[22846, 652, 50, 0, 27, "Text"],
Cell[22899, 654, 100, 2, 23, "Input"],

Cell[CellGroupData[{
Cell[23024, 660, 183, 3, 23, "Input"],
Cell[23210, 665, 28206, 1065, 166, 14169, 887, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[51431, 1733, 156, 2, 27, "Text"],
Cell[51590, 1737, 1076, 25, 23, "Input"],
Cell[52669, 1764, 143, 3, 23, "Input"],
Cell[52815, 1769, 72, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[52912, 1773, 183, 3, 23, "Input"],
Cell[53098, 1778, 22910, 788, 160, 10207, 627, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[76023, 2569, 369, 5, 61, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76429, 2579, 107, 1, 31, "Subsubsection",
  CellTags->"Desorption with Nonlinearity"],
Cell[76539, 2582, 214, 4, 44, "Text",
  CellTags->"desorption"],

Cell[CellGroupData[{
Cell[76778, 2590, 114, 2, 23, "Input"],
Cell[76895, 2594, 340, 10, 24, "Output"]
}, Open  ]],
Cell[77250, 2607, 377, 6, 61, "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{
Cell[77652, 2617, 145, 3, 23, "Input"],
Cell[77800, 2622, 1314, 41, 86, "Output"]
}, Open  ]],
Cell[79129, 2666, 370, 6, 61, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[79524, 2676, 210, 4, 39, "Input"],
Cell[79737, 2682, 131, 2, 34, "Output"]
}, Open  ]],
Cell[79883, 2687, 81, 1, 27, "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{
Cell[79989, 2692, 250, 5, 23, "Input"],
Cell[80242, 2699, 1539, 36, 92, "Output"]
}, Open  ]],
Cell[81796, 2738, 539, 11, 63, "Text",
  CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}],

Cell[CellGroupData[{
Cell[82360, 2753, 223, 4, 23, "Input"],
Cell[82586, 2759, 378, 13, 32, "Output"]
}, Open  ]],
Cell[82979, 2775, 204, 5, 44, "Text",
  CellTags->"numerical integration"],
Cell[83186, 2782, 563, 13, 23, "Input"],
Cell[83752, 2797, 185, 3, 44, "Text"],
Cell[83940, 2802, 149, 3, 23, "Input"],
Cell[84092, 2807, 127, 2, 27, "Text"],

Cell[CellGroupData[{
Cell[84244, 2813, 212, 3, 39, "Input"],
Cell[84459, 2818, 16873, 608, 186, 8160, 496, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[101347, 3429, 467, 7, 78, "Text",
  CellTags->"nonlinear strength"],
Cell[101817, 3438, 562, 13, 23, "Input"],
Cell[102382, 3453, 105, 2, 27, "Text"],
Cell[102490, 3457, 150, 3, 23, "Input"],
Cell[102643, 3462, 59, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[102727, 3466, 212, 3, 39, "Input"],
Cell[102942, 3471, 17308, 613, 186, 8162, 496, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[120265, 4087, 208, 3, 44, "Text"],
Cell[120476, 4092, 146, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

