(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    288688,      10938]*)
(*NotebookOutlinePosition[    294258,      11095]*)
(*  CellTagsIndexPosition[    293439,      11071]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.5 Stokes' Solution of the Creeping Flow", "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 60}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Stokes' Solution of the Creeping Flow"],

Cell[TextData[{
  "Let us consider the creeping motion of a fluid stream of speed ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  " around a solid sphere of radius ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ". The physical situation is shown in the following figure."
}], "Text",
  CellTags->"creeping motion of a fluid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.455556 0.126984 0.397778 0.126984 [
[.02381 .39778 -5 -7.5 ]
[.02381 .39778 5 7.5 ]
[.45556 .56286 -11 -7.5 ]
[.45556 .56286 11 7.5 ]
[.60794 .49937 -5 -7.5 ]
[.60794 .49937 5 7.5 ]
[.45556 .01683 -53.5 -7.5 ]
[.45556 .01683 53.5 7.5 ]
[.60794 .43587 -5 -7.5 ]
[.60794 .43587 5 7.5 ]
[.81111 .53746 -7.5 -7.5 ]
[.81111 .53746 7.5 7.5 ]
[.64603 .68984 -7.5 -7.5 ]
[.64603 .68984 7.5 7.5 ]
[ 0 0 0 0 ]
[ 1 .70667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
.0746 .14381 m
.20159 .14381 L
s
% Start of user PostScript
-3. -2. -2. -2. MAarrowhead1
% End of user PostScript
.0746 .2073 m
.20159 .2073 L
s
% Start of user PostScript
-3. -1.5 -2. -1.5 MAarrowhead1
% End of user PostScript
.0746 .27079 m
.20159 .27079 L
s
% Start of user PostScript
-3. -1. -2. -1. MAarrowhead1
% End of user PostScript
.0746 .33429 m
.20159 .33429 L
s
% Start of user PostScript
-3. -0.5 -2. -0.5 MAarrowhead1
% End of user PostScript
.0746 .39778 m
.20159 .39778 L
s
% Start of user PostScript
-3. 0 -2. 0 MAarrowhead1
% End of user PostScript
.0746 .46127 m
.20159 .46127 L
s
% Start of user PostScript
-3. 0.5 -2. 0.5 MAarrowhead1
% End of user PostScript
.0746 .52476 m
.20159 .52476 L
s
% Start of user PostScript
-3. 1. -2. 1. MAarrowhead1
% End of user PostScript
.0746 .58825 m
.20159 .58825 L
s
% Start of user PostScript
-3. 1.5 -2. 1.5 MAarrowhead1
% End of user PostScript
1 0 0 r
.45556 .39778 m
.45556 .39778 .12698 0 365.73 arc
F
0 g
.45556 .39778 m
.83651 .39778 L
s
.45556 .39778 m
.70952 .52476 L
s
% Start of user PostScript
0 0 2. 1. MAarrowhead1
% End of user PostScript
.72222 .52603 m
.97619 .66444 L
s
% Start of user PostScript
2.1 1.01 4.1 2.1 MAarrowhead1
% End of user PostScript
.72222 .52603 m
.64603 .65175 L
s
% Start of user PostScript
2.1 1.01 1.5 2. MAarrowhead1
% End of user PostScript
gsave
.02381 .39778 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(U) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.45556 .56286 -72 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(r) show
69.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(a) show
81.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
gsave
.60794 .49937 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(r) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.45556 .01683 -114.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Coordinate) show
129.000000 14.437500 moveto
(system) show
165.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.60794 .43587 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(q) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
gsave
.81111 .53746 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(r) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.64603 .68984 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 16.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(q) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
0 0 m
1 0 L
1 .70667 L
0 .70667 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{216, 159.5},
  ImageMargins->{{55.3125, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  FontSize->8,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003H0000Wa000`40O003h00Of7oo003HOol00=Qo
o`00f7oo001gOol2001OOol007Qoo`03001oogoo05eoo`00<7oo0`000goo0P0017oo0P000goo1000
0goo10000Woo0`0000=oo`0000000Woo0P0000=oo`0000000`000Woo0P0017oo0`0027oo0`001Goo
00@007ooOomoo`<000Aoo`8000Aoo`<00007Ool00000Ool007oo0000A7oo000_Ool00`00Oomoo`03
Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo009oo`04001oogoo0004Ool01@00Oomo
ogoo00000Woo00<007ooOol010000Woo00@007ooOol0009oo`03001oogoo00aoo`07001oogooOol0
07oo00001Goo00@007ooOol0009oo`04001oogoo0005Ool01@00Ool007oo0000A7oo000_Ool00`00
Oomoo`03Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo009oo`04001oogoo0004Ool0
1@00Oomoogoo00000Woo00<007ooOol00goo00@007ooOol000Eoo`@000Qoo`<000=oo`04001oogoo
0002Ool30003Ool00`00Oomoo`03Ool40002Ool01@00Ool007oo0000A7oo000_Ool00`00Oomoo`04
Ool20004Ool20003Ool40003Ool30003Ool20002Ool40004Ool300000goo000000030003Ool20009
Ool400001Goo00000000Ool00P0000=oo`0000000P0000=oo`0000000`000goo0P000Woo0`0000=o
o`00Ool0A7oo000_Ool01000Oomoo`005goo00<007ooOol04Woo00<007ooOol08Goo00<007ooOol0
DWoo000`Ool3000FOol20004Ool00`00Oomoo`26Ool00=Qoo`00f7oo003HOol00=Qoo`00f7oo003H
Ool00=Qoo`00f7oo003HOol00=Qoo`00f7oo003HOol00=Qoo`00f7oo003HOol00=Qoo`00f7oo003H
Ool00=Qoo`00f7oo000QOol2002eOol0025oo`D00;9oo`008Goo2@00[Woo000@OolL002/Ool0025o
o`P00:moo`008Goo0`00]7oo003HOol00=Qoo`00f7oo003HOol00=Qoo`00f7oo003HOol0025oo`80
0;Eoo`008Goo1@00/Woo000QOol9002^Ool0011ooa`00:aoo`008Goo2@00[Woo000QOol6002aOol0
025oo`800;Eoo`00f7oo003HOol00=Qoo`00f7oo003HOol00=Qoo`00f7oo000QOol2002eOol0025o
o`D00;9oo`008Goo2@00[Woo000@OolL002/Ool0025oo`P0031ooa1l06moo`008Goo0`00<Woo5G`0
KGoo001DOolJO01ZOol005=ooael06Qoo`00DWoo7g`0Igoo001@OolRO01VOol004moobEl06Aoo`00
CWoo9g`0Hgoo001=OolYO01ROol004aoob]l065oo`008Goo0`009goo;G`0H7oo000QOol8000ROol]
O01POol0011ooa`001ioobml05moo`008Goo2@0087oo;g`0Ggoo000QOol6000ROolaO01NOol0025o
o`8002Iooc5l05ioo`00B7oo<W`0GWoo0018OolcO01MOol004MoocAl05eoo`00Agoo=G`0G7oo0017
OoleO01LOol004MoocEl05aoo`00Agoo=G`0G7oo000QOol2000TOoleO01LOol000Eoo`8001Yoo`D0
021oocIl05aoo`0017oo00@007ooOol001Uoo`T001aoocMl05]oo`0017oo00@007ooOol000Qooa`0
01Yooaal058002Aoo`0017oo00@007ooOol001Uoo`P001eooael008001Ql05]oo`0017oo00@007oo
Ool001Uoo`<0029ooaml008001El05aoo`000goo0P0000Aoo`00000003ioob1l008001=l05aoo`00
Agoo8W`00P004G`0G7oo0017OolTO002000?O01LOol004MoobIl008000el00Aoo`<005Eoo`00Agoo
:7`00P002W`017oo00D007ooOomoo`0005Aoo`00B7oo:G`00P0027`017oo00<007ooOol00Woo00<0
07ooOol0DGoo0018Ool[O0020006O004Ool6001COol004Uoobal008000=l00Ioo`05001oogooOol0
001COol0025oo`<002Eoobil00800003O01oogoo00Eoo`<005Aoo`008Goo200087oo<7`00P00GGoo
000@OolL000NOol_O002Ool2001KOol0025oo`T0021oobml00Aoo`8005Uoo`008Goo1P0097oo;G`0
1goo0P00Egoo000QOol2000YOol[O00:Ool2001EOol004eoobUl00eoo`8005=oo`00CWoo9g`047oo
0P00DGoo001?OolUO00<Ool40003Ool2001?Ool0051oob=l00ioo`03001oogoo00Eoo`8000Aoo`03
001oogoo04Ioo`00DGoo8G`03goo00<007ooOol01goo0P0000Aoo`00000004Moo`00DWoo7W`047oo
10002Goo1P00AGoo001DOolKO00NOol70014Ool0025oo`8003=ooaQl01moo`P004=oo`008Goo1@00
<goo4W`097oo2000@Goo000QOol9000aOol>O00ZOol5000GOol2000WOol0011ooa`0039oo`Il03=o
o`800003Ool007oo01=oo`03001oogoo02Ioo`008Goo2000L7oo00@007oo000000eoo`@00004Ool0
0000000VOol0025oo`<007Eoo`04001oogooOol2000:Ool01000Oomoo`00:goo002HOol00`00Oomo
o`04Ool20008Ool01000Oomoo`00:goo002HOol00`00Oomoo`06Ool20005Ool200000goo0000000[
Ool009Moo`03001oogoo00Uoo`8003=oo`00FWoo10000Woo10000Woo1@00:goo00<007ooOol037oo
00<007ooOol0<7oo001KOol00`00Oomoo`08Ool4000/Ool00`00Oomoo`0=Ool2000`Ool005]oo`03
001oogoo009oo`@000Eoo`03001oogoo02Uoo`03001oogoo011oo`8002ioo`00FWoo10002Goo0`00
:goo00<007ooOol04Woo0P00;7oo002DOol00`00Oomoo`0EOol2000ZOol0025oo`<006moo`03001o
ogoo01Qoo`8002Qoo`008Goo2000JWoo00<007ooOol06Woo00<007ooOol09Goo000@OolL001VOol0
0`00Oomoo`0LOol2000UOol0025oo`T006Qoo`03001oogoo01ioo`8002=oo`008Goo1P00JWoo00<0
07ooOol08Goo0P008Goo000QOol2001ZOol01@00Oomoogoo00009Goo0P007goo002=Ool4000XOol2
000MOol008aoo`H002Uoo`03001oogoo01Yoo`00S7oo1`00:Goo0P006Woo002<Ool6000/Ool2000H
Ool008aoo`D002moo`8001Ioo`00Rgoo1@00<Woo0P0017oo00<007ooOol03Goo002;Ool4000eOol2
0002Ool2000>Ool008]oo`<003Qoo`D000eoo`00Rgoo0P00>Woo1@0037oo002:Ool2000jOol8000:
Ool008Yoo`03001oogoo03Uoo`T000Uoo`00b7oo200027oo003<Ool50007Ool00=1oo`8000Ioo`00
Rgoo0`00BWoo002;Ool40019Ool008Moo`D0009oo`03001oogoo04Moo`00QWoo00D007ooOol007oo
00@004Uoo`00QWoo00@007ooOol004ioo`00QGoo0P0000=oo`000000CWoo003HOol00=Qoo`00f7oo
003HOol00=Qoo`00f7oo0000\
\>"],
  ImageRangeCache->{{{0, 215}, {158.5, 0}} -> {-3.6204, -3.277, 0.0369339, \
0.0369339}}],

Cell[TextData[{
  "It is convenient to use spherical coordinates (",
  StyleBox["r",
    FontSlant->"Italic"],
  ", \[Theta]). We choose the origin of \[Theta] in such a way that \[Theta] \
= 0 defines the direction of ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  ". The velocity components ",
  Cell[BoxData[
      \(TraditionalForm\`u\_r\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\[Theta]\)]],
  " are related to the Stokes stream function \[CapitalPsi] in spherical \
coordinates by the relations "
}], "Text",
  CellTags->"Stokes stream function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StreamFunction = {
        ur \[Rule] 
          Function[{r, \[Theta]}, 
            \[PartialD]\_\[Theta] \[CapitalPsi][r, \[Theta]]\/\(r\^2\ 
                Sin[\[Theta]]\)], \n\t\t
        uth \[Rule] 
          Function[{r, \[Theta]}, 
            \(-\(\[PartialD]\_r \[CapitalPsi][r, \[Theta]]\/\(r\ 
                    Sin[\[Theta]]\)\)\)]}\)], "Input"],

Cell[BoxData[
    \({ur \[Rule] 
        Function[{r, \[Theta]}, 
          \[PartialD]\_\[Theta] \[CapitalPsi][r, \[Theta]]\/\(r\^2\ 
              Sin[\[Theta]]\)], 
      uth \[Rule] 
        Function[{r, \[Theta]}, 
          \(-\(\[PartialD]\_r \[CapitalPsi][r, \[Theta]]\/\(r\ 
                  Sin[\[Theta]]\)\)\)]}\)], "Output"]
}, Open  ]],

Cell["\<\
In the case of creep flows, the motion has a Reynolds number much \
less than unity. A consequence of this fact is that we can neglect \
acceleration terms in the momentum equation. The momentum equation for the \
stream function is derived by applying the Laplacian in spherical \
coordinates:\
\>", "Text",
  CellTags->{
  "Reynolds number", "momentum equation", "stream function", "Laplacian"}],

Cell[BoxData[
    \(Operator[expr_] := 
      \[PartialD]\_{r, 2}expr + \[PartialD]\_{\[Theta], 2}expr\/r\^2 - 
        \(Cot[\[Theta]]\ \[PartialD]\_\[Theta] expr\)\/r\^2\)], "Input"],

Cell[TextData[
"Applying this operator twice to the stream function \[CapitalPsi], we find \
the governing equation"], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Momentum = Operator[Operator[\[CapitalPsi][r, \[Theta]]]]; 
    Momentum // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  
                  StyleBox[
                    \(\(6\ Cot[\[Theta]]\ \[CapitalPsi]\_\[Theta]\)\/r\^4\),
                    ScriptLevel->0]}], "+", 
                
                StyleBox[
                  \(\(4\ Cot[\[Theta]]\ \[CapitalPsi]\_\(r, \[Theta]\)\)\/r\^3
                        \),
                  ScriptLevel->0], "+", 
                
                StyleBox[
                  \(\(6\ \[CapitalPsi]\_\(\[Theta], \[Theta]\)\)\/r\^4\),
                  ScriptLevel->0], "-", 
                
                StyleBox[
                  \(\(Cot[\[Theta]]\ \[CapitalPsi]\_\(r, r, \[Theta]\)\)\/r\^2
                        \),
                  ScriptLevel->0], "-", 
                
                StyleBox[
                  \(\(4\ \[CapitalPsi]\_\(r, \[Theta], \[Theta]\)\)\/r\^3\),
                  ScriptLevel->0], "-", 
                StyleBox[
                  FractionBox[
                    RowBox[{\(Cot[\[Theta]]\), " ", 
                      RowBox[{"(", 
                        RowBox[{
                          
                          StyleBox[
                            \(\(Csc[\[Theta]]\^2\ \[CapitalPsi]\_\[Theta]\)\/r
                                  \^2\),
                            ScriptLevel->0], "-", 
                          
                          StyleBox[
                            \(\(Cot[\[Theta]]\ 
                                  \[CapitalPsi]\_\(\[Theta], \[Theta]\)\)\/r
                                  \^2\),
                            ScriptLevel->0], "+", 
                          \(\[CapitalPsi]\_\(r, r, \[Theta]\)\), "+", 
                          
                          StyleBox[
                            \(\[CapitalPsi]\_\(\[Theta], \[Theta], 
                                  \[Theta]\)\/r\^2\),
                            ScriptLevel->0]}], ")"}]}], \(r\^2\)],
                  ScriptLevel->0], "+", \(\[CapitalPsi]\_\(r, r, r, r\)\), 
                "+", 
                
                StyleBox[
                  \(\[CapitalPsi]\_\(r, r, \[Theta], \[Theta]\)\/r\^2\),
                  ScriptLevel->0], "+", 
                StyleBox[
                  RowBox[{\(1\/r\^2\), 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"-", 
                          
                          StyleBox[
                            \(\(2\ Cot[\[Theta]]\ Csc[\[Theta]]\^2\ 
                                  \[CapitalPsi]\_\[Theta]\)\/r\^2\),
                            ScriptLevel->0]}], "+", 
                        \(\(2\ Csc[\[Theta]]\^2\ 
                              \[CapitalPsi]\_\(\[Theta], \[Theta]\)\)\/r\^2
                              \), "-", 
                        \(\(Cot[\[Theta]]\ 
                              \[CapitalPsi]\_\(\[Theta], \[Theta], 
                                \[Theta]\)\)\/r\^2\), "+", 
                        \(\[CapitalPsi]\_\(r, r, \[Theta], \[Theta]\)\), "+", 
                        \(\[CapitalPsi]\_\(\[Theta], \[Theta], \[Theta], 
                              \[Theta]\)\/r\^2\)}], ")"}]}],
                  ScriptLevel->0]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting equation is a fourth-order linear partial differential \
equation in spherical coordinates. The equation, although linear, contains a \
lot of analytic coefficients. This linear equation is an example to test the \
reliability of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". Extending our database by creating another file called ",
  StyleBox["stokes.dgl", "MmaText",
    FontSlant->"Italic"],
  " containing the information on this equation helps us to derive the \
symmetries of the equation:"
}], "Text",
  CellTags->"fourth-order linear PDE"],

Cell[BoxData[
    \(LieEquations[
      "\<stokes.dgl\>", {Momentum}, {\[CapitalPsi]}, {r, \[Theta]}, {}, \n
      \t{"\<Creeping flow for an immersed sphere\>"}, \n
      \t{{"\<G.G. Stokes\>"}, \n
        \t\t{"\<Trans. Camb. Phil. Soc. 9, 8-106, (1851)\>"}}, 
      SubstitutionRules 
        \[Rule] {\[PartialD]\_{r, 4}\[CapitalPsi][r, \[Theta]]}]\)], "Input",
  CellTags->"LieEquations[]"],

Cell["\<\
The Lie point symmetries of the momentum equation are derived by \
\
\>", "Text",
  Evaluatable->False,
  CellTags->"Lie point symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieSolve["\<stokes.dgl\>"] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-3\)\ Cot[\[Theta]]\ \((2 + Csc[\[Theta]]\^2)\)\ 
                  \((\[ScriptCapitalF]\_1)\)\_\[Theta] + 
                4\ r\ Cot[\[Theta]]\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(r, \[Theta]\) + 
                \((6 + Cot[\[Theta]]\^2 + 2\ Csc[\[Theta]]\^2)\)\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(\[Theta], \[Theta]\) - 
                2\ r\^2\ Cot[\[Theta]]\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(r, r, \[Theta]\) - 
                4\ r\ \((\[ScriptCapitalF]\_1)\)\_\(r, \[Theta], \[Theta]\) - 
                2\ Cot[\[Theta]]\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(\[Theta], \[Theta], 
                    \[Theta]\) + 
                r\^4\ \((\[ScriptCapitalF]\_1)\)\_\(r, r, r, r\) + 
                2\ r\^2\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(r, r, \[Theta], \[Theta]\) + 
                \((\[ScriptCapitalF]\_1)\)\_\(\[Theta], \[Theta], \[Theta], 
                  \[Theta]\) == 0\)},
          {\(\[Xi]\_2 == 0\)},
          {\(\[Xi]\_1 == k2\ r\)},
          {\(\[Phi]\_1 == k1\ \[CapitalPsi] + \[ScriptCapitalF]\_1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -3, 
              Cot[ \[Theta]], 
              Plus[ 2, 
                Power[ 
                  Csc[ \[Theta]], 2]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], \[Theta]]], 
            Times[ 4, r, 
              Cot[ \[Theta]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, \[Theta]]], 
            Times[ 
              Plus[ 6, 
                Power[ 
                  Cot[ \[Theta]], 2], 
                Times[ 2, 
                  Power[ 
                    Csc[ \[Theta]], 2]]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], \[Theta], \[Theta]]], 
            Times[ -2, 
              Power[ r, 2], 
              Cot[ \[Theta]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, r, \[Theta]]], 
            Times[ -4, r, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, \[Theta], \[Theta]]], 
            Times[ -2, 
              Cot[ \[Theta]], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], \[Theta], \[Theta], 
                \[Theta]]], 
            Times[ 
              Power[ r, 4], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, r, r, r]], 
            Times[ 2, 
              Power[ r, 2], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], r, r, \[Theta], 
                \[Theta]]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], \[Theta], \[Theta], \[Theta], 
              \[Theta]]], 0], 
        Equal[ 
          Subscript[ \[Xi], 2], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ k2, r]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ k1, \[CapitalPsi]], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The analysis shows that Stokes",
  "'",
  " model of creeping flow owns an infinite symmetry as expected for linear \
equations. The continuous part of the symmetry group is determined by the \
arbitrary function ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            RowBox[{
              FormBox[
                RowBox[{\(\[ScriptCapitalF]\_1\), " ", "=", 
                  StyleBox["free",
                    FontSlant->"Italic"]}],
                "TraditionalForm"], "[", "1", "]"}], "[", \(r, \[Theta]\), 
            "]"}],
          "MmaText"], TraditionalForm]]],
  ". The function ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalF]\_1\)]],
  " has to satisfy the original linear fourth-order PDE. The two constants ",
  StyleBox["k1", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "and ",
  StyleBox["k2", "MmaText",
    FontSlant->"Italic"],
  " are the determining elements of the finite group representing a scaling \
symmetry of the momentum equation. Knowing that the momentum equation allows \
only a scaling symmetry, we can use this information to reduce the PDE to an \
ODE. The application of the function ",
  StyleBox["LieReduction[]", "MmaText"],
  " delivers for the scaling group ",
  StyleBox["k1=1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k2=\[Alpha]",
    FontSlant->"Italic"],
  " an ordinary differential equation of fourth order. Unfortunately, this \
ODE is not solvable by ",
  StyleBox["DSolve[]", "MmaText"],
  "."
}], "Text",
  CellTags->{
  "Stokes' model", "finite group", "scaling symmetry", "LieReduction[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rmoment = 
      LieReduction[{Momentum}, {\[CapitalPsi]}, {r, \[Theta]}, {r, 0}, {
          \[Alpha]\ \[CapitalPsi]}]; 
    LTF[Flatten[rmoment]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\[Theta] - \[Zeta]\_1 == 0\)},
          {\(r\^\(-\[Alpha]\)\ \[CapitalPsi] - F\_1 == 0\)},
          {
            \(r\^\[Alpha]\ 
                \((\(-6\)\ \[Alpha]\ F\_1 + 11\ \[Alpha]\^2\ F\_1 - 
                    6\ \[Alpha]\^3\ F\_1 + \[Alpha]\^4\ F\_1 - 
                    6\ Cot[\[Zeta]\_1]\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    6\ \[Alpha]\ Cot[\[Zeta]\_1]\ 
                      \((F\_1)\)\_\(\[Zeta]\_1\) - 
                    2\ \[Alpha]\^2\ Cot[\[Zeta]\_1]\ 
                      \((F\_1)\)\_\(\[Zeta]\_1\) - 
                    3\ Cot[\[Zeta]\_1]\ Csc[\[Zeta]\_1]\^2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    6\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                    6\ \[Alpha]\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                    2\ \[Alpha]\^2\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                    Cot[\[Zeta]\_1]\^2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                    2\ Csc[\[Zeta]\_1]\^2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                    2\ Cot[\[Zeta]\_1]\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                    \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                      \[Zeta]\_1\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"A closer look at the above result reveals that the stream function \
\[CapitalPsi] can be represented by a product of a radial component and a \
function containing the angular part:"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(stream = 
      \[CapitalPsi] \[Rule] 
        Function[{r, \[Theta]}, r\^\[Alpha]\ g[\[Theta]]]\)], "Input"],

Cell[BoxData[
    \(\[CapitalPsi] \[Rule] 
      Function[{r, \[Theta]}, r\^\[Alpha]\ g[\[Theta]]]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "We replaced ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " in the similarity solution by ",
  StyleBox["g",
    FontSlant->"Italic"],
  ". Inserting this result into the original equation, we get"
}], "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mom1 = Expand[\(Momentum /. stream\)\/r\^\(\(-4\) + \[Alpha]\)]; 
    mom1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-6\)\ g\ \[Alpha] + 11\ g\ \[Alpha]\^2 - 6\ g\ \[Alpha]\^3 + 
                g\ \[Alpha]\^4 - 6\ Cot[\[Theta]]\ g\_\[Theta] + 
                6\ \[Alpha]\ Cot[\[Theta]]\ g\_\[Theta] - 
                2\ \[Alpha]\^2\ Cot[\[Theta]]\ g\_\[Theta] - 
                3\ Cot[\[Theta]]\ Csc[\[Theta]]\^2\ g\_\[Theta] + 
                6\ g\_\(\[Theta], \[Theta]\) - 
                6\ \[Alpha]\ g\_\(\[Theta], \[Theta]\) + 
                2\ \[Alpha]\^2\ g\_\(\[Theta], \[Theta]\) + 
                Cot[\[Theta]]\^2\ g\_\(\[Theta], \[Theta]\) + 
                2\ Csc[\[Theta]]\^2\ g\_\(\[Theta], \[Theta]\) - 
                2\ Cot[\[Theta]]\ g\_\(\[Theta], \[Theta], \[Theta]\) + 
                g\_\(\[Theta], \[Theta], \[Theta], \[Theta]\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is an equation in ",
  StyleBox["r",
    FontSlant->"Italic"],
  " and \[Theta]. The remaining equation for ",
  StyleBox["g",
    FontSlant->"Italic"],
  " is a linear ODE of fourth order. This type of equation is equivalent with \
the equation gained by ",
  StyleBox["LieReduction[]", "MmaText"],
  ". Since we already noted that the equation is not solved by ",
  StyleBox["DSolve[]", "MmaText"],
  ", we try an ansatz for the angular part ",
  Cell[BoxData[
      \(TraditionalForm\`g(\[Theta])\)]],
  " by"
}], "Text",
  CellTags->{"DSolve[]", "LieReduction[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sub = g \[Rule] Function[\[Theta], Sin[\[Theta]]\^2]\)], "Input"],

Cell[BoxData[
    \(g \[Rule] Function[\[Theta], Sin[\[Theta]]\^2]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which reduces the determining equation for ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " to a polynomial in \[Alpha] of fourth order:"
}], "Text",
  CellTags->"determining equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pol = Simplify[mom1 /. sub]\)], "Input"],

Cell[BoxData[
    \(\((\(-8\) + 6\ \[Alpha] + 7\ \[Alpha]\^2 - 6\ \[Alpha]\^3 + \[Alpha]\^4)
        \)\ Sin[\[Theta]]\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pol1 = pol\/Sin[\[Theta]]\^2\)], "Input"],

Cell[BoxData[
    \(\(-8\) + 6\ \[Alpha] + 7\ \[Alpha]\^2 - 6\ \[Alpha]\^3 + 
      \[Alpha]\^4\)], "Output"]
}, Open  ]],

Cell[TextData[
"The solutions for the exponent \[Alpha] are found by solving this \
fourth-order polynomial"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(exponents = Solve[pol1 == 0, \[Alpha]]\)], "Input"],

Cell[BoxData[
    \({{\[Alpha] \[Rule] \(-1\)}, {\[Alpha] \[Rule] 1}, {
        \[Alpha] \[Rule] 2}, {\[Alpha] \[Rule] 4}}\)], "Output"]
}, Open  ]],

Cell["\<\
This list is the basis for a combination of the radial components\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(radialpart = r\^\[Alpha] /. exponents\)], "Input"],

Cell[BoxData[
    \({1\/r, r, r\^2, r\^4}\)], "Output"]
}, Open  ]],

Cell[TextData[
"Since the four solutions for \[Alpha] are independent of each other, a \
linear combination of the radial parts provides"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = Plus@@\((Table[c[i], {i, 1, 4}]\ radialpart)\)\)], "Input"],

Cell[BoxData[
    \(c[1]\/r + r\ c[2] + r\^2\ c[3] + r\^4\ c[4]\)], "Output"]
}, Open  ]],

Cell["The final representation for the stream function is thus", "Text",
  CellTags->"stream function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StreamF = f\ Sin[\[Theta]]\^2\)], "Input"],

Cell[BoxData[
    \(\((c[1]\/r + r\ c[2] + r\^2\ c[3] + r\^4\ c[4])\)\ Sin[\[Theta]]\^2\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Up to now, we did not consider any boundary conditions for the problem. As \
one boundary condition, we have to assume that the derivatives of the stream \
function with respect to ",
  StyleBox["r",
    FontSlant->"Italic"],
  " and \[Theta] vanish at the surface of the sphere. This results in"
}], "Text",
  CellTags->"boundary condition"],

Cell[CellGroupData[{

Cell[BoxData[
    \(surf1 = \((\[PartialD]\_r StreamF /. r \[Rule] a)\) == 0\)], "Input"],

Cell[BoxData[
    \(\((\(-\(c[1]\/a\^2\)\) + c[2] + 2\ a\ c[3] + 4\ a\^3\ c[4])\)\ 
        Sin[\[Theta]]\^2 == 0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(surf2 = \((\[PartialD]\_\[Theta] StreamF /. r \[Rule] a)\) == 0\)], 
  "Input"],

Cell[BoxData[
    \(2\ \((c[1]\/a + a\ c[2] + a\^2\ c[3] + a\^4\ c[4])\)\ Cos[\[Theta]]\ 
        Sin[\[Theta]] == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "These two non-slip conditions for the surface are sufficient to determine \
two of the four integration constants ",
  StyleBox["c[i]",
    FontSlant->"Italic"],
  ":"
}], "Text",
  CellTags->"non-slip condition"],

Cell[CellGroupData[{

Cell[BoxData[
    \(iconstants = Solve[{surf1, surf2}, {c[1], c[2], c[3], c[4]}]\)], "Input"],

Cell[BoxData[
    \(Solve::"svars" \( : \ \) 
      "Equations may not give solutions for all \"solve\" variables."\)], 
  "Message"],

Cell[BoxData[
    \({{c[1] \[Rule] 1\/2\ a\^3\ c[3] + 3\/2\ a\^5\ c[4], 
        c[2] \[Rule] \(-\(3\/2\)\)\ a\ c[3] - 5\/2\ a\^3\ c[4]}}\)], "Output"]
}, Open  ]],

Cell["The representation of the stream function reduces thus to", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StreamF = 
      \(Simplify[StreamF /. iconstants]\)\[LeftDoubleBracket]1
        \[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \(\(1\/\(2\ r\)\) 
      \((\((a - r)\)\^2\ 
          \((3\ a\^3\ c[4] + 6\ a\^2\ r\ c[4] + 
              2\ r\ \((c[3] + r\^2\ c[4])\) + a\ \((c[3] + 4\ r\^2\ c[4])\))
            \)\ Sin[\[Theta]]\^2)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "containing two arbitrary constants ",
  StyleBox["c", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[3]", "MmaText"],
  " and ",
  StyleBox["c", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[4]", "MmaText"],
  ". If we consider the stream function for large values of ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ", we observe that the dominant changes result from the ",
  Cell[BoxData[
      \(TraditionalForm\`r\^4\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`r\^2\)]],
  " terms in the solution:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[StreamF, {r, \[Infinity], 2}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(\(c[4]\ Sin[\[Theta]]\^2\)\/\((1\/r)\)\^4\), "+", 
        InterpretationBox[\(1\/O[1\/r]\^2\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, -4, -2, 1]]}],
      SeriesData[ r, 
        DirectedInfinity[ 1], {
        Times[ 
          c[ 4], 
          Power[ 
            Sin[ \[Theta]], 2]]}, -4, -2, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we assume that the radial and angular components of the velocity are \
finite for large ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ", we have to set ",
  StyleBox["c", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[4]", "MmaText"],
  StyleBox[" = 0", "MmaText",
    FontSlant->"Italic"],
  " and ",
  StyleBox["c",
    FontSlant->"Italic"],
  StyleBox["[3]", "MmaText"],
  StyleBox[" = U", "MmaText",
    FontSlant->"Italic"],
  StyleBox["/2", "MmaText"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StreamF = StreamF /. {c[4] \[Rule] 0, c[3] \[Rule] U\/2}\)], "Input"],

Cell[BoxData[
    \(\(\((a - r)\)\^2\ \((a + 2\ r)\)\ U\ Sin[\[Theta]]\^2\)\/\(4\ r\)\)], 
  "Output"]
}, Open  ]],

Cell[TextData["The stream function \[CapitalPsi] is thus defined by"], "Text"],

Cell[BoxData[
    \(\[CapitalPsi][r_, \[Theta]_, a_, U_] := 
      1\/4\ Sin[\[Theta]]\^2\ a\^2\ U\ 
        \((a\/r - \(3\ r\)\/a + \(2\ r\^2\)\/a\^2)\)\)], "Input"],

Cell["\<\
This representation in spherical coordinates can be used to display \
the stream function in a Cartesian coordinate system. To this end, we have to \
transform the coordinates by\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(coordTrafo = {r \[Rule] \@\(x\^2 + y\^2\), 
        \[Theta] \[Rule] ArcTan[x, y]}\)], "Input"],

Cell[BoxData[
    \({r \[Rule] \@\(x\^2 + y\^2\), \[Theta] \[Rule] ArcTan[x, y]}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "To suppress the singularities at ",
  StyleBox["x=0",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y=0",
    FontSlant->"Italic"],
  ", we introduce the condition"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ps = 
      If[x == 0 && y == 0, 0, 
        \[CapitalPsi][r, \[Theta], 1, 1]\  /. \ coordTrafo]\)], "Input"],

Cell[BoxData[
    \(If[x == 0 && y == 0, 0, \[CapitalPsi][r, \[Theta], 1, 1] /. coordTrafo]
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The representation of the stream function in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is thus given by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[{
        ContourPlot[ps, {x, \(-3\), 3}, {y, \(-3\), 3}, \n\t\t\t
          PlotPoints \[Rule] 25, ColorFunction \[Rule] Hue, 
          AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True, \n\t\t\t
          Contours \[Rule] 25, DisplayFunction \[Rule] Identity], 
        Graphics[Disk[{0, 0}, 1]]}, AspectRatio \[Rule] Automatic, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.18254 -0.0125 -6 -9 ]
[.18254 -0.0125 6 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -12 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .18254 -12 -4.5 ]
[-0.0125 .18254 0 4.5 ]
[-0.0125 .34127 -12 -4.5 ]
[-0.0125 .34127 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .65873 -6 -4.5 ]
[-0.0125 .65873 0 4.5 ]
[-0.0125 .81746 -6 -4.5 ]
[-0.0125 .81746 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 .5 0 -7.5 ]
[1.025 .5 10 7.5 ]
[.5 1.025 -5 0 ]
[.5 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(-3)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(-2)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(-1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(1)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(-3)] -0.0125 .02381 1 0 Mshowa
0 .18254 m
.00625 .18254 L
s
[(-2)] -0.0125 .18254 1 0 Mshowa
0 .34127 m
.00625 .34127 L
s
[(-1)] -0.0125 .34127 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .65873 m
.00625 .65873 L
s
[(1)] -0.0125 .65873 1 0 Mshowa
0 .81746 m
.00625 .81746 L
s
[(2)] -0.0125 .81746 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(3)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .05556 m
.00375 .05556 L
s
0 .0873 m
.00375 .0873 L
s
0 .11905 m
.00375 .11905 L
s
0 .15079 m
.00375 .15079 L
s
0 .21429 m
.00375 .21429 L
s
0 .24603 m
.00375 .24603 L
s
0 .27778 m
.00375 .27778 L
s
0 .30952 m
.00375 .30952 L
s
0 .37302 m
.00375 .37302 L
s
0 .40476 m
.00375 .40476 L
s
0 .43651 m
.00375 .43651 L
s
0 .46825 m
.00375 .46825 L
s
0 .53175 m
.00375 .53175 L
s
0 .56349 m
.00375 .56349 L
s
0 .59524 m
.00375 .59524 L
s
0 .62698 m
.00375 .62698 L
s
0 .69048 m
.00375 .69048 L
s
0 .72222 m
.00375 .72222 L
s
0 .75397 m
.00375 .75397 L
s
0 .78571 m
.00375 .78571 L
s
0 .84921 m
.00375 .84921 L
s
0 .88095 m
.00375 .88095 L
s
0 .9127 m
.00375 .9127 L
s
0 .94444 m
.00375 .94444 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.18254 .99375 m
.18254 1 L
s
.34127 .99375 m
.34127 1 L
s
.5 .99375 m
.5 1 L
s
.65873 .99375 m
.65873 1 L
s
.81746 .99375 m
.81746 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.05556 .99625 m
.05556 1 L
s
.0873 .99625 m
.0873 1 L
s
.11905 .99625 m
.11905 1 L
s
.15079 .99625 m
.15079 1 L
s
.21429 .99625 m
.21429 1 L
s
.24603 .99625 m
.24603 1 L
s
.27778 .99625 m
.27778 1 L
s
.30952 .99625 m
.30952 1 L
s
.37302 .99625 m
.37302 1 L
s
.40476 .99625 m
.40476 1 L
s
.43651 .99625 m
.43651 1 L
s
.46825 .99625 m
.46825 1 L
s
.53175 .99625 m
.53175 1 L
s
.56349 .99625 m
.56349 1 L
s
.59524 .99625 m
.59524 1 L
s
.62698 .99625 m
.62698 1 L
s
.69048 .99625 m
.69048 1 L
s
.72222 .99625 m
.72222 1 L
s
.75397 .99625 m
.75397 1 L
s
.78571 .99625 m
.78571 1 L
s
.84921 .99625 m
.84921 1 L
s
.88095 .99625 m
.88095 1 L
s
.9127 .99625 m
.9127 1 L
s
.94444 .99625 m
.94444 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .18254 m
1 .18254 L
s
.99375 .34127 m
1 .34127 L
s
.99375 .5 m
1 .5 L
s
.99375 .65873 m
1 .65873 L
s
.99375 .81746 m
1 .81746 L
s
.99375 .97619 m
1 .97619 L
s
.125 Mabswid
.99625 .05556 m
1 .05556 L
s
.99625 .0873 m
1 .0873 L
s
.99625 .11905 m
1 .11905 L
s
.99625 .15079 m
1 .15079 L
s
.99625 .21429 m
1 .21429 L
s
.99625 .24603 m
1 .24603 L
s
.99625 .27778 m
1 .27778 L
s
.99625 .30952 m
1 .30952 L
s
.99625 .37302 m
1 .37302 L
s
.99625 .40476 m
1 .40476 L
s
.99625 .43651 m
1 .43651 L
s
.99625 .46825 m
1 .46825 L
s
.99625 .53175 m
1 .53175 L
s
.99625 .56349 m
1 .56349 L
s
.99625 .59524 m
1 .59524 L
s
.99625 .62698 m
1 .62698 L
s
.99625 .69048 m
1 .69048 L
s
.99625 .72222 m
1 .72222 L
s
.99625 .75397 m
1 .75397 L
s
.99625 .78571 m
1 .78571 L
s
.99625 .84921 m
1 .84921 L
s
.99625 .88095 m
1 .88095 L
s
.99625 .9127 m
1 .9127 L
s
.99625 .94444 m
1 .94444 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.5 0 m
.5 1 L
s
gsave
.5 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 0 1 r
.02381 .97619 m
.97619 .97619 L
.97619 .02381 L
.02381 .02381 L
F
.56 0 1 r
.02381 .07291 m
.06349 .06797 L
.09823 .06349 L
.10317 .06285 L
.14286 .05761 L
.18254 .05235 L
.22222 .04721 L
.2619 .04232 L
.30159 .03783 L
.34127 .03389 L
.38095 .03064 L
.42063 .02823 L
.46032 .02674 L
.5 .02623 L
.53968 .02674 L
.57937 .02823 L
.61905 .03064 L
.65873 .03389 L
.69841 .03783 L
.7381 .04232 L
.77778 .04721 L
.81746 .05235 L
.85714 .05761 L
.89683 .06285 L
.90177 .06349 L
.93651 .06797 L
.97619 .07291 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.5 Mabswid
.02381 .07291 m
.06349 .06797 L
.09823 .06349 L
.10317 .06285 L
.14286 .05761 L
.18254 .05235 L
.22222 .04721 L
.2619 .04232 L
.30159 .03783 L
.34127 .03389 L
.38095 .03064 L
.42063 .02823 L
.46032 .02674 L
.5 .02623 L
.53968 .02674 L
.57937 .02823 L
.61905 .03064 L
.65873 .03389 L
.69841 .03783 L
.7381 .04232 L
.77778 .04721 L
.81746 .05235 L
.85714 .05761 L
.89683 .06285 L
.90177 .06349 L
.93651 .06797 L
.97619 .07291 L
s
.32 0 1 r
.02381 .08287 m
.06349 .07785 L
.10317 .07262 L
.14286 .06726 L
.17053 .06349 L
.18254 .06187 L
.22222 .05657 L
.2619 .05153 L
.30159 .04689 L
.34127 .04283 L
.38095 .03948 L
.42063 .03698 L
.46032 .03544 L
.5 .03492 L
.53968 .03544 L
.57937 .03698 L
.61905 .03948 L
.65873 .04283 L
.69841 .04689 L
.7381 .05153 L
.77778 .05657 L
.81746 .06187 L
.82947 .06349 L
.85714 .06726 L
.89683 .07262 L
.93651 .07785 L
.97619 .08287 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .08287 m
.06349 .07785 L
.10317 .07262 L
.14286 .06726 L
.17053 .06349 L
.18254 .06187 L
.22222 .05657 L
.2619 .05153 L
.30159 .04689 L
.34127 .04283 L
.38095 .03948 L
.42063 .03698 L
.46032 .03544 L
.5 .03492 L
.53968 .03544 L
.57937 .03698 L
.61905 .03948 L
.65873 .04283 L
.69841 .04689 L
.7381 .05153 L
.77778 .05657 L
.81746 .06187 L
.82947 .06349 L
.85714 .06726 L
.89683 .07262 L
.93651 .07785 L
.97619 .08287 L
s
.08 0 1 r
.02381 .09316 m
.06349 .08806 L
.10317 .08272 L
.14286 .07723 L
.18254 .07168 L
.22222 .06622 L
.24268 .06349 L
.2619 .06101 L
.30159 .05621 L
.34127 .05199 L
.38095 .04852 L
.42063 .04593 L
.46032 .04434 L
.5 .0438 L
.53968 .04434 L
.57937 .04593 L
.61905 .04852 L
.65873 .05199 L
.69841 .05621 L
.7381 .06101 L
.75732 .06349 L
.77778 .06622 L
.81746 .07168 L
.85714 .07723 L
.89683 .08272 L
.93651 .08806 L
.97619 .09316 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .09316 m
.06349 .08806 L
.10317 .08272 L
.14286 .07723 L
.18254 .07168 L
.22222 .06622 L
.24268 .06349 L
.2619 .06101 L
.30159 .05621 L
.34127 .05199 L
.38095 .04852 L
.42063 .04593 L
.46032 .04434 L
.5 .0438 L
.53968 .04434 L
.57937 .04593 L
.61905 .04852 L
.65873 .05199 L
.69841 .05621 L
.7381 .06101 L
.75732 .06349 L
.77778 .06622 L
.81746 .07168 L
.85714 .07723 L
.89683 .08272 L
.93651 .08806 L
.97619 .09316 L
s
0 .16 1 r
.02381 .10381 m
.02881 .10317 L
.06349 .09863 L
.10317 .09318 L
.14286 .08755 L
.18254 .08184 L
.22222 .0762 L
.2619 .0708 L
.30159 .06581 L
.32168 .06349 L
.34127 .06142 L
.38095 .05781 L
.42063 .05511 L
.46032 .05345 L
.5 .05289 L
.53968 .05345 L
.57937 .05511 L
.61905 .05781 L
.65873 .06142 L
.67832 .06349 L
.69841 .06581 L
.7381 .0708 L
.77778 .0762 L
.81746 .08184 L
.85714 .08755 L
.89683 .09318 L
.93651 .09863 L
.97119 .10317 L
.97619 .10381 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .10381 m
.02881 .10317 L
.06349 .09863 L
.10317 .09318 L
.14286 .08755 L
.18254 .08184 L
.22222 .0762 L
.2619 .0708 L
.30159 .06581 L
.32168 .06349 L
.34127 .06142 L
.38095 .05781 L
.42063 .05511 L
.46032 .05345 L
.5 .05289 L
.53968 .05345 L
.57937 .05511 L
.61905 .05781 L
.65873 .06142 L
.67832 .06349 L
.69841 .06581 L
.7381 .0708 L
.77778 .0762 L
.81746 .08184 L
.85714 .08755 L
.89683 .09318 L
.93651 .09863 L
.97119 .10317 L
.97619 .10381 L
s
0 .4 1 r
.02381 .1148 m
.06349 .10956 L
.10317 .10403 L
.1092 .10317 L
.14286 .09827 L
.18254 .09239 L
.22222 .08655 L
.2619 .08094 L
.30159 .07574 L
.34127 .07117 L
.38095 .06739 L
.42063 .06457 L
.43467 .06349 L
.46032 .06283 L
.5 .06224 L
.53968 .06283 L
.56533 .06349 L
.57937 .06457 L
.61905 .06739 L
.65873 .07117 L
.69841 .07574 L
.7381 .08094 L
.77778 .08655 L
.81746 .09239 L
.85714 .09827 L
.8908 .10317 L
.89683 .10403 L
.93651 .10956 L
.97619 .1148 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .1148 m
.06349 .10956 L
.10317 .10403 L
.1092 .10317 L
.14286 .09827 L
.18254 .09239 L
.22222 .08655 L
.2619 .08094 L
.30159 .07574 L
.34127 .07117 L
.38095 .06739 L
.42063 .06457 L
.43467 .06349 L
.46032 .06283 L
.5 .06224 L
.53968 .06283 L
.56533 .06349 L
.57937 .06457 L
.61905 .06739 L
.65873 .07117 L
.69841 .07574 L
.7381 .08094 L
.77778 .08655 L
.81746 .09239 L
.85714 .09827 L
.8908 .10317 L
.89683 .10403 L
.93651 .10956 L
.97619 .1148 L
s
0 .64 1 r
.02381 .12624 m
.06349 .12091 L
.10317 .11526 L
.14286 .10937 L
.18254 .10335 L
.18372 .10317 L
.22222 .09731 L
.2619 .09148 L
.30159 .08606 L
.34127 .08126 L
.38095 .0773 L
.42063 .07435 L
.46032 .07252 L
.5 .0719 L
.53968 .07252 L
.57937 .07435 L
.61905 .0773 L
.65873 .08126 L
.69841 .08606 L
.7381 .09148 L
.77778 .09731 L
.81628 .10317 L
.81746 .10335 L
.85714 .10937 L
.89683 .11526 L
.93651 .12091 L
.97619 .12624 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .12624 m
.06349 .12091 L
.10317 .11526 L
.14286 .10937 L
.18254 .10335 L
.18372 .10317 L
.22222 .09731 L
.2619 .09148 L
.30159 .08606 L
.34127 .08126 L
.38095 .0773 L
.42063 .07435 L
.46032 .07252 L
.5 .0719 L
.53968 .07252 L
.57937 .07435 L
.61905 .0773 L
.65873 .08126 L
.69841 .08606 L
.7381 .09148 L
.77778 .09731 L
.81628 .10317 L
.81746 .10335 L
.85714 .10937 L
.89683 .11526 L
.93651 .12091 L
.97619 .12624 L
s
0 .88 1 r
.02381 .13818 m
.06349 .13276 L
.10317 .12699 L
.14286 .12093 L
.18254 .11471 L
.22222 .10849 L
.25706 .10317 L
.2619 .10245 L
.30159 .09678 L
.34127 .09176 L
.38095 .0876 L
.42063 .08448 L
.46032 .08256 L
.5 .08191 L
.53968 .08256 L
.57937 .08448 L
.61905 .0876 L
.65873 .09176 L
.69841 .09678 L
.7381 .10245 L
.74294 .10317 L
.77778 .10849 L
.81746 .11471 L
.85714 .12093 L
.89683 .12699 L
.93651 .13276 L
.97619 .13818 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .13818 m
.06349 .13276 L
.10317 .12699 L
.14286 .12093 L
.18254 .11471 L
.22222 .10849 L
.25706 .10317 L
.2619 .10245 L
.30159 .09678 L
.34127 .09176 L
.38095 .0876 L
.42063 .08448 L
.46032 .08256 L
.5 .08191 L
.53968 .08256 L
.57937 .08448 L
.61905 .0876 L
.65873 .09176 L
.69841 .09678 L
.7381 .10245 L
.74294 .10317 L
.77778 .10849 L
.81746 .11471 L
.85714 .12093 L
.89683 .12699 L
.93651 .13276 L
.97619 .13818 L
s
0 1 .88 r
.02381 .15061 m
.06349 .14515 L
.07932 .14286 L
.10317 .13927 L
.14286 .13305 L
.18254 .12661 L
.22222 .12013 L
.2619 .11383 L
.30159 .10793 L
.33737 .10317 L
.34127 .1027 L
.38095 .09831 L
.42063 .09502 L
.46032 .09299 L
.5 .0923 L
.53968 .09299 L
.57937 .09502 L
.61905 .09831 L
.65873 .1027 L
.66263 .10317 L
.69841 .10793 L
.7381 .11383 L
.77778 .12013 L
.81746 .12661 L
.85714 .13305 L
.89683 .13927 L
.92068 .14286 L
.93651 .14515 L
.97619 .15061 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .15061 m
.06349 .14515 L
.07932 .14286 L
.10317 .13927 L
.14286 .13305 L
.18254 .12661 L
.22222 .12013 L
.2619 .11383 L
.30159 .10793 L
.33737 .10317 L
.34127 .1027 L
.38095 .09831 L
.42063 .09502 L
.46032 .09299 L
.5 .0923 L
.53968 .09299 L
.57937 .09502 L
.61905 .09831 L
.65873 .1027 L
.66263 .10317 L
.69841 .10793 L
.7381 .11383 L
.77778 .12013 L
.81746 .12661 L
.85714 .13305 L
.89683 .13927 L
.92068 .14286 L
.93651 .14515 L
.97619 .15061 L
s
0 1 .64 r
.02381 .16364 m
.06349 .15809 L
.10317 .15211 L
.14286 .14576 L
.16044 .14286 L
.18254 .13913 L
.22222 .13238 L
.2619 .12577 L
.30159 .11956 L
.34127 .11403 L
.38095 .10943 L
.42063 .10598 L
.46032 .10385 L
.48955 .10317 L
.5 .10312 L
.51045 .10317 L
.53968 .10385 L
.57937 .10598 L
.61905 .10943 L
.65873 .11403 L
.69841 .11956 L
.7381 .12577 L
.77778 .13238 L
.81746 .13913 L
.83956 .14286 L
.85714 .14576 L
.89683 .15211 L
.93651 .15809 L
.97619 .16364 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .16364 m
.06349 .15809 L
.10317 .15211 L
.14286 .14576 L
.16044 .14286 L
.18254 .13913 L
.22222 .13238 L
.2619 .12577 L
.30159 .11956 L
.34127 .11403 L
.38095 .10943 L
.42063 .10598 L
.46032 .10385 L
.48955 .10317 L
.5 .10312 L
.51045 .10317 L
.53968 .10385 L
.57937 .10598 L
.61905 .10943 L
.65873 .11403 L
.69841 .11956 L
.7381 .12577 L
.77778 .13238 L
.81746 .13913 L
.83956 .14286 L
.85714 .14576 L
.89683 .15211 L
.93651 .15809 L
.97619 .16364 L
s
0 1 .4 r
.02381 .1774 m
.06349 .17177 L
.10317 .16565 L
.14286 .1591 L
.18254 .15225 L
.22222 .14528 L
.23607 .14286 L
.2619 .13837 L
.30159 .13181 L
.34127 .12594 L
.38095 .12105 L
.42063 .11737 L
.46032 .11509 L
.5 .11432 L
.53968 .11509 L
.57937 .11737 L
.61905 .12105 L
.65873 .12594 L
.69841 .13181 L
.7381 .13837 L
.76393 .14286 L
.77778 .14528 L
.81746 .15225 L
.85714 .1591 L
.89683 .16565 L
.93651 .17177 L
.97619 .1774 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .1774 m
.06349 .17177 L
.10317 .16565 L
.14286 .1591 L
.18254 .15225 L
.22222 .14528 L
.23607 .14286 L
.2619 .13837 L
.30159 .13181 L
.34127 .12594 L
.38095 .12105 L
.42063 .11737 L
.46032 .11509 L
.5 .11432 L
.53968 .11509 L
.57937 .11737 L
.61905 .12105 L
.65873 .12594 L
.69841 .13181 L
.7381 .13837 L
.76393 .14286 L
.77778 .14528 L
.81746 .15225 L
.85714 .1591 L
.89683 .16565 L
.93651 .17177 L
.97619 .1774 L
s
0 1 .16 r
.02381 .19191 m
.06349 .18626 L
.08773 .18254 L
.10317 .18005 L
.14286 .1733 L
.18254 .16618 L
.22222 .15886 L
.2619 .15161 L
.30159 .14475 L
.31314 .14286 L
.34127 .13853 L
.38095 .1333 L
.42063 .12936 L
.46032 .12692 L
.5 .12609 L
.53968 .12692 L
.57937 .12936 L
.61905 .1333 L
.65873 .13853 L
.68686 .14286 L
.69841 .14475 L
.7381 .15161 L
.77778 .15886 L
.81746 .16618 L
.85714 .1733 L
.89683 .18005 L
.91227 .18254 L
.93651 .18626 L
.97619 .19191 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .19191 m
.06349 .18626 L
.08773 .18254 L
.10317 .18005 L
.14286 .1733 L
.18254 .16618 L
.22222 .15886 L
.2619 .15161 L
.30159 .14475 L
.31314 .14286 L
.34127 .13853 L
.38095 .1333 L
.42063 .12936 L
.46032 .12692 L
.5 .12609 L
.53968 .12692 L
.57937 .12936 L
.61905 .1333 L
.65873 .13853 L
.68686 .14286 L
.69841 .14475 L
.7381 .15161 L
.77778 .15886 L
.81746 .16618 L
.85714 .1733 L
.89683 .18005 L
.91227 .18254 L
.93651 .18626 L
.97619 .19191 L
s
.08 1 0 r
.02381 .20737 m
.06349 .20163 L
.10317 .19531 L
.14286 .18843 L
.17496 .18254 L
.18254 .1811 L
.22222 .17341 L
.2619 .16572 L
.30159 .15838 L
.34127 .15177 L
.38095 .14623 L
.41133 .14286 L
.42063 .14206 L
.46032 .13942 L
.5 .13853 L
.53968 .13942 L
.57937 .14206 L
.58867 .14286 L
.61905 .14623 L
.65873 .15177 L
.69841 .15838 L
.7381 .16572 L
.77778 .17341 L
.81746 .1811 L
.82504 .18254 L
.85714 .18843 L
.89683 .19531 L
.93651 .20163 L
.97619 .20737 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .20737 m
.06349 .20163 L
.10317 .19531 L
.14286 .18843 L
.17496 .18254 L
.18254 .1811 L
.22222 .17341 L
.2619 .16572 L
.30159 .15838 L
.34127 .15177 L
.38095 .14623 L
.41133 .14286 L
.42063 .14206 L
.46032 .13942 L
.5 .13853 L
.53968 .13942 L
.57937 .14206 L
.58867 .14286 L
.61905 .14623 L
.65873 .15177 L
.69841 .15838 L
.7381 .16572 L
.77778 .17341 L
.81746 .1811 L
.82504 .18254 L
.85714 .18843 L
.89683 .19531 L
.93651 .20163 L
.97619 .20737 L
s
.32 1 0 r
.02381 .22399 m
.03656 .22222 L
.06349 .21823 L
.10317 .21177 L
.14286 .20466 L
.18254 .19701 L
.22222 .18901 L
.2541 .18254 L
.2619 .18094 L
.30159 .17307 L
.34127 .16591 L
.38095 .1599 L
.42063 .15536 L
.46032 .15254 L
.5 .15159 L
.53968 .15254 L
.57937 .15536 L
.61905 .1599 L
.65873 .16591 L
.69841 .17307 L
.7381 .18094 L
.7459 .18254 L
.77778 .18901 L
.81746 .19701 L
.85714 .20466 L
.89683 .21177 L
.93651 .21823 L
.96344 .22222 L
.97619 .22399 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .22399 m
.03656 .22222 L
.06349 .21823 L
.10317 .21177 L
.14286 .20466 L
.18254 .19701 L
.22222 .18901 L
.2541 .18254 L
.2619 .18094 L
.30159 .17307 L
.34127 .16591 L
.38095 .1599 L
.42063 .15536 L
.46032 .15254 L
.5 .15159 L
.53968 .15254 L
.57937 .15536 L
.61905 .1599 L
.65873 .16591 L
.69841 .17307 L
.7381 .18094 L
.7459 .18254 L
.77778 .18901 L
.81746 .19701 L
.85714 .20466 L
.89683 .21177 L
.93651 .21823 L
.96344 .22222 L
.97619 .22399 L
s
.56 1 0 r
.02381 .24187 m
.06349 .23611 L
.10317 .22962 L
.14286 .22242 L
.1439 .22222 L
.18254 .21442 L
.22222 .20592 L
.2619 .19726 L
.30159 .18889 L
.33434 .18254 L
.34127 .18126 L
.38095 .17468 L
.42063 .1697 L
.46032 .1666 L
.5 .16554 L
.53968 .1666 L
.57937 .1697 L
.61905 .17468 L
.65873 .18126 L
.66566 .18254 L
.69841 .18889 L
.7381 .19726 L
.77778 .20592 L
.81746 .21442 L
.8561 .22222 L
.85714 .22242 L
.89683 .22962 L
.93651 .23611 L
.97619 .24187 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .24187 m
.06349 .23611 L
.10317 .22962 L
.14286 .22242 L
.1439 .22222 L
.18254 .21442 L
.22222 .20592 L
.2619 .19726 L
.30159 .18889 L
.33434 .18254 L
.34127 .18126 L
.38095 .17468 L
.42063 .1697 L
.46032 .1666 L
.5 .16554 L
.53968 .1666 L
.57937 .1697 L
.61905 .17468 L
.65873 .18126 L
.66566 .18254 L
.69841 .18889 L
.7381 .19726 L
.77778 .20592 L
.81746 .21442 L
.8561 .22222 L
.85714 .22242 L
.89683 .22962 L
.93651 .23611 L
.97619 .24187 L
s
.8 1 0 r
.02381 .2616 m
.06349 .25584 L
.10317 .24925 L
.14286 .24179 L
.18254 .23353 L
.22222 .22468 L
.23298 .22222 L
.2619 .21539 L
.30159 .20618 L
.34127 .19773 L
.38095 .1906 L
.42063 .18523 L
.44547 .18254 L
.46032 .18189 L
.5 .18072 L
.53968 .18189 L
.55453 .18254 L
.57937 .18523 L
.61905 .1906 L
.65873 .19773 L
.69841 .20618 L
.7381 .21539 L
.76702 .22222 L
.77778 .22468 L
.81746 .23353 L
.85714 .24179 L
.89683 .24925 L
.93651 .25584 L
.97619 .2616 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .2616 m
.06349 .25584 L
.10317 .24925 L
.14286 .24179 L
.18254 .23353 L
.22222 .22468 L
.23298 .22222 L
.2619 .21539 L
.30159 .20618 L
.34127 .19773 L
.38095 .1906 L
.42063 .18523 L
.44547 .18254 L
.46032 .18189 L
.5 .18072 L
.53968 .18189 L
.55453 .18254 L
.57937 .18523 L
.61905 .1906 L
.65873 .19773 L
.69841 .20618 L
.7381 .21539 L
.76702 .22222 L
.77778 .22468 L
.81746 .23353 L
.85714 .24179 L
.89683 .24925 L
.93651 .25584 L
.97619 .2616 L
s
1 .96 0 r
.02381 .28336 m
.06349 .27773 L
.10317 .27121 L
.14286 .26374 L
.15188 .2619 L
.18254 .25512 L
.22222 .24556 L
.2619 .23551 L
.30159 .22562 L
.31589 .22222 L
.34127 .2163 L
.38095 .2082 L
.42063 .20205 L
.46032 .19823 L
.5 .19694 L
.53968 .19823 L
.57937 .20205 L
.61905 .2082 L
.65873 .2163 L
.68411 .22222 L
.69841 .22562 L
.7381 .23551 L
.77778 .24556 L
.81746 .25512 L
.84812 .2619 L
.85714 .26374 L
.89683 .27121 L
.93651 .27773 L
.97619 .28336 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .28336 m
.06349 .27773 L
.10317 .27121 L
.14286 .26374 L
.15188 .2619 L
.18254 .25512 L
.22222 .24556 L
.2619 .23551 L
.30159 .22562 L
.31589 .22222 L
.34127 .2163 L
.38095 .2082 L
.42063 .20205 L
.46032 .19823 L
.5 .19694 L
.53968 .19823 L
.57937 .20205 L
.61905 .2082 L
.65873 .2163 L
.68411 .22222 L
.69841 .22562 L
.7381 .23551 L
.77778 .24556 L
.81746 .25512 L
.84812 .2619 L
.85714 .26374 L
.89683 .27121 L
.93651 .27773 L
.97619 .28336 L
s
1 .72 0 r
.02381 .30832 m
.06349 .30299 L
.07292 .30159 L
.10317 .29653 L
.14286 .28884 L
.18254 .2799 L
.22222 .26987 L
.25202 .2619 L
.2619 .25908 L
.30159 .24772 L
.34127 .23706 L
.38095 .22806 L
.4145 .22222 L
.42063 .22135 L
.46032 .21691 L
.5 .2154 L
.53968 .21691 L
.57937 .22135 L
.5855 .22222 L
.61905 .22806 L
.65873 .23706 L
.69841 .24772 L
.7381 .25908 L
.74798 .2619 L
.77778 .26987 L
.81746 .2799 L
.85714 .28884 L
.89683 .29653 L
.92708 .30159 L
.93651 .30299 L
.97619 .30832 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .30832 m
.06349 .30299 L
.07292 .30159 L
.10317 .29653 L
.14286 .28884 L
.18254 .2799 L
.22222 .26987 L
.25202 .2619 L
.2619 .25908 L
.30159 .24772 L
.34127 .23706 L
.38095 .22806 L
.4145 .22222 L
.42063 .22135 L
.46032 .21691 L
.5 .2154 L
.53968 .21691 L
.57937 .22135 L
.5855 .22222 L
.61905 .22806 L
.65873 .23706 L
.69841 .24772 L
.7381 .25908 L
.74798 .2619 L
.77778 .26987 L
.81746 .2799 L
.85714 .28884 L
.89683 .29653 L
.92708 .30159 L
.93651 .30299 L
.97619 .30832 L
s
1 .48 0 r
.02381 .33793 m
.06349 .33281 L
.10317 .3266 L
.14286 .31907 L
.18254 .31007 L
.21536 .30159 L
.22222 .29958 L
.2619 .2872 L
.30159 .27426 L
.34127 .26242 L
.34316 .2619 L
.38095 .2514 L
.42063 .2429 L
.46032 .23763 L
.5 .23586 L
.53968 .23763 L
.57937 .2429 L
.61905 .2514 L
.65684 .2619 L
.65873 .26242 L
.69841 .27426 L
.7381 .2872 L
.77778 .29958 L
.78464 .30159 L
.81746 .31007 L
.85714 .31907 L
.89683 .3266 L
.93651 .33281 L
.97619 .33793 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .33793 m
.06349 .33281 L
.10317 .3266 L
.14286 .31907 L
.18254 .31007 L
.21536 .30159 L
.22222 .29958 L
.2619 .2872 L
.30159 .27426 L
.34127 .26242 L
.34316 .2619 L
.38095 .2514 L
.42063 .2429 L
.46032 .23763 L
.5 .23586 L
.53968 .23763 L
.57937 .2429 L
.61905 .2514 L
.65684 .2619 L
.65873 .26242 L
.69841 .27426 L
.7381 .2872 L
.77778 .29958 L
.78464 .30159 L
.81746 .31007 L
.85714 .31907 L
.89683 .3266 L
.93651 .33281 L
.97619 .33793 L
s
1 .24 0 r
.02381 .37536 m
.06349 .37094 L
.10317 .36542 L
.14286 .35846 L
.18254 .34973 L
.215 .34127 L
.22222 .33898 L
.2619 .32485 L
.30159 .30938 L
.32373 .30159 L
.34127 .29456 L
.38095 .28006 L
.42063 .26918 L
.46032 .26335 L
.5 .26211 L
.53968 .26335 L
.57937 .26918 L
.61905 .28006 L
.65873 .29456 L
.67627 .30159 L
.69841 .30938 L
.7381 .32485 L
.77778 .33898 L
.785 .34127 L
.81746 .34973 L
.85714 .35846 L
.89683 .36542 L
.93651 .37094 L
.97619 .37536 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .37536 m
.06349 .37094 L
.10317 .36542 L
.14286 .35846 L
.18254 .34973 L
.215 .34127 L
.22222 .33898 L
.2619 .32485 L
.30159 .30938 L
.32373 .30159 L
.34127 .29456 L
.38095 .28006 L
.42063 .26918 L
.46032 .26335 L
.5 .26211 L
.53968 .26335 L
.57937 .26918 L
.61905 .28006 L
.65873 .29456 L
.67627 .30159 L
.69841 .30938 L
.7381 .32485 L
.77778 .33898 L
.785 .34127 L
.81746 .34973 L
.85714 .35846 L
.89683 .36542 L
.93651 .37094 L
.97619 .37536 L
s
1 0 0 r
.02381 .43397 m
.06349 .4314 L
.10317 .42804 L
.14286 .42348 L
.16224 .42063 L
.18254 .41665 L
.22222 .40608 L
.2619 .39077 L
.28748 .38095 L
.30159 .37203 L
.34127 .35023 L
.35633 .34127 L
.38095 .32926 L
.42063 .31357 L
.46032 .30404 L
.48159 .30159 L
.5 .30057 L
.51841 .30159 L
.53968 .30404 L
.57937 .31357 L
.61905 .32926 L
.64367 .34127 L
.65873 .35023 L
.69841 .37203 L
.71252 .38095 L
.7381 .39077 L
.77778 .40608 L
.81746 .41665 L
.83776 .42063 L
.85714 .42348 L
.89683 .42804 L
.93651 .4314 L
.97619 .43397 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .43397 m
.06349 .4314 L
.10317 .42804 L
.14286 .42348 L
.16224 .42063 L
.18254 .41665 L
.22222 .40608 L
.2619 .39077 L
.28748 .38095 L
.30159 .37203 L
.34127 .35023 L
.35633 .34127 L
.38095 .32926 L
.42063 .31357 L
.46032 .30404 L
.48159 .30159 L
.5 .30057 L
.51841 .30159 L
.53968 .30404 L
.57937 .31357 L
.61905 .32926 L
.64367 .34127 L
.65873 .35023 L
.69841 .37203 L
.71252 .38095 L
.7381 .39077 L
.77778 .40608 L
.81746 .41665 L
.83776 .42063 L
.85714 .42348 L
.89683 .42804 L
.93651 .4314 L
.97619 .43397 L
s
1 .24 0 r
.02381 .56603 m
.06349 .5686 L
.10317 .57196 L
.14286 .57652 L
.16224 .57937 L
.18254 .58335 L
.22222 .59392 L
.2619 .60923 L
.28748 .61905 L
.30159 .62797 L
.34127 .64977 L
.35633 .65873 L
.38095 .67074 L
.42063 .68643 L
.46032 .69596 L
.48159 .69841 L
.5 .69943 L
.51841 .69841 L
.53968 .69596 L
.57937 .68643 L
.61905 .67074 L
.64367 .65873 L
.65873 .64977 L
.69841 .62797 L
.71252 .61905 L
.7381 .60923 L
.77778 .59392 L
.81746 .58335 L
.83776 .57937 L
.85714 .57652 L
.89683 .57196 L
.93651 .5686 L
.97619 .56603 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .56603 m
.06349 .5686 L
.10317 .57196 L
.14286 .57652 L
.16224 .57937 L
.18254 .58335 L
.22222 .59392 L
.2619 .60923 L
.28748 .61905 L
.30159 .62797 L
.34127 .64977 L
.35633 .65873 L
.38095 .67074 L
.42063 .68643 L
.46032 .69596 L
.48159 .69841 L
.5 .69943 L
.51841 .69841 L
.53968 .69596 L
.57937 .68643 L
.61905 .67074 L
.64367 .65873 L
.65873 .64977 L
.69841 .62797 L
.71252 .61905 L
.7381 .60923 L
.77778 .59392 L
.81746 .58335 L
.83776 .57937 L
.85714 .57652 L
.89683 .57196 L
.93651 .5686 L
.97619 .56603 L
s
1 .48 0 r
.02381 .62464 m
.06349 .62906 L
.10317 .63458 L
.14286 .64154 L
.18254 .65027 L
.215 .65873 L
.22222 .66102 L
.2619 .67515 L
.30159 .69062 L
.32373 .69841 L
.34127 .70544 L
.38095 .71994 L
.42063 .73082 L
.46032 .73665 L
.5 .73789 L
.53968 .73665 L
.57937 .73082 L
.61905 .71994 L
.65873 .70544 L
.67627 .69841 L
.69841 .69062 L
.7381 .67515 L
.77778 .66102 L
.785 .65873 L
.81746 .65027 L
.85714 .64154 L
.89683 .63458 L
.93651 .62906 L
.97619 .62464 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .62464 m
.06349 .62906 L
.10317 .63458 L
.14286 .64154 L
.18254 .65027 L
.215 .65873 L
.22222 .66102 L
.2619 .67515 L
.30159 .69062 L
.32373 .69841 L
.34127 .70544 L
.38095 .71994 L
.42063 .73082 L
.46032 .73665 L
.5 .73789 L
.53968 .73665 L
.57937 .73082 L
.61905 .71994 L
.65873 .70544 L
.67627 .69841 L
.69841 .69062 L
.7381 .67515 L
.77778 .66102 L
.785 .65873 L
.81746 .65027 L
.85714 .64154 L
.89683 .63458 L
.93651 .62906 L
.97619 .62464 L
s
1 .72 0 r
.02381 .66207 m
.06349 .66719 L
.10317 .6734 L
.14286 .68093 L
.18254 .68993 L
.21536 .69841 L
.22222 .70042 L
.2619 .7128 L
.30159 .72574 L
.34127 .73758 L
.34316 .7381 L
.38095 .7486 L
.42063 .7571 L
.46032 .76237 L
.5 .76414 L
.53968 .76237 L
.57937 .7571 L
.61905 .7486 L
.65684 .7381 L
.65873 .73758 L
.69841 .72574 L
.7381 .7128 L
.77778 .70042 L
.78464 .69841 L
.81746 .68993 L
.85714 .68093 L
.89683 .6734 L
.93651 .66719 L
.97619 .66207 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .66207 m
.06349 .66719 L
.10317 .6734 L
.14286 .68093 L
.18254 .68993 L
.21536 .69841 L
.22222 .70042 L
.2619 .7128 L
.30159 .72574 L
.34127 .73758 L
.34316 .7381 L
.38095 .7486 L
.42063 .7571 L
.46032 .76237 L
.5 .76414 L
.53968 .76237 L
.57937 .7571 L
.61905 .7486 L
.65684 .7381 L
.65873 .73758 L
.69841 .72574 L
.7381 .7128 L
.77778 .70042 L
.78464 .69841 L
.81746 .68993 L
.85714 .68093 L
.89683 .6734 L
.93651 .66719 L
.97619 .66207 L
s
1 .96 0 r
.02381 .69168 m
.06349 .69701 L
.07292 .69841 L
.10317 .70347 L
.14286 .71116 L
.18254 .7201 L
.22222 .73013 L
.25202 .7381 L
.2619 .74092 L
.30159 .75228 L
.34127 .76294 L
.38095 .77194 L
.4145 .77778 L
.42063 .77865 L
.46032 .78309 L
.5 .7846 L
.53968 .78309 L
.57937 .77865 L
.5855 .77778 L
.61905 .77194 L
.65873 .76294 L
.69841 .75228 L
.7381 .74092 L
.74798 .7381 L
.77778 .73013 L
.81746 .7201 L
.85714 .71116 L
.89683 .70347 L
.92708 .69841 L
.93651 .69701 L
.97619 .69168 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .69168 m
.06349 .69701 L
.07292 .69841 L
.10317 .70347 L
.14286 .71116 L
.18254 .7201 L
.22222 .73013 L
.25202 .7381 L
.2619 .74092 L
.30159 .75228 L
.34127 .76294 L
.38095 .77194 L
.4145 .77778 L
.42063 .77865 L
.46032 .78309 L
.5 .7846 L
.53968 .78309 L
.57937 .77865 L
.5855 .77778 L
.61905 .77194 L
.65873 .76294 L
.69841 .75228 L
.7381 .74092 L
.74798 .7381 L
.77778 .73013 L
.81746 .7201 L
.85714 .71116 L
.89683 .70347 L
.92708 .69841 L
.93651 .69701 L
.97619 .69168 L
s
.8 1 0 r
.02381 .71664 m
.06349 .72227 L
.10317 .72879 L
.14286 .73626 L
.15188 .7381 L
.18254 .74488 L
.22222 .75444 L
.2619 .76449 L
.30159 .77438 L
.31589 .77778 L
.34127 .7837 L
.38095 .7918 L
.42063 .79795 L
.46032 .80177 L
.5 .80306 L
.53968 .80177 L
.57937 .79795 L
.61905 .7918 L
.65873 .7837 L
.68411 .77778 L
.69841 .77438 L
.7381 .76449 L
.77778 .75444 L
.81746 .74488 L
.84812 .7381 L
.85714 .73626 L
.89683 .72879 L
.93651 .72227 L
.97619 .71664 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .71664 m
.06349 .72227 L
.10317 .72879 L
.14286 .73626 L
.15188 .7381 L
.18254 .74488 L
.22222 .75444 L
.2619 .76449 L
.30159 .77438 L
.31589 .77778 L
.34127 .7837 L
.38095 .7918 L
.42063 .79795 L
.46032 .80177 L
.5 .80306 L
.53968 .80177 L
.57937 .79795 L
.61905 .7918 L
.65873 .7837 L
.68411 .77778 L
.69841 .77438 L
.7381 .76449 L
.77778 .75444 L
.81746 .74488 L
.84812 .7381 L
.85714 .73626 L
.89683 .72879 L
.93651 .72227 L
.97619 .71664 L
s
.56 1 0 r
.02381 .7384 m
.06349 .74416 L
.10317 .75075 L
.14286 .75821 L
.18254 .76647 L
.22222 .77532 L
.23298 .77778 L
.2619 .78461 L
.30159 .79382 L
.34127 .80227 L
.38095 .8094 L
.42063 .81477 L
.44547 .81746 L
.46032 .81811 L
.5 .81928 L
.53968 .81811 L
.55453 .81746 L
.57937 .81477 L
.61905 .8094 L
.65873 .80227 L
.69841 .79382 L
.7381 .78461 L
.76702 .77778 L
.77778 .77532 L
.81746 .76647 L
.85714 .75821 L
.89683 .75075 L
.93651 .74416 L
.97619 .7384 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .7384 m
.06349 .74416 L
.10317 .75075 L
.14286 .75821 L
.18254 .76647 L
.22222 .77532 L
.23298 .77778 L
.2619 .78461 L
.30159 .79382 L
.34127 .80227 L
.38095 .8094 L
.42063 .81477 L
.44547 .81746 L
.46032 .81811 L
.5 .81928 L
.53968 .81811 L
.55453 .81746 L
.57937 .81477 L
.61905 .8094 L
.65873 .80227 L
.69841 .79382 L
.7381 .78461 L
.76702 .77778 L
.77778 .77532 L
.81746 .76647 L
.85714 .75821 L
.89683 .75075 L
.93651 .74416 L
.97619 .7384 L
s
.32 1 0 r
.02381 .75813 m
.06349 .76389 L
.10317 .77038 L
.14286 .77758 L
.1439 .77778 L
.18254 .78558 L
.22222 .79408 L
.2619 .80274 L
.30159 .81111 L
.33434 .81746 L
.34127 .81874 L
.38095 .82532 L
.42063 .8303 L
.46032 .8334 L
.5 .83446 L
.53968 .8334 L
.57937 .8303 L
.61905 .82532 L
.65873 .81874 L
.66566 .81746 L
.69841 .81111 L
.7381 .80274 L
.77778 .79408 L
.81746 .78558 L
.8561 .77778 L
.85714 .77758 L
.89683 .77038 L
.93651 .76389 L
.97619 .75813 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .75813 m
.06349 .76389 L
.10317 .77038 L
.14286 .77758 L
.1439 .77778 L
.18254 .78558 L
.22222 .79408 L
.2619 .80274 L
.30159 .81111 L
.33434 .81746 L
.34127 .81874 L
.38095 .82532 L
.42063 .8303 L
.46032 .8334 L
.5 .83446 L
.53968 .8334 L
.57937 .8303 L
.61905 .82532 L
.65873 .81874 L
.66566 .81746 L
.69841 .81111 L
.7381 .80274 L
.77778 .79408 L
.81746 .78558 L
.8561 .77778 L
.85714 .77758 L
.89683 .77038 L
.93651 .76389 L
.97619 .75813 L
s
.08 1 0 r
.02381 .77601 m
.03656 .77778 L
.06349 .78177 L
.10317 .78823 L
.14286 .79534 L
.18254 .80299 L
.22222 .81099 L
.2541 .81746 L
.2619 .81906 L
.30159 .82693 L
.34127 .83409 L
.38095 .8401 L
.42063 .84464 L
.46032 .84746 L
.5 .84841 L
.53968 .84746 L
.57937 .84464 L
.61905 .8401 L
.65873 .83409 L
.69841 .82693 L
.7381 .81906 L
.7459 .81746 L
.77778 .81099 L
.81746 .80299 L
.85714 .79534 L
.89683 .78823 L
.93651 .78177 L
.96344 .77778 L
.97619 .77601 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .77601 m
.03656 .77778 L
.06349 .78177 L
.10317 .78823 L
.14286 .79534 L
.18254 .80299 L
.22222 .81099 L
.2541 .81746 L
.2619 .81906 L
.30159 .82693 L
.34127 .83409 L
.38095 .8401 L
.42063 .84464 L
.46032 .84746 L
.5 .84841 L
.53968 .84746 L
.57937 .84464 L
.61905 .8401 L
.65873 .83409 L
.69841 .82693 L
.7381 .81906 L
.7459 .81746 L
.77778 .81099 L
.81746 .80299 L
.85714 .79534 L
.89683 .78823 L
.93651 .78177 L
.96344 .77778 L
.97619 .77601 L
s
0 1 .16 r
.02381 .79263 m
.06349 .79837 L
.10317 .80469 L
.14286 .81157 L
.17496 .81746 L
.18254 .8189 L
.22222 .82659 L
.2619 .83428 L
.30159 .84162 L
.34127 .84823 L
.38095 .85377 L
.41133 .85714 L
.42063 .85794 L
.46032 .86058 L
.5 .86147 L
.53968 .86058 L
.57937 .85794 L
.58867 .85714 L
.61905 .85377 L
.65873 .84823 L
.69841 .84162 L
.7381 .83428 L
.77778 .82659 L
.81746 .8189 L
.82504 .81746 L
.85714 .81157 L
.89683 .80469 L
.93651 .79837 L
.97619 .79263 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .79263 m
.06349 .79837 L
.10317 .80469 L
.14286 .81157 L
.17496 .81746 L
.18254 .8189 L
.22222 .82659 L
.2619 .83428 L
.30159 .84162 L
.34127 .84823 L
.38095 .85377 L
.41133 .85714 L
.42063 .85794 L
.46032 .86058 L
.5 .86147 L
.53968 .86058 L
.57937 .85794 L
.58867 .85714 L
.61905 .85377 L
.65873 .84823 L
.69841 .84162 L
.7381 .83428 L
.77778 .82659 L
.81746 .8189 L
.82504 .81746 L
.85714 .81157 L
.89683 .80469 L
.93651 .79837 L
.97619 .79263 L
s
0 1 .4 r
.02381 .80809 m
.06349 .81374 L
.08773 .81746 L
.10317 .81995 L
.14286 .8267 L
.18254 .83382 L
.22222 .84114 L
.2619 .84839 L
.30159 .85525 L
.31314 .85714 L
.34127 .86147 L
.38095 .8667 L
.42063 .87064 L
.46032 .87308 L
.5 .87391 L
.53968 .87308 L
.57937 .87064 L
.61905 .8667 L
.65873 .86147 L
.68686 .85714 L
.69841 .85525 L
.7381 .84839 L
.77778 .84114 L
.81746 .83382 L
.85714 .8267 L
.89683 .81995 L
.91227 .81746 L
.93651 .81374 L
.97619 .80809 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .80809 m
.06349 .81374 L
.08773 .81746 L
.10317 .81995 L
.14286 .8267 L
.18254 .83382 L
.22222 .84114 L
.2619 .84839 L
.30159 .85525 L
.31314 .85714 L
.34127 .86147 L
.38095 .8667 L
.42063 .87064 L
.46032 .87308 L
.5 .87391 L
.53968 .87308 L
.57937 .87064 L
.61905 .8667 L
.65873 .86147 L
.68686 .85714 L
.69841 .85525 L
.7381 .84839 L
.77778 .84114 L
.81746 .83382 L
.85714 .8267 L
.89683 .81995 L
.91227 .81746 L
.93651 .81374 L
.97619 .80809 L
s
0 1 .64 r
.02381 .8226 m
.06349 .82823 L
.10317 .83435 L
.14286 .8409 L
.18254 .84775 L
.22222 .85472 L
.23607 .85714 L
.2619 .86163 L
.30159 .86819 L
.34127 .87406 L
.38095 .87895 L
.42063 .88263 L
.46032 .88491 L
.5 .88568 L
.53968 .88491 L
.57937 .88263 L
.61905 .87895 L
.65873 .87406 L
.69841 .86819 L
.7381 .86163 L
.76393 .85714 L
.77778 .85472 L
.81746 .84775 L
.85714 .8409 L
.89683 .83435 L
.93651 .82823 L
.97619 .8226 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .8226 m
.06349 .82823 L
.10317 .83435 L
.14286 .8409 L
.18254 .84775 L
.22222 .85472 L
.23607 .85714 L
.2619 .86163 L
.30159 .86819 L
.34127 .87406 L
.38095 .87895 L
.42063 .88263 L
.46032 .88491 L
.5 .88568 L
.53968 .88491 L
.57937 .88263 L
.61905 .87895 L
.65873 .87406 L
.69841 .86819 L
.7381 .86163 L
.76393 .85714 L
.77778 .85472 L
.81746 .84775 L
.85714 .8409 L
.89683 .83435 L
.93651 .82823 L
.97619 .8226 L
s
0 1 .88 r
.02381 .83636 m
.06349 .84191 L
.10317 .84789 L
.14286 .85424 L
.16044 .85714 L
.18254 .86087 L
.22222 .86762 L
.2619 .87423 L
.30159 .88044 L
.34127 .88597 L
.38095 .89057 L
.42063 .89402 L
.46032 .89615 L
.48955 .89683 L
.5 .89688 L
.51045 .89683 L
.53968 .89615 L
.57937 .89402 L
.61905 .89057 L
.65873 .88597 L
.69841 .88044 L
.7381 .87423 L
.77778 .86762 L
.81746 .86087 L
.83956 .85714 L
.85714 .85424 L
.89683 .84789 L
.93651 .84191 L
.97619 .83636 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .83636 m
.06349 .84191 L
.10317 .84789 L
.14286 .85424 L
.16044 .85714 L
.18254 .86087 L
.22222 .86762 L
.2619 .87423 L
.30159 .88044 L
.34127 .88597 L
.38095 .89057 L
.42063 .89402 L
.46032 .89615 L
.48955 .89683 L
.5 .89688 L
.51045 .89683 L
.53968 .89615 L
.57937 .89402 L
.61905 .89057 L
.65873 .88597 L
.69841 .88044 L
.7381 .87423 L
.77778 .86762 L
.81746 .86087 L
.83956 .85714 L
.85714 .85424 L
.89683 .84789 L
.93651 .84191 L
.97619 .83636 L
s
0 .88 1 r
.02381 .84939 m
.06349 .85485 L
.07932 .85714 L
.10317 .86073 L
.14286 .86695 L
.18254 .87339 L
.22222 .87987 L
.2619 .88617 L
.30159 .89207 L
.33737 .89683 L
.34127 .8973 L
.38095 .90169 L
.42063 .90498 L
.46032 .90701 L
.5 .9077 L
.53968 .90701 L
.57937 .90498 L
.61905 .90169 L
.65873 .8973 L
.66263 .89683 L
.69841 .89207 L
.7381 .88617 L
.77778 .87987 L
.81746 .87339 L
.85714 .86695 L
.89683 .86073 L
.92068 .85714 L
.93651 .85485 L
.97619 .84939 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .84939 m
.06349 .85485 L
.07932 .85714 L
.10317 .86073 L
.14286 .86695 L
.18254 .87339 L
.22222 .87987 L
.2619 .88617 L
.30159 .89207 L
.33737 .89683 L
.34127 .8973 L
.38095 .90169 L
.42063 .90498 L
.46032 .90701 L
.5 .9077 L
.53968 .90701 L
.57937 .90498 L
.61905 .90169 L
.65873 .8973 L
.66263 .89683 L
.69841 .89207 L
.7381 .88617 L
.77778 .87987 L
.81746 .87339 L
.85714 .86695 L
.89683 .86073 L
.92068 .85714 L
.93651 .85485 L
.97619 .84939 L
s
0 .64 1 r
.02381 .86182 m
.06349 .86724 L
.10317 .87301 L
.14286 .87907 L
.18254 .88529 L
.22222 .89151 L
.25706 .89683 L
.2619 .89755 L
.30159 .90322 L
.34127 .90824 L
.38095 .9124 L
.42063 .91552 L
.46032 .91744 L
.5 .91809 L
.53968 .91744 L
.57937 .91552 L
.61905 .9124 L
.65873 .90824 L
.69841 .90322 L
.7381 .89755 L
.74294 .89683 L
.77778 .89151 L
.81746 .88529 L
.85714 .87907 L
.89683 .87301 L
.93651 .86724 L
.97619 .86182 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .86182 m
.06349 .86724 L
.10317 .87301 L
.14286 .87907 L
.18254 .88529 L
.22222 .89151 L
.25706 .89683 L
.2619 .89755 L
.30159 .90322 L
.34127 .90824 L
.38095 .9124 L
.42063 .91552 L
.46032 .91744 L
.5 .91809 L
.53968 .91744 L
.57937 .91552 L
.61905 .9124 L
.65873 .90824 L
.69841 .90322 L
.7381 .89755 L
.74294 .89683 L
.77778 .89151 L
.81746 .88529 L
.85714 .87907 L
.89683 .87301 L
.93651 .86724 L
.97619 .86182 L
s
0 .4 1 r
.02381 .87376 m
.06349 .87909 L
.10317 .88474 L
.14286 .89063 L
.18254 .89665 L
.18372 .89683 L
.22222 .90269 L
.2619 .90852 L
.30159 .91394 L
.34127 .91874 L
.38095 .9227 L
.42063 .92565 L
.46032 .92748 L
.5 .9281 L
.53968 .92748 L
.57937 .92565 L
.61905 .9227 L
.65873 .91874 L
.69841 .91394 L
.7381 .90852 L
.77778 .90269 L
.81628 .89683 L
.81746 .89665 L
.85714 .89063 L
.89683 .88474 L
.93651 .87909 L
.97619 .87376 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .87376 m
.06349 .87909 L
.10317 .88474 L
.14286 .89063 L
.18254 .89665 L
.18372 .89683 L
.22222 .90269 L
.2619 .90852 L
.30159 .91394 L
.34127 .91874 L
.38095 .9227 L
.42063 .92565 L
.46032 .92748 L
.5 .9281 L
.53968 .92748 L
.57937 .92565 L
.61905 .9227 L
.65873 .91874 L
.69841 .91394 L
.7381 .90852 L
.77778 .90269 L
.81628 .89683 L
.81746 .89665 L
.85714 .89063 L
.89683 .88474 L
.93651 .87909 L
.97619 .87376 L
s
0 .16 1 r
.02381 .8852 m
.06349 .89044 L
.10317 .89597 L
.1092 .89683 L
.14286 .90173 L
.18254 .90761 L
.22222 .91345 L
.2619 .91906 L
.30159 .92426 L
.34127 .92883 L
.38095 .93261 L
.42063 .93543 L
.43467 .93651 L
.46032 .93717 L
.5 .93776 L
.53968 .93717 L
.56533 .93651 L
.57937 .93543 L
.61905 .93261 L
.65873 .92883 L
.69841 .92426 L
.7381 .91906 L
.77778 .91345 L
.81746 .90761 L
.85714 .90173 L
.8908 .89683 L
.89683 .89597 L
.93651 .89044 L
.97619 .8852 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .8852 m
.06349 .89044 L
.10317 .89597 L
.1092 .89683 L
.14286 .90173 L
.18254 .90761 L
.22222 .91345 L
.2619 .91906 L
.30159 .92426 L
.34127 .92883 L
.38095 .93261 L
.42063 .93543 L
.43467 .93651 L
.46032 .93717 L
.5 .93776 L
.53968 .93717 L
.56533 .93651 L
.57937 .93543 L
.61905 .93261 L
.65873 .92883 L
.69841 .92426 L
.7381 .91906 L
.77778 .91345 L
.81746 .90761 L
.85714 .90173 L
.8908 .89683 L
.89683 .89597 L
.93651 .89044 L
.97619 .8852 L
s
.08 0 1 r
.02381 .89619 m
.02881 .89683 L
.06349 .90137 L
.10317 .90682 L
.14286 .91245 L
.18254 .91816 L
.22222 .9238 L
.2619 .9292 L
.30159 .93419 L
.32168 .93651 L
.34127 .93858 L
.38095 .94219 L
.42063 .94489 L
.46032 .94655 L
.5 .94711 L
.53968 .94655 L
.57937 .94489 L
.61905 .94219 L
.65873 .93858 L
.67832 .93651 L
.69841 .93419 L
.7381 .9292 L
.77778 .9238 L
.81746 .91816 L
.85714 .91245 L
.89683 .90682 L
.93651 .90137 L
.97119 .89683 L
.97619 .89619 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .89619 m
.02881 .89683 L
.06349 .90137 L
.10317 .90682 L
.14286 .91245 L
.18254 .91816 L
.22222 .9238 L
.2619 .9292 L
.30159 .93419 L
.32168 .93651 L
.34127 .93858 L
.38095 .94219 L
.42063 .94489 L
.46032 .94655 L
.5 .94711 L
.53968 .94655 L
.57937 .94489 L
.61905 .94219 L
.65873 .93858 L
.67832 .93651 L
.69841 .93419 L
.7381 .9292 L
.77778 .9238 L
.81746 .91816 L
.85714 .91245 L
.89683 .90682 L
.93651 .90137 L
.97119 .89683 L
.97619 .89619 L
s
.32 0 1 r
.02381 .90684 m
.06349 .91194 L
.10317 .91728 L
.14286 .92277 L
.18254 .92832 L
.22222 .93378 L
.24268 .93651 L
.2619 .93899 L
.30159 .94379 L
.34127 .94801 L
.38095 .95148 L
.42063 .95407 L
.46032 .95566 L
.5 .9562 L
.53968 .95566 L
.57937 .95407 L
.61905 .95148 L
.65873 .94801 L
.69841 .94379 L
.7381 .93899 L
.75732 .93651 L
.77778 .93378 L
.81746 .92832 L
.85714 .92277 L
.89683 .91728 L
.93651 .91194 L
.97619 .90684 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .90684 m
.06349 .91194 L
.10317 .91728 L
.14286 .92277 L
.18254 .92832 L
.22222 .93378 L
.24268 .93651 L
.2619 .93899 L
.30159 .94379 L
.34127 .94801 L
.38095 .95148 L
.42063 .95407 L
.46032 .95566 L
.5 .9562 L
.53968 .95566 L
.57937 .95407 L
.61905 .95148 L
.65873 .94801 L
.69841 .94379 L
.7381 .93899 L
.75732 .93651 L
.77778 .93378 L
.81746 .92832 L
.85714 .92277 L
.89683 .91728 L
.93651 .91194 L
.97619 .90684 L
s
.56 0 1 r
.02381 .91713 m
.06349 .92215 L
.10317 .92738 L
.14286 .93274 L
.17053 .93651 L
.18254 .93813 L
.22222 .94343 L
.2619 .94847 L
.30159 .95311 L
.34127 .95717 L
.38095 .96052 L
.42063 .96302 L
.46032 .96456 L
.5 .96508 L
.53968 .96456 L
.57937 .96302 L
.61905 .96052 L
.65873 .95717 L
.69841 .95311 L
.7381 .94847 L
.77778 .94343 L
.81746 .93813 L
.82947 .93651 L
.85714 .93274 L
.89683 .92738 L
.93651 .92215 L
.97619 .91713 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .91713 m
.06349 .92215 L
.10317 .92738 L
.14286 .93274 L
.17053 .93651 L
.18254 .93813 L
.22222 .94343 L
.2619 .94847 L
.30159 .95311 L
.34127 .95717 L
.38095 .96052 L
.42063 .96302 L
.46032 .96456 L
.5 .96508 L
.53968 .96456 L
.57937 .96302 L
.61905 .96052 L
.65873 .95717 L
.69841 .95311 L
.7381 .94847 L
.77778 .94343 L
.81746 .93813 L
.82947 .93651 L
.85714 .93274 L
.89683 .92738 L
.93651 .92215 L
.97619 .91713 L
s
.8 0 1 r
.02381 .92709 m
.06349 .93203 L
.09823 .93651 L
.10317 .93715 L
.14286 .94239 L
.18254 .94765 L
.22222 .95279 L
.2619 .95768 L
.30159 .96217 L
.34127 .96611 L
.38095 .96936 L
.42063 .97177 L
.46032 .97326 L
.5 .97377 L
.53968 .97326 L
.57937 .97177 L
.61905 .96936 L
.65873 .96611 L
.69841 .96217 L
.7381 .95768 L
.77778 .95279 L
.81746 .94765 L
.85714 .94239 L
.89683 .93715 L
.90177 .93651 L
.93651 .93203 L
.97619 .92709 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .92709 m
.06349 .93203 L
.09823 .93651 L
.10317 .93715 L
.14286 .94239 L
.18254 .94765 L
.22222 .95279 L
.2619 .95768 L
.30159 .96217 L
.34127 .96611 L
.38095 .96936 L
.42063 .97177 L
.46032 .97326 L
.5 .97377 L
.53968 .97326 L
.57937 .97177 L
.61905 .96936 L
.65873 .96611 L
.69841 .96217 L
.7381 .95768 L
.77778 .95279 L
.81746 .94765 L
.85714 .94239 L
.89683 .93715 L
.90177 .93651 L
.93651 .93203 L
.97619 .92709 L
s
1 0 .96 r
.02381 .06325 m
.06349 .05839 L
.10317 .05336 L
.14286 .04824 L
.18254 .04311 L
.22222 .0381 L
.2619 .03334 L
.30159 .02896 L
.34127 .02513 L
.35646 .02381 L
.02381 .02381 L
F
0 g
.02381 .06325 m
.06349 .05839 L
.10317 .05336 L
.14286 .04824 L
.18254 .04311 L
.22222 .0381 L
.2619 .03334 L
.30159 .02896 L
.34127 .02513 L
.35646 .02381 L
s
1 0 .96 r
.02381 .93675 m
.06349 .94161 L
.10317 .94664 L
.14286 .95176 L
.18254 .95689 L
.22222 .9619 L
.2619 .96666 L
.30159 .97104 L
.34127 .97487 L
.35646 .97619 L
.02381 .97619 L
F
0 g
.02381 .93675 m
.06349 .94161 L
.10317 .94664 L
.14286 .95176 L
.18254 .95689 L
.22222 .9619 L
.2619 .96666 L
.30159 .97104 L
.34127 .97487 L
.35646 .97619 L
s
1 0 .72 r
.02381 .05387 m
.06349 .04909 L
.10317 .04414 L
.14286 .03912 L
.18254 .0341 L
.22222 .0292 L
.2619 .02454 L
.26835 .02381 L
.02381 .02381 L
F
0 g
.02381 .05387 m
.06349 .04909 L
.10317 .04414 L
.14286 .03912 L
.18254 .0341 L
.22222 .0292 L
.2619 .02454 L
.26835 .02381 L
s
1 0 .72 r
.02381 .94613 m
.06349 .95091 L
.10317 .95586 L
.14286 .96088 L
.18254 .9659 L
.22222 .9708 L
.2619 .97546 L
.26835 .97619 L
.02381 .97619 L
F
0 g
.02381 .94613 m
.06349 .95091 L
.10317 .95586 L
.14286 .96088 L
.18254 .9659 L
.22222 .9708 L
.2619 .97546 L
.26835 .97619 L
s
1 0 .48 r
.02381 .04474 m
.06349 .04001 L
.10317 .03515 L
.14286 .03021 L
.18254 .02528 L
.19448 .02381 L
.02381 .02381 L
F
0 g
.02381 .04474 m
.06349 .04001 L
.10317 .03515 L
.14286 .03021 L
.18254 .02528 L
.19448 .02381 L
s
1 0 .48 r
.02381 .95526 m
.06349 .95999 L
.10317 .96485 L
.14286 .96979 L
.18254 .97472 L
.19448 .97619 L
.02381 .97619 L
F
0 g
.02381 .95526 m
.06349 .95999 L
.10317 .96485 L
.14286 .96979 L
.18254 .97472 L
.19448 .97619 L
s
1 0 .24 r
.02381 .03582 m
.06349 .03115 L
.10317 .02635 L
.12389 .02381 L
.02381 .02381 L
F
0 g
.02381 .03582 m
.06349 .03115 L
.10317 .02635 L
.12389 .02381 L
s
1 0 .24 r
.02381 .96418 m
.06349 .96885 L
.10317 .97365 L
.12389 .97619 L
.02381 .97619 L
F
0 g
.02381 .96418 m
.06349 .96885 L
.10317 .97365 L
.12389 .97619 L
s
1 0 0 r
.02381 .02709 m
.05211 .02381 L
.02381 .02381 L
F
0 g
.02381 .02709 m
.05211 .02381 L
s
1 0 0 r
.02381 .97291 m
.05211 .97619 L
.02381 .97619 L
F
0 g
.02381 .97291 m
.05211 .97619 L
s
1 .24 0 r
.5 .37852 m
.5196 .38095 L
.53968 .39218 L
.57231 .42063 L
.57604 .46032 L
.53968 .49077 L
.5 .49692 L
.46032 .49077 L
.42396 .46032 L
.42769 .42063 L
.46032 .39218 L
.4804 .38095 L
F
0 g
.5 .37852 m
.5196 .38095 L
.53968 .39218 L
.57231 .42063 L
.57604 .46032 L
.53968 .49077 L
.5 .49692 L
.46032 .49077 L
.42396 .46032 L
.42769 .42063 L
.46032 .39218 L
.4804 .38095 L
.5 .37852 L
s
1 .24 0 r
.46032 .50923 m
.5 .50308 L
.53968 .50923 L
.57604 .53968 L
.57231 .57937 L
.53968 .60782 L
.5196 .61905 L
.5 .62148 L
.4804 .61905 L
.46032 .60782 L
.42769 .57937 L
.42396 .53968 L
F
0 g
.46032 .50923 m
.5 .50308 L
.53968 .50923 L
.57604 .53968 L
.57231 .57937 L
.53968 .60782 L
.5196 .61905 L
.5 .62148 L
.4804 .61905 L
.46032 .60782 L
.42769 .57937 L
.42396 .53968 L
.46032 .50923 L
s
1 .48 0 r
.5 .40928 m
.53495 .42063 L
.53968 .42457 L
.55057 .46032 L
.53968 .47374 L
.5 .4906 L
.46032 .47374 L
.44943 .46032 L
.46032 .42457 L
.46505 .42063 L
F
0 g
.5 .40928 m
.53495 .42063 L
.53968 .42457 L
.55057 .46032 L
.53968 .47374 L
.5 .4906 L
.46032 .47374 L
.44943 .46032 L
.46032 .42457 L
.46505 .42063 L
.5 .40928 L
s
1 .48 0 r
.46032 .52626 m
.5 .5094 L
.53968 .52626 L
.55057 .53968 L
.53968 .57543 L
.53495 .57937 L
.5 .59072 L
.46505 .57937 L
.46032 .57543 L
.44943 .53968 L
F
0 g
.46032 .52626 m
.5 .5094 L
.53968 .52626 L
.55057 .53968 L
.53968 .57543 L
.53495 .57937 L
.5 .59072 L
.46505 .57937 L
.46032 .57543 L
.44943 .53968 L
.46032 .52626 L
s
1 .72 0 r
.5 .42245 m
.53789 .46032 L
.5 .48529 L
.46211 .46032 L
F
0 g
.5 .42245 m
.53789 .46032 L
.5 .48529 L
.46211 .46032 L
.5 .42245 L
s
1 .72 0 r
.5 .51471 m
.53789 .53968 L
.5 .57755 L
.46211 .53968 L
F
0 g
.5 .51471 m
.53789 .53968 L
.5 .57755 L
.46211 .53968 L
.5 .51471 L
s
1 .96 0 r
.5 .42886 m
.53114 .46032 L
.5 .48036 L
.46886 .46032 L
F
0 g
.5 .42886 m
.53114 .46032 L
.5 .48036 L
.46886 .46032 L
.5 .42886 L
s
1 .96 0 r
.5 .51964 m
.53114 .53968 L
.5 .57114 L
.46886 .53968 L
F
0 g
.5 .51964 m
.53114 .53968 L
.5 .57114 L
.46886 .53968 L
.5 .51964 L
s
.8 1 0 r
.5 .43525 m
.52445 .46032 L
.5 .47553 L
.47555 .46032 L
F
0 g
.5 .43525 m
.52445 .46032 L
.5 .47553 L
.47555 .46032 L
.5 .43525 L
s
.8 1 0 r
.5 .52447 m
.52445 .53968 L
.5 .56475 L
.47555 .53968 L
F
0 g
.5 .52447 m
.52445 .53968 L
.5 .56475 L
.47555 .53968 L
.5 .52447 L
s
.56 1 0 r
.5 .44208 m
.51736 .46032 L
.5 .47054 L
.48264 .46032 L
F
0 g
.5 .44208 m
.51736 .46032 L
.5 .47054 L
.48264 .46032 L
.5 .44208 L
s
.56 1 0 r
.5 .52946 m
.51736 .53968 L
.5 .55792 L
.48264 .53968 L
F
0 g
.5 .52946 m
.51736 .53968 L
.5 .55792 L
.48264 .53968 L
.5 .52946 L
s
.32 1 0 r
.5 .45029 m
.50902 .46032 L
.5 .46506 L
.49098 .46032 L
F
0 g
.5 .45029 m
.50902 .46032 L
.5 .46506 L
.49098 .46032 L
.5 .45029 L
s
.32 1 0 r
.5 .53494 m
.50902 .53968 L
.5 .54971 L
.49098 .53968 L
F
0 g
.5 .53494 m
.50902 .53968 L
.5 .54971 L
.49098 .53968 L
.5 .53494 L
s
1 0 .96 r
.97619 .06325 m
.93651 .05839 L
.89683 .05336 L
.85714 .04824 L
.81746 .04311 L
.77778 .0381 L
.7381 .03334 L
.69841 .02896 L
.65873 .02513 L
.64354 .02381 L
.97619 .02381 L
F
0 g
.97619 .06325 m
.93651 .05839 L
.89683 .05336 L
.85714 .04824 L
.81746 .04311 L
.77778 .0381 L
.7381 .03334 L
.69841 .02896 L
.65873 .02513 L
.64354 .02381 L
s
1 0 .96 r
.97619 .93675 m
.93651 .94161 L
.89683 .94664 L
.85714 .95176 L
.81746 .95689 L
.77778 .9619 L
.7381 .96666 L
.69841 .97104 L
.65873 .97487 L
.64354 .97619 L
.97619 .97619 L
F
0 g
.97619 .93675 m
.93651 .94161 L
.89683 .94664 L
.85714 .95176 L
.81746 .95689 L
.77778 .9619 L
.7381 .96666 L
.69841 .97104 L
.65873 .97487 L
.64354 .97619 L
s
1 0 .72 r
.97619 .05387 m
.93651 .04909 L
.89683 .04414 L
.85714 .03912 L
.81746 .0341 L
.77778 .0292 L
.7381 .02454 L
.73165 .02381 L
.97619 .02381 L
F
0 g
.97619 .05387 m
.93651 .04909 L
.89683 .04414 L
.85714 .03912 L
.81746 .0341 L
.77778 .0292 L
.7381 .02454 L
.73165 .02381 L
s
1 0 .72 r
.97619 .94613 m
.93651 .95091 L
.89683 .95586 L
.85714 .96088 L
.81746 .9659 L
.77778 .9708 L
.7381 .97546 L
.73165 .97619 L
.97619 .97619 L
F
0 g
.97619 .94613 m
.93651 .95091 L
.89683 .95586 L
.85714 .96088 L
.81746 .9659 L
.77778 .9708 L
.7381 .97546 L
.73165 .97619 L
s
1 0 .48 r
.97619 .04474 m
.93651 .04001 L
.89683 .03515 L
.85714 .03021 L
.81746 .02528 L
.80552 .02381 L
.97619 .02381 L
F
0 g
.97619 .04474 m
.93651 .04001 L
.89683 .03515 L
.85714 .03021 L
.81746 .02528 L
.80552 .02381 L
s
1 0 .48 r
.97619 .95526 m
.93651 .95999 L
.89683 .96485 L
.85714 .96979 L
.81746 .97472 L
.80552 .97619 L
.97619 .97619 L
F
0 g
.97619 .95526 m
.93651 .95999 L
.89683 .96485 L
.85714 .96979 L
.81746 .97472 L
.80552 .97619 L
s
1 0 .24 r
.97619 .03582 m
.93651 .03115 L
.89683 .02635 L
.87611 .02381 L
.97619 .02381 L
F
0 g
.97619 .03582 m
.93651 .03115 L
.89683 .02635 L
.87611 .02381 L
s
1 0 .24 r
.97619 .96418 m
.93651 .96885 L
.89683 .97365 L
.87611 .97619 L
.97619 .97619 L
F
0 g
.97619 .96418 m
.93651 .96885 L
.89683 .97365 L
.87611 .97619 L
s
1 0 0 r
.97619 .02709 m
.94789 .02381 L
.97619 .02381 L
F
0 g
.97619 .02709 m
.94789 .02381 L
s
1 0 0 r
.97619 .97291 m
.94789 .97619 L
.97619 .97619 L
F
0 g
.97619 .97291 m
.94789 .97619 L
s
.5 .5 m
.5 .5 .15873 0 365.73 arc
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{205, 204.875},
  ImageMargins->{{55.9375, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003=0000c1000`40O003h00OcGoo000EOol2000H
Ool4000HOol5000DOol2000IOol5000FOol4000IOol2000DOol001Aoo`04001oogoo000GOol00`00
Oomoo`0KOol00`00Oomoo`0COol01000Oomoo`006Woo00<007ooOol05Woo00<007ooOol06Goo00@0
07ooOol001=oo`005Woo00<007ooOol05goo00<007ooOol06Woo00<007ooOol04goo00@007ooOol0
01Yoo`03001oogoo01Moo`03001oogoo01Yoo`03001oogoo019oo`003Woo10001Goo00<007ooOol0
3goo100017oo00<007ooOol04Goo100017oo00<007ooOol04goo00@007ooOol001Yoo`03001oogoo
01Qoo`03001oogoo01Yoo`03001oogoo015oo`0057oo00@007ooOol001Moo`04001oogoo000JOol0
0`00Oomoo`0COol01000Oomoo`006Woo00<007ooOol05Woo00@007ooOol001Qoo`04001oogoo000C
Ool001Eoo`8001Uoo`8001Yoo`8001Ioo`8001Yoo`8001Uoo`8001Yoo`8001Aoo`00cGoo003=Ool0
0<eoo`00cGoo000?Oon^000@Ool000moo`05001oogooOol0000JOol00`00Oomoo`0IOol00`00Oomo
o`0HOol00`00Oomoo`0IOol00`00Oomoo`0HOol00`00Oomoo`0IOol01@00Oomoogoo000047oo0009
Ool20004Ool00`00Oomoo`1COol00`00Oomoo`1DOol00`00Oomoo`0>Ool000Qoo`04001oogoo0003
Ool00`00Oomoo`1COol00`00Oomoo`1DOol00`00Oomoo`0>Ool000Yoo`03001oogoo009oo`80009o
o`H000Eoo`L000Moo`D000Qoo`D000Uoo`L000iooa@000ioo`L000Uoo`D000Moo`H000Moo`L000Eo
o`H0009oo`80011oo`000Woo10001Goo00D007ooOomoo`0000=oo`04O0Ml1W`7O0L70007O0h70006
O1H70003O1h017`MO1il7W`N1`0000MT7f0OI1mP7f@OH1mT7`0>000DA1l>00001f0OI1mP7f@OH1mT
7f0O00L00005O1el7W`NO1il7@02O1h60007O1H70007O0h70003O0L4Ool00`00Oomoo`0>Ool000Qo
o`04001oogoo0003Ool01000Oomoogoo100000Ml3W`?O0il3g`>O0ml3P070007O1HR0003A1l0140O
A1m47d@O8P000T@O00E07d@OA1m47d0O028000Ml5PL00007O0ml3W`?O0il3g`>O0l010000goo00<0
07ooOol03Woo0009Ool20004Ool01000Oomoogoo17`>6`0000MP7f@OH1mT7f0OI1mP7`070007A1l>
000791lD000791l>0007A1l700001V@OH1mT7f0OI1mP7a`000=l3PAoo`03001oogoo00ioo`003goo
00@007ooOomoo`/00007O1il7G`NO1el7W`MO1h01`0000IT7f0OI1mP7f@OH1l70002A1l01D0OA1m4
7d@O@1l01`0000<T7bPO91l00R@O00<X7b@O00003@0001@87`@O21l47`PO11l87`@O21l47`PO11l8
7`@O21l47`PO11l87`@O3P000R@O00DX7b@O91lT7bPO00L000=47`04@1m47d@OA1l600001f0OI1mP
7f@OH1mT7f0O00L00007O1el7W`MO1il7G`NO1d02`000goo00<007ooOol03Woo000?Ool01000Oomo
ogoo100000=l7W`MO1h00W`N00=l7G`N00001P0000MT7f0OI1mP7f@OH1mT7`060007A1l7000791l7
00001`@O21l47`PO11l87`@O0280000721l47`PO11l87`@O21l01`001b@O1`001T@O1`0000MP7f@O
H1mT7f0OI1mP7`070002O1h01G`MO1il7W`NO1d010000Woo0P0047oo000?Ool02000OomoogooO1el
7W`MO1h700001f@OH1mT7f0OI1mP7f@O00L00003A1m07d@O00947`03@1l0000000D0000391lX7`00
00/0000311l87`0000/00280W``0000311l87`0000/0000391lX7`0000D00005@1m47d@OA1m07`02
A1l700001f0OI1mP7f@OH1mT7f0O00L00003O1el7W`M00Aoo`03001oogoo00ioo`003goo00@007oo
Oomoo`@00007I1mP7f@OH1mT7f0OI1l07@0000D87`@O21l47`PO00T000D0Wc0000D0W`T0000511l8
7`@O21l47`0M00001f0OI1mP7f@OH1mT7f0O00@000=oo`03001oogoo00ioo`003goo00@007ooOomo
oa8000<T7`04:1lT7b@O91l600001`PO11l87`@O21l47`PO00L000L0W`L0000>0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1Oa@0000>0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`L000L0W`L00006
11l87`@O21l47`PO1`0000DX7b@O91lT7bPO008T7a8000=oo`03001oogoo00ioo`003goo00@007oo
Oomoo`A47`L000LT7`L0000611l87`@O21l47`PO1`001`2O1`001`6O3P000`9o00D2W`9o0Wl2O`:O
00<2O`050Yl2O`9o0Wl2W`030Wl00`:O0000000<00070Il7000709l600001`PO11l87`@O21l47`PO
00L000LT7`L000=47`Aoo`03001oogoo00ioo`003goo00@007ooOomoo`@000<T7`04:1lT7b@O91l7
00001`@O21l47`PO11l87`@O00H000L0W`L000070Il1O`6O0Gl1W`5o0Il01`0000L2W`9o0Yl2O`:O
0Wl2W`0R00001`9o0Yl2O`:O0Wl2W`9o00L000070Gl1W`5o0Il1O`6O0Gl01`001P2O1`0000L87`@O
21l47`PO11l87`0700001BPO91lT7b@O:1l00R@O10000goo00<007ooOol03Woo000?Ool01000Oomo
ogoo12@O1`0000L47`PO11l87`@O21l47`07000609l700070Il700020Wl01@:O0Wl2O`9o0Yl01`00
8P=o1`000`9o00@2W`9o0Wl2O`L000L1W`H000L0W`L0000721l47`PO11l87`@O21l01`000b@O0goo
0P0047oo000?Ool01000Oomoogoo100000L47`PO11l87`@O21l47`07000709l600001`6O0Gl1W`5o
0Il1O`6O00L000070Yl2O`:O0Wl2W`9o0Yl01`000P=o00D3W`=o0gl3O`>O028000030gl3W`=o0083
O`030il3O`0000H000070Wl2W`9o0Yl2O`:O0Wl01`0000H1O`6O0Gl1W`5o0Il7000709l700001`PO
11l87`@O21l47`PO00@000=oo`03001oogoo00ioo`003goo00T007ooOomoo`PO11l87`@O21l01P00
202O1P001`6O1P000P9o00D2W`9o0Wl2O`:O00L000L3O`L00283n`L000L3O`L000<2O`040Yl2O`9o
0Wl600070Il6000809l6000010@O21l47`PO17oo00<007ooOol03Woo000?Ool01000Oomoogoo1@00
1P2O200000H1W`5o0Il1O`6O0Gl700001P9o0Yl2O`:O0Wl2W`L00083O`050il3O`=o0gl3W`070000
1@?l0o/3n`?k0o`00P?k8P000`?k00@3o0?k0o/3n`L000030gl3W`=o0083O`030il3O`0000H00006
0Wl2W`9o0Yl2O`:O1`0000H1W`5o0Il1O`6O0Gl8000609l50003Ool00`00Oomoo`0>Ool000moo`04
001oogooOol409l700070Il700000`9o0Yl2O`020Wl00`:O0000000500070gl700070o/700001@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00<3m0?c00001P001`?k1`001`=o1P0000D2W`9o0Wl2O`:O0082O`L000L1W`L000<0W`Aoo`03001o
ogoo00ioo`003goo00@007ooOomoo`@000070Gl1W`5o0Il1O`6O0Gl01`0000L2O`:O0Wl2W`9o0Yl2
O`0600020gl01@>O0gl3O`=o0il01`0000D3o0?k0o/3n`?l0083n`L000070o@3l`?d0o<3m0?c0o@0
8P0000L3l`?d0o<3m0?c0o@3l`0700030o/010?l0o/3n`?k1`0000<3O`>O0gl00P=o00<3W`000000
1@0000L2W`9o0Yl2O`:O0Wl2W`0700001`6O0Gl1W`5o0Il1O`6O00@0009oo`80011oo`003goo00@0
07ooOomoo`@1W`L000030Wl2W`9o0082O`030Yl2O`0000H000H3O`L000L3n`L000050o@3l`?c0o<3
m0020o<7000R0n`700000`?c0o@3l`020o<00`?d0o<0000600070o/600070gl700001@:O0Wl2O`9o
0Yl00P9o1`000`6O17oo00<007ooOol03Woo000?Ool01000Oomoogoo100000L2O`:O0Wl2W`9o0Yl2
O`0700000`=o0il3O`020gl00`>O0gl0000500001@?l0o/3n`?k0o`00P?k1`0000L3m0?c0o@3l`?d
0o<3m00700001`?/0n/3k0?[0n`3j`?/028000070n/3k0?[0n`3j`?/0n/01`0000L3l`?d0o<3m0?c
0o@3l`0700030o/00`?l0o/3n`0700020gl01@>O0gl3O`=o0il01`0000L2W`9o0Yl2O`:O0Wl2W`04
0003Ool00`00Oomoo`0>Ool000moo`04001oogooOol20Wl00`:O0Wl0000600070gl700060o/70000
1@?d0o<3l`?c0o@00P?c1`001`?/1`008P?T1`001`?/1`0000<3l`?d0o<00P?c00<3m0?c00001@00
1`?k1`001`=o1`0000<2W`9o0Wl017oo00<007ooOol03Woo000?Ool01000Oomoogoo100000<3O`>O
0gl00P=o00<3W`=o0gl01P000`?k00D3o0?k0o/3n`?l00D000090o@3l`?d0o<3m0?c0o@3l`?d00D0
00080n`3j`?/0n/3k0?[0n`3j`H000X3i1`000X3i0H000080n`3j`?/0n/3k0?[0n`3j`D000080o<3
m0?c0o@3l`?d0o<3m0D00083n`050o`3n`?k0o/3o0020o/500001@>O0gl3O`=o0il00`=o00<3W`00
00000P000goo00<007ooOol03Woo000?Ool01000Oomoogoo10=o20001P?k20000P?c00<3m0?c0o<0
2@001@?/20001P?T2P0001`7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0X000H3i0P000D3k0P00083l`030o@3l`?c00T000D3n`T000<3O`Aoo`03001o
ogoo00ioo`003goo00@007ooOomoo`@000<3n`040o`3n`?k0o/700001`?c0o@3l`?d0o<3m0?c00H0
00070n`3j`?/0n/3k0?[0n`01`001`?T1`0000h;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP5000
00h;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP1`001`?T1`0000H3j`?/0n/3k0?[0n`700001`?d
0o<3m0?c0o@3l`?d00L000050o`3n`?k0o/3o0020o/40002Ool2000@Ool000moo`04001oogooOol4
0o/700030o<01P?d0o<3l`?c0o@3l`D000P3k0D000T3i0D0000>2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0L001@Wh0L0000>2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0D000T3i0D000P3k0D0
00050o@3l`?c0o<3m0030o<00`?d0000000500030o/4Ool00`00Oomoo`0>Ool000moo`04001oogoo
Ool4000030?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0@000090n/3k0?[0n`3j`?/0n/3k0?[00@000X3
i0@0000<2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP1`000bOP00D[h2OP9n0Wh2_P00<Wh003:n0Wh2OP
00H000<Wh005:n0Wh2OP9n0[h0039n000b_P9n0Wh007000030_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h0@000X3i0<0000:0n/3k0?[0n`3j`?/0n/3k0?[0n`4000030?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0@000=oo`03001oogoo00ioo`0027oo10000goo00D007ooOomoo`?d00<3l`050o@3l`?c0o<3m002
0o<500090n`400090n@500002@OP2n07h0_P1n0;h0OP2n07h00700079n0>0006An0>00079n070000
2@_P1n0;h0OP2n07h0_P1n0;h00500080n@500090n`500000`?c0o@3l`020o<01@?d0o<3l`?c0o@0
17oo00<007ooOol03Woo0008Ool00`00Oomoo`04Ool02000Oomoogoo0o<3m0?c0o@700001`?/0n/3
k0?[0n`3j`?/00L000H3i0L000071n0;h0OP2n07h0_P1n001`000bOP00@[h2OP9n0Wh0L00005@n17
h4OPAn13h003An001D?PAn17h4OP@n000dOP00E3h4OPAn17h4?P00=7h005@n17h4OPAn13h003An00
0d?PAn00000600001B_P9n0Wh2OP:n000ROP1`0000L;h0OP2n07h0_P1n0;h00600070n@700001`?[
0n`3j`?/0n/3k0?[00L000030o<3m0?c00Aoo`03001oogoo00ioo`002Goo00<007ooOol00goo0P00
0Woo10001P?/20001P?T1`0000P7h0_P1n0;h0OP2n07h0_P1P0022OP1P003DOP5P003DOP1P0022OP
1P0000L7h0_P1n0;h0OP2n07h00800060n@800060n`40002Ool2000@Ool0009oo`@000Aoo`03001o
ogoo009oo`08001oogooOol3j`?/0n/3k0H000X3i0@0000<1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P
0`000ROP00D[h2OP9n0Wh2_P00<Wh004:n0000000003An001D?PAn17h4OP@n000dOP00=3h4OP0000
1@0001ISh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0H00005@n17h4OP
An13h003An001D?PAn17h4OP@n000`0000<Wh2_P9n000ROP00H[h2OP9n0Wh2_P9n03000030OP2n07
h0_P1n0;h0OP2n07h0_P1n0;h0@000X3i0H000030n/3k0?[00Aoo`03001oogoo00ioo`0027oo00@0
07ooOol000=oo`04001oogooOol4000<0n@400002`_P1n0;h0OP2n07h0_P1n0;h0OP2n001@002BOP
1@002DOP1`00029Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh0L000U7h0D000TWh0@0000<2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
100030?T10000goo00<007ooOol03Woo0009Ool20004Ool01000Oomoogoo2`?T1@0000T7h0_P1n0;
h0OP2n07h0_P1n001P0000D[h2OP9n0Wh2_P008Wh0L00003An13h4OP0097h004@n17h4OPAn050000
3VOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0D00003VOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn050002An001D?PAn17h4OP@n000TOP1`000bOP00<[h2OP9n001`0000T;h0OP2n07h0_P1n0;h0OP
2n001@002P?T17oo00<007ooOol03Woo000?Ool01000Oomoogoo10?T1`0000T7h0_P1n0;h0OP2n07
h0_P1n001@0022OP1@0034OP100000aWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn070002Ol001GnPOl1o
`7o0Oj000go000EoX7o0Ol1o`7nP00=o`003Oj1o`00000H0000<In1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?P100034OP1@0022OP1@0000T;h0OP2n07h0_P1n0;h0OP2n001`000`?T17oo00<007ooOol03Woo
000?Ool01000Oomoogoo100000`7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n0400000bOP:n0Wh0029n00
12_P9n0Wh2OP10000dOP00E3h4OPAn17h4?P00=7h003@n00000000<00009Hn1Wh6?PIn1Sh6OPHn1W
h6?P00L0000ROj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o
`7nPOl1oX7o0Oj1o`7nPOl0700002FOPHn1Wh6?PIn1Sh6OPHn1Wh0050003An001D?PAn17h4OP@n00
0dOP00I3h000000002OP:n039n001B_P9n0Wh2OP:n00100000`7h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n040003Ool00`00Oomoo`0>Ool000moo`0?001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P00D0
00TWh0@000Y7h0H00008Hn1Wh6?PIn1Sh6OPHn1Wh0H0009o`005Oj1o`7o0Ol1oX003Ol0017nPOl1o
`7o0500000EoX7o0Ol1o`7nP00=o`006Oj1o`7o0Ol1oX7o01@0000UWh6?PIn1Sh6OPHn1Wh6?PIn00
1P002DOP1@002BOP1@0000X7h0_P1n0;h0OP2n07h0_P1n0;h0=oo`80011oo`003goo00H007ooOomo
o`OP2n0900001B_P9n0Wh2OP:n000bOP00<[h00000000`0000=7h4?PAn000TOP00I3h4OPAn17h4?P
An0300002fOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn000`0000eo`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o
`007000DO/07000037nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`0@0000;Hn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh00300001D?PAn17h4OP@n000dOP00=3h4OPAn001@0000<Wh2_P9n000ROP00@[h2OP9n0Wh0T0
00031n1oogoo009oo`03001oogoo00ioo`003goo00@007ooOomoo`8000hWh0@000]7h0D0000;In1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh00300000go0Oj1o`002Ol001WnPOl1o`7o0Oj1o`0D0029n`0D0009o
`005Oj1o`7o0Ol1oX003Ol003gnP00000000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh004000<An04000>
9n020003Ool00`00Oomoo`0>Ool000moo`06001oogooOolWh2_P0bOP00H[h2OP9n0Wh2_P9n050000
1D?PAn17h4OP@n000dOP00=3h4OP0000100000aWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0400002Wo0
Oj1o`7nPOl1oX7o0Oj1o`7nP1000;7k0100000Yo`7nPOl1oX7o0Oj1o`7nPOl1oX0@0000;In1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh00500000dOP@n17h002An001T?PAn17h4OP@n17h0D0008Wh005:n0Wh2OP
9n0[h0039n04Ool00`00Oomoo`0>Ool000moo`04001oogooOol49n07000<An03000036OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh0D0009o`005Oj1o`7o0Ol1oX003Ol0017nP0000000047k0500047k00`00
00=o`7nPOl000Wo000IoX7o0Ol1o`7nPOl0500002fOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00100034OP
1`000bOP17oo00<007ooOol03Woo000?Ool01000Oomoogoo10000TOP00E3h4OPAn17h4?P00=7h004
@n17h4OPAn0500002VOPHn1Wh6?PIn1Sh6OPHn1Wh6?P1@0000aoX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP
Ol04000<O/07000057gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL07000<O/04
000037nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`0D0000:In1Sh6OPHn1Wh6?PIn1Sh6OPHn050002An00
1D?PAn17h4OP@n000dOP00A3h4OPAn17h0@0009oo`80011oo`003goo00@007ooOomoo`]7h0L0000;
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0040002Ol001GnPOl1o`7o0Oj000go000AoX7o0Ol1o`0<000]n
`0D0029m`0D000]n`0<00005Oj1o`7o0Ol1oX003Ol001WnPOl1o`7o0Oj1o`0<0000<In1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?P1`002TOP17oo00<007ooOol03Woo000?Ool01@00Oomoogoo@n000dOP1`00
00iWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P100000io`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o
`7nP10002Wk0100002amh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g010002Wk0100000eo`7nPOl1o
X7o0Oj1o`7nPOl1oX7o0Oj1o`00400003f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0070002
An000d?POomoo`02Ool00`00Oomoo`0>Ool000moo`04001oogooOol400004VOPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0<00005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj001@002gk0
0`0047g0500047g00`002gk010000Wo000EoX7o0Ol1o`7nP00=o`003Oj1o`7o000@0000BIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P10000goo00<007ooOol03Woo000?Ool05P00Oomo
ogooHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP100000ioX7o0Oj1o`7nPOl1oX7o0
Oj1o`7nPOl1oX7o00P0037k0100000im`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP1@0001Alh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c01@0000im`7gPOL1mh7g0ON1m`7gPOL1m
h7g0ON1m`7gP10002gk00`0000ioX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o01000015Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00Aoo`03001oogoo00ioo`003goo00l007ooOomoofOP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn001`0000=o`7nPOl000Wo000EoX7o0Ol1o`7nP00=o`0D000]n`0<0
00im`0@000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh003
O<1lh7cP00@000im`0<000]n`0@00003Ol1oX7o0009o`005Oj1o`7o0Ol1oX003Ol000gnP00000005
00002V?PIn1Sh6OPHn1Wh6?PIn1Sh6OP17oo00<007ooOol03Woo000?Ool02000OomoogooHn1Wh6?P
In0700003go0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`005000>O/0200003WgPOL1mh7g0ON1m
`7gPOL1mh7g0ON1m`7gPOL0300009Wc0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>0300003WgPOL1mh7g0ON1m`7gPOL1m
h7g0ON1m`7gPOL02000=O/05000047o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP1`0000=S
h6OPHn000goo0P0047oo000?Ool01000Oomoogoo100000=o`7nPOl000Wo000EoX7o0Ol1o`7nP00=o
`006Oj1o`7o0Ol1oX7o00`004Gk00P003Wg00P0000El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003
O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>0017c0O>1lh7cP
0P003Wg00P0047k010000Wo000EoX7o0Ol1o`7nP00=o`005Oj1o`7o0Ol1oX003Ol000gnP00000002
0003Ool00`00Oomoo`0>Ool000moo`0F001oogooOomoX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0
Oj1o`7nPOl05000AO/0300003WgPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL020000<7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`080000>ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m
`0<0015n`0D0000AOj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX004Ool00`00Oomoo`0>
Ool000moo`04001oogooOol3Ol001GnPOl1o`7o0Oj000go000=oX000000010004Wk010003Wg00`00
0WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1l
h7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00=l`7cP00000P003Wg010004Wk0
1P0000=o`7nPOl000Wo000IoX7o0Ol1o`7nPOl04Ool00`00Oomoo`0>Ool000moo`08001oogooOomo
X7o0Oj1o`0P001An`0@0000?OL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g000<0000HO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP2P0001Ql`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>0300003ggPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh004000DO/0800000gnPOl1oX004Ool00`00Oomoo`0>Ool000moo`04001oogooOol4
000IO/03000?OL040002O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh004O<1lh7cPO>05
000:O00500001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh006O<1lh7cPO>1l`7cP10003gg0
0P006Wk010000Woo0P0047oo000?Ool01000Oomoogoo6Gk01000011mh7g0ON1m`7gPOL1mh7g0ON1m
`7gPOL1mh7g0ON1m`080000EO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
00D001Al00D0000EO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c00080000?
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP00D001Qn`0Aoo`03001oogoo00ioo`003goo00@0
07ooOomooa9n`0L0019m`080009lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00=l`7cP
O>000P007W`00P000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>0017c0O>0000004Wg0
1`004Gk017oo00<007ooOol03Woo000?Ool01000Oomoogoo2gk01`0001Im`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh0<0000EO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cP0080029l0080000EO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c000<0000FOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON07
000:O/04Ool00`00Oomoo`0>Ool000Qoo`D0009oo`04001oogooOol4O/07000KOL0200000gcPO<1l
h002O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh003O<00000002Il00800003O>1l`7cP
009lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00=l`00000006gg01`000gk017oo00<0
07ooOol03Woo000:Ool00`00Oomoo`02Ool01000Oomoogoo1000021m`7gPOL1mh7g0ON1m`7gPOL1m
h7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP0P0001Il`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh08002Yl0080000FO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>02000087g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON040003Ool00`00Oomoo`0>Ool000Yo
o`03001oogoo009oo`80009ooamm`0D000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP
00=l`7cPO>000P00;W`00P000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>000gc0O>1l
h005000NOL03Ool2000@Ool0009oo`@000Aoo`03001oogoo009oo`0N001oogooOomm`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP1@0001Ulh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh002000BO00>000BO00200006Gc0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c000@0000JON1m`7gPOL1m
h7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`0Aoo`03001oogoo00ioo`00
2Woo00<007ooOol00Woo00@007ooOomooaMm`0<000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cP
O<000gcP00El`7cPO>1lh7c000=lh003O<00000000ml01D0019l00800003O>1l`7cP009lh005O<1l
h7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00Il`7cPO>1lh7c0O>04000FOL04Ool00`00Oomoo`0>
Ool000Uoo`8000Aoo`0F001oogooOomm`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON05
00007GcPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>000P0047`06@004G`00P0001el`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c000D0000AOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`004
Ool00`00Oomoo`0>Ool000moo`04001oogooOol;OL0700000gcPO<1lh002O>001Gc0O>1lh7cPO<00
0gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>000gc0O>1lh002000AO00L000AO0020003
O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cP
O<001`002Wg017oo00<007ooOol03Woo000?Ool02000OomoogooOL1mh7g0ON0700009GcPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cP0080011l0200019l0080000UO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<001`0000=m`7gPOL000goo0P0047oo
000?Ool01000Oomoogoo100000=lh7c0O>000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003
O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh007O<1lh7cPO>1l`7cP00004G`08`004W`0
00@007cPO>1l`0=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=l
h005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<0010000goo00<007ooOol03Woo000?Ool0<@00Oomo
ogooO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c00080015l02D0019l0080000/O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`0Aoo`03001oogoo00ioo`003goo00@007ooOomoo`=lh005O<1lh7cP
O>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0
O>1lh7cPO<000gcP0P004W`09`004g`00P0000El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>00
1Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>000gc0O>1oo`03Ool0
0`00Oomoo`0>Ool000moo`0/001oogooOoml`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh0<001=l02T001Al00<0
000WO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c000Aoo`03001oogoo00ioo`003goo00H007ooOomoogcPO<03O>00
1Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<00
0WcP10005G`0:`005W`010000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1l
h7cPO<000gcP00El`7cPO>1lh7c000=lh0Aoo`03001oogoo00ioo`003goo02D007ooOomoogc0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`003000HO00]000IO003000087cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c0O>1l`7cPO<03Ool2000@Ool000moo`04001oogooOol3O>001Gc0O>1lh7cP
O<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>000gc0O>000003000KO00]000LO003
0003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>000gc0O>1o
o`03Ool00`00Oomoo`0>Ool000moo`0N001oogooOoml`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP0`007W`0;`007W`00`0001Ylh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c017oo00<007ooOol03Woo000?Ool01P00Oomo
ogooO>1l`0=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<0020008G`0<00087`02@0000=lh7c0
O>000WcP00El`7cPO>1lh7c000=lh004O<1lh7cPO>04Ool00`00Oomoo`0>Ool000moo`0?001oogoo
Ooml`7cPO<1lh7c0O>1l`7cPO<1lh7c000L002Ql034002Ul00L0000:O>1l`7cPO<1lh7c0O>1l`7cP
O<04Ool00`00Oomoo`0>Ool000moo`04001oogooOol;000_O00b000_O00;0002Ool2000@Ool000mo
o`04001oogooOoljO00b000iO004Ool00`00Oomoo`0>Ool000moo`04001oogooOoliO00d000hO004
Ool00`00Oomoo`0>Ool000moo`04001oogooOoliO00d000hO004Ool00`00Oomoo`0>Ool000moo`04
001oogooOolhO00e000hO004Ool00`00Oomoo`0>Ool000moo`04001oogooOolhO00e000hO004Ool0
0`00Oomoo`0>Ool000moo`04001oogooOolhO00e000hO003Ool2000@Ool000moo`04001oogooOolg
O00f000hO004Ool00`00Oomoo`0>Ool000moo`04001oogooOolgO00g000gO004Ool00`00Oomoo`0>
Ool000Uoo`8000Aoo`04001oogooOolgO00g000gO004Ool00`00Oomoo`0>Ool000Qoo`04001oogoo
0003Ool01000Oomoogoo=g`0=`00=g`017oo00<007ooOol00goo0P0000=oo`0000001Woo0008Ool0
1000Oomoo`000goo1000=g`0=`00=g`01@001Woo00<007oo00001goo0008Ool01000Oomoo`000goo
00@007ooOomoocMl03L003Ml00Aoo`03001oogoo00Eoo`03001oogoo00Ioo`0027oo00@007ooOol0
00=oo`04001oogooOolgO00g000gO004Ool00`00Oomoo`03Ool200000goo00000006Ool000Uoo`80
00Aoo`04001oogooOolgO00g000gO004Ool00`00Oomoo`0>Ool000moo`04001oogooOolgO00g000g
O004Ool00`00Oomoo`0>Ool000moo`04001oogooOolgO00f000hO004Ool00`00Oomoo`0>Ool000mo
o`04001oogooOolhO00e000hO003Ool2000@Ool000moo`04001oogooOolhO00e000hO004Ool00`00
Oomoo`0>Ool000moo`04001oogooOolhO00e000hO004Ool00`00Oomoo`0>Ool000moo`04001oogoo
OoliO00d000hO004Ool00`00Oomoo`0>Ool000moo`04001oogooOoliO00d000hO004Ool00`00Oomo
o`0>Ool000moo`04001oogooOoljO00b000iO003Ool2000@Ool000moo`04001oogooOol;000_O00b
000_O00;0003Ool00`00Oomoo`0>Ool000moo`04001oogooOol3O>001Gc0O>1lh7cPO<000gcP1`00
:7`0<@00:G`01`0000El`7cPO>1lh7c000=lh003O<1lh7oo00=oo`03001oogoo00ioo`003goo01H0
07ooOomoogc0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh0P0025l0300025l00P0000A
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`004Ool00`00Oomoo`0>Ool000moo`06001o
ogooOomlh7c00gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000`00
7W`0;`007W`0100000=lh7c0O>000WcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>0017c0
O>1lh7cP17oo00<007ooOol03Woo000?Ool08@00OomoogooO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`004000KO00]000LO00300007Gc0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<0017oo00<007oo
Ool03Woo000?Ool01000Oomoogoo0gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0
O>1lh7cPO<000gcP00Il`7cPO>1lh7c0O>03000HO00/000JO0030002O>001Gc0O>1lh7cPO<000gcP
00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Wc0O>1lh7cPO<1lh0=oo`80011oo`003goo
02P007ooOomoogc0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh0@001El02X001Ml00@0000SO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`004Ool00`00Oomo
o`0>Ool000moo`06001oogooOomlh7c00gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>00
1Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh003O<1lh7cP00<001=l02T001Al00<000=lh005
O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003
O>0017c0O>1lh7cP17oo00<007ooOol03Woo000?Ool0;`00OomoogooO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<000P004W`09`004g`00P0002Ylh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<04Ool00`00Oomo
o`0>Ool000moo`04001oogooOol3O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1l
h7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh004O<1lh000000AO00U000B
O0020002O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0
O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh003O<1lh7oo00=oo`03001oogoo00ioo`003goo00@0
07ooOomoo`@0000/O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<00015l02<0019l000/001lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh0@0009oo`80011oo`003goo00@007ooOomoo`Am`0L0009lh005O<1l
h7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>00
0gc0O>1lh002000@O00Q000AO0020003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005
O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00=l`7cP00001P000gg017oo00<007ooOol03Woo
000?Ool03`00OomoogooOL1mh7g0ON1m`7gPOL1mh7g0ON1m`007000087c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>02000AO00L000AO002
000087c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c0O>0700002WgPOL1mh7g0ON1m`7gPOL1mh7g017oo00<007ooOol03Woo000?Ool01000Oomo
ogoo4Wg01@0000El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El
`7cPO>1lh7c00080011l01T0015l00800003O>1l`7cP009lh005O<1lh7cPO>1l`003O>001Gc0O>1l
h7cPO<000gcP00El`7cPO>1lh7c000=lh0D0015m`0Aoo`03001oogoo00ioo`0027oo1@000Woo01/0
07ooOomoogg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL000`0001al
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh08000ml
01D0019l0080000KO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cP
O<1lh7c000@0000FON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL04Ool0
0`00Oomoo`0>Ool000Yoo`03001oogoo009oo`04001oogooOolJOL040003O>001Gc0O>1lh7cPO<00
0gcP00El`7cPO>1lh7c000=lh005O<1lh7cPO>1l`002O>02000@O00@000BO0020003O>001Gc0O>1l
h7cPO<000gcP00El`7cPO>1lh7c000=lh006O<1lh7cPO>1l`7cP10006Wg017oo00<007ooOol03Woo
000:Ool00`00Oomoo`02Ool20002Ool07Wg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1m
h7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh0H0000GO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>00000DO008000DO0005`00O<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>001@0001imh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL03Ool2000@Ool000Yoo`03001oogoo009oo`04001oogooOol9000K
OL0200000gcPO<1lh002O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh08002al00800005
O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c0008001]m`0T000=oo`03001o
ogoo00ioo`002Woo00<007ooOol00Woo00@007ooOomoo`Un`0@0000ION1m`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON000P0001El`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<000`009W`00`0001Elh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>000P0001Um`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`0040008O/04Ool00`00Oomoo`0>Ool000Uoo`8000Aoo`04001oogooOol=O/05000F
OL030002O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh003O<1lh7cP0080029l008000=l
h005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00=l`7cP00000P005Wg01@0037k017oo00<0
07ooOol03Woo000?Ool01000Oomoogoo4Wk01P0001=m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`00200005GcPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh002
000NO00200005Gc0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`00200004WgP
OL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`0L0015n`0Aoo`03001oogoo00ioo`003goo
00@007ooOomooaQn`0D0011m`0800005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cP
O>1lh7c000D001Al00D00003O>1l`7cP009lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP
0P003gg01@0067k017oo00<007ooOol03Woo000?Ool01000Oomoogoo10006Gk00`0000mm`7gPOL1m
h7g0ON1m`7gPOL1mh7g0ON1m`7gPOL000`0001Ml`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh7c000D000Yl00D0000GO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1l
h7c0O>1l`7cPO<1lh00300003ggPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh002000JO/040002
Ool2000@Ool000moo`06001oogooOomo`7nP0Wo01`005Gk010003Wg010000gcP00El`7cPO>1lh7c0
00=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<002P0000=lh7c0O>000WcP00El`7cPO>1lh7c0
00=lh005O<1lh7cPO>1l`003O>000gc0O>1lh004000>OL04000DO/080003Ol04Ool00`00Oomoo`0>
Ool000moo`0?001oogooOomoX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP00L0019n`0@0000>OL1mh7g0ON1m
`7gPOL1mh7g0ON1m`7gPOL1mh0<0000dO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0
O>1l`7cPO<0300003Wg0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON04000BO/0600002gnPOl1oX7o0
Oj1o`7nPOl1oX7o0Oj0017oo00<007ooOol03Woo000?Ool01000Oomoogoo0go000EoX7o0Ol1o`7nP
00=o`005Oj1o`7o0Ol1oX002Ol05000AO/03000>OL0200001Gc0O>1lh7cPO<000gcP00El`7cPO>1l
h7c000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh005O<1l
h7cPO>1l`003O>02000>OL03000AO/050003Ol001GnPOl1o`7o0Oj000go000IoX7o0Ol1o`7nPOl04
Ool00`00Oomoo`0>Ool000moo`04001oogooOol400004gnPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP
Ol1oX7o0Oj1o`7nP00<0015n`080000>ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`080000/O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l`080000>ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`080
011n`0@0000COl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl0010000goo00<007oo
Ool03Woo000?Ool02000OomoogooIn1Sh6OPHn070002Ol001GnPOl1o`7o0Oj000go000EoX7o0Ol1o
`7nP00D000in`08000im`0D000=lh005O<1lh7cPO>1l`003O>001Gc0O>1lh7cPO<000gcP00El`7cP
O>1lh7c000=lh005O<1lh7cPO>1l`002O>05000>OL02000>O/040002Ol001GnPOl1o`7o0Oj000go0
00IoX7o0Ol1o`7nPOl0700000fOPHn1Wh003Ool2000@Ool000moo`0?001oogooOomSh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?P00L0000=Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj001@002gk00`00011m`7gP
OL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh0D0000HO>1l`7cPO<1lh7c0O>1l`7cPO<1lh7c0O>1l
`7cPO<1lh7c0O>1l`7cPO<1lh7c01@00011m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh0<0
00]n`0D0000=Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl001`0000YWh6?PIn1Sh6OPHn1Wh6?PIn1S
h0Aoo`03001oogoo00ioo`003goo01H007ooOomoofOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh0@00003Ol1oX7o0009o`005Oj1o`7o0Ol1oX003Ol000gnP0000000<O/04000AOL040000
1Gc0O>1lh7cPO<000gcP00El`7cPO>1lh7c000=lh0@0015m`0@000]n`0<00003Ol1oX7o0009o`005
Oj1o`7o0Ol1oX003Ol000gnP0000000200004FOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In0017oo00<007ooOol03Woo000?Ool01000Oomoogoo1000019Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn0300003Go0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o000D000]n`0<0000BON1m
`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g04000019mh7g0ON1m`7gPOL1mh7g0ON1m`7gP
OL1mh7g0ON1m`7gPOL03000;O/0400003Wo0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj0300004V?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0@000=oo`03001oogoo00ioo`003goo00@0
07ooOomoo`A7h0L0000>Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0@00005Oj1o`7o0Ol1oX003
Ol001WnPOl1o`7o0Oj1o`0@000Yn`0@002am`0@000Yn`0@0009o`005Oj1o`7o0Ol1oX003Ol000gnP
Ol1o`00500003V?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn070003An04Ool00`00Oomoo`0>Ool0
00moo`04001oogooOol2An001D?PAn17h4OP@n000dOP00=3h00000001@0000]Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?P00@0000>Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX0<000]n`0D0000ROL1mh7g0
ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0ON1m`7gPOL1mh7g0
ON05000;O/0300003Wo0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj03000036?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh0L000=7h005@n17h4OPAn13h002An04Ool00`00Oomoo`0>Ool000moo`04001oogoo
Ool4000>An0500002V?PIn1Sh6OPHn1Wh6?PIn1Sh6OP1@0000=o`7nPOl000Wo000EoX7o0Ol1o`7nP
009o`0@000an`0L001Am`0L000an`0@000=o`005Oj1o`7o0Ol1oX003Ol000gnP0000000300002V?P
In1Sh6OPHn1Wh6?PIn1Sh6OP1@003TOP10000Woo0P0047oo000?Ool01P00Oomoogoo9n0[h08Wh0L0
0003An13h4OP0097h005@n17h4OPAn13h002An03000036?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0D0
000;Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`003000@O/0D000@O/0300002gnPOl1oX7o0Oj1o`7nPOl1o
X7o0Oj001@0000]Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00@00003An13h4OP0097h005@n17h4OPAn13
h002An0700039n04Ool00`00Oomoo`0>Ool000moo`04001oogooOol;9n05000:An05000036?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh0@0009o`005Oj1o`7o0Ol1oX003Ol04000/O/0400001GnPOl1o`7o0
Oj000go000=oX7o000000`0000aSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn04000;An05000:9n04Ool0
0`00Oomoo`0>Ool000moo`05001oogooOol000029n001B_P9n0Wh2OP:n000bOP00D[h2OP9n0Wh2_P
00@00097h005@n17h4OPAn13h003An000d?P00000002000036OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h080000<Ol1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nP100097k0100000]o`7nPOl1oX7o0Oj1o`7nPOl1o
X7o000<0000<In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P10000dOP00E3h4OPAn17h4?P00=7h0@00003
9n0[h2OP008Wh005:n0Wh2OP9n0[h0039n000b_P9n000003Ool00`00Oomoo`0>Ool000moo`05001o
ogooOol;h00:00099n04000;An0400002V?PIn1Sh6OPHn1Wh6?PIn1Sh6OP10000Wo000EoX7o0Ol1o
`7nP00=o`003Oj1o`00000L001An`0P0009o`005Oj1o`7o0Ol1oX003Ol000gnPOl00000200002fOP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn0010002TOP1@002BOP2P0017oo00<007ooOol03Woo000?Ool03`00
Oomoogoo1n0;h0OP2n07h0_P1n0;h0OP2n07h00500000bOP:n0Wh0029n000b_P9n0Wh00700000dOP
@n17h002An000d?PAn17h006000026OPHn1Wh6?PIn1Sh6OPHn0600003Wo0Oj1o`7nPOl1oX7o0Oj1o
`7nPOl1oX7o0Oj0D00003Wo0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1oX7o0Oj06000026OPHn1Wh6?PIn1S
h6OPHn0600000dOP@n17h002An000d?PAn17h00600001B_P9n0Wh2OP:n000bOP00<[h00000000`00
00X;h0OP2n07h0_P1n0;h0OP2n07h0=oo`80011oo`003goo00@007ooOomoo`@0000<2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP10002bOP1@002DOP1@0000UWh6?PIn1Sh6OPHn1Wh6?PIn001`000go000Eo
X7o0Ol1o`7nP00=o`005Oj1o`7o0Ol1oX003Ol001GnPOl1o`7o0Oj000go000EoX7o0Ol1o`7nP009o
`0L00009Hn1Wh6?PIn1Sh6OPHn1Wh6?P00D000U7h0D000/Wh0@0000<2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP10000goo00<007ooOol03Woo000?Ool01000Oomoogoo10?T1`0000T;h0OP2n07h0_P1n0;
h0OP2n0010000bOP00D[h2OP9n0Wh2_P00<Wh003:n00000000800097h005@n17h4OPAn13h003An04
000036?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0L0000DOl1oX7o0Oj1o`7nPOl1oX7o0Oj1o`7nPOl1o
X7o0Oj1o`7nPOl1oX0L0000<Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP10000TOP00E3h4OPAn17h4?P
00=7h0@000039n0[h2OP008Wh006:n0Wh2OP9n0[h2OP1@0000T7h0_P1n0;h0OP2n07h0_P1n001`00
0`?T17oo00<007ooOol03Woo000?Ool01000Oomoogoo2`?T1`0000H;h0OP2n07h0_P1n0700099n05
0009An0500003V?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0D00003V?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn050009An0500099n0600001`OP2n07h0_P1n0;h0OP00L000X3i0Aoo`03001oogoo
00ioo`0027oo10000goo00@007ooOomoo`@000h3i0D000082n07h0_P1n0;h0OP2n07h0D000039n0[
h2OP008Wh004:n0Wh2OP9n050002An001D?PAn17h4OP@n000TOP1`00029Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0L00003An13
h4OP0097h004@n17h4OPAn0500001B_P9n0Wh2OP:n000bOP00<[h00000000`0000P;h0OP2n07h0_P
1n0;h0OP1@003P?T10000goo00<007ooOol03Woo0008Ool00`00Oomoo`04Ool01000Oomoogoo10?/
1@003P?T0P0000/7h0_P1n0;h0OP2n07h0_P1n0;h0OP00<000/Wh0<000e7h0D0000HHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP1@003DOP0`002bOP0`0000/;h0OP
2n07h0_P1n0;h0OP2n07h0_P008000h3i0D000<3k0Aoo`03001oogoo00ioo`002Goo00<007ooOol0
0goo0P000Woo100000D3j`?/0n/3k0?[00T000L3i0H000082n07h0_P1n0;h0OP2n07h0H0008Wh006
:n0Wh2OP9n0[h2OP1P000dOP00E3h4OPAn17h4?P00=7h003@n00000001H000=7h005@n17h4OPAn13
h003An000d?P0000000400029n001R_P9n0Wh2OP:n0Wh0H000082n07h0_P1n0;h0OP2n07h0H000L3
i0T000050n`3j`?/0n/3k0040002Ool2000@Ool000Yoo`03001oogoo009oo`04001oogooOol20o<0
0`?d0o<0000600070n`600070n@700001`_P1n0;h0OP2n07h0_P00L000LWh0L00297h0L000LWh0L0
00071n0;h0OP2n07h0_P1n001`001P?T1`001`?/1`0000<3m0?c0o<017oo00<007ooOol03Woo0008
Ool01000Oomoo`000goo00l007ooOomoo`?c0o@3l`?d0o<3m0?c0o@3l`?d0o<01@0000P3j`?/0n/3
k0?[0n`3j`?/1@002@?T1@0000T;h0OP2n07h0_P1n0;h0OP2n001`000ROP00D[h2OP9n0Wh2_P0280
00039n0[h2OP008Wh003:n0Wh00000H000091n0;h0OP2n07h0_P1n0;h0OP00D000P3i0D000090n`3
j`?/0n/3k0?[0n`3j`?/00D0000:0o@3l`?d0o<3m0?c0o@3l`?d0o<4Ool00`00Oomoo`0>Ool000Uo
o`8000Aoo`04001oogooOol400001@?d0o<3l`?c0o@00`?c00@3m0?c0o<3l`@000T3k0@000X3i0@0
000<1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1`008ROP1`0000`7h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n04000:0n@3000:0n`400020o<01@?d0o<3l`?c0o@00`?c00<3m0?c00000`000goo00<007ooOol0
3Woo000?Ool01000Oomoogoo0`?k00<3o00000001@0000T3m0?c0o@3l`?d0o<3m0?c0o@0100000T3
j`?/0n/3k0?[0n`3j`?/0n/01@002@?T1@0000h7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1`00
0ROP00D[h2OP9n0Wh2_P00<Wh005:n0Wh2OP9n0[h0039n000b_P9n00000600003POP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n0500090n@5000020?/0n/3k0?[0n`3j`?/0n/500002@?c0o@3l`?d0o<3
m0?c0o@3l`0700000`?k0o`3n`04Ool00`00Oomoo`0>Ool000moo`04001oogooOol400070o/70000
1P?d0o<3l`?c0o@3l`L000L3k0L000L3i0L0000>1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h1@0
000>1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0L000L3i0L000L3k0H000030o<3m0?c0083l`03
0o@3l`0000H000L3n`@0009oo`80011oo`003goo00H007ooOomoo`=o0il20gl800000`?k0o`3n`02
0o/00`?l0000000600001@?c0o@3l`?d0o<0200000H3k0?[0n`3j`?/0n/800060n@900007POP2n07
h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0T000H3
i0P000060n`3j`?/0n/3k0?[200000D3m0?c0o@3l`?d00P000030o/3o0?k0083n`030o`0000000H0
00<3O`Aoo`03001oogoo00ioo`003goo00@007ooOomoo`@000P3O`H000P3n`D000030o<3m0?c0083
l`030o@3l`?c00H000P3k0H000T3i1h000T3i0H000P3k0H000030o<3m0?c0083l`030o@3l`?c00D0
00P3n`H000P3O`@000=oo`03001oogoo00ioo`003goo00P007ooOomoo`9o0Yl2O`:O1`0000D3W`=o
0gl3O`>O0083O`H000<3n`040o`3n`?k0o/700001`?c0o@3l`?d0o<3m0?c00L000070n/3k0?[0n`3
j`?/0n/01`008P?T1`0000L3k0?[0n`3j`?/0n/3k00700001`?d0o<3m0?c0o@3l`?d00L000060o`3
n`?k0o/3o0?k1`000`=o00@3W`=o0gl3O`L000030Wl2W`9o00Aoo`03001oogoo00ioo`003goo00@0
07ooOomoo`@00082O`050Yl2O`9o0Wl2W`0700060gl700070o/700000`?c0o@3l`020o<00`?d0o<0
000600070n`R00070n`700001@?d0o<3l`?c0o@00P?c1`001`?k1P001`=o1`000`9o00@2W`9o0Wl2
O`@000=oo`03001oogoo00ioo`003goo00P007ooOomoo`5o0Il1O`6O1`0000L2W`9o0Yl2O`:O0Wl2
W`0600000`=o0il3O`020gl00`>O0gl0000600030o/010?l0o/3n`?k1`0000L3l`?d0o<3m0?c0o@3
l`0700008P?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/1`0000L3m0?c0o@3l`?d0o<3m00700001@?l0o/3n`?k0o`00P?k1`000P=o
00@3W`=o0gl3O`L000070Wl2W`9o0Yl2O`:O0Wl01`0000<1O`6O0Gl017oo00<007ooOol03Woo000?
Ool01000Oomoogoo10001`6O1`000P9o00@2W`9o0Wl2O`L000L3O`L000L3n`L000030o<3m0?c0083
l`030o@3l`00024000050o@3l`?c0o<3m0020o<700070o/700070gl600030Wl010:O0Wl2O`9o1`00
1`6O10000Woo0P0047oo000?Ool01000Oomoogoo102O1`0000L1W`5o0Il1O`6O0Gl1W`0600001`9o
0Yl2O`:O0Wl2W`9o00H00083O`060il3O`=o0gl3W`=o1P0000D3o0?k0o/3n`?l00<3n`L0000R0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@700001@?l0o/3n`?k0o`00`?k1P000P=o00H3W`=o0gl3O`>O0gl600001P:O0Wl2W`9o0Yl2
O`L000070Gl1W`5o0Il1O`6O0Gl01`000`2O17oo00<007ooOol03Woo000?Ool01000Oomoogoo1000
1`2O1`001P6O1`000`9o00<2W`9o0Wl020001P=o20001`?k8P001`?k20001P=o200000<2O`:O0Wl0
0P9o00<2W`00000010001`6O1`001`2O10000goo00<007ooOol03Woo000?Ool02000Oomoogoo11l8
7`@O21l7000709l600001`5o0Il1O`6O0Gl1W`5o00L000070Wl2W`9o0Yl2O`:O0Wl01`0000<3O`>O
0gl00P=o00<3W`=o00001P000`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3
n`?k0o`00`?k00D3o0?k0o/3n`?l0083n`L00083O`050il3O`=o0gl3W`0700001`:O0Wl2W`9o0Yl2
O`:O00L000060Il1O`6O0Gl1W`5o1`001`2O1`0000<47`PO11l017oo00<007ooOol03Woo000?Ool0
1000Oomoogoo100000L87`@O21l47`PO11l87`07000609l700070Il700030Wl010:O0Wl2O`9o1`00
1`=o8P001`=o1`000P9o00D2W`9o0Wl2O`:O00L000L1W`H000L0W`L0000711l87`@O21l47`PO11l0
10000goo00<007ooOol03Woo000?Ool01000Oomoogoo0b@O00<X7`0000001@0000L87`@O21l47`PO
11l87`06000709l700001`5o0Il1O`6O0Gl1W`5o00L000070Wl2W`9o0Yl2O`:O0Wl01`0000<3O`>O
0gl00P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00L000070Yl2O`:O0Wl2W`9o0Yl01`0000L1W`5o0Il1O`6O0Gl1W`07000609l700001`@O
21l47`PO11l87`@O00L0000391lX7b@O00=oo`80011oo`003goo00@007ooOomoo`@000LT7`L00006
21l47`PO11l87`@O1`001`2O1`001`6O1`000`9o00@2W`9o0Wl2Ob800082O`050Yl2O`9o0Wl2W`07
00070Il7000709l600001`@O21l47`PO11l87`@O00L000LT7`@000=oo`03001oogoo00ioo`003goo
00D007ooOomood0O00=47`L0008T7`05:1lT7b@O91lX7`0600001`@O21l47`PO11l87`@O00L000L0
W`L000070Gl1W`5o0Il1O`6O0Gl03P0001@2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o3P0000L1W`5o0Il1O`6O0Gl1W`07000709l700001PPO11l87`@O21l47`L0000391lX7b@O
008T7`03:1lT7`0000H000947`03@1moogoo009oo`03001oogoo00ioo`003goo00@007ooOomoo`X0
0003A1l0000000D000HT7`L0000711l87`@O21l47`PO11l01`001`2O3P001`6O50001`6O3P001`2O
1`0000L87`@O21l47`PO11l87`06000791l700000d@O000000080003Ool00`00Oomoo`0>Ool000mo
o`04001oogooOol400001V0OI1mP7f@OH1mT7ah0000511l87`@O21l47`09000<09lR000<09l90000
1@PO11l87`@O21l07P0000IP7f@OH1mT7f0OI1l40003Ool00`00Oomoo`0>Ool000moo`04001oogoo
Ool3O1h00g`M0000000500001f0OI1mP7f@OH1mT7f0O00H000M47`L0008T7``0000321l47`0000/0
0280W``0000321l47`0000/0008T7`L000I47`L00007I1mP7f@OH1mT7f0OI1l01`0000=l7W`MO1h0
17oo00<007ooOol03Woo000?Ool01000Oomoogoo100000Ml7G`NO1el7W`MO1il7@0700001V0OI1mP
7f@OH1mT7`L00003A1m07d@O00947`03@1m47`0000H00005:1lT7b@O91lX7`0291l700001`PO11l8
7`@O21l47`PO0280000711l87`@O21l47`PO11l01`000b@O00@X7b@O91lT7`L00005@1m47d@OA1m0
7`02A1l600001f@OH1mT7f0OI1mP7f@O00L00007O1il7G`NO1el7W`MO1h010000Woo0P0047oo000?
Ool01000Oomoogoo2`000W`N00El7G`NO1il7W`M00H00007I1mP7f@OH1mT7f0OI1l01`001d@O1`00
1b@O500000L47`PO11l87`@O21l47`0E000791l70007A1l700001V0OI1mP7f@OH1mT7`L00003O1il
7G`N009l7P03O1el7P0000X000=oo`03001oogoo00ioo`003goo00P007ooOomoog`>O0ml3W`?6`00
00MT7f0OI1mP7f@OH1mT7`0700000d@O@1m47`02A1l00d0OA1l0000=00000b@O:1lT7`0291l01BPO
91lT7b@O:1l00b@O1`0000<T7bPO91l00R@O00DX7b@O91lT7bPO00<T7`03:1l0000000`00005@1m4
7d@OA1m07`02A1l700001f0OI1mP7f@OH1mT7f0O01/00003O0il3g`>00Aoo`03001oogoo00ioo`00
2Goo0P0017oo00@007ooOomoo`@000Ml3PL000Il5R<000M47b8000M47b8000Ml5PL000Ml3P@000=o
o`03001oogoo00ioo`0027oo00@007ooOol000=oo`04001oogooOol300000g`70000000500001g`?
O0il3g`>O0ml3W`?00H000Ml5PL00007O1el7W`MO1il7G`NO1d01`0000MP7f@OH1mT7f0OI1mP7`0>
0003A1l01D0OA1m47d@O@1l00d@O00E07d@OA1m47d0O00=47`03@1l0000000`00007I1mP7f@OH1mT
7f0OI1l01`0000Ml7W`MO1il7G`NO1el7P070006O1H700001g`>O0ml3W`?O0il3g`>00L00004O0H0
00000003Ool00`00Oomoo`0>Ool000Yoo`03001oogoo009oo`80009oo`=l00<000=l1`03O0Il1`00
00H000Il3PH000Ql5PD0009l7P05O1el7W`NO1il7@02O1h700003V0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1lD00003V0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l70003O1h01W`MO1il7W`NO1el
7PD000Ml5PH000Ml3PL0009l1`03O0Il1g`700<0009l00=oo`80011oo`002goo00D007ooOomoo`00
05Eoo`03001oogoo05Aoo`03001oogoo00ioo`0027oo00@007ooOol000=oo`03001oogoo05=oo`03
001oogoo05Aoo`03001oogoo00ioo`002Goo0P0017oo00D007ooOomoo`0001Yoo`03001oogoo01Uo
o`03001oogoo01Qoo`03001oogoo01Uoo`03001oogoo01Qoo`03001oogoo01Uoo`05001oogooOol0
000@Ool000moojh0011oo`00cGoo003=Ool00<eoo`00cGoo003=Ool00<eoo`00cGoo001SOol2001X
Ool006Aoo`03001oogoo06Ioo`00IGoo00<007ooOol0IGoo001TOol00`00Ool0001VOol006=oo`04
001oogoo001VOol0069oo`<00003Ool0000006Eoo`00cGoo003=Ool00<eoo`00cGoo003=Ool00<eo
o`00\
\>"],
  ImageRangeCache->{{{0, 204}, {203.875, 0}} -> {-3.70345, -3.55583, \
0.0363381, 0.0363381}}]
}, Open  ]],

Cell["\<\
The black disk in the center of the picture represents the sphere. \
The different shadings outline the different strengths of the stream function \
around the disk.\
\>", "Text"],

Cell["\<\
The velocity components follow immediately by using the definitions\
\
\>", "Text"],

Cell[BoxData[
    \(ur[r_, \[Theta]_, a_, U_] := 
      \[PartialD]\_\[Theta] \[CapitalPsi][r, \[Theta], a, U]\/\(r\^2\ 
          Sin[\[Theta]]\)\)], "Input"],

Cell[BoxData[
    \(uth[r_, \[Theta]_, a_, U_] := 
      \(-\(\[PartialD]\_r \[CapitalPsi][r, \[Theta], a, U]\/\(r\ 
              Sin[\[Theta]]\)\)\)\)], "Input"],

Cell["\<\
A representation of the radial component of the velocity in \
Cartesian coordinates follow by\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(u1 = ur[r, \[Theta], 1, 1] /. coordTrafo\)], "Input"],

Cell[BoxData[
    \(\(\((1\/\@\(x\^2 + y\^2\) - 3\ \@\(x\^2 + y\^2\) + 2\ \((x\^2 + y\^2)\))
          \)\ Cos[ArcTan[x, y]]\)\/\(2\ \((x\^2 + y\^2)\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The graphical representation in a contour plot shows the orthogonal \
orientation of the velocity field ",
  Cell[BoxData[
      \(TraditionalForm\`u\_r\)]],
  " to the stream function:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[{
        ContourPlot[
          If[x == 0 && y == 0, 0, u1], {x, \(-3\), 3}, {y, \(-3\), 3}, 
          PlotPoints \[Rule] 25, ColorFunction \[Rule] Hue, 
          AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True, 
          Contours \[Rule] 25, DisplayFunction \[Rule] Identity], 
        Graphics[Disk[{0, 0}, 1.1]]}, AspectRatio \[Rule] Automatic, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.18254 -0.0125 -6 -9 ]
[.18254 -0.0125 6 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -12 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .18254 -12 -4.5 ]
[-0.0125 .18254 0 4.5 ]
[-0.0125 .34127 -12 -4.5 ]
[-0.0125 .34127 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .65873 -6 -4.5 ]
[-0.0125 .65873 0 4.5 ]
[-0.0125 .81746 -6 -4.5 ]
[-0.0125 .81746 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 .5 0 -7.5 ]
[1.025 .5 10 7.5 ]
[.5 1.025 -5 0 ]
[.5 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(-3)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(-2)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(-1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(1)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(-3)] -0.0125 .02381 1 0 Mshowa
0 .18254 m
.00625 .18254 L
s
[(-2)] -0.0125 .18254 1 0 Mshowa
0 .34127 m
.00625 .34127 L
s
[(-1)] -0.0125 .34127 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .65873 m
.00625 .65873 L
s
[(1)] -0.0125 .65873 1 0 Mshowa
0 .81746 m
.00625 .81746 L
s
[(2)] -0.0125 .81746 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(3)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .05556 m
.00375 .05556 L
s
0 .0873 m
.00375 .0873 L
s
0 .11905 m
.00375 .11905 L
s
0 .15079 m
.00375 .15079 L
s
0 .21429 m
.00375 .21429 L
s
0 .24603 m
.00375 .24603 L
s
0 .27778 m
.00375 .27778 L
s
0 .30952 m
.00375 .30952 L
s
0 .37302 m
.00375 .37302 L
s
0 .40476 m
.00375 .40476 L
s
0 .43651 m
.00375 .43651 L
s
0 .46825 m
.00375 .46825 L
s
0 .53175 m
.00375 .53175 L
s
0 .56349 m
.00375 .56349 L
s
0 .59524 m
.00375 .59524 L
s
0 .62698 m
.00375 .62698 L
s
0 .69048 m
.00375 .69048 L
s
0 .72222 m
.00375 .72222 L
s
0 .75397 m
.00375 .75397 L
s
0 .78571 m
.00375 .78571 L
s
0 .84921 m
.00375 .84921 L
s
0 .88095 m
.00375 .88095 L
s
0 .9127 m
.00375 .9127 L
s
0 .94444 m
.00375 .94444 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.18254 .99375 m
.18254 1 L
s
.34127 .99375 m
.34127 1 L
s
.5 .99375 m
.5 1 L
s
.65873 .99375 m
.65873 1 L
s
.81746 .99375 m
.81746 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.05556 .99625 m
.05556 1 L
s
.0873 .99625 m
.0873 1 L
s
.11905 .99625 m
.11905 1 L
s
.15079 .99625 m
.15079 1 L
s
.21429 .99625 m
.21429 1 L
s
.24603 .99625 m
.24603 1 L
s
.27778 .99625 m
.27778 1 L
s
.30952 .99625 m
.30952 1 L
s
.37302 .99625 m
.37302 1 L
s
.40476 .99625 m
.40476 1 L
s
.43651 .99625 m
.43651 1 L
s
.46825 .99625 m
.46825 1 L
s
.53175 .99625 m
.53175 1 L
s
.56349 .99625 m
.56349 1 L
s
.59524 .99625 m
.59524 1 L
s
.62698 .99625 m
.62698 1 L
s
.69048 .99625 m
.69048 1 L
s
.72222 .99625 m
.72222 1 L
s
.75397 .99625 m
.75397 1 L
s
.78571 .99625 m
.78571 1 L
s
.84921 .99625 m
.84921 1 L
s
.88095 .99625 m
.88095 1 L
s
.9127 .99625 m
.9127 1 L
s
.94444 .99625 m
.94444 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .18254 m
1 .18254 L
s
.99375 .34127 m
1 .34127 L
s
.99375 .5 m
1 .5 L
s
.99375 .65873 m
1 .65873 L
s
.99375 .81746 m
1 .81746 L
s
.99375 .97619 m
1 .97619 L
s
.125 Mabswid
.99625 .05556 m
1 .05556 L
s
.99625 .0873 m
1 .0873 L
s
.99625 .11905 m
1 .11905 L
s
.99625 .15079 m
1 .15079 L
s
.99625 .21429 m
1 .21429 L
s
.99625 .24603 m
1 .24603 L
s
.99625 .27778 m
1 .27778 L
s
.99625 .30952 m
1 .30952 L
s
.99625 .37302 m
1 .37302 L
s
.99625 .40476 m
1 .40476 L
s
.99625 .43651 m
1 .43651 L
s
.99625 .46825 m
1 .46825 L
s
.99625 .53175 m
1 .53175 L
s
.99625 .56349 m
1 .56349 L
s
.99625 .59524 m
1 .59524 L
s
.99625 .62698 m
1 .62698 L
s
.99625 .69048 m
1 .69048 L
s
.99625 .72222 m
1 .72222 L
s
.99625 .75397 m
1 .75397 L
s
.99625 .78571 m
1 .78571 L
s
.99625 .84921 m
1 .84921 L
s
.99625 .88095 m
1 .88095 L
s
.99625 .9127 m
1 .9127 L
s
.99625 .94444 m
1 .94444 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.5 0 m
.5 1 L
s
gsave
.5 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.08 1 0 r
.02381 .97619 m
.97619 .97619 L
.97619 .02381 L
.02381 .02381 L
F
0 1 .16 r
.04024 .97619 m
.0519 .93651 L
.06223 .89683 L
.06349 .89159 L
.07105 .85714 L
.07817 .81746 L
.08352 .77778 L
.08712 .7381 L
.08916 .69841 L
.08996 .65873 L
.08994 .61905 L
.08955 .57937 L
.08915 .53968 L
.08899 .5 L
.08915 .46032 L
.08955 .42063 L
.08994 .38095 L
.08996 .34127 L
.08916 .30159 L
.08712 .2619 L
.08352 .22222 L
.07817 .18254 L
.07105 .14286 L
.06349 .10841 L
.06223 .10317 L
.0519 .06349 L
.04024 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.5 Mabswid
.04024 .97619 m
.0519 .93651 L
.06223 .89683 L
.06349 .89159 L
.07105 .85714 L
.07817 .81746 L
.08352 .77778 L
.08712 .7381 L
.08916 .69841 L
.08996 .65873 L
.08994 .61905 L
.08955 .57937 L
.08915 .53968 L
.08899 .5 L
.08915 .46032 L
.08955 .42063 L
.08994 .38095 L
.08996 .34127 L
.08916 .30159 L
.08712 .2619 L
.08352 .22222 L
.07817 .18254 L
.07105 .14286 L
.06349 .10841 L
.06223 .10317 L
.0519 .06349 L
.04024 .02381 L
s
0 1 .4 r
.17462 .97619 m
.18154 .93651 L
.18254 .93019 L
.187 .89683 L
.19072 .85714 L
.19242 .81746 L
.19198 .77778 L
.18951 .7381 L
.18548 .69841 L
.18254 .67356 L
.18062 .65873 L
.1758 .61905 L
.17178 .57937 L
.16914 .53968 L
.16822 .5 L
.16914 .46032 L
.17178 .42063 L
.1758 .38095 L
.18062 .34127 L
.18254 .32644 L
.18548 .30159 L
.18951 .2619 L
.19198 .22222 L
.19242 .18254 L
.19072 .14286 L
.187 .10317 L
.18254 .06981 L
.18154 .06349 L
.17462 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.17462 .97619 m
.18154 .93651 L
.18254 .93019 L
.187 .89683 L
.19072 .85714 L
.19242 .81746 L
.19198 .77778 L
.18951 .7381 L
.18548 .69841 L
.18254 .67356 L
.18062 .65873 L
.1758 .61905 L
.17178 .57937 L
.16914 .53968 L
.16822 .5 L
.16914 .46032 L
.17178 .42063 L
.1758 .38095 L
.18062 .34127 L
.18254 .32644 L
.18548 .30159 L
.18951 .2619 L
.19198 .22222 L
.19242 .18254 L
.19072 .14286 L
.187 .10317 L
.18254 .06981 L
.18154 .06349 L
.17462 .02381 L
s
0 1 .64 r
.28987 .97619 m
.29314 .93651 L
.29486 .89683 L
.29454 .85714 L
.29159 .81746 L
.28554 .77778 L
.27644 .7381 L
.26521 .69841 L
.2619 .68714 L
.25345 .65873 L
.24282 .61905 L
.23456 .57937 L
.22939 .53968 L
.22763 .5 L
.22939 .46032 L
.23456 .42063 L
.24282 .38095 L
.25345 .34127 L
.2619 .31286 L
.26521 .30159 L
.27644 .2619 L
.28554 .22222 L
.29159 .18254 L
.29454 .14286 L
.29486 .10317 L
.29314 .06349 L
.28987 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.28987 .97619 m
.29314 .93651 L
.29486 .89683 L
.29454 .85714 L
.29159 .81746 L
.28554 .77778 L
.27644 .7381 L
.26521 .69841 L
.2619 .68714 L
.25345 .65873 L
.24282 .61905 L
.23456 .57937 L
.22939 .53968 L
.22763 .5 L
.22939 .46032 L
.23456 .42063 L
.24282 .38095 L
.25345 .34127 L
.2619 .31286 L
.26521 .30159 L
.27644 .2619 L
.28554 .22222 L
.29159 .18254 L
.29454 .14286 L
.29486 .10317 L
.29314 .06349 L
.28987 .02381 L
s
0 1 .88 r
.39642 .97619 m
.39741 .93651 L
.39722 .89683 L
.3952 .85714 L
.39025 .81746 L
.38095 .77842 L
.3807 .77778 L
.36482 .7381 L
.34354 .69841 L
.34127 .69424 L
.32096 .65873 L
.30213 .61905 L
.30159 .61763 L
.28788 .57937 L
.27877 .53968 L
.27543 .5 L
.27877 .46032 L
.28788 .42063 L
.30159 .38237 L
.30213 .38095 L
.32096 .34127 L
.34127 .30576 L
.34354 .30159 L
.36482 .2619 L
.3807 .22222 L
.38095 .22158 L
.39025 .18254 L
.3952 .14286 L
.39722 .10317 L
.39741 .06349 L
.39642 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.39642 .97619 m
.39741 .93651 L
.39722 .89683 L
.3952 .85714 L
.39025 .81746 L
.38095 .77842 L
.3807 .77778 L
.36482 .7381 L
.34354 .69841 L
.34127 .69424 L
.32096 .65873 L
.30213 .61905 L
.30159 .61763 L
.28788 .57937 L
.27877 .53968 L
.27543 .5 L
.27877 .46032 L
.28788 .42063 L
.30159 .38237 L
.30213 .38095 L
.32096 .34127 L
.34127 .30576 L
.34354 .30159 L
.36482 .2619 L
.3807 .22222 L
.38095 .22158 L
.39025 .18254 L
.3952 .14286 L
.39722 .10317 L
.39741 .06349 L
.39642 .02381 L
s
0 1 .64 r
.42063 .41039 m
.46032 .41004 L
.49329 .42063 L
.4994 .46032 L
.49987 .5 L
.4994 .53968 L
.49329 .57937 L
.46032 .58996 L
.42063 .58961 L
.40492 .57937 L
.383 .53968 L
.38095 .53831 L
.37673 .5 L
.38095 .46169 L
.383 .46032 L
.40492 .42063 L
F
0 g
.42063 .41039 m
.46032 .41004 L
.49329 .42063 L
.4994 .46032 L
.49987 .5 L
.4994 .53968 L
.49329 .57937 L
.46032 .58996 L
.42063 .58961 L
.40492 .57937 L
.383 .53968 L
.38095 .53831 L
.37673 .5 L
.38095 .46169 L
.383 .46032 L
.40492 .42063 L
.42063 .41039 L
s
0 1 .4 r
.46032 .41376 m
.48631 .42063 L
.4988 .46032 L
.49975 .5 L
.4988 .53968 L
.48631 .57937 L
.46032 .58624 L
.4223 .57937 L
.42063 .57824 L
.39676 .53968 L
.4108 .5 L
.39676 .46032 L
.42063 .42176 L
.4223 .42063 L
F
0 g
.46032 .41376 m
.48631 .42063 L
.4988 .46032 L
.49975 .5 L
.4988 .53968 L
.48631 .57937 L
.46032 .58624 L
.4223 .57937 L
.42063 .57824 L
.39676 .53968 L
.4108 .5 L
.39676 .46032 L
.42063 .42176 L
.4223 .42063 L
.46032 .41376 L
s
0 1 .16 r
.46032 .41667 m
.47869 .42063 L
.4982 .46032 L
.49962 .5 L
.4982 .53968 L
.47869 .57937 L
.46032 .58333 L
.43284 .57937 L
.42063 .5717 L
.40259 .53968 L
.4117 .5 L
.40259 .46032 L
.42063 .4283 L
.43284 .42063 L
F
0 g
.46032 .41667 m
.47869 .42063 L
.4982 .46032 L
.49962 .5 L
.4982 .53968 L
.47869 .57937 L
.46032 .58333 L
.43284 .57937 L
.42063 .5717 L
.40259 .53968 L
.4117 .5 L
.40259 .46032 L
.42063 .4283 L
.43284 .42063 L
.46032 .41667 L
s
.08 1 0 r
.46032 .41912 m
.46951 .42063 L
.4976 .46032 L
.4995 .5 L
.4976 .53968 L
.46951 .57937 L
.46032 .58088 L
.44486 .57937 L
.42063 .56589 L
.40678 .53968 L
.41254 .5 L
.40678 .46032 L
.42063 .43411 L
.44486 .42063 L
F
0 g
.46032 .41912 m
.46951 .42063 L
.4976 .46032 L
.4995 .5 L
.4976 .53968 L
.46951 .57937 L
.46032 .58088 L
.44486 .57937 L
.42063 .56589 L
.40678 .53968 L
.41254 .5 L
.40678 .46032 L
.42063 .43411 L
.44486 .42063 L
.46032 .41912 L
s
.32 1 0 r
.42063 .43946 m
.46032 .42199 L
.497 .46032 L
.49937 .5 L
.497 .53968 L
.46032 .57801 L
.42063 .56054 L
.41016 .53968 L
.41332 .5 L
.41016 .46032 L
F
0 g
.42063 .43946 m
.46032 .42199 L
.497 .46032 L
.49937 .5 L
.497 .53968 L
.46032 .57801 L
.42063 .56054 L
.41016 .53968 L
.41332 .5 L
.41016 .46032 L
.42063 .43946 L
s
.56 1 0 r
.42063 .44451 m
.46032 .42535 L
.49639 .46032 L
.49925 .5 L
.49639 .53968 L
.46032 .57465 L
.42063 .55549 L
.41303 .53968 L
.41405 .5 L
.41303 .46032 L
F
0 g
.42063 .44451 m
.46032 .42535 L
.49639 .46032 L
.49925 .5 L
.49639 .53968 L
.46032 .57465 L
.42063 .55549 L
.41303 .53968 L
.41405 .5 L
.41303 .46032 L
.42063 .44451 L
s
.8 1 0 r
.42063 .44934 m
.46032 .42787 L
.49579 .46032 L
.49912 .5 L
.49579 .53968 L
.46032 .57213 L
.42063 .55066 L
.41556 .53968 L
.41474 .5 L
.41556 .46032 L
F
0 g
.42063 .44934 m
.46032 .42787 L
.49579 .46032 L
.49912 .5 L
.49579 .53968 L
.46032 .57213 L
.42063 .55066 L
.41556 .53968 L
.41474 .5 L
.41556 .46032 L
.42063 .44934 L
s
1 .96 0 r
.42063 .45402 m
.46032 .42994 L
.49518 .46032 L
.499 .5 L
.49518 .53968 L
.46032 .57006 L
.42063 .54598 L
.41782 .53968 L
.4154 .5 L
.41782 .46032 L
F
0 g
.42063 .45402 m
.46032 .42994 L
.49518 .46032 L
.499 .5 L
.49518 .53968 L
.46032 .57006 L
.42063 .54598 L
.41782 .53968 L
.4154 .5 L
.41782 .46032 L
.42063 .45402 L
s
1 .72 0 r
.42063 .45859 m
.46032 .43171 L
.49458 .46032 L
.49887 .5 L
.49458 .53968 L
.46032 .56829 L
.42063 .54141 L
.41989 .53968 L
.41603 .5 L
.41989 .46032 L
F
0 g
.42063 .45859 m
.46032 .43171 L
.49458 .46032 L
.49887 .5 L
.49458 .53968 L
.46032 .56829 L
.42063 .54141 L
.41989 .53968 L
.41603 .5 L
.41989 .46032 L
.42063 .45859 L
s
1 .48 0 r
.46032 .43328 m
.49397 .46032 L
.49875 .5 L
.49397 .53968 L
.46032 .56672 L
.42117 .53968 L
.42063 .53744 L
.41663 .5 L
.42063 .46256 L
.42117 .46032 L
F
0 g
.46032 .43328 m
.49397 .46032 L
.49875 .5 L
.49397 .53968 L
.46032 .56672 L
.42117 .53968 L
.42063 .53744 L
.41663 .5 L
.42063 .46256 L
.42117 .46032 L
.46032 .43328 L
s
1 .24 0 r
.46032 .43469 m
.49336 .46032 L
.49862 .5 L
.49336 .53968 L
.46032 .56531 L
.42202 .53968 L
.42063 .53381 L
.41721 .5 L
.42063 .46619 L
.42202 .46032 L
F
0 g
.46032 .43469 m
.49336 .46032 L
.49862 .5 L
.49336 .53968 L
.46032 .56531 L
.42202 .53968 L
.42063 .53381 L
.41721 .5 L
.42063 .46619 L
.42202 .46032 L
.46032 .43469 L
s
1 0 0 r
.46032 .43599 m
.49274 .46032 L
.4985 .5 L
.49274 .53968 L
.46032 .56401 L
.42286 .53968 L
.42063 .53012 L
.41776 .5 L
.42063 .46988 L
.42286 .46032 L
F
0 g
.46032 .43599 m
.49274 .46032 L
.4985 .5 L
.49274 .53968 L
.46032 .56401 L
.42286 .53968 L
.42063 .53012 L
.41776 .5 L
.42063 .46988 L
.42286 .46032 L
.46032 .43599 L
s
0 .88 1 r
.5 .97619 m
.5 .93651 L
.5 .89683 L
.5 .85714 L
.5 .81746 L
.5 .77778 L
.5 .7381 L
.5 .69841 L
.5 .65873 L
.5 .61905 L
.5 .57937 L
.5 .5776 L
.5 .53968 L
.5 .50591 L
.5 .5 L
.5 .49409 L
.5 .46032 L
.5 .4224 L
.5 .42063 L
.5 .38095 L
.5 .34127 L
.5 .30159 L
.5 .2619 L
.5 .22222 L
.5 .18254 L
.5 .14286 L
.5 .10317 L
.5 .06349 L
.5 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.5 .97619 m
.5 .93651 L
.5 .89683 L
.5 .85714 L
.5 .81746 L
.5 .77778 L
.5 .7381 L
.5 .69841 L
.5 .65873 L
.5 .61905 L
.5 .57937 L
.5 .5776 L
.5 .53968 L
.5 .50591 L
.5 .5 L
.5 .49409 L
.5 .46032 L
.5 .4224 L
.5 .42063 L
.5 .38095 L
.5 .34127 L
.5 .30159 L
.5 .2619 L
.5 .22222 L
.5 .18254 L
.5 .14286 L
.5 .10317 L
.5 .06349 L
.5 .02381 L
s
0 .64 1 r
.53968 .41004 m
.57937 .41039 L
.59508 .42063 L
.617 .46032 L
.61905 .46169 L
.62327 .5 L
.61905 .53831 L
.617 .53968 L
.59508 .57937 L
.57937 .58961 L
.53968 .58996 L
.50671 .57937 L
.5006 .53968 L
.50013 .5 L
.5006 .46032 L
.50671 .42063 L
F
0 g
.53968 .41004 m
.57937 .41039 L
.59508 .42063 L
.617 .46032 L
.61905 .46169 L
.62327 .5 L
.61905 .53831 L
.617 .53968 L
.59508 .57937 L
.57937 .58961 L
.53968 .58996 L
.50671 .57937 L
.5006 .53968 L
.50013 .5 L
.5006 .46032 L
.50671 .42063 L
.53968 .41004 L
s
0 .4 1 r
.53968 .41376 m
.5777 .42063 L
.57937 .42176 L
.60324 .46032 L
.5892 .5 L
.60324 .53968 L
.57937 .57824 L
.5777 .57937 L
.53968 .58624 L
.51369 .57937 L
.5012 .53968 L
.50025 .5 L
.5012 .46032 L
.51369 .42063 L
F
0 g
.53968 .41376 m
.5777 .42063 L
.57937 .42176 L
.60324 .46032 L
.5892 .5 L
.60324 .53968 L
.57937 .57824 L
.5777 .57937 L
.53968 .58624 L
.51369 .57937 L
.5012 .53968 L
.50025 .5 L
.5012 .46032 L
.51369 .42063 L
.53968 .41376 L
s
0 .16 1 r
.53968 .41667 m
.56716 .42063 L
.57937 .4283 L
.59741 .46032 L
.5883 .5 L
.59741 .53968 L
.57937 .5717 L
.56716 .57937 L
.53968 .58333 L
.52131 .57937 L
.5018 .53968 L
.50038 .5 L
.5018 .46032 L
.52131 .42063 L
F
0 g
.53968 .41667 m
.56716 .42063 L
.57937 .4283 L
.59741 .46032 L
.5883 .5 L
.59741 .53968 L
.57937 .5717 L
.56716 .57937 L
.53968 .58333 L
.52131 .57937 L
.5018 .53968 L
.50038 .5 L
.5018 .46032 L
.52131 .42063 L
.53968 .41667 L
s
.08 0 1 r
.53968 .41912 m
.55514 .42063 L
.57937 .43411 L
.59322 .46032 L
.58746 .5 L
.59322 .53968 L
.57937 .56589 L
.55514 .57937 L
.53968 .58088 L
.53049 .57937 L
.5024 .53968 L
.5005 .5 L
.5024 .46032 L
.53049 .42063 L
F
0 g
.53968 .41912 m
.55514 .42063 L
.57937 .43411 L
.59322 .46032 L
.58746 .5 L
.59322 .53968 L
.57937 .56589 L
.55514 .57937 L
.53968 .58088 L
.53049 .57937 L
.5024 .53968 L
.5005 .5 L
.5024 .46032 L
.53049 .42063 L
.53968 .41912 L
s
.32 0 1 r
.53968 .42199 m
.57937 .43946 L
.58984 .46032 L
.58668 .5 L
.58984 .53968 L
.57937 .56054 L
.53968 .57801 L
.503 .53968 L
.50063 .5 L
.503 .46032 L
F
0 g
.53968 .42199 m
.57937 .43946 L
.58984 .46032 L
.58668 .5 L
.58984 .53968 L
.57937 .56054 L
.53968 .57801 L
.503 .53968 L
.50063 .5 L
.503 .46032 L
.53968 .42199 L
s
.56 0 1 r
.53968 .42535 m
.57937 .44451 L
.58697 .46032 L
.58595 .5 L
.58697 .53968 L
.57937 .55549 L
.53968 .57465 L
.50361 .53968 L
.50075 .5 L
.50361 .46032 L
F
0 g
.53968 .42535 m
.57937 .44451 L
.58697 .46032 L
.58595 .5 L
.58697 .53968 L
.57937 .55549 L
.53968 .57465 L
.50361 .53968 L
.50075 .5 L
.50361 .46032 L
.53968 .42535 L
s
.8 0 1 r
.53968 .42787 m
.57937 .44934 L
.58444 .46032 L
.58526 .5 L
.58444 .53968 L
.57937 .55066 L
.53968 .57213 L
.50421 .53968 L
.50088 .5 L
.50421 .46032 L
F
0 g
.53968 .42787 m
.57937 .44934 L
.58444 .46032 L
.58526 .5 L
.58444 .53968 L
.57937 .55066 L
.53968 .57213 L
.50421 .53968 L
.50088 .5 L
.50421 .46032 L
.53968 .42787 L
s
1 0 .96 r
.53968 .42994 m
.57937 .45402 L
.58218 .46032 L
.5846 .5 L
.58218 .53968 L
.57937 .54598 L
.53968 .57006 L
.50482 .53968 L
.501 .5 L
.50482 .46032 L
F
0 g
.53968 .42994 m
.57937 .45402 L
.58218 .46032 L
.5846 .5 L
.58218 .53968 L
.57937 .54598 L
.53968 .57006 L
.50482 .53968 L
.501 .5 L
.50482 .46032 L
.53968 .42994 L
s
1 0 .72 r
.53968 .43171 m
.57937 .45859 L
.58011 .46032 L
.58397 .5 L
.58011 .53968 L
.57937 .54141 L
.53968 .56829 L
.50542 .53968 L
.50113 .5 L
.50542 .46032 L
F
0 g
.53968 .43171 m
.57937 .45859 L
.58011 .46032 L
.58397 .5 L
.58011 .53968 L
.57937 .54141 L
.53968 .56829 L
.50542 .53968 L
.50113 .5 L
.50542 .46032 L
.53968 .43171 L
s
1 0 .48 r
.53968 .43328 m
.57883 .46032 L
.57937 .46256 L
.58337 .5 L
.57937 .53744 L
.57883 .53968 L
.53968 .56672 L
.50603 .53968 L
.50125 .5 L
.50603 .46032 L
F
0 g
.53968 .43328 m
.57883 .46032 L
.57937 .46256 L
.58337 .5 L
.57937 .53744 L
.57883 .53968 L
.53968 .56672 L
.50603 .53968 L
.50125 .5 L
.50603 .46032 L
.53968 .43328 L
s
1 0 .24 r
.53968 .43469 m
.57798 .46032 L
.57937 .46619 L
.58279 .5 L
.57937 .53381 L
.57798 .53968 L
.53968 .56531 L
.50664 .53968 L
.50138 .5 L
.50664 .46032 L
F
0 g
.53968 .43469 m
.57798 .46032 L
.57937 .46619 L
.58279 .5 L
.57937 .53381 L
.57798 .53968 L
.53968 .56531 L
.50664 .53968 L
.50138 .5 L
.50664 .46032 L
.53968 .43469 L
s
1 0 0 r
.53968 .43599 m
.57714 .46032 L
.57937 .46988 L
.58224 .5 L
.57937 .53012 L
.57714 .53968 L
.53968 .56401 L
.50726 .53968 L
.5015 .5 L
.50726 .46032 L
F
0 g
.53968 .43599 m
.57714 .46032 L
.57937 .46988 L
.58224 .5 L
.57937 .53012 L
.57714 .53968 L
.53968 .56401 L
.50726 .53968 L
.5015 .5 L
.50726 .46032 L
.53968 .43599 L
s
0 .64 1 r
.60358 .97619 m
.60259 .93651 L
.60278 .89683 L
.6048 .85714 L
.60975 .81746 L
.61905 .77842 L
.6193 .77778 L
.63518 .7381 L
.65646 .69841 L
.65873 .69424 L
.67904 .65873 L
.69787 .61905 L
.69841 .61763 L
.71212 .57937 L
.72123 .53968 L
.72457 .5 L
.72123 .46032 L
.71212 .42063 L
.69841 .38237 L
.69787 .38095 L
.67904 .34127 L
.65873 .30576 L
.65646 .30159 L
.63518 .2619 L
.6193 .22222 L
.61905 .22158 L
.60975 .18254 L
.6048 .14286 L
.60278 .10317 L
.60259 .06349 L
.60358 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.60358 .97619 m
.60259 .93651 L
.60278 .89683 L
.6048 .85714 L
.60975 .81746 L
.61905 .77842 L
.6193 .77778 L
.63518 .7381 L
.65646 .69841 L
.65873 .69424 L
.67904 .65873 L
.69787 .61905 L
.69841 .61763 L
.71212 .57937 L
.72123 .53968 L
.72457 .5 L
.72123 .46032 L
.71212 .42063 L
.69841 .38237 L
.69787 .38095 L
.67904 .34127 L
.65873 .30576 L
.65646 .30159 L
.63518 .2619 L
.6193 .22222 L
.61905 .22158 L
.60975 .18254 L
.6048 .14286 L
.60278 .10317 L
.60259 .06349 L
.60358 .02381 L
s
0 1 .88 r
.65873 .5 m
.65873 .5 L
.65873 .5 L
.65873 .5 L
F
0 g
.65873 .5 m
.65873 .5 L
.65873 .5 L
.65873 .5 L
.65873 .5 L
s
0 .4 1 r
.71013 .97619 m
.70686 .93651 L
.70514 .89683 L
.70546 .85714 L
.70841 .81746 L
.71446 .77778 L
.72356 .7381 L
.73479 .69841 L
.7381 .68714 L
.74655 .65873 L
.75718 .61905 L
.76544 .57937 L
.77061 .53968 L
.77237 .5 L
.77061 .46032 L
.76544 .42063 L
.75718 .38095 L
.74655 .34127 L
.7381 .31286 L
.73479 .30159 L
.72356 .2619 L
.71446 .22222 L
.70841 .18254 L
.70546 .14286 L
.70514 .10317 L
.70686 .06349 L
.71013 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.71013 .97619 m
.70686 .93651 L
.70514 .89683 L
.70546 .85714 L
.70841 .81746 L
.71446 .77778 L
.72356 .7381 L
.73479 .69841 L
.7381 .68714 L
.74655 .65873 L
.75718 .61905 L
.76544 .57937 L
.77061 .53968 L
.77237 .5 L
.77061 .46032 L
.76544 .42063 L
.75718 .38095 L
.74655 .34127 L
.7381 .31286 L
.73479 .30159 L
.72356 .2619 L
.71446 .22222 L
.70841 .18254 L
.70546 .14286 L
.70514 .10317 L
.70686 .06349 L
.71013 .02381 L
s
0 .16 1 r
.82538 .97619 m
.81846 .93651 L
.81746 .93019 L
.813 .89683 L
.80928 .85714 L
.80758 .81746 L
.80802 .77778 L
.81049 .7381 L
.81452 .69841 L
.81746 .67356 L
.81938 .65873 L
.8242 .61905 L
.82822 .57937 L
.83086 .53968 L
.83178 .5 L
.83086 .46032 L
.82822 .42063 L
.8242 .38095 L
.81938 .34127 L
.81746 .32644 L
.81452 .30159 L
.81049 .2619 L
.80802 .22222 L
.80758 .18254 L
.80928 .14286 L
.813 .10317 L
.81746 .06981 L
.81846 .06349 L
.82538 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.82538 .97619 m
.81846 .93651 L
.81746 .93019 L
.813 .89683 L
.80928 .85714 L
.80758 .81746 L
.80802 .77778 L
.81049 .7381 L
.81452 .69841 L
.81746 .67356 L
.81938 .65873 L
.8242 .61905 L
.82822 .57937 L
.83086 .53968 L
.83178 .5 L
.83086 .46032 L
.82822 .42063 L
.8242 .38095 L
.81938 .34127 L
.81746 .32644 L
.81452 .30159 L
.81049 .2619 L
.80802 .22222 L
.80758 .18254 L
.80928 .14286 L
.813 .10317 L
.81746 .06981 L
.81846 .06349 L
.82538 .02381 L
s
.08 0 1 r
.95976 .97619 m
.9481 .93651 L
.93777 .89683 L
.93651 .89159 L
.92895 .85714 L
.92183 .81746 L
.91648 .77778 L
.91288 .7381 L
.91084 .69841 L
.91004 .65873 L
.91006 .61905 L
.91045 .57937 L
.91085 .53968 L
.91101 .5 L
.91085 .46032 L
.91045 .42063 L
.91006 .38095 L
.91004 .34127 L
.91084 .30159 L
.91288 .2619 L
.91648 .22222 L
.92183 .18254 L
.92895 .14286 L
.93651 .10841 L
.93777 .10317 L
.9481 .06349 L
.95976 .02381 L
.97619 .02381 L
.97619 .97619 L
F
0 g
.95976 .97619 m
.9481 .93651 L
.93777 .89683 L
.93651 .89159 L
.92895 .85714 L
.92183 .81746 L
.91648 .77778 L
.91288 .7381 L
.91084 .69841 L
.91004 .65873 L
.91006 .61905 L
.91045 .57937 L
.91085 .53968 L
.91101 .5 L
.91085 .46032 L
.91045 .42063 L
.91006 .38095 L
.91004 .34127 L
.91084 .30159 L
.91288 .2619 L
.91648 .22222 L
.92183 .18254 L
.92895 .14286 L
.93651 .10841 L
.93777 .10317 L
.9481 .06349 L
.95976 .02381 L
s
.5 .5 m
.5 .5 .1746 0 365.73 arc
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  ImageSize->{204.5, 205.125},
  ImageMargins->{{53.25, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003<0000cA000`40O003h00Oc7oo000DOol2000I
Ool4000HOol5000DOol2000IOol5000FOol4000IOol2000COol001=oo`04001oogoo000HOol00`00
Oomoo`0KOol00`00Oomoo`0COol01000Oomoo`006Woo00<007ooOol05Woo00<007ooOol06Goo00@0
07ooOol0019oo`005Goo00<007ooOol067oo00<007ooOol06Woo00<007ooOol04goo00@007ooOol0
01Yoo`03001oogoo01Moo`03001oogoo01Yoo`03001oogoo015oo`003Goo10001Goo00<007ooOol0
47oo100017oo00<007ooOol04Goo100017oo00<007ooOol04goo00@007ooOol001Yoo`03001oogoo
01Qoo`03001oogoo01Yoo`03001oogoo011oo`004goo00@007ooOol001Qoo`04001oogoo000JOol0
0`00Oomoo`0COol01000Oomoo`006Woo00<007ooOol05Woo00@007ooOol001Qoo`04001oogoo000B
Ool001Aoo`8001Yoo`8001Yoo`8001Ioo`8001Yoo`8001Uoo`8001Yoo`8001=oo`00c7oo003<Ool0
0<aoo`00c7oo003<Ool000ioojl000moo`003Woo00D007ooOomoo`0001]oo`03001oogoo01Uoo`03
001oogoo01Qoo`03001oogoo01Uoo`03001oogoo01Qoo`03001oogoo01Uoo`05001oogooOol0000?
Ool000Qoo`8000Aoo`03001oogoo05Aoo`03001oogoo05Aoo`03001oogoo00eoo`001goo00@007oo
Ool000=oo`03001oogoo05Aoo`03001oogoo05Aoo`03001oogoo00eoo`002Goo00<007ooOol00Woo
0P001Goo00<007ooOol05Goo00<007ooOol04Goo00<007ooOol03goo00<007ooOol03goo00<007oo
Ool03goo00<007ooOol047oo00<007ooOol04Goo00<007ooOol057oo00<007ooOol00goo0P003goo
00000goo000000020005Ool01@00Oomoogoo00000goo00@7h0_P1n0001L3i0030003k0?/0143k003
0003l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c00004@?k00<000=o0gl03`=o00D0009o
0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl010:O0Wl2O`004`6O00<0002O09l0502O00<000@O21l0
17oo00<007ooOol03Goo0007Ool01000Oomoo`000goo00T007ooOomoo`_P1n0;h0OP00005P?T02L0
00?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d00000P?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0020o/00`000il3
O`020gl01@>O0gl3O`=o0il00`=o02`3W`=o0gl3O`>O0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`005P2O00@000@O
21l47`Aoo`03001oogoo00eoo`0027oo0P0017oo00T007ooOomoo`OP2n07h0_P00005P?T00<000?/
0n`04@?/00D000?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<00`?d0o<0000A0o/00`000gl3O`0?
0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00H2W`9o0Wl2O`:O000B0Il00`0009l0W`0D09l0
100021l47`PO17oo00<007ooOol03Goo000>Ool02@00Oomoogoo2n07h0_P1n00000G0n@09`000n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0003o0030o/01@?l0o/3n`?k0o`00`?k00H3o0?k0o/3n`?l00020gl01@>O0gl3O`=o
0il00`=o00D3W`=o0gl3O`>O0083O`0W0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0001H0W`0400047`PO11l4Ool0
0`00Oomoo`0=Ool000ioo`80009oo`051n0;h0OP2n00000G0n@00`000n`3k00@0n`00`000o<3m003
0o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`000143n`030003O`=o00l3O`050002O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00<2W`9o00004`6O00<0002O09l0502O00@000PO11l87`=oo`8000mo
o`003Woo00X007ooOomoo`_P1n0;h0OP2n0001H3i00V0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@00083n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00P?k00<000>O0gl00P=o00D3W`=o0gl3O`>O00<3O`0[0il3O`=o
0gl3W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o00005P2O00D000PO11l87`@O00Aoo`03001oogoo00eoo`003Woo00X0
07ooOomoo`OP2n07h0_P1n0001H3i0030003k0?/0103k0050003l`?c0o<3m0030o<01@?d0o<3l`?c
0o@00`?c00<3m0?c00004@?k00<000=o0gl03`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`05
0Yl2O`9o0Wl0000B0Il00`0009l0W`0D09l01@0011l87`@O21l017oo00<007ooOol03Goo000>Ool0
2P00Oomoogoo2n07h0_P1n0;h0005P?T02L000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000o`00`?k00D3o0?k0o/3n`?l
00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl09P000Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o000F09l01@0021l47`PO11l017oo00<007ooOol03Goo000>Ool02`00Oomoogoo1n0;
h0OP2n07h0_P00005@?T00<000?/0n`040?/00<000?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3
l`?c0o<0000A0o/00`000gl3O`0?0gl01@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl2
O`000181W`030000W`2O01<0W`0600087`@O21l47`PO17oo00<007ooOol03Goo000>Ool02`00Oomo
ogoo2n07h0_P1n0;h0OP00005@?T02H000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000P?k00D3o0?k0o/3n`?l00<3n`05
0o`3n`?k0o/3o0020o/00`000il3O`020gl01@>O0gl3O`=o0il00`=o02/3W`=o0gl3O`>O0002W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl0000E09l01P0011l87`@O21l47`Aoo`03001oogoo00eoo`003Woo0P000Woo00L7h0_P
1n0;h0OP2n00000F0n@00`000n`3k00@0n`010000o<3l`?d0`?c00D3m0?c0o<3l`?d00<3l`030o@3
l`000143n`030003O`=o00l3O`030002O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0000
4P6O00<0002O09l04`2O00H000PO11l87`@O21l3Ool2000?Ool000ioo`0<001oogooOol;h0OP2n07
h0_P1n0;h0005@?T02H000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l0`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3
o0000P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl09P000Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o000D09l0
1`0021l47`PO11l87`@O00Aoo`03001oogoo00eoo`003Woo00`007ooOomoo`OP2n07h0_P1n0;h0OP
000E0n@00`000n`3k00@0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`000143
n`030003O`=o00l3O`050002O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<2W`9o00004P6O00<0
002O09l04P2O00L000@O21l47`PO11l87`04Ool00`00Oomoo`0=Ool000ioo`0<001oogooOol;h0OP
2n07h0_P1n0;h0005@?T02D000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3
n`?l0083n`030003W`=o0083O`050il3O`=o0gl3W`030gl0:`>O0gl3O`=o0il000:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`0001@0W`0700087`@O21l47`PO11l017oo00<007ooOol03Goo000>Ool03000Oomoogoo1n0;h0OP
2n07h0_P1n0001D3i0030003k0?/0103k0040003l`?c0o@30o<01@?d0o<3l`?c0o@00`?c00<3m0?c
00004@?k00<000=o0gl03`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl0000B
0Il00`0009l0W`0B09l01`0011l87`@O21l47`PO00Aoo`03001oogoo00eoo`003Woo0P000Woo00T;
h0OP2n07h0_P1n0;h0OP000050?T02H000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l0`?k00D3o0?k0o/3n`?l00<3n`06
0o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl09P000Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o000D09l01`0021l47`PO11l87`@O00=oo`8000moo`003Woo00d007ooOomoo`OP2n07h0_P1n0;
h0OP2n00000D0n@00`000n`3k00?0n`00`000o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3
l`000143n`030003O`=o00l3O`050002O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<2W`9o0000
4@6O00<0002O09l04P2O00P000PO11l87`@O21l47`PO17oo00<007ooOol03Goo000>Ool03@00Oomo
ogoo2n07h0_P1n0;h0OP2n07h00001@3i00U0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00000P?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0020o/00`000il3O`020gl01@>O0gl3O`=o0il00`=o02X3W`=o0gl3O`>O0002
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O000D09l0200011l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000ioo`0>001oogoo
Ool7h0_P1n0;h0OP2n07h0_P1n0001<3i0030003k0?/00l3k0050003l`?c0o<3m0030o<01@?d0o<3
l`?c0o@00`?c00<3m0?c00004@?k00<000=o0gl03`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2
O`050Yl2O`9o0Wl0000A0Il00`0009l0W`0B09l0200021l47`PO11l87`@O21l4Ool00`00Oomoo`0=
Ool000ioo`0>001oogooOol;h0OP2n07h0_P1n0;h0OP2n0001<3i00V0003k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0<3
n`050o`3n`?k0o/3o0030o/01P?l0o/3n`?k0o`00083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o
0il00P=o02D000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000D09l0200011l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool0
00ioo`0>001oogooOol7h0_P1n0;h0OP2n07h0_P1n0001<3i0030003k0?/00l3k0030003l`?d00<3
l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c00004@?k00<000=o0gl03`=o00D0009o0Wl2O`:O00<2
O`050Yl2O`9o0Wl2W`030Wl00`:O0Wl0000A0Il00`0009l0W`0B09l0200021l47`PO11l87`@O21l4
Ool00`00Oomoo`0=Ool000ioo`80009oo`0:2n07h0_P1n0;h0OP2n07h0_P000C0n@09@000n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0000083n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00P?k00<000>O0gl00P=o00D3W`=o
0gl3O`>O00<3O`0Z0il3O`=o0gl3W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`00
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`004`2O00T000PO11l87`@O21l47`PO11l0
0goo0P003goo000>Ool03P00Oomoogoo1n0;h0OP2n07h0_P1n0;h0OP000C0n@00`000n`3k00?0n`0
1@000o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030o@3l`000143n`030003O`=o00l3O`030002
O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o00004@6O00<0002O09l04@2O00T000@O21l4
7`PO11l87`@O21l017oo00<007ooOol03Goo000>Ool03`00Oomoogoo2n07h0_P1n0;h0OP2n07h0_P
1n00000C0n@09@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0003n`?l00<3n`050o`3n`?k0o/3o0030o/01P?l0o/3n`?k0o`00083
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02@0009o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000C09l02@0021l47`PO
11l87`@O21l47`04Ool00`00Oomoo`0=Ool000Moo`@000=oo`0?001oogooOol7h0_P1n0;h0OP2n07
h0_P1n0;h00001<3i0030003k0?/00h3k0030003l`?d00<3l`050o@3l`?c0o<3m0030o<010?d0o<3
l`004P?k00<000=o0gl040=o00@0009o0Wl2W`<2O`050Yl2O`9o0Wl2W`030Wl00`:O0Wl0000A0Il0
0`0009l0W`0A09l02@0011l87`@O21l47`PO11l87`04Ool00`00Oomoo`0=Ool000Moo`03001oogoo
00Aoo`0?001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h00001<3i00S0003j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000030o/01@?l
0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083n`030003W`=o0083O`050il3O`=o0gl3W`030gl0:P>O
0gl3O`=o0il3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00180W`0:00047`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=
Ool000Qoo`03001oogoo00=oo`80009oo`0;1n0;h0OP2n07h0_P1n0;h0OP2n00000C0n@00`000n`3
k00>0n`01@000o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030o@000?k0143n`030003O`=o0103
O`030002W`9o0082O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o00004@6O00<0002O09l0402O00X0
00PO11l87`@O21l47`PO11l87`=oo`8000moo`0000=oo`0000000P0017oo00<007ooOol00Woo00l0
07ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP00004`?T02D000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0030o/01@?l0o/3
n`?k0o`00`?k00H3o0?k0o/3n`?l00020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0T
0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`004P2O00X000@O21l47`PO11l87`@O21l47`Aoo`03001oogoo00eoo`001goo00@0
07ooOol000=oo`0?001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h00001<3i0030003k0?/00h3k003
0003l`?d00<3l`050o@3l`?c0o<3m0030o<00`?d0o<0000C0o/00`000gl3O`0A0gl00`000Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00<2W`9o00004@6O00<0002O09l0402O00X000PO11l87`@O21l47`PO
11l87`Aoo`03001oogoo00eoo`0027oo0P0017oo00l007ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP
00004`?T02<000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@000?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00P?k00<000>O
0gl00P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl08`000Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00004P2O00X000@O
21l47`PO11l87`@O21l47`Aoo`03001oogoo00eoo`003Woo010007ooOomoo`OP2n07h0_P1n0;h0OP
2n07h0_P1n000183i0030003k0?/00d3k0030003m0?c0083l`050o@3l`?c0o<3m0030o<01@?d0o<3
l`?c00004`?k00<000=o0gl04@=o00D0009o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`:O0001
W`0?0Il00`0009l0W`0?09l02`0011l87`@O21l47`PO11l87`@O21l017oo00<007ooOol03Goo000>
Ool04000Oomoogoo2n07h0_P1n0;h0OP2n07h0_P1n0;h0004P?T028000?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@00083n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0000gl3O`>O00<3O`050il3O`=o0gl3W`030gl0:0>O
0gl3O`=o0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`004@2O00/000PO11l87`@O21l47`PO11l87`@O00Aoo`03001oogoo00eo
o`003Woo0P000Woo00`7h0_P1n0;h0OP2n07h0_P1n0;h0OP000B0n@00`000n`3k00=0n`010000o<3
l`?d0`?c00D3m0?c0o<3l`?d00<3l`030o@000?k01<3n`030003O`=o0183O`030002W`9o0082O`05
0Yl2O`9o0Wl2W`030Wl010:O0Wl2O`00406O00<0002O09l03`2O00/000@O21l47`PO11l87`@O21l4
7`PO00=oo`8000moo`003Woo010007ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n000183i00S0003
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`000o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083n`030003W`=o0083O`050il3
O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o0280009o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00140W`0;00087`@O21l47`PO11l87`@O
21l47`04Ool00`00Oomoo`0=Ool000ioo`0@001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP000B
0n@00`000n`3k00=0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00`?c00@3m0?c0o<001@3n`030003
O`=o0183O`040002O`9o0Yl30Wl01@:O0Wl2O`9o0Yl00`9o00<2W`000Il03`6O00<0002O09l03`2O
00/000@O21l47`PO11l87`@O21l47`PO00Aoo`03001oogoo00eoo`003Woo010007ooOomoo`_P1n0;
h0OP2n07h0_P1n0;h0OP2n000183i00Q0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k
0o`00`?k00D3o0000gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00P=o024000:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
00004@2O00/000PO11l87`@O21l47`PO11l87`@O00Aoo`03001oogoo00eoo`003Woo010007ooOomo
o`OP2n07h0_P1n0;h0OP2n07h0_P1n000183i0030003k0?/00`3k0050003l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00<000?k0o/04`?k00<000=o0gl04`=o00D0009o0Wl2O`:O00<2O`050Yl2O`9o
0Wl2W`030Wl00`000Il1W`0=0Il00`0009l0W`0?09l02`0011l87`@O21l47`PO11l87`@O21l017oo
00<007ooOol03Goo000>Ool20002Ool030_P1n0;h0OP2n07h0_P1n0;h0OP2n000143i00Q0003k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m000
0083n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o
0gl3W`030gl01@>O0gl3O`=o0il00`=o0283W`=o0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00140W`0;00087`@O21l47`PO11l87`@O21l4
7`03Ool2000?Ool000ioo`0@001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP000A0n@00`000n`3
k00=0n`00`000o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0?c00005@?k00<000=o0gl050=o00<0
00:O0Wl00P9o00D2W`9o0Wl2O`:O00<2O`030Yl2O`0000l1W`030000W`2O00l0W`0;00047`PO11l8
7`@O21l47`PO11l87`04Ool00`00Oomoo`0=Ool000ioo`0@001oogooOol;h0OP2n07h0_P1n0;h0OP
2n07h0_P000A0n@08P000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0003n`?l0`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l
0003O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl080>O0002W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000A09l02`0021l4
7`PO11l87`@O21l47`PO11l017oo00<007ooOol03Goo000>Ool04000Oomoogoo1n0;h0OP2n07h0_P
1n0;h0OP2n07h0004@?T00<000?/0n`030?/00<000?d0o<00P?c00D3m0?c0o<3l`?d00<3l`040o@3
l`?c000F0o/00`000gl3O`0E0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<2W`000Il03@6O
00<0002O09l03`2O00/000@O21l47`PO11l87`@O21l47`PO00Aoo`03001oogoo00eoo`003Woo0100
07ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n000143i00P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0<3n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il0
0`=o0283W`=o0gl000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il00140W`0;00087`@O21l47`PO11l87`@O21l47`04Ool00`00Oomoo`0=Ool000io
o`0@001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP000A0n@00`000n`3k00;0n`01@000o<3l`?c
0o@00`?c00D3m0?c0o<3l`?d00<3l`030003n`?k01D3n`030003O`=o01H3O`040002O`9o0Yl30Wl0
1@:O0Wl2O`9o0Yl00`9o00<0006O0Il02`6O00<0002O09l03`2O00/000@O21l47`PO11l87`@O21l4
7`PO00Aoo`03001oogoo00eoo`003Woo0P000Woo00`;h0OP2n07h0_P1n0;h0OP2n07h0_P000A0n@0
7P000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<0
00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00H3o0?k0o/3n`?l00020gl01@>O0gl3
O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0T0il3O`=o0gl3W`=o0002O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`004@2O00/000PO11l87`@O21l47`PO
11l87`@O00=oo`8000moo`003Woo014007ooOomoo`OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0000103
i0030003k0?/00/3k0030003l`?d00<3l`050o@3l`?c0o<3m0030o<00`?d0003n`0G0o/00`000gl3
O`0G0gl01@000Wl2O`9o0Yl00`9o00L2W`9o0Wl2O`:O0Wl0000>0Il00`0009l0W`0=09l0300021l4
7`PO11l87`@O21l47`PO11l87`Aoo`03001oogoo00eoo`003Woo014007ooOomoo`_P1n0;h0OP2n07
h0_P1n0;h0OP2n07h0000103i00M0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@000020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3
n`?k0o/3o0020o/00`000il3O`020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0S0il3
O`=o0gl3W`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl0000?09l0300011l87`@O21l47`PO11l87`@O21l47`Aoo`03001oogoo00eoo`003Woo0140
07ooOomoo`OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0000103i0030003k0?/00X3k0030003m0?c0083
l`050o@3l`?c0o<3m0030o<00`?d0o<0000I0o/00`000gl3O`0H0gl00`000Yl2O`020Wl01@:O0Wl2
O`9o0Yl00`9o00<2W`000Il0306O00<0002O09l03@2O00`000PO11l87`@O21l47`PO11l87`@O21l4
Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000@0n@0
7P000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3
o0<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00H3o0?k0o/3n`?l00020gl01@>O0gl3
O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl07@000Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00003`2O00`000@O21l47`PO11l8
7`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000ioo`80009oo`0=1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P000040?T00<000?/0n`02P?/00@000?c0o<3m0<3l`050o@3l`?c0o<3m0020o<00`000o/3n`0H
0o/00`000gl3O`0I0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<0006O0Il02P6O00<0002O
09l03@2O00`000PO11l87`@O21l47`PO11l87`@O21l3Ool2000?Ool000ioo`0A001oogooOol;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n00000?0n@07@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o003
0o/01@?l0o/3n`?k0o`00P?k00<000>O0gl00P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o01/0009o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o00003`2O00`000@O21l47`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool0
00ioo`0A001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000?0n@00`000n`3k00;0n`00`00
0o@3l`020o<01@?d0o<3l`?c0o@00`?c00<000?k0o/06@?k00<000=o0gl06P=o00@0009o0Wl2W`<2
O`070Yl2O`9o0Wl2W`9o0000306O00<0002O09l03@2O00`000PO11l87`@O21l47`PO11l87`@O21l4
Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000?0n@0
6`000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000030o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0003O`=o0il0
0`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00P=o01X000:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`003`2O00`000@O21l47`PO
11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000Moo`D0009oo`0A001oogooOol7h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n00000?0n@00`000n`3k00:0n`01@000o<3l`?c0o@00`?c00D3m0?c0o<3l`00
01H3n`l001H3O`050002O`9o0Wl2W`030Wl01P:O0Wl2O`9o0Yl000/1W`030000W`2O00d0W`0<0008
7`@O21l47`PO11l87`@O21l47`PO17oo00<007ooOol03Goo0009Ool00`00Oomoo`02Ool04@00Oomo
ogoo2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003`?T01X000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0
00?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000P?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o003
0o/00`?l0o/0000C00020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0L0il3O`000Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000>09l0300011l87`@O
21l47`PO11l87`@O21l47`Aoo`03001oogoo00eoo`002Goo00<007ooOol00Woo0P000Woo00d7h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n00000?0n@00`000n`3k0090n`010000o<3l`?d0`?c00H3m0?c0o<3
l`?d000B0o/J000A0gl00`000Yl2O`020Wl01@:O0Wl2O`9o0Yl00P9o00<0006O0Il02P6O00<0002O
09l0302O00`000PO11l87`@O21l47`PO11l87`@O21l3Ool2000?Ool00003Ool00000008000Aoo`03
001oogoo009oo`0A001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000?0n@06`000n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0030o/01@?l0o/3n`?k
0o`00`?k00<3o0?k00007@0000D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl06P>O0002W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000>09l0300011l87`@O21l4
7`PO11l87`@O21l47`Aoo`03001oogoo00eoo`002Goo00<007ooOol00Woo014007ooOomoo`OP2n07
h0_P1n0;h0OP2n07h0_P1n0;h00000l3i0030003k0?/00T3k0030003m0?c0083l`070o@3l`?c0o<3
m0?c00003`?k8@003`=o00<0009o0Yl00`9o00L2W`9o0Wl2O`:O0Wl0000;0Il00`0009l0W`0<09l0
300021l47`PO11l87`@O21l47`PO11l87`Aoo`03001oogoo00eoo`0027oo0P0017oo014007ooOomo
o`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00000l3i00I0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003
l`?d0o<3m0?c0o@3l`?d0o<3m0000o`00`?k00D3o0?k0o/3n`?l00<3n`030o`00000028000<3O`05
0il3O`=o0gl3W`030gl070>O0gl3O`=o0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`003P2O00`000@O21l47`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000io
o`0A001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000>0n@00`000n`3k0090n`01@000o<3
l`?c0o@00`?c00@3m0?c0o<000d3nbH000h3O`040002O`9o0Yl30Wl01@:O0Wl2O`9o00002`6O00<0
002O09l0302O00`000PO11l87`@O21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000ioo`80009o
o`0=2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003P?T01P000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0
00?d0o<3m0?c0o@3l`?d0o<3m0?c00030o/01@?l0o/3n`?k0o`00`?k00<3o00000009P000`=o00D3
W`=o0gl3O`>O00<3O`0J0il3O`=o0002W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il000h0W`0<00047`PO11l87`@O21l47`PO11l87`@O0goo0P003goo000>Ool04@00Oomoogoo
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P00003P?T00<000?/0n`02@?/00<000?c0o@00`?c00D3m0?c
0o<3l`0000`3nbX000d3O`050002O`9o0Wl2W`030Wl010:O0Wl2O`002P6O00<0002O09l0302O00`0
00PO11l87`@O21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol;h0OP2n07
h0_P1n0;h0OP2n07h0_P1n00000>0n@05`000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3
m0?c0o@3l`?d00000P?k00D3o0?k0o/3n`?l00<3n`030o`0000002X000<3O`050il3O`=o0gl3W`03
0gl060>O0gl0009o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il000h0W`0<0004
7`PO11l87`@O21l47`PO11l87`@O17oo00<007ooOol03Goo000>Ool04@00Oomoogoo1n0;h0OP2n07
h0_P1n0;h0OP2n07h0_P00003P?T00<000?/0n`02@?/00D000?c0o<3l`?d00<3l`030o@3l`0000X3
nbh000`3O`030002W`9o0082O`060Yl2O`9o0Wl2W`002P6O00<0002O09l0302O00`000PO11l87`@O
21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n00000>0n@060000n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`00
0o/3o0<3n`050o`3n`?k0o/3o00`00030gl01@>O0gl3O`=o0il00`=o01H3W`000Yl2O`:O0Wl2W`9o
0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il000h0W`0<00047`PO11l87`@O21l47`PO11l87`@O17oo
00<007ooOol03Goo000>Ool04@00Oomoogoo1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P00003P?T00<0
00?/0n`020?/00@000?c0o<3m0<3l`040o@3l`?c00090o/b000;0gl00`000Wl2W`030Wl010:O0Wl2
O`002P6O00<0002O09l0302O00`000PO11l87`@O21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool0
00ioo`80009oo`0=2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003@?T01L000?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@000?l00<3n`060o`3n`?k0o/3o0?k<`000`=o00D3W`=o
0gl3O`>O0083O`0F0002W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o000=09l0
300011l87`@O21l47`PO11l87`@O21l47`=oo`8000moo`003Woo014007ooOomoo`OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h00000d3i0030003k0?/00T3k0030003m0?c0083l`050o@3l`?c0o<000090o/d
000:0gl01@000Wl2O`9o0Yl00`9o00<2W`9o00002P6O00<0002O09l02`2O00`000PO11l87`@O21l4
7`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n00000=0n@05@000n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<000030o/0
1@?l0o/3n`?k0o`00P?k=@0000D3W`=o0gl3O`>O00<3O`0G0il3O`000Wl2W`9o0Yl2O`:O0Wl2W`00
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000=09l0300011l87`@O21l47`PO11l87`@O21l47`Aoo`03001o
ogoo00eoo`003Woo014007ooOomoo`OP2n07h0_P1n0;h0OP2n07h0_P1n0;h00000d3i0030003k0?/
00P3k0050003l`?c0o<3m0030o<00`?d0003n`080o/f000:0gl00`000Yl2O`020Wl01@:O0Wl2O`9o
00002P6O00<0002O09l02`2O00`000PO11l87`@O21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool0
00ioo`0A001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000=0n@05`000n/3k0?[0n`3j`?/
0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<000?k0o`00`?k00@3o0?k0o/3ncL000030gl3W`=o0083
O`0I0il3O`=o0gl0009o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o00003@2O00`0
00@O21l47`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000ioo`80009oo`0=1n0;h0OP2n07
h0_P1n0;h0OP2n07h0_P00003@?T00<000?/0n`020?/00<000?c0o@00`?c00@3m0?c0o<000P3ncP0
00X3O`030002O`:O00<2O`030Yl2O`0000X1W`030000W`2O00/0W`0<00087`@O21l47`PO11l87`@O
21l47`PO0goo0P003goo000>Ool04@00Oomoogoo2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003@?T
01D000?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0000o`00`?k00D3o0?k0o/3n`?l
03T00083O`050il3O`=o0gl3W`020gl05@000Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1
W`5o0Il0000<09l0300011l87`@O21l47`PO11l87`@O21l47`Aoo`03001oogoo00eoo`003Woo0140
07ooOomoo`OP2n07h0_P1n0;h0OP2n07h0_P1n0;h00000d3i0030003k0?/00L3k0030003m0?c0083
l`050o@3l`?c0o<000090o/i00090gl01@000Wl2O`9o0Yl00`9o00<2W`000Il02@6O00<0002O09l0
2P2O00`000PO11l87`@O21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000=0n@050000n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3
m0?c0o@3l`?d00020o/01P?l0o/3n`?k0o`3ncX000050il3O`=o0gl3W`030gl05P>O0gl0009o0Yl2
O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`00302O00`000@O21l47`PO11l87`@O21l47`PO
11l4Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000=
0n@00`000n`3k0070n`010000o<3l`?d0`?c00<3m0?c000020?k>`002@=o00<000:O0Wl00P9o00@2
W`9o0Wl000X1W`030000W`2O00X0W`0<00087`@O21l47`PO11l87`@O21l47`PO17oo00<007ooOol0
3Goo000>Ool04@00Oomoogoo2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003@?T01D000?[0n`3j`?/
0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0000o`00`?k00@3o0?k0o/3nc/000030gl3W`=o0083
O`0H0il3O`=o0gl0009o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`00302O00`000@O
21l47`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000ioo`80009oo`0=1n0;h0OP2n07h0_P
1n0;h0OP2n07h0_P00003@?T00<000?/0n`01`?/00<000?d0o<00P?c00D3m0?c0o<3l`0000L3nc`0
00T3O`040002O`9o0Yl30Wl00`:O0001W`090Il00`0009l0W`0:09l0300021l47`PO11l87`@O21l4
7`PO11l87`=oo`8000moo`003Woo014007ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00000d3
i00D0003j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@00083n`050o`3n`?k0o/3o00l
00030gl06P>O0gl3O`=o0il3O`000Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O000<
09l0300011l87`@O21l47`PO11l87`@O21l47`Aoo`03001oogoo00eoo`003Woo014007ooOomoo`OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h00000d3i0030003k0?/00L3k0040003l`?c0o@30o<00`?d0003
n`070o/l00090gl00`000Yl2O`020Wl010:O0Wl2O`002P6O00<0002O09l02`2O00/000@O21l47`PO
11l87`@O21l47`PO00Aoo`03001oogoo00eoo`0027oo0P0017oo014007ooOomoo`_P1n0;h0OP2n07
h0_P1n0;h0OP2n07h00000d3i00E0003j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0003
n`?l00<3n`030o`3n`?k03`000030gl3W`=o0083O`0H0il3O`=o0gl0009o0Yl2O`:O0Wl2W`9o0001
O`6O0Gl1W`5o0Il1O`6O0Gl1W`003@2O00/000PO11l87`@O21l47`PO11l87`@O00Aoo`03001oogoo
00=oo`800003Ool0000000Eoo`001goo00@007ooOol000=oo`0A001oogooOol7h0_P1n0;h0OP2n07
h0_P1n0;h0OP2n00000=0n@00`000n`3k0070n`00`000o@3l`020o<010?d0o<3l`0020?k?0002@=o
00@0009o0Wl2W`<2O`030Yl0006O00T1W`030000W`2O00/0W`0;00047`PO11l87`@O21l47`PO11l8
7`04Ool00`00Oomoo`04Ool00`00Ool00006Ool000Moo`04001oogoo0003Ool400003@_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h00000d3i00C0003j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c
00000`?k00D3o0?k0o/3n`?l03`000<3O`0J0il3O`=o0gl3W`=o0002O`:O0Wl2W`9o0Yl2O`000Gl1
W`5o0Il1O`6O0Gl1W`5o0Il000d0W`0;00087`@O21l47`PO11l87`@O21l47`050007Ool00`00Oomo
o`05Ool000Moo`04001oogoo0003Ool04@00Oomoogoo1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P0000
3@?T00<000?/0n`01`?/00@000?c0o<3m0<3l`030o@000?k00L3nc`000T3O`030002W`9o0082O`04
0Yl2O`9o000:0Il00`0009l0W`0;09l02`0011l87`@O21l47`PO11l87`@O21l017oo00<007ooOol0
0goo0P0000=oo`0000001Goo0007Ool01000Oomoo`000goo014007ooOomoo`_P1n0;h0OP2n07h0_P
1n0;h0OP2n07h00000d3i00E0003j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0003n`?l
00<3n`030o`3n`?k03`000030gl3W`=o0083O`0H0il3O`=o0gl0009o0Yl2O`:O0Wl2W`9o0001O`6O
0Gl1W`5o0Il1O`6O0Gl1W`003@2O00/000PO11l87`@O21l47`PO11l87`@O00Aoo`03001oogoo00eo
o`0027oo0P0017oo014007ooOomoo`OP2n07h0_P1n0;h0OP2n07h0_P1n0;h00000d3i0030003k0?/
00L3k0030003m0?c0083l`040o@3l`?c00080o/l00090gl010000Wl2O`:O0`9o00<2W`000Il02@6O
00<0002O09l02`2O00/000@O21l47`PO11l87`@O21l47`PO00Aoo`03001oogoo00eoo`003Woo0140
07ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00000d3i00D0003j`?/0n/3k0?[0n`3j`?/0n/0
00?c0o@3l`?d0o<3m0?c0o@00083n`050o`3n`?k0o/3o00l00030gl06P>O0gl3O`=o0il3O`000Wl2
W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O000<09l0300011l87`@O21l47`PO11l87`@O
21l47`Aoo`03001oogoo00eoo`003Woo014007ooOomoo`OP2n07h0_P1n0;h0OP2n07h0_P1n0;h000
00d3i0030003k0?/00L3k0040003l`?c0o@30o<00`?d0o<000070o/l00090gl00`000Yl2O`020Wl0
10:O0Wl2O`002P6O00<0002O09l02P2O00`000PO11l87`@O21l47`PO11l87`@O21l4Ool00`00Oomo
o`0=Ool000ioo`80009oo`0=2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003@?T01D000?[0n`3j`?/
0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0000o`00`?k00<3o0?k0o/0?00000<3O`>O0gl00P=o
01P3W`=o0gl3O`000Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O000<09l0300011l8
7`@O21l47`PO11l87`@O21l47`=oo`8000moo`003Woo014007ooOomoo`OP2n07h0_P1n0;h0OP2n07
h0_P1n0;h00000d3i0030003k0?/00L3k0030003m0?c0083l`050o@3l`?c0o<000080o/k00090gl0
10000Wl2O`:O0`9o00<2W`000Il02@6O00<0002O09l02P2O00`000PO11l87`@O21l47`PO11l87`@O
21l4Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000=
0n@050000n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d00020o/01P?l0o/3n`?k0o`3
ncX000050il3O`=o0gl3W`030gl05P>O0gl0009o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O
0Gl1W`00302O00`000@O21l47`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000ioo`0A001o
ogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000=0n@00`000n`3k0070n`010000o<3l`?d0`?c
00<3m0?c000020?k>P002@=o00<0009o0Yl00`9o00@2W`9o0Wl000X1W`030000W`2O00X0W`0<0008
7`@O21l47`PO11l87`@O21l47`PO17oo00<007ooOol03Goo000>Ool04@00Oomoogoo2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP00003@?T01D000?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3
m0000o`00`?k00D3o0?k0o/3n`?l03T00083O`050il3O`=o0gl3W`020gl05@000Yl2O`:O0Wl2W`9o
0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000<09l0300011l87`@O21l47`PO11l87`@O21l47`Ao
o`03001oogoo00eoo`003Woo0P000Woo00d7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000=0n@00`00
0n`3k0080n`01@000o<3l`?c0o@00`?c00<3m0000o/01`?k>0002P=o00D0009o0Wl2O`:O00<2O`03
0001W`6O00P1W`030000W`2O00/0W`0<00087`@O21l47`PO11l87`@O21l47`PO0goo0P003goo000>
Ool04@00Oomoogoo2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003@?T01L000?[0n`3j`?/0n/3k0?[
0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0003n`?l00<3n`040o`3n`?k0o/g00000`=o0il3O`020gl0
6@>O0gl3O`=o0il000:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`0000d0W`0<0004
7`PO11l87`@O21l47`PO11l87`@O17oo00<007ooOol03Goo000>Ool04@00Oomoogoo1n0;h0OP2n07
h0_P1n0;h0OP2n07h0_P00003@?T00<000?/0n`020?/00<000?c0o@00`?c00@3m0?c0o<000T3ncL0
00T3O`040002O`9o0Yl30Wl00`:O0Wl0000:0Il00`0009l0W`0;09l0300021l47`PO11l87`@O21l4
7`PO11l87`Aoo`03001oogoo00eoo`003Woo014007ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n07
h00000d3i00E0003j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`0000<3n`060o`3
n`?k0o/3o0?k=P0000D3W`=o0gl3O`>O00<3O`0G0il3O`000Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O
0Gl1W`5o0Il1O`6O0Gl0000=09l0300011l87`@O21l47`PO11l87`@O21l47`Aoo`03001oogoo00eo
o`003Woo014007ooOomoo`OP2n07h0_P1n0;h0OP2n07h0_P1n0;h00000d3i0030003k0?/00P3k005
0003l`?c0o<3m0030o<00`?d0003n`090o/e000:0gl00`000Yl2O`020Wl01@:O0Wl2O`9o00002P6O
00<0002O09l02`2O00`000PO11l87`@O21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000ioo`0A
001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000=0n@05`000n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`000o<3m0?c0o@3l`?d0o<3m0000o`00`?k00D3o0?k0o/3n`?l03@000<3O`050il3O`=o0gl3
W`020gl05P000Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`003@2O00`000@O
21l47`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000ioo`80009oo`0=1n0;h0OP2n07h0_P
1n0;h0OP2n07h0_P00003@?T00<000?/0n`02@?/00<000?d0o<00P?c00D3m0?c0o<3l`0000X3nc80
00/3O`050002O`9o0Wl2W`030Wl00`:O0Wl0000:0Il00`0009l0W`0;09l0300021l47`PO11l87`@O
21l47`PO11l87`=oo`8000moo`003Woo014007ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h000
00h3i00H0003k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0003n`?l0`?k00@3
o0?k0o/3nc4000<3O`050il3O`=o0gl3W`030gl05P>O0002W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1
W`5o0Il1O`6O0Gl1W`003P2O00`000@O21l47`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool0
00ioo`0A001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000>0n@00`000n`3k0080n`01000
0o<3l`?d0`?c00@3m0?c0o<000X3nc0000`3O`030002O`:O00<2O`040Yl2O`9o000:0Il00`0009l0
W`0<09l0300021l47`PO11l87`@O21l47`PO11l87`Aoo`03001oogoo00eoo`003Woo014007ooOomo
o`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00000h3i00G0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003
m0?c0o@3l`?d0o<3m0?c0o@000020o/01@?l0o/3n`?k0o`00`?k;P000P=o00D3W`=o0gl3O`>O00<3
O`0H0il3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`003P2O00`000@O
21l47`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol7h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n00000>0n@00`000n`3k0090n`01@000o<3l`?c0o@00`?c00<3m0?c00002`?k
;0003@=o00<000:O0Wl00P9o00H2W`9o0Wl2O`:O000:0Il00`0009l0W`0<09l0300021l47`PO11l8
7`@O21l47`PO11l87`Aoo`03001oogoo00eoo`003Woo0P000Woo00d;h0OP2n07h0_P1n0;h0OP2n07
h0_P1n00000>0n@060000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0003
o0<3n`050o`3n`?k0o/3o0030o/Z00020gl01@>O0gl3O`=o0il00`=o01X3W`=o0gl000:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`003P2O00`000@O21l47`PO11l87`@O21l4
7`PO11l3Ool2000?Ool000ioo`0A001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000>0n@0
0`000n`3k0090n`00`000o<3m0030o<01P?d0o<3l`?c0o@000`3nbP000h3O`050002O`9o0Wl2W`03
0Wl00`:O0Wl0000;0Il00`0009l0W`0<09l0300021l47`PO11l87`@O21l47`PO11l87`Aoo`03001o
ogoo00eoo`003Woo014007ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00000h3i00J0003k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0<3n`050o`3n`?k0o/3
o0030o/V00020gl01@>O0gl3O`=o0il00`=o01`3W`=o0gl3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0
006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000h0W`0<00047`PO11l87`@O21l47`PO11l87`@O17oo00<0
07ooOol03Goo000>Ool04@00Oomoogoo1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P00003`?T00<000?/
0n`02@?/00@000?c0o<3m0<3l`050o@3l`?c0o<0000=0o/T000?0gl010000Wl2O`:O0`9o00D2W`9o
0Wl2O`0000/1W`030000W`2O00`0W`0<00087`@O21l47`PO11l87`@O21l47`PO17oo00<007ooOol0
3Goo0007Ool50002Ool04@00Oomoogoo2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003`?T01P000?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d00020o/01@?l0o/3n`?k0o`0
0`?k00@3o0?k0o/3nb800083O`050il3O`=o0gl3W`030gl07P>O0gl3O`=o0il000:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000h0W`0<00047`PO11l87`@O21l47`PO
11l87`@O17oo00<007ooOol03Goo0009Ool00`00Oomoo`02Ool04@00Oomoogoo1n0;h0OP2n07h0_P
1n0;h0OP2n07h0_P00003`?T00<000?/0n`02@?/00<000?d0o<00P?c00D3m0?c0o<3l`?d0083l`03
0003n`?k00d3nad00183O`030002O`:O00<2O`060Yl2O`9o0Wl2W`00306O00<0002O09l0302O00`0
00PO11l87`@O21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000Uoo`03001oogoo009oo`80009o
o`0=2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003`?T01T000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0
00?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083
naT000050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o01`3W`=o0002O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000h0W`0<00047`PO11l87`@O21l47`PO11l8
7`@O0goo0P003goo0009Ool00`00Oomoo`02Ool04@00Oomoogoo1n0;h0OP2n07h0_P1n0;h0OP2n07
h0_P00003`?T00<000?/0n`02@?/00@000?c0o<3m0<3l`070o@3l`?c0o<3m0?c000050?k50004`=o
00<0009o0Yl00`9o00D2W`9o0Wl2O`:O0082O`030001W`6O00T1W`030000W`2O00d0W`0<00087`@O
21l47`PO11l87`@O21l47`PO17oo00<007ooOol03Goo0009Ool00`00Oomoo`02Ool04@00Oomoogoo
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP00003`?T01/000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k000
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o003
0o/00`?l0o/0000>00030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0M0il3O`=o0002
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000?09l0300011l8
7`@O21l47`PO11l87`@O21l47`Aoo`03001oogoo00eoo`0027oo0P0017oo014007ooOomoo`OP2n07
h0_P1n0;h0OP2n07h0_P1n0;h00000l3i0030003k0?/00X3k0050003l`?c0o<3m0030o<01P?d0o<3
l`?c0o@001/3n`<001/3O`030002W`9o0082O`050Yl2O`9o0Wl2W`030Wl00`000Il1W`0:0Il00`00
09l0W`0=09l0300021l47`PO11l87`@O21l47`PO11l87`Aoo`03001oogoo00eoo`003Woo014007oo
Oomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n07h00000l3i00M0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k
0o/3n`?l00<3n`050o`3n`?k0o/3o0020o/00`000il3O`020gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`030gl06`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000?09l0300011l87`@O21l47`PO11l87`@O21l47`Aoo`03001o
ogoo00eoo`003Woo0P000Woo00d7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000@0n@00`000n`3k00:
0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00`?c00<000?k0o/06@?k00<000=o0gl06@=o00D0009o
0Wl2O`:O00<2O`070Yl2O`9o0Wl2W`9o0000306O00<0002O09l03@2O00`000PO11l87`@O21l47`PO
11l87`@O21l3Ool2000?Ool000ioo`0A001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000@
0n@07P000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`00
0o/3o0<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00H3o0?k0o/3n`?l00020gl01@>O
0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl07@>O0002W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00003`2O00`000@O21l47`PO
11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol7h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n00000@0n@00`000n`3k00:0n`010000o<3l`?d0`?c00D3m0?c0o<3l`?d0083l`030003
n`?k01P3n`030003O`=o01P3O`040002O`9o0Yl30Wl01@:O0Wl2O`9o0Yl00P9o00<0006O0Il02`6O
00<0002O09l03@2O00`000PO11l87`@O21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000ioo`0A
001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P1n00000@0n@07@000n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00000P?k00D3o0?k0o/3n`?l00<3n`05
0o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00P?k00<000>O0gl00P=o00D3W`=o0gl3O`>O00<3O`05
0il3O`=o0gl3W`030gl08`>O0gl3O`=o0il3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl0005o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00003`2O00`000@O21l47`PO11l87`@O21l47`PO11l4Ool0
0`00Oomoo`0=Ool000ioo`0A001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP2n00000@0n@00`00
0n`3k00;0n`01@000o<3l`?c0o@00`?c00L3m0?c0o<3l`?d0o<0000I0o/00`000gl3O`0G0gl00`00
0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<0006O0Il0306O00<0002O09l03@2O00`000PO11l87`@O
21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000ioo`0A001oogooOol;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n00000@0n@07P000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<000<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00H3o0?k0o/3
n`?l00020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl07P00
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000l0
W`0<00047`PO11l87`@O21l47`PO11l87`@O17oo00<007ooOol03Goo000>Ool20002Ool030OP2n07
h0_P1n0;h0OP2n07h0_P1n000143i0030003k0?/00/3k0030003l`?d00<3l`050o@3l`?c0o<3m003
0o<00`?d0003n`0G0o/00`000gl3O`0F0gl00`000Yl2O`020Wl01@:O0Wl2O`9o0Yl00`9o00<2W`9o
00003@6O00<0002O09l03`2O00/000@O21l47`PO11l87`@O21l47`PO00=oo`8000moo`003Woo0100
07ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n000143i00P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0<3n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il0
0`=o0283W`=o0gl3O`000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il00140W`0;00087`@O21l47`PO11l87`@O21l47`04Ool00`00Oomoo`0=Ool000io
o`0@001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP000A0n@00`000n`3k00<0n`010000o<3l`?d
0`?c00D3m0?c0o<3l`?d00<3l`030003n`?k01D3n`030003O`=o01D3O`050002O`9o0Wl2W`030Wl0
1@:O0Wl2O`9o0Yl00P9o00<0006O0Il0306O00<0002O09l03`2O00/000@O21l47`PO11l87`@O21l4
7`PO00Aoo`03001oogoo00eoo`003Woo010007ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP2n000143
i00R0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<000?k0o`30o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`000=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`0P0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00140W`0;00087`@O21l47`PO11l8
7`@O21l47`04Ool00`00Oomoo`0=Ool000ioo`0@001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP
000A0n@00`000n`3k00<0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00`?c00@3m0?c0o<001H3n`03
0003O`=o01D3O`030002O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`:O0001W`0=0Il00`0009l0W`0?
09l02`0011l87`@O21l47`PO11l87`@O21l017oo00<007ooOol03Goo000>Ool20002Ool030_P1n0;
h0OP2n07h0_P1n0;h0OP2n000143i00Q0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000083n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k
0o`00`?k00D3o0?k0o/000>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o0283W`=o
0002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il00140W`0;00087`@O21l47`PO11l87`@O21l47`03Ool2000?Ool000ioo`0@001oogooOol7h0_P
1n0;h0OP2n07h0_P1n0;h0OP000A0n@00`000n`3k00=0n`00`000o<3m0030o<01@?d0o<3l`?c0o@0
0`?c00<3m0?c00005@?k00<000=o0gl050=o00<000:O0Wl00P9o00D2W`9o0Wl2O`:O00<2O`030Yl2
O`0000l1W`030000W`2O00l0W`0;00047`PO11l87`@O21l47`PO11l87`04Ool00`00Oomoo`0=Ool0
00ioo`0@001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h0_P000B0n@08@000n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0030o/01@?l0o/3
n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`000=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3
W`=o0gl3O`>O0083O`0Q0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`000140W`0;00087`@O21l47`PO11l87`@O21l47`04Ool00`00Oomo
o`0=Ool000ioo`0@001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP000B0n@00`000n`3k00<0n`0
1@000o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030003n`?k01<3n`030003O`=o01<3O`050002
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<0006O0Il03@6O00<0002O09l03`2O00/000@O21l4
7`PO11l87`@O21l47`PO00Aoo`03001oogoo00eoo`003Woo010007ooOomoo`_P1n0;h0OP2n07h0_P
1n0;h0OP2n000183i00S0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`000o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083
n`030003W`=o0083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o0280009o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00140W`0;
00087`@O21l47`PO11l87`@O21l47`04Ool00`00Oomoo`0=Ool000ioo`0@001oogooOol7h0_P1n0;
h0OP2n07h0_P1n0;h0OP000B0n@00`000n`3k00=0n`00`000o@3l`020o<01@?d0o<3l`?c0o@00`?c
00@3m0?c0o<001@3n`030003O`=o0183O`040002O`9o0Yl30Wl01@:O0Wl2O`9o0Yl00`9o00<2W`00
0Il03`6O00<0002O09l03`2O00/000@O21l47`PO11l87`@O21l47`PO00Aoo`03001oogoo00eoo`00
3Woo0P000Woo00`;h0OP2n07h0_P1n0;h0OP2n07h0_P000B0n@08@000n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0003l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000030o/01@?l0o/3n`?k
0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`000=o0gl3W`030gl01@>O0gl3O`=o0il00`=o02P3W`=o
0gl3O`>O0gl0009o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il00140W`0;00087`@O21l47`PO11l87`@O21l47`03Ool2000?Ool000ioo`0@
001oogooOol7h0_P1n0;h0OP2n07h0_P1n0;h0OP000B0n@00`000n`3k00=0n`010000o<3l`?d0`?c
00D3m0?c0o<3l`?d00<3l`030o@3l`0001<3n`030003O`=o0143O`030002O`:O00<2O`050Yl2O`9o
0Wl2W`030Wl010:O0Wl2O`00406O00<0002O09l03`2O00/000@O21l47`PO11l87`@O21l47`PO00Ao
o`03001oogoo00eoo`003Woo00l007ooOomoo`_P1n0;h0OP2n07h0_P1n0;h0OP00004`?T02<000?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@000?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00P?k00<000>O0gl00P=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`020gl08`000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00004P2O00X000@O21l47`PO11l87`@O
21l47`Aoo`03001oogoo00eoo`001goo10000goo00l007ooOomoo`OP2n07h0_P1n0;h0OP2n07h0_P
00004`?T00<000?/0n`03P?/00D000?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<00`000o/3n`0A
0o/00`000gl3O`0A0gl01@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030001W`6O00l1W`03
0000W`2O0100W`0:00087`@O21l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000Moo`03001oogoo
00Aoo`0?001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h00001<3i00U0003j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<000?k0o`00`?k
00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3
W`030gl090000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il00180W`0:00047`PO11l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool0
00Qoo`03001oogoo00=oo`80009oo`0;1n0;h0OP2n07h0_P1n0;h0OP2n00000C0n@00`000n`3k00>
0n`00`000o<3m0030o<01@?d0o<3l`?c0o@00`?c00@3m0?c0o<00183n`030003O`=o0103O`040002
O`9o0Yl30Wl01@:O0Wl2O`9o0Yl00`9o00<2W`9o00004@6O00<0002O09l0402O00X000PO11l87`@O
21l47`PO11l87`=oo`8000moo`002Goo00<007ooOol00Woo00l007ooOomoo`_P1n0;h0OP2n07h0_P
1n0;h0OP00004`?T02<000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`0000<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00P?k
00<000>O0gl00P=o00D3W`=o0gl3O`>O00<3O`0Z0il3O`=o0gl3W`=o0002O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`004P2O00X0
00@O21l47`PO11l87`@O21l47`Aoo`03001oogoo00eoo`001goo00@007ooOol000=oo`0?001oogoo
Ool7h0_P1n0;h0OP2n07h0_P1n0;h00001<3i0030003k0?/00h3k0050003l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00<3m0000o/04@?k00<000=o0gl040=o00<000:O0Wl00P9o00D2W`9o0Wl2O`:O
00<2O`050Yl2O`9o0Wl0000A0Il00`0009l0W`0A09l02@0011l87`@O21l47`PO11l87`04Ool00`00
Oomoo`0=Ool000Qoo`8000Aoo`0?001oogooOol;h0OP2n07h0_P1n0;h0OP2n07h00001<3i00U0003
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<000?k0o`00`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O
00<3O`050il3O`=o0gl3W`030gl090000Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il001<0W`0900087`@O21l47`PO11l87`@O00Ao
o`03001oogoo00eoo`003Woo00h007ooOomoo`OP2n07h0_P1n0;h0OP2n07h0004`?T00<000?/0n`0
3`?/00<000?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<0000A0o/00`000gl3O`0?0gl0
1@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl2O`000141W`030000W`2O0140W`090004
7`PO11l87`@O21l47`PO00Aoo`03001oogoo00eoo`003Woo00h007ooOomoo`_P1n0;h0OP2n07h0_P
1n0;h0004`?T02D000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083
n`030003W`=o0083O`050il3O`=o0gl3W`030gl0:P>O0gl3O`=o0il000:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il001<0W`09
00087`@O21l47`PO11l87`@O00Aoo`03001oogoo00eoo`003Woo0P000Woo00X7h0_P1n0;h0OP2n07
h0_P1n0001<3i0030003k0?/00l3k0050003l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0?c
00004@?k00<000=o0gl03`=o00<0009o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl0000A
0Il00`0009l0W`0B09l0200021l47`PO11l87`@O21l3Ool2000?Ool000ioo`0>001oogooOol;h0OP
2n07h0_P1n0;h0OP2n0001<3i00V0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0<3n`050o`3n`?k0o/3o0030o/01P?l
0o/3n`?k0o`00083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00P=o02D000:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0
000D09l0200011l87`@O21l47`PO11l4Ool00`00Oomoo`0=Ool000ioo`0>001oogooOol7h0_P1n0;
h0OP2n07h0_P1n0001<3i0030003k0?/00l3k0030003l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c00004@?k00<000=o0gl03`=o00D0009o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`:O
0Wl0000A0Il00`0009l0W`0B09l0200021l47`PO11l87`@O21l4Ool00`00Oomoo`0=Ool000ioo`0=
001oogooOol;h0OP2n07h0_P1n0;h0OP000050?T02D000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000020o/01@?l0o/3n`?k
0o`00`?k00D3o0?k0o/3n`?l0083n`030003W`=o0083O`050il3O`=o0gl3W`030gl0:P>O0gl3O`=o
0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il001@0W`0800047`PO11l87`@O21l47`Aoo`03001oogoo00eoo`003Woo00d0
07ooOomoo`OP2n07h0_P1n0;h0OP2n00000D0n@00`000n`3k00?0n`01@000o<3l`?c0o@00`?c00D3
m0?c0o<3l`?d00<3l`030o@3l`000143n`030003O`=o00l3O`030002O`:O00<2O`050Yl2O`9o0Wl2
W`030Wl01@:O0Wl2O`9o00004@6O00<0002O09l04`2O00L000@O21l47`PO11l87`04Ool00`00Oomo
o`0=Ool000ioo`80009oo`092n07h0_P1n0;h0OP2n07h00001@3i00V0003k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0<3
n`050o`3n`?k0o/3o0030o/01P?l0o/3n`?k0o`00083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o
0il00P=o02H000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`00502O00L000PO11l87`@O21l47`03Ool2000?Ool000ioo`0<
001oogooOol7h0_P1n0;h0OP2n07h0005@?T00<000?/0n`040?/00<000?d0o<00P?c00D3m0?c0o<3
l`?d00<3l`050o@3l`?c0o<0000A0o/00`000gl3O`0?0gl01@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`:O00<2O`030Yl2O`000181W`030000W`2O0180W`0700047`PO11l87`@O21l017oo00<007ooOol0
3Goo000>Ool03000Oomoogoo2n07h0_P1n0;h0OP2n0001D3i00U0003k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00000P?k00D3
o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0020o/00`000il3O`020gl01@>O0gl3O`=o0il00`=o02/3
W`=o0gl3O`>O0002W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000D09l01`0021l47`PO11l87`@O00Aoo`03001oogoo00eo
o`003Woo00`007ooOomoo`OP2n07h0_P1n0;h0OP000E0n@00`000n`3k00@0n`010000o<3l`?d0`?c
00D3m0?c0o<3l`?d00<3l`030o@3l`000143n`030003O`=o00l3O`030002O`:O00<2O`050Yl2O`9o
0Wl2W`030Wl01@:O0Wl2O`9o00004P6O00<0002O09l04P2O00L000@O21l47`PO11l87`04Ool00`00
Oomoo`0=Ool000ioo`0<001oogooOol;h0OP2n07h0_P1n0;h0005@?T02H000?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`000o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@000?l
0`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o
0gl3W`020gl09P000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o000D09l01`0021l47`PO11l87`@O00Aoo`03001oogoo00eo
o`003Woo00/007ooOomoo`OP2n07h0_P1n0;h00001H3i0030003k0?/0103k0030003m0?c0083l`05
0o@3l`?c0o<3m0030o<01@?d0o<3l`?c00004@?k00<000=o0gl03`=o00D0009o0Wl2O`:O00<2O`05
0Yl2O`9o0Wl2W`030Wl00`:O0Wl0000B0Il00`0009l0W`0C09l01P0021l47`PO11l87`Aoo`03001o
ogoo00eoo`003Woo0P000Woo00L;h0OP2n07h0_P1n00000E0n@09P000n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/000?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d00020o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083n`030003W`=o0083O`050il3O`=o0gl3W`030gl0
:`>O0gl3O`=o0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl0006O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0001D0W`0600047`PO11l87`@O0goo0P003goo000>Ool0
2`00Oomoogoo1n0;h0OP2n07h0_P00005@?T00<000?/0n`040?/00D000?c0o<3l`?d00<3l`050o@3
l`?c0o<3m0030o<00`?d0o<0000A0o/00`000gl3O`0?0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl0
0`9o00D2W`9o0Wl2O`000181W`030000W`2O01<0W`0600087`@O21l47`PO17oo00<007ooOol03Goo
000>Ool02`00Oomoogoo2n07h0_P1n0;h0OP00005@?T02L000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000o`00`?k00D3
o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`02
0gl09P000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`000Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o000E09l01P0011l87`@O21l47`Aoo`03001oogoo00eoo`003Woo00X0
07ooOomoo`OP2n07h0_P1n0001H3i0030003k0?/0103k0030003l`?d00<3l`050o@3l`?c0o<3m003
0o<01@?d0o<3l`?c00004@?k00<000=o0gl03`=o00D0009o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`03
0Wl00`:O0Wl0000B0Il00`0009l0W`0D09l01@0011l87`@O21l017oo00<007ooOol03Goo000>Ool0
2P00Oomoogoo2n07h0_P1n0;h0005P?T02H000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0000P?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0020o/00`000il3O`020gl01@>O0gl3O`=o0il00`=o02/3W`=o0gl3O`>O0002
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl0000F09l01@0021l47`PO11l017oo00<007ooOol03Goo000>Ool02P00Oomoogoo
1n0;h0OP2n07h0005P?T00<000?/0n`040?/00D000?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<0
0`?d0o<0000A0o/00`000gl3O`0?0gl00`000Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`000181W`030000W`2O01@0W`0500047`PO11l87`04Ool00`00Oomoo`0=Ool000ioo`80009oo`05
2n07h0_P1n00000G0n@09`000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0003m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0003o0030o/01@?l0o/3n`?k0o`00`?k00H3o0?k
0o/3n`?l00020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O0083O`0W0002W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`0001H0W`0400047`PO11l3Ool2000?Ool000ioo`09001oogooOol7h0_P1n0;h00001L3i0030003
k0?/0103k0030003l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c00004@?k00<000=o0gl0
3`=o00D0009o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl00`:O0Wl0000C0Il00`0009l0W`0D09l0
100021l47`PO17oo00<007ooOol03Goo000>Ool02@00Oomoogoo2n07h0_P1n00000F0n@09`000n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@000020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083n`030003W`=o0083
O`050il3O`=o0gl3W`030gl0;0>O0gl3O`=o0il000:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O000F09l0100011l87`@O
17oo00<007ooOol03Goo0008Ool20004Ool02@00Oomoogoo1n0;h0OP2n00000F0n@00`000n`3k00A
0n`01@000o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030o@3l`000143n`030003O`=o00l3O`03
0002O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01P:O0Wl2O`9o0Yl00181W`030000W`2O01@0W`040008
7`@O21l4Ool00`00Oomoo`0=Ool000Moo`04001oogoo0003Ool02000Oomoogoo2n07h0_P000G0n@0
:0000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`000?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@000?l0`?k00D3o0?k0o/3n`?l00<3n`060o`3n`?k0o/3o0000P=o00D3
W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`020gl0:0000Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`005P2O00<000PO
11l017oo00<007ooOol03Goo0009Ool00`00Oomoo`02Ool20002Ool010OP2n07h0005`?T00<000?/
0n`04@?/00<000?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<0000A0o/00`000gl3O`0?
0gl01@000Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`040Yl2O`9o000C0Il00`0009l0W`0D09l0
0`0011l87`03Ool2000?Ool000Yoo`05001oogooOol0001FOol00`00Oomoo`1DOol00`00Oomoo`0=
Ool000Moo`04001oogoo0003Ool00`00Oomoo`1DOol00`00Oomoo`1DOol00`00Oomoo`0=Ool000Qo
o`8000Aoo`05001oogooOol0000KOol00`00Oomoo`0IOol00`00Oomoo`0HOol00`00Oomoo`0IOol0
0`00Oomoo`0HOol00`00Oomoo`0IOol01@00Oomoogoo00003goo000>Oon_000?Ool00<aoo`00c7oo
003<Ool00<aoo`00c7oo003<Ool00<aoo`00Hgoo0P00Igoo001TOol00`00Oomoo`1UOol006Eoo`03
001oogoo06Aoo`00I7oo00<007oo0000IGoo001SOol01000Oomoo`00IGoo001ROol300000goo0000
001TOol00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00001\
\>"],
  ImageRangeCache->{{{0, 203.5}, {204.125, 0}} -> {-3.68919, -3.55538, \
0.0362877, 0.0362877}}]
}, Open  ]],

Cell["\<\
The related representation of the angular part of the velocity \
field is given by\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(u2 = uth[r, \[Theta], 1, 1] /. coordTrafo\)], "Input"],

Cell[BoxData[
    \(\(-\(\(\((\(-3\) - 1\/\(x\^2 + y\^2\) + 4\ \@\(x\^2 + y\^2\))\)\ 
            Sin[ArcTan[x, y]]\)\/\(4\ \@\(x\^2 + y\^2\)\)\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The graphical illustration of the angular component ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\[Theta]\)]],
  " is "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[{
        ContourPlot[
          If[x == 0 && y == 0, 0, u2], {x, \(-3\), 3}, {y, \(-3\), 3}, 
          PlotPoints \[Rule] 35, ColorFunction \[Rule] Hue, 
          AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True, 
          Contours \[Rule] 25, DisplayFunction \[Rule] Identity], 
        Graphics[Disk[{0, 0}, 1.1]]}, AspectRatio \[Rule] Automatic, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input",
  PageBreakWithin->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.18254 -0.0125 -6 -9 ]
[.18254 -0.0125 6 0 ]
[.34127 -0.0125 -6 -9 ]
[.34127 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -12 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .18254 -12 -4.5 ]
[-0.0125 .18254 0 4.5 ]
[-0.0125 .34127 -12 -4.5 ]
[-0.0125 .34127 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .65873 -6 -4.5 ]
[-0.0125 .65873 0 4.5 ]
[-0.0125 .81746 -6 -4.5 ]
[-0.0125 .81746 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 .5 0 -7.5 ]
[1.025 .5 10 7.5 ]
[.5 1.025 -5 0 ]
[.5 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(-3)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(-2)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(-1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(1)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(-3)] -0.0125 .02381 1 0 Mshowa
0 .18254 m
.00625 .18254 L
s
[(-2)] -0.0125 .18254 1 0 Mshowa
0 .34127 m
.00625 .34127 L
s
[(-1)] -0.0125 .34127 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .65873 m
.00625 .65873 L
s
[(1)] -0.0125 .65873 1 0 Mshowa
0 .81746 m
.00625 .81746 L
s
[(2)] -0.0125 .81746 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(3)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .05556 m
.00375 .05556 L
s
0 .0873 m
.00375 .0873 L
s
0 .11905 m
.00375 .11905 L
s
0 .15079 m
.00375 .15079 L
s
0 .21429 m
.00375 .21429 L
s
0 .24603 m
.00375 .24603 L
s
0 .27778 m
.00375 .27778 L
s
0 .30952 m
.00375 .30952 L
s
0 .37302 m
.00375 .37302 L
s
0 .40476 m
.00375 .40476 L
s
0 .43651 m
.00375 .43651 L
s
0 .46825 m
.00375 .46825 L
s
0 .53175 m
.00375 .53175 L
s
0 .56349 m
.00375 .56349 L
s
0 .59524 m
.00375 .59524 L
s
0 .62698 m
.00375 .62698 L
s
0 .69048 m
.00375 .69048 L
s
0 .72222 m
.00375 .72222 L
s
0 .75397 m
.00375 .75397 L
s
0 .78571 m
.00375 .78571 L
s
0 .84921 m
.00375 .84921 L
s
0 .88095 m
.00375 .88095 L
s
0 .9127 m
.00375 .9127 L
s
0 .94444 m
.00375 .94444 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.18254 .99375 m
.18254 1 L
s
.34127 .99375 m
.34127 1 L
s
.5 .99375 m
.5 1 L
s
.65873 .99375 m
.65873 1 L
s
.81746 .99375 m
.81746 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.05556 .99625 m
.05556 1 L
s
.0873 .99625 m
.0873 1 L
s
.11905 .99625 m
.11905 1 L
s
.15079 .99625 m
.15079 1 L
s
.21429 .99625 m
.21429 1 L
s
.24603 .99625 m
.24603 1 L
s
.27778 .99625 m
.27778 1 L
s
.30952 .99625 m
.30952 1 L
s
.37302 .99625 m
.37302 1 L
s
.40476 .99625 m
.40476 1 L
s
.43651 .99625 m
.43651 1 L
s
.46825 .99625 m
.46825 1 L
s
.53175 .99625 m
.53175 1 L
s
.56349 .99625 m
.56349 1 L
s
.59524 .99625 m
.59524 1 L
s
.62698 .99625 m
.62698 1 L
s
.69048 .99625 m
.69048 1 L
s
.72222 .99625 m
.72222 1 L
s
.75397 .99625 m
.75397 1 L
s
.78571 .99625 m
.78571 1 L
s
.84921 .99625 m
.84921 1 L
s
.88095 .99625 m
.88095 1 L
s
.9127 .99625 m
.9127 1 L
s
.94444 .99625 m
.94444 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .18254 m
1 .18254 L
s
.99375 .34127 m
1 .34127 L
s
.99375 .5 m
1 .5 L
s
.99375 .65873 m
1 .65873 L
s
.99375 .81746 m
1 .81746 L
s
.99375 .97619 m
1 .97619 L
s
.125 Mabswid
.99625 .05556 m
1 .05556 L
s
.99625 .0873 m
1 .0873 L
s
.99625 .11905 m
1 .11905 L
s
.99625 .15079 m
1 .15079 L
s
.99625 .21429 m
1 .21429 L
s
.99625 .24603 m
1 .24603 L
s
.99625 .27778 m
1 .27778 L
s
.99625 .30952 m
1 .30952 L
s
.99625 .37302 m
1 .37302 L
s
.99625 .40476 m
1 .40476 L
s
.99625 .43651 m
1 .43651 L
s
.99625 .46825 m
1 .46825 L
s
.99625 .53175 m
1 .53175 L
s
.99625 .56349 m
1 .56349 L
s
.99625 .59524 m
1 .59524 L
s
.99625 .62698 m
1 .62698 L
s
.99625 .69048 m
1 .69048 L
s
.99625 .72222 m
1 .72222 L
s
.99625 .75397 m
1 .75397 L
s
.99625 .78571 m
1 .78571 L
s
.99625 .84921 m
1 .84921 L
s
.99625 .88095 m
1 .88095 L
s
.99625 .9127 m
1 .9127 L
s
.99625 .94444 m
1 .94444 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
gsave
1.025 .5 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.5 0 m
.5 1 L
s
gsave
.5 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .16 1 r
.02381 .97619 m
.97619 .97619 L
.97619 .02381 L
.02381 .02381 L
F
0 .4 1 r
.02381 .08384 m
.05182 .09917 L
.06794 .10784 L
.07983 .11416 L
.10784 .12873 L
.1219 .13585 L
.13585 .14278 L
.16387 .15619 L
.18069 .16387 L
.19188 .16879 L
.21989 .1804 L
.2479 .19078 L
.25108 .19188 L
.27591 .19971 L
.30392 .20693 L
.33193 .21233 L
.35994 .21592 L
.38796 .21794 L
.41597 .21881 L
.44398 .21899 L
.47199 .21891 L
.5 .21885 L
.52801 .21891 L
.55602 .21899 L
.58403 .21881 L
.61204 .21794 L
.64006 .21592 L
.66807 .21233 L
.69608 .20693 L
.72409 .19971 L
.74892 .19188 L
.7521 .19078 L
.78011 .1804 L
.80812 .16879 L
.81931 .16387 L
.83613 .15619 L
.86415 .14278 L
.8781 .13585 L
.89216 .12873 L
.92017 .11416 L
.93206 .10784 L
.94818 .09917 L
.97619 .08384 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.5 Mabswid
.02381 .08384 m
.05182 .09917 L
.06794 .10784 L
.07983 .11416 L
.10784 .12873 L
.1219 .13585 L
.13585 .14278 L
.16387 .15619 L
.18069 .16387 L
.19188 .16879 L
.21989 .1804 L
.2479 .19078 L
.25108 .19188 L
.27591 .19971 L
.30392 .20693 L
.33193 .21233 L
.35994 .21592 L
.38796 .21794 L
.41597 .21881 L
.44398 .21899 L
.47199 .21891 L
.5 .21885 L
.52801 .21891 L
.55602 .21899 L
.58403 .21881 L
.61204 .21794 L
.64006 .21592 L
.66807 .21233 L
.69608 .20693 L
.72409 .19971 L
.74892 .19188 L
.7521 .19078 L
.78011 .1804 L
.80812 .16879 L
.81931 .16387 L
.83613 .15619 L
.86415 .14278 L
.8781 .13585 L
.89216 .12873 L
.92017 .11416 L
.93206 .10784 L
.94818 .09917 L
.97619 .08384 L
s
0 .64 1 r
.02381 .25373 m
.05182 .26279 L
.07983 .27156 L
.09414 .27591 L
.10784 .27997 L
.13585 .28791 L
.16387 .29522 L
.19188 .30168 L
.20268 .30392 L
.21989 .30701 L
.2479 .3108 L
.27591 .31258 L
.30392 .31194 L
.33193 .30877 L
.35893 .30392 L
.35994 .3036 L
.38796 .2975 L
.41597 .29163 L
.44398 .28691 L
.47199 .28388 L
.5 .28284 L
.52801 .28388 L
.55602 .28691 L
.58403 .29163 L
.61204 .2975 L
.64006 .3036 L
.64107 .30392 L
.66807 .30877 L
.69608 .31194 L
.72409 .31258 L
.7521 .3108 L
.78011 .30701 L
.79732 .30392 L
.80812 .30168 L
.83613 .29522 L
.86415 .28791 L
.89216 .27997 L
.90586 .27591 L
.92017 .27156 L
.94818 .26279 L
.97619 .25373 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .25373 m
.05182 .26279 L
.07983 .27156 L
.09414 .27591 L
.10784 .27997 L
.13585 .28791 L
.16387 .29522 L
.19188 .30168 L
.20268 .30392 L
.21989 .30701 L
.2479 .3108 L
.27591 .31258 L
.30392 .31194 L
.33193 .30877 L
.35893 .30392 L
.35994 .3036 L
.38796 .2975 L
.41597 .29163 L
.44398 .28691 L
.47199 .28388 L
.5 .28284 L
.52801 .28388 L
.55602 .28691 L
.58403 .29163 L
.61204 .2975 L
.64006 .3036 L
.64107 .30392 L
.66807 .30877 L
.69608 .31194 L
.72409 .31258 L
.7521 .3108 L
.78011 .30701 L
.79732 .30392 L
.80812 .30168 L
.83613 .29522 L
.86415 .28791 L
.89216 .27997 L
.90586 .27591 L
.92017 .27156 L
.94818 .26279 L
.97619 .25373 L
s
0 .88 1 r
.02381 .38399 m
.05013 .38796 L
.05182 .38821 L
.07983 .39225 L
.10784 .39606 L
.13585 .39954 L
.16387 .40258 L
.19188 .40493 L
.21989 .40623 L
.2479 .40583 L
.27591 .40255 L
.30392 .39466 L
.32094 .38796 L
.33193 .38114 L
.35994 .36428 L
.36753 .35994 L
.38796 .3482 L
.41597 .33516 L
.42425 .33193 L
.44398 .3259 L
.47199 .32044 L
.5 .31862 L
.52801 .32044 L
.55602 .3259 L
.57575 .33193 L
.58403 .33516 L
.61204 .3482 L
.63247 .35994 L
.64006 .36428 L
.66807 .38114 L
.67906 .38796 L
.69608 .39466 L
.72409 .40255 L
.7521 .40583 L
.78011 .40623 L
.80812 .40493 L
.83613 .40258 L
.86415 .39954 L
.89216 .39606 L
.92017 .39225 L
.94818 .38821 L
.94987 .38796 L
.97619 .38399 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .38399 m
.05013 .38796 L
.05182 .38821 L
.07983 .39225 L
.10784 .39606 L
.13585 .39954 L
.16387 .40258 L
.19188 .40493 L
.21989 .40623 L
.2479 .40583 L
.27591 .40255 L
.30392 .39466 L
.32094 .38796 L
.33193 .38114 L
.35994 .36428 L
.36753 .35994 L
.38796 .3482 L
.41597 .33516 L
.42425 .33193 L
.44398 .3259 L
.47199 .32044 L
.5 .31862 L
.52801 .32044 L
.55602 .3259 L
.57575 .33193 L
.58403 .33516 L
.61204 .3482 L
.63247 .35994 L
.64006 .36428 L
.66807 .38114 L
.67906 .38796 L
.69608 .39466 L
.72409 .40255 L
.7521 .40583 L
.78011 .40623 L
.80812 .40493 L
.83613 .40258 L
.86415 .39954 L
.89216 .39606 L
.92017 .39225 L
.94818 .38821 L
.94987 .38796 L
.97619 .38399 L
s
0 1 .88 r
.02381 .5 m
.05182 .5 L
.07983 .5 L
.10784 .5 L
.13585 .5 L
.16387 .5 L
.19188 .5 L
.21989 .5 L
.2479 .5 L
.27591 .5 L
.30392 .5 L
.32983 .5 L
.33193 .5 L
.34452 .47199 L
.35324 .44398 L
.35994 .42542 L
.36591 .41597 L
.38762 .38796 L
.38796 .38756 L
.41597 .36538 L
.42526 .35994 L
.44398 .35164 L
.47199 .34403 L
.5 .34154 L
.52801 .34403 L
.55602 .35164 L
.57474 .35994 L
.58403 .36538 L
.61204 .38756 L
.61238 .38796 L
.63409 .41597 L
.64006 .42542 L
.64676 .44398 L
.65548 .47199 L
.66807 .5 L
.67166 .5 L
.69608 .5 L
.72409 .5 L
.7521 .5 L
.78011 .5 L
.80812 .5 L
.83613 .5 L
.86415 .5 L
.89216 .5 L
.92017 .5 L
.94818 .5 L
.97619 .5 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .5 m
.05182 .5 L
.07983 .5 L
.10784 .5 L
.13585 .5 L
.16387 .5 L
.19188 .5 L
.21989 .5 L
.2479 .5 L
.27591 .5 L
.30392 .5 L
.32983 .5 L
.33193 .5 L
.34452 .47199 L
.35324 .44398 L
.35994 .42542 L
.36591 .41597 L
.38762 .38796 L
.38796 .38756 L
.41597 .36538 L
.42526 .35994 L
.44398 .35164 L
.47199 .34403 L
.5 .34154 L
.52801 .34403 L
.55602 .35164 L
.57474 .35994 L
.58403 .36538 L
.61204 .38756 L
.61238 .38796 L
.63409 .41597 L
.64006 .42542 L
.64676 .44398 L
.65548 .47199 L
.66807 .5 L
.67166 .5 L
.69608 .5 L
.72409 .5 L
.7521 .5 L
.78011 .5 L
.80812 .5 L
.83613 .5 L
.86415 .5 L
.89216 .5 L
.92017 .5 L
.94818 .5 L
.97619 .5 L
s
0 1 .64 r
.02381 .61601 m
.05013 .61204 L
.05182 .61179 L
.07983 .60775 L
.10784 .60394 L
.13585 .60046 L
.16387 .59742 L
.19188 .59507 L
.21989 .59377 L
.2479 .59417 L
.27591 .59745 L
.30392 .60534 L
.32094 .61204 L
.33193 .61886 L
.35994 .63572 L
.36753 .64006 L
.38796 .6518 L
.41597 .66484 L
.42425 .66807 L
.44398 .6741 L
.47199 .67956 L
.5 .68138 L
.52801 .67956 L
.55602 .6741 L
.57575 .66807 L
.58403 .66484 L
.61204 .6518 L
.63247 .64006 L
.64006 .63572 L
.66807 .61886 L
.67906 .61204 L
.69608 .60534 L
.72409 .59745 L
.7521 .59417 L
.78011 .59377 L
.80812 .59507 L
.83613 .59742 L
.86415 .60046 L
.89216 .60394 L
.92017 .60775 L
.94818 .61179 L
.94987 .61204 L
.97619 .61601 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .61601 m
.05013 .61204 L
.05182 .61179 L
.07983 .60775 L
.10784 .60394 L
.13585 .60046 L
.16387 .59742 L
.19188 .59507 L
.21989 .59377 L
.2479 .59417 L
.27591 .59745 L
.30392 .60534 L
.32094 .61204 L
.33193 .61886 L
.35994 .63572 L
.36753 .64006 L
.38796 .6518 L
.41597 .66484 L
.42425 .66807 L
.44398 .6741 L
.47199 .67956 L
.5 .68138 L
.52801 .67956 L
.55602 .6741 L
.57575 .66807 L
.58403 .66484 L
.61204 .6518 L
.63247 .64006 L
.64006 .63572 L
.66807 .61886 L
.67906 .61204 L
.69608 .60534 L
.72409 .59745 L
.7521 .59417 L
.78011 .59377 L
.80812 .59507 L
.83613 .59742 L
.86415 .60046 L
.89216 .60394 L
.92017 .60775 L
.94818 .61179 L
.94987 .61204 L
.97619 .61601 L
s
0 1 .4 r
.02381 .74627 m
.05182 .73721 L
.07983 .72844 L
.09414 .72409 L
.10784 .72003 L
.13585 .71209 L
.16387 .70478 L
.19188 .69832 L
.20268 .69608 L
.21989 .69299 L
.2479 .6892 L
.27591 .68742 L
.30392 .68806 L
.33193 .69123 L
.35893 .69608 L
.35994 .6964 L
.38796 .7025 L
.41597 .70837 L
.44398 .71309 L
.47199 .71612 L
.5 .71716 L
.52801 .71612 L
.55602 .71309 L
.58403 .70837 L
.61204 .7025 L
.64006 .6964 L
.64107 .69608 L
.66807 .69123 L
.69608 .68806 L
.72409 .68742 L
.7521 .6892 L
.78011 .69299 L
.79732 .69608 L
.80812 .69832 L
.83613 .70478 L
.86415 .71209 L
.89216 .72003 L
.90586 .72409 L
.92017 .72844 L
.94818 .73721 L
.97619 .74627 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .74627 m
.05182 .73721 L
.07983 .72844 L
.09414 .72409 L
.10784 .72003 L
.13585 .71209 L
.16387 .70478 L
.19188 .69832 L
.20268 .69608 L
.21989 .69299 L
.2479 .6892 L
.27591 .68742 L
.30392 .68806 L
.33193 .69123 L
.35893 .69608 L
.35994 .6964 L
.38796 .7025 L
.41597 .70837 L
.44398 .71309 L
.47199 .71612 L
.5 .71716 L
.52801 .71612 L
.55602 .71309 L
.58403 .70837 L
.61204 .7025 L
.64006 .6964 L
.64107 .69608 L
.66807 .69123 L
.69608 .68806 L
.72409 .68742 L
.7521 .6892 L
.78011 .69299 L
.79732 .69608 L
.80812 .69832 L
.83613 .70478 L
.86415 .71209 L
.89216 .72003 L
.90586 .72409 L
.92017 .72844 L
.94818 .73721 L
.97619 .74627 L
s
0 1 .16 r
.02381 .91616 m
.05182 .90083 L
.06794 .89216 L
.07983 .88584 L
.10784 .87127 L
.1219 .86415 L
.13585 .85722 L
.16387 .84381 L
.18069 .83613 L
.19188 .83121 L
.21989 .8196 L
.2479 .80922 L
.25108 .80812 L
.27591 .80029 L
.30392 .79307 L
.33193 .78767 L
.35994 .78408 L
.38796 .78206 L
.41597 .78119 L
.44398 .78101 L
.47199 .78109 L
.5 .78115 L
.52801 .78109 L
.55602 .78101 L
.58403 .78119 L
.61204 .78206 L
.64006 .78408 L
.66807 .78767 L
.69608 .79307 L
.72409 .80029 L
.74892 .80812 L
.7521 .80922 L
.78011 .8196 L
.80812 .83121 L
.81931 .83613 L
.83613 .84381 L
.86415 .85722 L
.8781 .86415 L
.89216 .87127 L
.92017 .88584 L
.93206 .89216 L
.94818 .90083 L
.97619 .91616 L
.97619 .97619 L
.02381 .97619 L
F
0 g
.02381 .91616 m
.05182 .90083 L
.06794 .89216 L
.07983 .88584 L
.10784 .87127 L
.1219 .86415 L
.13585 .85722 L
.16387 .84381 L
.18069 .83613 L
.19188 .83121 L
.21989 .8196 L
.2479 .80922 L
.25108 .80812 L
.27591 .80029 L
.30392 .79307 L
.33193 .78767 L
.35994 .78408 L
.38796 .78206 L
.41597 .78119 L
.44398 .78101 L
.47199 .78109 L
.5 .78115 L
.52801 .78109 L
.55602 .78101 L
.58403 .78119 L
.61204 .78206 L
.64006 .78408 L
.66807 .78767 L
.69608 .79307 L
.72409 .80029 L
.74892 .80812 L
.7521 .80922 L
.78011 .8196 L
.80812 .83121 L
.81931 .83613 L
.83613 .84381 L
.86415 .85722 L
.8781 .86415 L
.89216 .87127 L
.92017 .88584 L
.93206 .89216 L
.94818 .90083 L
.97619 .91616 L
s
.08 0 1 r
.68246 .02381 m
.66807 .03107 L
.64006 .04367 L
.61871 .05182 L
.61204 .05406 L
.58403 .06214 L
.55602 .06789 L
.52801 .07131 L
.5 .07244 L
.47199 .07131 L
.44398 .06789 L
.41597 .06214 L
.38796 .05406 L
.38129 .05182 L
.35994 .04367 L
.33193 .03107 L
.31754 .02381 L
F
0 g
.68246 .02381 m
.66807 .03107 L
.64006 .04367 L
.61871 .05182 L
.61204 .05406 L
.58403 .06214 L
.55602 .06789 L
.52801 .07131 L
.5 .07244 L
.47199 .07131 L
.44398 .06789 L
.41597 .06214 L
.38796 .05406 L
.38129 .05182 L
.35994 .04367 L
.33193 .03107 L
.31754 .02381 L
s
.08 1 0 r
.68246 .97619 m
.66807 .96893 L
.64006 .95633 L
.61871 .94818 L
.61204 .94594 L
.58403 .93786 L
.55602 .93211 L
.52801 .92869 L
.5 .92756 L
.47199 .92869 L
.44398 .93211 L
.41597 .93786 L
.38796 .94594 L
.38129 .94818 L
.35994 .95633 L
.33193 .96893 L
.31754 .97619 L
F
0 g
.68246 .97619 m
.66807 .96893 L
.64006 .95633 L
.61871 .94818 L
.61204 .94594 L
.58403 .93786 L
.55602 .93211 L
.52801 .92869 L
.5 .92756 L
.47199 .92869 L
.44398 .93211 L
.41597 .93786 L
.38796 .94594 L
.38129 .94818 L
.35994 .95633 L
.33193 .96893 L
.31754 .97619 L
s
0 .88 1 r
.35994 .5 m
.38796 .5 L
.41597 .5 L
.44398 .5 L
.47199 .5 L
.5 .52801 L
.52801 .5 L
.55602 .5 L
.58403 .5 L
.61204 .5 L
.64006 .5 L
.65548 .52801 L
.64676 .55602 L
.64006 .57458 L
.63409 .58403 L
.61238 .61204 L
.61204 .61244 L
.58403 .63462 L
.57474 .64006 L
.55602 .64836 L
.52801 .65597 L
.5 .65846 L
.47199 .65597 L
.44398 .64836 L
.42526 .64006 L
.41597 .63462 L
.38796 .61244 L
.38762 .61204 L
.36591 .58403 L
.35994 .57458 L
.35324 .55602 L
.34452 .52801 L
F
0 g
.35994 .5 m
.38796 .5 L
.41597 .5 L
.44398 .5 L
.47199 .5 L
.5 .52801 L
.52801 .5 L
.55602 .5 L
.58403 .5 L
.61204 .5 L
.64006 .5 L
.65548 .52801 L
.64676 .55602 L
.64006 .57458 L
.63409 .58403 L
.61238 .61204 L
.61204 .61244 L
.58403 .63462 L
.57474 .64006 L
.55602 .64836 L
.52801 .65597 L
.5 .65846 L
.47199 .65597 L
.44398 .64836 L
.42526 .64006 L
.41597 .63462 L
.38796 .61244 L
.38762 .61204 L
.36591 .58403 L
.35994 .57458 L
.35324 .55602 L
.34452 .52801 L
.35994 .5 L
s
0 1 .64 r
.5 .35738 m
.52646 .35994 L
.52801 .36028 L
.55602 .37018 L
.5832 .38796 L
.58403 .38866 L
.60529 .41597 L
.61204 .42996 L
.61405 .44398 L
.61204 .46829 L
.60906 .47199 L
.58403 .49223 L
.55602 .49814 L
.52801 .4997 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .4997 L
.44398 .49814 L
.41597 .49223 L
.39094 .47199 L
.38796 .46829 L
.38595 .44398 L
.38796 .42996 L
.39471 .41597 L
.41597 .38866 L
.4168 .38796 L
.44398 .37018 L
.47199 .36028 L
.47354 .35994 L
F
0 g
.5 .35738 m
.52646 .35994 L
.52801 .36028 L
.55602 .37018 L
.5832 .38796 L
.58403 .38866 L
.60529 .41597 L
.61204 .42996 L
.61405 .44398 L
.61204 .46829 L
.60906 .47199 L
.58403 .49223 L
.55602 .49814 L
.52801 .4997 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .4997 L
.44398 .49814 L
.41597 .49223 L
.39094 .47199 L
.38796 .46829 L
.38595 .44398 L
.38796 .42996 L
.39471 .41597 L
.41597 .38866 L
.4168 .38796 L
.44398 .37018 L
.47199 .36028 L
.47354 .35994 L
.5 .35738 L
s
0 .64 1 r
.41597 .50777 m
.44398 .50186 L
.47199 .5003 L
.5 .52801 L
.52801 .5003 L
.55602 .50186 L
.58403 .50777 L
.60906 .52801 L
.61204 .53171 L
.61405 .55602 L
.61204 .57004 L
.60529 .58403 L
.58403 .61134 L
.5832 .61204 L
.55602 .62982 L
.52801 .63972 L
.52646 .64006 L
.5 .64262 L
.47354 .64006 L
.47199 .63972 L
.44398 .62982 L
.4168 .61204 L
.41597 .61134 L
.39471 .58403 L
.38796 .57004 L
.38595 .55602 L
.38796 .53171 L
.39094 .52801 L
F
0 g
.41597 .50777 m
.44398 .50186 L
.47199 .5003 L
.5 .52801 L
.52801 .5003 L
.55602 .50186 L
.58403 .50777 L
.60906 .52801 L
.61204 .53171 L
.61405 .55602 L
.61204 .57004 L
.60529 .58403 L
.58403 .61134 L
.5832 .61204 L
.55602 .62982 L
.52801 .63972 L
.52646 .64006 L
.5 .64262 L
.47354 .64006 L
.47199 .63972 L
.44398 .62982 L
.4168 .61204 L
.41597 .61134 L
.39471 .58403 L
.38796 .57004 L
.38595 .55602 L
.38796 .53171 L
.39094 .52801 L
.41597 .50777 L
s
0 1 .4 r
.44398 .38426 m
.47199 .37316 L
.5 .36963 L
.52801 .37316 L
.55602 .38426 L
.56197 .38796 L
.58403 .40836 L
.58825 .41597 L
.5985 .44398 L
.59257 .47199 L
.58403 .48395 L
.55602 .49627 L
.52801 .49939 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49939 L
.44398 .49627 L
.41597 .48395 L
.40743 .47199 L
.4015 .44398 L
.41175 .41597 L
.41597 .40836 L
.43803 .38796 L
F
0 g
.44398 .38426 m
.47199 .37316 L
.5 .36963 L
.52801 .37316 L
.55602 .38426 L
.56197 .38796 L
.58403 .40836 L
.58825 .41597 L
.5985 .44398 L
.59257 .47199 L
.58403 .48395 L
.55602 .49627 L
.52801 .49939 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49939 L
.44398 .49627 L
.41597 .48395 L
.40743 .47199 L
.4015 .44398 L
.41175 .41597 L
.41597 .40836 L
.43803 .38796 L
.44398 .38426 L
s
0 .4 1 r
.41597 .51605 m
.44398 .50373 L
.47199 .50061 L
.5 .52801 L
.52801 .50061 L
.55602 .50373 L
.58403 .51605 L
.59257 .52801 L
.5985 .55602 L
.58825 .58403 L
.58403 .59164 L
.56197 .61204 L
.55602 .61574 L
.52801 .62684 L
.5 .63037 L
.47199 .62684 L
.44398 .61574 L
.43803 .61204 L
.41597 .59164 L
.41175 .58403 L
.4015 .55602 L
.40743 .52801 L
F
0 g
.41597 .51605 m
.44398 .50373 L
.47199 .50061 L
.5 .52801 L
.52801 .50061 L
.55602 .50373 L
.58403 .51605 L
.59257 .52801 L
.5985 .55602 L
.58825 .58403 L
.58403 .59164 L
.56197 .61204 L
.55602 .61574 L
.52801 .62684 L
.5 .63037 L
.47199 .62684 L
.44398 .61574 L
.43803 .61204 L
.41597 .59164 L
.41175 .58403 L
.4015 .55602 L
.40743 .52801 L
.41597 .51605 L
s
0 .16 1 r
.41597 .52586 m
.44398 .50562 L
.47199 .50091 L
.5 .52801 L
.52801 .50091 L
.55602 .50562 L
.58403 .52586 L
.5851 .52801 L
.58856 .55602 L
.58403 .57229 L
.57639 .58403 L
.55602 .60429 L
.54576 .61204 L
.52801 .61729 L
.5 .62092 L
.47199 .61729 L
.45424 .61204 L
.44398 .60429 L
.42361 .58403 L
.41597 .57229 L
.41144 .55602 L
.4149 .52801 L
F
0 g
.41597 .52586 m
.44398 .50562 L
.47199 .50091 L
.5 .52801 L
.52801 .50091 L
.55602 .50562 L
.58403 .52586 L
.5851 .52801 L
.58856 .55602 L
.58403 .57229 L
.57639 .58403 L
.55602 .60429 L
.54576 .61204 L
.52801 .61729 L
.5 .62092 L
.47199 .61729 L
.45424 .61204 L
.44398 .60429 L
.42361 .58403 L
.41597 .57229 L
.41144 .55602 L
.4149 .52801 L
.41597 .52586 L
s
0 1 .16 r
.47199 .38271 m
.5 .37908 L
.52801 .38271 L
.54576 .38796 L
.55602 .39571 L
.57639 .41597 L
.58403 .42771 L
.58856 .44398 L
.5851 .47199 L
.58403 .47414 L
.55602 .49438 L
.52801 .49909 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49909 L
.44398 .49438 L
.41597 .47414 L
.4149 .47199 L
.41144 .44398 L
.41597 .42771 L
.42361 .41597 L
.44398 .39571 L
.45424 .38796 L
F
0 g
.47199 .38271 m
.5 .37908 L
.52801 .38271 L
.54576 .38796 L
.55602 .39571 L
.57639 .41597 L
.58403 .42771 L
.58856 .44398 L
.5851 .47199 L
.58403 .47414 L
.55602 .49438 L
.52801 .49909 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49909 L
.44398 .49438 L
.41597 .47414 L
.4149 .47199 L
.41144 .44398 L
.41597 .42771 L
.42361 .41597 L
.44398 .39571 L
.45424 .38796 L
.47199 .38271 L
s
.08 0 1 r
.44398 .50753 m
.47199 .50122 L
.5 .52801 L
.52801 .50122 L
.55602 .50753 L
.57113 .52801 L
.58113 .55602 L
.56641 .58403 L
.55602 .5947 L
.52801 .60983 L
.5202 .61204 L
.5 .61403 L
.4798 .61204 L
.47199 .60983 L
.44398 .5947 L
.43359 .58403 L
.41887 .55602 L
.42887 .52801 L
F
0 g
.44398 .50753 m
.47199 .50122 L
.5 .52801 L
.52801 .50122 L
.55602 .50753 L
.57113 .52801 L
.58113 .55602 L
.56641 .58403 L
.55602 .5947 L
.52801 .60983 L
.5202 .61204 L
.5 .61403 L
.4798 .61204 L
.47199 .60983 L
.44398 .5947 L
.43359 .58403 L
.41887 .55602 L
.42887 .52801 L
.44398 .50753 L
s
.08 1 0 r
.5 .38597 m
.5202 .38796 L
.52801 .39017 L
.55602 .4053 L
.56641 .41597 L
.58113 .44398 L
.57113 .47199 L
.55602 .49247 L
.52801 .49878 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49878 L
.44398 .49247 L
.42887 .47199 L
.41887 .44398 L
.43359 .41597 L
.44398 .4053 L
.47199 .39017 L
.4798 .38796 L
F
0 g
.5 .38597 m
.5202 .38796 L
.52801 .39017 L
.55602 .4053 L
.56641 .41597 L
.58113 .44398 L
.57113 .47199 L
.55602 .49247 L
.52801 .49878 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49878 L
.44398 .49247 L
.42887 .47199 L
.41887 .44398 L
.43359 .41597 L
.44398 .4053 L
.47199 .39017 L
.4798 .38796 L
.5 .38597 L
s
.32 0 1 r
.44398 .50949 m
.47199 .50152 L
.5 .52801 L
.52801 .50152 L
.55602 .50949 L
.56772 .52801 L
.57507 .55602 L
.55866 .58403 L
.55602 .5868 L
.52801 .60271 L
.5 .60675 L
.47199 .60271 L
.44398 .5868 L
.44134 .58403 L
.42493 .55602 L
.43228 .52801 L
F
0 g
.44398 .50949 m
.47199 .50152 L
.5 .52801 L
.52801 .50152 L
.55602 .50949 L
.56772 .52801 L
.57507 .55602 L
.55866 .58403 L
.55602 .5868 L
.52801 .60271 L
.5 .60675 L
.47199 .60271 L
.44398 .5868 L
.44134 .58403 L
.42493 .55602 L
.43228 .52801 L
.44398 .50949 L
s
.32 1 0 r
.44398 .4132 m
.47199 .39729 L
.5 .39325 L
.52801 .39729 L
.55602 .4132 L
.55866 .41597 L
.57507 .44398 L
.56772 .47199 L
.55602 .49051 L
.52801 .49848 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49848 L
.44398 .49051 L
.43228 .47199 L
.42493 .44398 L
.44134 .41597 L
F
0 g
.44398 .4132 m
.47199 .39729 L
.5 .39325 L
.52801 .39729 L
.55602 .4132 L
.55866 .41597 L
.57507 .44398 L
.56772 .47199 L
.55602 .49051 L
.52801 .49848 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49848 L
.44398 .49051 L
.43228 .47199 L
.42493 .44398 L
.44134 .41597 L
.44398 .4132 L
s
.56 0 1 r
.44398 .51149 m
.47199 .50183 L
.5 .52801 L
.52801 .50183 L
.55602 .51149 L
.56529 .52801 L
.57014 .55602 L
.55602 .58039 L
.55215 .58403 L
.52801 .59682 L
.5 .60092 L
.47199 .59682 L
.44785 .58403 L
.44398 .58039 L
.42986 .55602 L
.43471 .52801 L
F
0 g
.44398 .51149 m
.47199 .50183 L
.5 .52801 L
.52801 .50183 L
.55602 .51149 L
.56529 .52801 L
.57014 .55602 L
.55602 .58039 L
.55215 .58403 L
.52801 .59682 L
.5 .60092 L
.47199 .59682 L
.44785 .58403 L
.44398 .58039 L
.42986 .55602 L
.43471 .52801 L
.44398 .51149 L
s
.56 1 0 r
.47199 .40318 m
.5 .39908 L
.52801 .40318 L
.55215 .41597 L
.55602 .41961 L
.57014 .44398 L
.56529 .47199 L
.55602 .48851 L
.52801 .49817 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49817 L
.44398 .48851 L
.43471 .47199 L
.42986 .44398 L
.44398 .41961 L
.44785 .41597 L
F
0 g
.47199 .40318 m
.5 .39908 L
.52801 .40318 L
.55215 .41597 L
.55602 .41961 L
.57014 .44398 L
.56529 .47199 L
.55602 .48851 L
.52801 .49817 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49817 L
.44398 .48851 L
.43471 .47199 L
.42986 .44398 L
.44398 .41961 L
.44785 .41597 L
.47199 .40318 L
s
.8 0 1 r
.44398 .51356 m
.47199 .50213 L
.5 .52801 L
.52801 .50213 L
.55602 .51356 L
.56333 .52801 L
.56596 .55602 L
.55602 .57488 L
.54609 .58403 L
.52801 .59204 L
.5 .59667 L
.47199 .59204 L
.45391 .58403 L
.44398 .57488 L
.43404 .55602 L
.43667 .52801 L
F
0 g
.44398 .51356 m
.47199 .50213 L
.5 .52801 L
.52801 .50213 L
.55602 .51356 L
.56333 .52801 L
.56596 .55602 L
.55602 .57488 L
.54609 .58403 L
.52801 .59204 L
.5 .59667 L
.47199 .59204 L
.45391 .58403 L
.44398 .57488 L
.43404 .55602 L
.43667 .52801 L
.44398 .51356 L
s
.8 1 0 r
.47199 .40796 m
.5 .40333 L
.52801 .40796 L
.54609 .41597 L
.55602 .42512 L
.56596 .44398 L
.56333 .47199 L
.55602 .48644 L
.52801 .49787 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49787 L
.44398 .48644 L
.43667 .47199 L
.43404 .44398 L
.44398 .42512 L
.45391 .41597 L
F
0 g
.47199 .40796 m
.5 .40333 L
.52801 .40796 L
.54609 .41597 L
.55602 .42512 L
.56596 .44398 L
.56333 .47199 L
.55602 .48644 L
.52801 .49787 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49787 L
.44398 .48644 L
.43667 .47199 L
.43404 .44398 L
.44398 .42512 L
.45391 .41597 L
.47199 .40796 L
s
1 0 .96 r
.44398 .51571 m
.47199 .50244 L
.5 .52801 L
.52801 .50244 L
.55602 .51571 L
.56167 .52801 L
.56231 .55602 L
.55602 .56946 L
.53982 .58403 L
.52801 .58824 L
.5 .59327 L
.47199 .58824 L
.46018 .58403 L
.44398 .56946 L
.43769 .55602 L
.43833 .52801 L
F
0 g
.44398 .51571 m
.47199 .50244 L
.5 .52801 L
.52801 .50244 L
.55602 .51571 L
.56167 .52801 L
.56231 .55602 L
.55602 .56946 L
.53982 .58403 L
.52801 .58824 L
.5 .59327 L
.47199 .58824 L
.46018 .58403 L
.44398 .56946 L
.43769 .55602 L
.43833 .52801 L
.44398 .51571 L
s
1 .96 0 r
.47199 .41176 m
.5 .40673 L
.52801 .41176 L
.53982 .41597 L
.55602 .43054 L
.56231 .44398 L
.56167 .47199 L
.55602 .48429 L
.52801 .49756 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49756 L
.44398 .48429 L
.43833 .47199 L
.43769 .44398 L
.44398 .43054 L
.46018 .41597 L
F
0 g
.47199 .41176 m
.5 .40673 L
.52801 .41176 L
.53982 .41597 L
.55602 .43054 L
.56231 .44398 L
.56167 .47199 L
.55602 .48429 L
.52801 .49756 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49756 L
.44398 .48429 L
.43833 .47199 L
.43769 .44398 L
.44398 .43054 L
.46018 .41597 L
.47199 .41176 L
s
1 .72 0 r
.47199 .41469 m
.5 .40957 L
.52801 .41469 L
.5326 .41597 L
.55602 .43654 L
.55905 .44398 L
.56021 .47199 L
.55602 .48201 L
.52801 .49726 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49726 L
.44398 .48201 L
.43979 .47199 L
.44095 .44398 L
.44398 .43654 L
.4674 .41597 L
F
0 g
.47199 .41469 m
.5 .40957 L
.52801 .41469 L
.5326 .41597 L
.55602 .43654 L
.55905 .44398 L
.56021 .47199 L
.55602 .48201 L
.52801 .49726 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49726 L
.44398 .48201 L
.43979 .47199 L
.44095 .44398 L
.44398 .43654 L
.4674 .41597 L
.47199 .41469 L
s
1 0 .72 r
.44398 .51799 m
.47199 .50274 L
.5 .52801 L
.52801 .50274 L
.55602 .51799 L
.56021 .52801 L
.55905 .55602 L
.55602 .56346 L
.5326 .58403 L
.52801 .58531 L
.5 .59043 L
.47199 .58531 L
.4674 .58403 L
.44398 .56346 L
.44095 .55602 L
.43979 .52801 L
F
0 g
.44398 .51799 m
.47199 .50274 L
.5 .52801 L
.52801 .50274 L
.55602 .51799 L
.56021 .52801 L
.55905 .55602 L
.55602 .56346 L
.5326 .58403 L
.52801 .58531 L
.5 .59043 L
.47199 .58531 L
.4674 .58403 L
.44398 .56346 L
.44095 .55602 L
.43979 .52801 L
.44398 .51799 L
s
1 .48 0 r
.5 .41205 m
.52443 .41597 L
.52801 .4177 L
.55602 .44375 L
.5561 .44398 L
.55889 .47199 L
.55602 .47958 L
.52801 .49695 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49695 L
.44398 .47958 L
.44111 .47199 L
.4439 .44398 L
.44398 .44375 L
.47199 .4177 L
.47557 .41597 L
F
0 g
.5 .41205 m
.52443 .41597 L
.52801 .4177 L
.55602 .44375 L
.5561 .44398 L
.55889 .47199 L
.55602 .47958 L
.52801 .49695 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49695 L
.44398 .47958 L
.44111 .47199 L
.4439 .44398 L
.44398 .44375 L
.47199 .4177 L
.47557 .41597 L
.5 .41205 L
s
1 0 .48 r
.44398 .52042 m
.47199 .50305 L
.5 .52801 L
.52801 .50305 L
.55602 .52042 L
.55889 .52801 L
.5561 .55602 L
.55602 .55625 L
.52801 .5823 L
.52443 .58403 L
.5 .58795 L
.47557 .58403 L
.47199 .5823 L
.44398 .55625 L
.4439 .55602 L
.44111 .52801 L
F
0 g
.44398 .52042 m
.47199 .50305 L
.5 .52801 L
.52801 .50305 L
.55602 .52042 L
.55889 .52801 L
.5561 .55602 L
.55602 .55625 L
.52801 .5823 L
.52443 .58403 L
.5 .58795 L
.47557 .58403 L
.47199 .5823 L
.44398 .55625 L
.4439 .55602 L
.44111 .52801 L
.44398 .52042 L
s
1 .24 0 r
.5 .41425 m
.51519 .41597 L
.52801 .42104 L
.55299 .44398 L
.55602 .44895 L
.55769 .47199 L
.55602 .47691 L
.52801 .49664 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49664 L
.44398 .47691 L
.44231 .47199 L
.44398 .44895 L
.44701 .44398 L
.47199 .42104 L
.48481 .41597 L
F
0 g
.5 .41425 m
.51519 .41597 L
.52801 .42104 L
.55299 .44398 L
.55602 .44895 L
.55769 .47199 L
.55602 .47691 L
.52801 .49664 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49664 L
.44398 .47691 L
.44231 .47199 L
.44398 .44895 L
.44701 .44398 L
.47199 .42104 L
.48481 .41597 L
.5 .41425 L
s
1 0 .24 r
.44398 .52309 m
.47199 .50336 L
.5 .52801 L
.52801 .50336 L
.55602 .52309 L
.55769 .52801 L
.55602 .55105 L
.55299 .55602 L
.52801 .57896 L
.51519 .58403 L
.5 .58575 L
.48481 .58403 L
.47199 .57896 L
.44701 .55602 L
.44398 .55105 L
.44231 .52801 L
F
0 g
.44398 .52309 m
.47199 .50336 L
.5 .52801 L
.52801 .50336 L
.55602 .52309 L
.55769 .52801 L
.55602 .55105 L
.55299 .55602 L
.52801 .57896 L
.51519 .58403 L
.5 .58575 L
.48481 .58403 L
.47199 .57896 L
.44701 .55602 L
.44398 .55105 L
.44231 .52801 L
.44398 .52309 L
s
1 0 0 r
.47199 .42387 m
.5 .43148 L
.52801 .42387 L
.55013 .44398 L
.55602 .45509 L
.55659 .47199 L
.55602 .47388 L
.52801 .49634 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49634 L
.44398 .47388 L
.44341 .47199 L
.44398 .45509 L
.44987 .44398 L
F
0 g
.47199 .42387 m
.5 .43148 L
.52801 .42387 L
.55013 .44398 L
.55602 .45509 L
.55659 .47199 L
.55602 .47388 L
.52801 .49634 L
.52801 .5 L
.5 .52801 L
.47199 .5 L
.47199 .49634 L
.44398 .47388 L
.44341 .47199 L
.44398 .45509 L
.44987 .44398 L
.47199 .42387 L
s
1 0 0 r
.44398 .52612 m
.47199 .50366 L
.5 .52801 L
.52801 .50366 L
.55602 .52612 L
.55659 .52801 L
.55602 .54491 L
.55013 .55602 L
.52801 .57613 L
.5 .56852 L
.47199 .57613 L
.44987 .55602 L
.44398 .54491 L
.44341 .52801 L
F
0 g
.44398 .52612 m
.47199 .50366 L
.5 .52801 L
.52801 .50366 L
.55602 .52612 L
.55659 .52801 L
.55602 .54491 L
.55013 .55602 L
.52801 .57613 L
.5 .56852 L
.47199 .57613 L
.44987 .55602 L
.44398 .54491 L
.44341 .52801 L
.44398 .52612 L
s
.5 .5 m
.5 .5 .1746 0 365.73 arc
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{196.25, 196.25},
  ImageMargins->{{64, 0}, {0, 3.25}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000340000a1000`40O003h00Oa7oo000DOol2000H
Ool4000FOol5000COol2000GOol5000EOol4000HOol2000COol001=oo`04001oogoo000GOol00`00
Oomoo`0IOol00`00Oomoo`0BOol01000Oomoo`0067oo00<007ooOol05Goo00<007ooOol067oo00@0
07ooOol0019oo`005Goo00<007ooOol05goo00<007ooOol067oo00<007ooOol04Woo00@007ooOol0
01Qoo`03001oogoo01Ioo`03001oogoo01Uoo`03001oogoo015oo`003Goo10001Goo00<007ooOol0
3goo100017oo00<007ooOol03goo100017oo00<007ooOol04Woo00@007ooOol001Qoo`03001oogoo
01Moo`03001oogoo01Uoo`03001oogoo011oo`004goo00@007ooOol001Moo`04001oogoo000HOol0
0`00Oomoo`0BOol01000Oomoo`0067oo00<007ooOol05Goo00@007ooOol001Moo`04001oogoo000B
Ool001Aoo`8001Uoo`8001Qoo`8001Eoo`8001Qoo`8001Qoo`8001Uoo`8001=oo`00a7oo0034Ool0
0<Aoo`00a7oo000?OonV000?Ool000moo`04001oogoo0005Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo00003goo0009Ool20004Ool00`00Oomo
o`1?Ool00`00Oomoo`1@Ool00`00Oomoo`0=Ool000Qoo`04001oogoo0003Ool00`00Oomoo`1?Ool0
0`00Oomoo`1@Ool00`00Oomoo`0=Ool000Yoo`03001oogoo009oo`80039oo`03001oogoo01]oo`03
001oogoo01]oo`03001oogoo035oo`8000moo`000Woo10001Goo00D007ooOomoo`00009ooc80W`80
000g11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l4
7`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l00P00<@2O
17oo00<007ooOol03Goo0008Ool01000Oomoo`000goo00<007ooOol0=02O0P0003<87`@O21l47`PO
11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO
11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l00P00<`2O17oo00<007ooOol03Goo0009Ool2
0004Ool00`00Oomoo`0f09l20000;`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O
21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l00P00
=@2O17oo00<007ooOol03Goo000?Ool00`00Oomoo`0h09l20000:`PO11l87`@O21l47`PO11l87`@O
21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O
21l47`PO008003L0W`Aoo`03001oogoo00eoo`003goo00<007ooOol0>P2O100002<47`PO11l87`@O
21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O
00@003T0W`=oo`8000moo`003goo00<007ooOol0?P2O0P0001l87`@O21l47`PO11l87`@O21l47`PO
11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO11l87`02000m09l4Ool00`00Oomoo`0=
Ool000moo`03001oogoo0400W`@0000G11l87`@O21l47`PO11l87`@O21l47`PO11l87`@O21l47`PO
11l87`@O21l47`04000o09l4Ool00`00Oomoo`0=Ool000moo`03001oogoo04@0WaL004<0W`Aoo`03
001oogoo00eoo`003goo00<007ooOol0WP2O17oo00<007ooOol03Goo000?Ool01000Oomoo`00W@2O
00D007ooOomoo`0000moo`003goo00@007ooOol1W`8009T0W`8000=oo`8000moo`003goo00H007oo
Ool1W`5o0Il2002E09l200000`6O0Gmoo`03Ool00`00Oomoo`0=Ool000moo`03001oogoo00D1W`80
0940W`8000@1W`Aoo`03001oogoo00eoo`003goo00X007ooOol1W`5o0Il1O`6O0Gl1W`8008d0W`80
00060Il1O`6O0Gl1W`5o17oo00<007ooOol03Goo000?Ool00`00Oomoo`090Il2002909l200080Il4
Ool00`00Oomoo`0=Ool000moo`0?001oogoo0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0008L0W`0;0001
W`5o0Il1O`6O0Gl1W`5o0Il1O`03Ool2000?Ool000moo`03001oogoo00`1W`8008<0W`8000/1W`Ao
o`03001oogoo00eoo`003goo014007ooOol1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00800800
W`0>0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`Aoo`03001oogoo00eoo`003goo00<007ooOol0
406O0P00N`2O0`003P6O17oo00<007ooOol03Goo000?Ool05@00Oomoo`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`03001f09l200004@5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl017oo00<007ooOol03Goo000?Ool00`00Oomoo`0E0Il2001b09l2000C0Il3Ool2000?Ool0
00moo`0J001oogoo0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`80
06d0W`<0000E0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00Aoo`03001o
ogoo00eoo`003goo00<007ooOol06@6O0P00J@2O0P00606O17oo00<007ooOol03Goo0008Ool40003
Ool07P00Oomoo`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`<006<0W`<0000J0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`Aoo`03001oogoo00eoo`0027oo00<007ooOol017oo00<007ooOol07P6O0P00G`2O0P00
7@6O17oo00<007ooOol03Goo0009Ool00`00Oomoo`03Ool200008Goo0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`02001K09l200007`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
00=oo`8000moo`000Woo100017oo00<007ooOol00Woo00<007ooOol08P6O0P00E`2O0P008@6O17oo
00<007ooOol03Goo0008Ool01000Oomoo`000goo02L007ooOol1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl01000C`2O1000
02<1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o00Aoo`03001oogoo00eoo`002Goo0P0017oo00<007ooOol0:06O1@00A@2O1@00
9`6O17oo00<007ooOol03Goo000?Ool0<000Oomoo`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`@003d0W`@0000/0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`Aoo`03001oogoo00eoo`003goo
00<007ooOol0<@6O1@00<`2O1@00<06O17oo00<007ooOol03Goo000?Ool0>@00Oomoo`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0c0000=@5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl00goo0P003goo000?Ool00`00Oomoo`2N0Il4
Ool00`00Oomoo`0=Ool000moo`2Q001oogoo0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`04Ool00`00Oomoo`0=Ool0
00moo`03001oogoo09h1W`Aoo`03001oogoo00eoo`003goo0:4007ooOol1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
00Aoo`03001oogoo00eoo`003goo00<007ooOol0WP6O0goo0P003goo000?Ool00`00Oomoo`020000
V`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il00P000goo00<007ooOol03Goo000?Ool00`00Oomoo`020Wl2002G0Il200000`9o
Oomoo`02Ool00`00Oomoo`0=Ool000moo`07001oogoo0Yl2O`:O0Wl0100008l1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00@000030Wl2W`9o00Aoo`03001oogoo00eo
o`003goo00D007ooOol2O`:O00<2O`030Yl2O`9o00<008T1W`<00082O`050Yl2O`9o0Wl2W`04Ool0
0`00Oomoo`0=Ool000moo`0>001oogoo0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`8000250Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl00P0000X2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`=oo`8000moo`003goo00<0
07ooOol00`9o00D2W`9o0Wl2O`:O00<2O`030Yl2O`0000<003P1W`d003P1W`@000030Wl2W`9o0082
O`050Yl2O`9o0Wl2W`020Wl4Ool00`00Oomoo`0=Ool000moo`0D001oogoo0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`D0000Z0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o2@0000d2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`0:0000:P6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`@0000@0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl4Ool00`00Oomoo`0=Ool000moo`05001oogoo0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl0000000800241W`D000030Wl2W`9o
0082O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl2O`9o
00@00241W`D000<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00<2WgooOol00Woo00<0
07ooOol03Goo000?Ool07@00Oomoo`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl01P0001H1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`D0000Y0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`0500005P5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O1P0001T2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`04Ool00`00Oomoo`0=Ool000moo`03001oogoo00<2O`050Yl2O`9o0Wl2
W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`03000?0Il40000
0`9o0Yl2O`020Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl0
1@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`060Yl2O`9o0Wl2W`9o10003`6O0`0000D2W`9o
0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O0082O`=o
o`8000moo`003goo02H007ooOol2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O3`0003/2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O00l0000R0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl4Ool00`00Oomoo`0=
Ool000moo`05001oogoo0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl0
1@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`040Yl2O`9o0Wl=00030Wl01@:O0Wl2O`9o0Yl0
0`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2
O`9o0Wl2W`04Ool00`00Oomoo`0=Ool000moo`18001oogoo0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O10000`=o
00D3W`=o0gl3O`>O00<3O`030il3O`0000<000140Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`Aoo`03001oogoo00eo
o`0027oo1@000Woo00<007ooOol00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O
0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o
00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl200040gl>00030gl300020Wl01@:O0Wl2O`9o
0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o
0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O0082O`Ao
o`03001oogoo00eoo`002Woo00<007ooOol00Woo04@007ooOol2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0P000`=o500000<3
W`=o0gl00P0003l2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl017oo00<007ooOol03Goo000:Ool00`00Oomoo`02Ool200000goo0Wl2
W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2
O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00@2
W`9o00000083OaT000<3O`8000050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2
O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00goo0P003goo0002Ool40004Ool00`00Oomoo`02Ool0@000
Oomoo`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0P0000<3O`>O00006`000`=o03h3W`000002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o17oo00<007ooOol03Goo000:Ool00`00Oomoo`02
Ool00`00Oomoo`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o
0Yl00`9o0P0000<3O`0000007`0010=o0P000P9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`03
0Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o
0Yl00`9o00D2W`9o0Wl2O`:O0082O`Aoo`03001oogoo00eoo`002Goo0P0017oo03/007ooOol2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o
0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o00<00083Ob@00004
0gl3W`=o0gl20000=`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o00Aoo`03001oogoo00eoo`003goo00D007ooOol2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O
0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o
00D2W`9o0Wl2O`:O00<2O`030Yl0000000@3ObH000D3O`8000050Yl2O`9o0Wl2W`030Wl01@:O0Wl2
O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2
W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`04Ool00`00Oomoo`0=Ool000moo`0g001oogoo0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl00P000P=o00<3W`=o0gl0:00000<3
O`>O0gl00P=o03H3W`000002O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl3
Ool2000?Ool000moo`03001oogoo00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2
W`9o0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2
O`030003O`=o00@3ObX000L3O`050002O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2
O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`030Yl2
O`9o00Aoo`03001oogoo00eoo`003goo00<007ooOol0200002T2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O
008000<3O`030il3O`=o02`000030gl3W`=o0083O`0]0il3O`000002W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2
O`:O00P000=oo`03001oogoo00eoo`003goo00<007ooOol020=o100000<2O`:O0Wl00P9o00D2W`9o
0Wl2O`:O00<2O`050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<000L3
Obh000P3O`<000050Yl2O`9o0Wl2W`030Wl01@:O0Wl2O`9o0Yl00`9o00D2W`9o0Wl2O`:O00<2O`05
0Yl2O`9o0Wl2W`030Wl00`:O0Wl0000300070gl4Ool00`00Oomoo`0=Ool000moo`04001oogoo0il3
0gl01@>O0gl3O`=o0il00`=o2P0001H2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2
W`9o0Yl2O`800083O`050il3O`=o0gl3W`030gl^00020gl01@>O0gl3O`=o0il00`=o01X3W`000002
O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o0Yl2O`:O0Wl2W`9o2@0000<3O`>O0gl00P=o
00H3W`=o0gl3O`>O0gl4Ool00`00Oomoo`0=Ool000moo`03001oogoo01H3OaH000/3Oc0000`3OaL0
01@3O`=oo`8000moo`003goo00<007ooOol00P=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`03
0gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o
0il00`=o00D3W`=o0gl3O`>O03400083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3
W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`040il3O`=o0gl4Ool00`00Oomoo`0=Ool000moo`03001oogoo03H3Oc8003H3O`Aoo`03001oogoo
00eoo`003goo00@007ooOol3W`<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`03
0il00000038000<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`030il3Ogoo00=o
o`03001oogoo00eoo`003goo00<007ooOol0=@=o=000=@=o17oo00<007ooOol03Goo000?Ool00`00
Oomoo`020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O
0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl00`>O0gl0000e00001@>O
0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o
00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl010>O0gl3O`=o0goo0P003goo000?Ool00`00
Oomoo`0d0glg000c0gl4Ool00`00Oomoo`0=Ool000moo`04001oogoo0il30gl01@>O0gl3O`=o0il0
0`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3
O`>O00<3O`050il3O`=o0gl3W`030glg00000`=o0il3O`020gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`06
0il3O`=o0gl3W`=o17oo00<007ooOol03Goo000?Ool00`00Oomoo`0c0glh000c0gl4Ool00`00Oomo
o`0=Ool000moo`03001oogoo0083O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o
0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`03
0il0000003H000<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`Aoo`03001oogoo
00eoo`003goo00<007ooOol0<`=o>000<`=o17oo00<007ooOol03Goo000?Ool01000Oomoo`>O0`=o
00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O
00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00P=o>00000<3O`>O0gl00P=o00D3W`=o0gl3
O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3
O`=o0gl3W`030gl01P>O0gl3O`=o0il3O`=oo`8000moo`003goo00<007ooOol0<`=o>@00<P=o17oo
00<007ooOol03Goo000?Ool00`00Oomoo`020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3
W`030gl00`>O0000000g00020gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o
0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl4Ool0
0`00Oomoo`0=Ool000Uoo`8000Aoo`03001oogoo0383OcX00383O`Aoo`03001oogoo00=oo`800003
Ool0000000Eoo`0027oo00@007ooOol000=oo`04001oogoo0il30gl01@>O0gl3O`=o0il00`=o00D3
W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00D3W`=o0gl3O`>O00<3
O`060il3O`=o0gl3W`=o>P0000D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o
0il00`=o00D3W`=o0gl3O`>O00<3O`050il3O`=o0gl3W`030gl01@>O0gl3O`=o0il00`=o00<3W`=o
Ool00goo00<007ooOol017oo00<007oo00001Woo0008Ool01000Oomoo`000gooYP001goo00<007oo
Ool01Goo0008Ool01000Oomoo`000goo00<007ooOol00P?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l
0o/3n`?k0o`00`?k>P000P?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k
0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k17oo00<0
07ooOol00goo0P0000=oo`0000001Goo0008Ool01000Oomoo`000goo00<007ooOol0<P?k>P00<P?k
17oo00<007ooOol03Goo0009Ool20004Ool01000Oomoo`?l0`?k00D3o0?k0o/3n`?l00<3n`050o`3
n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`?k0o`00P?k>@0000D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k
0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00<3o0?k
Ool00goo00<007ooOol03Goo000?Ool00`00Oomoo`0c0o/i000b0o/4Ool00`00Oomoo`0=Ool000mo
o`03001oogoo0083n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`030o`0000003H0
00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`=oo`8000moo`003goo00<007oo
Ool0<`?k>000<`?k17oo00<007ooOol03Goo000?Ool01000Oomoo`?l0`?k00D3o0?k0o/3n`?l00<3
n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3
o0030o/01@?l0o/3n`?k0o`00P?k>00000<3n`?l0o/00P?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01P?l
0o/3n`?k0o`3n`Aoo`03001oogoo00eoo`003goo00<007ooOol0<`?k>000<`?k17oo00<007ooOol0
3Goo000?Ool00`00Oomoo`020o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/00`?l
0o/0000f00030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/4Ool00`00Oomoo`0=
Ool000moo`03001oogoo03@3ncH003@3n`=oo`8000moo`003goo00@007ooOol3o0<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l
0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`030o`0000003<00083n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`0
0`?k00D3o0?k0o/3n`?l00<3n`030o`3ngoo00=oo`03001oogoo00eoo`003goo00<007ooOol0=@?k
=000=@?k17oo00<007ooOol03Goo000?Ool00`00Oomoo`020o/01@?l0o/3n`?k0o`00`?k00D3o0?k
0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`05
0o`3n`?k0o/3o0030o/010?l0o/3n`?k<`0000<3n`?l0o/00P?k00D3o0?k0o/3n`?l00<3n`050o`3
n`?k0o/3o0030o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`050o`3n`?k0o/3o0030o/0
1@?l0o/3n`?k0o`00`?k17oo00<007ooOol03Goo000?Ool00`00Oomoo`0f0o/b000f0o/4Ool00`00
Oomoo`0=Ool000moo`04001oogoo0o`30o/01@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l00<3n`05
0o`3n`?k0o/3o0030o/00`?l0o/3n`0900001@?l0o/3n`?k0o`00`?k00D3o0?k0o/3n`?l0083nc40
00050o`3n`?k0o/3o0030o/01@?l0o/3n`?k0o`00P?k2@0000D3o0?k0o/3n`?l00<3n`050o`3n`?k
0o/3o0030o/01@?l0o/3n`?k0o`00`?k00H3o0?k0o/3n`?l0o/4Ool00`00Oomoo`0=Ool000moo`03
001oogoo0143n`h000050o@3l`?c0o<3m0030o<00`?d00000003000;0o/_000;0o/500001@?d0o<3
l`?c0o@00`?c00<3m0000000300040?k0goo0P003goo000?Ool00`00Oomoo`020o/01@?l0o/3n`?k
0o`00`?k00<3o0?k0o/0100001`3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0@000030o/3o0?k0083n`030o`3n`0002d000050o`3n`?k0o/3o0030o/0
80?l000000000o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<400001@?l0o/3n`?k0o`00`?k00@3o0?k0o/3n`Aoo`03001oogoo00eoo`003goo00<007oo
Ool00`?k2P0000D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3
m0?c0o<3l`?d00<3l`040o@3l`?c0o<200060o//00080o/200020o<01@?d0o<3l`?c0o@00`?c00D3
m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m000000020000P?k
17oo00<007ooOol03Goo000?Ool00`00Oomoo`030000<P?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0000o`30o/00`?l0o/0000Y00001@?l0o/3n`?k0o`00P?k0P0002l3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c00<000=oo`03001oogoo00eoo`003goo00<007ooOol00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d
00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m00000001@?k:0001P?k0P0000D3
m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3
l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0?c0o<017oo00<007ooOol03Goo000?
Ool0>@00Oomoo`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`02
00020o/00`?l0o/0000U00001@?l0o/3n`?k0o`00P0003D3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c00=oo`8000moo`003goo00D007ooOol3l`?d00<3l`050o@3l`?c
0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`040o@3l`?c00040o/T00050o/010000o<3l`?d0`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d
00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m7ooOol00Woo00<007ooOol03Goo
000?Ool0?@00Oomoo`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0000083n`030o`3n`000240000n0o`3n`?k0o/3o0000o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`Aoo`03001oogoo00eoo`0027oo1@000Woo00<0
07ooOol00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3
m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d0083
l`8000<3nb0000@3n`800083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3
l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3
l`?c0o<3m0020o<4Ool00`00Oomoo`0=Ool000Yoo`03001oogoo009oo`0o001oogoo0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c008000030o`3
n`?k01/00083n`030o`3n`?k0080000k0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`04Ool00`00Oomoo`0=Ool000Yoo`03001oogoo009oo`800003
Ool3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`05
0o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m003
0o<00`?d000000030o/H00040o/200001@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3
l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<0
1@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00=oo`8000moo`002Woo00<007ooOol00Woo04<007oo
Ool3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`0200020o/00`?l0o/0000C00020o/0@P?l000000?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`Aoo`03001oogoo00eo
o`002Woo00<007ooOol00Woo00<007ooOol00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m003
0o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c
0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0020o<300040o/>00040o/200020o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d
0083l`Aoo`03001oogoo00eoo`002Goo0P0017oo04P007ooOol3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@80000
1@?k000000000o/02@0004<3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`04Ool00`00Oomoo`0=Ool000moo`05001oogoo
0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d
0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<500030o<01@?d0o<3l`?c0o@00`?c00D3m0?c
0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`05
0o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m003
0o<00`?dOomoo`02Ool00`00Oomoo`0=Ool000moo`0W001oogoo0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0180000c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3
l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0180000S0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`03Ool2
000?Ool000moo`03001oogoo00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c
0o<3l`?d00<3l`030o@3l`?c00H00183k0D000050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c
00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0?c00000`00
4P?/1P000P?c00D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3
m0?c0o<017oo00<007ooOol03Goo000?Ool07P00Oomoo`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0<0000M0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00400008@?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`05000070?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/100001T3l`?d0o<3m0?c
0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`04Ool00`00Oomoo`0=Ool000mo
o`05001oogoo0o<3m0030o<01@?d0o<3l`?c0o@00`?c00D3m0?c0o<3l`?d00<3l`030o@0000000<0
02@3k0D000030o<3m0?c0083l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@00`?c00<3m0?c0000
10009@?/100000D3m0?c0o<3l`?d00<3l`050o@3l`?c0o<3m0030o<01@?d0o<3l`?c0o@017oo00<0
07ooOol03Goo000?Ool05000Oomoo`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@50000
;P?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[100000l3m0?c0o@3l`?d0o<3m0?c0o@3l`?d
0o<3m0?c0o@0100002h3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0D0000@0o@3l`?d0o<3
m0?c0o@3l`?d0o<3m0?c0o@3l`?d0o<4Ool00`00Oomoo`0=Ool000moo`03001oogoo00<3l`050o@3
l`?c0o<3m0030o<00`?d0o<3l`03000g0n`?000g0n`300020o<01@?d0o<3l`?c0o@00`?c00<3m0?c
0o<017oo00<007ooOol03Goo000?Ool03`00Oomoo`?d0o<3m0?c0o@3l`?d0o<3m0?c0o@3l`020000
P`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P0000/3l`?d0o<3m0?c0o@3l`?d0o<3m0?c00=oo`8000mo
o`003goo00D007ooOol3l`?d00<3l`030o@3l`?c00@008L3k0@00083l`050o@3l`?c0o<3m004Ool0
0`00Oomoo`0=Ool000moo`06001oogoo0o@3l`?d1@0008l3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/00D000030o@3lgoo00=oo`03001oogoo00eoo`003goo00<007oo
Ool00`00V@?/0`000goo00<007ooOol03Goo000?Ool0X@00Oomoo`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/017oo
00<007ooOol03Goo000?Ool00`00Oomoo`2N0n`3Ool2000?Ool000moo`2Q001oogoo0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`04Ool00`00Oomoo`0=Ool000moo`03001oogoo09h3k0Aoo`03001oogoo00eoo`003goo
0:4007ooOol3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00Aoo`03001oogoo00eoo`003goo00<007ooOol0>`?/:@00
>P?/17oo00<007ooOol03Goo000?Ool0=@00Oomoo`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/02@00:@?T2@000343j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`03Ool2000?Ool000moo`03001oogoo02d3k0D003/3i0D002`3k0Aoo`03001oogoo00eoo`003goo
02d007ooOol3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/00`00A@?T0`0002T3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[00Aoo`03001oogoo00eoo`0027oo10000goo00<007ooOol0:0?/0P00B`?T0P009`?/17oo
00<007ooOol03Goo0008Ool00`00Oomoo`04Ool0:000Oomoo`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0`00C`?T0`00
02@3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/4Ool00`00Oomoo`0=Ool000Uoo`03001oogoo00=oo`800003Ool3k0?/0243
k08005D3i0800283k0=oo`8000moo`002Woo00<007ooOol00Woo02<007ooOol3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00<005T3i0<0
000O0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/017oo00<007ooOol03Goo0008Ool01000Oomoo`000goo00<007ooOol07P?/0P00G`?T0P00
7@?/17oo00<007ooOol03Goo0009Ool20004Ool07@00Oomoo`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/01000H`?T100001T3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`04Ool00`00Oomoo`0=Ool000moo`03001oogoo
01T3k0030003i0?T06T3i08001L3k0Aoo`03001oogoo00eoo`003goo01X007ooOol3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0P00KP?T01L000?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00=oo`8000moo`003goo00<007ooOol05@?/0P00
L@?T0P0050?/17oo00<007ooOol03Goo000?Ool05P00Oomoo`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0P00M@?T0`000143j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
00Aoo`03001oogoo00eoo`003goo00<007ooOol040?/0`00NP?T0P003`?/17oo00<007ooOol03Goo
000?Ool04@00Oomoo`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/00P00O`?T0P0000d3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`04Ool00`00Oomoo`0=Ool000moo`03001oogoo00d3k0030003i0?T
0843i0030003k0?/00X3k0Aoo`03001oogoo00eoo`003goo00h007ooOol3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0P00Q@?T0P0000X3k0?[0n`3j`?/0n/3k0?[0n`3j`=oo`8000moo`003goo00<007ooOol0
2P?/00<000?T0n@0Q`?T00<000?/0n`01`?/17oo00<007ooOol03Goo000?Ool02P00Oomoo`?/0n/3
k0?[0n`3j`?/0`00R`?T0`0000H3k0?[0n`3j`?/0n/4Ool00`00Oomoo`0=Ool000moo`03001oogoo
00D3k0800943i08000@3k0Aoo`03001oogoo00eoo`003goo00H007ooOol3k0?[0n`2002E0n@20000
0`?/0n]oo`03Ool00`00Oomoo`0=Ool000moo`04001oogoo0n`2002I0n@20003Ool2000?Ool000mo
o`04001oogoo002M0n@01@00Oomoogoo00003goo000?Ool00`00Oomoo`1=0n@5001<0n@4Ool00`00
Oomoo`0=Ool000moo`03001oogoo04@3i0T000051n0;h0OP2n07h00900130n@4Ool00`00Oomoo`0=
Ool000moo`03001oogoo0403i0@0000G1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P
1n0;h0OP2n07h005000n0n@4Ool00`00Oomoo`0=Ool000moo`03001oogoo03d3i0<0000P2n07h0_P
1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0<0
03/3i0=oo`8000moo`003goo00<007ooOol0>`?T0P0002H;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP0P00>@?T17oo
00<007ooOol03Goo000?Ool00`00Oomoo`0g0n@40000:POP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0<0
03H3i0Aoo`03001oogoo00eoo`002Goo0P0017oo00<007ooOol0=@?T0P00034;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h002000d0n@4Ool00`00Oomoo`0=Ool000Qoo`04001oogoo
0003Ool00`00Oomoo`0c0n@20000=@OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP
2n07h0_P1n000P00<P?T17oo00<007ooOol03Goo000:Ool00`00Oomoo`02Ool200000goo0n@3i00_
0n@20000>@_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;h0OP2n07h0_P1n0;
h002000`0n@3Ool2000?Ool000]oo`05001oogooOol0001AOol00`00Oomoo`1@Ool00`00Oomoo`0=
Ool000Qoo`04001oogoo0003Ool00`00Oomoo`1?Ool00`00Oomoo`1@Ool00`00Oomoo`0=Ool000Uo
o`8000Aoo`04001oogoo000JOol00`00Oomoo`0GOol00`00Oomoo`0GOol00`00Oomoo`0GOol00`00
Oomoo`0GOol00`00Oomoo`0HOol01@00Oomoogoo00003goo000?OonV000?Ool00<Aoo`00a7oo0034
Ool00<Aoo`00a7oo0034Ool00<Aoo`00Ggoo0P00Hgoo001POol00`00Oomoo`1QOol0065oo`03001o
ogoo061oo`00H7oo00<007oo0000HGoo001OOol01000Oomoo`00HGoo001NOol300000goo0000001P
Ool00<Aoo`00a7oo0034Ool00<Aoo`00a7oo0034Ool00001\
\>"],
  ImageRangeCache->{{{0, 195.25}, {195.25, 0}} -> {-3.72497, -3.5723, \
0.0381683, 0.0381683}}]
}, Open  ]],

Cell["\<\
In this section, we presented the derivation of Stokes' classical \
solution of the creeping flow around a sphere. Contrary to Stokes, we did not \
guess the solution by an ingenious ansatz. The solution in our calculation \
followed directly from the symmetry analysis of the problem. This example \
illustrates the strength of this method by a straightforward \
calculation.\
\>", "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"Layer.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{645, 668},
WindowMargins->{{94, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->311,
PrintingPageRange->{299, 300},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Stokes' Solution of the Creeping Flow"->{
    Cell[1739, 51, 396, 5, 41, "Subsection",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 60}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Stokes' Solution of the Creeping Flow"]},
  "creeping motion of a fluid"->{
    Cell[2138, 58, 336, 9, 44, "Text",
      CellTags->"creeping motion of a fluid"]},
  "Stokes stream function"->{
    Cell[17624, 569, 577, 17, 61, "Text",
      CellTags->"Stokes stream function"]},
  "Reynolds number"->{
    Cell[18963, 612, 407, 8, 61, "Text",
      CellTags->{
      "Reynolds number", "momentum equation", "stream function", 
        "Laplacian"}]},
  "momentum equation"->{
    Cell[18963, 612, 407, 8, 61, "Text",
      CellTags->{
      "Reynolds number", "momentum equation", "stream function", 
        "Laplacian"}]},
  "stream function"->{
    Cell[18963, 612, 407, 8, 61, "Text",
      CellTags->{
      "Reynolds number", "momentum equation", "stream function", 
        "Laplacian"}],
    Cell[35741, 1095, 103, 1, 27, "Text",
      CellTags->"stream function"]},
  "Laplacian"->{
    Cell[18963, 612, 407, 8, 61, "Text",
      CellTags->{
      "Reynolds number", "momentum equation", "stream function", 
        "Laplacian"}]},
  "fourth-order linear PDE"->{
    Cell[23347, 723, 591, 13, 80, "Text",
      CellTags->"fourth-order linear PDE"]},
  "LieEquations[]"->{
    Cell[23941, 738, 395, 8, 87, "Input",
      CellTags->"LieEquations[]"]},
  "Lie point symmetries"->{
    Cell[24339, 748, 149, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"Lie point symmetries"]},
  "Stokes' model"->{
    Cell[27899, 849, 1656, 46, 156, "Text",
      CellTags->{
      "Stokes' model", "finite group", "scaling symmetry", 
        "LieReduction[]"}]},
  "finite group"->{
    Cell[27899, 849, 1656, 46, 156, "Text",
      CellTags->{
      "Stokes' model", "finite group", "scaling symmetry", 
        "LieReduction[]"}]},
  "scaling symmetry"->{
    Cell[27899, 849, 1656, 46, 156, "Text",
      CellTags->{
      "Stokes' model", "finite group", "scaling symmetry", 
        "LieReduction[]"}]},
  "LieReduction[]"->{
    Cell[27899, 849, 1656, 46, 156, "Text",
      CellTags->{
      "Stokes' model", "finite group", "scaling symmetry", "LieReduction[]"}],
    
    Cell[33305, 998, 593, 17, 65, "Text",
      CellTags->{"DSolve[]", "LieReduction[]"}]},
  "similarity solution"->{
    Cell[31864, 957, 271, 9, 27, "Text",
      CellTags->"similarity solution"]},
  "DSolve[]"->{
    Cell[33305, 998, 593, 17, 65, "Text",
      CellTags->{"DSolve[]", "LieReduction[]"}]},
  "determining equation"->{
    Cell[34106, 1026, 210, 6, 27, "Text",
      CellTags->"determining equation"]},
  "boundary condition"->{
    Cell[36053, 1108, 361, 8, 61, "Text",
      CellTags->"boundary condition"]},
  "non-slip condition"->{
    Cell[36942, 1139, 232, 7, 44, "Text",
      CellTags->"non-slip condition"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Stokes' Solution of the Creeping Flow", 290393, 10985},
  {"creeping motion of a fluid", 290771, 10992},
  {"Stokes stream function", 290888, 10995},
  {"Reynolds number", 290997, 10998},
  {"momentum equation", 291171, 11003},
  {"stream function", 291343, 11008},
  {"Laplacian", 291587, 11015},
  {"fourth-order linear PDE", 291767, 11020},
  {"LieEquations[]", 291876, 11023},
  {"Lie point symmetries", 291982, 11026},
  {"Stokes' model", 292112, 11030},
  {"finite group", 292283, 11035},
  {"scaling symmetry", 292458, 11040},
  {"LieReduction[]", 292631, 11045},
  {"similarity solution", 292896, 11052},
  {"DSolve[]", 292994, 11055},
  {"determining equation", 293114, 11058},
  {"boundary condition", 293224, 11061},
  {"non-slip condition", 293332, 11064}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 396, 5, 41, "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 60}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Stokes' Solution of the Creeping Flow"],
Cell[2138, 58, 336, 9, 44, "Text",
  CellTags->"creeping motion of a fluid"],
Cell[2477, 69, 15144, 498, 184, 10187, 423, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[17624, 569, 577, 17, 61, "Text",
  CellTags->"Stokes stream function"],

Cell[CellGroupData[{
Cell[18226, 590, 382, 9, 67, "Input"],
Cell[18611, 601, 337, 8, 36, "Output"]
}, Open  ]],
Cell[18963, 612, 407, 8, 61, "Text",
  CellTags->{
  "Reynolds number", "momentum equation", "stream function", "Laplacian"}],
Cell[19373, 622, 184, 3, 34, "Input"],
Cell[19560, 627, 148, 3, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19733, 634, 114, 2, 23, "Input"],
Cell[19850, 638, 3482, 82, 124, "Output"]
}, Open  ]],
Cell[23347, 723, 591, 13, 80, "Text",
  CellTags->"fourth-order linear PDE"],
Cell[23941, 738, 395, 8, 87, "Input",
  CellTags->"LieEquations[]"],
Cell[24339, 748, 149, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"Lie point symmetries"],

Cell[CellGroupData[{
Cell[24513, 757, 66, 1, 23, "Input"],
Cell[24582, 760, 3302, 86, 92, "Output"]
}, Open  ]],
Cell[27899, 849, 1656, 46, 156, "Text",
  CellTags->{
  "Stokes' model", "finite group", "scaling symmetry", "LieReduction[]"}],

Cell[CellGroupData[{
Cell[29580, 899, 208, 4, 39, "Input"],
Cell[29791, 905, 1565, 32, 82, "Output"]
}, Open  ]],
Cell[31371, 940, 209, 3, 44, "Text"],

Cell[CellGroupData[{
Cell[31605, 947, 129, 3, 23, "Input"],
Cell[31737, 952, 112, 2, 23, "Output"]
}, Open  ]],
Cell[31864, 957, 271, 9, 27, "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[32160, 970, 114, 2, 34, "Input"],
Cell[32277, 974, 1013, 21, 54, "Output"]
}, Open  ]],
Cell[33305, 998, 593, 17, 65, "Text",
  CellTags->{"DSolve[]", "LieReduction[]"}],

Cell[CellGroupData[{
Cell[33923, 1019, 85, 1, 23, "Input"],
Cell[34011, 1022, 80, 1, 23, "Output"]
}, Open  ]],
Cell[34106, 1026, 210, 6, 27, "Text",
  CellTags->"determining equation"],

Cell[CellGroupData[{
Cell[34341, 1036, 60, 1, 23, "Input"],
Cell[34404, 1039, 135, 2, 23, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34576, 1046, 61, 1, 38, "Input"],
Cell[34640, 1049, 109, 2, 23, "Output"]
}, Open  ]],
Cell[34764, 1054, 118, 2, 27, "Text"],

Cell[CellGroupData[{
Cell[34907, 1060, 71, 1, 23, "Input"],
Cell[34981, 1063, 136, 2, 23, "Output"]
}, Open  ]],
Cell[35132, 1068, 91, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[35248, 1075, 70, 1, 23, "Input"],
Cell[35321, 1078, 55, 1, 34, "Output"]
}, Open  ]],
Cell[35391, 1082, 147, 2, 27, "Text"],

Cell[CellGroupData[{
Cell[35563, 1088, 83, 1, 23, "Input"],
Cell[35649, 1091, 77, 1, 34, "Output"]
}, Open  ]],
Cell[35741, 1095, 103, 1, 27, "Text",
  CellTags->"stream function"],

Cell[CellGroupData[{
Cell[35869, 1100, 62, 1, 23, "Input"],
Cell[35934, 1103, 104, 2, 34, "Output"]
}, Open  ]],
Cell[36053, 1108, 361, 8, 61, "Text",
  CellTags->"boundary condition"],

Cell[CellGroupData[{
Cell[36439, 1120, 89, 1, 23, "Input"],
Cell[36531, 1123, 127, 2, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36695, 1130, 99, 2, 23, "Input"],
Cell[36797, 1134, 130, 2, 34, "Output"]
}, Open  ]],
Cell[36942, 1139, 232, 7, 44, "Text",
  CellTags->"non-slip condition"],

Cell[CellGroupData[{
Cell[37199, 1150, 93, 1, 23, "Input"],
Cell[37295, 1153, 133, 3, 22, "Message"],
Cell[37431, 1158, 151, 2, 34, "Output"]
}, Open  ]],
Cell[37597, 1163, 73, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[37695, 1167, 136, 3, 23, "Input"],
Cell[37834, 1172, 238, 5, 34, "Output"]
}, Open  ]],
Cell[38087, 1180, 558, 19, 46, "Text"],

Cell[CellGroupData[{
Cell[38670, 1203, 69, 1, 23, "Input"],
Cell[38742, 1206, 391, 11, 44, "Output"]
}, Open  ]],
Cell[39148, 1220, 508, 19, 48, "Text"],

Cell[CellGroupData[{
Cell[39681, 1243, 89, 1, 34, "Input"],
Cell[39773, 1246, 102, 2, 36, "Output"]
}, Open  ]],
Cell[39890, 1251, 78, 0, 27, "Text"],
Cell[39971, 1253, 166, 3, 36, "Input"],
Cell[40140, 1258, 202, 4, 44, "Text"],

Cell[CellGroupData[{
Cell[40367, 1266, 115, 2, 29, "Input"],
Cell[40485, 1270, 97, 2, 26, "Output"]
}, Open  ]],
Cell[40597, 1275, 198, 8, 27, "Text"],

Cell[CellGroupData[{
Cell[40820, 1287, 129, 3, 23, "Input"],
Cell[40952, 1292, 112, 2, 23, "Output"]
}, Open  ]],
Cell[41079, 1297, 207, 8, 27, "Text"],

Cell[CellGroupData[{
Cell[41311, 1309, 424, 7, 71, "Input"],
Cell[41738, 1318, 94654, 4194, 213, 52688, 3671, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[136407, 5515, 189, 4, 44, "Text"],
Cell[136599, 5521, 93, 3, 27, "Text"],
Cell[136695, 5526, 159, 3, 36, "Input"],
Cell[136857, 5531, 163, 3, 36, "Input"],
Cell[137023, 5536, 117, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[137165, 5543, 73, 1, 23, "Input"],
Cell[137241, 5546, 166, 2, 48, "Output"]
}, Open  ]],
Cell[137422, 5551, 217, 6, 44, "Text"],

Cell[CellGroupData[{
Cell[137664, 5561, 446, 8, 71, "Input"],
Cell[138113, 5571, 78484, 2476, 206, 24917, 1810, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[216612, 8050, 106, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[216743, 8057, 74, 1, 23, "Input"],
Cell[216820, 8060, 161, 2, 48, "Output"]
}, Open  ]],
Cell[216996, 8065, 152, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[217173, 8074, 472, 9, 71, "Input",
  PageBreakWithin->False],
Cell[217648, 8085, 70461, 2835, 208, 33796, 2378, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[288124, 10923, 400, 7, 78, "Text"],
Cell[288527, 10932, 145, 3, 35, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

