(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    328438,       9115]*)
(*NotebookOutlinePosition[    361064,       9910]*)
(*  CellTagsIndexPosition[    356243,       9796]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["6", "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  AspectRatioFixed->True,
  CellTags->"Non-classical method"],

Cell["\<\
Non-classical Symmetries of Partial
Differential Equations\
\>", "Title",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  "6.",
  CounterBox["Section"],
  ".",
  " Introduction"
}], "Section",
  CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],

Cell[TextData[{
  "The non-classical method of symmetry analysis is an extension of Lie's \
classical method. This non-classical method was compiled by ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  " in connection with the analysis of the heat equation. This method allows \
us to derive another type of solutions which are different from solutions \
derived from Lie's procedure. The method extends the classical approach to \
find solutions for linear and non-linear PDEs. This chapter contains the \
theoretical background of the method and demonstrates the application to \
different problems."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "non-classical method", "symmetry analysis", "Lie's classical method"}],

Cell[TextData[{
  "Based on a side condition, ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  " introduced the non-classical method. They discussed the diffusion \
equation as an example. The result of their considerations was that \
completely different solutions for the heat equation occur. A \
group-theoretical explanation of this result was given by ",
  ButtonBox["Olver [1986] ",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  "and ",
  ButtonBox["Levi and Winternitz [1989]",
    ButtonData:>{"Literat.nb", "Levi-89"},
    ButtonStyle->"Hyperlink"],
  ". The non-classical method was extended to ",
  StyleBox["weak symmetries",
    FontSlant->"Italic"],
  " and ",
  StyleBox["side conditions ",
    FontSlant->"Italic"],
  "by",
  StyleBox[" ",
    FontSlant->"Italic"],
  ButtonBox["Olver and Rosenau [1986]",
    ButtonData:>{"Literat.nb", "Olve-86R"},
    ButtonStyle->"Hyperlink"],
  StyleBox[".",
    FontSlant->"Italic"],
  " The difference between weak symmetries and symmetries is defined as \
follows."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "non-classical method", "diffusion equation", "heat equation", 
    "weak symmetries"}],

Cell["Definition: Symmetry of a PDE", "Definition",
  CellTags->"Definition: Symmetry of a PDE"],

Cell[TextData[{
  "A symmetry group \[GothicCapitalG] of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " is a local transformation with the following properties:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"local transformation"],

Cell[TextData[{
  "The elements of \[GothicCapitalG] transform solutions of ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalDelta] = 0\ \)\)]],
  " into new solutions of this equation."
}], "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The solutions of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " invariant under \[GothicCapitalG] follow from a system of PDEs containing \
a reduced set of independent variables. \[EmptyCircle]"
}], "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The above definition rephrases the invariance conditions of C",
  ButtonBox["hapter 5",
    ButtonData:>{"symmet5.nb", 
      "Point Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " in different words. A weak symmetry, on the other hand, is a symmetry \
which satisfies the second condition of the definition but does not satisfy \
the first one. Thus, a weak symmetry transformation does not allow that new \
solutions of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " follow from known solutions. The second condition expand the class of \
solutions for a PDE. In the following, we will show that this freedom of a \
symmetry definition is capable to deliver a new kind of solution."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"weak symmetry"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.",
  CounterBox["Section"],
  ".",
  " Mathematical Background of the Non-classical Method"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Mathematical background of the non-classical method"],

Cell["\<\
In this section, we are looking for solutions of the general \
equation\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalDelta](x, u\_\((k)\))\  = \ 0\)], 
  "NumberedEquation"],

Cell[TextData[{
  "under a side condition. Contrary to the classical method of Lie, we are \
seeking solutions under the condition that the invariant surface condition \
vanishes. As we know, the solution for the function ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " invariant under a point transformation is based on the characteristic \
equations"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "invariant surface condition", "point transformation", 
    "characteristic equations"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          SubscriptBox[
            StyleBox["dx",
              FontSlant->"Italic"], "1"], \(\[Xi]\_1\)], "=", " ", 
        RowBox[{
          FractionBox[
            SubscriptBox[
              StyleBox["dx",
                FontSlant->"Italic"], "2"], \(\[Xi]\_2\)], "=", " ", 
          RowBox[{"\[CenterEllipsis]", "=", " ", 
            RowBox[{
              FractionBox[
                SubscriptBox[
                  StyleBox["dx",
                    FontSlant->"Italic"], "n"], \(\[Xi]\_n\)], "=", 
              RowBox[{
                FractionBox[
                  SuperscriptBox[
                    StyleBox["du",
                      FontSlant->"Italic"], "1"], \(\[Phi]\_1\)], "=", 
                RowBox[{
                  FractionBox[
                    SuperscriptBox[
                      StyleBox["du",
                        FontSlant->"Italic"], "2"], \(\[Phi]\_2\)], "=", 
                  RowBox[{"\[CenterEllipsis]", "=", 
                    FractionBox[
                      SuperscriptBox[
                        StyleBox["du",
                          FontSlant->"Italic"], "m"], 
                      \(\[Phi]\_m\)]}]}]}]}]}]}], "."}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "Equivalently, relation (6.2) can be formulated in connection with the \
vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " by using the infinitesimals as"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(\[Sum]\+\(i = 1\)\%n\( \[Xi]\_i\) u\_i\%\[Alpha] - 
            \[Phi]\_\[Alpha]\  = \ 0\), " ", ",", "     ", 
        FormBox[\(\[Alpha] = 1, \[Ellipsis], \ \(m . \)\),
          "TraditionalForm"]}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "This equation (6.3) is abbreviated with ",
  Cell[BoxData[
      \(TraditionalForm\`\(Q\_\[Alpha]\)(x, u\_\((1)\))\  = \ 0\)]],
  " by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ". A solution of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\  = \ 0\)]],
  " invariant under the transformation given by ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " satisfies the system of PDEs"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(\[CapitalDelta](x, u\_\((k)\)\),
              "TraditionalForm"], ")"}], " ", "=", " ", "0"}], ","}], 
      TraditionalForm]], "NumberedEquation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{\(Q\_\[Alpha]\), "(", 
            RowBox[{"x", ",", " ", 
              RowBox[{
                FormBox[\(\(u\_\((1)\))\)\ \),
                  "TraditionalForm"], "=", " ", "0."}]}]}],
          "TraditionalForm"], "   "}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "So far, we recalled the properties of the classical method by Lie. The \
non-classical method of Bluman and Cole now considers condition (6.5) as an \
additional side condition for the solution of the original equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\  = 0\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"classical method", "non-classical method"}],

Cell[TextData[{
  "In a non-classical symmetry analysis of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  ", we are not only interested in the symmetries of the PDE but also in the \
symmetries of the PDE extended by the characteristic equation (6.5). The \
solutions of the non-classical method will generate a weak symmetry in the  \
sense discussed in ",
  ButtonBox["Section 6.1",
    ButtonData:>"Introduction",
    ButtonStyle->"Hyperlink"],
  ". At the other hand, it is certain that the vector fields of the \
non-classical method do not need to form a Lie algebra. Hence, there can be a \
wider class of similarity solutions than in the classical case."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}],

Cell[TextData[{
  "An essential observation by ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  " is that an invariant solution ",
  Cell[BoxData[
      \(TraditionalForm\`u(x)\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " does not only solve the PDE itself but also the invariant surface \
condition or characteristic equation:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "invariant solution", "invariant surface condition", 
    "characteristic equation"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(Q\_\[Alpha]\  = \ 0\), ",", "       ", 
        FormBox[\(\[Alpha]\  = \ 1, \[Ellipsis], \ \ \(q . \)\),
          "TraditionalForm"]}], TraditionalForm]], "NumberedEquation"],

Cell["\<\
Thus, the invariance condition of the classical method is extended \
by this  additional condition:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(pr\^\((k)\)\) v\&\[RightVector]\ \[CapitalDelta]\ 
      \[VerticalSeparator]\_\(\[CapitalDelta] = \(0\nQ\_\[Alpha] = 0\)\)\ 
      \( = \ 0\), \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(pr\^\((1)\)\) v\&\[RightVector]\ Q\_\[Alpha]\ 
      \( \[VerticalSeparator] 
          \_\(\[CapitalDelta] = \(0\nQ\_\[Alpha] = 0\)\)\)\ \( = \ 0. \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "Equation (6.8) does not establish any additional restriction in the \
derivation of the determining equation since it is satisfied identically. The \
main difference compared with Lie's method is that not only one side \
condition occurs but also the characteristics must vanish. This second side \
condition has the consequence that the derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " are strongly coupled. The tight coupling of the derivatives results into \
a non-linear system of determining equations for the infinitesimals. This \
fact is the main difference between the classical and non-classical method. \
However, the non-linearity in the determining equations is a real problem in \
connection with symbolic calculations."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "characteristics", "Lie's method", 
    "nonlinear system of determining equations", "determining equations", 
    "infinitesimals", "nonlinear determining equations"}],

Cell["\<\
The above theoretical considerations can be cast into a more \
suitable formulation for computer calculation. The following discussion shows \
how the prolongation formulation can be rewritten in terms of the \
Fr\[EAcute]chet formalism. We know from above that the non-classical method \
applies the classical Lie method to the extended system of equations\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "prolongation formulation", "Fr\[EAcute]chet formalism", 
    "non-classical method"}],

Cell[BoxData[
    \(TraditionalForm\`\(\(\[CapitalDelta]\^i\)(x, u\_\((k)\))\  = \ 0, 
    \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`\(Q\_\[Alpha] = 0, \)\)], "NumberedEquation"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`i = 1, 2, \ \[Ellipsis], m\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 1, 2, \[Ellipsis], m\)]],
  ". The invariance condition expressed by the Fr\[EAcute]chet derivative \
reads"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"invariance condition", "Fr\[EAcute]chet derivative"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \((\(\[GothicCapitalD]\_\[CapitalDelta]\)(Q)\  + \ \ 
              \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ D\_i\ \[CapitalDelta])\), 
          SubscriptBox["\[VerticalSeparator]", 
            RowBox[{"  ", 
              RowBox[{
              \(Q\_\[Alpha] = \ 
                  \(\[Phi]\_\[Alpha] - 
                      \[Sum]\+\(i = 1\)\%p\( \[Xi]\_i\) u\_i\%\[Alpha] = 0
                    \)\), "\n", " ", 
                RowBox[{
                  StyleBox[\(\[CapitalDelta]\ \),
                    FontSize->11], "=", " ", "0"}]}]}]]}], "=", "0."}], 
      TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "Equation (6.11) is quite similar to the ",
  ButtonBox["invariance condition for point symmetries",
    ButtonData:>{"symmet5.nb", "Invariance condition for point symmetry"},
    ButtonStyle->"Hyperlink"],
  ". The difference is that in the present case the characteristics have to \
vanish. The added surface condition can be annotated as a side condition or \
as a conditional equation that introduces new dependencies for the \
derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". These relations have to be taken into consideration during the \
calculations. The side condition ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha] = 0\)]],
  " introduces a relation representing a strong connection between the \
derivatives of the dependent variables. This relationship has to be \
considered in the elimination of derivatives in the prolongation formula. \
Equation (6.11) contains all the necessary steps to calculate the determining \
equations in a nutshell. Let us summarize the algorithm in the following \
steps:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"algorithm for the non-classical method"],

Cell[TextData[{
  "Calculate the prolongation of the equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " as discussed for classical point symmetries."
}], "ListItem",
  CellDingbat->"1.",
  CellTags->{"non-classical algorithm", "prolongation"}],

Cell["Apply the side conditions to the prolongation formula.", "ListItem",
  CellDingbat->"2.",
  CellTags->{"side conditions", "prolongation formula"}],

Cell["\<\
Extract the determining equations as discussed for the classical \
method.\
\>", "ListItem",
  CellDingbat->"3.",
  CellTags->"determining equations"],

Cell[TextData[{
  "These three steps are the essentials of the non-classical method. Contrary \
to the classical method, we have as side conditions not only the equations ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " but also the condition of the vanishing characteristics and the \
differential consequences of this relation. The main difficulty of this \
algorithm is contained in the second step. Since the characteristic equation \
is satisfied identically, we can apply this side condition either to the \
original equation itself or to the prolongation. Both procedures are \
discussed in the literature. The method by ",
  ButtonBox["Levi and Winternitz [1989]",
    ButtonData:>{"Literat.nb", "Levi-89"},
    ButtonStyle->"Hyperlink"],
  " prefers the elimination of the side conditions after the calculation of \
the prolongation. ",
  ButtonBox["Clarkson and Mansfield [1994]",
    ButtonData:>{"Literat.nb", "Clar-94"},
    ButtonStyle->"Hyperlink"],
  " eliminate the terms of the characteristics before the prolongation is \
calculated. The algorithm implemented in ",
  StyleBox["MathLie ",
    FontSlant->"Italic"],
  "follow the considerations of Clarkson and Mansfield."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"non-classical method", "side condition"}],

Cell["\<\
The kind of problems occurring during a non-classical calculation \
are demonstrated by the following example. Let us consider the characteristic \
equation in 2+1 dimensions. The characteristic equation for this case reads\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"characteristic equation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_x\ \(\(\[Xi]\_1\)(x, t, u)\)\  + \ 
        u\_t\ \(\(\[Xi]\_2\)(x, t, u)\)\  - \ \[Phi](x, t, u)\  = 0. \)], 
  "NumberedEquation"],

Cell[TextData[{
  "Let us assume that we are looking for a substitution replacing the ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t\)]],
  " term. The resulting expression from (6.12) is given by"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm
    \`u\_t\  \[Rule] \[Phi]\  - \ \(u\_x\) \(\[Xi]\_1 . \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "We replaced the ratios of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]/\[Xi]\_2\)]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\[Xi]\_1\),
            "TraditionalForm"], "/", \(\[Xi]\_2\)}], TraditionalForm]]],
  " simply by \[Phi] and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", respectively. This substitution corresponds to a formal coordinate \
transformation assuming that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2 = 1\)]],
  ". The derived substitution rules from (6.13) are up to second order given \
by"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"formal coordinate transformation"],

Cell[BoxData[
    \(TraditionalForm\`\(u\_t \[Rule] \ \[Phi]\  - \(u\_x\) \[Xi]\_1, \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_xt \[Rule] \ 
      \[Phi]\_x + \(u\_x\)(\[Phi]\_u - \[Xi]\_\(1  x\))\  - \ 
        u\_x\%2\ \[Xi]\_\(1  u\) - \(u\_xx\) \[Xi]\_1, \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_tt \[Rule] \ 
      \[Phi]\_t\  + \ \(u\_t\) \[Phi]\_u\  - 
        \(u\_x\)(\[Xi]\_\(1  t\) + \ \(u\_t\) \[Xi]\_\(1  u\))\  - 
        \(u\_xt\) \(\[Xi]\_1 . \)\)], "NumberedEquation"],

Cell[TextData[{
  "The last of these relations (6.16) contains terms of ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(x, t\)\)]],
  " which have to be replaced by the first two rules (6.14) and (6.15), \
respectively. Thus, relation (6.16) is only expressible if the preceding \
substitutions were calculated first. If not, relation (6.16) contains \
redundant information which affects the invariant condition (6.11). Thus, one \
has to keep the following suggestions in mind if one solves the side \
conditions ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha] = 0\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"redundant information"],

Cell[TextData[{
  "The derivatives for which the side condition ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha] = 0\)]],
  " is solved should occur in the original equation in a simple form. This \
guarantees that the original equation stays simple after the substitution of \
the side conditions and thus saves a lot of computing time."
}], "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "If we have more than one dependent variable, we should solve the \
characteristic equation with respect to a derivative occurring in all side \
conditions. This allows the introduction of the relation ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i = 1\)]],
  " for a specific independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  "."
}], "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The substitutions derived in the above example indicate that the \
determining equations are non-linear functions in the infinitesimals. This \
change from a linear system of determining equations in the case of the \
classical method to a system of non-linear determining equations for the \
non-classical method bears very complicated problems. The problem of solving \
the non-linear determining equations is currently not disclosed. Thus, we \
cannot automatically find solutions for the infinitesimals in all cases with \
",
  StyleBox["MathLie.",
    FontSlant->"Italic"],
  " At the moment, we use an interactive and a pseudo-automatic method to \
derive the solutions from the determining equations. The following examples \
will demonstrate how we can find non-classical symmetries by applying the \
functions of ",
  StyleBox["MathLie.",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "nonlinear determining equations", "classical method", 
    "non-classical method", "non-classical symmetries"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.",
  CounterBox["Section"],
  ".",
  " Applications of the Non-classical Method"
}], "Section",
  CellTags->"Applications of the non-classical method"],

Cell[TextData[{
  "The non-classical method has been applied to various PDEs. New classes of \
solutions which cannot be obtained by the classical method have been found \
for the heat equation by ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  ", the Boussinesq equation by ",
  ButtonBox["Levi and Winternitz [1989]",
    ButtonData:>{"Literat.nb", "Levi-89"},
    ButtonStyle->"Hyperlink"],
  ", the Burgers equation by ",
  ButtonBox["Pucci [1992],",
    ButtonData:>{"Literat.nb", "Puci-92"},
    ButtonStyle->"Hyperlink"],
  " and the Fitzhugh Nagumo equation by ",
  ButtonBox["Nucci and Clarkson [1992]",
    ButtonData:>{"Literat.nb", "Nuci-92"},
    ButtonStyle->"Hyperlink"],
  ". We will demonstrate in this section how the functions of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " can be exerted to derive the determining equations. In addition, we will \
solve the determining equations interactively and automatically."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "heat equation", "Boussinesq equation", "Burgers equation", 
    "Fitzhugh Nagumo equation"}],

Cell[CellGroupData[{

Cell["6.3.1 The Heat Equation", "Subsection",
  CellTags->"The heat equation"],

Cell[TextData[{
  "Let us start with the well-studied heat equation by ",
  ButtonBox["Bluman and Cole [1969]",
    ButtonData:>{"Literat.nb", "Blum-69"},
    ButtonStyle->"Hyperlink"],
  ". The scaled heat equation in (1+1) dimensions reads"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"heat equation"],

Cell[BoxData[
    \(TraditionalForm\`\(\(u\_t - u\_\(x, x\) = 0, \)\ \)\)], 
  "NumberedEquation",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is the field describing the variation of a scaled temperature in a pipe, \
for example. The heat equation is one of the rare examples which allows the \
study of different solution procedures. In S",
  ButtonBox["ection 5.6.1",
    ButtonData:>{"symmet51.nb", "The diffusion equation"},
    ButtonStyle->"Hyperlink"],
  ", we examined the heat equation with the classical method of Lie. The \
result was a six-dimensional discrete symmetry group in connection with an \
infinite dimensional group. Here, we will examine the heat equation again by \
using the non-classical method. The determining equations are derived with \
the help of ",
  StyleBox["Lie[]", "MmaText"],
  " in connection with two options of the function. The equation of motion in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is created by"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "temperature", "non-classical method and heat equation", "Lie[]"}],

Cell[BoxData[
    \(\(U\  = \ u[x, t]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(diffus\  = \ {\[PartialD]\_t U - \[PartialD]\_\(x, x\)U\ }; 
    diffus // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We first extend our database by a file containing the information on the \
equation. The left-hand side of the heat equation (6.17) is stored to the \
file ",
  StyleBox["ncdiffu.dgl", "MmaText",
    FontSlant->"Italic"],
  " by applying ",
  StyleBox["LieEquations[]:", "MmaText"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"LieEquations[]"],

Cell[BoxData[
    \(LieEquations["\<ncdiffu.dgl\>", diffus, {u}, {x, t}, {}, 
      \n{"\<Heat equation\>"}, {{"\<G. Baumann\>"}, {"\<Ulm 1997\>"}}]\)], 
  "Input"],

Cell[TextData[{
  "The file ",
  StyleBox["ncdiffu.dgl",
    FontSlant->"Italic"],
  " contains all the necessary information to start the analysis. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The information in the file is contained in global variables. The variable \
",
  StyleBox["Title", "MmaText",
    FontSlant->"Italic"],
  StyleBox[",", "MmaText"],
  " for example, contains a headline describing the purpose of the equation. \
The variable ",
  StyleBox["Source", "MmaText",
    FontSlant->"Italic"],
  " carries, in sublists, information on the origin of the equation. The \
remaining variables such as ",
  StyleBox["IndepVar", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["DependVar", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["EqList", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["SubsList", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["ParameterS", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["ListXi", "MmaText",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["ListPhi", "MmaText",
    FontSlant->"Italic"],
  " contain information on the independent and dependent variables, the \
equation of motion, the terms for which the side condition in the classical \
method is solved, a list of parameters, and two lists for the infinitesimals, \
respectively. All information contained in the file is necessary for the \
function ",
  StyleBox["Lie[]", "MmaText"],
  " to carry out a symmetry analysis. The non-classical symmetry method is \
initiated by using ",
  StyleBox["Lie[]", "MmaText"],
  " in connection with the option ",
  StyleBox["NonclassicalSymmetries\[Rule]True", "MmaText",
    FontSlant->"Italic"],
  ". The option ",
  StyleBox["NonclassicalCases\[Rule]{t}", "MmaText",
    FontSlant->"Italic"],
  " of ",
  StyleBox["Lie[] ", "MmaText"],
  "selects those terms of the characteristic equations which contain a \
derivative with respect to the specified variable, here ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", meaning that all higher derivatives containing a partial derivative with \
respect to ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " are used to match and eliminate the terms in the original equation. We \
start the non-classical symmetry analysis for the heat equation by"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "non-classical symmetry method", "NonclassicalSymmetries", 
    "NonclassicalCases", "characteristic equations", 
    "non-classical symmetry analysis"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lie["\<ncdiffu.dgl\>", NonclassicalSymmetries \[Rule] True, \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ NonclassicalCases \[Rule] {t}] // 
      LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u\) == 0\)},
          {
            \(\[Phi]\_1\ \((\[Xi]\_2)\)\_u + \[Xi]\_1\ \((\[Xi]\_2)\)\_x + 
                \[Xi]\_2\ \((\[Xi]\_2)\)\_\(x, x\) == 0\)},
          {
            \(\(-\[Xi]\_2\%2\)\ \((\[Xi]\_1)\)\_t + 
                2\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_2)\)\_t + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\%2\ \((\[Xi]\_2)\)\_x + 
                \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-2\)\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_2)\)\_t + 
                \[Phi]\_1\%2\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_x - 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_t + 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {
            \(2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_2\ \((\[Xi]\_1)\)\_\(x, u\) + 
                \[Xi]\_2\ \((\[Phi]\_1)\)\_\(u, u\) == 0\)}
          },
        RowSpacings->2,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a non-linear coupled system of nine partial differential \
equations determining the non-classical symmetries of the heat equation. Our \
task is to solve the determining equations. If we have information on the \
structure of the infinitesimals, we can incorporate this information into the \
database file ",
  StyleBox["ncdiffu.dgl", "MmaText",
    FontSlant->"Italic"],
  ". The extension of the file will simplify the determining equations in the \
solution procedure. Let us first store the following relations into ",
  StyleBox["ncdiffu.dgl", "MmaText",
    FontSlant->"Italic"],
  StyleBox[":", "MmaText"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "nonlinear coupled system of partial differential equations", 
    "non-classical symmetries", "infinitesimals"}],

Cell[BoxData[
    \(ListXi\  = \ {\(xi[1]\)[x, t, u[x, t]], 1}; \n
    ListPhi\  = \ {\(phi[1]\)[x, t, u[x, t]]}; \)], "Input"],

Cell[BoxData[
    \(\(Save["\<ncdiffu.dgl\>", ListXi, ListPhi]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Save[] ", "MmaText"],
  "appends the two relations on the infinitesimals to the file ",
  StyleBox["ncdiffu.dgl", "MmaText",
    FontSlant->"Italic"],
  ". The gathered information can now be used to simplify the determining \
equations by starting the analysis a second time. Since we provided the \
database file with new information, we can activate this information by \
setting the option ",
  StyleBox["NonclassicalInfo\[Rule]True", "MmaText",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Save[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lie["\<ncdiffu.dgl\>", NonclassicalSymmetries \[Rule] True, 
        NonclassicalCases \[Rule] {t}, NonclassicalInfo \[Rule] True] // LTF
      \)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {
            \(2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u - 2\ \((\[Xi]\_1)\)\_\(x, u\) + 
                \((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {
            \(\(-2\)\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x - \((\[Phi]\_1)\)\_t + 
                \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + 2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_x + \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We end up with four non-linear determining equations. We realize that the \
number of equations is reduced by five. Although the equations are still \
non-linear, we have a good chance to solve them. First, we observe that not \
all equations are coupled. Thus, the strategy is to extract those equations \
which are simple and linear. Solving this subset of equations will provide us \
with more information on the infinitesimals. This information is essential to \
solve the remaining non-linear determining equations. The first equation of \
the determining equations states that ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[1] allows a solution which is independent of the dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Thus, we can use this information to extend our file ",
  StyleBox["ncdiffu.dgl ",
    FontSlant->"Italic"],
  "with"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"nonlinear determining equations"],

Cell[BoxData[{
    \(Clear[A]\), 
    \(ListXi\  = \ {A[x, t], 1}; \nListPhi\  = \ {\(phi[1]\)[x, t, u[x, t]]}; 
    \nSave["\<ncdiffu.dgl\>", ListXi, ListPhi]; \)}], "Input"],

Cell[TextData[{
  "Running the function ",
  StyleBox["Lie[]", "MmaText"],
  " again and using the new information in the file, we get"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Lie[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lie["\<ncdiffu.dgl\>", NonclassicalSymmetries \[Rule] True, 
        NonclassicalCases \[Rule] {t}, NonclassicalInfo \[Rule] True] // LTF
      \)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {
            \(\(-A\_t\) - 2\ A\ A\_x + A\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-2\)\ A\_x\ \[Phi]\_1 - \((\[Phi]\_1)\)\_t + 
                \((\[Phi]\_1)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting three equations are again simplified and determine the \
infinitesimals. A glance at these equations shows that we get a mixed system \
of linear and non-linear determining equations. The linear equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\(u, u\) = 0\)]],
  " serves to gain additional information on the structure of the  \
infinitesimals. This equation allows us to represent \[Phi] as a linear \
function in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Thus, we set the infinitesimals to"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"infinitesimals"],

Cell[BoxData[
    \(\(ListXi\  = \ {A[x, t], 1}; \)\)], "Input"],

Cell[TextData["as before, and \[Phi] as"], "Text"],

Cell[BoxData[
    \(\(ListPhi\  = \ {B[x, t]\  + \ C[x, t]\ u[x, t]}; \)\)], "Input"],

Cell[TextData[{
  "where ",
  StyleBox["B[x,t]",
    FontSlant->"Italic"],
  " and ",
  StyleBox["C[x,t] ",
    FontSlant->"Italic"],
  "are arbitrary functions. Saving this result,"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Save["\<ncdiffu.dgl\>", ListXi, ListPhi]; \)\)], "Input"],

Cell["and starting the calculation again by", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdiffu\  = \ 
      Lie["\<ncdiffu.dgl\>", NonclassicalSymmetries -> True, \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ NonclassicalCases -> {t}, \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ NonclassicalInfo -> True]; 
    ncdiffu // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-A\_t\) - 2\ A\ A\_x - 2\ C\_x + A\_\(x, x\) == 0\)},
          {\(\(-2\)\ B\ A\_x - B\_t + B\_\(x, x\) == 0\)},
          {\(\(-2\)\ C[x, t]\ A\_x - C\_t + C\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "reveals a system of three coupled non-linear equations for the unknown \
functions ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", ",
  StyleBox["B",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["C",
    FontSlant->"Italic"],
  ". This system of equations determines the infinitesimals of the  \
non-classical group. At this stage, we clearly face the problem that starting \
 with a linear PDE, we end up with a non-linear one. This system of \
non-linear PDEs is difficult to solve. However, in our analysis, we only need \
special solutions of this equation to find new solutions of the heat \
equation. We already know a method to analyze such non-linear equations. \
Applying Lie's point symmetry procedure in the usual way, we get the \
symmetries of these equations. The symmetries of the three coupled PDEs read"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"non-classical group", "Lie's point symmetry procedure"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(incdiffu\  = \ Infinitesimals[ncdiffu, {A, B, C}, {x, t}]; 
    incdiffu // LTF\)], "Input"],

Cell[BoxData[
    \(PDESolve::"nsf" \( : \ \) 
      "Use option Standard->True. \n This may lead to further solutions in \
case of\n\:f39flinear Systems"\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k1", "-", \(2\ k5\ t\), "+", 
                StyleBox[\(\(k3\ x\)\/2\),
                  ScriptLevel->0], "-", 
                StyleBox[\(\(2\ k7\ t\ x\)\/5\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{"k2", "+", \(k3\ t\), "-", 
                StyleBox[\(\(2\ k7\ t\^2\)\/5\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(1\/10\),
                  ScriptLevel->0], " ", 
                \((\(-5\)\ A\ k3 - 20\ k5 + 4\ A\ k7\ t - 4\ k7\ x)\)}]}]},
          {
            RowBox[{\(\[Phi]\_2\), "==", 
              RowBox[{
                RowBox[{"B", " ", 
                  RowBox[{"(", 
                    RowBox[{
                    "k4", "+", "k6", "+", \(k7\ t\), "+", \(k5\ x\), "+", 
                      StyleBox[\(\(k7\ x\^2\)\/10\),
                        ScriptLevel->0]}], ")"}]}], "+", 
                \(C\ \[ScriptCapitalF]\_1\), "-", 
                \(A\ \((\[ScriptCapitalF]\_1)\)\_x\), "-", 
                \(\((\[ScriptCapitalF]\_1)\)\_\(x, x\)\)}]}]},
          {
            RowBox[{\(\[Phi]\_3\), "==", 
              RowBox[{
                StyleBox[\(1\/5\),
                  ScriptLevel->0], " ", 
                \((\(-5\)\ C\ k3 + 5\ A\ k5 + k7 + 4\ C\ k7\ t + A\ k7\ x)
                  \)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k1, 
            Times[ -2, k5, t], 
            Times[ 
              Rational[ 1, 2], k3, x], 
            Times[ 
              Rational[ -2, 5], k7, t, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k2, 
            Times[ k3, t], 
            Times[ 
              Rational[ -2, 5], k7, 
              Power[ t, 2]]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 10], 
            Plus[ 
              Times[ -5, A, k3], 
              Times[ -20, k5], 
              Times[ 4, A, k7, t], 
              Times[ -4, k7, x]]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Plus[ 
            Times[ B, 
              Plus[ k4, k6, 
                Times[ k7, t], 
                Times[ k5, x], 
                Times[ 
                  Rational[ 1, 10], k7, 
                  Power[ x, 2]]]], 
            Times[ C, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, A, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x, x]]]], 
        Equal[ 
          Subscript[ \[Phi], 3], 
          Times[ 
            Rational[ 1, 5], 
            Plus[ 
              Times[ -5, C, k3], 
              Times[ 5, A, k5], k7, 
              Times[ 4, C, k7, t], 
              Times[ A, k7, x]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is that the three coupled PDEs for the non-classical symmetries \
posses a seven-dimensional discrete symmetry group. In addition, there exist \
an infinite dimensional group given by the function ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[1]. This arbitrary function has to satisfy the heat equation. The \
symmetries of the non-classical determining equations exhibit a similar \
structure as the point symmetries of the heat equation. The symmetries can \
now be used to find special solutions for the functions ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", ",
  StyleBox["B",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["C",
    FontSlant->"Italic"],
  ". First, we select the subgroup with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"heat equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      \({{\(xi[1]\)[x, t, A, B, C], \(xi[2]\)[x, t, A, B, C]}, {
              \(phi[1]\)[x, t, A, B, C], \n\(phi[2]\)[x, t, A, B, C], 
              \(phi[3]\)[x, t, A, B, C]}}\  /. \ 
          incdiffu\[LeftDoubleBracket]1\[RightDoubleBracket]\)\  /. 
        \n{k1 -> 0, k2 -> 1, k3 -> 0, k4 -> 0, k5 -> 0, k6 -> 0, k7 -> 0, 
          free[_] \[Rule] Function[{x, t}, 0]}\)], "Input"],

Cell[BoxData[
    \({{0, 1}, {0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell["\<\
The corresponding reduction of the non-classical determining \
equations follow with this representation of the infinitesimals by\
\>", 
  "Text",
  CellTags->"reduction of the non-classical determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red\  = \ 
      LieReduction[ncdiffu, {A, B, C}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \(red // Flatten\) // LTF /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(x - zeta1 == 0\)},
          {\(A - F\_1 == 0\)},
          {\(B - F\_2 == 0\)},
          {\(C - F\_3 == 0\)},
          {
            \(\(-2\)\ F3\_zeta1 - 2\ F\_1\ \((F\_1)\)\_zeta1 + 
                \((F\_1)\)\_\(zeta1, zeta1\) == 0\)},
          {\(\(-2\)\ F\_2\ F1\_zeta1 + \((F\_2)\)\_\(zeta1, zeta1\) == 0\)},
          {\(\(-2\)\ F\_3\ F1\_zeta1 + \((F\_3)\)\_\(zeta1, zeta1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The similarity representation of the non-linear determining equations is \
given by three coupled non-linear ODEs. To simplify things, let us assume \
that the functions ",
  Cell[BoxData[
      \(TraditionalForm\`F2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`F3\)]],
  " are given by the trivial solutions"
}], "Text",
  CellTags->
  "similarity representation of the nonlinear determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(redh\  = \ 
      red\[LeftDoubleBracket]3\[RightDoubleBracket]\  /. 
        \ {F3 \[Rule] Function[zeta1, 0], F2 \[Rule] Function[zeta1, 0]}\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(-2\), " ", \(F1[zeta1]\), " ", 
              RowBox[{
                SuperscriptBox["F1", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["F1", "\[DoublePrime]",
                MultilineFunction->None], "[", "zeta1", "]"}]}], "==", "0"}], 
        ",", "True", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The substitution of ",
  Cell[BoxData[
      \(TraditionalForm\`F2 = 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`F3 = 0\)]],
  " into the reduced equations simplifies the system to a single equation. \
This equation is solved by ",
  StyleBox["DSolve[]", "MmaText"]
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ 
      DSolve[redh\[LeftDoubleBracket]1\[RightDoubleBracket], F1, zeta1]\)], 
  "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((\@C[2]\ Tan[#1\ \@C[2] + C[1]\ \@C[2]]&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
The solution simplifies further if we specify the constants of \
integration in a certain way:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ 
      \((\ F1[zeta1]\  /. sol1\ )\) /. {C[1] \[Rule] 0, 
            C[2] \[Rule] \[Alpha]\^2} // Simplify\)], "Input"],

Cell[BoxData[
    \({\@\[Alpha]\^2\ Tan[zeta1\ \@\[Alpha]\^2]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The final solution for the unknown functions ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", ",
  StyleBox["B",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["C",
    FontSlant->"Italic"],
  " of the non-classical determining equations is thus given by"
}], "Text",
  CellTags->"solution of the non-classical determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rsol\  = \ 
      Solve[\(\(red\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. \ sol1
                \)\  /. 
              \ {F3 \[Rule] Function[zeta1, 0], F2 \[Rule] Function[zeta1, 0]}
                \) /. {C[1] \[Rule] 0, C[2] \[Rule] \[Alpha]\^2} // 
          Simplify, {A, B, C}]\)], "Input"],

Cell[BoxData[
    \({{A \[Rule] \@\[Alpha]\^2\ Tan[x\ \@\[Alpha]\^2], B \[Rule] 0, 
        C \[Rule] 0}}\)], "Output"]
}, Open  ]],

Cell["\<\
We can check that this special solution satisfies the determining \
equations by rewriting the above results in a pure function form:\
\>", "Text",\

  CellTags->"pure function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infired\  = 
      \ {A \[Rule] Function[{x, t}, \@\[Alpha]\^2\ Tan[x\ \@\[Alpha]\^2]], 
        B \[Rule] Function[{x, t}, 0], C \[Rule] Function[{x, t}, 0]}; 
    infired // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(A == \@\[Alpha]\^2\ Tan[x\ \@\[Alpha]\^2]\)},
          {\(B == 0\)},
          {\(C == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ A, 
          Times[ 
            Power[ 
              Power[ \[Alpha], 2], 
              Rational[ 1, 2]], 
            Tan[ 
              Times[ x, 
                Power[ 
                  Power[ \[Alpha], 2], 
                  Rational[ 1, 2]]]]]], 
        Equal[ B, 0], 
        Equal[ C, 0]}]]], "Output"]
}, Open  ]],

Cell["\<\
Inserting this representation of the solution into the non-linear \
determining equations, we find that the equations are identically \
satisfied:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdiffu\  /. infired // Simplify\)], "Input"],

Cell[BoxData[
    \({0, 0, 0}\)], "Output"]
}, Open  ]],

Cell["\<\
The non-classical infinitesimals for the heat equation are thus \
given by\
\>", "Text",
  CellTags->"non-classical infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(infdifus\  = \ {ListXi, ListPhi}\  /. \ infired\ \)\)], "Input"],

Cell[BoxData[
    \({{\@\[Alpha]\^2\ Tan[x\ \@\[Alpha]\^2], 1}, {0}}\)], "Output"]
}, Open  ]],

Cell["\<\
representing a special transformation under which the heat equation \
is invariant. The reduction of the heat equation with these infinitesimals \
follows:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rdiffus\  = \ 
      LieReduction[diffus, {u}, {x, t}, 
        infdifus\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infdifus\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \(rdiffus\  // Flatten\) // LTF /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Message"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(-zeta1\), "-", 
                
                StyleBox[
                  \(\(\(-t\)\ \[Alpha]\^2 + 
                        Log[Sin[x\ \[Alpha]]]\)\/\[Alpha]\^2\),
                  ScriptLevel->0]}], "==", "0"}]},
          {\(u - F\_1 == 0\)},
          {
            \(\((E\^\(2\ t\ \[Alpha]\^2\) - E\^\(2\ zeta1\ \[Alpha]\^2\))\)\ 
                \((\[Alpha]\^2\ F1\_zeta1 + F1\_\(zeta1, zeta1\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The similarity representation of the heat equation is an expression \
combining trigonometric and logarithmic functions. The unknown function ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " of this reduction is determined by a second-order ODE. This ODE is solved \
 by ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"similarity representation"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"srdiffus", " ", "=", " ", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(\[Alpha]\^2\), " ", 
                  RowBox[{
                    SuperscriptBox["F1", "\[Prime]",
                      MultilineFunction->None], "[", "zeta1", "]"}]}], "+", 
                RowBox[{
                  SuperscriptBox["F1", "\[DoublePrime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}], ")"}], 
            "==", "0"}], ",", "F1", ",", "zeta1"}], "]"}]}]], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((\(-\(\(E\^\(\(-\[Alpha]\^2\)\ #1\)\ C[1]\)\/\[Alpha]\^2\)\) + 
                C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an exponential solution containing two constants of \
integration ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2]. In original variables, the solution reads"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = \ 
      Solve[\((rdiffus\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. \ 
                srdiffus)\) // Simplify, u] // Flatten\)], "Input"],

Cell[BoxData[
    \({u \[Rule] 
        C[2] - \(E\^\(\(-t\)\ \[Alpha]\^2\)\ C[1]\ 
              Sin[x\ \[Alpha]]\)\/\[Alpha]\^2}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we specify the parameters \[Alpha], ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1], and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2] in an appropriate way, we can graphically represent the solution by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ Plot3D[
      Evaluate[\(u /. sol\)\  /. {\[Alpha] \[Rule] 1/2, C[1] \[Rule] 1, 
            C[2] \[Rule] 2}], {x, \(-3\) \[Pi], 3  \[Pi]}, {t, 0, 6}, 
      AxesLabel \[Rule] {"\<x\>", "\<t\>", "\<u\>"}, PlotPoints \[Rule] 25]
      \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.55112e-17 1.04977 -0.0679587 1.04977 [
[.16712 .19126 -11.837 -9 ]
[.16712 .19126 .16295 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.51313 .05518 -5.25488 -9 ]
[.51313 .05518 .74512 0 ]
[.29165 .07573 -9.31117 -15 ]
[.29165 .07573 .68883 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.80849 .15988 0 -6.10118 ]
[.80849 .15988 6 2.89882 ]
[.90119 .30183 0 -5.96721 ]
[.90119 .30183 6 3.03279 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02411 .26511 -12 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -6 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -6 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.17627 .20066 m
.18085 .20537 L
s
[(-5)] .16712 .19126 .97284 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.52102 .06567 m
.52496 .07092 L
s
[(5)] .51313 .05518 .75163 1 Mshowa
.125 Mabswid
.20879 .18793 m
.2115 .19079 L
s
.24172 .17504 m
.2444 .17792 L
s
.27507 .16198 m
.27771 .1649 L
s
.30885 .14875 m
.31146 .1517 L
s
.37773 .12178 m
.38026 .1248 L
s
.41285 .10803 m
.41534 .11108 L
s
.44843 .0941 m
.45088 .09718 L
s
.48448 .07998 m
.48689 .08309 L
s
.14416 .21324 m
.14694 .21603 L
s
.11245 .22566 m
.11526 .22842 L
s
.08113 .23792 m
.08396 .24065 L
s
.05019 .25004 m
.05305 .25274 L
s
.55805 .05117 m
.56037 .05435 L
s
.59558 .03648 m
.59785 .03969 L
s
.63363 .02158 m
.63585 .02483 L
s
.67219 .00648 m
.67437 .00976 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.79613 .16428 m
.78995 .16648 L
s
[(2)] .80849 .15988 -1 .35582 Mshowa
.88871 .30589 m
.88247 .30793 L
s
[(4)] .90119 .30183 -1 .32605 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(6)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.71716 .04348 m
.71349 .04489 L
s
.7445 .0853 m
.74081 .08667 L
s
.7708 .12553 m
.7671 .12688 L
s
.82054 .20161 m
.81682 .20291 L
s
.84407 .23761 m
.84035 .23888 L
s
.86679 .27235 m
.86305 .2736 L
s
.9099 .3383 m
.90615 .3395 L
s
.93037 .36962 m
.92662 .3708 L
s
.95018 .39992 m
.94642 .40107 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(-2)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(0)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(2)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(4)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(6)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03427 .2734 m
.03794 .27198 L
s
.03218 .28658 m
.03585 .28517 L
s
.03007 .29987 m
.03375 .29847 L
s
.0258 .3268 m
.02949 .32541 L
s
.02364 .34044 m
.02733 .33906 L
s
.02146 .3542 m
.02515 .35283 L
s
.01704 .38208 m
.02074 .38072 L
s
.01481 .3962 m
.0185 .39485 L
s
.01255 .41045 m
.01625 .40911 L
s
.00797 .43933 m
.01168 .43801 L
s
.00565 .45397 m
.00936 .45265 L
s
.00331 .46873 m
.00703 .46743 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.627 .718 .912 r
.38946 .66645 .40247 .67947 .42427 .67492 .41136 .66192 Metetra
.553 .694 .933 r
.41136 .66192 .42427 .67492 .4462 .67347 .43336 .66071 Metetra
.477 .668 .947 r
.43336 .66071 .4462 .67347 .46834 .67444 .45557 .66208 Metetra
.421 .652 .955 r
.45557 .66208 .46834 .67444 .49073 .67675 .47804 .66488 Metetra
.409 .656 .96 r
.47804 .66488 .49073 .67675 .51343 .67908 .50082 .66772 Metetra
.448 .686 .966 r
.50082 .66772 .51343 .67908 .53642 .68011 .52392 .66917 Metetra
.525 .727 .966 r
.52392 .66917 .53642 .68011 .55968 .67865 .5473 .66796 Metetra
.611 .765 .953 r
.5473 .66796 .55968 .67865 .58316 .6739 .57091 .66323 Metetra
.684 .787 .929 r
.57091 .66323 .58316 .6739 .60677 .66555 .59467 .65466 Metetra
.734 .796 .901 r
.59467 .65466 .60677 .66555 .63046 .65387 .61852 .64252 Metetra
.764 .795 .879 r
.61852 .64252 .63046 .65387 .65419 .63962 .6424 .62764 Metetra
.776 .79 .864 r
.6424 .62764 .65419 .63962 .67796 .62396 .66632 .61126 Metetra
.773 .781 .859 r
.66632 .61126 .67796 .62396 .70182 .60825 .69032 .59483 Metetra
.757 .77 .863 r
.69032 .59483 .70182 .60825 .72583 .59382 .71447 .57978 Metetra
.728 .756 .875 r
.71447 .57978 .72583 .59382 .75011 .58181 .73888 .56731 Metetra
.685 .738 .891 r
.73888 .56731 .75011 .58181 .77476 .57297 .76368 .55824 Metetra
.63 .715 .908 r
.76368 .55824 .77476 .57297 .79989 .56759 .78895 .55285 Metetra
.568 .69 .923 r
.78895 .55285 .79989 .56759 .82556 .56541 .81478 .5509 Metetra
.51 .668 .934 r
.81478 .5509 .82556 .56541 .85177 .56573 .84117 .55161 Metetra
.471 .656 .941 r
.84117 .55161 .85177 .56573 .87848 .56743 .86808 .55381 Metetra
.463 .662 .948 r
.86808 .55381 .87848 .56743 .90556 .56915 .89538 .55604 Metetra
.49 .686 .954 r
.89538 .55604 .90556 .56915 .93287 .5695 .92291 .5568 Metetra
.546 .723 .956 r
.92291 .5568 .93287 .5695 .96022 .56727 .95048 .55481 Metetra
.616 .762 .949 r
.95048 .55481 .96022 .56727 .98744 .5616 .97791 .54915 Metetra
.625 .716 .911 r
.37627 .65315 .38946 .66645 .41136 .66192 .39825 .64864 Metetra
.545 .69 .934 r
.39825 .64864 .41136 .66192 .43336 .66071 .42034 .64768 Metetra
.461 .661 .948 r
.42034 .64768 .43336 .66071 .45557 .66208 .44261 .64949 Metetra
.4 .641 .954 r
.44261 .64949 .45557 .66208 .47804 .66488 .46515 .65283 Metetra
.386 .645 .959 r
.46515 .65283 .47804 .66488 .50082 .66772 .48801 .65621 Metetra
.429 .678 .967 r
.48801 .65621 .50082 .66772 .52392 .66917 .51121 .65811 Metetra
.514 .724 .968 r
.51121 .65811 .52392 .66917 .5473 .66796 .53471 .65718 Metetra
.608 .765 .955 r
.53471 .65718 .5473 .66796 .57091 .66323 .55846 .65248 Metetra
.686 .79 .929 r
.55846 .65248 .57091 .66323 .59467 .65466 .58237 .64368 Metetra
.739 .798 .9 r
.58237 .64368 .59467 .65466 .61852 .64252 .60638 .63106 Metetra
.769 .797 .876 r
.60638 .63106 .61852 .64252 .6424 .62764 .63042 .61551 Metetra
.781 .791 .861 r
.63042 .61551 .6424 .62764 .66632 .61126 .6545 .59836 Metetra
.779 .782 .856 r
.6545 .59836 .66632 .61126 .69032 .59483 .67864 .58116 Metetra
.762 .77 .86 r
.67864 .58116 .69032 .59483 .71447 .57978 .70293 .56545 Metetra
.732 .756 .872 r
.70293 .56545 .71447 .57978 .73888 .56731 .72748 .5525 Metetra
.687 .737 .889 r
.72748 .5525 .73888 .56731 .76368 .55824 .75241 .54318 Metetra
.628 .713 .908 r
.75241 .54318 .76368 .55824 .78895 .55285 .77784 .53779 Metetra
.562 .686 .923 r
.77784 .53779 .78895 .55285 .81478 .5509 .80383 .53609 Metetra
.499 .661 .934 r
.80383 .53609 .81478 .5509 .84117 .55161 .8304 .53723 Metetra
.457 .648 .941 r
.8304 .53723 .84117 .55161 .86808 .55381 .8575 .53996 Metetra
.448 .653 .948 r
.8575 .53996 .86808 .55381 .89538 .55604 .88502 .54273 Metetra
.477 .68 .955 r
.88502 .54273 .89538 .55604 .92291 .5568 .91278 .54395 Metetra
.538 .72 .958 r
.91278 .54395 .92291 .5568 .95048 .55481 .94058 .54222 Metetra
.613 .762 .951 r
.94058 .54222 .95048 .55481 .97791 .54915 .96822 .53657 Metetra
.623 .713 .911 r
.36289 .63956 .37627 .65315 .39825 .64864 .38496 .63508 Metetra
.537 .685 .934 r
.38496 .63508 .39825 .64864 .42034 .64768 .40712 .6344 Metetra
.445 .652 .948 r
.40712 .6344 .42034 .64768 .44261 .64949 .42945 .63667 Metetra
.376 .629 .952 r
.42945 .63667 .44261 .64949 .46515 .65283 .45206 .64058 Metetra
.36 .633 .957 r
.45206 .64058 .46515 .65283 .48801 .65621 .475 .64456 Metetra
.408 .668 .967 r
.475 .64456 .48801 .65621 .51121 .65811 .49829 .64695 Metetra
.501 .721 .97 r
.49829 .64695 .51121 .65811 .53471 .65718 .52191 .64631 Metetra
.604 .766 .957 r
.52191 .64631 .53471 .65718 .55846 .65248 .5458 .64166 Metetra
.688 .792 .929 r
.5458 .64166 .55846 .65248 .58237 .64368 .56987 .6326 Metetra
.744 .801 .898 r
.56987 .6326 .58237 .64368 .60638 .63106 .59404 .61947 Metetra
.775 .799 .872 r
.59404 .61947 .60638 .63106 .63042 .61551 .61825 .60321 Metetra
.787 .792 .857 r
.61825 .60321 .63042 .61551 .6545 .59836 .64248 .58525 Metetra
.784 .783 .851 r
.64248 .58525 .6545 .59836 .67864 .58116 .66678 .56724 Metetra
.767 .771 .856 r
.66678 .56724 .67864 .58116 .70293 .56545 .69121 .55082 Metetra
.735 .756 .869 r
.69121 .55082 .70293 .56545 .72748 .5525 .7159 .53736 Metetra
.688 .736 .888 r
.7159 .53736 .72748 .5525 .75241 .54318 .74097 .52778 Metetra
.626 .711 .907 r
.74097 .52778 .75241 .54318 .77784 .53779 .76654 .52241 Metetra
.555 .682 .923 r
.76654 .52241 .77784 .53779 .80383 .53609 .79269 .52097 Metetra
.488 .654 .933 r
.79269 .52097 .80383 .53609 .8304 .53723 .81945 .52257 Metetra
.441 .639 .94 r
.81945 .52257 .8304 .53723 .8575 .53996 .84675 .52588 Metetra
.431 .644 .947 r
.84675 .52588 .8575 .53996 .88502 .54273 .87449 .52924 Metetra
.463 .673 .955 r
.87449 .52924 .88502 .54273 .91278 .54395 .90248 .53095 Metetra
.528 .717 .959 r
.90248 .53095 .91278 .54395 .94058 .54222 .93051 .52951 Metetra
.61 .763 .952 r
.93051 .52951 .94058 .54222 .96822 .53657 .95836 .52388 Metetra
.621 .711 .91 r
.34932 .62567 .36289 .63956 .38496 .63508 .37148 .62122 Metetra
.527 .68 .935 r
.37148 .62122 .38496 .63508 .40712 .6344 .39371 .62084 Metetra
.426 .642 .947 r
.39371 .62084 .40712 .6344 .42945 .63667 .4161 .62361 Metetra
.35 .615 .95 r
.4161 .62361 .42945 .63667 .45206 .64058 .43876 .62815 Metetra
.332 .618 .954 r
.43876 .62815 .45206 .64058 .475 .64456 .46177 .63276 Metetra
.385 .658 .966 r
.46177 .63276 .475 .64456 .49829 .64695 .48516 .63568 Metetra
.487 .716 .972 r
.48516 .63568 .49829 .64695 .52191 .64631 .5089 .63537 Metetra
.6 .766 .959 r
.5089 .63537 .52191 .64631 .5458 .64166 .53292 .63076 Metetra
.69 .794 .929 r
.53292 .63076 .5458 .64166 .56987 .6326 .55715 .62144 Metetra
.749 .803 .896 r
.55715 .62144 .56987 .6326 .59404 .61947 .58149 .60777 Metetra
.781 .801 .869 r
.58149 .60777 .59404 .61947 .61825 .60321 .60587 .59075 Metetra
.793 .793 .852 r
.60587 .59075 .61825 .60321 .64248 .58525 .63027 .57192 Metetra
.79 .783 .847 r
.63027 .57192 .64248 .58525 .66678 .56724 .65472 .55305 Metetra
.772 .771 .852 r
.65472 .55305 .66678 .56724 .69121 .55082 .6793 .53589 Metetra
.739 .756 .866 r
.6793 .53589 .69121 .55082 .7159 .53736 .70413 .52189 Metetra
.69 .735 .886 r
.70413 .52189 .7159 .53736 .74097 .52778 .72934 .51204 Metetra
.624 .709 .906 r
.72934 .51204 .74097 .52778 .76654 .52241 .75506 .50669 Metetra
.548 .677 .923 r
.75506 .50669 .76654 .52241 .79269 .52097 .78137 .50553 Metetra
.475 .646 .933 r
.78137 .50553 .79269 .52097 .81945 .52257 .80831 .50763 Metetra
.424 .629 .939 r
.80831 .50763 .81945 .52257 .84675 .52588 .83582 .51157 Metetra
.413 .634 .946 r
.83582 .51157 .84675 .52588 .87449 .52924 .86378 .51556 Metetra
.447 .665 .955 r
.86378 .51556 .87449 .52924 .90248 .53095 .89201 .5178 Metetra
.518 .714 .961 r
.89201 .5178 .90248 .53095 .93051 .52951 .92027 .51667 Metetra
.606 .763 .954 r
.92027 .51667 .93051 .52951 .95836 .52388 .94834 .51106 Metetra
.618 .709 .91 r
.33556 .61147 .34932 .62567 .37148 .62122 .35781 .60706 Metetra
.517 .674 .935 r
.35781 .60706 .37148 .62122 .39371 .62084 .3801 .60699 Metetra
.406 .631 .946 r
.3801 .60699 .39371 .62084 .4161 .62361 .40254 .61031 Metetra
.321 .599 .946 r
.40254 .61031 .4161 .62361 .43876 .62815 .42526 .61552 Metetra
.3 .601 .95 r
.42526 .61552 .43876 .62815 .46177 .63276 .44833 .62081 Metetra
.358 .645 .964 r
.44833 .62081 .46177 .63276 .48516 .63568 .4718 .6243 Metetra
.472 .711 .974 r
.4718 .6243 .48516 .63568 .5089 .63537 .49565 .62434 Metetra
.596 .767 .961 r
.49565 .62434 .5089 .63537 .53292 .63076 .51982 .61979 Metetra
.692 .797 .93 r
.51982 .61979 .53292 .63076 .55715 .62144 .54421 .6102 Metetra
.754 .805 .894 r
.54421 .6102 .55715 .62144 .58149 .60777 .56872 .59595 Metetra
.787 .802 .865 r
.56872 .59595 .58149 .60777 .60587 .59075 .59328 .57813 Metetra
.799 .795 .848 r
.59328 .57813 .60587 .59075 .63027 .57192 .61786 .55837 Metetra
.795 .784 .842 r
.61786 .55837 .63027 .57192 .65472 .55305 .64247 .53859 Metetra
.777 .772 .848 r
.64247 .53859 .65472 .55305 .6793 .53589 .6672 .52064 Metetra
.743 .756 .863 r
.6672 .52064 .6793 .53589 .70413 .52189 .69217 .50607 Metetra
.691 .735 .884 r
.69217 .50607 .70413 .52189 .72934 .51204 .71753 .49594 Metetra
.622 .706 .906 r
.71753 .49594 .72934 .51204 .75506 .50669 .74339 .4906 Metetra
.54 .671 .923 r
.74339 .4906 .75506 .50669 .78137 .50553 .76987 .48976 Metetra
.461 .638 .932 r
.76987 .48976 .78137 .50553 .80831 .50763 .79699 .4924 Metetra
.406 .618 .938 r
.79699 .4924 .80831 .50763 .83582 .51157 .8247 .497 Metetra
.393 .623 .945 r
.8247 .497 .83582 .51157 .86378 .51556 .85289 .50168 Metetra
.43 .657 .955 r
.85289 .50168 .86378 .51556 .89201 .5178 .88135 .50449 Metetra
.507 .71 .962 r
.88135 .50449 .89201 .5178 .92027 .51667 .90985 .5037 Metetra
.603 .763 .956 r
.90985 .5037 .92027 .51667 .94834 .51106 .93815 .49813 Metetra
.615 .706 .909 r
.32161 .59694 .33556 .61147 .35781 .60706 .34395 .59258 Metetra
.506 .668 .935 r
.34395 .59258 .35781 .60706 .3801 .60699 .36629 .59286 Metetra
.384 .619 .944 r
.36629 .59286 .3801 .60699 .40254 .61031 .38877 .59675 Metetra
.289 .581 .941 r
.38877 .59675 .40254 .61031 .42526 .61552 .41153 .60268 Metetra
.265 .582 .944 r
.41153 .60268 .42526 .61552 .44833 .62081 .43466 .60871 Metetra
.329 .631 .961 r
.43466 .60871 .44833 .62081 .4718 .6243 .45821 .61282 Metetra
.455 .705 .975 r
.45821 .61282 .4718 .6243 .49565 .62434 .48218 .61324 Metetra
.591 .767 .964 r
.48218 .61324 .49565 .62434 .51982 .61979 .50649 .60875 Metetra
.695 .799 .93 r
.50649 .60875 .51982 .61979 .54421 .6102 .53104 .59888 Metetra
.759 .808 .892 r
.53104 .59888 .54421 .6102 .56872 .59595 .55574 .58401 Metetra
.793 .804 .861 r
.55574 .58401 .56872 .59595 .59328 .57813 .58048 .56534 Metetra
.805 .796 .843 r
.58048 .56534 .59328 .57813 .61786 .55837 .60524 .5446 Metetra
.801 .785 .838 r
.60524 .5446 .61786 .55837 .64247 .53859 .63002 .52384 Metetra
.782 .772 .844 r
.63002 .52384 .64247 .53859 .6672 .52064 .65491 .50506 Metetra
.747 .756 .86 r
.65491 .50506 .6672 .52064 .69217 .50607 .68002 .48989 Metetra
.693 .734 .882 r
.68002 .48989 .69217 .50607 .71753 .49594 .70552 .47946 Metetra
.62 .703 .905 r
.70552 .47946 .71753 .49594 .74339 .4906 .73153 .47415 Metetra
.532 .666 .922 r
.73153 .47415 .74339 .4906 .76987 .48976 .75817 .47364 Metetra
.446 .628 .931 r
.75817 .47364 .76987 .48976 .79699 .4924 .78547 .47687 Metetra
.386 .606 .936 r
.78547 .47687 .79699 .4924 .8247 .497 .81339 .48219 Metetra
.371 .611 .943 r
.81339 .48219 .8247 .497 .85289 .50168 .84181 .48761 Metetra
.411 .647 .955 r
.84181 .48761 .85289 .50168 .88135 .50449 .87051 .49103 Metetra
.495 .705 .964 r
.87051 .49103 .88135 .50449 .90985 .5037 .89925 .49062 Metetra
.599 .764 .958 r
.89925 .49062 .90985 .5037 .93815 .49813 .92778 .48509 Metetra
.613 .703 .909 r
.30747 .58206 .32161 .59694 .34395 .59258 .32989 .57776 Metetra
.494 .661 .935 r
.32989 .57776 .34395 .59258 .36629 .59286 .35228 .57841 Metetra
.359 .605 .942 r
.35228 .57841 .36629 .59286 .38877 .59675 .37479 .58294 Metetra
.253 .56 .934 r
.37479 .58294 .38877 .59675 .41153 .60268 .39758 .58964 Metetra
.226 .56 .935 r
.39758 .58964 .41153 .60268 .43466 .60871 .42076 .59646 Metetra
.296 .615 .957 r
.42076 .59646 .43466 .60871 .45821 .61282 .44439 .60124 Metetra
.437 .699 .976 r
.44439 .60124 .45821 .61282 .48218 .61324 .46846 .60208 Metetra
.586 .768 .966 r
.46846 .60208 .48218 .61324 .50649 .60875 .49291 .59766 Metetra
.697 .802 .93 r
.49291 .59766 .50649 .60875 .53104 .59888 .51764 .58748 Metetra
.765 .81 .889 r
.51764 .58748 .53104 .59888 .55574 .58401 .54252 .57197 Metetra
.799 .806 .857 r
.54252 .57197 .55574 .58401 .58048 .56534 .56746 .55238 Metetra
.811 .797 .838 r
.56746 .55238 .58048 .56534 .60524 .5446 .5924 .5306 Metetra
.807 .785 .833 r
.5924 .5306 .60524 .5446 .63002 .52384 .61736 .50881 Metetra
.787 .772 .839 r
.61736 .50881 .63002 .52384 .65491 .50506 .64241 .48913 Metetra
.751 .756 .856 r
.64241 .48913 .65491 .50506 .68002 .48989 .66768 .47333 Metetra
.695 .733 .88 r
.66768 .47333 .68002 .48989 .70552 .47946 .69332 .46259 Metetra
.617 .7 .904 r
.69332 .46259 .70552 .47946 .73153 .47415 .71948 .45732 Metetra
.523 .66 .922 r
.71948 .45732 .73153 .47415 .75817 .47364 .74628 .45717 Metetra
.43 .618 .93 r
.74628 .45717 .75817 .47364 .78547 .47687 .77376 .46102 Metetra
.364 .592 .933 r
.77376 .46102 .78547 .47687 .81339 .48219 .80189 .46712 Metetra
.347 .597 .94 r
.80189 .46712 .81339 .48219 .84181 .48761 .83053 .47333 Metetra
.39 .636 .953 r
.83053 .47333 .84181 .48761 .87051 .49103 .85947 .47743 Metetra
.482 .7 .965 r
.85947 .47743 .87051 .49103 .89925 .49062 .88846 .47742 Metetra
.594 .764 .96 r
.88846 .47742 .89925 .49062 .92778 .48509 .91722 .47194 Metetra
.61 .7 .908 r
.29313 .56684 .30747 .58206 .32989 .57776 .31563 .5626 Metetra
.481 .653 .935 r
.31563 .5626 .32989 .57776 .35228 .57841 .33806 .56366 Metetra
.331 .589 .938 r
.33806 .56366 .35228 .57841 .37479 .58294 .3606 .56885 Metetra
.213 .536 .925 r
.3606 .56885 .37479 .58294 .39758 .58964 .38341 .57639 Metetra
.183 .534 .924 r
.38341 .57639 .39758 .58964 .42076 .59646 .40663 .58406 Metetra
.26 .595 .95 r
.40663 .58406 .42076 .59646 .44439 .60124 .43032 .58955 Metetra
.416 .691 .976 r
.43032 .58955 .44439 .60124 .46846 .60208 .4545 .59084 Metetra
.58 .768 .968 r
.4545 .59084 .46846 .60208 .49291 .59766 .47909 .58651 Metetra
.7 .805 .93 r
.47909 .58651 .49291 .59766 .51764 .58748 .504 .57601 Metetra
.771 .813 .886 r
.504 .57601 .51764 .58748 .54252 .57197 .52907 .55981 Metetra
.806 .807 .852 r
.52907 .55981 .54252 .57197 .56746 .55238 .55422 .53925 Metetra
.818 .797 .833 r
.55422 .53925 .56746 .55238 .5924 .5306 .57936 .51636 Metetra
.813 .786 .827 r
.57936 .51636 .5924 .5306 .61736 .50881 .6045 .49348 Metetra
.793 .772 .834 r
.6045 .49348 .61736 .50881 .64241 .48913 .62972 .47285 Metetra
.755 .756 .852 r
.62972 .47285 .64241 .48913 .66768 .47333 .65514 .45638 Metetra
.697 .732 .877 r
.65514 .45638 .66768 .47333 .69332 .46259 .68092 .44531 Metetra
.615 .697 .903 r
.68092 .44531 .69332 .46259 .71948 .45732 .70723 .44009 Metetra
.513 .653 .921 r
.70723 .44009 .71948 .45732 .74628 .45717 .73419 .44033 Metetra
.412 .607 .928 r
.73419 .44033 .74628 .45717 .77376 .46102 .76185 .44485 Metetra
.34 .577 .929 r
.76185 .44485 .77376 .46102 .80189 .46712 .79018 .45179 Metetra
.321 .581 .936 r
.79018 .45179 .80189 .46712 .83053 .47333 .81905 .45886 Metetra
.368 .624 .952 r
.81905 .45886 .83053 .47333 .85947 .47743 .84824 .46367 Metetra
.468 .694 .966 r
.84824 .46367 .85947 .47743 .88846 .47742 .87748 .4641 Metetra
.59 .764 .962 r
.87748 .4641 .88846 .47742 .91722 .47194 .90648 .45868 Metetra
.606 .697 .908 r
.27859 .55124 .29313 .56684 .31563 .5626 .30116 .54708 Metetra
.467 .645 .935 r
.30116 .54708 .31563 .5626 .33806 .56366 .32363 .54857 Metetra
.301 .571 .934 r
.32363 .54857 .33806 .56366 .3606 .56885 .34618 .55448 Metetra
.169 .509 .913 r
.34618 .55448 .3606 .56885 .38341 .57639 .369 .56291 Metetra
.135 .505 .909 r
.369 .56291 .38341 .57639 .40663 .58406 .39225 .5715 Metetra
.22 .573 .941 r
.39225 .5715 .40663 .58406 .43032 .58955 .416 .57777 Metetra
.392 .681 .976 r
.416 .57777 .43032 .58955 .4545 .59084 .44028 .57955 Metetra
.574 .769 .971 r
.44028 .57955 .4545 .59084 .47909 .58651 .46502 .57531 Metetra
.703 .808 .93 r
.46502 .57531 .47909 .58651 .504 .57601 .4901 .56448 Metetra
.777 .815 .883 r
.4901 .56448 .504 .57601 .52907 .55981 .51538 .54754 Metetra
.812 .809 .848 r
.51538 .54754 .52907 .55981 .55422 .53925 .54074 .52595 Metetra
.824 .798 .827 r
.54074 .52595 .55422 .53925 .57936 .51636 .56609 .50188 Metetra
.819 .786 .822 r
.56609 .50188 .57936 .51636 .6045 .49348 .59142 .47783 Metetra
.798 .773 .829 r
.59142 .47783 .6045 .49348 .62972 .47285 .61682 .45621 Metetra
.76 .755 .849 r
.61682 .45621 .62972 .47285 .65514 .45638 .6424 .43903 Metetra
.699 .731 .875 r
.6424 .43903 .65514 .45638 .68092 .44531 .66833 .42761 Metetra
.612 .694 .902 r
.66833 .42761 .68092 .44531 .70723 .44009 .69478 .42244 Metetra
.503 .646 .921 r
.69478 .42244 .70723 .44009 .73419 .44033 .72189 .42311 Metetra
.393 .595 .926 r
.72189 .42311 .73419 .44033 .76185 .44485 .74973 .42835 Metetra
.313 .561 .925 r
.74973 .42835 .76185 .44485 .79018 .45179 .77826 .43618 Metetra
.293 .564 .931 r
.77826 .43618 .79018 .45179 .81905 .45886 .80736 .44417 Metetra
.343 .611 .949 r
.80736 .44417 .81905 .45886 .84824 .46367 .83681 .44976 Metetra
.452 .688 .967 r
.83681 .44976 .84824 .46367 .87748 .4641 .8663 .45067 Metetra
.585 .764 .964 r
.8663 .45067 .87748 .4641 .90648 .45868 .89554 .44533 Metetra
.603 .694 .907 r
.26385 .53526 .27859 .55124 .30116 .54708 .2865 .53118 Metetra
.451 .635 .934 r
.2865 .53118 .30116 .54708 .32363 .54857 .30899 .53314 Metetra
.267 .551 .927 r
.30899 .53314 .32363 .54857 .34618 .55448 .33154 .53983 Metetra
.121 .478 .897 r
.33154 .53983 .34618 .55448 .369 .56291 .35436 .54922 Metetra
.082 .471 .891 r
.35436 .54922 .369 .56291 .39225 .5715 .37761 .55879 Metetra
.175 .548 .929 r
.37761 .55879 .39225 .5715 .416 .57777 .40141 .5659 Metetra
.366 .671 .974 r
.40141 .5659 .416 .57777 .44028 .57955 .42579 .56821 Metetra
.567 .769 .974 r
.42579 .56821 .44028 .57955 .46502 .57531 .45067 .56408 Metetra
.706 .812 .93 r
.45067 .56408 .46502 .57531 .4901 .56448 .47594 .55289 Metetra
.783 .818 .88 r
.47594 .55289 .4901 .56448 .51538 .54754 .50144 .53517 Metetra
.819 .811 .843 r
.50144 .53517 .51538 .54754 .54074 .52595 .52702 .51248 Metetra
.83 .799 .821 r
.52702 .51248 .54074 .52595 .56609 .50188 .55259 .48716 Metetra
.825 .786 .816 r
.55259 .48716 .56609 .50188 .59142 .47783 .57813 .46186 Metetra
.804 .773 .824 r
.57813 .46186 .59142 .47783 .61682 .45621 .60371 .43918 Metetra
.764 .755 .844 r
.60371 .43918 .61682 .45621 .6424 .43903 .62945 .42125 Metetra
.701 .729 .873 r
.62945 .42125 .6424 .43903 .66833 .42761 .65552 .40947 Metetra
.609 .691 .901 r
.65552 .40947 .66833 .42761 .69478 .42244 .68212 .40436 Metetra
.492 .638 .92 r
.68212 .40436 .69478 .42244 .72189 .42311 .70939 .40549 Metetra
.372 .581 .923 r
.70939 .40549 .72189 .42311 .74973 .42835 .7374 .4115 Metetra
.285 .543 .919 r
.7374 .4115 .74973 .42835 .77826 .43618 .76614 .4203 Metetra
.262 .545 .925 r
.76614 .4203 .77826 .43618 .80736 .44417 .79547 .42928 Metetra
.316 .596 .945 r
.79547 .42928 .80736 .44417 .83681 .44976 .82516 .43571 Metetra
.434 .68 .967 r
.82516 .43571 .83681 .44976 .8663 .45067 .85491 .43714 Metetra
.579 .765 .967 r
.85491 .43714 .8663 .45067 .89554 .44533 .88441 .43188 Metetra
.599 .69 .906 r
.24891 .51887 .26385 .53526 .2865 .53118 .27163 .51489 Metetra
.434 .625 .933 r
.27163 .51489 .2865 .53118 .30899 .53314 .29414 .51735 Metetra
.23 .527 .919 r
.29414 .51735 .30899 .53314 .33154 .53983 .31668 .52488 Metetra
.067 .443 .878 r
.31668 .52488 .33154 .53983 .35436 .54922 .33947 .53529 Metetra
.024 .433 .867 r
.33947 .53529 .35436 .54922 .37761 .55879 .36272 .54592 Metetra
.125 .518 .913 r
.36272 .54592 .37761 .55879 .40141 .5659 .38656 .55393 Metetra
.337 .658 .971 r
.38656 .55393 .40141 .5659 .42579 .56821 .41102 .55682 Metetra
.559 .769 .976 r
.41102 .55682 .42579 .56821 .45067 .56408 .43605 .55281 Metetra
.71 .815 .93 r
.43605 .55281 .45067 .56408 .47594 .55289 .46151 .54125 Metetra
.789 .821 .877 r
.46151 .54125 .47594 .55289 .50144 .53517 .48724 .52269 Metetra
.826 .812 .837 r
.48724 .52269 .50144 .53517 .52702 .51248 .51305 .49884 Metetra
.837 .8 .815 r
.51305 .49884 .52702 .51248 .55259 .48716 .53886 .47217 Metetra
.831 .787 .81 r
.53886 .47217 .55259 .48716 .57813 .46186 .56461 .44556 Metetra
.809 .773 .819 r
.56461 .44556 .57813 .46186 .60371 .43918 .59038 .42175 Metetra
.769 .755 .84 r
.59038 .42175 .60371 .43918 .62945 .42125 .61629 .40303 Metetra
.703 .728 .87 r
.61629 .40303 .62945 .42125 .65552 .40947 .64251 .39087 Metetra
.606 .687 .9 r
.64251 .39087 .65552 .40947 .68212 .40436 .66926 .38583 Metetra
.48 .63 .919 r
.66926 .38583 .68212 .40436 .70939 .40549 .69667 .38745 Metetra
.349 .566 .919 r
.69667 .38745 .70939 .40549 .7374 .4115 .72485 .3943 Metetra
.254 .523 .912 r
.72485 .3943 .7374 .4115 .76614 .4203 .75379 .40413 Metetra
.229 .524 .917 r
.75379 .40413 .76614 .4203 .79547 .42928 .78335 .41418 Metetra
.286 .579 .94 r
.78335 .41418 .79547 .42928 .82516 .43571 .8133 .42151 Metetra
.415 .672 .967 r
.8133 .42151 .82516 .43571 .85491 .43714 .84331 .42351 Metetra
.573 .765 .969 r
.84331 .42351 .85491 .43714 .88441 .43188 .87306 .41834 Metetra
.595 .687 .906 r
.23377 .50207 .24891 .51887 .27163 .51489 .25655 .49819 Metetra
.415 .614 .932 r
.25655 .49819 .27163 .51489 .29414 .51735 .27907 .5012 Metetra
.188 .501 .908 r
.27907 .5012 .29414 .51735 .31668 .52488 .30157 .50961 Metetra
.01 .404 .854 r
.30157 .50961 .31668 .52488 .33947 .53529 .32433 .52114 Metetra
0 .39 .838 r
.32433 .52114 .33947 .53529 .36272 .54592 .34756 .5329 Metetra
.07 .484 .893 r
.34756 .5329 .36272 .54592 .38656 .55393 .37143 .54188 Metetra
.304 .643 .967 r
.37143 .54188 .38656 .55393 .41102 .55682 .39597 .54539 Metetra
.551 .769 .979 r
.39597 .54539 .41102 .55682 .43605 .55281 .42115 .54152 Metetra
.713 .819 .93 r
.42115 .54152 .43605 .55281 .46151 .54125 .44681 .52956 Metetra
.796 .823 .873 r
.44681 .52956 .46151 .54125 .48724 .52269 .47276 .51012 Metetra
.832 .813 .832 r
.47276 .51012 .48724 .52269 .51305 .49884 .49884 .48502 Metetra
.843 .8 .809 r
.49884 .48502 .51305 .49884 .53886 .47217 .52489 .45693 Metetra
.837 .787 .803 r
.52489 .45693 .53886 .47217 .56461 .44556 .55087 .42891 Metetra
.815 .772 .813 r
.55087 .42891 .56461 .44556 .59038 .42175 .57684 .40391 Metetra
.773 .754 .836 r
.57684 .40391 .59038 .42175 .61629 .40303 .60292 .38434 Metetra
.705 .727 .867 r
.60292 .38434 .61629 .40303 .64251 .39087 .62929 .37179 Metetra
.602 .683 .899 r
.62929 .37179 .64251 .39087 .66926 .38583 .65618 .36684 Metetra
.467 .621 .917 r
.65618 .36684 .66926 .38583 .69667 .38745 .68374 .36899 Metetra
.325 .55 .915 r
.68374 .36899 .69667 .38745 .72485 .3943 .71209 .37672 Metetra
.221 .501 .904 r
.71209 .37672 .72485 .3943 .75379 .40413 .74122 .38767 Metetra
.192 .5 .907 r
.74122 .38767 .75379 .40413 .78335 .41418 .77101 .39886 Metetra
.254 .56 .934 r
.77101 .39886 .78335 .41418 .8133 .42151 .80121 .40717 Metetra
.394 .662 .966 r
.80121 .40717 .8133 .42151 .84331 .42351 .83149 .40978 Metetra
.566 .765 .972 r
.83149 .40978 .84331 .42351 .87306 .41834 .86151 .40473 Metetra
.591 .683 .905 r
.21842 .48484 .23377 .50207 .25655 .49819 .24126 .48107 Metetra
.394 .601 .93 r
.24126 .48107 .25655 .49819 .27907 .5012 .26377 .48466 Metetra
.143 .472 .894 r
.26377 .48466 .27907 .5012 .30157 .50961 .28623 .49403 Metetra
0 .36 .824 r
.28623 .49403 .30157 .50961 .32433 .52114 .30893 .50674 Metetra
0 .342 .803 r
.30893 .50674 .32433 .52114 .34756 .5329 .33213 .51973 Metetra
.01 .445 .867 r
.33213 .51973 .34756 .5329 .37143 .54188 .35601 .52975 Metetra
.268 .625 .961 r
.35601 .52975 .37143 .54188 .39597 .54539 .38063 .53393 Metetra
.542 .769 .982 r
.38063 .53393 .39597 .54539 .42115 .54152 .40594 .53021 Metetra
.717 .822 .93 r
.40594 .53021 .42115 .54152 .44681 .52956 .43181 .51784 Metetra
.803 .826 .869 r
.43181 .51784 .44681 .52956 .47276 .51012 .45801 .49745 Metetra
.839 .814 .826 r
.45801 .49745 .47276 .51012 .49884 .48502 .48435 .47102 Metetra
.85 .8 .802 r
.48435 .47102 .49884 .48502 .52489 .45693 .51067 .44141 Metetra
.843 .787 .797 r
.51067 .44141 .52489 .45693 .55087 .42891 .5369 .41191 Metetra
.821 .772 .807 r
.5369 .41191 .55087 .42891 .57684 .40391 .56307 .38564 Metetra
.778 .754 .831 r
.56307 .38564 .57684 .40391 .60292 .38434 .58933 .36519 Metetra
.707 .726 .865 r
.58933 .36519 .60292 .38434 .62929 .37179 .61586 .35222 Metetra
.598 .679 .898 r
.61586 .35222 .62929 .37179 .65618 .36684 .64288 .34736 Metetra
.453 .611 .916 r
.64288 .34736 .65618 .36684 .68374 .36899 .67059 .35007 Metetra
.298 .532 .909 r
.67059 .35007 .68374 .36899 .71209 .37672 .6991 .35877 Metetra
.185 .476 .894 r
.6991 .35877 .71209 .37672 .74122 .38767 .72842 .3709 Metetra
.153 .474 .895 r
.72842 .3709 .74122 .38767 .77101 .39886 .75844 .38333 Metetra
.218 .538 .925 r
.75844 .38333 .77101 .39886 .80121 .40717 .78889 .39269 Metetra
.371 .652 .965 r
.78889 .39269 .80121 .40717 .83149 .40978 .81945 .39596 Metetra
.559 .764 .974 r
.81945 .39596 .83149 .40978 .86151 .40473 .84972 .39104 Metetra
.586 .678 .904 r
.20287 .46714 .21842 .48484 .24126 .48107 .22576 .46351 Metetra
.371 .586 .927 r
.22576 .46351 .24126 .48107 .26377 .48466 .24826 .46772 Metetra
.093 .438 .877 r
.24826 .46772 .26377 .48466 .28623 .49403 .27065 .47811 Metetra
0 .311 .789 r
.27065 .47811 .28623 .49403 .30893 .50674 .29327 .49209 Metetra
0 .29 .762 r
.29327 .49209 .30893 .50674 .33213 .51973 .31641 .50639 Metetra
0 .401 .835 r
.31641 .50639 .33213 .51973 .35601 .52975 .34028 .51755 Metetra
.227 .604 .951 r
.34028 .51755 .35601 .52975 .38063 .53393 .36497 .52245 Metetra
.532 .768 .984 r
.36497 .52245 .38063 .53393 .40594 .53021 .39043 .51891 Metetra
.721 .826 .93 r
.39043 .51891 .40594 .53021 .43181 .51784 .41651 .50609 Metetra
.81 .828 .865 r
.41651 .50609 .43181 .51784 .45801 .49745 .44298 .4847 Metetra
.846 .815 .82 r
.44298 .4847 .45801 .49745 .48435 .47102 .4696 .45685 Metetra
.856 .801 .796 r
.4696 .45685 .48435 .47102 .51067 .44141 .4962 .42562 Metetra
.849 .786 .79 r
.4962 .42562 .51067 .44141 .5369 .41191 .52268 .39453 Metetra
.826 .772 .801 r
.52268 .39453 .5369 .41191 .56307 .38564 .54908 .36692 Metetra
.783 .753 .826 r
.54908 .36692 .56307 .38564 .58933 .36519 .57553 .34553 Metetra
.71 .724 .862 r
.57553 .34553 .58933 .36519 .61586 .35222 .60221 .33213 Metetra
.594 .675 .897 r
.60221 .33213 .61586 .35222 .64288 .34736 .62937 .32737 Metetra
.437 .6 .914 r
.62937 .32737 .64288 .34736 .67059 .35007 .65721 .3307 Metetra
.269 .513 .903 r
.65721 .3307 .67059 .35007 .6991 .35877 .68587 .34041 Metetra
.146 .45 .881 r
.68587 .34041 .6991 .35877 .72842 .3709 .71538 .35383 Metetra
.11 .446 .881 r
.71538 .35383 .72842 .3709 .75844 .38333 .74562 .36758 Metetra
.18 .515 .915 r
.74562 .36758 .75844 .38333 .78889 .39269 .77634 .37807 Metetra
.346 .639 .963 r
.77634 .37807 .78889 .39269 .81945 .39596 .80717 .38207 Metetra
.551 .764 .977 r
.80717 .38207 .81945 .39596 .84972 .39104 .83771 .37729 Metetra
.581 .674 .903 r
.18712 .44898 .20287 .46714 .22576 .46351 .21006 .44548 Metetra
.346 .571 .923 r
.21006 .44548 .22576 .46351 .24826 .46772 .23251 .45036 Metetra
.038 .4 .855 r
.23251 .45036 .24826 .46772 .27065 .47811 .25482 .46185 Metetra
0 .257 .747 r
.25482 .46185 .27065 .47811 .29327 .49209 .27734 .4772 Metetra
0 .233 .714 r
.27734 .4772 .29327 .49209 .31641 .50639 .3004 .49291 Metetra
0 .351 .797 r
.3004 .49291 .31641 .50639 .34028 .51755 .32425 .50528 Metetra
.181 .58 .939 r
.32425 .50528 .34028 .51755 .36497 .52245 .34899 .51096 Metetra
.52 .767 .987 r
.34899 .51096 .36497 .52245 .39043 .51891 .37459 .50761 Metetra
.726 .83 .93 r
.37459 .50761 .39043 .51891 .41651 .50609 .40089 .49432 Metetra
.817 .831 .86 r
.40089 .49432 .41651 .50609 .44298 .4847 .42764 .47186 Metetra
.853 .816 .813 r
.42764 .47186 .44298 .4847 .4696 .45685 .45457 .4425 Metetra
.862 .801 .788 r
.45457 .4425 .4696 .45685 .4962 .42562 .48147 .40955 Metetra
.855 .786 .783 r
.48147 .40955 .4962 .42562 .52268 .39453 .50823 .37677 Metetra
.832 .771 .795 r
.50823 .37677 .52268 .39453 .54908 .36692 .53487 .34774 Metetra
.788 .753 .821 r
.53487 .34774 .54908 .36692 .57553 .34553 .5615 .32536 Metetra
.712 .723 .858 r
.5615 .32536 .57553 .34553 .60221 .33213 .58834 .3115 Metetra
.59 .671 .895 r
.58834 .3115 .60221 .33213 .62937 .32737 .61563 .30685 Metetra
.421 .588 .911 r
.61563 .30685 .62937 .32737 .65721 .3307 .64361 .31084 Metetra
.238 .491 .894 r
.64361 .31084 .65721 .3307 .68587 .34041 .67242 .32165 Metetra
.104 .42 .866 r
.67242 .32165 .68587 .34041 .71538 .35383 .7021 .33644 Metetra
.065 .414 .863 r
.7021 .33644 .71538 .35383 .74562 .36758 .73256 .35161 Metetra
.139 .488 .902 r
.73256 .35161 .74562 .36758 .77634 .37807 .76353 .36332 Metetra
.318 .625 .96 r
.76353 .36332 .77634 .37807 .80717 .38207 .79464 .3681 Metetra
.543 .764 .979 r
.79464 .3681 .80717 .38207 .83771 .37729 .82546 .36348 Metetra
.576 .669 .902 r
.17116 .43031 .18712 .44898 .21006 .44548 .19414 .42697 Metetra
.318 .553 .918 r
.19414 .42697 .21006 .44548 .23251 .45036 .21655 .43257 Metetra
0 .358 .829 r
.21655 .43257 .23251 .45036 .25482 .46185 .23875 .44524 Metetra
0 .2 .699 r
.23875 .44524 .25482 .46185 .27734 .4772 .26114 .46204 Metetra
0 .172 .66 r
.26114 .46204 .27734 .4772 .3004 .49291 .28409 .47926 Metetra
0 .297 .752 r
.28409 .47926 .3004 .49291 .32425 .50528 .30789 .49294 Metetra
.131 .551 .922 r
.30789 .49294 .32425 .50528 .34899 .51096 .33267 .49948 Metetra
.508 .766 .989 r
.33267 .49948 .34899 .51096 .37459 .50761 .35842 .49634 Metetra
.73 .835 .929 r
.35842 .49634 .37459 .50761 .40089 .49432 .38495 .48256 Metetra
.824 .833 .856 r
.38495 .48256 .40089 .49432 .42764 .47186 .41199 .45895 Metetra
.86 .817 .806 r
.41199 .45895 .42764 .47186 .45457 .4425 .43925 .42797 Metetra
.868 .8 .781 r
.43925 .42797 .45457 .4425 .48147 .40955 .46647 .39319 Metetra
.861 .786 .776 r
.46647 .39319 .48147 .40955 .50823 .37677 .49353 .35862 Metetra
.837 .771 .788 r
.49353 .35862 .50823 .37677 .53487 .34774 .52042 .32808 Metetra
.793 .752 .816 r
.52042 .32808 .53487 .34774 .5615 .32536 .54725 .30464 Metetra
.714 .721 .855 r
.54725 .30464 .5615 .32536 .58834 .3115 .57425 .2903 Metetra
.586 .666 .894 r
.57425 .2903 .58834 .3115 .61563 .30685 .60167 .28579 Metetra
.403 .576 .908 r
.60167 .28579 .61563 .30685 .64361 .31084 .62977 .29048 Metetra
.205 .467 .885 r
.62977 .29048 .64361 .31084 .67242 .32165 .65872 .30246 Metetra
.06 .388 .849 r
.65872 .30246 .67242 .32165 .7021 .33644 .68857 .31872 Metetra
.017 .38 .843 r
.68857 .31872 .7021 .33644 .73256 .35161 .71924 .33542 Metetra
.094 .458 .887 r
.71924 .33542 .73256 .35161 .76353 .36332 .75047 .34844 Metetra
.287 .609 .955 r
.75047 .34844 .76353 .36332 .79464 .3681 .78185 .35407 Metetra
.533 .763 .982 r
.78185 .35407 .79464 .3681 .82546 .36348 .81296 .34963 Metetra
.57 .663 .901 r
.15499 .41113 .17116 .43031 .19414 .42697 .17801 .40796 Metetra
.287 .533 .912 r
.17801 .40796 .19414 .42697 .21655 .43257 .20035 .41432 Metetra
0 .312 .798 r
.20035 .41432 .21655 .43257 .23875 .44524 .22241 .42825 Metetra
0 .139 .646 r
.22241 .42825 .23875 .44524 .26114 .46204 .24464 .44662 Metetra
0 .11 .6 r
.24464 .44662 .26114 .46204 .28409 .47926 .26746 .46547 Metetra
0 .239 .701 r
.26746 .46547 .28409 .47926 .30789 .49294 .29119 .48055 Metetra
.075 .518 .9 r
.29119 .48055 .30789 .49294 .33267 .49948 .316 .48801 Metetra
.494 .764 .991 r
.316 .48801 .33267 .49948 .35842 .49634 .34189 .48511 Metetra
.735 .839 .929 r
.34189 .48511 .35842 .49634 .38495 .48256 .36866 .4708 Metetra
.831 .836 .85 r
.36866 .4708 .38495 .48256 .41199 .45895 .39602 .44597 Metetra
.866 .818 .799 r
.39602 .44597 .41199 .45895 .43925 .42797 .42363 .41327 Metetra
.874 .8 .774 r
.42363 .41327 .43925 .42797 .46647 .39319 .4512 .37653 Metetra
.867 .785 .769 r
.4512 .37653 .46647 .39319 .49353 .35862 .47858 .34005 Metetra
.843 .77 .781 r
.47858 .34005 .49353 .35862 .52042 .32808 .50573 .30791 Metetra
.798 .751 .81 r
.50573 .30791 .52042 .32808 .54725 .30464 .53278 .28336 Metetra
.717 .72 .852 r
.53278 .28336 .54725 .30464 .57425 .2903 .55993 .26852 Metetra
.581 .661 .892 r
.55993 .26852 .57425 .2903 .60167 .28579 .58748 .26415 Metetra
.384 .562 .905 r
.58748 .26415 .60167 .28579 .62977 .29048 .61569 .26959 Metetra
.168 .441 .873 r
.61569 .26959 .62977 .29048 .65872 .30246 .64477 .28283 Metetra
.012 .353 .829 r
.64477 .28283 .65872 .30246 .68857 .31872 .67479 .30066 Metetra
0 .342 .82 r
.67479 .30066 .68857 .31872 .71924 .33542 .70566 .319 Metetra
.046 .426 .868 r
.70566 .319 .71924 .33542 .75047 .34844 .73714 .33344 Metetra
.254 .591 .948 r
.73714 .33344 .75047 .34844 .78185 .35407 .76881 .33998 Metetra
.522 .762 .984 r
.76881 .33998 .78185 .35407 .81296 .34963 .80021 .33575 Metetra
.564 .658 .9 r
.13863 .39141 .15499 .41113 .17801 .40796 .16167 .38843 Metetra
.253 .51 .904 r
.16167 .38843 .17801 .40796 .20035 .41432 .18392 .39561 Metetra
0 .261 .761 r
.18392 .39561 .20035 .41432 .22241 .42825 .20582 .41088 Metetra
0 .077 .587 r
.20582 .41088 .22241 .42825 .24464 .44662 .22786 .43092 Metetra
0 .046 .536 r
.22786 .43092 .24464 .44662 .26746 .46547 .25051 .45151 Metetra
0 .178 .643 r
.25051 .45151 .26746 .46547 .29119 .48055 .27414 .46811 Metetra
.015 .479 .873 r
.27414 .46811 .29119 .48055 .316 .48801 .29897 .47657 Metetra
.478 .762 .993 r
.29897 .47657 .316 .48801 .34189 .48511 .32499 .47393 Metetra
.74 .844 .928 r
.32499 .47393 .34189 .48511 .36866 .4708 .35202 .45906 Metetra
.839 .838 .845 r
.35202 .45906 .36866 .4708 .39602 .44597 .37971 .43293 Metetra
.873 .818 .792 r
.37971 .43293 .39602 .44597 .42363 .41327 .4077 .39838 Metetra
.88 .8 .766 r
.4077 .39838 .42363 .41327 .4512 .37653 .43565 .35956 Metetra
.872 .784 .761 r
.43565 .35956 .4512 .37653 .47858 .34005 .46337 .32106 Metetra
.848 .769 .774 r
.46337 .32106 .47858 .34005 .50573 .30791 .49081 .28722 Metetra
.803 .751 .805 r
.49081 .28722 .50573 .30791 .53278 .28336 .51807 .2615 Metetra
.719 .718 .848 r
.51807 .2615 .53278 .28336 .55993 .26852 .54539 .24613 Metetra
.576 .655 .891 r
.54539 .24613 .55993 .26852 .58748 .26415 .57307 .24192 Metetra
.363 .547 .901 r
.57307 .24192 .58748 .26415 .61569 .26959 .60138 .24816 Metetra
.129 .413 .86 r
.60138 .24816 .61569 .26959 .64477 .28283 .63057 .26275 Metetra
0 .316 .805 r
.63057 .26275 .64477 .28283 .67479 .30066 .66073 .28226 Metetra
0 .302 .792 r
.66073 .28226 .67479 .30066 .70566 .319 .69181 .30235 Metetra
0 .39 .846 r
.69181 .30235 .70566 .319 .73714 .33344 .72353 .31833 Metetra
.217 .571 .94 r
.72353 .31833 .73714 .33344 .76881 .33998 .75548 .32586 Metetra
.511 .76 .986 r
.75548 .32586 .76881 .33998 .80021 .33575 .78718 .32186 Metetra
.557 .652 .898 r
.12206 .37112 .13863 .39141 .16167 .38843 .14512 .36834 Metetra
.216 .485 .894 r
.14512 .36834 .16167 .38843 .18392 .39561 .16726 .3764 Metetra
0 .206 .717 r
.16726 .3764 .18392 .39561 .20582 .41088 .18897 .39311 Metetra
0 .013 .523 r
.18897 .39311 .20582 .41088 .22786 .43092 .21077 .41494 Metetra
.53 .017 0 r
.21077 .41494 .22786 .43092 .25051 .45151 .23322 .43741 Metetra
0 .114 .58 r
.23322 .43741 .25051 .45151 .27414 .46811 .25673 .45564 Metetra
0 .436 .84 r
.25673 .45564 .27414 .46811 .29897 .47657 .28155 .46518 Metetra
.46 .759 .994 r
.28155 .46518 .29897 .47657 .32499 .47393 .30771 .46282 Metetra
.745 .849 .927 r
.30771 .46282 .32499 .47393 .35202 .45906 .335 .44736 Metetra
.846 .84 .839 r
.335 .44736 .35202 .45906 .37971 .43293 .36305 .41983 Metetra
.879 .818 .784 r
.36305 .41983 .37971 .43293 .4077 .39838 .39145 .38332 Metetra
.886 .799 .758 r
.39145 .38332 .4077 .39838 .43565 .35956 .41981 .34227 Metetra
.878 .783 .753 r
.41981 .34227 .43565 .35956 .46337 .32106 .4479 .30162 Metetra
.854 .769 .767 r
.4479 .30162 .46337 .32106 .49081 .28722 .47564 .26598 Metetra
.807 .75 .799 r
.47564 .26598 .49081 .28722 .51807 .2615 .50314 .23903 Metetra
.722 .716 .845 r
.50314 .23903 .51807 .2615 .54539 .24613 .53063 .22311 Metetra
.57 .65 .889 r
.53063 .22311 .54539 .24613 .57307 .24192 .55841 .21906 Metetra
.34 .53 .896 r
.55841 .21906 .57307 .24192 .60138 .24816 .58682 .22617 Metetra
.088 .383 .844 r
.58682 .22617 .60138 .24816 .63057 .26275 .61611 .24218 Metetra
0 .276 .778 r
.61611 .24218 .63057 .26275 .66073 .28226 .64641 .2635 Metetra
0 .259 .762 r
.64641 .2635 .66073 .28226 .69181 .30235 .67767 .28548 Metetra
0 .352 .82 r
.67767 .28548 .69181 .30235 .72353 .31833 .70963 .3031 Metetra
.177 .547 .929 r
.70963 .3031 .72353 .31833 .75548 .32586 .74187 .3117 Metetra
.498 .758 .988 r
.74187 .3117 .75548 .32586 .78718 .32186 .77387 .30796 Metetra
.55 .645 .897 r
.1053 .35025 .12206 .37112 .14512 .36834 .12836 .34769 Metetra
.175 .457 .882 r
.12836 .34769 .14512 .36834 .16726 .3764 .15037 .35669 Metetra
0 .147 .669 r
.15037 .35669 .16726 .3764 .18897 .39311 .17184 .37493 Metetra
.541 .05 0 r
.17184 .37493 .18897 .39311 .21077 .41494 .19338 .39868 Metetra
.591 .079 0 r
.19338 .39868 .21077 .41494 .23322 .43741 .21558 .42315 Metetra
.482 0 0 r
.21558 .42315 .23322 .43741 .25673 .45564 .23893 .44314 Metetra
0 .387 .799 r
.23893 .44314 .25673 .45564 .28155 .46518 .26373 .45384 Metetra
.441 .755 .995 r
.26373 .45384 .28155 .46518 .30771 .46282 .29002 .4518 Metetra
.751 .854 .926 r
.29002 .4518 .30771 .46282 .335 .44736 .31758 .43571 Metetra
.854 .842 .833 r
.31758 .43571 .335 .44736 .36305 .41983 .34602 .40669 Metetra
.886 .818 .776 r
.34602 .40669 .36305 .41983 .39145 .38332 .37486 .36808 Metetra
.892 .798 .75 r
.37486 .36808 .39145 .38332 .41981 .34227 .40367 .32466 Metetra
.883 .782 .745 r
.40367 .32466 .41981 .34227 .4479 .30162 .43216 .28172 Metetra
.859 .767 .76 r
.43216 .28172 .4479 .30162 .47564 .26598 .46023 .24418 Metetra
.812 .749 .793 r
.46023 .24418 .47564 .26598 .50314 .23903 .48798 .21591 Metetra
.724 .715 .841 r
.48798 .21591 .50314 .23903 .53063 .22311 .51563 .19941 Metetra
.565 .644 .887 r
.51563 .19941 .53063 .22311 .55841 .21906 .54353 .19556 Metetra
.316 .513 .89 r
.54353 .19556 .55841 .21906 .58682 .22617 .57202 .20359 Metetra
.043 .349 .825 r
.57202 .20359 .58682 .22617 .61611 .24218 .60139 .22113 Metetra
0 .233 .748 r
.60139 .22113 .61611 .24218 .64641 .2635 .6318 .24437 Metetra
0 .214 .727 r
.6318 .24437 .64641 .2635 .67767 .28548 .66323 .26838 Metetra
0 .31 .79 r
.66323 .26838 .67767 .28548 .70963 .3031 .69543 .28777 Metetra
.134 .521 .915 r
.69543 .28777 .70963 .3031 .74187 .3117 .72796 .29754 Metetra
.484 .756 .99 r
.72796 .29754 .74187 .3117 .77387 .30796 .76027 .29408 Metetra
.542 .638 .895 r
.08834 .32876 .1053 .35025 .12836 .34769 .1114 .32644 Metetra
.13 .425 .867 r
.1114 .32644 .12836 .34769 .15037 .35669 .13325 .33644 Metetra
0 .086 .614 r
.13325 .33644 .15037 .35669 .17184 .37493 .15445 .35631 Metetra
.602 .11 0 r
.15445 .35631 .17184 .37493 .19338 .39868 .17567 .38211 Metetra
.646 .138 0 r
.17567 .38211 .19338 .39868 .21558 .42315 .19758 .40875 Metetra
.546 .013 0 r
.19758 .40875 .21558 .42315 .23893 .44314 .22073 .43063 Metetra
0 .332 .751 r
.22073 .43063 .23893 .44314 .26373 .45384 .24548 .44259 Metetra
.419 .749 .994 r
.24548 .44259 .26373 .45384 .29002 .4518 .2719 .4409 Metetra
.757 .859 .925 r
.2719 .4409 .29002 .4518 .31758 .43571 .29976 .42414 Metetra
.861 .844 .826 r
.29976 .42414 .31758 .43571 .34602 .40669 .32861 .39353 Metetra
.892 .818 .768 r
.32861 .39353 .34602 .40669 .37486 .36808 .35793 .35267 Metetra
.897 .797 .741 r
.35793 .35267 .37486 .36808 .40367 .32466 .38723 .30672 Metetra
.888 .781 .737 r
.38723 .30672 .40367 .32466 .43216 .28172 .41615 .26134 Metetra
.864 .766 .752 r
.41615 .26134 .43216 .28172 .46023 .24418 .44458 .22178 Metetra
.817 .748 .786 r
.44458 .22178 .46023 .24418 .48798 .21591 .47258 .19214 Metetra
.727 .713 .837 r
.47258 .19214 .48798 .21591 .51563 .19941 .50041 .17503 Metetra
.558 .637 .885 r
.50041 .17503 .51563 .19941 .54353 .19556 .52841 .17138 Metetra
.29 .493 .883 r
.52841 .17138 .54353 .19556 .57202 .20359 .55696 .18039 Metetra
0 .314 .804 r
.55696 .18039 .57202 .20359 .60139 .22113 .5864 .19956 Metetra
0 .188 .715 r
.5864 .19956 .60139 .22113 .6318 .24437 .61691 .22486 Metetra
0 .167 .689 r
.61691 .22486 .6318 .24437 .66323 .26838 .6485 .25105 Metetra
0 .265 .756 r
.6485 .25105 .66323 .26838 .69543 .28777 .68092 .27235 Metetra
.087 .492 .898 r
.68092 .27235 .69543 .28777 .72796 .29754 .71373 .28337 Metetra
.468 .753 .992 r
.71373 .28337 .72796 .29754 .76027 .29408 .74636 .28023 Metetra
.534 .631 .893 r
.07119 .30663 .08834 .32876 .1114 .32644 .09423 .30457 Metetra
.08 .389 .849 r
.09423 .30457 .1114 .32644 .13325 .33644 .11589 .31563 Metetra
0 .023 .555 r
.11589 .31563 .13325 .33644 .15445 .35631 .13678 .33725 Metetra
.657 .168 0 r
.13678 .33725 .15445 .35631 .17567 .38211 .15763 .36525 Metetra
.695 .193 0 r
.15763 .36525 .17567 .38211 .19758 .40875 .1792 .3942 Metetra
.605 .074 0 r
.1792 .3942 .19758 .40875 .22073 .43063 .20212 .41812 Metetra
0 .274 .697 r
.20212 .41812 .22073 .43063 .24548 .44259 .22679 .43144 Metetra
.394 .743 .992 r
.22679 .43144 .24548 .44259 .2719 .4409 .25333 .43014 Metetra
.763 .864 .924 r
.25333 .43014 .2719 .4409 .29976 .42414 .2815 .41266 Metetra
.868 .846 .819 r
.2815 .41266 .29976 .42414 .32861 .39353 .3108 .38034 Metetra
.898 .818 .76 r
.3108 .38034 .32861 .39353 .35793 .35267 .34065 .33708 Metetra
.903 .796 .733 r
.34065 .33708 .35793 .35267 .38723 .30672 .37047 .28843 Metetra
.893 .78 .729 r
.37047 .28843 .38723 .30672 .41615 .26134 .39987 .24047 Metetra
.869 .765 .745 r
.39987 .24047 .41615 .26134 .44458 .22178 .42868 .19877 Metetra
.822 .746 .78 r
.42868 .19877 .44458 .22178 .47258 .19214 .45696 .16767 Metetra
.73 .711 .833 r
.45696 .16767 .47258 .19214 .50041 .17503 .48496 .14993 Metetra
.552 .63 .883 r
.48496 .14993 .50041 .17503 .52841 .17138 .51305 .1465 Metetra
.261 .472 .875 r
.51305 .1465 .52841 .17138 .55696 .18039 .54166 .15656 Metetra
0 .275 .78 r
.54166 .15656 .55696 .18039 .5864 .19956 .57113 .17747 Metetra
0 .142 .678 r
.57113 .17747 .5864 .19956 .61691 .22486 .60172 .20497 Metetra
0 .118 .648 r
.60172 .20497 .61691 .22486 .6485 .25105 .63344 .23349 Metetra
0 .219 .718 r
.63344 .23349 .6485 .25105 .68092 .27235 .66608 .25684 Metetra
.036 .459 .878 r
.66608 .25684 .68092 .27235 .71373 .28337 .69917 .26923 Metetra
.451 .749 .993 r
.69917 .26923 .71373 .28337 .74636 .28023 .73212 .26643 Metetra
.525 .623 .891 r
.05385 .28383 .07119 .30663 .09423 .30457 .07687 .28205 Metetra
.026 .35 .827 r
.07687 .28205 .09423 .30457 .11589 .31563 .09831 .29425 Metetra
0 0 .492 r
.09831 .29425 .11589 .31563 .13678 .33725 .11883 .31773 Metetra
.706 .222 0 r
.11883 .31773 .13678 .33725 .15763 .36525 .13926 .34807 Metetra
.738 .243 0 r
.13926 .34807 .15763 .36525 .1792 .3942 .16043 .3795 Metetra
.657 .132 0 r
.16043 .3795 .1792 .3942 .20212 .41812 .18306 .40562 Metetra
0 .212 .636 r
.18306 .40562 .20212 .41812 .22679 .43144 .20764 .42042 Metetra
.366 .734 .989 r
.20764 .42042 .22679 .43144 .25333 .43014 .23429 .41954 Metetra
.769 .87 .922 r
.23429 .41954 .25333 .43014 .2815 .41266 .26278 .40129 Metetra
.876 .847 .812 r
.26278 .40129 .2815 .41266 .3108 .38034 .29257 .36715 Metetra
.904 .817 .751 r
.29257 .36715 .3108 .38034 .34065 .33708 .32299 .32131 Metetra
.908 .795 .725 r
.32299 .32131 .34065 .33708 .37047 .28843 .35339 .26979 Metetra
.898 .778 .721 r
.35339 .26979 .37047 .28843 .39987 .24047 .3833 .21908 Metetra
.874 .764 .737 r
.3833 .21908 .39987 .24047 .42868 .19877 .41252 .17512 Metetra
.827 .745 .773 r
.41252 .17512 .42868 .19877 .45696 .16767 .4411 .14249 Metetra
.733 .709 .828 r
.4411 .14249 .45696 .16767 .48496 .14993 .46928 .12408 Metetra
.544 .623 .881 r
.46928 .12408 .48496 .14993 .51305 .1465 .49746 .12089 Metetra
.231 .449 .866 r
.49746 .12089 .51305 .1465 .54166 .15656 .52609 .13206 Metetra
0 .235 .753 r
.52609 .13206 .54166 .15656 .57113 .17747 .55559 .15482 Metetra
0 .094 .638 r
.55559 .15482 .57113 .17747 .60172 .20497 .58622 .18467 Metetra
0 .069 .604 r
.58622 .18467 .60172 .20497 .63344 .23349 .61806 .21569 Metetra
0 .17 .677 r
.61806 .21569 .63344 .23349 .66608 .25684 .6509 .24126 Metetra
0 .423 .853 r
.6509 .24126 .66608 .25684 .69917 .26923 .68427 .25512 Metetra
.432 .744 .993 r
.68427 .25512 .69917 .26923 .73212 .26643 .71755 .25272 Metetra
.515 .615 .889 r
.03634 .26033 .05385 .28383 .07687 .28205 .05931 .25885 Metetra
0 .307 .8 r
.05931 .25885 .07687 .28205 .09831 .29425 .08049 .27226 Metetra
.567 .101 0 r
.08049 .27226 .09831 .29425 .11883 .31773 .1006 .29772 Metetra
.748 .272 0 r
.1006 .29772 .11883 .31773 .13926 .34807 .12055 .33057 Metetra
.774 .289 0 r
.12055 .33057 .13926 .34807 .16043 .3795 .14125 .36467 Metetra
.703 .185 0 r
.14125 .36467 .16043 .3795 .18306 .40562 .16354 .39315 Metetra
.409 0 0 r
.16354 .39315 .18306 .40562 .20764 .42042 .18798 .40954 Metetra
.334 .723 .983 r
.18798 .40954 .20764 .42042 .23429 .41954 .21474 .40913 Metetra
.776 .876 .92 r
.21474 .40913 .23429 .41954 .26278 .40129 .24358 .39007 Metetra
.883 .848 .805 r
.24358 .39007 .26278 .40129 .29257 .36715 .2739 .35396 Metetra
.91 .816 .743 r
.2739 .35396 .29257 .36715 .32299 .32131 .30494 .30538 Metetra
.912 .794 .716 r
.30494 .30538 .32299 .32131 .35339 .26979 .33597 .25079 Metetra
.903 .777 .713 r
.33597 .25079 .35339 .26979 .3833 .21908 .36645 .19716 Metetra
.879 .762 .729 r
.36645 .19716 .3833 .21908 .41252 .17512 .39612 .1508 Metetra
.832 .744 .767 r
.39612 .1508 .41252 .17512 .4411 .14249 .42501 .11655 Metetra
.735 .707 .824 r
.42501 .11655 .4411 .14249 .46928 .12408 .45337 .09744 Metetra
.537 .615 .878 r
.45337 .09744 .46928 .12408 .49746 .12089 .48163 .09452 Metetra
.198 .424 .855 r
.48163 .09452 .49746 .12089 .52609 .13206 .51028 .10687 Metetra
0 .192 .722 r
.51028 .10687 .52609 .13206 .55559 .15482 .53976 .1316 Metetra
0 .046 .596 r
.53976 .1316 .55559 .15482 .58622 .18467 .57041 .16396 Metetra
0 .02 .558 r
.57041 .16396 .58622 .18467 .61806 .21569 .60233 .19767 Metetra
0 .12 .633 r
.60233 .19767 .61806 .21569 .6509 .24126 .63535 .22562 Metetra
0 .383 .824 r
.63535 .22562 .6509 .24126 .68427 .25512 .669 .24108 Metetra
.41 .739 .992 r
.669 .24108 .68427 .25512 .71755 .25272 .70262 .2391 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.17627 .20066 m
.18085 .20537 L
s
[(-5)] .16712 .19126 .97284 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.52102 .06567 m
.52496 .07092 L
s
[(5)] .51313 .05518 .75163 1 Mshowa
.125 Mabswid
.20879 .18793 m
.2115 .19079 L
s
.24172 .17504 m
.2444 .17792 L
s
.27507 .16198 m
.27771 .1649 L
s
.30885 .14875 m
.31146 .1517 L
s
.37773 .12178 m
.38026 .1248 L
s
.41285 .10803 m
.41534 .11108 L
s
.44843 .0941 m
.45088 .09718 L
s
.48448 .07998 m
.48689 .08309 L
s
.14416 .21324 m
.14694 .21603 L
s
.11245 .22566 m
.11526 .22842 L
s
.08113 .23792 m
.08396 .24065 L
s
.05019 .25004 m
.05305 .25274 L
s
.55805 .05117 m
.56037 .05435 L
s
.59558 .03648 m
.59785 .03969 L
s
.63363 .02158 m
.63585 .02483 L
s
.67219 .00648 m
.67437 .00976 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{223, 203.875},
  ImageMargins->{{60.3125, 0}, {0, 0.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003O0000ba000`40O003h00Oggoo003OOol00=mo
o`00ggoo003OOol00=moo`00ggoo003OOol00=moo`00ggoo003OOol00=moo`00ggoo003OOol00=mo
o`00ggoo003OOol00=moo`00ggoo002ROol2000kOol00:5oo`04001oogoo000jOol00:5oo`04001o
ogoo000jOol00:5oo`04001oogoo000jOol00:5oo`04001oogoo000jOol009aoo`8000Aoo`8003]o
o`00VWoo1@00@7oo002GOol40002Ool20010Ool007Moo`8001aoo`8000Ioo`03001oo`0003moo`00
MWoo00@007ooOol001Qoo`<000Qoo`04001oogoo000nOol007Uoo`03001oogoo01Aoo`800003Ool0
07oo00Qoo`04001oogoo000nOol004Moo`800003Ool0000002]oo`8001Aoo`<000eoo`05001oogoo
Ool0000mOol004Qoo`03001oo`0002aoo`03001oogoo015oo`80011oo`03001oogoo009oo`03001o
ogoo03Yoo`00BGoo00<007ooOol0:goo0`003Woo10004Goo00<007ooOol00Woo00<007ooOol0>Woo
0017Ool200000goo0000000iOol3000FOol01000Oomoogoo0P00>goo0023Ool2000IOol00`00Oomo
o`03Ool00`00Oomoo`0hOol0081oo`<00003Ool007oo01Qoo`03001oogoo00=oo`03001oogoo03Qo
o`00OWoo0P007Woo00<007ooOol017oo00<007ooOol0=goo001kOol3000POol00`00Oomoo`05Ool0
0`00Oomoo`0fOol007Uoo`80009oo`03001oogoo01ioo`03001oogoo00Eoo`03001oogoo03Ioo`00
MWoo0`009Goo00<007ooOol01Woo00<007ooOol0=Goo001dOol2000XOol00`00Oomoo`07Ool00`00
Oomoo`0dOol005=oo`8001aoo`<00003Ool007oo02Moo`03001oogoo00Moo`03001oogoo03Aoo`00
DWoo00@007ooOol001Uoo`8002eoo`03001oogoo00Qoo`03001oogoo03=oo`00DWoo00@007ooOol0
01Ioo`X002Qoo`03001oogoo00Uoo`03001oogoo039oo`00DWoo00@007ooOol001Aoo`800009Ool0
05kJ0012Nd9KAW]2Fd9k00@002Eoo`03001oogoo00Uoo`03001oogoo039oo`00DWoo00@007ooOol0
015oo`<00006Ool00000G]UJ^@000T9k00M2Fd9k@W/001FJ5KXEVP02000SOol00`00Oomoo`0:Ool0
0`00Oomoo`0aOol005=oo`80011oo`<0009oo`0B001J^EkJF[UNfUZi0012Fd9k@U]6Nd9K000EVQVk
5IXI^`008Woo00<007ooOol02Woo00<007ooOol0<Goo001ROol30004Ool02@00F[UNfEZiG]UJ^EkI
F[T00002@W/01d9K@W/001Fj5IXE^QFJ0080025oo`03001oogoo00]oo`03001oogoo031oo`00Ggoo
0`001Woo00d006KG001J^EkJF[UNfUZiG]X004Ik@U]2N`0400000aFJ6K/EVP03000OOol00`00Oomo
o`0<Ool00`00Oomoo`0_Ool005eoo`@000Ioo`0;001Vmf[h001NfEZiG]UJ^EkIF[UNf@0300000dIk
@W]2N`0500020;H00`00Oomoo`0MOol00`00Oomoo`0;Ool2000`Ool005Yoo`<000Uoo`0:001Vef[h
I]MZn000G]YJ^EkJF[T200002UkJ0016O49kAW]2F`006KXMfaVj0P000P2f00<007ooOol077oo00<0
07ooOol037oo00<007ooOol0;Woo001HOol2000<Ool02000J_QVmf[hI_L005ZiG]T2000015ZiF]UJ
f@000d9k00Q6Nd9k000I^afk6KXI^`000P2f00<007ooOol06goo00<007ooOol03Goo00<007ooOol0
;Goo001EOol300000goo001oo`0:Ool01`00J_QVef[hI]MZn6KG0080000@G]YJ^EkJF[UNfUZi0012
FdIl@W]6N`007M/I^QgK6KX200000`2f0000000LOol00`00Oomoo`0=Ool00`00Oomoo`04Ool4000U
Ool005=oo`8000moo`0;001Zn6KgJ_QVmf[hI_L006Kh001J^@02F]T01EkJF[UJf@00AW/00T9k1000
00<I^afk6KX01@006goo00<007ooOol03Woo00<007ooOol00goo00<007ooOol09Woo000bOol2000L
Ool3000@Ool04P00J_QVef[hI]MZn6KG001Vef[h001NfUZiG]YJ^EkJF[UNfP<00003AYa2NdIl00D0
00040?L0e`00000KOol00`00Oomoo`0?Ool00`00Oomoo`03Ool00`00Oomoo`0UOol0035oo`04001o
ogoo000IOol2000BOol03`00KaH006[hI_MZn6Kg001Vn6[hI_MVn000G]YJ^@02F]T2000015[J0016
Nd9k0TIk00@001gK7M/Mf`8000040?L0e`00000JOol00`00Oomoo`0?Ool00`00Oomoo`04Ool00`00
Oomoo`0TOol003Aoo`03001oogoo01Aoo`<001Aoo`0?001^mP00I]MZn6KGJ_P006[hI]MZn6KG001J
^EkJ0080000>F[UNfUZi0012NdIl@W]6W49k000MfR7K7M/Qf`8000030=L0000001Uoo`03001oogoo
011oo`05001oogooOol00002Ool00`00Oomoo`0SOol002]oo`@000=oo`8001Eoo`800003Ool007oo
01=oo`0:001^mVkfK_H006KgJ_P006[hI_L2I_P01V[hI_L00000F]YJf@=JfP07F]T004IkAW]2NdIk
000011gK00@0004H0000e`8001Qoo`03001oogoo00moo`<000=oo`8002Ioo`00<Woo00<007ooOol0
4Goo0`005goo01/006kfKaM^mW<G001Zn000J_QVef[hI]MZn6KG001Ve`00F[UNfUZiG]YJ^EkJ0016
W49kAW`0100000DMfR7K7M/0003g00@001Moo`03001oogoo015oo`03001oogoo02Uoo`00<Woo0`00
3goo0P006Woo00@006kfK_I_5P9^mP03001Zn6Kg009Vn006J_QVmfKh001Vn0000e[J00AJfE[JF]YJ
fP<00003AY]6NdIk00D000<160<001Ioo`03001oogoo019oo`03001oogoo02Qoo`00@Goo0`006goo
01L006lGK_Ic5fkfKaL006lG001Zn6KGJ_QVef[h001Zn6KHJ_P005kJF[UNfUZi0080000:G]X004JL
@W]6W49k000QfbGl8M/200000`4H0?L16003000EOol00`00Oomoo`0COol00`00Oomoo`0WOol003io
o`<001eoo`04001^mVkfKaH3K_H02000K_I^m`00J_QVmfKh0004I_P00`00F]UJfP020003F]X01`00
AW]6NdIkAY]6N`0000@Qn`8000030AP00000008001Aoo`03001oogoo01=oo`03001oogoo02Moo`00
?7oo0`007goo01@006kfLaM^mVlGK_H006kfKaMZmP00I]MZn000J_QVf6[hI]MZn6KH0P0001ANfUZi
G]YJ^EkJF[T0049kAYa2NdJL000Uo27K9O`Qf`000CP0003g10004goo00<007ooOol057oo00<007oo
Ool05Woo0P003Woo000jOol2000QOol00`00K_I_5P03K_H02FlF001^mfkfKaM^mP00I_P00005I_P0
0`00I_P00006F]X01000AY]6NdIk10000b7k00D0004i0000002E00<0019oo`03001oogoo01Eoo`03
001oogoo01Aoo`04001oogoo000=Ool003Moo`<0029oo`0O001^m@00K_I_5fkfLaL006lGJ_I_5fkf
KaMZmP00I]QZn6KGJ_QVf000I]QZn@00G]YJ^EkJF[UNfUZiG]X00`0000=6W4IkAY`01@0000D1>@4h
0CT0002E00<0015oo`03001oogoo01Eoo`03001oogoo01Aoo`03001oogoo00ioo`00=Goo0P0000=o
o`00Ool08Woo010007<FLaH006kfKaI^mP00K_I_5fkfK_M^mP00K_L000=Vn003001Vn6Kh009Vn003
001JfU[J009JfP800007F]X004JLAW]6VdIk00000bGk0P000`4i00<0002E00000P004Goo00<007oo
Ool05Goo00<007ooOol04Woo1@003Goo000aOol4000VOol05P00LaIbmG<F001c5fkf001ZmVlGK_I_
5f[f001ZmVlGJ_H006KHJ_P006[i0VKh00AVf000F[UNfP80009JfP0<F[UNfP00AYa6NdJLAW/002Gk
9Q`UnbHL0P0000@1>04i0000U@@000moo`03001oogoo01Ioo`03001oogoo019oo`03001oogoo00io
o`00;goo1000:7oo00<007<FLaH00W<F00T006kf001_5fkfK_M^mVlG00000Vkg00A_5`00I_P000IV
n08000IJfP070016NdJLAW]6V`009Q`00bGk00<V700000001P0000<0L`00Ool03Goo00<007ooOol0
5Woo00<007ooOol08goo000]Ool2000[Ool05@00L_Ec5VkeLaIbmG<F001_5fkfKaMZmVlG001_5f[f
KaMZmVlG001Zn@02I_P01VKHJ_UVn000H]P0009JfP05F[UNfU[JF]YJ^@0800001BHL9O/000EI1GX0
0P0000<0]@0000000`003Goo00<007ooOol05goo00<007ooOol08Woo000ZOol3000]Ool00`00LaIc
5P03LaH01`00LaH006kgK_I_5`00009^m`06KaM^mfkg001_5`0016Kh00@006KhI_T000EJfP800004
F]X004JKAY`2AY/00`00:Q`0000300031ET010000;H0001d0`0037oo00<007ooOol067oo00<007oo
Ool08Goo000XOol2000_Ool08000LaI^mG<FL_Ec5Vke001_5W<F001_5`00KaMZmVlGJ_I_5`00KaMZ
m`00I]QZnFKh001Rf6KiI_QVn@00G]X2F]X03`00F]YJfU[J001:W4IkAYa6NdZL000Z72Gk:Q`Z6`02
00001PEj1ET0002e0000D`@000Yoo`03001oogoo01Qoo`03001oogoo025oo`0097oo1000<Goo00<0
07<FLaH00g<F00T006lFLaIc5P00K_H006kgKaL00fkg00D006[gKaM^m`00009Vn003001VnFKh009V
n004001JfP000005F]X01P00AY]6VdJLAY/0008Z7003:Q/Z72XL00L0000307@0000000<000Qoo`03
001oogoo01Uoo`03001oogoo021oo`008goo0`00<Woo028006keLaIbmG<FK_Ec5P00LaI^mW<FKaH0
06[fKaMZmVlGJ_H006[gKaMZmflG001Vn000I_UVn6KiH]QVnFKh001J^P=JfP07F[YJfU[J0016NdZL
AW/01@0000DUnbXL0009VPEj008000030?L0000000@000030GT0000000L001Yoo`03001oo`00025o
o`0087oo0`00=Goo00<007<FLaH00g<F00P007<FLaIc5VlF001_5P000fkg00T006[gKaM^mflGJ_M_
5`00I_T00fKh00EVnFKh001Vn00000MJfP<00005AY]:W4JK000Z700400032GX300000`2E0000eP03
00000`5i000bo`02<_l00c;N00000002000JOol00`00Oomoo`0OOol001ioo`8003Moo`0U001c5W;e
LaI^mG<F001c5VkfLaI_5W<F001c5flF001ZmP00J_M_5f[gKaMZmflG001_6000I_URf6KiI_P006;H
I_URn000F[X00e[J0P0000aJfP00AW]:W4JKBY`002hl:Q/^?2XK;S`200000`Ej2IX0000400000`3F
0000000600000c;N00000002000JOol00`00Oomoo`0NOol001aoo`8003Qoo`03001c=P0000Ac5P0N
001c5W<FKaIc5P00LaI_5W<F001_5`00KaM^mflGJ_M_5`00KaMZmf/G001VnFKh001Vn6KiI_QVn@00
0U[J0P0015[J00`004JKAYa6VdZL000^?2XL;S`Z70003IX300000`4H0000000300000`3F00000005
00001CKo000focKo00006Woo00<007ooOol07Goo000LOol5000eOol09@00LaIc=P00LaIbm@00K_Ic
5VlFLaH007<GKaIc5fkfLaL006lGJ_M_5f[gKaL006lHJ_M_66[g001Vn000H]QVnF;hI_URf6Ki0080
000DF[YJfe[JF]YJ^U[K001:W4IkBYa6V`00:Q/^?2XK;S`Z6`003IX=V`8000030?P1600000H0000:
0K/003Ko<]hfoc;N000bgSKo000IOol00`00Oomoo`0MOol001Aoo`@000Aoo`800003?U/nNcik0080
039oo`0:001c5W<FLaIc=P00LaH007<FKaH2LaH07000KaIc5VlFLaH006lG001_5f[gKaM^m`00J_M[
5f[gKaMZm`00I_QVnFKhI_UVn6Ki001Vn@001e[J200000LZ72hl000=V`fJ3I/=VP0400000`3F0001
5`050004=_l4000IOol00`00Oomoo`0LOol001Aoo`03001oogoo00Aoo`800005Ool003iK@W`nF`03
000`Ool0;@00LcIc5GLfLaIc=P00LaI_5W<FK_H006lFLaM^mW<GKaH006kfLaL006lGJ_L006[gKaQZ
mflHJ_L006[g001Rn6KiH]QVn@00I_URn6Ki001JfUZjF]]JfP0300001dJKBYa6VdZlAY/002hK00P0
00050CT0004H0000e`0200000`3g0000000500001CKN000foS[o000067oo0P007Goo000EOol00`00
Oomoo`03Ool01P00Oomoo`00@W`nF`8nN`030001>00002ioo`04001c5W<FLcH2LaH00`00LcH00002
LaH06P00KaIc5VlFLaI_5P00KaIc5flF001^m`00J_M[5f[gKaMZm`00J_M[66[g001Vn6Ki0003I_T0
16;i001JfU[J0P000e[J00L004JKBYa6VdZLAY/00002;S`500000`fK0001>@0<00000cKo>_l00002
=_l00c[o001oo`0GOol00`00Oomoo`0KOol000ioo`@000Aoo`03001oogoo009oo`04001oogooOol6
00000`4H001oo`0/Ool0:P00LaEg=W<FLcIc5@00LaIc=P00LaH007<GK_Ic5flF001^mW<GKaIc5fkf
001ZmflHJ_M_66[g001ZmflHJ_M_6000I_T006KiH_QVnF;hI_URn080000;F]]FfU[KF]YJf`00B[a6
VdZLAY]:_00300001C8l;S`b?0005K/00P0000P1>04i0CP0003g0001>04i0P0000<5f`Wl00002000
67oo00<007ooOol01Goo0`004Woo000DOol01000Oomoo`000goo00<007ooOol00Woo00D0049l@W]2
O49k008002aoo`03001c5W<f00=c5P0N001c5W<FLaIc=P00LaI_5W<FKaIc5P00LaM_5VlGKaH006lG
001ZmflGJ_M[5`00JaQZmf/HJ_M[60000fKi00IRnFKiI_T006;i0006F]X00`00BY`000060002;S`0
10004K/A^a6k0P000P4i0`000`4h0P0000<9o0WK00000S[o00D003[o>_ljo`0001Qoo`03001oogoo
00Eoo`03001oogoo015oo`005Goo0P0017oo00<007ooOol00Woo00D003ik@W`nFd9l00<002]oo`0b
001g=W<FLcIc5GLf001c=W<FLcL007<g001c5flFLaL007<GKaIc5fkfLaL007<GKaH006[gKaP006lH
J_M_66[gKaP006/H001VnF;hI_URn000H_UVn@00F]]JfU[KE]YJf`D00005B[a6VdZl000bG0050000
1aFk4K/000000CT0004i00<000030CT1600000@00006>_hjo`00>_ljoP0067oo00<007ooOol00Woo
1@004Woo000KOol00`00Oomoo`03Ool02000@W]2O49k@W`000EJ000YOol00`00LcIc5P02LaH04W<f
001c5W<FLcIc5P00LaIc=`00LaH007<GKaI_5flFLaL000=_5`0=001[5`00JaQZmf/HJ_M[6000JaQZ
n6/H00000VKi00L006;iI_URnFKi001JfP0400002U[J001:VdZLBY]:W4ZKBY`0039L0c8l100000D5
FP000000004h00D000<>70P001Qoo`05001oogooOol00002Ool00`00Oomoo`0AOol001Yoo`03001o
ogoo00Aoo`090012O3ik@W`nF`000ET5FP0002Qoo`0]001c5W<fLaEg=P00LcIc5W<gLaH006lFLcMc
5P00K_H006lFLaM^mW<GKaH006lFLaM_5W<G001_66[gKaQZmflH001[66[gKaQZm`00H_P006;iI_UR
n6Ki00D0000BF]]FfU[KE]X004JKB[a6VdZlAY/0038l<U`^?39L000Ig1Fk0P0000P5NP5I0000004i
0AP0005I0`0000T=o18M3O`003[n000joSlO>_h00P005goo00L007ooOomoo`00Ool0000COol001Yo
o`03001oogoo00Eoo`H000031ET0000002Ioo`09001c5W<FLaIc=W<F001c5W<f009c5P03001c=g<F
009c5P07001_5VlGKaIc5flF000016lG010006lG001[66[gJaQZm`00J_Q[66[hJaQZn000H_UVn@<0
0003I_URn@0000IJfP05001:W4ZKBYa:V`050002<S`010006M/EfaWK0P0000D1F@000000004H0080
00030ET0000000@00004>_l003[n>_l3000EOol20004Ool2000COol001Yoo`8000Moo`050012W49k
@Wa2N`04000TOol07@00LcH007<EMcIc5P00LaIc=g<FLcH007<gLaIc=flF001_5P00K_Ic5flFLaL0
07<GKaIc5flF00000VlG00T006lHJ_L006[gKaQZmf/HJ_L0100000eVnF;iI_URn000H_T005KJF]]F
fU[KE]YJf`0400001DZKB[a6V`00<S`0100000<Ig1Fk6M`0100000<1F@000000100000<F?A8L5Sd0
1@0000@o7ckn?al001Ioo`03001oogoo01Ioo`006Woo00<007ooOol01goo00D0049l@W]2O49k0080
0003G@0007oo029oo`03001c=g<g00800003LaH007<f009c5P03001c=g<F009c5P08LcL007<gLaL0
06lFKaL000A_5`0;001_5flGKaL006[g001Zn6/HJ_Q[60030002JaP00`00H_UVn@020003H_T01000
F]YJfU[J0P0000AJfP00B[a:V`9:W006B[`0039L<U`fG39L1@0000@5NPFJ00000081F@8000070GX0
0000000F7AHm4Q`00P0000Hnockn?_lnoSko000FOol00`00Oomoo`0EOol001=oo`8000Eoo`03001o
ogoo00Qoo`090012W49k@W`000VK001M0000025oo`0L001c=g<fLcMc=W<g001c=g<FLcIc5P00LaIc
=flFLcL007<gKaIc=flF001^mP00KaIc5flF0005KaL00`00J_M_600400003V[hJaQVmf/H001Vn@00
I_URnFKiH_UVn@00F]/200004UKJF]]FfU[k001:_4JKB[a:VdZl000fGC8l=U`b?0006M/Mo0800003
1GX5VPEj008000050ET1>@000001VP05000013lO000o7c[n10005Goo00<007ooOol05Goo000BOol0
1000Oomoo`000goo0P002goo1P0000=M000000007goo00<007<gLcL00g<g00<007<g00000W<F00d0
07<FLaIc5W<g001c=g<GLcM_5W<gLaL00004KaL00`00KaM_5`02KaL4000016/HJ_Q[60000f/H00AZ
n6/H001Vn@=Rn@05I_URnF;i001Jf`03F]X01U[KF]X004ZLB[a:V`D00007<U`fG0007O`Inagl6M/0
0P0000L5VPEj0000005I0005^`0300026Sd500001Ckn?_lnoSko00005Goo00<007ooOol057oo000B
Ool01000Oomoo`000goo00<007ooOol02goo00@004JL@W]6W0800003G>00000001ioo`07001c=W<g
LcIc=`00LeL00W<g01<007<g001c=flFLcMc5P00KaIc=flFLcM_5P00KaL006lFLaL00003KaL30000
76lHKaL006[gKaP006/HI_M[66[hJaP006/I001VnF;iI_URnFKi001VnP00F]]FfU[kE]YJfeKJ0`00
00E:VdZlBY/0039L00D000036M/Mo1WK00@000061IX000000005^`FJ0`0000XJ?AYM000003kn@aln
oT<O?_h001Eoo`03001oogoo01Aoo`004Woo00@007ooOol000=oo`8000aoo`050012Nd9l@Wa2W002
00000ed00000000LOol00`00LcMc=`03LcL00`00LcMc=`02LcL04`00LaIc5W<gLaH007<GLcM_5W<g
LaL006lGLcM_5`00KaL006lG00800003KaL006lG009_5`03001[600000=[6009J_Q[6000JaQZn6/H
001VnF;i008000=Rn@04001Jfe[JF]X2000025KJ001:W4ZlBY]:_4ZL0004=U`500022I/2000010Ej
0GX000000`Fk1P0000<noSko?_h00`005Goo00<007ooOol04goo000BOol01000Oomoo`000goo00<0
07ooOol037oo00D0049kAYa2NdJL00<00003F<0007oo01Uoo`07001c=W<gLcIc=g<f00000W<g01=_
=g=G001c>000LcMc5P00KaIc=flFLcM_5W<g001c=flFLcM_5`030002KaL06`00KaQ_5flHJaM_6000
JaQVmf/HJ_Q[6000JaUVn6/HI_P006;i001RnFKjH_URnV;i001FfP0200003E[kE]YJfeKJ001:VdZl
BY]:_000=U`bG3Im008fG003000R71gl00<000052IX=^`000001NP0600000b9N7Ud00004000013kn
@alnoP004goo00<007oo000057oo000COol20004Ool00`00Oomoo`0<Ool01000@Ya2Nd9l0`0000AQ
0000000001Uoo`03001c=g<g009c=`03001c=g<g00=c=`0>001c=g<g001c5P00LcM_5W<gLaMc=`00
LcM_5`<00003KaL006lG009_5`03001_5flG009_5`09001_6000JaQZn6/H001[66[h00=[6003J_P0
06;i00IRn@0;001JfU[KE]YJfe[JF]/004ZlBYa:_0050002=U`01@007O`Qo1gl8Q`0200000<9^`WK
2M/0100000HNG@000012oT<O?_h2@_h00`00Oomoo`0BOol00`00Oomoo`0BOol001Uoo`03001oogoo
00eoo`<00005AYa2N`00G@1Q8002000HOol01P00LcMc=W<gLcH0009c=`0>KcMcEg<g001_=g=HKcMc
>000LcM_5W<gKaIc=`@0000PKaL006lGLcQ_5`00KaL006lGKaQ[5flHKaL006/GKaP006/H001[6FKh
JaQVn6/II_P006Kh001RnF;jH_UVnP800008H_T005KJF]]FfU[kE]YJf`<00005B[a:Vdjl000jO@06
00001Agl000=^a7L3K/00P0000T5^`00000000WL2K/9g0009Wh02P0057oo00<007ooOol04Goo000I
Ool00`00Oomoo`0>Ool01`00AYa2NdJL@Y`0064000<001Ioo`03001_F@0000=c=`03001c=g<g009c
=`0:001c=g<gKcMc=`00LcP007<gLaL300002flGLcM_5g<g001_=flGKcL006lG000016lG00P006lG
KaQ[5flH001[66[h0f/H00EZn000IaQ[6@0000=Rn@09001RnF;iH_X005[KF]YJfeKJ00800003F]/0
04Zl009:_009BY]:_000>W`fG3Il=U`0028L00<000043K/A^a6k4M/200000`FJ000000030000129M
8UhRGB9n0P0000=2oT<O@_h00T;n00<007ooOol04Woo00<007ooOol047oo000HOol00`00Oomoo`0@
Ool01`00AYa2NdJL001Q05d000<001Aoo`0:001cNFmHLeT007<g001c=flgLeL2LcL01`00LeQ_=g<h
KcL006lg00<0000RKaH006lFLcM_5g<g001c>6lGLcQ_5g<h001_66/GKaQ_5`00JaM_66/GKaP006lh
001[66KhJaUVn000I_Q[6FKhJaT300001f;jH_URnV;iH_X005[k0080000CE]YJneKJ001:VdjlBY]:
_4ZK000fG3Ym=U`jO@009Q`R72HL8Q`00P0000@Ag0fk0009^`<000033M/Ao00000<000078UdROP00
@am2oT<O@_h00`004goo00<007ooOol047oo000HOol2000BOol01@00AYa2NdJL00000V400`004goo
00<006mIKeT00VmI00<007<gLcL00g<g00<007<gKcL00W<g0`00015_=g<hKcL006lGLcM_5g<g001_
=flGKcM_5flg001_>000009_5`0C001_5flHJaM_66lG001[66lH001[66[h001W66/II_Q[66LH0000
0f;i00ARnV;iH_URn@800008F]]Ffe[KE]YJfeKK001:V`9:_0T000038Q`V728L00<000044K/000Vk
3K/3000010gl3M`002Im1`000d;n00<007ooOol04Goo00<007ooOol03goo000AOol40003Ool00`00
Oomoo`0BOol300001DJL00000000G>000P004Goo00T006mHLeU_F7=i001_F@00LeL00W<g00<007=H
KcL00`0003M_=g<hKcMcF6lg001_=`00KaMc=`00LcQ_5g<hKaMc>000KcQ_5g<h001_6000KaQ[5flH
JaL006/GKaQ[5`00I_P006KhJaUVn6/II_P006Kh001RnF;jH_URnV;i001Rn@00E]YJneKJF]]FfP05
000024ZKC[a:V`00>U`jOCIL>Wd500000aGL4M/0000200000`Vk3M`9^`0500000bIM:WhVO@020000
1dLO@_i77d;nAam2oP00019oo`80011oo`004Goo00<007ooOol017oo00<007ooOol04goo00@004JL
AY]6W0<00003G>00000000moo`03001_FFmI00=_F@03001_FFmI00800004LcL000000002LcL01P00
LcQ_=g<hKcL000=_>00P001_5`00KaM_=flGKcL006lhKaM_>6lGKcP006lHJaM_66lG001[66lHJaQ_
66/H001W66/II_Q[66LH001Vn09W6@03001RnF;i00800006H_URnV;i001FfU[K0P0000=FfU[K0000
1DZl00<003Yl>W`00cYl00<002Xl9Q`00`0000<EfaGL0000100000<F71Gl5O`0100000<VOP000000
0T;n00=77T;n00000P004Woo00<007ooOol03Woo000BOol00`00Oomoo`03Ool00`00Oomoo`0DOol0
1P00AYa2NdJL001HX0@000eoo`08001_F7=IKeQcNFmH001_F09_F@<0000iKcMc>6lgLeP007<hKcMc
F6lgLcP007=HKcMc>6lg001_5g<hKaMc>6lG001_5g<hKaM_>000KcP006lHJaL006/GKaQ[5flhJaL0
06/H001Vn6/II_P006KhJaUVn6/I001RnP00HaYRnF;jG_US6V;i0080000EF_]FfU[kE]YJn`00C[a:
VdjlBY]>_000>WdjG3Ym=U`002HL:SdV72Xm00D000034M`=f`00008000054O`F7A7l000ZO@070000
14;nAam2oP004Woo00<007ooOol03Goo000COol01@00Oomoogoo00005goo00@004JLAYa6V`800003
F:000000008000aoo`03001_FFmI009_F@03001_F@0000800003KeT006mI00800008LcM_=`00KcMc
>6lgLcP000A_>00G001_>000KaM_=flG001_5flhKaM_>6lG001_66lh001_6000KaQ[66lHJaP00003
JaP01000IaP006Kh0VLI01=[6FKhIaT006;jH_URnV;iH_YRn@00H_X005KJF]]Ffe[KE]X00003B[`;
00000bHL000Io0026O`300000a7K4M`0000400001RZN:WhZOP00:Yh00096oP04Aai2oTKn000COol0
0`00Oomoo`0<Ool0015oo`04001oogoo0002Ool00`00Oomoo`0FOol3000014JKAY`005RP10002Woo
00D007=IKeQcNFmH00<0009_F@06KeP006]IKeU[FFmJ0P0000]_=g=HKcMc>000LeQ_=g<hKcMcF000
009_>00U001_5`00KaMc>6lGKcQ_5`00KaM_>6/GKcP006lHJaM_>6/G001[66lhJaQ_66/H001Vn6/I
I_Q[6FKhJaT006/I001RnUkiHaX00P0000QNnF<JG_T005KJF_]FfU[k100000]:VdjlB[/003Yl?Ydj
O3im>W`002Xl00@000036O`InaWl00D000036QdF700000<00007:Yh00000@_i77d;nAal00`004Woo
00<007ooOol037oo0004Ool4000:Ool20003Ool2000HOol00`00AYa6W002AY`20000151P00000000
1goo0P0000=SO00000000`0016mI00<006mIKeT00fmI00H006]I001_=g<h0005KcP00`00KcQ_>002
KcP04P00KaM_>6lGKcQ_5`00KaQ_>6lHKcP006lh001_66/HKaP000A[600>001[6000IaU[6FKhIaT0
06LII_UW6@00H_X000=RnP05G_YRnP00F]]FfP0200001E[KE]/004ZlC[`00dZl00H003Yl>W`jO3Ym
0002:S`00bXm:S`0000400035O`3000011XL6Qd002jN1`0000=77TKnA_h00P004Goo00<007ooOol0
2goo0003Ool01000Oomoo`0047oo00<007ooOol067oo00D004JKAYa6VdJL00H000Aoo`800003GgaS
O@0000@000=_F@0CKeP006]IKeU[FFmJJeT006]IKeY[F@00KcL006lgLcQ_=g=H00000Vlh02ecF6lh
001[>000KaM_>6lG001_5flhJaM_>6lG001[5flh001_6000KcQ[66lHJaQ_>000JaU[6000I_Q[6@00
JaUVn6/II_Q[6@00H_YNnF<JG_URnUkiHaX00P0000UFfU[kE]YJneKJ001:^djlBY/01@0000XjO3im
000^?BXl:SdZ?0007O`N70<000035O`Eg1Wl00D00003;YhZOBjN00800006@_i77dKnAai2oTLO0P00
3goo0`0037oo0003Ool01000Oomoo`0047oo0P006Goo00@004JLAYa6W0/00006Hgd00000001SOF=l
0P0000ESO@00001_F@0000E_F@07001[FFmJJeU_FF]I00001Flh00<006lhKcP00Vlh00<006lhKcP0
0P0000a_>000KcQ_66lhKaP006lHKcQ_66lh0005JaP02@00JaQ[66/H001W6@00IaUVn@03IaT01@00
IaT006;jG_X00f;j00@006;j001Jf`=Ff`03F]]Ff`00008000=:_003000jO00000@00003:S`Z?@00
00<N70037O`0000000<000<N?@D00004;Yh004KnA_h30002A_h00`00Oomoo`0>Ool00`00Oomoo`04
Ool30003Ool0009oo`800003Ool00000011oo`03001oogoo01Uoo`<00003AYa6VdZl00<00003:_lV
gR[O00<00003HgeOO6=m0080000JGeaSOEmLHgeOG000JeU_FF]IKeY[F@00JeU_FV]IKeY[F@00JeT0
06lgLeQ_=`00KcQcF09_>00Y001_FFlhKcU[>6mI001_>6/GKcQ_5`00JaM_>6/HKcP006li001_66/H
KcP006/IJaQ_>F/HJaT006/II_Q[6FKhJaT006LII_UW6@00H_YNn@0200001f;jG_T005KJF_]FfU[k
0080000=E]X004ZkC[a:^djl000nWCYl?YdjO000:S`01@0000HMo1hL7O`001Wl7Qd300001Ahm7Q`R
?@00<Yh01@0000I77TKnAai6oTLN000AOol00`00Oomoo`03Ool01000Oomoo`000Woo000FOol00`00
Oomoo`0KOol00`00AYa6W003AY`00`008Q`0000200000b[O9]h00003000026=mGgaSOEmlHgeOO000
Ge`20002KeT02000JeU_FV]IKeU[F@00JeT2JeX200000flh001_>002KcP00`00KcQ_>003KcP04@00
KcT006lhKaP006lHKcQ_66lhKaP006/HKcP006/H00001F/H00<006/I00000fLI00l006LIIaUW6FKi
001RnP00G_YRnUkjH_YNnP00E]/00P000UKK00EJf`00B[a:_4jl009:_003000nWCYl008nO005000^
?2iM;S`^G@0500046Q`500001RjN<Yh^WP00;Yh000=6oP04Aah00000000AOol00`00Oomoo`02Ool0
1000Oomoo`000Woo000FOol3000LOol01000B[a6VdJL0`000R8L0`0000PZgRko:]h005mLHgeOG6=m
0P0000AOG6=mGeaSO@80000>JeU_FV]IKeY[F@00JeU_FV/iKeY[FFmJ001cF09_>00`001_FFlhKcU[
>6mI001_>F/hKeT006lh001_>6/HKcQ[5`00JaQ_>6/H001[6000JaQ_>F/HJaT006/iJaQ[6@00JaT0
06LII_UW6FKiIaUVn@00G_YRnUkiHaYNnV;j0P0000UFfe[kE]YJneKKF_/004jlB[/02`0000D^?000
8Q`R?B8L00@000057Qd002IM8SdRG@0;000014/NA_i;7P0047oo00<007ooOol00Woo0`000goo000F
Ool00`00Oomoo`0LOol800001R8L00000000;_lZgP8^g`800007Hgd006=mGeaOOEmlHgd00P0000MO
G000JeU_FF]I001[F@03JeX016]IJeX006]J0P0000=_>000KcP00flh018006liKcQ_>F/hKcT006lh
KaQ_>6lH001[66lhJcQ_>6/H0004JaP01`00JaU[66/IJaQ[6@0000=W6@09I_UW6FLI001Vn@00G_YR
nUkj00800005H_X005KKE]]Jf`02E]/400001dZlC[a:_000?Y`nWCil008nW003000^G00000<0008R
70038Sd001hM00@0000:8SdRGB8m000bWS:n000b_S:N0003A_h00dLNA_h0000@Ool20004Ool00`00
Oomoo`02Ool0015oo`<0009oo`03001oogoo01Yoo`H00003AY]:_4JK00`00015HgeOG6=mGeaSO@00
GgeOG6=mGe`006]I001[FFmJJcU_FV]IKeX006]JJeU[FV/i001_>6liJcQ_FFlh001[>6mIJcQ_>@00
KeT006lhJaL006/HKcQ[66liJaP006/H001[66/IJaP006/HJaUW66/i001[6@00IaUVnFLII_T006Ki
IaT006<J00800007G_YS6UkjH_X005[kE]/00P00019JneKK001:^dkLB[]>_4Zk000nO3jM?W`nW@00
<Ud^G39M;U`5000011hL8SdN728m1@0000Xf_S:N=[h003Jn001;7TKnBai6oP<000aoo`D000Aoo`<0
009oo`004Woo00@007ooOomoo`8001Qoo`<000Aoo`090016W4JLAYa:_4JL000V?2Hm00@00004;_hb
obko<_l200002eml000005mMGeaOOEmLGeeOG000JeT00f]J00=[F@00000016]J00<006]J00000flh
01`006lhKcU[>6li001_>F/iKcT006lh001_>6/hKcQ[6000JcQ_>F/H001[6000JaQ[6F/HJaT000=[
6@05001W6FLI001Vn@03IaT01000G_YNnV;j0ekj00ERnP00001FfeKk00=Ff`06001:_4jlB[a>_000
0SjL00/nWCil?Y`0039M;U`bGBiM000V?2Hm00@000037Q`R?@00008VG@/00004A_i;7TKn0007Ool4
0004Ool00`00Oomoo`07Ool000moo`D0009oo`03001oogoo01Aoo`<000Qoo`800007B[a6VdZl000Z
?BHL9Sd02P0000IOG5mmGeaSOEmLGgd20000C5mL000006mJJeT006/iJeY[FF]JJcT006LjJeYW>P00
KcP006/hKeU[>6li001_FF/hKcU[>6mI001_>6/HKcU[6000JaQ_>F/HKcU[6000JaQ[6FLHJcT006/I
IaQ[>FLH001Vn@00I_UW6F;iIaX006LJ001S6UkjH_YNnV<J001RnP00F_]Ffe[kE]YJn`00C[a:^dkL
3`0000@V?BHl000R?0H0000>9Ud00000=Yh003:M=[h004/NA_e;7TKnBah000Aoo`<000Qoo`03001o
ogoo00Moo`003goo00@007ooOol0009oo`03001oogoo019oo`<000eoo`L000039Sd0005J00@00003
<_lfoc;o00800006GgeOG000001OGEmL0emM0P0016]J0P001F]J01@006lhKcU[>6li001_>F/iKcU[
>Fli001[>@00KcQ[66lh001_>F/H0V/h00L006/H001[66/IJaP00002JaT01F/HJaU[6@00I_T00fLI
00D006LIIaUW6@00009NnP8000=NnP05001FfeKKE_]Ff`040003C[`02@00?Y`nW4:M?Y`0039M<Wdb
G002<Ud400001bHm8SdR?B8m9Sd002Ym00H0008f_P04001;7TKnB_h6000<Ool00`00Oomoo`06Ool0
011oo`03001oo`00009oo`80011oo`<0015oo`06001:_4JLB[`002YM0`0000@1NP000001N0L00006
GeaOOEmLGgeOG5mm0P0000eKG000001[FP00JeYW>V]JIcY[FVLj001W>P020000<fli001_FF/hKcU[
>6mI001_>F/iKcT006lh001_>F/HKcU[6000JaQ[>F/H001[6000IaQ[>FLHJaUW6000IaT006;iIaX0
06LJH_UW6V;i001NnP00G_YRnUkjHa]NnP00E]YJn`0200005EKKF_/004kLB[]>g4Zl000nO4:M?Ya2
WCil000bG39m<U`fO@00:UdV?00400002RHm8S`002IM:WhZGBYn9Ud003Jn1P0000=;7TKmBah00P00
3Goo00<007ooOol01Woo000AOol20002Ool00`00Oomoo`0=Ool2000EOol02000B[a6W4Zl000Z?BXl
:Sd500000`5i000fo`03=_l20002Ged20003Ged00emLGed00006JeX03000IeY[FVMJJeX006liJcU_
>F/iKcT000E[>@03001_>F/H009[>007001[66/iJaU[>F/H00000V/I00U[66/IJaT006LIJaT006LI
00000fLI00ARnFLIIaT000MNnP80009Ff`03E_]Ff`00009>_003B[`0000000T00008<U`bG@00:UdZ
?2Xm000VG@H00003:UdZO@00008f_P06000f_SJn001;7TKn0T[n0`0037oo00<007ooOol01Woo000E
Ool00`00Oomoo`0:Ool3000GOol01000AY]:_4JL100000<ZG@0000001@0000@focKn=alfoP<00005
FeaOGE]LGgeKG00200009emM001[FVLjJeYW>P00IcY[FfLjJeX006]K001_>F/hKeT006liJcU_>F/i
KcT006/j001_>F/HKcT006/iJaQ_>F/H001W6000IaQ[6@0200004VLIJaUW66/i001W6V;iIaYRnFLJ
H_T006;i001NnV<KG_YRnP800006G_X005KKF_]Ffe[k100000]:^dkLB[`003jL@YdnW4:M?Y`0039L
00D000099S`ZG@00:UdV?2YM9Sd002YM00d00004B_e;7TKm000;Ool00`00Oomoo`06Ool001Eoo`80
00Qoo`<001]oo`<0009:_003000^G@00008000031IX0000000H0008jo`04=_l00000Ged20002Ged0
4E]LGed00000JeX006MJJeYWFV]J001WFfLjIeX006li00001F/i01`006/iJcU[>@00KcT006/iJaU[
>F/H001[6F/i001[6@00JaUW6F/IIaU[6@00IaT006LIH_UW6@800005H_UW6V<I001NnP020003G_X0
0`00E_]Ff`0200001UKkE]/004jlC]a:_09>_006000nW4:M@Ya2W@0013Im00<002iM00001@0000<V
G@00;Wh00bim00@^OP00>[h000<j_P03001;7T[n009:oP03Bah007oo00Yoo`03001oogoo00Ioo`00
5Goo00<007ooOol017oo0`007goo00T004JKB[a6W4Zl000^GBXl;Ud0200000@foS/O=_hk7`<00007
GeeKG5mMFeaOGE]LGed00P0000mW>V]KIcY[FP00Je]W>V]KIcY[F`00KcU[>FliJcT00P0000U[>V/i
JcU[>F/j001[>F/HKcT00P0001iW66/iJaU[>@00JcUW6F/IIaQ[>@00JaUW6F/i001W6P00IaYRnFLJ
H_UW6V;i001NnV<KG_YNnekjHa/200002EKKF_aFfeKkE]/004ZlC]a:^`0:00002CIm000^GBYL;UdZ
?2iM000ZG@0500003Bin:Wd003Jm>]h003Zn=[d004[mBai6oD/N00<000Yoo`03001oogoo00Ioo`00
57oo00<007ooOol00Woo0`008goo00H004ZLB[a:_000;U`3;Ud600000`7K0000000200000c/O>_lj
o`0200000e]LGed00002000025mMFed00000JeX006MKIcX2IeX00fMK001WF`0200000f/i001[>@05
JcT04@00JcT006/i001[>F/IJcU[6F/i001[>@00JaUW6F/I00000VLI00U[6FLIIaT006LJH_UW6V<I
IaX00P0000=S6P00G_X00Ukj0P0000=NnP00E_/00eKK00=Fn`0000000P000djl00L004:L@Ye2W4:M
000fO@0500000biM:Ud00004:Ud00`00<Wh0000<0002B_h00d/N001oo`08Ool00`00Oomoo`06Ool0
01Aoo`D002Moo`X000032K/0000000H00003>_ho7c[n00@0000<GeeK?5mMFcaOGE/lGed006]KIcY[
FfLj0P0000MWFfLjJe]W>P00JcU[>P03JcT08f/j001[>VLiJcX006/iIaQ[>F/IJcT006/iIaU[>@00
JcT006/IIaU[>FLIJaT006/j001W6V;iIaX006LJH_UW6P00G_/00P0000MNnUkkG_YO6`00E_]Ff`02
00004eKkE]/004ZlC]a:^dkL0012_D:L@[e2W000=W`jOCIl>Wd0039m00H0008ZG@0A000bWRim<Yh^
O@00>[d003Zn?]hj_@00B_e;7T[mBai:o@020008Ool00`00Oomoo`06Ool000eoo`<000Aoo`8002]o
o`09001:_4ZlB[`002iM<Ud^GC9M00`00009?_hnocko001KG5mMFeeOGE]L0080000=Fed00000IeX0
06LjIe]W>VMKIcX006Lk00000f/i0P000V/i00i[>P00JcX006/iJaU[>@00JcU[6F/iJaU[>@000VLI
00A[6FLIIaT0009W6@04001S6@000002HaX01FLJH_US6P00G_/00ekj00=NnekjG_X00P000eKK00EF
n`00C[a>_4kL009>_0030012WD:L00D0008fO@07000^GBiM;Wd^G@00;Ud01P0000P^O@00?]hj_P00
>[hngP000T[n0`0000=:oT/N000027oo00<007ooOol01Goo000=Ool01000Oomoo`0017oo00<007oo
Ool0:Woo00T004JKB[a:W000;U`bOBiL<Ud00`0000<1>00000001@0000@o7c[n?aljoP80000nGed0
0000FcaOGE/lGeeK?000IcYWFfLjJe]W>P00HcYWFfLj001[>@00IcU[>VLiJcX006/jIcU[>P00JcT0
06/iIaU[>FLIJcT006/j001[>FLIJaT006/jIaUW6VLI001RnFLJH_UW6V;iIaX006LJ001NnekjGa]N
nP80000:Ga/005KkE]]Jo5KKE_/004kLB[`500001D:LA[e2W000=W`01P0000TbO@00;WhZGBim:Ud^
OP00<Yh02P0000I:oD/NB_e?7T[m0008Ool00`00Oomoo`05Ool000eoo`04001oogoo0005Ool2000Z
Ool01000B[a:_4Zl100000@^G@003M/Ag0l000=KG@0=FcaKG@00001K?@00IcYWFfLj001W>fMKIcX0
0VLk01P006/iJcU[>F/j001[>VLiJcYW>F/j001[>F/IJcU[6F/i001[>FLIJcT006LI0004IaT01P00
IaT006<JIaYRn@800005HaYRnV<J001Nn`0200001UkjG_]NnP00E]]Fn`9Ff`@0000:C[a>g4jl0012
W4:m@Ya2WD:L0003>Wd00cZM000bO@0500001bim;Ud003:M<YhbOC:N00<00004?]hn_SkN0002B_h0
0d/NB_d000020007Ool00`00Oomoo`05Ool000eoo`<000Qoo`03001oogoo02Qoo`<0009:_003000b
G00000<000034M`00000008000030EP0000000800005@alnoT<O?_i37`0200004E/l000005mMFcaK
GE/l001W>P00HcYWFfLjIe]S>P00HcX00P0002i[>P00JcYW>F/jIcU[>P00JcX006/iIaU[>@00JcYW
6F/jIaU[>P00JcYW6FLJIaT006LIIaYW6@00H_T006;iIaYRnF<JH_UW6P00G_]JnUlKG_YNne[j001F
f`80000IE_aFf`00B[]>g4jlC]`004Jm@Ya6_D:LA[d003ZM=W`jWCIl000^GC9m<UdbO@00<Wh04P00
00A:oDlNB_d000Ioo`03001oogoo00Eoo`003Woo00<007ooOol027oo00<007ooOol0:7oo00<004Zl
B[`00TZl00@0039M<WdbO@@000050GT000000001F@0400000ckn?alno`0300001U/mFeeK?E]MFceK
G@800004Ic]WFfLjIc/2000036<kIc]W>fMK001[>VLiJcYW>F/j001[>P9W>P0;001[>@00JcUW6F/i
IaU[>@00IcX00002IaT01`00IaUW6FLIIaYW6@00009S6P0<H_YS6V<JHaX006<J001NnekjG_]NnUkk
0P0000QFfeKkE]]Fn`00C]a>_4kL400000dbO@00;WdbOBim<Wd^O@00=YdfWSJM=YhfW@020003?]h0
1`00B_i:oD/NB_e:oP0000Ioo`03001oogoo00Eoo`003Woo0`002Goo00<007ooOol0:7oo00@004Zl
BY]:_0@00004<U`001Gl5O`700000aIM0000000200000ckn@alnoP0200001U]MFc`00000FeeK?080
000ZIe/006MKHcYWFf<jIe/006MK001[>VLiJcX006/jIcU[>VLIJcX006/jIaU[>VLIJcX006/jIaT0
06LI001W6FLJIaUW>VLI001S6@00H_US6V;i0P0000IS6V;j001NnUkkF_X200001Ukk001Fo5KKE_aF
f`@0000@C]a>_4kL0016_D:LA[e2W4Jm000jWCYl?YdjO000<Wd500004Rim<Wd003JN<YdfWS:M=Yh0
03kN0012gSjm001:oDlNB_e?7P<000Eoo`03001oogoo00Eoo`006goo0P00:Goo0`000TZl00<003Im
00000`0000<Eo00000002@0000=37d;n@al010000e/m00IKGE/m000006MKHc/2Ic/20002Hc/01FLk
001[>P00JcX00fLj00e[>P00IcX006/iIaU[>@00IcYW6FLiIaT00003IaT00fLJIaT00002IaX01FLI
001S6P00H_X00f<J00YRnP00000005kjG_]NnP00E]]Fn`800005E]]Fn`00C]a>_003C]`01P00A[e2
_4Jm@Y`0008jW@09>WdjW@00=WdbOCIm<Wd0039m01800004Cai:oD[n0004Ool00`00Oomoo`05Ool0
01eoo`03001oogoo02Moo`09001:_4ZkC[a:_000<U`fOCIl00H000030ET0000000L00003@am2oT<O
00800006FcaKG@00001G?5]M0P0000eS>P00Hc]WFf<jIe]S>fMK001[>VLiJcYW6@02000096LjIaU[
>P00JcX006/jIaU[>VLI001W6@00IaUW>VLI001S6FLJHaUW6V<I001RnV<JH_YS6V;jHaX005lKF_YN
ne[jGa]JnP800009E_aFfeKlE]]Fo000C]a:^dkL00l0000==YdbO@00<WdfWS9m<Yh003Zn=Ydj_SJM
>[h00P0000Pn_D;N?[d004[mCai:oDlN0`0017oo00<007ooOol017oo000NOol00`00Oomoo`0WOol0
1@00B[a:_4Zl000013Im00<001XL6Q`01@0000<1^`000000100000=2oT<O@_h010001U/m00D006<k
Hc]S>fLk009S>`06001S>`00001W>P001VLj00@006LjIaUW>@800006IaUW>VLJ001W6@000VLJ00IW
6FLJIaX006<J0002HaX026;j000006<J001NnekjG_/200001ekk001FfeKkE]]FneKK00@000=>g00<
0016_DJlA[e6_000>YdnWCZM?Yd003JM2`0000HfWSJM000ngP00?]h6000014lNB_e>o@000goo00<0
07ooOol017oo000OOol00`00Oomoo`0WOol;00000ahM0005^`0400000`6j000NO@05000024;nAam2
oP00EcaKGE/lFed200001ELl001S>VMKHc/00P0000EWFf<kHe]S>`00009W>P0DIaU[>VLjIcX006Lk
001[>P00JcYW6FLjIaU[>VLI001S6FLJHaUW6P800004HaUW6P00HaX200001EkjHa]NnP00F_X00P00
00MNne[jGa]JnP00E]]Fo00200007UKKE_`004kLC[a>g4jl0012W4Jm@Ya6_@00?YdjW3jM>W`003Im
=YdfOCJM=Wd0039m=YhbOCJN000j_PH0000:?[e2gT;M001:oDlNB_e?7T[m0003Ool00`00Oomoo`04
Ool0021oo`03001oogoo02Moo`06001:_4ZlB[`003Ym0cIm1@0000<5^`0000000`0000<NOR9n7Wh0
0P0000I37d;n@ai2oP00Fcd20004Fcd00`00Hc/00005Hc/00`00Hc/00003IcX20003IcX02@00IcYW
6FLjIaYW>VLI001W6P02000016LJ001W6V<J0fLJ00D006<JHaYS6V;j009S6P03001JnUkk009Nn`03
F_YNnekk00800005E_]FfeKlE]/00003C]`E00001cIm000jWCZn>Ydj_SZM00800008@]i2gD;N001?
7T[mC_e:o@<0009oo`03001oogoo00Aoo`008Goo0P00:7oo00`004jlB[a>g000>YdfO3ZM=Wd001hL
8Sd500000`Gl0000000:00001ULlFeeG?5/mEcaKG@800004Hc]WFf<kHe/20003Hc/01@00IcX006<J
Ic/00VLj00H006Lk001W>VLIJcX2000046<IIcYW6FLj001W6V<IIaYS6FLJ001W6P00Ha]NnV<J0P00
00INnP00F_YO6e[jG_/200001U[j001FfeKlE]]Fo0@0000:C[a>g4jl0012W4JmA[a6_@00?[d2?Yd0
2CZL000fOCZM=WdjWCIm000fO@0A00001T[mCai:o@00Ool000Ioo`008goo00<007ooOol09Goo00@0
04ZlB[a:_0P000038Sd000gL00L000089YhRORJN00177T;nAai6oP80009K?@80009K?@800003Hc/0
06<k00ES>`03001W>VLj009W>P0?001W>VLjIcX006Lj001W>VLJIcYW6VLj001W>P00009W6P80009S
6P06001RnP00001S6Ukj0V<J00X005[j000005kkF_]Nn`00E_aFf`800003E_aFf`0000A>g0060016
_DJlA[e6_0001CjM00H003JM>YdfOCZM0004=Yd01P00>[dj_SZm>[hj_@800008@]i2gD;N001?7T[m
C_e:o@@000Ioo`0097oo00<007ooOol09Goo0`0000M:_4kL000jWCIl>YdjO@0500000`WK00000006
00001BJN00177d;nAal0100000EG?5/mEcaK?ELl00800005HeaS>f<kHc]SG00200003elk000006Lj
001W>f<JIc]S6VLk001W>V<IIcYW6@02000066LjHaX006<I001S6VLJHaUW6V<J001NnV<KG_YS6ekj
Ha]NnP00F_YO6e[jG_]JnP<00008D]]Fo5KKE_`004kLC[a>g1D00007>Yh003jn>Ydn_SZM?[h00P00
00=2gD;N00001@0000A:oDlNB_d000Ioo`009Goo00<007ooOol09Goo00<004ZlC[`00TZl00<003ZM
>Wd00SZM00<0028m9Sd01`0000<>7000:Yh01@0000=77TKnAah00P000U/m0P0000EG?E/m000006<k
008000ES>`03001W>VLj00=W>P08001W>P00001W6P00IaYW>P=W6P0:001S6V<JHaYW6V<J001S6P00
G_X3HaX2000015lJ001Jnekk0P000U[k00D005KlE]]FneKK00@000=>g0060016_DJlA[e6_0000cjM
00<n_CjM000013ZM00<003ZM00002P0000I6gT;M@]h004lMB_d2C_d00dlM001oo`05Ool002Ioo`80
02Ioo`04001:_4kLB[`800000bIM000F700200000`GK0000000200000bZN9YhZWP0200000d;nAam6
oP0400001E/mEaaK?ELlFcd00P0000]O>f<lGc]S?5lkHc`006<l001W>f<J0080000FIc]S6VLkHaX0
06<IIcYS6VLjHaT006<J001S6FLJHaX006<JIaYS6P00G_X2000016<KG_YS6ekj0P0000MO6e[kG_]J
nP00E]]Fo002000015KKE_`005;L0TkL00E>_000A[a6_DJl00/0000<>Wd003JM>YhfWCZn000n_SZM
?[hj_Cjn0P0000Q2gDKN@]d004[mCai:oDlN0`001Goo000XOol00`00Oomoo`0TOol3000014ZlC[`0
03jM0cZM1@0000DAo0000000018L00T00003A_i77TKn00800007FceG?@00001K?ELm00000f<k0P00
00eS>elk001W>P00HcYW>V<jIc]S>P00HcX00002IaX200001V<JIaYS6P00HaX000ES6P09001NnV<J
GaYS6ekj001O6P0000=Jn`09G_/00000001Fo5KKE_aFf`0000=>g0D000]ooaH0009oo`03001oogoo
00=oo`00:Goo00<007ooOol097oo00d004ZlC]a:_4kL000nWCYl?Yd002YM9SdZG@0:00000bZN;[lZ
WP0200000d/OA_i77P0400004ULLFceG75/mEa`005lk001O>f<lGc]S?5lk001S6VLkHaYW>`80000@
HaYW>`00IcX006LkHaYW>V<JIc]S6P00HaYW6V<JIaX2000016<J001NnV<K0P0000ENnV<K001Nne[j
00800007G_]JnP00E]]Fo5;KE_`010007Woo00<007ooOol01goo00<007ooOol00goo000ZOol00`00
Oomoo`0SOol01000C[a:_4kL2@0000<ZG@006Qd03`0000E77TKnAah005/m00=G?@03Fcd00000009S
>`05Gc]S>`00001O>`0200003FLk001S>f<jIc]S6V<k001W>V<JIaYS6VLj00800003HaX006<J0080
00=S6P08001S6`00Ga]O6V<KG_YO6`8000AJn`03001Fo5KK008002=oo`03001oogoo00Ioo`03001o
ogoo00=oo`00:goo0P0097oo0`0000U>g4ZlC]`003jM>Y`n_@00;Wd0100000<F700000001P0000<b
_bjN<[h00P0000M6oT/NA_i;7P00FceG7002000015/mEa`005lk0P0000eS?5lkHcaO6f<l001W>f<J
Ic]S6VLk001W>`0200002V<J000006LkHaYW>f<J001S6V<K0f<J00mS6`00Ha]NnV<KG_YS6`00Ha/0
05kkF_YO6e[kG_/00P009Woo00<007ooOol01Goo00<007ooOol00goo000]Ool00`00Oomoo`0ROol0
1`00C[a:_4kLB[a>_00000<nW@04000^GBYM:Ud500000aHM000NG@0>0003Ecd01E/m000005lkHc`0
0elk0P0000AO?000Ic]S6P800005Hc]S6V<kHc/00003HaX01FLjHaX006<J00000f<J0P0000AS6P00
001NnP800004Ga]NnUlK0002F_/2000YOol00`00Oomoo`04Ool00`00Oomoo`03Ool002ioo`03001o
ogoo029oo`04001>g4ZlC]`9000012in000N?AhL1000010RGQiM8Uh003Jo<[hf_S:n0016oT/NA_e;
7P00FceG70800005FceG7000001S?002000045lKHcaO6`00HaX006<JIc]S6V<kHaX006<J001S6VLk
0P0000AS6VLk001S6P80000<HaYS6elJHa]S6P00G_YS6ekjGa]NnV<K0P00:goo00<007ooOol017oo
00<007ooOol00goo000_Ool00`00Oomoo`0ROol300001DkLB[a>g000?[d00SjM00<002im00000`00
00<N?@006Sd0100000<NGP00<[h00S:n00@004/NA_i;7P@00005EaeG?ELmEceG7@0200001ellGc]O
?5lkGcaO>`00009S>`09HaYS>`00001S6f<k001W>P00009S6P05Ha]S6V<J001S6`03HaX026<KHaX0
06<J001NnUlKGaX2000^Ool00`00Oomoo`04Ool00`00Oomoo`02Ool0031oo`8002=oo`0>001>g4Zl
C]a:_000?Ydn_CjL@[d0039m;UdbOQ400003Bai6oD/N00800006EaaK?@00001G75/m0P0000EO6f<l
000005lK0080000CHc/006<kHaYS>elJHc/006<kHaYW>f<JHc/006<k001S6elJHa/00P0000ANnV<K
001O6`80035oo`03001oogoo00=oo`03001oogoo009oo`00<Woo00<007ooOol08Goo00@004kLC[a>
g1<000039Wh003Jn008f_P800003B_i;7T[n00@00005EceG7ELmEaeG?@03000025llGc]O?5lkGc`0
06<kHa/2Hc/2000016<k000006<J0P0000IS6f<JHa/006<K0002HaX016<KGaYS6P00<goo00<007oo
Ool00goo00<007ooOol00Woo000cOol00`00Oomoo`0QOol300001dkLB[`003jM@[dnW4:m00800004
;WdbWP00:Uh400000ahm0000000900000dKmBai:o@0200002U/mEa`00000FceG7000Ga]S?5lK0P00
00=O?000Hc/00P00015O6f<kGaYS>elK001O6V<kHaYS>elJHc/006<KG_YS6elJ008003Eoo`03001o
ogoo009oo`03001oogoo009oo`00=7oo00<007ooOol08Goo0P000TkL00E>_000?Ye2_CjM00@00003
<Wd002IM008VG@P00003=[hjgSJn00800003Bai:oT/N00@00006EaeG?ELMEcd005ll0P000Ull00QO
6ell001S>f<KHc]S6f<k0P0000EO6`00HaYS6f<J00800003Ha/006<K008003Qoo`05001oogooOol0
0004Ool003Eoo`03001oogoo029oo`L00003?Ya2_CjM00H00006:Wh002IN8Ud002Ym2P0000M;7T[m
Bah005/mEaaG?@0300001ellFa]O?5lKGc`005ll00800008GaX00000Hc]O6f<k001S>`800005GaYS
>elJHc/0000kOol01000Oomoo`0017oo000fOol2000SOol01000C]a>g4kL0P000d:m00H003JM<Wdf
W@00:Wh400001B9M000ZWRjN:Wh00P000c[N00@004/NB_i;7PD00003EceG75LM00800005Ga/00000
GcaO6`02Gc`02P00Ga]S>elKHc]O6f<k001S6f<J0V<K0P00?7oo00@007ooOol000Aoo`00>7oo00<0
07ooOol087oo00@004kLB[a>g0T00005=Yh002Yn:Ud^OP0?00002DlNB_e;7P00EceG75LmEaaG?@02
000015/KGcaK6ell0P0000EK6`00Ga]S>elK00800003Hc`006<k008003moo`03001oo`0000Aoo`00
>Goo00<007ooOol087oo0`000dkL00H004:m@[e2_@00=Yd;0003;Yh02`00?]hjgSkN001;7T[mBai:
oT/N00000ULM0P000ULM00T005lK000005llFaaO?000Hc/00P0000EO6f<kGa]O6`00049oo`03001o
o`0000=oo`00>Woo00<007ooOol087oo00H004kMC[a>g4Zl0002@[d034:LA[d003JN=WdjWP00;Wh^
OBjN000^WP@0000:;Yd003[N?]hj_SkN001;7T[mCah4000015LLEceG75Lm0P0000eK6ellFa]O?5/K
Gc`006<kGa]S?5lKHc/00014Ool20003Ool003]oo`80025oo`04001>g4kLC]`=00001Bim000^ORYm
;Wh02`0000A;7T[mBah0009G7@80009G7@800005GcaO7000001K700200000elK00000015Ool20003
Ool003eoo`03001oogoo01moo`<0000=C]a:_000@[e6_D:lA[d003ZN=Ydj_P00<Yh02`000ckN0P00
00=:oDlNB_d00`0000EG75LmDaaG?ELL00<00004Fa]O?5/KGc`20017Ool20003Ool003ioo`03001o
ogoo01moo`03001>g4kL009>g0040012_DJm@[d400002cZM000bWS9m<Yh002jN;Wd^WP00=[h02P00
00A:oDlN0000009G7@80009G7@03001K75/L008004Eoo`@000Eoo`00?goo00<007ooOol07goo00@0
04kMC]a>g0@00004@[a6g@00?[h900003S:N000f_S:M=[h004;N?]e2oSkN001:oDlNB_d4000015LM
DaaG?ELL0`00@goo10002Goo0010Ool2000POol30002C]`200001DJm@[e6_@00>[d00SZM00H003JN
<YdbWP00<Yh>000014[mCai:o@000ULM0P00@Woo10003Goo0012Ool00`00Oomoo`0NOol01000C]e>
g4kL3@0000TfWP00<YhbOC:N000j_SJM>[h00P0000<ngD;n?]h00P0000=?7T[mCah00`00@7oo1000
4Goo0013Ool00`00Oomoo`0NOol3000=OolC000oOol4000EOol004Aoo`03001oogoo01eoo`03001o
ogoo05]oo`@001Uoo`00AGoo00<007ooOol077oo00<007ooOol0Egoo10007Goo0016Ool2000LOol0
0`00Oomoo`1DOol3000QOol004Qoo`03001oogoo01Uoo`03001oogoo051oo`@002Aoo`00BGoo00<0
07ooOol067oo00<007ooOol0C7oo1000:7oo001:Ool00`00Oomoo`0GOol00`00Oomoo`18Ool4000/
Ool004]oo`8001Moo`03001oogoo04Aoo`@0031oo`00CGoo00<007ooOol057oo00<007ooOol0@7oo
1000=7oo001>Ool00`00Oomoo`0COol00`00Oomoo`0lOol4000hOol004moo`03001oogoo019oo`03
001oogoo03Uoo`<003aoo`00D7oo0P004Woo00<007ooOol0=Goo1000?goo001BOol00`00Oomoo`0?
Ool00`00Oomoo`0aOol40013Ool005=oo`03001oogoo00ioo`03001oogoo02eoo`@004Moo`00E7oo
00<007ooOol03Goo00<007ooOol0:Goo1000Bgoo001EOol2000=Ool00`00Oomoo`0UOol4001?Ool0
05Moo`03001oogoo00Uoo`03001oogoo029oo`@005=oo`00F7oo00<007ooOol027oo00<007ooOol0
7Woo1000Egoo001IOol00`00Oomoo`07Ool00`00Oomoo`0KOol3001KOol005Yoo`03001oogoo00Io
o`03001oogoo01Moo`@005ioo`00Fgoo0P001Woo00<007ooOol04goo1000HWoo001MOol00`00Oomo
o`03Ool00`00Oomoo`0?Ool4001VOol005ioo`03001oogoo009oo`03001oogoo00]oo`@006Yoo`00
Ggoo00D007ooOomoo`0000Uoo`@006ioo`00H7oo0P0000=oo`00Ool017oo1000LWoo001ROol20000
0goo00000002001fOol006=oo`8007Yoo`00ggoo003OOol00=moo`00ggoo003OOol00=moo`00ggoo
003OOol00=moo`00ggoo003OOol00=moo`00ggoo003OOol00=moo`00ggoo003OOol00001\
\>"],
  ImageRangeCache->{{{0, 222}, {202.875, 0}} -> {-0.0999174, -0.052391, \
0.00479296, 0.00479296}}]
}, Open  ]],

Cell[TextData[{
  "The example of the heat equation demonstrates how the basic functions of ",
  
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " can be used to find non-classical solutions. The above discussion is \
based on the combination of batch mode calculations and interactive \
calculations in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The following calculation will show how non-classical symmetries can be \
derived by pseudo-automatic calculations in ",
  StyleBox["MathLie.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"find non-classical solutions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3.2 The Boussinesq Equation", "Subsection",
  CellTags->"The Boussinesq equation"],

Cell[TextData[{
  "The ",
  ButtonBox["Boussinesq [1872]",
    ButtonData:>{"Literat.nb", "Boussinesq-1872"},
    ButtonStyle->"Hyperlink"],
  " equation"
}], "Text",
  CellTags->"Boussinesq equation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_\(t, t\) + \ u\ u\_\(x, x\)\  + \ u\_x\%2\  + \ u\_\(x, x, x, x\) = 0
      \)], "NumberedEquation"],

Cell[TextData[{
  "is one of the equations frequently examined in connection with solution \
procedures for non-linear models. The equation arises in several physical \
applications ranging from surface waves of rectangular canals to applications \
in plasma physics. The point symmetries of the Boussinesq equation were \
examined by ",
  ButtonBox["Nishitani and Tajiri [1982]",
    ButtonData:>{"Literat.nb", "Nishitani and Tajiri-1982"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Rosenau and Schwarzmeier [1986]",
    ButtonData:>{"Literat.nb", "Rosenau and Schwarzmeier-1986"},
    ButtonStyle->"Hyperlink"],
  ". The discussion of the non-classical symmetries by ",
  ButtonBox["Levi and Winternitz [1989]",
    ButtonData:>{"Literat.nb", "Levi-89"},
    ButtonStyle->"Hyperlink"],
  " revealed that the symmetries of the direct method by ",
  ButtonBox["Clarkson and Kruskal [1989]",
    ButtonData:>{"Literat.nb", "Clarkson-89"},
    ButtonStyle->"Hyperlink"],
  ", Clarkson [1989] follow from a non-classical analysis. We use this \
equation here to demonstrate the pseudo-automatic calculation of \
non-classical symmetries."
}], "Text",
  CellTags->{
  "surface wave", "plasma physics", 
    "point symmetries of the Boussinesq equation", "direct method", 
    "pseudo automatic calculation of non-classical symmetries"}],

Cell[TextData[{
  "The Boussinesq equation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notation reads:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(boussinesq\  = \ 
      \[PartialD]\_t u[x, t]\  + \ u[x, t]\ \[PartialD]\_\(x, x\)u[x, t]\  + 
          \ \((\[PartialD]\_x u[x, t])\)\^2 + \ \[PartialD]\_{x, 4}u[x, t] == 
        0; boussinesq // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t + u\_x\%2 + u\ u\_\(x, x\) + u\_\(x, x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The point symmetries of the Boussinesq equation are", "Text",
  CellTags->"point symmetries of the Boussinesq equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(liePointSymmetries\  = \ Infinitesimals[boussinesq, u, {x, t}]; 
    liePointSymmetries\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == \(-2\)\ k3\ u\)},
          {\(\[Xi]\_1 == k2 + k3\ x\)},
          {\(\[Xi]\_2 == k1 + 4\ k3\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ -2, k3, u]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ k3, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 4, k3, t]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This finite dimensional group of order three contains translations and \
scaling transformations as symmetries. The non-classical symmetries follow by \
applying the function ",
  StyleBox["NonClassicalPointSymmetries[]", "MmaText"],
  ". This function assumes by default that the option ",
  StyleBox["NonclassicalCases", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "is set to the last variable of the independent variables. Typically, this \
variable is the time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". If you prefer to use another variable, for example, ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", you have to specify this change in the option ",
  StyleBox["NonclassicalCases", "MmaText",
    FontSlant->"Italic"],
  StyleBox["\[Rule]{x}", "MmaText"],
  ". The nonlinear determining equations follow from"
}], "Text",
  CellTags->"NonClassicalPointSymmetries[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdeter\  = \ NonClassicalPointSymmetries[boussinesq, {u}, {x, t}]; 
    ncdeter // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u, u\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x, u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x, x\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, x, x, u\) == 0\)},
          {
            \(\[Phi]\_1 + 2\ u\ \((\[Xi]\_1)\)\_x - 
                4\ \((\[Xi]\_1)\)\_\(x, x, x\) + 
                6\ \((\[Phi]\_1)\)\_\(x, x, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x, u, u\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u, u, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x, u\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u, u, u\) + 
                \((\[Phi]\_1)\)\_\(u, u, u, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u, u\) + 
                \((\[Phi]\_1)\)\_\(u, u, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 
              0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 
              0\)},
          {
            \(\[Phi]\_1\ \((\[Xi]\_2)\)\_u + \[Xi]\_1\ \((\[Xi]\_2)\)\_x - 
                \[Xi]\_2\ \((\[Xi]\_2)\)\_\(x, x, x, x\) == 0\)},
          {
            \(\(-\[Xi]\_2\%2\)\ \((\[Xi]\_1)\)\_t + 
                4\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                4\ \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_2)\)\_t + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\%2\ \((\[Xi]\_2)\)\_x + 
                2\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_x - 
                u\ \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_\(x, x\) + 
                2\ u\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, u\) - 
                \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_\(x, x, x, x\) + 
                4\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x, x, u\) == 0\)},
          {
            \(\(-4\)\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_2)\)\_t + 
                \[Phi]\_1\%2\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_x - 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_t - 
                u\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x\) - 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x, x, x\) == 0\)},
          {
            \(\(-4\)\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u + 
                2\ \[Xi]\_2\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_2\ \((\[Phi]\_1)\)\_u - 
                2\ u\ \[Xi]\_2\ \((\[Xi]\_1)\)\_\(x, u\) + 
                u\ \[Xi]\_2\ \((\[Phi]\_1)\)\_\(u, u\) - 
                4\ \[Xi]\_2\ \((\[Xi]\_1)\)\_\(x, x, x, u\) + 
                6\ \[Xi]\_2\ \((\[Phi]\_1)\)\_\(x, x, u, u\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a system of 29 coupled non-linear determining equations for \
the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  ". Only the last four equations are non-linear. The first 25 equations are \
linear. We can use these linear equations to find a partial solution of the \
determining equations. Before we apply a function to the total set of \
equations, let us rewrite the infinitesimals in such a way that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2 = 1\)]],
  ". Defining a general substitution for ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[2], we find"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncdeterh\  = 
      DeleteCases[
        \((\((ncdeter\  /. \ u[x, t] \[Rule] u)\)\ \  /. \ 
              xi[2] \[Rule] Function[{x, t, u}, 1])\) /. u \[Rule] u[x, t], 
        0]; ncdeterh\  // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u, u\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u, u, u\) == 0\)},
          {
            \(\[Phi]\_1 + 2\ u\ \((\[Xi]\_1)\)\_x - 
                4\ \((\[Xi]\_1)\)\_\(x, x, x\) + 
                6\ \((\[Phi]\_1)\)\_\(x, x, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x, u, u\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u, u, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x, u\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u, u\) == 0\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_\(x, x\) + 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u, u, u\) + 
                \((\[Phi]\_1)\)\_\(u, u, u, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u, u\) + 
                \((\[Phi]\_1)\)\_\(u, u, u\) == 0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 
              0\)},
          {
            \(\(-4\)\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 
              0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + 4\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                4\ \[Xi]\_1\ \((\[Xi]\_1)\)\_x + 2\ \((\[Phi]\_1)\)\_x - 
                u\ \((\[Xi]\_1)\)\_\(x, x\) + 
                2\ u\ \((\[Phi]\_1)\)\_\(x, u\) - 
                \((\[Xi]\_1)\)\_\(x, x, x, x\) + 
                4\ \((\[Phi]\_1)\)\_\(x, x, x, u\) == 0\)},
          {
            \(\(-4\)\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x - \((\[Phi]\_1)\)\_t - 
                u\ \((\[Phi]\_1)\)\_\(x, x\) - 
                \((\[Phi]\_1)\)\_\(x, x, x, x\) == 0\)},
          {
            \(\(-4\)\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u + 2\ \((\[Xi]\_1)\)\_x + 
                \((\[Phi]\_1)\)\_u - 2\ u\ \((\[Xi]\_1)\)\_\(x, u\) + 
                u\ \((\[Phi]\_1)\)\_\(u, u\) - 
                4\ \((\[Xi]\_1)\)\_\(x, x, x, u\) + 
                6\ \((\[Phi]\_1)\)\_\(x, x, u, u\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Applying now the general-purpose solver ",
  StyleBox["PDESolve[]", "MmaText"],
  " of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " to the system of coupled non-linear equations, we can automatically \
derive solutions. The function ",
  StyleBox["PDESolve[]", "MmaText"],
  " responds with a question concerning the solution branches of the \
non-linear determining equations. This interruption of the calculation is \
terminated by providing the number of the condition printed by the function:"
}], "Text",
  CellTags->{"PDESolve[]", "solution branches"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(partsol\  = \ PDESolve[ncdeter, {u}, {x, t}]; partsol // LTF\)], "Input"],

Cell[BoxData[
    \("There exists no unique solution of the equations."\)], "Output"],

Cell[BoxData[
    \("Please choose one of the following results"\)], "Output"],

Cell[BoxData[
    InterpretationBox[
      \(1\[InvisibleSpace]","\[InvisibleSpace]{\(free[3]\)[t] \[Rule] 0}\),
      SequenceForm[ 1, ",", {free[ 3][ t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"2", "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((2, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "\[Rule]", 
            "0"}], "}"}]}],
      SequenceForm[ 2, ",", {Derivative[ 2, 0][ 
          free[ 1]][ x, t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    \("There exists no unique solution of the equations."\)], "Output"],

Cell[BoxData[
    \("Please choose one of the following results"\)], "Output"],

Cell[BoxData[
    InterpretationBox[
      \(1\[InvisibleSpace]","\[InvisibleSpace]{\(free[3]\)[t] \[Rule] 0}\),
      SequenceForm[ 1, ",", {free[ 3][ t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"2", "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((3, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "\[Rule]", 
            "0"}], "}"}]}],
      SequenceForm[ 2, ",", {Derivative[ 3, 0][ 
          free[ 1]][ x, t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-2\)\ \[ScriptCapitalF]\_1\ 
                  \((\[ScriptCapitalF]\_2)\)\_t\%2 - 
                \[ScriptCapitalF]\_2\%2\ 
                  \((\[ScriptCapitalF]\_1)\)\_\(t, t\) + 
                \[ScriptCapitalF]\_2\ 
                  \((2\ \((\[ScriptCapitalF]\_1)\)\_t\ 
                        \((\[ScriptCapitalF]\_2)\)\_t + 
                      \[ScriptCapitalF]\_1\ 
                        \((\[ScriptCapitalF]\_2)\)\_\(t, t\))\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(\[ScriptCapitalF]\_2\), "+", 
                RowBox[{
                  StyleBox[\(1\/4\),
                    ScriptLevel->0], " ", "x", " ", 
                  \(\((\[ScriptCapitalF]\_1)\)\_t\)}], "-", 
                
                StyleBox[
                  \(\(x\ \[ScriptCapitalF]\_1\ 
                        \((\[ScriptCapitalF]\_2)\)\_t\)\/\(4\ 
                        \[ScriptCapitalF]\_2\)\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == \[ScriptCapitalF]\_1\)},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(1\/2\),
                  ScriptLevel->0], " ", "u", " ", 
                RowBox[{"(", 
                  RowBox[{\(-\((\[ScriptCapitalF]\_1)\)\_t\), "+", 
                    
                    StyleBox[
                      \(\(\[ScriptCapitalF]\_1\ 
                            \((\[ScriptCapitalF]\_2)\)\_t
                              \)\/\[ScriptCapitalF]\_2\),
                      ScriptLevel->0]}], ")"}]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 1], 
              Power[ 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t], 2]], 
            Times[ -1, 
              Power[ 
                Subscript[ \[ScriptCapitalF], 2], 2], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t, t]], 
            Times[ 
              Subscript[ \[ScriptCapitalF], 2], 
              Plus[ 
                Times[ 2, 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 1], t], 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 2], t]], 
                Times[ 
                  Subscript[ \[ScriptCapitalF], 1], 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 2], t, t]]]]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ 
              Rational[ 1, 4], x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Times[ 
              Rational[ -1, 4], x, 
              Subscript[ \[ScriptCapitalF], 1], 
              Power[ 
                Subscript[ \[ScriptCapitalF], 2], -1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], t]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 2], u, 
            Plus[ 
              Times[ -1, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t]], 
              Times[ 
                Subscript[ \[ScriptCapitalF], 1], 
                Power[ 
                  Subscript[ \[ScriptCapitalF], 2], -1], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t]]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We select the second case for each inquiry of ",
  StyleBox["PDESolve[]", "MmaText"],
  ". The result for these choices is a representation of the non-classical \
infinitesimals depending on two arbitrary functions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FormBox[\(\[ScriptCapitalF]\_i = \),
              "TraditionalForm"],
            "MmaText"], 
          RowBox[{
            StyleBox["free",
              FontSlant->"Italic"], 
            StyleBox["[",
              "MmaText"], 
            StyleBox["i",
              "MmaText"], 
            StyleBox["]",
              "MmaText"]}]}], TraditionalForm]]],
  StyleBox[", i = ",
    FontSlant->"Italic"],
  "1, 2. We know that for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  " the relation ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2 = 1\)]],
  " was assumed in the above calculation. Thus, we can set ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[1] = 1",
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ppsol\  = \ partsol\  /. \ free[1] \[Rule] Function[t, 1]; 
    \(ppsol // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              
              StyleBox[
                \(\(u\ \((\[ScriptCapitalF]\_2)\)\_t\)\/\(2\ 
                      \[ScriptCapitalF]\_2\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(\[ScriptCapitalF]\_2\), "-", 
                
                StyleBox[
                  \(\(x\ \((\[ScriptCapitalF]\_2)\)\_t\)\/\(4\ 
                        \[ScriptCapitalF]\_2\)\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == 1\)},
          {
            \(\(-2\)\ \((\[ScriptCapitalF]\_2)\)\_t\%2 + 
                \[ScriptCapitalF]\_2\ \((\[ScriptCapitalF]\_2)\)\_\(t, t\) == 
              0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 2], u, 
            Power[ 
              Subscript[ \[ScriptCapitalF], 2], -1], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 2], t]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ 
              Rational[ -1, 4], x, 
              Power[ 
                Subscript[ \[ScriptCapitalF], 2], -1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], t]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1], 
        Equal[ 
          Plus[ 
            Times[ -2, 
              Power[ 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t], 2]], 
            Times[ 
              Subscript[ \[ScriptCapitalF], 2], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], t, t]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The infinitesimals reduce to a simpler form containing only one \
undetermined function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FormBox[\(\[ScriptCapitalF]\_2 = \),
              "TraditionalForm"],
            "MmaText"], 
          RowBox[{
            StyleBox["free",
              FontSlant->"Italic"], 
            StyleBox["[",
              "MmaText"], 
            StyleBox["2",
              "MmaText"], 
            StyleBox["]",
              "MmaText"]}]}], TraditionalForm]]],
  ". This function has to satisfy the last determining equation, which is a \
second-order non-linear ODE. The partial results so far derived can be used \
in another calculation with ",
  StyleBox["PDESolve[]:", "MmaText"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(isol\  = \ PDESolve[ppsol, {u}, {x, t}]; isol\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              StyleBox[\(\(4 - k1\ x\)\/\(4\ k1\ k2 - 4\ k1\ t\)\),
                ScriptLevel->0]}]},
          {\(\[Xi]\_2 == 1\)},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              StyleBox[\(u\/\(2\ k2 - 2\ t\)\),
                ScriptLevel->0]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Power[ 
              Plus[ 
                Times[ 4, k1, k2], 
                Times[ -4, k1, t]], -1], 
            Plus[ 4, 
              Times[ -1, k1, x]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Power[ 
              Plus[ 
                Times[ 2, k2], 
                Times[ -2, t]], -1], u]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The final result of the calculation is a system of infinitesimals \
containing two parameters ",
  StyleBox["k1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k2",
    FontSlant->"Italic"],
  ". These two parameters determine the transformation properties of the \
non-classical infinitesimal transformation. The above representation of the \
infinitesimals is represented in a more convenient way by the following  \
transformations:"
}], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncinfi\  = 
      \(isol\  /. u[x, t] \[Rule] u\) /. \ 
          Rule[\(a_[n_]\)[h___], b_] \[Rule] 
            Rule[a[n], Function[$v, $w] /. {$v \[Rule] {h}, $w \[Rule] b}] // 
        Flatten; ncinfi // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              StyleBox[\(u\/\(2\ k2 - 2\ t\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              StyleBox[\(\(4 - k1\ x\)\/\(4\ k1\ k2 - 4\ k1\ t\)\),
                ScriptLevel->0]}]},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Power[ 
              Plus[ 
                Times[ 2, k2], 
                Times[ -2, t]], -1], u]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Power[ 
              Plus[ 
                Times[ 4, k1, k2], 
                Times[ -4, k1, t]], -1], 
            Plus[ 4, 
              Times[ -1, k1, x]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "After the rearrangements of the representation, we know the infinitesimals \
in a standard form which is helpful in the following calculations. Our aim is \
to derive solutions for the Boussinesq equation. To uncover the reduction of \
the Boussinesq equation, we first select a sub-class of the infinitesimal \
transformations with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k2",
            FontSlant->"Italic"], "=", "c"}], TraditionalForm]]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " a real constant:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      \({{\(xi[1]\)[x, t, u], \(xi[2]\)[x, t, u]}, {\(phi[1]\)[x, t, u]}}
            \  /. \ ncinfi\)\  /. \ {k1 \[Rule] 1, k2 \[Rule] c}\)], "Input"],

Cell[BoxData[
    \({{\(4 - x\)\/\(4\ c - 4\ t\), 1}, {u\/\(2\ c - 2\ t\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Inserting the equation and the infinitesimals into ",
  StyleBox["LieReduction[]", "MmaText"],
  " provides us with a reduction of the Boussinesq equation:"
}], "Text",
  CellTags->{"LieReduction[]", "reduction of the Boussinesq equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(red\  = \ 
      LieReduction[boussinesq, {u}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \((\(red // Flatten\) // LTF)\) /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[
                    FractionBox[
                      RowBox[{"c", 
                        StyleBox["+",
                          ScriptLevel->0], "t"}], \(\((\(-4\) + x)\)\^4\)],
                    ScriptLevel->0]}], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(u\ \((\(-4\) + x)\)\^2 - F\_1 == 0\)},
          {
            \(\((1 + 2904  \[Zeta]\_1)\) \((F\_1)\)\_\(\[Zeta]\_1\) + 
                2 \((5  F\_1\%2 + 
                      2 \( F\_1\) 
                        \((30 + 
                            13 \( \[Zeta]\_1\) \((F\_1)\)\_\(\[Zeta]\_1\) + 
                            4 \( \[Zeta]\_1\%2\) 
                              \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\))\) + 
                      8 \( \[Zeta]\_1\%2\) 
                        \((\((F\_1)\)\_\[Zeta]\_1\%2 + 
                            351 \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                            8 \( \[Zeta]\_1\) 
                              \((19 \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, 
                                      \[Zeta]\_1\) + 
                                  2 \( \[Zeta]\_1\) 
                                    \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, 
                                      \[Zeta]\_1, \[Zeta]\_1\))\))\))\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting reduction consists of a similarity representation of the \
original variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " containing an unknown function ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  ". This function has to satisfy a fourth-order ODE, which is easier to read \
if we rename the variables"
}], "Text",
  CellTags->"similarity representation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqr\  = \ 
      red\[LeftDoubleBracket]3, 1\[RightDoubleBracket]\  /. {F1 \[Rule] H, 
          zeta1 \[Rule] \[Zeta]}; eqr // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(120\ H + 10\ H\^2 + H\_\[Zeta] + 2904\ \[Zeta]\ H\_\[Zeta] + 
                52\ H\ \[Zeta]\ H\_\[Zeta] + 16\ \[Zeta]\^2\ H\_\[Zeta]\%2 + 
                5616\ \[Zeta]\^2\ H\_\(\[Zeta], \[Zeta]\) + 
                16\ H\ \[Zeta]\^2\ H\_\(\[Zeta], \[Zeta]\) + 
                2432\ \[Zeta]\^3\ H\_\(\[Zeta], \[Zeta], \[Zeta]\) + 
                256\ \[Zeta]\^4\ H\_\(\[Zeta], \[Zeta], \[Zeta], \[Zeta]\) == 
              0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"Surprisingly we can find a first integral of this complicated equation by \
integrating the left-hand side with respect to \[Zeta]."], "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqhh\  = \ 
      \[Integral]\((eqr\[LeftDoubleBracket]1\[RightDoubleBracket])\) 
            \[DifferentialD]\[Zeta] == K\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\((1 + 120\ \[Zeta])\)\ H[\[Zeta]]\), "+", 
        \(10\ \[Zeta]\ H[\[Zeta]]\^2\), "+", 
        RowBox[{"16", " ", \(\[Zeta]\^2\), " ", \((87 + H[\[Zeta]])\), " ", 
          RowBox[{
            SuperscriptBox["H", "\[Prime]",
              MultilineFunction->None], "[", "\[Zeta]", "]"}]}], "+", 
        RowBox[{"1408", " ", \(\[Zeta]\^3\), " ", 
          RowBox[{
            SuperscriptBox["H", "\[DoublePrime]",
              MultilineFunction->None], "[", "\[Zeta]", "]"}]}], "+", 
        RowBox[{"256", " ", \(\[Zeta]\^4\), " ", 
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "\[Zeta]", "]"}]}]}], "==", 
      "K"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  StyleBox["K ",
    FontSlant->"Italic"],
  "is the constant of integration. Now, the question is: Can we solve this \
third-order equation by Lie's methods? We know from S",
  ButtonBox["ection 4.4.3",
    ButtonData:>{"symmet4.nb", 
      "Higher order ordinary differential equations"},
    ButtonStyle->"Hyperlink"],
  " that a solution follows by quadratures if the equation possesses at least \
",
  StyleBox["n ",
    FontSlant->"Italic"],
  "symmetries, where ",
  StyleBox["n ",
    FontSlant->"Italic"],
  "is the largest order of derivatives. The first step in integrating the \
third-order ODE is the examination of the symmetries:"
}], "Text",
  CellTags->"quadratures"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ihh\  = \ Infinitesimals[eqhh, H, \[Zeta], {K}]; ihh\  // LTF\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_1 == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[
"The result is that the third-order ODE resulting from the Boussinesq \
equation does not allow any symmetry. Thus, the integration procedure by Lie \
fails. However, we are able to represent a solution by a numerical \
integration. The validity of the solution will be restricted by initial \
conditions and the finite interval for the similarity variable \[Zeta]. An \
example for a numerical integration is given below."], "Text",
  CellTags->{"numerical integration", "similarity variable"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"nboussinesq", " ", "=", " ", 
      RowBox[{"Map", "[", 
        RowBox[{
          RowBox[{
            RowBox[{"NDSolve", "[", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                  \(eqhh /. K \[Rule] #\), ",", \(H[0.1] == 0\), ",", 
                    RowBox[{
                      RowBox[{
                        SuperscriptBox["H", "\[Prime]",
                          MultilineFunction->None], "[", "0.1", "]"}], "==", 
                      "2"}], ",", 
                    RowBox[{
                      RowBox[{
                        SuperscriptBox["H", "\[DoublePrime]",
                          MultilineFunction->None], "[", "0.1", "]"}], "==", 
                      "1"}]}], "}"}], ",", "H", ",", 
                \({\[Zeta], 0.1, 15}\)}], "]"}], "&"}], ",", 
          \({1, 2, 3, 4, 5}\)}], "]"}]}]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"H", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.1`, 15.`}}, "<>"]\),
                False,
                Editable->False]}], "}"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The calculation is carried out by changing the constant ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " in steps of 1 from 1 to 5. The initial conditions are fixed for each \
integration. The result of the numerical solution is used to graphically \
represent the different solutions:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[H[\[Zeta]]\  /. nboussinesq], {\[Zeta],  .1, 6}, 
      AxesLabel \[Rule] {"\<\[Zeta]\>", "\<H\>"}, 
      PlotStyle 
        \[Rule] {RGBColor[1, 0, 0], RGBColor[0.996109, \ 0.996109, \ 0], 
          RGBColor[0.996109, \ 0.500008, \ 0], RGBColor[0, \ 0.500008, \ 0], 
          RGBColor[0, 0, 1]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 -0.313407 2.58011 [
[.18254 .19012 -3 -9 ]
[.18254 .19012 3 0 ]
[.34127 .19012 -3 -9 ]
[.34127 .19012 3 0 ]
[.5 .19012 -3 -9 ]
[.5 .19012 3 0 ]
[.65873 .19012 -3 -9 ]
[.65873 .19012 3 0 ]
[.81746 .19012 -3 -9 ]
[.81746 .19012 3 0 ]
[.97619 .19012 -3 -9 ]
[.97619 .19012 3 0 ]
[1.025 .20262 0 -7.5 ]
[1.025 .20262 10 7.5 ]
[.01131 .07361 -24 -4.5 ]
[.01131 .07361 0 4.5 ]
[.01131 .33162 -24 -4.5 ]
[.01131 .33162 0 4.5 ]
[.01131 .46063 -18 -4.5 ]
[.01131 .46063 0 4.5 ]
[.01131 .58963 -24 -4.5 ]
[.01131 .58963 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .20262 m
.18254 .20887 L
s
[(1)] .18254 .19012 0 1 Mshowa
.34127 .20262 m
.34127 .20887 L
s
[(2)] .34127 .19012 0 1 Mshowa
.5 .20262 m
.5 .20887 L
s
[(3)] .5 .19012 0 1 Mshowa
.65873 .20262 m
.65873 .20887 L
s
[(4)] .65873 .19012 0 1 Mshowa
.81746 .20262 m
.81746 .20887 L
s
[(5)] .81746 .19012 0 1 Mshowa
.97619 .20262 m
.97619 .20887 L
s
[(6)] .97619 .19012 0 1 Mshowa
.125 Mabswid
.05556 .20262 m
.05556 .20637 L
s
.0873 .20262 m
.0873 .20637 L
s
.11905 .20262 m
.11905 .20637 L
s
.15079 .20262 m
.15079 .20637 L
s
.21429 .20262 m
.21429 .20637 L
s
.24603 .20262 m
.24603 .20637 L
s
.27778 .20262 m
.27778 .20637 L
s
.30952 .20262 m
.30952 .20637 L
s
.37302 .20262 m
.37302 .20637 L
s
.40476 .20262 m
.40476 .20637 L
s
.43651 .20262 m
.43651 .20637 L
s
.46825 .20262 m
.46825 .20637 L
s
.53175 .20262 m
.53175 .20637 L
s
.56349 .20262 m
.56349 .20637 L
s
.59524 .20262 m
.59524 .20637 L
s
.62698 .20262 m
.62698 .20637 L
s
.69048 .20262 m
.69048 .20637 L
s
.72222 .20262 m
.72222 .20637 L
s
.75397 .20262 m
.75397 .20637 L
s
.78571 .20262 m
.78571 .20637 L
s
.84921 .20262 m
.84921 .20637 L
s
.88095 .20262 m
.88095 .20637 L
s
.9127 .20262 m
.9127 .20637 L
s
.94444 .20262 m
.94444 .20637 L
s
.25 Mabswid
0 .20262 m
1 .20262 L
s
gsave
1.025 .20262 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .07361 m
.03006 .07361 L
s
[(0.15)] .01131 .07361 1 0 Mshowa
.02381 .33162 m
.03006 .33162 L
s
[(0.25)] .01131 .33162 1 0 Mshowa
.02381 .46063 m
.03006 .46063 L
s
[(0.3)] .01131 .46063 1 0 Mshowa
.02381 .58963 m
.03006 .58963 L
s
[(0.35)] .01131 .58963 1 0 Mshowa
.125 Mabswid
.02381 .09941 m
.02756 .09941 L
s
.02381 .12521 m
.02756 .12521 L
s
.02381 .15101 m
.02756 .15101 L
s
.02381 .17681 m
.02756 .17681 L
s
.02381 .22842 m
.02756 .22842 L
s
.02381 .25422 m
.02756 .25422 L
s
.02381 .28002 m
.02756 .28002 L
s
.02381 .30582 m
.02756 .30582 L
s
.02381 .35742 m
.02756 .35742 L
s
.02381 .38322 m
.02756 .38322 L
s
.02381 .40902 m
.02756 .40902 L
s
.02381 .43483 m
.02756 .43483 L
s
.02381 .48643 m
.02756 .48643 L
s
.02381 .51223 m
.02756 .51223 L
s
.02381 .53803 m
.02756 .53803 L
s
.02381 .56383 m
.02756 .56383 L
s
.02381 .04781 m
.02756 .04781 L
s
.02381 .02201 m
.02756 .02201 L
s
.02381 .61543 m
.02756 .61543 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.05131 0 m
.05357 .04763 L
.05818 .124 L
.0676 .23722 L
.07278 .28219 L
.07767 .31672 L
.08269 .34581 L
.088 .37115 L
.09754 .40593 L
.1078 .43232 L
.11364 .44363 L
.11911 .45235 L
.12399 .45885 L
.12931 .46476 L
.13401 .4691 L
.13902 .47296 L
.14397 .47609 L
.14846 .47842 L
.15264 .4802 L
.15723 .48178 L
.16203 .48305 L
.16447 .48356 L
.16709 .48402 L
.16954 .48437 L
.17178 .48462 L
.17403 .48482 L
.17616 .48495 L
.17733 .48501 L
.17863 .48505 L
.17928 .48506 L
.17998 .48508 L
.18125 .48509 L
.18245 .48508 L
.18371 .48507 L
.18479 .48504 L
.18596 .485 L
.18736 .48494 L
.18864 .48487 L
.19149 .48467 L
.19663 .48417 L
.2014 .48355 L
.20645 .48275 L
.2155 .48102 L
.23595 .47596 L
.2732 .46428 L
.31287 .45029 L
.35105 .43644 L
.39164 .4219 L
.43073 .40834 L
.46834 .39583 L
Mistroke
.50836 .38313 L
.54689 .3715 L
.58783 .35975 L
.62728 .34901 L
.66524 .33917 L
.70561 .32922 L
.74449 .32009 L
.78188 .3117 L
.82168 .30317 L
.86 .29532 L
.90072 .28733 L
.93995 .27996 L
.97619 .27343 L
Mfstroke
.996 .996 0 r
.05122 0 m
.05357 .05004 L
.05818 .12796 L
.0676 .2445 L
.07278 .29123 L
.07767 .32735 L
.08269 .35797 L
.088 .38483 L
.09754 .42206 L
.1078 .45074 L
.11364 .46322 L
.11911 .47295 L
.12931 .48705 L
.13902 .49666 L
.14773 .5029 L
.15723 .50771 L
.16246 .50962 L
.16738 .51103 L
.1718 .51201 L
.17658 .51279 L
.17907 .51309 L
.1818 .51334 L
.18318 .51344 L
.18465 .51353 L
.18605 .51359 L
.18732 .51364 L
.18858 .51367 L
.18975 .51368 L
.19103 .51368 L
.19168 .51368 L
.19239 .51367 L
.19359 .51365 L
.19487 .51361 L
.19609 .51357 L
.1972 .51352 L
.19964 .51338 L
.20186 .51322 L
.20684 .51274 L
.21581 .51154 L
.22628 .50968 L
.23616 .50755 L
.27399 .49715 L
.31423 .48404 L
.35297 .47073 L
.39023 .4579 L
.4299 .44451 L
.46807 .43206 L
.50866 .41935 L
.54776 .40766 L
.58537 .3969 L
Mistroke
.62539 .38599 L
.66392 .37596 L
.70486 .36579 L
.74431 .35645 L
.78227 .34785 L
.82264 .3391 L
.86152 .33104 L
.89891 .32359 L
.93871 .31597 L
.97619 .30908 L
Mfstroke
.996 .5 0 r
.05114 0 m
.05357 .05246 L
.05818 .13192 L
.0676 .25177 L
.07278 .30027 L
.07767 .33798 L
.088 .39851 L
.09754 .43819 L
.10801 .46969 L
.11911 .49355 L
.12836 .50807 L
.13832 .51968 L
.14771 .52772 L
.15631 .53314 L
.161 .53546 L
.16599 .5375 L
.17031 .53895 L
.17498 .54023 L
.18048 .54137 L
.183 .54178 L
.18567 .54214 L
.18807 .54241 L
.19071 .54263 L
.19187 .54271 L
.19312 .54278 L
.19427 .54284 L
.19536 .54288 L
.19656 .54292 L
.19719 .54293 L
.19788 .54295 L
.19856 .54295 L
.19927 .54296 L
.20055 .54296 L
.20174 .54295 L
.20285 .54293 L
.20406 .5429 L
.20536 .54286 L
.20829 .54272 L
.21106 .54254 L
.21624 .54209 L
.22118 .54153 L
.22574 .54092 L
.23603 .53921 L
.25448 .5353 L
.27478 .53006 L
.31444 .5182 L
.35262 .50582 L
.39321 .4924 L
.43231 .4796 L
.46991 .4676 L
Mistroke
.50993 .45527 L
.54846 .44385 L
.5894 .43223 L
.62885 .42151 L
.66681 .41165 L
.70718 .4016 L
.74607 .39234 L
.78346 .3838 L
.82326 .37508 L
.86157 .36702 L
.90229 .3588 L
.94152 .35119 L
.97619 .34471 L
Mfstroke
0 .5 0 r
.05106 0 m
.05357 .05487 L
.05818 .13587 L
.0676 .25905 L
.07278 .30931 L
.07767 .34861 L
.088 .41218 L
.09754 .45432 L
.10801 .48816 L
.11911 .51414 L
.12836 .53021 L
.13832 .54328 L
.14771 .55254 L
.15631 .55896 L
.16599 .56433 L
.17498 .56789 L
.18015 .56943 L
.18484 .57053 L
.19026 .57151 L
.1929 .57188 L
.19536 .57217 L
.19775 .57239 L
.19993 .57256 L
.20236 .5727 L
.20369 .57276 L
.20496 .5728 L
.20618 .57283 L
.20748 .57285 L
.20859 .57286 L
.20982 .57286 L
.2105 .57285 L
.21113 .57285 L
.21182 .57284 L
.21254 .57282 L
.21376 .57279 L
.2151 .57275 L
.21749 .57264 L
.21965 .57252 L
.22451 .57215 L
.22901 .57171 L
.23327 .57121 L
.25295 .56802 L
.27109 .56409 L
.30984 .55377 L
.34709 .54251 L
.38676 .52996 L
.42494 .51781 L
.46553 .50508 L
.50462 .49315 L
.54223 .48204 L
Mistroke
.58225 .47064 L
.62078 .4601 L
.66172 .44935 L
.70117 .43942 L
.73913 .43025 L
.7795 .42088 L
.81838 .41222 L
.85577 .40421 L
.89557 .396 L
.93389 .38839 L
.97461 .38061 L
.97619 .38031 L
Mfstroke
0 0 1 r
.05099 0 m
.05357 .05729 L
.05818 .13983 L
.0676 .26632 L
.07278 .31836 L
.07767 .35924 L
.088 .42586 L
.09754 .47045 L
.10801 .50663 L
.11911 .53474 L
.12836 .55235 L
.13832 .56688 L
.14771 .57736 L
.15631 .58478 L
.16599 .59116 L
.17498 .59556 L
.18484 .59902 L
.19036 .60044 L
.19536 .60144 L
.20015 .60218 L
.20277 .6025 L
.20522 .60275 L
.20748 .60293 L
.20954 .60307 L
.21183 .60318 L
.21309 .60323 L
.21428 .60327 L
.21546 .60329 L
.21675 .60331 L
.2174 .60332 L
.21811 .60332 L
.21938 .60332 L
.22057 .6033 L
.22184 .60328 L
.22291 .60326 L
.22409 .60322 L
.22676 .60312 L
.22962 .60296 L
.23476 .60258 L
.24 .60208 L
.24483 .60151 L
.25575 .59993 L
.27556 .59618 L
.31431 .58668 L
.35156 .57604 L
.39123 .56401 L
.42941 .55223 L
.47 .5398 L
.5091 .52807 L
.5467 .5171 L
Mistroke
.58672 .5058 L
.62525 .49531 L
.66619 .48459 L
.70564 .47465 L
.7436 .46545 L
.78397 .45603 L
.82285 .4473 L
.86024 .43922 L
.90005 .43092 L
.93836 .42322 L
.97619 .41588 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 143.875},
  ImageMargins->{{60, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003H0000Sa000`40O003h00Of7oo003HOol00=Qo
o`00f7oo003HOol00=Qoo`006Woo00<007ooOol00Woo00<07gooOol0]Woo000JOol00`00Oomoo`02
Ool00`0OOomoo`2fOol001Yoo`03001oogoo009oo`0301moogoo0;Ioo`006Woo00<007ooOol00Woo
00<07gooOol0]Woo000JOol00`00Oomoo`02Ool00`0OOomoo`2fOol001Yoo`03001oogoo009oo`03
01moogoo0;Ioo`006Woo00<007ooOol00Woo00<07gooOol0]Woo000JOol00`00Oomoo`02Ool00`0O
Oomoo`2fOol001Yoo`03001oogoo009oo`0301moogoo0;Ioo`006Woo00<007ooOol00Woo00<07goo
Ool0]Woo000JOol00`00Oomoo`02Ool00`0OOomoo`2fOol0009oo`8000Aoo`8000=oo`D0009oo`80
00Aoo`03001oogoo009oo`0301moogoo0;Ioo`0000Eoo`00Oomoo`0000Yoo`05001oogooOol00002
Ool01@00Oomoogoo000017oo00<07gooOol0]Woo00001Goo001oogoo00002Woo00<007ooOol017oo
00@007ooOomoo`8000=oo`0301moogoo0;Ioo`0000Eoo`00Oomoo`0000Yoo`03001oogoo009oo`80
00Aoo`03001oogoo009oo`0301moogoo0;Ioo`0000Eoo`00Oomoo`0000Yoo`03001oogoo009oo`03
001oogoo00=oo`03001oogoo009oo`0301moogoo0;Ioo`000Woo0P002Woo0P0017oo0`000goo00<0
07ooOol00Woo00<07goPOol0]Woo000JOol00`00Oomoo`02Ool00`0O0N1oo`2fOol001Yoo`03001o
ogoo00=oo`0301moogoo0;Eoo`006Woo00<007ooOol00goo00<07gooOol0]Goo000JOol00`00Oomo
o`03Ool00`0OOomoo`2eOol001Yoo`03001oogoo00=oo`0301moogoo0;Eoo`006Woo00<007ooOol0
0goo00<07gooOol0]Goo000JOol00`00Oomoo`03Ool00`0OOomoo`2eOol001Yoo`03001oogoo00=o
o`0301moogoo0;Eoo`006Woo00<007ooOol00goo00<07gooOol0]Goo000JOol00`00Oomoo`03Ool0
0`0OOomoo`0AOol5000GOol4000JOol2000KOol3000HOol2000JOol3000COol001Yoo`03001oogoo
00=oo`0301moogoo01=oo`03001oogoo01Moo`03001oogoo01Yoo`04001oogoo000KOol00`00Oomo
o`0FOol01000Oomoo`006Goo00@007ooOol0019oo`006Woo00<007ooOol00goo00<07g`0Ool04goo
00<007ooOol067oo00<007ooOol06goo00<007ooOol05goo1@006Woo00<007ooOol05goo00@007oo
Ool0019oo`006Woo00<007ooOol00goo00<07goPOol04goo00<007ooOol06Goo00<007ooOol06goo
00<007ooOol05Woo00@007ooOol001Uoo`8001Yoo`<001=oo`006Woo00<007ooOol00goo00<07`7P
Ool04goo00<007ooOol05goo00@007ooOol001Uoo`04001oogoo000IOol00`00Ool0000IOol00`00
Oomoo`0JOol00`00Oomoo`0BOol001Yoo`03001oogoo00Aoo`0301moogoo015oo`8001Yoo`8001]o
o`8001]oo`8001Uoo`<001Yoo`<0019oo`006Woo00<007ooOol017oo00<07gooOol0]7oo000JOol0
0`00Oomoo`04Ool00`0OOomoo`2/Ool30005Ool001Yoo`03001oogoo00Aoo`0301moogoo0:]oo`05
001oogooOol00004Ool001Yoo`03001oogoo00Aoo`0301moogoo0:aoo`<000Eoo`005Goo300000<0
7`000000Y@001goo00<007ooOol01Goo000JOol00`00Oomoo`02Ool00`00Ool07`03Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomo
o`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomo
o`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`09Ool00`00Oomoo`05Ool001Yoo`03
001oogoo00Aoo`0301ml07oo0:aoo`03001oogoo00Eoo`006Woo00<007ooOol017oo00<07goPOol0
[Goo10000goo000JOol00`00Oomoo`04Ool00`0OON1oo`2dOol001Yoo`03001oogoo00Aoo`0301l1
h7oo0;Aoo`006Woo00<007ooOol017oo00<07`7POol0]7oo000JOol00`00Oomoo`05Ool00`0OOomo
o`2cOol001Yoo`03001oogoo00Eoo`0301moogoo0;=oo`006Woo00<007ooOol01Goo00<07gooOol0
/goo000JOol00`00Oomoo`05Ool00`0OOomoo`2cOol001Yoo`03001oogoo00Eoo`0301moogoo0;=o
o`006Woo00<007ooOol01Goo00<07gooOol0/goo000JOol00`00Oomoo`05Ool00`0OOomoo`2LOol4
O00COol001Yoo`03001oogoo00Eoo`0301moogoo09Eoo`Ml01Moo`006Woo00<007ooOol01Goo00<0
7gooOol0T7oo1G`07Woo000JOol00`00Oomoo`05Ool00`0OOomoo`2<Ool4O00SOol001Yoo`03001o
ogoo00Eoo`0301moogoo08Moo`El02Moo`006Woo00<007ooOol01Goo00<07g`0Ool0PWoo1G`0;7oo
000JOol00`00Oomoo`05Ool00`0OO01oo`1nOol4O00LOol2On0COol001Yoo`03001oogoo00Eoo`03
01moh7oo07Uoo`El01aoo`Aoh1Eoo`000Woo0P0017oo0P000goo10000goo0P0017oo00<007ooOol0
1Goo00<07goPOol0M7oo1G`077oo1GoP6Goo00001Goo001oogoo000027oo00<007ooOol00goo00@0
07ooOol000=oo`03001oogoo00Eoo`0301mmh7oo071oo`Al01Yoo`Moh1ioo`0000Eoo`00Oomoo`00
00Uoo`03001oogoo00Eoo`04001oogooOol20006Ool00`0O0N1oo`1]Ool3O00IOol5On0UOol00005
Ool007ooOol0000:Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`05Ool00`0O0N1l001YOol4O00H
Ool4On0ZOol00005Ool007ooOol00008Ool01000Oomoo`000goo00<007ooOol00goo00<007ooOol0
1Woo00<07g`0Ool0Hgoo1G`05goo1GoP;Woo0002Ool2000:Ool20004Ool30003Ool00`00Oomoo`06
Ool00`0OOn1oo`1NOol5O00GOol5On0MOol3ON0COol001Yoo`03001oogoo00Ioo`0301moh7oo05Yo
o`Al01Qoo`Aoh1]oo`Mmh1Ioo`006Woo00<007ooOol01Woo00<07ggPO000Egoo0g`05goo1GoP6Woo
1GgP7Goo000JOol00`00Oomoo`06Ool00`0O0N1l001COol4O00EOol5On0KOol4ON0ROol001Yoo`03
001oogoo00Ioo`0301l1h7`0051oo`=l01Eoo`Aoh1Yoo`Imh2Ioo`006Woo00<007ooOol01goo00<0
7goPOol0CGoo0W`05Goo0goP6Goo1GgP;7oo000JOol00`00Oomoo`07Ool00`0OOn1l001;Ool2O00C
Ool4On0HOol4ON0LOol20N0COol001Yoo`03001oogoo00Moo`0301mmh7`004Qoo`=l019oo`=oh1Qo
o`Amh1aoo`@1h1Eoo`006Woo00<007ooOol01goo00<07ggPO000A7oo17`04Goo17oP5Woo1GgP6Woo
1P7P6Goo000JOol00`00Oomoo`07Ool00`0O0N1oh011Ool3O00BOol3On0FOol4ON0HOol70N0OOol0
01Yoo`03001oogoo00Moo`0401l1h7oPO00lOol4O00AOol4On0FOol3ON0GOol50N0VOol001Yoo`03
001oogoo00Qoo`0301mmh7`003Uoo`=l019oo`=oh1Ioo`Amh1Moo`<1h2]oo`006Woo00<007ooOol0
27oo00@07ggPOoml03Aoo`Al015oo`Aoh1Aoo`Emh1Ioo`D1h1Uoo`807a=oo`006Woo00<007ooOol0
27oo00@07ggPOn1l035oo`=l019oo`=oh1=oo`Emh1Ioo`D1h1Yoo`@07aEoo`006Woo00<007ooOol0
27oo00D07`7POn1oog`002ioo`9l015oo`Aoh19oo`Amh1Moo`@1h1Yoo`D07aUoo`006Woo00<007oo
Ool027oo00D07`7PON1oog`002aoo`9l011oo`=oh1=oo`=mh1Moo`@1h1Uoo`D07aioo`006Woo00<0
07ooOol02Goo00D07ggPOn1oog`002Qoo`=l011oo`9oh19oo`Amh1Moo`<1h1Uoo`@07b=oo`006Woo
00<007ooOol02Goo00D07ggPOn1oog`002Ioo`9l015oo`9oh11oo`Amh1Ioo`D1h1Moo`D07bMoo`00
27oo0P0017oo0P0017oo0P0017oo00<007ooOol02Goo00H07`7PON1oh7ooO00SOol2O00@Ool3On0?
Ool3ON0EOol50N0GOol501l/Ool000Moo`04001oogoo0008Ool01000Oomoo`000goo00<007ooOol0
2Goo00H07`7PON1oh7ooO00POol3O00>Ool4On0?Ool3ON0DOol40N0HOol401laOol000Moo`04001o
ogoo000:Ool00`00Oomoo`02Ool2000;Ool01P0OON1oogoPOoml01]oo`Al00ioo`=oh15oo`9mh1=o
o`@1h1Moo`D07cEoo`001goo00@007ooOol000]oo`05001oogooOol0000<Ool0100O0N1mh7oP0Woo
00=l07ooOol05Goo0g`03goo0goP4Goo0ggP4Goo107P5Woo1@0O>Woo0007Ool01000Oomoo`0027oo
00@007ooOol000=oo`03001oogoo00Yoo`0701l1h7gPOomoh7ooO00057oo0g`03goo0goP4Goo0ggP
4Goo0`7P5Woo100O?goo0008Ool2000:Ool20004Ool00`00Oomoo`0:Ool01@0O0N1ooggPOn000Woo
0W`03goo0g`047oo0WoP4Goo0ggP47oo107P5Woo0`0O@goo000JOol00`00Oomoo`0;Ool01@0O0N1m
h7ooOn000goo17`01Goo1W`04Goo0WoP47oo0ggP47oo0`7P5Woo100OAWoo000JOol00`00Oomoo`0;
Ool01P0O0N1ooggPOomoh0Eoo`Ml01=oo`=oh0ioo`Amh11oo`<1h1Ioo`<07dYoo`006Woo00<007oo
Ool02goo00@07`7POommh09oo`03On1oogoo01Qoo`Aoh0ioo`=mh15oo`<1h1Eoo`@07deoo`006Woo
00<007ooOol02goo00@07goo0N1mh09oo`03On1oogoo01Aoo`Aoh0ioo`Amh11oo`@1h1=oo`D07e5o
o`006Woo00<007ooOol037oo00@07`7POommh09oo`9oh15oo`=oh0moo`=mh15oo`<1h19oo`D07eIo
o`006Woo00<007ooOol037oo00@07goo0N1mh0Aoo`=oh0Qoo`Ioh11oo`9mh19oo`81h15oo`@07e]o
o`006Woo00<007ooOol037oo00D07goo0N1ooggP00Ioo`Qoh1Aoo`9mh15oo`<1h11oo`<07emoo`00
6Woo00<007ooOol03Goo00D07`7POomooggP01ioo`=mh11oo`<1h0moo`@07f9oo`006Woo00<007oo
Ool03Goo00<07goo0N000Woo0WgP67oo17gP47oo0`7P3goo0`0OIWoo000JOol00`00Oomoo`0>Ool0
0`0O0N1oo`03Ool00ggPOomoo`0BOol3ON0AOol30N0@Ool201mYOol001Yoo`03001oogoo00ioo`03
01moo`7P00Aoo`=mh0]oo`Imh11oo`@1h15oo`807f]oo`006Woo00<007ooOol03Woo00@07gooOol1
h0Ioo`]mh19oo`@1h19oo`<07feoo`006Woo00<007ooOol03goo00@07gooOol1h1moo`<1h19oo`@0
7g1oo`006Woo00<007ooOol03goo00D07gooOomoo`7P01]oo`<1h19oo`<07gAoo`006Woo00<007oo
Ool047oo00D07gooOomoo`7P01Ioo`@1h15oo`@07gMoo`006Woo00<007ooOol04Goo00@07gooOomo
o`81h15oo`<1h19oo`<07g]oo`006Woo00<007ooOol04Woo00<07gooOol00Woo4@7P4Goo100OOWoo
0002Ool20004Ool20004Ool20004Ool20004Ool00`00Oomoo`0COol00`0OOomoo`0POol301n2Ool0
0005Ool007ooOol00008Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo01Aoo`0301mo
ogoo01aoo`<07hEoo`0000Eoo`00Oomoo`0000Yoo`03001oogoo00Aoo`04001oogooOol2000EOol0
0`0OOomoo`0IOol301n8Ool00005Ool007ooOol0000;Ool01000Oomoogoo0P0017oo00<007ooOol0
5Goo100O4goo100ORgoo00001Goo001oogoo000027oo00@007ooOol000=oo`03001oogoo00=oo`03
001oogoo01Uoo`807`]oo`H07hmoo`000Woo0P002Woo0P0017oo0`000goo00<007ooOol06goo2`0O
UGoo000JOol00`00Oomoo`2kOol001Yoo`03001oogoo0;]oo`006Woo00<007ooOol0^goo003HOol0
0=Qoo`00f7oo003HOol00=Qoo`00f7oo003HOol00=Qoo`00f7oo000GOol300000goo0000002kOol0
01Qoo`04001oogoo002lOol001Qoo`04001oogoo002lOol001Qoo`@00;aoo`0067oo00@007ooOol0
0;aoo`005goo0P0000Aoo`0000000;]oo`00f7oo003HOol00=Qoo`00f7oo003HOol00=Qoo`00f7oo
003HOol00=Qoo`00f7oo0000\
\>"],
  ImageRangeCache->{{{0, 215}, {142.875, 0}} -> {-0.925583, 0.107296, \
0.0352835, 0.00217066}}]
}, Open  ]],

Cell[TextData[{
  "The numerical solution is connected with the similarity solution via the \
similarity transformation. We can now at least numerically represent the \
non-classical similarity solution for the Boussinesq equation. The example \
demonstrates that the\[NonBreakingSpace]\[NoBreak]functions of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " support a pseudo-automatic procedure for the non-classical\
\[NonBreakingSpace]\[NoBreak]method. The interactions are reduced to a \
minimal number of steps. We\[NonBreakingSpace]\[NoBreak]also\
\[NonBreakingSpace]\[NoBreak]demonstrated that ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is capable of solving non-linear determining equations with a decision \
support provided by the user. The functions ",
  StyleBox["NonClassicalPointSymmetries[]", "MmaText"],
  " and ",
  StyleBox["PDESolve[]", "MmaText"],
  " reduce the solution steps and the interaction to a convenient number."
}], "Text",
  CellTags->{
  "numerical solution", "similarity transformation", 
    "NonClassicalPointSymmetries[]", "PDESolve[]"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3.3 The Fokker-Planck Equation", "Subsection",
  CellTags->"The Fokker-Planck equation"],

Cell[TextData[{
  "The Fokker-Planck (FP) equation is a general equation to describe \
statistical phenomena in condensed matter physics, quantum optics, chemical \
physics, and fluctuations in many other physical problems. For a detailed \
discussion of the Fokker-Planck equation, we refer to the book by ",
  ButtonBox["Risken [1984]",
    ButtonData:>{"Literat.nb", "Risken-1984"},
    ButtonStyle->"Hyperlink"],
  ". In this section, we restrict our considerations to the (1+1)-dimensional \
version of the FP equation"
}], "Text",
  CellTags->{
  "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
    "condensed matter physics", "quantum optics", "chemical physics", 
    "fluctuations", "FP-equation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_t\  = \ \((\(a(x)\)\ u)\)\_x\  + \ \((\(b(x)\)\ u)\)\_\(x, x\), 
    \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`a(x)\)]],
  " denotes the drift and ",
  Cell[BoxData[
      \(TraditionalForm\`b(x)\)]],
  " the diffusion coefficient. Both coefficients are functions of the spatial \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Subscripts in equation (6.19) denote partial derivatives with respect to \
time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Let us assume that we have a system with constant diffusion ",
  Cell[BoxData[
      \(TraditionalForm\`b(x) = 1\)]],
  " and a linear drift term ",
  Cell[BoxData[
      \(TraditionalForm\`a(x) = x\)]],
  ". Such a situation is possible for a Brownian particle in a liquid (",
  ButtonBox["Cicogna and Vitali [1990]",
    ButtonData:>{"Literat.nb", "Cicogna-1990"},
    ButtonStyle->"Hyperlink"],
  "). Under these conditions, equation (6.19) reduces to"
}], "Text",
  CellTags->{
  "Brownian particle in a liquid", "diffusion coefficient", 
    "drift coefficient"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(fokkerPlanck\  = \ 
      \[PartialD]\_t u[x, t] - \ x\ \[PartialD]\_x u[x, t]\  - 
          \[PartialD]\_\(x, x\)u[x, t] == 0; fokkerPlanck // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - x\ u\_x - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The point symmetries of this equation are", "Text",
  CellTags->"point symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ifokkerPlanck = Infinitesimals[fokkerPlanck, u, {x, t}]; 
    ifokkerPlanck // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                x\ \((\[ScriptCapitalF]\_1)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(E\^\(-t\)\ k1\), "+", \(E\^t\ k2\), "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(\(-2\)\ t\)\), " ", 
                  \((\(-E\^\(4\ t\)\)\ k3 + k5)\), " ", "x"}]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{
                RowBox[{
                  RowBox[{"-", 
                    StyleBox[\(1\/2\),
                      ScriptLevel->0]}], " ", \(E\^\(2\ t\)\), " ", "k3"}], 
                "-", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(\(-2\)\ t\)\), " ", "k5"}], 
                "+", "k6"}]}]},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", "u", " ", 
                  \((E\^\(2\ t\)\ k3 + 2\ k4 - 2\ E\^t\ k2\ x + 
                      E\^\(2\ t\)\ k3\ x\^2)\)}], "+", 
                \(\[ScriptCapitalF]\_1\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Times[ x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Times[ 
              Power[ E, 
                Times[ -1, t]], k1], 
            Times[ 
              Power[ E, t], k2], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ -2, t]], 
              Plus[ 
                Times[ -1, 
                  Power[ E, 
                    Times[ 4, t]], k3], k5], x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ 2, t]], k3], 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ -2, t]], k5], k6]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ 
              Rational[ 1, 2], u, 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, t]], k3], 
                Times[ 2, k4], 
                Times[ -2, 
                  Power[ E, t], k2, x], 
                Times[ 
                  Power[ E, 
                    Times[ 2, t]], k3, 
                  Power[ x, 2]]]], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a six-dimensional finite group extended by an infinite group \
given by ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "]. The arbitrary function ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] satisfies the FP equation. The structure of the group has some \
resemblance to the group of the heat equation. However, the detailed \
structure is completely different."
}], "Text",
  CellTags->"heat equation"],

Cell[TextData[{
  "The next step of our examination is the determination of the non-classical \
symmetries. To derive the non-classical determining equations for the FP \
equation, we apply the operator ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              StyleBox[
                TagBox[
                  StyleBox["\[ScriptN]\[ScriptCapitalP]\[ScriptCapitalS]",
                    FontSize->10],
                  NotationBoxTag,
                  Editable->True],
                FontSize->10], \(u, x\), "\[Gamma]"], "[", "\[CapitalDelta]", 
            "]"}], " "}], TraditionalForm]]],
  " to the equation"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"ncfokkerPlanck", " ", "=", " ", 
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptN]\[ScriptCapitalP]\[ScriptCapitalS]",
                  FontSize->10],
                NotationBoxTag,
                Editable->True],
              "Null",
              ScriptLevel->0], \({u}, {x, t}\), \({}\)], "[", "fokkerPlanck", 
          "]"}]}], ";", \(ncfokkerPlanck // LTF\)}]], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {\(\((\[Xi]\_2)\)\_\(x, u\) == 0\)},
          {
            \(\[Phi]\_1\ \((\[Xi]\_2)\)\_u + \[Xi]\_1\ \((\[Xi]\_2)\)\_x + 
                \[Xi]\_2\ \((\[Xi]\_2)\)\_\(x, x\) == 0\)},
          {
            \(\(-\[Xi]\_1\)\ \[Xi]\_2\%2 - \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_t + 
                2\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_1)\)\_x - 
                x\ \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_1\ \[Xi]\_2\ \((\[Xi]\_2)\)\_t + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\%2\ \((\[Xi]\_2)\)\_x + 
                \[Xi]\_2\%2\ \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-2\)\ \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x + 
                \[Xi]\_2\ \[Phi]\_1\ \((\[Xi]\_2)\)\_t + 
                \[Phi]\_1\%2\ \((\[Xi]\_2)\)\_u + 
                \[Xi]\_1\ \[Phi]\_1\ \((\[Xi]\_2)\)\_x - 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_t + 
                x\ \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_x + 
                \[Xi]\_2\%2\ \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {
            \(2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u + 
                2\ x\ \[Xi]\_2\ \((\[Xi]\_1)\)\_u - 
                2\ \[Xi]\_2\ \((\[Xi]\_1)\)\_\(x, u\) + 
                \[Xi]\_2\ \((\[Phi]\_1)\)\_\(u, u\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Again, we assume that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2 = 1\)]],
  " thus we can simplify the non-classical determining equations by"
}], "Text",
  CellTags->"non-classical determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(deteqFP\  = \ 
      DeleteCases[
          \((ncfokkerPlanck\  /. u[x, t] \[Rule] u)\) /. \ 
            xi[2] \[Rule] Function[{x, t, u}, 1], 0]\  /. u \[Rule] u[x, t]; 
    deteqFP // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_\(u, u\) == 0\)},
          {
            \(\(-\[Xi]\_1\) - \((\[Xi]\_1)\)\_t + 
                2\ \[Phi]\_1\ \((\[Xi]\_1)\)\_u - x\ \((\[Xi]\_1)\)\_x - 
                2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_x + \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\(-2\)\ \[Phi]\_1\ \((\[Xi]\_1)\)\_x - \((\[Phi]\_1)\)\_t + 
                x\ \((\[Phi]\_1)\)\_x + \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {
            \(2\ x\ \((\[Xi]\_1)\)\_u + 2\ \[Xi]\_1\ \((\[Xi]\_1)\)\_u - 
                2\ \((\[Xi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(u, u\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we apply ",
  StyleBox["PDESolve[]", "MmaText"],
  " to the derived equations, the solution of the non-classical determining \
equations follow. This function originally designed for linear PDEs is \
capable of solving some kind of non-linear equations if some hints are \
supplied to the function. In the present case, ",
  StyleBox["PDESolve[]", "MmaText"],
  " detects a situation in which either a function ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["2",
    FontSlant->"Italic"],
  "]",
  StyleBox[" ",
    FontSlant->"Italic"],
  "or ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["6",
    FontSlant->"Italic"],
  "] can be set equal to zero. The function asks the user to decide which of \
these possibilities it should take. The following calculation is carried out \
under the second possibility:"
}], "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1\  = \ PDESolve[deteqFP, {u}, {x, t}]; inf1 // LTF\)], "Input"],

Cell[BoxData[
    \("There exists no unique solution of the equations."\)], "Output"],

Cell[BoxData[
    \("Please choose one of the following results"\)], "Output"],

Cell[BoxData[
    InterpretationBox[
      \(1\[InvisibleSpace]","\[InvisibleSpace]{\(free[2]\)[x, t] \[Rule] 0}
          \),
      SequenceForm[ 1, ",", {free[ 2][ x, t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[
      \(2\[InvisibleSpace]","\[InvisibleSpace]{\(free[6]\)[x, t] \[Rule] 0}
          \),
      SequenceForm[ 2, ",", {free[ 6][ x, t] -> 0}],
      Editable->False]], "Output"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Xi]\_1 == \[ScriptCapitalF]\_1\)},
          {\(\[Phi]\_1 == \[ScriptCapitalF]\_2 + u\ \[ScriptCapitalF]\_3\)},
          {
            \(\(-\[ScriptCapitalF]\_1\) - \((\[ScriptCapitalF]\_1)\)\_t - 
                x\ \((\[ScriptCapitalF]\_1)\)\_x - 
                2\ \[ScriptCapitalF]\_1\ \((\[ScriptCapitalF]\_1)\)\_x - 
                2\ \((\[ScriptCapitalF]\_3)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {
            \(\(-2\)\ \[ScriptCapitalF]\_2\ \((\[ScriptCapitalF]\_1)\)\_x - 
                \((\[ScriptCapitalF]\_2)\)\_t + 
                x\ \((\[ScriptCapitalF]\_2)\)\_x + 
                \((\[ScriptCapitalF]\_2)\)\_\(x, x\) == 0\)},
          {
            \(\(-2\)\ \[ScriptCapitalF]\_3\ \((\[ScriptCapitalF]\_1)\)\_x - 
                \((\[ScriptCapitalF]\_3)\)\_t + 
                x\ \((\[ScriptCapitalF]\_3)\)\_x + 
                \((\[ScriptCapitalF]\_3)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ u, 
              Subscript[ \[ScriptCapitalF], 3]]]], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Times[ -1, x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -2, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 3], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Plus[ 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 2], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], t]], 
            Times[ x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 2], x, x]], 0], 
        Equal[ 
          Plus[ 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 3], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 3], t]], 
            Times[ x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 3], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 3], x, x]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of the calculation is a general representation of the \
infinitesimals depending on three arbitrary functions",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox[
              FormBox[\(\[ScriptCapitalF]\_i = \),
                "TraditionalForm"],
              "MmaText"], 
            RowBox[{
              StyleBox["free",
                FontSlant->"Italic"], 
              StyleBox["[",
                "MmaText"], 
              StyleBox["i",
                "MmaText"], 
              StyleBox["]",
                "MmaText"]}]}]}], TraditionalForm]]],
  StyleBox[", i=",
    FontSlant->"Italic"],
  "1, 2, 3",
  StyleBox[" ",
    FontSlant->"Italic"],
  "which have to satisfy three nonlinear coupled PDEs. These PDEs again allow \
some symmetries. In the following, we determine the point symmetries of the \
non-classical non-linear determining equations. We gain a simpler \
representation by renaming the arbitrary functions ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["i",
    FontSlant->"Italic"],
  "] by"
}], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1h\  = \ 
      inf1\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. 
        \ {free[1] \[Rule] g, free[2] \[Rule] h, free[3] \[Rule] f}; 
    inf1h // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-g\) - 2\ f\_x - g\_t - 2\ g\ g\_x - x\ g\_x + g\_\(x, x\) == 
              0\)},
          {\(\(-2\)\ h\ g\_x - h\_t + x\ h\_x + h\_\(x, x\) == 0\)},
          {\(\(-f\_t\) + x\ f\_x - 2\ f\ g\_x + f\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
For this set of equations, we determine the infinitesimals by\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1hh\  = \ Infinitesimals[inf1h, {g, h, f}, {x, t}]; 
    inf1hh // LTF\)], "Input"],

Cell[BoxData[
    \(PDESolve::"nsf" \( : \ \) 
      "Use option Standard->True. \n This may lead to further\:f39fsolutions \
in case of linear Systems"\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                x\ \((\[ScriptCapitalF]\_1)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(E\^\(-t\)\ k1\), "+", \(E\^t\ k2\), "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(\(-2\)\ t\)\), " ", 
                  \((k3 + E\^\(4\ t\)\ k4)\), " ", "x"}]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{
                RowBox[{
                  RowBox[{"-", 
                    StyleBox[\(1\/2\),
                      ScriptLevel->0]}], " ", \(E\^\(\(-2\)\ t\)\), " ", 
                  "k3"}], "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(2\ t\)\), " ", "k4"}], "+", 
                "k5"}]}]},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(1\/2\),
                    ScriptLevel->0]}], " ", \(E\^\(\(-2\)\ t\)\), " ", 
                \((2\ E\^t\ k1 - 2\ E\^\(3\ t\)\ k2 + g\ k3 + 
                    E\^\(4\ t\)\ g\ k4 + 2\ k3\ x - 2\ E\^\(4\ t\)\ k4\ x)
                  \)}]}]},
          {
            RowBox[{\(\[Phi]\_2\), "==", 
              RowBox[{\(\(-E\^\(\(-2\)\ t\)\)\ h\ k3\), "-", 
                RowBox[{
                  StyleBox[\(3\/2\),
                    ScriptLevel->0], " ", \(E\^\(2\ t\)\), " ", "h", " ", 
                  "k4"}], "+", \(h\ k6\), "-", \(E\^t\ h\ k2\ x\), "-", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(2\ t\)\), " ", "h", " ", 
                  "k4", " ", \(x\^2\)}], "+", \(f\ \[ScriptCapitalF]\_1\), 
                "-", \(\((g + x)\)\ \((\[ScriptCapitalF]\_1)\)\_x\), "-", 
                \(\((\[ScriptCapitalF]\_1)\)\_\(x, x\)\)}]}]},
          {
            \(\[Phi]\_3 == 
              \(-E\^\(\(-2\)\ t\)\)\ 
                \((f\ \((k3 + E\^\(4\ t\)\ k4)\) + 
                    E\^\(3\ t\)\ g\ \((k2 + E\^t\ k4\ x)\) + 
                    E\^\(3\ t\)\ \((E\^t\ k4 + k2\ x + E\^t\ k4\ x\^2)\))
                  \)\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Times[ x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Times[ 
              Power[ E, 
                Times[ -1, t]], k1], 
            Times[ 
              Power[ E, t], k2], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ -2, t]], 
              Plus[ k3, 
                Times[ 
                  Power[ E, 
                    Times[ 4, t]], k4]], x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ -2, t]], k3], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ 2, t]], k4], k5]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ -1, 2], 
            Power[ E, 
              Times[ -2, t]], 
            Plus[ 
              Times[ 2, 
                Power[ E, t], k1], 
              Times[ -2, 
                Power[ E, 
                  Times[ 3, t]], k2], 
              Times[ g, k3], 
              Times[ 
                Power[ E, 
                  Times[ 4, t]], g, k4], 
              Times[ 2, k3, x], 
              Times[ -2, 
                Power[ E, 
                  Times[ 4, t]], k4, x]]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Plus[ 
            Times[ -1, 
              Power[ E, 
                Times[ -2, t]], h, k3], 
            Times[ 
              Rational[ -3, 2], 
              Power[ E, 
                Times[ 2, t]], h, k4], 
            Times[ h, k6], 
            Times[ -1, 
              Power[ E, t], h, k2, x], 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ 2, t]], h, k4, 
              Power[ x, 2]], 
            Times[ f, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, 
              Plus[ g, x], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x, x]]]], 
        Equal[ 
          Subscript[ \[Phi], 3], 
          Times[ -1, 
            Power[ E, 
              Times[ -2, t]], 
            Plus[ 
              Times[ f, 
                Plus[ k3, 
                  Times[ 
                    Power[ E, 
                      Times[ 4, t]], k4]]], 
              Times[ 
                Power[ E, 
                  Times[ 3, t]], g, 
                Plus[ k2, 
                  Times[ 
                    Power[ E, t], k4, x]]], 
              Times[ 
                Power[ E, 
                  Times[ 3, t]], 
                Plus[ 
                  Times[ 
                    Power[ E, t], k4], 
                  Times[ k2, x], 
                  Times[ 
                    Power[ E, t], k4, 
                    Power[ x, 2]]]]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The infinitesimals represent a six-dimensional finite group and an \
infinite one given by the arbitrary function ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ". Surprisingly, this function must satisfy the original equation with \
which we started. Now you see another reason why we changed the names of the \
three arbitrary functions in the non-classical analysis preventing mismatches \
of the two calculations. Knowing the point symmetries of the non-classical \
determining equations, we can reduce the equations by applying ",
  StyleBox["LieReduction[]:", "MmaText"]
}], "Text",
  CellTags->{
  "point symmetries of the non-classical determining equations", 
    "LieReduction[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      \({{\(xi[1]\)[x, t, g, h, f], \(xi[2]\)[x, t, g, h, f]}, {
                \(phi[1]\)[x, t, g, h, f], \(phi[2]\)[x, t, g, h, f], 
                \(phi[3]\)[x, t, g, h, f]}} /. 
            inf1hh\[LeftDoubleBracket]1\[RightDoubleBracket]\)\  /. {
            k1 \[Rule] 1, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 0, 
            k5 \[Rule] 1, k6 \[Rule] 0, 
            free[___] \[Rule] Function[{x, t}, 0]} // Expand\)], "Input"],

Cell[BoxData[
    \({{E\^\(-t\), 1}, {\(-E\^\(-t\)\), 0, 0}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "For the sub-group ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", " ", 
          RowBox[{
            StyleBox["k5",
              FontSlant->"Italic"], " ", "=", "1"}]}], TraditionalForm]]],
  ", the reduction is gained by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1\  = \ 
      LieReduction[inf1h, {g, h, f}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \(\((red1 /. zeta1 \[Rule] \[Zeta]\_1)\) // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Output"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(E\^\(-t\) + x - \[Zeta]\_1 == 0\)},
          {\(g + x - F\_1 == 0\)},
          {\(h - F\_2 == 0\)},
          {\(f - F\_3 == 0\)},
          {
            \(F\_1 - 2\ F3\_\(\[Zeta]\_1\) - 
                2\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                \[Zeta]\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)},
          {
            \(2\ F\_2 - 2\ F\_2\ F1\_\(\[Zeta]\_1\) + 
                \[Zeta]\_1\ \((F\_2)\)\_\(\[Zeta]\_1\) + 
                \((F\_2)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)},
          {
            \(2\ F\_3 - 2\ F\_3\ F1\_\(\[Zeta]\_1\) + 
                \[Zeta]\_1\ \((F\_3)\)\_\(\[Zeta]\_1\) + 
                \((F\_3)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We find a coupled non-linear system of ODEs for the similarity functions ",
  
  Cell[BoxData[
      \(TraditionalForm\`F1, \ F2, \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`F3\)]],
  ". A special solution follows by choosing ",
  Cell[BoxData[
      \(TraditionalForm\`F2 = \(F3 = 0\)\)]],
  ":"
}], "Text",
  CellTags->"similarity function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\  /. {
            F2 \[Rule] Function[zeta1, 0], F3 \[Rule] Function[zeta1, 0]}
            \) /. zeta1 \[Rule] \[Zeta]\_1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(F\_1 - 2\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                \[Zeta]\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)},
          {"True"},
          {"True"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The remaining ODE for ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " is solved by means of ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"psol", " ", "=", " ", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{\(F1[zeta1]\), "+", 
              RowBox[{"zeta1", " ", 
                RowBox[{
                  SuperscriptBox["F1", "\[Prime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
              RowBox[{"2", " ", \(F1[zeta1]\), " ", 
                RowBox[{
                  SuperscriptBox["F1", "\[Prime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}], "+", 
              RowBox[{
                SuperscriptBox["F1", "\[DoublePrime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}], "==", 
            "0"}], ",", "F1", ",", "zeta1"}], "]"}]}]], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((\(\(-2\)\ E\^\(#1\^2\/2\)\ \@#1\^2 + 2\ #1\^2\ C[1] + 
                  \@\(2\ \[Pi]\)\ #1\^2\ Erfi[\@#1\^2\/\@2]\)\/\(#1\ 
                  \((2\ C[1] + \@\(2\ \[Pi]\)\ Erfi[\@#1\^2\/\@2])\)\)&)\)}}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution for ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " contains the special function ",
  StyleBox["Erfi[]", "MmaText"],
  ". The inversion of the used transformations provides the solution for the \
unknown functions ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ", ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["2", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ", and ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["3", "MmaText",
    FontSlant->"Italic"],
  StyleBox["] ", "MmaText"],
  "of the non-classical symmetries:"
}], "Text",
  CellTags->{"special function", "Erfi[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solg
      \  = {free[1] \[Rule] Function[{x, t}, g], 
          free[2] \[Rule] Function[{x, t}, h], 
          free[3] \[Rule] Function[{x, t}, f]} /. 
        Solve[\((
              \(red1\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. \ psol
                  \)\  /. {F2 \[Rule] Function[zeta1, 0], 
                  F3 \[Rule] Function[zeta1, 0]})\) // Flatten, {g, h, f}]
          \)], "Input"],

Cell[BoxData[
    \({{free[1] \[Rule] 
          Function[{x, t}, 
            \(-x\) + 
              \((\(-2\)\ E\^\(1\/2\ \((E\^\(-t\) + x)\)\^2\)\ 
                      \@\((E\^\(-t\) + x)\)\^2 + 
                    2\ \((E\^\(-t\) + x)\)\^2\ C[1] + 
                    \@\(2\ \[Pi]\)\ \((E\^\(-t\) + x)\)\^2\ 
                      Erfi[\@\((E\^\(-t\) + x)\)\^2\/\@2])\)/
                \((\((E\^\(-t\) + x)\)\ 
                    \((2\ C[1] + 
                        \@\(2\ \[Pi]\)\ Erfi[\@\((E\^\(-t\) + x)\)\^2\/\@2])
                      \))\)], free[2] \[Rule] Function[{x, t}, 0], 
        free[3] \[Rule] Function[{x, t}, 0]}}\)], "Output"]
}, Open  ]],

Cell["\<\
The check of the initial determining equations reveals that, in \
fact, the given functions satisfy the determining equations:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1\[LeftDoubleBracket]2\[RightDoubleBracket] /. solg // Simplify\)], 
  "Input"],

Cell[BoxData[
    \({{0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell["\<\
Finally, the non-classical symmetry transformations for the FP \
equation under the condition that the non-linear determining equations allow \
point symmetries are given by\
\>", "Text",
  CellTags->"non-classical symmetry transformations of the FP-equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncinfi\  = \ 
      Append[\(\(\(inf1\[LeftDoubleBracket]1\[RightDoubleBracket] /. solg
                  \)\  /. C[1] \[Rule] k1\)\  /. u[x, t] \[Rule] u\) /. \ 
            Rule[\(a_[n_]\)[h___], b_] \[Rule] 
              Rule[a[n], 
                Function[$v, $w] /. {$v \[Rule] {h}, $w \[Rule] b}] // 
          Flatten, xi[2] \[Rule] Function[{x, t, u}, 1]]; ncinfi // LTF\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 0\)},
          {
            \(\[Xi]\_1 == 
              \(-x\) + 
                \(2\ k1\ \((E\^\(-t\) + x)\)\^2 - 
                    2\ E\^\(1\/2\ \((E\^\(-t\) + x)\)\^2\)\ 
                      \@\((E\^\(-t\) + x)\)\^2 + 
                    \@\(2\ \[Pi]\)\ \((E\^\(-t\) + x)\)\^2\ 
                      Erfi[\@\((E\^\(-t\) + x)\)\^2\/\@2]\)\/\(\((
                      E\^\(-t\) + x)\)\ 
                    \((2\ k1 + 
                        \@\(2\ \[Pi]\)\ Erfi[\@\((E\^\(-t\) + x)\)\^2\/\@2])
                      \)\)\)},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Times[ -1, x], 
            Times[ 
              Power[ 
                Plus[ 
                  Power[ E, 
                    Times[ -1, t]], x], -1], 
              Power[ 
                Plus[ 
                  Times[ 2, k1], 
                  Times[ 
                    Power[ 
                      Times[ 2, Pi], 
                      Rational[ 1, 2]], 
                    Erfi[ 
                      Times[ 
                        Power[ 2, 
                          Rational[ -1, 2]], 
                        Power[ 
                          Power[ 
                            Plus[ 
                              Power[ E, 
                                Times[ -1, t]], x], 2], 
                          Rational[ 1, 2]]]]]], -1], 
              Plus[ 
                Times[ 2, k1, 
                  Power[ 
                    Plus[ 
                      Power[ E, 
                        Times[ -1, t]], x], 2]], 
                Times[ -2, 
                  Power[ E, 
                    Times[ 
                      Rational[ 1, 2], 
                      Power[ 
                        Plus[ 
                          Power[ E, 
                            Times[ -1, t]], x], 2]]], 
                  Power[ 
                    Power[ 
                      Plus[ 
                        Power[ E, 
                          Times[ -1, t]], x], 2], 
                    Rational[ 1, 2]]], 
                Times[ 
                  Power[ 
                    Times[ 2, Pi], 
                    Rational[ 1, 2]], 
                  Power[ 
                    Plus[ 
                      Power[ E, 
                        Times[ -1, t]], x], 2], 
                  Erfi[ 
                    Times[ 
                      Power[ 2, 
                        Rational[ -1, 2]], 
                      Power[ 
                        Power[ 
                          Plus[ 
                            Power[ E, 
                              Times[ -1, t]], x], 2], 
                        Rational[ 1, 2]]]]]]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "At this stage of the calculation, we find a very special representation of \
the non-classical symmetries. The next step in the calculation should be the \
reduction of the FP equation. A glance at the above result reveals that this \
last step is very difficult because the infinitesimals contain special \
functions with very complicated arguments. Since the infinitesimals are part \
of a first-order PDE, we face the problem of solving these equations to find \
the invariants. Currently, neither ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nor ",
  StyleBox["MathLie ",
    FontSlant->"Italic"],
  "can solve this kind of equations. However, the result derived via a mixed \
application of Lie's classical and non-classical method demonstrates that a \
simple equation allows a very complicated structure of symmetries."
}], "Text",
  CellTags->{"reduction of the FP-equation", "infinitesimals", "invariants"}],

Cell["\<\
However, solutions of the FP equation are derivable if we make an \
ansatz for the non-classical infinitesimals of the form\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf2\  = \ 
      inf1 /. {free[1] \[Rule] Function[{x, t}, \(free[1]\)[x]], 
          free[2] \[Rule] Function[{x, t}, 0], 
          free[3] \[Rule] Function[{x, t}, 0]}; inf2 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Xi]\_1 == \[ScriptCapitalF]\_1\)},
          {\(\[Phi]\_1 == 0\)},
          {
            \(\(-\[ScriptCapitalF]\_1\) - x\ \((\[ScriptCapitalF]\_1)\)\_x - 
                2\ \[ScriptCapitalF]\_1\ \((\[ScriptCapitalF]\_1)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {"True"},
          {"True"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], True, True}]]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "assuming that the arbitrary functions",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["2", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " and ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["3", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " are vanishing constants. The substitution into the non-linear determining \
equations of the FP equation reveals that only one equation for the function \
",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] remains. So that the non-classical infinitesimals are determined by"
}], "Text",
  CellTags->"non-classical infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf3\  = 
      \ {Append[inf2\[LeftDoubleBracket]1\[RightDoubleBracket], 
          \(xi[2]\)[x, t, u[x, t]] \[Rule] 1], 
        DeleteCases[inf2\[LeftDoubleBracket]2\[RightDoubleBracket], 0]}; 
    inf3\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\[ScriptCapitalF]\_1\) - x\ \((\[ScriptCapitalF]\_1)\)\_x - 
                2\ \[ScriptCapitalF]\_1\ \((\[ScriptCapitalF]\_1)\)\_x + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {\(\[Xi]\_1 == \[ScriptCapitalF]\_1\)},
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ -1, x, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Times[ -2, 
              Subscript[ \[ScriptCapitalF], 1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], x]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Since the unknown function ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " is a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " only, we can again apply ",
  StyleBox["PDESolve[]", "MmaText"],
  " to solve the determining equation for ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]:", "MmaText"]
}], "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf4\  = \ PDESolve[inf3, {u}, {x, t}]; inf4 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              
              StyleBox[
                \(\(\(-2\)\ \@x\^2 + 
                      k1\ \@\(2\ \[Pi]\)\ x\ Erfi[\@x\^2\/\@2]\)\/\(2\ 
                        \@x\^2\ \((E\^\(x\^2\/2\)\ k1 + x)\) - 
                      k1\ \@\(2\ \[Pi]\)\ x\^2\ Erfi[\@x\^2\/\@2]\)\),
                ScriptLevel->0]}]},
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Plus[ 
              Times[ -2, 
                Power[ 
                  Power[ x, 2], 
                  Rational[ 1, 2]]], 
              Times[ k1, 
                Power[ 
                  Times[ 2, Pi], 
                  Rational[ 1, 2]], x, 
                Erfi[ 
                  Times[ 
                    Power[ 2, 
                      Rational[ -1, 2]], 
                    Power[ 
                      Power[ x, 2], 
                      Rational[ 1, 2]]]]]], 
            Power[ 
              Plus[ 
                Times[ 2, 
                  Power[ 
                    Power[ x, 2], 
                    Rational[ 1, 2]], 
                  Plus[ 
                    Times[ 
                      Power[ E, 
                        Times[ 
                          Rational[ 1, 2], 
                          Power[ x, 2]]], k1], x]], 
                Times[ -1, k1, 
                  Power[ 
                    Times[ 2, Pi], 
                    Rational[ 1, 2]], 
                  Power[ x, 2], 
                  Erfi[ 
                    Times[ 
                      Power[ 2, 
                        Rational[ -1, 2]], 
                      Power[ 
                        Power[ x, 2], 
                        Rational[ 1, 2]]]]]], -1]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an explicit representation of the non-classical symmetries \
for the FP equation depending on a single parameter ",
  Cell[BoxData[
      FormBox[
        StyleBox["k1",
          FontSlant->"Italic"], TraditionalForm]]],
  ". This parameter is responsible for the transformation properties. Because \
",
  StyleBox["PDESolve[]", "MmaText"],
  " returns the infinitesimals in a special representation, we need to \
transform the infinitesimals into a pure function."
}], "Text",
  CellTags->{"non-classical symmetries", "PDESolve[]", "pure function"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ncifokkerPlanck\  = 
      \(inf4\  /. u[x, t] \[Rule] u\) /. \ 
          Rule[\(a_[n_]\)[h___], b_] \[Rule] 
            Rule[a[n], Function[$v, $w] /. {$v \[Rule] {h}, $w \[Rule] b}] // 
        Flatten; ncifokkerPlanck // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              
              StyleBox[
                \(\(\(-2\)\ \@x\^2 + 
                      k1\ \@\(2\ \[Pi]\)\ x\ Erfi[\@x\^2\/\@2]\)\/\(2\ 
                        \@x\^2\ \((E\^\(x\^2\/2\)\ k1 + x)\) - 
                      k1\ \@\(2\ \[Pi]\)\ x\^2\ Erfi[\@x\^2\/\@2]\)\),
                ScriptLevel->0]}]},
          {\(\[Xi]\_2 == 1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Plus[ 
              Times[ -2, 
                Power[ 
                  Power[ x, 2], 
                  Rational[ 1, 2]]], 
              Times[ k1, 
                Power[ 
                  Times[ 2, Pi], 
                  Rational[ 1, 2]], x, 
                Erfi[ 
                  Times[ 
                    Power[ 2, 
                      Rational[ -1, 2]], 
                    Power[ 
                      Power[ x, 2], 
                      Rational[ 1, 2]]]]]], 
            Power[ 
              Plus[ 
                Times[ 2, 
                  Power[ 
                    Power[ x, 2], 
                    Rational[ 1, 2]], 
                  Plus[ 
                    Times[ 
                      Power[ E, 
                        Times[ 
                          Rational[ 1, 2], 
                          Power[ x, 2]]], k1], x]], 
                Times[ -1, k1, 
                  Power[ 
                    Times[ 2, Pi], 
                    Rational[ 1, 2]], 
                  Power[ x, 2], 
                  Erfi[ 
                    Times[ 
                      Power[ 2, 
                        Rational[ -1, 2]], 
                      Power[ 
                        Power[ x, 2], 
                        Rational[ 1, 2]]]]]], -1]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "In the following, we will restrict our considerations to a sub-class of \
transformations for which ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", "0."}], TraditionalForm]]],
  " The non-classical infinitesimals reduce to the simple form"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      \({{\(xi[1]\)[x, t, u], \(xi[2]\)[x, t, u]}, {\(phi[1]\)[x, t, u]}} /. 
          ncifokkerPlanck\)\  /. k1 \[Rule] 0\)], "Input"],

Cell[BoxData[
    \({{\(-\(1\/x\)\), 1}, {0}}\)], "Output"]
}, Open  ]],

Cell["\<\
For this sub-class of infinitesimal transformation, we reduce the \
original FP equation by\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red\  = \ 
      LieReduction[fokkerPlanck, {u}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    \(red /. zeta1 \[Rule] \[Zeta]\_1 // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \((2\ t + x\^2)\)}], "-", 
                \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(u - F\_1 == 0\)},
          {
            \(\(-x\^2\)\ 
                \((F1\_\(\[Zeta]\_1\) + F1\_\(\[Zeta]\_1, \[Zeta]\_1\))\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting second-order ODE is solved by ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rsol\  = \ 
      DSolve[red\[LeftDoubleBracket]3, 1\[RightDoubleBracket], F1, zeta1]\)], 
  "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((\(-E\^\(-#1\)\)\ C[1] + C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution is a decaying exponential function in the similarity variable \
",
  Cell[BoxData[
      \(\[Zeta]\_1 = \((2\ t + x\^2)\)/2\)]],
  ". The solution for the original variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " follows by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = 
      Solve[\ red\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. \ rsol, 
          u] // Flatten\)], "Input"],

Cell[BoxData[
    \({u \[Rule] \(-E\^\(1\/2\ \((\(-2\)\ t - x\^2)\)\)\)\ C[1] + C[2]}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "representing a Gaussian in the spatial variable multiplied by an \
exponential decrease in time. The constants ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2] are constants of integration and can be used to implement initial \
conditions. For a fixed value of ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2], we plot the non-classical solution for the FP equation:"
}], "Text",
  CellTags->{
  "initial conditions", "non-classical solution of the FP-equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      Evaluate[\(u /. sol\)\  /. {C[1] \[Rule] \(-1\), C[2] \[Rule] 1}], {x, 
        \(-3\), 3}, {t, 0, 3}, AxesLabel \[Rule] {"\<x\>", "\<t\>", "\<u\>"}, 
      PlotPoints \[Rule] 25, PlotRange \[Rule] All, 
      ViewPoint -> {\(-1.253\), \ \(-2.896\), \ 1.221}, Mesh \[Rule] False]
      \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .64391 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0733255 1.07333 -0.163234 1.07333 [
[.37093 .01512 -5.90933 -9 ]
[.37093 .01512 6.09067 0 ]
[.62724 .0687 -3.07971 -9 ]
[.62724 .0687 2.92029 0 ]
[.86348 .11811 -3.19306 -9 ]
[.86348 .11811 2.80694 0 ]
[.62546 .00164 -5.13286 -15 ]
[.62546 .00164 4.86714 0 ]
[1.0011 .46237 -2.75415 0 ]
[1.0011 .46237 3.24585 9 ]
[.85628 .53841 -2.82241 0 ]
[.85628 .53841 3.17759 9 ]
[.73418 .60253 -2.87877 0 ]
[.73418 .60253 3.12123 9 ]
[.62983 .65732 -2.92608 0 ]
[.62983 .65732 3.07392 9 ]
[.79605 .63878 -4.75313 0 ]
[.79605 .63878 5.24687 15 ]
[.98956 .16404 0 -3.56644 ]
[.98956 .16404 6 5.43356 ]
[.99515 .2317 0 -3.61917 ]
[.99515 .2317 24 5.38083 ]
[1.00086 .30085 0 -3.67316 ]
[1.00086 .30085 18 5.32684 ]
[1.00669 .37152 0 -3.72846 ]
[1.00669 .37152 24 5.27154 ]
[1.01265 .44377 0 -3.78511 ]
[1.01265 .44377 6 5.21489 ]
[1.06684 .31304 0 -6.12204 ]
[1.06684 .31304 10 8.87796 ]
[ 0 0 0 0 ]
[ 1 .64391 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23392 0 m
.97589 .15476 L
s
.37073 .02854 m
.37062 .03524 L
s
[(-2)] .37093 .01512 -0.01511 1 Mshowa
.62759 .08211 m
.62777 .08882 L
s
[(0)] .62724 .0687 .02657 1 Mshowa
.86434 .1315 m
.86477 .13819 L
s
[(2)] .86348 .11811 .06435 1 Mshowa
.125 Mabswid
.43697 .04235 m
.43695 .04638 L
s
.50183 .05588 m
.50186 .05991 L
s
.56536 .06913 m
.56543 .07316 L
s
.68857 .09483 m
.68872 .09886 L
s
.74833 .1073 m
.74852 .11132 L
s
.80691 .11952 m
.80713 .12354 L
s
.30306 .01442 m
.30295 .01844 L
s
.92065 .14324 m
.92095 .14726 L
s
gsave
.62546 .00164 -66.1329 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
1 .44899 m
.6295 .64391 L
s
1 .44899 m
.99945 .44231 L
s
[(0)] 1.0011 .46237 -0.08195 -1 Mshowa
.85549 .52502 m
.85509 .51832 L
s
[(1)] .85628 .53841 -0.0592 -1 Mshowa
.73364 .58912 m
.73337 .58242 L
s
[(2)] .73418 .60253 -0.04041 -1 Mshowa
.6295 .64391 m
.62934 .6372 L
s
[(3)] .62983 .65732 -0.02464 -1 Mshowa
.125 Mabswid
.96899 .46531 m
.96868 .4613 L
s
.93909 .48104 m
.9388 .47703 L
s
.91024 .49622 m
.90997 .4922 L
s
.88239 .51087 m
.88214 .50685 L
s
.82949 .5387 m
.82927 .53468 L
s
.80434 .55193 m
.80414 .54791 L
s
.78001 .56473 m
.77982 .56071 L
s
.75645 .57712 m
.75628 .5731 L
s
.71152 .60076 m
.71138 .59673 L
s
.69008 .61204 m
.68995 .60801 L
s
.66929 .62298 m
.66916 .61895 L
s
.6491 .6336 m
.64899 .62957 L
s
gsave
.79605 .63878 -65.7531 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.97589 .15476 m
1 .44899 L
s
.97642 .16131 m
.96986 .15995 L
s
[(1)] .98956 .16404 -1 -0.20746 Mshowa
.98198 .22912 m
.9754 .22784 L
s
[(1.25)] .99515 .2317 -1 -0.19574 Mshowa
.98766 .29842 m
.98106 .29721 L
s
[(1.5)] 1.00086 .30085 -1 -0.18374 Mshowa
.99347 .36925 m
.98685 .36812 L
s
[(1.75)] 1.00669 .37152 -1 -0.17145 Mshowa
.9994 .44167 m
.99277 .44061 L
s
[(2)] 1.01265 .44377 -1 -0.15886 Mshowa
.125 Mabswid
.97753 .17476 m
.97358 .17395 L
s
.97863 .18826 m
.97469 .18746 L
s
.97974 .20182 m
.9758 .20103 L
s
.98086 .21545 m
.97691 .21466 L
s
.98311 .24286 m
.97916 .2421 L
s
.98424 .25666 m
.98028 .25591 L
s
.98537 .27052 m
.98142 .26978 L
s
.98651 .28444 m
.98256 .2837 L
s
.98881 .31246 m
.98485 .31174 L
s
.98997 .32657 m
.986 .32586 L
s
.99113 .34073 m
.98716 .34003 L
s
.99229 .35496 m
.98833 .35427 L
s
.99464 .38361 m
.99067 .38294 L
s
.99582 .39802 m
.99185 .39736 L
s
.99701 .41251 m
.99304 .41186 L
s
.9982 .42705 m
.99423 .42641 L
s
gsave
1.06684 .31304 -61 -10.122 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.23392 0 m
.22165 .32633 L
s
.22165 .32633 m
0 .5711 L
s
0 .5711 m
.01808 .31073 L
s
.01808 .31073 m
.23392 0 L
s
.97589 .15476 m
.62361 .40466 L
s
.62361 .40466 m
.6295 .64391 L
s
.6295 .64391 m
1 .44899 L
s
1 .44899 m
.97589 .15476 L
s
.23392 0 m
.22165 .32633 L
s
.22165 .32633 m
1 .44899 L
s
1 .44899 m
.97589 .15476 L
s
.97589 .15476 m
.23392 0 L
s
.01808 .31073 m
.62361 .40466 L
s
.62361 .40466 m
.6295 .64391 L
s
.6295 .64391 m
0 .5711 L
s
0 .5711 m
.01808 .31073 L
s
0 0 m
1 0 L
1 .64391 L
0 .64391 L
closepath
clip
newpath
.59 .803 .981 r
.61225 .39845 .60071 .40673 .62374 .41016 .63545 .40192 Mtetra
.59 .805 .982 r
.58888 .39507 .57749 .40339 .60071 .40673 .61225 .39845 Mtetra
.589 .808 .983 r
.56532 .39185 .5541 .40017 .57749 .40339 .58888 .39507 Mtetra
.588 .813 .985 r
.54159 .38886 .53053 .39716 .5541 .40017 .56532 .39185 Mtetra
.587 .818 .987 r
.51766 .38617 .50678 .39441 .53053 .39716 .54159 .38886 Mtetra
.584 .824 .99 r
.49354 .38381 .48283 .39193 .50678 .39441 .51766 .38617 Mtetra
.579 .83 .992 r
.46922 .38174 .45869 .38972 .48283 .39193 .49354 .38381 Mtetra
.573 .833 .994 r
.4447 .37986 .43434 .38767 .45869 .38972 .46922 .38174 Mtetra
.565 .833 .996 r
.41996 .37795 .40979 .38559 .43434 .38767 .4447 .37986 Mtetra
.557 .829 .997 r
.39502 .37576 .38504 .38326 .40979 .38559 .41996 .37795 Mtetra
.549 .82 .996 r
.36987 .37302 .36009 .38044 .38504 .38326 .39502 .37576 Mtetra
.543 .809 .995 r
.34452 .36952 .33494 .37696 .36009 .38044 .36987 .37302 Mtetra
.539 .796 .992 r
.31899 .36519 .30961 .37274 .33494 .37696 .34452 .36952 Mtetra
.538 .785 .989 r
.29326 .36009 .2841 .36785 .30961 .37274 .31899 .36519 Mtetra
.541 .776 .985 r
.26736 .3544 .2584 .36245 .2841 .36785 .29326 .36009 Mtetra
.546 .772 .982 r
.24127 .3484 .23251 .35676 .2584 .36245 .26736 .3544 Mtetra
.552 .772 .98 r
.21498 .34234 .20643 .35103 .23251 .35676 .24127 .3484 Mtetra
.56 .775 .979 r
.18848 .33645 .18014 .34543 .20643 .35103 .21498 .34234 Mtetra
.567 .78 .979 r
.16176 .33085 .15363 .34008 .18014 .34543 .18848 .33645 Mtetra
.574 .785 .979 r
.13481 .32556 .1269 .33501 .15363 .34008 .16176 .33085 Mtetra
.58 .79 .979 r
.10763 .32058 .09995 .3302 .1269 .33501 .13481 .32556 Mtetra
.584 .793 .979 r
.08021 .31582 .07275 .32558 .09995 .3302 .10763 .32058 Mtetra
.586 .796 .979 r
.05255 .31122 .04533 .3211 .07275 .32558 .08021 .31582 Mtetra
.588 .798 .98 r
.02465 .30672 .01767 .3167 .04533 .3211 .05255 .31122 Mtetra
.59 .803 .981 r
.624 .39003 .61225 .39845 .63545 .40192 .64736 .39354 Mtetra
.59 .805 .982 r
.60047 .38662 .58888 .39507 .61225 .39845 .624 .39003 Mtetra
.589 .809 .984 r
.57675 .3834 .56532 .39185 .58888 .39507 .60047 .38662 Mtetra
.588 .814 .986 r
.55284 .38044 .54159 .38886 .56532 .39185 .57675 .3834 Mtetra
.586 .821 .988 r
.52874 .37783 .51766 .38617 .54159 .38886 .55284 .38044 Mtetra
.583 .827 .991 r
.50445 .37559 .49354 .38381 .51766 .38617 .52874 .37783 Mtetra
.577 .834 .994 r
.47995 .3737 .46922 .38174 .49354 .38381 .50445 .37559 Mtetra
.57 .837 .996 r
.45524 .37202 .4447 .37986 .46922 .38174 .47995 .3737 Mtetra
.561 .837 .997 r
.43032 .37032 .41996 .37795 .4447 .37986 .45524 .37202 Mtetra
.551 .832 .998 r
.40518 .3683 .39502 .37576 .41996 .37795 .43032 .37032 Mtetra
.542 .822 .998 r
.37983 .36566 .36987 .37302 .39502 .37576 .40518 .3683 Mtetra
.536 .809 .996 r
.35428 .36215 .34452 .36952 .36987 .37302 .37983 .36566 Mtetra
.532 .795 .994 r
.32854 .35769 .31899 .36519 .34452 .36952 .35428 .36215 Mtetra
.531 .782 .99 r
.30261 .35235 .29326 .36009 .31899 .36519 .32854 .35769 Mtetra
.534 .773 .985 r
.27649 .34636 .26736 .3544 .29326 .36009 .30261 .35235 Mtetra
.54 .768 .982 r
.25019 .34 .24127 .3484 .26736 .3544 .27649 .34636 Mtetra
.547 .768 .98 r
.22369 .33359 .21498 .34234 .24127 .3484 .25019 .34 Mtetra
.556 .771 .979 r
.19697 .32737 .18848 .33645 .21498 .34234 .22369 .33359 Mtetra
.564 .777 .978 r
.17003 .32148 .16176 .33085 .18848 .33645 .19697 .32737 Mtetra
.572 .783 .978 r
.14286 .31596 .13481 .32556 .16176 .33085 .17003 .32148 Mtetra
.578 .788 .979 r
.11545 .31079 .10763 .32058 .13481 .32556 .14286 .31596 Mtetra
.583 .792 .979 r
.0878 .30588 .08021 .31582 .10763 .32058 .11545 .31079 Mtetra
.586 .796 .979 r
.05991 .30116 .05255 .31122 .08021 .31582 .0878 .30588 Mtetra
.588 .798 .98 r
.03177 .29654 .02465 .30672 .05255 .31122 .05991 .30116 Mtetra
.59 .803 .981 r
.63597 .38145 .624 .39003 .64736 .39354 .65949 .38501 Mtetra
.59 .806 .982 r
.61227 .37802 .60047 .38662 .624 .39003 .63597 .38145 Mtetra
.589 .81 .984 r
.58838 .37481 .57675 .3834 .60047 .38662 .61227 .37802 Mtetra
.588 .816 .986 r
.5643 .3719 .55284 .38044 .57675 .3834 .58838 .37481 Mtetra
.586 .823 .989 r
.54003 .36938 .52874 .37783 .55284 .38044 .5643 .3719 Mtetra
.582 .831 .992 r
.51556 .3673 .50445 .37559 .52874 .37783 .54003 .36938 Mtetra
.575 .838 .995 r
.49088 .36562 .47995 .3737 .50445 .37559 .51556 .3673 Mtetra
.566 .842 .997 r
.46599 .36418 .45524 .37202 .47995 .3737 .49088 .36562 Mtetra
.556 .842 .998 r
.44087 .36273 .43032 .37032 .45524 .37202 .46599 .36418 Mtetra
.545 .836 .999 r
.41554 .36091 .40518 .3683 .43032 .37032 .44087 .36273 Mtetra
.535 .825 .999 r
.38998 .35838 .37983 .36566 .40518 .3683 .41554 .36091 Mtetra
.527 .81 .998 r
.36423 .35487 .35428 .36215 .37983 .36566 .38998 .35838 Mtetra
.523 .793 .995 r
.33827 .35027 .32854 .35769 .35428 .36215 .36423 .35487 Mtetra
.523 .779 .99 r
.31213 .34468 .30261 .35235 .32854 .35769 .33827 .35027 Mtetra
.526 .768 .986 r
.2858 .33834 .27649 .34636 .30261 .35235 .31213 .34468 Mtetra
.533 .763 .982 r
.25928 .33159 .25019 .34 .27649 .34636 .2858 .33834 Mtetra
.542 .763 .979 r
.23256 .32478 .22369 .33359 .25019 .34 .25928 .33159 Mtetra
.551 .768 .978 r
.20563 .31819 .19697 .32737 .22369 .33359 .23256 .32478 Mtetra
.561 .774 .978 r
.17847 .31198 .17003 .32148 .19697 .32737 .20563 .31819 Mtetra
.57 .78 .978 r
.15108 .3062 .14286 .31596 .17003 .32148 .17847 .31198 Mtetra
.577 .787 .979 r
.12344 .30082 .11545 .31079 .14286 .31596 .15108 .3062 Mtetra
.582 .791 .979 r
.09555 .29575 .0878 .30588 .11545 .31079 .12344 .30082 Mtetra
.585 .795 .979 r
.06741 .2909 .05991 .30116 .0878 .30588 .09555 .29575 Mtetra
.587 .797 .979 r
.03903 .28616 .03177 .29654 .05991 .30116 .06741 .2909 Mtetra
.59 .804 .981 r
.64815 .37273 .63597 .38145 .65949 .38501 .67184 .37633 Mtetra
.59 .807 .983 r
.62428 .36928 .61227 .37802 .63597 .38145 .64815 .37273 Mtetra
.589 .812 .985 r
.60023 .36608 .58838 .37481 .61227 .37802 .62428 .36928 Mtetra
.588 .818 .987 r
.57598 .36323 .5643 .3719 .58838 .37481 .60023 .36608 Mtetra
.585 .826 .99 r
.55153 .36083 .54003 .36938 .5643 .3719 .57598 .36323 Mtetra
.58 .835 .993 r
.52689 .35894 .51556 .3673 .54003 .36938 .55153 .36083 Mtetra
.572 .843 .996 r
.50202 .3575 .49088 .36562 .51556 .3673 .52689 .35894 Mtetra
.562 .847 .997 r
.47694 .35635 .46599 .36418 .49088 .36562 .50202 .3575 Mtetra
.549 .846 .998 r
.45163 .35518 .44087 .36273 .46599 .36418 .47694 .35635 Mtetra
.537 .839 .999 r
.4261 .35361 .41554 .36091 .44087 .36273 .45163 .35518 Mtetra
.525 .827 1 r
.40034 .35122 .38998 .35838 .41554 .36091 .4261 .35361 Mtetra
.517 .81 .999 r
.37436 .34771 .36423 .35487 .38998 .35838 .40034 .35122 Mtetra
.513 .792 .996 r
.34819 .34297 .33827 .35027 .36423 .35487 .37436 .34771 Mtetra
.514 .775 .991 r
.32183 .33709 .31213 .34468 .33827 .35027 .34819 .34297 Mtetra
.518 .764 .986 r
.29528 .33036 .2858 .33834 .31213 .34468 .32183 .33709 Mtetra
.525 .758 .982 r
.26855 .32317 .25928 .33159 .2858 .33834 .29528 .33036 Mtetra
.535 .758 .979 r
.24161 .31591 .23256 .32478 .25928 .33159 .26855 .32317 Mtetra
.546 .763 .978 r
.21446 .30891 .20563 .31819 .23256 .32478 .24161 .31591 Mtetra
.557 .77 .977 r
.18707 .30235 .17847 .31198 .20563 .31819 .21446 .30891 Mtetra
.567 .778 .978 r
.15945 .29629 .15108 .3062 .17847 .31198 .18707 .30235 Mtetra
.575 .785 .978 r
.13158 .29068 .12344 .30082 .15108 .3062 .15945 .29629 Mtetra
.581 .79 .979 r
.10345 .28544 .09555 .29575 .12344 .30082 .13158 .29068 Mtetra
.585 .794 .979 r
.07507 .28044 .06741 .2909 .09555 .29575 .10345 .28544 Mtetra
.587 .797 .979 r
.04643 .27558 .03903 .28616 .06741 .2909 .07507 .28044 Mtetra
.59 .804 .982 r
.66056 .36385 .64815 .37273 .67184 .37633 .68442 .36749 Mtetra
.589 .808 .983 r
.63652 .36039 .62428 .36928 .64815 .37273 .66056 .36385 Mtetra
.589 .813 .985 r
.6123 .35721 .60023 .36608 .62428 .36928 .63652 .36039 Mtetra
.587 .821 .988 r
.58787 .35443 .57598 .36323 .60023 .36608 .6123 .35721 Mtetra
.584 .83 .991 r
.56325 .35218 .55153 .36083 .57598 .36323 .58787 .35443 Mtetra
.578 .839 .994 r
.53843 .35051 .52689 .35894 .55153 .36083 .56325 .35218 Mtetra
.569 .848 .997 r
.51338 .34937 .50202 .3575 .52689 .35894 .53843 .35051 Mtetra
.557 .852 .998 r
.48811 .34855 .47694 .35635 .50202 .3575 .51338 .34937 Mtetra
.542 .851 .998 r
.4626 .34772 .45163 .35518 .47694 .35635 .48811 .34855 Mtetra
.527 .843 .999 r
.43686 .34643 .4261 .35361 .45163 .35518 .4626 .34772 Mtetra
.514 .829 1 r
.41089 .34421 .40034 .35122 .4261 .35361 .43686 .34643 Mtetra
.506 .81 1 r
.3847 .34072 .37436 .34771 .40034 .35122 .41089 .34421 Mtetra
.502 .789 .997 r
.35831 .33582 .34819 .34297 .37436 .34771 .3847 .34072 Mtetra
.503 .771 .992 r
.33172 .32963 .32183 .33709 .34819 .34297 .35831 .33582 Mtetra
.508 .758 .986 r
.30496 .32246 .29528 .33036 .32183 .33709 .33172 .32963 Mtetra
.516 .752 .981 r
.278 .31477 .26855 .32317 .29528 .33036 .30496 .32246 Mtetra
.528 .752 .978 r
.25083 .30702 .24161 .31591 .26855 .32317 .278 .31477 Mtetra
.541 .758 .977 r
.22346 .29955 .21446 .30891 .24161 .31591 .25083 .30702 Mtetra
.553 .766 .977 r
.19585 .2926 .18707 .30235 .21446 .30891 .22346 .29955 Mtetra
.564 .775 .977 r
.16799 .28622 .15945 .29629 .18707 .30235 .19585 .2926 Mtetra
.573 .783 .978 r
.13988 .28037 .13158 .29068 .15945 .29629 .16799 .28622 Mtetra
.579 .789 .979 r
.11151 .27492 .10345 .28544 .13158 .29068 .13988 .28037 Mtetra
.584 .794 .979 r
.08288 .26977 .07507 .28044 .10345 .28544 .11151 .27492 Mtetra
.587 .796 .979 r
.05399 .26479 .04643 .27558 .07507 .28044 .08288 .26977 Mtetra
.59 .805 .982 r
.6732 .35482 .66056 .36385 .68442 .36749 .69723 .35849 Mtetra
.589 .809 .983 r
.64899 .35134 .63652 .36039 .66056 .36385 .6732 .35482 Mtetra
.589 .815 .986 r
.62459 .3482 .6123 .35721 .63652 .36039 .64899 .35134 Mtetra
.587 .823 .989 r
.6 .34552 .58787 .35443 .6123 .35721 .62459 .3482 Mtetra
.583 .834 .992 r
.5752 .34345 .56325 .35218 .58787 .35443 .6 .34552 Mtetra
.576 .844 .995 r
.55019 .34204 .53843 .35051 .56325 .35218 .5752 .34345 Mtetra
.565 .853 .997 r
.52496 .34123 .51338 .34937 .53843 .35051 .55019 .34204 Mtetra
.55 .858 .997 r
.4995 .34081 .48811 .34855 .51338 .34937 .52496 .34123 Mtetra
.532 .856 .997 r
.47379 .34038 .4626 .34772 .48811 .34855 .4995 .34081 Mtetra
.515 .846 .997 r
.44784 .33942 .43686 .34643 .4626 .34772 .47379 .34038 Mtetra
.501 .83 .999 r
.42166 .3374 .41089 .34421 .43686 .34643 .44784 .33942 Mtetra
.492 .809 1 r
.39524 .33394 .3847 .34072 .41089 .34421 .42166 .3374 Mtetra
.488 .786 .998 r
.36863 .32887 .35831 .33582 .3847 .34072 .39524 .33394 Mtetra
.49 .766 .992 r
.34181 .32232 .33172 .32963 .35831 .33582 .36863 .32887 Mtetra
.496 .751 .986 r
.31482 .31467 .30496 .32246 .33172 .32963 .34181 .32232 Mtetra
.506 .745 .981 r
.28763 .30642 .278 .31477 .30496 .32246 .31482 .31467 Mtetra
.52 .745 .977 r
.26024 .2981 .25083 .30702 .278 .31477 .28763 .30642 Mtetra
.534 .752 .976 r
.23263 .29012 .22346 .29955 .25083 .30702 .26024 .2981 Mtetra
.548 .761 .976 r
.20479 .28273 .19585 .2926 .22346 .29955 .23263 .29012 Mtetra
.561 .771 .977 r
.1767 .276 .16799 .28622 .19585 .2926 .20479 .28273 Mtetra
.571 .78 .978 r
.14835 .26987 .13988 .28037 .16799 .28622 .1767 .276 Mtetra
.578 .788 .978 r
.11973 .26422 .11151 .27492 .13988 .28037 .14835 .26987 Mtetra
.583 .793 .979 r
.09085 .2589 .08288 .26977 .11151 .27492 .11973 .26422 Mtetra
.586 .796 .979 r
.0617 .25378 .05399 .26479 .08288 .26977 .09085 .2589 Mtetra
.59 .806 .982 r
.68608 .34562 .6732 .35482 .69723 .35849 .71027 .34933 Mtetra
.589 .81 .984 r
.6617 .34214 .64899 .35134 .6732 .35482 .68608 .34562 Mtetra
.588 .817 .987 r
.63712 .33905 .62459 .3482 .64899 .35134 .6617 .34214 Mtetra
.586 .826 .99 r
.61235 .33649 .6 .34552 .62459 .3482 .63712 .33905 Mtetra
.582 .838 .993 r
.58737 .33463 .5752 .34345 .6 .34552 .61235 .33649 Mtetra
.573 .85 .996 r
.56218 .33353 .55019 .34204 .5752 .34345 .58737 .33463 Mtetra
.56 .859 .997 r
.53677 .33312 .52496 .34123 .55019 .34204 .56218 .33353 Mtetra
.541 .864 .995 r
.51111 .33316 .4995 .34081 .52496 .34123 .53677 .33312 Mtetra
.52 .86 .994 r
.48521 .33318 .47379 .34038 .4995 .34081 .51111 .33316 Mtetra
.5 .849 .994 r
.45905 .33261 .44784 .33942 .47379 .34038 .48521 .33318 Mtetra
.484 .831 .997 r
.43264 .33084 .42166 .3374 .44784 .33942 .45905 .33261 Mtetra
.475 .807 .999 r
.406 .32742 .39524 .33394 .42166 .3374 .43264 .33084 Mtetra
.472 .782 .998 r
.37915 .32217 .36863 .32887 .39524 .33394 .406 .32742 Mtetra
.475 .759 .993 r
.35211 .31522 .34181 .32232 .36863 .32887 .37915 .32217 Mtetra
.483 .743 .986 r
.32488 .30702 .31482 .31467 .34181 .32232 .35211 .31522 Mtetra
.495 .736 .98 r
.29746 .29814 .28763 .30642 .31482 .31467 .32488 .30702 Mtetra
.51 .738 .976 r
.26984 .28919 .26024 .2981 .28763 .30642 .29746 .29814 Mtetra
.527 .745 .975 r
.242 .28063 .23263 .29012 .26024 .2981 .26984 .28919 Mtetra
.543 .756 .975 r
.21392 .27275 .20479 .28273 .23263 .29012 .242 .28063 Mtetra
.557 .767 .976 r
.18559 .26562 .1767 .276 .20479 .28273 .21392 .27275 Mtetra
.568 .778 .977 r
.15699 .25919 .14835 .26987 .1767 .276 .18559 .26562 Mtetra
.576 .786 .978 r
.12812 .2533 .11973 .26422 .14835 .26987 .15699 .25919 Mtetra
.582 .792 .979 r
.09898 .24781 .09085 .2589 .11973 .26422 .12812 .2533 Mtetra
.586 .795 .979 r
.06957 .24255 .0617 .25378 .09085 .2589 .09898 .24781 Mtetra
.59 .806 .982 r
.69921 .33626 .68608 .34562 .71027 .34933 .72357 .34 Mtetra
.589 .811 .984 r
.67465 .33279 .6617 .34214 .68608 .34562 .69921 .33626 Mtetra
.588 .819 .987 r
.6499 .32976 .63712 .33905 .6617 .34214 .67465 .33279 Mtetra
.586 .83 .991 r
.62494 .32735 .61235 .33649 .63712 .33905 .6499 .32976 Mtetra
.58 .843 .994 r
.59979 .32573 .58737 .33463 .61235 .33649 .62494 .32735 Mtetra
.57 .856 .997 r
.57442 .32499 .56218 .33353 .58737 .33463 .59979 .32573 Mtetra
.553 .866 .996 r
.54882 .32505 .53677 .33312 .56218 .33353 .57442 .32499 Mtetra
.531 .869 .992 r
.52297 .32562 .51111 .33316 .53677 .33312 .54882 .32505 Mtetra
.505 .864 .988 r
.49686 .32619 .48521 .33318 .51111 .33316 .52297 .32562 Mtetra
.481 .85 .988 r
.47048 .32607 .45905 .33261 .48521 .33318 .49686 .32619 Mtetra
.463 .83 .993 r
.44385 .32459 .43264 .33084 .45905 .33261 .47048 .32607 Mtetra
.454 .805 .998 r
.41698 .32123 .406 .32742 .43264 .33084 .44385 .32459 Mtetra
.453 .777 .998 r
.3899 .31577 .37915 .32217 .406 .32742 .41698 .32123 Mtetra
.458 .752 .993 r
.36261 .30839 .35211 .31522 .37915 .32217 .3899 .31577 Mtetra
.468 .734 .985 r
.33514 .29956 .32488 .30702 .35211 .31522 .36261 .30839 Mtetra
.482 .727 .979 r
.30748 .28998 .29746 .29814 .32488 .30702 .33514 .29956 Mtetra
.5 .729 .975 r
.27962 .28031 .26984 .28919 .29746 .29814 .30748 .28998 Mtetra
.518 .737 .974 r
.25155 .27109 .242 .28063 .26984 .28919 .27962 .28031 Mtetra
.536 .75 .974 r
.22323 .26266 .21392 .27275 .242 .28063 .25155 .27109 Mtetra
.552 .763 .976 r
.19465 .25509 .18559 .26562 .21392 .27275 .22323 .26266 Mtetra
.565 .775 .977 r
.16581 .24832 .15699 .25919 .18559 .26562 .19465 .25509 Mtetra
.575 .784 .978 r
.13668 .24219 .12812 .2533 .15699 .25919 .16581 .24832 Mtetra
.581 .791 .979 r
.10728 .2365 .09898 .24781 .12812 .2533 .13668 .24219 Mtetra
.585 .795 .979 r
.0776 .23109 .06957 .24255 .09898 .24781 .10728 .2365 Mtetra
.59 .807 .983 r
.71258 .32673 .69921 .33626 .72357 .34 .73712 .33049 Mtetra
.589 .813 .985 r
.68785 .32328 .67465 .33279 .69921 .33626 .71258 .32673 Mtetra
.588 .822 .988 r
.66292 .32033 .6499 .32976 .67465 .33279 .68785 .32328 Mtetra
.585 .834 .992 r
.63779 .31809 .62494 .32735 .6499 .32976 .66292 .32033 Mtetra
.578 .848 .995 r
.61245 .31677 .59979 .32573 .62494 .32735 .63779 .31809 Mtetra
.566 .862 .996 r
.5869 .31645 .57442 .32499 .59979 .32573 .61245 .31677 Mtetra
.545 .872 .993 r
.56111 .31706 .54882 .32505 .57442 .32499 .5869 .31645 Mtetra
.517 .873 .985 r
.53507 .31825 .52297 .32562 .54882 .32505 .56111 .31706 Mtetra
.485 .865 .979 r
.50875 .31944 .49686 .32619 .52297 .32562 .53507 .31825 Mtetra
.457 .849 .978 r
.48216 .31986 .47048 .32607 .49686 .32619 .50875 .31944 Mtetra
.438 .827 .985 r
.45531 .31872 .44385 .32459 .47048 .32607 .48216 .31986 Mtetra
.429 .8 .994 r
.4282 .31543 .41698 .32123 .44385 .32459 .45531 .31872 Mtetra
.43 .77 .997 r
.40086 .30975 .3899 .31577 .41698 .32123 .4282 .31543 Mtetra
.437 .742 .992 r
.37333 .30187 .36261 .30839 .3899 .31577 .40086 .30975 Mtetra
.45 .723 .984 r
.34561 .29235 .33514 .29956 .36261 .30839 .37333 .30187 Mtetra
.467 .715 .977 r
.31771 .28196 .30748 .28998 .33514 .29956 .34561 .29235 Mtetra
.487 .718 .973 r
.28961 .27148 .27962 .28031 .30748 .28998 .31771 .28196 Mtetra
.509 .728 .972 r
.26129 .26153 .25155 .27109 .27962 .28031 .28961 .27148 Mtetra
.529 .743 .973 r
.23273 .25247 .22323 .26266 .25155 .27109 .26129 .26153 Mtetra
.547 .758 .975 r
.20391 .24441 .19465 .25509 .22323 .26266 .23273 .25247 Mtetra
.562 .771 .976 r
.17481 .23727 .16581 .24832 .19465 .25509 .20391 .24441 Mtetra
.573 .782 .978 r
.14543 .23086 .13668 .24219 .16581 .24832 .17481 .23727 Mtetra
.58 .789 .979 r
.11576 .22497 .10728 .2365 .13668 .24219 .14543 .23086 Mtetra
.584 .794 .979 r
.0858 .21939 .0776 .23109 .10728 .2365 .11576 .22497 Mtetra
.59 .808 .983 r
.72621 .31703 .71258 .32673 .73712 .33049 .75093 .32081 Mtetra
.589 .814 .986 r
.7013 .31361 .68785 .32328 .71258 .32673 .72621 .31703 Mtetra
.587 .824 .989 r
.67619 .31076 .66292 .32033 .68785 .32328 .7013 .31361 Mtetra
.584 .838 .993 r
.65089 .30874 .63779 .31809 .66292 .32033 .67619 .31076 Mtetra
.575 .854 .996 r
.62537 .30776 .61245 .31677 .63779 .31809 .65089 .30874 Mtetra
.56 .869 .995 r
.59964 .30793 .5869 .31645 .61245 .31677 .62537 .30776 Mtetra
.534 .878 .988 r
.57366 .30916 .56111 .31706 .5869 .31645 .59964 .30793 Mtetra
.498 .876 .975 r
.54742 .31108 .53507 .31825 .56111 .31706 .57366 .30916 Mtetra
.459 .864 .963 r
.5209 .31299 .50875 .31944 .53507 .31825 .54742 .31108 Mtetra
.426 .844 .962 r
.4941 .31404 .48216 .31986 .50875 .31944 .5209 .31299 Mtetra
.405 .821 .973 r
.46701 .3133 .45531 .31872 .48216 .31986 .4941 .31404 Mtetra
.399 .793 .987 r
.43965 .31011 .4282 .31543 .45531 .31872 .46701 .3133 Mtetra
.403 .76 .994 r
.41207 .30419 .40086 .30975 .4282 .31543 .43965 .31011 Mtetra
.414 .731 .99 r
.38428 .29575 .37333 .30187 .40086 .30975 .41207 .30419 Mtetra
.43 .71 .982 r
.35631 .28544 .34561 .29235 .37333 .30187 .38428 .29575 Mtetra
.45 .702 .975 r
.32815 .27414 .31771 .28196 .34561 .29235 .35631 .28544 Mtetra
.474 .706 .971 r
.29981 .26275 .28961 .27148 .31771 .28196 .32815 .27414 Mtetra
.498 .718 .97 r
.27124 .25196 .26129 .26153 .28961 .27148 .29981 .26275 Mtetra
.521 .735 .972 r
.24243 .2422 .23273 .25247 .26129 .26153 .27124 .25196 Mtetra
.542 .752 .974 r
.21336 .23359 .20391 .24441 .23273 .25247 .24243 .2422 Mtetra
.558 .767 .976 r
.184 .22604 .17481 .23727 .20391 .24441 .21336 .23359 Mtetra
.57 .779 .977 r
.15435 .21932 .14543 .23086 .17481 .23727 .184 .22604 Mtetra
.579 .788 .978 r
.12441 .2132 .11576 .22497 .14543 .23086 .15435 .21932 Mtetra
.584 .793 .979 r
.09418 .20745 .0858 .21939 .11576 .22497 .12441 .2132 Mtetra
.59 .809 .983 r
.74012 .30715 .72621 .31703 .75093 .32081 .76501 .31095 Mtetra
.589 .816 .986 r
.71503 .30377 .7013 .31361 .72621 .31703 .74012 .30715 Mtetra
.587 .828 .99 r
.68974 .30106 .67619 .31076 .7013 .31361 .71503 .30377 Mtetra
.582 .843 .994 r
.66425 .29928 .65089 .30874 .67619 .31076 .68974 .30106 Mtetra
.572 .86 .996 r
.63856 .2987 .62537 .30776 .65089 .30874 .66425 .29928 Mtetra
.552 .876 .992 r
.61264 .29945 .59964 .30793 .62537 .30776 .63856 .2987 Mtetra
.519 .883 .979 r
.58648 .30142 .57366 .30916 .59964 .30793 .61264 .29945 Mtetra
.474 .876 .957 r
.56005 .30417 .54742 .31108 .57366 .30916 .58648 .30142 Mtetra
.426 .857 .938 r
.53332 .30693 .5209 .31299 .54742 .31108 .56005 .30417 Mtetra
.386 .833 .936 r
.50629 .30869 .4941 .31404 .5209 .31299 .53332 .30693 Mtetra
.365 .809 .953 r
.47897 .30844 .46701 .3133 .4941 .31404 .50629 .30869 Mtetra
.361 .781 .976 r
.45136 .30537 .43965 .31011 .46701 .3133 .47897 .30844 Mtetra
.37 .748 .989 r
.42352 .29917 .41207 .30419 .43965 .31011 .45136 .30537 Mtetra
.386 .717 .988 r
.39547 .29011 .38428 .29575 .41207 .30419 .42352 .29917 Mtetra
.406 .695 .979 r
.36723 .2789 .35631 .28544 .38428 .29575 .39547 .29011 Mtetra
.431 .687 .971 r
.33882 .26657 .32815 .27414 .35631 .28544 .36723 .2789 Mtetra
.458 .692 .968 r
.31021 .25414 .29981 .26275 .32815 .27414 .33882 .26657 Mtetra
.486 .707 .967 r
.2814 .24241 .27124 .25196 .29981 .26275 .31021 .25414 Mtetra
.512 .726 .97 r
.25233 .23186 .24243 .2422 .27124 .25196 .2814 .24241 Mtetra
.535 .745 .972 r
.223 .22263 .21336 .23359 .24243 .2422 .25233 .23186 Mtetra
.554 .763 .975 r
.19338 .21462 .184 .22604 .21336 .23359 .223 .22263 Mtetra
.568 .777 .977 r
.16347 .20756 .15435 .21932 .184 .22604 .19338 .21462 Mtetra
.577 .786 .978 r
.13325 .2012 .12441 .2132 .15435 .21932 .16347 .20756 Mtetra
.583 .792 .979 r
.10274 .19526 .09418 .20745 .12441 .2132 .13325 .2012 Mtetra
.59 .81 .984 r
.75429 .2971 .74012 .30715 .76501 .31095 .77936 .30091 Mtetra
.589 .819 .987 r
.72902 .29378 .71503 .30377 .74012 .30715 .75429 .2971 Mtetra
.586 .831 .991 r
.70355 .29122 .68974 .30106 .71503 .30377 .72902 .29378 Mtetra
.581 .848 .995 r
.67789 .28974 .66425 .29928 .68974 .30106 .70355 .29122 Mtetra
.568 .867 .996 r
.65202 .28963 .63856 .2987 .66425 .29928 .67789 .28974 Mtetra
.543 .882 .987 r
.62592 .29105 .61264 .29945 .63856 .2987 .65202 .28963 Mtetra
.5 .885 .965 r
.59957 .29386 .58648 .30142 .61264 .29945 .62592 .29105 Mtetra
.443 .869 .93 r
.57295 .29758 .56005 .30417 .58648 .30142 .59957 .29386 Mtetra
.382 .841 .901 r
.54602 .30132 .53332 .30693 .56005 .30417 .57295 .29758 Mtetra
.336 .812 .896 r
.51877 .30393 .50629 .30869 .53332 .30693 .54602 .30132 Mtetra
.313 .789 .921 r
.4912 .30422 .47897 .30844 .50629 .30869 .51877 .30393 Mtetra
.314 .764 .958 r
.46334 .30131 .45136 .30537 .47897 .30844 .4912 .30422 Mtetra
.33 .732 .981 r
.43522 .29482 .42352 .29917 .45136 .30537 .46334 .30131 Mtetra
.353 .699 .983 r
.4069 .28504 .39547 .29011 .42352 .29917 .43522 .29482 Mtetra
.379 .677 .975 r
.37839 .27282 .36723 .2789 .39547 .29011 .4069 .28504 Mtetra
.409 .67 .967 r
.34971 .25932 .33882 .26657 .36723 .2789 .37839 .27282 Mtetra
.44 .676 .964 r
.32084 .24571 .31021 .25414 .33882 .26657 .34971 .25932 Mtetra
.472 .693 .964 r
.29177 .23292 .2814 .24241 .31021 .25414 .32084 .24571 Mtetra
.502 .715 .967 r
.26245 .22147 .25233 .23186 .2814 .24241 .29177 .23292 Mtetra
.528 .738 .971 r
.23285 .21155 .223 .22263 .25233 .23186 .26245 .22147 Mtetra
.549 .758 .974 r
.20297 .20301 .19338 .21462 .223 .22263 .23285 .21155 Mtetra
.565 .773 .976 r
.17278 .19559 .16347 .20756 .19338 .21462 .20297 .20301 Mtetra
.575 .784 .978 r
.14229 .18895 .13325 .2012 .16347 .20756 .17278 .19559 Mtetra
.582 .791 .979 r
.11148 .18281 .10274 .19526 .13325 .2012 .14229 .18895 Mtetra
.59 .812 .984 r
.76875 .28687 .75429 .2971 .77936 .30091 .79401 .29067 Mtetra
.589 .821 .988 r
.7433 .28362 .72902 .29378 .75429 .2971 .76875 .28687 Mtetra
.586 .835 .992 r
.71765 .28125 .70355 .29122 .72902 .29378 .7433 .28362 Mtetra
.579 .854 .996 r
.69181 .28011 .67789 .28974 .70355 .29122 .71765 .28125 Mtetra
.562 .874 .994 r
.66576 .28056 .65202 .28963 .67789 .28974 .69181 .28011 Mtetra
.529 .888 .978 r
.63949 .28275 .62592 .29105 .65202 .28963 .66576 .28056 Mtetra
.474 .883 .942 r
.61296 .28655 .59957 .29386 .62592 .29105 .63949 .28275 Mtetra
.401 .854 .89 r
.58615 .29139 .57295 .29758 .59957 .29386 .61296 .28655 Mtetra
.327 .812 .846 r
.55901 .29626 .54602 .30132 .57295 .29758 .58615 .29139 Mtetra
.273 .778 .839 r
.53153 .29984 .51877 .30393 .54602 .30132 .55901 .29626 Mtetra
.249 .756 .875 r
.50372 .30079 .4912 .30422 .51877 .30393 .53153 .29984 Mtetra
.256 .738 .93 r
.47559 .29806 .46334 .30131 .4912 .30422 .50372 .30079 Mtetra
.281 .71 .968 r
.4472 .29124 .43522 .29482 .46334 .30131 .47559 .29806 Mtetra
.314 .678 .977 r
.41859 .28066 .4069 .28504 .43522 .29482 .4472 .29124 Mtetra
.348 .655 .97 r
.3898 .26729 .37839 .27282 .4069 .28504 .41859 .28066 Mtetra
.384 .649 .962 r
.36084 .25246 .34971 .25932 .37839 .27282 .3898 .26729 Mtetra
.42 .658 .958 r
.33171 .23751 .32084 .24571 .34971 .25932 .36084 .25246 Mtetra
.456 .678 .96 r
.30236 .2235 .29177 .23292 .32084 .24571 .33171 .23751 Mtetra
.49 .703 .964 r
.27278 .21105 .26245 .22147 .29177 .23292 .30236 .2235 Mtetra
.52 .729 .969 r
.24292 .20034 .23285 .21155 .26245 .22147 .27278 .21105 Mtetra
.544 .752 .973 r
.21276 .19123 .20297 .20301 .23285 .21155 .24292 .20034 Mtetra
.561 .77 .976 r
.1823 .18339 .17278 .19559 .20297 .20301 .21276 .19123 Mtetra
.573 .782 .978 r
.15152 .17645 .14229 .18895 .17278 .19559 .1823 .18339 Mtetra
.581 .79 .979 r
.12042 .1701 .11148 .18281 .14229 .18895 .15152 .17645 Mtetra
.589 .813 .985 r
.7835 .27645 .76875 .28687 .79401 .29067 .80894 .28024 Mtetra
.588 .824 .989 r
.75787 .2733 .7433 .28362 .76875 .28687 .7835 .27645 Mtetra
.585 .84 .993 r
.73204 .27115 .71765 .28125 .7433 .28362 .75787 .2733 Mtetra
.576 .861 .996 r
.70602 .27043 .69181 .28011 .71765 .28125 .73204 .27115 Mtetra
.555 .882 .99 r
.6798 .27151 .66576 .28056 .69181 .28011 .70602 .27043 Mtetra
.512 .891 .964 r
.65335 .2746 .63949 .28275 .66576 .28056 .6798 .27151 Mtetra
.44 .873 .908 r
.62665 .27953 .61296 .28655 .63949 .28275 .65335 .2746 Mtetra
.347 .825 .831 r
.59965 .28567 .58615 .29139 .61296 .28655 .62665 .27953 Mtetra
.258 .767 .77 r
.57231 .29185 .55901 .29626 .58615 .29139 .59965 .28567 Mtetra
.196 .725 .759 r
.54461 .29657 .53153 .29984 .55901 .29626 .57231 .29185 Mtetra
.171 .708 .808 r
.51654 .29828 .50372 .30079 .53153 .29984 .54461 .29657 Mtetra
.185 .7 .888 r
.48814 .29578 .47559 .29806 .50372 .30079 .51654 .29828 Mtetra
.222 .68 .948 r
.45946 .28859 .4472 .29124 .47559 .29806 .48814 .29578 Mtetra
.268 .651 .966 r
.43055 .2771 .41859 .28066 .4472 .29124 .45946 .28859 Mtetra
.312 .63 .962 r
.40147 .26242 .3898 .26729 .41859 .28066 .43055 .2771 Mtetra
.355 .625 .955 r
.37222 .24607 .36084 .25246 .3898 .26729 .40147 .26242 Mtetra
.398 .637 .952 r
.3428 .22961 .33171 .23751 .36084 .25246 .37222 .24607 Mtetra
.439 .661 .955 r
.31319 .21422 .30236 .2235 .33171 .23751 .3428 .22961 Mtetra
.477 .69 .961 r
.28333 .20063 .27278 .21105 .30236 .2235 .31319 .21422 Mtetra
.511 .72 .967 r
.2532 .18903 .24292 .20034 .27278 .21105 .28333 .20063 Mtetra
.538 .745 .972 r
.22277 .17926 .21276 .19123 .24292 .20034 .2532 .18903 Mtetra
.558 .766 .975 r
.19202 .17096 .1823 .18339 .21276 .19123 .22277 .17926 Mtetra
.571 .78 .977 r
.16095 .1637 .15152 .17645 .1823 .18339 .19202 .17096 Mtetra
.58 .789 .978 r
.12956 .15711 .12042 .1701 .15152 .17645 .16095 .1637 Mtetra
.589 .815 .986 r
.79856 .26585 .7835 .27645 .80894 .28024 .82418 .26961 Mtetra
.588 .827 .99 r
.77274 .26281 .75787 .2733 .7835 .27645 .79856 .26585 Mtetra
.584 .845 .994 r
.74674 .26093 .73204 .27115 .75787 .2733 .77274 .26281 Mtetra
.572 .868 .995 r
.72054 .26069 .70602 .27043 .73204 .27115 .74674 .26093 Mtetra
.545 .888 .984 r
.69415 .26252 .6798 .27151 .70602 .27043 .72054 .26069 Mtetra
.488 .89 .942 r
.66753 .26664 .65335 .2746 .6798 .27151 .69415 .26252 Mtetra
.395 .853 .858 r
.64066 .27289 .62665 .27953 .65335 .2746 .66753 .26664 Mtetra
.281 .779 .751 r
.61348 .28053 .59965 .28567 .62665 .27953 .64066 .27289 Mtetra
0 0 0 r
.58594 .28823 .57231 .29185 .59965 .28567 .61348 .28053 Mtetra
.55801 .29427 .54461 .29657 .57231 .29185 .58594 .28823 Mtetra
.08 .64 .718 r
.52969 .29686 .51654 .29828 .54461 .29657 .55801 .29427 Mtetra
.099 .647 .828 r
.50101 .29463 .48814 .29578 .51654 .29828 .52969 .29686 Mtetra
.152 .641 .918 r
.47202 .28704 .45946 .28859 .48814 .29578 .50101 .29463 Mtetra
.213 .618 .952 r
.44281 .27451 .43055 .2771 .45946 .28859 .47202 .28704 Mtetra
.271 .599 .951 r
.41341 .25834 .40147 .26242 .43055 .2771 .44281 .27451 Mtetra
.323 .598 .945 r
.38386 .24027 .37222 .24607 .40147 .26242 .41341 .25834 Mtetra
.372 .613 .944 r
.35415 .22207 .3428 .22961 .37222 .24607 .38386 .24027 Mtetra
.419 .641 .948 r
.32425 .20511 .31319 .21422 .3428 .22961 .35415 .22207 Mtetra
.463 .675 .956 r
.29412 .19022 .28333 .20063 .31319 .21422 .32425 .20511 Mtetra
.5 .708 .964 r
.26371 .17762 .2532 .18903 .28333 .20063 .29412 .19022 Mtetra
.531 .738 .97 r
.233 .16713 .22277 .17926 .2532 .18903 .26371 .17762 Mtetra
.553 .761 .974 r
.20196 .15831 .19202 .17096 .22277 .17926 .233 .16713 Mtetra
.569 .777 .977 r
.1706 .1507 .16095 .1637 .19202 .17096 .20196 .15831 Mtetra
.578 .787 .978 r
.1389 .14384 .12956 .15711 .16095 .1637 .1706 .1507 Mtetra
.589 .817 .986 r
.81392 .25505 .79856 .26585 .82418 .26961 .83973 .25878 Mtetra
.588 .83 .991 r
.78792 .25217 .77274 .26281 .79856 .26585 .81392 .25505 Mtetra
.582 .85 .995 r
.76174 .25061 .74674 .26093 .77274 .26281 .78792 .25217 Mtetra
.568 .875 .994 r
.73537 .25092 .72054 .26069 .74674 .26093 .76174 .25061 Mtetra
.531 .894 .973 r
.70882 .25361 .69415 .26252 .72054 .26069 .73537 .25092 Mtetra
.456 .882 .908 r
.68204 .25894 .66753 .26664 .69415 .26252 .70882 .25361 Mtetra
.337 .817 .787 r
.65501 .26671 .64066 .27289 .66753 .26664 .68204 .25894 Mtetra
0 0 0 r
.62765 .27608 .61348 .28053 .64066 .27289 .65501 .26671 Mtetra
.59992 .28554 .58594 .28823 .61348 .28053 .62765 .27608 Mtetra
.57176 .29311 .55801 .29427 .58594 .28823 .59992 .28554 Mtetra
.021 0 0 r
.54318 .29673 .52969 .29686 .55801 .29427 .57176 .29311 Mtetra
0 .576 .746 r
.5142 .29483 .50101 .29463 .52969 .29686 .54318 .29673 Mtetra
.067 .589 .875 r
.4849 .28678 .47202 .28704 .50101 .29463 .5142 .29483 Mtetra
.149 .576 .931 r
.45536 .27307 .44281 .27451 .47202 .28704 .4849 .28678 Mtetra
.223 .563 .937 r
.42564 .25519 .41341 .25834 .44281 .27451 .45536 .27307 Mtetra
.286 .566 .933 r
.39577 .23515 .38386 .24027 .41341 .25834 .42564 .25519 Mtetra
.344 .586 .934 r
.36576 .21498 .35415 .22207 .38386 .24027 .39577 .23515 Mtetra
.397 .619 .941 r
.33557 .19624 .32425 .20511 .35415 .22207 .36576 .21498 Mtetra
.446 .657 .95 r
.30515 .17987 .29412 .19022 .32425 .20511 .33557 .19624 Mtetra
.489 .696 .96 r
.27446 .16614 .26371 .17762 .29412 .19022 .30515 .17987 Mtetra
.523 .729 .968 r
.24346 .15483 .233 .16713 .26371 .17762 .27446 .16614 Mtetra
.549 .756 .973 r
.21213 .14544 .20196 .15831 .233 .16713 .24346 .15483 Mtetra
.566 .774 .976 r
.18046 .13742 .1706 .1507 .20196 .15831 .21213 .14544 Mtetra
.577 .786 .978 r
.14846 .13029 .1389 .14384 .1706 .1507 .18046 .13742 Mtetra
.589 .819 .987 r
.82961 .24407 .81392 .25505 .83973 .25878 .8556 .24774 Mtetra
.587 .834 .992 r
.80343 .24137 .78792 .25217 .81392 .25505 .82961 .24407 Mtetra
.58 .857 .995 r
.77707 .24018 .76174 .25061 .78792 .25217 .80343 .24137 Mtetra
.561 .883 .991 r
.75054 .24114 .73537 .25092 .76174 .25061 .77707 .24018 Mtetra
.513 .896 .956 r
.72382 .24483 .70882 .25361 .73537 .25092 .75054 .24114 Mtetra
.414 .864 .859 r
.69689 .25155 .68204 .25894 .70882 .25361 .72382 .24483 Mtetra
.266 .761 .693 r
.6697 .26107 .65501 .26671 .68204 .25894 .69689 .25155 Mtetra
0 0 0 r
.64218 .27245 .62765 .27608 .65501 .26671 .6697 .26107 Mtetra
.007 0 0 r
.61426 .28394 .59992 .28554 .62765 .27608 .64218 .27245 Mtetra
.086 0 0 r
.58588 .29328 .57176 .29311 .59992 .28554 .61426 .28394 Mtetra
.124 0 0 r
.55703 .29811 .54318 .29673 .57176 .29311 .58588 .29328 Mtetra
.108 0 0 r
.52776 .29661 .5142 .29483 .54318 .29673 .55703 .29811 Mtetra
0 .521 .815 r
.49813 .28804 .4849 .28678 .5142 .29483 .52776 .29661 Mtetra
.075 .526 .901 r
.46824 .273 .45536 .27307 .4849 .28678 .49813 .28804 Mtetra
.169 .521 .918 r
.43817 .25316 .42564 .25519 .45536 .27307 .46824 .273 Mtetra
.245 .53 .918 r
.40797 .23087 .39577 .23515 .42564 .25519 .43817 .25316 Mtetra
.312 .556 .922 r
.37764 .20843 .36576 .21498 .39577 .23515 .40797 .23087 Mtetra
.372 .593 .931 r
.34714 .18767 .33557 .19624 .36576 .21498 .37764 .20843 Mtetra
.428 .637 .944 r
.31643 .16963 .30515 .17987 .33557 .19624 .34714 .18767 Mtetra
.476 .681 .956 r
.28545 .15461 .27446 .16614 .30515 .17987 .31643 .16963 Mtetra
.514 .72 .966 r
.25415 .14236 .24346 .15483 .27446 .16614 .28545 .15461 Mtetra
.543 .75 .972 r
.22253 .13233 .21213 .14544 .24346 .15483 .25415 .14236 Mtetra
.563 .77 .976 r
.19055 .12388 .18046 .13742 .21213 .14544 .22253 .13233 Mtetra
.575 .784 .978 r
.15823 .11644 .14846 .13029 .18046 .13742 .19055 .12388 Mtetra
.589 .822 .988 r
.84563 .23289 .82961 .24407 .8556 .24774 .87181 .23649 Mtetra
.586 .839 .993 r
.81927 .23041 .80343 .24137 .82961 .24407 .84563 .23289 Mtetra
.578 .864 .996 r
.79273 .22966 .77707 .24018 .80343 .24137 .81927 .23041 Mtetra
.552 .89 .985 r
.76604 .23138 .75054 .24114 .77707 .24018 .79273 .22966 Mtetra
.488 .894 .93 r
.73917 .23623 .72382 .24483 .75054 .24114 .76604 .23138 Mtetra
.36 .83 .789 r
.71211 .24455 .69689 .25155 .72382 .24483 .73917 .23623 Mtetra
0 0 0 r
.68478 .2561 .6697 .26107 .69689 .25155 .71211 .24455 Mtetra
.6571 .26979 .64218 .27245 .6697 .26107 .68478 .2561 Mtetra
.095 0 0 r
.629 .28365 .61426 .28394 .64218 .27245 .6571 .26979 Mtetra
.175 0 0 r
.6004 .29504 .58588 .29328 .61426 .28394 .629 .28365 Mtetra
.221 0 0 r
.57129 .30127 .55703 .29811 .58588 .29328 .6004 .29504 Mtetra
.219 0 0 r
.5417 .30024 .52776 .29661 .55703 .29811 .57129 .30127 Mtetra
0 .438 .736 r
.51172 .2911 .49813 .28804 .52776 .29661 .5417 .30024 Mtetra
0 .464 .861 r
.48146 .27452 .46824 .273 .49813 .28804 .51172 .2911 Mtetra
.108 .472 .894 r
.45102 .25245 .43817 .25316 .46824 .273 .48146 .27452 Mtetra
.2 .489 .899 r
.42047 .22758 .40797 .23087 .43817 .25316 .45102 .25245 Mtetra
.277 .521 .907 r
.3898 .20256 .37764 .20843 .40797 .23087 .42047 .22758 Mtetra
.345 .565 .919 r
.35899 .17947 .34714 .18767 .37764 .20843 .3898 .20256 Mtetra
.407 .615 .935 r
.32797 .15952 .31643 .16963 .34714 .18767 .35899 .17947 Mtetra
.461 .665 .951 r
.29669 .14305 .28545 .15461 .31643 .16963 .32797 .15952 Mtetra
.504 .709 .963 r
.2651 .12975 .25415 .14236 .28545 .15461 .29669 .14305 Mtetra
.537 .743 .97 r
.23316 .119 .22253 .13233 .25415 .14236 .2651 .12975 Mtetra
.559 .766 .975 r
.20088 .11006 .19055 .12388 .22253 .13233 .23316 .119 Mtetra
.573 .782 .977 r
.16824 .10228 .15823 .11644 .19055 .12388 .20088 .11006 Mtetra
.589 .824 .989 r
.86199 .22152 .84563 .23289 .87181 .23649 .88836 .22502 Mtetra
.585 .844 .994 r
.83545 .2193 .81927 .23041 .84563 .23289 .86199 .22152 Mtetra
.574 .871 .995 r
.80875 .21907 .79273 .22966 .81927 .23041 .83545 .2193 Mtetra
.541 .896 .975 r
.7819 .22166 .76604 .23138 .79273 .22966 .80875 .21907 Mtetra
.454 .884 .891 r
.75489 .22785 .73917 .23623 .76604 .23138 .7819 .22166 Mtetra
.292 .776 .697 r
.7277 .23802 .71211 .24455 .73917 .23623 .75489 .22785 Mtetra
0 0 0 r
.70025 .25192 .68478 .2561 .71211 .24455 .7277 .23802 Mtetra
.062 0 0 r
.67244 .26829 .6571 .26979 .68478 .2561 .70025 .25192 Mtetra
.173 0 0 r
.64417 .28487 .629 .28365 .6571 .26979 .67244 .26829 Mtetra
.252 0 0 r
.61536 .29866 .6004 .29504 .629 .28365 .64417 .28487 Mtetra
.307 0 0 r
.58597 .30653 .57129 .30127 .6004 .29504 .61536 .29866 Mtetra
.324 0 0 r
.55605 .30605 .5417 .30024 .57129 .30127 .58597 .30653 Mtetra
.255 0 0 r
.5257 .29626 .51172 .2911 .5417 .30024 .55605 .30605 Mtetra
0 .391 .809 r
.49505 .27792 .48146 .27452 .51172 .2911 .5257 .29626 Mtetra
.041 .415 .863 r
.46422 .25329 .45102 .25245 .48146 .27452 .49505 .27792 Mtetra
.151 .443 .876 r
.43329 .22545 .42047 .22758 .45102 .25245 .46422 .25329 Mtetra
.239 .483 .888 r
.40226 .19748 .3898 .20256 .42047 .22758 .43329 .22545 Mtetra
.315 .533 .906 r
.37111 .17175 .35899 .17947 .3898 .20256 .40226 .19748 Mtetra
.384 .59 .926 r
.33978 .14962 .32797 .15952 .35899 .17947 .37111 .17175 Mtetra
.444 .647 .944 r
.30819 .13149 .29669 .14305 .32797 .15952 .33978 .14962 Mtetra
.493 .696 .959 r
.27629 .11701 .2651 .12975 .29669 .14305 .30819 .13149 Mtetra
.53 .735 .969 r
.24405 .10545 .23316 .119 .2651 .12975 .27629 .11701 Mtetra
.555 .762 .974 r
.21145 .09596 .20088 .11006 .23316 .119 .24405 .10545 Mtetra
.571 .779 .977 r
.17848 .08782 .16824 .10228 .20088 .11006 .21145 .09596 Mtetra
.589 .828 .99 r
.87871 .20995 .86199 .22152 .88836 .22502 .90526 .21333 Mtetra
.584 .849 .994 r
.85199 .20804 .83545 .2193 .86199 .22152 .87871 .20995 Mtetra
.569 .879 .993 r
.82513 .20842 .80875 .21907 .83545 .2193 .85199 .20804 Mtetra
.524 .9 .959 r
.79813 .21203 .7819 .22166 .80875 .21907 .82513 .20842 Mtetra
.41 .861 .834 r
.771 .21976 .75489 .22785 .7819 .22166 .79813 .21203 Mtetra
0 0 0 r
.7437 .23208 .7277 .23802 .75489 .22785 .771 .21976 Mtetra
.71614 .24868 .70025 .25192 .7277 .23802 .7437 .23208 Mtetra
.138 0 0 r
.68822 .26815 .67244 .26829 .70025 .25192 .71614 .24868 Mtetra
.239 0 0 r
.6598 .28789 .64417 .28487 .67244 .26829 .68822 .26815 Mtetra
.315 0 0 r
.63078 .30446 .61536 .29866 .64417 .28487 .6598 .28789 Mtetra
.378 0 0 r
.60112 .31424 .58597 .30653 .61536 .29866 .63078 .30446 Mtetra
.416 0 0 r
.57086 .31443 .55605 .30605 .58597 .30653 .60112 .31424 Mtetra
.369 0 0 r
.54011 .3039 .5257 .29626 .55605 .30605 .57086 .31443 Mtetra
0 .306 .744 r
.50904 .28354 .49505 .27792 .5257 .29626 .54011 .3039 Mtetra
0 .351 .824 r
.47779 .25596 .46422 .25329 .49505 .27792 .50904 .28354 Mtetra
.097 .392 .849 r
.44645 .22472 .43329 .22545 .46422 .25329 .47779 .25596 Mtetra
.197 .44 .867 r
.41504 .19336 .40226 .19748 .43329 .22545 .44645 .22472 Mtetra
.283 .498 .889 r
.38354 .16459 .37111 .17175 .40226 .19748 .41504 .19336 Mtetra
.359 .563 .914 r
.35187 .13999 .33978 .14962 .37111 .17175 .38354 .16459 Mtetra
.426 .626 .937 r
.31996 .11997 .30819 .13149 .33978 .14962 .35187 .13999 Mtetra
.481 .682 .955 r
.28775 .10415 .27629 .11701 .30819 .13149 .31996 .11997 Mtetra
.522 .726 .966 r
.25519 .09167 .24405 .10545 .27629 .11701 .28775 .10415 Mtetra
.551 .757 .973 r
.22226 .08158 .21145 .09596 .24405 .10545 .25519 .09167 Mtetra
.569 .776 .977 r
.18896 .07303 .17848 .08782 .21145 .09596 .22226 .08158 Mtetra
.588 .831 .991 r
.89579 .19819 .87871 .20995 .90526 .21333 .92253 .20142 Mtetra
.583 .856 .995 r
.8689 .19665 .85199 .20804 .87871 .20995 .89579 .19819 Mtetra
.563 .887 .989 r
.84188 .19773 .82513 .20842 .85199 .20804 .8689 .19665 Mtetra
.502 .9 .935 r
.81475 .20252 .79813 .21203 .82513 .20842 .84188 .19773 Mtetra
.352 .821 .756 r
.78751 .21203 .771 .21976 .79813 .21203 .81475 .20252 Mtetra
0 0 0 r
.76012 .22682 .7437 .23208 .771 .21976 .78751 .21203 Mtetra
.069 0 0 r
.73249 .24655 .71614 .24868 .7437 .23208 .76012 .22682 Mtetra
.201 0 0 r
.70447 .26961 .68822 .26815 .71614 .24868 .73249 .24655 Mtetra
.292 0 .078 r
.67592 .29303 .6598 .28789 .68822 .26815 .70447 .26961 Mtetra
.366 0 .094 r
.64671 .31283 .63078 .30446 .6598 .28789 .67592 .29303 Mtetra
.434 0 .04 r
.61678 .32484 .60112 .31424 .63078 .30446 .64671 .31283 Mtetra
.491 0 0 r
.58616 .32582 .57086 .31443 .60112 .31424 .61678 .32484 Mtetra
.476 0 0 r
.555 .31445 .54011 .3039 .57086 .31443 .58616 .32582 Mtetra
0 .212 .665 r
.52347 .29176 .50904 .28354 .54011 .3039 .555 .31445 Mtetra
0 .281 .778 r
.49175 .26078 .47779 .25596 .50904 .28354 .52347 .29176 Mtetra
.04 .336 .816 r
.45997 .22563 .44645 .22472 .47779 .25596 .49175 .26078 Mtetra
.153 .394 .842 r
.42815 .19038 .41504 .19336 .44645 .22472 .45997 .22563 Mtetra
.247 .46 .87 r
.39627 .15814 .38354 .16459 .41504 .19336 .42815 .19038 Mtetra
.331 .532 .9 r
.36426 .13069 .35187 .13999 .38354 .16459 .39627 .15814 Mtetra
.405 .603 .928 r
.33202 .10853 .31996 .11997 .35187 .13999 .36426 .13069 Mtetra
.467 .666 .949 r
.29949 .09119 .28775 .10415 .31996 .11997 .33202 .10853 Mtetra
.513 .716 .964 r
.2666 .07768 .25519 .09167 .28775 .10415 .29949 .09119 Mtetra
.545 .751 .972 r
.23334 .06691 .22226 .08158 .25519 .09167 .2666 .07768 Mtetra
.566 .773 .976 r
.1997 .05791 .18896 .07303 .22226 .08158 .23334 .06691 Mtetra
.588 .835 .992 r
.91326 .18624 .89579 .19819 .92253 .20142 .94018 .18928 Mtetra
.581 .862 .995 r
.8862 .18513 .8689 .19665 .89579 .19819 .91326 .18624 Mtetra
.554 .894 .982 r
.85903 .18702 .84188 .19773 .8689 .19665 .8862 .18513 Mtetra
.471 .892 .899 r
.83178 .19318 .81475 .20252 .84188 .19773 .85903 .18702 Mtetra
.282 .761 .656 r
.80446 .20476 .78751 .21203 .81475 .20252 .83178 .19318 Mtetra
0 0 0 r
.77701 .2224 .76012 .22682 .78751 .21203 .80446 .20476 Mtetra
.138 0 0 r
.74933 .24574 .73249 .24655 .76012 .22682 .77701 .2224 Mtetra
.253 0 .093 r
.72125 .27296 .70447 .26961 .73249 .24655 .74933 .24574 Mtetra
.335 0 .163 r
.6926 .30064 .67592 .29303 .70447 .26961 .72125 .27296 Mtetra
.405 .012 .176 r
.66321 .32421 .64671 .31283 .67592 .29303 .6926 .30064 Mtetra
.477 .041 .132 r
.633 .33883 .61678 .32484 .64671 .31283 .66321 .32421 Mtetra
.55 .041 0 r
.60201 .34075 .58616 .32582 .61678 .32484 .633 .33883 Mtetra
.569 0 0 r
.5704 .32842 .555 .31445 .58616 .32582 .60201 .34075 Mtetra
0 .112 .575 r
.53837 .30304 .52347 .29176 .555 .31445 .5704 .32842 Mtetra
0 .204 .724 r
.50615 .26814 .49175 .26078 .52347 .29176 .53837 .30304 Mtetra
0 .276 .779 r
.47388 .22848 .45997 .22563 .49175 .26078 .50615 .26814 Mtetra
.107 .345 .813 r
.44162 .18874 .42815 .19038 .45997 .22563 .47388 .22848 Mtetra
.21 .419 .847 r
.40934 .15252 .39627 .15814 .42815 .19038 .44162 .18874 Mtetra
.301 .498 .883 r
.37696 .12184 .36426 .13069 .39627 .15814 .40934 .15252 Mtetra
.382 .577 .917 r
.34438 .09723 .33202 .10853 .36426 .13069 .37696 .12184 Mtetra
.451 .648 .943 r
.3115 .07815 .29949 .09119 .33202 .10853 .34438 .09723 Mtetra
.503 .704 .96 r
.27829 .06348 .2666 .07768 .29949 .09119 .3115 .07815 Mtetra
.54 .744 .97 r
.24469 .05195 .23334 .06691 .2666 .07768 .27829 .06348 Mtetra
.563 .769 .975 r
.2107 .04246 .1997 .05791 .23334 .06691 .24469 .05195 Mtetra
.587 .84 .993 r
.93112 .17409 .91326 .18624 .94018 .18928 .95822 .17691 Mtetra
.578 .87 .995 r
.9039 .17349 .8862 .18513 .91326 .18624 .93112 .17409 Mtetra
.542 .9 .971 r
.87659 .17634 .85903 .18702 .8862 .18513 .9039 .17349 Mtetra
.43 .873 .846 r
.84924 .18407 .83178 .19318 .85903 .18702 .87659 .17634 Mtetra
0 0 0 r
.82186 .19803 .80446 .20476 .83178 .19318 .84924 .18407 Mtetra
.038 0 0 r
.79438 .21897 .77701 .2224 .80446 .20476 .82186 .19803 Mtetra
.196 0 .05 r
.76669 .2465 .74933 .24574 .77701 .2224 .79438 .21897 Mtetra
.295 0 .174 r
.7386 .27853 .72125 .27296 .74933 .24574 .76669 .2465 Mtetra
.368 .017 .232 r
.70988 .31117 .6926 .30064 .72125 .27296 .7386 .27853 Mtetra
.436 .07 .244 r
.68033 .33913 .66321 .32421 .6926 .30064 .70988 .31117 Mtetra
.51 .104 .207 r
.64985 .35682 .633 .33883 .66321 .32421 .68033 .33913 Mtetra
.595 .119 .093 r
.61847 .35985 .60201 .34075 .633 .33883 .64985 .35682 Mtetra
.644 .089 0 r
.58637 .34643 .5704 .32842 .60201 .34075 .61847 .35985 Mtetra
.517 0 0 r
.55379 .31794 .53837 .30304 .5704 .32842 .58637 .34643 Mtetra
0 .125 .664 r
.52101 .27849 .50615 .26814 .53837 .30304 .55379 .31794 Mtetra
0 .214 .738 r
.48821 .23361 .47388 .22848 .50615 .26814 .52101 .27849 Mtetra
.059 .293 .781 r
.45546 .18871 .44162 .18874 .47388 .22848 .48821 .23361 Mtetra
.171 .375 .822 r
.42275 .14791 .40934 .15252 .44162 .18874 .45546 .18871 Mtetra
.269 .461 .864 r
.38998 .11351 .37696 .12184 .40934 .15252 .42275 .14791 Mtetra
.358 .549 .904 r
.35704 .08612 .34438 .09723 .37696 .12184 .38998 .11351 Mtetra
.433 .628 .935 r
.32382 .06507 .3115 .07815 .34438 .09723 .35704 .08612 Mtetra
.492 .691 .956 r
.29026 .04908 .27829 .06348 .3115 .07815 .32382 .06507 Mtetra
.533 .736 .969 r
.25632 .0367 .24469 .05195 .27829 .06348 .29026 .04908 Mtetra
.559 .765 .975 r
.22197 .02666 .2107 .04246 .24469 .05195 .25632 .0367 Mtetra
.586 .845 .994 r
.94939 .16175 .93112 .17409 .95822 .17691 .97667 .1643 Mtetra
.574 .878 .993 r
.92201 .16175 .9039 .17349 .93112 .17409 .94939 .16175 Mtetra
.525 .904 .954 r
.89458 .1657 .87659 .17634 .9039 .17349 .92201 .16175 Mtetra
.377 .837 .773 r
.86715 .17526 .84924 .18407 .87659 .17634 .89458 .1657 Mtetra
0 0 0 r
.83974 .19197 .82186 .19803 .84924 .18407 .86715 .17526 Mtetra
.107 0 0 r
.81228 .21672 .79438 .21897 .82186 .19803 .83974 .19197 Mtetra
.243 0 .137 r
.78463 .24909 .76669 .2465 .79438 .21897 .81228 .21672 Mtetra
.328 0 .24 r
.75657 .28671 .7386 .27853 .76669 .2465 .78463 .24909 Mtetra
.394 .068 .289 r
.72782 .32514 .70988 .31117 .7386 .27853 .75657 .28671 Mtetra
.459 .118 .299 r
.69815 .35824 .68033 .33913 .70988 .31117 .72782 .32514 Mtetra
.535 .156 .269 r
.6674 .37952 .64985 .35682 .68033 .33913 .69815 .35824 Mtetra
.629 .183 .173 r
.63561 .38387 .61847 .35985 .64985 .35682 .6674 .37952 Mtetra
.703 .176 0 r
.60297 .36919 .58637 .34643 .61847 .35985 .63561 .38387 Mtetra
.605 .087 0 r
.56979 .33708 .55379 .31794 .58637 .34643 .60297 .36919 Mtetra
0 .044 .6 r
.53639 .29236 .52101 .27849 .55379 .31794 .56979 .33708 Mtetra
0 .15 .693 r
.50299 .24144 .48821 .23361 .52101 .27849 .53639 .29236 Mtetra
.011 .24 .746 r
.46971 .19058 .45546 .18871 .48821 .23361 .50299 .24144 Mtetra
.13 .329 .794 r
.43653 .14451 .42275 .14791 .45546 .18871 .46971 .19058 Mtetra
.235 .422 .843 r
.40334 .10585 .38998 .11351 .42275 .14791 .43653 .14451 Mtetra
.331 .517 .889 r
.37002 .07526 .35704 .08612 .38998 .11351 .40334 .10585 Mtetra
.414 .605 .926 r
.33644 .05198 .32382 .06507 .35704 .08612 .37002 .07526 Mtetra
.479 .676 .952 r
.30253 .0345 .29026 .04908 .32382 .06507 .33644 .05198 Mtetra
.525 .728 .966 r
.26823 .02116 .25632 .0367 .29026 .04908 .30253 .0345 Mtetra
.555 .761 .974 r
.23353 .01051 .22197 .02666 .25632 .0367 .26823 .02116 Mtetra
0 g
.23392 0 m
.22165 .32633 L
s
.22165 .32633 m
0 .5711 L
s
0 .5711 m
.01808 .31073 L
s
.01808 .31073 m
.23392 0 L
s
.23392 0 m
.22165 .32633 L
s
.22165 .32633 m
1 .44899 L
s
1 .44899 m
.97589 .15476 L
s
.97589 .15476 m
.23392 0 L
s
.23392 0 m
.97589 .15476 L
s
.37073 .02854 m
.37062 .03524 L
s
[(-2)] .37093 .01512 -0.01511 1 Mshowa
.62759 .08211 m
.62777 .08882 L
s
[(0)] .62724 .0687 .02657 1 Mshowa
.86434 .1315 m
.86477 .13819 L
s
[(2)] .86348 .11811 .06435 1 Mshowa
.125 Mabswid
.43697 .04235 m
.43695 .04638 L
s
.50183 .05588 m
.50186 .05991 L
s
.56536 .06913 m
.56543 .07316 L
s
.68857 .09483 m
.68872 .09886 L
s
.74833 .1073 m
.74852 .11132 L
s
.80691 .11952 m
.80713 .12354 L
s
.30306 .01442 m
.30295 .01844 L
s
.92065 .14324 m
.92095 .14726 L
s
gsave
.62546 .00164 -66.1329 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
1 .44899 m
.6295 .64391 L
s
1 .44899 m
.99945 .44231 L
s
[(0)] 1.0011 .46237 -0.08195 -1 Mshowa
.85549 .52502 m
.85509 .51832 L
s
[(1)] .85628 .53841 -0.0592 -1 Mshowa
.73364 .58912 m
.73337 .58242 L
s
[(2)] .73418 .60253 -0.04041 -1 Mshowa
.6295 .64391 m
.62934 .6372 L
s
[(3)] .62983 .65732 -0.02464 -1 Mshowa
.125 Mabswid
.96899 .46531 m
.96868 .4613 L
s
.93909 .48104 m
.9388 .47703 L
s
.91024 .49622 m
.90997 .4922 L
s
.88239 .51087 m
.88214 .50685 L
s
.82949 .5387 m
.82927 .53468 L
s
.80434 .55193 m
.80414 .54791 L
s
.78001 .56473 m
.77982 .56071 L
s
.75645 .57712 m
.75628 .5731 L
s
.71152 .60076 m
.71138 .59673 L
s
.69008 .61204 m
.68995 .60801 L
s
.66929 .62298 m
.66916 .61895 L
s
.6491 .6336 m
.64899 .62957 L
s
gsave
.79605 .63878 -65.7531 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{215.625, 173.438},
  ImageMargins->{{60, 0}, {0, 0.25}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003G0000[A000`40O003h00Oegoo003GOol00=Mo
o`00egoo003GOol00=Moo`00egoo003GOol00=Moo`00egoo003GOol00=Moo`00egoo003GOol00=Mo
o`00egoo003GOol007=oo`800003Ool0000005moo`00M7oo00<007oo0000H7oo001eOol00`00Oomo
o`1OOol007=oo`800003Ool0000005moo`00Agoo1000S7oo0017Ool00`00Oomoo`2=Ool004Qoo`03
001oogoo08aoo`00@Goo100017oo00<007ooOol0Rgoo0017Ool01000Oomoo`00S7oo000/Ool3000I
Ool2002=Ool002]oo`80009oo`D00:=oo`00:goo0P001goo1P00WGoo000ZOol01000A_h004Kn2goo
1000VWoo000YOol02@00Oom2oP00@_i77d;nAai2oP0;Ool5002EOol002Qoo`05001oodKnA_h00004
A_h3@]h>Ool5000^Ool2001POol002Qoo`0A0016oTLN@_h004;nAai2oTLO?]i2oSkM@_hngT;n?]e2
oP0=Ool6000XOol01000Oomoo`00Ggoo000WOol01P00A_i6oTKnAah00096oP03Aai2gT;N00I2gP03
>Ydj_CZm015oo`D002=oo`04001oogoo001OOol002Ioo`0G0016oTLN@_i77dKn0012oTLO@]i2oT;N
@_hngT;n?]e2oSZM?[hjWCjn>Ydn_P0DOol5000NOol01000Oomoo`00Ggoo000VOol04@00Aai6oTLN
A_i77P00Aai2gT;n@]i2oT;N@_i2gT;n>Yd00SZm00Hj_SZM>[dj_CZn>YdGOol4000JOol01000Oomo
o`00Ggoo000UOol06`00Aai6oTLOA_i77TKn0012gTKn@]i2oT;N@_i2gT;n>[dn_SZm?[hjWCjn>Ydn
_SZM<WdbG00JOol6000EOol2001POol002Aoo`0900177TKnAai6oTLNA_h004Kn00E2oP0<@]i2oT;N
?[hn_Cjn>[dn_SZm>[hjWCZm0S9M00<bG39MOol077oo1@00Lgoo000TOol07`00A_i77dKnAai6oTLO
0016oT;NA_i2gTKn@]i6oT;N?[hj_Cjn>[dn_SZm?[hj_Cjn<U`fOC9L<WdbG3Im025oo`D006ioo`00
8goo00@004LNAai6oP=77P04A_h004;nA_h5@_h02CkN?[hngSZm?[hn_Cjn>[dn_P02=Wd01S9L<Udb
GC9M<U`bGBEoo`D006Uoo`008Woo02@004KnBam6oTLNA_i77dKnAah004Kn@_i6oT;nA_i2oSkN?[dn
gSjm?]hn_CkN?[dfOC9l=WdbOCIm<W`fOC9L<WdbG3Im<U`XOol4000_Ool4000bOol0025oo`030017
7TLN00I77P03@_h004;n0092oP0:A_i2oSkN?]i2gSjm?]hn_SkN?[d2=Yd6=Wd3<Ud00c9L:Q/Un`0[
Ool5000ZOol00`00Oomoo`0cOol0025oo`0W001;7dKnAam6oT/OA_i77d;nAal004Kn@_i6oT;nA_hn
_D;N?]e2gSjm?]hn_CkN=WdjWSIm>YdbO3Im<WdfOC9l=WdUnbXL9O/Z72Gk02ioo`H002Ioo`03001o
ogoo039oo`0087oo00<004LNAah01TLN00=6oT;n00000TKn00A2oTKn?]i2gP<ngP06@]hngSkN=Ydj
WCIm0SJM00<jWCIm=Wd00SIm00LZ72Xl9O/Z72Gk:Q/Un`0cOol5000ROol00`00Oomoo`0aOol001mo
o`0J001;7dLNBam6oT/OAai;7dKnAam2oTKn00177d;nA_hngD;n?]i2gSjm@]hngD;N=Ydj_P8jW@0?
=WdjWSIm>YdfOCZN:Q`^?2XK;S`UnbXL9O/Z72Gk03Moo`D001]oo`04001oogoo000bOol001moo`03
00177TLN00I77P=6oP060012oTKnA_i2gSkN0d;N00<ngT;N>Yd01CZM00@fOCJM=YdjW@8^?004:Q`^
?2XL:S`2:Q`00bGk:Q/Un`0kOol5000GOol2000cOol001ioo`0?00177T/OAai;7dLNBam77TLO@_i7
7T;nAal004LN0092oP0H?]i2gSkM@_hngT;N>Ydn_SZM>[hfWCZn>Ydj_SJM<Ud^?2iM;S`bGBXL;S`Z
6bhl0RXL00<UnbXL9O/0?goo1000B7oo000MOol00`00Aai77P06Aah02TKnAai6oTLNA_h004Kn@_i2
gT;n0T;N00PngT;N@]hn_SZm>[hj_Cjn0cZM00DbGC9L;S`^?2iL00@^?007:Q`Z?2XL7KXIVQfj6IX0
@7oo00<007oo00001000@goo000LOol0:@00Aai;7dLNBam77T/OAai;7dKnAai2oTLOA_i77P00@_i2
gT;n?]i2oT;N@_hngSjn>Ydn_SZM?[hjWCjn>YdbOC9L<Wd^G39m;S`^GBhl<Ud00Rhl00LZ6b7K7KXM
^QVI7KXIVP16Ool5000nOol001aoo`0400177TLNBah3Aah02D/NA_i77TKnAai6oTLNA_h00002@_h0
3d;N@_i2gT;n@]hn_Sjm?[hj_Cjn>[dj_SZm=WdbO@03<Ud0139L<Ud^?2iL0bhl00PQfagJ8M/Mfafj
6IXM^QVJBGoo1P00>Goo000KOol0<000Bam77T/OAai;7dLNBam6oTLNA_i77dKnAai2oTLO0012oT;N
A_i2gT;n@]hngSZm?]hj_CkN>[dn_SZM?[hbOCIm<W`fOC9L<Wd^G39m<U`Uo27K9O`Qnb7K7KXQf`8M
^P036ITM^Woo04ioo`D003Aoo`006Woo00@004LNAai;7P=77P03Bai77TLN00977P06A_i77TLNAai2
oP001D;n00<ngSjn?]h00Sjn00Dn_Cjn?[hn_S9m00<fO@09<WdfOC9M<UdbG2XL9Q`Unb7k008Un`07
8M/MfR7K7M/M^QVJ7KX0Dgoo1@00;goo000JOol01`00Aai;?dLNBam77T/o00977P0HA_i77dKnAai6
oTLO@_i6oP00A_i2gT;n@]i6oSjm?]hn_D;N?[dngSZm?]hfOCJM0SIm010bOCIm<W`fOC9m:Q`V6bXL
9Q/Uo27K9O`Qnb7K7KXQf`8M^P036ITM^Woo055oo`03001oogoo009oo`@002]oo`006Goo00<004LN
Bah00dLN00=;7TLNAah01TLN0d;n00H004;n@_i2oTKn?[h3?]h01Cjn?]hngSkN=Wd00cJM00DfOCJM
=WdfOC9m008Z?006:Q`V72XL9Q`Unb7k0RGk00LQfagJ8M/Mfafj6IXM^P1JOol5000VOol001Qoo`07
00177T/oAai;7dLNBcl00TLN0396oTLOA_i77TKnAam2oTKn@_i6oP00A_i2gTKn?]i2gSkM@]hn_CkN
?[e2gSJM>[hfWCZN=WdfWCIm>YhfOBhl:S`^?BXl:Q`V6bXL9Q/Z727K9O`Qnb7K7KXQfafj3ET=>15I
Fgoo00<007ooOol01@008Goo000GOol00`00Aai;7P03Aah00d/NAai77P07Aah01dKn@_i6oT;n0012
oTKn00<ngP05@]hngSkN?]i2gP03>Yd00cZN>YdjW@02=Yd013Im;Ud^GBhl0bXl00H^?2HL:Q`V72XL
8O/29O/01QEi4GTANA5i3ET=>6=oo`<001ioo`005goo00h004/oAai;7dLNBcm77T/OA_i;7dKnAam6
oT/O0TKn02e2oTLO@_i6oP00AalngT;n?]e2gSkN@]hngD;N>Ydj_SJM>[hfWCZn=Ydj_SJM<Ud^?39M
;U`bGBXl;SdZ?2hl9Q/Z72HK:Q`EVQVj5IXENQ5I5GXAN@eI3CP0HWoo0`000goo1@005Woo000FOol0
2000Bai77T/NAai;7TLNBah7Aah3A_h01D;nA_h004Kn?]h00d;N00TngT;N@]hj_SZm>[hj_CZn>[d0
0SZM00HjWSZM<WdbOBiM;U`3;Ud3:S`00bhl7K/Mf`027M/011FJ6IXIVQEi0a5i00<=F@dhOol0Dgoo
00A3WT>M@ii3W@E7O`I;G`03001oogoo00=oo`03001oogoo01Ioo`005Goo00h004/oAai;7dLNBcm7
7T/OA_i;7dLNBam6oT/O0TLN01Y2oTLO@_i77T;n0012gT;n?]i2oSkN@_hngCkN>[dngSZM?[hjWCZn
>Ydn_S9M<WdbG39m0S9M01@^?39M;U`bGBhl8O`Qnb7l6KXMfafj7M/EVQVj5IXENQ5I5GX=>0eIDWoo
018oWD>N?ge3WTMnBgm7OT]oAgi;OdMNBem7GT]OAei;Ggoo0005Ool00`00Oomoo`0FOol001Eoo`07
00177T/NAai;7TLNBah024LN00=6oTLN@_h00dKn00T004;n@]i2oT;N@_i2gSjn>[d00cjn00Dj_CZn
>[dj_S9m008fO@03<WdbGC9m008bO@03;U`^GBiM008V708Qn`038O`M^agK008Mf`045IXIVQVJ5GT2
4GT00`dh3EUoo`1=Ool00bmH@ii3WP03@ih3Agl00d]oAgm7O`05Bel3Ool20004Ool00`00Oomoo`0F
Ool001Aoo`0=00177T/oAai;?dLNBcm77T/OAai;7dLNBal00TLN00a2oTLO@_i77T;nAam2oP00?]i2
oT;N@_h2?]h04cjm?]hj_CkN>[dngSZm?]hbOCJM<WdfWS9m=YdbG39m<UdbOBHK00<V700@9Q/Qo27k
8O`QfagK7KXMfaFJ6KXEVQEj4ETENPdh3EU;Ool04P00<eY7WT=nAii3OT]oAei;OdMNBgm7GT]OAci;
GdMNBem7?PAoo`03001oogoo00=oo`03001oogoo01Ioo`004goo00L004LNBai77T/NAai;7P0:Aah0
1dKnAai6oTLNA_i2oP0000A2oP03?]hn_SkN008ngP@n_P@fW@05<WdfOCIm=YdbO@02:S`00bXm9Q`V
70049Q`00b7k8O`Qn`037M/011FJ6IXIVQEi0Q5i00<=>7ooOol0Agoo00<003Mj@ih014>N00E;OdMo
Agm7Od]o00I;G`Ioo`8000=oo`8001Qoo`004goo03<004/oAai;?dLNBcm77T/OAai;7dLNBam77T/O
@_i77dKnAai2oTLOA_i2oT;N0012gT;n@]i6oSkN@]hj_CkN?[dngSZm?]hfWCZN=YdjWSJM>YhbOCJN
<Wd^GBXl:SdZ?2Xm:S`00bHL00lV6bHL8O/Qo27K7M/M^QgK2ET=F@UI1CP55`Dh0=H0AGoo0P00018k
Nc^L@gi7Wd=nAim3OT]oAei;OdMNBgm7?T]OAci;GdLnBel8Ool00`00Oomoo`0KOol0019oo`08001;
7TLNBai77T/NAai;7P=77P03Bai77TLN00977P05A_i77TLNAai6oP02@_h00dKn0012oP02@_h8?]h0
13ZM>[hjWCJN0cJM00<fWSJM;Ud012iM00<Z?2Xm:S`01BHL0QFk00@E^Q6J4GXAVP<9F@041CP5603g
0?M2Ool220003P`0>ga7WTMnAim3OTNNAem;OdMOBgm7Gd]OBch3Bel00d/nOomoo`08Ool00`00Oomo
o`0KOol0015oo`0D001;?dLNBcm77T/oAai;?dLNBam77T/OAai;7dKnAam6oTLNA_i77`96oP0c@_i6
od;n0012oTKo@_i2gSkM@]hngT;N?]e2gSJM>[hfWCZn=Ydj_SJM>[h^GC9m;UdbOBiL;UdZ?2iM:S`Z
?BXl:SdIfagl6M/Mo1Fj6K/E^Q6J4GXAVPUI3ET560Dh1AL4m`3F03ioo`80000D300800`0?ge7WdMn
Aim7OTNOAei;OdMNBgm7GT]OAci;GdLnBem7?PYoo`8001eoo`0047oo00D004/NBai;7TLN00=;7P=7
7P03Bai77TLN00977P04A_i77TLNAah2A_h01d;nA_i2oT;n0016oT;n00=2gP@ngP@j_P06>Ydj_SZM
>[hbOC:M0S9m00<^OC9m<Wd012iM00LR727l8Q`Mfagl6M/Mf`025K/011Fj4IXANQ6J0PUI00@560Dh
1AP0mceoo`8000880006?ie7OTMoAgm7WdMn0T]O00Y;OdMOBem;?d]OBci;Gd/oBem;?Paoo`03001o
ogoo01]oo`0047oo01/004LNBcm77T/oAai;?dLNBam77T/oAai;7dLNBam6oTLOA_i;7dKnAai2oTLO
@_i77T;n00000T;n018ngT;n?]i2oSkN@_hj_Cjn>[dn_SZm?[hj_Cjn<WdfWS9m=Yh2<Wd06RiM<Wd^
GC9m8Q`V?BHL8Q`Mo28L6M/Mo1WK7O`IfaVk5KXAVQ5j4IX9F@eI1AP5>03F1?LjOol2000050P03008
04>NAgi7OdMnBim7OT]OAei;OdMNBem7?T]OAci;GdLnBel=Ool2000MOol000moo`04001;7T/nAah2
Bah01d/nAai;7TLNBai77T/N00M77P96oP0:Aai2oTKn@_i6oP00@_i2gT;n?]h3@]h00cZn?[hn_P05
>[h01SJM=YhbOCJM<WdbW@8bO@09;WdbOBYM:UdV?2Hm9S`V?B7l008R70097O`IfagK7M/E^aFj4IXA
NQ6J0089F@041AP5>03G0?LeOol500032005Agl02DMOBem;Gd]OAem;Gd/oBem;?P02Bcl00d]OOomo
o`0=Ool00`00Oomoo`0KOol000ioo`0C00177T/oAai;?dLNBcm77T/OAai;?dLNBam77T/OAai77dKn
Bal00TLN02Y2oTLO@_i77T;nAam2oP00?]i2oT;N@_hngT;n>[dngSZm?]hj_CkN>[dngSJM=YhfWCJn
=YdfWS9m=YhbOCJN:S`ZGBXm:UdR72Hm9Q`V?Agl8Q`27O`03QWK7O`IfaVk5KXAVQ5j4IX9F@Dh1AP5
>03F1?LcOol300005A@1604H0a`460=;OdMNBgm7GT]oAei;GdMNBem7GT]OAci;GdLnBem7?P0AOol0
0`00Oomoo`0KOol000ioo`03001;?TLN009;7P07Bci77T/NAai;7TLNBah024LN00=6oTLN@_h00TKn
00U77T;n@_h004;n@]i2oT;N@_h013kN010j_Sjn?[hngSJM>[hfWCJN=YdfWSJM=Yh^GBim;Ud^O@DZ
G@049SdV?2Hm9S`28Q`44K/00`VJ2GX5F@021ET01@4H1AP5603g0=L0<Goo00@00100300<008D0@<L
0`A7O`03Bem7Gd]O009;G`05Aem;Gd/oBcm;?P02BclAOol20003Ool50002Ool20003Ool40003Ool2
0005Ool000eoo`0J001;?dLNBcm77T/oAai;7dLNBcm77T/OAai;7dLNBam6oT/OAai77d;nAam2oTLN
@_i77`92oP06@]h004;N@_i2gT;n0SkN01@n_CkN?]hngSjm?]hfWCZn=Ydj_SJM=YhfWCJn;WdbWRim
;Wh^GBim0RYM00HZ?BYM:S`N7AXL7Qd26O`03aGK4K/=^a7K3K/9VPUj1ET5>@EI0?L0e`2f1?L0eP0]
Ool06R;e10040100300H0A@1604H0a`460<L14MNBgm7GT]OAci;GdLnBem7?T]OAci;GdLnBelDOol0
0`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`03Ool01000Oomoo`0017oo000<Ool00`00Bci7
7P02Bah02D/nAai;7TLNBai77T/NAai;7P08Aah01DKnAai6oTLNA_h00d;n00@004;n@_i2oPPngP@j
_P05=Ydj_SJn>[h^O@02<Wd01c:N;WdbOBiM;Wd^GBim00<R?@8N70057QdN71Gl5O`Io0034K/00`VJ
2GX5F@021ET00`4H0=L0eP0209DZOol2000010@0300@00`00a@10a`300<L14MOAgl01d]O00E;?d/n
Bcm;?T/o01Eoo`03001oogoo00=oo`03001oogoo00Qoo`03001oogoo00Eoo`03001oogoo009oo`00
2goo01X007ooAai;?dLNBcm77T/oAai;?dLNBcm77T/oAai;7dLNBam77T/OAai77dKnAai2oTLO0TKn
02Q2oTKo@_h004;nA_lngT;N?]i2oSkN@]hngT;n>[dj_SZm>]hj_CZn>[dfWS:M=YhbWC:N;WdbWRim
<Yh^OBYM9UdZOR8l8SdR?2Hm6Q`N7@8Io00?5M/Io0fk4M/9NPVJ2GX5F@Di0AP0m`3G0;H0U@1e02Io
o`<0000J100@00`0400D0AP1504H0AP370@H0a`4Aei;OdLnBem7?T]OAci;GdLnBem7?T]OAci;GaMo
o`03001oogoo009oo`03001oogoo00Uoo`03001oogoo009oo`8000Eoo`002goo00D004/NBai;7T/n
009;7P06Aai;7TLNBai77T/N0dLN00=;7TLNAah00TLN00A6oTLNAai77P96oP0@@_i6oT;nA_h004Kn
?]i2oT;N@_hngT;n@]hngSZn?]h5>[h01SJn=Yhf_S:N=YhbW@8bWP05=YhZOBYn:WdZOP039Ud38Sd0
0ahL7QdN70025O`01QWl5M`A^`Uj2IX9NP85F@030AP0eP3G0080UB=oo`@00003600D01`2008L0P05
80@P1B0490DT1P0290L00bP7Aem;G`02Bel02T/nBem;Gd]OBci;?d/nBcm;?T/o67oo00<007ooOol0
0Woo00<007ooOol01goo00@007ooOol000=oo`03001oogoo00Aoo`002Woo02L004LNBcm77T/oAai;
?dLNBcm77T/oAai;?dLNBam77T/OAai;7dLNAam6oTLOA_i77dKnAai2oTLO@_i77T;n0012gT;n?]i2
oSkN@_h013kN02`j_CkN>[hngSZm=[hfWCJn=Ydf_SJM=YhbWCJN;WdbWRYM;WhZOBin:UdZORIM8SdR
?2Hm8S`N7AWl3M`9f`gL2M/5^`Uj2IX9NPEI1CT1602f0=L0M@2E87oo0P@001h<0100300H01@0708L
0A`280@T1B0490DT1RP790HX1dMNBem7?T]OAci;GdLnBem7?T/oAci;GdLnBclHOol20003Ool2000:
Ool20004Ool30004Ool000Uoo`05001ood/NBai;?P04Bah014LNBai77T/N0dLN00=;7TLNAah024LN
00=6oTLN@_h00TKn00=77P00@_h01D;n1ckN0SZn00Df_SZn=[hf_SJN00<f_PD^WP05:WhZOBYn:WdZ
OP029Ud46Sd01Q7l4Q`9f`gL2M/5V`<1F@<160030=H0e`2E01eoo`800007100@00`0300D01P05000
0a`200DP120580@T1B@6008T1`07:0LT1T]OBcm;Gd/nBel00T/o00E;?T/oBci;?d/n01]oo`03001o
ogoo01Yoo`002Goo02/004/oAai;?dLNBcm77T/oAai;?dLNBcm77T/OAai;?dLNBam77T/oAai77dKn
Bam77TLO@_i77d;nAai2oTLO@_h004;N@_m2gT;n?]i2oSkN@_hj_P03?]h06SZn?]hj_SZn=[djgSJn
>[hf_C:n<Yhb_S:M<Yh^OC:N;WdbWRIm9WhROBJN7UdRGQXl7Sd26Sd02AXl5QdAo0gL2M/=g0FJ0EX1
F@020AP0103F0;H0e`1e6Woo0P00020400`0400<01P0500H01@0708L0A`280@T1B0490DT1RP790HX
1b@6Bem7?T]OAci;GdLnBem7?T/oAci;GdLn77oo00<007ooOol06Woo0008Ool01000Bai;7T/n0d/N
00U;?TLNBai;7T/nAai;7TLNBah00dLN00=;7TLNAah014LN00Q6oTLNA_i77TKnAai2oP001D;n1ckN
00Lj_S[N>[hjgSZn>]hf_P02>[h3=[h00c:N<[hbWP02<Yh4:Yh49Wh00b9N7UdJ?@046Sd01A8L5Qd9
f`WL1IX00`5I00<1603F0=H00P2E5Woo0`0000D@01@0700L01P0008P0@03808P0A`2008L0P0580@P
1B0490DT1P0290L03BP790I;?d/oBem;?T/oBci;?d/nBcm;?T/o01eoo`8001aoo`001goo02@004/o
Aai;?dLNBcm77T/oAai;?dLNBcm77T/oAai;?dLNBam77T/oAai;7dKnBam77T/O@_i77d;nAai2oTLO
@_i6oP00A_l2@_h02T;N@_lngT;n?]i2oSkN@_hj_SkO0S[N018j_SkN>[hjgSZn=[hb_SJn<Yhf_S:n
=[h^WS:o;Yh^_RYn;Yh2:Yh05R9m9YhVOBIn7UdROPhl4Ud>?19M1O/:70Gk0M/5VPFk0ET1NP4H0=H0
E02F4goo02D000P0200801@0400L01P0700P0B@2804T0R01:0@T12P5:0H/9bP6;2LT1RP790HX1b@6
Bem7?T]OAci;?dLnBcm7?T/oAci;?`0OOol00`00Oomoo`0JOol000Moo`08001;7T/nBai;?T/NBci7
7P9;7P09Bci77T/NAai;7TLNBai77T/N00Q77P04A_i77TLNAah3@_h00`00@_i2oP02@_h043kN@_hn
gT;n?]i2oS[N?]hjgSkN>]hngS[N?]hf_S[N1SJn0S:n00D^WRjn;[h^_RjN00@ZWP048YhNWR:N7Yh2
6Wd01A9M4SdB?A8m2Q`00PHL00P1N@6I0CL1=`4H0=H0M02E47oo0`P000@D0100500@00<L00<P0@03
808T12P4008X100:;0H/9R`6;2L/:30X;2PX1b@690L2Bcl01d/nBcm;?T/oBci;?d/n025oo`03001o
ogoo01Yoo`001Woo02l004LNBcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/OAai;?dLNBam77T/O
Aai;7d;nAam6oTLO@_i77dKnAai2oTLO0016oT;nAalngT;n?]i2ockN@_hjgSko008ngP06>[hngc[N
?]hf_S[O0S[N02Df_S[O=[hjgRjn<]lb_S:o;[hb_bjN;[h^WS:o9YhV_bJN9[lNOR:N7WdRWQin8YhF
GAYn3S`BG@Gk2Q`5n`6I0GP1=`4H07@0E00:Ool3000010@0500@01@011`001lH01`0600T0R01908P
0B@290@X12@4:0DT12`W:0H/9bP6<2P/:319;2P`:4LnBem7?T/oAci;?dLnBcm7?P0ROol00`00Oomo
o`0JOol000Eoo`08001ood/nBai;?T/NBci77P9;7P03Bci77T/N009;7P04Aai;7TLNBah=Aah01dKn
@_i6oT;n0012oTKn00I2oP03?]hnoSkN00DngPLjgP8fgP03=]lf_S:n00@b_P03:[hZ_bZn008Z_P03
:[lZ_RZn008V_PDJ_@054Y`BO1:M4W`BW0021U/01@5i0CL1=`1d038017oo0`000PP000D@01@0400D
010000@L00@T0006;08X0R`2;08X12@40bP400`T12`V;0H/9b`6<2P/:30X;2P`:4/nBcl3Bch00d/o
Bci;?P0TOol00`00Oomoo`0JOol000Aoo`0W001ood/oAai;?dLNBcm77T/oAai;?dLNBcm77T/oAai;
?dLNBcm77T/OAai;7dLNBam77TLOA_i77dKnAam6oTLO@_i77d;nAal004;o00=2oP0h@_m2oT;n?]i2
ockN@_hngT;o?]hnoc[N?_ljgSko>]hnocKN>]lfgS[o<[hfgc:n=]lb_S;O;[hbgbkN<]l^_S;O;]hZ
obKN:_lVgR;N7[dRgR:n8]hN_AZn6Yd:VPYi3YX:N@ZJ2WT>VP4F07@0<P<<00PH00<L00DT000L:08/
0RP2;08X0S0U<0@`9B@4:0DT12`W:0H/9bP6<2P/:319;2P`:4LnBcm;?T/oAai;?d/nBclTOol30002
Ool50002Ool20004Ool2000:Ool000Aoo`06001;?T/NBci;7T/n0d/N00=;?TLNBah00T/N00A77T/N
Aai;7P=77P03Bai77TLN00Q77P06A_i77T;nAai6oP0024;n0Skn00HngSkn?]hnoSkN?_h3>]h01CkN
>]hjgc[N>]l00cKN00Hjgc;N<]lbgc;o<]h2<]l00c;o;_h^o`02;_l03Bkn;_l^ob[o9]hNoAkM7_dN
gAkm7]dNoAkM00<Nn`057aXS6R<J07@0<P0;9005;003;0801BP2;08/0S0U<0@00S0500d`9C04;2H/
1R`W;0H`:2`X<2P/:30XBci;?`03Bch00d/oBcioo`0WOol00`00Oomoo`02Ool00`00Oomoo`07Ool0
1000Oomoo`002Goo0003Ool0J`00Bcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm77T/oAai;?dLNBam7
7T/oAai;7dLNBam77TLOA_i;7dLNAam2oTLO@_i77d;nAal004LO@_i77d;nAalngT;o?]i2ockN@_ln
gSko>]hnoc[N?_ljgSko>]hjocKN>_ljgS[o=]hfocKN=_lbgSKo=]hfobkn<alboS<O;_hc7c;n<alZ
oRlO:ah_7R[n;al[7RLM9a`W?BLL9adW6b/l9c/[?2LK=gdcG@1d>00/02@0:00T02P090001b`00S@1
01/`0B`2:08/0R`4<2D`130U;0@`9C04=2L`9R`W:0H/9b`X<4T/:30X;2Q;?d/nBcm77T/oBch0:Goo
00<007ooOol00Woo00<007ooOol02Woo1@001Goo0003Ool01@00Bai;?T/NBch00d/N00=;?T/NBah0
0T/N00A77T/NBai;7P=77P03Bai77TLN00Y77P08A_i77TLNAai2oP00@_i77PQ2oP<noP0:?_lnoSkn
?_hnoc[n>_ljoSko>_h3>_l01CKo>_ljoc[o=_l00cLO00dfocLO=alg7cKo<alc7S<o<ahc7c<N<cl[
?@02;cd00bln:cd_G@02;ed01Blm;edgGCMm<ed00SMM00<0<P1A>0000SP01C002C@100<`1C0U<0@0
0S0500<`9C@W=2L013@W00H/:30X;2P`:2`XBcl3Bch00d/oOomoo`0XOol20004Ool00`00Oomoo`08
Ool30002Ool00`00Oomoo`04Ool000=oo`1Q001;?dLNBcm77T/oAai;?dLNBcm77T/oAai;?dLNBcm7
7T/OAai;?dLNBam77T/OAai;7dKnBam77TLO@_i77dKnAam2oTLO@_i77`00Aam2oTLO@_i37d;n@_ln
oT;o?_i2ockn@_lngSko?]hnoc[n?_ljgSko>]hnoc[n?aljoS[o=_hjocKn>alfoc/O=_lk7cKo=clc
7SLo<ahg?c<N=clc7S=O<chcGRln<elcGCMN<edgGS=M>ghgGC]n=ed00S]n00DoOcmn0380DDP000<h
0004?00h03`0>003=0406C01=04d0C`S>2<l9304<2D/130U=2Hd9c0V=4Ld9S@W=4PhJB`X<2P/:4/o
Bci;?dLN02eoo`03001oogoo009oo`03001oogoo00Qoo`03001oo`00009oo`03001oogoo00Aoo`00
0goo00<007ooOol01goo00];?TLNBai;7T/nAai;7TLNBai77T/N00i77P03@_i77TKn00@000E2oP0>
?_i2oSkn@_lnoT;n?_hnockn?_lnoSko?_hno`Ljo`8g7`0D>alg7cLO=alk?cLo>clg?c/o=clk?cLn
=elg?SLo=chkGSMN>ehgGP8kGP08?ghkOSmn>ei3Ocmn@gloOP93O`030380DD@000940006>00l03`0
?00h03`02CPS1c@W00HhJ3QY=6PhJCQXBcl3Bch]Ool20003Ool2000:Ool300000goo00000006Ool0
00=oo`03001oogoo00aoo`0KBcm77T/oAai;?dLNBcm77T/OAai;7dLNAam6oTLOA_i77dKnAam2oTLO
@_h004;nAam2oTLO00H0000B?_i37ckn@alnoT<O?_i37ckn@alnoSlO>_ho7c[n?aljoSlO1c/O024k
?cLO>clg7c/o=chkGcLn>elg?S]O=choOc]N?elkGSmo?ehoOcmN@gloGT=o?ei3Od=NAgm3GTMo@ei<
@3`0B0000T@001a084@P@214840PA20h8c`S>2<l93PS?2<lAD1V?4Dd9c0V=4Ld9SQY=4PhJCA8>6Td
B4/oBai;?c1oo`03001oogoo01Uoo`000goo00<007ooOol04Woo34LN00Q6oTLNAah004KnAai2oT<N
0d;n00A37T;n@_i2oPH00004@_lnoT<O?_h3?al02Skn?alo7clO>alo7c/O?alk7clO1c/o010kGc/o
?elk?c]O>ehoGc]N>elkGSmo?ehoOcmn?gm3OP=3O`0:@gi7OdMoAgm3GdMoAem8@3`0D402A0001T0P
A21084@P@21480<h8`06?4HlACa6?4DlASa50S@W00LhJCQX>6TdJ3QY>6Q;?`02BchaOol00`00Oomo
o`0IOol000=oo`03001oogoo01Moo`0LA_i;7dLNAam6oT/OA_i77d;n0016oTLO@_i77d;nAam2oTLO
@_i37d;n@am2oT<O@_i37ckn@al6000013kn?alnoSlo0clO04<o?clO?clk7clo>clo?c/O?clk?cmO
>cloGc/o?elkGSmo?ehoGcmN@gloGT=o?ei7Od=NAgm3GTMoAem7Od=OAgm7Gd]OAei;OdMNC40l0510
C21@@40PA21084@P@21483a5@6HlAD1V?4E0ISa5@6HlACQY=4PhJCA8>6TdB3QYBai;?`0aOol2000K
Ool000=oo`03001oogoo01aoo`A77P0E00177TLNAai2oTLN@_i77T;n@ai2oT<O@_i37T;n@am2oT<O
@_i37d;n008o7`03@alo7P0000D00003?alo?clo00Do?`04?elo?cmO?cl4?el01D=O?em3Gd=O@gl0
0d=O00E7Od=OAem3GdMo00M7G`04Bem7GdMOAel2B4000e10C41@@006B6803Sa5?4HlACa6?4DlASa5
@8Q0QcQY=6PhJCQX>6T2BchcOol00`00Oomoo`0IOol000=oo`03001oogoo01moo`0P001ood;nAam2
oTLO@_i77d;nAam2oTLO@_i77d;n@am2oT<O@_i37clN@alnoT<O?ai37ckn@clo7T<o?ai3?`H0000k
?cm3Gclo@elo?d=O?em3Gclo@eloGdMO@em7Od=OAem3GdMo@em7Od=OAgm7GdMoAem7OdMNBem7GT]O
Aei;GdLnBem7?Ta0B21HX4`PD418@DQRB498HTQ1B698@T1V?4E0IT27@8Q0Id28@8M0R3A8>6U;7P0e
Ool00`00Oomoo`0IOol0009oo`03001oogoo01moo`03001oogoo00Eoo`05@_i37T<NAam2oP02@ah0
1T<O@_i37d<N@am37P=37`05@ai37d<O@clo7`02@al01T<o?cm3?clo@clo?`93?`L000Q3G`e7G`0:
Bem7Gd]OBcm;GdLnBem;?dQ0E802E:000e10B698HP05B6802T28@8M0R427@8Q0Qd28@8M0R4/n=Woo
00<007ooOol06Goo0002Ool00`00Oomoo`0NOol00`00Oomoo`0:Ool08TLO@_i77d;nAam2oTLO@ai3
7clN@am37T<O@ai3?d<N@cm37T<o?cm3?clO@clo?d<o?cm3Gclo@elo?dMO@cm3Gd<o1P0000=7Gd=O
Ael00TMO02M3Gd]OAei;GdLnBem7?T]OAci;GdLnBem7?T]OAci;GdLnBem7?Ta0E81HX5B0F:1<Q52U
C8A<YDb4D:E<Q428@6M0R427@8Q0Id28Bah0=goo00<007ooOol06Goo0002Ool00`00Oomoo`0MOol0
0`00Oomoo`0@Ool00d<O@ai37`02@al014<N@am37d<o0d<O24<o00E3Gd<o@cm3GdMO00=3G`M7G`H0
00=7G`06Bem7?d]OAem;GdLo0T/o00Y;GdLnBcm;?T/oBci;?d/nF:1DP09DX00=F:1<Y4bUC:A<YDbT
C:E0Qd28@8M0R427@8P0>7oo00<007oo00000Woo1@000Woo0P001Goo00<007ooOol00Woo0P000goo
0002Ool00`00Oomoo`0LOol00`00Oomoo`0FOol07T<o@ai7?d<N@cm37TLo@ci3?d<NAcm3?TMO@cm7
Gd<oAem3?dMO@cm7Gd<oAem3GdMO@cm7Gd=OAem7?`97G`04Bem7?T]OAch6000074]OAci;GdLnBem7
?T/oAci;GdLnBcm7?T/oAciHX5B0F:1DP5RPC8A@YDb4C:E<Q52U@8M0R41W>goo0P0017oo00<007oo
Ool02Goo00D007ooOomoo`00009oo`40005oo`5oo`000Woo00<007ooOol06goo00<007ooOol077oo
00Y7?d<o@cm3?dLo@cm7?d<oAcm3?`97?`04Aem3?dMOAcl<Ael02D]OAcm7GdMOBem7?T]OAcm;G`06
00002d/nBcm;?T/oBci;?d/nBcm;?T/oE8000UBP00Q<YDbTC:E<Y4bUC:A0R427?Goo00<007ooOol0
0Woo00<007ooOol02Goo00<007ooOol017oo0@000Goo0Goo0002Ool00`00Oomoo`0JOol00`00Oomo
o`0ROol09TLo@ci7Gd<nAem3?dMO@cm7Gd<oAem7?TMOAci7GdLnAem7?T]OAci;GdLnBem7?T]OAci;
GdLnBem7?T]OAci;GdLnBem7?T/oAch600003T/oAai;?d/NBcm77T/oBai<YDb4D:E<Q4bUC8@mOol2
0004Ool00`00Oomoo`0:Ool01000Oomoogoo0P000goo0002Ool00`00Oomoo`0JOol00`00Oomoo`0[
Ool00dMOAcm7G`02Ael02TLoAem7GdMOAci;GdLoBem7?T]O0T/o0117?T/oBcm;?d/nBcm;?T/oBci;
?d/nBcm;?T/oBci;?`9;?PL0009;?P03Bcm;7T/n041oo`03001oogoo009oo`03001oogoo00Moo`04
001oogoo0003Ool00`00Oomoo`02Ool0009oo`03001oogoo01Uoo`03001oogoo03Yoo`0LAci;GdLn
Bem7?T]OAci;?dLnBem7?T/oAci;?dLnBcm77T/oAci;?dLNBcm;7T/oAai;?d/NBcl6000oOol01000
Oomoogoo0P002Goo10000goo0`000Woo0002Ool00`00Oomoo`0HOol00`00Oomoo`14Ool014/nBcm;
?T/o0d/n00E;?d/nBci;?T/o00=;?P06Bcm;7T/nBci;?d/N17oo1P00>7oo0P006Woo0002Ool00`00
Oomoo`0GOol00`00Oomoo`1>Ool02dLNBcm;7T/oAai;?d/NBcm77T/oBah02goo1P00<goo00<007oo
Ool067oo0002Ool00`00Oomoo`0FOol00`00Oomoo`1COol01T/oBai;?T/nBcl0019oo`H002eoo`03
001oogoo01Qoo`000Woo00<007ooOol05Goo00<007ooOol0FGoo00<007ooOol05Woo1P009goo00<0
07ooOol067oo0002Ool00`00Oomoo`0DOol00`00Oomoo`1JOol00`00Oomoo`0LOol7000POol00`00
Oomoo`0HOol0009oo`03001oogoo01=oo`03001oogoo05]oo`03001oogoo02=oo`H001Yoo`8001Uo
o`000Woo00<007ooOol04goo00<007ooOol0Fgoo00<007ooOol0:Goo1P005Goo00<007ooOol05goo
0002Ool00`00Oomoo`0BOol00`00Oomoo`1LOol00`00Oomoo`0_Ool6000?Ool00`00Oomoo`0GOol0
0003Ool007oo01=oo`03001oogoo05eoo`03001oogoo03Eoo`H000Moo`<0009oo`@001=oo`0000=o
o`00Ool04Woo00<007ooOol0GWoo00<007ooOol0>goo1P000goo00@007ooOol001Ioo`0000=oo`00
Ool04Goo00<007ooOol0Ggoo00<007ooOol0@Goo10000goo00<007ooOol04goo00000goo001oo`0@
Ool00`00Oomoo`1POol00`00Oomoo`12Ool20005Ool00`00Oomoo`0BOol00003Ool007oo00moo`03
001oogoo065oo`03001oogoo03ioo`04001oo`000005Ool01000Oomoo`004goo00000goo001oo`0>
Ool00`00Oomoo`1ROol00`00Oomoo`0nOol20008Ool2000DOol00003Ool007oo00ioo`03001oogoo
069oo`03001oogoo03aoo`80021oo`0000=oo`00Ool03Goo00<007ooOol0Hgoo00<007ooOol0>7oo
00@007oo0000029oo`0000=oo`00Ool037oo00<007ooOol0I7oo00<007ooOol0>7oo0P002Goo0P00
6Goo00000goo001oo`0;Ool00`00Oomoo`1UOol00`00Oomoo`0fOol2000:Ool01000Oomoo`0067oo
00000goo001oo`0:Ool00`00Oomoo`1VOol00`00Oomoo`0cOol3000<Ool01000Oomoo`0067oo0000
0goo001oo`09Ool00`00Oomoo`1WOol00`00Oomoo`0cOol00`00Oomoo`0<Ool01000Oomoo`0067oo
00000goo001oo`08Ool00`00Oomoo`1XOol00`00Oomoo`0aOol2000?Ool01000Oomoo`0067oo0000
0goo001oo`07Ool00`00Oomoo`1YOol00`00Oomoo`0^Ool3000BOol2000IOol00003Ool007oo00Mo
o`03001oogoo06Uoo`03001oogoo02eoo`8002moo`0000=oo`00Ool01Woo00<007ooOol0JWoo00<0
07ooOol0:7oo00<007ooOol00P00<Goo00000goo001oo`05Ool00`00Oomoo`1/Ool00`00Oomoo`0W
Ool3000cOol00003001oogoo00Aoo`03001oogoo06eoo`03001oogoo02Ioo`8003Eoo`0000<007oo
Ool00goo00<007ooOol0KWoo00<007ooOol08goo0`00=goo00000`00Oomoo`02Ool00`00Oomoo`1_
Ool00`00Oomoo`0ROol2000iOol00005001oogooOol0001bOol00`00Oomoo`0NOol01000Oomoo`00
>goo00001000Oomoo`00Lgoo00<007ooOol07Woo0`00?7oo00001000Oomoo`00Lgoo00<007ooOol0
7Goo0P00?Woo00000`00Ool0001dOol00`00Oomoo`0IOol01000Ool000002Goo1@00<Woo0002001e
Ool00`00Oomoo`0IOol2000=Ool00`00Oomoo`0bOol000D0079oo`03001oogoo01Eoo`04001oo`00
000?Ool00`00Oomoo`0bOol000Eoo`P006Yoo`03001oogoo01Eoo`80015oo`03001oogoo039oo`00
3Goo2@00HGoo00<007ooOol047oo00<007ooOol00P004goo00<007ooOol0<Woo000FOol8001IOol0
0`00Oomoo`0@Ool3000DOol2000dOol001ioo`T0051oo`03001oogoo00moo`8004aoo`009goo2000
B7oo00<007ooOol037oo00<007oo0000CWoo000_Ool9000oOol00`00Oomoo`0<Ool2001?Ool003Qo
o`P003Moo`03001oogoo00Qoo`04001oo`00001AOol0041oo`T002ioo`03001oogoo00Qoo`8005=o
o`00BGoo20009Woo00<007ooOol017oo00@007oo000005Eoo`00DGoo2@007Goo00<007ooOol017oo
0P002Goo1000BWoo001JOol8000EOol01@00Oomoo`00Ool00P002goo00<007ooOol0Bgoo001ROol9
000<Ool00`00Oomoo`02000>Ool00`00Oomoo`1:Ool006]oo`P000Aoo`<0015oo`03001oogoo04Uo
o`00Lgoo1@004Goo00@007ooOol004Yoo`00RWoo0P00Bgoo003GOol00=Moo`00UGoo0P00@7oo002D
Ool01000Oomoo`00?goo001fOol2000LOol00`00Oomoo`10Ool007Eoo`04001oogoo000JOol5000o
Ool007Moo`03001oogoo01Yoo`03001oogoo041oo`00N7oo00<007ooOol0G7oo001eOol01000Oomo
o`00GWoo001fOol2001OOol00=Moo`00egoo003GOol00=Moo`00egoo003GOol00=Moo`00egoo003G
Ool00=Moo`00egoo003GOol00=Moo`00\
\>"],
  ImageRangeCache->{{{0, 214.625}, {172.438, 0}} -> {0.0683112, 0.0261975, \
0.00492025, 0.00492025}}]
}, Open  ]],

Cell[TextData[{
  "We clearly observe that the solution represents a decaying solution in  \
time. The initial shape of a Gaussian in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " decreases in time but does not change its shape. The examination of the \
FP equation demonstrated that the non-classical method can be combined with \
the classical method. The results for the non-classical symmetries of the FP \
equation are, however, too complicated for ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " to carry out the final stage of the solution procedure."
}], "Text",
  CellTags->"combination of non-classical and classical method"],

Cell["\<\
Up to now, we discussed local symmetries of a given equation. In \
the following chapter, we will describe the derivation of non-local \
symmetries. We will show that the Fr\[EAcute]chet derivative is a useful tool \
for determining this type of symmetry.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet65.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{666, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->364,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Non-classical Symmetries of Partial Differential Equations", 
            FontSlant -> "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Introduction", 
                "Mathematical Background of the Non-classical Method", 
                "Applications of the Non-classical Method"}, #]&)], FontSlant -> 
            "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Non-classical method"->{
    Cell[1739, 51, 385, 7, 94, "ChapterLine",
      Evaluatable->False,
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Non-classical method"]},
  "Introduction"->{
    Cell[2560, 73, 332, 9, 43, "Section",
      CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Introduction"]},
  "non-classical method"->{
    Cell[2895, 84, 817, 16, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "symmetry analysis", "Lie's classical method"}],
    
    Cell[3715, 102, 1284, 37, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "diffusion equation", "heat equation", 
        "weak symmetries"}],
    Cell[10922, 327, 432, 10, 44, "Text",
      Evaluatable->False,
      CellTags->{"classical method", "non-classical method"}],
    Cell[14637, 425, 535, 12, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation formulation", "Fr\[EAcute]chet formalism", 
        "non-classical method"}],
    Cell[18220, 523, 1330, 27, 146, "Text",
      Evaluatable->False,
      CellTags->{"non-classical method", "side condition"}],
    Cell[23431, 674, 1080, 22, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear determining equations", "classical method", 
        "non-classical method", "non-classical symmetries"}]},
  "symmetry analysis"->{
    Cell[2895, 84, 817, 16, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "symmetry analysis", 
        "Lie's classical method"}]},
  "Lie's classical method"->{
    Cell[2895, 84, 817, 16, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "symmetry analysis", 
        "Lie's classical method"}]},
  "diffusion equation"->{
    Cell[3715, 102, 1284, 37, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "diffusion equation", "heat equation", 
        "weak symmetries"}]},
  "heat equation"->{
    Cell[3715, 102, 1284, 37, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "diffusion equation", "heat equation", 
        "weak symmetries"}],
    Cell[24723, 709, 1183, 29, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "heat equation", "Boussinesq equation", "Burgers equation", 
        "Fitzhugh Nagumo equation"}],
    Cell[26012, 745, 331, 9, 44, "Text",
      Evaluatable->False,
      CellTags->"heat equation"],
    Cell[44570, 1292, 979, 28, 95, "Text",
      Evaluatable->False,
      CellTags->"heat equation"],
    Cell[207002, 5755, 545, 18, 61, "Text",
      CellTags->"heat equation"]},
  "weak symmetries"->{
    Cell[3715, 102, 1284, 37, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical method", "diffusion equation", "heat equation", 
        "weak symmetries"}]},
  "Definition: Symmetry of a PDE"->{
    Cell[5002, 141, 96, 1, 33, "Definition",
      CellTags->"Definition: Symmetry of a PDE"]},
  "local transformation"->{
    Cell[5101, 144, 283, 8, 27, "Text",
      Evaluatable->False,
      CellTags->"local transformation"]},
  "weak symmetry"->{
    Cell[5995, 175, 853, 18, 95, "Text",
      Evaluatable->False,
      CellTags->"weak symmetry"],
    Cell[11357, 339, 816, 17, 95, "Text",
      Evaluatable->False,
      CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}]},
  "Mathematical background of the non-classical method"->{
    Cell[6885, 198, 242, 8, 43, "Section",
      Evaluatable->False,
      CellTags->"Mathematical background of the non-classical method"]},
  "invariant surface condition"->{
    Cell[7381, 219, 524, 13, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant surface condition", "point transformation", 
        "characteristic equations"}],
    Cell[12176, 358, 598, 18, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant solution", "invariant surface condition", 
        "characteristic equation"}]},
  "point transformation"->{
    Cell[7381, 219, 524, 13, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant surface condition", "point transformation", 
        "characteristic equations"}]},
  "characteristic equations"->{
    Cell[7381, 219, 524, 13, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant surface condition", "point transformation", 
        "characteristic equations"}],
    Cell[28770, 836, 2354, 65, 211, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "classical method"->{
    Cell[10922, 327, 432, 10, 44, "Text",
      Evaluatable->False,
      CellTags->{"classical method", "non-classical method"}],
    Cell[23431, 674, 1080, 22, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear determining equations", "classical method", 
        "non-classical method", "non-classical symmetries"}]},
  "Lie algebra"->{
    Cell[11357, 339, 816, 17, 95, "Text",
      Evaluatable->False,
      CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}]},
  "similarity solutions"->{
    Cell[11357, 339, 816, 17, 95, "Text",
      Evaluatable->False,
      CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}]},
  "invariant solution"->{
    Cell[12176, 358, 598, 18, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant solution", "invariant surface condition", 
        "characteristic equation"}]},
  "characteristic equation"->{
    Cell[12176, 358, 598, 18, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "invariant solution", "invariant surface condition", 
        "characteristic equation"}],
    Cell[19553, 552, 336, 8, 44, "Text",
      Evaluatable->False,
      CellTags->"characteristic equation"]},
  "characteristics"->{
    Cell[13615, 404, 1019, 19, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}]},
  "Lie's method"->{
    Cell[13615, 404, 1019, 19, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}]},
  "nonlinear system of determining equations"->{
    Cell[13615, 404, 1019, 19, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}]},
  "determining equations"->{
    Cell[13615, 404, 1019, 19, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}],
    Cell[18057, 516, 160, 5, 20, "ListItem",
      CellTags->"determining equations"]},
  "infinitesimals"->{
    Cell[13615, 404, 1019, 19, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}],
    Cell[32958, 949, 837, 18, 99, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear coupled system of partial differential equations", 
        "non-classical symmetries", "infinitesimals"}],
    Cell[37669, 1081, 643, 15, 78, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals"],
    Cell[169160, 4448, 500, 13, 61, "Text",
      CellTags->"infinitesimals"],
    Cell[216660, 6032, 1161, 36, 78, "Text",
      CellTags->"infinitesimals"],
    Cell[236406, 6638, 949, 17, 129, "Text",
      CellTags->{
      "reduction of the FP-equation", "infinitesimals", "invariants"}]},
  "nonlinear determining equations"->{
    Cell[13615, 404, 1019, 19, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "characteristics", "Lie's method", 
        "nonlinear system of determining equations", "determining equations", 
        "infinitesimals", "nonlinear determining equations"}],
    Cell[23431, 674, 1080, 22, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear determining equations", "classical method", 
        "non-classical method", "non-classical symmetries"}],
    Cell[35558, 1020, 1000, 21, 129, "Text",
      Evaluatable->False,
      CellTags->"nonlinear determining equations"]},
  "prolongation formulation"->{
    Cell[14637, 425, 535, 12, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation formulation", "Fr\[EAcute]chet formalism", 
        "non-classical method"}]},
  "Fr\[EAcute]chet formalism"->{
    Cell[14637, 425, 535, 12, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation formulation", "Fr\[EAcute]chet formalism", 
        "non-classical method"}]},
  "invariance condition"->{
    Cell[15380, 446, 388, 11, 27, "Text",
      Evaluatable->False,
      CellTags->{"invariance condition", "Fr\[EAcute]chet derivative"}]},
  "Fr\[EAcute]chet derivative"->{
    Cell[15380, 446, 388, 11, 27, "Text",
      Evaluatable->False,
      CellTags->{"invariance condition", "Fr\[EAcute]chet derivative"}]},
  "algorithm for the non-classical method"->{
    Cell[16443, 477, 1179, 24, 129, "Text",
      Evaluatable->False,
      CellTags->"algorithm for the non-classical method"]},
  "non-classical algorithm"->{
    Cell[17625, 503, 274, 7, 20, "ListItem",
      CellTags->{"non-classical algorithm", "prolongation"}]},
  "prolongation"->{
    Cell[17625, 503, 274, 7, 20, "ListItem",
      CellTags->{"non-classical algorithm", "prolongation"}]},
  "side conditions"->{
    Cell[17902, 512, 152, 2, 20, "ListItem",
      CellTags->{"side conditions", "prolongation formula"}]},
  "prolongation formula"->{
    Cell[17902, 512, 152, 2, 20, "ListItem",
      CellTags->{"side conditions", "prolongation formula"}]},
  "side condition"->{
    Cell[18220, 523, 1330, 27, 146, "Text",
      Evaluatable->False,
      CellTags->{"non-classical method", "side condition"}]},
  "formal coordinate transformation"->{
    Cell[20506, 584, 712, 22, 61, "Text",
      Evaluatable->False,
      CellTags->"formal coordinate transformation"]},
  "redundant information"->{
    Cell[21781, 626, 745, 19, 78, "Text",
      Evaluatable->False,
      CellTags->"redundant information"]},
  "non-classical symmetries"->{
    Cell[23431, 674, 1080, 22, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear determining equations", "classical method", 
        "non-classical method", "non-classical symmetries"}],
    Cell[32958, 949, 837, 18, 99, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear coupled system of partial differential equations", 
        "non-classical symmetries", "infinitesimals"}],
    Cell[244109, 6878, 584, 13, 63, "Text",
      CellTags->{
      "non-classical symmetries", "PDESolve[]", "pure function"}]},
  "Applications of the non-classical method"->{
    Cell[24548, 701, 172, 6, 43, "Section",
      CellTags->"Applications of the non-classical method"]},
  "Boussinesq equation"->{
    Cell[24723, 709, 1183, 29, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "heat equation", "Boussinesq equation", "Burgers equation", 
        "Fitzhugh Nagumo equation"}],
    Cell[146334, 3793, 201, 7, 27, "Text",
      CellTags->"Boussinesq equation"]},
  "Burgers equation"->{
    Cell[24723, 709, 1183, 29, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "heat equation", "Boussinesq equation", "Burgers equation", 
        "Fitzhugh Nagumo equation"}]},
  "Fitzhugh Nagumo equation"->{
    Cell[24723, 709, 1183, 29, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "heat equation", "Boussinesq equation", "Burgers equation", 
        "Fitzhugh Nagumo equation"}]},
  "The heat equation"->{
    Cell[25931, 742, 78, 1, 41, "Subsection",
      CellTags->"The heat equation"]},
  "temperature"->{
    Cell[26495, 762, 1049, 25, 114, "Text",
      Evaluatable->False,
      CellTags->{
      "temperature", "non-classical method and heat equation", "Lie[]"}]},
  "non-classical method and heat equation"->{
    Cell[26495, 762, 1049, 25, 114, "Text",
      Evaluatable->False,
      CellTags->{
      "temperature", "non-classical method and heat equation", "Lie[]"}]},
  "Lie[]"->{
    Cell[26495, 762, 1049, 25, 114, "Text",
      Evaluatable->False,
      CellTags->{
      "temperature", "non-classical method and heat equation", "Lie[]"}],
    Cell[36739, 1048, 216, 7, 29, "Text",
      Evaluatable->False,
      CellTags->"Lie[]"]},
  "LieEquations[]"->{
    Cell[27997, 809, 390, 11, 46, "Text",
      Evaluatable->False,
      CellTags->"LieEquations[]"]},
  "non-classical symmetry method"->{
    Cell[28770, 836, 2354, 65, 211, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "NonclassicalSymmetries"->{
    Cell[28770, 836, 2354, 65, 211, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "NonclassicalCases"->{
    Cell[28770, 836, 2354, 65, 211, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "non-classical symmetry analysis"->{
    Cell[28770, 836, 2354, 65, 211, "Text",
      Evaluatable->False,
      CellTags->{
      "non-classical symmetry method", "NonclassicalSymmetries", 
        "NonclassicalCases", "characteristic equations", 
        "non-classical symmetry analysis"}]},
  "nonlinear coupled system of partial differential equations"->{
    Cell[32958, 949, 837, 18, 99, "Text",
      Evaluatable->False,
      CellTags->{
      "nonlinear coupled system of partial differential equations", 
        "non-classical symmetries", "infinitesimals"}]},
  "Save[]"->{
    Cell[34010, 976, 584, 14, 65, "Text",
      Evaluatable->False,
      CellTags->"Save[]"]},
  "non-classical group"->{
    Cell[39659, 1147, 976, 22, 129, "Text",
      Evaluatable->False,
      CellTags->{"non-classical group", "Lie's point symmetry procedure"}]},
  "Lie's point symmetry procedure"->{
    Cell[39659, 1147, 976, 22, 129, "Text",
      Evaluatable->False,
      CellTags->{"non-classical group", "Lie's point symmetry procedure"}]},
  "reduction of the non-classical determining equations"->{
    Cell[46066, 1337, 224, 5, 44, "Text",
      CellTags->"reduction of the non-classical determining equations"]},
  "similarity representation of the nonlinear determining equations"->{
    Cell[47207, 1372, 435, 12, 44, "Text",
      CellTags->
      "similarity representation of the nonlinear determining equations"]},
  "DSolve[]"->{
    Cell[48351, 1409, 335, 11, 46, "Text",
      CellTags->"DSolve[]"],
    Cell[229023, 6413, 192, 7, 29, "Text",
      CellTags->"DSolve[]"],
    Cell[248745, 7028, 136, 4, 29, "Text",
      CellTags->"DSolve[]"]},
  "solution of the non-classical determining equations"->{
    Cell[49333, 1450, 356, 12, 44, "Text",
      CellTags->"solution of the non-classical determining equations"]},
  "pure function"->{
    Cell[50173, 1479, 188, 5, 44, "Text",
      CellTags->"pure function"],
    Cell[244109, 6878, 584, 13, 63, "Text",
      CellTags->{
      "non-classical symmetries", "PDESolve[]", "pure function"}]},
  "non-classical infinitesimals"->{
    Cell[51572, 1534, 142, 4, 27, "Text",
      CellTags->"non-classical infinitesimals"],
    Cell[238942, 6707, 827, 27, 63, "Text",
      CellTags->"non-classical infinitesimals"]},
  "similarity representation"->{
    Cell[53280, 1591, 387, 9, 63, "Text",
      CellTags->"similarity representation"],
    Cell[174200, 4599, 408, 11, 44, "Text",
      CellTags->"similarity representation"]},
  "find non-classical solutions"->{
    Cell[145617, 3770, 587, 15, 78, "Text",
      CellTags->"find non-classical solutions"]},
  "The Boussinesq equation"->{
    Cell[146241, 3790, 90, 1, 41, "Subsection",
      CellTags->"The Boussinesq equation"]},
  "surface wave"->{
    Cell[146686, 3807, 1345, 28, 129, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}]},
  "plasma physics"->{
    Cell[146686, 3807, 1345, 28, 129, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}]},
  "point symmetries of the Boussinesq equation"->{
    Cell[146686, 3807, 1345, 28, 129, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}],
    Cell[148721, 3863, 126, 1, 27, "Text",
      CellTags->"point symmetries of the Boussinesq equation"]},
  "direct method"->{
    Cell[146686, 3807, 1345, 28, 129, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}]},
  "pseudo automatic calculation of non-classical symmetries"->{
    Cell[146686, 3807, 1345, 28, 129, "Text",
      CellTags->{
      "surface wave", "plasma physics", 
        "point symmetries of the Boussinesq equation", "direct method", 
        "pseudo automatic calculation of non-classical symmetries"}]},
  "NonClassicalPointSymmetries[]"->{
    Cell[149638, 3896, 950, 23, 101, "Text",
      CellTags->"NonClassicalPointSymmetries[]"],
    Cell[200010, 5547, 1091, 22, 133, "Text",
      CellTags->{
      "numerical solution", "similarity transformation", 
        "NonClassicalPointSymmetries[]", "PDESolve[]"}]},
  "PDESolve[]"->{
    Cell[157816, 4100, 587, 13, 82, "Text",
      CellTags->{"PDESolve[]", "solution branches"}],
    Cell[164054, 4277, 1088, 36, 63, "Text",
      CellTags->"PDESolve[]"],
    Cell[200010, 5547, 1091, 22, 133, "Text",
      CellTags->{
      "numerical solution", "similarity transformation", 
        "NonClassicalPointSymmetries[]", "PDESolve[]"}],
    Cell[211933, 5894, 908, 27, 99, "Text",
      CellTags->"PDESolve[]"],
    Cell[241264, 6782, 602, 21, 48, "Text",
      CellTags->"PDESolve[]"],
    Cell[244109, 6878, 584, 13, 63, "Text",
      CellTags->{
      "non-classical symmetries", "PDESolve[]", "pure function"}]},
  "solution branches"->{
    Cell[157816, 4100, 587, 13, 82, "Text",
      CellTags->{"PDESolve[]", "solution branches"}]},
  "LieReduction[]"->{
    Cell[172015, 4543, 259, 5, 46, "Text",
      CellTags->{"LieReduction[]", "reduction of the Boussinesq equation"}],
    Cell[224760, 6285, 833, 18, 101, "Text",
      CellTags->{
      "point symmetries of the non-classical determining equations", 
        "LieReduction[]"}]},
  "reduction of the Boussinesq equation"->{
    Cell[172015, 4543, 259, 5, 46, "Text",
      CellTags->{"LieReduction[]", "reduction of the Boussinesq equation"}]},
  "first integral"->{
    Cell[175502, 4638, 188, 3, 44, "Text",
      CellTags->"first integral"]},
  "quadratures"->{
    Cell[176688, 4672, 712, 20, 78, "Text",
      CellTags->"quadratures"]},
  "numerical integration"->{
    Cell[177918, 4716, 510, 7, 78, "Text",
      CellTags->{"numerical integration", "similarity variable"}]},
  "similarity variable"->{
    Cell[177918, 4716, 510, 7, 78, "Text",
      CellTags->{"numerical integration", "similarity variable"}]},
  "numerical solution"->{
    Cell[200010, 5547, 1091, 22, 133, "Text",
      CellTags->{
      "numerical solution", "similarity transformation", 
        "NonClassicalPointSymmetries[]", "PDESolve[]"}]},
  "similarity transformation"->{
    Cell[200010, 5547, 1091, 22, 133, "Text",
      CellTags->{
      "numerical solution", "similarity transformation", 
        "NonClassicalPointSymmetries[]", "PDESolve[]"}]},
  "The Fokker-Planck equation"->{
    Cell[201138, 5574, 96, 1, 41, "Subsection",
      CellTags->"The Fokker-Planck equation"]},
  "Fokker-Planck"->{
    Cell[201237, 5577, 728, 14, 78, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "Fokker-Planck equation"->{
    Cell[201237, 5577, 728, 14, 78, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "statistical phenomena"->{
    Cell[201237, 5577, 728, 14, 78, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "condensed matter physics"->{
    Cell[201237, 5577, 728, 14, 78, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "quantum optics"->{
    Cell[201237, 5577, 728, 14, 78, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "chemical physics"->{
    Cell[201237, 5577, 728, 14, 78, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "fluctuations"->{
    Cell[201237, 5577, 728, 14, 78, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "FP-equation"->{
    Cell[201237, 5577, 728, 14, 78, "Text",
      CellTags->{
      "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
        "condensed matter physics", "quantum optics", "chemical physics", 
        "fluctuations", "FP-equation"}]},
  "Brownian particle in a liquid"->{
    Cell[202113, 5598, 1067, 32, 78, "Text",
      CellTags->{
      "Brownian particle in a liquid", "diffusion coefficient", 
        "drift coefficient"}]},
  "diffusion coefficient"->{
    Cell[202113, 5598, 1067, 32, 78, "Text",
      CellTags->{
      "Brownian particle in a liquid", "diffusion coefficient", 
        "drift coefficient"}]},
  "drift coefficient"->{
    Cell[202113, 5598, 1067, 32, 78, "Text",
      CellTags->{
      "Brownian particle in a liquid", "diffusion coefficient", 
        "drift coefficient"}]},
  "point symmetries"->{
    Cell[203656, 5650, 89, 1, 27, "Text",
      CellTags->"point symmetries"]},
  "non-classical determining equations"->{
    Cell[210573, 5854, 234, 6, 27, "Text",
      CellTags->"non-classical determining equations"]},
  "point symmetries of the non-classical determining equations"->{
    Cell[224760, 6285, 833, 18, 101, "Text",
      CellTags->{
      "point symmetries of the non-classical determining equations", 
        "LieReduction[]"}]},
  "similarity function"->{
    Cell[227957, 6375, 376, 13, 44, "Text",
      CellTags->"similarity function"]},
  "special function"->{
    Cell[230292, 6451, 866, 30, 48, "Text",
      CellTags->{"special function", "Erfi[]"}]},
  "Erfi[]"->{
    Cell[230292, 6451, 866, 30, 48, "Text",
      CellTags->{"special function", "Erfi[]"}]},
  "non-classical symmetry transformations of the FP-equation"->{
    Cell[232624, 6527, 270, 5, 44, "Text",
      CellTags->
      "non-classical symmetry transformations of the FP-equation"]},
  "reduction of the FP-equation"->{
    Cell[236406, 6638, 949, 17, 129, "Text",
      CellTags->{
      "reduction of the FP-equation", "infinitesimals", "invariants"}]},
  "invariants"->{
    Cell[236406, 6638, 949, 17, 129, "Text",
      CellTags->{
      "reduction of the FP-equation", "infinitesimals", "invariants"}]},
  "initial conditions"->{
    Cell[249696, 7068, 600, 18, 61, "Text",
      CellTags->{
      "initial conditions", "non-classical solution of the FP-equation"}]},
  "non-classical solution of the FP-equation"->{
    Cell[249696, 7068, 600, 18, 61, "Text",
      CellTags->{
      "initial conditions", "non-classical solution of the FP-equation"}]},
  "combination of non-classical and classical method"->{
    Cell[327266, 9083, 651, 13, 78, "Text",
      CellTags->"combination of non-classical and classical method"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Non-classical method", 330353, 9167},
  {"Introduction", 330726, 9175},
  {"non-classical method", 331069, 9182},
  {"symmetry analysis", 332106, 9209},
  {"Lie's classical method", 332309, 9215},
  {"diffusion equation", 332508, 9221},
  {"heat equation", 332715, 9227},
  {"weak symmetries", 333399, 9246},
  {"Definition: Symmetry of a PDE", 333622, 9252},
  {"local transformation", 333746, 9255},
  {"weak symmetry", 333875, 9259},
  {"Mathematical background of the non-classical method", 334179, 9266},
  {"invariant surface condition", 334356, 9270},
  {"point transformation", 334753, 9281},
  {"characteristic equations", 334971, 9287},
  {"classical method", 335438, 9299},
  {"Lie algebra", 335801, 9308},
  {"similarity solutions", 335973, 9312},
  {"invariant solution", 336143, 9316},
  {"characteristic equation", 336358, 9322},
  {"characteristics", 336676, 9331},
  {"Lie's method", 336969, 9338},
  {"nonlinear system of determining equations", 337291, 9345},
  {"determining equations", 337593, 9352},
  {"infinitesimals", 337975, 9361},
  {"nonlinear determining equations", 338896, 9383},
  {"prolongation formulation", 339536, 9398},
  {"Fr\[EAcute]chet formalism", 339754, 9404},
  {"invariance condition", 339967, 9410},
  {"Fr\[EAcute]chet derivative", 340143, 9414},
  {"algorithm for the non-classical method", 340331, 9418},
  {"non-classical algorithm", 340492, 9422},
  {"prolongation", 340620, 9425},
  {"side conditions", 340751, 9428},
  {"prolongation formula", 340887, 9431},
  {"side condition", 341017, 9434},
  {"formal coordinate transformation", 341189, 9438},
  {"redundant information", 341340, 9442},
  {"non-classical symmetries", 341483, 9446},
  {"Applications of the non-classical method", 342084, 9460},
  {"Boussinesq equation", 342217, 9463},
  {"Burgers equation", 342518, 9471},
  {"Fitzhugh Nagumo equation", 342744, 9477},
  {"The heat equation", 342963, 9483},
  {"temperature", 343067, 9486},
  {"non-classical method and heat equation", 343276, 9491},
  {"Lie[]", 343452, 9496},
  {"LieEquations[]", 343731, 9504},
  {"non-classical symmetry method", 343872, 9508},
  {"NonclassicalSymmetries", 344160, 9515},
  {"NonclassicalCases", 344443, 9522},
  {"non-classical symmetry analysis", 344740, 9529},
  {"nonlinear coupled system of partial differential equations", 345064, \
9536},
  {"Save[]", 345290, 9542},
  {"non-classical group", 345413, 9546},
  {"Lie's point symmetry procedure", 345598, 9550},
  {"reduction of the non-classical determining equations", 345805, 9554},
  {"similarity representation of the nonlinear determining equations", \
345993, 9557},
  {"DSolve[]", 346145, 9561},
  {"solution of the non-classical determining equations", 346421, 9568},
  {"pure function", 346558, 9571},
  {"non-classical infinitesimals", 346800, 9577},
  {"similarity representation", 347018, 9582},
  {"find non-classical solutions", 347233, 9587},
  {"The Boussinesq equation", 347358, 9590},
  {"surface wave", 347471, 9593},
  {"plasma physics", 347742, 9599},
  {"point symmetries of the Boussinesq equation", 348042, 9605},
  {"direct method", 348419, 9613},
  {"pseudo automatic calculation of non-classical symmetries", 348732, 9619},
  {"NonClassicalPointSymmetries[]", 349018, 9625},
  {"PDESolve[]", 349311, 9632},
  {"solution branches", 349969, 9648},
  {"LieReduction[]", 350090, 9651},
  {"reduction of the Boussinesq equation", 350416, 9658},
  {"first integral", 350559, 9661},
  {"quadratures", 350657, 9664},
  {"numerical integration", 350763, 9667},
  {"similarity variable", 350901, 9670},
  {"numerical solution", 351038, 9673},
  {"similarity transformation", 351251, 9678},
  {"The Fokker-Planck equation", 351465, 9683},
  {"Fokker-Planck", 351582, 9686},
  {"Fokker-Planck equation", 351866, 9692},
  {"statistical phenomena", 352149, 9698},
  {"condensed matter physics", 352435, 9704},
  {"quantum optics", 352711, 9710},
  {"chemical physics", 352989, 9716},
  {"fluctuations", 353263, 9722},
  {"FP-equation", 353536, 9728},
  {"Brownian particle in a liquid", 353827, 9734},
  {"diffusion coefficient", 354016, 9739},
  {"drift coefficient", 354201, 9744},
  {"point symmetries", 354385, 9749},
  {"non-classical determining equations", 354508, 9752},
  {"point symmetries of the non-classical determining equations", 354675, \
9755},
  {"similarity function", 354864, 9760},
  {"special function", 354973, 9763},
  {"Erfi[]", 355081, 9766},
  {"non-classical symmetry transformations of the FP-equation", 355240, \
9769},
  {"reduction of the FP-equation", 355405, 9773},
  {"invariants", 355559, 9777},
  {"initial conditions", 355721, 9781},
  {"non-classical solution of the FP-equation", 355908, 9785},
  {"combination of non-classical and classical method", 356103, 9789}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 385, 7, 94, "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Non-classical method"],
Cell[2127, 60, 408, 9, 184, "Title",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],

Cell[CellGroupData[{
Cell[2560, 73, 332, 9, 43, "Section",
  CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],
Cell[2895, 84, 817, 16, 95, "Text",
  Evaluatable->False,
  CellTags->{
  "non-classical method", "symmetry analysis", "Lie's classical method"}],
Cell[3715, 102, 1284, 37, 95, "Text",
  Evaluatable->False,
  CellTags->{
  "non-classical method", "diffusion equation", "heat equation", 
    "weak symmetries"}],
Cell[5002, 141, 96, 1, 33, "Definition",
  CellTags->"Definition: Symmetry of a PDE"],
Cell[5101, 144, 283, 8, 27, "Text",
  Evaluatable->False,
  CellTags->"local transformation"],
Cell[5387, 154, 277, 8, 20, "ListItem",
  Evaluatable->False],
Cell[5667, 164, 325, 9, 20, "ListItem",
  Evaluatable->False],
Cell[5995, 175, 853, 18, 95, "Text",
  Evaluatable->False,
  CellTags->"weak symmetry"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6885, 198, 242, 8, 43, "Section",
  Evaluatable->False,
  CellTags->"Mathematical background of the non-classical method"],
Cell[7130, 208, 143, 5, 27, "Text",
  Evaluatable->False],
Cell[7276, 215, 102, 2, 23, "NumberedEquation"],
Cell[7381, 219, 524, 13, 61, "Text",
  Evaluatable->False,
  CellTags->{
  "invariant surface condition", "point transformation", 
    "characteristic equations"}],
Cell[7908, 234, 1289, 34, 39, "NumberedEquation"],
Cell[9200, 270, 266, 8, 27, "Text",
  Evaluatable->False],
Cell[9469, 280, 291, 6, 39, "NumberedEquation"],
Cell[9763, 288, 559, 17, 45, "Text",
  Evaluatable->False],
Cell[10325, 307, 248, 7, 23, "NumberedEquation"],
Cell[10576, 316, 343, 9, 23, "NumberedEquation"],
Cell[10922, 327, 432, 10, 44, "Text",
  Evaluatable->False,
  CellTags->{"classical method", "non-classical method"}],
Cell[11357, 339, 816, 17, 95, "Text",
  Evaluatable->False,
  CellTags->{"weak symmetry", "Lie algebra", "similarity solutions"}],
Cell[12176, 358, 598, 18, 44, "Text",
  Evaluatable->False,
  CellTags->{
  "invariant solution", "invariant surface condition", 
    "characteristic equation"}],
Cell[12777, 378, 218, 4, 22, "NumberedEquation"],
Cell[12998, 384, 171, 5, 27, "Text",
  Evaluatable->False],
Cell[13172, 391, 216, 4, 34, "NumberedEquation"],
Cell[13391, 397, 221, 5, 34, "NumberedEquation"],
Cell[13615, 404, 1019, 19, 112, "Text",
  Evaluatable->False,
  CellTags->{
  "characteristics", "Lie's method", 
    "nonlinear system of determining equations", "determining equations", 
    "infinitesimals", "nonlinear determining equations"}],
Cell[14637, 425, 535, 12, 78, "Text",
  Evaluatable->False,
  CellTags->{
  "prolongation formulation", "Fr\[EAcute]chet formalism", 
    "non-classical method"}],
Cell[15175, 439, 117, 2, 23, "NumberedEquation"],
Cell[15295, 443, 82, 1, 22, "NumberedEquation"],
Cell[15380, 446, 388, 11, 27, "Text",
  Evaluatable->False,
  CellTags->{"invariance condition", "Fr\[EAcute]chet derivative"}],
Cell[15771, 459, 669, 16, 43, "NumberedEquation"],
Cell[16443, 477, 1179, 24, 129, "Text",
  Evaluatable->False,
  CellTags->"algorithm for the non-classical method"],
Cell[17625, 503, 274, 7, 20, "ListItem",
  CellTags->{"non-classical algorithm", "prolongation"}],
Cell[17902, 512, 152, 2, 20, "ListItem",
  CellTags->{"side conditions", "prolongation formula"}],
Cell[18057, 516, 160, 5, 20, "ListItem",
  CellTags->"determining equations"],
Cell[18220, 523, 1330, 27, 146, "Text",
  Evaluatable->False,
  CellTags->{"non-classical method", "side condition"}],
Cell[19553, 552, 336, 8, 44, "Text",
  Evaluatable->False,
  CellTags->"characteristic equation"],
Cell[19892, 562, 177, 4, 22, "NumberedEquation"],
Cell[20072, 568, 259, 7, 44, "Text",
  Evaluatable->False],
Cell[20334, 577, 169, 5, 22, "NumberedEquation",
  Evaluatable->False],
Cell[20506, 584, 712, 22, 61, "Text",
  Evaluatable->False,
  CellTags->"formal coordinate transformation"],
Cell[21221, 608, 113, 2, 22, "NumberedEquation"],
Cell[21337, 612, 208, 5, 23, "NumberedEquation"],
Cell[21548, 619, 230, 5, 22, "NumberedEquation"],
Cell[21781, 626, 745, 19, 78, "Text",
  Evaluatable->False,
  CellTags->"redundant information"],
Cell[22529, 647, 430, 10, 34, "ListItem",
  Evaluatable->False],
Cell[22962, 659, 466, 13, 34, "ListItem",
  Evaluatable->False],
Cell[23431, 674, 1080, 22, 129, "Text",
  Evaluatable->False,
  CellTags->{
  "nonlinear determining equations", "classical method", 
    "non-classical method", "non-classical symmetries"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24548, 701, 172, 6, 43, "Section",
  CellTags->"Applications of the non-classical method"],
Cell[24723, 709, 1183, 29, 112, "Text",
  Evaluatable->False,
  CellTags->{
  "heat equation", "Boussinesq equation", "Burgers equation", 
    "Fitzhugh Nagumo equation"}],

Cell[CellGroupData[{
Cell[25931, 742, 78, 1, 41, "Subsection",
  CellTags->"The heat equation"],
Cell[26012, 745, 331, 9, 44, "Text",
  Evaluatable->False,
  CellTags->"heat equation"],
Cell[26346, 756, 146, 4, 23, "NumberedEquation",
  Evaluatable->False],
Cell[26495, 762, 1049, 25, 114, "Text",
  Evaluatable->False,
  CellTags->{
  "temperature", "non-classical method and heat equation", "Lie[]"}],
Cell[27547, 789, 54, 1, 23, "Input"],

Cell[CellGroupData[{
Cell[27626, 794, 111, 2, 23, "Input"],
Cell[27740, 798, 242, 8, 23, "Output"]
}, Open  ]],
Cell[27997, 809, 390, 11, 46, "Text",
  Evaluatable->False,
  CellTags->"LieEquations[]"],
Cell[28390, 822, 164, 3, 39, "Input"],
Cell[28557, 827, 210, 7, 27, "Text",
  Evaluatable->False],
Cell[28770, 836, 2354, 65, 211, "Text",
  Evaluatable->False,
  CellTags->{
  "non-classical symmetry method", "NonclassicalSymmetries", 
    "NonclassicalCases", "characteristic equations", 
    "non-classical symmetry analysis"}],

Cell[CellGroupData[{
Cell[31149, 905, 182, 3, 39, "Input"],
Cell[31334, 910, 1609, 36, 182, "Output"]
}, Open  ]],
Cell[32958, 949, 837, 18, 99, "Text",
  Evaluatable->False,
  CellTags->{
  "nonlinear coupled system of partial differential equations", 
    "non-classical symmetries", "infinitesimals"}],
Cell[33798, 969, 127, 2, 39, "Input"],
Cell[33928, 973, 79, 1, 23, "Input"],
Cell[34010, 976, 584, 14, 65, "Text",
  Evaluatable->False,
  CellTags->"Save[]"],

Cell[CellGroupData[{
Cell[34619, 994, 177, 3, 39, "Input"],
Cell[34799, 999, 744, 18, 64, "Output"]
}, Open  ]],
Cell[35558, 1020, 1000, 21, 129, "Text",
  Evaluatable->False,
  CellTags->"nonlinear determining equations"],
Cell[36561, 1043, 175, 3, 71, "Input"],
Cell[36739, 1048, 216, 7, 29, "Text",
  Evaluatable->False,
  CellTags->"Lie[]"],

Cell[CellGroupData[{
Cell[36980, 1059, 177, 3, 39, "Input"],
Cell[37160, 1064, 494, 14, 50, "Output"]
}, Open  ]],
Cell[37669, 1081, 643, 15, 78, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],
Cell[38315, 1098, 64, 1, 23, "Input"],
Cell[38382, 1101, 50, 0, 27, "Text"],
Cell[38435, 1103, 85, 1, 23, "Input"],
Cell[38523, 1106, 242, 10, 27, "Text",
  Evaluatable->False],
Cell[38768, 1118, 79, 1, 23, "Input"],
Cell[38850, 1121, 101, 2, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[38976, 1127, 271, 5, 55, "Input"],
Cell[39250, 1134, 394, 10, 46, "Output"]
}, Open  ]],
Cell[39659, 1147, 976, 22, 129, "Text",
  Evaluatable->False,
  CellTags->{"non-classical group", "Lie's point symmetry procedure"}],

Cell[CellGroupData[{
Cell[40660, 1173, 112, 2, 23, "Input"],
Cell[40775, 1177, 221, 5, 52, "Message"],
Cell[40999, 1184, 3556, 105, 154, "Output"]
}, Open  ]],
Cell[44570, 1292, 979, 28, 95, "Text",
  Evaluatable->False,
  CellTags->"heat equation"],

Cell[CellGroupData[{
Cell[45574, 1324, 421, 7, 55, "Input"],
Cell[45998, 1333, 53, 1, 23, "Output"]
}, Open  ]],
Cell[46066, 1337, 224, 5, 44, "Text",
  CellTags->"reduction of the non-classical determining equations"],

Cell[CellGroupData[{
Cell[46315, 1346, 264, 5, 39, "Input"],
Cell[46582, 1353, 610, 16, 98, "Output"]
}, Open  ]],
Cell[47207, 1372, 435, 12, 44, "Text",
  CellTags->
  "similarity representation of the nonlinear determining equations"],

Cell[CellGroupData[{
Cell[47667, 1388, 178, 4, 23, "Input"],
Cell[47848, 1394, 488, 12, 23, "Output"]
}, Open  ]],
Cell[48351, 1409, 335, 11, 46, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[48711, 1424, 119, 3, 23, "Input"],
Cell[48833, 1429, 97, 2, 26, "Output"]
}, Open  ]],
Cell[48945, 1434, 118, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[49088, 1441, 151, 3, 23, "Input"],
Cell[49242, 1446, 76, 1, 26, "Output"]
}, Open  ]],
Cell[49333, 1450, 356, 12, 44, "Text",
  CellTags->"solution of the non-classical determining equations"],

Cell[CellGroupData[{
Cell[49714, 1466, 322, 6, 39, "Input"],
Cell[50039, 1474, 119, 2, 26, "Output"]
}, Open  ]],
Cell[50173, 1479, 188, 5, 44, "Text",
  CellTags->"pure function"],

Cell[CellGroupData[{
Cell[50386, 1488, 212, 4, 47, "Input"],
Cell[50601, 1494, 635, 22, 50, "Output"]
}, Open  ]],
Cell[51251, 1519, 170, 4, 44, "Text"],

Cell[CellGroupData[{
Cell[51446, 1527, 65, 1, 23, "Input"],
Cell[51514, 1530, 43, 1, 23, "Output"]
}, Open  ]],
Cell[51572, 1534, 142, 4, 27, "Text",
  CellTags->"non-classical infinitesimals"],

Cell[CellGroupData[{
Cell[51739, 1542, 86, 1, 23, "Input"],
Cell[51828, 1545, 82, 1, 26, "Output"]
}, Open  ]],
Cell[51925, 1549, 179, 4, 44, "Text"],

Cell[CellGroupData[{
Cell[52129, 1557, 275, 5, 39, "Input"],
Cell[52407, 1564, 180, 3, 37, "Message"],
Cell[52590, 1569, 675, 19, 62, "Output"]
}, Open  ]],
Cell[53280, 1591, 387, 9, 63, "Text",
  CellTags->"similarity representation"],

Cell[CellGroupData[{
Cell[53692, 1604, 602, 14, 23, "Input"],
Cell[54297, 1620, 150, 3, 41, "Output"]
}, Open  ]],
Cell[54462, 1626, 262, 9, 44, "Text"],

Cell[CellGroupData[{
Cell[54749, 1639, 171, 3, 23, "Input"],
Cell[54923, 1644, 144, 3, 36, "Output"]
}, Open  ]],
Cell[55082, 1650, 247, 8, 44, "Text"],

Cell[CellGroupData[{
Cell[55354, 1662, 273, 5, 39, "Input"],
Cell[55630, 1669, 89972, 2098, 213, 54490, 1656, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[145617, 3770, 587, 15, 78, "Text",
  CellTags->"find non-classical solutions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[146241, 3790, 90, 1, 41, "Subsection",
  CellTags->"The Boussinesq equation"],
Cell[146334, 3793, 201, 7, 27, "Text",
  CellTags->"Boussinesq equation"],
Cell[146538, 3802, 145, 3, 23, "NumberedEquation"],
Cell[146686, 3807, 1345, 28, 129, "Text",
  CellTags->{
  "surface wave", "plasma physics", 
    "point symmetries of the Boussinesq equation", "direct method", 
    "pseudo automatic calculation of non-classical symmetries"}],
Cell[148034, 3837, 133, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[148192, 3846, 236, 4, 39, "Input"],
Cell[148431, 3852, 275, 8, 24, "Output"]
}, Open  ]],
Cell[148721, 3863, 126, 1, 27, "Text",
  CellTags->"point symmetries of the Boussinesq equation"],

Cell[CellGroupData[{
Cell[148872, 3868, 129, 2, 23, "Input"],
Cell[149004, 3872, 619, 21, 44, "Output"]
}, Open  ]],
Cell[149638, 3896, 950, 23, 101, "Text",
  CellTags->"NonClassicalPointSymmetries[]"],

Cell[CellGroupData[{
Cell[150613, 3923, 120, 2, 23, "Input"],
Cell[150736, 3927, 3714, 81, 448, "Output"]
}, Open  ]],
Cell[154465, 4011, 773, 21, 78, "Text"],

Cell[CellGroupData[{
Cell[155263, 4036, 232, 5, 55, "Input"],
Cell[155498, 4043, 2303, 54, 216, "Output"]
}, Open  ]],
Cell[157816, 4100, 587, 13, 82, "Text",
  CellTags->{"PDESolve[]", "solution branches"}],

Cell[CellGroupData[{
Cell[158428, 4117, 93, 1, 23, "Input"],
Cell[158524, 4120, 85, 1, 23, "Output"],
Cell[158612, 4123, 78, 1, 23, "Output"],
Cell[158693, 4126, 197, 4, 23, "Output"],
Cell[158893, 4132, 505, 13, 23, "Output"],
Cell[159401, 4147, 85, 1, 23, "Output"],
Cell[159489, 4150, 78, 1, 23, "Output"],
Cell[159570, 4153, 197, 4, 23, "Output"],
Cell[159770, 4159, 505, 13, 23, "Output"],
Cell[160278, 4174, 3761, 100, 92, "Output"]
}, Open  ]],
Cell[164054, 4277, 1088, 36, 63, "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{
Cell[165167, 4317, 124, 2, 23, "Input"],
Cell[165294, 4321, 1917, 57, 92, "Output"]
}, Open  ]],
Cell[167226, 4381, 788, 23, 63, "Text"],

Cell[CellGroupData[{
Cell[168039, 4408, 87, 1, 23, "Input"],
Cell[168129, 4411, 1016, 34, 70, "Output"]
}, Open  ]],
Cell[169160, 4448, 500, 13, 61, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[169685, 4465, 244, 5, 39, "Input"],
Cell[169932, 4472, 1016, 34, 70, "Output"]
}, Open  ]],
Cell[170963, 4509, 737, 21, 78, "Text"],

Cell[CellGroupData[{
Cell[171725, 4534, 183, 3, 23, "Input"],
Cell[171911, 4539, 89, 1, 34, "Output"]
}, Open  ]],
Cell[172015, 4543, 259, 5, 46, "Text",
  CellTags->{"LieReduction[]", "reduction of the Boussinesq equation"}],

Cell[CellGroupData[{
Cell[172299, 4552, 267, 5, 39, "Input"],
Cell[172569, 4559, 1616, 37, 84, "Output"]
}, Open  ]],
Cell[174200, 4599, 408, 11, 44, "Text",
  CellTags->"similarity representation"],

Cell[CellGroupData[{
Cell[174633, 4614, 164, 3, 23, "Input"],
Cell[174800, 4619, 687, 16, 38, "Output"]
}, Open  ]],
Cell[175502, 4638, 188, 3, 44, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[175715, 4645, 155, 3, 33, "Input"],
Cell[175873, 4650, 800, 19, 23, "Output"]
}, Open  ]],
Cell[176688, 4672, 712, 20, 78, "Text",
  CellTags->"quadratures"],

Cell[CellGroupData[{
Cell[177425, 4696, 97, 2, 23, "Input"],
Cell[177525, 4700, 378, 13, 32, "Output"]
}, Open  ]],
Cell[177918, 4716, 510, 7, 78, "Text",
  CellTags->{"numerical integration", "similarity variable"}],

Cell[CellGroupData[{
Cell[178453, 4727, 904, 21, 55, "Input"],
Cell[179360, 4750, 1220, 32, 83, "Output"]
}, Open  ]],
Cell[180595, 4785, 323, 7, 44, "Text"],

Cell[CellGroupData[{
Cell[180943, 4796, 346, 6, 55, "Input"],
Cell[181292, 4804, 18703, 740, 152, 10173, 630, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[200010, 5547, 1091, 22, 133, "Text",
  CellTags->{
  "numerical solution", "similarity transformation", 
    "NonClassicalPointSymmetries[]", "PDESolve[]"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[201138, 5574, 96, 1, 41, "Subsection",
  CellTags->"The Fokker-Planck equation"],
Cell[201237, 5577, 728, 14, 78, "Text",
  CellTags->{
  "Fokker-Planck", "Fokker-Planck equation", "statistical phenomena", 
    "condensed matter physics", "quantum optics", "chemical physics", 
    "fluctuations", "FP-equation"}],
Cell[201968, 5593, 142, 3, 24, "NumberedEquation"],
Cell[202113, 5598, 1067, 32, 78, "Text",
  CellTags->{
  "Brownian particle in a liquid", "diffusion coefficient", 
    "drift coefficient"}],

Cell[CellGroupData[{
Cell[203205, 5634, 181, 3, 23, "Input"],
Cell[203389, 5639, 252, 8, 23, "Output"]
}, Open  ]],
Cell[203656, 5650, 89, 1, 27, "Text",
  CellTags->"point symmetries"],

Cell[CellGroupData[{
Cell[203770, 5655, 115, 2, 23, "Input"],
Cell[203888, 5659, 3099, 93, 100, "Output"]
}, Open  ]],
Cell[207002, 5755, 545, 18, 61, "Text",
  CellTags->"heat equation"],
Cell[207550, 5775, 688, 18, 45, "Text"],

Cell[CellGroupData[{
Cell[208263, 5797, 499, 13, 24, "Input"],
Cell[208765, 5812, 1793, 39, 150, "Output"]
}, Open  ]],
Cell[210573, 5854, 234, 6, 27, "Text",
  CellTags->"non-classical determining equations"],

Cell[CellGroupData[{
Cell[210832, 5864, 223, 5, 55, "Input"],
Cell[211058, 5871, 860, 20, 64, "Output"]
}, Open  ]],
Cell[211933, 5894, 908, 27, 99, "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{
Cell[212866, 5925, 87, 1, 23, "Input"],
Cell[212956, 5928, 85, 1, 23, "Output"],
Cell[213044, 5931, 78, 1, 23, "Output"],
Cell[213125, 5934, 214, 5, 23, "Output"],
Cell[213342, 5941, 214, 5, 23, "Output"],
Cell[213559, 5948, 3086, 81, 74, "Output"]
}, Open  ]],
Cell[216660, 6032, 1161, 36, 78, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[217846, 6072, 191, 4, 23, "Input"],
Cell[218040, 6078, 450, 12, 46, "Output"]
}, Open  ]],
Cell[218505, 6093, 88, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[218618, 6100, 106, 2, 23, "Input"],
Cell[218727, 6104, 219, 5, 37, "Message"],
Cell[218949, 6111, 5796, 171, 140, "Output"]
}, Open  ]],
Cell[224760, 6285, 833, 18, 101, "Text",
  CellTags->{
  "point symmetries of the non-classical determining equations", 
    "LieReduction[]"}],

Cell[CellGroupData[{
Cell[225618, 6307, 469, 8, 55, "Input"],
Cell[226090, 6317, 74, 1, 23, "Output"]
}, Open  ]],
Cell[226179, 6321, 323, 11, 27, "Text"],

Cell[CellGroupData[{
Cell[226527, 6336, 270, 5, 39, "Input"],
Cell[226800, 6343, 179, 3, 38, "Output"],
Cell[226982, 6348, 960, 24, 100, "Output"]
}, Open  ]],
Cell[227957, 6375, 376, 13, 44, "Text",
  CellTags->"similarity function"],

Cell[CellGroupData[{
Cell[228358, 6392, 212, 3, 23, "Input"],
Cell[228573, 6397, 435, 13, 46, "Output"]
}, Open  ]],
Cell[229023, 6413, 192, 7, 29, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[229240, 6424, 765, 17, 39, "Input"],
Cell[230008, 6443, 269, 5, 67, "Output"]
}, Open  ]],
Cell[230292, 6451, 866, 30, 48, "Text",
  CellTags->{"special function", "Erfi[]"}],

Cell[CellGroupData[{
Cell[231183, 6485, 424, 9, 71, "Input"],
Cell[231610, 6496, 659, 13, 146, "Output"]
}, Open  ]],
Cell[232284, 6512, 150, 3, 44, "Text"],

Cell[CellGroupData[{
Cell[232459, 6519, 102, 2, 23, "Input"],
Cell[232564, 6523, 45, 1, 23, "Output"]
}, Open  ]],
Cell[232624, 6527, 270, 5, 44, "Text",
  CellTags->"non-classical symmetry transformations of the FP-equation"],

Cell[CellGroupData[{
Cell[232919, 6536, 416, 8, 55, "Input"],
Cell[233338, 6546, 3053, 89, 98, "Output"]
}, Open  ]],
Cell[236406, 6638, 949, 17, 129, "Text",
  CellTags->{
  "reduction of the FP-equation", "infinitesimals", "invariants"}],
Cell[237358, 6657, 147, 3, 44, "Text"],

Cell[CellGroupData[{
Cell[237530, 6664, 218, 4, 39, "Input"],
Cell[237751, 6670, 1176, 34, 70, "Output"]
}, Open  ]],
Cell[238942, 6707, 827, 27, 63, "Text",
  CellTags->"non-classical infinitesimals"],

Cell[CellGroupData[{
Cell[239794, 6738, 247, 5, 23, "Input"],
Cell[240044, 6745, 1205, 34, 58, "Output"]
}, Open  ]],
Cell[241264, 6782, 602, 21, 48, "Text",
  CellTags->"PDESolve[]"],

Cell[CellGroupData[{
Cell[241891, 6807, 84, 1, 23, "Input"],
Cell[241978, 6810, 2116, 65, 86, "Output"]
}, Open  ]],
Cell[244109, 6878, 584, 13, 63, "Text",
  CellTags->{"non-classical symmetries", "PDESolve[]", "pure function"}],

Cell[CellGroupData[{
Cell[244718, 6895, 262, 5, 39, "Input"],
Cell[244983, 6902, 2116, 65, 86, "Output"]
}, Open  ]],
Cell[247114, 6970, 337, 9, 44, "Text"],

Cell[CellGroupData[{
Cell[247476, 6983, 168, 3, 23, "Input"],
Cell[247647, 6988, 59, 1, 34, "Output"]
}, Open  ]],
Cell[247721, 6992, 115, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[247861, 6999, 263, 5, 39, "Input"],
Cell[248127, 7006, 603, 19, 60, "Output"]
}, Open  ]],
Cell[248745, 7028, 136, 4, 29, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[248906, 7036, 121, 3, 23, "Input"],
Cell[249030, 7041, 84, 1, 23, "Output"]
}, Open  ]],
Cell[249129, 7045, 283, 9, 44, "Text"],

Cell[CellGroupData[{
Cell[249437, 7058, 139, 3, 23, "Input"],
Cell[249579, 7063, 102, 2, 26, "Output"]
}, Open  ]],
Cell[249696, 7068, 600, 18, 61, "Text",
  CellTags->{
  "initial conditions", "non-classical solution of the FP-equation"}],

Cell[CellGroupData[{
Cell[250321, 7090, 333, 6, 55, "Input"],
Cell[250657, 7098, 76594, 1982, 182, 54921, 1710, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[327266, 9083, 651, 13, 78, "Text",
  CellTags->"combination of non-classical and classical method"],
Cell[327920, 9098, 327, 7, 61, "Text",
  Evaluatable->False],
Cell[328250, 9107, 148, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

