@ECHO OFF

echo Current file is "%~f0"

cd /d %~dp0

echo Current directory is "%~dp0"

set jredir=%~dp0..\..\jre1.8.0_144

echo JRE DIR is "%jredir%"

set "JRE_HOME=%jredir%"

for /f %%p in ('powershell -Command "([math]::round((Get-WmiObject -Class Win32_ComputerSystem).TotalPhysicalMemory / 1MB, 0))"') do set total_ram_mb=%%p
echo Total RAM: %total_ram_mb%


set "ram=%total_ram_mb%"
set "limit_8gb=7800"
set "limit_4gb=3850"

if %ram% GEQ %limit_8gb% (
echo RAM is greater than equal to 8GB
set CATALINA_OPTS=-Xms2048m -Xmx2048m
) else (if %ram% GEQ %limit_4gb% (
echo RAM is greater than equal to 4GB but less than 8GB
set CATALINA_OPTS=-Xms1024m -Xmx1024m
) else (
echo RAM is less than 4GB
set CATALINA_OPTS=-Xms512m -Xmx512m
) )

rem You can either use system proxy, or provide proxy settings manually

rem to use system proxy use below line

rem set JAVA_OPTS=-Djava.net.useSystemProxies=true

rem to provide proxy settings manually use this line

rem set JAVA_OPTS=-Dhttp.proxyHost=<Your Proxy Domain URL or IP Address> -Dhttp.proxyPort=<Your Proxy Port>

exit /b 0