/* $NetBSD: syscall.h,v 1.317 2020/06/11 03:45:30 dholland Exp $ */

/*
 * System call numbers.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.305 2020/05/16 18:31:50 christos Exp
 */

#ifndef _SYS_SYSCALL_H_
#define	_SYS_SYSCALL_H_

#define	SYS_MAXSYSARGS	8

/* syscall: "syscall" ret: "int" args: "int" "..." */
#define	SYS_syscall	0

/* syscall: "exit" ret: "void" args: "int" */
#define	SYS_exit	1

/* syscall: "fork" ret: "int" args: */
#define	SYS_fork	2

/* syscall: "read" ret: "ssize_t" args: "int" "void *" "size_t" */
#define	SYS_read	3

/* syscall: "write" ret: "ssize_t" args: "int" "const void *" "size_t" */
#define	SYS_write	4

/* syscall: "open" ret: "int" args: "const char *" "int" "..." */
#define	SYS_open	5

/* syscall: "close" ret: "int" args: "int" */
#define	SYS_close	6

/* syscall: "compat_50_wait4" ret: "int" args: "pid_t" "int *" "int" "struct rusage50 *" */
#define	SYS_compat_50_wait4	7

/* syscall: "compat_43_ocreat" ret: "int" args: "const char *" "mode_t" */
#define	SYS_compat_43_ocreat	8

/* syscall: "link" ret: "int" args: "const char *" "const char *" */
#define	SYS_link	9

/* syscall: "unlink" ret: "int" args: "const char *" */
#define	SYS_unlink	10

				/* 11 is obsolete execv */
/* syscall: "chdir" ret: "int" args: "const char *" */
#define	SYS_chdir	12

/* syscall: "fchdir" ret: "int" args: "int" */
#define	SYS_fchdir	13

/* syscall: "compat_50_mknod" ret: "int" args: "const char *" "mode_t" "uint32_t" */
#define	SYS_compat_50_mknod	14

/* syscall: "chmod" ret: "int" args: "const char *" "mode_t" */
#define	SYS_chmod	15

/* syscall: "chown" ret: "int" args: "const char *" "uid_t" "gid_t" */
#define	SYS_chown	16

/* syscall: "break" ret: "int" args: "char *" */
#define	SYS_break	17

/* syscall: "compat_20_getfsstat" ret: "int" args: "struct statfs12 *" "long" "int" */
#define	SYS_compat_20_getfsstat	18

/* syscall: "compat_43_olseek" ret: "long" args: "int" "long" "int" */
#define	SYS_compat_43_olseek	19

/* syscall: "getpid" ret: "pid_t" args: */
#define	SYS_getpid	20

/* syscall: "compat_40_mount" ret: "int" args: "const char *" "const char *" "int" "void *" */
#define	SYS_compat_40_mount	21

/* syscall: "unmount" ret: "int" args: "const char *" "int" */
#define	SYS_unmount	22

/* syscall: "setuid" ret: "int" args: "uid_t" */
#define	SYS_setuid	23

/* syscall: "getuid" ret: "uid_t" args: */
#define	SYS_getuid	24

/* syscall: "geteuid" ret: "uid_t" args: */
#define	SYS_geteuid	25

/* syscall: "ptrace" ret: "int" args: "int" "pid_t" "void *" "int" */
#define	SYS_ptrace	26

/* syscall: "recvmsg" ret: "ssize_t" args: "int" "struct msghdr *" "int" */
#define	SYS_recvmsg	27

/* syscall: "sendmsg" ret: "ssize_t" args: "int" "const struct msghdr *" "int" */
#define	SYS_sendmsg	28

/* syscall: "recvfrom" ret: "ssize_t" args: "int" "void *" "size_t" "int" "struct sockaddr *" "socklen_t *" */
#define	SYS_recvfrom	29

/* syscall: "accept" ret: "int" args: "int" "struct sockaddr *" "socklen_t *" */
#define	SYS_accept	30

/* syscall: "getpeername" ret: "int" args: "int" "struct sockaddr *" "socklen_t *" */
#define	SYS_getpeername	31

/* syscall: "getsockname" ret: "int" args: "int" "struct sockaddr *" "socklen_t *" */
#define	SYS_getsockname	32

/* syscall: "access" ret: "int" args: "const char *" "int" */
#define	SYS_access	33

/* syscall: "chflags" ret: "int" args: "const char *" "u_long" */
#define	SYS_chflags	34

/* syscall: "fchflags" ret: "int" args: "int" "u_long" */
#define	SYS_fchflags	35

/* syscall: "sync" ret: "void" args: */
#define	SYS_sync	36

/* syscall: "kill" ret: "int" args: "pid_t" "int" */
#define	SYS_kill	37

/* syscall: "compat_43_stat43" ret: "int" args: "const char *" "struct stat43 *" */
#define	SYS_compat_43_stat43	38

/* syscall: "getppid" ret: "pid_t" args: */
#define	SYS_getppid	39

/* syscall: "compat_43_lstat43" ret: "int" args: "const char *" "struct stat43 *" */
#define	SYS_compat_43_lstat43	40

/* syscall: "dup" ret: "int" args: "int" */
#define	SYS_dup	41

/* syscall: "pipe" ret: "int" args: */
#define	SYS_pipe	42

/* syscall: "getegid" ret: "gid_t" args: */
#define	SYS_getegid	43

/* syscall: "profil" ret: "int" args: "char *" "size_t" "u_long" "u_int" */
#define	SYS_profil	44

/* syscall: "ktrace" ret: "int" args: "const char *" "int" "int" "pid_t" */
#define	SYS_ktrace	45

/* syscall: "compat_13_sigaction13" ret: "int" args: "int" "const struct sigaction13 *" "struct sigaction13 *" */
#define	SYS_compat_13_sigaction13	46

/* syscall: "getgid" ret: "gid_t" args: */
#define	SYS_getgid	47

/* syscall: "compat_13_sigprocmask13" ret: "int" args: "int" "int" */
#define	SYS_compat_13_sigprocmask13	48

/* syscall: "__getlogin" ret: "int" args: "char *" "size_t" */
#define	SYS___getlogin	49

/* syscall: "__setlogin" ret: "int" args: "const char *" */
#define	SYS___setlogin	50

/* syscall: "acct" ret: "int" args: "const char *" */
#define	SYS_acct	51

/* syscall: "compat_13_sigpending13" ret: "int" args: */
#define	SYS_compat_13_sigpending13	52

/* syscall: "compat_13_sigaltstack13" ret: "int" args: "const struct sigaltstack13 *" "struct sigaltstack13 *" */
#define	SYS_compat_13_sigaltstack13	53

/* syscall: "ioctl" ret: "int" args: "int" "u_long" "..." */
#define	SYS_ioctl	54

/* syscall: "compat_12_oreboot" ret: "int" args: "int" */
#define	SYS_compat_12_oreboot	55

/* syscall: "revoke" ret: "int" args: "const char *" */
#define	SYS_revoke	56

/* syscall: "symlink" ret: "int" args: "const char *" "const char *" */
#define	SYS_symlink	57

/* syscall: "readlink" ret: "ssize_t" args: "const char *" "char *" "size_t" */
#define	SYS_readlink	58

/* syscall: "execve" ret: "int" args: "const char *" "char *const *" "char *const *" */
#define	SYS_execve	59

/* syscall: "umask" ret: "mode_t" args: "mode_t" */
#define	SYS_umask	60

/* syscall: "chroot" ret: "int" args: "const char *" */
#define	SYS_chroot	61

/* syscall: "compat_43_fstat43" ret: "int" args: "int" "struct stat43 *" */
#define	SYS_compat_43_fstat43	62

/* syscall: "compat_43_ogetkerninfo" ret: "int" args: "int" "char *" "int *" "int" */
#define	SYS_compat_43_ogetkerninfo	63

/* syscall: "compat_43_ogetpagesize" ret: "int" args: */
#define	SYS_compat_43_ogetpagesize	64

/* syscall: "compat_12_msync" ret: "int" args: "void *" "size_t" */
#define	SYS_compat_12_msync	65

/* syscall: "vfork" ret: "int" args: */
#define	SYS_vfork	66

				/* 67 is obsolete vread */
				/* 68 is obsolete vwrite */
				/* 69 is obsolete sbrk */
				/* 70 is obsolete sstk */
/* syscall: "compat_43_ommap" ret: "int" args: "void *" "size_t" "int" "int" "int" "long" */
#define	SYS_compat_43_ommap	71

/* syscall: "vadvise" ret: "int" args: "int" */
#define	SYS_vadvise	72

/* syscall: "munmap" ret: "int" args: "void *" "size_t" */
#define	SYS_munmap	73

/* syscall: "mprotect" ret: "int" args: "void *" "size_t" "int" */
#define	SYS_mprotect	74

/* syscall: "madvise" ret: "int" args: "void *" "size_t" "int" */
#define	SYS_madvise	75

				/* 76 is obsolete vhangup */
				/* 77 is obsolete vlimit */
/* syscall: "mincore" ret: "int" args: "void *" "size_t" "char *" */
#define	SYS_mincore	78

/* syscall: "getgroups" ret: "int" args: "int" "gid_t *" */
#define	SYS_getgroups	79

/* syscall: "setgroups" ret: "int" args: "int" "const gid_t *" */
#define	SYS_setgroups	80

/* syscall: "getpgrp" ret: "int" args: */
#define	SYS_getpgrp	81

/* syscall: "setpgid" ret: "int" args: "pid_t" "pid_t" */
#define	SYS_setpgid	82

/* syscall: "compat_50_setitimer" ret: "int" args: "int" "const struct itimerval50 *" "struct itimerval50 *" */
#define	SYS_compat_50_setitimer	83

/* syscall: "compat_43_owait" ret: "int" args: */
#define	SYS_compat_43_owait	84

/* syscall: "compat_12_oswapon" ret: "int" args: "const char *" */
#define	SYS_compat_12_oswapon	85

/* syscall: "compat_50_getitimer" ret: "int" args: "int" "struct itimerval50 *" */
#define	SYS_compat_50_getitimer	86

/* syscall: "compat_43_ogethostname" ret: "int" args: "char *" "u_int" */
#define	SYS_compat_43_ogethostname	87

/* syscall: "compat_43_osethostname" ret: "int" args: "char *" "u_int" */
#define	SYS_compat_43_osethostname	88

/* syscall: "compat_43_ogetdtablesize" ret: "int" args: */
#define	SYS_compat_43_ogetdtablesize	89

/* syscall: "dup2" ret: "int" args: "int" "int" */
#define	SYS_dup2	90

/* syscall: "fcntl" ret: "int" args: "int" "int" "..." */
#define	SYS_fcntl	92

/* syscall: "compat_50_select" ret: "int" args: "int" "fd_set *" "fd_set *" "fd_set *" "struct timeval50 *" */
#define	SYS_compat_50_select	93

/* syscall: "fsync" ret: "int" args: "int" */
#define	SYS_fsync	95

/* syscall: "setpriority" ret: "int" args: "int" "id_t" "int" */
#define	SYS_setpriority	96

/* syscall: "compat_30_socket" ret: "int" args: "int" "int" "int" */
#define	SYS_compat_30_socket	97

/* syscall: "connect" ret: "int" args: "int" "const struct sockaddr *" "socklen_t" */
#define	SYS_connect	98

/* syscall: "compat_43_oaccept" ret: "int" args: "int" "void *" "socklen_t *" */
#define	SYS_compat_43_oaccept	99

/* syscall: "getpriority" ret: "int" args: "int" "id_t" */
#define	SYS_getpriority	100

/* syscall: "compat_43_osend" ret: "int" args: "int" "void *" "int" "int" */
#define	SYS_compat_43_osend	101

/* syscall: "compat_43_orecv" ret: "int" args: "int" "void *" "int" "int" */
#define	SYS_compat_43_orecv	102

/* syscall: "compat_13_sigreturn13" ret: "int" args: "struct sigcontext13 *" */
#define	SYS_compat_13_sigreturn13	103

/* syscall: "bind" ret: "int" args: "int" "const struct sockaddr *" "socklen_t" */
#define	SYS_bind	104

/* syscall: "setsockopt" ret: "int" args: "int" "int" "int" "const void *" "socklen_t" */
#define	SYS_setsockopt	105

/* syscall: "listen" ret: "int" args: "int" "int" */
#define	SYS_listen	106

				/* 107 is obsolete vtimes */
/* syscall: "compat_43_osigvec" ret: "int" args: "int" "struct sigvec *" "struct sigvec *" */
#define	SYS_compat_43_osigvec	108

/* syscall: "compat_43_osigblock" ret: "int" args: "int" */
#define	SYS_compat_43_osigblock	109

/* syscall: "compat_43_osigsetmask" ret: "int" args: "int" */
#define	SYS_compat_43_osigsetmask	110

/* syscall: "compat_13_sigsuspend13" ret: "int" args: "int" */
#define	SYS_compat_13_sigsuspend13	111

/* syscall: "compat_43_osigstack" ret: "int" args: "struct sigstack *" "struct sigstack *" */
#define	SYS_compat_43_osigstack	112

/* syscall: "compat_43_orecvmsg" ret: "int" args: "int" "struct omsghdr *" "int" */
#define	SYS_compat_43_orecvmsg	113

/* syscall: "compat_43_osendmsg" ret: "int" args: "int" "void *" "int" */
#define	SYS_compat_43_osendmsg	114

				/* 115 is obsolete vtrace */
/* syscall: "compat_50_gettimeofday" ret: "int" args: "struct timeval50 *" "void *" */
#define	SYS_compat_50_gettimeofday	116

/* syscall: "compat_50_getrusage" ret: "int" args: "int" "struct rusage50 *" */
#define	SYS_compat_50_getrusage	117

/* syscall: "getsockopt" ret: "int" args: "int" "int" "int" "void *" "socklen_t *" */
#define	SYS_getsockopt	118

				/* 119 is obsolete resuba */
/* syscall: "readv" ret: "ssize_t" args: "int" "const struct iovec *" "int" */
#define	SYS_readv	120

/* syscall: "writev" ret: "ssize_t" args: "int" "const struct iovec *" "int" */
#define	SYS_writev	121

/* syscall: "compat_50_settimeofday" ret: "int" args: "const struct timeval50 *" "const void *" */
#define	SYS_compat_50_settimeofday	122

/* syscall: "fchown" ret: "int" args: "int" "uid_t" "gid_t" */
#define	SYS_fchown	123

/* syscall: "fchmod" ret: "int" args: "int" "mode_t" */
#define	SYS_fchmod	124

/* syscall: "compat_43_orecvfrom" ret: "int" args: "int" "void *" "size_t" "int" "void *" "socklen_t *" */
#define	SYS_compat_43_orecvfrom	125

/* syscall: "setreuid" ret: "int" args: "uid_t" "uid_t" */
#define	SYS_setreuid	126

/* syscall: "setregid" ret: "int" args: "gid_t" "gid_t" */
#define	SYS_setregid	127

/* syscall: "rename" ret: "int" args: "const char *" "const char *" */
#define	SYS_rename	128

/* syscall: "compat_43_otruncate" ret: "int" args: "const char *" "long" */
#define	SYS_compat_43_otruncate	129

/* syscall: "compat_43_oftruncate" ret: "int" args: "int" "long" */
#define	SYS_compat_43_oftruncate	130

/* syscall: "flock" ret: "int" args: "int" "int" */
#define	SYS_flock	131

/* syscall: "mkfifo" ret: "int" args: "const char *" "mode_t" */
#define	SYS_mkfifo	132

/* syscall: "sendto" ret: "ssize_t" args: "int" "const void *" "size_t" "int" "const struct sockaddr *" "socklen_t" */
#define	SYS_sendto	133

/* syscall: "shutdown" ret: "int" args: "int" "int" */
#define	SYS_shutdown	134

/* syscall: "socketpair" ret: "int" args: "int" "int" "int" "int *" */
#define	SYS_socketpair	135

/* syscall: "mkdir" ret: "int" args: "const char *" "mode_t" */
#define	SYS_mkdir	136

/* syscall: "rmdir" ret: "int" args: "const char *" */
#define	SYS_rmdir	137

/* syscall: "compat_50_utimes" ret: "int" args: "const char *" "const struct timeval50 *" */
#define	SYS_compat_50_utimes	138

				/* 139 is obsolete 4.2 sigreturn */
/* syscall: "compat_50_adjtime" ret: "int" args: "const struct timeval50 *" "struct timeval50 *" */
#define	SYS_compat_50_adjtime	140

/* syscall: "compat_43_ogetpeername" ret: "int" args: "int" "void *" "socklen_t *" */
#define	SYS_compat_43_ogetpeername	141

/* syscall: "compat_43_ogethostid" ret: "int32_t" args: */
#define	SYS_compat_43_ogethostid	142

/* syscall: "compat_43_osethostid" ret: "int" args: "int32_t" */
#define	SYS_compat_43_osethostid	143

/* syscall: "compat_43_ogetrlimit" ret: "int" args: "int" "struct orlimit *" */
#define	SYS_compat_43_ogetrlimit	144

/* syscall: "compat_43_osetrlimit" ret: "int" args: "int" "const struct orlimit *" */
#define	SYS_compat_43_osetrlimit	145

/* syscall: "compat_43_okillpg" ret: "int" args: "int" "int" */
#define	SYS_compat_43_okillpg	146

/* syscall: "setsid" ret: "int" args: */
#define	SYS_setsid	147

/* syscall: "compat_50_quotactl" ret: "int" args: "const char *" "int" "int" "void *" */
#define	SYS_compat_50_quotactl	148

/* syscall: "compat_43_oquota" ret: "int" args: */
#define	SYS_compat_43_oquota	149

/* syscall: "compat_43_ogetsockname" ret: "int" args: "int" "void *" "socklen_t *" */
#define	SYS_compat_43_ogetsockname	150

/* syscall: "nfssvc" ret: "int" args: "int" "void *" */
#define	SYS_nfssvc	155

/* syscall: "compat_43_ogetdirentries" ret: "int" args: "int" "char *" "u_int" "long *" */
#define	SYS_compat_43_ogetdirentries	156

/* syscall: "compat_20_statfs" ret: "int" args: "const char *" "struct statfs12 *" */
#define	SYS_compat_20_statfs	157

/* syscall: "compat_20_fstatfs" ret: "int" args: "int" "struct statfs12 *" */
#define	SYS_compat_20_fstatfs	158

/* syscall: "compat_30_getfh" ret: "int" args: "const char *" "struct compat_30_fhandle *" */
#define	SYS_compat_30_getfh	161

/* syscall: "compat_09_ogetdomainname" ret: "int" args: "char *" "int" */
#define	SYS_compat_09_ogetdomainname	162

/* syscall: "compat_09_osetdomainname" ret: "int" args: "char *" "int" */
#define	SYS_compat_09_osetdomainname	163

/* syscall: "compat_09_ouname" ret: "int" args: "struct outsname *" */
#define	SYS_compat_09_ouname	164

/* syscall: "sysarch" ret: "int" args: "int" "void *" */
#define	SYS_sysarch	165

/* syscall: "__futex" ret: "int" args: "int *" "int" "int" "const struct timespec *" "int *" "int" "int" */
#define	SYS___futex	166

/* syscall: "__futex_set_robust_list" ret: "int" args: "void *" "size_t" */
#define	SYS___futex_set_robust_list	167

/* syscall: "__futex_get_robust_list" ret: "int" args: "lwpid_t" "void **" "size_t *" */
#define	SYS___futex_get_robust_list	168

#if !defined(_LP64)
/* syscall: "compat_10_osemsys" ret: "int" args: "int" "int" "int" "int" "int" */
#define	SYS_compat_10_osemsys	169

#else
				/* 169 is excluded 1.0 semsys */
#endif
#if !defined(_LP64)
/* syscall: "compat_10_omsgsys" ret: "int" args: "int" "int" "int" "int" "int" "int" */
#define	SYS_compat_10_omsgsys	170

#else
				/* 170 is excluded 1.0 msgsys */
#endif
#if !defined(_LP64)
/* syscall: "compat_10_oshmsys" ret: "int" args: "int" "int" "int" "int" */
#define	SYS_compat_10_oshmsys	171

#else
				/* 171 is excluded 1.0 shmsys */
#endif
/* syscall: "pread" ret: "ssize_t" args: "int" "void *" "size_t" "int" "off_t" */
#define	SYS_pread	173

/* syscall: "pwrite" ret: "ssize_t" args: "int" "const void *" "size_t" "int" "off_t" */
#define	SYS_pwrite	174

/* syscall: "compat_30_ntp_gettime" ret: "int" args: "struct ntptimeval30 *" */
#define	SYS_compat_30_ntp_gettime	175

#if defined(NTP) || !defined(_KERNEL_OPT)
/* syscall: "ntp_adjtime" ret: "int" args: "struct timex *" */
#define	SYS_ntp_adjtime	176

#else
				/* 176 is excluded ntp_adjtime */
#endif
/* syscall: "setgid" ret: "int" args: "gid_t" */
#define	SYS_setgid	181

/* syscall: "setegid" ret: "int" args: "gid_t" */
#define	SYS_setegid	182

/* syscall: "seteuid" ret: "int" args: "uid_t" */
#define	SYS_seteuid	183

/* syscall: "lfs_bmapv" ret: "int" args: "fsid_t *" "struct block_info *" "int" */
#define	SYS_lfs_bmapv	184

/* syscall: "lfs_markv" ret: "int" args: "fsid_t *" "struct block_info *" "int" */
#define	SYS_lfs_markv	185

/* syscall: "lfs_segclean" ret: "int" args: "fsid_t *" "u_long" */
#define	SYS_lfs_segclean	186

/* syscall: "compat_50_lfs_segwait" ret: "int" args: "fsid_t *" "struct timeval50 *" */
#define	SYS_compat_50_lfs_segwait	187

/* syscall: "compat_12_stat12" ret: "int" args: "const char *" "struct stat12 *" */
#define	SYS_compat_12_stat12	188

/* syscall: "compat_12_fstat12" ret: "int" args: "int" "struct stat12 *" */
#define	SYS_compat_12_fstat12	189

/* syscall: "compat_12_lstat12" ret: "int" args: "const char *" "struct stat12 *" */
#define	SYS_compat_12_lstat12	190

/* syscall: "pathconf" ret: "long" args: "const char *" "int" */
#define	SYS_pathconf	191

/* syscall: "fpathconf" ret: "long" args: "int" "int" */
#define	SYS_fpathconf	192

/* syscall: "getsockopt2" ret: "int" args: "int" "int" "int" "void *" "socklen_t *" */
#define	SYS_getsockopt2	193

/* syscall: "getrlimit" ret: "int" args: "int" "struct rlimit *" */
#define	SYS_getrlimit	194

/* syscall: "setrlimit" ret: "int" args: "int" "const struct rlimit *" */
#define	SYS_setrlimit	195

/* syscall: "compat_12_getdirentries" ret: "int" args: "int" "char *" "u_int" "long *" */
#define	SYS_compat_12_getdirentries	196

/* syscall: "mmap" ret: "void *" args: "void *" "size_t" "int" "int" "int" "long" "off_t" */
#define	SYS_mmap	197

/* syscall: "__syscall" ret: "quad_t" args: "quad_t" "..." */
#define	SYS___syscall	198

/* syscall: "lseek" ret: "off_t" args: "int" "int" "off_t" "int" */
#define	SYS_lseek	199

/* syscall: "truncate" ret: "int" args: "const char *" "int" "off_t" */
#define	SYS_truncate	200

/* syscall: "ftruncate" ret: "int" args: "int" "int" "off_t" */
#define	SYS_ftruncate	201

/* syscall: "__sysctl" ret: "int" args: "const int *" "u_int" "void *" "size_t *" "const void *" "size_t" */
#define	SYS___sysctl	202

/* syscall: "mlock" ret: "int" args: "const void *" "size_t" */
#define	SYS_mlock	203

/* syscall: "munlock" ret: "int" args: "const void *" "size_t" */
#define	SYS_munlock	204

/* syscall: "undelete" ret: "int" args: "const char *" */
#define	SYS_undelete	205

/* syscall: "compat_50_futimes" ret: "int" args: "int" "const struct timeval50 *" */
#define	SYS_compat_50_futimes	206

/* syscall: "getpgid" ret: "pid_t" args: "pid_t" */
#define	SYS_getpgid	207

/* syscall: "reboot" ret: "int" args: "int" "char *" */
#define	SYS_reboot	208

/* syscall: "poll" ret: "int" args: "struct pollfd *" "u_int" "int" */
#define	SYS_poll	209

/* syscall: "afssys" ret: "int" args: "long" "long" "long" "long" "long" "long" "long" */
#define	SYS_afssys	210

/* syscall: "compat_14___semctl" ret: "int" args: "int" "int" "int" "union __semun *" */
#define	SYS_compat_14___semctl	220

/* syscall: "semget" ret: "int" args: "key_t" "int" "int" */
#define	SYS_semget	221

/* syscall: "semop" ret: "int" args: "int" "struct sembuf *" "size_t" */
#define	SYS_semop	222

/* syscall: "semconfig" ret: "int" args: "int" */
#define	SYS_semconfig	223

/* syscall: "compat_14_msgctl" ret: "int" args: "int" "int" "struct msqid_ds14 *" */
#define	SYS_compat_14_msgctl	224

/* syscall: "msgget" ret: "int" args: "key_t" "int" */
#define	SYS_msgget	225

/* syscall: "msgsnd" ret: "int" args: "int" "const void *" "size_t" "int" */
#define	SYS_msgsnd	226

/* syscall: "msgrcv" ret: "ssize_t" args: "int" "void *" "size_t" "long" "int" */
#define	SYS_msgrcv	227

/* syscall: "shmat" ret: "void *" args: "int" "const void *" "int" */
#define	SYS_shmat	228

/* syscall: "compat_14_shmctl" ret: "int" args: "int" "int" "struct shmid_ds14 *" */
#define	SYS_compat_14_shmctl	229

/* syscall: "shmdt" ret: "int" args: "const void *" */
#define	SYS_shmdt	230

/* syscall: "shmget" ret: "int" args: "key_t" "size_t" "int" */
#define	SYS_shmget	231

/* syscall: "compat_50_clock_gettime" ret: "int" args: "clockid_t" "struct timespec50 *" */
#define	SYS_compat_50_clock_gettime	232

/* syscall: "compat_50_clock_settime" ret: "int" args: "clockid_t" "const struct timespec50 *" */
#define	SYS_compat_50_clock_settime	233

/* syscall: "compat_50_clock_getres" ret: "int" args: "clockid_t" "struct timespec50 *" */
#define	SYS_compat_50_clock_getres	234

/* syscall: "timer_create" ret: "int" args: "clockid_t" "struct sigevent *" "timer_t *" */
#define	SYS_timer_create	235

/* syscall: "timer_delete" ret: "int" args: "timer_t" */
#define	SYS_timer_delete	236

/* syscall: "compat_50_timer_settime" ret: "int" args: "timer_t" "int" "const struct itimerspec50 *" "struct itimerspec50 *" */
#define	SYS_compat_50_timer_settime	237

/* syscall: "compat_50_timer_gettime" ret: "int" args: "timer_t" "struct itimerspec50 *" */
#define	SYS_compat_50_timer_gettime	238

/* syscall: "timer_getoverrun" ret: "int" args: "timer_t" */
#define	SYS_timer_getoverrun	239

/* syscall: "compat_50_nanosleep" ret: "int" args: "const struct timespec50 *" "struct timespec50 *" */
#define	SYS_compat_50_nanosleep	240

/* syscall: "fdatasync" ret: "int" args: "int" */
#define	SYS_fdatasync	241

/* syscall: "mlockall" ret: "int" args: "int" */
#define	SYS_mlockall	242

/* syscall: "munlockall" ret: "int" args: */
#define	SYS_munlockall	243

/* syscall: "compat_50___sigtimedwait" ret: "int" args: "const sigset_t *" "siginfo_t *" "struct timespec50 *" */
#define	SYS_compat_50___sigtimedwait	244

/* syscall: "sigqueueinfo" ret: "int" args: "pid_t" "const siginfo_t *" */
#define	SYS_sigqueueinfo	245

/* syscall: "modctl" ret: "int" args: "int" "void *" */
#define	SYS_modctl	246

/* syscall: "_ksem_init" ret: "int" args: "unsigned int" "intptr_t *" */
#define	SYS__ksem_init	247

/* syscall: "_ksem_open" ret: "int" args: "const char *" "int" "mode_t" "unsigned int" "intptr_t *" */
#define	SYS__ksem_open	248

/* syscall: "_ksem_unlink" ret: "int" args: "const char *" */
#define	SYS__ksem_unlink	249

/* syscall: "_ksem_close" ret: "int" args: "intptr_t" */
#define	SYS__ksem_close	250

/* syscall: "_ksem_post" ret: "int" args: "intptr_t" */
#define	SYS__ksem_post	251

/* syscall: "_ksem_wait" ret: "int" args: "intptr_t" */
#define	SYS__ksem_wait	252

/* syscall: "_ksem_trywait" ret: "int" args: "intptr_t" */
#define	SYS__ksem_trywait	253

/* syscall: "_ksem_getvalue" ret: "int" args: "intptr_t" "unsigned int *" */
#define	SYS__ksem_getvalue	254

/* syscall: "_ksem_destroy" ret: "int" args: "intptr_t" */
#define	SYS__ksem_destroy	255

/* syscall: "_ksem_timedwait" ret: "int" args: "intptr_t" "const struct timespec *" */
#define	SYS__ksem_timedwait	256

/* syscall: "mq_open" ret: "mqd_t" args: "const char *" "int" "mode_t" "struct mq_attr *" */
#define	SYS_mq_open	257

/* syscall: "mq_close" ret: "int" args: "mqd_t" */
#define	SYS_mq_close	258

/* syscall: "mq_unlink" ret: "int" args: "const char *" */
#define	SYS_mq_unlink	259

/* syscall: "mq_getattr" ret: "int" args: "mqd_t" "struct mq_attr *" */
#define	SYS_mq_getattr	260

/* syscall: "mq_setattr" ret: "int" args: "mqd_t" "const struct mq_attr *" "struct mq_attr *" */
#define	SYS_mq_setattr	261

/* syscall: "mq_notify" ret: "int" args: "mqd_t" "const struct sigevent *" */
#define	SYS_mq_notify	262

/* syscall: "mq_send" ret: "int" args: "mqd_t" "const char *" "size_t" "unsigned" */
#define	SYS_mq_send	263

/* syscall: "mq_receive" ret: "ssize_t" args: "mqd_t" "char *" "size_t" "unsigned *" */
#define	SYS_mq_receive	264

/* syscall: "compat_50_mq_timedsend" ret: "int" args: "mqd_t" "const char *" "size_t" "unsigned" "const struct timespec50 *" */
#define	SYS_compat_50_mq_timedsend	265

/* syscall: "compat_50_mq_timedreceive" ret: "ssize_t" args: "mqd_t" "char *" "size_t" "unsigned *" "const struct timespec50 *" */
#define	SYS_compat_50_mq_timedreceive	266

/* syscall: "__posix_rename" ret: "int" args: "const char *" "const char *" */
#define	SYS___posix_rename	270

/* syscall: "swapctl" ret: "int" args: "int" "void *" "int" */
#define	SYS_swapctl	271

/* syscall: "compat_30_getdents" ret: "int" args: "int" "char *" "size_t" */
#define	SYS_compat_30_getdents	272

/* syscall: "minherit" ret: "int" args: "void *" "size_t" "int" */
#define	SYS_minherit	273

/* syscall: "lchmod" ret: "int" args: "const char *" "mode_t" */
#define	SYS_lchmod	274

/* syscall: "lchown" ret: "int" args: "const char *" "uid_t" "gid_t" */
#define	SYS_lchown	275

/* syscall: "compat_50_lutimes" ret: "int" args: "const char *" "const struct timeval50 *" */
#define	SYS_compat_50_lutimes	276

/* syscall: "__msync13" ret: "int" args: "void *" "size_t" "int" */
#define	SYS___msync13	277

/* syscall: "compat_30___stat13" ret: "int" args: "const char *" "struct stat13 *" */
#define	SYS_compat_30___stat13	278

/* syscall: "compat_30___fstat13" ret: "int" args: "int" "struct stat13 *" */
#define	SYS_compat_30___fstat13	279

/* syscall: "compat_30___lstat13" ret: "int" args: "const char *" "struct stat13 *" */
#define	SYS_compat_30___lstat13	280

/* syscall: "__sigaltstack14" ret: "int" args: "const struct sigaltstack *" "struct sigaltstack *" */
#define	SYS___sigaltstack14	281

/* syscall: "__vfork14" ret: "int" args: */
#define	SYS___vfork14	282

/* syscall: "__posix_chown" ret: "int" args: "const char *" "uid_t" "gid_t" */
#define	SYS___posix_chown	283

/* syscall: "__posix_fchown" ret: "int" args: "int" "uid_t" "gid_t" */
#define	SYS___posix_fchown	284

/* syscall: "__posix_lchown" ret: "int" args: "const char *" "uid_t" "gid_t" */
#define	SYS___posix_lchown	285

/* syscall: "getsid" ret: "pid_t" args: "pid_t" */
#define	SYS_getsid	286

/* syscall: "__clone" ret: "pid_t" args: "int" "void *" */
#define	SYS___clone	287

/* syscall: "fktrace" ret: "int" args: "int" "int" "int" "pid_t" */
#define	SYS_fktrace	288

/* syscall: "preadv" ret: "ssize_t" args: "int" "const struct iovec *" "int" "int" "off_t" */
#define	SYS_preadv	289

/* syscall: "pwritev" ret: "ssize_t" args: "int" "const struct iovec *" "int" "int" "off_t" */
#define	SYS_pwritev	290

/* syscall: "compat_16___sigaction14" ret: "int" args: "int" "const struct sigaction *" "struct sigaction *" */
#define	SYS_compat_16___sigaction14	291

/* syscall: "__sigpending14" ret: "int" args: "sigset_t *" */
#define	SYS___sigpending14	292

/* syscall: "__sigprocmask14" ret: "int" args: "int" "const sigset_t *" "sigset_t *" */
#define	SYS___sigprocmask14	293

/* syscall: "__sigsuspend14" ret: "int" args: "const sigset_t *" */
#define	SYS___sigsuspend14	294

/* syscall: "compat_16___sigreturn14" ret: "int" args: "struct sigcontext *" */
#define	SYS_compat_16___sigreturn14	295

/* syscall: "__getcwd" ret: "int" args: "char *" "size_t" */
#define	SYS___getcwd	296

/* syscall: "fchroot" ret: "int" args: "int" */
#define	SYS_fchroot	297

/* syscall: "compat_30_fhopen" ret: "int" args: "const struct compat_30_fhandle *" "int" */
#define	SYS_compat_30_fhopen	298

/* syscall: "compat_30_fhstat" ret: "int" args: "const struct compat_30_fhandle *" "struct stat13 *" */
#define	SYS_compat_30_fhstat	299

/* syscall: "compat_20_fhstatfs" ret: "int" args: "const struct compat_30_fhandle *" "struct statfs12 *" */
#define	SYS_compat_20_fhstatfs	300

/* syscall: "compat_50_____semctl13" ret: "int" args: "int" "int" "int" "..." */
#define	SYS_compat_50_____semctl13	301

/* syscall: "compat_50___msgctl13" ret: "int" args: "int" "int" "struct msqid_ds *" */
#define	SYS_compat_50___msgctl13	302

/* syscall: "compat_50___shmctl13" ret: "int" args: "int" "int" "struct shmid_ds13 *" */
#define	SYS_compat_50___shmctl13	303

/* syscall: "lchflags" ret: "int" args: "const char *" "u_long" */
#define	SYS_lchflags	304

/* syscall: "issetugid" ret: "int" args: */
#define	SYS_issetugid	305

/* syscall: "utrace" ret: "int" args: "const char *" "void *" "size_t" */
#define	SYS_utrace	306

/* syscall: "getcontext" ret: "int" args: "struct __ucontext *" */
#define	SYS_getcontext	307

/* syscall: "setcontext" ret: "int" args: "const struct __ucontext *" */
#define	SYS_setcontext	308

/* syscall: "_lwp_create" ret: "int" args: "const struct __ucontext *" "u_long" "lwpid_t *" */
#define	SYS__lwp_create	309

/* syscall: "_lwp_exit" ret: "int" args: */
#define	SYS__lwp_exit	310

/* syscall: "_lwp_self" ret: "lwpid_t" args: */
#define	SYS__lwp_self	311

/* syscall: "_lwp_wait" ret: "int" args: "lwpid_t" "lwpid_t *" */
#define	SYS__lwp_wait	312

/* syscall: "_lwp_suspend" ret: "int" args: "lwpid_t" */
#define	SYS__lwp_suspend	313

/* syscall: "_lwp_continue" ret: "int" args: "lwpid_t" */
#define	SYS__lwp_continue	314

/* syscall: "_lwp_wakeup" ret: "int" args: "lwpid_t" */
#define	SYS__lwp_wakeup	315

/* syscall: "_lwp_getprivate" ret: "void *" args: */
#define	SYS__lwp_getprivate	316

/* syscall: "_lwp_setprivate" ret: "void" args: "void *" */
#define	SYS__lwp_setprivate	317

/* syscall: "_lwp_kill" ret: "int" args: "lwpid_t" "int" */
#define	SYS__lwp_kill	318

/* syscall: "_lwp_detach" ret: "int" args: "lwpid_t" */
#define	SYS__lwp_detach	319

/* syscall: "compat_50__lwp_park" ret: "int" args: "const struct timespec50 *" "lwpid_t" "const void *" "const void *" */
#define	SYS_compat_50__lwp_park	320

/* syscall: "_lwp_unpark" ret: "int" args: "lwpid_t" "const void *" */
#define	SYS__lwp_unpark	321

/* syscall: "_lwp_unpark_all" ret: "ssize_t" args: "const lwpid_t *" "size_t" "const void *" */
#define	SYS__lwp_unpark_all	322

/* syscall: "_lwp_setname" ret: "int" args: "lwpid_t" "const char *" */
#define	SYS__lwp_setname	323

/* syscall: "_lwp_getname" ret: "int" args: "lwpid_t" "char *" "size_t" */
#define	SYS__lwp_getname	324

/* syscall: "_lwp_ctl" ret: "int" args: "int" "struct lwpctl **" */
#define	SYS__lwp_ctl	325

/* syscall: "compat_60_sa_register" ret: "int" args: "void *" "void **" "int" "ssize_t" */
#define	SYS_compat_60_sa_register	330

/* syscall: "compat_60_sa_stacks" ret: "int" args: "int" "stack_t *" */
#define	SYS_compat_60_sa_stacks	331

/* syscall: "compat_60_sa_enable" ret: "int" args: */
#define	SYS_compat_60_sa_enable	332

/* syscall: "compat_60_sa_setconcurrency" ret: "int" args: "int" */
#define	SYS_compat_60_sa_setconcurrency	333

/* syscall: "compat_60_sa_yield" ret: "int" args: */
#define	SYS_compat_60_sa_yield	334

/* syscall: "compat_60_sa_preempt" ret: "int" args: "int" */
#define	SYS_compat_60_sa_preempt	335

				/* 336 is obsolete sys_sa_unblockyield */
/* syscall: "__sigaction_sigtramp" ret: "int" args: "int" "const struct sigaction *" "struct sigaction *" "const void *" "int" */
#define	SYS___sigaction_sigtramp	340

				/* 341 is obsolete sys_pmc_get_info */
				/* 342 is obsolete sys_pmc_control */
/* syscall: "rasctl" ret: "int" args: "void *" "size_t" "int" */
#define	SYS_rasctl	343

/* syscall: "kqueue" ret: "int" args: */
#define	SYS_kqueue	344

/* syscall: "compat_50_kevent" ret: "int" args: "int" "const struct kevent *" "size_t" "struct kevent *" "size_t" "const struct timespec50 *" */
#define	SYS_compat_50_kevent	345

/* syscall: "_sched_setparam" ret: "int" args: "pid_t" "lwpid_t" "int" "const struct sched_param *" */
#define	SYS__sched_setparam	346

/* syscall: "_sched_getparam" ret: "int" args: "pid_t" "lwpid_t" "int *" "struct sched_param *" */
#define	SYS__sched_getparam	347

/* syscall: "_sched_setaffinity" ret: "int" args: "pid_t" "lwpid_t" "size_t" "const cpuset_t *" */
#define	SYS__sched_setaffinity	348

/* syscall: "_sched_getaffinity" ret: "int" args: "pid_t" "lwpid_t" "size_t" "cpuset_t *" */
#define	SYS__sched_getaffinity	349

/* syscall: "sched_yield" ret: "int" args: */
#define	SYS_sched_yield	350

/* syscall: "_sched_protect" ret: "int" args: "int" */
#define	SYS__sched_protect	351

/* syscall: "fsync_range" ret: "int" args: "int" "int" "off_t" "off_t" */
#define	SYS_fsync_range	354

/* syscall: "uuidgen" ret: "int" args: "struct uuid *" "int" */
#define	SYS_uuidgen	355

/* syscall: "compat_90_getvfsstat" ret: "int" args: "struct statvfs90 *" "size_t" "int" */
#define	SYS_compat_90_getvfsstat	356

/* syscall: "compat_90_statvfs1" ret: "int" args: "const char *" "struct statvfs90 *" "int" */
#define	SYS_compat_90_statvfs1	357

/* syscall: "compat_90_fstatvfs1" ret: "int" args: "int" "struct statvfs90 *" "int" */
#define	SYS_compat_90_fstatvfs1	358

/* syscall: "compat_30_fhstatvfs1" ret: "int" args: "const struct compat_30_fhandle *" "struct statvfs90 *" "int" */
#define	SYS_compat_30_fhstatvfs1	359

/* syscall: "extattrctl" ret: "int" args: "const char *" "int" "const char *" "int" "const char *" */
#define	SYS_extattrctl	360

/* syscall: "extattr_set_file" ret: "int" args: "const char *" "int" "const char *" "const void *" "size_t" */
#define	SYS_extattr_set_file	361

/* syscall: "extattr_get_file" ret: "ssize_t" args: "const char *" "int" "const char *" "void *" "size_t" */
#define	SYS_extattr_get_file	362

/* syscall: "extattr_delete_file" ret: "int" args: "const char *" "int" "const char *" */
#define	SYS_extattr_delete_file	363

/* syscall: "extattr_set_fd" ret: "int" args: "int" "int" "const char *" "const void *" "size_t" */
#define	SYS_extattr_set_fd	364

/* syscall: "extattr_get_fd" ret: "ssize_t" args: "int" "int" "const char *" "void *" "size_t" */
#define	SYS_extattr_get_fd	365

/* syscall: "extattr_delete_fd" ret: "int" args: "int" "int" "const char *" */
#define	SYS_extattr_delete_fd	366

/* syscall: "extattr_set_link" ret: "int" args: "const char *" "int" "const char *" "const void *" "size_t" */
#define	SYS_extattr_set_link	367

/* syscall: "extattr_get_link" ret: "ssize_t" args: "const char *" "int" "const char *" "void *" "size_t" */
#define	SYS_extattr_get_link	368

/* syscall: "extattr_delete_link" ret: "int" args: "const char *" "int" "const char *" */
#define	SYS_extattr_delete_link	369

/* syscall: "extattr_list_fd" ret: "ssize_t" args: "int" "int" "void *" "size_t" */
#define	SYS_extattr_list_fd	370

/* syscall: "extattr_list_file" ret: "ssize_t" args: "const char *" "int" "void *" "size_t" */
#define	SYS_extattr_list_file	371

/* syscall: "extattr_list_link" ret: "ssize_t" args: "const char *" "int" "void *" "size_t" */
#define	SYS_extattr_list_link	372

/* syscall: "compat_50_pselect" ret: "int" args: "int" "fd_set *" "fd_set *" "fd_set *" "const struct timespec50 *" "const sigset_t *" */
#define	SYS_compat_50_pselect	373

/* syscall: "compat_50_pollts" ret: "int" args: "struct pollfd *" "u_int" "const struct timespec50 *" "const sigset_t *" */
#define	SYS_compat_50_pollts	374

/* syscall: "setxattr" ret: "int" args: "const char *" "const char *" "const void *" "size_t" "int" */
#define	SYS_setxattr	375

/* syscall: "lsetxattr" ret: "int" args: "const char *" "const char *" "const void *" "size_t" "int" */
#define	SYS_lsetxattr	376

/* syscall: "fsetxattr" ret: "int" args: "int" "const char *" "const void *" "size_t" "int" */
#define	SYS_fsetxattr	377

/* syscall: "getxattr" ret: "int" args: "const char *" "const char *" "void *" "size_t" */
#define	SYS_getxattr	378

/* syscall: "lgetxattr" ret: "int" args: "const char *" "const char *" "void *" "size_t" */
#define	SYS_lgetxattr	379

/* syscall: "fgetxattr" ret: "int" args: "int" "const char *" "void *" "size_t" */
#define	SYS_fgetxattr	380

/* syscall: "listxattr" ret: "int" args: "const char *" "char *" "size_t" */
#define	SYS_listxattr	381

/* syscall: "llistxattr" ret: "int" args: "const char *" "char *" "size_t" */
#define	SYS_llistxattr	382

/* syscall: "flistxattr" ret: "int" args: "int" "char *" "size_t" */
#define	SYS_flistxattr	383

/* syscall: "removexattr" ret: "int" args: "const char *" "const char *" */
#define	SYS_removexattr	384

/* syscall: "lremovexattr" ret: "int" args: "const char *" "const char *" */
#define	SYS_lremovexattr	385

/* syscall: "fremovexattr" ret: "int" args: "int" "const char *" */
#define	SYS_fremovexattr	386

/* syscall: "compat_50___stat30" ret: "int" args: "const char *" "struct stat30 *" */
#define	SYS_compat_50___stat30	387

/* syscall: "compat_50___fstat30" ret: "int" args: "int" "struct stat30 *" */
#define	SYS_compat_50___fstat30	388

/* syscall: "compat_50___lstat30" ret: "int" args: "const char *" "struct stat30 *" */
#define	SYS_compat_50___lstat30	389

/* syscall: "__getdents30" ret: "int" args: "int" "char *" "size_t" */
#define	SYS___getdents30	390

				/* 391 is ignored old posix_fadvise */
/* syscall: "compat_30___fhstat30" ret: "int" args: "const struct compat_30_fhandle *" "struct stat30 *" */
#define	SYS_compat_30___fhstat30	392

/* syscall: "compat_50___ntp_gettime30" ret: "int" args: "struct ntptimeval50 *" */
#define	SYS_compat_50___ntp_gettime30	393

/* syscall: "__socket30" ret: "int" args: "int" "int" "int" */
#define	SYS___socket30	394

/* syscall: "__getfh30" ret: "int" args: "const char *" "void *" "size_t *" */
#define	SYS___getfh30	395

/* syscall: "__fhopen40" ret: "int" args: "const void *" "size_t" "int" */
#define	SYS___fhopen40	396

/* syscall: "compat_90_fhstatvfs1" ret: "int" args: "const void *" "size_t" "struct statvfs90 *" "int" */
#define	SYS_compat_90_fhstatvfs1	397

/* syscall: "compat_50___fhstat40" ret: "int" args: "const void *" "size_t" "struct stat30 *" */
#define	SYS_compat_50___fhstat40	398

/* syscall: "aio_cancel" ret: "int" args: "int" "struct aiocb *" */
#define	SYS_aio_cancel	399

/* syscall: "aio_error" ret: "int" args: "const struct aiocb *" */
#define	SYS_aio_error	400

/* syscall: "aio_fsync" ret: "int" args: "int" "struct aiocb *" */
#define	SYS_aio_fsync	401

/* syscall: "aio_read" ret: "int" args: "struct aiocb *" */
#define	SYS_aio_read	402

/* syscall: "aio_return" ret: "int" args: "struct aiocb *" */
#define	SYS_aio_return	403

/* syscall: "compat_50_aio_suspend" ret: "int" args: "const struct aiocb *const *" "int" "const struct timespec50 *" */
#define	SYS_compat_50_aio_suspend	404

/* syscall: "aio_write" ret: "int" args: "struct aiocb *" */
#define	SYS_aio_write	405

/* syscall: "lio_listio" ret: "int" args: "int" "struct aiocb *const *" "int" "struct sigevent *" */
#define	SYS_lio_listio	406

/* syscall: "__mount50" ret: "int" args: "const char *" "const char *" "int" "void *" "size_t" */
#define	SYS___mount50	410

/* syscall: "mremap" ret: "void *" args: "void *" "size_t" "void *" "size_t" "int" */
#define	SYS_mremap	411

/* syscall: "pset_create" ret: "int" args: "psetid_t *" */
#define	SYS_pset_create	412

/* syscall: "pset_destroy" ret: "int" args: "psetid_t" */
#define	SYS_pset_destroy	413

/* syscall: "pset_assign" ret: "int" args: "psetid_t" "cpuid_t" "psetid_t *" */
#define	SYS_pset_assign	414

/* syscall: "_pset_bind" ret: "int" args: "idtype_t" "id_t" "id_t" "psetid_t" "psetid_t *" */
#define	SYS__pset_bind	415

/* syscall: "__posix_fadvise50" ret: "int" args: "int" "int" "off_t" "off_t" "int" */
#define	SYS___posix_fadvise50	416

/* syscall: "__select50" ret: "int" args: "int" "fd_set *" "fd_set *" "fd_set *" "struct timeval *" */
#define	SYS___select50	417

/* syscall: "__gettimeofday50" ret: "int" args: "struct timeval *" "void *" */
#define	SYS___gettimeofday50	418

/* syscall: "__settimeofday50" ret: "int" args: "const struct timeval *" "const void *" */
#define	SYS___settimeofday50	419

/* syscall: "__utimes50" ret: "int" args: "const char *" "const struct timeval *" */
#define	SYS___utimes50	420

/* syscall: "__adjtime50" ret: "int" args: "const struct timeval *" "struct timeval *" */
#define	SYS___adjtime50	421

/* syscall: "__lfs_segwait50" ret: "int" args: "fsid_t *" "struct timeval *" */
#define	SYS___lfs_segwait50	422

/* syscall: "__futimes50" ret: "int" args: "int" "const struct timeval *" */
#define	SYS___futimes50	423

/* syscall: "__lutimes50" ret: "int" args: "const char *" "const struct timeval *" */
#define	SYS___lutimes50	424

/* syscall: "__setitimer50" ret: "int" args: "int" "const struct itimerval *" "struct itimerval *" */
#define	SYS___setitimer50	425

/* syscall: "__getitimer50" ret: "int" args: "int" "struct itimerval *" */
#define	SYS___getitimer50	426

/* syscall: "__clock_gettime50" ret: "int" args: "clockid_t" "struct timespec *" */
#define	SYS___clock_gettime50	427

/* syscall: "__clock_settime50" ret: "int" args: "clockid_t" "const struct timespec *" */
#define	SYS___clock_settime50	428

/* syscall: "__clock_getres50" ret: "int" args: "clockid_t" "struct timespec *" */
#define	SYS___clock_getres50	429

/* syscall: "__nanosleep50" ret: "int" args: "const struct timespec *" "struct timespec *" */
#define	SYS___nanosleep50	430

/* syscall: "____sigtimedwait50" ret: "int" args: "const sigset_t *" "siginfo_t *" "struct timespec *" */
#define	SYS_____sigtimedwait50	431

/* syscall: "__mq_timedsend50" ret: "int" args: "mqd_t" "const char *" "size_t" "unsigned" "const struct timespec *" */
#define	SYS___mq_timedsend50	432

/* syscall: "__mq_timedreceive50" ret: "ssize_t" args: "mqd_t" "char *" "size_t" "unsigned *" "const struct timespec *" */
#define	SYS___mq_timedreceive50	433

/* syscall: "compat_60__lwp_park" ret: "int" args: "const struct timespec *" "lwpid_t" "const void *" "const void *" */
#define	SYS_compat_60__lwp_park	434

/* syscall: "__kevent50" ret: "int" args: "int" "const struct kevent *" "size_t" "struct kevent *" "size_t" "const struct timespec *" */
#define	SYS___kevent50	435

/* syscall: "__pselect50" ret: "int" args: "int" "fd_set *" "fd_set *" "fd_set *" "const struct timespec *" "const sigset_t *" */
#define	SYS___pselect50	436

/* syscall: "__pollts50" ret: "int" args: "struct pollfd *" "u_int" "const struct timespec *" "const sigset_t *" */
#define	SYS___pollts50	437

/* syscall: "__aio_suspend50" ret: "int" args: "const struct aiocb *const *" "int" "const struct timespec *" */
#define	SYS___aio_suspend50	438

/* syscall: "__stat50" ret: "int" args: "const char *" "struct stat *" */
#define	SYS___stat50	439

/* syscall: "__fstat50" ret: "int" args: "int" "struct stat *" */
#define	SYS___fstat50	440

/* syscall: "__lstat50" ret: "int" args: "const char *" "struct stat *" */
#define	SYS___lstat50	441

/* syscall: "____semctl50" ret: "int" args: "int" "int" "int" "..." */
#define	SYS_____semctl50	442

/* syscall: "__shmctl50" ret: "int" args: "int" "int" "struct shmid_ds *" */
#define	SYS___shmctl50	443

/* syscall: "__msgctl50" ret: "int" args: "int" "int" "struct msqid_ds *" */
#define	SYS___msgctl50	444

/* syscall: "__getrusage50" ret: "int" args: "int" "struct rusage *" */
#define	SYS___getrusage50	445

/* syscall: "__timer_settime50" ret: "int" args: "timer_t" "int" "const struct itimerspec *" "struct itimerspec *" */
#define	SYS___timer_settime50	446

/* syscall: "__timer_gettime50" ret: "int" args: "timer_t" "struct itimerspec *" */
#define	SYS___timer_gettime50	447

#if defined(NTP) || !defined(_KERNEL_OPT)
/* syscall: "__ntp_gettime50" ret: "int" args: "struct ntptimeval *" */
#define	SYS___ntp_gettime50	448

#else
				/* 448 is excluded ___ntp_gettime50 */
#endif
/* syscall: "__wait450" ret: "int" args: "pid_t" "int *" "int" "struct rusage *" */
#define	SYS___wait450	449

/* syscall: "__mknod50" ret: "int" args: "const char *" "mode_t" "dev_t" */
#define	SYS___mknod50	450

/* syscall: "__fhstat50" ret: "int" args: "const void *" "size_t" "struct stat *" */
#define	SYS___fhstat50	451

				/* 452 is obsolete 5.99 quotactl */
/* syscall: "pipe2" ret: "int" args: "int *" "int" */
#define	SYS_pipe2	453

/* syscall: "dup3" ret: "int" args: "int" "int" "int" */
#define	SYS_dup3	454

/* syscall: "kqueue1" ret: "int" args: "int" */
#define	SYS_kqueue1	455

/* syscall: "paccept" ret: "int" args: "int" "struct sockaddr *" "socklen_t *" "const sigset_t *" "int" */
#define	SYS_paccept	456

/* syscall: "linkat" ret: "int" args: "int" "const char *" "int" "const char *" "int" */
#define	SYS_linkat	457

/* syscall: "renameat" ret: "int" args: "int" "const char *" "int" "const char *" */
#define	SYS_renameat	458

/* syscall: "mkfifoat" ret: "int" args: "int" "const char *" "mode_t" */
#define	SYS_mkfifoat	459

/* syscall: "mknodat" ret: "int" args: "int" "const char *" "mode_t" "int" "dev_t" */
#define	SYS_mknodat	460

/* syscall: "mkdirat" ret: "int" args: "int" "const char *" "mode_t" */
#define	SYS_mkdirat	461

/* syscall: "faccessat" ret: "int" args: "int" "const char *" "int" "int" */
#define	SYS_faccessat	462

/* syscall: "fchmodat" ret: "int" args: "int" "const char *" "mode_t" "int" */
#define	SYS_fchmodat	463

/* syscall: "fchownat" ret: "int" args: "int" "const char *" "uid_t" "gid_t" "int" */
#define	SYS_fchownat	464

/* syscall: "fexecve" ret: "int" args: "int" "char *const *" "char *const *" */
#define	SYS_fexecve	465

/* syscall: "fstatat" ret: "int" args: "int" "const char *" "struct stat *" "int" */
#define	SYS_fstatat	466

/* syscall: "utimensat" ret: "int" args: "int" "const char *" "const struct timespec *" "int" */
#define	SYS_utimensat	467

/* syscall: "openat" ret: "int" args: "int" "const char *" "int" "..." */
#define	SYS_openat	468

/* syscall: "readlinkat" ret: "ssize_t" args: "int" "const char *" "char *" "size_t" */
#define	SYS_readlinkat	469

/* syscall: "symlinkat" ret: "int" args: "const char *" "int" "const char *" */
#define	SYS_symlinkat	470

/* syscall: "unlinkat" ret: "int" args: "int" "const char *" "int" */
#define	SYS_unlinkat	471

/* syscall: "futimens" ret: "int" args: "int" "const struct timespec *" */
#define	SYS_futimens	472

/* syscall: "__quotactl" ret: "int" args: "const char *" "struct quotactl_args *" */
#define	SYS___quotactl	473

/* syscall: "posix_spawn" ret: "int" args: "pid_t *" "const char *" "const struct posix_spawn_file_actions *" "const struct posix_spawnattr *" "char *const *" "char *const *" */
#define	SYS_posix_spawn	474

/* syscall: "recvmmsg" ret: "int" args: "int" "struct mmsghdr *" "unsigned int" "unsigned int" "struct timespec *" */
#define	SYS_recvmmsg	475

/* syscall: "sendmmsg" ret: "int" args: "int" "struct mmsghdr *" "unsigned int" "unsigned int" */
#define	SYS_sendmmsg	476

/* syscall: "clock_nanosleep" ret: "int" args: "clockid_t" "int" "const struct timespec *" "struct timespec *" */
#define	SYS_clock_nanosleep	477

/* syscall: "___lwp_park60" ret: "int" args: "clockid_t" "int" "struct timespec *" "lwpid_t" "const void *" "const void *" */
#define	SYS____lwp_park60	478

/* syscall: "posix_fallocate" ret: "int" args: "int" "int" "off_t" "off_t" */
#define	SYS_posix_fallocate	479

/* syscall: "fdiscard" ret: "int" args: "int" "int" "off_t" "off_t" */
#define	SYS_fdiscard	480

/* syscall: "wait6" ret: "int" args: "idtype_t" "id_t" "int *" "int" "struct wrusage *" "siginfo_t *" */
#define	SYS_wait6	481

/* syscall: "clock_getcpuclockid2" ret: "int" args: "idtype_t" "id_t" "clockid_t *" */
#define	SYS_clock_getcpuclockid2	482

/* syscall: "__getvfsstat90" ret: "int" args: "struct statvfs *" "size_t" "int" */
#define	SYS___getvfsstat90	483

/* syscall: "__statvfs190" ret: "int" args: "const char *" "struct statvfs *" "int" */
#define	SYS___statvfs190	484

/* syscall: "__fstatvfs190" ret: "int" args: "int" "struct statvfs *" "int" */
#define	SYS___fstatvfs190	485

/* syscall: "__fhstatvfs190" ret: "int" args: "const void *" "size_t" "struct statvfs *" "int" */
#define	SYS___fhstatvfs190	486

/* syscall: "__acl_get_link" ret: "int" args: "const char *" "acl_type_t" "struct acl *" */
#define	SYS___acl_get_link	487

/* syscall: "__acl_set_link" ret: "int" args: "const char *" "acl_type_t" "struct acl *" */
#define	SYS___acl_set_link	488

/* syscall: "__acl_delete_link" ret: "int" args: "const char *" "acl_type_t" */
#define	SYS___acl_delete_link	489

/* syscall: "__acl_aclcheck_link" ret: "int" args: "const char *" "acl_type_t" "struct acl *" */
#define	SYS___acl_aclcheck_link	490

/* syscall: "__acl_get_file" ret: "int" args: "const char *" "acl_type_t" "struct acl *" */
#define	SYS___acl_get_file	491

/* syscall: "__acl_set_file" ret: "int" args: "const char *" "acl_type_t" "struct acl *" */
#define	SYS___acl_set_file	492

/* syscall: "__acl_get_fd" ret: "int" args: "int" "acl_type_t" "struct acl *" */
#define	SYS___acl_get_fd	493

/* syscall: "__acl_set_fd" ret: "int" args: "int" "acl_type_t" "struct acl *" */
#define	SYS___acl_set_fd	494

/* syscall: "__acl_delete_file" ret: "int" args: "const char *" "acl_type_t" */
#define	SYS___acl_delete_file	495

/* syscall: "__acl_delete_fd" ret: "int" args: "int" "acl_type_t" */
#define	SYS___acl_delete_fd	496

/* syscall: "__acl_aclcheck_file" ret: "int" args: "const char *" "acl_type_t" "struct acl *" */
#define	SYS___acl_aclcheck_file	497

/* syscall: "__acl_aclcheck_fd" ret: "int" args: "int" "acl_type_t" "struct acl *" */
#define	SYS___acl_aclcheck_fd	498

/* syscall: "lpathconf" ret: "long" args: "const char *" "int" */
#define	SYS_lpathconf	499

#define	SYS_MAXSYSCALL	500
#define	SYS_NSYSENT	512
#endif /* _SYS_SYSCALL_H_ */
