/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.TensorFlow;

public final class Graph
implements AutoCloseable {
    private final Object nativeHandleLock = new Object();
    private long nativeHandle;
    private int refcount = 0;

    public Graph() {
        this.nativeHandle = Graph.allocate();
    }

    Graph(long l) {
        this.nativeHandle = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == 0L) {
                return;
            }
            while (this.refcount > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Graph.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation operation(String string) {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            long l = Graph.operation(this.nativeHandle, string);
            if (l == 0L) {
                return null;
            }
            return new Operation(this, l);
        }
    }

    public OperationBuilder opBuilder(String string, String string2) {
        return new OperationBuilder(this, string, string2);
    }

    public void importGraphDef(byte[] byArray) throws IllegalArgumentException {
        this.importGraphDef(byArray, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importGraphDef(byte[] byArray, String string) throws IllegalArgumentException {
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("graphDef and prefix cannot be null");
        }
        Object object = this.nativeHandleLock;
        synchronized (object) {
            Graph.importGraphDef(this.nativeHandle, byArray, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toGraphDef() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            return Graph.toGraphDef(this.nativeHandle);
        }
    }

    Reference ref() {
        return new Reference();
    }

    private static native long allocate();

    private static native void delete(long var0);

    private static native long operation(long var0, String var2);

    private static native void importGraphDef(long var0, byte[] var2, String var3) throws IllegalArgumentException;

    private static native byte[] toGraphDef(long var0);

    static {
        TensorFlow.init();
    }

    class Reference
    implements AutoCloseable {
        private boolean active;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Reference() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                boolean bl = this.active = Graph.this.nativeHandle != 0L;
                if (!this.active) {
                    throw new IllegalStateException("close() has been called on the Graph");
                }
                this.active = true;
                Graph.this.refcount++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                if (--Graph.this.refcount == 0) {
                    Graph.this.nativeHandleLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long nativeHandle() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                return this.active ? Graph.this.nativeHandle : 0L;
            }
        }
    }
}

