/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tensorflow.TensorFlow;

final class NativeLibrary {
    private static final boolean DEBUG = System.getProperty("org.tensorflow.NativeLibrary.DEBUG") != null;
    private static final String LIBNAME = "tensorflow_jni";

    public static void load() {
        if (NativeLibrary.isLoaded() || NativeLibrary.tryLoadLibrary()) {
            return;
        }
        String string = NativeLibrary.makeResourceName();
        NativeLibrary.log("resourceName: " + string);
        InputStream inputStream = NativeLibrary.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new UnsatisfiedLinkError(String.format("Cannot find TensorFlow native library for OS: %s, architecture: %s. See https://github.com/tensorflow/tensorflow/tree/master/tensorflow/java/README.md for possible solutions (such as building the library from source). Additional information on attempts to find the native library can be obtained by adding org.tensorflow.NativeLibrary.DEBUG=1 to the system properties of the JVM.", NativeLibrary.os(), NativeLibrary.architecture()));
        }
        try {
            System.load(NativeLibrary.extractResource(inputStream));
        }
        catch (IOException iOException) {
            throw new UnsatisfiedLinkError(String.format("Unable to extract native library into a temporary file (%s)", iOException.toString()));
        }
    }

    private static boolean tryLoadLibrary() {
        try {
            System.loadLibrary(LIBNAME);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            NativeLibrary.log("tryLoadLibraryFailed: " + unsatisfiedLinkError.getMessage());
            return false;
        }
    }

    private static boolean isLoaded() {
        try {
            TensorFlow.version();
            NativeLibrary.log("isLoaded: true");
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    private static String extractResource(InputStream inputStream) throws IOException {
        String string = System.mapLibraryName(LIBNAME);
        int n = string.indexOf(".");
        String string2 = n < 0 ? string : string.substring(0, n);
        String string3 = n < 0 ? null : string.substring(n);
        File file = File.createTempFile(string2, string3);
        String string4 = file.getAbsolutePath();
        file.deleteOnExit();
        NativeLibrary.log("extracting native library to: " + string4);
        long l = NativeLibrary.copy(inputStream, file);
        NativeLibrary.log(String.format("copied %d bytes to %s", l, string4));
        return string4;
    }

    private static String os() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("linux")) {
            return "linux";
        }
        if (string.contains("os x") || string.contains("darwin")) {
            return "darwin";
        }
        if (string.contains("windows")) {
            return "windows";
        }
        return string.replaceAll("\\s", "");
    }

    private static String architecture() {
        String string = System.getProperty("os.arch").toLowerCase();
        return string.equals("amd64") ? "x86_64" : string;
    }

    private static void log(String string) {
        if (DEBUG) {
            System.err.println("org.tensorflow.NativeLibrary: " + string);
        }
    }

    private static String makeResourceName() {
        return "org/tensorflow/native/" + String.format("%s-%s/", NativeLibrary.os(), NativeLibrary.architecture()) + System.mapLibraryName(LIBNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            byte[] byArray = new byte[0x100000];
            long l = 0L;
            int n = 0;
            while ((n = inputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
                l += (long)n;
            }
            long l2 = l;
            return l2;
        }
        finally {
            fileOutputStream.close();
            inputStream.close();
        }
    }

    private NativeLibrary() {
    }
}

