/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.DataType;
import org.tensorflow.Graph;
import org.tensorflow.Output;

public final class Operation {
    private final long unsafeNativeHandle;
    private final Graph graph;

    Operation(Graph graph, long l) {
        this.graph = graph;
        this.unsafeNativeHandle = l;
    }

    public String name() {
        try (Graph.Reference reference = this.graph.ref();){
            String string = Operation.name(this.unsafeNativeHandle);
            return string;
        }
    }

    public String type() {
        try (Graph.Reference reference = this.graph.ref();){
            String string = Operation.type(this.unsafeNativeHandle);
            return string;
        }
    }

    public int numOutputs() {
        try (Graph.Reference reference = this.graph.ref();){
            int n = Operation.numOutputs(this.unsafeNativeHandle);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int outputListLength(String string) {
        try (Graph.Reference reference = this.graph.ref();){
            int n = Operation.outputListLength(this.unsafeNativeHandle, string);
            return n;
        }
    }

    public Output[] outputList(int n, int n2) {
        Output[] outputArray = new Output[n2];
        for (int i = 0; i < n2; ++i) {
            outputArray[i] = this.output(n + i);
        }
        return outputArray;
    }

    public Output output(int n) {
        return new Output(this, n);
    }

    public int hashCode() {
        return Long.valueOf(this.unsafeNativeHandle).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)object;
        if (this.graph != operation.graph) {
            return false;
        }
        try (Graph.Reference reference = this.graph.ref();){
            boolean bl = this.unsafeNativeHandle == operation.unsafeNativeHandle;
            return bl;
        }
    }

    public String toString() {
        return String.format("<%s '%s'>", this.type(), this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inputListLength(String string) {
        try (Graph.Reference reference = this.graph.ref();){
            int n = Operation.inputListLength(this.unsafeNativeHandle, string);
            return n;
        }
    }

    long getUnsafeNativeHandle() {
        return this.unsafeNativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] shape(int n) {
        try (Graph.Reference reference = this.graph.ref();){
            long[] lArray = Operation.shape(reference.nativeHandle(), this.unsafeNativeHandle, n);
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataType dtype(int n) {
        try (Graph.Reference reference = this.graph.ref();){
            DataType dataType = DataType.fromC(Operation.dtype(reference.nativeHandle(), this.unsafeNativeHandle, n));
            return dataType;
        }
    }

    private static native String name(long var0);

    private static native String type(long var0);

    private static native int numOutputs(long var0);

    private static native int outputListLength(long var0, String var2);

    private static native int inputListLength(long var0, String var2);

    private static native long[] shape(long var0, long var2, int var4);

    private static native int dtype(long var0, long var2, int var4);
}

