/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.nio.charset.Charset;
import org.tensorflow.DataType;
import org.tensorflow.Graph;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.Tensor;

public final class OperationBuilder {
    private long unsafeNativeHandle;
    private Graph graph;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationBuilder(Graph graph, String string, String string2) {
        this.graph = graph;
        try (Graph.Reference reference = graph.ref();){
            this.unsafeNativeHandle = OperationBuilder.allocate(reference.nativeHandle(), string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation build() {
        try (Graph.Reference reference = this.graph.ref();){
            Operation operation = new Operation(this.graph, OperationBuilder.finish(this.unsafeNativeHandle));
            this.unsafeNativeHandle = 0L;
            Operation operation2 = operation;
            return operation2;
        }
    }

    public OperationBuilder addInput(Output output) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.addInput(this.unsafeNativeHandle, output.op().getUnsafeNativeHandle(), output.index());
        }
        return this;
    }

    public OperationBuilder addControlInput(Operation operation) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.addControlInput(this.unsafeNativeHandle, operation.getUnsafeNativeHandle());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder addInputList(Output[] outputArray) {
        try (Graph.Reference reference = this.graph.ref();){
            long[] lArray = new long[outputArray.length];
            int[] nArray = new int[outputArray.length];
            for (int i = 0; i < outputArray.length; ++i) {
                lArray[i] = outputArray[i].op().getUnsafeNativeHandle();
                nArray[i] = outputArray[i].index();
            }
            OperationBuilder.addInputList(this.unsafeNativeHandle, lArray, nArray);
        }
        return this;
    }

    public OperationBuilder setDevice(String string) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setDevice(this.unsafeNativeHandle, string);
        }
        return this;
    }

    public OperationBuilder setAttr(String string, String string2) {
        this.setAttr(string, string2.getBytes(Charset.forName("UTF-8")));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, byte[] byArray) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrString(this.unsafeNativeHandle, string, byArray);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, long l) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrInt(this.unsafeNativeHandle, string, l);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, long[] lArray) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrIntList(this.unsafeNativeHandle, string, lArray);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, float f) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrFloat(this.unsafeNativeHandle, string, f);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, float[] fArray) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrFloatList(this.unsafeNativeHandle, string, fArray);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, boolean bl) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrBool(this.unsafeNativeHandle, string, bl);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, boolean[] blArray) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrBoolList(this.unsafeNativeHandle, string, blArray);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, DataType dataType) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrType(this.unsafeNativeHandle, string, dataType.c());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, DataType[] dataTypeArray) {
        int[] nArray = new int[dataTypeArray.length];
        for (int i = 0; i < dataTypeArray.length; ++i) {
            nArray[i] = dataTypeArray[i].c();
        }
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrTypeList(this.unsafeNativeHandle, string, nArray);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, Tensor tensor) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrTensor(this.unsafeNativeHandle, string, tensor.getNativeHandle());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, Tensor[] tensorArray) {
        long[] lArray = new long[tensorArray.length];
        int n = 0;
        for (Tensor tensor : tensorArray) {
            lArray[n++] = tensor.getNativeHandle();
        }
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrTensorList(this.unsafeNativeHandle, string, lArray);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, Shape shape) {
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrShape(this.unsafeNativeHandle, string, shape.asArray(), shape.numDimensions());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String string, String[] stringArray) {
        Charset charset = Charset.forName("UTF-8");
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = stringArray[i].getBytes(charset);
        }
        try (Graph.Reference reference = this.graph.ref();){
            OperationBuilder.setAttrStringList(this.unsafeNativeHandle, string, objectArray);
        }
        return this;
    }

    private static native long allocate(long var0, String var2, String var3);

    private static native long finish(long var0);

    private static native void addInput(long var0, long var2, int var4);

    private static native void addInputList(long var0, long[] var2, int[] var3);

    private static native void addControlInput(long var0, long var2);

    private static native void setDevice(long var0, String var2);

    private static native void setAttrString(long var0, String var2, byte[] var3);

    private static native void setAttrInt(long var0, String var2, long var3);

    private static native void setAttrIntList(long var0, String var2, long[] var3);

    private static native void setAttrFloat(long var0, String var2, float var3);

    private static native void setAttrFloatList(long var0, String var2, float[] var3);

    private static native void setAttrBool(long var0, String var2, boolean var3);

    private static native void setAttrBoolList(long var0, String var2, boolean[] var3);

    private static native void setAttrType(long var0, String var2, int var3);

    private static native void setAttrTypeList(long var0, String var2, int[] var3);

    private static native void setAttrTensor(long var0, String var2, long var3);

    private static native void setAttrTensorList(long var0, String var2, long[] var3);

    private static native void setAttrShape(long var0, String var2, long[] var3, int var4);

    private static native void setAttrStringList(long var0, String var2, Object[] var3);
}

