/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Objects;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Shape;

public final class Output
implements Operand {
    private final Operation operation;
    private final int index;

    public Output(Operation operation, int n) {
        this.operation = operation;
        this.index = n;
    }

    public Operation op() {
        return this.operation;
    }

    public int index() {
        return this.index;
    }

    public Shape shape() {
        return new Shape(this.operation.shape(this.index));
    }

    public DataType dataType() {
        return this.operation.dtype(this.index);
    }

    @Override
    public Output asOutput() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.index);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Output) {
            Output output = (Output)object;
            return this.index == output.index && this.operation.equals(output.operation);
        }
        return false;
    }

    public String toString() {
        return String.format("<%s '%s:%d' shape=%s dtype=%s>", new Object[]{this.operation.type(), this.operation.name(), this.index, this.shape().toString(), this.dataType()});
    }
}

