/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.ArrayList;
import java.util.List;
import org.tensorflow.Graph;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.Tensor;

public final class Session
implements AutoCloseable {
    private final Graph graph;
    private final Graph.Reference graphRef;
    private final Object nativeHandleLock = new Object();
    private long nativeHandle;
    private int numActiveRuns;

    public Session(Graph graph) {
        this(graph, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session(Graph graph, byte[] byArray) {
        this.graph = graph;
        try (Graph.Reference reference = graph.ref();){
            this.nativeHandle = byArray == null ? Session.allocate(reference.nativeHandle()) : Session.allocate2(reference.nativeHandle(), null, byArray);
            this.graphRef = graph.ref();
        }
    }

    Session(Graph graph, long l) {
        this.graph = graph;
        this.nativeHandle = l;
        this.graphRef = graph.ref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.graphRef.close();
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == 0L) {
                return;
            }
            while (this.numActiveRuns > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Session.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    public Runner runner() {
        return new Runner();
    }

    private static native long allocate(long var0);

    private static native long allocate2(long var0, String var2, byte[] var3);

    private static native void delete(long var0);

    private static native byte[] run(long var0, byte[] var2, long[] var3, long[] var4, int[] var5, long[] var6, int[] var7, long[] var8, boolean var9, long[] var10);

    public static final class Run {
        public List<Tensor> outputs;
        public byte[] metadata;
    }

    public final class Runner {
        private ArrayList<Output> inputs = new ArrayList();
        private ArrayList<Tensor> inputTensors = new ArrayList();
        private ArrayList<Output> outputs = new ArrayList();
        private ArrayList<Operation> targets = new ArrayList();
        private byte[] runOptions = null;

        public Runner feed(String string, Tensor tensor) {
            return this.feed(this.parseOutput(string), tensor);
        }

        public Runner feed(String string, int n, Tensor tensor) {
            Operation operation = this.operationByName(string);
            if (operation != null) {
                this.inputs.add(operation.output(n));
                this.inputTensors.add(tensor);
            }
            return this;
        }

        public Runner feed(Output output, Tensor tensor) {
            this.inputs.add(output);
            this.inputTensors.add(tensor);
            return this;
        }

        public Runner fetch(String string) {
            return this.fetch(this.parseOutput(string));
        }

        public Runner fetch(String string, int n) {
            Operation operation = this.operationByName(string);
            if (operation != null) {
                this.outputs.add(operation.output(n));
            }
            return this;
        }

        public Runner fetch(Output output) {
            this.outputs.add(output);
            return this;
        }

        public Runner addTarget(String string) {
            Operation operation = this.operationByName(string);
            if (operation != null) {
                this.targets.add(operation);
            }
            return this;
        }

        public Runner addTarget(Operation operation) {
            this.targets.add(operation);
            return this;
        }

        public Runner setOptions(byte[] byArray) {
            this.runOptions = byArray;
            return this;
        }

        public List<Tensor> run() {
            return this.runHelper((boolean)false).outputs;
        }

        public Run runAndFetchMetadata() {
            return this.runHelper(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Run runHelper(boolean bl) {
            byte[] byArray;
            long[] lArray = new long[this.inputTensors.size()];
            long[] lArray2 = new long[this.inputs.size()];
            int[] nArray = new int[this.inputs.size()];
            long[] lArray3 = new long[this.outputs.size()];
            int[] nArray2 = new int[this.outputs.size()];
            long[] lArray4 = new long[this.targets.size()];
            long[] lArray5 = new long[this.outputs.size()];
            int n = 0;
            for (Tensor object2 : this.inputTensors) {
                lArray[n++] = object2.getNativeHandle();
            }
            n = 0;
            for (Output output : this.inputs) {
                lArray2[n] = output.op().getUnsafeNativeHandle();
                nArray[n] = output.index();
                ++n;
            }
            n = 0;
            for (Output output : this.outputs) {
                lArray3[n] = output.op().getUnsafeNativeHandle();
                nArray2[n] = output.index();
                ++n;
            }
            n = 0;
            for (Operation operation : this.targets) {
                lArray4[n++] = operation.getUnsafeNativeHandle();
            }
            Object var11_18 = null;
            try (Reference reference = new Reference();){
                byArray = Session.run(Session.this.nativeHandle, this.runOptions, lArray, lArray2, nArray, lArray3, nArray2, lArray4, bl, lArray5);
            }
            ArrayList<Tensor> arrayList = new ArrayList<Tensor>();
            for (long l : lArray5) {
                try {
                    arrayList.add(Tensor.fromHandle(l));
                }
                catch (Exception exception) {
                    for (Tensor tensor : arrayList) {
                        tensor.close();
                    }
                    arrayList.clear();
                    throw exception;
                }
            }
            Run run = new Run();
            run.outputs = arrayList;
            run.metadata = byArray;
            return run;
        }

        private Operation operationByName(String string) {
            Operation operation = Session.this.graph.operation(string);
            if (operation == null) {
                throw new IllegalArgumentException("No Operation named [" + string + "] in the Graph");
            }
            return operation;
        }

        private Output parseOutput(String string) {
            int n = string.lastIndexOf(58);
            if (n == -1 || n == string.length() - 1) {
                return new Output(this.operationByName(string), 0);
            }
            try {
                String string2 = string.substring(0, n);
                int n2 = Integer.parseInt(string.substring(n + 1));
                return new Output(this.operationByName(string2), n2);
            }
            catch (NumberFormatException numberFormatException) {
                return new Output(this.operationByName(string), 0);
            }
        }

        private class Reference
        implements AutoCloseable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Reference() {
                Object object = Session.this.nativeHandleLock;
                synchronized (object) {
                    if (Session.this.nativeHandle == 0L) {
                        throw new IllegalStateException("run() cannot be called on the Session after close()");
                    }
                    ++Session.this.numActiveRuns;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Object object = Session.this.nativeHandleLock;
                synchronized (object) {
                    if (Session.this.nativeHandle == 0L) {
                        return;
                    }
                    if (--Session.this.numActiveRuns == 0) {
                        Session.this.nativeHandleLock.notifyAll();
                    }
                }
            }
        }
    }
}

