/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Arrays;

public final class Shape {
    private long[] shape;

    public static Shape unknown() {
        return new Shape(null);
    }

    public static Shape scalar() {
        return new Shape(new long[0]);
    }

    public static Shape make(long l, long ... lArray) {
        long[] lArray2 = new long[lArray.length + 1];
        lArray2[0] = l;
        System.arraycopy(lArray, 0, lArray2, 1, lArray.length);
        return new Shape(lArray2);
    }

    public int numDimensions() {
        return this.shape == null ? -1 : this.shape.length;
    }

    public long size(int n) {
        return this.shape[n];
    }

    public String toString() {
        if (this.shape == null) {
            return "<unknown>";
        }
        return Arrays.toString(this.shape).replace("-1", "?");
    }

    Shape(long[] lArray) {
        this.shape = lArray;
    }

    long[] asArray() {
        return this.shape;
    }
}

