/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.tensorflow.DataType;
import org.tensorflow.TensorFlow;

public final class Tensor
implements AutoCloseable {
    private long nativeHandle;
    private DataType dtype;
    private long[] shapeCopy = null;

    public static Tensor create(Object object) {
        Tensor tensor = new Tensor();
        tensor.dtype = Tensor.dataTypeOf(object);
        tensor.shapeCopy = new long[Tensor.numDimensions(object)];
        Tensor.fillShape(object, 0, tensor.shapeCopy);
        if (tensor.dtype != DataType.STRING) {
            int n = Tensor.elemByteSize(tensor.dtype) * Tensor.numElements(tensor.shapeCopy);
            tensor.nativeHandle = Tensor.allocate(tensor.dtype.c(), tensor.shapeCopy, n);
            Tensor.setValue(tensor.nativeHandle, object);
        } else {
            if (tensor.shapeCopy.length != 0) {
                throw new UnsupportedOperationException(String.format("non-scalar DataType.STRING tensors are not supported yet (version %s). Please file a feature request at https://github.com/tensorflow/tensorflow/issues/new", TensorFlow.version()));
            }
            tensor.nativeHandle = Tensor.allocateScalarBytes((byte[])object);
        }
        return tensor;
    }

    public static Tensor create(long[] lArray, IntBuffer intBuffer) {
        Tensor tensor = Tensor.allocateForBuffer(DataType.INT32, lArray, intBuffer.remaining());
        tensor.buffer().asIntBuffer().put(intBuffer);
        return tensor;
    }

    public static Tensor create(long[] lArray, FloatBuffer floatBuffer) {
        Tensor tensor = Tensor.allocateForBuffer(DataType.FLOAT, lArray, floatBuffer.remaining());
        tensor.buffer().asFloatBuffer().put(floatBuffer);
        return tensor;
    }

    public static Tensor create(long[] lArray, DoubleBuffer doubleBuffer) {
        Tensor tensor = Tensor.allocateForBuffer(DataType.DOUBLE, lArray, doubleBuffer.remaining());
        tensor.buffer().asDoubleBuffer().put(doubleBuffer);
        return tensor;
    }

    public static Tensor create(long[] lArray, LongBuffer longBuffer) {
        Tensor tensor = Tensor.allocateForBuffer(DataType.INT64, lArray, longBuffer.remaining());
        tensor.buffer().asLongBuffer().put(longBuffer);
        return tensor;
    }

    public static Tensor create(DataType dataType, long[] lArray, ByteBuffer byteBuffer) {
        int n = 0;
        if (dataType != DataType.STRING) {
            int n2 = Tensor.elemByteSize(dataType);
            if (byteBuffer.remaining() % n2 != 0) {
                throw new IllegalArgumentException(String.format("ByteBuffer with %d bytes is not compatible with a %s Tensor (%d bytes/element)", byteBuffer.remaining(), dataType.toString(), n2));
            }
            n = byteBuffer.remaining() / n2;
        } else {
            n = byteBuffer.remaining();
        }
        Tensor tensor = Tensor.allocateForBuffer(dataType, lArray, n);
        tensor.buffer().put(byteBuffer);
        return tensor;
    }

    private static Tensor allocateForBuffer(DataType dataType, long[] lArray, int n) {
        int n2 = Tensor.numElements(lArray);
        int n3 = 0;
        if (dataType != DataType.STRING) {
            if (n != n2) {
                throw Tensor.incompatibleBuffer(n, lArray);
            }
            n3 = n2 * Tensor.elemByteSize(dataType);
        } else {
            n3 = n;
        }
        Tensor tensor = new Tensor();
        tensor.dtype = dataType;
        tensor.shapeCopy = Arrays.copyOf(lArray, lArray.length);
        tensor.nativeHandle = Tensor.allocate(tensor.dtype.c(), tensor.shapeCopy, n3);
        return tensor;
    }

    @Override
    public void close() {
        if (this.nativeHandle != 0L) {
            Tensor.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    public DataType dataType() {
        return this.dtype;
    }

    public int numDimensions() {
        return this.shapeCopy.length;
    }

    public int numBytes() {
        return this.buffer().remaining();
    }

    public int numElements() {
        return Tensor.numElements(this.shapeCopy);
    }

    public long[] shape() {
        return this.shapeCopy;
    }

    public float floatValue() {
        return Tensor.scalarFloat(this.nativeHandle);
    }

    public double doubleValue() {
        return Tensor.scalarDouble(this.nativeHandle);
    }

    public int intValue() {
        return Tensor.scalarInt(this.nativeHandle);
    }

    public long longValue() {
        return Tensor.scalarLong(this.nativeHandle);
    }

    public boolean booleanValue() {
        return Tensor.scalarBoolean(this.nativeHandle);
    }

    public byte[] bytesValue() {
        return Tensor.scalarBytes(this.nativeHandle);
    }

    public <T> T copyTo(T t) {
        this.throwExceptionIfTypeIsIncompatible(t);
        Tensor.readNDArray(this.nativeHandle, t);
        return t;
    }

    public void writeTo(IntBuffer intBuffer) {
        if (this.dtype != DataType.INT32) {
            throw Tensor.incompatibleBuffer(intBuffer, this.dtype);
        }
        ByteBuffer byteBuffer = this.buffer();
        intBuffer.put(byteBuffer.asIntBuffer());
    }

    public void writeTo(FloatBuffer floatBuffer) {
        if (this.dtype != DataType.FLOAT) {
            throw Tensor.incompatibleBuffer(floatBuffer, this.dtype);
        }
        ByteBuffer byteBuffer = this.buffer();
        floatBuffer.put(byteBuffer.asFloatBuffer());
    }

    public void writeTo(DoubleBuffer doubleBuffer) {
        if (this.dtype != DataType.DOUBLE) {
            throw Tensor.incompatibleBuffer(doubleBuffer, this.dtype);
        }
        ByteBuffer byteBuffer = this.buffer();
        doubleBuffer.put(byteBuffer.asDoubleBuffer());
    }

    public void writeTo(LongBuffer longBuffer) {
        if (this.dtype != DataType.INT64) {
            throw Tensor.incompatibleBuffer(longBuffer, this.dtype);
        }
        ByteBuffer byteBuffer = this.buffer();
        longBuffer.put(byteBuffer.asLongBuffer());
    }

    public void writeTo(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = this.buffer();
        byteBuffer.put(byteBuffer2);
    }

    public String toString() {
        return String.format("%s tensor with shape %s", this.dtype.toString(), Arrays.toString(this.shape()));
    }

    static Tensor fromHandle(long l) {
        Tensor tensor = new Tensor();
        tensor.dtype = DataType.fromC(Tensor.dtype(l));
        tensor.shapeCopy = Tensor.shape(l);
        tensor.nativeHandle = l;
        return tensor;
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    private Tensor() {
    }

    private ByteBuffer buffer() {
        return Tensor.buffer(this.nativeHandle).order(ByteOrder.nativeOrder());
    }

    private static IllegalArgumentException incompatibleBuffer(Buffer buffer, DataType dataType) {
        return new IllegalArgumentException(String.format("cannot use %s with Tensor of type %s", new Object[]{buffer.getClass().getName(), dataType}));
    }

    private static IllegalArgumentException incompatibleBuffer(int n, long[] lArray) {
        return new IllegalArgumentException(String.format("buffer with %d elements is not compatible with a Tensor with shape %s", n, Arrays.toString(lArray)));
    }

    private static int numElements(long[] lArray) {
        int n = 1;
        for (int i = 0; i < lArray.length; ++i) {
            n *= (int)lArray[i];
        }
        return n;
    }

    private static int elemByteSize(DataType dataType) {
        switch (dataType) {
            case UINT8: {
                return 1;
            }
            case FLOAT: 
            case INT32: {
                return 4;
            }
            case DOUBLE: 
            case INT64: {
                return 8;
            }
            case BOOL: {
                return 1;
            }
            case STRING: {
                throw new IllegalArgumentException("STRING tensors do not have a fixed element size");
            }
        }
        throw new IllegalArgumentException("DataType " + (Object)((Object)dataType) + " is not supported yet");
    }

    private static DataType dataTypeOf(Object object) {
        if (object.getClass().isArray()) {
            if (Array.getLength(object) == 0) {
                throw new IllegalArgumentException("cannot create Tensors with a 0 dimension");
            }
            Object object2 = Array.get(object, 0);
            if (Byte.class.isInstance(object2) || Byte.TYPE.isInstance(object2)) {
                return DataType.STRING;
            }
            return Tensor.dataTypeOf(object2);
        }
        if (Float.class.isInstance(object) || Float.TYPE.isInstance(object)) {
            return DataType.FLOAT;
        }
        if (Double.class.isInstance(object) || Double.TYPE.isInstance(object)) {
            return DataType.DOUBLE;
        }
        if (Integer.class.isInstance(object) || Integer.TYPE.isInstance(object)) {
            return DataType.INT32;
        }
        if (Long.class.isInstance(object) || Long.TYPE.isInstance(object)) {
            return DataType.INT64;
        }
        if (Boolean.class.isInstance(object) || Boolean.TYPE.isInstance(object)) {
            return DataType.BOOL;
        }
        throw new IllegalArgumentException("cannot create Tensors of " + object.getClass().getName());
    }

    private static int numDimensions(Object object) {
        if (object.getClass().isArray()) {
            Object object2 = Array.get(object, 0);
            if (Byte.class.isInstance(object2) || Byte.TYPE.isInstance(object2)) {
                return 0;
            }
            return 1 + Tensor.numDimensions(object2);
        }
        return 0;
    }

    private static void fillShape(Object object, int n, long[] lArray) {
        if (lArray == null || n == lArray.length) {
            return;
        }
        int n2 = Array.getLength(object);
        if (lArray[n] == 0L) {
            lArray[n] = n2;
        } else if (lArray[n] != (long)n2) {
            throw new IllegalArgumentException(String.format("mismatched lengths (%d and %d) in dimension %d", lArray[n], n2, n));
        }
        for (int i = 0; i < n2; ++i) {
            Tensor.fillShape(Array.get(object, i), n + 1, lArray);
        }
    }

    private void throwExceptionIfTypeIsIncompatible(Object object) {
        if (Tensor.numDimensions(object) != this.numDimensions()) {
            throw new IllegalArgumentException(String.format("cannot copy Tensor with %d dimensions into an object with %d", this.numDimensions(), Tensor.numDimensions(object)));
        }
        if (Tensor.dataTypeOf(object) != this.dtype) {
            throw new IllegalArgumentException(String.format("cannot copy Tensor with DataType %s into an object of type %s", this.dtype.toString(), object.getClass().getName()));
        }
        long[] lArray = new long[this.numDimensions()];
        Tensor.fillShape(object, 0, lArray);
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == this.shape()[i]) continue;
            throw new IllegalArgumentException(String.format("cannot copy Tensor with shape %s into object with shape %s", Arrays.toString(this.shape()), Arrays.toString(lArray)));
        }
    }

    private static native long allocate(int var0, long[] var1, long var2);

    private static native long allocateScalarBytes(byte[] var0);

    private static native void delete(long var0);

    private static native ByteBuffer buffer(long var0);

    private static native int dtype(long var0);

    private static native long[] shape(long var0);

    private static native void setValue(long var0, Object var2);

    private static native float scalarFloat(long var0);

    private static native double scalarDouble(long var0);

    private static native int scalarInt(long var0);

    private static native long scalarLong(long var0);

    private static native boolean scalarBoolean(long var0);

    private static native byte[] scalarBytes(long var0);

    private static native void readNDArray(long var0, Object var2);

    static {
        TensorFlow.init();
    }
}

