/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

final class NameScope {
    private final String opPrefix;
    private final String opName;
    private final Map<String, Integer> ids;
    private static final Pattern NAME_REGEX = Pattern.compile("[A-Za-z0-9.][A-Za-z0-9_.\\-]*");

    NameScope withSubScope(String string) {
        NameScope.checkPattern(NAME_REGEX, string);
        String string2 = this.opName != null ? this.opName : string;
        String string3 = this.fullyQualify(this.makeUnique(string2));
        return new NameScope(string3, null, null);
    }

    NameScope withName(String string) {
        NameScope.checkPattern(NAME_REGEX, string);
        return new NameScope(this.opPrefix, string, this.ids);
    }

    String makeOpName(String string) {
        NameScope.checkPattern(NAME_REGEX, string);
        String string2 = this.opName != null ? this.opName : string;
        return this.fullyQualify(this.makeUnique(string2));
    }

    NameScope() {
        this(null, null, null);
    }

    private NameScope(String string, String string2, Map<String, Integer> map) {
        this.opPrefix = string;
        this.opName = string2;
        this.ids = map != null ? map : new HashMap<String, Integer>();
    }

    private String makeUnique(String string) {
        if (!this.ids.containsKey(string)) {
            this.ids.put(string, 1);
            return string;
        }
        int n = this.ids.get(string);
        this.ids.put(string, n + 1);
        return String.format("%s_%d", string, n);
    }

    private String fullyQualify(String string) {
        if (this.opPrefix != null) {
            return String.format("%s/%s", this.opPrefix, string);
        }
        return string;
    }

    private static void checkPattern(Pattern pattern, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Names cannot be null");
        }
        if (!pattern.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format("invalid name: '%s' does not match the regular expression %s", string, NAME_REGEX.pattern()));
        }
    }
}

