# Delete and stop the service if it already exists.
if (Get-Service timebeat -ErrorAction SilentlyContinue) {
  Stop-Service timebeat
  (Get-Service timebeat).WaitForStatus('Stopped')
  Start-Sleep -s 1
  sc.exe delete timebeat
}

$workdir = Split-Path $MyInvocation.MyCommand.Path

# Create the new service.
New-Service -name timebeat `
  -displayName Timebeat `
  -binaryPathName "`"$workdir\timebeat.exe`" --environment=windows_service -c `"$workdir\timebeat.yml`" --path.home `"$workdir`" --path.data `"$env:PROGRAMDATA\timebeat`" --path.logs `"$env:PROGRAMDATA\timebeat\logs`" -E logging.files.redirect_stderr=true"

# Attempt to set the service to delayed start using sc config.
Try {
  Start-Process -FilePath sc.exe -ArgumentList 'config timebeat start= delayed-auto'
}
Catch { Write-Host -f red "An error occurred setting the service to delayed start." }
