<?php
/**
 * AccessiBe Mixpanel Integration
 *
 * @copyright   Copyright (C) 2023 - present, AccessiBe Ltd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// Load Composer autoloader
$autoloaderPath = __DIR__ . '/vendor/autoload.php';
if (file_exists($autoloaderPath)) {
  require_once $autoloaderPath;
}

class JoomlaMixpanelHandler
{
  private static $instance = null;
  private $config;
  private $mixpanel;

  private function __construct()
  {
    $this->config = $this->getConfig();
    $this->mixpanel = Mixpanel::getInstance('877ee022b7a6795a2a46cc402b91590c', $this->config); // Assuming a Mixpanel PHP SDK is available
  }

  public static function getInstance()
  {
    if (self::$instance === null) {
      self::$instance = new self();
    }
    return self::$instance;
  }

  private function getConfig() {
    // Use Joomla config or fallback to default
    $dashboard_domain = defined('ACCESSIBE_DASHBOARD_DOMAIN') ? ACCESSIBE_DASHBOARD_DOMAIN : 'dashboard.accessibe.com';
    
    $config = [
      'host' => $dashboard_domain,
      'events_endpoint' => '/mixpanel/proxy/track',
      'people_endpoint' => '/mixpanel/proxy/engage',
      'use_ssl' => true,
      'error_callback' => function($err) {
        if ($err) {
          error_log("Mixpanel Error: " . print_r($err, true));
        } else {
          error_log("Mixpanel Success: No error returned");
        }
      }
    ];
    return $config;
  }

  private function addDefaultProps($properties)
  {
    $properties['accessiBeProduct'] = 'Universal Plugin';
    $properties['eventType'] = 'server-side';
    $properties['pluginSource'] = 'Joomla';
    $properties['isReact'] = false;

    return $properties;
  }

  public function trackEvent($eventName, $properties = [])
  {
    if (!$this->mixpanel) {
      error_log("Mixpanel not initialized - dependencies may not be installed");
      return false;
    }

    if (isset($properties['userId'])) {
      $properties['$user_id'] = $properties['userId'];
      //$properties['distinct_id'] = $properties['userId'];
      unset($properties['userId']);
    } 

    if (strpos($eventName, '$') === false) {
      // Add default props only if the event is not system-defined (e.g., $identify)
      $properties = $this->addDefaultProps($properties);
    }

    try {
      $this->mixpanel->track($eventName, $properties);
    } catch (Exception $e) {
      error_log("Mixpanel tracking error: " . $e->getMessage());
      return false;
    } catch (Error $e) {
      error_log("Mixpanel tracking fatal error: " . $e->getMessage());
      return false;
    }
    return true;
  }

  public function isInitialized()
  {
    return $this->mixpanel !== null;
  }

  public function __clone() {}
  public function __wakeup() {}
}