<?php
/**
 * AccessiBe Package Installer Script
 *
 * @copyright   Copyright (C) 2023 - present, AccessiBe Ltd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\InstallerScript;

class pkg_accessibeInstallerScript extends InstallerScript
{
    /**
     * Called before installation/uninstallation
     */
    public function preflight($type, $parent)
    {
        // Log the action
        error_log('ACCESSIBE PACKAGE: Preflight - ' . $type);
        return true;
    }
    
    /**
     * Called after installation/uninstallation
     */
    public function postflight($type, $parent)
    {
        if ($type == 'install' || $type == 'update') {
            error_log('ACCESSIBE PACKAGE: Post-flight - ensuring plugin is enabled');
            
            try {
                // Enable the system plugin
                $db = Factory::getDbo();
                $query = $db->getQuery(true)
                    ->update('#__extensions')
                    ->set('enabled = 1')
                    ->where('element = ' . $db->quote('accessibe'))
                    ->where('folder = ' . $db->quote('system'))
                    ->where('type = ' . $db->quote('plugin'));
                
                $db->setQuery($query);
                $db->execute();
                $link = 'index.php?option=com_accessibe';
                echo '<div class="alert alert-success">
                        <h4>Accessibe Package Installed Successfully!</h4>
                        <p>Ready to configure in Components → Accessibe</p>
                        <p><a href="' . $link . '" class="btn btn-primary">Configure Accessibe Now</a></p>
                      </div>';
            } catch (Exception $e) {
                error_log('ACCESSIBE PACKAGE: Error enabling plugin - ' . $e->getMessage());
            }
        } elseif ($type == 'uninstall') {
            error_log('ACCESSIBE PACKAGE: Package uninstalled successfully');
        }
        
        return true;
    }
    
    /**
     * Called on installation
     */
    public function install($parent)
    {
        error_log('ACCESSIBE PACKAGE: Install method called');
        return true;
    }
    
    /**
     * Called on uninstallation
     */
    public function uninstall($parent)
    {
        error_log('ACCESSIBE PACKAGE: Uninstall method called');
        return true;
    }
    
    /**
     * Called on update
     */
    public function update($parent)
    {
        error_log('ACCESSIBE PACKAGE: Update method called');
        return true;
    }
}