#!/usr/bin/env python
# coding=UTF-8
#

from distutils.command import *
from distutils.core import setup

import os
import subprocess

def my_run(cmd):
  try:
    r=subprocess.call(cmd, shell=True)
    ret=r
  except OSError, e:
    ret=-1

  return(ret)

class _build_py(build_py.build_py):
  def run(self):
    my_run("make -C src/gui")
    build_py.build_py.run(self)

class _clean(clean.clean):
  def run(self):
    my_run("make -C src/gui clean")
    clean.clean.run(self)

setup(
  name		= "katimon",
  version	= '1.0.2',
  author	= 'Stefanos Harhalakis',
  author_email	= 'v13@v13.gr',
  url		= 'http://www.it.teithe.gr/~v13/',
  # py_modules	= ['src/main', 'src/win', 'src/settings', 'src/overclock'],
  # data_files	= [('' , ['src/img/ati_temp_icon-256.png', 'src/img/ati-icon.png'])],
  data_files	= [('/usr/share/applications', ['katimon.desktop'])],
  packages	= ['katimon'],
  package_dir	= {'katimon' : 'src'},
  package_data	= {'katimon' : ['img/ati_temp_icon-256.png', 'img/ati-icon.png']},
  #scripts	= ['src/main.py'],
  scripts	= ['src/katimon'],
  cmdclass	= {'build_py': _build_py, 'clean': _clean},
  )

# vim: set ts=8 sts=2 sw=2 noet formatoptions=r ai nocindent:

