#!/usr/bin/env python
# coding=UTF-8
#
# Copyright 2009 Harhalakis Stefanos <v13@v13.gr>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License or (at your option) version 3 or any later version
# accepted by the membership of KDE e.V. (or its successor approved
# by the membership of KDE e.V.), which shall act as a proxy 
# defined in Section 14 of version 3 of the license.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: config.py 951561 2009-04-09 16:40:14Z sharhalakis $
#

from PyKDE4.kdecore import *
from PyQt4.QtCore import *

class cfg:
  temp_min=63
  temp_max=75
  speed_min=20
  speed_max=100
  automatic=True
  manual_speed=60

  overclock=False
  speed_core=0
  speed_mem=0

  alarm_on=True
  alarm_temp=85

  ignore_fan=False

ati=None

def read():
  global cfg
  global config
  global ati

  #config=KConfig("katitemprc", KConfig.NoGlobals)
  #config=KGlobal.config()
  #config=KConfig

  grp=KConfigGroup(config, "Global")

#  cfg.temp_min=grp.readEntry("temp_min", QVariant(63))
#  cfg.temp_max=grp.readEntry("temp_max", QVariant(75))
#  cfg.automatic=grp.readEntry("automatic", QVariant(True))
#  cfg.manual_speed=grp.readEntry("manual_speed", QVariant(60))

  # Temperature and fan speed control
  cfg.temp_min=grp.readEntry("temp_min", QVariant(cfg.temp_min)).toInt()[0]
  cfg.temp_max=grp.readEntry("temp_max", QVariant(cfg.temp_max)).toInt()[0]
  cfg.speed_min=grp.readEntry("speed_min", QVariant(cfg.speed_min)).toInt()[0]
  cfg.speed_max=grp.readEntry("speed_max", QVariant(cfg.speed_max)).toInt()[0]
  cfg.automatic=grp.readEntry("automatic", QVariant(cfg.automatic)).toBool()
  cfg.manual_speed=grp.readEntry("manual_speed",
    QVariant(cfg.manual_speed)).toInt()[0]
  cfg.ignore_fan=grp.readEntry("ignore_fan", QVariant(cfg.ignore_fan)).toBool()

  # Overclocking
  cfg.overclock=grp.readEntry("overclock", QVariant(cfg.overclock)).toBool()
  cfg.speed_core=grp.readEntry("speed_core",
    QVariant(cfg.speed_core)).toInt()[0]
  cfg.speed_mem=grp.readEntry("speed_mem",
    QVariant(cfg.speed_mem)).toInt()[0]

  # Alarm
  cfg.alarm_on=grp.readEntry("alarm_on", QVariant(cfg.alarm_on)).toBool()
  cfg.alarm_temp=grp.readEntry("alarm_temp",
    QVariant(cfg.alarm_temp)).toInt()[0]

  ati.set_parameters(cfg.temp_min, cfg.temp_max, cfg.speed_min, cfg.speed_max)
  ati.setAutomatic(cfg.automatic)
  ati.setCustomSpeed(cfg.manual_speed)
  ati.set_overclocking(cfg.overclock)
  ati.set_continuousoverclocking(cfg.overclock)
  ati.doInitialOverclocking(cfg.speed_core, cfg.speed_mem)
  ati.setAlarmOn(cfg.alarm_on)
  ati.setAlarmTemp(cfg.alarm_temp)
  ati.setFanIgnore(cfg.ignore_fan)

def write():
  global cfg
  global config

  #config=KConfig("katitemprc", KConfig.NoGlobals)
  #config=KGlobal.config()
  #config=KConfig

  grp=KConfigGroup(config, "Global")

  copy_values(True)

  grp.writeEntry("temp_min", QVariant(cfg.temp_min))
  grp.writeEntry("temp_max", QVariant(cfg.temp_max))
  grp.writeEntry("speed_min", QVariant(cfg.speed_min))
  grp.writeEntry("speed_max", QVariant(cfg.speed_max))
  grp.writeEntry("automatic", QVariant(cfg.automatic))
  grp.writeEntry("manual_speed", QVariant(cfg.manual_speed))
  grp.writeEntry("ignore_fan", QVariant(cfg.ignore_fan))

  grp.writeEntry("overclock", QVariant(cfg.overclock))
  grp.writeEntry("speed_core", QVariant(cfg.speed_core))
  grp.writeEntry("speed_mem", QVariant(cfg.speed_mem))

  grp.writeEntry("alarm_on", QVariant(cfg.alarm_on))
  grp.writeEntry("alarm_temp", QVariant(cfg.alarm_temp))

  grp.config().sync()
  #config.sync()
 
def copy_values(iswrite):
  global  cfg
  global  ati

  cfg.temp_min=ati.min_temp
  cfg.temp_max=ati.max_temp
  cfg.speed_min=ati.min_speed
  cfg.speed_max=ati.max_speed
  cfg.automatic=ati.getAutomatic()
  cfg.manual_speed=ati.getCustomSpeed()
  cfg.ignore_fan=ati.getFanIgnore()

  cfg.overclock=ati.continuousoverclocking

  ai=ati.get_atiinfo()
  cfg.speed_core=ai.getSpeedCoreMax()
  cfg.speed_mem=ai.getSpeedMemMax()

  cfg.alarm_on=ati.getAlarmOn()
  cfg.alarm_temp=ati.getAlarmTemp()

def init(_ati):
  global  ati
  global  config

  config=KConfig()

  ati=_ati

  # Get default values first
  copy_values(False)
  # Then read existing
  read()

def finish():
  # Store data
  write()

# vim: set ts=8 sts=2 sw=2 noet formatoptions=r ai nocindent:

