#!/usr/bin/env python
# coding=UTF-8
#
# Copyright 2009 Harhalakis Stefanos <v13@v13.gr>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License or (at your option) version 3 or any later version
# accepted by the membership of KDE e.V. (or its successor approved
# by the membership of KDE e.V.), which shall act as a proxy 
# defined in Section 14 of version 3 of the license.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: overclock.py 951561 2009-04-09 16:40:14Z sharhalakis $
#

from PyQt4 import uic
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyKDE4.kdeui import *
from PyKDE4.kdecore import i18n

from overclockWin import *

import config

#(Ui_DialogOverclock, x) = uic.loadUiType('gui/overclock.ui')

class Overclock(KDialog, Ui_DialogOverclock):
  def __init__(self, parent, ati):
    KDialog.__init__(self, parent)

    self.setCaption(i18n('Overclocking'))
    #self.setButtons(KDialog::Ok | Kdialog::Cancel)

    w=QWidget(self)
    self.setupUi(self.mainWidget())

    self.setOverclocking(ati.overclocking)
    self.setContinuousOverclocking(ati.continuousoverclocking)

    ai=ati.get_atiinfo()

    self.setSpeeds(ai.getSpeedCoreMax(), ai.getSpeedMemMax())
    r=ai.getSpeedCoreRange()
    self.setCoreRange(r[0], r[1])
    r=ai.getSpeedMemRange()
    self.setMemRange(r[0], r[1])

    self.connect(self, SIGNAL('accepted()'), self.eventAccept)
    self.connect(self.checkBoxEnableOverclocking, SIGNAL('stateChanged(int)'),
      self.eventEnableOverclocking)

    self.ati=ati

  def setSpeeds(self, core, mem):
    self.core_speed=core
    self.mem_speed=mem

    self.spinBoxCorePeakSpeed.setValue(core)
    self.spinBoxMemPeakSpeed.setValue(mem)

  def setCoreRange(self, min, max):
    txt="%d - %d" % (min, max)
    self.labelCorePeakRange.setText(txt)
    self.spinBoxCorePeakSpeed.setRange(min, max)

  def setMemRange(self, min, max):
    txt="%d - %d" % (min, max)
    self.labelMemPeakRange.setText(txt)
    self.spinBoxMemPeakSpeed.setRange(min, max)

  def setOverclocking(self, v):
    if v:
      state=Qt.Checked
    else:
      state=Qt.Unchecked
    self.checkBoxEnableOverclocking.setCheckState(state)
    self.setDisabled(not v)

  def setContinuousOverclocking(self, v):
    if v:
      state=Qt.Checked
    else:
      state=Qt.Unchecked
    self.checkBoxEnableContinuousOverclocking.setCheckState(state)

  # Ask weather overclocking should be enabled
  def askEnableOverclocking(self):
    n=KMessageBox.questionYesNo(self,
      i18n("WARNING!\n"
      "Overclocking may make your system unstable and/or cause data loss!\n"
      "It is even possible to destroy your graphics card or reduce its lifetime!\n"
      "\n"
      "ATI/AMD's Overdrive(TM) disclaimer states:\n"
      "Overclocking to high/maximum clock value cannot be guaranteed to work\n"
      "depending on the actual ASIC.  Hard hangs, corruption, or application\n"
      "failures are valid results that may be observed if a higher clock value\n"
      "is set than the ASIC can handle.\n"
      "\n"
      "If you confirm this you accept that you are the only person responsible for your actions!\n"
      "\n"
      "Are you sure you want to enable overclocking?"),
      i18n("Confirm overclocking"),
      KStandardGuiItem.yes(), KStandardGuiItem.no())

    ret=False
    if n==KMessageBox.Yes:
      ret=True

    return(ret)
  # End of askEnableOverclocking()

  def eventAccept(self):
    global config
    if self.checkBoxEnableOverclocking.checkState()!=Qt.Checked:
      self.ati.set_overclocking(False)
      self.ati.set_continuousoverclocking(False)
      return(True)

    self.ati.set_overclocking(True)

    # Emit an overclocking signal
    if self.checkBoxEnableContinuousOverclocking.checkState()!=Qt.Checked:
      cont=False
    else:
      cont=True

    self.ati.set_continuousoverclocking(cont)

    config.write()

    core=self.spinBoxCorePeakSpeed.value()
    mem=self.spinBoxMemPeakSpeed.value()
    QObject.emit(self, SIGNAL("Overclock(bool, int, int)"), cont, core, mem)
  # End of eventAccept()

  def setDisabled(self, dis):
    self.checkBoxEnableContinuousOverclocking.setCheckState(Qt.Unchecked)
    self.checkBoxEnableContinuousOverclocking.setDisabled(dis)
    self.groupBoxCoreSpeed.setDisabled(dis)
    self.groupBoxMemorySpeed.setDisabled(dis)

  def eventEnableOverclocking(self, value):
    if value==Qt.Checked:
      r=self.askEnableOverclocking()
      if r:
	self.setDisabled(False)
      else:
	self.checkBoxEnableOverclocking.setCheckState(Qt.Unchecked)
    else:
      self.setDisabled(True)

# vim: set ts=8 sts=2 sw=2 noet formatoptions=r ai nocindent:

