#!/usr/bin/env python
# coding=UTF-8
#
# Copyright 2009 Harhalakis Stefanos <v13@v13.gr>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License or (at your option) version 3 or any later version
# accepted by the membership of KDE e.V. (or its successor approved
# by the membership of KDE e.V.), which shall act as a proxy 
# defined in Section 14 of version 3 of the license.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: settings.py 951561 2009-04-09 16:40:14Z sharhalakis $
#

from PyQt4.QtCore import *
from PyKDE4.kdeui import *
from PyKDE4.kdecore import *
#from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import uic
from PyKDE4.kdecore import i18n

from settingsWin import *

import config

# x is the base class but we don't care about that
#(Ui_DialogSettings, x) = uic.loadUiType('gui/settings.ui')

class Settings(KDialog, Ui_DialogSettings):
  def __init__(self, parent, ati):
    KDialog.__init__(self, parent)

    self.setCaption(i18n('Settings'))
    #self.setButtons(KDialog::Ok | Kdialog::Cancel)

    w=QWidget(self)
    self.setupUi(self.mainWidget())

    self.spinBoxTemperatureMinimum.setValue(ati.min_temp)
    self.spinBoxTemperatureMaximum.setValue(ati.max_temp)
    self.horizontalSliderSpeedMinimum.setValue(ati.min_speed/10)
    self.horizontalSliderSpeedMaximum.setValue(ati.max_speed/10)
    self.spinBoxSpeedMinimum.setValue(ati.min_speed)
    self.spinBoxSpeedMaximum.setValue(ati.max_speed)
    self.checkBoxIgnoreFan.setChecked(ati.getFanIgnore())

    self.checkBoxAlarm.setChecked(config.cfg.alarm_on)
    self.spinBoxAlarm.setValue(config.cfg.alarm_temp)

    self.connect(self, SIGNAL('accepted()'), self.eventAccepted)

    self.connect(self.horizontalSliderSpeedMinimum, SIGNAL('valueChanged(int)'),
      self.eventHsSpeedMinChange)
    self.connect(self.horizontalSliderSpeedMaximum, SIGNAL('valueChanged(int)'),
      self.eventHsSpeedMaxChange)

    self.connect(self.spinBoxSpeedMinimum, SIGNAL('valueChanged(int)'),
      self.eventSbSpeedMinChange)
    self.connect(self.spinBoxSpeedMaximum, SIGNAL('valueChanged(int)'),
      self.eventSbSpeedMaxChange)

    self.connect(self.checkBoxIgnoreFan, SIGNAL('stateChanged(int)'),
      self.eventCbIgnoreFanChange)

    self.ati=ati

    if not self.ati.monitorFan():
      self.groupBoxFanSpeed.setDisabled(True)

    # Disable FAN settings if there is not Fan and force "Ignore Fan"
    ai=ati.get_atiinfo()
    if not ai.hasFanDetect():
      self.checkBoxIgnoreFan.setChecked(True)
      self.checkBoxIgnoreFan.setDisabled(True)

    # Handle autostart
    self.initAutostart()

    if self.getAutostart():
      self.checkBoxAutostart.setChecked(True)
    else:
      self.checkBoxAutostart.setChecked(False)

  def eventAccepted(self):
    global config

    min_temp=self.spinBoxTemperatureMinimum.value()
    max_temp=self.spinBoxTemperatureMaximum.value()
    min_speed=self.horizontalSliderSpeedMinimum.value()*10
    max_speed=self.horizontalSliderSpeedMaximum.value()*10

    alarm_on=self.checkBoxAlarm.isChecked()
    alarm_temp=self.spinBoxAlarm.value()

    #print("%d %d %d %d" % (min_temp, max_temp, min_speed, max_speed))
    self.ati.set_parameters(min_temp, max_temp, min_speed, max_speed)

    self.ati.setAlarmOn(alarm_on)
    self.ati.setAlarmTemp(alarm_temp)

    self.ati.setFanIgnore(self.checkBoxIgnoreFan.isChecked())

    config.write()

    self.applyAutostart2(self.checkBoxAutostart.isChecked())
    # Without the following line, autostart settings are not stored
    # This is most probably because of a circular reference between this
    # class and the kas object. This most probably disallows kas from being
    # deleted and thus the changes aren't stored in the disk (!)
    self.kas=None

  def eventHsSpeedMinChange(self, value):
    self.spinBoxSpeedMinimum.setValue(value*10)
    
  def eventHsSpeedMaxChange(self, value):
    self.spinBoxSpeedMaximum.setValue(value*10)

  def eventSbSpeedMinChange(self, value):
    v=(value+5)/10
    self.horizontalSliderSpeedMinimum.setValue(v)
    self.spinBoxSpeedMinimum.setValue(v*10)

  def eventSbSpeedMaxChange(self, value):
    v=(value+5)/10
    self.horizontalSliderSpeedMaximum.setValue(v)
    self.spinBoxSpeedMaximum.setValue(v*10)

  def eventCbIgnoreFanChange(self, state):
    v=self.checkBoxIgnoreFan.isChecked()
    self.groupBoxFanSpeed.setDisabled(v)

  def getAutostart(self):
    return self.kas.autostarts()

  def applyAutostart2(self, on):
    self.kas.setAutostarts(on)

  def initAutostart(self):
    kas=KAutostart('katimon')
    if not KAutostart.isServiceRegistered("katimon"):
      ad=KGlobal.mainComponent().aboutData()
      kas.setVisibleName(ad.programName())
      kas.setCommand(ad.appName())
      kas.setStartPhase(kas.Applications)
      kas.setAllowedEnvironments(["KDE", "GNOME"])
    self.kas=kas
  # End of _get_kas

# vim: set ts=8 sts=2 sw=2 noet formatoptions=r ai nocindent:

