#!/usr/bin/env python
# coding=UTF-8
#
# Copyright 2009 Harhalakis Stefanos <v13@v13.gr>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License or (at your option) version 3 or any later version
# accepted by the membership of KDE e.V. (or its successor approved
# by the membership of KDE e.V.), which shall act as a proxy 
# defined in Section 14 of version 3 of the license.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: win.py 954985 2009-04-16 17:28:46Z sharhalakis $
#

import sys
#from PyQt4 import uic
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyKDE4.kdecore import *
from PyKDE4.kdeui import *
#from PyKDE4.kfile import *
#from mainWin import *
from PyQt4.Qwt5 import *
from settings import *
from overclock import *

from mainWin import *

import config
import time
import os

#(Ui_Main, x) = uic.loadUiType('gui/main.ui')

class Main(KMainWindow, Ui_Main):
  def __init__(self, name, kapp, ati):
    KMainWindow.__init__(self)
    #Ui_Main.__init__(self, None, name)

    #self.rootWidget=QWidget(self)
    #rootWidget=QWidget(self)

    Ui_Main.__init__(self)
    self.setupUi(self)

    self.do_real_close=False

    self.data_temp=[]
    self.data_speed=[]
    self.data_gpu=[]
    self.data_speed_core=[]
    self.data_time=[]
    for i in xrange(0,100):
      self.data_temp.append(-10)
      self.data_speed.append(-10)
      self.data_gpu.append(-10)
      self.data_speed_core.append(-10)
      self.data_time.append(i-100)

    self.qwtPlot.enableAxis(0)
    self.qwtPlot.enableAxis(1)
    self.qwtPlot.enableAxis(2, False)

    self.qwtPlot2.enableAxis(0)
    self.qwtPlot2.enableAxis(1)
    self.qwtPlot2.enableAxis(2, False)
    #self.qwtPlot2.enableAxis(1)

    #self.setCentralWidget(self.rootWidget)

    #MainWin.__init__(self)

    self.kapp=kapp
    self.ati=ati

    # We will need this
    #pixmap=QPixmap(22, 22)
    #self.icon=QIcon(pixmap)

    self.mk_icon(80, 50, 50)

    self.init_window()

    self.connect(self.fileQuitAction, SIGNAL('triggered()'), self.close_real)

    self.connect(self.editSettingsAction, SIGNAL('triggered()'),
      self.do_settings)

    self.connect(self.editOverclockingAction, SIGNAL('triggered()'),
      self.do_overclocking)

    self.connect(self.horizontalSliderFanSpeed, SIGNAL('valueChanged(int)'),
      self.eventSpeedChanged)

    self.connect(self.radioButtonSpeedAutomatic, SIGNAL('pressed()'),
      self.eventSetSpeedAutomatic)

    self.connect(self.radioButtonSpeedManual, SIGNAL('pressed()'),
      self.eventSetSpeedManual)

#    self.connect(self.helpAboutAction, SIGNAL('triggered()'),
#      self.showAboutApplication)

  def init_window(self):
    self.add_tray()

    hlp=self.helpMenu()
    self.menuWidget().addMenu(hlp)

  def add_tray(self):
    self.tray=KSystemTrayIcon(self)

    # Set icon
    action=QAction(i18n("ATI GPU Monitor"), self.tray)
    title=self.tray.setContextMenuTitle(action)

    # Add menu
    self.traymenu=self.tray.contextMenu()

    # Call the quit function even on kapp.quit messages
    self.connect(self.tray, SIGNAL('quitSelected()'), self.kapp.quit)

    self.tray.setIcon(self.icon)
    self.tray.show()

  # ------------------------------------------------------------------------

  def mk_icon(self, perc, cpu, temp):
    columns=3
    sz_x=22
    sz_y=22
    column_width=sz_x / columns
    border_alpha=64
    bg_alpha=32

    i=QPixmap(sz_x, sz_y)

    pnt=QPainter()

    i.fill(QColor(0,0,0))

    pnt.begin(i)

    steps=10

    l_width=2

    y_bottom=0
    y_max=22
    height=y_max-y_bottom

    # Make a list of those.
    dt=[perc, cpu, temp]
    labels=['F', 'C', 'T']

    # Calculate columns/values
    # y_top[0]=y_max - (perc * y_max / 100)
    # y_top[1]=y_max - (cpu * y_max / 100)
    # y_top[2]=y_max - (temp * y_max / 100)

    # Store the values
    y_top=[]
    for n in xrange(columns):
      if dt[n]<0:
	t=y_max
      else:
	t=y_max - (dt[n] * y_max / 100)
      y_top.append(t)

    # This will hold column data
    coldata=[]
    for n in xrange(columns):
      d=n*column_width
      x1=d
      x2=d+column_width-1
      coldata.append({'d':d, 'x1': x1, 'x2': x2})

    for n in xrange(columns):
      coldata[n]['col']=None

    # A gray color
    colgray=QColor(128, 128, 128, bg_alpha)

    r=0
    g=255
    for y in xrange(21, 0, -1*(l_width+1)):
      t_perc=1.0*(height-y)/height
      last_r=r
      last_g=g
      r=min(255, 255*t_perc*1.5)
      g=255 - (255*t_perc)

      col=QColor(r, g, 0)

      for n in xrange(columns):
	if y<y_top[n]:
	  if coldata[n]['col']==None:
	    coldata[n]['col']=QColor(last_r, last_g, 0, border_alpha)
	  #col2=colgray
	  if dt[n]==-1:
	    col2=colgray
	  else:
	    col2=colgray
	    # col2=QColor(r, g, 0, bg_alpha)
	else:
	  if dt[n]==-1:
	    col2=colgray
	  else:
	    col2=col

	pen=QPen(col2, l_width)
	pnt.setPen(pen)

	d=coldata[n]['d']
	x1=coldata[n]['x1']+1+1
	x2=coldata[n]['x2']-1
	pnt.drawLine(x1, y, x2, y)


    for n in xrange(columns):
      if dt[n]==-1:
	coldata[n]['col']=QColor(192, 192, 192, border_alpha)
      elif coldata[n]['col']==None:
	coldata[n]['col']=QColor(255, 0, 0, border_alpha)

    # Dray rectangle
    for n in xrange(columns):
      col=coldata[n]['col']
      pen=QPen(col, 1)
      pnt.setPen(pen)
      d=coldata[n]['d']
      x1=coldata[n]['x1']
      x2=coldata[n]['x2']
      y1=0
      y2=sz_y-1
#      r=QRectF(x1, y1, x2-x1, y2-y1)
#      pnt.drawRoundRect(r, 20, 20)
      pnt.drawLine(x1, y1+1, x1, y2-1)
      pnt.drawLine(x2, y1+1, x2, y2-1)
      pnt.drawLine(x1+1, y1, x2-1, y1)
      pnt.drawLine(x1+1, y2, x2-1, y2)

    # End of rectangle

#    fnt=QFont('sans-serif', 5, 1)
#    pnt.setFont(fnt)
#    for n in xrange(columns):
#      x1=coldata[n]['x1']
#      pnt.drawText(QPointF(x1+1, sz_y/2+4), labels[n])

    pnt.end()

    i.setMask(i.createHeuristicMask())

    self.icon=QIcon(i)
  # End of mk_icon

  def init_visuals(self):
    self.progressTemperature.setMaximum(self.ati.max_temp)
    self.progressTemperature.setMinimum(self.ati.min_temp)

    self.progressCurrentSpeed.setMinimum(0)
    self.progressCurrentSpeed.setMaximum(100)

    self.progressTargetSpeed.setMinimum(0)
    self.progressTargetSpeed.setMaximum(100)

    self.progressGPUUsage.setMinimum(0)
    self.progressGPUUsage.setMaximum(100)

    # TODO: Load these
    self.radioButtonSpeedAutomatic.setChecked(self.ati.getAutomatic())
    self.radioButtonSpeedManual.setChecked(not self.ati.getAutomatic())
    #self.horizontalSliderFanSpeed.setDisabled(True)
    self.horizontalSliderFanSpeed.setValue(self.ati.getCustomSpeed()/10)
    self.labelCustomSpeed.setText("%d%%" % self.ati.getCustomSpeed())

    self.init_visuals_graph()

    if not self.ati.monitorFan():
      self.set_no_fan(True)

  # End of init_visuals()

  # Initialize the graph
  def init_visuals_graph(self):
    pen=QPen()
    pen.setWidth(2)
    pen.setCapStyle(Qt.RoundCap)
    pen.setJoinStyle(Qt.RoundJoin)

    legend=QwtLegend(self)
    legend2=QwtLegend(self)

    pen.setColor(QColor(255,0,0))
    curve=QwtPlotCurve(i18n("Temperature"))
    curve.setData(self.data_time, self.data_temp)
    curve.attach(self.qwtPlot)
    curve.setPen(pen)
    li=QwtLegendItem(QwtSymbol(), pen, QwtText(i18n("Temperature")), self)
    legend.insert(curve, li)
    self.curveTemperature=curve

    pen.setColor(QColor(0,0,200))
    curve=QwtPlotCurve(i18n("Fan Speed"))
    curve.setData(self.data_time, self.data_speed)
    curve.attach(self.qwtPlot)
    curve.setPen(pen)
    li=QwtLegendItem(QwtSymbol(), pen, QwtText(i18n("Fan Speed")), self)
    legend.insert(curve, li)
    self.curveSpeed=curve

    pen.setColor(QColor(64,192,64))
    curve=QwtPlotCurve(i18n("GPU Usage"))
    curve.setData(self.data_time, self.data_gpu)
    curve.attach(self.qwtPlot2)
    curve.setPen(pen)
    li=QwtLegendItem(QwtSymbol(), pen, QwtText(i18n("GPU Usage")), self)
    legend2.insert(curve, li)
    self.curveGpuload=curve

    pen.setColor(QColor(0,100,200))
    curve=QwtPlotCurve(i18n("Core Speed"))
    curve.setData(self.data_time, self.data_speed_core)
    curve.attach(self.qwtPlot2)
    curve.setPen(pen)
    li=QwtLegendItem(QwtSymbol(), pen, QwtText(i18n("GPU Usage")), self)
    legend2.insert(curve, li)
    self.curveSpeedCore=curve

    #self.qwtPlot.setTitle('Temperature')
    #self.qwtPlot.setTitleLabel(ki18n('Temperature-oo'))

    font=self.qwtPlot.axisFont(0)
    font.setPointSize(9)

    qwttxt=QwtText()
    qwttxt.setFont(font)

    self.qwtPlot.setAxisFont(0, font)
    self.qwtPlot.setAxisFont(1, font)
    self.qwtPlot2.setAxisFont(0, font)
    self.qwtPlot2.setAxisFont(1, font)

    self.qwtPlot.setAxisScale(0, self.ati.min_temp,
      self.ati.max_temp, 2)
    qwttxt.setText(i18n('Temperature (ºC)'))
    self.qwtPlot.setAxisTitle(0, qwttxt)

    self.qwtPlot.setAxisScale(1, 0, 100, 20)
    qwttxt.setText(i18n('Fan Speed (%)'))
    self.qwtPlot.setAxisTitle(1, qwttxt)

    self.qwtPlot2.setAxisScale(0, 0, 100, 20)
    qwttxt.setText(i18n('GPU Usage (%)'))
    self.qwtPlot2.setAxisTitle(0, qwttxt)

    #self.qwtPlot2.setAxisScale(1, 0, 100, 20)
    qwttxt.setText(i18n('Core Speed (MHz)'))
    self.qwtPlot2.setAxisTitle(1, qwttxt)

    self.qwtPlot.insertLegend(legend, QwtPlot.BottomLegend)
    self.qwtPlot2.insertLegend(legend2, QwtPlot.BottomLegend)
  # End of init_visuals_graph()

  # Disable controlls when there is no fan
  # True: no fan, False: with fan
  def set_no_fan(self, value):
    self.lCDCurrentSpeed.setDisabled(value)
    self.progressCurrentSpeed.setDisabled(value)
    self.progressTargetSpeed.setDisabled(value)
    self.groupBoxFanControl.setDisabled(value)

  def set_visual(self):
    ai=self.ati.get_atiinfo()
    temp=ai.getTemperature()
    target_speed=self.ati.target_speed
    cpu=ai.getGPULoad()
    if self.ati.getFanIgnore():
      speed=-1
    else:
      speed=ai.getFanSpeed()

    temp_perc=100 * (temp - self.ati.min_temp) / \
      (self.ati.max_temp - self.ati.min_temp)

    self.mk_icon(speed, cpu, temp_perc)
    self.tray.setIcon(self.icon)

    #self.lCDTemperature.setProperty("value", QVariant(temp))
    self.lCDTemperature.display(temp)
    self.lCDCurrentSpeed.display(speed)
    self.lCDTargetSpeed.display(int(self.ati.target_speed))
    self.lCDGPUUsage.display(cpu)

    # TODO:
    self.lCDClockSpeedCurrent.display(ai.getSpeedCore())
    self.lCDClockSpeedMax.display(ai.getSpeedCoreMax())
    self.lCDMemorySpeedCurrent.display(ai.getSpeedMem())
    self.lCDMemorySpeedMax.display(ai.getSpeedMemMax())

    self.progressTemperature.setValue(temp)
    self.progressCurrentSpeed.setValue(speed)
    self.progressTargetSpeed.setValue(target_speed)
    self.progressGPUUsage.setValue(cpu)

    txt=i18n(
      "ATI Card #%1\n\nFan speed: %2%\nGPU load: %3%\nTemperature: %4ºC",
      self.ati.index, speed, cpu, temp)
    txt+="\n\n"
    txt+=i18n(
      "Columns from left to right are: \nFan speed, GPU load, Temperature")

    #QToolTip.add(self.tray, txt)
    self.tray.setToolTip(txt)
 
  def eventSetSpeedAutomatic(self):
    self.setSpeedAutomatic()

  def eventSetSpeedManual(self):
    self.setSpeedManual()

  def eventSpeedChanged(self, value):
    speed=int(value)*10
    self.labelCustomSpeed.setText("%d%%" % speed)

    if self.ati.getAutomatic():
      self.ati.setCustomSpeed(speed)
      return

    self.setSpeedManual()

  def setSpeedAutomatic(self):
    if self.ati.getAutomatic():
      return

    # print "Automatic"
    #self.horizontalSliderFanSpeed.setDisabled(True)
    self.ati.setAutomatic(True)
  # End of setSpeedAutomatic()

  # Apply manual speed
  def setSpeedManual(self):
    auto=self.ati.getAutomatic()
    old_speed=self.ati.getCustomSpeed()
    new_speed=self.horizontalSliderFanSpeed.value()*10

    # If it is already manual and there is no speed change, return
    if not auto and old_speed==new_speed:
      return

    # If there is an automatic -> manual change
    if auto:
      #self.horizontalSliderFanSpeed.setDisabled(False)
      self.ati.setAutomatic(False)

    self.ati.setCustomSpeed(new_speed)

    self.ati.applyCustomSpeed()
  # End of setSpeedManual()

  def showAlarmError(self, temp):
    msg=i18n("""
<h1>ALERT</h1>
<h2>The temperature of your graphics card has reached the alarm limit!</h2>
<b>This is a serious problem.</b><br/><br/>
The current temperature is %1 ºC. Overheating may reduce the lifetime of your 
graphics card or even destroy it. It is even possible to start a fire!<br/>
<br/>
<u>You should investigate this IMMEDIATELY, and perhaps turn off your computer 
to allow the graphics card to cool.</u><br/>
<br/>
The overheating may be caused by a fan having stopped working effectively, 
either due to mechanical failure or an accumulation of dust, 
or from overclocking without adequate cooling.<br/>
If you have not overclocked your graphics card then you should inspect its 
fan (if one is fitted).<br/><br/>
The following graphics cards are known to have fan issues:
<ul>
<li>ASUS EAH4870: Fan control circuit dies during the first 6 months of
operation (based on Internet reports.)</li>
</ul>
""", temp)

    msg="<html>"+msg+"</html>"
    title=i18n("Temperature alarm!")

    KMessageBox.queuedMessageBox(self, KMessageBox.Error, msg, title,
      KMessageBox.Option(KMessageBox.Notify)) # | KMessageBox.Dangerous))
  # End of showAlarmError()

  def timerEvent(self):
    self.ati.run_once()

    ai=self.ati.get_atiinfo()
    temp=ai.getTemperature()
    speed=ai.getFanSpeed()
    gpuload=ai.getGPULoad()
    t=time.time()

    self.data_temp.append(temp)
    if self.ati.monitorFan():
      self.data_speed.append(speed)
    else:
      self.data_speed.append(0)
    self.data_gpu.append(gpuload)
    self.data_speed_core.append(ai.speed_core)
    #self.data_time.append(t)

    if len(self.data_temp)>len(self.data_time):
      self.data_temp=self.data_temp[2:]
      self.data_speed=self.data_speed[2:]
      self.data_gpu=self.data_gpu[2:]
      self.data_speed_core=self.data_speed_core[2:]
      #self.data_time=self.data_time[2:]

    curve=self.curveTemperature
    curve.setYAxis(0)
    curve.setData(self.data_time, self.data_temp)

    curve=self.curveSpeed
    curve.setYAxis(1)
    curve.setData(self.data_time, self.data_speed)

    curve=self.curveGpuload
    curve.setYAxis(0)
    curve.setData(self.data_time, self.data_gpu)

    curve=self.curveSpeedCore
    curve.setYAxis(1)
    curve.setData(self.data_time, self.data_speed_core)

    self.qwtPlot2.setAxisScale(1, 0, ai.getSpeedCoreMax())

    self.qwtPlot.replot()
    self.qwtPlot2.replot()

    self.set_visual()

    if self.ati.isAlarm():
      alarm_temp=self.ati.getAlarmTemp()
      self.show()
      self.activateWindow()

      # TODO: Someone who knows how, should make the default of the alarm
      # just play a sound. The popup is overkill because there is an error
      # message too.
      n=KNotification("temperature_alarm", self,
	KNotification.NotificationFlag(KNotification.Persistent))
#	  KNotification.CloseWhenWidgetActivated))
      msg=i18n(
	"The temperature of your graphics card has reached the alarm limit!",
	alarm_temp)
      n.setText(msg)
      n.beep()
      n.setActions(QStringList(i18n("Acknowledge")))
      n.sendEvent()
      self.showAlarmError(alarm_temp)
#      n.close()
#      self.notificationAlarm=n

  def init_timer(self):
    self.timer=QTimer(self)
    self.timer.connect(self.timer, SIGNAL('timeout()'), self.timerEvent)
    self.timer.setSingleShot(False)
    self.timer.start(3000)

  def close_real(self):
    self.do_real_close=True
    self.kapp.quit()

  def queryClose(self):
    if not self.do_real_close:
      self.hide()
      return(False)
    return(True)

  def do_settings(self):
    s=Settings(self, self.ati)
    self.connect(s, SIGNAL("accepted()"), self.eventSettingsFinish)
    s.show()

  def do_overclocking(self):
    s=Overclock(self, self.ati)

    s.connect(s, SIGNAL("Overclock(bool, int, int)"), self.eventOverclock)
    s.show()

  def eventOverclock(self, cont, core, mem):
    global cfg

    self.ati.set_overclock(core, mem)

  def eventSettingsFinish(self):
    # Change Temperature limits at the graph
    self.qwtPlot.setAxisScale(0, self.ati.min_temp,
      self.ati.max_temp, 2)
    # Handle ignore_fan changes
    self.set_no_fan(not self.ati.monitorFan())
    # Change scale of progress bars
    self.progressTemperature.setMaximum(self.ati.max_temp)
    self.progressTemperature.setMinimum(self.ati.min_temp)


# End of class Main()

class AtiApplication(KApplication):
  def __init__(self, ati):
    KApplication.__init__(self)

    self.setWindowIcon(QIcon())

    self.ati=ati

    self.main=Main('Test', self, ati)
    self.setTopWidget(self.main)

    #self.main.show()

  def welcome(self):
    msgnew=KMessageBox.information(self.main,
      i18n("<html><b>Welcome to the ATI GPU Monitor (KAtiMon)</b><br/><br/>" 
      "This is a KDE program for monitoring and controlling some aspects of your ATI graphics card.<br/>" 
      "You can access KAtiMon by clicking on its system tray icon.<br/><br/>" 
      "<u>Note that this program is NOT developed by ATI/AMD: please do not send them any bug reports.</u><br/></html>"),
      "KAtiMon",
      "welcome")

  def check_fan(self):
    ai=self.ati.get_atiinfo()
    if ai.hasFanDetect():
      return

    msg=KMessageBox.information(self.main,
      i18n("<html>It seems that your graphics card does not have a fan, "
      "or that it is not possible to control it using the aticonfig tool.<br/>"
      "The fan controlling and monitoring capability of this program "
      "has been disabled.<br/><br/>"
      "If this is incorrect, please send a bug report.</html>"),
      i18n("No fan"),
      "nofan")

  def doit(self):
    self.main.init_visuals()
    self.main.timerEvent()
    self.main.init_timer()
    self.welcome()
    self.check_fan()
    self.exec_()

  def quit(self):
    ati_finish=True

    if self.ati.monitorFan():
      t=self.ati.getInitialSpeed()
      KMessageBox.information(self.main,
	i18n("When this program exits it restores the fan speed "
	"to its original value (i.e. the speed that was set when the "
	"program was started).<br/>"
	"This only happens when you use the auto-fan speed feature, "
	"which is the default.<br/>"
	"If you want to set a specific fan speed, set it manually "
	"before closing the program.<br/><br/>"
	"The fan speed will be restored to %1%.", t),
	i18n("Fan speed restoration"),
	"fan_speed_restore"
	)

    # Ask for keeping the custom speed
    if self.ati.monitorFan() and not self.ati.getAutomatic():
      m=KMessageBox.questionYesNoCancel(None,
	i18n("The current fan speed has been set manually. "
	"Normally, the program restores the fan to the speed "
	"at which it was originally operating when the program was started. "
	"Alternatively, you can keep your manual fan speed setting.\n\n"
	"Do you want to restore the original fan speed?"),
	i18n("Confirm fan speed setting"),
	KStandardGuiItem.yes(),
	KStandardGuiItem.no(),
	KStandardGuiItem.cancel(),
	)

      if m==KMessageBox.Yes:
	ati_finish=True
      elif m==KMessageBox.No:
	ati_finish=False
      elif m==KMessageBox.Cancel:
	return(False)

    if ati_finish:
      self.ati.finish()
      # print "Finish!"

    config.finish()

    KApplication.quit(self)
  # End of quit()

def init(ati):
  global  kapp
  global  main

  appname="katimon"
  programname=ki18n("ATI GPU Monitor")
  version="1.0.2"
  shortdescription=ki18n(
    "ATI Temperature Monitor, Fan Regulator and Overclocking Utility")
  licensetype=KAboutData.License_GPL_V3
  copyright=ki18n("Copyright (c) 2009 Stefanos Harhalakis")
  text=ki18n("This is an utility that monitors and controls supported ATI graphics cards. It can:<ul><li>monitor temperature, fan speed, GPU speed and memory speed;<li>auto-control fan speed by monitoring the temperature;<li>act as an overclocking utility for cards that support it.</ul><p>Created with python, pyqt, pykde4 and pyqwt.<p>Have fun using it and be careful when overclocking.")
  homepage="http://www.it.teithe.gr/~v13/"
  email="v13@v13.gr"

  about=KAboutData(appname, "", programname, version, shortdescription,
    licensetype, copyright, text, homepage, email)

  about.addAuthor(ki18n("Stefanos Harhalakis"), ki18n("Main developer"),
    "v13@v13.gr", "http://www.v13.gr/")

  path0=os.path.dirname(__file__)
  about.setProgramLogo(QVariant(QImage(path0+"/img/ati_temp_icon-256.png")))

  KCmdLineArgs.init(sys.argv, about)
  #kapp=KApplication(sys.argv, "Test")
  kapp=AtiApplication(ati)

#  main=Main('Test', kapp, ati);

#  kapp.setTopWidget(main)
  #kapp.setTopWidget(main.widget)
  #main.widget.show()
#  main.show()

def doit():
  global  kapp
  
  kapp.doit()
#  main.timerEvent()
#  main.init_timer()
#  kapp.exec_()

# vim: set ts=8 sts=2 sw=2 noet formatoptions=r ai nocindent:

