/****************************************/
/*					*/
/****************************************/
/* Start      : 13/10/2002		*/
/* Version    : 1.00			*/
/* Last Update: 13/10/2002		*/
/****************************************/

/*
  Copyright (c) 2002 Stefanos Harhalakis

  This file is part of netinfo.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define _DB_CC
#include "db.h"
#include "conf.h"

#define TBL_NETDEVS	"netdevs"
#define TBL_INTERFACES	"interfaces"
#define TBL_MACS	"macs"
#define TBL_IPS		"ips"

#include "v/mem/longline.h"
#include "v/misc/keytable2.cc"

BASEDB	db;

int	add_netdev(int type, const char *name, const char *ip, const char *community)
{
	char	buf[1000];
	INT4	ret;
	
	sprintf(buf,"INSERT INTO %s(ip,dev_type,name,community)"
			"VALUES ('%s','%d','%s','%s')",
			TBL_NETDEVS,
			ip, type, name, community);
			
	ret=db.Exec(buf);
	
	return(ret);
}

int	add_interface(const char *ip, int ifindex, const char *descr, const char *alias, int ifinternal, int has_netdev)
{
	char	buf[1000];
	INT4	ret;
	
	sprintf(buf,"INSERT INTO %s(netdev_ip, ifindex, description, alias, ifinternal, has_netdev)"
			"VALUES ('%s','%d','%s','%s','%d','%d')",
			TBL_INTERFACES,
			ip, ifindex, descr, alias, ifinternal, has_netdev);
			
	ret=db.Exec(buf);
	
	return(ret);
}

int	add_mac(const char *ip, int ifindex, const char *mac)
{
	char	buf[1000];
	INT4	ret;
	
	sprintf(buf,"INSERT INTO %s(mac, netdev_ip, ifindex)"
			"VALUES ('%s','%s','%d')",
			TBL_MACS,
			mac, ip, ifindex);
			
	ret=db.Exec(buf);
	
	return(ret);
}

int	add_ips(const char *ip, const char *mac, const char *netdev_ip, int ifindex)
{
	char	buf[1000];
	INT4	ret;
	
	sprintf(buf,"INSERT INTO %s(ip, mac, netdev_ip, ifindex)"
			"VALUES ('%s','%s','%s','%d')",
			TBL_IPS,
			ip, mac, netdev_ip, ifindex);
			
	ret=db.Exec(buf);
	
	return(ret);
}

void	clear_tables()
{
	char	buf[1000];

#define KOKO(x)	sprintf(buf,"DELETE FROM %s", x); db.Exec(buf);
//	KOKO(TBL_NETDEVS)
	KOKO(TBL_INTERFACES)
	KOKO(TBL_MACS)
	KOKO(TBL_IPS)
#undef KOKO
}

/*
	Return: 1: OK, 0: Error
*/
int	connect_db()
{
	int	ret;
	
	ret=db.Connect(NULL, conf.dbname.p, conf.dbuser.p, conf.dbpass.p);
	
	return(ret);
}

int	close_db()
{
	db.Disconnect();
}

#define CURS	"curs1"
int	get_netdevs()
{
	char		tmp[1000];
	const char	*p;
	NETDEV		ndev;
	LONGLINE	ip;
	
	sprintf(tmp,"SELECT ip, community, dev_type FROM %s",
		TBL_NETDEVS);

	netdevs.ClearTable();
		
	db.Begin();
	db.DeclareCursor(CURS,tmp);
	while (db.Fetch(CURS)>0)
	{
		p=db.GetValue(0,0);
		if (p!=NULL)
		{
			ip=p;
			
			p=db.GetValue(0,1);
			ndev.community=p;
			
			p=db.GetValue(0,2);
			ndev.type=atoi(p);
			
			netdevs.Add(ip,ndev);
		}
	}
	db.End();
}
#undef CURS




