/****************************************/
/*					*/
/****************************************/
/* Start      : 13/10/2002		*/
/* Version    : 1.00			*/
/* Last Update: 13/10/2002		*/
/****************************************/

/*
  Copyright (c) 2002 Stefanos Harhalakis

  This file is part of netinfo.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _DB_H
#define _DB_H

#include "basedb.h"

int	add_netdev	(int type, const char *name, const char *ip, const char *community);
int	add_interface	(const char *ip, int ifindex, const char *descr, const char *alias, int ifinternal=-1, int has_netdev=-1);
int	add_mac		(const char *ip, int ifindex, const char *mac);
int	add_ips		(const char *ip, const char *mac, const char *netdev_ip, int ifindex);
void	clear_tables	();
int	connect_db	();
int	close_db	();
int	get_netdevs	();

#ifndef _DB_CC
extern BASEDB	db;
#endif


#endif

