/****************************************/
/*					*/
/****************************************/
/* Start      : 12/10/2002		*/
/* Version    : 1.00			*/
/* Last Update: 12/10/2002		*/
/****************************************/

/*
  Copyright (c) 2002 Stefanos Harhalakis

  This file is part of netinfo.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _SNMP_H
#define _SNMP_H

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>

#include "v/mem/longline.h"
#include "v/mem/strlist.h"
#include "v/misc/keytable2.h"
#include "v/misc/nkeytable.h"

enum	device_type { router=1, l2_switch=2 };

// MAC Addresses(strings) use capitals for hex numbers

// L2 switch interface
struct	L2S_IFACE
{
	int		internal;	// internal interface number
	int		ifindex;	// interface index number
	LONGLINE	descr;		// description
	LONGLINE	alias;		// alias
//	KEYTABLE<int>	macs;		// MAC addresses - key is mac address (string). value is port number
	STRLIST		macs;		// MAC addresses
	int		has_netdev;	// 1: If there is a router/switch on this port
};

struct	ROUTER_IFACE
{
	int			ifindex;
	LONGLINE		descr;
	LONGLINE		alias;	// alias
//	KEYTABLE<LONGLINE>	ips;	// Table if ip addresses - key is mac address (string). value is ip(string)
	KEYTABLE<STRLIST>	ips;	// Table if ip addresses - key is mac address (string). value is ip(string)
};

struct	DEVICE_DATA
{
	device_type	type;
	LONGLINE	addr;
	LONGLINE	community;
	snmp_session	session, *psession;
	oid		root_oid[MAX_OID_LEN];
	size_t		root_oid_len;
	oid		cur_oid[MAX_OID_LEN];
	size_t		cur_oid_len;
	struct ROUTER
	{
		int			status;	// current state. -1: Error, 0: Begin,
						//	1: Wait interface descriptions, 2: Got it
						//	3: Wait ip->mac, 4: Got it
						//	100: Finished

		NKEYTABLE<ROUTER_IFACE>	ifaces;
	} router;

	struct L2_SWITCH
	{
		int			status;	// current state. -1: Error, 0: Begin, 
						//	1: Wait interface descriptions, 2: Got it
						//	3: Wait interface internal numbers, 4: Got it
						//	5: Wait mac-address types (learned etd), 6: Got it
						//	7: Wait mac-address ports, 8: Got it
						//	100: Finished
		NKEYTABLE<L2S_IFACE>	ifaces;	// index is interface index number
		KEYTABLE<int>		macs_tmp;	// temp for mac addresses. store mac type. key is mac(string). value is type

		L2S_IFACE *get_internal(int internal)
		{
			L2S_IFACE	*piface;
			u_32		pkey;

			ifaces.Rewind();
			while ((pkey=ifaces.Get_Next())!=NK_INVALID)
			{
				piface=ifaces[pkey];
				if (piface->internal==internal)
					return(piface);
			}

			return(NULL);
		}
	} l2_switch;
};

int snmp_main();

#endif


