CREATE OR REPLACE VIEW view_interfaces AS
	SELECT n.id			AS netdev_id,
		n.ip			AS netdev_ip,
		n.name			AS netdev_name,
		n.flags			AS netdev_flags,

		i.id			AS ifid,
		i.description		AS ifdescr,
		i.alias			AS ifalias,
		i.last_had_netdev	AS last_had_netdev,
		i.ts			AS if_ts,
		i.flags			AS if_flags,
		i.shortdesc		AS if_shortdesc

		FROM netdevs n, interfaces i
		WHERE n.id=i.netdev_id
		ORDER BY netdev_name,
			substring(i.description from '^[^0-9]*'),
			('0' || substring(substring(i.description from '[0-9]*/') from '[0-9]*'))::integer,
			('0' || substring(i.description from '[0-9]*$'))::integer
;

CREATE OR REPLACE VIEW view_macs AS
	SELECT * FROM macs
		LEFT JOIN ( SELECT prefix, name AS vendor FROM vendors ) vendors
			ON trunc(macs.mac)=vendors.prefix
;

CREATE OR REPLACE VIEW view_ips AS
	SELECT * FROM ips
		LEFT JOIN ( SELECT ip, hostname FROM res_cache ) rcache
			USING(ip)
;

CREATE OR REPLACE VIEW view_all AS
	SELECT macs.mac			AS mac,
		macs.ifid		AS ifid,
		macs.ts			AS mac_ts,
		macs.flags		AS mac_flags,
		macs.shortdesc		AS mac_shortdesc,
		macs.description	AS mac_description,

		vendors.name		AS mac_vendor,

		ips.ip			AS ip,
		ips.ts			AS ip_ts,

		view_interfaces.netdev_id,
		view_interfaces.netdev_ip,
		view_interfaces.netdev_name,
		view_interfaces.netdev_flags,

		view_interfaces.ifdescr,
		view_interfaces.ifalias,
		view_interfaces.last_had_netdev,
		view_interfaces.if_ts,
		view_interfaces.if_flags,
		view_interfaces.if_shortdesc

		FROM macs
		LEFT JOIN ips ON macs.mac=ips.mac
		LEFT JOIN view_interfaces ON view_interfaces.ifid=macs.ifid
		LEFT JOIN vendors ON trunc(macs.mac)=vendors.prefix
;

CREATE OR REPLACE VIEW view_all_allmacs AS
	SELECT allmacs.mac		AS mac,
		allmacs.ifid		AS ifid,
		allmacs.ts		AS mac_ts,

		macs.flags		AS mac_flags,
		macs.shortdesc		AS mac_shortdesc,
		macs.description	AS mac_description,

		vendors.name		AS mac_vendor,

		ips.ip			AS ip,
		ips.ts			AS ip_ts,

		view_interfaces.netdev_id,
		view_interfaces.netdev_ip,
		view_interfaces.netdev_name,
		view_interfaces.netdev_flags,

		view_interfaces.ifdescr,
		view_interfaces.ifalias,
		view_interfaces.last_had_netdev,
		view_interfaces.if_ts,
		view_interfaces.if_flags,
		view_interfaces.if_shortdesc

		FROM allmacs
		LEFT JOIN ips ON allmacs.mac=ips.mac
		LEFT JOIN view_interfaces ON view_interfaces.ifid=allmacs.ifid
		LEFT JOIN vendors ON trunc(allmacs.mac)=vendors.prefix
		LEFT JOIN macs ON allmacs.mac=macs.mac
;

CREATE OR REPLACE VIEW view_history AS
	SELECT
		history.ip,
		history.mac,
		history.ifid		AS ifid,
		history.ts,
		history.ignore_ts	AS hist_ignore_ts,
		history.flags		AS hist_flags,

		view_macs.shortdesc	AS mac_shortdesc,
		view_macs.description	AS mac_description,

		view_macs.vendor	AS mac_vendor,

		view_interfaces.netdev_id,
		view_interfaces.netdev_ip,
		view_interfaces.netdev_name,
		view_interfaces.netdev_flags,

		view_interfaces.ifdescr,
		view_interfaces.ifalias,
		view_interfaces.last_had_netdev,
		view_interfaces.if_ts,
		view_interfaces.if_flags,
		view_interfaces.if_shortdesc

		FROM history
		LEFT JOIN view_macs ON view_macs.mac=history.mac
		LEFT JOIN view_interfaces ON view_interfaces.ifid=history.ifid
;

--
-- History without the filtered entries
--
CREATE OR REPLACE VIEW view_history_not_filtered AS
	SELECT * FROM view_history h
		WHERE (h.hist_flags IS NULL OR
			(((h.hist_flags & X'02'::INTEGER) <> X'02'::INTEGER ) AND
				(((h.hist_flags & X'01'::INTEGER) <> X'01'::INTEGER) OR (h.hist_ignore_ts<h.ts)))) AND
			NOT EXISTS ( SELECT * FROM monitor_filters m
				WHERE
					((h.ip>=m.ip_from AND h.ip<=m.ip_to) OR
						(h.ip<<=m.ip_mask) OR
						(m.ip_from IS NULL AND m.ip_mask IS NULL)) AND
					(h.mac=m.mac OR m.mac IS NULL) AND
					(h.ifid=m.ifid OR m.ifid IS NULL) AND
					(h.netdev_id=m.netdev_id OR m.netdev_id IS NULL)
				LIMIT 1
			)
;

-- Current entries
-- Those that are know for the last 5 hours
CREATE OR REPLACE VIEW view_current AS
	SELECT *
		FROM view_all
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - mac_ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - ip_ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - if_ts) < 18000
;

CREATE OR REPLACE VIEW view_current_allmacs AS
	SELECT *
		FROM view_all_allmacs
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - mac_ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - ip_ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - if_ts) < 18000
;

--CREATE OR REPLACE VIEW view_interfaces_info_old AS
--	SELECT * ,
--		( SELECT 1 WHERE (v.if_flags & X'01'::INTEGER) = X'01'::INTEGER ) AS assoc_macs,
--		( SELECT 1 WHERE (v.if_flags & X'02'::INTEGER) = X'02'::INTEGER ) AS assoc_ips,
--		( SELECT 1 WHERE (v.if_flags & X'10'::INTEGER) = X'10'::INTEGER ) AS is_routed,
--		( SELECT 1 WHERE (v.if_flags & X'20'::INTEGER) = X'20'::INTEGER ) AS do_locking,
--		( SELECT 1 WHERE (v.if_flags & X'40'::INTEGER) = X'40'::INTEGER ) AS is_changed,
--		( SELECT 1 WHERE (v.if_flags & X'80'::INTEGER) = X'80'::INTEGER ) AS is_added,
--		( SELECT 1 WHERE (v.if_flags & X'100'::INTEGER) = X'100'::INTEGER ) AS is_locked,
--		( SELECT 1 WHERE (last_had_netdev>0)) AS has_netdev,
--		( SELECT COUNT(mac) FROM macs WHERE ifid=v.ifid ) AS mac_cnt,
--		( SELECT COUNT(mac) FROM allmacs WHERE ifid=v.ifid ) AS allmac_cnt,
--		( SELECT COUNT(ip) FROM macs LEFT JOIN ips USING(mac) WHERE ifid=v.ifid ) AS ip_cnt
--		
--		FROM view_interfaces v
--;

CREATE OR REPLACE VIEW view_interfaces_info AS
	SELECT v.*,
		( CASE WHEN ((v.if_flags & X'001'::INTEGER)>0) THEN 1 ELSE NULL END ) AS assoc_macs,
		( CASE WHEN ((v.if_flags & X'002'::INTEGER)>0) THEN 1 ELSE NULL END ) AS assoc_ips,
		( CASE WHEN ((v.if_flags & X'010'::INTEGER)>0) THEN 1 ELSE NULL END ) AS is_routed,
		( CASE WHEN ((v.if_flags & X'020'::INTEGER)>0) THEN 1 ELSE NULL END ) AS do_locking,
		( CASE WHEN ((v.if_flags & X'040'::INTEGER)>0) THEN 1 ELSE NULL END ) AS is_changed,
		( CASE WHEN ((v.if_flags & X'080'::INTEGER)>0) THEN 1 ELSE NULL END ) AS is_added,
		( CASE WHEN ((v.if_flags & X'100'::INTEGER)>0) THEN 1 ELSE NULL END ) AS is_locked,
		( CASE WHEN ((v.if_flags & X'200'::INTEGER)>0) THEN 1 ELSE NULL END ) AS is_hunted,
		( CASE WHEN (v.last_had_netdev>0) THEN 1 ELSE NULL END ) AS has_netdev,
		mac_cnt, allmac_cnt, ip_cnt

		FROM view_interfaces v
		LEFT JOIN ( SELECT ifid, COUNT(mac) AS mac_cnt FROM macs GROUP BY ifid ) m USING(ifid)
		LEFT JOIN ( SELECT ifid, COUNT(mac) AS allmac_cnt FROM allmacs GROUP BY ifid ) am USING(ifid)
		LEFT JOIN ( SELECT ifid, COUNT(ip) AS ip_cnt FROM macs LEFT JOIN ips USING(mac) GROUP BY ifid ) ips USING(ifid)
;

CREATE OR REPLACE VIEW view_netdevs_info AS
	SELECT *
		FROM netdevs n
		LEFT JOIN 
			( SELECT n.id,
				COUNT(v.ifid)		AS if_cnt,
				COUNT(v.assoc_macs)	AS assoc_macs_cnt,
				COUNT(v.assoc_ips)	AS assoc_ips_cnt,
				COUNT(v.is_routed)	AS is_routed_cnt,
				COUNT(v.do_locking)	AS do_locking_cnt,
				COUNT(v.is_changed)	AS is_changed_cnt,
				COUNT(v.is_added)	AS is_added_cnt,
				COUNT(v.is_locked)	AS is_locked_cnt,
				COUNT(v.is_hunted)	AS is_hunted_cnt,
				COUNT(v.has_netdev)	AS has_netdev_cnt,
				SUM(v.mac_cnt)		AS mac_cnt,
				SUM(v.allmac_cnt)	AS allmac_cnt,
				SUM(v.ip_cnt)		AS ip_cnt

				FROM netdevs n
				LEFT JOIN view_interfaces_info v ON v.netdev_id=n.id

				GROUP BY(n.id) ) n2
			USING(id)
;

--CREATE OR REPLACE VIEW view_netdevs_info_old AS
--	SELECT *,
--		(SELECT COUNT(*) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id) AS if_cnt,
--		(SELECT COUNT(*) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id AND v.assoc_macs=1) AS assoc_macs_cnt,
--		(SELECT COUNT(*) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id AND v.assoc_ips=1) AS assoc_ips_cnt,
--		(SELECT COUNT(*) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id AND v.is_routed=1) AS is_routed_cnt,
--		(SELECT COUNT(*) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id AND v.do_locking=1) AS do_locking_cnt,
--		(SELECT COUNT(*) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id AND v.is_changed=1) AS is_changed_cnt,
--		(SELECT COUNT(*) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id AND v.is_added=1) AS is_added_cnt,
--		(SELECT COUNT(*) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id AND v.is_locked=1) AS is_locked_cnt,
--		(SELECT COUNT(*) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id AND v.has_netdev=1) AS has_netdev_cnt,
--		(SELECT SUM(mac_cnt) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id) AS mac_cnt,
--		(SELECT SUM(allmac_cnt) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id) AS allmac_cnt,
--		(SELECT SUM(ip_cnt) FROM view_interfaces_info v
--			WHERE n.id=v.netdev_id) AS ip_cnt
--
--		FROM netdevs n
--;

--CREATE OR REPLACE VIEW view_hist_toadd_old AS
--	SELECT h.ip, h.mac, h.ifid,
--		( CASE WHEN assoc_ip2mac.ip IS NULL THEN NULL ELSE 1 END ) AS exists_ip2mac,
--		( CASE WHEN assoc_ip2iface.ip IS NULL THEN NULL ELSE 1 END ) AS exists_ip2iface,
--		( CASE WHEN assoc_mac2iface.mac IS NULL THEN NULL ELSE 1 END ) AS exists_mac2iface,
--		( CASE WHEN v.ip IS NULL THEN NULL ELSE 1 END ) AS is_current,
--
--		view_ips.shortdesc		AS ip_shortdesc,
--		view_ips.hostname		AS ip_hostname,
--		view_macs.shortdesc		AS mac_shortdesc,
--		view_macs.vendor		AS mac_vendor,
--		view_interfaces.netdev_name	AS netdev_name,
--		view_interfaces.if_shortdesc	AS if_shortdesc,
--		view_interfaces.ifdescr		AS ifdescr,
--		view_interfaces.ifalias		AS ifalias
--		
--		FROM history h
--		LEFT JOIN view_ips USING(ip)
--		LEFT JOIN view_macs ON h.mac=view_macs.mac
--		LEFT JOIN view_interfaces ON h.ifid=view_interfaces.ifid
--		LEFT JOIN assoc_ip2mac ON h.ip=assoc_ip2mac.ip AND h.mac=assoc_ip2mac.mac
--		LEFT JOIN assoc_ip2mac a2m_sub ON h.ip<<=a2m_sub.ip AND h.mac=a2m_sub.mac
--		LEFT JOIN assoc_ip2iface ON h.ip=assoc_ip2iface.ip AND h.ifid=assoc_ip2iface.ifid
--		LEFT JOIN assoc_ip2iface a2i_sub ON h.ip<<=a2i_sub.ip AND h.ifid=a2i_sub.ifid
--		LEFT JOIN assoc_mac2iface ON h.mac=assoc_mac2iface.mac AND h.ifid=assoc_mac2iface.ifid
--		LEFT JOIN view_current v ON h.ip=v.ip AND h.mac=v.mac AND h.ifid=v.ifid
--;

--
-- View for 'Related history entries' - For reg_edit
--
CREATE OR REPLACE VIEW view_hist_toadd AS
	SELECT a.*,
		( CASE WHEN assoc_mac2iface.mac IS NULL THEN NULL ELSE 1 END ) AS exists_mac2iface,
		( CASE WHEN v.ip IS NULL THEN NULL ELSE 1 END ) AS is_current,
		view_ips.shortdesc		AS ip_shortdesc,
		view_ips.hostname		AS ip_hostname,
		view_macs.shortdesc		AS mac_shortdesc,
		view_macs.vendor		AS mac_vendor,
		view_interfaces.netdev_name	AS netdev_name,
		view_interfaces.if_shortdesc	AS if_shortdesc,
		view_interfaces.ifdescr		AS ifdescr,
		view_interfaces.ifalias		AS ifalias

		FROM (
			SELECT h.ip, h.mac, h.ifid,
				( CASE WHEN COUNT(assoc_ip2mac.ip) > 0 THEN 1 ELSE NULL END ) AS exists_ip2mac,
				( CASE WHEN COUNT(assoc_ip2iface.ip) > 0 THEN 1 ELSE NULL END ) AS exists_ip2iface

				FROM history h
				LEFT JOIN assoc_ip2mac ON h.ip<<=assoc_ip2mac.ip AND h.mac=assoc_ip2mac.mac
				LEFT JOIN assoc_ip2iface ON h.ip<<=assoc_ip2iface.ip AND h.ifid=assoc_ip2iface.ifid
				GROUP BY h.ip, h.mac, h.ifid
		) a
		LEFT JOIN view_ips USING(ip)
		LEFT JOIN view_macs ON a.mac=view_macs.mac
		LEFT JOIN view_interfaces ON a.ifid=view_interfaces.ifid
		LEFT JOIN assoc_mac2iface ON a.mac=assoc_mac2iface.mac AND a.ifid=assoc_mac2iface.ifid
		LEFT JOIN view_current v ON a.ip=v.ip AND a.mac=v.mac AND a.ifid=v.ifid
;

--CREATE OR REPLACE VIEW view_hist_toadd_very_old AS
--	SELECT h.ip, h.mac, h.ifid,
--		( SELECT 1 WHERE EXISTS
--			( SELECT * FROM assoc_ip2mac a WHERE a.ip=h.ip AND a.mac=h.mac LIMIT 1) ) AS exists_ip2mac,
--		( SELECT 1 WHERE EXISTS
--			( SELECT * FROM assoc_ip2iface a WHERE a.ip=h.ip AND a.ifid=h.ifid LIMIT 1) ) AS exists_ip2iface,
--		( SELECT 1 WHERE EXISTS
--			( SELECT * FROM assoc_mac2iface a WHERE a.mac=h.mac AND a.ifid=h.ifid LIMIT 1) ) AS exists_mac2iface,
--		( SELECT 1 WHERE EXISTS
--			( SELECT * FROM view_current v WHERE v.ip=h.ip AND v.mac=h.mac AND v.ifid=h.ifid LIMIT 1) ) AS is_current,
--		view_ips.shortdesc		AS ip_shortdesc,
--		view_ips.hostname		AS ip_hostname,
--		view_macs.shortdesc		AS mac_shortdesc,
--		view_macs.vendor		AS mac_vendor,
--		view_interfaces.netdev_name	AS netdev_name,
--		view_interfaces.if_shortdesc	AS if_shortdesc,
--		view_interfaces.ifdescr		AS ifdescr,
--		view_interfaces.ifalias		AS ifalias
--		
--		FROM history h
--		LEFT JOIN view_ips USING(ip)
--		LEFT JOIN view_macs ON h.mac=view_macs.mac
--		LEFT JOIN view_interfaces ON h.ifid=view_interfaces.ifid
--;

-- views for policies
--

--
-- Interfaces with enabled locking
-- that are not routed and don't have a netdev
--
CREATE OR REPLACE VIEW view_policy_interfaces AS
	SELECT * FROM interfaces i
		WHERE (i.flags & X'20'::INTEGER) = X'20'::INTEGER AND
			(i.flags & X'10'::INTEGER) <> X'10'::INTEGER AND
			last_had_netdev=0
;

--
-- Interfaces that require to be locked
-- Interfaces with do_locking which have assoc_macs or have auto-locked
--
CREATE OR REPLACE VIEW view_policy_interfaces_tolock AS
	SELECT * FROM view_policy_interfaces i
		WHERE ( i.flags & X'01'::INTEGER ) > 0 OR
			( i.flags & X'100'::INTEGER ) > 0
;

CREATE OR REPLACE VIEW view_policy_violators AS
-- Macs: Assoc IPs only - with unassociated IPs
	SELECT DISTINCT mac,1 AS vtype FROM macs m
		LEFT JOIN ips i USING(mac)
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - m.ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - i.ts) < 18000 AND
			(m.flags & X'01'::INTEGER) = X'01'::INTEGER AND
			NOT EXISTS ( SELECT mac FROM assoc_ip2mac a WHERE a.mac=m.mac AND a.ip=i.ip )
	UNION
-- Macs: Assoc Ifaces only - with unassociated Interface
	SELECT mac,2 AS vtype FROM macs m
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - m.ts) < 18000 AND
			(m.flags & X'02'::INTEGER) = X'02'::INTEGER AND
			NOT EXISTS (SELECT mac FROM assoc_mac2iface a WHERE a.mac=m.mac AND a.ifid=m.ifid)
	UNION
-- IPs: Assoc macs only -- with unassociated macs
	SELECT mac,3 AS vtype FROM ips
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - ips.ts) < 18000 AND
			(ips.flags & X'01'::INTEGER) = X'01'::INTEGER AND
			NOT EXISTS ( SELECT mac FROM assoc_ip2mac a WHERE a.mac=ips.mac AND a.ip>>=ips.ip)
	UNION
-- IPs: Assoc ifaces only -- with unassociated interfaces
	SELECT DISTINCT mac,4 AS vtype FROM ips
		LEFT JOIN macs m USING(mac)
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - ips.ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - m.ts) < 18000 AND
			(ips.flags & X'02'::INTEGER) = X'02'::INTEGER AND
			NOT EXISTS ( SELECT ifid FROM assoc_ip2iface a WHERE m.ifid=a.ifid AND a.ip=ips.ip)
	UNION
-- Subnets: Assoc macs only -- with unassociated macs
	SELECT mac,9 AS vtype FROM subnets
		LEFT JOIN ips ON ips.ip<<=subnets.ip
		WHERE (subnets.flags & X'01'::INTEGER) = X'01'::INTEGER AND
			NOT EXISTS ( SELECT mac FROM assoc_ip2mac a WHERE a.mac=ips.mac AND a.ip>>=ips.ip)
	UNION
-- Subnets: Assoc ifaces only -- with unassociated interfaces
	SELECT DISTINCT mac,10 AS vtype FROM subnets
		LEFT JOIN ips ON ips.ip<<=subnets.ip
		LEFT JOIN macs m USING(mac)
		WHERE (subnets.flags & X'02'::INTEGER) = X'02'::INTEGER AND
			NOT EXISTS ( SELECT ifid FROM assoc_ip2iface a WHERE m.ifid=a.ifid AND a.ip>>=ips.ip)
	UNION
-- Interfaces: Assoc macs only -- with unassociated macs
	SELECT DISTINCT mac,5 AS vtype FROM macs m
		LEFT JOIN interfaces i ON m.ifid=i.id
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - m.ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - i.ts) < 18000 AND
			(i.flags & X'01'::INTEGER) = X'01'::INTEGER AND
			(i.flags & X'200'::INTEGER) = 0 AND
			NOT EXISTS ( SELECT mac FROM assoc_mac2iface a WHERE a.mac=m.mac AND a.ifid=m.ifid)
	UNION
-- Interfaces: Assoc ips only -- with unassociated ips
	SELECT DISTINCT mac,6 AS vtype FROM ips
		LEFT JOIN macs m USING(mac)
		LEFT JOIN interfaces i ON m.ifid=i.id
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - m.ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - i.ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - ips.ts) < 18000 AND
			(i.flags & X'02'::INTEGER) = X'02'::INTEGER AND
			(i.flags & X'200'::INTEGER) = 0 AND
			NOT EXISTS ( SELECT ip FROM assoc_ip2iface a WHERE a.ip>>=ips.ip AND a.ifid=m.ifid )
	UNION
-- Hunt interfaces: Assoc macs only -- with unassociated macs -- only get last 5min entries from allmacs
	SELECT DISTINCT mac,7 AS vtype FROM allmacs m
		LEFT JOIN interfaces i ON m.ifid=i.id
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - m.ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - i.ts) < 18000 AND
			(i.flags & X'01'::INTEGER) = X'01'::INTEGER AND
			(i.flags & X'200'::INTEGER) = X'200'::INTEGER AND
			i.last_had_netdev > 0 AND
			NOT EXISTS ( SELECT mac FROM assoc_mac2iface a WHERE a.mac=m.mac AND a.ifid=m.ifid) AND
			m.ts >= ( SELECT to_number(value,'9999999999') FROM config WHERE name='last_run')-60
	UNION
-- Hunt interfaces: Assoc ips only -- with unassociated ips -- only get last 5min entries from allmacs
	SELECT DISTINCT mac,8 AS vtype FROM ips
		LEFT JOIN allmacs m USING(mac)
		LEFT JOIN interfaces i ON m.ifid=i.id
		WHERE (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - ips.ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - m.ts) < 18000 AND
			(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - i.ts) < 18000 AND
			(i.flags & X'02'::INTEGER) = X'02'::INTEGER AND
			(i.flags & X'200'::INTEGER) = X'200'::INTEGER AND
			i.last_had_netdev > 0 AND
			NOT EXISTS ( SELECT ip FROM assoc_ip2iface a WHERE a.ip>>=ips.ip AND a.ifid=m.ifid ) AND
			m.ts >= ( SELECT to_number(value,'9999999999') FROM config WHERE name='last_run')-60
;

--
-- Macs per interface excluding blacklisted - for maclocking
--
-- Macs for interfaces with 'do_locking and associated MACs only'
-- plus Macs for interfaces with 'do_locking and policy violations'
-- except blacklisted MACs
--

CREATE OR REPLACE VIEW view_policy_ifmacs AS
-- auto-locked
	SELECT ifid, mac
		FROM macs m
		LEFT JOIN interfaces i ON m.ifid=i.id
-- do_locking, auto-locked, not blacklisted
		WHERE ( i.flags & X'20'::INTEGER ) >0 AND
			( i.flags & X'100'::INTEGER ) >0 AND
			( m.flags & X'100'::INTEGER ) =0 AND
			NOT EXISTS ( SELECT mac FROM blacklist b WHERE b.mac=m.mac )
	UNION
-- associated
	SELECT ifid, mac
		FROM assoc_mac2iface a
		LEFT JOIN interfaces i ON  a.ifid=i.id
-- do_locking, associated MACs, not blacklisted
		WHERE ( i.flags & X'20'::INTEGER ) >0 AND
			( i.flags & X'01'::INTEGER ) > 0 AND
			NOT EXISTS ( SELECT mac FROM blacklist b WHERE b.mac=a.mac )
;

--
-- Helper for maclock script
--
-- Select devices with do_locking
--

CREATE OR REPLACE VIEW view_ml_tolock AS
	SELECT ip, ml_uname, ml_t_pass, ml_en_pass,
		( SELECT 1 WHERE
			( ((EXTRACT(EPOCH FROM CURRENT_TIMESTAMP)) - ml_last_try) > 115200) OR
			ml_last_try IS NULL ) AS is_old,
		id
		FROM netdevs
		WHERE ( ml_t_pass IS NOT NULL AND
			ml_en_pass IS NOT NULL AND
			ml_t_pass <> '' AND
			ml_en_pass <> '' ) AND
			( flags & X'08'::INTEGER ) > 0
;

