<?

/*
	HTTP Vars (for gen_lookup):

	netdev_id
	ip
	mac
	netdev_id
	ifid

	$me: How to reference self script. Only needed for lookup_type 3

	$lookup_type:
		1: Search view_current
		2: Search view_all
		3: Search view_history
	$grouping:
		1: ip
		2: mac
		3: ifid
*/

/*
	Return 1 when nothing is done
*/
function do_hist_edit($ip, $mac, $ifid, $me)
{
	global $db;

	$linkme="$me&gl_action=edit&gl_ip=$ip&gl_mac=$mac&gl_ifid=$ifid";

	$gle_action=pget("gle_action");
	$gle_ignore=pget("gle_ignore");
	$gle_shortdesc=pget("gle_shortdesc");
	$gle_comments=pget("gle_comments");

	if ($gle_action=="Return")
		return 1;

	if ($gle_ignore!="")
	{
		$cmd="SELECT flags FROM history WHERE ip='$ip' AND mac='$mac' AND ifid='$ifid'";
		$res=pg_query($db, $cmd);
		$r=pg_fetch_row($res,0);

		$fl=$r[0];
		$fl&=~(0x03);

		if ($gle_ignore=="once")
			$fl|=0x01;
		else if ($gle_ignore=="forever")
			$fl|=0x02;

		if ($fl & 0x03)
		{
			$for_ts="ignore_ts='".time()."'";
		} else
		{
			$for_ts="ignore_ts=NULL";
		}

		$cmd="UPDATE history SET flags='$fl', shortdesc=".nov($gle_shortdesc).
			", comments=".nov($gle_comments).", $for_ts";
/*		$t=time();
		if ($fl!="") $cmd.=", ignore_ts=$t";*/
		$cmd.=" WHERE ip='$ip' AND mac='$mac' AND ifid='$ifid'";

		pg_query($db,$cmd);
	}

	$cmd="SELECT hostname FROM res_cache WHERE ip='$ip';";
	$res=pg_query($db,$cmd);
	if ($res)
	{
		$num=pg_num_rows($res);
		if ($num>0)
		{
			$r=pg_fetch_row($res,0);
			$hostname=$r[0];
		} else $hostname="";
	} else $hostname="";

	$cmd="SELECT vendor, h.ts, h.flags, ignore_ts, h.shortdesc, h.comments".
		" FROM history h".
		" LEFT JOIN view_macs USING(mac)".
		" WHERE h.ip='$ip' AND h.ifid='$ifid' AND h.mac='$mac';";
	$res=pg_query($db,$cmd);
	$r=pg_fetch_row($res,0);
	$mac_vendor=$r[0];
	$ts=$r[1];
	$flags=$r[2];
	$ignore_ts=$r[3];
	$shortdesc=$r[4];
	$comments=$r[5];

	$cmd="SELECT netdev_id, shortdesc, description, alias FROM interfaces WHERE id='$ifid'";
	$res=pg_query($db, $cmd);
	$r=pg_fetch_row($res,0);

	$if_shortdesc=$r[1];
	$ifdescr=$r[2];
	$ifalias=$r[3];

	$cmd="SELECT name,ip FROM netdevs WHERE id='$r[0]'";
	$res=pg_query($db, $cmd);
	$r=pg_fetch_row($res,0);

	$netdev_name=$r[0];
	$netdev_ip=$r[1];
?>
<BR>
<FORM METHOD="POST" ACTION="<? echo $linkme; ?>">
<TABLE style="width:80%; margin:auto;">
	<TR>
		<TD style="width: 60%; text-align: center;">
<TABLE class="edit">
<THEAD>
	<TR>
		<TD COLSPAN="2">
			History entry
		</TD>
	</TR>
</THEAD>
<TBODY>
	<TR>
		<TD class="label"> IP: </TD>
		<TD class="data"> <? echo $ip; ?> </TD>
	</TR>
<? if ($hostname!="")
	{ ?>
	<TR>
		<TD class="label"> Hostname: </TD>
		<TD class="data"> <? echo $hostname; ?> </TD>
	</TR>
<?	} ?>
	<TR>
		<TD class="label"> MAC: </TD>
		<TD class="data"> <? echo $mac; ?> </TD>
	</TR>
	<TR>
		<TD class="label"> NIC vendor: </TD>
		<TD class="data"> <? echo $mac_vendor; ?> </TD>
	</TR>
	<TR>
		<TD class="label"> Device: </TD>
		<TD class="data"> <? echo "$netdev_name ($netdev_ip)"; ?> </TD>
	</TR>
	<TR>
		<TD class="label"> Interface: </TD>
		<TD class="data"> <? echo $ifdescr; if ($ifalias!="") echo " ($ifalias)";?> </TD>
	</TR>
<? if ($if_shortdesc!="")
	{ ?>
	<TR>
		<TD class="label"> Interface description: </TD>
		<TD class="data"> <? echo $if_shortdesc; ?> </TD>
	</TR>
<?	} ?>
	<TR>
		<TD class="label"> Last seen: </TD>
		<TD class="data"> <? $s=date("r",$ts); echo $s; ?> </TD>
	</TR>
	<TR>
		<TD class="label"> Ignored: </TD>
		<TD class="data"> <?
			if (($flags & 0x02) || (($flags & 0x01) && ($ignore_ts>=$ts) ))
			{
				echo "Yes";
			} else
			{
				echo "No";
			}
		?> </TD>
	</TR>
	<TR>
		<TD class="label"> Short comment: </TD>
		<TD class="data">
			<INPUT TYPE="TEXT" NAME="gle_shortdesc" VALUE="<? echo $shortdesc; ?>">
		</TD>
	</TR>
</TBODY>
</TABLE>
		</TD>
		<TD style="vertical-align: top; text-align: left;">
			<TABLE style="margin: 0pt auto auto 0pt;">
				<TR style="height: 50%">
					<TD>
						<B>
							Ignore this entry:
						</B>
					</TD>
					<TD>
			<SELECT NAME="gle_ignore">
				<OPTION VALUE="no" <? if (!($flags & 0x03)) echo "selected"; ?>> No </OPTION>
				<OPTION VALUE="once" <? if (($flags & 0x01) && ($ignore_ts>$ts)) echo "selected"; ?>> Once </OPTION>
				<OPTION VALUE="forever" <? if ($flags & 0x02) echo "selected";?>> Forever </OPTION>
			</SELECT>
					</TD>
				</TR>
			</TABLE>
			<BR><BR><BR>
			<INPUT TYPE="SUBMIT" NAME="gle_action" VALUE="Apply" style="width: 100%"><BR><BR>
			<INPUT TYPE="SUBMIT" NAME="gle_action" VALUE="Return" style="width: 100%">
		</TD>
	</TR>
</TABLE>
<DIV class="hr" style="width: 70%;"> </DIV>
<DIV class="comments">
	<DIV> <B> Comments: </B> <DIV>
	<TEXTAREA NAME="gle_comments" class="comment"><? echo $comments; ?></TEXTAREA>
</DIV>
<DIV class="hr" style="width: 70%;"> </DIV>
</FORM>
<?
	return 0;
}


require("regcommon.inc");

/*
	filtered: don't count ignored entries
*/
function do_gen_lookup($lookup_type, $me, $title, $extra="", $grouping=0, $filtered=0)
{
	global $db;

	$ip=trim(pget("ip"));
	$mac=trim(pget("mac"));
	$netdev_id=pget("netdev_id");
	$ifid=pget("ifid");

	$linkme="$me&ip=$ip&mac=$mac&netdev_id=$netdev_id&ifid=$ifid";

	$gl_action=pget("gl_action");
	$gl_ip=pget("gl_ip");
	$gl_mac=pget("gl_mac");
	$gl_ifid=pget("gl_ifid");

	if ($gl_action=="delete")
	{
		$cmd="DELETE FROM history WHERE ip='$gl_ip' AND mac='$gl_mac' AND ifid='$gl_ifid'";
		pg_query($db,$cmd);
	} else if ($gl_action=="edit")
	{
		if (do_hist_edit($gl_ip, $gl_mac, $gl_ifid, $linkme)!=1)
			return;
	}

	switch($lookup_type)
	{
		case 1: $tbl="view_current"; /* $title="Last 5 hours"; */ break;
		case 2: $tbl="view_all"; /* $title="Current state"; */ break;
		case 3: $tbl="view_history"; /* $title="History data"; */ break;
	}

	pg_query($db,"BEGIN");
/*
	0		1		2		3		4
	ip		ip_shortdesc	hostname	-		-
+5	-		-		-		-		-
+10	mac		mac_shortdesc	mac_vendor	-		-
+15	-		-		-		-		-
+20	netdev_id	netdev_ip	netdev_name	netdev_flags	-
+25	-		-		-		-		-
+30	ifid		if_shortdesc	ifdescr		ifalias		ifdescr_short
+35	-		-		-		-		-
+40	ts(history)	is_current	is_5h
*/
	if ($lookup_type==3)
	{
		$histts_field="t.ts AS ts";
	} else
	{
		$histts_field="40 AS ts";
	}

	$cmd="CREATE VIEW v_tmp AS ".
		"SELECT ".
		" t.ip,".
		" ips.shortdesc AS ip_shortdesc,".
		" res_cache.hostname AS hostname ,".
		" 3 AS t3, 4 AS t4, 5 AS t5, 6 AS t6, 7 AS t7, 8 AS t8, 9 AS t9,".

		" t.mac,".
		" t.mac_shortdesc,".
		" t.mac_vendor,".
		" 13 AS t13, 14 AS t14, 15 AS t15, 16 AS t16, 17 AS t17, 18 AS t18, 19 AS t19,".

		" t.netdev_id,".
		" t.netdev_ip,".
		" t.netdev_name,".
		" t.netdev_flags,".
		" 24 AS t24, 25 AS t25, 26 AS t26, 27 AS t27, 28 AS t28, 29 AS t29,".

		" t.ifid,".
		" interfaces.shortdesc AS if_shortdesc,".
		" t.ifdescr,".
		" t.ifalias,".
		" short_ifdescr(t.ifdescr) AS ifdescr_short,".
		" 35 AS t35,36 AS t36,37 AS t37,38 AS t38,39 AS t39,".

		" $histts_field,".
		" (SELECT 1 WHERE va.ip IS NOT NULL) AS is_current,".
		" (SELECT 1 WHERE vc.ip IS NOT NULL) AS is_5h,".

		" 100 AS t100".

#		" FROM ( SELECT * FROM $tbl v WHERE NOT EXISTS (".
#			" SELECT * FROM monitor_filters m WHERE".
#				" ((v.ip>=m.ip_from AND v.ip<=m.ip_to) OR (v.ip<<=m.ip_mask) OR (m.ip_from IS NULL AND m.ip_mask IS NULL)) AND".
#				" ( v.mac=m.mac OR m.mac IS NULL) AND".
#				" ( v.ifid=m.ifid OR m.ifid IS NULL) AND".
#				" ( v.netdev_id=m.netdev_id OR m.netdev_id IS NULL )".
#				" LIMIT 1".
#		" ) ) t".
		" FROM $tbl t".
		" LEFT JOIN ips ON t.ip=ips.ip".
		" LEFT JOIN res_cache ON t.ip=res_cache.ip".
		" LEFT JOIN interfaces ON t.ifid=interfaces.id".
		" LEFT JOIN view_all va ON t.mac=va.mac AND t.ip=va.ip AND t.ifid=va.ifid".
		" LEFT JOIN view_current vc ON t.mac=vc.mac AND t.ip=vc.ip AND t.ifid=vc.ifid".
		"";

	if ($ip != "")
	{
		if ($where!="") $where.=" AND ";
		$where.="t.ip<<='$ip'";
	}

	if ($mac != "")
	{
		if ($where!="") $where.=" AND ";
		$where.="(t.mac::TEXT LIKE lower('$mac%'))";
	}

	if ($netdev_id != "" && $ifid=="")
	{
		if ($where!="") $where.=" AND ";
		$where.="t.netdev_id='$netdev_id'";
	}

	if ($ifid!="")
	{
		if ($where!="") $where.=" AND ";
		$where.="t.ifid='$ifid'";
	}

	if ($where!="")
	{
		$cmd.=" WHERE $where";
	}

//	echo "<BR>cmd=$cmd <BR>";
	pg_query($db,$cmd);

	$cmd="SELECT v.* FROM v_tmp v";
//	if ($extra!="")
//		$cmd.=" WHERE $extra";
	if ($extra!="")
		$cmd.=" $extra";

	switch($grouping)
	{
		case 1: $cmd.=" ORDER by ip,ts,ifid"; break;
		case 2: $cmd.=" ORDER by mac,ts,ip,ifid"; break;
		case 3: $cmd.=" ORDER by mac,ts"; break;
	}

//	echo "cmd=$cmd <BR>";

	$idx=0;
	$last="";

	$res=pg_query($db, $cmd);
	$num=pg_num_rows($res);
?>
<BR>
<TABLE class="list">
	<TR class="head">
		<TD COLSPAN="<? if ($lookup_type==3) echo "7"; else echo "5"; ?>"> <? echo $title; ?> </TD>
	</TR>
	<TR class="head">
		<TD> IP </TD>
		<TD> MAC </TD>
		<TD> Interface </TD>
		<TD> Last 5h </TD>
		<TD> Current </TD>
<?
	if ($lookup_type==3)
	{ ?>
		<TD> When </TD>
		<TD> Action </TD>
<?	} ?>
	</TR>

<?
	for ($n=0;$n<$num;$n++)
	{
		$r=pg_fetch_row($res,$n);
		switch($grouping)
		{
			case 1: $cur=$r[0]; break;
			case 2: $cur=$r[10]; break;
			case 3: $cur=$r[0]; break;
			default: $last="+"; $cur="-"; break;
		}
		if ($last!=$cur)
		{
			$last=$cur;
			$idx++;
		}
	?>
	<TR <?php tr_listclass($idx) ?>>
		<TD class="ip">
			<? disp_ip($r[0], $r[1], $r[2]); ?>
		</TD>
		<TD class="mac">
			<? disp_mac($r[10], $r[11], $r[12]); ?>
		</TD>
		<TD>
			<? disp_iface($r[22], $r[30], $r[34], $r[33], $r[31]); ?>
		</TD>
		<TD> <? dtnz($r[42]); ?> </TD>
		<TD> <? dtnz($r[41]); ?> </TD>
<?	if ($lookup_type==3)
	{ ?>
		<TD>
			<? $st=form_time($r[40]); echo $st; ?>
		</TD>
		<TD>
<?
		$hist="gl_ip=$r[0]&gl_mac=$r[10]&gl_ifid=$r[30]"; ?>
			<A HREF="<? echo "$linkme&gl_action=edit&$hist"; ?>">Edit</A>
<?		if ($r[41]!="1")
		{
			?>
			| <A HREF="<? echo "$linkme&gl_action=delete&$hist"; ?>">Delete</A>
<?		} else echo "&nbsp;"; ?>
		</TD>
<?	} ?>
	</TR>
<?	} ?>

</TABLE>
<BR>
<?
	pg_query($db,"ROLLBACK");
}
?>
