<?

/*
	Output a <SELECT> <OPTION> ... </SELECT> block
	for all netdevs

	$name is the name of the SELECT
	$current is the current netdev_id

	$type:
		& 0x04: Same as 0x04 of ifaces_opt()
		& 0x08: also list an entry called "none" with netdev_id==""
*/
function netdevs_opt($name, $current, $type=0x00)
{
	global $db;

	$cmd="SELECT id, name, ip FROM netdevs ORDER BY name";
	$res=pg_exec($db,$cmd);
	$num=pg_num_rows($res);
	?>
	<SELECT NAME="<? echo $name; ?>">
<?
	if ($type & 0x04)
	{?>
		<OPTION VALUE="" <? if ($current=="") echo "selected"; ?>>Any</OPTION>
<?	}
	if ($type & 0x08)
	{?>
		<OPTION VALUE="" <? if ($current=="") echo "selected"; ?>>None</OPTION>
<?	}
	for ($n=0;$n<$num;$n++)
	{
		$r=pg_fetch_row($res,$n); ?>
		<OPTION VALUE="<? echo $r[0]; ?>" <?
		if ($r[0]==$current) echo "selected";
		?> > <? echo "$r[1] - $r[2]"; ?> </OPTION>
<?	}?>
	</SELECT>
<?
}

/*
	Output a <SELECT> <OPTION> ... </SELECT> block
	for all interfaces of a netdev

	$netdev_id is the netdev_id
	$name is the name of the SELECT
	$current is the current ifid
	$type:
		& 0x01: also list netdev interfaces
		& 0x02: also list routed interfaces
		& 0x04: also list an entry called "any" with netdev_id==""
*/
function ifaces_opt($netdev_id, $name, $current, $type)
{
	global $db;

	$where="";

	$cmd="SELECT ifid, ifdescr, ifalias, if_shortdesc FROM view_interfaces_info".
		" WHERE netdev_id='$netdev_id'";

	if (!($type & 0x01))	// Don't list netdev interfaces
	{
		$where.=" AND ( has_netdev<>1 OR has_netdev IS NULL)";
	}

	if (!($type & 0x02))
	{
		$where.=" AND ( is_routed<>1 OR is_routed IS NULL)";
	}
	$cmd.=$where;
	$cmd.=" ORDER BY ifdescr";

	$res=pg_exec($db,$cmd);
	$num=pg_num_rows($res);
	?>
	<SELECT NAME="<? echo $name; ?>">
<?
	if ($type & 0x04)
	{?>
		<OPTION VALUE="" <? if ($current=="") echo "selected"; ?>>Any</OPTION>
<?	}
	for ($n=0;$n<$num;$n++)
	{
		$r=pg_fetch_row($res,$n); ?>
		<OPTION VALUE="<? echo $r[0]; ?>" <?
		if ($r[0]==$current) echo "selected";
		?> > <? echo "$r[1]";
		if ($r[2]!="") echo " ($r[2])";
		if ($r[3]!="") echo " ($r[3])";
		?> </OPTION>
<?	}?>
	</SELECT>
<?
}

/*
	Get list of all netdevs
*/
function get_netdevs()
{
	global $db, $data_netdevs;

	if ($data_netdevs["done"]!=1)
	{
		$cmd="SELECT id, ip, name, community, ts FROM netdevs";
		$res=pg_query($db, $cmd);
		$num=pg_num_rows($res);
		for ($n=0;$n<$num;$n++)
		{
			$r=pg_fetch_row($res,$n);
			$data_netdevs["$r[0]"]["id"]=$r[0];
			$data_netdevs["$r[0]"]["ip"]=$r[1];
			$data_netdevs["$r[0]"]["name"]=$r[2];
			$data_netdevs["$r[0]"]["community"]=$r[3];
			$data_netdevs["$r[0]"]["ts"]=$r[4];
		}

		$data_netdevs["done"]=1;
	}
}

/*
	Return the netdev name
*/
function get_netdev_name($id)
{
	global	$data_netdevs;

	get_netdevs();

	return($data_netdevs["$id"]["name"]);
}

/*
	Return the netdev ip
*/
function get_netdev_ip($id)
{
	global	$data_netdevs;

	get_netdevs();

	return($data_netdevs["$id"]["ip"]);
}

?>
