/*
  Copyright (c) 2002, 2003, 2004 Stefanos Harhalakis

  This file is part of commonlib.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: basedb.h,v 1.14 2004/05/27 17:01:55 v13 Exp $
*/

#ifndef _BASEDB_H
#define _BASEDB_H

#include "v/lconfig.h"

#include "libpq-fe.h"

#define INT4	s_32

#if (SIZEOF_UNSIGNED_LONG_LONG == 8)
#	define INT8	s_64
#else				// hope for the best
#	define INT8	s_32
#endif

#include "v/mem/longline.h"

class BASEDB
{
 private:
	PGconn		*pgdb;
	PGresult	*res;
 public:
	ExecStatusType	est;
	int		do_debug_stdout;	// Write debug messages to stdout
						// Don't use this for daemons since there exist no stdout
						// and fd #1/#2 may be used for other reasons. Will cause
						// ugly bugs.
 private:
	void		Finish		();
	void		Clear		();	// Call PQclear
 public:
			BASEDB		();
			~BASEDB		();
			BASEDB		(const BASEDB &db);
	int		Connect		(const char *path, const char *dbname, const char *user, const char *pass);
								// Return:	1: Connected
								//		0: Error
	void		Disconnect	();
	int		Exec		(char *cmd);	// Return: >0: OK, 0: Error(see est) or tuples==0, -1: Error (est unspecified)
	int		Commit		();		// Do a "COMMIT WORK". Return the result of Exec
	int		ExecParams	(char *cmd, int nparams, const char * const * params,
					const int *plengths, const int *pformats, int res_format);

	const char*	GetValue	(int tup_num, int field_num);
	const char*	GetValue	(int tup_num, const char *field_name);
	int		GetIsNull	(int tup_num, int field_num);	// Return 1 if the field is null, 0 if not, -1 on error
	int		GetIsNull	(int tup_num, const char *field_name);
	int		Tuples		();
	int		CmdTuples	();	// Return number of rows affected by insert, update or delete

	int		Begin		();	// Begin a transaction
	int		End		();	// End a transaction

	int		CallFunction	(const char *func);	// Call a function using select. Return the result of Exec
	int		DeclareCursor	(const char *cursor, const char *select);	// Declare cursor for select
	int		Fetch		(const char *cursor);	// fetch from cursor

	int		LockTable	(const char *tName);	// Lock table in ACCESS EXCLUSIVE MODE -- One reader/writer
	int		LockTableWrite	(const char *tName);	// Lock table in EXCLUSIVE MODE - One writer, many readers

	int		ReindexTable	(const char *tName);	// Reindex a table - Will begin/end a transaction

	INT8		GetSeqCurrent	(const char *sName);	// Get the current sequence number
	INT8		GetSeqNext	(const char *sName);	// Get the next sequence number - will increase the sequence

static	int		isTrue		(const char *value);	// Check if a value is true or false
static	int		isFalse		(const char *value);

	int		isTrue		(int tup_num, int field_num);	// Just like isTrue but check the result
	int		isFalse		(int tup_num, int field_num);	// 0 doesn't mean that the field is true/false. It may be null too

static	LONGLINE	EscapeString	(const char *str);	// Escape invalid characters
static	LONGLINE	EscapeBytea	(unsigned char *buf, size_t len);	// Escape a binary buffer
static	unsigned char	*UnescapeBytea	(unsigned char *buf, size_t *ret_len);	// Unescape a binary buffer
};

#endif

