/*
  Copyright (c) 2002,2003,2004 Stefanos Harhalakis

  This file is part of netinfo.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: conf.cc,v 1.6 2004/06/08 14:28:46 v13 Exp $
*/

#define _CONF_CC
#include "conf.h"

#include "v/misc/keytable2.cc"
#include "v/misc/nkeytable.cc"
#include "v/socket/ipaddr.h"

CFG			conf;
KEYTABLE<NETDEV>	netdevs;	// Key is the ip
KEYTABLE<STRLIST>	arp;
STRLIST			netdev_macs;
KEYTABLE<LONGLINE>	res_cache;
KEYTABLE<LONGLINE>	res_new;
KEYTABLE<SUBNET>	subnets;
CONFIG			config;

CFG_VAR vars[]={
//	name,			p,			dflt,		type,		flags,			opt
//	{"LOGFILE",		&conf.logfile,		NULL,		TYPE_LL,	NOINIT | REHASH,	NULL},
	{"DBNAME",		&conf.dbname,		NULL,		TYPE_LL,	NOINIT,			NULL},
	{"DBUSER",		&conf.dbuser,		NULL,		TYPE_LL,	NOINIT,			NULL},
	{"DBPASS",		&conf.dbpass,		NULL,		TYPE_LL,	NOINIT | ZERO,		NULL},
	{"RESOLVERS",		&conf.resolvers,	"1",		TYPE_U16,	0,			NULL},
	{NULL,			NULL,			NULL,		0,		0,			NULL}
};

SIMPLE_CONFIG	scfg(vars);

void	init_conf(const char *fn)
{
	if (fn!=NULL)
		conf.cfg_file=fn;

	scfg.Read(conf.cfg_file.p);
	
	netdev_macs.SetUnique(1);
}

IFACE	*NETDEV::get_internal(int internal)
{
	IFACE	*piface;
	u_32	key;
	
	ifaces.Rewind();
	
	while ((key=ifaces.Get_Next())!=NK_INVALID)
	{
		piface=ifaces[key];
		if (piface->internal==internal)
			return(piface);
	}
	
	return(NULL);
}

void	SUBNET::set(u_32 ip, u_32 mask)
{
	u_8	n;
	u_32	m;

	m=ntohl(mask);

	n=0;
	while ((m%2)==0 && n<32)	// find the rightest non-zero bit
	{
		n++;
		m>>=1;
	}

	this->mask=32-n;

	m=ntohl(ip);
	m&=~((1<<n)-1);	// clear host bits

	this->net=htonl(m);
}
