/*
  Copyright (c) 2002,2003,2004 Stefanos Harhalakis

  This file is part of netinfo.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: conf.h,v 1.8 2011-02-21 10:38:21 v13 Exp $
*/

#ifndef _CONF_H
#define _CONF_H

#include "v/mem/strlist.h"
#include "v/misc/simpleconfigfile.h"
#include "v/misc/keytable2.cc"
#include "v/misc/nkeytable.cc"

struct CFG
{
	LONGLINE	cfg_file;
	LONGLINE	dbname,dbuser,dbpass;
	u_16		resolvers;
};


class IFACE
{
 public:
 	int		internal;	// internal iface number
	int		ifindex;	// iface index
	LONGLINE	descr,alias;	// iface description and alias
	int		has_netdev;	// if there is a netdev on this interface
	int		is_routed;	// if this is a routed interface
	STRLIST		macs;		// macs on this interface
	STRLIST		arpmacs;	// macs on this interface learned from ARP cache
	STRLIST		internal_macs;	// Internal macs of the device
	int		iftype;		// IANA interface type number
	int		is_ignored;	// if this iface is ignored - set by the program - used for subnets
 private:
 	void	ddd		(IFACE &d)
		{ internal=d.internal; ifindex=d.ifindex; descr=d.descr; alias=d.alias;
		has_netdev=d.has_netdev; is_routed=d.is_routed; macs=d.macs; arpmacs=d.arpmacs;
		internal_macs=d.internal_macs; iftype=d.iftype; is_ignored=d.is_ignored; }
 public:
		IFACE		() { descr=""; alias=""; internal=ifindex=-1; has_netdev=is_routed=0;
				macs.SetUnique(1); iftype=-1; is_ignored=0; arpmacs.SetUnique(1); }
		IFACE		(IFACE &d) { ddd(d); }
	IFACE&	operator=	(IFACE &d) { ddd(d); return(*this); }
};

struct NETDEV
{
	int			id;
	LONGLINE		ip;
	LONGLINE		community;
	LONGLINE		name;
	NKEYTABLE<IFACE>	ifaces;		// key is ifindex
	KEYTABLE<int>		macs_tmp;	// temp for mac addresses. store mac type.
						// key is mac(string). value is type
	STRLIST			dev_macs;	// the internal mac addresses
	int			has_same_ifdescr;	// 1: This device has interfaces with the same ifdescr

	IFACE 	*get_internal	(int internal);

		NETDEV		() { dev_macs.SetUnique(1); has_same_ifdescr=0;}
};

class SUBNET
{
 public:
	u_32	net;		// network in NBO
	u_8	mask;		// number of bits (CIDR) (/N)
	IFACE	*piface;	// the interface this mask came from

 private:
 	void	ddd	(const SUBNET &d) { this->net=d.net; this->mask=d.mask; this->piface=d.piface; }
 public:
 		SUBNET		() { net=0; mask=32; this->piface=NULL; }
		SUBNET		(u_32 ip, u_32 mask=0xFFFFFFFF) { set(ip,mask); }

		SUBNET		(const SUBNET &d) { ddd(d); }
	void	operator=	(const SUBNET &d) { ddd(d); }
	int	operator==	(const SUBNET &d) { return (d.net==net && d.mask==mask); }

	void	set		(u_32 ip, u_32 mask);	// set the net/mask clearing host bits
							// ip,mask are IP format in NBO, (e.x. 255.255.255.250)

	void	set_mask	(u_32 mask) { set(net, mask); }
};

struct CONFIG
{
	time_t	last_maintenance;
	time_t	last_vacuumfull;
	int	discover_subnets;
	int	subnet_max_mask;
	int	filter_out_strange_ips;
	int	resolver_expire_time;
};

#ifndef _CONF_CC
extern CFG			conf;
extern KEYTABLE<NETDEV>		netdevs;	// key is IP
extern KEYTABLE<STRLIST>	arp;		// Global ARP - key is mac address (string)
						// Value is ip(string)
extern STRLIST			netdev_macs;	// internal MAC addresses of netdevs
extern KEYTABLE<LONGLINE>	res_cache;	// The res_cache table (key is the IP)
extern KEYTABLE<LONGLINE>	res_new;	// Newly resolved hostnames (key is the IP)
extern KEYTABLE<SUBNET>		subnets;	// Key is IP address (string)
extern CONFIG			config;
#endif

void	init_conf(const char *fn=NULL);

#endif

