/*
  Copyright (c) 2002,2003,2004 Stefanos Harhalakis

  This file is part of netinfo.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: db.h,v 1.6 2004/06/07 19:28:34 v13 Exp $
*/

#ifndef _DB_H
#define _DB_H

#include "basedb.h"
#include "v/lconfig.h"

#include "conf.h"

#include "v/mem/strlist.h"
#include "v/misc/keytable2.h"
#include "v/misc/nkeytable.h"

int	connect_db	();
void	close_db	();
int	get_netdevs	();	// Fill netdevs. Return # of netdevs.

void	get_res_cache	();	// Get the resolver cache

/*void	update_iface	(int netdev_id, const char *ifdescr,
			const char *ifalias, int ifindex, int has_netdev, int is_routed);*/
void	update_iface	(int netdev_id, IFACE *piface);

void	update_netdev	(int netdev_id);

void	update_macs	(int netdev_id, const char *ifdescr, STRLIST &macs,
			STRLIST &exclude_macs, int netdev_if=0);

void	update_ips	(KEYTABLE<STRLIST> &arp);

void	update_res_cache();

void	insert_subnets	();	// Insert discovered subnets

void	do_final	();	// Run final SQL commands
void	db_begin_update	();	// Begin a transaction and lock tables
void	db_end_update	();

void	do_connect_db	();	// in main.cc

void	get_config	();

#ifndef _DB_CC
extern BASEDB	db;
#endif

#endif

