/*
  Copyright (c) 2002,2003,2004 Stefanos Harhalakis

  This file is part of netinfo.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: main.cc,v 1.6 2004/06/07 19:28:34 v13 Exp $
*/

#include "config.h"
#include "conffile.h"
#include "conf.h"
#include "db.h"
#include "snmp.h"
#include "res.h"

void	do_connect_db()
{
	int	n;

	n=connect_db();
	if (!n)
	{
		fprintf(stderr,"Error connecting to databse\n");
		exit(1);
	}
}

void	init()
{
	conf.cfg_file=CONFFILE;
	init_conf();

	do_connect_db();

	get_config();		// fetch parameters
	get_netdevs();		// get devices
	get_res_cache();	// get existing resolver cache
}

void	end()
{
	close_db();

// Free some(?) memory
	netdevs.ClearTable();
	netdev_macs.Clear();
}

int main()
{
	init();
	snmp_doit();
	check_same_ifdescr();
	detect_netdevs();
	update_db();
	end();
	do_resolve(conf.resolvers);
}
