/*
  Copyright (c) 2002,2003,2004 Stefanos Harhalakis

  This file is part of netinfo.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: res.cc,v 1.2 2004/06/07 19:28:34 v13 Exp $
*/

#include "res.h"

#include "conf.h"
#include "db.h"

#include "v/dns/vresolv2.h"

#include <unistd.h>

void	do_resolve_one(int num, int total)
{
	STRLIST		tmp, *pslist;
	LONGLINE	*pll1, *pll2;
	LONGLINE	ll;
	VRESOLV		vres;
	int		idx=0;

	tmp.SetUnique(1);

	// First collect hostnames to be resolved
	arp.Rewind();
	while ((pll1=arp.Get_Next())!=NULL)
	{
		pslist=arp[*pll1];

		pslist->Rewind();
		while ((pll2=pslist->Get_Next())!=NULL)
		{
			if (res_cache[*pll2]==NULL)	// if not cached
				tmp.Add(pll2->p);
		}
	}

	vres.useTCP(1);
	tmp.Rewind();

	while ((pll1=tmp.Get_Next())!=NULL)
	{
		if (idx%total == num)
		{
			vres=*pll1;
			ll=vres;
			printf("Resolver[%d]: %s -> %s\n", num, pll1->p, ll.p);
			res_new.Add(pll1->p, ll);
		}
		idx++;
	}
}

/*
	num: The resolver number (1st -> 0)
	total: The total number of resolvers
*/
void	run_resolve(int num, int total)
{
	do_connect_db();

	do_resolve_one(num,total);

	update_res_cache();

	close_db();
	exit(0);
}

int	resolver=-1;

/*
	Spawn many resolvers
*/
void do_resolve(int resolvers)
{
	int	n;
	pid_t	pid;

	for (n=0;n<resolvers-1;n++)
	{
		pid=fork();
		if (pid==0)
		{
			run_resolve(n,resolvers);
		}
	}
	run_resolve(n,resolvers);
}
