CREATE TABLE netdevs (
	ip		INET
			PRIMARY KEY,

	name		VARCHAR(100)
			NOT NULL
			UNIQUE,

	community	VARCHAR(100)
			NOT NULL,

-- flags & 0x0f:
--	0x00	other
--	0x01	cisco
--	0x02	netsnmp
	flags		INTEGER
			DEFAULT 0
			NOT NULL
) WITHOUT OIDS;

CREATE TABLE netdev_data (
	netdev_name	VARCHAR(100)
			PRIMARY KEY
			REFERENCES netdevs(name)
				ON DELETE CASCADE
				ON UPDATE CASCADE,

	uptime		INT8
			DEFAULT 0,

	cpu1		INTEGER
			DEFAULT -1,

	cpu2		INTEGER
			DEFAULT -1,

	cpu3		INTEGER
			DEFAULT -1,

-- Free memory for cisco
-- Total memory for netsnmp
	memfree		INT8
			DEFAULT -1,

	memused		INT8
			DEFAULT 1
) WITHOUT OIDS;

CREATE TABLE interfaces (
	netdev_ip	INET
			NOT NULL
			REFERENCES netdevs(ip)
				ON DELETE CASCADE
				ON UPDATE CASCADE,

	ifindex		INTEGER,

	description	VARCHAR(64)
			NOT NULL,

	alias		VARCHAR(128),

	cur_in		INT8
			DEFAULT 0,

	cur_out		INT8
			DEFAULT 0,

	cur_ts		INT8
			DEFAULT 0,

	last_in		INT8
			DEFAULT 0,

	last_out	INT8
			DEFAULT 0,

	last_ts		INT8
			DEFAULT 0,

	speed		INT8
			DEFAULT 0,

	PRIMARY KEY(netdev_ip,description)
) WITHOUT OIDS;

--CREATE TABLE ifacct_old (
--	netdev_ip	INET,
--
--	ifdescr		VARCHAR(64),
--
--	ts		INTEGER,
--
--	actype		INTEGER,
--
--	bytes_in	INT8
--			DEFAULT 0,
--
--	bytes_out	INT8
--			DEFAULT 0,
--
--	FOREIGN KEY(netdev_ip,ifdescr)
--		REFERENCES interfaces(netdev_ip,description)
--			ON DELETE CASCADE
--			ON UPDATE CASCADE,
--
--	PRIMARY KEY(netdev_ip,ifdescr,ts)
--) WITHOUT OIDS; 

CREATE TABLE ifacct (
	netdev_ip	INET,

	ifdescr		VARCHAR(64),

	actype		INTEGER,

	ts		INTEGER,

-- bits per second
	bps_in		INTEGER,

	bps_out		INTEGER,

	count		INTEGER,

	FOREIGN KEY(netdev_ip,ifdescr)
		REFERENCES interfaces(netdev_ip,description)
			ON DELETE CASCADE
			ON UPDATE CASCADE,

	PRIMARY KEY(netdev_ip, ifdescr, actype, ts)
) WITHOUT OIDS;

-- actype:
--	0: last value
--	1: daily	-- /150 sec
--	2: weekly	-- /1050 sec
--	3: monthly	-- /4200 sec
--	4: yearly	-- /54750 sec
--	5: 6-months	-- /27450 sec

CREATE TABLE memacct (
	ts		INTEGER,

	actype		INTEGER,

	netdev_ip	INET
			REFERENCES netdevs(ip)
				ON DELETE CASCADE
				ON UPDATE CASCADE,

	mem		INTEGER,

	count		INTEGER
			DEFAULT 0,

	PRIMARY KEY(netdev_ip,actype,ts)
) WITHOUT OIDS;

CREATE TABLE cpuacct (
	ts		INTEGER,

	actype		INTEGER,

	netdev_ip	INET
			REFERENCES netdevs(ip)
				ON DELETE CASCADE
				ON UPDATE CASCADE,

	cpu		INTEGER,

	count		INTEGER
			DEFAULT 0,

	PRIMARY KEY(netdev_ip,actype,ts)
) WITHOUT OIDS;


CREATE TABLE config (
	name		VARCHAR(256)
			PRIMARY KEY,

	value		TEXT
) WITHOUT OIDS;

CREATE SEQUENCE seq_maps;
CREATE TABLE maps (
	id		INTEGER
			PRIMARY KEY
			NOT NULL
			DEFAULT NEXTVAL('seq_maps'),

	filename	VARCHAR(512),

	name		VARCHAR(100)
			UNIQUE,

	active		INTEGER
			DEFAULT 0
) WITHOUT OIDS;

CREATE TABLE map_config (
	mapid		INTEGER
			REFERENCES maps(id)
				ON UPDATE CASCADE
				ON DELETE CASCADE,

	name		VARCHAR(70),

	value		VARCHAR(256),

	PRIMARY KEY(mapid,name)
) WITHOUT OIDS;

CREATE TABLE points(
	mapid		INTEGER
			NOT NULL
			REFERENCES maps(id)
				ON DELETE CASCADE
				ON UPDATE CASCADE,
-- coords
	x		INTEGER,

	y		INTEGER,

	label		VARCHAR(256),

-- flags & 0x0f:
--		0x01	link	- txt=url	( label + click:url )
--		0x02	label	- txt=
--		0x03	map	- txt=mapid	( label + click:map )
--		0x04	data	- txt=
--		0x05	legend	- txt=
--		0x06	date	- txt=
--		0x07	area	- label=widthxheight
--
-- flags & 0x70:
--		0x10	popup - raw -- txt is the html
--		0x20	popup - img -- txt is the img url
--		0x30	popup - devinfo -- txt is the device name
--		0x40	popup - graph
-- flags & 0x700
--		0x000	map default
--		0x100	tiny
--		0x200	small
--		0x300	medium bold
--		0x400	large
--		0x500	huge
-- flags & 0x80:
--		0x00	border
--		0x80	no border
-- flags & 0x800:
--		0x000	background
--		0x800	no background
-- flags & 0x7000:
--		0x1000	click - url
--		0x2000	click - map
--		0x3000	click - graphs page
-- flags & 0x8000:
--		0x8000	click - menu
	flags		INTEGER
			DEFAULT 0,

	txt		VARCHAR(256),


	popup		VARCHAR(256),
-- dataflags & 0x03
--		0x01	incoming
--		0x02	outgoing
	dataflags	INTEGER
			DEFAULT 0,

	PRIMARY KEY(mapid, x, y)
) WITHOUT OIDS;

CREATE TABLE datasources(
	mapid		INTEGER,

	x		INTEGER,

	y		INTEGER,

	netdev_ip	INET,

	ifdescr		VARCHAR(100),

	FOREIGN KEY (mapid,x,y)
		REFERENCES points(mapid,x,y)
			ON DELETE CASCADE
			ON UPDATE CASCADE,

	FOREIGN KEY (netdev_ip, ifdescr)
		REFERENCES interfaces(netdev_ip, description)
			ON DELETE CASCADE
			ON UPDATE CASCADE,

	PRIMARY KEY (mapid, x, y, netdev_ip, ifdescr)
) WITHOUT OIDS;

