CREATE VIEW view_ifaces AS
	SELECT ip AS netdev_ip,
		name AS netdev_name,
		ifindex,
		description AS ifdescr,
		alias AS ifalias
		FROM netdevs n, interfaces i
		WHERE n.ip=i.netdev_ip;

CREATE VIEW view_points AS
	SELECT p.mapid , p.x, p.y,
		p.label, p.flags, p.txt, p.dataflags,
		d.netdev_ip, d.ifdescr,
		i.alias, 
		i.cur_in, i.cur_out, i.cur_ts,
		i.last_in, i.last_out, i.last_ts,
		i.speed
		FROM points p
		LEFT JOIN datasources d ON p.mapid=d.mapid AND p.x=d.x AND p.y=d.y
		LEFT JOIN interfaces i ON d.netdev_ip=i.netdev_ip AND d.ifdescr=i.description;

