<?php

/*
	Check if a color exists and allocate it if not.
*/
function get_imgcolor($im, $r, $g, $b)
{
	$c=imageColorExact($im,intval($r),intval($g),intval($b));
	if ($c==-1)
	{
		$c=imageColorAllocate($im, intval($r), intval($g), intval($b));
	}
	
	return($c);
}

function do_rect($im, $x1, $y1, $x2, $y2, $line_color, $fill_color, $border)
{
	imageFilledRectangle($im, $x1, $y1, $x2, $y2, $fill_color);
	if ($border=="yes")
		imageRectangle($im, $x1, $y1 ,$x2, $y2, $line_color);
}

function init_second_img()
{
	global	$helpim;
	
	$helpim=imageCreate(500,500);
}

init_second_img();

function do_transp_rect($im, $x1, $y1, $x2, $y2, $line_color, $fill_color, $transp, $border)
{
	global $helpim;

	$t1=imagecolorsforindex($im,$fill_color);
	$c1=imageColorExact($helpim,$t1['red'],$t1['green'],$t1['blue']);
	
	if ($c1==-1)
		$c1=imageColorAllocate($helpim, $t1['red'],$t1['green'],$t1['blue']);
		
	$dx=$x2-$x1;
	$dy=$y2-$y1;
	imageFilledRectangle($helpim, 0, 0, $dx, $dy, $c1);
	imageCopyMerge($im, $helpim, $x1, $y1, 0, 0, $dx+1, $dy+1, 100-$transp);
	if ($border==1)
		imageRectangle($im, $x1, $y1 , $x2, $y2, $line_color);
//	imageFilledRectangle($im, 0, 0, $dx, $dy, $fill_color);
//	imageRectangle($im, 0, 0 , $dx, $dy, $line_color);
//	imageCopyMerge($im, $helpim, $x1, $y1, 0, 0, $dx, $dy, 50);
//	imageRectangle($im, 1, 1 , 10, 10, $line_color);
}

/*
	Allign:	
		00,01,02,10,11,12,20,21,22:
		
		xy:	x: 0,1,2: left,center, right
			y: 0,1,2: top, center, bottom
	box:
		0: No box - no background
		1: background
		2: box
		3: Box + background
*/
function do_text($im, $x, $y, $text, $size, $color, $box, $allign, $fill_color, $transp=0)
{
	global $c_white, $c_black;

	$x_size=strlen($text) * imageFontWidth($size);
	$y_size=imageFontHeight($size);
	if ($box>0)
	{
		if ($size>=3)
		{
			$x_size+=6;
			$y_size+=2;
			$x_advance=4;
			$y_advance=1;
		} else
		{
			$x_size+=4;
			$y_size+=0;
			$x_advance=3;
			$y_advance=0;
		}
	}
	
	$al=intval($allign/10);
	switch($al)
	{
		case 2: $true_x=$x-$x_size;break;
		case 1: $true_x=$x-intval($x_size/2);break;
		case 0:
		default:
			$true_x=$x;break;
	}
	$al=$allign%10;
	switch($al)
	{
		case 2: $true_y=$y-$y_size; break;
		case 1: $true_y=$y-intval($y_size/2); break;
		case 0:
		default:
			$true_y=$y; break;
	}
	
	if ($box==0)
	{
		ImageString($im, $size, $true_x, $true_y, $text, $color);
//		do_transp_rect($im, $true_x, $true_y, $true_x + $x_size, $true_y + $y_size, $c_black, $c_white, $transp);
//		ImageString($im, $size, $true_x, $true_y, $text, $color);
	} else
	{
		if ($box==3) // box+bg
//			do_transp_rect($im, $true_x, $true_y, $true_x + $x_size, $true_y + $y_size, $c_black, $fill_color, $transp, 1);
			do_transp_rect($im, $true_x, $true_y, $true_x + $x_size, $true_y + $y_size, $color, $fill_color, $transp, 1);
		else if ($box==2) // box
			do_transp_rect($im, $true_x, $true_y, $true_x + $x_size, $true_y + $y_size, $color, $fill_color, 100, 1);
		else if ($box==1) // bg
			do_transp_rect($im, $true_x, $true_y, $true_x + $x_size, $true_y + $y_size, $color, $fill_color, $transp, 0);
		ImageString($im, $size, $true_x+$x_advance, $true_y+$y_advance, $text, $color);
	}
}

/*function do_text($im, $x, $y, $text, $size, $color, $box, $allign)
{
	do_text($im, $x, $y, $text, $size, $color, $box, $allign, 0);
}*/

/*
	Return the coords of the 2 corners of a:
	center alligned box that contains the text $text with fontsize $size
*/
function get_text_rect($x, $y, $text, $size, &$x1, &$y1, &$x2, &$y2)
{
	if ($size>=3)
	{
		$x_size=6;
		$y_size=2;
	} else
	{
		$x_size=4;
		$y_size=0;
	}
	
	$x_size+=strlen($text) * imageFontWidth($size);
	$y_size+=imageFontHeight($size);
	
	$x1=$x-intval($x_size/2);
	$y1=$y-intval($y_size/2);
	$x2=$x1+$x_size;
	$y2=$y1+$y_size;
}

function rescale1($perc)
{
	if ($perc<0.1)
	{
		$ret=$perc*5;
	} else
	{
		$ret=0.5+(0.5*($perc-0.1)/0.9);
	}
	
	return($ret);
}

function unrescale1($perc)
{
	if ($perc<0.5)
	{
		$ret=$perc/5;
	} else
	{
		$ret=(($perc-0.5)*0.9/0.5)+0.1;
	}
	
	return($ret);
}

/*
	custom rescaling
*/
function rescale2($value,$max)
{
	global $mapcfg_rescale_bw, $kilo;
	
	$l=$mapcfg_rescale_bw*($kilo/8);
	
	if ($value<=$l)
	{
		$ret=0.5*$value/$l;
	} else
	{
		$ret=0.5+(0.5*(($value-$l)/($max-$l)));
	}
	
	return($ret);
}

/*
	Get the RGB values using color scheme #1 (Blue->Green->Red);
*/
function get_color_scheme1($prc, &$r,&$g,&$b)
{
	$perc=$prc;
	
	$r=0;$g=0;$b=0;
	
	if ($perc>1)
		$perc=1;

	if ($perc<0.25)
	{
		$b=255;
		$g=180+75*($perc/0.25);
	} else if ($perc<0.5)
	{
		$g=255;
		$b=255-255*(($perc-0.25)/0.25);
	} else if ($perc<0.75)
	{
		$g=255;
		$r=255*(($perc-0.5)/0.25);
	} else 
	{
		$r=255;
		$g=255-(255*(($perc-0.75)/0.25));
	}

	if ($r>255) $r=255;
	if ($g>255) $g=255;
	if ($b>255) $b=255;
	if ($r<0) $r=0;
	if ($g<0) $g=0;
	if ($b<0) $b=0;
}

/*
	Get the RGB values using color scheme #4 (Blue->Green->Yellow(50%)->Red);
*/
function get_color_scheme4($prc, &$r,&$g,&$b)
{
	$perc=$prc;
	
	$r=0;$g=0;$b=0;
	
	if ($perc>1)
		$perc=1;

	if ($perc<0.15)
	{
		$b=255;
		$g=180+75*($perc/0.15);
	} else if ($perc<0.30)
	{
		$g=255;
		$b=255-255*(($perc-0.15)/0.15);
	} else if ($perc<0.45)
	{
		$g=255;
		$r=255*(($perc-0.30)/0.15);
	} else 
	{
		$r=255;
		$g=255-(255*(($perc-0.45)/0.55));
	}

	if ($r>255) $r=255;
	if ($g>255) $g=255;
	if ($b>255) $b=255;
	if ($r<0) $r=0;
	if ($g<0) $g=0;
	if ($b<0) $b=0;
}


/*
	Get the RGB values using color scheme #2 (Green->Blue->Red);
*/
function get_color_scheme2($prc, &$r,&$g,&$b)
{
	$perc=$prc;
	
	$r=0;$g=0;$b=0;
	
	if ($perc>1)
		$perc=1;

	if ($perc<0.33)
	{
		$g=255;
		$b=255*($perc/0.33);
	} else if ($perc<0.5)
	{
		$b=255;
		$g=255-75*(($perc-0.33)/0.17);
	} else if ($perc<0.75)
	{
		$b=255;
		$r=255*(($perc-0.5)/0.25);
//		$g=180-(180*(($perc-0.5)/0.25));
		$g=180;
	} else 
	{
		$r=255;
		$b=255-(255*(($perc-0.75)/0.25));
		$g=180-(180*(($perc-0.75)/0.25));
	}

	if ($r>255) $r=255;
	if ($g>255) $g=255;
	if ($b>255) $b=255;
	if ($r<0) $r=0;
	if ($g<0) $g=0;
	if ($b<0) $b=0;
}

/*
	Get the RGB values using color scheme #3 (Green->Yellow->Red);
*/
function get_color_scheme3($prc, &$r,&$g,&$b)
{
	$perc=$prc;
	
	$r=0;$g=0;$b=0;
	
	if ($perc>1)
		$perc=1;

	if ($perc<0.4)
	{
		$g=255;
		$r=220*($perc/0.4);
	} else if ($perc<0.50)
	{
		$g=255;
		$r=220+35*(($perc-0.4)/0.1);
	} else if ($perc<0.75)
	{
		$r=255;
		$g=255-75*(($perc-0.5)/0.25);
	} else 
	{
		$g=180-(180*(($perc-0.75)/0.25));
		$r=255;
	}

	if ($r>255) $r=255;
	if ($g>255) $g=255;
	if ($b>255) $b=255;
	if ($r<0) $r=0;
	if ($g<0) $g=0;
	if ($b<0) $b=0;
}

/*
	Allocate and return a color.
	Rescale if needed
*/
function get_color($im, $value, $max, $scale)
{
	global $mapcfg_colorscheme;
	
	if ($value==0)
	{
		$r=0xa0;
		$g=0xa0;
		$b=0xa0;
	} else
	{
		$perc=$value/$max;

		if (("$scale"=="yes") || ("$scale"=="1"))
		{
			$perc=rescale1($perc);
		} else if ("$scale"=="custom")
		{
			$perc=rescale2($value,$max);
		}
		switch ($mapcfg_colorscheme)
		{
			case 2: get_color_scheme2($perc,$r,$g,$b); break;
			case 3: get_color_scheme3($perc,$r,$g,$b); break;
			case 4: get_color_scheme4($perc,$r,$g,$b); break;
			case 1:
			default:
				get_color_scheme1($perc,$r,$g,$b);
				break;
		}
	
	}
	
	$c=get_imgcolor($im, intval($r), intval($g), intval($b));
	
	return($c);
}


function draw_legend_old($im, $x, $y, $height)
{
	global $c_white, $c_black, $rescale;
	
	$fontsize=2;
	
	$marg_l=3;	// margin left
	$marg_r=3;	// margin right
	$marg_t=intval(2+(0.5 * imagefontheight($fontsize)) +0.5);	// margin top (add half fontheight)
	$marg_b=intval(2+(0.5 * imagefontheight($fontsize)) +0.5);	// margin bottom
	$txt_l=4*imagefontwidth($fontsize);	// space for text at the left (100% == 4 chars)
	$ln_l=5;	// line length for small lines at the left
	
	$marg_l_t=$marg_l+$txt_l+$ln_l+1;	// total margin left
	
	$l_width=10;	// line width
	
	$width=$marg_l_t+$l_width+$marg_r+1;
	
	imageFilledRectangle($im, $x, $y, $x+$width, $y+$height ,$c_white);
	imageRectangle($im, $x, $y, $x+$width, $y+$height ,$c_black);

	$sx1=$x+$marg_l_t;
	$sx2=$sx1+$l_width;
	$sy1=$y+$marg_t;
	$sy2=$y+$height-$marg_b;
	
	$l_height=$height-($marg_t+$marg_b);
	
	for ($n=0;$n<$l_height;$n++)
	{
		$c=get_color($im, $n, $l_height, 0);
		imageLine($im, $sx1+1, $sy2-$n, $sx2-1, $sy2-$n, $c);
	}
	imageRectangle($im, $sx1, $sy1, $sx2, $sy2, $c_black);
	for ($n=0;$n<5;$n++)
	{
		$perc=$n*0.25;
		$y=$sy2-($l_height*$perc);
		if ($rescale=="yes")
			$perc=unrescale1($perc);
		imageLine($im, $sx1-$ln_l, $y, $sx1-1, $y, $c_black);
		$disp=intval($perc*100);
		do_text($im, $sx1-5, $y, "$disp%", $fontsize, $c_black,  0, 21, $c_white,0);
	}
}

function draw_legend($im, $x, $y, $height, $box=1, $bg=1)
{
	global $c_white, $c_black, $mapcfg_rescale, $mapcfg_rescale_bw;
	global $kilo;
	
	$fontsize=2;
	
	if ($mapcfg_rescale=="custom")
		$txt_l_size=strlen("$mapcfg_rescale_bw")+1;
	else
		$txt_l_size=4;
	
	$marg_l=3;	// margin left
	$marg_r=3;	// margin right
	$marg_t=intval(2+(0.5 * imagefontheight($fontsize)) +0.5);	// margin top (add half fontheight)
	$marg_b=intval(2+(0.5 * imagefontheight($fontsize)) +0.5);	// margin bottom
	$txt_l=$txt_l_size*imagefontwidth($fontsize);	// space for text at the left (100% == 4 chars)
	$ln_l=5;	// line length for small lines at the left
	
	$marg_l_t=$marg_l+$txt_l+$ln_l+1;	// total margin left
	
	$l_width=10;	// line width
	
	$width=$marg_l_t+$l_width+$marg_r+1;

	if ($bg==1)
		imageFilledRectangle($im, $x, $y, $x+$width, $y+$height ,$c_white);
	if ($box==1)
		imageRectangle($im, $x, $y, $x+$width, $y+$height ,$c_black);

	$sx1=$x+$marg_l_t;
	$sx2=$sx1+$l_width;
	$sy1=$y+$marg_t;
	$sy2=$y+$height-$marg_b;
	
	$l_height=$height-($marg_t+$marg_b);
	
	for ($n=0;$n<$l_height;$n++)
	{
		$c=get_color($im, $n, $l_height, 0);
		imageLine($im, $sx1+1, $sy2-$n, $sx2-1, $sy2-$n, $c);
	}
	imageRectangle($im, $sx1, $sy1, $sx2, $sy2, $c_black);
	if ($mapcfg_rescale=="custom")
	{
		imageLine($im, $sx1-$ln_l, $sy2, $sx1-1, $sy2, $c_black);
		do_text($im, $sx1-5, $sy2, "0k", $fontsize, $c_black, 0, 21, $c_white,0);

//		imageLine($im, $sx1-$ln_l, $sy2-($l_height*0.25), $sx1-1, $sy2-($l_height*0.25), $c_black);
//		$disp=intval($mapcfg_rescale_bw/2);
//		do_text($im, $sx1-5, $sy2-($l_height*0.25), "${disp}k", $fontsize, $c_black, 0, 21);

		$l=$mapcfg_rescale_bw;
		$unit="K";
		if ($l>=$kilo)
		{
			$l=sprintf("%1.2f",$l/$kilo);
			$unit="M";
		}
		
		imageLine($im, $sx1-$ln_l, $sy2-($l_height*0.5), $sx1-1, $sy2-($l_height*0.5), $c_black);
		do_text($im, $sx1-5, $sy2-($l_height*0.5), "$l$unit", $fontsize, $c_black, 0, 21, $c_white);
		
//		imageLine($im, $sx1-$ln_l, $sy2-($l_height*0.75), $sx1-1, $sy2-($l_height*0.75), $c_black);
//		do_text($im, $sx1-5, $sy2-($l_height*0.75), "${mapcfg_rescale_bw}k", $fontsize, $c_black, 0, 21);
		
		imageLine($im, $sx1-$ln_l, $sy2-$l_height, $sx1-1, $sy2-$l_height, $c_black);
		do_text($im, $sx1-5, $sy2-$l_height, "100%", $fontsize, $c_black, 0, 21, $c_white);
	} else
	{
		for ($n=0;$n<5;$n++)
		{
			$perc=$n*0.25;
			$y=$sy2-($l_height*$perc);
			if ($mapcfg_rescale=="yes")
				$perc=unrescale1($perc);
			imageLine($im, $sx1-$ln_l, $y, $sx1-1, $y, $c_black);
			$disp=intval($perc*100);
			do_text($im, $sx1-5, $y, "$disp%", $fontsize, $c_black, 0, 21, $c_white);
		}
	}
}

/*	
	$val/10: percentage
		0: no
		1: yes
	$val%10: kbps
		0: no
		1: X kbps
		2: X k
		3: X
		
	default: 11
*/
function get_label_text($perc,$kb)
{
	global $mapcfg_label;
	
	switch ($mapcfg_label)
	{
		case 12: $ret="$perc% ($kb k)"; break;
		case 13: $ret="$perc% ($kb)"; break;
		case 10: $ret="$perc%"; break;
		case 1: $ret="$kb kbps"; break;
		case 2: $ret="$kb k"; break;
		case 3: $ret="$kb"; break;
		case 11:
		default:
			$ret="$perc% ($kb kbps)"; break;
	}
	
	return($ret);
}

?>
