<?php

/*
	Calculate values.
	
	Set table $dt_f
	
	$dt_f[$x][$y][0] -> rate;
	$dt_f[$x][$y][1] -> max bandwidth;
	
	values are in bytes per second
*/

function calc_data($mapid)
{
	global $db;
//	global $rescale;
	global $dt_f;
	
	/* First get the data */	
/*
	0	1	2	3	4
	x	y	label	flags	txt
+5	dflags	ifdescr	alias	cur_in	cur_out
+10	cur_ts	l_in	l_out	l_ts	speed
*/
	
	$cmd="SELECT x,y,label,flags,txt,dataflags, ".
		"ifdescr, alias, cur_in, cur_out, cur_ts, ".
		"last_in, last_out, last_ts ,speed FROM view_points ".
		"WHERE mapid='$mapid' ORDER BY x,y";

	$res=pg_exec($db,$cmd);
	$num=pg_num_rows($res);

	for ($n=0;$n<$num;$n++)
	{
		$r=pg_fetch_row($res,$n);
		$x=$r[0]; $y=$r[1]; $label=$r[2]; $flags=$r[3]; $txt=$r[4];
		$dflags=$r[5]; $ifdescr=$r[6]; $ifalias=$r[7]; $cur_in=$r[8]; $cur_out=$r[9];
		$cur_ts=$r[10]; $last_in=$r[11]; $last_out=$r[12]; $last_ts=$r[13]; $speed=$r[14];
		
		$fl=$flags & 0x07;
		if ($fl==0x04 && ($speed>0))	// For each data point
		{
			$max=intval($speed/8);
			
			/*--- calculate values ---*/
			
			$d_ts=$cur_ts-$last_ts;
			$d_in=$cur_in-$last_in;
			$d_out=$cur_out-$last_out;
			if ($d_ts==0 || $speed==0)
			{
				$d_in=0;
				$d_out=0;
				$d_ts=1;
			}
		
			if ($cur_in<$last_in)	// overflow or reset
			{
				$cur_in+=1073741824*4;
				$d_in=$cur_in-$last_in;
			}
			if ($d_in > $d_ts*$speed)	// imposible
			{
				$d_in=0;
				$d_ts=1;
			}               
			if ($cur_out<$last_out)
			{
				$cur_out+=1073741824*4;
				$d_out=$cur_out-$last_out;
			}
			if ($d_out > $d_out*$speed)	// imposible
			{
				$d_out=0;
				$d_ts=1;
			}
			
/*			echo "d_ts=$d_ts <BR>\n";
			echo "d_in=$d_in <BR>\n";
			echo "d_out=$d_out <BR>\n";*/
			$rate_in=$d_in/$d_ts;
			$rate_out=$d_out/$d_ts;
			
			$dt[$x][$y][0]+=1;
			$dt[$x][$y][1]+=$rate_in;
			$dt[$x][$y][2]+=$rate_out;
			$dt[$x][$y][3]+=$max;
			/*------------------------*/
		}
	
	}
	/* There exist a small overhead for dupplicate point entries */
	/* but it is prefered from another database query */
	for ($n=0;$n<$num;$n++)
	{
		$r=pg_fetch_row($res,$n);
		$x=$r[0]; $y=$r[1]; $label=$r[2]; $flags=$r[3]; $txt=$r[4];
		$dflags=$r[5];
		
		$rate_in=$dt[$x][$y][1];	// saved values
		$rate_out=$dt[$x][$y][2];
		$max=$dt[$x][$y][3];

		$rate=0;
		$max2=0;

		if (($dflags & 0x01) == 0x01) { $rate+=$rate_in; $max2+=$max; }
		if (($dflags & 0x02) == 0x02) { $rate+=$rate_out; $max2+=$max; }

		$dt_f[$x][$y][0]=$rate;	// save the final output
		$dt_f[$x][$y][1]=$max2;
	}
}

function get_label($rate, $max)
{
	global $kilo;

	if ($max>0)
	{
		$perc=intval(100*$rate/$max);
		$kb=intval($rate*8/$kilo);

		$ret=get_label_text($perc,$kb);
	} else $ret="ERR2";
	
	return($ret);
}
?>
