/****************************************/
/*					*/
/****************************************/
/* Start      : 13/10/2002		*/
/* Version    : 1.00			*/
/* Last Update: 13/10/2002		*/
/****************************************/

/*
  Copyright (c) 2002,2003 Stefanos Harhalakis

  This file is part of commonlib.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "basedb.h"

#include "v/mem/longline.h"

/*
	Generic db functions
*/

BASEDB::BASEDB()
{
	pgdb=NULL;
}


BASEDB::~BASEDB()
{
}

BASEDB::BASEDB(const BASEDB &db)
{
	this->pgdb=db.pgdb;
	this->est=db.est;
}

int	BASEDB::Connect(const char *path, const char *dbname, const char *user, const char *pass)
{
	LONGLINE	ll;
	int		ret=1;

	ll="";
	if ((dbname!=NULL) && (dbname[0]!=0))
	{
		ll+="dbname=";
		ll+=dbname;
		ll+=" ";
	}
	if ((user!=NULL) && (user[0]!=0))
	{
		ll+="user=";
		ll+=user;
		ll+=" ";
	}
	if (pass!=NULL)
	{
		ll+="password=";
		ll+=pass;
		ll+=" ";
	}
	ll--;
	if (pgdb!=NULL) delete(pgdb);
	pgdb=new PgDatabase(ll.p);
	if ((pgdb!=NULL) && (pgdb->Status()==CONNECTION_BAD))
	{
		ret=0;
	}

	return(ret);
}

int	BASEDB::Exec(char *cmd)
{
	int	ret;

	printf("Exec: %s\n",cmd);
	if (pgdb==NULL)
	{
		ret=-1;
  	} else
	{
		est=pgdb->Exec(cmd);

		if (est==PGRES_COMMAND_OK) ret=1;
		else if (est==PGRES_TUPLES_OK) ret=pgdb->Tuples();
		else ret=0;
	}
	if (ret<=0)
		printf("ret=%d  Error=%s\n",ret,pgdb->ErrorMessage());
	fflush(stdout);

	return(ret);
}

void	BASEDB::Disconnect()
{
	if (pgdb!=NULL)
	{
		delete(pgdb);
		pgdb=NULL;
	}
}

int	BASEDB::Commit()
{
	return(Exec("COMMIT WORK"));
}

const char *BASEDB::GetValue(int tup_num, int field_num)
{
	const char	*p;

	p=pgdb->GetValue(tup_num, field_num);

	return(p);
}

int	BASEDB::Tuples()
{
	int	ret;

	ret=pgdb->Tuples();

	return(ret);
}

int	BASEDB::CmdTuples()
{
	int     ret;

	ret=pgdb->CmdTuples();

	return(ret);
}

int	BASEDB::CallFunction(const char *func)
{
	LONGLINE	ll;
	int		ret;

	ll="SELECT ";
	ll+=func;
	ll+="()";

	ret=Exec(ll.p);

	return(ret);
}

int	BASEDB::DeclareCursor(const char *cursor, const char *select)
{
	LONGLINE	ll;
	int		ret;

	ll="DECLARE ";
	ll+=cursor;
	ll+=" CURSOR FOR ";
	ll+=select;

	ret=Exec(ll.p);

	return(ret);
}

int	BASEDB::Begin()
{
	LONGLINE	ll;
	int		ret;

	ll="BEGIN";

	ret=Exec(ll.p);

	return(ret);
}

int	BASEDB::End()
{
	LONGLINE	ll;
	int		ret;

	ll="END";

	ret=Exec(ll.p);

	return(ret);
}

int	BASEDB::Fetch(const char *cursor)
{
	LONGLINE	ll;
	int		ret;

	ll="FETCH FROM ";
	ll+=cursor;

	ret=Exec(ll.p);

	return(ret);
}

int	BASEDB::LockTable(const char *tName)
{
	LONGLINE	ll;
	int		ret;

	ll="LOCK TABLE ";
	ll+=tName;
	ll+=" IN ACCESS EXCLUSIVE MODE";

	ret=Exec(ll.p);
	
	return(ret);
}

int	BASEDB::LockTableWrite(const char *tName)
{
	LONGLINE	ll;
	int		ret;

	ll="LOCK TABLE ";
	ll+=tName;
	ll+=" IN EXCLUSIVE MODE";

	ret=Exec(ll.p);
	
	return(ret);
}

int	BASEDB::ReindexTable(const char *tName)
{
	LONGLINE	ll;
	int		ret;

	ll="REINDEX TABLE ";
	ll+=tName;
	ll+=" FORCE";

	Begin();
	LockTableWrite(tName);

	ret=Exec(ll.p);

	End();

	return(ret);
}

